
#declare Is_Inc_File = true

#if ( Is_Inc_File = false )

// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: Chris Hernandez


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"


// -------------------------------- light sources ---------------
light_source { <50, 0, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, 50, 0> color rgb <0.6, 0.6, 0.6> }
light_source { <0, -50, -50> color rgb <0.6, 0.6, 0.6> }
light_source { <-50, 0, -50> color rgb <0.6, 0.6, 0.6> }


background { color rgb <0.6, 0.6, 0.6> }


#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.35
	   roughness 0.05
	   //reflection 0.05
	}
}

#declare RedT = texture { pigment { color rgb <1,0,0> } }


// ------------------------------------ Camera -------------------
camera {
  location  <0.0 , 2.0 ,-5.0>
  look_at   <0.0 , 0.0 , 0.0>
}

#end



// ============================================================
// *  Textures  *
// ============================================================

#declare Doc_Flesh = texture {
   pigment { color red 0.96 green 0.80 blue 0.69 }
   finish { ambient 0.35 diffuse 0.35 crand 0.02 }
   normal { wrinkles 0.15 turbulence 0.25 scale 0.01 }
}

//#default { texture { Doc_Flesh } }

#declare Doc_EyeBrowTexture = texture {
      pigment {
         bozo
         ramp_wave
         color_map {
            [ 0.00 color rgbt <0.85, 0.5, 0.1, 0.0> ]
            [ 0.60 color rgbt <0.80, 0.5, 0.1, 0.0> ]
            [ 0.60 color rgbt <0.85, 0.5, 0.1, 1.0> ]
            [ 1.00 color rgbt <0.90, 0.5, 0.1, 1.0> ]
         }
      }
      finish  { ambient 0.2 diffuse 0.2 crand 0.30 }
      scale <30, 1, 1>
      scale 0.015
   }

#declare Doc_EyeBallTexture =  texture {
      pigment {
         bozo
         color_map {
            [ 0.00 color rgb 0.85 ]
            [ 0.20 color rgb 0.82 ]
            [ 0.40 color rgb 0.90 ]
            [ 0.44 color rgb <0.90, 0.8, 0.8> ]
            [ 0.48 color rgb 0.90 ]
            [ 0.80 color rgb 0.90 ]
            [ 0.83 color rgb <0.85, 0.7, 0.7> ]
            [ 0.85 color rgb 0.90 ]
            [ 1.00 color rgb 0.87 ]
         }
         turbulence 0.9
      }
      finish {
         ambient 0.60
         diffuse 0.30
         specular 0.95 roughness 0.001
         //phong 0.65 phong_size 225
      }
      rotate y*90
      scale 0.25
   }


#declare Doc_IrisTexture = texture {
   pigment {
      agate
      color_map {

         [0.0, 0.3 color rgb <0.90, 0.5, 0.1>*0.80
                   color rgb <0.90, 0.5, 0.1>*0.70]
         [0.3, 1.0 color rgb <0.90, 0.5, 0.1>*0.75
                   color rgb <0.90, 0.5, 0.1>*0.80]
         /*
         [0.0, 0.3 color rgb <0.6, 0.6, 1.0>
                   color rgb <0.6, 0.6, 0.9>]
         [0.3, 1.0 color rgb <0.6, 0.6, 0.9>
                   color rgb <0.6, 0.6, 0.8>]
         */
      }
      scale 0.1
   }
   finish { ambient 0.20 diffuse 0.3 specular 0.8 roughness 0.005 phong 0.4 phong_size 200 }
}

// ============================================================
// *  Base Shapes  *
// ============================================================

#declare Doc_EyelidBase = object {
   union {
      difference {
         sphere{ 0, 1 }
         plane { y, 0 }
         sphere{ 0, 0.99 }
         plane { -z, 0 }
      }
      difference {
         torus { 1, 0.02 }
         plane { -z, 0 }
      }
   }
}

#declare Doc_EyeBottomBase = object {
   union {
      difference {
         sphere{ 0, 1 }
         plane { -y, 0 }
         sphere{ 0, 0.99 }
         plane { -z, 0 }
      }
      difference {
         torus { 1, 0.02 }
         plane { -z, 0 }
      }
   }
}


#declare Doc_EyeBallBase = object {
   difference {
      sphere{ 0, 1 }
      //plane { y, 0 }
      sphere{ 0, 0.99 }
      plane { -z, 0 }
   }
}

#declare Doc_Iris = object {
   union {
      sphere { 0*z, 0.265 }
      cylinder { 0*z, -0.267*z, 0.075 texture { pigment { color rgb 0 } } }
   }
   scale <1, 1, 0.5>
   texture { Doc_IrisTexture }
}



// ============================================================
// *  Left Eye  *
// ============================================================


#declare Doc_EyelidLeft = object {
   union {
      difference {
         object { Doc_EyelidBase }
         plane { -x, 0 }
         scale <0.9, 0.9, 1>
      }

      difference {
         object { Doc_EyelidBase }
         plane { x, 0 }
         scale <1.2, 0.9, 1>
      }
   }
   texture { Doc_Flesh }
}

#declare Doc_EyeBottomLeft = object {
   union {
      difference {
         object { Doc_EyeBottomBase }
         plane { -x, 0 }
         scale <0.9, 0.9, 1>
      }

      difference {
         object { Doc_EyeBottomBase }
         plane { x, 0 }
         scale <1.2, 0.9, 1>
      }
   }
   texture { Doc_Flesh }
}

#declare Doc_EyeBallLeft = object {
   union {
      difference {
         object { Doc_EyeBallBase }
         plane { -x, 0 }
         scale <0.9, 0.9, 1>
      }

      difference {
         object { Doc_EyeBallBase }
         plane { x, 0 }
         scale <1.2, 0.9, 1>
      }
   }
   texture { Doc_EyeBallTexture }
}

#declare Doc_EyeBrowLeft = object {
   union {
      difference {
         torus { 1, 0.165 rotate -x*90 }
         plane { y, 0 rotate -z*15 }
         plane { -x, 0 }
         scale <0.9, 0.5, 1.2>
      }
      difference {
         torus { 1, 0.165 rotate -x*90 }
         plane { y, 0 rotate z*15 }
         plane { x, 0 }
         scale <1.35, 0.5, 1.2>
      }
   }
   scale 1.15
   rotate -y*22 //18 //15 //10 //05
   rotate -x*30 //15
   rotate  z*5
   texture { Doc_EyeBrowTexture rotate z*45 }
}

#declare Doc_EyeLeft = object {
   union {
      object { Doc_EyelidLeft rotate x*22.5 }
      object { Doc_EyeBallLeft }
      object { Doc_EyeBottomLeft rotate -x*15 }
      object { Doc_Iris translate -z*1 rotate x*0 rotate y*0 }
      object { Doc_EyeBrowLeft translate <-0.15, 0.65, 0.90>}
   }
}


// ============================================================
// *  Right Eye  *
// ============================================================


#declare Doc_EyelidRight = object {
   union {
      difference {
         object { Doc_EyelidBase }
         plane { x, 0 }
         scale <0.9, 0.9, 1>
      }
      difference {
         object { Doc_EyelidBase }
         plane { -x, 0 }
         scale <1.2, 0.9, 1>
      }
   }
   texture { Doc_Flesh }
}

#declare Doc_EyeBottomRight = object {
   union {
      difference {
         object { Doc_EyeBottomBase }
         plane { x, 0 }
         scale <0.9, 0.9, 1>
      }

      difference {
         object { Doc_EyeBottomBase }
         plane { -x, 0 }
         scale <1.2, 0.9, 1>
      }
   }
   texture { Doc_Flesh }
}

#declare Doc_EyeBallRight = object {
   union {
      difference {
         object { Doc_EyeBallBase }
         plane { x, 0 }
         scale <0.9, 0.9, 1>
      }

      difference {
         object { Doc_EyeBallBase }
         plane { -x, 0 }
         scale <1.2, 0.9, 1>
      }
   }
   texture { Doc_EyeBallTexture }
}

#declare Doc_EyeBrowRight = object {
   union {
      difference {
         torus { 1, 0.165 rotate -x*90 }
         plane { y, 0 rotate z*15 }
         plane { x, 0 }
         scale <0.9, 0.5, 1.2>
      }
      difference {
         torus { 1, 0.165 rotate -x*90 }
         plane { y, 0 rotate -z*15 }
         plane { -x, 0 }
         scale <1.35, 0.5, 1.2>
      }
   }
   scale 1.15
   rotate y*22 //18 //15 //10 //05
   rotate -x*20 //15
   rotate -z*5
   texture { Doc_EyeBrowTexture rotate -z*45 }
}

#declare Doc_EyeRight = object {
   union {
      object { Doc_EyelidRight rotate x*22.5 }
      object { Doc_EyeBallRight }
      object { Doc_EyeBottomRight rotate -x*15 }
      object { Doc_Iris translate -z*1 rotate x*0 rotate -y*1.5 }
      object { Doc_EyeBrowRight translate <0, 0.65, 0.80>}
   }
}


#if ( Is_Inc_File = false )

object {
   Doc_EyeRight
   scale <1.3, 1.2, 0.4>
   //scale 0.0515
   //rotate -x*5  rotate -y*17.5
   //translate <0.11, 0.345, -1.835>
}

#end
