// dbwtribute.pov by Joel NewKirk
//
// Entry into the IRTC Nov-Dec 1998 stills competition "First Encounter"
// This entry is a tribute to the first ray-traced image I ever saw.  It was called
// 'Glass', and was rendered by David Wecker with his raytracer DBWRender, on VAX and
// Amiga computers.  DBWRender was 'first encounter' with raytracing, and the image 
// 'glass' was my first encounter with a raytraced image - appropriately a 'glass 
// ball and checkerboard' image after a fashion.
//
// The 'glass' scene was composed of brick walls, a half dozen glass spheres, and 
// two light sources.  I have preserved that theme, but 'updated' it with a far more
// complex brick texture, caustics, and the bowtiles floor.      
//
// The BowTiles include is something I was playing with during the V3.1 development.
// I am in the process of creating a collection of interlocking tiles in this 
// fashion, like 'S' tiles, hexagon-and-square pairs, etc.   
//

#include "colors.inc"   
#include "stones.inc"
#include "bowtiles.inc"

global_settings { assumed_gamma 2.4 }

camera {
    location  <50, 60,-60>
    direction <-1,  0,   1>  
    right <4/3,0,0>
    up        <0,  1,   0>
    look_at <0, 11, 0>
}

light_source {<30, 70, -20> color Gray85}
light_source {<-30,80,20> color Gray75}                                       


// SimpleBricks is a flat 2-color texture, rendering faster for the walls that are
// not directly visible by the camera

#declare SimpleBricks =
texture {
    pigment { brick Gray80, rgb<0.65, 0.3, 0.25> brick_size <3,1,2> mortar 0.15 }
    normal { brick -10 brick_size <3,1,2> mortar 0.175 ramp_wave}
    finish {
        ambient 0.0
        diffuse 0.8
    }
    scale 6
}


// RealBricks uses a texture_map with brick pattern to make the mortar transparent,
// so that we specify a second box object slightly smaller than the 'brick' object 
// and texture it as mortar, so that the mortar is visible recessed below the brick
// surface.
                  
// I use a crackle normal with a custom slope_map here - the intention is to recreate 
// the spiderweb of small cracks that often appear on bricks, and pockmarks/chips.  
// The 0.0 to 0.05 range is the spiderweb cracks, and the 0.6 to 1.0 range provides 
// a smooth but somewhat steep slope into the little 'craters'
                  
#declare RealBricks = 
texture
{
        brick 
                texture {pigment { rgbf <1,1,1,1> }}
                texture
                {
                        pigment { rgb <0.65, 0.3, 0.2> }
                        normal 
                        { 
                                crackle 0.75
                                slope_map
                                {
                                        [ 0.0 <0.75,0> ]
                                        [ 0.05 <1,0> ]
                                        [ 0.6 <1,0> ]
                                        [ 0.6 <1,1> ]
                                        [ 1.0 <0,1> ]
                                }        
                        }
                        finish { ambient 0.1 diffuse 0.8 }
                }
}

                        
// This is where we create a simple 120x120x120 box that is textured with the 
// bricks and mortar
                      
#declare BrickWall =
union
{
        box { <0,0,0>,<120,120,120> texture { RealBricks translate 3*z} }  
        box { <0.1,0.1,0.1>,<119.9,119.9,119.9> pigment { rgb < 0.9, 0.8, 0.7 > } }
}        


// predefine the textures to be used on the BowTile floor - makes adjustments easier
                    
#declare tex1 = texture { T_Stone3 scale 0.5 }
#declare tex2 = texture { T_Stone26 scale 5.5}

object { BrickWall translate <-60,-40,40> }
object { BrickWall  rotate -90*y translate <-60,-40,-50> }
plane { x, 60 hollow on texture { SimpleBricks rotate y* 90}}  // cheat on the walls
plane { z, -60 hollow on texture { SimpleBricks }}             // that won't be           
plane { y, 90 hollow on texture { SimpleBricks }}              // directly visible
                  
object {BowTiles (10,10,tex1,tex2)  scale 14 translate <-88,-25,-72>}
                         
#declare spheretex =
material
{
    texture 
    {
        pigment { color rgbf <0.98, 0.98, 0.98, 0.95> }
        finish 
        {     
            ambient 0.1
            diffuse 0.1
            reflection 0.1
            specular 0.8
            roughness 0.003
            phong 1
            phong_size 400 
        }
    }
    interior
    {
        ior 1.52   
        caustics 1
        fade_distance 40
        fade_power 2
    }
}


// populate our little world with some strategically located glass balls   ;^)

sphere { <10,0, 10>, 7 material { spheretex } }
sphere { <30,40, -20>, 7 material { spheretex } }
sphere { <-30,20, 20>, 7 material { spheretex } }
sphere { <-48,1, -10>, 7 material { spheretex } }
sphere { <49,10, 20>, 7 material { spheretex } }
sphere { <10,0, -40>, 7 material { spheretex } }
