#include "colors.inc"
#include "shapes.inc"

camera { location <0, 12, 0>
         right x*4/3
         angle 45
         look_at <0, 90, 500> }

light_source { <-10000, 1500, -2000> color White }
light_source { <-6, 7, 42> color rgb <0.6, 0.9, 1>
               fade_distance 200
               fade_power 2 }

// Texture defs
#declare DarkClouds = texture {
                  pigment { bozo turbulence 0.5
                            octaves 6
                            lambda 3
                            omega 0.6
                            color_map { [0 color Clear]
                                        [0.5 color Clear]
                                        [1 color LightSteelBlue] } }
                  finish { ambient 1 } }
#declare HullT = texture { pigment { bozo
                                      turbulence 0.4
                                      octaves 7
                                      omega 0.5
                                      lambda 3
                                      color_map { [0 color Firebrick]
                                                  [0.6 color Gray70]
                                                  [1 color White] }
                                      scale 5 }
                            finish { ambient 0.3 phong 1 phong_size 8 } }
#declare Gleaming = texture { pigment { bozo
                                        color_map { [0 color MandarinOrange]
                                                    [1 color Pink] }
                                        scale 0.1 }
                              finish { ambient 0.5 phong 1 phong_size 15 } }
#declare Plain = texture { pigment { wrinkles turbulence 0.3
                                     octaves 6
                                     lambda 3
                                     omega 0.6
                                     color_map { [0 color rgb <0.7, 1, 0.5>]
                                                 [1 color Tan] }
                                     scale 50 }
                           finish { ambient 0.2 } }
                 texture { pigment { wrinkles
                                     color_map { [0 color ForestGreen]
                                                 [0.3 color Clear]
                                                 [1 color Clear] } }
                           finish { ambient 0.2 } }
#declare Rocky = texture { pigment { granite turbulence 0.4
                                     octaves 6
                                     lambda 3
                                     omega 0.35
                                     color_map { [0 color Gray80]
                                                 [0.3 color Wheat]
                                                 [0.5 color Gray50]
                                                 [1 color White] }
                                     scale 5 }
                           finish { ambient 0.2 } }
#declare Bark = pigment { bozo
                          color_map { [0 color DarkWood]
                                      [1 color Tan] }
                          scale <0.2, 0.2, 5> }
#declare LogT = texture { pigment { wood
                                    pigment_map { [0 color LightWood]
                                                  [0.4 color MediumWood]
                                                  [0.8 color LightWood]
                                                  [0.9 Bark]
                                                  [1 Bark] }
                                    rotate <0, 90, 0> }
                          finish { ambient 0.2 } }
#declare Concrete = pigment { bozo turbulence 0.6
                              color_map { [0 color White]
                                          [1 color Gray80] }
                              scale 0.2 }
#declare Earthy = pigment { bozo turbulence 0.5
                            color_map { [0 color MandarinOrange]
                                        [1 color Tan] }
                            scale 0.0003 }

// Spacecraft
#declare Jaggy = julia_fractal {
                        <0.64, -0.059, 0.74, -0.027> /*0.44 -0.59 -0.54 0.057*/
                        quaternion
                        sqr
                        max_iteration 6
                        precision 10
                        slice <0, 0, 0, 1>, 0
                        rotate <0, 0, 90>
                        scale <2, 5, 2> }
#declare Spindly = difference {
                      julia_fractal {
                        <0.55, -0.052, -0.25, -0.523>
                        quaternion
                        sqr
                        max_iteration 5
                        precision 10
                        slice <0, 0, 0, 1>, 0
                        scale <1.5, 8, 1.5> }
                      plane { <0, 1, 0>, 0 } }
#declare Round = difference {
                      julia_fractal {
                        <0.2, -0.2, -0.2, 0.2>
                        quaternion
                        sqr
                        max_iteration 8
                        precision 10
                        slice <0, 0, 0, 1>, 0
                        rotate <0, 0, 90>
                        scale <2, 6, 2> }
                      plane { <0, -1, 0>, 0 } }
#declare Hull = union {
                 object { Jaggy }
                 object { Spindly }
                 object { Round }
                 object { Round rotate <0, 180, 0> }
                 texture { HullT } }
#declare Spine = difference {
                   intersection {
                     torus { 5, 0.25 translate <5, 0.125, 0> rotate <0, 0, 1.5> }
                     torus { 5, 0.25 translate <5, -0.125, 0> rotate <0, 0, -1.5> } }
                   plane { <0, 0, -1>, 0 }
                   rotate <0, 0, 90>
                   texture { gradient y
                             texture_map { [0 HullT]
                                           [1 Gleaming] }
                             scale 6 } }
#declare Spines = union {
                  object { Spine scale <1, 1, 1> rotate <0, -45, 0> }
                  object { Spine scale <1, 1, 1> rotate <0, 80, 0> }
                  object { Spine scale <1, 1.2, 0.9> rotate <0, 40, 0> }
                  object { Spine scale <1, 2, 0.7> rotate <0, 60, 0> }
                  object { Spine scale <1, 1.8, 0.8> rotate <0, 160, 0> }
                  object { Spine scale <1, 1.7, 0.8> rotate <0, -150, 0> }
                  object { Spine scale <1, 1.6, 0.7> rotate <0, -80, 0> }
                  object { Spine scale <1, 0.75, 1.2> rotate <0, -65, 0> }
                  object { Spine scale <1, 1.5, 0.85> rotate <0, -100, 0> }
                  object { Spine scale <1, 1.3, 0.9> rotate <0, -125, 0> }
                  object { Spine scale <1, 1.6, 1> rotate <0, 113, 0> }
                  object { Spine scale <1, 0.7, 0.7> rotate <0, 0, 180> rotate <0, -20, 0> }
                  object { Spine scale <1, 0.6, 0.7> rotate <0, 0, 180> rotate <0, 30, 0> }
                  object { Spine scale <1, 0.7, 0.6> rotate <0, 0, 180> rotate <0, -70, 0> }
                  object { Spine scale <1, 0.8, 0.7> rotate <0, 0, 180> rotate <0, -120, 0> }
                  object { Spine scale <1, 0.7, 0.6> rotate <0, 0, 180> rotate <0, -170, 0> }
                  object { Spine scale <1, 0.6, 0.7> rotate <0, 0, 180> rotate <0, 70, 0> }
                  object { Spine scale <1, 0.8, 0.6> rotate <0, 0, 180> rotate <0, 130, 0> }
                  object { Spine scale <1, 0.7, 0.7> rotate <0, 0, 180> rotate <0, 160, 0> } }
#declare Plume = difference { sphere { <0, 0, 0>, 1 }
                              plane { <0, -1, 0>, 0 }
                              scale <1, 10, 1>
                              pigment { color Clear }
                              halo { emitting
                                     linear
                                     spherical_mapping
                                     samples 10
                                     color_map { [0 rgbt<0, 0.2, 0.5, 1>]
                                                 [0.5 rgbt<0.5, 0.8, 1, 0.2>]
                                                 [1 rgbt<1, 1, 1, 0>] }
                                     scale <1, 9, 1>
                                     translate <0, -1, 0> }
                              hollow }
#declare Ship = union {
                object { Hull }
                object { Spines }
                object { Plume translate <0, -4, 0> } }
#declare Fusion = sphere { <0, 0, 0>, 7
                           translate <1, 3, 1>
                           pigment { color Clear }
                           halo { emitting
                                  linear
                                  spherical_mapping
                                  samples 10
                                  turbulence 0.8
                                  octaves 7
                                  lambda 3
                                  omega 0.6
                                  color_map { [0 rgbt <0, 0.1, 0.4, 1>]
                                              [0.4 rgbt <0, 0.5, 1, 0.9>]
                                              [0.7 rgbt <0.5, 0.9, 1, 0.5>]
                                              [1 rgbt <1, 1, 1, 0>] }
                                  scale <7, 5, 7>
                                  translate <0, 0, 0> }
                           hollow }
#declare Log = cylinder { <-10, 0, 0>, <10, 0, 0>, 0.5
                          texture { LogT } }
#declare LongWall = union { object { Log translate <0, 0.5, 0> }
                            object { Log translate <0, 1.5, 0> }
                            object { Log translate <0, 2.5, 0> }
                            object { Log translate <0, 3.5, 0> }
                            object { Log translate <0, 4.5, 0> }
                            object { Log translate <0, 5.5, 0> }
                            object { Log translate <0, 6.5, 0> }
                            object { Log translate <0, 7.5, 0> } }
#declare ShortWall = object { LongWall scale <0.5, 1, 1> rotate <0, 90, 0> }
#declare CabinBase = difference {
                   union {
                      object { LongWall translate <0, 0, 5> }
                      object { LongWall translate <0, 0, -5> }
                      object { ShortWall translate <-9.5, 0, 0> }
                      object { ShortWall translate <9.5, 0, 0> } }
                   object { Cube scale <1.5, 5, 1> translate <-6, 0, -5> }
                   object { Cube scale <1, 1.5, 1.5> translate <9.5, 4.5, 0> }
                   object { Cube scale <1.5, 1.5, 1> translate <-1, 4.5, -5> }
                   object { Cube scale <1.5, 1.5, 1> translate <4.5, 4.5, -5> } }
#declare WindowFrame = union { cylinder { <-1.5, -2, 0>, <-1.5, 2, 0>, 0.5 }
                               cylinder { <1.5, -2, 0>, <1.5, 2, 0>, 0.5 }
                               cylinder { <0, -2, 0>, <0, 2, 0>, 0.2 }
                               cylinder { <-1.5, 0, 0>, <1.5, 0, 0>, 0.2 }
                               pigment { Bark }
                               finish { ambient 0.2 } }
#declare Roof = union { object { Log translate <0, 0, 10> }
                        object { Log translate <0, 0, 9> }
                        object { Log translate <0, 0, 8> }
                        object { Log translate <0, 0, 7> }
                        object { Log translate <0, 0, 6> }
                        object { Log translate <0, 0, 5> }
                        object { Log translate <0, 0, 4> }
                        object { Log translate <0, 0, 3> }
                        object { Log translate <0, 0, 2> }
                        object { Log translate <0, 0, 1> }
                        object { Log }
                        object { Log translate <0, 0, -1> }
                        object { Log translate <0, 0, -2> }
                        object { Log translate <0, 0, -3> }
                        object { Log translate <0, 0, -4> }
                        object { Log translate <0, 0, -5> }
                        object { Log translate <0, 0, -6> }
                        object { Log translate <0, 0, -7> }
                        object { Log translate <0, 0, -8> }
                        object { Log translate <0, 0, -9> }
                        object { Log translate <0, 0, -10> }
                        translate <-10, 0, 0>
                        scale <0.35, 1, 1>
                        rotate <0, -90, 0> rotate <-15, 0, 0>
                        translate <0, 9.5, 0> }
#declare End = difference { object { Log scale <0.35, 1, 1> rotate <0, 90, 0> }
                            plane { <0, -1, 0>, -1.5 rotate <-15, 0, 0> }
                            plane { <0, -1, 0>, -1.5 rotate <15, 0, 0> } }
#declare Chimney = difference { object { Cube scale <1, 3, 1> }
                                object { Cube scale <0.7, 4, 0.7> }
                                pigment { Concrete }
                                finish { ambient 0.2 } }
#declare Butt = difference { object { Cube scale <3, 2, 3> }
                             object { Cube scale <2.5, 3, 2.5> }
                             translate <0, 2, 0>
                             pigment { Concrete }
                             finish { ambient 0.2 } }
#declare Fence = union { object { Log scale <0.3, 0.5, 0.5> rotate <0, 0, 90> }
                         object { Log scale <0.3, 0.5, 0.5> rotate <0, 0, 90> translate <3, 0, 0> }
                         object { Log scale <0.3, 0.5, 0.5> rotate <0, 0, 90> translate <6, 0, 0> }
                         object { Log scale <0.4, 0.5, 0.5> translate <3, 3, 0> } }
#declare Cabin = union {
                 object { CabinBase }
                 cylinder { <-4.5, 0, -5>, <-4.5, 5.5, -5>, 0.5 pigment { Bark } finish { ambient 0.2 } }
                 cylinder { <-7.5, 0, -5>, <-7.5, 5.5, -5>, 0.5 pigment { Bark } finish { ambient 0.2 } }
                 object { WindowFrame translate <-1, 4.5, -5> }
                 object { WindowFrame translate <4.5, 4.5, -5> }
                 object { WindowFrame rotate <0, 90, 0> translate <9.5, 4.5, 0> }
                 object { Roof }
                 object { Roof rotate <0, 180, 0> }
                 object { End translate <-9.5, 8.5, 0> }
                 object { End translate <9.5, 8.5, 0> }
                 object { Log translate <0, 9.5, 0> }
                 object { Chimney translate <5, 8.5, 0> }
                 object { Butt translate <8, 0, 9> }
                 union { cylinder { <11, 0, 4>, <11, 2.5, 4>, 0.7 }
                         cylinder { <11.5, 0, 2>, <11.5, 2.5, 2>, 0.7 }
                         pigment { color SteelBlue }
                         finish { ambient 0.2 phong 1 phong_size 8 } }
                 object { Cube scale <17, 5, 13> translate <-2, -5, 2>
                          pigment { Concrete }
                          finish { ambient 0.2 } }
                 object { Fence translate <5, 0, -10> } }

// Backgrounds
// Ground
difference {
     height_field { tga "Grass.tga"
                    smooth
                    scale <1000, 20, 1000>
                    translate <-500, 0, 0>
                    texture { Plain }
                    texture { pigment { wood turbulence 0
                                        lambda 0.6
                                        pigment_map { [0 Earthy]
                                                      [0.02 Earthy]
                                                      [0.03 color Clear]
                                                      [1 color Clear] }
                                        scale 1000
                                        rotate <90, 0, 0>
                                        translate <17, 0, 80> }
                              finish { ambient 0.2 } } }
     sphere { <-6, 5, 42>, 6
              pigment { color White }
              finish { ambient 1 } } }
plane { <0, 1, 0>, 0
        texture { Plain } }
// Mountains
height_field { tga "Rocks.tga"
               smooth
               scale <3500, 750, 3500>
               translate <-1750, -50, 2000>
               texture { gradient y
                         texture_map { [0 Plain scale 1/12]
                                       [0.2 Rocky]
                                       [0.6 Rocky]
                                       [0.8 pigment { color White } finish { ambient 0.5 } ]
                                       [1 pigment { color White } finish { ambient 0.5 } ] }
                         scale 750 } }

// Craft
object { Ship rotate <0, -40, 0> translate <-6, 22, 42> }

// Exhaust fire
object { Fusion translate <-6, 5, 42> }

// Building
object { Cabin scale 0.35 rotate <0, 55, 0> translate <17, 4, 80> }

// Sky
difference { plane { <0, 1, 0>, 0 }
             plane { <0, 1, 0>, -0.1 }
             translate <0, 2000, 0>
             texture { DarkClouds scale <3500, 3500, 8000> }
             no_shadow }
sky_sphere { pigment { gradient y
                       color_map { [0.5 color rgb <1, 0.7, 0.7>]
                                   [0.6 color rgb <1, 1, 0.9>]
                                   [0.65 color rgb <0.9, 1, 1>]
                                   [1.0 color SkyBlue] }
             scale 2
             translate -1 } }
