//=============================================================================
//      MACRO ROTRING
//=============================================================================
//MediumForestGreen (?) MandarinOrange (0.10) DarkTurquoise (0.70)
//BlueViolet (0.13) Red (0.18) Yellow (0.35)

#declare Queue = 
  union {
         cone {<0,0,0>,0.45,<0,8.5,0>,0.575 
                pigment {IndianRed} 
                finish {reflection .05 phong 1.9 phong_size 30}
                } 
         intersection {
                cone {<0,0,0>,0.46,<0,8.5,0>,0.576}
                cylinder {<0,.6,0>,<0,.9,0>,1} 
                pigment {Red} 
                finish {reflection .05 phong 1.9 phong_size 30}
                }
cylinder {<0,8.5,0>,<0,8.62,0>,0.575    pigment {Gray50 filter .3}}
cylinder {<0,10.89,0>,<0,11.44,0>,0.125 texture {T_Chrome_5E}}
cylinder {<0,11.44,0>,<0,11.85,0>,0.025 texture {T_Chrome_5E}}

}

#declare Tete =
union {
        cylinder {<0,8.62,0>,<0,9.42,0>,0.575}
        cylinder {<0,8.62,0>,<0,8.82,0>,0.62}
        cylinder {<0,8.92,0>,<0,9.12,0>,0.62}
        cylinder {<0,9.22,0>,<0,9.42,0>,0.62}
        cone {<0,9.42,0>,0.575,<0,9.47,0>,0.525}
        union {
          cylinder {<0,9.48,0>,<0,9.5,0>,.57}
          cylinder {<0,9.58,0>,<0,9.6,0>,.57}
          cylinder {<0,9.68,0>,<0,9.7,0>,.57}
          cylinder {<0,9.78,0>,<0,9.8,0>,.57}
          translate y*.1
          }
        cylinder {<0,9.47,0>,<0,9.59,0>,0.525}
        cone {<0,9.59,0>,0.505,<0,10.69,0>,0.45}
        cylinder {<0,10.69,0>,<0,10.89,0>,0.26}
        }

#macro Rotring (RotPig)
union {
object {Queue}
object {Tete pigment {RotPig} finish {reflection .15 specular 0 phong .8}}
}
#end

//=============================================================================
//      MACRO PENCIL
//=============================================================================

// USAGE : Pencil (Pentype,Penlenght,Penradius,Penpoint,Pencolor,Penfollow)
// Pentype   1=round 2=hex
// Penlenght ...
// Penradius radius of the pencil
// Penpoint  radius of the colored point
// Pencolor  
// Penfollow = yes  //yes=same color as point; no=wooden body

#macro Pencil (Pentype,Penlenght,Penradius,Penpoint,Pencolor,Penfollow)
union {
difference {
#if (Pentype=1)
cylinder {<0,0,0>,<0,Penlenght,0>,Penradius #if (Penfollow=1) 
texture {finish {phong 1 phong_size 15} pigment {Pencolor}} #else texture {T_Wood23 rotate x*90} #end }
#else
 intersection {
 cylinder {<0,0,0>,<0,Penlenght,0>,Penradius}
 plane {x,.866*Penradius}
 plane {x,.866*Penradius rotate y*60}
 plane {x,.866*Penradius rotate y*120}
 plane {x,.866*Penradius rotate y*180}
 plane {x,.866*Penradius rotate y*240}
 plane {x,.866*Penradius rotate y*300}
 #if (Penfollow=1) texture {pigment {Pencolor} finish { phong 1}} #else texture {T_Wood23 rotate x*90} #end
 }
#end
cone {<0,.001,0>,1/4,<0,1,0>,0 scale Penlenght texture {T_Wood23} inverse}
cylinder {<0,-.1,0>,<0,Penlenght,0>,Penpoint pigment {Pencolor}}
}

difference {
cylinder {<0,-.1,0>,<0,Penlenght,0>,Penpoint pigment {Pencolor}}
cone {<0,0,0>,1/4,<0,1,0>,0 scale Penlenght pigment {Pencolor} inverse}
}

}
#end
//=============================================================================
//      MACRO PANTONE
//=============================================================================

#declare plastiq = texture {pigment {Black} 
                   finish {specular .8 reflection .1}
                   normal {bumps .1 scale .05}
                   }

#macro Pantone (PanColor)
        union {
                cylinder {<0,0,0>,<0,-10,0>,.9
                          pigment {PanColor} 
                          finish {phong 1.2 phong_size 30}
                          }
                cone {<0,-10,0>,.9,<0,-13,0>,.8 texture {plastiq}}
                cylinder {<0,0,0>,<0,.5,0>,.8 texture {plastiq}}
                cone {<0,.5,0>,.8,<0,1.5,0>,.5 texture {plastiq}}
                cylinder {<0,1.5,0>,<0,2,0>,.5 texture {plastiq}}
                cylinder {<0,2,0>,<0,2.5,0>,.4 texture {plastiq}}
                cylinder {<0,2.5,0>,<0,3,0>,.3 pigment {PanColor}}
                sphere {<0,3,0>,.3 pigment {PanColor}}

translate y*-3 rotate x*180 
}
#end

