// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1a
//
// Fichier    :Ilovyou2.pov  by  Martial Rameaux
// Date       :24 Decembre 1998 
//
// Description:
//
//                              
//
// mile ;) -> Martial.Rameaux@Biosys.net
//==========================================
#version 3.1;
#include "colors.inc"
#include "textures.inc"

#include "consts.inc"
#declare Rad_Quality = 5;
#include "rad_def.inc"
global_settings 
{
  radiosity { distance_maximum 10 }     
  max_trace_level 200
  max_intersections 200
}  
//=============== Camera et Lens Flare ===========

#declare sky_vect = z;
#declare cam_loc  = <0.0 ,2.0 ,-20.0>;
#declare lookat   = <0.0 , 0.0 , 2.0>;
#declare AmbientLight = <1,1,1>;
#declare flare_size        = 1;        //(1.0 = 100%)
#declare bright_background = false;    //(True/False)
#declare flare_brightness  = <1,1,1>;  //(1.0 = 100%)
#declare light_rad = 2.50;
	
camera
{
  location cam_loc
  right x*4/3
  direction <0, 0,1.0>
  look_at   lookat
} 
  
#declare flare_brightness  =  <1.25,0.5,0.5>; //(1.0 = 100%)
#include "85mm.FLR"//*required*    
#declare light_loc = <  12,8.5,2>;   
#include "nkflare.inc" 

#declare flare_brightness  =  <0.5,1.25,0.5>; //(1.0 = 100%)
#include "85mm.FLR"//*required*    
#declare light_loc = < -12,8.5,2>;   
#include "nkflare.inc"  

                     
#declare flare_brightness  = <0.5,0.5,1.25>;  //(1.0 = 100%)
#include "85mm.FLR"//*required*    
#declare light_loc = < -0,6,2>;
#include "nkflare.inc"  


//#declare flare_brightness  =  <1,1,1>; //(1.0 = 100%)
//#include "space1.FLR"//*required*    
//#declare light_loc = <  0,-1,2>;   
//#include "nkflare.inc" 
 

//=================MEDIA atmosphere ========

media {
  intervals 40 //40
  scattering { 1, rgb 0.03}
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9
}

//================= Halo halo ==============

#include "halovy.inc"

//==================== lumieres ============

light_source { <0, 15, 20> 
         color rgb 0.1
         media_interaction off  // ON en plein rgime
         //shadowless
}     

light_source { <0,1,0> 
         color rgb 0.5
         media_interaction on  // ON en plein rgime
         //shadowless
}     


#declare Intensite=2;
#declare Falop=15;
#declare Rad=1;
#declare Pt=-2;

  light_source { 
  <-20, 15, 5> color rgb Intensite*<0,1,0> //<0.6, 1.0, 0.6> * Intensite
  spotlight
  point_at <-3, Pt, 0>
  radius Rad
  falloff Falop
  tightness 1
 //media_attenuation on  
  media_interaction on
}
   
   
light_source { 
  <20, 15,  5> color rgb Intensite*<1,0,0> //<1, 0.6, 0.6> * Intensite
  spotlight
  point_at < 3,Pt, 0>
  radius Rad
  falloff Falop
  tightness 1
  //media_attenuation on 
  media_interaction on
}
        
light_source { 
  <0.0, 15, 5> color rgb Intensite*<0,0,1>*1.5 //<0.6, 0.6, 1.0> * Intensite
  spotlight
  point_at <0,Pt,0>
  radius Rad
  falloff Falop
  tightness 1
  //media_attenuation on 
  media_interaction on
} 
//================= Brouillard ==============
fog {
    fog_type 1 // 1=constant, 2=ground_fog
    distance 30
    color 1
   }

//============ Murs ==========================
  
cylinder { <0,-9,0>,<0,30,0>,50 
        pigment { color rgb <1,1,1> }
        finish { ambient 0.2 diffuse 0.6 }
         hollow
}                                            

//=============== Ben c'est le pav ==========================

#include "pave.inc"   
object {Pavage translate <0,-9+3,2>} 

//========== On affiche les talons hauts et les Crocno ==========

#include "Souliers.inc"

union {
        object {TalonH   rotate <- 0,-30,-10>  translate <-3, 0.0,3.5> }          
        object {TalonH   rotate <- 0,  0,  0>  translate <-5, 0.0,1.5> }	
        object {Crocno   rotate <- 0,150,  0>  translate < 3,-1.5,2.5> }          
        object {Crocno   rotate <- 0,160,  0>  translate < 1,-1.5,5.0> }          
	   
        translate <1,-2,-5>
}

//============== L c'est les BRIS ============================
//================== Pas Textures ======================== 

#declare Bris_Texture= texture {
  pigment
  {
    marble // some pattern
    color_map {
        [0.1 color rgb 1.0] 
        [0.5 color rgb 0.9]}
    turbulence 0.5
    scale <1,3,1>// transformations
  }
  normal
  {
    marble 
    turbulence 0.5 
    octaves 6
    scale <1,3,1>
  }
  finish {  ambient 0.2 specular 0.6 }
}

#declare Bris=
difference {  
box { -1,1  translate <0 ,-0, -2> } 
sphere {<1,1,-1>,1} 
sphere {<1,-1,-1>,1} 
texture {Bris_Texture} 
rotate y*-180 
scale 0.1
}
 
object { Bris   rotate <0,45,0> //grand derriere
   translate <1 ,-4, -5>     
}
object { Bris  rotate <0,0,0>  //moyen devant
        scale 0.8
   translate <3 ,-4,-7>    
}
object { Bris  rotate <0,0,0>   //petit
     scale 0.5      
   translate <2.5 ,-4,-6.7>   
 
}
object { Bris  rotate <0,90,0>  //petit
   scale 0.5       
   translate <3.2 ,-4,-6>  
   
}
object { Bris   rotate <0,90,0> //grand derriere
   translate <-3 ,-4, 2>     
}                 
object { Bris   rotate <0,120,0> //grand derriere
   translate <-1.5 ,-4,1>     
} 
//=============== FIN du Fichier ===========================
 

