//
//
//

#version 3.1;

//
// Include objects for the scene
//

#include "desk.inc"
#include "sketch.inc"
#include "pencil.inc"
#include "julia.inc"
#include "newtons_cradle.inc"
#include "mug.inc"
#include "mug_mat.inc"
#include "pencil_holder.inc"
#include "room.inc"
#include "desk_lamp.inc"

//
// Set the global settings for the image
//

global_settings
{
        assumed_gamma 2.0
}

global_settings
{
	radiosity
	{
	        count 800
	        error_bound 0.2
	        gray_threshold 0.5
	        distance_maximum 0
	        low_error_factor 0.7
	        nearest_count 9
	        minimum_reuse 0.01
	        brightness 3.3
	        recursion_limit 1
	}
}

//
// Set the background for the scene.
//

background
{
        colour rgb <0, 0, 0>
}

//
// Place the room
//

object
{
        room
}

//
// Place the desk. Put it next to a wall.
//

object
{
        desk
        translate <0, 0, 72.5>
}

//
// Add a lamp to the scene. Twist it slightly to illuminate other
// objects.
//

object
{
        desk_lamp 
        rotate <0, -22, 0>
        translate <30, 73.5, 93>
}

//
// Show the subject of the sketch
//

object
{
        julia
        rotate <0, -4, 0>
        translate <0, 90, 15 + 72.5>
}

//
// Now put the scetch on the desk, on top of a blank piece
// of paper.
//

object
{
        julia_sketch
        rotate <0, -20, 0>
        translate <-5, 73.5 + 0.021, -32 + 72.5>
}

object
{
        blank_sketch
        rotate <0, -2, 0>
        translate <-10, 73.5, -32 + 72.5 + 5>
}

//
// Place a pencil on top of the scetch.
//

object
{
        red_pencil
        scale 0.1 // to get in cms
        rotate <0, 225, 0>
        translate <15, 73.5 + (sqrt (12) / 10), -20 + 72.5>
}

//
// Add an 'executive toy'...
//

object
{
        newtons_cradle
        rotate <0, -41, 0>
        translate <-55, 73.5, 5 + 72.5>
}

//
// ... and a mug and a mat.
//

object
{
        mug
        rotate <0, 13, 0>
        translate <33 + 0.3, 73.5 + 0.3, 66 + 0.2>
}

object
{
        mug_mat
        translate <33, 73.5, 66>
}

//
// Add a pencil holder and some pencils.
//

object
{
        pencils_holder_with_pencils
        rotate <0, 270, 0>
        translate <-23, 73.5, 68>
}

//
// Everything is now placed in the scene, so its time to set up some
// cameras and lights.
//

//
// On the newtons cradle.
//

/*
camera
{
        location <-43, 93, 65>
        look_at <-48, 85, 5 + 72.5>
}
*/

//
// On lamp.
//

/*
camera
{
        location <50, 110, -25>
        look_at <30, 87, 93>
        angle 20
}
*/

//
// On the scetch
//

/*
camera
{
        location <0, 110, 10>
        look_at <0, 75, 45>
        angle 45
}
*/

//
// On the Julia Set
//

/*
camera
{
        location <0, 110, 10>
        look_at <0, 99, 45>
        angle 28
}
*/

//
// On the Mug and Mat
//

/*
camera
{
        location <50, 110, -25>
        look_at <33, 77, 66>
        angle 11
}
*/

//
// On the pencil holder
//

/*
camera
{
        location <50, 110, -25>
        look_at <-23, 79.5, 68>
        angle 15
}
*/

//
// Full scene.
//

camera
{
        location <50, 110, -25>
        look_at <0, 75, 90>
        angle 35
}

light_source
{
        <0, 200, 0>
        colour rgb <0.6, 0.6, 0.6>
        shadowless
}
