////////////////////////////////////////////////////////////////////////////////
//
//         Name: Plastic pencil holder
//
//  Description: 
//
//        Scale: 1 POV unit = 1cm
//
//   Dimentions: -4 =< x =< 4
//               0 =< y =< 13.6
//               -(2 + sqrt (12)) =< z =< (2 + sqrt (12))
//
//       Centre: <0, 6, 0>
//
////////////////////////////////////////////////////////////////////////////////

#include "colors.inc"
#include "textures.inc"

#include "pencil.inc"

#declare pencil_holder = union
{
	difference
	{
	        cylinder
        	{
                	<0, 0.05, sqrt (12) / 2>,
			// <0, 12, sqrt (12) / 2>, 2.1
                        <0, 13.314363 + 0.25, sqrt (12) / 2>, 2.1			
	        }
	        cylinder
        	{
                	<0, 0.25, sqrt (12) / 2>,
			<0, 20, sqrt (12) / 2>, 1.9
	        }
	}
	cone
	{
		<0, 0, sqrt (12) / 2>, 2.05
		<0, 0.05, sqrt (12) / 2>, 2.1
	}
	difference
	{
	        cylinder
        	{
                	<2, 0.05, -(sqrt (12) / 2)>,
			// <2, 9, -(sqrt (12) / 2)>, 2.1
			<2, 9.415592 + 0.25, -(sqrt (12) / 2)>, 2.1
	        }
        	cylinder
	        {
        	        <2, 0.25, -(sqrt (12) / 2)>,
			<2, 20, -(sqrt (12) / 2)>, 1.9
	        }
	}
	cone
	{
		<2, 0, -(sqrt (12) / 2)>, 2.05
		<2, 0.05, -(sqrt (12) / 2)>, 2.1
	}
	difference
	{
        	cylinder
	        {
        	        <-2, 0.05, -(sqrt (12) / 2)>,
			<-2, 6, -(sqrt (12) / 2)>, 2.1
	        }
        	cylinder
	        {
        	        <-2, 0.25, -(sqrt (12) / 2)>,
			<-2, 20, -(sqrt (12) / 2)>, 1.9
	        }
	}
	cone
	{
		<-2, 0, -(sqrt (12) / 2)>, 2.05
		<-2, 0.05, -(sqrt (12) / 2)>, 2.1
	}
	pigment
	{
		colour rgb <0,0.2,1> // Blue
	}
	finish
	{
		Dull
	}
}

#declare pencils_holder_with_pencils = union
{
        object
        {
                pencil_holder
        }
        
        //
        // Pencils in tallest holder
        //
        
        object
        {
                orange_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 90> // to stand verticle
                translate <0,8,0> // to rest on y=0
                rotate <6.10981,0,0> // to tip to one side 
                translate <0, 0.25 + 0.03686, sqrt (12) / 2>
        }
        object
        {
                red_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 270> // to stand verticle
                rotate <0,60,0> // to show label
                translate <0,8,0> // to rest on y=0
                rotate <6.10981,0,0> // to tip to one side
                rotate <0,80,0> 
                translate <0, 0.25 + 0.03686, sqrt (12) / 2>
        }
        object
        {
                white_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 90> // to stand verticle on point
                translate <0,8,0> // to rest on y=0
                rotate <6.10981,0,0> // to tip to one side
                rotate <0,200,0> 
                translate <0, 0.25 + 0.03686, sqrt (12) / 2>
        }
        object
        {
                orange_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 90> // to stand verticle on point
                translate <0,8,0> // to rest on y=0
                rotate <6.10981,0,0> // to tip to one side
                rotate <0,270,0> 
                translate <0, 0.25 + 0.03686, sqrt (12) / 2>
        }

        //
        // Pencils in middle height holder
        //
        
        object
        {
                red_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 90> // to stand verticle
                translate <0,8,0> // to rest on y=0
                rotate <7.34006,0,0> // to tip to one side 
                translate <2, 0.25 + 0.0442567, -(sqrt (12) / 2)>
        }
        object
        {
                orange_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 270> // to stand verticle
                rotate <0,60,0> // to show label
                translate <0,8,0> // to rest on y=0
                rotate <7.34006,0,0> // to tip to one side
                rotate <0,50,0> 
                translate <2, 0.25 + 0.0442567, -(sqrt (12) / 2)>
        }
        object
        {
                red_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 90> // to stand verticle on point
                translate <0,8,0> // to rest on y=0
                rotate <7.34006,0,0> // to tip to one side
                rotate <0,100,0> 
                translate <2, 0.25 + 0.0442567, -(sqrt (12) / 2)>
        }
        object
        {
                orange_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 90> // to stand verticle on point
                translate <0,8,0> // to rest on y=0
                rotate <7.34006,0,0> // to tip to one side
                rotate <0,150,0> 
                translate <2, 0.25 + 0.0442567, -(sqrt (12) / 2)>
        }
        object
        {
                red_pencil
                scale 0.1 // to get in cms
                rotate <0, 0, 270> // to stand verticle on point
                rotate <0,300,0> // to show text
                translate <0,8,0> // to rest on y=0
                rotate <7.34006,0,0> // to tip to one side
                rotate <0,190,0> 
                translate <2, 0.25 + 0.0442567, -(sqrt (12) / 2)>
        }
}
