//Man.inc
//Parameters for rotation and translation supplied by the calling file
//(c) 1998 Ben Jackson

//for use with fingers
#declare capped_sphere = union {
cylinder {<0,0,0>,<0,2,0>,1}
sphere {<0,0,0>,1}
sphere {<0,2,0>,1}
}
 


//for use with shoe
#declare half_sole =
difference{
  union{
   torus { 2.0, .5 }
   torus { 1.0, .5 }
   sphere{<0,0,0>, .5}
  }
  box {<-3,-1.5,-3>, <3,1.5,0>}
}

#declare upper_shoe = difference{
 union{
  sphere {<0,0,0>, 2.0 texture {shoe_tex_1}}
  sphere {<0,0,-2>, 2.0 texture {shoe_tex_1}}

  cylinder{<0,0,0>, <0,0,-2>, 2.0 texture {shoe_tex_1}}
 }
 box {<-3,-3,-5>, <3,0,3>}
}

//Shoe
declare shoe = union{
 object {upper_shoe} 
 union{
  object{half_sole}
  object{half_sole rotate x*180 translate z*-2}
  cylinder{<0,0,0>, <0,0,-2>, .5}
  cylinder{<1,0,0>, <1,0,-2>, .5}
  cylinder{<-1,0,0>, <-1,0,-2>, .5}
  cylinder{<-2,0,0>, <-2,0,-2>, .5}
  cylinder{<2,0,0>, <2,0,-2>, .5}
  texture {sole_tex} 
 }
 translate <0,-1,0>
}

//Left Leg
declare left_leg = union{
 union{
  object{shoe rotate left_shoe_rotate}
  torus {1,.3 translate <0,1,0> rotate <10,0,0> texture{shoe_tex_2}}
  cylinder{<0,0,0>, lower_leg, lower_thickness}
  sphere {lower_leg, lower_thickness}
  translate lower_leg * <-1,-1,-1>
  texture{leg_tex}
  rotate left_knee_bend
 }
 cylinder {<0,0,0>, upper_leg, upper_thickness texture{leg_tex}}
 translate upper_leg * <-1,-1,-1>
 rotate left_leg_rotate
}

//Right Leg
declare right_leg = union{
 union{
  object{shoe rotate right_shoe_rotate}
  torus {1,.3 translate <0,1,0>  rotate <10,0,0> texture{shoe_tex_2}}
  cylinder{<0,0,0>, lower_leg, lower_thickness}
  sphere {lower_leg, lower_thickness}
  translate lower_leg * <-1,-1,-1>
  texture{leg_tex}
  rotate right_knee_bend
 }
 cylinder {<0,0,0>, upper_leg, upper_thickness texture{leg_tex}}
 translate upper_leg * <-1,-1,-1>
 rotate right_leg_rotate
}    

//Right Eye
#declare right_eye =union{
  sphere {<0,0,0>,.45 pigment {color White} finish{eye_finish}}
  union {
    difference{
    sphere {<0,0,0>,.46 pigment {color Blue} finish{eye_finish}}
    box {<-1,-1,-1>,<1,.4,1>}
    }
    difference{
    sphere {<0,0,0>,.47 pigment {color Black} finish{eye_finish}}
    box {<-1,-1,-1>,<1,eye_dialation,1>}
    }
    rotate right_eye_rotate
  }  
  difference{
    sphere{<0,0,0>,.48 texture {eye_lid_tex rotate r_right_eye_upper}}
    box {<-1,-1,-1>,<1,right_eye_upper,1> rotate r_right_eye_upper}
  }
  difference{
    sphere {<0,0,0>,.48 texture {eye_lid_tex rotate r_right_eye_lower}}
    box {<-1,-right_eye_lower,-1>,<1,1,1> rotate r_right_eye_lower}
  }
  finish {phong .3 phong_size 30}
  scale <1,1,.4>
}  

//Left Eye  
#declare left_eye =union{
  sphere {<0,0,0>,.45 pigment {color White} finish{eye_finish}}
  union {
    difference{
    sphere {<0,0,0>,.46 pigment {color Blue} finish{eye_finish}}
    box {<-1,-1,-1>,<1,.4,1>}
    }
    difference{
    sphere {<0,0,0>,.47 pigment {color Black} finish{eye_finish}}
    box {<-1,-1,-1>,<1,eye_dialation,1>}      
    }
    rotate left_eye_rotate
  }  
  difference{
    sphere{<0,0,0>,.48 texture {eye_lid_tex rotate r_left_eye_upper}}
    box {<-1,-1,-1>,<1,left_eye_upper,1> rotate r_left_eye_upper}
  }
  difference{
    sphere {<0,0,0>,.48 texture {eye_lid_tex rotate r_left_eye_lower}}
    box {<-1,-left_eye_lower,-1>,<1,1,1> rotate r_left_eye_lower}
  }
  finish {phong .3 phong_size 30}  
  scale <1,1,.4>
}    
      

//Head
#declare head=union{
 object{right_eye scale right_eye_size rotate <-30,30,0> translate <-1,1.5,-1.9>}
 object{left_eye scale left_eye_size rotate <-30,-30,0> translate <1,1.5,-1.9>}
 cone {<0,0,0>, 1.5 
       <0,4,0>, 3 texture {chin_tex}}
 sphere{<0,0,0>, 1.5 scale <1,.2,1> texture {chin_tex}}
 sphere{<0,4,.5>,3.5 texture {head_tex rotate <40,0,0>}}
 torus{4, .3
      hollow 
      finish {ambient .8 diffuse .2}
      pigment {color rgbt<1,1,0,1>}
      translate <0,4,.5>
      interior{
       media{
        emission .65
        density {agate 
         color_map{
          [0.0 rgbt <1,1,1,1>]
          [1.0 rgbt <1,1,0,0>]
         }
         scale 1 
         turbulence .5
        }
       }
      }
 }
 difference{
  difference{
    torus {2, .5 rotate <0,0,90> translate <0,2,0>}
    box {<-.55,-2.55,0> <.55,2.55,2.55>}
  }
  box {<-.55,-.55,-2.55> <.55,.35,.5>}
  texture {nose_tex translate <0,-.67,0>}
 }  
 translate <0,-1.5,-1.6>
 rotate head_rotate
}

//Right Arm
#declare right_arm = union{
 union{
  union{
   union{
    union{
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} rotate r_right_index_01 translate <0,.4,0>}
     object {capped_sphere scale <.2,.2,.21> texture {finger_tex} }
     rotate r_right_index_02
     translate <0,.4,0>
     }
    object {capped_sphere scale <.22,.2,.23> texture {finger_tex} }
    rotate r_right_index_03
    translate <.55,.5,0>
   }
   
   union{
    union{
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} rotate r_right_middle_01 translate <0,.4,0>}
     object {capped_sphere scale <.2,.2,.21> texture {finger_tex} }
     rotate r_right_middle_02
     translate <0,.4,0>
     }
    object {capped_sphere scale <.22,.2,.23> texture {finger_tex} }
    rotate r_right_middle_03
    translate <.0,.5,0>
   } 
 
   union{
    union{
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} rotate r_right_pinky_01 translate <0,.4,0>}
     object {capped_sphere scale <.2,.2,.21> texture {finger_tex} }
     rotate r_right_pinky_02
     translate <0,.4,0>
     }
    object {capped_sphere scale <.22,.2,.23> texture {finger_tex} }
    rotate r_right_pinky_03
    translate <-.55,.5,0>
   }      
  
   union{ 
    object {capped_sphere scale <.2,.2,.2> texture {finger_tex} rotate r_right_thumb_01 translate <0,.6,0>}
    object {capped_sphere scale <.2,.3,.2> texture {finger_tex} }
    rotate r_right_thumb                   
    translate <.7,-.45,-.2>
   }
  
   union{
    box {<-.5,-.5,-.25>,<.5,.5,.25>}
    cylinder {<-.5,-.5,0>,<.5,-.5,0>,.25}
    cylinder {<.5,-.5,0>,<.5,.5,0>,.25}
    cylinder {<.5,.5,0>,<-.5,.5,0>,.25}
    cylinder {<-.5,.5,0>,<-.5,-.5,0>,.25}
    sphere {<.5,-.5,0>,.25}
    sphere {<-.5,-.5,0>,.25}
    sphere {<-.5,.5,0>,.25}
    sphere {<.5,.5,0>,.25}
    sphere {<.4,-.4,-.1>,.5 scale <1,1,.7>}
    sphere {<-.25,-.54,-.1>,.6 scale<1,.7,.5>}
   }
   texture{hand_tex}
   translate <0,.5.0>
   scale <1.5,1.5,1.5>
   rotate r_right_hand
  }
  cylinder {<0,0,0>, <0,-lower_arm,0>, lower_arm_thickness}
  sphere {<0,-lower_arm,0>, lower_arm_thickness}
  sphere {<0,-lower_arm,0>, upper_arm_thickness}
  translate <0,lower_arm,0>
  texture {arm_tex}
  rotate r_right_lower_arm
 }
 cylinder {<0,0,0>, <0,-upper_arm,0>, upper_arm_thickness}
 translate <0, upper_arm,0>
 texture {arm_tex}
 rotate r_right_arm
}

//Left Arm
#declare left_arm = union{
 union{
  union{
   union{
    union{
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} rotate r_left_index_01 translate <0,.4,0>}
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} }
     rotate r_left_index_02
     translate <0,.4,0>
     }
    object {capped_sphere scale <.22,.2,.23> texture {finger_tex} }
    rotate r_left_index_03
    translate <-.55,.5,0>
   }
   
   union{
    union{
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} rotate r_left_middle_01 translate <0,.4,0>}
     object {capped_sphere scale <.2,.2,.21> texture {finger_tex} }
     rotate r_left_middle_02
     translate <0,.4,0>
     }
    object {capped_sphere scale <.22,.2,.23>texture {finger_tex} }
    rotate r_left_middle_03
    translate <.0,.5,0>
   } 
 
   union{
    union{
     object {capped_sphere scale <.17,.2,.2> texture {finger_tex} rotate r_left_pinky_01 translate <0,.4,0>}
     object {capped_sphere scale <.2,.2,.21> texture {finger_tex} }
     rotate r_left_pinky_02
     translate <0,.4,0>
     }
    object {capped_sphere scale <.22,.2,.23> texture {finger_tex} }
    rotate r_left_pinky_03
    translate <.55,.5,0>
   }      
  
   union{ 
    object {capped_sphere scale <.2,.2,.2> texture {finger_tex} rotate r_left_thumb_01 translate <0,.6,0>}
    object {capped_sphere scale <.2,.3,.2> texture {finger_tex} }
    rotate r_left_thumb 
    translate <-.7,-.45,-.2>
   }
  
   union{
    box {<-.5,-.5,-.25>,<.5,.5,.25>}
    cylinder {<-.5,-.5,0>,<.5,-.5,0>,.25}
    cylinder {<.5,-.5,0>,<.5,.5,0>,.25}
    cylinder {<.5,.5,0>,<-.5,.5,0>,.25}
    cylinder {<-.5,.5,0>,<-.5,-.5,0>,.25}
    sphere {<.5,-.5,0>,.25}
    sphere {<-.5,-.5,0>,.25}
    sphere {<-.5,.5,0>,.25}
    sphere {<.5,.5,0>,.25}
    sphere {<-.4,-.4,-.1>,.5 scale <1,1,.7>}
    sphere {<.25,-.54,-.1>,.6 scale<1,.7,.5>}
   }
   texture {hand_tex}
   translate <0,.5.0>
   scale <1.5,1.5,1.5>
   rotate r_left_hand
  }
  cylinder {<0,0,0>, <0,-lower_arm,0>, lower_arm_thickness}
  sphere {<0,-lower_arm,0>, lower_arm_thickness}
  sphere {<0,-lower_arm,0>, upper_arm_thickness}
  translate <0, lower_arm, 0>
  texture {arm_tex}  
  rotate r_left_lower_arm
 }
 cylinder {<0,0,0>, <0,-upper_arm,0>, upper_arm_thickness}
 translate <0, upper_arm,0>
 texture {arm_tex}
 rotate r_left_arm
}  
 
//here's the man
#declare man=union{
object {left_leg translate left_hip}
object {right_leg translate right_hip}
object {head translate head_location}
object {right_arm translate right_shoulder}
object {left_arm translate left_shoulder}
cylinder {head_location, chest, .75 texture{body_tex scale 2.7}}
blob { threshold .65
      cylinder {left_shoulder, right_shoulder, 2, 1 }
       cylinder {hips, chest, 3, 1 }
       cylinder {left_hip, right_hip, 2, 1}  
       texture{body_tex scale 3}}
}



   
















 

                