//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 11/18/1998    (18.11.1998)
//

/* // Scene Comment

This scene was initially modelled with Moray For Windows, then altered for final rendering.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

//Fog is used to obscure the fact that the ground is a simple plane with a heavily crand'ed green texture.
fog {
  fog_type 1    // Constant
  distance     120.0
  color <0.6,0.6,0.6,0.0,0.0>
}

camera {  //  Camera StdCam
  location  <-12.000, -20.000, 15.000>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.000, -20.000, 20.000>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  TEXTURES  *******
//

#include "nest2.inc"


//
// ********  While Loop to make a nest  *******
//
//Declare the "hay"
#declare hay=cylinder{
         <0,0,0>,
         <0,1,0>,
         .01

         texture {   DryGrass}
}

//Declare the "twig"
#declare twig=cylinder {
    <0, 0, 0>,     // Center of one end
    <0, 3, 0>,     // Center of other end
    0.11            // Radius

    texture { DMFWood2 }
  }

#declare Count=0
#declare r1=4
#declare r2=6.2
#declare hmax=2.1

#declare l1 = seed(0)
#declare l2 = seed(1)
#declare l3 = seed(2)
#declare l4 = seed(6)
#declare l5 = seed(23)

#while (Count < 2000)

  #declare h= rand(l1)* hmax
  #declare t1 = (-15) + rand(l2) * (2 * 15)
  #declare t2 = rand(l3) * 359
  #declare ra = r1 + rand(l4) * (r2 - r1)
  #declare sz1 = .5 + rand(l5)
  #declare sz2 = .5 + rand(l5)
  #declare sz3 = .5 + (1 / ra)

    object{twig
    scale <sz1,sz2,sz3>
    translate <-ra,0,h>
    rotate <t1,0,0>
    rotate <0,0,t2>
    clipped_by { sphere { <0,0,0>, 6.2 } }

    }
    #declare Count=Count+1
#end

//This is for the inside filler of the nest

#declare Count=0
#declare r1=0
#declare r2=4.2
#declare hmax=2.0

#declare l1 = seed(0)
#declare l2 = seed(1)
#declare l3 = seed(2)
#declare l4 = seed(6)
#declare l5 = seed(23)

#while (Count < 3000)

  #declare h= rand(l1)* hmax
  #declare t1 = (-15) + rand(l2) * (2 * 15)
  #declare t2 = rand(l3) * 359
  #declare ra = r1 + rand(l4) * (r2 - r1)
  #declare sz1 = .5 + rand(l5)
  #declare sz2 = .5 + rand(l5)
  #declare sz3 = .5 + (1 / ra)

    object{hay
   // scale <sz1,sz2,sz3>
    translate <-ra,0,h>
    rotate <t1,0,0>
    rotate <0,0,t2>
    //clipped_by { sphere { <0,0,0>, 6.2 } }

    }
    #declare Count=Count+1
#end


#declare Needle = cone { // Cone001
  <0,0,0>, (1/12), <0,0,1>, 0.0
  texture {
    pigment {
    color rgb <0,.3854,0>
    }
    finish
   {
      ambient 0.1
      brilliance 2.406
      phong 0.194233
      specular 0.647467
      roughness 0.1203
   }
   }
}
#declare leaf= union{
object{Needle}

#declare UpweGo = 0
#while (UpweGo < .9)
       #declare Arund = 0
       #while (Arund < 9)
       object{
              Needle
              #declare a = .5 - ((4/9) * UpweGo)
              scale <a,a,a>
              rotate<0, 30, (36* Arund)>
              translate<0,0,UpweGo>
       }
       #declare Arund = Arund + 1
       #end
#declare UpweGo = UpweGo + .1
#end
}

#declare leaf2= union{
object{leaf}
object{leaf
       rotate<0,-25,0>
}
object{leaf
       rotate<0,25,0>
}
}

//
// ********  OTHER OBJECTS  *******
//

object { // Upper left pine leaf
       leaf
       rotate <0,180-33,0>
       translate <-3,0,3>
       scale <3,3,3>
}

object { // Lower right set of three leaves
       leaf2
       rotate <-45,-33,0>
       translate <0,-4,0>
       scale <3,3,4>
}


cylinder { // root5
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood4_1
  }
  scale <1.21251, 1.0, -11.750574>
  rotate 34.219707*y
  translate  <15.152464, 16.063758, -42.714424>
}


cylinder { // trunk
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood4_1
  }
  scale <13.247669, 12.124611, -76.140976>
  translate  <25.497574, 21.525533, 26.351187>
}

//The next two prisms where used to place the crack in the egg.  They get differenced out later
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-1.312925, 1.115646>,
  <-0.793265, 1.026156>,
  <0.280272, 0.871429>,
  <0.37415, 0.768707>,
  <0.528912, 0.788435>,
  <0.544218, 0.92517>,
  <0.383673, 0.993197>,
  <0.319728, 0.918367>,
  <-0.394558, 0.989796>,
  <-1.312925, 1.115646>
  rotate -x*90
  rotate <-67.918701, 0.0, 171.836548>
  translate  <-2.318966, -0.580265, 4.685549>
}
#declare TraSwp2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <0.280272, 0.871429>,
  <0.37415, 0.768707>,
  <0.460884, 0.856463>,
  <1.723639, 0.632313>,
  <2.319728, 1.52381>,
  <1.705741, 0.666122>,
  <0.495646, 0.910204>,
  <0.383673, 0.993197>,
  <0.319728, 0.918367>,
  <0.280272, 0.871429>
  rotate -x*90
  rotate <-67.918701, 0.0, 132.017441>
  translate  <-1.698753, -1.114055, 4.685549>
}
difference { // wholeEgg
  sphere { // Egg
    <0,0,0>,1
    texture {
      eggshell
    }
    hollow
    scale <1.813876, 1.795429, 3.034689>
    rotate -16.21146*y
    translate  <-1.953301, 0.0, 2.360239>
  }
  object { TraSwp001 }
  object { TraSwp2 }
  texture {
    eggshell
  }
  translate  <0.055921, 0.025419, 0.0>
}


plane { // Ground
  z,0
  texture {
    Grass
  }
  translate  <0.0, -0.610413, -47.909355>
}


cylinder { // Branch1
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood4_1
  }
  scale <-2.030596, 8.195783, -36.128189>
  rotate <-180.0, -89.972397, 180.0>
  translate  <-14.731148, 0.0, -2.523014>
}


cylinder { // root1
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood4_1
  }
  scale <1.21251, 1.0, -11.750574>
  rotate <-23.129755, 33.583229, -3.746074>
  translate  <16.334496, 14.936926, -44.414501>
}


cylinder { // root2
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood4_1
  }
  scale <1.21251, 1.0, -11.750574>
  rotate <-151.473282, 37.686958, -147.666061>
  translate  <44.994962, 17.614541, -51.852336>
}


cylinder { // root3
  <0,0,1>, <0,0,0>, 1
  texture {
    DMFWood4_1
  }
  scale <1.21251, 1.0, -11.750574>
  rotate <-134.387955, 23.371107, -156.52594>
  translate  <42.68194, 10.141702, -51.852336>
}


