
#declare pin_hole = box { <0, 0.75, 0>, <3, 0, 0.2>
                          translate x * -0.8
                        }

#declare pin_holes = union {
                       object {pin_hole}
                       object {pin_hole translate <0, 0.75, 1.5> rotate x * -30}
                       object {pin_hole translate <0, 0.85, -1.5> rotate x * 30 }
                     }

#declare cord = intersection {
                  torus { 4, 0.3       
                    rotate y * -90
                  }
                 
                  box {
                    <0, 1, 0>, <-5, -1, -5>
                  }
                }


#declare lead = union {
                  object {
                    pin_holes
                    pigment {color White}
                    finish {reflection 0.4 phong 0.6}
                  }

                  superellipsoid {
                    <1, .5>
                    pigment { rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                    scale <1.5, 1.5, 0.2>
                    rotate y * 90
                    translate <0.3, 1.2, 0.15>
                  }

                  cylinder {
                    <0.3, 1.2, 0.15>, <-0.7, 1.2, 0.15>, 1.45
                    pigment{ rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                  }

                  cone {
                    <-0.7, 1.2, 0.15>, 1.45, <-2, 1.2, 0.15>, 0.5
                    pigment { rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                  }

                  cylinder {
                    <-2, 1.2, 0.15>, <-2.3, 1.2, 0.15>, 0.5
                    pigment{ rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                  }

                  superellipsoid {
                    <1, .5>
                    pigment { rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                    scale <0.55, 0.55, 0.2>
                    rotate y * 90
                    translate <-2.3, 1.2, 0.15>
                  }

                  object {
                    cord
                    pigment { rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                    translate <-2.4, 1.2, 4.1>
                  }

                  object {
                    cord
                    pigment { rgb <0.9, 0.8, 0.7> }
                    finish {phong 0.5}
                    rotate y * 180
                    translate <-10.4, 1.2, 4.1>
                  }
               }

