#include "lopy01.pov"

object {
   lopy
   rotate y*25
   translate <10,0,4>
}
object {
   lopy
   rotate y*160
   translate <7,0,10>
}
object {
   lopy
   rotate -30*y
   translate <4,0,3>
}
object {
   lopy
   rotate -10*y
   translate <7,0,5>
}

object {
   lopy
   rotate 20*y
   translate <8,0,-6>
}

object {
   lopy
   rotate -30*y
   translate <22,0,7>
}
object {
   lopy
   rotate 60*y
   translate <18,0,8>
}
object {
   lopy
   rotate -70*y
   translate <20,0,11>
}
object {
   lopy
   rotate -130*y
   translate <24,0,13>
}
object {
   lopy
   rotate -130*y
   translate <15,0,7>
}
object {
   lopy
   rotate -30*y
   translate <18,0,14>
}
object {
   lopy
   rotate 40*y
   translate <22,0,16>
}
object {
   lopy
   rotate -50*y
   translate <28,0,15>
}
object {
   lopy
   rotate 70*y
   translate <26,0,9>
}

object {
   lopy
   rotate -35*y
   translate <21,0,-4>
}

#declare Metal = 
texture {
   pigment { color rgb <1,.8,.7> }
   finish  { phong 0.8 phong_size 40  }
   normal { bumps 0.2 }
   scale 0.1
}

#declare Zemlja = 
texture {
   pigment {
      wrinkles
      color_map {
         [ 0 color rgb <0,0.6,0> ]
         [ 1 color rgb <0.6,0.3,0> ]
      }
      scale 0.1   
   }
   finish  { phong 0.2 phong_size 20 }
   normal  { wrinkles 0.8 }
   scale 0.1
}



#declare BRDO_GORNJA_TEX = 
   texture {
      gradient y
      texture_map {
         [ 0.0 Zemlja ]
         [ 0.4 Zemlja ]
         [ 0.7 Metal ]
         [ 1.0 Metal ]
      }
      turbulence 0.4
      octaves 8
      lambda 6
      omega .6  
   }


union {

height_field {
   tga "hf2.tga"
   smooth
   rotate 90*y
   scale <30,4,30>
   translate <-27,-6,4>
}
height_field {
   tga "hf2.tga"
   smooth
   rotate 90*y
   scale <30,4,30>
   translate <-20,-6,18>
}
plane {  y,-6 }
   texture {
      BRDO_GORNJA_TEX
      scale 8
      translate <0,-8,0>
   }

}

fog
{
  fog_type   2
  distance   10
  color      rgbt <0.2,0.2,0.35,0.4>
  fog_offset -6
  fog_alt    5
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map {
       [0.0 color rgb <0.4,0.5,0.7>/3 ] // dijeljenje je bilo na 4
       [0.1 color rgb <0.5,0.6,0.8>/3 ]
       [0.2 color rgb <0.7,0.8,1.0>/3 ]
       [1.0 color rgb <0.7,0.8,1.0>/3 ]
    }
  }
  pigment { 
    wrinkles 
    turbulence .4 
    octaves 5 
    lambda 4  
    omega 0.3  
    color_map { 
      [0 color rgbt <1, 1, 1, 1>] 
      [0.5 color rgbt <0.98, 0.99, 0.99, .85>] 
      [1 color rgbt <1, 1, 1, 1>] 
    } 
    scale <.8, .1, .8> 
  }
   
}
 