// Persistence of Vision Ray Tracer Scene Description File
// File: violet.pov
// Vers: 3.1
// Desc: Source file of the "Violet sunset" picture. 
// Date: 29 December 1998
// Auth: Sergei P. Shuvalkin

#version 3.1;
#declare main_camera_location = <0.05, 0.2,   -3>;
#declare main_camera_look_at  = < 0.7,  10, -2.7>;
#declare camera2_location     = <   0,   1,  -10>;
#declare enable_area_light    = 1;

#include "colors.inc"
#include "ca_textures.inc"
#include "Campodeoid.inc"
#include "treen2.inc"
#include "term.inc"

camera{ location main_camera_location look_at main_camera_look_at }
//camera{ location camera2_location look_at main_camera_location + <0,2,0> }
  
#declare lvect = <-100.05,100.1 ,-100.1> - main_camera_location;
#declare lvect_n = lvect/vlength(lvect);
#declare ax1_t = vcross(lvect_n,y);
#declare ax1 = ax1_t/vlength(ax1_t);
#declare ax2 = vcross(ax1,lvect_n);
light_source{ <-100.05,100.1 ,-100.1> color rgb <1,1,1>
#if( enable_area_light = 1 )
   area_light 5*ax1, 5*ax2, 4, 4 
   adaptive 3
   jitter
#end
}
 
light_source{ main_camera_location    color rgb <0.5,0.5,0.25> }

sky_sphere{ pigment{Sky_pig1} pigment{Sky_pig2}}
plane {y,-1 texture{T_Stone1}}
   
object{ tree62(5576) texture{ Red_tree_xt } translate <   0,-0.5,-2> }
object{ tree62(  55) texture{ Red_tree_xt } rotate 45*y translate <-0.5,-0.5,-4> }

object{ CaHead scale 0.5 rotate -60*x rotate 180*y
        translate <0.0,0.8,-0.35>
        rotate -60*y
        translate main_camera_location }

#declare Cam_dir_vector = main_camera_look_at - main_camera_location;
#declare Cam_dir_vector_prxz = Cam_dir_vector - y*vdot(y,Cam_dir_vector);
#if( vdot(x,Cam_dir_vector) > 0 )
   #declare y_rot =  degrees(acos(vdot(z,Cam_dir_vector)/vlength(Cam_dir_vector_prxz)));   
#else
   #declare y_rot = -degrees(acos(vdot(z,Cam_dir_vector)/vlength(Cam_dir_vector_prxz)));   
#end
#declare x_rot = -degrees(asin(vdot(y,Cam_dir_vector)/vlength(Cam_dir_vector)));  
object{ Term(0.01) rotate x_rot*x rotate y_rot*y
        translate main_camera_location
        pigment{ color rgb <1.1,1.1,1.1> }}

