#include "metals.inc"

#declare PodTex =
texture {
	crackle
	texture_map {
		[0.0 T_Brass_1C]
		[1.0 T_Brass_5E]
	}
	turbulence .5
	scale 5
}

#declare T13_Glass =
material {
	texture{
		pigment{rgbft<1,1,1,.49,.49>}
		finish {phong .25 phong_size 200 reflection .4}
	}
	interior {
		ior 1.5
	}
}

#declare T13_Glass2 =
material {
	texture{
		pigment{rgbft<1,1,1,.2,.2>}
		finish {phong 1 reflection .75}
	}
	interior {
		ior 1.5
	}
}

#declare Column_stone =
texture {
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.07 color rgb<0.522, 0.435, 0.322>]
      [0.15 color rgb<0.741, 0.471, 0.251>]
      [0.24 color rgb<0.745, 0.486, 0.227>]
      [0.43 color rgb<0.380, 0.329, 0.118>]
      [0.49 color rgb<0.886, 0.584, 0.282>]
      [0.64 color rgb<0.694, 0.573, 0.416>]
      [0.68 color rgb<0.447, 0.369, 0.020>]
      [0.78 color rgb<0.573, 0.412, 0.251>]
      [1.00 color rgb<0.671, 0.302, 0.039>]
    }
    scale 50
  }
}
texture {
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgbf<0.843, 0.655, 0.482, 0.514>]
      [0.06 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.12 color rgbf<0.616, 0.482, 0.224, 0.090>]
      [0.16 color rgbf<0.800, 0.784, 0.675, 0.337>]
      [0.36 color rgbf<0.667, 0.435, 0.114, 0.624>]
      [0.46 color rgbf<0.906, 0.722, 0.569, 0.416>]
      [0.55 color rgbf<0.910, 0.827, 0.608, 1.000>]
      [0.65 color rgbf<0.659, 0.490, 0.259, 0.741>]
      [0.79 color rgbf<0.886, 0.608, 0.349, 0.196>]
      [0.87 color rgbf<0.678, 0.439, 0.247, 0.188>]
      [0.92 color rgbf<0.973, 0.780, 0.565, 0.533>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    } 
    scale 10
  }
  finish {phong .2 phong_size 5}
  normal {dents 1 scale .1}
}

#declare Floor_stone =
texture {
  pigment
  {
    crackle
    color_map
    {
      [0.00 color rgb<0.380, 0.208, 0.012>]
      [0.12 color rgb<0.545, 0.373, 0.102>]
      [0.24 color rgb<0.635, 0.471, 0.208>]
      [0.41 color rgb<0.718, 0.435, 0.153>]
      [0.55 color rgb<0.702, 0.561, 0.302>]
      [0.73 color rgb<0.820, 0.655, 0.439>]
      [0.89 color rgb<0.886, 0.796, 0.635>]
      [1.00 color rgb<0.902, 0.780, 0.627>]
    }
  }
  scale 3
}
texture {
  pigment
  {
    bozo
    turbulence 0.8
    color_map
    {
      [0.00 color rgbf<0.8, 0.8, 0.8, 0.824>]
      [0.13 color rgbf<0.7, 0.7, 0.7, 0.345>]
      [0.20 color rgbf<0.7, 0.7, 0.7, 0.129>]
      [0.33 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.36 color rgbf<0.9, 0.9, 0.9, 0.176>]
      [0.44 color rgbf<0.7, 0.7, 0.7, 0.655>]
      [0.51 color rgbf<0.5, 0.5, 0.5, 1.000>]
      [0.68 color rgbf<0.8, 0.8, 0.8, 0.773>]
      [0.74 color rgbf<0.7, 0.7, 0.7, 0.467>]
      [0.80 color rgbf<0.5, 0.5, 0.5, 0.247>]
      [0.90 color rgbf<0.9, 0.9, 0.9, 0.200>]
      [1.00 color rgbf<0.7, 0.7, 0.7, 0.741>]
    }
  }
  scale 3  
  finish {crand .1}
  normal {granite 1}
} 


#declare Masonry =
texture {
	brick
	texture {Floor_stone}
	texture{Column_stone} 
	scale <.75,.5,.75>
}

#declare Masonry2 =
texture {
	radial
	texture_map {
		[0.0 Floor_stone]
		[0.1 Floor_stone]
		[0.1 Column_stone]
		[1.0 Column_stone]
	}
	frequency 180
	rotate <90,0,0>
}

#declare Masonry3 =
texture {
	gradient x
	texture_map {
		[0.0 Floor_stone]
		[0.1 Floor_stone]
		[0.1 Column_stone]
		[1.0 Column_stone]
	}
	rotate <0,0,-15>
}

// rusty 
#declare Metal_Tex3 =
texture {
	pigment {
		granite
		color_map {
			[0.0 rgb <.6,.5,.3>]
			[0.5 rgb <.4,.2,.2>]
			[1.0 rgb <.5,.3,.1>]
		}
		scale .25
		turbulence .5
	}
	finish {phong .1 phong_size 10}
	normal {bumps .5 scale .01}
}

// bare old metal
#declare Metal_Tex2 =
texture {
	pigment {
		bozo
		color_map {
			[0.0  Gray50]
			[0.25 Gray80]
			[0.57 Gray60]
			[0.65 Gray40]
			[0.88 Gray80]
			[1.0  Gray50]
		}
		scale .1
		turbulence 1
	}
	finish {metallic phong .4 phong_size 5} 
	normal {dents 1 scale .01}
}

// rusty metal
#declare T13_Rust =
texture {
	crackle
	texture_map {
		[0.0 Metal_Tex3]
		[0.05 Metal_Tex3]
		[0.5 Metal_Tex2]
		[1.0 Metal_Tex2]
	}
	scale .1
	turbulence .5
}


#declare T13_Copper1 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.906, 0.663, 0.420>]
      [0.39 color rgb<0.937, 0.745, 0.553>]
      [0.66 color rgb<0.741, 0.561, 0.384>]
      [1.00 color rgb<0.929, 0.816, 0.702>]
    }
  }
  normal
  {
    dents 0.6
    scale <0.5, 0.5, 0.5>
  }
  finish {
    specular 0.41    roughness 0.2    metallic
    phong 1.0    phong_size 21
    reflection 0.6
  }
}  

#declare T13_Copper2 = texture
{
  pigment
  {
    bozo
    turbulence 1.2
    color_map
    {
      [0.00 color rgb<0.906, 0.663, 0.420>]
      [0.39 color rgb<0.937, 0.745, 0.553>]
      [0.66 color rgb<0.741, 0.561, 0.384>]
      [1.00 color rgb<0.929, 0.816, 0.702>]
    }
  }
  normal
  {
    dents 0.6
    scale <0.5, 0.5, 0.5>
  }
  finish {
    metallic
    phong .2    phong_size 5
  }
}

#declare T13_Copper3 =
texture {
	crackle
	texture_map {
		[0.0 T13_Copper2]
		[0.05 T13_Copper2]
		[0.5 T13_Copper1]
		[1.0 T13_Copper1]
	} 
	turbulence .5
	scale <.25,1,.25>
}

#declare T13_Copper4 =
texture {
	crackle
	texture_map {
		[0.0 T13_Copper2]
		[0.05 T13_Copper2]
		[0.5 T13_Copper1]
		[1.0 T13_Copper1]
	} 
	turbulence .5
	scale .25
}