#declare Radiosity_effects 	= on;
#declare Effects_high 		= on; 
#declare Switch_Chains		= on;
#declare Switch_Pipes		= on;
#declare Switch_Homoc		= on;

#include "colors.inc" 
#include "13t_horror.inc"

camera {
        location <50,30,-70>
        look_at  <20,30,0> 
        angle 120
}

light_source {<50,40,-70> 
	color Gray80    
	fade_distance 30
	fade_power 1
}

light_source {<60,200,-80> 
	color White
	fade_distance 100
	fade_power 2
}  

// RADIOSITY
#if (Radiosity_effects = on)
// Constants used by 'rad_def.inc' are set in 'const.inc'
#include "consts.inc"
#if (Effects_high = off)
	#declare Rad_Quality = Radiosity_Debug;
	#else
	#declare Rad_Quality = Radiosity_Normal;
#end
#end

/* THE ARCH */

#declare Arch_part = 
union {

difference {
        box {<-20.37,21.92,3><39.63,53,-3>}
        cylinder {<0,0,4><0,0,-4>,40.99}
        box {<-1,0,4><70,18,-4> rotate <0,0,-15> translate <-20.37,53,0>}
        box {<-25,38,4><-10,23,-4>}
}

difference { 
	cylinder {<0,0,3.1><0,0,-3.1>,43.5 texture{Masonry2}}
	cylinder {<0,0,4><0,0,-4>,40.9 texture{Masonry2}} 
	box {<-20.37,-50,5><-100,50,-5> texture{Masonry2}}
	box {<39.63,-50,5><100,50,-5> texture{Masonry2}} 
	box {<100,-50,5><-100,0,-5> texture{Masonry2}}
}

}

#declare Arch =
union {
object {Arch_part texture{Masonry}}
difference {
        box {<-20.37,36.92,2.20><39.63,55.59,-2.20> texture{Masonry3}}
        box {<-1,0,4><70,18,-4> rotate <0,0,-15> translate <-20.37,55.59,0> texture{Masonry3}}
        box {<-1,0,4><70,-30,-4> rotate <0,0,-15> translate <-20.37,53,0> texture{Masonry3}}
}
box {<-20.37,56.93,2.20><-15.37,54.24,-2.20> texture{Masonry}}
box {<34.63,40.85,2.20><39.63,39.51,-2.20> texture{Masonry}}
}

/* THE COLUMN */

#declare entab1=
union{
        box {<-1.50,0,-1.50><1.50,.50,1.50>}
        box {<-1.65,.50,-1.65><1.65,1.00,1.65>}
        box {<-1.80,1.00,-1.80><1.80,1.75,1.80>}
        box {<-1.95,1.75,-1.95><1.95,1.90,1.95>}
        box {<-2.10,1.90,-2.10><2.10,2.05,2.10>}
        box {<-1.95,2.05,-1.95><1.95,4.45,1.95>}
        box {<-2.10,4.45,-2.10><2.10,4.70,2.10>}
        box {<-2.60,5.20,-2.60><2.60,5.70,2.60>}
        box {<-2.75,5.70,-2.75><2.75,5.85,2.75>}
        box {<-2.90,5.85,-2.90><2.90,6.00,2.90>}
        difference {
                box {<-2.60,4.70,-2.60><2.60,5.20,2.60>}
                box {<0,10,10><10,-10,-10> rotate <0,0,-45> translate <2.10,4.70,0>}
                box {<0,10,10><10,-10,-10> rotate <0,0,-45> translate <2.10,4.70,0> rotate <0,90,0>}
                box {<0,10,10><10,-10,-10> rotate <0,0,-45> translate <2.10,4.70,0> rotate <0,180,0>}
                box {<0,10,10><10,-10,-10> rotate <0,0,-45> translate <2.10,4.70,0> rotate <0,270,0>}
        }
}

#declare entab2=
union{
        box {<-2.00,2.55,-2.00><2.00,2.80,2.00>}
        box {<-1.00,2.30,-2.10><-.50,4.45,2.10>}
        box {<-.25,2.30,-2.10><.25,4.45,2.10>}
        box {<.50,2.30,-2.10><1.00,4.45,2.10>}
        box {<-2.10,2.30,-1.00><2.10,4.45,-.50>}
        box {<-2.10,2.30,-.25><2.10,4.45,.25>}
        box {<-2.10,2.30,.50><2.10,4.45,1.00>}
        box {<-.25,4.70,-2.75><.25,5.55,2.75>}
        box {<-2.75,4.70,-.25><2.75,5.55,.25>}
        box {<-.40,5.55,-2.90><.40,5.70,2.90>}
        box {<-2.90,5.55,-.40><2.90,5.70,.40>}
}

#declare entab=
union{
object {entab1}
object {entab2}
}

#declare column_head=
union{
        difference {
                cylinder {<1.50,.75,1.70><1.50,.75,.50>,.75}
                box {<1.50,1.70,1.80><0,-.30,.40>}
                torus {.625,.15 sturm rotate <90,0,0> translate <1.50,.75,1.70>}
                torus {.375,.15 sturm rotate <90,0,0> translate <1.50,.75,1.70>}
                torus {.125,.15 sturm rotate <90,0,0> translate <1.50,.75,1.70>}
        }
        difference {
                cylinder {<1.50,.625,1.70><1.50,.625,.50>,.625}
                box {<1.50,1.70,1.80><2.50,-.30,.40>}
                torus {.50,.15 sturm rotate <90,0,0> translate <1.50,.625,1.70>}
                torus {.25,.15 sturm rotate <90,0,0> translate <1.50,.625,1.70>}
        }
}

#declare head_half=
union{
        difference {
                box {<-1.50,1.25,1.70><1.50,1.50,.75>}
                cylinder {<-1.75,1.375,1.70><1.75,1.375,1.70>,.15}
        }
        object {column_head}
        object {column_head scale <-1,1,1>}
}

#declare capital=
union {
        object {head_half}
        object {head_half scale <1,1,-1>}
}

#declare cut_out=
merge{
cylinder {<1.50,2.50,0><1.50,21.95,0>,.25}
sphere {<1.50,2.50,0>,.25}
sphere {<1.50,21.95,0>,.25}
sphere {<1.60,23.05,0>,.25}
}

#declare column=
union{
box {<-2.00,0,-2.00><2.00,.50,2.00>}
torus {1.75,.25 sturm translate <0,.75,0>}
cylinder {<0,1.00,0><0,1.15,0>,1.75}
difference {
        cylinder {<0,1.15,0><0,1.55,0>,1.75}
        torus {1.75,.20 sturm translate <0,1.35,0>}
}
cylinder {<0,1.55,0><0,1.70,0>,1.75}
cylinder {<0,1.70,0><0,1.85,0>,1.65}
difference {
        cylinder {<0,1.85,0><0,23.85,0>,1.50}
        object {cut_out}
        object {cut_out rotate <0,22.5,0>}
        object {cut_out rotate <0,45,0>}   
        object {cut_out rotate <0,67.5,0>} 
        object {cut_out rotate <0,90,0>} 
        object {cut_out rotate <0,112.5,0>} 
        object {cut_out rotate <0,135,0>} 
        object {cut_out rotate <0,157.5,0>} 
        object {cut_out rotate <0,180,0>} 
        object {cut_out rotate <0,202.5,0>} 
        object {cut_out rotate <0,225,0>} 
        object {cut_out rotate <0,247.5,0>} 
        object {cut_out rotate <0,270,0>} 
        object {cut_out rotate <0,292.5,0>} 
        object {cut_out rotate <0,315,0>} 
        object {cut_out rotate <0,337.5,0>} 
}   
box {<1.65,23.85,1.65><-1.65,24.00,-1.65>}
object {capital translate <0,22.20,0>}
object {entab translate <0,24.00,0>}
}

// the repeated bay

#declare Bay=
union{
	box {<-78,-400,-3><-66,2000,3> texture{Masonry}} 
	box {<-6,-400,-3><6,2000,3>  texture{Masonry}}    
	box {<66,-400,-3><78,2000,3>  texture{Masonry}}    
	box {<138,-400,-3><150,2000,3>  texture{Masonry}}  

	object {Arch translate <-45.633807,76.297207,0>}
	object {Arch translate <-45.633807,27.369270,0>}
	object {Arch translate <26.366193,8.076929,0>}
	object {Arch translate <26.366193,57.004865,0>}
	object {Arch translate <26.366193,160.00,0>}
	object {Arch translate <98.366193,-11.215413,0>} 
	
	box {<0,-400,-25><6,0,25> texture{Masonry}}
	box {<0,-400,-25><-100,0,25> texture{Masonry rotate <90,0,0>}}

	box {<-66,-400,2.50><-61.50,35.399293,-2.50> texture{Masonry}}
	box {<-10.50,-400,2.50><-6,19.292342,-2.50> texture{Masonry}}
	box {<6,-400,2.50><10.50,16.076952,-2.50> texture{Masonry}}
	box {<61.50,-400,2.50><66,0,-2.50> texture{Masonry}}
	box {<78,-400,2.50><82.50,-3.21539,-2.50> texture{Masonry}}

	object {column rotate <0,90,0> translate <-64.00,35.369293,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <-64.00,84.297230,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <-8.00,19.292342,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <-8.00,68.220278,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <8.00,16.076952,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <8.00,65.004888,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <64.00,0,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <64.00,48.927936,0> texture{Masonry scale .75}}
	object {column rotate <0,90,0> translate <80.00,-3.21539,0> texture{Masonry scale .75}}


}

object {Bay translate <0,0,-50>}
object {Bay}
object {Bay translate <0,0,50>}
object {Bay translate <0,0,100>}
object {Bay translate <0,0,150>}
object {Bay translate <0,0,200>}
object {Bay translate <0,0,250>}
object {Bay translate <0,0,300>}
object {Bay translate <0,0,350>}
object {Bay translate <0,0,400>}
object {Bay translate <0,0,450>}
object {Bay translate <0,0,500>} 

box {<-72,-40,-600><-80,200,600> pigment{Black} finish {reflection 1}}

// chains and stuff

#if (Switch_Chains = on)

cylinder {<57,20,-59><57,40,-59>,1 texture{T13_Copper3}} 

cylinder {<57,32,-59><57,35,-59>,1.1 texture{T13_Copper3}}
#include "handle.inc"       

#declare Hand_Set =
union {
	object {Handle1 translate <0,0,-3>} 
	
	cylinder {<0,0,0><0,0,-2>,.8 texture{T13_Copper4}} 
	
	difference {
		cylinder {<0,0,0><0,0,-3.5>,.2 texture{T13_Copper4}}
		
		cylinder {<0,1,-3.5><0,-1,-3.5>,.075 rotate <0,0,45> texture{T13_Copper4}}
	}
	
}

object {Hand_Set rotate <0,45,0> translate <57,33.5,-59>} 

#declare Logo_Set =
union {                      
	cylinder {<0,0,0><0,3,0>,1.1}  
	difference {
		cylinder {<0,1.5,0><0,1.5,-1.5>,1} 
		cylinder {<0,1.5,1><0,1.5,-2>,.8}
	}
	cylinder {<0,1.5,0><0,1.5,-1.3>,.8 texture{T13_Copper1}}  
	
	text { ttf             
  		"artistik.ttf",  
  		"13",    
  		1,             
  		0
  		scale 1.5 
  		translate <-.5,1,-1.4>       
	}
}

object {Logo_Set texture{T13_Copper4} rotate <0,45,0> translate <57,23,-59>}

// COMMON LINK OPTION
// ******************
   #declare link_looseness = 1.5;
   #declare camera_sky = <0.001,1,0>;
   #include "LINKOBJS.INC"  
   
   #declare link_object = Iron_Chain
   #declare link_count = 50;
   #declare link_twist = .475;
   #declare link_point1 = <55,50,-60>;
   #declare link_point2 = <55,0,-60>;
   #include "LINK.INC" 
   
   #declare link_object = Gold_Chain
   #declare link_count = 30;
   #declare link_twist = .475;
   #declare link_point1 = <55.5,37,-62>;
   #declare link_point2 = <55.5,23,-62>;
   #include "LINK.INC"  
   
   #declare link_looseness = 18;
   #declare link_object = Iron_Chain
   #declare link_count = 200;
   #declare link_twist = .475;
   #declare link_point1 = <0,70,-60>;
   #declare link_point2 = <25,70,-60>;
   #include "LINK.INC" 
   
   #declare link_looseness = 5;
   #declare link_object = Iron_Chain
   #declare link_count = 200;
   #declare link_twist = .475;
   #declare link_point1 = <30,50,-40>;
   #declare link_point2 = <30,50,-70>;
   #include "LINK.INC"  

#end
   
// pipe stuff   

#if (Switch_Pipes = on)

#declare nDeco=7;
#declare Deco=array[nDeco]
#include "pipedeco.inc"

#declare Cage=union{
	#include "Pipe_1.inc"
	#include "Pipe_2.inc"
	texture{T13_Copper4 scale 10}
}

object {Cage translate <-40,20,0>}  
object {Cage rotate <0,0,90> translate <-70,100,-40>}

#include "pipe_3.inc"

object {Pipe_Set1 scale 2 translate <5,0,-58.5>}
object {Pipe_Set1 scale 2 translate <5,0,-15>} 

object {Pipe_Set1 scale 2 translate <48,-40,-10>} 
object {Pipe_Set1 scale 2 translate <48,-40,5>}

#end

// homoculus cage

#if (Switch_Homoc = on)

#include "hom2.inc" 
object {Homoculus_Cage translate <38,10,-23>}

#end

// lower floor

box {<0,-50,25><40,-100,-35> texture{Masonry rotate <90,0,0>}}

box {<50,-40,25><40,-100,-35> texture{Masonry}} 
box {<50,-40,25><0,-100,35> texture{Masonry}}

box {<0,-45,25><40,-41,-35>
	texture{pigment{rgbf<.8,.7,.3,.6>}} 
	interior {ior 1.3}
	finish {phong .2 reflection .3} 
	normal {dents .2}
}

#declare Ladder_Rung =
union {
	difference {
		union {
			torus {1,.25}
			torus {1,.25 translate <0,0,2>}
		}
		box {<-2,-2,0><2,2,2>}
	}
	cylinder {<1,0,0><1,0,2>,.25}
	
	cylinder {<0,0,-1><.2,0,-1>,.5}
	cylinder {<0,0,3><.2,0,3>,.5}
}   

object {Ladder_Rung scale 2 translate <6,-1,-40> texture{T13_Rust scale 2}}
object {Ladder_Rung scale 2 translate <6,-6,-40> texture{T13_Rust scale 2}}
object {Ladder_Rung scale 2 translate <6,-11,-40> texture{T13_Rust scale 2}}
object {Ladder_Rung scale 2 translate <6,-16,-40> texture{T13_Rust scale 2}}
object {Ladder_Rung scale 2 translate <6,-21,-40> texture{T13_Rust scale 2}} 
object {Ladder_Rung scale 2 translate <6,-26,-40> texture{T13_Rust scale 2}}
object {Ladder_Rung scale 2 translate <6,-31,-40> texture{T13_Rust scale 2}}
object {Ladder_Rung scale 2 translate <6,-36,-40> texture{T13_Rust scale 2}}
	

// eof
