// LINK INCLUDE FILE: SAMPLE LINK OBJECTS
// **************************************
// This file includes a variety of link objects which can be used with
// Link.inc:
//
//    Gold_Chain - can be used to create a fine, golden chain
//    Iron_Chain - can be used to create a heavy, iron chain
//    Rope - can be used to create a thick rope
//    Candy_Cane - when used with the link_twist option, this object
//                 can create a candy-cane like link.  Note that for the
//                 best results you should use a small link_size value
//                 (or a large link_count value).
//    Snake - creates a surface somewhat like snake scales
//    Spikes - can be used to create a spiked chrome wire/chain
//    RailWay - can be used to create rail tracks
//    Beads - can create strings of coloured beads
//    Bubbles - when used with the link_size_turb and link_twist_turb
//              option, this object can create a chain of soap bubbles

#declare Gold_Chain = torus {.6, .1 scale <1, 1, .7>

	texture {T13_Rust scale 5}

//   pigment {rgb <.9, .7, .3>} finish {phong .8 phong_size 120 metallic reflection .6}
}

#declare Iron_Chain = union {
   torus {.7, .3 clipped_by {box {<-1, -.3, -1>, <0, .3, 1>}} translate -x * .6}
   torus {.7, .3 clipped_by {box {<-1, -.3, -1>, <0, .3, 1>}} translate -x * .6 scale <-1, 1, 1>}
   cylinder {-x*.6, x*.6, .3 translate z * .7}
   cylinder {-x*.6, x*.6, .3 translate -z * .7}

   texture {T13_Rust scale 5}	

//   pigment {rgb <.4, .4, .45>} normal {dents .6 scale .3} finish {phong .3 phong_size 10 metallic}

   scale .5}

#declare Rope = sphere {<0, 0, 0>, 1
   pigment {wrinkles color_map {[0 rgb <.6, .4, .2>] [1 rgb <.5, .4, .1>]}}
   normal {radial .75 frequency 11 scallop_wave rotate z * 90 warp {turbulence .2 octaves 2 lambda 4}}
   scale <.9, 1.1, 1.1>}

#declare Candy_Cane = union {
   sphere {<0, 2, 0>, 3 pigment {rgb <1, 0, 0>}}
   sphere {<0, -2, 0>, 3 pigment {rgb <1, 1, 1>}}}

#declare Snake = union {
   #declare R = 0; #while (R < 360) sphere {y * 1.2, 1 rotate x * R} #declare R = R + (360/7); #end
   pigment {gradient y color_map {[0 rgb <.5, .7, .3>] [1 rgb <0, .3, .2>]} scale 2.3}
   finish {phong .2 phong_size 40}}

#declare Spikes = union {
   cone {<0, 0, 0>, .5, <0, 3, 0>, 0}
   sphere {<0, 0, 0>, 1 scale <1, .5, .5>}
   pigment {rgb <.7, .7, .65>}
   finish {phong .9 phong_size 5 metallic reflection .8}}

#declare RailWay = union {
   box {<-.25, 0, -1.5>, <.25, .3, 1.5>
      pigment {wood color_map {[0 rgb <.5, .35, .2>] [1 rgb <.3, .2, .1>]} scale .03 rotate <5, 15, 0>}}
   union {
      box {<-.55, .3, -1>, <.55, .6, -.8>} box {<-.55, .3, .8>, <.55, .6, 1>}
      pigment {rgb <.4, .4, .4>} normal {dents 1 scale .5} finish {phong .2}}}

#declare Beads = union {
   sphere {x * -.2, .3 pigment {rgb <1, .6, .1>} finish {phong .4}}
   sphere {x * .3, .15 pigment {rgb <1, .3, .8>} finish {phong .4}}
   cylinder {x * -.55, x * .55, .01 pigment {rgb .7}}
   }

#declare Bubbles = sphere {<0, .6, .3>, .6
   pigment {rgbt <1, 1, 1, .95>}
   finish {phong .6 phong_size 105 reflection .2 irid {.2 thickness .2 turbulence .2}}}
