//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 17 materials and 1146 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 10/12/1999    (12.10.1999)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.392> }

camera {  //  Camera StdCam
  location  <     -5.351,      24.069,      26.301>
  direction <        0.0,         0.0,      1.1267> // Aperture is 0.84 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      7.699,     -32.512,      16.340>
}

//    Other cameras are commented out.
/*
camera {  //  Camera testMcam
  location  <      1.000,      -8.000,       5.000>
  direction <        0.0,         0.0,      1.6612> // Aperture is 0.58 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.083,       0.419,       2.009>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <-2.108, 49.426, 17.145>
  color rgb <0.829, 1.000, 1.000>*0.8000
  shadowless
  media_interaction off
}

light_source {   // Light001
  <-0.012, -29.507, 21.292>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  MATERIALS  *******
//

#include "cinema-scene.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare BezPtch008 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt23 = union {
  cone { // Cone277
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch008 }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.4
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <7.450323, -17.326344, -4.628963>
}




//
// ********  OBJECTS  *******
//

union { // leafs
  object { Blatt23 }
  object { // Blatt22->Blatt23
    Blatt23
    rotate <5.813466, 3.871074, -96.793343>
    translate  <20.826866, -12.374681, 2.159621>
  }
  object { // Blatt21->Blatt23
    Blatt23
    rotate <-3.188866, -3.947224, 115.210785>
    translate  <-6.140259, -29.153159, -1.435379>
  }
  rotate 0.0*x
  translate  <0.0, 16.679913, 4.351282>
  scale 2.0
  translate  <10.582516, -30.904714, -5.381341>
}


union { // popMcluster
  sphere { // Sphere060
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <-180.0, -80.0, 40.0>
    translate  <35.919458, 30.790319, 0.6635>
  }
  sphere { // Sphere059
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <-180.0, -80.0, 50.0>
    translate  <35.992495, 30.892702, 0.386167>
  }
  sphere { // Sphere058
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <-180.0, -80.0, 60.0>
    translate  <36.156308, 30.580434, 0.386167>
  }
  sphere { // Sphere057
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <-180.0, -80.0, 70.0>
    translate  <35.833801, 30.611149, 0.386167>
  }
  rotate <0.0, 0.0, -0.0>
  translate  <-35.948438, -30.649402, -0.418479>
  rotate <-0.0, -90.770538, 0.0>
  translate  <-4.97809, 7.245491, 20.33378>
}


#declare ribcageMleft = union {
  torus { // Torus026
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.178551, 1.805179, -5.12764>
  }
  torus { // Torus027
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.297019, 1.575937, -6.197968>
  }
  torus { // Torus028
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.181722, 2.001243, -3.90566>
  }
  torus { // Torus029
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.057331, 2.114087, -2.466968>
  }
  torus { // Torus030
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.999426, 2.20132, -1.078089>
  }
  torus { // Torus031
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.067741, 2.226013, -1.794035>
  }
  scale <1.0, -0.9, 1.0>
  rotate 3.609034*z
  translate  <-0.072292, -0.04536, -0.143374>
}
#declare ribcageMright = union {
  torus { // Torus032
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.238894, 1.790511, -4.974797>
  }
  torus { // Torus033
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.183365, 1.511926, -6.147021>
  }
  torus { // Torus034
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.168194, 1.921746, -3.863626>
  }
  torus { // Torus035
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.070659, 2.196042, -2.502768>
  }
  torus { // Torus036
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.910663, 2.344694, -1.01272>
  }
  torus { // Torus037
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.959827, 2.376283, -1.757957>
  }
  scale <1.0, 0.9, 1.0>
  rotate -2.686408*z
  translate  <-0.16194, 0.776374, -0.191991>
}
#declare backhorn3 = union {
  cone { // Cone039
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere251
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone040
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1390
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1391
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <-4.982898, -122.199158, -13.006399>
  translate  <2.991861, -2.831935, -0.52784>
}
#declare backhorn2 = union {
  cone { // Cone037
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere252
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone038
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1392
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1393
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, -0.966641, 0.897271>
  rotate <-5.282954, -123.897797, -11.708396>
  translate  <3.149146, -2.3936, -4.01965>
}
#declare backhorn1 = union {
  cone { // Cone035
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere253
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone036
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1394
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1395
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <3.189699, 2.342453, -4.170216>
}
#declare backhorn = union {
  cone { // Cone034
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere254
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone033
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1396
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1397
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <2.984451, 2.908959, -0.876936>
}
#declare torso = union {
  sphere { // Sphere242
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.431978, 3.640435, -1.571137>
    translate  <0.755961, 0.0, -9.936281>
  }
  sphere { // Sphere243
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.562611, -1.577748, 2.681785>
    rotate <0.0, -7.330361, -0.0>
    translate  <0.28956, -0.0, -9.564097>
  }
  cylinder { // Cylndr1380
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.12583, -0.742838, -11.504373>
    rotate -4.594381*y
    translate  <-1.109086, 0.0, 1.943899>
  }
  object { ribcageMleft }
  object { ribcageMright }
  cylinder { // Cylndr1381
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <12.646627, -7.665387, 8.324436>
    translate  <-0.660863, -2.517925, -2.905298>
  }
  cylinder { // Cylndr1382
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <171.665756, -175.767288, 182.595764>
    translate  <-0.966044, 2.1511, -2.495622>
  }
  sphere { // Sphere244
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.745076, 1.770083, -4.747586>
    rotate <4.042048, 0.185979, 0.521351>
    translate  <0.010811, 2.614042, -5.087942>
  }
  sphere { // Sphere245
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.678328, 1.883597, -5.076229>
    rotate <-1.562712, 0.189786, -0.485653>
    translate  <-0.018209, -2.140103, -5.208063>
  }
  cylinder { // Cylndr1383
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.219531, 0.612627, -9.652758>
    rotate -3.6973*y
    translate  0.390831*x
  }
  cylinder { // Cylndr1384
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.601077, -2.034538, -9.141262>
    rotate <5.172945, -4.044183, -8.660601>
    translate  <0.252768, -1.941129, -0.484216>
  }
  cylinder { // Cylndr1385
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.830165, 1.902151, -9.160878>
    rotate <-2.637861, 0.249879, 11.201634>
    translate  <0.252768, 1.738915, -0.387373>
  }
  sphere { // Sphere246
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <-1.064826, -2.428671, -2.510869>
    rotate -9.444944*z
    translate  <-0.534124, 2.386924, -1.936865>
  }
  sphere { // Sphere247
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.091671, -2.311246, -2.764631>
    rotate 8.449643*z
    translate  <-0.333828, -1.865268, -1.936865>
  }
  sphere { // Sphere248
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.30654, 2.177789, -5.763244>
    translate  <-0.073603, 0.0, -3.776887>
  }
  cylinder { // Cylndr1386
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    translate  <1.001483, -0.034691, -0.861696>
  }
  cylinder { // Cylndr1387
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate <15.484534, -0.0, -0.0>
    translate  <-0.534124, 1.457883, -0.861696>
  }
  cylinder { // Cylndr1388
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate -12.639755*x
    translate  <-0.467359, -1.483702, -0.861696>
  }
  cylinder { // Cylndr1389
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <1.0, 1.0, 3.0>
    translate  -0.861696*z
  }
  sphere { // Sphere249
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, -2.723392, 1.107712>
    rotate 6.808063*x
    translate  <0.0, -3.23136, -0.215424>
  }
  sphere { // Sphere250
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, 2.723392, 1.107712>
    rotate -4.840706*x
    translate  <0.0, 3.123648, -0.215424>
  }
  object { backhorn3 }
  object { backhorn2 }
  object { backhorn1 }
  object { backhorn }
  torus { // Torus038
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.418202, 1.180507>
    rotate <-44.0, 16.0, -167.0>
    translate  <-0.468104, 2.281597, -1.017244>
  }
  torus { // Torus065
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.342479, 1.247094>
    rotate <44.496597, 16.266319, 167.285858>
    translate  <-0.539582, -2.22596, -0.894328>
  }
  torus { // Torus066
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <-64.350632, -197.359482, -170.857941>
    translate  <1.035453, -2.369653, -9.84021>
  }
  torus { // Torus067
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <65.47683, 21.784595, -0.944939>
    translate  <1.034414, 2.657424, -9.785606>
  }
  torus { // Torus068
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, 1.220737, 1.808289>
    rotate <-32.536304, -193.641876, -169.694855>
    translate  <0.710842, -3.17749, -11.183852>
  }
  torus { // Torus069
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, -1.220737, 1.808289>
    rotate <32.536301, -193.641876, -169.694855>
    translate  <0.777046, 3.689119, -11.086957>
  }
  rotate 0.0*y
  translate  <-1.013394, 0.0, 9.373898>
  scale <1.5, 1.1, 1.5>
  rotate <0.0, -13.581846, -180.0>
  translate  <-4.601911, 0.111723, 9.845346>
}
#declare basicMlimb4 = union {
  sphere { // Sphere255
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1398
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1399
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1400
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1401
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1402
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere256
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere257
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere258
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere259
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart4 = union {
  sphere { // Sphere269
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere270
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1412
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1413
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone012
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart4 = union {
  sphere { // Sphere271
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere272
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1414
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1415
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger4 = union {
  object { fingerMlowerMpart4 }
  object { fingerMpart4 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart5 = union {
  sphere { // Sphere273
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere274
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1416
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1417
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone013
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart5 = union {
  sphere { // Sphere275
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere276
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1418
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1419
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger5 = union {
  object { fingerMlowerMpart5 }
  object { fingerMpart5 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart6 = union {
  sphere { // Sphere277
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere278
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1420
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1421
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone014
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart6 = union {
  sphere { // Sphere279
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere280
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1422
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1423
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger6 = union {
  object { fingerMlowerMpart6 }
  object { fingerMpart6 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart7 = union {
  sphere { // Sphere281
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere282
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1424
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1425
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone015
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart7 = union {
  sphere { // Sphere283
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere284
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1426
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1427
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger7 = union {
  object { fingerMlowerMpart7 }
  object { fingerMpart7 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand1 = union {
  sphere { // Sphere265
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1408
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere266
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere267
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1409
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1410
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1411
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere268
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger4 }
  object { finger5 }
  object { finger6 }
  object { finger7 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.59683, 0.117826, -0.181062>
}
#declare basicMlimb5 = union {
  sphere { // Sphere260
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1403
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1404
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1405
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1406
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1407
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere261
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere262
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere263
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere264
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone011
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand1 }
  rotate <-190.374329, -149.529099, 187.794266>
}
#declare basicMarmMleft = union {
  object { basicMlimb4 }
  object { basicMlimb5 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale -0.8
  rotate <157.287582, -8.568952, -157.326843>
  translate  <0.207494, 5.447027, 22.500708>
}
#declare basicMlimb1 = union {
  sphere { // Sphere285
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1428
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1429
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1430
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1431
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1432
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere286
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere287
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere288
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere289
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart = union {
  sphere { // Sphere299
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere300
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1442
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1443
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone007
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart = union {
  sphere { // Sphere301
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere302
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1444
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1445
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger = union {
  object { fingerMlowerMpart }
  object { fingerMpart }
  rotate <35.438938, -5.488492, -1.079493>
}
#declare fingerMlowerMpart1 = union {
  sphere { // Sphere303
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere304
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1446
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1447
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone008
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart1 = union {
  sphere { // Sphere305
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere306
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1448
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1449
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger1 = union {
  object { fingerMlowerMpart1 }
  object { fingerMpart1 }
  rotate <23.532076, 4.955722, 3.205281>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart2 = union {
  sphere { // Sphere307
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere308
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1450
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1451
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone009
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart2 = union {
  sphere { // Sphere309
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere310
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1452
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1453
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger2 = union {
  object { fingerMlowerMpart2 }
  object { fingerMpart2 }
  rotate <17.833134, -4.972438, -1.68526>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart3 = union {
  sphere { // Sphere311
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere312
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1454
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1455
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone010
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart3 = union {
  sphere { // Sphere313
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere314
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1456
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1457
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger3 = union {
  object { fingerMlowerMpart3 }
  object { fingerMpart3 }
  rotate <-70.608345, -108.136642, 8.678893>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand = union {
  sphere { // Sphere295
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1438
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere296
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere297
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1439
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1440
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1441
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere298
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger }
  object { finger1 }
  object { finger2 }
  object { finger3 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <89.412956, -246.545654, 78.155556>
  translate  <8.696018, -0.056512, -0.223852>
}
#declare basicMlimb = union {
  sphere { // Sphere290
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1433
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1434
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1435
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1436
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1437
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere291
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere292
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere293
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere294
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand }
  rotate <-150.192078, -144.849197, 193.12645>
}
#declare basicMarmMright = union {
  object { basicMlimb1 }
  object { basicMlimb }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale 0.8
  rotate <178.942154, -211.201981, 183.075974>
  translate  <0.055141, -5.405216, 22.731882>
}
#declare CSG001 = difference {
  sphere { // Sphere315
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <4.25028, 11.680179, 3.325953>
    rotate <-0.196035, -0.0, -0.0>
    translate  <-0.0, 5.874081, -0.157509>
  }
  sphere { // Sphere316
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <5.349308, 9.944535, 4.791598>
    rotate -2.533771*x
    translate  <0.149241, 3.538993, -3.332989>
  }
  scale <1.166423, 1.1, 1.144323>
  rotate 0.684455*x
  translate  <-0.0, 2.075105, -0.253283>
}
#declare teethMupperMleft1 = union {
  cone { // Cone048
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone049
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone050
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone051
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone052
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone053
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone054
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone055
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone056
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone057
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright1 = union {
  cone { // Cone058
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone059
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone060
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone061
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone062
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone063
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone064
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone065
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone066
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone067
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone068
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMlower = union {
  object { teethMupperMleft1 }
  object { teethMupperMright1 }
  scale -1.0
  rotate <7.41871, 0.0, -180.0>
  translate  <0.0, 0.20296, -4.886318>
}
#declare teethMupperMleft = union {
  cone { // Cone030
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone031
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone032
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone041
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone042
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone043
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone044
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone045
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone046
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone047
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright = union {
  cone { // Cone028
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone027
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone029
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone026
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone025
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone024
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone023
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone022
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone006
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone005
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMupper = union {
  object { teethMupperMleft }
  object { teethMupperMright }
}
#declare headMx = union {
  sphere { // Sphere321
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.270821, 1.487489, 2.59577>
    rotate -62.072033*x
    translate  <0.0, -1.195858, -0.233674>
  }
  sphere { // Sphere322
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <2.0, 1.658326, 2.0>
    rotate -90.0*x
    translate  <0.0, 13.325275, 0.0>
  }
  torus { // Torus072
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  11.195858*y
  }
  torus { // Torus073
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  9.195858*y
  }
  torus { // Torus074
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  7.195858*y
  }
  torus { // Torus075
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  5.195858*y
  }
  torus { // Torus076
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  3.195858*y
  }
  torus { // Torus077
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  1.195858*y
  }
  cylinder { // Cylndr1463
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 0.658326, 13.075064>
    rotate -90.0*x
  }
  scale <1.823368, 1.192647, 0.952494>
  translate  <-0.0, 0.555383, 0.18012>
}
#declare headMinterior = union {
  object { teethMlower }
  object { teethMupper }
  sphere { // Sphere317
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.279829, 3.013228, 0.691975>
    rotate 10.305234*x
    translate  <0.0, 2.850586, -3.530883>
  }
  cylinder { // Cylndr1458
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.639969, -0.189462, 2.421683>
    translate  <1.750329, -2.022552, -2.360624>
  }
  cylinder { // Cylndr1459
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.590279, 0.101221, -2.999959>
    translate  <-1.731603, -1.888632, -2.360624>
  }
  sphere { // Sphere318
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.715117, 3.552059, 0.626342>
    rotate -4.058217*x
    translate  <0.0, -0.284982, -3.303354>
  }
  sphere { // Sphere319
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.839486, 2.366695, 0.735887>
    translate  <0.0, -2.050042, -0.683347>
  }
  torus { // Torus070
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.145908, 1.126128, 0.95174>
    rotate -19.642107*x
    translate  <0.0, -2.73339, -1.537532>
  }
  torus { // Torus071
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.15546, 0.996368, 0.875845>
    rotate 6.707807*x
    translate  <0.0, -2.562553, -3.075063>
  }
  sphere { // Sphere320
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.0, 0.847587, 2.885885>
    rotate -68.325066*x
    translate  <0.0, 8.679306, -2.166905>
  }
  cylinder { // Cylndr1460
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.621841, 0.964178, 8.980318>
    rotate -90.0*x
    translate  <0.031092, -1.879205, -2.500708>
  }
  cylinder { // Cylndr1461
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <1.368051, 2.904227, -1.117958>
  }
  cylinder { // Cylndr1462
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <-1.368051, 2.904227, -1.117958>
  }
  object { headMx }
}
#declare head = union {
  object { CSG001 }
  object { headMinterior }
  scale <0.6, 0.8, 0.8>
  rotate <-8.869848, 0.339446, 91.046371>
  translate  <3.443233, 0.051678, 28.800424>
}
#declare tailMseg4 = union {
  sphere { // Sphere323
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone094
    <0,0,0>, 0.0, <0,0,1>, 0.8
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone095
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.541516, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.076768, -1.995904>
  }
  cone { // Cone096
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.336995, -0.1877, -0.651453>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 0.787325, -2.373694>
  }
  cone { // Cone097
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.285301, -0.097924, -0.690062>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 0.606552, -3.05747>
  }
  torus { // Torus078
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.387161, 0.529998, 0.55242>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus079
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.470708, 0.590001, 0.599762>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone099
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.618626, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.207862, -1.206992>
  }
  translate  <0.0, 0.081209, -0.153672>
  scale 0.2401
  translate  <-0.0, -0.019498, -10.177797>
}
#declare tailMseg3 = union {
  sphere { // Sphere324
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone088
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.018093, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone089
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus080
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.503471, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus081
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.539657, 0.607, 0.607239>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus082
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.575842, 0.643, 0.640606>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone090
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone091
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone092
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus083
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus084
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone093
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.343
  translate  <0.0, 0.0, -8.799636>
}
#declare tailMpartM1 = union {
  object { tailMseg4 }
  object { tailMseg3 }
  rotate 0.0*x
  translate  <-0.0, 0.023283, 8.800973>
  rotate <-31.292847, 0.0, -0.0>
  translate  <0.0, -0.023283, -8.800973>
}
#declare tailMseg2 = union {
  sphere { // Sphere325
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone082
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone083
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus085
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.491709, 0.569774, 0.57679>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus086
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.542822, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus087
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone084
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone085
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone086
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus088
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus089
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone087
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.49
  translate  <0.0, 0.0, -6.825016>
}
#declare tailMpartM2 = union {
  object { tailMpartM1 }
  object { tailMseg2 }
  rotate -0.0*x
  translate  <-0.0, -0.008138, 6.841223>
  rotate <145.207321, -245.240997, 100.418365>
  translate  <0.0, 0.008138, -6.841223>
}
#declare tailMseg1 = union {
  sphere { // Sphere326
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone076
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone077
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus090
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus091
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus092
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone078
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone079
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone080
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus093
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus094
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone081
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.7
  translate  <0.0, 0.0, -3.996833>
}
#declare tailMpartM3 = union {
  object { tailMpartM2 }
  object { tailMseg1 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-0.0, -0.048121, 3.977207>
  rotate <63.436512, -39.948841, -32.007793>
  translate  <0.0, 0.073518, -3.72317>
}
#declare tailMseg = union {
  sphere { // Sphere327
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone070
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone072
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus095
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus096
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus097
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone073
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone074
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone075
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus098
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus099
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone071
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
}
#declare tail = union {
  object { tailMpartM3 }
  object { tailMseg }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.076435, -0.065365>
  scale <1.214286, 1.7, 2.833333>
  rotate <134.710983, -18.567162, 99.970016>
  translate  <-6.403084, -0.252203, 6.594411>
}
#declare upperMbody = union {
  object { torso }
  object { basicMarmMleft }
  object { basicMarmMright }
  object { head }
  object { tail }
  rotate <-4.351486, 2.086776, -2.302046>
  translate  <-2.274868, 0.0, -1.624906>
}
#declare corn = union {
  sphere { // Sphere028
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -80.0, 80.0>
    translate  <-0.051298, -0.489271, 0.386167>
  }
  sphere { // Sphere027
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <90.0, -90.0, 0.0>
    translate  <0.135864, -0.313478, 0.474069>
  }
  sphere { // Sphere026
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -80.0, -80.0>
    translate  <0.309794, 0.048824, 0.493602>
  }
  sphere { // Sphere025
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -70.0, -70.0>
    translate  <0.051298, 0.333001, 0.454535>
  }
  sphere { // Sphere024
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -60.0, -60.0>
    translate  <0.121443, -0.407121, 0.593752>
  }
  sphere { // Sphere023
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -50.0, -50.0>
    translate  <-0.187162, -0.048824, 0.493602>
  }
  sphere { // Sphere022
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -50.0, 50.0>
    translate  <-0.206105, -0.469103, 0.173371>
  }
  sphere { // Sphere021
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -60.0, 60.0>
    translate  <0.037593, -0.588676, 0.202672>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -70.0, 70.0>
    translate  <0.245981, -0.265401, 0.241739>
  }
  sphere { // Sphere019
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -80.0, 80.0>
    translate  <0.499058, -0.06886, 0.241739>
  }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <90.0, -90.0, 0.0>
    translate  <0.314841, 0.174838, 0.241739>
  }
  sphere { // Sphere017
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -80.0, -80.0>
    translate  <0.206582, 0.588548, 0.261272>
  }
  sphere { // Sphere016
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -70.0, -70.0>
    translate  <-0.068385, 0.342762, 0.21166>
  }
  sphere { // Sphere015
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -60.0, -60.0>
    translate  <-0.466585, 0.314841, 0.229476>
  }
  sphere { // Sphere014
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -50.0, -50.0>
    translate  <-0.372673, -0.009089, 0.220374>
  }
  sphere { // Sphere013
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -40.0, -40.0>
    translate  <-0.733797, -0.005245, -0.04029>
  }
  sphere { // Sphere012
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -70.0, 70.0>
    translate  <0.243354, -0.758657, -0.04029>
  }
  sphere { // Sphere011
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -80.0, 80.0>
    translate  <0.366529, -0.439418, -0.04029>
  }
  sphere { // Sphere010
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <90.0, -90.0, 0.0>
    translate  <0.702379, -0.27449, -0.04029>
  }
  sphere { // Sphere009
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -80.0, -80.0>
    translate  <0.73905, 0.125716, -0.04029>
  }
  sphere { // Sphere008
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -70.0, -70.0>
    translate  <0.478631, 0.327316, -0.04029>
  }
  sphere { // Sphere007
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -60.0, -60.0>
    translate  <0.313703, 0.682773, -0.04029>
  }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -50.0, -50.0>
    translate  <-0.04729, 0.621412, -0.04029>
  }
  sphere { // Sphere005
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -40.0, -40.0>
    translate  <-0.366529, 0.655089, -0.04029>
  }
  sphere { // Sphere004
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -30.0, -30.0>
    translate  <-0.64356, 0.392128, -0.04029>
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -20.0, -20.0>
    translate  <-0.52338, -0.302174, -0.04029>
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <-0.0, -10.0, -10.0>
    translate  <-0.419812, -0.641018, -0.04029>
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    translate  <-0.078426, -0.702379, -0.04029>
  }
  translate  3.109262*z
}
#declare popMbox = union {
  object { corn }
  cone { // Cone268
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      stripes
    }
    scale <1.0, 1.0, 3.0>
  }
  torus { // Torus023
    1.5, 0.1  rotate -x*90
    material {
      singleMstripe
    }
    scale <0.7, 0.7, 1.0>
    translate  3.021735*z
  }
  scale 2.0
  rotate <-0.0, 0.0, 122.71936>
  translate  <8.62201, -0.667287, 12.372674>
}
#declare alien = union {
  object { upperMbody }
  object { popMbox }
  scale 0.4
  rotate -122.71936*z
  translate  <3.038317, 10.752286, 13.843457>
}
#declare ribcageMleft1 = union {
  torus { // Torus100
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.178551, 1.805179, -5.12764>
  }
  torus { // Torus101
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.297019, 1.575937, -6.197968>
  }
  torus { // Torus102
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.181722, 2.001243, -3.90566>
  }
  torus { // Torus124
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.057331, 2.114087, -2.466968>
  }
  torus { // Torus125
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.999426, 2.20132, -1.078089>
  }
  torus { // Torus126
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.067741, 2.226013, -1.794035>
  }
  scale <1.0, -0.9, 1.0>
  rotate 3.609034*z
  translate  <-0.072292, -0.04536, -0.143374>
}
#declare ribcageMright1 = union {
  torus { // Torus127
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.238894, 1.790511, -4.974797>
  }
  torus { // Torus128
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.183365, 1.511926, -6.147021>
  }
  torus { // Torus129
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.168194, 1.921746, -3.863626>
  }
  torus { // Torus130
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.070659, 2.196042, -2.502768>
  }
  torus { // Torus131
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.910663, 2.344694, -1.01272>
  }
  torus { // Torus132
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.959827, 2.376283, -1.757957>
  }
  scale <1.0, 0.9, 1.0>
  rotate -2.686408*z
  translate  <-0.16194, 0.776374, -0.191991>
}
#declare backhorn4 = union {
  cone { // Cone069
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere337
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone098
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1474
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1475
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <-4.982898, -122.199158, -13.006399>
  translate  <2.991861, -2.831935, -0.52784>
}
#declare backhorn5 = union {
  cone { // Cone100
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere338
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone101
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1476
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1477
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, -0.966641, 0.897271>
  rotate <-5.282954, -123.897797, -11.708396>
  translate  <3.149146, -2.3936, -4.01965>
}
#declare backhorn6 = union {
  cone { // Cone102
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere339
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone103
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1478
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1479
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <3.189699, 2.342453, -4.170216>
}
#declare backhorn7 = union {
  cone { // Cone104
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere340
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone105
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1480
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1481
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <2.984451, 2.908959, -0.876936>
}
#declare torso1 = union {
  sphere { // Sphere328
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.431978, 3.640435, -1.571137>
    translate  <0.755961, 0.0, -9.936281>
  }
  sphere { // Sphere329
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.562611, -1.577748, 2.681785>
    rotate <0.0, -7.330361, -0.0>
    translate  <0.28956, -0.0, -9.564097>
  }
  cylinder { // Cylndr1464
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.12583, -0.742838, -11.504373>
    rotate -4.594381*y
    translate  <-1.109086, 0.0, 1.943899>
  }
  object { ribcageMleft1 }
  object { ribcageMright1 }
  cylinder { // Cylndr1465
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <12.646627, -7.665387, 8.324436>
    translate  <-0.660863, -2.517925, -2.905298>
  }
  cylinder { // Cylndr1466
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <171.665756, -175.767288, 182.595764>
    translate  <-0.966044, 2.1511, -2.495622>
  }
  sphere { // Sphere330
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.745076, 1.770083, -4.747586>
    rotate <4.042048, 0.185979, 0.521351>
    translate  <0.010811, 2.614042, -5.087942>
  }
  sphere { // Sphere331
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.678328, 1.883597, -5.076229>
    rotate <-1.562712, 0.189786, -0.485653>
    translate  <-0.018209, -2.140103, -5.208063>
  }
  cylinder { // Cylndr1467
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.219531, 0.612627, -9.652758>
    rotate -3.6973*y
    translate  0.390831*x
  }
  cylinder { // Cylndr1468
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.601077, -2.034538, -9.141262>
    rotate <5.172945, -4.044183, -8.660601>
    translate  <0.252768, -1.941129, -0.484216>
  }
  cylinder { // Cylndr1469
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.830165, 1.902151, -9.160878>
    rotate <-2.637861, 0.249879, 11.201634>
    translate  <0.252768, 1.738915, -0.387373>
  }
  sphere { // Sphere332
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <-1.064826, -2.428671, -2.510869>
    rotate -9.444944*z
    translate  <-0.534124, 2.386924, -1.936865>
  }
  sphere { // Sphere333
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.091671, -2.311246, -2.764631>
    rotate 8.449643*z
    translate  <-0.333828, -1.865268, -1.936865>
  }
  sphere { // Sphere334
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.30654, 2.177789, -5.763244>
    translate  <-0.073603, 0.0, -3.776887>
  }
  cylinder { // Cylndr1470
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    translate  <1.001483, -0.034691, -0.861696>
  }
  cylinder { // Cylndr1471
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate <15.484534, -0.0, -0.0>
    translate  <-0.534124, 1.457883, -0.861696>
  }
  cylinder { // Cylndr1472
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate -12.639755*x
    translate  <-0.467359, -1.483702, -0.861696>
  }
  cylinder { // Cylndr1473
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <1.0, 1.0, 3.0>
    translate  -0.861696*z
  }
  sphere { // Sphere335
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, -2.723392, 1.107712>
    rotate 6.808063*x
    translate  <0.0, -3.23136, -0.215424>
  }
  sphere { // Sphere336
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, 2.723392, 1.107712>
    rotate -4.840706*x
    translate  <0.0, 3.123648, -0.215424>
  }
  object { backhorn4 }
  object { backhorn5 }
  object { backhorn6 }
  object { backhorn7 }
  torus { // Torus133
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.418202, 1.180507>
    rotate <-44.0, 16.0, -167.0>
    translate  <-0.468104, 2.281597, -1.017244>
  }
  torus { // Torus134
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.342479, 1.247094>
    rotate <44.496597, 16.266319, 167.285858>
    translate  <-0.539582, -2.22596, -0.894328>
  }
  torus { // Torus135
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <-64.350632, -197.359482, -170.857941>
    translate  <1.035453, -2.369653, -9.84021>
  }
  torus { // Torus136
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <65.47683, 21.784595, -0.944939>
    translate  <1.034414, 2.657424, -9.785606>
  }
  torus { // Torus137
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, 1.220737, 1.808289>
    rotate <-32.536304, -193.641876, -169.694855>
    translate  <0.710842, -3.17749, -11.183852>
  }
  torus { // Torus138
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, -1.220737, 1.808289>
    rotate <32.536301, -193.641876, -169.694855>
    translate  <0.777046, 3.689119, -11.086957>
  }
  rotate 0.0*y
  translate  <-1.013394, 0.0, 9.373898>
  scale <1.5, 1.1, 1.5>
  rotate <0.0, -13.581846, -180.0>
  translate  <-4.601911, 0.111723, 9.845346>
}
#declare basicMlimb6 = union {
  sphere { // Sphere341
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1482
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1483
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1484
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1485
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1486
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere342
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere343
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere344
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere345
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart8 = union {
  sphere { // Sphere355
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere356
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1496
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1497
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone017
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart8 = union {
  sphere { // Sphere357
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere358
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1498
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1499
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger8 = union {
  object { fingerMlowerMpart8 }
  object { fingerMpart8 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart9 = union {
  sphere { // Sphere359
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere360
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1500
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1501
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone018
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart9 = union {
  sphere { // Sphere361
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere362
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1502
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1503
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger9 = union {
  object { fingerMlowerMpart9 }
  object { fingerMpart9 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart10 = union {
  sphere { // Sphere363
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere364
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1504
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1505
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone019
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart10 = union {
  sphere { // Sphere365
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere366
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1506
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1507
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger10 = union {
  object { fingerMlowerMpart10 }
  object { fingerMpart10 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart11 = union {
  sphere { // Sphere367
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere368
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1508
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1509
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone020
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart11 = union {
  sphere { // Sphere369
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere370
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1510
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1511
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger11 = union {
  object { fingerMlowerMpart11 }
  object { fingerMpart11 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand2 = union {
  sphere { // Sphere351
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1492
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere352
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere353
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1493
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1494
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1495
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere354
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger8 }
  object { finger9 }
  object { finger10 }
  object { finger11 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.59683, 0.117826, -0.181062>
}
#declare basicMlimb7 = union {
  sphere { // Sphere346
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1487
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1488
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1489
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1490
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1491
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere347
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere348
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere349
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere350
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone016
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand2 }
  rotate <-204.169037, -143.69548, 192.675323>
}
#declare basicMarmMleft1 = union {
  object { basicMlimb6 }
  object { basicMlimb7 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale -0.8
  rotate <170.631714, -8.235018, -170.591888>
  translate  <0.207494, 5.447027, 22.500708>
}
#declare basicMlimb2 = union {
  sphere { // Sphere371
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1512
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1513
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1514
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1515
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1516
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere372
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere373
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere374
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere375
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart12 = union {
  sphere { // Sphere385
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere386
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1526
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1527
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone021
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart12 = union {
  sphere { // Sphere387
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere388
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1528
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1529
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger12 = union {
  object { fingerMlowerMpart12 }
  object { fingerMpart12 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart13 = union {
  sphere { // Sphere389
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere390
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1530
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1531
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone106
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart13 = union {
  sphere { // Sphere391
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere392
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1532
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1533
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger13 = union {
  object { fingerMlowerMpart13 }
  object { fingerMpart13 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart14 = union {
  sphere { // Sphere393
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere394
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1534
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1535
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone107
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart14 = union {
  sphere { // Sphere395
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere396
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1536
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1537
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger14 = union {
  object { fingerMlowerMpart14 }
  object { fingerMpart14 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart15 = union {
  sphere { // Sphere397
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere398
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1538
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1539
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone108
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart15 = union {
  sphere { // Sphere399
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere400
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1540
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1541
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger15 = union {
  object { fingerMlowerMpart15 }
  object { fingerMpart15 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand3 = union {
  sphere { // Sphere381
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1522
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere382
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere383
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1523
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1524
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1525
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere384
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger12 }
  object { finger13 }
  object { finger14 }
  object { finger15 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.696018, -0.056512, -0.223852>
}
#declare basicMlimb3 = union {
  sphere { // Sphere376
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1517
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1518
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1519
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1520
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1521
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere377
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere378
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere379
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere380
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand3 }
  rotate <-150.455215, -156.036163, 179.265594>
}
#declare basicMarmMright1 = union {
  object { basicMlimb2 }
  object { basicMlimb3 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale 0.8
  rotate <163.70462, -227.336044, 174.132141>
  translate  <0.055141, -5.405216, 22.731882>
}
#declare CSG002 = difference {
  sphere { // Sphere401
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <4.25028, 11.680179, 3.325953>
    rotate <-0.196035, -0.0, -0.0>
    translate  <-0.0, 5.874081, -0.157509>
  }
  sphere { // Sphere402
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <5.349308, 9.944535, 4.791598>
    rotate -2.533771*x
    translate  <0.149241, 3.538993, -3.332989>
  }
  scale <1.166423, 1.1, 1.144323>
  rotate 0.684455*x
  translate  <-0.0, 2.075105, -0.253283>
}
#declare teethMupperMleft2 = union {
  cone { // Cone109
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone110
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone111
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone112
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone113
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone114
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone115
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone116
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone117
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone118
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright2 = union {
  cone { // Cone119
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone120
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone121
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone122
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone123
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone124
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone125
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone126
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone127
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone128
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone129
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMlower1 = union {
  object { teethMupperMleft2 }
  object { teethMupperMright2 }
  scale -1.0
  rotate <7.41871, 0.0, -180.0>
  translate  <0.0, 0.20296, -4.886318>
}
#declare teethMupperMleft3 = union {
  cone { // Cone130
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone131
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone132
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone133
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone134
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone135
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone136
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone137
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone138
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone139
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright3 = union {
  cone { // Cone140
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone141
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone142
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone143
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone144
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone145
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone146
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone147
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone148
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone149
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone150
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMupper1 = union {
  object { teethMupperMleft3 }
  object { teethMupperMright3 }
}
#declare headMx1 = union {
  sphere { // Sphere407
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.270821, 1.487489, 2.59577>
    rotate -62.072033*x
    translate  <0.0, -1.195858, -0.233674>
  }
  sphere { // Sphere408
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <2.0, 1.658326, 2.0>
    rotate -90.0*x
    translate  <0.0, 13.325275, 0.0>
  }
  torus { // Torus141
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  11.195858*y
  }
  torus { // Torus142
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  9.195858*y
  }
  torus { // Torus143
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  7.195858*y
  }
  torus { // Torus144
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  5.195858*y
  }
  torus { // Torus145
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  3.195858*y
  }
  torus { // Torus146
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  1.195858*y
  }
  cylinder { // Cylndr1547
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 0.658326, 13.075064>
    rotate -90.0*x
  }
  scale <1.823368, 1.192647, 0.952494>
  translate  <-0.0, 0.555383, 0.18012>
}
#declare headMinterior1 = union {
  object { teethMlower1 }
  object { teethMupper1 }
  sphere { // Sphere403
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.279829, 3.013228, 0.691975>
    rotate 10.305234*x
    translate  <0.0, 2.850586, -3.530883>
  }
  cylinder { // Cylndr1542
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.639969, -0.189462, 2.421683>
    translate  <1.750329, -2.022552, -2.360624>
  }
  cylinder { // Cylndr1543
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.590279, 0.101221, -2.999959>
    translate  <-1.731603, -1.888632, -2.360624>
  }
  sphere { // Sphere404
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.715117, 3.552059, 0.626342>
    rotate -4.058217*x
    translate  <0.0, -0.284982, -3.303354>
  }
  sphere { // Sphere405
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.839486, 2.366695, 0.735887>
    translate  <0.0, -2.050042, -0.683347>
  }
  torus { // Torus139
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.145908, 1.126128, 0.95174>
    rotate -19.642107*x
    translate  <0.0, -2.73339, -1.537532>
  }
  torus { // Torus140
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.15546, 0.996368, 0.875845>
    rotate 6.707807*x
    translate  <0.0, -2.562553, -3.075063>
  }
  sphere { // Sphere406
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.0, 0.847587, 2.885885>
    rotate -68.325066*x
    translate  <0.0, 8.679306, -2.166905>
  }
  cylinder { // Cylndr1544
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.621841, 0.964178, 8.980318>
    rotate -90.0*x
    translate  <0.031092, -1.879205, -2.500708>
  }
  cylinder { // Cylndr1545
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <1.368051, 2.904227, -1.117958>
  }
  cylinder { // Cylndr1546
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <-1.368051, 2.904227, -1.117958>
  }
  object { headMx1 }
}
#declare head1 = union {
  object { CSG002 }
  object { headMinterior1 }
  scale <0.6, 0.8, 0.8>
  rotate <-8.869848, 0.339446, 91.046371>
  translate  <3.443233, 0.051678, 28.800424>
}
#declare tailMseg5 = union {
  sphere { // Sphere409
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone151
    <0,0,0>, 0.0, <0,0,1>, 0.8
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone152
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.541516, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.076768, -1.995904>
  }
  cone { // Cone153
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.336995, -0.1877, -0.651453>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 0.787325, -2.373694>
  }
  cone { // Cone154
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.285301, -0.097924, -0.690062>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 0.606552, -3.05747>
  }
  torus { // Torus147
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.387161, 0.529998, 0.55242>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus148
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.470708, 0.590001, 0.599762>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone155
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.618626, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.207862, -1.206992>
  }
  translate  <0.0, 0.081209, -0.153672>
  scale 0.2401
  translate  <-0.0, -0.019498, -10.177797>
}
#declare tailMseg6 = union {
  sphere { // Sphere410
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone156
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.018093, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone157
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus149
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.503471, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus150
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.539657, 0.607, 0.607239>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus151
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.575842, 0.643, 0.640606>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone158
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone159
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone160
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus152
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus153
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone161
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.343
  translate  <0.0, 0.0, -8.799636>
}
#declare tailMpartM4 = union {
  object { tailMseg5 }
  object { tailMseg6 }
  rotate 0.0*x
  translate  <-0.0, 0.023283, 8.800973>
  rotate <-31.292847, 0.0, -0.0>
  translate  <0.0, -0.023283, -8.800973>
}
#declare tailMseg7 = union {
  sphere { // Sphere411
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone162
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone163
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus154
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.491709, 0.569774, 0.57679>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus155
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.542822, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus156
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone164
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone165
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone166
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus157
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus158
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone167
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.49
  translate  <0.0, 0.0, -6.825016>
}
#declare tailMpartM5 = union {
  object { tailMpartM4 }
  object { tailMseg7 }
  rotate -0.0*x
  translate  <-0.0, -0.008138, 6.841223>
  rotate <145.207321, -245.240997, 100.418365>
  translate  <0.0, 0.008138, -6.841223>
}
#declare tailMseg8 = union {
  sphere { // Sphere412
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone168
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone169
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus159
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus160
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus161
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone170
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone171
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone172
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus162
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus163
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone173
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.7
  translate  <0.0, 0.0, -3.996833>
}
#declare tailMpartM6 = union {
  object { tailMpartM5 }
  object { tailMseg8 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-0.0, -0.048121, 3.977207>
  rotate <63.436512, -39.948841, -32.007793>
  translate  <0.0, 0.073518, -3.72317>
}
#declare tailMseg9 = union {
  sphere { // Sphere413
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone174
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone175
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus164
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus165
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus166
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone176
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone177
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone178
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus167
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus168
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone179
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
}
#declare tail1 = union {
  object { tailMpartM6 }
  object { tailMseg9 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.076435, -0.065365>
  scale <1.214286, 1.7, 2.833333>
  rotate <134.710983, -18.567162, 99.970016>
  translate  <-6.403084, -0.252203, 6.594411>
}
#declare upperMbody1 = union {
  object { torso1 }
  object { basicMarmMleft1 }
  object { basicMarmMright1 }
  object { head1 }
  object { tail1 }
  rotate <-4.351486, 2.086776, -2.302046>
  translate  <-2.274868, 0.0, -1.624906>
}
#declare alien1 = union {
  object { upperMbody1 }
  scale 0.4
  rotate -71.619019*z
  translate  <-7.879434, 9.991788, 12.023918>
}
#declare ribcageMleft2 = union {
  torus { // Torus169
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.178551, 1.805179, -5.12764>
  }
  torus { // Torus170
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.297019, 1.575937, -6.197968>
  }
  torus { // Torus171
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.181722, 2.001243, -3.90566>
  }
  torus { // Torus172
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.057331, 2.114087, -2.466968>
  }
  torus { // Torus173
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.999426, 2.20132, -1.078089>
  }
  torus { // Torus174
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.067741, 2.226013, -1.794035>
  }
  scale <1.0, -0.9, 1.0>
  rotate 3.609034*z
  translate  <-0.072292, -0.04536, -0.143374>
}
#declare ribcageMright2 = union {
  torus { // Torus175
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.9, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.238894, 1.790511, -4.974797>
  }
  torus { // Torus176
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.284391, 0.8, 0.801005>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.183365, 1.511926, -6.147021>
  }
  torus { // Torus177
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.31599, 1.0, 0.890006>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.168194, 1.921746, -3.863626>
  }
  torus { // Torus178
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.347589, 1.1, 0.979007>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-1.070659, 2.196042, -2.502768>
  }
  torus { // Torus179
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.910663, 2.344694, -1.01272>
  }
  torus { // Torus180
    2.25, 0.25  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.365042, 1.155231, 1.028163>
    rotate <8.101063, -29.239931, -15.349557>
    translate  <-0.959827, 2.376283, -1.757957>
  }
  scale <1.0, 0.9, 1.0>
  rotate -2.686408*z
  translate  <-0.16194, 0.776374, -0.191991>
}
#declare backhorn8 = union {
  cone { // Cone180
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere423
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone181
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1558
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1559
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <-4.982898, -122.199158, -13.006399>
  translate  <2.991861, -2.831935, -0.52784>
}
#declare backhorn9 = union {
  cone { // Cone182
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere424
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone183
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1560
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1561
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, -0.966641, 0.897271>
  rotate <-5.282954, -123.897797, -11.708396>
  translate  <3.149146, -2.3936, -4.01965>
}
#declare backhorn10 = union {
  cone { // Cone184
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere425
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone185
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1562
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1563
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <3.189699, 2.342453, -4.170216>
}
#declare backhorn11 = union {
  cone { // Cone186
    <0,0,0>, 0.6, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <0.652889, 0.591111, 2.312061>
    rotate <0.0, -15.856109, -0.0>
    translate  <0.673909, 0.0, -2.2239>
  }
  sphere { // Sphere426
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.663045, 0.591111, 0.615445>
  }
  cone { // Cone187
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <1.0, -0.906981, 2.906981>
  }
  cylinder { // Cylndr1564
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.2693, 0.2, 2.381847>
    rotate -26.985752*y
    translate  <0.334546, 0.0, -2.267477>
  }
  cylinder { // Cylndr1565
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.265367, 0.2, 3.128979>
    rotate -5.408974*y
    translate  <-0.743435, 0.0, -0.22303>
  }
  scale <0.61485, 0.966641, 0.897271>
  rotate <4.093906, -123.181404, 11.128835>
  translate  <2.984451, 2.908959, -0.876936>
}
#declare torso2 = union {
  sphere { // Sphere414
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.431978, 3.640435, -1.571137>
    translate  <0.755961, 0.0, -9.936281>
  }
  sphere { // Sphere415
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.562611, -1.577748, 2.681785>
    rotate <0.0, -7.330361, -0.0>
    translate  <0.28956, -0.0, -9.564097>
  }
  cylinder { // Cylndr1548
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.12583, -0.742838, -11.504373>
    rotate -4.594381*y
    translate  <-1.109086, 0.0, 1.943899>
  }
  object { ribcageMleft2 }
  object { ribcageMright2 }
  cylinder { // Cylndr1549
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <12.646627, -7.665387, 8.324436>
    translate  <-0.660863, -2.517925, -2.905298>
  }
  cylinder { // Cylndr1550
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.542229, -1.089456, -6.74746>
    rotate <171.665756, -175.767288, 182.595764>
    translate  <-0.966044, 2.1511, -2.495622>
  }
  sphere { // Sphere416
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.745076, 1.770083, -4.747586>
    rotate <4.042048, 0.185979, 0.521351>
    translate  <0.010811, 2.614042, -5.087942>
  }
  sphere { // Sphere417
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.678328, 1.883597, -5.076229>
    rotate <-1.562712, 0.189786, -0.485653>
    translate  <-0.018209, -2.140103, -5.208063>
  }
  cylinder { // Cylndr1551
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.219531, 0.612627, -9.652758>
    rotate -3.6973*y
    translate  0.390831*x
  }
  cylinder { // Cylndr1552
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.601077, -2.034538, -9.141262>
    rotate <5.172945, -4.044183, -8.660601>
    translate  <0.252768, -1.941129, -0.484216>
  }
  cylinder { // Cylndr1553
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.830165, 1.902151, -9.160878>
    rotate <-2.637861, 0.249879, 11.201634>
    translate  <0.252768, 1.738915, -0.387373>
  }
  sphere { // Sphere418
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <-1.064826, -2.428671, -2.510869>
    rotate -9.444944*z
    translate  <-0.534124, 2.386924, -1.936865>
  }
  sphere { // Sphere419
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.091671, -2.311246, -2.764631>
    rotate 8.449643*z
    translate  <-0.333828, -1.865268, -1.936865>
  }
  sphere { // Sphere420
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.30654, 2.177789, -5.763244>
    translate  <-0.073603, 0.0, -3.776887>
  }
  cylinder { // Cylndr1554
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    translate  <1.001483, -0.034691, -0.861696>
  }
  cylinder { // Cylndr1555
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate <15.484534, -0.0, -0.0>
    translate  <-0.534124, 1.457883, -0.861696>
  }
  cylinder { // Cylndr1556
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 3.0>
    rotate -12.639755*x
    translate  <-0.467359, -1.483702, -0.861696>
  }
  cylinder { // Cylndr1557
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <1.0, 1.0, 3.0>
    translate  -0.861696*z
  }
  sphere { // Sphere421
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, -2.723392, 1.107712>
    rotate 6.808063*x
    translate  <0.0, -3.23136, -0.215424>
  }
  sphere { // Sphere422
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.0, 2.723392, 1.107712>
    rotate -4.840706*x
    translate  <0.0, 3.123648, -0.215424>
  }
  object { backhorn8 }
  object { backhorn9 }
  object { backhorn10 }
  object { backhorn11 }
  torus { // Torus181
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.418202, 1.180507>
    rotate <-44.0, 16.0, -167.0>
    translate  <-0.468104, 2.281597, -1.017244>
  }
  torus { // Torus182
    1.5, 0.6  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <0.838662, 1.342479, 1.247094>
    rotate <44.496597, 16.266319, 167.285858>
    translate  <-0.539582, -2.22596, -0.894328>
  }
  torus { // Torus183
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <-64.350632, -197.359482, -170.857941>
    translate  <1.035453, -2.369653, -9.84021>
  }
  torus { // Torus184
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.0, 1.762706, 1.572567>
    rotate <65.47683, 21.784595, -0.944939>
    translate  <1.034414, 2.657424, -9.785606>
  }
  torus { // Torus185
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, 1.220737, 1.808289>
    rotate <-32.536304, -193.641876, -169.694855>
    translate  <0.710842, -3.17749, -11.183852>
  }
  torus { // Torus186
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    scale <1.040717, -1.220737, 1.808289>
    rotate <32.536301, -193.641876, -169.694855>
    translate  <0.777046, 3.689119, -11.086957>
  }
  rotate 0.0*y
  translate  <-1.013394, 0.0, 9.373898>
  scale <1.5, 1.1, 1.5>
  rotate <0.0, -13.581846, -180.0>
  translate  <-4.601911, 0.111723, 9.845346>
}
#declare basicMlimb8 = union {
  sphere { // Sphere427
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1566
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1567
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1568
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1569
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1570
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere428
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere429
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere430
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere431
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart16 = union {
  sphere { // Sphere441
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere442
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1580
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1581
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone189
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart16 = union {
  sphere { // Sphere443
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere444
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1582
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1583
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger16 = union {
  object { fingerMlowerMpart16 }
  object { fingerMpart16 }
  rotate 5.359898*x
}
#declare fingerMlowerMpart17 = union {
  sphere { // Sphere445
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere446
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1584
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1585
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone190
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart17 = union {
  sphere { // Sphere447
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere448
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1586
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1587
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger17 = union {
  object { fingerMlowerMpart17 }
  object { fingerMpart17 }
  rotate <8.423412, 8.406881, 1.240275>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart18 = union {
  sphere { // Sphere449
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere450
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1588
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1589
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone191
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart18 = union {
  sphere { // Sphere451
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere452
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1590
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1591
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger18 = union {
  object { fingerMlowerMpart18 }
  object { fingerMpart18 }
  rotate <19.317337, -5.2043, -1.797943>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart19 = union {
  sphere { // Sphere453
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere454
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1592
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1593
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone192
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart19 = union {
  sphere { // Sphere455
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere456
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1594
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1595
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger19 = union {
  object { fingerMlowerMpart19 }
  object { fingerMpart19 }
  rotate <54.33197, -39.003738, -122.539757>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand4 = union {
  sphere { // Sphere437
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1576
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere438
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere439
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1577
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1578
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1579
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere440
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger16 }
  object { finger17 }
  object { finger18 }
  object { finger19 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-0.0, 63.990879, 0.0>
  translate  <8.59683, 0.117826, -0.181062>
}
#declare basicMlimb9 = union {
  sphere { // Sphere432
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1571
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1572
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1573
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1574
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1575
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere433
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere434
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere435
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere436
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone188
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand4 }
  rotate <-190.374329, -149.529099, 187.794266>
}
#declare basicMarmMleft2 = union {
  object { basicMlimb8 }
  object { basicMlimb9 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale -0.8
  rotate <-15.355539, -157.445953, -335.992371>
  translate  <0.207494, 5.447027, 22.500708>
}
#declare basicMlimb10 = union {
  sphere { // Sphere457
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1596
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-39.058731, -269.074951, -38.186611>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1597
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <26.370316, -268.800262, 25.834269>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1598
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1599
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <176.157715, -263.389404, 173.706039>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1600
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.8, 0.6, 8.0>
    rotate <187.221924, -263.535645, 186.848358>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere458
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <4.849487, 1.0, 1.0>
    rotate -0.303636*y
    translate  <4.059008, 0.0, 0.447708>
  }
  sphere { // Sphere459
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.387675, 0.666952, -0.181486>
  }
  sphere { // Sphere460
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.200152, -0.724948, -0.282082>
  }
  sphere { // Sphere461
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  scale <0.8, 1.0, 1.2>
  rotate 64.684219*y
  translate  <-2.902059, 0.0, 5.616888>
}
#declare fingerMlowerMpart20 = union {
  sphere { // Sphere471
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere472
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1610
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1611
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone193
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate -53.599339*x
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart20 = union {
  sphere { // Sphere473
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere474
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1612
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1613
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger20 = union {
  object { fingerMlowerMpart20 }
  object { fingerMpart20 }
  rotate <19.605928, -3.32396, 8.486428>
}
#declare fingerMlowerMpart21 = union {
  sphere { // Sphere475
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere476
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1614
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1615
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone194
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-38.692936, -1.5059, -4.851066>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart21 = union {
  sphere { // Sphere477
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere478
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.101187, 0.085932>
    translate  -0.022797*y
  }
  cylinder { // Cylndr1616
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1617
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger21 = union {
  object { fingerMlowerMpart21 }
  object { fingerMpart21 }
  rotate <19.048786, 5.76514, 9.153496>
  translate  <0.242136, 0.0, -0.007882>
}
#declare fingerMlowerMpart22 = union {
  sphere { // Sphere479
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere480
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1618
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1619
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone195
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale 0.8
  rotate <-29.519882, 0.539366, 2.358635>
  translate  <0.0, 0.0, 0.382571>
}
#declare fingerMpart22 = union {
  sphere { // Sphere481
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere482
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.085838>
    translate  <-0.000756, -0.022829, -0.007782>
  }
  cylinder { // Cylndr1620
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1621
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
}
#declare finger22 = union {
  object { fingerMlowerMpart22 }
  object { fingerMpart22 }
  rotate <6.951625, -4.383348, -8.265558>
  translate  <-0.244335, 0.0, -0.015764>
}
#declare fingerMlowerMpart23 = union {
  sphere { // Sphere483
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere484
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  -0.007034*y
  }
  cylinder { // Cylndr1622
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1623
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  cone { // Cone196
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMsmoothM0
    }
    scale <0.0625, 0.0625, 0.375>
    rotate <161.912201, 0.0, -0.0>
    translate  <0.0, 0.114011, 0.792047>
  }
  translate  0.021641*z
  scale <0.8, 0.8, 0.6>
  rotate <-38.322693, -0.397409, -17.358274>
  translate  <0.073375, 0.045342, 0.275655>
}
#declare fingerMpart23 = union {
  sphere { // Sphere485
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.114576, 0.085424, 0.085932>
    translate  <0.0, -0.007034, 0.393893>
  }
  sphere { // Sphere486
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.14, 0.109069, 0.078051>
    translate  <0.0, -0.030679, -0.007882>
  }
  cylinder { // Cylndr1624
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.064576, 0.035424, 0.4>
    translate  <0.004859, -0.053446, 0.0>
  }
  cylinder { // Cylndr1625
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.095141, 0.070848, 0.4>
  }
  scale <1.0, 1.0, 0.6>
  rotate <-10.081417, 13.339588, -16.848455>
  translate  <0.007518, 0.03918, 0.055165>
}
#declare finger23 = union {
  object { fingerMlowerMpart23 }
  object { fingerMpart23 }
  rotate <-39.232018, -124.932007, -50.500912>
  translate  <-0.250219, 0.008313, -0.261804>
}
#declare hand5 = union {
  sphere { // Sphere467
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate <-16.079803, -12.513702, 2.103882>
    translate  <-0.098106, 0.059688, -0.37563>
  }
  cylinder { // Cylndr1606
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.104909, 0.091562, 0.38772>
    rotate <-11.853992, -13.145894, 2.86311>
    translate  <-0.112415, -0.022597, -0.644003>
  }
  sphere { // Sphere468
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate 3.165258*y
    translate  <0.096759, -0.065897, -0.33391>
  }
  sphere { // Sphere469
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <0.093602, 0.070988, 0.371844>
    rotate -2.06301*y
    translate  <-0.116751, -0.065897, -0.355997>
  }
  cylinder { // Cylndr1607
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate -13.92426*y
    translate  <-0.109938, -0.008981, -0.606788>
  }
  cylinder { // Cylndr1608
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    rotate 3.458166*y
    translate  <0.188598, -0.008981, -0.592736>
  }
  cylinder { // Cylndr1609
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMroughM2
    }
    scale <0.122452, 0.073057, 0.582038>
    translate  <0.0, -0.008981, -0.606208>
  }
  sphere { // Sphere470
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <0.279086, 0.093462, 0.246256>
    rotate 7.801773*x
    translate  <0.027523, -0.023706, -0.626461>
  }
  object { finger20 }
  object { finger21 }
  object { finger22 }
  object { finger23 }
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.048773, 0.0, 0.66786>
  scale 4.0
  rotate <-7.897548, 51.331421, -12.522943>
  translate  <8.696018, -0.056512, -0.223852>
}
#declare basicMlimb11 = union {
  sphere { // Sphere462
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.548303, 1.025848, 1.141949>
    translate  <8.206207, -0.116101, -0.18723>
  }
  cylinder { // Cylndr1601
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <-3.179894, -268.524628, 0.213461>
    translate  <0.058051, -0.899784, 0.453616>
  }
  cylinder { // Cylndr1602
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.5, 0.5, 8.0>
    rotate <2.732224, -268.516815, -0.179966>
    translate  <0.0, 0.725632, 0.453616>
  }
  cylinder { // Cylndr1603
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.6, 0.6, 8.0>
    rotate <0.0, 85.483521, 0.0>
    translate  <0.127917, 0.0, -1.407083>
  }
  cylinder { // Cylndr1604
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.816635, -263.743439, 176.809723>
    translate  <0.182584, 0.831458, -0.803586>
  }
  cylinder { // Cylndr1605
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMgridM3
    }
    scale <0.8, 0.6, 8.0>
    rotate <180.177322, -263.825043, 182.130188>
    translate  <0.246543, -0.7675, -0.867544>
  }
  sphere { // Sphere463
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <4.849487, 0.81222, 1.0>
    rotate 1.924396*y
    translate  <3.310089, 0.0, 0.260479>
  }
  sphere { // Sphere464
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, 0.608902, -0.374459>
  }
  sphere { // Sphere465
    <0,0,0>,1
    material {
      alienMskinMgridM3
    }
    scale <1.5, 1.0, 1.5>
    translate  <-0.18723, -0.608847, -0.374459>
  }
  sphere { // Sphere466
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.5, 1.206713, 1.8>
    rotate -2.95065*y
    translate  <0.163363, -0.005908, -0.255833>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      alienMskinMroughM2
    }
    scale <0.748034, 1.0, 2.707683>
    rotate 85.864548*y
    translate  <-3.744592, 0.0, -0.936148>
  }
  object { hand5 }
  rotate <-150.455215, -156.036163, 179.265594>
}
#declare basicMarmMright2 = union {
  object { basicMlimb10 }
  object { basicMlimb11 }
  rotate <0.0, -0.0, -0.0>
  translate  <3.304033, 0.0, -5.955785>
  scale 0.8
  rotate <160.236526, -257.971436, 173.389725>
  translate  <0.055141, -5.405216, 22.731882>
}
#declare CSG003 = difference {
  sphere { // Sphere487
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <4.25028, 11.680179, 3.325953>
    rotate <-0.196035, -0.0, -0.0>
    translate  <-0.0, 5.874081, -0.157509>
  }
  sphere { // Sphere488
    <0,0,0>,1
    material {
      alienMskinMtransM4
    }
    scale <5.349308, 9.944535, 4.791598>
    rotate -2.533771*x
    translate  <0.149241, 3.538993, -3.332989>
  }
  scale <1.166423, 1.1, 1.144323>
  rotate 0.684455*x
  translate  <-0.0, 2.075105, -0.253283>
}
#declare teethMupperMleft4 = union {
  cone { // Cone197
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone198
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone199
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone200
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone201
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone202
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone203
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone204
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone205
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone206
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright4 = union {
  cone { // Cone207
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone208
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone209
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone210
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone211
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone212
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone213
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone214
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone215
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone216
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone217
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMlower2 = union {
  object { teethMupperMleft4 }
  object { teethMupperMright4 }
  scale -1.0
  rotate <7.41871, 0.0, -180.0>
  translate  <0.0, 0.20296, -4.886318>
}
#declare teethMupperMleft5 = union {
  cone { // Cone218
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone219
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone220
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone221
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone222
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone223
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone224
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone225
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone226
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone227
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  scale -1.0
  rotate -180.0*x
}
#declare teethMupperMright5 = union {
  cone { // Cone228
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.199591, -1.055288, -1.89495>
  }
  cone { // Cone229
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.725293, -0.285407, -2.348024>
  }
  cone { // Cone230
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.260747, -0.683397, -1.974904>
  }
  cone { // Cone231
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.777203, -0.625435, -2.188115>
  }
  cone { // Cone232
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.756965, -0.918553, -1.974904>
  }
  cone { // Cone233
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.637054, -1.332131, -1.868298>
  }
  cone { // Cone234
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.437365, -1.686528, -1.814995>
  }
  cone { // Cone235
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-1.205215, -1.978384, -1.687642>
  }
  cone { // Cone236
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.868312, -2.226822, -1.631387>
  }
  cone { // Cone237
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <-0.438785, -2.422112, -1.575132>
  }
  cone { // Cone238
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 10.192531, -0.922603>
    material {
      teeth
    }
    scale <-0.191606, -0.181264, -0.899513>
    rotate <-165.404007, 0.0, 180.0>
    translate  <0.0, -2.526864, -1.575132>
  }
}
#declare teethMupper2 = union {
  object { teethMupperMleft5 }
  object { teethMupperMright5 }
}
#declare headMx2 = union {
  sphere { // Sphere493
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <1.270821, 1.487489, 2.59577>
    rotate -62.072033*x
    translate  <0.0, -1.195858, -0.233674>
  }
  sphere { // Sphere494
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    scale <2.0, 1.658326, 2.0>
    rotate -90.0*x
    translate  <0.0, 13.325275, 0.0>
  }
  torus { // Torus189
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  11.195858*y
  }
  torus { // Torus190
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  9.195858*y
  }
  torus { // Torus191
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  7.195858*y
  }
  torus { // Torus192
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  5.195858*y
  }
  torus { // Torus193
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  3.195858*y
  }
  torus { // Torus194
    1.5, 0.5  rotate -x*90
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
    translate  1.195858*y
  }
  cylinder { // Cylndr1631
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 0.658326, 13.075064>
    rotate -90.0*x
  }
  scale <1.823368, 1.192647, 0.952494>
  translate  <-0.0, 0.555383, 0.18012>
}
#declare headMinterior2 = union {
  object { teethMlower2 }
  object { teethMupper2 }
  sphere { // Sphere489
    <0,0,0>,1
    material {
      alienMskinMrippleM1
    }
    scale <1.279829, 3.013228, 0.691975>
    rotate 10.305234*x
    translate  <0.0, 2.850586, -3.530883>
  }
  cylinder { // Cylndr1626
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.639969, -0.189462, 2.421683>
    translate  <1.750329, -2.022552, -2.360624>
  }
  cylinder { // Cylndr1627
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <0.657987, 0.81126, 8.075064>
    rotate <-86.590279, 0.101221, -2.999959>
    translate  <-1.731603, -1.888632, -2.360624>
  }
  sphere { // Sphere490
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.715117, 3.552059, 0.626342>
    rotate -4.058217*x
    translate  <0.0, -0.284982, -3.303354>
  }
  sphere { // Sphere491
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <1.839486, 2.366695, 0.735887>
    translate  <0.0, -2.050042, -0.683347>
  }
  torus { // Torus187
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.145908, 1.126128, 0.95174>
    rotate -19.642107*x
    translate  <0.0, -2.73339, -1.537532>
  }
  torus { // Torus188
    1.5, 0.3  rotate -x*90
    material {
      alienMskinMrippleM1
    }
    scale <1.15546, 0.996368, 0.875845>
    rotate 6.707807*x
    translate  <0.0, -2.562553, -3.075063>
  }
  sphere { // Sphere492
    <0,0,0>,1
    material {
      alienMskinMroughM2
    }
    scale <2.0, 0.847587, 2.885885>
    rotate -68.325066*x
    translate  <0.0, 8.679306, -2.166905>
  }
  cylinder { // Cylndr1628
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.621841, 0.964178, 8.980318>
    rotate -90.0*x
    translate  <0.031092, -1.879205, -2.500708>
  }
  cylinder { // Cylndr1629
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <1.368051, 2.904227, -1.117958>
  }
  cylinder { // Cylndr1630
    <0,0,1>, <0,0,0>, 1 
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 10.0>
    rotate -90.0*x
    translate  <-1.368051, 2.904227, -1.117958>
  }
  object { headMx2 }
}
#declare head2 = union {
  object { CSG003 }
  object { headMinterior2 }
  scale <0.6, 0.8, 0.8>
  rotate <-10.691661, 1.38918, 110.348022>
  translate  <3.029711, 0.576603, 28.825257>
}
#declare tailMseg10 = union {
  sphere { // Sphere495
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone239
    <0,0,0>, 0.0, <0,0,1>, 0.8
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone240
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.541516, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.076768, -1.995904>
  }
  cone { // Cone241
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.336995, -0.1877, -0.651453>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 0.787325, -2.373694>
  }
  cone { // Cone242
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.285301, -0.097924, -0.690062>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 0.606552, -3.05747>
  }
  torus { // Torus195
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.387161, 0.529998, 0.55242>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus196
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.470708, 0.590001, 0.599762>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone243
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.618626, -0.11, -0.461419>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.207862, -1.206992>
  }
  translate  <0.0, 0.081209, -0.153672>
  scale 0.2401
  translate  <-0.0, -0.019498, -10.177797>
}
#declare tailMseg11 = union {
  sphere { // Sphere496
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone244
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.018093, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone245
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus197
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.503471, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus198
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.539657, 0.607, 0.607239>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus199
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.575842, 0.643, 0.640606>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone246
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone247
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone248
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus200
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus201
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone249
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.343
  translate  <0.0, 0.0, -8.799636>
}
#declare tailMpartM7 = union {
  object { tailMseg10 }
  object { tailMseg11 }
  rotate 0.0*x
  translate  <-0.0, 0.023283, 8.800973>
  rotate <-31.292847, 0.0, -0.0>
  translate  <0.0, -0.023283, -8.800973>
}
#declare tailMseg12 = union {
  sphere { // Sphere497
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone250
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone251
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus202
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.491709, 0.569774, 0.57679>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus203
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.542822, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus204
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone252
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone253
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone254
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus205
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus206
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone255
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.49
  translate  <0.0, 0.0, -6.825016>
}
#declare tailMpartM8 = union {
  object { tailMpartM7 }
  object { tailMseg12 }
  rotate -0.0*x
  translate  <-0.0, -0.008138, 6.841223>
  rotate <145.207321, -245.240997, 100.418365>
  translate  <0.0, 0.008138, -6.841223>
}
#declare tailMseg13 = union {
  sphere { // Sphere498
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone256
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone257
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus207
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus208
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus209
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone258
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone259
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone260
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus210
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus211
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone261
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
  translate  <0.0, -0.0, -0.08188>
  scale 0.7
  translate  <0.0, 0.0, -3.996833>
}
#declare tailMpartM9 = union {
  object { tailMpartM8 }
  object { tailMseg13 }
  rotate <-0.0, 0.0, 0.0>
  translate  <-0.0, -0.048121, 3.977207>
  rotate <63.436512, -39.948841, -32.007793>
  translate  <0.0, 0.073518, -3.72317>
}
#declare tailMseg14 = union {
  sphere { // Sphere499
    <0,0,0>,1
    material {
      alienMskinMrippleMvM1
    }
    rotate -90.0*x
  }
  cone { // Cone262
    <0,0,0>, 0.7, <0,0,1>, 1.0
    material {
      alienMskinMrippleM1
    }
    scale <1.0, 1.0, 4.0>
    translate  -4.0*z
  }
  cone { // Cone263
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.426058, -2.140063>
  }
  torus { // Torus212
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.55, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.927855>
  }
  torus { // Torus213
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.6, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.000285, -3.160382>
  }
  torus { // Torus214
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.65, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -2.312122>
  }
  cone { // Cone264
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.140028, -0.671444>
    rotate <112.749634, 0.0, -180.0>
    translate  <0.022579, 1.39043, -2.867143>
  }
  cone { // Cone265
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.121403, -0.679254>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.264485, -3.715403>
  }
  cone { // Cone266
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.776388, -0.138293, -0.715946>
    rotate <114.71817, 0.0, -180.0>
    translate  <0.0, 1.150121, -4.442483>
  }
  torus { // Torus215
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.593935, 0.7, 0.623922>
    rotate -22.760059*x
    translate  <0.0, 0.040679, -1.544648>
  }
  torus { // Torus216
    1.5, 0.2  rotate -x*90
    material {
      alienMskinMgridM3
    }
    scale <0.676515, 0.740376, 0.710673>
    rotate -22.760059*x
    translate  <0.0, 0.07619, -0.7073>
  }
  cone { // Cone267
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      alienMskinMgridM3
    }
    scale <-0.886943, -0.15771, -0.661551>
    rotate <115.992294, 0.0, -180.0>
    translate  <0.0, 1.466452, -1.332196>
  }
}
#declare tail2 = union {
  object { tailMpartM9 }
  object { tailMseg14 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.076435, -0.065365>
  scale <1.214286, 1.7, 2.833333>
  rotate <128.702225, -12.019544, 98.510849>
  translate  <-6.403084, -0.252203, 6.594411>
}
#declare upperMbody2 = union {
  object { torso2 }
  object { basicMarmMleft2 }
  object { basicMarmMright2 }
  object { head2 }
  object { tail2 }
  rotate <-4.351486, 2.086776, -2.302046>
  translate  <-2.274868, 0.0, -1.624906>
}
#declare corn1 = union {
  sphere { // Sphere029
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -80.0, 80.0>
    translate  <-0.051298, -0.489271, 0.386167>
  }
  sphere { // Sphere030
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <90.0, -90.0, 0.0>
    translate  <0.135864, -0.313478, 0.474069>
  }
  sphere { // Sphere031
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -80.0, -80.0>
    translate  <0.309794, 0.048824, 0.493602>
  }
  sphere { // Sphere032
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -70.0, -70.0>
    translate  <0.051298, 0.333001, 0.454535>
  }
  sphere { // Sphere033
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -60.0, -60.0>
    translate  <0.121443, -0.407121, 0.593752>
  }
  sphere { // Sphere034
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -50.0, -50.0>
    translate  <-0.187162, -0.048824, 0.493602>
  }
  sphere { // Sphere035
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -50.0, 50.0>
    translate  <-0.206105, -0.469103, 0.173371>
  }
  sphere { // Sphere036
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -60.0, 60.0>
    translate  <0.037593, -0.588676, 0.202672>
  }
  sphere { // Sphere037
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -70.0, 70.0>
    translate  <0.245981, -0.265401, 0.241739>
  }
  sphere { // Sphere038
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -80.0, 80.0>
    translate  <0.499058, -0.06886, 0.241739>
  }
  sphere { // Sphere039
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <90.0, -90.0, 0.0>
    translate  <0.314841, 0.174838, 0.241739>
  }
  sphere { // Sphere040
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -80.0, -80.0>
    translate  <0.206582, 0.588548, 0.261272>
  }
  sphere { // Sphere041
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -70.0, -70.0>
    translate  <-0.068385, 0.342762, 0.21166>
  }
  sphere { // Sphere042
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -60.0, -60.0>
    translate  <-0.466585, 0.314841, 0.229476>
  }
  sphere { // Sphere043
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -50.0, -50.0>
    translate  <-0.372673, -0.009089, 0.220374>
  }
  sphere { // Sphere044
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -40.0, -40.0>
    translate  <-0.733797, -0.005245, -0.04029>
  }
  sphere { // Sphere045
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -70.0, 70.0>
    translate  <0.243354, -0.758657, -0.04029>
  }
  sphere { // Sphere046
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <180.0, -80.0, 80.0>
    translate  <0.366529, -0.439418, -0.04029>
  }
  sphere { // Sphere047
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <90.0, -90.0, 0.0>
    translate  <0.702379, -0.27449, -0.04029>
  }
  sphere { // Sphere048
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -80.0, -80.0>
    translate  <0.73905, 0.125716, -0.04029>
  }
  sphere { // Sphere049
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -70.0, -70.0>
    translate  <0.478631, 0.327316, -0.04029>
  }
  sphere { // Sphere050
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -60.0, -60.0>
    translate  <0.313703, 0.682773, -0.04029>
  }
  sphere { // Sphere051
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -50.0, -50.0>
    translate  <-0.04729, 0.621412, -0.04029>
  }
  sphere { // Sphere052
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -40.0, -40.0>
    translate  <-0.366529, 0.655089, -0.04029>
  }
  sphere { // Sphere053
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -30.0, -30.0>
    translate  <-0.64356, 0.392128, -0.04029>
  }
  sphere { // Sphere054
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <0.0, -20.0, -20.0>
    translate  <-0.52338, -0.302174, -0.04029>
  }
  sphere { // Sphere055
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    rotate <-0.0, -10.0, -10.0>
    translate  <-0.419812, -0.641018, -0.04029>
  }
  sphere { // Sphere056
    <0,0,0>,1
    material {
      popcorn
    }
    scale 0.2
    translate  <-0.078426, -0.702379, -0.04029>
  }
  translate  3.109262*z
}
#declare popMbox1 = union {
  object { corn1 }
  cone { // Cone269
    <0,0,0>, 0.8, <0,0,1>, 1.0
    material {
      stripes
    }
    scale <1.0, 1.0, 3.0>
  }
  torus { // Torus024
    1.5, 0.1  rotate -x*90
    material {
      singleMstripe
    }
    scale <0.7, 0.7, 1.0>
    translate  3.021735*z
  }
  scale 2.666667
  rotate <33.41132, -10.584929, 124.365211>
  translate  <-1.671887, -4.854872, 5.324325>
}
#declare alien2 = union {
  object { upperMbody2 }
  object { popMbox1 }
  scale 0.4
  rotate <-0.0, -0.0, -125.926819>
  translate  <-0.204134, -3.833659, 5.339497>
}
union { // family
  object { alien }
  object { alien1 }
  object { alien2 }
}




union { // cinemaMwall
  torus { // Torus109
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  22.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus108
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  22.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus107
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  21.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus106
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  21.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus105
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  20.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus104
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  20.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus103
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  19.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus064
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  19.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus063
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  18.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus062
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  18.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus061
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  18.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus060
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  17.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus059
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  17.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus058
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  16.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus057
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  16.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus056
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  15.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus055
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  15.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus054
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  14.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus053
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  14.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus052
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  13.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus051
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  13.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus050
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  13.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus049
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  12.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus048
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  12.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus047
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  11.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus046
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  11.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus045
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  10.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus044
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  10.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus043
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  9.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus042
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  9.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus041
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  9.0*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus040
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  8.55*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus039
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  8.1*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus022
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  7.65*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus021
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  7.2*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus020
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  6.75*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus019
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  6.3*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus018
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  5.85*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus017
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  5.4*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus016
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  4.95*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus015
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  4.5*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus014
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  4.05*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus013
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  3.6*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus012
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  3.15*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus011
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  2.7*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus010
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  2.25*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus009
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  1.8*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus008
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  1.35*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus007
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  0.9*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus006
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    translate  0.45*z
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  torus { // Torus005
    1.5, 0.05  rotate -x*90
    scale <40.0, 40.0, 5.0>
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  plane { // Plane001
    z,0
    scale <20.0, 20.0, 2.5>
    translate  <-0.829858, -27.00271, 5.723028>
    material {
      alienMhullMroughMglobal
      // Transform to world space
      translate  <-0.829858, 9.9583, 30.0>
      scale <1.0/1.0, 1.0/1.0, 1.0/4.0>
    }
  }
  scale <1.0, 1.0, 4.0>
  translate  <0.829858, -9.9583, -30.0>
}




#declare screenMcorner3 = difference {
  torus { // Torus004
    1.5, 1.0  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    rotate -90.0*x
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    translate  -2.0*z
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    rotate -90.0*y
    translate  -2.0*x
  }
  rotate 90.0*y
  translate  <14.0, 0.0, -8.5>
}
#declare screenMcorner2 = difference {
  torus { // Torus003
    1.5, 1.0  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    rotate -90.0*x
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    translate  -2.0*z
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    rotate -90.0*y
    translate  -2.0*x
  }
  rotate <180.0, 0.0, -180.0>
  translate  <-14.0, 0.0, -8.5>
}
#declare screenMcorner1 = difference {
  torus { // Torus002
    1.5, 1.0  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    rotate -90.0*x
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    translate  -2.0*z
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    rotate -90.0*y
    translate  -2.0*x
  }
  rotate -90.0*y
  translate  <-14.0, 0.0, 8.5>
}
#declare screenMcorner = difference {
  torus { // Torus001
    1.5, 1.0  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    rotate -90.0*x
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    translate  -2.0*z
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      defaultMskin
    }
    scale <4.0, 2.0, 2.0>
    rotate -90.0*y
    translate  -2.0*x
  }
  translate  <14.0, 0.0, 8.5>
}
union { // screenMgroup
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 17.0>
    rotate 180.0*x
    translate  <15.5, 0.0, 8.5>
    material {
      alienMhullMrippleMhMglobal
      // Transform to world space
      translate  <-1.638548, 37.618037, -21.178312>
      scale <1.0/1.7, 1.0/1.0, 1.0/2.1>
    }
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 17.0>
    rotate <180.0, 0.0, -175.0>
    translate  <-15.5, 0.0, 8.5>
    material {
      alienMhullMrippleMhMglobal
      // Transform to world space
      translate  <-1.638548, 37.618037, -21.178312>
      scale <1.0/1.7, 1.0/1.0, 1.0/2.1>
    }
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 28.0>
    rotate -90.0*y
    translate  <14.0, 0.0, -10.0>
    material {
      alienMhullMrippleMhMglobal
      // Transform to world space
      translate  <-1.638548, 37.618037, -21.178312>
      scale <1.0/1.7, 1.0/1.0, 1.0/2.1>
    }
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 28.0>
    rotate -90.0*y
    translate  <14.0, 0.0, 10.0>
    material {
      alienMhullMrippleMhMglobal
      // Transform to world space
      translate  <-1.638548, 37.618037, -21.178312>
      scale <1.0/1.7, 1.0/1.0, 1.0/2.1>
    }
  }
  object { screenMcorner3 }
  object { screenMcorner2 }
  object { screenMcorner1 }
  object { screenMcorner }
  torus { // Torus123
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <8.48169, 0.0, -9.87922>
  }
  torus { // Torus114
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <2.039437, 0.0, 10.041907>
  }
  torus { // Torus113
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-0.960563, 0.0, 10.041907>
  }
  torus { // Torus115
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <5.039437, 0.0, 10.041907>
  }
  torus { // Torus116
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <8.039437, 0.0, 10.041907>
  }
  torus { // Torus117
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-9.51831, 0.0, -9.87922>
  }
  torus { // Torus118
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-6.51831, 0.0, -9.87922>
  }
  torus { // Torus119
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-3.51831, 0.0, -9.87922>
  }
  torus { // Torus120
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-0.51831, 0.0, -9.87922>
  }
  torus { // Torus121
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <2.48169, 0.0, -9.87922>
  }
  torus { // Torus122
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <5.48169, 0.0, -9.87922>
  }
  torus { // Torus112
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-3.960563, 0.0, 10.041907>
  }
  torus { // Torus111
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-6.960563, 0.0, 10.041907>
  }
  torus { // Torus110
    1.5, 0.5  rotate -x*90
    material {
      alienMhullMrippleMvMglobal
    }
    scale <0.75, 1.5, 0.75>
    rotate -90.0*y
    translate  <-9.960563, 0.0, 10.041907>
  }
  box { // cineMscreen
    <-1, -1, -1>, <1, 1, 1>
    material {
      screenMimage
    }
    scale <14.705882, 8.928572, 0.208333>
    rotate <90.0, 0.0, -180.0>
    translate  0.15*z
  }
  scale <1.7, 1.0, 2.1>
  translate  <1.638548, -37.618037, 21.178312>
}


#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.316323, -0.058464, 0.508489>, <0.164796, -0.058464, 0.735456>, <0.199995, -0.051711, 1.077744>, <0.431196, -0.051711, 1.222727>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.902234, -0.049748, 0.567079>, <0.713589, -0.049748, 0.448783>, <0.439959, -0.058464, 0.323300>, <0.316323, -0.058464, 0.508489>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.212851, -0.042017, 1.108256>, <1.345058, -0.042017, 0.910229>, <1.103956, -0.049748, 0.693576>, <0.902234, -0.049748, 0.567079>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.212851, -0.042017, 1.108256>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.047485, -0.042017, 1.355951>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.683513, -0.051711, 1.380951>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.431196, -0.051711, 1.222727>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>, 
      <0.154984, 5.626361, 0.730007>, <0.154984, 5.566828, 0.730007>, <0.155052, 5.486724, 0.720730>, <0.154984, 5.427918, 0.730007>, 
      <0.213551, 5.626361, 1.051520>, <0.213551, 5.566828, 1.051520>, <0.238801, 5.481828, 1.050949>, <0.213551, 5.427918, 1.051520>, 
      <0.444763, 5.626361, 1.196486>, <0.444763, 5.566828, 1.196486>, <0.470013, 5.481828, 1.195915>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>, 
      <0.693530, 5.626361, 0.422904>, <0.693530, 5.566828, 0.422904>, <0.704857, 5.480305, 0.396992>, <0.693530, 5.427918, 0.422904>, 
      <0.430117, 5.626361, 0.317830>, <0.430117, 5.566828, 0.317830>, <0.430185, 5.486724, 0.308554>, <0.430117, 5.427918, 0.317830>, 
      <0.306494, 5.626361, 0.503029>, <0.306494, 5.566828, 0.503029>, <0.306563, 5.486724, 0.493753>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.205451, 5.566828, 1.066661>, <1.234991, 5.473854, 1.042967>, <1.205451, 5.427918, 1.066661>, 
      <1.337643, 5.626361, 0.868624>, <1.337643, 5.566828, 0.868624>, <1.367183, 5.473854, 0.844930>, <1.337643, 5.427918, 0.868624>, 
      <1.083915, 5.626361, 0.667669>, <1.083915, 5.566828, 0.667669>, <1.095242, 5.480305, 0.641757>, <1.083915, 5.427918, 0.667669>, 
      <0.882184, 5.626361, 0.541187>, <0.882184, 5.566828, 0.541187>, <0.893511, 5.480305, 0.515275>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205451, 5.626361, 1.066661>, <1.040103, 5.626361, 1.314368>, <0.697091, 5.626361, 1.354692>, <0.444763, 5.626361, 1.196486>, 
      <1.205451, 5.566828, 1.066661>, <1.040103, 5.566828, 1.314368>, <0.697091, 5.566828, 1.354692>, <0.444763, 5.566828, 1.196486>, 
      <1.234991, 5.473854, 1.042967>, <1.069643, 5.473854, 1.290674>, <0.722341, 5.481828, 1.354121>, <0.470013, 5.481828, 1.195915>, 
      <1.205451, 5.427918, 1.066661>, <1.040103, 5.427918, 1.314368>, <0.697091, 5.427918, 1.354692>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>, 
      <0.346497, 4.594506, 0.671614>, <0.073661, 4.594506, 0.665696>, <-0.053878, 4.594802, 1.057458>, <-0.052002, 4.594802, 1.330351>, 
      <0.306075, 5.069158, 0.559621>, <0.154565, 5.069158, 0.786598>, <0.040898, 5.059296, 1.055421>, <0.272110, 5.059296, 1.200387>, 
      <0.306494, 5.427918, 0.503029>, <0.154984, 5.427918, 0.730007>, <0.213551, 5.427918, 1.051520>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>, 
      <0.781077, 4.594883, 1.125284>, <0.779546, 4.594883, 0.902622>, <0.569112, 4.594506, 0.676443>, <0.346497, 4.594506, 0.671614>, 
      <0.801868, 5.056452, 0.724924>, <0.613214, 5.056452, 0.606641>, <0.429698, 5.069158, 0.374422>, <0.306075, 5.069158, 0.559621>, 
      <0.882184, 5.427918, 0.541187>, <0.693530, 5.427918, 0.422904>, <0.430117, 5.427918, 0.317830>, <0.306494, 5.427918, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>, 
      <0.654951, 4.595179, 1.785078>, <0.892999, 4.595179, 1.790242>, <0.782714, 4.594883, 1.363382>, <0.781077, 4.594883, 1.125284>, 
      <0.959541, 5.045514, 1.263906>, <1.091733, 5.045514, 1.065869>, <1.003599, 5.056452, 0.851406>, <0.801868, 5.056452, 0.724924>, 
      <1.205451, 5.427918, 1.066661>, <1.337643, 5.427918, 0.868624>, <1.083915, 5.427918, 0.667669>, <0.882184, 5.427918, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312168, 4.237260, 1.783163>, <0.654951, 4.595179, 1.785078>, <0.959541, 5.045514, 1.263906>, <1.205451, 5.427918, 1.066661>, 
      <0.014414, 4.237260, 1.776704>, <0.357198, 4.595179, 1.778620>, <0.794193, 5.045514, 1.511613>, <1.040103, 5.427918, 1.314368>, 
      <-0.203806, 4.237260, 1.509005>, <-0.049954, 4.594802, 1.628167>, <0.524439, 5.059296, 1.358594>, <0.697091, 5.427918, 1.354692>, 
      <-0.205854, 4.237260, 1.211188>, <-0.052002, 4.594802, 1.330351>, <0.272110, 5.059296, 1.200387>, <0.444763, 5.427918, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>, 
      <0.105462, 3.463578, 0.850334>, <0.055023, 3.463578, 0.582137>, <-0.340953, 3.483383, 0.584389>, <-0.607601, 3.483383, 0.642467>, 
      <0.265438, 3.898818, 0.770024>, <-0.007397, 3.898818, 0.764106>, <-0.366443, 3.868423, 0.815368>, <-0.364567, 3.868423, 1.088261>, 
      <0.304872, 4.237260, 0.722149>, <0.032037, 4.237260, 0.716231>, <-0.207731, 4.237260, 0.938295>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>, 
      <-0.204841, 3.488257, 1.374467>, <0.012726, 3.488257, 1.327079>, <0.146616, 3.463578, 1.069166>, <0.105462, 3.463578, 0.850334>, 
      <0.371952, 3.860518, 1.336769>, <0.370421, 3.860518, 1.114107>, <0.488054, 3.898818, 0.774853>, <0.265438, 3.898818, 0.770024>, 
      <0.581840, 4.237260, 1.228274>, <0.580309, 4.237260, 1.005612>, <0.527487, 4.237260, 0.726978>, <0.304872, 4.237260, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>, 
      <-0.849194, 3.504386, 1.439758>, <-0.805187, 3.504386, 1.673760>, <-0.437490, 3.488257, 1.425140>, <-0.204841, 3.488257, 1.374467>, 
      <-0.075015, 3.832981, 1.780999>, <0.163032, 3.832981, 1.786163>, <0.373589, 3.860518, 1.574868>, <0.371952, 3.860518, 1.336769>, 
      <0.312168, 4.237260, 1.783163>, <0.550216, 4.237260, 1.788327>, <0.583477, 4.237260, 1.466372>, <0.581840, 4.237260, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.998353, 3.126806, 1.054346>, <-0.849194, 3.504386, 1.439758>, <-0.075015, 3.832981, 1.780999>, <0.312168, 4.237260, 1.783163>, 
      <-1.053398, 3.126806, 0.761653>, <-0.904239, 3.504386, 1.147066>, <-0.372769, 3.832981, 1.774541>, <0.014414, 4.237260, 1.776704>, 
      <-0.836419, 3.126806, 0.492946>, <-0.898602, 3.483383, 0.705849>, <-0.362519, 3.868423, 1.386078>, <-0.203806, 4.237260, 1.509005>, 
      <-0.545418, 3.126806, 0.429564>, <-0.607601, 3.483383, 0.642467>, <-0.364567, 3.868423, 1.088261>, <-0.205854, 4.237260, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>, 
      <-0.128147, 2.415676, 0.651832>, <0.126414, 2.415676, 0.553481>, <0.053531, 2.440944, 0.169666>, <-0.052050, 2.440944, -0.081982>, 
      <-0.023820, 2.814543, 0.808328>, <-0.074258, 2.814543, 0.540130>, <-0.219259, 2.785552, 0.167732>, <-0.485907, 2.785552, 0.225810>, 
      <0.038380, 3.126806, 0.828538>, <-0.012058, 3.126806, 0.560340>, <-0.278770, 3.126806, 0.371486>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>, 
      <-0.697247, 2.446923, 0.443910>, <-0.611100, 2.446923, 0.649238>, <-0.335852, 2.415676, 0.732080>, <-0.128147, 2.415676, 0.651832>, 
      <-0.587640, 2.778548, 1.039500>, <-0.370073, 2.778548, 0.992112>, <0.017335, 2.814543, 1.027160>, <-0.023820, 2.814543, 0.808328>, 
      <-0.399799, 3.126806, 1.203870>, <-0.182232, 3.126806, 1.156482>, <0.079534, 3.126806, 1.047370>, <0.038380, 3.126806, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>, 
      <-0.880560, 2.466101, -0.172718>, <-1.102663, 2.466101, -0.086907>, <-0.789365, 2.446923, 0.224348>, <-0.697247, 2.446923, 0.443910>, 
      <-1.144960, 2.755688, 0.675529>, <-1.100952, 2.755688, 0.909531>, <-0.820290, 2.778548, 1.090173>, <-0.587640, 2.778548, 1.039500>, 
      <-0.998353, 3.126806, 1.054346>, <-0.954346, 3.126806, 1.288347>, <-0.632448, 3.126806, 1.254543>, <-0.399799, 3.126806, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.530548, 2.104019, -0.394332>, <-0.880560, 2.466101, -0.172718>, <-1.144960, 2.755688, 0.675529>, <-0.998353, 3.126806, 1.054346>, 
      <-0.252738, 2.104019, -0.501665>, <-0.602749, 2.466101, -0.280051>, <-1.200004, 2.755688, 0.382836>, <-1.053398, 3.126806, 0.761653>, 
      <0.050935, 2.104019, -0.337146>, <-0.167273, 2.440944, -0.356614>, <-0.776909, 2.785552, 0.289192>, <-0.836419, 3.126806, 0.492946>, 
      <0.166158, 2.104019, -0.062515>, <-0.052050, 2.440944, -0.081982>, <-0.485907, 2.785552, 0.225810>, <-0.545418, 3.126806, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.234524, 1.081232, 0.616299>, <0.551125, 1.081232, 0.697322>, <0.779388, 1.081232, 0.547756>, 
      <0.028194, 1.393687, 0.395892>, <0.171180, 1.393687, 0.628333>, <0.505759, 1.423886, 0.492281>, <0.734022, 1.423886, 0.342715>, 
      <-0.111949, 1.792362, 0.516332>, <0.142612, 1.792362, 0.417981>, <0.489946, 1.767094, 0.208601>, <0.384366, 1.767094, -0.043048>, 
      <-0.120048, 2.104019, 0.584082>, <0.134513, 2.104019, 0.485731>, <0.271739, 2.104019, 0.189134>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>, 
      <0.234524, 1.081232, 0.616299>, <0.300570, 0.755451, 0.603751>, <0.100099, 0.326674, 0.699584>, <0.154975, 0.000000, 0.730010>, 
      <0.551125, 1.081232, 0.697322>, <0.595304, 0.747538, 0.897002>, <0.302425, 0.339953, 0.879182>, <0.213519, 0.000000, 1.051528>, 
      <0.779388, 1.081232, 0.547756>, <0.823568, 0.747538, 0.747436>, <0.533627, 0.339953, 1.024166>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.180330, 1.081232, -0.001283>, <-0.025129, 1.081232, 0.194200>, <0.091538, 1.081232, 0.383857>, 
      <0.125214, 1.431229, -0.176519>, <-0.061034, 1.431229, -0.054483>, <-0.088473, 1.393687, 0.206234>, <0.028194, 1.393687, 0.395892>, 
      <-0.440308, 1.761115, -0.001050>, <-0.354161, 1.761115, 0.204279>, <-0.319654, 1.792362, 0.596580>, <-0.111949, 1.792362, 0.516332>, 
      <-0.568777, 2.104019, 0.221430>, <-0.482630, 2.104019, 0.426758>, <-0.327753, 2.104019, 0.664330>, <-0.120048, 2.104019, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>, 
      <0.180330, 1.081232, -0.001283>, <0.411833, 0.745534, 0.049744>, <0.555172, 0.343419, 0.244602>, <0.693544, 0.000000, 0.422947>, 
      <-0.025129, 1.081232, 0.194200>, <0.040917, 0.755451, 0.181652>, <0.375262, 0.326674, 0.287429>, <0.430138, 0.000000, 0.317854>, 
      <0.091538, 1.081232, 0.383857>, <0.157584, 0.755451, 0.371309>, <0.251626, 0.326674, 0.472618>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.854275, 1.081232, -0.400463>, <0.565737, 1.081232, -0.253815>, <0.366578, 1.081232, -0.123319>, 
      <0.670363, 1.455342, -0.457448>, <0.545608, 1.455342, -0.660252>, <0.324373, 1.431229, -0.307015>, <0.125214, 1.431229, -0.176519>, 
      <-0.180537, 1.741937, -0.615946>, <-0.402640, 1.741937, -0.530136>, <-0.532426, 1.761115, -0.220612>, <-0.440308, 1.761115, -0.001050>, 
      <-0.530548, 2.104019, -0.394332>, <-0.752651, 2.104019, -0.308522>, <-0.660896, 2.104019, 0.001868>, <-0.568777, 2.104019, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.261608, 0.738743, 0.040172>, <1.142527, 0.355497, 0.715488>, <1.205418, 0.000000, 1.066741>, 
      <0.854275, 1.081232, -0.400463>, <1.136853, 0.738743, -0.162632>, <1.274733, 0.355497, 0.517461>, <1.337625, 0.000000, 0.868714>, 
      <0.565737, 1.081232, -0.253815>, <0.797239, 0.745534, -0.202788>, <0.945539, 0.343419, 0.489396>, <1.083911, 0.000000, 0.667741>, 
      <0.366578, 1.081232, -0.123319>, <0.598081, 0.745534, -0.072292>, <0.743817, 0.343419, 0.362899>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <0.670363, 1.455342, -0.457448>, <-0.180537, 1.741937, -0.615946>, <-0.530548, 2.104019, -0.394332>, 
      <1.135075, 1.081232, 0.056011>, <0.826408, 1.455342, -0.203778>, <0.097274, 1.741937, -0.723279>, <-0.252738, 2.104019, -0.501665>, 
      <1.028498, 1.081232, 0.384530>, <0.983133, 1.423886, 0.179489>, <0.269142, 1.767094, -0.317679>, <0.050935, 2.104019, -0.337146>, 
      <0.779388, 1.081232, 0.547756>, <0.734022, 1.423886, 0.342715>, <0.384366, 1.767094, -0.043048>, <0.166158, 2.104019, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.979030, 1.081232, -0.197659>, <1.135075, 1.081232, 0.056011>, <1.028498, 1.081232, 0.384530>, <0.779388, 1.081232, 0.547756>, 
      <1.261608, 0.738743, 0.040172>, <1.417652, 0.738743, 0.293842>, <1.072678, 0.747538, 0.584210>, <0.823568, 0.747538, 0.747436>, 
      <1.142527, 0.355497, 0.715488>, <0.977161, 0.355497, 0.963183>, <0.785944, 0.339953, 1.182390>, <0.533627, 0.339953, 1.024166>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.171607, -0.058008, 0.567566>, <-0.429647, -0.058008, 0.478746>, <-0.748211, -0.046475, 0.605113>, <-0.829626, -0.046475, 0.865585>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.080693, -0.053847, 1.152972>, <-0.014263, -0.053847, 0.940444>, <0.038937, -0.058008, 0.640038>, <-0.171607, -0.058008, 0.567566>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.523592, -0.042839, 1.593553>, <-0.298453, -0.042839, 1.671048>, <-0.151727, -0.053847, 1.380233>, <-0.080693, -0.053847, 1.152972>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.523592, -0.042839, 1.593553>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.805199, -0.042839, 1.496620>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.918477, -0.046475, 1.149846>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.829626, -0.046475, 0.865585>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>, 
      <-0.423778, 5.626361, 0.490812>, <-0.423778, 5.566828, 0.490812>, <-0.430195, 5.486410, 0.499852>, <-0.423778, 5.427918, 0.490812>, 
      <-0.719823, 5.626361, 0.629223>, <-0.719823, 5.566828, 0.629223>, <-0.726450, 5.477662, 0.661250>, <-0.719823, 5.427918, 0.629223>, 
      <-0.801219, 5.626361, 0.889701>, <-0.801219, 5.566828, 0.889701>, <-0.807845, 5.477662, 0.921728>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>, 
      <0.010193, 5.626361, 0.933545>, <0.010193, 5.566828, 0.933545>, <0.025226, 5.483433, 0.948915>, <0.010193, 5.427918, 0.933545>, 
      <0.044818, 5.626361, 0.652071>, <0.044818, 5.566828, 0.652071>, <0.038401, 5.486410, 0.661111>, <0.044818, 5.427918, 0.652071>, 
      <-0.165731, 5.626361, 0.579614>, <-0.165731, 5.566828, 0.579614>, <-0.172148, 5.486410, 0.588654>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.482199, 5.566828, 1.592358>, <-0.463544, 5.474575, 1.624284>, <-0.482199, 5.427918, 1.592358>, 
      <-0.257054, 5.626361, 1.669837>, <-0.257054, 5.566828, 1.669837>, <-0.238399, 5.474575, 1.701764>, <-0.257054, 5.427918, 1.669837>, 
      <-0.127237, 5.626361, 1.373344>, <-0.127237, 5.566828, 1.373344>, <-0.112205, 5.483433, 1.388713>, <-0.127237, 5.427918, 1.373344>, 
      <-0.056220, 5.626361, 1.146078>, <-0.056220, 5.566828, 1.146078>, <-0.041187, 5.483433, 1.161448>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482199, 5.626361, 1.592358>, <-0.763814, 5.626361, 1.495446>, <-0.890049, 5.626361, 1.173969>, <-0.801219, 5.626361, 0.889701>, 
      <-0.482199, 5.566828, 1.592358>, <-0.763814, 5.566828, 1.495446>, <-0.890049, 5.566828, 1.173969>, <-0.801219, 5.566828, 0.889701>, 
      <-0.463544, 5.474575, 1.624284>, <-0.745159, 5.474575, 1.527372>, <-0.896675, 5.477662, 1.205995>, <-0.807845, 5.477662, 0.921728>, 
      <-0.482199, 5.427918, 1.592358>, <-0.763814, 5.427918, 1.495446>, <-0.890049, 5.427918, 1.173969>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>, 
      <-0.089107, 4.594527, 0.386047>, <-0.152773, 4.594527, 0.120678>, <-0.564322, 4.595013, 0.097065>, <-0.827765, 4.595013, 0.168284>, 
      <-0.126297, 5.068491, 0.524063>, <-0.384344, 5.068491, 0.435261>, <-0.669715, 5.051760, 0.387044>, <-0.751111, 5.051760, 0.647522>, 
      <-0.165731, 5.427918, 0.579614>, <-0.423778, 5.427918, 0.490812>, <-0.719823, 5.427918, 0.629223>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>, 
      <-0.417480, 4.594711, 0.921634>, <-0.202528, 4.594711, 0.863524>, <-0.037160, 4.594527, 0.602571>, <-0.089107, 4.594527, 0.386047>, 
      <-0.155195, 5.062406, 1.044886>, <-0.088782, 5.062406, 0.832353>, <0.084253, 5.068491, 0.596519>, <-0.126297, 5.068491, 0.524063>, 
      <-0.056220, 5.427918, 1.146078>, <0.010193, 5.427918, 0.933545>, <0.044818, 5.427918, 0.652071>, <-0.165731, 5.427918, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>, 
      <-1.087756, 4.595149, 0.967504>, <-1.032208, 4.595149, 1.199037>, <-0.647332, 4.594711, 0.983772>, <-0.417480, 4.594711, 0.921634>, 
      <-0.634640, 5.046650, 1.331464>, <-0.409495, 5.046650, 1.408943>, <-0.226213, 5.062406, 1.272152>, <-0.155195, 5.062406, 1.044886>, 
      <-0.482199, 5.427918, 1.592358>, <-0.257054, 5.427918, 1.669837>, <-0.127237, 5.427918, 1.373344>, <-0.056220, 5.427918, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.037597, 4.237260, 0.641823>, <-1.087756, 4.595149, 0.967504>, <-0.634640, 5.046650, 1.331464>, <-0.482199, 5.427918, 1.592358>, 
      <-1.107078, 4.237260, 0.352218>, <-1.157237, 4.595149, 0.677899>, <-0.916254, 5.046650, 1.234552>, <-0.763814, 5.427918, 1.495446>, 
      <-0.903679, 4.237260, 0.073090>, <-1.115267, 4.595013, 0.246007>, <-0.839940, 5.051760, 0.931790>, <-0.890049, 5.427918, 1.173969>, 
      <-0.616177, 4.237260, -0.004633>, <-0.827765, 4.595013, 0.168284>, <-0.751111, 5.051760, 0.647522>, <-0.801219, 5.427918, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>, 
      <0.271064, 3.465083, 0.375612>, <0.517615, 3.465083, 0.258622>, <0.402853, 3.495644, -0.136809>, <0.278870, 3.495644, -0.379918>, 
      <0.058931, 3.896598, 0.344779>, <-0.004735, 3.896598, 0.079410>, <-0.122620, 3.848180, -0.263910>, <-0.386062, 3.848180, -0.192692>, 
      <-0.013327, 4.237260, 0.364922>, <-0.076993, 4.237260, 0.099553>, <-0.352735, 4.237260, -0.075852>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>, 
      <-0.313106, 3.477658, 0.196542>, <-0.211944, 3.477658, 0.394904>, <0.069895, 3.465083, 0.471068>, <0.271064, 3.465083, 0.375612>, 
      <-0.447355, 3.877483, 0.600333>, <-0.232404, 3.877483, 0.542223>, <0.110878, 3.896598, 0.561302>, <0.058931, 3.896598, 0.344779>, 
      <-0.432369, 4.237260, 0.761504>, <-0.217418, 4.237260, 0.703394>, <0.038620, 4.237260, 0.581445>, <-0.013327, 4.237260, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>, 
      <-0.545698, 3.502879, -0.414521>, <-0.760812, 3.502879, -0.312448>, <-0.421281, 3.477658, -0.015569>, <-0.313106, 3.477658, 0.196542>, 
      <-0.981310, 3.835650, 0.276356>, <-0.925762, 3.835650, 0.507889>, <-0.677208, 3.877483, 0.662471>, <-0.447355, 3.877483, 0.600333>, 
      <-1.037597, 4.237260, 0.641823>, <-0.982048, 4.237260, 0.873356>, <-0.662221, 4.237260, 0.823642>, <-0.432369, 4.237260, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.159692, 3.126806, -0.501665>, <-0.545698, 3.502879, -0.414521>, <-0.981310, 3.835650, 0.276356>, <-1.037597, 4.237260, 0.641823>, 
      <0.109377, 3.126806, -0.629339>, <-0.276629, 3.502879, -0.542196>, <-1.050791, 3.835650, -0.013249>, <-1.107078, 4.237260, 0.352218>, 
      <0.424431, 3.126806, -0.487834>, <0.143563, 3.495644, -0.645230>, <-0.673564, 3.848180, -0.114968>, <-0.903679, 4.237260, 0.073090>, 
      <0.559738, 3.126806, -0.222522>, <0.278870, 3.495644, -0.379918>, <-0.386062, 3.848180, -0.192692>, <-0.616177, 4.237260, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>, 
      <0.365100, 2.417655, 0.731806>, <0.524959, 2.417655, 0.952983>, <0.891390, 2.455820, 0.766646>, <1.107911, 2.455820, 0.600536>, 
      <0.370049, 2.812306, 0.506711>, <0.616600, 2.812306, 0.389721>, <0.956934, 2.768021, 0.173693>, <0.832951, 2.768021, -0.069416>, 
      <0.322359, 3.126806, 0.443549>, <0.568910, 3.126806, 0.326559>, <0.683722, 3.126806, 0.020587>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>, 
      <0.437691, 2.433805, 0.127413>, <0.261024, 2.433805, 0.262947>, <0.234666, 2.417655, 0.551341>, <0.365100, 2.417655, 0.731806>, 
      <0.000755, 2.793839, 0.038072>, <0.101918, 2.793839, 0.236433>, <0.168879, 2.812306, 0.602167>, <0.370049, 2.812306, 0.506711>, 
      <-0.152071, 3.126806, 0.115235>, <-0.050909, 3.126806, 0.313596>, <0.121190, 3.126806, 0.539005>, <0.322359, 3.126806, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>, 
      <0.991383, 2.464347, -0.214834>, <0.851907, 2.464347, -0.407810>, <0.626605, 2.433805, -0.017518>, <0.437691, 2.433805, 0.127413>, 
      <0.219055, 2.757805, -0.587170>, <0.003941, 2.757805, -0.485097>, <-0.107420, 2.793839, -0.174039>, <0.000755, 2.793839, 0.038072>, 
      <-0.159692, 3.126806, -0.501665>, <-0.374807, 3.126806, -0.399592>, <-0.260246, 3.126806, -0.096877>, <-0.152071, 3.126806, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151989, 2.104019, 0.147508>, <0.991383, 2.464347, -0.214834>, <0.219055, 2.757805, -0.587170>, <-0.159692, 3.126806, -0.501665>, 
      <1.326447, 2.104019, 0.388885>, <1.165841, 2.464347, 0.026543>, <0.488124, 2.757805, -0.714844>, <0.109377, 3.126806, -0.629339>, 
      <1.244570, 2.104019, 0.724413>, <1.344208, 2.455820, 0.419255>, <0.697644, 2.768021, -0.334728>, <0.424431, 3.126806, -0.487834>, 
      <1.008274, 2.104019, 0.905694>, <1.107911, 2.455820, 0.600536>, <0.832951, 2.768021, -0.069416>, <0.559738, 3.126806, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.224474, 1.081232, 1.042327>, <-0.222313, 1.081232, 1.369123>, <-0.019611, 1.081232, 1.551842>, 
      <0.035153, 1.396006, 0.876905>, <-0.153280, 1.396006, 1.074305>, <0.088221, 1.442306, 1.371879>, <0.290923, 1.442306, 1.554598>, 
      <0.255198, 1.790383, 0.854888>, <0.415056, 1.790383, 1.076065>, <0.692115, 1.752218, 1.376962>, <0.908636, 1.752218, 1.210852>, 
      <0.310149, 2.104019, 0.793347>, <0.470008, 2.104019, 1.014524>, <0.791752, 2.104019, 1.071804>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>, 
      <-0.224474, 1.081232, 1.042327>, <-0.298291, 0.754862, 1.009170>, <-0.390564, 0.327640, 0.558707>, <-0.423769, 0.000000, 0.490773>, 
      <-0.222313, 1.081232, 1.369123>, <-0.513671, 0.742454, 1.366537>, <-0.506757, 0.348832, 0.809677>, <-0.719824, 0.000000, 0.629163>, 
      <-0.019611, 1.081232, 1.551842>, <-0.310969, 0.742454, 1.549256>, <-0.588171, 0.348832, 1.070149>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.359017, 1.081232, 0.832847>, <0.117708, 1.081232, 0.683860>, <-0.036041, 1.081232, 0.844926>, 
      <0.620129, 1.415221, 0.842415>, <0.454738, 1.415221, 0.693328>, <0.188902, 1.396006, 0.715839>, <0.035153, 1.396006, 0.876905>, 
      <0.655813, 1.774233, 0.406870>, <0.479146, 1.774233, 0.542404>, <0.124764, 1.790383, 0.674422>, <0.255198, 1.790383, 0.854888>, 
      <0.546752, 2.104019, 0.267141>, <0.370085, 2.104019, 0.402676>, <0.179715, 2.104019, 0.612881>, <0.310149, 2.104019, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>, 
      <0.359017, 1.081232, 0.832847>, <0.264047, 0.749863, 0.971272>, <0.162627, 0.335985, 0.890444>, <0.010170, 0.000000, 0.933538>, 
      <0.117708, 1.081232, 0.683860>, <0.043891, 0.754862, 0.650703>, <0.078020, 0.327640, 0.720000>, <0.044816, 0.000000, 0.652066>, 
      <-0.036041, 1.081232, 0.844926>, <-0.109858, 0.754862, 0.811769>, <-0.132524, 0.327640, 0.647528>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.916474, 1.081232, 1.383110>, <0.701264, 1.081232, 1.141355>, <0.524408, 1.081232, 0.981934>, 
      <1.040909, 1.453099, 1.299984>, <1.205316, 1.453099, 1.127752>, <0.796985, 1.415221, 1.001836>, <0.620129, 1.415221, 0.842415>, 
      <1.312595, 1.743691, 0.509850>, <1.173120, 1.743691, 0.316874>, <0.844727, 1.774233, 0.261939>, <0.655813, 1.774233, 0.406870>, 
      <1.151989, 2.104019, 0.147508>, <1.012513, 2.104019, -0.045468>, <0.735666, 2.104019, 0.122211>, <0.546752, 2.104019, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.486546, 0.739388, 1.790082>, <-0.140497, 0.354327, 1.582077>, <-0.482271, 0.000000, 1.592315>, 
      <0.916474, 1.081232, 1.383110>, <0.650953, 0.739388, 1.617850>, <0.084642, 0.354327, 1.659573>, <-0.257132, 0.000000, 1.669811>, 
      <0.701264, 1.081232, 1.141355>, <0.606294, 0.749863, 1.279780>, <0.025164, 0.335985, 1.330233>, <-0.127293, 0.000000, 1.373327>, 
      <0.524408, 1.081232, 0.981934>, <0.429438, 0.749863, 1.120359>, <0.096198, 0.335985, 1.102972>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <1.040909, 1.453099, 1.299984>, <1.312595, 1.743691, 0.509850>, <1.151989, 2.104019, 0.147508>, 
      <0.546424, 1.081232, 1.770770>, <0.835266, 1.453099, 1.515412>, <1.487054, 1.743691, 0.751227>, <1.326447, 2.104019, 0.388885>, 
      <0.201603, 1.081232, 1.751248>, <0.512137, 1.442306, 1.754004>, <1.144933, 1.752218, 1.029571>, <1.244570, 2.104019, 0.724413>, 
      <-0.019611, 1.081232, 1.551842>, <0.290923, 1.442306, 1.554598>, <0.908636, 1.752218, 1.210852>, <1.008274, 2.104019, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.752067, 1.081232, 1.555341>, <0.546424, 1.081232, 1.770770>, <0.201603, 1.081232, 1.751248>, <-0.019611, 1.081232, 1.551842>, 
      <0.486546, 0.739388, 1.790082>, <0.280903, 0.739388, 2.005510>, <-0.089755, 0.742454, 1.748662>, <-0.310969, 0.742454, 1.549256>, 
      <-0.140497, 0.354327, 1.582077>, <-0.422104, 0.354327, 1.485145>, <-0.677022, 0.348832, 1.354410>, <-0.588171, 0.348832, 1.070149>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.531123, -0.050749, 0.000078>, <0.531123, -0.050749, -0.272821>, <0.304895, -0.043346, -0.532983>, <0.032107, -0.043346, -0.525189>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <0.010372, -0.057224, 0.275149>, <0.232949, -0.057224, 0.268790>, <0.531123, -0.050749, 0.222746>, <0.531123, -0.050749, 0.000078>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.555407, -0.047723, -0.004906>, <-0.555407, -0.047723, 0.233197>, <-0.227635, -0.057224, 0.281949>, <0.010372, -0.057224, 0.275149>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.555407, -0.047723, -0.004906>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.555407, -0.047723, -0.302730>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.265595, -0.043346, -0.516683>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <0.032107, -0.043346, -0.525189>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>, 
      <0.499935, 5.626361, -0.272928>, <0.499935, 5.566828, -0.272928>, <0.487182, 5.481088, -0.296477>, <0.499935, 5.427918, -0.272928>, 
      <0.272705, 5.626361, -0.507806>, <0.272705, 5.566828, -0.507806>, <0.239261, 5.475015, -0.522211>, <0.272705, 5.427918, -0.507806>, 
      <-0.000082, 5.626361, -0.499992>, <-0.000082, 5.566828, -0.499992>, <-0.033527, 5.475015, -0.514397>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>, 
      <0.222553, 5.626361, 0.281511>, <0.222553, 5.566828, 0.281511>, <0.209130, 5.485864, 0.279002>, <0.222553, 5.427918, 0.281511>, 
      <0.499971, 5.626361, 0.222639>, <0.499971, 5.566828, 0.222639>, <0.487219, 5.481088, 0.199091>, <0.499971, 5.427918, 0.222639>, 
      <0.499955, 5.626361, -0.000029>, <0.499955, 5.566828, -0.000029>, <0.487202, 5.481088, -0.023577>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560649, 5.566828, 0.030352>, <-0.589835, 5.478685, 0.041080>, <-0.560649, 5.427918, 0.030352>, 
      <-0.560631, 5.626361, 0.268456>, <-0.560631, 5.566828, 0.268456>, <-0.589817, 5.478685, 0.279183>, <-0.560631, 5.427918, 0.268456>, 
      <-0.238030, 5.626361, 0.294705>, <-0.238030, 5.566828, 0.294705>, <-0.251453, 5.485864, 0.292195>, <-0.238030, 5.427918, 0.294705>, 
      <-0.000024, 5.626361, 0.287887>, <-0.000024, 5.566828, 0.287887>, <-0.013447, 5.485864, 0.285378>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560649, 5.626361, 0.030352>, <-0.560671, 5.626361, -0.267471>, <-0.297783, 5.626361, -0.491464>, <-0.000082, 5.626361, -0.499992>, 
      <-0.560649, 5.566828, 0.030352>, <-0.560671, 5.566828, -0.267471>, <-0.297783, 5.566828, -0.491464>, <-0.000082, 5.566828, -0.499992>, 
      <-0.589835, 5.478685, 0.041080>, <-0.589857, 5.478685, -0.256743>, <-0.331228, 5.475015, -0.505870>, <-0.033527, 5.475015, -0.514397>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560671, 5.427918, -0.267471>, <-0.297783, 5.427918, -0.491464>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>, 
      <0.871674, 4.594842, 0.409537>, <1.101873, 4.594842, 0.262968>, <0.990284, 4.595130, -0.133963>, <0.837200, 4.595130, -0.359882>, 
      <0.588703, 5.057900, 0.163849>, <0.588683, 5.057900, -0.109050>, <0.542953, 5.047354, -0.391404>, <0.270166, 5.047354, -0.383590>, 
      <0.499955, 5.427918, -0.000029>, <0.499935, 5.427918, -0.272928>, <0.272705, 5.427918, -0.507806>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>, 
      <0.258408, 4.594562, 0.273502>, <0.383314, 4.594562, 0.457837>, <0.683847, 4.594842, 0.529128>, <0.871674, 4.594842, 0.409537>, 
      <0.083501, 5.067343, 0.303502>, <0.306078, 5.067343, 0.297127>, <0.588720, 5.057900, 0.386517>, <0.588703, 5.057900, 0.163849>, 
      <-0.000024, 5.427918, 0.287887>, <0.222553, 5.427918, 0.281511>, <0.499971, 5.427918, 0.222639>, <0.499955, 5.427918, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>, 
      <-0.002919, 4.594964, -0.345512>, <-0.203767, 4.594964, -0.217631>, <0.124843, 4.594562, 0.076388>, <0.258408, 4.594562, 0.273502>, 
      <-0.345421, 5.053539, -0.048759>, <-0.345404, 5.053539, 0.189344>, <-0.154505, 5.067343, 0.310320>, <0.083501, 5.067343, 0.303502>, 
      <-0.560649, 5.427918, 0.030352>, <-0.560631, 5.427918, 0.268456>, <-0.238030, 5.427918, 0.294705>, <-0.000024, 5.427918, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.237935, 4.237260, -0.263184>, <-0.002919, 4.594964, -0.345512>, <-0.345421, 5.053539, -0.048759>, <-0.560649, 5.427918, 0.030352>, 
      <0.489158, 4.237260, -0.423140>, <0.248304, 4.594964, -0.505468>, <-0.345443, 5.053539, -0.346583>, <-0.560671, 5.427918, -0.267471>, 
      <0.819288, 4.237260, -0.321664>, <0.670135, 4.595130, -0.606434>, <-0.027535, 5.047354, -0.375063>, <-0.297783, 5.427918, -0.491464>, 
      <0.986353, 4.237260, -0.075112>, <0.837200, 4.595130, -0.359882>, <0.270166, 5.047354, -0.383590>, <-0.000082, 5.427918, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>, 
      <0.487685, 3.485815, 1.278173>, <0.678550, 3.485815, 1.473223>, <1.021481, 3.501927, 1.236272>, <1.211001, 3.501927, 1.039914>, 
      <0.792948, 3.864501, 0.829580>, <1.023146, 3.864501, 0.683010>, <1.306122, 3.837324, 0.469049>, <1.153038, 3.837324, 0.243131>, 
      <0.833129, 4.237260, 0.615194>, <1.063328, 4.237260, 0.468625>, <1.139437, 4.237260, 0.150807>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>, 
      <0.458265, 3.467610, 0.673952>, <0.303630, 3.467610, 0.834167>, <0.331951, 3.485815, 1.119025>, <0.487685, 3.485815, 1.278173>, 
      <0.382814, 3.892839, 0.419899>, <0.507721, 3.892839, 0.604234>, <0.605121, 3.864501, 0.949171>, <0.792948, 3.864501, 0.829580>, 
      <0.321753, 4.237260, 0.348044>, <0.446659, 4.237260, 0.532379>, <0.645302, 4.237260, 0.734785>, <0.833129, 4.237260, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>, 
      <0.975227, 3.492933, 0.262535>, <0.808698, 3.492933, 0.092354>, <0.623620, 3.467610, 0.502630>, <0.458265, 3.467610, 0.673952>, 
      <0.496831, 3.852760, -0.174689>, <0.295984, 3.852760, -0.046808>, <0.249249, 3.892839, 0.222786>, <0.382814, 3.892839, 0.419899>, 
      <0.237935, 4.237260, -0.263184>, <0.037087, 4.237260, -0.135303>, <0.188188, 4.237260, 0.150931>, <0.321753, 4.237260, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.988764, 3.126806, 0.559968>, <0.975227, 3.492933, 0.262535>, <0.496831, 3.852760, -0.174689>, <0.237935, 4.237260, -0.263184>, 
      <1.197061, 3.126806, 0.772832>, <1.183524, 3.492933, 0.475399>, <0.748054, 3.852760, -0.334644>, <0.489158, 4.237260, -0.423140>, 
      <1.165802, 3.126806, 1.116788>, <1.417829, 3.501927, 0.825623>, <0.985973, 3.837324, -0.003422>, <0.819288, 4.237260, -0.321664>, 
      <0.958974, 3.126806, 1.331080>, <1.211001, 3.501927, 1.039914>, <1.153038, 3.837324, 0.243131>, <0.986353, 4.237260, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>, 
      <-0.478676, 2.443939, 1.104255>, <-0.635781, 2.443939, 1.327397>, <-0.339553, 2.463236, 1.620984>, <-0.112016, 2.463236, 1.771652>, 
      <0.025493, 2.782051, 1.366857>, <0.216358, 2.782051, 1.561907>, <0.522439, 2.759143, 1.812815>, <0.711959, 2.759143, 1.616456>, 
      <0.251908, 3.126806, 1.323413>, <0.442773, 3.126806, 1.518463>, <0.769455, 3.126806, 1.527438>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>, 
      <0.105840, 2.420954, 0.966742>, <-0.079815, 2.420954, 0.843806>, <-0.350489, 2.443939, 0.922187>, <-0.478676, 2.443939, 1.104255>, 
      <0.360933, 2.808564, 0.855739>, <0.206297, 2.808564, 1.015955>, <-0.130241, 2.782051, 1.207709>, <0.025493, 2.782051, 1.366857>, 
      <0.407933, 3.126806, 0.767957>, <0.253298, 3.126806, 0.928172>, <0.096174, 3.126806, 1.164265>, <0.251908, 3.126806, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>, 
      <0.604571, 2.452578, 1.399187>, <0.741644, 2.452578, 1.204498>, <0.304365, 2.420954, 1.098199>, <0.105840, 2.420954, 0.966742>, 
      <1.001887, 2.771873, 0.848307>, <0.835358, 2.771873, 0.678127>, <0.526288, 2.808564, 0.684418>, <0.360933, 2.808564, 0.855739>, 
      <0.988764, 3.126806, 0.559968>, <0.822235, 3.126806, 0.389788>, <0.573288, 3.126806, 0.596635>, <0.407933, 3.126806, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.316807, 2.104019, 1.469812>, <0.604571, 2.452578, 1.399187>, <1.001887, 2.771873, 0.848307>, <0.988764, 3.126806, 0.559968>, 
      <0.145354, 2.104019, 1.713333>, <0.433118, 2.452578, 1.642708>, <1.210184, 2.771873, 1.061171>, <1.197061, 3.126806, 0.772832>, 
      <-0.198554, 2.104019, 1.745119>, <0.136302, 2.463236, 1.936081>, <0.918787, 2.759143, 1.402165>, <1.165802, 3.126806, 1.116788>, 
      <-0.446872, 2.104019, 1.580690>, <-0.112016, 2.463236, 1.771652>, <0.711959, 2.759143, 1.616456>, <0.958974, 3.126806, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.532779, 1.081232, -0.115902>, <-0.841079, 1.081232, -0.007496>, <-0.947876, 1.081232, 0.243639>, 
      <-0.460568, 1.427554, 0.143533>, <-0.708550, 1.427554, 0.029607>, <-0.919759, 1.451683, 0.358848>, <-1.026556, 1.451683, 0.609983>, 
      <-0.657048, 1.764099, 0.663767>, <-0.814153, 1.764099, 0.886908>, <-1.009265, 1.744802, 1.239059>, <-0.781728, 1.744802, 1.389728>, 
      <-0.567862, 2.104019, 0.884011>, <-0.724967, 2.104019, 1.107152>, <-0.674409, 2.104019, 1.430022>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>, 
      <-0.532779, 1.081232, -0.115902>, <-0.362912, 0.746541, -0.256523>, <0.290460, 0.341673, -0.273427>, <0.500000, 0.000000, -0.272899>, 
      <-0.841079, 1.081232, -0.007496>, <-0.768561, 0.739794, -0.345148>, <0.010876, 0.353593, -0.302315>, <0.272788, 0.000000, -0.507794>, 
      <-0.947876, 1.081232, 0.243639>, <-0.875358, 0.739794, -0.094013>, <-0.261912, 0.353593, -0.294521>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.144796, 1.081232, 0.367641>, <-0.082460, 1.081232, 0.090980>, <-0.284797, 1.081232, -0.001976>, 
      <-0.230920, 1.399890, 0.670780>, <-0.143781, 1.399890, 0.465871>, <-0.258231, 1.427554, 0.236488>, <-0.460568, 1.427554, 0.143533>, 
      <-0.092438, 1.787084, 0.906190>, <-0.278093, 1.787084, 0.783255>, <-0.528861, 1.764099, 0.481698>, <-0.657048, 1.764099, 0.663767>, 
      <0.006701, 2.104019, 0.936466>, <-0.178954, 2.104019, 0.813531>, <-0.439675, 2.104019, 0.701942>, <-0.567862, 2.104019, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>, 
      <-0.144796, 1.081232, 0.367641>, <-0.145838, 0.753870, 0.266728>, <0.162897, 0.329277, 0.354769>, <0.222577, 0.000000, 0.281520>, 
      <-0.082460, 1.081232, 0.090980>, <0.087407, 0.746541, -0.049642>, <0.290460, 0.341673, 0.222140>, <0.500000, 0.000000, 0.222668>, 
      <-0.284797, 1.081232, -0.001976>, <-0.114930, 0.746541, -0.142598>, <0.290460, 0.341673, -0.000528>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.483662, 1.081232, 1.073839>, <-0.325115, 1.081232, 0.791664>, <-0.231935, 1.081232, 0.572550>, 
      <-0.551143, 1.438248, 1.218700>, <-0.334780, 1.438248, 1.318099>, <-0.324100, 1.399890, 0.889893>, <-0.230920, 1.399890, 0.670780>, 
      <0.029043, 1.755460, 1.540437>, <0.166117, 1.755460, 1.345747>, <0.106087, 1.787084, 1.037648>, <-0.092438, 1.787084, 0.906190>, 
      <0.316807, 2.104019, 1.469812>, <0.453880, 2.104019, 1.275122>, <0.205226, 2.104019, 1.067923>, <0.006701, 2.104019, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.840828, 0.743590, 0.743435>, <-0.598392, 0.346823, 0.286187>, <-0.560606, 0.000000, 0.030303>, 
      <-0.483662, 1.081232, 1.073839>, <-0.624465, 0.743590, 0.842835>, <-0.598392, 0.346823, 0.524291>, <-0.560606, 0.000000, 0.268407>, 
      <-0.325115, 1.081232, 0.791664>, <-0.326157, 0.753870, 0.690751>, <-0.297686, 0.329277, 0.367929>, <-0.238007, 0.000000, 0.294679>, 
      <-0.231935, 1.081232, 0.572550>, <-0.232978, 0.753870, 0.471637>, <-0.059680, 0.329277, 0.361129>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.551143, 1.438248, 1.218700>, <0.029043, 1.755460, 1.540437>, <0.316807, 2.104019, 1.469812>, 
      <-0.970655, 1.081232, 0.850110>, <-0.821773, 1.438248, 1.094370>, <-0.142410, 1.755460, 1.783957>, <0.145354, 2.104019, 1.713333>, 
      <-1.064426, 1.081232, 0.517710>, <-1.143107, 1.451683, 0.884053>, <-0.533411, 1.744802, 1.554156>, <-0.198554, 2.104019, 1.745119>, 
      <-0.947876, 1.081232, 0.243639>, <-1.026556, 1.451683, 0.609983>, <-0.781728, 1.744802, 1.389728>, <-0.446872, 2.104019, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.700025, 1.081232, 0.974440>, <-0.970655, 1.081232, 0.850110>, <-1.064426, 1.081232, 0.517710>, <-0.947876, 1.081232, 0.243639>, 
      <-0.840828, 0.743590, 0.743435>, <-1.111458, 0.743590, 0.619105>, <-0.991908, 0.739794, 0.180057>, <-0.875358, 0.739794, -0.094013>, 
      <-0.598392, 0.346823, 0.286187>, <-0.598392, 0.346823, -0.011636>, <-0.559614, 0.353593, -0.286016>, <-0.261912, 0.353593, -0.294521>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt = union {
  cone { // Cone291
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch001 }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 123.91114>
  translate  <-2.918603, -2.009389, 2.682482>
}
#declare segMstraightMA = union {
  object { sPatchObj1 }
  object { Blatt }
  translate  <-0.1416, 0.531909, 5.931396>
}
#declare BezPtch003 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt8 = union {
  cone { // Cone292
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch003 }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.3
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <-1.015973, 2.80328, 2.590573>
}
#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.382950, -0.198443, 1.038181>, <0.231423, -0.198443, 1.265148>, <0.289967, -0.198443, 1.586665>, <0.521168, -0.198443, 1.731648>, 
      <0.382950, -0.138910, 1.038181>, <0.231423, -0.138910, 1.265148>, <0.289967, -0.138910, 1.586665>, <0.521168, -0.138910, 1.731648>, 
      <0.414651, -0.048850, 1.050547>, <0.263124, -0.048850, 1.277514>, <0.300659, -0.048722, 1.619162>, <0.531860, -0.048722, 1.764145>, 
      <0.382950, 0.000000, 1.038181>, <0.231423, 0.000000, 1.265148>, <0.289967, 0.000000, 1.586665>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.958637, -0.198443, 1.076381>, <0.769992, -0.198443, 0.958085>, <0.506586, -0.198443, 0.852992>, <0.382950, -0.198443, 1.038181>, 
      <0.958637, -0.138910, 1.076381>, <0.769992, -0.138910, 0.958085>, <0.506586, -0.138910, 0.852992>, <0.382950, -0.138910, 1.038181>, 
      <0.993774, -0.039753, 1.103386>, <0.805129, -0.039753, 0.985090>, <0.538288, -0.048850, 0.865358>, <0.414651, -0.048850, 1.050547>, 
      <0.958637, 0.000000, 1.076381>, <0.769992, 0.000000, 0.958085>, <0.506586, 0.000000, 0.852992>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.414073, -0.198443, 1.403851>, <1.160359, -0.198443, 1.202878>, <0.958637, -0.198443, 1.076381>, 
      <1.281866, -0.138910, 1.601878>, <1.414073, -0.138910, 1.403851>, <1.160359, -0.138910, 1.202878>, <0.958637, -0.138910, 1.076381>, 
      <1.305480, -0.035894, 1.643087>, <1.437687, -0.035894, 1.445060>, <1.195496, -0.039753, 1.229883>, <0.993774, -0.039753, 1.103386>, 
      <1.281866, 0.000000, 1.601878>, <1.414073, 0.000000, 1.403851>, <1.160359, 0.000000, 1.202878>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281866, -0.198443, 1.601878>, <1.281866, -0.138910, 1.601878>, <1.305480, -0.035894, 1.643087>, <1.281866, 0.000000, 1.601878>, 
      <1.116500, -0.198443, 1.849573>, <1.116500, -0.138910, 1.849573>, <1.140114, -0.035894, 1.890782>, <1.116500, 0.000000, 1.849573>, 
      <0.773485, -0.198443, 1.889873>, <0.773485, -0.138910, 1.889873>, <0.784177, -0.048722, 1.922369>, <0.773485, 0.000000, 1.889873>, 
      <0.521168, -0.198443, 1.731648>, <0.521168, -0.138910, 1.731648>, <0.531860, -0.048722, 1.764145>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>, 
      <0.467505, 5.626361, -1.348637>, <0.467505, 5.566828, -1.348637>, <0.509780, 5.466167, -1.365785>, <0.467505, 5.427918, -1.348637>, 
      <0.526073, 5.626361, -1.027124>, <0.526073, 5.566828, -1.027124>, <0.576188, 5.458817, -1.035948>, <0.526073, 5.427918, -1.027124>, 
      <0.757285, 5.626361, -0.882157>, <0.757285, 5.566828, -0.882157>, <0.807400, 5.458817, -0.890982>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>, 
      <1.006052, 5.626361, -1.655739>, <1.006052, 5.566828, -1.655739>, <1.048927, 5.459842, -1.681945>, <1.006052, 5.427918, -1.655739>, 
      <0.742638, 5.626361, -1.760813>, <0.742638, 5.566828, -1.760813>, <0.784913, 5.466167, -1.777961>, <0.742638, 5.427918, -1.760813>, 
      <0.619016, 5.626361, -1.575614>, <0.619016, 5.566828, -1.575614>, <0.661290, 5.466167, -1.592762>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.517973, 5.566828, -1.011983>, <1.566262, 5.454522, -1.034444>, <1.517973, 5.427918, -1.011983>, 
      <1.650165, 5.626361, -1.210019>, <1.650165, 5.566828, -1.210019>, <1.698454, 5.454522, -1.232481>, <1.650165, 5.427918, -1.210019>, 
      <1.396437, 5.626361, -1.410974>, <1.396437, 5.566828, -1.410974>, <1.439313, 5.459842, -1.437179>, <1.396437, 5.427918, -1.410974>, 
      <1.194706, 5.626361, -1.537457>, <1.194706, 5.566828, -1.537457>, <1.237581, 5.459842, -1.563662>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.517973, 5.626361, -1.011983>, <1.352625, 5.626361, -0.764276>, <1.009613, 5.626361, -0.723951>, <0.757285, 5.626361, -0.882157>, 
      <1.517973, 5.566828, -1.011983>, <1.352625, 5.566828, -0.764276>, <1.009613, 5.566828, -0.723951>, <0.757285, 5.566828, -0.882157>, 
      <1.566262, 5.454522, -1.034444>, <1.400914, 5.454522, -0.786737>, <1.059728, 5.458817, -0.732776>, <0.807400, 5.458817, -0.890982>, 
      <1.517973, 5.427918, -1.011983>, <1.352625, 5.427918, -0.764276>, <1.009613, 5.427918, -0.723951>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>, 
      <-0.416768, 4.721273, -1.247418>, <-0.689604, 4.721273, -1.253336>, <-0.729103, 4.787694, -0.873656>, <-0.727227, 4.787694, -0.600763>, 
      <0.228340, 5.074441, -1.417145>, <0.076830, 5.074441, -1.190167>, <-0.060671, 5.066156, -0.923812>, <0.170541, 5.066156, -0.778846>, 
      <0.619016, 5.427918, -1.575614>, <0.467505, 5.427918, -1.348637>, <0.526073, 5.427918, -1.027124>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>, 
      <0.010389, 4.716106, -0.789508>, <0.008858, 4.716106, -1.012170>, <-0.194153, 4.721273, -1.242589>, <-0.416768, 4.721273, -1.247418>, 
      <0.710236, 5.067195, -1.241350>, <0.521582, 5.067195, -1.359633>, <0.351963, 5.074441, -1.602344>, <0.228340, 5.074441, -1.417145>, 
      <1.194706, 5.427918, -1.537457>, <1.006052, 5.427918, -1.655739>, <0.742638, 5.427918, -1.760813>, <0.619016, 5.427918, -1.575614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>, 
      <-0.061860, 4.746262, -0.146843>, <0.176188, 4.746262, -0.141679>, <0.012026, 4.716106, -0.551410>, <0.010389, 4.716106, -0.789508>, 
      <0.854156, 5.062198, -0.703210>, <0.986348, 5.062198, -0.901247>, <0.911968, 5.067195, -1.114868>, <0.710236, 5.067195, -1.241350>, 
      <1.517973, 5.427918, -1.011983>, <1.650165, 5.427918, -1.210019>, <1.396437, 5.427918, -1.410974>, <1.194706, 5.427918, -1.537457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.761991, 4.370247, 0.048536>, <-0.061860, 4.746262, -0.146843>, <0.854156, 5.062198, -0.703210>, <1.517973, 5.427918, -1.011983>, 
      <-1.059745, 4.370247, 0.042078>, <-0.359613, 4.746262, -0.153301>, <0.688808, 5.062198, -0.455503>, <1.352625, 5.427918, -0.764276>, 
      <-1.277965, 4.370247, -0.225622>, <-0.725179, 4.787694, -0.302946>, <0.422869, 5.066156, -0.620640>, <1.009613, 5.427918, -0.723951>, 
      <-1.280013, 4.370247, -0.523439>, <-0.727227, 4.787694, -0.600763>, <0.170541, 5.066156, -0.778846>, <0.757285, 5.427918, -0.882157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>, 
      <-1.479019, 3.584063, -0.349267>, <-1.529457, 3.584063, -0.617465>, <-1.933409, 3.620178, -0.614618>, <-2.200057, 3.620178, -0.556540>, 
      <-1.108076, 4.032892, -0.786688>, <-1.380911, 4.032892, -0.792606>, <-1.646320, 4.095040, -0.745355>, <-1.644443, 4.095040, -0.472462>, 
      <-0.769287, 4.370247, -1.012478>, <-1.042122, 4.370247, -1.018396>, <-1.281890, 4.370247, -0.796332>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>, 
      <-1.721332, 3.679914, 0.147818>, <-1.503764, 3.679914, 0.100430>, <-1.437864, 3.584063, -0.130435>, <-1.479019, 3.584063, -0.349267>, 
      <-0.975400, 4.037891, -0.234253>, <-0.976931, 4.037891, -0.456916>, <-0.885461, 4.032892, -0.781859>, <-1.108076, 4.032892, -0.786688>, 
      <-0.492319, 4.370247, -0.506353>, <-0.493850, 4.370247, -0.729015>, <-0.546672, 4.370247, -1.007649>, <-0.769287, 4.370247, -1.012478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>, 
      <-2.344436, 3.751648, 0.263985>, <-2.300429, 3.751648, 0.497986>, <-1.953981, 3.679914, 0.198490>, <-1.721332, 3.679914, 0.147818>, 
      <-1.344142, 4.057594, 0.210992>, <-1.106095, 4.057594, 0.216155>, <-0.973762, 4.037891, 0.003845>, <-0.975400, 4.037891, -0.234253>, 
      <-0.761991, 4.370247, 0.048536>, <-0.523943, 4.370247, 0.053700>, <-0.490682, 4.370247, -0.268255>, <-0.492319, 4.370247, -0.506353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684097, 3.171135, 0.160649>, <-2.344436, 3.751648, 0.263985>, <-1.344142, 4.057594, 0.210992>, <-0.761991, 4.370247, 0.048536>, 
      <-2.739142, 3.171135, -0.132044>, <-2.399481, 3.751648, -0.028708>, <-1.641896, 4.057594, 0.204533>, <-1.059745, 4.370247, 0.042078>, 
      <-2.522163, 3.171135, -0.400751>, <-2.491058, 3.620178, -0.493158>, <-1.642395, 4.095040, -0.174646>, <-1.277965, 4.370247, -0.225622>, 
      <-2.231162, 3.171135, -0.464133>, <-2.200057, 3.620178, -0.556540>, <-1.644443, 4.095040, -0.472462>, <-1.280013, 4.370247, -0.523439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>, 
      <-1.919775, 2.347050, 0.484065>, <-1.665213, 2.347050, 0.385715>, <-1.646940, 2.276974, 0.044790>, <-1.752520, 2.276974, -0.206858>, 
      <-1.775348, 2.857208, 0.150833>, <-1.825786, 2.857208, -0.117365>, <-1.994206, 2.742499, -0.434003>, <-2.260854, 2.742499, -0.375925>, 
      <-1.647364, 3.171135, -0.065159>, <-1.697803, 3.171135, -0.333357>, <-1.964514, 3.171135, -0.522211>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>, 
      <-2.413154, 2.272171, 0.257782>, <-2.327008, 2.272171, 0.463110>, <-2.127480, 2.347050, 0.564313>, <-1.919775, 2.347050, 0.484065>, 
      <-2.281834, 2.896930, 0.397674>, <-2.064266, 2.896930, 0.350287>, <-1.734194, 2.857208, 0.369665>, <-1.775348, 2.857208, 0.150833>, 
      <-2.085543, 3.171135, 0.310173>, <-1.867976, 3.171135, 0.262786>, <-1.606210, 3.171135, 0.153673>, <-1.647364, 3.171135, -0.065159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>, 
      <-2.484832, 2.246145, -0.367567>, <-2.706935, 2.246145, -0.281756>, <-2.505273, 2.272171, 0.038220>, <-2.413154, 2.272171, 0.257782>, 
      <-2.891284, 2.817033, 0.097616>, <-2.847276, 2.817033, 0.331618>, <-2.514483, 2.896930, 0.448347>, <-2.281834, 2.896930, 0.397674>, 
      <-2.684097, 3.171135, 0.160649>, <-2.640090, 3.171135, 0.394650>, <-2.318192, 3.171135, 0.360846>, <-2.085543, 3.171135, 0.310173>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.139844, 2.015361, -0.370651>, <-2.484832, 2.246145, -0.367567>, <-2.891284, 2.817033, 0.097616>, <-2.684097, 3.171135, 0.160649>, 
      <-1.862034, 2.015361, -0.477984>, <-2.207022, 2.246145, -0.474900>, <-2.946329, 2.817033, -0.195077>, <-2.739142, 3.171135, -0.132044>, 
      <-1.558362, 2.015361, -0.313465>, <-1.867744, 2.276974, -0.481490>, <-2.551855, 2.742499, -0.312543>, <-2.522163, 3.171135, -0.400751>, 
      <-1.443138, 2.015361, -0.038834>, <-1.752520, 2.276974, -0.206858>, <-2.260854, 2.742499, -0.375925>, <-2.231162, 3.171135, -0.464133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.304515, 1.081232, 0.946677>, <0.012086, 1.081232, 1.027701>, <0.240349, 1.081232, 0.878135>, 
      <-0.788855, 1.406922, 0.644678>, <-0.645869, 1.406922, 0.877120>, <-0.365873, 1.469014, 0.687036>, <-0.137609, 1.469014, 0.537470>, 
      <-1.503417, 1.621845, 0.754518>, <-1.248856, 1.621845, 0.656168>, <-0.886311, 1.633789, 0.457885>, <-0.991892, 1.633789, 0.206236>, 
      <-1.729344, 2.015361, 0.607763>, <-1.474783, 2.015361, 0.509412>, <-1.337557, 2.015361, 0.212815>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>, 
      <-0.304515, 1.081232, 0.946677>, <-0.003609, 0.794135, 1.007992>, <0.007566, 0.344951, 1.177824>, <0.231423, 0.000000, 1.265148>, 
      <0.012086, 1.081232, 1.027701>, <0.261255, 0.825587, 1.252283>, <0.214222, 0.345166, 1.356448>, <0.289967, 0.000000, 1.586665>, 
      <0.240349, 1.081232, 0.878135>, <0.489518, 0.825587, 1.102717>, <0.445423, 0.345166, 1.501431>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <-0.358708, 1.081232, 0.329096>, <-0.564168, 1.081232, 0.524578>, <-0.447501, 1.081232, 0.714236>, 
      <-0.717575, 1.431472, 0.062597>, <-0.903823, 1.431472, 0.184633>, <-0.905522, 1.406922, 0.455021>, <-0.788855, 1.406922, 0.644678>, 
      <-1.730134, 1.526020, 0.220968>, <-1.643987, 1.526020, 0.426296>, <-1.711122, 1.621845, 0.834766>, <-1.503417, 1.621845, 0.754518>, 
      <-2.178073, 2.015361, 0.245111>, <-2.091926, 2.015361, 0.450439>, <-1.937049, 2.015361, 0.688011>, <-1.729344, 2.015361, 0.607763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>, 
      <-0.358708, 1.081232, 0.329096>, <0.082253, 0.797910, 0.445956>, <0.453044, 0.358581, 0.714490>, <0.769992, 0.000000, 0.958085>, 
      <-0.564168, 1.081232, 0.524578>, <-0.263262, 0.794135, 0.585893>, <0.282729, 0.344951, 0.765668>, <0.506586, 0.000000, 0.852992>, 
      <-0.447501, 1.081232, 0.714236>, <-0.146595, 0.794135, 0.775551>, <0.159093, 0.344951, 0.950858>, <0.382950, 0.000000, 1.038181>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.315237, 1.081232, -0.070085>, <0.026698, 1.081232, 0.076564>, <-0.172460, 1.081232, 0.207060>, 
      <-0.205809, 1.461603, -0.239568>, <-0.330563, 1.461603, -0.442372>, <-0.518416, 1.431472, -0.067899>, <-0.717575, 1.431472, 0.062597>, 
      <-1.444291, 1.550061, -0.376869>, <-1.666394, 1.550061, -0.291059>, <-1.822252, 1.526020, 0.001406>, <-1.730134, 1.526020, 0.220968>, 
      <-2.139844, 2.015361, -0.370651>, <-2.361947, 2.015361, -0.284841>, <-2.270192, 2.015361, 0.025549>, <-2.178073, 2.015361, 0.245111>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.905100, 0.807287, 0.400843>, <1.042798, 0.363391, 1.184679>, <1.281866, 0.000000, 1.601878>, 
      <0.315237, 1.081232, -0.070085>, <0.780346, 0.807287, 0.198039>, <1.175005, 0.363391, 0.986652>, <1.414073, 0.000000, 1.403851>, 
      <0.026698, 1.081232, 0.076564>, <0.467660, 0.797910, 0.193425>, <0.843411, 0.358581, 0.959283>, <1.160359, 0.000000, 1.202878>, 
      <-0.172460, 1.081232, 0.207060>, <0.268501, 0.797910, 0.323920>, <0.641689, 0.358581, 0.832786>, <0.958637, 0.000000, 1.076381>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <-0.205809, 1.461603, -0.239568>, <-1.444291, 1.550061, -0.376869>, <-2.139844, 2.015361, -0.370651>, 
      <0.596036, 1.081232, 0.386390>, <-0.049764, 1.461603, 0.014103>, <-1.166480, 1.550061, -0.484202>, <-1.862034, 2.015361, -0.477984>, 
      <0.489460, 1.081232, 0.714909>, <0.111501, 1.469014, 0.374244>, <-1.107115, 1.633789, -0.068395>, <-1.558362, 2.015361, -0.313465>, 
      <0.240349, 1.081232, 0.878135>, <-0.137609, 1.469014, 0.537470>, <-0.991892, 1.633789, 0.206236>, <-1.443138, 2.015361, -0.038834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439991, 1.081232, 0.132719>, <0.596036, 1.081232, 0.386390>, <0.489460, 1.081232, 0.714909>, <0.240349, 1.081232, 0.878135>, 
      <0.905100, 0.807287, 0.400843>, <1.061145, 0.807287, 0.654513>, <0.738629, 0.825587, 0.939491>, <0.489518, 0.825587, 1.102717>, 
      <1.042798, 0.363391, 1.184679>, <0.877432, 0.363391, 1.432374>, <0.697740, 0.345166, 1.659655>, <0.445423, 0.345166, 1.501431>, 
      <1.281866, 0.000000, 1.601878>, <1.116500, 0.000000, 1.849573>, <0.773485, 0.000000, 1.889873>, <0.521168, 0.000000, 1.731648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.089280, -0.198443, 1.114731>, <-0.347320, -0.198443, 1.025911>, <-0.643376, -0.198443, 1.164300>, <-0.724791, -0.198443, 1.424772>, 
      <-0.089280, -0.138910, 1.114731>, <-0.347320, -0.138910, 1.025911>, <-0.643376, -0.138910, 1.164300>, <-0.724791, -0.138910, 1.424772>, 
      <-0.068171, -0.055603, 1.112099>, <-0.326212, -0.055603, 1.023279>, <-0.650600, -0.055645, 1.144409>, <-0.732015, -0.055645, 1.404881>, 
      <-0.089280, 0.000000, 1.114731>, <-0.347320, 0.000000, 1.025911>, <-0.643376, 0.000000, 1.164300>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020189, -0.198443, 1.681203>, <0.086618, -0.198443, 1.468675>, <0.121264, -0.198443, 1.187203>, <-0.089280, -0.198443, 1.114731>, 
      <0.020189, -0.138910, 1.681203>, <0.086618, -0.138910, 1.468675>, <0.121264, -0.138910, 1.187203>, <-0.089280, -0.138910, 1.114731>, 
      <0.021745, -0.057184, 1.697688>, <0.088174, -0.057184, 1.485160>, <0.142373, -0.055603, 1.184571>, <-0.068171, -0.055603, 1.112099>, 
      <0.020189, 0.000000, 1.681203>, <0.086618, 0.000000, 1.468675>, <0.121264, 0.000000, 1.187203>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.180684, -0.198443, 2.204948>, <-0.050845, -0.198443, 1.908464>, <0.020189, -0.198443, 1.681203>, 
      <-0.405823, -0.138910, 2.127452>, <-0.180684, -0.138910, 2.204948>, <-0.050845, -0.138910, 1.908464>, <0.020189, -0.138910, 1.681203>, 
      <-0.431374, -0.052836, 2.137433>, <-0.206235, -0.052836, 2.214929>, <-0.049289, -0.057184, 1.924948>, <0.021745, -0.057184, 1.697688>, 
      <-0.405823, 0.000000, 2.127452>, <-0.180684, 0.000000, 2.204948>, <-0.050845, 0.000000, 1.908464>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.405823, -0.198443, 2.127452>, <-0.405823, -0.138910, 2.127452>, <-0.431374, -0.052836, 2.137433>, <-0.405823, 0.000000, 2.127452>, 
      <-0.687430, -0.198443, 2.030520>, <-0.687430, -0.138910, 2.030520>, <-0.712982, -0.052836, 2.040501>, <-0.687430, 0.000000, 2.030520>, 
      <-0.813641, -0.198443, 1.709033>, <-0.813641, -0.138910, 1.709033>, <-0.820866, -0.055645, 1.689142>, <-0.813641, 0.000000, 1.709033>, 
      <-0.724791, -0.198443, 1.424772>, <-0.724791, -0.138910, 1.424772>, <-0.732015, -0.055645, 1.404881>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>, 
      <-0.111256, 5.626361, -1.587831>, <-0.111256, 5.566828, -1.587831>, <-0.069643, 5.470267, -1.592191>, <-0.111256, 5.427918, -1.587831>, 
      <-0.407302, 5.626361, -1.449420>, <-0.407302, 5.566828, -1.449420>, <-0.368068, 5.468930, -1.431452>, <-0.407302, 5.427918, -1.449420>, 
      <-0.488697, 5.626361, -1.188943>, <-0.488697, 5.566828, -1.188943>, <-0.449464, 5.468930, -1.170975>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>, 
      <0.322715, 5.626361, -1.145098>, <0.322715, 5.566828, -1.145098>, <0.371190, 5.462459, -1.143983>, <0.322715, 5.427918, -1.145098>, 
      <0.357340, 5.626361, -1.426573>, <0.357340, 5.566828, -1.426573>, <0.398953, 5.470267, -1.430933>, <0.357340, 5.427918, -1.426573>, 
      <0.146791, 5.626361, -1.499029>, <0.146791, 5.566828, -1.499029>, <0.188404, 5.470267, -1.503390>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.169677, 5.566828, -0.486286>, <-0.121324, 5.459192, -0.471185>, <-0.169677, 5.427918, -0.486286>, 
      <0.055468, 5.626361, -0.408806>, <0.055468, 5.566828, -0.408806>, <0.103821, 5.459192, -0.393705>, <0.055468, 5.427918, -0.408806>, 
      <0.185284, 5.626361, -0.705300>, <0.185284, 5.566828, -0.705300>, <0.233760, 5.462459, -0.704184>, <0.185284, 5.427918, -0.705300>, 
      <0.256302, 5.626361, -0.932566>, <0.256302, 5.566828, -0.932566>, <0.304777, 5.462459, -0.931450>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.169677, 5.626361, -0.486286>, <-0.451292, 5.626361, -0.583198>, <-0.577527, 5.626361, -0.904675>, <-0.488697, 5.626361, -1.188943>, 
      <-0.169677, 5.566828, -0.486286>, <-0.451292, 5.566828, -0.583198>, <-0.577527, 5.566828, -0.904675>, <-0.488697, 5.566828, -1.188943>, 
      <-0.121324, 5.459192, -0.471185>, <-0.402939, 5.459192, -0.568097>, <-0.538293, 5.468930, -0.886707>, <-0.449464, 5.468930, -1.170975>, 
      <-0.169677, 5.427918, -0.486286>, <-0.451292, 5.427918, -0.583198>, <-0.577527, 5.427918, -0.904675>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>, 
      <-0.833708, 4.749489, -1.545964>, <-0.897374, 4.749489, -1.811333>, <-1.288948, 4.858728, -1.826220>, <-1.552390, 4.858728, -1.755001>, 
      <-0.195143, 5.079934, -1.463202>, <-0.453190, 5.079934, -1.552004>, <-0.741975, 5.078072, -1.602691>, <-0.823371, 5.078072, -1.342214>, 
      <0.146791, 5.427918, -1.499029>, <-0.111256, 5.427918, -1.587831>, <-0.407302, 5.427918, -1.449420>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>, 
      <-1.087471, 4.821855, -1.003961>, <-0.872520, 4.821855, -1.062071>, <-0.781761, 4.749489, -1.329441>, <-0.833708, 4.749489, -1.545964>, 
      <-0.245976, 5.070017, -0.944121>, <-0.179562, 5.070017, -1.156654>, <0.015406, 5.079934, -1.390746>, <-0.195143, 5.079934, -1.463202>, 
      <0.256302, 5.427918, -0.932566>, <0.322715, 5.427918, -1.145098>, <0.357340, 5.427918, -1.426573>, <0.146791, 5.427918, -1.499029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>, 
      <-1.721542, 4.895757, -0.881118>, <-1.665994, 4.895757, -0.649585>, <-1.317324, 4.821855, -0.941822>, <-1.087471, 4.821855, -1.003961>, 
      <-0.728416, 5.066532, -0.660782>, <-0.503271, 5.066532, -0.583303>, <-0.316993, 5.070017, -0.716856>, <-0.245976, 5.070017, -0.944121>, 
      <-0.169677, 5.427918, -0.486286>, <0.055468, 5.427918, -0.408806>, <0.185284, 5.427918, -0.705300>, <0.256302, 5.427918, -0.932566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.111756, 4.370247, -1.092804>, <-1.721542, 4.895757, -0.881118>, <-0.728416, 5.066532, -0.660782>, <-0.169677, 5.427918, -0.486286>, 
      <-2.181236, 4.370247, -1.382409>, <-1.791023, 4.895757, -1.170723>, <-1.010031, 5.066532, -0.757694>, <-0.451292, 5.427918, -0.583198>, 
      <-1.977838, 4.370247, -1.661536>, <-1.839893, 4.858728, -1.677277>, <-0.912200, 5.078072, -1.057946>, <-0.577527, 5.427918, -0.904675>, 
      <-1.690336, 4.370247, -1.739260>, <-1.552390, 4.858728, -1.755001>, <-0.823371, 5.078072, -1.342214>, <-0.488697, 5.427918, -1.188943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>, 
      <-1.333099, 3.508092, -0.763045>, <-1.086548, 3.508092, -0.880034>, <-1.130598, 3.449089, -1.188097>, <-1.254581, 3.449089, -1.431206>, 
      <-1.326556, 4.012984, -1.203660>, <-1.390222, 4.012984, -1.469029>, <-1.546231, 3.947660, -1.796861>, <-1.809673, 3.947660, -1.725642>, 
      <-1.087486, 4.370247, -1.369705>, <-1.151152, 4.370247, -1.635073>, <-1.426894, 4.370247, -1.810479>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>, 
      <-1.899719, 3.499474, -0.954693>, <-1.798557, 3.499474, -0.756332>, <-1.534268, 3.508092, -0.667589>, <-1.333099, 3.508092, -0.763045>, 
      <-1.763151, 4.093690, -0.954238>, <-1.548200, 4.093690, -1.012348>, <-1.274609, 4.012984, -0.987137>, <-1.326556, 4.012984, -1.203660>, 
      <-1.506528, 4.370247, -0.973123>, <-1.291576, 4.370247, -1.031233>, <-1.035539, 4.370247, -1.153181>, <-1.087486, 4.370247, -1.369705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>, 
      <-2.045189, 3.455457, -1.547973>, <-2.260304, 3.455457, -1.445900>, <-2.007895, 3.499474, -1.166804>, <-1.899719, 3.499474, -0.954693>, 
      <-2.327029, 4.080334, -1.209586>, <-2.271480, 4.080334, -0.978053>, <-1.993004, 4.093690, -0.892100>, <-1.763151, 4.093690, -0.954238>, 
      <-2.111756, 4.370247, -1.092804>, <-2.056207, 4.370247, -0.861271>, <-1.736380, 4.370247, -0.910984>, <-1.506528, 4.370247, -0.973123>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.845436, 3.171135, -1.395362>, <-2.045189, 3.455457, -1.547973>, <-2.327029, 4.080334, -1.209586>, <-2.111756, 4.370247, -1.092804>, 
      <-1.576368, 3.171135, -1.523036>, <-1.776121, 3.455457, -1.675647>, <-2.396509, 4.080334, -1.499191>, <-2.181236, 4.370247, -1.382409>, 
      <-1.261313, 3.171135, -1.381531>, <-1.389888, 3.449089, -1.696518>, <-2.097176, 3.947660, -1.647919>, <-1.977838, 4.370247, -1.661536>, 
      <-1.126006, 3.171135, -1.116219>, <-1.254581, 3.449089, -1.431206>, <-1.809673, 3.947660, -1.725642>, <-1.690336, 4.370247, -1.739260>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>, 
      <-1.446077, 2.404893, 0.514064>, <-1.286219, 2.404893, 0.735241>, <-0.928331, 2.423455, 0.509982>, <-0.711810, 2.423455, 0.343872>, 
      <-1.397225, 2.794648, -0.100544>, <-1.150674, 2.794648, -0.217534>, <-0.790649, 2.714186, -0.355280>, <-0.914633, 2.714186, -0.598389>, 
      <-1.363385, 3.171135, -0.450148>, <-1.116834, 3.171135, -0.567138>, <-1.002023, 3.171135, -0.873110>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>, 
      <-1.338930, 2.332180, -0.026128>, <-1.515597, 2.332180, 0.109406>, <-1.576511, 2.404893, 0.333598>, <-1.446077, 2.404893, 0.514064>, 
      <-1.751532, 2.713489, -0.532828>, <-1.650370, 2.713489, -0.334467>, <-1.598394, 2.794648, -0.005088>, <-1.397225, 2.794648, -0.100544>, 
      <-1.837815, 3.171135, -0.778462>, <-1.736653, 3.171135, -0.580101>, <-1.564555, 3.171135, -0.354692>, <-1.363385, 3.171135, -0.450148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>, 
      <-0.792791, 2.355968, -0.363553>, <-0.932266, 2.355968, -0.556529>, <-1.150016, 2.332180, -0.171059>, <-1.338930, 2.332180, -0.026128>, 
      <-1.467895, 2.633755, -1.106922>, <-1.683010, 2.633755, -1.004849>, <-1.859707, 2.713489, -0.744940>, <-1.751532, 2.713489, -0.532828>, 
      <-1.845436, 3.171135, -1.395362>, <-2.060551, 3.171135, -1.293289>, <-1.945990, 3.171135, -0.990574>, <-1.837815, 3.171135, -0.778462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.457307, 2.015361, 0.171189>, <-0.792791, 2.355968, -0.363553>, <-1.467895, 2.633755, -1.106922>, <-1.845436, 3.171135, -1.395362>, 
      <-0.282849, 2.015361, 0.412566>, <-0.618332, 2.355968, -0.122176>, <-1.198826, 2.633755, -1.234596>, <-1.576368, 3.171135, -1.523036>, 
      <-0.364726, 2.015361, 0.748095>, <-0.475513, 2.423455, 0.162591>, <-1.049940, 2.714186, -0.863701>, <-1.261313, 3.171135, -1.381531>, 
      <-0.601022, 2.015361, 0.929375>, <-0.711810, 2.423455, 0.343872>, <-0.914633, 2.714186, -0.598389>, <-1.126006, 3.171135, -1.116219>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.763513, 1.081232, 1.372705>, <-0.761351, 1.081232, 1.699502>, <-0.558650, 1.081232, 1.882221>, 
      <-0.764265, 1.396371, 1.128753>, <-0.952698, 1.396371, 1.326154>, <-0.737508, 1.469474, 1.604068>, <-0.534807, 1.469474, 1.786787>, 
      <-1.193420, 1.735064, 1.035033>, <-1.033561, 1.735064, 1.256210>, <-0.756108, 1.789057, 1.420169>, <-0.539586, 1.789057, 1.254059>, 
      <-1.299147, 2.015361, 0.817028>, <-1.139289, 2.015361, 1.038205>, <-0.817544, 2.015361, 1.095485>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>, 
      <-0.763513, 1.081232, 1.372705>, <-0.581696, 0.778367, 1.417443>, <-0.473571, 0.332564, 1.041652>, <-0.347320, 0.000000, 1.025911>, 
      <-0.761351, 1.081232, 1.699502>, <-0.782527, 0.736413, 1.784262>, <-0.600210, 0.332481, 1.283153>, <-0.643376, 0.000000, 1.164300>, 
      <-0.558650, 1.081232, 1.882221>, <-0.579826, 0.736413, 1.966981>, <-0.681624, 0.332481, 1.543625>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <-0.180022, 1.081232, 1.163226>, <-0.421330, 1.081232, 1.014239>, <-0.575080, 1.081232, 1.175304>, 
      <-0.225276, 1.473321, 1.041814>, <-0.390668, 1.473321, 0.892727>, <-0.610516, 1.396371, 0.967687>, <-0.764265, 1.396371, 1.128753>, 
      <-0.789139, 1.701959, 0.604355>, <-0.965806, 1.701959, 0.739890>, <-1.323854, 1.735064, 0.854567>, <-1.193420, 1.735064, 1.035033>, 
      <-1.062544, 2.015361, 0.290822>, <-1.239211, 2.015361, 0.426357>, <-1.429581, 2.015361, 0.636562>, <-1.299147, 2.015361, 0.817028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>, 
      <-0.180022, 1.081232, 1.163226>, <-0.041346, 0.823106, 1.341305>, <0.077657, 0.329359, 1.373731>, <0.086618, 0.000000, 1.468675>, 
      <-0.421330, 1.081232, 1.014239>, <-0.239514, 0.778367, 1.058977>, <-0.004986, 0.332564, 1.202945>, <0.121264, 0.000000, 1.187203>, 
      <-0.575080, 1.081232, 1.175304>, <-0.393263, 0.778367, 1.220043>, <-0.215530, 0.332564, 1.130473>, <-0.089280, 0.000000, 1.114731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.377436, 1.081232, 1.713488>, <0.162226, 1.081232, 1.471734>, <-0.014631, 1.081232, 1.312313>, 
      <0.201678, 1.525540, 1.454440>, <0.366085, 1.525540, 1.282209>, <-0.048420, 1.473321, 1.201235>, <-0.225276, 1.473321, 1.041814>, 
      <-0.167654, 1.721284, 0.632881>, <-0.307129, 1.721284, 0.439905>, <-0.600225, 1.701959, 0.459425>, <-0.789139, 1.701959, 0.604355>, 
      <-0.457307, 2.015361, 0.171189>, <-0.596783, 2.015361, -0.021787>, <-0.873630, 2.015361, 0.145892>, <-1.062544, 2.015361, 0.290822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.220006, 0.808097, 2.150845>, <-0.242420, 0.337888, 2.063625>, <-0.405823, 0.000000, 2.127452>, 
      <0.377436, 1.081232, 1.713488>, <0.384413, 0.808097, 1.978614>, <-0.017281, 0.337888, 2.141120>, <-0.180684, 0.000000, 2.204948>, 
      <0.162226, 1.081232, 1.471734>, <0.300901, 0.823106, 1.649813>, <-0.059807, 0.329359, 1.813520>, <-0.050845, 0.000000, 1.908464>, 
      <-0.014631, 1.081232, 1.312313>, <0.124045, 0.823106, 1.490391>, <0.011227, 0.329359, 1.586259>, <0.020189, 0.000000, 1.681203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.201678, 1.525540, 1.454440>, <-0.167654, 1.721284, 0.632881>, <-0.457307, 2.015361, 0.171189>, 
      <0.007386, 1.081232, 2.101148>, <-0.003964, 1.525540, 1.669869>, <0.006805, 1.721284, 0.874259>, <-0.282849, 2.015361, 0.412566>, 
      <-0.337436, 1.081232, 2.081627>, <-0.313593, 1.469474, 1.986193>, <-0.303290, 1.789057, 1.072779>, <-0.364726, 2.015361, 0.748095>, 
      <-0.558650, 1.081232, 1.882221>, <-0.534807, 1.469474, 1.786787>, <-0.539586, 1.789057, 1.254059>, <-0.601022, 2.015361, 0.929375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.213029, 1.081232, 1.885720>, <0.007386, 1.081232, 2.101148>, <-0.337436, 1.081232, 2.081627>, <-0.558650, 1.081232, 1.882221>, 
      <0.220006, 0.808097, 2.150845>, <0.014363, 0.808097, 2.366274>, <-0.358612, 0.736413, 2.166387>, <-0.579826, 0.736413, 1.966981>, 
      <-0.242420, 0.337888, 2.063625>, <-0.524027, 0.337888, 1.966692>, <-0.770475, 0.332481, 1.827886>, <-0.681624, 0.332481, 1.543625>, 
      <-0.405823, 0.000000, 2.127452>, <-0.687430, 0.000000, 2.030520>, <-0.813641, 0.000000, 1.709033>, <-0.724791, 0.000000, 1.424772>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.576448, -0.198443, 0.535137>, <0.576448, -0.198443, 0.262238>, <0.349236, -0.198443, 0.027343>, <0.076448, -0.198443, 0.035137>, 
      <0.576448, -0.138910, 0.535137>, <0.576448, -0.138910, 0.262238>, <0.349236, -0.138910, 0.027343>, <0.076448, -0.138910, 0.035137>, 
      <0.620136, -0.039925, 0.541587>, <0.620136, -0.039925, 0.268688>, <0.393748, -0.036435, 0.012000>, <0.120960, -0.036435, 0.019794>, 
      <0.576448, 0.000000, 0.535137>, <0.576448, 0.000000, 0.262238>, <0.349236, 0.000000, 0.027343>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.076448, -0.198443, 0.823016>, <0.299025, -0.198443, 0.816657>, <0.576448, -0.198443, 0.757805>, <0.576448, -0.198443, 0.535137>, 
      <0.076448, -0.138910, 0.823016>, <0.299025, -0.138910, 0.816657>, <0.576448, -0.138910, 0.757805>, <0.576448, -0.138910, 0.535137>, 
      <0.109274, -0.049569, 0.819921>, <0.331851, -0.049569, 0.813561>, <0.620136, -0.039925, 0.764255>, <0.620136, -0.039925, 0.541587>, 
      <0.076448, 0.000000, 0.823016>, <0.299025, 0.000000, 0.816657>, <0.576448, 0.000000, 0.757805>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.198443, 0.803544>, <-0.161558, -0.198443, 0.829816>, <0.076448, -0.198443, 0.823016>, 
      <-0.484158, -0.138910, 0.565440>, <-0.484158, -0.138910, 0.803544>, <-0.161558, -0.138910, 0.829816>, <0.076448, -0.138910, 0.823016>, 
      <-0.457077, -0.045906, 0.538917>, <-0.457077, -0.045906, 0.777020>, <-0.128733, -0.049569, 0.826721>, <0.109274, -0.049569, 0.819921>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.803544>, <-0.161558, 0.000000, 0.829816>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.484158, -0.198443, 0.565440>, <-0.484158, -0.138910, 0.565440>, <-0.457077, -0.045906, 0.538917>, <-0.484158, 0.000000, 0.565440>, 
      <-0.484158, -0.198443, 0.267617>, <-0.484158, -0.138910, 0.267617>, <-0.457077, -0.045906, 0.241093>, <-0.484158, 0.000000, 0.267617>, 
      <-0.221254, -0.198443, 0.043643>, <-0.221254, -0.138910, 0.043643>, <-0.176742, -0.036435, 0.028300>, <-0.221254, 0.000000, 0.043643>, 
      <0.076448, -0.198443, 0.035137>, <0.076448, -0.138910, 0.035137>, <0.120960, -0.036435, 0.019794>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>, 
      <0.812457, 5.626361, -2.351572>, <0.812457, 5.566828, -2.351572>, <0.845476, 5.467288, -2.381637>, <0.812457, 5.427918, -2.351572>, 
      <0.585227, 5.626361, -2.586450>, <0.585227, 5.566828, -2.586450>, <0.600840, 5.476916, -2.616443>, <0.585227, 5.427918, -2.586450>, 
      <0.312440, 5.626361, -2.578635>, <0.312440, 5.566828, -2.578635>, <0.328052, 5.476916, -2.608629>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>, 
      <0.535075, 5.626361, -1.797132>, <0.535075, 5.566828, -1.797132>, <0.572463, 5.472019, -1.811323>, <0.535075, 5.427918, -1.797132>, 
      <0.812493, 5.626361, -1.856004>, <0.812493, 5.566828, -1.856004>, <0.845513, 5.467288, -1.886070>, <0.812493, 5.427918, -1.856004>, 
      <0.812477, 5.626361, -2.078672>, <0.812477, 5.566828, -2.078672>, <0.845496, 5.467288, -2.108737>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248127, 5.566828, -2.048291>, <-0.222901, 5.481799, -2.050457>, <-0.248127, 5.427918, -2.048291>, 
      <-0.248110, 5.626361, -1.810188>, <-0.248110, 5.566828, -1.810188>, <-0.222884, 5.481799, -1.812353>, <-0.248110, 5.427918, -1.810188>, 
      <0.074492, 5.626361, -1.783939>, <0.074492, 5.566828, -1.783939>, <0.111880, 5.472019, -1.798129>, <0.074492, 5.427918, -1.783939>, 
      <0.312498, 5.626361, -1.790756>, <0.312498, 5.566828, -1.790756>, <0.349886, 5.472019, -1.804947>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.248127, 5.626361, -2.048291>, <-0.248149, 5.626361, -2.346115>, <0.014739, 5.626361, -2.570108>, <0.312440, 5.626361, -2.578635>, 
      <-0.248127, 5.566828, -2.048291>, <-0.248149, 5.566828, -2.346115>, <0.014739, 5.566828, -2.570108>, <0.312440, 5.566828, -2.578635>, 
      <-0.222901, 5.481799, -2.050457>, <-0.222923, 5.481799, -2.348280>, <0.030351, 5.476916, -2.600101>, <0.328052, 5.476916, -2.608629>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248149, 5.427918, -2.346115>, <0.014739, 5.427918, -2.570108>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>, 
      <0.053971, 4.666623, -1.448852>, <0.284170, 4.666623, -1.595421>, <0.174382, 4.607182, -1.900465>, <0.021298, 4.607182, -2.126384>, 
      <0.517220, 5.075879, -1.809835>, <0.517200, 5.075879, -2.082735>, <0.477637, 5.090263, -2.379763>, <0.204850, 5.090263, -2.371949>, 
      <0.812477, 5.427918, -2.078672>, <0.812457, 5.427918, -2.351572>, <0.585227, 5.427918, -2.586450>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>, 
      <-0.522392, 4.696657, -1.627402>, <-0.397485, 4.696657, -1.443067>, <-0.133856, 4.666623, -1.329261>, <0.053971, 4.666623, -1.448852>, 
      <0.019644, 5.082481, -1.679607>, <0.242221, 5.082481, -1.685983>, <0.517236, 5.075879, -1.587167>, <0.517220, 5.075879, -1.809835>, 
      <0.312498, 5.427918, -1.790756>, <0.535075, 5.427918, -1.797132>, <0.812493, 5.427918, -1.856004>, <0.812477, 5.427918, -2.078672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>, 
      <-0.779386, 4.656022, -2.214925>, <-0.980234, 4.656022, -2.087044>, <-0.655957, 4.696657, -1.824516>, <-0.522392, 4.696657, -1.627402>, 
      <-0.402100, 5.099049, -2.035075>, <-0.402082, 5.099049, -1.796971>, <-0.218362, 5.082481, -1.672789>, <0.019644, 5.082481, -1.679607>, 
      <-0.248127, 5.427918, -2.048291>, <-0.248110, 5.427918, -1.810188>, <0.074492, 5.427918, -1.783939>, <0.312498, 5.427918, -1.790756>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.836224, 4.370247, -1.997811>, <-0.779386, 4.656022, -2.214925>, <-0.402100, 5.099049, -2.035075>, <-0.248127, 5.427918, -2.048291>, 
      <-0.585001, 4.370247, -2.157766>, <-0.528163, 4.656022, -2.374880>, <-0.402121, 5.099049, -2.332898>, <-0.248149, 5.427918, -2.346115>, 
      <-0.254871, 4.370247, -2.056291>, <-0.145767, 4.607182, -2.372936>, <-0.092851, 5.090263, -2.363421>, <0.014739, 5.427918, -2.570108>, 
      <-0.087806, 4.370247, -1.809739>, <0.021298, 4.607182, -2.126384>, <0.204850, 5.090263, -2.371949>, <0.312440, 5.427918, -2.578635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>, 
      <-1.069952, 3.613722, 0.048729>, <-0.879086, 3.613722, 0.243780>, <-0.578520, 3.575232, 0.047883>, <-0.389001, 3.575232, -0.148476>, 
      <-0.622336, 3.987164, -0.693640>, <-0.392137, 3.987164, -0.840209>, <-0.144231, 3.915270, -0.975778>, <-0.297315, 3.915270, -1.201697>, 
      <-0.241030, 4.370247, -1.119433>, <-0.010831, 4.370247, -1.266002>, <0.065278, 4.370247, -1.583820>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>, 
      <-1.142715, 3.545331, -0.498640>, <-1.297350, 3.545331, -0.338424>, <-1.225686, 3.613722, -0.110419>, <-1.069952, 3.613722, 0.048729>, 
      <-1.021373, 3.988560, -1.104980>, <-0.896467, 3.988560, -0.920645>, <-0.810163, 3.987164, -0.574049>, <-0.622336, 3.987164, -0.693640>, 
      <-0.752406, 4.370247, -1.386583>, <-0.627499, 4.370247, -1.202248>, <-0.428857, 4.370247, -0.999842>, <-0.241030, 4.370247, -1.119433>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>, 
      <-0.630548, 3.514007, -0.842063>, <-0.797077, 3.514007, -1.012244>, <-0.977360, 3.545331, -0.669961>, <-1.142715, 3.545331, -0.498640>, 
      <-0.932696, 3.885198, -1.629301>, <-1.133543, 3.885198, -1.501419>, <-1.154938, 3.988560, -1.302094>, <-1.021373, 3.988560, -1.104980>, 
      <-0.836224, 4.370247, -1.997811>, <-1.037072, 4.370247, -1.869929>, <-0.885971, 4.370247, -1.583696>, <-0.752406, 4.370247, -1.386583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.696980, 3.171135, -0.333729>, <-0.630548, 3.514007, -0.842063>, <-0.932696, 3.885198, -1.629301>, <-0.836224, 4.370247, -1.997811>, 
      <-0.488683, 3.171135, -0.120865>, <-0.422251, 3.514007, -0.629199>, <-0.681473, 3.885198, -1.789256>, <-0.585001, 4.370247, -2.157766>, 
      <-0.519942, 3.171135, 0.223092>, <-0.182172, 3.575232, -0.362767>, <-0.464380, 3.915270, -1.448249>, <-0.254871, 4.370247, -2.056291>, 
      <-0.726770, 3.171135, 0.437383>, <-0.389001, 3.575232, -0.148476>, <-0.297315, 3.915270, -1.201697>, <-0.087806, 4.370247, -1.809739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>, 
      <-2.299322, 2.433902, 0.927982>, <-2.456427, 2.433902, 1.151123>, <-2.067432, 2.609972, 1.414828>, <-1.839895, 2.609972, 1.565496>, 
      <-1.664665, 2.890382, 0.671393>, <-1.473799, 2.890382, 0.866444>, <-1.188084, 2.845969, 1.105167>, <-0.998565, 2.845969, 0.908809>, 
      <-1.433836, 3.171135, 0.429716>, <-1.242971, 3.171135, 0.624766>, <-0.916290, 3.171135, 0.633741>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>, 
      <-1.705847, 2.441113, 0.750588>, <-1.891503, 2.441113, 0.627653>, <-2.171134, 2.433902, 0.745913>, <-2.299322, 2.433902, 0.927982>, 
      <-1.398131, 2.837870, 0.206371>, <-1.552766, 2.837870, 0.366587>, <-1.820398, 2.890382, 0.512245>, <-1.664665, 2.890382, 0.671393>, 
      <-1.277811, 3.171135, -0.125740>, <-1.432447, 3.171135, 0.034476>, <-1.589570, 3.171135, 0.270568>, <-1.433836, 3.171135, 0.429716>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 2.015361, 1.493493>, <-1.155416, 2.015361, 1.298803>, <-1.404070, 2.015361, 1.091604>, <-1.602595, 2.015361, 0.960147>, 
      <-1.157934, 2.534113, 1.086776>, <-1.020861, 2.534113, 0.892087>, <-1.507322, 2.441113, 0.882046>, <-1.705847, 2.441113, 0.750588>, 
      <-0.769447, 2.797116, 0.220784>, <-0.935977, 2.797116, 0.050604>, <-1.232776, 2.837870, 0.035050>, <-1.398131, 2.837870, 0.206371>, 
      <-0.696980, 3.171135, -0.333729>, <-0.863509, 3.171135, -0.503909>, <-1.112457, 3.171135, -0.297061>, <-1.277811, 3.171135, -0.125740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.292489, 2.015361, 1.493493>, <-1.157934, 2.534113, 1.086776>, <-0.769447, 2.797116, 0.220784>, <-0.696980, 3.171135, -0.333729>, 
      <-1.463942, 2.015361, 1.737014>, <-1.329388, 2.534113, 1.330297>, <-0.561151, 2.797116, 0.433648>, <-0.488683, 3.171135, -0.120865>, 
      <-1.807850, 2.015361, 1.768800>, <-1.591577, 2.609972, 1.729925>, <-0.791737, 2.845969, 0.694517>, <-0.519942, 3.171135, 0.223092>, 
      <-2.056168, 2.015361, 1.604371>, <-1.839895, 2.609972, 1.565496>, <-0.998565, 2.845969, 0.908809>, <-0.726770, 3.171135, 0.437383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 1.081232, 0.328402>, <-1.071818, 1.081232, 0.214477>, <-1.380118, 1.081232, 0.322883>, <-1.486914, 1.081232, 0.574017>, 
      <-1.243411, 1.388319, 0.385170>, <-1.491394, 1.388319, 0.271244>, <-1.669056, 1.354284, 0.535491>, <-1.775853, 1.354284, 0.786626>, 
      <-2.030767, 1.513816, 0.883378>, <-2.187872, 1.513816, 1.106520>, <-2.437514, 1.592486, 1.481350>, <-2.209977, 1.592486, 1.632018>, 
      <-2.177158, 2.015361, 0.907692>, <-2.334263, 2.015361, 1.130834>, <-2.283705, 2.015361, 1.453703>, <-2.056168, 2.015361, 1.604371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.823836, 1.081232, 0.328402>, <-0.395183, 0.767501, 0.270407>, <0.184320, 0.358354, 0.477244>, <0.576448, 0.000000, 0.535137>, 
      <-1.071818, 1.081232, 0.214477>, <-0.643165, 0.767501, 0.156481>, <0.184320, 0.358354, 0.204345>, <0.576448, 0.000000, 0.262238>, 
      <-1.380118, 1.081232, 0.322883>, <-1.000237, 0.722238, 0.043357>, <-0.093932, 0.362750, 0.180100>, <0.349236, 0.000000, 0.027343>, 
      <-1.486914, 1.081232, 0.574017>, <-1.107034, 0.722238, 0.294492>, <-0.366719, 0.362750, 0.187894>, <0.076448, 0.000000, 0.035137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 1.081232, 0.902929>, <-0.683835, 1.081232, 0.698019>, <-0.621499, 1.081232, 0.421358>, <-0.823836, 1.081232, 0.328402>, 
      <-1.011060, 1.369409, 0.922537>, <-0.923921, 1.369409, 0.717628>, <-1.041074, 1.388319, 0.478126>, <-1.243411, 1.388319, 0.385170>, 
      <-1.522739, 1.686080, 1.122222>, <-1.708394, 1.686080, 0.999287>, <-1.902580, 1.513816, 0.701310>, <-2.030767, 1.513816, 0.883378>, 
      <-1.602595, 2.015361, 0.960147>, <-1.788250, 2.015361, 0.837212>, <-2.048971, 2.015361, 0.725623>, <-2.177158, 2.015361, 0.907692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.770974, 1.081232, 0.902929>, <-0.507092, 0.764493, 0.881377>, <-0.151174, 0.343728, 0.844481>, <0.076448, 0.000000, 0.823016>, 
      <-0.683835, 1.081232, 0.698019>, <-0.419952, 0.764493, 0.676467>, <0.071403, 0.343728, 0.838122>, <0.299025, 0.000000, 0.816657>, 
      <-0.621499, 1.081232, 0.421358>, <-0.192846, 0.767501, 0.363363>, <0.184320, 0.358354, 0.699912>, <0.576448, 0.000000, 0.757805>, 
      <-0.823836, 1.081232, 0.328402>, <-0.395183, 0.767501, 0.270407>, <0.184320, 0.358354, 0.477244>, <0.576448, 0.000000, 0.535137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.022701, 1.081232, 1.404218>, <-0.864153, 1.081232, 1.122042>, <-0.770974, 1.081232, 0.902929>, 
      <-1.337082, 1.325614, 1.417354>, <-1.120719, 1.325614, 1.516753>, <-1.104240, 1.369409, 1.141650>, <-1.011060, 1.369409, 0.922537>, 
      <-1.349758, 1.794570, 1.666600>, <-1.212685, 1.794570, 1.471910>, <-1.324214, 1.686080, 1.253680>, <-1.522739, 1.686080, 1.122222>, 
      <-1.292489, 2.015361, 1.493493>, <-1.155416, 2.015361, 1.298803>, <-1.404070, 2.015361, 1.091604>, <-1.602595, 2.015361, 0.960147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.083811, 0.694152, 1.126572>, <-0.690470, 0.349729, 0.767509>, <-0.484158, 0.000000, 0.565440>, 
      <-1.022701, 1.081232, 1.404218>, <-0.867448, 0.694152, 1.225971>, <-0.690470, 0.349729, 1.005612>, <-0.484158, 0.000000, 0.803544>, 
      <-0.864153, 1.081232, 1.122042>, <-0.600271, 0.764493, 1.100490>, <-0.389180, 0.343728, 0.851281>, <-0.161558, 0.000000, 0.829816>, 
      <-0.770974, 1.081232, 0.902929>, <-0.507092, 0.764493, 0.881377>, <-0.151174, 0.343728, 0.844481>, <0.076448, 0.000000, 0.823016>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.337082, 1.325614, 1.417354>, <-1.349758, 1.794570, 1.666600>, <-1.292489, 2.015361, 1.493493>, 
      <-1.509694, 1.081232, 1.180488>, <-1.607712, 1.325614, 1.293024>, <-1.521212, 1.794570, 1.910121>, <-1.463942, 2.015361, 1.737014>, 
      <-1.603465, 1.081232, 0.848088>, <-1.892403, 1.354284, 1.060696>, <-1.961659, 1.592486, 1.796447>, <-1.807850, 2.015361, 1.768800>, 
      <-1.486914, 1.081232, 0.574017>, <-1.775853, 1.354284, 0.786626>, <-2.209977, 1.592486, 1.632018>, <-2.056168, 2.015361, 1.604371>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.239064, 1.081232, 1.304818>, <-1.509694, 1.081232, 1.180488>, <-1.603465, 1.081232, 0.848088>, <-1.486914, 1.081232, 0.574017>, 
      <-1.083811, 0.694152, 1.126572>, <-1.354441, 0.694152, 1.002242>, <-1.223585, 0.722238, 0.568562>, <-1.107034, 0.722238, 0.294492>, 
      <-0.690470, 0.349729, 0.767509>, <-0.690470, 0.349729, 0.469685>, <-0.664421, 0.362750, 0.196400>, <-0.366719, 0.362750, 0.187894>, 
      <-0.484158, 0.000000, 0.565440>, <-0.484158, 0.000000, 0.267617>, <-0.221254, 0.000000, 0.043643>, <0.076448, 0.000000, 0.035137>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <0.1416, 0.361831, 0.0036>
}
#declare segMshiftMA = union {
  object { Blatt8 }
  object { sPatchObj5 }
  translate  <-0.363682, 0.695127, 11.654475>
}
#declare BezPtch005 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt14 = union {
  cone { // Cone293
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch005 }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 15.546656>
  translate  <0.250194, 2.35502, 2.682482>
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.306502, -0.198443, 0.503044>, <0.154975, -0.198443, 0.730010>, <0.213519, -0.198443, 1.051528>, <0.444720, -0.198443, 1.196511>, 
      <0.306502, -0.138910, 0.503044>, <0.154975, -0.138910, 0.730010>, <0.213519, -0.138910, 1.051528>, <0.444720, -0.138910, 1.196511>, 
      <0.277127, -0.051562, 0.507806>, <0.125600, -0.051562, 0.734772>, <0.174932, -0.040910, 1.071062>, <0.406133, -0.040910, 1.216045>, 
      <0.306502, 0.000000, 0.503044>, <0.154975, 0.000000, 0.730010>, <0.213519, 0.000000, 1.051528>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.882189, -0.198443, 0.541244>, <0.693544, -0.198443, 0.422947>, <0.430138, -0.198443, 0.317854>, <0.306502, -0.198443, 0.503044>, 
      <0.882189, -0.138910, 0.541244>, <0.693544, -0.138910, 0.422947>, <0.430138, -0.138910, 0.317854>, <0.306502, -0.138910, 0.503044>, 
      <0.865420, -0.051004, 0.566965>, <0.676775, -0.051004, 0.448668>, <0.400763, -0.051562, 0.322616>, <0.277127, -0.051562, 0.507806>, 
      <0.882189, 0.000000, 0.541244>, <0.693544, 0.000000, 0.422947>, <0.430138, 0.000000, 0.317854>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.337625, -0.198443, 0.868714>, <1.083911, -0.198443, 0.667741>, <0.882189, -0.198443, 0.541244>, 
      <1.205418, -0.138910, 1.066741>, <1.337625, -0.138910, 0.868714>, <1.083911, -0.138910, 0.667741>, <0.882189, -0.138910, 0.541244>, 
      <1.184046, -0.040947, 1.104300>, <1.316252, -0.040947, 0.906273>, <1.067142, -0.051004, 0.693461>, <0.865420, -0.051004, 0.566965>, 
      <1.205418, 0.000000, 1.066741>, <1.337625, 0.000000, 0.868714>, <1.083911, 0.000000, 0.667741>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.205418, -0.198443, 1.066741>, <1.205418, -0.138910, 1.066741>, <1.184046, -0.040947, 1.104300>, <1.205418, 0.000000, 1.066741>, 
      <1.040052, -0.198443, 1.314436>, <1.040052, -0.138910, 1.314436>, <1.018680, -0.040947, 1.351995>, <1.040052, 0.000000, 1.314436>, 
      <0.697037, -0.198443, 1.354735>, <0.697037, -0.138910, 1.354735>, <0.658450, -0.040910, 1.374270>, <0.697037, 0.000000, 1.354735>, 
      <0.444720, -0.198443, 1.196511>, <0.444720, -0.138910, 1.196511>, <0.406133, -0.040910, 1.216045>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>, 
      <-0.855631, 5.429722, 0.730006>, <-0.803530, 5.400920, 0.730006>, <-0.733936, 5.361541, 0.721743>, <-0.681960, 5.333712, 0.730007>, 
      <-0.827295, 5.480978, 1.051520>, <-0.775194, 5.452176, 1.051520>, <-0.690273, 5.431881, 1.050960>, <-0.653624, 5.384969, 1.051520>, 
      <-0.715431, 5.683328, 1.196486>, <-0.663330, 5.654525, 1.196486>, <-0.578409, 5.634231, 1.195926>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>, 
      <-0.595074, 5.901042, 0.422904>, <-0.542973, 5.872240, 0.422904>, <-0.464206, 5.839552, 0.400091>, <-0.421402, 5.805032, 0.422904>, 
      <-0.722518, 5.670511, 0.317830>, <-0.670416, 5.641708, 0.317830>, <-0.600822, 5.602329, 0.309567>, <-0.548846, 5.574500, 0.317830>, 
      <-0.782328, 5.562320, 0.503029>, <-0.730227, 5.533517, 0.503029>, <-0.660632, 5.494138, 0.494766>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.295297, 6.320257, 1.066661>, <-0.202994, 6.299939, 1.044549>, <-0.173727, 6.253049, 1.066661>, 
      <-0.283442, 6.464750, 0.868624>, <-0.231340, 6.435948, 0.868624>, <-0.139038, 6.415630, 0.846512>, <-0.109770, 6.368740, 0.868624>, 
      <-0.406199, 6.242695, 0.667669>, <-0.354098, 6.213892, 0.667669>, <-0.275331, 6.181205, 0.644856>, <-0.232528, 6.146685, 0.667669>, 
      <-0.503800, 6.066146, 0.541187>, <-0.451699, 6.037344, 0.541187>, <-0.372932, 6.004656, 0.518374>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.347398, 6.349060, 1.066661>, <-0.427396, 6.204352, 1.314368>, <-0.593351, 5.904158, 1.354692>, <-0.715431, 5.683328, 1.196486>, 
      <-0.295297, 6.320257, 1.066661>, <-0.375294, 6.175549, 1.314368>, <-0.541249, 5.875356, 1.354692>, <-0.663330, 5.654525, 1.196486>, 
      <-0.202994, 6.299939, 1.044549>, <-0.282992, 6.155232, 1.292256>, <-0.456328, 5.855060, 1.354132>, <-0.578409, 5.634231, 1.195926>, 
      <-0.173727, 6.253049, 1.066661>, <-0.253725, 6.108342, 1.314368>, <-0.419679, 5.808149, 1.354692>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>, 
      <0.333387, 5.140495, 0.666297>, <0.146841, 4.941398, 0.660378>, <0.089060, 4.814777, 1.059697>, <0.090343, 4.816146, 1.332590>, 
      <-0.246561, 5.272440, 0.560594>, <-0.319864, 5.139843, 0.787572>, <-0.398275, 5.058113, 1.055421>, <-0.286411, 5.260462, 1.200388>, 
      <-0.608657, 5.466310, 0.503029>, <-0.681960, 5.333712, 0.730007>, <-0.653624, 5.384969, 1.051520>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>, 
      <0.632096, 5.471738, 1.114818>, <0.631049, 5.470621, 0.892155>, <0.485597, 5.302945, 0.671125>, <0.333387, 5.140495, 0.666297>, 
      <0.018129, 5.689274, 0.726800>, <-0.073145, 5.524170, 0.608517>, <-0.186750, 5.380631, 0.375396>, <-0.246561, 5.272440, 0.560594>, 
      <-0.330128, 5.970136, 0.541187>, <-0.421402, 5.805032, 0.422904>, <-0.548846, 5.574500, 0.317830>, <-0.608657, 5.466310, 0.503029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>, 
      <0.559724, 5.359637, 1.785183>, <0.722485, 5.533348, 1.790346>, <0.633215, 5.472933, 1.352916>, <0.632096, 5.471738, 1.114818>, 
      <0.087598, 5.834381, 1.264095>, <0.151555, 5.950072, 1.066059>, <0.115730, 5.865823, 0.853283>, <0.018129, 5.689274, 0.726800>, 
      <-0.173727, 6.253049, 1.066661>, <-0.109770, 6.368740, 0.868624>, <-0.232528, 6.146685, 0.667669>, <-0.330128, 5.970136, 0.541187>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.600965, 4.829686, 1.783163>, <0.559724, 5.359637, 1.785183>, <0.087598, 5.834381, 1.264095>, <-0.173727, 6.253049, 1.066661>, 
      <0.397381, 4.612405, 1.776704>, <0.356140, 5.142357, 1.778724>, <0.007600, 5.689674, 1.511802>, <-0.253725, 6.108342, 1.314368>, 
      <0.248176, 4.453163, 1.509005>, <0.091744, 4.817640, 1.630407>, <-0.164330, 5.481292, 1.358594>, <-0.419679, 5.808149, 1.354692>, 
      <0.246776, 4.451668, 1.211188>, <0.090343, 4.816146, 1.332590>, <-0.286411, 5.260462, 1.200388>, <-0.541760, 5.587319, 1.196486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>, 
      <0.882376, 3.995773, 0.849049>, <0.841315, 3.966481, 0.580851>, <0.516590, 3.777855, 0.584002>, <0.299515, 3.623001, 0.642080>, 
      <0.833105, 4.538882, 0.772586>, <0.646558, 4.339785, 0.766668>, <0.405989, 4.076356, 0.813740>, <0.407272, 4.077726, 1.086633>, 
      <0.595977, 4.824362, 0.722149>, <0.409430, 4.625265, 0.716231>, <0.245493, 4.450299, 0.938295>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>, 
      <0.621171, 3.839677, 1.368932>, <0.798289, 3.966028, 1.321545>, <0.915880, 4.019673, 1.067881>, <0.882376, 3.995773, 0.849049>, 
      <0.944036, 4.565423, 1.345753>, <0.942989, 4.564306, 1.123091>, <0.985314, 4.701332, 0.777415>, <0.833105, 4.538882, 0.772586>, 
      <0.785349, 5.026474, 1.228274>, <0.784302, 5.025357, 1.005612>, <0.748186, 4.986812, 0.726978>, <0.595977, 4.824362, 0.722149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>, 
      <0.099322, 3.489870, 1.437820>, <0.135148, 3.515427, 1.671821>, <0.431775, 3.704567, 1.419605>, <0.621171, 3.839677, 1.368932>, 
      <0.647941, 4.226036, 1.780862>, <0.810702, 4.399747, 1.786026>, <0.945155, 4.566618, 1.583851>, <0.944036, 4.565423, 1.345753>, 
      <0.600965, 4.829686, 1.783163>, <0.763726, 5.003397, 1.788327>, <0.786468, 5.027669, 1.466372>, <0.785349, 5.026474, 1.228274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.077730, 3.021803, 1.054346>, <0.099322, 3.489870, 1.437820>, <0.647941, 4.226036, 1.780862>, <0.600965, 4.829686, 1.783163>, 
      <0.032918, 2.989836, 0.761653>, <0.054511, 3.457903, 1.145127>, <0.444357, 4.008756, 1.774404>, <0.397381, 4.612405, 1.776704>, 
      <0.209558, 3.115845, 0.492946>, <0.062615, 3.454004, 0.705462>, <0.408672, 4.079220, 1.384450>, <0.248176, 4.453163, 1.509005>, 
      <0.446457, 3.284843, 0.429564>, <0.299515, 3.623001, 0.642080>, <0.407272, 4.077726, 1.086633>, <0.246776, 4.451668, 1.211188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>, 
      <0.842239, 2.712652, 0.652879>, <1.079409, 2.805129, 0.554528>, <1.039943, 2.771892, 0.171966>, <0.941576, 2.733537, -0.079682>, 
      <0.963539, 3.228570, 0.806736>, <0.922478, 3.199278, 0.538538>, <0.788065, 3.153108, 0.191378>, <0.570991, 2.998253, 0.249456>, 
      <0.921719, 3.623881, 0.828538>, <0.880658, 3.594589, 0.560340>, <0.663532, 3.439697, 0.371486>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>, 
      <0.313144, 2.546508, 0.450622>, <0.393406, 2.577804, 0.655950>, <0.648725, 2.637197, 0.733127>, <0.842239, 2.712652, 0.652879>, 
      <0.512441, 2.929325, 1.049401>, <0.689559, 3.055676, 1.002013>, <0.997042, 3.252470, 1.025568>, <0.963539, 3.228570, 0.806736>, 
      <0.565004, 3.369410, 1.203870>, <0.742122, 3.495762, 1.156482>, <0.955222, 3.647781, 1.047370>, <0.921719, 3.623881, 0.828538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>, 
      <0.147649, 2.501586, -0.170179>, <-0.059280, 2.420900, -0.084369>, <0.227320, 2.513043, 0.231060>, <0.313144, 2.546508, 0.450622>, 
      <0.059256, 2.621347, 0.726264>, <0.095082, 2.646904, 0.960265>, <0.323045, 2.794215, 1.100074>, <0.512441, 2.929325, 1.049401>, 
      <0.077730, 3.021803, 1.054346>, <0.113555, 3.047360, 1.288347>, <0.375607, 3.234301, 1.254543>, <0.565004, 3.369410, 1.203870>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.478357, 2.171840, -0.394332>, <0.147649, 2.501586, -0.170179>, <0.059256, 2.621347, 0.726264>, <0.077730, 3.021803, 1.054346>, 
      <0.737188, 2.272763, -0.501665>, <0.406479, 2.602509, -0.277512>, <0.014445, 2.589380, 0.433571>, <0.032918, 2.989836, 0.761653>, 
      <1.020113, 2.383082, -0.337147>, <0.834225, 2.691678, -0.354314>, <0.334091, 2.829256, 0.312838>, <0.209558, 3.115845, 0.492946>, 
      <1.127464, 2.424940, -0.062515>, <0.941576, 2.733537, -0.079682>, <0.570991, 2.998253, 0.249456>, <0.446457, 3.284843, 0.429564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <1.184052, 1.106319, 0.616299>, <1.499098, 1.137656, 0.697322>, <1.726240, 1.160250, 0.547756>, 
      <1.129392, 1.459057, 0.396667>, <1.271676, 1.473210, 0.629109>, <1.610121, 1.531984, 0.492588>, <1.837264, 1.554577, 0.343022>, 
      <0.878420, 1.949636, 0.518860>, <1.115590, 2.042113, 0.420509>, <1.461870, 2.071445, 0.210932>, <1.363502, 2.033089, -0.040716>, 
      <0.860812, 2.320967, 0.584082>, <1.097982, 2.413444, 0.485731>, <1.225832, 2.463296, 0.189134>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>, 
      <1.184052, 1.106319, 0.616299>, <1.091978, 0.720794, 0.602838>, <0.350665, 0.343493, 0.698289>, <0.154975, 0.000000, 0.730010>, 
      <1.499098, 1.137656, 0.697322>, <1.364811, 0.660701, 0.944957>, <0.572554, 0.380657, 0.869770>, <0.213519, 0.000000, 1.051528>, 
      <1.726240, 1.160250, 0.547756>, <1.591953, 0.683295, 0.795391>, <0.803756, 0.380657, 1.014753>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.130124, 1.100955, -0.001283>, <0.925674, 1.080618, 0.194200>, <1.041768, 1.092166, 0.383857>, 
      <1.232537, 1.526577, -0.183665>, <1.047204, 1.508142, -0.061629>, <1.013298, 1.447509, 0.207010>, <1.129392, 1.459057, 0.396667>, 
      <0.558680, 1.810340, 0.016388>, <0.638942, 1.841635, 0.221717>, <0.684905, 1.874181, 0.599108>, <0.878420, 1.949636, 0.518860>, 
      <0.442740, 2.157953, 0.221430>, <0.523001, 2.189249, 0.426758>, <0.667297, 2.245512, 0.664330>, <0.860812, 2.320967, 0.584082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>, 
      <1.130124, 1.100955, -0.001283>, <1.211405, 0.701818, 0.057870>, <0.809481, 0.352635, 0.245119>, <0.693544, 0.000000, 0.422947>, 
      <0.925674, 1.080618, 0.194200>, <0.833600, 0.695093, 0.180739>, <0.625828, 0.343493, 0.286133>, <0.430138, 0.000000, 0.317854>, 
      <1.041768, 1.092166, 0.383857>, <0.949695, 0.706641, 0.370396>, <0.502192, 0.343493, 0.471323>, <0.306502, 0.000000, 0.503044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.800760, 1.167662, -0.400463>, <1.513638, 1.139103, -0.253815>, <1.315458, 1.119390, -0.123319>, 
      <1.783199, 1.603298, -0.482420>, <1.659057, 1.590950, -0.685224>, <1.430718, 1.546290, -0.314161>, <1.232537, 1.526577, -0.183665>, 
      <0.816377, 1.834805, -0.623440>, <0.609448, 1.754119, -0.537630>, <0.472855, 1.776875, -0.203174>, <0.558680, 1.810340, 0.016388>, 
      <0.478357, 2.171840, -0.394332>, <0.271428, 2.091155, -0.308522>, <0.356915, 2.124488, 0.001868>, <0.442740, 2.157953, 0.221430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.075298, 0.730756, 0.104570>, <1.407161, 0.386517, 0.712205>, <1.205418, 0.000000, 1.066741>, 
      <1.800760, 1.167662, -0.400463>, <1.951156, 0.718408, -0.098234>, <1.539367, 0.386517, 0.514178>, <1.337625, 0.000000, 0.868714>, 
      <1.513638, 1.139103, -0.253815>, <1.594919, 0.739966, -0.194662>, <1.199848, 0.352635, 0.489912>, <1.083911, 0.000000, 0.667741>, 
      <1.315458, 1.119390, -0.123319>, <1.396738, 0.720253, -0.064166>, <0.998126, 0.352635, 0.363415>, <0.882189, 0.000000, 0.541244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <1.783199, 1.603298, -0.482420>, <0.816377, 1.834805, -0.623440>, <0.478357, 2.171840, -0.394332>, 
      <2.080181, 1.195456, 0.056011>, <1.938478, 1.618744, -0.228749>, <1.075207, 1.935728, -0.730773>, <0.737188, 2.272763, -0.501665>, 
      <1.974128, 1.184907, 0.384530>, <2.085151, 1.579234, 0.179796>, <1.256151, 1.991230, -0.315348>, <1.020113, 2.383082, -0.337147>, 
      <1.726240, 1.160250, 0.547756>, <1.837264, 1.554577, 0.343022>, <1.363502, 2.033089, -0.040716>, <1.127464, 2.424940, -0.062515>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.924902, 1.180011, -0.197659>, <2.080181, 1.195456, 0.056011>, <1.974128, 1.184907, 0.384530>, <1.726240, 1.160250, 0.547756>, 
      <2.075298, 0.730756, 0.104570>, <2.230577, 0.746201, 0.358241>, <1.839840, 0.707952, 0.632165>, <1.591953, 0.683295, 0.795391>, 
      <1.407161, 0.386517, 0.712205>, <1.241794, 0.386517, 0.959900>, <1.056073, 0.380657, 1.172978>, <0.803756, 0.380657, 1.014753>, 
      <1.205418, 0.000000, 1.066741>, <1.040052, 0.000000, 1.314436>, <0.697037, 0.000000, 1.354735>, <0.444720, 0.000000, 1.196511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.165728, -0.198443, 0.579594>, <-0.423769, -0.198443, 0.490773>, <-0.719824, -0.198443, 0.629163>, <-0.801239, -0.198443, 0.889635>, 
      <-0.165728, -0.138910, 0.579594>, <-0.423769, -0.138910, 0.490773>, <-0.719824, -0.138910, 0.629163>, <-0.801239, -0.138910, 0.889635>, 
      <-0.203692, -0.044900, 0.570272>, <-0.461732, -0.044900, 0.481451>, <-0.765596, -0.033808, 0.611667>, <-0.847011, -0.033808, 0.872139>, 
      <-0.165728, 0.000000, 0.579594>, <-0.423769, 0.000000, 0.490773>, <-0.719824, 0.000000, 0.629163>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.056259, -0.198443, 1.146066>, <0.010170, -0.198443, 0.933538>, <0.044816, -0.198443, 0.652066>, <-0.165728, -0.198443, 0.579594>, 
      <-0.056259, -0.138910, 1.146066>, <0.010170, -0.138910, 0.933538>, <0.044816, -0.138910, 0.652066>, <-0.165728, -0.138910, 0.579594>, 
      <-0.100977, -0.039005, 1.150867>, <-0.034548, -0.039005, 0.938339>, <0.006853, -0.044900, 0.642744>, <-0.203692, -0.044900, 0.570272>, 
      <-0.056259, 0.000000, 1.146066>, <0.010170, 0.000000, 0.933538>, <0.044816, 0.000000, 0.652066>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.257132, -0.198443, 1.669811>, <-0.127293, -0.198443, 1.373327>, <-0.056259, -0.198443, 1.146066>, 
      <-0.482271, -0.138910, 1.592315>, <-0.257132, -0.138910, 1.669811>, <-0.127293, -0.138910, 1.373327>, <-0.056259, -0.138910, 1.146066>, 
      <-0.532826, -0.031427, 1.593172>, <-0.307686, -0.031427, 1.670667>, <-0.172011, -0.039005, 1.378128>, <-0.100977, -0.039005, 1.150867>, 
      <-0.482271, 0.000000, 1.592315>, <-0.257132, 0.000000, 1.669811>, <-0.127293, 0.000000, 1.373327>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.482271, -0.198443, 1.592315>, <-0.482271, -0.138910, 1.592315>, <-0.532826, -0.031427, 1.593172>, <-0.482271, 0.000000, 1.592315>, 
      <-0.763878, -0.198443, 1.495382>, <-0.763878, -0.138910, 1.495382>, <-0.814433, -0.031427, 1.496239>, <-0.763878, 0.000000, 1.495382>, 
      <-0.890089, -0.198443, 1.173896>, <-0.890089, -0.138910, 1.173896>, <-0.935861, -0.033808, 1.156400>, <-0.890089, 0.000000, 1.173896>, 
      <-0.801239, -0.198443, 0.889635>, <-0.801239, -0.138910, 0.889635>, <-0.847011, -0.033808, 0.872139>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>, 
      <-1.135645, 4.923207, 0.490812>, <-1.083543, 4.894404, 0.490812>, <-1.016672, 4.849124, 0.499265>, <-0.961974, 4.827198, 0.490812>, 
      <-1.278876, 4.664117, 0.629223>, <-1.226775, 4.635314, 0.629223>, <-1.152234, 4.584241, 0.661968>, <-1.105205, 4.568108, 0.629223>, 
      <-1.318257, 4.592882, 0.889701>, <-1.266155, 4.564079, 0.889701>, <-1.191614, 4.513006, 0.922445>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>, 
      <-0.925682, 5.303006, 0.933545>, <-0.873581, 5.274203, 0.933545>, <-0.794448, 5.245746, 0.949092>, <-0.752011, 5.206996, 0.933545>, 
      <-0.908930, 5.333309, 0.652070>, <-0.856829, 5.304506, 0.652070>, <-0.789958, 5.259225, 0.660524>, <-0.735259, 5.237299, 0.652071>, 
      <-1.010798, 5.149042, 0.579614>, <-0.958696, 5.120239, 0.579614>, <-0.891825, 5.074959, 0.588067>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.111808, 4.843276, 1.592358>, <-1.020927, 4.813514, 1.627003>, <-0.990239, 4.776070, 1.592358>, 
      <-1.054981, 5.069119, 1.669837>, <-1.002880, 5.040316, 1.669837>, <-0.911999, 5.010554, 1.704482>, <-0.881310, 4.973110, 1.669837>, 
      <-0.992174, 5.182731, 1.373344>, <-0.940072, 5.153928, 1.373344>, <-0.860939, 5.125471, 1.388891>, <-0.818503, 5.086722, 1.373344>, 
      <-0.957815, 5.244883, 1.146078>, <-0.905713, 5.216080, 1.146078>, <-0.826580, 5.187623, 1.161625>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.163910, 4.872079, 1.592358>, <-1.300159, 4.625618, 1.495446>, <-1.361234, 4.515141, 1.173969>, <-1.318257, 4.592882, 0.889701>, 
      <-1.111808, 4.843276, 1.592358>, <-1.248058, 4.596816, 1.495446>, <-1.309132, 4.486338, 1.173969>, <-1.266155, 4.564079, 0.889701>, 
      <-1.020927, 4.813514, 1.627003>, <-1.157177, 4.567053, 1.530091>, <-1.234591, 4.435265, 1.206713>, <-1.191614, 4.513006, 0.922445>, 
      <-0.990239, 4.776070, 1.592358>, <-1.126488, 4.529609, 1.495446>, <-1.187563, 4.419132, 1.173969>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>, 
      <0.045326, 4.803767, 0.387696>, <0.001795, 4.757308, 0.122328>, <-0.247041, 4.434546, 0.099814>, <-0.427165, 4.242303, 0.171033>, 
      <-0.473949, 4.907449, 0.523488>, <-0.598796, 4.681614, 0.434686>, <-0.757509, 4.448831, 0.387136>, <-0.796890, 4.377596, 0.647614>, 
      <-0.837127, 5.053032, 0.579614>, <-0.961974, 4.827198, 0.490812>, <-1.105205, 4.568108, 0.629223>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>, 
      <-0.149898, 4.541390, 0.922230>, <-0.002929, 4.698247, 0.864120>, <0.080844, 4.841674, 0.604220>, <0.045326, 4.803767, 0.387696>, 
      <-0.508679, 4.897343, 1.045159>, <-0.476547, 4.955466, 0.832626>, <-0.372082, 5.091715, 0.595944>, <-0.473949, 4.907449, 0.523488>, 
      <-0.784143, 5.148873, 1.146078>, <-0.752011, 5.206996, 0.933545>, <-0.735259, 5.237299, 0.652071>, <-0.837127, 5.053032, 0.579614>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>, 
      <-0.581819, 4.032846, 0.952694>, <-0.543838, 4.073382, 1.184228>, <-0.307056, 4.373660, 0.984368>, <-0.149898, 4.541390, 0.922230>, 
      <-0.759944, 4.495076, 1.332377>, <-0.651016, 4.692116, 1.409856>, <-0.543038, 4.835191, 1.272425>, <-0.508679, 4.897343, 1.045159>, 
      <-0.990239, 4.776070, 1.592358>, <-0.881310, 4.973110, 1.669837>, <-0.818503, 5.086722, 1.373344>, <-0.784143, 5.148873, 1.146078>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.321914, 3.844720, 0.641823>, <-0.581819, 4.032846, 0.952694>, <-0.759944, 4.495076, 1.332377>, <-0.990239, 4.776070, 1.592358>, 
      <-0.369421, 3.794017, 0.352218>, <-0.629325, 3.982144, 0.663089>, <-0.896194, 4.248615, 1.235465>, <-1.126488, 4.529609, 1.495446>, 
      <-0.230350, 3.942443, 0.073090>, <-0.623741, 4.032504, 0.248756>, <-0.839867, 4.299855, 0.931882>, <-1.187563, 4.419132, 1.173969>, 
      <-0.033775, 4.152243, -0.004633>, <-0.427165, 4.242303, 0.171033>, <-0.796890, 4.377596, 0.647614>, <-1.144585, 4.496872, 0.889701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>, 
      <1.025779, 4.093207, 0.381884>, <1.226493, 4.236390, 0.264894>, <1.126390, 4.232918, -0.129444>, <1.025457, 4.160915, -0.372554>, 
      <0.661213, 4.412504, 0.345586>, <0.617682, 4.366044, 0.080217>, <0.525790, 4.257618, -0.245289>, <0.345665, 4.065375, -0.174070>, 
      <0.378413, 4.592162, 0.364922>, <0.334883, 4.545702, 0.099553>, <0.146349, 4.344485, -0.075852>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>, 
      <0.543731, 3.789628, 0.194518>, <0.626086, 3.848378, 0.392879>, <0.862010, 3.976379, 0.477340>, <1.025779, 4.093207, 0.381884>, 
      <0.319543, 4.046286, 0.610188>, <0.466513, 4.203143, 0.552078>, <0.696731, 4.450411, 0.562110>, <0.661213, 4.412504, 0.345586>, 
      <0.091900, 4.286373, 0.761504>, <0.238870, 4.443230, 0.703394>, <0.413932, 4.630069, 0.581445>, <0.378413, 4.592162, 0.364922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>, 
      <0.327542, 3.702958, -0.411287>, <0.152420, 3.578032, -0.309213>, <0.455668, 3.726806, -0.017594>, <0.543731, 3.789628, 0.194518>, 
      <-0.040928, 3.641333, 0.305736>, <-0.002948, 3.681868, 0.537269>, <0.162385, 3.878556, 0.672326>, <0.319543, 4.046286, 0.610188>, 
      <-0.321914, 3.844720, 0.641823>, <-0.283934, 3.885255, 0.873356>, <-0.065257, 4.118643, 0.823642>, <0.091900, 4.286373, 0.761504>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.760471, 3.508852, -0.501665>, <0.327542, 3.702958, -0.411287>, <-0.040928, 3.641333, 0.305736>, <-0.321914, 3.844720, 0.641823>, 
      <0.979516, 3.665112, -0.629340>, <0.546587, 3.859218, -0.538961>, <-0.088435, 3.590630, 0.016131>, <-0.369421, 3.794017, 0.352218>, 
      <1.235997, 3.848078, -0.487834>, <0.915305, 4.082336, -0.637866>, <0.149090, 3.855576, -0.096347>, <-0.230350, 3.942443, 0.073090>, 
      <1.346149, 3.926657, -0.222522>, <1.025457, 4.160915, -0.372554>, <0.345665, 4.065375, -0.174070>, <-0.033775, 4.152243, -0.004633>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>, 
      <1.296997, 2.879843, 0.733703>, <1.445934, 2.937916, 0.954880>, <1.774379, 3.091461, 0.797898>, <1.976107, 3.170119, 0.631788>, 
      <1.307648, 3.418247, 0.518613>, <1.508362, 3.561430, 0.401624>, <1.841102, 3.710837, 0.204924>, <1.740168, 3.638834, -0.038185>, 
      <1.152902, 3.788800, 0.443549>, <1.353616, 3.931984, 0.326559>, <1.447082, 3.998660, 0.020587>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>, 
      <1.385444, 2.888728, 0.148511>, <1.220847, 2.824548, 0.284046>, <1.175475, 2.832459, 0.553237>, <1.296997, 2.879843, 0.733703>, 
      <0.987091, 3.240061, 0.036852>, <1.069446, 3.298811, 0.235213>, <1.143879, 3.301419, 0.614069>, <1.307648, 3.418247, 0.518613>, 
      <0.766675, 3.513278, 0.115235>, <0.849030, 3.572027, 0.313596>, <0.989133, 3.671972, 0.539005>, <1.152902, 3.788800, 0.443549>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>, 
      <1.906742, 3.131796, -0.157567>, <1.776795, 3.081127, -0.350543>, <1.561452, 2.957357, 0.003581>, <1.385444, 2.888728, 0.148511>, 
      <1.194126, 3.314419, -0.592195>, <1.019004, 3.189493, -0.490122>, <0.899027, 3.177239, -0.175260>, <0.987091, 3.240061, 0.036852>, 
      <0.760471, 3.508852, -0.501665>, <0.585350, 3.383925, -0.399592>, <0.678612, 3.450456, -0.096877>, <0.766675, 3.513278, 0.115235>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.045943, 2.783073, 0.147508>, <1.906742, 3.131796, -0.157567>, <1.194126, 3.314419, -0.592195>, <0.760471, 3.508852, -0.501665>, 
      <2.208483, 2.846450, 0.388885>, <2.069281, 3.195173, 0.083810>, <1.413171, 3.470679, -0.719869>, <0.979516, 3.665112, -0.629340>, 
      <2.132199, 2.816706, 0.724413>, <2.196260, 3.255960, 0.450507>, <1.630017, 3.560256, -0.303498>, <1.235997, 3.848078, -0.487834>, 
      <1.912047, 2.730864, 0.905694>, <1.976107, 3.170119, 0.631788>, <1.740168, 3.638834, -0.038185>, <1.346149, 3.926657, -0.222522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.727308, 1.060887, 1.042327>, <0.729459, 1.061101, 1.369123>, <0.931165, 1.081165, 1.551842>, 
      <1.130039, 1.453072, 0.877157>, <0.942531, 1.434421, 1.074558>, <1.157661, 1.492077, 1.371658>, <1.359367, 1.512140, 1.554376>, 
      <1.224179, 2.051219, 0.856463>, <1.373116, 2.109292, 1.077641>, <1.635704, 2.140586, 1.390835>, <1.837433, 2.219244, 1.224725>, 
      <1.261618, 2.477249, 0.793347>, <1.410555, 2.535322, 1.014524>, <1.710318, 2.652206, 1.071804>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>, 
      <0.727308, 1.060887, 1.042327>, <0.495765, 0.659030, 1.007652>, <-0.127188, 0.350771, 0.563600>, <-0.423769, 0.000000, 0.490773>, 
      <0.729459, 1.061101, 1.369123>, <0.275535, 0.604236, 1.366437>, <-0.224661, 0.365743, 0.818438>, <-0.719824, 0.000000, 0.629163>, 
      <0.931165, 1.081165, 1.551842>, <0.477241, 0.624300, 1.549155>, <-0.306076, 0.365743, 1.078910>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.307934, 1.118641, 0.832847>, <1.067810, 1.094756, 0.683860>, <0.914816, 1.079538, 0.844926>, 
      <1.709058, 1.529154, 0.846782>, <1.544479, 1.512783, 0.697696>, <1.283033, 1.468290, 0.716091>, <1.130039, 1.453072, 0.877157>, 
      <1.610751, 2.129575, 0.425166>, <1.446154, 2.065395, 0.560700>, <1.102656, 2.003834, 0.675998>, <1.224179, 2.051219, 0.856463>, 
      <1.482056, 2.563202, 0.267141>, <1.317459, 2.499023, 0.402676>, <1.140095, 2.429865, 0.612881>, <1.261618, 2.477249, 0.793347>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>, 
      <1.307934, 1.118641, 0.832847>, <1.024882, 0.647009, 0.994571>, <0.440830, 0.375638, 0.887301>, <0.010170, 0.000000, 0.933538>, 
      <1.067810, 1.094756, 0.683860>, <0.836267, 0.692899, 0.649185>, <0.341396, 0.350771, 0.724892>, <0.044816, 0.000000, 0.652066>, 
      <0.914816, 1.079538, 0.844926>, <0.683273, 0.677681, 0.810251>, <0.130852, 0.350771, 0.652420>, <-0.165728, 0.000000, 0.579594>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.862654, 1.173819, 1.383110>, <1.648500, 1.152517, 1.141355>, <1.472513, 1.135012, 0.981934>, 
      <2.109209, 1.609047, 1.320949>, <2.272809, 1.625320, 1.148717>, <1.885046, 1.546659, 1.006204>, <1.709058, 1.529154, 0.846782>, 
      <2.233965, 2.312047, 0.559578>, <2.104018, 2.261378, 0.366603>, <1.786758, 2.198203, 0.280236>, <1.610751, 2.129575, 0.425166>, 
      <2.045943, 2.783073, 0.147508>, <1.915997, 2.732404, -0.045468>, <1.658063, 2.631831, 0.122211>, <1.482056, 2.563202, 0.267141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.234013, 0.645627, 1.821099>, <0.146906, 0.391119, 1.581650>, <-0.482271, 0.000000, 1.592315>, 
      <1.862654, 1.173819, 1.383110>, <1.397613, 0.661900, 1.648868>, <0.372045, 0.391119, 1.659146>, <-0.257132, 0.000000, 1.669811>, 
      <1.648500, 1.152517, 1.141355>, <1.365448, 0.680885, 1.303079>, <0.303367, 0.375638, 1.327090>, <-0.127293, 0.000000, 1.373327>, 
      <1.472513, 1.135012, 0.981934>, <1.189461, 0.663379, 1.143657>, <0.374401, 0.375638, 1.099829>, <-0.056259, 0.000000, 1.146066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <2.109209, 1.609047, 1.320949>, <2.233965, 2.312047, 0.559578>, <2.045943, 2.783073, 0.147508>, 
      <1.494421, 1.137191, 1.770770>, <1.904576, 1.588692, 1.536377>, <2.396504, 2.375424, 0.800956>, <2.208483, 2.846450, 0.388885>, 
      <1.151293, 1.103061, 1.751248>, <1.579494, 1.534036, 1.753783>, <2.057585, 2.305086, 1.043444>, <2.132199, 2.816706, 0.724413>, 
      <0.931165, 1.081165, 1.551842>, <1.359367, 1.512140, 1.554376>, <1.837433, 2.219244, 1.224725>, <1.912047, 2.730864, 0.905694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.699054, 1.157546, 1.555341>, <1.494421, 1.137191, 1.770770>, <1.151293, 1.103061, 1.751248>, <0.931165, 1.081165, 1.551842>, 
      <1.234013, 0.645627, 1.821099>, <1.029380, 0.625272, 2.036528>, <0.697369, 0.646196, 1.748562>, <0.477241, 0.624300, 1.549155>, 
      <0.146906, 0.391119, 1.581650>, <-0.134701, 0.391119, 1.484718>, <-0.394926, 0.365743, 1.363171>, <-0.306076, 0.365743, 1.078910>, 
      <-0.482271, 0.000000, 1.592315>, <-0.763878, 0.000000, 1.495382>, <-0.890089, 0.000000, 1.173896>, <-0.801239, 0.000000, 0.889635>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.500000, -0.198443, 0.000000>, <0.500000, -0.198443, -0.272899>, <0.272788, -0.198443, -0.507794>, <0.000000, -0.198443, -0.500000>, 
      <0.500000, -0.138910, 0.000000>, <0.500000, -0.138910, -0.272899>, <0.272788, -0.138910, -0.507794>, <0.000000, -0.138910, -0.500000>, 
      <0.492124, -0.059010, 0.000093>, <0.492124, -0.059010, -0.272806>, <0.272471, -0.050458, -0.539386>, <-0.000317, -0.050458, -0.531592>, 
      <0.500000, 0.000000, 0.000000>, <0.500000, 0.000000, -0.272899>, <0.272788, 0.000000, -0.507794>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.198443, 0.287879>, <0.222577, -0.198443, 0.281520>, <0.500000, -0.198443, 0.222668>, <0.500000, -0.198443, 0.000000>, 
      <0.000000, -0.138910, 0.287879>, <0.222577, -0.138910, 0.281520>, <0.500000, -0.138910, 0.222668>, <0.500000, -0.138910, 0.000000>, 
      <-0.029004, -0.050709, 0.276410>, <0.193573, -0.050709, 0.270050>, <0.492124, -0.059010, 0.222761>, <0.492124, -0.059010, 0.000093>, 
      <0.000000, 0.000000, 0.287879>, <0.222577, 0.000000, 0.281520>, <0.500000, 0.000000, 0.222668>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.198443, 0.268407>, <-0.238007, -0.198443, 0.294679>, <0.000000, -0.198443, 0.287879>, 
      <-0.560606, -0.138910, 0.030303>, <-0.560606, -0.138910, 0.268407>, <-0.238007, -0.138910, 0.294679>, <0.000000, -0.138910, 0.287879>, 
      <-0.588494, -0.041496, -0.002015>, <-0.588494, -0.041496, 0.236088>, <-0.267011, -0.050709, 0.283210>, <-0.029004, -0.050709, 0.276410>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, 0.268407>, <-0.238007, 0.000000, 0.294679>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.560606, -0.198443, 0.030303>, <-0.560606, -0.138910, 0.030303>, <-0.588494, -0.041496, -0.002015>, <-0.560606, 0.000000, 0.030303>, 
      <-0.560606, -0.198443, -0.267520>, <-0.560606, -0.138910, -0.267520>, <-0.588494, -0.041496, -0.299839>, <-0.560606, 0.000000, -0.267520>, 
      <-0.297702, -0.198443, -0.491494>, <-0.297702, -0.138910, -0.491494>, <-0.298019, -0.050458, -0.523086>, <-0.297702, 0.000000, -0.491494>, 
      <0.000000, -0.198443, -0.500000>, <0.000000, -0.138910, -0.500000>, <-0.000317, -0.050458, -0.531592>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>, 
      <-0.688738, 5.731613, -0.272928>, <-0.636637, 5.702810, -0.272928>, <-0.568524, 5.652551, -0.292911>, <-0.515067, 5.635604, -0.272929>, 
      <-0.798675, 5.532749, -0.507806>, <-0.746574, 5.503946, -0.507806>, <-0.683223, 5.435931, -0.520220>, <-0.625004, 5.436739, -0.507806>, 
      <-0.930654, 5.294014, -0.499992>, <-0.878553, 5.265211, -0.499992>, <-0.815202, 5.197196, -0.512406>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>, 
      <-0.822940, 5.488857, 0.281511>, <-0.770839, 5.460054, 0.281511>, <-0.706292, 5.409803, 0.279281>, <-0.649269, 5.392847, 0.281511>, 
      <-0.688721, 5.731645, 0.222639>, <-0.636619, 5.702842, 0.222639>, <-0.568507, 5.652583, 0.202657>, <-0.515049, 5.635636, 0.222639>, 
      <-0.688729, 5.731631, -0.000029>, <-0.636627, 5.702828, -0.000029>, <-0.568514, 5.652568, -0.020011>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.149764, 4.774619, 0.030352>, <-1.086901, 4.708347, 0.040188>, <-1.028194, 4.707412, 0.030352>, 
      <-1.201857, 4.803437, 0.268456>, <-1.149755, 4.774634, 0.268456>, <-1.086893, 4.708363, 0.278291>, <-1.028186, 4.707428, 0.268456>, 
      <-1.045777, 5.085768, 0.294705>, <-0.993676, 5.056965, 0.294705>, <-0.929129, 5.006715, 0.292475>, <-0.872106, 4.989758, 0.294705>, 
      <-0.930626, 5.294064, 0.287887>, <-0.878525, 5.265261, 0.287887>, <-0.813978, 5.215011, 0.285657>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.201865, 4.803422, 0.030352>, <-1.201876, 4.803403, -0.267471>, <-1.074687, 5.033474, -0.491465>, <-0.930654, 5.294014, -0.499992>, 
      <-1.149764, 4.774619, 0.030352>, <-1.149774, 4.774600, -0.267471>, <-1.022585, 5.004672, -0.491465>, <-0.878553, 5.265211, -0.499992>, 
      <-1.086901, 4.708347, 0.040188>, <-1.086912, 4.708328, -0.257636>, <-0.959234, 4.936656, -0.503879>, <-0.815202, 5.197196, -0.512406>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028205, 4.707393, -0.267471>, <-0.901015, 4.937464, -0.491464>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>, 
      <0.673433, 5.542398, 0.382051>, <0.830828, 5.710382, 0.235482>, <0.742311, 5.615008, -0.169149>, <0.637642, 5.503297, -0.395068>, 
      <-0.070189, 5.494588, 0.166260>, <-0.070199, 5.494571, -0.106640>, <-0.075813, 5.444359, -0.390701>, <-0.207791, 5.205623, -0.382888>, 
      <-0.515057, 5.635621, -0.000029>, <-0.515067, 5.635604, -0.272929>, <-0.625004, 5.436739, -0.507806>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>, 
      <0.264924, 5.071978, 0.264958>, <0.350327, 5.163126, 0.449294>, <0.545009, 5.405335, 0.501642>, <0.673433, 5.542398, 0.382051>, 
      <-0.350982, 5.077334, 0.303765>, <-0.243295, 5.272127, 0.297389>, <-0.070181, 5.494603, 0.388928>, <-0.070189, 5.494588, 0.166260>, 
      <-0.756955, 5.198054, 0.287887>, <-0.649269, 5.392847, 0.281511>, <-0.515049, 5.635636, 0.222639>, <-0.515057, 5.635621, -0.000029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>, 
      <0.085454, 4.866228, -0.353558>, <-0.051873, 4.719663, -0.225676>, <0.173601, 4.974511, 0.067845>, <0.264924, 5.071978, 0.264958>, 
      <-0.552806, 4.699840, -0.049293>, <-0.552798, 4.699856, 0.188811>, <-0.466133, 4.869038, 0.310582>, <-0.350982, 5.077334, 0.303765>, 
      <-1.028194, 4.707412, 0.030352>, <-1.028186, 4.707428, 0.268456>, <-0.872106, 4.989758, 0.294705>, <-0.756955, 5.198054, 0.287887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.550210, 4.775516, -0.263184>, <0.085454, 4.866228, -0.353558>, <-0.552806, 4.699840, -0.049293>, <-1.028194, 4.707412, 0.030352>, 
      <0.721979, 4.958841, -0.423140>, <0.257223, 5.049553, -0.513513>, <-0.552817, 4.699822, -0.347116>, <-1.028205, 4.707393, -0.267471>, 
      <0.947700, 5.199747, -0.321664>, <0.523414, 5.381385, -0.641620>, <-0.351824, 4.945084, -0.374360>, <-0.901015, 4.937464, -0.491464>, 
      <1.061928, 5.321660, -0.075112>, <0.637642, 5.503297, -0.395068>, <-0.207791, 5.205623, -0.382888>, <-0.756983, 5.198003, -0.499992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>, 
      <1.176418, 4.228400, 1.281084>, <1.331799, 4.339244, 1.476134>, <1.598674, 4.553109, 1.259562>, <1.752959, 4.663172, 1.063204>, 
      <1.237274, 4.881539, 0.845362>, <1.394669, 5.049523, 0.698793>, <1.602658, 5.246691, 0.479642>, <1.497990, 5.134981, 0.253723>, 
      <0.957164, 5.209847, 0.615194>, <1.114559, 5.377830, 0.468625>, <1.166597, 5.433370, 0.150807>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>, 
      <1.168489, 4.198111, 0.682275>, <1.042602, 4.108307, 0.842491>, <1.049638, 4.137958, 1.121936>, <1.176418, 4.228400, 1.281084>, 
      <0.909517, 4.629264, 0.421284>, <0.994920, 4.720412, 0.605619>, <1.108851, 4.744476, 0.964953>, <1.237274, 4.881539, 0.845362>, 
      <0.607519, 4.836680, 0.348044>, <0.692922, 4.927828, 0.532379>, <0.828740, 5.072784, 0.734785>, <0.957164, 5.209847, 0.615194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>, 
      <1.584124, 4.531858, 0.291211>, <1.448555, 4.435146, 0.121030>, <1.303102, 4.294140, 0.510954>, <1.168489, 4.198111, 0.682275>, 
      <0.993460, 4.689001, -0.176992>, <0.856133, 4.542436, -0.049111>, <0.818194, 4.531798, 0.224171>, <0.909517, 4.629264, 0.421284>, 
      <0.550210, 4.775516, -0.263184>, <0.412883, 4.628950, -0.135303>, <0.516196, 4.739213, 0.150931>, <0.607519, 4.836680, 0.348044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.695413, 4.175812, 0.559968>, <1.584124, 4.531858, 0.291211>, <0.993460, 4.689001, -0.176992>, <0.550210, 4.775516, -0.263184>, 
      <1.864985, 4.296779, 0.772832>, <1.753695, 4.652825, 0.504075>, <1.165229, 4.872326, -0.336948>, <0.721979, 4.958841, -0.423140>, 
      <1.839537, 4.278626, 1.116789>, <1.921335, 4.783286, 0.848912>, <1.383762, 5.013069, 0.007171>, <0.947700, 5.199747, -0.321664>, 
      <1.671161, 4.158511, 1.331080>, <1.752959, 4.663172, 1.063204>, <1.497990, 5.134981, 0.253723>, <1.061928, 5.321660, -0.075112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>, 
      <0.518744, 2.630839, 1.116586>, <0.372372, 2.573766, 1.339727>, <0.646578, 2.695348, 1.627582>, <0.858569, 2.778007, 1.778251>, 
      <1.007584, 3.225212, 1.369456>, <1.162965, 3.336056, 1.564507>, <1.420558, 3.454205, 1.842865>, <1.574843, 3.564268, 1.646507>, 
      <1.095549, 3.747886, 1.323413>, <1.250930, 3.858730, 1.518463>, <1.516876, 4.048448, 1.527438>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>, 
      <1.058881, 2.809064, 0.967556>, <0.885910, 2.741619, 0.844621>, <0.638173, 2.677407, 0.934517>, <0.518744, 2.630839, 1.116586>, 
      <1.287745, 3.405068, 0.871225>, <1.161858, 3.315264, 1.031441>, <0.880804, 3.134771, 1.210308>, <1.007584, 3.225212, 1.369456>, 
      <1.222567, 3.838497, 0.767957>, <1.096680, 3.748693, 0.928172>, <0.968769, 3.657445, 1.164265>, <1.095549, 3.747886, 1.323413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>, 
      <1.511433, 3.014108, 1.399758>, <1.639141, 3.063904, 1.205068>, <1.243843, 2.881184, 1.099014>, <1.058881, 2.809064, 0.967556>, 
      <1.838591, 3.717745, 0.905735>, <1.703022, 3.621034, 0.735555>, <1.422358, 3.501097, 0.699904>, <1.287745, 3.405068, 0.871225>, 
      <1.695413, 4.175812, 0.559968>, <1.559844, 4.079101, 0.389788>, <1.357180, 3.934526, 0.596635>, <1.222567, 3.838497, 0.767957>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.267821, 2.479668, 1.469812>, <1.511433, 3.014108, 1.399758>, <1.838591, 3.717745, 0.905735>, <1.695413, 4.175812, 0.559968>, 
      <1.108081, 2.417382, 1.713333>, <1.351693, 2.951822, 1.643279>, <2.008162, 3.838712, 1.118599>, <1.864985, 4.296779, 0.772832>, 
      <0.787669, 2.292448, 1.745119>, <1.089922, 2.868216, 1.942679>, <1.743219, 3.684382, 1.432216>, <1.839537, 4.278626, 1.116789>, 
      <0.556317, 2.202239, 1.580690>, <0.858569, 2.778007, 1.778251>, <1.574843, 3.564268, 1.646507>, <1.671161, 4.158511, 1.331080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.420517, 1.030371, -0.115902>, <0.113731, 0.999855, -0.007496>, <0.007458, 0.989284, 0.243639>, 
      <0.656890, 1.452521, 0.160879>, <0.410125, 1.427975, 0.046953>, <0.215961, 1.404545, 0.374858>, <0.109689, 1.393974, 0.625992>, 
      <0.382882, 1.776536, 0.696127>, <0.236511, 1.719463, 0.919268>, <0.092582, 1.640028, 1.265476>, <0.304574, 1.722688, 1.416144>, 
      <0.443593, 2.158285, 0.884011>, <0.297221, 2.101212, 1.107152>, <0.344325, 2.119579, 1.430022>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>, 
      <0.420517, 1.030371, -0.115902>, <0.428264, 0.733937, -0.237318>, <0.542391, 0.317613, -0.273400>, <0.500000, 0.000000, -0.272899>, 
      <0.113731, 0.999855, -0.007496>, <0.046675, 0.734409, -0.258291>, <0.274764, 0.314693, -0.310764>, <0.272788, 0.000000, -0.507794>, 
      <0.007458, 0.989284, 0.243639>, <-0.059597, 0.723838, -0.007156>, <0.001976, 0.314693, -0.302970>, <0.000000, 0.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.806595, 1.068774, 0.367641>, <0.868625, 1.074944, 0.090980>, <0.667281, 1.054916, -0.001976>, 
      <0.873382, 1.431312, 0.674253>, <0.960093, 1.439937, 0.469344>, <0.858233, 1.472548, 0.253834>, <0.656890, 1.452521, 0.160879>, 
      <0.905311, 1.960277, 0.907859>, <0.732340, 1.892832, 0.784924>, <0.502312, 1.823104, 0.514058>, <0.382882, 1.776536, 0.696127>, 
      <0.978901, 2.367013, 0.936466>, <0.805930, 2.299568, 0.813531>, <0.563022, 2.204853, 0.701942>, <0.443593, 2.158285, 0.884011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>, 
      <0.806595, 1.068774, 0.367641>, <0.660698, 0.715990, 0.270974>, <0.414440, 0.335439, 0.357390>, <0.222577, 0.000000, 0.281520>, 
      <0.868625, 1.074944, 0.090980>, <0.876372, 0.778509, -0.030436>, <0.542391, 0.317613, 0.222167>, <0.500000, 0.000000, 0.222668>, 
      <0.667281, 1.054916, -0.001976>, <0.675029, 0.758482, -0.123392>, <0.542391, 0.317613, -0.000501>, <0.500000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.469393, 1.035233, 1.073839>, <0.627162, 1.050926, 0.791664>, <0.719884, 1.060148, 0.572550>, 
      <0.552471, 1.418471, 1.209352>, <0.767772, 1.439887, 1.308751>, <0.780660, 1.422089, 0.893366>, <0.873382, 1.431312, 0.674253>, 
      <1.039269, 1.978267, 1.535535>, <1.166978, 2.028063, 1.340846>, <1.090273, 2.032397, 1.039317>, <0.905311, 1.960277, 0.907859>, 
      <1.267821, 2.479668, 1.469812>, <1.395530, 2.529464, 1.275122>, <1.163863, 2.439133, 1.067923>, <0.978901, 2.367013, 0.936466>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.005147, 0.662242, 0.770342>, <-0.334748, 0.336073, 0.292045>, <-0.560606, 0.000000, 0.030303>, 
      <0.469393, 1.035233, 1.073839>, <0.210153, 0.683658, 0.869742>, <-0.334748, 0.336073, 0.530148>, <-0.560606, 0.000000, 0.268407>, 
      <0.627162, 1.050926, 0.791664>, <0.481265, 0.698142, 0.694997>, <-0.046144, 0.335439, 0.370549>, <-0.238007, 0.000000, 0.294679>, 
      <0.719884, 1.060148, 0.572550>, <0.573987, 0.707365, 0.475884>, <0.191863, 0.335439, 0.363749>, <0.000000, 0.000000, 0.287879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <0.552471, 1.418471, 1.209352>, <1.039269, 1.978267, 1.535535>, <1.267821, 2.479668, 1.469812>, 
      <-0.015209, 0.987030, 0.850110>, <0.283170, 1.391684, 1.085022>, <0.879530, 1.915981, 1.779056>, <1.108081, 2.417382, 1.713333>, 
      <-0.108520, 0.977748, 0.517710>, <-0.006289, 1.382438, 0.900063>, <0.535927, 1.812897, 1.580573>, <0.787669, 2.292448, 1.745119>, 
      <0.007458, 0.989284, 0.243639>, <0.109689, 1.393974, 0.625992>, <0.304574, 1.722688, 1.416144>, <0.556317, 2.202239, 1.580690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.254092, 1.013817, 0.974440>, <-0.015209, 0.987030, 0.850110>, <-0.108520, 0.977748, 0.517710>, <0.007458, 0.989284, 0.243639>, 
      <-0.005147, 0.662242, 0.770342>, <-0.274448, 0.635455, 0.646012>, <-0.175575, 0.712302, 0.266914>, <-0.059597, 0.723838, -0.007156>, 
      <-0.334748, 0.336073, 0.292045>, <-0.334748, 0.336073, -0.005778>, <-0.295726, 0.314693, -0.294464>, <0.001976, 0.314693, -0.302970>, 
      <-0.560606, 0.000000, 0.030303>, <-0.560606, 0.000000, -0.267520>, <-0.297702, 0.000000, -0.491494>, <0.000000, 0.000000, -0.500000>
    }
  }
  material {
    beanMskin
  }
  rotate 90.0*x
  translate  <-0.379391, -0.15447, -0.074957>
}
#declare segMcurvedMA = union {
  object { Blatt14 }
  object { sPatchObj3 }
  translate  <0.497773, 3.275763, 17.453742>
}
#declare BezPtch023 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt24 = union {
  cone { // Cone270
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch023 }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -156.088867>
  translate  <0.993812, -0.861687, 22.535691>
}
#declare BezPtch006 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt3 = union {
  cone { // Cone288
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch006 }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -26.08886>
  translate  <1.217384, 2.580596, 7.382659>
}
#declare BezPtch007 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt4 = union {
  cone { // Cone287
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch007 }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -76.08886>
  translate  <3.079474, 1.489987, 7.066099>
}
#declare BezPtch024 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt5 = union {
  cone { // Cone286
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch024 }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -126.08886>
  translate  <1.768829, -2.189298, 7.976066>
}
#declare BezPtch009 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt6 = union {
  cone { // Cone285
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch009 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -176.088867>
  translate  <-0.197359, -2.932279, 8.976066>
}
#declare BezPtch010 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt7 = union {
  cone { // Cone284
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch010 }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 133.911133>
  translate  <-2.236344, -1.885672, 10.066099>
}
#declare BezPtch011 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt9 = union {
  cone { // Cone283
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch011 }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 83.911133>
  translate  <-2.599037, 0.349593, 11.013906>
}
#declare Blatt10 = union {
  cone { // Cone282
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 33.911133>
  translate  <-1.464652, 2.49106, 12.066099>
}
#declare BezPtch013 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt11 = union {
  cone { // Cone281
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch013 }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -16.088867>
  translate  <0.46593, 2.840988, 12.682482>
}
#declare BezPtch014 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt12 = union {
  cone { // Cone280
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch014 }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -66.088867>
  translate  <0.826869, 1.484884, 13.313219>
}
#declare BezPtch015 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt13 = union {
  cone { // Cone279
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch015 }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -116.088867>
  translate  <0.803163, 0.104653, 15.085019>
}
#declare BezPtch016 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt15 = union {
  cone { // Cone278
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch016 }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -166.088867>
  translate  <-1.25059, -0.627963, 15.810355>
}
#declare BezPtch017 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt16 = union {
  cone { // Cone276
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch017 }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 143.911133>
  translate  <-1.638474, 0.796201, 16.900387>
}
#declare BezPtch018 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt17 = union {
  cone { // Cone275
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch018 }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 93.911133>
  translate  <-1.453078, 2.520999, 17.753595>
}
#declare BezPtch019 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt18 = union {
  cone { // Cone274
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch019 }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 43.911133>
  translate  <-0.150726, 4.593256, 19.013906>
}
#declare BezPtch020 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt19 = union {
  cone { // Cone273
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch020 }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -6.088867>
  translate  <2.160218, 5.008142, 20.212891>
}
#declare BezPtch021 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt20 = union {
  cone { // Cone272
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch021 }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -56.088867>
  translate  <3.719084, 3.196557, 21.103938>
}
#declare BezPtch022 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt25 = union {
  cone { // Cone271
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch022 }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, -106.088867>
  translate  <2.937084, 0.976958, 21.682482>
}
#declare BezPtch004 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt2 = union {
  cone { // Cone289
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch004 }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 23.91114>
  translate  <-1.055187, 2.942439, 6.472691>
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.813772, -3.125196, 0.000000>, <-1.655968, -3.534811, 0.000000>, <-0.285616, -3.532193, 0.000000>, <0.812207, -3.250391, 0.000000>, 
      <-4.837634, -1.812207, 0.000000>, <-1.688576, -1.874804, 0.000000>, <-0.250391, -1.937402, 0.000000>, <2.924782, -2.062598, 0.000000>, 
      <-5.014692, -1.026175, 1.644816>, <-1.624324, -0.911286, 0.789657>, <-0.282560, -1.000000, 0.101928>, <3.117348, -1.241341, -1.560632>, 
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.600343, -0.343091, -0.215864>, <-1.654867, 0.000000, 0.220361>, <-0.263685, 0.000000, 0.205097>, <2.757298, -0.400454, 0.212239>, 
      <-4.185995, 0.339994, -2.076544>, <-1.685410, 0.911286, -0.348935>, <-0.244810, 1.000000, 0.308265>, <2.397247, 0.440434, 1.985110>, 
      <-2.725217, 2.094006, 0.302549>, <-1.387210, 2.284360, 0.302549>, <-0.273741, 2.195646, 0.302549>, <0.991476, 2.112051, 0.302549>, 
      <-1.906209, 3.660006, 0.219453>, <-1.169802, 6.564004, -0.622553>, <-0.572088, 6.496770, -0.622553>, <0.152126, 3.661964, -0.306632>
    }
  }
  material {
    leafMskinMmap
  }
}
#declare Blatt1 = union {
  cone { // Cone290
    <0,0,0>, 0.2, <0,0,1>, 1.0
    material {
      beanMskin
    }
    scale <0.2, 0.2, 3.0>
    rotate 93.54702*x
    translate  <-1.159671, -0.871892, 0.200048>
  }
  object { BezPtch002 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      beanMskin
    }
    scale <0.2, 0.2, 2.0>
    rotate <23.161333, -255.902481, 299.725311>
    translate  <-1.161135, -3.826861, -0.017125>
  }
  scale 0.5
  rotate <-10.285381, -2.384943, 73.91114>
  translate  <-2.979812, 0.957002, 7.020857>
}
union { // beanMstalk
  object { segMstraightMA }
  object { segMshiftMA }
  object { segMcurvedMA }
  object { Blatt24 }
  object { Blatt3 }
  object { Blatt4 }
  object { Blatt5 }
  object { Blatt6 }
  object { Blatt7 }
  object { Blatt9 }
  object { Blatt10 }
  object { Blatt11 }
  object { Blatt12 }
  object { Blatt13 }
  object { Blatt15 }
  object { Blatt16 }
  object { Blatt17 }
  object { Blatt18 }
  object { Blatt19 }
  object { Blatt20 }
  object { Blatt25 }
  object { Blatt2 }
  object { Blatt1 }
  scale 3.0
  rotate 60.500481*z
  translate  <36.112787, -24.851625, -15.187311>
}


