
#declare MarkerLights = //positions of the accent lights
union{
object{Marklight translate <38,4.25+70,38>}
object{Marklight translate <38,4.25+70,-38>}
object{Marklight translate <-38,4.25+70,38>}
object{Marklight translate <-38,4.25+70,-38>} 

object{Marklight translate <-137.5,13.5,49>   }
object{Marklight translate <-121,13.5,65.5> }
object{Marklight translate <-104.5,13.5,49>   }
object{Marklight translate <-121,13.5,33> }

object{Marklight translate <-141.5,-5,49> }
object{Marklight translate <-121  ,-5,69>   }
object{Marklight translate <-100,-5,49> }
object{Marklight translate <-121  ,-5,29>   } 

object{Marklight translate <-25,0,-52.5>}
object{Marklight translate <25,0,-52.5> }   

union {
object{Marklight translate <59.5,20.25,0>}  
object{Marklight translate <-59.5,20.25,0>}
object{Marklight translate <0,20.25,59.5>}
object{Marklight translate <0,20.5,-59.5>} 
object{Marklight translate <0,67.25,0>} 
 
rotate <-40,-20,0>
translate <-122,57,49>
translate -18*y
}
}
//Large tanks of bio-nuclear material (Num is the number on the tank)
#macro Biotube(Num)
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Sphere
      // Name: NoName
      object
      {
         sphere { < 0, 0, 0 >, 1 }

         scale < 3.5, 2, 3.5 >
         translate < 0, 9, 0 >
      }
      // Object type: Cone
      // Name: NoName
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.75}
         scale < 6, 2, 6 > 
         texture {ConcreteTex scale .3}
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 3.5, 7, 3.5 >
         translate < 0, 2, 0 >
      }
      
      union {
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 0.25 }

         translate < 0, 3, 0 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 0.25 }

         translate < 0, 5, 0 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 4, 0.25 }

         translate < 0, 7, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < 0, 2, 4 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < 0, 2, -4 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < -4, 2, 0 >
      }
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 5, 0.25 >
         translate < 4, 2, 0 >
      }
      texture {pigment {rgb .5}}
      texture {Scarring}
      }
union {Marklight2 scale .75 translate <4.25,7.25,0> }
union {Marklight2 scale .75 translate <-4.25,7.25,0>}
}
texture {
pigment {rgb 1}
finish {ambient ALight+ .25 diffuse DiffTotal*.9 phong .5}}
texture {
pigment {
image_map {
png concat("0",str(Num,0,0)) 

once
}
}
scale<6,6,6>
translate<-3,1.5,0> 
scale 1.5 
rotate 45*y
finish {ambient ALight+ .25 diffuse DiffTotal*.9}
}
texture {Scarring translate Num*300}
}
#end

//Human guard hut
#declare GuardHut =
// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Sphere
                  // Name: NoName
                  object
                  {
                     sphere { < 0, 0, 0 >, 1 }

                     scale < 7.5, 7.5, 7.5 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 2.375, 7.5, 4.5 >
                     rotate < 90, 0, 0 >
                     translate < 0, -5.2881e-23, -8.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 8.25, 0.375, 8.25 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 7.5, 0.375, 7.5 >
                     rotate < -180, 0, 0 >
                     translate < 0, 6.2813, 0 >
                  }
               }
            }
            // Object type: Paraboloid
            // Name: NoName
            object
            {
               object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

               scale < 3.75, 1.875, 3.75 >
               rotate < 180, 0, 0 >
               translate < 0, 8.1563, -1.5882e-22 >
               texture { 
               pigment {rgbt <.5,.55,.6,.5>}
               finish {ambient ALight+ .25 diffuse DiffTotal*.75 phong 1}
               }
               texture {Snow scale .75}
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Union
                  // Name: 'or'
                  object
                  {
                     merge
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 6.875, 0.25, 6.875 >
                           translate < 0, 2.875, 0 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 4.625, 0.25, 4.625 >
                           translate < 0, 5.875, 0 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 0, 0, 90 >
                           translate < 0.125, 0, 0 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 90, 45, 0 >
                           translate < -0.088388, 0, -0.088388 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 90, 0, 0 >
                           translate < 0, 0, -0.125 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 7.75, 0.25, 7.625 >
                           rotate < 90, -45, 0 >
                           translate < 0.088388, 0, -0.088388 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                           scale < 2.5, 7.625, 4.625 >
                           rotate < 90, 0, 0 >
                           translate < 0, -1.1444e-21, -7.625 >
                        }
                     }
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 16.5, 6.375, 17.875 >
                     translate < -8.25, 0, -9 >
                  }
               }
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 2.25, 7.625, 4.375 >
               rotate < 90, 0, 0 >
               translate < 0, -1.5637e-16, -8.125 >
            }
         }
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 3, 0.125 }
         translate < 0, 7, 0 >
         pigment {rgb .5}
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 2, 0.125 }
         translate < 0, 7.625, 0 > 
         pigment {rgb .5}
      }
      // Object type: Disc
      // Name: NoName
      object
      {
         disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

         scale < 2.375, 1, 4.375 >
         rotate < 90, 0, 0 >
         translate < 0, 2.0435e-22, -6.125 >
         pigment {rgb .25}
      }
sphere_sweep{
linear_sphere_sweep,
4,
<0,0,0>        ,.2
<0,5.375,0>    ,.2
<1.375,5.375,0>,.2
<1.375,5.875,0>,.2
translate <.25,0,0>   
translate <-3.5,0,-5.5>
pigment {rgb .5}
} 
sphere_sweep{
linear_sphere_sweep,
4,
<0,0,0>        ,.2
<0,5.375,0>    ,.2
<1.375,5.375,0>,.2
<1.375,5.875,0>,.2
translate <.25,0,0> 
scale <-1,1,1>  
translate <-3.5,0,-5.5>
pigment {rgb .5}
}
union {
sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <.75,.75,1>*1.5
absorption 1
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .5]
[1 rgb 10]
}       
}        
}
}
scale 1
}
scale 2 rotate 151*x translate <1.375,5.875,0> translate <-3.25,0,-6>
}
union {
sphere {0,1
pigment {Clear}
hollow
no_shadow
interior {
media {
emission <.75,.75,1>*1.5
absorption 1
sample_method 2
density {
spherical
color_map {
[0 rgb 0]  
[.75 rgb .5]
[1 rgb 10]
}       
}        
}
}
scale 1
}
scale 2 rotate 151*x translate <1.375,5.875,0> translate .25*x scale <-1,1,1> translate <-3.5,0,-6> 
}  
}
texture {pigment {rgb 1.5}
finish {ambient ALight diffuse DiffTotal}}
texture {Scarring scale .75}
texture {Snow scale .75}
}
//Radar transmitter, with snow nestled in the lip
#declare Radar = 
union {

      // Object type: Composite
      // Name: group #1
      object
      {
         union
         {
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Paraboloid
                  // Name: NoName
                  object
                  {
                     object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                     scale < 60, 20, 60 >
                     rotate < -40, -20, 0 >
                     translate < -122, 57, 49 >
                  }
                  // Object type: Paraboloid
                  // Name: NoName
                  object
                  {
                     object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                     scale < 60, 20, 60 >
                     rotate < -40, -20, 0 >
                     translate < -121.56, 58.532, 47.792 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                           scale < 50, 20, 50 >
                           rotate < -40, -20, 0 >
                           translate < -122, 57, 49 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 10, 20, 110 >
                           rotate < -40, -20, 0 >
                           translate < -112.55, 22.289, 8.4182 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 110, 20, 10 >
                           rotate < -40, -20, 0 >
                           translate < -172.37, 53.786, 26.59 >
                        }
                        // Object type: Cylinder
                        // Name: NoName
                        object
                        {
                           cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

                           scale < 15, 30, 15 >
                           rotate < -40, -20, 0 >
                           translate < -124.2, 49.34, 55.04 >
                        }
                     }
                  }
               }
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .45]
[1 rgb .675]
}
scale 5
} 
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}

         texture {Scarring} 
         texture {DishSnowTex} 
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -42.633, 26.897, -38.623 >
                     translate < -164.7, 38.23, 9.6552 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -42.633, 26.897, -38.623 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -42.633, 26.897, -38.623 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -37.247, 3.6536, -18.787 >
                     translate < -138.24, 23.525, 0.63626 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -37.247, 3.6536, -18.787 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -37.247, 3.6536, -18.787 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -83.978, -52.6, 66.422 >
                     translate < -64.732, 36.56, 43.921 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -83.978, -52.6, 66.422 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -83.978, -52.6, 66.422 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Intersection
            // Name: 'and'
            object
            {
               intersection
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 3, 20, 125 >
                     rotate < -53.168, -41.005, 25.206 >
                     translate < -80.523, 22.561, 20.42 >
                  }
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -53.168, -41.005, 25.206 >
                           translate < -121.89, 57.383, 48.698 >
                        }
                        // Object type: Paraboloid
                        // Name: NoName
                        object
                        {
                           object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

                           scale < 45, 20, 60 >
                           rotate < -53.168, -41.005, 25.206 >
                           translate < -121.67, 58.149, 48.094 >
                        }
                     }
                  }
               }
            }
            // Object type: Paraboloid
            // Name: NoName
            object
            {
               object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

               scale < 59, 19, 59 >
               rotate < -40, -20, 0 >
               translate < -121.78, 57.766, 48.396 >
                texture {
                pigment {leopard color_map {[.2 rgb .3 transmit 0][.35 rgb .35 transmit 1]} scale .3}
                finish {phong 1 metallic ambient ALight+ .25 diffuse DiffTotal*1}
                scale <1,100,1>
                rotate < -40, -20, 0 >
                translate < -121.78, 57.766, 48.396 >
                }
                texture {
                pigment {onion color_map {[.4 rgb .3 transmit 0][.4 rgb .3 transmit 1]} scale 10}
                finish {phong 1 metallic ambient ALight+ .25 diffuse DiffTotal*1}
                scale <1,100,1>
                rotate < -40, -20, 0 >
                translate < -121.78, 57.766, 48.396 >
                }
                texture {DishSnowTex} 
            }
         }
         texture {
         pigment {rgb .35}
         finish {phong 1 metallic ambient ALight+ .25 diffuse DiffTotal*1} 
         }
         texture {Scarring}
         texture {DishSnowTex} 
      }

blob {
threshold .1
#macro SnowComp1(Rand,Rot)
#declare C=0
#while (C<10)
sphere {0,2,.125
scale <20*rand(seed(C*C+Rand))+5,2.5*rand(seed(C*C/3/7*C+Rand))+1.5,20*rand(seed(C*C*C+Rand))+5>*<1,1,1> 
rotate 30*(1-(C/10))*x
translate <0,-4*C,C*C>
translate <0,40,-100> 
rotate Rot*y  
scale <1,3,1>
}
#declare C=C+1//.75*rand(seed(C*Rand))+.25
#end 
#end
#declare Count=0
#while (Count<20)
SnowComp1(Count*Count+54676,-160*(Count/20)+80)
#declare Count=Count+1
#end 
pigment {rgb 2}
scale <1,1/2,1>
translate 45*y
scale 1/115
scale<60,20,60>
rotate<-40,-20,0>
translate<-122,57,49>
texture {
pigment {rgb 1.5}
normal {crackle metric 4 bump_size 1 scale 7.5}
finish {ambient ALight+ .125 diffuse DiffTotal*1 }
}
}
union {
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 10, 4, 10 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 3, 15, 3 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 2, 35, 2 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}

object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < 1, 65, 1 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < .5, 66, .5 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale < .25, 67, .25 >
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
}     
union {
      #declare C=0
      #while(C<360)
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 0.125 }

               scale < -2.9876, -2.9924, -3.1701 >
               rotate < -179, 0, 90 >
               translate < 0, 91.5, 0>
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 80, 1, 80 >
               rotate < 180, 1, 0 >
               translate <0, 20, 0 >
            }
            pigment {rgb .5}
         }
         rotate C*y
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 0.125 }

               scale < -2.9876, -2.9924, -3.1701 >
               rotate < 179, 0, 90 >
               translate < 0, 91.5, 0>
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 80, 1, 80 >
               rotate < 180, -1, 0 >
               translate < 0, 20, 0 >
            }
            pigment {rgb .5}
         } 
         rotate C*y
      }
      #declare C=C+30
      #end
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 59, 1.5 }

         scale < 0.992, 0.33333, 0.992 >
         translate < 0, 20, 0 >
      }
      #declare C=0
      #while (C<360)
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.25, 7.3715, 0.25 >
         rotate < 58.578, 0, 0 >
         translate < 0, 16.5, 51 > 
         rotate C*y
         
      }            
      #declare C=C+7.5
      #end
rotate < -40, -20, 0 >
translate < -122, 57, 49 >
      }



texture {
pigment {rgb .75}
finish {phong 1 metallic ambient ALight+ .25 diffuse DiffTotal*1}
}
texture {Scarring} 
texture {DishSnowTex}      
}


object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<10,10,10>
translate<-121,32,49>
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<9,2,9>
translate<-121,42,49>
}
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<8,5,8>
translate<-121,44,49>
}      
object {
cylinder{<0,0,0>,<0,1,0>,1}
scale<20,25,20>
translate<-121,0,49>
}
object {
cone{<0,0,0>,1,<0,1,0>,0.8}
scale<20,7,20>
translate<-121,25,49>
}
texture {BaseTex} 
translate -18*y
}
//passage connecting the radar tower with the main complex
#declare Rand = 234
#declare OverheadPassage = 
union {
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<43,6,18>
translate<-83,26,-9>
texture {SnowTex}
}
union {
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<-115,0,0>
translate<-51,26,8>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<115,0,0>
translate<-51,26,-8>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<-90,67.609,180>
translate<-83,1.0323e-21,-8>
}

texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb 1]
}
scale 1
scale <10,.5,10> 
translate -Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 diffuse DiffTotal*1 reflection_min 0 reflection_max .5}
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb <.4,.5,.6> transmit 1]
}
turbulence .5
scale 4 
translate Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 diffuse DiffTotal*1 }
}
texture {
pigment { bozo
color_map { 
[.2 rgb <.4,.5,.6>*.5]
[.4 rgb <.4,.5,.6>*.5 transmit 1]
}
turbulence .5
scale 12 
translate Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 phong 1 diffuse DiffTotal*1 }
}
#if ((rand(seed(Rand))*1)>.25)
texture {Blood translate Rand}
#end
#if ((rand(seed(Rand))*1)>.75)
texture {Blood translate Rand scale 2}
#end
texture {Blood translate -Rand scale 4}
texture {
pigment { gradient y triangle_wave
color_map {
[.5 rgb .75 transmit 1]
[.6 rgb .75           ]
}
}
finish {ambient ALight+ .25 diffuse DiffTotal*1}
scale 5
translate 4*y
}

}
}
}
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>} 
scale<63,6,18>
rotate<0,45,0>
translate<-128.28,26,35.556>
texture {SnowTex}
}
union {
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<-115,45,0>
translate<-93.636,26,24.95>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<110,1,20>
rotate<115,45,0>
translate<-104.95,26,13.636>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<90,-67.5,0>
translate<-83,0,-8>
}

texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb 1]
}
scale 1
scale <10,.5,10> 
translate -Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 diffuse DiffTotal*1 reflection_min 0 reflection_max .5}
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb <.4,.5,.6> transmit 1]
}
turbulence .5
scale 4 
translate Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 diffuse DiffTotal*1 }
}
texture {
pigment { bozo
color_map { 
[.2 rgb <.4,.5,.6>*.5]
[.4 rgb <.4,.5,.6>*.5 transmit 1]
}
turbulence .5
scale 12 
translate Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 phong 1 diffuse DiffTotal*1 }
}
#if ((rand(seed(Rand))*1)>.25)
texture {Blood translate Rand}
#end
#if ((rand(seed(Rand))*1)>.75)
texture {Blood translate Rand scale 2}
#end
texture {Blood translate -Rand scale 4}
texture {
pigment { gradient y triangle_wave
color_map {
[.5 rgb .75 transmit 1]
[.6 rgb .75           ]
}
}
finish {ambient ALight+ .25 diffuse DiffTotal*1}
scale 5
translate 4*y
}


}
}
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<5,8,10>
translate<-76,18,-5>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}
scale<5,8,10>
rotate<0,45,0>
translate<-101,18,14>
}
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 43, 2, 16 >
         translate < -83, 24, -8 >
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 62.933, 2, 16 >
         rotate < 0, 45, 0 >
         translate < -127.5, 24, 36 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 12.5, 5, 7 >
         translate < -74.5, 29.5, -3.5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 7, 5, 7 >
         translate < -90.5, 29.5, 3.5 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2a

         scale < 7, 5, 7 >
         translate < -103.5, 29.5, 16.5 >
      }
      
#declare C=0;
#while (C < 32)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.7057,0.5>
rotate<25,0,0>
translate<-48-C,26,-8>
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.706,0.5>
rotate<-25,0,0>
translate<-48-C,26,8> 
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
#declare C=C+8
#end

#declare C=0;
#while (C < 64)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.7057,0.5>
rotate<25,0,0>
translate<-C,26,-9>
rotate 45*y
translate -79.1*x

texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.66,6.706,0.5>
rotate<-25,0,0>
translate<-C,26,9>
rotate 45*y
translate -79.1*x 
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
#declare C=C+8
#end

texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 5
rotate 90*x
} 
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
translate -18*y         
}




//empty garage with a hole in one of the doors
#declare Garage = 
//Objecttype:Difference
//Name:'andnot'
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}
scale<72,18,64>
translate<-123,0,-30>
}
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}
scale<121,1.613,40.921>
rotate<-100,0,0>
translate<-67,0,28>
texture {BaseTex}
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}
scale<55.168,1.196,115.5>
rotate<0,0,-99.703>
translate<-122,1.4211e-14,0>
texture {BaseTex}
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}
scale<121,1.613,40.921>
rotate<117.31,0,0>
translate<-67,-2.0872e-14,-25>
texture {BaseTex}
}

//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<92,17,39>
translate<-104,-1,-15>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<26,17,53>
translate<-86,-1,-28>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}
scale<26,17,53>
translate<-118,-1,-28>
}
}
}
object {
box{<0,0,0>,<1,1,1>}
scale<28,14,0.88379>
rotate<27.897,0,0>
translate<-87,4,-22>
texture {
pigment {
image_map {
png "door.png"
interpolate 2
}
} 
finish {ambient ALight+ .75 diffuse DiffTotal*2 } 
scale <28,14,1> 
rotate <27.897,0,0>
translate<-87,4,-22>     
}
}
object {
box{<0,0,0>,<1,1,1>}
scale<28,14,0.88379>
rotate<27.897,0,0>
translate<-119,4,-22>
texture {
pigment {
image_map {
png "ibrokeit2.png"  
interpolate 2
}
} 
finish {ambient ALight+ .75 diffuse DiffTotal*2 } 
scale <28,14,1> 
rotate <27.897,0,0>
translate<-119,4,-22>     
}
}
texture {BaseTex}
translate -18*y
}



//one floor of the main complex
#macro OfficeFloor(Rand,FloorNum,SNOW)
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object {
box{<0,0,0>,<1,1,1>}
scale<100,6,100>
translate<-50,0,-50>
}
union {
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,115>
translate<50,3.9593e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<-115,0,0>
translate<1.9722e-31,0,50>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,-115>
translate<-50,3.986e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<115,0,0>
translate<0,0,-50>
}

texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb 1]
}
scale 1
scale <10,.5,10> 
translate -Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 diffuse DiffTotal*1  reflection_min 0 reflection_max .5}
}
texture {
pigment { bozo
color_map {
[0 rgb <.4,.5,.6>]
[1 rgb <.4,.5,.6> transmit 1]
}
turbulence .5
scale 4 
translate Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 diffuse DiffTotal*1 }
}
texture {
pigment { bozo
color_map { 
[.2 rgb <.4,.5,.6>*.5]
[.4 rgb <.4,.5,.6>*.5 transmit 1]
}
turbulence .5
scale 12 
translate Rand
}
finish {ambient ALight+ 1*rand(seed(Rand))+.25 phong 1 diffuse DiffTotal*1 }
}
#if ((rand(seed(Rand))*1)>.25)
texture {Blood translate Rand}
#end
#if ((rand(seed(Rand))*1)>.75)
texture {Blood translate Rand scale 2}
#end
texture {Blood translate -Rand scale 4}
texture {
pigment { gradient y triangle_wave
color_map {
[.5 rgb .75 transmit 1]
[.6 rgb .75           ]
}
}
finish {ambient ALight+ .25 diffuse DiffTotal*1}
scale 5
translate 3*y
}

}
}
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient ALight+.5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring} 
#if (SNOW=1)
texture {
pigment {
bozo
color_map {
[.4 rgbt 1]
[.6 rgb 1]
}
scale 5
turbulence .5
}
normal {crackle metric 4 bump_size 2 scale 20} 
finish {ambient ALight+ .125 diffuse DiffTotal*1}
}
#end  
}
#declare C=0;
#while (C < 90)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C>
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C>
rotate 90*y
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C> 
rotate -90*y
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.5,7.5,0.75>
rotate<0,0,-25>
translate<-50,0,-45+C> 
rotate 180*y
texture {
pigment {rgb .5}
finish {ambient ALight+ .25 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}           
#declare C=C+8
#end 

object {
box{<0,0,0>,<1,1,1>}
scale<100,1,100>
translate<-50,-1,-50>
}
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
translate 7*FloorNum*y 
}
#end

//one of the top two floors - top one has snow on it
#macro OfficeTopper(FloorNum,SNOW)
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object {
box{<0,0,0>,<1,1,1>}
scale<100,6,100>
translate<-50,0,-50>
}
union {
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,115>
translate<50,3.9593e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<-115,0,0>
translate<1.9722e-31,0,50>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,-115>
translate<-50,3.986e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<115,0,0>
translate<0,0,-50>
}
}
}   
}
#declare C=0;
#while (C < 90)
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
rotate 90*y
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
rotate -90*y
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}
cylinder{<0,0,0>,<0,1,0>,1
scale<0.75,21,0.5>
rotate<0,0,-25>
translate<-56,-13,-45+C>
rotate 180*y
texture {
pigment {rgb .5}
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
}           
#declare C=C+8
#end

object {
box{<0,0,0>,<1,1,1>}
scale<100,1,100>
translate<-50,-1,-50>
}
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 10
} 
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring}
#if (SNOW=1)
texture {
pigment {
bozo
color_map {
[.4 rgbt 1]
[.6 rgb 1]
}
scale 5
turbulence .5
}
normal {crackle metric 4 bump_size 2 scale 20} 
finish {ambient ALight+ .125 diffuse DiffTotal*1}
}
#end

scale .8
translate 7*FloorNum*y 
}
#end

//Concrete Base
#macro OfficeBase()
union {
object {
difference {
//Objecttype:Box
//Name:NoName
object {
box{<0,0,0>,<1,1,1>}
scale<100,6,100>
translate<-50,0,-50>
}
union {
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,115>
translate<50,3.9593e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<-115,0,0>
translate<1.9722e-31,0,50>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<20,1,105>
rotate<0,0,-115>
translate<-50,3.986e-15,0>
}
object {
disc{<0,0,0>,<0,1,0>,1,0}
scale<110,1,20>
rotate<115,0,0>
translate<0,0,-50>
}
}
}   
}
texture {
pigment {
crackle metric 1
color_map {
[0 rgb .35]
[1 rgb .5]
}
scale 5
rotate 90*x
} 
finish {ambient ALight+ .5 diffuse DiffTotal*1 phong .25}
}
texture {Scarring} 
texture {
pigment {
bozo
color_map {
[.5 rgbt 1]
[1 rgb 1]
}
scale 2
turbulence 1
} 
finish {ambient ALight+ .25 diffuse DiffTotal*1}
}
scale <1.1,3,1.1>
translate -18*y
}
#end

//Put it all together
#declare OfficeComplex = 
union {
OfficeBase()
OfficeFloor(123,0,0)
OfficeFloor(234,1,0)
OfficeFloor(345,2,0)
OfficeFloor(455,3,0)
OfficeFloor(675,4,0)
OfficeFloor(787,5,0)
OfficeFloor(678,6,0)
OfficeFloor(879,7,0)
OfficeFloor(459,8,1)
difference {
OfficeTopper(9,0)
plane {y,0 translate 48*y}
}
OfficeTopper(10,1)  
light_source {
<-52.358,0,-52.669>
color rgb 2
spotlight
point_at < -68.959, -21.425, -65.529 >
radius 28
falloff 50
tightness 10
}
object {Light rotate <180,-64.5,-127.5> translate <-52.5,0,-52.5> rotate 0*y}
light_source {
<-119.17,0,-15.138>
color rgb 2
spotlight
point_at < -127, -21.425, -630 >
radius 28
falloff 50
tightness 10
}
object {Light rotate <180,-64.5,-127.5> translate <-119.17,0,-15.138> rotate 0*y}
//garage lights
light_source
{
< -73, -3, 0 >
color rgb .25
area_light 5,1,3,3
adaptive 0
fade_distance 75
fade_power 2
}
light_source
{
< -104, -3, 0 >
color rgb .5
area_light 5,1,3,3
adaptive 0
fade_distance 75
fade_power 2
}
union {Garage}
union {OverheadPassage translate <0,-1,-.75>}
union {Radar}
union {MarkerLights}
translate 18*y
translate <80,0,0>
} 
#declare Biotubes =
union {
#declare C=0
#while (C<5)
object {Biotube(1+C) translate C*12*x translate -5*3*x translate 8*z}
#declare C=C+1
#end
#declare C=0
#while (C<5)
object {Biotube(1+C) translate C*12*x translate -5*3*x translate -8*z}
#declare C=C+1
#end   
rotate -30*y
translate <-100,1.5,-30>
}



