#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "metals.inc"

// atmosphere
/*
media {
  intervals 6
  scattering { 1, rgb 0.022}
  samples 1, 8         
  confidence 0.995
  variance 1/384
  ratio 0.9
}
*/


///*                          
  camera {  
    location <10, 15, 15>
    look_at <0, 4, -19>
    angle 50             
  }    
    
//*/

  light_source { <35,35,-35> rgb<0.95,0.95,0.7>*3
                 area_light <3, 0, 0>, <0, 2, 0>, 4, 4
                 adaptive 1
                 jitter
                 
}
  light_source { <11,50,35> 
                Gray15
                media_attenuation off
                media_interaction off}  

  fog { fog_type 1 distance 120 rgbt <.3,.3,.3,.7> turbulence 5 omega 4}
  box { <30,30,-35.5>,<40,40,-36.5> pigment {rgbt <1,1,0.9,0.8>}}
#declare F_Shine1=finish {
                    ambient 0.25
                    phong 0.3
                    reflection 0.1
                    }
                    
#declare F_Shine2=finish { 
                    ambient 0.315
                    phong 0.1
                    reflection 0.2
                   }

#declare F_Shine3=finish { 
                    ambient 0.375
                    phong 0.2
                    reflection rgb <0.55, 0.30, 0.15> * 0.33
                   }
                   
#declare F_Basic=finish { ambient 0.2}

#declare Plank=union {
                difference {
                    box {<-20,-0.5,-1>, <20,0,1>}
                    box {<-20,0.001,-1.01>, <20,-0.025,-0.98>}
                    box {<-20,0.001,1.01>, <20,-0.025,0.98>}
                    }                          
                    cylinder {<-20,-0.025,-0.98>,<20,-0.025,-0.98>,0.02}
                    cylinder {<-20,-0.025,0.98>,<20,-0.025,0.98>,0.02}
                }           
             
/*#declare T_OldWood=
    texture {  pigment{ Pigment1 color_map { M_Wood7A } rotate y*90}} 
    texture {  pigment{ P_WoodGrain2B color_map { OldWoodOver } rotate y*90}} */

#declare P_WoodGrainA =
pigment {
    wood
    turbulence 0.075
    octaves 3
    scale <0.25, .35, 1>
    rotate y*90
}

#declare P_WoodGrainB =
pigment {
    wood
    turbulence <0.08, 0.05, 1>
    octaves 4
    scale <0.33, 0.43, 1> * 0.68
    rotate y*90
}       

#declare M_WoodA = 
color_map { 
    [0.0, 0.1 color rgb <0.45, 0.30, 0.15>
              color rgb <0.5, 0.30, 0.15>]
    [0.1, 0.9 color rgb <0.55, 0.30, 0.15>
              color rgb <0.30, 0.2, 0.1>]
    [0.9, 1.0 color rgb <0.25, 0.15, 0.05>
              color rgb <0.45, 0.30, 0.15>]
}
#declare M_WoodB = 
color_map { 
    [0.0 color rgbf <0.60, 0.35, 0.20, 0.30>]
    [0.4 color rgbf <0.60, 0.35, 0.20, 0.80>]
    [1.0 color rgbf <1.00, 1.00, 1.00, 1.00> ] 
}
 
#declare T_Wood   =
    texture { pigment { P_WoodGrainA  color_map { M_WoodA }}} 
    texture { pigment { P_WoodGrainB  color_map { M_WoodB }}}

#declare Sd1=seed(99);

// Build Wall

#declare WallPlank=difference {
                    box {<-9,-0.2,-1.5>, <9,0,1.5>}
                    box {<-9.2,-0.35,-0.35>, <9.2,0.35,0.35> rotate x*45 translate <0,0.33,-1.5>}
                    box {<-9.2,-0.35,-0.35>, <9.2,0.35,0.35> rotate x*45 translate <0,0.33,1.5>}
//                    box {<-9,-0.2,1.7>, <9,0.2,1.3> rotate x*45}
//                    box {<-9,0.001,-1.01>, <9,-0.025,-0.98>}
//                    box {<-9,0.001,1.01>, <9,-0.025,0.98>}
                    }                          

#declare W1=-60; 
#declare Wall=union {
#while (W1<=60)
    #object {WallPlank texture {T_Wood32 translate <rand(Sd1)*.5-.25,rand(Sd1)*.6+.3,0> rotate y*90 scale 3} finish {F_Shine2} rotate <90,0,90> translate <W1,5.5,-20>}
    #declare W1=W1+3;
#end      
}  
// molding                                                    

#declare Mold1=rand(Sd1)*.5-.25;
#declare Mold2=rand(Sd1)*.6-.3;
#declare Molding=difference {
    box { <-60,0,0>, <60,0.5,0.3> texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2} translate <0,0,-20>}
    cylinder {<-60.05,0.22,0.3>, <60.05,0.22,0.3>, 0.2 scale <1,2,1> texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2} translate <0,0,-20>}
    }


// Bounder Board

#declare Mold1=rand(Sd1)*.5-.25;
#declare Mold2=rand(Sd1)*.6-.3;

#declare Bounder=object {
union { 
        box {<-60,0,0>,<60,0.9,0.25> texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2}}
//        box { <-45,-0.25,-0.25>, <60,0.25,0.25> rotate x*45 texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5}}
        box { <-60,-0.25,-0.25>, <60,0.25,0.25> rotate x*45 translate <0,0.86,0> texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2}}
        cylinder {<-60,0.15,0.25>, <60,0.15,0.25>, 0.15 texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2}}
        cylinder {<-60,0.45,0.25>, <60,0.45,0.25>, 0.15 texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2}}
        cylinder {<-60,0.75,0.25>, <60,0.75,0.25>, 0.15 texture {T_Wood32 translate <Mold1,Mold2,0> rotate y*90 scale 1.5} finish {F_Shine2}}
      }                 
      translate <0,14.3,-19.99>
      }
      
// upper wall
#declare UpperWall=box { <-60,14.4,-20>,<60,90,-20.1> 
        texture { 
            pigment {
                bozo 
                color_map { 
                    [0.0 rgb <0.96, 0.95, 0.83>]
                    [0.55 rgb <0.95, 0.96, 0.85> ]
                    [0.72 rgb <0.92, 0.92, 0.81> ]
                    [0.88 rgb <0.94, 0.92, 0.83> ]
                    [1    rgb <0.96, 0.98, 0.84> ]
                    }
                 turbulence 0.35 scale 0.35
                 } normal {bumps scale 0.05 turbulence 0.3} /* normal { wrinkles scale 0.23}*/ }
                 finish {F_Basic}
            }


difference {
    union {
        #object {UpperWall}
        #object {Bounder}
        #object {Molding}
        #object {Wall}
        }
    box {<-6.975,-0.2,-19.5>, <6.975,25.975,-22> texture {pigment {Clear}} }
}           
object {
    union {
        object {UpperWall}
        object {Bounder}
        object {Molding}
        object {Wall}
        }
    translate <0,0,-165>
    }
    
// door frame

#object {
    union {
        box {<-7,0,-20>, <-6.6,26,-19.75> }
        cylinder { <-7,0,-20>, <-7,26,-20>, 0.4 }
        }
        texture {T_Wood32 translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate x*90 scale 1.5} 
        finish {F_Shine2}
        }
#object {
    union {
        box {<7,0,-20>, <7.4,26,-19.75> }
        cylinder { <7,0,-20>, <7,26,-20>, 0.4 }
        } 
        texture {T_Wood32 translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate x*90 scale 1.5} 
        finish {F_Shine2}
        }
#object {
    union { 
        box { <-7.35,26,-20>, <7.3,25.6,-19.74> }
            cylinder { <-7.35,25.6,-20>, <7.3,25.6,-20>, 0.4}
          }
    texture {T_Wood32 translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate y*90 scale 1.5} finish {F_Shine2}}
 
box { <-7,0,-19.9>, <7,0.1,-20.5> texture {T_Wood translate <rand(Sd1)*2-1,rand(Sd1)*2-1,rand(Sd1)*2-1> rotate y*3-rand(Sd1)*3} finish {F_Shine2}}

// Door

#declare BoxBorderT= union {
        box {<2,24.5,.5>, <11,24.25,.75> }
        cylinder { <1.875,24.5,.5>, <11.125,24.5,.5>, 0.25 }
        cylinder { <2,24.25,.5>, <11,24.25,.5>, 0.25 }
        texture {T_Wood translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate x*90 scale 1.2} 
        finish {F_Shine3}
        }
#declare BoxBorderB= union {
        box {<2,18.25,.5>, <11,18,.75> }
        cylinder { <1.875,18,.5>, <11.125,18,.5>, 0.25 }
        cylinder { <2,18.25,.5>, <11,18.25,.5>, 0.25 }
        texture {T_Wood translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate x*90 scale 1.2} 
        finish {F_Shine3}
        }

#declare BoxBorderL= union {
        box {<2,24.5,.5>, <2.25,18,.75> }
        cylinder { <2,24.625,.5>, <2,18,.5>, 0.25 }
        cylinder { <2.25,24.625,.5>, <2.25,18,.5>, 0.25 }
        texture {T_Wood translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate z*90 scale 1.2} 
        finish {F_Shine3}
        }

#declare BoxBorderR= union {
        box {<10.75,24.5,.5>, <11,18,.75> }
        cylinder { <10.75,24.625,.5>, <10.75,18,.5>, 0.25 }
        cylinder { <11,24.625,.5>, <11,18,.5>, 0.25 }
        texture {T_Wood translate <rand(Sd1)*.5-.25,rand(Sd1)*.6-.3,0> rotate z*90 scale 1.2} 
        finish {F_Shine3}
        }

#declare DoorBox=union {
    object {BoxBorderT}
    object {BoxBorderL}
    object {BoxBorderB}
    object {BoxBorderR}
}

#declare Knob=sphere {<0,0,0>, 0.5  //<1,12,1.3>, .6 
                        scale <1,1.4,0.37> 
                        texture {pigment {P_Copper2} finish {F_MetalC}}
                        translate <1,12,1.3>
                        }
#declare Doorknob=union {
    cylinder {<1,12,.595>,<1,12,1.1> 0.3 pigment {P_Copper2} finish {F_MetalB}}
    object {Knob}
    cone {<0,0,0.0575>, .31 //<1,12,.6>, .34
          <0,0,-0.0575>, .5   //<1,12,.525>, 1.9
          translate <1,12,.64>
          texture {pigment {P_Copper3} finish {F_MetalB}}
         }
    cylinder {<0,0,-.0125>, <0,0,.0125>,.5 
               translate <1,12,.5125>
               texture{ pigment {P_Copper3} finish {F_MetalB}}
             }
}                     

union {
    box {<0,0.125,.5>, <13,25.5,-.5> texture {T_Wood translate <rand(Sd1)*2-1,rand(Sd1)*2-1,rand(Sd1)*2-1> rotate z*90} finish {F_Shine3} }
    object {DoorBox}
    object {DoorBox translate <0,-8.5,0>}
    object {DoorBox translate <0,-17,0>}
    object {Doorknob translate <11.1,0,0>}
    rotate y*20 translate <-6.7,0,-20.5>}


// Build floor
        
#declare L1=-180;
#declare Ofs=0;

#while (L1<=40)
    #declare L2=-60;
    #while (L2<=60)
        #object {Plank texture {T_Wood translate <rand(Sd1)*2-1,rand(Sd1)*2-1,rand(Sd1)*2-1> rotate y*3-rand(Sd1)*3} finish {F_Shine1} translate <L2+Ofs,0,L1>}
//        #object {Plank texture {pigment {White}} translate <L2+Ofs,0,L1>}
        #declare L2=L2+40+rand(Sd1)*.04+.0125;
    #end
    #if (Ofs=0)
        #declare Ofs=20;
    #else
        #declare Ofs=0;
    #end
    #declare L1=L1+2+rand(Sd1)*.04+.0125;
#end


// blood

#declare BloodTex=texture { 
                    pigment {rgbft <0.723, 0.39, 0.58, 0.85, 0.075>} 
                    finish { 
                            phong .77 
                            phong_size 130 
                            specular 0.3 
                            roughness 0.013 
                            reflection rgb <0.54, 0.22, 0.31> } 
                        }
#declare BloodInt=interior {
                            ior 1.42 
                            caustics 0.131 
                            fade_distance 0.5 
                            fade_power 2}

#declare Blood=blob {
                        threshold .7542
                        sphere { <.5,.09,-20>, .8, 1 }
                        sphere { <-.5,.078,-20>,.721, 1 }
                        sphere { <0,.086,-19.4>,.88, 1 }
                        sphere { <1,.09,-20.5>, .8, 1 }
                        sphere { <-.5,.078,-20.7>,.721, 1 }
                        sphere { <.7,.086,-20.4>,.88, 1 }
                        sphere { <1.1,.09,-20.6>, 1.2, 1 }
                        sphere { <1.34,.078,-20.743>,.721, 1 }
                        sphere { <1.61,.086,-21.1>,.88, 1 }
                        sphere { <2,.09,-22>, .85, 1 }
                        sphere { <2.33,.078,-21.8>,.721, 1 }
                        sphere { <2.45,.086,-20.7>,.88, 1 }
                        sphere { <2.76,.09,-20.4>, .8, 1 }
                        sphere { <2.99,.078,-21.65>,.721, 1 }
                        sphere { <3.21,.086,-20.53>,.88, 1 }
                       sphere { <3.7,.09,-21.5>, .8, 1 }
                        sphere { <3.9,.078,-22.7>,.721, 1 }
                        sphere { <4.2,.086,-23.1>,.88, 1 }
                        sphere { <3.46,.09,-21.4>, .8, 1 }
                        sphere { <3.85,.078,-20.93>,.721, 1 }
                        sphere { <2.6,.086,-21.13>,.88, 1 }
                       sphere { <3.8,.09,-21.92>, .8, 1 }
                        sphere { <4.1,.09,-21.6>, 1.2, 1 }
                        sphere { <4.4,.078,-20.9>,.721, 1 }
                        sphere { <5,.086,-21.1>,.88, 1 }
                        sphere { <4.8,.09,-22>, .85, 1 }
                        sphere { <5.23,.078,-21.8>,.721, 1 }
                        sphere { <5.43,.086,-24.3>,.88, 1 }
                        sphere { <5.67,.09,-21.4>, .8, 1 }
                        sphere { <5.92,.078,-22.65>,.721, 1 }
                       sphere { <4.7,.09,-21.5>, .8, 1 }
                        sphere { <5,.078,-22.3>,.721, 1 }
                        sphere { <5.1,.086,-20.435>,.88, 1 }
                        sphere { <5.3,.09,-21.4>, 1.2, 1 }
                        sphere { <5.5,.078,-22.9>,.721, 1 }
                        sphere { <5.75,.086,-20.1>,.88, 1 }
                        sphere { <5.8,.09,-21.5>, .85, 1 }
                        sphere { <6,.078,-21.8>,.721, 1 }
                        sphere { <6.2,.086,-23.3>,.88, 1 }
                        sphere { <5.8,.09,-23.8>, .8, 1 }
                        sphere { <6.3,.078,-22.65>,.721, 1 }
                        sphere { <6.45,.086,-21.3>,.88, 1 }
                        sphere { <6,.078,-20.95>,.721, 1 }
                        sphere { <6.15,.086,-21>,.88, 1 }
                        sphere { <6.18,.086,-22>,.88, 1 }
                        scale <1,.17,1> 
                        texture { BloodTex}
                        interior {BloodInt}
                    }
object { Blood}
