// Burial mounds

#declare r0 = seed(4842);
#declare r1 = seed(9372);

#macro mRound( ob )
	object { ob rotate y*  0 }
	object { ob rotate y* 90 }
	object { ob rotate y*180 }
	object { ob rotate y*270 }
#end

#declare DirtMound = union {
	sphere { < 0.5, 0, 1.5>, 1.5 }
	sphere { < 0.5, 0, 4.5>, 1.5 }
	sphere { <-0.5, 0, 1.5>, 1.5 }
	sphere { <-0.5, 0, 4.5>, 1.5 }
	cylinder { <-0.5, 0, 1.5>, < 0.5, 0, 1.5>, 1.5 }
	cylinder { < 0.5, 0, 4.5>, < 0.5, 0, 1.5>, 1.5 }
	cylinder { < 0.5, 0, 4.5>, <-0.5, 0, 4.5>, 1.5 }
	cylinder { <-0.5, 0, 1.5>, <-0.5, 0, 4.5>, 1.5 }
	box { <-0.5, 0, 1.5>, < 0.5, 1.5, 4.5> }
	scale <1, .3, 1>
	clipped_by { box { <-2, 0, 0>, <2, 0.5, 6> } }
	texture { Dirt1 }
}

#declare StoneMound = intersection {
	box { <-1.5, 0, -1.5>, <1.5, 1.5, 1.5> }
	mRound( plane { <0, 1, 5>, 0 translate <0, 0.25, 1.5> } )
	texture { Stone1 }
}

// Tombstone 1a: basic
#declare TombWord1 = text {
	ttf "\windows\fonts\bloodrac.ttf" "R.I.P." 0.10, 0.1*x
	translate <-1.55, -.3, -.12>
}

#declare HeadBody = union {
	box { -1, 1 }
	cylinder { <0, 1, -1>, <0, 1, 1>, 0.8 }
	translate y
	scale <2, 3, .4>
	
}

#declare HeadCut = union {
	cylinder { <-.6, 1.6, .75>, <-.6, 1.6, 1.1>, .3 }
	cylinder { < .6, 1.6, .75>, < .6, 1.6, 1.1>, .3 }
	box { <-.6, 1.3, .75>, < .6, 1.9, 1.1> }
	scale <2, 3, .4>
}

#macro tRot( tx ) texture { tx rotate <rand(r0)*180, rand(r0)*180, rand(r0)*180> } #end

#macro HeadStone()
	#local hxr = 20*(rand(r1)-.5);
	#local hzr = 20*(rand(r1)-.5);
	#local hcl = tRot( m1Col )
	#local rcl = tRot( Rot1 )	
	union {
		difference {
			object { HeadBody texture { hcl } texture { rcl } }
			object { HeadCut texture { m1cCol } texture { rcl } }
			bounded_by { box { <-2, 0, -.5>, <2, 9, .5> } }
		}
		object { TombWord1 
			rotate y*180
			translate <0, 4.8, 0.30>
			texture { hcl }
			texture { rcl }
		}
		translate y*-.5
		rotate <hxr, 0, hzr>
	}
#end

#macro Marker1() 
	union {
		HeadStone()
		object { DirtMound translate z*.5 }
	}
#end

//Tombstone 2: cross
#declare CrossBaseBody = intersection {
	box { <-2, 0, -2>, <2, 4, 2> }
	plane { <0, 1, 8>, 0 translate z*2 }
	plane { <0, 1, 8>, 0 translate z*2 rotate y* 90 }
	plane { <0, 1, 8>, 0 translate z*2 rotate y*180 }
	plane { <0, 1, 8>, 0 translate z*2 rotate y*270 }
	bounded_by { box { <-2, 0, -2>, <2, 4, 2> } }
}

#declare CrossBaseCut = intersection {
	box { <-1.7, 0.3, 0>, <1.7, 3.7, 2> }
	plane { <0, -1, -8>, 0 translate <0, 0.3, 1.7> }
	plane { <8, 1, 0>, 0 translate <1.7, 0.3, 0> }
	plane { <-8, 1, 0>, 0 translate <-1.7, 0.3, 0> }
	bounded_by { box { <-1.7, 0.3, 0>, <1.7, 3.7, 2> } }
}

#declare CrossBase = difference {
	object { CrossBaseBody }
	union {
		object { CrossBaseCut }
		object { CrossBaseCut rotate y* 90 }
		object { CrossBaseCut rotate y*180 }
		object { CrossBaseCut rotate y*270 }
	}
}

#declare CrossStraight = prism {
	linear_sweep
	linear_spline
	0, 1.4, 17,
	<-.2, 0.4>, <0.2, 0.4>, <0.5, 0.7>, <0.7, 0.5>, <0.4, 0.2>,
	<0.4, -.2>, <0.7, -.5>, <0.5, -.7>, <0.2, -.4>, <-.2, -.4>,
	<-.5, -.7>, <-.7, -.5>, <-.4, -.2>, <-.4, 0.2>, <-.7, 0.5>,
	<-.5, 0.7>, <-.2, 0.4>
	translate y*-.7
}

#declare CrossCone = intersection {
	object { CrossStraight }
	mRound( plane { <0, 1, 1>, 0 } )
}

#declare CrossCube = intersection {
	object { CrossStraight }
	object { CrossStraight rotate z*90 }
	object { CrossStraight rotate x*90 }
}

#declare CrossBlock = union {
	object { CrossCube }
	mRound( CrossCone )
}

#declare CrossCircle = lathe {
	linear_spline
	17,
	<2.8, 0.4>, <3.2, 0.4>, <3.5, 0.7>, <3.7, 0.5>, <3.4, 0.2>,
	<3.4, -.2>, <3.7, -.5>, <3.5, -.7>, <3.2, -.4>, <2.8, -.4>,
	<2.5, -.7>, <2.3, -.5>, <2.6, -.2>, <2.6, 0.2>, <2.3, 0.5>,
	<2.5, 0.7>, <2.8, 0.4>
	rotate x*90
}

#declare CrossPie = lathe {
	linear_spline
	11,
	<0.0, 0.4>, <0.2, 0.4>, <0.5, 0.7>, <0.7, 0.5>, <0.4, 0.2>,
	<0.4, -.2>, <0.7, -.5>, <0.5, -.7>, <0.2, -.4>, <0.0, -.4>,
	<0.0, 0.4>
	rotate x*90
}

#declare CrossHemi = //union {
	intersection {
		object { CrossPie }
		plane { -y, 0 }
		// translate y*1.4
	}/*
	object { CrossStraight translate y*.7 }
}*/

#declare CubeHemi = union {
	object { CrossBlock }
	object { CrossHemi translate y*.7 }
	object { CrossHemi translate y*.7 rotate z*90 }
	object { CrossHemi translate y*.7 rotate z*-90 }
}

#declare StraightCut = union {
	box{ <-3.7, -0.6, 0.4>, <3.7, 0.6, 0.8> }
	box{ <-0.6, -3.7, 0.4>, <0.6, 3.7, 0.8> }
}

#declare CircleCut = difference {
	cylinder { z*0.4, z*0.8, 3.6 }
	cylinder { z*0.3, z*0.9, 2.4 }
}

#declare CrossPiece = union {
	object { CrossCube }
	object { CrossStraight scale <1, 4, 1> translate y*3.5 }
	object { CubeHemi translate y*7.0 }
	object { CrossStraight scale <1, 4, 1> translate y*3.5 rotate z*90 }
	object { CubeHemi translate y*7.0 rotate z*90 }
	object { CrossStraight scale <1, 4, 1> translate y*3.5 rotate z*-90 }
	object { CubeHemi translate y*7.0 rotate z*-90 }
	object { CrossStraight scale <1, 8, 1> translate -y*6.3 }
	object { CubeHemi translate y*12.6 rotate z*180 }
}

#macro Cross()
	union {
		#local hxr = 10*(rand(r1)-.5);
		#local hzr = 10*(rand(r1)-.5);
		#local hcl = tRot( m2Col )
		difference {
			object { CrossPiece }
			object { CircleCut }
			object { CircleCut rotate y*180 }
		}
		difference {
		object { CrossCircle }
			object { StraightCut }
			object { StraightCut rotate y*180}
		}
		scale <.5, .5, 1>
		translate y*6.3
		rotate <hxr, 0, hzr>
		texture { hcl }
	}
#end

#macro Marker2()
	union {
		object { Cross() translate y*4 }
		object { CrossBase texture { m2bCol } }
		object { StoneMound translate z*4 }
		translate z*2
	}
#end

//Tombstone 3: Rear
#macro sdRound( len, rad )
	intersection {
		cylinder { <-len, 0, 0>, <len, 0, 0>, rad }
		plane { <1, 0, 1>, 0 translate <len-rad, 0, 0> }
		plane { <-1, 0, 1>, 0 translate <rad-len, 0, 0> }
	}
#end

#macro Roundel( siz, cut )
	#local szc = siz - <cut, cut, cut>;
	union {
		box { <-szc.x, -cut, -szc.z>, <szc.x, cut, szc.z> }
		object { sdRound( siz.x, cut ) translate <0, 0, -szc.z> rotate y*  0 }
		object { sdRound( siz.z, cut ) translate <0, 0, -szc.x> rotate y* 90 }
		object { sdRound( siz.x, cut ) translate <0, 0, -szc.z> rotate y*180 }
		object { sdRound( siz.z, cut ) translate <0, 0, -szc.x> rotate y*270 }
	}
#end

#macro LowMound( siz, cut )
	#local szc = siz - <cut, cut, cut>;
	union {
		object { Roundel( siz, cut ) translate y*szc.y }
		box { <-siz.x, 0, -siz.z>, <siz.x, szc.y, siz.z> }
	}
#end

#declare FlowerPot = difference {
	cone { y*0.0, .50, y*2.0, .90 }
	cone { y*0.1, .45, y*2.1, .85 }
}

#declare TombWord3 = text {
	ttf "\windows\fonts\bodoni.ttf" "In Loving Memory" 0.36, 0.1*x
	translate <-4.7, -.3, -.35>
	rotate <90, 180, 0>
}

#declare m3d = <7.0, 1.0, 2.0>;
#declare m3Cut = 0.5;

#declare Marker3 = union {
	difference {
		object { LowMound( m3d, m3Cut ) }
		box { <-5, m3d.y-.35, -1.2>, <-5, m3d.y+.35, 1.2> }
	}
  object { TombWord3 translate y*m3d.y }
	object { FlowerPot translate <1-m3d.x+m3Cut, m3d.y, 0> }
	object { FlowerPot translate <m3d.x-m3Cut-1, m3d.y, 0> }
	texture { m3Col }
}

//Tomestone 4: Gabled
#macro Frust(wid, cut, h)
	intersection {
		box { <-wid, 0, -wid>, <wid, h, wid> }
		mRound( plane { <h, cut, 0>, 0 translate x*wid } )
	}
#end

#macro Cove( dim, rad )
	difference {
		box { <-dim.x, 0, -dim.z>, dim }
		union { mRound( cylinder { dim-2*x*dim.x, dim, rad } ) }
	}
#end

#declare m4Base = union {
	object { Cove ( <3, .8, 3>, .6 ) }
	box { <-2.4, .8, -2.4>, <2.4, 1.2, 2.4> }
	object { Cove ( <3.0, 1.2, 3.0>, 0.6 ) rotate x*180 translate y*2.4 }
	object { Cove ( <3.0, 0.4, 3.0>, 0.4 ) translate y*2.4 }
	object { Frust ( 2.6, 0.2, 0.4 ) translate y*2.8 }
}

#macro CutPyr( out, in, dep )
	prism {
		conic_sweep
		linear_spline
		0.36, 1, 21,
		< 1.0, 1.0>, < out, 1.0>, < in, dep>, <-in, dep>, <-out, 1.0>, <-1.0, 1.0>,
		<-1.0, out>, <-dep, in>, <-dep,-in>, <-1.0,-out>, <-1.0,-1.0>, <-out,-1.0>,
		<-in,-dep>, < in,-dep>, < out,-1.0>, < 1.0,-1.0>, < 1.0,-out>, < dep,-in>,
		< dep, in>, < 1.0, out>, < 1.0, 1.0>
		translate -y
		scale < 2.4, -25, 2.4>	
	}
#end

#macro m4gFlat( len, wid, cut )
	union {
		object { Cove ( <wid-cut, cut, len>, cut ) translate -y*cut rotate x*180 }
		object { Roundel ( <wid, cut, len>, cut ) translate y*2*cut }
	}
#end

#macro m4gSection( len, wid, cut )
	intersection {
		object {
			m4gFlat( len, wid, cut )
			translate x*(wid-4*cut)
			rotate z*315
		}
		plane { -x, 0 }
	}
#end

#declare m4gCut = box { <-8, -8, -20>, <0, 0, 20> rotate z*45 }

#macro m4gAngle (len, wid, cut)
	difference {
		union {
			object { m4gSection( len, wid, cut ) rotate y*  0 }
			object { m4gSection( len, wid, cut ) rotate y*180 }
		}
		object { m4gCut rotate y*90 translate y*cut*4.24 }
	}
#end

#macro m4gRoof( len, wid, cut )
	difference {
		object { m4gFlat( len, len, cut ) translate y*-wid }
		object { m4gCut translate y*cut*4.24 }
		object { m4gCut rotate y*90 translate y*cut*4.24 }
	}
#end

#macro m4Gable( len, wid, cut )
	union {
		object { m4gAngle( len, wid, cut ) }
		object { m4gAngle( len, wid, cut ) rotate y*90 }
		object { m4gRoof( len, wid, cut ) }
	}
#end

#declare m4Gables = union {
	object { m4Gable( 2.8, 2.1, 0.35 ) translate y*6 }
	object { m4Gable( 2.0, 1.5, 0.25 ) translate y*13 }
	object { m4Gable( 1.2, 0.9, 0.15 ) translate y*18 }
}

#declare m4Cross = union {
	box { <-0.2, 0.0, -0.2>, < 0.2, 4.0, 0.2> }
	box { <-1.0, 0.8, -0.2>, < 1.0, 1.2, 0.2> }
	box { <-0.6, 2.8, -0.2>, < 0.6, 3.2, 0.2> }
	rotate x*-4.29
	translate z*2
}

#declare m4pCut = prism {
	conic_sweep
	linear_spline
	0.82, 1.0, 5,
	<-0.80,-0.4>, <-0.74, 0.4>, <0.74, 0.4>, <0.80,-0.4>, <-0.80,-0.4>
	scale <2.0, 2.35, 2.5>
	rotate x*-85.71
}

#declare m4Top = difference {
	object { Frust( 2.4, 1.2, 16 ) texture { m4Col } translate y*3.2 }
	union { mRound( m4pCut ) texture { m4cCol } translate y*7 }
}

#declare Marker4 = union {
	object { m4Base }
	object { m4Top }
	object { m4Gable( 1.4, 1.05, 0.175 ) translate y*19.8 }
	object { m4gCut scale <0.15, 0.15, .05> rotate y*90 translate y*20.3 }
	object { m4gCut scale <0.15, 0.15, .05> rotate y* 0 translate y*20.3 }
	union { mRound( m4Cross ) translate y*10 }
	translate z*3
	texture { m4Col }
}

//Tombstone 5: Oval

#declare TombWord5 = text {
	ttf "\windows\fonts\scythe.ttf" "Gone" 0.10, 0.1*x
	rotate y*180
	translate < 1.30, -.3, 0.40>
	scale <1.5, 1.5, 1>
}

#declare m5Base = union {
	difference {
		box { <-2.4, 0.0,-0.4>, < 2.4, 1.7, 0.4> }
		cylinder { <-2.4, 1.7, -.5>, <-2.4, 1.7, 0.5>, 1.2 }
		cylinder { < 2.4, 1.7, -.5>, < 2.4, 1.7, 0.5>, 1.2 }
		cylinder { -z*.5, z*.5, 1.2 scale <1, .3, 1> translate y*1.7 }
	}
	box { <-3.0, 0.0,-0.4>, < 3.0, 0.5, 0.4> }
	cylinder { <-2.7, 0.5,-0.4>, <-2.7, 0.5, 0.4>, 0.3 }
	cylinder { < 2.7, 0.5,-0.4>, < 2.7, 0.5, 0.4>, 0.3 }
	texture { m5Col }
}

#declare m5Crest = union {
	difference {
		union {
			cone { -z*.4, 1.40, 0, 1.60 }
			cone {  z*.4, 1.40, 0, 1.60 }
		}
		cylinder { -z*.5, z*.5, 1.30 }
		scale <2, 1, 1>
		texture { m5Col }
	}
	cylinder { 
		-z*.3, z*.3, 1.30 
		scale <2, 1, 1>
		texture { m5cCol }
	}
	object { TombWord5 texture { m5Col } }
	translate y*3.3
}

#macro m5nPos( dis, ang , ecc )
	#local xm = dis*cos(radians(ang));
	#local ym = dis*sin(radians(ang))*ecc;
	sphere { 0, .4 translate <xm, ym, 0> }		
#end

#declare m5nQuart = union {
	object { m5nPos( 3.4,  0.0, 0.5) }
	object { m5nPos( 3.4, 16.0, 0.5) }
	object { m5nPos( 3.4, 31.0, 0.5) }
	object { m5nPos( 3.4, 45.0, 0.5) }
	object { m5nPos( 3.4, 58.0, 0.5) }
	object { m5nPos( 3.4, 69.0, 0.5) }
	object { m5nPos( 3.4, 80.0, 0.5) }
	object { m5nPos( 3.4, 90.0, 0.5) }
}

#declare m5Nodes = union {
	object { m5nQuart scale < 1, 1, 1> }
	object { m5nQuart scale < 1,-1, 1> }
	object { m5nQuart scale <-1, 1, 1> }
	object { m5nQuart scale <-1,-1, 1> }
	translate y*3.3
	texture { m5Col }
}

#declare Marker5 = union {
	object { m5Base }
	object { m5Crest }
	object { m5Nodes }
	object { DirtMound translate z*.5 }
}
	