// File generated by sPatch, Copyright 1996-1998 by Mike Clifton
                                                    
#include "colors.inc"                                                    
#include "metals.inc"
                       
// set the maximum ray tracing bounce depth (1...20) [5]
global_settings {
 #max_trace_level 15
}
                       
#declare Leather2 = texture {
    pigment {
        rgb <0.85,0.53,0.10>*0.6
    }
    finish {
        ambient < 0.200, 0.200, 0.200 >
        diffuse 0.50
        brilliance 1.00
        phong 0.20
        phong_size 50.00
        crand 0.100
    }
}

#declare texClear=
 texture {
  pigment {Clear}       
  finish {ambient 0 diffuse 0 specular 0 phong 0 reflection 0}
 }
 
#declare texBlood=         
 texture { 
  pigment {rgbf <0.6,0,0.1,0.4>}
  finish {specular 0.7 roughness 0.002 reflection 0.1}
 }

#declare Spotty=
 texture { 
  leopard
  texture_map {
   [0.0 texClear]
   [0.65 texClear]
   [0.7 texBlood]
   [1.0 texBlood]
  }               
  scale 0.03
 }

#declare Blood=
 texture {
  gradient x
  texture_map {
   [0.0 Spotty]
   [0.35 Spotty]          
   [0.36 texBlood]
   [0.62 texBlood] 
   [0.63 Spotty] 
   [1.0 Spotty]
  }            
  rotate z*5
  scale 15               
  turbulence 0.8
 }

#declare SwordCamera=
 camera {
	location <-0.9, 0, -1.754>
	look_at <-0.9,0, 0>
 }                  

#declare GuardCamera=
 camera {
  location <-1,0,-2>
  look_at <-1,0,0>
 }

#declare HiltCamera=
 camera {
  location <1,0,-4>
  look_at <0,0,0>
 }                               

#declare Blade=  
  union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.006, 2.044, -14.432> <0.002, 1.494, -14.002> <0.005, 1.291, -13.547> 
		<-0.005, 2.367, -14.804> <-0.000, 2.045, -14.425> <-0.058, 1.655, -13.985> <-0.055, 1.453, -13.530> 
		<0.002, 2.369, -14.795> <-0.058, 2.207, -14.406> <-0.116, 1.782, -13.918> <-0.135, 1.668, -13.507> 
		<0.008, 2.370, -14.788> <-0.053, 2.208, -14.399> <-0.176, 1.943, -13.900> <-0.195, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.005, 2.367, -14.804> <0.002, 2.369, -14.795> <0.008, 2.370, -14.788> 
		<0.024, 2.264, -14.403> <0.030, 2.265, -14.396> <0.062, 2.207, -14.406> <0.067, 2.208, -14.399> 
		<0.092, 2.119, -13.862> <0.148, 2.082, -13.870> <0.154, 2.002, -13.888> <0.184, 1.943, -13.900> 
		<0.105, 2.026, -13.451> <0.161, 1.989, -13.458> <0.175, 1.888, -13.478> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.005, 2.367, -14.804> <0.002, 2.369, -14.795> <0.008, 2.370, -14.788> 
		<-0.006, 2.044, -14.432> <-0.000, 2.045, -14.425> <0.062, 2.207, -14.406> <0.067, 2.208, -14.399> 
		<0.002, 1.494, -14.002> <0.062, 1.655, -13.985> <0.124, 1.782, -13.917> <0.184, 1.943, -13.900> 
		<0.005, 1.291, -13.547> <0.065, 1.453, -13.530> <0.145, 1.668, -13.507> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.005, 2.367, -14.804> <0.002, 2.369, -14.795> <0.008, 2.370, -14.788> 
		<-0.006, 2.044, -14.432> <-0.000, 2.045, -14.425> <-0.058, 2.207, -14.406> <-0.053, 2.208, -14.399> 
		<0.002, 1.494, -14.002> <-0.058, 1.655, -13.985> <-0.116, 1.782, -13.918> <-0.176, 1.943, -13.900> 
		<0.005, 1.291, -13.547> <-0.055, 1.453, -13.530> <-0.135, 1.668, -13.507> <-0.195, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <0.024, 2.264, -14.403> <0.092, 2.119, -13.862> <0.105, 2.026, -13.451> 
		<-0.005, 2.367, -14.804> <0.030, 2.265, -14.396> <0.148, 2.082, -13.870> <0.161, 1.989, -13.458> 
		<0.002, 2.369, -14.795> <0.062, 2.207, -14.406> <0.154, 2.002, -13.888> <0.175, 1.888, -13.478> 
		<0.008, 2.370, -14.788> <0.067, 2.208, -14.399> <0.184, 1.943, -13.900> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.005, 2.367, -14.804> <0.002, 2.369, -14.795> <0.008, 2.370, -14.788> 
		<-0.006, 2.044, -14.432> <-0.000, 2.045, -14.425> <0.062, 2.207, -14.406> <0.067, 2.208, -14.399> 
		<0.002, 1.494, -14.002> <0.062, 1.655, -13.985> <0.124, 1.782, -13.917> <0.184, 1.943, -13.900> 
		<0.005, 1.291, -13.547> <0.065, 1.453, -13.530> <0.145, 1.668, -13.507> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.005, 2.367, -14.804> <0.002, 2.369, -14.795> <0.008, 2.370, -14.788> 
		<-0.006, 2.044, -14.432> <-0.000, 2.045, -14.425> <-0.058, 2.207, -14.406> <-0.053, 2.208, -14.399> 
		<0.002, 1.494, -14.002> <-0.058, 1.655, -13.985> <-0.116, 1.782, -13.918> <-0.176, 1.943, -13.900> 
		<0.005, 1.291, -13.547> <-0.055, 1.453, -13.530> <-0.135, 1.668, -13.507> <-0.195, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <0.024, 2.264, -14.403> <0.092, 2.119, -13.862> <0.105, 2.026, -13.451> 
		<-0.005, 2.367, -14.804> <0.030, 2.265, -14.396> <0.148, 2.082, -13.870> <0.161, 1.989, -13.458> 
		<0.002, 2.369, -14.795> <0.062, 2.207, -14.406> <0.154, 2.002, -13.888> <0.175, 1.888, -13.478> 
		<0.008, 2.370, -14.788> <0.067, 2.208, -14.399> <0.184, 1.943, -13.900> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.005, 2.367, -14.804> <0.002, 2.369, -14.795> <0.008, 2.370, -14.788> 
		<-0.006, 2.044, -14.432> <-0.000, 2.045, -14.425> <0.062, 2.207, -14.406> <0.067, 2.208, -14.399> 
		<0.002, 1.494, -14.002> <0.062, 1.655, -13.985> <0.124, 1.782, -13.917> <0.184, 1.943, -13.900> 
		<0.005, 1.291, -13.547> <0.065, 1.453, -13.530> <0.145, 1.668, -13.507> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.036, 2.264, -14.403> <-0.089, 2.119, -13.862> <-0.095, 2.026, -13.451> 
		<-0.011, 2.366, -14.811> <-0.036, 2.264, -14.403> <-0.089, 2.119, -13.862> <-0.095, 2.026, -13.451> 
		<-0.011, 2.366, -14.811> <-0.036, 2.264, -14.403> <-0.089, 2.119, -13.862> <-0.095, 2.026, -13.451> 
		<-0.011, 2.366, -14.811> <-0.036, 2.264, -14.403> <-0.089, 2.119, -13.862> <-0.095, 2.026, -13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <-0.011, 2.366, -14.811> <-0.011, 2.366, -14.811> <-0.011, 2.366, -14.811> 
		<-0.036, 2.264, -14.403> <-0.001, 2.162, -13.995> <-0.001, 2.162, -13.995> <0.024, 2.264, -14.403> 
		<-0.089, 2.119, -13.862> <-0.029, 2.119, -13.862> <0.042, 2.151, -13.856> <0.092, 2.119, -13.862> 
		<-0.095, 2.026, -13.451> <-0.035, 2.026, -13.451> <0.055, 2.058, -13.444> <0.105, 2.026, -13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.366, -14.811> <0.024, 2.264, -14.403> <0.092, 2.119, -13.862> <0.105, 2.026, -13.451> 
		<-0.006, 2.044, -14.432> <0.029, 1.942, -14.024> <0.148, 2.082, -13.870> <0.161, 1.989, -13.458> 
		<0.002, 1.494, -14.002> <0.062, 1.655, -13.985> <0.115, 1.727, -13.495> <0.175, 1.888, -13.478> 
		<0.005, 1.291, -13.547> <0.065, 1.453, -13.530> <0.145, 1.668, -13.507> <0.205, 1.829, -13.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.008, 2.370, -14.788> <0.002, 2.369, -14.795> <-0.005, 2.367, -14.804> <-0.011, 2.366, -14.811> 
		<-0.053, 2.208, -14.399> <-0.058, 2.207, -14.406> <-0.030, 2.265, -14.396> <-0.036, 2.264, -14.403> 
		<-0.176, 1.943, -13.900> <-0.146, 2.002, -13.889> <-0.119, 2.061, -13.873> <-0.089, 2.119, -13.862> 
		<-0.195, 1.829, -13.490> <-0.165, 1.888, -13.478> <-0.125, 1.967, -13.463> <-0.095, 2.026, -13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.008, 2.370, -14.788> <-0.053, 2.208, -14.399> <-0.176, 1.943, -13.900> <-0.195, 1.829, -13.490> 
		<0.067, 2.208, -14.399> <0.006, 2.046, -14.009> <-0.116, 1.782, -13.918> <-0.135, 1.668, -13.507> 
		<0.184, 1.943, -13.900> <0.124, 1.782, -13.917> <0.005, 1.614, -13.513> <-0.055, 1.453, -13.530> 
		<0.205, 1.829, -13.490> <0.145, 1.668, -13.507> <0.065, 1.453, -13.530> <0.005, 1.291, -13.547> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 2.026, -13.451> <-0.095, 2.026, -13.451> <-0.095, 2.026, -13.451> <-0.095, 2.026, -13.451> 
		<-0.095, 2.026, -13.451> <-0.108, 1.833, -12.607> <-0.108, 1.833, -12.607> <-0.108, 1.833, -12.607> 
		<-0.095, 2.026, -13.451> <-0.108, 1.833, -12.607> <-0.087, 1.779, -12.322> <-0.080, 1.595, -11.476> 
		<-0.095, 2.026, -13.451> <-0.108, 1.833, -12.607> <-0.080, 1.595, -11.476> <-0.074, 1.410, -10.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.095, 2.026, -13.451> <-0.035, 2.026, -13.451> <0.055, 2.058, -13.444> <0.105, 2.026, -13.451> 
		<-0.108, 1.833, -12.607> <-0.048, 1.833, -12.607> <0.081, 1.867, -12.598> <0.131, 1.834, -12.604> 
		<-0.080, 1.595, -11.476> <-0.022, 1.598, -11.473> <0.068, 1.598, -11.471> <0.117, 1.566, -11.476> 
		<-0.074, 1.410, -10.630> <-0.016, 1.413, -10.627> <0.071, 1.450, -10.615> <0.120, 1.419, -10.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.105, 2.026, -13.451> <0.161, 1.989, -13.458> <0.175, 1.888, -13.478> <0.205, 1.829, -13.490> 
		<0.131, 1.834, -12.604> <0.187, 1.798, -12.611> <0.218, 1.656, -12.643> <0.248, 1.597, -12.654> 
		<0.117, 1.566, -11.476> <0.173, 1.530, -11.482> <0.187, 1.429, -11.504> <0.217, 1.370, -11.515> 
		<0.120, 1.419, -10.620> <0.176, 1.383, -10.626> <0.190, 1.282, -10.648> <0.220, 1.223, -10.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.205, 1.829, -13.490> <0.145, 1.668, -13.507> <0.065, 1.453, -13.530> <0.005, 1.291, -13.547> 
		<0.248, 1.597, -12.654> <0.188, 1.436, -12.671> <0.071, 1.091, -12.716> <0.011, 0.929, -12.733> 
		<0.217, 1.370, -11.515> <0.157, 1.161, -11.521> <0.077, 0.913, -11.545> <0.017, 0.704, -11.550> 
		<0.220, 1.223, -10.659> <0.160, 1.014, -10.665> <0.080, 0.736, -10.672> <0.020, 0.527, -10.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.005, 1.291, -13.547> <-0.055, 1.453, -13.530> <-0.135, 1.668, -13.507> <-0.195, 1.829, -13.490> 
		<0.011, 0.929, -12.733> <-0.049, 1.091, -12.716> <-0.173, 1.436, -12.671> <-0.233, 1.597, -12.654> 
		<0.017, 0.704, -11.550> <-0.043, 0.913, -11.545> <-0.123, 1.161, -11.521> <-0.183, 1.370, -11.515> 
		<0.020, 0.527, -10.677> <-0.040, 0.736, -10.672> <-0.120, 1.014, -10.665> <-0.180, 1.223, -10.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.195, 1.829, -13.490> <-0.165, 1.888, -13.478> <-0.125, 1.967, -13.463> <-0.095, 2.026, -13.451> 
		<-0.233, 1.597, -12.654> <-0.203, 1.656, -12.642> <-0.138, 1.774, -12.618> <-0.108, 1.833, -12.607> 
		<-0.183, 1.370, -11.515> <-0.151, 1.426, -11.506> <-0.112, 1.539, -11.485> <-0.080, 1.595, -11.476> 
		<-0.180, 1.223, -10.659> <-0.148, 1.279, -10.651> <-0.106, 1.354, -10.639> <-0.074, 1.410, -10.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 1.419, -10.620> <0.123, 1.287, -9.850> <0.124, 1.173, -8.813> <0.124, 1.094, -8.035> 
		<0.071, 1.450, -10.615> <0.074, 1.318, -9.845> <0.074, 1.205, -8.806> <0.074, 1.126, -8.028> 
		<-0.016, 1.413, -10.627> <-0.016, 1.318, -9.848> <-0.015, 1.171, -8.815> <-0.016, 1.094, -8.035> 
		<-0.074, 1.410, -10.630> <-0.074, 1.315, -9.851> <-0.075, 1.171, -8.815> <-0.076, 1.094, -8.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 1.419, -10.620> <0.176, 1.383, -10.626> <0.190, 1.282, -10.648> <0.220, 1.223, -10.659> 
		<0.123, 1.287, -9.850> <0.179, 1.251, -9.855> <0.193, 1.149, -9.877> <0.223, 1.090, -9.889> 
		<0.124, 1.173, -8.813> <0.180, 1.136, -8.820> <0.232, 1.042, -8.842> <0.224, 0.976, -8.852> 
		<0.124, 1.094, -8.035> <0.180, 1.057, -8.042> <0.232, 0.964, -8.065> <0.224, 0.898, -8.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.220, 1.223, -10.659> <0.160, 1.014, -10.665> <0.080, 0.736, -10.672> <0.020, 0.527, -10.677> 
		<0.223, 1.090, -9.889> <0.163, 0.882, -9.894> <0.082, 0.584, -9.927> <0.022, 0.375, -9.932> 
		<0.224, 0.976, -8.852> <0.200, 0.760, -8.883> <0.084, 0.482, -8.894> <0.024, 0.272, -8.920> 
		<0.224, 0.898, -8.074> <0.200, 0.681, -8.105> <0.084, 0.407, -8.137> <0.024, 0.197, -8.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.527, -10.677> <-0.040, 0.736, -10.672> <-0.120, 1.014, -10.665> <-0.180, 1.223, -10.659> 
		<0.022, 0.375, -9.932> <-0.038, 0.584, -9.927> <-0.117, 0.882, -9.894> <-0.177, 1.090, -9.889> 
		<0.024, 0.272, -8.920> <-0.036, 0.482, -8.894> <-0.116, 0.766, -8.879> <-0.176, 0.976, -8.852> 
		<0.024, 0.197, -8.164> <-0.036, 0.407, -8.137> <-0.116, 0.688, -8.101> <-0.176, 0.898, -8.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.180, 1.223, -10.659> <-0.148, 1.279, -10.651> <-0.106, 1.354, -10.639> <-0.074, 1.410, -10.630> 
		<-0.177, 1.090, -9.889> <-0.146, 1.147, -9.880> <-0.106, 1.259, -9.860> <-0.074, 1.315, -9.851> 
		<-0.176, 0.976, -8.852> <-0.146, 1.035, -8.840> <-0.105, 1.113, -8.827> <-0.075, 1.171, -8.815> 
		<-0.176, 0.898, -8.074> <-0.146, 0.956, -8.062> <-0.106, 1.035, -8.047> <-0.076, 1.094, -8.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.074, 1.410, -10.630> <-0.074, 1.410, -10.630> <-0.074, 1.410, -10.630> <-0.074, 1.410, -10.630> 
		<-0.074, 1.315, -9.851> <-0.075, 1.220, -9.073> <-0.075, 1.220, -9.073> <-0.074, 1.315, -9.851> 
		<-0.075, 1.171, -8.815> <-0.075, 1.171, -8.815> <-0.075, 1.171, -8.815> <-0.075, 1.171, -8.815> 
		<-0.076, 1.094, -8.035> <-0.076, 1.094, -8.035> <-0.076, 1.094, -8.035> <-0.076, 1.094, -8.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 1.094, -8.035> <-0.077, 1.017, -7.259> <-0.080, 0.945, -6.222> <-0.080, 0.894, -5.444> 
		<-0.076, 1.094, -8.035> <-0.077, 1.017, -7.259> <-0.080, 0.945, -6.222> <-0.080, 0.894, -5.444> 
		<-0.076, 1.094, -8.035> <-0.077, 1.017, -7.259> <-0.080, 0.945, -6.222> <-0.080, 0.894, -5.444> 
		<-0.076, 1.094, -8.035> <-0.077, 1.017, -7.259> <-0.080, 0.945, -6.222> <-0.080, 0.894, -5.444> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 1.094, -8.035> <-0.016, 1.094, -8.035> <0.074, 1.126, -8.028> <0.124, 1.094, -8.035> 
		<-0.077, 1.017, -7.259> <-0.017, 1.017, -7.259> <0.074, 1.048, -7.253> <0.124, 1.015, -7.259> 
		<-0.080, 0.945, -6.222> <-0.020, 0.945, -6.222> <0.071, 0.978, -6.215> <0.120, 0.945, -6.222> 
		<-0.080, 0.894, -5.444> <-0.020, 0.894, -5.444> <0.070, 0.927, -5.437> <0.120, 0.894, -5.444> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.124, 1.094, -8.035> <0.180, 1.057, -8.042> <0.232, 0.964, -8.065> <0.224, 0.898, -8.074> 
		<0.124, 1.015, -7.259> <0.180, 0.979, -7.267> <0.232, 0.885, -7.289> <0.224, 0.819, -7.298> 
		<0.120, 0.945, -6.222> <0.176, 0.909, -6.229> <0.190, 0.808, -6.249> <0.220, 0.749, -6.261> 
		<0.120, 0.894, -5.444> <0.176, 0.858, -5.451> <0.190, 0.757, -5.471> <0.220, 0.698, -5.483> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.224, 0.898, -8.074> <0.200, 0.681, -8.105> <0.084, 0.407, -8.137> <0.024, 0.197, -8.164> 
		<0.224, 0.819, -7.298> <0.200, 0.602, -7.330> <0.084, 0.329, -7.342> <0.024, 0.119, -7.369> 
		<0.220, 0.749, -6.261> <0.160, 0.544, -6.269> <0.080, 0.263, -6.298> <0.020, 0.058, -6.306> 
		<0.220, 0.698, -5.483> <0.160, 0.493, -5.491> <0.080, 0.220, -5.501> <0.020, 0.016, -5.508> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.024, 0.197, -8.164> <-0.036, 0.407, -8.137> <-0.116, 0.688, -8.101> <-0.176, 0.898, -8.074> 
		<0.024, 0.119, -7.369> <-0.036, 0.329, -7.342> <-0.116, 0.609, -7.325> <-0.176, 0.819, -7.298> 
		<0.020, 0.058, -6.306> <-0.040, 0.263, -6.298> <-0.120, 0.544, -6.269> <-0.180, 0.749, -6.261> 
		<0.020, 0.016, -5.508> <-0.040, 0.220, -5.501> <-0.120, 0.493, -5.491> <-0.180, 0.698, -5.483> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.176, 0.898, -8.074> <-0.146, 0.956, -8.062> <-0.106, 1.035, -8.047> <-0.076, 1.094, -8.035> 
		<-0.176, 0.819, -7.298> <-0.146, 0.878, -7.287> <-0.107, 0.958, -7.271> <-0.077, 1.017, -7.259> 
		<-0.180, 0.749, -6.261> <-0.150, 0.808, -6.249> <-0.110, 0.886, -6.234> <-0.080, 0.945, -6.222> 
		<-0.180, 0.698, -5.483> <-0.150, 0.757, -5.471> <-0.110, 0.836, -5.456> <-0.080, 0.894, -5.444> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.894, -5.444> <-0.081, 0.847, -4.711> <-0.080, 0.791, -3.734> <-0.080, 0.765, -3.000> 
		<-0.080, 0.894, -5.444> <-0.081, 0.847, -4.711> <-0.080, 0.791, -3.734> <-0.080, 0.765, -3.000> 
		<-0.080, 0.894, -5.444> <-0.081, 0.847, -4.711> <-0.080, 0.791, -3.734> <-0.080, 0.765, -3.000> 
		<-0.080, 0.894, -5.444> <-0.081, 0.847, -4.711> <-0.080, 0.791, -3.734> <-0.080, 0.765, -3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.894, -5.444> <-0.020, 0.894, -5.444> <0.070, 0.927, -5.437> <0.120, 0.894, -5.444> 
		<-0.081, 0.847, -4.711> <-0.021, 0.847, -4.711> <0.069, 0.879, -4.705> <0.119, 0.847, -4.711> 
		<-0.080, 0.791, -3.734> <-0.020, 0.791, -3.734> <0.070, 0.824, -3.727> <0.120, 0.791, -3.734> 
		<-0.080, 0.765, -3.000> <-0.020, 0.765, -3.000> <0.070, 0.798, -2.993> <0.120, 0.765, -3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 0.894, -5.444> <0.176, 0.858, -5.451> <0.190, 0.757, -5.471> <0.220, 0.698, -5.483> 
		<0.119, 0.847, -4.711> <0.175, 0.810, -4.718> <0.189, 0.709, -4.739> <0.219, 0.650, -4.750> 
		<0.120, 0.791, -3.734> <0.176, 0.755, -3.741> <0.190, 0.655, -3.761> <0.220, 0.596, -3.773> 
		<0.120, 0.765, -3.000> <0.176, 0.729, -3.007> <0.190, 0.628, -3.027> <0.220, 0.569, -3.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.220, 0.698, -5.483> <0.160, 0.493, -5.491> <0.080, 0.220, -5.501> <0.020, 0.016, -5.508> 
		<0.219, 0.650, -4.750> <0.159, 0.446, -4.758> <0.079, 0.182, -4.784> <0.019, -0.023, -4.791> 
		<0.220, 0.596, -3.773> <0.160, 0.403, -3.796> <0.080, 0.144, -3.811> <0.020, -0.049, -3.834> 
		<0.220, 0.569, -3.039> <0.160, 0.376, -3.063> <0.080, 0.120, -3.094> <0.020, -0.073, -3.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, 0.016, -5.508> <-0.040, 0.220, -5.501> <-0.120, 0.493, -5.491> <-0.180, 0.698, -5.483> 
		<0.019, -0.023, -4.791> <-0.041, 0.182, -4.784> <-0.121, 0.446, -4.758> <-0.181, 0.650, -4.750> 
		<0.020, -0.049, -3.834> <-0.040, 0.144, -3.811> <-0.120, 0.403, -3.796> <-0.180, 0.596, -3.773> 
		<0.020, -0.073, -3.117> <-0.040, 0.120, -3.094> <-0.120, 0.376, -3.063> <-0.180, 0.569, -3.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.180, 0.698, -5.483> <-0.150, 0.757, -5.471> <-0.110, 0.836, -5.456> <-0.080, 0.894, -5.444> 
		<-0.181, 0.650, -4.750> <-0.151, 0.709, -4.739> <-0.111, 0.788, -4.723> <-0.081, 0.847, -4.711> 
		<-0.180, 0.596, -3.773> <-0.150, 0.655, -3.761> <-0.110, 0.732, -3.745> <-0.080, 0.791, -3.734> 
		<-0.180, 0.569, -3.039> <-0.150, 0.628, -3.027> <-0.110, 0.706, -3.012> <-0.080, 0.765, -3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.702, -0.061> <-0.080, 0.702, -0.061> <-0.080, 0.702, -0.061> <-0.080, 0.702, -0.061> 
		<-0.080, 0.721, -0.943> <-0.080, 0.721, -0.943> <-0.080, 0.721, -0.943> <-0.080, 0.721, -0.943> 
		<-0.080, 0.734, -2.119> <-0.080, 0.734, -2.119> <-0.080, 0.734, -2.119> <-0.080, 0.734, -2.119> 
		<-0.080, 0.765, -3.000> <-0.080, 0.765, -3.000> <-0.080, 0.765, -3.000> <-0.080, 0.765, -3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.702, -0.061> <-0.080, 0.721, -0.943> <-0.080, 0.734, -2.119> <-0.080, 0.765, -3.000> 
		<-0.020, 0.702, -0.061> <-0.020, 0.721, -0.943> <-0.020, 0.734, -2.119> <-0.020, 0.765, -3.000> 
		<0.070, 0.736, -0.060> <0.070, 0.755, -0.941> <0.070, 0.766, -2.112> <0.070, 0.798, -2.993> 
		<0.120, 0.702, -0.061> <0.120, 0.721, -0.943> <0.120, 0.734, -2.119> <0.120, 0.765, -3.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.120, 0.702, -0.061> <0.120, 0.721, -0.943> <0.120, 0.734, -2.119> <0.120, 0.765, -3.000> 
		<0.176, 0.665, -0.063> <0.176, 0.683, -0.945> <0.176, 0.697, -2.126> <0.176, 0.729, -3.007> 
		<0.190, 0.561, -0.068> <0.190, 0.582, -0.959> <0.190, 0.595, -2.137> <0.190, 0.628, -3.027> 
		<0.220, 0.500, -0.071> <0.220, 0.521, -0.962> <0.220, 0.536, -2.149> <0.220, 0.569, -3.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.220, 0.500, -0.071> <0.220, 0.521, -0.962> <0.220, 0.536, -2.149> <0.220, 0.569, -3.039> 
		<0.160, 0.299, -0.051> <0.160, 0.320, -0.941> <0.160, 0.344, -2.173> <0.160, 0.376, -3.063> 
		<0.080, 0.031, -0.024> <0.080, 0.060, -0.958> <0.080, 0.088, -2.160> <0.080, 0.120, -3.094> 
		<0.020, -0.171, -0.003> <0.020, -0.141, -0.937> <0.020, -0.104, -2.183> <0.020, -0.073, -3.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.020, -0.171, -0.003> <0.020, -0.141, -0.937> <0.020, -0.104, -2.183> <0.020, -0.073, -3.117> 
		<-0.040, 0.031, -0.024> <-0.040, 0.060, -0.958> <-0.040, 0.088, -2.160> <-0.040, 0.120, -3.094> 
		<-0.120, 0.299, -0.051> <-0.120, 0.320, -0.941> <-0.120, 0.344, -2.173> <-0.120, 0.376, -3.063> 
		<-0.180, 0.500, -0.071> <-0.180, 0.521, -0.962> <-0.180, 0.536, -2.149> <-0.180, 0.569, -3.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.180, 0.500, -0.071> <-0.180, 0.521, -0.962> <-0.180, 0.536, -2.149> <-0.180, 0.569, -3.039> 
		<-0.150, 0.561, -0.068> <-0.150, 0.582, -0.959> <-0.150, 0.595, -2.137> <-0.150, 0.628, -3.027> 
		<-0.110, 0.642, -0.064> <-0.110, 0.661, -0.946> <-0.110, 0.675, -2.131> <-0.110, 0.706, -3.012> 
		<-0.080, 0.702, -0.061> <-0.080, 0.721, -0.943> <-0.080, 0.734, -2.119> <-0.080, 0.765, -3.000> 
	}
  }
  
#declare Leatherguard=  
  union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.068, 0.728, -0.877> <-0.071, 0.723, -0.626> <-0.075, 0.715, -0.290> <-0.078, 0.710, -0.039> 
		<-0.130, 0.686, -0.877> <-0.133, 0.680, -0.626> <-0.132, 0.674, -0.293> <-0.135, 0.668, -0.041> 
		<-0.205, 0.590, -0.870> <-0.199, 0.584, -0.624> <-0.192, 0.573, -0.295> <-0.186, 0.568, -0.049> 
		<-0.197, 0.515, -0.872> <-0.192, 0.510, -0.626> <-0.184, 0.503, -0.298> <-0.178, 0.498, -0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.068, 0.728, -0.877> <-0.130, 0.686, -0.877> <-0.205, 0.590, -0.870> <-0.197, 0.515, -0.872> 
		<-0.022, 0.760, -0.877> <-0.084, 0.717, -0.877> <-0.075, 0.596, -0.876> <-0.068, 0.521, -0.878> 
		<0.071, 0.762, -0.869> <0.129, 0.725, -0.872> <0.113, 0.598, -0.885> <0.105, 0.529, -0.887> 
		<0.118, 0.732, -0.872> <0.176, 0.695, -0.875> <0.243, 0.604, -0.891> <0.235, 0.535, -0.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.068, 0.728, -0.877> <-0.022, 0.760, -0.877> <0.071, 0.762, -0.869> <0.118, 0.732, -0.872> 
		<-0.071, 0.723, -0.626> <-0.025, 0.754, -0.626> <0.071, 0.757, -0.619> <0.119, 0.727, -0.622> 
		<-0.075, 0.715, -0.290> <-0.027, 0.750, -0.288> <0.069, 0.752, -0.287> <0.120, 0.720, -0.289> 
		<-0.078, 0.710, -0.039> <-0.030, 0.745, -0.037> <0.070, 0.747, -0.037> <0.121, 0.715, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.118, 0.732, -0.872> <0.176, 0.695, -0.875> <0.243, 0.604, -0.891> <0.235, 0.535, -0.893> 
		<0.119, 0.727, -0.622> <0.177, 0.690, -0.625> <0.242, 0.599, -0.637> <0.235, 0.530, -0.639> 
		<0.120, 0.720, -0.289> <0.178, 0.684, -0.290> <0.242, 0.591, -0.298> <0.234, 0.523, -0.300> 
		<0.121, 0.715, -0.039> <0.179, 0.679, -0.040> <0.242, 0.585, -0.044> <0.234, 0.517, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, -0.197, -0.900> <0.019, -0.197, -0.900> <0.019, -0.197, -0.900> <0.019, -0.197, -0.900> 
		<-0.046, 0.017, -0.892> <0.019, 0.236, -0.890> <0.019, 0.236, -0.890> <0.084, 0.023, -0.898> 
		<-0.176, 0.293, -0.877> <-0.047, 0.299, -0.884> <0.081, 0.302, -0.894> <0.211, 0.308, -0.900> 
		<-0.197, 0.515, -0.872> <-0.068, 0.521, -0.878> <0.105, 0.529, -0.887> <0.235, 0.535, -0.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, -0.197, -0.900> <0.019, -0.201, -0.652> <0.019, -0.206, -0.320> <0.019, -0.210, -0.072> 
		<0.084, 0.023, -0.898> <0.084, 0.019, -0.650> <0.083, 0.012, -0.313> <0.083, 0.008, -0.064> 
		<0.211, 0.308, -0.900> <0.211, 0.302, -0.646> <0.210, 0.296, -0.309> <0.209, 0.291, -0.055> 
		<0.235, 0.535, -0.893> <0.235, 0.530, -0.639> <0.234, 0.523, -0.300> <0.234, 0.517, -0.046> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.019, -0.197, -0.900> <-0.046, 0.017, -0.892> <-0.176, 0.293, -0.877> <-0.197, 0.515, -0.872> 
		<0.019, -0.201, -0.652> <-0.046, 0.013, -0.643> <-0.171, 0.288, -0.631> <-0.192, 0.510, -0.626> 
		<0.019, -0.206, -0.320> <-0.040, 0.007, -0.314> <-0.161, 0.284, -0.305> <-0.184, 0.503, -0.298> 
		<0.019, -0.210, -0.072> <-0.040, 0.003, -0.066> <-0.156, 0.279, -0.059> <-0.178, 0.498, -0.051> 
	}
	texture {Leather2}
   }                                                           

// try an intersection of this and a heightfield to get the pattern.      
#declare Guard=
 intersection {
  union {
   cylinder {
    <0,0,0>,<0,0,0.1>,0.6
    scale <0.9,1,1>  
    translate y*0.1
   }
   torus {
    0.6,0.05 
    rotate x*-90
    scale <0.9,1,1>
    translate <0,0.1,0.05>
   }
  }
 height_field {
   gif "guard.gif"
   translate <-0.5,0,-0.5>
   scale <1.25,0.3,1.35>
   rotate x*-90    
   translate <0.03,0.09,0.22> 
   smooth
   water_level 0.1
  } 
  texture {T_Chrome_1C}
 } 
          
#declare CutOut=
 box {
  <-0.13,-0.13,-0.3>,<0.13,0.13,0.3>
  rotate z*45
  scale <0.4,1,1>
  //rotate z*-45     
  translate y*0.1
 }

#declare Hilt=
 union {
  cylinder {
   <0.1,0.1,0>,<2.1,0.1,0>,0.18
   texture {
    crackle
     texture_map {
      [0 pigment {rgb <0,0,0>}]
      [0.2 pigment {rgb <0,0,0>}]
      [0.2 T_Gold_3D]
      [1.0 T_Gold_3D]
     }
    scale 0.03
   }
  }
  cylinder {
   <2.09,0.1,0>,<2.3,0.1,0>,0.21
   texture {T_Chrome_1C}
  }
  difference { 
   cylinder {
    <0.1,0.1,0>,<2.1,0.1,0>,0.19    
   }
   union {
    object {CutOut translate x*0.38}
    object {CutOut translate x*0.67}
    object {CutOut translate x*0.96}
    object {CutOut translate x*1.24}
    object {CutOut translate x*1.53}
    object {CutOut translate x*1.81}
   }
   pigment {rgb <0,0,0>}
  }
  scale <1,1,0.8>
 }
            
#declare Wakizashi=
 union {
  object {Blade   
          texture {T_Chrome_4D}                  
          scale  <0.5,0.4,0.5>
          rotate y*90
          translate y*-0.03  
         }   
  object {Blade   
          rotate y*90
          texture {Blood translate <10.8,0,0>}                  
          scale  <0.502,0.402,0.502>
          translate y*-0.03  
         }         
  object {Leatherguard 
          scale  <0.5,0.4,0.5>
          rotate y*90
          translate y*-0.03
         }
  object {Guard rotate y*-90}
  object {Hilt}
 }
 /*
object {Wakizashi scale 0.3 translate x*0.2}

box {
 <-1.5,-1,0>,<1.5,-1.1,0.1>
 pigment {rgb <1,0,0>}
}
                  
background {rgb <0.6,0.6,1> }     

plane {
 z,-10
 pigment {rgb <1,1,1>}
 hollow 
 no_shadow
}             
                  
camera {SwordCamera}               
                                                                   
light_source { < 0, 100, -200 > color rgb <1, 1, 1> }
light_source { < 200, 10, 0 > color rgb <0.4, 0.5, 0.4> }
light_source { < -10, 100, 200 > color rgb <1,1,1> }

   */                                                              