// Persistence of Vision Ray Tracer Scene Description File
// File: CD.inc
// Vers: 3.1
// Desc: Very basic CD-Rom and CD Box. No refraction colors on the cd.
// Date: 
// Auth: 

#declare BasicCD=
 difference {
  cylinder {
   <0,0,0>,<0,0.002,0>,0.6
  }
  cylinder {
   <0,-0.01,0>,<0,0.01,0>,0.15
  } 
  texture {T_Silver_4C}
 }

#declare CDBoxTop=
 union {
  box {
   <0.12,0.08,0>,<1.42,0.1,1.23>
  }
  box {
   <0,0,0>,<1.42,0.11,0.01>
  }
  box {
   <0,0,1.22>,<1.42,0.11,1.23>
  }
  box {
   <0.13,0.06,0>,<0.14,0.1,1.23>
  }
  texture {Glass2}
 }
  
#declare CDBoxBottom=
 union {
  box {
   <0,0,0>,<1.42,0.02,1.23>
  }
  box {
   <1.41,0,0>,<1.42,0.11,1.23>
  }
  box {
   <0,0,0.015>,<1.42,0.11,0.025>
  }
  box {
   <0,0,1.205>,<1.42,0.11,1.215>
  }
  box {
   <0,0,0>,<0.01,0.11,1.23>
  }
  texture {Glass2}
 }  

#declare CDTray=
 union {
  box {
   <0,0.11,0.015>,<0.12,0.12,1.215>
  }
  box {
   <0.12,0.04,0.015>,<0.1,0.12,1.215>
  }
  difference {
   box {
    <0.12,0.02,0.015>,<1.41,0.05,1.215>
   }
   cylinder {
    <0.75,0.021,0.61>,<0.75,0.06,0.61>,0.62
   }
   cylinder {
    <0.75,0.01,0.61>,<0.75,0.06,0.61>,0.04
   }
  }
  difference {
   cylinder {
    <0.75,0.02,0.61>,<0.75,0.05,0.61>,0.08
   }
   cylinder {
    <0.75,0.01,0.61>,<0.75,0.06,0.61>,0.04
   } 
  }
 pigment {Gray25}
}
                 
#macro CDBox(CDFront,CDSide)
 union {
  object {CDBoxBottom}
  object {CDBoxTop}
  object {CDTray}
  box {
   <0,0,0>,<1,1,0.0005>
   pigment {CDFront}
   scale <1.2,1.2,1>
   rotate x*90
   translate <0.12,0.1,0.01>
  }
  box {            
   <0,0,0>,<1,1,0.0005>
   pigment {CDSide}    
   scale <1.2,0.08,1>
   rotate y*90
   translate <0.03,0.01,1.22>
  }
 }
#end