// Persistence of Vision Ray Tracer Scene Description File
// File: deskobj.inc
// Vers: 3.1
// Desc: Desk objects for deadline.pov
// Date: 
// Auth: 

#declare LeaverFile=
 union {
  box {
   <0,0,0>,<2.8,0.05,3.2>
  }
  box {
   <0,0,0>,<0.05,0.8,3.2>
   rotate z*-5
  }
  box {
   <-0.001,0.1,1>,<0.01,0.7,3>
   pigment {White}
   rotate z*-5
  }
  box {
   <0,0,0>,<2.8,0.05,3.2>
   rotate z*-8
   translate <0.08,0.79,0>
  }
  box {
   <0.45,0.04,1.5>,<2.33,0.051,2.7>
   pigment {White}
   rotate z*-8
   translate <0.08,0.79,0>
  }
  text {ttf "timesbd.ttf" "WebSite" , 0.1,0
        scale 0.45
        rotate x*90
        rotate z*-8
        translate <0.65,0.77,2.3>
        pigment {Black}
       }
  text {ttf "timesbd.ttf" "Notes & Bugs" , 0.1,0
        scale 0.3
        rotate x*90
        rotate z*-8
        translate <0.6,0.785,1.8>
        pigment {Black}
       }
  box {  // papers in file. Need better texture!!!
   <0.4,0.05,0.1>,<2.6,0.39,3.1>
   //pigment {White}
   texture {
    PageTex
    rotate x*-90
    scale 0.1
   }
  }
  box {
   <0.4,0.3999,0.1>,<2.6,0.4001,3.1>
   pigment {rgb<0.919, 0.833, 0.669>*1.5}
  }
  box {  
   <0.38,0.15,0.08>,<2.63,0.16,3.1>
   pigment {DeepPink}
  } 
  box {  
   <0.38,0.35,0.08>,<2.63,0.36,3.1>
   pigment {Crimson}
  }
  pigment {Tomato}
  finish {
   specular 0.8
   roughness 0.004
  }
 }
 
 #declare PenHolder=
 union {
  difference {
   cylinder {
    <0,0,0>,<0,1,0>,0.5
   }         
   cylinder {
    <0,0.05,0>,<0,1.6,0>,0.4
   }
  }
  torus {
   0.45,0.05
  }
  torus {
   0.45,0.05
   translate y*1
  }
  texture { T_Wood10 rotate x*90 scale 0.1}
  translate <-0.5,0,1>
 }

#declare PizzaBox=
 union {
  box {
   <0.07,0.1,0.07>,<2.23,0.5,2.3>  
   pigment {
    image_map {
     gif "PizzaTop.gif"
    }          
    rotate x*90
    scale <2.3,1,2.3>
   }
  }
  box {
   <0,0,0>,<2.3,0.5,0.05> 
   pigment {
    image_map {
     gif "PizzaFront.gif"
    }          
    scale <2.3,0.5,1>
   }
  }
  box {
   <0,0,0>,<0.05,0.5,2.3> 
   pigment {
    image_map {
     gif "PizzaSide.gif"
    }          
    rotate y*-90
    scale <1,0.5,2.3>
   }
  }
  box {
   <2.25,0,0>,<2.3,0.5,2.3>
  }
  pigment {White}
 }     

#declare PaperHolder=
 difference {
  box {
   <-0.5,0,-0.5>,<0.5,0.35,0.5>
  }
  union {
   box {
    <-0.45,0.05,-0.45>,<0.45,0.4,0.45>
   }
   box {
    <-0.15,0.25,-0.55>,<0.15,0.4,-0.4>
   }
   #declare Decor1=0;
   #while (Decor1<9)
    box {
     <-0.025,-0.025,-0.55>,<0.025,0.025,0.55>
     rotate z*45
     translate <-0.4+Decor1*0.1,0.1,0>
    }  
    box {
     <-0.025,-0.025,-0.55>,<0.025,0.025,0.55>
     rotate z*45
     translate <-0.4+Decor1*0.1,0.2,0>
    }
    box {
     <-0.55,-0.025,-0.025>,<0.55,0.025,0.025>
     rotate x*45
     translate <0,0.1,-0.4+Decor1*0.1>
    }       
    box {
     <-0.55,-0.025,-0.025>,<0.55,0.025,0.025>
     rotate x*45
     translate <0,0.2,-0.4+Decor1*0.1>
    }                       
    #declare Decor1=Decor1+1;
   #end
  }
  texture {T_Wood2 scale 0.1}
 }
  
#declare PaperBlock=
 union {
  box {
   <-0.45,0.19,-0.45>,<0.45,0.23,0.45>
   pigment {HotPink}
  }
  box {
   <-0.45,0.11,-0.45>,<0.45,0.19,0.45>
   pigment {Plum2}
  }
  box {
   <-0.45,0.05,-0.45>,<0.45,0.11,0.45>
   pigment {SkyBlue}
  }
 }

#declare Pencil=
 union {
  object {Hexagon
          scale <2,0.1,0.1>
         }
  intersection {
   cone {<1.95,0,0>, 0.12, <2.45,0,0>, 0 }
   object {Hexagon
          scale <2,0.1,0.1>
          translate x*2
         }
   texture {T_Wood10}
  }
  cone {
   <2.46,0,0>,0,<2.3,0,0>,0.0365
   pigment { rgb <0.15,0.15,0.15> }
   finish {phong 1 phong_size 230}
  }
 }

 
#declare QuarterTorus=
 intersection {
  torus { 1, 0.3 }
  box { <0,-2,0>,<2,2,2> }
 }

#declare Handle=
 union {
  object {QuarterTorus
          scale 5
          rotate x*-90
          translate y*2.5
         }
  object {QuarterTorus
          scale 5
          rotate x*90
          translate y*-2.5
         }
  cylinder { <5,-2.5,0>,<5,2.5,0>,1.5 }
  //pigment {White}
 }

#ifndef (Level)  // level is percentage of cup full.
  #declare Level=0;
#end

#macro cup(Level,CupTex,AllTex,ContentsTex)
 union {
  difference {
   cylinder { <0,0,0>,<0,20,0>,10 }
   cylinder { <0,3,0>,<0,30,0>,8 }
   pigment {CupTex}
  }
  torus { 9,1}
  torus {9,1.05
         translate <0,20,0>
        }
  object {Handle
          translate <9.99,9.5,0>
         }
  cylinder {
   <0,2.5,0>,<0,15.7*Level+2.9,0>,8.5
   texture {ContentsTex}
  }
  pigment {AllTex}
 }
#end
 
#declare Clock=
 union {
  difference {
   superellipsoid { 
    <0.3,0.3> 
    scale <1,0.25,0.6>
   }                  
   superellipsoid {
    <0.2,0.2>
    scale <0.75,0.18,0.3>
    pigment {Black}
    pigment {
     image_map {
      gif "clock.gif"
     }
     scale <1.5,0.36,1>
     translate <0.75,0.18,0>
    }
    finish {ambient 0.8}
    translate <0.1,0,-0.8>
   }              
  }
  sphere {
   <-0.85,-0.3,-0.2>,0.05
  }
  sphere {
   <0.85,-0.3,-0.2>,0.05
  }
  sphere {
   <0,0,0>,0.15
   scale <1.5,0.25,1>
   translate <-0.6,0.25,-0.15>
  }
  sphere {
   <0,0,0>,0.15
   scale <1,0.25,1>
   translate <-0.2,0.25,-0.15>
  }
  sphere {
   <0,0,0>,0.15
   scale <1,0.25,1>
   translate <0.1,0.25,-0.15>
  }
  pigment {Gray20}
  translate y*0.25
 }
 
#declare spoon=
 union {
  difference {
   sphere {
    <0,0,0>,0.12    
    scale <2,0.4,1>  
    rotate z*-5
   } 
   sphere {
    <0,0,0>,0.11
    scale <2,0.4,1>  
    rotate z*-5
   }              
   box {
    <-0.3,0,-0.2>,<0.2,0.2,0.2>
   }
  }                              
  intersection {
   /*sphere {
    <0,0,0>,0.05
    scale <15,1,0.6>
   }   */       
   sphere_sweep {
    b_spline_sphere_sweep
    9               
    <-0.5,0,0>,0.12
    <-0.45,0,0>,0.075,
    <-0.4,0,0>,0.05,
    <-0.35,0,0>,0.03,
    <-0.2,0,0>,0.03,
    <0,0,0>,0.04,
    <0.2,0,0>,0.045,
    <0.55,0,0>,0.05,
    <0.65,0,0>,0.055
   }      
   difference {
    box {
     <-0.45,-0.01,-0.09>,<0.6,0.01,0.09>
    }         
    cylinder {
     <-0.45,-0.02,0>,<-0.45,0.02,0>,0.07
    }
   }
   translate x*0.4
   rotate z*8
   translate <0.21,-0.01,0>
  }   
  texture {T_Silver_3D} 
  translate x*-0.3
 }