
#include "colors.inc"
#include "textures.inc"

/*******************************************************************/

camera
{
  location <-1.0, 0.01, -3.0>
  look_at <0.0, 6.0, 0.0>
}

/*camera
{
  location <0.0, 5.0, -20.0>
  look_at <0.0, 5.0, 0.0>
}*/

light_source
{
  <-2.0, 20.0, -10.0>
  color rgb <2.0, 2.0, 4.0>
  spotlight
  point_at <0.0, 7.5, 0.0>
  radius 10.0
  tightness 50
  falloff 15.0
}

light_source
{
  <0.0, 2.0, 0.0>
  color rgb <2.5, 2.5, 0.0>
  spotlight
  point_at <19.0, 40.0, 15.0>
  radius 18.0
  tightness 50
  falloff 20.0
  fade_distance 20.0
  fade_power 1.0
}


/*******************************************************************/

sky_sphere
{
  pigment
  {
    gradient y
    color_map
    {
      [ 0.0 color Gray ]
      [ 0.025 color Gray ]
      [ 0.5 color Black ]
      [ 0.975 color Gray ]
      [ 1.0 color Gray ]
    }
    turbulence 1.1
    scale 1.0
    rotate -135.0*y
  }
}

/*******************************************************************/

#declare T_Etincelles = texture
{
  pigment { White }
  finish { ambient <3.0, 1.5, 0.0> }
}

#declare T_Eclair = texture
{
  pigment { White }
  finish { ambient <2.0, 2.0, 3.0> }
}

#declare T_Loupiotte1 = texture
{
  pigment { rgbt <1.0, 1.0, 0.0, 0.2> }
  finish { reflection 0.4 ambient 0.6 diffuse 0.5 }
}

#declare T_Loupiotte2 = texture
{
  pigment { rgbt <0.0, 2.0, 0.0, 0.2> }
  finish { reflection 0.4 ambient 0.6 diffuse 0.5 }
}

#declare T_Loupiotte3 = texture
{
  pigment { rgbt <3.0, 0.0, 0.0, 0.2> }
  finish { reflection 0.4 ambient 0.6 diffuse 0.5 }
}

#declare T_Pancarte = texture
{
  pigment { rgbt <1.0, 0.0, 1.0, 0.1> }
  finish { reflection 0.2 phong 0.2 phong_size 0.2 ambient 0.4 }
}

#declare T_Paille = texture
{
  pigment
  {
    spiral1 1
    color_map
    {
      [ 0.0 White ]
      [ 0.25 Green ]
      [ 0.5 White ]
      [ 1.0 Yellow ]
    }
  }
  finish { reflection 0.1 phong 0.1 phong_size 1.0 ambient 0.3 }
}

#declare T_Eau = texture
{
  pigment { rgbt <1.0, 1.0, 1.0, 0.8> }
  finish { caustics 0.6 diffuse 0.4 reflection 0.6 refraction 1.1 ior 1.45 ambient 0.05 }
}

#declare T_Plastique = texture
{
  pigment { rgbt <1.0, 1.0, 1.0, 0.4> }
  finish { reflection 0.01 phong 0.5 phong_size 1.5 }
  normal { crackle 0.1 }
}

#declare T_Carton = texture
{
  pigment
  {
    image_map
    {
      tga "e:\raytra~1\scripts\mcdo\logosoda.tga"
      map_type 2
    }
    scale <1.0, 7.0, 1.0>
    translate 2.7*y
    rotate -40.0*y
  }
  finish { reflection 0.02 ambient 0.3 }
  normal { granite 0.1 scale 10.0 }
}

#declare T_Pluie = texture
{
  pigment { rgb <0.5, 0.5, 0.5> }
  finish { ambient 1.5 }
}

#declare T_Pique = texture
{
  pigment { rgbt <1.5, 1.0, 0.0, 0.5> }
  finish { caustics 0.6 diffuse 0.4 reflection 0.6 refraction 1.1 ior 1.45 ambient 0.2 }
}

#declare T_Sang = texture
{
  pigment { rgbt <1.0, 0.0, 0.0, 0.4> }
  finish { reflection 0.3 }
}

#declare T_Pain = texture
{
  pigment { rgb <1.0, 0.7, 0.3> }
  normal { bumps 0.5 }
  finish { reflection 0.1 }
}

#declare T_Steak = texture
{
  pigment { rgb <1.0, 1.0, 0.1> }
  normal { agate 0.5 }
}

#declare T_Sol = texture
{
  pigment { Gray }
}

#declare T_Armature = texture
{
  pigment { rgb <0.4, 0.4, 0.4> }
  finish { reflection 0.1 phong 0.15 phong_size 0.3 metallic }
  normal { dents 0.8 scale 0.2 }
}

#declare T_Pub = texture
{
  pigment { rgbt <3.0, 0.0, 0.0, 0.1> }
  finish { reflection 0.2 phong 0.2 phong_size 0.2 ambient 0.4 }
}

#declare T_Pub2 = texture
{
  pigment { rgbt <3.0, 0.0, 0.0, 0.1> }
  finish { reflection 0.5 ambient 0.4 }
}

#declare T_Texte = texture
{
  pigment { rgbt <1.5, 1.5, 0.0, 0.1> }
  finish { reflection 0.2 phong 0.2 phong_size 0.2 ambient 0.4 }
}

#declare T_Lame = texture
{
  pigment { rgb <0.5, 0.5, 0.52> }
  finish { reflection 0.8 metallic phong 0.2 phong_size 0.5 }
  normal { crackle 0.05 scale 0.8 }
}

#declare T_Tourbillon = texture
{
  pigment
  {
    gradient y
    color_map
    {
      [ 0.0 color rgbt <0.2, 0.21, 0.2, 0.9> ]
      [ 0.5 color rgbt <1.0, 1.0, 1.0, 1.0> ]
      [ 1.0 color rgbt <0.2, 0.21, 0.2, 0.9> ]
    }
    scale 1.0
  }
  normal { bumps 0.3 }
  finish { reflection 0.1 }
}

/*******************************************************************/

#declare Sol = box
{
  <-20.0, 0.000001, -20.0>
  <20.0, -0.5, 20.0>
  texture { T_Sol }
}

#declare Guillotine = merge
{
  difference
  {
    merge
    {
      cylinder
      {
        <-1.0, 0.0, 0.0>
        <-1.0, 10.0, 0.0>
        0.08
      }
      cylinder
      {
        <1.0, 0.0, 0.0>
        <1.0, 10.0, 0.0>
        0.08
      }
      box
      {
        <-1.1, 3.0, -0.1>
        <1.1, 3.2, 0.1>
      }
      box
      {
        <-1.1, 6.7, -0.1>
        <1.1, 6.9, 0.1>
      }
      box
      {
        <-1.1, 9.0, -0.1>
        <1.1, 9.2, 0.1>
      }
    }
    box
    {
      <-1.0, -1.0, -0.05>
      <1.0, 11.0, 0.05>
    }
    texture { T_Armature }
  }
  superellipsoid
  {
    <0.3, 0.2>
    scale <1.7, 1.2, 0.15>
    texture { T_Pub }
    translate 10.5*y
  }
  superellipsoid
  {
    <0.3, 0.2>
    scale <1.7, 0.3, 0.15>
    texture { T_Pub }
    translate 8.5*y
  }
  text
  {
    ttf "c:\WINDOWS\FONTS\ARIAL.TTF"
    "DEATH DRIVE"
    0.1, 0.0
    texture { T_Texte }
    scale 1.0/2.5
    translate <-1.29, 8.38, -0.2>
  }
  text
  {
    ttf "c:\WINDOWS\FONTS\COMIC.TTF"
    "BEURK"
    0.1, 0.0
    texture { T_Texte }
    translate <-1.53, 10.4, -0.2>
  }
  text
  {
    ttf "c:\WINDOWS\FONTS\COMIC.TTF"
    "FAST FOOD"
    0.1, 0.0
    texture { T_Texte }
    scale 1.0/2.0
    translate <-1.39, 9.7, -0.2>
  }
}

#declare Lame = difference
{
  box
  {
    <-1.0, 0.0, -0.05>
    <1.0, 1.8, 0.05>
  }
  box
  {
    <-5.0, -1.0, -1.0>
    <5.0, 0.0, 1.0>
    rotate 30.0*z
    translate 0.5*y
  }
  box
  {
    <-5.0, -1.0, -1.0>
    <5.0, 1.0, 0.0>
    rotate -10.0*x
    rotate 30.0*z
    translate 0.5*y
  }
  box
  {
    <-5.0, -1.0, 1.0>
    <5.0, 1.0, 0.0>
    rotate 10.0*x
    rotate 30.0*z
    translate 0.5*y
  }
  texture { T_Lame }
  translate 5.0*y
}

/*******************************************************************/

#declare Tourbillon = blob
{
  threshold 0.999
#declare NB = 200
#declare Count1 = 1
#declare S1 = seed(1111)
#declare S2 = seed(2222)
#declare S3 = seed(3333)
#while (Count1 <= 5)
  #declare Angle = 360.0*rand(S1)
  #declare DAngle = 10.0*rand(S2)
  #declare Offset = 20.0*rand(S3)
  #declare Count2 = 1
  #while (Count2 < NB)
    #declare XX = 120.0-120.0*(Count2-2)/(NB-1)
    #declare YY = 120.0-3.0*log(XX/2.0)+Offset
    #declare V1 = <XX+10.0, YY, 0.0>
    #declare XX = 120.0-120.0*(Count2-1)/(NB-1)
    #declare YY = 120.0-3.0*log(XX/2.0)+Offset
    #declare V2 = <XX+10.0, YY, 0.0>
    #declare V1 = vaxis_rotate(V1, y, Angle)
    #declare V2 = vaxis_rotate(V2, y, Angle+DAngle)
    cylinder
    {
      V1, V2
      11.0, 0.9
    }
    #declare Angle = Angle+DAngle
    #declare Count2 = Count2+1
  #end
  #declare Count1 = Count1+1
#end
  texture { T_Tourbillon }
  sturm
}

/*******************************************************************/

#declare Hamburger = merge
{
  merge
  {
    //1ere tranche
    cylinder
    {
      <0.0, 0.0, 0.0>
      <0.0, 0.5, 0.0>
      2.5
    }
    sphere
    {
      <0.0, 0.0, 0.0>
      2.5
      scale <1.0, 0.1, 1.0>
      translate 0.5*y
    }
    sphere
    {
      <0.0, 0.0, 0.0>
      2.5
      scale <1.0, 0.1, 1.0>
    }
    //2eme tranche
    cylinder
    {
      <0.0, 1.0, 0.0>
      <0.0, 1.5, 0.0>
      2.5
    }
    sphere
    {
      <0.0, 0.0, 0.0>
      2.5
      scale <1.0, 0.1, 1.0>
      translate 1.5*y
    }
    sphere
    {
      <0.0, 0.0, 0.0>
      2.5
      scale <1.0, 0.1, 1.0>
      translate 1.0*y
    }
    //3eme tranche
    cylinder
    {
      <0.0, 2.0, 0.0>
      <0.0, 2.5, 0.0>
      2.5
    }
    sphere
    {
      <0.0, 0.0, 0.0>
      2.5
      scale <1.0, 0.5, 1.0>
      translate 2.5*y
    }
    texture { T_Pain }
  }
  merge
  {
    //1er steak
    cylinder
    {
      <0.0, 0.5, 0.0>
      <0.0, 1.0, 0.0>
      2.4
    }
    //2eme steak
    cylinder
    {
      <0.0, 1.5, 0.0>
      <0.0, 2.0, 0.0>
      2.4
    }
    texture { T_Steak }
  }
  difference
  {
    blob
    {
      threshold 0.7
      #declare Nb_Cote = 200
      #declare Nb_Dessus = 75
      #declare S10 = seed(10000)
      #declare Count = 1.0
      #while (Count <= Nb_Cote)
        sphere
        {
          #declare Angle = 2.0*pi*rand(S10)
          #declare Hauteur = 0.25+1.75*rand(S10)
          <2.15*cos(Angle), Hauteur, 2.15*sin(Angle)>
          0.6, 1.0
        }
        #declare Count = Count+1
      #end
      #declare Count = 1.0
      #while (Count <= Nb_Dessus)
        sphere
        {
          #declare Angle = 2.0*pi*rand(S10)
          #declare Longueur = 2.3*rand(S10)
          <Longueur*cos(Angle), 0.5*sqrt(2.3*2.3-Longueur*Longueur)+2.5, Longueur*sin(Angle)>
          0.6, 1.0
        }
        #declare Count = Count+1
      #end
      sturm
    }
    difference
    {
      cylinder
      {
        <0.0, -5.0, 0.0>
        <0.0, 5.0, 0.0>
        3.0
      }
      cylinder
      {
        <0.0, -5.0, 0.0>
        <0.0, 5.0, 0.0>
        2.6
      }
    }
    texture { T_Sang }
  }
  union
  {
    box
    {
      <-0.1, 0.0, -0.1>
      <0.1, 5.5, 0.1>
    }
    box
    {
      <-0.2, -0.2, -0.1>
      <0.2, 0.2, 0.1>
      translate 5.5*y
    }
    cylinder
    {
      <-0.3, 0.4, -0.2>
      <-0.3, 0.4, 0.2>
      0.2
      translate 5.5*y
    }
    cylinder
    {
      <0.3, 0.4, -0.2>
      <0.3, 0.4, 0.2>
      0.2
      translate 5.5*y
    }
    box
    {
      <-0.9, -0.05, -0.05>
      <0.9, 0.05, 0.05>
      rotate 15.0*z
      translate 5.1*y
    }
    box
    {
      <-0.9, -0.05, -0.05>
      <0.9, 0.05, 0.05>
      rotate -15.0*z
      translate 5.1*y
    }
    cylinder
    {
      <0.0, 5.5, -0.01>
      <0.0, 5.5, 0.01>
      0.4
    }
    texture { T_Pique }
    rotate -10.0*y
    rotate -5.0*z
  }
  scale <0.5, 0.5, 0.5>
  translate 3.5*y
}

#declare Pied_Hamburger = merge
{
  cylinder
  {
    <0.0, 0.0, 0.0>
    <0.0, -0.15, 0.0>
    1.5
  }
  cylinder
  {
    <0.0, 0.0, 0.0>
    <0.0, -3.5, 0.0>
    0.1
  }
  texture { T_Armature }
  translate 3.5*y
}

/*******************************************************************/

#declare Soda = merge
{
  cone
  {
    <0.0, 0.0, 0.0>, 2.5
    <0.0, 9.0, 0.0>, 3.0
    texture { T_Carton }
  }
  merge
  {
    cone
    {
      <0.0, 9.1, 0.0>, 3.1
      <0.0, 9.15, 0.0>, 2.5
    }
    difference
    {
      merge
      {
        cone
        {
          <0.0, 9.1, 0.0>, 3.1
          <0.0, 8.8, 0.0>, 3.2
        }
        cylinder
        {
          <0.0, 8.8, 0.0>
          <0.0, 8.75, 0.0>
          3.22
        }
      }
      cone
      {
        <0.0, 9.1, 0.0>, 3.0
        <0.0, 8.7, 0.0>, 3.15
      }
    }
    texture { T_Plastique }
  }
  blob
  {
    threshold 0.8
    #declare Nb_Cote = 300
    #declare S12 = seed(121212)
    #declare Count = 1.0
    #while (Count <= Nb_Cote)
      sphere
      {
        #declare Angle = 2.0*pi*rand(S10)
        #declare Hauteur = 8.5*rand(S10)
        #declare Rayon = 2.5+0.5*Hauteur/8.5
        <0.99*Rayon*cos(Angle), Hauteur, 0.99*Rayon*sin(Angle)>
        0.27, 1.0
      }
      #declare Count = Count+1
    #end
    sturm
    texture { T_Eau }
  }
  cylinder
  {
    <0.0, -3.0, 0.0>
    <0.0, 5.0, 0.0>
    0.25
    texture { T_Paille }
    rotate -10.0*z
    translate 9.0*y
  }
  scale 0.5
}

/*******************************************************************/

#declare Pancarte = merge
{
  merge
  {
    sphere { <0.1, 0.5, 0.0> 0.04 }
    sphere { <0.3, 0.5, 0.0> 0.04 }
    sphere { <0.5, 0.5, 0.0> 0.04 }
    sphere { <0.7, 0.5, 0.0> 0.04 }
    sphere { <0.9, 0.5, 0.0> 0.04 }
    sphere { <1.1, 0.5, 0.0> 0.04 }
    sphere { <1.3, 0.5, 0.0> 0.04 }
    sphere { <1.5, 0.5, 0.0> 0.04 }
    sphere { <1.7, 0.5, 0.0> 0.04 }
    sphere { <1.9, 0.5, 0.0> 0.04 }

    sphere { <2.0, 0.1, 0.0> 0.04 }
    sphere { <2.0, 0.3, 0.0> 0.04 }

    sphere { <0.2, 0.0, 0.0> 0.04 }
    sphere { <0.4, 0.0, 0.0> 0.04 }
    sphere { <0.6, 0.0, 0.0> 0.04 }
    sphere { <0.8, 0.0, 0.0> 0.04 }
    sphere { <1.0, 0.0, 0.0> 0.04 }
    sphere { <1.2, 0.0, 0.0> 0.04 }
    sphere { <1.4, 0.0, 0.0> 0.04 }
    sphere { <1.6, 0.0, 0.0> 0.04 }
    sphere { <1.8, 0.0, 0.0> 0.04 }

    sphere { <0.0, 0.1, 0.0> 0.04 }
    sphere { <0.0, 0.3, 0.0> 0.04 }

    texture { T_Loupiotte1 }
  }
  merge
  {
    sphere { <0.2, 0.5, 0.0> 0.04 }
    sphere { <0.4, 0.5, 0.0> 0.04 }
    sphere { <0.6, 0.5, 0.0> 0.04 }
    sphere { <0.8, 0.5, 0.0> 0.04 }
    sphere { <1.0, 0.5, 0.0> 0.04 }
    sphere { <1.2, 0.5, 0.0> 0.04 }
    sphere { <1.4, 0.5, 0.0> 0.04 }
    sphere { <1.6, 0.5, 0.0> 0.04 }
    sphere { <1.8, 0.5, 0.0> 0.04 }

    sphere { <2.0, 0.2, 0.0> 0.04 }
    sphere { <2.0, 0.4, 0.0> 0.04 }

    sphere { <0.1, 0.0, 0.0> 0.04 }
    sphere { <0.3, 0.0, 0.0> 0.04 }
    sphere { <0.5, 0.0, 0.0> 0.04 }
    sphere { <0.7, 0.0, 0.0> 0.04 }
    sphere { <0.9, 0.0, 0.0> 0.04 }
    sphere { <1.1, 0.0, 0.0> 0.04 }
    sphere { <1.3, 0.0, 0.0> 0.04 }
    sphere { <1.5, 0.0, 0.0> 0.04 }
    sphere { <1.7, 0.0, 0.0> 0.04 }
    sphere { <1.9, 0.0, 0.0> 0.04 }

    sphere { <0.0, 0.2, 0.0> 0.04 }
    sphere { <0.0, 0.4, 0.0> 0.04 }

    texture { T_Loupiotte2 }
  }
  merge
  {
    sphere { <0.0, 0.0, 0.0> 0.04 }
    sphere { <2.0, 0.0, 0.0> 0.04 }
    sphere { <0.0, 0.5, 0.0> 0.04 }
    sphere { <2.0, 0.5, 0.0> 0.04 }
    texture { T_Loupiotte3 }
  }
  merge
  {
    box
    {
      <0.0, 0.0, 0.0>
      <2.0, 0.5, 0.1>
    }
    difference
    {
      cone
      {
        <1.0, 0.2, 0.05>, 0.08
        <2.0, -1.5, 0.05>, 0.2
      }
      box
      {
        <-3.0, -3.0, 0.0>
        <3.0, 3.0, -1.0>
      }
    }
    texture { T_Pancarte }
  }
  text
  {
    ttf "c:\WINDOWS\FONTS\ARIAL.TTF"
    "TRANSGENIC COW"
    0.1, 0.0
    texture { T_Texte }
    scale 1.0/5.0
    translate <0.1-0.01, 0.2-0.01, -0.01>
  }
  translate <-3.7, 5.5, 2.2>
}

/*******************************************************************/

#declare Eclair = merge
{
  cone
  {
    <0.0, 0.0, 0.0>, 0.01
    <-2.0, 3.0, 0.0>, 0.03
  }
  cone
  {
    <-2.0, 3.0, 0.0>, 0.03
    <-3.0, 80.0, 0.0>, 0.04
  }
  cone
  {
    <-3.0, 80.0, 0.0>, 0.04
    <-3.0, 20.0, 0.0>, 0.04
  }
  cone
  {
    <-3.0, 20.0, 0.0>, 0.04
    <-5.0, 130.0, 0.0>, 0.05
  }
  cone
  {
    <-5.0, 130.0, 0.0>, 0.05
    <-11.0, 100.0, 0.0>, 0.06
  }
  scale <1.0, 0.01, 1.0>
  rotate -21.0*z
  translate <-1.7, 1.2+10.5, 0.0>
  texture { T_Eclair }
}

/*******************************************************************/

#declare Projections = merge
{
  #declare S15 = seed(15)
  #declare Count = 1
  #while (Count <= 50)
    #declare Count = Count+1
    triangle
    {
      <-1.0, 0.0, 0.0>
      <1.0, 0.0, 0.0>
      <0.0, 1.0, 0.0>
      scale 0.2*<rand(S15), rand(S15), rand(S15)>
      rotate 360.0*rand(S15)*z
      translate 0.6*rand(S15)*x
      rotate 360.0*<rand(S15), rand(S15), rand(S15)>
    }
  #end
  translate <-1.7, 1.2+10.5, 0.0>
  texture { T_Pub2 }
}

#declare Explosion = sphere
{
  <0.0, 0.0, 0.0>
  1.0
  pigment { rgbt <1.0, 1.0, 1.0, 1.0> }
  halo
  {
    emitting
    spherical_mapping
    linear
    turbulence 1.5
    color_map
    {
      [ 0.0 color rgbt <1.0, 0.0, 0.0, 1.0> ]
      [ 0.5 color rgbt <2.0, 1.0, 0.0, -1.0> ]
      [ 1.0 color rgbt <1.0, 0.0, 0.0, 1.0> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  hollow
  scale <0.7, 0.5, 0.5>
  translate <-1.7-0.3, 1.2+10.5, 0.0>
}

/*******************************************************************/

//Immeubles

#declare Nb_Immeubles = 15
#declare S21 = seed(2121121)
#declare S22 = seed(1211212)
#declare Count = 1
#while (Count <= Nb_Immeubles)
  #declare Hauteur = 150.0*(1.0+rand(S21))
  #declare Xpos = 100.0*(rand(S21)-0.5)*2.0
  #declare Zpos = 130.0*(1.0+rand(S21))
  #declare Largeur = 17.0*(1.0+rand(S21))
  box
  {
    <-Largeur/2.0, 0.0, -Largeur/2.0>
    <Largeur/2.0, Hauteur, Largeur/2.0>
    translate <Xpos, 0.0, Zpos>
    texture
    {
      pigment { rgb <0.5, 0.5, 0.5+0.3*rand(S22)> }
      finish { metallic reflection 0.1+0.2*rand(S22) ambient 0.2 }
      normal { quilted 0.2 control0 0.0 control1 0.0 scale 3.0-0.5*rand(S22) }
    }
  }
  #declare Count = Count+1
#end

/*******************************************************************/

//Etincelles

#declare Nb_Courbes = 40
#declare Nb_Etincelles = 10
#declare S20 = seed(202023)
#declare Count1 = 1
#while (Count1 <= Nb_Courbes)
  #declare Angle = 45.0+235.0*rand(S20)
  #declare HH = 1.5*rand(S20)
  #declare LL = 2.0*rand(S20)
  #declare LM = LL+0.2*rand(S20)
  #declare Count2 = 1
  #while (Count2 <= Nb_Etincelles)
    cylinder
    {
      #declare X1 = LM*rand(S20)
      #declare X2 = X1+0.03
      #declare Y1 = 4.0*HH*X1*(1.0-X1/LL)/LL
      #declare Y2 = 4.0*HH*X2*(1.0-X2/LL)/LL
      <X1, Y1, 0.0>
      <X2, Y2, 0.0>
      0.01
      rotate Angle*y
      translate <-1.7+0.05, 1.2+10.5, 0.0>
      texture { T_Etincelles }
      no_shadow
    }
    #declare Count2 = Count2+1
  #end
  #declare Count1 = Count1+1
#end

/*******************************************************************/

//Pluie

  #declare Nb_Gouttes = 50000
  #declare Rmin = 10.0
  #declare Rmax = 60.0
  #declare Hmin = 10.0
  #declare Hmax = 110.0
  #declare Count = 1
  #declare S11 = seed(1111111)
  #while (Count <= Nb_Gouttes)
    #declare Angle = 360.0*rand(S11)
    #declare Rayon = Rmin+(Rmax-Rmin)*rand(S11)
    #declare Alti  = Hmin+(Hmax-Hmin)*rand(S11)
    cylinder
    {
      <Rayon, Alti, 0.0>
      <Rayon, Alti+0.5, 0.0>
      0.0075
      rotate Angle*y
      texture { T_Pluie }

    }
    #declare Count = Count+1
  #end

/*******************************************************************/

object { Sol }
object { Guillotine }
object { Lame }
object { Tourbillon }
object { Hamburger translate <-1.5, 0.0, 3.0> }
object { Pied_Hamburger translate <-1.5, 0.0, 3.0> }
object { Soda translate <3.9, 0.0, 1.0>}
object { Pancarte }
object { Eclair }
object { Explosion }
object { Projections }

#include "mfries.pov"
