#declare OFlamme = merge {sphere {0,1}cylinder{0,3*y,1} // flamme
 #if(area)
 light_source {-.3*y color rgb clt area_light .1*y,x,10,1 fade_distance fd fade_power 2}
 #else
 light_source {-.2*y color rgb clt fade_distance fd fade_power 2}
 #end
//cylinder {-.3*y,-.1*y,.1 pigment {color rgbf<1,0,0,0>} finish {ambient 1} no_shadow translate -2*z}
 pigment{rgbf 1}
 interior {media {
  emission rgb<1,1,0>
  absorption rgb .5
  density {spherical color_map {
   [0 rgb 0]
   [.1 rgb <1,.1,0>]
   [.2 rgb <1,.5,0>]
   [.6 rgb<1,1,0>]
   [.8 rgb 1]
  } scale <1,1.6,1> translate -.8*y turbulence <.1,.4,.1> octaves 5 lambda 5 omega 1
 } #if(area) samples 1,1e3 variance 1e-4 confidence 1-1e-4 #end // samples -> parsing
 }}
 scale <.6,2,.6>
 hollow on
}

#declare OTorche = union {
 object {OFlamme rotate rand(s)*360*y}
 union { // torche
  sphere {0,1 scale <.3,.2,.3>}
  intersection {sphere {0,.3 scale <1,14,1>} plane {y,0}}
  cylinder {0,.6*y,.4 translate -1.6*y texture {TMetal}}
  cylinder {0,3*z,.2 rotate 20*x translate -1.2*y texture {TMetal}}

  texture {TTorche rotate rand(s)*360*y}
  rotate -20*x
  translate -1.4*y
 }
}

#macro tige(l) // poignee et grille
 #declare r=.14 ;
 cylinder {2*z,.6*z,r}
 intersection {torus {.6,r rotate 90*z} box {-<1,0,1>,<1,1,0>} translate <0,-.6,.6>}
 cylinder {-.6*y,(.6-l)*y,r}
 intersection {torus {.6,r rotate 90*z} box {-<1,1,1>,<1,0,0>} translate <0,(.6-l),.6>}
 cylinder {2*z,.6*z,r translate -l*y}
#end

#declare OPorte = union { // porte
 difference {
  box {<-5,.2,-.6>,<5,13.9,.4>}
  box {<-2,0,-1>,<2,2.6,1> translate 9.4*y} // fenetre
  cylinder {-z,z,.3 translate <4,5.2,0>} // serrure
  prism {linear_spline -1,1,4, 0,<-.3,-.8>,<.3,-.8>,0 rotate -90*x translate <4,5.2,0>}
  texture {TPorte}
 }
 //box {<-.5,-1,.5>,<.5,1,1> pigment {color rgb 0} finish {diffuse 0 specular 0}} // noir de la serrure
 union {tige(3.4) translate <0,10.7+1.7,-1.4>} // grille
 union {tige(3.4) translate <-1.2,10.7+1.7,-1.4>}
 union {tige(3.4) translate <1.2,10.7+1.7,-1.4>}
 union {tige(4.8) translate 2.4*y rotate 90*z translate <0,10.7+.6,-1.4>}
 union {tige(4.8) translate 2.4*y rotate 90*z translate <0,10.7-.6,-1.4>}
 
 union {tige(2) scale <1.6,1,1> translate <4,8,-1.4>} // poignee
 texture {TMetal}
}

#macro pile() // empilement de hauteur 14
 #declare ax=.3 ; #declare ay=.4 ; #declare az=.03 ; // marges aleatoires
 #declare yy=0 ; #declare n=0 ;
 #while(n<3)
  #declare dx=(rand(s)-.5)*ax ; #declare dy=(rand(s)-.5)*ay ; #declare dz=(rand(s)-.5)*az ;
  superellipsoid {<.2,.2> scale<1.4+dx,1+dy,1.2+dz> translate <-1.4-dx,1+dy+yy,0>}
  #declare yy=yy+2*(1+dy) ;
  #declare dx=(rand(s)-.5)*ax ; #declare dy=(rand(s)-.5)*ay ;
  superellipsoid {<.2,.2> scale<1+dx,1+dy,1.2+dz> translate <-1-dx,1+dy+yy,0>}
  #declare yy=yy+2*(1+dy) ;
  #declare n=n+1 ;
 #end
 #declare dx=(rand(s)-.5)*ax ; #declare dy=(12-yy)/2 ;
 superellipsoid {<.2,.2> scale<1.4+dx,1+dy,1.2+dz> translate <-1.4-dx,1+dy+yy,0>}
#end

object {OTorche translate <12,14,-2.3>}
object {OTorche translate <-12,14,-2.3>}

object {OPorte}

text {ttf "Dauphinn.ttf" "1999" 1,0 texture {TGold} scale 1.2 translate <-1.3,.4,0>
 scale .6 translate <-12,3,-.81>}
union {
 box {<-4,0,0>,<4,1.4,1> texture {THat finish {ambient .15}}} // signature
 text {ttf "Frnkstnn.ttf" "JM Grimaldi" 1,0 texture {TText} scale 1.1 translate <-3.3,.4,-.01>}
 scale .5 translate <-12,2,-.81>
}

union { // mur
 plane {-y,-22 no_shadow} // plafond
 difference {
  plane {-z,.8}
  box {<-5.1,-1,-2>,<5.1,14.1,10>} // trou pour la porte
  box {<-10,-100,2>,<10,100,20>} // cage de l'ascenseur (pour l'ombre quand on monte le gamma)
  cylinder {-z,z,1 scale <1,3,1> translate<-12,-1.4,0>} // entree du trou de 'souris'
  cylinder {-.3*z,5*z,1 scale <3,5,1> translate<-12,-1.4,0>} // trou de 'souris'
  cylinder {-z,-.6*z,1.2 scale <1,3,1> translate<-12,-1.4,0>} // arrondi de l'entree
  plane {-x,-18-d} // virage
  box {<18,-1,-1>,<18+2*d,23,d-.8>} // arr. angle
 }
 torus {1.2,.2 rotate 90*x scale <1,3,1> translate<-12,-1.4,-.6>} // arrondi du trou de souris
 cylinder {0,22*y,d translate <18,0,d-.8>} //arrondi de l'angle
 difference {box {<-20,22-d,-.8-d>,<18,23,0>} cylinder {-80*x,0,d translate <18+d,22-d,-.8-d>}}// arr. plafond
 difference {cylinder {0,d*y,2*d}/*box {<0,0,-2*d>,<2*d,d,0>}*/ torus {2*d,d} translate <18,22-d,d-.8>}// angle-plafond

 union {pile() translate -5*x} // montant gauche
 difference { // montant droit
  union {pile() scale <-1,1,1> translate 5*x} // pierres
  text {ttf "Dauphinn.ttf" "-3" 1,0 scale 1.8 translate <5.7,12.6,-2.8> texture {TGold finish {ambient .3}}} // no d'etage
 }
 difference { // lintau
  union {pile() translate -7*y rotate -90*z} // pierres
  text {ttf "Dauphinn.ttf" "-5   -4   -3   -2   -1" 1,0 scale 1.3 translate <-4.4,.6,-1.4>} // etages
  translate 14*y
 }
 texture {TVentre translate 10}
}

sphere {0,1 // lumiere pour indiquer l'etage
 pigment {color rgbf 1}
 interior {media {
  emission rgb<1,1,.2>
  density {spherical}}} hollow
 scale <1.2,.95,1>
 translate <-2,14.7,-.8>
}

#declare OG = union { // guest
 sphere {0,1 texture {TGGlobe}}
 sphere {-z,.3 texture {TPup} rotate -<10,30,0>}
}
union {
 object {OG translate -.8*x}
 object {OG translate -.8*x scale <-1,1,1>}
 sphere {<0,-1.5,2.4>,3 finish {diffuse 0}}
 scale .3
 rotate -29.962*y // looking at you
 translate<-12.2,.6,0>
}

plane {z,-40 texture {TVentre} no_shadow} // mur (pour la reflexion)

#declare OBut = union { // bouton d'ascenseur
 superellipsoid {<.3,.3> translate .6*z pigment {color rgbf<.9,.9,.95,.6>} finish {FBut} hollow}
 mesh {
  triangle {-x,y,0}
  triangle {x,y,0}
  triangle {-x/2,<-.5,-.5,0>,<.5,-.5,0>}
  triangle {-x/2,x/2,<.5,-.5,0>}
  pigment {color rgbf<.4,.8,.4,.8>} finish {FBut}
  scale .6
  translate <0,-.1,-.401>
 }
}

#declare OButs = union { // 2 bout + lumiere
 object {OBut} // up button
 sphere {0,1 // light in the button
  pigment {color rgbf 1}
  interior {media {
   emission rgb<1,1,.2>
   density {spherical}}} hollow
  scale <2,2,1.4>
 }
 object {OBut scale <1,-1,1> translate -2.7*y} // down button
 scale .6
}

object {OButs translate <5.9,8.77,-1.3>}


#declare ONotice = union { // panneaux indicateurs
 height_field {gif "notices.gif" #if(area) smooth #end rotate -90*x translate <-.5,-.5,.1> scale <10,10,.2> texture {TWood}}
 union {
  box {<60,30,-.142>,<360,75,0>}
  box {<60,105,-.142>,<360,150,0>}
  box {<60,180,-.142>,<280,225,0>}
  box {<60,260,-.142>,<280,300,0>}
  box {<60,330,-.142>,<280,375,0>}
  translate -200*<1,1,0> scale  <1/40,-1/40,1> texture {THat}
 }
}

object {ONotice scale .84 translate <12.4,4.5,-.8>}
