// Resolution : 600*200

#global_settings {assumed_gamma 2.48}

#declare db=1 ; // pas de la fourrure (en degres)

#declare d=3 ; // epaisseur de l'arrondi des murs
#declare h=.6 ; // altitude de la camera

#include "gtext.inc"
#declare F = finish {ambient 1 diffuse 0 specular 0}
#declare TPied = texture {pigment {rgb 0} finish {F}}
#declare TTerre = texture {pigment {rgb .4} finish {F}}
#declare TVentre = texture {pigment {rgb 1} finish {F}}

#declare OFour = union { // boule de fourrure, rayon 1
 #declare s=seed(0) ;
 #declare a=0 ;
 #while(a<180)
  #declare b=0 ;
  #while (b<360)
   cone {0,.01,y/2,0 scale <1,.1+a*(180-a)/8100,1> rotate -(80-a/180*80+10*rand(s)-5)*z translate y rotate (-a+14*rand(s)-7)*z rotate (b+2*rand(s)-1)*y}
   #declare b=b+db ;
  #end
  #declare a=a+9 ;
 #end
}
#declare OPied = union { // pied
 sphere {0,1}
 intersection {sphere {0,1 scale <2.4,1,1>} plane {x,0}}
 intersection {sphere {0,1 scale <2.4,1,4>} plane {x,0} plane {-z,0}}
 intersection {sphere {0,1 scale <1,1,4>} plane {-z,0}}
 scale 1.4
}

#declare OBod = union {
 object {OFour scale 3.6 rotate -20*x} // boule de fourrure
 object {OPied rotate 30*y translate -<3.2,8,3.6>}
 object {OPied rotate 20*y translate -<3.2,8,3.6> scale <-1,1,1>}
 translate 8.4*y
}

#declare OTorche = union {
 object {sphere {0,1} rotate rand(s)*360*y}
 sphere {0,1 scale <.3,.2,.3> texture {TTorche rotate rand(s)*360*y} rotate -20*x translate -1.4*y}
}

#macro pile() // empilement de hauteur 14
 #declare ax=.3 ; #declare ay=.4 ; #declare az=.03 ; // marges aleatoires
 #declare yy=0 ; #declare n=0 ;
 #while(n<3)
  #declare dx=(rand(s)-.5)*ax ; #declare dy=(rand(s)-.5)*ay ; #declare dz=(rand(s)-.5)*az ;
  superellipsoid {<.2,.2> scale<1.4+dx,1+dy,1.2+dz> translate <-1.4-dx,1+dy+yy,0>}
  #declare yy=yy+2*(1+dy) ;
  #declare dx=(rand(s)-.5)*ax ; #declare dy=(rand(s)-.5)*ay ;
  superellipsoid {<.2,.2> scale<1+dx,1+dy,1.2+dz> translate <-1-dx,1+dy+yy,0>}
  #declare yy=yy+2*(1+dy) ;
  #declare n=n+1 ;
 #end
 #declare dx=(rand(s)-.5)*ax ; #declare dy=(12-yy)/2 ;
 superellipsoid {<.2,.2> scale<1.4+dx,1+dy,1.2+dz> translate <-1.4-dx,1+dy+yy,0>}
#end


intersection {
union { // mur
 difference {
  plane {-z,.8}
  box {<-5.1,-1,-2>,<5.1,14.1,10>} // trou pour la porte
  box {<-10,-100,2>,<10,100,20>} // cage de l'ascenseur (pour l'ombre quand on monte le gamma)
  cylinder {-z,z,1 scale <1,3,1> translate<-12,-1.4,0>} // entree du trou de 'souris'
  cylinder {-.3*z,5*z,1 scale <3,5,1> translate<-12,-1.4,0>} // trou de 'souris'
  cylinder {-z,-.6*z,1.2 scale <1,3,1> translate<-12,-1.4,0>} // arrondi de l'entree
  plane {-x,-18-d} // virage
  box {<18,-1,-1>,<18+2*d,23,d-.8>} // arr. angle
 }
 torus {1.2,.2 rotate 90*x scale <1,3,1> translate<-12,-1.4,-.6>} // arrondi du trou de souris
 cylinder {0,22*y,d translate <18,0,d-.8>} //arrondi de l'angle

 union {pile() translate -5*x} // montant gauche
 union {pile() scale <-1,1,1> translate 5*x}} // pierres
plane {y,h} texture {TVentre translate 10}}

plane {y,0 texture {TTerre} no_shadow} // sol

intersection {
 object {OBod scale .4 rotate 10*y translate <1,0,-4>}
 plane {y,h}
 texture {TPied}
}

#declare OPied = union { // pied
 sphere {0,1}
 intersection {sphere {0,1 scale <2.4,1,1>} plane {x,0}}
 intersection {sphere {0,1 scale <2.4,1,4>} plane {x,0} plane {-z,0}}
 intersection {sphere {0,1 scale <1,1,4>} plane {-z,0}}
 scale 1.4
}

#declare OBud = union {
 object {OPied rotate 20*y translate -<2.4,8.2,1.2>}
 object {OPied rotate 20*y translate -<2.4,8.2,1.2> scale <-1,1,1>}
 translate 8.5*y
}

intersection {
 object {OBud scale .45 rotate -50*y translate <-4,0,-7>}
 plane {y,h}
 texture {TPied}
}

/*height_field {gif "ground.gif"
 scale <60,.2,20> translate <-30+4,0,-10-4>
 texture {TTerre}
}

light_source {<-12,16,-28,> color rgb <.35,.35,.4>*5 }
light_source {<10,4,-20,> color rgb <.55,.5,.5>*5 }*/

camera { // vue de dessus
 orthographic
 location h*y*1.01
 right 60*x up 20*z
 look_at 0
 scale <-1,1,1>
 translate <4,0,-4>
}
