#declare OOeil = union { // oeil+paupiere
 sphere {0,1 texture {TGlobe}} // blanc
 sphere {0,.2 scale <1,1,.7> translate -z texture {TPup} rotate -<12,20,0>} // noir
 
 intersection {sphere {0,1.01} plane {-z,0} rotate <0,-40,-10>} // voile
 union { // sup
  intersection {sphere {0,1 scale <1.2,1.1,1.1> translate .1*x} plane {-y,0}}
  torus {1.1,.1 scale <1,2,1>}
  rotate <30,-20,-30>
 }
 union { // inf
  intersection {sphere {0,1.1} plane {y,0}}
  torus {1,.1 scale <1,2,1>}
  rotate <-45,10,-30>
 }
 texture {TSkin}
 translate <-1.2,.6,-3.5> // oeil gauche
}

#declare OSem = union { // elements symetriques
 object {OOeil}
 sphere {0,1 scale <2,1,.8> rotate <30,30,10> translate -<1.5,1,3.4>} // joue
 intersection { // levre sup
  cylinder {-y,0,1 scale <2,1,.5> rotate <-10,0,-15>}
  cone {<0,-2,0>,.4,0,0 scale <1,1,.5> translate -.5*z rotate -10*x inverse}
  plane {x,0}
  translate <0,-1.2,-3.7>
 }

 union { // dents sup
  cone {0,.25,-1.2*y,0 rotate 17*z translate <-.2,0,0>}
  cone {0,.25,-1.2*y,0 rotate 19*z translate <-.6,0,.04>}
  cone {0,.25,-1.2*y,0 rotate 21*z translate <-1,0,.1>}
  cone {0,.25,-1.2*y,0 rotate 23*z translate <-1.4,0,.15>}
  cone {0,.25,-1*y,0 rotate 27*z translate <-1.8,0,.2>}
  rotate <-10,0,-15>
  translate <0,-2,-3.7>
  texture {TTooth}
 }
 union { // dents inf
  cone {0,.2,1.2*y,0 rotate 30*z translate <-.2,0,0>}
  cone {0,.2,1.2*y,0 rotate 28*z translate <-.6,0,.06>}
  cone {0,.15,.8*y,0 rotate 24*z translate <-1,0,.15>}
  cone {0,.15,.7*y,0 rotate 20*z translate <-1.4,0,.22>}
  cone {0,.15,.5*y,0 rotate 15*z translate <-1.8,.2,.3>}
  rotate <-20,0,-30>
  translate <.2,-3.8,-3.1>
  texture {TTooth}
 }

 difference { // oreille
  union {
   sphere {0,.6 scale <1,1,.5> rotate <20,60,0> translate <-4,-.6,0>} // lobe
   sphere {0,.6 scale <1.5,2,.5> rotate 60*y rotate <45,0,30> translate <-4.2,.4,.2>}
  }
   sphere {0,.4 scale <1,1,.5> rotate <20,60,0> translate <-4.2,-.6,-.2>}
   sphere {0,.4 scale <1.5,2,.5> rotate 60*y rotate <45,0,30> translate <-4.4,.4,0>}
   sphere {0,.4 scale <1,1,.5> rotate <20,60,0> translate <-4,-.2,-.2>} // trou
 }
 sphere {0,.3 scale <1,1,.7> rotate 60*y translate <-4,-.3,-.4>} // boule

 texture {TSkin}
}

#declare OEChapeau = intersection { // chapeau elem.
  sphere {0,5 translate <.9,0,0>}
  sphere {0,5 translate <-.9,0,0>}
  plane {-y,-1}
  scale <1,1.1,.83>
  translate -2*y
 }
#declare OChapeau = union { // chapeau
 #declare a=0 ; // angle
 #declare da=5 ; // increment
 #declare xx=0 ; #declare yy=0 ;
 #while(a<60)
  object {OEChapeau scale <1-a/500*da,1,1-a/500*da> rotate -a*z translate <xx,yy+2,0>}
  #declare xx = xx+.3*sin(radians(a)) ;
  #declare yy = yy+.3*cos(radians(a)) ;
  #declare a = a+da ;
 #end
 texture {THat}
 rotate 10*x
 }

#declare OTete = union{ // tete
 object {OSem} // moitie gauche
 object {OSem scale <-1,1,1>} // droite

 sphere {0,4} // crane
 sphere {0,1 scale <1,.6,1.5> translate <0,-.3,-3.5>} // nez sup
 intersection {sphere {0,1} plane {y,0} // nez inf
  scale <1,1,1.5> translate <0,-.3,-3.5>}
 sphere {0,1 scale <1,.4,1> translate -<0,3.6,2.6>} // levre inf
 intersection { // zygomatiques
  torus {1,.15 rotate -100*x scale <2,3,5>}
  plane {y,0}
  translate <0,-.8,-3>
 }
  
 texture {TSkin}
}

#declare OFour = union { // boule de fourrure, rayon 1
 #declare s=seed(0) ;

 #declare a=0 ;
 #while(a<180)
  #declare b=0 ;
  #while (b<360)
   cone {0,.01,y/2,0 scale <1,.1+a*(180-a)/8100,1> rotate -(80-a/180*80+10*rand(s)-5)*z translate y rotate (-a+14*rand(s)-7)*z rotate (b+2*rand(s)-1)*y}
   #declare b=b+db ;
  #end
  #declare a=a+9 ;
 #end
 sphere {0,1 texture {
  pigment {color rgb<.7,.67,.5>}
  finish {diffuse .6 specular 0}
 }}
 texture {TFour}
}

#declare OHache = union { // hache
 cylinder {-20*y,2.1*y,.3 texture {TWood}} // manche
 sphere {0,.3 scale <1,.8,1> translate -20*y texture {TWood}} // arrondi bas
 sphere {0,.3 scale <1,.8,1> translate 2.1*y texture {TWood}} // arrondi haut
 cylinder {-2*y,2*y,.4} // 'fourreau' de la lame
 intersection { // lame
  cylinder {-3*y,3*y,20.2 translate 20*z scale <3,1,1>}
  cylinder {-3*y,3*y,20.2 translate -20*z scale <3,1,1>}
  cylinder {-3*z,3*z,8 translate 9.6*y inverse}
  cylinder {-3*z,3*z,8 translate -9.6*y inverse}
  sphere {0,1 scale <10,8,9> translate 8*z texture {TLame}}
  sphere {0,1 scale <10,8,9> translate -8*z texture {TLame}}
 }
 texture {THache}
}

#macro OForeArm(vf1,vf2,vh1,vh2) union { // avant-bras
 union { // main
 sphere {0,1 scale <.4,.8,1> translate -y} // carpe
 sphere {0,.3 translate <.2,-1.5,.6> scale <2,1,1>} // phalanges 1
 sphere {0,.3 translate <.2,-1.7,.2> scale <2,1,1>}
 sphere {0,.3 translate <.2,-1.7,-.2> scale <2,1,1>}
 sphere {0,.3 translate <.2,-1.5,-.6> scale <2,1,1>}
 sphere {0,.3 scale <1,1,2.4> rotate <-30,0,60> rotate -30*y translate <.6,-.6,-.8>} // pouce
 sphere {0,.3 scale <1,2,1> translate <.9,-1.1,.6>} //p2
 sphere {0,.3 scale <1,2,1> translate <.9,-1.3,.2>}
 sphere {0,.3 scale <1,2,1> translate <.9,-1.3,-.2>}
 sphere {0,.3 scale <1,2,1> translate <.9,-1.1,-.6>}

 #if(vdot(vh2,vh2)=36*36) // on met la hache dans la main de droite
 object {OHache scale 1.4 rotate 45*y translate 12*y rotate -90*x translate <.5,-1,0>} // hache
 #end
 translate <-.2,.4,0> // le poignet a l'origine

 texture {TSkin}
 rotate vh1 rotate vh2
 translate <.4,-3,-.6> rotate 30*y}
 
 #declare trd = .3 ;
 #macro blb(sth) 0,sqrt(1/(1-sqrt(trd/sth))),sth #end
 blob {
  threshold trd
  sphere {blb(1) scale <.6,1.4,.6> rotate <10,30,10> translate <0,-1.6,-.4>} // ab dos
  sphere {blb(1) scale <.3,.5,.5> translate <-.2,0,0> rotate vh1 rotate vh2 translate <.4,-3,-.6> rotate 30*y} // poignet
 }

 sphere {0,.5} // coude
 sphere {0,1 scale <.6,1.4,.4> rotate <5,-30,5> translate -<.2,1,.6>} // ab dessus
 sphere {0,1 scale <.4,1.4,.4> rotate <10,0,-3> translate <.2,-1.4,-.6>}
 rotate -30*y
 texture {TSkin}
 rotate vf1 rotate vf2
}#end

#macro OArm(va1,va2,vf1,vf2,vh1,vh2) union { // bras
 object {OForeArm(vf1,vf2,vh1,vh2) translate <0,-3.2,-.2>} // avant-bras
 sphere {0,1 scale <1,2,1.2>} // epaule
 sphere {0,1 scale <.8,1.6,1> translate -<.2,1.6,.5>} // biceps
 sphere {0,1 scale <.04,1.6,1.04> translate -<.2,1.6,.5>} // a nerve on the biceps
 sphere {0,1 scale <1,2,1.2> rotate 20*x translate <0,-1.2,0>} // bras
 texture {TSkin}
 translate -1.6*y
 rotate va1 rotate va2
 rotate 10*x // pour eviter de rentrer dans le ventre
 translate <-3.8,.8,0>
}#end

#declare OPied = union { // pied
 sphere {0,1}
 intersection {sphere {0,1 scale <2.4,1,1>} plane {x,0}}
 intersection {sphere {0,1 scale <2.4,1,4>} plane {x,0} plane {-z,0}}
 intersection {sphere {0,1 scale <1,1,4>} plane {-z,0}}
 sphere {<0,1,3>,1 texture {TVentre}}
 scale 1.4
 texture {TPied}
}

#declare OBod = union {
 object {OTete rotate 5*y translate <0,5.4,-2.2>}
 object {OChapeau rotate 5*y translate <0,5.4,-2.2>}
 object {OArm(<5,-40,-30>,0,<0,-30,0>,<60,0,0>,<0,-22,30>,<-18,0,0>)} // bras gauche
 object {OArm(<-30,15,-10>,0,<0,60,0>,<80,0,0>,<0,40,-40>,<-36,0,0>) scale <-1,1,1>} // bras droit
 object {OFour scale 3.6 rotate -20*x} // boule de fourrure
 sphere {0,3 scale <1.2,1.4,1.2> rotate -3*x translate <0,-3.1,.2> texture {TVentre}} // ventre
 object {OPied rotate 30*y translate -<3.2,8,3.6>}
 object {OPied rotate 20*y translate -<3.2,8,3.6> scale <-1,1,1>}
 translate 8.4*y
}
