//Foot.inc
//An OK foot shape

#version 3.1;

#declare Flesh = color red 0.96 green 0.80 blue 0.69;


// create a smooth blobby shape 
#declare RightFoot = 
blob
{ #declare Radius = 0.6;
#declare Width = 2;
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  cylinder { <0,0.4,0>, <3,0.6,0>, Radius, 1 scale <1,1,Width>}   //lower foot surface 
  cylinder { <0,0.3,0>, <3,1.6,0>, Radius, 1 scale <1,0.9,Width>}  //upper surface 
  sphere { <2.7,0.3,0>, 1.0*Radius, 1 scale <1,1,(5/6)*Width>}         //heel
  
  cylinder {<-0.4,0.25,-0.6> , <-1.0,0.25,-0.6>, 0.45, 1.0 } //big toe 
  cylinder {<-0.4,0.25,-0.2> , <-0.9,0.25,-0.2>, 0.22, 1.0 } //2nd toe 
  cylinder {<-0.4,0.25,0.1> , <-0.8,0.25,0.1>, 0.22, 1.0 } //3rd toe 
  cylinder {<-0.4,0.25,0.39> , <-0.6,0.25,0.39>, 0.20, 1.0 } //4th toe
  cylinder {<-0.25,0.25,0.7> , <-0.5,0.25,0.7>, 0.20, 0.9 } //5th toe
  
  cylinder { <4,1.5,0>, <4.5,2.3,0>, 2.2, 1 scale <1,1,1>} //ankle/leg 
  
  cylinder { <3,0.9,0>, <3,1.0,0>, Radius*1.2, 1 scale <1.2,1,0.8*Width> translate x*-0.6}  //back of foot
  
  cylinder { <1,0.5,-1.2>, <2,0.5,-1.3>, 1, -1 }//Curve inside of foot
  
  // [sturm]
  scale 1
  translate -1.5*x 
  pigment {Flesh} 
  

}

#declare LeftFoot =
blob
{ #declare Radius = 0.6;
#declare Width = 2;
  // threshold (0.0 < threshold <= StrengthVal) surface falloff threshold #
  threshold 0.6
  cylinder { <0,0.4,0>, <3,0.6,0>, Radius, 1 scale <1,1,Width>}   //lower foot surface 
  cylinder { <0,0.3,0>, <3,1.6,0>, Radius, 1 scale <1,0.9,Width>}  //upper surface 
  sphere { <2.7,0.3,0>, 1.0*Radius, 1 scale <1,1,(5/6)*Width>}         //heel
  
  
    cylinder {<-0.4,0.25,0.6> , <-1.0,0.25,0.6>, 0.45, 1.0 } //big toe  
    
 
  cylinder {<-0.4,0.25,0.25> , <-0.9,0.25,0.25>, 0.22, 1.0 } //2nd toe 
  
  cylinder {<-0.4,0.25,-0.05> , <-0.8,0.25,-0.05>, 0.22, 1.0 } //3rd toe 
  
  cylinder {<-0.35,0.25,-0.16> , <-0.65,0.25,-0.16>, 0.1, -0.6 } //corrective negative cylinder
   
  
    cylinder {<-0.4,0.25,-0.30> , <-0.60,0.25,-0.30>, 0.20, 1.0 } //4th toe
  
  
  cylinder {<-0.25,0.25,-0.6> , <-0.5,0.25,-0.6>, 0.20, 0.9 } //5th toe
  
  cylinder { <4,1.5,0>, <4.5,2.3,0>, 2.2, 1 scale <1,1,1>} //ankle/leg 
  
  cylinder { <3,0.9,0>, <3,1.0,0>, Radius*1.2, 1 scale <1.2,1,0.8*Width> translate x*-0.6}  //back of foot
  
  cylinder { <1.3,0.5,1.25>, <2,0.5,1.35>, 1, -1 }//Curve inside of foot
  
  // [sturm]
  scale 1
  translate -1.5*x 
  pigment {Flesh} 
  

}

