#declare cam = off;
#declare lig = off;
#if (cam)
  camera {  //  Camera Camera01
    location  <    -10.710,     -18.240,       2.340>
    direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
    sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
    up        <        0.0,         0.0,         1.0> // Where Z is up
    right     <    1.33333,         0.0,         0.0> // Aspect ratio
    look_at   <     -0.060,       4.250,       3.170>
  }
#end

// *******  L I G H T S *******

#if (lig)
  light_source { <5000,-6000,5000> color rgb <1,0.9,0.7> }
  light_source { <-10,-18,2.3> color rgb <1,0.9,0.7>*0.1 }
  light_source { <-10,38,2.3> color rgb <0.4,0.3,0.1>*0.5 }
#end

// ********  TEXTURES  *******

#include "boy.inc"

// ********  OBJECTS  *******

#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.631228, -0.281669, 6.072497>, <-0.631228, -0.244154, 6.085545>, <-0.631228, -0.195247, 6.106742>, <-0.631228, -0.156620, 6.115991>, 
      <-0.676274, -0.238355, 5.997131>, <-0.676274, -0.200841, 6.010179>, <-0.676710, -0.154138, 5.995660>, <-0.676710, -0.115511, 6.004909>, 
      <-0.627422, -0.239805, 5.847954>, <-0.627422, -0.202290, 5.831644>, <-0.627422, -0.155612, 5.824987>, <-0.627422, -0.114757, 5.822944>, 
      <-0.625791, -0.221863, 5.751722>, <-0.625791, -0.184349, 5.735411>, <-0.625791, -0.137671, 5.699396>, <-0.625791, -0.096815, 5.697353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343074, -0.493706, 6.224730>, <-0.343074, -0.451299, 6.273662>, <-0.343074, -0.409193, 6.356830>, <-0.343074, -0.352348, 6.387836>, 
      <-0.447761, -0.449851, 6.197851>, <-0.447761, -0.407443, 6.246783>, <-0.451897, -0.360664, 6.298741>, <-0.451897, -0.303819, 6.329748>, 
      <-0.577561, -0.333272, 6.162286>, <-0.577561, -0.295757, 6.175334>, <-0.583709, -0.238197, 6.222798>, <-0.583709, -0.199570, 6.232047>, 
      <-0.631228, -0.281669, 6.072497>, <-0.631228, -0.244154, 6.085545>, <-0.631228, -0.195247, 6.106742>, <-0.631228, -0.156620, 6.115991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.173429, -0.618755, 6.279098>, <0.173429, -0.587765, 6.359020>, <0.173429, -0.589638, 6.502556>, <0.173429, -0.515454, 6.545505>, 
      <0.013201, -0.621402, 6.280863>, <0.013201, -0.590412, 6.360785>, <0.004209, -0.587885, 6.504310>, <0.004209, -0.513700, 6.547259>, 
      <-0.199239, -0.553961, 6.261660>, <-0.199239, -0.511554, 6.310592>, <-0.204139, -0.471150, 6.430991>, <-0.204139, -0.414305, 6.461997>, 
      <-0.343074, -0.493706, 6.224730>, <-0.343074, -0.451299, 6.273662>, <-0.343074, -0.409193, 6.356830>, <-0.343074, -0.352348, 6.387836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.644193, -0.477396, 6.213856>, <0.662808, -0.443144, 6.262788>, <0.700470, -0.417341, 6.346109>, <0.706242, -0.363222, 6.376962>, 
      <0.515053, -0.539147, 6.254314>, <0.533667, -0.504894, 6.303245>, <0.556505, -0.481746, 6.419039>, <0.562278, -0.427627, 6.449892>, 
      <0.322152, -0.616298, 6.277460>, <0.322152, -0.585308, 6.357382>, <0.347170, -0.591439, 6.500756>, <0.347170, -0.517254, 6.543704>, 
      <0.173429, -0.618755, 6.279098>, <0.173429, -0.587765, 6.359020>, <0.173429, -0.589638, 6.502556>, <0.173429, -0.515454, 6.545505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.832906, -0.303416, 6.072497>, <0.882984, -0.256115, 6.088808>, <0.973066, -0.211136, 6.122507>, <0.999834, -0.145747, 6.126866>, 
      <0.792520, -0.341199, 6.140828>, <0.842598, -0.293899, 6.157139>, <0.929876, -0.259839, 6.238292>, <0.956644, -0.194450, 6.242651>, 
      <0.720511, -0.440904, 6.189947>, <0.739126, -0.406651, 6.238879>, <0.810522, -0.368107, 6.290359>, <0.816294, -0.313988, 6.321212>, 
      <0.644193, -0.477396, 6.213856>, <0.662808, -0.443144, 6.262788>, <0.700470, -0.417341, 6.346109>, <0.706242, -0.363222, 6.376962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.917331, -0.221863, 5.751722>, <0.930664, -0.177825, 5.733780>, <0.955131, -0.123837, 5.695980>, <0.961775, -0.075068, 5.691916>, 
      <0.892003, -0.246329, 5.847954>, <0.905337, -0.202290, 5.830012>, <0.966548, -0.145041, 5.826465>, <0.973193, -0.096272, 5.822401>, 
      <0.879984, -0.259373, 5.992844>, <0.930062, -0.212072, 6.009154>, <1.016210, -0.162484, 6.006844>, <1.042978, -0.097095, 6.011203>, 
      <0.832906, -0.303416, 6.072497>, <0.882984, -0.256115, 6.088808>, <0.973066, -0.211136, 6.122507>, <0.999834, -0.145747, 6.126866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.631228, 0.104349, 6.164923>, <-0.673436, 0.104349, 6.043168>, <-0.627422, 0.104349, 5.864265>, <-0.625791, 0.104349, 5.735411>, 
      <-0.631228, 0.025705, 6.177575>, <-0.673436, 0.025705, 6.055820>, <-0.627422, 0.043982, 5.875590>, <-0.625791, 0.043982, 5.746736>, 
      <-0.631228, -0.079155, 6.134539>, <-0.676710, -0.038046, 6.023457>, <-0.627422, -0.053413, 5.819877>, <-0.625791, -0.035472, 5.694286>, 
      <-0.631228, -0.156620, 6.115991>, <-0.676710, -0.115511, 6.004909>, <-0.627422, -0.114757, 5.822944>, <-0.625791, -0.096815, 5.697353>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343074, 0.104349, 6.550941>, <-0.463566, 0.104349, 6.471156>, <-0.583894, 0.104349, 6.301464>, <-0.631228, 0.104349, 6.164923>, 
      <-0.343074, -0.040693, 6.562285>, <-0.463566, -0.040693, 6.482500>, <-0.583894, 0.025705, 6.314115>, <-0.631228, 0.025705, 6.177575>, 
      <-0.343074, -0.224628, 6.457502>, <-0.451897, -0.176098, 6.399413>, <-0.583709, -0.122104, 6.250595>, <-0.631228, -0.079155, 6.134539>, 
      <-0.343074, -0.352348, 6.387836>, <-0.451897, -0.303819, 6.329748>, <-0.583709, -0.199570, 6.232047>, <-0.631228, -0.156620, 6.115991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.173429, 0.104349, 6.697737>, <0.012344, 0.104349, 6.698572>, <-0.208762, 0.104349, 6.639877>, <-0.343074, 0.104349, 6.550941>, 
      <0.173429, -0.087084, 6.701354>, <0.012344, -0.087084, 6.702188>, <-0.208762, -0.040693, 6.651221>, <-0.343074, -0.040693, 6.562285>, 
      <0.173429, -0.349753, 6.641437>, <0.004209, -0.348000, 6.643191>, <-0.204139, -0.286585, 6.531662>, <-0.343074, -0.224628, 6.457502>, 
      <0.173429, -0.515454, 6.545505>, <0.004209, -0.513700, 6.547259>, <-0.204139, -0.414305, 6.461997>, <-0.343074, -0.352348, 6.387836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.706242, 0.104349, 6.545505>, <0.571568, 0.104349, 6.642966>, <0.339667, 0.104349, 6.696876>, <0.173429, 0.104349, 6.697737>, 
      <0.706242, -0.044373, 6.556200>, <0.571568, -0.044373, 6.653661>, <0.339667, -0.087084, 6.700493>, <0.173429, -0.087084, 6.701354>, 
      <0.719999, -0.234240, 6.450494>, <0.576035, -0.298645, 6.523424>, <0.347170, -0.351554, 6.639636>, <0.173429, -0.349753, 6.641437>, 
      <0.706242, -0.363222, 6.376962>, <0.562278, -0.427627, 6.449892>, <0.347170, -0.517254, 6.543704>, <0.173429, -0.515454, 6.545505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.999834, 0.104349, 6.099681>, <0.952240, 0.104349, 6.252589>, <0.835977, 0.104349, 6.451618>, <0.706242, 0.104349, 6.545505>, 
      <0.999834, 0.031581, 6.119697>, <0.952240, 0.031581, 6.272604>, <0.835977, -0.044373, 6.462312>, <0.706242, -0.044373, 6.556200>, 
      <1.028372, -0.076035, 6.131513>, <0.985183, -0.124738, 6.247298>, <0.830052, -0.185006, 6.394744>, <0.719999, -0.234240, 6.450494>, 
      <0.999834, -0.145747, 6.126866>, <0.956644, -0.194450, 6.242651>, <0.816294, -0.313988, 6.321212>, <0.706242, -0.363222, 6.376962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.961775, 0.104349, 5.724537>, <0.973193, 0.104349, 5.837080>, <1.033453, 0.104349, 5.991671>, <0.999834, 0.104349, 6.099681>, 
      <0.961775, 0.050793, 5.735701>, <0.973193, 0.050793, 5.848244>, <1.033453, 0.031581, 6.011687>, <0.999834, 0.031581, 6.119697>, 
      <0.969135, -0.021045, 5.687414>, <0.980553, -0.042249, 5.817899>, <1.071516, -0.027383, 6.015850>, <1.028372, -0.076035, 6.131513>, 
      <0.961775, -0.075068, 5.691916>, <0.973193, -0.096272, 5.822401>, <1.042978, -0.097095, 6.011203>, <0.999834, -0.145747, 6.126866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.365029, 0.556524, 4.851248>, <-0.404801, 0.538962, 4.865069>, <-0.455838, 0.506909, 4.876213>, <-0.494756, 0.485646, 4.886913>, 
      <-0.444889, 0.619060, 5.034852>, <-0.484660, 0.601498, 5.048674>, <-0.495148, 0.500151, 4.981288>, <-0.534067, 0.478888, 4.991988>, 
      <-0.583956, 0.765831, 5.258902>, <-0.621019, 0.678513, 5.197209>, <-0.607515, 0.569451, 5.195510>, <-0.605884, 0.478893, 5.127680>, 
      <-0.631228, 0.764977, 5.463264>, <-0.668291, 0.677659, 5.401570>, <-0.627422, 0.553676, 5.304994>, <-0.625791, 0.463119, 5.237164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.142059, 0.641389, 4.764344>, <-0.209789, 0.613881, 4.785751>, <-0.298622, 0.585848, 4.828170>, <-0.365029, 0.556524, 4.851248>, 
      <-0.202364, 0.787725, 5.047369>, <-0.270093, 0.760217, 5.068776>, <-0.378482, 0.648384, 5.011775>, <-0.444889, 0.619060, 5.034852>, 
      <-0.301134, 1.108087, 5.386901>, <-0.431194, 1.027205, 5.350388>, <-0.532384, 0.887330, 5.344746>, <-0.583956, 0.765831, 5.258902>, 
      <-0.343074, 1.129175, 5.707760>, <-0.473134, 1.048294, 5.671246>, <-0.579656, 0.886475, 5.549108>, <-0.631228, 0.764977, 5.463264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.173429, 0.775215, 4.681063>, <0.067848, 0.768459, 4.680091>, <-0.047984, 0.679597, 4.734611>, <-0.142059, 0.641389, 4.764344>, 
      <0.173429, 0.922263, 4.983494>, <0.067848, 0.915507, 4.982522>, <-0.108289, 0.825933, 5.017636>, <-0.202364, 0.787725, 5.047369>, 
      <0.173429, 1.240908, 5.353772>, <0.013086, 1.241586, 5.354251>, <-0.168684, 1.190455, 5.424086>, <-0.301134, 1.108087, 5.386901>, 
      <0.173429, 1.265376, 5.689166>, <0.013086, 1.266054, 5.689645>, <-0.210623, 1.211543, 5.744944>, <-0.343074, 1.129175, 5.707760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.564989, 0.686634, 4.770852>, <0.452795, 0.727319, 4.739422>, <0.296584, 0.783096, 4.682197>, <0.173429, 0.775215, 4.681063>, 
      <0.607365, 0.818064, 5.050983>, <0.495171, 0.858749, 5.019553>, <0.296584, 0.930144, 4.984627>, <0.173429, 0.922263, 4.983494>, 
      <0.677484, 1.112699, 5.393863>, <0.540549, 1.196336, 5.433930>, <0.338811, 1.240208, 5.353278>, <0.173429, 1.240908, 5.353772>, 
      <0.706242, 1.124735, 5.704622>, <0.569307, 1.208372, 5.744688>, <0.338811, 1.264676, 5.688672>, <0.173429, 1.265376, 5.689166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.787969, 0.552365, 4.853224>, <0.727134, 0.600413, 4.826796>, <0.639446, 0.659634, 4.791711>, <0.564989, 0.686634, 4.770852>, 
      <0.851529, 0.614843, 5.031466>, <0.790693, 0.662891, 5.005038>, <0.681822, 0.791064, 5.071842>, <0.607365, 0.818064, 5.050983>, 
      <0.961785, 0.765376, 5.251805>, <0.914191, 0.890258, 5.340039>, <0.810080, 1.031712, 5.355066>, <0.677484, 1.112699, 5.393863>, 
      <0.999834, 0.760624, 5.447364>, <0.952240, 0.885506, 5.535598>, <0.838838, 1.043748, 5.665825>, <0.706242, 1.124735, 5.704622>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.849596, 0.461849, 4.894491>, <0.831108, 0.489004, 4.882111>, <0.814045, 0.531770, 4.864552>, <0.787969, 0.552365, 4.853224>, 
      <0.883250, 0.459566, 4.995411>, <0.864762, 0.486721, 4.983031>, <0.877605, 0.594248, 5.042794>, <0.851529, 0.614843, 5.031466>, 
      <0.945126, 0.466755, 5.126541>, <0.956544, 0.558671, 5.191484>, <0.995404, 0.677163, 5.189479>, <0.961785, 0.765376, 5.251805>, 
      <0.961775, 0.454238, 5.230890>, <0.973193, 0.546154, 5.295832>, <1.033453, 0.672411, 5.385038>, <0.999834, 0.760624, 5.447364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.631228, 0.551713, 6.002043>, <-0.631228, 0.670877, 5.875478>, <-0.670404, 0.764269, 5.632626>, <-0.631228, 0.764977, 5.463264>, 
      <-0.675007, 0.495866, 5.894477>, <-0.675007, 0.615030, 5.767912>, <-0.707468, 0.676951, 5.570932>, <-0.668291, 0.677659, 5.401570>, 
      <-0.627422, 0.432784, 5.725906>, <-0.627422, 0.499262, 5.633585>, <-0.647573, 0.537709, 5.415816>, <-0.627422, 0.553676, 5.304994>, 
      <-0.625791, 0.381815, 5.607562>, <-0.625791, 0.448292, 5.515241>, <-0.645942, 0.447152, 5.347986>, <-0.625791, 0.463119, 5.237164>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.631228, 0.551713, 6.002043>, <-0.675007, 0.495866, 5.894477>, <-0.627422, 0.432784, 5.725906>, <-0.625791, 0.381815, 5.607562>, 
      <-0.631228, 0.453805, 6.106032>, <-0.675007, 0.397958, 5.998466>, <-0.627422, 0.379229, 5.800282>, <-0.625791, 0.328260, 5.681938>, 
      <-0.631228, 0.245364, 6.142238>, <-0.673436, 0.245364, 6.020483>, <-0.627422, 0.194429, 5.847366>, <-0.625791, 0.194429, 5.718512>, 
      <-0.631228, 0.104349, 6.164923>, <-0.673436, 0.104349, 6.043168>, <-0.627422, 0.104349, 5.864265>, <-0.625791, 0.104349, 5.735411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343074, 0.742465, 6.302209>, <-0.343074, 0.906755, 6.167038>, <-0.370590, 1.143011, 5.918268>, <-0.343074, 1.129175, 5.707760>, 
      <-0.451312, 0.694368, 6.232726>, <-0.451312, 0.858658, 6.097556>, <-0.500649, 1.062129, 5.881755>, <-0.473134, 1.048294, 5.671246>, 
      <-0.584577, 0.611224, 6.116667>, <-0.584577, 0.730388, 5.990102>, <-0.618833, 0.885767, 5.718470>, <-0.579656, 0.886475, 5.549108>, 
      <-0.631228, 0.551713, 6.002043>, <-0.631228, 0.670877, 5.875478>, <-0.670404, 0.764269, 5.632626>, <-0.631228, 0.764977, 5.463264>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343074, 0.742465, 6.302209>, <-0.451312, 0.694368, 6.232726>, <-0.584577, 0.611224, 6.116667>, <-0.631228, 0.551713, 6.002043>, 
      <-0.343074, 0.583801, 6.432751>, <-0.451312, 0.535704, 6.363268>, <-0.584577, 0.513316, 6.220656>, <-0.631228, 0.453805, 6.106032>, 
      <-0.343074, 0.309187, 6.534920>, <-0.463566, 0.309187, 6.455135>, <-0.583894, 0.245364, 6.278778>, <-0.631228, 0.245364, 6.142238>, 
      <-0.343074, 0.104349, 6.550941>, <-0.463566, 0.104349, 6.471156>, <-0.583894, 0.104349, 6.301464>, <-0.631228, 0.104349, 6.164923>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.173429, 0.909269, 6.518585>, <0.173429, 1.113697, 6.341000>, <0.173429, 1.285079, 5.959238>, <0.173429, 1.265376, 5.689166>, 
      <-0.001861, 0.908720, 6.519419>, <-0.001861, 1.113149, 6.341834>, <0.013086, 1.285757, 5.959718>, <0.013086, 1.266054, 5.689645>, 
      <-0.204904, 0.803862, 6.390906>, <-0.204904, 0.968152, 6.255735>, <-0.238139, 1.225379, 5.955453>, <-0.210623, 1.211543, 5.744944>, 
      <-0.343074, 0.742465, 6.302209>, <-0.343074, 0.906755, 6.167038>, <-0.370590, 1.143011, 5.918268>, <-0.343074, 1.129175, 5.707760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.173429, 0.909269, 6.518585>, <-0.001861, 0.908720, 6.519419>, <-0.204904, 0.803862, 6.390906>, <-0.343074, 0.742465, 6.302209>, 
      <0.173429, 0.722510, 6.680820>, <-0.001861, 0.721961, 6.681654>, <-0.204904, 0.645198, 6.521448>, <-0.343074, 0.583801, 6.432751>, 
      <0.173429, 0.351690, 6.693064>, <0.012344, 0.351690, 6.693898>, <-0.208762, 0.309187, 6.623856>, <-0.343074, 0.309187, 6.534920>, 
      <0.173429, 0.104349, 6.697737>, <0.012344, 0.104349, 6.698572>, <-0.208762, 0.104349, 6.639877>, <-0.343074, 0.104349, 6.550941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.706242, 0.745751, 6.297215>, <0.706242, 0.908603, 6.163011>, <0.725673, 1.132867, 5.914593>, <0.706242, 1.124735, 5.704622>, 
      <0.568331, 0.809727, 6.393416>, <0.568331, 0.972579, 6.259212>, <0.588738, 1.216505, 5.954660>, <0.569307, 1.208372, 5.744688>, 
      <0.353334, 0.909832, 6.517729>, <0.353334, 1.114261, 6.340144>, <0.338811, 1.284379, 5.958744>, <0.338811, 1.264676, 5.688672>, 
      <0.173429, 0.909269, 6.518585>, <0.173429, 1.113697, 6.341000>, <0.173429, 1.285079, 5.959238>, <0.173429, 1.265376, 5.689166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.706242, 0.745751, 6.297215>, <0.568331, 0.809727, 6.393416>, <0.353334, 0.909832, 6.517729>, <0.173429, 0.909269, 6.518585>, 
      <0.706242, 0.586518, 6.428436>, <0.568331, 0.650494, 6.524636>, <0.353334, 0.723073, 6.679964>, <0.173429, 0.722510, 6.680820>, 
      <0.706242, 0.310152, 6.530706>, <0.571568, 0.310152, 6.628167>, <0.339667, 0.351690, 6.692202>, <0.173429, 0.351690, 6.693064>, 
      <0.706242, 0.104349, 6.545505>, <0.571568, 0.104349, 6.642966>, <0.339667, 0.104349, 6.696876>, <0.173429, 0.104349, 6.697737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.999834, 0.525906, 5.942122>, <0.999834, 0.642423, 5.826308>, <1.031201, 0.756707, 5.608577>, <0.999834, 0.760624, 5.447364>, 
      <0.952734, 0.593780, 6.071081>, <0.952734, 0.710297, 5.955266>, <0.983607, 0.881589, 5.696811>, <0.952240, 0.885506, 5.535598>, 
      <0.823643, 0.691290, 6.215321>, <0.823643, 0.854142, 6.081117>, <0.858270, 1.051880, 5.875796>, <0.838838, 1.043748, 5.665825>, 
      <0.706242, 0.745751, 6.297215>, <0.706242, 0.908603, 6.163011>, <0.725673, 1.132867, 5.914593>, <0.706242, 1.124735, 5.704622>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.999834, 0.525906, 5.942122>, <0.952734, 0.593780, 6.071081>, <0.823643, 0.691290, 6.215321>, <0.706242, 0.745751, 6.297215>, 
      <0.999834, 0.430150, 6.037300>, <0.952734, 0.498024, 6.166259>, <0.823643, 0.532057, 6.346542>, <0.706242, 0.586518, 6.428436>, 
      <0.999834, 0.234526, 6.063875>, <0.952240, 0.234526, 6.216782>, <0.835977, 0.310152, 6.436818>, <0.706242, 0.310152, 6.530706>, 
      <0.999834, 0.104349, 6.099681>, <0.952240, 0.104349, 6.252589>, <0.835977, 0.104349, 6.451618>, <0.706242, 0.104349, 6.545505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.961775, 0.377513, 5.597575>, <0.961775, 0.442503, 5.505883>, <0.979360, 0.441018, 5.341104>, <0.961775, 0.454238, 5.230890>, 
      <0.973193, 0.422031, 5.700939>, <0.973193, 0.487021, 5.609247>, <0.990778, 0.532933, 5.406046>, <0.973193, 0.546154, 5.295832>, 
      <1.034623, 0.475773, 5.846871>, <1.034623, 0.592290, 5.731057>, <1.064820, 0.668493, 5.546251>, <1.033453, 0.672411, 5.385038>, 
      <0.999834, 0.525906, 5.942122>, <0.999834, 0.642423, 5.826308>, <1.031201, 0.756707, 5.608577>, <0.999834, 0.760624, 5.447364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.961775, 0.377513, 5.597575>, <0.973193, 0.422031, 5.700939>, <1.034623, 0.475773, 5.846871>, <0.999834, 0.525906, 5.942122>, 
      <0.961775, 0.325257, 5.671302>, <0.973193, 0.369774, 5.774666>, <1.034623, 0.380017, 5.942050>, <0.999834, 0.430150, 6.037300>, 
      <0.961775, 0.192816, 5.706096>, <0.973193, 0.192816, 5.818639>, <1.033453, 0.234526, 5.955865>, <0.999834, 0.234526, 6.063875>, 
      <0.961775, 0.104349, 5.724537>, <0.973193, 0.104349, 5.837080>, <1.033453, 0.104349, 5.991671>, <0.999834, 0.104349, 6.099681>
    }
  }
  texture {
    Hair
  }
}
#declare sPatchObj1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.502160, -1.354523, -5.723215>, <-0.558529, -1.424776, -5.721884>, <-0.707526, -1.450614, -5.712621>, <-0.793868, -1.424928, -5.712621>, 
      <-0.499416, -1.376457, -5.717769>, <-0.555784, -1.446710, -5.716437>, <-0.711359, -1.474136, -5.706936>, <-0.797701, -1.448450, -5.706936>, 
      <-0.489718, -1.416415, -5.724594>, <-0.550323, -1.491948, -5.723163>, <-0.710083, -1.516213, -5.712886>, <-0.802914, -1.488596, -5.712886>, 
      <-0.493012, -1.427637, -5.705061>, <-0.553617, -1.503169, -5.703630>, <-0.713813, -1.530951, -5.693672>, <-0.806643, -1.503334, -5.693672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.345270, -0.865838, -5.723215>, <-0.354502, -1.019537, -5.723215>, <-0.405809, -1.234440, -5.725490>, <-0.502160, -1.354523, -5.723215>, 
      <-0.338988, -0.876754, -5.717769>, <-0.348220, -1.030453, -5.717769>, <-0.403065, -1.256375, -5.720044>, <-0.499416, -1.376457, -5.717769>, 
      <-0.325971, -0.899756, -5.718459>, <-0.335897, -1.065006, -5.718459>, <-0.386126, -1.287308, -5.727040>, <-0.489718, -1.416415, -5.724594>, 
      <-0.324330, -0.902225, -5.705061>, <-0.334256, -1.067475, -5.705061>, <-0.389420, -1.298530, -5.707507>, <-0.493012, -1.427637, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.452509, -0.527932, -5.723215>, <-0.439158, -0.633445, -5.723215>, <-0.338893, -0.759675, -5.723215>, <-0.345270, -0.865838, -5.723215>, 
      <-0.448645, -0.531230, -5.717769>, <-0.435294, -0.636743, -5.717769>, <-0.332611, -0.770591, -5.717769>, <-0.338988, -0.876754, -5.717769>, 
      <-0.442841, -0.538465, -5.711765>, <-0.428486, -0.651907, -5.711765>, <-0.319115, -0.785615, -5.718459>, <-0.325971, -0.899756, -5.718459>, 
      <-0.439629, -0.538925, -5.705061>, <-0.425275, -0.652368, -5.705061>, <-0.317474, -0.788084, -5.705061>, <-0.324330, -0.902225, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.415131, -0.313720, -5.723215>, <-0.432105, -0.376708, -5.723215>, <-0.460698, -0.463214, -5.723215>, <-0.452509, -0.527932, -5.723215>, 
      <-0.410424, -0.312188, -5.717769>, <-0.427398, -0.375176, -5.717769>, <-0.456834, -0.466511, -5.717769>, <-0.448645, -0.531230, -5.717769>, 
      <-0.402891, -0.309123, -5.711542>, <-0.421140, -0.376845, -5.711542>, <-0.451645, -0.468882, -5.711765>, <-0.442841, -0.538465, -5.711765>, 
      <-0.399441, -0.308613, -5.705061>, <-0.417691, -0.376335, -5.705061>, <-0.448433, -0.469342, -5.705061>, <-0.439629, -0.538925, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.310324, -0.000307, -5.723215>, <-0.329010, -0.097672, -5.723215>, <-0.389334, -0.217993, -5.723215>, <-0.415131, -0.313720, -5.723215>, 
      <-0.303254, 0.008292, -5.717769>, <-0.321940, -0.089073, -5.717769>, <-0.384627, -0.216461, -5.717769>, <-0.410424, -0.312188, -5.717769>, 
      <-0.293567, 0.025368, -5.714975>, <-0.313657, -0.079314, -5.714975>, <-0.375156, -0.206202, -5.711542>, <-0.402891, -0.309123, -5.711542>, 
      <-0.286758, 0.028355, -5.705061>, <-0.306848, -0.076328, -5.705061>, <-0.371706, -0.205692, -5.705061>, <-0.399441, -0.308613, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.278053, 0.400545, -5.723215>, <-0.223998, 0.292688, -5.723215>, <-0.287585, 0.118176, -5.723215>, <-0.310324, -0.000307, -5.723215>, 
      <-0.270255, 0.418181, -5.717769>, <-0.216200, 0.310324, -5.717769>, <-0.280516, 0.126774, -5.717769>, <-0.303254, 0.008292, -5.717769>, 
      <-0.257082, 0.448771, -5.721332>, <-0.198964, 0.332808, -5.721332>, <-0.269120, 0.152755, -5.714975>, <-0.293567, 0.025368, -5.714975>, 
      <-0.252061, 0.459333, -5.705061>, <-0.193943, 0.343370, -5.705061>, <-0.262311, 0.155742, -5.705061>, <-0.286758, 0.028355, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.598098, 0.573897, -5.723215>, <-0.489986, 0.558572, -5.723215>, <-0.326977, 0.498165, -5.723215>, <-0.278053, 0.400545, -5.723215>, 
      <-0.597517, 0.595441, -5.717769>, <-0.489404, 0.580116, -5.717769>, <-0.319180, 0.515801, -5.717769>, <-0.270255, 0.418181, -5.717769>, 
      <-0.596869, 0.631404, -5.722059>, <-0.480631, 0.614927, -5.722059>, <-0.309683, 0.553728, -5.721332>, <-0.257082, 0.448771, -5.721332>, 
      <-0.596160, 0.645712, -5.705061>, <-0.479922, 0.629235, -5.705061>, <-0.304662, 0.564289, -5.705061>, <-0.252061, 0.459333, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.902284, 0.489032, -5.723215>, <-0.839713, 0.560170, -5.723215>, <-0.691901, 0.587194, -5.723215>, <-0.598098, 0.573897, -5.723215>, 
      <-0.908561, 0.508663, -5.717769>, <-0.845990, 0.579802, -5.717769>, <-0.691320, 0.608738, -5.717769>, <-0.597517, 0.595441, -5.717769>, 
      <-0.919036, 0.541353, -5.721341>, <-0.851762, 0.617838, -5.721341>, <-0.697722, 0.645699, -5.722059>, <-0.596869, 0.631404, -5.722059>, 
      <-0.923207, 0.554469, -5.705061>, <-0.855933, 0.630954, -5.705061>, <-0.697013, 0.660008, -5.705061>, <-0.596160, 0.645712, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.114340, -0.013030, -5.723215>, <-1.090003, 0.148651, -5.723215>, <-1.010268, 0.366262, -5.723215>, <-0.902284, 0.489032, -5.723215>, 
      <-1.125398, -0.004718, -5.717769>, <-1.101061, 0.156963, -5.717769>, <-1.016545, 0.385893, -5.717769>, <-0.908561, 0.508663, -5.717769>, 
      <-1.146269, 0.011908, -5.718810>, <-1.120103, 0.185740, -5.718810>, <-1.035136, 0.409357, -5.721341>, <-0.919036, 0.541353, -5.721341>, 
      <-1.151200, 0.014675, -5.705061>, <-1.125034, 0.188507, -5.705061>, <-1.039307, 0.422473, -5.705061>, <-0.923207, 0.554469, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.150738, -1.161573, -5.723215>, <-1.227043, -0.825398, -5.725738>, <-1.165653, -0.353926, -5.723215>, <-1.114340, -0.013030, -5.723215>, 
      <-1.162617, -1.179157, -5.717769>, <-1.238922, -0.842981, -5.720291>, <-1.176711, -0.345614, -5.717769>, <-1.125398, -0.004718, -5.717769>, 
      <-1.187008, -1.209144, -5.723688>, <-1.269048, -0.847703, -5.726400>, <-1.201438, -0.354608, -5.718810>, <-1.146269, 0.011908, -5.718810>, 
      <-1.190334, -1.220186, -5.705061>, <-1.272374, -0.858745, -5.707773>, <-1.206369, -0.351840, -5.705061>, <-1.151200, 0.014675, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.150738, -1.161573, -5.723215>, <-1.162617, -1.179157, -5.717769>, <-1.187008, -1.209144, -5.723688>, <-1.190334, -1.220186, -5.705061>, 
      <-1.121278, -1.291363, -5.722242>, <-1.133157, -1.308947, -5.716795>, <-1.155334, -1.348688, -5.722641>, <-1.158660, -1.359730, -5.704014>, 
      <-0.921437, -1.386977, -5.712621>, <-0.925270, -1.410498, -5.706936>, <-0.940071, -1.447792, -5.712886>, <-0.943800, -1.462530, -5.693672>, 
      <-0.793868, -1.424928, -5.712621>, <-0.797701, -1.448450, -5.706936>, <-0.802914, -1.488596, -5.712886>, <-0.806643, -1.503334, -5.693672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.480784, -0.131601, -4.958485>, <-0.478117, -0.139816, -4.944252>, <-0.469981, -0.143737, -4.904636>, <-0.471894, -0.158983, -4.911043>, 
      <-0.547509, -0.164636, -4.954675>, <-0.544842, -0.172850, -4.940442>, <-0.543222, -0.179998, -4.900825>, <-0.545135, -0.195244, -4.907233>, 
      <-0.643442, -0.224214, -4.963522>, <-0.647670, -0.234716, -4.949289>, <-0.649942, -0.243699, -4.909441>, <-0.650410, -0.260623, -4.916080>, 
      <-0.716583, -0.209815, -4.964560>, <-0.720811, -0.220317, -4.950327>, <-0.730209, -0.227896, -4.910480>, <-0.730677, -0.244821, -4.917118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.397399, -0.051789, -4.982786>, <-0.392294, -0.057670, -4.968553>, <-0.380292, -0.056855, -4.928141>, <-0.380381, -0.071393, -4.935343>, 
      <-0.420527, -0.078441, -4.980144>, <-0.415422, -0.084322, -4.965911>, <-0.405595, -0.086012, -4.925507>, <-0.405684, -0.100551, -4.932709>, 
      <-0.449113, -0.115921, -4.960294>, <-0.446446, -0.124135, -4.946061>, <-0.435340, -0.126587, -4.906438>, <-0.437254, -0.141833, -4.912846>, 
      <-0.480784, -0.131601, -4.958485>, <-0.478117, -0.139816, -4.944252>, <-0.469981, -0.143737, -4.904636>, <-0.471894, -0.158983, -4.911043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.321270, 0.052213, -4.976709>, <-0.313939, 0.049373, -4.962476>, <-0.296702, 0.056443, -4.920504>, <-0.296832, 0.042747, -4.929267>, 
      <-0.336100, 0.016473, -4.975628>, <-0.328768, 0.013634, -4.961395>, <-0.312975, 0.017224, -4.919423>, <-0.313105, 0.003529, -4.928186>, 
      <-0.372099, -0.022635, -4.985677>, <-0.366994, -0.028516, -4.971444>, <-0.352518, -0.024850, -4.931032>, <-0.352607, -0.039388, -4.938234>, 
      <-0.397399, -0.051789, -4.982786>, <-0.392294, -0.057670, -4.968553>, <-0.380292, -0.056855, -4.928141>, <-0.380381, -0.071393, -4.935343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.314099, 0.148967, -4.988861>, <-0.306558, 0.148956, -4.974628>, <-0.290533, 0.161155, -4.931048>, <-0.288961, 0.148932, -4.941419>, 
      <-0.314103, 0.119677, -4.987276>, <-0.306561, 0.119666, -4.973044>, <-0.290536, 0.129044, -4.929465>, <-0.288965, 0.116821, -4.939836>, 
      <-0.310032, 0.079296, -4.977528>, <-0.302701, 0.076456, -4.963296>, <-0.284385, 0.086129, -4.921323>, <-0.284514, 0.072433, -4.930086>, 
      <-0.321270, 0.052213, -4.976709>, <-0.313939, 0.049373, -4.962476>, <-0.296702, 0.056443, -4.920504>, <-0.296832, 0.042747, -4.929267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.321243, 0.276842, -4.988861>, <-0.313911, 0.280571, -4.974628>, <-0.302331, 0.298444, -4.928948>, <-0.296802, 0.289272, -4.941419>, 
      <-0.308019, 0.240863, -4.986233>, <-0.300687, 0.244592, -4.972000>, <-0.287812, 0.258942, -4.926319>, <-0.282283, 0.249770, -4.938790>, 
      <-0.314094, 0.187333, -4.990937>, <-0.306553, 0.187323, -4.976704>, <-0.290527, 0.203271, -4.933124>, <-0.288956, 0.191049, -4.943495>, 
      <-0.314099, 0.148967, -4.988861>, <-0.306558, 0.148956, -4.974628>, <-0.290533, 0.161155, -4.931048>, <-0.288961, 0.148932, -4.941419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.405787, 0.398425, -5.007086>, <-0.400927, 0.405709, -4.992853>, <-0.399208, 0.419099, -4.946464>, <-0.389587, 0.422706, -4.959643>, 
      <-0.369344, 0.372530, -5.009311>, <-0.364484, 0.379814, -4.995078>, <-0.359255, 0.390709, -4.948687>, <-0.349634, 0.394317, -4.961866>, 
      <-0.336649, 0.318757, -4.991923>, <-0.329317, 0.322486, -4.977691>, <-0.319224, 0.344405, -4.932007>, <-0.313695, 0.335233, -4.944478>, 
      <-0.321243, 0.276842, -4.988861>, <-0.313911, 0.280571, -4.974628>, <-0.302331, 0.298444, -4.928948>, <-0.296802, 0.289272, -4.941419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.619732, 0.488941, -4.970634>, <-0.621128, 0.498872, -4.956402>, <-0.624732, 0.514506, -4.907503>, <-0.624386, 0.522044, -4.923193>, 
      <-0.549517, 0.482406, -4.972525>, <-0.550913, 0.492337, -4.958293>, <-0.547825, 0.507348, -4.909390>, <-0.547479, 0.514887, -4.925080>, 
      <-0.463221, 0.439236, -5.003579>, <-0.458361, 0.446520, -4.989346>, <-0.462124, 0.463806, -4.942964>, <-0.452504, 0.467413, -4.956142>, 
      <-0.405787, 0.398425, -5.007086>, <-0.400927, 0.405709, -4.992853>, <-0.399208, 0.419099, -4.946464>, <-0.389587, 0.422706, -4.959643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.856905, 0.440409, -4.994935>, <-0.865237, 0.448921, -4.980703>, <-0.879927, 0.464045, -4.930190>, <-0.884677, 0.468782, -4.947494>, 
      <-0.795546, 0.479796, -4.991542>, <-0.803878, 0.488308, -4.977310>, <-0.812633, 0.507242, -4.926800>, <-0.817382, 0.511979, -4.944104>, 
      <-0.692383, 0.495702, -4.968677>, <-0.693779, 0.505633, -4.954445>, <-0.704402, 0.521920, -4.905548>, <-0.704056, 0.529459, -4.921238>, 
      <-0.619732, 0.488941, -4.970634>, <-0.621128, 0.498872, -4.956402>, <-0.624732, 0.514506, -4.907503>, <-0.624386, 0.522044, -4.923193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.949371, 0.277343, -4.988861>, <-0.960407, 0.281086, -4.974628>, <-0.976363, 0.298633, -4.928581>, <-0.986156, 0.289821, -4.941419>, 
      <-0.943441, 0.333188, -4.992339>, <-0.954477, 0.336932, -4.978106>, <-0.969854, 0.359936, -4.932060>, <-0.979647, 0.351124, -4.944898>, 
      <-0.904205, 0.410047, -4.997550>, <-0.912536, 0.418559, -4.983318>, <-0.931843, 0.430720, -4.932806>, <-0.936592, 0.435457, -4.950110>, 
      <-0.856905, 0.440409, -4.994935>, <-0.865237, 0.448921, -4.980703>, <-0.879927, 0.464045, -4.930190>, <-0.884677, 0.468782, -4.947494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.908696, -0.047358, -4.964560>, <-0.918542, -0.053109, -4.950327>, <-0.938475, -0.050377, -4.909216>, <-0.941515, -0.066529, -4.917118>, 
      <-0.951097, 0.041374, -4.968986>, <-0.960942, 0.035623, -4.954754>, <-0.984995, 0.046976, -4.913640>, <-0.988035, 0.030823, -4.921543>, 
      <-0.959745, 0.179639, -4.982777>, <-0.970781, 0.183382, -4.968544>, <-0.987747, 0.191420, -4.922497>, <-0.997540, 0.182608, -4.935335>, 
      <-0.949371, 0.277343, -4.988861>, <-0.960407, 0.281086, -4.974628>, <-0.976363, 0.298633, -4.928581>, <-0.986156, 0.289821, -4.941419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.908696, -0.047358, -4.964560>, <-0.876186, -0.115392, -4.961166>, <-0.790633, -0.195237, -4.965612>, <-0.716583, -0.209815, -4.964560>, 
      <-0.918542, -0.053109, -4.950327>, <-0.886032, -0.121143, -4.946934>, <-0.794861, -0.205739, -4.951379>, <-0.720811, -0.220317, -4.950327>, 
      <-0.938475, -0.050377, -4.909216>, <-0.902790, -0.125055, -4.905821>, <-0.811478, -0.211897, -4.911531>, <-0.730209, -0.227896, -4.910480>, 
      <-0.941515, -0.066529, -4.917118>, <-0.905830, -0.141207, -4.913724>, <-0.811946, -0.228822, -4.918170>, <-0.730677, -0.244821, -4.917118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.560060, -0.763370, -5.224010>, <-0.602408, -0.806663, -5.224682>, <-0.677382, -0.884192, -5.219515>, <-0.734678, -0.864656, -5.221419>, 
      <-0.540652, -0.575134, -5.142886>, <-0.583000, -0.618428, -5.143558>, <-0.666761, -0.692435, -5.141865>, <-0.724057, -0.672899, -5.143769>, 
      <-0.495554, -0.347533, -4.990288>, <-0.568795, -0.383794, -4.986478>, <-0.655737, -0.453409, -4.991699>, <-0.736004, -0.437607, -4.992737>, 
      <-0.471894, -0.158983, -4.911043>, <-0.545135, -0.195244, -4.907233>, <-0.650410, -0.260623, -4.916080>, <-0.730677, -0.244821, -4.917118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.400286, -0.522798, -5.216115>, <-0.439577, -0.599969, -5.219679>, <-0.499459, -0.701415, -5.223049>, <-0.560060, -0.763370, -5.224010>, 
      <-0.403204, -0.383613, -5.138086>, <-0.442495, -0.460784, -5.141650>, <-0.480050, -0.513180, -5.141925>, <-0.540652, -0.575134, -5.142886>, 
      <-0.381258, -0.214398, -5.006184>, <-0.406560, -0.243555, -5.003550>, <-0.460913, -0.330382, -4.992091>, <-0.495554, -0.347533, -4.990288>, 
      <-0.380381, -0.071393, -4.935343>, <-0.405684, -0.100551, -4.932709>, <-0.437254, -0.141833, -4.912846>, <-0.471894, -0.158983, -4.911043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.324613, -0.300927, -5.202650>, <-0.343752, -0.368685, -5.204824>, <-0.368352, -0.460077, -5.213218>, <-0.400286, -0.522798, -5.216115>, 
      <-0.315039, -0.199284, -5.118966>, <-0.334178, -0.267042, -5.121140>, <-0.371270, -0.320892, -5.135188>, <-0.403204, -0.383613, -5.138086>, 
      <-0.297885, -0.068445, -5.000408>, <-0.314158, -0.107664, -4.999327>, <-0.353484, -0.182393, -5.009076>, <-0.381258, -0.214398, -5.006184>, 
      <-0.296832, 0.042747, -4.929267>, <-0.313105, 0.003529, -4.928186>, <-0.352607, -0.039388, -4.938234>, <-0.380381, -0.071393, -4.935343>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.281705, -0.102981, -5.202650>, <-0.295516, -0.162154, -5.202650>, <-0.308104, -0.242480, -5.200776>, <-0.324613, -0.300927, -5.202650>, 
      <-0.280286, -0.028914, -5.122838>, <-0.294097, -0.088087, -5.122838>, <-0.298530, -0.140837, -5.117092>, <-0.315039, -0.199284, -5.118966>, 
      <-0.278336, 0.066298, -5.011538>, <-0.278340, 0.034187, -5.009955>, <-0.285567, -0.038760, -5.001227>, <-0.297885, -0.068445, -5.000408>, 
      <-0.288961, 0.148932, -4.941419>, <-0.288965, 0.116821, -4.939836>, <-0.284514, 0.072433, -4.930086>, <-0.296832, 0.042747, -4.929267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.226459, 0.119612, -5.202650>, <-0.228774, 0.050847, -5.202650>, <-0.266066, -0.035978, -5.202650>, <-0.281705, -0.102981, -5.202650>, 
      <-0.252746, 0.161233, -5.120465>, <-0.255061, 0.092468, -5.120465>, <-0.264647, 0.038089, -5.122838>, <-0.280286, -0.028914, -5.122838>, 
      <-0.264579, 0.235820, -5.014099>, <-0.250060, 0.196318, -5.011469>, <-0.278331, 0.108414, -5.013614>, <-0.278336, 0.066298, -5.011538>, 
      <-0.296802, 0.289272, -4.941419>, <-0.282283, 0.249770, -4.938790>, <-0.288956, 0.191049, -4.943495>, <-0.288961, 0.148932, -4.941419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.263022, 0.451953, -5.202650>, <-0.200015, 0.373908, -5.202650>, <-0.223084, 0.219859, -5.202650>, <-0.226459, 0.119612, -5.202650>, 
      <-0.295775, 0.441376, -5.127492>, <-0.232768, 0.363331, -5.127492>, <-0.249371, 0.261480, -5.120465>, <-0.252746, 0.161233, -5.120465>, 
      <-0.341996, 0.440550, -5.024835>, <-0.302043, 0.412160, -5.027058>, <-0.281472, 0.281781, -5.017158>, <-0.264579, 0.235820, -5.014099>, 
      <-0.389587, 0.422706, -4.959643>, <-0.349634, 0.394317, -4.961866>, <-0.313695, 0.335233, -4.944478>, <-0.296802, 0.289272, -4.941419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.614617, 0.600414, -5.202650>, <-0.500397, 0.592461, -5.202650>, <-0.334944, 0.541041, -5.202650>, <-0.263022, 0.451953, -5.202650>, 
      <-0.619322, 0.562670, -5.124271>, <-0.505102, 0.554717, -5.124271>, <-0.367696, 0.530464, -5.127492>, <-0.295775, 0.441376, -5.127492>, 
      <-0.622655, 0.559765, -5.001705>, <-0.545748, 0.552608, -5.003592>, <-0.404912, 0.485257, -5.021335>, <-0.341996, 0.440550, -5.024835>, 
      <-0.624386, 0.522044, -4.923193>, <-0.547479, 0.514887, -4.925080>, <-0.452504, 0.467413, -4.956142>, <-0.389587, 0.422706, -4.959643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.913917, 0.497273, -5.202650>, <-0.844846, 0.562456, -5.202650>, <-0.709360, 0.607011, -5.202650>, <-0.614617, 0.600414, -5.202650>, 
      <-0.903286, 0.479332, -5.127987>, <-0.834215, 0.544515, -5.127987>, <-0.714064, 0.569266, -5.124271>, <-0.619322, 0.562670, -5.124271>, 
      <-0.904516, 0.488569, -5.019774>, <-0.837221, 0.531766, -5.016383>, <-0.702325, 0.567180, -4.999750>, <-0.622655, 0.559765, -5.001705>, 
      <-0.884677, 0.468782, -4.947494>, <-0.817382, 0.511979, -4.944104>, <-0.704056, 0.529459, -4.921238>, <-0.624386, 0.522044, -4.923193>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.112451, 0.130604, -5.202650>, <-1.101147, 0.255115, -5.198546>, <-1.004893, 0.411419, -5.202650>, <-0.913917, 0.497273, -5.202650>, 
      <-1.074932, 0.176057, -5.122743>, <-1.063628, 0.300568, -5.118639>, <-0.994262, 0.393477, -5.127987>, <-0.903286, 0.479332, -5.127987>, 
      <-1.039017, 0.242257, -5.010717>, <-1.032508, 0.303560, -5.014196>, <-0.956431, 0.455244, -5.022389>, <-0.904516, 0.488569, -5.019774>, 
      <-0.986156, 0.289821, -4.941419>, <-0.979647, 0.351124, -4.944898>, <-0.936592, 0.435457, -4.950110>, <-0.884677, 0.468782, -4.947494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.014303, -0.608492, -5.239100>, <-1.093761, -0.399157, -5.235152>, <-1.132687, -0.092301, -5.209998>, <-1.112451, 0.130604, -5.202650>, 
      <-0.982433, -0.440009, -5.156394>, <-1.061891, -0.230674, -5.152447>, <-1.095168, -0.046848, -5.130091>, <-1.074932, 0.176057, -5.122743>, 
      <-0.973248, -0.235141, -4.999613>, <-1.019768, -0.137789, -5.004038>, <-1.050401, 0.135044, -5.004633>, <-1.039017, 0.242257, -5.010717>, 
      <-0.941515, -0.066529, -4.917118>, <-0.988035, 0.030823, -4.921543>, <-0.997540, 0.182608, -4.935335>, <-0.986156, 0.289821, -4.941419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.014303, -0.608492, -5.239100>, <-0.982433, -0.440009, -5.156394>, <-0.973248, -0.235141, -4.999613>, <-0.941515, -0.066529, -4.917118>, 
      <-0.973893, -0.714954, -5.241108>, <-0.942024, -0.546470, -5.158402>, <-0.937564, -0.309819, -4.996219>, <-0.905830, -0.141207, -4.913724>, 
      <-0.842422, -0.827920, -5.224998>, <-0.831801, -0.636163, -5.147348>, <-0.817273, -0.421607, -4.993789>, <-0.811946, -0.228822, -4.918170>, 
      <-0.734678, -0.864656, -5.221419>, <-0.724057, -0.672899, -5.143769>, <-0.736004, -0.437607, -4.992737>, <-0.730677, -0.244821, -4.917118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.580901, -1.216217, -5.366679>, <-0.627822, -1.269641, -5.365395>, <-0.723289, -1.349031, -5.352001>, <-0.790571, -1.326196, -5.355011>, 
      <-0.584854, -1.083644, -5.314370>, <-0.631775, -1.137068, -5.313086>, <-0.704330, -1.213863, -5.302714>, <-0.771612, -1.191028, -5.305724>, 
      <-0.573500, -0.893719, -5.280187>, <-0.615848, -0.937013, -5.280858>, <-0.684822, -1.018523, -5.273912>, <-0.742118, -0.998987, -5.275815>, 
      <-0.560060, -0.763370, -5.224010>, <-0.602408, -0.806663, -5.224682>, <-0.677382, -0.884192, -5.219515>, <-0.734678, -0.864656, -5.221419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.364251, -0.840795, -5.366679>, <-0.402798, -0.964887, -5.371609>, <-0.495105, -1.118531, -5.369028>, <-0.580901, -1.216217, -5.366679>, 
      <-0.382007, -0.757428, -5.303491>, <-0.420554, -0.881521, -5.308421>, <-0.499058, -0.985958, -5.316718>, <-0.584854, -1.083644, -5.314370>, 
      <-0.398346, -0.615335, -5.267992>, <-0.437637, -0.692506, -5.271557>, <-0.512898, -0.831765, -5.279225>, <-0.573500, -0.893719, -5.280187>, 
      <-0.400286, -0.522798, -5.216115>, <-0.439577, -0.599969, -5.219679>, <-0.499459, -0.701415, -5.223049>, <-0.560060, -0.763370, -5.224010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343400, -0.451639, -5.336303>, <-0.356153, -0.568074, -5.341978>, <-0.329489, -0.728885, -5.362233>, <-0.364251, -0.840795, -5.366679>, 
      <-0.339651, -0.413903, -5.288915>, <-0.352405, -0.530338, -5.294590>, <-0.347245, -0.645518, -5.299045>, <-0.382007, -0.757428, -5.303491>, 
      <-0.329015, -0.347660, -5.241126>, <-0.348154, -0.415417, -5.243300>, <-0.366412, -0.552614, -5.265095>, <-0.398346, -0.615335, -5.267992>, 
      <-0.324613, -0.300927, -5.202650>, <-0.343752, -0.368685, -5.204824>, <-0.368352, -0.460077, -5.213218>, <-0.400286, -0.522798, -5.216115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.295983, -0.217523, -5.336303>, <-0.317801, -0.285782, -5.336303>, <-0.335607, -0.380488, -5.332836>, <-0.343400, -0.451639, -5.336303>, 
      <-0.293337, -0.189077, -5.291686>, <-0.315154, -0.257336, -5.291686>, <-0.331858, -0.342751, -5.285448>, <-0.339651, -0.413903, -5.288915>, 
      <-0.282396, -0.139016, -5.241481>, <-0.296206, -0.198189, -5.241481>, <-0.312506, -0.289213, -5.239252>, <-0.329015, -0.347660, -5.241126>, 
      <-0.281705, -0.102981, -5.202650>, <-0.295516, -0.162154, -5.202650>, <-0.308104, -0.242480, -5.200776>, <-0.324613, -0.300927, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.170499, 0.089291, -5.336303>, <-0.180566, -0.009643, -5.336303>, <-0.265706, -0.122799, -5.336303>, <-0.295983, -0.217523, -5.336303>, 
      <-0.179656, 0.096979, -5.293533>, <-0.189722, -0.001955, -5.293533>, <-0.263059, -0.094353, -5.291686>, <-0.293337, -0.189077, -5.291686>, 
      <-0.214273, 0.100318, -5.240749>, <-0.216588, 0.031553, -5.240749>, <-0.266757, -0.072013, -5.241481>, <-0.282396, -0.139016, -5.241481>, 
      <-0.226459, 0.119612, -5.202650>, <-0.228774, 0.050847, -5.202650>, <-0.266066, -0.035978, -5.202650>, <-0.281705, -0.102981, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.225445, 0.475712, -5.336303>, <-0.159651, 0.378852, -5.336303>, <-0.158646, 0.205782, -5.336303>, <-0.170499, 0.089291, -5.336303>, 
      <-0.232277, 0.463948, -5.296297>, <-0.166483, 0.367088, -5.296297>, <-0.167802, 0.213470, -5.293533>, <-0.179656, 0.096979, -5.293533>, 
      <-0.246280, 0.457360, -5.241069>, <-0.183273, 0.379315, -5.241069>, <-0.210898, 0.200565, -5.240749>, <-0.214273, 0.100318, -5.240749>, 
      <-0.263022, 0.451953, -5.202650>, <-0.200015, 0.373908, -5.202650>, <-0.223084, 0.219859, -5.202650>, <-0.226459, 0.119612, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.599588, 0.720984, -5.336303>, <-0.466349, 0.704856, -5.336303>, <-0.300858, 0.586733, -5.336303>, <-0.225445, 0.475712, -5.336303>, 
      <-0.603634, 0.696299, -5.288234>, <-0.470395, 0.680171, -5.288234>, <-0.307690, 0.574969, -5.296297>, <-0.232277, 0.463948, -5.296297>, 
      <-0.611691, 0.623891, -5.251401>, <-0.497471, 0.615938, -5.251401>, <-0.318201, 0.546447, -5.241069>, <-0.246280, 0.457360, -5.241069>, 
      <-0.614617, 0.600414, -5.202650>, <-0.500397, 0.592461, -5.202650>, <-0.334944, 0.541041, -5.202650>, <-0.263022, 0.451953, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.940039, 0.562211, -5.336303>, <-0.865962, 0.647141, -5.336303>, <-0.711468, 0.734527, -5.336303>, <-0.599588, 0.720984, -5.336303>, 
      <-0.934346, 0.540635, -5.296924>, <-0.860269, 0.625565, -5.296924>, <-0.715513, 0.709842, -5.288234>, <-0.603634, 0.696299, -5.288234>, 
      <-0.920124, 0.507748, -5.246243>, <-0.851053, 0.572931, -5.246243>, <-0.706433, 0.630487, -5.251401>, <-0.611691, 0.623891, -5.251401>, 
      <-0.913917, 0.497273, -5.202650>, <-0.844846, 0.562456, -5.202650>, <-0.709360, 0.607011, -5.202650>, <-0.614617, 0.600414, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.171567, 0.065203, -5.336303>, <-1.152709, 0.228510, -5.330702>, <-1.048159, 0.438251, -5.336303>, <-0.940039, 0.562211, -5.336303>, 
      <-1.158741, 0.079922, -5.292417>, <-1.139883, 0.243229, -5.286816>, <-1.042465, 0.416675, -5.296924>, <-0.934346, 0.540635, -5.296924>, 
      <-1.130601, 0.108616, -5.241306>, <-1.119297, 0.233127, -5.237202>, <-1.011100, 0.421894, -5.246243>, <-0.920124, 0.507748, -5.246243>, 
      <-1.112451, 0.130604, -5.202650>, <-1.101147, 0.255115, -5.198546>, <-1.004893, 0.411419, -5.202650>, <-0.913917, 0.497273, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.124112, -1.031857, -5.390980>, <-1.211214, -0.713761, -5.386702>, <-1.209381, -0.262264, -5.347535>, <-1.171567, 0.065203, -5.336303>, 
      <-1.091796, -0.906096, -5.341660>, <-1.178898, -0.587999, -5.337383>, <-1.196555, -0.247544, -5.303649>, <-1.158741, 0.079922, -5.292417>, 
      <-1.037555, -0.731418, -5.299442>, <-1.117013, -0.522083, -5.295494>, <-1.150837, -0.114289, -5.248654>, <-1.130601, 0.108616, -5.241306>, 
      <-1.014303, -0.608492, -5.239100>, <-1.093761, -0.399157, -5.235152>, <-1.132687, -0.092301, -5.209998>, <-1.112451, 0.130604, -5.202650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.124112, -1.031857, -5.390980>, <-1.091796, -0.906096, -5.341660>, <-1.037555, -0.731418, -5.299442>, <-1.014303, -0.608492, -5.239100>, 
      <-1.088755, -1.160981, -5.392716>, <-1.056439, -1.035219, -5.343396>, <-0.997145, -0.837880, -5.301450>, <-0.973893, -0.714954, -5.241108>, 
      <-0.917243, -1.283205, -5.360678>, <-0.898284, -1.148037, -5.311390>, <-0.849862, -0.962251, -5.279394>, <-0.842422, -0.827920, -5.224998>, 
      <-0.790571, -1.326196, -5.355011>, <-0.771612, -1.191028, -5.305724>, <-0.742118, -0.998987, -5.275815>, <-0.734678, -0.864656, -5.221419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.538720, -1.479080, -5.506407>, <-0.596614, -1.556222, -5.504399>, <-0.744741, -1.623809, -5.488423>, <-0.837384, -1.596904, -5.488423>, 
      <-0.558123, -1.432404, -5.431702>, <-0.616017, -1.509546, -5.429694>, <-0.740892, -1.581381, -5.407308>, <-0.833534, -1.554477, -5.407308>, 
      <-0.578400, -1.300089, -5.399773>, <-0.625322, -1.353513, -5.398488>, <-0.735259, -1.434371, -5.383119>, <-0.802541, -1.411536, -5.386129>, 
      <-0.580901, -1.216217, -5.366679>, <-0.627822, -1.269641, -5.365395>, <-0.723289, -1.349031, -5.352001>, <-0.790571, -1.326196, -5.355011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.538720, -1.479080, -5.506407>, <-0.525153, -1.511717, -5.558643>, <-0.502137, -1.458725, -5.650948>, <-0.493012, -1.427637, -5.705061>, 
      <-0.596614, -1.556222, -5.504399>, <-0.583046, -1.588859, -5.556636>, <-0.562742, -1.534257, -5.649517>, <-0.553617, -1.503169, -5.703630>, 
      <-0.744741, -1.623809, -5.488423>, <-0.747611, -1.655435, -5.548888>, <-0.724208, -1.572034, -5.640113>, <-0.713813, -1.530951, -5.693672>, 
      <-0.837384, -1.596904, -5.488423>, <-0.840253, -1.628531, -5.548888>, <-0.817039, -1.544418, -5.640113>, <-0.806643, -1.503334, -5.693672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.318714, -0.905790, -5.506407>, <-0.355365, -1.086324, -5.506407>, <-0.428168, -1.331773, -5.510240>, <-0.538720, -1.479080, -5.506407>, 
      <-0.324273, -0.897236, -5.459291>, <-0.360924, -1.077770, -5.459291>, <-0.447572, -1.285097, -5.435535>, <-0.558123, -1.432404, -5.431702>, 
      <-0.356184, -0.878672, -5.395388>, <-0.394731, -1.002765, -5.400318>, <-0.492604, -1.202403, -5.402121>, <-0.578400, -1.300089, -5.399773>, 
      <-0.364251, -0.840795, -5.366679>, <-0.402798, -0.964887, -5.371609>, <-0.495105, -1.118531, -5.369028>, <-0.580901, -1.216217, -5.366679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.318714, -0.905790, -5.506407>, <-0.311838, -0.916370, -5.564686>, <-0.317199, -0.912954, -5.646840>, <-0.324330, -0.902225, -5.705061>, 
      <-0.355365, -1.086324, -5.506407>, <-0.348490, -1.096904, -5.564686>, <-0.327125, -1.078203, -5.646840>, <-0.334256, -1.067475, -5.705061>, 
      <-0.428168, -1.331773, -5.510240>, <-0.414601, -1.364410, -5.562477>, <-0.398545, -1.329618, -5.653394>, <-0.389420, -1.298530, -5.707507>, 
      <-0.538720, -1.479080, -5.506407>, <-0.525153, -1.511717, -5.558643>, <-0.502137, -1.458725, -5.650948>, <-0.493012, -1.427637, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.348643, -0.542818, -5.506407>, <-0.352048, -0.652026, -5.506407>, <-0.296976, -0.798713, -5.506407>, <-0.318714, -0.905790, -5.506407>, 
      <-0.334387, -0.529887, -5.451777>, <-0.337792, -0.639095, -5.451777>, <-0.302534, -0.790160, -5.459291>, <-0.324273, -0.897236, -5.459291>, 
      <-0.346978, -0.487652, -5.381526>, <-0.359731, -0.604087, -5.387201>, <-0.321421, -0.766762, -5.390942>, <-0.356184, -0.878672, -5.395388>, 
      <-0.343400, -0.451639, -5.336303>, <-0.356153, -0.568074, -5.341978>, <-0.329489, -0.728885, -5.362233>, <-0.364251, -0.840795, -5.366679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.348643, -0.542818, -5.506407>, <-0.364779, -0.557454, -5.568242>, <-0.411358, -0.542977, -5.646048>, <-0.439629, -0.538925, -5.705061>, 
      <-0.352048, -0.652026, -5.506407>, <-0.368184, -0.666663, -5.568242>, <-0.397004, -0.656419, -5.646048>, <-0.425275, -0.652368, -5.705061>, 
      <-0.296976, -0.798713, -5.506407>, <-0.290100, -0.809293, -5.564686>, <-0.310343, -0.798812, -5.646840>, <-0.317474, -0.788084, -5.705061>, 
      <-0.318714, -0.905790, -5.506407>, <-0.311838, -0.916370, -5.564686>, <-0.317199, -0.912954, -5.646840>, <-0.324330, -0.902225, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.299723, -0.296645, -5.506407>, <-0.321887, -0.368605, -5.506407>, <-0.346297, -0.467559, -5.506407>, <-0.348643, -0.542818, -5.506407>, 
      <-0.284930, -0.283620, -5.453678>, <-0.307094, -0.355580, -5.453678>, <-0.332041, -0.454628, -5.451777>, <-0.334387, -0.529887, -5.451777>, 
      <-0.298795, -0.247748, -5.383710>, <-0.320613, -0.316007, -5.383710>, <-0.339184, -0.416500, -5.378059>, <-0.346978, -0.487652, -5.381526>, 
      <-0.295983, -0.217523, -5.336303>, <-0.317801, -0.285782, -5.336303>, <-0.335607, -0.380488, -5.332836>, <-0.343400, -0.451639, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.299723, -0.296645, -5.506407>, <-0.317273, -0.312097, -5.568959>, <-0.368138, -0.303982, -5.646254>, <-0.399441, -0.308613, -5.705061>, 
      <-0.321887, -0.368605, -5.506407>, <-0.339437, -0.384057, -5.568959>, <-0.386388, -0.371703, -5.646254>, <-0.417691, -0.376335, -5.705061>, 
      <-0.346297, -0.467559, -5.506407>, <-0.362433, -0.482195, -5.568242>, <-0.420162, -0.473394, -5.646048>, <-0.448433, -0.469342, -5.705061>, 
      <-0.348643, -0.542818, -5.506407>, <-0.364779, -0.557454, -5.568242>, <-0.411358, -0.542977, -5.646048>, <-0.439629, -0.538925, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.161429, 0.065011, -5.506407>, <-0.173640, -0.050504, -5.506407>, <-0.265531, -0.185633, -5.506407>, <-0.299723, -0.296645, -5.506407>, 
      <-0.146097, 0.073047, -5.457776>, <-0.158308, -0.042468, -5.457776>, <-0.250737, -0.172608, -5.453678>, <-0.284930, -0.283620, -5.453678>, 
      <-0.159856, 0.080355, -5.386017>, <-0.169923, -0.018579, -5.386017>, <-0.268518, -0.153024, -5.383710>, <-0.298795, -0.247748, -5.383710>, 
      <-0.170499, 0.089291, -5.336303>, <-0.180566, -0.009643, -5.336303>, <-0.265706, -0.122799, -5.336303>, <-0.295983, -0.217523, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.161429, 0.065011, -5.506407>, <-0.182612, 0.053908, -5.573596>, <-0.247574, 0.045544, -5.648004>, <-0.286758, 0.028355, -5.705061>, 
      <-0.173640, -0.050504, -5.506407>, <-0.194822, -0.061607, -5.573596>, <-0.267664, -0.059138, -5.648004>, <-0.306848, -0.076328, -5.705061>, 
      <-0.265531, -0.185633, -5.506407>, <-0.283080, -0.201084, -5.568959>, <-0.340403, -0.201060, -5.646254>, <-0.371706, -0.205692, -5.705061>, 
      <-0.299723, -0.296645, -5.506407>, <-0.317273, -0.312097, -5.568959>, <-0.368138, -0.303982, -5.646254>, <-0.399441, -0.308613, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.211150, 0.541274, -5.506407>, <-0.135585, 0.419098, -5.506407>, <-0.146328, 0.207871, -5.506407>, <-0.161429, 0.065011, -5.506407>, 
      <-0.207205, 0.543702, -5.451744>, <-0.131640, 0.421527, -5.451744>, <-0.130996, 0.215907, -5.457776>, <-0.146097, 0.073047, -5.457776>, 
      <-0.216576, 0.490984, -5.388241>, <-0.150782, 0.394125, -5.388241>, <-0.148003, 0.196846, -5.386017>, <-0.159856, 0.080355, -5.386017>, 
      <-0.225445, 0.475712, -5.336303>, <-0.159651, 0.378852, -5.336303>, <-0.158646, 0.205782, -5.336303>, <-0.170499, 0.089291, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.211150, 0.541274, -5.506407>, <-0.215870, 0.538370, -5.571797>, <-0.235617, 0.493923, -5.651772>, <-0.252061, 0.459333, -5.705061>, 
      <-0.135585, 0.419098, -5.506407>, <-0.140305, 0.416194, -5.571797>, <-0.177499, 0.377960, -5.651772>, <-0.193943, 0.343370, -5.705061>, 
      <-0.146328, 0.207871, -5.506407>, <-0.167511, 0.196768, -5.573596>, <-0.223127, 0.172931, -5.648004>, <-0.262311, 0.155742, -5.705061>, 
      <-0.161429, 0.065011, -5.506407>, <-0.182612, 0.053908, -5.573596>, <-0.247574, 0.045544, -5.648004>, <-0.286758, 0.028355, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.589051, 0.756404, -5.506407>, <-0.460317, 0.735296, -5.506407>, <-0.279770, 0.652222, -5.506407>, <-0.211150, 0.541274, -5.506407>, 
      <-0.589527, 0.766848, -5.455243>, <-0.460792, 0.745740, -5.455243>, <-0.275825, 0.654650, -5.451744>, <-0.207205, 0.543702, -5.451744>, 
      <-0.595689, 0.744773, -5.382628>, <-0.462450, 0.728645, -5.382628>, <-0.291989, 0.602005, -5.388241>, <-0.216576, 0.490984, -5.388241>, 
      <-0.599588, 0.720984, -5.336303>, <-0.466349, 0.704856, -5.336303>, <-0.300858, 0.586733, -5.336303>, <-0.225445, 0.475712, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.589051, 0.756404, -5.506407>, <-0.588429, 0.742753, -5.573282>, <-0.593982, 0.689647, -5.652869>, <-0.596160, 0.645712, -5.705061>, 
      <-0.460317, 0.735296, -5.506407>, <-0.459695, 0.721645, -5.573282>, <-0.477744, 0.673170, -5.652869>, <-0.479922, 0.629235, -5.705061>, 
      <-0.279770, 0.652222, -5.506407>, <-0.284490, 0.649317, -5.571797>, <-0.288218, 0.598879, -5.651772>, <-0.304662, 0.564289, -5.705061>, 
      <-0.211150, 0.541274, -5.506407>, <-0.215870, 0.538370, -5.571797>, <-0.235617, 0.493923, -5.651772>, <-0.252061, 0.459333, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.957834, 0.663706, -5.506407>, <-0.884414, 0.750999, -5.508102>, <-0.701624, 0.774862, -5.506407>, <-0.589051, 0.756404, -5.506407>, 
      <-0.960554, 0.664957, -5.446818>, <-0.887134, 0.752250, -5.448512>, <-0.702100, 0.785306, -5.455243>, <-0.589527, 0.766848, -5.455243>, 
      <-0.947544, 0.590653, -5.388212>, <-0.873467, 0.675582, -5.388212>, <-0.707569, 0.758316, -5.382628>, <-0.595689, 0.744773, -5.382628>, 
      <-0.940039, 0.562211, -5.336303>, <-0.865962, 0.647141, -5.336303>, <-0.711468, 0.734527, -5.336303>, <-0.599588, 0.720984, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.957834, 0.663706, -5.506407>, <-0.954697, 0.662263, -5.575121>, <-0.936669, 0.596799, -5.652520>, <-0.923207, 0.554469, -5.705061>, 
      <-0.884414, 0.750999, -5.508102>, <-0.881278, 0.749557, -5.576816>, <-0.869395, 0.673284, -5.652520>, <-0.855933, 0.630954, -5.705061>, 
      <-0.701624, 0.774862, -5.506407>, <-0.701003, 0.761212, -5.573282>, <-0.694835, 0.703943, -5.652869>, <-0.697013, 0.660008, -5.705061>, 
      <-0.589051, 0.756404, -5.506407>, <-0.588429, 0.742753, -5.573282>, <-0.593982, 0.689647, -5.652869>, <-0.596160, 0.645712, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.197124, 0.033431, -5.492372>, <-1.173310, 0.234319, -5.492372>, <-1.088032, 0.508907, -5.503402>, <-0.957834, 0.663706, -5.506407>, 
      <-1.199768, 0.039991, -5.444500>, <-1.175954, 0.240879, -5.444500>, <-1.090751, 0.510158, -5.443813>, <-0.960554, 0.664957, -5.446818>, 
      <-1.184489, 0.050373, -5.380518>, <-1.165631, 0.213680, -5.374916>, <-1.055664, 0.466692, -5.388212>, <-0.947544, 0.590653, -5.388212>, 
      <-1.171567, 0.065203, -5.336303>, <-1.152709, 0.228510, -5.330702>, <-1.048159, 0.438251, -5.336303>, <-0.940039, 0.562211, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.197124, 0.033431, -5.492372>, <-1.193544, 0.024550, -5.557188>, <-1.172931, 0.026871, -5.644466>, <-1.151200, 0.014675, -5.705061>, 
      <-1.173310, 0.234319, -5.492372>, <-1.169730, 0.225438, -5.557188>, <-1.146765, 0.200703, -5.644466>, <-1.125034, 0.188507, -5.705061>, 
      <-1.088032, 0.508907, -5.503402>, <-1.084895, 0.507464, -5.572116>, <-1.052769, 0.464803, -5.652520>, <-1.039307, 0.422473, -5.705061>, 
      <-0.957834, 0.663706, -5.506407>, <-0.954697, 0.662263, -5.575121>, <-0.936669, 0.596799, -5.652520>, <-0.923207, 0.554469, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.189448, -1.290099, -5.506407>, <-1.275009, -0.902340, -5.507346>, <-1.243870, -0.360896, -5.492372>, <-1.197124, 0.033431, -5.492372>, 
      <-1.173950, -1.246025, -5.432904>, <-1.259511, -0.858266, -5.433844>, <-1.246514, -0.354336, -5.444500>, <-1.199768, 0.039991, -5.444500>, 
      <-1.144375, -1.110713, -5.421905>, <-1.231477, -0.792617, -5.417628>, <-1.222303, -0.277093, -5.391749>, <-1.184489, 0.050373, -5.380518>, 
      <-1.124112, -1.031857, -5.390980>, <-1.211214, -0.713761, -5.386702>, <-1.209381, -0.262264, -5.347535>, <-1.171567, 0.065203, -5.336303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.189448, -1.290099, -5.506407>, <-1.200690, -1.322071, -5.559727>, <-1.199925, -1.252031, -5.651343>, <-1.190334, -1.220186, -5.705061>, 
      <-1.275009, -0.902340, -5.507346>, <-1.286251, -0.934312, -5.560666>, <-1.281965, -0.890590, -5.654055>, <-1.272374, -0.858745, -5.707773>, 
      <-1.243870, -0.360896, -5.492372>, <-1.240290, -0.369777, -5.557188>, <-1.228100, -0.339645, -5.644466>, <-1.206369, -0.351840, -5.705061>, 
      <-1.197124, 0.033431, -5.492372>, <-1.193544, 0.024550, -5.557188>, <-1.172931, 0.026871, -5.644466>, <-1.151200, 0.014675, -5.705061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.189448, -1.290099, -5.506407>, <-1.173950, -1.246025, -5.432904>, <-1.144375, -1.110713, -5.421905>, <-1.124112, -1.031857, -5.390980>, 
      <-1.159239, -1.427006, -5.506075>, <-1.143741, -1.382932, -5.432573>, <-1.109018, -1.239837, -5.423641>, <-1.088755, -1.160981, -5.392716>, 
      <-0.972022, -1.557803, -5.488423>, <-0.968172, -1.515376, -5.407308>, <-0.929213, -1.368545, -5.391796>, <-0.917243, -1.283205, -5.360678>, 
      <-0.837384, -1.596904, -5.488423>, <-0.833534, -1.554477, -5.407308>, <-0.802541, -1.411536, -5.386129>, <-0.790571, -1.326196, -5.355011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.189448, -1.290099, -5.506407>, <-1.159239, -1.427006, -5.506075>, <-0.972022, -1.557803, -5.488423>, <-0.837384, -1.596904, -5.488423>, 
      <-1.200690, -1.322071, -5.559727>, <-1.170481, -1.458978, -5.559396>, <-0.974891, -1.589430, -5.548888>, <-0.840253, -1.628531, -5.548888>, 
      <-1.199925, -1.252031, -5.651343>, <-1.168251, -1.391575, -5.650296>, <-0.954195, -1.503614, -5.640113>, <-0.817039, -1.544418, -5.640113>, 
      <-1.190334, -1.220186, -5.705061>, <-1.158660, -1.359730, -5.704014>, <-0.943800, -1.462530, -5.693672>, <-0.806643, -1.503334, -5.693672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.716766, -1.354523, -5.747868>, <0.773135, -1.424776, -5.746537>, <0.922133, -1.450614, -5.737274>, <1.008474, -1.424928, -5.737274>, 
      <0.714022, -1.376457, -5.742422>, <0.770390, -1.446710, -5.741091>, <0.925965, -1.474136, -5.731589>, <1.012307, -1.448450, -5.731589>, 
      <0.704324, -1.416415, -5.749248>, <0.764929, -1.491948, -5.747816>, <0.924689, -1.516213, -5.737539>, <1.017520, -1.488596, -5.737539>, 
      <0.707618, -1.427637, -5.729715>, <0.768223, -1.503169, -5.728284>, <0.928419, -1.530951, -5.718325>, <1.021249, -1.503334, -5.718325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.559876, -0.865838, -5.747868>, <0.569108, -1.019537, -5.747868>, <0.620415, -1.234440, -5.750144>, <0.716766, -1.354523, -5.747868>, 
      <0.553594, -0.876754, -5.742422>, <0.562826, -1.030453, -5.742422>, <0.617671, -1.256375, -5.744698>, <0.714022, -1.376457, -5.742422>, 
      <0.540577, -0.899756, -5.743112>, <0.550503, -1.065006, -5.743112>, <0.600732, -1.287308, -5.751694>, <0.704324, -1.416415, -5.749248>, 
      <0.538936, -0.902225, -5.729715>, <0.548862, -1.067475, -5.729715>, <0.604026, -1.298530, -5.732161>, <0.707618, -1.427637, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.667115, -0.527932, -5.747868>, <0.653764, -0.633445, -5.747868>, <0.553499, -0.759675, -5.747868>, <0.559876, -0.865838, -5.747868>, 
      <0.663251, -0.531230, -5.742422>, <0.649900, -0.636743, -5.742422>, <0.547217, -0.770591, -5.742422>, <0.553594, -0.876754, -5.742422>, 
      <0.657447, -0.538465, -5.736419>, <0.643092, -0.651907, -5.736419>, <0.533721, -0.785615, -5.743112>, <0.540577, -0.899756, -5.743112>, 
      <0.654235, -0.538925, -5.729715>, <0.639881, -0.652368, -5.729715>, <0.532080, -0.788084, -5.729715>, <0.538936, -0.902225, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.629737, -0.313720, -5.747868>, <0.646711, -0.376708, -5.747868>, <0.675304, -0.463214, -5.747868>, <0.667115, -0.527932, -5.747868>, 
      <0.625030, -0.312188, -5.742422>, <0.642004, -0.375176, -5.742422>, <0.671440, -0.466511, -5.742422>, <0.663251, -0.531230, -5.742422>, 
      <0.617497, -0.309123, -5.736196>, <0.635746, -0.376845, -5.736196>, <0.666251, -0.468882, -5.736419>, <0.657447, -0.538465, -5.736419>, 
      <0.614047, -0.308613, -5.729715>, <0.632297, -0.376335, -5.729715>, <0.663040, -0.469342, -5.729715>, <0.654235, -0.538925, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.524930, -0.000307, -5.747868>, <0.543616, -0.097672, -5.747868>, <0.603940, -0.217993, -5.747868>, <0.629737, -0.313720, -5.747868>, 
      <0.517860, 0.008292, -5.742422>, <0.536546, -0.089073, -5.742422>, <0.599233, -0.216461, -5.742422>, <0.625030, -0.312188, -5.742422>, 
      <0.508173, 0.025368, -5.739629>, <0.528263, -0.079314, -5.739629>, <0.589762, -0.206202, -5.736196>, <0.617497, -0.309123, -5.736196>, 
      <0.501364, 0.028355, -5.729715>, <0.521454, -0.076328, -5.729715>, <0.586312, -0.205692, -5.729715>, <0.614047, -0.308613, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.492659, 0.400545, -5.747868>, <0.438604, 0.292688, -5.747868>, <0.502192, 0.118176, -5.747868>, <0.524930, -0.000307, -5.747868>, 
      <0.484861, 0.418181, -5.742422>, <0.430806, 0.310324, -5.742422>, <0.495122, 0.126774, -5.742422>, <0.517860, 0.008292, -5.742422>, 
      <0.471688, 0.448771, -5.745986>, <0.413570, 0.332808, -5.745986>, <0.483725, 0.152755, -5.739629>, <0.508173, 0.025368, -5.739629>, 
      <0.466667, 0.459333, -5.729715>, <0.408550, 0.343370, -5.729715>, <0.476917, 0.155742, -5.729715>, <0.501364, 0.028355, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.812704, 0.573897, -5.747868>, <0.704592, 0.558572, -5.747868>, <0.541583, 0.498165, -5.747868>, <0.492659, 0.400545, -5.747868>, 
      <0.812123, 0.595441, -5.742422>, <0.704010, 0.580116, -5.742422>, <0.533786, 0.515801, -5.742422>, <0.484861, 0.418181, -5.742422>, 
      <0.811475, 0.631404, -5.746713>, <0.695237, 0.614927, -5.746713>, <0.524289, 0.553728, -5.745986>, <0.471688, 0.448771, -5.745986>, 
      <0.810766, 0.645712, -5.729715>, <0.694528, 0.629235, -5.729715>, <0.519268, 0.564289, -5.729715>, <0.466667, 0.459333, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.116890, 0.489032, -5.747868>, <1.054319, 0.560170, -5.747868>, <0.906507, 0.587194, -5.747868>, <0.812704, 0.573897, -5.747868>, 
      <1.123167, 0.508663, -5.742422>, <1.060596, 0.579802, -5.742422>, <0.905926, 0.608738, -5.742422>, <0.812123, 0.595441, -5.742422>, 
      <1.133642, 0.541353, -5.745994>, <1.066368, 0.617838, -5.745994>, <0.912328, 0.645699, -5.746713>, <0.811475, 0.631404, -5.746713>, 
      <1.137813, 0.554469, -5.729715>, <1.070540, 0.630954, -5.729715>, <0.911619, 0.660008, -5.729715>, <0.810766, 0.645712, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.328946, -0.013030, -5.747868>, <1.304609, 0.148651, -5.747868>, <1.224874, 0.366262, -5.747868>, <1.116890, 0.489032, -5.747868>, 
      <1.340004, -0.004718, -5.742422>, <1.315667, 0.156963, -5.742422>, <1.231151, 0.385893, -5.742422>, <1.123167, 0.508663, -5.742422>, 
      <1.360875, 0.011908, -5.743464>, <1.334709, 0.185740, -5.743464>, <1.249742, 0.409357, -5.745994>, <1.133642, 0.541353, -5.745994>, 
      <1.365806, 0.014675, -5.729715>, <1.339640, 0.188507, -5.729715>, <1.253913, 0.422473, -5.729715>, <1.137813, 0.554469, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.365344, -1.161573, -5.747868>, <1.441649, -0.825398, -5.750390>, <1.380259, -0.353926, -5.747868>, <1.328946, -0.013030, -5.747868>, 
      <1.377223, -1.179157, -5.742422>, <1.453528, -0.842981, -5.744944>, <1.391317, -0.345614, -5.742422>, <1.340004, -0.004718, -5.742422>, 
      <1.401614, -1.209144, -5.748342>, <1.483654, -0.847703, -5.751054>, <1.416044, -0.354608, -5.743464>, <1.360875, 0.011908, -5.743464>, 
      <1.404940, -1.220186, -5.729715>, <1.486980, -0.858745, -5.732427>, <1.420975, -0.351840, -5.729715>, <1.365806, 0.014675, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.365344, -1.161573, -5.747868>, <1.377223, -1.179157, -5.742422>, <1.401614, -1.209144, -5.748342>, <1.404940, -1.220186, -5.729715>, 
      <1.335884, -1.291363, -5.746894>, <1.347763, -1.308947, -5.741448>, <1.369941, -1.348688, -5.747295>, <1.373266, -1.359730, -5.728668>, 
      <1.136043, -1.386977, -5.737274>, <1.139876, -1.410498, -5.731589>, <1.154677, -1.447792, -5.737539>, <1.158406, -1.462530, -5.718325>, 
      <1.008474, -1.424928, -5.737274>, <1.012307, -1.448450, -5.731589>, <1.017520, -1.488596, -5.737539>, <1.021249, -1.503334, -5.718325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.695390, -0.131601, -4.983138>, <0.692723, -0.139816, -4.968906>, <0.684587, -0.143737, -4.929288>, <0.686500, -0.158983, -4.935696>, 
      <0.762115, -0.164636, -4.979328>, <0.759448, -0.172850, -4.965095>, <0.757828, -0.179998, -4.925478>, <0.759741, -0.195244, -4.931885>, 
      <0.858048, -0.224214, -4.988174>, <0.862276, -0.234716, -4.973942>, <0.864548, -0.243699, -4.934094>, <0.865016, -0.260623, -4.940732>, 
      <0.931189, -0.209815, -4.989213>, <0.935417, -0.220317, -4.974980>, <0.944815, -0.227896, -4.935132>, <0.945283, -0.244821, -4.941771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.612005, -0.051789, -5.007439>, <0.606900, -0.057670, -4.993206>, <0.594898, -0.056855, -4.952794>, <0.594987, -0.071393, -4.959996>, 
      <0.635133, -0.078441, -5.004796>, <0.630028, -0.084322, -4.990563>, <0.620201, -0.086013, -4.950160>, <0.620290, -0.100551, -4.957362>, 
      <0.663719, -0.115921, -4.984947>, <0.661052, -0.124135, -4.970714>, <0.649946, -0.126587, -4.931091>, <0.651860, -0.141833, -4.937498>, 
      <0.695390, -0.131601, -4.983138>, <0.692723, -0.139816, -4.968906>, <0.684587, -0.143737, -4.929288>, <0.686500, -0.158983, -4.935696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.535876, 0.052213, -5.001363>, <0.528545, 0.049373, -4.987130>, <0.511308, 0.056443, -4.945158>, <0.511438, 0.042747, -4.953921>, 
      <0.550705, 0.016473, -5.000281>, <0.543374, 0.013634, -4.986049>, <0.527581, 0.017224, -4.944076>, <0.527711, 0.003529, -4.952839>, 
      <0.586705, -0.022635, -5.010330>, <0.581600, -0.028516, -4.996097>, <0.567124, -0.024850, -4.955686>, <0.567213, -0.039388, -4.962888>, 
      <0.612005, -0.051789, -5.007439>, <0.606900, -0.057670, -4.993206>, <0.594898, -0.056855, -4.952794>, <0.594987, -0.071393, -4.959996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.528705, 0.148967, -5.013514>, <0.521164, 0.148956, -4.999282>, <0.505139, 0.161155, -4.955700>, <0.503567, 0.148932, -4.966072>, 
      <0.528709, 0.119677, -5.011930>, <0.521167, 0.119666, -4.997697>, <0.505143, 0.129044, -4.954118>, <0.503571, 0.116821, -4.964490>, 
      <0.524638, 0.079296, -5.002182>, <0.517307, 0.076456, -4.987950>, <0.498991, 0.086129, -4.945977>, <0.499121, 0.072433, -4.954740>, 
      <0.535876, 0.052213, -5.001363>, <0.528545, 0.049373, -4.987130>, <0.511308, 0.056443, -4.945158>, <0.511438, 0.042747, -4.953921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.535849, 0.276842, -5.013514>, <0.528517, 0.280571, -4.999282>, <0.516937, 0.298444, -4.953601>, <0.511408, 0.289272, -4.966072>, 
      <0.522625, 0.240863, -5.010885>, <0.515293, 0.244592, -4.996653>, <0.502418, 0.258942, -4.950971>, <0.496889, 0.249770, -4.963442>, 
      <0.528700, 0.187333, -5.015589>, <0.521159, 0.187323, -5.001357>, <0.505133, 0.203271, -4.957776>, <0.503562, 0.191049, -4.968148>, 
      <0.528705, 0.148967, -5.013514>, <0.521164, 0.148956, -4.999282>, <0.505139, 0.161155, -4.955700>, <0.503567, 0.148932, -4.966072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.620393, 0.398425, -5.031739>, <0.615533, 0.405709, -5.017506>, <0.613814, 0.419099, -4.971118>, <0.604193, 0.422706, -4.984297>, 
      <0.583950, 0.372530, -5.033965>, <0.579090, 0.379814, -5.019732>, <0.573861, 0.390709, -4.973341>, <0.564240, 0.394317, -4.986520>, 
      <0.551255, 0.318757, -5.016576>, <0.543923, 0.322486, -5.002344>, <0.533830, 0.344405, -4.956660>, <0.528301, 0.335233, -4.969132>, 
      <0.535849, 0.276842, -5.013514>, <0.528517, 0.280571, -4.999282>, <0.516937, 0.298444, -4.953601>, <0.511408, 0.289272, -4.966072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.834338, 0.488941, -4.995288>, <0.835734, 0.498872, -4.981055>, <0.839338, 0.514505, -4.932156>, <0.838992, 0.522044, -4.947846>, 
      <0.764123, 0.482406, -4.997180>, <0.765519, 0.492337, -4.982947>, <0.762431, 0.507348, -4.934043>, <0.762085, 0.514887, -4.949733>, 
      <0.677827, 0.439236, -5.028232>, <0.672967, 0.446520, -5.014000>, <0.676730, 0.463806, -4.967618>, <0.667110, 0.467413, -4.980796>, 
      <0.620393, 0.398425, -5.031739>, <0.615533, 0.405709, -5.017506>, <0.613814, 0.419099, -4.971118>, <0.604193, 0.422706, -4.984297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.071511, 0.440409, -5.019588>, <1.079843, 0.448921, -5.005356>, <1.094534, 0.464045, -4.954843>, <1.099283, 0.468782, -4.972147>, 
      <1.010152, 0.479796, -5.016195>, <1.018484, 0.488308, -5.001963>, <1.027239, 0.507242, -4.951453>, <1.031988, 0.511979, -4.968757>, 
      <0.906989, 0.495702, -4.993331>, <0.908385, 0.505633, -4.979098>, <0.919008, 0.521920, -4.930200>, <0.918662, 0.529459, -4.945891>, 
      <0.834338, 0.488941, -4.995288>, <0.835734, 0.498872, -4.981055>, <0.839338, 0.514505, -4.932156>, <0.838992, 0.522044, -4.947846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.163977, 0.277343, -5.013514>, <1.175013, 0.281086, -4.999282>, <1.190969, 0.298633, -4.953234>, <1.200762, 0.289821, -4.966072>, 
      <1.158047, 0.333188, -5.016992>, <1.169083, 0.336932, -5.002759>, <1.184460, 0.359936, -4.956713>, <1.194253, 0.351124, -4.969551>, 
      <1.118811, 0.410047, -5.022203>, <1.127142, 0.418559, -5.007971>, <1.146449, 0.430720, -4.957458>, <1.151198, 0.435457, -4.974762>, 
      <1.071511, 0.440409, -5.019588>, <1.079843, 0.448921, -5.005356>, <1.094534, 0.464045, -4.954843>, <1.099283, 0.468782, -4.972147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.123302, -0.047358, -4.989213>, <1.133148, -0.053109, -4.974980>, <1.153081, -0.050377, -4.933868>, <1.156121, -0.066529, -4.941771>, 
      <1.165703, 0.041374, -4.993639>, <1.175548, 0.035623, -4.979406>, <1.199601, 0.046976, -4.938294>, <1.202641, 0.030823, -4.946196>, 
      <1.174351, 0.179639, -5.007430>, <1.185387, 0.183382, -4.993197>, <1.202353, 0.191420, -4.947151>, <1.212146, 0.182608, -4.959988>, 
      <1.163977, 0.277343, -5.013514>, <1.175013, 0.281086, -4.999282>, <1.190969, 0.298633, -4.953234>, <1.200762, 0.289821, -4.966072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.123302, -0.047358, -4.989213>, <1.090792, -0.115392, -4.985819>, <1.005239, -0.195237, -4.990264>, <0.931189, -0.209815, -4.989213>, 
      <1.133148, -0.053109, -4.974980>, <1.100638, -0.121143, -4.971587>, <1.009467, -0.205739, -4.976032>, <0.935417, -0.220317, -4.974980>, 
      <1.153081, -0.050377, -4.933868>, <1.117396, -0.125055, -4.930474>, <1.026084, -0.211897, -4.936184>, <0.944815, -0.227896, -4.935132>, 
      <1.156121, -0.066529, -4.941771>, <1.120436, -0.141207, -4.938377>, <1.026552, -0.228822, -4.942822>, <0.945283, -0.244821, -4.941771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.774666, -0.763370, -5.248664>, <0.817014, -0.806663, -5.249336>, <0.891988, -0.884192, -5.244169>, <0.949284, -0.864656, -5.246073>, 
      <0.755258, -0.575134, -5.167540>, <0.797606, -0.618428, -5.168212>, <0.881367, -0.692435, -5.166519>, <0.938663, -0.672899, -5.168423>, 
      <0.710160, -0.347533, -5.014942>, <0.783401, -0.383793, -5.011131>, <0.870343, -0.453409, -5.016352>, <0.950610, -0.437607, -5.017391>, 
      <0.686500, -0.158983, -4.935696>, <0.759741, -0.195244, -4.931885>, <0.865016, -0.260623, -4.940732>, <0.945283, -0.244821, -4.941771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.614892, -0.522798, -5.240769>, <0.654183, -0.599969, -5.244333>, <0.714064, -0.701415, -5.247702>, <0.774666, -0.763370, -5.248664>, 
      <0.617810, -0.383613, -5.162740>, <0.657101, -0.460784, -5.166304>, <0.694656, -0.513180, -5.166579>, <0.755258, -0.575134, -5.167540>, 
      <0.595863, -0.214397, -5.030838>, <0.621167, -0.243555, -5.028204>, <0.675519, -0.330382, -5.016744>, <0.710160, -0.347533, -5.014942>, 
      <0.594987, -0.071393, -4.959996>, <0.620290, -0.100551, -4.957362>, <0.651860, -0.141833, -4.937498>, <0.686500, -0.158983, -4.935696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.539219, -0.300927, -5.227303>, <0.558358, -0.368685, -5.229476>, <0.582958, -0.460077, -5.237872>, <0.614892, -0.522798, -5.240769>, 
      <0.529645, -0.199284, -5.143619>, <0.548784, -0.267042, -5.145792>, <0.585876, -0.320891, -5.159842>, <0.617810, -0.383613, -5.162740>, 
      <0.512491, -0.068445, -5.025062>, <0.528764, -0.107664, -5.023981>, <0.568090, -0.182393, -5.033730>, <0.595863, -0.214397, -5.030838>, 
      <0.511438, 0.042747, -4.953921>, <0.527711, 0.003529, -4.952839>, <0.567213, -0.039388, -4.962888>, <0.594987, -0.071393, -4.959996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.496311, -0.102981, -5.227303>, <0.510122, -0.162154, -5.227303>, <0.522710, -0.242480, -5.225428>, <0.539219, -0.300927, -5.227303>, 
      <0.494892, -0.028914, -5.147490>, <0.508703, -0.088087, -5.147490>, <0.513136, -0.140837, -5.141744>, <0.529645, -0.199284, -5.143619>, 
      <0.492942, 0.066298, -5.036190>, <0.492946, 0.034187, -5.034608>, <0.500173, -0.038760, -5.025881>, <0.512491, -0.068445, -5.025062>, 
      <0.503567, 0.148932, -4.966072>, <0.503571, 0.116821, -4.964490>, <0.499121, 0.072433, -4.954740>, <0.511438, 0.042747, -4.953921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.441065, 0.119612, -5.227303>, <0.443380, 0.050847, -5.227303>, <0.480673, -0.035978, -5.227303>, <0.496311, -0.102981, -5.227303>, 
      <0.467352, 0.161233, -5.145118>, <0.469667, 0.092468, -5.145118>, <0.479253, 0.038089, -5.147490>, <0.494892, -0.028914, -5.147490>, 
      <0.479185, 0.235820, -5.038752>, <0.464666, 0.196318, -5.036122>, <0.492937, 0.108415, -5.038267>, <0.492942, 0.066298, -5.036190>, 
      <0.511408, 0.289272, -4.966072>, <0.496889, 0.249770, -4.963442>, <0.503562, 0.191049, -4.968148>, <0.503567, 0.148932, -4.966072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.477628, 0.451953, -5.227303>, <0.414621, 0.373908, -5.227303>, <0.437690, 0.219859, -5.227303>, <0.441065, 0.119612, -5.227303>, 
      <0.510381, 0.441376, -5.152145>, <0.447374, 0.363331, -5.152145>, <0.463977, 0.261480, -5.145118>, <0.467352, 0.161233, -5.145118>, 
      <0.556601, 0.440550, -5.049489>, <0.516649, 0.412160, -5.051712>, <0.496078, 0.281781, -5.041811>, <0.479185, 0.235820, -5.038752>, 
      <0.604193, 0.422706, -4.984297>, <0.564240, 0.394317, -4.986520>, <0.528301, 0.335233, -4.969132>, <0.511408, 0.289272, -4.966072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.829223, 0.600414, -5.227303>, <0.715003, 0.592461, -5.227303>, <0.549550, 0.541041, -5.227303>, <0.477628, 0.451953, -5.227303>, 
      <0.833928, 0.562669, -5.148924>, <0.719708, 0.554717, -5.148924>, <0.582302, 0.530464, -5.152145>, <0.510381, 0.441376, -5.152145>, 
      <0.837261, 0.559766, -5.026358>, <0.760354, 0.552608, -5.028245>, <0.619518, 0.485257, -5.045988>, <0.556601, 0.440550, -5.049489>, 
      <0.838992, 0.522044, -4.947846>, <0.762085, 0.514887, -4.949733>, <0.667110, 0.467413, -4.980796>, <0.604193, 0.422706, -4.984297>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.128523, 0.497273, -5.227303>, <1.059452, 0.562456, -5.227303>, <0.923966, 0.607011, -5.227303>, <0.829223, 0.600414, -5.227303>, 
      <1.117892, 0.479332, -5.152640>, <1.048821, 0.544515, -5.152640>, <0.928670, 0.569266, -5.148924>, <0.833928, 0.562669, -5.148924>, 
      <1.119122, 0.488569, -5.044426>, <1.051827, 0.531766, -5.041036>, <0.916931, 0.567180, -5.024403>, <0.837261, 0.559766, -5.026358>, 
      <1.099283, 0.468782, -4.972147>, <1.031988, 0.511979, -4.968757>, <0.918662, 0.529459, -4.945891>, <0.838992, 0.522044, -4.947846>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.327057, 0.130604, -5.227303>, <1.315753, 0.255115, -5.223199>, <1.219499, 0.411419, -5.227303>, <1.128523, 0.497273, -5.227303>, 
      <1.289538, 0.176057, -5.147396>, <1.278234, 0.300568, -5.143292>, <1.208868, 0.393477, -5.152640>, <1.117892, 0.479332, -5.152640>, 
      <1.253623, 0.242257, -5.035370>, <1.247114, 0.303560, -5.038848>, <1.171037, 0.455244, -5.047042>, <1.119122, 0.488569, -5.044426>, 
      <1.200762, 0.289821, -4.966072>, <1.194253, 0.351124, -4.969551>, <1.151198, 0.435457, -4.974762>, <1.099283, 0.468782, -4.972147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.228909, -0.608492, -5.263754>, <1.308367, -0.399157, -5.259806>, <1.347293, -0.092301, -5.234651>, <1.327057, 0.130604, -5.227303>, 
      <1.197040, -0.440009, -5.181048>, <1.276497, -0.230674, -5.177101>, <1.309774, -0.046848, -5.154744>, <1.289538, 0.176057, -5.147396>, 
      <1.187854, -0.235141, -5.024266>, <1.234374, -0.137789, -5.028691>, <1.265006, 0.135044, -5.029286>, <1.253623, 0.242257, -5.035370>, 
      <1.156121, -0.066529, -4.941771>, <1.202641, 0.030823, -4.946196>, <1.212146, 0.182608, -4.959988>, <1.200762, 0.289821, -4.966072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.228909, -0.608492, -5.263754>, <1.197040, -0.440009, -5.181048>, <1.187854, -0.235141, -5.024266>, <1.156121, -0.066529, -4.941771>, 
      <1.188499, -0.714954, -5.265762>, <1.156630, -0.546470, -5.183056>, <1.152170, -0.309819, -5.020872>, <1.120436, -0.141207, -4.938377>, 
      <1.057028, -0.827920, -5.249652>, <1.046407, -0.636163, -5.172002>, <1.031879, -0.421607, -5.018442>, <1.026552, -0.228822, -4.942822>, 
      <0.949284, -0.864656, -5.246073>, <0.938663, -0.672899, -5.168423>, <0.950610, -0.437607, -5.017391>, <0.945283, -0.244821, -4.941771>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.795507, -1.216217, -5.391332>, <0.842428, -1.269641, -5.390048>, <0.937895, -1.349031, -5.376655>, <1.005177, -1.326196, -5.379665>, 
      <0.799460, -1.083644, -5.339023>, <0.846381, -1.137068, -5.337739>, <0.918936, -1.213863, -5.327368>, <0.986218, -1.191028, -5.330378>, 
      <0.788106, -0.893719, -5.304840>, <0.830454, -0.937013, -5.305512>, <0.899428, -1.018523, -5.298565>, <0.956724, -0.998987, -5.300469>, 
      <0.774666, -0.763370, -5.248664>, <0.817014, -0.806663, -5.249336>, <0.891988, -0.884192, -5.244169>, <0.949284, -0.864656, -5.246073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.578857, -0.840795, -5.391332>, <0.617404, -0.964887, -5.396262>, <0.709711, -1.118531, -5.393680>, <0.795507, -1.216217, -5.391332>, 
      <0.596613, -0.757428, -5.328144>, <0.635160, -0.881521, -5.333074>, <0.713664, -0.985958, -5.341371>, <0.799460, -1.083644, -5.339023>, 
      <0.612952, -0.615335, -5.292646>, <0.652243, -0.692506, -5.296211>, <0.727504, -0.831765, -5.303879>, <0.788106, -0.893719, -5.304840>, 
      <0.614892, -0.522798, -5.240769>, <0.654183, -0.599969, -5.244333>, <0.714064, -0.701415, -5.247702>, <0.774666, -0.763370, -5.248664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.558006, -0.451639, -5.360956>, <0.570759, -0.568074, -5.366630>, <0.544095, -0.728885, -5.386886>, <0.578857, -0.840795, -5.391332>, 
      <0.554257, -0.413903, -5.313568>, <0.567010, -0.530338, -5.319242>, <0.561851, -0.645519, -5.323698>, <0.596613, -0.757428, -5.328144>, 
      <0.543621, -0.347660, -5.265779>, <0.562760, -0.415417, -5.267952>, <0.581018, -0.552614, -5.289749>, <0.612952, -0.615335, -5.292646>, 
      <0.539219, -0.300927, -5.227303>, <0.558358, -0.368685, -5.229476>, <0.582958, -0.460077, -5.237872>, <0.614892, -0.522798, -5.240769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.510589, -0.217523, -5.360956>, <0.532407, -0.285782, -5.360956>, <0.550213, -0.380488, -5.357489>, <0.558006, -0.451639, -5.360956>, 
      <0.507942, -0.189077, -5.316340>, <0.529760, -0.257336, -5.316340>, <0.546464, -0.342751, -5.310100>, <0.554257, -0.413903, -5.313568>, 
      <0.497002, -0.139016, -5.266134>, <0.510813, -0.198189, -5.266134>, <0.527112, -0.289213, -5.263904>, <0.543621, -0.347660, -5.265779>, 
      <0.496311, -0.102981, -5.227303>, <0.510122, -0.162154, -5.227303>, <0.522710, -0.242480, -5.225428>, <0.539219, -0.300927, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.385105, 0.089291, -5.360956>, <0.395172, -0.009643, -5.360956>, <0.480312, -0.122799, -5.360956>, <0.510589, -0.217523, -5.360956>, 
      <0.394262, 0.096979, -5.318186>, <0.404328, -0.001955, -5.318186>, <0.477665, -0.094353, -5.316340>, <0.507942, -0.189077, -5.316340>, 
      <0.428879, 0.100318, -5.265402>, <0.431194, 0.031553, -5.265402>, <0.481363, -0.072013, -5.266134>, <0.497002, -0.139016, -5.266134>, 
      <0.441065, 0.119612, -5.227303>, <0.443380, 0.050847, -5.227303>, <0.480673, -0.035978, -5.227303>, <0.496311, -0.102981, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.440051, 0.475712, -5.360956>, <0.374257, 0.378852, -5.360956>, <0.373252, 0.205782, -5.360956>, <0.385105, 0.089291, -5.360956>, 
      <0.446883, 0.463948, -5.320950>, <0.381089, 0.367088, -5.320950>, <0.382408, 0.213470, -5.318186>, <0.394262, 0.096979, -5.318186>, 
      <0.460886, 0.457360, -5.265722>, <0.397879, 0.379315, -5.265722>, <0.425504, 0.200565, -5.265402>, <0.428879, 0.100318, -5.265402>, 
      <0.477628, 0.451953, -5.227303>, <0.414621, 0.373908, -5.227303>, <0.437690, 0.219859, -5.227303>, <0.441065, 0.119612, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.814194, 0.720984, -5.360956>, <0.680955, 0.704856, -5.360956>, <0.515464, 0.586733, -5.360956>, <0.440051, 0.475712, -5.360956>, 
      <0.818240, 0.696299, -5.312887>, <0.685001, 0.680171, -5.312887>, <0.522296, 0.574969, -5.320950>, <0.446883, 0.463948, -5.320950>, 
      <0.826297, 0.623891, -5.276054>, <0.712077, 0.615938, -5.276054>, <0.532807, 0.546447, -5.265722>, <0.460886, 0.457360, -5.265722>, 
      <0.829223, 0.600414, -5.227303>, <0.715003, 0.592461, -5.227303>, <0.549550, 0.541041, -5.227303>, <0.477628, 0.451953, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.154645, 0.562211, -5.360956>, <1.080568, 0.647141, -5.360956>, <0.926073, 0.734527, -5.360956>, <0.814194, 0.720984, -5.360956>, 
      <1.148952, 0.540635, -5.321578>, <1.074875, 0.625565, -5.321578>, <0.930119, 0.709842, -5.312887>, <0.818240, 0.696299, -5.312887>, 
      <1.134730, 0.507748, -5.270896>, <1.065659, 0.572931, -5.270896>, <0.921039, 0.630487, -5.276054>, <0.826297, 0.623891, -5.276054>, 
      <1.128523, 0.497273, -5.227303>, <1.059452, 0.562456, -5.227303>, <0.923966, 0.607011, -5.227303>, <0.829223, 0.600414, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.386173, 0.065203, -5.360956>, <1.367315, 0.228510, -5.355355>, <1.262765, 0.438251, -5.360956>, <1.154645, 0.562211, -5.360956>, 
      <1.373347, 0.079922, -5.317070>, <1.354489, 0.243229, -5.311469>, <1.257071, 0.416675, -5.321578>, <1.148952, 0.540635, -5.321578>, 
      <1.345207, 0.108616, -5.265959>, <1.333903, 0.233127, -5.261855>, <1.225706, 0.421894, -5.270896>, <1.134730, 0.507748, -5.270896>, 
      <1.327057, 0.130604, -5.227303>, <1.315753, 0.255115, -5.223199>, <1.219499, 0.411419, -5.227303>, <1.128523, 0.497273, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.338718, -1.031857, -5.415633>, <1.425820, -0.713761, -5.411356>, <1.423987, -0.262264, -5.372188>, <1.386173, 0.065203, -5.360956>, 
      <1.306402, -0.906096, -5.366314>, <1.393504, -0.587999, -5.362036>, <1.411161, -0.247544, -5.328302>, <1.373347, 0.079922, -5.317070>, 
      <1.252161, -0.731418, -5.324096>, <1.331619, -0.522083, -5.320148>, <1.365443, -0.114289, -5.273307>, <1.345207, 0.108616, -5.265959>, 
      <1.228909, -0.608492, -5.263754>, <1.308367, -0.399157, -5.259806>, <1.347293, -0.092301, -5.234651>, <1.327057, 0.130604, -5.227303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.338718, -1.031857, -5.415633>, <1.306402, -0.906096, -5.366314>, <1.252161, -0.731418, -5.324096>, <1.228909, -0.608492, -5.263754>, 
      <1.303361, -1.160981, -5.417369>, <1.271045, -1.035219, -5.368050>, <1.211751, -0.837880, -5.326104>, <1.188499, -0.714954, -5.265762>, 
      <1.131849, -1.283205, -5.385332>, <1.112890, -1.148037, -5.336044>, <1.064468, -0.962251, -5.304048>, <1.057028, -0.827920, -5.249652>, 
      <1.005177, -1.326196, -5.379665>, <0.986218, -1.191028, -5.330378>, <0.956724, -0.998987, -5.300469>, <0.949284, -0.864656, -5.246073>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.753326, -1.479080, -5.531060>, <0.811220, -1.556222, -5.529053>, <0.959347, -1.623809, -5.513077>, <1.051990, -1.596904, -5.513077>, 
      <0.772729, -1.432404, -5.456355>, <0.830623, -1.509546, -5.454347>, <0.955498, -1.581381, -5.431962>, <1.048140, -1.554476, -5.431962>, 
      <0.793006, -1.300089, -5.424426>, <0.839928, -1.353513, -5.423142>, <0.949865, -1.434371, -5.407773>, <1.017147, -1.411536, -5.410783>, 
      <0.795507, -1.216217, -5.391332>, <0.842428, -1.269641, -5.390048>, <0.937895, -1.349031, -5.376655>, <1.005177, -1.326196, -5.379665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.753326, -1.479080, -5.531060>, <0.739758, -1.511717, -5.583297>, <0.716743, -1.458725, -5.675602>, <0.707618, -1.427637, -5.729715>, 
      <0.811220, -1.556222, -5.529053>, <0.797652, -1.588859, -5.581289>, <0.777348, -1.534257, -5.674171>, <0.768223, -1.503169, -5.728284>, 
      <0.959347, -1.623809, -5.513077>, <0.962217, -1.655435, -5.573542>, <0.938814, -1.572034, -5.664766>, <0.928419, -1.530951, -5.718325>, 
      <1.051990, -1.596904, -5.513077>, <1.054860, -1.628531, -5.573542>, <1.031645, -1.544418, -5.664766>, <1.021249, -1.503334, -5.718325>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.533320, -0.905790, -5.531060>, <0.569971, -1.086324, -5.531060>, <0.642774, -1.331773, -5.534894>, <0.753326, -1.479080, -5.531060>, 
      <0.538879, -0.897236, -5.483944>, <0.575530, -1.077770, -5.483944>, <0.662178, -1.285097, -5.460188>, <0.772729, -1.432404, -5.456355>, 
      <0.570790, -0.878672, -5.420041>, <0.609337, -1.002765, -5.424971>, <0.707210, -1.202403, -5.426774>, <0.793006, -1.300089, -5.424426>, 
      <0.578857, -0.840795, -5.391332>, <0.617404, -0.964887, -5.396262>, <0.709711, -1.118531, -5.393680>, <0.795507, -1.216217, -5.391332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.533320, -0.905790, -5.531060>, <0.526444, -0.916370, -5.589340>, <0.531805, -0.912954, -5.671494>, <0.538936, -0.902225, -5.729715>, 
      <0.569971, -1.086324, -5.531060>, <0.563096, -1.096904, -5.589340>, <0.541731, -1.078204, -5.671494>, <0.548862, -1.067475, -5.729715>, 
      <0.642774, -1.331773, -5.534894>, <0.629207, -1.364410, -5.587130>, <0.613151, -1.329618, -5.678048>, <0.604026, -1.298530, -5.732161>, 
      <0.753326, -1.479080, -5.531060>, <0.739758, -1.511717, -5.583297>, <0.716743, -1.458725, -5.675602>, <0.707618, -1.427637, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.563249, -0.542818, -5.531060>, <0.566654, -0.652026, -5.531060>, <0.511582, -0.798713, -5.531060>, <0.533320, -0.905790, -5.531060>, 
      <0.548993, -0.529887, -5.476430>, <0.552398, -0.639095, -5.476430>, <0.517140, -0.790160, -5.483944>, <0.538879, -0.897236, -5.483944>, 
      <0.561584, -0.487652, -5.406180>, <0.574337, -0.604087, -5.411854>, <0.536027, -0.766762, -5.415595>, <0.570790, -0.878672, -5.420041>, 
      <0.558006, -0.451639, -5.360956>, <0.570759, -0.568074, -5.366630>, <0.544095, -0.728885, -5.386886>, <0.578857, -0.840795, -5.391332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.563249, -0.542818, -5.531060>, <0.579385, -0.557454, -5.592895>, <0.625964, -0.542977, -5.670702>, <0.654235, -0.538925, -5.729715>, 
      <0.566654, -0.652026, -5.531060>, <0.582790, -0.666663, -5.592895>, <0.611610, -0.656419, -5.670702>, <0.639881, -0.652368, -5.729715>, 
      <0.511582, -0.798713, -5.531060>, <0.504706, -0.809293, -5.589340>, <0.524949, -0.798812, -5.671494>, <0.532080, -0.788084, -5.729715>, 
      <0.533320, -0.905790, -5.531060>, <0.526444, -0.916370, -5.589340>, <0.531805, -0.912954, -5.671494>, <0.538936, -0.902225, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.514329, -0.296645, -5.531060>, <0.536493, -0.368605, -5.531060>, <0.560903, -0.467559, -5.531060>, <0.563249, -0.542818, -5.531060>, 
      <0.499536, -0.283620, -5.478331>, <0.521699, -0.355580, -5.478331>, <0.546647, -0.454628, -5.476430>, <0.548993, -0.529887, -5.476430>, 
      <0.513401, -0.247748, -5.408363>, <0.535219, -0.316007, -5.408363>, <0.553790, -0.416501, -5.402712>, <0.561584, -0.487652, -5.406180>, 
      <0.510589, -0.217523, -5.360956>, <0.532407, -0.285782, -5.360956>, <0.550213, -0.380488, -5.357489>, <0.558006, -0.451639, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.514329, -0.296645, -5.531060>, <0.531879, -0.312097, -5.593613>, <0.582744, -0.303982, -5.670908>, <0.614047, -0.308613, -5.729715>, 
      <0.536493, -0.368605, -5.531060>, <0.554043, -0.384057, -5.593613>, <0.600994, -0.371703, -5.670908>, <0.632297, -0.376335, -5.729715>, 
      <0.560903, -0.467559, -5.531060>, <0.577039, -0.482195, -5.592895>, <0.634768, -0.473394, -5.670702>, <0.663040, -0.469342, -5.729715>, 
      <0.563249, -0.542818, -5.531060>, <0.579385, -0.557454, -5.592895>, <0.625964, -0.542977, -5.670702>, <0.654235, -0.538925, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.376035, 0.065011, -5.531060>, <0.388246, -0.050504, -5.531060>, <0.480137, -0.185633, -5.531060>, <0.514329, -0.296645, -5.531060>, 
      <0.360703, 0.073047, -5.482429>, <0.372914, -0.042468, -5.482429>, <0.465343, -0.172608, -5.478331>, <0.499536, -0.283620, -5.478331>, 
      <0.374462, 0.080355, -5.410670>, <0.384529, -0.018579, -5.410670>, <0.483124, -0.153024, -5.408363>, <0.513401, -0.247748, -5.408363>, 
      <0.385105, 0.089291, -5.360956>, <0.395172, -0.009643, -5.360956>, <0.480312, -0.122799, -5.360956>, <0.510589, -0.217523, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.376035, 0.065011, -5.531060>, <0.397218, 0.053908, -5.598249>, <0.462180, 0.045545, -5.672658>, <0.501364, 0.028355, -5.729715>, 
      <0.388246, -0.050504, -5.531060>, <0.409428, -0.061607, -5.598249>, <0.482270, -0.059138, -5.672658>, <0.521454, -0.076328, -5.729715>, 
      <0.480137, -0.185633, -5.531060>, <0.497686, -0.201084, -5.593613>, <0.555009, -0.201060, -5.670908>, <0.586312, -0.205692, -5.729715>, 
      <0.514329, -0.296645, -5.531060>, <0.531879, -0.312097, -5.593613>, <0.582744, -0.303982, -5.670908>, <0.614047, -0.308613, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425756, 0.541274, -5.531060>, <0.350191, 0.419098, -5.531060>, <0.360934, 0.207871, -5.531060>, <0.376035, 0.065011, -5.531060>, 
      <0.421811, 0.543702, -5.476398>, <0.346246, 0.421527, -5.476398>, <0.345602, 0.215907, -5.482429>, <0.360703, 0.073047, -5.482429>, 
      <0.431182, 0.490984, -5.412894>, <0.365388, 0.394125, -5.412894>, <0.362609, 0.196846, -5.410670>, <0.374462, 0.080355, -5.410670>, 
      <0.440051, 0.475712, -5.360956>, <0.374257, 0.378852, -5.360956>, <0.373252, 0.205782, -5.360956>, <0.385105, 0.089291, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425756, 0.541274, -5.531060>, <0.430476, 0.538370, -5.596451>, <0.450223, 0.493923, -5.676426>, <0.466667, 0.459333, -5.729715>, 
      <0.350191, 0.419098, -5.531060>, <0.354911, 0.416194, -5.596451>, <0.392105, 0.377960, -5.676426>, <0.408550, 0.343370, -5.729715>, 
      <0.360934, 0.207871, -5.531060>, <0.382117, 0.196768, -5.598249>, <0.437733, 0.172931, -5.672658>, <0.476917, 0.155742, -5.729715>, 
      <0.376035, 0.065011, -5.531060>, <0.397218, 0.053908, -5.598249>, <0.462180, 0.045545, -5.672658>, <0.501364, 0.028355, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.803657, 0.756404, -5.531060>, <0.674923, 0.735296, -5.531060>, <0.494376, 0.652222, -5.531060>, <0.425756, 0.541274, -5.531060>, 
      <0.804133, 0.766848, -5.479896>, <0.675398, 0.745740, -5.479896>, <0.490431, 0.654650, -5.476398>, <0.421811, 0.543702, -5.476398>, 
      <0.810295, 0.744773, -5.407280>, <0.677056, 0.728645, -5.407280>, <0.506595, 0.602005, -5.412894>, <0.431182, 0.490984, -5.412894>, 
      <0.814194, 0.720984, -5.360956>, <0.680955, 0.704856, -5.360956>, <0.515464, 0.586733, -5.360956>, <0.440051, 0.475712, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.803657, 0.756404, -5.531060>, <0.803035, 0.742753, -5.597935>, <0.808588, 0.689647, -5.677523>, <0.810766, 0.645712, -5.729715>, 
      <0.674923, 0.735296, -5.531060>, <0.674301, 0.721645, -5.597935>, <0.692350, 0.673170, -5.677523>, <0.694528, 0.629235, -5.729715>, 
      <0.494376, 0.652222, -5.531060>, <0.499096, 0.649317, -5.596451>, <0.502824, 0.598879, -5.676426>, <0.519268, 0.564289, -5.729715>, 
      <0.425756, 0.541274, -5.531060>, <0.430476, 0.538370, -5.596451>, <0.450223, 0.493923, -5.676426>, <0.466667, 0.459333, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.172440, 0.663706, -5.531060>, <1.099020, 0.750999, -5.532755>, <0.916230, 0.774862, -5.531060>, <0.803657, 0.756404, -5.531060>, 
      <1.175160, 0.664957, -5.471471>, <1.101740, 0.752250, -5.473166>, <0.916706, 0.785306, -5.479896>, <0.804133, 0.766848, -5.479896>, 
      <1.162150, 0.590653, -5.412865>, <1.088073, 0.675582, -5.412865>, <0.922175, 0.758316, -5.407280>, <0.810295, 0.744773, -5.407280>, 
      <1.154645, 0.562211, -5.360956>, <1.080568, 0.647141, -5.360956>, <0.926073, 0.734527, -5.360956>, <0.814194, 0.720984, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.172440, 0.663706, -5.531060>, <1.169304, 0.662263, -5.599775>, <1.151275, 0.596799, -5.677174>, <1.137813, 0.554469, -5.729715>, 
      <1.099020, 0.750999, -5.532755>, <1.095884, 0.749557, -5.601470>, <1.084001, 0.673284, -5.677174>, <1.070540, 0.630954, -5.729715>, 
      <0.916230, 0.774862, -5.531060>, <0.915609, 0.761212, -5.597935>, <0.909441, 0.703943, -5.677523>, <0.911619, 0.660008, -5.729715>, 
      <0.803657, 0.756404, -5.531060>, <0.803035, 0.742753, -5.597935>, <0.808588, 0.689647, -5.677523>, <0.810766, 0.645712, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.411730, 0.033431, -5.517025>, <1.387916, 0.234319, -5.517025>, <1.302638, 0.508907, -5.528055>, <1.172440, 0.663706, -5.531060>, 
      <1.414374, 0.039991, -5.469152>, <1.390560, 0.240879, -5.469152>, <1.305357, 0.510158, -5.468466>, <1.175160, 0.664957, -5.471471>, 
      <1.399095, 0.050374, -5.405170>, <1.380237, 0.213680, -5.399569>, <1.270269, 0.466692, -5.412865>, <1.162150, 0.590653, -5.412865>, 
      <1.386173, 0.065203, -5.360956>, <1.367315, 0.228510, -5.355355>, <1.262765, 0.438251, -5.360956>, <1.154645, 0.562211, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.411730, 0.033431, -5.517025>, <1.408150, 0.024550, -5.581841>, <1.387537, 0.026871, -5.669119>, <1.365806, 0.014675, -5.729715>, 
      <1.387916, 0.234319, -5.517025>, <1.384336, 0.225438, -5.581841>, <1.361371, 0.200703, -5.669119>, <1.339640, 0.188507, -5.729715>, 
      <1.302638, 0.508907, -5.528055>, <1.299501, 0.507464, -5.596770>, <1.267375, 0.464803, -5.677174>, <1.253913, 0.422473, -5.729715>, 
      <1.172440, 0.663706, -5.531060>, <1.169304, 0.662263, -5.599775>, <1.151275, 0.596799, -5.677174>, <1.137813, 0.554469, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.404054, -1.290099, -5.531060>, <1.489615, -0.902340, -5.531999>, <1.458476, -0.360896, -5.517025>, <1.411730, 0.033431, -5.517025>, 
      <1.388557, -1.246025, -5.457558>, <1.474117, -0.858266, -5.458496>, <1.461120, -0.354336, -5.469152>, <1.414374, 0.039991, -5.469152>, 
      <1.358981, -1.110713, -5.446558>, <1.446083, -0.792617, -5.442281>, <1.436909, -0.277093, -5.416403>, <1.399095, 0.050374, -5.405170>, 
      <1.338718, -1.031857, -5.415633>, <1.425820, -0.713761, -5.411356>, <1.423987, -0.262264, -5.372188>, <1.386173, 0.065203, -5.360956>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.404054, -1.290099, -5.531060>, <1.415296, -1.322071, -5.584381>, <1.414531, -1.252031, -5.675997>, <1.404940, -1.220186, -5.729715>, 
      <1.489615, -0.902340, -5.531999>, <1.500857, -0.934312, -5.585320>, <1.496571, -0.890590, -5.678708>, <1.486980, -0.858745, -5.732427>, 
      <1.458476, -0.360896, -5.517025>, <1.454896, -0.369777, -5.581841>, <1.442706, -0.339645, -5.669119>, <1.420975, -0.351840, -5.729715>, 
      <1.411730, 0.033431, -5.517025>, <1.408150, 0.024550, -5.581841>, <1.387537, 0.026871, -5.669119>, <1.365806, 0.014675, -5.729715>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.404054, -1.290099, -5.531060>, <1.388557, -1.246025, -5.457558>, <1.358981, -1.110713, -5.446558>, <1.338718, -1.031857, -5.415633>, 
      <1.373845, -1.427006, -5.530729>, <1.358347, -1.382932, -5.457226>, <1.323624, -1.239837, -5.448295>, <1.303361, -1.160981, -5.417369>, 
      <1.186628, -1.557803, -5.513077>, <1.182778, -1.515376, -5.431962>, <1.143819, -1.368545, -5.416450>, <1.131849, -1.283205, -5.385332>, 
      <1.051990, -1.596904, -5.513077>, <1.048140, -1.554476, -5.431962>, <1.017147, -1.411536, -5.410783>, <1.005177, -1.326196, -5.379665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.404054, -1.290099, -5.531060>, <1.373845, -1.427006, -5.530729>, <1.186628, -1.557803, -5.513077>, <1.051990, -1.596904, -5.513077>, 
      <1.415296, -1.322071, -5.584381>, <1.385087, -1.458978, -5.584050>, <1.189497, -1.589430, -5.573542>, <1.054860, -1.628531, -5.573542>, 
      <1.414531, -1.252031, -5.675997>, <1.382857, -1.391575, -5.674950>, <1.168801, -1.503614, -5.664766>, <1.031645, -1.544418, -5.664766>, 
      <1.404940, -1.220186, -5.729715>, <1.373266, -1.359730, -5.728668>, <1.158406, -1.462530, -5.718325>, <1.021249, -1.503334, -5.718325>
    }
  }
  texture {
    Shoes
  }
}
#declare sPatchObj2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.082751, -0.679066, 5.761615>, <-0.083307, -0.671670, 5.766786>, <-0.083867, -0.654704, 5.768183>, <-0.084347, -0.650953, 5.772360>, 
      <-0.082751, -0.679066, 5.761615>, <-0.026644, -0.694099, 5.773472>, <-0.022828, -0.678865, 5.775385>, <-0.023308, -0.675114, 5.779562>, 
      <-0.082751, -0.679066, 5.761615>, <-0.026644, -0.694099, 5.773472>, <-0.010497, -0.698021, 5.739510>, <0.044052, -0.718562, 5.720514>, 
      <-0.082751, -0.679066, 5.761615>, <-0.026088, -0.701495, 5.768300>, <0.044531, -0.726996, 5.717291>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.082751, -0.679066, 5.761615>, <-0.153306, -0.651138, 5.753290>, <-0.231297, -0.617814, 5.684746>, <-0.294959, -0.591563, 5.651802>, 
      <-0.082751, -0.679066, 5.761615>, <-0.153862, -0.643742, 5.758461>, <-0.168113, -0.635631, 5.720913>, <-0.231775, -0.609380, 5.687969>, 
      <-0.082751, -0.679066, 5.761615>, <-0.153862, -0.643742, 5.758461>, <-0.153141, -0.627282, 5.760009>, <-0.153621, -0.623532, 5.764186>, 
      <-0.082751, -0.679066, 5.761615>, <-0.083307, -0.671670, 5.766786>, <-0.083867, -0.654704, 5.768183>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.082751, -0.679066, 5.761615>, <-0.026088, -0.701495, 5.768300>, <0.044531, -0.726996, 5.717291>, <0.099080, -0.747537, 5.698295>, 
      <-0.153306, -0.651138, 5.753290>, <-0.096643, -0.673567, 5.759976>, <-0.010497, -0.698021, 5.739510>, <0.044052, -0.718562, 5.720514>, 
      <-0.231297, -0.617814, 5.684746>, <-0.168113, -0.635631, 5.720913>, <-0.092583, -0.647693, 5.771388>, <-0.023308, -0.675114, 5.779562>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231775, -0.609380, 5.687969>, <-0.153621, -0.623532, 5.764186>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080912, -0.696645, 5.740411>, <-0.081464, -0.691371, 5.746772>, <-0.082242, -0.685840, 5.756878>, <-0.082751, -0.679066, 5.761615>, 
      <-0.080912, -0.696645, 5.740411>, <-0.028301, -0.712415, 5.753045>, <-0.025579, -0.708269, 5.763564>, <-0.026088, -0.701495, 5.768300>, 
      <-0.080912, -0.696645, 5.740411>, <-0.028301, -0.712415, 5.753045>, <-0.009467, -0.711728, 5.729926>, <0.044531, -0.726996, 5.717291>, 
      <-0.080912, -0.696645, 5.740411>, <-0.027749, -0.717689, 5.746684>, <0.045082, -0.732269, 5.710930>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080912, -0.696645, 5.740411>, <-0.081464, -0.691371, 5.746772>, <-0.082242, -0.685840, 5.756878>, <-0.082751, -0.679066, 5.761615>, 
      <-0.027749, -0.717689, 5.746684>, <-0.028301, -0.712415, 5.753045>, <-0.082798, -0.678444, 5.762050>, <-0.083307, -0.671670, 5.766786>, 
      <0.045082, -0.732269, 5.710930>, <-0.009946, -0.703294, 5.733149>, <-0.022828, -0.678865, 5.775385>, <-0.083867, -0.654704, 5.768183>, 
      <0.099080, -0.747537, 5.698295>, <0.044052, -0.718562, 5.720514>, <-0.023308, -0.675114, 5.779562>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080912, -0.696645, 5.740411>, <-0.081464, -0.691371, 5.746772>, <-0.082242, -0.685840, 5.756878>, <-0.082751, -0.679066, 5.761615>, 
      <-0.080912, -0.696645, 5.740411>, <-0.151998, -0.663451, 5.738449>, <-0.152797, -0.657912, 5.748553>, <-0.153306, -0.651138, 5.753290>, 
      <-0.080912, -0.696645, 5.740411>, <-0.151998, -0.663451, 5.738449>, <-0.167082, -0.649339, 5.711328>, <-0.231297, -0.617814, 5.684746>, 
      <-0.080912, -0.696645, 5.740411>, <-0.151446, -0.668725, 5.732088>, <-0.230745, -0.623088, 5.678385>, <-0.294959, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080912, -0.696645, 5.740411>, <-0.027749, -0.717689, 5.746684>, <0.045082, -0.732269, 5.710930>, <0.099080, -0.747537, 5.698295>, 
      <-0.151446, -0.668725, 5.732088>, <-0.098283, -0.689769, 5.738361>, <-0.009467, -0.711728, 5.729926>, <0.044531, -0.726996, 5.717291>, 
      <-0.230745, -0.623088, 5.678385>, <-0.167082, -0.649339, 5.711328>, <-0.096643, -0.673567, 5.759976>, <-0.026088, -0.701495, 5.768300>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231297, -0.617814, 5.684746>, <-0.153306, -0.651138, 5.753290>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080912, -0.696645, 5.740411>, <-0.081464, -0.691371, 5.746772>, <-0.082242, -0.685840, 5.756878>, <-0.082751, -0.679066, 5.761615>, 
      <-0.151446, -0.668725, 5.732088>, <-0.151998, -0.663451, 5.738449>, <-0.082798, -0.678444, 5.762050>, <-0.083307, -0.671670, 5.766786>, 
      <-0.230745, -0.623088, 5.678385>, <-0.167561, -0.640905, 5.714552>, <-0.153141, -0.627282, 5.760009>, <-0.083867, -0.654704, 5.768183>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231775, -0.609380, 5.687969>, <-0.153621, -0.623532, 5.764186>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080912, -0.696645, 5.740411>, <-0.027749, -0.717689, 5.746684>, <0.045082, -0.732269, 5.710930>, <0.099080, -0.747537, 5.698295>, 
      <-0.151446, -0.668725, 5.732088>, <-0.098283, -0.689769, 5.738361>, <-0.009946, -0.703294, 5.733149>, <0.044052, -0.718562, 5.720514>, 
      <-0.230745, -0.623088, 5.678385>, <-0.167561, -0.640905, 5.714552>, <-0.092583, -0.647693, 5.771388>, <-0.023308, -0.675114, 5.779562>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231775, -0.609380, 5.687969>, <-0.153621, -0.623532, 5.764186>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080165, -0.677375, 5.610335>, <-0.145322, -0.651584, 5.602647>, <-0.230521, -0.617307, 5.639362>, <-0.294959, -0.591563, 5.651802>, 
      <-0.021484, -0.700603, 5.617258>, <-0.086641, -0.674812, 5.609570>, <-0.166307, -0.648831, 5.665944>, <-0.230745, -0.623088, 5.678385>, 
      <0.045307, -0.726488, 5.671907>, <-0.008691, -0.711221, 5.684542>, <-0.098283, -0.689769, 5.738361>, <-0.151446, -0.668725, 5.732088>, 
      <0.099080, -0.747537, 5.698295>, <0.045082, -0.732269, 5.710930>, <-0.027749, -0.717689, 5.746684>, <-0.080912, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080165, -0.677375, 5.610335>, <-0.145322, -0.651584, 5.602647>, <-0.230521, -0.617307, 5.639362>, <-0.294959, -0.591563, 5.651802>, 
      <-0.021484, -0.700603, 5.617258>, <-0.086641, -0.674812, 5.609570>, <-0.166858, -0.643558, 5.672306>, <-0.231297, -0.617814, 5.684746>, 
      <0.045307, -0.726488, 5.671907>, <-0.009243, -0.705947, 5.690903>, <-0.096643, -0.673567, 5.759976>, <-0.153306, -0.651138, 5.753290>, 
      <0.099080, -0.747537, 5.698295>, <0.044531, -0.726996, 5.717291>, <-0.026088, -0.701495, 5.768300>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080165, -0.677375, 5.610335>, <-0.145322, -0.651584, 5.602647>, <-0.230521, -0.617307, 5.639362>, <-0.294959, -0.591563, 5.651802>, 
      <-0.021484, -0.700603, 5.617258>, <-0.086641, -0.674812, 5.609570>, <-0.167337, -0.635124, 5.675529>, <-0.231775, -0.609380, 5.687969>, 
      <0.045307, -0.726488, 5.671907>, <-0.009722, -0.697513, 5.694126>, <-0.092583, -0.647693, 5.771388>, <-0.153621, -0.623532, 5.764186>, 
      <0.099080, -0.747537, 5.698295>, <0.044052, -0.718562, 5.720514>, <-0.023308, -0.675114, 5.779562>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.077807, -0.701866, 5.620928>, <-0.078516, -0.695066, 5.616704>, <-0.080003, -0.679242, 5.614979>, <-0.080165, -0.677375, 5.610335>, 
      <-0.077807, -0.701866, 5.620928>, <-0.146591, -0.668120, 5.608672>, <-0.145160, -0.653450, 5.607291>, <-0.145322, -0.651584, 5.602647>, 
      <-0.077807, -0.701866, 5.620928>, <-0.146591, -0.668120, 5.608672>, <-0.165375, -0.650397, 5.630100>, <-0.230521, -0.617307, 5.639362>, 
      <-0.077807, -0.701866, 5.620928>, <-0.145882, -0.674920, 5.612896>, <-0.229813, -0.624654, 5.642540>, <-0.294959, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.077807, -0.701866, 5.620928>, <-0.145882, -0.674920, 5.612896>, <-0.229813, -0.624654, 5.642540>, <-0.294959, -0.591563, 5.651802>, 
      <-0.022796, -0.723641, 5.627418>, <-0.090871, -0.696695, 5.619386>, <-0.165375, -0.650397, 5.630100>, <-0.230521, -0.617307, 5.639362>, 
      <0.046014, -0.733836, 5.675085>, <-0.007760, -0.712787, 5.648697>, <-0.086641, -0.674812, 5.609570>, <-0.145322, -0.651584, 5.602647>, 
      <0.099080, -0.747537, 5.698295>, <0.045307, -0.726488, 5.671907>, <-0.021484, -0.700603, 5.617258>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.077807, -0.701866, 5.620928>, <-0.078516, -0.695066, 5.616704>, <-0.080003, -0.679242, 5.614979>, <-0.080165, -0.677375, 5.610335>, 
      <-0.077807, -0.701866, 5.620928>, <-0.023506, -0.716841, 5.623195>, <-0.021322, -0.702470, 5.621902>, <-0.021484, -0.700603, 5.617258>, 
      <-0.077807, -0.701866, 5.620928>, <-0.023506, -0.716841, 5.623195>, <-0.007760, -0.712787, 5.648697>, <0.045307, -0.726488, 5.671907>, 
      <-0.077807, -0.701866, 5.620928>, <-0.022796, -0.723641, 5.627418>, <0.046014, -0.733836, 5.675085>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.077807, -0.701866, 5.620928>, <-0.145882, -0.674920, 5.612896>, <-0.229813, -0.624654, 5.642540>, <-0.294959, -0.591563, 5.651802>, 
      <-0.022796, -0.723641, 5.627418>, <-0.090871, -0.696695, 5.619386>, <-0.165599, -0.656179, 5.669123>, <-0.230745, -0.623088, 5.678385>, 
      <0.046014, -0.733836, 5.675085>, <-0.007984, -0.718568, 5.687720>, <-0.098283, -0.689769, 5.738361>, <-0.151446, -0.668725, 5.732088>, 
      <0.099080, -0.747537, 5.698295>, <0.045082, -0.732269, 5.710930>, <-0.027749, -0.717689, 5.746684>, <-0.080912, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.077807, -0.701866, 5.620928>, <-0.145882, -0.674920, 5.612896>, <-0.229813, -0.624654, 5.642540>, <-0.294959, -0.591563, 5.651802>, 
      <-0.022796, -0.723641, 5.627418>, <-0.090871, -0.696695, 5.619386>, <-0.166151, -0.650905, 5.675484>, <-0.231297, -0.617814, 5.684746>, 
      <0.046014, -0.733836, 5.675085>, <-0.008535, -0.713294, 5.694081>, <-0.096643, -0.673567, 5.759976>, <-0.153306, -0.651138, 5.753290>, 
      <0.099080, -0.747537, 5.698295>, <0.044531, -0.726996, 5.717291>, <-0.026088, -0.701495, 5.768300>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.077807, -0.701866, 5.620928>, <-0.145882, -0.674920, 5.612896>, <-0.229813, -0.624654, 5.642540>, <-0.294959, -0.591563, 5.651802>, 
      <-0.022796, -0.723641, 5.627418>, <-0.090871, -0.696695, 5.619386>, <-0.166630, -0.642471, 5.678707>, <-0.231775, -0.609380, 5.687969>, 
      <0.046014, -0.733836, 5.675085>, <-0.009014, -0.704861, 5.697304>, <-0.092583, -0.647693, 5.771388>, <-0.153621, -0.623532, 5.764186>, 
      <0.099080, -0.747537, 5.698295>, <0.044052, -0.718562, 5.720514>, <-0.023308, -0.675114, 5.779562>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.076585, -0.712262, 5.630620>, <-0.077267, -0.707039, 5.624141>, <-0.077807, -0.701866, 5.620928>, 
      <-0.076061, -0.716718, 5.634774>, <-0.024225, -0.732988, 5.636798>, <-0.022257, -0.728814, 5.630632>, <-0.022796, -0.723641, 5.627418>, 
      <-0.076061, -0.716718, 5.634774>, <-0.024225, -0.732988, 5.636798>, <-0.006528, -0.724590, 5.656029>, <0.046014, -0.733836, 5.675085>, 
      <-0.076061, -0.716718, 5.634774>, <-0.023701, -0.737444, 5.640952>, <0.046538, -0.738291, 5.679239>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.076585, -0.712262, 5.630620>, <-0.077267, -0.707039, 5.624141>, <-0.077807, -0.701866, 5.620928>, 
      <-0.023701, -0.737444, 5.640952>, <-0.024225, -0.732988, 5.636798>, <-0.077977, -0.700240, 5.619917>, <-0.078516, -0.695066, 5.616704>, 
      <0.046538, -0.738291, 5.679239>, <-0.007236, -0.717243, 5.652851>, <-0.021322, -0.702470, 5.621902>, <-0.080003, -0.679242, 5.614979>, 
      <0.099080, -0.747537, 5.698295>, <0.045307, -0.726488, 5.671907>, <-0.021484, -0.700603, 5.617258>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.023701, -0.737444, 5.640952>, <0.046538, -0.738291, 5.679239>, <0.099080, -0.747537, 5.698295>, 
      <-0.146136, -0.688980, 5.626506>, <-0.093776, -0.709706, 5.632684>, <-0.007236, -0.717243, 5.652851>, <0.045307, -0.726488, 5.671907>, 
      <-0.229290, -0.629109, 5.646694>, <-0.164851, -0.654853, 5.634254>, <-0.086641, -0.674812, 5.609570>, <-0.021484, -0.700603, 5.617258>, 
      <-0.294959, -0.591563, 5.651802>, <-0.230521, -0.617307, 5.639362>, <-0.145322, -0.651584, 5.602647>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.076585, -0.712262, 5.630620>, <-0.077267, -0.707039, 5.624141>, <-0.077807, -0.701866, 5.620928>, 
      <-0.146136, -0.688980, 5.626506>, <-0.146660, -0.684524, 5.622352>, <-0.077977, -0.700240, 5.619917>, <-0.078516, -0.695066, 5.616704>, 
      <-0.229290, -0.629109, 5.646694>, <-0.164851, -0.654853, 5.634254>, <-0.145160, -0.653450, 5.607291>, <-0.080003, -0.679242, 5.614979>, 
      <-0.294959, -0.591563, 5.651802>, <-0.230521, -0.617307, 5.639362>, <-0.145322, -0.651584, 5.602647>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.076585, -0.712262, 5.630620>, <-0.077267, -0.707039, 5.624141>, <-0.077807, -0.701866, 5.620928>, 
      <-0.076061, -0.716718, 5.634774>, <-0.146660, -0.684524, 5.622352>, <-0.145342, -0.680093, 5.616109>, <-0.145882, -0.674920, 5.612896>, 
      <-0.076061, -0.716718, 5.634774>, <-0.146660, -0.684524, 5.622352>, <-0.164144, -0.662200, 5.637432>, <-0.229813, -0.624654, 5.642540>, 
      <-0.076061, -0.716718, 5.634774>, <-0.146136, -0.688980, 5.626506>, <-0.229290, -0.629109, 5.646694>, <-0.294959, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.023701, -0.737444, 5.640952>, <0.046538, -0.738291, 5.679239>, <0.099080, -0.747537, 5.698295>, 
      <-0.146136, -0.688980, 5.626506>, <-0.093776, -0.709706, 5.632684>, <-0.006528, -0.724590, 5.656029>, <0.046014, -0.733836, 5.675085>, 
      <-0.229290, -0.629109, 5.646694>, <-0.164144, -0.662200, 5.637432>, <-0.090871, -0.696695, 5.619386>, <-0.022796, -0.723641, 5.627418>, 
      <-0.294959, -0.591563, 5.651802>, <-0.229813, -0.624654, 5.642540>, <-0.145882, -0.674920, 5.612896>, <-0.077807, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.023701, -0.737444, 5.640952>, <0.046538, -0.738291, 5.679239>, <0.099080, -0.747537, 5.698295>, 
      <-0.146136, -0.688980, 5.626506>, <-0.093776, -0.709706, 5.632684>, <-0.007460, -0.723024, 5.691874>, <0.045082, -0.732269, 5.710930>, 
      <-0.229290, -0.629109, 5.646694>, <-0.165075, -0.660634, 5.673276>, <-0.098283, -0.689769, 5.738361>, <-0.027749, -0.717689, 5.746684>, 
      <-0.294959, -0.591563, 5.651802>, <-0.230745, -0.623088, 5.678385>, <-0.151446, -0.668725, 5.732088>, <-0.080912, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.023701, -0.737444, 5.640952>, <0.046538, -0.738291, 5.679239>, <0.099080, -0.747537, 5.698295>, 
      <-0.146136, -0.688980, 5.626506>, <-0.093776, -0.709706, 5.632684>, <-0.008012, -0.717750, 5.698234>, <0.044531, -0.726996, 5.717291>, 
      <-0.229290, -0.629109, 5.646694>, <-0.165627, -0.655360, 5.679638>, <-0.096643, -0.673567, 5.759976>, <-0.026088, -0.701495, 5.768300>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231297, -0.617814, 5.684746>, <-0.153306, -0.651138, 5.753290>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.076061, -0.716718, 5.634774>, <-0.023701, -0.737444, 5.640952>, <0.046538, -0.738291, 5.679239>, <0.099080, -0.747537, 5.698295>, 
      <-0.146136, -0.688980, 5.626506>, <-0.093776, -0.709706, 5.632684>, <-0.008490, -0.709316, 5.701458>, <0.044052, -0.718562, 5.720514>, 
      <-0.229290, -0.629109, 5.646694>, <-0.166106, -0.646926, 5.682861>, <-0.092583, -0.647693, 5.771388>, <-0.023308, -0.675114, 5.779562>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231775, -0.609380, 5.687969>, <-0.153621, -0.623532, 5.764186>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.019563, -0.714713, 5.601612>, <-0.087467, -0.687834, 5.593600>, <-0.172220, -0.666903, 5.673381>, <-0.229290, -0.629109, 5.646694>, 
      <0.045739, -0.730665, 5.667196>, <-0.006803, -0.721419, 5.648140>, <-0.093776, -0.709706, 5.632684>, <-0.146136, -0.688980, 5.626506>, 
      <0.099080, -0.747537, 5.698295>, <0.046538, -0.738291, 5.679239>, <-0.023701, -0.737444, 5.640952>, <-0.076061, -0.716718, 5.634774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.019563, -0.714713, 5.601612>, <-0.087467, -0.687834, 5.593600>, <-0.172744, -0.662447, 5.669228>, <-0.229813, -0.624654, 5.642540>, 
      <0.045739, -0.730665, 5.667196>, <-0.007327, -0.716963, 5.643986>, <-0.090871, -0.696695, 5.619386>, <-0.145882, -0.674920, 5.612896>, 
      <0.099080, -0.747537, 5.698295>, <0.046014, -0.733836, 5.675085>, <-0.022796, -0.723641, 5.627418>, <-0.077807, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.019563, -0.714713, 5.601612>, <-0.087467, -0.687834, 5.593600>, <-0.173451, -0.655100, 5.666050>, <-0.230521, -0.617307, 5.639362>, 
      <0.045739, -0.730665, 5.667196>, <-0.008035, -0.709616, 5.640808>, <-0.086641, -0.674812, 5.609570>, <-0.145322, -0.651584, 5.602647>, 
      <0.099080, -0.747537, 5.698295>, <0.045307, -0.726488, 5.671907>, <-0.021484, -0.700603, 5.617258>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.019563, -0.714713, 5.601612>, <-0.087467, -0.687834, 5.593600>, <-0.173675, -0.660881, 5.705072>, <-0.230745, -0.623088, 5.678385>, 
      <0.045739, -0.730665, 5.667196>, <-0.008259, -0.715397, 5.679831>, <-0.098283, -0.689769, 5.738361>, <-0.151446, -0.668725, 5.732088>, 
      <0.099080, -0.747537, 5.698295>, <0.045082, -0.732269, 5.710930>, <-0.027749, -0.717689, 5.746684>, <-0.080912, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.019563, -0.714713, 5.601612>, <-0.087467, -0.687834, 5.593600>, <-0.174227, -0.655608, 5.711434>, <-0.231297, -0.617814, 5.684746>, 
      <0.045739, -0.730665, 5.667196>, <-0.008811, -0.710123, 5.686192>, <-0.096643, -0.673567, 5.759976>, <-0.153306, -0.651138, 5.753290>, 
      <0.099080, -0.747537, 5.698295>, <0.044531, -0.726996, 5.717291>, <-0.026088, -0.701495, 5.768300>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.019563, -0.714713, 5.601612>, <-0.087467, -0.687834, 5.593600>, <-0.174706, -0.647174, 5.714657>, <-0.231775, -0.609380, 5.687969>, 
      <0.045739, -0.730665, 5.667196>, <-0.009289, -0.701689, 5.689416>, <-0.092583, -0.647693, 5.771388>, <-0.153621, -0.623532, 5.764186>, 
      <0.099080, -0.747537, 5.698295>, <0.044052, -0.718562, 5.720514>, <-0.023308, -0.675114, 5.779562>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.078724, -0.691295, 5.594632>, <-0.148489, -0.664831, 5.592635>, <-0.173451, -0.655100, 5.666050>, <-0.230521, -0.617307, 5.639362>, 
      <-0.078724, -0.691295, 5.594632>, <-0.148489, -0.664831, 5.592635>, <-0.145449, -0.650118, 5.599000>, <-0.145322, -0.651584, 5.602647>, 
      <-0.078724, -0.691295, 5.594632>, <-0.080586, -0.691710, 5.600647>, <-0.080292, -0.675909, 5.606688>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.019563, -0.714713, 5.601612>, <0.045739, -0.730665, 5.667196>, <0.099080, -0.747537, 5.698295>, 
      <-0.078724, -0.691295, 5.594632>, <-0.021425, -0.715128, 5.607627>, <-0.008035, -0.709616, 5.640808>, <0.045307, -0.726488, 5.671907>, 
      <-0.078724, -0.691295, 5.594632>, <-0.021425, -0.715128, 5.607627>, <-0.021611, -0.699137, 5.613612>, <-0.021484, -0.700603, 5.617258>, 
      <-0.078724, -0.691295, 5.594632>, <-0.080586, -0.691710, 5.600647>, <-0.080292, -0.675909, 5.606688>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.146627, -0.664417, 5.586620>, <-0.237890, -0.629357, 5.678490>, <-0.294959, -0.591563, 5.651802>, 
      <-0.080586, -0.691710, 5.600647>, <-0.148489, -0.664831, 5.592635>, <-0.172744, -0.662447, 5.669228>, <-0.229813, -0.624654, 5.642540>, 
      <-0.080292, -0.675909, 5.606688>, <-0.080130, -0.677776, 5.611332>, <-0.146591, -0.668120, 5.608672>, <-0.145882, -0.674920, 5.612896>, 
      <-0.080165, -0.677375, 5.610335>, <-0.080003, -0.679242, 5.614979>, <-0.078516, -0.695066, 5.616704>, <-0.077807, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078724, -0.691295, 5.594632>, <-0.019563, -0.714713, 5.601612>, <0.045739, -0.730665, 5.667196>, <0.099080, -0.747537, 5.698295>, 
      <-0.080586, -0.691710, 5.600647>, <-0.021425, -0.715128, 5.607627>, <-0.007327, -0.716963, 5.643986>, <0.046014, -0.733836, 5.675085>, 
      <-0.080292, -0.675909, 5.606688>, <-0.080130, -0.677776, 5.611332>, <-0.023506, -0.716841, 5.623195>, <-0.022796, -0.723641, 5.627418>, 
      <-0.080165, -0.677375, 5.610335>, <-0.080003, -0.679242, 5.614979>, <-0.078516, -0.695066, 5.616704>, <-0.077807, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.012035, -0.699533, 5.678078>, <0.045739, -0.730665, 5.667196>, 
      <-0.232067, -0.611801, 5.691441>, <-0.174997, -0.649595, 5.718129>, <-0.087467, -0.687834, 5.593600>, <-0.019563, -0.714713, 5.601612>, 
      <-0.294959, -0.591563, 5.651802>, <-0.237890, -0.629357, 5.678490>, <-0.146627, -0.664417, 5.586620>, <-0.078724, -0.691295, 5.594632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.012467, -0.695357, 5.682789>, <0.045307, -0.726488, 5.671907>, 
      <-0.232067, -0.611801, 5.691441>, <-0.167629, -0.637545, 5.679001>, <-0.086641, -0.674812, 5.609570>, <-0.021484, -0.700603, 5.617258>, 
      <-0.294959, -0.591563, 5.651802>, <-0.230521, -0.617307, 5.639362>, <-0.145322, -0.651584, 5.602647>, <-0.080165, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.011236, -0.707160, 5.690121>, <0.046538, -0.738291, 5.679239>, 
      <-0.232067, -0.611801, 5.691441>, <-0.166397, -0.649348, 5.686333>, <-0.093776, -0.709706, 5.632684>, <-0.023701, -0.737444, 5.640952>, 
      <-0.294959, -0.591563, 5.651802>, <-0.229290, -0.629109, 5.646694>, <-0.146136, -0.688980, 5.626506>, <-0.076061, -0.716718, 5.634774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.011760, -0.702704, 5.685967>, <0.046014, -0.733836, 5.675085>, 
      <-0.232067, -0.611801, 5.691441>, <-0.166921, -0.644892, 5.682179>, <-0.090871, -0.696695, 5.619386>, <-0.022796, -0.723641, 5.627418>, 
      <-0.294959, -0.591563, 5.651802>, <-0.229813, -0.624654, 5.642540>, <-0.145882, -0.674920, 5.612896>, <-0.077807, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.012691, -0.701138, 5.721812>, <0.045082, -0.732269, 5.710930>, 
      <-0.232067, -0.611801, 5.691441>, <-0.167853, -0.643326, 5.718024>, <-0.098283, -0.689769, 5.738361>, <-0.027749, -0.717689, 5.746684>, 
      <-0.294959, -0.591563, 5.651802>, <-0.230745, -0.623088, 5.678385>, <-0.151446, -0.668725, 5.732088>, <-0.080912, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.013243, -0.695864, 5.728173>, <0.044531, -0.726996, 5.717291>, 
      <-0.232067, -0.611801, 5.691441>, <-0.168404, -0.638052, 5.724385>, <-0.096643, -0.673567, 5.759976>, <-0.026088, -0.701495, 5.768300>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231297, -0.617814, 5.684746>, <-0.153306, -0.651138, 5.753290>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.156530, -0.630836, 5.775530>, <-0.095045, -0.655174, 5.782784>, <-0.013722, -0.687431, 5.731396>, <0.044052, -0.718562, 5.720514>, 
      <-0.232067, -0.611801, 5.691441>, <-0.168883, -0.629618, 5.727608>, <-0.092583, -0.647693, 5.771388>, <-0.023308, -0.675114, 5.779562>, 
      <-0.294959, -0.591563, 5.651802>, <-0.231775, -0.609380, 5.687969>, <-0.153621, -0.623532, 5.764186>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.084542, -0.656986, 5.780293>, <-0.023057, -0.681324, 5.787548>, <-0.013243, -0.695864, 5.728173>, <0.044531, -0.726996, 5.717291>, 
      <-0.084572, -0.649193, 5.774320>, <-0.084092, -0.652944, 5.770143>, <-0.026644, -0.694099, 5.773472>, <-0.026088, -0.701495, 5.768300>, 
      <-0.084347, -0.650953, 5.772360>, <-0.083867, -0.654704, 5.768183>, <-0.083307, -0.671670, 5.766786>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.156530, -0.630836, 5.775530>, <-0.232067, -0.611801, 5.691441>, <-0.294959, -0.591563, 5.651802>, 
      <-0.084542, -0.656986, 5.780293>, <-0.155754, -0.628798, 5.771891>, <-0.168404, -0.638052, 5.724385>, <-0.231297, -0.617814, 5.684746>, 
      <-0.084572, -0.649193, 5.774320>, <-0.084092, -0.652944, 5.770143>, <-0.153862, -0.643742, 5.758461>, <-0.153306, -0.651138, 5.753290>, 
      <-0.084347, -0.650953, 5.772360>, <-0.083867, -0.654704, 5.768183>, <-0.083307, -0.671670, 5.766786>, <-0.082751, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>, 
      <-0.085318, -0.659024, 5.783932>, <-0.023057, -0.681324, 5.787548>, <-0.013722, -0.687431, 5.731396>, <0.044052, -0.718562, 5.720514>, 
      <-0.085318, -0.659024, 5.783932>, <-0.023057, -0.681324, 5.787548>, <-0.023534, -0.673354, 5.781522>, <-0.023308, -0.675114, 5.779562>, 
      <-0.085318, -0.659024, 5.783932>, <-0.084542, -0.656986, 5.780293>, <-0.084572, -0.649193, 5.774320>, <-0.084347, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.085318, -0.659024, 5.783932>, <-0.084542, -0.656986, 5.780293>, <-0.084572, -0.649193, 5.774320>, <-0.084347, -0.650953, 5.772360>, 
      <-0.085318, -0.659024, 5.783932>, <-0.155754, -0.628798, 5.771891>, <-0.153847, -0.621772, 5.766146>, <-0.153621, -0.623532, 5.764186>, 
      <-0.085318, -0.659024, 5.783932>, <-0.155754, -0.628798, 5.771891>, <-0.168883, -0.629618, 5.727608>, <-0.231775, -0.609380, 5.687969>, 
      <-0.085318, -0.659024, 5.783932>, <-0.156530, -0.630836, 5.775530>, <-0.232067, -0.611801, 5.691441>, <-0.294959, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.096221, -0.682147, 5.828069>, <-0.046885, -0.705748, 5.841970>, <0.027389, -0.731732, 5.817620>, <0.078187, -0.752550, 5.830678>, 
      <-0.092833, -0.683604, 5.813218>, <-0.043496, -0.707206, 5.827119>, <0.034407, -0.734056, 5.778071>, <0.085205, -0.754875, 5.791129>, 
      <-0.088116, -0.666374, 5.797058>, <-0.026631, -0.690712, 5.804313>, <0.038025, -0.716073, 5.749276>, <0.095799, -0.747205, 5.738394>, 
      <-0.085318, -0.659024, 5.783932>, <-0.023833, -0.683362, 5.791187>, <0.041306, -0.716406, 5.709177>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.071606, -0.709892, 5.090496>, <0.075738, -0.691558, 5.024066>, <0.075901, -0.672280, 4.933920>, <0.077742, -0.656161, 4.866815>, 
      <0.085067, -0.713397, 5.082914>, <0.089199, -0.695063, 5.016484>, <0.106215, -0.673408, 4.936218>, <0.108055, -0.657289, 4.869114>, 
      <0.104085, -0.720321, 5.075515>, <0.120746, -0.698545, 5.016222>, <0.130538, -0.674241, 4.931142>, <0.148586, -0.654060, 4.871691>, 
      <0.118849, -0.721331, 5.069862>, <0.135510, -0.699555, 5.010569>, <0.160960, -0.674241, 4.931142>, <0.179007, -0.654060, 4.871691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.061801, -0.726899, 5.123115>, <0.066003, -0.717986, 5.117340>, <0.070922, -0.712925, 5.101486>, <0.071606, -0.709892, 5.090496>, 
      <0.075474, -0.734475, 5.122128>, <0.079676, -0.725562, 5.116353>, <0.084383, -0.716431, 5.093904>, <0.085067, -0.713397, 5.082914>, 
      <0.095858, -0.739265, 5.117978>, <0.100178, -0.726084, 5.111632>, <0.100194, -0.725406, 5.089360>, <0.104085, -0.720321, 5.075515>, 
      <0.110657, -0.743393, 5.114931>, <0.114977, -0.730213, 5.108585>, <0.114959, -0.726416, 5.083706>, <0.118849, -0.721331, 5.069862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.019164, -0.821124, 5.162559>, <0.018536, -0.813563, 5.130231>, <0.049583, -0.752813, 5.139904>, <0.061801, -0.726899, 5.123115>, 
      <0.024159, -0.842395, 5.149925>, <0.023531, -0.834834, 5.117597>, <0.063257, -0.760390, 5.138916>, <0.075474, -0.734475, 5.122128>, 
      <0.041822, -0.878281, 5.152214>, <0.043299, -0.861292, 5.107099>, <0.082198, -0.780941, 5.138044>, <0.095858, -0.739265, 5.117978>, 
      <0.062816, -0.892291, 5.152173>, <0.064293, -0.875301, 5.107058>, <0.096997, -0.785070, 5.134997>, <0.110657, -0.743393, 5.114931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.069762, -0.675058, 5.576726>, <-0.020479, -0.699444, 5.588888>, <0.045930, -0.729884, 5.606608>, <0.095726, -0.754327, 5.616323>, 
      <-0.071960, -0.674369, 5.584109>, <-0.022677, -0.698755, 5.596271>, <0.048383, -0.726961, 5.631008>, <0.098178, -0.751404, 5.640723>, 
      <-0.076442, -0.690787, 5.587260>, <-0.017281, -0.714205, 5.594241>, <0.047753, -0.730869, 5.642583>, <0.101094, -0.747741, 5.673682>, 
      <-0.078724, -0.691295, 5.594632>, <-0.019563, -0.714713, 5.601612>, <0.045739, -0.730665, 5.667196>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178973, -0.797152, 5.625251>, <0.150761, -0.797152, 5.625251>, <0.120672, -0.766572, 5.621190>, <0.095726, -0.754327, 5.616323>, 
      <0.178971, -0.788867, 5.656878>, <0.150759, -0.788867, 5.656878>, <0.123125, -0.763649, 5.645589>, <0.098178, -0.751404, 5.640723>, 
      <0.178990, -0.801713, 5.701454>, <0.148135, -0.801713, 5.701454>, <0.127890, -0.762180, 5.668634>, <0.101094, -0.747741, 5.673682>, 
      <0.178993, -0.801448, 5.734147>, <0.148138, -0.801448, 5.734147>, <0.125876, -0.761976, 5.693248>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.101451, -0.849301, 5.396158>, <0.085100, -0.834428, 5.392301>, <0.075227, -0.799812, 5.391891>, <0.066716, -0.786114, 5.376291>, 
      <0.118822, -0.835074, 5.466904>, <0.102470, -0.820201, 5.463047>, <0.087273, -0.789303, 5.463281>, <0.078761, -0.775605, 5.447681>, 
      <0.155716, -0.812797, 5.556523>, <0.127504, -0.812797, 5.556523>, <0.113407, -0.775231, 5.548910>, <0.088461, -0.762986, 5.544044>, 
      <0.178973, -0.797152, 5.625251>, <0.150761, -0.797152, 5.625251>, <0.120672, -0.766572, 5.621190>, <0.095726, -0.754327, 5.616323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.101451, -0.849301, 5.396158>, <0.085100, -0.834428, 5.392301>, <0.075227, -0.799812, 5.391891>, <0.066716, -0.786114, 5.376291>, 
      <0.083847, -0.863720, 5.324462>, <0.067496, -0.848847, 5.320604>, <0.064275, -0.809368, 5.326977>, <0.055763, -0.795670, 5.311376>, 
      <0.060513, -0.918789, 5.222535>, <0.039518, -0.904779, 5.222576>, <0.025416, -0.857542, 5.214687>, <0.020421, -0.836271, 5.227321>, 
      <0.062816, -0.892291, 5.152173>, <0.041822, -0.878281, 5.152214>, <0.024159, -0.842395, 5.149925>, <0.019164, -0.821124, 5.162559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.023116, -0.723228, 5.252583>, <0.045360, -0.749879, 5.232880>, <0.011264, -0.787483, 5.182539>, <0.019164, -0.821124, 5.162559>, 
      <0.023116, -0.723228, 5.252583>, <0.058440, -0.768745, 5.269992>, <0.012522, -0.802630, 5.247301>, <0.020421, -0.836271, 5.227321>, 
      <0.023116, -0.723228, 5.252583>, <0.058440, -0.768745, 5.269992>, <0.039210, -0.769028, 5.281036>, <0.055763, -0.795670, 5.311376>, 
      <0.023116, -0.723228, 5.252583>, <0.036196, -0.742094, 5.289695>, <0.050162, -0.759472, 5.345951>, <0.066716, -0.786114, 5.376291>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.023116, -0.723228, 5.252583>, <0.036196, -0.742094, 5.289695>, <0.050162, -0.759472, 5.345951>, <0.066716, -0.786114, 5.376291>, 
      <0.001657, -0.718262, 5.352364>, <0.014737, -0.737128, 5.389476>, <0.062208, -0.748963, 5.417341>, <0.078761, -0.775605, 5.447681>, 
      <-0.040719, -0.684165, 5.479181>, <0.008563, -0.708550, 5.491344>, <0.038666, -0.738544, 5.534329>, <0.088461, -0.762986, 5.544044>, 
      <-0.069762, -0.675058, 5.576726>, <-0.020479, -0.699444, 5.588888>, <0.045930, -0.729884, 5.606608>, <0.095726, -0.754327, 5.616323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179013, -0.888256, 5.402779>, <0.152899, -0.888256, 5.402779>, <0.120482, -0.866611, 5.400647>, <0.101451, -0.849301, 5.396158>, 
      <0.179013, -0.888256, 5.402779>, <0.152888, -0.868668, 5.472189>, <0.137852, -0.852383, 5.471393>, <0.118822, -0.835074, 5.466904>, 
      <0.179013, -0.888256, 5.402779>, <0.152888, -0.868668, 5.472189>, <0.155721, -0.831073, 5.486756>, <0.155716, -0.812797, 5.556523>, 
      <0.179013, -0.888256, 5.402779>, <0.179002, -0.868668, 5.472189>, <0.178977, -0.815429, 5.555484>, <0.178973, -0.797152, 5.625251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.028271, -0.697743, 5.120880>, <0.041272, -0.701388, 5.111765>, <0.057764, -0.706287, 5.098293>, <0.071606, -0.709892, 5.090496>, 
      <0.028271, -0.697743, 5.120880>, <0.051331, -0.710135, 5.112435>, <0.057080, -0.709321, 5.109282>, <0.070922, -0.712925, 5.101486>, 
      <0.028271, -0.697743, 5.120880>, <0.051331, -0.710135, 5.112435>, <0.054352, -0.711530, 5.118182>, <0.066003, -0.717986, 5.117340>, 
      <0.028271, -0.697743, 5.120880>, <0.038330, -0.706490, 5.121550>, <0.050150, -0.720443, 5.123956>, <0.061801, -0.726899, 5.123115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.028271, -0.697743, 5.120880>, <0.038330, -0.706490, 5.121550>, <0.050150, -0.720443, 5.123956>, <0.061801, -0.726899, 5.123115>, 
      <0.039138, -0.684401, 5.044139>, <0.049197, -0.693148, 5.044809>, <0.054352, -0.711530, 5.118182>, <0.066003, -0.717986, 5.117340>, 
      <0.062901, -0.668636, 4.943035>, <0.061060, -0.684755, 5.010139>, <0.075054, -0.694591, 5.035056>, <0.070922, -0.712925, 5.101486>, 
      <0.077742, -0.656161, 4.866815>, <0.075901, -0.672280, 4.933920>, <0.075738, -0.691558, 5.024066>, <0.071606, -0.709892, 5.090496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.028271, -0.697743, 5.120880>, <0.039138, -0.684401, 5.044139>, <0.062901, -0.668636, 4.943035>, <0.077742, -0.656161, 4.866815>, 
      <0.028271, -0.697743, 5.120880>, <0.052138, -0.688046, 5.035024>, <0.061060, -0.684755, 5.010139>, <0.075901, -0.672280, 4.933920>, 
      <0.028271, -0.697743, 5.120880>, <0.052138, -0.688046, 5.035024>, <0.061896, -0.687953, 5.031863>, <0.075738, -0.691558, 5.024066>, 
      <0.028271, -0.697743, 5.120880>, <0.041272, -0.701388, 5.111765>, <0.057764, -0.706287, 5.098293>, <0.071606, -0.709892, 5.090496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.028271, -0.697743, 5.120880>, <0.038330, -0.706490, 5.121550>, <0.050150, -0.720443, 5.123956>, <0.061801, -0.726899, 5.123115>, 
      <0.022706, -0.704575, 5.160178>, <0.032765, -0.713322, 5.160848>, <0.037932, -0.746357, 5.140745>, <0.049583, -0.752813, 5.139904>, 
      <0.031573, -0.725185, 5.213256>, <0.053818, -0.751836, 5.193553>, <0.010637, -0.779922, 5.150211>, <0.018536, -0.813563, 5.130231>, 
      <0.023116, -0.723228, 5.252583>, <0.045360, -0.749879, 5.232880>, <0.011264, -0.787483, 5.182539>, <0.019164, -0.821124, 5.162559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178989, -0.717237, 5.049378>, <0.159890, -0.717237, 5.049378>, <0.136649, -0.722549, 5.063046>, <0.118849, -0.721331, 5.069862>, 
      <0.178989, -0.717237, 5.049378>, <0.159895, -0.693413, 4.998064>, <0.153310, -0.700772, 5.003753>, <0.135510, -0.699555, 5.010569>, 
      <0.178989, -0.717237, 5.049378>, <0.159895, -0.693413, 4.998064>, <0.160954, -0.693194, 4.984448>, <0.160960, -0.674241, 4.931142>, 
      <0.178989, -0.717237, 5.049378>, <0.178994, -0.693413, 4.998064>, <0.179002, -0.673013, 4.924997>, <0.179007, -0.654060, 4.871691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178989, -0.717237, 5.049378>, <0.159890, -0.717237, 5.049378>, <0.136649, -0.722549, 5.063046>, <0.118849, -0.721331, 5.069862>, 
      <0.178987, -0.725477, 5.067127>, <0.159888, -0.725477, 5.067127>, <0.132759, -0.727633, 5.076890>, <0.114959, -0.726416, 5.083706>, 
      <0.178980, -0.742341, 5.089743>, <0.157378, -0.742341, 5.089743>, <0.135387, -0.735906, 5.104383>, <0.114977, -0.730213, 5.108585>, 
      <0.178985, -0.759588, 5.098987>, <0.157383, -0.759588, 5.098987>, <0.131068, -0.749087, 5.110729>, <0.110657, -0.743393, 5.114931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.070460, -0.445213, 3.912879>, <-0.038072, -0.478808, 3.913524>, <0.011115, -0.518445, 3.916787>, <0.051810, -0.541279, 3.917532>, 
      <-0.041106, -0.378990, 3.932300>, <-0.008718, -0.412586, 3.932945>, <0.026080, -0.443932, 3.929550>, <0.066775, -0.466766, 3.930294>, 
      <0.006201, -0.288249, 3.944332>, <0.025216, -0.311188, 3.936696>, <0.064832, -0.345328, 3.939333>, <0.088446, -0.364545, 3.934956>, 
      <0.027387, -0.224471, 3.977616>, <0.046402, -0.247410, 3.969980>, <0.078080, -0.273685, 3.964449>, <0.101694, -0.292902, 3.960072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.035092, -0.127463, 4.078704>, <0.054753, -0.151672, 4.060926>, <0.089707, -0.181923, 4.045708>, <0.113748, -0.206319, 4.034959>, 
      <0.043911, -0.148528, 4.043342>, <0.063572, -0.172738, 4.025565>, <0.092035, -0.199203, 4.015901>, <0.116076, -0.223599, 4.005152>, 
      <0.039279, -0.188672, 3.996298>, <0.058294, -0.211611, 3.988662>, <0.084016, -0.241582, 3.975703>, <0.107630, -0.260799, 3.971326>, 
      <0.027387, -0.224471, 3.977616>, <0.046402, -0.247410, 3.969980>, <0.078080, -0.273685, 3.964449>, <0.101694, -0.292902, 3.960072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.160837, -0.320703, 3.913296>, <-0.137994, -0.360777, 3.911662>, <-0.102492, -0.411987, 3.912241>, <-0.070460, -0.445213, 3.912879>, 
      <-0.124624, -0.261037, 3.944415>, <-0.101781, -0.301111, 3.942781>, <-0.073137, -0.345764, 3.931662>, <-0.041106, -0.378990, 3.932300>, 
      <-0.056462, -0.178784, 3.968780>, <-0.039156, -0.210199, 3.954220>, <-0.017730, -0.259381, 3.953942>, <0.006201, -0.288249, 3.944332>, 
      <-0.040128, -0.121818, 4.017027>, <-0.022821, -0.153233, 4.002468>, <0.003456, -0.195603, 3.987226>, <0.027387, -0.224471, 3.977616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.064946, 0.013715, 4.196532>, <-0.037686, -0.027117, 4.157370>, <0.000696, -0.085110, 4.109804>, <0.035092, -0.127463, 4.078704>, 
      <-0.042746, -0.018344, 4.140962>, <-0.015487, -0.059176, 4.101800>, <0.009515, -0.106176, 4.074442>, <0.043911, -0.148528, 4.043342>, 
      <-0.025617, -0.071212, 4.059888>, <-0.008310, -0.102627, 4.045329>, <0.015348, -0.159804, 4.005909>, <0.039279, -0.188672, 3.996298>, 
      <-0.040128, -0.121818, 4.017027>, <-0.022821, -0.153233, 4.002468>, <0.003456, -0.195603, 3.987226>, <0.027387, -0.224471, 3.977616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.257999, -0.116219, 3.926295>, <-0.241206, -0.182135, 3.925186>, <-0.194506, -0.261638, 3.915704>, <-0.160837, -0.320703, 3.913296>, 
      <-0.213052, -0.074873, 3.975904>, <-0.196259, -0.140789, 3.974795>, <-0.158294, -0.201973, 3.946824>, <-0.124624, -0.261037, 3.944415>, 
      <-0.123242, -0.020345, 4.026818>, <-0.106319, -0.065234, 4.005190>, <-0.079990, -0.136077, 3.988572>, <-0.056462, -0.178784, 3.968780>, 
      <-0.108176, 0.021600, 4.091659>, <-0.091252, -0.023289, 4.070030>, <-0.063656, -0.079111, 4.036820>, <-0.040128, -0.121818, 4.017027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.158097, 0.161915, 4.356246>, <-0.131515, 0.120316, 4.305096>, <-0.095802, 0.059935, 4.240861>, <-0.064946, 0.013715, 4.196532>, 
      <-0.128131, 0.124815, 4.278642>, <-0.101549, 0.083216, 4.227491>, <-0.073602, 0.027875, 4.185291>, <-0.042746, -0.018344, 4.140962>, 
      <-0.090734, 0.070159, 4.166723>, <-0.073811, 0.025270, 4.145094>, <-0.049145, -0.028504, 4.079681>, <-0.025617, -0.071212, 4.059888>, 
      <-0.108176, 0.021600, 4.091659>, <-0.091252, -0.023289, 4.070030>, <-0.063656, -0.079111, 4.036820>, <-0.040128, -0.121818, 4.017027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.311092, 0.398917, 4.670178>, <-0.280795, 0.321590, 4.574604>, <-0.205443, 0.236009, 4.447352>, <-0.158097, 0.161915, 4.356246>, 
      <-0.251120, 0.340843, 4.517470>, <-0.220823, 0.263516, 4.421896>, <-0.175477, 0.198908, 4.369748>, <-0.128131, 0.124815, 4.278642>, 
      <-0.160893, 0.238154, 4.321244>, <-0.158593, 0.192009, 4.297847>, <-0.107390, 0.114335, 4.188009>, <-0.090734, 0.070159, 4.166723>, 
      <-0.151724, 0.174182, 4.159651>, <-0.149424, 0.128037, 4.136254>, <-0.124831, 0.065777, 4.112945>, <-0.108176, 0.021600, 4.091659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.268550, 0.102097, 3.920408>, <-0.277740, 0.037181, 3.922447>, <-0.274191, -0.052663, 3.927364>, <-0.257999, -0.116219, 3.926295>, 
      <-0.233502, 0.123723, 3.992181>, <-0.242693, 0.058806, 3.994220>, <-0.229244, -0.011317, 3.976973>, <-0.213052, -0.074873, 3.975904>, 
      <-0.147365, 0.143766, 4.082818>, <-0.145065, 0.097621, 4.059422>, <-0.139897, 0.023831, 4.048104>, <-0.123242, -0.020345, 4.026818>, 
      <-0.151724, 0.174182, 4.159651>, <-0.149424, 0.128037, 4.136254>, <-0.124831, 0.065777, 4.112945>, <-0.108176, 0.021600, 4.091659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.367383, 0.696077, 5.016458>, <-0.375522, 0.602503, 4.915452>, <-0.344096, 0.483152, 4.774291>, <-0.311092, 0.398917, 4.670178>, 
      <-0.283151, 0.623127, 4.778883>, <-0.291290, 0.529553, 4.677878>, <-0.284124, 0.425079, 4.621584>, <-0.251120, 0.340843, 4.517470>, 
      <-0.159955, 0.437534, 4.496244>, <-0.172960, 0.388657, 4.466856>, <-0.163491, 0.290275, 4.347671>, <-0.160893, 0.238154, 4.321244>, 
      <-0.124166, 0.342405, 4.254318>, <-0.137172, 0.293528, 4.224929>, <-0.154322, 0.226304, 4.186078>, <-0.151724, 0.174182, 4.159651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.204351, 0.262727, 3.914393>, <-0.231863, 0.218693, 3.915068>, <-0.261275, 0.153486, 3.918794>, <-0.268550, 0.102097, 3.920408>, 
      <-0.180296, 0.286630, 4.016371>, <-0.207808, 0.242596, 4.017046>, <-0.226227, 0.175112, 3.990567>, <-0.233502, 0.123723, 3.992181>, 
      <-0.109509, 0.303445, 4.155239>, <-0.122515, 0.254568, 4.125850>, <-0.149962, 0.195887, 4.109246>, <-0.147365, 0.143766, 4.082818>, 
      <-0.124166, 0.342405, 4.254318>, <-0.137172, 0.293528, 4.224929>, <-0.154322, 0.226304, 4.186078>, <-0.151724, 0.174182, 4.159651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.273747, 0.828275, 5.133634>, <-0.314117, 0.793056, 5.106661>, <-0.363844, 0.736769, 5.060382>, <-0.367383, 0.696077, 5.016458>, 
      <-0.220147, 0.755998, 4.879088>, <-0.260517, 0.720779, 4.852114>, <-0.279612, 0.663820, 4.822807>, <-0.283151, 0.623127, 4.778883>, 
      <-0.115624, 0.551361, 4.587201>, <-0.136730, 0.516965, 4.564065>, <-0.149613, 0.476402, 4.519615>, <-0.159955, 0.437534, 4.496244>, 
      <-0.074269, 0.465269, 4.334676>, <-0.095375, 0.430872, 4.311540>, <-0.113824, 0.381273, 4.277688>, <-0.124166, 0.342405, 4.254318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.074280, 0.413030, 3.915642>, <-0.117050, 0.371483, 3.914887>, <-0.172756, 0.313295, 3.913618>, <-0.204351, 0.262727, 3.914393>, 
      <-0.074277, 0.428702, 4.041352>, <-0.117047, 0.387155, 4.040597>, <-0.148701, 0.337199, 4.015596>, <-0.180296, 0.286630, 4.016371>, 
      <-0.054864, 0.424872, 4.216185>, <-0.075970, 0.390476, 4.193049>, <-0.099167, 0.342313, 4.178609>, <-0.109509, 0.303445, 4.155239>, 
      <-0.074269, 0.465269, 4.334676>, <-0.095375, 0.430872, 4.311540>, <-0.113824, 0.381273, 4.277688>, <-0.124166, 0.342405, 4.254318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.074247, 0.533360, 3.919311>, <0.023780, 0.506107, 3.919643>, <-0.033142, 0.452992, 3.916368>, <-0.074280, 0.413030, 3.915642>, 
      <0.059059, 0.548328, 4.068413>, <0.008592, 0.521075, 4.068745>, <-0.033139, 0.468663, 4.042078>, <-0.074277, 0.428702, 4.041352>, 
      <0.046476, 0.540995, 4.273567>, <0.002629, 0.515080, 4.262568>, <-0.031222, 0.463402, 4.242101>, <-0.054864, 0.424872, 4.216185>, 
      <0.023619, 0.583254, 4.416318>, <-0.020228, 0.557339, 4.405320>, <-0.050627, 0.503799, 4.360592>, <-0.074269, 0.465269, 4.334676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.127128, 0.905674, 5.176983>, <-0.175471, 0.888690, 5.172797>, <-0.239145, 0.858462, 5.156753>, <-0.273747, 0.828275, 5.133634>, 
      <-0.101421, 0.838072, 4.935642>, <-0.149763, 0.821087, 4.931456>, <-0.185545, 0.786184, 4.902206>, <-0.220147, 0.755998, 4.879088>, 
      <-0.014614, 0.653942, 4.655101>, <-0.058462, 0.628028, 4.644103>, <-0.091982, 0.589891, 4.613117>, <-0.115624, 0.551361, 4.587201>, 
      <0.023619, 0.583254, 4.416318>, <-0.020228, 0.557339, 4.405320>, <-0.050627, 0.503799, 4.360592>, <-0.074269, 0.465269, 4.334676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.183824, -0.587893, 3.917532>, <0.182733, -0.516171, 3.927061>, <0.181243, -0.417968, 3.928000>, <0.180187, -0.348820, 3.949295>, 
      <0.141823, -0.587893, 3.917532>, <0.140732, -0.516171, 3.927061>, <0.152151, -0.417968, 3.928000>, <0.151095, -0.348820, 3.949295>, 
      <0.088434, -0.561829, 3.918202>, <0.103399, -0.487316, 3.930964>, <0.110781, -0.382721, 3.930816>, <0.124029, -0.311078, 3.955932>, 
      <0.051810, -0.541279, 3.917532>, <0.066775, -0.466766, 3.930294>, <0.088446, -0.364545, 3.934956>, <0.101694, -0.292902, 3.960072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179021, -0.273517, 4.014350>, <0.150245, -0.273517, 4.014350>, <0.133020, -0.225875, 4.026342>, <0.113748, -0.206319, 4.034959>, 
      <0.179256, -0.286562, 3.987496>, <0.150479, -0.286562, 3.987496>, <0.135347, -0.243155, 3.996535>, <0.116076, -0.223599, 4.005152>, 
      <0.179751, -0.320290, 3.958082>, <0.150659, -0.320290, 3.958082>, <0.129965, -0.278975, 3.967187>, <0.107630, -0.260799, 3.971326>, 
      <0.180187, -0.348820, 3.949295>, <0.151095, -0.348820, 3.949295>, <0.124029, -0.311078, 3.955932>, <0.101694, -0.292902, 3.960072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.035411, -0.074465, 4.229430>, <-0.002997, -0.108166, 4.197435>, <0.051198, -0.152144, 4.166519>, <0.087524, -0.187715, 4.141513>, 
      <-0.009448, -0.088470, 4.186134>, <0.022966, -0.122171, 4.154138>, <0.064260, -0.157947, 4.136342>, <0.100586, -0.193518, 4.111337>, 
      <0.024116, -0.101245, 4.122715>, <0.043777, -0.125455, 4.104938>, <0.087456, -0.165215, 4.074529>, <0.111497, -0.189611, 4.063780>, 
      <0.035092, -0.127463, 4.078704>, <0.054753, -0.151672, 4.060926>, <0.089707, -0.181923, 4.045708>, <0.113748, -0.206319, 4.034959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.205350, 0.116782, 4.430603>, <-0.159515, 0.059033, 4.366592>, <-0.091270, -0.016389, 4.284568>, <-0.035411, -0.074465, 4.229430>, 
      <-0.155557, 0.092420, 4.362865>, <-0.109722, 0.034670, 4.298854>, <-0.065307, -0.030394, 4.241272>, <-0.009448, -0.088470, 4.186134>, 
      <-0.093569, 0.055050, 4.268180>, <-0.066309, 0.014218, 4.229018>, <-0.010279, -0.058893, 4.153815>, <0.024116, -0.101245, 4.122715>, 
      <-0.064946, 0.013715, 4.196532>, <-0.037686, -0.027117, 4.157370>, <0.000696, -0.085110, 4.109804>, <0.035092, -0.127463, 4.078704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.308810, 0.270000, 4.611247>, <-0.279985, 0.232237, 4.549960>, <-0.241752, 0.162646, 4.481440>, <-0.205350, 0.116782, 4.430603>, 
      <-0.257853, 0.249664, 4.534190>, <-0.229028, 0.211901, 4.472902>, <-0.191960, 0.138284, 4.413702>, <-0.155557, 0.092420, 4.362865>, 
      <-0.189217, 0.200444, 4.436838>, <-0.162635, 0.158845, 4.385688>, <-0.124425, 0.101270, 4.312509>, <-0.093569, 0.055050, 4.268180>, 
      <-0.158097, 0.161915, 4.356246>, <-0.131515, 0.120316, 4.305096>, <-0.095802, 0.059935, 4.240861>, <-0.064946, 0.013715, 4.196532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.525278, 0.535913, 5.110834>, <-0.481074, 0.453437, 4.954989>, <-0.376382, 0.358525, 4.754918>, <-0.308810, 0.270000, 4.611247>, 
      <-0.460463, 0.517581, 4.973878>, <-0.416259, 0.435105, 4.818033>, <-0.325424, 0.338189, 4.677861>, <-0.257853, 0.249664, 4.534190>, 
      <-0.363685, 0.449846, 4.804096>, <-0.333388, 0.372519, 4.708522>, <-0.236563, 0.274537, 4.527944>, <-0.189217, 0.200444, 4.436838>, 
      <-0.311092, 0.398917, 4.670178>, <-0.280795, 0.321590, 4.574604>, <-0.205443, 0.236009, 4.447352>, <-0.158097, 0.161915, 4.356246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.541183, 0.703564, 5.430505>, <-0.568487, 0.653141, 5.338519>, <-0.551636, 0.585093, 5.203764>, <-0.525278, 0.535913, 5.110834>, 
      <-0.497220, 0.734192, 5.306884>, <-0.524525, 0.683769, 5.214898>, <-0.486821, 0.566761, 5.066808>, <-0.460463, 0.517581, 4.973878>, 
      <-0.410631, 0.733533, 5.138439>, <-0.418770, 0.639958, 5.037434>, <-0.396689, 0.534081, 4.908209>, <-0.363685, 0.449846, 4.804096>, 
      <-0.367383, 0.696077, 5.016458>, <-0.375522, 0.602503, 4.915452>, <-0.344096, 0.483152, 4.774291>, <-0.311092, 0.398917, 4.670178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.541183, 0.703564, 5.430505>, <-0.497220, 0.734192, 5.306884>, <-0.410631, 0.733533, 5.138439>, <-0.367383, 0.696077, 5.016458>, 
      <-0.515511, 0.750973, 5.516992>, <-0.471548, 0.781600, 5.393372>, <-0.407092, 0.774225, 5.182363>, <-0.363844, 0.736769, 5.060382>, 
      <-0.424210, 0.802532, 5.614850>, <-0.392955, 0.842110, 5.457559>, <-0.346911, 0.837276, 5.262395>, <-0.314117, 0.793056, 5.106661>, 
      <-0.357048, 0.846582, 5.677585>, <-0.325792, 0.886160, 5.520293>, <-0.306540, 0.872495, 5.289369>, <-0.273747, 0.828275, 5.133634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.125747, 0.976036, 5.818554>, <-0.203988, 0.945940, 5.785624>, <-0.297695, 0.885510, 5.733026>, <-0.357048, 0.846582, 5.677585>, 
      <-0.106899, 1.026329, 5.632526>, <-0.185140, 0.996232, 5.599596>, <-0.266440, 0.925088, 5.575734>, <-0.325792, 0.886160, 5.520293>, 
      <-0.146885, 0.957628, 5.362459>, <-0.195228, 0.940644, 5.358274>, <-0.271938, 0.902682, 5.312488>, <-0.306540, 0.872495, 5.289369>, 
      <-0.127128, 0.905674, 5.176983>, <-0.175471, 0.888690, 5.172797>, <-0.239145, 0.858462, 5.156753>, <-0.273747, 0.828275, 5.133634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178849, 0.987286, 5.172820>, <0.178880, 0.915274, 4.925250>, <0.179854, 0.700024, 4.641611>, <0.179035, 0.614976, 4.398212>, 
      <0.083839, 0.987286, 5.172820>, <0.083869, 0.915274, 4.925250>, <0.131959, 0.700024, 4.641611>, <0.131140, 0.614976, 4.398212>, 
      <-0.037787, 0.937062, 5.184718>, <-0.012079, 0.869460, 4.943378>, <0.025689, 0.677762, 4.665211>, <0.063922, 0.607074, 4.426427>, 
      <-0.127128, 0.905674, 5.176983>, <-0.101421, 0.838072, 4.935642>, <-0.014614, 0.653942, 4.655101>, <0.023619, 0.583254, 4.416318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178849, 1.052721, 5.903135>, <0.081262, 1.052721, 5.903135>, <-0.040972, 1.008646, 5.854234>, <-0.125747, 0.976036, 5.818554>, 
      <0.178818, 1.117746, 5.692993>, <0.081231, 1.117746, 5.692993>, <-0.022124, 1.058938, 5.668206>, <-0.106899, 1.026329, 5.632526>, 
      <0.178823, 1.048724, 5.384038>, <0.083812, 1.048724, 5.384038>, <-0.057543, 0.989016, 5.370194>, <-0.146885, 0.957628, 5.362459>, 
      <0.178849, 0.987286, 5.172820>, <0.083839, 0.987286, 5.172820>, <-0.037787, 0.937062, 5.184718>, <-0.127128, 0.905674, 5.176983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179028, -0.284448, 4.081814>, <0.179026, -0.281996, 4.061458>, <0.178860, -0.264559, 4.032792>, <0.179021, -0.273517, 4.014350>, 
      <0.135250, -0.284448, 4.081814>, <0.135248, -0.281996, 4.061458>, <0.150083, -0.264559, 4.032792>, <0.150245, -0.273517, 4.014350>, 
      <0.115592, -0.215199, 4.122192>, <0.128653, -0.221002, 4.092015>, <0.130769, -0.209167, 4.055163>, <0.133020, -0.225875, 4.026342>, 
      <0.087524, -0.187715, 4.141513>, <0.100586, -0.193518, 4.111337>, <0.111497, -0.189611, 4.063780>, <0.113748, -0.206319, 4.034959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.022858, -0.165939, 4.244936>, <0.067944, -0.202408, 4.215213>, <0.113874, -0.291134, 4.160587>, <0.179037, -0.291134, 4.160587>, 
      <0.044420, -0.167113, 4.214680>, <0.089506, -0.203582, 4.184957>, <0.113874, -0.288433, 4.137024>, <0.179037, -0.288433, 4.137024>, 
      <0.072983, -0.181255, 4.175106>, <0.101050, -0.208739, 4.155785>, <0.135253, -0.287285, 4.105360>, <0.179031, -0.287285, 4.105360>, 
      <0.087524, -0.187715, 4.141513>, <0.115592, -0.215199, 4.122192>, <0.135250, -0.284448, 4.081814>, <0.179028, -0.284448, 4.081814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.140220, -0.032896, 4.371059>, <-0.094259, -0.071907, 4.328823>, <-0.028071, -0.124744, 4.278512>, <0.022858, -0.165939, 4.244936>, 
      <-0.105438, -0.037502, 4.329605>, <-0.059477, -0.076513, 4.287368>, <-0.006509, -0.125917, 4.248256>, <0.044420, -0.167113, 4.214680>, 
      <-0.062324, -0.059947, 4.274312>, <-0.029910, -0.093648, 4.242316>, <0.036657, -0.145684, 4.200112>, <0.072983, -0.181255, 4.175106>, 
      <-0.035411, -0.074465, 4.229430>, <-0.002997, -0.108166, 4.197435>, <0.051198, -0.152144, 4.166519>, <0.087524, -0.187715, 4.141513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.357367, 0.156790, 4.594345>, <-0.301738, 0.102454, 4.517389>, <-0.208532, 0.025086, 4.433834>, <-0.140220, -0.032896, 4.371059>, 
      <-0.308917, 0.154711, 4.546542>, <-0.253288, 0.100375, 4.469586>, <-0.173750, 0.020480, 4.392380>, <-0.105438, -0.037502, 4.329605>, 
      <-0.244087, 0.135735, 4.483302>, <-0.198252, 0.077986, 4.419290>, <-0.118184, -0.001871, 4.329449>, <-0.062324, -0.059947, 4.274312>, 
      <-0.205350, 0.116782, 4.430603>, <-0.159515, 0.059033, 4.366592>, <-0.091270, -0.016389, 4.284568>, <-0.035411, -0.074465, 4.229430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.465100, 0.284432, 4.820492>, <-0.439539, 0.249902, 4.747910>, <-0.400253, 0.198679, 4.653673>, <-0.357367, 0.156790, 4.594345>, 
      <-0.416993, 0.292896, 4.759078>, <-0.391433, 0.258367, 4.686496>, <-0.351803, 0.196600, 4.605869>, <-0.308917, 0.154711, 4.546542>, 
      <-0.351082, 0.286870, 4.675170>, <-0.322257, 0.249107, 4.613882>, <-0.280489, 0.181599, 4.534139>, <-0.244087, 0.135735, 4.483302>, 
      <-0.308810, 0.270000, 4.611247>, <-0.279985, 0.232237, 4.549960>, <-0.241752, 0.162646, 4.481440>, <-0.205350, 0.116782, 4.430603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.596322, 0.479591, 5.272874>, <-0.576176, 0.430314, 5.129480>, <-0.511455, 0.347052, 4.952120>, <-0.465100, 0.284432, 4.820492>, 
      <-0.575356, 0.513447, 5.233925>, <-0.555210, 0.464171, 5.090530>, <-0.463348, 0.355516, 4.890706>, <-0.416993, 0.292896, 4.759078>, 
      <-0.548934, 0.542604, 5.160819>, <-0.504730, 0.460128, 5.004974>, <-0.418654, 0.375394, 4.818842>, <-0.351082, 0.286870, 4.675170>, 
      <-0.525278, 0.535913, 5.110834>, <-0.481074, 0.453437, 4.954989>, <-0.376382, 0.358525, 4.754918>, <-0.308810, 0.270000, 4.611247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.574424, 0.551838, 5.598643>, <-0.594209, 0.534696, 5.501798>, <-0.609535, 0.511910, 5.366922>, <-0.596322, 0.479591, 5.272874>, 
      <-0.563181, 0.611492, 5.566539>, <-0.582966, 0.594350, 5.469694>, <-0.588569, 0.545766, 5.327973>, <-0.575356, 0.513447, 5.233925>, 
      <-0.563590, 0.687954, 5.493512>, <-0.590894, 0.637531, 5.401526>, <-0.575292, 0.591784, 5.253749>, <-0.548934, 0.542604, 5.160819>, 
      <-0.541183, 0.703564, 5.430505>, <-0.568487, 0.653141, 5.338519>, <-0.551636, 0.585093, 5.203764>, <-0.525278, 0.535913, 5.110834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.446824, 0.609113, 6.004634>, <-0.502630, 0.600377, 5.888856>, <-0.549018, 0.573850, 5.723002>, <-0.574424, 0.551838, 5.598643>, 
      <-0.419170, 0.703867, 5.929241>, <-0.474976, 0.695131, 5.813463>, <-0.537775, 0.633504, 5.690898>, <-0.563181, 0.611492, 5.566539>, 
      <-0.380551, 0.816821, 5.795860>, <-0.447713, 0.772772, 5.733126>, <-0.537918, 0.735363, 5.580000>, <-0.563590, 0.687954, 5.493512>, 
      <-0.357048, 0.846582, 5.677585>, <-0.424210, 0.802532, 5.614850>, <-0.515511, 0.750973, 5.516992>, <-0.541183, 0.703564, 5.430505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.240121, 0.604172, 6.292211>, <-0.329234, 0.604881, 6.234341>, <-0.400794, 0.616319, 6.100132>, <-0.446824, 0.609113, 6.004634>, 
      <-0.214849, 0.753461, 6.187862>, <-0.303963, 0.754170, 6.129992>, <-0.373140, 0.711073, 6.024739>, <-0.419170, 0.703867, 5.929241>, 
      <-0.143647, 0.928273, 5.995225>, <-0.221888, 0.898177, 5.962295>, <-0.321198, 0.855749, 5.851301>, <-0.380551, 0.816821, 5.795860>, 
      <-0.125747, 0.976036, 5.818554>, <-0.203988, 0.945940, 5.785624>, <-0.297695, 0.885510, 5.733026>, <-0.357048, 0.846582, 5.677585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179034, 0.604132, 6.411065>, <0.048330, 0.604132, 6.411065>, <-0.130505, 0.603300, 6.363395>, <-0.240121, 0.604172, 6.292211>, 
      <0.179003, 0.777822, 6.305415>, <0.048299, 0.777822, 6.305415>, <-0.105234, 0.752588, 6.259046>, <-0.214849, 0.753461, 6.187862>, 
      <0.178878, 0.992625, 6.097348>, <0.081291, 0.992625, 6.097348>, <-0.058872, 0.960882, 6.030905>, <-0.143647, 0.928273, 5.995225>, 
      <0.178849, 1.052721, 5.903135>, <0.081262, 1.052721, 5.903135>, <-0.040972, 1.008646, 5.854234>, <-0.125747, 0.976036, 5.818554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179034, 0.604132, 6.411065>, <0.179064, 0.432290, 6.515591>, <0.179043, 0.154336, 6.567108>, <0.179044, -0.046742, 6.571900>, 
      <0.048330, 0.604132, 6.411065>, <0.048360, 0.432290, 6.515591>, <0.029856, 0.154336, 6.567108>, <0.029857, -0.046742, 6.571900>, 
      <-0.130505, 0.603300, 6.363395>, <-0.152027, 0.476168, 6.452257>, <-0.161435, 0.205194, 6.493392>, <-0.154747, 0.049011, 6.502572>, 
      <-0.240121, 0.604172, 6.292211>, <-0.261642, 0.477040, 6.381073>, <-0.280439, 0.257918, 6.420488>, <-0.273750, 0.101735, 6.429667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.048490, -0.180311, 4.332366>, <0.015501, -0.219193, 4.294235>, <0.094999, -0.300486, 4.221708>, <0.179026, -0.300486, 4.221708>, 
      <-0.025457, -0.172802, 4.308329>, <0.038534, -0.211683, 4.270198>, <0.094999, -0.299081, 4.203211>, <0.179026, -0.299081, 4.203211>, 
      <0.003061, -0.164861, 4.272714>, <0.048148, -0.201330, 4.242991>, <0.113874, -0.293247, 4.179016>, <0.179037, -0.293247, 4.179016>, 
      <0.022858, -0.165939, 4.244936>, <0.067944, -0.202408, 4.215213>, <0.113874, -0.291134, 4.160587>, <0.179037, -0.291134, 4.160587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.236859, -0.047790, 4.469526>, <-0.183433, -0.087046, 4.424009>, <-0.109733, -0.143099, 4.368859>, <-0.048490, -0.180311, 4.332366>, 
      <-0.208809, -0.031226, 4.443605>, <-0.155382, -0.070482, 4.398088>, <-0.086699, -0.135590, 4.344822>, <-0.025457, -0.172802, 4.308329>, 
      <-0.166882, -0.029365, 4.402836>, <-0.120921, -0.068377, 4.360600>, <-0.047868, -0.123666, 4.306290>, <0.003061, -0.164861, 4.272714>, 
      <-0.140220, -0.032896, 4.371059>, <-0.094259, -0.071907, 4.328823>, <-0.028071, -0.124744, 4.278512>, <0.022858, -0.165939, 4.244936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.468174, 0.128060, 4.689919>, <-0.411263, 0.081743, 4.608764>, <-0.309545, 0.005617, 4.531451>, <-0.236859, -0.047790, 4.469526>, 
      <-0.439089, 0.150478, 4.664368>, <-0.382177, 0.104161, 4.583213>, <-0.281494, 0.022182, 4.505530>, <-0.208809, -0.031226, 4.443605>, 
      <-0.389198, 0.158156, 4.625751>, <-0.333569, 0.103820, 4.548795>, <-0.235194, 0.028616, 4.465611>, <-0.166882, -0.029365, 4.402836>, 
      <-0.357367, 0.156790, 4.594345>, <-0.301738, 0.102454, 4.517389>, <-0.208532, 0.025086, 4.433834>, <-0.140220, -0.032896, 4.371059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.570716, 0.223919, 4.945603>, <-0.548089, 0.198952, 4.864846>, <-0.513691, 0.165104, 4.754826>, <-0.468174, 0.128060, 4.689919>, 
      <-0.540239, 0.253650, 4.915117>, <-0.517612, 0.228683, 4.834360>, <-0.484606, 0.187523, 4.729275>, <-0.439089, 0.150478, 4.664368>, 
      <-0.497204, 0.278784, 4.861476>, <-0.471643, 0.244254, 4.788895>, <-0.432084, 0.200045, 4.685079>, <-0.389198, 0.158156, 4.625751>, 
      <-0.465100, 0.284432, 4.820492>, <-0.439539, 0.249902, 4.747910>, <-0.400253, 0.198679, 4.653673>, <-0.357367, 0.156790, 4.594345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.652139, 0.331056, 5.346507>, <-0.644375, 0.313667, 5.221079>, <-0.603521, 0.260117, 5.062686>, <-0.570716, 0.223919, 4.945603>, 
      <-0.640403, 0.381066, 5.335769>, <-0.632639, 0.363677, 5.210341>, <-0.573043, 0.289849, 5.032200>, <-0.540239, 0.253650, 4.915117>, 
      <-0.616074, 0.447695, 5.309568>, <-0.595928, 0.398418, 5.166174>, <-0.543559, 0.341404, 4.993104>, <-0.497204, 0.278784, 4.861476>, 
      <-0.596322, 0.479591, 5.272874>, <-0.576176, 0.430314, 5.129480>, <-0.511455, 0.347052, 4.952120>, <-0.465100, 0.284432, 4.820492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.613516, 0.319778, 5.637047>, <-0.627235, 0.326898, 5.550421>, <-0.657524, 0.343117, 5.433504>, <-0.652139, 0.331056, 5.346507>, 
      <-0.604792, 0.390736, 5.634654>, <-0.618511, 0.397857, 5.548028>, <-0.645788, 0.393126, 5.422766>, <-0.640403, 0.381066, 5.335769>, 
      <-0.586136, 0.489698, 5.632085>, <-0.605921, 0.472556, 5.535240>, <-0.629287, 0.480014, 5.403617>, <-0.616074, 0.447695, 5.309568>, 
      <-0.574424, 0.551838, 5.598643>, <-0.594209, 0.534696, 5.501798>, <-0.609535, 0.511910, 5.366922>, <-0.596322, 0.479591, 5.272874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.526531, 0.265862, 6.139644>, <-0.585306, 0.303580, 6.002532>, <-0.589526, 0.307327, 5.788528>, <-0.613516, 0.319778, 5.637047>, 
      <-0.522185, 0.378298, 6.127179>, <-0.580960, 0.416017, 5.990066>, <-0.580803, 0.378285, 5.786134>, <-0.604792, 0.390736, 5.634654>, 
      <-0.472029, 0.522749, 6.073351>, <-0.527835, 0.514012, 5.957573>, <-0.560729, 0.511709, 5.756444>, <-0.586136, 0.489698, 5.632085>, 
      <-0.446824, 0.609113, 6.004634>, <-0.502630, 0.600377, 5.888856>, <-0.549018, 0.573850, 5.723002>, <-0.574424, 0.551838, 5.598643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.526531, 0.265862, 6.139644>, <-0.522185, 0.378298, 6.127179>, <-0.472029, 0.522749, 6.073351>, <-0.446824, 0.609113, 6.004634>, 
      <-0.478601, 0.235103, 6.251457>, <-0.474256, 0.347540, 6.238991>, <-0.425999, 0.529955, 6.168850>, <-0.400794, 0.616319, 6.100132>, 
      <-0.373843, 0.146081, 6.368347>, <-0.380532, 0.302264, 6.359167>, <-0.350755, 0.477749, 6.323203>, <-0.329234, 0.604881, 6.234341>, 
      <-0.273750, 0.101735, 6.429667>, <-0.280439, 0.257918, 6.420488>, <-0.261642, 0.477040, 6.381073>, <-0.240121, 0.604172, 6.292211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.123070, -0.213514, 4.397223>, <-0.037573, -0.245612, 4.355822>, <0.078765, -0.300486, 4.283735>, <0.179035, -0.300486, 4.283735>, 
      <-0.111340, -0.191479, 4.378374>, <-0.025843, -0.223578, 4.336974>, <0.078761, -0.295590, 4.265782>, <0.179030, -0.295590, 4.265782>, 
      <-0.069601, -0.187194, 4.354397>, <-0.005610, -0.226075, 4.316266>, <0.094999, -0.301895, 4.240262>, <0.179026, -0.301895, 4.240262>, 
      <-0.048490, -0.180311, 4.332366>, <0.015501, -0.219193, 4.294235>, <0.094999, -0.300486, 4.221708>, <0.179026, -0.300486, 4.221708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.627502, 0.126006, 4.982941>, <-0.605329, 0.110949, 4.899334>, <-0.557559, 0.073273, 4.794906>, <-0.510871, 0.038472, 4.729197>, 
      <-0.620721, 0.160977, 4.979850>, <-0.598548, 0.145920, 4.896243>, <-0.558091, 0.105283, 4.794318>, <-0.511403, 0.070482, 4.728609>, 
      <-0.591526, 0.203618, 4.966419>, <-0.568900, 0.178651, 4.885662>, <-0.534509, 0.149059, 4.773114>, <-0.488991, 0.112015, 4.708207>, 
      <-0.570716, 0.223919, 4.945603>, <-0.548089, 0.198952, 4.864846>, <-0.513691, 0.165104, 4.754826>, <-0.468174, 0.128060, 4.689919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.673868, 0.149162, 5.343822>, <-0.673061, 0.156744, 5.234713>, <-0.655123, 0.144763, 5.087095>, <-0.627502, 0.126006, 4.982941>, 
      <-0.675242, 0.203596, 5.351297>, <-0.674435, 0.211178, 5.242188>, <-0.648342, 0.179735, 5.084004>, <-0.620721, 0.160977, 4.979850>, 
      <-0.664431, 0.278680, 5.357753>, <-0.656667, 0.261291, 5.232325>, <-0.624331, 0.239816, 5.083502>, <-0.591526, 0.203618, 4.966419>, 
      <-0.652139, 0.331056, 5.346507>, <-0.644375, 0.313667, 5.221079>, <-0.603521, 0.260117, 5.062686>, <-0.570716, 0.223919, 4.945603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.632171, 0.082119, 5.614484>, <-0.652127, 0.114234, 5.538823>, <-0.674492, 0.143299, 5.428199>, <-0.673868, 0.149162, 5.343822>, 
      <-0.633480, 0.151981, 5.631161>, <-0.653436, 0.184096, 5.555500>, <-0.675866, 0.197733, 5.435674>, <-0.675242, 0.203596, 5.351297>, 
      <-0.622277, 0.248518, 5.639450>, <-0.635995, 0.255638, 5.552824>, <-0.669816, 0.290741, 5.444750>, <-0.664431, 0.278680, 5.357753>, 
      <-0.613516, 0.319778, 5.637047>, <-0.627235, 0.326898, 5.550421>, <-0.657524, 0.343117, 5.433504>, <-0.652139, 0.331056, 5.346507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.476854, -0.167894, 6.090778>, <-0.551900, -0.087774, 5.963646>, <-0.592541, 0.018342, 5.764736>, <-0.632171, 0.082119, 5.614484>, 
      <-0.504359, -0.045452, 6.131045>, <-0.579405, 0.034668, 6.003914>, <-0.593850, 0.088204, 5.781414>, <-0.633480, 0.151981, 5.631161>, 
      <-0.531590, 0.134966, 6.154156>, <-0.590365, 0.172684, 6.017044>, <-0.598287, 0.236067, 5.790931>, <-0.622277, 0.248518, 5.639450>, 
      <-0.526531, 0.265862, 6.139644>, <-0.585306, 0.303580, 6.002532>, <-0.589526, 0.307327, 5.788528>, <-0.613516, 0.319778, 5.637047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.197909, -0.381506, 6.350145>, <-0.220933, -0.251950, 6.419346>, <-0.267400, -0.046547, 6.438382>, <-0.273750, 0.101735, 6.429667>, 
      <-0.133939, -0.416299, 6.390073>, <-0.156963, -0.286743, 6.459274>, <-0.148396, -0.099271, 6.511287>, <-0.154747, 0.049011, 6.502572>, 
      <-0.020797, -0.437314, 6.406246>, <0.002340, -0.329476, 6.486163>, <-0.006620, -0.170269, 6.527612>, <0.029857, -0.046742, 6.571900>, 
      <0.057453, -0.458500, 6.424273>, <0.080590, -0.350662, 6.504190>, <0.142567, -0.170269, 6.527612>, <0.179044, -0.046742, 6.571900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.197909, -0.381506, 6.350145>, <-0.298825, -0.326619, 6.287157>, <-0.418320, -0.230386, 6.189937>, <-0.476854, -0.167894, 6.090778>, 
      <-0.220933, -0.251950, 6.419346>, <-0.321849, -0.197063, 6.356358>, <-0.445825, -0.107944, 6.230204>, <-0.504359, -0.045452, 6.131045>, 
      <-0.267400, -0.046547, 6.438382>, <-0.367493, -0.002201, 6.377062>, <-0.483660, 0.104207, 6.265969>, <-0.531590, 0.134966, 6.154156>, 
      <-0.273750, 0.101735, 6.429667>, <-0.373843, 0.146081, 6.368347>, <-0.478601, 0.235103, 6.251457>, <-0.526531, 0.265862, 6.139644>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179040, -0.483564, 6.436985>, <0.179038, -0.371131, 6.515536>, <0.179045, -0.183858, 6.575167>, <0.179044, -0.046742, 6.571900>, 
      <0.179040, -0.483564, 6.436985>, <0.141600, -0.371131, 6.515536>, <0.142568, -0.307385, 6.530879>, <0.142567, -0.170269, 6.527612>, 
      <0.179040, -0.483564, 6.436985>, <0.141600, -0.371131, 6.515536>, <0.115866, -0.360213, 6.512317>, <0.080590, -0.350662, 6.504190>, 
      <0.179040, -0.483564, 6.436985>, <0.141602, -0.483564, 6.436985>, <0.092728, -0.468051, 6.432400>, <0.057453, -0.458500, 6.424273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179040, -0.483564, 6.436985>, <0.179038, -0.371131, 6.515536>, <0.179045, -0.183858, 6.575167>, <0.179044, -0.046742, 6.571900>, 
      <0.179040, -0.483564, 6.436985>, <0.215074, -0.371131, 6.515536>, <0.214080, -0.307385, 6.530879>, <0.214079, -0.170269, 6.527612>, 
      <0.179040, -0.483564, 6.436985>, <0.215074, -0.371131, 6.515536>, <0.240468, -0.360171, 6.512135>, <0.274317, -0.350754, 6.504122>, 
      <0.179040, -0.483564, 6.436985>, <0.215077, -0.483564, 6.436985>, <0.261979, -0.467917, 6.432286>, <0.295828, -0.458500, 6.424273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179040, -0.483564, 6.436985>, <0.141602, -0.483564, 6.436985>, <0.092728, -0.468051, 6.432400>, <0.057453, -0.458500, 6.424273>, 
      <0.215077, -0.483564, 6.436985>, <0.177639, -0.483564, 6.436985>, <0.115866, -0.360213, 6.512317>, <0.080590, -0.350662, 6.504190>, 
      <0.261979, -0.467917, 6.432286>, <0.240468, -0.360171, 6.512135>, <0.177602, -0.293797, 6.483324>, <0.142567, -0.170269, 6.527612>, 
      <0.295828, -0.458500, 6.424273>, <0.274317, -0.350754, 6.504122>, <0.214079, -0.170269, 6.527612>, <0.179044, -0.046742, 6.571900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.109463, -0.294848, 4.430342>, <-0.026766, -0.315084, 4.398284>, <0.088085, -0.334319, 4.345761>, <0.179058, -0.334319, 4.345761>, 
      <-0.111706, -0.269595, 4.422097>, <-0.029008, -0.289831, 4.390038>, <0.088088, -0.315010, 4.337018>, <0.179061, -0.315010, 4.337018>, 
      <-0.133068, -0.232295, 4.413288>, <-0.047571, -0.264393, 4.371888>, <0.078771, -0.306063, 4.304184>, <0.179040, -0.306063, 4.304184>, 
      <-0.123070, -0.213514, 4.397223>, <-0.037573, -0.245612, 4.355822>, <0.078765, -0.300486, 4.283735>, <0.179035, -0.300486, 4.283735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.293158, -0.123209, 4.512387>, <-0.247303, -0.153005, 4.473133>, <-0.180467, -0.191965, 4.425017>, <-0.123070, -0.213514, 4.397223>, 
      <-0.303318, -0.148329, 4.521924>, <-0.257463, -0.178125, 4.482671>, <-0.190465, -0.210746, 4.441082>, <-0.133068, -0.232295, 4.413288>, 
      <-0.305865, -0.187895, 4.527059>, <-0.251717, -0.207255, 4.486497>, <-0.175674, -0.253941, 4.446895>, <-0.111706, -0.269595, 4.422097>, 
      <-0.304855, -0.215905, 4.533356>, <-0.250708, -0.235264, 4.492794>, <-0.173432, -0.279195, 4.455140>, <-0.109463, -0.294848, 4.430342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.293158, -0.123209, 4.512387>, <-0.364111, -0.077105, 4.573126>, <-0.455483, -0.002814, 4.651243>, <-0.510871, 0.038472, 4.729197>, 
      <-0.282185, -0.096079, 4.502086>, <-0.353138, -0.049975, 4.562825>, <-0.456014, 0.029196, 4.650655>, <-0.511403, 0.070482, 4.728609>, 
      <-0.257763, -0.060134, 4.488843>, <-0.330449, -0.006727, 4.550768>, <-0.432080, 0.065697, 4.627052>, <-0.488991, 0.112015, 4.708207>, 
      <-0.236859, -0.047790, 4.469526>, <-0.309545, 0.005617, 4.531451>, <-0.411263, 0.081743, 4.608764>, <-0.468174, 0.128060, 4.689919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.293158, -0.123209, 4.512387>, <-0.282185, -0.096079, 4.502086>, <-0.257763, -0.060134, 4.488843>, <-0.236859, -0.047790, 4.469526>, 
      <-0.247303, -0.153005, 4.473133>, <-0.236330, -0.125875, 4.462832>, <-0.204337, -0.099390, 4.443326>, <-0.183433, -0.087046, 4.424009>, 
      <-0.180467, -0.191965, 4.425017>, <-0.168737, -0.169931, 4.406168>, <-0.130844, -0.149982, 4.390890>, <-0.109733, -0.143099, 4.368859>, 
      <-0.123070, -0.213514, 4.397223>, <-0.111340, -0.191479, 4.378374>, <-0.069601, -0.187194, 4.354397>, <-0.048490, -0.180311, 4.332366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.463247, -0.168359, 4.695364>, <-0.423325, -0.185794, 4.641274>, <-0.358295, -0.196798, 4.573389>, <-0.304855, -0.215905, 4.533356>, 
      <-0.482680, -0.107424, 4.703516>, <-0.442758, -0.124858, 4.649426>, <-0.359305, -0.168789, 4.567092>, <-0.305865, -0.187895, 4.527059>, 
      <-0.509800, -0.025985, 4.730381>, <-0.454411, -0.067271, 4.652427>, <-0.374271, -0.102225, 4.582664>, <-0.303318, -0.148329, 4.521924>, 
      <-0.510871, 0.038472, 4.729197>, <-0.455483, -0.002814, 4.651243>, <-0.364111, -0.077105, 4.573126>, <-0.293158, -0.123209, 4.512387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.628590, -0.074527, 4.971982>, <-0.599482, -0.077481, 4.875631>, <-0.521129, -0.143082, 4.773787>, <-0.463247, -0.168359, 4.695364>, 
      <-0.641888, -0.016128, 4.978531>, <-0.612780, -0.019082, 4.882180>, <-0.540562, -0.082146, 4.781940>, <-0.482680, -0.107424, 4.703516>, 
      <-0.638929, 0.067079, 4.988150>, <-0.616757, 0.052021, 4.904542>, <-0.556488, 0.008816, 4.796090>, <-0.509800, -0.025985, 4.730381>, 
      <-0.627502, 0.126006, 4.982941>, <-0.605329, 0.110949, 4.899334>, <-0.557559, 0.073273, 4.794906>, <-0.510871, 0.038472, 4.729197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.639987, -0.150422, 5.280388>, <-0.644379, -0.120911, 5.189833>, <-0.656151, -0.071730, 5.063212>, <-0.628590, -0.074527, 4.971982>, 
      <-0.657143, -0.062576, 5.303447>, <-0.661535, -0.033064, 5.212892>, <-0.669449, -0.013331, 5.069761>, <-0.641888, -0.016128, 4.978531>, 
      <-0.671558, 0.057622, 5.331251>, <-0.670751, 0.065204, 5.222142>, <-0.666551, 0.085836, 5.092304>, <-0.638929, 0.067079, 4.988150>, 
      <-0.673868, 0.149162, 5.343822>, <-0.673061, 0.156744, 5.234713>, <-0.655123, 0.144763, 5.087095>, <-0.627502, 0.126006, 4.982941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.602895, -0.247161, 5.501707>, <-0.629980, -0.217189, 5.440531>, <-0.636610, -0.173114, 5.350016>, <-0.639987, -0.150422, 5.280388>, 
      <-0.626936, -0.151031, 5.535782>, <-0.654021, -0.121059, 5.474606>, <-0.653765, -0.085267, 5.373076>, <-0.657143, -0.062576, 5.303447>, 
      <-0.630262, -0.019786, 5.590157>, <-0.650218, 0.012329, 5.514496>, <-0.672181, 0.051758, 5.415628>, <-0.671558, 0.057622, 5.331251>, 
      <-0.632171, 0.082119, 5.614484>, <-0.652127, 0.114234, 5.538823>, <-0.674492, 0.143299, 5.428199>, <-0.673868, 0.149162, 5.343822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.364553, -0.455216, 5.902503>, <-0.452116, -0.381525, 5.800679>, <-0.546300, -0.309789, 5.629537>, <-0.602895, -0.247161, 5.501707>, 
      <-0.392972, -0.379862, 5.975093>, <-0.480535, -0.306171, 5.873269>, <-0.570341, -0.213659, 5.663612>, <-0.626936, -0.151031, 5.535782>, 
      <-0.454228, -0.268621, 6.057652>, <-0.529274, -0.188500, 5.930520>, <-0.590632, -0.083563, 5.740409>, <-0.630262, -0.019786, 5.590157>, 
      <-0.476854, -0.167894, 6.090778>, <-0.551900, -0.087774, 5.963646>, <-0.592541, 0.018342, 5.764736>, <-0.632171, 0.082119, 5.614484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.142958, -0.634233, 6.036554>, <-0.216785, -0.584035, 6.005721>, <-0.310564, -0.500652, 5.965285>, <-0.364553, -0.455216, 5.902503>, 
      <-0.163254, -0.574228, 6.140756>, <-0.237081, -0.524030, 6.109923>, <-0.338983, -0.425298, 6.037875>, <-0.392972, -0.379862, 5.975093>, 
      <-0.179024, -0.487771, 6.293384>, <-0.279940, -0.432884, 6.230396>, <-0.395693, -0.331112, 6.156811>, <-0.454228, -0.268621, 6.057652>, 
      <-0.197909, -0.381506, 6.350145>, <-0.298825, -0.326619, 6.287157>, <-0.418320, -0.230386, 6.189937>, <-0.476854, -0.167894, 6.090778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.142958, -0.634233, 6.036554>, <-0.163254, -0.574228, 6.140756>, <-0.179024, -0.487771, 6.293384>, <-0.197909, -0.381506, 6.350145>, 
      <-0.095769, -0.666319, 6.056262>, <-0.116065, -0.606313, 6.160464>, <-0.115054, -0.522564, 6.333312>, <-0.133939, -0.416299, 6.390073>, 
      <-0.021995, -0.702182, 6.063694>, <-0.026176, -0.642887, 6.183392>, <-0.043500, -0.543127, 6.327829>, <-0.020797, -0.437314, 6.406246>, 
      <0.033354, -0.725768, 6.068684>, <0.029173, -0.666473, 6.188383>, <0.034750, -0.564313, 6.345856>, <0.057453, -0.458500, 6.424273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.142958, -0.634233, 6.036554>, <-0.095769, -0.666319, 6.056262>, <-0.021995, -0.702182, 6.063694>, <0.033354, -0.725768, 6.068684>, 
      <-0.132025, -0.666557, 5.980422>, <-0.084836, -0.698643, 6.000130>, <-0.019708, -0.734615, 5.998222>, <0.035641, -0.758201, 6.003212>, 
      <-0.110767, -0.675891, 5.891822>, <-0.061431, -0.699492, 5.905723>, <0.014638, -0.727509, 5.889476>, <0.065436, -0.748327, 5.902534>, 
      <-0.096221, -0.682147, 5.828069>, <-0.046885, -0.705748, 5.841970>, <0.027389, -0.731732, 5.817620>, <0.078187, -0.752550, 5.830678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179058, -0.771453, 6.065584>, <0.133239, -0.771453, 6.065584>, <0.075361, -0.743668, 6.072471>, <0.033354, -0.725768, 6.068684>, 
      <0.179067, -0.700853, 6.187606>, <0.133248, -0.700853, 6.187606>, <0.071180, -0.684373, 6.192170>, <0.029173, -0.666473, 6.188383>, 
      <0.179042, -0.599128, 6.356247>, <0.141604, -0.599128, 6.356247>, <0.070025, -0.573864, 6.353983>, <0.034750, -0.564313, 6.345856>, 
      <0.179040, -0.483564, 6.436985>, <0.141602, -0.483564, 6.436985>, <0.092728, -0.468051, 6.432400>, <0.057453, -0.458500, 6.424273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.109462, -0.366759, 4.447258>, <-0.025568, -0.393879, 4.411603>, <0.083907, -0.462381, 4.357038>, <0.179012, -0.462381, 4.357038>, 
      <-0.108454, -0.383823, 4.449757>, <-0.024560, -0.410943, 4.414102>, <0.083904, -0.477972, 4.358208>, <0.179009, -0.477972, 4.358208>, 
      <-0.105327, -0.406927, 4.447981>, <-0.024430, -0.433912, 4.411988>, <0.086467, -0.499042, 4.356613>, <0.179030, -0.499042, 4.356613>, 
      <-0.101846, -0.423802, 4.449226>, <-0.020949, -0.450786, 4.413233>, <0.086466, -0.514449, 4.359272>, <0.179029, -0.514449, 4.359272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.109462, -0.366759, 4.447258>, <-0.025568, -0.393879, 4.411603>, <0.083907, -0.462381, 4.357038>, <0.179012, -0.462381, 4.357038>, 
      <-0.110755, -0.344868, 4.444052>, <-0.026861, -0.371989, 4.408397>, <0.083913, -0.423922, 4.354153>, <0.179018, -0.423922, 4.354153>, 
      <-0.107599, -0.315841, 4.437197>, <-0.024902, -0.336077, 4.405138>, <0.088080, -0.369453, 4.361668>, <0.179053, -0.369453, 4.361668>, 
      <-0.109463, -0.294848, 4.430342>, <-0.026766, -0.315084, 4.398284>, <0.088085, -0.334319, 4.345761>, <0.179058, -0.334319, 4.345761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.286355, -0.311942, 4.554818>, <-0.237486, -0.327047, 4.515940>, <-0.166137, -0.348438, 4.471345>, <-0.109462, -0.366759, 4.447258>, 
      <-0.284188, -0.326299, 4.557950>, <-0.235319, -0.341405, 4.519072>, <-0.165129, -0.365501, 4.473844>, <-0.108454, -0.383823, 4.449757>, 
      <-0.286351, -0.346117, 4.561991>, <-0.235835, -0.365313, 4.521975>, <-0.164094, -0.387324, 4.474128>, <-0.105327, -0.406927, 4.447981>, 
      <-0.283055, -0.360313, 4.564863>, <-0.232539, -0.379509, 4.524848>, <-0.160613, -0.404199, 4.475373>, <-0.101846, -0.423802, 4.449226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.286355, -0.311942, 4.554818>, <-0.237486, -0.327047, 4.515940>, <-0.166137, -0.348438, 4.471345>, <-0.109462, -0.366759, 4.447258>, 
      <-0.290738, -0.282908, 4.548483>, <-0.241869, -0.298013, 4.509605>, <-0.167430, -0.326547, 4.468139>, <-0.110755, -0.344868, 4.444052>, 
      <-0.303799, -0.245194, 4.539941>, <-0.249652, -0.264554, 4.499379>, <-0.171568, -0.300188, 4.461995>, <-0.107599, -0.315841, 4.437197>, 
      <-0.304855, -0.215905, 4.533356>, <-0.250708, -0.235264, 4.492794>, <-0.173432, -0.279195, 4.455140>, <-0.109463, -0.294848, 4.430342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.411400, -0.273430, 4.687467>, <-0.407024, -0.283635, 4.686904>, <-0.407300, -0.299348, 4.686892>, <-0.402738, -0.309464, 4.687576>, 
      <-0.380752, -0.283427, 4.641804>, <-0.376375, -0.293632, 4.641241>, <-0.380342, -0.308589, 4.641450>, <-0.375780, -0.318705, 4.642134>, 
      <-0.328871, -0.298800, 4.588642>, <-0.326704, -0.313157, 4.591774>, <-0.326647, -0.330805, 4.593911>, <-0.323351, -0.345001, 4.596783>, 
      <-0.286355, -0.311942, 4.554818>, <-0.284188, -0.326299, 4.557950>, <-0.286351, -0.346117, 4.561991>, <-0.283055, -0.360313, 4.564863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.411400, -0.273430, 4.687467>, <-0.380752, -0.283427, 4.641804>, <-0.328871, -0.298800, 4.588642>, <-0.286355, -0.311942, 4.554818>, 
      <-0.425267, -0.241093, 4.689252>, <-0.394618, -0.251090, 4.643589>, <-0.333254, -0.269766, 4.582307>, <-0.290738, -0.282908, 4.548483>, 
      <-0.452629, -0.201654, 4.690909>, <-0.412706, -0.219088, 4.636819>, <-0.357240, -0.226088, 4.579974>, <-0.303799, -0.245194, 4.539941>, 
      <-0.463247, -0.168359, 4.695364>, <-0.423325, -0.185794, 4.641274>, <-0.358295, -0.196798, 4.573389>, <-0.304855, -0.215905, 4.533356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.547146, -0.226877, 4.943369>, <-0.533513, -0.248286, 4.937924>, <-0.508105, -0.269370, 4.924865>, <-0.492276, -0.288594, 4.917537>, 
      <-0.519703, -0.225555, 4.859749>, <-0.506071, -0.246963, 4.854304>, <-0.490901, -0.261928, 4.852971>, <-0.475072, -0.281153, 4.845643>, 
      <-0.459661, -0.257688, 4.759371>, <-0.455285, -0.267893, 4.758808>, <-0.444641, -0.286548, 4.749836>, <-0.440079, -0.296664, 4.750520>, 
      <-0.411400, -0.273430, 4.687467>, <-0.407024, -0.283635, 4.686904>, <-0.407300, -0.299348, 4.686892>, <-0.402738, -0.309464, 4.687576>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.547146, -0.226877, 4.943369>, <-0.519703, -0.225555, 4.859749>, <-0.459661, -0.257688, 4.759371>, <-0.411400, -0.273430, 4.687467>, 
      <-0.574735, -0.183552, 4.954388>, <-0.547292, -0.182230, 4.870768>, <-0.473528, -0.225351, 4.761156>, <-0.425267, -0.241093, 4.689252>, 
      <-0.616996, -0.125444, 4.966272>, <-0.587887, -0.128399, 4.869922>, <-0.510510, -0.176376, 4.769332>, <-0.452629, -0.201654, 4.690909>, 
      <-0.628590, -0.074527, 4.971982>, <-0.599482, -0.077481, 4.875631>, <-0.521129, -0.143082, 4.773787>, <-0.463247, -0.168359, 4.695364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.589661, -0.282019, 5.230641>, <-0.574495, -0.309383, 5.218944>, <-0.544452, -0.338969, 5.202368>, <-0.523008, -0.361485, 5.190171>, 
      <-0.594213, -0.258647, 5.145221>, <-0.579047, -0.286010, 5.133524>, <-0.549872, -0.314385, 5.121010>, <-0.528428, -0.336901, 5.108813>, 
      <-0.574794, -0.228209, 5.027615>, <-0.561162, -0.249618, 5.022170>, <-0.527825, -0.277899, 5.007274>, <-0.511996, -0.297124, 4.999946>, 
      <-0.547146, -0.226877, 4.943369>, <-0.533513, -0.248286, 4.937924>, <-0.508105, -0.269370, 4.924865>, <-0.492276, -0.288594, 4.917537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.589661, -0.282019, 5.230641>, <-0.594213, -0.258647, 5.145221>, <-0.574794, -0.228209, 5.027615>, <-0.547146, -0.226877, 4.943369>, 
      <-0.610015, -0.245296, 5.246338>, <-0.614566, -0.221923, 5.160918>, <-0.602383, -0.184884, 5.038634>, <-0.574735, -0.183552, 4.954388>, 
      <-0.631667, -0.193025, 5.269205>, <-0.636059, -0.163514, 5.178650>, <-0.644557, -0.122647, 5.057502>, <-0.616996, -0.125444, 4.966272>, 
      <-0.639987, -0.150422, 5.280388>, <-0.644379, -0.120911, 5.189833>, <-0.656151, -0.071730, 5.063212>, <-0.628590, -0.074527, 4.971982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.519866, -0.366949, 5.455302>, <-0.502550, -0.390091, 5.445083>, <-0.478172, -0.419813, 5.430473>, <-0.459014, -0.439453, 5.416795>, 
      <-0.551537, -0.333375, 5.396142>, <-0.534221, -0.356517, 5.385923>, <-0.508264, -0.389453, 5.369558>, <-0.489107, -0.409093, 5.355880>, 
      <-0.585809, -0.301795, 5.302919>, <-0.570643, -0.329159, 5.291223>, <-0.539716, -0.360451, 5.273460>, <-0.518272, -0.382967, 5.261262>, 
      <-0.589661, -0.282019, 5.230641>, <-0.574495, -0.309383, 5.218944>, <-0.544452, -0.338969, 5.202368>, <-0.523008, -0.361485, 5.190171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.519866, -0.366949, 5.455302>, <-0.551537, -0.333375, 5.396142>, <-0.585809, -0.301795, 5.302919>, <-0.589661, -0.282019, 5.230641>, 
      <-0.545785, -0.332309, 5.470598>, <-0.577456, -0.298735, 5.411439>, <-0.606163, -0.265072, 5.318616>, <-0.610015, -0.245296, 5.246338>, 
      <-0.592367, -0.289258, 5.486785>, <-0.619452, -0.259286, 5.425609>, <-0.628289, -0.215716, 5.338834>, <-0.631667, -0.193025, 5.269205>, 
      <-0.602895, -0.247161, 5.501707>, <-0.629980, -0.217189, 5.440531>, <-0.636610, -0.173114, 5.350016>, <-0.639987, -0.150422, 5.280388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.080403, -0.507638, 4.457652>, <-0.140347, -0.486856, 4.485113>, <-0.209515, -0.450222, 4.536428>, <-0.259602, -0.427174, 4.578134>, 
      <-0.087393, -0.484941, 4.446867>, <-0.147337, -0.464159, 4.474328>, <-0.220222, -0.432221, 4.531043>, <-0.270309, -0.409173, 4.572749>, 
      <-0.096590, -0.449281, 4.451106>, <-0.155358, -0.429678, 4.477252>, <-0.227741, -0.400177, 4.529029>, <-0.278257, -0.380981, 4.569045>, 
      <-0.101846, -0.423802, 4.449226>, <-0.160613, -0.404199, 4.475373>, <-0.232539, -0.379509, 4.524848>, <-0.283055, -0.360313, 4.564863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179005, -0.579237, 4.377204>, <0.094742, -0.579237, 4.377204>, <-0.007340, -0.532969, 4.424181>, <-0.080403, -0.507638, 4.457652>, 
      <0.179009, -0.564353, 4.363596>, <0.094747, -0.564353, 4.363596>, <-0.014330, -0.510272, 4.413396>, <-0.087393, -0.484941, 4.446867>, 
      <0.179028, -0.534322, 4.362702>, <0.086465, -0.534322, 4.362702>, <-0.015694, -0.476266, 4.415113>, <-0.096590, -0.449281, 4.451106>, 
      <0.179029, -0.514449, 4.359272>, <0.086466, -0.514449, 4.359272>, <-0.020949, -0.450786, 4.413233>, <-0.101846, -0.423802, 4.449226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.364797, -0.376771, 4.694456>, <-0.340304, -0.387056, 4.652783>, <-0.295407, -0.410698, 4.607948>, <-0.259602, -0.427174, 4.578134>, 
      <-0.378703, -0.358688, 4.689856>, <-0.354210, -0.368973, 4.648183>, <-0.306114, -0.392696, 4.602562>, <-0.270309, -0.409173, 4.572749>, 
      <-0.393190, -0.330637, 4.689008>, <-0.366231, -0.339878, 4.643566>, <-0.318553, -0.365669, 4.600965>, <-0.278257, -0.380981, 4.569045>, 
      <-0.402738, -0.309464, 4.687576>, <-0.375780, -0.318705, 4.642134>, <-0.323351, -0.345001, 4.596783>, <-0.283055, -0.360313, 4.564863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.447028, -0.348471, 4.897021>, <-0.433851, -0.342558, 4.832484>, <-0.397574, -0.363008, 4.750222>, <-0.364797, -0.376771, 4.694456>, 
      <-0.461360, -0.330840, 4.902366>, <-0.448183, -0.324927, 4.837829>, <-0.411480, -0.344925, 4.745623>, <-0.378703, -0.358688, 4.689856>, 
      <-0.478043, -0.305880, 4.910948>, <-0.460839, -0.298439, 4.839054>, <-0.430531, -0.317837, 4.751952>, <-0.393190, -0.330637, 4.689008>, 
      <-0.492276, -0.288594, 4.917537>, <-0.475072, -0.281153, 4.845643>, <-0.440079, -0.296664, 4.750520>, <-0.402738, -0.309464, 4.687576>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.459114, -0.419093, 5.156388>, <-0.470283, -0.392316, 5.081058>, <-0.463112, -0.355688, 4.975797>, <-0.447028, -0.348471, 4.897021>, 
      <-0.477827, -0.402232, 5.167979>, <-0.488996, -0.375455, 5.092649>, <-0.477445, -0.338058, 4.981142>, <-0.461360, -0.330840, 4.902366>, 
      <-0.505206, -0.380177, 5.180045>, <-0.510626, -0.355593, 5.098688>, <-0.497763, -0.314410, 4.993357>, <-0.478043, -0.305880, 4.910948>, 
      <-0.523008, -0.361485, 5.190171>, <-0.528428, -0.336901, 5.108813>, <-0.511996, -0.297124, 4.999946>, <-0.492276, -0.288594, 4.917537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.379149, -0.511207, 5.354836>, <-0.413118, -0.485560, 5.299412>, <-0.449445, -0.442274, 5.221600>, <-0.459114, -0.419093, 5.156388>, 
      <-0.403807, -0.494120, 5.376812>, <-0.437777, -0.468473, 5.321388>, <-0.468158, -0.425412, 5.233192>, <-0.477827, -0.402232, 5.167979>, 
      <-0.435775, -0.463277, 5.400203>, <-0.465867, -0.432917, 5.339288>, <-0.500470, -0.401658, 5.251137>, <-0.505206, -0.380177, 5.180045>, 
      <-0.459014, -0.439453, 5.416795>, <-0.489107, -0.409093, 5.355880>, <-0.518272, -0.382967, 5.261262>, <-0.523008, -0.361485, 5.190171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.225860, -0.595202, 5.536960>, <-0.282387, -0.565266, 5.496420>, <-0.342337, -0.539000, 5.414898>, <-0.379149, -0.511207, 5.354836>, 
      <-0.242329, -0.590656, 5.573375>, <-0.298855, -0.560719, 5.532834>, <-0.366996, -0.521914, 5.436873>, <-0.403807, -0.494120, 5.376812>, 
      <-0.275039, -0.598816, 5.617618>, <-0.350653, -0.548742, 5.582259>, <-0.396413, -0.502989, 5.479882>, <-0.435775, -0.463277, 5.400203>, 
      <-0.294959, -0.591563, 5.651802>, <-0.370573, -0.541489, 5.616442>, <-0.419652, -0.479165, 5.496474>, <-0.459014, -0.439453, 5.416795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.225860, -0.595202, 5.536960>, <-0.185600, -0.616524, 5.565834>, <-0.116964, -0.651702, 5.565077>, <-0.069762, -0.675058, 5.576726>, 
      <-0.242329, -0.590656, 5.573375>, <-0.202068, -0.611977, 5.602249>, <-0.119162, -0.651013, 5.572460>, <-0.071960, -0.674369, 5.584109>, 
      <-0.275039, -0.598816, 5.617618>, <-0.217970, -0.636610, 5.644306>, <-0.144346, -0.663908, 5.579248>, <-0.076442, -0.690787, 5.587260>, 
      <-0.294959, -0.591563, 5.651802>, <-0.237890, -0.629357, 5.678490>, <-0.146627, -0.664417, 5.586620>, <-0.078724, -0.691295, 5.594632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.329999, -0.557284, 5.715670>, <-0.324277, -0.568495, 5.695056>, <-0.306920, -0.587208, 5.672328>, <-0.294959, -0.591563, 5.651802>, 
      <-0.403589, -0.502532, 5.650918>, <-0.397867, -0.513743, 5.630303>, <-0.382534, -0.537134, 5.636969>, <-0.370573, -0.541489, 5.616442>, 
      <-0.472475, -0.417188, 5.543825>, <-0.455159, -0.440330, 5.533606>, <-0.438810, -0.459525, 5.510152>, <-0.419652, -0.479165, 5.496474>, 
      <-0.519866, -0.366949, 5.455302>, <-0.502550, -0.390091, 5.445083>, <-0.478172, -0.419813, 5.430473>, <-0.459014, -0.439453, 5.416795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.329999, -0.557284, 5.715670>, <-0.273393, -0.599400, 5.765478>, <-0.171729, -0.646026, 5.806794>, <-0.096221, -0.682147, 5.828069>, 
      <-0.324277, -0.568495, 5.695056>, <-0.267670, -0.610611, 5.744864>, <-0.168341, -0.647483, 5.791944>, <-0.092833, -0.683604, 5.813218>, 
      <-0.306920, -0.587208, 5.672328>, <-0.244028, -0.607446, 5.711968>, <-0.159328, -0.638186, 5.788656>, <-0.088116, -0.666374, 5.797058>, 
      <-0.294959, -0.591563, 5.651802>, <-0.232067, -0.611801, 5.691441>, <-0.156530, -0.630836, 5.775530>, <-0.085318, -0.659024, 5.783932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.329999, -0.557284, 5.715670>, <-0.403589, -0.502532, 5.650918>, <-0.472475, -0.417188, 5.543825>, <-0.519866, -0.366949, 5.455302>, 
      <-0.345329, -0.527250, 5.770894>, <-0.418919, -0.472498, 5.706141>, <-0.498394, -0.382548, 5.559121>, <-0.545785, -0.332309, 5.470598>, 
      <-0.347593, -0.500186, 5.859182>, <-0.435156, -0.426495, 5.757358>, <-0.535772, -0.351886, 5.614615>, <-0.592367, -0.289258, 5.486785>, 
      <-0.364553, -0.455216, 5.902503>, <-0.452116, -0.381525, 5.800679>, <-0.546300, -0.309789, 5.629537>, <-0.602895, -0.247161, 5.501707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.329999, -0.557284, 5.715670>, <-0.345329, -0.527250, 5.770894>, <-0.347593, -0.500186, 5.859182>, <-0.364553, -0.455216, 5.902503>, 
      <-0.273393, -0.599400, 5.765478>, <-0.288723, -0.569366, 5.820702>, <-0.293604, -0.545622, 5.921965>, <-0.310564, -0.500652, 5.965285>, 
      <-0.171729, -0.646026, 5.806794>, <-0.186276, -0.639769, 5.870547>, <-0.205852, -0.616359, 5.949589>, <-0.216785, -0.584035, 6.005721>, 
      <-0.096221, -0.682147, 5.828069>, <-0.110767, -0.675891, 5.891822>, <-0.132025, -0.666557, 5.980422>, <-0.142958, -0.634233, 6.036554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178999, -0.794939, 5.898815>, <0.178989, -0.799395, 5.849578>, <0.178998, -0.801048, 5.783584>, <0.178993, -0.801448, 5.734147>, 
      <0.140344, -0.794939, 5.898815>, <0.140334, -0.799395, 5.849578>, <0.148143, -0.801048, 5.783584>, <0.148138, -0.801448, 5.734147>, 
      <0.112984, -0.766811, 5.839622>, <0.120002, -0.769135, 5.800073>, <0.122595, -0.761644, 5.733347>, <0.125876, -0.761976, 5.693248>, 
      <0.078187, -0.752550, 5.830678>, <0.085205, -0.754875, 5.791129>, <0.095799, -0.747205, 5.738394>, <0.099080, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.178999, -0.794939, 5.898815>, <0.140344, -0.794939, 5.898815>, <0.112984, -0.766811, 5.839622>, <0.078187, -0.752550, 5.830678>, 
      <0.179009, -0.790385, 5.949134>, <0.140354, -0.790385, 5.949134>, <0.100233, -0.762588, 5.911478>, <0.065436, -0.748327, 5.902534>, 
      <0.179055, -0.796756, 6.021852>, <0.133236, -0.796756, 6.021852>, <0.077648, -0.776101, 6.007000>, <0.035641, -0.758201, 6.003212>, 
      <0.179058, -0.771453, 6.065584>, <0.133239, -0.771453, 6.065584>, <0.075361, -0.743668, 6.072471>, <0.033354, -0.725768, 6.068684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.055971, -0.572750, 4.520002>, <-0.064422, -0.558247, 4.497566>, <-0.072893, -0.532021, 4.469238>, <-0.080403, -0.507638, 4.457652>, 
      <0.010462, -0.589879, 4.490562>, <0.002010, -0.575376, 4.468126>, <0.000170, -0.557352, 4.435767>, <-0.007340, -0.532969, 4.424181>, 
      <0.104347, -0.610969, 4.447523>, <0.104348, -0.605919, 4.424937>, <0.094738, -0.596318, 4.392821>, <0.094742, -0.579237, 4.377204>, 
      <0.179002, -0.610969, 4.447523>, <0.179003, -0.605919, 4.424937>, <0.179000, -0.596318, 4.392821>, <0.179005, -0.579237, 4.377204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.190658, -0.515657, 4.611336>, <-0.209790, -0.490770, 4.595644>, <-0.242227, -0.456386, 4.586874>, <-0.259602, -0.427174, 4.578134>, 
      <-0.154400, -0.533275, 4.578905>, <-0.173533, -0.508388, 4.563213>, <-0.192140, -0.479434, 4.545168>, <-0.209515, -0.450222, 4.536428>, 
      <-0.102010, -0.560879, 4.540404>, <-0.110462, -0.546376, 4.517968>, <-0.132837, -0.511239, 4.496699>, <-0.140347, -0.486856, 4.485113>, 
      <-0.055971, -0.572750, 4.520002>, <-0.064422, -0.558247, 4.497566>, <-0.072893, -0.532021, 4.469238>, <-0.080403, -0.507638, 4.457652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.286351, -0.460808, 4.726071>, <-0.306710, -0.433027, 4.716421>, <-0.343422, -0.404566, 4.701526>, <-0.364797, -0.376771, 4.694456>, 
      <-0.259966, -0.472255, 4.687960>, <-0.280324, -0.444473, 4.678310>, <-0.318929, -0.414851, 4.659852>, <-0.340304, -0.387056, 4.652783>, 
      <-0.224118, -0.499399, 4.641265>, <-0.243251, -0.474512, 4.625574>, <-0.278032, -0.439910, 4.616687>, <-0.295407, -0.410698, 4.607948>, 
      <-0.190658, -0.515657, 4.611336>, <-0.209790, -0.490770, 4.595644>, <-0.242227, -0.456386, 4.586874>, <-0.259602, -0.427174, 4.578134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.371452, -0.437225, 4.872478>, <-0.392704, -0.409119, 4.878447>, <-0.425084, -0.375466, 4.888837>, <-0.447028, -0.348471, 4.897021>, 
      <-0.361963, -0.429986, 4.822593>, <-0.383215, -0.401880, 4.828562>, <-0.411907, -0.369553, 4.824301>, <-0.433851, -0.342558, 4.832484>, 
      <-0.314697, -0.448511, 4.767014>, <-0.335055, -0.420730, 4.757363>, <-0.376199, -0.390802, 4.757292>, <-0.397574, -0.363008, 4.750222>, 
      <-0.286351, -0.460808, 4.726071>, <-0.306710, -0.433027, 4.716421>, <-0.343422, -0.404566, 4.701526>, <-0.364797, -0.376771, 4.694456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.354813, -0.513039, 5.085985>, <-0.385099, -0.487881, 5.111857>, <-0.427320, -0.447742, 5.136694>, <-0.459114, -0.419093, 5.156388>, 
      <-0.373874, -0.489313, 5.025004>, <-0.404160, -0.464155, 5.050876>, <-0.438489, -0.420965, 5.061363>, <-0.470283, -0.392316, 5.081058>, 
      <-0.384060, -0.446844, 4.938761>, <-0.405312, -0.418738, 4.944730>, <-0.441168, -0.382683, 4.967613>, <-0.463112, -0.355688, 4.975797>, 
      <-0.371452, -0.437225, 4.872478>, <-0.392704, -0.409119, 4.878447>, <-0.425084, -0.375466, 4.888837>, <-0.447028, -0.348471, 4.897021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.257459, -0.579118, 5.237168>, <-0.286351, -0.561103, 5.280001>, <-0.342867, -0.536348, 5.322502>, <-0.379149, -0.511207, 5.354836>, 
      <-0.295646, -0.557768, 5.199899>, <-0.324537, -0.539753, 5.242732>, <-0.376837, -0.510701, 5.267078>, <-0.413118, -0.485560, 5.299412>, 
      <-0.338739, -0.533047, 5.137409>, <-0.369025, -0.507888, 5.163280>, <-0.417651, -0.470922, 5.201906>, <-0.449445, -0.442274, 5.221600>, 
      <-0.354813, -0.513039, 5.085985>, <-0.385099, -0.487881, 5.111857>, <-0.427320, -0.447742, 5.136694>, <-0.459114, -0.419093, 5.156388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.135756, -0.635514, 5.299781>, <-0.085776, -0.661185, 5.302527>, <-0.008233, -0.685668, 5.280351>, <0.023116, -0.723228, 5.252583>, 
      <-0.161367, -0.621275, 5.371063>, <-0.111387, -0.646946, 5.373809>, <-0.029692, -0.680703, 5.380132>, <0.001657, -0.718262, 5.352364>, 
      <-0.194305, -0.603913, 5.467188>, <-0.154045, -0.625235, 5.496062>, <-0.087922, -0.660808, 5.467533>, <-0.040719, -0.684165, 5.479181>, 
      <-0.225860, -0.595202, 5.536960>, <-0.185600, -0.616524, 5.565834>, <-0.116964, -0.651702, 5.565077>, <-0.069762, -0.675058, 5.576726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.135756, -0.635514, 5.299781>, <-0.161367, -0.621275, 5.371063>, <-0.194305, -0.603913, 5.467188>, <-0.225860, -0.595202, 5.536960>, 
      <-0.175212, -0.615249, 5.297613>, <-0.200823, -0.601009, 5.368895>, <-0.250832, -0.573977, 5.426647>, <-0.282387, -0.565266, 5.496420>, 
      <-0.227952, -0.595615, 5.265966>, <-0.256844, -0.577600, 5.308799>, <-0.306055, -0.564141, 5.382563>, <-0.342337, -0.539000, 5.414898>, 
      <-0.257459, -0.579118, 5.237168>, <-0.286351, -0.561103, 5.280001>, <-0.342867, -0.536348, 5.322502>, <-0.379149, -0.511207, 5.354836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179044, -0.927813, 5.162249>, <0.179039, -0.906785, 5.112601>, <0.178997, -0.807110, 5.124459>, <0.178985, -0.759588, 5.098987>, 
      <0.142458, -0.927813, 5.162249>, <0.142454, -0.906785, 5.112601>, <0.157395, -0.807110, 5.124459>, <0.157383, -0.759588, 5.098987>, 
      <0.093248, -0.912598, 5.152114>, <0.094725, -0.895609, 5.106999>, <0.117408, -0.790763, 5.130794>, <0.131068, -0.749087, 5.110729>, 
      <0.062816, -0.892291, 5.152173>, <0.064293, -0.875301, 5.107058>, <0.096997, -0.785070, 5.134997>, <0.110657, -0.743393, 5.114931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179044, -0.927813, 5.162249>, <0.142458, -0.927813, 5.162249>, <0.093248, -0.912598, 5.152114>, <0.062816, -0.892291, 5.152173>, 
      <0.179050, -0.956333, 5.229587>, <0.142465, -0.956333, 5.229587>, <0.090945, -0.939096, 5.222476>, <0.060513, -0.918789, 5.222535>, 
      <0.179024, -0.908117, 5.332399>, <0.152910, -0.908117, 5.332399>, <0.102878, -0.881030, 5.328950>, <0.083847, -0.863720, 5.324462>, 
      <0.179013, -0.888256, 5.402779>, <0.152899, -0.888256, 5.402779>, <0.120482, -0.866611, 5.400647>, <0.101451, -0.849301, 5.396158>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.067239, -0.683391, 5.095483>, <-0.041562, -0.685462, 5.023660>, <-0.005083, -0.658758, 4.930473>, <0.021556, -0.648201, 4.859754>, 
      <-0.041150, -0.690223, 5.108531>, <-0.015472, -0.692294, 5.036708>, <0.011710, -0.662021, 4.931764>, <0.038349, -0.651464, 4.861045>, 
      <-0.000382, -0.693437, 5.113261>, <0.010485, -0.680096, 5.036520>, <0.045806, -0.667999, 4.941739>, <0.060648, -0.655525, 4.865519>, 
      <0.028271, -0.697743, 5.120880>, <0.039138, -0.684401, 5.044139>, <0.062901, -0.668636, 4.943035>, <0.077742, -0.656161, 4.866815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.067239, -0.683391, 5.095483>, <-0.041150, -0.690223, 5.108531>, <-0.000382, -0.693437, 5.113261>, <0.028271, -0.697743, 5.120880>, 
      <-0.089523, -0.681594, 5.157816>, <-0.063434, -0.688426, 5.170864>, <-0.005947, -0.700269, 5.152558>, <0.022706, -0.704575, 5.160178>, 
      <-0.113750, -0.647749, 5.238534>, <-0.063770, -0.673420, 5.241280>, <0.000224, -0.687626, 5.241024>, <0.031573, -0.725185, 5.213256>, 
      <-0.135756, -0.635514, 5.299781>, <-0.085776, -0.661185, 5.302527>, <-0.008233, -0.685668, 5.280351>, <0.023116, -0.723228, 5.252583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.067239, -0.683391, 5.095483>, <-0.089523, -0.681594, 5.157816>, <-0.113750, -0.647749, 5.238534>, <-0.135756, -0.635514, 5.299781>, 
      <-0.098277, -0.675263, 5.079960>, <-0.120561, -0.673466, 5.142292>, <-0.153206, -0.627483, 5.236366>, <-0.175212, -0.615249, 5.297613>, 
      <-0.132276, -0.660839, 5.048648>, <-0.166082, -0.652276, 5.112370>, <-0.189596, -0.619531, 5.209102>, <-0.227952, -0.595615, 5.265966>, 
      <-0.158375, -0.648865, 5.027532>, <-0.192180, -0.640303, 5.091255>, <-0.219103, -0.603034, 5.180304>, <-0.257459, -0.579118, 5.237168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.055548, -0.630259, 4.856567>, <-0.032174, -0.634571, 4.856594>, <-0.001710, -0.643680, 4.857966>, <0.021556, -0.648201, 4.859754>, 
      <-0.086396, -0.635841, 4.907856>, <-0.063022, -0.640153, 4.907883>, <-0.028348, -0.654237, 4.928684>, <-0.005083, -0.658758, 4.930473>, 
      <-0.130401, -0.655950, 4.974800>, <-0.104302, -0.667924, 4.995916>, <-0.072599, -0.677334, 5.008137>, <-0.041562, -0.685462, 5.023660>, 
      <-0.158375, -0.648865, 5.027532>, <-0.132276, -0.660839, 5.048648>, <-0.098277, -0.675263, 5.079960>, <-0.067239, -0.683391, 5.095483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.231884, -0.607854, 4.962274>, <-0.214058, -0.620554, 4.985553>, <-0.181772, -0.638131, 5.008603>, <-0.158375, -0.648865, 5.027532>, 
      <-0.271055, -0.588834, 5.002899>, <-0.253229, -0.601534, 5.026178>, <-0.215577, -0.629568, 5.072325>, <-0.192180, -0.640303, 5.091255>, 
      <-0.316530, -0.544841, 5.053281>, <-0.300456, -0.564849, 5.104705>, <-0.257290, -0.581684, 5.143035>, <-0.219103, -0.603034, 5.180304>, 
      <-0.354813, -0.513039, 5.085985>, <-0.338739, -0.533047, 5.137409>, <-0.295646, -0.557768, 5.199899>, <-0.257459, -0.579118, 5.237168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.136506, -0.619041, 4.859573>, <-0.112275, -0.622756, 4.860613>, <-0.079677, -0.625808, 4.856539>, <-0.055548, -0.630259, 4.856567>, 
      <-0.165119, -0.615685, 4.890383>, <-0.140889, -0.619400, 4.891424>, <-0.110525, -0.631389, 4.907829>, <-0.086396, -0.635841, 4.907856>, 
      <-0.204139, -0.621326, 4.933499>, <-0.186313, -0.634026, 4.956778>, <-0.153798, -0.645216, 4.955871>, <-0.130401, -0.655950, 4.974800>, 
      <-0.231884, -0.607854, 4.962274>, <-0.214058, -0.620554, 4.985553>, <-0.181772, -0.638131, 5.008603>, <-0.158375, -0.648865, 5.027532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.291720, -0.553864, 4.853400>, <-0.270651, -0.575497, 4.850554>, <-0.214525, -0.601848, 4.850440>, <-0.205899, -0.607210, 4.850109>, 
      <-0.293546, -0.561270, 4.893315>, <-0.272477, -0.582903, 4.890468>, <-0.209390, -0.601815, 4.855400>, <-0.200764, -0.607177, 4.855069>, 
      <-0.254555, -0.591702, 4.932668>, <-0.226811, -0.605174, 4.903893>, <-0.186163, -0.612459, 4.889479>, <-0.157549, -0.615815, 4.858669>, 
      <-0.231884, -0.607854, 4.962274>, <-0.204139, -0.621326, 4.933499>, <-0.165119, -0.615685, 4.890383>, <-0.136506, -0.619041, 4.859573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.291720, -0.553864, 4.853400>, <-0.293546, -0.561270, 4.893315>, <-0.254555, -0.591702, 4.932668>, <-0.231884, -0.607854, 4.962274>, 
      <-0.321430, -0.523359, 4.857414>, <-0.323256, -0.530765, 4.897329>, <-0.293726, -0.572682, 4.973293>, <-0.271055, -0.588834, 5.002899>, 
      <-0.346018, -0.470861, 4.865334>, <-0.358626, -0.480480, 4.931617>, <-0.335591, -0.521115, 4.992300>, <-0.316530, -0.544841, 5.053281>, 
      <-0.371452, -0.437225, 4.872478>, <-0.384060, -0.446844, 4.938761>, <-0.373874, -0.489313, 5.025004>, <-0.354813, -0.513039, 5.085985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.222713, -0.570659, 4.761804>, <-0.246267, -0.564706, 4.786680>, <-0.290158, -0.547527, 4.819247>, <-0.291720, -0.553864, 4.853400>, 
      <-0.242700, -0.541171, 4.744588>, <-0.266255, -0.535218, 4.769463>, <-0.319867, -0.517022, 4.823261>, <-0.321430, -0.523359, 4.857414>, 
      <-0.263831, -0.491539, 4.736745>, <-0.292177, -0.479242, 4.777688>, <-0.336529, -0.463622, 4.815449>, <-0.346018, -0.470861, 4.865334>, 
      <-0.286351, -0.460808, 4.726071>, <-0.314697, -0.448511, 4.767014>, <-0.361963, -0.429986, 4.822593>, <-0.371452, -0.437225, 4.872478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.178913, -0.619315, 4.818616>, <-0.190118, -0.615594, 4.823964>, <-0.209023, -0.607230, 4.847092>, <-0.205899, -0.607210, 4.850109>, 
      <-0.192053, -0.604718, 4.801572>, <-0.203258, -0.600997, 4.806920>, <-0.217649, -0.601868, 4.847423>, <-0.214525, -0.601848, 4.850440>, 
      <-0.209577, -0.590040, 4.773120>, <-0.233131, -0.584086, 4.797995>, <-0.269089, -0.569160, 4.816400>, <-0.270651, -0.575497, 4.850554>, 
      <-0.222713, -0.570659, 4.761804>, <-0.246267, -0.564706, 4.786680>, <-0.290158, -0.547527, 4.819247>, <-0.291720, -0.553864, 4.853400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.130972, -0.594492, 4.683633>, <-0.160878, -0.588227, 4.704246>, <-0.197745, -0.576970, 4.735435>, <-0.222713, -0.570659, 4.761804>, 
      <-0.147479, -0.574768, 4.657387>, <-0.177385, -0.568502, 4.678000>, <-0.217732, -0.547482, 4.718218>, <-0.242700, -0.541171, 4.744588>, 
      <-0.170625, -0.541716, 4.627767>, <-0.204085, -0.525458, 4.657696>, <-0.237446, -0.502985, 4.698634>, <-0.263831, -0.491539, 4.736745>, 
      <-0.190658, -0.515657, 4.611336>, <-0.224118, -0.499399, 4.641265>, <-0.259966, -0.472255, 4.687960>, <-0.286351, -0.460808, 4.726071>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.078679, -0.649463, 4.789384>, <-0.109795, -0.643926, 4.797388>, <-0.150729, -0.628676, 4.805163>, <-0.178913, -0.619315, 4.818616>, 
      <-0.094367, -0.632972, 4.757658>, <-0.125483, -0.627434, 4.765663>, <-0.163869, -0.614079, 4.788119>, <-0.192053, -0.604718, 4.801572>, 
      <-0.113433, -0.615450, 4.711520>, <-0.143339, -0.609185, 4.732134>, <-0.184608, -0.596350, 4.746750>, <-0.209577, -0.590040, 4.773120>, 
      <-0.130972, -0.594492, 4.683633>, <-0.160878, -0.588227, 4.704246>, <-0.197745, -0.576970, 4.735435>, <-0.222713, -0.570659, 4.761804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.018782, -0.613383, 4.621240>, <-0.005350, -0.627632, 4.664043>, <0.009455, -0.642509, 4.723303>, <0.021556, -0.654992, 4.767044>, 
      <-0.055441, -0.609906, 4.633860>, <-0.042009, -0.624155, 4.676663>, <-0.021167, -0.641969, 4.727036>, <-0.009066, -0.654452, 4.770777>, 
      <-0.099388, -0.601109, 4.661863>, <-0.081849, -0.622067, 4.689750>, <-0.064921, -0.638212, 4.750084>, <-0.049233, -0.654703, 4.781809>, 
      <-0.130972, -0.594492, 4.683633>, <-0.113433, -0.615450, 4.711520>, <-0.094367, -0.632972, 4.757658>, <-0.078679, -0.649463, 4.789384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.018782, -0.613383, 4.621240>, <-0.055441, -0.609906, 4.633860>, <-0.099388, -0.601109, 4.661863>, <-0.130972, -0.594492, 4.683633>, 
      <-0.028649, -0.602916, 4.589798>, <-0.065308, -0.599439, 4.602418>, <-0.115895, -0.581385, 4.635617>, <-0.147479, -0.574768, 4.657387>, 
      <-0.045542, -0.590646, 4.547687>, <-0.091582, -0.578775, 4.568090>, <-0.134367, -0.559334, 4.595336>, <-0.170625, -0.541716, 4.627767>, 
      <-0.055971, -0.572750, 4.520002>, <-0.102010, -0.560879, 4.540404>, <-0.154400, -0.533275, 4.578905>, <-0.190658, -0.515657, 4.611336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179001, -0.623893, 4.576925>, <0.179006, -0.631454, 4.631462>, <0.179021, -0.644973, 4.703654>, <0.179029, -0.654008, 4.757966>, 
      <0.118113, -0.623893, 4.576925>, <0.118118, -0.631454, 4.631462>, <0.131699, -0.644973, 4.703654>, <0.131708, -0.654008, 4.757966>, 
      <0.038560, -0.618822, 4.601500>, <0.051992, -0.633071, 4.644303>, <0.056421, -0.643338, 4.717577>, <0.068522, -0.655820, 4.761318>, 
      <-0.018782, -0.613383, 4.621240>, <-0.005350, -0.627632, 4.664043>, <0.009455, -0.642509, 4.723303>, <0.021556, -0.654992, 4.767044>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.179001, -0.623893, 4.576925>, <0.118113, -0.623893, 4.576925>, <0.038560, -0.618822, 4.601500>, <-0.018782, -0.613383, 4.621240>, 
      <0.178998, -0.618536, 4.538281>, <0.118110, -0.618536, 4.538281>, <0.028693, -0.608355, 4.570059>, <-0.028649, -0.602916, 4.589798>, 
      <0.179001, -0.619482, 4.485597>, <0.104346, -0.619482, 4.485597>, <0.020890, -0.607775, 4.518248>, <-0.045542, -0.590646, 4.547687>, 
      <0.179002, -0.610969, 4.447523>, <0.104347, -0.610969, 4.447523>, <0.010462, -0.589879, 4.490562>, <-0.055971, -0.572750, 4.520002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.430714, -0.679066, 5.761615>, <0.431270, -0.671670, 5.766786>, <0.431830, -0.654704, 5.768183>, <0.432310, -0.650953, 5.772360>, 
      <0.430714, -0.679066, 5.761615>, <0.374607, -0.694099, 5.773472>, <0.370791, -0.678865, 5.775385>, <0.371271, -0.675114, 5.779562>, 
      <0.430714, -0.679066, 5.761615>, <0.374607, -0.694099, 5.773472>, <0.358460, -0.698021, 5.739510>, <0.303911, -0.718562, 5.720514>, 
      <0.430714, -0.679066, 5.761615>, <0.374051, -0.701495, 5.768300>, <0.303432, -0.726996, 5.717291>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.430714, -0.679066, 5.761615>, <0.431270, -0.671670, 5.766786>, <0.431830, -0.654704, 5.768183>, <0.432310, -0.650953, 5.772360>, 
      <0.430714, -0.679066, 5.761615>, <0.501825, -0.643742, 5.758461>, <0.501104, -0.627282, 5.760009>, <0.501584, -0.623532, 5.764186>, 
      <0.430714, -0.679066, 5.761615>, <0.501825, -0.643742, 5.758461>, <0.516076, -0.635631, 5.720913>, <0.579738, -0.609380, 5.687969>, 
      <0.430714, -0.679066, 5.761615>, <0.501269, -0.651138, 5.753290>, <0.579260, -0.617814, 5.684746>, <0.642922, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.430714, -0.679066, 5.761615>, <0.374051, -0.701495, 5.768300>, <0.303432, -0.726996, 5.717291>, <0.248883, -0.747537, 5.698295>, 
      <0.501269, -0.651138, 5.753290>, <0.444606, -0.673567, 5.759976>, <0.358460, -0.698021, 5.739510>, <0.303911, -0.718562, 5.720514>, 
      <0.579260, -0.617814, 5.684746>, <0.516076, -0.635631, 5.720913>, <0.440546, -0.647693, 5.771388>, <0.371271, -0.675114, 5.779562>, 
      <0.642922, -0.591563, 5.651802>, <0.579738, -0.609380, 5.687969>, <0.501584, -0.623532, 5.764186>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428875, -0.696645, 5.740411>, <0.429427, -0.691371, 5.746772>, <0.430205, -0.685840, 5.756878>, <0.430714, -0.679066, 5.761615>, 
      <0.428875, -0.696645, 5.740411>, <0.376264, -0.712415, 5.753045>, <0.373542, -0.708269, 5.763564>, <0.374051, -0.701495, 5.768300>, 
      <0.428875, -0.696645, 5.740411>, <0.376264, -0.712415, 5.753045>, <0.357430, -0.711728, 5.729926>, <0.303432, -0.726996, 5.717291>, 
      <0.428875, -0.696645, 5.740411>, <0.375712, -0.717689, 5.746684>, <0.302881, -0.732269, 5.710930>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428875, -0.696645, 5.740411>, <0.429427, -0.691371, 5.746772>, <0.430205, -0.685840, 5.756878>, <0.430714, -0.679066, 5.761615>, 
      <0.375712, -0.717689, 5.746684>, <0.376264, -0.712415, 5.753045>, <0.430761, -0.678444, 5.762050>, <0.431270, -0.671670, 5.766786>, 
      <0.302881, -0.732269, 5.710930>, <0.357909, -0.703294, 5.733149>, <0.370791, -0.678865, 5.775385>, <0.431830, -0.654704, 5.768183>, 
      <0.248883, -0.747537, 5.698295>, <0.303911, -0.718562, 5.720514>, <0.371271, -0.675114, 5.779562>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428875, -0.696645, 5.740411>, <0.429427, -0.691371, 5.746772>, <0.430205, -0.685840, 5.756878>, <0.430714, -0.679066, 5.761615>, 
      <0.428875, -0.696645, 5.740411>, <0.499961, -0.663451, 5.738449>, <0.500760, -0.657912, 5.748553>, <0.501269, -0.651138, 5.753290>, 
      <0.428875, -0.696645, 5.740411>, <0.499961, -0.663451, 5.738449>, <0.515046, -0.649339, 5.711328>, <0.579260, -0.617814, 5.684746>, 
      <0.428875, -0.696645, 5.740411>, <0.499409, -0.668725, 5.732088>, <0.578708, -0.623088, 5.678385>, <0.642922, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428875, -0.696645, 5.740411>, <0.375712, -0.717689, 5.746684>, <0.302881, -0.732269, 5.710930>, <0.248883, -0.747537, 5.698295>, 
      <0.499409, -0.668725, 5.732088>, <0.446246, -0.689769, 5.738361>, <0.357430, -0.711728, 5.729926>, <0.303432, -0.726996, 5.717291>, 
      <0.578708, -0.623088, 5.678385>, <0.515046, -0.649339, 5.711328>, <0.444606, -0.673567, 5.759976>, <0.374051, -0.701495, 5.768300>, 
      <0.642922, -0.591563, 5.651802>, <0.579260, -0.617814, 5.684746>, <0.501269, -0.651138, 5.753290>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428875, -0.696645, 5.740411>, <0.429427, -0.691371, 5.746772>, <0.430205, -0.685840, 5.756878>, <0.430714, -0.679066, 5.761615>, 
      <0.499409, -0.668725, 5.732088>, <0.499961, -0.663451, 5.738449>, <0.430761, -0.678444, 5.762050>, <0.431270, -0.671670, 5.766786>, 
      <0.578708, -0.623088, 5.678385>, <0.515524, -0.640905, 5.714552>, <0.501104, -0.627282, 5.760009>, <0.431830, -0.654704, 5.768183>, 
      <0.642922, -0.591563, 5.651802>, <0.579738, -0.609380, 5.687969>, <0.501584, -0.623532, 5.764186>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428875, -0.696645, 5.740411>, <0.375712, -0.717689, 5.746684>, <0.302881, -0.732269, 5.710930>, <0.248883, -0.747537, 5.698295>, 
      <0.499409, -0.668725, 5.732088>, <0.446246, -0.689769, 5.738361>, <0.357909, -0.703294, 5.733149>, <0.303911, -0.718562, 5.720514>, 
      <0.578708, -0.623088, 5.678385>, <0.515524, -0.640905, 5.714552>, <0.440546, -0.647693, 5.771388>, <0.371271, -0.675114, 5.779562>, 
      <0.642922, -0.591563, 5.651802>, <0.579738, -0.609380, 5.687969>, <0.501584, -0.623532, 5.764186>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428128, -0.677375, 5.610335>, <0.493285, -0.651584, 5.602647>, <0.578484, -0.617307, 5.639362>, <0.642922, -0.591563, 5.651802>, 
      <0.369447, -0.700603, 5.617258>, <0.434604, -0.674812, 5.609570>, <0.514270, -0.648831, 5.665944>, <0.578708, -0.623088, 5.678385>, 
      <0.302656, -0.726488, 5.671907>, <0.356654, -0.711221, 5.684542>, <0.446246, -0.689769, 5.738361>, <0.499409, -0.668725, 5.732088>, 
      <0.248883, -0.747537, 5.698295>, <0.302881, -0.732269, 5.710930>, <0.375712, -0.717689, 5.746684>, <0.428875, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428128, -0.677375, 5.610335>, <0.493285, -0.651584, 5.602647>, <0.578484, -0.617307, 5.639362>, <0.642922, -0.591563, 5.651802>, 
      <0.369447, -0.700603, 5.617258>, <0.434604, -0.674812, 5.609570>, <0.514821, -0.643558, 5.672306>, <0.579260, -0.617814, 5.684746>, 
      <0.302656, -0.726488, 5.671907>, <0.357206, -0.705947, 5.690903>, <0.444606, -0.673567, 5.759976>, <0.501269, -0.651138, 5.753290>, 
      <0.248883, -0.747537, 5.698295>, <0.303432, -0.726996, 5.717291>, <0.374051, -0.701495, 5.768300>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428128, -0.677375, 5.610335>, <0.493285, -0.651584, 5.602647>, <0.578484, -0.617307, 5.639362>, <0.642922, -0.591563, 5.651802>, 
      <0.369447, -0.700603, 5.617258>, <0.434604, -0.674812, 5.609570>, <0.515300, -0.635124, 5.675529>, <0.579738, -0.609380, 5.687969>, 
      <0.302656, -0.726488, 5.671907>, <0.357685, -0.697513, 5.694126>, <0.440546, -0.647693, 5.771388>, <0.501584, -0.623532, 5.764186>, 
      <0.248883, -0.747537, 5.698295>, <0.303911, -0.718562, 5.720514>, <0.371271, -0.675114, 5.779562>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425770, -0.701866, 5.620928>, <0.426480, -0.695066, 5.616704>, <0.427966, -0.679242, 5.614979>, <0.428128, -0.677375, 5.610335>, 
      <0.425770, -0.701866, 5.620928>, <0.494554, -0.668120, 5.608672>, <0.493123, -0.653450, 5.607291>, <0.493285, -0.651584, 5.602647>, 
      <0.425770, -0.701866, 5.620928>, <0.494554, -0.668120, 5.608672>, <0.513338, -0.650397, 5.630100>, <0.578484, -0.617307, 5.639362>, 
      <0.425770, -0.701866, 5.620928>, <0.493845, -0.674920, 5.612896>, <0.577776, -0.624654, 5.642540>, <0.642922, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425770, -0.701866, 5.620928>, <0.493845, -0.674920, 5.612896>, <0.577776, -0.624654, 5.642540>, <0.642922, -0.591563, 5.651802>, 
      <0.370759, -0.723641, 5.627418>, <0.438834, -0.696695, 5.619386>, <0.513338, -0.650397, 5.630100>, <0.578484, -0.617307, 5.639362>, 
      <0.301949, -0.733836, 5.675085>, <0.355723, -0.712787, 5.648697>, <0.434604, -0.674812, 5.609570>, <0.493285, -0.651584, 5.602647>, 
      <0.248883, -0.747537, 5.698295>, <0.302656, -0.726488, 5.671907>, <0.369447, -0.700603, 5.617258>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425770, -0.701866, 5.620928>, <0.426480, -0.695066, 5.616704>, <0.427966, -0.679242, 5.614979>, <0.428128, -0.677375, 5.610335>, 
      <0.425770, -0.701866, 5.620928>, <0.371469, -0.716841, 5.623195>, <0.369285, -0.702470, 5.621902>, <0.369447, -0.700603, 5.617258>, 
      <0.425770, -0.701866, 5.620928>, <0.371469, -0.716841, 5.623195>, <0.355723, -0.712787, 5.648697>, <0.302656, -0.726488, 5.671907>, 
      <0.425770, -0.701866, 5.620928>, <0.370759, -0.723641, 5.627418>, <0.301949, -0.733836, 5.675085>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425770, -0.701866, 5.620928>, <0.493845, -0.674920, 5.612896>, <0.577776, -0.624654, 5.642540>, <0.642922, -0.591563, 5.651802>, 
      <0.370759, -0.723641, 5.627418>, <0.438834, -0.696695, 5.619386>, <0.513562, -0.656179, 5.669123>, <0.578708, -0.623088, 5.678385>, 
      <0.301949, -0.733836, 5.675085>, <0.355947, -0.718568, 5.687720>, <0.446246, -0.689769, 5.738361>, <0.499409, -0.668725, 5.732088>, 
      <0.248883, -0.747537, 5.698295>, <0.302881, -0.732269, 5.710930>, <0.375712, -0.717689, 5.746684>, <0.428875, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425770, -0.701866, 5.620928>, <0.493845, -0.674920, 5.612896>, <0.577776, -0.624654, 5.642540>, <0.642922, -0.591563, 5.651802>, 
      <0.370759, -0.723641, 5.627418>, <0.438834, -0.696695, 5.619386>, <0.514114, -0.650905, 5.675484>, <0.579260, -0.617814, 5.684746>, 
      <0.301949, -0.733836, 5.675085>, <0.356498, -0.713294, 5.694081>, <0.444606, -0.673567, 5.759976>, <0.501269, -0.651138, 5.753290>, 
      <0.248883, -0.747537, 5.698295>, <0.303432, -0.726996, 5.717291>, <0.374051, -0.701495, 5.768300>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.425770, -0.701866, 5.620928>, <0.493845, -0.674920, 5.612896>, <0.577776, -0.624654, 5.642540>, <0.642922, -0.591563, 5.651802>, 
      <0.370759, -0.723641, 5.627418>, <0.438834, -0.696695, 5.619386>, <0.514593, -0.642471, 5.678707>, <0.579738, -0.609380, 5.687969>, 
      <0.301949, -0.733836, 5.675085>, <0.356977, -0.704861, 5.697304>, <0.440546, -0.647693, 5.771388>, <0.501584, -0.623532, 5.764186>, 
      <0.248883, -0.747537, 5.698295>, <0.303911, -0.718562, 5.720514>, <0.371271, -0.675114, 5.779562>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.424547, -0.712262, 5.630620>, <0.425230, -0.707039, 5.624141>, <0.425770, -0.701866, 5.620928>, 
      <0.424023, -0.716718, 5.634774>, <0.372187, -0.732988, 5.636798>, <0.370220, -0.728814, 5.630632>, <0.370759, -0.723641, 5.627418>, 
      <0.424023, -0.716718, 5.634774>, <0.372187, -0.732988, 5.636798>, <0.354491, -0.724590, 5.656029>, <0.301949, -0.733836, 5.675085>, 
      <0.424023, -0.716718, 5.634774>, <0.371663, -0.737444, 5.640952>, <0.301425, -0.738291, 5.679239>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.424547, -0.712262, 5.630620>, <0.425230, -0.707039, 5.624141>, <0.425770, -0.701866, 5.620928>, 
      <0.371663, -0.737444, 5.640952>, <0.372187, -0.732988, 5.636798>, <0.425940, -0.700240, 5.619917>, <0.426480, -0.695066, 5.616704>, 
      <0.301425, -0.738291, 5.679239>, <0.355198, -0.717243, 5.652851>, <0.369285, -0.702470, 5.621902>, <0.427966, -0.679242, 5.614979>, 
      <0.248883, -0.747537, 5.698295>, <0.302656, -0.726488, 5.671907>, <0.369447, -0.700603, 5.617258>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.371663, -0.737444, 5.640952>, <0.301425, -0.738291, 5.679239>, <0.248883, -0.747537, 5.698295>, 
      <0.494099, -0.688980, 5.626506>, <0.441739, -0.709706, 5.632684>, <0.355198, -0.717243, 5.652851>, <0.302656, -0.726488, 5.671907>, 
      <0.577252, -0.629109, 5.646694>, <0.512814, -0.654853, 5.634254>, <0.434604, -0.674812, 5.609570>, <0.369447, -0.700603, 5.617258>, 
      <0.642922, -0.591563, 5.651802>, <0.578484, -0.617307, 5.639362>, <0.493285, -0.651584, 5.602647>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.424547, -0.712262, 5.630620>, <0.425230, -0.707039, 5.624141>, <0.425770, -0.701866, 5.620928>, 
      <0.494099, -0.688980, 5.626506>, <0.494623, -0.684524, 5.622352>, <0.425940, -0.700240, 5.619917>, <0.426480, -0.695066, 5.616704>, 
      <0.577252, -0.629109, 5.646694>, <0.512814, -0.654853, 5.634254>, <0.493123, -0.653450, 5.607291>, <0.427966, -0.679242, 5.614979>, 
      <0.642922, -0.591563, 5.651802>, <0.578484, -0.617307, 5.639362>, <0.493285, -0.651584, 5.602647>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.424547, -0.712262, 5.630620>, <0.425230, -0.707039, 5.624141>, <0.425770, -0.701866, 5.620928>, 
      <0.424023, -0.716718, 5.634774>, <0.494623, -0.684524, 5.622352>, <0.493305, -0.680093, 5.616109>, <0.493845, -0.674920, 5.612896>, 
      <0.424023, -0.716718, 5.634774>, <0.494623, -0.684524, 5.622352>, <0.512107, -0.662200, 5.637432>, <0.577776, -0.624654, 5.642540>, 
      <0.424023, -0.716718, 5.634774>, <0.494099, -0.688980, 5.626506>, <0.577252, -0.629109, 5.646694>, <0.642922, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.371663, -0.737444, 5.640952>, <0.301425, -0.738291, 5.679239>, <0.248883, -0.747537, 5.698295>, 
      <0.494099, -0.688980, 5.626506>, <0.441739, -0.709706, 5.632684>, <0.354491, -0.724590, 5.656029>, <0.301949, -0.733836, 5.675085>, 
      <0.577252, -0.629109, 5.646694>, <0.512107, -0.662200, 5.637432>, <0.438834, -0.696695, 5.619386>, <0.370759, -0.723641, 5.627418>, 
      <0.642922, -0.591563, 5.651802>, <0.577776, -0.624654, 5.642540>, <0.493845, -0.674920, 5.612896>, <0.425770, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.371663, -0.737444, 5.640952>, <0.301425, -0.738291, 5.679239>, <0.248883, -0.747537, 5.698295>, 
      <0.494099, -0.688980, 5.626506>, <0.441739, -0.709706, 5.632684>, <0.355423, -0.723024, 5.691874>, <0.302881, -0.732269, 5.710930>, 
      <0.577252, -0.629109, 5.646694>, <0.513038, -0.660634, 5.673276>, <0.446246, -0.689769, 5.738361>, <0.375712, -0.717689, 5.746684>, 
      <0.642922, -0.591563, 5.651802>, <0.578708, -0.623088, 5.678385>, <0.499409, -0.668725, 5.732088>, <0.428875, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.371663, -0.737444, 5.640952>, <0.301425, -0.738291, 5.679239>, <0.248883, -0.747537, 5.698295>, 
      <0.494099, -0.688980, 5.626506>, <0.441739, -0.709706, 5.632684>, <0.355974, -0.717750, 5.698234>, <0.303432, -0.726996, 5.717291>, 
      <0.577252, -0.629109, 5.646694>, <0.513590, -0.655360, 5.679638>, <0.444606, -0.673567, 5.759976>, <0.374051, -0.701495, 5.768300>, 
      <0.642922, -0.591563, 5.651802>, <0.579260, -0.617814, 5.684746>, <0.501269, -0.651138, 5.753290>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.424023, -0.716718, 5.634774>, <0.371663, -0.737444, 5.640952>, <0.301425, -0.738291, 5.679239>, <0.248883, -0.747537, 5.698295>, 
      <0.494099, -0.688980, 5.626506>, <0.441739, -0.709706, 5.632684>, <0.356453, -0.709316, 5.701458>, <0.303911, -0.718562, 5.720514>, 
      <0.577252, -0.629109, 5.646694>, <0.514069, -0.646926, 5.682861>, <0.440546, -0.647693, 5.771388>, <0.371271, -0.675114, 5.779562>, 
      <0.642922, -0.591563, 5.651802>, <0.579738, -0.609380, 5.687969>, <0.501584, -0.623532, 5.764186>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.494590, -0.664417, 5.586620>, <0.435430, -0.687834, 5.593600>, <0.355998, -0.709616, 5.640808>, <0.302656, -0.726488, 5.671907>, 
      <0.585853, -0.629356, 5.678490>, <0.521414, -0.655100, 5.666050>, <0.434604, -0.674812, 5.609570>, <0.369447, -0.700603, 5.617258>, 
      <0.642922, -0.591563, 5.651802>, <0.578484, -0.617307, 5.639362>, <0.493285, -0.651584, 5.602647>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.494590, -0.664417, 5.586620>, <0.435430, -0.687834, 5.593600>, <0.354766, -0.721419, 5.648140>, <0.301425, -0.738291, 5.679239>, 
      <0.585853, -0.629356, 5.678490>, <0.520183, -0.666903, 5.673381>, <0.441739, -0.709706, 5.632684>, <0.371663, -0.737444, 5.640952>, 
      <0.642922, -0.591563, 5.651802>, <0.577252, -0.629109, 5.646694>, <0.494099, -0.688980, 5.626506>, <0.424023, -0.716718, 5.634774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.494590, -0.664417, 5.586620>, <0.435430, -0.687834, 5.593600>, <0.355290, -0.716963, 5.643986>, <0.301949, -0.733836, 5.675085>, 
      <0.585853, -0.629356, 5.678490>, <0.520707, -0.662447, 5.669228>, <0.438834, -0.696695, 5.619386>, <0.370759, -0.723641, 5.627418>, 
      <0.642922, -0.591563, 5.651802>, <0.577776, -0.624654, 5.642540>, <0.493845, -0.674920, 5.612896>, <0.425770, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.494590, -0.664417, 5.586620>, <0.435430, -0.687834, 5.593600>, <0.356222, -0.715397, 5.679831>, <0.302881, -0.732269, 5.710930>, 
      <0.585853, -0.629356, 5.678490>, <0.521638, -0.660881, 5.705072>, <0.446246, -0.689769, 5.738361>, <0.375712, -0.717689, 5.746684>, 
      <0.642922, -0.591563, 5.651802>, <0.578708, -0.623088, 5.678385>, <0.499409, -0.668725, 5.732088>, <0.428875, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.494590, -0.664417, 5.586620>, <0.435430, -0.687834, 5.593600>, <0.356774, -0.710123, 5.686192>, <0.303432, -0.726996, 5.717291>, 
      <0.585853, -0.629356, 5.678490>, <0.522190, -0.655607, 5.711434>, <0.444606, -0.673567, 5.759976>, <0.374051, -0.701495, 5.768300>, 
      <0.642922, -0.591563, 5.651802>, <0.579260, -0.617814, 5.684746>, <0.501269, -0.651138, 5.753290>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.494590, -0.664417, 5.586620>, <0.435430, -0.687834, 5.593600>, <0.357252, -0.701689, 5.689416>, <0.303911, -0.718562, 5.720514>, 
      <0.585853, -0.629356, 5.678490>, <0.522669, -0.647173, 5.714657>, <0.440546, -0.647693, 5.771388>, <0.371271, -0.675114, 5.779562>, 
      <0.642922, -0.591563, 5.651802>, <0.579738, -0.609380, 5.687969>, <0.501584, -0.623532, 5.764186>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.494590, -0.664417, 5.586620>, <0.585853, -0.629356, 5.678490>, <0.642922, -0.591563, 5.651802>, 
      <0.426687, -0.691295, 5.594632>, <0.496452, -0.664831, 5.592635>, <0.521414, -0.655100, 5.666050>, <0.578484, -0.617307, 5.639362>, 
      <0.426687, -0.691295, 5.594632>, <0.496452, -0.664831, 5.592635>, <0.493412, -0.650118, 5.599000>, <0.493285, -0.651584, 5.602647>, 
      <0.426687, -0.691295, 5.594632>, <0.428549, -0.691710, 5.600647>, <0.428255, -0.675909, 5.606688>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.426687, -0.691295, 5.594632>, <0.369388, -0.715128, 5.607627>, <0.355998, -0.709616, 5.640808>, <0.302656, -0.726488, 5.671907>, 
      <0.426687, -0.691295, 5.594632>, <0.369388, -0.715128, 5.607627>, <0.369574, -0.699137, 5.613612>, <0.369447, -0.700603, 5.617258>, 
      <0.426687, -0.691295, 5.594632>, <0.428549, -0.691710, 5.600647>, <0.428255, -0.675909, 5.606688>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.494590, -0.664417, 5.586620>, <0.585853, -0.629356, 5.678490>, <0.642922, -0.591563, 5.651802>, 
      <0.428549, -0.691710, 5.600647>, <0.496452, -0.664831, 5.592635>, <0.520707, -0.662447, 5.669228>, <0.577776, -0.624654, 5.642540>, 
      <0.428255, -0.675909, 5.606688>, <0.428093, -0.677776, 5.611332>, <0.494554, -0.668120, 5.608672>, <0.493845, -0.674920, 5.612896>, 
      <0.428128, -0.677375, 5.610335>, <0.427966, -0.679242, 5.614979>, <0.426480, -0.695066, 5.616704>, <0.425770, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426687, -0.691295, 5.594632>, <0.367526, -0.714713, 5.601612>, <0.302224, -0.730665, 5.667196>, <0.248883, -0.747537, 5.698295>, 
      <0.428549, -0.691710, 5.600647>, <0.369388, -0.715128, 5.607627>, <0.355290, -0.716963, 5.643986>, <0.301949, -0.733836, 5.675085>, 
      <0.428255, -0.675909, 5.606688>, <0.428093, -0.677776, 5.611332>, <0.371469, -0.716841, 5.623195>, <0.370759, -0.723641, 5.627418>, 
      <0.428128, -0.677375, 5.610335>, <0.427966, -0.679242, 5.614979>, <0.426480, -0.695066, 5.616704>, <0.425770, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.432505, -0.656986, 5.780293>, <0.432535, -0.649193, 5.774320>, <0.432310, -0.650953, 5.772360>, 
      <0.504493, -0.630836, 5.775530>, <0.503717, -0.628798, 5.771891>, <0.432055, -0.652944, 5.770143>, <0.431830, -0.654704, 5.768183>, 
      <0.580030, -0.611801, 5.691441>, <0.516367, -0.638052, 5.724385>, <0.501825, -0.643742, 5.758461>, <0.431270, -0.671670, 5.766786>, 
      <0.642922, -0.591563, 5.651802>, <0.579260, -0.617814, 5.684746>, <0.501269, -0.651138, 5.753290>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.432505, -0.656986, 5.780293>, <0.432535, -0.649193, 5.774320>, <0.432310, -0.650953, 5.772360>, 
      <0.433281, -0.659024, 5.783932>, <0.503717, -0.628798, 5.771891>, <0.501810, -0.621772, 5.766146>, <0.501584, -0.623532, 5.764186>, 
      <0.433281, -0.659024, 5.783932>, <0.503717, -0.628798, 5.771891>, <0.516846, -0.629618, 5.727608>, <0.579738, -0.609380, 5.687969>, 
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.522960, -0.649595, 5.718129>, <0.585853, -0.629356, 5.678490>, 
      <0.306094, -0.715494, 5.709496>, <0.359436, -0.698621, 5.678397>, <0.435430, -0.687834, 5.593600>, <0.494590, -0.664417, 5.586620>, 
      <0.248883, -0.747537, 5.698295>, <0.302224, -0.730665, 5.667196>, <0.367526, -0.714713, 5.601612>, <0.426687, -0.691295, 5.594632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.514360, -0.649348, 5.686333>, <0.577252, -0.629109, 5.646694>, 
      <0.306094, -0.715494, 5.709496>, <0.358636, -0.706248, 5.690440>, <0.441739, -0.709706, 5.632684>, <0.494099, -0.688980, 5.626506>, 
      <0.248883, -0.747537, 5.698295>, <0.301425, -0.738291, 5.679239>, <0.371663, -0.737444, 5.640952>, <0.424023, -0.716718, 5.634774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.514884, -0.644892, 5.682179>, <0.577776, -0.624654, 5.642540>, 
      <0.306094, -0.715494, 5.709496>, <0.359160, -0.701792, 5.686286>, <0.438834, -0.696695, 5.619386>, <0.493845, -0.674920, 5.612896>, 
      <0.248883, -0.747537, 5.698295>, <0.301949, -0.733836, 5.675085>, <0.370759, -0.723641, 5.627418>, <0.425770, -0.701866, 5.620928>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.515591, -0.637545, 5.679001>, <0.578484, -0.617307, 5.639362>, 
      <0.306094, -0.715494, 5.709496>, <0.359868, -0.694445, 5.683108>, <0.434604, -0.674812, 5.609570>, <0.493285, -0.651584, 5.602647>, 
      <0.248883, -0.747537, 5.698295>, <0.302656, -0.726488, 5.671907>, <0.369447, -0.700603, 5.617258>, <0.428128, -0.677375, 5.610335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.515816, -0.643326, 5.718024>, <0.578708, -0.623088, 5.678385>, 
      <0.306094, -0.715494, 5.709496>, <0.360092, -0.700226, 5.722131>, <0.446246, -0.689769, 5.738361>, <0.499409, -0.668725, 5.732088>, 
      <0.248883, -0.747537, 5.698295>, <0.302881, -0.732269, 5.710930>, <0.375712, -0.717689, 5.746684>, <0.428875, -0.696645, 5.740411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.432505, -0.656986, 5.780293>, <0.432535, -0.649193, 5.774320>, <0.432310, -0.650953, 5.772360>, 
      <0.371796, -0.683362, 5.791187>, <0.371020, -0.681324, 5.787548>, <0.432055, -0.652944, 5.770143>, <0.431830, -0.654704, 5.768183>, 
      <0.306094, -0.715494, 5.709496>, <0.360644, -0.694952, 5.728492>, <0.374607, -0.694099, 5.773472>, <0.431270, -0.671670, 5.766786>, 
      <0.248883, -0.747537, 5.698295>, <0.303432, -0.726996, 5.717291>, <0.374051, -0.701495, 5.768300>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.516367, -0.638052, 5.724385>, <0.579260, -0.617814, 5.684746>, 
      <0.306094, -0.715494, 5.709496>, <0.360644, -0.694952, 5.728492>, <0.444606, -0.673567, 5.759976>, <0.501269, -0.651138, 5.753290>, 
      <0.248883, -0.747537, 5.698295>, <0.303432, -0.726996, 5.717291>, <0.374051, -0.701495, 5.768300>, <0.430714, -0.679066, 5.761615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.432505, -0.656986, 5.780293>, <0.432535, -0.649193, 5.774320>, <0.432310, -0.650953, 5.772360>, 
      <0.433281, -0.659024, 5.783932>, <0.371020, -0.681324, 5.787548>, <0.371497, -0.673354, 5.781522>, <0.371271, -0.675114, 5.779562>, 
      <0.433281, -0.659024, 5.783932>, <0.371020, -0.681324, 5.787548>, <0.361122, -0.686518, 5.731715>, <0.303911, -0.718562, 5.720514>, 
      <0.433281, -0.659024, 5.783932>, <0.371796, -0.683362, 5.791187>, <0.306094, -0.715494, 5.709496>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.433281, -0.659024, 5.783932>, <0.504493, -0.630836, 5.775530>, <0.580030, -0.611801, 5.691441>, <0.642922, -0.591563, 5.651802>, 
      <0.371796, -0.683362, 5.791187>, <0.443008, -0.655174, 5.782784>, <0.516846, -0.629618, 5.727608>, <0.579738, -0.609380, 5.687969>, 
      <0.306094, -0.715494, 5.709496>, <0.361122, -0.686518, 5.731715>, <0.440546, -0.647693, 5.771388>, <0.501584, -0.623532, 5.764186>, 
      <0.248883, -0.747537, 5.698295>, <0.303911, -0.718562, 5.720514>, <0.371271, -0.675114, 5.779562>, <0.432310, -0.650953, 5.772360>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.314608, -0.725768, 6.068684>, <0.275462, -0.742992, 6.072328>, <0.221981, -0.771453, 6.065584>, <0.179058, -0.771453, 6.065584>, 
      <0.319857, -0.666524, 6.188280>, <0.280711, -0.683748, 6.191924>, <0.221990, -0.700853, 6.187606>, <0.179067, -0.700853, 6.187606>, 
      <0.316982, -0.564458, 6.345749>, <0.283133, -0.573875, 6.353762>, <0.215079, -0.599128, 6.356247>, <0.179042, -0.599128, 6.356247>, 
      <0.295828, -0.458500, 6.424273>, <0.261979, -0.467917, 6.432286>, <0.215077, -0.483564, 6.436985>, <0.179040, -0.483564, 6.436985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.269775, -0.752550, 5.830678>, <0.262757, -0.754875, 5.791129>, <0.252164, -0.747205, 5.738394>, <0.248883, -0.747537, 5.698295>, 
      <0.237291, -0.766366, 5.839344>, <0.230273, -0.768691, 5.799795>, <0.227584, -0.760972, 5.733582>, <0.224303, -0.761304, 5.693483>, 
      <0.215347, -0.794939, 5.898815>, <0.215337, -0.799395, 5.849578>, <0.207579, -0.801048, 5.783584>, <0.207574, -0.801448, 5.734147>, 
      <0.178999, -0.794939, 5.898815>, <0.178989, -0.799395, 5.849578>, <0.178998, -0.801048, 5.783584>, <0.178993, -0.801448, 5.734147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.269775, -0.752550, 5.830678>, <0.237291, -0.766366, 5.839344>, <0.215347, -0.794939, 5.898815>, <0.178999, -0.794939, 5.898815>, 
      <0.282526, -0.748327, 5.902534>, <0.250042, -0.762143, 5.911200>, <0.215357, -0.790385, 5.949134>, <0.179009, -0.790385, 5.949134>, 
      <0.311735, -0.758192, 6.003231>, <0.272589, -0.775416, 6.006875>, <0.221977, -0.796756, 6.021852>, <0.179055, -0.796756, 6.021852>, 
      <0.314608, -0.725768, 6.068684>, <0.275462, -0.742992, 6.072328>, <0.221981, -0.771453, 6.065584>, <0.179058, -0.771453, 6.065584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.252237, -0.754327, 5.616323>, <0.249785, -0.751404, 5.640723>, <0.246869, -0.747741, 5.673682>, <0.248883, -0.747537, 5.698295>, 
      <0.229809, -0.765796, 5.620881>, <0.227357, -0.762873, 5.645281>, <0.222289, -0.761508, 5.668870>, <0.224303, -0.761304, 5.693483>, 
      <0.204572, -0.797152, 5.625251>, <0.204570, -0.788867, 5.656878>, <0.207571, -0.801713, 5.701454>, <0.207574, -0.801448, 5.734147>, 
      <0.178973, -0.797152, 5.625251>, <0.178971, -0.788867, 5.656878>, <0.178990, -0.801713, 5.701454>, <0.178993, -0.801448, 5.734147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.444184, -0.682147, 5.828069>, <0.440796, -0.683604, 5.813218>, <0.436079, -0.666374, 5.797058>, <0.433281, -0.659024, 5.783932>, 
      <0.394847, -0.705749, 5.841970>, <0.391459, -0.707206, 5.827119>, <0.374594, -0.690712, 5.804313>, <0.371796, -0.683362, 5.791187>, 
      <0.320206, -0.731100, 5.817224>, <0.313188, -0.733425, 5.777675>, <0.309375, -0.715161, 5.749595>, <0.306094, -0.715494, 5.709496>, 
      <0.269775, -0.752550, 5.830678>, <0.262757, -0.754875, 5.791129>, <0.252164, -0.747205, 5.738394>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.285147, -0.892291, 5.152173>, <0.283670, -0.875301, 5.107058>, <0.250966, -0.785070, 5.134997>, <0.237306, -0.743393, 5.114931>, 
      <0.257698, -0.911847, 5.152116>, <0.256221, -0.894857, 5.107002>, <0.233407, -0.790425, 5.131044>, <0.219748, -0.748748, 5.110978>, 
      <0.212747, -0.927813, 5.162249>, <0.212743, -0.906785, 5.112601>, <0.197775, -0.807110, 5.124459>, <0.197763, -0.759588, 5.098987>, 
      <0.179044, -0.927813, 5.162249>, <0.179039, -0.906785, 5.112601>, <0.178997, -0.807110, 5.124459>, <0.178985, -0.759588, 5.098987>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.229114, -0.721331, 5.069862>, <0.214142, -0.722460, 5.063540>, <0.195280, -0.717237, 5.049378>, <0.178989, -0.717237, 5.049378>, 
      <0.232462, -0.726461, 5.083831>, <0.217490, -0.727591, 5.077508>, <0.195278, -0.725477, 5.067127>, <0.178987, -0.725477, 5.067127>, 
      <0.232986, -0.730213, 5.108585>, <0.215428, -0.735568, 5.104632>, <0.197758, -0.742341, 5.089743>, <0.178980, -0.742341, 5.089743>, 
      <0.237306, -0.743393, 5.114931>, <0.219748, -0.748748, 5.110978>, <0.197763, -0.759588, 5.098987>, <0.178985, -0.759588, 5.098987>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.229114, -0.721331, 5.069862>, <0.214142, -0.722460, 5.063540>, <0.195280, -0.717237, 5.049378>, <0.178989, -0.717237, 5.049378>, 
      <0.229114, -0.721331, 5.069862>, <0.199972, -0.700747, 5.004418>, <0.195285, -0.693413, 4.998064>, <0.178994, -0.693413, 4.998064>, 
      <0.229114, -0.721331, 5.069862>, <0.199972, -0.700747, 5.004418>, <0.194034, -0.693194, 4.984448>, <0.179002, -0.673013, 4.924997>, 
      <0.229114, -0.721331, 5.069862>, <0.214944, -0.699618, 5.010740>, <0.194039, -0.674241, 4.931142>, <0.179007, -0.654060, 4.871691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.229114, -0.721331, 5.069862>, <0.214944, -0.699618, 5.010740>, <0.194039, -0.674241, 4.931142>, <0.179007, -0.654060, 4.871691>, 
      <0.214142, -0.722460, 5.063540>, <0.199972, -0.700747, 5.004418>, <0.175992, -0.694423, 4.990594>, <0.160960, -0.674241, 4.931142>, 
      <0.195280, -0.717237, 5.049378>, <0.176181, -0.717237, 5.049378>, <0.153310, -0.700772, 5.003753>, <0.135510, -0.699555, 5.010569>, 
      <0.178989, -0.717237, 5.049378>, <0.159890, -0.717237, 5.049378>, <0.136649, -0.722549, 5.063046>, <0.118849, -0.721331, 5.069862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.276356, -0.709892, 5.090496>, <0.272224, -0.691558, 5.024066>, <0.272062, -0.672280, 4.933920>, <0.270221, -0.656161, 4.866815>, 
      <0.262895, -0.713397, 5.082914>, <0.258764, -0.695063, 5.016484>, <0.244762, -0.673365, 4.936130>, <0.242921, -0.657246, 4.869026>, 
      <0.243673, -0.720233, 5.076010>, <0.229502, -0.698519, 5.016888>, <0.221450, -0.674241, 4.931142>, <0.206418, -0.654060, 4.871691>, 
      <0.229114, -0.721331, 5.069862>, <0.214944, -0.699618, 5.010740>, <0.194039, -0.674241, 4.931142>, <0.179007, -0.654060, 4.871691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.286162, -0.726899, 5.123115>, <0.281960, -0.717986, 5.117340>, <0.277040, -0.712925, 5.101486>, <0.276356, -0.709892, 5.090496>, 
      <0.272489, -0.734475, 5.122128>, <0.268286, -0.725562, 5.116353>, <0.263579, -0.716430, 5.093904>, <0.262895, -0.713397, 5.082914>, 
      <0.251952, -0.738926, 5.118228>, <0.247632, -0.725746, 5.111883>, <0.247021, -0.725363, 5.089979>, <0.243673, -0.720233, 5.076010>, 
      <0.237306, -0.743393, 5.114931>, <0.232986, -0.730213, 5.108585>, <0.232462, -0.726461, 5.083831>, <0.229114, -0.721331, 5.069862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.328799, -0.821124, 5.162559>, <0.329427, -0.813563, 5.130231>, <0.298380, -0.752813, 5.139904>, <0.286162, -0.726899, 5.123115>, 
      <0.323804, -0.842395, 5.149925>, <0.324432, -0.834834, 5.117597>, <0.284707, -0.760390, 5.138916>, <0.272489, -0.734475, 5.122128>, 
      <0.305703, -0.877646, 5.152216>, <0.304227, -0.860656, 5.107101>, <0.265612, -0.780603, 5.138294>, <0.251952, -0.738926, 5.118228>, 
      <0.285147, -0.892291, 5.152173>, <0.283670, -0.875301, 5.107058>, <0.250966, -0.785070, 5.134997>, <0.237306, -0.743393, 5.114931>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.417725, -0.675058, 5.576726>, <0.419923, -0.674369, 5.584109>, <0.424405, -0.690787, 5.587260>, <0.426687, -0.691295, 5.594632>, 
      <0.368442, -0.699444, 5.588888>, <0.370640, -0.698755, 5.596271>, <0.365245, -0.714205, 5.594241>, <0.367526, -0.714713, 5.601612>, 
      <0.301575, -0.729096, 5.606295>, <0.299123, -0.726173, 5.630695>, <0.300210, -0.730869, 5.642583>, <0.302224, -0.730665, 5.667196>, 
      <0.252237, -0.754327, 5.616323>, <0.249785, -0.751404, 5.640723>, <0.246869, -0.747741, 5.673682>, <0.248883, -0.747537, 5.698295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.246511, -0.849301, 5.396158>, <0.262124, -0.833702, 5.392113>, <0.272736, -0.799812, 5.391891>, <0.281247, -0.786114, 5.376291>, 
      <0.230751, -0.835179, 5.466379>, <0.246364, -0.819580, 5.462334>, <0.260690, -0.789303, 5.463281>, <0.269202, -0.775605, 5.447681>, 
      <0.199234, -0.812797, 5.556523>, <0.224834, -0.812797, 5.556523>, <0.237074, -0.774455, 5.548602>, <0.259502, -0.762986, 5.544044>, 
      <0.178973, -0.797152, 5.625251>, <0.204572, -0.797152, 5.625251>, <0.229809, -0.765796, 5.620881>, <0.252237, -0.754327, 5.616323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.246511, -0.849301, 5.396158>, <0.230184, -0.865613, 5.400388>, <0.202477, -0.888256, 5.402779>, <0.179013, -0.888256, 5.402779>, 
      <0.246511, -0.849301, 5.396158>, <0.214424, -0.851491, 5.470609>, <0.202466, -0.868668, 5.472189>, <0.179002, -0.868668, 5.472189>, 
      <0.246511, -0.849301, 5.396158>, <0.214424, -0.851491, 5.470609>, <0.199239, -0.831073, 5.486756>, <0.178977, -0.815429, 5.555484>, 
      <0.246511, -0.849301, 5.396158>, <0.230751, -0.835179, 5.466379>, <0.199234, -0.812797, 5.556523>, <0.178973, -0.797152, 5.625251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.246511, -0.849301, 5.396158>, <0.230184, -0.865613, 5.400388>, <0.202477, -0.888256, 5.402779>, <0.179013, -0.888256, 5.402779>, 
      <0.230751, -0.835179, 5.466379>, <0.214424, -0.851491, 5.470609>, <0.176363, -0.888256, 5.402779>, <0.152899, -0.888256, 5.402779>, 
      <0.199234, -0.812797, 5.556523>, <0.175978, -0.828442, 5.487795>, <0.137852, -0.852383, 5.471393>, <0.120482, -0.866611, 5.400647>, 
      <0.178973, -0.797152, 5.625251>, <0.155716, -0.812797, 5.556523>, <0.118822, -0.835074, 5.466904>, <0.101451, -0.849301, 5.396158>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.246511, -0.849301, 5.396158>, <0.262124, -0.833702, 5.392113>, <0.272736, -0.799812, 5.391891>, <0.281247, -0.786114, 5.376291>, 
      <0.262675, -0.863785, 5.324136>, <0.278288, -0.848186, 5.320091>, <0.283688, -0.809368, 5.326977>, <0.292200, -0.795670, 5.311376>, 
      <0.287450, -0.918789, 5.222535>, <0.308006, -0.904144, 5.222578>, <0.322547, -0.857542, 5.214687>, <0.327542, -0.836271, 5.227321>, 
      <0.285147, -0.892291, 5.152173>, <0.305703, -0.877646, 5.152216>, <0.323804, -0.842395, 5.149925>, <0.328799, -0.821124, 5.162559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.246511, -0.849301, 5.396158>, <0.262675, -0.863785, 5.324136>, <0.287450, -0.918789, 5.222535>, <0.285147, -0.892291, 5.152173>, 
      <0.230184, -0.865613, 5.400388>, <0.246348, -0.880097, 5.328366>, <0.260001, -0.938345, 5.222478>, <0.257698, -0.911847, 5.152116>, 
      <0.202477, -0.888256, 5.402779>, <0.202488, -0.908117, 5.332399>, <0.212753, -0.956333, 5.229587>, <0.212747, -0.927813, 5.162249>, 
      <0.179013, -0.888256, 5.402779>, <0.179024, -0.908117, 5.332399>, <0.179050, -0.956333, 5.229587>, <0.179044, -0.927813, 5.162249>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.324847, -0.723228, 5.252583>, <0.311767, -0.742094, 5.289695>, <0.297801, -0.759472, 5.345951>, <0.281247, -0.786114, 5.376291>, 
      <0.324847, -0.723228, 5.252583>, <0.289523, -0.768745, 5.269992>, <0.308754, -0.769028, 5.281036>, <0.292200, -0.795670, 5.311376>, 
      <0.324847, -0.723228, 5.252583>, <0.289523, -0.768745, 5.269992>, <0.335442, -0.802630, 5.247301>, <0.327542, -0.836271, 5.227321>, 
      <0.324847, -0.723228, 5.252583>, <0.302603, -0.749879, 5.232880>, <0.336699, -0.787483, 5.182539>, <0.328799, -0.821124, 5.162559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.324847, -0.723228, 5.252583>, <0.346306, -0.718262, 5.352364>, <0.388683, -0.684165, 5.479181>, <0.417725, -0.675058, 5.576726>, 
      <0.311767, -0.742094, 5.289695>, <0.333226, -0.737128, 5.389476>, <0.339400, -0.708550, 5.491344>, <0.368442, -0.699444, 5.588888>, 
      <0.297801, -0.759472, 5.345951>, <0.285756, -0.748963, 5.417341>, <0.308840, -0.737756, 5.534016>, <0.301575, -0.729096, 5.606295>, 
      <0.281247, -0.786114, 5.376291>, <0.269202, -0.775605, 5.447681>, <0.259502, -0.762986, 5.544044>, <0.252237, -0.754327, 5.616323>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.319692, -0.697743, 5.120880>, <0.306691, -0.701388, 5.111765>, <0.290198, -0.706287, 5.098293>, <0.276356, -0.709892, 5.090496>, 
      <0.319692, -0.697743, 5.120880>, <0.296632, -0.710135, 5.112435>, <0.290882, -0.709320, 5.109283>, <0.277040, -0.712925, 5.101486>, 
      <0.319692, -0.697743, 5.120880>, <0.296632, -0.710135, 5.112435>, <0.293611, -0.711530, 5.118182>, <0.281960, -0.717986, 5.117340>, 
      <0.319692, -0.697743, 5.120880>, <0.309633, -0.706490, 5.121550>, <0.297813, -0.720443, 5.123956>, <0.286162, -0.726899, 5.123115>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.319692, -0.697743, 5.120880>, <0.309633, -0.706490, 5.121550>, <0.297813, -0.720443, 5.123956>, <0.286162, -0.726899, 5.123115>, 
      <0.308825, -0.684401, 5.044139>, <0.298766, -0.693148, 5.044809>, <0.293611, -0.711530, 5.118182>, <0.281960, -0.717986, 5.117340>, 
      <0.285062, -0.668636, 4.943035>, <0.286903, -0.684755, 5.010139>, <0.272908, -0.694591, 5.035056>, <0.277040, -0.712925, 5.101486>, 
      <0.270221, -0.656161, 4.866815>, <0.272062, -0.672280, 4.933920>, <0.272224, -0.691558, 5.024066>, <0.276356, -0.709892, 5.090496>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.319692, -0.697743, 5.120880>, <0.306691, -0.701388, 5.111765>, <0.290198, -0.706287, 5.098293>, <0.276356, -0.709892, 5.090496>, 
      <0.319692, -0.697743, 5.120880>, <0.295824, -0.688046, 5.035024>, <0.286067, -0.687953, 5.031863>, <0.272224, -0.691558, 5.024066>, 
      <0.319692, -0.697743, 5.120880>, <0.295824, -0.688046, 5.035024>, <0.286903, -0.684755, 5.010139>, <0.272062, -0.672280, 4.933920>, 
      <0.319692, -0.697743, 5.120880>, <0.308825, -0.684401, 5.044139>, <0.285062, -0.668636, 4.943035>, <0.270221, -0.656161, 4.866815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.319692, -0.697743, 5.120880>, <0.325257, -0.704575, 5.160178>, <0.316389, -0.725185, 5.213256>, <0.324847, -0.723228, 5.252583>, 
      <0.309633, -0.706490, 5.121550>, <0.315198, -0.713322, 5.160848>, <0.294145, -0.751836, 5.193553>, <0.302603, -0.749879, 5.232880>, 
      <0.297813, -0.720443, 5.123956>, <0.310031, -0.746357, 5.140745>, <0.337326, -0.779922, 5.150211>, <0.336699, -0.787483, 5.182539>, 
      <0.286162, -0.726899, 5.123115>, <0.298380, -0.752813, 5.139904>, <0.329427, -0.813563, 5.130231>, <0.328799, -0.821124, 5.162559>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.295533, -0.541279, 3.917532>, <0.280710, -0.466766, 3.930294>, <0.259238, -0.364540, 3.934958>, <0.246124, -0.292902, 3.960072>, 
      <0.264534, -0.560182, 3.918148>, <0.249711, -0.485669, 3.930910>, <0.239901, -0.381686, 3.931053>, <0.226787, -0.310048, 3.956167>, 
      <0.220137, -0.587893, 3.917532>, <0.219046, -0.516171, 3.927061>, <0.207381, -0.417968, 3.928000>, <0.206324, -0.348820, 3.949295>, 
      <0.183824, -0.587893, 3.917532>, <0.182733, -0.516171, 3.927061>, <0.181243, -0.417968, 3.928000>, <0.180187, -0.348820, 3.949295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.234215, -0.206319, 4.034959>, <0.216987, -0.225118, 4.026676>, <0.205832, -0.273517, 4.014350>, <0.179021, -0.273517, 4.014350>, 
      <0.231864, -0.223596, 4.005157>, <0.214636, -0.242395, 3.996874>, <0.206066, -0.286562, 3.987496>, <0.179256, -0.286562, 3.987496>, 
      <0.240246, -0.260794, 3.971328>, <0.220909, -0.277940, 3.967423>, <0.205888, -0.320290, 3.958082>, <0.179751, -0.320290, 3.958082>, 
      <0.246124, -0.292902, 3.960072>, <0.226787, -0.310048, 3.956167>, <0.206324, -0.348820, 3.949295>, <0.180187, -0.348820, 3.949295>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.417803, -0.445213, 3.912879>, <0.388591, -0.378990, 3.932300>, <0.341487, -0.288231, 3.944342>, <0.320431, -0.224471, 3.977616>, 
      <0.385415, -0.478808, 3.913524>, <0.356204, -0.412586, 3.932945>, <0.322471, -0.311170, 3.936705>, <0.301416, -0.247410, 3.969980>, 
      <0.335373, -0.516985, 3.916740>, <0.320550, -0.442472, 3.929502>, <0.281995, -0.344363, 3.939553>, <0.268880, -0.272725, 3.964668>, 
      <0.295533, -0.541279, 3.917532>, <0.280710, -0.466766, 3.930294>, <0.259238, -0.364540, 3.934958>, <0.246124, -0.292902, 3.960072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.312871, -0.127463, 4.078704>, <0.293210, -0.151672, 4.060926>, <0.257283, -0.181148, 4.046050>, <0.234215, -0.206319, 4.034959>, 
      <0.304033, -0.148525, 4.043347>, <0.284372, -0.172734, 4.025570>, <0.254931, -0.198425, 4.016248>, <0.231864, -0.223596, 4.005157>, 
      <0.308604, -0.188658, 3.996306>, <0.289589, -0.211596, 3.988669>, <0.263003, -0.240617, 3.975924>, <0.240246, -0.260794, 3.971328>, 
      <0.320431, -0.224471, 3.977616>, <0.301416, -0.247410, 3.969980>, <0.268880, -0.272725, 3.964668>, <0.246124, -0.292902, 3.960072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.508180, -0.320703, 3.913296>, <0.472110, -0.261037, 3.944415>, <0.404166, -0.178750, 3.968808>, <0.387947, -0.121818, 4.017027>, 
      <0.485337, -0.360777, 3.911662>, <0.449267, -0.301111, 3.942781>, <0.386859, -0.210166, 3.954248>, <0.370640, -0.153233, 4.002467>, 
      <0.449835, -0.411987, 3.912241>, <0.420623, -0.345764, 3.931662>, <0.365418, -0.259363, 3.953952>, <0.344362, -0.195603, 3.987226>, 
      <0.417803, -0.445213, 3.912879>, <0.388591, -0.378990, 3.932300>, <0.341487, -0.288231, 3.944342>, <0.320431, -0.224471, 3.977616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.412909, 0.013715, 4.196532>, <0.385649, -0.027117, 4.157370>, <0.347266, -0.085110, 4.109804>, <0.312871, -0.127463, 4.078704>, 
      <0.390690, -0.018344, 4.140963>, <0.363431, -0.059176, 4.101801>, <0.338429, -0.106172, 4.074447>, <0.304033, -0.148525, 4.043347>, 
      <0.373525, -0.071193, 4.059904>, <0.356218, -0.102608, 4.045344>, <0.332535, -0.159789, 4.005916>, <0.308604, -0.188658, 3.996306>, 
      <0.387947, -0.121818, 4.017027>, <0.370640, -0.153233, 4.002467>, <0.344362, -0.195603, 3.987226>, <0.320431, -0.224471, 3.977616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.605342, -0.116219, 3.926295>, <0.560538, -0.074873, 3.975904>, <0.470956, -0.020312, 4.026871>, <0.455995, 0.021600, 4.091659>, 
      <0.588549, -0.182135, 3.925186>, <0.543745, -0.140789, 3.974795>, <0.454032, -0.065200, 4.005241>, <0.439072, -0.023289, 4.070030>, 
      <0.541849, -0.261638, 3.915704>, <0.505779, -0.201973, 3.946824>, <0.427694, -0.136043, 3.988601>, <0.411475, -0.079111, 4.036820>, 
      <0.508180, -0.320703, 3.913296>, <0.472110, -0.261037, 3.944415>, <0.404166, -0.178750, 3.968808>, <0.387947, -0.121818, 4.017027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.506060, 0.161915, 4.356246>, <0.479478, 0.120316, 4.305096>, <0.443765, 0.059935, 4.240861>, <0.412909, 0.013715, 4.196532>, 
      <0.476072, 0.124815, 4.278642>, <0.449491, 0.083216, 4.227491>, <0.421546, 0.027876, 4.185292>, <0.390690, -0.018344, 4.140963>, 
      <0.438656, 0.070174, 4.166746>, <0.421733, 0.025285, 4.145117>, <0.397053, -0.028486, 4.079697>, <0.373525, -0.071193, 4.059904>, 
      <0.455995, 0.021600, 4.091659>, <0.439072, -0.023289, 4.070030>, <0.411475, -0.079111, 4.036820>, <0.387947, -0.121818, 4.017027>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.659055, 0.398917, 4.670178>, <0.628758, 0.321590, 4.574604>, <0.553406, 0.236009, 4.447352>, <0.506060, 0.161915, 4.356246>, 
      <0.599059, 0.340842, 4.517467>, <0.568762, 0.263515, 4.421893>, <0.523419, 0.198908, 4.369748>, <0.476072, 0.124815, 4.278642>, 
      <0.508845, 0.238155, 4.321248>, <0.506545, 0.192011, 4.297852>, <0.455311, 0.114350, 4.188032>, <0.438656, 0.070174, 4.166746>, 
      <0.499542, 0.174182, 4.159651>, <0.497242, 0.128037, 4.136254>, <0.472650, 0.065777, 4.112945>, <0.455995, 0.021600, 4.091659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.615893, 0.102097, 3.920408>, <0.580988, 0.123723, 3.992181>, <0.495122, 0.143789, 4.082878>, <0.499542, 0.174182, 4.159651>, 
      <0.626426, 0.037395, 3.922745>, <0.591521, 0.059021, 3.994518>, <0.492823, 0.097644, 4.059481>, <0.497242, 0.128037, 4.136254>, 
      <0.621534, -0.052663, 3.927364>, <0.576730, -0.011317, 3.976973>, <0.487611, 0.023865, 4.048157>, <0.472650, 0.065777, 4.112945>, 
      <0.605342, -0.116219, 3.926295>, <0.560538, -0.074873, 3.975904>, <0.470956, -0.020312, 4.026871>, <0.455995, 0.021600, 4.091659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.715346, 0.696077, 5.016458>, <0.723485, 0.602503, 4.915452>, <0.692059, 0.483152, 4.774291>, <0.659055, 0.398917, 4.670178>, 
      <0.631084, 0.623127, 4.778880>, <0.639223, 0.529553, 4.677875>, <0.632062, 0.425077, 4.621580>, <0.599059, 0.340842, 4.517467>, 
      <0.507352, 0.446736, 4.492496>, <0.520358, 0.397859, 4.463108>, <0.511442, 0.290277, 4.347676>, <0.508845, 0.238155, 4.321248>, 
      <0.471984, 0.342405, 4.254318>, <0.484990, 0.293528, 4.224929>, <0.502140, 0.226304, 4.186078>, <0.499542, 0.174182, 4.159651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.551695, 0.213330, 3.914393>, <0.527782, 0.252053, 4.016371>, <0.456933, 0.298007, 4.152962>, <0.471984, 0.342405, 4.254318>, 
      <0.571910, 0.180485, 3.914889>, <0.547997, 0.219207, 4.016867>, <0.469939, 0.249130, 4.123573>, <0.484990, 0.293528, 4.224929>, 
      <0.609700, 0.140143, 3.919034>, <0.574794, 0.161768, 3.990807>, <0.497720, 0.195911, 4.109305>, <0.502140, 0.226304, 4.186078>, 
      <0.615893, 0.102097, 3.920408>, <0.580988, 0.123723, 3.992181>, <0.495122, 0.143789, 4.082878>, <0.499542, 0.174182, 4.159651>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.621710, 0.828275, 5.133634>, <0.662080, 0.793056, 5.106661>, <0.711807, 0.736769, 5.060382>, <0.715346, 0.696077, 5.016458>, 
      <0.568081, 0.755997, 4.879084>, <0.608452, 0.720778, 4.852110>, <0.627544, 0.663819, 4.822804>, <0.631084, 0.623127, 4.778880>, 
      <0.463616, 0.550479, 4.587482>, <0.484722, 0.516083, 4.564346>, <0.497010, 0.485604, 4.515867>, <0.507352, 0.446736, 4.492496>, 
      <0.422086, 0.465269, 4.334676>, <0.443192, 0.430872, 4.311540>, <0.461642, 0.381273, 4.277688>, <0.471984, 0.342405, 4.254318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.421623, 0.417740, 3.915642>, <0.384786, 0.459461, 3.916292>, <0.322375, 0.502990, 3.919638>, <0.273096, 0.528864, 3.919311>, 
      <0.421762, 0.431999, 4.041352>, <0.384925, 0.473719, 4.042003>, <0.337706, 0.519307, 4.068740>, <0.288427, 0.545181, 4.068413>, 
      <0.402626, 0.425340, 4.216213>, <0.378984, 0.463870, 4.242129>, <0.344579, 0.513810, 4.262247>, <0.301273, 0.540485, 4.273567>, 
      <0.422086, 0.465269, 4.334676>, <0.398444, 0.503799, 4.360592>, <0.367506, 0.556580, 4.404997>, <0.324200, 0.583254, 4.416318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.421623, 0.417740, 3.915642>, <0.421762, 0.431999, 4.041352>, <0.402626, 0.425340, 4.216213>, <0.422086, 0.465269, 4.334676>, 
      <0.469729, 0.363257, 3.914793>, <0.469868, 0.377515, 4.040503>, <0.423731, 0.390944, 4.193078>, <0.443192, 0.430872, 4.311540>, 
      <0.513599, 0.275226, 3.913458>, <0.489686, 0.313949, 4.015436>, <0.446591, 0.336875, 4.176332>, <0.461642, 0.381273, 4.277688>, 
      <0.551695, 0.213330, 3.914393>, <0.527782, 0.252053, 4.016371>, <0.456933, 0.298007, 4.152962>, <0.471984, 0.342405, 4.254318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.475091, 0.905674, 5.176983>, <0.449358, 0.838070, 4.935638>, <0.362513, 0.654725, 4.654864>, <0.324200, 0.583254, 4.416318>, 
      <0.388622, 0.936721, 5.184634>, <0.362889, 0.869117, 4.943289>, <0.325191, 0.677713, 4.664620>, <0.286878, 0.606243, 4.426074>, 
      <0.271041, 0.987286, 5.172820>, <0.271072, 0.915274, 4.925250>, <0.224761, 0.700024, 4.641611>, <0.223942, 0.614976, 4.398212>, 
      <0.178849, 0.987286, 5.172820>, <0.178880, 0.915274, 4.925250>, <0.179854, 0.700024, 4.641611>, <0.179035, 0.614976, 4.398212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.475091, 0.905674, 5.176983>, <0.449358, 0.838070, 4.935638>, <0.362513, 0.654725, 4.654864>, <0.324200, 0.583254, 4.416318>, 
      <0.523310, 0.888361, 5.172716>, <0.497577, 0.820757, 4.931371>, <0.405819, 0.628050, 4.643543>, <0.367506, 0.556580, 4.404997>, 
      <0.587108, 0.858462, 5.156753>, <0.533479, 0.786183, 4.902203>, <0.439974, 0.589009, 4.613397>, <0.398444, 0.503799, 4.360592>, 
      <0.621710, 0.828275, 5.133634>, <0.568081, 0.755997, 4.879084>, <0.463616, 0.550479, 4.587482>, <0.422086, 0.465269, 4.334676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.174612, 0.547436, 3.914006>, <0.144174, 0.548124, 3.914006>, <0.101036, 0.547826, 3.919135>, <0.074247, 0.533360, 3.919311>, 
      <0.175939, 0.567698, 4.059268>, <0.145501, 0.568386, 4.059268>, <0.085847, 0.562795, 4.068237>, <0.059059, 0.548328, 4.068413>, 
      <0.178569, 0.566594, 4.259748>, <0.130674, 0.566594, 4.259748>, <0.086779, 0.564815, 4.283676>, <0.046476, 0.540995, 4.273567>, 
      <0.179035, 0.614976, 4.398212>, <0.131140, 0.614976, 4.398212>, <0.063922, 0.607074, 4.426427>, <0.023619, 0.583254, 4.416318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.174612, 0.547436, 3.914006>, <0.175939, 0.567698, 4.059268>, <0.178569, 0.566594, 4.259748>, <0.179035, 0.614976, 4.398212>, 
      <0.204712, 0.546755, 3.914006>, <0.206039, 0.567017, 4.059268>, <0.223476, 0.566594, 4.259748>, <0.223942, 0.614976, 4.398212>, 
      <0.246440, 0.542860, 3.919134>, <0.261771, 0.559177, 4.068236>, <0.263950, 0.563473, 4.283324>, <0.286878, 0.606243, 4.426074>, 
      <0.273096, 0.528864, 3.919311>, <0.288427, 0.545181, 4.068413>, <0.301273, 0.540485, 4.273567>, <0.324200, 0.583254, 4.416318>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.260439, -0.187715, 4.141513>, <0.247377, -0.193518, 4.111337>, <0.236489, -0.189611, 4.063778>, <0.234215, -0.206319, 4.034959>, 
      <0.234314, -0.214561, 4.122640>, <0.221252, -0.220364, 4.092464>, <0.219261, -0.208410, 4.055495>, <0.216987, -0.225118, 4.026676>, 
      <0.220973, -0.284448, 4.081814>, <0.220971, -0.281996, 4.061458>, <0.205670, -0.264559, 4.032792>, <0.205832, -0.273517, 4.014350>, 
      <0.179028, -0.284448, 4.081814>, <0.179026, -0.281996, 4.061458>, <0.178860, -0.264559, 4.032792>, <0.179021, -0.273517, 4.014350>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.383374, -0.074465, 4.229430>, <0.357411, -0.088470, 4.186134>, <0.323871, -0.101248, 4.122711>, <0.312871, -0.127463, 4.078704>, 
      <0.350960, -0.108166, 4.197435>, <0.324997, -0.122171, 4.154138>, <0.304210, -0.125458, 4.104933>, <0.293210, -0.151672, 4.060926>, 
      <0.295728, -0.151453, 4.167005>, <0.282666, -0.157256, 4.136829>, <0.259556, -0.164441, 4.074869>, <0.257283, -0.181148, 4.046050>, 
      <0.260439, -0.187715, 4.141513>, <0.247377, -0.193518, 4.111337>, <0.236489, -0.189611, 4.063778>, <0.234215, -0.206319, 4.034959>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.553313, 0.116782, 4.430603>, <0.503521, 0.092420, 4.362865>, <0.441554, 0.055046, 4.268173>, <0.412909, 0.013715, 4.196532>, 
      <0.507478, 0.059033, 4.366592>, <0.457685, 0.034670, 4.298854>, <0.414295, 0.014214, 4.229011>, <0.385649, -0.027117, 4.157370>, 
      <0.439233, -0.016389, 4.284568>, <0.413270, -0.030394, 4.241272>, <0.358266, -0.058895, 4.153810>, <0.347266, -0.085110, 4.109804>, 
      <0.383374, -0.074465, 4.229430>, <0.357411, -0.088470, 4.186134>, <0.323871, -0.101248, 4.122711>, <0.312871, -0.127463, 4.078704>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.656773, 0.270000, 4.611247>, <0.605816, 0.249664, 4.534190>, <0.537200, 0.200441, 4.436832>, <0.506060, 0.161915, 4.356246>, 
      <0.627948, 0.232237, 4.549960>, <0.576991, 0.211901, 4.472902>, <0.510618, 0.158842, 4.385682>, <0.479478, 0.120316, 4.305096>, 
      <0.589715, 0.162646, 4.481440>, <0.539923, 0.138284, 4.413702>, <0.472411, 0.101266, 4.312502>, <0.443765, 0.059935, 4.240861>, 
      <0.553313, 0.116782, 4.430603>, <0.503521, 0.092420, 4.362865>, <0.441554, 0.055046, 4.268173>, <0.412909, 0.013715, 4.196532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.873240, 0.535913, 5.110834>, <0.808425, 0.517581, 4.973878>, <0.711666, 0.449843, 4.804090>, <0.659055, 0.398917, 4.670178>, 
      <0.829036, 0.453437, 4.954989>, <0.764221, 0.435105, 4.818033>, <0.681369, 0.372516, 4.708516>, <0.628758, 0.321590, 4.574604>, 
      <0.724345, 0.358525, 4.754918>, <0.673387, 0.338189, 4.677861>, <0.584546, 0.274534, 4.527938>, <0.553406, 0.236009, 4.447352>, 
      <0.656773, 0.270000, 4.611247>, <0.605816, 0.249664, 4.534190>, <0.537200, 0.200441, 4.436832>, <0.506060, 0.161915, 4.356246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.889146, 0.703564, 5.430505>, <0.863474, 0.750973, 5.516992>, <0.772173, 0.802532, 5.614850>, <0.705011, 0.846582, 5.677585>, 
      <0.845183, 0.734192, 5.306884>, <0.819511, 0.781600, 5.393372>, <0.740918, 0.842110, 5.457559>, <0.673755, 0.886160, 5.520293>, 
      <0.758608, 0.733531, 5.138435>, <0.755069, 0.774223, 5.182359>, <0.694890, 0.837275, 5.262392>, <0.654520, 0.872494, 5.289366>, 
      <0.715346, 0.696077, 5.016458>, <0.711807, 0.736769, 5.060382>, <0.662080, 0.793056, 5.106661>, <0.621710, 0.828275, 5.133634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.889146, 0.703564, 5.430505>, <0.845183, 0.734192, 5.306884>, <0.758608, 0.733531, 5.138435>, <0.715346, 0.696077, 5.016458>, 
      <0.916450, 0.653141, 5.338519>, <0.872487, 0.683769, 5.214898>, <0.766747, 0.639957, 5.037429>, <0.723485, 0.602503, 4.915452>, 
      <0.899598, 0.585093, 5.203764>, <0.834784, 0.566761, 5.066808>, <0.744670, 0.534079, 4.908203>, <0.692059, 0.483152, 4.774291>, 
      <0.873240, 0.535913, 5.110834>, <0.808425, 0.517581, 4.973878>, <0.711666, 0.449843, 4.804090>, <0.659055, 0.398917, 4.670178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.473710, 0.976036, 5.818554>, <0.391681, 1.008173, 5.853717>, <0.273707, 1.052721, 5.903135>, <0.178849, 1.052721, 5.903135>, 
      <0.454862, 1.026329, 5.632526>, <0.372833, 1.058466, 5.667689>, <0.273675, 1.117746, 5.692993>, <0.178818, 1.117746, 5.692993>, 
      <0.494867, 0.957627, 5.362457>, <0.408398, 0.988674, 5.370109>, <0.271015, 1.048724, 5.384038>, <0.178823, 1.048724, 5.384038>, 
      <0.475091, 0.905674, 5.176983>, <0.388622, 0.936721, 5.184634>, <0.271041, 0.987286, 5.172820>, <0.178849, 0.987286, 5.172820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.473710, 0.976036, 5.818554>, <0.454862, 1.026329, 5.632526>, <0.494867, 0.957627, 5.362457>, <0.475091, 0.905674, 5.176983>, 
      <0.551595, 0.945523, 5.785167>, <0.532747, 0.995815, 5.599139>, <0.543086, 0.940314, 5.358190>, <0.523310, 0.888361, 5.172716>, 
      <0.645658, 0.885510, 5.733026>, <0.614402, 0.925088, 5.575734>, <0.619918, 0.902681, 5.312485>, <0.587108, 0.858462, 5.156753>, 
      <0.705011, 0.846582, 5.677585>, <0.673755, 0.886160, 5.520293>, <0.654520, 0.872494, 5.289366>, <0.621710, 0.828275, 5.133634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.325105, -0.165939, 4.244936>, <0.303543, -0.167113, 4.214680>, <0.274980, -0.181255, 4.175106>, <0.260439, -0.187715, 4.141513>, 
      <0.282240, -0.201745, 4.215753>, <0.260678, -0.202919, 4.185497>, <0.248855, -0.208101, 4.156234>, <0.234314, -0.214561, 4.122640>, 
      <0.242055, -0.291134, 4.160587>, <0.242055, -0.288433, 4.137024>, <0.220976, -0.287285, 4.105360>, <0.220973, -0.284448, 4.081814>, 
      <0.179037, -0.291134, 4.160587>, <0.179037, -0.288433, 4.137024>, <0.179031, -0.287285, 4.105360>, <0.179028, -0.284448, 4.081814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.488183, -0.032896, 4.371059>, <0.453401, -0.037502, 4.329605>, <0.410287, -0.059947, 4.274312>, <0.383374, -0.074465, 4.229430>, 
      <0.442222, -0.071907, 4.328823>, <0.407440, -0.076513, 4.287369>, <0.377873, -0.093648, 4.242316>, <0.350960, -0.108166, 4.197435>, 
      <0.375174, -0.124115, 4.279024>, <0.353612, -0.125289, 4.248768>, <0.310269, -0.144992, 4.200599>, <0.295728, -0.151453, 4.167005>, 
      <0.325105, -0.165939, 4.244936>, <0.303543, -0.167113, 4.214680>, <0.274980, -0.181255, 4.175106>, <0.260439, -0.187715, 4.141513>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.705330, 0.156790, 4.594345>, <0.656880, 0.154711, 4.546542>, <0.592050, 0.135735, 4.483302>, <0.553313, 0.116782, 4.430603>, 
      <0.649701, 0.102454, 4.517389>, <0.601251, 0.100375, 4.469586>, <0.546215, 0.077986, 4.419290>, <0.507478, 0.059033, 4.366592>, 
      <0.556495, 0.025086, 4.433834>, <0.521713, 0.020480, 4.392380>, <0.466147, -0.001871, 4.329449>, <0.439233, -0.016389, 4.284568>, 
      <0.488183, -0.032896, 4.371059>, <0.453401, -0.037502, 4.329605>, <0.410287, -0.059947, 4.274312>, <0.383374, -0.074465, 4.229430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.813063, 0.284432, 4.820492>, <0.764956, 0.292896, 4.759078>, <0.699045, 0.286870, 4.675170>, <0.656773, 0.270000, 4.611247>, 
      <0.787502, 0.249902, 4.747910>, <0.739395, 0.258367, 4.686496>, <0.670220, 0.249107, 4.613882>, <0.627948, 0.232237, 4.549960>, 
      <0.748216, 0.198679, 4.653673>, <0.699766, 0.196600, 4.605869>, <0.628452, 0.181599, 4.534139>, <0.589715, 0.162646, 4.481440>, 
      <0.705330, 0.156790, 4.594345>, <0.656880, 0.154711, 4.546542>, <0.592050, 0.135735, 4.483302>, <0.553313, 0.116782, 4.430603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.944285, 0.479591, 5.272874>, <0.923319, 0.513447, 5.233925>, <0.896896, 0.542604, 5.160819>, <0.873240, 0.535913, 5.110834>, 
      <0.924139, 0.430314, 5.129480>, <0.903173, 0.464171, 5.090530>, <0.852692, 0.460128, 5.004974>, <0.829036, 0.453437, 4.954989>, 
      <0.859418, 0.347052, 4.952120>, <0.811311, 0.355516, 4.890706>, <0.766617, 0.375394, 4.818842>, <0.724345, 0.358525, 4.754918>, 
      <0.813063, 0.284432, 4.820492>, <0.764956, 0.292896, 4.759078>, <0.699045, 0.286870, 4.675170>, <0.656773, 0.270000, 4.611247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.922387, 0.551838, 5.598643>, <0.911283, 0.610753, 5.565155>, <0.911553, 0.687954, 5.493512>, <0.889146, 0.703564, 5.430505>, 
      <0.942172, 0.534696, 5.501798>, <0.931068, 0.593611, 5.468310>, <0.938857, 0.637531, 5.401526>, <0.916450, 0.653141, 5.338519>, 
      <0.957498, 0.511910, 5.366922>, <0.936532, 0.545766, 5.327973>, <0.923254, 0.591784, 5.253749>, <0.899598, 0.585093, 5.203764>, 
      <0.944285, 0.479591, 5.272874>, <0.923319, 0.513447, 5.233925>, <0.896896, 0.542604, 5.160819>, <0.873240, 0.535913, 5.110834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.794787, 0.609113, 6.004634>, <0.767133, 0.703867, 5.929241>, <0.728514, 0.816821, 5.795860>, <0.705011, 0.846582, 5.677585>, 
      <0.850593, 0.600377, 5.888856>, <0.822939, 0.695131, 5.813463>, <0.795676, 0.772772, 5.733126>, <0.772173, 0.802532, 5.614850>, 
      <0.896980, 0.573850, 5.723002>, <0.885877, 0.632764, 5.689514>, <0.885881, 0.735363, 5.580000>, <0.863474, 0.750973, 5.516992>, 
      <0.922387, 0.551838, 5.598643>, <0.911283, 0.610753, 5.565155>, <0.911553, 0.687954, 5.493512>, <0.889146, 0.703564, 5.430505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.588084, 0.604172, 6.292211>, <0.609605, 0.477040, 6.381073>, <0.628402, 0.257918, 6.420488>, <0.621713, 0.101735, 6.429667>, 
      <0.481434, 0.603309, 6.362606>, <0.502955, 0.476177, 6.451468>, <0.512218, 0.205694, 6.492701>, <0.505529, 0.049511, 6.501881>, 
      <0.306824, 0.604132, 6.411065>, <0.306855, 0.432290, 6.515591>, <0.325470, 0.154336, 6.567108>, <0.325471, -0.046742, 6.571900>, 
      <0.179034, 0.604132, 6.411065>, <0.179064, 0.432290, 6.515591>, <0.179043, 0.154336, 6.567108>, <0.179044, -0.046742, 6.571900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.588084, 0.604172, 6.292211>, <0.481434, 0.603309, 6.362606>, <0.306824, 0.604132, 6.411065>, <0.179034, 0.604132, 6.411065>, 
      <0.562812, 0.753461, 6.187862>, <0.456163, 0.752598, 6.258257>, <0.306793, 0.777822, 6.305415>, <0.179003, 0.777822, 6.305415>, 
      <0.491610, 0.928273, 5.995225>, <0.409581, 0.960410, 6.030388>, <0.273736, 0.992625, 6.097348>, <0.178878, 0.992625, 6.097348>, 
      <0.473710, 0.976036, 5.818554>, <0.391681, 1.008173, 5.853717>, <0.273707, 1.052721, 5.903135>, <0.178849, 1.052721, 5.903135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.588084, 0.604172, 6.292211>, <0.562812, 0.753461, 6.187862>, <0.491610, 0.928273, 5.995225>, <0.473710, 0.976036, 5.818554>, 
      <0.676763, 0.604889, 6.233678>, <0.651491, 0.754178, 6.129329>, <0.569495, 0.897759, 5.961838>, <0.551595, 0.945523, 5.785167>, 
      <0.748757, 0.616319, 6.100132>, <0.721103, 0.711073, 6.024739>, <0.669161, 0.855749, 5.851301>, <0.645658, 0.885510, 5.733026>, 
      <0.794787, 0.609113, 6.004634>, <0.767133, 0.703867, 5.929241>, <0.728514, 0.816821, 5.795860>, <0.705011, 0.846582, 5.677585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.396453, -0.180311, 4.332366>, <0.373420, -0.172802, 4.308329>, <0.344902, -0.164861, 4.272714>, <0.325105, -0.165939, 4.244936>, 
      <0.334967, -0.218600, 4.294816>, <0.311933, -0.211090, 4.270780>, <0.302036, -0.200668, 4.243531>, <0.282240, -0.201745, 4.215753>, 
      <0.260614, -0.300486, 4.221708>, <0.260614, -0.299081, 4.203211>, <0.242054, -0.293247, 4.179016>, <0.242055, -0.291134, 4.160587>, 
      <0.179026, -0.300486, 4.221708>, <0.179026, -0.299081, 4.203211>, <0.179037, -0.293247, 4.179016>, <0.179037, -0.291134, 4.160587>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.584822, -0.047790, 4.469526>, <0.556772, -0.031226, 4.443605>, <0.514845, -0.029365, 4.402836>, <0.488183, -0.032896, 4.371059>, 
      <0.531396, -0.087046, 4.424009>, <0.503346, -0.070482, 4.398088>, <0.468884, -0.068377, 4.360600>, <0.442222, -0.071907, 4.328823>, 
      <0.457058, -0.142571, 4.369378>, <0.434025, -0.135062, 4.345341>, <0.394971, -0.123037, 4.306802>, <0.375174, -0.124115, 4.279024>, 
      <0.396453, -0.180311, 4.332366>, <0.373420, -0.172802, 4.308329>, <0.344902, -0.164861, 4.272714>, <0.325105, -0.165939, 4.244936>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.816137, 0.128060, 4.689919>, <0.787052, 0.150478, 4.664368>, <0.737161, 0.158156, 4.625751>, <0.705330, 0.156790, 4.594345>, 
      <0.759226, 0.081743, 4.608764>, <0.730140, 0.104161, 4.583213>, <0.681532, 0.103820, 4.548795>, <0.649701, 0.102454, 4.517389>, 
      <0.657508, 0.005617, 4.531451>, <0.629457, 0.022182, 4.505530>, <0.583157, 0.028616, 4.465611>, <0.556495, 0.025086, 4.433834>, 
      <0.584822, -0.047790, 4.469526>, <0.556772, -0.031226, 4.443605>, <0.514845, -0.029365, 4.402836>, <0.488183, -0.032896, 4.371059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.918679, 0.223919, 4.945603>, <0.888201, 0.253650, 4.915117>, <0.845167, 0.278784, 4.861476>, <0.813063, 0.284432, 4.820492>, 
      <0.896052, 0.198952, 4.864846>, <0.865575, 0.228683, 4.834360>, <0.819606, 0.244254, 4.788895>, <0.787502, 0.249902, 4.747910>, 
      <0.861654, 0.165104, 4.754826>, <0.832569, 0.187523, 4.729275>, <0.780047, 0.200045, 4.685079>, <0.748216, 0.198679, 4.653673>, 
      <0.816137, 0.128060, 4.689919>, <0.787052, 0.150478, 4.664368>, <0.737161, 0.158156, 4.625751>, <0.705330, 0.156790, 4.594345>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.000102, 0.331056, 5.346507>, <0.988366, 0.381066, 5.335769>, <0.964037, 0.447695, 5.309568>, <0.944285, 0.479591, 5.272874>, 
      <0.992464, 0.313948, 5.221033>, <0.980727, 0.363957, 5.210295>, <0.943892, 0.398418, 5.166174>, <0.924139, 0.430314, 5.129480>, 
      <0.951484, 0.260117, 5.062686>, <0.921006, 0.289849, 5.032200>, <0.891521, 0.341404, 4.993104>, <0.859418, 0.347052, 4.952120>, 
      <0.918679, 0.223919, 4.945603>, <0.888201, 0.253650, 4.915117>, <0.845167, 0.278784, 4.861476>, <0.813063, 0.284432, 4.820492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.961479, 0.319778, 5.648652>, <0.952677, 0.391374, 5.646237>, <0.934057, 0.489916, 5.633840>, <0.922387, 0.551838, 5.598643>, 
      <0.975736, 0.327178, 5.558630>, <0.966934, 0.398774, 5.556215>, <0.953843, 0.472775, 5.536995>, <0.942172, 0.534696, 5.501798>, 
      <1.005608, 0.343387, 5.436948>, <0.993872, 0.393397, 5.426210>, <0.977251, 0.480014, 5.403617>, <0.957498, 0.511910, 5.366922>, 
      <1.000102, 0.331056, 5.346507>, <0.988366, 0.381066, 5.335769>, <0.964037, 0.447695, 5.309568>, <0.944285, 0.479591, 5.272874>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.874494, 0.265862, 6.139644>, <0.826001, 0.234742, 6.251114>, <0.721277, 0.146489, 6.367784>, <0.621713, 0.101735, 6.429667>, 
      <0.870148, 0.378298, 6.127179>, <0.821656, 0.347178, 6.238648>, <0.727965, 0.302672, 6.358604>, <0.628402, 0.257918, 6.420488>, 
      <0.819993, 0.522748, 6.073351>, <0.773962, 0.529954, 6.168850>, <0.698284, 0.477757, 6.322540>, <0.609605, 0.477040, 6.381073>, 
      <0.794787, 0.609113, 6.004634>, <0.748757, 0.616319, 6.100132>, <0.676763, 0.604889, 6.233678>, <0.588084, 0.604172, 6.292211>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.874494, 0.265862, 6.139644>, <0.870148, 0.378298, 6.127179>, <0.819993, 0.522748, 6.073351>, <0.794787, 0.609113, 6.004634>, 
      <0.932641, 0.303178, 6.005982>, <0.928296, 0.415614, 5.993516>, <0.875798, 0.514012, 5.957573>, <0.850593, 0.600377, 5.888856>, 
      <0.938021, 0.307603, 5.796776>, <0.929219, 0.379199, 5.794361>, <0.908651, 0.511928, 5.758199>, <0.896980, 0.573850, 5.723002>, 
      <0.961479, 0.319778, 5.648652>, <0.952677, 0.391374, 5.646237>, <0.934057, 0.489916, 5.633840>, <0.922387, 0.551838, 5.598643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.471033, -0.213514, 4.397223>, <0.459303, -0.191479, 4.378374>, <0.417564, -0.187194, 4.354397>, <0.396453, -0.180311, 4.332366>, 
      <0.388363, -0.245230, 4.356316>, <0.376633, -0.223195, 4.337467>, <0.356077, -0.225482, 4.316847>, <0.334967, -0.218600, 4.294816>, 
      <0.276573, -0.300486, 4.283735>, <0.276568, -0.295590, 4.265782>, <0.260614, -0.301895, 4.240262>, <0.260614, -0.300486, 4.221708>, 
      <0.179035, -0.300486, 4.283735>, <0.179030, -0.295590, 4.265782>, <0.179026, -0.301895, 4.240262>, <0.179026, -0.300486, 4.221708>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.975465, 0.126006, 4.982941>, <0.968684, 0.160977, 4.979850>, <0.939489, 0.203618, 4.966419>, <0.918679, 0.223919, 4.945603>, 
      <0.953292, 0.110949, 4.899334>, <0.946511, 0.145920, 4.896243>, <0.916863, 0.178651, 4.885662>, <0.896052, 0.198952, 4.864846>, 
      <0.905523, 0.073273, 4.794906>, <0.906055, 0.105283, 4.794318>, <0.882472, 0.149059, 4.773114>, <0.861654, 0.165104, 4.754826>, 
      <0.858834, 0.038472, 4.729197>, <0.859366, 0.070482, 4.728609>, <0.836954, 0.112015, 4.708207>, <0.816137, 0.128060, 4.689919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.021831, 0.149162, 5.343822>, <1.023205, 0.203596, 5.351297>, <1.012394, 0.278680, 5.357753>, <1.000102, 0.331056, 5.346507>, 
      <1.021024, 0.156744, 5.234713>, <1.022398, 0.211178, 5.242188>, <1.004755, 0.261572, 5.232279>, <0.992464, 0.313948, 5.221033>, 
      <1.003086, 0.144763, 5.087095>, <0.996305, 0.179735, 5.084004>, <0.972294, 0.239816, 5.083502>, <0.951484, 0.260117, 5.062686>, 
      <0.975465, 0.126006, 4.982941>, <0.968684, 0.160977, 4.979850>, <0.939489, 0.203618, 4.966419>, <0.918679, 0.223919, 4.945603>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.980134, 0.082119, 5.614484>, <0.981444, 0.152044, 5.632608>, <0.970290, 0.248110, 5.651069>, <0.961479, 0.319778, 5.648652>, 
      <1.000090, 0.114234, 5.538823>, <1.001400, 0.184160, 5.556947>, <0.984546, 0.255510, 5.561047>, <0.975736, 0.327178, 5.558630>, 
      <1.022455, 0.143299, 5.428199>, <1.023829, 0.197733, 5.435674>, <1.017900, 0.291011, 5.448194>, <1.005608, 0.343387, 5.436948>, 
      <1.021831, 0.149162, 5.343822>, <1.023205, 0.203596, 5.351297>, <1.012394, 0.278680, 5.357753>, <1.000102, 0.331056, 5.346507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.824817, -0.167894, 6.090778>, <0.852321, -0.045452, 6.131045>, <0.879553, 0.134966, 6.154156>, <0.874494, 0.265862, 6.139644>, 
      <0.899863, -0.087774, 5.963646>, <0.927368, 0.034668, 6.003914>, <0.937700, 0.172282, 6.020494>, <0.932641, 0.303178, 6.005982>, 
      <0.940504, 0.018342, 5.764736>, <0.941814, 0.088268, 5.782860>, <0.946832, 0.235935, 5.799193>, <0.938021, 0.307603, 5.796776>, 
      <0.980134, 0.082119, 5.614484>, <0.981444, 0.152044, 5.632608>, <0.970290, 0.248110, 5.651069>, <0.961479, 0.319778, 5.648652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.545872, -0.381506, 6.350145>, <0.483290, -0.415886, 6.389599>, <0.372454, -0.437182, 6.406133>, <0.295828, -0.458500, 6.424273>, 
      <0.568896, -0.251950, 6.419346>, <0.506314, -0.286330, 6.458800>, <0.350943, -0.329435, 6.485982>, <0.274317, -0.350754, 6.504122>, 
      <0.615363, -0.046547, 6.438382>, <0.499179, -0.098771, 6.510596>, <0.360506, -0.170269, 6.527612>, <0.214079, -0.170269, 6.527612>, 
      <0.621713, 0.101735, 6.429667>, <0.505529, 0.049511, 6.501881>, <0.325471, -0.046742, 6.571900>, <0.179044, -0.046742, 6.571900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.545872, -0.381506, 6.350145>, <0.568896, -0.251950, 6.419346>, <0.615363, -0.046547, 6.438382>, <0.621713, 0.101735, 6.429667>, 
      <0.646375, -0.326293, 6.286784>, <0.669400, -0.196737, 6.355985>, <0.714927, -0.001793, 6.376499>, <0.721277, 0.146489, 6.367784>, 
      <0.766283, -0.230386, 6.189937>, <0.793788, -0.107944, 6.230204>, <0.831060, 0.103846, 6.265626>, <0.826001, 0.234742, 6.251114>, 
      <0.824817, -0.167894, 6.090778>, <0.852321, -0.045452, 6.131045>, <0.879553, 0.134966, 6.154156>, <0.874494, 0.265862, 6.139644>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.457426, -0.294848, 4.430342>, <0.459668, -0.269595, 4.422097>, <0.481031, -0.232295, 4.413288>, <0.471033, -0.213514, 4.397223>, 
      <0.377658, -0.314786, 4.398756>, <0.379901, -0.289532, 4.390511>, <0.398361, -0.264010, 4.372381>, <0.388363, -0.245230, 4.356316>, 
      <0.267138, -0.334319, 4.345761>, <0.267141, -0.315010, 4.337018>, <0.276578, -0.306063, 4.304184>, <0.276573, -0.300486, 4.283735>, 
      <0.179058, -0.334319, 4.345761>, <0.179061, -0.315010, 4.337018>, <0.179040, -0.306063, 4.304184>, <0.179035, -0.300486, 4.283735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.641121, -0.123209, 4.512387>, <0.595266, -0.153005, 4.473133>, <0.528087, -0.191626, 4.425455>, <0.471033, -0.213514, 4.397223>, 
      <0.651281, -0.148329, 4.521924>, <0.605426, -0.178125, 4.482671>, <0.538085, -0.210406, 4.441520>, <0.481031, -0.232295, 4.413288>, 
      <0.653828, -0.187895, 4.527059>, <0.599681, -0.207255, 4.486497>, <0.523398, -0.253666, 4.447332>, <0.459668, -0.269595, 4.422097>, 
      <0.652818, -0.215905, 4.533356>, <0.598671, -0.235264, 4.492794>, <0.521155, -0.278919, 4.455577>, <0.457426, -0.294848, 4.430342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.641121, -0.123209, 4.512387>, <0.630148, -0.096079, 4.502086>, <0.605726, -0.060134, 4.488843>, <0.584822, -0.047790, 4.469526>, 
      <0.595266, -0.153005, 4.473133>, <0.584293, -0.125875, 4.462832>, <0.552300, -0.099390, 4.443326>, <0.531396, -0.087046, 4.424009>, 
      <0.528087, -0.191626, 4.425455>, <0.516357, -0.169591, 4.406606>, <0.478169, -0.149453, 4.391408>, <0.457058, -0.142571, 4.369378>, 
      <0.471033, -0.213514, 4.397223>, <0.459303, -0.191479, 4.378374>, <0.417564, -0.187194, 4.354397>, <0.396453, -0.180311, 4.332366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.641121, -0.123209, 4.512387>, <0.712074, -0.077105, 4.573126>, <0.803446, -0.002814, 4.651243>, <0.858834, 0.038472, 4.729197>, 
      <0.630148, -0.096079, 4.502086>, <0.701101, -0.049975, 4.562825>, <0.803978, 0.029196, 4.650655>, <0.859366, 0.070482, 4.728609>, 
      <0.605726, -0.060134, 4.488843>, <0.678412, -0.006727, 4.550768>, <0.780043, 0.065697, 4.627052>, <0.836954, 0.112015, 4.708207>, 
      <0.584822, -0.047790, 4.469526>, <0.657508, 0.005617, 4.531451>, <0.759226, 0.081743, 4.608764>, <0.816137, 0.128060, 4.689919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.811209, -0.168359, 4.695364>, <0.830642, -0.107423, 4.703516>, <0.857762, -0.025985, 4.730381>, <0.858834, 0.038472, 4.729197>, 
      <0.771287, -0.185794, 4.641274>, <0.790720, -0.124858, 4.649426>, <0.802374, -0.067271, 4.652427>, <0.803446, -0.002814, 4.651243>, 
      <0.706258, -0.196798, 4.573389>, <0.707268, -0.168789, 4.567092>, <0.722234, -0.102225, 4.582664>, <0.712074, -0.077105, 4.573126>, 
      <0.652818, -0.215905, 4.533356>, <0.653828, -0.187895, 4.527059>, <0.651281, -0.148329, 4.521924>, <0.641121, -0.123209, 4.512387>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.976553, -0.074527, 4.971982>, <0.989851, -0.016128, 4.978531>, <0.986892, 0.067079, 4.988150>, <0.975465, 0.126006, 4.982941>, 
      <0.947445, -0.077481, 4.875631>, <0.960743, -0.019082, 4.882180>, <0.964719, 0.052021, 4.904542>, <0.953292, 0.110949, 4.899334>, 
      <0.869091, -0.143082, 4.773788>, <0.888524, -0.082146, 4.781940>, <0.904451, 0.008816, 4.796090>, <0.905523, 0.073273, 4.794906>, 
      <0.811209, -0.168359, 4.695364>, <0.830642, -0.107423, 4.703516>, <0.857762, -0.025985, 4.730381>, <0.858834, 0.038472, 4.729197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.987950, -0.150422, 5.280388>, <1.005106, -0.062576, 5.303447>, <1.019521, 0.057622, 5.331251>, <1.021831, 0.149162, 5.343822>, 
      <0.992343, -0.120911, 5.189833>, <1.009499, -0.033064, 5.212892>, <1.018714, 0.065204, 5.222142>, <1.021024, 0.156744, 5.234713>, 
      <1.004114, -0.071730, 5.063212>, <1.017413, -0.013331, 5.069761>, <1.014514, 0.085836, 5.092304>, <1.003086, 0.144763, 5.087095>, 
      <0.976553, -0.074527, 4.971982>, <0.989851, -0.016128, 4.978531>, <0.986892, 0.067079, 4.988150>, <0.975465, 0.126006, 4.982941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.950857, -0.247161, 5.501707>, <0.974898, -0.151031, 5.535782>, <0.978234, -0.019299, 5.588197>, <0.980134, 0.082119, 5.614484>, 
      <0.977942, -0.217189, 5.440531>, <1.001983, -0.121059, 5.474606>, <0.998190, 0.012817, 5.512536>, <1.000090, 0.114234, 5.538823>, 
      <0.984572, -0.173114, 5.350016>, <1.001728, -0.085267, 5.373076>, <1.020145, 0.051758, 5.415628>, <1.022455, 0.143299, 5.428199>, 
      <0.987950, -0.150422, 5.280388>, <1.005106, -0.062576, 5.303447>, <1.019521, 0.057622, 5.331251>, <1.021831, 0.149162, 5.343822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.712516, -0.455216, 5.902503>, <0.740935, -0.379862, 5.975093>, <0.802190, -0.268621, 6.057652>, <0.824817, -0.167894, 6.090778>, 
      <0.800079, -0.381525, 5.800679>, <0.828498, -0.306171, 5.873269>, <0.877237, -0.188500, 5.930520>, <0.899863, -0.087774, 5.963646>, 
      <0.894262, -0.309789, 5.629537>, <0.918303, -0.213659, 5.663612>, <0.938604, -0.083075, 5.738450>, <0.940504, 0.018342, 5.764736>, 
      <0.950857, -0.247161, 5.501707>, <0.974898, -0.151031, 5.535782>, <0.978234, -0.019299, 5.588197>, <0.980134, 0.082119, 5.614484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.490921, -0.634233, 6.036554>, <0.479988, -0.666557, 5.980422>, <0.458730, -0.675891, 5.891822>, <0.444184, -0.682147, 5.828069>, 
      <0.443732, -0.666319, 6.056262>, <0.432798, -0.698643, 6.000130>, <0.409394, -0.699492, 5.905723>, <0.394847, -0.705749, 5.841970>, 
      <0.369668, -0.701542, 6.063558>, <0.366795, -0.733965, 5.998106>, <0.332956, -0.726877, 5.889080>, <0.320206, -0.731100, 5.817224>, 
      <0.314608, -0.725768, 6.068684>, <0.311735, -0.758192, 6.003231>, <0.282526, -0.748327, 5.902534>, <0.269775, -0.752550, 5.830678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.490921, -0.634233, 6.036554>, <0.443732, -0.666319, 6.056262>, <0.369668, -0.701542, 6.063558>, <0.314608, -0.725768, 6.068684>, 
      <0.511217, -0.574228, 6.140756>, <0.464028, -0.606313, 6.160464>, <0.374917, -0.642297, 6.183154>, <0.319857, -0.666524, 6.188280>, 
      <0.526987, -0.487771, 6.293384>, <0.464406, -0.522151, 6.332838>, <0.393608, -0.543140, 6.327610>, <0.316982, -0.564458, 6.345749>, 
      <0.545872, -0.381506, 6.350145>, <0.483290, -0.415886, 6.389599>, <0.372454, -0.437182, 6.406133>, <0.295828, -0.458500, 6.424273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.490921, -0.634233, 6.036554>, <0.511217, -0.574228, 6.140756>, <0.526987, -0.487771, 6.293384>, <0.545872, -0.381506, 6.350145>, 
      <0.564748, -0.584035, 6.005721>, <0.585044, -0.524030, 6.109923>, <0.627491, -0.432558, 6.230023>, <0.646375, -0.326293, 6.286784>, 
      <0.658527, -0.500652, 5.965285>, <0.686946, -0.425298, 6.037875>, <0.743657, -0.331112, 6.156811>, <0.766283, -0.230386, 6.189937>, 
      <0.712516, -0.455216, 5.902503>, <0.740935, -0.379862, 5.975093>, <0.802190, -0.268621, 6.057652>, <0.824817, -0.167894, 6.090778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.457425, -0.366759, 4.447258>, <0.376347, -0.393548, 4.412038>, <0.271379, -0.462381, 4.357038>, <0.179012, -0.462381, 4.357038>, 
      <0.456417, -0.383823, 4.449757>, <0.375339, -0.410612, 4.414537>, <0.271377, -0.477972, 4.358208>, <0.179009, -0.477972, 4.358208>, 
      <0.453290, -0.406927, 4.447981>, <0.375210, -0.433554, 4.412466>, <0.268845, -0.499042, 4.356613>, <0.179030, -0.499042, 4.356613>, 
      <0.449809, -0.423802, 4.449226>, <0.371729, -0.450429, 4.413710>, <0.268844, -0.514449, 4.359272>, <0.179029, -0.514449, 4.359272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.457425, -0.366759, 4.447258>, <0.458718, -0.344868, 4.444052>, <0.455562, -0.315841, 4.437197>, <0.457426, -0.294848, 4.430342>, 
      <0.376347, -0.393548, 4.412038>, <0.377640, -0.371657, 4.408832>, <0.375794, -0.335778, 4.405611>, <0.377658, -0.314786, 4.398756>, 
      <0.271379, -0.462381, 4.357038>, <0.271386, -0.423922, 4.354153>, <0.267133, -0.369453, 4.361668>, <0.267138, -0.334319, 4.345761>, 
      <0.179012, -0.462381, 4.357038>, <0.179018, -0.423922, 4.354153>, <0.179053, -0.369453, 4.361668>, <0.179058, -0.334319, 4.345761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.634317, -0.311942, 4.554818>, <0.585448, -0.327047, 4.515940>, <0.513821, -0.348125, 4.471756>, <0.457425, -0.366759, 4.447258>, 
      <0.632150, -0.326299, 4.557950>, <0.583281, -0.341405, 4.519072>, <0.512813, -0.365189, 4.474255>, <0.456417, -0.383823, 4.449757>, 
      <0.634314, -0.346117, 4.561991>, <0.583798, -0.365313, 4.521975>, <0.511746, -0.386993, 4.474570>, <0.453290, -0.406927, 4.447981>, 
      <0.631018, -0.360313, 4.564863>, <0.580502, -0.379509, 4.524848>, <0.508266, -0.403867, 4.475815>, <0.449809, -0.423802, 4.449226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.634317, -0.311942, 4.554818>, <0.638700, -0.282907, 4.548483>, <0.651762, -0.245194, 4.539941>, <0.652818, -0.215905, 4.533356>, 
      <0.585448, -0.327047, 4.515940>, <0.589831, -0.298013, 4.509606>, <0.597615, -0.264554, 4.499379>, <0.598671, -0.235264, 4.492794>, 
      <0.513821, -0.348125, 4.471756>, <0.515114, -0.326234, 4.468550>, <0.519291, -0.299912, 4.462432>, <0.521155, -0.278919, 4.455577>, 
      <0.457425, -0.366759, 4.447258>, <0.458718, -0.344868, 4.444052>, <0.455562, -0.315841, 4.437197>, <0.457426, -0.294848, 4.430342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.759363, -0.273430, 4.687467>, <0.728715, -0.283427, 4.641804>, <0.676833, -0.298800, 4.588642>, <0.634317, -0.311942, 4.554818>, 
      <0.754987, -0.283635, 4.686904>, <0.724338, -0.293632, 4.641241>, <0.674666, -0.313157, 4.591774>, <0.632150, -0.326299, 4.557950>, 
      <0.755263, -0.299348, 4.686892>, <0.728305, -0.308589, 4.641450>, <0.674610, -0.330805, 4.593911>, <0.634314, -0.346117, 4.561991>, 
      <0.750701, -0.309464, 4.687576>, <0.723743, -0.318705, 4.642134>, <0.671314, -0.345001, 4.596783>, <0.631018, -0.360313, 4.564863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.759363, -0.273430, 4.687467>, <0.773230, -0.241093, 4.689252>, <0.800591, -0.201654, 4.690909>, <0.811209, -0.168359, 4.695364>, 
      <0.728715, -0.283427, 4.641804>, <0.742581, -0.251090, 4.643589>, <0.760668, -0.219088, 4.636819>, <0.771287, -0.185794, 4.641274>, 
      <0.676833, -0.298800, 4.588642>, <0.681216, -0.269766, 4.582307>, <0.705202, -0.226088, 4.579974>, <0.706258, -0.196798, 4.573389>, 
      <0.634317, -0.311942, 4.554818>, <0.638700, -0.282907, 4.548483>, <0.651762, -0.245194, 4.539941>, <0.652818, -0.215905, 4.533356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.895108, -0.226877, 4.943369>, <0.867665, -0.225555, 4.859749>, <0.807624, -0.257688, 4.759371>, <0.759363, -0.273430, 4.687467>, 
      <0.881475, -0.248285, 4.937924>, <0.854033, -0.246963, 4.854304>, <0.803248, -0.267893, 4.758808>, <0.754987, -0.283635, 4.686904>, 
      <0.856068, -0.269370, 4.924865>, <0.838864, -0.261928, 4.852971>, <0.792604, -0.286548, 4.749836>, <0.755263, -0.299348, 4.686892>, 
      <0.840239, -0.288594, 4.917537>, <0.823035, -0.281153, 4.845643>, <0.788042, -0.296664, 4.750520>, <0.750701, -0.309464, 4.687576>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.895108, -0.226877, 4.943369>, <0.922697, -0.183552, 4.954388>, <0.964958, -0.125444, 4.966272>, <0.976553, -0.074527, 4.971982>, 
      <0.867665, -0.225555, 4.859749>, <0.895254, -0.182230, 4.870768>, <0.935850, -0.128399, 4.869922>, <0.947445, -0.077481, 4.875631>, 
      <0.807624, -0.257688, 4.759371>, <0.821491, -0.225351, 4.761156>, <0.858472, -0.176376, 4.769333>, <0.869091, -0.143082, 4.773788>, 
      <0.759363, -0.273430, 4.687467>, <0.773230, -0.241093, 4.689252>, <0.800591, -0.201654, 4.690909>, <0.811209, -0.168359, 4.695364>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.937624, -0.282019, 5.230641>, <0.942176, -0.258647, 5.145221>, <0.922756, -0.228209, 5.027615>, <0.895108, -0.226877, 4.943369>, 
      <0.922458, -0.309383, 5.218944>, <0.927010, -0.286010, 5.133524>, <0.909124, -0.249618, 5.022170>, <0.881475, -0.248285, 4.937924>, 
      <0.892415, -0.338969, 5.202368>, <0.897835, -0.314385, 5.121010>, <0.875788, -0.277899, 5.007274>, <0.856068, -0.269370, 4.924865>, 
      <0.870971, -0.361485, 5.190171>, <0.876391, -0.336901, 5.108813>, <0.859959, -0.297124, 4.999946>, <0.840239, -0.288594, 4.917537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.937624, -0.282019, 5.230641>, <0.957978, -0.245296, 5.246338>, <0.979630, -0.193025, 5.269205>, <0.987950, -0.150422, 5.280388>, 
      <0.942176, -0.258647, 5.145221>, <0.962529, -0.221923, 5.160918>, <0.984023, -0.163514, 5.178650>, <0.992343, -0.120911, 5.189833>, 
      <0.922756, -0.228209, 5.027615>, <0.950345, -0.184884, 5.038634>, <0.992520, -0.122647, 5.057502>, <1.004114, -0.071730, 5.063212>, 
      <0.895108, -0.226877, 4.943369>, <0.922697, -0.183552, 4.954388>, <0.964958, -0.125444, 4.966272>, <0.976553, -0.074527, 4.971982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.867829, -0.366949, 5.455302>, <0.899500, -0.333375, 5.396142>, <0.933773, -0.301795, 5.302919>, <0.937624, -0.282019, 5.230641>, 
      <0.850513, -0.390091, 5.445083>, <0.882184, -0.356517, 5.385923>, <0.918607, -0.329159, 5.291223>, <0.922458, -0.309383, 5.218944>, 
      <0.826135, -0.419813, 5.430473>, <0.856227, -0.389453, 5.369558>, <0.887679, -0.360451, 5.273460>, <0.892415, -0.338969, 5.202368>, 
      <0.806977, -0.439453, 5.416795>, <0.837070, -0.409093, 5.355880>, <0.866235, -0.382967, 5.261262>, <0.870971, -0.361485, 5.190171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.867829, -0.366949, 5.455302>, <0.893748, -0.332309, 5.470598>, <0.940329, -0.289258, 5.486785>, <0.950857, -0.247161, 5.501707>, 
      <0.899500, -0.333375, 5.396142>, <0.925419, -0.298735, 5.411438>, <0.967414, -0.259286, 5.425609>, <0.977942, -0.217189, 5.440531>, 
      <0.933773, -0.301795, 5.302919>, <0.954126, -0.265072, 5.318616>, <0.976252, -0.215716, 5.338834>, <0.984572, -0.173114, 5.350016>, 
      <0.937624, -0.282019, 5.230641>, <0.957978, -0.245296, 5.246338>, <0.979630, -0.193025, 5.269205>, <0.987950, -0.150422, 5.280388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428366, -0.507638, 4.457652>, <0.435357, -0.484941, 4.446867>, <0.444553, -0.449281, 4.451106>, <0.449809, -0.423802, 4.449226>, 
      <0.487960, -0.486493, 4.485593>, <0.494951, -0.463796, 4.474808>, <0.503010, -0.429346, 4.477695>, <0.508266, -0.403867, 4.475815>, 
      <0.557478, -0.450222, 4.536428>, <0.568185, -0.432221, 4.531043>, <0.575704, -0.400177, 4.529029>, <0.580502, -0.379509, 4.524848>, 
      <0.607565, -0.427174, 4.578134>, <0.618272, -0.409173, 4.572749>, <0.626220, -0.380981, 4.569045>, <0.631018, -0.360313, 4.564863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.428366, -0.507638, 4.457652>, <0.358122, -0.532562, 4.424718>, <0.260492, -0.579237, 4.377204>, <0.179005, -0.579237, 4.377204>, 
      <0.435357, -0.484941, 4.446867>, <0.365112, -0.509865, 4.413933>, <0.260496, -0.564353, 4.363596>, <0.179009, -0.564353, 4.363596>, 
      <0.444553, -0.449281, 4.451106>, <0.366474, -0.475907, 4.415590>, <0.268843, -0.534322, 4.362702>, <0.179028, -0.534322, 4.362702>, 
      <0.449809, -0.423802, 4.449226>, <0.371729, -0.450429, 4.413710>, <0.268844, -0.514449, 4.359272>, <0.179029, -0.514449, 4.359272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.712760, -0.376771, 4.694456>, <0.688267, -0.387056, 4.652783>, <0.643370, -0.410698, 4.607948>, <0.607565, -0.427174, 4.578134>, 
      <0.726666, -0.358688, 4.689856>, <0.702173, -0.368973, 4.648183>, <0.654077, -0.392696, 4.602562>, <0.618272, -0.409173, 4.572749>, 
      <0.741153, -0.330637, 4.689008>, <0.714194, -0.339878, 4.643566>, <0.666516, -0.365669, 4.600965>, <0.626220, -0.380981, 4.569045>, 
      <0.750701, -0.309464, 4.687576>, <0.723743, -0.318705, 4.642134>, <0.671314, -0.345001, 4.596783>, <0.631018, -0.360313, 4.564863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.794991, -0.348471, 4.897021>, <0.781814, -0.342558, 4.832484>, <0.745537, -0.363008, 4.750222>, <0.712760, -0.376771, 4.694456>, 
      <0.809323, -0.330840, 4.902366>, <0.796146, -0.324927, 4.837829>, <0.759443, -0.344925, 4.745623>, <0.726666, -0.358688, 4.689856>, 
      <0.826006, -0.305881, 4.910948>, <0.808802, -0.298439, 4.839054>, <0.778494, -0.317837, 4.751952>, <0.741153, -0.330637, 4.689008>, 
      <0.840239, -0.288594, 4.917537>, <0.823035, -0.281153, 4.845643>, <0.788042, -0.296664, 4.750520>, <0.750701, -0.309464, 4.687576>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.807077, -0.419093, 5.156388>, <0.818246, -0.392316, 5.081058>, <0.811075, -0.355688, 4.975797>, <0.794991, -0.348471, 4.897021>, 
      <0.825790, -0.402232, 5.167979>, <0.836959, -0.375455, 5.092649>, <0.825408, -0.338058, 4.981142>, <0.809323, -0.330840, 4.902366>, 
      <0.853169, -0.380177, 5.180045>, <0.858589, -0.355593, 5.098688>, <0.845726, -0.314410, 4.993357>, <0.826006, -0.305881, 4.910948>, 
      <0.870971, -0.361485, 5.190171>, <0.876391, -0.336901, 5.108813>, <0.859959, -0.297124, 4.999946>, <0.840239, -0.288594, 4.917537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.727112, -0.511207, 5.354836>, <0.761081, -0.485560, 5.299412>, <0.797408, -0.442274, 5.221600>, <0.807077, -0.419093, 5.156388>, 
      <0.751771, -0.494120, 5.376812>, <0.785740, -0.468473, 5.321388>, <0.816121, -0.425412, 5.233192>, <0.825790, -0.402232, 5.167979>, 
      <0.783738, -0.463277, 5.400203>, <0.813830, -0.432917, 5.339288>, <0.848433, -0.401658, 5.251137>, <0.853169, -0.380177, 5.180045>, 
      <0.806977, -0.439453, 5.416795>, <0.837070, -0.409093, 5.355880>, <0.866235, -0.382967, 5.261262>, <0.870971, -0.361485, 5.190171>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.573823, -0.595202, 5.536960>, <0.590291, -0.590656, 5.573375>, <0.623003, -0.598816, 5.617618>, <0.642922, -0.591563, 5.651802>, 
      <0.533563, -0.616524, 5.565834>, <0.550031, -0.611977, 5.602249>, <0.565933, -0.636609, 5.644306>, <0.585853, -0.629356, 5.678490>, 
      <0.464927, -0.651702, 5.565077>, <0.467125, -0.651013, 5.572460>, <0.492309, -0.663908, 5.579248>, <0.494590, -0.664417, 5.586620>, 
      <0.417725, -0.675058, 5.576726>, <0.419923, -0.674369, 5.584109>, <0.424405, -0.690787, 5.587260>, <0.426687, -0.691295, 5.594632>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.573823, -0.595202, 5.536960>, <0.630350, -0.565266, 5.496420>, <0.690300, -0.539000, 5.414898>, <0.727112, -0.511207, 5.354836>, 
      <0.590291, -0.590656, 5.573375>, <0.646818, -0.560719, 5.532834>, <0.714959, -0.521914, 5.436873>, <0.751771, -0.494120, 5.376812>, 
      <0.623003, -0.598816, 5.617618>, <0.698616, -0.548742, 5.582259>, <0.744376, -0.502989, 5.479882>, <0.783738, -0.463277, 5.400203>, 
      <0.642922, -0.591563, 5.651802>, <0.718536, -0.541489, 5.616442>, <0.767615, -0.479165, 5.496474>, <0.806977, -0.439453, 5.416795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.677962, -0.557284, 5.715670>, <0.751552, -0.502532, 5.650918>, <0.820438, -0.417188, 5.543825>, <0.867829, -0.366949, 5.455302>, 
      <0.672240, -0.568495, 5.695056>, <0.745830, -0.513743, 5.630303>, <0.803122, -0.440330, 5.533606>, <0.850513, -0.390091, 5.445083>, 
      <0.654883, -0.587208, 5.672328>, <0.730497, -0.537134, 5.636969>, <0.786773, -0.459525, 5.510152>, <0.826135, -0.419813, 5.430473>, 
      <0.642922, -0.591563, 5.651802>, <0.718536, -0.541489, 5.616442>, <0.767615, -0.479165, 5.496474>, <0.806977, -0.439453, 5.416795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.677962, -0.557284, 5.715670>, <0.672240, -0.568495, 5.695056>, <0.654883, -0.587208, 5.672328>, <0.642922, -0.591563, 5.651802>, 
      <0.621356, -0.599400, 5.765478>, <0.615633, -0.610611, 5.744864>, <0.591991, -0.607446, 5.711968>, <0.580030, -0.611801, 5.691441>, 
      <0.519692, -0.646026, 5.806794>, <0.516304, -0.647483, 5.791944>, <0.507291, -0.638186, 5.788656>, <0.504493, -0.630836, 5.775530>, 
      <0.444184, -0.682147, 5.828069>, <0.440796, -0.683604, 5.813218>, <0.436079, -0.666374, 5.797058>, <0.433281, -0.659024, 5.783932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.677962, -0.557284, 5.715670>, <0.621356, -0.599400, 5.765478>, <0.519692, -0.646026, 5.806794>, <0.444184, -0.682147, 5.828069>, 
      <0.693292, -0.527250, 5.770894>, <0.636686, -0.569366, 5.820702>, <0.534239, -0.639769, 5.870547>, <0.458730, -0.675891, 5.891822>, 
      <0.695556, -0.500186, 5.859182>, <0.641567, -0.545622, 5.921965>, <0.553815, -0.616359, 5.949589>, <0.479988, -0.666557, 5.980422>, 
      <0.712516, -0.455216, 5.902503>, <0.658527, -0.500652, 5.965285>, <0.564748, -0.584035, 6.005721>, <0.490921, -0.634233, 6.036554>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.677962, -0.557284, 5.715670>, <0.693292, -0.527250, 5.770894>, <0.695556, -0.500186, 5.859182>, <0.712516, -0.455216, 5.902503>, 
      <0.751552, -0.502532, 5.650918>, <0.766882, -0.472498, 5.706141>, <0.783119, -0.426495, 5.757358>, <0.800079, -0.381525, 5.800679>, 
      <0.820438, -0.417188, 5.543825>, <0.846357, -0.382548, 5.559121>, <0.883734, -0.351886, 5.614615>, <0.894262, -0.309789, 5.629537>, 
      <0.867829, -0.366949, 5.455302>, <0.893748, -0.332309, 5.470598>, <0.940329, -0.289258, 5.486785>, <0.950857, -0.247161, 5.501707>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.403934, -0.572750, 4.520002>, <0.340400, -0.589589, 4.491061>, <0.250819, -0.610969, 4.447523>, <0.179002, -0.610969, 4.447523>, 
      <0.412386, -0.558247, 4.497566>, <0.348851, -0.575086, 4.468624>, <0.250820, -0.605919, 4.424937>, <0.179003, -0.605919, 4.424937>, 
      <0.420856, -0.532021, 4.469238>, <0.350612, -0.556945, 4.436304>, <0.260487, -0.596318, 4.392821>, <0.179000, -0.596318, 4.392821>, 
      <0.428366, -0.507638, 4.457652>, <0.358122, -0.532562, 4.424718>, <0.260492, -0.579237, 4.377204>, <0.179005, -0.579237, 4.377204>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.538621, -0.515657, 4.611336>, <0.502363, -0.533275, 4.578905>, <0.449705, -0.560619, 4.540851>, <0.403934, -0.572750, 4.520002>, 
      <0.557754, -0.490770, 4.595644>, <0.521496, -0.508388, 4.563213>, <0.458156, -0.546116, 4.518415>, <0.412386, -0.558247, 4.497566>, 
      <0.590190, -0.456386, 4.586874>, <0.540103, -0.479434, 4.545168>, <0.480450, -0.510876, 4.497179>, <0.420856, -0.532021, 4.469238>, 
      <0.607565, -0.427174, 4.578134>, <0.557478, -0.450222, 4.536428>, <0.487960, -0.486493, 4.485593>, <0.428366, -0.507638, 4.457652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.634314, -0.460808, 4.726071>, <0.607929, -0.472255, 4.687960>, <0.572081, -0.499399, 4.641265>, <0.538621, -0.515657, 4.611336>, 
      <0.654672, -0.433027, 4.716421>, <0.628287, -0.444473, 4.678310>, <0.591213, -0.474512, 4.625574>, <0.557754, -0.490770, 4.595644>, 
      <0.691385, -0.404566, 4.701526>, <0.666892, -0.414851, 4.659852>, <0.625995, -0.439910, 4.616687>, <0.590190, -0.456386, 4.586874>, 
      <0.712760, -0.376771, 4.694456>, <0.688267, -0.387056, 4.652783>, <0.643370, -0.410698, 4.607948>, <0.607565, -0.427174, 4.578134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.719415, -0.437225, 4.872478>, <0.709926, -0.429986, 4.822593>, <0.662660, -0.448511, 4.767014>, <0.634314, -0.460808, 4.726071>, 
      <0.740667, -0.409119, 4.878447>, <0.731178, -0.401880, 4.828562>, <0.683018, -0.420730, 4.757363>, <0.654672, -0.433027, 4.716421>, 
      <0.773047, -0.375466, 4.888837>, <0.759870, -0.369553, 4.824301>, <0.724162, -0.390802, 4.757292>, <0.691385, -0.404566, 4.701526>, 
      <0.794991, -0.348471, 4.897021>, <0.781814, -0.342558, 4.832484>, <0.745537, -0.363008, 4.750222>, <0.712760, -0.376771, 4.694456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.702776, -0.513039, 5.085985>, <0.721837, -0.489313, 5.025004>, <0.732023, -0.446844, 4.938761>, <0.719415, -0.437225, 4.872478>, 
      <0.733062, -0.487881, 5.111857>, <0.752123, -0.464155, 5.050876>, <0.753275, -0.418738, 4.944730>, <0.740667, -0.409119, 4.878447>, 
      <0.775283, -0.447742, 5.136694>, <0.786452, -0.420965, 5.061363>, <0.789131, -0.382683, 4.967613>, <0.773047, -0.375466, 4.888837>, 
      <0.807077, -0.419093, 5.156388>, <0.818246, -0.392316, 5.081058>, <0.811075, -0.355688, 4.975797>, <0.794991, -0.348471, 4.897021>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.605422, -0.579118, 5.237168>, <0.643609, -0.557768, 5.199899>, <0.686702, -0.533047, 5.137409>, <0.702776, -0.513039, 5.085985>, 
      <0.634314, -0.561103, 5.280001>, <0.672500, -0.539753, 5.242732>, <0.716988, -0.507888, 5.163280>, <0.733062, -0.487881, 5.111857>, 
      <0.690830, -0.536348, 5.322502>, <0.724800, -0.510701, 5.267078>, <0.765614, -0.470922, 5.201906>, <0.775283, -0.447742, 5.136694>, 
      <0.727112, -0.511207, 5.354836>, <0.761081, -0.485560, 5.299412>, <0.797408, -0.442274, 5.221600>, <0.807077, -0.419093, 5.156388>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.483719, -0.635514, 5.299781>, <0.523175, -0.615249, 5.297613>, <0.575915, -0.595615, 5.265966>, <0.605422, -0.579118, 5.237168>, 
      <0.509330, -0.621275, 5.371063>, <0.548786, -0.601009, 5.368895>, <0.604807, -0.577600, 5.308799>, <0.634314, -0.561103, 5.280001>, 
      <0.542268, -0.603913, 5.467188>, <0.598795, -0.573977, 5.426647>, <0.654018, -0.564141, 5.382563>, <0.690830, -0.536348, 5.322502>, 
      <0.573823, -0.595202, 5.536960>, <0.630350, -0.565266, 5.496420>, <0.690300, -0.539000, 5.414898>, <0.727112, -0.511207, 5.354836>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.483719, -0.635514, 5.299781>, <0.509330, -0.621275, 5.371063>, <0.542268, -0.603913, 5.467188>, <0.573823, -0.595202, 5.536960>, 
      <0.433739, -0.661185, 5.302527>, <0.459350, -0.646946, 5.373809>, <0.502008, -0.625235, 5.496062>, <0.533563, -0.616524, 5.565834>, 
      <0.356196, -0.685668, 5.280351>, <0.377655, -0.680703, 5.380132>, <0.435885, -0.660808, 5.467533>, <0.464927, -0.651702, 5.565077>, 
      <0.324847, -0.723228, 5.252583>, <0.346306, -0.718262, 5.352364>, <0.388683, -0.684165, 5.479181>, <0.417725, -0.675058, 5.576726>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.415201, -0.683391, 5.095483>, <0.389112, -0.690223, 5.108531>, <0.348345, -0.693437, 5.113261>, <0.319692, -0.697743, 5.120880>, 
      <0.389524, -0.685462, 5.023660>, <0.363435, -0.692294, 5.036708>, <0.337478, -0.680096, 5.036520>, <0.308825, -0.684401, 5.044139>, 
      <0.353045, -0.658758, 4.930473>, <0.336253, -0.662021, 4.931764>, <0.302148, -0.667956, 4.941651>, <0.285062, -0.668636, 4.943035>, 
      <0.326407, -0.648201, 4.859754>, <0.309614, -0.651464, 4.861045>, <0.287307, -0.655482, 4.865431>, <0.270221, -0.656161, 4.866815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.415201, -0.683391, 5.095483>, <0.446239, -0.675263, 5.079960>, <0.480239, -0.660839, 5.048648>, <0.506338, -0.648865, 5.027532>, 
      <0.437485, -0.681594, 5.157816>, <0.468523, -0.673466, 5.142293>, <0.514045, -0.652276, 5.112370>, <0.540143, -0.640303, 5.091254>, 
      <0.461713, -0.647749, 5.238534>, <0.501169, -0.627483, 5.236366>, <0.537559, -0.619531, 5.209102>, <0.567066, -0.603034, 5.180304>, 
      <0.483719, -0.635514, 5.299781>, <0.523175, -0.615249, 5.297613>, <0.575915, -0.595615, 5.265966>, <0.605422, -0.579118, 5.237168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.415201, -0.683391, 5.095483>, <0.437485, -0.681594, 5.157816>, <0.461713, -0.647749, 5.238534>, <0.483719, -0.635514, 5.299781>, 
      <0.389112, -0.690223, 5.108531>, <0.411396, -0.688426, 5.170864>, <0.411733, -0.673420, 5.241280>, <0.433739, -0.661185, 5.302527>, 
      <0.348345, -0.693437, 5.113261>, <0.353909, -0.700269, 5.152558>, <0.347739, -0.687626, 5.241024>, <0.356196, -0.685668, 5.280351>, 
      <0.319692, -0.697743, 5.120880>, <0.325257, -0.704575, 5.160178>, <0.316389, -0.725185, 5.213256>, <0.324847, -0.723228, 5.252583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.403510, -0.630259, 4.856567>, <0.434358, -0.635841, 4.907856>, <0.478364, -0.655950, 4.974800>, <0.506338, -0.648865, 5.027532>, 
      <0.380136, -0.634571, 4.856594>, <0.410985, -0.640153, 4.907883>, <0.452265, -0.667924, 4.995916>, <0.480239, -0.660839, 5.048648>, 
      <0.349673, -0.643680, 4.857966>, <0.376311, -0.654237, 4.928684>, <0.420562, -0.677334, 5.008137>, <0.446239, -0.675263, 5.079960>, 
      <0.326407, -0.648201, 4.859754>, <0.353045, -0.658758, 4.930473>, <0.389524, -0.685462, 5.023660>, <0.415201, -0.683391, 5.095483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.579847, -0.607854, 4.962274>, <0.619018, -0.588834, 5.002899>, <0.664493, -0.544841, 5.053281>, <0.702776, -0.513039, 5.085985>, 
      <0.562021, -0.620554, 4.985553>, <0.601192, -0.601534, 5.026178>, <0.648419, -0.564849, 5.104705>, <0.686702, -0.533047, 5.137409>, 
      <0.529735, -0.638131, 5.008603>, <0.563540, -0.629568, 5.072325>, <0.605253, -0.581684, 5.143035>, <0.643609, -0.557768, 5.199899>, 
      <0.506338, -0.648865, 5.027532>, <0.540143, -0.640303, 5.091254>, <0.567066, -0.603034, 5.180304>, <0.605422, -0.579118, 5.237168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.484469, -0.619041, 4.859573>, <0.513082, -0.615685, 4.890383>, <0.552102, -0.621326, 4.933499>, <0.579847, -0.607854, 4.962274>, 
      <0.460238, -0.622756, 4.860613>, <0.488851, -0.619400, 4.891424>, <0.534276, -0.634026, 4.956778>, <0.562021, -0.620554, 4.985553>, 
      <0.427639, -0.625807, 4.856539>, <0.458488, -0.631389, 4.907829>, <0.501760, -0.645216, 4.955871>, <0.529735, -0.638131, 5.008603>, 
      <0.403510, -0.630259, 4.856567>, <0.434358, -0.635841, 4.907856>, <0.478364, -0.655950, 4.974800>, <0.506338, -0.648865, 5.027532>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.639683, -0.553864, 4.853400>, <0.641509, -0.561270, 4.893315>, <0.602518, -0.591702, 4.932668>, <0.579847, -0.607854, 4.962274>, 
      <0.618614, -0.575497, 4.850554>, <0.620440, -0.582903, 4.890468>, <0.574774, -0.605174, 4.903893>, <0.552102, -0.621326, 4.933499>, 
      <0.562487, -0.601848, 4.850440>, <0.557352, -0.601815, 4.855400>, <0.534125, -0.612459, 4.889479>, <0.513082, -0.615685, 4.890383>, 
      <0.553861, -0.607210, 4.850109>, <0.548726, -0.607177, 4.855069>, <0.505512, -0.615815, 4.858669>, <0.484469, -0.619041, 4.859573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.639683, -0.553864, 4.853400>, <0.669393, -0.523359, 4.857414>, <0.693981, -0.470861, 4.865334>, <0.719415, -0.437225, 4.872478>, 
      <0.641509, -0.561270, 4.893315>, <0.671219, -0.530765, 4.897329>, <0.706589, -0.480480, 4.931617>, <0.732023, -0.446844, 4.938761>, 
      <0.602518, -0.591702, 4.932668>, <0.641689, -0.572682, 4.973293>, <0.683554, -0.521115, 4.992300>, <0.721837, -0.489313, 5.025004>, 
      <0.579847, -0.607854, 4.962274>, <0.619018, -0.588834, 5.002899>, <0.664493, -0.544841, 5.053281>, <0.702776, -0.513039, 5.085985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.570676, -0.570659, 4.761804>, <0.590663, -0.541171, 4.744588>, <0.611794, -0.491539, 4.736745>, <0.634314, -0.460808, 4.726071>, 
      <0.594230, -0.564706, 4.786680>, <0.614218, -0.535218, 4.769463>, <0.640140, -0.479242, 4.777688>, <0.662660, -0.448511, 4.767014>, 
      <0.638121, -0.547527, 4.819247>, <0.667830, -0.517022, 4.823261>, <0.684492, -0.463622, 4.815449>, <0.709926, -0.429986, 4.822593>, 
      <0.639683, -0.553864, 4.853400>, <0.669393, -0.523359, 4.857414>, <0.693981, -0.470861, 4.865334>, <0.719415, -0.437225, 4.872478>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.526876, -0.619315, 4.818616>, <0.540016, -0.604718, 4.801572>, <0.557540, -0.590040, 4.773120>, <0.570676, -0.570659, 4.761804>, 
      <0.538080, -0.615594, 4.823964>, <0.551220, -0.600997, 4.806920>, <0.581094, -0.584086, 4.797995>, <0.594230, -0.564706, 4.786680>, 
      <0.556985, -0.607230, 4.847093>, <0.565611, -0.601868, 4.847424>, <0.617052, -0.569160, 4.816400>, <0.638121, -0.547527, 4.819247>, 
      <0.553861, -0.607210, 4.850109>, <0.562487, -0.601848, 4.850440>, <0.618614, -0.575497, 4.850554>, <0.639683, -0.553864, 4.853400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.478935, -0.594492, 4.683633>, <0.495442, -0.574768, 4.657387>, <0.518588, -0.541716, 4.627767>, <0.538621, -0.515657, 4.611336>, 
      <0.508841, -0.588227, 4.704246>, <0.525348, -0.568502, 4.678000>, <0.552048, -0.525458, 4.657696>, <0.572081, -0.499399, 4.641265>, 
      <0.545708, -0.576970, 4.735435>, <0.565695, -0.547482, 4.718218>, <0.585409, -0.502985, 4.698634>, <0.607929, -0.472255, 4.687960>, 
      <0.570676, -0.570659, 4.761804>, <0.590663, -0.541171, 4.744588>, <0.611794, -0.491539, 4.736745>, <0.634314, -0.460808, 4.726071>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.426641, -0.649463, 4.789384>, <0.442329, -0.632972, 4.757658>, <0.461396, -0.615450, 4.711520>, <0.478935, -0.594492, 4.683633>, 
      <0.457757, -0.643925, 4.797388>, <0.473445, -0.627434, 4.765663>, <0.491302, -0.609185, 4.732134>, <0.508841, -0.588227, 4.704246>, 
      <0.498692, -0.628676, 4.805163>, <0.511832, -0.614079, 4.788119>, <0.532571, -0.596350, 4.746750>, <0.545708, -0.576970, 4.735435>, 
      <0.526876, -0.619315, 4.818616>, <0.540016, -0.604718, 4.801572>, <0.557540, -0.590040, 4.773120>, <0.570676, -0.570659, 4.761804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.366745, -0.613383, 4.621240>, <0.353313, -0.627632, 4.664043>, <0.338508, -0.642509, 4.723303>, <0.326407, -0.654992, 4.767044>, 
      <0.312372, -0.618713, 4.601896>, <0.298940, -0.632962, 4.644699>, <0.294570, -0.643316, 4.717728>, <0.282469, -0.655798, 4.761469>, 
      <0.236958, -0.623893, 4.576925>, <0.236963, -0.631454, 4.631462>, <0.223319, -0.644973, 4.703654>, <0.223327, -0.654008, 4.757966>, 
      <0.179001, -0.623893, 4.576925>, <0.179006, -0.631454, 4.631462>, <0.179021, -0.644973, 4.703654>, <0.179029, -0.654008, 4.757966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.366745, -0.613383, 4.621240>, <0.403264, -0.609803, 4.634232>, <0.447351, -0.601109, 4.661863>, <0.478935, -0.594492, 4.683633>, 
      <0.353313, -0.627632, 4.664043>, <0.389832, -0.624053, 4.677035>, <0.429812, -0.622067, 4.689750>, <0.461396, -0.615450, 4.711520>, 
      <0.338508, -0.642509, 4.723303>, <0.369111, -0.641948, 4.727186>, <0.412884, -0.638212, 4.750084>, <0.442329, -0.632972, 4.757658>, 
      <0.326407, -0.654992, 4.767044>, <0.357009, -0.654430, 4.770927>, <0.397195, -0.654703, 4.781809>, <0.426641, -0.649463, 4.789384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.366745, -0.613383, 4.621240>, <0.312372, -0.618713, 4.601896>, <0.236958, -0.623893, 4.576925>, <0.179001, -0.623893, 4.576925>, 
      <0.376612, -0.602916, 4.589798>, <0.322239, -0.608246, 4.570454>, <0.236954, -0.618536, 4.538281>, <0.178998, -0.618536, 4.538281>, 
      <0.393506, -0.590646, 4.547687>, <0.329971, -0.607485, 4.518746>, <0.250819, -0.619482, 4.485597>, <0.179001, -0.619482, 4.485597>, 
      <0.403934, -0.572750, 4.520002>, <0.340400, -0.589589, 4.491061>, <0.250819, -0.610969, 4.447523>, <0.179002, -0.610969, 4.447523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.366745, -0.613383, 4.621240>, <0.376612, -0.602916, 4.589798>, <0.393506, -0.590646, 4.547687>, <0.403934, -0.572750, 4.520002>, 
      <0.403264, -0.609803, 4.634232>, <0.413131, -0.599336, 4.602791>, <0.439276, -0.578515, 4.568536>, <0.449705, -0.560619, 4.540851>, 
      <0.447351, -0.601109, 4.661863>, <0.463858, -0.581385, 4.635617>, <0.482330, -0.559334, 4.595336>, <0.502363, -0.533275, 4.578905>, 
      <0.478935, -0.594492, 4.683633>, <0.495442, -0.574768, 4.657387>, <0.518588, -0.541716, 4.627767>, <0.538621, -0.515657, 4.611336>
    }
  }
  texture {
    Head
  }
}
#declare sPatchObj3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.874842, -0.323135, -0.096061>, <1.852738, -0.349392, -0.162920>, <1.818320, -0.395641, -0.247313>, <1.801161, -0.410660, -0.318925>, 
      <1.892725, -0.302023, -0.110265>, <1.870621, -0.328280, -0.177124>, <1.835873, -0.374253, -0.261516>, <1.818715, -0.389273, -0.333128>, 
      <1.919349, -0.270431, -0.131475>, <1.897245, -0.296688, -0.198334>, <1.863477, -0.346840, -0.282175>, <1.845669, -0.357956, -0.354338>, 
      <1.948134, -0.266444, -0.142557>, <1.926030, -0.292702, -0.209416>, <1.892262, -0.342853, -0.293257>, <1.874454, -0.353969, -0.365420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.865120, -0.364448, -0.076622>, <1.843855, -0.390625, -0.143790>, <1.808167, -0.433819, -0.228856>, <1.794238, -0.451704, -0.300516>, 
      <1.867299, -0.351832, -0.082297>, <1.846034, -0.378009, -0.149465>, <1.809345, -0.421295, -0.234165>, <1.795416, -0.439179, -0.305824>, 
      <1.866790, -0.332642, -0.089665>, <1.844685, -0.358899, -0.156524>, <1.810613, -0.405030, -0.241078>, <1.793455, -0.420049, -0.312690>, 
      <1.874842, -0.323135, -0.096061>, <1.852738, -0.349392, -0.162920>, <1.818320, -0.395641, -0.247313>, <1.801161, -0.410660, -0.318925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.861226, -0.401971, -0.060599>, <1.841000, -0.428048, -0.128150>, <1.803194, -0.468643, -0.213977>, <1.793806, -0.488894, -0.285768>, 
      <1.861218, -0.390525, -0.065091>, <1.840992, -0.416602, -0.132642>, <1.801099, -0.457423, -0.217691>, <1.791711, -0.477674, -0.289482>, 
      <1.863207, -0.375525, -0.071639>, <1.841942, -0.401702, -0.138808>, <1.807132, -0.444829, -0.224190>, <1.793203, -0.462714, -0.295850>, 
      <1.865120, -0.364448, -0.076622>, <1.843855, -0.390625, -0.143790>, <1.808167, -0.433819, -0.228856>, <1.794238, -0.451704, -0.300516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.865185, -0.453275, -0.041759>, <1.848788, -0.478984, -0.110720>, <1.819893, -0.514545, -0.200912>, <1.810529, -0.538973, -0.271630>, 
      <1.862572, -0.437893, -0.046936>, <1.846175, -0.463602, -0.115898>, <1.814057, -0.499723, -0.204803>, <1.804693, -0.524152, -0.275521>, 
      <1.861237, -0.417274, -0.054593>, <1.841011, -0.443351, -0.122144>, <1.806055, -0.483971, -0.208903>, <1.796667, -0.504222, -0.280695>, 
      <1.861226, -0.401971, -0.060599>, <1.841000, -0.428048, -0.128150>, <1.803194, -0.468643, -0.213977>, <1.793806, -0.488894, -0.285768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.877963, -0.500502, -0.027436>, <1.864114, -0.525967, -0.097336>, <1.849451, -0.555897, -0.193017>, <1.831801, -0.585384, -0.260435>, 
      <1.873145, -0.486521, -0.031334>, <1.859296, -0.511985, -0.101234>, <1.845465, -0.541379, -0.197401>, <1.827815, -0.570867, -0.264819>, 
      <1.867616, -0.467585, -0.036943>, <1.851219, -0.493295, -0.105904>, <1.825474, -0.528717, -0.197191>, <1.816110, -0.553146, -0.267909>, 
      <1.865185, -0.453275, -0.041759>, <1.848788, -0.478984, -0.110720>, <1.819893, -0.514545, -0.200912>, <1.810529, -0.538973, -0.271630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.898331, -0.549454, -0.014945>, <1.879964, -0.575353, -0.083180>, <1.859442, -0.602066, -0.178925>, <1.837107, -0.635783, -0.242396>, 
      <1.889732, -0.535789, -0.017469>, <1.871365, -0.561687, -0.085704>, <1.857062, -0.586958, -0.184073>, <1.834727, -0.620674, -0.247543>, 
      <1.883112, -0.515442, -0.023271>, <1.869263, -0.540906, -0.093171>, <1.853553, -0.570838, -0.188505>, <1.835903, -0.600325, -0.255923>, 
      <1.877963, -0.500502, -0.027436>, <1.864114, -0.525967, -0.097336>, <1.849451, -0.555897, -0.193017>, <1.831801, -0.585384, -0.260435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.943132, -0.604071, -0.008307>, <1.914845, -0.630923, -0.072888>, <1.873574, -0.655303, -0.163450>, <1.848841, -0.693576, -0.223578>, 
      <1.925464, -0.592261, -0.007104>, <1.897177, -0.619113, -0.071685>, <1.858710, -0.644184, -0.162902>, <1.833977, -0.682457, -0.223030>, 
      <1.909531, -0.567254, -0.011657>, <1.891164, -0.593152, -0.079893>, <1.862180, -0.619453, -0.173003>, <1.839845, -0.653169, -0.236473>, 
      <1.898331, -0.549454, -0.014945>, <1.879964, -0.575353, -0.083180>, <1.859442, -0.602066, -0.178925>, <1.837107, -0.635783, -0.242396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.030425, -0.637749, -0.023940>, <2.008321, -0.664007, -0.090799>, <1.968090, -0.685368, -0.184138>, <1.956744, -0.725274, -0.246803>, 
      <2.004132, -0.641572, -0.013746>, <1.982028, -0.667830, -0.080605>, <1.936231, -0.689886, -0.171830>, <1.924885, -0.729792, -0.234496>, 
      <1.966754, -0.619860, -0.009916>, <1.938467, -0.646712, -0.074497>, <1.901148, -0.675930, -0.164466>, <1.876416, -0.714202, -0.224594>, 
      <1.943132, -0.604071, -0.008307>, <1.914845, -0.630923, -0.072888>, <1.873574, -0.655303, -0.163450>, <1.848841, -0.693576, -0.223578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.106848, -0.580266, -0.071782>, <2.082406, -0.606748, -0.137780>, <2.041329, -0.631744, -0.228167>, <2.025373, -0.668540, -0.291774>, 
      <2.088629, -0.602232, -0.057132>, <2.064187, -0.628714, -0.123130>, <2.025634, -0.653265, -0.214526>, <2.009678, -0.690062, -0.278133>, 
      <2.060063, -0.633440, -0.035431>, <2.037959, -0.659697, -0.102290>, <1.995765, -0.681443, -0.194829>, <1.984419, -0.721349, -0.257494>, 
      <2.030425, -0.637749, -0.023940>, <2.008321, -0.664007, -0.090799>, <1.968090, -0.685368, -0.184138>, <1.956744, -0.725274, -0.246803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.125105, -0.523596, -0.100073>, <2.099312, -0.550208, -0.165573>, <2.058374, -0.579185, -0.253626>, <2.039128, -0.612303, -0.318407>, 
      <2.122334, -0.541492, -0.092129>, <2.096541, -0.568104, -0.157629>, <2.056302, -0.596632, -0.246089>, <2.037056, -0.629750, -0.310870>, 
      <2.118079, -0.566725, -0.080813>, <2.093637, -0.593207, -0.146811>, <2.051356, -0.617995, -0.236881>, <2.035399, -0.654791, -0.300488>, 
      <2.106848, -0.580266, -0.071782>, <2.082406, -0.606748, -0.137780>, <2.041329, -0.631744, -0.228167>, <2.025373, -0.668540, -0.291774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.123094, -0.475335, -0.118362>, <2.097504, -0.501928, -0.183937>, <2.056603, -0.534638, -0.270255>, <2.037793, -0.563977, -0.336945>, 
      <2.125436, -0.489839, -0.113440>, <2.099845, -0.516432, -0.179015>, <2.059251, -0.549163, -0.265427>, <2.040441, -0.578501, -0.332116>, 
      <2.127276, -0.509574, -0.106298>, <2.101483, -0.536186, -0.171798>, <2.060058, -0.565009, -0.259750>, <2.040812, -0.598128, -0.324531>, 
      <2.125105, -0.523596, -0.100073>, <2.099312, -0.550208, -0.165573>, <2.058374, -0.579185, -0.253626>, <2.039128, -0.612303, -0.318407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.109443, -0.426578, -0.132998>, <2.083052, -0.453247, -0.198278>, <2.040356, -0.490070, -0.282281>, <2.021474, -0.515475, -0.350598>, 
      <2.114712, -0.440964, -0.129090>, <2.088321, -0.467633, -0.194370>, <2.046384, -0.504323, -0.278676>, <2.027502, -0.529727, -0.346994>, 
      <2.120705, -0.460534, -0.123385>, <2.095114, -0.487127, -0.188960>, <2.053894, -0.519781, -0.275195>, <2.035084, -0.549120, -0.341884>, 
      <2.123094, -0.475335, -0.118362>, <2.097504, -0.501928, -0.183937>, <2.056603, -0.534638, -0.270255>, <2.037793, -0.563977, -0.336945>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.087092, -0.377039, -0.145063>, <2.059895, -0.403786, -0.210046>, <2.016019, -0.444854, -0.292111>, <1.996434, -0.466196, -0.361673>, 
      <2.094657, -0.391579, -0.141854>, <2.067460, -0.418326, -0.206837>, <2.023309, -0.459724, -0.288682>, <2.003725, -0.481066, -0.358243>, 
      <2.103877, -0.411382, -0.137126>, <2.077487, -0.438051, -0.202406>, <2.033939, -0.474900, -0.286117>, <2.015057, -0.500305, -0.354434>, 
      <2.109443, -0.426578, -0.132998>, <2.083052, -0.453247, -0.198278>, <2.040356, -0.490070, -0.282281>, <2.021474, -0.515475, -0.350598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.063821, -0.338897, -0.152349>, <2.038185, -0.365494, -0.217907>, <1.997988, -0.409500, -0.300509>, <1.978367, -0.427553, -0.370876>, 
      <2.072258, -0.349453, -0.150993>, <2.046622, -0.376050, -0.216551>, <2.004289, -0.420737, -0.298179>, <1.984668, -0.438790, -0.368546>, 
      <2.080940, -0.365216, -0.147672>, <2.053743, -0.391963, -0.212655>, <2.010375, -0.433343, -0.294766>, <1.990790, -0.454685, -0.364328>, 
      <2.087092, -0.377039, -0.145063>, <2.059895, -0.403786, -0.210046>, <2.016019, -0.444854, -0.292111>, <1.996434, -0.466196, -0.361673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.027147, -0.302041, -0.154699>, <2.005043, -0.328298, -0.221558>, <1.970712, -0.375056, -0.305867>, <1.953466, -0.389566, -0.377562>, 
      <2.040346, -0.310307, -0.155816>, <2.018242, -0.336565, -0.222675>, <1.981942, -0.383008, -0.306457>, <1.964696, -0.397518, -0.378152>, 
      <2.054121, -0.326761, -0.153908>, <2.028485, -0.353358, -0.219466>, <1.991359, -0.397679, -0.302960>, <1.971738, -0.415731, -0.373327>, 
      <2.063821, -0.338897, -0.152349>, <2.038185, -0.365494, -0.217907>, <1.997988, -0.409500, -0.300509>, <1.978367, -0.427553, -0.370876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.027147, -0.302041, -0.154699>, <2.004955, -0.288143, -0.152821>, <1.972431, -0.263079, -0.151912>, <1.948134, -0.266444, -0.142557>, 
      <2.005043, -0.328298, -0.221558>, <1.982851, -0.314400, -0.219680>, <1.950327, -0.289336, -0.218771>, <1.926030, -0.292702, -0.209416>, 
      <1.970712, -0.375056, -0.305867>, <1.949308, -0.359899, -0.304743>, <1.916559, -0.339488, -0.302612>, <1.892262, -0.342853, -0.293257>, 
      <1.953466, -0.389566, -0.377562>, <1.932061, -0.374409, -0.376438>, <1.898751, -0.350604, -0.374774>, <1.874454, -0.353969, -0.365420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.665219, -1.289605, -0.845659>, <1.672525, -1.291343, -0.847622>, <1.686303, -1.301326, -0.848031>, <1.683036, -1.308308, -0.847124>, 
      <1.677791, -1.277757, -0.833292>, <1.685096, -1.279495, -0.835254>, <1.704044, -1.305182, -0.831298>, <1.700776, -1.312164, -0.830391>, 
      <1.692171, -1.254692, -0.818815>, <1.714688, -1.260060, -0.825484>, <1.732813, -1.296176, -0.819873>, <1.726536, -1.317258, -0.810051>, 
      <1.707124, -1.250111, -0.804434>, <1.729641, -1.255479, -0.811103>, <1.748448, -1.300080, -0.801168>, <1.742171, -1.321162, -0.791346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.636243, -1.297178, -0.834552>, <1.640277, -1.288558, -0.835672>, <1.656199, -1.287460, -0.843236>, <1.665219, -1.289605, -0.845659>, 
      <1.634381, -1.296354, -0.811626>, <1.638415, -1.287734, -0.812746>, <1.668771, -1.275611, -0.830868>, <1.677791, -1.277757, -0.833292>, 
      <1.625937, -1.294746, -0.780778>, <1.633774, -1.268425, -0.793041>, <1.664059, -1.247990, -0.810488>, <1.692171, -1.254692, -0.818815>, 
      <1.630036, -1.294430, -0.758132>, <1.637873, -1.268110, -0.770395>, <1.679012, -1.243409, -0.796107>, <1.707124, -1.250111, -0.804434>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.652339, -1.317130, -0.842083>, <1.644794, -1.315336, -0.840056>, <1.632869, -1.304388, -0.833615>, <1.636243, -1.297178, -0.834552>, 
      <1.659100, -1.329514, -0.815651>, <1.651556, -1.327720, -0.813624>, <1.631007, -1.303564, -0.810689>, <1.634381, -1.296354, -0.811626>, 
      <1.663261, -1.347790, -0.779472>, <1.641321, -1.342559, -0.772973>, <1.619821, -1.315287, -0.771208>, <1.625937, -1.294746, -0.780778>, 
      <1.674877, -1.358411, -0.753977>, <1.652937, -1.353181, -0.747479>, <1.623920, -1.314971, -0.748562>, <1.630036, -1.294430, -0.758132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.652339, -1.317130, -0.842083>, <1.659100, -1.329514, -0.815651>, <1.663261, -1.347790, -0.779472>, <1.674877, -1.358411, -0.753977>, 
      <1.661469, -1.319302, -0.844536>, <1.668231, -1.331686, -0.818104>, <1.687240, -1.353506, -0.786574>, <1.698856, -1.364127, -0.761080>, 
      <1.678953, -1.317034, -0.845990>, <1.696693, -1.320890, -0.829257>, <1.719851, -1.339708, -0.799592>, <1.735486, -1.343613, -0.780886>, 
      <1.683036, -1.308308, -0.847124>, <1.700776, -1.312164, -0.830391>, <1.726536, -1.317258, -0.810051>, <1.742171, -1.321162, -0.791346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.796412, -1.249414, -0.719484>, <1.771311, -1.249086, -0.746630>, <1.733146, -1.242139, -0.779407>, <1.707124, -1.250111, -0.804434>, 
      <1.824123, -1.258222, -0.725650>, <1.799022, -1.257894, -0.752796>, <1.755663, -1.247507, -0.786077>, <1.729641, -1.255479, -0.811103>, 
      <1.822953, -1.316636, -0.703028>, <1.800018, -1.313829, -0.733782>, <1.772808, -1.306163, -0.772025>, <1.748448, -1.300080, -0.801168>, 
      <1.815770, -1.341452, -0.688329>, <1.792835, -1.338645, -0.719083>, <1.766531, -1.327245, -0.762203>, <1.742171, -1.321162, -0.791346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.668635, -1.294684, -0.655589>, <1.653620, -1.295107, -0.684826>, <1.635890, -1.293979, -0.725790>, <1.630036, -1.294430, -0.758132>, 
      <1.679500, -1.257148, -0.677823>, <1.664484, -1.257572, -0.707060>, <1.643727, -1.267659, -0.738053>, <1.637873, -1.268110, -0.770395>, 
      <1.754498, -1.236091, -0.710157>, <1.729397, -1.235763, -0.737303>, <1.705034, -1.235437, -0.771080>, <1.679012, -1.243409, -0.796107>, 
      <1.796412, -1.249414, -0.719484>, <1.771311, -1.249086, -0.746630>, <1.733146, -1.242139, -0.779407>, <1.707124, -1.250111, -0.804434>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.750762, -1.407124, -0.626067>, <1.728613, -1.397673, -0.666371>, <1.693079, -1.375054, -0.714027>, <1.674877, -1.358411, -0.753977>, 
      <1.710953, -1.394470, -0.617209>, <1.688804, -1.385019, -0.657513>, <1.671140, -1.369824, -0.707529>, <1.652937, -1.353181, -0.747479>, 
      <1.658316, -1.330334, -0.634472>, <1.643301, -1.330757, -0.663709>, <1.629774, -1.314521, -0.716220>, <1.623920, -1.314971, -0.748562>, 
      <1.668635, -1.294684, -0.655589>, <1.653620, -1.295107, -0.684826>, <1.635890, -1.293979, -0.725790>, <1.630036, -1.294430, -0.758132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.750762, -1.407124, -0.626067>, <1.781926, -1.417030, -0.633001>, <1.807692, -1.369360, -0.671798>, <1.815770, -1.341452, -0.688329>, 
      <1.728613, -1.397673, -0.666371>, <1.759777, -1.407579, -0.673306>, <1.784757, -1.366553, -0.702552>, <1.792835, -1.338645, -0.719083>, 
      <1.693079, -1.375054, -0.714027>, <1.717058, -1.380771, -0.721130>, <1.759846, -1.349695, -0.751744>, <1.766531, -1.327245, -0.762203>, 
      <1.674877, -1.358411, -0.753977>, <1.698856, -1.364127, -0.761080>, <1.735486, -1.343613, -0.780886>, <1.742171, -1.321162, -0.791346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.804629, -1.251386, -0.698985>, <1.801306, -1.255960, -0.702490>, <1.800928, -1.249473, -0.714600>, <1.796412, -1.249414, -0.719484>, 
      <1.836214, -1.260534, -0.706124>, <1.832891, -1.265107, -0.709629>, <1.828638, -1.258281, -0.720766>, <1.824123, -1.258222, -0.725650>, 
      <1.859702, -1.308874, -0.662628>, <1.848817, -1.319336, -0.672458>, <1.833694, -1.317951, -0.688625>, <1.822953, -1.316636, -0.703028>, 
      <1.853487, -1.334786, -0.642079>, <1.842603, -1.345247, -0.651910>, <1.826511, -1.342767, -0.673926>, <1.815770, -1.341452, -0.688329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.706679, -1.292269, -0.608896>, <1.696368, -1.298673, -0.622300>, <1.676896, -1.294451, -0.639504>, <1.668635, -1.294684, -0.655589>, 
      <1.714392, -1.260107, -0.634401>, <1.704081, -1.266511, -0.647805>, <1.687760, -1.256916, -0.661738>, <1.679500, -1.257148, -0.677823>, 
      <1.765425, -1.240032, -0.690124>, <1.762102, -1.244606, -0.693629>, <1.759013, -1.236150, -0.705274>, <1.754498, -1.236091, -0.710157>, 
      <1.804629, -1.251386, -0.698985>, <1.801306, -1.255960, -0.702490>, <1.800928, -1.249473, -0.714600>, <1.796412, -1.249414, -0.719484>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.769298, -1.398701, -0.582161>, <1.763086, -1.407726, -0.591688>, <1.757611, -1.410047, -0.613603>, <1.750762, -1.407124, -0.626067>, 
      <1.733719, -1.388397, -0.574119>, <1.727507, -1.397422, -0.583646>, <1.717803, -1.397393, -0.604745>, <1.710953, -1.394470, -0.617209>, 
      <1.699679, -1.321457, -0.585749>, <1.689367, -1.327861, -0.599153>, <1.666576, -1.330101, -0.618388>, <1.658316, -1.330334, -0.634472>, 
      <1.706679, -1.292269, -0.608896>, <1.696368, -1.298673, -0.622300>, <1.676896, -1.294451, -0.639504>, <1.668635, -1.294684, -0.655589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.769298, -1.398701, -0.582161>, <1.803513, -1.408610, -0.589895>, <1.846755, -1.362855, -0.619820>, <1.853487, -1.334786, -0.642079>, 
      <1.763086, -1.407726, -0.591688>, <1.797301, -1.417635, -0.599422>, <1.835871, -1.373317, -0.629650>, <1.842603, -1.345247, -0.651910>, 
      <1.757611, -1.410047, -0.613603>, <1.788775, -1.419952, -0.620538>, <1.818433, -1.370675, -0.657395>, <1.826511, -1.342767, -0.673926>, 
      <1.750762, -1.407124, -0.626067>, <1.781926, -1.417030, -0.633001>, <1.807692, -1.369360, -0.671798>, <1.815770, -1.341452, -0.688329>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.822831, -1.213050, -0.691618>, <1.817624, -1.224740, -0.693406>, <1.811084, -1.242501, -0.692176>, <1.804629, -1.251386, -0.698985>, 
      <1.855287, -1.216641, -0.703991>, <1.850080, -1.228332, -0.705778>, <1.842670, -1.251648, -0.699316>, <1.836214, -1.260534, -0.706124>, 
      <1.896605, -1.246762, -0.646306>, <1.885466, -1.269062, -0.651490>, <1.875084, -1.294089, -0.648734>, <1.859702, -1.308874, -0.662628>, 
      <1.895041, -1.265261, -0.616731>, <1.883903, -1.287562, -0.621915>, <1.868870, -1.320001, -0.628185>, <1.853487, -1.334786, -0.642079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.743089, -1.248447, -0.558804>, <1.733933, -1.267534, -0.567160>, <1.719657, -1.284210, -0.592026>, <1.706679, -1.292269, -0.608896>, 
      <1.745224, -1.223191, -0.599180>, <1.736068, -1.242279, -0.607536>, <1.727370, -1.252048, -0.617531>, <1.714392, -1.260107, -0.634401>, 
      <1.778522, -1.208147, -0.674727>, <1.773315, -1.219837, -0.676514>, <1.771881, -1.231147, -0.683315>, <1.765425, -1.240032, -0.690124>, 
      <1.822831, -1.213050, -0.691618>, <1.817624, -1.224740, -0.693406>, <1.811084, -1.242501, -0.692176>, <1.804629, -1.251386, -0.698985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.814220, -1.314928, -0.528747>, <1.800858, -1.341886, -0.541583>, <1.783293, -1.378368, -0.560697>, <1.769298, -1.398701, -0.582161>, 
      <1.785808, -1.311784, -0.517916>, <1.772446, -1.338742, -0.530752>, <1.747714, -1.368063, -0.552655>, <1.733719, -1.388397, -0.574119>, 
      <1.741720, -1.264642, -0.532914>, <1.732564, -1.283729, -0.541270>, <1.712656, -1.313398, -0.568879>, <1.699679, -1.321457, -0.585749>, 
      <1.743089, -1.248447, -0.558804>, <1.733933, -1.267534, -0.567160>, <1.719657, -1.284210, -0.592026>, <1.706679, -1.292269, -0.608896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.814220, -1.314928, -0.528747>, <1.850296, -1.318920, -0.542500>, <1.893303, -1.285824, -0.583857>, <1.895041, -1.265261, -0.616731>, 
      <1.800858, -1.341886, -0.541583>, <1.836934, -1.345878, -0.555336>, <1.882164, -1.308125, -0.589041>, <1.883903, -1.287562, -0.621915>, 
      <1.783293, -1.378368, -0.560697>, <1.817509, -1.388277, -0.568431>, <1.862138, -1.348070, -0.605926>, <1.868870, -1.320001, -0.628185>, 
      <1.769298, -1.398701, -0.582161>, <1.803513, -1.408610, -0.589895>, <1.846755, -1.362855, -0.619820>, <1.853487, -1.334786, -0.642079>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.854606, -1.139181, -0.681828>, <1.847599, -1.162450, -0.682034>, <1.832624, -1.191064, -0.688256>, <1.822831, -1.213050, -0.691618>, 
      <1.886168, -1.147424, -0.695749>, <1.879161, -1.170693, -0.695955>, <1.865080, -1.194655, -0.700629>, <1.855287, -1.216641, -0.703991>, 
      <1.932902, -1.161670, -0.637405>, <1.922672, -1.193016, -0.641169>, <1.911123, -1.217694, -0.639549>, <1.896605, -1.246762, -0.646306>, 
      <1.938518, -1.164541, -0.602503>, <1.928288, -1.195886, -0.606267>, <1.909559, -1.236194, -0.609974>, <1.895041, -1.265261, -0.616731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786936, -1.124952, -0.535644>, <1.778677, -1.163295, -0.543094>, <1.759149, -1.214965, -0.544145>, <1.743089, -1.248447, -0.558804>, 
      <1.779253, -1.121025, -0.583385>, <1.770995, -1.159368, -0.590835>, <1.761284, -1.189709, -0.584521>, <1.745224, -1.223191, -0.599180>, 
      <1.811433, -1.127906, -0.662786>, <1.804426, -1.151175, -0.662991>, <1.788315, -1.186161, -0.671365>, <1.778522, -1.208147, -0.674727>, 
      <1.854606, -1.139181, -0.681828>, <1.847599, -1.162450, -0.682034>, <1.832624, -1.191064, -0.688256>, <1.822831, -1.213050, -0.691618>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.889176, -1.156851, -0.467005>, <1.868443, -1.204989, -0.485729>, <1.836955, -1.269060, -0.506907>, <1.814220, -1.314928, -0.528747>, 
      <1.855215, -1.147981, -0.452026>, <1.834483, -1.196120, -0.470749>, <1.808543, -1.265917, -0.496076>, <1.785808, -1.311784, -0.517916>, 
      <1.792979, -1.128041, -0.498090>, <1.784721, -1.166384, -0.505540>, <1.757781, -1.231159, -0.518255>, <1.741720, -1.264642, -0.532914>, 
      <1.786936, -1.124952, -0.535644>, <1.778677, -1.163295, -0.543094>, <1.759149, -1.214965, -0.544145>, <1.743089, -1.248447, -0.558804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.889176, -1.156851, -0.467005>, <1.927728, -1.166920, -0.484009>, <1.945378, -1.168048, -0.559871>, <1.938518, -1.164541, -0.602503>, 
      <1.868443, -1.204989, -0.485729>, <1.906996, -1.215058, -0.502733>, <1.935149, -1.199393, -0.563636>, <1.928288, -1.195886, -0.606267>, 
      <1.836955, -1.269060, -0.506907>, <1.873032, -1.273052, -0.520660>, <1.907821, -1.256757, -0.577099>, <1.909559, -1.236194, -0.609974>, 
      <1.814220, -1.314928, -0.528747>, <1.850296, -1.318920, -0.542500>, <1.893303, -1.285824, -0.583857>, <1.895041, -1.265261, -0.616731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.867500, -1.064718, -0.690308>, <1.863632, -1.087057, -0.687764>, <1.861184, -1.117337, -0.681635>, <1.854606, -1.139181, -0.681828>, 
      <1.912257, -1.059198, -0.706653>, <1.908389, -1.081536, -0.704109>, <1.892746, -1.125580, -0.695556>, <1.886168, -1.147424, -0.695749>, 
      <1.962595, -1.029782, -0.628779>, <1.950299, -1.075267, -0.625554>, <1.947459, -1.117063, -0.632048>, <1.932902, -1.161670, -0.637405>, 
      <1.977417, -1.012847, -0.586419>, <1.965122, -1.058332, -0.583194>, <1.953076, -1.119933, -0.597146>, <1.938518, -1.164541, -0.602503>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.788825, -1.036108, -0.517546>, <1.790182, -1.063271, -0.518251>, <1.792564, -1.098823, -0.530567>, <1.786936, -1.124952, -0.535644>, 
      <1.771028, -1.056441, -0.568407>, <1.772386, -1.083605, -0.569112>, <1.784881, -1.094896, -0.578308>, <1.779253, -1.121025, -0.583385>, 
      <1.813761, -1.071346, -0.670683>, <1.809893, -1.093685, -0.668139>, <1.818011, -1.106062, -0.662593>, <1.811433, -1.127906, -0.662786>, 
      <1.867500, -1.064718, -0.690308>, <1.863632, -1.087057, -0.687764>, <1.861184, -1.117337, -0.681635>, <1.854606, -1.139181, -0.681828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.974765, -0.942165, -0.383759>, <1.949088, -1.006571, -0.408733>, <1.916628, -1.093111, -0.442213>, <1.889176, -1.156851, -0.467005>, 
      <1.905460, -0.950713, -0.358449>, <1.879783, -1.015119, -0.383423>, <1.882668, -1.084241, -0.427234>, <1.855215, -1.147981, -0.452026>, 
      <1.811777, -1.009885, -0.451953>, <1.813134, -1.037049, -0.452659>, <1.798607, -1.101911, -0.493013>, <1.792979, -1.128041, -0.498090>, 
      <1.788825, -1.036108, -0.517546>, <1.790182, -1.063271, -0.518251>, <1.792564, -1.098823, -0.530567>, <1.786936, -1.124952, -0.535644>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.974765, -0.942165, -0.383759>, <2.034850, -0.934754, -0.405702>, <1.997315, -0.990112, -0.529552>, <1.977417, -1.012847, -0.586419>, 
      <1.949088, -1.006571, -0.408733>, <2.009174, -0.999160, -0.430676>, <1.985020, -1.035598, -0.526327>, <1.965122, -1.058332, -0.583194>, 
      <1.916628, -1.093111, -0.442213>, <1.955181, -1.103180, -0.459217>, <1.959936, -1.123440, -0.554515>, <1.953076, -1.119933, -0.597146>, 
      <1.889176, -1.156851, -0.467005>, <1.927728, -1.166920, -0.484009>, <1.945378, -1.168048, -0.559871>, <1.938518, -1.164541, -0.602503>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.787815, -0.399313, -0.459272>, <1.801101, -0.371278, -0.474675>, <1.825053, -0.328312, -0.499467>, <1.856971, -0.323348, -0.511969>, 
      <1.795079, -0.397983, -0.417489>, <1.808365, -0.369948, -0.432891>, <1.833655, -0.332789, -0.455300>, <1.865574, -0.327825, -0.467802>, 
      <1.791474, -0.419140, -0.359355>, <1.809027, -0.397752, -0.373559>, <1.834954, -0.364644, -0.397757>, <1.863739, -0.360657, -0.408839>, 
      <1.801161, -0.410660, -0.318925>, <1.818715, -0.389273, -0.333128>, <1.845669, -0.357956, -0.354338>, <1.874454, -0.353969, -0.365420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.794561, -0.455044, -0.439615>, <1.790545, -0.438450, -0.444804>, <1.780971, -0.413756, -0.451337>, <1.787815, -0.399313, -0.459272>, 
      <1.799316, -0.449152, -0.398566>, <1.795300, -0.432559, -0.403755>, <1.788235, -0.412426, -0.409554>, <1.795079, -0.397983, -0.417489>, 
      <1.786502, -0.461637, -0.340314>, <1.787680, -0.449112, -0.345622>, <1.783767, -0.428529, -0.353120>, <1.791474, -0.419140, -0.359355>, 
      <1.794238, -0.451704, -0.300516>, <1.795416, -0.439179, -0.305824>, <1.793455, -0.420049, -0.312690>, <1.801161, -0.410660, -0.318925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.813419, -0.505100, -0.426191>, <1.810467, -0.489639, -0.431287>, <1.798285, -0.470430, -0.434804>, <1.794561, -0.455044, -0.439615>, 
      <1.814864, -0.494868, -0.384644>, <1.811912, -0.479406, -0.389740>, <1.803040, -0.464538, -0.393754>, <1.799316, -0.449152, -0.398566>, 
      <1.788460, -0.500426, -0.326650>, <1.786365, -0.489206, -0.330364>, <1.785467, -0.472647, -0.335648>, <1.786502, -0.461637, -0.340314>, 
      <1.793806, -0.488894, -0.285768>, <1.791711, -0.477674, -0.289482>, <1.793203, -0.462714, -0.295850>, <1.794238, -0.451704, -0.300516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.817818, -0.576841, -0.399471>, <1.821216, -0.556068, -0.408752>, <1.817524, -0.526598, -0.419105>, <1.813419, -0.505100, -0.426191>, 
      <1.821693, -0.560778, -0.362978>, <1.825090, -0.540005, -0.372260>, <1.818969, -0.516365, -0.377559>, <1.814864, -0.494868, -0.384644>, 
      <1.805554, -0.551951, -0.309201>, <1.799718, -0.537130, -0.313092>, <1.791321, -0.515754, -0.321577>, <1.788460, -0.500426, -0.326650>, 
      <1.810529, -0.538973, -0.271630>, <1.804693, -0.524152, -0.275521>, <1.796667, -0.504222, -0.280695>, <1.793806, -0.488894, -0.285768>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.790186, -0.647149, -0.362724>, <1.795167, -0.624759, -0.373164>, <1.814096, -0.599598, -0.389303>, <1.817818, -0.576841, -0.399471>, 
      <1.798265, -0.626270, -0.332070>, <1.803246, -0.603880, -0.342510>, <1.817971, -0.583535, -0.352811>, <1.821693, -0.560778, -0.362978>, 
      <1.822948, -0.600175, -0.294254>, <1.818962, -0.585658, -0.298638>, <1.811135, -0.566124, -0.305480>, <1.805554, -0.551951, -0.309201>, 
      <1.831801, -0.585384, -0.260435>, <1.827815, -0.570867, -0.264819>, <1.816110, -0.553146, -0.267909>, <1.810529, -0.538973, -0.271630>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.786280, -0.718606, -0.333369>, <1.782287, -0.696911, -0.340569>, <1.785600, -0.667765, -0.353111>, <1.790186, -0.647149, -0.362724>, 
      <1.797265, -0.691462, -0.306217>, <1.793272, -0.669767, -0.313417>, <1.793679, -0.646886, -0.322457>, <1.798265, -0.626270, -0.332070>, 
      <1.825256, -0.653673, -0.276074>, <1.822876, -0.638565, -0.281221>, <1.827049, -0.615117, -0.289742>, <1.822948, -0.600175, -0.294254>, 
      <1.837107, -0.635783, -0.242396>, <1.834727, -0.620674, -0.247543>, <1.835903, -0.600325, -0.255923>, <1.831801, -0.585384, -0.260435>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.817919, -0.797833, -0.312714>, <1.795651, -0.783784, -0.312319>, <1.790811, -0.743225, -0.325198>, <1.786280, -0.718606, -0.333369>, 
      <1.824564, -0.764081, -0.288301>, <1.802296, -0.750032, -0.287906>, <1.801796, -0.716081, -0.298046>, <1.797265, -0.691462, -0.306217>, 
      <1.835012, -0.714975, -0.257197>, <1.820148, -0.703857, -0.256649>, <1.827994, -0.671060, -0.270151>, <1.825256, -0.653673, -0.276074>, 
      <1.848841, -0.693576, -0.223578>, <1.833977, -0.682457, -0.223030>, <1.839845, -0.653169, -0.236473>, <1.837107, -0.635783, -0.242396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.973800, -0.836914, -0.336693>, <1.928819, -0.843672, -0.319168>, <1.859141, -0.823840, -0.313445>, <1.817919, -0.797833, -0.312714>, 
      <1.970765, -0.800390, -0.313630>, <1.925784, -0.807149, -0.296105>, <1.865786, -0.790088, -0.289031>, <1.824564, -0.764081, -0.288301>, 
      <1.950207, -0.748267, -0.282910>, <1.918348, -0.752786, -0.270602>, <1.862587, -0.735602, -0.258213>, <1.835012, -0.714975, -0.257197>, 
      <1.956744, -0.725274, -0.246803>, <1.924885, -0.729792, -0.234496>, <1.876416, -0.714202, -0.224594>, <1.848841, -0.693576, -0.223578>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.026065, -0.766559, -0.393811>, <2.016518, -0.792210, -0.378454>, <2.002760, -0.832563, -0.347976>, <1.973800, -0.836914, -0.336693>, 
      <2.024044, -0.734765, -0.365760>, <2.014497, -0.760416, -0.350404>, <1.999726, -0.796039, -0.324913>, <1.970765, -0.800390, -0.313630>, 
      <2.016366, -0.689311, -0.327680>, <2.000671, -0.710833, -0.314038>, <1.977882, -0.744342, -0.293601>, <1.950207, -0.748267, -0.282910>, 
      <2.025373, -0.668540, -0.291774>, <2.009678, -0.690062, -0.278133>, <1.984419, -0.721349, -0.257494>, <1.956744, -0.725274, -0.246803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.028613, -0.689640, -0.424862>, <2.028128, -0.712754, -0.415624>, <2.033639, -0.746210, -0.405993>, <2.026065, -0.766559, -0.393811>, 
      <2.029294, -0.664420, -0.394338>, <2.028809, -0.687535, -0.385100>, <2.031618, -0.714416, -0.377943>, <2.024044, -0.734765, -0.365760>, 
      <2.029001, -0.629730, -0.352494>, <2.026929, -0.647177, -0.344957>, <2.026392, -0.675562, -0.336394>, <2.016366, -0.689311, -0.327680>, 
      <2.039128, -0.612303, -0.318407>, <2.037056, -0.629750, -0.310870>, <2.035399, -0.654791, -0.300488>, <2.025373, -0.668540, -0.291774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.029100, -0.621940, -0.451611>, <2.031112, -0.642399, -0.444242>, <2.029038, -0.669365, -0.432965>, <2.028613, -0.689640, -0.424862>, 
      <2.030423, -0.601982, -0.418559>, <2.032436, -0.622440, -0.411190>, <2.029719, -0.644146, -0.402442>, <2.029294, -0.664420, -0.394338>, 
      <2.028136, -0.579040, -0.371185>, <2.030784, -0.593564, -0.366356>, <2.030685, -0.615554, -0.358618>, <2.029001, -0.629730, -0.352494>, 
      <2.037793, -0.563977, -0.336945>, <2.040441, -0.578501, -0.332116>, <2.040812, -0.598128, -0.324531>, <2.039128, -0.612303, -0.318407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.015208, -0.553366, -0.473949>, <2.021081, -0.573722, -0.467897>, <2.027069, -0.601298, -0.459046>, <2.029100, -0.621940, -0.451611>, 
      <2.017670, -0.538414, -0.438277>, <2.023543, -0.558770, -0.432224>, <2.028393, -0.581340, -0.425994>, <2.030423, -0.601982, -0.418559>, 
      <2.011754, -0.528552, -0.385764>, <2.017783, -0.542805, -0.382160>, <2.025427, -0.564183, -0.376124>, <2.028136, -0.579040, -0.371185>, 
      <2.021474, -0.515475, -0.350598>, <2.027502, -0.529727, -0.346994>, <2.035084, -0.549120, -0.341884>, <2.037793, -0.563977, -0.336945>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.989212, -0.483700, -0.492714>, <1.997593, -0.504441, -0.487339>, <2.009075, -0.532111, -0.480269>, <2.015208, -0.553366, -0.473949>, 
      <1.993064, -0.474191, -0.454341>, <2.001445, -0.494932, -0.448967>, <2.011537, -0.517159, -0.444596>, <2.017670, -0.538414, -0.438277>, 
      <1.986110, -0.477446, -0.398342>, <1.993401, -0.492316, -0.394912>, <2.005338, -0.513382, -0.389601>, <2.011754, -0.528552, -0.385764>, 
      <1.996434, -0.466196, -0.361673>, <2.003725, -0.481066, -0.358243>, <2.015057, -0.500305, -0.354434>, <2.021474, -0.515475, -0.350598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.965206, -0.429629, -0.506013>, <1.972627, -0.445776, -0.502125>, <1.982585, -0.467301, -0.496964>, <1.989212, -0.483700, -0.492714>, 
      <1.970747, -0.424540, -0.465976>, <1.978168, -0.440688, -0.462088>, <1.986437, -0.457791, -0.458591>, <1.993064, -0.474191, -0.454341>, 
      <1.967745, -0.437326, -0.408971>, <1.974045, -0.448563, -0.406641>, <1.980466, -0.465935, -0.400996>, <1.986110, -0.477446, -0.398342>, 
      <1.978367, -0.427553, -0.370876>, <1.984668, -0.438790, -0.368546>, <1.990790, -0.454685, -0.364328>, <1.996434, -0.466196, -0.361673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.939582, -0.375712, -0.518716>, <1.952636, -0.388531, -0.517998>, <1.957737, -0.413376, -0.509926>, <1.965206, -0.429629, -0.506013>, 
      <1.947020, -0.375130, -0.476619>, <1.960074, -0.387948, -0.475901>, <1.963278, -0.408288, -0.469889>, <1.970747, -0.424540, -0.465976>, 
      <1.943655, -0.397820, -0.418347>, <1.954885, -0.405773, -0.418937>, <1.961116, -0.425505, -0.411422>, <1.967745, -0.437326, -0.408971>, 
      <1.953466, -0.389566, -0.377562>, <1.964696, -0.397518, -0.378152>, <1.971738, -0.415731, -0.373327>, <1.978367, -0.427553, -0.370876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.939582, -0.375712, -0.518716>, <1.947020, -0.375130, -0.476619>, <1.943655, -0.397820, -0.418347>, <1.953466, -0.389566, -0.377562>, 
      <1.918612, -0.355121, -0.519870>, <1.926050, -0.354538, -0.477773>, <1.922250, -0.382663, -0.417223>, <1.932061, -0.374409, -0.376438>, 
      <1.884075, -0.319133, -0.522585>, <1.892678, -0.323610, -0.478418>, <1.888036, -0.357292, -0.418194>, <1.898751, -0.350604, -0.374774>, 
      <1.856971, -0.323348, -0.511969>, <1.865574, -0.327825, -0.467802>, <1.863739, -0.360657, -0.408839>, <1.874454, -0.353969, -0.365420>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.752214, -0.419621, -0.600463>, <1.763166, -0.386255, -0.617188>, <1.781512, -0.330332, -0.645215>, <1.817188, -0.324166, -0.659432>, 
      <1.765457, -0.410422, -0.559410>, <1.776408, -0.377056, -0.576135>, <1.795844, -0.324658, -0.602065>, <1.831520, -0.318492, -0.616281>, 
      <1.780264, -0.400695, -0.502705>, <1.793550, -0.372660, -0.518107>, <1.816335, -0.323775, -0.544222>, <1.848254, -0.318811, -0.556724>, 
      <1.787815, -0.399313, -0.459272>, <1.801101, -0.371278, -0.474675>, <1.825053, -0.328312, -0.499467>, <1.856971, -0.323348, -0.511969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.762361, -0.491202, -0.575706>, <1.757328, -0.469868, -0.582421>, <1.745759, -0.439287, -0.590606>, <1.752214, -0.419621, -0.600463>, 
      <1.774845, -0.479155, -0.535996>, <1.769812, -0.457821, -0.542711>, <1.759002, -0.430088, -0.549553>, <1.765457, -0.410422, -0.559410>, 
      <1.789625, -0.461161, -0.482230>, <1.785608, -0.444567, -0.487420>, <1.773419, -0.415138, -0.494770>, <1.780264, -0.400695, -0.502705>, 
      <1.794561, -0.455044, -0.439615>, <1.790545, -0.438450, -0.444804>, <1.780971, -0.413756, -0.451337>, <1.787815, -0.399313, -0.459272>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.784349, -0.555841, -0.557590>, <1.781616, -0.535989, -0.564483>, <1.767013, -0.510923, -0.569499>, <1.762361, -0.491202, -0.575706>, 
      <1.796234, -0.541117, -0.518813>, <1.793500, -0.521264, -0.525706>, <1.779497, -0.498876, -0.529789>, <1.774845, -0.479155, -0.535996>, 
      <1.811962, -0.515413, -0.468062>, <1.809010, -0.499951, -0.473158>, <1.793348, -0.476546, -0.477419>, <1.789625, -0.461161, -0.482230>, 
      <1.813419, -0.505100, -0.426191>, <1.810467, -0.489639, -0.431287>, <1.798285, -0.470430, -0.434804>, <1.794561, -0.455044, -0.439615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.784052, -0.648741, -0.521007>, <1.785756, -0.621102, -0.532425>, <1.788212, -0.583901, -0.547847>, <1.784349, -0.555841, -0.557590>, 
      <1.794029, -0.630286, -0.482834>, <1.795732, -0.602647, -0.494252>, <1.800097, -0.569176, -0.509071>, <1.796234, -0.541117, -0.518813>, 
      <1.813605, -0.594307, -0.439151>, <1.817003, -0.573534, -0.448432>, <1.816067, -0.536910, -0.460977>, <1.811962, -0.515413, -0.468062>, 
      <1.817818, -0.576841, -0.399471>, <1.821216, -0.556068, -0.408752>, <1.817524, -0.526598, -0.419105>, <1.813419, -0.505100, -0.426191>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.773192, -0.736851, -0.482813>, <1.776716, -0.711012, -0.495484>, <1.782403, -0.675494, -0.509955>, <1.784052, -0.648741, -0.521007>, 
      <1.781168, -0.714451, -0.444307>, <1.784692, -0.688613, -0.456977>, <1.792379, -0.657040, -0.471782>, <1.794029, -0.630286, -0.482834>, 
      <1.780554, -0.672042, -0.399271>, <1.785535, -0.649652, -0.409711>, <1.809883, -0.617064, -0.428983>, <1.813605, -0.594307, -0.439151>, 
      <1.790186, -0.647149, -0.362724>, <1.795167, -0.624759, -0.373164>, <1.814096, -0.599598, -0.389303>, <1.817818, -0.576841, -0.399471>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.759747, -0.826947, -0.433619>, <1.755225, -0.799518, -0.447469>, <1.769417, -0.764530, -0.469240>, <1.773192, -0.736851, -0.482813>, 
      <1.769055, -0.801088, -0.397997>, <1.764533, -0.773659, -0.411847>, <1.777392, -0.742131, -0.430733>, <1.781168, -0.714451, -0.444307>, 
      <1.773904, -0.749188, -0.363961>, <1.769911, -0.727493, -0.371161>, <1.775967, -0.692658, -0.389658>, <1.780554, -0.672042, -0.399271>, 
      <1.786280, -0.718606, -0.333369>, <1.782287, -0.696911, -0.340569>, <1.785600, -0.667765, -0.353111>, <1.790186, -0.647149, -0.362724>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.803785, -0.922427, -0.389110>, <1.774204, -0.906576, -0.395969>, <1.764734, -0.857198, -0.418344>, <1.759747, -0.826947, -0.433619>, 
      <1.809537, -0.894073, -0.355893>, <1.779956, -0.878222, -0.362753>, <1.774042, -0.831339, -0.382722>, <1.769055, -0.801088, -0.397997>, 
      <1.810980, -0.833079, -0.338208>, <1.788712, -0.819030, -0.337813>, <1.778435, -0.773808, -0.355790>, <1.773904, -0.749188, -0.363961>, 
      <1.817919, -0.797833, -0.312714>, <1.795651, -0.783784, -0.312319>, <1.790811, -0.743225, -0.325198>, <1.786280, -0.718606, -0.333369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.803785, -0.922427, -0.389110>, <1.809537, -0.894073, -0.355893>, <1.810980, -0.833079, -0.338208>, <1.817919, -0.797833, -0.312714>, 
      <1.848397, -0.946333, -0.378765>, <1.854149, -0.917979, -0.345548>, <1.852201, -0.859086, -0.338939>, <1.859141, -0.823840, -0.313445>, 
      <1.927311, -0.949515, -0.364712>, <1.927021, -0.917939, -0.350592>, <1.931243, -0.872847, -0.337590>, <1.928819, -0.843672, -0.319168>, 
      <1.974765, -0.942165, -0.383759>, <1.974475, -0.910590, -0.369639>, <1.976224, -0.866089, -0.355116>, <1.973800, -0.836914, -0.336693>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.803785, -0.922427, -0.389110>, <1.848397, -0.946333, -0.378765>, <1.927311, -0.949515, -0.364712>, <1.974765, -0.942165, -0.383759>, 
      <1.797602, -0.952903, -0.424813>, <1.842214, -0.976808, -0.414468>, <1.858006, -0.958063, -0.339402>, <1.905460, -0.950713, -0.358449>, 
      <1.788111, -0.972841, -0.486994>, <1.793824, -0.987505, -0.483374>, <1.810971, -0.993762, -0.451535>, <1.811777, -1.009885, -0.451953>, 
      <1.779944, -0.985024, -0.532011>, <1.785657, -0.999688, -0.528391>, <1.788019, -1.019985, -0.517127>, <1.788825, -1.036108, -0.517546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.039194, -0.885967, -0.483600>, <2.028632, -0.912426, -0.456335>, <2.010988, -0.936555, -0.398299>, <1.974765, -0.942165, -0.383759>, 
      <2.043737, -0.857682, -0.448906>, <2.033175, -0.884141, -0.421641>, <2.010698, -0.904980, -0.384179>, <1.974475, -0.910590, -0.369639>, 
      <2.028207, -0.800260, -0.423544>, <2.018660, -0.825911, -0.408187>, <2.005185, -0.861738, -0.366399>, <1.976224, -0.866089, -0.355116>, 
      <2.026065, -0.766559, -0.393811>, <2.016518, -0.792210, -0.378454>, <2.002760, -0.832563, -0.347976>, <1.973800, -0.836914, -0.336693>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.039194, -0.885967, -0.483600>, <2.034522, -0.915061, -0.519286>, <2.015513, -0.934898, -0.577947>, <1.996741, -0.949150, -0.617774>, 
      <2.028632, -0.912426, -0.456335>, <2.023960, -0.941519, -0.492021>, <2.013467, -0.955119, -0.569335>, <1.994695, -0.969371, -0.609162>, 
      <2.010988, -0.936555, -0.398299>, <2.071074, -0.929144, -0.420241>, <2.003062, -0.968853, -0.531059>, <1.983164, -0.991588, -0.587926>, 
      <1.974765, -0.942165, -0.383759>, <2.034850, -0.934754, -0.405702>, <1.997315, -0.990112, -0.529552>, <1.977417, -1.012847, -0.586419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.034245, -0.793163, -0.537302>, <2.036020, -0.821524, -0.522156>, <2.047819, -0.864361, -0.505864>, <2.039194, -0.885967, -0.483600>, 
      <2.039834, -0.767601, -0.499612>, <2.041609, -0.795961, -0.484466>, <2.052361, -0.836076, -0.471170>, <2.043737, -0.857682, -0.448906>, 
      <2.027824, -0.718861, -0.460228>, <2.027339, -0.741975, -0.450990>, <2.035781, -0.779911, -0.435726>, <2.028207, -0.800260, -0.423544>, 
      <2.028613, -0.689640, -0.424862>, <2.028128, -0.712754, -0.415624>, <2.033639, -0.746210, -0.405993>, <2.026065, -0.766559, -0.393811>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.028146, -0.709454, -0.577863>, <2.032687, -0.735154, -0.567816>, <2.032703, -0.768532, -0.550455>, <2.034245, -0.793163, -0.537302>, 
      <2.035788, -0.686827, -0.538448>, <2.040330, -0.712528, -0.528401>, <2.038292, -0.742970, -0.512765>, <2.039834, -0.767601, -0.499612>, 
      <2.027521, -0.645749, -0.491039>, <2.029534, -0.666207, -0.483670>, <2.028250, -0.698586, -0.468331>, <2.027824, -0.718861, -0.460228>, 
      <2.029100, -0.621940, -0.451611>, <2.031112, -0.642399, -0.444242>, <2.029038, -0.669365, -0.432965>, <2.028613, -0.689640, -0.424862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.003965, -0.621808, -0.604289>, <2.012557, -0.647855, -0.596900>, <2.023533, -0.683350, -0.588068>, <2.028146, -0.709454, -0.577863>, 
      <2.013767, -0.603320, -0.565250>, <2.022359, -0.629366, -0.557862>, <2.031175, -0.660723, -0.548653>, <2.035788, -0.686827, -0.538448>, 
      <2.012394, -0.570454, -0.514717>, <2.018268, -0.590809, -0.508664>, <2.025491, -0.625107, -0.498475>, <2.027521, -0.645749, -0.491039>, 
      <2.015208, -0.553366, -0.473949>, <2.021081, -0.573722, -0.467897>, <2.027069, -0.601298, -0.459046>, <2.029100, -0.621940, -0.451611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.969687, -0.532230, -0.628137>, <1.980378, -0.558991, -0.621162>, <1.994997, -0.594620, -0.612002>, <2.003965, -0.621808, -0.604289>, 
      <1.979628, -0.517839, -0.588251>, <1.990319, -0.544600, -0.581276>, <2.004799, -0.576132, -0.572963>, <2.013767, -0.603320, -0.565250>, 
      <1.984989, -0.494127, -0.534789>, <1.993370, -0.514868, -0.529414>, <2.006262, -0.549199, -0.521037>, <2.012394, -0.570454, -0.514717>, 
      <1.989212, -0.483700, -0.492714>, <1.997593, -0.504441, -0.487339>, <2.009075, -0.532111, -0.480269>, <2.015208, -0.553366, -0.473949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.940317, -0.462496, -0.645813>, <1.950143, -0.483075, -0.640980>, <1.961281, -0.511190, -0.633621>, <1.969687, -0.532230, -0.628137>, 
      <1.950955, -0.451046, -0.604976>, <1.960781, -0.471625, -0.600143>, <1.971222, -0.496799, -0.593735>, <1.979628, -0.517839, -0.588251>, 
      <1.959259, -0.435091, -0.548987>, <1.966680, -0.451238, -0.545099>, <1.978362, -0.477727, -0.539038>, <1.984989, -0.494127, -0.534789>, 
      <1.965206, -0.429629, -0.506013>, <1.972627, -0.445776, -0.502125>, <1.982585, -0.467301, -0.496964>, <1.989212, -0.483700, -0.492714>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.903437, -0.393483, -0.660724>, <1.919283, -0.411285, -0.658971>, <1.930244, -0.441400, -0.650768>, <1.940317, -0.462496, -0.645813>, 
      <1.916812, -0.384739, -0.619425>, <1.932658, -0.402541, -0.617672>, <1.940882, -0.429950, -0.609931>, <1.950955, -0.451046, -0.604976>, 
      <1.931878, -0.376315, -0.562319>, <1.944932, -0.389134, -0.561601>, <1.951789, -0.418838, -0.552900>, <1.959259, -0.435091, -0.548987>, 
      <1.939582, -0.375712, -0.518716>, <1.952636, -0.388531, -0.517998>, <1.957737, -0.413376, -0.509926>, <1.965206, -0.429629, -0.506013>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.903437, -0.393483, -0.660724>, <1.916812, -0.384739, -0.619425>, <1.931878, -0.376315, -0.562319>, <1.939582, -0.375712, -0.518716>, 
      <1.881424, -0.368753, -0.663159>, <1.894799, -0.360008, -0.621860>, <1.910908, -0.355724, -0.563473>, <1.918612, -0.355121, -0.519870>, 
      <1.847637, -0.318903, -0.671566>, <1.861969, -0.313229, -0.628415>, <1.875358, -0.314597, -0.567340>, <1.884075, -0.319133, -0.522585>, 
      <1.817188, -0.324166, -0.659432>, <1.831520, -0.318492, -0.616281>, <1.848254, -0.318811, -0.556724>, <1.856971, -0.323348, -0.511969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.705361, -0.456591, -0.714884>, <1.715972, -0.422354, -0.731838>, <1.733306, -0.364306, -0.760365>, <1.769645, -0.357921, -0.774887>, 
      <1.718735, -0.443967, -0.680816>, <1.729346, -0.409730, -0.697770>, <1.746671, -0.351461, -0.726277>, <1.783010, -0.345076, -0.740798>, 
      <1.740590, -0.427696, -0.636498>, <1.751542, -0.394330, -0.653223>, <1.769375, -0.335138, -0.681757>, <1.805051, -0.328971, -0.695973>, 
      <1.752214, -0.419621, -0.600463>, <1.763166, -0.386255, -0.617188>, <1.781512, -0.330332, -0.645215>, <1.817188, -0.324166, -0.659432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.716069, -0.530787, -0.689285>, <1.710868, -0.508670, -0.696252>, <1.699001, -0.477111, -0.704723>, <1.705361, -0.456591, -0.714884>, 
      <1.729457, -0.518336, -0.655217>, <1.724256, -0.496219, -0.662183>, <1.712375, -0.464487, -0.670655>, <1.718735, -0.443967, -0.680816>, 
      <1.751222, -0.501951, -0.611136>, <1.746189, -0.480616, -0.617851>, <1.734135, -0.447362, -0.626641>, <1.740590, -0.427696, -0.636498>, 
      <1.762361, -0.491202, -0.575706>, <1.757328, -0.469868, -0.582421>, <1.745759, -0.439287, -0.590606>, <1.752214, -0.419621, -0.600463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.738573, -0.597831, -0.670395>, <1.733621, -0.577411, -0.676778>, <1.720875, -0.551225, -0.682847>, <1.716069, -0.530787, -0.689285>, 
      <1.751979, -0.585534, -0.636313>, <1.747027, -0.565114, -0.642695>, <1.734262, -0.538774, -0.648779>, <1.729457, -0.518336, -0.655217>, 
      <1.773708, -0.569025, -0.592310>, <1.770974, -0.549173, -0.599203>, <1.755875, -0.521672, -0.604930>, <1.751222, -0.501951, -0.611136>, 
      <1.784349, -0.555841, -0.557590>, <1.781616, -0.535989, -0.564483>, <1.767013, -0.510923, -0.569499>, <1.762361, -0.491202, -0.575706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.755286, -0.692513, -0.638736>, <1.754853, -0.664202, -0.649712>, <1.745420, -0.626069, -0.661569>, <1.738573, -0.597831, -0.670395>, 
      <1.764267, -0.680855, -0.602990>, <1.763835, -0.652544, -0.613966>, <1.758826, -0.613772, -0.627487>, <1.751979, -0.585534, -0.636313>, 
      <1.775198, -0.665119, -0.554885>, <1.776902, -0.637480, -0.566303>, <1.777571, -0.597085, -0.582567>, <1.773708, -0.569025, -0.592310>, 
      <1.784052, -0.648741, -0.521007>, <1.785756, -0.621102, -0.532425>, <1.788212, -0.583901, -0.547847>, <1.784349, -0.555841, -0.557590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.741419, -0.784115, -0.598177>, <1.745405, -0.756591, -0.610304>, <1.755718, -0.720799, -0.627770>, <1.755286, -0.692513, -0.638736>, 
      <1.745932, -0.773265, -0.561413>, <1.749917, -0.745741, -0.573540>, <1.764700, -0.709141, -0.592025>, <1.764267, -0.680855, -0.602990>, 
      <1.766390, -0.755955, -0.515653>, <1.769914, -0.730116, -0.528324>, <1.773549, -0.691872, -0.543833>, <1.775198, -0.665119, -0.554885>, 
      <1.773192, -0.736851, -0.482813>, <1.776716, -0.711012, -0.495484>, <1.782403, -0.675494, -0.509955>, <1.784052, -0.648741, -0.521007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.728101, -0.880237, -0.556024>, <1.732247, -0.869502, -0.516505>, <1.751232, -0.850604, -0.466208>, <1.759747, -0.826947, -0.433619>, 
      <1.734517, -0.913695, -0.545005>, <1.738663, -0.902960, -0.505486>, <1.756219, -0.880855, -0.450933>, <1.764734, -0.857198, -0.418344>, 
      <1.767277, -0.952510, -0.540037>, <1.775445, -0.940327, -0.495020>, <1.768022, -0.937052, -0.431672>, <1.774204, -0.906576, -0.395969>, 
      <1.779944, -0.985024, -0.532011>, <1.788111, -0.972841, -0.486994>, <1.797602, -0.952903, -0.424813>, <1.803785, -0.922427, -0.389110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.728101, -0.880237, -0.556024>, <1.722414, -0.850578, -0.565792>, <1.737249, -0.812909, -0.585490>, <1.741419, -0.784115, -0.598177>, 
      <1.732247, -0.869502, -0.516505>, <1.726560, -0.839842, -0.526273>, <1.741762, -0.802059, -0.548726>, <1.745932, -0.773265, -0.561413>, 
      <1.751232, -0.850604, -0.466208>, <1.746710, -0.823175, -0.480058>, <1.762615, -0.783634, -0.502080>, <1.766390, -0.755955, -0.515653>, 
      <1.759747, -0.826947, -0.433619>, <1.755225, -0.799518, -0.447469>, <1.769417, -0.764530, -0.469240>, <1.773192, -0.736851, -0.482813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.994189, -0.847090, -0.657012>, <1.996366, -0.877802, -0.645670>, <1.999782, -0.919092, -0.630575>, <1.996741, -0.949150, -0.617774>, 
      <2.012329, -0.834269, -0.622336>, <2.014506, -0.864981, -0.610994>, <2.018554, -0.904840, -0.590748>, <2.015513, -0.934898, -0.577947>, 
      <2.029229, -0.816106, -0.571130>, <2.031004, -0.844467, -0.555984>, <2.043146, -0.893455, -0.541550>, <2.034522, -0.915061, -0.519286>, 
      <2.034245, -0.793163, -0.537302>, <2.036020, -0.821524, -0.522156>, <2.047819, -0.864361, -0.505864>, <2.039194, -0.885967, -0.483600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.983186, -0.757877, -0.688411>, <1.989023, -0.784507, -0.679883>, <1.992294, -0.820353, -0.666886>, <1.994189, -0.847090, -0.657012>, 
      <2.000682, -0.745706, -0.656184>, <2.006520, -0.772336, -0.647656>, <2.010435, -0.807532, -0.632210>, <2.012329, -0.834269, -0.622336>, 
      <2.021739, -0.728424, -0.610908>, <2.026280, -0.754124, -0.600861>, <2.027687, -0.791475, -0.584284>, <2.029229, -0.816106, -0.571130>, 
      <2.028146, -0.709454, -0.577863>, <2.032687, -0.735154, -0.567816>, <2.032703, -0.768532, -0.550455>, <2.034245, -0.793163, -0.537302>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.954785, -0.667328, -0.714583>, <1.963080, -0.694536, -0.706640>, <1.977151, -0.730345, -0.697228>, <1.983186, -0.757877, -0.688411>, 
      <1.971944, -0.654955, -0.682156>, <1.980238, -0.682163, -0.674213>, <1.994647, -0.718175, -0.665001>, <2.000682, -0.745706, -0.656184>, 
      <1.995396, -0.637969, -0.638413>, <2.003988, -0.664015, -0.631024>, <2.017126, -0.702319, -0.621112>, <2.021739, -0.728424, -0.610908>, 
      <2.003965, -0.621808, -0.604289>, <2.012557, -0.647855, -0.596900>, <2.023533, -0.683350, -0.588068>, <2.028146, -0.709454, -0.577863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.927039, -0.573706, -0.742178>, <1.936447, -0.601577, -0.734343>, <1.946235, -0.639283, -0.722771>, <1.954785, -0.667328, -0.714583>, 
      <1.942601, -0.561256, -0.709135>, <1.952009, -0.589127, -0.701300>, <1.963394, -0.626910, -0.690344>, <1.971944, -0.654955, -0.682156>, 
      <1.960880, -0.544980, -0.663476>, <1.971571, -0.571741, -0.656501>, <1.986428, -0.610780, -0.646125>, <1.995396, -0.637969, -0.638413>, 
      <1.969687, -0.532230, -0.628137>, <1.980378, -0.558991, -0.621162>, <1.994997, -0.594620, -0.612002>, <2.003965, -0.621808, -0.604289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.898708, -0.501204, -0.761285>, <1.909087, -0.522341, -0.756415>, <1.919608, -0.551691, -0.748367>, <1.927039, -0.573706, -0.742178>, 
      <1.913943, -0.488611, -0.728118>, <1.924321, -0.509748, -0.723249>, <1.935170, -0.539242, -0.715324>, <1.942601, -0.561256, -0.709135>, 
      <1.930924, -0.472606, -0.681872>, <1.940750, -0.493186, -0.677039>, <1.952474, -0.523940, -0.668960>, <1.960880, -0.544980, -0.663476>, 
      <1.940317, -0.462496, -0.645813>, <1.950143, -0.483075, -0.640980>, <1.961281, -0.511190, -0.633621>, <1.969687, -0.532230, -0.628137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.856493, -0.430035, -0.775279>, <1.869866, -0.417383, -0.741209>, <1.891741, -0.401130, -0.696840>, <1.903437, -0.393483, -0.660724>, 
      <1.833884, -0.404935, -0.777662>, <1.847256, -0.392283, -0.743592>, <1.869728, -0.376400, -0.699275>, <1.881424, -0.368753, -0.663159>, 
      <1.800682, -0.352467, -0.787290>, <1.814047, -0.339622, -0.753201>, <1.835500, -0.323708, -0.708107>, <1.847637, -0.318903, -0.671566>, 
      <1.769645, -0.357921, -0.774887>, <1.783010, -0.345076, -0.740798>, <1.805051, -0.328971, -0.695973>, <1.817188, -0.324166, -0.659432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.856493, -0.430035, -0.775279>, <1.873301, -0.448695, -0.773508>, <1.887841, -0.479073, -0.766384>, <1.898708, -0.501204, -0.761285>, 
      <1.869866, -0.417383, -0.741209>, <1.886674, -0.436043, -0.739438>, <1.903076, -0.466480, -0.733217>, <1.913943, -0.488611, -0.728118>, 
      <1.891741, -0.401130, -0.696840>, <1.907587, -0.418932, -0.695087>, <1.920851, -0.451510, -0.686827>, <1.930924, -0.472606, -0.681872>, 
      <1.903437, -0.393483, -0.660724>, <1.919283, -0.411285, -0.658971>, <1.930244, -0.441400, -0.650768>, <1.940317, -0.462496, -0.645813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.670919, -0.496357, -0.807550>, <1.681996, -0.463304, -0.824193>, <1.700700, -0.408147, -0.852039>, <1.736141, -0.402058, -0.866147>, 
      <1.681958, -0.482243, -0.781077>, <1.693035, -0.449190, -0.797720>, <1.711344, -0.392491, -0.826203>, <1.746785, -0.386402, -0.840311>, 
      <1.694318, -0.467015, -0.743014>, <1.704929, -0.432778, -0.759968>, <1.722274, -0.374909, -0.788504>, <1.758613, -0.368524, -0.803026>, 
      <1.705361, -0.456591, -0.714884>, <1.715972, -0.422354, -0.731838>, <1.733306, -0.364306, -0.760365>, <1.769645, -0.357921, -0.774887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.680864, -0.566998, -0.783096>, <1.675892, -0.545945, -0.789720>, <1.664431, -0.515715, -0.797803>, <1.670919, -0.496357, -0.807550>, 
      <1.692219, -0.554158, -0.756118>, <1.687247, -0.533105, -0.762742>, <1.675471, -0.501601, -0.771329>, <1.681958, -0.482243, -0.781077>, 
      <1.705002, -0.541080, -0.717448>, <1.699801, -0.518963, -0.724415>, <1.687958, -0.487534, -0.732853>, <1.694318, -0.467015, -0.743014>, 
      <1.716069, -0.530787, -0.689285>, <1.710868, -0.508670, -0.696252>, <1.699001, -0.477111, -0.704723>, <1.705361, -0.456591, -0.714884>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.702666, -0.630772, -0.765258>, <1.696578, -0.611544, -0.770797>, <1.685461, -0.586461, -0.776972>, <1.680864, -0.566998, -0.783096>, 
      <1.714307, -0.619118, -0.737830>, <1.708219, -0.599890, -0.743369>, <1.696816, -0.573621, -0.749995>, <1.692219, -0.554158, -0.756118>, 
      <1.727471, -0.608015, -0.698620>, <1.722519, -0.587595, -0.705002>, <1.709808, -0.561518, -0.711011>, <1.705002, -0.541080, -0.717448>, 
      <1.738573, -0.597831, -0.670395>, <1.733621, -0.577411, -0.676778>, <1.720875, -0.551225, -0.682847>, <1.716069, -0.530787, -0.689285>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.729263, -0.719860, -0.739064>, <1.722664, -0.692922, -0.747462>, <1.711101, -0.657412, -0.757584>, <1.702666, -0.630772, -0.765258>, 
      <1.739590, -0.709995, -0.710251>, <1.732991, -0.683057, -0.718649>, <1.722742, -0.645758, -0.730157>, <1.714307, -0.619118, -0.737830>, 
      <1.747814, -0.702212, -0.668473>, <1.747382, -0.673901, -0.679448>, <1.734318, -0.636253, -0.689794>, <1.727471, -0.608015, -0.698620>, 
      <1.755286, -0.692513, -0.638736>, <1.754853, -0.664202, -0.649712>, <1.745420, -0.626069, -0.661569>, <1.738573, -0.597831, -0.670395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.745162, -0.804247, -0.711178>, <1.744440, -0.778735, -0.720246>, <1.735431, -0.745039, -0.731214>, <1.729263, -0.719860, -0.739064>, 
      <1.751181, -0.796016, -0.678269>, <1.750459, -0.770504, -0.687338>, <1.745758, -0.735174, -0.702401>, <1.739590, -0.709995, -0.710251>, 
      <1.737391, -0.793800, -0.630994>, <1.741377, -0.766276, -0.643121>, <1.748246, -0.730498, -0.657507>, <1.747814, -0.702212, -0.668473>, 
      <1.741419, -0.784115, -0.598177>, <1.745405, -0.756591, -0.610304>, <1.755718, -0.720799, -0.627770>, <1.755286, -0.692513, -0.638736>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.734165, -0.893186, -0.677456>, <1.732767, -0.865506, -0.685007>, <1.745927, -0.831304, -0.701561>, <1.745162, -0.804247, -0.711178>, 
      <1.736627, -0.886919, -0.641398>, <1.735229, -0.859239, -0.648949>, <1.751946, -0.823073, -0.668652>, <1.751181, -0.796016, -0.678269>, 
      <1.724406, -0.889804, -0.591242>, <1.718719, -0.860145, -0.601010>, <1.733221, -0.822594, -0.618307>, <1.737391, -0.793800, -0.630994>, 
      <1.728101, -0.880237, -0.556024>, <1.722414, -0.850578, -0.565792>, <1.737249, -0.812909, -0.585490>, <1.741419, -0.784115, -0.598177>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.754818, -0.995473, -0.659010>, <1.735342, -0.970417, -0.657133>, <1.735712, -0.923820, -0.669099>, <1.734165, -0.893186, -0.677456>, 
      <1.765594, -0.990232, -0.621934>, <1.746118, -0.965176, -0.620057>, <1.738174, -0.917552, -0.633041>, <1.736627, -0.886919, -0.641398>, 
      <1.773223, -0.995050, -0.569059>, <1.760556, -0.962537, -0.577085>, <1.730822, -0.923262, -0.580224>, <1.724406, -0.889804, -0.591242>, 
      <1.779944, -0.985024, -0.532011>, <1.767277, -0.952510, -0.540037>, <1.734517, -0.913695, -0.545005>, <1.728101, -0.880237, -0.556024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.754818, -0.995473, -0.659010>, <1.765594, -0.990232, -0.621934>, <1.773223, -0.995050, -0.569059>, <1.779944, -0.985024, -0.532011>, 
      <1.779797, -1.027608, -0.661418>, <1.790573, -1.022367, -0.624342>, <1.778936, -1.009715, -0.565438>, <1.785657, -0.999688, -0.528391>, 
      <1.829497, -1.070104, -0.676552>, <1.775758, -1.076732, -0.656927>, <1.770223, -1.040318, -0.567988>, <1.788019, -1.019985, -0.517127>, 
      <1.867500, -1.064718, -0.690308>, <1.813761, -1.071346, -0.670683>, <1.771028, -1.056441, -0.568407>, <1.788825, -1.036108, -0.517546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.927121, -0.971054, -0.721380>, <1.917576, -1.003061, -0.712389>, <1.899738, -1.060149, -0.701978>, <1.867500, -1.064718, -0.690308>, 
      <1.946733, -0.964834, -0.689409>, <1.937188, -0.996840, -0.680418>, <1.944496, -1.054629, -0.718323>, <1.912257, -1.059198, -0.706653>, 
      <1.981319, -0.960858, -0.650494>, <1.979273, -0.981079, -0.641882>, <1.968341, -1.008523, -0.630286>, <1.962595, -1.029782, -0.628779>, 
      <1.996741, -0.949150, -0.617774>, <1.994695, -0.969371, -0.609162>, <1.983164, -0.991588, -0.587926>, <1.977417, -1.012847, -0.586419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.925581, -0.869965, -0.745017>, <1.926695, -0.899805, -0.736155>, <1.935717, -0.942231, -0.729477>, <1.927121, -0.971054, -0.721380>, 
      <1.943605, -0.862427, -0.716980>, <1.944719, -0.892267, -0.708118>, <1.955329, -0.936011, -0.697506>, <1.946733, -0.964834, -0.689409>, 
      <1.979136, -0.857729, -0.685787>, <1.981312, -0.888442, -0.674445>, <1.984361, -0.930800, -0.663295>, <1.981319, -0.960858, -0.650494>, 
      <1.994189, -0.847090, -0.657012>, <1.996366, -0.877802, -0.645670>, <1.999782, -0.919092, -0.630575>, <1.996741, -0.949150, -0.617774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.920162, -0.784570, -0.776763>, <1.924199, -0.810204, -0.768031>, <1.924602, -0.843735, -0.752807>, <1.925581, -0.869965, -0.745017>, 
      <1.937501, -0.775520, -0.749531>, <1.941539, -0.801154, -0.740798>, <1.942626, -0.836197, -0.724770>, <1.943605, -0.862427, -0.716980>, 
      <1.968003, -0.768439, -0.716377>, <1.973840, -0.795068, -0.707848>, <1.977241, -0.830993, -0.695660>, <1.979136, -0.857729, -0.685787>, 
      <1.983186, -0.757877, -0.688411>, <1.989023, -0.784507, -0.679883>, <1.992294, -0.820353, -0.666886>, <1.994189, -0.847090, -0.657012>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.898477, -0.697874, -0.803641>, <1.905248, -0.723846, -0.795679>, <1.916034, -0.758359, -0.785692>, <1.920162, -0.784570, -0.776763>, 
      <1.914949, -0.687321, -0.777175>, <1.921720, -0.713294, -0.769213>, <1.933373, -0.749309, -0.758460>, <1.937501, -0.775520, -0.749531>, 
      <1.940199, -0.677846, -0.742147>, <1.948494, -0.705054, -0.734204>, <1.961968, -0.740907, -0.725194>, <1.968003, -0.768439, -0.716377>, 
      <1.954785, -0.667328, -0.714583>, <1.963080, -0.694536, -0.706640>, <1.977151, -0.730345, -0.697228>, <1.983186, -0.757877, -0.688411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.874276, -0.608557, -0.830718>, <1.882898, -0.635108, -0.823141>, <1.891481, -0.671040, -0.811867>, <1.898477, -0.697874, -0.803641>, 
      <1.889613, -0.596406, -0.804593>, <1.898235, -0.622956, -0.797016>, <1.907954, -0.660487, -0.785401>, <1.914949, -0.687321, -0.777175>, 
      <1.913875, -0.584237, -0.770128>, <1.923283, -0.612108, -0.762293>, <1.931649, -0.649800, -0.750335>, <1.940199, -0.677846, -0.742147>, 
      <1.927039, -0.573706, -0.742178>, <1.936447, -0.601577, -0.734343>, <1.946235, -0.639283, -0.722771>, <1.954785, -0.667328, -0.714583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.847070, -0.539574, -0.848815>, <1.854906, -0.560357, -0.843244>, <1.867450, -0.587538, -0.836716>, <1.874276, -0.608557, -0.830718>, 
      <1.860262, -0.526186, -0.822193>, <1.868098, -0.546969, -0.816621>, <1.882787, -0.575387, -0.810591>, <1.889613, -0.596406, -0.804593>, 
      <1.885849, -0.511833, -0.789280>, <1.896228, -0.532970, -0.784410>, <1.906444, -0.562222, -0.776317>, <1.913875, -0.584237, -0.770128>, 
      <1.898708, -0.501204, -0.761285>, <1.909087, -0.522341, -0.756415>, <1.919608, -0.551691, -0.748367>, <1.927039, -0.573706, -0.742178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.822173, -0.470369, -0.867762>, <1.836410, -0.488018, -0.865538>, <1.839273, -0.518895, -0.854358>, <1.847070, -0.539574, -0.848815>, 
      <1.833161, -0.456053, -0.841371>, <1.847398, -0.473702, -0.839146>, <1.852465, -0.505507, -0.827736>, <1.860262, -0.526186, -0.822193>, 
      <1.845452, -0.440481, -0.803407>, <1.862261, -0.459141, -0.801636>, <1.874982, -0.489702, -0.794378>, <1.885849, -0.511833, -0.789280>, 
      <1.856493, -0.430035, -0.775279>, <1.873301, -0.448695, -0.773508>, <1.887841, -0.479073, -0.766384>, <1.898708, -0.501204, -0.761285>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.822173, -0.470369, -0.867762>, <1.833161, -0.456053, -0.841371>, <1.845452, -0.440481, -0.803407>, <1.856493, -0.430035, -0.775279>, 
      <1.801578, -0.444838, -0.870980>, <1.812566, -0.430522, -0.844588>, <1.822843, -0.415380, -0.805790>, <1.833884, -0.404935, -0.777662>, 
      <1.766381, -0.396862, -0.878185>, <1.777025, -0.381206, -0.852349>, <1.789650, -0.363070, -0.815429>, <1.800682, -0.352467, -0.787290>, 
      <1.736141, -0.402058, -0.866147>, <1.746785, -0.386402, -0.840311>, <1.758613, -0.368524, -0.803026>, <1.769645, -0.357921, -0.774887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.636389, -0.544773, -0.880285>, <1.648107, -0.513271, -0.896531>, <1.668541, -0.461905, -0.923458>, <1.702839, -0.456187, -0.937043>, 
      <1.644604, -0.530679, -0.857301>, <1.656322, -0.499177, -0.873546>, <1.676647, -0.446516, -0.900802>, <1.710945, -0.440798, -0.914386>, 
      <1.661186, -0.508801, -0.830891>, <1.672263, -0.475748, -0.847534>, <1.691208, -0.422109, -0.875078>, <1.726649, -0.416020, -0.889187>, 
      <1.670919, -0.496357, -0.807550>, <1.681996, -0.463304, -0.824193>, <1.700700, -0.408147, -0.852039>, <1.736141, -0.402058, -0.866147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.645338, -0.610766, -0.857326>, <1.640664, -0.591104, -0.863502>, <1.629755, -0.562606, -0.871088>, <1.636389, -0.544773, -0.880285>, 
      <1.654252, -0.598190, -0.833996>, <1.649578, -0.578527, -0.840173>, <1.637970, -0.548512, -0.848104>, <1.644604, -0.530679, -0.857301>, 
      <1.670930, -0.578231, -0.806698>, <1.665957, -0.557178, -0.813322>, <1.654698, -0.528159, -0.821144>, <1.661186, -0.508801, -0.830891>, 
      <1.680864, -0.566998, -0.783096>, <1.675892, -0.545945, -0.789720>, <1.664431, -0.515715, -0.797803>, <1.670919, -0.496357, -0.807550>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666223, -0.670265, -0.840864>, <1.660409, -0.652316, -0.845991>, <1.649663, -0.628957, -0.851612>, <1.645338, -0.610766, -0.857326>, 
      <1.676794, -0.658714, -0.817860>, <1.670980, -0.640765, -0.822987>, <1.658577, -0.616380, -0.828282>, <1.654252, -0.598190, -0.833996>, 
      <1.692541, -0.640909, -0.789114>, <1.686453, -0.621681, -0.794652>, <1.675527, -0.597695, -0.800574>, <1.670930, -0.578231, -0.806698>, 
      <1.702666, -0.630772, -0.765258>, <1.696578, -0.611544, -0.770797>, <1.685461, -0.586461, -0.776972>, <1.680864, -0.566998, -0.783096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.691544, -0.753404, -0.816584>, <1.685327, -0.728245, -0.824409>, <1.674274, -0.695118, -0.833765>, <1.666223, -0.670265, -0.840864>, 
      <1.703205, -0.743344, -0.793497>, <1.696987, -0.718186, -0.801323>, <1.684845, -0.683567, -0.810761>, <1.676794, -0.658714, -0.817860>, 
      <1.720351, -0.728373, -0.763929>, <1.713752, -0.701435, -0.772327>, <1.700976, -0.667549, -0.781440>, <1.692541, -0.640909, -0.789114>, 
      <1.729263, -0.719860, -0.739064>, <1.722664, -0.692922, -0.747462>, <1.711101, -0.657412, -0.757584>, <1.702666, -0.630772, -0.765258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.706245, -0.832215, -0.790492>, <1.702945, -0.808522, -0.798706>, <1.697353, -0.776910, -0.809273>, <1.691544, -0.753404, -0.816584>, 
      <1.718523, -0.823557, -0.767100>, <1.715223, -0.799864, -0.775315>, <1.709014, -0.766850, -0.786186>, <1.703205, -0.743344, -0.793497>, 
      <1.740305, -0.810889, -0.737733>, <1.739584, -0.785376, -0.746801>, <1.726519, -0.753552, -0.756079>, <1.720351, -0.728373, -0.763929>, 
      <1.745162, -0.804247, -0.711178>, <1.744440, -0.778735, -0.720246>, <1.735431, -0.745039, -0.731214>, <1.729263, -0.719860, -0.739064>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.714152, -0.915744, -0.760303>, <1.711724, -0.890684, -0.769342>, <1.709735, -0.857274, -0.781805>, <1.706245, -0.832215, -0.790492>, 
      <1.720673, -0.908804, -0.735628>, <1.718244, -0.883744, -0.744666>, <1.722013, -0.848616, -0.758413>, <1.718523, -0.823557, -0.767100>, 
      <1.732390, -0.897705, -0.703456>, <1.730992, -0.870026, -0.711007>, <1.741070, -0.837945, -0.728116>, <1.740305, -0.810889, -0.737733>, 
      <1.734165, -0.893186, -0.677456>, <1.732767, -0.865506, -0.685007>, <1.745927, -0.831304, -0.701561>, <1.745162, -0.804247, -0.711178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.723704, -1.012379, -0.725509>, <1.704570, -0.988262, -0.728655>, <1.716961, -0.944734, -0.749847>, <1.714152, -0.915744, -0.760303>, 
      <1.731296, -1.007521, -0.704782>, <1.712163, -0.983404, -0.707928>, <1.723482, -0.937793, -0.725171>, <1.720673, -0.908804, -0.735628>, 
      <1.748567, -0.998513, -0.680516>, <1.729091, -0.973457, -0.678639>, <1.733936, -0.928339, -0.695099>, <1.732390, -0.897705, -0.703456>, 
      <1.754818, -0.995473, -0.659010>, <1.735342, -0.970417, -0.657133>, <1.735712, -0.923820, -0.669099>, <1.734165, -0.893186, -0.677456>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.837406, -1.071099, -0.740039>, <1.802004, -1.077349, -0.725880>, <1.747594, -1.042491, -0.721581>, <1.723704, -1.012379, -0.725509>, 
      <1.844009, -1.068671, -0.723969>, <1.808607, -1.074920, -0.709810>, <1.755186, -1.037633, -0.700855>, <1.731296, -1.007521, -0.704782>, 
      <1.858472, -1.066632, -0.705227>, <1.820469, -1.072018, -0.691471>, <1.773547, -1.030649, -0.682924>, <1.748567, -0.998513, -0.680516>, 
      <1.867500, -1.064718, -0.690308>, <1.829497, -1.070104, -0.676552>, <1.779797, -1.027608, -0.661418>, <1.754818, -0.995473, -0.659010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.889883, -0.983043, -0.791971>, <1.881753, -1.013224, -0.777430>, <1.868993, -1.065523, -0.752672>, <1.837406, -1.071099, -0.740039>, 
      <1.898955, -0.978238, -0.770043>, <1.890825, -1.008419, -0.755503>, <1.875596, -1.063095, -0.736601>, <1.844009, -1.068671, -0.723969>, 
      <1.914631, -0.975015, -0.741740>, <1.905086, -1.007022, -0.732749>, <1.890710, -1.062063, -0.716897>, <1.858472, -1.066632, -0.705227>, 
      <1.927121, -0.971054, -0.721380>, <1.917576, -1.003061, -0.712389>, <1.899738, -1.060149, -0.701978>, <1.867500, -1.064718, -0.690308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.885508, -0.892542, -0.826066>, <1.887508, -0.919729, -0.816050>, <1.896733, -0.957617, -0.804221>, <1.889883, -0.983043, -0.791971>, 
      <1.898903, -0.884903, -0.802746>, <1.900903, -0.912091, -0.792730>, <1.905805, -0.952812, -0.782294>, <1.898955, -0.978238, -0.770043>, 
      <1.910835, -0.876132, -0.767955>, <1.911949, -0.905972, -0.759092>, <1.923227, -0.946192, -0.749837>, <1.914631, -0.975015, -0.741740>, 
      <1.925581, -0.869965, -0.745017>, <1.926695, -0.899805, -0.736155>, <1.935717, -0.942231, -0.729477>, <1.927121, -0.971054, -0.721380>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.877383, -0.813099, -0.854580>, <1.882211, -0.836849, -0.846849>, <1.883756, -0.868729, -0.834839>, <1.885508, -0.892542, -0.826066>, 
      <1.889822, -0.804187, -0.831153>, <1.894649, -0.827936, -0.823422>, <1.897152, -0.861090, -0.811519>, <1.898903, -0.884903, -0.802746>, 
      <1.905691, -0.792123, -0.799490>, <1.909729, -0.817757, -0.790758>, <1.909856, -0.849902, -0.775744>, <1.910835, -0.876132, -0.767955>, 
      <1.920162, -0.784570, -0.776763>, <1.924199, -0.810204, -0.768031>, <1.924602, -0.843735, -0.752807>, <1.925581, -0.869965, -0.745017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.852983, -0.732545, -0.878149>, <1.859692, -0.756816, -0.870835>, <1.872406, -0.788618, -0.862549>, <1.877383, -0.813099, -0.854580>, 
      <1.867729, -0.722197, -0.856480>, <1.874438, -0.746468, -0.849166>, <1.884845, -0.779706, -0.839122>, <1.889822, -0.804187, -0.831153>, 
      <1.884373, -0.706909, -0.826302>, <1.891144, -0.732882, -0.818341>, <1.901563, -0.765911, -0.808419>, <1.905691, -0.792123, -0.799490>, 
      <1.898477, -0.697874, -0.803641>, <1.905248, -0.723846, -0.795679>, <1.916034, -0.758359, -0.785692>, <1.920162, -0.784570, -0.776763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.832021, -0.648986, -0.904034>, <1.837983, -0.674095, -0.896144>, <1.846079, -0.707567, -0.885676>, <1.852983, -0.732545, -0.878149>, 
      <1.843005, -0.637390, -0.880873>, <1.848968, -0.662499, -0.872983>, <1.860825, -0.697219, -0.864007>, <1.867729, -0.722197, -0.856480>, 
      <1.861056, -0.619031, -0.853237>, <1.869678, -0.645581, -0.845660>, <1.877377, -0.680075, -0.834528>, <1.884373, -0.706909, -0.826302>, 
      <1.874276, -0.608557, -0.830718>, <1.882898, -0.635108, -0.823141>, <1.891481, -0.671040, -0.811867>, <1.898477, -0.697874, -0.803641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.817595, -0.583520, -0.924976>, <1.824178, -0.602794, -0.919583>, <1.827366, -0.629382, -0.910194>, <1.832021, -0.648986, -0.904034>, 
      <1.828114, -0.571037, -0.902447>, <1.834697, -0.590311, -0.897053>, <1.838350, -0.617786, -0.887033>, <1.843005, -0.637390, -0.880873>, 
      <1.835808, -0.551003, -0.871543>, <1.843644, -0.571786, -0.865972>, <1.854230, -0.598012, -0.859235>, <1.861056, -0.619031, -0.853237>, 
      <1.847070, -0.539574, -0.848815>, <1.854906, -0.560357, -0.843244>, <1.867450, -0.587538, -0.836716>, <1.874276, -0.608557, -0.830718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.787804, -0.519528, -0.940258>, <1.802273, -0.535583, -0.938736>, <1.810825, -0.563700, -0.930522>, <1.817595, -0.583520, -0.924976>, 
      <1.795270, -0.505768, -0.916769>, <1.809739, -0.521823, -0.915247>, <1.821344, -0.551217, -0.907993>, <1.828114, -0.571037, -0.902447>, 
      <1.812472, -0.483009, -0.891063>, <1.826709, -0.500658, -0.888839>, <1.828011, -0.530325, -0.877087>, <1.835808, -0.551003, -0.871543>, 
      <1.822173, -0.470369, -0.867762>, <1.836410, -0.488018, -0.865538>, <1.839273, -0.518895, -0.854358>, <1.847070, -0.539574, -0.848815>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.787804, -0.519528, -0.940258>, <1.795270, -0.505768, -0.916769>, <1.812472, -0.483009, -0.891063>, <1.822173, -0.470369, -0.867762>, 
      <1.766562, -0.495958, -0.942492>, <1.774028, -0.482198, -0.919003>, <1.791877, -0.457478, -0.894281>, <1.801578, -0.444838, -0.870980>, 
      <1.732062, -0.451315, -0.948618>, <1.740169, -0.435925, -0.925961>, <1.756889, -0.410824, -0.901225>, <1.766381, -0.396862, -0.878185>, 
      <1.702839, -0.456187, -0.937043>, <1.710945, -0.440798, -0.914386>, <1.726649, -0.416020, -0.889187>, <1.736141, -0.402058, -0.866147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.630438, -0.565807, -0.920810>, <1.642767, -0.534933, -0.936457>, <1.661093, -0.487007, -0.968446>, <1.693574, -0.482868, -0.985116>, 
      <1.634516, -0.560008, -0.908954>, <1.646844, -0.529134, -0.924601>, <1.665611, -0.477977, -0.955111>, <1.698092, -0.473838, -0.971781>, 
      <1.632363, -0.551680, -0.891550>, <1.644081, -0.520178, -0.907795>, <1.663794, -0.470918, -0.936726>, <1.698092, -0.465199, -0.950311>, 
      <1.636389, -0.544773, -0.880285>, <1.648107, -0.513271, -0.896531>, <1.668541, -0.461905, -0.923458>, <1.702839, -0.456187, -0.937043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.633031, -0.634480, -0.908277>, <1.630622, -0.614268, -0.913262>, <1.623406, -0.583416, -0.911885>, <1.630438, -0.565807, -0.920810>, 
      <1.638201, -0.627586, -0.893323>, <1.635792, -0.607374, -0.898308>, <1.627484, -0.577618, -0.900030>, <1.634516, -0.560008, -0.908954>, 
      <1.639836, -0.618529, -0.871726>, <1.635161, -0.598866, -0.877902>, <1.625729, -0.569514, -0.882353>, <1.632363, -0.551680, -0.891550>, 
      <1.645338, -0.610766, -0.857326>, <1.640664, -0.591104, -0.863502>, <1.629755, -0.562606, -0.871088>, <1.636389, -0.544773, -0.880285>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.645613, -0.693111, -0.889411>, <1.641491, -0.675545, -0.894899>, <1.635199, -0.652669, -0.903791>, <1.633031, -0.634480, -0.908277>, 
      <1.652764, -0.686535, -0.875165>, <1.648642, -0.668969, -0.880653>, <1.640369, -0.645774, -0.888837>, <1.638201, -0.627586, -0.893323>, 
      <1.659673, -0.677422, -0.855118>, <1.653858, -0.659473, -0.860245>, <1.644160, -0.636719, -0.866011>, <1.639836, -0.618529, -0.871726>, 
      <1.666223, -0.670265, -0.840864>, <1.660409, -0.652316, -0.845991>, <1.649663, -0.628957, -0.851612>, <1.645338, -0.610766, -0.857326>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.665897, -0.774526, -0.864521>, <1.660793, -0.750030, -0.872474>, <1.651352, -0.717566, -0.881770>, <1.645613, -0.693111, -0.889411>, 
      <1.673908, -0.768202, -0.850308>, <1.668804, -0.743706, -0.858262>, <1.658503, -0.710990, -0.867525>, <1.652764, -0.686535, -0.875165>, 
      <1.684192, -0.759747, -0.831140>, <1.677975, -0.734588, -0.838966>, <1.667723, -0.702275, -0.848020>, <1.659673, -0.677422, -0.855118>, 
      <1.691544, -0.753404, -0.816584>, <1.685327, -0.728245, -0.824409>, <1.674274, -0.695118, -0.833765>, <1.666223, -0.670265, -0.840864>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.678554, -0.851216, -0.838077>, <1.673817, -0.828233, -0.845563>, <1.670685, -0.797506, -0.857060>, <1.665897, -0.774526, -0.864521>, 
      <1.686894, -0.845244, -0.823932>, <1.682158, -0.822262, -0.831418>, <1.678696, -0.791182, -0.842847>, <1.673908, -0.768202, -0.850308>, 
      <1.698528, -0.837657, -0.805194>, <1.695229, -0.813963, -0.813408>, <1.690001, -0.783253, -0.823829>, <1.684192, -0.759747, -0.831140>, 
      <1.706245, -0.832215, -0.790492>, <1.702945, -0.808522, -0.798706>, <1.697353, -0.776910, -0.809273>, <1.691544, -0.753404, -0.816584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.698236, -0.931426, -0.813414>, <1.693456, -0.907662, -0.822417>, <1.683527, -0.875344, -0.830218>, <1.678554, -0.851216, -0.838077>, 
      <1.704558, -0.926029, -0.798258>, <1.699777, -0.902265, -0.807261>, <1.691867, -0.869372, -0.816073>, <1.686894, -0.845244, -0.823932>, 
      <1.709890, -0.920280, -0.776430>, <1.707462, -0.895220, -0.785468>, <1.702018, -0.862715, -0.796506>, <1.698528, -0.837657, -0.805194>, 
      <1.714152, -0.915744, -0.760303>, <1.711724, -0.890684, -0.769342>, <1.709735, -0.857274, -0.781805>, <1.706245, -0.832215, -0.790492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.712960, -1.022256, -0.773279>, <1.693426, -0.999596, -0.776736>, <1.703804, -0.959104, -0.802928>, <1.698236, -0.931426, -0.813414>, 
      <1.717950, -1.018191, -0.759747>, <1.698416, -0.995531, -0.763204>, <1.710125, -0.953707, -0.787772>, <1.704558, -0.926029, -0.798258>, 
      <1.718670, -1.015600, -0.739251>, <1.699537, -0.991483, -0.742396>, <1.712700, -0.949269, -0.765973>, <1.709890, -0.920280, -0.776430>, 
      <1.723704, -1.012379, -0.725509>, <1.704570, -0.988262, -0.728655>, <1.716961, -0.944734, -0.749847>, <1.714152, -0.915744, -0.760303>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.826225, -1.079897, -0.790763>, <1.792537, -1.084451, -0.772721>, <1.737922, -1.051213, -0.768861>, <1.712960, -1.022256, -0.773279>, 
      <1.831620, -1.076847, -0.776225>, <1.797932, -1.081400, -0.758183>, <1.742912, -1.047148, -0.755329>, <1.717950, -1.018191, -0.759747>, 
      <1.831457, -1.073287, -0.754517>, <1.796055, -1.079536, -0.740358>, <1.742560, -1.045711, -0.735323>, <1.718670, -1.015600, -0.739251>, 
      <1.837406, -1.071099, -0.740039>, <1.802004, -1.077349, -0.725880>, <1.747594, -1.042491, -0.721581>, <1.723704, -1.012379, -0.725509>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.870697, -1.000936, -0.857754>, <1.867574, -1.029913, -0.840618>, <1.855820, -1.075897, -0.806612>, <1.826225, -1.079897, -0.790763>, 
      <1.878090, -0.994703, -0.838836>, <1.874967, -1.023679, -0.821700>, <1.861215, -1.072847, -0.792074>, <1.831620, -1.076847, -0.776225>, 
      <1.881922, -0.987259, -0.811213>, <1.873791, -1.017440, -0.796672>, <1.863044, -1.067711, -0.767150>, <1.831457, -1.073287, -0.754517>, 
      <1.889883, -0.983043, -0.791971>, <1.881753, -1.013224, -0.777430>, <1.868993, -1.065523, -0.752672>, <1.837406, -1.071099, -0.740039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.843828, -0.916584, -0.887340>, <1.847986, -0.942493, -0.877565>, <1.873284, -0.976936, -0.871947>, <1.870697, -1.000936, -0.857754>, 
      <1.856842, -0.908932, -0.869497>, <1.861000, -0.934841, -0.859722>, <1.880677, -0.970702, -0.853029>, <1.878090, -0.994703, -0.838836>, 
      <1.874309, -0.898928, -0.845562>, <1.876309, -0.926115, -0.835546>, <1.888771, -0.961833, -0.823463>, <1.881922, -0.987259, -0.811213>, 
      <1.885508, -0.892542, -0.826066>, <1.887508, -0.919729, -0.816050>, <1.896733, -0.957617, -0.804221>, <1.889883, -0.983043, -0.791971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.844654, -0.838671, -0.918974>, <1.850042, -0.862178, -0.911569>, <1.840082, -0.893242, -0.896147>, <1.843828, -0.916584, -0.887340>, 
      <1.856826, -0.830720, -0.901167>, <1.862215, -0.854228, -0.893763>, <1.853096, -0.885590, -0.878304>, <1.856842, -0.908932, -0.869497>, 
      <1.867164, -0.820421, -0.873826>, <1.871992, -0.844171, -0.866095>, <1.872558, -0.875114, -0.854335>, <1.874309, -0.898928, -0.845562>, 
      <1.877383, -0.813099, -0.854580>, <1.882211, -0.836849, -0.846849>, <1.883756, -0.868729, -0.834839>, <1.885508, -0.892542, -0.826066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.808213, -0.761214, -0.936280>, <1.813751, -0.785620, -0.928526>, <1.839058, -0.814258, -0.926664>, <1.844654, -0.838671, -0.918974>, 
      <1.822330, -0.752675, -0.919360>, <1.827868, -0.777081, -0.911606>, <1.851230, -0.806308, -0.908857>, <1.856826, -0.830720, -0.901167>, 
      <1.840616, -0.741223, -0.896322>, <1.847325, -0.765494, -0.889008>, <1.862187, -0.795940, -0.881795>, <1.867164, -0.820421, -0.873826>, 
      <1.852983, -0.732545, -0.878149>, <1.859692, -0.756816, -0.870835>, <1.872406, -0.788618, -0.862549>, <1.877383, -0.813099, -0.854580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.808251, -0.678259, -0.969937>, <1.812588, -0.703344, -0.961379>, <1.802536, -0.736196, -0.944228>, <1.808213, -0.761214, -0.936280>, 
      <1.818554, -0.669596, -0.951561>, <1.822891, -0.694680, -0.943003>, <1.816653, -0.727658, -0.927308>, <1.822330, -0.752675, -0.919360>, 
      <1.823128, -0.658374, -0.922786>, <1.829090, -0.683483, -0.914896>, <1.833712, -0.716245, -0.903849>, <1.840616, -0.741223, -0.896322>, 
      <1.832021, -0.648986, -0.904034>, <1.837983, -0.674095, -0.896144>, <1.846079, -0.707567, -0.885676>, <1.852983, -0.732545, -0.878149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.783031, -0.615567, -0.985969>, <1.787197, -0.635533, -0.981716>, <1.804886, -0.658799, -0.976576>, <1.808251, -0.678259, -0.969937>, 
      <1.795121, -0.606277, -0.968583>, <1.799288, -0.626243, -0.964329>, <1.815189, -0.650135, -0.958201>, <1.818554, -0.669596, -0.951561>, 
      <1.808852, -0.593896, -0.943702>, <1.815435, -0.613170, -0.938309>, <1.818473, -0.638771, -0.928946>, <1.823128, -0.658374, -0.922786>, 
      <1.817595, -0.583520, -0.924976>, <1.824178, -0.602794, -0.919583>, <1.827366, -0.629382, -0.910194>, <1.832021, -0.648986, -0.904034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.780788, -0.546648, -0.997971>, <1.792525, -0.564059, -0.998083>, <1.778832, -0.595445, -0.990255>, <1.783031, -0.615567, -0.985969>, 
      <1.786780, -0.538722, -0.981489>, <1.798517, -0.556133, -0.981601>, <1.790922, -0.586155, -0.972869>, <1.795121, -0.606277, -0.968583>, 
      <1.782714, -0.528910, -0.956273>, <1.797183, -0.544965, -0.954751>, <1.802082, -0.574075, -0.949248>, <1.808852, -0.593896, -0.943702>, 
      <1.787804, -0.519528, -0.940258>, <1.802273, -0.535583, -0.938736>, <1.810825, -0.563700, -0.930522>, <1.817595, -0.583520, -0.924976>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.780788, -0.546648, -0.997971>, <1.786780, -0.538722, -0.981489>, <1.782714, -0.528910, -0.956273>, <1.787804, -0.519528, -0.940258>, 
      <1.762542, -0.519582, -0.997797>, <1.768534, -0.511656, -0.981315>, <1.761472, -0.505340, -0.958506>, <1.766562, -0.495958, -0.942492>, 
      <1.722431, -0.479191, -0.999926>, <1.726949, -0.470161, -0.986590>, <1.727315, -0.460327, -0.961886>, <1.732062, -0.451315, -0.948618>, 
      <1.693574, -0.482868, -0.985116>, <1.698092, -0.473838, -0.971781>, <1.698092, -0.465199, -0.950311>, <1.702839, -0.456187, -0.937043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.611685, -0.579905, -0.952113>, <1.623190, -0.552211, -0.969134>, <1.646698, -0.511529, -0.997208>, <1.677106, -0.507616, -1.012991>, 
      <1.616410, -0.574932, -0.942591>, <1.627916, -0.547238, -0.959612>, <1.651522, -0.504901, -0.988139>, <1.681930, -0.500988, -1.003922>, 
      <1.626974, -0.570734, -0.930882>, <1.639303, -0.539860, -0.946530>, <1.657790, -0.493607, -0.978193>, <1.690272, -0.489468, -0.994863>, 
      <1.630438, -0.565807, -0.920810>, <1.642767, -0.534933, -0.936457>, <1.661093, -0.487007, -0.968446>, <1.693574, -0.482868, -0.985116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.620483, -0.643913, -0.929221>, <1.618825, -0.623754, -0.932925>, <1.604824, -0.596420, -0.941963>, <1.611685, -0.579905, -0.952113>, 
      <1.617439, -0.642686, -0.922088>, <1.615781, -0.622526, -0.925791>, <1.609549, -0.591448, -0.932440>, <1.616410, -0.574932, -0.942591>, 
      <1.630679, -0.637617, -0.915080>, <1.628270, -0.617405, -0.920066>, <1.619942, -0.588343, -0.921958>, <1.626974, -0.570734, -0.930882>, 
      <1.633031, -0.634480, -0.908277>, <1.630622, -0.614268, -0.913262>, <1.623406, -0.583416, -0.911885>, <1.630438, -0.565807, -0.920810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.622427, -0.710540, -0.928113>, <1.619501, -0.691054, -0.931535>, <1.622095, -0.663519, -0.925619>, <1.620483, -0.643913, -0.929221>, 
      <1.629091, -0.704105, -0.916945>, <1.626165, -0.684619, -0.920367>, <1.619051, -0.662292, -0.918486>, <1.617439, -0.642686, -0.922088>, 
      <1.639596, -0.698645, -0.901398>, <1.635473, -0.681079, -0.906887>, <1.632847, -0.655806, -0.910594>, <1.630679, -0.637617, -0.915080>, 
      <1.645613, -0.693111, -0.889411>, <1.641491, -0.675545, -0.894899>, <1.635199, -0.652669, -0.903791>, <1.633031, -0.634480, -0.908277>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.642712, -0.791955, -0.903223>, <1.637609, -0.767459, -0.911176>, <1.626268, -0.736121, -0.923621>, <1.622427, -0.710540, -0.928113>, 
      <1.638749, -0.789044, -0.889572>, <1.633646, -0.764549, -0.897526>, <1.632932, -0.729687, -0.912453>, <1.629091, -0.704105, -0.916945>, 
      <1.659254, -0.779770, -0.876306>, <1.654151, -0.755274, -0.884260>, <1.645335, -0.723099, -0.893758>, <1.639596, -0.698645, -0.901398>, 
      <1.665897, -0.774526, -0.864521>, <1.660793, -0.750030, -0.872474>, <1.651352, -0.717566, -0.881770>, <1.645613, -0.693111, -0.889411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.655367, -0.868644, -0.876778>, <1.650243, -0.845966, -0.884910>, <1.647500, -0.814935, -0.895762>, <1.642712, -0.791955, -0.903223>, 
      <1.662789, -0.863027, -0.865647>, <1.657665, -0.840350, -0.873779>, <1.643537, -0.812024, -0.882111>, <1.638749, -0.789044, -0.889572>, 
      <1.671628, -0.856175, -0.849823>, <1.666891, -0.833192, -0.857309>, <1.664042, -0.802750, -0.868845>, <1.659254, -0.779770, -0.876306>, 
      <1.678554, -0.851216, -0.838077>, <1.673817, -0.828233, -0.845563>, <1.670685, -0.797506, -0.857060>, <1.665897, -0.774526, -0.864521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.677709, -0.946855, -0.847676>, <1.672199, -0.923685, -0.857896>, <1.660758, -0.892506, -0.868221>, <1.655367, -0.868644, -0.876778>, 
      <1.673386, -0.944737, -0.835767>, <1.667876, -0.921566, -0.845986>, <1.668180, -0.886889, -0.857090>, <1.662789, -0.863027, -0.865647>, 
      <1.693538, -0.935436, -0.824677>, <1.688758, -0.911672, -0.833680>, <1.676601, -0.880302, -0.841964>, <1.671628, -0.856175, -0.849823>, 
      <1.698236, -0.931426, -0.813414>, <1.693456, -0.907662, -0.822417>, <1.683527, -0.875344, -0.830218>, <1.678554, -0.851216, -0.838077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.695093, -1.035687, -0.803102>, <1.674915, -1.013439, -0.806851>, <1.684145, -0.973917, -0.835740>, <1.677709, -0.946855, -0.847676>, 
      <1.700453, -1.031658, -0.794155>, <1.680275, -1.009409, -0.797904>, <1.679822, -0.971798, -0.823831>, <1.673386, -0.944737, -0.835767>, 
      <1.709237, -1.025289, -0.783376>, <1.689703, -1.002629, -0.786833>, <1.699106, -0.963114, -0.814191>, <1.693538, -0.935436, -0.824677>, 
      <1.712960, -1.022256, -0.773279>, <1.693426, -0.999596, -0.776736>, <1.703804, -0.959104, -0.802928>, <1.698236, -0.931426, -0.813414>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.806330, -1.088669, -0.823779>, <1.773679, -1.092969, -0.805886>, <1.720079, -1.063235, -0.798460>, <1.695093, -1.035687, -0.803102>, 
      <1.811886, -1.085779, -0.813708>, <1.779234, -1.090078, -0.795815>, <1.725439, -1.059206, -0.789513>, <1.700453, -1.031658, -0.794155>, 
      <1.822176, -1.082186, -0.801673>, <1.788488, -1.086740, -0.783631>, <1.734199, -1.054246, -0.778959>, <1.709237, -1.025289, -0.783376>, 
      <1.826225, -1.079897, -0.790763>, <1.792537, -1.084451, -0.772721>, <1.737922, -1.051213, -0.768861>, <1.712960, -1.022256, -0.773279>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.851943, -1.015033, -0.889056>, <1.849977, -1.042726, -0.872085>, <1.834676, -1.084936, -0.839313>, <1.806330, -1.088669, -0.823779>, 
      <1.856815, -1.010066, -0.879606>, <1.854850, -1.037759, -0.862635>, <1.840232, -1.082046, -0.829241>, <1.811886, -1.085779, -0.813708>, 
      <1.866613, -1.004379, -0.868204>, <1.863490, -1.033356, -0.851068>, <1.851771, -1.078186, -0.817522>, <1.822176, -1.082186, -0.801673>, 
      <1.870697, -1.000936, -0.857754>, <1.867574, -1.029913, -0.840618>, <1.855820, -1.075897, -0.806612>, <1.826225, -1.079897, -0.790763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.817410, -0.932581, -0.919432>, <1.824203, -0.958043, -0.909052>, <1.853654, -0.990927, -0.903828>, <1.851943, -1.015033, -0.889056>, 
      <1.829408, -0.928610, -0.915093>, <1.836201, -0.954072, -0.904713>, <1.858527, -0.985960, -0.894378>, <1.856815, -1.010066, -0.879606>, 
      <1.836388, -0.920958, -0.897540>, <1.840546, -0.946867, -0.887765>, <1.869200, -0.980379, -0.882396>, <1.866613, -1.004379, -0.868204>, 
      <1.843828, -0.916584, -0.887340>, <1.847986, -0.942493, -0.877565>, <1.873284, -0.976936, -0.871947>, <1.870697, -1.000936, -0.857754>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.809838, -0.857218, -0.953392>, <1.816131, -0.880033, -0.945647>, <1.811437, -0.910195, -0.928558>, <1.817410, -0.932581, -0.919432>, 
      <1.819036, -0.851164, -0.942193>, <1.825329, -0.873979, -0.934448>, <1.823435, -0.906224, -0.924219>, <1.829408, -0.928610, -0.915093>, 
      <1.836338, -0.844103, -0.931140>, <1.841726, -0.867610, -0.923735>, <1.832642, -0.897616, -0.906347>, <1.836388, -0.920958, -0.897540>, 
      <1.844654, -0.838671, -0.918974>, <1.850042, -0.862178, -0.911569>, <1.840082, -0.893242, -0.896147>, <1.843828, -0.916584, -0.887340>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.775210, -0.779586, -0.971365>, <1.780427, -0.803896, -0.963542>, <1.803251, -0.833337, -0.961498>, <1.809838, -0.857218, -0.953392>, 
      <1.788657, -0.774753, -0.965448>, <1.793874, -0.799063, -0.957626>, <1.812449, -0.827283, -0.950299>, <1.819036, -0.851164, -0.942193>, 
      <1.798974, -0.766802, -0.947353>, <1.804513, -0.791208, -0.939599>, <1.830742, -0.819690, -0.938829>, <1.836338, -0.844103, -0.931140>, 
      <1.808213, -0.761214, -0.936280>, <1.813751, -0.785620, -0.928526>, <1.839058, -0.814258, -0.926664>, <1.844654, -0.838671, -0.918974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.775374, -0.696620, -1.005069>, <1.777516, -0.722816, -0.999508>, <1.769833, -0.754530, -0.979428>, <1.775210, -0.779586, -0.971365>, 
      <1.782223, -0.688232, -0.994049>, <1.784365, -0.714428, -0.988489>, <1.783280, -0.749696, -0.973511>, <1.788657, -0.774753, -0.965448>, 
      <1.801263, -0.684135, -0.982401>, <1.805600, -0.709220, -0.973843>, <1.793297, -0.741784, -0.955301>, <1.798974, -0.766802, -0.947353>, 
      <1.808251, -0.678259, -0.969937>, <1.812588, -0.703344, -0.961379>, <1.802536, -0.736196, -0.944228>, <1.808213, -0.761214, -0.936280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.762630, -0.625754, -1.004019>, <1.765619, -0.646871, -1.000576>, <1.773651, -0.675555, -1.009541>, <1.775374, -0.696620, -1.005069>, 
      <1.770577, -0.622916, -1.001804>, <1.773566, -0.644033, -0.998361>, <1.780501, -0.667167, -0.998521>, <1.782223, -0.688232, -0.994049>, 
      <1.778470, -0.619072, -0.992529>, <1.782636, -0.639038, -0.988276>, <1.797898, -0.664675, -0.989040>, <1.801263, -0.684135, -0.982401>, 
      <1.783031, -0.615567, -0.985969>, <1.787197, -0.635533, -0.981716>, <1.804886, -0.658799, -0.976576>, <1.808251, -0.678259, -0.969937>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.756221, -0.561305, -1.027133>, <1.768296, -0.577985, -1.025866>, <1.759776, -0.605588, -1.007307>, <1.762630, -0.625754, -1.004019>, 
      <1.762479, -0.555720, -1.018198>, <1.774554, -0.572399, -1.016931>, <1.767723, -0.602751, -1.005092>, <1.770577, -0.622916, -1.001804>, 
      <1.776972, -0.551695, -1.008467>, <1.788709, -0.569106, -1.008579>, <1.774271, -0.598950, -0.996815>, <1.778470, -0.619072, -0.992529>, 
      <1.780788, -0.546648, -0.997971>, <1.792525, -0.564059, -0.998083>, <1.778832, -0.595445, -0.990255>, <1.783031, -0.615567, -0.985969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.756221, -0.561305, -1.027133>, <1.762479, -0.555720, -1.018198>, <1.776972, -0.551695, -1.008467>, <1.780788, -0.546648, -0.997971>, 
      <1.739250, -0.537862, -1.028913>, <1.745508, -0.532277, -1.019978>, <1.758726, -0.524629, -1.008293>, <1.762542, -0.519582, -0.997797>, 
      <1.702675, -0.504325, -1.026263>, <1.707500, -0.497697, -1.017193>, <1.719128, -0.485791, -1.009672>, <1.722431, -0.479191, -0.999926>, 
      <1.677106, -0.507616, -1.012991>, <1.681930, -0.500988, -1.003922>, <1.690272, -0.489468, -0.994863>, <1.693574, -0.482868, -0.985116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.673358, -1.052025, -0.839381>, <1.659710, -1.014190, -0.857963>, <1.699296, -0.955654, -0.905812>, <1.738849, -0.951329, -0.925304>, 
      <1.677834, -1.049526, -0.826783>, <1.664186, -1.011691, -0.845365>, <1.673009, -0.958340, -0.892310>, <1.712561, -0.954015, -0.911802>, 
      <1.688573, -1.040588, -0.813986>, <1.668394, -1.018340, -0.817735>, <1.694131, -0.978811, -0.863252>, <1.687695, -0.951749, -0.875188>, 
      <1.695093, -1.035687, -0.803102>, <1.674915, -1.013439, -0.806851>, <1.684145, -0.973917, -0.835740>, <1.677709, -0.946855, -0.847676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.673358, -1.052025, -0.839381>, <1.665052, -1.056663, -0.862757>, <1.660114, -1.053516, -0.897115>, <1.653280, -1.059032, -0.920776>, 
      <1.659710, -1.014190, -0.857963>, <1.651403, -1.018828, -0.881339>, <1.649282, -1.015392, -0.909781>, <1.642448, -1.020908, -0.933442>, 
      <1.699296, -0.955654, -0.905812>, <1.698504, -0.957971, -0.904960>, <1.682490, -0.984911, -0.942752>, <1.673920, -0.994997, -0.960006>, 
      <1.738849, -0.951329, -0.925304>, <1.738056, -0.953647, -0.924452>, <1.719528, -0.981592, -0.961417>, <1.710958, -0.991679, -0.978670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.791706, -1.097855, -0.853341>, <1.778498, -1.104299, -0.878403>, <1.760829, -1.108744, -0.913009>, <1.746770, -1.117727, -0.936794>, 
      <1.757512, -1.101594, -0.836490>, <1.744304, -1.108038, -0.861552>, <1.721817, -1.112239, -0.893350>, <1.707758, -1.121222, -0.917135>, 
      <1.685157, -1.084734, -0.823317>, <1.676851, -1.089371, -0.846693>, <1.671523, -1.093672, -0.883775>, <1.664689, -1.099188, -0.907435>, 
      <1.673358, -1.052025, -0.839381>, <1.665052, -1.056663, -0.862757>, <1.660114, -1.053516, -0.897115>, <1.653280, -1.059032, -0.920776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.791706, -1.097855, -0.853341>, <1.757512, -1.101594, -0.836490>, <1.685157, -1.084734, -0.823317>, <1.673358, -1.052025, -0.839381>, 
      <1.796375, -1.095577, -0.844481>, <1.762182, -1.099315, -0.827630>, <1.689633, -1.082234, -0.810719>, <1.677834, -1.049526, -0.826783>, 
      <1.801519, -1.091172, -0.832501>, <1.768867, -1.095471, -0.814608>, <1.713558, -1.068137, -0.809344>, <1.688573, -1.040588, -0.813986>, 
      <1.806330, -1.088669, -0.823779>, <1.773679, -1.092969, -0.805886>, <1.720079, -1.063235, -0.798460>, <1.695093, -1.035687, -0.803102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.838269, -1.033994, -0.920651>, <1.844649, -1.030911, -0.911227>, <1.847048, -1.020024, -0.898551>, <1.851943, -1.015033, -0.889056>, 
      <1.826312, -1.000849, -0.936929>, <1.832692, -0.997765, -0.927505>, <1.848759, -0.995918, -0.913323>, <1.853654, -0.990927, -0.903828>, 
      <1.773499, -0.947540, -0.942380>, <1.795020, -0.945341, -0.953434>, <1.802389, -0.965263, -0.916941>, <1.824203, -0.958043, -0.909052>, 
      <1.738849, -0.951329, -0.925304>, <1.760370, -0.949130, -0.936358>, <1.795596, -0.939801, -0.927321>, <1.817410, -0.932581, -0.919432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.838269, -1.033994, -0.920651>, <1.826312, -1.000849, -0.936929>, <1.773499, -0.947540, -0.942380>, <1.738849, -0.951329, -0.925304>, 
      <1.824287, -1.040752, -0.941304>, <1.812331, -1.007606, -0.957582>, <1.772706, -0.949858, -0.941528>, <1.738056, -0.953647, -0.924452>, 
      <1.799687, -1.038893, -0.967488>, <1.790147, -1.005317, -0.978643>, <1.752148, -0.978670, -0.977855>, <1.719528, -0.981592, -0.961417>, 
      <1.785398, -1.047195, -0.987353>, <1.775859, -1.013619, -0.998508>, <1.743578, -0.988757, -0.995108>, <1.710958, -0.991679, -0.978670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.838269, -1.033994, -0.920651>, <1.824287, -1.040752, -0.941304>, <1.799687, -1.038893, -0.967488>, <1.785398, -1.047195, -0.987353>, 
      <1.847863, -1.060589, -0.907590>, <1.833881, -1.067346, -0.928242>, <1.809403, -1.073090, -0.956128>, <1.795114, -1.081392, -0.975992>, 
      <1.819508, -1.094815, -0.867042>, <1.806300, -1.101259, -0.892104>, <1.794051, -1.105767, -0.929751>, <1.779993, -1.114751, -0.953535>, 
      <1.791706, -1.097855, -0.853341>, <1.778498, -1.104299, -0.878403>, <1.760829, -1.108744, -0.913009>, <1.746770, -1.117727, -0.936794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.838269, -1.033994, -0.920651>, <1.847863, -1.060589, -0.907590>, <1.819508, -1.094815, -0.867042>, <1.791706, -1.097855, -0.853341>, 
      <1.844649, -1.030911, -0.911227>, <1.854243, -1.057505, -0.898165>, <1.824178, -1.092537, -0.858182>, <1.796375, -1.095577, -0.844481>, 
      <1.847048, -1.020024, -0.898551>, <1.845082, -1.047716, -0.881581>, <1.829865, -1.087439, -0.848035>, <1.801519, -1.091172, -0.832501>, 
      <1.851943, -1.015033, -0.889056>, <1.849977, -1.042726, -0.872085>, <1.834676, -1.084936, -0.839313>, <1.806330, -1.088669, -0.823779>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.629392, -0.888422, -0.911810>, <1.633969, -0.882762, -0.899425>, <1.648019, -0.874205, -0.887799>, <1.655367, -0.868644, -0.876778>, 
      <1.638155, -0.923008, -0.898474>, <1.642732, -0.917348, -0.886089>, <1.653410, -0.898067, -0.879242>, <1.660758, -0.892506, -0.868221>, 
      <1.704587, -0.954031, -0.908884>, <1.678299, -0.956717, -0.895381>, <1.682185, -0.928578, -0.885408>, <1.672199, -0.923685, -0.857896>, 
      <1.738849, -0.951329, -0.925304>, <1.712561, -0.954015, -0.911802>, <1.687695, -0.951749, -0.875188>, <1.677709, -0.946855, -0.847676>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.629392, -0.888422, -0.911810>, <1.638155, -0.923008, -0.898474>, <1.704587, -0.954031, -0.908884>, <1.738849, -0.951329, -0.925304>, 
      <1.623536, -0.895663, -0.927656>, <1.632299, -0.930249, -0.914321>, <1.705334, -0.951848, -0.909687>, <1.739596, -0.949146, -0.926107>, 
      <1.625751, -0.904546, -0.951551>, <1.636657, -0.947226, -0.938630>, <1.684118, -0.975498, -0.946022>, <1.725002, -0.971819, -0.966575>, 
      <1.621504, -0.910517, -0.968408>, <1.632410, -0.953197, -0.955486>, <1.674732, -0.981741, -0.963124>, <1.715616, -0.978061, -0.983678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.788080, -0.875909, -0.987861>, <1.795649, -0.905781, -0.976343>, <1.768441, -0.948995, -0.939486>, <1.738849, -0.951329, -0.925304>, 
      <1.795122, -0.870716, -0.977642>, <1.802691, -0.900588, -0.966124>, <1.789963, -0.946797, -0.950540>, <1.760370, -0.949130, -0.936358>, 
      <1.801960, -0.862404, -0.962985>, <1.808253, -0.885219, -0.955240>, <1.789623, -0.917414, -0.936447>, <1.795596, -0.939801, -0.927321>, 
      <1.809838, -0.857218, -0.953392>, <1.816131, -0.880033, -0.945647>, <1.811437, -0.910195, -0.928558>, <1.817410, -0.932581, -0.919432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.788080, -0.875909, -0.987861>, <1.778264, -0.883148, -1.002106>, <1.763730, -0.892180, -1.020391>, <1.753694, -0.898620, -1.034864>, 
      <1.795649, -0.905781, -0.976343>, <1.785832, -0.913020, -0.990588>, <1.773239, -0.929396, -1.009123>, <1.763204, -0.935836, -1.023596>, 
      <1.768441, -0.948995, -0.939486>, <1.769188, -0.946812, -0.940289>, <1.760653, -0.968610, -0.984498>, <1.751266, -0.974853, -1.001600>, 
      <1.738849, -0.951329, -0.925304>, <1.739596, -0.949146, -0.926107>, <1.725002, -0.971819, -0.966575>, <1.715616, -0.978061, -0.983678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.700490, -0.799933, -0.983679>, <1.674069, -0.802399, -0.970091>, <1.650855, -0.797936, -0.931271>, <1.642712, -0.791955, -0.903223>, 
      <1.664235, -0.802792, -0.966304>, <1.637814, -0.805258, -0.952716>, <1.655642, -0.820915, -0.923810>, <1.647500, -0.814935, -0.895762>, 
      <1.620119, -0.851824, -0.925921>, <1.624696, -0.846164, -0.913536>, <1.642895, -0.851527, -0.895931>, <1.650243, -0.845966, -0.884910>, 
      <1.629392, -0.888422, -0.911810>, <1.633969, -0.882762, -0.899425>, <1.648019, -0.874205, -0.887799>, <1.655367, -0.868644, -0.876778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.700490, -0.799933, -0.983679>, <1.731800, -0.797464, -0.998684>, <1.780072, -0.844303, -1.000047>, <1.788080, -0.875909, -0.987861>, 
      <1.721338, -0.797987, -0.994401>, <1.752648, -0.795518, -1.009406>, <1.787114, -0.839110, -0.989829>, <1.795122, -0.870716, -0.977642>, 
      <1.754757, -0.786938, -0.980365>, <1.759974, -0.811248, -0.972542>, <1.795373, -0.838523, -0.971091>, <1.801960, -0.862404, -0.962985>, 
      <1.775210, -0.779586, -0.971365>, <1.780427, -0.803896, -0.963542>, <1.803251, -0.833337, -0.961498>, <1.809838, -0.857218, -0.953392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.676853, -0.826357, -1.029608>, <1.683604, -0.818302, -1.015733>, <1.700207, -0.801282, -0.982772>, <1.700490, -0.799933, -0.983679>, 
      <1.635612, -0.830069, -1.008875>, <1.642363, -0.822014, -0.995000>, <1.663952, -0.804141, -0.965396>, <1.664235, -0.802792, -0.966304>, 
      <1.610503, -0.867464, -0.981443>, <1.614750, -0.861493, -0.964586>, <1.614263, -0.859065, -0.941768>, <1.620119, -0.851824, -0.925921>, 
      <1.621504, -0.910517, -0.968408>, <1.625751, -0.904546, -0.951551>, <1.623536, -0.895663, -0.927656>, <1.629392, -0.888422, -0.911810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.676853, -0.826357, -1.029608>, <1.713807, -0.823031, -1.048186>, <1.743837, -0.860042, -1.046544>, <1.753694, -0.898620, -1.034864>, 
      <1.683604, -0.818302, -1.015733>, <1.720558, -0.814976, -1.034311>, <1.753873, -0.853602, -1.032070>, <1.763730, -0.892180, -1.020391>, 
      <1.700207, -0.801282, -0.982772>, <1.731517, -0.798813, -0.997777>, <1.770256, -0.851542, -1.014292>, <1.778264, -0.883148, -1.002106>, 
      <1.700490, -0.799933, -0.983679>, <1.731800, -0.797464, -0.998684>, <1.780072, -0.844303, -1.000047>, <1.788080, -0.875909, -0.987861>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.604106, -0.733193, -0.958972>, <1.608279, -0.728031, -0.948107>, <1.616580, -0.716186, -0.937912>, <1.622427, -0.710540, -0.928113>, 
      <1.609281, -0.767978, -0.951546>, <1.613454, -0.762816, -0.940682>, <1.620421, -0.741768, -0.933420>, <1.626268, -0.736121, -0.923621>, 
      <1.668094, -0.800713, -0.968128>, <1.641674, -0.803179, -0.954540>, <1.645751, -0.773440, -0.939225>, <1.637609, -0.767459, -0.911176>, 
      <1.700490, -0.799933, -0.983679>, <1.674069, -0.802399, -0.970091>, <1.650855, -0.797936, -0.931271>, <1.642712, -0.791955, -0.903223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.604106, -0.733193, -0.958972>, <1.609281, -0.767978, -0.951546>, <1.668094, -0.800713, -0.968128>, <1.700490, -0.799933, -0.983679>, 
      <1.597524, -0.741336, -0.976109>, <1.602699, -0.776120, -0.968684>, <1.668386, -0.799320, -0.969065>, <1.700782, -0.798541, -0.984616>, 
      <1.592894, -0.748214, -1.001943>, <1.603593, -0.788869, -0.989778>, <1.648760, -0.812136, -1.003345>, <1.687735, -0.808628, -1.022939>, 
      <1.587066, -0.754283, -1.020178>, <1.597765, -0.794938, -1.008013>, <1.640496, -0.817379, -1.018415>, <1.679471, -0.813871, -1.038009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.766589, -0.729283, -1.036969>, <1.771360, -0.761352, -1.030123>, <1.730356, -0.799214, -0.998016>, <1.700490, -0.799933, -0.983679>, 
      <1.773765, -0.723430, -1.026539>, <1.778537, -0.755499, -1.019693>, <1.751204, -0.797268, -1.008737>, <1.721338, -0.797987, -0.994401>, 
      <1.769191, -0.704193, -1.015017>, <1.771333, -0.730389, -1.009457>, <1.749380, -0.761881, -0.988427>, <1.754757, -0.786938, -0.980365>, 
      <1.775374, -0.696620, -1.005069>, <1.777516, -0.722816, -0.999508>, <1.769833, -0.754530, -0.979428>, <1.775210, -0.779586, -0.971365>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.766589, -0.729283, -1.036969>, <1.755808, -0.738076, -1.052639>, <1.731348, -0.736242, -1.070662>, <1.719256, -0.742387, -1.086634>, 
      <1.771360, -0.761352, -1.030123>, <1.760579, -0.770144, -1.045793>, <1.740489, -0.770977, -1.060269>, <1.728397, -0.777123, -1.076241>, 
      <1.730356, -0.799214, -0.998016>, <1.730648, -0.797822, -0.998953>, <1.721035, -0.805632, -1.039680>, <1.712771, -0.810874, -1.054750>, 
      <1.700490, -0.799933, -0.983679>, <1.700782, -0.798541, -0.984616>, <1.687735, -0.808628, -1.022939>, <1.679471, -0.813871, -1.038009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.678607, -0.652855, -1.015076>, <1.651154, -0.656362, -1.000630>, <1.632586, -0.648793, -0.957582>, <1.620483, -0.643913, -0.929221>, 
      <1.645323, -0.653656, -0.999099>, <1.617870, -0.657163, -0.984653>, <1.634198, -0.668399, -0.953980>, <1.622095, -0.663519, -0.925619>, 
      <1.598789, -0.697455, -0.966601>, <1.602961, -0.692293, -0.955737>, <1.613654, -0.696700, -0.941334>, <1.619501, -0.691054, -0.931535>, 
      <1.604106, -0.733193, -0.958972>, <1.608279, -0.728031, -0.948107>, <1.616580, -0.716186, -0.937912>, <1.622427, -0.710540, -0.928113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.678607, -0.652855, -1.015076>, <1.710670, -0.652083, -1.030467>, <1.761467, -0.694855, -1.044318>, <1.766589, -0.729283, -1.036969>, 
      <1.702079, -0.649856, -1.027427>, <1.734142, -0.649085, -1.042818>, <1.768643, -0.689002, -1.033888>, <1.773765, -0.723430, -1.026539>, 
      <1.738316, -0.634436, -1.010796>, <1.741305, -0.655553, -1.007353>, <1.767468, -0.683128, -1.019489>, <1.769191, -0.704193, -1.015017>, 
      <1.762630, -0.625754, -1.004019>, <1.765619, -0.646871, -1.000576>, <1.773651, -0.675555, -1.009541>, <1.775374, -0.696620, -1.005069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.645829, -0.686036, -1.076259>, <1.655517, -0.677569, -1.057098>, <1.677493, -0.659513, -1.011691>, <1.678607, -0.652855, -1.015076>, 
      <1.608707, -0.689377, -1.057596>, <1.618394, -0.680910, -1.038435>, <1.644209, -0.660314, -0.995713>, <1.645323, -0.653656, -0.999099>, 
      <1.576876, -0.715561, -1.031764>, <1.582703, -0.709491, -1.013529>, <1.592206, -0.705597, -0.983738>, <1.598789, -0.697455, -0.966601>, 
      <1.587066, -0.754283, -1.020178>, <1.592894, -0.748214, -1.001943>, <1.597524, -0.741336, -0.976109>, <1.604106, -0.733193, -0.958972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.645829, -0.686036, -1.076259>, <1.678418, -0.683103, -1.092643>, <1.710310, -0.708393, -1.096806>, <1.719256, -0.742387, -1.086634>, 
      <1.655517, -0.677569, -1.057098>, <1.688106, -0.674637, -1.073481>, <1.722402, -0.702248, -1.080833>, <1.731348, -0.736242, -1.070662>, 
      <1.677493, -0.659513, -1.011691>, <1.709556, -0.658742, -1.027082>, <1.750686, -0.703648, -1.059988>, <1.755808, -0.738076, -1.052639>, 
      <1.678607, -0.652855, -1.015076>, <1.710670, -0.652083, -1.030467>, <1.761467, -0.694855, -1.044318>, <1.766589, -0.729283, -1.036969>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.599469, -0.598396, -0.983217>, <1.603204, -0.594676, -0.973044>, <1.607072, -0.584760, -0.961409>, <1.611685, -0.579905, -0.952113>, 
      <1.602236, -0.628251, -0.978427>, <1.605971, -0.624531, -0.968254>, <1.600211, -0.601275, -0.951259>, <1.604824, -0.596420, -0.941963>, 
      <1.651715, -0.655871, -1.001305>, <1.624262, -0.659378, -0.986859>, <1.630928, -0.628633, -0.961286>, <1.618825, -0.623754, -0.932925>, 
      <1.678607, -0.652855, -1.015076>, <1.651154, -0.656362, -1.000630>, <1.632586, -0.648793, -0.957582>, <1.620483, -0.643913, -0.929221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.599469, -0.598396, -0.983217>, <1.602236, -0.628251, -0.978427>, <1.651715, -0.655871, -1.001305>, <1.678607, -0.652855, -1.015076>, 
      <1.590526, -0.607304, -1.007574>, <1.593292, -0.637159, -1.002783>, <1.652836, -0.649172, -1.004711>, <1.679728, -0.646156, -1.018482>, 
      <1.576908, -0.615424, -1.040764>, <1.585523, -0.650181, -1.031207>, <1.625561, -0.667937, -1.047440>, <1.658592, -0.665014, -1.063993>, 
      <1.569695, -0.621730, -1.066470>, <1.578310, -0.656487, -1.056913>, <1.615374, -0.673568, -1.067532>, <1.648405, -0.670645, -1.084085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.740529, -0.582576, -1.055450>, <1.743317, -0.612663, -1.050623>, <1.705708, -0.649816, -1.028954>, <1.678607, -0.652855, -1.015076>, 
      <1.746971, -0.578103, -1.046875>, <1.749759, -0.608190, -1.042047>, <1.729181, -0.646817, -1.041305>, <1.702079, -0.649856, -1.027427>, 
      <1.750287, -0.566601, -1.035606>, <1.762362, -0.583280, -1.034339>, <1.735461, -0.614271, -1.014085>, <1.738316, -0.634436, -1.010796>, 
      <1.756221, -0.561305, -1.027133>, <1.768296, -0.577985, -1.025866>, <1.759776, -0.605588, -1.007307>, <1.762630, -0.625754, -1.004019>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.740529, -0.582576, -1.055450>, <1.725002, -0.593358, -1.076119>, <1.699493, -0.603430, -1.101965>, <1.683736, -0.611637, -1.123619>, 
      <1.743317, -0.612663, -1.050623>, <1.727790, -0.623445, -1.071291>, <1.706738, -0.632660, -1.093928>, <1.690981, -0.640867, -1.115582>, 
      <1.705708, -0.649816, -1.028954>, <1.706830, -0.643117, -1.032360>, <1.686371, -0.662556, -1.077913>, <1.676183, -0.668187, -1.098005>, 
      <1.678607, -0.652855, -1.015076>, <1.679728, -0.646156, -1.018482>, <1.658592, -0.665014, -1.063993>, <1.648405, -0.670645, -1.084085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666324, -0.520308, -1.036343>, <1.635578, -0.523756, -1.020599>, <1.596306, -0.564263, -0.988694>, <1.599469, -0.598396, -0.983217>, 
      <1.653560, -0.533739, -1.059644>, <1.622814, -0.537188, -1.043900>, <1.587363, -0.573171, -1.013050>, <1.590526, -0.607304, -1.007574>, 
      <1.634546, -0.554457, -1.088182>, <1.602990, -0.557250, -1.072369>, <1.568677, -0.582219, -1.049895>, <1.576908, -0.615424, -1.040764>, 
      <1.622291, -0.565295, -1.113054>, <1.590735, -0.568088, -1.097240>, <1.561464, -0.588525, -1.075601>, <1.569695, -0.621730, -1.066470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666324, -0.520308, -1.036343>, <1.670013, -0.516426, -1.029608>, <1.673711, -0.512281, -1.019374>, <1.677106, -0.507616, -1.012991>, 
      <1.635578, -0.523756, -1.020599>, <1.639267, -0.519874, -1.013864>, <1.643303, -0.516194, -1.003591>, <1.646698, -0.511529, -0.997208>, 
      <1.596306, -0.564263, -0.988694>, <1.600041, -0.560542, -0.978521>, <1.618577, -0.557065, -0.978431>, <1.623190, -0.552211, -0.969134>, 
      <1.599469, -0.598396, -0.983217>, <1.603204, -0.594676, -0.973044>, <1.607072, -0.584760, -0.961409>, <1.611685, -0.579905, -0.952113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666324, -0.520308, -1.036343>, <1.653560, -0.533739, -1.059644>, <1.634546, -0.554457, -1.088182>, <1.622291, -0.565295, -1.113054>, 
      <1.692559, -0.517366, -1.049777>, <1.679794, -0.530797, -1.073078>, <1.661748, -0.552050, -1.101814>, <1.649493, -0.562888, -1.126686>, 
      <1.737830, -0.553451, -1.060123>, <1.722303, -0.564233, -1.080791>, <1.692398, -0.574807, -1.109836>, <1.676641, -0.583014, -1.131490>, 
      <1.740529, -0.582576, -1.055450>, <1.725002, -0.593358, -1.076119>, <1.699493, -0.603430, -1.101965>, <1.683736, -0.611637, -1.123619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666324, -0.520308, -1.036343>, <1.692559, -0.517366, -1.049777>, <1.737830, -0.553451, -1.060123>, <1.740529, -0.582576, -1.055450>, 
      <1.670013, -0.516426, -1.029608>, <1.696248, -0.513484, -1.043042>, <1.744272, -0.548978, -1.051548>, <1.746971, -0.578103, -1.046875>, 
      <1.673711, -0.512281, -1.019374>, <1.699280, -0.508991, -1.032646>, <1.733316, -0.543158, -1.037386>, <1.750287, -0.566601, -1.035606>, 
      <1.677106, -0.507616, -1.012991>, <1.702675, -0.504325, -1.026263>, <1.739250, -0.537862, -1.028913>, <1.756221, -0.561305, -1.027133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.633067, -1.084548, -0.978882>, <1.642352, -1.073779, -0.956914>, <1.647870, -1.063399, -0.939508>, <1.653280, -1.059032, -0.920776>, 
      <1.640414, -1.122792, -0.964964>, <1.649699, -1.112023, -0.942996>, <1.659279, -1.103555, -0.926167>, <1.664689, -1.099188, -0.907435>, 
      <1.675304, -1.152543, -0.983163>, <1.695431, -1.133835, -0.951246>, <1.692196, -1.131166, -0.943462>, <1.707758, -1.121222, -0.917135>, 
      <1.693554, -1.160571, -1.019395>, <1.713681, -1.141863, -0.987478>, <1.731209, -1.127670, -0.963121>, <1.746770, -1.117727, -0.936794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.669122, -1.033396, -1.065679>, <1.689633, -1.017369, -1.033586>, <1.698523, -1.006314, -1.003704>, <1.710958, -0.991679, -0.978670>, 
      <1.650569, -1.025235, -1.028845>, <1.671079, -1.009208, -0.996753>, <1.661485, -1.009633, -0.985039>, <1.673920, -0.994997, -0.960006>, 
      <1.625598, -1.045669, -0.993031>, <1.634883, -1.034900, -0.971064>, <1.637038, -1.025275, -0.952174>, <1.642448, -1.020908, -0.933442>, 
      <1.633067, -1.084548, -0.978882>, <1.642352, -1.073779, -0.956914>, <1.647870, -1.063399, -0.939508>, <1.653280, -1.059032, -0.920776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.700329, -1.114135, -1.112416>, <1.736924, -1.087227, -1.065940>, <1.757958, -1.063137, -1.025500>, <1.785398, -1.047195, -0.987353>, 
      <1.693462, -1.078394, -1.125424>, <1.730057, -1.051485, -1.078948>, <1.748419, -1.029561, -1.036655>, <1.775859, -1.013619, -0.998508>, 
      <1.686178, -1.040899, -1.099541>, <1.706689, -1.024872, -1.067448>, <1.731143, -1.003392, -1.020142>, <1.743578, -0.988757, -0.995108>, 
      <1.669122, -1.033396, -1.065679>, <1.689633, -1.017369, -1.033586>, <1.698523, -1.006314, -1.003704>, <1.710958, -0.991679, -0.978670>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.700329, -1.114135, -1.112416>, <1.707601, -1.151990, -1.098639>, <1.711619, -1.168517, -1.055259>, <1.693554, -1.160571, -1.019395>, 
      <1.736924, -1.087227, -1.065940>, <1.744196, -1.125081, -1.052164>, <1.731746, -1.149810, -1.023342>, <1.713681, -1.141863, -0.987478>, 
      <1.757958, -1.063137, -1.025500>, <1.767674, -1.097334, -1.014139>, <1.764431, -1.124694, -0.979862>, <1.731209, -1.127670, -0.963121>, 
      <1.785398, -1.047195, -0.987353>, <1.795114, -1.081392, -0.975992>, <1.779993, -1.114751, -0.953535>, <1.746770, -1.117727, -0.936794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.582981, -1.140573, -1.087106>, <1.573288, -1.108550, -1.098464>, <1.579322, -1.073346, -1.119449>, <1.610313, -1.070321, -1.136148>, 
      <1.609361, -1.118566, -1.048382>, <1.599668, -1.086542, -1.059740>, <1.600641, -1.056790, -1.091479>, <1.631632, -1.053764, -1.108178>, 
      <1.614700, -1.105852, -1.022340>, <1.607231, -1.066974, -1.036489>, <1.631275, -1.040311, -1.059035>, <1.649828, -1.048472, -1.095868>, 
      <1.633067, -1.084548, -0.978882>, <1.625598, -1.045669, -0.993031>, <1.650569, -1.025235, -1.028845>, <1.669122, -1.033396, -1.065679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.513744, -1.184094, -1.154043>, <1.504514, -1.148210, -1.166343>, <1.528441, -1.120762, -1.191446>, <1.565493, -1.113877, -1.201638>, 
      <1.537301, -1.166743, -1.124581>, <1.528071, -1.130859, -1.136880>, <1.547748, -1.102928, -1.167484>, <1.584801, -1.096043, -1.177676>, 
      <1.561822, -1.158225, -1.118166>, <1.552129, -1.126202, -1.129525>, <1.559815, -1.088496, -1.145042>, <1.590806, -1.085471, -1.161741>, 
      <1.582981, -1.140573, -1.087106>, <1.573288, -1.108550, -1.098464>, <1.579322, -1.073346, -1.119449>, <1.610313, -1.070321, -1.136148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.651472, -1.206305, -1.087916>, <1.618757, -1.209499, -1.070288>, <1.593213, -1.174378, -1.075116>, <1.582981, -1.140573, -1.087106>, 
      <1.670098, -1.190789, -1.060836>, <1.637384, -1.193983, -1.043208>, <1.619593, -1.152370, -1.036392>, <1.609361, -1.118566, -1.048382>, 
      <1.676185, -1.176716, -1.046939>, <1.657934, -1.168688, -1.010707>, <1.622047, -1.144097, -1.008421>, <1.614700, -1.105852, -1.022340>, 
      <1.693554, -1.160571, -1.019395>, <1.675304, -1.152543, -0.983163>, <1.640414, -1.122792, -0.964964>, <1.633067, -1.084548, -0.978882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.597980, -1.240183, -1.158345>, <1.560209, -1.247202, -1.147955>, <1.523153, -1.220674, -1.141505>, <1.513744, -1.184094, -1.154043>, 
      <1.619720, -1.227304, -1.131031>, <1.581950, -1.234323, -1.120641>, <1.546710, -1.203323, -1.112042>, <1.537301, -1.166743, -1.124581>, 
      <1.632403, -1.222190, -1.115640>, <1.599688, -1.225383, -1.098012>, <1.572054, -1.192030, -1.106176>, <1.561822, -1.158225, -1.118166>, 
      <1.651472, -1.206305, -1.087916>, <1.618757, -1.209499, -1.070288>, <1.593213, -1.174378, -1.075116>, <1.582981, -1.140573, -1.087106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.669952, -1.132083, -1.133970>, <1.679352, -1.125084, -1.122721>, <1.691181, -1.120861, -1.124033>, <1.700329, -1.114135, -1.112416>, 
      <1.660696, -1.101501, -1.144817>, <1.670095, -1.094502, -1.133568>, <1.684315, -1.085120, -1.137041>, <1.693462, -1.078394, -1.125424>, 
      <1.639909, -1.067432, -1.152096>, <1.661228, -1.050875, -1.124126>, <1.666884, -1.055975, -1.129730>, <1.686178, -1.040899, -1.099541>, 
      <1.610313, -1.070321, -1.136148>, <1.631632, -1.053764, -1.108178>, <1.649828, -1.048472, -1.095868>, <1.669122, -1.033396, -1.065679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.669952, -1.132083, -1.133970>, <1.679575, -1.163876, -1.122694>, <1.682239, -1.203302, -1.104495>, <1.651472, -1.206305, -1.087916>, 
      <1.679352, -1.125084, -1.122721>, <1.688975, -1.156877, -1.111444>, <1.700866, -1.187786, -1.077415>, <1.670098, -1.190789, -1.060836>, 
      <1.691181, -1.120861, -1.124033>, <1.698454, -1.158716, -1.110257>, <1.694249, -1.184662, -1.082803>, <1.676185, -1.176716, -1.046939>, 
      <1.700329, -1.114135, -1.112416>, <1.707601, -1.151990, -1.098639>, <1.711619, -1.168517, -1.055259>, <1.693554, -1.160571, -1.019395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.637174, -1.161158, -1.187996>, <1.652028, -1.149749, -1.168093>, <1.654138, -1.143858, -1.152896>, <1.669952, -1.132083, -1.133970>, 
      <1.629098, -1.129759, -1.198759>, <1.643952, -1.118350, -1.178856>, <1.644881, -1.113275, -1.163743>, <1.660696, -1.101501, -1.144817>, 
      <1.597914, -1.107852, -1.210556>, <1.617222, -1.090018, -1.186595>, <1.620403, -1.082582, -1.177689>, <1.639909, -1.067432, -1.152096>, 
      <1.565493, -1.113877, -1.201638>, <1.584801, -1.096043, -1.177676>, <1.590806, -1.085471, -1.161741>, <1.610313, -1.070321, -1.136148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.637174, -1.161158, -1.187996>, <1.645818, -1.194765, -1.176477>, <1.632681, -1.233735, -1.167890>, <1.597980, -1.240183, -1.158345>, 
      <1.652028, -1.149749, -1.168093>, <1.660672, -1.183357, -1.156574>, <1.654421, -1.220856, -1.140576>, <1.619720, -1.227304, -1.131031>, 
      <1.654138, -1.143858, -1.152896>, <1.663761, -1.175650, -1.141619>, <1.663170, -1.219186, -1.132219>, <1.632403, -1.222190, -1.115640>, 
      <1.669952, -1.132083, -1.133970>, <1.679575, -1.163876, -1.122694>, <1.682239, -1.203302, -1.104495>, <1.651472, -1.206305, -1.087916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.498774, -1.250577, -1.308475>, <1.501767, -1.257497, -1.299469>, <1.501504, -1.264720, -1.295653>, <1.506393, -1.268189, -1.285553>, 
      <1.500850, -1.250100, -1.309618>, <1.503844, -1.257020, -1.300612>, <1.515165, -1.264277, -1.304188>, <1.520054, -1.267746, -1.294088>, 
      <1.501523, -1.248038, -1.310685>, <1.510599, -1.245121, -1.309031>, <1.520670, -1.257103, -1.306679>, <1.528482, -1.253175, -1.302536>, 
      <1.501156, -1.245813, -1.311556>, <1.510231, -1.242896, -1.309902>, <1.516444, -1.242316, -1.311489>, <1.524255, -1.238388, -1.307346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.494518, -1.247338, -1.307901>, <1.483867, -1.244545, -1.293729>, <1.470861, -1.245648, -1.288588>, <1.467409, -1.240230, -1.271830>, 
      <1.494839, -1.249283, -1.307139>, <1.484188, -1.246490, -1.292967>, <1.476004, -1.263638, -1.282736>, <1.472551, -1.258220, -1.265978>, 
      <1.496959, -1.250994, -1.307476>, <1.499953, -1.257913, -1.298470>, <1.484884, -1.265258, -1.285269>, <1.489773, -1.268728, -1.275169>, 
      <1.498774, -1.250577, -1.308475>, <1.501767, -1.257497, -1.299469>, <1.501504, -1.264720, -1.295653>, <1.506393, -1.268189, -1.285553>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.497272, -1.241471, -1.312041>, <1.494944, -1.231289, -1.308361>, <1.490501, -1.225022, -1.308358>, <1.491348, -1.215555, -1.302674>, 
      <1.494677, -1.242067, -1.310612>, <1.492350, -1.231885, -1.306932>, <1.475117, -1.225520, -1.298747>, <1.475964, -1.216053, -1.293062>, 
      <1.494059, -1.244557, -1.308990>, <1.483408, -1.241764, -1.294818>, <1.466101, -1.228995, -1.294005>, <1.462649, -1.223577, -1.277247>, 
      <1.494518, -1.247338, -1.307901>, <1.483867, -1.244545, -1.293729>, <1.470861, -1.245648, -1.288588>, <1.467409, -1.240230, -1.271830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.497272, -1.241471, -1.312041>, <1.499245, -1.241018, -1.313127>, <1.500807, -1.243699, -1.312384>, <1.501156, -1.245813, -1.311556>, 
      <1.494944, -1.231289, -1.308361>, <1.496917, -1.230835, -1.309447>, <1.509883, -1.240782, -1.310730>, <1.510231, -1.242896, -1.309902>, 
      <1.490501, -1.225022, -1.308358>, <1.503932, -1.224586, -1.316750>, <1.512288, -1.227777, -1.316218>, <1.516444, -1.242316, -1.311489>, 
      <1.491348, -1.215555, -1.302674>, <1.504779, -1.215120, -1.311066>, <1.520099, -1.223849, -1.312075>, <1.524255, -1.238388, -1.307346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.534246, -1.275748, -1.235198>, <1.559806, -1.274726, -1.253128>, <1.569366, -1.244427, -1.270805>, <1.561170, -1.215634, -1.279727>, 
      <1.521130, -1.279759, -1.253416>, <1.546690, -1.278737, -1.271345>, <1.556802, -1.253020, -1.284085>, <1.548606, -1.224227, -1.293006>, 
      <1.515885, -1.274925, -1.265944>, <1.529546, -1.274482, -1.274479>, <1.544790, -1.244974, -1.293887>, <1.540564, -1.230187, -1.298697>, 
      <1.506393, -1.268189, -1.285553>, <1.520054, -1.267746, -1.294088>, <1.528482, -1.253175, -1.302536>, <1.524255, -1.238388, -1.307346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.534246, -1.275748, -1.235198>, <1.558198, -1.268424, -1.201931>, <1.573650, -1.254596, -1.188913>, <1.597980, -1.240183, -1.158345>, 
      <1.559806, -1.274726, -1.253128>, <1.583757, -1.267402, -1.219860>, <1.608351, -1.248147, -1.198458>, <1.632681, -1.233735, -1.167890>, 
      <1.569366, -1.244427, -1.270805>, <1.601377, -1.222534, -1.236971>, <1.617846, -1.216250, -1.213957>, <1.645818, -1.194765, -1.176477>, 
      <1.561170, -1.215634, -1.279727>, <1.593181, -1.193741, -1.245893>, <1.609202, -1.182642, -1.225476>, <1.637174, -1.161158, -1.187996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.534246, -1.275748, -1.235198>, <1.521130, -1.279759, -1.253416>, <1.515885, -1.274925, -1.265944>, <1.506393, -1.268189, -1.285553>, 
      <1.507781, -1.276806, -1.216633>, <1.494665, -1.280817, -1.234850>, <1.499265, -1.275463, -1.255560>, <1.489773, -1.268728, -1.275169>, 
      <1.484960, -1.248834, -1.211075>, <1.477538, -1.257825, -1.229941>, <1.468285, -1.251526, -1.245271>, <1.472551, -1.258220, -1.265978>, 
      <1.476473, -1.219021, -1.220313>, <1.469052, -1.228012, -1.239178>, <1.463143, -1.233535, -1.251123>, <1.467409, -1.240230, -1.271830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.534246, -1.275748, -1.235198>, <1.507781, -1.276806, -1.216633>, <1.484960, -1.248834, -1.211075>, <1.476473, -1.219021, -1.220313>, 
      <1.558198, -1.268424, -1.201931>, <1.531733, -1.269482, -1.183366>, <1.495960, -1.235506, -1.183110>, <1.487474, -1.205693, -1.192348>, 
      <1.573650, -1.254596, -1.188913>, <1.535880, -1.261614, -1.178523>, <1.504502, -1.234411, -1.164831>, <1.495093, -1.197831, -1.177369>, 
      <1.597980, -1.240183, -1.158345>, <1.560209, -1.247202, -1.147955>, <1.523153, -1.220674, -1.141505>, <1.513744, -1.184094, -1.154043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.503781, -1.168724, -1.268360>, <1.479758, -1.169685, -1.251508>, <1.468770, -1.191959, -1.228698>, <1.476473, -1.219021, -1.220313>, 
      <1.493063, -1.183421, -1.282965>, <1.469041, -1.184382, -1.266113>, <1.461348, -1.200950, -1.247564>, <1.469052, -1.228012, -1.239178>, 
      <1.493132, -1.195614, -1.290701>, <1.477748, -1.196113, -1.281089>, <1.458383, -1.216883, -1.256540>, <1.463143, -1.233535, -1.251123>, 
      <1.491348, -1.215555, -1.302674>, <1.475964, -1.216053, -1.293062>, <1.462649, -1.223577, -1.277247>, <1.467409, -1.240230, -1.271830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.503781, -1.168724, -1.268360>, <1.522943, -1.142447, -1.242249>, <1.542852, -1.134790, -1.229736>, <1.565493, -1.113877, -1.201638>, 
      <1.479758, -1.169685, -1.251508>, <1.498920, -1.143407, -1.225397>, <1.505800, -1.141675, -1.219544>, <1.528441, -1.120762, -1.191446>, 
      <1.468770, -1.191959, -1.228698>, <1.479771, -1.178631, -1.200733>, <1.485863, -1.161947, -1.189669>, <1.504514, -1.148210, -1.166343>, 
      <1.476473, -1.219021, -1.220313>, <1.487474, -1.205693, -1.192348>, <1.495093, -1.197831, -1.177369>, <1.513744, -1.184094, -1.154043>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.503781, -1.168724, -1.268360>, <1.493063, -1.183421, -1.282965>, <1.493132, -1.195614, -1.290701>, <1.491348, -1.215555, -1.302674>, 
      <1.527888, -1.167760, -1.285271>, <1.517170, -1.182457, -1.299875>, <1.506563, -1.195179, -1.299092>, <1.504779, -1.215120, -1.311066>, 
      <1.553440, -1.188477, -1.288142>, <1.540876, -1.197070, -1.301421>, <1.536408, -1.215648, -1.303426>, <1.520099, -1.223849, -1.312075>, 
      <1.561170, -1.215634, -1.279727>, <1.548606, -1.224227, -1.293006>, <1.540564, -1.230187, -1.298697>, <1.524255, -1.238388, -1.307346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.503781, -1.168724, -1.268360>, <1.527888, -1.167760, -1.285271>, <1.553440, -1.188477, -1.288142>, <1.561170, -1.215634, -1.279727>, 
      <1.522943, -1.142447, -1.242249>, <1.547050, -1.141483, -1.259159>, <1.585451, -1.166584, -1.254308>, <1.593181, -1.193741, -1.245893>, 
      <1.542852, -1.134790, -1.229736>, <1.575274, -1.128766, -1.238655>, <1.601126, -1.151243, -1.236239>, <1.609202, -1.182642, -1.225476>, 
      <1.565493, -1.113877, -1.201638>, <1.597914, -1.107852, -1.210556>, <1.629098, -1.129759, -1.198759>, <1.637174, -1.161158, -1.187996>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.599988, -0.929763, -1.028511>, <1.610234, -0.920918, -1.006082>, <1.616882, -0.917015, -0.986753>, <1.621504, -0.910517, -0.968408>, 
      <1.606465, -0.968178, -1.015726>, <1.616711, -0.959333, -0.993297>, <1.627787, -0.959696, -0.973831>, <1.632410, -0.953197, -0.955486>, 
      <1.640873, -0.998093, -1.035041>, <1.662560, -0.983469, -1.001677>, <1.659898, -0.991606, -0.990152>, <1.674732, -0.981741, -0.963124>, 
      <1.658673, -1.004649, -1.071391>, <1.680359, -0.990025, -1.038027>, <1.700782, -0.987926, -1.010706>, <1.715616, -0.978061, -0.983678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.636941, -0.875753, -1.114289>, <1.657941, -0.860143, -1.081965>, <1.664537, -0.841051, -1.054921>, <1.676853, -0.826357, -1.029608>, 
      <1.618539, -0.868975, -1.076708>, <1.639539, -0.853365, -1.044384>, <1.623296, -0.844763, -1.034188>, <1.635612, -0.830069, -1.008875>, 
      <1.593292, -0.890047, -1.041729>, <1.603538, -0.881202, -1.019300>, <1.605881, -0.873963, -0.999787>, <1.610503, -0.867464, -0.981443>, 
      <1.599988, -0.929763, -1.028511>, <1.610234, -0.920918, -1.006082>, <1.616882, -0.917015, -0.986753>, <1.621504, -0.910517, -0.968408>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666172, -0.954140, -1.163670>, <1.703851, -0.931940, -1.115640>, <1.727151, -0.915654, -1.073144>, <1.753694, -0.898620, -1.034864>, 
      <1.660143, -0.918379, -1.175572>, <1.697822, -0.896180, -1.127542>, <1.717293, -0.877076, -1.084823>, <1.743837, -0.860042, -1.046544>, 
      <1.653511, -0.881856, -1.148127>, <1.674511, -0.866246, -1.115803>, <1.701491, -0.837725, -1.073499>, <1.713807, -0.823031, -1.048186>, 
      <1.636941, -0.875753, -1.114289>, <1.657941, -0.860143, -1.081965>, <1.664537, -0.841051, -1.054921>, <1.676853, -0.826357, -1.029608>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.666172, -0.954140, -1.163670>, <1.672718, -0.992963, -1.150749>, <1.676662, -1.011275, -1.108127>, <1.658673, -1.004649, -1.071391>, 
      <1.703851, -0.931940, -1.115640>, <1.710397, -0.970763, -1.102720>, <1.698348, -0.996651, -1.074763>, <1.680359, -0.990025, -1.038027>, 
      <1.727151, -0.915654, -1.073144>, <1.736660, -0.952870, -1.061876>, <1.736433, -0.984717, -1.028629>, <1.700782, -0.987926, -1.010706>, 
      <1.753694, -0.898620, -1.034864>, <1.763204, -0.935836, -1.023596>, <1.751266, -0.974853, -1.001600>, <1.715616, -0.978061, -0.983678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.536975, -0.983485, -1.153437>, <1.528316, -0.949584, -1.163575>, <1.533778, -0.912034, -1.183186>, <1.565034, -0.909472, -1.201720>, 
      <1.570021, -0.962273, -1.109555>, <1.561363, -0.928372, -1.119694>, <1.561213, -0.895363, -1.149674>, <1.592469, -0.892801, -1.168208>, 
      <1.576956, -0.949645, -1.078927>, <1.570260, -0.909929, -1.092145>, <1.595104, -0.886394, -1.112779>, <1.613506, -0.893172, -1.150360>, 
      <1.599988, -0.929763, -1.028511>, <1.593292, -0.890047, -1.041729>, <1.618539, -0.868975, -1.076708>, <1.636941, -0.875753, -1.114289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.434856, -1.035760, -1.247788>, <1.426460, -0.999428, -1.259053>, <1.449125, -0.972790, -1.286045>, <1.485371, -0.967857, -1.299436>, 
      <1.473612, -1.015080, -1.209367>, <1.465216, -0.978748, -1.220633>, <1.484609, -0.950111, -1.251312>, <1.520855, -0.945178, -1.264703>, 
      <1.504225, -1.004507, -1.196926>, <1.495566, -0.970607, -1.207064>, <1.501508, -0.931644, -1.222605>, <1.532763, -0.929082, -1.241139>, 
      <1.536975, -0.983485, -1.153437>, <1.528316, -0.949584, -1.163575>, <1.533778, -0.912034, -1.183186>, <1.565034, -0.909472, -1.201720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.602103, -1.054606, -1.158316>, <1.569552, -1.057274, -1.139014>, <1.545992, -1.018790, -1.142878>, <1.536975, -0.983485, -1.153437>, 
      <1.627699, -1.038319, -1.124771>, <1.595147, -1.040988, -1.105469>, <1.579039, -0.997578, -1.098997>, <1.570021, -0.962273, -1.109555>, 
      <1.635537, -1.020250, -1.106985>, <1.617737, -1.013694, -1.070635>, <1.583433, -0.988061, -1.066142>, <1.576956, -0.949645, -1.078927>, 
      <1.658673, -1.004649, -1.071391>, <1.640873, -0.998093, -1.035041>, <1.606465, -0.968178, -1.015726>, <1.599988, -0.929763, -1.028511>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.515001, -1.096070, -1.259682>, <1.478076, -1.101095, -1.246040>, <1.443410, -1.072773, -1.236312>, <1.434856, -1.035760, -1.247788>, 
      <1.552331, -1.080646, -1.222382>, <1.515405, -1.085672, -1.208740>, <1.482166, -1.052093, -1.197891>, <1.473612, -1.015080, -1.209367>, 
      <1.570990, -1.074404, -1.199092>, <1.538438, -1.077073, -1.179790>, <1.513242, -1.039813, -1.186368>, <1.504225, -1.004507, -1.196926>, 
      <1.602103, -1.054606, -1.158316>, <1.569552, -1.057274, -1.139014>, <1.545992, -1.018790, -1.142878>, <1.536975, -0.983485, -1.153437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.621400, -0.976564, -1.203499>, <1.636594, -0.967549, -1.185616>, <1.651590, -0.962731, -1.182257>, <1.666172, -0.954140, -1.163670>, 
      <1.613215, -0.944518, -1.213083>, <1.628409, -0.935503, -1.195200>, <1.645561, -0.926971, -1.194159>, <1.660143, -0.918379, -1.175572>, 
      <1.594580, -0.907050, -1.219240>, <1.622015, -0.890379, -1.185728>, <1.630076, -0.899275, -1.184198>, <1.653511, -0.881856, -1.148127>, 
      <1.565034, -0.909472, -1.201720>, <1.592469, -0.892801, -1.168208>, <1.613506, -0.893172, -1.150360>, <1.636941, -0.875753, -1.114289>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.621400, -0.976564, -1.203499>, <1.630012, -1.010283, -1.193415>, <1.633191, -1.052057, -1.176751>, <1.602103, -1.054606, -1.158316>, 
      <1.636594, -0.967549, -1.185616>, <1.645206, -1.001268, -1.175532>, <1.658787, -1.035770, -1.143206>, <1.627699, -1.038319, -1.124771>, 
      <1.651590, -0.962731, -1.182257>, <1.658136, -1.001554, -1.169337>, <1.653526, -1.026876, -1.143721>, <1.635537, -1.020250, -1.106985>, 
      <1.666172, -0.954140, -1.163670>, <1.672718, -0.992963, -1.150749>, <1.676662, -1.011275, -1.108127>, <1.658673, -1.004649, -1.071391>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.556513, -1.019203, -1.292735>, <1.586697, -1.002675, -1.261500>, <1.593310, -0.993230, -1.236560>, <1.621400, -0.976564, -1.203499>, 
      <1.549061, -0.986958, -1.302733>, <1.579245, -0.970430, -1.271498>, <1.585125, -0.961184, -1.246144>, <1.613215, -0.944518, -1.213083>, 
      <1.517539, -0.963479, -1.311321>, <1.553023, -0.940800, -1.276588>, <1.562310, -0.926660, -1.258660>, <1.594580, -0.907050, -1.219240>, 
      <1.485371, -0.967857, -1.299436>, <1.520855, -0.945178, -1.264703>, <1.532763, -0.929082, -1.241139>, <1.565034, -0.909472, -1.201720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.556513, -1.019203, -1.292735>, <1.564423, -1.053431, -1.282122>, <1.549148, -1.091423, -1.272298>, <1.515001, -1.096070, -1.259682>, 
      <1.586697, -1.002675, -1.261500>, <1.594607, -1.036903, -1.250888>, <1.586477, -1.075999, -1.234998>, <1.552331, -1.080646, -1.222382>, 
      <1.593310, -0.993230, -1.236560>, <1.601922, -1.026949, -1.226476>, <1.602078, -1.071855, -1.217527>, <1.570990, -1.074404, -1.199092>, 
      <1.621400, -0.976564, -1.203499>, <1.630012, -1.010283, -1.193415>, <1.633191, -1.052057, -1.176751>, <1.602103, -1.054606, -1.158316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.369856, -1.105589, -1.411925>, <1.373828, -1.112863, -1.403412>, <1.373620, -1.120436, -1.399610>, <1.379965, -1.124102, -1.390258>, 
      <1.371833, -1.105201, -1.413250>, <1.375805, -1.112475, -1.404737>, <1.386338, -1.120554, -1.409396>, <1.392683, -1.124219, -1.400044>, 
      <1.372491, -1.103164, -1.414354>, <1.382238, -1.100840, -1.413630>, <1.391894, -1.113281, -1.412232>, <1.400808, -1.109969, -1.408992>, 
      <1.372161, -1.100922, -1.415177>, <1.381908, -1.098597, -1.414453>, <1.388054, -1.098317, -1.416575>, <1.396968, -1.095005, -1.413335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.365901, -1.102151, -1.410980>, <1.357695, -1.099156, -1.396198>, <1.345247, -1.099583, -1.389764>, <1.345014, -1.094527, -1.373356>, 
      <1.366188, -1.104097, -1.410266>, <1.357981, -1.101101, -1.395484>, <1.349835, -1.117463, -1.384574>, <1.349602, -1.112407, -1.368166>, 
      <1.368141, -1.105926, -1.410775>, <1.372113, -1.113199, -1.402262>, <1.358424, -1.120297, -1.387916>, <1.364769, -1.123962, -1.378564>, 
      <1.369856, -1.105589, -1.411925>, <1.373828, -1.112863, -1.403412>, <1.373620, -1.120436, -1.399610>, <1.379965, -1.124102, -1.390258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.368500, -1.096382, -1.415304>, <1.367612, -1.086258, -1.411564>, <1.364050, -1.080013, -1.410696>, <1.366240, -1.070613, -1.405784>, 
      <1.366032, -1.096867, -1.413649>, <1.365144, -1.086742, -1.409909>, <1.349870, -1.079883, -1.399784>, <1.352060, -1.070483, -1.394872>, 
      <1.365489, -1.099351, -1.412008>, <1.357282, -1.096355, -1.397225>, <1.340966, -1.082898, -1.394607>, <1.340733, -1.077843, -1.378199>, 
      <1.365901, -1.102151, -1.410980>, <1.357695, -1.099156, -1.396198>, <1.345247, -1.099583, -1.389764>, <1.345014, -1.094527, -1.373356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.368500, -1.096382, -1.415304>, <1.370379, -1.096013, -1.416564>, <1.371847, -1.098791, -1.415959>, <1.372161, -1.100922, -1.415177>, 
      <1.367612, -1.086258, -1.411564>, <1.369491, -1.085889, -1.412823>, <1.381594, -1.096466, -1.415236>, <1.381908, -1.098597, -1.414453>, 
      <1.364050, -1.080013, -1.410696>, <1.376490, -1.080128, -1.420268>, <1.384299, -1.083680, -1.420824>, <1.388054, -1.098317, -1.416575>, 
      <1.366240, -1.070613, -1.405784>, <1.378680, -1.070728, -1.415357>, <1.393212, -1.080368, -1.417584>, <1.396968, -1.095005, -1.413335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.415246, -1.131811, -1.345026>, <1.438078, -1.131782, -1.364725>, <1.448813, -1.103206, -1.381672>, <1.441038, -1.075328, -1.390141>, 
      <1.399077, -1.135168, -1.360661>, <1.421909, -1.135138, -1.380360>, <1.433119, -1.110662, -1.393534>, <1.425344, -1.082784, -1.402004>, 
      <1.392110, -1.131118, -1.372358>, <1.404828, -1.131235, -1.382144>, <1.419475, -1.103033, -1.402206>, <1.415635, -1.088069, -1.406550>, 
      <1.379965, -1.124102, -1.390258>, <1.392683, -1.124219, -1.400044>, <1.400808, -1.109969, -1.408992>, <1.396968, -1.095005, -1.413335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.415246, -1.131811, -1.345026>, <1.453254, -1.123921, -1.308273>, <1.478705, -1.111067, -1.295950>, <1.515001, -1.096070, -1.259682>, 
      <1.438078, -1.131782, -1.364725>, <1.476087, -1.123891, -1.327972>, <1.512852, -1.106420, -1.308565>, <1.549148, -1.091423, -1.272298>, 
      <1.448813, -1.103206, -1.381672>, <1.496046, -1.080765, -1.345968>, <1.523299, -1.075950, -1.324678>, <1.564423, -1.053431, -1.282122>, 
      <1.441038, -1.075328, -1.390141>, <1.488271, -1.052887, -1.354438>, <1.515389, -1.041722, -1.335291>, <1.556513, -1.019203, -1.292735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.415246, -1.131811, -1.345026>, <1.399077, -1.135168, -1.360661>, <1.392110, -1.131118, -1.372358>, <1.379965, -1.124102, -1.390258>, 
      <1.391881, -1.131841, -1.324868>, <1.375712, -1.135198, -1.340502>, <1.376914, -1.130979, -1.360664>, <1.364769, -1.123962, -1.378564>, 
      <1.372624, -1.103955, -1.315585>, <1.360609, -1.111814, -1.332378>, <1.349302, -1.105902, -1.347053>, <1.349602, -1.112407, -1.368166>, 
      <1.364668, -1.075427, -1.324252>, <1.352653, -1.083286, -1.341045>, <1.344714, -1.088022, -1.352243>, <1.345014, -1.094527, -1.373356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.415246, -1.131811, -1.345026>, <1.391881, -1.131841, -1.324868>, <1.372624, -1.103955, -1.315585>, <1.364668, -1.075427, -1.324252>, 
      <1.453254, -1.123921, -1.308273>, <1.429890, -1.123951, -1.288115>, <1.396366, -1.088425, -1.282403>, <1.388410, -1.059897, -1.291070>, 
      <1.478705, -1.111067, -1.295950>, <1.441779, -1.116092, -1.282307>, <1.414418, -1.088243, -1.265053>, <1.405864, -1.051230, -1.276529>, 
      <1.515001, -1.096070, -1.259682>, <1.478076, -1.101095, -1.246040>, <1.443410, -1.072773, -1.236312>, <1.434856, -1.035760, -1.247788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.385278, -1.024358, -1.377670>, <1.362454, -1.024388, -1.357979>, <1.356896, -1.047560, -1.332718>, <1.364668, -1.075427, -1.324252>, 
      <1.371135, -1.036557, -1.390295>, <1.348312, -1.036587, -1.370604>, <1.344881, -1.055419, -1.349511>, <1.352653, -1.083286, -1.341045>, 
      <1.370799, -1.051045, -1.395559>, <1.356618, -1.050915, -1.384648>, <1.340433, -1.071337, -1.357086>, <1.344714, -1.088022, -1.352243>, 
      <1.366240, -1.070613, -1.405784>, <1.352060, -1.070483, -1.394872>, <1.340733, -1.077843, -1.378199>, <1.345014, -1.094527, -1.373356>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.385278, -1.024358, -1.377670>, <1.419548, -0.994798, -1.347077>, <1.449861, -0.990552, -1.334194>, <1.485371, -0.967857, -1.299436>, 
      <1.362454, -1.024388, -1.357979>, <1.396725, -0.994828, -1.327386>, <1.413615, -0.995485, -1.320803>, <1.449125, -0.972790, -1.286045>, 
      <1.356896, -1.047560, -1.332718>, <1.380638, -1.032030, -1.299536>, <1.397468, -1.014898, -1.287794>, <1.426460, -0.999428, -1.259053>, 
      <1.364668, -1.075427, -1.324252>, <1.388410, -1.059897, -1.291070>, <1.405864, -1.051230, -1.276529>, <1.434856, -1.035760, -1.247788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.385278, -1.024358, -1.377670>, <1.371135, -1.036557, -1.390295>, <1.370799, -1.051045, -1.395559>, <1.366240, -1.070613, -1.405784>, 
      <1.408055, -1.024329, -1.397322>, <1.393913, -1.036527, -1.409947>, <1.383238, -1.051159, -1.405132>, <1.378680, -1.070728, -1.415357>, 
      <1.433282, -1.047517, -1.398590>, <1.417588, -1.054973, -1.410453>, <1.411880, -1.073431, -1.410798>, <1.393212, -1.080368, -1.417584>, 
      <1.441038, -1.075328, -1.390141>, <1.425344, -1.082784, -1.402004>, <1.415635, -1.088069, -1.406550>, <1.396968, -1.095005, -1.413335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.385278, -1.024358, -1.377670>, <1.408055, -1.024329, -1.397322>, <1.433282, -1.047517, -1.398590>, <1.441038, -1.075328, -1.390141>, 
      <1.419548, -0.994798, -1.347077>, <1.442326, -0.994769, -1.366729>, <1.480515, -1.025076, -1.362886>, <1.488271, -1.052887, -1.354438>, 
      <1.449861, -0.990552, -1.334194>, <1.482029, -0.986174, -1.346079>, <1.507937, -1.009478, -1.345289>, <1.515389, -1.041722, -1.335291>, 
      <1.485371, -0.967857, -1.299436>, <1.517539, -0.963479, -1.311321>, <1.549061, -0.986958, -1.302733>, <1.556513, -1.019203, -1.292735>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.565368, -0.773538, -1.080185>, <1.574443, -0.764870, -1.057201>, <1.581264, -0.760326, -1.038334>, <1.587066, -0.754283, -1.020178>, 
      <1.571845, -0.811953, -1.067400>, <1.580920, -0.803285, -1.044416>, <1.591963, -0.800981, -1.026169>, <1.597765, -0.794938, -1.008013>, 
      <1.606252, -0.841867, -1.086716>, <1.628027, -0.826339, -1.054160>, <1.625700, -0.826765, -1.045396>, <1.640496, -0.817379, -1.018415>, 
      <1.624052, -0.848423, -1.123066>, <1.645827, -0.832894, -1.090510>, <1.664675, -0.823257, -1.064990>, <1.679471, -0.813871, -1.038009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.602321, -0.719527, -1.165963>, <1.623984, -0.706658, -1.133212>, <1.632585, -0.697611, -1.102454>, <1.645829, -0.686036, -1.076259>, 
      <1.583919, -0.712749, -1.128382>, <1.605581, -0.699880, -1.095631>, <1.595463, -0.700951, -1.083791>, <1.608707, -0.689377, -1.057596>, 
      <1.558672, -0.733822, -1.093403>, <1.567747, -0.725154, -1.070419>, <1.571073, -0.721603, -1.049920>, <1.576876, -0.715561, -1.031764>, 
      <1.565368, -0.773538, -1.080185>, <1.574443, -0.764870, -1.057201>, <1.581264, -0.760326, -1.038334>, <1.587066, -0.754283, -1.020178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.631552, -0.797914, -1.215344>, <1.670982, -0.775795, -1.168689>, <1.690631, -0.756935, -1.124445>, <1.719256, -0.742387, -1.086634>, 
      <1.625523, -0.762153, -1.227245>, <1.664953, -0.740035, -1.180591>, <1.681685, -0.722941, -1.134617>, <1.710310, -0.708393, -1.096806>, 
      <1.618891, -0.725630, -1.199801>, <1.640554, -0.712761, -1.167050>, <1.665175, -0.694678, -1.118837>, <1.678418, -0.683103, -1.092643>, 
      <1.602321, -0.719527, -1.165963>, <1.623984, -0.706658, -1.133212>, <1.632585, -0.697611, -1.102454>, <1.645829, -0.686036, -1.076259>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.631552, -0.797914, -1.215344>, <1.638097, -0.836737, -1.202424>, <1.642041, -0.855048, -1.159801>, <1.624052, -0.848423, -1.123066>, 
      <1.670982, -0.775795, -1.168689>, <1.677527, -0.814618, -1.155769>, <1.663815, -0.839520, -1.127245>, <1.645827, -0.832894, -1.090510>, 
      <1.690631, -0.756935, -1.124445>, <1.699772, -0.791671, -1.114052>, <1.697975, -0.820260, -1.081731>, <1.664675, -0.823257, -1.064990>, 
      <1.719256, -0.742387, -1.086634>, <1.728397, -0.777123, -1.076241>, <1.712771, -0.810874, -1.054750>, <1.679471, -0.813871, -1.038009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.523746, -0.814765, -1.180548>, <1.516224, -0.782365, -1.189430>, <1.518089, -0.746908, -1.209434>, <1.540482, -0.748619, -1.235527>, 
      <1.556453, -0.798863, -1.152943>, <1.548931, -0.766463, -1.161825>, <1.547420, -0.733880, -1.188507>, <1.569813, -0.735591, -1.214601>, 
      <1.549545, -0.788652, -1.120259>, <1.542849, -0.748935, -1.133477>, <1.563833, -0.724682, -1.158749>, <1.582235, -0.731459, -1.196330>, 
      <1.565368, -0.773538, -1.080185>, <1.558672, -0.733822, -1.093403>, <1.583919, -0.712749, -1.128382>, <1.602321, -0.719527, -1.165963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.407336, -0.850371, -1.213564>, <1.399256, -0.814725, -1.224514>, <1.415466, -0.790070, -1.256030>, <1.447791, -0.788166, -1.276211>, 
      <1.451509, -0.835480, -1.196745>, <1.443429, -0.799834, -1.207695>, <1.453018, -0.775126, -1.242256>, <1.485343, -0.773222, -1.262436>, 
      <1.488246, -0.832025, -1.210510>, <1.480724, -0.799624, -1.219392>, <1.485401, -0.761427, -1.232755>, <1.507794, -0.763138, -1.258848>, 
      <1.523746, -0.814765, -1.180548>, <1.516224, -0.782365, -1.189430>, <1.518089, -0.746908, -1.209434>, <1.540482, -0.748619, -1.235527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.573222, -0.889643, -1.196866>, <1.549911, -0.887862, -1.169702>, <1.531576, -0.848494, -1.171301>, <1.523746, -0.814765, -1.180548>, 
      <1.602015, -0.876305, -1.174619>, <1.578704, -0.874524, -1.147455>, <1.564284, -0.832592, -1.143696>, <1.556453, -0.798863, -1.152943>, 
      <1.604024, -0.862706, -1.153011>, <1.586224, -0.856151, -1.116661>, <1.556022, -0.827067, -1.107474>, <1.549545, -0.788652, -1.120259>, 
      <1.624052, -0.848423, -1.123066>, <1.606252, -0.841867, -1.086716>, <1.571845, -0.811953, -1.067400>, <1.565368, -0.773538, -1.080185>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.476900, -0.916588, -1.236762>, <1.444012, -0.918525, -1.216230>, <1.415556, -0.886637, -1.202424>, <1.407336, -0.850371, -1.213564>, 
      <1.515261, -0.907152, -1.221616>, <1.482373, -0.909089, -1.201084>, <1.459729, -0.871746, -1.185605>, <1.451509, -0.835480, -1.196745>, 
      <1.541788, -0.904204, -1.221153>, <1.518477, -0.902423, -1.193989>, <1.496077, -0.865754, -1.201263>, <1.488246, -0.832025, -1.210510>, 
      <1.573222, -0.889643, -1.196866>, <1.549911, -0.887862, -1.169702>, <1.531576, -0.848494, -1.171301>, <1.523746, -0.814765, -1.180548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.582260, -0.819236, -1.248732>, <1.602639, -0.811110, -1.237070>, <1.616472, -0.806373, -1.233187>, <1.631552, -0.797914, -1.215344>, 
      <1.575126, -0.788507, -1.257156>, <1.595505, -0.780381, -1.245495>, <1.610443, -0.770612, -1.245088>, <1.625523, -0.762153, -1.227245>, 
      <1.561720, -0.750242, -1.260275>, <1.591051, -0.737213, -1.239349>, <1.598805, -0.737562, -1.230168>, <1.618891, -0.725630, -1.199801>, 
      <1.540482, -0.748619, -1.235527>, <1.569813, -0.735591, -1.214601>, <1.582235, -0.731459, -1.196330>, <1.602321, -0.719527, -1.165963>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.582260, -0.819236, -1.248732>, <1.589807, -0.851743, -1.239820>, <1.595689, -0.891360, -1.223046>, <1.573222, -0.889643, -1.196866>, 
      <1.602639, -0.811110, -1.237070>, <1.610186, -0.843617, -1.228159>, <1.624482, -0.878022, -1.200799>, <1.602015, -0.876305, -1.174619>, 
      <1.616472, -0.806373, -1.233187>, <1.623017, -0.845196, -1.220266>, <1.622012, -0.869332, -1.189747>, <1.604024, -0.862706, -1.153011>, 
      <1.631552, -0.797914, -1.215344>, <1.638097, -0.836737, -1.202424>, <1.642041, -0.855048, -1.159801>, <1.624052, -0.848423, -1.123066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.516054, -0.843968, -1.281437>, <1.543026, -0.834633, -1.270414>, <1.557164, -0.829243, -1.263093>, <1.582260, -0.819236, -1.248732>, 
      <1.508706, -0.811548, -1.291396>, <1.535678, -0.802213, -1.280373>, <1.550030, -0.798514, -1.271517>, <1.575126, -0.788507, -1.257156>, 
      <1.477191, -0.786435, -1.294565>, <1.514743, -0.771491, -1.280791>, <1.529032, -0.764761, -1.283596>, <1.561720, -0.750242, -1.260275>, 
      <1.447791, -0.788166, -1.276211>, <1.485343, -0.773222, -1.262436>, <1.507794, -0.763138, -1.258848>, <1.540482, -0.748619, -1.235527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.516054, -0.843968, -1.281437>, <1.523860, -0.878406, -1.270858>, <1.508130, -0.914749, -1.256259>, <1.476900, -0.916588, -1.236762>, 
      <1.543026, -0.834633, -1.270414>, <1.550832, -0.869071, -1.259835>, <1.546491, -0.905313, -1.241113>, <1.515261, -0.907152, -1.221616>, 
      <1.557164, -0.829243, -1.263093>, <1.564711, -0.861750, -1.254181>, <1.564255, -0.905921, -1.247333>, <1.541788, -0.904204, -1.221153>, 
      <1.582260, -0.819236, -1.248732>, <1.589807, -0.851743, -1.239820>, <1.595689, -0.891360, -1.223046>, <1.573222, -0.889643, -1.196866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.299072, -0.914880, -1.332317>, <1.305306, -0.922033, -1.324937>, <1.305896, -0.929726, -1.320705>, <1.314939, -0.933086, -1.313534>, 
      <1.300697, -0.914676, -1.334027>, <1.306931, -0.921829, -1.326647>, <1.315685, -0.931211, -1.332839>, <1.324728, -0.934571, -1.325668>, 
      <1.301139, -0.912701, -1.335273>, <1.311534, -0.910992, -1.336895>, <1.320561, -0.923613, -1.336801>, <1.330825, -0.920832, -1.336079>, 
      <1.300780, -0.910513, -1.336103>, <1.311175, -0.908804, -1.337726>, <1.316973, -0.908945, -1.340955>, <1.327237, -0.906164, -1.340233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.295822, -0.911134, -1.330886>, <1.293234, -0.906916, -1.316051>, <1.283358, -0.905822, -1.306566>, <1.289236, -0.900398, -1.293127>, 
      <1.296130, -0.913008, -1.330175>, <1.293542, -0.908790, -1.315340>, <1.287528, -0.922867, -1.301739>, <1.293405, -0.917443, -1.288300>, 
      <1.297680, -0.915054, -1.330852>, <1.303914, -0.922207, -1.323473>, <1.294521, -0.928000, -1.306604>, <1.303564, -0.931360, -1.299433>, 
      <1.299072, -0.914880, -1.332317>, <1.305306, -0.922033, -1.324937>, <1.305896, -0.929726, -1.320705>, <1.314939, -0.933086, -1.313534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.297570, -0.905734, -1.335787>, <1.299232, -0.895376, -1.333021>, <1.296842, -0.888495, -1.331885>, <1.301800, -0.879370, -1.328746>, 
      <1.295548, -0.905987, -1.333659>, <1.297210, -0.895629, -1.330893>, <1.286226, -0.886885, -1.318725>, <1.291184, -0.877759, -1.315586>, 
      <1.295375, -0.908411, -1.331919>, <1.292787, -0.904193, -1.317084>, <1.279467, -0.889915, -1.311071>, <1.285345, -0.884491, -1.297632>, 
      <1.295822, -0.911134, -1.330886>, <1.293234, -0.906916, -1.316051>, <1.283358, -0.905822, -1.306566>, <1.289236, -0.900398, -1.293127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.297570, -0.905734, -1.335787>, <1.299125, -0.905539, -1.337423>, <1.300436, -0.908420, -1.336897>, <1.300780, -0.910513, -1.336103>, 
      <1.299232, -0.895376, -1.333021>, <1.300787, -0.895181, -1.334657>, <1.310831, -0.906711, -1.338520>, <1.311175, -0.908804, -1.337726>, 
      <1.296842, -0.888495, -1.331885>, <1.306343, -0.889937, -1.343663>, <1.313491, -0.894708, -1.344987>, <1.316973, -0.908945, -1.340955>, 
      <1.301800, -0.879370, -1.328746>, <1.311301, -0.880812, -1.340524>, <1.323755, -0.891927, -1.344265>, <1.327237, -0.906164, -1.340233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.367405, -0.940270, -1.278130>, <1.384359, -0.942811, -1.302181>, <1.389466, -0.916017, -1.322640>, <1.382547, -0.888358, -1.330351>, 
      <1.344885, -0.942564, -1.288805>, <1.361839, -0.945105, -1.312856>, <1.368374, -0.922965, -1.329208>, <1.361455, -0.895305, -1.336919>, 
      <1.333768, -0.940082, -1.298603>, <1.343556, -0.941567, -1.310738>, <1.353125, -0.914790, -1.334510>, <1.349537, -0.900122, -1.338664>, 
      <1.314939, -0.933086, -1.313534>, <1.324728, -0.934571, -1.325668>, <1.330825, -0.920832, -1.336079>, <1.327237, -0.906164, -1.340233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.367405, -0.940270, -1.278130>, <1.409625, -0.935969, -1.258117>, <1.434358, -0.927052, -1.253559>, <1.476900, -0.916588, -1.236762>, 
      <1.384359, -0.942811, -1.302181>, <1.426579, -0.938510, -1.282169>, <1.465588, -0.925213, -1.273056>, <1.508130, -0.914749, -1.256259>, 
      <1.389466, -0.916017, -1.322640>, <1.442768, -0.898459, -1.306042>, <1.472269, -0.896262, -1.291943>, <1.523860, -0.878406, -1.270858>, 
      <1.382547, -0.888358, -1.330351>, <1.435850, -0.870800, -1.313753>, <1.464463, -0.861824, -1.302521>, <1.516054, -0.843968, -1.281437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.367405, -0.940270, -1.278130>, <1.344885, -0.942564, -1.288805>, <1.333768, -0.940082, -1.298603>, <1.314939, -0.933086, -1.313534>, 
      <1.350523, -0.937740, -1.254181>, <1.328003, -0.940034, -1.264856>, <1.322392, -0.938356, -1.284503>, <1.303564, -0.931360, -1.299433>, 
      <1.336060, -0.907902, -1.246955>, <1.317929, -0.915582, -1.259169>, <1.302114, -0.909407, -1.268388>, <1.293405, -0.917443, -1.288300>, 
      <1.329171, -0.880360, -1.254633>, <1.311040, -0.888040, -1.266847>, <1.297944, -0.892362, -1.273215>, <1.289236, -0.900398, -1.293127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.367405, -0.940270, -1.278130>, <1.350523, -0.937740, -1.254181>, <1.336060, -0.907902, -1.246955>, <1.329171, -0.880360, -1.254633>, 
      <1.409625, -0.935969, -1.258117>, <1.392742, -0.933440, -1.234169>, <1.364728, -0.895758, -1.227641>, <1.357839, -0.868216, -1.235319>, 
      <1.434358, -0.927052, -1.253559>, <1.401470, -0.928989, -1.233027>, <1.382899, -0.897647, -1.214858>, <1.374678, -0.861380, -1.225999>, 
      <1.476900, -0.916588, -1.236762>, <1.444012, -0.918525, -1.216230>, <1.415556, -0.886637, -1.202424>, <1.407336, -0.850371, -1.213564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.339475, -0.828609, -1.309260>, <1.322346, -0.826042, -1.284961>, <1.322181, -0.852415, -1.262424>, <1.329171, -0.880360, -1.254633>, 
      <1.318393, -0.841780, -1.316847>, <1.301263, -0.839213, -1.292547>, <1.304050, -0.860096, -1.274638>, <1.311040, -0.888040, -1.266847>, 
      <1.313678, -0.857510, -1.321227>, <1.303062, -0.855899, -1.308068>, <1.294053, -0.876455, -1.277720>, <1.297944, -0.892362, -1.273215>, 
      <1.301800, -0.879370, -1.328746>, <1.291184, -0.877759, -1.315586>, <1.285345, -0.884491, -1.297632>, <1.289236, -0.900398, -1.293127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.339475, -0.828609, -1.309260>, <1.377800, -0.804667, -1.295469>, <1.406240, -0.804701, -1.291453>, <1.447791, -0.788166, -1.276211>, 
      <1.322346, -0.826042, -1.284961>, <1.360670, -0.802100, -1.271170>, <1.373915, -0.806605, -1.271272>, <1.415466, -0.790070, -1.256030>, 
      <1.322181, -0.852415, -1.262424>, <1.350849, -0.840271, -1.243110>, <1.366599, -0.825735, -1.236948>, <1.399256, -0.814725, -1.224514>, 
      <1.329171, -0.880360, -1.254633>, <1.357839, -0.868216, -1.235319>, <1.374678, -0.861380, -1.225999>, <1.407336, -0.850371, -1.213564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.339475, -0.828609, -1.309260>, <1.318393, -0.841780, -1.316847>, <1.313678, -0.857510, -1.321227>, <1.301800, -0.879370, -1.328746>, 
      <1.356754, -0.831198, -1.333772>, <1.335672, -0.844369, -1.341359>, <1.323179, -0.858951, -1.333005>, <1.311301, -0.880812, -1.340524>, 
      <1.375496, -0.860169, -1.338210>, <1.354404, -0.867116, -1.344778>, <1.346055, -0.885885, -1.342696>, <1.323755, -0.891927, -1.344265>, 
      <1.382547, -0.888358, -1.330351>, <1.361455, -0.895305, -1.336919>, <1.349537, -0.900122, -1.338664>, <1.327237, -0.906164, -1.340233>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.339475, -0.828609, -1.309260>, <1.356754, -0.831198, -1.333772>, <1.375496, -0.860169, -1.338210>, <1.382547, -0.888358, -1.330351>, 
      <1.377800, -0.804667, -1.295469>, <1.395079, -0.807256, -1.319981>, <1.428799, -0.842611, -1.321612>, <1.435850, -0.870800, -1.313753>, 
      <1.406240, -0.804701, -1.291453>, <1.435640, -0.802970, -1.309807>, <1.457115, -0.829404, -1.312480>, <1.464463, -0.861824, -1.302521>, 
      <1.447791, -0.788166, -1.276211>, <1.477191, -0.786435, -1.294565>, <1.508706, -0.811548, -1.291396>, <1.516054, -0.843968, -1.281437>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.562329, -0.630868, -1.115585>, <1.569791, -0.625606, -1.097970>, <1.565712, -0.625212, -1.080666>, <1.569695, -0.621730, -1.066470>, 
      <1.567087, -0.662313, -1.105838>, <1.574548, -0.657050, -1.088223>, <1.574327, -0.659969, -1.071108>, <1.578310, -0.656487, -1.056913>, 
      <1.594887, -0.686788, -1.122333>, <1.613390, -0.677254, -1.098187>, <1.604694, -0.679471, -1.088594>, <1.615374, -0.673568, -1.067532>, 
      <1.609157, -0.691242, -1.152047>, <1.627660, -0.681708, -1.127901>, <1.637725, -0.676548, -1.105147>, <1.648405, -0.670645, -1.084085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.593093, -0.585067, -1.184960>, <1.611265, -0.577950, -1.160278>, <1.612400, -0.574042, -1.133127>, <1.622291, -0.565295, -1.113054>, 
      <1.578153, -0.580404, -1.153849>, <1.596325, -0.573286, -1.129166>, <1.580844, -0.576835, -1.117313>, <1.590735, -0.568088, -1.097240>, 
      <1.557348, -0.597945, -1.125791>, <1.564810, -0.592683, -1.108176>, <1.557481, -0.592008, -1.089796>, <1.561464, -0.588525, -1.075601>, 
      <1.562329, -0.630868, -1.115585>, <1.569791, -0.625606, -1.097970>, <1.565712, -0.625212, -1.080666>, <1.569695, -0.621730, -1.066470>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.615778, -0.647551, -1.226884>, <1.648333, -0.633072, -1.190986>, <1.662010, -0.622953, -1.153475>, <1.683736, -0.611637, -1.123619>, 
      <1.611362, -0.618361, -1.235933>, <1.643916, -0.603882, -1.200034>, <1.654915, -0.594330, -1.161346>, <1.676641, -0.583014, -1.131490>, 
      <1.606340, -0.589202, -1.212544>, <1.624512, -0.582084, -1.187862>, <1.639602, -0.571634, -1.146758>, <1.649493, -0.562888, -1.126686>, 
      <1.593093, -0.585067, -1.184960>, <1.611265, -0.577950, -1.160278>, <1.612400, -0.574042, -1.133127>, <1.622291, -0.565295, -1.113054>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.615778, -0.647551, -1.226884>, <1.620662, -0.679831, -1.216878>, <1.623806, -0.695814, -1.182551>, <1.609157, -0.691242, -1.152047>, 
      <1.648333, -0.633072, -1.190986>, <1.653217, -0.665352, -1.180979>, <1.642308, -0.686280, -1.158405>, <1.627660, -0.681708, -1.127901>, 
      <1.662010, -0.622953, -1.153475>, <1.669255, -0.652182, -1.145438>, <1.665504, -0.674089, -1.119068>, <1.637725, -0.676548, -1.105147>, 
      <1.683736, -0.611637, -1.123619>, <1.690981, -0.640867, -1.115582>, <1.676183, -0.668187, -1.098005>, <1.648405, -0.670645, -1.084085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.515233, -0.660139, -1.195040>, <1.509310, -0.632289, -1.202748>, <1.508649, -0.600764, -1.218871>, <1.528076, -0.602195, -1.241022>, 
      <1.545771, -0.649579, -1.174913>, <1.539848, -0.621729, -1.182621>, <1.537942, -0.591316, -1.203521>, <1.557370, -0.592748, -1.225672>, 
      <1.548013, -0.640965, -1.149383>, <1.543031, -0.608042, -1.159588>, <1.558289, -0.588183, -1.180829>, <1.573229, -0.592847, -1.211940>, 
      <1.562329, -0.630868, -1.115585>, <1.557348, -0.597945, -1.125791>, <1.578153, -0.580404, -1.153849>, <1.593093, -0.585067, -1.184960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.429231, -0.676893, -1.203309>, <1.424093, -0.648931, -1.211789>, <1.427581, -0.629919, -1.239153>, <1.446855, -0.632230, -1.261589>, 
      <1.462986, -0.670142, -1.200038>, <1.457847, -0.642180, -1.208518>, <1.461227, -0.620864, -1.236184>, <1.480501, -0.623175, -1.258620>, 
      <1.487495, -0.669731, -1.213322>, <1.481572, -0.641881, -1.221030>, <1.478865, -0.610369, -1.234478>, <1.498292, -0.611800, -1.256629>, 
      <1.515233, -0.660139, -1.195040>, <1.509310, -0.632289, -1.202748>, <1.508649, -0.600764, -1.218871>, <1.528076, -0.602195, -1.241022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.553081, -0.719762, -1.208482>, <1.534479, -0.718391, -1.187272>, <1.520905, -0.686806, -1.187659>, <1.515233, -0.660139, -1.195040>, 
      <1.581133, -0.710579, -1.193272>, <1.562531, -0.709208, -1.172062>, <1.551443, -0.676246, -1.167532>, <1.545771, -0.649579, -1.174913>, 
      <1.589884, -0.701173, -1.177198>, <1.575614, -0.696719, -1.147484>, <1.552770, -0.672409, -1.139635>, <1.548013, -0.640965, -1.149383>, 
      <1.609157, -0.691242, -1.152047>, <1.594887, -0.686788, -1.122333>, <1.567087, -0.662313, -1.105838>, <1.562329, -0.630868, -1.115585>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.466294, -0.738011, -1.229510>, <1.446863, -0.735681, -1.206891>, <1.434412, -0.705084, -1.194760>, <1.429231, -0.676893, -1.203309>, 
      <1.501431, -0.732389, -1.225494>, <1.482000, -0.730059, -1.202875>, <1.468166, -0.698333, -1.191489>, <1.462986, -0.670142, -1.200038>, 
      <1.522829, -0.729666, -1.224886>, <1.504226, -0.728295, -1.203676>, <1.493167, -0.696398, -1.205941>, <1.487495, -0.669731, -1.213322>, 
      <1.553081, -0.719762, -1.208482>, <1.534479, -0.718391, -1.187272>, <1.520905, -0.686806, -1.187659>, <1.515233, -0.660139, -1.195040>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.566234, -0.663897, -1.253190>, <1.586820, -0.657795, -1.245069>, <1.601002, -0.654123, -1.243177>, <1.615778, -0.647551, -1.226884>, 
      <1.560430, -0.636610, -1.260743>, <1.581017, -0.630508, -1.252622>, <1.596586, -0.624932, -1.252226>, <1.611362, -0.618361, -1.235933>, 
      <1.547111, -0.603598, -1.262725>, <1.576405, -0.594150, -1.247375>, <1.586476, -0.596981, -1.239524>, <1.606340, -0.589202, -1.212544>, 
      <1.528076, -0.602195, -1.241022>, <1.557370, -0.592748, -1.225672>, <1.573229, -0.592847, -1.211940>, <1.593093, -0.585067, -1.184960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.566234, -0.663897, -1.253190>, <1.571974, -0.690884, -1.245721>, <1.571906, -0.721149, -1.229946>, <1.553081, -0.719762, -1.208482>, 
      <1.586820, -0.657795, -1.245069>, <1.592560, -0.684782, -1.237600>, <1.599958, -0.711966, -1.214736>, <1.581133, -0.710579, -1.193272>, 
      <1.601002, -0.654123, -1.243177>, <1.605886, -0.686403, -1.233171>, <1.604533, -0.705745, -1.207702>, <1.589884, -0.701173, -1.177198>, 
      <1.615778, -0.647551, -1.226884>, <1.620662, -0.679831, -1.216878>, <1.623806, -0.695814, -1.182551>, <1.609157, -0.691242, -1.152047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.491573, -0.684367, -1.275879>, <1.522419, -0.677879, -1.272553>, <1.537810, -0.672322, -1.264403>, <1.566234, -0.663897, -1.253190>, 
      <1.486799, -0.658387, -1.283758>, <1.517645, -0.651899, -1.280432>, <1.532006, -0.645035, -1.271955>, <1.560430, -0.636610, -1.260743>, 
      <1.464762, -0.634377, -1.282435>, <1.498409, -0.625322, -1.279466>, <1.517327, -0.613203, -1.278332>, <1.547111, -0.603598, -1.262725>, 
      <1.446855, -0.632230, -1.261589>, <1.480501, -0.623175, -1.258620>, <1.498292, -0.611800, -1.256629>, <1.528076, -0.602195, -1.241022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.491573, -0.684367, -1.275879>, <1.496696, -0.712243, -1.267425>, <1.485508, -0.740315, -1.251877>, <1.466294, -0.738011, -1.229510>, 
      <1.522419, -0.677879, -1.272553>, <1.527542, -0.705755, -1.264100>, <1.520646, -0.734692, -1.247861>, <1.501431, -0.732389, -1.225494>, 
      <1.537810, -0.672322, -1.264403>, <1.543549, -0.699309, -1.256933>, <1.541654, -0.731053, -1.246350>, <1.522829, -0.729666, -1.224886>, 
      <1.566234, -0.663897, -1.253190>, <1.571974, -0.690884, -1.245721>, <1.571906, -0.721149, -1.229946>, <1.553081, -0.719762, -1.208482>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.284521, -0.720902, -1.255816>, <1.291395, -0.727137, -1.251467>, <1.293030, -0.732955, -1.247864>, <1.302017, -0.736771, -1.244747>, 
      <1.285253, -0.720947, -1.257534>, <1.292127, -0.727182, -1.253185>, <1.296210, -0.735665, -1.259376>, <1.305197, -0.739481, -1.256258>, 
      <1.285355, -0.719361, -1.258560>, <1.293409, -0.719073, -1.262203>, <1.299233, -0.729670, -1.263319>, <1.307780, -0.728512, -1.265279>, 
      <1.285082, -0.717637, -1.259225>, <1.293136, -0.717349, -1.262868>, <1.297035, -0.718060, -1.266537>, <1.305581, -0.716903, -1.268497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.283029, -0.717511, -1.254408>, <1.287444, -0.713484, -1.243850>, <1.284737, -0.710848, -1.234131>, <1.294267, -0.707260, -1.227536>, 
      <1.283256, -0.718948, -1.253854>, <1.287672, -0.714921, -1.243296>, <1.287208, -0.723896, -1.230515>, <1.296738, -0.720308, -1.223919>, 
      <1.283911, -0.720865, -1.254384>, <1.290785, -0.727099, -1.250035>, <1.289457, -0.729909, -1.234926>, <1.298443, -0.733725, -1.231809>, 
      <1.284521, -0.720902, -1.255816>, <1.291395, -0.727137, -1.251467>, <1.293030, -0.732955, -1.247864>, <1.302017, -0.736771, -1.244747>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.283341, -0.713442, -1.258692>, <1.287377, -0.705173, -1.258046>, <1.287425, -0.699236, -1.257146>, <1.293613, -0.692396, -1.257048>, 
      <1.282430, -0.713386, -1.256554>, <1.286466, -0.705117, -1.255908>, <1.284053, -0.696362, -1.244940>, <1.290242, -0.689522, -1.244842>, 
      <1.282690, -0.715365, -1.255235>, <1.287105, -0.711338, -1.244677>, <1.282406, -0.698538, -1.237544>, <1.291936, -0.694950, -1.230948>, 
      <1.283029, -0.717511, -1.254408>, <1.287444, -0.713484, -1.243850>, <1.284737, -0.710848, -1.234131>, <1.294267, -0.707260, -1.227536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.283341, -0.713442, -1.258692>, <1.284045, -0.713485, -1.260344>, <1.284820, -0.715978, -1.259864>, <1.285082, -0.717637, -1.259225>, 
      <1.287377, -0.705173, -1.258046>, <1.288081, -0.705216, -1.259699>, <1.292874, -0.715690, -1.263507>, <1.293136, -0.717349, -1.262868>, 
      <1.287425, -0.699236, -1.257146>, <1.290442, -0.701807, -1.268071>, <1.294948, -0.707043, -1.269591>, <1.297035, -0.718060, -1.266537>, 
      <1.293613, -0.692396, -1.257048>, <1.296630, -0.694968, -1.267972>, <1.303495, -0.705886, -1.271551>, <1.305581, -0.716903, -1.268497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.356077, -0.751286, -1.230996>, <1.360528, -0.756310, -1.254553>, <1.361483, -0.731124, -1.269365>, <1.357098, -0.707883, -1.275739>, 
      <1.333528, -0.751116, -1.233087>, <1.337979, -0.756139, -1.256645>, <1.341064, -0.734696, -1.268554>, <1.336679, -0.711455, -1.274929>, 
      <1.321874, -0.745203, -1.237859>, <1.325054, -0.747913, -1.249371>, <1.327826, -0.725797, -1.269875>, <1.325627, -0.714188, -1.273094>, 
      <1.302017, -0.736771, -1.244747>, <1.305197, -0.739481, -1.256258>, <1.307780, -0.728512, -1.265279>, <1.305581, -0.716903, -1.268497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.356077, -0.751286, -1.230996>, <1.399510, -0.751614, -1.226968>, <1.423493, -0.744860, -1.234401>, <1.466294, -0.738011, -1.229510>, 
      <1.360528, -0.756310, -1.254553>, <1.403961, -0.756638, -1.250525>, <1.442707, -0.747163, -1.256768>, <1.485508, -0.740315, -1.251877>, 
      <1.361483, -0.731124, -1.269365>, <1.414277, -0.721889, -1.271460>, <1.444497, -0.723221, -1.273053>, <1.496696, -0.712243, -1.267425>, 
      <1.357098, -0.707883, -1.275739>, <1.409892, -0.698648, -1.277834>, <1.439375, -0.695345, -1.281507>, <1.491573, -0.684367, -1.275879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.356077, -0.751286, -1.230996>, <1.333528, -0.751116, -1.233087>, <1.321874, -0.745203, -1.237859>, <1.302017, -0.736771, -1.244747>, 
      <1.351698, -0.746344, -1.207821>, <1.329150, -0.746174, -1.209912>, <1.318301, -0.742157, -1.224921>, <1.298443, -0.733725, -1.231809>, 
      <1.349282, -0.717056, -1.205269>, <1.328611, -0.721707, -1.208980>, <1.313634, -0.713947, -1.212225>, <1.296738, -0.720308, -1.223919>, 
      <1.344968, -0.694192, -1.211540>, <1.324297, -0.698843, -1.215251>, <1.311163, -0.700899, -1.215842>, <1.294267, -0.707260, -1.227536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.356077, -0.751286, -1.230996>, <1.351698, -0.746344, -1.207821>, <1.349282, -0.717056, -1.205269>, <1.344968, -0.694192, -1.211540>, 
      <1.399510, -0.751614, -1.226968>, <1.395131, -0.746672, -1.203793>, <1.381909, -0.709715, -1.199413>, <1.377595, -0.686851, -1.205683>, 
      <1.423493, -0.744860, -1.234401>, <1.404061, -0.742530, -1.211782>, <1.401269, -0.711712, -1.197972>, <1.396088, -0.683522, -1.206521>, 
      <1.466294, -0.738011, -1.229510>, <1.446863, -0.735681, -1.206891>, <1.434412, -0.705084, -1.194760>, <1.429231, -0.676893, -1.203309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.337617, -0.653453, -1.257828>, <1.333184, -0.648449, -1.234363>, <1.340600, -0.671043, -1.217889>, <1.344968, -0.694192, -1.211540>, 
      <1.316133, -0.661888, -1.257191>, <1.311700, -0.656884, -1.233727>, <1.319929, -0.675693, -1.221600>, <1.324297, -0.698843, -1.215251>, 
      <1.309103, -0.675276, -1.256801>, <1.305732, -0.672402, -1.244595>, <1.308832, -0.688589, -1.219255>, <1.311163, -0.700899, -1.215842>, 
      <1.293613, -0.692396, -1.257048>, <1.290242, -0.689522, -1.244842>, <1.291936, -0.694950, -1.230948>, <1.294267, -0.707260, -1.227536>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.337617, -0.653453, -1.257828>, <1.378322, -0.637471, -1.259034>, <1.404764, -0.643558, -1.265303>, <1.446855, -0.632230, -1.261589>, 
      <1.333184, -0.648449, -1.234363>, <1.373889, -0.632467, -1.235570>, <1.385490, -0.641247, -1.242867>, <1.427581, -0.629919, -1.239153>, 
      <1.340600, -0.671043, -1.217889>, <1.373227, -0.663702, -1.212032>, <1.390950, -0.655559, -1.215001>, <1.424093, -0.648931, -1.211789>, 
      <1.344968, -0.694192, -1.211540>, <1.377595, -0.686851, -1.205683>, <1.396088, -0.683522, -1.206521>, <1.429231, -0.676893, -1.203309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.337617, -0.653453, -1.257828>, <1.316133, -0.661888, -1.257191>, <1.309103, -0.675276, -1.256801>, <1.293613, -0.692396, -1.257048>, 
      <1.341938, -0.658330, -1.280697>, <1.320454, -0.666765, -1.280060>, <1.312120, -0.677847, -1.267726>, <1.296630, -0.694968, -1.267972>, 
      <1.352841, -0.685322, -1.281927>, <1.332422, -0.688893, -1.281116>, <1.323541, -0.703171, -1.276148>, <1.303495, -0.705886, -1.271551>, 
      <1.357098, -0.707883, -1.275739>, <1.336679, -0.711455, -1.274929>, <1.325627, -0.714188, -1.273094>, <1.305581, -0.716903, -1.268497>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.337617, -0.653453, -1.257828>, <1.341938, -0.658330, -1.280697>, <1.352841, -0.685322, -1.281927>, <1.357098, -0.707883, -1.275739>, 
      <1.378322, -0.637471, -1.259034>, <1.382643, -0.642348, -1.281903>, <1.405635, -0.676086, -1.284022>, <1.409892, -0.698648, -1.277834>, 
      <1.404764, -0.643558, -1.265303>, <1.422671, -0.645705, -1.286149>, <1.434600, -0.669366, -1.289386>, <1.439375, -0.695345, -1.281507>, 
      <1.446855, -0.632230, -1.261589>, <1.464762, -0.634377, -1.282435>, <1.486799, -0.658387, -1.283758>, <1.491573, -0.684367, -1.275879>
    }
  }
  texture {
    Body01
  }
}
#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.688519, -0.799083, 3.741898>, <0.726101, -0.804138, 3.744726>, <0.776884, -0.823924, 3.755798>, <0.813791, -0.815933, 3.751326>, 
      <0.688519, -0.707305, 3.807387>, <0.726101, -0.712360, 3.810216>, <0.776884, -0.728611, 3.824048>, <0.813791, -0.720620, 3.819576>, 
      <0.688519, -0.599833, 3.923700>, <0.726101, -0.601354, 3.929289>, <0.776885, -0.611349, 3.949152>, <0.813791, -0.608946, 3.940316>, 
      <0.688519, -0.493155, 3.960195>, <0.726101, -0.494675, 3.965784>, <0.776885, -0.500626, 3.987662>, <0.813791, -0.498223, 3.978826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.921981, -0.748537, 3.713612>, <0.921981, -0.667362, 3.770820>, <0.921981, -0.572425, 3.873687>, <0.921981, -0.477954, 3.904303>, 
      <0.889524, -0.768756, 3.724926>, <0.889524, -0.687581, 3.782134>, <0.889524, -0.578505, 3.896044>, <0.889524, -0.484035, 3.926660>, 
      <0.852496, -0.807553, 3.746637>, <0.852496, -0.712240, 3.814886>, <0.852496, -0.606426, 3.931050>, <0.852496, -0.495703, 3.969560>, 
      <0.813791, -0.815933, 3.751326>, <0.813791, -0.720620, 3.819576>, <0.813791, -0.608946, 3.940316>, <0.813791, -0.498223, 3.978826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.688519, 0.097082, 4.048479>, <0.688519, -0.081946, 4.046355>, <0.688519, -0.323753, 4.018148>, <0.688519, -0.493155, 3.960195>, 
      <0.726101, 0.095562, 4.054068>, <0.726101, -0.083467, 4.051945>, <0.726101, -0.325273, 4.023737>, <0.726101, -0.494675, 3.965784>, 
      <0.776885, 0.089611, 4.075946>, <0.776885, -0.089425, 4.074671>, <0.776885, -0.331521, 4.046476>, <0.776885, -0.500626, 3.987662>, 
      <0.813791, 0.092014, 4.067110>, <0.813791, -0.087022, 4.065835>, <0.813791, -0.329118, 4.037640>, <0.813791, -0.498223, 3.978826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.921981, 0.112283, 3.992586>, <0.889524, 0.106202, 4.014943>, <0.852496, 0.094534, 4.057844>, <0.813791, 0.092014, 4.067110>, 
      <0.921981, -0.066692, 3.987734>, <0.889524, -0.072773, 4.010091>, <0.852496, -0.084502, 4.056569>, <0.813791, -0.087022, 4.065835>, 
      <0.921981, -0.307634, 3.959500>, <0.889524, -0.313715, 3.981857>, <0.852496, -0.326598, 4.028375>, <0.813791, -0.329118, 4.037640>, 
      <0.921981, -0.477954, 3.904303>, <0.889524, -0.484035, 3.926660>, <0.852496, -0.495703, 3.969560>, <0.813791, -0.498223, 3.978826>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.688519, 0.617505, 3.973372>, <0.692565, 0.485558, 4.059726>, <0.688519, 0.254815, 4.050351>, <0.688519, 0.097082, 4.048479>, 
      <0.726101, 0.621647, 3.977422>, <0.730146, 0.489700, 4.063776>, <0.726101, 0.253295, 4.055940>, <0.726101, 0.095562, 4.054068>, 
      <0.776884, 0.637858, 3.993272>, <0.780980, 0.500711, 4.082317>, <0.776885, 0.253177, 4.077111>, <0.776885, 0.089611, 4.075946>, 
      <0.813791, 0.631311, 3.986871>, <0.817886, 0.494164, 4.075916>, <0.813791, 0.255580, 4.068275>, <0.813791, 0.092014, 4.067110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.921981, 0.576089, 3.932878>, <0.889524, 0.592656, 3.949076>, <0.852496, 0.624445, 3.980158>, <0.813791, 0.631311, 3.986871>, 
      <0.925863, 0.459685, 4.011084>, <0.893405, 0.476251, 4.027283>, <0.856591, 0.487297, 4.069202>, <0.817886, 0.494164, 4.075916>, 
      <0.921981, 0.252522, 3.996388>, <0.889524, 0.246441, 4.018745>, <0.852496, 0.258100, 4.059008>, <0.813791, 0.255580, 4.068275>, 
      <0.921981, 0.112283, 3.992586>, <0.889524, 0.106202, 4.014943>, <0.852496, 0.094534, 4.057844>, <0.813791, 0.092014, 4.067110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.662859, 0.933962, 3.500776>, <0.666669, 0.876705, 3.661651>, <0.684138, 0.760374, 3.879870>, <0.688519, 0.617505, 3.973372>, 
      <0.700441, 0.939178, 3.503296>, <0.704251, 0.881921, 3.664171>, <0.721720, 0.764516, 3.883920>, <0.726101, 0.621647, 3.977422>, 
      <0.751224, 0.959593, 3.513160>, <0.755027, 0.901634, 3.675766>, <0.772562, 0.782635, 3.899274>, <0.776884, 0.637858, 3.993272>, 
      <0.788131, 0.951348, 3.509176>, <0.791933, 0.893389, 3.671783>, <0.809468, 0.776088, 3.892872>, <0.813791, 0.631311, 3.986871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.896321, 0.881808, 3.475577>, <0.863864, 0.902670, 3.485657>, <0.826836, 0.942702, 3.504998>, <0.788131, 0.951348, 3.509176>, 
      <0.900155, 0.826656, 3.631256>, <0.867698, 0.847518, 3.641335>, <0.830638, 0.884743, 3.667606>, <0.791933, 0.893389, 3.671783>, 
      <0.917410, 0.713165, 3.840783>, <0.884953, 0.729731, 3.856981>, <0.848173, 0.769222, 3.886159>, <0.809468, 0.776088, 3.892872>, 
      <0.921981, 0.576089, 3.932878>, <0.889524, 0.592656, 3.949076>, <0.852496, 0.624445, 3.980158>, <0.813791, 0.631311, 3.986871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.662859, 1.003136, 2.889874>, <0.662859, 1.006345, 3.074288>, <0.658745, 0.995792, 3.327055>, <0.662859, 0.933962, 3.500776>, 
      <0.700441, 1.008928, 2.889770>, <0.700441, 1.012137, 3.074184>, <0.696326, 1.001007, 3.329575>, <0.700441, 0.939178, 3.503296>, 
      <0.751225, 1.031596, 2.889362>, <0.751225, 1.034612, 3.076452>, <0.747104, 1.022400, 3.336949>, <0.751224, 0.959593, 3.513160>, 
      <0.788131, 1.022441, 2.889527>, <0.788131, 1.025456, 3.076617>, <0.784011, 1.014155, 3.332966>, <0.788131, 0.951348, 3.509176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.896321, 0.945222, 2.890917>, <0.863864, 0.968388, 2.890500>, <0.826836, 1.012840, 2.889700>, <0.788131, 1.022441, 2.889527>, 
      <0.896321, 0.948999, 3.067303>, <0.863864, 0.972164, 3.066886>, <0.826836, 1.015855, 3.076790>, <0.788131, 1.025456, 3.076617>, 
      <0.892227, 0.940707, 3.309323>, <0.859770, 0.961569, 3.319402>, <0.822715, 1.005509, 3.328788>, <0.784011, 1.014155, 3.332966>, 
      <0.896321, 0.881808, 3.475577>, <0.863864, 0.902670, 3.485657>, <0.826836, 0.942702, 3.504998>, <0.788131, 0.951348, 3.509176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.662859, 0.911277, 2.197173>, <0.668024, 0.960953, 2.400766>, <0.662859, 0.999489, 2.680276>, <0.662859, 1.003136, 2.889874>, 
      <0.700441, 0.916935, 2.195931>, <0.705605, 0.966611, 2.399524>, <0.700441, 1.005280, 2.680172>, <0.700441, 1.008928, 2.889770>, 
      <0.751224, 0.939081, 2.191070>, <0.756403, 0.988960, 2.395793>, <0.751225, 1.028200, 2.678614>, <0.751225, 1.031596, 2.889362>, 
      <0.788131, 0.930137, 2.193033>, <0.793310, 0.980016, 2.397756>, <0.788131, 1.019045, 2.678779>, <0.788131, 1.022441, 2.889527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.896321, 0.854701, 2.209589>, <0.863864, 0.877332, 2.204622>, <0.826836, 0.920757, 2.195091>, <0.788131, 0.930137, 2.193033>, 
      <0.901443, 0.903766, 2.409795>, <0.868986, 0.926396, 2.404829>, <0.832015, 0.970636, 2.399814>, <0.793310, 0.980016, 2.397756>, 
      <0.896321, 0.940808, 2.684770>, <0.863864, 0.963974, 2.684353>, <0.826836, 1.009443, 2.678952>, <0.788131, 1.019045, 2.678779>, 
      <0.896321, 0.945222, 2.890917>, <0.863864, 0.968388, 2.890500>, <0.826836, 1.012840, 2.889700>, <0.788131, 1.022441, 2.889527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.628646, 0.674068, 1.541208>, <0.636807, 0.722666, 1.744843>, <0.657697, 0.861629, 1.993693>, <0.662859, 0.911277, 2.197173>, 
      <0.666228, 0.679726, 1.539966>, <0.674389, 0.728324, 1.743601>, <0.695279, 0.867287, 1.992451>, <0.700441, 0.916935, 2.195931>, 
      <0.717012, 0.701871, 1.535106>, <0.725173, 0.750469, 1.738741>, <0.746077, 0.889501, 1.987574>, <0.751224, 0.939081, 2.191070>, 
      <0.753918, 0.692927, 1.537069>, <0.762079, 0.741525, 1.740704>, <0.782983, 0.880557, 1.989537>, <0.788131, 0.930137, 2.193033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.862108, 0.617491, 1.553625>, <0.829651, 0.640122, 1.548658>, <0.792623, 0.683547, 1.539128>, <0.753918, 0.692927, 1.537069>, 
      <0.870269, 0.666089, 1.757260>, <0.837812, 0.688720, 1.752293>, <0.800784, 0.732145, 1.742762>, <0.762079, 0.741525, 1.740704>, 
      <0.891116, 0.804847, 2.006161>, <0.858660, 0.827477, 2.001194>, <0.821688, 0.871177, 1.991595>, <0.782983, 0.880557, 1.989537>, 
      <0.896321, 0.854701, 2.209589>, <0.863864, 0.877332, 2.204622>, <0.826836, 0.920757, 2.195091>, <0.788131, 0.930137, 2.193033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.611539, 0.605690, 0.916706>, <0.616671, 0.626203, 1.104057>, <0.621301, 0.630335, 1.357957>, <0.628646, 0.674068, 1.541208>, 
      <0.649121, 0.611348, 0.915464>, <0.654253, 0.631861, 1.102815>, <0.658883, 0.635992, 1.356716>, <0.666228, 0.679726, 1.539966>, 
      <0.699905, 0.633494, 0.910604>, <0.705037, 0.654007, 1.097955>, <0.709667, 0.658138, 1.351855>, <0.717012, 0.701871, 1.535106>, 
      <0.736812, 0.624550, 0.912567>, <0.741944, 0.645063, 1.099918>, <0.746574, 0.649194, 1.353818>, <0.753918, 0.692927, 1.537069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.845002, 0.549114, 0.929123>, <0.812545, 0.571745, 0.924156>, <0.775517, 0.615170, 0.914626>, <0.736812, 0.624550, 0.912567>, 
      <0.850134, 0.569627, 1.116474>, <0.817677, 0.592258, 1.111507>, <0.780649, 0.635684, 1.101976>, <0.741944, 0.645063, 1.099918>, 
      <0.854764, 0.573758, 1.370374>, <0.822307, 0.596388, 1.365407>, <0.785278, 0.639814, 1.355877>, <0.746574, 0.649194, 1.353818>, 
      <0.862108, 0.617491, 1.553625>, <0.829651, 0.640122, 1.548658>, <0.792623, 0.683547, 1.539128>, <0.753918, 0.692927, 1.537069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343188, -0.493155, 3.960195>, <-0.348735, -0.503028, 3.996495>, <-0.431554, -0.500626, 3.987662>, <-0.468460, -0.498223, 3.978826>, 
      <-0.343188, -0.316084, 3.986680>, <-0.348735, -0.325957, 4.022980>, <-0.431554, -0.323555, 4.014147>, <-0.468460, -0.321152, 4.005312>, 
      <-0.343188, -0.081947, 4.046354>, <-0.380770, -0.083467, 4.051944>, <-0.431553, -0.089426, 4.074671>, <-0.468460, -0.087022, 4.065835>, 
      <-0.343188, 0.097081, 4.048478>, <-0.380770, 0.095561, 4.054068>, <-0.431553, 0.089611, 4.075946>, <-0.468460, 0.092014, 4.067110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.576650, -0.477954, 3.904303>, <-0.576650, -0.300883, 3.930788>, <-0.576650, -0.066692, 3.987734>, <-0.576650, 0.112283, 3.992586>, 
      <-0.582467, -0.488308, 3.942372>, <-0.582467, -0.311237, 3.968856>, <-0.544193, -0.072773, 4.010091>, <-0.544193, 0.106202, 4.014943>, 
      <-0.507165, -0.495703, 3.969560>, <-0.507165, -0.318632, 3.996045>, <-0.507165, -0.084502, 4.056569>, <-0.507165, 0.094534, 4.057844>, 
      <-0.468460, -0.498223, 3.978826>, <-0.468460, -0.321152, 4.005312>, <-0.468460, -0.087022, 4.065835>, <-0.468460, 0.092014, 4.067110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.343188, 0.617505, 3.973372>, <-0.347234, 0.485558, 4.059726>, <-0.343188, 0.254815, 4.050350>, <-0.343188, 0.097081, 4.048478>, 
      <-0.380770, 0.621647, 3.977422>, <-0.384815, 0.489700, 4.063776>, <-0.380770, 0.253294, 4.055939>, <-0.380770, 0.095561, 4.054068>, 
      <-0.431553, 0.637858, 3.993272>, <-0.435649, 0.500711, 4.082317>, <-0.431553, 0.253177, 4.077111>, <-0.431553, 0.089611, 4.075946>, 
      <-0.468460, 0.631311, 3.986871>, <-0.472555, 0.494164, 4.075916>, <-0.468460, 0.255580, 4.068275>, <-0.468460, 0.092014, 4.067110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.576650, 0.576089, 3.932878>, <-0.544193, 0.592656, 3.949076>, <-0.507165, 0.624445, 3.980158>, <-0.468460, 0.631311, 3.986871>, 
      <-0.580532, 0.459685, 4.011084>, <-0.548075, 0.476251, 4.027283>, <-0.511260, 0.487297, 4.069202>, <-0.472555, 0.494164, 4.075916>, 
      <-0.576650, 0.252522, 3.996388>, <-0.544193, 0.246441, 4.018745>, <-0.507165, 0.258100, 4.059008>, <-0.468460, 0.255580, 4.068275>, 
      <-0.576650, 0.112283, 3.992586>, <-0.544193, 0.106202, 4.014943>, <-0.507165, 0.094534, 4.057844>, <-0.468460, 0.092014, 4.067110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.317528, 0.933962, 3.500776>, <-0.321338, 0.876705, 3.661651>, <-0.338807, 0.760375, 3.879870>, <-0.343188, 0.617505, 3.973372>, 
      <-0.355110, 0.939178, 3.503296>, <-0.358920, 0.881921, 3.664171>, <-0.376389, 0.764516, 3.883920>, <-0.380770, 0.621647, 3.977422>, 
      <-0.405894, 0.959593, 3.513160>, <-0.409696, 0.901634, 3.675766>, <-0.427230, 0.782635, 3.899274>, <-0.431553, 0.637858, 3.993272>, 
      <-0.442800, 0.951348, 3.509176>, <-0.446602, 0.893389, 3.671783>, <-0.464137, 0.776088, 3.892872>, <-0.468460, 0.631311, 3.986871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.550990, 0.881808, 3.475577>, <-0.518533, 0.902670, 3.485657>, <-0.481505, 0.942702, 3.504998>, <-0.442800, 0.951348, 3.509176>, 
      <-0.554824, 0.826656, 3.631256>, <-0.522367, 0.847518, 3.641335>, <-0.485307, 0.884743, 3.667606>, <-0.446602, 0.893389, 3.671783>, 
      <-0.572079, 0.713165, 3.840783>, <-0.539622, 0.729731, 3.856981>, <-0.502842, 0.769222, 3.886159>, <-0.464137, 0.776088, 3.892872>, 
      <-0.576650, 0.576089, 3.932878>, <-0.544193, 0.592656, 3.949076>, <-0.507165, 0.624445, 3.980158>, <-0.468460, 0.631311, 3.986871>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.317528, 1.003135, 2.889874>, <-0.317528, 1.002372, 3.074314>, <-0.313414, 0.995791, 3.327055>, <-0.317528, 0.933962, 3.500776>, 
      <-0.355110, 1.008927, 2.889770>, <-0.355110, 1.008163, 3.074210>, <-0.350996, 1.001007, 3.329575>, <-0.355110, 0.939178, 3.503296>, 
      <-0.405894, 1.031596, 2.889362>, <-0.405894, 1.030620, 3.076474>, <-0.401773, 1.022400, 3.336949>, <-0.405894, 0.959593, 3.513160>, 
      <-0.442800, 1.022441, 2.889527>, <-0.442800, 1.021465, 3.076639>, <-0.438680, 1.014155, 3.332966>, <-0.442800, 0.951348, 3.509176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.550990, 0.945222, 2.890917>, <-0.518533, 0.968388, 2.890500>, <-0.481505, 1.012840, 2.889700>, <-0.442800, 1.022441, 2.889527>, 
      <-0.550990, 0.945086, 3.067344>, <-0.518533, 0.968252, 3.066927>, <-0.481505, 1.011863, 3.076812>, <-0.442800, 1.021465, 3.076639>, 
      <-0.546896, 0.940707, 3.309323>, <-0.514439, 0.961569, 3.319402>, <-0.477384, 1.005509, 3.328788>, <-0.438680, 1.014155, 3.332966>, 
      <-0.550990, 0.881808, 3.475577>, <-0.518533, 0.902670, 3.485657>, <-0.481505, 0.942702, 3.504998>, <-0.442800, 0.951348, 3.509176>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.317528, 0.939358, 2.197173>, <-0.322772, 0.967388, 2.403905>, <-0.317528, 1.003999, 2.681187>, <-0.317528, 1.003135, 2.889874>, 
      <-0.355110, 0.945016, 2.195931>, <-0.360354, 0.973046, 2.402663>, <-0.355110, 1.009791, 2.681082>, <-0.355110, 1.008927, 2.889770>, 
      <-0.405894, 0.967161, 2.191070>, <-0.411152, 0.995335, 2.398938>, <-0.405894, 1.032691, 2.679530>, <-0.405894, 1.031596, 2.889362>, 
      <-0.442800, 0.958217, 2.193033>, <-0.448058, 0.986391, 2.400901>, <-0.442800, 1.023536, 2.679695>, <-0.442800, 1.022441, 2.889527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.550990, 0.882781, 2.209589>, <-0.518533, 0.905412, 2.204622>, <-0.481505, 0.948837, 2.195091>, <-0.442800, 0.958217, 2.193033>, 
      <-0.556192, 0.910380, 2.412914>, <-0.523735, 0.933011, 2.407947>, <-0.486763, 0.977011, 2.402959>, <-0.448058, 0.986391, 2.400901>, 
      <-0.550990, 0.945380, 2.685662>, <-0.518533, 0.968545, 2.685245>, <-0.481505, 1.013935, 2.679868>, <-0.442800, 1.023536, 2.679695>, 
      <-0.550990, 0.945222, 2.890917>, <-0.518533, 0.968388, 2.890500>, <-0.481505, 1.012840, 2.889700>, <-0.442800, 1.022441, 2.889527>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.283315, 0.820275, 1.541208>, <-0.291209, 0.855648, 1.738170>, <-0.312495, 0.912459, 1.998783>, <-0.317528, 0.939358, 2.197173>, 
      <-0.320897, 0.825933, 1.539966>, <-0.328791, 0.861305, 1.736929>, <-0.350077, 0.918117, 1.997540>, <-0.355110, 0.945016, 2.195931>, 
      <-0.371681, 0.848078, 1.535106>, <-0.379574, 0.883450, 1.732068>, <-0.400875, 0.940272, 1.992678>, <-0.405894, 0.967161, 2.191070>, 
      <-0.408587, 0.839134, 1.537069>, <-0.416481, 0.874507, 1.734031>, <-0.437781, 0.931328, 1.994641>, <-0.442800, 0.958217, 2.193033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.516777, 0.763699, 1.553625>, <-0.484320, 0.786330, 1.548658>, <-0.447292, 0.829754, 1.539128>, <-0.408587, 0.839134, 1.537069>, 
      <-0.524671, 0.799072, 1.750587>, <-0.492214, 0.821702, 1.745620>, <-0.455186, 0.865127, 1.736090>, <-0.416481, 0.874507, 1.734031>, 
      <-0.545915, 0.855852, 2.011204>, <-0.513458, 0.878483, 2.006237>, <-0.476486, 0.921948, 1.996699>, <-0.437781, 0.931328, 1.994641>, 
      <-0.550990, 0.882781, 2.209589>, <-0.518533, 0.905412, 2.204622>, <-0.481505, 0.948837, 2.195091>, <-0.442800, 0.958217, 2.193033>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.266208, 0.709397, 0.916706>, <-0.271340, 0.742660, 1.104057>, <-0.275812, 0.786654, 1.354001>, <-0.283315, 0.820275, 1.541208>, 
      <-0.303790, 0.715055, 0.915464>, <-0.308922, 0.748318, 1.102815>, <-0.313393, 0.792312, 1.352760>, <-0.320897, 0.825933, 1.539966>, 
      <-0.354574, 0.737200, 0.910604>, <-0.359706, 0.770463, 1.097955>, <-0.364178, 0.814457, 1.347899>, <-0.371681, 0.848078, 1.535106>, 
      <-0.391481, 0.728256, 0.912567>, <-0.396613, 0.761519, 1.099918>, <-0.401084, 0.805513, 1.349862>, <-0.408587, 0.839134, 1.537069>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.499671, 0.652820, 0.929123>, <-0.467214, 0.675451, 0.924156>, <-0.430186, 0.718876, 0.914626>, <-0.391481, 0.728256, 0.912567>, 
      <-0.504803, 0.686084, 1.116474>, <-0.472346, 0.708715, 1.111507>, <-0.435318, 0.752140, 1.101976>, <-0.396613, 0.761519, 1.099918>, 
      <-0.509274, 0.730078, 1.366418>, <-0.476817, 0.752709, 1.361451>, <-0.439789, 0.796134, 1.351921>, <-0.401084, 0.805513, 1.349862>, 
      <-0.516777, 0.763699, 1.553625>, <-0.484320, 0.786330, 1.548658>, <-0.447292, 0.829754, 1.539128>, <-0.408587, 0.839134, 1.537069>
    }
  }
  texture {
    Pants
  }
}
#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.189828, -0.162809, -0.592487>, <-1.266752, -0.117681, -0.617246>, <-1.418717, -0.115836, -0.659181>, <-1.492404, -0.171402, -0.652152>, 
      <-1.218253, -0.006671, -0.290202>, <-1.295177, 0.038456, -0.314961>, <-1.445479, 0.034155, -0.325166>, <-1.519165, -0.021411, -0.318137>, 
      <-1.256919, 0.241824, 0.095158>, <-1.330127, 0.294851, 0.089114>, <-1.473415, 0.261128, 0.093493>, <-1.547722, 0.213620, 0.114218>, 
      <-1.284578, 0.357650, 0.415131>, <-1.357786, 0.410677, 0.409087>, <-1.507303, 0.376074, 0.440506>, <-1.581609, 0.328567, 0.461231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.995812, -0.462731, -0.492315>, <-0.998495, -0.359554, -0.533957>, <-1.097331, -0.217073, -0.562715>, <-1.189828, -0.162809, -0.592487>, 
      <-1.022632, -0.333209, -0.193957>, <-1.025316, -0.230033, -0.235599>, <-1.125756, -0.060935, -0.260430>, <-1.218253, -0.006671, -0.290202>, 
      <-1.055957, -0.119089, 0.189329>, <-1.053464, 0.004224, 0.137938>, <-1.148949, 0.163616, 0.104072>, <-1.256919, 0.241824, 0.095158>, 
      <-1.085213, -0.030992, 0.502212>, <-1.082720, 0.092322, 0.450821>, <-1.176607, 0.279443, 0.424045>, <-1.284578, 0.357650, 0.415131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.170243, -0.915816, -0.288576>, <-1.059347, -0.807613, -0.319304>, <-0.992003, -0.609164, -0.433215>, <-0.995812, -0.462731, -0.492315>, 
      <-1.208934, -0.750922, 0.013031>, <-1.098038, -0.642719, -0.017697>, <-1.018824, -0.479642, -0.134857>, <-1.022632, -0.333209, -0.193957>, 
      <-1.264881, -0.480882, 0.392257>, <-1.155695, -0.419586, 0.340324>, <-1.058486, -0.244195, 0.241467>, <-1.055957, -0.119089, 0.189329>, 
      <-1.299212, -0.366168, 0.716782>, <-1.190025, -0.304871, 0.664849>, <-1.087742, -0.156097, 0.554350>, <-1.085213, -0.030992, 0.502212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.479108, -0.934290, -0.358399>, <-1.406188, -0.984469, -0.323470>, <-1.237052, -0.981002, -0.270064>, <-1.170243, -0.915816, -0.288576>, 
      <-1.515580, -0.750114, -0.026664>, <-1.442660, -0.800293, 0.008265>, <-1.275742, -0.816108, 0.031543>, <-1.208934, -0.750922, 0.013031>, 
      <-1.556295, -0.450105, 0.391720>, <-1.483248, -0.501964, 0.412396>, <-1.338934, -0.522455, 0.427479>, <-1.264881, -0.480882, 0.392257>, 
      <-1.600680, -0.320371, 0.747386>, <-1.527634, -0.372229, 0.768062>, <-1.373264, -0.407740, 0.752004>, <-1.299212, -0.366168, 0.716782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.702598, -0.549481, -0.543573>, <-1.700247, -0.684403, -0.491621>, <-1.589912, -0.858041, -0.411474>, <-1.479108, -0.934290, -0.358399>, 
      <-1.740436, -0.381711, -0.210431>, <-1.738085, -0.516633, -0.158479>, <-1.626384, -0.673866, -0.079738>, <-1.515580, -0.750114, -0.026664>, 
      <-1.786484, -0.097757, 0.210221>, <-1.790032, -0.218480, 0.263455>, <-1.661161, -0.375657, 0.362037>, <-1.556295, -0.450105, 0.391720>, 
      <-1.828726, 0.009752, 0.566899>, <-1.832274, -0.110971, 0.620133>, <-1.705546, -0.245923, 0.717703>, <-1.600680, -0.320371, 0.747386>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.702598, -0.549481, -0.543573>, <-1.740436, -0.381711, -0.210431>, <-1.786484, -0.097757, 0.210221>, <-1.828726, 0.009752, 0.566899>, 
      <-1.704774, -0.424635, -0.591646>, <-1.742612, -0.256865, -0.258504>, <-1.783121, 0.016663, 0.159767>, <-1.825364, 0.124172, 0.516445>, 
      <-1.598925, -0.251728, -0.641991>, <-1.625687, -0.101737, -0.307976>, <-1.650322, 0.148023, 0.142834>, <-1.684210, 0.262970, 0.489847>, 
      <-1.492404, -0.171402, -0.652152>, <-1.519165, -0.021411, -0.318137>, <-1.547722, 0.213620, 0.114218>, <-1.581609, 0.328567, 0.461231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.386994, 0.662865, 1.688457>, <-1.401126, 0.631439, 1.295948>, <-1.316498, 0.491323, 0.784405>, <-1.284578, 0.357650, 0.415131>, 
      <-1.463351, 0.730978, 1.696415>, <-1.477482, 0.699552, 1.303907>, <-1.389706, 0.544350, 0.778361>, <-1.357786, 0.410677, 0.409087>, 
      <-1.647294, 0.681882, 1.710508>, <-1.678652, 0.652423, 1.323047>, <-1.543287, 0.498134, 0.808995>, <-1.507303, 0.376074, 0.440506>, 
      <-1.724132, 0.614626, 1.720792>, <-1.755489, 0.585167, 1.333331>, <-1.617593, 0.450627, 0.829719>, <-1.581609, 0.328567, 0.461231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.197619, 0.144954, 1.665915>, <-1.192444, 0.112405, 1.312764>, <-1.117008, 0.064751, 0.842247>, <-1.085213, -0.030992, 0.502212>, 
      <-1.198843, 0.310510, 1.663902>, <-1.193668, 0.277961, 1.310751>, <-1.114515, 0.188064, 0.790856>, <-1.082720, 0.092322, 0.450821>, 
      <-1.263809, 0.552979, 1.675618>, <-1.277941, 0.521553, 1.283109>, <-1.208528, 0.413115, 0.793319>, <-1.176607, 0.279443, 0.424045>, 
      <-1.386994, 0.662865, 1.688457>, <-1.401126, 0.631439, 1.295948>, <-1.316498, 0.491323, 0.784405>, <-1.284578, 0.357650, 0.415131>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.380515, -0.213201, 1.699109>, <-1.396435, -0.226328, 1.400576>, <-1.328911, -0.266929, 0.997526>, <-1.299212, -0.366168, 0.716782>, 
      <-1.277040, -0.150952, 1.690596>, <-1.292960, -0.164078, 1.392063>, <-1.219724, -0.205633, 0.945593>, <-1.190025, -0.304871, 0.664849>, 
      <-1.196724, 0.023911, 1.667387>, <-1.191548, -0.008638, 1.314236>, <-1.119538, -0.060355, 0.894385>, <-1.087742, -0.156097, 0.554350>, 
      <-1.197619, 0.144954, 1.665915>, <-1.192444, 0.112405, 1.312764>, <-1.117008, 0.064751, 0.842247>, <-1.085213, -0.030992, 0.502212>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.737274, -0.179696, 1.710315>, <-1.768331, -0.182636, 1.417163>, <-1.635008, -0.220034, 1.022459>, <-1.600680, -0.320371, 0.747386>, 
      <-1.645680, -0.235084, 1.699827>, <-1.676737, -0.238024, 1.406675>, <-1.561962, -0.271892, 1.043135>, <-1.527634, -0.372229, 0.768062>, 
      <-1.472447, -0.268506, 1.706673>, <-1.488366, -0.281633, 1.408140>, <-1.402963, -0.308502, 1.032748>, <-1.373264, -0.407740, 0.752004>, 
      <-1.380515, -0.213201, 1.699109>, <-1.396435, -0.226328, 1.400576>, <-1.328911, -0.266929, 0.997526>, <-1.299212, -0.366168, 0.716782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.976282, 0.147064, 1.767326>, <-2.016211, 0.140601, 1.404404>, <-1.869870, 0.114466, 0.914305>, <-1.828726, 0.009752, 0.566899>, 
      <-1.978311, 0.024441, 1.765709>, <-2.018239, 0.017978, 1.402786>, <-1.873418, -0.006257, 0.967539>, <-1.832274, -0.110971, 0.620133>, 
      <-1.841727, -0.116532, 1.722275>, <-1.872784, -0.119472, 1.429123>, <-1.739874, -0.145586, 0.992776>, <-1.705546, -0.245923, 0.717703>, 
      <-1.737274, -0.179696, 1.710315>, <-1.768331, -0.182636, 1.417163>, <-1.635008, -0.220034, 1.022459>, <-1.600680, -0.320371, 0.747386>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.976282, 0.147064, 1.767326>, <-1.973636, 0.307004, 1.769436>, <-1.843903, 0.509791, 1.736822>, <-1.724132, 0.614626, 1.720792>, 
      <-2.016211, 0.140601, 1.404404>, <-2.013564, 0.300542, 1.406513>, <-1.875260, 0.480332, 1.349361>, <-1.755489, 0.585167, 1.333331>, 
      <-1.869870, 0.114466, 0.914305>, <-1.866507, 0.228886, 0.863850>, <-1.720194, 0.385030, 0.858336>, <-1.617593, 0.450627, 0.829719>, 
      <-1.828726, 0.009752, 0.566899>, <-1.825364, 0.124172, 0.516445>, <-1.684210, 0.262970, 0.489847>, <-1.581609, 0.328567, 0.461231>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.202742, 0.539637, 2.688132>, <-1.276170, 0.547056, 2.389943>, <-1.375977, 0.687366, 1.994467>, <-1.386994, 0.662865, 1.688457>, 
      <-1.249031, 0.611772, 2.820390>, <-1.322459, 0.619191, 2.522201>, <-1.452333, 0.755479, 2.002425>, <-1.463351, 0.730978, 1.696415>, 
      <-1.314148, 0.610224, 3.058165>, <-1.463237, 0.622192, 2.629099>, <-1.610745, 0.716218, 2.162121>, <-1.647294, 0.681882, 1.710508>, 
      <-1.360842, 0.535971, 3.189102>, <-1.509931, 0.547940, 2.760035>, <-1.687583, 0.648963, 2.172405>, <-1.724132, 0.614626, 1.720792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.114265, 0.151716, 2.484574>, <-1.153557, 0.160469, 2.241002>, <-1.201221, 0.167609, 1.911723>, <-1.197619, 0.144954, 1.665915>, 
      <-1.115593, 0.285778, 2.486219>, <-1.154885, 0.294531, 2.242647>, <-1.202446, 0.333165, 1.909710>, <-1.198843, 0.310510, 1.663902>, 
      <-1.163362, 0.478269, 2.575614>, <-1.236790, 0.485688, 2.277425>, <-1.252792, 0.577480, 1.981627>, <-1.263809, 0.552979, 1.675618>, 
      <-1.202742, 0.539637, 2.688132>, <-1.276170, 0.547056, 2.389943>, <-1.375977, 0.687366, 1.994467>, <-1.386994, 0.662865, 1.688457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.194622, -0.279928, 2.678076>, <-1.263528, -0.245409, 2.388550>, <-1.364576, -0.200058, 1.998003>, <-1.380515, -0.213201, 1.699109>, 
      <-1.155643, -0.204015, 2.562156>, <-1.224549, -0.169497, 2.272630>, <-1.261101, -0.137809, 1.989490>, <-1.277040, -0.150952, 1.690596>, 
      <-1.112839, 0.007791, 2.482808>, <-1.152130, 0.016544, 2.239236>, <-1.200326, 0.046566, 1.913194>, <-1.196724, 0.023911, 1.667387>, 
      <-1.114265, 0.151716, 2.484574>, <-1.153557, 0.160469, 2.241002>, <-1.201221, 0.167609, 1.911723>, <-1.197619, 0.144954, 1.665915>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.344200, -0.296089, 3.168378>, <-1.494189, -0.243151, 2.742748>, <-1.689407, -0.175164, 2.162143>, <-1.737274, -0.179696, 1.710315>, 
      <-1.295222, -0.350515, 3.033057>, <-1.445211, -0.297577, 2.607427>, <-1.597813, -0.230552, 2.151655>, <-1.645680, -0.235084, 1.699827>, 
      <-1.236287, -0.361071, 2.801982>, <-1.305193, -0.326552, 2.512456>, <-1.456507, -0.255363, 2.005567>, <-1.472447, -0.268506, 1.706673>, 
      <-1.194622, -0.279928, 2.678076>, <-1.263528, -0.245409, 2.388550>, <-1.364576, -0.200058, 1.998003>, <-1.380515, -0.213201, 1.699109>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.502783, 0.062509, 3.529495>, <-1.695948, 0.084519, 3.017151>, <-1.916363, 0.156762, 2.311944>, <-1.976282, 0.147064, 1.767326>, 
      <-1.499586, -0.097326, 3.525514>, <-1.692751, -0.075315, 3.013170>, <-1.918392, 0.034139, 2.310327>, <-1.978311, 0.024441, 1.765709>, 
      <-1.395106, -0.239521, 3.309026>, <-1.545095, -0.186583, 2.883396>, <-1.793861, -0.112000, 2.174103>, <-1.841727, -0.116532, 1.722275>, 
      <-1.344200, -0.296089, 3.168378>, <-1.494189, -0.243151, 2.742748>, <-1.689407, -0.175164, 2.162143>, <-1.737274, -0.179696, 1.710315>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.502783, 0.062509, 3.529495>, <-1.506382, 0.242463, 3.533977>, <-1.414185, 0.451144, 3.338685>, <-1.360842, 0.535971, 3.189102>, 
      <-1.695948, 0.084519, 3.017151>, <-1.699548, 0.264473, 3.021633>, <-1.563274, 0.463113, 2.909619>, <-1.509931, 0.547940, 2.760035>, 
      <-1.916363, 0.156762, 2.311944>, <-1.913717, 0.316703, 2.314054>, <-1.807354, 0.544128, 2.188435>, <-1.687583, 0.648963, 2.172405>, 
      <-1.976282, 0.147064, 1.767326>, <-1.973636, 0.307004, 1.769436>, <-1.843903, 0.509791, 1.736822>, <-1.724132, 0.614626, 1.720792>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.026174, 0.626408, 3.153732>, <-1.152940, 0.598562, 3.075316>, <-1.166495, 0.535975, 2.835328>, <-1.202742, 0.539637, 2.688132>, 
      <-1.027565, 0.685128, 3.289160>, <-1.154331, 0.657282, 3.210744>, <-1.212784, 0.608109, 2.967586>, <-1.249031, 0.611772, 2.820390>, 
      <-1.027856, 0.655004, 3.530389>, <-1.158272, 0.641404, 3.432916>, <-1.260541, 0.605920, 3.212444>, <-1.314148, 0.610224, 3.058165>, 
      <-1.057103, 0.561078, 3.640449>, <-1.187519, 0.547478, 3.542976>, <-1.307234, 0.531667, 3.343380>, <-1.360842, 0.535971, 3.189102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.046444, 0.111278, 2.603065>, <-1.085362, 0.115835, 2.586055>, <-1.107466, 0.150201, 2.526720>, <-1.114265, 0.151716, 2.484574>, 
      <-1.045583, 0.337538, 2.599056>, <-1.084501, 0.342095, 2.582045>, <-1.108795, 0.284264, 2.528364>, <-1.115593, 0.285778, 2.486219>, 
      <-1.024041, 0.536390, 2.946121>, <-1.150807, 0.508544, 2.867705>, <-1.127115, 0.474606, 2.722810>, <-1.163362, 0.478269, 2.575614>, 
      <-1.026174, 0.626408, 3.153732>, <-1.152940, 0.598562, 3.075316>, <-1.166495, 0.535975, 2.835328>, <-1.202742, 0.539637, 2.688132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.030039, -0.388773, 3.171722>, <-1.114384, -0.358202, 3.039861>, <-1.157942, -0.298303, 2.832196>, <-1.194622, -0.279928, 2.678076>, 
      <-1.028466, -0.285667, 2.969240>, <-1.112812, -0.255096, 2.837380>, <-1.118963, -0.222390, 2.716276>, <-1.155643, -0.204015, 2.562156>, 
      <-1.047309, -0.115912, 2.607091>, <-1.086227, -0.111354, 2.590081>, <-1.106040, 0.006277, 2.524954>, <-1.112839, 0.007791, 2.482808>, 
      <-1.046444, 0.111278, 2.603065>, <-1.085362, 0.115835, 2.586055>, <-1.107466, 0.150201, 2.526720>, <-1.114265, 0.151716, 2.484574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.054558, -0.420658, 3.647693>, <-1.172643, -0.392714, 3.525633>, <-1.287386, -0.316142, 3.329604>, <-1.344200, -0.296089, 3.168378>, 
      <-1.023811, -0.500304, 3.532601>, <-1.141897, -0.472360, 3.410541>, <-1.238408, -0.370567, 3.194283>, <-1.295222, -0.350515, 3.033057>, 
      <-1.031031, -0.453796, 3.299417>, <-1.115376, -0.423225, 3.167556>, <-1.199607, -0.379446, 2.956102>, <-1.236287, -0.361071, 2.801982>, 
      <-1.030039, -0.388773, 3.171722>, <-1.114384, -0.358202, 3.039861>, <-1.157942, -0.298303, 2.832196>, <-1.194622, -0.279928, 2.678076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.202874, 0.058937, 3.818681>, <-1.317694, 0.056194, 3.769370>, <-1.458724, 0.057489, 3.646356>, <-1.502783, 0.062509, 3.529495>, 
      <-1.202462, -0.100156, 3.819855>, <-1.317282, -0.102899, 3.770544>, <-1.455527, -0.102346, 3.642375>, <-1.499586, -0.097326, 3.525514>, 
      <-1.088694, -0.332232, 3.775473>, <-1.206780, -0.304288, 3.653412>, <-1.338291, -0.259574, 3.470252>, <-1.395106, -0.239521, 3.309026>, 
      <-1.054558, -0.420658, 3.647693>, <-1.172643, -0.392714, 3.525633>, <-1.287386, -0.316142, 3.329604>, <-1.344200, -0.296089, 3.168378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.202874, 0.058937, 3.818681>, <-1.203304, 0.224656, 3.817458>, <-1.089937, 0.455631, 3.764010>, <-1.057103, 0.561078, 3.640449>, 
      <-1.317694, 0.056194, 3.769370>, <-1.318124, 0.221913, 3.768147>, <-1.220353, 0.442031, 3.666537>, <-1.187519, 0.547478, 3.542976>, 
      <-1.458724, 0.057489, 3.646356>, <-1.462323, 0.237442, 3.650838>, <-1.360578, 0.446840, 3.492964>, <-1.307234, 0.531667, 3.343380>, 
      <-1.502783, 0.062509, 3.529495>, <-1.506382, 0.242463, 3.533977>, <-1.414185, 0.451144, 3.338685>, <-1.360842, 0.535971, 3.189102>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.681336, 0.654171, 3.010667>, <-0.784787, 0.645842, 3.053586>, <-0.932285, 0.647032, 3.211811>, <-1.026174, 0.626408, 3.153732>, 
      <-0.613836, 0.749291, 3.243237>, <-0.717287, 0.740962, 3.286156>, <-0.933676, 0.705752, 3.347238>, <-1.027565, 0.685128, 3.289160>, 
      <-0.547596, 0.749129, 3.633970>, <-0.722666, 0.728903, 3.570423>, <-0.878317, 0.670598, 3.642155>, <-1.027856, 0.655004, 3.530389>, 
      <-0.473537, 0.628499, 3.852274>, <-0.648607, 0.608273, 3.788726>, <-0.907564, 0.576672, 3.752215>, <-1.057103, 0.561078, 3.640449>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.835078, 0.119022, 2.606599>, <-0.898488, 0.116699, 2.605539>, <-0.988626, 0.104507, 2.628335>, <-1.046444, 0.111278, 2.603065>, 
      <-0.794120, 0.319586, 2.580276>, <-0.857530, 0.317263, 2.579216>, <-0.987765, 0.330767, 2.624326>, <-1.045583, 0.337538, 2.599056>, 
      <-0.734881, 0.578716, 2.826179>, <-0.838333, 0.570387, 2.869099>, <-0.930152, 0.557014, 3.004199>, <-1.024041, 0.536390, 2.946121>, 
      <-0.681336, 0.654171, 3.010667>, <-0.784787, 0.645842, 3.053586>, <-0.932285, 0.647032, 3.211811>, <-1.026174, 0.626408, 3.153732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.894321, -0.388773, 3.147549>, <-0.935036, -0.388773, 3.154801>, <-1.008168, -0.396700, 3.205914>, <-1.030039, -0.388773, 3.171722>, 
      <-0.921389, -0.296859, 2.945860>, <-0.962104, -0.296859, 2.953112>, <-1.006595, -0.293594, 3.003433>, <-1.028466, -0.285667, 2.969240>, 
      <-0.879391, -0.097968, 2.635078>, <-0.942801, -0.100291, 2.634018>, <-0.989491, -0.122683, 2.632361>, <-1.047309, -0.115912, 2.607091>, 
      <-0.835078, 0.119022, 2.606599>, <-0.898488, 0.116699, 2.605539>, <-0.988626, 0.104507, 2.628335>, <-1.046444, 0.111278, 2.603065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.665537, -0.456688, 3.869886>, <-0.782243, -0.445879, 3.803228>, <-0.962050, -0.442549, 3.743315>, <-1.054558, -0.420658, 3.647693>, 
      <-0.776491, -0.551780, 3.694581>, <-0.893198, -0.540971, 3.627923>, <-0.931303, -0.522195, 3.628223>, <-1.023811, -0.500304, 3.532601>, 
      <-0.866656, -0.482717, 3.353691>, <-0.907371, -0.482717, 3.360943>, <-1.009159, -0.461724, 3.333609>, <-1.031031, -0.453796, 3.299417>, 
      <-0.894321, -0.388773, 3.147549>, <-0.935036, -0.388773, 3.154801>, <-1.008168, -0.396700, 3.205914>, <-1.030039, -0.388773, 3.171722>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.335217, 0.090400, 4.030920>, <-0.595514, 0.080961, 3.967248>, <-0.956556, 0.064821, 3.924466>, <-1.202874, 0.058937, 3.818681>, 
      <-0.369659, -0.104267, 4.034080>, <-0.629956, -0.113706, 3.970408>, <-0.956143, -0.094272, 3.925639>, <-1.202462, -0.100156, 3.819855>, 
      <-0.569414, -0.374307, 4.021758>, <-0.686120, -0.363498, 3.955100>, <-0.996186, -0.354123, 3.871094>, <-1.088694, -0.332232, 3.775473>, 
      <-0.665537, -0.456688, 3.869886>, <-0.782243, -0.445879, 3.803228>, <-0.962050, -0.442549, 3.743315>, <-1.054558, -0.420658, 3.647693>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.335217, 0.090400, 4.030920>, <-0.304718, 0.262782, 4.028122>, <-0.423700, 0.547323, 3.999177>, <-0.473537, 0.628499, 3.852274>, 
      <-0.595514, 0.080961, 3.967248>, <-0.565015, 0.253344, 3.964451>, <-0.598770, 0.527097, 3.935630>, <-0.648607, 0.608273, 3.788726>, 
      <-0.956556, 0.064821, 3.924466>, <-0.956985, 0.230540, 3.923242>, <-0.940398, 0.471224, 3.875776>, <-0.907564, 0.576672, 3.752215>, 
      <-1.202874, 0.058937, 3.818681>, <-1.203304, 0.224656, 3.817458>, <-1.089937, 0.455631, 3.764010>, <-1.057103, 0.561078, 3.640449>
    }
  }
  texture {
    Shirt
  }
}
#declare sPatchObj6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.085033, -0.294445, -0.402756>, <2.186551, -0.116998, 0.049611>, <2.360495, 0.162020, 0.631597>, <2.423425, 0.297046, 1.105133>, 
      <2.058229, -0.255612, -0.408344>, <2.159746, -0.078164, 0.044023>, <2.319196, 0.222469, 0.631345>, <2.382126, 0.357495, 1.104882>, 
      <1.986667, -0.235078, -0.395331>, <2.064945, -0.049003, 0.064645>, <2.224334, 0.238303, 0.651371>, <2.271865, 0.386056, 1.129114>, 
      <1.941784, -0.230696, -0.380362>, <2.020062, -0.044621, 0.079614>, <2.155180, 0.241800, 0.675147>, <2.202711, 0.389553, 1.152890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.156878, -0.542320, -0.335523>, <2.270051, -0.408283, 0.111607>, <2.459074, -0.200541, 0.692265>, <2.534122, -0.095529, 1.154909>, 
      <2.157641, -0.468734, -0.366918>, <2.270814, -0.334696, 0.080212>, <2.460249, -0.081561, 0.660039>, <2.535297, 0.023451, 1.122683>, 
      <2.130166, -0.359833, -0.393347>, <2.231684, -0.182386, 0.059019>, <2.430035, 0.060235, 0.632020>, <2.492965, 0.195261, 1.105557>, 
      <2.085033, -0.294445, -0.402756>, <2.186551, -0.116998, 0.049611>, <2.360495, 0.162020, 0.631597>, <2.423425, 0.297046, 1.105133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.080327, -0.748471, -0.209053>, <2.181081, -0.655047, 0.244853>, <2.347549, -0.514277, 0.841109>, <2.416173, -0.437057, 1.303968>, 
      <2.125484, -0.698415, -0.244366>, <2.226238, -0.604991, 0.209540>, <2.417126, -0.430369, 0.797888>, <2.485750, -0.353149, 1.260747>, 
      <2.156152, -0.612316, -0.305660>, <2.269326, -0.478279, 0.141469>, <2.457956, -0.313716, 0.722919>, <2.533004, -0.208704, 1.185563>, 
      <2.156878, -0.542320, -0.335523>, <2.270051, -0.408283, 0.111607>, <2.459074, -0.200541, 0.692265>, <2.534122, -0.095529, 1.154909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.937474, -0.785525, -0.163946>, <2.015053, -0.700831, 0.294710>, <2.139333, -0.580346, 0.901886>, <2.196069, -0.503213, 1.364906>, 
      <1.981916, -0.791819, -0.175285>, <2.059495, -0.707125, 0.283371>, <2.207809, -0.587534, 0.883241>, <2.264545, -0.510401, 1.346261>, 
      <2.052857, -0.778921, -0.187571>, <2.153610, -0.685497, 0.266336>, <2.305224, -0.565320, 0.867402>, <2.373847, -0.488101, 1.330260>, 
      <2.080327, -0.748471, -0.209053>, <2.181081, -0.655047, 0.244853>, <2.347549, -0.514277, 0.841109>, <2.416173, -0.437057, 1.303968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.855598, -0.716646, -0.151715>, <1.919894, -0.621866, 0.313274>, <2.027299, -0.487626, 0.929247>, <2.069918, -0.400712, 1.398247>, 
      <1.876639, -0.740969, -0.148639>, <1.940935, -0.646189, 0.316350>, <2.059718, -0.525397, 0.928759>, <2.102337, -0.438483, 1.397759>, 
      <1.906460, -0.781133, -0.156033>, <1.984038, -0.696439, 0.302623>, <2.091548, -0.575330, 0.914897>, <2.148283, -0.498197, 1.377917>, 
      <1.937474, -0.785525, -0.163946>, <2.015053, -0.700831, 0.294710>, <2.139333, -0.580346, 0.901886>, <2.196069, -0.503213, 1.364906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.726429, -0.541562, -0.194804>, <1.769770, -0.416401, 0.274578>, <1.844496, -0.243645, 0.897641>, <1.870898, -0.124358, 1.369803>, 
      <1.731653, -0.603948, -0.172258>, <1.774994, -0.478787, 0.297124>, <1.852546, -0.343648, 0.918752>, <1.878948, -0.224361, 1.390914>, 
      <1.812262, -0.666551, -0.158051>, <1.876558, -0.571771, 0.306937>, <1.960529, -0.409833, 0.930252>, <2.003148, -0.322919, 1.399253>, 
      <1.855598, -0.716646, -0.151715>, <1.919894, -0.621866, 0.313274>, <2.027299, -0.487626, 0.929247>, <2.069918, -0.400712, 1.398247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.818058, -0.268381, -0.313716>, <1.876264, -0.092513, 0.154367>, <1.980265, 0.170444, 0.766269>, <2.012078, 0.317845, 1.246560>, 
      <1.770251, -0.337391, -0.272523>, <1.828457, -0.161523, 0.195559>, <1.906605, 0.056359, 0.814422>, <1.938418, 0.203761, 1.294713>, 
      <1.719087, -0.453887, -0.226489>, <1.762427, -0.328726, 0.242893>, <1.833183, -0.103104, 0.867973>, <1.859585, 0.016182, 1.340135>, 
      <1.726429, -0.541562, -0.194804>, <1.769770, -0.416401, 0.274578>, <1.844496, -0.243645, 0.897641>, <1.870898, -0.124358, 1.369803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.818058, -0.268381, -0.313716>, <1.840373, -0.236169, -0.332944>, <1.900553, -0.226671, -0.366611>, <1.941784, -0.230696, -0.380362>, 
      <1.876264, -0.092513, 0.154367>, <1.898579, -0.060301, 0.135139>, <1.978831, -0.040596, 0.093365>, <2.020062, -0.044621, 0.079614>, 
      <1.980265, 0.170444, 0.766269>, <2.014648, 0.223695, 0.743792>, <2.091653, 0.245012, 0.696988>, <2.155180, 0.241800, 0.675147>, 
      <2.012078, 0.317845, 1.246560>, <2.046461, 0.371097, 1.224083>, <2.139184, 0.392765, 1.174732>, <2.202711, 0.389553, 1.152890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.379210, 0.336761, 1.810881>, <2.336347, 0.398336, 1.809097>, <2.226100, 0.427639, 1.773941>, <2.154037, 0.429111, 1.753047>, 
      <2.430690, 0.331342, 1.604809>, <2.387827, 0.392917, 1.603025>, <2.265955, 0.417669, 1.597636>, <2.193892, 0.419141, 1.576743>, 
      <2.450360, 0.354839, 1.307814>, <2.409061, 0.415288, 1.307563>, <2.288994, 0.439304, 1.301283>, <2.219840, 0.442800, 1.325059>, 
      <2.423425, 0.297046, 1.105133>, <2.382126, 0.357495, 1.104882>, <2.271865, 0.386056, 1.129114>, <2.202711, 0.389553, 1.152890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.498000, -0.065002, 1.767363>, <2.500926, 0.059671, 1.787751>, <2.451384, 0.233081, 1.813885>, <2.379210, 0.336761, 1.810881>, 
      <2.541824, -0.060719, 1.588418>, <2.544750, 0.063954, 1.608806>, <2.502864, 0.227662, 1.607813>, <2.430690, 0.331342, 1.604809>, 
      <2.562916, -0.055239, 1.332414>, <2.564091, 0.063742, 1.300187>, <2.519900, 0.253054, 1.308238>, <2.450360, 0.354839, 1.307814>, 
      <2.534122, -0.095529, 1.154909>, <2.535297, 0.023451, 1.122683>, <2.492965, 0.195261, 1.105557>, <2.423425, 0.297046, 1.105133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.361153, -0.432469, 1.685085>, <2.432569, -0.343924, 1.723907>, <2.495216, -0.183593, 1.747969>, <2.498000, -0.065002, 1.767363>, 
      <2.393882, -0.425903, 1.574484>, <2.465298, -0.337358, 1.613306>, <2.539040, -0.179309, 1.569024>, <2.541824, -0.060719, 1.588418>, 
      <2.432890, -0.418246, 1.416722>, <2.502467, -0.334338, 1.373501>, <2.561798, -0.168413, 1.363068>, <2.562916, -0.055239, 1.332414>, 
      <2.416173, -0.437057, 1.303968>, <2.485750, -0.353149, 1.260747>, <2.533004, -0.208704, 1.185563>, <2.534122, -0.095529, 1.154909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.151013, -0.495217, 1.578739>, <2.220075, -0.502068, 1.601760>, <2.317709, -0.486333, 1.661469>, <2.361153, -0.432469, 1.685085>, 
      <2.167883, -0.491131, 1.515475>, <2.236945, -0.497981, 1.538495>, <2.350438, -0.479768, 1.550868>, <2.393882, -0.425903, 1.574484>, 
      <2.203941, -0.492511, 1.429149>, <2.272417, -0.499699, 1.410504>, <2.390564, -0.469290, 1.443015>, <2.432890, -0.418246, 1.416722>, 
      <2.196069, -0.503213, 1.364906>, <2.264545, -0.510401, 1.346261>, <2.373847, -0.488101, 1.330260>, <2.416173, -0.437057, 1.303968>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <2.011932, -0.397827, 1.568679>, <2.044625, -0.436748, 1.573150>, <2.102818, -0.490436, 1.562674>, <2.151013, -0.495217, 1.578739>, 
      <2.025929, -0.395884, 1.516545>, <2.058622, -0.434805, 1.521017>, <2.119688, -0.486350, 1.499410>, <2.167883, -0.491131, 1.515475>, 
      <2.074725, -0.390909, 1.451147>, <2.107144, -0.428680, 1.450659>, <2.156156, -0.487495, 1.442160>, <2.203941, -0.492511, 1.429149>, 
      <2.069918, -0.400712, 1.398247>, <2.102337, -0.438483, 1.397759>, <2.148283, -0.498197, 1.377917>, <2.196069, -0.503213, 1.364906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.823093, -0.104827, 1.533888>, <1.831635, -0.208280, 1.517477>, <1.944597, -0.317665, 1.559469>, <2.011932, -0.397827, 1.568679>, 
      <1.833548, -0.106903, 1.483395>, <1.842091, -0.210356, 1.466984>, <1.958594, -0.315722, 1.507336>, <2.025929, -0.395884, 1.516545>, 
      <1.873692, -0.111736, 1.419763>, <1.881741, -0.211739, 1.440874>, <2.007955, -0.313115, 1.452152>, <2.074725, -0.390909, 1.451147>, 
      <1.870898, -0.124358, 1.369803>, <1.878948, -0.224361, 1.390914>, <2.003148, -0.322919, 1.399253>, <2.069918, -0.400712, 1.398247>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.950552, 0.345516, 1.686599>, <1.877085, 0.226986, 1.637947>, <1.811088, 0.040561, 1.556952>, <1.823093, -0.104827, 1.533888>, 
      <1.979955, 0.334458, 1.556792>, <1.906488, 0.215928, 1.508140>, <1.821543, 0.038485, 1.506459>, <1.833548, -0.106903, 1.483395>, 
      <2.020518, 0.356951, 1.373981>, <1.946858, 0.242866, 1.422134>, <1.862379, 0.028804, 1.390095>, <1.873692, -0.111736, 1.419763>, 
      <2.012078, 0.317845, 1.246560>, <1.938418, 0.203761, 1.294713>, <1.859585, 0.016182, 1.340135>, <1.870898, -0.124358, 1.369803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.950552, 0.345516, 1.686599>, <1.979955, 0.334458, 1.556792>, <2.020518, 0.356951, 1.373981>, <2.012078, 0.317845, 1.246560>, 
      <1.984845, 0.400844, 1.709309>, <2.014248, 0.389786, 1.579501>, <2.054901, 0.410203, 1.351505>, <2.046461, 0.371097, 1.224083>, 
      <2.087836, 0.430463, 1.733853>, <2.127690, 0.420493, 1.557549>, <2.156313, 0.446013, 1.346901>, <2.139184, 0.392765, 1.174732>, 
      <2.154037, 0.429111, 1.753047>, <2.193892, 0.419141, 1.576743>, <2.219840, 0.442800, 1.325059>, <2.202711, 0.389553, 1.152890>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.865387, 0.355786, 3.338913>, <1.839153, 0.435166, 3.298260>, <1.792300, 0.486571, 3.170822>, <1.766552, 0.498665, 3.082319>, 
      <2.067978, 0.358727, 2.899730>, <2.041744, 0.438107, 2.859077>, <1.954687, 0.460603, 2.788813>, <1.928939, 0.472697, 2.700310>, 
      <2.262022, 0.349096, 2.279974>, <2.219159, 0.410671, 2.278190>, <2.134536, 0.450545, 2.178992>, <2.062473, 0.452017, 2.158098>, 
      <2.379210, 0.336761, 1.810881>, <2.336347, 0.398336, 1.809097>, <2.226100, 0.427639, 1.773941>, <2.154037, 0.429111, 1.753047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.980794, -0.149609, 3.414316>, <1.981093, 0.004908, 3.443006>, <1.909736, 0.221590, 3.407638>, <1.865387, 0.355786, 3.338913>, 
      <2.199972, -0.135584, 2.944630>, <2.200271, 0.018933, 2.973320>, <2.112327, 0.224531, 2.968455>, <2.067978, 0.358727, 2.899730>, 
      <2.374698, -0.077053, 2.270843>, <2.377625, 0.047620, 2.291231>, <2.334196, 0.245416, 2.282978>, <2.262022, 0.349096, 2.279974>, 
      <2.498000, -0.065002, 1.767363>, <2.500926, 0.059671, 1.787751>, <2.451384, 0.233081, 1.813885>, <2.379210, 0.336761, 1.810881>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.863640, -0.547900, 3.171122>, <1.908231, -0.450777, 3.268149>, <1.980520, -0.291528, 3.387966>, <1.980794, -0.149609, 3.414316>, 
      <2.054813, -0.543332, 2.740245>, <2.099404, -0.446209, 2.837271>, <2.199698, -0.277502, 2.918280>, <2.199972, -0.135584, 2.944630>, 
      <2.227603, -0.459260, 2.136384>, <2.299019, -0.370715, 2.175205>, <2.371914, -0.195644, 2.251449>, <2.374698, -0.077053, 2.270843>, 
      <2.361153, -0.432469, 1.685085>, <2.432569, -0.343924, 1.723907>, <2.495216, -0.183593, 1.747969>, <2.498000, -0.065002, 1.767363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.771197, -0.606133, 2.958246>, <1.792920, -0.620560, 3.025125>, <1.841465, -0.596199, 3.122871>, <1.863640, -0.547900, 3.171122>, 
      <1.933202, -0.592866, 2.559570>, <1.954925, -0.607293, 2.626449>, <2.032639, -0.591632, 2.691993>, <2.054813, -0.543332, 2.740245>, 
      <2.040299, -0.522036, 1.993935>, <2.109361, -0.528887, 2.016955>, <2.184160, -0.513125, 2.112767>, <2.227603, -0.459260, 2.136384>, 
      <2.151013, -0.495217, 1.578739>, <2.220075, -0.502068, 1.601760>, <2.317709, -0.486333, 1.661469>, <2.361153, -0.432469, 1.685085>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.715983, -0.449832, 2.716523>, <1.733502, -0.516425, 2.771206>, <1.744588, -0.588460, 2.876323>, <1.771197, -0.606133, 2.958246>, 
      <1.862906, -0.426086, 2.393173>, <1.880425, -0.492679, 2.447856>, <1.906593, -0.575193, 2.477647>, <1.933202, -0.592866, 2.559570>, 
      <1.919692, -0.410628, 1.912239>, <1.952385, -0.449549, 1.916710>, <1.992104, -0.517255, 1.977870>, <2.040299, -0.522036, 1.993935>, 
      <2.011932, -0.397827, 1.568679>, <2.044625, -0.436748, 1.573150>, <2.102818, -0.490436, 1.562674>, <2.151013, -0.495217, 1.578739>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.631973, -0.076909, 2.523672>, <1.636950, -0.205252, 2.525120>, <1.690392, -0.352554, 2.636642>, <1.715983, -0.449832, 2.716523>, 
      <1.727357, -0.058756, 2.237140>, <1.732334, -0.187100, 2.238588>, <1.837315, -0.328807, 2.313293>, <1.862906, -0.426086, 2.393173>, 
      <1.761800, -0.092655, 1.829900>, <1.770342, -0.196107, 1.813489>, <1.852357, -0.330466, 1.903029>, <1.919692, -0.410628, 1.912239>, 
      <1.823093, -0.104827, 1.533888>, <1.831635, -0.208280, 1.517477>, <1.944597, -0.317665, 1.559469>, <2.011932, -0.397827, 1.568679>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.681390, 0.442212, 2.706463>, <1.653960, 0.324896, 2.592598>, <1.625550, 0.088729, 2.521804>, <1.631973, -0.076909, 2.523672>, 
      <1.812989, 0.442119, 2.417232>, <1.785558, 0.324803, 2.303367>, <1.720933, 0.106882, 2.235272>, <1.727357, -0.058756, 2.237140>, 
      <1.880594, 0.371826, 1.995446>, <1.807127, 0.253296, 1.946795>, <1.749794, 0.052734, 1.852963>, <1.761800, -0.092655, 1.829900>, 
      <1.950552, 0.345516, 1.686599>, <1.877085, 0.226986, 1.637947>, <1.811088, 0.040561, 1.556952>, <1.823093, -0.104827, 1.533888>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.681390, 0.442212, 2.706463>, <1.812989, 0.442119, 2.417232>, <1.880594, 0.371826, 1.995446>, <1.950552, 0.345516, 1.686599>, 
      <1.700725, 0.524905, 2.786724>, <1.832324, 0.524811, 2.497493>, <1.914887, 0.427154, 2.018156>, <1.984845, 0.400844, 1.709309>, 
      <1.734188, 0.513867, 2.971076>, <1.896576, 0.487899, 2.589066>, <1.996271, 0.453369, 2.138904>, <2.087836, 0.430463, 1.733853>, 
      <1.766552, 0.498665, 3.082319>, <1.928939, 0.472697, 2.700310>, <2.062473, 0.452017, 2.158098>, <2.154037, 0.429111, 1.753047>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.504075, 0.533048, 3.282055>, <1.487697, 0.537206, 3.113123>, <1.475059, 0.470452, 2.864326>, <1.467038, 0.345859, 2.749280>, 
      <1.588937, 0.517831, 3.232414>, <1.572560, 0.521989, 3.063482>, <1.542223, 0.492027, 2.876949>, <1.534202, 0.367434, 2.761903>, 
      <1.727708, 0.504877, 3.173697>, <1.695345, 0.520078, 3.062454>, <1.671046, 0.524926, 2.851953>, <1.651711, 0.442233, 2.771693>, 
      <1.766552, 0.498665, 3.082319>, <1.734188, 0.513867, 2.971076>, <1.700725, 0.524905, 2.786724>, <1.681390, 0.442212, 2.706463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.550276, 0.324728, 3.607867>, <1.537896, 0.421543, 3.543638>, <1.515346, 0.530187, 3.398315>, <1.504075, 0.533048, 3.282055>, 
      <1.649977, 0.331157, 3.533356>, <1.637597, 0.427972, 3.469127>, <1.600209, 0.514970, 3.348674>, <1.588937, 0.517831, 3.232414>, 
      <1.813182, 0.355028, 3.452084>, <1.786948, 0.434409, 3.411431>, <1.753456, 0.492782, 3.262200>, <1.727708, 0.504877, 3.173697>, 
      <1.865387, 0.355786, 3.338913>, <1.839153, 0.435166, 3.298260>, <1.792300, 0.486571, 3.170822>, <1.766552, 0.498665, 3.082319>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.587997, -0.123233, 3.717443>, <1.589432, 0.014895, 3.731135>, <1.564984, 0.209707, 3.684174>, <1.550276, 0.324728, 3.607867>, 
      <1.714393, -0.121504, 3.638453>, <1.715828, 0.016624, 3.652145>, <1.664686, 0.216136, 3.609662>, <1.649977, 0.331157, 3.533356>, 
      <1.917784, -0.153641, 3.549342>, <1.918083, 0.000876, 3.578031>, <1.857531, 0.220832, 3.520809>, <1.813182, 0.355028, 3.452084>, 
      <1.980794, -0.149609, 3.414316>, <1.981093, 0.004908, 3.443006>, <1.909736, 0.221590, 3.407638>, <1.865387, 0.355786, 3.338913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.458544, -0.174205, 2.628992>, <1.514161, -0.135982, 2.627241>, <1.610689, -0.080960, 2.587609>, <1.631973, -0.076909, 2.523672>, 
      <1.460175, -0.014215, 2.621830>, <1.515792, 0.024008, 2.620078>, <1.604266, 0.084679, 2.585741>, <1.625550, 0.088729, 2.521804>, 
      <1.459471, 0.228323, 2.640750>, <1.526635, 0.249898, 2.653373>, <1.624281, 0.324918, 2.657827>, <1.653960, 0.324896, 2.592598>, 
      <1.467038, 0.345859, 2.749280>, <1.534202, 0.367434, 2.761903>, <1.651711, 0.442233, 2.771693>, <1.681390, 0.442212, 2.706463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.458544, -0.487267, 2.786578>, <1.536232, -0.470254, 2.800987>, <1.682622, -0.455224, 2.789943>, <1.715983, -0.449832, 2.716523>, 
      <1.451644, -0.428005, 2.699998>, <1.529332, -0.410992, 2.714407>, <1.657031, -0.357946, 2.710063>, <1.690392, -0.352554, 2.636642>, 
      <1.457473, -0.279240, 2.633694>, <1.513090, -0.241018, 2.631943>, <1.615666, -0.209303, 2.589056>, <1.636950, -0.205252, 2.525120>, 
      <1.458544, -0.174205, 2.628992>, <1.514161, -0.135982, 2.627241>, <1.610689, -0.080960, 2.587609>, <1.631973, -0.076909, 2.523672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.502109, -0.548357, 3.175619>, <1.591346, -0.540307, 3.120467>, <1.731607, -0.609375, 3.055672>, <1.771197, -0.606133, 2.958246>, 
      <1.488846, -0.553942, 3.057630>, <1.578083, -0.545891, 3.002478>, <1.704998, -0.591702, 2.973749>, <1.744588, -0.588460, 2.876323>, 
      <1.466344, -0.554260, 2.884453>, <1.544033, -0.537247, 2.898863>, <1.700141, -0.521817, 2.844626>, <1.733502, -0.516425, 2.771206>, 
      <1.458544, -0.487267, 2.786578>, <1.536232, -0.470254, 2.800987>, <1.682622, -0.455224, 2.789943>, <1.715983, -0.449832, 2.716523>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.542208, -0.452037, 3.530868>, <1.653228, -0.453233, 3.433676>, <1.803800, -0.549330, 3.305994>, <1.863640, -0.547900, 3.171122>, 
      <1.528462, -0.520076, 3.444152>, <1.639482, -0.521272, 3.346960>, <1.781625, -0.597629, 3.257742>, <1.841465, -0.596199, 3.122871>, 
      <1.514503, -0.543138, 3.285878>, <1.603740, -0.535088, 3.230726>, <1.753330, -0.623802, 3.122551>, <1.792920, -0.620560, 3.025125>, 
      <1.502109, -0.548357, 3.175619>, <1.591346, -0.540307, 3.120467>, <1.731607, -0.609375, 3.055672>, <1.771197, -0.606133, 2.958246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.542208, -0.452037, 3.530868>, <1.556346, -0.382058, 3.620057>, <1.586816, -0.236914, 3.706174>, <1.587997, -0.123233, 3.717443>, 
      <1.653228, -0.453233, 3.433676>, <1.667366, -0.383254, 3.522865>, <1.713212, -0.235185, 3.627184>, <1.714393, -0.121504, 3.638453>, 
      <1.803800, -0.549330, 3.305994>, <1.848390, -0.452207, 3.403020>, <1.917510, -0.295560, 3.522991>, <1.917784, -0.153641, 3.549342>, 
      <1.863640, -0.547900, 3.171122>, <1.908231, -0.450777, 3.268149>, <1.980520, -0.291528, 3.387966>, <1.980794, -0.149609, 3.414316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.172279, -0.160670, 3.919591>, <1.299888, -0.193636, 3.875016>, <1.470018, -0.124847, 3.791173>, <1.587997, -0.123233, 3.717443>, 
      <1.155844, -0.279245, 3.921191>, <1.283453, -0.312210, 3.876616>, <1.468837, -0.238528, 3.779904>, <1.586816, -0.236914, 3.706174>, 
      <1.207420, -0.440883, 3.826608>, <1.326120, -0.414441, 3.746196>, <1.446656, -0.380876, 3.716086>, <1.556346, -0.382058, 3.620057>, 
      <1.146541, -0.540175, 3.798906>, <1.265241, -0.513734, 3.718495>, <1.432518, -0.450855, 3.626897>, <1.542208, -0.452037, 3.530868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.215397, -0.656274, 3.301750>, <1.201009, -0.654898, 3.455619>, <1.230982, -0.618274, 3.695684>, <1.146541, -0.540175, 3.798906>, 
      <1.301729, -0.610407, 3.283822>, <1.287341, -0.609031, 3.437692>, <1.349682, -0.591833, 3.615272>, <1.265241, -0.513734, 3.718495>, 
      <1.417811, -0.555962, 3.227718>, <1.430205, -0.550743, 3.337977>, <1.418772, -0.518894, 3.540181>, <1.432518, -0.450855, 3.626897>, 
      <1.502109, -0.548357, 3.175619>, <1.514503, -0.543138, 3.285878>, <1.528462, -0.520076, 3.444152>, <1.542208, -0.452037, 3.530868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.357936, 0.571934, 3.321342>, <1.359257, 0.570715, 3.098034>, <1.262048, 0.469627, 2.786191>, <1.272216, 0.310773, 2.629564>, 
      <1.402262, 0.556887, 3.318916>, <1.403583, 0.555667, 3.095608>, <1.319810, 0.431161, 2.785446>, <1.329978, 0.272307, 2.628819>, 
      <1.464092, 0.540217, 3.305444>, <1.447714, 0.544375, 3.136512>, <1.410015, 0.449558, 2.852102>, <1.401994, 0.324965, 2.737056>, 
      <1.504075, 0.533048, 3.282055>, <1.487697, 0.537206, 3.113123>, <1.475059, 0.470452, 2.864326>, <1.467038, 0.345859, 2.749280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.409266, -0.229965, 2.530684>, <1.414894, -0.228179, 2.567199>, <1.428070, -0.195148, 2.629951>, <1.458544, -0.174205, 2.628992>, 
      <1.412517, -0.060037, 2.530370>, <1.418145, -0.058251, 2.566884>, <1.429701, -0.035158, 2.622789>, <1.460175, -0.014215, 2.621830>, 
      <1.279955, 0.189874, 2.510360>, <1.337717, 0.151408, 2.509615>, <1.394428, 0.207429, 2.628526>, <1.459471, 0.228323, 2.640750>, 
      <1.272216, 0.310773, 2.629564>, <1.329978, 0.272307, 2.628819>, <1.401994, 0.324965, 2.737056>, <1.467038, 0.345859, 2.749280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.265366, 0.317094, 3.787338>, <1.384536, 0.344567, 3.681491>, <1.356979, 0.572817, 3.483077>, <1.357936, 0.571934, 3.321342>, 
      <1.350839, 0.319384, 3.733497>, <1.470009, 0.346857, 3.627650>, <1.401305, 0.557770, 3.480651>, <1.402262, 0.556887, 3.318916>, 
      <1.469446, 0.319516, 3.668275>, <1.457066, 0.416330, 3.604046>, <1.475363, 0.537356, 3.421704>, <1.464092, 0.540217, 3.305444>, 
      <1.550276, 0.324728, 3.607867>, <1.537896, 0.421543, 3.543638>, <1.515346, 0.530187, 3.398315>, <1.504075, 0.533048, 3.282055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.265366, 0.317094, 3.787338>, <1.350839, 0.319384, 3.733497>, <1.469446, 0.319516, 3.668275>, <1.550276, 0.324728, 3.607867>, 
      <1.333448, 0.184130, 3.811478>, <1.418921, 0.186420, 3.757637>, <1.484155, 0.204495, 3.744582>, <1.564984, 0.209707, 3.684174>, 
      <1.193053, -0.010798, 3.917568>, <1.320662, -0.043763, 3.872994>, <1.471453, 0.013281, 3.804865>, <1.589432, 0.014895, 3.731135>, 
      <1.172279, -0.160670, 3.919591>, <1.299888, -0.193636, 3.875016>, <1.470018, -0.124847, 3.791173>, <1.587997, -0.123233, 3.717443>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.255734, -0.550620, 2.631157>, <1.316577, -0.531614, 2.677783>, <1.382633, -0.503891, 2.772498>, <1.458544, -0.487267, 2.786578>, 
      <1.322833, -0.466018, 2.606177>, <1.383676, -0.447012, 2.652803>, <1.375732, -0.444629, 2.685918>, <1.451644, -0.428005, 2.699998>, 
      <1.407146, -0.340777, 2.530889>, <1.412774, -0.338991, 2.567403>, <1.426999, -0.300183, 2.634654>, <1.457473, -0.279240, 2.633694>, 
      <1.409266, -0.229965, 2.530684>, <1.414894, -0.228179, 2.567199>, <1.428070, -0.195148, 2.629951>, <1.458544, -0.174205, 2.628992>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.255734, -0.550620, 2.631157>, <1.254467, -0.593335, 2.830650>, <1.234391, -0.658091, 3.098625>, <1.215397, -0.656274, 3.301750>, 
      <1.316577, -0.531614, 2.677783>, <1.315310, -0.574329, 2.877276>, <1.320722, -0.612224, 3.080698>, <1.301729, -0.610407, 3.283822>, 
      <1.382633, -0.503891, 2.772498>, <1.390433, -0.570883, 2.870373>, <1.404548, -0.561547, 3.109729>, <1.417811, -0.555962, 3.227718>, 
      <1.458544, -0.487267, 2.786578>, <1.466344, -0.554260, 2.884453>, <1.488846, -0.553942, 3.057630>, <1.502109, -0.548357, 3.175619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.103231, 0.543814, 4.297817>, <0.054577, 0.541219, 4.290643>, <-0.025156, 0.559348, 4.297817>, <-0.059769, 0.524314, 4.297817>, 
      <0.101298, 0.556887, 4.297675>, <0.052644, 0.554292, 4.290501>, <-0.032060, 0.571826, 4.297675>, <-0.066673, 0.536792, 4.297675>, 
      <0.097421, 0.581863, 4.309330>, <0.043821, 0.579004, 4.301426>, <-0.042143, 0.599972, 4.310630>, <-0.080274, 0.561377, 4.310630>, 
      <0.096788, 0.587390, 4.297342>, <0.043188, 0.584531, 4.289439>, <-0.044650, 0.604503, 4.297342>, <-0.082781, 0.565908, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.320600, 0.544604, 4.353901>, <0.263702, 0.580634, 4.353901>, <0.169765, 0.547363, 4.307627>, <0.103231, 0.543814, 4.297817>, 
      <0.325295, 0.557701, 4.355469>, <0.268397, 0.593731, 4.355469>, <0.167832, 0.560436, 4.307485>, <0.101298, 0.556887, 4.297675>, 
      <0.335026, 0.587734, 4.373064>, <0.272344, 0.627426, 4.373064>, <0.170718, 0.585773, 4.320137>, <0.097421, 0.581863, 4.309330>, 
      <0.336251, 0.588260, 4.359127>, <0.273569, 0.627952, 4.359127>, <0.170085, 0.591300, 4.308149>, <0.096788, 0.587390, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.531328, 0.272727, 4.297817>, <0.495866, 0.370354, 4.309802>, <0.408936, 0.488667, 4.353901>, <0.320600, 0.544604, 4.353901>, 
      <0.542449, 0.277533, 4.297675>, <0.506987, 0.375160, 4.309660>, <0.413631, 0.501763, 4.355469>, <0.325295, 0.557701, 4.355469>, 
      <0.571967, 0.287240, 4.308822>, <0.532900, 0.394790, 4.322025>, <0.432341, 0.526110, 4.373064>, <0.335026, 0.587734, 4.373064>, 
      <0.568399, 0.288748, 4.297342>, <0.529332, 0.396298, 4.310545>, <0.433566, 0.526637, 4.359127>, <0.336251, 0.588260, 4.359127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.486546, 0.087758, 4.297817>, <0.493983, 0.144366, 4.297817>, <0.550692, 0.219417, 4.291273>, <0.531328, 0.272727, 4.297817>, 
      <0.496302, 0.086924, 4.297675>, <0.503738, 0.143532, 4.297675>, <0.561814, 0.224224, 4.291130>, <0.542449, 0.277533, 4.297675>, 
      <0.516543, 0.085194, 4.306801>, <0.524736, 0.147555, 4.306801>, <0.593300, 0.228512, 4.301612>, <0.571967, 0.287240, 4.308822>, 
      <0.519065, 0.084978, 4.297342>, <0.527258, 0.147339, 4.297342>, <0.589732, 0.230020, 4.290132>, <0.568399, 0.288748, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.485905, -0.073035, 4.297817>, <0.497203, -0.026138, 4.297817>, <0.480263, 0.039931, 4.297817>, <0.486546, 0.087758, 4.297817>, 
      <0.495641, -0.078772, 4.297675>, <0.506939, -0.031876, 4.297675>, <0.490019, 0.039097, 4.297675>, <0.496302, 0.086924, 4.297675>, 
      <0.515486, -0.090466, 4.308140>, <0.527932, -0.038803, 4.308140>, <0.509621, 0.032505, 4.306801>, <0.516543, 0.085194, 4.306801>, 
      <0.518359, -0.092159, 4.297342>, <0.530805, -0.040496, 4.297342>, <0.512143, 0.032289, 4.297342>, <0.519065, 0.084978, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.405731, -0.247693, 4.297817>, <0.452106, -0.213439, 4.297817>, <0.472402, -0.129085, 4.297817>, <0.485905, -0.073035, 4.297817>, 
      <0.413023, -0.258756, 4.297675>, <0.459398, -0.224502, 4.297675>, <0.482138, -0.134823, 4.297675>, <0.495641, -0.078772, 4.297675>, 
      <0.427554, -0.280803, 4.309801>, <0.478643, -0.243068, 4.309801>, <0.500610, -0.152214, 4.308140>, <0.515486, -0.090466, 4.308140>, 
      <0.430036, -0.284570, 4.297342>, <0.481125, -0.246835, 4.297342>, <0.503483, -0.153907, 4.297342>, <0.518359, -0.092159, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.209219, -0.277400, 4.297817>, <0.268841, -0.277753, 4.297817>, <0.357772, -0.283117, 4.297817>, <0.405731, -0.247693, 4.297817>, 
      <0.210518, -0.289369, 4.297675>, <0.270140, -0.289722, 4.297675>, <0.365063, -0.294180, 4.297675>, <0.413023, -0.258756, 4.297675>, 
      <0.213143, -0.313556, 4.308779>, <0.278826, -0.313945, 4.308779>, <0.374719, -0.319828, 4.309801>, <0.427554, -0.280803, 4.309801>, 
      <0.213549, -0.317297, 4.297342>, <0.279232, -0.317685, 4.297342>, <0.377202, -0.323595, 4.297342>, <0.430036, -0.284570, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.000987, -0.245288, 4.297817>, <0.055024, -0.275822, 4.297817>, <0.145427, -0.277023, 4.297817>, <0.209219, -0.277400, 4.297817>, 
      <-0.006098, -0.256278, 4.297675>, <0.049913, -0.286812, 4.297675>, <0.146726, -0.288992, 4.297675>, <0.210518, -0.289369, 4.297675>, 
      <-0.016417, -0.278465, 4.308848>, <0.045288, -0.312103, 4.308848>, <0.142866, -0.313141, 4.308779>, <0.213143, -0.313556, 4.308779>, 
      <-0.018024, -0.281921, 4.297342>, <0.043681, -0.315559, 4.297342>, <0.143272, -0.316881, 4.297342>, <0.213549, -0.317297, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.123679, -0.095923, 4.297817>, <-0.095883, -0.146816, 4.297817>, <-0.051902, -0.217532, 4.297817>, <-0.000987, -0.245288, 4.297817>, 
      <-0.132531, -0.102358, 4.297675>, <-0.104735, -0.153251, 4.297675>, <-0.057013, -0.228522, 4.297675>, <-0.006098, -0.256278, 4.297675>, 
      <-0.150650, -0.115530, 4.307828>, <-0.120029, -0.171596, 4.307828>, <-0.072507, -0.247889, 4.308848>, <-0.016417, -0.278465, 4.308848>, 
      <-0.153187, -0.117374, 4.297342>, <-0.122566, -0.173440, 4.297342>, <-0.074114, -0.251344, 4.297342>, <-0.018024, -0.281921, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.182290, 0.086664, 4.297817>, <-0.173879, 0.029753, 4.297817>, <-0.151255, -0.045434, 4.297817>, <-0.123679, -0.095923, 4.297817>, 
      <-0.192930, 0.085797, 4.297675>, <-0.184519, 0.028886, 4.297675>, <-0.160107, -0.051869, 4.297675>, <-0.132531, -0.102358, 4.297675>, 
      <-0.214775, 0.084016, 4.307590>, <-0.205510, 0.021320, 4.307590>, <-0.181029, -0.059908, 4.307828>, <-0.150650, -0.115530, 4.307828>, 
      <-0.217755, 0.083773, 4.297342>, <-0.208489, 0.021077, 4.297342>, <-0.183566, -0.061753, 4.297342>, <-0.153187, -0.117374, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.176396, 0.260783, 4.297817>, <-0.190486, 0.210452, 4.297817>, <-0.189931, 0.138368, 4.297817>, <-0.182290, 0.086664, 4.297817>, 
      <-0.186856, 0.265225, 4.297675>, <-0.200946, 0.214895, 4.297675>, <-0.200571, 0.137501, 4.297675>, <-0.192930, 0.085797, 4.297675>, 
      <-0.208160, 0.274272, 4.308196>, <-0.223682, 0.218826, 4.308196>, <-0.223193, 0.140975, 4.307590>, <-0.214775, 0.084016, 4.307590>, 
      <-0.211262, 0.275590, 4.297342>, <-0.226784, 0.220144, 4.297342>, <-0.226173, 0.140732, 4.297342>, <-0.217755, 0.083773, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.176396, 0.260783, 4.297817>, <-0.186856, 0.265225, 4.297675>, <-0.208160, 0.274272, 4.308196>, <-0.211262, 0.275590, 4.297342>, 
      <-0.153089, 0.344038, 4.297817>, <-0.163549, 0.348480, 4.297675>, <-0.182483, 0.365990, 4.308196>, <-0.185586, 0.367307, 4.297342>, 
      <-0.120531, 0.462812, 4.297817>, <-0.127435, 0.475290, 4.297675>, <-0.147213, 0.493624, 4.310630>, <-0.149720, 0.498155, 4.297342>, 
      <-0.059769, 0.524314, 4.297817>, <-0.066673, 0.536792, 4.297675>, <-0.080274, 0.561377, 4.310630>, <-0.082781, 0.565908, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.096788, 0.600051, 4.175835>, <0.098269, 0.586637, 4.209910>, <0.095032, 0.602717, 4.264098>, <0.096788, 0.587390, 4.297342>, 
      <0.041985, 0.601958, 4.175835>, <0.043467, 0.588544, 4.209910>, <0.041432, 0.599858, 4.256194>, <0.043188, 0.584531, 4.289439>, 
      <-0.045025, 0.605676, 4.175835>, <-0.038780, 0.593909, 4.209766>, <-0.051057, 0.616085, 4.263378>, <-0.044650, 0.604503, 4.297342>, 
      <-0.082781, 0.565908, 4.175835>, <-0.076536, 0.554141, 4.209766>, <-0.089188, 0.577489, 4.263378>, <-0.082781, 0.565908, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.336251, 0.551327, 4.175835>, <0.330154, 0.542671, 4.230919>, <0.341159, 0.590368, 4.303290>, <0.336251, 0.588260, 4.359127>, 
      <0.278582, 0.596590, 4.175835>, <0.272485, 0.587934, 4.230919>, <0.278477, 0.630061, 4.303290>, <0.273569, 0.627952, 4.359127>, 
      <0.170055, 0.597502, 4.175835>, <0.171536, 0.584088, 4.209910>, <0.168329, 0.606626, 4.274905>, <0.170085, 0.591300, 4.308149>, 
      <0.096788, 0.600051, 4.175835>, <0.098269, 0.586637, 4.209910>, <0.095032, 0.602717, 4.264098>, <0.096788, 0.587390, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.493416, 0.288748, 4.175835>, <0.501593, 0.273526, 4.215030>, <0.555785, 0.294079, 4.256756>, <0.568399, 0.288748, 4.297342>, 
      <0.459910, 0.374221, 4.175835>, <0.468086, 0.358999, 4.215030>, <0.516718, 0.401629, 4.269959>, <0.529332, 0.396298, 4.310545>, 
      <0.408469, 0.494645, 4.175835>, <0.402372, 0.485989, 4.230919>, <0.438474, 0.528745, 4.303290>, <0.433566, 0.526637, 4.359127>, 
      <0.336251, 0.551327, 4.175835>, <0.330154, 0.542671, 4.230919>, <0.341159, 0.590368, 4.303290>, <0.336251, 0.588260, 4.359127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.519065, 0.084978, 4.175835>, <0.508420, 0.077734, 4.209937>, <0.528452, 0.084176, 4.262128>, <0.519065, 0.084978, 4.297342>, 
      <0.515039, 0.146460, 4.175835>, <0.504394, 0.139215, 4.209937>, <0.536645, 0.146537, 4.262128>, <0.527258, 0.147339, 4.297342>, 
      <0.515903, 0.231385, 4.175835>, <0.524080, 0.216163, 4.215030>, <0.577117, 0.235350, 4.249546>, <0.589732, 0.230020, 4.290132>, 
      <0.493416, 0.288748, 4.175835>, <0.501593, 0.273526, 4.215030>, <0.555785, 0.294079, 4.256756>, <0.568399, 0.288748, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.518359, -0.092159, 4.175835>, <0.507534, -0.094226, 4.210581>, <0.527625, -0.097619, 4.262513>, <0.518359, -0.092159, 4.297342>, 
      <0.530805, -0.040496, 4.175835>, <0.519980, -0.042562, 4.210581>, <0.540072, -0.045956, 4.262513>, <0.530805, -0.040496, 4.297342>, 
      <0.522537, 0.031950, 4.175835>, <0.511892, 0.024706, 4.209937>, <0.521531, 0.031487, 4.262128>, <0.512143, 0.032289, 4.297342>, 
      <0.519065, 0.084978, 4.175835>, <0.508420, 0.077734, 4.209937>, <0.528452, 0.084176, 4.262128>, <0.519065, 0.084978, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.430036, -0.284570, 4.175835>, <0.421732, -0.280806, 4.211129>, <0.436865, -0.294932, 4.263067>, <0.430036, -0.284570, 4.297342>, 
      <0.481125, -0.246835, 4.175835>, <0.472821, -0.243070, 4.211129>, <0.487955, -0.257196, 4.263067>, <0.481125, -0.246835, 4.297342>, 
      <0.503483, -0.153907, 4.175835>, <0.492658, -0.155973, 4.210581>, <0.512750, -0.159367, 4.262513>, <0.503483, -0.153907, 4.297342>, 
      <0.518359, -0.092159, 4.175835>, <0.507534, -0.094226, 4.210581>, <0.527625, -0.097619, 4.262513>, <0.518359, -0.092159, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.213549, -0.317297, 4.175835>, <0.211804, -0.312429, 4.211918>, <0.214778, -0.328622, 4.262716>, <0.213549, -0.317297, 4.297342>, 
      <0.279232, -0.317685, 4.175835>, <0.277487, -0.312817, 4.211918>, <0.280461, -0.329011, 4.262716>, <0.279232, -0.317685, 4.297342>, 
      <0.377202, -0.323595, 4.175835>, <0.368898, -0.319830, 4.211129>, <0.384031, -0.333956, 4.263067>, <0.377202, -0.323595, 4.297342>, 
      <0.430036, -0.284570, 4.175835>, <0.421732, -0.280806, 4.211129>, <0.436865, -0.294932, 4.263067>, <0.430036, -0.284570, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.018024, -0.281921, 4.175835>, <-0.012589, -0.278179, 4.211685>, <-0.022857, -0.292313, 4.262738>, <-0.018024, -0.281921, 4.297342>, 
      <0.043681, -0.315559, 4.175835>, <0.049116, -0.311817, 4.211685>, <0.038848, -0.325951, 4.262738>, <0.043681, -0.315559, 4.297342>, 
      <0.143272, -0.316881, 4.175835>, <0.141528, -0.312013, 4.211918>, <0.144502, -0.328207, 4.262716>, <0.143272, -0.316881, 4.297342>, 
      <0.213549, -0.317297, 4.175835>, <0.211804, -0.312429, 4.211918>, <0.214778, -0.328622, 4.262716>, <0.213549, -0.317297, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.153187, -0.117374, 4.175835>, <-0.143747, -0.118701, 4.211018>, <-0.161635, -0.123516, 4.262418>, <-0.153187, -0.117374, 4.297342>, 
      <-0.122566, -0.173440, 4.175835>, <-0.113125, -0.174766, 4.211018>, <-0.131014, -0.179581, 4.262418>, <-0.122566, -0.173440, 4.297342>, 
      <-0.074114, -0.251344, 4.175835>, <-0.068679, -0.247602, 4.211685>, <-0.078947, -0.261736, 4.262738>, <-0.074114, -0.251344, 4.297342>, 
      <-0.018024, -0.281921, 4.175835>, <-0.012589, -0.278179, 4.211685>, <-0.022857, -0.292313, 4.262738>, <-0.018024, -0.281921, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.217755, 0.083773, 4.175835>, <-0.206738, 0.076587, 4.209831>, <-0.227929, 0.082944, 4.262348>, <-0.217755, 0.083773, 4.297342>, 
      <-0.208489, 0.021077, 4.175835>, <-0.197473, 0.013891, 4.209831>, <-0.218663, 0.020248, 4.262348>, <-0.208489, 0.021077, 4.297342>, 
      <-0.183566, -0.061753, 4.175835>, <-0.174126, -0.063079, 4.211018>, <-0.192014, -0.067894, 4.262418>, <-0.183566, -0.061753, 4.297342>, 
      <-0.153187, -0.117374, 4.175835>, <-0.143747, -0.118701, 4.211018>, <-0.161635, -0.123516, 4.262418>, <-0.153187, -0.117374, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.211262, 0.275590, 4.175835>, <-0.200852, 0.263266, 4.208523>, <-0.221212, 0.279816, 4.262530>, <-0.211262, 0.275590, 4.297342>, 
      <-0.226784, 0.220144, 4.175835>, <-0.216375, 0.207820, 4.208523>, <-0.236735, 0.224369, 4.262530>, <-0.226784, 0.220144, 4.297342>, 
      <-0.226173, 0.140732, 4.175835>, <-0.215156, 0.133546, 4.209831>, <-0.236347, 0.139903, 4.262348>, <-0.226173, 0.140732, 4.297342>, 
      <-0.217755, 0.083773, 4.175835>, <-0.206738, 0.076587, 4.209831>, <-0.227929, 0.082944, 4.262348>, <-0.217755, 0.083773, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.211262, 0.275590, 4.175835>, <-0.185586, 0.367307, 4.175835>, <-0.148359, 0.496837, 4.175835>, <-0.082781, 0.565908, 4.175835>, 
      <-0.200852, 0.263266, 4.208523>, <-0.175176, 0.354983, 4.208523>, <-0.142113, 0.485070, 4.209766>, <-0.076536, 0.554141, 4.209766>, 
      <-0.221212, 0.279816, 4.262530>, <-0.195536, 0.371533, 4.262530>, <-0.156127, 0.509736, 4.263378>, <-0.089188, 0.577489, 4.263378>, 
      <-0.211262, 0.275590, 4.297342>, <-0.185586, 0.367307, 4.297342>, <-0.149720, 0.498155, 4.297342>, <-0.082781, 0.565908, 4.297342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.084627, 0.697510, 4.017611>, <0.089098, 0.664779, 4.062666>, <0.094530, 0.620499, 4.123892>, <0.096788, 0.600051, 4.175835>, 
      <0.018625, 0.699807, 4.017611>, <0.023096, 0.667076, 4.062666>, <0.039727, 0.622406, 4.123892>, <0.041985, 0.601958, 4.175835>, 
      <-0.082136, 0.700642, 4.029694>, <-0.057883, 0.677150, 4.069276>, <-0.053939, 0.622470, 4.127406>, <-0.045025, 0.605676, 4.175835>, 
      <-0.130881, 0.656534, 4.036015>, <-0.106628, 0.633042, 4.075598>, <-0.091695, 0.582703, 4.127406>, <-0.082781, 0.565908, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.372015, 0.639035, 4.036015>, <0.341718, 0.620292, 4.072039>, <0.341758, 0.559146, 4.126081>, <0.336251, 0.551327, 4.175835>, 
      <0.301161, 0.690903, 4.028213>, <0.270864, 0.672160, 4.064237>, <0.284089, 0.604409, 4.126081>, <0.278582, 0.596590, 4.175835>, 
      <0.172730, 0.694444, 4.017611>, <0.177200, 0.661713, 4.062666>, <0.167796, 0.617950, 4.123892>, <0.170055, 0.597502, 4.175835>, 
      <0.084627, 0.697510, 4.017611>, <0.089098, 0.664779, 4.062666>, <0.094530, 0.620499, 4.123892>, <0.096788, 0.600051, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.520045, 0.378768, 4.065557>, <0.481256, 0.377344, 4.085078>, <0.485123, 0.304188, 4.136080>, <0.493416, 0.288748, 4.175835>, 
      <0.484119, 0.461431, 4.060720>, <0.445330, 0.460006, 4.080241>, <0.451616, 0.389661, 4.136080>, <0.459910, 0.374221, 4.175835>, 
      <0.444562, 0.585928, 4.044004>, <0.414265, 0.567185, 4.080027>, <0.413976, 0.502463, 4.126081>, <0.408469, 0.494645, 4.175835>, 
      <0.372015, 0.639035, 4.036015>, <0.341718, 0.620292, 4.072039>, <0.341758, 0.559146, 4.126081>, <0.336251, 0.551327, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.591417, 0.134216, 4.065557>, <0.554307, 0.148172, 4.080114>, <0.531399, 0.093372, 4.136322>, <0.519065, 0.084978, 4.175835>, 
      <0.579764, 0.209749, 4.065557>, <0.542654, 0.223704, 4.080114>, <0.527373, 0.154853, 4.136322>, <0.515039, 0.146460, 4.175835>, 
      <0.550465, 0.308776, 4.069653>, <0.511676, 0.307352, 4.089174>, <0.507610, 0.246825, 4.136080>, <0.515903, 0.231385, 4.175835>, 
      <0.520045, 0.378768, 4.065557>, <0.481256, 0.377344, 4.085078>, <0.485123, 0.304188, 4.136080>, <0.493416, 0.288748, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.591417, 0.134216, 4.065557>, <0.579764, 0.209749, 4.065557>, <0.550465, 0.308776, 4.069653>, <0.520045, 0.378768, 4.065557>, 
      <0.767387, 0.068041, 3.996527>, <0.755734, 0.143573, 3.996527>, <0.764180, 0.316624, 3.962097>, <0.733760, 0.386616, 3.958001>, 
      <0.988591, -0.113218, 3.983755>, <1.009365, 0.036655, 3.981732>, <1.157070, 0.143468, 3.968136>, <1.088989, 0.276432, 3.943996>, 
      <1.172279, -0.160670, 3.919591>, <1.193053, -0.010798, 3.917568>, <1.333448, 0.184130, 3.811478>, <1.265366, 0.317094, 3.787338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.591417, 0.134216, 4.065557>, <0.601141, 0.071184, 4.065557>, <0.605507, -0.016370, 4.065557>, <0.590570, -0.078373, 4.065557>, 
      <0.554307, 0.148172, 4.080114>, <0.564031, 0.085140, 4.080114>, <0.576421, 0.004374, 4.083010>, <0.561484, -0.057629, 4.083010>, 
      <0.531399, 0.093372, 4.136322>, <0.534872, 0.040344, 4.136322>, <0.542613, -0.038241, 4.137935>, <0.530166, -0.089905, 4.137935>, 
      <0.519065, 0.084978, 4.175835>, <0.522537, 0.031950, 4.175835>, <0.530805, -0.040496, 4.175835>, <0.518359, -0.092159, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.591417, 0.134216, 4.065557>, <0.767387, 0.068041, 3.996527>, <0.988591, -0.113218, 3.983755>, <1.172279, -0.160670, 3.919591>, 
      <0.601141, 0.071184, 4.065557>, <0.777111, 0.005009, 3.996527>, <0.972156, -0.231792, 3.985355>, <1.155844, -0.279245, 3.921191>, 
      <0.605507, -0.016370, 4.065557>, <0.774572, -0.136946, 3.964113>, <1.081147, -0.324093, 3.980968>, <1.207420, -0.440883, 3.826608>, 
      <0.590570, -0.078373, 4.065557>, <0.759634, -0.198949, 3.964113>, <1.020268, -0.423385, 3.953267>, <1.146541, -0.540175, 3.798906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.484570, -0.309292, 4.065557>, <0.465831, -0.284786, 4.087132>, <0.438612, -0.288458, 4.139386>, <0.430036, -0.284570, 4.175835>, 
      <0.545884, -0.264004, 4.065557>, <0.527145, -0.239498, 4.087132>, <0.489701, -0.250722, 4.139386>, <0.481125, -0.246835, 4.175835>, 
      <0.572717, -0.152479, 4.065557>, <0.543631, -0.131735, 4.083010>, <0.515291, -0.151653, 4.137935>, <0.503483, -0.153907, 4.175835>, 
      <0.590570, -0.078373, 4.065557>, <0.561484, -0.057629, 4.083010>, <0.530166, -0.089905, 4.137935>, <0.518359, -0.092159, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.484570, -0.309292, 4.065557>, <0.545884, -0.264004, 4.065557>, <0.572717, -0.152479, 4.065557>, <0.590570, -0.078373, 4.065557>, 
      <0.580125, -0.434256, 3.955544>, <0.641439, -0.388968, 3.955544>, <0.741781, -0.273054, 3.964113>, <0.759634, -0.198949, 3.964113>, 
      <0.740022, -0.652304, 3.891012>, <0.855372, -0.603605, 3.896885>, <0.956526, -0.527345, 3.924263>, <1.020268, -0.423385, 3.953267>, 
      <0.799812, -0.768153, 3.750110>, <0.915162, -0.719453, 3.755983>, <1.082800, -0.644135, 3.769902>, <1.146541, -0.540175, 3.798906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.224756, -0.348569, 4.065557>, <0.225915, -0.319992, 4.084944>, <0.215203, -0.321912, 4.141632>, <0.213549, -0.317297, 4.175835>, 
      <0.303584, -0.349035, 4.065557>, <0.304743, -0.320458, 4.084944>, <0.280886, -0.322300, 4.141632>, <0.279232, -0.317685, 4.175835>, 
      <0.421161, -0.356127, 4.065557>, <0.402422, -0.331620, 4.087132>, <0.385777, -0.327482, 4.139386>, <0.377202, -0.323595, 4.175835>, 
      <0.484570, -0.309292, 4.065557>, <0.465831, -0.284786, 4.087132>, <0.438612, -0.288458, 4.139386>, <0.430036, -0.284570, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.053163, -0.306113, 4.065557>, <-0.035798, -0.282942, 4.086049>, <-0.023313, -0.285562, 4.140948>, <-0.018024, -0.281921, 4.175835>, 
      <0.020891, -0.346483, 4.065557>, <0.038256, -0.323312, 4.086049>, <0.038392, -0.319200, 4.140948>, <0.043681, -0.315559, 4.175835>, 
      <0.140415, -0.348070, 4.065557>, <0.141573, -0.319494, 4.084944>, <0.144926, -0.321496, 4.141632>, <0.143272, -0.316881, 4.175835>, 
      <0.224756, -0.348569, 4.065557>, <0.225915, -0.319992, 4.084944>, <0.215203, -0.321912, 4.141632>, <0.213549, -0.317297, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.215378, -0.108634, 4.065557>, <-0.185479, -0.095895, 4.085389>, <-0.163047, -0.115988, 4.139088>, <-0.153187, -0.117374, 4.175835>, 
      <-0.178628, -0.175921, 4.065557>, <-0.148729, -0.163182, 4.085389>, <-0.132425, -0.172054, 4.139088>, <-0.122566, -0.173440, 4.175835>, 
      <-0.120479, -0.269416, 4.065557>, <-0.103114, -0.246246, 4.086049>, <-0.079403, -0.254985, 4.140948>, <-0.074114, -0.251344, 4.175835>, 
      <-0.053163, -0.306113, 4.065557>, <-0.035798, -0.282942, 4.086049>, <-0.023313, -0.285562, 4.140948>, <-0.018024, -0.281921, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.292868, 0.132770, 4.065557>, <-0.255622, 0.142934, 4.083661>, <-0.230643, 0.092180, 4.136066>, <-0.217755, 0.083773, 4.175835>, 
      <-0.281748, 0.057526, 4.065557>, <-0.244502, 0.067690, 4.083661>, <-0.221377, 0.029484, 4.136066>, <-0.208489, 0.021077, 4.175835>, 
      <-0.251837, -0.041881, 4.065557>, <-0.221938, -0.029142, 4.085389>, <-0.193426, -0.060367, 4.139088>, <-0.183566, -0.061753, 4.175835>, 
      <-0.215378, -0.108634, 4.065557>, <-0.185479, -0.095895, 4.085389>, <-0.163047, -0.115988, 4.139088>, <-0.153187, -0.117374, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.285076, 0.362977, 4.065557>, <-0.244659, 0.361258, 4.090770>, <-0.224875, 0.291706, 4.133090>, <-0.211262, 0.275590, 4.175835>, 
      <-0.305464, 0.297056, 4.069275>, <-0.265047, 0.295337, 4.094488>, <-0.240397, 0.236259, 4.133090>, <-0.226784, 0.220144, 4.175835>, 
      <-0.302971, 0.201129, 4.065557>, <-0.265724, 0.211293, 4.083661>, <-0.239061, 0.149139, 4.136066>, <-0.226173, 0.140732, 4.175835>, 
      <-0.292868, 0.132770, 4.065557>, <-0.255622, 0.142934, 4.083661>, <-0.230643, 0.092180, 4.136066>, <-0.217755, 0.083773, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.285076, 0.362977, 4.065557>, <-0.255610, 0.458251, 4.060183>, <-0.204595, 0.589833, 4.045575>, <-0.130881, 0.656534, 4.036015>, 
      <-0.244659, 0.361258, 4.090770>, <-0.215193, 0.456532, 4.085396>, <-0.180342, 0.566341, 4.085157>, <-0.106628, 0.633042, 4.075598>, 
      <-0.224875, 0.291706, 4.133090>, <-0.199198, 0.383423, 4.133090>, <-0.157273, 0.513632, 4.127406>, <-0.091695, 0.582703, 4.127406>, 
      <-0.211262, 0.275590, 4.175835>, <-0.185586, 0.367307, 4.175835>, <-0.148359, 0.496837, 4.175835>, <-0.082781, 0.565908, 4.175835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.054546, 0.909324, 3.750110>, <0.058673, 0.863938, 3.842210>, <0.076404, 0.757712, 3.934740>, <0.084627, 0.697510, 4.017611>, 
      <-0.067852, 0.914718, 3.750110>, <-0.063726, 0.869332, 3.842210>, <0.010402, 0.760009, 3.934740>, <0.018625, 0.699807, 4.017611>, 
      <-0.240333, 0.884446, 3.750110>, <-0.188745, 0.856892, 3.851958>, <-0.136885, 0.753672, 3.940341>, <-0.082136, 0.700642, 4.029694>, 
      <-0.343633, 0.818571, 3.750110>, <-0.292045, 0.791017, 3.851958>, <-0.185630, 0.709564, 3.946662>, <-0.130881, 0.656534, 4.036015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.694298, 0.772830, 3.750110>, <0.627350, 0.750580, 3.865604>, <0.452945, 0.689101, 3.939788>, <0.372015, 0.639035, 4.036015>, 
      <0.518077, 0.859022, 3.744692>, <0.451130, 0.836772, 3.860185>, <0.382090, 0.740969, 3.931986>, <0.301161, 0.690903, 4.028213>, 
      <0.250601, 0.900684, 3.750110>, <0.254728, 0.855298, 3.842210>, <0.164507, 0.754647, 3.934740>, <0.172730, 0.694444, 4.017611>, 
      <0.054546, 0.909324, 3.750110>, <0.058673, 0.863938, 3.842210>, <0.076404, 0.757712, 3.934740>, <0.084627, 0.697510, 4.017611>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.694298, 0.772830, 3.750110>, <0.891375, 0.676437, 3.756169>, <1.166620, 0.509945, 3.752325>, <1.265366, 0.317094, 3.787338>, 
      <0.627350, 0.750580, 3.865604>, <0.824428, 0.654187, 3.871663>, <0.990243, 0.469283, 3.908984>, <1.088989, 0.276432, 3.943996>, 
      <0.452945, 0.689101, 3.939788>, <0.525491, 0.635995, 3.947776>, <0.697834, 0.469278, 3.953164>, <0.733760, 0.386616, 3.958001>, 
      <0.372015, 0.639035, 4.036015>, <0.444562, 0.585928, 4.044004>, <0.484119, 0.461431, 4.060720>, <0.520045, 0.378768, 4.065557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.188100, -0.944817, 3.750110>, <0.195366, -0.802989, 3.894694>, <0.217958, -0.516185, 3.951842>, <0.224756, -0.348569, 4.065557>, 
      <0.379112, -0.945602, 3.750110>, <0.386377, -0.803774, 3.894694>, <0.296787, -0.516651, 3.951842>, <0.303584, -0.349035, 4.065557>, 
      <0.624032, -0.842365, 3.741161>, <0.564241, -0.726516, 3.882063>, <0.516716, -0.481090, 3.955544>, <0.421161, -0.356127, 4.065557>, 
      <0.799812, -0.768153, 3.750110>, <0.740022, -0.652304, 3.891012>, <0.580125, -0.434256, 3.955544>, <0.484570, -0.309292, 4.065557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.378794, -0.763310, 3.750110>, <-0.316898, -0.647253, 3.891570>, <-0.147721, -0.432285, 3.953974>, <-0.053163, -0.306113, 4.065557>, 
      <-0.223220, -0.850975, 3.750110>, <-0.161325, -0.734917, 3.891570>, <-0.073667, -0.472655, 3.953974>, <0.020891, -0.346483, 4.065557>, 
      <0.009529, -0.944083, 3.750110>, <0.016794, -0.802256, 3.894694>, <0.133617, -0.515687, 3.951842>, <0.140415, -0.348070, 4.065557>, 
      <0.188100, -0.944817, 3.750110>, <0.195366, -0.802989, 3.894694>, <0.217958, -0.516185, 3.951842>, <0.224756, -0.348569, 4.065557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.795020, -0.390835, 3.750110>, <-0.670306, -0.318942, 3.910233>, <-0.384470, -0.180678, 3.953399>, <-0.215378, -0.108634, 4.065557>, 
      <-0.673920, -0.506520, 3.744629>, <-0.549206, -0.434627, 3.904752>, <-0.347720, -0.247964, 3.953399>, <-0.178628, -0.175921, 4.065557>, 
      <-0.524778, -0.681049, 3.750110>, <-0.462882, -0.564991, 3.891570>, <-0.215037, -0.395589, 3.953974>, <-0.120479, -0.269416, 4.065557>, 
      <-0.378794, -0.763310, 3.750110>, <-0.316898, -0.647253, 3.891570>, <-0.147721, -0.432285, 3.953974>, <-0.053163, -0.306113, 4.065557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.032726, -0.138617, 3.779706>, <-0.868845, -0.042640, 3.944566>, <-0.512536, 0.072827, 3.958784>, <-0.292868, 0.132770, 4.065557>, 
      <-1.018065, -0.241935, 3.779706>, <-0.854183, -0.145957, 3.944566>, <-0.501416, -0.002417, 3.958784>, <-0.281748, 0.057526, 4.065557>, 
      <-0.870436, -0.318791, 3.753523>, <-0.745722, -0.246898, 3.913646>, <-0.420928, -0.113924, 3.953399>, <-0.251837, -0.041881, 4.065557>, 
      <-0.795020, -0.390835, 3.750110>, <-0.670306, -0.318942, 3.910233>, <-0.384470, -0.180678, 3.953399>, <-0.215378, -0.108634, 4.065557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.893708, 0.304615, 3.750110>, <-0.763649, 0.324490, 3.909141>, <-0.460082, 0.370420, 3.956384>, <-0.285076, 0.362977, 4.065557>, 
      <-0.975268, 0.191324, 3.753613>, <-0.845209, 0.211199, 3.912644>, <-0.480469, 0.304499, 3.960103>, <-0.305464, 0.297056, 4.069275>, 
      <-1.052345, -0.000363, 3.779706>, <-0.888464, 0.095614, 3.944566>, <-0.522639, 0.141186, 3.958784>, <-0.302971, 0.201129, 4.065557>, 
      <-1.032726, -0.138617, 3.779706>, <-0.868845, -0.042640, 3.944566>, <-0.512536, 0.072827, 3.958784>, <-0.292868, 0.132770, 4.065557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.893708, 0.304615, 3.750110>, <-0.761798, 0.487846, 3.744445>, <-0.534054, 0.697138, 3.750110>, <-0.343633, 0.818571, 3.750110>, 
      <-0.763649, 0.324490, 3.909141>, <-0.631739, 0.507721, 3.903476>, <-0.482466, 0.669585, 3.851958>, <-0.292045, 0.791017, 3.851958>, 
      <-0.460082, 0.370420, 3.956384>, <-0.430616, 0.465694, 3.951010>, <-0.259344, 0.642862, 3.956222>, <-0.185630, 0.709564, 3.946662>, 
      <-0.285076, 0.362977, 4.065557>, <-0.255610, 0.458251, 4.060183>, <-0.204595, 0.589833, 4.045575>, <-0.130881, 0.656534, 4.036015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.053430, 1.040624, 3.321342>, <0.053604, 1.020171, 3.454305>, <0.049144, 0.968741, 3.629537>, <0.054546, 0.909324, 3.750110>, 
      <-0.119881, 1.050537, 3.321342>, <-0.119706, 1.030084, 3.454305>, <-0.073255, 0.974135, 3.629537>, <-0.067852, 0.914718, 3.750110>, 
      <-0.358223, 0.959442, 3.321342>, <-0.327125, 0.957490, 3.454262>, <-0.300300, 0.916476, 3.631718>, <-0.240333, 0.884446, 3.750110>, 
      <-0.492875, 0.849880, 3.321342>, <-0.461777, 0.847928, 3.454262>, <-0.403600, 0.850600, 3.631718>, <-0.343633, 0.818571, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.786286, 0.776717, 3.321342>, <0.810906, 0.775168, 3.153150>, <0.841367, 0.773322, 2.927078>, <0.839614, 0.763686, 2.757368>, 
      <0.957724, 0.715122, 3.321342>, <0.982343, 0.713573, 3.153150>, <1.003974, 0.673107, 2.910029>, <1.002221, 0.663471, 2.740319>, 
      <1.185669, 0.630414, 3.330771>, <1.186990, 0.629195, 3.107462>, <1.102443, 0.575914, 2.788249>, <1.112612, 0.417060, 2.631622>, 
      <1.357936, 0.571934, 3.321342>, <1.359257, 0.570715, 3.098034>, <1.262048, 0.469627, 2.786191>, <1.272216, 0.310773, 2.629564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.786286, 0.776717, 3.321342>, <0.957724, 0.715122, 3.321342>, <1.185669, 0.630414, 3.330771>, <1.357936, 0.571934, 3.321342>, 
      <0.767232, 0.777916, 3.451512>, <0.938670, 0.716321, 3.451512>, <1.184712, 0.631297, 3.492506>, <1.356979, 0.572817, 3.483077>, 
      <0.759379, 0.794459, 3.637836>, <0.956457, 0.698066, 3.643896>, <1.285790, 0.537418, 3.646478>, <1.384536, 0.344567, 3.681491>, 
      <0.694298, 0.772830, 3.750110>, <0.891375, 0.676437, 3.756169>, <1.166620, 0.509945, 3.752325>, <1.265366, 0.317094, 3.787338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.786286, 0.776717, 3.321342>, <0.767232, 0.777916, 3.451512>, <0.759379, 0.794459, 3.637836>, <0.694298, 0.772830, 3.750110>, 
      <0.566372, 0.855729, 3.321342>, <0.547318, 0.856928, 3.451512>, <0.583158, 0.880652, 3.632418>, <0.518077, 0.859022, 3.744692>, 
      <0.286726, 1.027280, 3.321342>, <0.286901, 1.006828, 3.454305>, <0.245199, 0.960101, 3.629537>, <0.250601, 0.900684, 3.750110>, 
      <0.053430, 1.040624, 3.321342>, <0.053604, 1.020171, 3.454305>, <0.049144, 0.968741, 3.629537>, <0.054546, 0.909324, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.800370, -0.921180, 3.321342>, <0.800295, -0.890413, 3.454409>, <0.842352, -0.850577, 3.649860>, <0.799812, -0.768153, 3.750110>, 
      <0.937087, -0.865017, 3.318737>, <0.937012, -0.834249, 3.451803>, <0.957702, -0.801878, 3.655733>, <0.915162, -0.719453, 3.755983>, 
      <1.086993, -0.724493, 3.328414>, <1.072605, -0.723117, 3.482284>, <1.167240, -0.722234, 3.666680>, <1.082800, -0.644135, 3.769902>, 
      <1.215397, -0.656274, 3.301750>, <1.201009, -0.654898, 3.455619>, <1.230982, -0.618274, 3.695684>, <1.146541, -0.540175, 3.798906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.187358, -1.078594, 3.321342>, <0.187383, -1.051973, 3.453432>, <0.183269, -1.039115, 3.653979>, <0.188100, -0.944817, 3.750110>, 
      <0.377227, -1.079318, 3.321342>, <0.377251, -1.052697, 3.453432>, <0.374281, -1.039900, 3.653979>, <0.379112, -0.945602, 3.750110>, 
      <0.624769, -0.993317, 3.324689>, <0.624694, -0.962550, 3.457755>, <0.666572, -0.924790, 3.640911>, <0.624032, -0.842365, 3.741161>, 
      <0.800370, -0.921180, 3.321342>, <0.800295, -0.890413, 3.454409>, <0.842352, -0.850577, 3.649860>, <0.799812, -0.768153, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.378794, -0.916685, 3.321342>, <-0.378769, -0.890838, 3.455487>, <-0.422569, -0.845391, 3.650063>, <-0.378794, -0.763310, 3.750110>, 
      <-0.230491, -1.012670, 3.321342>, <-0.230466, -0.986823, 3.455487>, <-0.266996, -0.933056, 3.650063>, <-0.223220, -0.850975, 3.750110>, 
      <0.010705, -1.077921, 3.321342>, <0.010729, -1.051300, 3.453432>, <0.004698, -1.038381, 3.653979>, <0.009529, -0.944083, 3.750110>, 
      <0.187358, -1.078594, 3.321342>, <0.187383, -1.051973, 3.453432>, <0.183269, -1.039115, 3.653979>, <0.188100, -0.944817, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.795020, -0.442776, 3.321342>, <-0.795020, -0.430962, 3.450373>, <-0.870069, -0.434098, 3.653753>, <-0.795020, -0.390835, 3.750110>, 
      <-0.657311, -0.572550, 3.321342>, <-0.657311, -0.560736, 3.450373>, <-0.748969, -0.549783, 3.648272>, <-0.673920, -0.506520, 3.744629>, 
      <-0.537647, -0.813871, 3.321342>, <-0.537623, -0.788025, 3.455487>, <-0.568554, -0.763130, 3.650063>, <-0.524778, -0.681049, 3.750110>, 
      <-0.378794, -0.916685, 3.321342>, <-0.378769, -0.890838, 3.455487>, <-0.422569, -0.845391, 3.650063>, <-0.378794, -0.763310, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.032664, -0.300492, 3.321342>, <-1.032673, -0.285715, 3.466424>, <-1.127756, -0.194272, 3.684108>, <-1.032726, -0.138617, 3.779706>, 
      <-1.021267, -0.382802, 3.321342>, <-1.021276, -0.368024, 3.466424>, <-1.113095, -0.297589, 3.684108>, <-1.018065, -0.241935, 3.779706>, 
      <-0.855493, -0.385787, 3.321342>, <-0.855493, -0.373973, 3.450373>, <-0.945484, -0.362054, 3.657166>, <-0.870436, -0.318791, 3.753523>, 
      <-0.795020, -0.442776, 3.321342>, <-0.795020, -0.430962, 3.450373>, <-0.870069, -0.434098, 3.653753>, <-0.795020, -0.390835, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.893708, 0.269968, 3.321342>, <-0.803870, 0.461426, 3.321342>, <-0.656919, 0.716402, 3.321342>, <-0.492875, 0.849880, 3.321342>, 
      <-0.893708, 0.268467, 3.450383>, <-0.803870, 0.459925, 3.450383>, <-0.625821, 0.714451, 3.454262>, <-0.461777, 0.847928, 3.454262>, 
      <-0.975026, 0.292188, 3.650678>, <-0.843115, 0.475419, 3.645012>, <-0.594021, 0.729168, 3.631718>, <-0.403600, 0.850600, 3.631718>, 
      <-0.893708, 0.304615, 3.750110>, <-0.761798, 0.487846, 3.744445>, <-0.534054, 0.697138, 3.750110>, <-0.343633, 0.818571, 3.750110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.893708, 0.269968, 3.321342>, <-0.893708, 0.268467, 3.450383>, <-0.975026, 0.292188, 3.650678>, <-0.893708, 0.304615, 3.750110>, 
      <-0.968531, 0.110508, 3.321342>, <-0.968531, 0.109007, 3.450383>, <-1.056585, 0.178897, 3.654180>, <-0.975268, 0.191324, 3.753613>, 
      <-1.056822, -0.126015, 3.321342>, <-1.056831, -0.111238, 3.466424>, <-1.147375, -0.056017, 3.684108>, <-1.052345, -0.000363, 3.779706>, 
      <-1.032664, -0.300492, 3.321342>, <-1.032673, -0.285715, 3.466424>, <-1.127756, -0.194272, 3.684108>, <-1.032726, -0.138617, 3.779706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.053244, 1.062031, 2.757368>, <0.054570, 1.078526, 2.925872>, <0.053211, 1.066366, 3.153996>, <0.053430, 1.040624, 3.321342>, 
      <-0.147360, 1.071875, 2.757368>, <-0.146033, 1.088370, 2.925872>, <-0.120100, 1.076278, 3.153996>, <-0.119881, 1.050537, 3.321342>, 
      <-0.418119, 0.957423, 2.757368>, <-0.416294, 0.979630, 2.927000>, <-0.397195, 0.961888, 3.154768>, <-0.358223, 0.959442, 3.321342>, 
      <-0.575899, 0.833148, 2.757368>, <-0.574074, 0.855355, 2.927000>, <-0.531847, 0.852326, 3.154768>, <-0.492875, 0.849880, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.053244, 1.062031, 2.757368>, <0.305260, 1.049664, 2.757368>, <0.625663, 0.895545, 2.779800>, <0.839614, 0.763686, 2.757368>, 
      <0.054570, 1.078526, 2.925872>, <0.306586, 1.066159, 2.925872>, <0.627416, 0.905181, 2.949509>, <0.841367, 0.773322, 2.927078>, 
      <0.053211, 1.066366, 3.153996>, <0.286507, 1.053022, 3.153996>, <0.590991, 0.854180, 3.153150>, <0.810906, 0.775168, 3.153150>, 
      <0.053430, 1.040624, 3.321342>, <0.286726, 1.027280, 3.321342>, <0.566372, 0.855729, 3.321342>, <0.786286, 0.776717, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.800370, -0.997692, 2.757368>, <0.800428, -1.011721, 2.927533>, <0.800463, -0.959644, 3.154989>, <0.800370, -0.921180, 3.321342>, 
      <0.969991, -0.903293, 2.737320>, <0.970049, -0.917323, 2.907485>, <0.937180, -0.903480, 3.152383>, <0.937087, -0.865017, 3.318737>, 
      <1.137587, -0.699586, 2.675142>, <1.136320, -0.742301, 2.874635>, <1.105986, -0.726310, 3.125290>, <1.086993, -0.724493, 3.328414>, 
      <1.255734, -0.550620, 2.631157>, <1.254467, -0.593335, 2.830650>, <1.234391, -0.658091, 3.098625>, <1.215397, -0.656274, 3.301750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.187915, -1.144890, 2.757368>, <0.188204, -1.159206, 2.927123>, <0.187327, -1.112250, 3.154342>, <0.187358, -1.078594, 3.321342>, 
      <0.376758, -1.151792, 2.757368>, <0.377046, -1.166107, 2.927123>, <0.377196, -1.112974, 3.154342>, <0.377227, -1.079318, 3.321342>, 
      <0.636123, -1.089100, 2.776781>, <0.636181, -1.103129, 2.946946>, <0.624862, -1.031781, 3.158335>, <0.624769, -0.993317, 3.324689>, 
      <0.800370, -0.997692, 2.757368>, <0.800428, -1.011721, 2.927533>, <0.800463, -0.959644, 3.154989>, <0.800370, -0.921180, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.187915, -1.144890, 2.757368>, <0.008640, -1.138338, 2.757368>, <-0.230265, -1.054924, 2.757368>, <-0.378978, -0.954591, 2.757368>, 
      <0.188204, -1.159206, 2.927123>, <0.008929, -1.152654, 2.927123>, <-0.230226, -1.072397, 2.926039>, <-0.378940, -0.972064, 2.926039>, 
      <0.187327, -1.112250, 3.154342>, <0.010674, -1.111577, 3.154342>, <-0.230522, -1.044753, 3.154831>, <-0.378825, -0.948768, 3.154831>, 
      <0.187358, -1.078594, 3.321342>, <0.010705, -1.077921, 3.321342>, <-0.230491, -1.012670, 3.321342>, <-0.378794, -0.916685, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.795020, -0.481732, 2.757368>, <-0.795020, -0.479953, 2.926954>, <-0.795020, -0.458240, 3.152453>, <-0.795020, -0.442776, 3.321342>, 
      <-0.667219, -0.620904, 2.757368>, <-0.667219, -0.619124, 2.926954>, <-0.657311, -0.588014, 3.152453>, <-0.657311, -0.572550, 3.321342>, 
      <-0.535612, -0.848914, 2.757368>, <-0.535574, -0.866387, 2.926039>, <-0.537678, -0.845955, 3.154831>, <-0.537647, -0.813871, 3.321342>, 
      <-0.378978, -0.954591, 2.757368>, <-0.378940, -0.972064, 2.926039>, <-0.378825, -0.948768, 3.154831>, <-0.378794, -0.916685, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.032664, -0.242746, 2.757368>, <-1.022487, -0.247433, 2.927075>, <-1.032654, -0.317726, 3.152141>, <-1.032664, -0.300492, 3.321342>, 
      <-1.020253, -0.343090, 2.757368>, <-1.010076, -0.347777, 2.927075>, <-1.021257, -0.400035, 3.152141>, <-1.021267, -0.382802, 3.321342>, 
      <-0.863408, -0.407260, 2.757368>, <-0.863408, -0.405481, 2.926954>, <-0.855493, -0.401251, 3.152453>, <-0.855493, -0.385787, 3.321342>, 
      <-0.795020, -0.481732, 2.757368>, <-0.795020, -0.479953, 2.926954>, <-0.795020, -0.458240, 3.152453>, <-0.795020, -0.442776, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.893708, 0.316164, 2.757368>, <-0.893945, 0.312283, 2.927082>, <-0.893708, 0.271943, 3.151595>, <-0.893708, 0.269968, 3.321342>, 
      <-0.961227, 0.157126, 2.757368>, <-0.961464, 0.153244, 2.927082>, <-0.968531, 0.112483, 3.151595>, <-0.968531, 0.110508, 3.321342>, 
      <-1.053872, -0.071275, 2.757368>, <-1.043695, -0.075962, 2.927075>, <-1.056812, -0.143248, 3.152141>, <-1.056822, -0.126015, 3.321342>, 
      <-1.032664, -0.242746, 2.757368>, <-1.022487, -0.247433, 2.927075>, <-1.032654, -0.317726, 3.152141>, <-1.032664, -0.300492, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.893708, 0.316164, 2.757368>, <-0.822563, 0.483744, 2.757368>, <-0.718919, 0.720498, 2.757368>, <-0.575899, 0.833148, 2.757368>, 
      <-0.893945, 0.312283, 2.927082>, <-0.822800, 0.479863, 2.927082>, <-0.717094, 0.742705, 2.927000>, <-0.574074, 0.855355, 2.927000>, 
      <-0.893708, 0.271943, 3.151595>, <-0.803870, 0.463400, 3.151595>, <-0.695892, 0.718848, 3.154768>, <-0.531847, 0.852326, 3.154768>, 
      <-0.893708, 0.269968, 3.321342>, <-0.803870, 0.461426, 3.321342>, <-0.656919, 0.716402, 3.321342>, <-0.492875, 0.849880, 3.321342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.040539, 0.880306, 1.683604>, <0.042691, 0.945188, 2.003822>, <0.050685, 1.030200, 2.432200>, <0.053244, 1.062031, 2.757368>, 
      <-0.140226, 0.873492, 1.683604>, <-0.138073, 0.938373, 2.003822>, <-0.149919, 1.040044, 2.432200>, <-0.147360, 1.071875, 2.757368>, 
      <-0.356391, 0.730208, 1.683604>, <-0.369966, 0.772301, 2.008739>, <-0.421620, 0.914833, 2.432034>, <-0.418119, 0.957423, 2.757368>, 
      <-0.510496, 0.635478, 1.683604>, <-0.524071, 0.677572, 2.008739>, <-0.579399, 0.790557, 2.432034>, <-0.575899, 0.833148, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.769373, 0.683725, 1.683604>, <0.801159, 0.715376, 2.004189>, <0.836277, 0.745336, 2.434198>, <0.839614, 0.763686, 2.757368>, 
      <0.570099, 0.791316, 1.683604>, <0.601885, 0.822967, 2.004189>, <0.622326, 0.877195, 2.456630>, <0.625663, 0.895545, 2.779800>, 
      <0.266842, 0.888837, 1.683604>, <0.268994, 0.953719, 2.003822>, <0.302700, 1.017834, 2.432200>, <0.305260, 1.049664, 2.757368>, 
      <0.040539, 0.880306, 1.683604>, <0.042691, 0.945188, 2.003822>, <0.050685, 1.030200, 2.432200>, <0.053244, 1.062031, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.138057, 0.287738, 1.683604>, <1.185941, 0.293498, 1.966230>, <1.231968, 0.303862, 2.345776>, <1.272216, 0.310773, 2.629564>, 
      <1.054438, 0.426856, 1.683604>, <1.102322, 0.432616, 1.966230>, <1.072364, 0.410150, 2.347834>, <1.112612, 0.417060, 2.631622>, 
      <0.912200, 0.606611, 1.683604>, <0.943985, 0.638261, 2.004189>, <0.998884, 0.645121, 2.417150>, <1.002221, 0.663471, 2.740319>, 
      <0.769373, 0.683725, 1.683604>, <0.801159, 0.715376, 2.004189>, <0.836277, 0.745336, 2.434198>, <0.839614, 0.763686, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.312836, -0.220440, 1.683604>, <1.337416, -0.225466, 1.938152>, <1.370349, -0.242314, 2.278183>, <1.409266, -0.229965, 2.530684>, 
      <1.289447, -0.060927, 1.683604>, <1.314027, -0.065953, 1.938152>, <1.373601, -0.072386, 2.277868>, <1.412517, -0.060037, 2.530370>, 
      <1.221111, 0.149560, 1.683604>, <1.268995, 0.155319, 1.966230>, <1.239707, 0.182963, 2.226572>, <1.279955, 0.189874, 2.510360>, 
      <1.138057, 0.287738, 1.683604>, <1.185941, 0.293498, 1.966230>, <1.231968, 0.303862, 2.345776>, <1.272216, 0.310773, 2.629564>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.225672, -0.309802, 1.683604>, <1.225029, -0.337945, 1.975692>, <1.257556, -0.489183, 2.344225>, <1.255734, -0.550620, 2.631157>, 
      <1.250830, -0.282061, 1.683604>, <1.250186, -0.310204, 1.975692>, <1.324655, -0.404581, 2.319245>, <1.322833, -0.466018, 2.606177>, 
      <1.318269, -0.257494, 1.683604>, <1.342849, -0.262520, 1.938152>, <1.368229, -0.353126, 2.278387>, <1.407146, -0.340777, 2.530889>, 
      <1.312836, -0.220440, 1.683604>, <1.337416, -0.225466, 1.938152>, <1.370349, -0.242314, 2.278183>, <1.409266, -0.229965, 2.530684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.799813, -0.786157, 1.683604>, <0.795419, -0.834238, 2.008355>, <0.800259, -0.970715, 2.430158>, <0.800370, -0.997692, 2.757368>, 
      <0.963764, -0.686838, 1.683604>, <0.959370, -0.734919, 2.008355>, <0.969880, -0.876317, 2.410109>, <0.969991, -0.903293, 2.737320>, 
      <1.096903, -0.451798, 1.683604>, <1.096259, -0.479941, 1.975692>, <1.139409, -0.638149, 2.388210>, <1.137587, -0.699586, 2.675142>, 
      <1.225672, -0.309802, 1.683604>, <1.225029, -0.337945, 1.975692>, <1.257556, -0.489183, 2.344225>, <1.255734, -0.550620, 2.631157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.184574, -0.940482, 1.683604>, <0.184693, -0.969758, 2.010210>, <0.187360, -1.117334, 2.430613>, <0.187915, -1.144890, 2.757368>, 
      <0.374759, -0.946794, 1.683604>, <0.374878, -0.976070, 2.010210>, <0.376202, -1.124236, 2.430613>, <0.376758, -1.151792, 2.757368>, 
      <0.637058, -0.884752, 1.683604>, <0.632664, -0.932833, 2.008355>, <0.636012, -1.062123, 2.449571>, <0.636123, -1.089100, 2.776781>, 
      <0.799813, -0.786157, 1.683604>, <0.795419, -0.834238, 2.008355>, <0.800259, -0.970715, 2.430158>, <0.800370, -0.997692, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.379165, -0.747029, 1.683604>, <-0.379204, -0.796371, 2.007965>, <-0.379052, -0.920784, 2.431022>, <-0.378978, -0.954591, 2.757368>, 
      <-0.218636, -0.825774, 1.683604>, <-0.218675, -0.875116, 2.007965>, <-0.230339, -1.021117, 2.431022>, <-0.230265, -1.054924, 2.757368>, 
      <0.005870, -0.934551, 1.683604>, <0.005989, -0.963828, 2.010210>, <0.008085, -1.110783, 2.430613>, <0.008640, -1.138338, 2.757368>, 
      <0.184574, -0.940482, 1.683604>, <0.184693, -0.969758, 2.010210>, <0.187360, -1.117334, 2.430613>, <0.187915, -1.144890, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.795021, -0.459958, 1.683604>, <-0.795021, -0.459663, 2.005799>, <-0.795020, -0.485112, 2.435190>, <-0.795020, -0.481732, 2.757368>, 
      <-0.668161, -0.542949, 1.683604>, <-0.668160, -0.542654, 2.005799>, <-0.667219, -0.624284, 2.435190>, <-0.667219, -0.620904, 2.757368>, 
      <-0.515267, -0.680266, 1.683604>, <-0.515307, -0.729608, 2.007965>, <-0.535686, -0.815108, 2.431022>, <-0.535612, -0.848914, 2.757368>, 
      <-0.379165, -0.747029, 1.683604>, <-0.379204, -0.796371, 2.007965>, <-0.379052, -0.920784, 2.431022>, <-0.378978, -0.954591, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.130875, -0.255266, 1.683604>, <-1.116298, -0.277987, 2.005971>, <-1.052021, -0.233832, 2.434575>, <-1.032664, -0.242746, 2.757368>, 
      <-1.116167, -0.372340, 1.683604>, <-1.101590, -0.395061, 2.005971>, <-1.039610, -0.334176, 2.434575>, <-1.020253, -0.343090, 2.757368>, 
      <-0.893763, -0.395362, 1.683604>, <-0.893763, -0.395066, 2.005799>, <-0.863408, -0.410640, 2.435190>, <-0.863408, -0.407260, 2.757368>, 
      <-0.795021, -0.459958, 1.683604>, <-0.795021, -0.459663, 2.005799>, <-0.795020, -0.485112, 2.435190>, <-0.795020, -0.481732, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.891424, 0.307422, 1.683604>, <-0.902829, 0.309549, 2.005536>, <-0.893259, 0.323529, 2.435312>, <-0.893708, 0.316164, 2.757368>, 
      <-0.996272, 0.156880, 1.683604>, <-1.007677, 0.159007, 2.005536>, <-0.960778, 0.164491, 2.435312>, <-0.961227, 0.157126, 2.757368>, 
      <-1.153742, -0.073241, 1.683604>, <-1.139165, -0.095962, 2.005971>, <-1.073229, -0.062361, 2.434575>, <-1.053872, -0.071275, 2.757368>, 
      <-1.130875, -0.255266, 1.683604>, <-1.116298, -0.277987, 2.005971>, <-1.052021, -0.233832, 2.434575>, <-1.032664, -0.242746, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.891424, 0.307422, 1.683604>, <-0.805230, 0.431180, 1.683604>, <-0.638978, 0.556499, 1.683604>, <-0.510496, 0.635478, 1.683604>, 
      <-0.902829, 0.309549, 2.005536>, <-0.816635, 0.433307, 2.005536>, <-0.652554, 0.598593, 2.008739>, <-0.524071, 0.677572, 2.008739>, 
      <-0.893259, 0.323529, 2.435312>, <-0.822114, 0.491109, 2.435312>, <-0.722420, 0.677908, 2.432034>, <-0.579399, 0.790557, 2.432034>, 
      <-0.893708, 0.316164, 2.757368>, <-0.822563, 0.483744, 2.757368>, <-0.718919, 0.720498, 2.757368>, <-0.575899, 0.833148, 2.757368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.042980, 0.752585, 1.230120>, <0.037919, 0.787416, 1.367007>, <0.039608, 0.852239, 1.545082>, <0.040539, 0.880306, 1.683604>, 
      <-0.127192, 0.755777, 1.230120>, <-0.132254, 0.790608, 1.367007>, <-0.141156, 0.845425, 1.545082>, <-0.140226, 0.873492, 1.683604>, 
      <-0.360259, 0.712257, 1.230120>, <-0.365952, 0.711172, 1.366043>, <-0.350762, 0.712755, 1.548799>, <-0.356391, 0.730208, 1.683604>, 
      <-0.512132, 0.635422, 1.230120>, <-0.517825, 0.634337, 1.366043>, <-0.504868, 0.618026, 1.548799>, <-0.510496, 0.635478, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.688188, 0.612905, 1.230120>, <0.704981, 0.623066, 1.368567>, <0.755643, 0.670053, 1.545121>, <0.769373, 0.683725, 1.683604>, 
      <0.509232, 0.697741, 1.230120>, <0.526025, 0.707902, 1.368567>, <0.556369, 0.777644, 1.545121>, <0.570099, 0.791316, 1.683604>, 
      <0.240992, 0.748870, 1.230120>, <0.235931, 0.783701, 1.367007>, <0.265911, 0.860770, 1.545082>, <0.266842, 0.888837, 1.683604>, 
      <0.042980, 0.752585, 1.230120>, <0.037919, 0.787416, 1.367007>, <0.039608, 0.852239, 1.545082>, <0.040539, 0.880306, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.035115, 0.282254, 1.230120>, <1.068001, 0.292027, 1.365352>, <1.114756, 0.284935, 1.546076>, <1.138057, 0.287738, 1.683604>, 
      <0.950440, 0.398453, 1.230120>, <0.983326, 0.408226, 1.365352>, <1.031137, 0.424054, 1.546076>, <1.054438, 0.426856, 1.683604>, 
      <0.818106, 0.551316, 1.230120>, <0.834899, 0.561477, 1.368567>, <0.898469, 0.592939, 1.545121>, <0.912200, 0.606611, 1.683604>, 
      <0.688188, 0.612905, 1.230120>, <0.704981, 0.623066, 1.368567>, <0.755643, 0.670053, 1.545121>, <0.769373, 0.683725, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.283681, -0.204286, 1.230120>, <1.315133, -0.221392, 1.361750>, <1.299727, -0.217760, 1.547850>, <1.312836, -0.220440, 1.683604>, 
      <1.233648, -0.048202, 1.230120>, <1.265100, -0.065308, 1.361750>, <1.276339, -0.058247, 1.547850>, <1.289447, -0.060927, 1.683604>, 
      <1.131645, 0.149787, 1.230120>, <1.164530, 0.159560, 1.365352>, <1.197811, 0.146757, 1.546076>, <1.221111, 0.149560, 1.683604>, 
      <1.035115, 0.282254, 1.230120>, <1.068001, 0.292027, 1.365352>, <1.114756, 0.284935, 1.546076>, <1.138057, 0.287738, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.258820, -0.415628, 1.230120>, <1.278373, -0.388433, 1.366110>, <1.225979, -0.296370, 1.544196>, <1.225672, -0.309802, 1.683604>, 
      <1.299168, -0.366155, 1.230120>, <1.318721, -0.338959, 1.366110>, <1.251137, -0.268628, 1.544196>, <1.250830, -0.282061, 1.683604>, 
      <1.303168, -0.265079, 1.230120>, <1.334620, -0.282185, 1.361750>, <1.305160, -0.254813, 1.547850>, <1.318269, -0.257494, 1.683604>, 
      <1.283681, -0.204286, 1.230120>, <1.315133, -0.221392, 1.361750>, <1.299727, -0.217760, 1.547850>, <1.312836, -0.220440, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.821034, -0.771575, 1.230120>, <0.827327, -0.742237, 1.363040>, <0.801637, -0.766202, 1.548821>, <0.799813, -0.786157, 1.683604>, 
      <0.969171, -0.689677, 1.230120>, <0.975464, -0.660339, 1.363040>, <0.965588, -0.666883, 1.548821>, <0.963764, -0.686838, 1.683604>, 
      <1.151840, -0.546805, 1.230120>, <1.171393, -0.519609, 1.366110>, <1.097210, -0.438366, 1.544196>, <1.096903, -0.451798, 1.683604>, 
      <1.258820, -0.415628, 1.230120>, <1.278373, -0.388433, 1.366110>, <1.225979, -0.296370, 1.544196>, <1.225672, -0.309802, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.187359, -1.007990, 1.230120>, <0.186832, -0.978276, 1.364418>, <0.184524, -0.928202, 1.546606>, <0.184574, -0.940482, 1.683604>, 
      <0.390090, -1.016322, 1.230120>, <0.389563, -0.986608, 1.364418>, <0.374709, -0.934514, 1.546606>, <0.374759, -0.946794, 1.683604>, 
      <0.643463, -0.869746, 1.230120>, <0.649755, -0.840409, 1.363040>, <0.638881, -0.864796, 1.548821>, <0.637058, -0.884752, 1.683604>, 
      <0.821034, -0.771575, 1.230120>, <0.827327, -0.742237, 1.363040>, <0.801637, -0.766202, 1.548821>, <0.799813, -0.786157, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.378793, -0.722264, 1.230120>, <-0.386475, -0.691380, 1.362599>, <-0.379149, -0.726539, 1.548906>, <-0.379165, -0.747029, 1.683604>, 
      <-0.210991, -0.811916, 1.230120>, <-0.218673, -0.781032, 1.362599>, <-0.218620, -0.805283, 1.548906>, <-0.218636, -0.825774, 1.683604>, 
      <-0.002730, -1.000178, 1.230120>, <-0.003258, -0.970464, 1.364418>, <0.005820, -0.922271, 1.546606>, <0.005870, -0.934551, 1.683604>, 
      <0.187359, -1.007990, 1.230120>, <0.186832, -0.978276, 1.364418>, <0.184524, -0.928202, 1.546606>, <0.184574, -0.940482, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.795021, -0.483131, 1.230120>, <-0.814530, -0.458709, 1.362708>, <-0.795021, -0.460083, 1.547381>, <-0.795021, -0.459958, 1.683604>, 
      <-0.683236, -0.573922, 1.230120>, <-0.702745, -0.549500, 1.362708>, <-0.668161, -0.543074, 1.547381>, <-0.668161, -0.542949, 1.683604>, 
      <-0.505811, -0.654402, 1.230120>, <-0.513492, -0.623517, 1.362599>, <-0.515251, -0.659776, 1.548906>, <-0.515267, -0.680266, 1.683604>, 
      <-0.378793, -0.722264, 1.230120>, <-0.386475, -0.691380, 1.362599>, <-0.379149, -0.726539, 1.548906>, <-0.379165, -0.747029, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.101724, -0.135105, 1.230120>, <-1.138244, -0.154288, 1.364963>, <-1.137229, -0.245362, 1.543084>, <-1.130875, -0.255266, 1.683604>, 
      <-1.093875, -0.274049, 1.230120>, <-1.130395, -0.293232, 1.364963>, <-1.122521, -0.362436, 1.543084>, <-1.116167, -0.372340, 1.683604>, 
      <-0.903045, -0.395394, 1.230120>, <-0.922554, -0.370972, 1.362708>, <-0.893763, -0.395486, 1.547381>, <-0.893763, -0.395362, 1.683604>, 
      <-0.795021, -0.483131, 1.230120>, <-0.814530, -0.458709, 1.362708>, <-0.795021, -0.460083, 1.547381>, <-0.795021, -0.459958, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.839603, 0.306074, 1.230120>, <-0.863726, 0.298498, 1.364696>, <-0.886576, 0.306518, 1.546762>, <-0.891424, 0.307422, 1.683604>, 
      <-0.933158, 0.183809, 1.230120>, <-0.957281, 0.176233, 1.364696>, <-0.991424, 0.155976, 1.546762>, <-0.996272, 0.156880, 1.683604>, 
      <-1.110407, 0.018602, 1.230120>, <-1.146926, -0.000581, 1.364963>, <-1.160096, -0.063337, 1.543084>, <-1.153742, -0.073241, 1.683604>, 
      <-1.101724, -0.135105, 1.230120>, <-1.138244, -0.154288, 1.364963>, <-1.137229, -0.245362, 1.543084>, <-1.130875, -0.255266, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.839603, 0.306074, 1.230120>, <-0.754932, 0.416729, 1.230120>, <-0.636460, 0.572523, 1.230120>, <-0.512132, 0.635422, 1.230120>, 
      <-0.863726, 0.298498, 1.364696>, <-0.779055, 0.409153, 1.364696>, <-0.642153, 0.571438, 1.366043>, <-0.517825, 0.634337, 1.366043>, 
      <-0.886576, 0.306518, 1.546762>, <-0.800382, 0.430276, 1.546762>, <-0.633350, 0.539046, 1.548799>, <-0.504868, 0.618026, 1.548799>, 
      <-0.891424, 0.307422, 1.683604>, <-0.805230, 0.431180, 1.683604>, <-0.638978, 0.556499, 1.683604>, <-0.510496, 0.635478, 1.683604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.067742, 0.693088, 0.947819>, <0.060313, 0.710937, 1.032509>, <0.046091, 0.731178, 1.145987>, <0.042980, 0.752585, 1.230120>, 
      <-0.097208, 0.694742, 0.947819>, <-0.104636, 0.712591, 1.032509>, <-0.124082, 0.734370, 1.145987>, <-0.127192, 0.755777, 1.230120>, 
      <-0.327381, 0.704725, 0.947819>, <-0.337116, 0.702946, 1.032509>, <-0.356691, 0.712936, 1.144931>, <-0.360259, 0.712257, 1.230120>, 
      <-0.479679, 0.641350, 0.947819>, <-0.489415, 0.639572, 1.032509>, <-0.508564, 0.636102, 1.144931>, <-0.512132, 0.635422, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.680129, 0.629722, 0.947819>, <0.682547, 0.624677, 1.032509>, <0.677995, 0.606737, 1.146085>, <0.688188, 0.612905, 1.230120>, 
      <0.515887, 0.714207, 0.947819>, <0.518305, 0.709162, 1.032509>, <0.499039, 0.691573, 1.146085>, <0.509232, 0.697741, 1.230120>, 
      <0.252430, 0.691236, 0.947819>, <0.245001, 0.709086, 1.032509>, <0.244102, 0.727463, 1.145987>, <0.240992, 0.748870, 1.230120>, 
      <0.067742, 0.693088, 0.947819>, <0.060313, 0.710937, 1.032509>, <0.046091, 0.731178, 1.145987>, <0.042980, 0.752585, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.959130, 0.234565, 0.947819>, <0.981926, 0.248872, 1.032509>, <1.014169, 0.276029, 1.143985>, <1.035115, 0.282254, 1.230120>, 
      <0.883963, 0.358699, 0.947819>, <0.906759, 0.373005, 1.032509>, <0.929494, 0.392228, 1.143985>, <0.950440, 0.398453, 1.230120>, 
      <0.809175, 0.563342, 0.947819>, <0.811593, 0.558297, 1.032509>, <0.807914, 0.545148, 1.146085>, <0.818106, 0.551316, 1.230120>, 
      <0.680129, 0.629722, 0.947819>, <0.682547, 0.624677, 1.032509>, <0.677995, 0.606737, 1.146085>, <0.688188, 0.612905, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.137028, -0.124822, 0.947819>, <1.181024, -0.148661, 1.032509>, <1.261001, -0.191951, 1.135200>, <1.283681, -0.204286, 1.230120>, 
      <1.109789, -0.007644, 0.947819>, <1.153785, -0.031483, 1.032509>, <1.210968, -0.035867, 1.135200>, <1.233648, -0.048202, 1.230120>, 
      <1.021443, 0.131659, 0.947819>, <1.044238, 0.145965, 1.032509>, <1.110699, 0.143562, 1.143985>, <1.131645, 0.149787, 1.230120>, 
      <0.959130, 0.234565, 0.947819>, <0.981926, 0.248872, 1.032509>, <1.014169, 0.276029, 1.143985>, <1.035115, 0.282254, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.119879, -0.456946, 0.947819>, <1.161561, -0.444551, 1.032509>, <1.245529, -0.434114, 1.137680>, <1.258820, -0.415628, 1.230120>, 
      <1.160947, -0.366020, 0.947819>, <1.202629, -0.353625, 1.032509>, <1.285876, -0.384641, 1.137680>, <1.299168, -0.366155, 1.230120>, 
      <1.159618, -0.222001, 0.947819>, <1.203614, -0.245840, 1.032509>, <1.280488, -0.252744, 1.135200>, <1.303168, -0.265079, 1.230120>, 
      <1.137028, -0.124822, 0.947819>, <1.181024, -0.148661, 1.032509>, <1.261001, -0.191951, 1.135200>, <1.283681, -0.204286, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.764980, -0.948556, 0.947819>, <0.781796, -0.895462, 1.032509>, <0.816353, -0.793398, 1.131246>, <0.821034, -0.771575, 1.230120>, 
      <0.914475, -0.844930, 0.947819>, <0.931291, -0.791836, 1.032509>, <0.964490, -0.711500, 1.131246>, <0.969171, -0.689677, 1.230120>, 
      <1.045005, -0.622720, 0.947819>, <1.086688, -0.610325, 1.032509>, <1.138549, -0.565291, 1.137680>, <1.151840, -0.546805, 1.230120>, 
      <1.119879, -0.456946, 0.947819>, <1.161561, -0.444551, 1.032509>, <1.245529, -0.434114, 1.137680>, <1.258820, -0.415628, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.187461, -1.103275, 0.947819>, <0.187430, -1.074690, 1.032509>, <0.187701, -1.027299, 1.142847>, <0.187359, -1.007990, 1.230120>, 
      <0.366760, -1.108157, 0.947819>, <0.366729, -1.079572, 1.032509>, <0.390432, -1.035631, 1.142847>, <0.390090, -1.016322, 1.230120>, 
      <0.617567, -1.050739, 0.947819>, <0.634383, -0.997645, 1.032509>, <0.638782, -0.891569, 1.131246>, <0.643463, -0.869746, 1.230120>, 
      <0.764980, -0.948556, 0.947819>, <0.781796, -0.895462, 1.032509>, <0.816353, -0.793398, 1.131246>, <0.821034, -0.771575, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.336501, -0.918561, 0.947819>, <-0.349189, -0.859672, 1.032509>, <-0.372933, -0.745823, 1.129066>, <-0.378793, -0.722264, 1.230120>, 
      <-0.192379, -1.002274, 0.947819>, <-0.205067, -0.943385, 1.032509>, <-0.205131, -0.835475, 1.129066>, <-0.210991, -0.811916, 1.230120>, 
      <0.020853, -1.098738, 0.947819>, <0.020822, -1.070153, 1.032509>, <-0.002388, -1.019487, 1.142847>, <-0.002730, -1.000178, 1.230120>, 
      <0.187461, -1.103275, 0.947819>, <0.187430, -1.074690, 1.032509>, <0.187701, -1.027299, 1.142847>, <0.187359, -1.007990, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.686758, -0.595485, 0.947819>, <-0.719237, -0.561779, 1.032509>, <-0.781163, -0.500479, 1.135937>, <-0.795021, -0.483131, 1.230120>, 
      <-0.599197, -0.708482, 0.947819>, <-0.631676, -0.674775, 1.032509>, <-0.669378, -0.591270, 1.135937>, <-0.683236, -0.573922, 1.230120>, 
      <-0.460113, -0.846761, 0.947819>, <-0.472801, -0.787872, 1.032509>, <-0.499951, -0.677960, 1.129066>, <-0.505811, -0.654402, 1.230120>, 
      <-0.336501, -0.918561, 0.947819>, <-0.349189, -0.859672, 1.032509>, <-0.372933, -0.745823, 1.129066>, <-0.378793, -0.722264, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.931602, -0.150592, 0.947819>, <-0.982639, -0.145946, 1.032509>, <-1.076088, -0.121639, 1.135462>, <-1.101724, -0.135105, 1.230120>, 
      <-0.919896, -0.302487, 0.947819>, <-0.970933, -0.297841, 1.032509>, <-1.068239, -0.260583, 1.135462>, <-1.093875, -0.274049, 1.230120>, 
      <-0.780073, -0.475063, 0.947819>, <-0.812552, -0.441357, 1.032509>, <-0.889187, -0.412742, 1.135937>, <-0.903045, -0.395394, 1.230120>, 
      <-0.686758, -0.595485, 0.947819>, <-0.719237, -0.561779, 1.032509>, <-0.781163, -0.500479, 1.135937>, <-0.795021, -0.483131, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.759532, 0.348841, 0.947819>, <-0.783553, 0.336011, 1.032509>, <-0.823931, 0.310996, 1.142689>, <-0.839603, 0.306074, 1.230120>, 
      <-0.838076, 0.211202, 0.947819>, <-0.862097, 0.198372, 1.032509>, <-0.917485, 0.188731, 1.142689>, <-0.933158, 0.183809, 1.230120>, 
      <-0.943778, 0.007413, 0.947819>, <-0.994815, 0.012059, 1.032509>, <-1.084770, 0.032068, 1.135462>, <-1.110407, 0.018602, 1.230120>, 
      <-0.931602, -0.150592, 0.947819>, <-0.982639, -0.145946, 1.032509>, <-1.076088, -0.121639, 1.135462>, <-1.101724, -0.135105, 1.230120>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.759532, 0.348841, 0.947819>, <-0.699340, 0.454321, 0.947819>, <-0.591805, 0.594692, 0.947819>, <-0.479679, 0.641350, 0.947819>, 
      <-0.783553, 0.336011, 1.032509>, <-0.723361, 0.441491, 1.032509>, <-0.601541, 0.592914, 1.032509>, <-0.489415, 0.639572, 1.032509>, 
      <-0.823931, 0.310996, 1.142689>, <-0.739260, 0.421651, 1.142689>, <-0.632892, 0.573203, 1.144931>, <-0.508564, 0.636102, 1.144931>, 
      <-0.839603, 0.306074, 1.230120>, <-0.754932, 0.416729, 1.230120>, <-0.636460, 0.572523, 1.230120>, <-0.512132, 0.635422, 1.230120>
    }
  }
  texture {
    Shirt
  }
}
#declare sPatchObj7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.694721, 0.657382, -4.894626>, <-0.699817, 0.628470, -4.584057>, <-0.713666, 0.579362, -4.170803>, <-0.711709, 0.561007, -3.859396>, 
      <-0.384159, 0.650022, -4.909020>, <-0.389255, 0.621110, -4.598451>, <-0.444543, 0.592997, -4.130409>, <-0.442587, 0.574642, -3.819002>, 
      <-0.092085, 0.123906, -4.964913>, <-0.132380, 0.117093, -4.623446>, <-0.221616, 0.069823, -4.169680>, <-0.228526, 0.062712, -3.825920>, 
      <-0.097826, -0.187015, -4.967213>, <-0.138121, -0.193828, -4.625746>, <-0.225232, -0.202614, -4.172751>, <-0.232142, -0.209725, -3.828990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.244635, -0.159838, -4.914059>, <-1.227544, -0.189327, -4.631564>, <-1.195578, -0.243944, -4.256488>, <-1.187665, -0.258136, -3.972409>, 
      <-1.239179, 0.135665, -4.911873>, <-1.222088, 0.106176, -4.629378>, <-1.191780, 0.042242, -4.253263>, <-1.183867, 0.028050, -3.969184>, 
      <-0.989883, 0.664377, -4.880946>, <-0.994980, 0.635464, -4.570376>, <-0.996370, 0.565039, -4.213235>, <-0.994413, 0.546684, -3.901828>, 
      <-0.694721, 0.657382, -4.894626>, <-0.699817, 0.628470, -4.584057>, <-0.713666, 0.579362, -4.170803>, <-0.711709, 0.561007, -3.859396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.719472, -0.683047, -4.904541>, <-0.722597, -0.720780, -4.595629>, <-0.731615, -0.774149, -4.184116>, <-0.729890, -0.808825, -3.874834>, 
      <-0.941583, -0.677783, -4.894246>, <-0.944709, -0.715517, -4.585334>, <-0.945764, -0.784999, -4.216258>, <-0.944038, -0.819675, -3.906976>, 
      <-1.248741, -0.382206, -4.915704>, <-1.231650, -0.411695, -4.633209>, <-1.198455, -0.460730, -4.258931>, <-1.190542, -0.474922, -3.974852>, 
      <-1.244635, -0.159838, -4.914059>, <-1.227544, -0.189327, -4.631564>, <-1.195578, -0.243944, -4.256488>, <-1.187665, -0.258136, -3.972409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.719472, -0.683047, -4.904541>, <-0.480468, -0.688711, -4.915619>, <-0.102244, -0.426295, -4.968983>, <-0.097826, -0.187015, -4.967213>, 
      <-0.722597, -0.720780, -4.595629>, <-0.483593, -0.726444, -4.606707>, <-0.142539, -0.433108, -4.627516>, <-0.138121, -0.193828, -4.625746>, 
      <-0.731615, -0.774149, -4.184116>, <-0.500426, -0.762436, -4.149415>, <-0.228338, -0.436651, -4.175388>, <-0.225232, -0.202614, -4.172751>, 
      <-0.729890, -0.808825, -3.874834>, <-0.498701, -0.797112, -3.840134>, <-0.235248, -0.443762, -3.831628>, <-0.232142, -0.209725, -3.828990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.866595, 0.654874, -4.922553>, <0.553560, 0.652608, -4.914092>, <0.204964, 0.158769, -4.921072>, <0.207062, -0.154175, -4.932438>, 
      <0.875862, 0.634084, -4.562845>, <0.562827, 0.631818, -4.554383>, <0.235691, 0.142923, -4.562534>, <0.237789, -0.170021, -4.573900>, 
      <0.888217, 0.606363, -4.083234>, <0.592462, 0.614644, -4.094594>, <0.279757, 0.104938, -4.096568>, <0.278758, -0.191149, -4.095850>, 
      <0.897484, 0.585573, -3.723526>, <0.601729, 0.593854, -3.734886>, <0.310484, 0.089092, -3.738030>, <0.309485, -0.206995, -3.737313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.415022, -0.145431, -4.965090>, <1.413070, 0.145706, -4.954516>, <1.157816, 0.656982, -4.930425>, <0.866595, 0.654874, -4.922553>, 
      <1.391841, -0.172538, -4.584908>, <1.389889, 0.118599, -4.574334>, <1.167083, 0.636192, -4.570717>, <0.875862, 0.634084, -4.562845>, 
      <1.360932, -0.208679, -4.077999>, <1.361875, 0.070999, -4.078677>, <1.167583, 0.598541, -4.072504>, <0.888217, 0.606363, -4.083234>, 
      <1.337750, -0.235786, -3.697817>, <1.338693, 0.043892, -3.698495>, <1.176849, 0.577751, -3.712796>, <0.897484, 0.585573, -3.723526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.875619, -0.691244, -4.971444>, <1.105750, -0.689578, -4.977665>, <1.416564, -0.375495, -4.973446>, <1.415022, -0.145431, -4.965090>, 
      <0.880785, -0.721258, -4.596068>, <1.110916, -0.719592, -4.602289>, <1.393383, -0.402602, -4.593264>, <1.391841, -0.172538, -4.584908>, 
      <0.887674, -0.761277, -4.095566>, <1.101051, -0.767251, -4.087370>, <1.360211, -0.422296, -4.077481>, <1.360932, -0.208679, -4.077999>, 
      <0.892840, -0.791291, -3.720190>, <1.106218, -0.797265, -3.711994>, <1.337030, -0.449403, -3.697300>, <1.337750, -0.235786, -3.697817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.875619, -0.691244, -4.971444>, <0.880785, -0.721258, -4.596068>, <0.887674, -0.761277, -4.095566>, <0.892840, -0.791291, -3.720190>, 
      <0.618185, -0.693107, -4.964486>, <0.623352, -0.723122, -4.589110>, <0.640204, -0.754348, -4.105072>, <0.645370, -0.784362, -3.729696>, 
      <0.208787, -0.411534, -4.941785>, <0.239514, -0.427380, -4.583248>, <0.277923, -0.438896, -4.095250>, <0.308649, -0.454742, -3.736713>, 
      <0.207062, -0.154175, -4.932438>, <0.237789, -0.170021, -4.573900>, <0.278758, -0.191149, -4.095850>, <0.309485, -0.206995, -3.737313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.866595, 0.654874, -4.922553>, <0.563472, 0.653895, -4.905820>, <0.253121, 0.152197, -4.889949>, <0.255155, -0.151183, -4.900968>, 
      <0.875862, 0.634084, -4.562845>, <0.572738, 0.633105, -4.546112>, <0.269420, 0.135453, -4.540852>, <0.271454, -0.167927, -4.551871>, 
      <0.898353, 0.601281, -4.083610>, <0.602598, 0.609562, -4.094970>, <0.306730, 0.111891, -4.087144>, <0.305731, -0.184195, -4.086427>, 
      <0.897484, 0.585573, -3.723526>, <0.601729, 0.593854, -3.734886>, <0.310484, 0.089092, -3.738030>, <0.309485, -0.206995, -3.737313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.453589, -0.147314, -4.967125>, <1.451589, 0.150987, -4.956291>, <1.164644, 0.655836, -4.939006>, <0.866595, 0.654874, -4.922553>, 
      <1.418837, -0.173856, -4.586332>, <1.416838, 0.124445, -4.575498>, <1.173911, 0.635046, -4.579298>, <0.875862, 0.634084, -4.562845>, 
      <1.345656, -0.211733, -4.080274>, <1.346599, 0.067945, -4.080952>, <1.177718, 0.593459, -4.072880>, <0.898353, 0.601281, -4.083610>, 
      <1.337750, -0.235786, -3.697817>, <1.338693, 0.043892, -3.698495>, <1.176849, 0.577751, -3.712796>, <0.897484, 0.585573, -3.723526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.875619, -0.691244, -4.971444>, <1.113360, -0.690477, -4.984568>, <1.455184, -0.385256, -4.975767>, <1.453589, -0.147314, -4.967125>, 
      <0.880785, -0.721258, -4.596068>, <1.118526, -0.720491, -4.609192>, <1.420432, -0.411797, -4.594974>, <1.418837, -0.173856, -4.586332>, 
      <0.893794, -0.755800, -4.095122>, <1.107172, -0.761774, -4.086926>, <1.344935, -0.425350, -4.079757>, <1.345656, -0.211733, -4.080274>, 
      <0.892840, -0.791291, -3.720190>, <1.106218, -0.797265, -3.711994>, <1.337030, -0.449403, -3.697300>, <1.337750, -0.235786, -3.697817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.875619, -0.691244, -4.971444>, <0.880785, -0.721258, -4.596068>, <0.893794, -0.755800, -4.095122>, <0.892840, -0.791291, -3.720190>, 
      <0.628318, -0.692042, -4.957792>, <0.633484, -0.722056, -4.582416>, <0.646324, -0.748871, -4.104628>, <0.645370, -0.784362, -3.729696>, 
      <0.256814, -0.398693, -4.909958>, <0.273113, -0.415437, -4.560861>, <0.304895, -0.431943, -4.085826>, <0.308649, -0.454742, -3.736713>, 
      <0.255155, -0.151183, -4.900968>, <0.271454, -0.167927, -4.551871>, <0.305731, -0.184195, -4.086427>, <0.309485, -0.206995, -3.737313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.682658, 0.544215, -2.974687>, <-0.399091, 0.552178, -2.976680>, <-0.133176, 0.054881, -2.946347>, <-0.138336, -0.228701, -2.952050>, 
      <-0.688529, 0.524529, -3.239495>, <-0.404961, 0.532492, -3.241488>, <-0.162189, 0.056025, -3.209394>, <-0.167349, -0.227557, -3.215096>, 
      <-0.710043, 0.545379, -3.594258>, <-0.440921, 0.559014, -3.553864>, <-0.233844, 0.057240, -3.561386>, <-0.237460, -0.215197, -3.564456>, 
      <-0.711709, 0.561007, -3.859396>, <-0.442587, 0.574642, -3.819002>, <-0.228526, 0.062712, -3.825920>, <-0.232142, -0.209725, -3.828990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.189778, -0.258226, -2.944662>, <-1.184595, 0.026588, -2.938935>, <-0.967457, 0.536218, -2.972686>, <-0.682658, 0.544215, -2.974687>, 
      <-1.180853, -0.263870, -3.252806>, <-1.175671, 0.020944, -3.247078>, <-0.973328, 0.516532, -3.237494>, <-0.688529, 0.524529, -3.239495>, 
      <-1.179091, -0.273514, -3.664588>, <-1.175292, 0.012672, -3.661362>, <-0.992747, 0.531056, -3.636690>, <-0.710043, 0.545379, -3.594258>, 
      <-1.187665, -0.258136, -3.972409>, <-1.183867, 0.028050, -3.969184>, <-0.994413, 0.546684, -3.901828>, <-0.711709, 0.561007, -3.859396>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.708868, -0.896169, -3.003653>, <-0.949091, -0.902915, -3.001965>, <-1.194149, -0.498461, -2.949493>, <-1.189778, -0.258226, -2.944662>, 
      <-0.705851, -0.867037, -3.264756>, <-0.946074, -0.873783, -3.263068>, <-1.185225, -0.504105, -3.257637>, <-1.180853, -0.263870, -3.252806>, 
      <-0.728433, -0.838099, -3.613734>, <-0.942582, -0.848948, -3.645876>, <-1.181968, -0.490300, -3.667030>, <-1.179091, -0.273514, -3.664588>, 
      <-0.729890, -0.808825, -3.874834>, <-0.944038, -0.819675, -3.906976>, <-1.190542, -0.474922, -3.974852>, <-1.187665, -0.258136, -3.972409>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.708868, -0.896169, -3.003653>, <-0.705851, -0.867037, -3.264756>, <-0.728433, -0.838099, -3.613734>, <-0.729890, -0.808825, -3.874834>, 
      <-0.445101, -0.888762, -3.005506>, <-0.442084, -0.859630, -3.266609>, <-0.497244, -0.826386, -3.579033>, <-0.498701, -0.797112, -3.840134>, 
      <-0.143136, -0.492482, -2.957355>, <-0.172149, -0.491337, -3.220401>, <-0.240566, -0.449234, -3.567094>, <-0.235248, -0.443762, -3.831628>, 
      <-0.138336, -0.228701, -2.952050>, <-0.167349, -0.227557, -3.215096>, <-0.237460, -0.215197, -3.564456>, <-0.232142, -0.209725, -3.828990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.861475, 0.562284, -2.800058>, <0.870198, 0.552273, -3.077079>, <0.896816, 0.573486, -3.446451>, <0.897484, 0.585573, -3.723526>, 
      <0.553087, 0.562617, -2.825140>, <0.561810, 0.552605, -3.102161>, <0.601061, 0.581767, -3.457811>, <0.601729, 0.593854, -3.734886>, 
      <0.274934, 0.026901, -2.886640>, <0.290361, 0.032456, -3.141323>, <0.313222, 0.072461, -3.483377>, <0.310484, 0.089092, -3.738030>, 
      <0.276773, -0.282475, -2.890598>, <0.292201, -0.276919, -3.145281>, <0.312223, -0.223626, -3.482660>, <0.309485, -0.206995, -3.737313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.408761, -0.283697, -2.798530>, <1.404432, -0.280770, -3.069487>, <1.332160, -0.252792, -3.427402>, <1.337750, -0.235786, -3.697817>, 
      <1.406964, 0.018545, -2.794663>, <1.402634, 0.021473, -3.065620>, <1.333103, 0.026886, -3.428079>, <1.338693, 0.043892, -3.698495>, 
      <1.162753, 0.561959, -2.775554>, <1.171475, 0.551947, -3.052575>, <1.176181, 0.565664, -3.435721>, <1.176849, 0.577751, -3.712796>, 
      <0.861475, 0.562284, -2.800058>, <0.870198, 0.552273, -3.077079>, <0.896816, 0.573486, -3.446451>, <0.897484, 0.585573, -3.723526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.870140, -0.895023, -2.818702>, <0.875875, -0.852588, -3.087630>, <0.892150, -0.816954, -3.449087>, <0.892840, -0.791291, -3.720190>, 
      <1.113838, -0.895286, -2.798881>, <1.119573, -0.852851, -3.067810>, <1.105528, -0.822928, -3.440891>, <1.106218, -0.797265, -3.711994>, 
      <1.410215, -0.528175, -2.801658>, <1.405885, -0.525248, -3.072615>, <1.331440, -0.466409, -3.426884>, <1.337030, -0.449403, -3.697300>, 
      <1.408761, -0.283697, -2.798530>, <1.404432, -0.280770, -3.069487>, <1.332160, -0.252792, -3.427402>, <1.337750, -0.235786, -3.697817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.870140, -0.895023, -2.818702>, <0.614232, -0.894747, -2.839516>, <0.278299, -0.539203, -2.893883>, <0.276773, -0.282475, -2.890598>, 
      <0.875875, -0.852588, -3.087630>, <0.619967, -0.852312, -3.108444>, <0.293728, -0.533647, -3.148566>, <0.292201, -0.276919, -3.145281>, 
      <0.892150, -0.816954, -3.449087>, <0.644680, -0.810025, -3.458592>, <0.311388, -0.471373, -3.482059>, <0.312223, -0.223626, -3.482660>, 
      <0.892840, -0.791291, -3.720190>, <0.645370, -0.784362, -3.729696>, <0.308649, -0.454742, -3.736713>, <0.309485, -0.206995, -3.737313>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.670889, 0.697884, -2.018150>, <-0.336529, 0.699091, -2.029331>, <-0.018464, 0.116313, -2.049572>, <-0.034230, -0.217531, -2.034633>, 
      <-0.670541, 0.667607, -2.307231>, <-0.336181, 0.668815, -2.318412>, <-0.036686, 0.125104, -2.325844>, <-0.052452, -0.208740, -2.310905>, 
      <-0.676233, 0.565758, -2.684896>, <-0.392666, 0.573721, -2.686888>, <-0.102807, 0.053683, -2.671008>, <-0.107967, -0.229899, -2.676711>, 
      <-0.682658, 0.544215, -2.974687>, <-0.399091, 0.552178, -2.976680>, <-0.133176, 0.054881, -2.946347>, <-0.138336, -0.228701, -2.952050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.244961, -0.221903, -1.994145>, <-1.229629, 0.102761, -2.008673>, <-0.996055, 0.696710, -2.007276>, <-0.670889, 0.697884, -2.018150>, 
      <-1.239829, -0.216442, -2.279890>, <-1.224497, 0.108222, -2.294418>, <-0.995708, 0.666433, -2.296357>, <-0.670541, 0.667607, -2.307231>, 
      <-1.198052, -0.252994, -2.658987>, <-1.192869, 0.031820, -2.653259>, <-0.961033, 0.557761, -2.682894>, <-0.676233, 0.565758, -2.684896>, 
      <-1.189778, -0.258226, -2.944662>, <-1.184595, 0.026588, -2.938935>, <-0.967457, 0.536218, -2.972686>, <-0.682658, 0.544215, -2.974687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.752231, -1.024581, -1.941072>, <-1.035073, -1.025602, -1.931613>, <-1.258297, -0.504308, -1.981508>, <-1.244961, -0.221903, -1.994145>, 
      <-0.754078, -0.999405, -2.261436>, <-1.036920, -1.000427, -2.251977>, <-1.253165, -0.498847, -2.267252>, <-1.239829, -0.216442, -2.279890>, 
      <-0.712558, -0.931800, -2.684299>, <-0.952780, -0.938546, -2.682611>, <-1.202423, -0.493229, -2.663818>, <-1.198052, -0.252994, -2.658987>, 
      <-0.708868, -0.896169, -3.003653>, <-0.949091, -0.902915, -3.001965>, <-1.194149, -0.498461, -2.949493>, <-1.189778, -0.258226, -2.944662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.752231, -1.024581, -1.941072>, <-0.754078, -0.999405, -2.261436>, <-0.712558, -0.931800, -2.684299>, <-0.708868, -0.896169, -3.003653>, 
      <-0.427138, -1.023407, -1.951943>, <-0.428986, -0.998231, -2.272307>, <-0.448790, -0.924394, -2.686152>, <-0.445101, -0.888762, -3.005506>, 
      <-0.049558, -0.542121, -2.020108>, <-0.067780, -0.533330, -2.296380>, <-0.112767, -0.493680, -2.682015>, <-0.143136, -0.492482, -2.957355>, 
      <-0.034230, -0.217531, -2.034633>, <-0.052452, -0.208740, -2.310905>, <-0.107967, -0.229899, -2.676711>, <-0.138336, -0.228701, -2.952050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.844846, 0.645989, -2.051795>, <0.839749, 0.627757, -2.276935>, <0.854369, 0.570440, -2.574383>, <0.861475, 0.562284, -2.800058>, 
      <0.518751, 0.649403, -2.086862>, <0.513654, 0.631171, -2.312002>, <0.545981, 0.570773, -2.599465>, <0.553087, 0.562617, -2.825140>, 
      <0.210329, 0.085788, -2.148058>, <0.224531, 0.083133, -2.375370>, <0.261164, 0.021942, -2.659341>, <0.274934, 0.026901, -2.886640>, 
      <0.212432, -0.241946, -2.135182>, <0.226634, -0.244601, -2.362493>, <0.263004, -0.287434, -2.663299>, <0.276773, -0.282475, -2.890598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.364699, -0.254008, -2.011271>, <1.369226, -0.277383, -2.246785>, <1.412543, -0.286254, -2.561859>, <1.408761, -0.283697, -2.798530>, 
      <1.362698, 0.057786, -2.023521>, <1.367226, 0.034411, -2.259036>, <1.410746, 0.015988, -2.557992>, <1.406964, 0.018545, -2.794663>, 
      <1.155081, 0.642741, -2.018433>, <1.149985, 0.624510, -2.243573>, <1.155647, 0.570115, -2.549879>, <1.162753, 0.561959, -2.775554>, 
      <0.844846, 0.645989, -2.051795>, <0.839749, 0.627757, -2.276935>, <0.854369, 0.570440, -2.574383>, <0.861475, 0.562284, -2.800058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.855826, -1.065158, -1.984566>, <0.856376, -1.035910, -2.238314>, <0.864761, -0.934826, -2.566451>, <0.870140, -0.895023, -2.818702>, 
      <1.141542, -1.068149, -1.953841>, <1.142092, -1.038901, -2.207589>, <1.108458, -0.935089, -2.546630>, <1.113838, -0.895286, -2.798881>, 
      <1.366542, -0.541160, -1.999989>, <1.371069, -0.564535, -2.235504>, <1.413997, -0.530732, -2.564987>, <1.410215, -0.528175, -2.801658>, 
      <1.364699, -0.254008, -2.011271>, <1.369226, -0.277383, -2.246785>, <1.412543, -0.286254, -2.561859>, <1.408761, -0.283697, -2.798530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.855826, -1.065158, -1.984566>, <0.540975, -1.061862, -2.018424>, <0.214463, -0.558379, -2.122750>, <0.212432, -0.241946, -2.135182>, 
      <0.856376, -1.035910, -2.238314>, <0.541525, -1.032614, -2.272172>, <0.228664, -0.561034, -2.350061>, <0.226634, -0.244601, -2.362493>, 
      <0.864761, -0.934826, -2.566451>, <0.608853, -0.934550, -2.587264>, <0.264530, -0.544161, -2.666583>, <0.263004, -0.287434, -2.663299>, 
      <0.870140, -0.895023, -2.818702>, <0.614232, -0.894747, -2.839516>, <0.278299, -0.539203, -2.893883>, <0.276773, -0.282475, -2.890598>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.722946, 0.634096, 0.875072>, <0.732049, 0.642450, 0.906655>, <0.739515, 0.636494, 0.998038>, <0.753289, 0.661941, 0.980349>, 
      <0.562336, 0.763367, 0.886341>, <0.571439, 0.771721, 0.917924>, <0.584114, 0.775386, 1.006839>, <0.597888, 0.800833, 0.989150>, 
      <0.260566, 0.765245, 0.941339>, <0.268432, 0.776925, 0.974649>, <0.282665, 0.775820, 1.061274>, <0.288088, 0.805398, 1.041185>, 
      <0.054988, 0.780662, 0.952894>, <0.062854, 0.792342, 0.986204>, <0.075786, 0.790017, 1.084016>, <0.081208, 0.819595, 1.063927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.124734, -0.080353, 0.877835>, <1.120653, -0.086520, 0.916164>, <1.075030, -0.094636, 1.019059>, <1.111131, -0.100911, 1.005599>, 
      <1.119877, 0.165501, 0.878967>, <1.115796, 0.159334, 0.917296>, <1.079717, 0.158198, 1.015965>, <1.115817, 0.151924, 1.002505>, 
      <0.914223, 0.480141, 0.861651>, <0.923326, 0.488495, 0.893234>, <0.927908, 0.468116, 0.987368>, <0.941682, 0.493563, 0.969680>, 
      <0.722946, 0.634096, 0.875072>, <0.732049, 0.642450, 0.906655>, <0.739515, 0.636494, 0.998038>, <0.753289, 0.661941, 0.980349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.754770, -0.976811, 0.867653>, <0.745130, -0.981274, 0.907532>, <0.707720, -0.958621, 1.020264>, <0.722637, -0.991687, 1.000584>, 
      <0.966208, -0.777346, 0.854884>, <0.956568, -0.781809, 0.894763>, <0.917641, -0.756304, 1.019728>, <0.932558, -0.789370, 1.000047>, 
      <1.130481, -0.371249, 0.876495>, <1.126400, -0.377416, 0.914824>, <1.069627, -0.386111, 1.022626>, <1.105728, -0.392385, 1.009166>, 
      <1.124734, -0.080353, 0.877835>, <1.120653, -0.086520, 0.916164>, <1.075030, -0.094636, 1.019059>, <1.111131, -0.100911, 1.005599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.071626, -1.073829, 0.941436>, <0.065584, -1.088331, 0.961498>, <0.049791, -1.106682, 1.028472>, <0.051487, -1.122169, 1.008308>, 
      <0.278581, -1.088975, 0.924730>, <0.272539, -1.103477, 0.944791>, <0.253807, -1.119559, 1.011459>, <0.255502, -1.135046, 0.991296>, 
      <0.603486, -1.119529, 0.876790>, <0.593846, -1.123992, 0.916669>, <0.560022, -1.100968, 1.020642>, <0.574939, -1.134034, 1.000962>, 
      <0.754770, -0.976811, 0.867653>, <0.745130, -0.981274, 0.907532>, <0.707720, -0.958621, 1.020264>, <0.722637, -0.991687, 1.000584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.569877, -0.879868, 0.974584>, <-0.573881, -0.888687, 1.015052>, <-0.574341, -0.875003, 1.131355>, <-0.583223, -0.909266, 1.109477>, 
      <-0.425018, -1.019402, 0.966334>, <-0.429022, -1.028222, 1.006802>, <-0.431792, -1.019208, 1.119417>, <-0.440674, -1.053471, 1.097539>, 
      <-0.128491, -1.059184, 0.957590>, <-0.134532, -1.073686, 0.977652>, <-0.152227, -1.093932, 1.045317>, <-0.150531, -1.109418, 1.025154>, 
      <0.071626, -1.073829, 0.941436>, <0.065584, -1.088331, 0.961498>, <0.049791, -1.106682, 1.028472>, <0.051487, -1.122169, 1.008308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.983996, -0.057010, 1.001558>, <-0.985120, -0.061168, 1.029692>, <-0.963076, -0.072967, 1.109386>, <-0.987741, -0.070871, 1.095338>, 
      <-0.983314, -0.333447, 1.006125>, <-0.984437, -0.337605, 1.034259>, <-0.959851, -0.352225, 1.106045>, <-0.984516, -0.350129, 1.091998>, 
      <-0.768833, -0.688226, 0.985915>, <-0.772837, -0.697045, 1.026383>, <-0.770351, -0.676717, 1.147770>, <-0.779233, -0.710980, 1.125892>, 
      <-0.569877, -0.879868, 0.974584>, <-0.573881, -0.888687, 1.015052>, <-0.574341, -0.875003, 1.131355>, <-0.583223, -0.909266, 1.109477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.573854, 0.731348, 0.947963>, <-0.582430, 0.738438, 1.002389>, <-0.562149, 0.722221, 1.149116>, <-0.602441, 0.754980, 1.129383>, 
      <-0.781639, 0.563823, 0.957695>, <-0.790215, 0.570913, 1.012121>, <-0.772299, 0.547160, 1.155291>, <-0.812592, 0.579918, 1.135558>, 
      <-0.984655, 0.210036, 0.997146>, <-0.985779, 0.205878, 1.025280>, <-0.966235, 0.200579, 1.112657>, <-0.990900, 0.202675, 1.098610>, 
      <-0.983996, -0.057010, 1.001558>, <-0.985120, -0.061168, 1.029692>, <-0.963076, -0.072967, 1.109386>, <-0.987741, -0.070871, 1.095338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.573854, 0.731348, 0.947963>, <-0.426632, 0.850045, 0.941067>, <-0.133424, 0.794792, 0.963484>, <0.054988, 0.780662, 0.952894>, 
      <-0.582430, 0.738438, 1.002389>, <-0.435208, 0.857134, 0.995493>, <-0.125558, 0.806472, 0.996794>, <0.062854, 0.792342, 0.986204>, 
      <-0.562149, 0.722221, 1.149116>, <-0.403188, 0.854641, 1.144445>, <-0.129441, 0.804101, 1.106577>, <0.075786, 0.790017, 1.084016>, 
      <-0.602441, 0.754980, 1.129383>, <-0.443480, 0.887399, 1.124712>, <-0.124018, 0.833679, 1.086487>, <0.081208, 0.819595, 1.063927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.770041, 0.721102, 0.814591>, <0.604384, 0.858799, 0.822643>, <0.286270, 0.859887, 0.877127>, <0.071474, 0.870591, 0.891814>, 
      <0.765475, 0.706374, 0.865339>, <0.599818, 0.844071, 0.873391>, <0.291258, 0.853382, 0.930433>, <0.076462, 0.864086, 0.945119>, 
      <0.774830, 0.701737, 0.952685>, <0.619429, 0.840629, 0.961486>, <0.296174, 0.849507, 1.011226>, <0.089294, 0.863705, 1.033967>, 
      <0.753289, 0.661941, 0.980349>, <0.597888, 0.800833, 0.989150>, <0.288088, 0.805398, 1.041185>, <0.081208, 0.819595, 1.063927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.239519, -0.100303, 0.835039>, <1.235970, 0.183572, 0.834476>, <0.988213, 0.539755, 0.803986>, <0.770041, 0.721102, 0.814591>, 
      <1.216908, -0.105797, 0.894707>, <1.213359, 0.178078, 0.894143>, <0.983647, 0.525027, 0.854734>, <0.765475, 0.706374, 0.865339>, 
      <1.170360, -0.111205, 0.983516>, <1.175047, 0.141629, 0.980422>, <0.963223, 0.533359, 0.942016>, <0.774830, 0.701737, 0.952685>, 
      <1.111131, -0.100911, 1.005599>, <1.115817, 0.151924, 1.002505>, <0.941682, 0.493563, 0.969680>, <0.753289, 0.661941, 0.980349>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.792309, -1.060022, 0.818127>, <1.026993, -0.845909, 0.818634>, <1.243490, -0.417958, 0.835670>, <1.239519, -0.100303, 0.835039>, 
      <0.779230, -1.059646, 0.878807>, <1.013914, -0.845533, 0.879314>, <1.220880, -0.423452, 0.895338>, <1.216908, -0.105797, 0.894707>, 
      <0.745074, -1.041422, 0.970982>, <0.954995, -0.839106, 0.970445>, <1.164957, -0.402679, 0.987083>, <1.170360, -0.111205, 0.983516>, 
      <0.722637, -0.991687, 1.000584>, <0.932558, -0.789370, 1.000047>, <1.105728, -0.392385, 1.009166>, <1.111131, -0.100911, 1.005599>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.080784, -1.157470, 0.832538>, <0.295712, -1.166917, 0.820114>, <0.633115, -1.205262, 0.817783>, <0.792309, -1.060022, 0.818127>, 
      <0.082193, -1.160340, 0.886942>, <0.297120, -1.169787, 0.874518>, <0.620036, -1.204886, 0.878464>, <0.779230, -1.059646, 0.878807>, 
      <0.055114, -1.155291, 0.965184>, <0.259129, -1.168168, 0.948171>, <0.597377, -1.183770, 0.971360>, <0.745074, -1.041422, 0.970982>, 
      <0.051487, -1.122169, 1.008308>, <0.255502, -1.135046, 0.991296>, <0.574939, -1.134034, 1.000962>, <0.722637, -0.991687, 1.000584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.600705, -0.998790, 0.898649>, <-0.448805, -1.144227, 0.883407>, <-0.129513, -1.148226, 0.844694>, <0.080784, -1.157470, 0.832538>, 
      <-0.588535, -0.993684, 0.966288>, <-0.436634, -1.139121, 0.951046>, <-0.128104, -1.151096, 0.899097>, <0.082193, -1.160340, 0.886942>, 
      <-0.597933, -0.966011, 1.073244>, <-0.455384, -1.110215, 1.061306>, <-0.146905, -1.142541, 0.982030>, <0.055114, -1.155291, 0.965184>, 
      <-0.583223, -0.909266, 1.109477>, <-0.440674, -1.053471, 1.097539>, <-0.150531, -1.109418, 1.025154>, <0.051487, -1.122169, 1.008308>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.076814, -0.049124, 0.948694>, <-1.068358, -0.368056, 0.946394>, <-0.830556, -0.778719, 0.921713>, <-0.600705, -0.998790, 0.898649>, 
      <-1.054663, -0.042802, 0.995185>, <-1.046206, -0.361735, 0.992885>, <-0.818385, -0.773613, 0.989351>, <-0.588535, -0.993684, 0.966288>, 
      <-1.032704, -0.067051, 1.069730>, <-1.029479, -0.346309, 1.066389>, <-0.793943, -0.767724, 1.089659>, <-0.597933, -0.966011, 1.073244>, 
      <-0.987741, -0.070871, 1.095338>, <-0.984516, -0.350129, 1.091998>, <-0.779233, -0.710980, 1.125892>, <-0.583223, -0.909266, 1.109477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.648182, 0.791778, 0.911561>, <-0.869192, 0.614762, 0.922509>, <-1.084325, 0.234141, 0.950737>, <-1.076814, -0.049124, 0.948694>, 
      <-0.640541, 0.788782, 0.978740>, <-0.861551, 0.611765, 0.989687>, <-1.062173, 0.240463, 0.997227>, <-1.054663, -0.042802, 0.995185>, 
      <-0.651529, 0.794890, 1.105342>, <-0.861680, 0.619828, 1.111517>, <-1.035863, 0.206495, 1.073001>, <-1.032704, -0.067051, 1.069730>, 
      <-0.602441, 0.754980, 1.129383>, <-0.812592, 0.579918, 1.135558>, <-0.990900, 0.202675, 1.098610>, <-0.987741, -0.070871, 1.095338>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.648182, 0.791778, 0.911561>, <-0.640541, 0.788782, 0.978740>, <-0.651529, 0.794890, 1.105342>, <-0.602441, 0.754980, 1.129383>, 
      <-0.478729, 0.927501, 0.903167>, <-0.471088, 0.924504, 0.970346>, <-0.492568, 0.927309, 1.100671>, <-0.443480, 0.887399, 1.124712>, 
      <-0.145021, 0.881380, 0.906617>, <-0.140033, 0.874875, 0.959922>, <-0.115932, 0.877789, 1.056528>, <-0.124018, 0.833679, 1.086487>, 
      <0.071474, 0.870591, 0.891814>, <0.076462, 0.864086, 0.945119>, <0.089294, 0.863705, 1.033967>, <0.081208, 0.819595, 1.063927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.889959, 0.664175, -1.541836>, <1.175444, 0.691674, -1.543709>, <1.386739, 0.136385, -1.458142>, <1.382941, -0.150389, -1.455409>, 
      <0.886219, 0.647919, -1.694610>, <1.171704, 0.675418, -1.696483>, <1.392125, 0.120607, -1.627041>, <1.388328, -0.166167, -1.624308>, 
      <0.848313, 0.658390, -1.898653>, <1.158548, 0.655143, -1.865292>, <1.359452, 0.074546, -1.854662>, <1.361453, -0.237248, -1.842412>, 
      <0.844846, 0.645989, -2.051795>, <1.155081, 0.642741, -2.018433>, <1.362698, 0.057786, -2.023521>, <1.364699, -0.254008, -2.011271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.867336, -1.044078, -1.525555>, <0.862607, -1.051963, -1.663140>, <0.855529, -1.080948, -1.847582>, <0.855826, -1.065158, -1.984566>, 
      <1.176143, -1.014333, -1.527581>, <1.171413, -1.022217, -1.665166>, <1.141245, -1.083938, -1.816857>, <1.141542, -1.068149, -1.953841>, 
      <1.378833, -0.460590, -1.452453>, <1.384219, -0.476368, -1.621351>, <1.363296, -0.524400, -1.831130>, <1.366542, -0.541160, -1.999989>, 
      <1.382941, -0.150389, -1.455409>, <1.388328, -0.166167, -1.624308>, <1.361453, -0.237248, -1.842412>, <1.364699, -0.254008, -2.011271>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.217338, -0.287552, -1.410273>, <-1.214315, 0.049818, -1.418241>, <-1.021918, 0.697721, -1.481014>, <-0.684454, 0.700551, -1.481995>, 
      <-1.211797, -0.285421, -1.586633>, <-1.208774, 0.051950, -1.594601>, <-1.017580, 0.690751, -1.641704>, <-0.680115, 0.693581, -1.642685>, 
      <-1.248129, -0.225274, -1.817746>, <-1.232798, 0.099390, -1.832274>, <-0.996248, 0.713470, -1.847252>, <-0.671082, 0.714644, -1.858125>, 
      <-1.244961, -0.221903, -1.994145>, <-1.229629, 0.102761, -2.008673>, <-0.996055, 0.696710, -2.007276>, <-0.670889, 0.697884, -2.018150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.699860, -1.018939, -1.441383>, <-0.968794, -1.021194, -1.440601>, <-1.219747, -0.556411, -1.403923>, <-1.217338, -0.287552, -1.410273>, 
      <-0.710401, -1.027382, -1.591514>, <-0.979335, -1.029637, -1.590732>, <-1.214206, -0.554279, -1.580283>, <-1.211797, -0.285421, -1.586633>, 
      <-0.751365, -1.036390, -1.790800>, <-1.034207, -1.037411, -1.781342>, <-1.261466, -0.507680, -1.805108>, <-1.248129, -0.225274, -1.817746>, 
      <-0.752231, -1.024581, -1.941072>, <-1.035073, -1.025602, -1.931613>, <-1.258297, -0.504308, -1.981508>, <-1.244961, -0.221903, -1.994145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.036872, -0.277653, -1.413705>, <-0.039545, -0.576028, -1.406658>, <-0.401402, -1.016436, -1.442251>, <-0.699860, -1.018939, -1.441383>, 
      <-0.046996, -0.293663, -1.599895>, <-0.049670, -0.592037, -1.592848>, <-0.411943, -1.024879, -1.592382>, <-0.710401, -1.027382, -1.591514>, 
      <-0.021919, -0.223470, -1.847981>, <-0.037248, -0.548061, -1.833457>, <-0.426272, -1.035216, -1.801672>, <-0.751365, -1.036390, -1.790800>, 
      <-0.034230, -0.217531, -2.034633>, <-0.049558, -0.542121, -2.020108>, <-0.427138, -1.023407, -1.951943>, <-0.752231, -1.024581, -1.941072>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.036872, -0.277653, -1.413705>, <-0.046996, -0.293663, -1.599895>, <-0.021919, -0.223470, -1.847981>, <-0.034230, -0.217531, -2.034633>, 
      <-0.033714, 0.074771, -1.422029>, <-0.043839, 0.058761, -1.608219>, <-0.006154, 0.110373, -1.862921>, <-0.018464, 0.116313, -2.049572>, 
      <-0.331932, 0.703507, -1.483020>, <-0.327593, 0.696537, -1.643710>, <-0.336721, 0.715851, -1.869307>, <-0.336529, 0.699091, -2.029331>, 
      <-0.684454, 0.700551, -1.481995>, <-0.680115, 0.693581, -1.642685>, <-0.671082, 0.714644, -1.858125>, <-0.670889, 0.697884, -2.018150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.186615, -0.265623, -1.447560>, <0.220039, -0.285844, -1.650387>, <0.199553, -0.239539, -1.929044>, <0.212432, -0.241946, -2.135182>, 
      <0.182495, -0.576694, -1.444595>, <0.215919, -0.596915, -1.647422>, <0.201583, -0.555972, -1.916611>, <0.214463, -0.558379, -2.122750>, 
      <0.557663, -1.073907, -1.523523>, <0.552934, -1.081791, -1.661108>, <0.540678, -1.077652, -1.881440>, <0.540975, -1.061862, -2.018424>, 
      <0.867336, -1.044078, -1.525555>, <0.862607, -1.051963, -1.663140>, <0.855529, -1.080948, -1.847582>, <0.855826, -1.065158, -1.984566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.186615, -0.265623, -1.447560>, <0.191262, 0.085228, -1.450904>, <0.540685, 0.630532, -1.539545>, <0.889959, 0.664175, -1.541836>, 
      <0.220039, -0.285844, -1.650387>, <0.224685, 0.065008, -1.653730>, <0.536945, 0.614276, -1.692319>, <0.886219, 0.647919, -1.694610>, 
      <0.199553, -0.239539, -1.929044>, <0.197450, 0.088195, -1.941920>, <0.522217, 0.661804, -1.933721>, <0.848313, 0.658390, -1.898653>, 
      <0.212432, -0.241946, -2.135182>, <0.210329, 0.085788, -2.148058>, <0.518751, 0.649403, -2.086862>, <0.844846, 0.645989, -2.051795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.685059, -0.970780, -0.984397>, <-0.676904, -0.972755, -1.122068>, <-0.690215, -1.011214, -1.304011>, <-0.699860, -1.018939, -1.441383>, 
      <-0.358019, -0.943530, -1.022390>, <-0.349864, -0.945505, -1.160061>, <-0.391757, -1.008711, -1.304879>, <-0.401402, -1.016436, -1.442251>, 
      <0.025363, -0.457568, -0.979374>, <0.009524, -0.458421, -0.976975>, <-0.032105, -0.564262, -1.269832>, <-0.039545, -0.576028, -1.406658>, 
      <0.022858, -0.127257, -0.984776>, <0.007019, -0.128110, -0.982377>, <-0.029432, -0.265888, -1.276879>, <-0.036872, -0.277653, -1.413705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.770862, -1.001745, -0.242740>, <-0.758023, -0.999988, -0.466539>, <-0.698313, -0.967570, -0.760639>, <-0.685059, -0.970780, -0.984397>, 
      <-0.554069, -1.126636, -0.275782>, <-0.541230, -1.124880, -0.499581>, <-0.371274, -0.940321, -0.798632>, <-0.358019, -0.943530, -1.022390>, 
      <-0.196063, -0.914399, -0.368962>, <-0.197535, -0.725299, -0.602151>, <0.030490, -0.755634, -0.943760>, <0.025363, -0.457568, -0.979374>, 
      <0.056298, -0.915894, -0.369580>, <0.054826, -0.726794, -0.602768>, <0.027985, -0.425323, -0.949162>, <0.022858, -0.127257, -0.984776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.751524, -0.979873, 0.174124>, <-0.563724, -1.115137, 0.125699>, <-0.206173, -1.076511, 0.189743>, <0.030266, -1.078938, 0.188785>, 
      <-0.718777, -0.979304, 0.393785>, <-0.530977, -1.114569, 0.345361>, <-0.202277, -1.114951, 0.381027>, <0.034162, -1.117378, 0.380069>, 
      <-0.639927, -1.015245, 0.680671>, <-0.488026, -1.160682, 0.665429>, <-0.134557, -1.137949, 0.649883>, <0.075740, -1.147193, 0.637727>, 
      <-0.600705, -0.998790, 0.898649>, <-0.448805, -1.144227, 0.883407>, <-0.129513, -1.148226, 0.844694>, <0.080784, -1.157470, 0.832538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.751524, -0.979873, 0.174124>, <-0.770009, -0.980194, 0.050129>, <-0.778042, -1.002727, -0.117584>, <-0.770862, -1.001745, -0.242740>, 
      <-0.563724, -1.115137, 0.125699>, <-0.582209, -1.115458, 0.001705>, <-0.561249, -1.127618, -0.150626>, <-0.554069, -1.126636, -0.275782>, 
      <-0.206173, -1.076511, 0.189743>, <-0.209661, -1.042102, 0.018522>, <-0.195207, -1.024422, -0.233289>, <-0.196063, -0.914399, -0.368962>, 
      <0.030266, -1.078938, 0.188785>, <0.026778, -1.044530, 0.017563>, <0.057154, -1.025916, -0.233906>, <0.056298, -0.915894, -0.369580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.261040, -0.148866, 0.521750>, <-1.273653, -0.455155, 0.472556>, <-0.998111, -0.802267, 0.237707>, <-0.751524, -0.979873, 0.174124>, 
      <-1.235467, -0.136748, 0.661587>, <-1.248080, -0.443037, 0.612393>, <-0.965365, -0.801698, 0.457368>, <-0.718777, -0.979304, 0.393785>, 
      <-1.137726, -0.066507, 0.820855>, <-1.129269, -0.385439, 0.818555>, <-0.869777, -0.795173, 0.703734>, <-0.639927, -1.015245, 0.680671>, 
      <-1.076814, -0.049124, 0.948694>, <-1.068358, -0.368056, 0.946394>, <-0.830556, -0.778719, 0.921713>, <-0.600705, -0.998790, 0.898649>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.280634, -0.145708, -0.165816>, <-1.293393, -0.444846, -0.150775>, <-1.028392, -0.853386, -0.203489>, <-0.770862, -1.001745, -0.242740>, 
      <-1.277535, -0.132477, 0.040092>, <-1.290294, -0.431615, 0.055133>, <-1.035572, -0.854368, -0.078334>, <-0.778042, -1.002727, -0.117584>, 
      <-1.298028, -0.166394, 0.319494>, <-1.310641, -0.472683, 0.270301>, <-1.016596, -0.802588, 0.113712>, <-0.770009, -0.980194, 0.050129>, 
      <-1.261040, -0.148866, 0.521750>, <-1.273653, -0.455155, 0.472556>, <-0.998111, -0.802267, 0.237707>, <-0.751524, -0.979873, 0.174124>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.281435, -0.235934, -0.833253>, <-1.279255, -0.523404, -0.828552>, <-0.969681, -0.994495, -0.951332>, <-0.685059, -0.970780, -0.984397>, 
      <-1.291633, -0.213081, -0.632756>, <-1.289453, -0.500551, -0.628055>, <-0.982936, -0.991286, -0.727573>, <-0.698313, -0.967570, -0.760639>, 
      <-1.283669, -0.158663, -0.367430>, <-1.296428, -0.457801, -0.352388>, <-1.015552, -0.851630, -0.427288>, <-0.758023, -0.999988, -0.466539>, 
      <-1.280634, -0.145708, -0.165816>, <-1.293393, -0.444846, -0.150775>, <-1.028392, -0.853386, -0.203489>, <-0.770862, -1.001745, -0.242740>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-1.281435, -0.235934, -0.833253>, <-1.272610, -0.255711, -1.006765>, <-1.222829, -0.289664, -1.235514>, <-1.217338, -0.287552, -1.410273>, 
      <-1.279255, -0.523404, -0.828552>, <-1.270430, -0.543181, -1.002063>, <-1.225238, -0.558523, -1.229164>, <-1.219747, -0.556411, -1.403923>, 
      <-0.969681, -0.994495, -0.951332>, <-0.961526, -0.996470, -1.089003>, <-0.959148, -1.013469, -1.303229>, <-0.968794, -1.021194, -1.440601>, 
      <-0.685059, -0.970780, -0.984397>, <-0.676904, -0.972755, -1.122068>, <-0.690215, -1.011214, -1.304011>, <-0.699860, -1.018939, -1.441383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.678850, 0.784945, 0.457576>, <-0.931520, 0.575031, 0.495655>, <-1.247606, 0.177370, 0.574148>, <-1.261040, -0.148866, 0.521750>, 
      <-0.674050, 0.779146, 0.593890>, <-0.926719, 0.569232, 0.631969>, <-1.222033, 0.189488, 0.713985>, <-1.235467, -0.136748, 0.661587>, 
      <-0.663595, 0.797822, 0.776047>, <-0.884604, 0.620806, 0.786995>, <-1.145237, 0.216758, 0.822898>, <-1.137726, -0.066507, 0.820855>, 
      <-0.648182, 0.791778, 0.911561>, <-0.869192, 0.614762, 0.922509>, <-1.084325, 0.234141, 0.950737>, <-1.076814, -0.049124, 0.948694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.678850, 0.784945, 0.457576>, <-0.674050, 0.779146, 0.593890>, <-0.663595, 0.797822, 0.776047>, <-0.648182, 0.791778, 0.911561>, 
      <-0.515196, 0.920906, 0.432912>, <-0.510396, 0.915107, 0.569226>, <-0.494142, 0.933545, 0.767653>, <-0.478729, 0.927501, 0.903167>, 
      <-0.201481, 0.907628, 0.320799>, <-0.196171, 0.905848, 0.490626>, <-0.160737, 0.901875, 0.738672>, <-0.145021, 0.881380, 0.906617>, 
      <0.012511, 0.909180, 0.329818>, <0.017821, 0.907400, 0.499645>, <0.055758, 0.891086, 0.723869>, <0.071474, 0.870591, 0.891814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.698045, 0.741512, -1.012400>, <-0.362677, 0.769456, -1.051360>, <0.020289, 0.211465, -0.990316>, <0.022858, -0.127257, -0.984776>, 
      <-0.697109, 0.723847, -1.152762>, <-0.361741, 0.751791, -1.191722>, <0.004450, 0.210613, -0.987916>, <0.007019, -0.128110, -0.982377>, 
      <-0.688269, 0.706680, -1.340707>, <-0.335747, 0.709636, -1.341732>, <-0.026274, 0.086536, -1.285203>, <-0.029432, -0.265888, -1.276879>, 
      <-0.684454, 0.700551, -1.481995>, <-0.331932, 0.703507, -1.483020>, <-0.033714, 0.074771, -1.422029>, <-0.036872, -0.277653, -1.413705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.698045, 0.741512, -1.012400>, <-0.697109, 0.723847, -1.152762>, <-0.688269, 0.706680, -1.340707>, <-0.684454, 0.700551, -1.481995>, 
      <-1.040261, 0.712998, -0.972644>, <-1.039325, 0.695333, -1.113006>, <-1.025733, 0.703850, -1.339726>, <-1.021918, 0.697721, -1.481014>, 
      <-1.284056, 0.109705, -0.838906>, <-1.275231, 0.089928, -1.012417>, <-1.219806, 0.047706, -1.243482>, <-1.214315, 0.049818, -1.418241>, 
      <-1.281435, -0.235934, -0.833253>, <-1.272610, -0.255711, -1.006765>, <-1.222829, -0.289664, -1.235514>, <-1.217338, -0.287552, -1.410273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.692102, 0.844831, -0.335591>, <-0.957954, 0.634790, -0.250280>, <-1.265764, 0.202924, -0.183346>, <-1.280634, -0.145708, -0.165816>, 
      <-0.688987, 0.851879, -0.097055>, <-0.954839, 0.641838, -0.011744>, <-1.262665, 0.216155, 0.022562>, <-1.277535, -0.132477, 0.040092>, 
      <-0.687242, 0.795082, 0.219279>, <-0.939912, 0.585168, 0.257358>, <-1.284594, 0.159843, 0.371892>, <-1.298028, -0.166394, 0.319494>, 
      <-0.678850, 0.784945, 0.457576>, <-0.931520, 0.575031, 0.495655>, <-1.247606, 0.177370, 0.574148>, <-1.261040, -0.148866, 0.521750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.692102, 0.844831, -0.335591>, <-0.694783, 0.838765, -0.540887>, <-0.699405, 0.767160, -0.808609>, <-0.698045, 0.741512, -1.012400>, 
      <-0.957954, 0.634790, -0.250280>, <-0.960635, 0.628724, -0.455576>, <-1.041621, 0.738646, -0.768853>, <-1.040261, 0.712998, -0.972644>, 
      <-1.265764, 0.202924, -0.183346>, <-1.268799, 0.189969, -0.384960>, <-1.294254, 0.132558, -0.638409>, <-1.284056, 0.109705, -0.838906>, 
      <-1.280634, -0.145708, -0.165816>, <-1.283669, -0.158663, -0.367430>, <-1.291633, -0.213081, -0.632756>, <-1.281435, -0.235934, -0.833253>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.692102, 0.844831, -0.335591>, <-0.518478, 0.982006, -0.391306>, <-0.202843, 0.889374, -0.582556>, <0.025302, 0.886072, -0.584886>, 
      <-0.694783, 0.838765, -0.540887>, <-0.521159, 0.975940, -0.596602>, <-0.200823, 0.687038, -0.839195>, <0.027322, 0.683736, -0.841525>, 
      <-0.699405, 0.767160, -0.808609>, <-0.364037, 0.795104, -0.847570>, <0.014708, 0.535925, -1.029083>, <0.017277, 0.197202, -1.023544>, 
      <-0.698045, 0.741512, -1.012400>, <-0.362677, 0.769456, -1.051360>, <0.020289, 0.211465, -0.990316>, <0.022858, -0.127257, -0.984776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <-0.692102, 0.844831, -0.335591>, <-0.688987, 0.851879, -0.097055>, <-0.687242, 0.795082, 0.219279>, <-0.678850, 0.784945, 0.457576>, 
      <-0.518478, 0.982006, -0.391306>, <-0.515363, 0.989054, -0.152770>, <-0.523588, 0.931043, 0.194615>, <-0.515196, 0.920906, 0.432912>, 
      <-0.202843, 0.889374, -0.582556>, <-0.204540, 1.059338, -0.366978>, <-0.210060, 0.910505, 0.046422>, <-0.201481, 0.907628, 0.320799>, 
      <0.025302, 0.886072, -0.584886>, <0.023605, 1.056035, -0.369308>, <0.003932, 0.912056, 0.055442>, <0.012511, 0.909180, 0.329818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.902210, -0.996851, 0.167423>, <0.871814, -1.005708, 0.363768>, <0.834211, -1.061227, 0.623714>, <0.792309, -1.060022, 0.818127>, 
      <0.697953, -1.158444, 0.132207>, <0.667557, -1.167301, 0.328552>, <0.675017, -1.206467, 0.623371>, <0.633115, -1.205262, 0.817783>, 
      <0.293068, -1.081636, 0.187720>, <0.296964, -1.120076, 0.379004>, <0.290667, -1.156641, 0.625303>, <0.295712, -1.166917, 0.820114>, 
      <0.030266, -1.078938, 0.188785>, <0.034162, -1.117378, 0.380069>, <0.075740, -1.147193, 0.637727>, <0.080784, -1.157470, 0.832538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.957199, -1.011979, -0.246971>, <0.958575, -1.010646, -0.121496>, <0.921390, -0.991263, 0.043533>, <0.902210, -0.996851, 0.167423>, 
      <0.727526, -1.158638, -0.278136>, <0.728902, -1.157306, -0.152660>, <0.717133, -1.152856, 0.008318>, <0.697953, -1.158444, 0.132207>, 
      <0.330573, -0.917518, -0.370252>, <0.331429, -1.027541, -0.234578>, <0.289580, -1.047228, 0.016499>, <0.293068, -1.081636, 0.187720>, 
      <0.056298, -0.915894, -0.369580>, <0.057154, -1.025916, -0.233906>, <0.026778, -1.044530, 0.017563>, <0.030266, -1.078938, 0.188785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.889290, -1.009368, -1.011034>, <0.519606, -1.003518, -1.041946>, <0.026575, -0.498114, -0.995135>, <0.022858, -0.127257, -0.984776>, 
      <0.878437, -1.013245, -1.165452>, <0.508753, -1.007395, -1.196363>, <0.044197, -0.497166, -0.997805>, <0.040479, -0.126308, -0.987445>, 
      <0.872647, -1.035224, -1.371052>, <0.562974, -1.065053, -1.369021>, <0.157736, -0.561715, -1.294348>, <0.161856, -0.250644, -1.297312>, 
      <0.867336, -1.044078, -1.525555>, <0.557663, -1.073907, -1.523523>, <0.182495, -0.576694, -1.444595>, <0.186615, -0.265623, -1.447560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.889290, -1.009368, -1.011034>, <0.905419, -1.003607, -0.781548>, <0.954676, -1.014423, -0.477068>, <0.957199, -1.011979, -0.246971>, 
      <0.519606, -1.003518, -1.041946>, <0.535735, -0.997757, -0.812460>, <0.725003, -1.161083, -0.508233>, <0.727526, -1.158638, -0.278136>, 
      <0.026575, -0.498114, -0.995135>, <0.031703, -0.796180, -0.959521>, <0.329101, -0.728418, -0.603440>, <0.330573, -0.917518, -0.370252>, 
      <0.022858, -0.127257, -0.984776>, <0.027985, -0.425323, -0.949162>, <0.054826, -0.726794, -0.602768>, <0.056298, -0.915894, -0.369580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.335389, -0.046417, 0.413800>, <1.325787, -0.044984, 0.544046>, <1.285630, -0.089098, 0.713357>, <1.239519, -0.100303, 0.835039>, 
      <1.354298, -0.361777, 0.351825>, <1.344696, -0.360344, 0.482071>, <1.289601, -0.406753, 0.713987>, <1.243490, -0.417958, 0.835670>, 
      <1.152421, -0.798902, 0.210562>, <1.122025, -0.807758, 0.406906>, <1.068895, -0.847114, 0.624221>, <1.026993, -0.845909, 0.818634>, 
      <0.902210, -0.996851, 0.167423>, <0.871814, -1.005708, 0.363768>, <0.834211, -1.061227, 0.623714>, <0.792309, -1.060022, 0.818127>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.315730, -0.111674, -0.198686>, <1.316718, -0.097166, -0.014379>, <1.348982, -0.048445, 0.229432>, <1.335389, -0.046417, 0.413800>, 
      <1.331002, -0.401884, -0.182157>, <1.331989, -0.387376, 0.002150>, <1.367890, -0.363805, 0.167457>, <1.354298, -0.361777, 0.351825>, 
      <1.200940, -0.856336, -0.213897>, <1.202316, -0.855004, -0.088422>, <1.171601, -0.793314, 0.086672>, <1.152421, -0.798902, 0.210562>, 
      <0.957199, -1.011979, -0.246971>, <0.958575, -1.010646, -0.121496>, <0.921390, -0.991263, 0.043533>, <0.902210, -0.996851, 0.167423>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.328480, -0.147917, -0.875605>, <1.317622, -0.141663, -0.672589>, <1.314644, -0.127636, -0.401458>, <1.315730, -0.111674, -0.198686>, 
      <1.331415, -0.440704, -0.883784>, <1.320557, -0.434449, -0.680767>, <1.329915, -0.417846, -0.384929>, <1.331002, -0.401884, -0.182157>, 
      <1.181150, -1.013986, -0.986630>, <1.197280, -1.008225, -0.757144>, <1.198417, -0.858780, -0.443995>, <1.200940, -0.856336, -0.213897>, 
      <0.889290, -1.009368, -1.011034>, <0.905419, -1.003607, -0.781548>, <0.954676, -1.014423, -0.477068>, <0.957199, -1.011979, -0.246971>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.328480, -0.147917, -0.875605>, <1.331415, -0.440704, -0.883784>, <1.181150, -1.013986, -0.986630>, <0.889290, -1.009368, -1.011034>, 
      <1.337806, -0.153289, -1.049982>, <1.340741, -0.446075, -1.058160>, <1.170297, -1.017863, -1.141048>, <0.878437, -1.013245, -1.165452>, 
      <1.377396, -0.134147, -1.281546>, <1.373288, -0.444348, -1.278589>, <1.181453, -1.005479, -1.373078>, <0.872647, -1.035224, -1.371052>, 
      <1.382941, -0.150389, -1.455409>, <1.378833, -0.460590, -1.452453>, <1.176143, -1.014333, -1.527581>, <0.867336, -1.044078, -1.525555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.794733, 0.795632, 0.519683>, <0.597306, 0.938246, 0.507150>, <0.256160, 0.910947, 0.340087>, <0.012511, 0.909180, 0.329818>, 
      <0.787665, 0.787735, 0.610622>, <0.590238, 0.930349, 0.598088>, <0.261470, 0.909167, 0.509914>, <0.017821, 0.907400, 0.499645>, 
      <0.777922, 0.746525, 0.726991>, <0.612264, 0.884221, 0.735043>, <0.270554, 0.880382, 0.709183>, <0.055758, 0.891086, 0.723869>, 
      <0.770041, 0.721102, 0.814591>, <0.604384, 0.858799, 0.822643>, <0.286270, 0.859887, 0.877127>, <0.071474, 0.870591, 0.891814>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.794733, 0.795632, 0.519683>, <0.787665, 0.787735, 0.610622>, <0.777922, 0.746525, 0.726991>, <0.770041, 0.721102, 0.814591>, 
      <1.039120, 0.619096, 0.535198>, <1.032052, 0.611199, 0.626136>, <0.996093, 0.565178, 0.716387>, <0.988213, 0.539755, 0.803986>, 
      <1.317659, 0.249285, 0.471912>, <1.308057, 0.250718, 0.602158>, <1.282081, 0.194777, 0.712793>, <1.235970, 0.183572, 0.834476>, 
      <1.335389, -0.046417, 0.413800>, <1.325787, -0.044984, 0.544046>, <1.285630, -0.089098, 0.713357>, <1.239519, -0.100303, 0.835039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.860671, 0.822354, -0.351447>, <0.659814, 0.977655, -0.411560>, <0.286174, 0.882296, -0.587550>, <0.025302, 0.886072, -0.584886>, 
      <0.847097, 0.828299, -0.089657>, <0.646240, 0.983600, -0.149770>, <0.284477, 1.052259, -0.371972>, <0.023605, 1.056035, -0.369308>, 
      <0.814976, 0.818248, 0.259236>, <0.617549, 0.960861, 0.246703>, <0.247581, 0.913823, 0.065711>, <0.003932, 0.912056, 0.055442>, 
      <0.794733, 0.795632, 0.519683>, <0.597306, 0.938246, 0.507150>, <0.256160, 0.910947, 0.340087>, <0.012511, 0.909180, 0.329818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.860671, 0.822354, -0.351447>, <0.847097, 0.828299, -0.089657>, <0.814976, 0.818248, 0.259236>, <0.794733, 0.795632, 0.519683>, 
      <1.103201, 0.634832, -0.278862>, <1.089628, 0.640777, -0.017072>, <1.059364, 0.641711, 0.274751>, <1.039120, 0.619096, 0.535198>, 
      <1.299201, 0.202429, -0.216576>, <1.300189, 0.216938, -0.032269>, <1.331251, 0.247257, 0.287543>, <1.317659, 0.249285, 0.471912>, 
      <1.315730, -0.111674, -0.198686>, <1.316718, -0.097166, -0.014379>, <1.348982, -0.048445, 0.229432>, <1.335389, -0.046417, 0.413800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.871534, 0.761993, -0.961553>, <0.875841, 0.738734, -1.136589>, <0.894257, 0.682858, -1.366252>, <0.889959, 0.664175, -1.541836>, 
      <0.504026, 0.767808, -0.992283>, <0.508333, 0.744549, -1.167319>, <0.544983, 0.649214, -1.363960>, <0.540685, 0.630532, -1.539545>, 
      <0.019162, 0.241417, -0.974478>, <0.036784, 0.242365, -0.977147>, <0.166502, 0.100207, -1.300656>, <0.191262, 0.085228, -1.450904>, 
      <0.022858, -0.127257, -0.984776>, <0.040479, -0.126308, -0.987445>, <0.161856, -0.250644, -1.297312>, <0.186615, -0.265623, -1.447560>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.871534, 0.761993, -0.961553>, <0.504026, 0.767808, -0.992283>, <0.019162, 0.241417, -0.974478>, <0.022858, -0.127257, -0.984776>, 
      <0.867049, 0.786217, -0.779256>, <0.499541, 0.792032, -0.809985>, <0.013581, 0.565876, -1.013245>, <0.017277, 0.197202, -1.023544>, 
      <0.870194, 0.818183, -0.535107>, <0.669336, 0.973484, -0.595220>, <0.288194, 0.679959, -0.844189>, <0.027322, 0.683736, -0.841525>, 
      <0.860671, 0.822354, -0.351447>, <0.659814, 0.977655, -0.411560>, <0.286174, 0.882296, -0.587550>, <0.025302, 0.886072, -0.584886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.871534, 0.761993, -0.961553>, <0.867049, 0.786217, -0.779256>, <0.870194, 0.818183, -0.535107>, <0.860671, 0.822354, -0.351447>, 
      <1.176977, 0.757160, -0.936013>, <1.172492, 0.781383, -0.753716>, <1.112724, 0.630661, -0.462523>, <1.103201, 0.634832, -0.278862>, 
      <1.325409, 0.158495, -0.867046>, <1.314551, 0.164749, -0.664030>, <1.298115, 0.186467, -0.419348>, <1.299201, 0.202429, -0.216576>, 
      <1.328480, -0.147917, -0.875605>, <1.317622, -0.141663, -0.672589>, <1.314644, -0.127636, -0.401458>, <1.315730, -0.111674, -0.198686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <0.871534, 0.761993, -0.961553>, <1.176977, 0.757160, -0.936013>, <1.325409, 0.158495, -0.867046>, <1.328480, -0.147917, -0.875605>, 
      <0.875841, 0.738734, -1.136589>, <1.181283, 0.733901, -1.111049>, <1.334734, 0.153123, -1.041422>, <1.337806, -0.153289, -1.049982>, 
      <0.894257, 0.682858, -1.366252>, <1.179742, 0.710356, -1.368125>, <1.381194, 0.152627, -1.284279>, <1.377396, -0.134147, -1.281546>, 
      <0.889959, 0.664175, -1.541836>, <1.175444, 0.691674, -1.543709>, <1.386739, 0.136385, -1.458142>, <1.382941, -0.150389, -1.455409>
    }
  }
  texture {
    Pants
  }
}
#declare Ear = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.013647, 0.083643, 5.375609>, <1.013647, 0.069227, 5.385900>, <1.003342, 0.047146, 5.401313>, <1.013647, 0.035589, 5.409914>, 
      <1.013647, 0.059627, 5.348618>, <1.013647, 0.045211, 5.358909>, <1.003342, 0.021968, 5.366372>, <1.013647, 0.010411, 5.374973>, 
      <1.013647, 0.024935, 5.315112>, <1.013647, 0.018359, 5.311900>, <1.011893, 0.001516, 5.321114>, <1.013647, -0.004824, 5.317908>, 
      <1.013647, -0.000226, 5.289184>, <1.013647, -0.006801, 5.285972>, <1.011893, -0.015804, 5.281682>, <1.013647, -0.022144, 5.278477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.013647, 0.128977, 5.434397>, <1.013647, 0.138342, 5.463534>, <1.002315, 0.151495, 5.504453>, <1.013647, 0.160195, 5.531519>, 
      <1.013647, 0.106708, 5.434735>, <1.013647, 0.116074, 5.463872>, <1.002315, 0.099263, 5.504709>, <1.013647, 0.107963, 5.531775>, 
      <1.013647, 0.098447, 5.392248>, <1.013647, 0.084031, 5.402539>, <1.003342, 0.077683, 5.443690>, <1.013647, 0.066125, 5.452291>, 
      <1.013647, 0.083643, 5.375609>, <1.013647, 0.069227, 5.385900>, <1.003342, 0.047146, 5.401313>, <1.013647, 0.035589, 5.409914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.013647, 0.187512, 5.374033>, <1.013647, 0.215040, 5.384439>, <1.001658, 0.254558, 5.398158>, <1.013647, 0.279273, 5.408719>, 
      <1.013647, 0.186312, 5.399230>, <1.013647, 0.213840, 5.409636>, <1.001658, 0.255246, 5.449470>, <1.013647, 0.279961, 5.460030>, 
      <1.013647, 0.154199, 5.434015>, <1.013647, 0.163565, 5.463152>, <1.002315, 0.202811, 5.504202>, <1.013647, 0.211510, 5.531267>, 
      <1.013647, 0.128977, 5.434397>, <1.013647, 0.138342, 5.463534>, <1.002315, 0.151495, 5.504453>, <1.013647, 0.160195, 5.531519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.013647, 0.136294, 5.280743>, <1.013647, 0.142363, 5.273810>, <1.007141, 0.153214, 5.263256>, <1.013647, 0.156523, 5.257634>, 
      <1.013647, 0.163521, 5.297419>, <1.013647, 0.169589, 5.290486>, <1.007141, 0.203788, 5.292458>, <1.013647, 0.207097, 5.286836>, 
      <1.013647, 0.189031, 5.342142>, <1.013647, 0.216559, 5.352548>, <1.001658, 0.253775, 5.339764>, <1.013647, 0.278490, 5.350325>, 
      <1.013647, 0.187512, 5.374033>, <1.013647, 0.215040, 5.384439>, <1.001658, 0.254558, 5.398158>, <1.013647, 0.279273, 5.408719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.013647, 0.004502, 5.261943>, <1.013647, -0.001167, 5.255106>, <1.014104, -0.007354, 5.244547>, <1.013647, -0.014395, 5.239152>, 
      <1.013647, 0.044040, 5.267583>, <1.013647, 0.038371, 5.260746>, <1.014104, 0.043921, 5.250092>, <1.013647, 0.036880, 5.244697>, 
      <1.013647, 0.102236, 5.259884>, <1.013647, 0.108305, 5.252951>, <1.007141, 0.108551, 5.237467>, <1.013647, 0.111860, 5.231845>, 
      <1.013647, 0.136294, 5.280743>, <1.013647, 0.142363, 5.273810>, <1.007141, 0.153214, 5.263256>, <1.013647, 0.156523, 5.257634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.088336, -0.000120, 5.437943>, <1.080791, -0.036177, 5.387904>, <1.050267, -0.051557, 5.307845>, <1.033951, -0.073602, 5.252089>, 
      <1.078202, 0.018023, 5.421953>, <1.070658, -0.018035, 5.371914>, <1.043474, -0.036285, 5.315508>, <1.027159, -0.058330, 5.259751>, 
      <1.028902, 0.018480, 5.422646>, <1.028902, -0.006698, 5.387705>, <1.018055, -0.020755, 5.309854>, <1.018055, -0.038075, 5.270424>, 
      <1.013647, 0.035589, 5.409914>, <1.013647, 0.010411, 5.374973>, <1.013647, -0.004824, 5.317908>, <1.013647, -0.022144, 5.278477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.088336, 0.186319, 5.612795>, <1.088336, 0.109639, 5.612372>, <1.097647, 0.044377, 5.499694>, <1.088336, -0.000120, 5.437943>, 
      <1.080842, 0.183338, 5.579735>, <1.080842, 0.106658, 5.579312>, <1.087513, 0.062520, 5.483704>, <1.078202, 0.018023, 5.421953>, 
      <1.026246, 0.169868, 5.561614>, <1.026246, 0.117636, 5.561870>, <1.028902, 0.049017, 5.465022>, <1.028902, 0.018480, 5.422646>, 
      <1.013647, 0.160195, 5.531519>, <1.013647, 0.107963, 5.531775>, <1.013647, 0.066125, 5.452291>, <1.013647, 0.035589, 5.409914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.088336, 0.341484, 5.439829>, <1.088336, 0.343600, 5.509506>, <1.088336, 0.256027, 5.613180>, <1.088336, 0.186319, 5.612795>, 
      <1.082164, 0.313776, 5.428356>, <1.082164, 0.315891, 5.498033>, <1.080842, 0.253046, 5.580120>, <1.080842, 0.183338, 5.579735>, 
      <1.026120, 0.304986, 5.419707>, <1.026120, 0.305674, 5.471018>, <1.026246, 0.221184, 5.561362>, <1.026246, 0.169868, 5.561614>, 
      <1.013647, 0.279273, 5.408719>, <1.013647, 0.279961, 5.460030>, <1.013647, 0.211510, 5.531267>, <1.013647, 0.160195, 5.531519>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.088336, 0.174277, 5.216201>, <1.102658, 0.246221, 5.256649>, <1.088336, 0.338942, 5.356099>, <1.088336, 0.341484, 5.439829>, 
      <1.078832, 0.167875, 5.239730>, <1.093154, 0.239818, 5.280178>, <1.082164, 0.311233, 5.344626>, <1.082164, 0.313776, 5.428356>, 
      <1.032128, 0.165922, 5.241664>, <1.032128, 0.216496, 5.270866>, <1.026120, 0.304203, 5.361313>, <1.026120, 0.304986, 5.419707>, 
      <1.013647, 0.156523, 5.257634>, <1.013647, 0.207097, 5.286836>, <1.013647, 0.278490, 5.350325>, <1.013647, 0.279273, 5.408719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.009968, -0.052187, 5.218501>, <1.033478, 0.015752, 5.217811>, <1.076044, 0.112530, 5.181486>, <1.088336, 0.174277, 5.216201>, 
      <1.006623, -0.042095, 5.225924>, <1.030133, 0.025844, 5.225234>, <1.066540, 0.106127, 5.205015>, <1.078832, 0.167875, 5.239730>, 
      <1.012980, -0.024674, 5.231275>, <1.012980, 0.026602, 5.236820>, <1.032128, 0.121258, 5.215875>, <1.032128, 0.165922, 5.241664>, 
      <1.013647, -0.014395, 5.239152>, <1.013647, 0.036880, 5.244697>, <1.013647, 0.111860, 5.231845>, <1.013647, 0.156523, 5.257634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.045656, -0.021717, 5.460421>, <1.045656, -0.058060, 5.401854>, <1.045656, -0.072396, 5.307784>, <1.045656, -0.094116, 5.242369>, 
      <1.061440, -0.023186, 5.460732>, <1.061440, -0.059529, 5.402164>, <1.052239, -0.074468, 5.304455>, <1.052239, -0.096187, 5.239040>, 
      <1.094464, -0.011091, 5.447612>, <1.086919, -0.047148, 5.397574>, <1.053097, -0.057922, 5.304652>, <1.036781, -0.079966, 5.248896>, 
      <1.088336, -0.000120, 5.437943>, <1.080791, -0.036177, 5.387904>, <1.050267, -0.051557, 5.307845>, <1.033951, -0.073602, 5.252089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.045656, 0.172928, 5.672720>, <1.045656, 0.086534, 5.671204>, <1.045656, 0.023842, 5.533841>, <1.045656, -0.021717, 5.460421>, 
      <1.068018, 0.174225, 5.673958>, <1.068018, 0.087831, 5.672442>, <1.061440, 0.022373, 5.534152>, <1.061440, -0.023186, 5.460732>, 
      <1.093277, 0.188284, 5.634589>, <1.093277, 0.111605, 5.634166>, <1.103774, 0.033407, 5.509364>, <1.094464, -0.011091, 5.447612>, 
      <1.088336, 0.186319, 5.612795>, <1.088336, 0.109639, 5.612372>, <1.097647, 0.044377, 5.499694>, <1.088336, -0.000120, 5.437943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.045656, 0.422978, 5.468223>, <1.045656, 0.421967, 5.565125>, <1.045656, 0.269820, 5.674420>, <1.045656, 0.172928, 5.672720>, 
      <1.074520, 0.422967, 5.467179>, <1.074520, 0.421956, 5.564081>, <1.068018, 0.271117, 5.675658>, <1.068018, 0.174225, 5.673958>, 
      <1.094158, 0.367622, 5.450652>, <1.094158, 0.369738, 5.520329>, <1.093277, 0.257993, 5.634974>, <1.093277, 0.188284, 5.634589>, 
      <1.088336, 0.341484, 5.439829>, <1.088336, 0.343600, 5.509506>, <1.088336, 0.256027, 5.613180>, <1.088336, 0.186319, 5.612795>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.045656, 0.178087, 5.178386>, <1.048433, 0.277905, 5.233035>, <1.045656, 0.424166, 5.354396>, <1.045656, 0.422978, 5.468223>, 
      <1.062790, 0.178473, 5.178864>, <1.065567, 0.278291, 5.233512>, <1.074520, 0.424155, 5.353352>, <1.074520, 0.422967, 5.467179>, 
      <1.094562, 0.178471, 5.200787>, <1.108884, 0.250415, 5.241235>, <1.094158, 0.365080, 5.366922>, <1.094158, 0.367622, 5.450652>, 
      <1.088336, 0.174277, 5.216201>, <1.102658, 0.246221, 5.256649>, <1.088336, 0.338942, 5.356099>, <1.088336, 0.341484, 5.439829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.031953, -0.069618, 5.198535>, <1.036064, 0.004693, 5.192490>, <1.043835, 0.112610, 5.142538>, <1.045656, 0.178087, 5.178386>, 
      <1.040664, -0.071736, 5.193400>, <1.044774, 0.002576, 5.187356>, <1.060968, 0.112995, 5.143016>, <1.062790, 0.178473, 5.178864>, 
      <1.012633, -0.060227, 5.212587>, <1.036144, 0.007712, 5.211897>, <1.082270, 0.116724, 5.166072>, <1.094562, 0.178471, 5.200787>, 
      <1.009968, -0.052187, 5.218501>, <1.033478, 0.015752, 5.217811>, <1.076044, 0.112530, 5.181486>, <1.088336, 0.174277, 5.216201>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.002976, 0.007827, 5.436266>, <1.002976, -0.024290, 5.391696>, <1.002976, -0.042350, 5.318310>, <1.002976, -0.063854, 5.267758>, 
      <1.015780, -0.001036, 5.443512>, <1.015780, -0.033153, 5.398942>, <1.015780, -0.051428, 5.310694>, <1.015780, -0.072933, 5.260141>, 
      <1.028557, -0.020125, 5.460085>, <1.028557, -0.056468, 5.401518>, <1.030668, -0.067680, 5.315366>, <1.030668, -0.089399, 5.249951>, 
      <1.045656, -0.021717, 5.460421>, <1.045656, -0.058060, 5.401854>, <1.045656, -0.072396, 5.307784>, <1.045656, -0.094116, 5.242369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.002976, 0.181370, 5.608069>, <1.002976, 0.108125, 5.606609>, <1.002976, 0.050656, 5.495702>, <1.002976, 0.007827, 5.436266>, 
      <1.015780, 0.178837, 5.627464>, <1.015780, 0.105592, 5.626004>, <1.015780, 0.041793, 5.502949>, <1.015780, -0.001036, 5.443512>, 
      <1.022353, 0.171577, 5.671430>, <1.022353, 0.085183, 5.669914>, <1.028557, 0.025434, 5.533506>, <1.028557, -0.020125, 5.460085>, 
      <1.045656, 0.172928, 5.672720>, <1.045656, 0.086534, 5.671204>, <1.045656, 0.023842, 5.533841>, <1.045656, -0.021717, 5.460421>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.002976, 0.341516, 5.442918>, <1.002976, 0.343094, 5.511914>, <1.002976, 0.250370, 5.609445>, <1.002976, 0.181370, 5.608069>, 
      <1.015780, 0.365955, 5.450510>, <1.015780, 0.367532, 5.519506>, <1.015780, 0.247838, 5.628840>, <1.015780, 0.178837, 5.627464>, 
      <1.017060, 0.422989, 5.469258>, <1.017060, 0.421978, 5.566160>, <1.022353, 0.268469, 5.673130>, <1.022353, 0.171577, 5.671430>, 
      <1.045656, 0.422978, 5.468223>, <1.045656, 0.421967, 5.565125>, <1.045656, 0.269820, 5.674420>, <1.045656, 0.172928, 5.672720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.002976, 0.172356, 5.213822>, <1.002976, 0.246835, 5.255677>, <1.002976, 0.339563, 5.357506>, <1.002976, 0.341516, 5.442918>, 
      <1.015780, 0.174075, 5.203191>, <1.015780, 0.248555, 5.245047>, <1.015780, 0.364002, 5.365098>, <1.015780, 0.365955, 5.450510>, 
      <1.028936, 0.177711, 5.177920>, <1.031713, 0.277529, 5.232569>, <1.017060, 0.424177, 5.355431>, <1.017060, 0.422989, 5.469258>, 
      <1.045656, 0.178087, 5.178386>, <1.048433, 0.277905, 5.233035>, <1.045656, 0.424166, 5.354396>, <1.045656, 0.422978, 5.468223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 1 v_steps 1,
      <1.002976, -0.050487, 5.222623>, <1.002976, 0.016366, 5.219983>, <1.002976, 0.114030, 5.181044>, <1.002976, 0.172356, 5.213822>, 
      <1.011669, -0.056226, 5.215396>, <1.011669, 0.010627, 5.212756>, <1.015780, 0.115749, 5.170414>, <1.015780, 0.174075, 5.203191>, 
      <1.021263, -0.067019, 5.204836>, <1.025374, 0.007293, 5.198792>, <1.027115, 0.112234, 5.142073>, <1.028936, 0.177711, 5.177920>, 
      <1.031953, -0.069618, 5.198535>, <1.036064, 0.004693, 5.192490>, <1.043835, 0.112610, 5.142538>, <1.045656, 0.178087, 5.178386>
    }
  }
}
union { // sPatchGroup
  object { sPatchObj }
  object { sPatchObj1 }
  object { sPatchObj2 }
  object { sPatchObj3 }
  object { sPatchObj4 }
  object { sPatchObj5 }
  object { sPatchObj6 }
  object { sPatchObj7 }
  object { Ear }
  texture {
    Body01
  }
  scale 0.2
  rotate -195.0*z
  translate  <-4.33, -13.12, 1.11>
}


