// ##################################################################

// TYPE : Scene file for IRTC Topic Horror                      
// NAME : "This could be reality!"
// CREATOR : Toni Bratincevic                                       
// E-MAIL  : tbrat@mail.geocities.com, tbratinc&barok.foi.hr                                
// HOMEPAGE: http://members.xoom.com/Intercepto                     
// HW USED : Pentium 133 (64MB Ram, 1.6GB HD, WinNT) 
// SW USED : POVRay 3.1, Moray 3.1, sPatch 1.5, PhotoShop 4.0 

// ##################################################################

// FIRST RENDER HFied SCENES IN /hfields directory anc copy TGA files to this directory

#declare alight = on;

#include "nucl_textures.inc"
#include "left_building.pov"
#include "antena.pov"
#include "boy.pov"
#include "bird.pov"
#include "bear.pov"
#include "sky.pov"
#include "grass.pov"
#include "explosion.pov"
#include "bflyes.pov"
#include "right_building.pov"
#include "tree_v0.72.pov"

object {
  stablo // this means tree on english :)
  scale 0.05
  rotate x*90
  translate <-11.0,-11.0,-0.15>
}

global_settings {
  max_trace_level 20
  radiosity {
    brightness       3.3
    count            300
    distance_maximum 0.0
    error_bound      0.33
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
}

// *******  C A M E R A *******

camera {  //  Camera Camera01
  location  <    -10.710,     -18.240,       2.340>
  direction <        0.0,         0.0,      1.1547> // Aperture is 0.82 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.060,       4.250,       3.170>
}

// *******  L I G H T S *******

// Sun light
light_source { // Arealight001
  <5000.000, -6000.000, 5000.000>
  color rgb <1.000, 0.900, 0.700>
  #if (alight)
    area_light <433.013, 250.000, 0.000>, <-143.394, 248.366, 409.576>, 15, 15
    adaptive 1   
    jitter
  #end
}

// Little light from camera
light_source {
  <-10.710,-18.240,2.340>
  color rgb <1,0.9,0.7>*0.2
}

// Light from explosion
light_source {
  <-10,38,2.3>
  color rgb <0.7,0.4,0.0>*2
  fade_distance 25
  fade_power 2
}

// OBJECT AS LIGHT SOURCE FOR RADIOSITY

box {
  <-10,-10,0> <10,10,1>
  rotate x*40
  rotate -60*y
  translate <510,310,-310>
  rotate -90*x
  pigment { color rgb <1,0.9,0.7> }
  finish { diffuse 0 ambient 8 }
}
