
// POV-Ray Object File - Seat
// created 18-Sep-99
// last update 29-Oct-99
// 1999 Glenn McCarter
// This file does not render.  #include "AirplaneSeat.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// AirplaneSeatS // simple version
// WindowSeat
// DoubleSeat // detailed, but not adjustable
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)



//===============================================
//             Variables
//===============================================

// Seat origin is at bottom front of seat at floor level
// Seat faces +x

//===============================================
//             Textures
//===============================================


#declare SeatFabric =
	texture {
//		pigment { color rgb <0.875,0.775,0.675> }
//		pigment { checker color rgb <0.875,0.775,0.675> color rgb <0.825,0.705,0.555> scale <2,2,0.8> } // tan
		pigment { checker color rgb <0.775,0.725,0.675> color rgb <0.725,0.705,0.555> scale <2,2,0.8> }
		normal { bumps .2 scale .15 }
		finish { ambient .10 diffuse .45 specular .08 roughness .167 }
	}
#declare SeatbackFabric =
	texture {
		pigment { checker color rgb <0.875,0.875,0.875> color rgb <0.575,0.575,0.505> scale <2,2,0.8> }
		finish { ambient .10 specular .15 roughness .167 }
	}
#declare AluminumTex =
	texture {
		pigment { color rgb <.91,.91,.91> }
		finish { ambient .10 specular .65 roughness .065 }
	}
#declare SeatFrameTex =
	texture {
		pigment { color rgb <.91,.91,.91> }
		finish { ambient .10 specular .65 roughness .065 }
	}



//===============================================
//             Objects
//===============================================

#declare AirplaneSeatS = // simple version
	union {
		box { // bottom
			<0,-14,0>,<14,14,5>
			texture { SeatFabric }
			rotate <0,-8,0>
			translate <0,0,8>
		}
		box { // back
			<0,-14,0>,<4,14,28>
			texture { SeatFabric }
			rotate <0,-8,0>
			translate <-4,0,14>
		}
	} // end union

#declare SeatBack =
	union {
		superellipsoid { // left side
			<.4,.4>
			scale <3,4,13>
			rotate <0,0,9>
			translate <-0.6,-8,12>
		}
		superellipsoid { // right side
			<.4,.4>
			scale <3,4,13>
			rotate <0,0,-9>
			translate <-0.6,8,12>
		}
		superellipsoid { // headrest LH
			<.5,.5>
			scale <2.8,6,5>
			rotate <0,4,6>
			translate <0,-3,26>
		}
		superellipsoid { // headrest RH
			<.5,.5>
			scale <2.8,6,5>
			rotate <0,4,-6>
			translate <0,3,26>
		}
		box { // lumbar
			<0,-5,0>,<2,5,22>
			texture { SeatbackFabric }
		}
		texture { SeatFabric }
	} // end union
#declare SeatBottom =
	union {
		box { // center
			<0,-10,0>,<18,10,4>
			texture { SeatbackFabric }
		}
		superellipsoid { // left side
			<.4,.4>
			scale <10,4,4>
			rotate <-9,0,0>
			translate <9,-8,1>
		}
		superellipsoid { // right side
			<.4,.4>
			scale <10,4,4>
			rotate <9,0,0>
			translate <9,8,1>
		}
		superellipsoid { // front
			<.9,.6>
			scale <4,8,4>
			rotate <0,22,0>
			translate <16,0,0>
		}
		texture { SeatFabric }
	} // end union
#declare SeatArm =
	union {
		box {
			<0,-1,0>,<17,1,2>
			texture { AluminumTex }
		}
		superellipsoid {
			<.3,.3>
			scale <7.5,1.8,1.2>
			translate <8,0,1.6>
			texture { SeatFabric }
		}
	} // end union
#declare SeatFrameOuter =
	union {
		box { // back leg
			<0,-1.4,0>,<2,0,18>
			rotate <0,18,0>
			translate <-5,-10,0>
		}
		difference {
			box { // front leg
				<0,-1.4,0>,<4,0,14>
				translate <8,-12,0>
			}
			box { // front leg cutout
				<0.6,-2,0.6>,<3.4,1,12>
				translate <8,-12,0>
			}
		} // end difference
		superellipsoid { // frame lower
			<.2,.2>
			scale <8,1.0,3.5>
			translate <7,-12.4,14>
		}
		superellipsoid { // frame upper
			<.2,.2>
			scale <2,1.0,3.5>
			rotate <0,-12,0>
			translate <2,-12.4,17>
		}
		texture { SeatFrameTex }
	} // end union
#declare MainSeat =
	union {
		object { SeatBack rotate <0,-8,0> translate <0,0,16> }
		object { SeatBottom rotate <0,-4,0> translate <0,0,12> }
		object { SeatArm rotate <0,-4,0> translate <0,-12,21> }
		object { SeatArm rotate <0,-4,0> translate <0, 12,21> }
	} // end union

#declare WindowSeat =
	union  {
//		object { MainSeat } // aisle seat
//		object { SeatFrameOuter } // aisle seat frame
		object { MainSeat translate <0,27.5,0> } // window seat
		object { SeatFrameOuter scale <1,-1,1> translate <0,27.5,0> } // window seat frame
		object { SeatFrameOuter translate <0,27.5,0> } // window seat frame
	} // end union

#declare DoubleSeat =
	union  {
		object { MainSeat } // aisle seat
		object { SeatFrameOuter } // aisle seat frame
		object { SeatFrameOuter translate <0,27.5,0> } // middle frame
		object { MainSeat translate <0,27.5,0> } // window seat
		object { SeatFrameOuter scale <1,-1,1> translate <0,27.5,0> } // window seat frame
	} // end union

#declare MissingSeat =
	union  {
		object { SeatFrameOuter } // aisle seat frame
		object { SeatFrameOuter translate <0,27.5,0> } // middle frame
		clipped_by { box { <-30,-30,-30>,<30,30,30> rotate <6,14,0> translate <0,0,-24> } }
	} // end union

//===============================================
//             For Testing Only
//===============================================
/*
#include "GIncludeRH.inc"
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 50
		location  <4*Feet, -7*Feet, 4.8*Feet>
		look_at <1.4*Feet, 1.4*Feet, 1.8*Feet>
	}


light_source
{ <10*Feet,-5*Feet,10*Feet>, 2
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .5 } scale 3 }

object { DoubleSeat }
//object { DoubleSeat rotate z*-75 translate <3*Feet,3*Feet,0> }
*/
