
// POV-Ray Object File - Junk
// created 28-Oct-99
// last update 28-Oct-99
// 1999 Glenn McCarter
// This file does not render.  #include "Junk.inc" in another .pov file
// Required #include files: all Winseat files first, before this file
//
// Objects available:
// SeatBack, SeatBottom, SeatArm, SeatFrameOuter,
// TWheelS, WindshieldS,
// WindowCutout, WindowShades, FloorBulkhead, Ceiling, TopSpar, BHole,
// OverheadCabinUnit, OverheadDoorClosed,
// Skid, TireS, HalfRim
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)


//===============================================
//             Variables
//===============================================

// behind wheel
#declare BW = <1*Feet,21*Feet,12>;
#declare LOT = <23*Feet,120*Feet,12>;
#declare INHL = <24*Feet,26*Feet,5>;

//===============================================
//             Textures
//===============================================



//===============================================
//             Objects
//===============================================

#include "Jawbone.inc"
#declare JawboneGroup =
	union {
		object { JawboneShape
			scale 2.0*Feet
			texture { JawboneTex }
		}
		difference {
			superellipsoid {
				<.4,.6>
				scale <10,7,7>
			}
			superellipsoid {
				<.4,.6>
				scale <10,7,7>
				translate <1,1,1>
			}
			rotate <14,3,-63>
			translate <3,13,-3>
			texture { Jawbone2Tex }
		} // end difference
	} // end union

#declare LeftCurve =
	difference {
		object {
			CurveTube(28,1.8,90)
			texture { Jawbone2Tex }
			rotate <90,0,-10>
			translate <-38,-36,26.7>
		}
		object {
			CurveTube(28,1.2,95)
			texture { Jawbone2Tex }
			rotate <90,0,-10>
			translate <-38,-36,26.7>
		}
	} // end difference

#declare LTeethBlocker =
	union {
		difference {
			superellipsoid {
				<.4,.8>
				scale <24,9,16>
			}
			superellipsoid {
				<.4,.8>
				scale <24,9,16>
				translate <1,-1,1>
			}
		} // end difference
		box { <0,-5,-24>,<1,8,14> translate <7,0,0> }
		box { <0,-5,-24>,<1,8,14> translate <-7,0,0> }
		difference {
			cylinder { <0,0,0>,<20,0,0>,6 }
			cylinder { <-21,0,0>,<21,0,0>,5.3 }
		} // end difference
		rotate <-4,-3,-38>
		translate <-10,-13*Feet,2*Feet>
		texture { AlumSkinTex }
	} // end union

#declare RoundJaw =
	superellipsoid {
		<.4,.8>
		scale <4,6,3>*1
		rotate <21,53,125>
		translate <32,-13.8*Feet,16>
		texture { FloorPipeTex }
	}

#declare BlockerBox =
	box {
		<-6*Feet,0,0>,<6*Feet,8,36>
		texture { CabinTex }
	}
#declare SkinCutter =
	height_field {
		png "FusCutterHF01.png"
		scale <4*Feet,4*Feet,4*Feet> // scale it up, Y-scale sets max height
		translate <0*Feet,0*Feet,-2.5*Feet> //
//		texture { AlumSkinTex }
	}
#declare BlockerSkin2 =
//	intersection {
	difference {


		cylinder {
			<-9*Feet,0,0>,<8*Feet,0,0>,6.5*Feet
			texture { AlumSkinTex }
		}
		object { SkinCutter rotate x*180 translate <0,8*Feet,0> texture { AlumSkinTex } }
		cylinder {
			<-9*Feet-1,0,0>,<8*Feet+1,0,0>,6.45*Feet
//			inverse
			texture { AlumSkinTex }
		}
		box {
			<0,0,0>,<8*Feet,5*Feet,5*Feet>
//			translate <0,4*Feet,0>
			translate <0,-4*Feet,0>
			texture { AlumSkinTex }
		}

//		clipped_by { object { SkinCutter rotate x*180 translate <0,8*Feet,0> } }
		translate <0,-6*Feet,20>
	} // end intersection

#declare BlockerSkin =
//union {
	difference {
		superellipsoid {
			<.6,.6>
			scale <31,17,17>
		}
		superellipsoid {
			<.6,.6>
			scale <31,17,17>
			translate <2,2,2>
		}
		object { SkinCutter rotate x*180 translate <-24,2*Feet,0> }
		texture { AlumSkinTex }
	} // end difference
#declare JunkGroup =
	union {
		// fuselage stuff
		object { LeftCurve }
		object { LTeethBlocker }
		object { RoundJaw }
		object { JawboneGroup translate <0,0,0*Feet> rotate <0,-0,-0> translate <2*Feet,-13*Feet,2*Feet> }
		object { BlockerSkin rotate <0,0,-45> translate <7.4*Feet,-8.5*Feet,26> }

		// behind wheel
//		object { WindshieldS rotate <23,33,74> translate BW }

		// left of truck
		object { OverheadCabinUnit rotate <198,36,15> translate LOT }

		// in headlights
		object { FloorBulkhead rotate <3,-13,194> translate INHL }

	} // end union
