#macro Rock13 (SIZE,COMPLEXITY,RAND)

	#declare R13_Rand 	= seed(RAND);
	#local THRESHOLD 	= .75;
	#local Rad1			= ((SIZE * 2) / THRESHOLD);
	
	blob {
		threshold THRESHOLD
		
		sphere {<0,0,0>,Rad1,1}
		
		#local Count1 = 0;
		#while (Count1 < COMPLEXITY) 
		
			#local Power = rand(R13_Rand);
			#if (Power > .5) #local Rad2 = (Rad1 * .35); #local Sign = 1; #else #local Rad2 = (Rad1 * .75); #local Sign = -1; #end
			#local P2 = <0,Rad2,0>;
			
			sphere {P2,SIZE,Sign rotate <(rand(R13_Rand) * 360),(rand(R13_Rand) * 360),(rand(R13_Rand) * 360)> }
			
			#local Count1 = (Count1 + 1);
		#end  
		
		scale <1,.5,1> 
	}

#end

#macro Mound13 (SIZE,COMPLEXITY,RAND,RADIUS,HEIGHT)

	#declare R13_Rand 	= seed(RAND);
	#local THRESHOLD 	= .75;
	#local Rad1			= ((SIZE * 2) / THRESHOLD);
	
	blob {
		threshold THRESHOLD
		
		sphere {<0,0,0>,Rad1,1}
		
		#local Count1 = 0;
		#while (Count1 < COMPLEXITY) 
		
			#local Power = rand(R13_Rand);
			#if (Power > .5) #local Rad2 = (Rad1 * .35); #local Sign = 1; #else #local Rad2 = (Rad1 * .75); #local Sign = -1; #end
			#local P2 = <0,Rad2,0>;
			
			sphere {P2,SIZE,Sign rotate <(rand(R13_Rand) * 360),(rand(R13_Rand) * 360),(rand(R13_Rand) * 360)> }
			
			#local Count1 = (Count1 + 1);
		#end  
		
		scale <RADIUS,HEIGHT,RADIUS> 
	}

#end   


// eof

