// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare Grassy_plant = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.00237, 0.1804, -0.003742>, 0.2749 }
		cylinder { <-0.00237, 0.1804, -0.003742>, <-0.007109, 0.3607, -0.01122>, 0.2749 }
		cylinder { <-0.007109, 0.3607, -0.01122>, <-0.01421, 0.5408, -0.02244>, 0.2749 }
		texture{Grass_Texture1}}
	union { // internode
		cylinder { <-0.01421, 0.5408, -0.02244>, <-0.04449, 1.1909, -0.04764>, 0.9918 }
		cylinder { <-0.04449, 1.1909, -0.04764>, <-0.0794, 1.8412, -0.05754>, 0.9918 }
		cylinder { <-0.0794, 1.8412, -0.05754>, <-0.1189, 2.4914, -0.05213>, 0.9918 }
		texture{Grass_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1189, 2.4914, -0.05213>, <-0.1568, 3.1149, -0.04694>, 0.9512 }
			cylinder { <-0.1568, 3.1149, -0.04694>, <-0.1947, 3.7384, -0.04175>, 0.9512 }
			cylinder { <-0.1947, 3.7384, -0.04175>, <-0.2326, 4.3619, -0.03656>, 0.9512 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.2326, 4.3619, -0.03656>, <-1.9724, 21.1578, -0.4837>, <-0.9555, 21.4396, 0.1514> }
			triangle { <-1.9724, 21.1578, -0.4837>, <-3.8191, 30.7252, 0.5365>, <-0.9555, 21.4396, 0.1514> }
			triangle { <-3.8191, 30.7252, 0.5365>, <-2.8343, 30.7772, 1.4845>, <-0.9555, 21.4396, 0.1514> }
			triangle { <-3.8191, 30.7252, 0.5365>, <-12.3797, 59.2087, 7.8142>, <-2.8343, 30.7772, 1.4845> }
			triangle { <-2.8343, 30.7772, 1.4845>, <-12.3797, 59.2087, 7.8142>, <-1.8359, 30.6047, 2.4306> }
			triangle { <-0.9555, 21.4396, 0.1514>, <-2.8343, 30.7772, 1.4845>, <-1.8359, 30.6047, 2.4306> }
			triangle { <-0.9555, 21.4396, 0.1514>, <-1.8359, 30.6047, 2.4306>, <-0.09122, 21.2605, 0.9172> }
			triangle { <-0.9555, 21.4396, 0.1514>, <-0.09122, 21.2605, 0.9172>, <-0.2326, 4.3619, -0.03656> }
			triangle { <-17.8614, 73.4769, 13.04642>, <-12.3797, 59.2087, 7.8142>, <-14.1727, 59.1073, 6.9083> }
			triangle { <-1.8359, 30.6047, 2.4306>, <-12.3797, 59.2087, 7.8142>, <-11.2643, 59.2578, 10.06701> }
			triangle { <-3.8191, 30.7252, 0.5365>, <-14.1727, 59.1073, 6.9083>, <-12.3797, 59.2087, 7.8142> }
			triangle { <-17.8614, 73.4769, 13.04642>, <-11.2643, 59.2578, 10.06701>, <-12.3797, 59.2087, 7.8142> }
			texture{Grass_Texture3}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1189, 2.4914, -0.05213>, <-0.1568, 3.1149, -0.04694>, 0.9512 }
			cylinder { <-0.1568, 3.1149, -0.04694>, <-0.1947, 3.7384, -0.04175>, 0.9512 }
			cylinder { <-0.1947, 3.7384, -0.04175>, <-0.2326, 4.3619, -0.03656>, 0.9512 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.2326, 4.3619, -0.03656>, <-0.5394, 21.2351, 0.6907>, <-1.5837, 21.4022, 0.05925> }
			triangle { <-0.5394, 21.2351, 0.6907>, <0.1337, 30.9714, -0.1689>, <-1.5837, 21.4022, 0.05925> }
			triangle { <0.1337, 30.9714, -0.1689>, <-0.851, 30.9194, -1.1169>, <-1.5837, 21.4022, 0.05925> }
			triangle { <0.1337, 30.9714, -0.1689>, <5.174, 60.3988, -6.9648>, <-0.851, 30.9194, -1.1169> }
			triangle { <-0.851, 30.9194, -1.1169>, <5.174, 60.3988, -6.9648>, <-1.8221, 30.6429, -2.06681> }
			triangle { <-1.5837, 21.4022, 0.05925>, <-0.851, 30.9194, -1.1169>, <-1.8221, 30.6429, -2.06681> }
			triangle { <-1.5837, 21.4022, 0.05925>, <-1.8221, 30.6429, -2.06681>, <-2.4207, 21.1324, -0.7102> }
			triangle { <-1.5837, 21.4022, 0.05925>, <-2.4207, 21.1324, -0.7102>, <-0.2326, 4.3619, -0.03656> }
			triangle { <8.8819, 75.3105, -11.9542>, <5.174, 60.3988, -6.9648>, <6.967, 60.5002, -6.05898> }
			triangle { <-1.8221, 30.6429, -2.06681>, <5.174, 60.3988, -6.9648>, <4.05856, 60.3497, -9.2176> }
			triangle { <0.1337, 30.9714, -0.1689>, <6.967, 60.5002, -6.05898>, <5.174, 60.3988, -6.9648> }
			triangle { <8.8819, 75.3105, -11.9542>, <4.05856, 60.3497, -9.2176>, <5.174, 60.3988, -6.9648> }
			texture{Grass_Texture3}}
		}
	union { // internode
		cylinder { <-0.1189, 2.4914, -0.05213>, <-0.144, 3.1475, -0.05323>, 1.0 }
		cylinder { <-0.144, 3.1475, -0.05323>, <-0.1544, 3.8041, -0.0609>, 1.0 }
		cylinder { <-0.1544, 3.8041, -0.0609>, <-0.1501, 4.4606, -0.07511>, 1.0 }
		texture{Grass_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1501, 4.4606, -0.07511>, <-0.146, 5.09936, -0.08894>, 0.9729 }
			cylinder { <-0.146, 5.09936, -0.08894>, <-0.1418, 5.738, -0.1027>, 0.9729 }
			cylinder { <-0.1418, 5.738, -0.1027>, <-0.1376, 6.3768, -0.1166>, 0.9729 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.1376, 6.3768, -0.1166>, <-0.0003823, 23.6427, 0.4577>, <-0.1975, 23.8475, -0.7695> }
			triangle { <-0.0003823, 23.6427, 0.4577>, <1.6357, 33.5275, 0.5941>, <-0.1975, 23.8475, -0.7695> }
			triangle { <1.6357, 33.5275, 0.5941>, <1.7116, 33.4967, -0.8024>, <-0.1975, 23.8475, -0.7695> }
			triangle { <1.6357, 33.5275, 0.5941>, <11.8332, 63.137, 0.5341>, <1.7116, 33.4967, -0.8024> }
			triangle { <1.7116, 33.4967, -0.8024>, <11.8332, 63.137, 0.5341>, <1.7859, 33.2361, -2.1941> }
			triangle { <-0.1975, 23.8475, -0.7695>, <1.7116, 33.4967, -0.8024>, <1.7859, 33.2361, -2.1941> }
			triangle { <-0.1975, 23.8475, -0.7695>, <1.7859, 33.2361, -2.1941>, <-0.1732, 23.592, -1.9367> }
			triangle { <-0.1975, 23.8475, -0.7695>, <-0.1732, 23.592, -1.9367>, <-0.1376, 6.3768, -0.1166> }
			triangle { <18.9659, 78.04047, 0.3662>, <11.8332, 63.137, 0.5341>, <12.3307, 63.1769, 2.5298> }
			triangle { <1.7859, 33.2361, -2.1941>, <11.8332, 63.137, 0.5341>, <12.8328, 63.07917, -1.8343> }
			triangle { <1.6357, 33.5275, 0.5941>, <12.3307, 63.1769, 2.5298>, <11.8332, 63.137, 0.5341> }
			triangle { <18.9659, 78.04047, 0.3662>, <12.8328, 63.07917, -1.8343>, <11.8332, 63.137, 0.5341> }
			texture{Grass_Texture3}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.1501, 4.4606, -0.07511>, <-0.146, 5.09936, -0.08894>, 0.9729 }
			cylinder { <-0.146, 5.09936, -0.08894>, <-0.1418, 5.738, -0.1027>, 0.9729 }
			cylinder { <-0.1418, 5.738, -0.1027>, <-0.1376, 6.3768, -0.1166>, 0.9729 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.1376, 6.3768, -0.1166>, <-0.04888, 23.602, -1.4378>, <0.1512, 23.8571, -0.2205> }
			triangle { <-0.04888, 23.602, -1.4378>, <-1.5554, 33.4922, -2.002524>, <0.1512, 23.8571, -0.2205> }
			triangle { <-1.5554, 33.4922, -2.002524>, <-1.6313, 33.5229, -0.6058>, <0.1512, 23.8571, -0.2205> }
			triangle { <-1.5554, 33.4922, -2.002524>, <-11.3642, 63.2075, -3.2272>, <-1.6313, 33.5229, -0.6058> }
			triangle { <-1.6313, 33.5229, -0.6058>, <-11.3642, 63.2075, -3.2272>, <-1.7087, 33.3237, 0.7957> }
			triangle { <0.1512, 23.8571, -0.2205>, <-1.6313, 33.5229, -0.6058>, <-1.7087, 33.3237, 0.7957> }
			triangle { <0.1512, 23.8571, -0.2205>, <-1.7087, 33.3237, 0.7957>, <0.1239, 23.6527, 0.9566> }
			triangle { <0.1512, 23.8571, -0.2205>, <0.1239, 23.6527, 0.9566>, <-0.1376, 6.3768, -0.1166> }
			triangle { <-18.301, 78.1964, -3.7067>, <-11.3642, 63.2075, -3.2272>, <-11.8617, 63.1675, -5.2229> }
			triangle { <-1.7087, 33.3237, 0.7957>, <-11.3642, 63.2075, -3.2272>, <-12.3638, 63.2654, -0.8587> }
			triangle { <-1.5554, 33.4922, -2.002524>, <-11.8617, 63.1675, -5.2229>, <-11.3642, 63.2075, -3.2272> }
			triangle { <-18.301, 78.1964, -3.7067>, <-12.3638, 63.2654, -0.8587>, <-11.3642, 63.2075, -3.2272> }
			texture{Grass_Texture3}}
		}
	union { // internode
		cylinder { <-0.1501, 4.4606, -0.07511>, <-0.175, 5.1162, -0.103>, 1.0 }
		cylinder { <-0.175, 5.1162, -0.103>, <-0.2289, 5.7693, -0.1446>, 1.0 }
		cylinder { <-0.2289, 5.7693, -0.1446>, <-0.3118, 6.4184, -0.1997>, 1.0 }
		texture{Grass_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.3118, 6.4184, -0.1997>, <-0.3914, 7.04093, -0.2526>, 0.959 }
			cylinder { <-0.3914, 7.04093, -0.2526>, <-0.4709, 7.6634, -0.3055>, 0.959 }
			cylinder { <-0.4709, 7.6634, -0.3055>, <-0.5504, 8.2859, -0.3583>, 0.959 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.5504, 8.2859, -0.3583>, <-2.008428, 25.1276, -2.417>, <-2.8188, 25.3314, -1.4985> }
			triangle { <-2.008428, 25.1276, -2.417>, <-3.9782, 34.5514, -4.6238>, <-2.8188, 25.3314, -1.4985> }
			triangle { <-3.9782, 34.5514, -4.6238>, <-5.06418, 34.4847, -3.7764>, <-2.8188, 25.3314, -1.4985> }
			triangle { <-3.9782, 34.5514, -4.6238>, <-13.6, 62.04261, -14.8506>, <-5.06418, 34.4847, -3.7764> }
			triangle { <-5.06418, 34.4847, -3.7764>, <-13.6, 62.04261, -14.8506>, <-6.1215, 34.1939, -2.91> }
			triangle { <-2.8188, 25.3314, -1.4985>, <-5.06418, 34.4847, -3.7764>, <-6.1215, 34.1939, -2.91> }
			triangle { <-2.8188, 25.3314, -1.4985>, <-6.1215, 34.1939, -2.91>, <-3.6776, 25.05682, -0.7402> }
			triangle { <-2.8188, 25.3314, -1.4985>, <-3.6776, 25.05682, -0.7402>, <-0.5504, 8.2859, -0.3583> }
			triangle { <-19.819, 75.6019, -21.389>, <-13.6, 62.04261, -14.8506>, <-12.4335, 62.05072, -16.5093> }
			triangle { <-6.1215, 34.1939, -2.91>, <-13.6, 62.04261, -14.8506>, <-15.9956, 61.804, -14.05744> }
			triangle { <-3.9782, 34.5514, -4.6238>, <-12.4335, 62.05072, -16.5093>, <-13.6, 62.04261, -14.8506> }
			triangle { <-19.819, 75.6019, -21.389>, <-15.9956, 61.804, -14.05744>, <-13.6, 62.04261, -14.8506> }
			texture{Grass_Texture3}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.3118, 6.4184, -0.1997>, <-0.3914, 7.04093, -0.2526>, 0.959 }
			cylinder { <-0.3914, 7.04093, -0.2526>, <-0.4709, 7.6634, -0.3055>, 0.959 }
			cylinder { <-0.4709, 7.6634, -0.3055>, <-0.5504, 8.2859, -0.3583>, 0.959 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.5504, 8.2859, -0.3583>, <-3.386, 25.05884, -1.1549>, <-2.6328, 25.3031, -2.1115> }
			triangle { <-3.386, 25.05884, -1.1549>, <-3.8779, 34.9073, -0.585>, <-2.6328, 25.3031, -2.1115> }
			triangle { <-3.8779, 34.9073, -0.585>, <-2.7919, 34.974, -1.4324>, <-2.6328, 25.3031, -2.1115> }
			triangle { <-3.8779, 34.9073, -0.585>, <-1.6411, 65.2333, 4.7307>, <-2.7919, 34.974, -1.4324> }
			triangle { <-2.7919, 34.974, -1.4324>, <-1.6411, 65.2333, 4.7307>, <-1.6773, 34.8167, -2.2607> }
			triangle { <-2.6328, 25.3031, -2.1115>, <-2.7919, 34.974, -1.4324>, <-1.6773, 34.8167, -2.2607> }
			triangle { <-2.6328, 25.3031, -2.1115>, <-1.6773, 34.8167, -2.2607>, <-1.7168, 25.1296, -2.8316> }
			triangle { <-2.6328, 25.3031, -2.1115>, <-1.7168, 25.1296, -2.8316>, <-0.5504, 8.2859, -0.3583> }
			triangle { <0.8567, 80.8066, 8.7946>, <-1.6411, 65.2333, 4.7307>, <-2.8075, 65.2252, 6.3895> }
			triangle { <-1.6773, 34.8167, -2.2607>, <-1.6411, 65.2333, 4.7307>, <0.7545, 65.4719, 3.9375> }
			triangle { <-3.8779, 34.9073, -0.585>, <-2.8075, 65.2252, 6.3895>, <-1.6411, 65.2333, 4.7307> }
			triangle { <0.8567, 80.8066, 8.7946>, <0.7545, 65.4719, 3.9375>, <-1.6411, 65.2333, 4.7307> }
			texture{Grass_Texture3}}
		}
	union { // internode
		cylinder { <-0.3118, 6.4184, -0.1997>, <-0.3862, 7.07043, -0.2239>, 1.0 }
		cylinder { <-0.3862, 7.07043, -0.2239>, <-0.4518, 7.7237, -0.2171>, 1.0 }
		cylinder { <-0.4518, 7.7237, -0.2171>, <-0.5085, 8.3768, -0.1793>, 1.0 }
		texture{Grass_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.5085, 8.3768, -0.1793>, <-0.5591, 8.9594, -0.1456>, 0.8919 }
			cylinder { <-0.5591, 8.9594, -0.1456>, <-0.6097, 9.542, -0.1119>, 0.8919 }
			cylinder { <-0.6097, 9.542, -0.1119>, <-0.6603, 10.1245, -0.07827>, 0.8919 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.6603, 10.1245, -0.07827>, <-2.8874, 25.7847, 0.7317>, <-1.7747, 26.09402, 0.7209> }
			triangle { <-2.8874, 25.7847, 0.7317>, <-4.1822, 34.6785, 2.6324>, <-1.7747, 26.09402, 0.7209> }
			triangle { <-4.1822, 34.6785, 2.6324>, <-2.9274, 34.7732, 2.8806>, <-1.7747, 26.09402, 0.7209> }
			triangle { <-4.1822, 34.6785, 2.6324>, <-8.2955, 61.05951, 13.1877>, <-2.9274, 34.7732, 2.8806> }
			triangle { <-2.9274, 34.7732, 2.8806>, <-8.2955, 61.05951, 13.1877>, <-1.6544, 34.6581, 3.1168> }
			triangle { <-1.7747, 26.09402, 0.7209>, <-2.9274, 34.7732, 2.8806>, <-1.6544, 34.6581, 3.1168> }
			triangle { <-1.7747, 26.09402, 0.7209>, <-1.6544, 34.6581, 3.1168>, <-0.6987, 25.9661, 0.8828> }
			triangle { <-1.7747, 26.09402, 0.7209>, <-0.6987, 25.9661, 0.8828>, <-0.6603, 10.1245, -0.07827> }
			triangle { <-10.49, 74.236, 20.3315>, <-8.2955, 61.05951, 13.1877>, <-10.1635, 60.886, 13.382> }
			triangle { <-1.6544, 34.6581, 3.1168>, <-8.2955, 61.05951, 13.1877>, <-6.2752, 61.1649, 14.398> }
			triangle { <-4.1822, 34.6785, 2.6324>, <-10.1635, 60.886, 13.382>, <-8.2955, 61.05951, 13.1877> }
			triangle { <-10.49, 74.236, 20.3315>, <-6.2752, 61.1649, 14.398>, <-8.2955, 61.05951, 13.1877> }
			texture{Grass_Texture3}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.5085, 8.3768, -0.1793>, <-0.5591, 8.9594, -0.1456>, 0.8919 }
			cylinder { <-0.5591, 8.9594, -0.1456>, <-0.6097, 9.542, -0.1119>, 0.8919 }
			cylinder { <-0.6097, 9.542, -0.1119>, <-0.6603, 10.1245, -0.07827>, 0.8919 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.6603, 10.1245, -0.07827>, <-1.1656, 25.9227, 0.9314>, <-2.3148, 26.0329, 0.9665> }
			triangle { <-1.1656, 25.9227, 0.9314>, <-1.4374, 35.06499, 0.07413>, <-2.3148, 26.0329, 0.9665> }
			triangle { <-1.4374, 35.06499, 0.07413>, <-2.6922, 34.9703, -0.1741>, <-2.3148, 26.0329, 0.9665> }
			triangle { <-1.4374, 35.06499, 0.07413>, <-2.02387, 62.7923, -7.3512>, <-2.6922, 34.9703, -0.1741> }
			triangle { <-2.6922, 34.9703, -0.1741>, <-2.02387, 62.7923, -7.3512>, <-3.9288, 34.666, -0.4345> }
			triangle { <-2.3148, 26.0329, 0.9665>, <-2.6922, 34.9703, -0.1741>, <-3.9288, 34.666, -0.4345> }
			triangle { <-2.3148, 26.0329, 0.9665>, <-3.9288, 34.666, -0.4345>, <-3.3544, 25.7413, 0.7803> }
			triangle { <-2.3148, 26.0329, 0.9665>, <-3.3544, 25.7413, 0.7803>, <-0.6603, 10.1245, -0.07827> }
			triangle { <-2.1974, 76.8796, -12.9178>, <-2.02387, 62.7923, -7.3512>, <-0.1559, 62.9658, -7.5455> }
			triangle { <-3.9288, 34.666, -0.4345>, <-2.02387, 62.7923, -7.3512>, <-4.04422, 62.6869, -8.5615> }
			triangle { <-1.4374, 35.06499, 0.07413>, <-0.1559, 62.9658, -7.5455>, <-2.02387, 62.7923, -7.3512> }
			triangle { <-2.1974, 76.8796, -12.9178>, <-4.04422, 62.6869, -8.5615>, <-2.02387, 62.7923, -7.3512> }
			texture{Grass_Texture3}}
		}
	union { // internode
		cylinder { <-0.5085, 8.3768, -0.1793>, <-0.5477, 9.0323, -0.1685>, 1.0 }
		cylinder { <-0.5477, 9.0323, -0.1685>, <-0.5692, 9.6884, -0.1846>, 1.0 }
		cylinder { <-0.5692, 9.6884, -0.1846>, <-0.573, 10.3436, -0.2276>, 1.0 }
		texture{Grass_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.573, 10.3436, -0.2276>, <-0.5758, 10.8122, -0.2584>, 0.7151 }
			cylinder { <-0.5758, 10.8122, -0.2584>, <-0.5785, 11.2808, -0.2892>, 0.7151 }
			cylinder { <-0.5785, 11.2808, -0.2892>, <-0.5812, 11.7494, -0.3199>, 0.7151 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.5812, 11.7494, -0.3199>, <-0.2638, 24.4419, -0.5752>, <-0.8728, 24.5626, -1.2622> }
			triangle { <-0.2638, 24.4419, -0.5752>, <0.8052, 31.6757, -1.4578>, <-0.8728, 24.5626, -1.2622> }
			triangle { <0.8052, 31.6757, -1.4578>, <0.2979, 31.6141, -2.3502>, <-0.8728, 24.5626, -1.2622> }
			triangle { <0.8052, 31.6757, -1.4578>, <7.09879, 53.2385, -6.4912>, <0.2979, 31.6141, -2.3502> }
			triangle { <0.2979, 31.6141, -2.3502>, <7.09879, 53.2385, -6.4912>, <-0.2084, 31.3839, -3.2315> }
			triangle { <-0.8728, 24.5626, -1.2622>, <0.2979, 31.6141, -2.3502>, <-0.2084, 31.3839, -3.2315> }
			triangle { <-0.8728, 24.5626, -1.2622>, <-0.2084, 31.3839, -3.2315>, <-1.321, 24.3431, -1.9852> }
			triangle { <-0.8728, 24.5626, -1.2622>, <-1.321, 24.3431, -1.9852>, <-0.5812, 11.7494, -0.3199> }
			triangle { <11.4493, 64.05288, -9.9027>, <7.09879, 53.2385, -6.4912>, <8.1986, 53.3129, -5.456> }
			triangle { <-0.2084, 31.3839, -3.2315>, <7.09879, 53.2385, -6.4912>, <6.7772, 53.1146, -8.3497> }
			triangle { <0.8052, 31.6757, -1.4578>, <8.1986, 53.3129, -5.456>, <7.09879, 53.2385, -6.4912> }
			triangle { <11.4493, 64.05288, -9.9027>, <6.7772, 53.1146, -8.3497>, <7.09879, 53.2385, -6.4912> }
			texture{Grass_Texture3}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.573, 10.3436, -0.2276>, <-0.5758, 10.8122, -0.2584>, 0.7151 }
			cylinder { <-0.5758, 10.8122, -0.2584>, <-0.5785, 11.2808, -0.2892>, 0.7151 }
			cylinder { <-0.5785, 11.2808, -0.2892>, <-0.5812, 11.7494, -0.3199>, 0.7151 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.5812, 11.7494, -0.3199>, <-1.04612, 24.3617, -1.7264>, <-0.439, 24.5784, -1.06155> }
			triangle { <-1.04612, 24.3617, -1.7264>, <-2.1997, 31.636, -1.7965>, <-0.439, 24.5784, -1.06155> }
			triangle { <-2.1997, 31.636, -1.7965>, <-1.6923, 31.6975, -0.9041>, <-0.439, 24.5784, -1.06155> }
			triangle { <-2.1997, 31.636, -1.7965>, <-8.7467, 53.5973, 0.3786>, <-1.6923, 31.6975, -0.9041> }
			triangle { <-1.6923, 31.6975, -0.9041>, <-8.7467, 53.5973, 0.3786>, <-1.184, 31.5904, -0.0006891> }
			triangle { <-0.439, 24.5784, -1.06155>, <-1.6923, 31.6975, -0.9041>, <-1.184, 31.5904, -0.0006891> }
			triangle { <-0.439, 24.5784, -1.06155>, <-1.184, 31.5904, -0.0006891>, <0.01113, 24.4605, -0.3164> }
			triangle { <-0.439, 24.5784, -1.06155>, <0.01113, 24.4605, -0.3164>, <-0.5812, 11.7494, -0.3199> }
			triangle { <-13.225, 64.7137, 2.3499>, <-8.7467, 53.5973, 0.3786>, <-9.8465, 53.5229, -0.6564> }
			triangle { <-1.184, 31.5904, -0.0006891>, <-8.7467, 53.5973, 0.3786>, <-8.4252, 53.7212, 2.2371> }
			triangle { <-2.1997, 31.636, -1.7965>, <-9.8465, 53.5229, -0.6564>, <-8.7467, 53.5973, 0.3786> }
			triangle { <-13.225, 64.7137, 2.3499>, <-8.4252, 53.7212, 2.2371>, <-8.7467, 53.5973, 0.3786> }
			texture{Grass_Texture3}}
		}
	union { // internode
		cylinder { <-0.573, 10.3436, -0.2276>, <-0.5888, 10.8652, -0.2602>, 0.7961 }
		cylinder { <-0.5888, 10.8652, -0.2602>, <-0.6173, 11.3863, -0.2911>, 0.7961 }
		cylinder { <-0.6173, 11.3863, -0.2911>, <-0.6584, 11.9067, -0.3203>, 0.7961 }
		texture{Grass_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.6584, 11.9067, -0.3203>, <-0.6782, 12.156, -0.3343>, 0.3814 }
			cylinder { <-0.6782, 12.156, -0.3343>, <-0.6979, 12.4053, -0.3482>, 0.3814 }
			cylinder { <-0.6979, 12.4053, -0.3482>, <-0.7176, 12.6546, -0.3622>, 0.3814 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.7176, 12.6546, -0.3622>, <-1.1539, 19.3739, -1.09865>, <-1.2224, 19.4858, -0.6224> }
			triangle { <-1.1539, 19.3739, -1.09865>, <-2.009098, 23.173, -1.6191>, <-1.2224, 19.4858, -0.6224> }
			triangle { <-2.009098, 23.173, -1.6191>, <-2.1928, 23.1874, -1.1024>, <-1.2224, 19.4858, -0.6224> }
			triangle { <-2.009098, 23.173, -1.6191>, <-6.6088, 34.3865, -3.584>, <-2.1928, 23.1874, -1.1024> }
			triangle { <-2.1928, 23.1874, -1.1024>, <-6.6088, 34.3865, -3.584>, <-2.3694, 23.1121, -0.5808> }
			triangle { <-1.2224, 19.4858, -0.6224>, <-2.1928, 23.1874, -1.1024>, <-2.3694, 23.1121, -0.5808> }
			triangle { <-1.2224, 19.4858, -0.6224>, <-2.3694, 23.1121, -0.5808>, <-1.3554, 19.4095, -0.1796> }
			triangle { <-1.2224, 19.4858, -0.6224>, <-1.3554, 19.4095, -0.1796>, <-0.7176, 12.6546, -0.3622> }
			triangle { <-9.6893, 39.967, -4.7411>, <-6.6088, 34.3865, -3.584>, <-6.5733, 34.3441, -4.3887> }
			triangle { <-2.3694, 23.1121, -0.5808>, <-6.6088, 34.3865, -3.584>, <-7.2468, 34.3798, -2.8034> }
			triangle { <-2.009098, 23.173, -1.6191>, <-6.5733, 34.3441, -4.3887>, <-6.6088, 34.3865, -3.584> }
			triangle { <-9.6893, 39.967, -4.7411>, <-7.2468, 34.3798, -2.8034>, <-6.6088, 34.3865, -3.584> }
			texture{Grass_Texture3}}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.6584, 11.9067, -0.3203>, <-0.6782, 12.156, -0.3343>, 0.3814 }
			cylinder { <-0.6782, 12.156, -0.3343>, <-0.6979, 12.4053, -0.3482>, 0.3814 }
			cylinder { <-0.6979, 12.4053, -0.3482>, <-0.7176, 12.6546, -0.3622>, 0.3814 }
			texture{Grass_Texture2}}
		mesh { // leaf
			triangle { <-0.7176, 12.6546, -0.3622>, <-1.3465, 19.3989, -0.3808>, <-1.2921, 19.4666, -0.867> }
			triangle { <-1.3465, 19.3989, -0.3808>, <-1.1019, 23.3191, -0.2932>, <-1.2921, 19.4666, -0.867> }
			triangle { <-1.1019, 23.3191, -0.2932>, <-0.9182, 23.3046, -0.8098>, <-1.2921, 19.4666, -0.867> }
			triangle { <-1.1019, 23.3191, -0.2932>, <1.6658, 35.263, 0.3732>, <-0.9182, 23.3046, -0.8098> }
			triangle { <-0.9182, 23.3046, -0.8098>, <1.6658, 35.263, 0.3732>, <-0.7273, 23.2004, -1.3214> }
			triangle { <-1.2921, 19.4666, -0.867>, <-0.9182, 23.3046, -0.8098>, <-0.7273, 23.2004, -1.3214> }
			triangle { <-1.2921, 19.4666, -0.867>, <-0.7273, 23.2004, -1.3214>, <-1.145, 19.3634, -1.2998> }
			triangle { <-1.2921, 19.4666, -0.867>, <-1.145, 19.3634, -1.2998>, <-0.7176, 12.6546, -0.3622> }
			triangle { <3.8232, 41.3509, 0.8759>, <1.6658, 35.263, 0.3732>, <1.6303, 35.3053, 1.1778> }
			triangle { <-0.7273, 23.2004, -1.3214>, <1.6658, 35.263, 0.3732>, <2.3038, 35.2697, -0.4074> }
			triangle { <-1.1019, 23.3191, -0.2932>, <1.6303, 35.3053, 1.1778>, <1.6658, 35.263, 0.3732> }
			triangle { <3.8232, 41.3509, 0.8759>, <2.3038, 35.2697, -0.4074>, <1.6658, 35.263, 0.3732> }
			texture{Grass_Texture3}}
		}
} // end Grassy_plant

#declare maiden_grass = union {
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.3605, 10.3805, -0.3605>, 0.1761 }
			cylinder { <-0.3605, 10.3805, -0.3605>, <-1.08092, 20.7234, -1.08092>, 0.1761 }
			cylinder { <-1.08092, 20.7234, -1.08092>, <-2.1592, 31.004, -2.1592>, 0.1761 }
			cylinder { <-2.1592, 31.004, -2.1592>, <-3.5929, 41.1973, -3.5929>, 0.1761 }
			cylinder { <-3.5929, 41.1973, -3.5929>, <-5.3786, 51.2788, -5.3786>, 0.1761 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-5.3786, 51.2788, -5.3786>, <-5.7902, 53.3823, -5.7902>, 0.1761 }
				cylinder { <-5.7902, 53.3823, -5.7902>, <-6.2382, 55.4709, -6.2382>, 0.1761 }
				cylinder { <-6.2382, 55.4709, -6.2382>, <-6.7223, 57.5432, -6.7223>, 0.1761 }
				cylinder { <-6.7223, 57.5432, -6.7223>, <-7.2422, 59.5982, -7.2422>, 0.1761 }
				cylinder { <-7.2422, 59.5982, -7.2422>, <-7.7976, 61.6345, -7.7976>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-7.7976, 61.6345, -7.7976>, <-8.00176, 62.1394, -7.8689>, 0.009308 }
				cylinder { <-8.00176, 62.1394, -7.8689>, <-8.2641, 62.6218, -7.8697>, 0.009308 }
				cylinder { <-8.2641, 62.6218, -7.8697>, <-8.5772, 63.06773, -7.7999>, 0.009308 }
				cylinder { <-8.5772, 63.06773, -7.7999>, <-8.9316, 63.4638, -7.6615>, 0.009308 }
				cylinder { <-8.9316, 63.4638, -7.6615>, <-9.317, 63.7985, -7.4588>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.317, 63.7985, -7.4588>, <-11.01626, 65.163, -6.6012>, <-11.0973, 65.1925, -6.7486> }
				triangle { <-11.01626, 65.163, -6.6012>, <-11.8652, 66.1154, -6.1352>, <-11.0973, 65.1925, -6.7486> }
				triangle { <-11.8652, 66.1154, -6.1352>, <-11.9058, 66.1601, -6.315>, <-11.0973, 65.1925, -6.7486> }
				triangle { <-11.8652, 66.1154, -6.1352>, <-13.9809, 69.5454, -4.8005>, <-11.9058, 66.1601, -6.315> }
				triangle { <-11.9058, 66.1601, -6.315>, <-13.9809, 69.5454, -4.8005>, <-11.9233, 66.1862, -6.5046> }
				triangle { <-11.0973, 65.1925, -6.7486>, <-11.9058, 66.1601, -6.315>, <-11.9233, 66.1862, -6.5046> }
				triangle { <-11.0973, 65.1925, -6.7486>, <-11.9233, 66.1862, -6.5046>, <-11.1114, 65.2075, -6.9093> }
				triangle { <-11.0973, 65.1925, -6.7486>, <-11.1114, 65.2075, -6.9093>, <-9.317, 63.7985, -7.4588> }
				triangle { <-14.883, 71.4887, -4.1468>, <-13.9809, 69.5454, -4.8005>, <-13.8717, 69.5458, -4.5439> }
				triangle { <-11.9233, 66.1862, -6.5046>, <-13.9809, 69.5454, -4.8005>, <-13.9761, 69.7134, -5.1059> }
				triangle { <-11.8652, 66.1154, -6.1352>, <-13.8717, 69.5458, -4.5439>, <-13.9809, 69.5454, -4.8005> }
				triangle { <-14.883, 71.4887, -4.1468>, <-13.9761, 69.7134, -5.1059>, <-13.9809, 69.5454, -4.8005> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-7.7976, 61.6345, -7.7976>, <-8.4607, 63.6292, -8.385>, 0.1761 }
				cylinder { <-8.4607, 63.6292, -8.385>, <-9.2294, 65.5762, -9.002751>, 0.1761 }
				cylinder { <-9.2294, 65.5762, -9.002751>, <-10.1013, 67.4698, -9.6489>, 0.1761 }
				cylinder { <-10.1013, 67.4698, -9.6489>, <-11.07398, 69.3041, -10.3217>, 0.1761 }
				cylinder { <-11.07398, 69.3041, -10.3217>, <-12.1442, 71.07378, -11.01919>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-12.1442, 71.07378, -11.01919>, <-12.367, 71.523, -11.2431>, 0.009308 }
				cylinder { <-12.367, 71.523, -11.2431>, <-12.5397, 71.9696, -11.5122>, 0.009308 }
				cylinder { <-12.5397, 71.9696, -11.5122>, <-12.66, 72.4066, -11.8224>, 0.009308 }
				cylinder { <-12.66, 72.4066, -11.8224>, <-12.7259, 72.8276, -12.1689>, 0.009308 }
				cylinder { <-12.7259, 72.8276, -12.1689>, <-12.7364, 73.2261, -12.5466>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-12.7364, 73.2261, -12.5466>, <-12.8627, 74.9084, -14.1711>, <-12.8636, 74.8065, -14.3082> }
				triangle { <-12.8627, 74.9084, -14.1711>, <-12.7228, 75.8859, -15.1038>, <-12.8636, 74.8065, -14.3082> }
				triangle { <-12.7228, 75.8859, -15.1038>, <-12.6817, 75.7515, -15.2312>, <-12.8636, 74.8065, -14.3082> }
				triangle { <-12.7228, 75.8859, -15.1038>, <-11.586, 78.8811, -17.8893>, <-12.6817, 75.7515, -15.2312> }
				triangle { <-12.6817, 75.7515, -15.2312>, <-11.586, 78.8811, -17.8893>, <-12.6392, 75.596, -15.3358> }
				triangle { <-12.8636, 74.8065, -14.3082>, <-12.6817, 75.7515, -15.2312>, <-12.6392, 75.596, -15.3358> }
				triangle { <-12.8636, 74.8065, -14.3082>, <-12.6392, 75.596, -15.3358>, <-12.8328, 74.6718, -14.3927> }
				triangle { <-12.8636, 74.8065, -14.3082>, <-12.8328, 74.6718, -14.3927>, <-12.7364, 73.2261, -12.5466> }
				triangle { <-10.7437, 80.4178, -19.2845>, <-11.586, 78.8811, -17.8893>, <-11.5638, 79.08559, -17.7009> }
				triangle { <-12.6392, 75.596, -15.3358>, <-11.586, 78.8811, -17.8893>, <-11.4, 78.6711, -18.09619> }
				triangle { <-12.7228, 75.8859, -15.1038>, <-11.5638, 79.08559, -17.7009>, <-11.586, 78.8811, -17.8893> }
				triangle { <-10.7437, 80.4178, -19.2845>, <-11.4, 78.6711, -18.09619>, <-11.586, 78.8811, -17.8893> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-12.1442, 71.07378, -11.01919>, <-13.2797, 72.8056, -11.7082>, 0.1761 }
				cylinder { <-13.2797, 72.8056, -11.7082>, <-14.4789, 74.4977, -12.388>, 0.1761 }
				cylinder { <-14.4789, 74.4977, -12.388>, <-15.7405, 76.148, -13.05779>, 0.1761 }
				cylinder { <-15.7405, 76.148, -13.05779>, <-17.06288, 77.7544, -13.7167>, 0.1761 }
				cylinder { <-17.06288, 77.7544, -13.7167>, <-18.4444, 79.315, -14.3641>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-18.4444, 79.315, -14.3641>, <-18.8428, 79.6828, -14.4516>, 0.009308 }
				cylinder { <-18.8428, 79.6828, -14.4516>, <-19.2802, 80.01488, -14.4611>, 0.009308 }
				cylinder { <-19.2802, 80.01488, -14.4611>, <-19.7437, 80.3014, -14.3923>, 0.009308 }
				cylinder { <-19.7437, 80.3014, -14.3923>, <-20.2197, 80.5339, -14.2472>, 0.009308 }
				cylinder { <-20.2197, 80.5339, -14.2472>, <-20.6941, 80.7056, -14.03027>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-20.6941, 80.7056, -14.03027>, <-22.7425, 81.3576, -13.1009>, <-22.8383, 81.3347, -13.2405> }
				triangle { <-22.7425, 81.3576, -13.1009>, <-23.8751, 81.9334, -12.6204>, <-22.8383, 81.3347, -13.2405> }
				triangle { <-23.8751, 81.9334, -12.6204>, <-23.9425, 81.9369, -12.7976>, <-22.8383, 81.3347, -13.2405> }
				triangle { <-23.8751, 81.9334, -12.6204>, <-27.1211, 84.3473, -11.3325>, <-23.9425, 81.9369, -12.7976> }
				triangle { <-23.9425, 81.9369, -12.7976>, <-27.1211, 84.3473, -11.3325>, <-23.982, 81.9318, -12.9856> }
				triangle { <-22.8383, 81.3347, -13.2405>, <-23.9425, 81.9369, -12.7976>, <-23.982, 81.9318, -12.9856> }
				triangle { <-22.8383, 81.3347, -13.2405>, <-23.982, 81.9318, -12.9856>, <-22.8682, 81.3241, -13.3994> }
				triangle { <-22.8383, 81.3347, -13.2405>, <-22.8682, 81.3241, -13.3994>, <-20.6941, 80.7056, -14.03027> }
				triangle { <-28.6976, 85.8227, -10.7367>, <-27.1211, 84.3473, -11.3325>, <-27.00475, 84.4212, -11.09017> }
				triangle { <-23.982, 81.9318, -12.9856>, <-27.1211, 84.3473, -11.3325>, <-27.2066, 84.4666, -11.6487> }
				triangle { <-23.8751, 81.9334, -12.6204>, <-27.00475, 84.4212, -11.09017>, <-27.1211, 84.3473, -11.3325> }
				triangle { <-28.6976, 85.8227, -10.7367>, <-27.2066, 84.4666, -11.6487>, <-27.1211, 84.3473, -11.3325> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-18.4444, 79.315, -14.3641>, <-19.9088, 80.7907, -15.02828>, 0.1761 }
				cylinder { <-19.9088, 80.7907, -15.02828>, <-21.4516, 82.1772, -15.7072>, 0.1761 }
				cylinder { <-21.4516, 82.1772, -15.7072>, <-23.06819, 83.4701, -16.3991>, 0.1761 }
				cylinder { <-23.06819, 83.4701, -16.3991>, <-24.7535, 84.6657, -17.1018>, 0.1761 }
				cylinder { <-24.7535, 84.6657, -17.1018>, <-26.5025, 85.7602, -17.8134>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-26.5025, 85.7602, -17.8134>, <-26.9052, 86.05249, -18.04589>, 0.009308 }
				cylinder { <-26.9052, 86.05249, -18.04589>, <-27.2645, 86.3572, -18.3282>, 0.009308 }
				cylinder { <-27.2645, 86.3572, -18.3282>, <-27.5749, 86.6697, -18.6563>, 0.009308 }
				cylinder { <-27.5749, 86.6697, -18.6563>, <-27.8317, 86.9854, -19.02516>, 0.009308 }
				cylinder { <-27.8317, 86.9854, -19.02516>, <-28.03112, 87.2996, -19.4291>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-28.03112, 87.2996, -19.4291>, <-28.9491, 88.5889, -21.1553>, <-28.9172, 88.4803, -21.2832> }
				triangle { <-28.9491, 88.5889, -21.1553>, <-29.2879, 89.4254, -22.1704>, <-28.9172, 88.4803, -21.2832> }
				triangle { <-29.2879, 89.4254, -22.1704>, <-29.2038, 89.3054, -22.2907>, <-28.9172, 88.4803, -21.2832> }
				triangle { <-29.2879, 89.4254, -22.1704>, <-29.678, 92.2826, -25.286>, <-29.2038, 89.3054, -22.2907> }
				triangle { <-29.2038, 89.3054, -22.2907>, <-29.678, 92.2826, -25.286>, <-29.1081, 89.1693, -22.387> }
				triangle { <-28.9172, 88.4803, -21.2832>, <-29.2038, 89.3054, -22.2907>, <-29.1081, 89.1693, -22.387> }
				triangle { <-28.9172, 88.4803, -21.2832>, <-29.1081, 89.1693, -22.387>, <-28.8393, 88.3607, -21.3599> }
				triangle { <-28.9172, 88.4803, -21.2832>, <-28.8393, 88.3607, -21.3599>, <-28.03112, 87.2996, -19.4291> }
				triangle { <-29.6405, 93.8568, -26.879>, <-29.678, 92.2826, -25.286>, <-29.7294, 92.4988, -25.1175> }
				triangle { <-29.1081, 89.1693, -22.387>, <-29.678, 92.2826, -25.286>, <-29.4364, 92.1431, -25.495> }
				triangle { <-29.2879, 89.4254, -22.1704>, <-29.7294, 92.4988, -25.1175>, <-29.678, 92.2826, -25.286> }
				triangle { <-29.6405, 93.8568, -26.879>, <-29.4364, 92.1431, -25.495>, <-29.678, 92.2826, -25.286> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-26.5025, 85.7602, -17.8134>, <-26.9357, 86.03937, -18.0034>, 0.009308 }
				cylinder { <-26.9357, 86.03937, -18.0034>, <-27.3616, 86.322, -18.2042>, 0.009308 }
				cylinder { <-27.3616, 86.322, -18.2042>, <-27.7801, 86.6081, -18.4156>, 0.009308 }
				cylinder { <-27.7801, 86.6081, -18.4156>, <-28.1908, 86.8973, -18.6377>, 0.009308 }
				cylinder { <-28.1908, 86.8973, -18.6377>, <-28.5935, 87.1896, -18.8702>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-28.5935, 87.1896, -18.8702>, <-30.3629, 88.3706, -19.8496>, <-30.3648, 88.2876, -19.9988> }
				triangle { <-30.3629, 88.3706, -19.8496>, <-31.2391, 89.192, -20.484>, <-30.3648, 88.2876, -19.9988> }
				triangle { <-31.2391, 89.192, -20.484>, <-31.189, 89.1107, -20.6479>, <-30.3648, 88.2876, -19.9988> }
				triangle { <-31.2391, 89.192, -20.484>, <-33.4041, 92.1584, -22.6139>, <-31.189, 89.1107, -20.6479> }
				triangle { <-31.189, 89.1107, -20.6479>, <-33.4041, 92.1584, -22.6139>, <-31.1157, 89.0144, -20.7972> }
				triangle { <-30.3648, 88.2876, -19.9988>, <-31.189, 89.1107, -20.6479>, <-31.1157, 89.0144, -20.7972> }
				triangle { <-30.3648, 88.2876, -19.9988>, <-31.1157, 89.0144, -20.7972>, <-30.3027, 88.2006, -20.1206> }
				triangle { <-30.3648, 88.2876, -19.9988>, <-30.3027, 88.2006, -20.1206>, <-28.5935, 87.1896, -18.8702> }
				triangle { <-34.3214, 93.8448, -23.7678>, <-33.4041, 92.1584, -22.6139>, <-33.4243, 92.3356, -22.3995> }
				triangle { <-31.1157, 89.0144, -20.7972>, <-33.4041, 92.1584, -22.6139>, <-33.2453, 92.1079, -22.92> }
				triangle { <-31.2391, 89.192, -20.484>, <-33.4243, 92.3356, -22.3995>, <-33.4041, 92.1584, -22.6139> }
				triangle { <-34.3214, 93.8448, -23.7678>, <-33.2453, 92.1079, -22.92>, <-33.4041, 92.1584, -22.6139> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.5406, 10.3648, 0.5406>, 0.1761 }
			cylinder { <0.5406, 10.3648, 0.5406>, <1.6189, 20.6453, 1.6189>, 0.1761 }
			cylinder { <1.6189, 20.6453, 1.6189>, <3.2291, 30.7858, 3.2291>, 0.1761 }
			cylinder { <3.2291, 30.7858, 3.2291>, <5.3624, 40.7313, 5.3624>, 0.1761 }
			cylinder { <5.3624, 40.7313, 5.3624>, <8.007265, 50.4279, 8.007265>, 0.1761 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <8.007265, 50.4279, 8.007265>, <8.5246, 52.4636, 8.6003>, 0.1761 }
				cylinder { <8.5246, 52.4636, 8.6003>, <9.00367, 54.4975, 9.2308>, 0.1761 }
				cylinder { <9.00367, 54.4975, 9.2308>, <9.444, 56.5282, 9.8983>, 0.1761 }
				cylinder { <9.444, 56.5282, 9.8983>, <9.8455, 58.5547, 10.6023>, 0.1761 }
				cylinder { <9.8455, 58.5547, 10.6023>, <10.2078, 60.5757, 11.3424>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <10.2078, 60.5757, 11.3424>, <10.3571, 61.08799, 11.4726>, 0.009308 }
				cylinder { <10.3571, 61.08799, 11.4726>, <10.5612, 61.5928, 11.544>, 0.009308 }
				cylinder { <10.5612, 61.5928, 11.544>, <10.8157, 62.07944, 11.5548>, 0.009308 }
				cylinder { <10.8157, 62.07944, 11.5548>, <11.1152, 62.5371, 11.5051>, 0.009308 }
				cylinder { <11.1152, 62.5371, 11.5051>, <11.4531, 62.9561, 11.3957>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <11.4531, 62.9561, 11.3957>, <12.8614, 64.7317, 10.8055>, <12.9369, 64.7514, 10.9574> }
				triangle { <12.8614, 64.7317, 10.8055>, <13.5145, 65.8873, 10.5171>, <12.9369, 64.7514, 10.9574> }
				triangle { <13.5145, 65.8873, 10.5171>, <13.5477, 65.909, 10.7026>, <12.9369, 64.7514, 10.9574> }
				triangle { <13.5145, 65.8873, 10.5171>, <14.9439, 69.8194, 9.7975>, <13.5477, 65.909, 10.7026> }
				triangle { <13.5477, 65.909, 10.7026>, <14.9439, 69.8194, 9.7975>, <13.5617, 65.9068, 10.8943> }
				triangle { <12.9369, 64.7514, 10.9574>, <13.5477, 65.909, 10.7026>, <13.5617, 65.9068, 10.8943> }
				triangle { <12.9369, 64.7514, 10.9574>, <13.5617, 65.9068, 10.8943>, <12.9495, 64.7424, 11.1187> }
				triangle { <12.9369, 64.7514, 10.9574>, <12.9495, 64.7424, 11.1187>, <11.4531, 62.9561, 11.3957> }
				triangle { <15.4633, 71.9757, 9.4845>, <14.9439, 69.8194, 9.7975>, <14.8342, 69.8412, 9.542> }
				triangle { <13.5617, 65.9068, 10.8943>, <14.9439, 69.8194, 9.7975>, <14.9108, 69.9319, 10.1258> }
				triangle { <13.5145, 65.8873, 10.5171>, <14.8342, 69.8412, 9.542>, <14.9439, 69.8194, 9.7975> }
				triangle { <15.4633, 71.9757, 9.4845>, <14.9108, 69.9319, 10.1258>, <14.9439, 69.8194, 9.7975> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <10.2078, 60.5757, 11.3424>, <10.6795, 62.5612, 12.1163>, 0.1761 }
				cylinder { <10.6795, 62.5612, 12.1163>, <11.259, 64.5052, 12.9215>, 0.1761 }
				cylinder { <11.259, 64.5052, 12.9215>, <11.9446, 66.4019, 13.7557>, 0.1761 }
				cylinder { <11.9446, 66.4019, 13.7557>, <12.7342, 68.2455, 14.6166>, 0.1761 }
				cylinder { <12.7342, 68.2455, 14.6166>, <13.6254, 70.03052, 15.5014>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <13.6254, 70.03052, 15.5014>, <13.7909, 70.4744, 15.7793>, 0.009308 }
				cylinder { <13.7909, 70.4744, 15.7793>, <13.894, 70.9034, 16.1064>, 0.009308 }
				cylinder { <13.894, 70.9034, 16.1064>, <13.9326, 71.3083, 16.4755>, 0.009308 }
				cylinder { <13.9326, 71.3083, 16.4755>, <13.9056, 71.6802, 16.8787>, 0.009308 }
				cylinder { <13.9056, 71.6802, 16.8787>, <13.8139, 72.01115, 17.3074>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <13.8139, 72.01115, 17.3074>, <13.4295, 73.5224, 19.05472>, <13.4383, 73.4102, 19.1831> }
				triangle { <13.4295, 73.5224, 19.05472>, <12.9996, 74.3592, 20.03456>, <13.4383, 73.4102, 19.1831> }
				triangle { <12.9996, 74.3592, 20.03456>, <12.9753, 74.2078, 20.1462>, <13.4383, 73.4102, 19.1831> }
				triangle { <12.9996, 74.3592, 20.03456>, <11.00028, 76.7888, 22.8844>, <12.9753, 74.2078, 20.1462> }
				triangle { <12.9753, 74.2078, 20.1462>, <11.00028, 76.7888, 22.8844>, <12.9562, 74.03769, 20.2335> }
				triangle { <13.4383, 73.4102, 19.1831>, <12.9753, 74.2078, 20.1462>, <12.9562, 74.03769, 20.2335> }
				triangle { <13.4383, 73.4102, 19.1831>, <12.9562, 74.03769, 20.2335>, <13.4282, 73.2646, 19.2534> }
				triangle { <13.4383, 73.4102, 19.1831>, <13.4282, 73.2646, 19.2534>, <13.8139, 72.01115, 17.3074> }
				triangle { <9.7256, 77.9868, 24.2834>, <11.00028, 76.7888, 22.8844>, <10.9542, 77.0017, 22.7102> }
				triangle { <12.9562, 74.03769, 20.2335>, <11.00028, 76.7888, 22.8844>, <10.843, 76.5272, 23.05277> }
				triangle { <12.9996, 74.3592, 20.03456>, <10.9542, 77.0017, 22.7102>, <11.00028, 76.7888, 22.8844> }
				triangle { <9.7256, 77.9868, 24.2834>, <10.843, 76.5272, 23.05277>, <11.00028, 76.7888, 22.8844> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <13.6254, 70.03052, 15.5014>, <14.4789, 71.8146, 16.4244>, 0.1761 }
				cylinder { <14.4789, 71.8146, 16.4244>, <15.2942, 73.5969, 17.3847>, 0.1761 }
				cylinder { <15.2942, 73.5969, 17.3847>, <16.07078, 75.3762, 18.382>, 0.1761 }
				cylinder { <16.07078, 75.3762, 18.382>, <16.8081, 77.1515, 19.4155>, 0.1761 }
				cylinder { <16.8081, 77.1515, 19.4155>, <17.5057, 78.9217, 20.4847>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <17.5057, 78.9217, 20.4847>, <17.7394, 79.3708, 20.6977>, 0.009308 }
				cylinder { <17.7394, 79.3708, 20.6977>, <18.02606, 79.8138, 20.85>, 0.009308 }
				cylinder { <18.02606, 79.8138, 20.85>, <18.3595, 80.2412, 20.9383>, 0.009308 }
				cylinder { <18.3595, 80.2412, 20.9383>, <18.7325, 80.6437, 20.9607>, 0.009308 }
				cylinder { <18.7325, 80.6437, 20.9607>, <19.137, 81.01264, 20.9167>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <19.137, 81.01264, 20.9167>, <20.8286, 82.6022, 20.6061>, <20.9058, 82.582, 20.7571> }
				triangle { <20.8286, 82.6022, 20.6061>, <21.6695, 83.6642, 20.5052>, <20.9058, 82.582, 20.7571> }
				triangle { <21.6695, 83.6642, 20.5052>, <21.7053, 83.6471, 20.6907>, <20.9058, 82.582, 20.7571> }
				triangle { <21.6695, 83.6642, 20.5052>, <23.7487, 87.3649, 20.4401>, <21.7053, 83.6471, 20.6907> }
				triangle { <21.7053, 83.6471, 20.6907>, <23.7487, 87.3649, 20.4401>, <21.718, 83.6091, 20.8787> }
				triangle { <20.9058, 82.582, 20.7571>, <21.7053, 83.6471, 20.6907>, <21.718, 83.6091, 20.8787> }
				triangle { <20.9058, 82.582, 20.7571>, <21.718, 83.6091, 20.8787>, <20.9161, 82.543, 20.914> }
				triangle { <20.9058, 82.582, 20.7571>, <20.9161, 82.543, 20.914>, <19.137, 81.01264, 20.9167> }
				triangle { <24.6279, 89.4244, 20.4918>, <23.7487, 87.3649, 20.4401>, <23.6452, 87.4492, 20.1953> }
				triangle { <21.718, 83.6091, 20.8787>, <23.7487, 87.3649, 20.4401>, <23.7339, 87.422, 20.7837> }
				triangle { <21.6695, 83.6642, 20.5052>, <23.6452, 87.4492, 20.1953>, <23.7487, 87.3649, 20.4401> }
				triangle { <24.6279, 89.4244, 20.4918>, <23.7339, 87.422, 20.7837>, <23.7487, 87.3649, 20.4401> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <17.5057, 78.9217, 20.4847>, <18.305, 80.6332, 21.578>, 0.1761 }
				cylinder { <18.305, 80.6332, 21.578>, <19.2034, 82.2809, 22.6922>, 0.1761 }
				cylinder { <19.2034, 82.2809, 22.6922>, <20.1982, 83.8597, 23.8241>, 0.1761 }
				cylinder { <20.1982, 83.8597, 23.8241>, <21.2864, 85.365, 24.9701>, 0.1761 }
				cylinder { <21.2864, 85.365, 24.9701>, <22.4647, 86.7921, 26.1271>, 0.1761 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <22.4647, 86.7921, 26.1271>, <22.7124, 87.1476, 26.4645>, 0.009308 }
				cylinder { <22.7124, 87.1476, 26.4645>, <22.9076, 87.4943, 26.8432>, 0.009308 }
				cylinder { <22.9076, 87.4943, 26.8432>, <23.04738, 87.8268, 27.2573>, 0.009308 }
				cylinder { <23.04738, 87.8268, 27.2573>, <23.1295, 88.1403, 27.7008>, 0.009308 }
				cylinder { <23.1295, 88.1403, 27.7008>, <23.1529, 88.4298, 28.1669>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <23.1529, 88.4298, 28.1669>, <23.2765, 89.7695, 30.08393>, <23.2689, 89.6437, 30.1991> }
				triangle { <23.2765, 89.7695, 30.08393>, <23.1356, 90.5587, 31.1804>, <23.2689, 89.6437, 30.1991> }
				triangle { <23.1356, 90.5587, 31.1804>, <23.08543, 90.4045, 31.2788>, <23.2689, 89.6437, 30.1991> }
				triangle { <23.1356, 90.5587, 31.1804>, <21.9996, 93.01883, 34.4484>, <23.08543, 90.4045, 31.2788> }
				triangle { <23.08543, 90.4045, 31.2788>, <21.9996, 93.01883, 34.4484>, <23.03387, 90.2338, 31.3506> }
				triangle { <23.2689, 89.6437, 30.1991>, <23.08543, 90.4045, 31.2788>, <23.03387, 90.2338, 31.3506> }
				triangle { <23.2689, 89.6437, 30.1991>, <23.03387, 90.2338, 31.3506>, <23.2304, 89.4968, 30.2556> }
				triangle { <23.2689, 89.6437, 30.1991>, <23.2304, 89.4968, 30.2556>, <23.1529, 88.4298, 28.1669> }
				triangle { <21.1592, 94.2976, 36.08418>, <21.9996, 93.01883, 34.4484>, <21.9912, 93.2557, 34.3016> }
				triangle { <23.03387, 90.2338, 31.3506>, <21.9996, 93.01883, 34.4484>, <21.7991, 92.7812, 34.6061> }
				triangle { <23.1356, 90.5587, 31.1804>, <21.9912, 93.2557, 34.3016>, <21.9996, 93.01883, 34.4484> }
				triangle { <21.1592, 94.2976, 36.08418>, <21.7991, 92.7812, 34.6061>, <21.9996, 93.01883, 34.4484> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <22.4647, 86.7921, 26.1271>, <22.7612, 87.1512, 26.4182>, 0.009308 }
				cylinder { <22.7612, 87.1512, 26.4182>, <23.05776, 87.5103, 26.7093>, 0.009308 }
				cylinder { <23.05776, 87.5103, 26.7093>, <23.3542, 87.8694, 27.00053>, 0.009308 }
				cylinder { <23.3542, 87.8694, 27.00053>, <23.6507, 88.2286, 27.2916>, 0.009308 }
				cylinder { <23.6507, 88.2286, 27.2916>, <23.9473, 88.5877, 27.5828>, 0.009308 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <23.9473, 88.5877, 27.5828>, <25.2187, 90.1929, 28.7192>, <25.2429, 90.104, 28.863> }
				triangle { <25.2187, 90.1929, 28.7192>, <25.7686, 91.2005, 29.4454>, <25.2429, 90.104, 28.863> }
				triangle { <25.7686, 91.2005, 29.4454>, <25.7427, 91.09563, 29.6013>, <25.2429, 90.104, 28.863> }
				triangle { <25.7686, 91.2005, 29.4454>, <26.8125, 94.5343, 31.8576>, <25.7427, 91.09563, 29.6013> }
				triangle { <25.7427, 91.09563, 29.6013>, <26.8125, 94.5343, 31.8576>, <25.6999, 90.9703, 29.7406> }
				triangle { <25.2429, 90.104, 28.863>, <25.7427, 91.09563, 29.6013>, <25.6999, 90.9703, 29.7406> }
				triangle { <25.2429, 90.104, 28.863>, <25.6999, 90.9703, 29.7406>, <25.2086, 89.9931, 28.9759> }
				triangle { <25.2429, 90.104, 28.863>, <25.2086, 89.9931, 28.9759>, <23.9473, 88.5877, 27.5828> }
				triangle { <27.1106, 96.3345, 33.1567>, <26.8125, 94.5343, 31.8576>, <26.7808, 94.7241, 31.6557> }
				triangle { <25.6999, 90.9703, 29.7406>, <26.8125, 94.5343, 31.8576>, <26.6697, 94.4137, 32.1518> }
				triangle { <25.7686, 91.2005, 29.4454>, <26.7808, 94.7241, 31.6557>, <26.8125, 94.5343, 31.8576> }
				triangle { <27.1106, 96.3345, 33.1567>, <26.6697, 94.4137, 32.1518>, <26.8125, 94.5343, 31.8576> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.1943, 3.7256, -0.1943>, 0.06331 }
			cylinder { <-0.1943, 3.7256, -0.1943>, <-0.5819, 7.421, -0.5819>, 0.06331 }
			cylinder { <-0.5819, 7.421, -0.5819>, <-1.1607, 11.06609, -1.1607>, 0.06331 }
			cylinder { <-1.1607, 11.06609, -1.1607>, <-1.9275, 14.641, -1.9275>, 0.06331 }
			cylinder { <-1.9275, 14.641, -1.9275>, <-2.8782, 18.1265, -2.8782>, 0.06331 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-2.8782, 18.1265, -2.8782>, <-3.07788, 18.8584, -3.07788>, 0.06331 }
				cylinder { <-3.07788, 18.8584, -3.07788>, <-3.2775, 19.5904, -3.2775>, 0.06331 }
				cylinder { <-3.2775, 19.5904, -3.2775>, <-3.4771, 20.3223, -3.4771>, 0.06331 }
				cylinder { <-3.4771, 20.3223, -3.4771>, <-3.6768, 21.05432, -3.6768>, 0.06331 }
				cylinder { <-3.6768, 21.05432, -3.6768>, <-3.8764, 21.7862, -3.8764>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.8764, 21.7862, -3.8764>, <-3.9017, 21.8517, -3.8869>, 0.001202 }
				cylinder { <-3.9017, 21.8517, -3.8869>, <-3.9335, 21.9151, -3.8896>, 0.001202 }
				cylinder { <-3.9335, 21.9151, -3.8896>, <-3.9713, 21.9749, -3.8845>, 0.001202 }
				cylinder { <-3.9713, 21.9749, -3.8845>, <-4.01422, 22.03003, -3.8717>, 0.001202 }
				cylinder { <-4.01422, 22.03003, -3.8717>, <-4.0613, 22.07908, -3.8513>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.0613, 22.07908, -3.8513>, <-4.5427, 22.6781, -3.5079>, <-4.5784, 22.6885, -3.5567> }
				triangle { <-4.5427, 22.6781, -3.5079>, <-4.7681, 23.07449, -3.3332>, <-4.5784, 22.6885, -3.5567> }
				triangle { <-4.7681, 23.07449, -3.3332>, <-4.7908, 23.08715, -3.3962>, <-4.5784, 22.6885, -3.5567> }
				triangle { <-4.7681, 23.07449, -3.3332>, <-5.2691, 24.4415, -2.8763>, <-4.7908, 23.08715, -3.3962> }
				triangle { <-4.7908, 23.08715, -3.3962>, <-5.2691, 24.4415, -2.8763>, <-4.8068, 23.09174, -3.4633> }
				triangle { <-4.5784, 22.6885, -3.5567>, <-4.7908, 23.08715, -3.3962>, <-4.8068, 23.09174, -3.4633> }
				triangle { <-4.5784, 22.6885, -3.5567>, <-4.8068, 23.09174, -3.4633>, <-4.5921, 22.6898, -3.6133> }
				triangle { <-4.5784, 22.6885, -3.5567>, <-4.5921, 22.6898, -3.6133>, <-4.0613, 22.07908, -3.8513> }
				triangle { <-5.4548, 25.1972, -2.6696>, <-5.2691, 24.4415, -2.8763>, <-5.2157, 24.4434, -2.7915> }
				triangle { <-4.8068, 23.09174, -3.4633>, <-5.2691, 24.4415, -2.8763>, <-5.2773, 24.4917, -2.9908> }
				triangle { <-4.7681, 23.07449, -3.3332>, <-5.2157, 24.4434, -2.7915>, <-5.2691, 24.4415, -2.8763> }
				triangle { <-5.4548, 25.1972, -2.6696>, <-5.2773, 24.4917, -2.9908>, <-5.2691, 24.4415, -2.8763> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.8764, 21.7862, -3.8764>, <-4.1023, 22.5108, -4.07509>, 0.06331 }
				cylinder { <-4.1023, 22.5108, -4.07509>, <-4.354, 23.2271, -4.2724>, 0.06331 }
				cylinder { <-4.354, 23.2271, -4.2724>, <-4.6314, 23.9344, -4.4683>, 0.06331 }
				cylinder { <-4.6314, 23.9344, -4.4683>, <-4.9341, 24.6316, -4.6624>, 0.06331 }
				cylinder { <-4.9341, 24.6316, -4.6624>, <-5.2616, 25.3181, -4.8546>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.2616, 25.3181, -4.8546>, <-5.284, 25.3807, -4.8795>, 0.001202 }
				cylinder { <-5.284, 25.3807, -4.8795>, <-5.2986, 25.4424, -4.9113>, 0.001202 }
				cylinder { <-5.2986, 25.4424, -4.9113>, <-5.3052, 25.5019, -4.9494>, 0.001202 }
				cylinder { <-5.3052, 25.5019, -4.9494>, <-5.3035, 25.558, -4.9929>, 0.001202 }
				cylinder { <-5.3035, 25.558, -4.9929>, <-5.2937, 25.6093, -5.04095>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.2937, 25.6093, -5.04095>, <-5.1274, 26.2866, -5.5124>, <-5.1357, 26.2603, -5.5672> }
				triangle { <-5.1274, 26.2866, -5.5124>, <-4.9579, 26.6567, -5.782>, <-5.1357, 26.2603, -5.5672> }
				triangle { <-4.9579, 26.6567, -5.782>, <-4.9553, 26.6143, -5.8353>, <-5.1357, 26.2603, -5.5672> }
				triangle { <-4.9579, 26.6567, -5.782>, <-4.1967, 27.7107, -6.5809>, <-4.9553, 26.6143, -5.8353> }
				triangle { <-4.9553, 26.6143, -5.8353>, <-4.1967, 27.7107, -6.5809>, <-4.9549, 26.5633, -5.8819> }
				triangle { <-5.1357, 26.2603, -5.5672>, <-4.9553, 26.6143, -5.8353>, <-4.9549, 26.5633, -5.8819> }
				triangle { <-5.1357, 26.2603, -5.5672>, <-4.9549, 26.5633, -5.8819>, <-5.1375, 26.2163, -5.6054> }
				triangle { <-5.1357, 26.2603, -5.5672>, <-5.1375, 26.2163, -5.6054>, <-5.2937, 25.6093, -5.04095> }
				triangle { <-3.718, 28.2217, -6.9783>, <-4.1967, 27.7107, -6.5809>, <-4.1714, 27.7664, -6.5016> }
				triangle { <-4.9549, 26.5633, -5.8819>, <-4.1967, 27.7107, -6.5809>, <-4.1508, 27.6319, -6.6668> }
				triangle { <-4.9579, 26.6567, -5.782>, <-4.1714, 27.7664, -6.5016>, <-4.1967, 27.7107, -6.5809> }
				triangle { <-3.718, 28.2217, -6.9783>, <-4.1508, 27.6319, -6.6668>, <-4.1967, 27.7107, -6.5809> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.2616, 25.3181, -4.8546>, <-5.5892, 26.00459, -5.0469>, 0.06331 }
				cylinder { <-5.5892, 26.00459, -5.0469>, <-5.9168, 26.691, -5.2391>, 0.06331 }
				cylinder { <-5.9168, 26.691, -5.2391>, <-6.2443, 27.3775, -5.4313>, 0.06331 }
				cylinder { <-6.2443, 27.3775, -5.4313>, <-6.5719, 28.06396, -5.6235>, 0.06331 }
				cylinder { <-6.5719, 28.06396, -5.6235>, <-6.8995, 28.7504, -5.8157>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-6.8995, 28.7504, -5.8157>, <-6.9357, 28.8106, -5.8252>, 0.001202 }
				cylinder { <-6.9357, 28.8106, -5.8252>, <-6.9778, 28.8677, -5.8267>, 0.001202 }
				cylinder { <-6.9778, 28.8677, -5.8267>, <-7.02489, 28.9205, -5.82>, 0.001202 }
				cylinder { <-7.02489, 28.9205, -5.82>, <-7.07581, 28.9677, -5.8054>, 0.001202 }
				cylinder { <-7.07581, 28.9677, -5.8054>, <-7.1295, 29.00843, -5.7832>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.1295, 29.00843, -5.7832>, <-7.6895, 29.5216, -5.4204>, <-7.7285, 29.5255, -5.4677> }
				triangle { <-7.6895, 29.5216, -5.4204>, <-7.9706, 29.8762, -5.2369>, <-7.7285, 29.5255, -5.4677> }
				triangle { <-7.9706, 29.8762, -5.2369>, <-7.9977, 29.8844, -5.299>, <-7.7285, 29.5255, -5.4677> }
				triangle { <-7.9706, 29.8762, -5.2369>, <-8.6736, 31.1444, -4.7614>, <-7.9977, 29.8844, -5.299> }
				triangle { <-7.9977, 29.8844, -5.299>, <-8.6736, 31.1444, -4.7614>, <-8.01711, 29.8856, -5.3653> }
				triangle { <-7.7285, 29.5255, -5.4677>, <-7.9977, 29.8844, -5.299>, <-8.01711, 29.8856, -5.3653> }
				triangle { <-7.7285, 29.5255, -5.4677>, <-8.01711, 29.8856, -5.3653>, <-7.7446, 29.524, -5.5237> }
				triangle { <-7.7285, 29.5255, -5.4677>, <-7.7446, 29.524, -5.5237>, <-7.1295, 29.00843, -5.7832> }
				triangle { <-8.9743, 31.8602, -4.5483>, <-8.6736, 31.1444, -4.7614>, <-8.6177, 31.156, -4.679> }
				triangle { <-8.01711, 29.8856, -5.3653>, <-8.6736, 31.1444, -4.7614>, <-8.6949, 31.1915, -4.8755> }
				triangle { <-7.9706, 29.8762, -5.2369>, <-8.6177, 31.156, -4.679>, <-8.6736, 31.1444, -4.7614> }
				triangle { <-8.9743, 31.8602, -4.5483>, <-8.6949, 31.1915, -4.8755>, <-8.6736, 31.1444, -4.7614> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-6.8995, 28.7504, -5.8157>, <-7.2141, 29.4388, -6.02207>, 0.06331 }
				cylinder { <-7.2141, 29.4388, -6.02207>, <-7.5156, 30.1287, -6.2424>, 0.06331 }
				cylinder { <-7.5156, 30.1287, -6.2424>, <-7.8038, 30.8198, -6.4766>, 0.06331 }
				cylinder { <-7.8038, 30.8198, -6.4766>, <-8.07861, 31.5115, -6.7245>, 0.06331 }
				cylinder { <-8.07861, 31.5115, -6.7245>, <-8.3396, 32.2036, -6.9861>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-8.3396, 32.2036, -6.9861>, <-8.3543, 32.2653, -7.01792>, 0.001202 }
				cylinder { <-8.3543, 32.2653, -7.01792>, <-8.3595, 32.3243, -7.05696>, 0.001202 }
				cylinder { <-8.3595, 32.3243, -7.05696>, <-8.3551, 32.3789, -7.102>, 0.001202 }
				cylinder { <-8.3551, 32.3789, -7.102>, <-8.3412, 32.4275, -7.1519>, 0.001202 }
				cylinder { <-8.3412, 32.4275, -7.1519>, <-8.3184, 32.4686, -7.205>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.3184, 32.4686, -7.205>, <-7.9971, 33.03119, -7.7426>, <-8.003874, 32.9979, -7.7938> }
				triangle { <-7.9971, 33.03119, -7.7426>, <-7.7431, 33.3253, -8.03819>, <-8.003874, 32.9979, -7.7938> }
				triangle { <-7.7431, 33.3253, -8.03819>, <-7.7419, 33.275, -8.08425>, <-8.003874, 32.9979, -7.7938> }
				triangle { <-7.7431, 33.3253, -8.03819>, <-6.7434, 34.1179, -8.8754>, <-7.7419, 33.275, -8.08425> }
				triangle { <-7.7419, 33.275, -8.08425>, <-6.7434, 34.1179, -8.8754>, <-7.7451, 33.2177, -8.1227> }
				triangle { <-8.003874, 32.9979, -7.7938>, <-7.7419, 33.275, -8.08425>, <-7.7451, 33.2177, -8.1227> }
				triangle { <-8.003874, 32.9979, -7.7938>, <-7.7451, 33.2177, -8.1227>, <-8.008879, 32.9492, -7.8253> }
				triangle { <-8.003874, 32.9979, -7.7938>, <-8.008879, 32.9492, -7.8253>, <-8.3184, 32.4686, -7.205> }
				triangle { <-6.15, 34.4847, -9.2774>, <-6.7434, 34.1179, -8.8754>, <-6.7177, 34.1813, -8.8021> }
				triangle { <-7.7451, 33.2177, -8.1227>, <-6.7434, 34.1179, -8.8754>, <-6.7022, 34.02063, -8.9428> }
				triangle { <-7.7431, 33.3253, -8.03819>, <-6.7177, 34.1813, -8.8021>, <-6.7434, 34.1179, -8.8754> }
				triangle { <-6.15, 34.4847, -9.2774>, <-6.7022, 34.02063, -8.9428>, <-6.7434, 34.1179, -8.8754> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-8.3396, 32.2036, -6.9861>, <-8.3633, 32.2662, -7.009761>, 0.001202 }
				cylinder { <-8.3633, 32.2662, -7.009761>, <-8.3869, 32.3288, -7.03341>, 0.001202 }
				cylinder { <-8.3869, 32.3288, -7.03341>, <-8.4105, 32.3914, -7.05707>, 0.001202 }
				cylinder { <-8.4105, 32.3914, -7.05707>, <-8.4341, 32.4539, -7.08073>, 0.001202 }
				cylinder { <-8.4341, 32.4539, -7.08073>, <-8.4577, 32.5165, -7.1043>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.4577, 32.5165, -7.1043>, <-8.6814, 33.3089, -7.2798>, <-8.6993, 33.2994, -7.3378> }
				triangle { <-8.6814, 33.3089, -7.2798>, <-8.7378, 33.7782, -7.4021>, <-8.6993, 33.2994, -7.3378> }
				triangle { <-8.7378, 33.7782, -7.4021>, <-8.7407, 33.759, -7.4675>, <-8.6993, 33.2994, -7.3378> }
				triangle { <-8.7378, 33.7782, -7.4021>, <-8.6625, 35.2399, -7.8339>, <-8.7407, 33.759, -7.4675> }
				triangle { <-8.7407, 33.759, -7.4675>, <-8.6625, 35.2399, -7.8339>, <-8.7404, 33.7294, -7.5299> }
				triangle { <-8.6993, 33.2994, -7.3378>, <-8.7407, 33.759, -7.4675>, <-8.7404, 33.7294, -7.5299> }
				triangle { <-8.6993, 33.2994, -7.3378>, <-8.7404, 33.7294, -7.5299>, <-8.7004, 33.2725, -7.3894> }
				triangle { <-8.6993, 33.2994, -7.3378>, <-8.7004, 33.2725, -7.3894>, <-8.4577, 32.5165, -7.1043> }
				triangle { <-8.5321, 35.9972, -8.07417>, <-8.6625, 35.2399, -7.8339>, <-8.6301, 35.2743, -7.7455> }
				triangle { <-8.7404, 33.7294, -7.5299>, <-8.6625, 35.2399, -7.8339>, <-8.6267, 35.2173, -7.9518> }
				triangle { <-8.7378, 33.7782, -7.4021>, <-8.6301, 35.2743, -7.7455>, <-8.6625, 35.2399, -7.8339> }
				triangle { <-8.5321, 35.9972, -8.07417>, <-8.6267, 35.2173, -7.9518>, <-8.6625, 35.2399, -7.8339> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1296, 3.7313, 0.1296>, 0.06331 }
			cylinder { <0.1296, 3.7313, 0.1296>, <0.3885, 7.4491, 0.3885>, 0.06331 }
			cylinder { <0.3885, 7.4491, 0.3885>, <0.7761, 11.1445, 0.7761>, 0.06331 }
			cylinder { <0.7761, 11.1445, 0.7761>, <1.2915, 14.8085, 1.2915>, 0.06331 }
			cylinder { <1.2915, 14.8085, 1.2915>, <1.9333, 18.4323, 1.9333>, 0.06331 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.9333, 18.4323, 1.9333>, <2.04125, 19.1976, 2.06847>, 0.06331 }
				cylinder { <2.04125, 19.1976, 2.06847>, <2.1221, 19.9661, 2.2037>, 0.06331 }
				cylinder { <2.1221, 19.9661, 2.2037>, <2.1758, 20.737, 2.3389>, 0.06331 }
				cylinder { <2.1758, 20.737, 2.3389>, <2.2024, 21.5093, 2.474>, 0.06331 }
				cylinder { <2.2024, 21.5093, 2.474>, <2.2017, 22.2822, 2.6087>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.2017, 22.2822, 2.6087>, <2.2079, 22.3526, 2.6148>, 0.001202 }
				cylinder { <2.2079, 22.3526, 2.6148>, <2.2202, 22.4225, 2.6148>, 0.001202 }
				cylinder { <2.2202, 22.4225, 2.6148>, <2.2385, 22.4908, 2.6087>, 0.001202 }
				cylinder { <2.2385, 22.4908, 2.6087>, <2.2625, 22.5565, 2.5965>, 0.001202 }
				cylinder { <2.2625, 22.5565, 2.5965>, <2.2918, 22.6185, 2.5785>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.2918, 22.6185, 2.5785>, <2.6965, 23.3395, 2.4199>, <2.7101, 23.3539, 2.478> }
				triangle { <2.6965, 23.3395, 2.4199>, <2.862, 23.7904, 2.3323>, <2.7101, 23.3539, 2.478> }
				triangle { <2.862, 23.7904, 2.3323>, <2.8584, 23.8028, 2.3992>, <2.7101, 23.3539, 2.478> }
				triangle { <2.862, 23.7904, 2.3323>, <3.1326, 25.2694, 2.0716>, <2.8584, 23.8028, 2.3992> }
				triangle { <2.8584, 23.8028, 2.3992>, <3.1326, 25.2694, 2.0716>, <2.8495, 23.8054, 2.4677> }
				triangle { <2.7101, 23.3539, 2.478>, <2.8584, 23.8028, 2.3992>, <2.8495, 23.8054, 2.4677> }
				triangle { <2.7101, 23.3539, 2.478>, <2.8495, 23.8054, 2.4677>, <2.7033, 23.3537, 2.5359> }
				triangle { <2.7101, 23.3539, 2.478>, <2.7033, 23.3537, 2.5359>, <2.2918, 22.6185, 2.5785> }
				triangle { <3.1838, 26.06196, 1.9391>, <3.1326, 25.2694, 2.0716>, <3.1118, 25.2658, 1.9736> }
				triangle { <2.8495, 23.8054, 2.4677>, <3.1326, 25.2694, 2.0716>, <3.08947, 25.3106, 2.1817> }
				triangle { <2.862, 23.7904, 2.3323>, <3.1118, 25.2658, 1.9736>, <3.1326, 25.2694, 2.0716> }
				triangle { <3.1838, 26.06196, 1.9391>, <3.08947, 25.3106, 2.1817>, <3.1326, 25.2694, 2.0716> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.2017, 22.2822, 2.6087>, <2.2283, 23.0546, 2.7438>, 0.06331 }
				cylinder { <2.2283, 23.0546, 2.7438>, <2.282, 23.8255, 2.879>, 0.06331 }
				cylinder { <2.282, 23.8255, 2.879>, <2.3629, 24.594, 3.01441>, 0.06331 }
				cylinder { <2.3629, 24.594, 3.01441>, <2.4708, 25.3592, 3.1496>, 0.06331 }
				cylinder { <2.4708, 25.3592, 3.1496>, <2.6055, 26.1201, 3.2846>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.6055, 26.1201, 3.2846>, <2.6115, 26.1885, 3.3028>, 0.001202 }
				cylinder { <2.6115, 26.1885, 3.3028>, <2.6111, 26.2552, 3.3268>, 0.001202 }
				cylinder { <2.6111, 26.2552, 3.3268>, <2.6043, 26.3195, 3.3562>, 0.001202 }
				cylinder { <2.6043, 26.3195, 3.3562>, <2.5914, 26.3802, 3.3906>, 0.001202 }
				cylinder { <2.5914, 26.3802, 3.3906>, <2.5724, 26.4365, 3.4294>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.5724, 26.4365, 3.4294>, <2.4058, 27.08414, 3.9408>, <2.4132, 27.05432, 3.994> }
				triangle { <2.4058, 27.08414, 3.9408>, <2.236, 27.4379, 4.2313>, <2.4132, 27.05432, 3.994> }
				triangle { <2.236, 27.4379, 4.2313>, <2.2324, 27.3923, 4.2818>, <2.4132, 27.05432, 3.994> }
				triangle { <2.236, 27.4379, 4.2313>, <1.4737, 28.446, 5.08643>, <2.2324, 27.3923, 4.2818> }
				triangle { <2.2324, 27.3923, 4.2818>, <1.4737, 28.446, 5.08643>, <2.2311, 27.3384, 4.325> }
				triangle { <2.4132, 27.05432, 3.994>, <2.2324, 27.3923, 4.2818>, <2.2311, 27.3384, 4.325> }
				triangle { <2.4132, 27.05432, 3.994>, <2.2311, 27.3384, 4.325>, <2.4142, 27.00805, 4.02938> }
				triangle { <2.4132, 27.05432, 3.994>, <2.4142, 27.00805, 4.02938>, <2.5724, 26.4365, 3.4294> }
				triangle { <0.9943, 28.9352, 5.5097>, <1.4737, 28.446, 5.08643>, <1.4498, 28.5069, 5.01044> }
				triangle { <2.2311, 27.3384, 4.325>, <1.4737, 28.446, 5.08643>, <1.426, 28.3623, 5.1665> }
				triangle { <2.236, 27.4379, 4.2313>, <1.4498, 28.5069, 5.01044>, <1.4737, 28.446, 5.08643> }
				triangle { <0.9943, 28.9352, 5.5097>, <1.426, 28.3623, 5.1665>, <1.4737, 28.446, 5.08643> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.6055, 26.1201, 3.2846>, <2.7535, 26.8762, 3.4328>, 0.06331 }
				cylinder { <2.7535, 26.8762, 3.4328>, <2.9144, 27.6269, 3.5941>, 0.06331 }
				cylinder { <2.9144, 27.6269, 3.5941>, <3.08833, 28.3718, 3.7684>, 0.06331 }
				cylinder { <3.08833, 28.3718, 3.7684>, <3.275, 29.1104, 3.9557>, 0.06331 }
				cylinder { <3.275, 29.1104, 3.9557>, <3.4744, 29.8423, 4.1557>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.4744, 29.8423, 4.1557>, <3.5008, 29.9075, 4.165>, 0.001202 }
				cylinder { <3.5008, 29.9075, 4.165>, <3.5348, 29.9698, 4.1652>, 0.001202 }
				cylinder { <3.5348, 29.9698, 4.1652>, <3.5753, 30.02747, 4.1563>, 0.001202 }
				cylinder { <3.5753, 30.02747, 4.1563>, <3.6211, 30.07862, 4.1385>, 0.001202 }
				cylinder { <3.6211, 30.07862, 4.1385>, <3.671, 30.1218, 4.1125>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.671, 30.1218, 4.1125>, <4.3143, 30.6001, 3.8552>, <4.3388, 30.6107, 3.9105> }
				triangle { <4.3143, 30.6001, 3.8552>, <4.6384, 30.9362, 3.7125>, <4.3388, 30.6107, 3.9105> }
				triangle { <4.6384, 30.9362, 3.7125>, <4.6475, 30.9526, 3.778>, <4.3388, 30.6107, 3.9105> }
				triangle { <4.6384, 30.9362, 3.7125>, <5.4575, 32.1528, 3.2914>, <4.6475, 30.9526, 3.778> }
				triangle { <4.6475, 30.9526, 3.778>, <5.4575, 32.1528, 3.2914>, <4.6479, 30.9626, 3.8464> }
				triangle { <4.3388, 30.6107, 3.9105>, <4.6475, 30.9526, 3.778>, <4.6479, 30.9626, 3.8464> }
				triangle { <4.3388, 30.6107, 3.9105>, <4.6479, 30.9626, 3.8464>, <4.3388, 30.6166, 3.9684> }
				triangle { <4.3388, 30.6107, 3.9105>, <4.3388, 30.6166, 3.9684>, <3.671, 30.1218, 4.1125> }
				triangle { <5.8122, 32.8441, 3.08018>, <5.4575, 32.1528, 3.2914>, <5.4266, 32.1527, 3.1961> }
				triangle { <4.6479, 30.9626, 3.8464>, <5.4575, 32.1528, 3.2914>, <5.4471, 32.2143, 3.4001> }
				triangle { <4.6384, 30.9362, 3.7125>, <5.4266, 32.1527, 3.1961>, <5.4575, 32.1528, 3.2914> }
				triangle { <5.8122, 32.8441, 3.08018>, <5.4471, 32.2143, 3.4001>, <5.4575, 32.1528, 3.2914> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.4744, 29.8423, 4.1557>, <3.6739, 30.5742, 4.3558>, 0.06331 }
				cylinder { <3.6739, 30.5742, 4.3558>, <3.8733, 31.3061, 4.5558>, 0.06331 }
				cylinder { <3.8733, 31.3061, 4.5558>, <4.07279, 32.03804, 4.7559>, 0.06331 }
				cylinder { <4.07279, 32.03804, 4.7559>, <4.2722, 32.7699, 4.9559>, 0.06331 }
				cylinder { <4.2722, 32.7699, 4.9559>, <4.4716, 33.5018, 5.156>, 0.06331 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.4716, 33.5018, 5.156>, <4.4808, 33.567, 5.1824>, 0.001202 }
				cylinder { <4.4808, 33.567, 5.1824>, <4.4808, 33.6294, 5.2163>, 0.001202 }
				cylinder { <4.4808, 33.6294, 5.2163>, <4.4717, 33.687, 5.2567>, 0.001202 }
				cylinder { <4.4717, 33.687, 5.2567>, <4.4537, 33.7382, 5.3024>, 0.001202 }
				cylinder { <4.4537, 33.7382, 5.3024>, <4.4274, 33.7815, 5.3521>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.4274, 33.7815, 5.3521>, <4.1723, 34.2664, 5.9912>, <4.1789, 34.2248, 6.03584> }
				triangle { <4.1723, 34.2664, 5.9912>, <3.9538, 34.5231, 6.3444>, <4.1789, 34.2248, 6.03584> }
				triangle { <3.9538, 34.5231, 6.3444>, <3.9511, 34.4661, 6.3817>, <4.1789, 34.2248, 6.03584> }
				triangle { <3.9538, 34.5231, 6.3444>, <3.05292, 35.2282, 7.3542>, <3.9511, 34.4661, 6.3817> }
				triangle { <3.9511, 34.4661, 6.3817>, <3.05292, 35.2282, 7.3542>, <3.9518, 34.4031, 6.4101> }
				triangle { <4.1789, 34.2248, 6.03584>, <3.9511, 34.4661, 6.3817>, <3.9518, 34.4031, 6.4101> }
				triangle { <4.1789, 34.2248, 6.03584>, <3.9518, 34.4031, 6.4101>, <4.1817, 34.1713, 6.0587> }
				triangle { <4.1789, 34.2248, 6.03584>, <4.1817, 34.1713, 6.0587>, <4.4274, 33.7815, 5.3521> }
				triangle { <2.5063, 35.5606, 7.8432>, <3.05292, 35.2282, 7.3542>, <3.02864, 35.3044, 7.2938> }
				triangle { <3.9518, 34.4031, 6.4101>, <3.05292, 35.2282, 7.3542>, <3.007875, 35.1239, 7.4071> }
				triangle { <3.9538, 34.5231, 6.3444>, <3.02864, 35.3044, 7.2938>, <3.05292, 35.2282, 7.3542> }
				triangle { <2.5063, 35.5606, 7.8432>, <3.007875, 35.1239, 7.4071>, <3.05292, 35.2282, 7.3542> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <4.4716, 33.5018, 5.156>, <4.4897, 33.568, 5.1741>, 0.001202 }
				cylinder { <4.4897, 33.568, 5.1741>, <4.5077, 33.6342, 5.1922>, 0.001202 }
				cylinder { <4.5077, 33.6342, 5.1922>, <4.5257, 33.7004, 5.2103>, 0.001202 }
				cylinder { <4.5257, 33.7004, 5.2103>, <4.5438, 33.7666, 5.2284>, 0.001202 }
				cylinder { <4.5438, 33.7666, 5.2284>, <4.5618, 33.8328, 5.2465>, 0.001202 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.5618, 33.8328, 5.2465>, <4.8308, 34.5856, 5.5104>, <4.8376, 34.5712, 5.5697> }
				triangle { <4.8308, 34.5856, 5.5104>, <4.9125, 35.03893, 5.6724>, <4.8376, 34.5712, 5.5697> }
				triangle { <4.9125, 35.03893, 5.6724>, <4.9022, 35.01619, 5.7358>, <4.8376, 34.5712, 5.5697> }
				triangle { <4.9125, 35.03893, 5.6724>, <4.9121, 36.476, 6.1856>, <4.9022, 35.01619, 5.7358> }
				triangle { <4.9022, 35.01619, 5.7358>, <4.9121, 36.476, 6.1856>, <4.8884, 34.9836, 5.7952> }
				triangle { <4.8376, 34.5712, 5.5697>, <4.9022, 35.01619, 5.7358>, <4.8884, 34.9836, 5.7952> }
				triangle { <4.8376, 34.5712, 5.5697>, <4.8884, 34.9836, 5.7952>, <4.8271, 34.5417, 5.6189> }
				triangle { <4.8376, 34.5712, 5.5697>, <4.8271, 34.5417, 5.6189>, <4.5618, 33.8328, 5.2465> }
				triangle { <4.8195, 37.2298, 6.4529>, <4.9121, 36.476, 6.1856>, <4.8989, 36.5182, 6.09575> }
				triangle { <4.8884, 34.9836, 5.7952>, <4.9121, 36.476, 6.1856>, <4.8546, 36.4514, 6.2943> }
				triangle { <4.9125, 35.03893, 5.6724>, <4.8989, 36.5182, 6.09575>, <4.9121, 36.476, 6.1856> }
				triangle { <4.8195, 37.2298, 6.4529>, <4.8546, 36.4514, 6.2943>, <4.9121, 36.476, 6.1856> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.005131, 1.4178, 0.1044>, 0.02409 }
			cylinder { <0.005131, 1.4178, 0.1044>, <0.01536, 2.8241, 0.3128>, 0.02409 }
			cylinder { <0.01536, 2.8241, 0.3128>, <0.03065, 4.2112, 0.6239>, 0.02409 }
			cylinder { <0.03065, 4.2112, 0.6239>, <0.0509, 5.5716, 1.03611>, 0.02409 }
			cylinder { <0.0509, 5.5716, 1.03611>, <0.076, 6.898, 1.5471>, 0.02409 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.076, 6.898, 1.5471>, <0.07395, 7.1765, 1.6547>, 0.02409 }
				cylinder { <0.07395, 7.1765, 1.6547>, <0.06459, 7.4547, 1.7627>, 0.02409 }
				cylinder { <0.06459, 7.4547, 1.7627>, <0.04791, 7.7325, 1.8708>, 0.02409 }
				cylinder { <0.04791, 7.7325, 1.8708>, <0.02393, 8.009757, 1.979>, 0.02409 }
				cylinder { <0.02393, 8.009757, 1.979>, <-0.007335, 8.2862, 2.08734>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.007335, 8.2862, 2.08734>, <-0.006901, 8.2957, 2.09102>, 0.0001741 }
				cylinder { <-0.006901, 8.2957, 2.09102>, <-0.004968, 8.3052, 2.09458>, 0.0001741 }
				cylinder { <-0.004968, 8.3052, 2.09458>, <-0.001576, 8.3143, 2.09793>, 0.0001741 }
				cylinder { <-0.001576, 8.3143, 2.09793>, <0.003201, 8.3229, 2.101>, 0.0001741 }
				cylinder { <0.003201, 8.3229, 2.101>, <0.00926, 8.3307, 2.1037>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.007335, 8.2862, 2.08734>, <-0.03097, 8.5606, 2.2023>, 0.02409 }
				cylinder { <-0.03097, 8.5606, 2.2023>, <-0.04695, 8.8328, 2.324>, 0.02409 }
				cylinder { <-0.04695, 8.8328, 2.324>, <-0.05526, 9.1024, 2.452>, 0.02409 }
				cylinder { <-0.05526, 9.1024, 2.452>, <-0.05588, 9.369, 2.5864>, 0.02409 }
				cylinder { <-0.05588, 9.369, 2.5864>, <-0.04882, 9.6323, 2.7269>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.04882, 9.6323, 2.7269>, <-0.05009, 9.6413, 2.7318>, 0.0001741 }
				cylinder { <-0.05009, 9.6413, 2.7318>, <-0.05284, 9.65, 2.7365>, 0.0001741 }
				cylinder { <-0.05284, 9.65, 2.7365>, <-0.057, 9.6581, 2.7412>, 0.0001741 }
				cylinder { <-0.057, 9.6581, 2.7412>, <-0.0625, 9.6657, 2.7455>, 0.0001741 }
				cylinder { <-0.0625, 9.6657, 2.7455>, <-0.06921, 9.6724, 2.7495>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.04882, 9.6323, 2.7269>, <-0.04177, 9.8957, 2.8674>, 0.02409 }
				cylinder { <-0.04177, 9.8957, 2.8674>, <-0.03471, 10.159, 3.007939>, 0.02409 }
				cylinder { <-0.03471, 10.159, 3.007939>, <-0.02766, 10.4223, 3.1484>, 0.02409 }
				cylinder { <-0.02766, 10.4223, 3.1484>, <-0.0206, 10.6856, 3.2889>, 0.02409 }
				cylinder { <-0.0206, 10.6856, 3.2889>, <-0.01354, 10.949, 3.4294>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.01354, 10.949, 3.4294>, <-0.01155, 10.9579, 3.4341>, 0.0001741 }
				cylinder { <-0.01155, 10.9579, 3.4341>, <-0.007868, 10.9665, 3.4384>, 0.0001741 }
				cylinder { <-0.007868, 10.9665, 3.4384>, <-0.002598, 10.9743, 3.4424>, 0.0001741 }
				cylinder { <-0.002598, 10.9743, 3.4424>, <0.004098, 10.9814, 3.4457>, 0.0001741 }
				cylinder { <0.004098, 10.9814, 3.4457>, <0.01202, 10.9873, 3.4485>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.01354, 10.949, 3.4294>, <-0.01417, 11.2156, 3.5638>, 0.02409 }
				cylinder { <-0.01417, 11.2156, 3.5638>, <-0.02246, 11.4851, 3.6918>, 0.02409 }
				cylinder { <-0.02246, 11.4851, 3.6918>, <-0.03843, 11.7573, 3.8134>, 0.02409 }
				cylinder { <-0.03843, 11.7573, 3.8134>, <-0.06203, 12.03188, 3.9284>, 0.02409 }
				cylinder { <-0.06203, 12.03188, 3.9284>, <-0.09325, 12.3083, 4.03671>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.09325, 12.3083, 4.03671>, <-0.09605, 12.3175, 4.04039>, 0.0001741 }
				cylinder { <-0.09605, 12.3175, 4.04039>, <-0.1005, 12.3261, 4.04391>, 0.0001741 }
				cylinder { <-0.1005, 12.3261, 4.04391>, <-0.1064, 12.3338, 4.04716>, 0.0001741 }
				cylinder { <-0.1064, 12.3338, 4.04716>, <-0.1137, 12.3404, 4.05005>, 0.0001741 }
				cylinder { <-0.1137, 12.3404, 4.05005>, <-0.1222, 12.3457, 4.0525>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.09325, 12.3083, 4.03671>, <-0.09432, 12.3178, 4.04044>, 0.0001741 }
				cylinder { <-0.09432, 12.3178, 4.04044>, <-0.0954, 12.3273, 4.04417>, 0.0001741 }
				cylinder { <-0.0954, 12.3273, 4.04417>, <-0.09647, 12.3369, 4.04789>, 0.0001741 }
				cylinder { <-0.09647, 12.3369, 4.04789>, <-0.09755, 12.3464, 4.05162>, 0.0001741 }
				cylinder { <-0.09755, 12.3464, 4.05162>, <-0.09862, 12.3559, 4.05535>, 0.0001741 }
				texture{Grass_Texture4}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.005131, 1.4178, -0.1044>, 0.02409 }
			cylinder { <-0.005131, 1.4178, -0.1044>, <-0.01536, 2.8241, -0.3128>, 0.02409 }
			cylinder { <-0.01536, 2.8241, -0.3128>, <-0.03065, 4.2112, -0.6239>, 0.02409 }
			cylinder { <-0.03065, 4.2112, -0.6239>, <-0.0509, 5.5716, -1.03611>, 0.02409 }
			cylinder { <-0.0509, 5.5716, -1.03611>, <-0.076, 6.898, -1.5471>, 0.02409 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.076, 6.898, -1.5471>, <-0.08892, 7.1738, -1.6608>, 0.02409 }
				cylinder { <-0.08892, 7.1738, -1.6608>, <-0.1094, 7.4464, -1.7808>, 0.02409 }
				cylinder { <-0.1094, 7.4464, -1.7808>, <-0.1376, 7.7155, -1.9069>, 0.02409 }
				cylinder { <-0.1376, 7.7155, -1.9069>, <-0.1733, 7.9809, -2.03907>, 0.02409 }
				cylinder { <-0.1733, 7.9809, -2.03907>, <-0.2165, 8.2421, -2.1769>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.2165, 8.2421, -2.1769>, <-0.2198, 8.2508, -2.1814>, 0.0001741 }
				cylinder { <-0.2198, 8.2508, -2.1814>, <-0.2246, 8.2588, -2.1856>, 0.0001741 }
				cylinder { <-0.2246, 8.2588, -2.1856>, <-0.2309, 8.2661, -2.1892>, 0.0001741 }
				cylinder { <-0.2309, 8.2661, -2.1892>, <-0.2385, 8.2723, -2.1922>, 0.0001741 }
				cylinder { <-0.2385, 8.2723, -2.1922>, <-0.2471, 8.2773, -2.1946>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.2165, 8.2421, -2.1769>, <-0.2673, 8.4989, -2.3205>, 0.02409 }
				cylinder { <-0.2673, 8.4989, -2.3205>, <-0.3254, 8.751, -2.4696>, 0.02409 }
				cylinder { <-0.3254, 8.751, -2.4696>, <-0.3908, 8.998, -2.6239>, 0.02409 }
				cylinder { <-0.3908, 8.998, -2.6239>, <-0.4635, 9.2397, -2.7834>, 0.02409 }
				cylinder { <-0.4635, 9.2397, -2.7834>, <-0.5434, 9.4757, -2.9478>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.5434, 9.4757, -2.9478>, <-0.5449, 9.4841, -2.9536>, 0.0001741 }
				cylinder { <-0.5449, 9.4841, -2.9536>, <-0.5452, 9.4925, -2.9595>, 0.0001741 }
				cylinder { <-0.5452, 9.4925, -2.9595>, <-0.5442, 9.5009, -2.9654>, 0.0001741 }
				cylinder { <-0.5442, 9.5009, -2.9654>, <-0.5419, 9.5091, -2.9712>, 0.0001741 }
				cylinder { <-0.5419, 9.5091, -2.9712>, <-0.5385, 9.517, -2.9767>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.5434, 9.4757, -2.9478>, <-0.6303, 9.7059, -3.117>, 0.02409 }
				cylinder { <-0.6303, 9.7059, -3.117>, <-0.7242, 9.9298, -3.2907>, 0.02409 }
				cylinder { <-0.7242, 9.9298, -3.2907>, <-0.8249, 10.1473, -3.4687>, 0.02409 }
				cylinder { <-0.8249, 10.1473, -3.4687>, <-0.9324, 10.358, -3.6508>, 0.02409 }
				cylinder { <-0.9324, 10.358, -3.6508>, <-1.04645, 10.5618, -3.8369>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.04645, 10.5618, -3.8369>, <-1.05194, 10.5682, -3.8428>, 0.0001741 }
				cylinder { <-1.05194, 10.5682, -3.8428>, <-1.05884, 10.5737, -3.848>, 0.0001741 }
				cylinder { <-1.05884, 10.5737, -3.848>, <-1.06693, 10.5783, -3.8524>, 0.0001741 }
				cylinder { <-1.06693, 10.5783, -3.8524>, <-1.07599, 10.5817, -3.8559>, 0.0001741 }
				cylinder { <-1.07599, 10.5817, -3.8559>, <-1.08574, 10.5839, -3.8583>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-1.04645, 10.5618, -3.8369>, <-1.1536, 10.7677, -4.02459>, 0.02409 }
				cylinder { <-1.1536, 10.7677, -4.02459>, <-1.254, 10.9757, -4.2137>, 0.02409 }
				cylinder { <-1.254, 10.9757, -4.2137>, <-1.3474, 11.1857, -4.4043>, 0.02409 }
				cylinder { <-1.3474, 11.1857, -4.4043>, <-1.4339, 11.3974, -4.5962>, 0.02409 }
				cylinder { <-1.4339, 11.3974, -4.5962>, <-1.5133, 11.6109, -4.7893>, 0.02409 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.5133, 11.6109, -4.7893>, <-1.5143, 11.6185, -4.7961>, 0.0001741 }
				cylinder { <-1.5143, 11.6185, -4.7961>, <-1.5136, 11.6262, -4.8029>, 0.0001741 }
				cylinder { <-1.5136, 11.6262, -4.8029>, <-1.5111, 11.6337, -4.8094>, 0.0001741 }
				cylinder { <-1.5111, 11.6337, -4.8094>, <-1.5069, 11.6408, -4.8155>, 0.0001741 }
				cylinder { <-1.5069, 11.6408, -4.8155>, <-1.5012, 11.6473, -4.8211>, 0.0001741 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.5133, 11.6109, -4.7893>, <-1.5161, 11.6182, -4.7959>, 0.0001741 }
				cylinder { <-1.5161, 11.6182, -4.7959>, <-1.5188, 11.6256, -4.8025>, 0.0001741 }
				cylinder { <-1.5188, 11.6256, -4.8025>, <-1.5215, 11.6329, -4.8092>, 0.0001741 }
				cylinder { <-1.5215, 11.6329, -4.8092>, <-1.5243, 11.6403, -4.8158>, 0.0001741 }
				cylinder { <-1.5243, 11.6403, -4.8158>, <-1.527, 11.6476, -4.8225>, 0.0001741 }
				texture{Grass_Texture4}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 15.8924, 0.0>, 0.2172 }
			cylinder { <-0.0, 15.8924, 0.0>, <-0.00000001, 31.7849, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 31.7849, 0.0>, <-0.00000001, 47.6774, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 47.6774, 0.0>, <-0.00000001, 63.5699, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 63.5699, 0.0>, <-0.00000002, 79.4624, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <0.01117, 80.1799, -0.01361>, 0.2172 }
			cylinder { <0.01117, 80.1799, -0.01361>, <0.03351, 80.8968, -0.04083>, 0.2172 }
			cylinder { <0.03351, 80.8968, -0.04083>, <0.06701, 81.6126, -0.08165>, 0.2172 }
			cylinder { <0.06701, 81.6126, -0.08165>, <0.1116, 82.3268, -0.136>, 0.2172 }
			cylinder { <0.1116, 82.3268, -0.136>, <0.1673, 83.03921, -0.2039>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.1673, 83.03921, -0.2039>, <0.2341, 83.7491, -0.2853>, 0.2172 }
			cylinder { <0.2341, 83.7491, -0.2853>, <0.312, 84.4563, -0.3802>, 0.2172 }
			cylinder { <0.312, 84.4563, -0.3802>, <0.4008, 85.1602, -0.4884>, 0.2172 }
			cylinder { <0.4008, 85.1602, -0.4884>, <0.5006, 85.8605, -0.61>, 0.2172 }
			cylinder { <0.5006, 85.8605, -0.61>, <0.6112, 86.5567, -0.7448>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.6112, 86.5567, -0.7448>, <0.7326, 87.2484, -0.8927>, 0.2172 }
			cylinder { <0.7326, 87.2484, -0.8927>, <0.8648, 87.9353, -1.05384>, 0.2172 }
			cylinder { <0.8648, 87.9353, -1.05384>, <1.00769, 88.6168, -1.2278>, 0.2172 }
			cylinder { <1.00769, 88.6168, -1.2278>, <1.161, 89.2925, -1.4147>, 0.2172 }
			cylinder { <1.161, 89.2925, -1.4147>, <1.3249, 89.9622, -1.6144>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <1.3249, 89.9622, -1.6144>, <1.4991, 90.6253, -1.8267>, 0.2172 }
			cylinder { <1.4991, 90.6253, -1.8267>, <1.6837, 91.2814, -2.0516>, 0.2172 }
			cylinder { <1.6837, 91.2814, -2.0516>, <1.8783, 91.9302, -2.2888>, 0.2172 }
			cylinder { <1.8783, 91.9302, -2.2888>, <2.0831, 92.5713, -2.5382>, 0.2172 }
			cylinder { <2.0831, 92.5713, -2.5382>, <2.2977, 93.2043, -2.7998>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <2.2977, 93.2043, -2.7998>, <2.4958, 93.8432, -3.05986>, 0.2172 }
			cylinder { <2.4958, 93.8432, -3.05986>, <2.6773, 94.4878, -3.3182>, 0.2172 }
			cylinder { <2.6773, 94.4878, -3.3182>, <2.8421, 95.1375, -3.5749>, 0.2172 }
			cylinder { <2.8421, 95.1375, -3.5749>, <2.99, 95.792, -3.8296>, 0.2172 }
			cylinder { <2.99, 95.792, -3.8296>, <3.121, 96.4509, -4.08227>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.121, 96.4509, -4.08227>, <3.6583, 99.576, -5.2626>, 0.2172 }
				cylinder { <3.6583, 99.576, -5.2626>, <4.1152, 102.7182, -6.4316>, 0.2172 }
				cylinder { <4.1152, 102.7182, -6.4316>, <4.4913, 105.8755, -7.5887>, 0.2172 }
				cylinder { <4.4913, 105.8755, -7.5887>, <4.7864, 109.0459, -8.733>, 0.2172 }
				cylinder { <4.7864, 109.0459, -8.733>, <5.000383, 112.2277, -9.864>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <5.000383, 112.2277, -9.864>, <4.9124, 113.0275, -10.05873>, <4.9991, 113.0535, -10.03885> }
					triangle { <4.9124, 113.0275, -10.05873>, <4.9269, 113.4614, -10.2097>, <4.9991, 113.0535, -10.03885> }
					triangle { <4.9269, 113.4614, -10.2097>, <5.02311, 113.4887, -10.1844>, <4.9991, 113.0535, -10.03885> }
					triangle { <4.9269, 113.4614, -10.2097>, <5.06183, 114.1141, -10.3791>, <5.02311, 113.4887, -10.1844> }
					triangle { <5.02311, 113.4887, -10.1844>, <5.06183, 114.1141, -10.3791>, <5.0955, 113.4851, -10.111> }
					triangle { <4.9991, 113.0535, -10.03885>, <5.02311, 113.4887, -10.1844>, <5.0955, 113.4851, -10.111> }
					triangle { <4.9991, 113.0535, -10.03885>, <5.0955, 113.4851, -10.111>, <5.06784, 113.0458, -9.9799> }
					triangle { <4.9991, 113.0535, -10.03885>, <5.06784, 113.0458, -9.9799>, <5.000383, 112.2277, -9.864> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.121, 96.4509, -4.08227>, <3.2668, 97.1102, -4.3254>, 0.2172 }
			cylinder { <3.2668, 97.1102, -4.3254>, <3.4275, 97.7696, -4.559>, 0.2172 }
			cylinder { <3.4275, 97.7696, -4.559>, <3.6028, 98.4286, -4.7828>, 0.2172 }
			cylinder { <3.6028, 98.4286, -4.7828>, <3.7927, 99.08687, -4.9968>, 0.2172 }
			cylinder { <3.7927, 99.08687, -4.9968>, <3.997, 99.7439, -5.2008>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.997, 99.7439, -5.2008>, <5.02793, 102.8343, -6.1148>, 0.2172 }
				cylinder { <5.02793, 102.8343, -6.1148>, <6.1257, 105.9155, -6.9805>, 0.2172 }
				cylinder { <6.1257, 105.9155, -6.9805>, <7.2899, 108.9857, -7.7974>, 0.2172 }
				cylinder { <7.2899, 108.9857, -7.7974>, <8.5196, 112.043, -8.565>, 0.2172 }
				cylinder { <8.5196, 112.043, -8.565>, <9.8142, 115.0855, -9.283>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <9.8142, 115.0855, -9.283>, <10.07115, 115.8251, -9.3779>, <10.04913, 115.8333, -9.4631> }
					triangle { <10.07115, 115.8251, -9.3779>, <10.147, 116.2487, -9.4588>, <10.04913, 115.8333, -9.4631> }
					triangle { <10.147, 116.2487, -9.4588>, <10.1242, 116.2548, -9.5541>, <10.04913, 115.8333, -9.4631> }
					triangle { <10.147, 116.2487, -9.4588>, <10.2394, 116.8529, -9.6947>, <10.1242, 116.2548, -9.5541> }
					triangle { <10.1242, 116.2548, -9.5541>, <10.2394, 116.8529, -9.6947>, <10.1328, 116.2117, -9.642> }
					triangle { <10.04913, 115.8333, -9.4631>, <10.1242, 116.2548, -9.5541>, <10.1328, 116.2117, -9.642> }
					triangle { <10.04913, 115.8333, -9.4631>, <10.1328, 116.2117, -9.642>, <10.04842, 115.7946, -9.5404> }
					triangle { <10.04913, 115.8333, -9.4631>, <10.04842, 115.7946, -9.5404>, <9.8142, 115.0855, -9.283> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.997, 99.7439, -5.2008>, <4.1965, 100.3972, -5.4213>, 0.2172 }
			cylinder { <4.1965, 100.3972, -5.4213>, <4.3911, 101.0461, -5.6582>, 0.2172 }
			cylinder { <4.3911, 101.0461, -5.6582>, <4.5807, 101.6905, -5.9112>, 0.2172 }
			cylinder { <4.5807, 101.6905, -5.9112>, <4.7651, 102.3297, -6.1804>, 0.2172 }
			cylinder { <4.7651, 102.3297, -6.1804>, <4.9443, 102.9636, -6.4655>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.9443, 102.9636, -6.4655>, <5.7635, 105.9244, -7.8835>, 0.2172 }
				cylinder { <5.7635, 105.9244, -7.8835>, <6.5569, 108.8561, -9.375>, 0.2172 }
				cylinder { <6.5569, 108.8561, -9.375>, <7.324, 111.7568, -10.9388>, 0.2172 }
				cylinder { <7.324, 111.7568, -10.9388>, <8.06431, 114.6249, -12.5742>, 0.2172 }
				cylinder { <8.06431, 114.6249, -12.5742>, <8.7774, 117.4586, -14.2801>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <8.7774, 117.4586, -14.2801>, <8.7592, 118.0245, -14.774>, <8.7542, 118.0869, -14.7179> }
					triangle { <8.7592, 118.0245, -14.774>, <8.801, 118.366, -15.0099>, <8.7542, 118.0869, -14.7179> }
					triangle { <8.801, 118.366, -15.0099>, <8.7929, 118.4339, -14.946>, <8.7542, 118.0869, -14.7179> }
					triangle { <8.801, 118.366, -15.0099>, <8.8369, 118.9338, -15.2665>, <8.7929, 118.4339, -14.946> }
					triangle { <8.7929, 118.4339, -14.946>, <8.8369, 118.9338, -15.2665>, <8.7452, 118.4635, -14.8711> }
					triangle { <8.7542, 118.0869, -14.7179>, <8.7929, 118.4339, -14.946>, <8.7452, 118.4635, -14.8711> }
					triangle { <8.7542, 118.0869, -14.7179>, <8.7452, 118.4635, -14.8711>, <8.719, 118.1125, -14.6479> }
					triangle { <8.7542, 118.0869, -14.7179>, <8.719, 118.1125, -14.6479>, <8.7774, 117.4586, -14.2801> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <4.9443, 102.9636, -6.4655>, <5.1164, 103.6055, -6.7365>, 0.2172 }
			cylinder { <5.1164, 103.6055, -6.7365>, <5.2815, 104.255, -6.9933>, 0.2172 }
			cylinder { <5.2815, 104.255, -6.9933>, <5.4393, 104.9119, -7.2358>, 0.2172 }
			cylinder { <5.4393, 104.9119, -7.2358>, <5.5899, 105.5755, -7.4639>, 0.2172 }
			cylinder { <5.5899, 105.5755, -7.4639>, <5.7331, 106.2457, -7.6773>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.7331, 106.2457, -7.6773>, <6.3729, 109.4335, -8.6137>, 0.2172 }
				cylinder { <6.3729, 109.4335, -8.6137>, <6.977, 112.648, -9.48>, 0.2172 }
				cylinder { <6.977, 112.648, -9.48>, <7.5453, 115.8872, -10.2756>, 0.2172 }
				cylinder { <7.5453, 115.8872, -10.2756>, <8.07722, 119.1492, -11.00015>, 0.2172 }
				cylinder { <8.07722, 119.1492, -11.00015>, <8.5725, 122.4321, -11.653>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <8.5725, 122.4321, -11.653>, <8.6077, 123.1314, -11.8005>, <8.6784, 123.1299, -11.8381> }
					triangle { <8.6077, 123.1314, -11.8005>, <8.6398, 123.5002, -11.945>, <8.6784, 123.1299, -11.8381> }
					triangle { <8.6398, 123.5002, -11.945>, <8.7197, 123.4969, -11.9843>, <8.6784, 123.1299, -11.8381> }
					triangle { <8.6398, 123.5002, -11.945>, <8.7896, 124.0219, -12.1874>, <8.7197, 123.4969, -11.9843> }
					triangle { <8.7197, 123.4969, -11.9843>, <8.7896, 124.0219, -12.1874>, <8.804, 123.4692, -11.9764> }
					triangle { <8.6784, 123.1299, -11.8381>, <8.7197, 123.4969, -11.9843>, <8.804, 123.4692, -11.9764> }
					triangle { <8.6784, 123.1299, -11.8381>, <8.804, 123.4692, -11.9764>, <8.7514, 123.1011, -11.8372> }
					triangle { <8.6784, 123.1299, -11.8381>, <8.7514, 123.1011, -11.8372>, <8.5725, 122.4321, -11.653> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <-0.01742, 80.1799, 0.002584>, 0.2172 }
			cylinder { <-0.01742, 80.1799, 0.002584>, <-0.05225, 80.8968, 0.007751>, 0.2172 }
			cylinder { <-0.05225, 80.8968, 0.007751>, <-0.1044, 81.6126, 0.01549>, 0.2172 }
			cylinder { <-0.1044, 81.6126, 0.01549>, <-0.174, 82.3268, 0.02582>, 0.2172 }
			cylinder { <-0.174, 82.3268, 0.02582>, <-0.2609, 83.03921, 0.03871>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.2609, 83.03921, 0.03871>, <-0.4529, 83.7296, 0.07914>, 0.2172 }
			cylinder { <-0.4529, 83.7296, 0.07914>, <-0.6305, 84.4231, 0.1294>, 0.2172 }
			cylinder { <-0.6305, 84.4231, 0.1294>, <-0.7938, 85.1194, 0.1894>, 0.2172 }
			cylinder { <-0.7938, 85.1194, 0.1894>, <-0.9427, 85.8181, 0.2593>, 0.2172 }
			cylinder { <-0.9427, 85.8181, 0.2593>, <-1.07697, 86.5186, 0.3388>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.07697, 86.5186, 0.3388>, <-1.6408, 89.8283, 0.7595>, 0.2172 }
				cylinder { <-1.6408, 89.8283, 0.7595>, <-2.1354, 93.1429, 1.2256>, 0.2172 }
				cylinder { <-2.1354, 93.1429, 1.2256>, <-2.5603, 96.4605, 1.7368>, 0.2172 }
				cylinder { <-2.5603, 96.4605, 1.7368>, <-2.9152, 99.7792, 2.2927>, 0.2172 }
				cylinder { <-2.9152, 99.7792, 2.2927>, <-3.2, 103.0969, 2.8931>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.2, 103.0969, 2.8931>, <-3.1095, 103.8998, 3.07335>, <-3.1546, 103.933, 2.9995> }
					triangle { <-3.1095, 103.8998, 3.07335>, <-3.1356, 104.3499, 3.1627>, <-3.1546, 103.933, 2.9995> }
					triangle { <-3.1356, 104.3499, 3.1627>, <-3.1837, 104.3848, 3.07846>, <-3.1546, 103.933, 2.9995> }
					triangle { <-3.1356, 104.3499, 3.1627>, <-3.2192, 105.0323, 3.1783>, <-3.1837, 104.3848, 3.07846> }
					triangle { <-3.1837, 104.3848, 3.07846>, <-3.2192, 105.0323, 3.1783>, <-3.189, 104.3791, 2.9756> }
					triangle { <-3.1546, 103.933, 2.9995>, <-3.1837, 104.3848, 3.07846>, <-3.189, 104.3791, 2.9756> }
					triangle { <-3.1546, 103.933, 2.9995>, <-3.189, 104.3791, 2.9756>, <-3.1675, 103.9251, 2.9099> }
					triangle { <-3.1546, 103.933, 2.9995>, <-3.1675, 103.9251, 2.9099>, <-3.2, 103.0969, 2.8931> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.07697, 86.5186, 0.3388>, <-1.2157, 87.22, 0.4014>, 0.2172 }
			cylinder { <-1.2157, 87.22, 0.4014>, <-1.359, 87.9218, 0.4469>, 0.2172 }
			cylinder { <-1.359, 87.9218, 0.4469>, <-1.5066, 88.6236, 0.4754>, 0.2172 }
			cylinder { <-1.5066, 88.6236, 0.4754>, <-1.6586, 89.325, 0.4868>, 0.2172 }
			cylinder { <-1.6586, 89.325, 0.4868>, <-1.8147, 90.02557, 0.4811>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.8147, 90.02557, 0.4811>, <-2.5701, 93.3219, 0.3737>, 0.2172 }
				cylinder { <-2.5701, 93.3219, 0.3737>, <-3.3443, 96.6104, 0.1858>, 0.2172 }
				cylinder { <-3.3443, 96.6104, 0.1858>, <-4.137, 99.8888, -0.08241>, 0.2172 }
				cylinder { <-4.137, 99.8888, -0.08241>, <-4.9476, 103.1554, -0.4308>, 0.2172 }
				cylinder { <-4.9476, 103.1554, -0.4308>, <-5.7757, 106.4079, -0.8592>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-5.7757, 106.4079, -0.8592>, <-5.8825, 107.1794, -0.9832>, <-5.9209, 107.1975, -0.9057> }
					triangle { <-5.8825, 107.1794, -0.9832>, <-5.9093, 107.6165, -0.9867>, <-5.9209, 107.1975, -0.9057> }
					triangle { <-5.9093, 107.6165, -0.9867>, <-5.9541, 107.634, -0.9011>, <-5.9209, 107.1975, -0.9057> }
					triangle { <-5.9093, 107.6165, -0.9867>, <-6.01505, 108.2561, -0.8919>, <-5.9541, 107.634, -0.9011> }
					triangle { <-5.9541, 107.634, -0.9011>, <-6.01505, 108.2561, -0.8919>, <-6.02646, 107.606, -0.8408> }
					triangle { <-5.9209, 107.1975, -0.9057>, <-5.9541, 107.634, -0.9011>, <-6.02646, 107.606, -0.8408> }
					triangle { <-5.9209, 107.1975, -0.9057>, <-6.02646, 107.606, -0.8408>, <-5.9786, 107.1712, -0.847> }
					triangle { <-5.9209, 107.1975, -0.9057>, <-5.9786, 107.1712, -0.847>, <-5.7757, 106.4079, -0.8592> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.8147, 90.02557, 0.4811>, <-1.9789, 90.7241, 0.4909>, 0.2172 }
			cylinder { <-1.9789, 90.7241, 0.4909>, <-2.1511, 91.4204, 0.5163>, 0.2172 }
			cylinder { <-2.1511, 91.4204, 0.5163>, <-2.3312, 92.114, 0.5572>, 0.2172 }
			cylinder { <-2.3312, 92.114, 0.5572>, <-2.519, 92.8044, 0.6135>, 0.2172 }
			cylinder { <-2.519, 92.8044, 0.6135>, <-2.7146, 93.4913, 0.6853>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.7146, 93.4913, 0.6853>, <-3.6718, 96.7104, 1.09665>, 0.2172 }
				cylinder { <-3.6718, 96.7104, 1.09665>, <-4.664, 99.9089, 1.5803>, 0.2172 }
				cylinder { <-4.664, 99.9089, 1.5803>, <-5.6906, 103.0847, 2.1361>, 0.2172 }
				cylinder { <-5.6906, 103.0847, 2.1361>, <-6.7509, 106.236, 2.7637>, 0.2172 }
				cylinder { <-6.7509, 106.236, 2.7637>, <-7.8444, 109.3607, 3.4627>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-7.8444, 109.3607, 3.4627>, <-8.04652, 109.9879, 3.8236>, <-7.9938, 110.0401, 3.7837> }
					triangle { <-8.04652, 109.9879, 3.8236>, <-8.1659, 110.3637, 3.9599>, <-7.9938, 110.0401, 3.7837> }
					triangle { <-8.1659, 110.3637, 3.9599>, <-8.1049, 110.4196, 3.9162>, <-7.9938, 110.0401, 3.7837> }
					triangle { <-8.1659, 110.3637, 3.9599>, <-8.2511, 110.9637, 4.1091>, <-8.1049, 110.4196, 3.9162> }
					triangle { <-8.1049, 110.4196, 3.9162>, <-8.2511, 110.9637, 4.1091>, <-8.01529, 110.4314, 3.8921> }
					triangle { <-7.9938, 110.0401, 3.7837>, <-8.1049, 110.4196, 3.9162>, <-8.01529, 110.4314, 3.8921> }
					triangle { <-7.9938, 110.0401, 3.7837>, <-8.01529, 110.4314, 3.8921>, <-7.9173, 110.0502, 3.7549> }
					triangle { <-7.9938, 110.0401, 3.7837>, <-7.9173, 110.0502, 3.7549>, <-7.8444, 109.3607, 3.4627> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-2.7146, 93.4913, 0.6853>, <-2.8942, 94.183, 0.7513>, 0.2172 }
			cylinder { <-2.8942, 94.183, 0.7513>, <-3.05793, 94.8792, 0.8113>, 0.2172 }
			cylinder { <-3.05793, 94.8792, 0.8113>, <-3.2055, 95.5795, 0.8654>, 0.2172 }
			cylinder { <-3.2055, 95.5795, 0.8654>, <-3.3369, 96.2835, 0.9134>, 0.2172 }
			cylinder { <-3.3369, 96.2835, 0.9134>, <-3.4521, 96.9906, 0.9555>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.4521, 96.9906, 0.9555>, <-3.9184, 100.3377, 1.1252>, 0.2172 }
				cylinder { <-3.9184, 100.3377, 1.1252>, <-4.3075, 103.6958, 1.2664>, 0.2172 }
				cylinder { <-4.3075, 103.6958, 1.2664>, <-4.6192, 107.0631, 1.3788>, 0.2172 }
				cylinder { <-4.6192, 107.0631, 1.3788>, <-4.8533, 110.4375, 1.4626>, 0.2172 }
				cylinder { <-4.8533, 110.4375, 1.4626>, <-5.009728, 113.817, 1.5175>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-5.009728, 113.817, 1.5175>, <-4.9972, 114.5296, 1.5827>, <-5.07387, 114.5425, 1.5629> }
					triangle { <-4.9972, 114.5296, 1.5827>, <-5.04444, 114.917, 1.6572>, <-5.07387, 114.5425, 1.5629> }
					triangle { <-5.04444, 114.917, 1.6572>, <-5.1291, 114.9296, 1.6326>, <-5.07387, 114.5425, 1.5629> }
					triangle { <-5.04444, 114.917, 1.6572>, <-5.2122, 115.4838, 1.7205>, <-5.1291, 114.9296, 1.6326> }
					triangle { <-5.1291, 114.9296, 1.6326>, <-5.2122, 115.4838, 1.7205>, <-5.1907, 114.9117, 1.5707> }
					triangle { <-5.07387, 114.5425, 1.5629>, <-5.1291, 114.9296, 1.6326>, <-5.1907, 114.9117, 1.5707> }
					triangle { <-5.07387, 114.5425, 1.5629>, <-5.1907, 114.9117, 1.5707>, <-5.132, 114.5232, 1.5138> }
					triangle { <-5.07387, 114.5425, 1.5629>, <-5.132, 114.5232, 1.5138>, <-5.009728, 113.817, 1.5175> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.2609, 83.03921, 0.03871>, <-0.3333, 83.7529, 0.0614>, 0.2172 }
			cylinder { <-0.3333, 83.7529, 0.0614>, <-0.391, 84.4675, 0.09387>, 0.2172 }
			cylinder { <-0.391, 84.4675, 0.09387>, <-0.434, 85.1827, 0.1361>, 0.2172 }
			cylinder { <-0.434, 85.1827, 0.1361>, <-0.4624, 85.898, 0.188>, 0.2172 }
			cylinder { <-0.4624, 85.898, 0.188>, <-0.4761, 86.6129, 0.2497>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.4761, 86.6129, 0.2497>, <-0.3915, 87.3169, 0.3612>, 0.2172 }
			cylinder { <-0.3915, 87.3169, 0.3612>, <-0.3112, 88.02384, 0.4559>, 0.2172 }
			cylinder { <-0.3112, 88.02384, 0.4559>, <-0.2353, 88.7332, 0.5337>, 0.2172 }
			cylinder { <-0.2353, 88.7332, 0.5337>, <-0.1638, 89.4448, 0.5946>, 0.2172 }
			cylinder { <-0.1638, 89.4448, 0.5946>, <-0.09686, 90.158, 0.6386>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.09686, 90.158, 0.6386>, <0.1976, 93.5264, 0.7658>, 0.2172 }
				cylinder { <0.1976, 93.5264, 0.7658>, <0.4707, 96.8986, 0.8128>, 0.2172 }
				cylinder { <0.4707, 96.8986, 0.8128>, <0.7221, 100.2726, 0.7797>, 0.2172 }
				cylinder { <0.7221, 100.2726, 0.7797>, <0.9518, 103.6465, 0.6665>, 0.2172 }
				cylinder { <0.9518, 103.6465, 0.6665>, <1.1595, 107.0182, 0.4732>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.1595, 107.0182, 0.4732>, <1.1156, 107.825, 0.2934>, <1.09565, 107.8546, 0.379> }
					triangle { <1.1156, 107.825, 0.2934>, <1.1397, 108.2822, 0.2529>, <1.09565, 107.8546, 0.379> }
					triangle { <1.1397, 108.2822, 0.2529>, <1.1149, 108.3126, 0.3482>, <1.09565, 107.8546, 0.379> }
					triangle { <1.1397, 108.2822, 0.2529>, <1.1291, 108.9675, 0.3098>, <1.1149, 108.3126, 0.3482> }
					triangle { <1.1149, 108.3126, 0.3482>, <1.1291, 108.9675, 0.3098>, <1.05105, 108.2977, 0.4278> }
					triangle { <1.09565, 107.8546, 0.379>, <1.1149, 108.3126, 0.3482>, <1.05105, 108.2977, 0.4278> }
					triangle { <1.09565, 107.8546, 0.379>, <1.05105, 108.2977, 0.4278>, <1.04646, 107.8392, 0.4538> }
					triangle { <1.09565, 107.8546, 0.379>, <1.04646, 107.8392, 0.4538>, <1.1595, 107.0182, 0.4732> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.09686, 90.158, 0.6386>, <-0.03794, 90.8709, 0.6982>, 0.2172 }
			cylinder { <-0.03794, 90.8709, 0.6982>, <0.01287, 91.5828, 0.7734>, 0.2172 }
			cylinder { <0.01287, 91.5828, 0.7734>, <0.05555, 92.2935, 0.8642>, 0.2172 }
			cylinder { <0.05555, 92.2935, 0.8642>, <0.09006, 93.0025, 0.9705>, 0.2172 }
			cylinder { <0.09006, 93.0025, 0.9705>, <0.1163, 93.7093, 1.09235>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.1163, 93.7093, 1.09235>, <0.2018, 97.02946, 1.7388>, 0.2172 }
				cylinder { <0.2018, 97.02946, 1.7388>, <0.2486, 100.3355, 2.4574>, 0.2172 }
				cylinder { <0.2486, 100.3355, 2.4574>, <0.2566, 103.6255, 3.2477>, 0.2172 }
				cylinder { <0.2566, 103.6255, 3.2477>, <0.2259, 106.8974, 4.1092>, 0.2172 }
				cylinder { <0.2259, 106.8974, 4.1092>, <0.1564, 110.1493, 5.04143>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.1564, 110.1493, 5.04143>, <0.05916, 110.9115, 5.2189>, <0.1367, 110.9398, 5.1876> }
					triangle { <0.05916, 110.9115, 5.2189>, <0.02361, 111.347, 5.2472>, <0.1367, 110.9398, 5.1876> }
					triangle { <0.02361, 111.347, 5.2472>, <0.1115, 111.376, 5.2143>, <0.1367, 110.9398, 5.1876> }
					triangle { <0.02361, 111.347, 5.2472>, <0.0871, 111.999, 5.2597>, <0.1115, 111.376, 5.2143> }
					triangle { <0.1115, 111.376, 5.2143>, <0.0871, 111.999, 5.2597>, <0.2082, 111.3596, 5.2178> }
					triangle { <0.1367, 110.9398, 5.1876>, <0.1115, 111.376, 5.2143>, <0.2082, 111.3596, 5.2178> }
					triangle { <0.1367, 110.9398, 5.1876>, <0.2082, 111.3596, 5.2178>, <0.2216, 110.9237, 5.1825> }
					triangle { <0.1367, 110.9398, 5.1876>, <0.2216, 110.9237, 5.1825>, <0.1564, 110.1493, 5.04143> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.1163, 93.7093, 1.09235>, <0.1592, 94.4163, 1.208>, 0.2172 }
			cylinder { <0.1592, 94.4163, 1.208>, <0.2186, 95.1232, 1.3175>, 0.2172 }
			cylinder { <0.2186, 95.1232, 1.3175>, <0.2944, 95.8294, 1.4207>, 0.2172 }
			cylinder { <0.2944, 95.8294, 1.4207>, <0.3866, 96.5345, 1.5177>, 0.2172 }
			cylinder { <0.3866, 96.5345, 1.5177>, <0.4952, 97.2382, 1.6083>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.4952, 97.2382, 1.6083>, <1.08402, 100.5464, 2.005307>, 0.2172 }
				cylinder { <1.08402, 100.5464, 2.005307>, <1.7492, 103.8436, 2.3718>, 0.2172 }
				cylinder { <1.7492, 103.8436, 2.3718>, <2.4905, 107.1279, 2.7076>, 0.2172 }
				cylinder { <2.4905, 107.1279, 2.7076>, <3.3075, 110.3971, 3.0126>, 0.2172 }
				cylinder { <3.3075, 110.3971, 3.0126>, <4.1996, 113.6495, 3.2864>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.1996, 113.6495, 3.2864>, <4.5127, 114.3218, 3.1664>, <4.441, 114.3657, 3.1615> }
					triangle { <4.5127, 114.3218, 3.1664>, <4.6459, 114.7169, 3.1526>, <4.441, 114.3657, 3.1615> }
					triangle { <4.6459, 114.7169, 3.1526>, <4.5651, 114.7635, 3.1449>, <4.441, 114.3657, 3.1615> }
					triangle { <4.6459, 114.7169, 3.1526>, <4.7353, 115.3331, 3.1103>, <4.5651, 114.7635, 3.1449> }
					triangle { <4.5651, 114.7635, 3.1449>, <4.7353, 115.3331, 3.1103>, <4.4816, 114.766, 3.1027> }
					triangle { <4.441, 114.3657, 3.1615>, <4.5651, 114.7635, 3.1449>, <4.4816, 114.766, 3.1027> }
					triangle { <4.441, 114.3657, 3.1615>, <4.4816, 114.766, 3.1027>, <4.3643, 114.3671, 3.1315> }
					triangle { <4.441, 114.3657, 3.1615>, <4.3643, 114.3671, 3.1315>, <4.1996, 113.6495, 3.2864> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.4952, 97.2382, 1.6083>, <0.5876, 97.9449, 1.6927>, 0.2172 }
			cylinder { <0.5876, 97.9449, 1.6927>, <0.6638, 98.6543, 1.7708>, 0.2172 }
			cylinder { <0.6638, 98.6543, 1.7708>, <0.7236, 99.3659, 1.8426>, 0.2172 }
			cylinder { <0.7236, 99.3659, 1.8426>, <0.7672, 100.0793, 1.908>, 0.2172 }
			cylinder { <0.7672, 100.0793, 1.908>, <0.7944, 100.7941, 1.9671>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.7944, 100.7941, 1.9671>, <0.8454, 104.1682, 2.215>, 0.2172 }
				cylinder { <0.8454, 104.1682, 2.215>, <0.8192, 107.5447, 2.4324>, 0.2172 }
				cylinder { <0.8192, 107.5447, 2.4324>, <0.7158, 110.9215, 2.6192>, 0.2172 }
				cylinder { <0.7158, 110.9215, 2.6192>, <0.5353, 114.2966, 2.7752>, 0.2172 }
				cylinder { <0.5353, 114.2966, 2.7752>, <0.2778, 117.6681, 2.9004>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.2778, 117.6681, 2.9004>, <0.2258, 118.3804, 2.8566>, <0.2674, 118.3973, 2.923> }
					triangle { <0.2258, 118.3804, 2.8566>, <0.2632, 118.7756, 2.8401>, <0.2674, 118.3973, 2.923> }
					triangle { <0.2632, 118.7756, 2.8401>, <0.3077, 118.7924, 2.9155>, <0.2674, 118.3973, 2.923> }
					triangle { <0.2632, 118.7756, 2.8401>, <0.3603, 119.3572, 2.9163>, <0.3077, 118.7924, 2.9155> }
					triangle { <0.3077, 118.7924, 2.9155>, <0.3603, 119.3572, 2.9163>, <0.314, 118.7736, 3.002438> }
					triangle { <0.2674, 118.3973, 2.923>, <0.3077, 118.7924, 2.9155>, <0.314, 118.7736, 3.002438> }
					triangle { <0.2674, 118.3973, 2.923>, <0.314, 118.7736, 3.002438>, <0.2799, 118.378, 2.998> }
					triangle { <0.2674, 118.3973, 2.923>, <0.2799, 118.378, 2.998>, <0.2778, 117.6681, 2.9004> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.4761, 86.6129, 0.2497>, <-0.4942, 87.3291, 0.2944>, 0.2172 }
			cylinder { <-0.4942, 87.3291, 0.2944>, <-0.5166, 88.04594, 0.322>, 0.2172 }
			cylinder { <-0.5166, 88.04594, 0.322>, <-0.5434, 88.763, 0.3325>, 0.2172 }
			cylinder { <-0.5434, 88.763, 0.3325>, <-0.5745, 89.4801, 0.326>, 0.2172 }
			cylinder { <-0.5745, 89.4801, 0.326>, <-0.6099, 90.1965, 0.3024>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.6099, 90.1965, 0.3024>, <-0.6832, 90.8992, 0.1756>, 0.2172 }
			cylinder { <-0.6832, 90.8992, 0.1756>, <-0.7649, 91.6035, 0.06426>, 0.2172 }
			cylinder { <-0.7649, 91.6035, 0.06426>, <-0.8548, 92.3091, -0.03162>, 0.2172 }
			cylinder { <-0.8548, 92.3091, -0.03162>, <-0.9531, 93.01552, -0.1119>, 0.2172 }
			cylinder { <-0.9531, 93.01552, -0.1119>, <-1.05953, 93.7223, -0.1767>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.05953, 93.7223, -0.1767>, <-1.5995, 97.0545, -0.4083>, 0.2172 }
				cylinder { <-1.5995, 97.0545, -0.4083>, <-2.1775, 100.3846, -0.5661>, 0.2172 }
				cylinder { <-2.1775, 100.3846, -0.5661>, <-2.7932, 103.7106, -0.6501>, 0.2172 }
				cylinder { <-2.7932, 103.7106, -0.6501>, <-3.4462, 107.0305, -0.66>, 0.2172 }
				cylinder { <-3.4462, 107.0305, -0.66>, <-4.1361, 110.3424, -0.5961>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-4.1361, 110.3424, -0.5961>, <-4.3212, 111.1296, -0.419>, <-4.2531, 111.1686, -0.4684> }
					triangle { <-4.3212, 111.1296, -0.419>, <-4.4213, 111.5777, -0.397>, <-4.2531, 111.1686, -0.4684> }
					triangle { <-4.4213, 111.5777, -0.397>, <-4.3432, 111.6188, -0.4503>, <-4.2531, 111.1686, -0.4684> }
					triangle { <-4.4213, 111.5777, -0.397>, <-4.4586, 112.264, -0.4197>, <-4.3432, 111.6188, -0.4503> }
					triangle { <-4.3432, 111.6188, -0.4503>, <-4.4586, 112.264, -0.4197>, <-4.2414, 111.6165, -0.4665> }
					triangle { <-4.2531, 111.1686, -0.4684>, <-4.3432, 111.6188, -0.4503>, <-4.2414, 111.6165, -0.4665> }
					triangle { <-4.2531, 111.1686, -0.4684>, <-4.2414, 111.6165, -0.4665>, <-4.1652, 111.1642, -0.4909> }
					triangle { <-4.2531, 111.1686, -0.4684>, <-4.1652, 111.1642, -0.4909>, <-4.1361, 110.3424, -0.5961> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.05953, 93.7223, -0.1767>, <-1.1495, 94.4308, -0.2476>, 0.2172 }
			cylinder { <-1.1495, 94.4308, -0.2476>, <-1.223, 95.1406, -0.3247>, 0.2172 }
			cylinder { <-1.223, 95.1406, -0.3247>, <-1.28, 95.8512, -0.4078>, 0.2172 }
			cylinder { <-1.28, 95.8512, -0.4078>, <-1.3205, 96.5622, -0.4969>, 0.2172 }
			cylinder { <-1.3205, 96.5622, -0.4969>, <-1.3444, 97.2732, -0.592>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.3444, 97.2732, -0.592>, <-1.3789, 100.623, -1.06839>, 0.2172 }
				cylinder { <-1.3789, 100.623, -1.06839>, <-1.3352, 103.9685, -1.5722>, 0.2172 }
				cylinder { <-1.3352, 103.9685, -1.5722>, <-1.2133, 107.3079, -2.1034>, 0.2172 }
				cylinder { <-1.2133, 107.3079, -2.1034>, <-1.0133, 110.6391, -2.6616>, 0.2172 }
				cylinder { <-1.0133, 110.6391, -2.6616>, <-0.7352, 113.9601, -3.2464>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.7352, 113.9601, -3.2464>, <-0.6377, 114.741, -3.2986>, <-0.7191, 114.7601, -3.3272> }
					triangle { <-0.6377, 114.741, -3.2986>, <-0.6454, 115.1787, -3.2879>, <-0.7191, 114.7601, -3.3272> }
					triangle { <-0.6454, 115.1787, -3.2879>, <-0.7355, 115.1975, -3.3221>, <-0.7191, 114.7601, -3.3272> }
					triangle { <-0.6454, 115.1787, -3.2879>, <-0.7628, 115.822, -3.3281>, <-0.7355, 115.1975, -3.3221> }
					triangle { <-0.7355, 115.1975, -3.3221>, <-0.7628, 115.822, -3.3281>, <-0.8025, 115.174, -3.3901> }
					triangle { <-0.7191, 114.7601, -3.3272>, <-0.7355, 115.1975, -3.3221>, <-0.8025, 115.174, -3.3901> }
					triangle { <-0.7191, 114.7601, -3.3272>, <-0.8025, 115.174, -3.3901>, <-0.783, 114.737, -3.3807> }
					triangle { <-0.7191, 114.7601, -3.3272>, <-0.783, 114.737, -3.3807>, <-0.7352, 113.9601, -3.2464> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.3444, 97.2732, -0.592>, <-1.3846, 97.9826, -0.6938>, 0.2172 }
			cylinder { <-1.3846, 97.9826, -0.6938>, <-1.441, 98.6898, -0.802>, 0.2172 }
			cylinder { <-1.441, 98.6898, -0.802>, <-1.5135, 99.3946, -0.9167>, 0.2172 }
			cylinder { <-1.5135, 99.3946, -0.9167>, <-1.6023, 100.0965, -1.03785>, 0.2172 }
			cylinder { <-1.6023, 100.0965, -1.03785>, <-1.7071, 100.795, -1.1652>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.7071, 100.795, -1.1652>, <-2.2768, 104.0702, -1.7954>, 0.2172 }
				cylinder { <-2.2768, 104.0702, -1.7954>, <-2.9218, 107.3256, -2.4547>, 0.2172 }
				cylinder { <-2.9218, 107.3256, -2.4547>, <-3.6417, 110.5594, -3.1426>, 0.2172 }
				cylinder { <-3.6417, 110.5594, -3.1426>, <-4.436, 113.7695, -3.8587>, 0.2172 }
				cylinder { <-4.436, 113.7695, -3.8587>, <-5.3042, 116.954, -4.6027>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-5.3042, 116.954, -4.6027>, <-5.696, 117.5856, -4.7123>, <-5.6519, 117.6342, -4.6598> }
					triangle { <-5.696, 117.5856, -4.7123>, <-5.8511, 117.966, -4.7845>, <-5.6519, 117.6342, -4.6598> }
					triangle { <-5.8511, 117.966, -4.7845>, <-5.8025, 118.0178, -4.7237>, <-5.6519, 117.6342, -4.6598> }
					triangle { <-5.8511, 117.966, -4.7845>, <-6.01983, 118.5667, -4.8022>, <-5.8025, 118.0178, -4.7237> }
					triangle { <-5.8025, 118.0178, -4.7237>, <-6.01983, 118.5667, -4.8022>, <-5.7694, 118.0228, -4.6363> }
					triangle { <-5.6519, 117.6342, -4.6598>, <-5.8025, 118.0178, -4.7237>, <-5.7694, 118.0228, -4.6363> }
					triangle { <-5.6519, 117.6342, -4.6598>, <-5.7694, 118.0228, -4.6363>, <-5.6155, 117.6388, -4.586> }
					triangle { <-5.6519, 117.6342, -4.6598>, <-5.6155, 117.6388, -4.586>, <-5.3042, 116.954, -4.6027> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.7071, 100.795, -1.1652>, <-1.8045, 101.4972, -1.2771>, 0.2172 }
			cylinder { <-1.8045, 101.4972, -1.2771>, <-1.8945, 102.2028, -1.3734>, 0.2172 }
			cylinder { <-1.8945, 102.2028, -1.3734>, <-1.9769, 102.9112, -1.454>, 0.2172 }
			cylinder { <-1.9769, 102.9112, -1.454>, <-2.05183, 103.622, -1.5189>, 0.2172 }
			cylinder { <-2.05183, 103.622, -1.5189>, <-2.119, 104.3349, -1.568>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.119, 104.3349, -1.568>, <-2.4001, 107.7031, -1.7252>, 0.2172 }
				cylinder { <-2.4001, 107.7031, -1.7252>, <-2.6449, 111.0768, -1.8078>, 0.2172 }
				cylinder { <-2.6449, 111.0768, -1.8078>, <-2.8533, 114.4539, -1.8159>, 0.2172 }
				cylinder { <-2.8533, 114.4539, -1.8159>, <-3.02524, 117.8324, -1.7495>, 0.2172 }
				cylinder { <-3.02524, 117.8324, -1.7495>, <-3.1605, 121.2104, -1.6085>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.1605, 121.2104, -1.6085>, <-3.2376, 121.9173, -1.5283>, <-3.2261, 121.9371, -1.6051> }
					triangle { <-3.2376, 121.9173, -1.5283>, <-3.324, 122.305, -1.5341>, <-3.2261, 121.9371, -1.6051> }
					triangle { <-3.324, 122.305, -1.5341>, <-3.3086, 122.3254, -1.6195>, <-3.2261, 121.9371, -1.6051> }
					triangle { <-3.324, 122.305, -1.5341>, <-3.4152, 122.8819, -1.6453>, <-3.3086, 122.3254, -1.6195> }
					triangle { <-3.3086, 122.3254, -1.6195>, <-3.4152, 122.8819, -1.6453>, <-3.2531, 122.3144, -1.6884> }
					triangle { <-3.2261, 121.9371, -1.6051>, <-3.3086, 122.3254, -1.6195>, <-3.2531, 122.3144, -1.6884> }
					triangle { <-3.2261, 121.9371, -1.6051>, <-3.2531, 122.3144, -1.6884>, <-3.183, 121.9241, -1.6693> }
					triangle { <-3.2261, 121.9371, -1.6051>, <-3.183, 121.9241, -1.6693>, <-3.1605, 121.2104, -1.6085> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.6099, 90.1965, 0.3024>, <-0.6536, 90.9129, 0.2943>, 0.2172 }
			cylinder { <-0.6536, 90.9129, 0.2943>, <-0.7055, 91.6287, 0.3018>, 0.2172 }
			cylinder { <-0.7055, 91.6287, 0.3018>, <-0.7656, 92.3435, 0.3249>, 0.2172 }
			cylinder { <-0.7656, 92.3435, 0.3249>, <-0.8339, 93.05698, 0.3635>, 0.2172 }
			cylinder { <-0.8339, 93.05698, 0.3635>, <-0.9103, 93.7685, 0.4177>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.9103, 93.7685, 0.4177>, <-1.02583, 94.4596, 0.5734>, 0.2172 }
			cylinder { <-1.02583, 94.4596, 0.5734>, <-1.1251, 95.1544, 0.7234>, 0.2172 }
			cylinder { <-1.1251, 95.1544, 0.7234>, <-1.2081, 95.8526, 0.8675>, 0.2172 }
			cylinder { <-1.2081, 95.8526, 0.8675>, <-1.2749, 96.5537, 1.005752>, 0.2172 }
			cylinder { <-1.2749, 96.5537, 1.005752>, <-1.3252, 97.2574, 1.1379>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.3252, 97.2574, 1.1379>, <-1.4853, 100.5845, 1.7322>, 0.2172 }
				cylinder { <-1.4853, 100.5845, 1.7322>, <-1.5681, 103.9195, 2.2974>, 0.2172 }
				cylinder { <-1.5681, 103.9195, 2.2974>, <-1.5734, 107.2604, 2.8332>, 0.2172 }
				cylinder { <-1.5734, 107.2604, 2.8332>, <-1.5013, 110.6051, 3.3392>, 0.2172 }
				cylinder { <-1.5013, 110.6051, 3.3392>, <-1.3518, 113.9517, 3.8151>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.3518, 113.9517, 3.8151>, <-1.1929, 114.7641, 3.8226>, <-1.2807, 114.7928, 3.814> }
					triangle { <-1.1929, 114.7641, 3.8226>, <-1.1589, 115.2187, 3.8817>, <-1.2807, 114.7928, 3.814> }
					triangle { <-1.1589, 115.2187, 3.8817>, <-1.2568, 115.2484, 3.8694>, <-1.2807, 114.7928, 3.814> }
					triangle { <-1.1589, 115.2187, 3.8817>, <-1.2296, 115.9006, 3.9358>, <-1.2568, 115.2484, 3.8694> }
					triangle { <-1.2568, 115.2484, 3.8694>, <-1.2296, 115.9006, 3.9358>, <-1.3423, 115.2366, 3.8129> }
					triangle { <-1.2807, 114.7928, 3.814>, <-1.2568, 115.2484, 3.8694>, <-1.3423, 115.2366, 3.8129> }
					triangle { <-1.2807, 114.7928, 3.814>, <-1.3423, 115.2366, 3.8129>, <-1.3598, 114.7796, 3.7716> }
					triangle { <-1.2807, 114.7928, 3.814>, <-1.3598, 114.7796, 3.7716>, <-1.3518, 113.9517, 3.8151> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.3252, 97.2574, 1.1379>, <-1.392, 97.9608, 1.2636>, 0.2172 }
			cylinder { <-1.392, 97.9608, 1.2636>, <-1.4751, 98.6637, 1.3828>, 0.2172 }
			cylinder { <-1.4751, 98.6637, 1.3828>, <-1.5745, 99.3655, 1.4954>, 0.2172 }
			cylinder { <-1.5745, 99.3655, 1.4954>, <-1.6901, 100.0659, 1.6014>, 0.2172 }
			cylinder { <-1.6901, 100.0659, 1.6014>, <-1.8219, 100.7644, 1.7006>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.8219, 100.7644, 1.7006>, <-2.5193, 104.0466, 2.1365>, 0.2172 }
				cylinder { <-2.5193, 104.0466, 2.1365>, <-3.2921, 107.3159, 2.5401>, 0.2172 }
				cylinder { <-3.2921, 107.3159, 2.5401>, <-4.1398, 110.5704, 2.9113>, 0.2172 }
				cylinder { <-4.1398, 110.5704, 2.9113>, <-5.06215, 113.8082, 3.2497>, 0.2172 }
				cylinder { <-5.06215, 113.8082, 3.2497>, <-6.05833, 117.0273, 3.5553>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-6.05833, 117.0273, 3.5553>, <-6.2594, 117.7898, 3.5424>, <-6.2208, 117.8124, 3.6186> }
					triangle { <-6.2594, 117.7898, 3.5424>, <-6.2996, 118.2258, 3.5475>, <-6.2208, 117.8124, 3.6186> }
					triangle { <-6.2996, 118.2258, 3.5475>, <-6.2583, 118.2483, 3.6338>, <-6.2208, 117.8124, 3.6186> }
					triangle { <-6.2996, 118.2258, 3.5475>, <-6.3178, 118.8696, 3.6677>, <-6.2583, 118.2483, 3.6338> }
					triangle { <-6.2583, 118.2483, 3.6338>, <-6.3178, 118.8696, 3.6677>, <-6.2514, 118.2237, 3.7286> }
					triangle { <-6.2208, 117.8124, 3.6186>, <-6.2583, 118.2483, 3.6338>, <-6.2514, 118.2237, 3.7286> }
					triangle { <-6.2208, 117.8124, 3.6186>, <-6.2514, 118.2237, 3.7286>, <-6.2066, 117.7894, 3.7008> }
					triangle { <-6.2208, 117.8124, 3.6186>, <-6.2066, 117.7894, 3.7008>, <-6.05833, 117.0273, 3.5553> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.8219, 100.7644, 1.7006>, <-1.946, 101.4619, 1.8156>, 0.2172 }
			cylinder { <-1.946, 101.4619, 1.8156>, <-2.06224, 102.158, 1.9463>, 0.2172 }
			cylinder { <-2.06224, 102.158, 1.9463>, <-2.1705, 102.8523, 2.09273>, 0.2172 }
			cylinder { <-2.1705, 102.8523, 2.09273>, <-2.2708, 103.5443, 2.2546>, 0.2172 }
			cylinder { <-2.2708, 103.5443, 2.2546>, <-2.363, 104.2336, 2.4319>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.363, 104.2336, 2.4319>, <-2.7597, 107.4688, 3.3401>, 0.2172 }
				cylinder { <-2.7597, 107.4688, 3.3401>, <-3.1179, 110.6874, 4.3201>, 0.2172 }
				cylinder { <-3.1179, 110.6874, 4.3201>, <-3.4375, 113.8877, 5.3713>, 0.2172 }
				cylinder { <-3.4375, 113.8877, 5.3713>, <-3.7183, 117.0675, 6.4929>, 0.2172 }
				cylinder { <-3.7183, 117.0675, 6.4929>, <-3.96, 120.2251, 7.6844>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.96, 120.2251, 7.6844>, <-3.821, 120.872, 8.04033>, <-3.8244, 120.9219, 7.9726> }
					triangle { <-3.821, 120.872, 8.04033>, <-3.8009, 121.2548, 8.2048>, <-3.8244, 120.9219, 7.9726> }
					triangle { <-3.8009, 121.2548, 8.2048>, <-3.8026, 121.3082, 8.128>, <-3.8244, 120.9219, 7.9726> }
					triangle { <-3.8009, 121.2548, 8.2048>, <-3.7613, 121.8624, 8.3421>, <-3.8026, 121.3082, 8.128> }
					triangle { <-3.8026, 121.3082, 8.128>, <-3.7613, 121.8624, 8.3421>, <-3.7693, 121.3189, 8.04126> }
					triangle { <-3.8244, 120.9219, 7.9726>, <-3.8026, 121.3082, 8.128>, <-3.7693, 121.3189, 8.04126> }
					triangle { <-3.8244, 120.9219, 7.9726>, <-3.7693, 121.3189, 8.04126>, <-3.8026, 120.9305, 7.8936> }
					triangle { <-3.8244, 120.9219, 7.9726>, <-3.8026, 120.9305, 7.8936>, <-3.96, 120.2251, 7.6844> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-2.363, 104.2336, 2.4319>, <-2.4508, 104.9275, 2.5928>, 0.2172 }
			cylinder { <-2.4508, 104.9275, 2.5928>, <-2.5341, 105.6256, 2.7372>, 0.2172 }
			cylinder { <-2.5341, 105.6256, 2.7372>, <-2.6128, 106.3275, 2.865>, 0.2172 }
			cylinder { <-2.6128, 106.3275, 2.865>, <-2.687, 107.0327, 2.9761>, 0.2172 }
			cylinder { <-2.687, 107.0327, 2.9761>, <-2.7565, 107.7408, 3.07055>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.7565, 107.7408, 3.07055>, <-3.06213, 111.0906, 3.4363>, 0.2172 }
				cylinder { <-3.06213, 111.0906, 3.4363>, <-3.3454, 114.4501, 3.7226>, 0.2172 }
				cylinder { <-3.3454, 114.4501, 3.7226>, <-3.6063, 117.8172, 3.9294>, 0.2172 }
				cylinder { <-3.6063, 117.8172, 3.9294>, <-3.8446, 121.19, 4.05645>, 0.2172 }
				cylinder { <-3.8446, 121.19, 4.05645>, <-4.06013, 124.5664, 4.1037>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-4.06013, 124.5664, 4.1037>, <-4.03552, 125.2815, 4.1089>, <-4.09755, 125.293, 4.1583> }
					triangle { <-4.03552, 125.2815, 4.1089>, <-4.02276, 125.6725, 4.1783>, <-4.09755, 125.293, 4.1583> }
					triangle { <-4.02276, 125.6725, 4.1783>, <-4.09345, 125.6835, 4.2314>, <-4.09755, 125.293, 4.1583> }
					triangle { <-4.02276, 125.6725, 4.1783>, <-4.09949, 126.2416, 4.3322>, <-4.09345, 125.6835, 4.2314> }
					triangle { <-4.09345, 125.6835, 4.2314>, <-4.09949, 126.2416, 4.3322>, <-4.1788, 125.6617, 4.2449> }
					triangle { <-4.09755, 125.293, 4.1583>, <-4.09345, 125.6835, 4.2314>, <-4.1788, 125.6617, 4.2449> }
					triangle { <-4.09755, 125.293, 4.1583>, <-4.1788, 125.6617, 4.2449>, <-4.1705, 125.2707, 4.1767> }
					triangle { <-4.09755, 125.293, 4.1583>, <-4.1705, 125.2707, 4.1767>, <-4.06013, 124.5664, 4.1037> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.2196, 4.2104, 0.2196>, 0.07155 }
			cylinder { <0.2196, 4.2104, 0.2196>, <0.6576, 8.3865, 0.6576>, 0.07155 }
			cylinder { <0.6576, 8.3865, 0.6576>, <1.3117, 12.5058, 1.3117>, 0.07155 }
			cylinder { <1.3117, 12.5058, 1.3117>, <2.1783, 16.5459, 2.1783>, 0.07155 }
			cylinder { <2.1783, 16.5459, 2.1783>, <3.2527, 20.4849, 3.2527>, 0.07155 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <3.2527, 20.4849, 3.2527>, <3.522, 21.2952, 3.4913>, 0.07155 }
				cylinder { <3.522, 21.2952, 3.4913>, <3.8343, 22.08614, 3.7422>, 0.07155 }
				cylinder { <3.8343, 22.08614, 3.7422>, <4.1885, 22.8553, 4.004752>, 0.07155 }
				cylinder { <4.1885, 22.8553, 4.004752>, <4.5836, 23.6004, 4.278>, 0.07155 }
				cylinder { <4.5836, 23.6004, 4.278>, <5.0184, 24.3193, 4.5613>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.0184, 24.3193, 4.5613>, <5.07372, 24.3894, 4.5766>, 0.001536 }
				cylinder { <5.07372, 24.3894, 4.5766>, <5.1377, 24.4536, 4.5777>, 0.001536 }
				cylinder { <5.1377, 24.4536, 4.5777>, <5.2081, 24.5092, 4.5645>, 0.001536 }
				cylinder { <5.2081, 24.5092, 4.5645>, <5.282, 24.5541, 4.5375>, 0.001536 }
				cylinder { <5.282, 24.5541, 4.5375>, <5.3566, 24.5867, 4.4978>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.3566, 24.5867, 4.4978>, <6.04994, 24.9783, 3.9771>, <6.1001, 24.9745, 4.02481> }
				triangle { <6.04994, 24.9783, 3.9771>, <6.423, 25.2811, 3.7059>, <6.1001, 24.9745, 4.02481> }
				triangle { <6.423, 25.2811, 3.7059>, <6.4636, 25.286, 3.7712>, <6.1001, 24.9745, 4.02481> }
				triangle { <6.423, 25.2811, 3.7059>, <7.4541, 26.4553, 2.9763>, <6.4636, 25.286, 3.7712> }
				triangle { <6.4636, 25.286, 3.7712>, <7.4541, 26.4553, 2.9763>, <6.4945, 25.2856, 3.8429> }
				triangle { <6.1001, 24.9745, 4.02481>, <6.4636, 25.286, 3.7712>, <6.4945, 25.2856, 3.8429> }
				triangle { <6.1001, 24.9745, 4.02481>, <6.4945, 25.2856, 3.8429>, <6.1253, 24.9714, 4.08556> }
				triangle { <6.1001, 24.9745, 4.02481>, <6.1253, 24.9714, 4.08556>, <5.3566, 24.5867, 4.4978> }
				triangle { <7.9391, 27.1471, 2.6386>, <7.4541, 26.4553, 2.9763>, <7.3844, 26.4787, 2.8901> }
				triangle { <6.4945, 25.2856, 3.8429>, <7.4541, 26.4553, 2.9763>, <7.506, 26.5072, 3.09745> }
				triangle { <6.423, 25.2811, 3.7059>, <7.3844, 26.4787, 2.8901>, <7.4541, 26.4553, 2.9763> }
				triangle { <7.9391, 27.1471, 2.6386>, <7.506, 26.5072, 3.09745>, <7.4541, 26.4553, 2.9763> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <5.0184, 24.3193, 4.5613>, <5.4386, 25.04035, 4.8607>, 0.07155 }
				cylinder { <5.4386, 25.04035, 4.8607>, <5.844, 25.763, 5.1759>, 0.07155 }
				cylinder { <5.844, 25.763, 5.1759>, <6.2343, 26.4871, 5.5067>, 0.07155 }
				cylinder { <6.2343, 26.4871, 5.5067>, <6.6094, 27.2119, 5.8531>, 0.07155 }
				cylinder { <6.6094, 27.2119, 5.8531>, <6.969, 27.9372, 6.2146>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <6.969, 27.9372, 6.2146>, <6.994, 28.01044, 6.2618>, 0.001536 }
				cylinder { <6.994, 28.01044, 6.2618>, <7.00678, 28.08052, 6.3179>, 0.001536 }
				cylinder { <7.00678, 28.08052, 6.3179>, <7.006684, 28.1454, 6.3811>, 0.001536 }
				cylinder { <7.006684, 28.1454, 6.3811>, <6.9938, 28.2032, 6.4497>, 0.001536 }
				cylinder { <6.9938, 28.2032, 6.4497>, <6.9685, 28.2523, 6.5216>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <6.9685, 28.2523, 6.5216>, <6.6559, 28.865, 7.1788>, <6.6595, 28.8222, 7.2333> }
				triangle { <6.6559, 28.865, 7.1788>, <6.3954, 29.1927, 7.5383>, <6.6595, 28.8222, 7.2333> }
				triangle { <6.3954, 29.1927, 7.5383>, <6.3885, 29.1322, 7.5853>, <6.6595, 28.8222, 7.2333> }
				triangle { <6.3954, 29.1927, 7.5383>, <5.3381, 30.1037, 8.5513>, <6.3885, 29.1322, 7.5853> }
				triangle { <6.3885, 29.1322, 7.5853>, <5.3381, 30.1037, 8.5513>, <6.3857, 29.06398, 7.6232> }
				triangle { <6.6595, 28.8222, 7.2333>, <6.3885, 29.1322, 7.5853>, <6.3857, 29.06398, 7.6232> }
				triangle { <6.6595, 28.8222, 7.2333>, <6.3857, 29.06398, 7.6232>, <6.6598, 28.7641, 7.2642> }
				triangle { <6.6595, 28.8222, 7.2333>, <6.6598, 28.7641, 7.2642>, <6.9685, 28.2523, 6.5216> }
				triangle { <4.7015, 30.5371, 9.03587>, <5.3381, 30.1037, 8.5513>, <5.3165, 30.1843, 8.4747> }
				triangle { <6.3857, 29.06398, 7.6232>, <5.3381, 30.1037, 8.5513>, <5.2811, 29.9923, 8.6178> }
				triangle { <6.3954, 29.1927, 7.5383>, <5.3165, 30.1843, 8.4747>, <5.3381, 30.1037, 8.5513> }
				triangle { <4.7015, 30.5371, 9.03587>, <5.2811, 29.9923, 8.6178>, <5.3381, 30.1037, 8.5513> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <6.969, 27.9372, 6.2146>, <7.3285, 28.6625, 6.5762>, 0.07155 }
				cylinder { <7.3285, 28.6625, 6.5762>, <7.6881, 29.3878, 6.9378>, 0.07155 }
				cylinder { <7.6881, 29.3878, 6.9378>, <8.04766, 30.1131, 7.2993>, 0.07155 }
				cylinder { <8.04766, 30.1131, 7.2993>, <8.4072, 30.8383, 7.6609>, 0.07155 }
				cylinder { <8.4072, 30.8383, 7.6609>, <8.7667, 31.5636, 8.02252>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <8.7667, 31.5636, 8.02252>, <8.8126, 31.6368, 8.04983>, 0.001536 }
				cylinder { <8.8126, 31.6368, 8.04983>, <8.8667, 31.7076, 8.06689>, 0.001536 }
				cylinder { <8.8667, 31.7076, 8.06689>, <8.9277, 31.7742, 8.07333>, 0.001536 }
				cylinder { <8.9277, 31.7742, 8.07333>, <8.9944, 31.8354, 8.06902>, 0.001536 }
				cylinder { <8.9944, 31.8354, 8.06902>, <9.06543, 31.8898, 8.05405>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <9.06543, 31.8898, 8.05405>, <9.7313, 32.514, 7.7858>, <9.7714, 32.5092, 7.8423> }
				triangle { <9.7313, 32.514, 7.7858>, <10.06655, 32.9359, 7.6667>, <9.7714, 32.5092, 7.8423> }
				triangle { <10.06655, 32.9359, 7.6667>, <10.09205, 32.9335, 7.7394>, <9.7714, 32.5092, 7.8423> }
				triangle { <10.06655, 32.9359, 7.6667>, <10.9099, 34.4194, 7.4178>, <10.09205, 32.9335, 7.7394> }
				triangle { <10.09205, 32.9335, 7.7394>, <10.9099, 34.4194, 7.4178>, <10.1084, 32.9228, 7.815> }
				triangle { <9.7714, 32.5092, 7.8423>, <10.09205, 32.9335, 7.7394>, <10.1084, 32.9228, 7.815> }
				triangle { <9.7714, 32.5092, 7.8423>, <10.1084, 32.9228, 7.815>, <9.7849, 32.4973, 7.9056> }
				triangle { <9.7714, 32.5092, 7.8423>, <9.7849, 32.4973, 7.9056>, <9.06543, 31.8898, 8.05405> }
				triangle { <11.2729, 35.2492, 7.3312>, <10.9099, 34.4194, 7.4178>, <10.8538, 34.448, 7.3236> }
				triangle { <10.1084, 32.9228, 7.815>, <10.9099, 34.4194, 7.4178>, <10.9249, 34.4515, 7.5549> }
				triangle { <10.06655, 32.9359, 7.6667>, <10.8538, 34.448, 7.3236>, <10.9099, 34.4194, 7.4178> }
				triangle { <11.2729, 35.2492, 7.3312>, <10.9249, 34.4515, 7.5549>, <10.9099, 34.4194, 7.4178> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <8.7667, 31.5636, 8.02252>, <9.1263, 32.2889, 8.384>, 0.07155 }
				cylinder { <9.1263, 32.2889, 8.384>, <9.4858, 33.01423, 8.7456>, 0.07155 }
				cylinder { <9.4858, 33.01423, 8.7456>, <9.8454, 33.7395, 9.1072>, 0.07155 }
				cylinder { <9.8454, 33.7395, 9.1072>, <10.2049, 34.4647, 9.4688>, 0.07155 }
				cylinder { <10.2049, 34.4647, 9.4688>, <10.5645, 35.19, 9.8303>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <10.5645, 35.19, 9.8303>, <10.5896, 35.2632, 9.8775>, 0.001536 }
				cylinder { <10.5896, 35.2632, 9.8775>, <10.6022, 35.3333, 9.9336>, 0.001536 }
				cylinder { <10.6022, 35.3333, 9.9336>, <10.6022, 35.3982, 9.9968>, 0.001536 }
				cylinder { <10.6022, 35.3982, 9.9968>, <10.5893, 35.456, 10.06547>, 0.001536 }
				cylinder { <10.5893, 35.456, 10.06547>, <10.564, 35.5051, 10.1373>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.564, 35.5051, 10.1373>, <10.2514, 36.1178, 10.7945>, <10.255, 36.07511, 10.849> }
				triangle { <10.2514, 36.1178, 10.7945>, <9.9909, 36.4456, 11.154>, <10.255, 36.07511, 10.849> }
				triangle { <9.9909, 36.4456, 11.154>, <9.984, 36.385, 11.2011>, <10.255, 36.07511, 10.849> }
				triangle { <9.9909, 36.4456, 11.154>, <8.9336, 37.3565, 12.167>, <9.984, 36.385, 11.2011> }
				triangle { <9.984, 36.385, 11.2011>, <8.9336, 37.3565, 12.167>, <9.9812, 36.3168, 11.2389> }
				triangle { <10.255, 36.07511, 10.849>, <9.984, 36.385, 11.2011>, <9.9812, 36.3168, 11.2389> }
				triangle { <10.255, 36.07511, 10.849>, <9.9812, 36.3168, 11.2389>, <10.2553, 36.01701, 10.8799> }
				triangle { <10.255, 36.07511, 10.849>, <10.2553, 36.01701, 10.8799>, <10.564, 35.5051, 10.1373> }
				triangle { <8.297, 37.7899, 12.6515>, <8.9336, 37.3565, 12.167>, <8.912, 37.4371, 12.09046> }
				triangle { <9.9812, 36.3168, 11.2389>, <8.9336, 37.3565, 12.167>, <8.8766, 37.2452, 12.2335> }
				triangle { <9.9909, 36.4456, 11.154>, <8.912, 37.4371, 12.09046>, <8.9336, 37.3565, 12.167> }
				triangle { <8.297, 37.7899, 12.6515>, <8.8766, 37.2452, 12.2335>, <8.9336, 37.3565, 12.167> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <10.5645, 35.19, 9.8303>, <10.6028, 35.2641, 9.8657>, 0.001536 }
				cylinder { <10.6028, 35.2641, 9.8657>, <10.6427, 35.3381, 9.8996>, 0.001536 }
				cylinder { <10.6427, 35.3381, 9.8996>, <10.6842, 35.412, 9.9318>, 0.001536 }
				cylinder { <10.6842, 35.412, 9.9318>, <10.7271, 35.4857, 9.9624>, 0.001536 }
				cylinder { <10.7271, 35.4857, 9.9624>, <10.7716, 35.5592, 9.9913>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.7716, 35.5592, 9.9913>, <11.1779, 36.3983, 10.1807>, <11.1997, 36.3834, 10.2449> }
				triangle { <11.1779, 36.3983, 10.1807>, <11.335, 36.909, 10.3185>, <11.1997, 36.3834, 10.2449> }
				triangle { <11.335, 36.909, 10.3185>, <11.3387, 36.8859, 10.3919>, <11.1997, 36.3834, 10.2449> }
				triangle { <11.335, 36.909, 10.3185>, <11.5482, 38.5449, 10.821>, <11.3387, 36.8859, 10.3919> }
				triangle { <11.3387, 36.8859, 10.3919>, <11.5482, 38.5449, 10.821>, <11.3369, 36.8518, 10.4621> }
				triangle { <11.1997, 36.3834, 10.2449>, <11.3387, 36.8859, 10.3919>, <11.3369, 36.8518, 10.4621> }
				triangle { <11.1997, 36.3834, 10.2449>, <11.3369, 36.8518, 10.4621>, <11.1991, 36.3522, 10.3029> }
				triangle { <11.1997, 36.3834, 10.2449>, <11.1991, 36.3522, 10.3029>, <10.7716, 35.5592, 9.9913> }
				triangle { <11.5579, 39.409, 11.1059>, <11.5482, 38.5449, 10.821>, <11.513, 38.5907, 10.7236> }
				triangle { <11.3369, 36.8518, 10.4621>, <11.5482, 38.5449, 10.821>, <11.5114, 38.5241, 10.9562> }
				triangle { <11.335, 36.909, 10.3185>, <11.513, 38.5907, 10.7236>, <11.5482, 38.5449, 10.821> }
				triangle { <11.5579, 39.409, 11.1059>, <11.5114, 38.5241, 10.9562>, <11.5482, 38.5449, 10.821> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.2196, 4.2104, -0.2196>, 0.07155 }
			cylinder { <-0.2196, 4.2104, -0.2196>, <-0.6576, 8.3865, -0.6576>, 0.07155 }
			cylinder { <-0.6576, 8.3865, -0.6576>, <-1.3117, 12.5058, -1.3117>, 0.07155 }
			cylinder { <-1.3117, 12.5058, -1.3117>, <-2.1783, 16.5459, -2.1783>, 0.07155 }
			cylinder { <-2.1783, 16.5459, -2.1783>, <-3.2527, 20.4849, -3.2527>, 0.07155 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-3.2527, 20.4849, -3.2527>, <-3.4628, 21.3118, -3.4936>, 0.07155 }
				cylinder { <-3.4628, 21.3118, -3.4936>, <-3.6574, 22.138, -3.7497>, 0.07155 }
				cylinder { <-3.6574, 22.138, -3.7497>, <-3.8363, 22.9629, -4.0209>, 0.07155 }
				cylinder { <-3.8363, 22.9629, -4.0209>, <-3.9994, 23.7861, -4.3068>, 0.07155 }
				cylinder { <-3.9994, 23.7861, -4.3068>, <-4.1466, 24.6071, -4.6075>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.1466, 24.6071, -4.6075>, <-4.1712, 24.6916, -4.629>, 0.001536 }
				cylinder { <-4.1712, 24.6916, -4.629>, <-4.2049, 24.775, -4.6408>, 0.001536 }
				cylinder { <-4.2049, 24.775, -4.6408>, <-4.2469, 24.8552, -4.6426>, 0.001536 }
				cylinder { <-4.2469, 24.8552, -4.6426>, <-4.2963, 24.9308, -4.6343>, 0.001536 }
				cylinder { <-4.2963, 24.9308, -4.6343>, <-4.3521, 24.9999, -4.6163>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.3521, 24.9999, -4.6163>, <-4.8538, 25.7475, -4.309>, <-4.8908, 25.7578, -4.3668> }
				triangle { <-4.8538, 25.7475, -4.309>, <-5.07861, 26.2289, -4.1599>, <-4.8908, 25.7578, -4.3668> }
				triangle { <-5.07861, 26.2289, -4.1599>, <-5.1, 26.2392, -4.2331>, <-4.8908, 25.7578, -4.3668> }
				triangle { <-5.07861, 26.2289, -4.1599>, <-5.5359, 27.851, -3.7945>, <-5.1, 26.2392, -4.2331> }
				triangle { <-5.1, 26.2392, -4.2331>, <-5.5359, 27.851, -3.7945>, <-5.1145, 26.2396, -4.3098> }
				triangle { <-4.8908, 25.7578, -4.3668>, <-5.1, 26.2392, -4.2331>, <-5.1145, 26.2396, -4.3098> }
				triangle { <-4.8908, 25.7578, -4.3668>, <-5.1145, 26.2396, -4.3098>, <-4.9035, 25.7552, -4.4313> }
				triangle { <-4.8908, 25.7578, -4.3668>, <-4.9035, 25.7552, -4.4313>, <-4.3521, 24.9999, -4.6163> }
				triangle { <-5.6838, 28.7353, -3.6393>, <-5.5359, 27.851, -3.7945>, <-5.4794, 27.8563, -3.6964> }
				triangle { <-5.1145, 26.2396, -4.3098>, <-5.5359, 27.851, -3.7945>, <-5.5351, 27.8975, -3.9282> }
				triangle { <-5.07861, 26.2289, -4.1599>, <-5.4794, 27.8563, -3.6964>, <-5.5359, 27.851, -3.7945> }
				triangle { <-5.6838, 28.7353, -3.6393>, <-5.5351, 27.8975, -3.9282>, <-5.5359, 27.851, -3.7945> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.1466, 24.6071, -4.6075>, <-4.324, 25.4222, -4.9078>, 0.07155 }
				cylinder { <-4.324, 25.4222, -4.9078>, <-4.5314, 26.2305, -5.2073>, 0.07155 }
				cylinder { <-4.5314, 26.2305, -5.2073>, <-4.7685, 27.03106, -5.5056>, 0.07155 }
				cylinder { <-4.7685, 27.03106, -5.5056>, <-5.03515, 27.8227, -5.8025>, 0.07155 }
				cylinder { <-5.03515, 27.8227, -5.8025>, <-5.3308, 28.6047, -6.09764>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.3308, 28.6047, -6.09764>, <-5.3514, 28.6838, -6.1369>, 0.001536 }
				cylinder { <-5.3514, 28.6838, -6.1369>, <-5.3618, 28.7602, -6.1845>, 0.001536 }
				cylinder { <-5.3618, 28.7602, -6.1845>, <-5.3619, 28.8324, -6.2393>, 0.001536 }
				cylinder { <-5.3619, 28.8324, -6.2393>, <-5.3516, 28.8987, -6.3002>, 0.001536 }
				cylinder { <-5.3516, 28.8987, -6.3002>, <-5.3312, 28.9578, -6.3658>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.3312, 28.9578, -6.3658>, <-5.05926, 29.6594, -6.9479>, <-5.06846, 29.6255, -7.007774> }
				triangle { <-5.05926, 29.6594, -6.9479>, <-4.8214, 30.03467, -7.2752>, <-5.06846, 29.6255, -7.007774> }
				triangle { <-4.8214, 30.03467, -7.2752>, <-4.82, 29.9818, -7.3313>, <-5.06846, 29.6255, -7.007774> }
				triangle { <-4.8214, 30.03467, -7.2752>, <-3.8298, 31.07556, -8.2277>, <-4.82, 29.9818, -7.3313> }
				triangle { <-4.82, 29.9818, -7.3313>, <-3.8298, 31.07556, -8.2277>, <-4.8223, 29.9201, -7.3791> }
				triangle { <-5.06846, 29.6255, -7.007774>, <-4.82, 29.9818, -7.3313>, <-4.8223, 29.9201, -7.3791> }
				triangle { <-5.06846, 29.6255, -7.007774>, <-4.8223, 29.9201, -7.3791>, <-5.07289, 29.5727, -7.04692> }
				triangle { <-5.06846, 29.6255, -7.007774>, <-5.07289, 29.5727, -7.04692>, <-5.3312, 28.9578, -6.3658> }
				triangle { <-3.2251, 31.5695, -8.6949>, <-3.8298, 31.07556, -8.2277>, <-3.7998, 31.1432, -8.142> }
				triangle { <-4.8223, 29.9201, -7.3791>, <-3.8298, 31.07556, -8.2277>, <-3.7815, 30.9749, -8.3148> }
				triangle { <-4.8214, 30.03467, -7.2752>, <-3.7998, 31.1432, -8.142>, <-3.8298, 31.07556, -8.2277> }
				triangle { <-3.2251, 31.5695, -8.6949>, <-3.7815, 30.9749, -8.3148>, <-3.8298, 31.07556, -8.2277> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.3308, 28.6047, -6.09764>, <-5.6553, 29.3761, -6.3905>, 0.07155 }
				cylinder { <-5.6553, 29.3761, -6.3905>, <-6.008277, 30.1358, -6.6809>, 0.07155 }
				cylinder { <-6.008277, 30.1358, -6.6809>, <-6.3891, 30.883, -6.9685>, 0.07155 }
				cylinder { <-6.3891, 30.883, -6.9685>, <-6.7974, 31.6168, -7.2528>, 0.07155 }
				cylinder { <-6.7974, 31.6168, -7.2528>, <-7.2328, 32.3362, -7.5337>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-7.2328, 32.3362, -7.5337>, <-7.2868, 32.4071, -7.5503>, 0.001536 }
				cylinder { <-7.2868, 32.4071, -7.5503>, <-7.3486, 32.4732, -7.5545>, 0.001536 }
				cylinder { <-7.3486, 32.4732, -7.5545>, <-7.4165, 32.5326, -7.5459>, 0.001536 }
				cylinder { <-7.4165, 32.5326, -7.5459>, <-7.4885, 32.5836, -7.525>, 0.001536 }
				cylinder { <-7.4885, 32.5836, -7.525>, <-7.5624, 32.6246, -7.4923>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.5624, 32.6246, -7.4923>, <-8.25, 33.1052, -7.04375>, <-8.2978, 33.1015, -7.09394> }
				triangle { <-8.25, 33.1052, -7.04375>, <-8.6124, 33.4548, -6.8179>, <-8.2978, 33.1015, -7.09394> }
				triangle { <-8.6124, 33.4548, -6.8179>, <-8.6489, 33.4576, -6.8857>, <-8.2978, 33.1015, -7.09394> }
				triangle { <-8.6124, 33.4548, -6.8179>, <-9.5863, 34.7546, -6.2383>, <-8.6489, 33.4576, -6.8857> }
				triangle { <-8.6489, 33.4576, -6.8857>, <-9.5863, 34.7546, -6.2383>, <-8.6758, 33.454, -6.9589> }
				triangle { <-8.2978, 33.1015, -7.09394>, <-8.6489, 33.4576, -6.8857>, <-8.6758, 33.454, -6.9589> }
				triangle { <-8.2978, 33.1015, -7.09394>, <-8.6758, 33.454, -6.9589>, <-8.3197, 33.09568, -7.1557> }
				triangle { <-8.2978, 33.1015, -7.09394>, <-8.3197, 33.09568, -7.1557>, <-7.5624, 32.6246, -7.4923> }
				triangle { <-10.03332, 35.5043, -5.9812>, <-9.5863, 34.7546, -6.2383>, <-9.5198, 34.7794, -6.15> }
				triangle { <-8.6758, 33.454, -6.9589>, <-9.5863, 34.7546, -6.2383>, <-9.6274, 34.8008, -6.3657> }
				triangle { <-8.6124, 33.4548, -6.8179>, <-9.5198, 34.7794, -6.15>, <-9.5863, 34.7546, -6.2383> }
				triangle { <-10.03332, 35.5043, -5.9812>, <-9.6274, 34.8008, -6.3657>, <-9.5863, 34.7546, -6.2383> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-7.2328, 32.3362, -7.5337>, <-7.6538, 33.05774, -7.8308>, 0.07155 }
				cylinder { <-7.6538, 33.05774, -7.8308>, <-8.0603, 33.7808, -8.1439>, 0.07155 }
				cylinder { <-8.0603, 33.7808, -8.1439>, <-8.4518, 34.505, -8.4729>, 0.07155 }
				cylinder { <-8.4518, 34.505, -8.4729>, <-8.8283, 35.2299, -8.8176>, 0.07155 }
				cylinder { <-8.8283, 35.2299, -8.8176>, <-9.1895, 35.9551, -9.1777>, 0.07155 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-9.1895, 35.9551, -9.1777>, <-9.2149, 36.02818, -9.2249>, 0.001536 }
				cylinder { <-9.2149, 36.02818, -9.2249>, <-9.228, 36.09806, -9.2811>, 0.001536 }
				cylinder { <-9.228, 36.09806, -9.2811>, <-9.2285, 36.1626, -9.3447>, 0.001536 }
				cylinder { <-9.2285, 36.1626, -9.3447>, <-9.2163, 36.2201, -9.4137>, 0.001536 }
				cylinder { <-9.2163, 36.2201, -9.4137>, <-9.1918, 36.2687, -9.4862>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.1918, 36.2687, -9.4862>, <-8.8854, 36.8769, -10.1504>, <-8.8899, 36.8339, -10.2047> }
				triangle { <-8.8854, 36.8769, -10.1504>, <-8.6283, 37.2017, -10.5149>, <-8.8899, 36.8339, -10.2047> }
				triangle { <-8.6283, 37.2017, -10.5149>, <-8.6223, 37.1409, -10.5618>, <-8.8899, 36.8339, -10.2047> }
				triangle { <-8.6283, 37.2017, -10.5149>, <-7.5808, 38.1031, -11.5465>, <-8.6223, 37.1409, -10.5618> }
				triangle { <-8.6223, 37.1409, -10.5618>, <-7.5808, 38.1031, -11.5465>, <-8.6204, 37.07255, -10.5994> }
				triangle { <-8.8899, 36.8339, -10.2047>, <-8.6223, 37.1409, -10.5618>, <-8.6204, 37.07255, -10.5994> }
				triangle { <-8.8899, 36.8339, -10.2047>, <-8.6204, 37.07255, -10.5994>, <-8.8909, 36.7756, -10.2353> }
				triangle { <-8.8899, 36.8339, -10.2047>, <-8.8909, 36.7756, -10.2353>, <-9.1918, 36.2687, -9.4862> }
				triangle { <-6.9489, 38.5314, -12.0417>, <-7.5808, 38.1031, -11.5465>, <-7.5578, 38.184, -11.4706> }
				triangle { <-8.6204, 37.07255, -10.5994>, <-7.5808, 38.1031, -11.5465>, <-7.5252, 37.9912, -11.6132> }
				triangle { <-8.6283, 37.2017, -10.5149>, <-7.5578, 38.184, -11.4706>, <-7.5808, 38.1031, -11.5465> }
				triangle { <-6.9489, 38.5314, -12.0417>, <-7.5252, 37.9912, -11.6132>, <-7.5808, 38.1031, -11.5465> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-9.1895, 35.9551, -9.1777>, <-9.2248, 36.02922, -9.2161>, 0.001536 }
				cylinder { <-9.2248, 36.02922, -9.2161>, <-9.2586, 36.1032, -9.256>, 0.001536 }
				cylinder { <-9.2586, 36.1032, -9.256>, <-9.2907, 36.1772, -9.2974>, 0.001536 }
				cylinder { <-9.2907, 36.1772, -9.2974>, <-9.3211, 36.251, -9.3403>, 0.001536 }
				cylinder { <-9.3211, 36.251, -9.3403>, <-9.3499, 36.3246, -9.3847>, 0.001536 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.3499, 36.3246, -9.3847>, <-9.5957, 37.1727, -9.7387>, <-9.6119, 37.1513, -9.8027> }
				triangle { <-9.5957, 37.1727, -9.7387>, <-9.6542, 37.6731, -9.9639>, <-9.6119, 37.1513, -9.8027> }
				triangle { <-9.6542, 37.6731, -9.9639>, <-9.6529, 37.6397, -10.03335>, <-9.6119, 37.1513, -9.8027> }
				triangle { <-9.6542, 37.6731, -9.9639>, <-9.55, 39.2265, -10.7055>, <-9.6529, 37.6397, -10.03335> }
				triangle { <-9.6529, 37.6397, -10.03335>, <-9.55, 39.2265, -10.7055>, <-9.6483, 37.5954, -10.09745> }
				triangle { <-9.6119, 37.1513, -9.8027>, <-9.6529, 37.6397, -10.03335>, <-9.6483, 37.5954, -10.09745> }
				triangle { <-9.6119, 37.1513, -9.8027>, <-9.6483, 37.5954, -10.09745>, <-9.6095, 37.1119, -9.8553> }
				triangle { <-9.6119, 37.1513, -9.8027>, <-9.6095, 37.1119, -9.8553>, <-9.3499, 36.3246, -9.3847> }
				triangle { <-9.3918, 40.02996, -11.1022>, <-9.55, 39.2265, -10.7055>, <-9.5196, 39.2814, -10.6112> }
				triangle { <-9.6483, 37.5954, -10.09745>, <-9.55, 39.2265, -10.7055>, <-9.5015, 39.1804, -10.8303> }
				triangle { <-9.6542, 37.6731, -9.9639>, <-9.5196, 39.2814, -10.6112>, <-9.55, 39.2265, -10.7055> }
				triangle { <-9.3918, 40.02996, -11.1022>, <-9.5015, 39.1804, -10.8303>, <-9.55, 39.2265, -10.7055> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.004752, 1.9714, -0.09673>, 0.03345 }
			cylinder { <-0.004752, 1.9714, -0.09673>, <-0.01424, 3.9358, -0.2899>, 0.03345 }
			cylinder { <-0.01424, 3.9358, -0.2899>, <-0.02845, 5.8882, -0.5792>, 0.03345 }
			cylinder { <-0.02845, 5.8882, -0.5792>, <-0.04735, 7.8241, -0.9638>, 0.03345 }
			cylinder { <-0.04735, 7.8241, -0.9638>, <-0.07088, 9.7388, -1.4428>, 0.03345 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.07088, 9.7388, -1.4428>, <-0.06566, 10.1408, -1.5439>, 0.03345 }
				cylinder { <-0.06566, 10.1408, -1.5439>, <-0.05028, 10.5424, -1.6454>, 0.03345 }
				cylinder { <-0.05028, 10.5424, -1.6454>, <-0.02475, 10.9434, -1.7472>, 0.03345 }
				cylinder { <-0.02475, 10.9434, -1.7472>, <0.0109, 11.3435, -1.8493>, 0.03345 }
				cylinder { <0.0109, 11.3435, -1.8493>, <0.05667, 11.7426, -1.9516>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.05667, 11.7426, -1.9516>, <0.05595, 11.7618, -1.9564>, 0.0003357 }
				cylinder { <0.05595, 11.7618, -1.9564>, <0.05234, 11.7807, -1.961>, 0.0003357 }
				cylinder { <0.05234, 11.7807, -1.961>, <0.0459, 11.799, -1.9652>, 0.0003357 }
				cylinder { <0.0459, 11.799, -1.9652>, <0.0368, 11.8162, -1.9691>, 0.0003357 }
				cylinder { <0.0368, 11.8162, -1.9691>, <0.02521, 11.8319, -1.9725>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.02521, 11.8319, -1.9725>, <-0.2375, 12.1714, -2.08868>, <-0.224, 12.1775, -2.1175> }
				triangle { <-0.2375, 12.1714, -2.08868>, <-0.3632, 12.3916, -2.1364>, <-0.224, 12.1775, -2.1175> }
				triangle { <-0.3632, 12.3916, -2.1364>, <-0.3396, 12.3982, -2.1629>, <-0.224, 12.1775, -2.1175> }
				triangle { <-0.3632, 12.3916, -2.1364>, <-0.6581, 13.1382, -2.212>, <-0.3396, 12.3982, -2.1629> }
				triangle { <-0.3396, 12.3982, -2.1629>, <-0.6581, 13.1382, -2.212>, <-0.3128, 12.4002, -2.1876> }
				triangle { <-0.224, 12.1775, -2.1175>, <-0.3396, 12.3982, -2.1629>, <-0.3128, 12.4002, -2.1876> }
				triangle { <-0.224, 12.1775, -2.1175>, <-0.3128, 12.4002, -2.1876>, <-0.2015, 12.1778, -2.1384> }
				triangle { <-0.224, 12.1775, -2.1175>, <-0.2015, 12.1778, -2.1384>, <0.02521, 11.8319, -1.9725> }
				triangle { <-0.7764, 13.5466, -2.2239>, <-0.6581, 13.1382, -2.212>, <-0.6832, 13.1384, -2.1654> }
				triangle { <-0.3128, 12.4002, -2.1876>, <-0.6581, 13.1382, -2.212>, <-0.6059, 13.1631, -2.2443> }
				triangle { <-0.3632, 12.3916, -2.1364>, <-0.6832, 13.1384, -2.1654>, <-0.6581, 13.1382, -2.212> }
				triangle { <-0.7764, 13.5466, -2.2239>, <-0.6059, 13.1631, -2.2443>, <-0.6581, 13.1382, -2.212> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.05667, 11.7426, -1.9516>, <0.113, 12.1427, -2.04428>, 0.03345 }
				cylinder { <0.113, 12.1427, -2.04428>, <0.1798, 12.5433, -2.127>, 0.03345 }
				cylinder { <0.1798, 12.5433, -2.127>, <0.257, 12.944, -2.1998>, 0.03345 }
				cylinder { <0.257, 12.944, -2.1998>, <0.3445, 13.3443, -2.2626>, 0.03345 }
				cylinder { <0.3445, 13.3443, -2.2626>, <0.4422, 13.7436, -2.3153>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.4422, 13.7436, -2.3153>, <0.4501, 13.7616, -2.3178>, 0.0003357 }
				cylinder { <0.4501, 13.7616, -2.3178>, <0.4609, 13.778, -2.3201>, 0.0003357 }
				cylinder { <0.4609, 13.778, -2.3201>, <0.4745, 13.7923, -2.3222>, 0.0003357 }
				cylinder { <0.4745, 13.7923, -2.3222>, <0.4903, 13.8041, -2.3241>, 0.0003357 }
				cylinder { <0.4903, 13.8041, -2.3241>, <0.5079, 13.813, -2.3257>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.5079, 13.813, -2.3257>, <0.8997, 14.00892, -2.403>, <0.9096, 13.9892, -2.4268> }
				triangle { <0.8997, 14.00892, -2.403>, <1.1413, 14.09796, -2.419>, <0.9096, 13.9892, -2.4268> }
				triangle { <1.1413, 14.09796, -2.419>, <1.1497, 14.06899, -2.4387>, <0.9096, 13.9892, -2.4268> }
				triangle { <1.1413, 14.09796, -2.419>, <1.9227, 14.2898, -2.3679>, <1.1497, 14.06899, -2.4387> }
				triangle { <1.1497, 14.06899, -2.4387>, <1.9227, 14.2898, -2.3679>, <1.1527, 14.03765, -2.4572> }
				triangle { <0.9096, 13.9892, -2.4268>, <1.1497, 14.06899, -2.4387>, <1.1527, 14.03765, -2.4572> }
				triangle { <0.9096, 13.9892, -2.4268>, <1.1527, 14.03765, -2.4572>, <0.911, 13.963, -2.4429> }
				triangle { <0.9096, 13.9892, -2.4268>, <0.911, 13.963, -2.4429>, <0.5079, 13.813, -2.3257> }
				triangle { <2.3376, 14.359, -2.3041>, <1.9227, 14.2898, -2.3679>, <1.917, 14.3237, -2.3275> }
				triangle { <1.1527, 14.03765, -2.4572>, <1.9227, 14.2898, -2.3679>, <1.9458, 14.2299, -2.3838> }
				triangle { <1.1413, 14.09796, -2.419>, <1.917, 14.3237, -2.3275>, <1.9227, 14.2898, -2.3679> }
				triangle { <2.3376, 14.359, -2.3041>, <1.9458, 14.2299, -2.3838>, <1.9227, 14.2898, -2.3679> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.4422, 13.7436, -2.3153>, <0.5497, 14.1405, -2.3679>, 0.03345 }
				cylinder { <0.5497, 14.1405, -2.3679>, <0.6671, 14.5345, -2.4204>, 0.03345 }
				cylinder { <0.6671, 14.5345, -2.4204>, <0.7941, 14.9256, -2.4728>, 0.03345 }
				cylinder { <0.7941, 14.9256, -2.4728>, <0.9308, 15.3134, -2.525>, 0.03345 }
				cylinder { <0.9308, 15.3134, -2.525>, <1.07715, 15.6978, -2.577>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.07715, 15.6978, -2.577>, <1.08134, 15.717, -2.5795>, 0.0003357 }
				cylinder { <1.08134, 15.717, -2.5795>, <1.08266, 15.7366, -2.582>, 0.0003357 }
				cylinder { <1.08266, 15.7366, -2.582>, <1.08105, 15.7562, -2.5844>, 0.0003357 }
				cylinder { <1.08105, 15.7562, -2.5844>, <1.07657, 15.7753, -2.5867>, 0.0003357 }
				cylinder { <1.07657, 15.7753, -2.5867>, <1.06931, 15.7936, -2.5889>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.06931, 15.7936, -2.5889>, <0.9038, 16.1967, -2.6783>, <0.9207, 16.2022, -2.7055> }
				triangle { <0.9038, 16.1967, -2.6783>, <0.8376, 16.4444, -2.7066>, <0.9207, 16.2022, -2.7055> }
				triangle { <0.8376, 16.4444, -2.7066>, <0.8641, 16.4477, -2.7308>, <0.9207, 16.2022, -2.7055> }
				triangle { <0.8376, 16.4444, -2.7066>, <0.7332, 17.2439, -2.7097>, <0.8641, 16.4477, -2.7308> }
				triangle { <0.8641, 16.4477, -2.7308>, <0.7332, 17.2439, -2.7097>, <0.8925, 16.4457, -2.7535> }
				triangle { <0.9207, 16.2022, -2.7055>, <0.8641, 16.4477, -2.7308>, <0.8925, 16.4457, -2.7535> }
				triangle { <0.9207, 16.2022, -2.7055>, <0.8925, 16.4457, -2.7535>, <0.9442, 16.1992, -2.725> }
				triangle { <0.9207, 16.2022, -2.7055>, <0.9442, 16.1992, -2.725>, <1.06931, 15.7936, -2.5889> }
				triangle { <0.7154, 17.6679, -2.6797>, <0.7332, 17.2439, -2.7097>, <0.7052, 17.2455, -2.6647> }
				triangle { <0.8925, 16.4457, -2.7535>, <0.7332, 17.2439, -2.7097>, <0.7922, 17.2586, -2.7359> }
				triangle { <0.8376, 16.4444, -2.7066>, <0.7052, 17.2455, -2.6647>, <0.7332, 17.2439, -2.7097> }
				triangle { <0.7154, 17.6679, -2.6797>, <0.7922, 17.2586, -2.7359>, <0.7332, 17.2439, -2.7097> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <1.07715, 15.6978, -2.577>, <1.2135, 16.08424, -2.6393>, 0.03345 }
				cylinder { <1.2135, 16.08424, -2.6393>, <1.3399, 16.4723, -2.7117>, 0.03345 }
				cylinder { <1.3399, 16.4723, -2.7117>, <1.4561, 16.8615, -2.7943>, 0.03345 }
				cylinder { <1.4561, 16.8615, -2.7943>, <1.5621, 17.2514, -2.887>, 0.03345 }
				cylinder { <1.5621, 17.2514, -2.887>, <1.6576, 17.6415, -2.9895>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.6576, 17.6415, -2.9895>, <1.6649, 17.6592, -2.9943>, 0.0003357 }
				cylinder { <1.6649, 17.6592, -2.9943>, <1.6749, 17.6757, -2.999>, 0.0003357 }
				cylinder { <1.6749, 17.6757, -2.999>, <1.6872, 17.6905, -3.003499>, 0.0003357 }
				cylinder { <1.6872, 17.6905, -3.003499>, <1.7017, 17.7034, -3.007578>, 0.0003357 }
				cylinder { <1.7017, 17.7034, -3.007578>, <1.718, 17.7141, -3.01121>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.718, 17.7141, -3.01121>, <2.07864, 17.9437, -3.134>, <2.08966, 17.9226, -3.1561> }
				triangle { <2.07864, 17.9437, -3.134>, <2.3064, 18.05762, -3.1749>, <2.08966, 17.9226, -3.1561> }
				triangle { <2.3064, 18.05762, -3.1749>, <2.3172, 18.02773, -3.1919>, <2.08966, 17.9226, -3.1561> }
				triangle { <2.3064, 18.05762, -3.1749>, <3.06022, 18.3431, -3.1947>, <2.3172, 18.02773, -3.1919> }
				triangle { <2.3172, 18.02773, -3.1919>, <3.06022, 18.3431, -3.1947>, <2.3232, 17.995, -3.207> }
				triangle { <2.08966, 17.9226, -3.1561>, <2.3172, 18.02773, -3.1919>, <2.3232, 17.995, -3.207> }
				triangle { <2.08966, 17.9226, -3.1561>, <2.3232, 17.995, -3.207>, <2.09337, 17.8951, -3.1693> }
				triangle { <2.08966, 17.9226, -3.1561>, <2.09337, 17.8951, -3.1693>, <1.718, 17.7141, -3.01121> }
				triangle { <3.4662, 18.4666, -3.1653>, <3.06022, 18.3431, -3.1947>, <3.05241, 18.3805, -3.158> }
				triangle { <2.3232, 17.995, -3.207>, <3.06022, 18.3431, -3.1947>, <3.08962, 18.2847, -3.2054> }
				triangle { <2.3064, 18.05762, -3.1749>, <3.05241, 18.3805, -3.158>, <3.06022, 18.3431, -3.1947> }
				triangle { <3.4662, 18.4666, -3.1653>, <3.08962, 18.2847, -3.2054>, <3.06022, 18.3431, -3.1947> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <1.6576, 17.6415, -2.9895>, <1.6626, 17.66, -2.9944>, 0.0003357 }
				cylinder { <1.6626, 17.66, -2.9944>, <1.6681, 17.6784, -2.9993>, 0.0003357 }
				cylinder { <1.6681, 17.6784, -2.9993>, <1.6741, 17.6966, -3.004206>, 0.0003357 }
				cylinder { <1.6741, 17.6966, -3.004206>, <1.6805, 17.7147, -3.009084>, 0.0003357 }
				cylinder { <1.6805, 17.7147, -3.009084>, <1.6874, 17.7326, -3.01394>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.6874, 17.7326, -3.01394>, <1.8367, 18.1239, -3.1639>, <1.8541, 18.1124, -3.1888> }
				triangle { <1.8367, 18.1239, -3.1639>, <1.9537, 18.3456, -3.2247>, <1.8541, 18.1124, -3.1888> }
				triangle { <1.9537, 18.3456, -3.2247>, <1.9767, 18.3267, -3.2451>, <1.8541, 18.1124, -3.1888> }
				triangle { <1.9537, 18.3456, -3.2247>, <2.409, 19.00436, -3.3187>, <1.9767, 18.3267, -3.2451> }
				triangle { <1.9767, 18.3267, -3.2451>, <2.409, 19.00436, -3.3187>, <1.9974, 18.3029, -3.2634> }
				triangle { <1.8541, 18.1124, -3.1888>, <1.9767, 18.3267, -3.2451>, <1.9974, 18.3029, -3.2634> }
				triangle { <1.8541, 18.1124, -3.1888>, <1.9974, 18.3029, -3.2634>, <1.8705, 18.09163, -3.2044> }
				triangle { <1.8541, 18.1124, -3.1888>, <1.8705, 18.09163, -3.2044>, <1.6874, 17.7326, -3.01394> }
				triangle { <2.677, 19.3344, -3.3321>, <2.409, 19.00436, -3.3187>, <2.3873, 19.03126, -3.2786> }
				triangle { <1.9974, 18.3029, -3.2634>, <2.409, 19.00436, -3.3187>, <2.4638, 18.9724, -3.3376> }
				triangle { <1.9537, 18.3456, -3.2247>, <2.3873, 19.03126, -3.2786>, <2.409, 19.00436, -3.3187> }
				triangle { <2.677, 19.3344, -3.3321>, <2.4638, 18.9724, -3.3376>, <2.409, 19.00436, -3.3187> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.004752, 1.9714, 0.09673>, 0.03345 }
			cylinder { <0.004752, 1.9714, 0.09673>, <0.01424, 3.9358, 0.2899>, 0.03345 }
			cylinder { <0.01424, 3.9358, 0.2899>, <0.02845, 5.8882, 0.5792>, 0.03345 }
			cylinder { <0.02845, 5.8882, 0.5792>, <0.04735, 7.8241, 0.9638>, 0.03345 }
			cylinder { <0.04735, 7.8241, 0.9638>, <0.07088, 9.7388, 1.4428>, 0.03345 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.07088, 9.7388, 1.4428>, <0.08646, 10.1382, 1.5527>, 0.03345 }
				cylinder { <0.08646, 10.1382, 1.5527>, <0.1126, 10.5344, 1.6718>, 0.03345 }
				cylinder { <0.1126, 10.5344, 1.6718>, <0.1494, 10.9269, 1.7999>, 0.03345 }
				cylinder { <0.1494, 10.9269, 1.7999>, <0.1967, 11.3152, 1.9368>, 0.03345 }
				cylinder { <0.1967, 11.3152, 1.9368>, <0.2545, 11.699, 2.08255>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.2545, 11.699, 2.08255>, <0.2606, 11.7166, 2.08913>, 0.0003357 }
				cylinder { <0.2606, 11.7166, 2.08913>, <0.2698, 11.7331, 2.09512>, 0.0003357 }
				cylinder { <0.2698, 11.7331, 2.09512>, <0.2818, 11.7479, 2.1003>, 0.0003357 }
				cylinder { <0.2818, 11.7479, 2.1003>, <0.2964, 11.7607, 2.1046>, 0.0003357 }
				cylinder { <0.2964, 11.7607, 2.1046>, <0.3131, 11.7709, 2.1079>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.3131, 11.7709, 2.1079>, <0.6879, 11.9823, 2.2203>, <0.6798, 11.9892, 2.2509> }
				triangle { <0.6879, 11.9823, 2.2203>, <0.887, 12.1382, 2.2712>, <0.6798, 11.9892, 2.2509> }
				triangle { <0.887, 12.1382, 2.2712>, <0.8696, 12.1492, 2.3007>, <0.6798, 11.9892, 2.2509> }
				triangle { <0.887, 12.1382, 2.2712>, <1.4332, 12.7223, 2.374>, <0.8696, 12.1492, 2.3007> }
				triangle { <0.8696, 12.1492, 2.3007>, <1.4332, 12.7223, 2.374>, <0.8474, 12.1573, 2.3285> }
				triangle { <0.6798, 11.9892, 2.2509>, <0.8696, 12.1492, 2.3007>, <0.8474, 12.1573, 2.3285> }
				triangle { <0.6798, 11.9892, 2.2509>, <0.8474, 12.1573, 2.3285>, <0.6607, 11.9947, 2.2744> }
				triangle { <0.6798, 11.9892, 2.2509>, <0.6607, 11.9947, 2.2744>, <0.3131, 11.7709, 2.1079> }
				triangle { <1.6896, 13.06033, 2.4061>, <1.4332, 12.7223, 2.374>, <1.4529, 12.7195, 2.3249> }
				triangle { <0.8474, 12.1573, 2.3285>, <1.4332, 12.7223, 2.374>, <1.3962, 12.7597, 2.4142> }
				triangle { <0.887, 12.1382, 2.2712>, <1.4529, 12.7195, 2.3249>, <1.4332, 12.7223, 2.374> }
				triangle { <1.6896, 13.06033, 2.4061>, <1.3962, 12.7597, 2.4142>, <1.4332, 12.7223, 2.374> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.2545, 11.699, 2.08255>, <0.3123, 12.08276, 2.2282>, 0.03345 }
				cylinder { <0.3123, 12.08276, 2.2282>, <0.3701, 12.4664, 2.3739>, 0.03345 }
				cylinder { <0.3701, 12.4664, 2.3739>, <0.4279, 12.8502, 2.5195>, 0.03345 }
				cylinder { <0.4279, 12.8502, 2.5195>, <0.4857, 13.2339, 2.6652>, 0.03345 }
				cylinder { <0.4857, 13.2339, 2.6652>, <0.5434, 13.6177, 2.8109>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.5434, 13.6177, 2.8109>, <0.5433, 13.6361, 2.818>, 0.0003357 }
				cylinder { <0.5433, 13.6361, 2.818>, <0.5402, 13.6544, 2.8252>, 0.0003357 }
				cylinder { <0.5402, 13.6544, 2.8252>, <0.5344, 13.6719, 2.8322>, 0.0003357 }
				cylinder { <0.5344, 13.6719, 2.8322>, <0.5258, 13.6885, 2.8389>, 0.0003357 }
				cylinder { <0.5258, 13.6885, 2.8389>, <0.5147, 13.7036, 2.8452>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.5147, 13.7036, 2.8452>, <0.2696, 14.02807, 3.02559>, <0.2533, 14.00972, 3.04683> }
				triangle { <0.2696, 14.02807, 3.02559>, <0.1011, 14.2084, 3.1004>, <0.2533, 14.00972, 3.04683> }
				triangle { <0.1011, 14.2084, 3.1004>, <0.08149, 14.1824, 3.1157>, <0.2533, 14.00972, 3.04683> }
				triangle { <0.1011, 14.2084, 3.1004>, <-0.4972, 14.7341, 3.2258>, <0.08149, 14.1824, 3.1157> }
				triangle { <0.08149, 14.1824, 3.1157>, <-0.4972, 14.7341, 3.2258>, <0.06532, 14.1523, 3.1285> }
				triangle { <0.2533, 14.00972, 3.04683>, <0.08149, 14.1824, 3.1157>, <0.06532, 14.1523, 3.1285> }
				triangle { <0.2533, 14.00972, 3.04683>, <0.06532, 14.1523, 3.1285>, <0.2409, 13.9838, 3.05789> }
				triangle { <0.2533, 14.00972, 3.04683>, <0.2409, 13.9838, 3.05789>, <0.5147, 13.7036, 2.8452> }
				triangle { <-0.8332, 14.9938, 3.2511>, <-0.4972, 14.7341, 3.2258>, <-0.4791, 14.7705, 3.1919> }
				triangle { <0.06532, 14.1523, 3.1285>, <-0.4972, 14.7341, 3.2258>, <-0.5447, 14.6888, 3.2345> }
				triangle { <0.1011, 14.2084, 3.1004>, <-0.4791, 14.7705, 3.1919>, <-0.4972, 14.7341, 3.2258> }
				triangle { <-0.8332, 14.9938, 3.2511>, <-0.5447, 14.6888, 3.2345>, <-0.4972, 14.7341, 3.2258> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.5434, 13.6177, 2.8109>, <0.6116, 13.9963, 2.9651>, 0.03345 }
				cylinder { <0.6116, 13.9963, 2.9651>, <0.6901, 14.3694, 3.1277>, 0.03345 }
				cylinder { <0.6901, 14.3694, 3.1277>, <0.7789, 14.7366, 3.2984>, 0.03345 }
				cylinder { <0.7789, 14.7366, 3.2984>, <0.8777, 15.09734, 3.4771>, 0.03345 }
				cylinder { <0.8777, 15.09734, 3.4771>, <0.9865, 15.4511, 3.6636>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.9865, 15.4511, 3.6636>, <0.9949, 15.467, 3.6719>, 0.0003357 }
				cylinder { <0.9949, 15.467, 3.6719>, <1.00632, 15.4814, 3.6794>, 0.0003357 }
				cylinder { <1.00632, 15.4814, 3.6794>, <1.02026, 15.4939, 3.6859>, 0.0003357 }
				cylinder { <1.02026, 15.4939, 3.6859>, <1.03641, 15.5042, 3.6911>, 0.0003357 }
				cylinder { <1.03641, 15.5042, 3.6911>, <1.05428, 15.5118, 3.6949>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.05428, 15.5118, 3.6949>, <1.455, 15.6608, 3.8174>, <1.4485, 15.6649, 3.8489> }
				triangle { <1.455, 15.6608, 3.8174>, <1.6733, 15.7839, 3.8787>, <1.4485, 15.6649, 3.8489> }
				triangle { <1.6733, 15.7839, 3.8787>, <1.658, 15.7934, 3.9099>, <1.4485, 15.6649, 3.8489> }
				triangle { <1.6733, 15.7839, 3.8787>, <2.2909, 16.2802, 4.02815>, <1.658, 15.7934, 3.9099> }
				triangle { <1.658, 15.7934, 3.9099>, <2.2909, 16.2802, 4.02815>, <1.6376, 15.8009, 3.9392> }
				triangle { <1.4485, 15.6649, 3.8489>, <1.658, 15.7934, 3.9099>, <1.6376, 15.8009, 3.9392> }
				triangle { <1.4485, 15.6649, 3.8489>, <1.6376, 15.8009, 3.9392>, <1.4307, 15.67, 3.8735> }
				triangle { <1.4485, 15.6649, 3.8489>, <1.4307, 15.67, 3.8735>, <1.05428, 15.5118, 3.6949> }
				triangle { <2.5885, 16.5779, 4.08955>, <2.2909, 16.2802, 4.02815>, <2.309, 16.2808, 3.9783> }
				triangle { <1.6376, 15.8009, 3.9392>, <2.2909, 16.2802, 4.02815>, <2.2597, 16.3168, 4.07363> }
				triangle { <1.6733, 15.7839, 3.8787>, <2.309, 16.2808, 3.9783>, <2.2909, 16.2802, 4.02815> }
				triangle { <2.5885, 16.5779, 4.08955>, <2.2597, 16.3168, 4.07363>, <2.2909, 16.2802, 4.02815> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.9865, 15.4511, 3.6636>, <1.08557, 15.8072, 3.8513>, 0.03345 }
				cylinder { <1.08557, 15.8072, 3.8513>, <1.1746, 16.1652, 4.04027>, 0.03345 }
				cylinder { <1.1746, 16.1652, 4.04027>, <1.2537, 16.525, 4.2302>, 0.03345 }
				cylinder { <1.2537, 16.525, 4.2302>, <1.3228, 16.8864, 4.4211>, 0.03345 }
				cylinder { <1.3228, 16.8864, 4.4211>, <1.3819, 17.2491, 4.6129>, 0.03345 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.3819, 17.2491, 4.6129>, <1.3813, 17.2666, 4.6222>, 0.0003357 }
				cylinder { <1.3813, 17.2666, 4.6222>, <1.3773, 17.2837, 4.6313>, 0.0003357 }
				cylinder { <1.3773, 17.2837, 4.6313>, <1.3701, 17.3, 4.64>, 0.0003357 }
				cylinder { <1.3701, 17.3, 4.64>, <1.3599, 17.3149, 4.6481>, 0.0003357 }
				cylinder { <1.3599, 17.3149, 4.6481>, <1.3469, 17.3281, 4.6552>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.3469, 17.3281, 4.6552>, <1.05845, 17.603, 4.8527>, <1.04278, 17.5807, 4.8703> }
				triangle { <1.05845, 17.603, 4.8527>, <0.8677, 17.7561, 4.9348>, <1.04278, 17.5807, 4.8703> }
				triangle { <0.8677, 17.7561, 4.9348>, <0.8499, 17.7266, 4.9454>, <1.04278, 17.5807, 4.8703> }
				triangle { <0.8677, 17.7561, 4.9348>, <0.2117, 18.2038, 5.07381>, <0.8499, 17.7266, 4.9454> }
				triangle { <0.8499, 17.7266, 4.9454>, <0.2117, 18.2038, 5.07381>, <0.836, 17.6938, 4.9532> }
				triangle { <1.04278, 17.5807, 4.8703>, <0.8499, 17.7266, 4.9454>, <0.836, 17.6938, 4.9532> }
				triangle { <1.04278, 17.5807, 4.8703>, <0.836, 17.6938, 4.9532>, <1.03237, 17.5526, 4.8772> }
				triangle { <1.04278, 17.5807, 4.8703>, <1.03237, 17.5526, 4.8772>, <1.3469, 17.3281, 4.6552> }
				triangle { <-0.1498, 18.4259, 5.1029>, <0.2117, 18.2038, 5.07381>, <0.2282, 18.2457, 5.04596> }
				triangle { <0.836, 17.6938, 4.9532>, <0.2117, 18.2038, 5.07381>, <0.1686, 18.1536, 5.07334> }
				triangle { <0.8677, 17.7561, 4.9348>, <0.2282, 18.2457, 5.04596>, <0.2117, 18.2038, 5.07381> }
				triangle { <-0.1498, 18.4259, 5.1029>, <0.1686, 18.1536, 5.07334>, <0.2117, 18.2038, 5.07381> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <1.3819, 17.2491, 4.6129>, <1.3847, 17.2665, 4.622>, 0.0003357 }
				cylinder { <1.3847, 17.2665, 4.622>, <1.3875, 17.2838, 4.6312>, 0.0003357 }
				cylinder { <1.3875, 17.2838, 4.6312>, <1.3903, 17.3011, 4.6404>, 0.0003357 }
				cylinder { <1.3903, 17.3011, 4.6404>, <1.3932, 17.3185, 4.6495>, 0.0003357 }
				cylinder { <1.3932, 17.3185, 4.6495>, <1.396, 17.3358, 4.6587>, 0.0003357 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.396, 17.3358, 4.6587>, <1.4617, 17.703, 4.9009>, <1.4429, 17.6948, 4.9261> }
				triangle { <1.4617, 17.703, 4.9009>, <1.4687, 17.9314, 5.02069>, <1.4429, 17.6948, 4.9261> }
				triangle { <1.4687, 17.9314, 5.02069>, <1.4411, 17.9204, 5.04117>, <1.4429, 17.6948, 4.9261> }
				triangle { <1.4687, 17.9314, 5.02069>, <1.3886, 18.679, 5.3118>, <1.4411, 17.9204, 5.04117> }
				triangle { <1.4411, 17.9204, 5.04117>, <1.3886, 18.679, 5.3118>, <1.413, 17.9047, 5.05822> }
				triangle { <1.4429, 17.6948, 4.9261>, <1.4411, 17.9204, 5.04117>, <1.413, 17.9047, 5.05822> }
				triangle { <1.4429, 17.6948, 4.9261>, <1.413, 17.9047, 5.05822>, <1.4198, 17.6804, 4.9404> }
				triangle { <1.4429, 17.6948, 4.9261>, <1.4198, 17.6804, 4.9404>, <1.396, 17.3358, 4.6587> }
				triangle { <1.311, 19.07957, 5.4322>, <1.3886, 18.679, 5.3118>, <1.4174, 18.7023, 5.2739> }
				triangle { <1.413, 17.9047, 5.05822>, <1.3886, 18.679, 5.3118>, <1.3268, 18.6713, 5.3341> }
				triangle { <1.4687, 17.9314, 5.02069>, <1.4174, 18.7023, 5.2739>, <1.3886, 18.679, 5.3118> }
				triangle { <1.311, 19.07957, 5.4322>, <1.3268, 18.6713, 5.3341>, <1.3886, 18.679, 5.3118> }
				texture{Grass_Texture5}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 15.8924, 0.0>, 0.2172 }
			cylinder { <-0.0, 15.8924, 0.0>, <-0.00000001, 31.7849, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 31.7849, 0.0>, <-0.00000001, 47.6774, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 47.6774, 0.0>, <-0.00000001, 63.5699, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 63.5699, 0.0>, <-0.00000002, 79.4624, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <-0.008742, 80.1791, 0.03838>, 0.2172 }
			cylinder { <-0.008742, 80.1791, 0.03838>, <-0.02622, 80.8925, 0.115>, 0.2172 }
			cylinder { <-0.02622, 80.8925, 0.115>, <-0.05241, 81.6005, 0.2297>, 0.2172 }
			cylinder { <-0.05241, 81.6005, 0.2297>, <-0.08725, 82.301, 0.382>, 0.2172 }
			cylinder { <-0.08725, 82.301, 0.382>, <-0.1306, 82.9919, 0.5716>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.1306, 82.9919, 0.5716>, <-0.1825, 83.671, 0.7978>, 0.2172 }
			cylinder { <-0.1825, 83.671, 0.7978>, <-0.2427, 84.3365, 1.05996>, 0.2172 }
			cylinder { <-0.2427, 84.3365, 1.05996>, <-0.3111, 84.9861, 1.3572>, 0.2172 }
			cylinder { <-0.3111, 84.9861, 1.3572>, <-0.3875, 85.6181, 1.6888>, 0.2172 }
			cylinder { <-0.3875, 85.6181, 1.6888>, <-0.4716, 86.2304, 2.05364>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.4716, 86.2304, 2.05364>, <-0.5634, 86.8213, 2.4505>, 0.2172 }
			cylinder { <-0.5634, 86.8213, 2.4505>, <-0.6624, 87.389, 2.8785>, 0.2172 }
			cylinder { <-0.6624, 87.389, 2.8785>, <-0.7684, 87.9317, 3.336>, 0.2172 }
			cylinder { <-0.7684, 87.9317, 3.336>, <-0.8812, 88.4478, 3.8218>, 0.2172 }
			cylinder { <-0.8812, 88.4478, 3.8218>, <-1.000396, 88.9358, 4.3345>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-1.000396, 88.9358, 4.3345>, <-1.1256, 89.3942, 4.8724>, 0.2172 }
			cylinder { <-1.1256, 89.3942, 4.8724>, <-1.2566, 89.8216, 5.4339>, 0.2172 }
			cylinder { <-1.2566, 89.8216, 5.4339>, <-1.3929, 90.2167, 6.01736>, 0.2172 }
			cylinder { <-1.3929, 90.2167, 6.01736>, <-1.5342, 90.5784, 6.6209>, 0.2172 }
			cylinder { <-1.5342, 90.5784, 6.6209>, <-1.6801, 90.9055, 7.2429>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-1.6801, 90.9055, 7.2429>, <-1.7967, 91.258, 7.8571>, 0.2172 }
			cylinder { <-1.7967, 91.258, 7.8571>, <-1.8839, 91.6346, 8.4618>, 0.2172 }
			cylinder { <-1.8839, 91.6346, 8.4618>, <-1.9412, 92.03442, 9.05522>, 0.2172 }
			cylinder { <-1.9412, 92.03442, 9.05522>, <-1.9685, 92.456, 9.6354>, 0.2172 }
			cylinder { <-1.9685, 92.456, 9.6354>, <-1.9658, 92.8982, 10.2007>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.9658, 92.8982, 10.2007>, <-1.7107, 95.02257, 12.8219>, 0.2172 }
				cylinder { <-1.7107, 95.02257, 12.8219>, <-1.2151, 97.1751, 15.385>, 0.2172 }
				cylinder { <-1.2151, 97.1751, 15.385>, <-0.4816, 99.3441, 17.8761>, 0.2172 }
				cylinder { <-0.4816, 99.3441, 17.8761>, <0.4857, 101.5181, 20.2817>, 0.2172 }
				cylinder { <0.4857, 101.5181, 20.2817>, <1.6817, 103.6849, 22.5888>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.6817, 103.6849, 22.5888>, <2.08549, 104.2244, 23.06973>, <2.01243, 104.2774, 23.09097> }
					triangle { <2.08549, 104.2244, 23.06973>, <2.2541, 104.5094, 23.3884>, <2.01243, 104.2774, 23.09097> }
					triangle { <2.2541, 104.5094, 23.3884>, <2.1721, 104.5686, 23.4085>, <2.01243, 104.2774, 23.09097> }
					triangle { <2.2541, 104.5094, 23.3884>, <2.3955, 104.9954, 23.854>, <2.1721, 104.5686, 23.4085> }
					triangle { <2.1721, 104.5686, 23.4085>, <2.3955, 104.9954, 23.854>, <2.09337, 104.6207, 23.3672> }
					triangle { <2.01243, 104.2774, 23.09097>, <2.1721, 104.5686, 23.4085>, <2.09337, 104.6207, 23.3672> }
					triangle { <2.01243, 104.2774, 23.09097>, <2.09337, 104.6207, 23.3672>, <1.9377, 104.3179, 23.05903> }
					triangle { <2.01243, 104.2774, 23.09097>, <1.9377, 104.3179, 23.05903>, <1.6817, 103.6849, 22.5888> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.9658, 92.8982, 10.2007>, <-2.00237, 93.3409, 10.7644>, 0.2172 }
			cylinder { <-2.00237, 93.3409, 10.7644>, <-2.07816, 93.7829, 11.3248>, 0.2172 }
			cylinder { <-2.07816, 93.7829, 11.3248>, <-2.1929, 94.2229, 11.8801>, 0.2172 }
			cylinder { <-2.1929, 94.2229, 11.8801>, <-2.3464, 94.6594, 12.4288>, 0.2172 }
			cylinder { <-2.3464, 94.6594, 12.4288>, <-2.538, 95.09137, 12.969>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.538, 95.09137, 12.969>, <-3.6491, 97.1795, 15.3884>, 0.2172 }
				cylinder { <-3.6491, 97.1795, 15.3884>, <-4.9617, 99.3084, 17.6673>, 0.2172 }
				cylinder { <-4.9617, 99.3084, 17.6673>, <-6.4688, 101.4665, 19.7933>, 0.2172 }
				cylinder { <-6.4688, 101.4665, 19.7933>, <-8.1621, 103.6422, 21.7548>, 0.2172 }
				cylinder { <-8.1621, 103.6422, 21.7548>, <-10.03263, 105.8235, 23.5413>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-10.03263, 105.8235, 23.5413>, <-10.6402, 106.2146, 23.8573>, <-10.6191, 106.2007, 23.9419> }
					triangle { <-10.6402, 106.2146, 23.8573>, <-10.9265, 106.4665, 24.07265>, <-10.6191, 106.2007, 23.9419> }
					triangle { <-10.9265, 106.4665, 24.07265>, <-10.9027, 106.4477, 24.166>, <-10.6191, 106.2007, 23.9419> }
					triangle { <-10.9265, 106.4665, 24.07265>, <-11.3114, 106.7893, 24.4933>, <-10.9027, 106.4477, 24.166> }
					triangle { <-10.9027, 106.4477, 24.166>, <-11.3114, 106.7893, 24.4933>, <-10.8791, 106.3775, 24.2306> }
					triangle { <-10.6191, 106.2007, 23.9419>, <-10.9027, 106.4477, 24.166>, <-10.8791, 106.3775, 24.2306> }
					triangle { <-10.6191, 106.2007, 23.9419>, <-10.8791, 106.3775, 24.2306>, <-10.591, 106.1428, 23.9997> }
					triangle { <-10.6191, 106.2007, 23.9419>, <-10.591, 106.1428, 23.9997>, <-10.03263, 105.8235, 23.5413> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-2.538, 95.09137, 12.969>, <-2.7024, 95.5057, 13.5315>, 0.2172 }
			cylinder { <-2.7024, 95.5057, 13.5315>, <-2.8389, 95.9012, 14.1147>, 0.2172 }
			cylinder { <-2.8389, 95.9012, 14.1147>, <-2.9472, 96.2768, 14.7166>, 0.2172 }
			cylinder { <-2.9472, 96.2768, 14.7166>, <-3.02701, 96.6312, 15.3356>, 0.2172 }
			cylinder { <-3.02701, 96.6312, 15.3356>, <-3.07806, 96.9633, 15.9698>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.07806, 96.9633, 15.9698>, <-3.2305, 98.3215, 19.0651>, 0.2172 }
				cylinder { <-3.2305, 98.3215, 19.0651>, <-3.2941, 99.4646, 22.249>, 0.2172 }
				cylinder { <-3.2941, 99.4646, 22.249>, <-3.2684, 100.3865, 25.5045>, 0.2172 }
				cylinder { <-3.2684, 100.3865, 25.5045>, <-3.1535, 101.0822, 28.8138>, 0.2172 }
				cylinder { <-3.1535, 101.0822, 28.8138>, <-2.95, 101.5477, 32.159>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.95, 101.5477, 32.159>, <-2.9369, 101.5897, 32.909>, <-2.917, 101.6713, 32.9143> }
					triangle { <-2.9369, 101.5897, 32.909>, <-2.9721, 101.6682, 33.3172>, <-2.917, 101.6713, 32.9143> }
					triangle { <-2.9721, 101.6682, 33.3172>, <-2.9474, 101.7583, 33.321>, <-2.917, 101.6713, 32.9143> }
					triangle { <-2.9721, 101.6682, 33.3172>, <-2.9787, 101.8873, 33.9016>, <-2.9474, 101.7583, 33.321> }
					triangle { <-2.9474, 101.7583, 33.321>, <-2.9787, 101.8873, 33.9016>, <-2.8867, 101.8227, 33.2905> }
					triangle { <-2.917, 101.6713, 32.9143>, <-2.9474, 101.7583, 33.321>, <-2.8867, 101.8227, 33.2905> }
					triangle { <-2.917, 101.6713, 32.9143>, <-2.8867, 101.8227, 33.2905>, <-2.8697, 101.7317, 32.8841> }
					triangle { <-2.917, 101.6713, 32.9143>, <-2.8697, 101.7317, 32.8841>, <-2.95, 101.5477, 32.159> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-3.07806, 96.9633, 15.9698>, <-3.1324, 97.3296, 16.5846>, 0.2172 }
			cylinder { <-3.1324, 97.3296, 16.5846>, <-3.1899, 97.7289, 17.1782>, 0.2172 }
			cylinder { <-3.1899, 97.7289, 17.1782>, <-3.2504, 98.1601, 17.7488>, 0.2172 }
			cylinder { <-3.2504, 98.1601, 17.7488>, <-3.3137, 98.6218, 18.2947>, 0.2172 }
			cylinder { <-3.3137, 98.6218, 18.2947>, <-3.3795, 99.1126, 18.8142>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.3795, 99.1126, 18.8142>, <-3.5918, 101.5929, 21.1059>, 0.2172 }
				cylinder { <-3.5918, 101.5929, 21.1059>, <-3.7052, 104.2261, 23.2277>, 0.2172 }
				cylinder { <-3.7052, 104.2261, 23.2277>, <-3.7191, 106.9979, 25.1681>, 0.2172 }
				cylinder { <-3.7191, 106.9979, 25.1681>, <-3.6334, 109.8935, 26.9165>, 0.2172 }
				cylinder { <-3.6334, 109.8935, 26.9165>, <-3.4485, 112.8969, 28.4636>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.4485, 112.8969, 28.4636>, <-3.4627, 113.6036, 28.5757>, <-3.5201, 113.6034, 28.6317> }
					triangle { <-3.4627, 113.6036, 28.5757>, <-3.4646, 113.9801, 28.7026>, <-3.5201, 113.6034, 28.6317> }
					triangle { <-3.4646, 113.9801, 28.7026>, <-3.5301, 113.9782, 28.7629>, <-3.5201, 113.6034, 28.6317> }
					triangle { <-3.4646, 113.9801, 28.7026>, <-3.5567, 114.5137, 28.9479>, <-3.5301, 113.9782, 28.7629> }
					triangle { <-3.5301, 113.9782, 28.7629>, <-3.5567, 114.5137, 28.9479>, <-3.6124, 113.9488, 28.7805> }
					triangle { <-3.5201, 113.6034, 28.6317>, <-3.5301, 113.9782, 28.7629>, <-3.6124, 113.9488, 28.7805> }
					triangle { <-3.5201, 113.6034, 28.6317>, <-3.6124, 113.9488, 28.7805>, <-3.5895, 113.5736, 28.6529> }
					triangle { <-3.5201, 113.6034, 28.6317>, <-3.5895, 113.5736, 28.6529>, <-3.4485, 112.8969, 28.4636> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <0.03225, 80.1791, -0.02256>, 0.2172 }
			cylinder { <0.03225, 80.1791, -0.02256>, <0.09668, 80.8925, -0.06762>, 0.2172 }
			cylinder { <0.09668, 80.8925, -0.06762>, <0.193, 81.6005, -0.135>, 0.2172 }
			cylinder { <0.193, 81.6005, -0.135>, <0.3212, 82.301, -0.2244>, 0.2172 }
			cylinder { <0.3212, 82.301, -0.2244>, <0.4806, 82.9919, -0.3357>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.4806, 82.9919, -0.3357>, <0.8297, 83.6026, -0.4784>, 0.2172 }
			cylinder { <0.8297, 83.6026, -0.4784>, <1.1439, 84.2302, -0.6284>, 0.2172 }
			cylinder { <1.1439, 84.2302, -0.6284>, <1.4224, 84.8728, -0.7852>, 0.2172 }
			cylinder { <1.4224, 84.8728, -0.7852>, <1.6644, 85.5285, -0.9486>, 0.2172 }
			cylinder { <1.6644, 85.5285, -0.9486>, <1.869, 86.1953, -1.1179>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.869, 86.1953, -1.1179>, <2.6265, 89.3575, -2.05329>, 0.2172 }
				cylinder { <2.6265, 89.3575, -2.05329>, <3.1729, 92.5214, -3.1208>, 0.2172 }
				cylinder { <3.1729, 92.5214, -3.1208>, <3.5053, 95.6698, -4.3146>, 0.2172 }
				cylinder { <3.5053, 95.6698, -4.3146>, <3.6217, 98.7858, -5.6284>, 0.2172 }
				cylinder { <3.6217, 98.7858, -5.6284>, <3.5216, 101.8523, -7.05498>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <3.5216, 101.8523, -7.05498>, <3.3646, 102.5716, -7.4335>, <3.4093, 102.626, -7.3732> }
					triangle { <3.3646, 102.5716, -7.4335>, <3.3535, 102.9829, -7.6383>, <3.4093, 102.626, -7.3732> }
					triangle { <3.3535, 102.9829, -7.6383>, <3.4013, 103.0419, -7.5685>, <3.4093, 102.626, -7.3732> }
					triangle { <3.3535, 102.9829, -7.6383>, <3.3842, 103.6411, -7.8354>, <3.4013, 103.0419, -7.5685> }
					triangle { <3.4013, 103.0419, -7.5685>, <3.3842, 103.6411, -7.8354>, <3.4102, 103.0639, -7.4682> }
					triangle { <3.4093, 102.626, -7.3732>, <3.4013, 103.0419, -7.5685>, <3.4102, 103.0639, -7.4682> }
					triangle { <3.4093, 102.626, -7.3732>, <3.4102, 103.0639, -7.4682>, <3.4254, 102.6428, -7.2855> }
					triangle { <3.4093, 102.626, -7.3732>, <3.4254, 102.6428, -7.2855>, <3.5216, 101.8523, -7.05498> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.869, 86.1953, -1.1179>, <2.09919, 86.8606, -1.2573>, 0.2172 }
			cylinder { <2.09919, 86.8606, -1.2573>, <2.3542, 87.5226, -1.3663>, 0.2172 }
			cylinder { <2.3542, 87.5226, -1.3663>, <2.6333, 88.1791, -1.4447>, 0.2172 }
			cylinder { <2.6333, 88.1791, -1.4447>, <2.9357, 88.8283, -1.4921>, 0.2172 }
			cylinder { <2.9357, 88.8283, -1.4921>, <3.2603, 89.4682, -1.5084>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.2603, 89.4682, -1.5084>, <4.8322, 92.4599, -1.341>, 0.2172 }
				cylinder { <4.8322, 92.4599, -1.341>, <6.4369, 95.4102, -0.9301>, 0.2172 }
				cylinder { <6.4369, 95.4102, -0.9301>, <8.06571, 98.3034, -0.2781>, 0.2172 }
				cylinder { <8.06571, 98.3034, -0.2781>, <9.7098, 101.1237, 0.6116>, 0.2172 }
				cylinder { <9.7098, 101.1237, 0.6116>, <11.3603, 103.8557, 1.7342>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <11.3603, 103.8557, 1.7342>, <11.839, 104.3358, 2.1371>, <11.8837, 104.3671, 2.06772> }
					triangle { <11.839, 104.3358, 2.1371>, <12.08327, 104.6539, 2.3129>, <11.8837, 104.3671, 2.06772> }
					triangle { <12.08327, 104.6539, 2.3129>, <12.1335, 104.6854, 2.2347>, <11.8837, 104.3671, 2.06772> }
					triangle { <12.08327, 104.6539, 2.3129>, <12.5013, 105.134, 2.4677>, <12.1335, 104.6854, 2.2347> }
					triangle { <12.1335, 104.6854, 2.2347>, <12.5013, 105.134, 2.4677>, <12.1836, 104.6581, 2.1548> }
					triangle { <11.8837, 104.3671, 2.06772>, <12.1335, 104.6854, 2.2347>, <12.1836, 104.6581, 2.1548> }
					triangle { <11.8837, 104.3671, 2.06772>, <12.1836, 104.6581, 2.1548>, <11.922, 104.347, 1.9928> }
					triangle { <11.8837, 104.3671, 2.06772>, <11.922, 104.347, 1.9928>, <11.3603, 103.8557, 1.7342> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.2603, 89.4682, -1.5084>, <3.5868, 90.105, -1.5639>, 0.2172 }
			cylinder { <3.5868, 90.105, -1.5639>, <3.9142, 90.7366, -1.6585>, 0.2172 }
			cylinder { <3.9142, 90.7366, -1.6585>, <4.2415, 91.3613, -1.7918>, 0.2172 }
			cylinder { <4.2415, 91.3613, -1.7918>, <4.5678, 91.9771, -1.9635>, 0.2172 }
			cylinder { <4.5678, 91.9771, -1.9635>, <4.8921, 92.5822, -2.173>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.8921, 92.5822, -2.173>, <6.5017, 95.3109, -3.3613>, 0.2172 }
				cylinder { <6.5017, 95.3109, -3.3613>, <8.1834, 97.9011, -4.7436>, 0.2172 }
				cylinder { <8.1834, 97.9011, -4.7436>, <9.9282, 100.339, -6.3125>, 0.2172 }
				cylinder { <9.9282, 100.339, -6.3125>, <11.7266, 102.611, -8.05952>, 0.2172 }
				cylinder { <11.7266, 102.611, -8.05952>, <13.5688, 104.7051, -9.9751>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <13.5688, 104.7051, -9.9751>, <14.02599, 105.1199, -10.4034>, <13.987, 105.1935, -10.3916> }
					triangle { <14.02599, 105.1199, -10.4034>, <14.284, 105.3924, -10.5854>, <13.987, 105.1935, -10.3916> }
					triangle { <14.284, 105.3924, -10.5854>, <14.2378, 105.4729, -10.5731>, <13.987, 105.1935, -10.3916> }
					triangle { <14.284, 105.3924, -10.5854>, <14.5859, 105.876, -10.8395>, <14.2378, 105.4729, -10.5731> }
					triangle { <14.2378, 105.4729, -10.5731>, <14.5859, 105.876, -10.8395>, <14.1542, 105.5147, -10.5767> }
					triangle { <13.987, 105.1935, -10.3916>, <14.2378, 105.4729, -10.5731>, <14.1542, 105.5147, -10.5767> }
					triangle { <13.987, 105.1935, -10.3916>, <14.1542, 105.5147, -10.5767>, <13.9141, 105.2317, -10.3869> }
					triangle { <13.987, 105.1935, -10.3916>, <13.9141, 105.2317, -10.3869>, <13.5688, 104.7051, -9.9751> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <4.8921, 92.5822, -2.173>, <5.1942, 93.2068, -2.3566>, 0.2172 }
			cylinder { <5.1942, 93.2068, -2.3566>, <5.4731, 93.8492, -2.5136>, 0.2172 }
			cylinder { <5.4731, 93.8492, -2.5136>, <5.7281, 94.5073, -2.6437>, 0.2172 }
			cylinder { <5.7281, 94.5073, -2.6437>, <5.9584, 95.1793, -2.7464>, 0.2172 }
			cylinder { <5.9584, 95.1793, -2.7464>, <6.1632, 95.8631, -2.8215>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.1632, 95.8631, -2.8215>, <6.9023, 99.1535, -3.09593>, 0.2172 }
				cylinder { <6.9023, 99.1535, -3.09593>, <7.4112, 102.4931, -3.2891>, 0.2172 }
				cylinder { <7.4112, 102.4931, -3.2891>, <7.687, 105.8635, -3.4>, 0.2172 }
				cylinder { <7.687, 105.8635, -3.4>, <7.7282, 109.2467, -3.4281>, 0.2172 }
				cylinder { <7.7282, 109.2467, -3.4281>, <7.5346, 112.6243, -3.3733>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <7.5346, 112.6243, -3.3733>, <7.3669, 113.2904, -3.1725>, <7.4419, 113.3169, -3.163> }
					triangle { <7.3669, 113.2904, -3.1725>, <7.3167, 113.6793, -3.1085>, <7.4419, 113.3169, -3.163> }
					triangle { <7.3167, 113.6793, -3.1085>, <7.4007, 113.7063, -3.09617>, <7.4419, 113.3169, -3.163> }
					triangle { <7.3167, 113.6793, -3.1085>, <7.3485, 114.261, -2.9902>, <7.4007, 113.7063, -3.09617> }
					triangle { <7.4007, 113.7063, -3.09617>, <7.3485, 114.261, -2.9902>, <7.4784, 113.6875, -3.05675> }
					triangle { <7.4419, 113.3169, -3.163>, <7.4007, 113.7063, -3.09617>, <7.4784, 113.6875, -3.05675> }
					triangle { <7.4419, 113.3169, -3.163>, <7.4784, 113.6875, -3.05675>, <7.5134, 113.3, -3.1352> }
					triangle { <7.4419, 113.3169, -3.163>, <7.5134, 113.3, -3.1352>, <7.5346, 112.6243, -3.3733> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.4806, 82.9919, -0.3357>, <0.6017, 83.6896, -0.4525>, 0.2172 }
			cylinder { <0.6017, 83.6896, -0.4525>, <0.6841, 84.3921, -0.5745>, 0.2172 }
			cylinder { <0.6841, 84.3921, -0.5745>, <0.7274, 85.09722, -0.7014>, 0.2172 }
			cylinder { <0.7274, 85.09722, -0.7014>, <0.7316, 85.8028, -0.8327>, 0.2172 }
			cylinder { <0.7316, 85.8028, -0.8327>, <0.6967, 86.5067, -0.9681>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.6967, 86.5067, -0.9681>, <0.485, 87.1531, -1.1972>, 0.2172 }
			cylinder { <0.485, 87.1531, -1.1972>, <0.2978, 87.8156, -1.4001>, 0.2172 }
			cylinder { <0.2978, 87.8156, -1.4001>, <0.1357, 88.4923, -1.5761>, 0.2172 }
			cylinder { <0.1357, 88.4923, -1.5761>, <-0.0008847, 89.1811, -1.7246>, 0.2172 }
			cylinder { <-0.0008847, 89.1811, -1.7246>, <-0.1115, 89.8799, -1.8453>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.1115, 89.8799, -1.8453>, <-0.5658, 93.2162, -2.178>, 0.2172 }
				cylinder { <-0.5658, 93.2162, -2.178>, <-0.9502, 96.5766, -2.2729>, 0.2172 }
				cylinder { <-0.9502, 96.5766, -2.2729>, <-1.2627, 99.9426, -2.1294>, 0.2172 }
				cylinder { <-1.2627, 99.9426, -2.1294>, <-1.5015, 103.2962, -1.7483>, 0.2172 }
				cylinder { <-1.5015, 103.2962, -1.7483>, <-1.6654, 106.619, -1.1316>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.6654, 106.619, -1.1316>, <-1.6344, 107.4021, -0.8648>, <-1.6162, 107.4412, -0.9469> }
					triangle { <-1.6344, 107.4021, -0.8648>, <-1.6667, 107.8515, -0.774>, <-1.6162, 107.4412, -0.9469> }
					triangle { <-1.6667, 107.8515, -0.774>, <-1.6437, 107.8927, -0.8657>, <-1.6162, 107.4412, -0.9469> }
					triangle { <-1.6667, 107.8515, -0.774>, <-1.6699, 108.539, -0.7554>, <-1.6437, 107.8927, -0.8657> }
					triangle { <-1.6437, 107.8927, -0.8657>, <-1.6699, 108.539, -0.7554>, <-1.5807, 107.8879, -0.9472> }
					triangle { <-1.6162, 107.4412, -0.9469>, <-1.6437, 107.8927, -0.8657>, <-1.5807, 107.8879, -0.9472> }
					triangle { <-1.6162, 107.4412, -0.9469>, <-1.5807, 107.8879, -0.9472>, <-1.5677, 107.4352, -1.02345> }
					triangle { <-1.6162, 107.4412, -0.9469>, <-1.5677, 107.4352, -1.02345>, <-1.6654, 106.619, -1.1316> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.1115, 89.8799, -1.8453>, <-0.2219, 90.5709, -2.004602>, 0.2172 }
			cylinder { <-0.2219, 90.5709, -2.004602>, <-0.3318, 91.2522, -2.202>, 0.2172 }
			cylinder { <-0.3318, 91.2522, -2.202>, <-0.4407, 91.9216, -2.4369>, 0.2172 }
			cylinder { <-0.4407, 91.9216, -2.4369>, <-0.5484, 92.5771, -2.7087>, 0.2172 }
			cylinder { <-0.5484, 92.5771, -2.7087>, <-0.6544, 93.2167, -3.01653>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.6544, 93.2167, -3.01653>, <-1.03279, 96.146, -4.6671>, 0.2172 }
				cylinder { <-1.03279, 96.146, -4.6671>, <-1.2875, 98.9732, -6.5085>, 0.2172 }
				cylinder { <-1.2875, 98.9732, -6.5085>, <-1.4174, 101.683, -8.5305>, 0.2172 }
				cylinder { <-1.4174, 101.683, -8.5305>, <-1.4216, 104.2607, -10.7223>, 0.2172 }
				cylinder { <-1.4216, 104.2607, -10.7223>, <-1.3001, 106.6924, -13.07194>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.3001, 106.6924, -13.07194>, <-1.2845, 107.0766, -13.7605>, <-1.355, 107.1278, -13.7458> }
					triangle { <-1.2845, 107.0766, -13.7605>, <-1.2795, 107.3509, -14.1018>, <-1.355, 107.1278, -13.7458> }
					triangle { <-1.2795, 107.3509, -14.1018>, <-1.3597, 107.405, -14.08466>, <-1.355, 107.1278, -13.7458> }
					triangle { <-1.2795, 107.3509, -14.1018>, <-1.3793, 107.7971, -14.571>, <-1.3597, 107.405, -14.08466> }
					triangle { <-1.3597, 107.405, -14.08466>, <-1.3793, 107.7971, -14.571>, <-1.4539, 107.4028, -14.05702> }
					triangle { <-1.355, 107.1278, -13.7458>, <-1.3597, 107.405, -14.08466>, <-1.4539, 107.4028, -14.05702> }
					triangle { <-1.355, 107.1278, -13.7458>, <-1.4539, 107.4028, -14.05702>, <-1.4358, 107.1305, -13.7149> }
					triangle { <-1.355, 107.1278, -13.7458>, <-1.4358, 107.1305, -13.7149>, <-1.3001, 106.6924, -13.07194> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.6544, 93.2167, -3.01653>, <-0.7877, 93.8638, -3.2969>, 0.2172 }
			cylinder { <-0.7877, 93.8638, -3.2969>, <-0.948, 94.5164, -3.5491>, 0.2172 }
			cylinder { <-0.948, 94.5164, -3.5491>, <-1.1347, 95.1724, -3.7723>, 0.2172 }
			cylinder { <-1.1347, 95.1724, -3.7723>, <-1.3473, 95.83, -3.9659>, 0.2172 }
			cylinder { <-1.3473, 95.83, -3.9659>, <-1.5852, 96.4872, -4.1293>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.5852, 96.4872, -4.1293>, <-2.9224, 99.5239, -4.7914>, 0.2172 }
				cylinder { <-2.9224, 99.5239, -4.7914>, <-4.4682, 102.4831, -5.3416>, 0.2172 }
				cylinder { <-4.4682, 102.4831, -5.3416>, <-6.2142, 105.3485, -5.777>, 0.2172 }
				cylinder { <-6.2142, 105.3485, -5.777>, <-8.1509, 108.1046, -6.09524>, 0.2172 }
				cylinder { <-8.1509, 108.1046, -6.09524>, <-10.2678, 110.7366, -6.2944>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-10.2678, 110.7366, -6.2944>, <-10.7862, 111.2764, -6.3614>, <-10.7337, 111.3418, -6.3549> }
					triangle { <-10.7862, 111.2764, -6.3614>, <-11.03179, 111.6022, -6.4481>, <-10.7337, 111.3418, -6.3549> }
					triangle { <-11.03179, 111.6022, -6.4481>, <-10.9721, 111.6737, -6.4381>, <-10.7337, 111.3418, -6.3549> }
					triangle { <-11.03179, 111.6022, -6.4481>, <-11.3089, 112.1529, -6.5455>, <-10.9721, 111.6737, -6.4381> }
					triangle { <-10.9721, 111.6737, -6.4381>, <-11.3089, 112.1529, -6.5455>, <-10.9039, 111.7099, -6.3853> }
					triangle { <-10.7337, 111.3418, -6.3549>, <-10.9721, 111.6737, -6.4381>, <-10.9039, 111.7099, -6.3853> }
					triangle { <-10.7337, 111.3418, -6.3549>, <-10.9039, 111.7099, -6.3853>, <-10.6688, 111.373, -6.3148> }
					triangle { <-10.7337, 111.3418, -6.3549>, <-10.6688, 111.373, -6.3148>, <-10.2678, 110.7366, -6.2944> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.5852, 96.4872, -4.1293>, <-1.7857, 97.155, -4.2994>, 0.2172 }
			cylinder { <-1.7857, 97.155, -4.2994>, <-1.9484, 97.8315, -4.4755>, 0.2172 }
			cylinder { <-1.9484, 97.8315, -4.4755>, <-2.07262, 98.5147, -4.6572>, 0.2172 }
			cylinder { <-2.07262, 98.5147, -4.6572>, <-2.158, 99.2024, -4.8439>, 0.2172 }
			cylinder { <-2.158, 99.2024, -4.8439>, <-2.2044, 99.8927, -5.03499>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.2044, 99.8927, -5.03499>, <-2.1911, 103.1767, -5.8497>, 0.2172 }
				cylinder { <-2.1911, 103.1767, -5.8497>, <-1.946, 106.4727, -6.5741>, 0.2172 }
				cylinder { <-1.946, 106.4727, -6.5741>, <-1.4705, 109.7629, -7.2043>, 0.2172 }
				cylinder { <-1.4705, 109.7629, -7.2043>, <-0.767, 113.0294, -7.7367>, 0.2172 }
				cylinder { <-0.767, 113.0294, -7.7367>, <0.1604, 116.2546, -8.1685>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.1604, 116.2546, -8.1685>, <0.5604, 116.8326, -8.3022>, <0.5175, 116.8601, -8.364> }
					triangle { <0.5604, 116.8326, -8.3022>, <0.7248, 117.1871, -8.3743>, <0.5175, 116.8601, -8.364> }
					triangle { <0.7248, 117.1871, -8.3743>, <0.6772, 117.2148, -8.4444>, <0.5175, 116.8601, -8.364> }
					triangle { <0.7248, 117.1871, -8.3743>, <0.907, 117.7177, -8.5711>, <0.6772, 117.2148, -8.4444> }
					triangle { <0.6772, 117.2148, -8.4444>, <0.907, 117.7177, -8.5711>, <0.6416, 117.191, -8.5226> }
					triangle { <0.5175, 116.8601, -8.364>, <0.6772, 117.2148, -8.4444>, <0.6416, 117.191, -8.5226> }
					triangle { <0.5175, 116.8601, -8.364>, <0.6416, 117.191, -8.5226>, <0.4793, 116.8407, -8.4298> }
					triangle { <0.5175, 116.8601, -8.364>, <0.4793, 116.8407, -8.4298>, <0.1604, 116.2546, -8.1685> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.6967, 86.5067, -0.9681>, <0.6879, 87.2165, -1.07465>, 0.2172 }
			cylinder { <0.6879, 87.2165, -1.07465>, <0.7051, 87.9298, -1.1518>, 0.2172 }
			cylinder { <0.7051, 87.9298, -1.1518>, <0.7484, 88.6446, -1.1995>, 0.2172 }
			cylinder { <0.7484, 88.6446, -1.1995>, <0.8175, 89.3588, -1.2175>, 0.2172 }
			cylinder { <0.8175, 89.3588, -1.2175>, <0.9123, 90.0702, -1.2057>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.9123, 90.0702, -1.2057>, <1.06347, 90.7403, -0.9978>, 0.2172 }
			cylinder { <1.06347, 90.7403, -0.9978>, <1.2171, 91.4204, -0.8278>, 0.2172 }
			cylinder { <1.2171, 91.4204, -0.8278>, <1.3728, 92.1086, -0.6964>, 0.2172 }
			cylinder { <1.3728, 92.1086, -0.6964>, <1.5302, 92.8028, -0.6039>, 0.2172 }
			cylinder { <1.5302, 92.8028, -0.6039>, <1.6888, 93.5007, -0.5505>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.6888, 93.5007, -0.5505>, <2.5485, 96.7731, -0.5207>, 0.2172 }
				cylinder { <2.5485, 96.7731, -0.5207>, <3.5155, 100.0099, -0.7129>, 0.2172 }
				cylinder { <3.5155, 100.0099, -0.7129>, <4.5845, 103.1934, -1.1259>, 0.2172 }
				cylinder { <4.5845, 103.1934, -1.1259>, <5.7499, 106.3065, -1.7575>, 0.2172 }
				cylinder { <5.7499, 106.3065, -1.7575>, <7.005334, 109.3323, -2.6044>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <7.005334, 109.3323, -2.6044>, <7.3284, 110.0174, -2.9385>, <7.2709, 110.0778, -2.898> }
					triangle { <7.3284, 110.0174, -2.9385>, <7.5103, 110.4241, -3.05143>, <7.2709, 110.0778, -2.898> }
					triangle { <7.5103, 110.4241, -3.05143>, <7.4436, 110.4893, -3.00757>, <7.2709, 110.0778, -2.898> }
					triangle { <7.5103, 110.4241, -3.05143>, <7.6774, 111.0807, -3.1692>, <7.4436, 110.4893, -3.00757> }
					triangle { <7.4436, 110.4893, -3.00757>, <7.6774, 111.0807, -3.1692>, <7.344, 110.51, -2.9911> }
					triangle { <7.2709, 110.0778, -2.898>, <7.4436, 110.4893, -3.00757>, <7.344, 110.51, -2.9911> }
					triangle { <7.2709, 110.0778, -2.898>, <7.344, 110.51, -2.9911>, <7.1848, 110.0951, -2.8749> }
					triangle { <7.2709, 110.0778, -2.898>, <7.1848, 110.0951, -2.8749>, <7.005334, 109.3323, -2.6044> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.6888, 93.5007, -0.5505>, <1.8207, 94.2014, -0.4684>, 0.2172 }
			cylinder { <1.8207, 94.2014, -0.4684>, <1.9254, 94.9028, -0.3577>, 0.2172 }
			cylinder { <1.9254, 94.9028, -0.3577>, <2.00262, 95.6027, -0.2189>, 0.2172 }
			cylinder { <2.00262, 95.6027, -0.2189>, <2.05209, 96.2991, -0.05243>, 0.2172 }
			cylinder { <2.05209, 96.2991, -0.05243>, <2.07365, 96.9898, 0.1413>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.07365, 96.9898, 0.1413>, <1.9386, 100.2233, 1.1289>, 0.2172 }
				cylinder { <1.9386, 100.2233, 1.1289>, <1.5678, 103.4162, 2.1855>, 0.2172 }
				cylinder { <1.5678, 103.4162, 2.1855>, <0.963, 106.5513, 3.3053>, 0.2172 }
				cylinder { <0.963, 106.5513, 3.3053>, <0.1276, 109.6116, 4.4822>, 0.2172 }
				cylinder { <0.1276, 109.6116, 4.4822>, <-0.9338, 112.5805, 5.7098>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.9338, 112.5805, 5.7098>, <-1.3033, 113.1333, 6.134>, <-1.2308, 113.1744, 6.1634> }
					triangle { <-1.3033, 113.1333, 6.134>, <-1.4657, 113.4879, 6.3331>, <-1.2308, 113.1744, 6.1634> }
					triangle { <-1.4657, 113.4879, 6.3331>, <-1.384, 113.5305, 6.3668>, <-1.2308, 113.1744, 6.1634> }
					triangle { <-1.4657, 113.4879, 6.3331>, <-1.5957, 114.0354, 6.6686>, <-1.384, 113.5305, 6.3668> }
					triangle { <-1.384, 113.5305, 6.3668>, <-1.5957, 114.0354, 6.6686>, <-1.2977, 113.5155, 6.4113> }
					triangle { <-1.2308, 113.1744, 6.1634>, <-1.384, 113.5305, 6.3668>, <-1.2977, 113.5155, 6.4113> }
					triangle { <-1.2308, 113.1744, 6.1634>, <-1.2977, 113.5155, 6.4113>, <-1.1512, 113.1641, 6.1956> }
					triangle { <-1.2308, 113.1744, 6.1634>, <-1.1512, 113.1641, 6.1956>, <-0.9338, 112.5805, 5.7098> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.07365, 96.9898, 0.1413>, <2.1345, 97.6789, 0.3327>, 0.2172 }
			cylinder { <2.1345, 97.6789, 0.3327>, <2.2344, 98.3641, 0.5213>, 0.2172 }
			cylinder { <2.2344, 98.3641, 0.5213>, <2.3731, 99.04356, 0.7066>, 0.2172 }
			cylinder { <2.3731, 99.04356, 0.7066>, <2.5502, 99.715, 0.8878>, 0.2172 }
			cylinder { <2.5502, 99.715, 0.8878>, <2.7652, 100.3766, 1.06473>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.7652, 100.3766, 1.06473>, <3.9927, 103.3949, 1.9765>, 0.2172 }
				cylinder { <3.9927, 103.3949, 1.9765>, <5.4277, 106.2965, 2.9616>, 0.2172 }
				cylinder { <5.4277, 106.2965, 2.9616>, <7.06238, 109.0655, 4.01456>, 0.2172 }
				cylinder { <7.06238, 109.0655, 4.01456>, <8.8878, 111.6871, 5.1297>, 0.2172 }
				cylinder { <8.8878, 111.6871, 5.1297>, <10.8943, 114.1469, 6.3009>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <10.8943, 114.1469, 6.3009>, <11.3506, 114.6532, 6.617>, <11.3308, 114.7176, 6.5666> }
					triangle { <11.3506, 114.6532, 6.617>, <11.547, 114.9752, 6.7954>, <11.3308, 114.7176, 6.5666> }
					triangle { <11.547, 114.9752, 6.7954>, <11.5256, 115.0448, 6.7367>, <11.3308, 114.7176, 6.5666> }
					triangle { <11.547, 114.9752, 6.7954>, <11.8095, 115.5144, 6.968>, <11.5256, 115.0448, 6.7367> }
					triangle { <11.5256, 115.0448, 6.7367>, <11.8095, 115.5144, 6.968>, <11.5177, 115.0698, 6.6468> }
					triangle { <11.3308, 114.7176, 6.5666>, <11.5256, 115.0448, 6.7367>, <11.5177, 115.0698, 6.6468> }
					triangle { <11.3308, 114.7176, 6.5666>, <11.5177, 115.0698, 6.6468>, <11.3162, 114.7409, 6.4889> }
					triangle { <11.3308, 114.7176, 6.5666>, <11.3162, 114.7409, 6.4889>, <10.8943, 114.1469, 6.3009> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.7652, 100.3766, 1.06473>, <2.9509, 101.0524, 1.2193>, 0.2172 }
			cylinder { <2.9509, 101.0524, 1.2193>, <3.1069, 101.7404, 1.3512>, 0.2172 }
			cylinder { <3.1069, 101.7404, 1.3512>, <3.2327, 102.4386, 1.46>, 0.2172 }
			cylinder { <3.2327, 102.4386, 1.46>, <3.3278, 103.1449, 1.5454>, 0.2172 }
			cylinder { <3.3278, 103.1449, 1.5454>, <3.3921, 103.8571, 1.607>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.3921, 103.8571, 1.607>, <3.5874, 107.2343, 1.6738>, 0.2172 }
				cylinder { <3.5874, 107.2343, 1.6738>, <3.6739, 110.6131, 1.5165>, 0.2172 }
				cylinder { <3.6739, 110.6131, 1.5165>, <3.6511, 113.9752, 1.1361>, 0.2172 }
				cylinder { <3.6511, 113.9752, 1.1361>, <3.519, 117.3022, 0.5345>, 0.2172 }
				cylinder { <3.519, 117.3022, 0.5345>, <3.2785, 120.5762, -0.2848>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <3.2785, 120.5762, -0.2848>, <3.02802, 121.1919, -0.5499>, <3.02574, 121.2321, -0.4806> }
					triangle { <3.02802, 121.1919, -0.5499>, <2.9399, 121.562, -0.6646>, <3.02574, 121.2321, -0.4806> }
					triangle { <2.9399, 121.562, -0.6646>, <2.9357, 121.6043, -0.5863>, <3.02574, 121.2321, -0.4806> }
					triangle { <2.9399, 121.562, -0.6646>, <2.7978, 122.1356, -0.7292>, <2.9357, 121.6043, -0.5863> }
					triangle { <2.9357, 121.6043, -0.5863>, <2.7978, 122.1356, -0.7292>, <2.9063, 121.5999, -0.5023> }
					triangle { <3.02574, 121.2321, -0.4806>, <2.9357, 121.6043, -0.5863>, <2.9063, 121.5999, -0.5023> }
					triangle { <3.02574, 121.2321, -0.4806>, <2.9063, 121.5999, -0.5023>, <3.007035, 121.2286, -0.4045> }
					triangle { <3.02574, 121.2321, -0.4806>, <3.007035, 121.2286, -0.4045>, <3.2785, 120.5762, -0.2848> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9123, 90.0702, -1.2057>, <1.007965, 90.7809, -1.2333>, 0.2172 }
			cylinder { <1.007965, 90.7809, -1.2333>, <1.1041, 91.489, -1.3002>, 0.2172 }
			cylinder { <1.1041, 91.489, -1.3002>, <1.2005, 92.1923, -1.4062>, 0.2172 }
			cylinder { <1.2005, 92.1923, -1.4062>, <1.297, 92.8886, -1.5509>, 0.2172 }
			cylinder { <1.297, 92.8886, -1.5509>, <1.3932, 93.5759, -1.734>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <1.3932, 93.5759, -1.734>, <1.5654, 94.175, -2.08979>, 0.2172 }
			cylinder { <1.5654, 94.175, -2.08979>, <1.7134, 94.794, -2.4215>, 0.2172 }
			cylinder { <1.7134, 94.794, -2.4215>, <1.8369, 95.431, -2.7283>, 0.2172 }
			cylinder { <1.8369, 95.431, -2.7283>, <1.9355, 96.08418, -3.009188>, 0.2172 }
			cylinder { <1.9355, 96.08418, -3.009188>, <2.008865, 96.7513, -3.2633>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.008865, 96.7513, -3.2633>, <2.1257, 99.9448, -4.3754>, 0.2172 }
				cylinder { <2.1257, 99.9448, -4.3754>, <2.01322, 103.169, -5.3955>, 0.2172 }
				cylinder { <2.01322, 103.169, -5.3955>, <1.6719, 106.4064, -6.3181>, 0.2172 }
				cylinder { <1.6719, 106.4064, -6.3181>, <1.1036, 109.6396, -7.138>, 0.2172 }
				cylinder { <1.1036, 109.6396, -7.138>, <0.3115, 112.8509, -7.8509>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.3115, 112.8509, -7.8509>, <0.01214, 113.6179, -7.9365>, <0.09374, 113.662, -7.936> }
					triangle { <0.01214, 113.6179, -7.9365>, <-0.1034, 114.0501, -8.04202>, <0.09374, 113.662, -7.936> }
					triangle { <-0.1034, 114.0501, -8.04202>, <-0.01185, 114.0973, -8.03836>, <0.09374, 113.662, -7.936> }
					triangle { <-0.1034, 114.0501, -8.04202>, <-0.1557, 114.7233, -8.1726>, <-0.01185, 114.0973, -8.03836> }
					triangle { <-0.01185, 114.0973, -8.03836>, <-0.1557, 114.7233, -8.1726>, <0.07629, 114.1069, -7.9857> }
					triangle { <0.09374, 113.662, -7.936>, <-0.01185, 114.0973, -8.03836>, <0.07629, 114.1069, -7.9857> }
					triangle { <0.09374, 113.662, -7.936>, <0.07629, 114.1069, -7.9857>, <0.1754, 113.6674, -7.8968> }
					triangle { <0.09374, 113.662, -7.936>, <0.1754, 113.6674, -7.8968>, <0.3115, 112.8509, -7.8509> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.008865, 96.7513, -3.2633>, <2.1209, 97.412, -3.5204>, 0.2172 }
			cylinder { <2.1209, 97.412, -3.5204>, <2.2713, 98.06419, -3.7796>, 0.2172 }
			cylinder { <2.2713, 98.06419, -3.7796>, <2.4597, 98.7058, -4.04029>, 0.2172 }
			cylinder { <2.4597, 98.7058, -4.04029>, <2.6854, 99.3351, -4.3014>, 0.2172 }
			cylinder { <2.6854, 99.3351, -4.3014>, <2.9478, 99.9501, -4.5623>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.9478, 99.9501, -4.5623>, <4.401, 102.7934, -5.6813>, 0.2172 }
				cylinder { <4.401, 102.7934, -5.6813>, <6.06236, 105.5655, -6.6834>, 0.2172 }
				cylinder { <6.06236, 105.5655, -6.6834>, <7.9227, 108.2513, -7.5632>, 0.2172 }
				cylinder { <7.9227, 108.2513, -7.5632>, <9.9721, 110.8362, -8.316>, 0.2172 }
				cylinder { <9.9721, 110.8362, -8.316>, <12.1994, 113.3063, -8.9376>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <12.1994, 113.3063, -8.9376>, <12.8658, 113.7042, -9.07734>, <12.8408, 113.7404, -9.1539> }
					triangle { <12.8658, 113.7042, -9.07734>, <13.1918, 113.9832, -9.165>, <12.8408, 113.7404, -9.1539> }
					triangle { <13.1918, 113.9832, -9.165>, <13.1631, 114.0202, -9.2513>, <12.8408, 113.7404, -9.1539> }
					triangle { <13.1918, 113.9832, -9.165>, <13.6246, 114.4138, -9.4026>, <13.1631, 114.0202, -9.2513> }
					triangle { <13.1631, 114.0202, -9.2513>, <13.6246, 114.4138, -9.4026>, <13.1252, 113.9991, -9.3394> }
					triangle { <12.8408, 113.7404, -9.1539>, <13.1631, 114.0202, -9.2513>, <13.1252, 113.9991, -9.3394> }
					triangle { <12.8408, 113.7404, -9.1539>, <13.1252, 113.9991, -9.3394>, <12.801, 113.7266, -9.2295> }
					triangle { <12.8408, 113.7404, -9.1539>, <12.801, 113.7266, -9.2295>, <12.1994, 113.3063, -8.9376> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.9478, 99.9501, -4.5623>, <3.1797, 100.5664, -4.8479>, 0.2172 }
			cylinder { <3.1797, 100.5664, -4.8479>, <3.3802, 101.1821, -5.1574>, 0.2172 }
			cylinder { <3.3802, 101.1821, -5.1574>, <3.5488, 101.7954, -5.4898>, 0.2172 }
			cylinder { <3.5488, 101.7954, -5.4898>, <3.6851, 102.4044, -5.8443>, 0.2172 }
			cylinder { <3.6851, 102.4044, -5.8443>, <3.7885, 103.0073, -6.2197>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.7885, 103.0073, -6.2197>, <4.1476, 105.745, -8.1754>, 0.2172 }
				cylinder { <4.1476, 105.745, -8.1754>, <4.3759, 108.3634, -10.3063>, 0.2172 }
				cylinder { <4.3759, 108.3634, -10.3063>, <4.4723, 110.8481, -12.6009>, 0.2172 }
				cylinder { <4.4723, 110.8481, -12.6009>, <4.4363, 113.1858, -15.04683>, 0.2172 }
				cylinder { <4.4363, 113.1858, -15.04683>, <4.268, 115.3639, -17.6306>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.268, 115.3639, -17.6306>, <4.2499, 115.7949, -18.2457>, <4.2462, 115.8691, -18.2061> }
					triangle { <4.2499, 115.7949, -18.2457>, <4.2925, 116.0694, -18.557>, <4.2462, 115.8691, -18.2061> }
					triangle { <4.2925, 116.0694, -18.557>, <4.2858, 116.1507, -18.5112>, <4.2462, 115.8691, -18.2061> }
					triangle { <4.2925, 116.0694, -18.557>, <4.3312, 116.5585, -18.9427>, <4.2858, 116.1507, -18.5112> }
					triangle { <4.2858, 116.1507, -18.5112>, <4.3312, 116.5585, -18.9427>, <4.2393, 116.198, -18.4451> }
					triangle { <4.2462, 115.8691, -18.2061>, <4.2858, 116.1507, -18.5112>, <4.2393, 116.198, -18.4451> }
					triangle { <4.2462, 115.8691, -18.2061>, <4.2393, 116.198, -18.4451>, <4.2121, 115.9111, -18.144> }
					triangle { <4.2462, 115.8691, -18.2061>, <4.2121, 115.9111, -18.144>, <4.268, 115.3639, -17.6306> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.7885, 103.0073, -6.2197>, <3.9023, 103.6281, -6.5616>, 0.2172 }
			cylinder { <3.9023, 103.6281, -6.5616>, <4.02595, 104.2648, -6.8688>, 0.2172 }
			cylinder { <4.02595, 104.2648, -6.8688>, <4.159, 104.9157, -7.1406>, 0.2172 }
			cylinder { <4.159, 104.9157, -7.1406>, <4.3012, 105.5786, -7.3759>, 0.2172 }
			cylinder { <4.3012, 105.5786, -7.3759>, <4.4521, 106.2517, -7.5742>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.4521, 106.2517, -7.5742>, <5.1024, 109.4967, -8.2784>, 0.2172 }
				cylinder { <5.1024, 109.4967, -8.2784>, <5.6886, 112.7958, -8.7482>, 0.2172 }
				cylinder { <5.6886, 112.7958, -8.7482>, <6.2074, 116.1312, -8.9808>, 0.2172 }
				cylinder { <6.2074, 116.1312, -8.9808>, <6.656, 119.4849, -8.9753>, 0.2172 }
				cylinder { <6.656, 119.4849, -8.9753>, <7.03201, 122.8387, -8.7314>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <7.03201, 122.8387, -8.7314>, <7.1814, 123.4864, -8.4665>, <7.2367, 123.5067, -8.521> }
					triangle { <7.1814, 123.4864, -8.4665>, <7.2543, 123.8677, -8.3818>, <7.2367, 123.5067, -8.521> }
					triangle { <7.2543, 123.8677, -8.3818>, <7.3172, 123.8875, -8.4418>, <7.2367, 123.5067, -8.521> }
					triangle { <7.2543, 123.8677, -8.3818>, <7.4442, 124.4284, -8.3279>, <7.3172, 123.8875, -8.4418> }
					triangle { <7.3172, 123.8875, -8.4418>, <7.4442, 124.4284, -8.3279>, <7.3919, 123.8593, -8.4814> }
					triangle { <7.2367, 123.5067, -8.521>, <7.3172, 123.8875, -8.4418>, <7.3919, 123.8593, -8.4814> }
					triangle { <7.2367, 123.5067, -8.521>, <7.3919, 123.8593, -8.4814>, <7.2986, 123.482, -8.5624> }
					triangle { <7.2367, 123.5067, -8.521>, <7.2986, 123.482, -8.5624>, <7.03201, 122.8387, -8.7314> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.04047, 11.1821, 0.8238>, 0.19 }
			cylinder { <0.04047, 11.1821, 0.8238>, <0.1212, 22.2733, 2.467>, 0.19 }
			cylinder { <0.1212, 22.2733, 2.467>, <0.2417, 33.2134, 4.9208>, 0.19 }
			cylinder { <0.2417, 33.2134, 4.9208>, <0.4014, 43.9431, 8.1717>, 0.19 }
			cylinder { <0.4014, 43.9431, 8.1717>, <0.5994, 54.4043, 12.2022>, 0.19 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.5994, 54.4043, 12.2022>, <0.6436, 56.5797, 13.1021>, 0.19 }
				cylinder { <0.6436, 56.5797, 13.1021>, <0.6904, 58.7324, 14.05523>, 0.19 }
				cylinder { <0.6904, 58.7324, 14.05523>, <0.7398, 60.8609, 15.06076>, 0.19 }
				cylinder { <0.7398, 60.8609, 15.06076>, <0.7918, 62.9641, 16.1181>, 0.19 }
				cylinder { <0.7918, 62.9641, 16.1181>, <0.8462, 65.04078, 17.2267>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.8462, 65.04078, 17.2267>, <0.9546, 65.5984, 17.5199>, 0.01083 }
				cylinder { <0.9546, 65.5984, 17.5199>, <1.1541, 66.1379, 17.7988>, 0.01083 }
				cylinder { <1.1541, 66.1379, 17.7988>, <1.4404, 66.6476, 18.05749>, 0.01083 }
				cylinder { <1.4404, 66.6476, 18.05749>, <1.8074, 67.1163, 18.2903>, 0.01083 }
				cylinder { <1.8074, 67.1163, 18.2903>, <2.2472, 67.5341, 18.4922>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.2472, 67.5341, 18.4922>, <4.003904, 69.3173, 18.8356>, <3.9915, 69.3278, 19.01913> }
				triangle { <4.003904, 69.3173, 18.8356>, <4.8507, 70.5014, 19.00382>, <3.9915, 69.3278, 19.01913> }
				triangle { <4.8507, 70.5014, 19.00382>, <4.7809, 70.5175, 19.1954>, <3.9915, 69.3278, 19.01913> }
				triangle { <4.8507, 70.5014, 19.00382>, <6.855, 74.6019, 19.3853>, <4.7809, 70.5175, 19.1954> }
				triangle { <4.7809, 70.5175, 19.1954>, <6.855, 74.6019, 19.3853>, <4.6881, 70.5097, 19.3807> }
				triangle { <3.9915, 69.3278, 19.01913>, <4.7809, 70.5175, 19.1954>, <4.6881, 70.5097, 19.3807> }
				triangle { <3.9915, 69.3278, 19.01913>, <4.6881, 70.5097, 19.3807>, <3.9137, 69.3135, 19.1749> }
				triangle { <3.9915, 69.3278, 19.01913>, <3.9137, 69.3135, 19.1749>, <2.2472, 67.5341, 18.4922> }
				triangle { <7.6644, 76.8745, 19.5257>, <6.855, 74.6019, 19.3853>, <6.8957, 74.6415, 19.08992> }
				triangle { <4.6881, 70.5097, 19.3807>, <6.855, 74.6019, 19.3853>, <6.6517, 74.7189, 19.6793> }
				triangle { <4.8507, 70.5014, 19.00382>, <6.8957, 74.6415, 19.08992>, <6.855, 74.6019, 19.3853> }
				triangle { <7.6644, 76.8745, 19.5257>, <6.6517, 74.7189, 19.6793>, <6.855, 74.6019, 19.3853> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.8462, 65.04078, 17.2267>, <0.9633, 67.05979, 18.4326>, 0.19 }
				cylinder { <0.9633, 67.05979, 18.4326>, <1.1424, 69.01512, 19.7322>, 0.19 }
				cylinder { <1.1424, 69.01512, 19.7322>, <1.3832, 70.9008, 21.1216>, 0.19 }
				cylinder { <1.3832, 70.9008, 21.1216>, <1.6846, 72.7113, 22.5966>, 0.19 }
				cylinder { <1.6846, 72.7113, 22.5966>, <2.04587, 74.441, 24.1528>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.04587, 74.441, 24.1528>, <2.06589, 74.915, 24.5813>, 0.01083 }
				cylinder { <2.06589, 74.915, 24.5813>, <2.007558, 75.3863, 25.00927>, 0.01083 }
				cylinder { <2.007558, 75.3863, 25.00927>, <1.8717, 75.8478, 25.4302>, 0.01083 }
				cylinder { <1.8717, 75.8478, 25.4302>, <1.6605, 76.2925, 25.8379>, 0.01083 }
				cylinder { <1.6605, 76.2925, 25.8379>, <1.377, 76.7138, 26.2262>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.377, 76.7138, 26.2262>, <0.3533, 78.6923, 27.4186>, <0.2596, 78.5974, 27.5458> }
				triangle { <0.3533, 78.6923, 27.4186>, <-0.4103, 79.8216, 27.956>, <0.2596, 78.5974, 27.5458> }
				triangle { <-0.4103, 79.8216, 27.956>, <-0.532, 79.6872, 28.05093>, <0.2596, 78.5974, 27.5458> }
				triangle { <-0.4103, 79.8216, 27.956>, <-3.2869, 83.2111, 29.05787>, <-0.532, 79.6872, 28.05093> }
				triangle { <-0.532, 79.6872, 28.05093>, <-3.2869, 83.2111, 29.05787>, <-0.639, 79.5277, 28.1289> }
				triangle { <0.2596, 78.5974, 27.5458>, <-0.532, 79.6872, 28.05093>, <-0.639, 79.5277, 28.1289> }
				triangle { <0.2596, 78.5974, 27.5458>, <-0.639, 79.5277, 28.1289>, <0.1761, 78.4591, 27.6125> }
				triangle { <0.2596, 78.5974, 27.5458>, <0.1761, 78.4591, 27.6125>, <1.377, 76.7138, 26.2262> }
				triangle { <-4.9538, 84.9232, 29.4177>, <-3.2869, 83.2111, 29.05787>, <-3.1757, 83.4085, 28.8599> }
				triangle { <-0.639, 79.5277, 28.1289>, <-3.2869, 83.2111, 29.05787>, <-3.5833, 82.9908, 29.129> }
				triangle { <-0.4103, 79.8216, 27.956>, <-3.1757, 83.4085, 28.8599>, <-3.2869, 83.2111, 29.05787> }
				triangle { <-4.9538, 84.9232, 29.4177>, <-3.5833, 82.9908, 29.129>, <-3.2869, 83.2111, 29.05787> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.04587, 74.441, 24.1528>, <2.408, 76.1314, 25.7515>, 0.19 }
				cylinder { <2.408, 76.1314, 25.7515>, <2.7709, 77.7815, 27.3915>, 0.19 }
				cylinder { <2.7709, 77.7815, 27.3915>, <3.1344, 79.3903, 29.072>, 0.19 }
				cylinder { <3.1344, 79.3903, 29.072>, <3.4981, 80.9569, 30.7918>, 0.19 }
				cylinder { <3.4981, 80.9569, 30.7918>, <3.8619, 82.4802, 32.55>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.8619, 82.4802, 32.55>, <4.05234, 82.8798, 33.01134>, 0.01083 }
				cylinder { <4.05234, 82.8798, 33.01134>, <4.3302, 83.2567, 33.4465>, 0.01083 }
				cylinder { <4.3302, 83.2567, 33.4465>, <4.6895, 83.6028, 33.8461>, 0.01083 }
				cylinder { <4.6895, 83.6028, 33.8461>, <5.1225, 83.9107, 34.2017>, 0.01083 }
				cylinder { <5.1225, 83.9107, 34.2017>, <5.6198, 84.1735, 34.5054>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.6198, 84.1735, 34.5054>, <7.6112, 85.4947, 35.3257>, <7.6047, 85.4405, 35.5017> }
				triangle { <7.6112, 85.4947, 35.3257>, <8.6154, 86.4314, 35.8372>, <7.6047, 85.4405, 35.5017> }
				triangle { <8.6154, 86.4314, 35.8372>, <8.5531, 86.3863, 36.0268>, <7.6047, 85.4405, 35.5017> }
				triangle { <8.6154, 86.4314, 35.8372>, <11.1691, 89.8571, 37.4863>, <8.5531, 86.3863, 36.0268> }
				triangle { <8.5531, 86.3863, 36.0268>, <11.1691, 89.8571, 37.4863>, <8.4646, 86.3241, 36.2037> }
				triangle { <7.6047, 85.4405, 35.5017>, <8.5531, 86.3863, 36.0268>, <8.4646, 86.3241, 36.2037> }
				triangle { <7.6047, 85.4405, 35.5017>, <8.4646, 86.3241, 36.2037>, <7.5294, 85.3811, 35.6478> }
				triangle { <7.6047, 85.4405, 35.5017>, <7.5294, 85.3811, 35.6478>, <5.6198, 84.1735, 34.5054> }
				triangle { <12.2843, 91.8169, 38.3553>, <11.1691, 89.8571, 37.4863>, <11.2079, 89.9941, 37.2213> }
				triangle { <8.4646, 86.3241, 36.2037>, <11.1691, 89.8571, 37.4863>, <10.9908, 89.885, 37.8163> }
				triangle { <8.6154, 86.4314, 35.8372>, <11.2079, 89.9941, 37.2213>, <11.1691, 89.8571, 37.4863> }
				triangle { <12.2843, 91.8169, 38.3553>, <10.9908, 89.885, 37.8163>, <11.1691, 89.8571, 37.4863> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.8619, 82.4802, 32.55>, <4.2256, 83.9594, 34.3456>, 0.19 }
				cylinder { <4.2256, 83.9594, 34.3456>, <4.5889, 85.3936, 36.1774>, 0.19 }
				cylinder { <4.5889, 85.3936, 36.1774>, <4.9517, 86.7819, 38.04431>, 0.19 }
				cylinder { <4.9517, 86.7819, 38.04431>, <5.3137, 88.1235, 39.9452>, 0.19 }
				cylinder { <5.3137, 88.1235, 39.9452>, <5.6746, 89.4175, 41.8789>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.6746, 89.4175, 41.8789>, <5.6789, 89.7746, 42.4092>, 0.01083 }
				cylinder { <5.6789, 89.7746, 42.4092>, <5.5893, 90.1296, 42.9332>, 0.01083 }
				cylinder { <5.5893, 90.1296, 42.9332>, <5.4079, 90.475, 43.4396>, 0.01083 }
				cylinder { <5.4079, 90.475, 43.4396>, <5.1385, 90.8031, 43.9175>, 0.01083 }
				cylinder { <5.1385, 90.8031, 43.9175>, <4.7869, 91.107, 44.3565>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.7869, 91.107, 44.3565>, <3.5107, 92.6984, 45.8474>, <3.41, 92.5721, 45.9361> }
				triangle { <3.5107, 92.6984, 45.8474>, <2.6201, 93.6348, 46.5383>, <3.41, 92.5721, 45.9361> }
				triangle { <2.6201, 93.6348, 46.5383>, <2.4978, 93.477, 46.5831>, <3.41, 92.5721, 45.9361> }
				triangle { <2.6201, 93.6348, 46.5383>, <-0.5761, 96.5472, 48.04779>, <2.4978, 93.477, 46.5831> }
				triangle { <2.4978, 93.477, 46.5831>, <-0.5761, 96.5472, 48.04779>, <2.3935, 93.2994, 46.6075> }
				triangle { <3.41, 92.5721, 45.9361>, <2.4978, 93.477, 46.5831>, <2.3935, 93.2994, 46.6075> }
				triangle { <3.41, 92.5721, 45.9361>, <2.3935, 93.2994, 46.6075>, <3.3289, 92.4188, 45.9575> }
				triangle { <3.41, 92.5721, 45.9361>, <3.3289, 92.4188, 45.9575>, <4.7869, 91.107, 44.3565> }
				triangle { <-2.3812, 98.05805, 48.5943>, <-0.5761, 96.5472, 48.04779>, <-0.457, 96.7906, 47.9172> }
				triangle { <2.3935, 93.2994, 46.6075>, <-0.5761, 96.5472, 48.04779>, <-0.8635, 96.3054, 48.02803> }
				triangle { <2.6201, 93.6348, 46.5383>, <-0.457, 96.7906, 47.9172>, <-0.5761, 96.5472, 48.04779> }
				triangle { <-2.3812, 98.05805, 48.5943>, <-0.8635, 96.3054, 48.02803>, <-0.5761, 96.5472, 48.04779> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <5.6746, 89.4175, 41.8789>, <5.7726, 89.7689, 42.4039>, 0.01083 }
				cylinder { <5.7726, 89.7689, 42.4039>, <5.8706, 90.1202, 42.9289>, 0.01083 }
				cylinder { <5.8706, 90.1202, 42.9289>, <5.9686, 90.4715, 43.4539>, 0.01083 }
				cylinder { <5.9686, 90.4715, 43.4539>, <6.06666, 90.8228, 43.9789>, 0.01083 }
				cylinder { <6.06666, 90.8228, 43.9789>, <6.1646, 91.1741, 44.5039>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <6.1646, 91.1741, 44.5039>, <6.6485, 92.9118, 46.2731>, <6.5751, 92.8214, 46.4159> }
				triangle { <6.6485, 92.9118, 46.2731>, <6.7265, 94.01103, 47.2392>, <6.5751, 92.8214, 46.4159> }
				triangle { <6.7265, 94.01103, 47.2392>, <6.6008, 93.9053, 47.3614>, <6.5751, 92.8214, 46.4159> }
				triangle { <6.7265, 94.01103, 47.2392>, <6.2987, 97.6726, 49.957>, <6.6008, 93.9053, 47.3614> }
				triangle { <6.6008, 93.9053, 47.3614>, <6.2987, 97.6726, 49.957>, <6.4697, 93.7776, 47.4588> }
				triangle { <6.5751, 92.8214, 46.4159>, <6.6008, 93.9053, 47.3614>, <6.4697, 93.7776, 47.4588> }
				triangle { <6.5751, 92.8214, 46.4159>, <6.4697, 93.7776, 47.4588>, <6.4687, 92.7077, 46.4953> }
				triangle { <6.5751, 92.8214, 46.4159>, <6.4687, 92.7077, 46.4953>, <6.1646, 91.1741, 44.5039> }
				triangle { <5.8369, 99.6581, 51.2548>, <6.2987, 97.6726, 49.957>, <6.4069, 97.8696, 49.757> }
				triangle { <6.4697, 93.7776, 47.4588>, <6.2987, 97.6726, 49.957>, <5.9831, 97.5596, 50.1275> }
				triangle { <6.7265, 94.01103, 47.2392>, <6.4069, 97.8696, 49.757>, <6.2987, 97.6726, 49.957> }
				triangle { <5.8369, 99.6581, 51.2548>, <5.9831, 97.5596, 50.1275>, <6.2987, 97.6726, 49.957> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.04047, 11.1821, -0.8238>, 0.19 }
			cylinder { <-0.04047, 11.1821, -0.8238>, <-0.1212, 22.2733, -2.467>, 0.19 }
			cylinder { <-0.1212, 22.2733, -2.467>, <-0.2417, 33.2134, -4.9208>, 0.19 }
			cylinder { <-0.2417, 33.2134, -4.9208>, <-0.4014, 43.9431, -8.1717>, 0.19 }
			cylinder { <-0.4014, 43.9431, -8.1717>, <-0.5994, 54.4043, -12.2022>, 0.19 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.5994, 54.4043, -12.2022>, <-0.6436, 56.5797, -13.1021>, 0.19 }
				cylinder { <-0.6436, 56.5797, -13.1021>, <-0.6904, 58.7324, -14.05523>, 0.19 }
				cylinder { <-0.6904, 58.7324, -14.05523>, <-0.7398, 60.8609, -15.06076>, 0.19 }
				cylinder { <-0.7398, 60.8609, -15.06076>, <-0.7918, 62.9641, -16.1181>, 0.19 }
				cylinder { <-0.7918, 62.9641, -16.1181>, <-0.8462, 65.04078, -17.2267>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.8462, 65.04078, -17.2267>, <-0.97, 65.5962, -17.5179>, 0.01083 }
				cylinder { <-0.97, 65.5962, -17.5179>, <-1.199, 66.127, -17.7907>, 0.01083 }
				cylinder { <-1.199, 66.127, -17.7907>, <-1.5266, 66.6176, -18.03721>, 0.01083 }
				cylinder { <-1.5266, 66.6176, -18.03721>, <-1.9431, 67.05341, -18.2499>, 0.01083 }
				cylinder { <-1.9431, 67.05341, -18.2499>, <-2.4362, 67.4216, -18.4228>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.4362, 67.4216, -18.4228>, <-4.4224, 68.9342, -18.811>, <-4.4086, 68.945, -18.9944> }
				triangle { <-4.4224, 68.9342, -18.811>, <-5.426, 69.9845, -19.00415>, <-4.4086, 68.945, -18.9944> }
				triangle { <-5.426, 69.9845, -19.00415>, <-5.3559, 70.00891, -19.1948>, <-4.4086, 68.945, -18.9944> }
				triangle { <-5.426, 69.9845, -19.00415>, <-7.9859, 73.7552, -19.4574>, <-5.3559, 70.00891, -19.1948> }
				triangle { <-5.3559, 70.00891, -19.1948>, <-7.9859, 73.7552, -19.4574>, <-5.2599, 70.01297, -19.3786> }
				triangle { <-4.4086, 68.945, -18.9944>, <-5.3559, 70.00891, -19.1948>, <-5.2599, 70.01297, -19.3786> }
				triangle { <-4.4086, 68.945, -18.9944>, <-5.2599, 70.01297, -19.3786>, <-4.3269, 68.9407, -19.1489> }
				triangle { <-4.4086, 68.945, -18.9944>, <-4.3269, 68.9407, -19.1489>, <-2.4362, 67.4216, -18.4228> }
				triangle { <-9.1076, 75.8884, -19.6328>, <-7.9859, 73.7552, -19.4574>, <-8.03684, 73.7908, -19.163> }
				triangle { <-5.2599, 70.01297, -19.3786>, <-7.9859, 73.7552, -19.4574>, <-7.7964, 73.8977, -19.7493> }
				triangle { <-5.426, 69.9845, -19.00415>, <-8.03684, 73.7908, -19.163>, <-7.9859, 73.7552, -19.4574> }
				triangle { <-9.1076, 75.8884, -19.6328>, <-7.7964, 73.8977, -19.7493>, <-7.9859, 73.7552, -19.4574> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.8462, 65.04078, -17.2267>, <-0.9633, 67.05979, -18.4326>, 0.19 }
				cylinder { <-0.9633, 67.05979, -18.4326>, <-1.1424, 69.01512, -19.7322>, 0.19 }
				cylinder { <-1.1424, 69.01512, -19.7322>, <-1.3832, 70.9008, -21.1216>, 0.19 }
				cylinder { <-1.3832, 70.9008, -21.1216>, <-1.6846, 72.7113, -22.5966>, 0.19 }
				cylinder { <-1.6846, 72.7113, -22.5966>, <-2.04587, 74.441, -24.1528>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-2.04587, 74.441, -24.1528>, <-2.0502, 74.915, -24.5817>, 0.01083 }
				cylinder { <-2.0502, 74.915, -24.5817>, <-1.9607, 75.3832, -25.00768>, 0.01083 }
				cylinder { <-1.9607, 75.3832, -25.00768>, <-1.7793, 75.8355, -25.4214>, 0.01083 }
				cylinder { <-1.7793, 75.8355, -25.4214>, <-1.5099, 76.262, -25.8141>, 0.01083 }
				cylinder { <-1.5099, 76.262, -25.8141>, <-1.1585, 76.6535, -26.1771>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-1.1585, 76.6535, -26.1771>, <0.1424, 78.423, -27.4262>, <0.2372, 78.3096, -27.5362> }
				triangle { <0.1424, 78.423, -27.4262>, <1.05101, 79.4304, -27.9806>, <0.2372, 78.3096, -27.5362> }
				triangle { <1.05101, 79.4304, -27.9806>, <1.1671, 79.2781, -28.05277>, <0.2372, 78.3096, -27.5362> }
				triangle { <1.05101, 79.4304, -27.9806>, <4.3144, 82.4487, -29.08355>, <1.1671, 79.2781, -28.05277> }
				triangle { <1.1671, 79.2781, -28.05277>, <4.3144, 82.4487, -29.08355>, <1.2649, 79.1037, -28.1074> }
				triangle { <0.2372, 78.3096, -27.5362>, <1.1671, 79.2781, -28.05277>, <1.2649, 79.1037, -28.1074> }
				triangle { <0.2372, 78.3096, -27.5362>, <1.2649, 79.1037, -28.1074>, <0.3128, 78.1593, -27.5835> }
				triangle { <0.2372, 78.3096, -27.5362>, <0.3128, 78.1593, -27.5835>, <-1.1585, 76.6535, -26.1771> }
				triangle { <6.1586, 83.9724, -29.4257>, <4.3144, 82.4487, -29.08355>, <4.206, 82.6717, -28.9132> }
				triangle { <1.2649, 79.1037, -28.1074>, <4.3144, 82.4487, -29.08355>, <4.5939, 82.1983, -29.1091> }
				triangle { <1.05101, 79.4304, -27.9806>, <4.206, 82.6717, -28.9132>, <4.3144, 82.4487, -29.08355> }
				triangle { <6.1586, 83.9724, -29.4257>, <4.5939, 82.1983, -29.1091>, <4.3144, 82.4487, -29.08355> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-2.04587, 74.441, -24.1528>, <-2.4657, 76.08476, -25.7857>, 0.19 }
				cylinder { <-2.4657, 76.08476, -25.7857>, <-2.9428, 77.6375, -27.4902>, 0.19 }
				cylinder { <-2.9428, 77.6375, -27.4902>, <-3.4757, 79.09473, -29.2614>, 0.19 }
				cylinder { <-3.4757, 79.09473, -29.2614>, <-4.06269, 80.4518, -31.09389>, 0.19 }
				cylinder { <-4.06269, 80.4518, -31.09389>, <-4.7019, 81.7048, -32.9821>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.7019, 81.7048, -32.9821>, <-4.978, 82.02014, -33.4649>, 0.01083 }
				cylinder { <-4.978, 82.02014, -33.4649>, <-5.3485, 82.3012, -33.9034>, 0.01083 }
				cylinder { <-5.3485, 82.3012, -33.9034>, <-5.8026, 82.5398, -34.2849>, 0.01083 }
				cylinder { <-5.8026, 82.5398, -34.2849>, <-6.3267, 82.729, -34.5982>, 0.01083 }
				cylinder { <-6.3267, 82.729, -34.5982>, <-6.9056, 82.8631, -34.8339>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-6.9056, 82.8631, -34.8339>, <-9.23, 83.5728, -35.5247>, <-9.2282, 83.4989, -35.6935> }
				triangle { <-9.23, 83.5728, -35.5247>, <-10.4778, 84.1786, -35.9977>, <-9.2282, 83.4989, -35.6935> }
				triangle { <-10.4778, 84.1786, -35.9977>, <-10.4256, 84.1245, -36.188>, <-9.2282, 83.4989, -35.6935> }
				triangle { <-10.4778, 84.1786, -35.9977>, <-13.9391, 86.68, -37.6527>, <-10.4256, 84.1245, -36.188> }
				triangle { <-10.4256, 84.1245, -36.188>, <-13.9391, 86.68, -37.6527>, <-10.3428, 84.06158, -36.3674> }
				triangle { <-9.2282, 83.4989, -35.6935>, <-10.4256, 84.1245, -36.188>, <-10.3428, 84.06158, -36.3674> }
				triangle { <-9.2282, 83.4989, -35.6935>, <-10.3428, 84.06158, -36.3674>, <-9.1558, 83.4396, -35.841> }
				triangle { <-9.2282, 83.4989, -35.6935>, <-9.1558, 83.4396, -35.841>, <-6.9056, 82.8631, -34.8339> }
				triangle { <-15.5782, 88.2002, -38.5705>, <-13.9391, 86.68, -37.6527>, <-13.9832, 86.8382, -37.4006> }
				triangle { <-10.3428, 84.06158, -36.3674>, <-13.9391, 86.68, -37.6527>, <-13.8068, 86.7044, -38.00399> }
				triangle { <-10.4778, 84.1786, -35.9977>, <-13.9832, 86.8382, -37.4006>, <-13.9391, 86.68, -37.6527> }
				triangle { <-15.5782, 88.2002, -38.5705>, <-13.8068, 86.7044, -38.00399>, <-13.9391, 86.68, -37.6527> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.7019, 81.7048, -32.9821>, <-5.2854, 82.968, -34.8817>, 0.19 }
				cylinder { <-5.2854, 82.968, -34.8817>, <-5.8128, 84.2405, -36.7914>, 0.19 }
				cylinder { <-5.8128, 84.2405, -36.7914>, <-6.2837, 85.5216, -38.71>, 0.19 }
				cylinder { <-6.2837, 85.5216, -38.71>, <-6.6979, 86.8106, -40.6365>, 0.19 }
				cylinder { <-6.6979, 86.8106, -40.6365>, <-7.0552, 88.1066, -42.5696>, 0.19 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-7.0552, 88.1066, -42.5696>, <-7.04282, 88.4659, -43.09823>, 0.01083 }
				cylinder { <-7.04282, 88.4659, -43.09823>, <-6.9214, 88.8221, -43.615>, 0.01083 }
				cylinder { <-6.9214, 88.8221, -43.615>, <-6.6945, 89.1646, -44.1047>, 0.01083 }
				cylinder { <-6.6945, 89.1646, -44.1047>, <-6.3689, 89.4834, -44.553>, 0.01083 }
				cylinder { <-6.3689, 89.4834, -44.553>, <-5.9542, 89.7692, -44.9467>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.9542, 89.7692, -44.9467>, <-4.4132, 91.1603, -46.3869>, <-4.3118, 91.0218, -46.4539> }
				triangle { <-4.4132, 91.1603, -46.3869>, <-3.389, 91.9854, -47.03334>, <-4.3118, 91.0218, -46.4539> }
				triangle { <-3.389, 91.9854, -47.03334>, <-3.2734, 91.8176, -47.05202>, <-4.3118, 91.0218, -46.4539> }
				triangle { <-3.389, 91.9854, -47.03334>, <0.1466, 94.5767, -48.3601>, <-3.2734, 91.8176, -47.05202> }
				triangle { <-3.2734, 91.8176, -47.05202>, <0.1466, 94.5767, -48.3601>, <-3.1793, 91.6328, -47.05121> }
				triangle { <-4.3118, 91.0218, -46.4539>, <-3.2734, 91.8176, -47.05202>, <-3.1793, 91.6328, -47.05121> }
				triangle { <-4.3118, 91.0218, -46.4539>, <-3.1793, 91.6328, -47.05121>, <-4.2394, 90.8627, -46.4545> }
				triangle { <-4.3118, 91.0218, -46.4539>, <-4.2394, 90.8627, -46.4545>, <-5.9542, 89.7692, -44.9467> }
				triangle { <2.09972, 95.9311, -48.7969>, <0.1466, 94.5767, -48.3601>, <0.03022, 94.8363, -48.2622> }
				triangle { <-3.1793, 91.6328, -47.05121>, <0.1466, 94.5767, -48.3601>, <0.4129, 94.3208, -48.2894> }
				triangle { <-3.389, 91.9854, -47.03334>, <0.03022, 94.8363, -48.2622>, <0.1466, 94.5767, -48.3601> }
				triangle { <2.09972, 95.9311, -48.7969>, <0.4129, 94.3208, -48.2894>, <0.1466, 94.5767, -48.3601> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-7.0552, 88.1066, -42.5696>, <-7.1676, 88.4566, -43.09266>, 0.01083 }
				cylinder { <-7.1676, 88.4566, -43.09266>, <-7.2955, 88.8044, -43.6135>, 0.01083 }
				cylinder { <-7.2955, 88.8044, -43.6135>, <-7.4386, 89.1499, -44.132>, 0.01083 }
				cylinder { <-7.4386, 89.1499, -44.132>, <-7.5971, 89.4928, -44.6477>, 0.01083 }
				cylinder { <-7.5971, 89.4928, -44.6477>, <-7.7706, 89.833, -45.1603>, 0.01083 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.7706, 89.833, -45.1603>, <-8.5584, 91.3854, -46.9915>, <-8.4809, 91.2964, -47.1331> }
				triangle { <-8.5584, 91.3854, -46.9915>, <-8.8234, 92.4053, -48.00996>, <-8.4809, 91.2964, -47.1331> }
				triangle { <-8.8234, 92.4053, -48.00996>, <-8.6912, 92.3091, -48.1329>, <-8.4809, 91.2964, -47.1331> }
				triangle { <-8.8234, 92.4053, -48.00996>, <-9.001339, 95.9198, -50.9414>, <-8.6912, 92.3091, -48.1329> }
				triangle { <-8.6912, 92.3091, -48.1329>, <-9.001339, 95.9198, -50.9414>, <-8.5496, 92.1931, -48.2304> }
				triangle { <-8.4809, 91.2964, -47.1331>, <-8.6912, 92.3091, -48.1329>, <-8.5496, 92.1931, -48.2304> }
				triangle { <-8.4809, 91.2964, -47.1331>, <-8.5496, 92.1931, -48.2304>, <-8.3647, 91.1924, -47.2119> }
				triangle { <-8.4809, 91.2964, -47.1331>, <-8.3647, 91.1924, -47.2119>, <-7.7706, 89.833, -45.1603> }
				triangle { <-8.8616, 97.865, -52.3683>, <-9.001339, 95.9198, -50.9414>, <-9.1243, 96.1133, -50.7466> }
				triangle { <-8.5496, 92.1931, -48.2304>, <-9.001339, 95.9198, -50.9414>, <-8.6823, 95.8372, -51.1227> }
				triangle { <-8.8234, 92.4053, -48.00996>, <-9.1243, 96.1133, -50.7466>, <-9.001339, 95.9198, -50.9414> }
				triangle { <-8.8616, 97.865, -52.3683>, <-8.6823, 95.8372, -51.1227>, <-9.001339, 95.9198, -50.9414> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.002136, 0.8864, -0.04349>, 0.01504 }
			cylinder { <-0.002136, 0.8864, -0.04349>, <-0.006405, 1.7696, -0.1303>, 0.01504 }
			cylinder { <-0.006405, 1.7696, -0.1303>, <-0.01279, 2.6474, -0.2604>, 0.01504 }
			cylinder { <-0.01279, 2.6474, -0.2604>, <-0.02129, 3.5179, -0.4333>, 0.01504 }
			cylinder { <-0.02129, 3.5179, -0.4333>, <-0.03187, 4.3787, -0.6487>, 0.01504 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.03187, 4.3787, -0.6487>, <-0.03409, 4.5595, -0.6939>, 0.01504 }
				cylinder { <-0.03409, 4.5595, -0.6939>, <-0.03631, 4.7403, -0.7392>, 0.01504 }
				cylinder { <-0.03631, 4.7403, -0.7392>, <-0.03853, 4.9211, -0.7844>, 0.01504 }
				cylinder { <-0.03853, 4.9211, -0.7844>, <-0.04075, 5.1019, -0.8296>, 0.01504 }
				cylinder { <-0.04075, 5.1019, -0.8296>, <-0.04298, 5.2827, -0.8748>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.04298, 5.2827, -0.8748>, <-0.04361, 5.2865, -0.8758>, 0.00006788 }
				cylinder { <-0.04361, 5.2865, -0.8758>, <-0.04482, 5.2902, -0.8767>, 0.00006788 }
				cylinder { <-0.04482, 5.2902, -0.8767>, <-0.04657, 5.2937, -0.8774>, 0.00006788 }
				cylinder { <-0.04657, 5.2937, -0.8774>, <-0.04883, 5.297, -0.8781>, 0.00006788 }
				cylinder { <-0.04883, 5.297, -0.8781>, <-0.05155, 5.2998, -0.8787>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.04298, 5.2827, -0.8748>, <-0.04041, 5.4644, -0.9158>, 0.01504 }
				cylinder { <-0.04041, 5.4644, -0.9158>, <-0.03307, 5.647, -0.9526>, 0.01504 }
				cylinder { <-0.03307, 5.647, -0.9526>, <-0.02095, 5.8302, -0.9849>, 0.01504 }
				cylinder { <-0.02095, 5.8302, -0.9849>, <-0.004082, 6.01368, -1.01299>, 0.01504 }
				cylinder { <-0.004082, 6.01368, -1.01299>, <0.01752, 6.1972, -1.03659>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.01752, 6.1972, -1.03659>, <0.01866, 6.201, -1.03711>, 0.00006788 }
				cylinder { <0.01866, 6.201, -1.03711>, <0.02043, 6.2046, -1.03762>, 0.00006788 }
				cylinder { <0.02043, 6.2046, -1.03762>, <0.02279, 6.2078, -1.03811>, 0.00006788 }
				cylinder { <0.02279, 6.2078, -1.03811>, <0.02567, 6.2105, -1.03856>, 0.00006788 }
				cylinder { <0.02567, 6.2105, -1.03856>, <0.02899, 6.2127, -1.03897>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <0.01752, 6.1972, -1.03659>, <0.03894, 6.3802, -1.06472>, 0.01504 }
				cylinder { <0.03894, 6.3802, -1.06472>, <0.06015, 6.5625, -1.09736>, 0.01504 }
				cylinder { <0.06015, 6.5625, -1.09736>, <0.08116, 6.7439, -1.1345>, 0.01504 }
				cylinder { <0.08116, 6.7439, -1.1345>, <0.1019, 6.9244, -1.1761>, 0.01504 }
				cylinder { <0.1019, 6.9244, -1.1761>, <0.1224, 7.1038, -1.2221>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.1224, 7.1038, -1.2221>, <0.1222, 7.1077, -1.2231>, 0.00006788 }
				cylinder { <0.1222, 7.1077, -1.2231>, <0.1213, 7.1115, -1.224>, 0.00006788 }
				cylinder { <0.1213, 7.1115, -1.224>, <0.1197, 7.1151, -1.2248>, 0.00006788 }
				cylinder { <0.1197, 7.1151, -1.2248>, <0.1175, 7.1183, -1.2255>, 0.00006788 }
				cylinder { <0.1175, 7.1183, -1.2255>, <0.1148, 7.1212, -1.226>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <0.1224, 7.1038, -1.2221>, <0.1427, 7.2821, -1.2726>, 0.01504 }
				cylinder { <0.1427, 7.2821, -1.2726>, <0.1627, 7.459, -1.3274>, 0.01504 }
				cylinder { <0.1627, 7.459, -1.3274>, <0.1825, 7.6346, -1.3866>, 0.01504 }
				cylinder { <0.1825, 7.6346, -1.3866>, <0.2019, 7.8088, -1.4501>, 0.01504 }
				cylinder { <0.2019, 7.8088, -1.4501>, <0.2211, 7.9813, -1.5179>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.2211, 7.9813, -1.5179>, <0.2221, 7.9849, -1.5194>, 0.00006788 }
				cylinder { <0.2221, 7.9849, -1.5194>, <0.2236, 7.9883, -1.5208>, 0.00006788 }
				cylinder { <0.2236, 7.9883, -1.5208>, <0.2257, 7.9915, -1.5222>, 0.00006788 }
				cylinder { <0.2257, 7.9915, -1.5222>, <0.2283, 7.9943, -1.5235>, 0.00006788 }
				cylinder { <0.2283, 7.9943, -1.5235>, <0.2312, 7.9967, -1.5246>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.2211, 7.9813, -1.5179>, <0.2215, 7.985, -1.5194>, 0.00006788 }
				cylinder { <0.2215, 7.985, -1.5194>, <0.2219, 7.9887, -1.5209>, 0.00006788 }
				cylinder { <0.2219, 7.9887, -1.5209>, <0.2223, 7.9924, -1.5223>, 0.00006788 }
				cylinder { <0.2223, 7.9924, -1.5223>, <0.2228, 7.9961, -1.5238>, 0.00006788 }
				cylinder { <0.2228, 7.9961, -1.5238>, <0.2232, 7.9999, -1.5252>, 0.00006788 }
				texture{Grass_Texture4}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.002136, 0.8864, 0.04349>, 0.01504 }
			cylinder { <0.002136, 0.8864, 0.04349>, <0.006405, 1.7696, 0.1303>, 0.01504 }
			cylinder { <0.006405, 1.7696, 0.1303>, <0.01279, 2.6474, 0.2604>, 0.01504 }
			cylinder { <0.01279, 2.6474, 0.2604>, <0.02129, 3.5179, 0.4333>, 0.01504 }
			cylinder { <0.02129, 3.5179, 0.4333>, <0.03187, 4.3787, 0.6487>, 0.01504 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.03187, 4.3787, 0.6487>, <0.03431, 4.5584, 0.6983>, 0.01504 }
				cylinder { <0.03431, 4.5584, 0.6983>, <0.03696, 4.7367, 0.7524>, 0.01504 }
				cylinder { <0.03696, 4.7367, 0.7524>, <0.03983, 4.9137, 0.8108>, 0.01504 }
				cylinder { <0.03983, 4.9137, 0.8108>, <0.04291, 5.08918, 0.8735>, 0.01504 }
				cylinder { <0.04291, 5.08918, 0.8735>, <0.0462, 5.263, 0.9405>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.0462, 5.263, 0.9405>, <0.04695, 5.2667, 0.9419>, 0.00006788 }
				cylinder { <0.04695, 5.2667, 0.9419>, <0.04837, 5.2702, 0.9431>, 0.00006788 }
				cylinder { <0.04837, 5.2702, 0.9431>, <0.0504, 5.2735, 0.9443>, 0.00006788 }
				cylinder { <0.0504, 5.2735, 0.9443>, <0.05299, 5.2764, 0.9453>, 0.00006788 }
				cylinder { <0.05299, 5.2764, 0.9453>, <0.05607, 5.2788, 0.9461>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <0.0462, 5.263, 0.9405>, <0.04471, 5.4384, 1.00344>, 0.01504 }
				cylinder { <0.04471, 5.4384, 1.00344>, <0.03845, 5.6152, 1.0622>, 0.01504 }
				cylinder { <0.03845, 5.6152, 1.0622>, <0.02742, 5.7931, 1.1167>, 0.01504 }
				cylinder { <0.02742, 5.7931, 1.1167>, <0.01164, 5.9718, 1.1669>, 0.01504 }
				cylinder { <0.01164, 5.9718, 1.1669>, <-0.008864, 6.1513, 1.2128>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.008864, 6.1513, 1.2128>, <-0.009978, 6.155, 1.2138>, 0.00006788 }
				cylinder { <-0.009978, 6.155, 1.2138>, <-0.01173, 6.1585, 1.2147>, 0.00006788 }
				cylinder { <-0.01173, 6.1585, 1.2147>, <-0.01407, 6.1616, 1.2156>, 0.00006788 }
				cylinder { <-0.01407, 6.1616, 1.2156>, <-0.01694, 6.1643, 1.2164>, 0.00006788 }
				cylinder { <-0.01694, 6.1643, 1.2164>, <-0.02024, 6.1665, 1.2171>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.008864, 6.1513, 1.2128>, <-0.02937, 6.3308, 1.2587>, 0.01504 }
				cylinder { <-0.02937, 6.3308, 1.2587>, <-0.04988, 6.5102, 1.3046>, 0.01504 }
				cylinder { <-0.04988, 6.5102, 1.3046>, <-0.07039, 6.6897, 1.3504>, 0.01504 }
				cylinder { <-0.07039, 6.6897, 1.3504>, <-0.09091, 6.8692, 1.3963>, 0.01504 }
				cylinder { <-0.09091, 6.8692, 1.3963>, <-0.1114, 7.04869, 1.4422>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.1114, 7.04869, 1.4422>, <-0.1112, 7.05257, 1.4432>, 0.00006788 }
				cylinder { <-0.1112, 7.05257, 1.4432>, <-0.1105, 7.05639, 1.4441>, 0.00006788 }
				cylinder { <-0.1105, 7.05639, 1.4441>, <-0.1092, 7.06008, 1.445>, 0.00006788 }
				cylinder { <-0.1092, 7.06008, 1.445>, <-0.1073, 7.06355, 1.4458>, 0.00006788 }
				cylinder { <-0.1073, 7.06355, 1.4458>, <-0.105, 7.06672, 1.4465>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.1114, 7.04869, 1.4422>, <-0.1319, 7.2281, 1.4881>, 0.01504 }
				cylinder { <-0.1319, 7.2281, 1.4881>, <-0.1524, 7.4076, 1.534>, 0.01504 }
				cylinder { <-0.1524, 7.4076, 1.534>, <-0.1729, 7.587, 1.5799>, 0.01504 }
				cylinder { <-0.1729, 7.587, 1.5799>, <-0.1934, 7.7665, 1.6257>, 0.01504 }
				cylinder { <-0.1934, 7.7665, 1.6257>, <-0.2139, 7.946, 1.6716>, 0.01504 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.2139, 7.946, 1.6716>, <-0.215, 7.9497, 1.6726>, 0.00006788 }
				cylinder { <-0.215, 7.9497, 1.6726>, <-0.2168, 7.9532, 1.6735>, 0.00006788 }
				cylinder { <-0.2168, 7.9532, 1.6735>, <-0.2191, 7.9563, 1.6744>, 0.00006788 }
				cylinder { <-0.2191, 7.9563, 1.6744>, <-0.222, 7.959, 1.6752>, 0.00006788 }
				cylinder { <-0.222, 7.959, 1.6752>, <-0.2253, 7.9611, 1.6759>, 0.00006788 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.2139, 7.946, 1.6716>, <-0.2143, 7.9498, 1.6726>, 0.00006788 }
				cylinder { <-0.2143, 7.9498, 1.6726>, <-0.2145, 7.9537, 1.6736>, 0.00006788 }
				cylinder { <-0.2145, 7.9537, 1.6736>, <-0.2147, 7.9576, 1.6746>, 0.00006788 }
				cylinder { <-0.2147, 7.9576, 1.6746>, <-0.2147, 7.9615, 1.6755>, 0.00006788 }
				cylinder { <-0.2147, 7.9615, 1.6755>, <-0.2147, 7.9654, 1.6765>, 0.00006788 }
				texture{Grass_Texture4}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 15.8924, 0.0>, 0.2172 }
			cylinder { <-0.0, 15.8924, 0.0>, <-0.00000001, 31.7849, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 31.7849, 0.0>, <-0.00000001, 47.6774, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 47.6774, 0.0>, <-0.00000001, 63.5699, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 63.5699, 0.0>, <-0.00000002, 79.4624, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <0.002437, 80.1797, 0.02478>, 0.2172 }
			cylinder { <0.002437, 80.1797, 0.02478>, <0.007302, 80.8957, 0.07433>, 0.2172 }
			cylinder { <0.007302, 80.8957, 0.07433>, <0.01458, 81.6095, 0.1485>, 0.2172 }
			cylinder { <0.01458, 81.6095, 0.1485>, <0.02425, 82.3204, 0.2474>, 0.2172 }
			cylinder { <0.02425, 82.3204, 0.2474>, <0.03631, 83.02736, 0.3707>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.03631, 83.02736, 0.3707>, <0.05072, 83.7295, 0.5184>, 0.2172 }
			cylinder { <0.05072, 83.7295, 0.5184>, <0.06746, 84.4262, 0.6903>, 0.2172 }
			cylinder { <0.06746, 84.4262, 0.6903>, <0.0865, 85.1164, 0.8861>, 0.2172 }
			cylinder { <0.0865, 85.1164, 0.8861>, <0.1078, 85.7994, 1.1056>, 0.2172 }
			cylinder { <0.1078, 85.7994, 1.1056>, <0.1313, 86.4743, 1.3486>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.1313, 86.4743, 1.3486>, <0.1571, 87.1404, 1.6148>, 0.2172 }
			cylinder { <0.1571, 87.1404, 1.6148>, <0.185, 87.7967, 1.9038>, 0.2172 }
			cylinder { <0.185, 87.7967, 1.9038>, <0.2151, 88.4426, 2.2153>, 0.2172 }
			cylinder { <0.2151, 88.4426, 2.2153>, <0.2472, 89.07732, 2.549>, 0.2172 }
			cylinder { <0.2472, 89.07732, 2.549>, <0.2814, 89.6999, 2.9043>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.2814, 89.6999, 2.9043>, <0.3176, 90.3098, 3.281>, 0.2172 }
			cylinder { <0.3176, 90.3098, 3.281>, <0.3557, 90.9062, 3.6785>, 0.2172 }
			cylinder { <0.3557, 90.9062, 3.6785>, <0.3956, 91.4883, 4.09645>, 0.2172 }
			cylinder { <0.3956, 91.4883, 4.09645>, <0.4374, 92.0556, 4.5342>, 0.2172 }
			cylinder { <0.4374, 92.0556, 4.5342>, <0.481, 92.6072, 4.9912>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.481, 92.6072, 4.9912>, <0.5399, 93.1703, 5.4324>, 0.2172 }
			cylinder { <0.5399, 93.1703, 5.4324>, <0.6141, 93.7441, 5.8571>, 0.2172 }
			cylinder { <0.6141, 93.7441, 5.8571>, <0.7035, 94.328, 6.2647>, 0.2172 }
			cylinder { <0.7035, 94.328, 6.2647>, <0.808, 94.9212, 6.655>, 0.2172 }
			cylinder { <0.808, 94.9212, 6.655>, <0.9274, 95.5231, 7.02729>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9274, 95.5231, 7.02729>, <1.6521, 98.3455, 8.747>, 0.2172 }
				cylinder { <1.6521, 98.3455, 8.747>, <2.5366, 101.146, 10.4273>, 0.2172 }
				cylinder { <2.5366, 101.146, 10.4273>, <3.5789, 103.9178, 12.06421>, 0.2172 }
				cylinder { <3.5789, 103.9178, 12.06421>, <4.7763, 106.6543, 13.6536>, 0.2172 }
				cylinder { <4.7763, 106.6543, 13.6536>, <6.126, 109.3489, 15.1917>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <6.126, 109.3489, 15.1917>, <6.4476, 109.9476, 15.6645>, <6.3814, 110.0108, 15.6492> }
					triangle { <6.4476, 109.9476, 15.6645>, <6.5558, 110.2836, 15.9589>, <6.3814, 110.0108, 15.6492> }
					triangle { <6.5558, 110.2836, 15.9589>, <6.4827, 110.3533, 15.9383>, <6.3814, 110.0108, 15.6492> }
					triangle { <6.5558, 110.2836, 15.9589>, <6.6273, 110.8516, 16.34>, <6.4827, 110.3533, 15.9383> }
					triangle { <6.4827, 110.3533, 15.9383>, <6.6273, 110.8516, 16.34>, <6.4302, 110.4012, 15.8636> }
					triangle { <6.3814, 110.0108, 15.6492>, <6.4827, 110.3533, 15.9383>, <6.4302, 110.4012, 15.8636> }
					triangle { <6.3814, 110.0108, 15.6492>, <6.4302, 110.4012, 15.8636>, <6.328, 110.0493, 15.5867> }
					triangle { <6.3814, 110.0108, 15.6492>, <6.328, 110.0493, 15.5867>, <6.126, 109.3489, 15.1917> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9274, 95.5231, 7.02729>, <1.02269, 96.1257, 7.4053>, 0.2172 }
			cylinder { <1.02269, 96.1257, 7.4053>, <1.09357, 96.7284, 7.7886>, 0.2172 }
			cylinder { <1.09357, 96.7284, 7.7886>, <1.14, 97.3303, 8.1768>, 0.2172 }
			cylinder { <1.14, 97.3303, 8.1768>, <1.162, 97.9307, 8.5693>, 0.2172 }
			cylinder { <1.162, 97.9307, 8.5693>, <1.1594, 98.5291, 8.9657>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.1594, 98.5291, 8.9657>, <1.01117, 101.3983, 10.753>, 0.2172 }
				cylinder { <1.01117, 101.3983, 10.753>, <0.7268, 104.3091, 12.4545>, 0.2172 }
				cylinder { <0.7268, 104.3091, 12.4545>, <0.3072, 107.2544, 14.06616>, 0.2172 }
				cylinder { <0.3072, 107.2544, 14.06616>, <-0.2465, 110.2272, 15.584>, 0.2172 }
				cylinder { <-0.2465, 110.2272, 15.584>, <-0.9334, 113.2204, 17.00447>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.9334, 113.2204, 17.00447>, <-1.184, 113.919, 17.2713>, <-1.1548, 113.9099, 17.3542> }
					triangle { <-1.184, 113.919, 17.2713>, <-1.2543, 114.3151, 17.4442>, <-1.1548, 113.9099, 17.3542> }
					triangle { <-1.2543, 114.3151, 17.4442>, <-1.2235, 114.3019, 17.5365>, <-1.1548, 113.9099, 17.3542> }
					triangle { <-1.2543, 114.3151, 17.4442>, <-1.3285, 114.8556, 17.8069>, <-1.2235, 114.3019, 17.5365> }
					triangle { <-1.2235, 114.3019, 17.5365>, <-1.3285, 114.8556, 17.8069>, <-1.2244, 114.2414, 17.6139> }
					triangle { <-1.1548, 113.9099, 17.3542>, <-1.2235, 114.3019, 17.5365>, <-1.2244, 114.2414, 17.6139> }
					triangle { <-1.1548, 113.9099, 17.3542>, <-1.2244, 114.2414, 17.6139>, <-1.1474, 113.8561, 17.4215> }
					triangle { <-1.1548, 113.9099, 17.3542>, <-1.1474, 113.8561, 17.4215>, <-0.9334, 113.2204, 17.00447> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.1594, 98.5291, 8.9657>, <1.178, 99.1198, 9.3729>, 0.2172 }
			cylinder { <1.178, 99.1198, 9.3729>, <1.2177, 99.7022, 9.7904>, 0.2172 }
			cylinder { <1.2177, 99.7022, 9.7904>, <1.2785, 100.2757, 10.2178>, 0.2172 }
			cylinder { <1.2785, 100.2757, 10.2178>, <1.3602, 100.8395, 10.6544>, 0.2172 }
			cylinder { <1.3602, 100.8395, 10.6544>, <1.4628, 101.3928, 11.09985>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.4628, 101.3928, 11.09985>, <1.9816, 103.8928, 13.3201>, 0.2172 }
				cylinder { <1.9816, 103.8928, 13.3201>, <2.5343, 106.2779, 15.6555>, 0.2172 }
				cylinder { <2.5343, 106.2779, 15.6555>, <3.1196, 108.5425, 18.1004>, 0.2172 }
				cylinder { <3.1196, 108.5425, 18.1004>, <3.7361, 110.6811, 20.6489>, 0.2172 }
				cylinder { <3.7361, 110.6811, 20.6489>, <4.3824, 112.6885, 23.2949>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.3824, 112.6885, 23.2949>, <4.6192, 113.0001, 23.9362>, <4.6482, 113.0716, 23.9027> }
					triangle { <4.6192, 113.0001, 23.9362>, <4.7136, 113.2291, 24.2719>, <4.6482, 113.0716, 23.9027> }
					triangle { <4.7136, 113.2291, 24.2719>, <4.7476, 113.3068, 24.2324>, <4.6482, 113.0716, 23.9027> }
					triangle { <4.7136, 113.2291, 24.2719>, <4.9016, 113.6441, 24.6984>, <4.7476, 113.3068, 24.2324> }
					triangle { <4.7476, 113.3068, 24.2324>, <4.9016, 113.6441, 24.6984>, <4.8031, 113.3408, 24.1652> }
					triangle { <4.6482, 113.0716, 23.9027>, <4.7476, 113.3068, 24.2324>, <4.8031, 113.3408, 24.1652> }
					triangle { <4.6482, 113.0716, 23.9027>, <4.8031, 113.3408, 24.1652>, <4.6906, 113.105, 23.8404> }
					triangle { <4.6482, 113.0716, 23.9027>, <4.6906, 113.105, 23.8404>, <4.3824, 112.6885, 23.2949> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.4628, 101.3928, 11.09985>, <1.5587, 101.9617, 11.5268>, 0.2172 }
			cylinder { <1.5587, 101.9617, 11.5268>, <1.648, 102.5452, 11.935>, 0.2172 }
			cylinder { <1.648, 102.5452, 11.935>, <1.7305, 103.1429, 12.3237>, 0.2172 }
			cylinder { <1.7305, 103.1429, 12.3237>, <1.8061, 103.7539, 12.6926>, 0.2172 }
			cylinder { <1.8061, 103.7539, 12.6926>, <1.8747, 104.3776, 13.04121>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.8747, 104.3776, 13.04121>, <2.2766, 107.3786, 14.5514>, 0.2172 }
				cylinder { <2.2766, 107.3786, 14.5514>, <2.7562, 110.4334, 15.9251>, 0.2172 }
				cylinder { <2.7562, 110.4334, 15.9251>, <3.3123, 113.5345, 17.1588>, 0.2172 }
				cylinder { <3.3123, 113.5345, 17.1588>, <3.9435, 116.6746, 18.2496>, 0.2172 }
				cylinder { <3.9435, 116.6746, 18.2496>, <4.6483, 119.8461, 19.1949>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.6483, 119.8461, 19.1949>, <4.8521, 120.5144, 19.3493>, <4.7898, 120.533, 19.3962> }
					triangle { <4.8521, 120.5144, 19.3493>, <4.9553, 120.8679, 19.4986>, <4.7898, 120.533, 19.3962> }
					triangle { <4.9553, 120.8679, 19.4986>, <4.8841, 120.8876, 19.5485>, <4.7898, 120.533, 19.3962> }
					triangle { <4.9553, 120.8679, 19.4986>, <5.008005, 121.3983, 19.7618>, <4.8841, 120.8876, 19.5485> }
					triangle { <4.8841, 120.8876, 19.5485>, <5.008005, 121.3983, 19.7618>, <4.7951, 120.8876, 19.5519> }
					triangle { <4.7898, 120.533, 19.3962>, <4.8841, 120.8876, 19.5485>, <4.7951, 120.8876, 19.5519> }
					triangle { <4.7898, 120.533, 19.3962>, <4.7951, 120.8876, 19.5519>, <4.712, 120.5283, 19.405> }
					triangle { <4.7898, 120.533, 19.3962>, <4.712, 120.5283, 19.405>, <4.6483, 119.8461, 19.1949> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <0.01483, 80.1797, -0.02>, 0.2172 }
			cylinder { <0.01483, 80.1797, -0.02>, <0.0445, 80.8957, -0.05997>, 0.2172 }
			cylinder { <0.0445, 80.8957, -0.05997>, <0.08897, 81.6095, -0.1198>, 0.2172 }
			cylinder { <0.08897, 81.6095, -0.1198>, <0.1481, 82.3204, -0.1996>, 0.2172 }
			cylinder { <0.1481, 82.3204, -0.1996>, <0.222, 83.02736, -0.2991>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.222, 83.02736, -0.2991>, <0.4749, 83.6882, -0.4192>, 0.2172 }
			cylinder { <0.4749, 83.6882, -0.4192>, <0.7049, 84.358, -0.5357>, 0.2172 }
			cylinder { <0.7049, 84.358, -0.5357>, <0.9116, 85.03606, -0.6484>, 0.2172 }
			cylinder { <0.9116, 85.03606, -0.6484>, <1.09491, 85.7214, -0.7572>, 0.2172 }
			cylinder { <1.09491, 85.7214, -0.7572>, <1.2544, 86.4132, -0.862>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.2544, 86.4132, -0.862>, <1.8707, 89.6878, -1.4503>, 0.2172 }
				cylinder { <1.8707, 89.6878, -1.4503>, <2.3496, 92.9672, -2.1318>, 0.2172 }
				cylinder { <2.3496, 92.9672, -2.1318>, <2.6899, 96.2437, -2.9048>, 0.2172 }
				cylinder { <2.6899, 96.2437, -2.9048>, <2.8908, 99.5092, -3.7675>, 0.2172 }
				cylinder { <2.8908, 99.5092, -3.7675>, <2.9519, 102.7561, -4.7178>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <2.9519, 102.7561, -4.7178>, <3.04561, 103.5184, -5.02661>, <3.07695, 103.5583, -4.9489> }
					triangle { <3.04561, 103.5184, -5.02661>, <3.1688, 103.9379, -5.1684>, <3.07695, 103.5583, -4.9489> }
					triangle { <3.1688, 103.9379, -5.1684>, <3.2008, 103.9808, -5.08032>, <3.07695, 103.5583, -4.9489> }
					triangle { <3.1688, 103.9379, -5.1684>, <3.3693, 104.5897, -5.2575>, <3.2008, 103.9808, -5.08032> }
					triangle { <3.2008, 103.9808, -5.08032>, <3.3693, 104.5897, -5.2575>, <3.1805, 103.9931, -4.9799> }
					triangle { <3.07695, 103.5583, -4.9489>, <3.2008, 103.9808, -5.08032>, <3.1805, 103.9931, -4.9799> }
					triangle { <3.07695, 103.5583, -4.9489>, <3.1805, 103.9931, -4.9799>, <3.06661, 103.5649, -4.859> }
					triangle { <3.07695, 103.5583, -4.9489>, <3.06661, 103.5649, -4.859>, <2.9519, 102.7561, -4.7178> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.2544, 86.4132, -0.862>, <1.4348, 87.1019, -0.9534>, 0.2172 }
			cylinder { <1.4348, 87.1019, -0.9534>, <1.6357, 87.7865, -1.03135>, 0.2172 }
			cylinder { <1.6357, 87.7865, -1.03135>, <1.8569, 88.4662, -1.09574>, 0.2172 }
			cylinder { <1.8569, 88.4662, -1.09574>, <2.09823, 89.1403, -1.1464>, 0.2172 }
			cylinder { <2.09823, 89.1403, -1.1464>, <2.3592, 89.8078, -1.1835>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.3592, 89.8078, -1.1835>, <3.6222, 92.9468, -1.1954>, 0.2172 }
				cylinder { <3.6222, 92.9468, -1.1954>, <4.9145, 96.07027, -1.04467>, 0.2172 }
				cylinder { <4.9145, 96.07027, -1.04467>, <6.233, 99.1705, -0.7315>, 0.2172 }
				cylinder { <6.233, 99.1705, -0.7315>, <7.5746, 102.2403, -0.2567>, 0.2172 }
				cylinder { <7.5746, 102.2403, -0.2567>, <8.9359, 105.2721, 0.3784>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <8.9359, 105.2721, 0.3784>, <9.2689, 105.9414, 0.6297>, <9.3094, 105.9623, 0.554> }
					triangle { <9.2689, 105.9414, 0.6297>, <9.4239, 106.3432, 0.7091>, <9.3094, 105.9623, 0.554> }
					triangle { <9.4239, 106.3432, 0.7091>, <9.4703, 106.3633, 0.6249>, <9.3094, 105.9623, 0.554> }
					triangle { <9.4239, 106.3432, 0.7091>, <9.7125, 106.9312, 0.7224>, <9.4703, 106.3633, 0.6249> }
					triangle { <9.4703, 106.3633, 0.6249>, <9.7125, 106.9312, 0.7224>, <9.5299, 106.3278, 0.5553> }
					triangle { <9.3094, 105.9623, 0.554>, <9.4703, 106.3633, 0.6249>, <9.5299, 106.3278, 0.5553> }
					triangle { <9.3094, 105.9623, 0.554>, <9.5299, 106.3278, 0.5553>, <9.3556, 105.9323, 0.4874> }
					triangle { <9.3094, 105.9623, 0.554>, <9.3556, 105.9323, 0.4874>, <8.9359, 105.2721, 0.3784> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.3592, 89.8078, -1.1835>, <2.6139, 90.4761, -1.2446>, 0.2172 }
			cylinder { <2.6139, 90.4761, -1.2446>, <2.862, 91.1441, -1.3297>, 0.2172 }
			cylinder { <2.862, 91.1441, -1.3297>, <3.1031, 91.8113, -1.4388>, 0.2172 }
			cylinder { <3.1031, 91.8113, -1.4388>, <3.3371, 92.4767, -1.5716>, 0.2172 }
			cylinder { <3.3371, 92.4767, -1.5716>, <3.5635, 93.1396, -1.728>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.5635, 93.1396, -1.728>, <4.6992, 96.204, -2.6043>, 0.2172 }
				cylinder { <4.6992, 96.204, -2.6043>, <5.9005, 99.2005, -3.6173>, 0.2172 }
				cylinder { <5.9005, 99.2005, -3.6173>, <7.1644, 102.1221, -4.7645>, 0.2172 }
				cylinder { <7.1644, 102.1221, -4.7645>, <8.4878, 104.9614, -6.04329>, 0.2172 }
				cylinder { <8.4878, 104.9614, -6.04329>, <9.8676, 107.7118, -7.4504>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <9.8676, 107.7118, -7.4504>, <10.1552, 108.2331, -7.9086>, <10.1076, 108.2973, -7.8822> }
					triangle { <10.1552, 108.2331, -7.9086>, <10.3229, 108.5609, -8.1048>, <10.1076, 108.2973, -7.8822> }
					triangle { <10.3229, 108.5609, -8.1048>, <10.2673, 108.6303, -8.07593>, <10.1076, 108.2973, -7.8822> }
					triangle { <10.3229, 108.5609, -8.1048>, <10.4834, 109.1087, -8.3571>, <10.2673, 108.6303, -8.07593> }
					triangle { <10.2673, 108.6303, -8.07593>, <10.4834, 109.1087, -8.3571>, <10.1788, 108.6562, -8.05976> }
					triangle { <10.1076, 108.2973, -7.8822>, <10.2673, 108.6303, -8.07593>, <10.1788, 108.6562, -8.05976> }
					triangle { <10.1076, 108.2973, -7.8822>, <10.1788, 108.6562, -8.05976>, <10.03181, 108.321, -7.8603> }
					triangle { <10.1076, 108.2973, -7.8822>, <10.03181, 108.321, -7.8603>, <9.8676, 107.7118, -7.4504> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.5635, 93.1396, -1.728>, <3.7804, 93.8103, -1.8629>, 0.2172 }
			cylinder { <3.7804, 93.8103, -1.8629>, <3.9876, 94.4881, -1.9759>, 0.2172 }
			cylinder { <3.9876, 94.4881, -1.9759>, <4.1846, 95.1722, -2.06703>, 0.2172 }
			cylinder { <4.1846, 95.1722, -2.06703>, <4.3715, 95.8618, -2.1361>, 0.2172 }
			cylinder { <4.3715, 95.8618, -2.1361>, <4.5478, 96.5559, -2.183>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.5478, 96.5559, -2.183>, <5.2256, 99.8665, -2.3532>, 0.2172 }
				cylinder { <5.2256, 99.8665, -2.3532>, <5.7485, 103.2074, -2.4717>, 0.2172 }
				cylinder { <5.7485, 103.2074, -2.4717>, <6.1152, 106.5703, -2.5383>, 0.2172 }
				cylinder { <6.1152, 106.5703, -2.5383>, <6.3249, 109.9474, -2.5526>, 0.2172 }
				cylinder { <6.3249, 109.9474, -2.5526>, <6.3771, 113.3303, -2.5149>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <6.3771, 113.3303, -2.5149>, <6.3176, 114.0434, -2.5167>, <6.3935, 114.0596, -2.4968> }
					triangle { <6.3176, 114.0434, -2.5167>, <6.3383, 114.4381, -2.5573>, <6.3935, 114.0596, -2.4968> }
					triangle { <6.3383, 114.4381, -2.5573>, <6.4225, 114.4541, -2.5327>, <6.3935, 114.0596, -2.4968> }
					triangle { <6.3383, 114.4381, -2.5573>, <6.4681, 115.0181, -2.5723>, <6.4225, 114.4541, -2.5327> }
					triangle { <6.4225, 114.4541, -2.5327>, <6.4681, 115.0181, -2.5723>, <6.4862, 114.4349, -2.4734> }
					triangle { <6.3935, 114.0596, -2.4968>, <6.4225, 114.4541, -2.5327>, <6.4862, 114.4349, -2.4734> }
					triangle { <6.3935, 114.0596, -2.4968>, <6.4862, 114.4349, -2.4734>, <6.4536, 114.0399, -2.4503> }
					triangle { <6.3935, 114.0596, -2.4968>, <6.4536, 114.0399, -2.4503>, <6.3771, 113.3303, -2.5149> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.222, 83.02736, -0.2991>, <0.2716, 83.737, -0.3939>, 0.2172 }
			cylinder { <0.2716, 83.737, -0.3939>, <0.2968, 84.4486, -0.484>, 0.2172 }
			cylinder { <0.2968, 84.4486, -0.484>, <0.2976, 85.1613, -0.5692>, 0.2172 }
			cylinder { <0.2976, 85.1613, -0.5692>, <0.274, 85.8741, -0.6494>, 0.2172 }
			cylinder { <0.274, 85.8741, -0.6494>, <0.226, 86.5863, -0.7246>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.226, 86.5863, -0.7246>, <0.02701, 87.2535, -0.8985>, 0.2172 }
			cylinder { <0.02701, 87.2535, -0.8985>, <-0.1516, 87.9294, -1.06104>, 0.2172 }
			cylinder { <-0.1516, 87.9294, -1.06104>, <-0.3098, 88.6131, -1.2117>, 0.2172 }
			cylinder { <-0.3098, 88.6131, -1.2117>, <-0.4472, 89.3037, -1.3506>, 0.2172 }
			cylinder { <-0.4472, 89.3037, -1.3506>, <-0.5637, 90.00051, -1.4774>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.5637, 90.00051, -1.4774>, <-1.07363, 93.3164, -1.9168>, 0.2172 }
				cylinder { <-1.07363, 93.3164, -1.9168>, <-1.543, 96.6555, -2.1969>, 0.2172 }
				cylinder { <-1.543, 96.6555, -2.1969>, <-1.9709, 100.0098, -2.3168>, 0.2172 }
				cylinder { <-1.9709, 100.0098, -2.3168>, <-2.3561, 103.3711, -2.2764>, 0.2172 }
				cylinder { <-2.3561, 103.3711, -2.2764>, <-2.6978, 106.7314, -2.07583>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.6978, 106.7314, -2.07583>, <-2.8937, 107.5338, -2.0196>, <-2.8612, 107.5591, -2.1027> }
					triangle { <-2.8937, 107.5338, -2.0196>, <-3.03598, 107.9692, -2.05726>, <-2.8612, 107.5591, -2.1027> }
					triangle { <-3.03598, 107.9692, -2.05726>, <-2.9967, 107.9958, -2.1488>, <-2.8612, 107.5591, -2.1027> }
					triangle { <-3.03598, 107.9692, -2.05726>, <-3.1765, 108.6231, -2.2173>, <-2.9967, 107.9958, -2.1488> }
					triangle { <-2.9967, 107.9958, -2.1488>, <-3.1765, 108.6231, -2.2173>, <-2.9138, 107.991, -2.2099> }
					triangle { <-2.8612, 107.5591, -2.1027>, <-2.9967, 107.9958, -2.1488>, <-2.9138, 107.991, -2.2099> }
					triangle { <-2.8612, 107.5591, -2.1027>, <-2.9138, 107.991, -2.2099>, <-2.7932, 107.5504, -2.1621> }
					triangle { <-2.8612, 107.5591, -2.1027>, <-2.7932, 107.5504, -2.1621>, <-2.6978, 106.7314, -2.07583> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.5637, 90.00051, -1.4774>, <-0.687, 90.6914, -1.6274>, 0.2172 }
			cylinder { <-0.687, 90.6914, -1.6274>, <-0.8171, 91.3757, -1.8005>, 0.2172 }
			cylinder { <-0.8171, 91.3757, -1.8005>, <-0.9538, 92.05257, -1.9964>, 0.2172 }
			cylinder { <-0.9538, 92.05257, -1.9964>, <-1.09684, 92.7211, -2.2149>, 0.2172 }
			cylinder { <-1.09684, 92.7211, -2.2149>, <-1.246, 93.3805, -2.4557>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.246, 93.3805, -2.4557>, <-1.8664, 96.4528, -3.7302>, 0.2172 }
				cylinder { <-1.8664, 96.4528, -3.7302>, <-2.4021, 99.4814, -5.1407>, 0.2172 }
				cylinder { <-2.4021, 99.4814, -5.1407>, <-2.8518, 102.4589, -6.6838>, 0.2172 }
				cylinder { <-2.8518, 102.4589, -6.6838>, <-3.2144, 105.3781, -8.3557>, 0.2172 }
				cylinder { <-3.2144, 105.3781, -8.3557>, <-3.4891, 108.2319, -10.1525>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.4891, 108.2319, -10.1525>, <-3.5, 108.8423, -10.6518>, <-3.5781, 108.8753, -10.6268> }
					triangle { <-3.5, 108.8423, -10.6518>, <-3.5208, 109.2218, -10.8694>, <-3.5781, 108.8753, -10.6268> }
					triangle { <-3.5208, 109.2218, -10.8694>, <-3.609, 109.2552, -10.842>, <-3.5781, 108.8753, -10.6268> }
					triangle { <-3.5208, 109.2218, -10.8694>, <-3.6653, 109.7938, -11.1544>, <-3.609, 109.2552, -10.842> }
					triangle { <-3.609, 109.2552, -10.842>, <-3.6653, 109.7938, -11.1544>, <-3.703, 109.2313, -10.8265> }
					triangle { <-3.5781, 108.8753, -10.6268>, <-3.609, 109.2552, -10.842>, <-3.703, 109.2313, -10.8265> }
					triangle { <-3.5781, 108.8753, -10.6268>, <-3.703, 109.2313, -10.8265>, <-3.6597, 108.8563, -10.6051> }
					triangle { <-3.5781, 108.8753, -10.6268>, <-3.6597, 108.8563, -10.6051>, <-3.4891, 108.2319, -10.1525> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.246, 93.3805, -2.4557>, <-1.4065, 94.04488, -2.6749>, 0.2172 }
			cylinder { <-1.4065, 94.04488, -2.6749>, <-1.578, 94.7133, -2.8721>, 0.2172 }
			cylinder { <-1.578, 94.7133, -2.8721>, <-1.7603, 95.385, -3.04719>, 0.2172 }
			cylinder { <-1.7603, 95.385, -3.04719>, <-1.9532, 96.05933, -3.1998>, 0.2172 }
			cylinder { <-1.9532, 96.05933, -3.1998>, <-2.1566, 96.7352, -3.3298>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.1566, 96.7352, -3.3298>, <-3.2641, 99.8848, -3.8793>, 0.2172 }
				cylinder { <-3.2641, 99.8848, -3.8793>, <-4.5178, 102.99, -4.3639>, 0.2172 }
				cylinder { <-4.5178, 102.99, -4.3639>, <-5.9148, 106.0431, -4.7825>, 0.2172 }
				cylinder { <-5.9148, 106.0431, -4.7825>, <-7.4517, 109.037, -5.1339>, 0.2172 }
				cylinder { <-7.4517, 109.037, -5.1339>, <-9.1247, 111.9643, -5.4174>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-9.1247, 111.9643, -5.4174>, <-9.5882, 112.5516, -5.3492>, <-9.5288, 112.6111, -5.3453> }
					triangle { <-9.5882, 112.5516, -5.3492>, <-9.8089, 112.9053, -5.3644>, <-9.5288, 112.6111, -5.3453> }
					triangle { <-9.8089, 112.9053, -5.3644>, <-9.7414, 112.9697, -5.3577>, <-9.5288, 112.6111, -5.3453> }
					triangle { <-9.8089, 112.9053, -5.3644>, <-10.03897, 113.4855, -5.3644>, <-9.7414, 112.9697, -5.3577> }
					triangle { <-9.7414, 112.9697, -5.3577>, <-10.03897, 113.4855, -5.3644>, <-9.6624, 112.9939, -5.3137> }
					triangle { <-9.5288, 112.6111, -5.3453>, <-9.7414, 112.9697, -5.3577>, <-9.6624, 112.9939, -5.3137> }
					triangle { <-9.5288, 112.6111, -5.3453>, <-9.6624, 112.9939, -5.3137>, <-9.4556, 112.632, -5.3136> }
					triangle { <-9.5288, 112.6111, -5.3453>, <-9.4556, 112.632, -5.3136>, <-9.1247, 111.9643, -5.4174> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-2.1566, 96.7352, -3.3298>, <-2.3377, 97.4153, -3.4703>, 0.2172 }
			cylinder { <-2.3377, 97.4153, -3.4703>, <-2.4964, 98.09892, -3.6211>, 0.2172 }
			cylinder { <-2.4964, 98.09892, -3.6211>, <-2.6324, 98.785, -3.7819>, 0.2172 }
			cylinder { <-2.6324, 98.785, -3.7819>, <-2.7457, 99.4728, -3.9527>, 0.2172 }
			cylinder { <-2.7457, 99.4728, -3.9527>, <-2.836, 100.1617, -4.1331>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.836, 100.1617, -4.1331>, <-3.1102, 103.4402, -4.9232>, 0.2172 }
				cylinder { <-3.1102, 103.4402, -4.9232>, <-3.2323, 106.7423, -5.6512>, 0.2172 }
				cylinder { <-3.2323, 106.7423, -5.6512>, <-3.2019, 110.0599, -6.3152>, 0.2172 }
				cylinder { <-3.2019, 110.0599, -6.3152>, <-3.01911, 113.3851, -6.9136>, 0.2172 }
				cylinder { <-3.01911, 113.3851, -6.9136>, <-2.6843, 116.7099, -7.4451>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.6843, 116.7099, -7.4451>, <-2.568, 117.4136, -7.5026>, <-2.6093, 117.4248, -7.5704> }
					triangle { <-2.568, 117.4136, -7.5026>, <-2.5697, 117.809, -7.5417>, <-2.6093, 117.4248, -7.5704> }
					triangle { <-2.5697, 117.809, -7.5417>, <-2.614, 117.8191, -7.6183>, <-2.6093, 117.4248, -7.5704> }
					triangle { <-2.5697, 117.809, -7.5417>, <-2.616, 118.3807, -7.6983>, <-2.614, 117.8191, -7.6183> }
					triangle { <-2.614, 117.8191, -7.6183>, <-2.616, 118.3807, -7.6983>, <-2.6238, 117.7889, -7.7016> }
					triangle { <-2.6093, 117.4248, -7.5704>, <-2.614, 117.8191, -7.6183>, <-2.6238, 117.7889, -7.7016> }
					triangle { <-2.6093, 117.4248, -7.5704>, <-2.6238, 117.7889, -7.7016>, <-2.6251, 117.3965, -7.6418> }
					triangle { <-2.6093, 117.4248, -7.5704>, <-2.6251, 117.3965, -7.6418>, <-2.6843, 116.7099, -7.4451> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.226, 86.5863, -0.7246>, <0.1994, 87.3008, -0.7872>, 0.2172 }
			cylinder { <0.1994, 87.3008, -0.7872>, <0.1942, 88.01677, -0.8372>, 0.2172 }
			cylinder { <0.1942, 88.01677, -0.8372>, <0.2105, 88.7333, -0.8745>, 0.2172 }
			cylinder { <0.2105, 88.7333, -0.8745>, <0.2481, 89.4496, -0.8991>, 0.2172 }
			cylinder { <0.2481, 89.4496, -0.8991>, <0.3071, 90.1648, -0.9108>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.3071, 90.1648, -0.9108>, <0.4078, 90.8553, -0.743>, 0.2172 }
			cylinder { <0.4078, 90.8553, -0.743>, <0.5019, 91.552, -0.5985>, 0.2172 }
			cylinder { <0.5019, 91.552, -0.5985>, <0.5894, 92.254, -0.4773>, 0.2172 }
			cylinder { <0.5894, 92.254, -0.4773>, <0.6702, 92.9605, -0.3797>, 0.2172 }
			cylinder { <0.6702, 92.9605, -0.3797>, <0.744, 93.6706, -0.3057>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.744, 93.6706, -0.3057>, <1.1715, 97.02093, -0.1031>, 0.2172 }
				cylinder { <1.1715, 97.02093, -0.1031>, <1.6772, 100.366, -0.04692>, 0.2172 }
				cylinder { <1.6772, 100.366, -0.04692>, <2.26, 103.6978, -0.1372>, 0.2172 }
				cylinder { <2.26, 103.6978, -0.1372>, <2.9183, 107.0083, -0.3738>, 0.2172 }
				cylinder { <2.9183, 107.0083, -0.3738>, <3.6506, 110.2894, -0.7562>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <3.6506, 110.2894, -0.7562>, <3.9156, 111.0734, -0.7769>, <3.839, 111.1121, -0.7417> }
					triangle { <3.9156, 111.0734, -0.7769>, <4.04086, 111.5112, -0.7143>, <3.839, 111.1121, -0.7417> }
					triangle { <4.04086, 111.5112, -0.7143>, <3.9537, 111.5524, -0.6777>, <3.839, 111.1121, -0.7417> }
					triangle { <4.04086, 111.5112, -0.7143>, <4.106, 112.1852, -0.594>, <3.9537, 111.5524, -0.6777> }
					triangle { <3.9537, 111.5524, -0.6777>, <4.106, 112.1852, -0.594>, <3.8513, 111.5568, -0.6882> }
					triangle { <3.839, 111.1121, -0.7417>, <3.9537, 111.5524, -0.6777>, <3.8513, 111.5568, -0.6882> }
					triangle { <3.839, 111.1121, -0.7417>, <3.8513, 111.5568, -0.6882>, <3.7483, 111.1126, -0.7429> }
					triangle { <3.839, 111.1121, -0.7417>, <3.7483, 111.1126, -0.7429>, <3.6506, 110.2894, -0.7562> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.744, 93.6706, -0.3057>, <0.807, 94.379, -0.2095>, 0.2172 }
			cylinder { <0.807, 94.379, -0.2095>, <0.8589, 95.08502, -0.09105>, 0.2172 }
			cylinder { <0.8589, 95.08502, -0.09105>, <0.8998, 95.7876, 0.04949>, 0.2172 }
			cylinder { <0.8998, 95.7876, 0.04949>, <0.9296, 96.4861, 0.2119>, 0.2172 }
			cylinder { <0.9296, 96.4861, 0.2119>, <0.9482, 97.1796, 0.396>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9482, 97.1796, 0.396>, <0.8781, 100.4354, 1.3145>, 0.2172 }
				cylinder { <0.8781, 100.4354, 1.3145>, <0.6506, 103.6699, 2.2811>, 0.2172 }
				cylinder { <0.6506, 103.6699, 2.2811>, <0.2661, 106.8755, 3.2936>, 0.2172 }
				cylinder { <0.2661, 106.8755, 3.2936>, <-0.2744, 110.0443, 4.3495>, 0.2172 }
				cylinder { <-0.2744, 110.0443, 4.3495>, <-0.9696, 113.1687, 5.4464>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.9696, 113.1687, 5.4464>, <-1.2301, 113.8559, 5.7325>, <-1.1523, 113.8854, 5.7622> }
					triangle { <-1.2301, 113.8559, 5.7325>, <-1.3201, 114.2674, 5.8523>, <-1.1523, 113.8854, 5.7622> }
					triangle { <-1.3201, 114.2674, 5.8523>, <-1.2331, 114.2971, 5.887>, <-1.1523, 113.8854, 5.7622> }
					triangle { <-1.3201, 114.2674, 5.8523>, <-1.3433, 114.8822, 6.07749>, <-1.2331, 114.2971, 5.887> }
					triangle { <-1.2331, 114.2971, 5.887>, <-1.3433, 114.8822, 6.07749>, <-1.1557, 114.2725, 5.9421> }
					triangle { <-1.1523, 113.8854, 5.7622>, <-1.2331, 114.2971, 5.887>, <-1.1557, 114.2725, 5.9421> }
					triangle { <-1.1523, 113.8854, 5.7622>, <-1.1557, 114.2725, 5.9421>, <-1.07949, 113.8644, 5.8038> }
					triangle { <-1.1523, 113.8854, 5.7622>, <-1.07949, 113.8644, 5.8038>, <-0.9696, 113.1687, 5.4464> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9482, 97.1796, 0.396>, <0.99, 97.8743, 0.5712>, 0.2172 }
			cylinder { <0.99, 97.8743, 0.5712>, <1.05498, 98.5695, 0.7373>, 0.2172 }
			cylinder { <1.05498, 98.5695, 0.7373>, <1.143, 99.2644, 0.894>, 0.2172 }
			cylinder { <1.143, 99.2644, 0.894>, <1.2541, 99.958, 1.04122>, 0.2172 }
			cylinder { <1.2541, 99.958, 1.04122>, <1.388, 100.6496, 1.1787>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.388, 100.6496, 1.1787>, <2.168, 103.8652, 1.8858>, 0.2172 }
				cylinder { <2.168, 103.8652, 1.8858>, <3.09488, 107.0284, 2.65>, 0.2172 }
				cylinder { <3.09488, 107.0284, 2.65>, <4.1663, 110.1314, 3.4695>, 0.2172 }
				cylinder { <4.1663, 110.1314, 3.4695>, <5.3798, 113.1669, 4.3423>, 0.2172 }
				cylinder { <5.3798, 113.1669, 4.3423>, <6.7325, 116.1275, 5.2663>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <6.7325, 116.1275, 5.2663>, <7.1816, 116.7022, 5.4465>, <7.1463, 116.7591, 5.3956> }
					triangle { <7.1816, 116.7022, 5.4465>, <7.3715, 117.0569, 5.5567>, <7.1463, 116.7591, 5.3956> }
					triangle { <7.3715, 117.0569, 5.5567>, <7.3325, 117.118, 5.4976>, <7.1463, 116.7591, 5.3956> }
					triangle { <7.3715, 117.0569, 5.5567>, <7.6016, 117.6323, 5.6308>, <7.3325, 117.118, 5.4976> }
					triangle { <7.3325, 117.118, 5.4976>, <7.6016, 117.6323, 5.6308>, <7.3057, 117.1329, 5.4092> }
					triangle { <7.1463, 116.7591, 5.3956>, <7.3325, 117.118, 5.4976>, <7.3057, 117.1329, 5.4092> }
					triangle { <7.1463, 116.7591, 5.3956>, <7.3057, 117.1329, 5.4092>, <7.1153, 116.7729, 5.3205> }
					triangle { <7.1463, 116.7591, 5.3956>, <7.1153, 116.7729, 5.3205>, <6.7325, 116.1275, 5.2663> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.388, 100.6496, 1.1787>, <1.4989, 101.3468, 1.3083>, 0.2172 }
			cylinder { <1.4989, 101.3468, 1.3083>, <1.5868, 102.0487, 1.4299>, 0.2172 }
			cylinder { <1.5868, 102.0487, 1.4299>, <1.6514, 102.7544, 1.5432>, 0.2172 }
			cylinder { <1.6514, 102.7544, 1.5432>, <1.6928, 103.4632, 1.6482>, 0.2172 }
			cylinder { <1.6928, 103.4632, 1.6482>, <1.7109, 104.1742, 1.7447>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.7109, 104.1742, 1.7447>, <1.7272, 107.544, 2.0496>, 0.2172 }
				cylinder { <1.7272, 107.544, 2.0496>, <1.6744, 110.9236, 2.2037>, 0.2172 }
				cylinder { <1.6744, 110.9236, 2.2037>, <1.5527, 114.305, 2.2068>, 0.2172 }
				cylinder { <1.5527, 114.305, 2.2068>, <1.3625, 117.6799, 2.05876>, 0.2172 }
				cylinder { <1.3625, 117.6799, 2.05876>, <1.104, 121.0404, 1.7599>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.104, 121.0404, 1.7599>, <1.05222, 121.7414, 1.6262>, <1.03901, 121.7648, 1.7017> }
					triangle { <1.05222, 121.7414, 1.6262>, <1.06822, 122.1377, 1.6009>, <1.03901, 121.7648, 1.7017> }
					triangle { <1.06822, 122.1377, 1.6009>, <1.05122, 122.1615, 1.6851>, <1.03901, 121.7648, 1.7017> }
					triangle { <1.06822, 122.1377, 1.6009>, <1.05746, 122.7284, 1.6668>, <1.05122, 122.1615, 1.6851> }
					triangle { <1.05122, 122.1615, 1.6851>, <1.05746, 122.7284, 1.6668>, <1.000102, 122.1463, 1.7565> }
					triangle { <1.03901, 121.7648, 1.7017>, <1.05122, 122.1615, 1.6851>, <1.000102, 122.1463, 1.7565> }
					triangle { <1.03901, 121.7648, 1.7017>, <1.000102, 122.1463, 1.7565>, <1.000332, 121.7494, 1.7682> }
					triangle { <1.03901, 121.7648, 1.7017>, <1.000332, 121.7494, 1.7682>, <1.104, 121.0404, 1.7599> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.3071, 90.1648, -0.9108>, <0.3588, 90.8798, -0.9464>, 0.2172 }
			cylinder { <0.3588, 90.8798, -0.9464>, <0.4031, 91.5937, -1.005816>, 0.2172 }
			cylinder { <0.4031, 91.5937, -1.005816>, <0.4401, 92.3056, -1.08888>, 0.2172 }
			cylinder { <0.4401, 92.3056, -1.08888>, <0.4697, 93.0148, -1.1955>, 0.2172 }
			cylinder { <0.4697, 93.0148, -1.1955>, <0.4919, 93.7202, -1.3257>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.4919, 93.7202, -1.3257>, <0.5998, 94.3698, -1.6112>, 0.2172 }
			cylinder { <0.5998, 94.3698, -1.6112>, <0.6977, 95.02965, -1.8762>, 0.2172 }
			cylinder { <0.6977, 95.02965, -1.8762>, <0.7856, 95.6987, -2.1205>, 0.2172 }
			cylinder { <0.7856, 95.6987, -2.1205>, <0.8633, 96.3764, -2.3437>, 0.2172 }
			cylinder { <0.8633, 96.3764, -2.3437>, <0.9308, 97.06193, -2.5455>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9308, 97.06193, -2.5455>, <1.09358, 100.3198, -3.4445>, 0.2172 }
				cylinder { <1.09358, 100.3198, -3.4445>, <1.1006, 103.5964, -4.2887>, 0.2172 }
				cylinder { <1.1006, 103.5964, -4.2887>, <0.9521, 106.8837, -5.0761>, 0.2172 }
				cylinder { <0.9521, 106.8837, -5.0761>, <0.6482, 110.1739, -5.8047>, 0.2172 }
				cylinder { <0.6482, 110.1739, -5.8047>, <0.1897, 113.459, -6.4729>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.1897, 113.459, -6.4729>, <0.06042, 114.2302, -6.7445>, <0.1444, 114.2635, -6.7241> }
					triangle { <0.06042, 114.2302, -6.7445>, <0.05426, 114.6485, -6.9348>, <0.1444, 114.2635, -6.7241> }
					triangle { <0.05426, 114.6485, -6.9348>, <0.1473, 114.6843, -6.9087>, <0.1444, 114.2635, -6.7241> }
					triangle { <0.05426, 114.6485, -6.9348>, <0.1552, 115.2906, -7.1596>, <0.1473, 114.6843, -6.9087> }
					triangle { <0.1473, 114.6843, -6.9087>, <0.1552, 115.2906, -7.1596>, <0.2167, 114.6922, -6.8329> }
					triangle { <0.1444, 114.2635, -6.7241>, <0.1473, 114.6843, -6.9087>, <0.2167, 114.6922, -6.8329> }
					triangle { <0.1444, 114.2635, -6.7241>, <0.2167, 114.6922, -6.8329>, <0.2109, 114.2658, -6.6623> }
					triangle { <0.1444, 114.2635, -6.7241>, <0.2109, 114.2658, -6.6623>, <0.1897, 113.459, -6.4729> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9308, 97.06193, -2.5455>, <1.02102, 97.7421, -2.7561>, 0.2172 }
			cylinder { <1.02102, 97.7421, -2.7561>, <1.1338, 98.4162, -2.9751>, 0.2172 }
			cylinder { <1.1338, 98.4162, -2.9751>, <1.2692, 99.08349, -3.2022>, 0.2172 }
			cylinder { <1.2692, 99.08349, -3.2022>, <1.4269, 99.743, -3.4373>, 0.2172 }
			cylinder { <1.4269, 99.743, -3.4373>, <1.6067, 100.3941, -3.6799>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.6067, 100.3941, -3.6799>, <2.6035, 103.4444, -4.7527>, 0.2172 }
				cylinder { <2.6035, 103.4444, -4.7527>, <3.7467, 106.4681, -5.7519>, 0.2172 }
				cylinder { <3.7467, 106.4681, -5.7519>, <5.03373, 109.4581, -6.6751>, 0.2172 }
				cylinder { <5.03373, 109.4581, -6.6751>, <6.4613, 112.4071, -7.5201>, 0.2172 }
				cylinder { <6.4613, 112.4071, -7.5201>, <8.02614, 115.308, -8.2847>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <8.02614, 115.308, -8.2847>, <8.4798, 115.9401, -8.4134>, <8.4448, 115.9627, -8.4913> }
					triangle { <8.4798, 115.9401, -8.4134>, <8.6683, 116.3264, -8.4972>, <8.4448, 115.9627, -8.4913> }
					triangle { <8.6683, 116.3264, -8.4972>, <8.6299, 116.3482, -8.5849>, <8.4448, 115.9627, -8.4913> }
					triangle { <8.6683, 116.3264, -8.4972>, <8.8983, 116.8937, -8.7307>, <8.6299, 116.3482, -8.5849> }
					triangle { <8.6299, 116.3482, -8.5849>, <8.8983, 116.8937, -8.7307>, <8.6066, 116.3132, -8.6736> }
					triangle { <8.4448, 115.9627, -8.4913>, <8.6299, 116.3482, -8.5849>, <8.6066, 116.3132, -8.6736> }
					triangle { <8.4448, 115.9627, -8.4913>, <8.6066, 116.3132, -8.6736>, <8.4163, 115.9337, -8.5676> }
					triangle { <8.4448, 115.9627, -8.4913>, <8.4163, 115.9337, -8.5676>, <8.02614, 115.308, -8.2847> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.6067, 100.3941, -3.6799>, <1.7636, 101.0476, -3.9318>, 0.2172 }
			cylinder { <1.7636, 101.0476, -3.9318>, <1.8972, 101.7028, -4.1927>, 0.2172 }
			cylinder { <1.8972, 101.7028, -4.1927>, <2.007621, 102.3588, -4.4622>, 0.2172 }
			cylinder { <2.007621, 102.3588, -4.4622>, <2.09448, 103.0148, -4.7401>, 0.2172 }
			cylinder { <2.09448, 103.0148, -4.7401>, <2.1577, 103.6701, -5.02601>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.1577, 103.6701, -5.02601>, <2.3803, 106.7026, -6.5102>, 0.2172 }
				cylinder { <2.3803, 106.7026, -6.5102>, <2.5266, 109.6711, -8.1273>, 0.2172 }
				cylinder { <2.5266, 109.6711, -8.1273>, <2.5963, 112.5684, -9.8735>, 0.2172 }
				cylinder { <2.5963, 112.5684, -9.8735>, <2.5892, 115.3876, -11.7444>, 0.2172 }
				cylinder { <2.5892, 115.3876, -11.7444>, <2.5053, 118.1219, -13.7357>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <2.5053, 118.1219, -13.7357>, <2.3513, 118.6494, -14.2481>, <2.3496, 118.7148, -14.1952> }
					triangle { <2.3513, 118.6494, -14.2481>, <2.3204, 118.9766, -14.505>, <2.3496, 118.7148, -14.1952> }
					triangle { <2.3204, 118.9766, -14.505>, <2.3163, 119.0476, -14.4443>, <2.3496, 118.7148, -14.1952> }
					triangle { <2.3204, 118.9766, -14.505>, <2.2583, 119.5267, -14.7932>, <2.3163, 119.0476, -14.4443> }
					triangle { <2.3163, 119.0476, -14.4443>, <2.2583, 119.5267, -14.7932>, <2.279, 119.0779, -14.364> }
					triangle { <2.3496, 118.7148, -14.1952>, <2.3163, 119.0476, -14.4443>, <2.279, 119.0779, -14.364> }
					triangle { <2.3496, 118.7148, -14.1952>, <2.279, 119.0779, -14.364>, <2.3241, 118.7419, -14.1217> }
					triangle { <2.3496, 118.7148, -14.1952>, <2.3241, 118.7419, -14.1217>, <2.5053, 118.1219, -13.7357> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.1577, 103.6701, -5.02601>, <2.2333, 104.3326, -5.2915>, 0.2172 }
			cylinder { <2.2333, 104.3326, -5.2915>, <2.3212, 105.0015, -5.5362>, 0.2172 }
			cylinder { <2.3212, 105.0015, -5.5362>, <2.4212, 105.6761, -5.76>, 0.2172 }
			cylinder { <2.4212, 105.6761, -5.76>, <2.5332, 106.3555, -5.9624>, 0.2172 }
			cylinder { <2.5332, 106.3555, -5.9624>, <2.657, 107.0389, -6.1434>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.657, 107.0389, -6.1434>, <3.1943, 110.3054, -6.8433>, 0.2172 }
				cylinder { <3.1943, 110.3054, -6.8433>, <3.6837, 113.6087, -7.3886>, 0.2172 }
				cylinder { <3.6837, 113.6087, -7.3886>, <4.1241, 116.9408, -7.7778>, 0.2172 }
				cylinder { <4.1241, 116.9408, -7.7778>, <4.5143, 120.2938, -8.01012>, 0.2172 }
				cylinder { <4.5143, 120.2938, -8.01012>, <4.8534, 123.6595, -8.08488>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.8534, 123.6595, -8.08488>, <4.8752, 124.3739, -8.04988>, <4.9375, 124.3841, -8.09923> }
					triangle { <4.8752, 124.3739, -8.04988>, <4.8874, 124.7682, -8.09717>, <4.9375, 124.3841, -8.09923> }
					triangle { <4.8874, 124.7682, -8.09717>, <4.9583, 124.7775, -8.1503>, <4.9375, 124.3841, -8.09923> }
					triangle { <4.8874, 124.7682, -8.09717>, <4.9999, 125.3389, -8.2198>, <4.9583, 124.7775, -8.1503> }
					triangle { <4.9583, 124.7775, -8.1503>, <4.9999, 125.3389, -8.2198>, <5.04206, 124.7511, -8.1658> }
					triangle { <4.9375, 124.3841, -8.09923>, <4.9583, 124.7775, -8.1503>, <5.04206, 124.7511, -8.1658> }
					triangle { <4.9375, 124.3841, -8.09923>, <5.04206, 124.7511, -8.1658>, <5.008813, 124.3582, -8.1195> }
					triangle { <4.9375, 124.3841, -8.09923>, <5.008813, 124.3582, -8.1195>, <4.8534, 123.6595, -8.08488> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1545, 9.9257, -0.1883>, 0.1682 }
			cylinder { <0.1545, 9.9257, -0.1883>, <0.4636, 19.8424, -0.5649>, 0.1682 }
			cylinder { <0.4636, 19.8424, -0.5649>, <0.927, 29.7442, -1.1295>, 0.1682 }
			cylinder { <0.927, 29.7442, -1.1295>, <1.5443, 39.6251, -1.8818>, 0.1682 }
			cylinder { <1.5443, 39.6251, -1.8818>, <2.3154, 49.4791, -2.8213>, 0.1682 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.3154, 49.4791, -2.8213>, <2.4773, 51.5485, -3.01863>, 0.1682 }
				cylinder { <2.4773, 51.5485, -3.01863>, <2.6392, 53.6178, -3.2159>, 0.1682 }
				cylinder { <2.6392, 53.6178, -3.2159>, <2.8011, 55.6872, -3.4132>, 0.1682 }
				cylinder { <2.8011, 55.6872, -3.4132>, <2.963, 57.7565, -3.6105>, 0.1682 }
				cylinder { <2.963, 57.7565, -3.6105>, <3.1249, 59.8259, -3.8078>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.1249, 59.8259, -3.8078>, <3.1066, 60.318, -3.9013>, 0.008495 }
				cylinder { <3.1066, 60.318, -3.9013>, <3.03141, 60.794, -4.03908>, 0.008495 }
				cylinder { <3.03141, 60.794, -4.03908>, <2.9009, 61.2437, -4.2179>, 0.008495 }
				cylinder { <2.9009, 61.2437, -4.2179>, <2.718, 61.6574, -4.434>, 0.008495 }
				cylinder { <2.718, 61.6574, -4.434>, <2.4866, 62.02602, -4.6827>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.4866, 62.02602, -4.6827>, <1.7232, 63.6351, -6.03678>, <1.868, 63.6893, -6.08879> }
				triangle { <1.7232, 63.6351, -6.03678>, <1.2846, 64.6874, -6.6566>, <1.868, 63.6893, -6.08879> }
				triangle { <1.2846, 64.6874, -6.6566>, <1.4552, 64.748, -6.6644>, <1.868, 63.6893, -6.08879> }
				triangle { <1.2846, 64.6874, -6.6566>, <-0.0566, 68.2777, -7.9829>, <1.4552, 64.748, -6.6644> }
				triangle { <1.4552, 64.748, -6.6644>, <-0.0566, 68.2777, -7.9829>, <1.6344, 64.7867, -6.6539> }
				triangle { <1.868, 63.6893, -6.08879>, <1.4552, 64.748, -6.6644>, <1.6344, 64.7867, -6.6539> }
				triangle { <1.868, 63.6893, -6.08879>, <1.6344, 64.7867, -6.6539>, <2.02044, 63.7153, -6.08093> }
				triangle { <1.868, 63.6893, -6.08879>, <2.02044, 63.7153, -6.08093>, <2.4866, 62.02602, -4.6827> }
				triangle { <-0.7469, 70.2486, -8.4497>, <-0.0566, 68.2777, -7.9829>, <-0.3098, 68.2386, -7.9102> }
				triangle { <1.6344, 64.7867, -6.6539>, <-0.0566, 68.2777, -7.9829>, <0.2189, 68.4488, -7.9074> }
				triangle { <1.2846, 64.6874, -6.6566>, <-0.3098, 68.2386, -7.9102>, <-0.0566, 68.2777, -7.9829> }
				triangle { <-0.7469, 70.2486, -8.4497>, <0.2189, 68.4488, -7.9074>, <-0.0566, 68.2777, -7.9829> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.1249, 59.8259, -3.8078>, <3.2869, 61.8952, -4.005107>, 0.1682 }
				cylinder { <3.2869, 61.8952, -4.005107>, <3.4488, 63.9646, -4.2024>, 0.1682 }
				cylinder { <3.4488, 63.9646, -4.2024>, <3.6107, 66.03395, -4.3996>, 0.1682 }
				cylinder { <3.6107, 66.03395, -4.3996>, <3.7726, 68.1032, -4.5969>, 0.1682 }
				cylinder { <3.7726, 68.1032, -4.5969>, <3.9345, 70.1726, -4.7942>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.9345, 70.1726, -4.7942>, <4.03916, 70.6628, -4.7866>, 0.008495 }
				cylinder { <4.03916, 70.6628, -4.7866>, <4.2063, 71.1312, -4.7241>, 0.008495 }
				cylinder { <4.2063, 71.1312, -4.7241>, <4.4312, 71.564, -4.6087>, 0.008495 }
				cylinder { <4.4312, 71.564, -4.6087>, <4.7071, 71.9486, -4.4436>, 0.008495 }
				cylinder { <4.7071, 71.9486, -4.4436>, <5.02592, 72.2735, -4.2338>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.02592, 72.2735, -4.2338>, <6.6775, 73.6265, -3.5651>, <6.8021, 73.5313, -3.6098> }
				triangle { <6.6775, 73.6265, -3.5651>, <7.6167, 74.3184, -2.9967>, <6.8021, 73.5313, -3.6098> }
				triangle { <7.6167, 74.3184, -2.9967>, <7.7283, 74.1777, -3.02078>, <6.8021, 73.5313, -3.6098> }
				triangle { <7.6167, 74.3184, -2.9967>, <10.3937, 76.1272, -0.659>, <7.7283, 74.1777, -3.02078> }
				triangle { <7.7283, 74.1777, -3.02078>, <10.3937, 76.1272, -0.659>, <7.8168, 74.0202, -3.0534> }
				triangle { <6.8021, 73.5313, -3.6098>, <7.7283, 74.1777, -3.02078>, <7.8168, 74.0202, -3.0534> }
				triangle { <6.8021, 73.5313, -3.6098>, <7.8168, 74.0202, -3.0534>, <6.8733, 73.3979, -3.6432> }
				triangle { <6.8021, 73.5313, -3.6098>, <6.8733, 73.3979, -3.6432>, <5.02592, 72.2735, -4.2338> }
				triangle { <11.7743, 76.942, 0.7582>, <10.3937, 76.1272, -0.659>, <10.2252, 76.3031, -0.5509> }
				triangle { <7.8168, 74.0202, -3.0534>, <10.3937, 76.1272, -0.659>, <10.5699, 75.8523, -0.5938> }
				triangle { <7.6167, 74.3184, -2.9967>, <10.2252, 76.3031, -0.5509>, <10.3937, 76.1272, -0.659> }
				triangle { <11.7743, 76.942, 0.7582>, <10.5699, 75.8523, -0.5938>, <10.3937, 76.1272, -0.659> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.9345, 70.1726, -4.7942>, <4.1211, 72.2263, -5.1021>, 0.1682 }
				cylinder { <4.1211, 72.2263, -5.1021>, <4.3319, 74.2582, -5.5197>, 0.1682 }
				cylinder { <4.3319, 74.2582, -5.5197>, <4.5662, 76.2621, -6.04576>, 0.1682 }
				cylinder { <4.5662, 76.2621, -6.04576>, <4.8235, 78.2321, -6.6785>, 0.1682 }
				cylinder { <4.8235, 78.2321, -6.6785>, <5.1031, 80.1621, -7.4162>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.1031, 80.1621, -7.4162>, <5.09237, 80.6055, -7.6496>, 0.008495 }
				cylinder { <5.09237, 80.6055, -7.6496>, <5.004045, 81.01138, -7.9303>, 0.008495 }
				cylinder { <5.004045, 81.01138, -7.9303>, <4.8415, 81.364, -8.2473>, 0.008495 }
				cylinder { <4.8415, 81.364, -8.2473>, <4.6111, 81.6498, -8.5885>, 0.008495 }
				cylinder { <4.6111, 81.6498, -8.5885>, <4.3216, 81.8579, -8.9409>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.3216, 81.8579, -8.9409>, <3.29, 82.6824, -10.7469>, <3.4239, 82.7254, -10.8298> }
				triangle { <3.29, 82.6824, -10.7469>, <2.6873, 83.3366, -11.6917>, <3.4239, 82.7254, -10.8298> }
				triangle { <2.6873, 83.3366, -11.6917>, <2.8477, 83.4062, -11.7393>, <3.4239, 82.7254, -10.8298> }
				triangle { <2.6873, 83.3366, -11.6917>, <0.8191, 85.9077, -14.2111>, <2.8477, 83.4062, -11.7393> }
				triangle { <2.8477, 83.4062, -11.7393>, <0.8191, 85.9077, -14.2111>, <3.02039, 83.4643, -11.7622> }
				triangle { <3.4239, 82.7254, -10.8298>, <2.8477, 83.4062, -11.7393>, <3.02039, 83.4643, -11.7622> }
				triangle { <3.4239, 82.7254, -10.8298>, <3.02039, 83.4643, -11.7622>, <3.5716, 82.7681, -10.8475> }
				triangle { <3.4239, 82.7254, -10.8298>, <3.5716, 82.7681, -10.8475>, <4.3216, 81.8579, -8.9409> }
				triangle { <-0.1493, 87.4309, -15.3604>, <0.8191, 85.9077, -14.2111>, <0.5768, 85.8756, -14.1051> }
				triangle { <3.02039, 83.4643, -11.7622>, <0.8191, 85.9077, -14.2111>, <1.07228, 86.1225, -14.237> }
				triangle { <2.6873, 83.3366, -11.6917>, <0.5768, 85.8756, -14.1051>, <0.8191, 85.9077, -14.2111> }
				triangle { <-0.1493, 87.4309, -15.3604>, <1.07228, 86.1225, -14.237>, <0.8191, 85.9077, -14.2111> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <5.1031, 80.1621, -7.4162>, <5.4136, 82.07323, -8.1899>, 0.1682 }
				cylinder { <5.4136, 82.07323, -8.1899>, <5.7548, 83.9642, -8.9993>, 0.1682 }
				cylinder { <5.7548, 83.9642, -8.9993>, <6.1265, 85.8339, -9.8439>, 0.1682 }
				cylinder { <6.1265, 85.8339, -9.8439>, <6.5286, 87.6812, -10.7231>, 0.1682 }
				cylinder { <6.5286, 87.6812, -10.7231>, <6.9607, 89.5051, -11.6364>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <6.9607, 89.5051, -11.6364>, <7.1211, 89.9476, -11.8088>, 0.008495 }
				cylinder { <7.1211, 89.9476, -11.8088>, <7.3346, 90.3845, -11.9303>, 0.008495 }
				cylinder { <7.3346, 90.3845, -11.9303>, <7.5966, 90.8064, -11.9983>, 0.008495 }
				cylinder { <7.5966, 90.8064, -11.9983>, <7.9014, 91.2041, -12.01132>, 0.008495 }
				cylinder { <7.9014, 91.2041, -12.01132>, <8.2423, 91.5691, -11.969>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <8.2423, 91.5691, -11.969>, <9.975, 92.9845, -11.988>, <10.0936, 92.8725, -11.9918> }
				triangle { <9.975, 92.9845, -11.988>, <10.967, 93.7986, -11.7957>, <10.0936, 92.8725, -11.9918> }
				triangle { <10.967, 93.7986, -11.7957>, <11.07197, 93.655, -11.7611>, <10.0936, 92.8725, -11.9918> }
				triangle { <10.967, 93.7986, -11.7957>, <13.9245, 96.2692, -10.532>, <11.07197, 93.655, -11.7611> }
				triangle { <11.07197, 93.655, -11.7611>, <13.9245, 96.2692, -10.532>, <11.1528, 93.4938, -11.7265> }
				triangle { <10.0936, 92.8725, -11.9918>, <11.07197, 93.655, -11.7611>, <11.1528, 93.4938, -11.7265> }
				triangle { <10.0936, 92.8725, -11.9918>, <11.1528, 93.4938, -11.7265>, <10.1579, 92.7338, -11.9676> }
				triangle { <10.0936, 92.8725, -11.9918>, <10.1579, 92.7338, -11.9676>, <8.2423, 91.5691, -11.969> }
				triangle { <15.4047, 97.5289, -9.6369>, <13.9245, 96.2692, -10.532>, <13.7684, 96.4833, -10.5037> }
				triangle { <11.1528, 93.4938, -11.7265>, <13.9245, 96.2692, -10.532>, <14.09354, 96.03839, -10.3616> }
				triangle { <10.967, 93.7986, -11.7957>, <13.7684, 96.4833, -10.5037>, <13.9245, 96.2692, -10.532> }
				triangle { <15.4047, 97.5289, -9.6369>, <14.09354, 96.03839, -10.3616>, <13.9245, 96.2692, -10.532> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <6.9607, 89.5051, -11.6364>, <7.07422, 89.9449, -11.8484>, 0.008495 }
				cylinder { <7.07422, 89.9449, -11.8484>, <7.1972, 90.3858, -12.05279>, 0.008495 }
				cylinder { <7.1972, 90.3858, -12.05279>, <7.3297, 90.8274, -12.2493>, 0.008495 }
				cylinder { <7.3297, 90.8274, -12.2493>, <7.4716, 91.2696, -12.4378>, 0.008495 }
				cylinder { <7.4716, 91.2696, -12.4378>, <7.6229, 91.7121, -12.6184>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <7.6229, 91.7121, -12.6184>, <8.5339, 93.4917, -13.6228>, <8.6858, 93.4333, -13.6353> }
				triangle { <8.5339, 93.4917, -13.6228>, <9.0946, 94.5937, -14.01663>, <8.6858, 93.4333, -13.6353> }
				triangle { <9.0946, 94.5937, -14.01663>, <9.2557, 94.5188, -13.9811>, <8.6858, 93.4333, -13.6353> }
				triangle { <9.0946, 94.5937, -14.01663>, <10.8852, 98.1883, -14.5832>, <9.2557, 94.5188, -13.9811> }
				triangle { <9.2557, 94.5188, -13.9811>, <10.8852, 98.1883, -14.5832>, <9.4032, 94.4209, -13.9324> }
				triangle { <8.6858, 93.4333, -13.6353>, <9.2557, 94.5188, -13.9811>, <9.4032, 94.4209, -13.9324> }
				triangle { <8.6858, 93.4333, -13.6353>, <9.4032, 94.4209, -13.9324>, <8.807, 93.3452, -13.5966> }
				triangle { <8.6858, 93.4333, -13.6353>, <8.807, 93.3452, -13.5966>, <7.6229, 91.7121, -12.6184> }
				triangle { <11.8239, 100.1105, -14.6376>, <10.8852, 98.1883, -14.5832>, <10.6612, 98.3314, -14.5645> }
				triangle { <9.4032, 94.4209, -13.9324>, <10.8852, 98.1883, -14.5832>, <11.1674, 98.1131, -14.4232> }
				triangle { <9.0946, 94.5937, -14.01663>, <10.6612, 98.3314, -14.5645>, <10.8852, 98.1883, -14.5832> }
				triangle { <11.8239, 100.1105, -14.6376>, <11.1674, 98.1131, -14.4232>, <10.8852, 98.1883, -14.5832> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.4633, 9.9017, 0.5646>, 0.1682 }
			cylinder { <-0.4633, 9.9017, 0.5646>, <-1.3875, 19.723, 1.6907>, 0.1682 }
			cylinder { <-1.3875, 19.723, 1.6907>, <-2.7676, 29.4104, 3.3723>, 0.1682 }
			cylinder { <-2.7676, 29.4104, 3.3723>, <-4.596, 38.9116, 5.6002>, 0.1682 }
			cylinder { <-4.596, 38.9116, 5.6002>, <-6.8629, 48.175, 8.3624>, 0.1682 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-6.8629, 48.175, 8.3624>, <-7.369, 50.1013, 8.9792>, 0.1682 }
				cylinder { <-7.369, 50.1013, 8.9792>, <-7.9051, 52.00753, 9.6324>, 0.1682 }
				cylinder { <-7.9051, 52.00753, 9.6324>, <-8.4706, 53.8923, 10.3215>, 0.1682 }
				cylinder { <-8.4706, 53.8923, 10.3215>, <-9.06537, 55.7547, 11.04619>, 0.1682 }
				cylinder { <-9.06537, 55.7547, 11.04619>, <-9.6889, 57.5935, 11.8059>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-9.6889, 57.5935, 11.8059>, <-9.7703, 58.02915, 12.04029>, 0.008495 }
				cylinder { <-9.7703, 58.02915, 12.04029>, <-9.7809, 58.4453, 12.3193>, 0.008495 }
				cylinder { <-9.7809, 58.4453, 12.3193>, <-9.7203, 58.83, 12.635>, 0.008495 }
				cylinder { <-9.7203, 58.83, 12.635>, <-9.5904, 59.1717, 12.9779>, 0.008495 }
				cylinder { <-9.5904, 59.1717, 12.9779>, <-9.3949, 59.4604, 13.338>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.3949, 59.4604, 13.338>, <-8.3662, 60.7694, 14.8327>, <-8.4885, 60.7786, 14.9403> }
				triangle { <-8.3662, 60.7694, 14.8327>, <-7.8422, 61.6841, 15.5895>, <-8.4885, 60.7786, 14.9403> }
				triangle { <-7.8422, 61.6841, 15.5895>, <-8.004507, 61.706, 15.667>, <-8.4885, 60.7786, 14.9403> }
				triangle { <-7.8422, 61.6841, 15.5895>, <-6.4722, 64.9837, 17.5086>, <-8.004507, 61.706, 15.667> }
				triangle { <-8.004507, 61.706, 15.667>, <-6.4722, 64.9837, 17.5086>, <-8.179, 61.7105, 15.7239> }
				triangle { <-8.4885, 60.7786, 14.9403>, <-8.004507, 61.706, 15.667>, <-8.179, 61.7105, 15.7239> }
				triangle { <-8.4885, 60.7786, 14.9403>, <-8.179, 61.7105, 15.7239>, <-8.6359, 60.7755, 14.9874> }
				triangle { <-8.4885, 60.7786, 14.9403>, <-8.6359, 60.7755, 14.9874>, <-9.3949, 59.4604, 13.338> }
				triangle { <-5.8535, 66.8555, 18.3409>, <-6.4722, 64.9837, 17.5086>, <-6.2573, 65.01549, 17.3543> }
				triangle { <-8.179, 61.7105, 15.7239>, <-6.4722, 64.9837, 17.5086>, <-6.7717, 65.1117, 17.5778> }
				triangle { <-7.8422, 61.6841, 15.5895>, <-6.2573, 65.01549, 17.3543>, <-6.4722, 64.9837, 17.5086> }
				triangle { <-5.8535, 66.8555, 18.3409>, <-6.7717, 65.1117, 17.5778>, <-6.4722, 64.9837, 17.5086> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-9.6889, 57.5935, 11.8059>, <-10.3292, 59.3814, 12.6667>, 0.1682 }
				cylinder { <-10.3292, 59.3814, 12.6667>, <-10.9844, 61.1128, 13.6259>, 0.1682 }
				cylinder { <-10.9844, 61.1128, 13.6259>, <-11.6527, 62.7826, 14.6806>, 0.1682 }
				cylinder { <-11.6527, 62.7826, 14.6806>, <-12.3321, 64.3858, 15.8277>, 0.1682 }
				cylinder { <-12.3321, 64.3858, 15.8277>, <-13.02056, 65.9175, 17.06361>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-13.02056, 65.9175, 17.06361>, <-13.2438, 66.2892, 17.315>, 0.008495 }
				cylinder { <-13.2438, 66.2892, 17.315>, <-13.5201, 66.6563, 17.5153>, 0.008495 }
				cylinder { <-13.5201, 66.6563, 17.5153>, <-13.8434, 67.01096, 17.6602>, 0.008495 }
				cylinder { <-13.8434, 67.01096, 17.6602>, <-14.2066, 67.3453, 17.7465>, 0.008495 }
				cylinder { <-14.2066, 67.3453, 17.7465>, <-14.602, 67.6524, 17.7724>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-14.602, 67.6524, 17.7724>, <-16.2439, 69.1696, 17.8601>, <-16.3685, 69.0651, 17.8725> }
				triangle { <-16.2439, 69.1696, 17.8601>, <-17.1951, 70.03902, 17.7074>, <-16.3685, 69.0651, 17.8725> }
				triangle { <-17.1951, 70.03902, 17.7074>, <-17.3101, 69.9014, 17.6813>, <-16.3685, 69.0651, 17.8725> }
				triangle { <-17.1951, 70.03902, 17.7074>, <-20.06706, 72.6636, 16.562>, <-17.3101, 69.9014, 17.6813> }
				triangle { <-17.3101, 69.9014, 17.6813>, <-20.06706, 72.6636, 16.562>, <-17.4022, 69.7449, 17.6542> }
				triangle { <-16.3685, 69.0651, 17.8725>, <-17.3101, 69.9014, 17.6813>, <-17.4022, 69.7449, 17.6542> }
				triangle { <-16.3685, 69.0651, 17.8725>, <-17.4022, 69.7449, 17.6542>, <-16.4423, 68.9302, 17.8544> }
				triangle { <-16.3685, 69.0651, 17.8725>, <-16.4423, 68.9302, 17.8544>, <-14.602, 67.6524, 17.7724> }
				triangle { <-21.5177, 73.9962, 15.7262>, <-20.06706, 72.6636, 16.562>, <-19.9003, 72.8674, 16.5212> }
				triangle { <-17.4022, 69.7449, 17.6542>, <-20.06706, 72.6636, 16.562>, <-20.2587, 72.4407, 16.4055> }
				triangle { <-17.1951, 70.03902, 17.7074>, <-19.9003, 72.8674, 16.5212>, <-20.06706, 72.6636, 16.562> }
				triangle { <-21.5177, 73.9962, 15.7262>, <-20.2587, 72.4407, 16.4055>, <-20.06706, 72.6636, 16.562> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-13.02056, 65.9175, 17.06361>, <-13.7335, 67.4143, 18.3278>, 0.1682 }
				cylinder { <-13.7335, 67.4143, 18.3278>, <-14.4707, 68.8755, 19.6197>, 0.1682 }
				cylinder { <-14.4707, 68.8755, 19.6197>, <-15.2315, 70.3001, 20.9384>, 0.1682 }
				cylinder { <-15.2315, 70.3001, 20.9384>, <-16.01567, 71.6873, 22.2831>, 0.1682 }
				cylinder { <-16.01567, 71.6873, 22.2831>, <-16.8225, 73.03624, 23.653>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-16.8225, 73.03624, 23.653>, <-16.9548, 73.3495, 24.02131>, 0.008495 }
				cylinder { <-16.9548, 73.3495, 24.02131>, <-17.02252, 73.6451, 24.4204>, 0.008495 }
				cylinder { <-17.02252, 73.6451, 24.4204>, <-17.02421, 73.9164, 24.8418>, 0.008495 }
				cylinder { <-17.02421, 73.9164, 24.8418>, <-16.9598, 74.1578, 25.2764>, 0.008495 }
				cylinder { <-16.9598, 74.1578, 25.2764>, <-16.8308, 74.3639, 25.7147>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-16.8308, 74.3639, 25.7147>, <-16.1074, 75.3682, 27.5785>, <-16.2283, 75.3198, 27.6767> }
				triangle { <-16.1074, 75.3682, 27.5785>, <-15.7931, 76.1126, 28.5939>, <-16.2283, 75.3198, 27.6767> }
				triangle { <-15.7931, 76.1126, 28.5939>, <-15.9559, 76.07645, 28.6647>, <-16.2283, 75.3198, 27.6767> }
				triangle { <-15.7931, 76.1126, 28.5939>, <-15.1702, 78.9237, 31.4501>, <-15.9559, 76.07645, 28.6647> }
				triangle { <-15.9559, 76.07645, 28.6647>, <-15.1702, 78.9237, 31.4501>, <-16.1269, 76.02735, 28.71> }
				triangle { <-16.2283, 75.3198, 27.6767>, <-15.9559, 76.07645, 28.6647>, <-16.1269, 76.02735, 28.71> }
				triangle { <-16.2283, 75.3198, 27.6767>, <-16.1269, 76.02735, 28.71>, <-16.3712, 75.2723, 27.7122> }
				triangle { <-16.2283, 75.3198, 27.6767>, <-16.3712, 75.2723, 27.7122>, <-16.8308, 74.3639, 25.7147> }
				triangle { <-14.9726, 80.5595, 32.8154>, <-15.1702, 78.9237, 31.4501>, <-14.9681, 79.04337, 31.3243> }
				triangle { <-16.1269, 76.02735, 28.71>, <-15.1702, 78.9237, 31.4501>, <-15.4903, 78.9601, 31.5347> }
				triangle { <-15.7931, 76.1126, 28.5939>, <-14.9681, 79.04337, 31.3243>, <-15.1702, 78.9237, 31.4501> }
				triangle { <-14.9726, 80.5595, 32.8154>, <-15.4903, 78.9601, 31.5347>, <-15.1702, 78.9237, 31.4501> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-16.8225, 73.03624, 23.653>, <-17.6293, 74.3851, 25.02303>, 0.1682 }
				cylinder { <-17.6293, 74.3851, 25.02303>, <-18.4362, 75.734, 26.3929>, 0.1682 }
				cylinder { <-18.4362, 75.734, 26.3929>, <-19.243, 77.08298, 27.7629>, 0.1682 }
				cylinder { <-19.243, 77.08298, 27.7629>, <-20.04992, 78.4319, 29.1328>, 0.1682 }
				cylinder { <-20.04992, 78.4319, 29.1328>, <-20.8567, 79.7808, 30.5028>, 0.1682 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-20.8567, 79.7808, 30.5028>, <-21.1173, 80.109, 30.7778>, 0.008495 }
				cylinder { <-21.1173, 80.109, 30.7778>, <-21.4367, 80.4315, 30.9904>, 0.008495 }
				cylinder { <-21.4367, 80.4315, 30.9904>, <-21.8057, 80.7387, 31.1344>, 0.008495 }
				cylinder { <-21.8057, 80.7387, 31.1344>, <-22.2133, 81.0217, 31.2054>, 0.008495 }
				cylinder { <-22.2133, 81.0217, 31.2054>, <-22.6475, 81.272, 31.2015>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-22.6475, 81.272, 31.2015>, <-24.482, 82.5525, 31.1741>, <-24.5917, 82.4319, 31.17> }
				triangle { <-24.482, 82.5525, 31.1741>, <-25.5237, 83.2948, 30.9556>, <-24.5917, 82.4319, 31.17> }
				triangle { <-25.5237, 83.2948, 30.9556>, <-25.6158, 83.1447, 30.913>, <-24.5917, 82.4319, 31.17> }
				triangle { <-25.5237, 83.2948, 30.9556>, <-28.6026, 85.5692, 29.6156>, <-25.6158, 83.1447, 30.913> }
				triangle { <-25.6158, 83.1447, 30.913>, <-28.6026, 85.5692, 29.6156>, <-25.6825, 82.9789, 30.871> }
				triangle { <-24.5917, 82.4319, 31.17>, <-25.6158, 83.1447, 30.913>, <-25.6825, 82.9789, 30.871> }
				triangle { <-24.5917, 82.4319, 31.17>, <-25.6825, 82.9789, 30.871>, <-24.6443, 82.2895, 31.1397> }
				triangle { <-24.5917, 82.4319, 31.17>, <-24.6443, 82.2895, 31.1397>, <-22.6475, 81.272, 31.2015> }
				triangle { <-30.1338, 86.7375, 28.6832>, <-28.6026, 85.5692, 29.6156>, <-28.4621, 85.795, 29.5994> }
				triangle { <-25.6825, 82.9789, 30.871>, <-28.6026, 85.5692, 29.6156>, <-28.7459, 85.3309, 29.4325> }
				triangle { <-25.5237, 83.2948, 30.9556>, <-28.4621, 85.795, 29.5994>, <-28.6026, 85.5692, 29.6156> }
				triangle { <-30.1338, 86.7375, 28.6832>, <-28.7459, 85.3309, 29.4325>, <-28.6026, 85.5692, 29.6156> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-20.8567, 79.7808, 30.5028>, <-21.05074, 80.1051, 30.8321>, 0.008495 }
				cylinder { <-21.05074, 80.1051, 30.8321>, <-21.2447, 80.4293, 31.1615>, 0.008495 }
				cylinder { <-21.2447, 80.4293, 31.1615>, <-21.4386, 80.7536, 31.4908>, 0.008495 }
				cylinder { <-21.4386, 80.7536, 31.4908>, <-21.6326, 81.07796, 31.8202>, 0.008495 }
				cylinder { <-21.6326, 81.07796, 31.8202>, <-21.8266, 81.4022, 32.1495>, 0.008495 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-21.8266, 81.4022, 32.1495>, <-22.5437, 82.9668, 33.5789>, <-22.6831, 82.8937, 33.622> }
				triangle { <-22.5437, 82.9668, 33.5789>, <-23.04489, 83.9616, 34.2447>, <-22.6831, 82.8937, 33.622> }
				triangle { <-23.04489, 83.9616, 34.2447>, <-23.2048, 83.8766, 34.2419>, <-22.6831, 82.8937, 33.622> }
				triangle { <-23.04489, 83.9616, 34.2447>, <-24.8328, 87.29, 35.7188>, <-23.2048, 83.8766, 34.2419> }
				triangle { <-23.2048, 83.8766, 34.2419>, <-24.8328, 87.29, 35.7188>, <-23.3538, 83.7716, 34.22> }
				triangle { <-22.6831, 82.8937, 33.622>, <-23.2048, 83.8766, 34.2419>, <-23.3538, 83.7716, 34.22> }
				triangle { <-22.6831, 82.8937, 33.622>, <-23.3538, 83.7716, 34.22>, <-22.8047, 82.7997, 33.6043> }
				triangle { <-22.6831, 82.8937, 33.622>, <-22.8047, 82.7997, 33.6043>, <-21.8266, 81.4022, 32.1495> }
				triangle { <-25.8367, 89.09936, 36.2642>, <-24.8328, 87.29, 35.7188>, <-24.6308, 87.4543, 35.6627> }
				triangle { <-23.3538, 83.7716, 34.22>, <-24.8328, 87.29, 35.7188>, <-25.1423, 87.2075, 35.6278> }
				triangle { <-23.04489, 83.9616, 34.2447>, <-24.6308, 87.4543, 35.6627>, <-24.8328, 87.29, 35.7188> }
				triangle { <-25.8367, 89.09936, 36.2642>, <-25.1423, 87.2075, 35.6278>, <-24.8328, 87.29, 35.7188> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.3063, 6.3049, 0.04544>, 0.1069 }
			cylinder { <-0.3063, 6.3049, 0.04544>, <-0.9184, 12.5871, 0.1362>, 0.1069 }
			cylinder { <-0.9184, 12.5871, 0.1362>, <-1.8346, 18.8313, 0.2721>, 0.1069 }
			cylinder { <-1.8346, 18.8313, 0.2721>, <-3.05284, 25.02262, 0.4528>, 0.1069 }
			cylinder { <-3.05284, 25.02262, 0.4528>, <-4.57, 31.146, 0.6779>, 0.1069 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-4.57, 31.146, 0.6779>, <-4.9149, 32.4232, 0.7619>, 0.1069 }
				cylinder { <-4.9149, 32.4232, 0.7619>, <-5.2856, 33.6902, 0.8826>, 0.1069 }
				cylinder { <-5.2856, 33.6902, 0.8826>, <-5.6817, 34.9455, 1.03984>, 0.1069 }
				cylinder { <-5.6817, 34.9455, 1.03984>, <-6.1028, 36.1875, 1.2333>, 0.1069 }
				cylinder { <-6.1028, 36.1875, 1.2333>, <-6.5483, 37.4147, 1.4629>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-6.5483, 37.4147, 1.4629>, <-6.6092, 37.5955, 1.5313>, 0.003434 }
				cylinder { <-6.6092, 37.5955, 1.5313>, <-6.6609, 37.7641, 1.631>, 0.003434 }
				cylinder { <-6.6609, 37.7641, 1.631>, <-6.7021, 37.9156, 1.7591>, 0.003434 }
				cylinder { <-6.7021, 37.9156, 1.7591>, <-6.7315, 38.0456, 1.9117>, 0.003434 }
				cylinder { <-6.7315, 38.0456, 1.9117>, <-6.7483, 38.1501, 2.08452>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-6.7483, 38.1501, 2.08452>, <-6.8894, 38.8438, 3.3183>, <-6.9907, 38.8647, 3.3103> }
				triangle { <-6.8894, 38.8438, 3.3183>, <-6.9381, 39.3519, 3.9665>, <-6.9907, 38.8647, 3.3103> }
				triangle { <-6.9381, 39.3519, 3.9665>, <-7.04147, 39.3856, 3.9285>, <-6.9907, 38.8647, 3.3103> }
				triangle { <-6.9381, 39.3519, 3.9665>, <-6.9602, 41.2466, 5.7153>, <-7.04147, 39.3856, 3.9285> }
				triangle { <-7.04147, 39.3856, 3.9285>, <-6.9602, 41.2466, 5.7153>, <-7.1419, 39.4098, 3.8743> }
				triangle { <-6.9907, 38.8647, 3.3103>, <-7.04147, 39.3856, 3.9285>, <-7.1419, 39.4098, 3.8743> }
				triangle { <-6.9907, 38.8647, 3.3103>, <-7.1419, 39.4098, 3.8743>, <-7.07581, 38.881, 3.2636> }
				triangle { <-6.9907, 38.8647, 3.3103>, <-7.07581, 38.881, 3.2636>, <-6.7483, 38.1501, 2.08452> }
				triangle { <-6.9218, 42.3403, 6.5235>, <-6.9602, 41.2466, 5.7153>, <-6.7943, 41.2398, 5.7485> }
				triangle { <-7.1419, 39.4098, 3.8743>, <-6.9602, 41.2466, 5.7153>, <-7.1093, 41.3633, 5.6204> }
				triangle { <-6.9381, 39.3519, 3.9665>, <-6.7943, 41.2398, 5.7485>, <-6.9602, 41.2466, 5.7153> }
				triangle { <-6.9218, 42.3403, 6.5235>, <-7.1093, 41.3633, 5.6204>, <-6.9602, 41.2466, 5.7153> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-6.5483, 37.4147, 1.4629>, <-6.9694, 38.6567, 1.6564>, 0.1069 }
				cylinder { <-6.9694, 38.6567, 1.6564>, <-7.3655, 39.912, 1.8137>, 0.1069 }
				cylinder { <-7.3655, 39.912, 1.8137>, <-7.7361, 41.179, 1.9345>, 0.1069 }
				cylinder { <-7.7361, 41.179, 1.9345>, <-8.08085, 42.4563, 2.01867>, 0.1069 }
				cylinder { <-8.08085, 42.4563, 2.01867>, <-8.3991, 43.7422, 2.06614>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-8.3991, 43.7422, 2.06614>, <-8.4521, 43.9359, 2.03901>, 0.003434 }
				cylinder { <-8.4521, 43.9359, 2.03901>, <-8.5077, 44.1211, 1.9782>, 0.003434 }
				cylinder { <-8.5077, 44.1211, 1.9782>, <-8.5644, 44.2922, 1.8857>, 0.003434 }
				cylinder { <-8.5644, 44.2922, 1.8857>, <-8.6205, 44.4442, 1.7641>, 0.003434 }
				cylinder { <-8.6205, 44.4442, 1.7641>, <-8.6744, 44.5728, 1.617>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.6744, 44.5728, 1.617>, <-9.09266, 45.4894, 0.6129>, <-9.1725, 45.434, 0.5767> }
				triangle { <-9.09266, 45.4894, 0.6129>, <-9.2503, 45.96, -0.0461>, <-9.1725, 45.434, 0.5767> }
				triangle { <-9.2503, 45.96, -0.0461>, <-9.3166, 45.8751, -0.08701>, <-9.1725, 45.434, 0.5767> }
				triangle { <-9.2503, 45.96, -0.0461>, <-9.4354, 47.1962, -2.3013>, <-9.3166, 45.8751, -0.08701> }
				triangle { <-9.3166, 45.8751, -0.08701>, <-9.4354, 47.1962, -2.3013>, <-9.3767, 45.7788, -0.1142> }
				triangle { <-9.1725, 45.434, 0.5767>, <-9.3166, 45.8751, -0.08701>, <-9.3767, 45.7788, -0.1142> }
				triangle { <-9.1725, 45.434, 0.5767>, <-9.3767, 45.7788, -0.1142>, <-9.2241, 45.3524, 0.558> }
				triangle { <-9.1725, 45.434, 0.5767>, <-9.2241, 45.3524, 0.558>, <-8.6744, 44.5728, 1.617> }
				triangle { <-9.418, 47.7553, -3.5415>, <-9.4354, 47.1962, -2.3013>, <-9.3049, 47.3005, -2.2733> }
				triangle { <-9.3767, 45.7788, -0.1142>, <-9.4354, 47.1962, -2.3013>, <-9.4965, 47.02804, -2.4144> }
				triangle { <-9.2503, 45.96, -0.0461>, <-9.3049, 47.3005, -2.2733>, <-9.4354, 47.1962, -2.3013> }
				triangle { <-9.418, 47.7553, -3.5415>, <-9.4965, 47.02804, -2.4144>, <-9.4354, 47.1962, -2.3013> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-8.3991, 43.7422, 2.06614>, <-8.7439, 45.01955, 2.1503>, 0.1069 }
				cylinder { <-8.7439, 45.01955, 2.1503>, <-9.1145, 46.2865, 2.271>, 0.1069 }
				cylinder { <-9.1145, 46.2865, 2.271>, <-9.5107, 47.5418, 2.4282>, 0.1069 }
				cylinder { <-9.5107, 47.5418, 2.4282>, <-9.9319, 48.7837, 2.6216>, 0.1069 }
				cylinder { <-9.9319, 48.7837, 2.6216>, <-10.3777, 50.01096, 2.8509>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-10.3777, 50.01096, 2.8509>, <-10.4387, 50.1916, 2.9193>, 0.003434 }
				cylinder { <-10.4387, 50.1916, 2.9193>, <-10.4907, 50.3602, 3.01907>, 0.003434 }
				cylinder { <-10.4907, 50.3602, 3.01907>, <-10.5322, 50.5116, 3.1471>, 0.003434 }
				cylinder { <-10.5322, 50.5116, 3.1471>, <-10.562, 50.6414, 3.2998>, 0.003434 }
				cylinder { <-10.562, 50.6414, 3.2998>, <-10.5792, 50.7459, 3.4726>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.5792, 50.7459, 3.4726>, <-10.7237, 51.4386, 4.7065>, <-10.825, 51.4595, 4.6983> }
				triangle { <-10.7237, 51.4386, 4.7065>, <-10.774, 51.946, 5.3551>, <-10.825, 51.4595, 4.6983> }
				triangle { <-10.774, 51.946, 5.3551>, <-10.8773, 51.9798, 5.3168>, <-10.825, 51.4595, 4.6983> }
				triangle { <-10.774, 51.946, 5.3551>, <-10.8006, 53.8393, 7.1054>, <-10.8773, 51.9798, 5.3168> }
				triangle { <-10.8773, 51.9798, 5.3168>, <-10.8006, 53.8393, 7.1054>, <-10.9776, 52.00417, 5.2623> }
				triangle { <-10.825, 51.4595, 4.6983>, <-10.8773, 51.9798, 5.3168>, <-10.9776, 52.00417, 5.2623> }
				triangle { <-10.825, 51.4595, 4.6983>, <-10.9776, 52.00417, 5.2623>, <-10.9099, 51.4758, 4.6514> }
				triangle { <-10.825, 51.4595, 4.6983>, <-10.9099, 51.4758, 4.6514>, <-10.5792, 50.7459, 3.4726> }
				triangle { <-10.7641, 54.9323, 7.9147>, <-10.8006, 53.8393, 7.1054>, <-10.6348, 53.8324, 7.1392> }
				triangle { <-10.9776, 52.00417, 5.2623>, <-10.8006, 53.8393, 7.1054>, <-10.9494, 53.9561, 7.0103> }
				triangle { <-10.774, 51.946, 5.3551>, <-10.6348, 53.8324, 7.1392>, <-10.8006, 53.8393, 7.1054> }
				triangle { <-10.7641, 54.9323, 7.9147>, <-10.9494, 53.9561, 7.0103>, <-10.8006, 53.8393, 7.1054> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-10.3777, 50.01096, 2.8509>, <-10.799, 51.2529, 3.04439>, 0.1069 }
				cylinder { <-10.799, 51.2529, 3.04439>, <-11.1951, 52.5081, 3.2015>, 0.1069 }
				cylinder { <-11.1951, 52.5081, 3.2015>, <-11.5657, 53.7752, 3.3224>, 0.1069 }
				cylinder { <-11.5657, 53.7752, 3.3224>, <-11.9102, 55.05254, 3.4067>, 0.1069 }
				cylinder { <-11.9102, 55.05254, 3.4067>, <-12.2283, 56.3385, 3.4543>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-12.2283, 56.3385, 3.4543>, <-12.2815, 56.5314, 3.4223>, 0.003434 }
				cylinder { <-12.2815, 56.5314, 3.4223>, <-12.3374, 56.7131, 3.3523>, 0.003434 }
				cylinder { <-12.3374, 56.7131, 3.3523>, <-12.3937, 56.8768, 3.2469>, 0.003434 }
				cylinder { <-12.3937, 56.8768, 3.2469>, <-12.4483, 57.01606, 3.1102>, 0.003434 }
				cylinder { <-12.4483, 57.01606, 3.1102>, <-12.4991, 57.1255, 2.9475>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-12.4991, 57.1255, 2.9475>, <-12.8968, 57.9112, 1.8303>, <-12.9746, 57.8505, 1.7984> }
				triangle { <-12.8968, 57.9112, 1.8303>, <-13.03922, 58.2988, 1.1161>, <-12.9746, 57.8505, 1.7984> }
				triangle { <-13.03922, 58.2988, 1.1161>, <-13.1028, 58.2086, 1.08339>, <-12.9746, 57.8505, 1.7984> }
				triangle { <-13.03922, 58.2988, 1.1161>, <-13.1666, 59.2605, -1.2729>, <-13.1028, 58.2086, 1.08339> }
				triangle { <-13.1028, 58.2086, 1.08339>, <-13.1666, 59.2605, -1.2729>, <-13.1605, 58.1087, 1.06575> }
				triangle { <-12.9746, 57.8505, 1.7984>, <-13.1028, 58.2086, 1.08339>, <-13.1605, 58.1087, 1.06575> }
				triangle { <-12.9746, 57.8505, 1.7984>, <-13.1605, 58.1087, 1.06575>, <-13.02441, 57.7663, 1.7877> }
				triangle { <-12.9746, 57.8505, 1.7984>, <-13.02441, 57.7663, 1.7877>, <-12.4991, 57.1255, 2.9475> }
				triangle { <-13.1159, 59.6716, -2.5687>, <-13.1666, 59.2605, -1.2729>, <-13.03875, 59.3698, -1.2531> }
				triangle { <-13.1605, 58.1087, 1.06575>, <-13.1666, 59.2605, -1.2729>, <-13.2214, 59.07921, -1.3674> }
				triangle { <-13.03922, 58.2988, 1.1161>, <-13.03875, 59.3698, -1.2531>, <-13.1666, 59.2605, -1.2729> }
				triangle { <-13.1159, 59.6716, -2.5687>, <-13.2214, 59.07921, -1.3674>, <-13.1666, 59.2605, -1.2729> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-12.2283, 56.3385, 3.4543>, <-12.2769, 56.5351, 3.4616>, 0.003434 }
				cylinder { <-12.2769, 56.5351, 3.4616>, <-12.3255, 56.7316, 3.4689>, 0.003434 }
				cylinder { <-12.3255, 56.7316, 3.4689>, <-12.3741, 56.9282, 3.4762>, 0.003434 }
				cylinder { <-12.3741, 56.9282, 3.4762>, <-12.4228, 57.1248, 3.4835>, 0.003434 }
				cylinder { <-12.4228, 57.1248, 3.4835>, <-12.4714, 57.3213, 3.4908>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-12.4714, 57.3213, 3.4908>, <-12.8452, 58.6909, 3.5801>, <-12.9381, 58.6824, 3.5347> }
				triangle { <-12.8452, 58.6909, 3.5801>, <-13.00114, 59.4987, 3.5183>, <-12.9381, 58.6824, 3.5347> }
				triangle { <-13.00114, 59.4987, 3.5183>, <-13.08687, 59.4735, 3.4456>, <-12.9381, 58.6824, 3.5347> }
				triangle { <-13.00114, 59.4987, 3.5183>, <-13.2583, 62.00254, 2.9583>, <-13.08687, 59.4735, 3.4456> }
				triangle { <-13.08687, 59.4735, 3.4456>, <-13.2583, 62.00254, 2.9583>, <-13.1668, 59.4303, 3.3724> }
				triangle { <-12.9381, 58.6824, 3.5347>, <-13.08687, 59.4735, 3.4456>, <-13.1668, 59.4303, 3.3724> }
				triangle { <-12.9381, 58.6824, 3.5347>, <-13.1668, 59.4303, 3.3724>, <-13.00603, 58.6426, 3.4757> }
				triangle { <-12.9381, 58.6824, 3.5347>, <-13.00603, 58.6426, 3.4757>, <-12.4714, 57.3213, 3.4908> }
				triangle { <-13.306, 63.2951, 2.5367>, <-13.2583, 62.00254, 2.9583>, <-13.1082, 62.04879, 3.02185> }
				triangle { <-13.1668, 59.4303, 3.3724>, <-13.2583, 62.00254, 2.9583>, <-13.3641, 61.9744, 2.777> }
				triangle { <-13.00114, 59.4987, 3.5183>, <-13.1082, 62.04879, 3.02185>, <-13.2583, 62.00254, 2.9583> }
				triangle { <-13.306, 63.2951, 2.5367>, <-13.3641, 61.9744, 2.777>, <-13.2583, 62.00254, 2.9583> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.4593, 6.2954, -0.06813>, 0.1069 }
			cylinder { <0.4593, 6.2954, -0.06813>, <1.3755, 12.5396, -0.204>, 0.1069 }
			cylinder { <1.3755, 12.5396, -0.204>, <2.7436, 18.6988, -0.4069>, 0.1069 }
			cylinder { <2.7436, 18.6988, -0.4069>, <4.5563, 24.7396, -0.6758>, 0.1069 }
			cylinder { <4.5563, 24.7396, -0.6758>, <6.8035, 30.6291, -1.009214>, 0.1069 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <6.8035, 30.6291, -1.009214>, <7.2801, 31.8656, -1.04701>, 0.1069 }
				cylinder { <7.2801, 31.8656, -1.04701>, <7.761, 33.1009, -1.05259>, 0.1069 }
				cylinder { <7.761, 33.1009, -1.05259>, <8.2459, 34.3344, -1.02594>, 0.1069 }
				cylinder { <8.2459, 34.3344, -1.02594>, <8.7347, 35.5652, -0.967>, 0.1069 }
				cylinder { <8.7347, 35.5652, -0.967>, <9.2268, 36.7927, -0.876>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <9.2268, 36.7927, -0.876>, <9.299, 36.9818, -0.8867>, 0.003434 }
				cylinder { <9.299, 36.9818, -0.8867>, <9.3669, 37.1694, -0.9218>, 0.003434 }
				cylinder { <9.3669, 37.1694, -0.9218>, <9.4297, 37.3528, -0.9809>, 0.003434 }
				cylinder { <9.4297, 37.3528, -0.9809>, <9.4863, 37.5291, -1.06308>, 0.003434 }
				cylinder { <9.4863, 37.5291, -1.06308>, <9.5359, 37.6959, -1.167>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <9.5359, 37.6959, -1.167>, <9.669, 38.9035, -1.9067>, <9.7711, 38.9161, -1.8935> }
				triangle { <9.669, 38.9035, -1.9067>, <9.7184, 39.6635, -2.224>, <9.7711, 38.9161, -1.8935> }
				triangle { <9.7184, 39.6635, -2.224>, <9.8238, 39.6724, -2.1784>, <9.7711, 38.9161, -1.8935> }
				triangle { <9.7184, 39.6635, -2.224>, <9.7609, 42.1722, -2.8186>, <9.8238, 39.6724, -2.1784> }
				triangle { <9.8238, 39.6724, -2.1784>, <9.7609, 42.1722, -2.8186>, <9.9265, 39.6651, -2.1233> }
				triangle { <9.7711, 38.9161, -1.8935>, <9.8238, 39.6724, -2.1784>, <9.9265, 39.6651, -2.1233> }
				triangle { <9.7711, 38.9161, -1.8935>, <9.9265, 39.6651, -2.1233>, <9.8579, 38.9058, -1.8482> }
				triangle { <9.7711, 38.9161, -1.8935>, <9.8579, 38.9058, -1.8482>, <9.5359, 37.6959, -1.167> }
				triangle { <9.7394, 43.5223, -2.9847>, <9.7609, 42.1722, -2.8186>, <9.594, 42.1855, -2.8444> }
				triangle { <9.9265, 39.6651, -2.1233>, <9.7609, 42.1722, -2.8186>, <9.9163, 42.2246, -2.6847> }
				triangle { <9.7184, 39.6635, -2.224>, <9.594, 42.1855, -2.8444>, <9.7609, 42.1722, -2.8186> }
				triangle { <9.7394, 43.5223, -2.9847>, <9.9163, 42.2246, -2.6847>, <9.7609, 42.1722, -2.8186> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <9.2268, 36.7927, -0.876>, <9.7489, 38.0082, -0.7894>, 0.1069 }
				cylinder { <9.7489, 38.0082, -0.7894>, <10.3005, 39.2108, -0.7074>, 0.1069 }
				cylinder { <10.3005, 39.2108, -0.7074>, <10.8814, 40.3999, -0.63>, 0.1069 }
				cylinder { <10.8814, 40.3999, -0.63>, <11.4911, 41.5747, -0.5572>, 0.1069 }
				cylinder { <11.4911, 41.5747, -0.5572>, <12.1294, 42.7346, -0.489>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <12.1294, 42.7346, -0.489>, <12.2289, 42.9065, -0.4493>, 0.003434 }
				cylinder { <12.2289, 42.9065, -0.4493>, <12.3283, 43.06952, -0.3812>, 0.003434 }
				cylinder { <12.3283, 43.06952, -0.3812>, <12.4253, 43.2198, -0.2862>, 0.003434 }
				cylinder { <12.4253, 43.2198, -0.2862>, <12.5179, 43.3544, -0.1663>, 0.003434 }
				cylinder { <12.5179, 43.3544, -0.1663>, <12.6041, 43.4702, -0.02418>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <12.6041, 43.4702, -0.02418>, <13.0326, 44.4105, 0.9533>, <13.1096, 44.3539, 0.9935> }
				triangle { <13.0326, 44.4105, 0.9533>, <13.1924, 44.9009, 1.5973>, <13.1096, 44.3539, 0.9935> }
				triangle { <13.1924, 44.9009, 1.5973>, <13.2547, 44.8155, 1.6429>, <13.1096, 44.3539, 0.9935> }
				triangle { <13.1924, 44.9009, 1.5973>, <13.3719, 46.2177, 3.8069>, <13.2547, 44.8155, 1.6429> }
				triangle { <13.2547, 44.8155, 1.6429>, <13.3719, 46.2177, 3.8069>, <13.3107, 44.7183, 1.6752> }
				triangle { <13.1096, 44.3539, 0.9935>, <13.2547, 44.8155, 1.6429>, <13.3107, 44.7183, 1.6752> }
				triangle { <13.1096, 44.3539, 0.9935>, <13.3107, 44.7183, 1.6752>, <13.1579, 44.2713, 1.0166> }
				triangle { <13.1096, 44.3539, 0.9935>, <13.1579, 44.2713, 1.0166>, <12.6041, 43.4702, -0.02418> }
				triangle { <13.3472, 46.8254, 5.02392>, <13.3719, 46.2177, 3.8069>, <13.2458, 46.3254, 3.7718> }
				triangle { <13.3107, 44.7183, 1.6752>, <13.3719, 46.2177, 3.8069>, <13.4244, 46.05212, 3.9278> }
				triangle { <13.1924, 44.9009, 1.5973>, <13.2458, 46.3254, 3.7718>, <13.3719, 46.2177, 3.8069> }
				triangle { <13.3472, 46.8254, 5.02392>, <13.4244, 46.05212, 3.9278>, <13.3719, 46.2177, 3.8069> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <12.1294, 42.7346, -0.489>, <12.7676, 43.8945, -0.4209>, 0.1069 }
				cylinder { <12.7676, 43.8945, -0.4209>, <13.4059, 45.05437, -0.3527>, 0.1069 }
				cylinder { <13.4059, 45.05437, -0.3527>, <14.04416, 46.2142, -0.2846>, 0.1069 }
				cylinder { <14.04416, 46.2142, -0.2846>, <14.6824, 47.3741, -0.2165>, 0.1069 }
				cylinder { <14.6824, 47.3741, -0.2165>, <15.3206, 48.534, -0.1483>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <15.3206, 48.534, -0.1483>, <15.4141, 48.7127, -0.1674>, 0.003434 }
				cylinder { <15.4141, 48.7127, -0.1674>, <15.5014, 48.8891, -0.2156>, 0.003434 }
				cylinder { <15.5014, 48.8891, -0.2156>, <15.5808, 49.05929, -0.2917>, 0.003434 }
				cylinder { <15.5808, 49.05929, -0.2917>, <15.6504, 49.2195, -0.3943>, 0.003434 }
				cylinder { <15.6504, 49.2195, -0.3943>, <15.7088, 49.3664, -0.5211>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <15.7088, 49.3664, -0.5211>, <15.9083, 50.4563, -1.4131>, <16.01186, 50.4593, -1.4076> }
				triangle { <15.9083, 50.4563, -1.4131>, <16.01028, 51.1635, -1.8257>, <16.01186, 50.4593, -1.4076> }
				triangle { <16.01028, 51.1635, -1.8257>, <16.119, 51.1663, -1.7878>, <16.01186, 50.4593, -1.4076> }
				triangle { <16.01028, 51.1635, -1.8257>, <16.2593, 53.5645, -2.7321>, <16.119, 51.1663, -1.7878> }
				triangle { <16.119, 51.1663, -1.7878>, <16.2593, 53.5645, -2.7321>, <16.2241, 51.1547, -1.7383> }
				triangle { <16.01186, 50.4593, -1.4076>, <16.119, 51.1663, -1.7878>, <16.2241, 51.1547, -1.7383> }
				triangle { <16.01186, 50.4593, -1.4076>, <16.2241, 51.1547, -1.7383>, <16.1001, 50.4452, -1.3665> }
				triangle { <16.01186, 50.4593, -1.4076>, <16.1001, 50.4452, -1.3665>, <15.7088, 49.3664, -0.5211> }
				triangle { <16.3602, 54.8798, -3.06491>, <16.2593, 53.5645, -2.7321>, <16.09317, 53.5925, -2.7496> }
				triangle { <16.2241, 51.1547, -1.7383>, <16.2593, 53.5645, -2.7321>, <16.4282, 53.6155, -2.6152> }
				triangle { <16.01028, 51.1635, -1.8257>, <16.09317, 53.5925, -2.7496>, <16.2593, 53.5645, -2.7321> }
				triangle { <16.3602, 54.8798, -3.06491>, <16.4282, 53.6155, -2.6152>, <16.2593, 53.5645, -2.7321> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <15.3206, 48.534, -0.1483>, <15.9589, 49.6938, -0.08023>, 0.1069 }
				cylinder { <15.9589, 49.6938, -0.08023>, <16.5971, 50.8537, -0.01209>, 0.1069 }
				cylinder { <16.5971, 50.8537, -0.01209>, <17.2353, 52.01364, 0.05604>, 0.1069 }
				cylinder { <17.2353, 52.01364, 0.05604>, <17.8736, 53.1735, 0.1241>, 0.1069 }
				cylinder { <17.8736, 53.1735, 0.1241>, <18.5118, 54.3334, 0.1923>, 0.1069 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <18.5118, 54.3334, 0.1923>, <18.6114, 54.5053, 0.232>, 0.003434 }
				cylinder { <18.6114, 54.5053, 0.232>, <18.7107, 54.6683, 0.3>, 0.003434 }
				cylinder { <18.7107, 54.6683, 0.3>, <18.8078, 54.8186, 0.3951>, 0.003434 }
				cylinder { <18.8078, 54.8186, 0.3951>, <18.9004, 54.9532, 0.515>, 0.003434 }
				cylinder { <18.9004, 54.9532, 0.515>, <18.9865, 55.06903, 0.6572>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <18.9865, 55.06903, 0.6572>, <19.415, 56.00934, 1.6347>, <19.4921, 55.9526, 1.6749> }
				triangle { <19.415, 56.00934, 1.6347>, <19.5749, 56.4997, 2.2786>, <19.4921, 55.9526, 1.6749> }
				triangle { <19.5749, 56.4997, 2.2786>, <19.6372, 56.4143, 2.3243>, <19.4921, 55.9526, 1.6749> }
				triangle { <19.5749, 56.4997, 2.2786>, <19.7543, 57.8165, 4.4883>, <19.6372, 56.4143, 2.3243> }
				triangle { <19.6372, 56.4143, 2.3243>, <19.7543, 57.8165, 4.4883>, <19.6932, 56.317, 2.3566> }
				triangle { <19.4921, 55.9526, 1.6749>, <19.6372, 56.4143, 2.3243>, <19.6932, 56.317, 2.3566> }
				triangle { <19.4921, 55.9526, 1.6749>, <19.6932, 56.317, 2.3566>, <19.5403, 55.8701, 1.6979> }
				triangle { <19.4921, 55.9526, 1.6749>, <19.5403, 55.8701, 1.6979>, <18.9865, 55.06903, 0.6572> }
				triangle { <19.7296, 58.4242, 5.7053>, <19.7543, 57.8165, 4.4883>, <19.6283, 57.9241, 4.4532> }
				triangle { <19.6932, 56.317, 2.3566>, <19.7543, 57.8165, 4.4883>, <19.8069, 57.6508, 4.6092> }
				triangle { <19.5749, 56.4997, 2.2786>, <19.6283, 57.9241, 4.4532>, <19.7543, 57.8165, 4.4883> }
				triangle { <19.7296, 58.4242, 5.7053>, <19.8069, 57.6508, 4.6092>, <19.7543, 57.8165, 4.4883> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <18.5118, 54.3334, 0.1923>, <18.6099, 54.51, 0.2076>, 0.003434 }
				cylinder { <18.6099, 54.51, 0.2076>, <18.7083, 54.6859, 0.2278>, 0.003434 }
				cylinder { <18.7083, 54.6859, 0.2278>, <18.8071, 54.8611, 0.2529>, 0.003434 }
				cylinder { <18.8071, 54.8611, 0.2529>, <18.9062, 55.03526, 0.2829>, 0.003434 }
				cylinder { <18.9062, 55.03526, 0.2829>, <19.00564, 55.2083, 0.3178>, 0.003434 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <19.00564, 55.2083, 0.3178>, <19.5092, 56.5208, 0.5351>, <19.6018, 56.4934, 0.5732> }
				triangle { <19.5092, 56.5208, 0.5351>, <19.7444, 57.2736, 0.7773>, <19.6018, 56.4934, 0.5732> }
				triangle { <19.7444, 57.2736, 0.7773>, <19.8288, 57.2243, 0.8383>, <19.6018, 56.4934, 0.5732> }
				triangle { <19.7444, 57.2736, 0.7773>, <20.2562, 59.5398, 1.8958>, <19.8288, 57.2243, 0.8383> }
				triangle { <19.8288, 57.2243, 0.8383>, <20.2562, 59.5398, 1.8958>, <19.9056, 57.1579, 0.8959> }
				triangle { <19.6018, 56.4934, 0.5732>, <19.8288, 57.2243, 0.8383>, <19.9056, 57.1579, 0.8959> }
				triangle { <19.6018, 56.4934, 0.5732>, <19.9056, 57.1579, 0.8959>, <19.6667, 56.4348, 0.6183> }
				triangle { <19.6018, 56.4934, 0.5732>, <19.6667, 56.4348, 0.6183>, <19.00564, 55.2083, 0.3178> }
				triangle { <20.4385, 60.6861, 2.6056>, <20.2562, 59.5398, 1.8958>, <20.11, 59.6131, 1.8514> }
				triangle { <19.9056, 57.1579, 0.8959>, <20.2562, 59.5398, 1.8958>, <20.3625, 59.4602, 2.06075> }
				triangle { <19.7444, 57.2736, 0.7773>, <20.11, 59.6131, 1.8514>, <20.2562, 59.5398, 1.8958> }
				triangle { <20.4385, 60.6861, 2.6056>, <20.3625, 59.4602, 2.06075>, <20.2562, 59.5398, 1.8958> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1874, 3.05612, 0.1252>, 0.05193 }
			cylinder { <0.1874, 3.05612, 0.1252>, <0.5613, 6.08738, 0.375>, 0.05193 }
			cylinder { <0.5613, 6.08738, 0.375>, <1.1195, 9.07736, 0.748>, 0.05193 }
			cylinder { <1.1195, 9.07736, 0.748>, <1.8592, 12.00984, 1.2422>, 0.05193 }
			cylinder { <1.8592, 12.00984, 1.2422>, <2.7762, 14.8689, 1.855>, 0.05193 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.7762, 14.8689, 1.855>, <2.9896, 15.4632, 1.9786>, 0.05193 }
				cylinder { <2.9896, 15.4632, 1.9786>, <3.2238, 16.05089, 2.09715>, 0.05193 }
				cylinder { <3.2238, 16.05089, 2.09715>, <3.4783, 16.631, 2.2103>, 0.05193 }
				cylinder { <3.4783, 16.631, 2.2103>, <3.7528, 17.2029, 2.3181>, 0.05193 }
				cylinder { <3.7528, 17.2029, 2.3181>, <4.04718, 17.766, 2.4203>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.04718, 17.766, 2.4203>, <4.07286, 17.8063, 2.4208>, 0.0008093 }
				cylinder { <4.07286, 17.8063, 2.4208>, <4.1016, 17.8438, 2.4142>, 0.0008093 }
				cylinder { <4.1016, 17.8438, 2.4142>, <4.1326, 17.8775, 2.4007>, 0.0008093 }
				cylinder { <4.1326, 17.8775, 2.4007>, <4.1649, 17.9064, 2.3808>, 0.0008093 }
				cylinder { <4.1649, 17.9064, 2.3808>, <4.1976, 17.9297, 2.3549>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.1976, 17.9297, 2.3549>, <4.6483, 18.2615, 1.9503>, <4.6856, 18.2652, 1.9839> }
				triangle { <4.6483, 18.2615, 1.9503>, <4.8819, 18.5065, 1.7363>, <4.6856, 18.2652, 1.9839> }
				triangle { <4.8819, 18.5065, 1.7363>, <4.9118, 18.5161, 1.7827>, <4.6856, 18.2652, 1.9839> }
				triangle { <4.8819, 18.5065, 1.7363>, <5.4947, 19.4266, 1.1492>, <4.9118, 18.5161, 1.7827> }
				triangle { <4.9118, 18.5161, 1.7827>, <5.4947, 19.4266, 1.1492>, <4.9353, 18.5212, 1.834> }
				triangle { <4.6856, 18.2652, 1.9839>, <4.9118, 18.5161, 1.7827>, <4.9353, 18.5212, 1.834> }
				triangle { <4.6856, 18.2652, 1.9839>, <4.9353, 18.5212, 1.834>, <4.7051, 18.2675, 2.02753> }
				triangle { <4.6856, 18.2652, 1.9839>, <4.7051, 18.2675, 2.02753>, <4.1976, 17.9297, 2.3549> }
				triangle { <5.7693, 19.9598, 0.8727>, <5.4947, 19.4266, 1.1492>, <5.4408, 19.4338, 1.08755> }
				triangle { <4.9353, 18.5212, 1.834>, <5.4947, 19.4266, 1.1492>, <5.529, 19.473, 1.2342> }
				triangle { <4.8819, 18.5065, 1.7363>, <5.4408, 19.4338, 1.08755>, <5.4947, 19.4266, 1.1492> }
				triangle { <5.7693, 19.9598, 0.8727>, <5.529, 19.473, 1.2342>, <5.4947, 19.4266, 1.1492> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.04718, 17.766, 2.4203>, <4.3608, 18.3196, 2.5168>, 0.05193 }
				cylinder { <4.3608, 18.3196, 2.5168>, <4.6935, 18.8629, 2.6076>, 0.05193 }
				cylinder { <4.6935, 18.8629, 2.6076>, <5.04483, 19.3954, 2.6925>, 0.05193 }
				cylinder { <5.04483, 19.3954, 2.6925>, <5.4143, 19.9163, 2.7714>, 0.05193 }
				cylinder { <5.4143, 19.9163, 2.7714>, <5.8015, 20.4251, 2.8443>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.8015, 20.4251, 2.8443>, <5.8268, 20.464, 2.8557>, 0.0008093 }
				cylinder { <5.8268, 20.464, 2.8557>, <5.8481, 20.5031, 2.8729>, 0.0008093 }
				cylinder { <5.8481, 20.5031, 2.8729>, <5.8649, 20.5416, 2.8955>, 0.0008093 }
				cylinder { <5.8649, 20.5416, 2.8955>, <5.877, 20.5787, 2.9231>, 0.0008093 }
				cylinder { <5.877, 20.5787, 2.9231>, <5.884, 20.6136, 2.9549>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.884, 20.6136, 2.9549>, <5.9831, 21.1428, 3.3873>, <5.9933, 21.1157, 3.4285> }
				triangle { <5.9831, 21.1428, 3.3873>, <5.9785, 21.4469, 3.6479>, <5.9933, 21.1157, 3.4285> }
				triangle { <5.9785, 21.4469, 3.6479>, <5.9766, 21.4094, 3.6893>, <5.9933, 21.1157, 3.4285> }
				triangle { <5.9785, 21.4469, 3.6479>, <5.756, 22.3663, 4.4677>, <5.9766, 21.4094, 3.6893> }
				triangle { <5.9766, 21.4094, 3.6893>, <5.756, 22.3663, 4.4677>, <5.9734, 21.3652, 3.7246> }
				triangle { <5.9933, 21.1157, 3.4285>, <5.9766, 21.4094, 3.6893>, <5.9734, 21.3652, 3.7246> }
				triangle { <5.9933, 21.1157, 3.4285>, <5.9734, 21.3652, 3.7246>, <5.9919, 21.07747, 3.4569> }
				triangle { <5.9933, 21.1157, 3.4285>, <5.9919, 21.07747, 3.4569>, <5.884, 20.6136, 2.9549> }
				triangle { <5.5652, 22.8333, 4.8939>, <5.756, 22.3663, 4.4677>, <5.7347, 22.4222, 4.4112> }
				triangle { <5.9734, 21.3652, 3.7246>, <5.756, 22.3663, 4.4677>, <5.7184, 22.306, 4.542> }
				triangle { <5.9785, 21.4469, 3.6479>, <5.7347, 22.4222, 4.4112>, <5.756, 22.3663, 4.4677> }
				triangle { <5.5652, 22.8333, 4.8939>, <5.7184, 22.306, 4.542>, <5.756, 22.3663, 4.4677> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <5.8015, 20.4251, 2.8443>, <6.1887, 20.934, 2.9171>, 0.05193 }
				cylinder { <6.1887, 20.934, 2.9171>, <6.5759, 21.4428, 2.99>, 0.05193 }
				cylinder { <6.5759, 21.4428, 2.99>, <6.9631, 21.9516, 3.06285>, 0.05193 }
				cylinder { <6.9631, 21.9516, 3.06285>, <7.3503, 22.4604, 3.1357>, 0.05193 }
				cylinder { <7.3503, 22.4604, 3.1357>, <7.7375, 22.9692, 3.2085>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <7.7375, 22.9692, 3.2085>, <7.7691, 23.00509, 3.2078>, 0.0008093 }
				cylinder { <7.7691, 23.00509, 3.2078>, <7.8027, 23.03824, 3.2009>, 0.0008093 }
				cylinder { <7.8027, 23.03824, 3.2009>, <7.8378, 23.06797, 3.188>, 0.0008093 }
				cylinder { <7.8378, 23.06797, 3.188>, <7.8735, 23.09366, 3.1695>, 0.0008093 }
				cylinder { <7.8735, 23.09366, 3.1695>, <7.9091, 23.1147, 3.1456>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <7.9091, 23.1147, 3.1456>, <8.4019, 23.4192, 2.7698>, <8.4386, 23.417, 2.8042> }
				triangle { <8.4019, 23.4192, 2.7698>, <8.6651, 23.6498, 2.575>, <8.4386, 23.417, 2.8042> }
				triangle { <8.6651, 23.6498, 2.575>, <8.6947, 23.6535, 2.6223>, <8.4386, 23.417, 2.8042> }
				triangle { <8.6651, 23.6498, 2.575>, <9.3853, 24.5316, 2.05466>, <8.6947, 23.6535, 2.6223> }
				triangle { <8.6947, 23.6535, 2.6223>, <9.3853, 24.5316, 2.05466>, <8.7173, 23.6532, 2.6742> }
				triangle { <8.4386, 23.417, 2.8042>, <8.6947, 23.6535, 2.6223>, <8.7173, 23.6532, 2.6742> }
				triangle { <8.4386, 23.417, 2.8042>, <8.7173, 23.6532, 2.6742>, <8.4571, 23.4148, 2.8482> }
				triangle { <8.4386, 23.417, 2.8042>, <8.4571, 23.4148, 2.8482>, <7.9091, 23.1147, 3.1456> }
				triangle { <9.7211, 25.04752, 1.8153>, <9.3853, 24.5316, 2.05466>, <9.334, 24.5479, 1.9925> }
				triangle { <8.7173, 23.6532, 2.6742>, <9.3853, 24.5316, 2.05466>, <9.4222, 24.5691, 2.1429> }
				triangle { <8.6651, 23.6498, 2.575>, <9.334, 24.5479, 1.9925>, <9.3853, 24.5316, 2.05466> }
				triangle { <9.7211, 25.04752, 1.8153>, <9.4222, 24.5691, 2.1429>, <9.3853, 24.5316, 2.05466> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <7.7375, 22.9692, 3.2085>, <8.142, 23.4653, 3.2752>, 0.05193 }
				cylinder { <8.142, 23.4653, 3.2752>, <8.5633, 23.948, 3.3357>, 0.05193 }
				cylinder { <8.5633, 23.948, 3.3357>, <9.000878, 24.4167, 3.3899>, 0.05193 }
				cylinder { <9.000878, 24.4167, 3.3899>, <9.4541, 24.871, 3.4377>, 0.05193 }
				cylinder { <9.4541, 24.871, 3.4377>, <9.9227, 25.3102, 3.4792>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <9.9227, 25.3102, 3.4792>, <9.9545, 25.3446, 3.4884>, 0.0008093 }
				cylinder { <9.9545, 25.3446, 3.4884>, <9.9827, 25.38, 3.5035>, 0.0008093 }
				cylinder { <9.9827, 25.38, 3.5035>, <10.0067, 25.4158, 3.5242>, 0.0008093 }
				cylinder { <10.0067, 25.4158, 3.5242>, <10.02592, 25.451, 3.5501>, 0.0008093 }
				cylinder { <10.02592, 25.451, 3.5501>, <10.03996, 25.485, 3.5806>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.03996, 25.485, 3.5806>, <10.244, 26.00066, 3.992>, <10.2515, 25.9732, 4.03364> }
				triangle { <10.244, 26.00066, 3.992>, <10.3012, 26.3074, 4.2431>, <10.2515, 25.9732, 4.03364> }
				triangle { <10.3012, 26.3074, 4.2431>, <10.2951, 26.2717, 4.2857>, <10.2515, 25.9732, 4.03364> }
				triangle { <10.3012, 26.3074, 4.2431>, <10.27, 27.2701, 5.0425>, <10.2951, 26.2717, 4.2857> }
				triangle { <10.2951, 26.2717, 4.2857>, <10.27, 27.2701, 5.0425>, <10.2862, 26.2295, 4.3225> }
				triangle { <10.2515, 25.9732, 4.03364>, <10.2951, 26.2717, 4.2857>, <10.2862, 26.2295, 4.3225> }
				triangle { <10.2515, 25.9732, 4.03364>, <10.2862, 26.2295, 4.3225>, <10.245, 25.9363, 4.06332> }
				triangle { <10.2515, 25.9732, 4.03364>, <10.245, 25.9363, 4.06332>, <10.03996, 25.485, 3.5806> }
				triangle { <10.1779, 27.7723, 5.4614>, <10.27, 27.2701, 5.0425>, <10.2557, 27.3274, 4.9852> }
				triangle { <10.2862, 26.2295, 4.3225>, <10.27, 27.2701, 5.0425>, <10.2264, 27.2187, 5.12> }
				triangle { <10.3012, 26.3074, 4.2431>, <10.2557, 27.3274, 4.9852>, <10.27, 27.2701, 5.0425> }
				triangle { <10.1779, 27.7723, 5.4614>, <10.2264, 27.2187, 5.12>, <10.27, 27.2701, 5.0425> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <9.9227, 25.3102, 3.4792>, <9.9574, 25.3428, 3.4823>, 0.0008093 }
				cylinder { <9.9574, 25.3428, 3.4823>, <9.9922, 25.3754, 3.4853>, 0.0008093 }
				cylinder { <9.9922, 25.3754, 3.4853>, <10.02699, 25.408, 3.4884>, 0.0008093 }
				cylinder { <10.02699, 25.408, 3.4884>, <10.06175, 25.4406, 3.4915>, 0.0008093 }
				cylinder { <10.06175, 25.4406, 3.4915>, <10.09652, 25.4732, 3.4946>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.09652, 25.4732, 3.4946>, <10.5902, 25.9558, 3.504>, <10.6119, 25.9421, 3.5473> }
				triangle { <10.5902, 25.9558, 3.504>, <10.8341, 26.2716, 3.5387>, <10.6119, 25.9421, 3.5473> }
				triangle { <10.8341, 26.2716, 3.5387>, <10.8432, 26.2569, 3.5919>, <10.6119, 25.9421, 3.5473> }
				triangle { <10.8341, 26.2716, 3.5387>, <11.4306, 27.3543, 3.7356>, <10.8432, 26.2569, 3.5919> }
				triangle { <10.8432, 26.2569, 3.5919>, <11.4306, 27.3543, 3.7356>, <10.8457, 26.2358, 3.6444> }
				triangle { <10.6119, 25.9421, 3.5473>, <10.8432, 26.2569, 3.5919>, <10.8457, 26.2358, 3.6444> }
				triangle { <10.6119, 25.9421, 3.5473>, <10.8457, 26.2358, 3.6444>, <10.6139, 25.9224, 3.5908> }
				triangle { <10.6119, 25.9421, 3.5473>, <10.6139, 25.9224, 3.5908>, <10.09652, 25.4732, 3.4946> }
				triangle { <11.68, 27.9513, 3.8683>, <11.4306, 27.3543, 3.7356>, <11.4016, 27.3916, 3.6683> }
				triangle { <10.8457, 26.2358, 3.6444>, <11.4306, 27.3543, 3.7356>, <11.4233, 27.3524, 3.8381> }
				triangle { <10.8341, 26.2716, 3.5387>, <11.4016, 27.3916, 3.6683>, <11.4306, 27.3543, 3.7356> }
				triangle { <11.68, 27.9513, 3.8683>, <11.4233, 27.3524, 3.8381>, <11.4306, 27.3543, 3.7356> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.1874, 3.05612, -0.1252>, 0.05193 }
			cylinder { <-0.1874, 3.05612, -0.1252>, <-0.5613, 6.08738, -0.375>, 0.05193 }
			cylinder { <-0.5613, 6.08738, -0.375>, <-1.1195, 9.07736, -0.748>, 0.05193 }
			cylinder { <-1.1195, 9.07736, -0.748>, <-1.8592, 12.00984, -1.2422>, 0.05193 }
			cylinder { <-1.8592, 12.00984, -1.2422>, <-2.7762, 14.8689, -1.855>, 0.05193 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-2.7762, 14.8689, -1.855>, <-2.9476, 15.4746, -1.9885>, 0.05193 }
				cylinder { <-2.9476, 15.4746, -1.9885>, <-3.09773, 16.08498, -2.1267>, 0.05193 }
				cylinder { <-3.09773, 16.08498, -2.1267>, <-3.2262, 16.6991, -2.2695>, 0.05193 }
				cylinder { <-3.2262, 16.6991, -2.2695>, <-3.3331, 17.3164, -2.4166>, 0.05193 }
				cylinder { <-3.3331, 17.3164, -2.4166>, <-3.4182, 17.9361, -2.5678>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.4182, 17.9361, -2.5678>, <-3.4278, 17.9824, -2.5743>, 0.0008093 }
				cylinder { <-3.4278, 17.9824, -2.5743>, <-3.4407, 18.02843, -2.5758>, 0.0008093 }
				cylinder { <-3.4407, 18.02843, -2.5758>, <-3.4567, 18.07333, -2.5725>, 0.0008093 }
				cylinder { <-3.4567, 18.07333, -2.5725>, <-3.4753, 18.1165, -2.5643>, 0.0008093 }
				cylinder { <-3.4753, 18.1165, -2.5643>, <-3.4965, 18.1572, -2.5514>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.4965, 18.1572, -2.5514>, <-3.7494, 18.7493, -2.3015>, <-3.7795, 18.7604, -2.3404> }
				triangle { <-3.7494, 18.7493, -2.3015>, <-3.8461, 19.1196, -2.1838>, <-3.7795, 18.7604, -2.3404> }
				triangle { <-3.8461, 19.1196, -2.1838>, <-3.8664, 19.1291, -2.235>, <-3.7795, 18.7604, -2.3404> }
				triangle { <-3.8461, 19.1196, -2.1838>, <-3.9694, 20.3349, -1.9102>, <-3.8664, 19.1291, -2.235> }
				triangle { <-3.8664, 19.1291, -2.235>, <-3.9694, 20.3349, -1.9102>, <-3.883, 19.1305, -2.2892> }
				triangle { <-3.7795, 18.7604, -2.3404>, <-3.8664, 19.1291, -2.235>, <-3.883, 19.1305, -2.2892> }
				triangle { <-3.7795, 18.7604, -2.3404>, <-3.883, 19.1305, -2.2892>, <-3.7941, 18.7596, -2.3858> }
				triangle { <-3.7795, 18.7604, -2.3404>, <-3.7941, 18.7596, -2.3858>, <-3.4965, 18.1572, -2.5514> }
				triangle { <-3.968, 20.9862, -1.801>, <-3.9694, 20.3349, -1.9102>, <-3.9205, 20.333, -1.8441> }
				triangle { <-3.883, 19.1305, -2.2892>, <-3.9694, 20.3349, -1.9102>, <-3.975, 20.3675, -2.007527> }
				triangle { <-3.8461, 19.1196, -2.1838>, <-3.9205, 20.333, -1.8441>, <-3.9694, 20.3349, -1.9102> }
				triangle { <-3.968, 20.9862, -1.801>, <-3.975, 20.3675, -2.007527>, <-3.9694, 20.3349, -1.9102> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.4182, 17.9361, -2.5678>, <-3.5032, 18.5558, -2.7191>, 0.05193 }
				cylinder { <-3.5032, 18.5558, -2.7191>, <-3.5883, 19.1755, -2.8704>, 0.05193 }
				cylinder { <-3.5883, 19.1755, -2.8704>, <-3.6734, 19.7952, -3.02168>, 0.05193 }
				cylinder { <-3.6734, 19.7952, -3.02168>, <-3.7584, 20.4149, -3.1729>, 0.05193 }
				cylinder { <-3.7584, 20.4149, -3.1729>, <-3.8435, 21.03462, -3.3242>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.8435, 21.03462, -3.3242>, <-3.8449, 21.07898, -3.3418>, 0.0008093 }
				cylinder { <-3.8449, 21.07898, -3.3418>, <-3.8415, 21.1204, -3.3653>, 0.0008093 }
				cylinder { <-3.8415, 21.1204, -3.3653>, <-3.8332, 21.1576, -3.394>, 0.0008093 }
				cylinder { <-3.8332, 21.1576, -3.394>, <-3.8205, 21.1897, -3.427>, 0.0008093 }
				cylinder { <-3.8205, 21.1897, -3.427>, <-3.8035, 21.2155, -3.4634>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.8035, 21.2155, -3.4634>, <-3.5106, 21.6274, -3.9339>, <-3.5289, 21.6045, -3.9749> }
				triangle { <-3.5106, 21.6274, -3.9339>, <-3.2916, 21.8271, -4.2033>, <-3.5289, 21.6045, -3.9749> }
				triangle { <-3.2916, 21.8271, -4.2033>, <-3.3063, 21.7889, -4.2414>, <-3.5289, 21.6045, -3.9749> }
				triangle { <-3.2916, 21.8271, -4.2033>, <-2.4588, 22.3075, -5.004923>, <-3.3063, 21.7889, -4.2414> }
				triangle { <-3.3063, 21.7889, -4.2414>, <-2.4588, 22.3075, -5.004923>, <-3.3248, 21.7456, -4.2729> }
				triangle { <-3.5289, 21.6045, -3.9749>, <-3.3063, 21.7889, -4.2414>, <-3.3248, 21.7456, -4.2729> }
				triangle { <-3.5289, 21.6045, -3.9749>, <-3.3248, 21.7456, -4.2729>, <-3.5463, 21.568, -4.000426> }
				triangle { <-3.5289, 21.6045, -3.9749>, <-3.5463, 21.568, -4.000426>, <-3.8035, 21.2155, -3.4634> }
				triangle { <-1.9724, 22.5058, -5.4052>, <-2.4588, 22.3075, -5.004923>, <-2.4169, 22.3498, -4.9482> }
				triangle { <-3.3248, 21.7456, -4.2729>, <-2.4588, 22.3075, -5.004923>, <-2.4539, 22.2252, -5.06636> }
				triangle { <-3.2916, 21.8271, -4.2033>, <-2.4169, 22.3498, -4.9482>, <-2.4588, 22.3075, -5.004923> }
				triangle { <-1.9724, 22.5058, -5.4052>, <-2.4539, 22.2252, -5.06636>, <-2.4588, 22.3075, -5.004923> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.8435, 21.03462, -3.3242>, <-3.9066, 21.6559, -3.4794>, 0.05193 }
				cylinder { <-3.9066, 21.6559, -3.4794>, <-3.9478, 22.2781, -3.6384>, 0.05193 }
				cylinder { <-3.9478, 22.2781, -3.6384>, <-3.9669, 22.9005, -3.801>, 0.05193 }
				cylinder { <-3.9669, 22.9005, -3.801>, <-3.9639, 23.5222, -3.967>, 0.05193 }
				cylinder { <-3.9639, 23.5222, -3.967>, <-3.9389, 24.1426, -4.1361>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.9389, 24.1426, -4.1361>, <-3.9405, 24.1897, -4.1441>, 0.0008093 }
				cylinder { <-3.9405, 24.1897, -4.1441>, <-3.9455, 24.2371, -4.1473>, 0.0008093 }
				cylinder { <-3.9455, 24.2371, -4.1473>, <-3.9539, 24.284, -4.1457>, 0.0008093 }
				cylinder { <-3.9539, 24.284, -4.1457>, <-3.9656, 24.3299, -4.1394>, 0.0008093 }
				cylinder { <-3.9656, 24.3299, -4.1394>, <-3.9803, 24.374, -4.1284>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.9803, 24.374, -4.1284>, <-4.1425, 25.00675, -3.9044>, <-4.1686, 25.02147, -3.9448> }
				triangle { <-4.1425, 25.00675, -3.9044>, <-4.1817, 25.3913, -3.7998>, <-4.1686, 25.02147, -3.9448> }
				triangle { <-4.1817, 25.3913, -3.7998>, <-4.1979, 25.4024, -3.8521>, <-4.1686, 25.02147, -3.9448> }
				triangle { <-4.1817, 25.3913, -3.7998>, <-4.1143, 26.618, -3.56>, <-4.1979, 25.4024, -3.8521> }
				triangle { <-4.1979, 25.4024, -3.8521>, <-4.1143, 26.618, -3.56>, <-4.2117, 25.4049, -3.907> }
				triangle { <-4.1686, 25.02147, -3.9448>, <-4.1979, 25.4024, -3.8521>, <-4.2117, 25.4049, -3.907> }
				triangle { <-4.1686, 25.02147, -3.9448>, <-4.2117, 25.4049, -3.907>, <-4.1812, 25.02173, -3.9909> }
				triangle { <-4.1686, 25.02147, -3.9448>, <-4.1812, 25.02173, -3.9909>, <-3.9803, 24.374, -4.1284> }
				triangle { <-4.01011, 27.2633, -3.4657>, <-4.1143, 26.618, -3.56>, <-4.06932, 26.6102, -3.4916> }
				triangle { <-4.2117, 25.4049, -3.907>, <-4.1143, 26.618, -3.56>, <-4.1103, 26.6482, -3.6581> }
				triangle { <-4.1817, 25.3913, -3.7998>, <-4.06932, 26.6102, -3.4916>, <-4.1143, 26.618, -3.56> }
				triangle { <-4.01011, 27.2633, -3.4657>, <-4.1103, 26.6482, -3.6581>, <-4.1143, 26.618, -3.56> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.9389, 24.1426, -4.1361>, <-3.9045, 24.7591, -4.3174>, 0.05193 }
				cylinder { <-3.9045, 24.7591, -4.3174>, <-3.8609, 25.3714, -4.5108>, 0.05193 }
				cylinder { <-3.8609, 25.3714, -4.5108>, <-3.808, 25.979, -4.716>, 0.05193 }
				cylinder { <-3.808, 25.979, -4.716>, <-3.7458, 26.5816, -4.9331>, 0.05193 }
				cylinder { <-3.7458, 26.5816, -4.9331>, <-3.6745, 27.1789, -5.1618>, 0.05193 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.6745, 27.1789, -5.1618>, <-3.6645, 27.2197, -5.1845>, 0.0008093 }
				cylinder { <-3.6645, 27.2197, -5.1845>, <-3.6502, 27.2558, -5.2123>, 0.0008093 }
				cylinder { <-3.6502, 27.2558, -5.2123>, <-3.6319, 27.2861, -5.2444>, 0.0008093 }
				cylinder { <-3.6319, 27.2861, -5.2444>, <-3.6102, 27.3097, -5.2797>, 0.0008093 }
				cylinder { <-3.6102, 27.3097, -5.2797>, <-3.5857, 27.326, -5.3174>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.5857, 27.326, -5.3174>, <-3.1797, 27.5948, -5.807>, <-3.2007, 27.5714, -5.8464> }
				triangle { <-3.1797, 27.5948, -5.807>, <-2.906, 27.7022, -6.07895>, <-3.2007, 27.5714, -5.8464> }
				triangle { <-2.906, 27.7022, -6.07895>, <-2.9273, 27.6637, -6.1134>, <-3.2007, 27.5714, -5.8464> }
				triangle { <-2.906, 27.7022, -6.07895>, <-1.9424, 27.8708, -6.86>, <-2.9273, 27.6637, -6.1134> }
				triangle { <-2.9273, 27.6637, -6.1134>, <-1.9424, 27.8708, -6.86>, <-2.9538, 27.6219, -6.1411> }
				triangle { <-3.2007, 27.5714, -5.8464>, <-2.9273, 27.6637, -6.1134>, <-2.9538, 27.6219, -6.1411> }
				triangle { <-3.2007, 27.5714, -5.8464>, <-2.9538, 27.6219, -6.1411>, <-3.2249, 27.5369, -5.8688> }
				triangle { <-3.2007, 27.5714, -5.8464>, <-3.2249, 27.5369, -5.8688>, <-3.5857, 27.326, -5.3174> }
				triangle { <-1.4026, 27.8989, -7.2395>, <-1.9424, 27.8708, -6.86>, <-1.8948, 27.9097, -6.8053> }
				triangle { <-2.9538, 27.6219, -6.1411>, <-1.9424, 27.8708, -6.86>, <-1.9539, 27.7822, -6.9108> }
				triangle { <-2.906, 27.7022, -6.07895>, <-1.8948, 27.9097, -6.8053>, <-1.9424, 27.8708, -6.86> }
				triangle { <-1.4026, 27.8989, -7.2395>, <-1.9539, 27.7822, -6.9108>, <-1.9424, 27.8708, -6.86> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-3.6745, 27.1789, -5.1618>, <-3.6692, 27.2232, -5.1788>, 0.0008093 }
				cylinder { <-3.6692, 27.2232, -5.1788>, <-3.6639, 27.2675, -5.1957>, 0.0008093 }
				cylinder { <-3.6639, 27.2675, -5.1957>, <-3.6586, 27.3118, -5.2127>, 0.0008093 }
				cylinder { <-3.6586, 27.3118, -5.2127>, <-3.6533, 27.3562, -5.2297>, 0.0008093 }
				cylinder { <-3.6533, 27.3562, -5.2297>, <-3.648, 27.4005, -5.2467>, 0.0008093 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.648, 27.4005, -5.2467>, <-3.5251, 28.05614, -5.4252>, <-3.5442, 28.05389, -5.4717> }
				triangle { <-3.5251, 28.05614, -5.4252>, <-3.3975, 28.4155, -5.5477>, <-3.5442, 28.05389, -5.4717> }
				triangle { <-3.3975, 28.4155, -5.5477>, <-3.4096, 28.4002, -5.6001>, <-3.5442, 28.05389, -5.4717> }
				triangle { <-3.3975, 28.4155, -5.5477>, <-2.8191, 29.4393, -5.9767>, <-3.4096, 28.4002, -5.6001> }
				triangle { <-3.4096, 28.4002, -5.6001>, <-2.8191, 29.4393, -5.9767>, <-3.4231, 28.3764, -5.6497> }
				triangle { <-3.5442, 28.05389, -5.4717>, <-3.4096, 28.4002, -5.6001>, <-3.4231, 28.3764, -5.6497> }
				triangle { <-3.5442, 28.05389, -5.4717>, <-3.4231, 28.3764, -5.6497>, <-3.5572, 28.03284, -5.5126> }
				triangle { <-3.5442, 28.05389, -5.4717>, <-3.5572, 28.03284, -5.5126>, <-3.648, 27.4005, -5.2467> }
				triangle { <-2.4534, 29.9351, -6.2146>, <-2.8191, 29.4393, -5.9767>, <-2.7789, 29.4554, -5.9069> }
				triangle { <-3.4231, 28.3764, -5.6497>, <-2.8191, 29.4393, -5.9767>, <-2.8065, 29.4053, -6.07297> }
				triangle { <-3.3975, 28.4155, -5.5477>, <-2.7789, 29.4554, -5.9069>, <-2.8191, 29.4393, -5.9767> }
				triangle { <-2.4534, 29.9351, -6.2146>, <-2.8065, 29.4053, -6.07297>, <-2.8191, 29.4393, -5.9767> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.01772, 0.9888, -0.07075>, 0.0168 }
			cylinder { <-0.01772, 0.9888, -0.07075>, <-0.05307, 1.9696, -0.2118>, 0.0168 }
			cylinder { <-0.05307, 1.9696, -0.2118>, <-0.1058, 2.937, -0.4226>, 0.0168 }
			cylinder { <-0.1058, 2.937, -0.4226>, <-0.1757, 3.8858, -0.7018>, 0.0168 }
			cylinder { <-0.1757, 3.8858, -0.7018>, <-0.2625, 4.8109, -1.04796>, 0.0168 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.2625, 4.8109, -1.04796>, <-0.2807, 5.00525, -1.1206>, 0.0168 }
				cylinder { <-0.2807, 5.00525, -1.1206>, <-0.2989, 5.1995, -1.1933>, 0.0168 }
				cylinder { <-0.2989, 5.1995, -1.1933>, <-0.3171, 5.3937, -1.266>, 0.0168 }
				cylinder { <-0.3171, 5.3937, -1.266>, <-0.3353, 5.588, -1.3387>, 0.0168 }
				cylinder { <-0.3353, 5.588, -1.3387>, <-0.3535, 5.7823, -1.4114>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.3535, 5.7823, -1.4114>, <-0.3546, 5.7869, -1.4129>, 0.00008473 }
				cylinder { <-0.3546, 5.7869, -1.4129>, <-0.3565, 5.7913, -1.4142>, 0.00008473 }
				cylinder { <-0.3565, 5.7913, -1.4142>, <-0.3589, 5.7956, -1.4153>, 0.00008473 }
				cylinder { <-0.3589, 5.7956, -1.4153>, <-0.362, 5.7994, -1.4161>, 0.00008473 }
				cylinder { <-0.362, 5.7994, -1.4161>, <-0.3656, 5.8029, -1.4166>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.3535, 5.7823, -1.4114>, <-0.3656, 5.9783, -1.4806>, 0.0168 }
				cylinder { <-0.3656, 5.9783, -1.4806>, <-0.3715, 6.1757, -1.5464>, 0.0168 }
				cylinder { <-0.3715, 6.1757, -1.5464>, <-0.3713, 6.3745, -1.6085>, 0.0168 }
				cylinder { <-0.3713, 6.3745, -1.6085>, <-0.365, 6.5742, -1.667>, 0.0168 }
				cylinder { <-0.365, 6.5742, -1.667>, <-0.3525, 6.7747, -1.7218>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.3525, 6.7747, -1.7218>, <-0.3514, 6.7794, -1.7233>, 0.00008473 }
				cylinder { <-0.3514, 6.7794, -1.7233>, <-0.3495, 6.7837, -1.7248>, 0.00008473 }
				cylinder { <-0.3495, 6.7837, -1.7248>, <-0.3468, 6.7876, -1.7265>, 0.00008473 }
				cylinder { <-0.3468, 6.7876, -1.7265>, <-0.3435, 6.7909, -1.7281>, 0.00008473 }
				cylinder { <-0.3435, 6.7909, -1.7281>, <-0.3396, 6.7936, -1.7298>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.3525, 6.7747, -1.7218>, <-0.3351, 6.9746, -1.7776>, 0.0168 }
				cylinder { <-0.3351, 6.9746, -1.7776>, <-0.3127, 7.1736, -1.8343>, 0.0168 }
				cylinder { <-0.3127, 7.1736, -1.8343>, <-0.2853, 7.3718, -1.892>, 0.0168 }
				cylinder { <-0.2853, 7.3718, -1.892>, <-0.2531, 7.569, -1.9507>, 0.0168 }
				cylinder { <-0.2531, 7.569, -1.9507>, <-0.2159, 7.765, -2.01026>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.2159, 7.765, -2.01026>, <-0.2158, 7.7699, -2.01155>, 0.00008473 }
				cylinder { <-0.2158, 7.7699, -2.01155>, <-0.2163, 7.7747, -2.01267>, 0.00008473 }
				cylinder { <-0.2163, 7.7747, -2.01267>, <-0.2175, 7.7795, -2.0136>, 0.00008473 }
				cylinder { <-0.2175, 7.7795, -2.0136>, <-0.2194, 7.784, -2.01432>, 0.00008473 }
				cylinder { <-0.2194, 7.784, -2.01432>, <-0.222, 7.7883, -2.01481>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <-0.2159, 7.765, -2.01026>, <-0.1848, 7.9609, -2.07371>, 0.0168 }
				cylinder { <-0.1848, 7.9609, -2.07371>, <-0.1599, 8.1564, -2.141>, 0.0168 }
				cylinder { <-0.1599, 8.1564, -2.141>, <-0.141, 8.3512, -2.212>, 0.0168 }
				cylinder { <-0.141, 8.3512, -2.212>, <-0.1284, 8.5451, -2.2867>, 0.0168 }
				cylinder { <-0.1284, 8.5451, -2.2867>, <-0.1218, 8.7379, -2.365>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.1218, 8.7379, -2.365>, <-0.1211, 8.7425, -2.367>, 0.00008473 }
				cylinder { <-0.1211, 8.7425, -2.367>, <-0.1198, 8.7468, -2.3691>, 0.00008473 }
				cylinder { <-0.1198, 8.7468, -2.3691>, <-0.1179, 8.7509, -2.3712>, 0.00008473 }
				cylinder { <-0.1179, 8.7509, -2.3712>, <-0.1155, 8.7547, -2.3734>, 0.00008473 }
				cylinder { <-0.1155, 8.7547, -2.3734>, <-0.1125, 8.7582, -2.3755>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.1218, 8.7379, -2.365>, <-0.1218, 8.7426, -2.3669>, 0.00008473 }
				cylinder { <-0.1218, 8.7426, -2.3669>, <-0.1219, 8.7472, -2.3687>, 0.00008473 }
				cylinder { <-0.1219, 8.7472, -2.3687>, <-0.1221, 8.7519, -2.3705>, 0.00008473 }
				cylinder { <-0.1221, 8.7519, -2.3705>, <-0.1224, 8.7566, -2.3723>, 0.00008473 }
				cylinder { <-0.1224, 8.7566, -2.3723>, <-0.1229, 8.7612, -2.374>, 0.00008473 }
				texture{Grass_Texture4}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.01772, 0.9888, 0.07075>, 0.0168 }
			cylinder { <0.01772, 0.9888, 0.07075>, <0.05307, 1.9696, 0.2118>, 0.0168 }
			cylinder { <0.05307, 1.9696, 0.2118>, <0.1058, 2.937, 0.4226>, 0.0168 }
			cylinder { <0.1058, 2.937, 0.4226>, <0.1757, 3.8858, 0.7018>, 0.0168 }
			cylinder { <0.1757, 3.8858, 0.7018>, <0.2625, 4.8109, 1.04796>, 0.0168 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.2625, 4.8109, 1.04796>, <0.2868, 5.003293, 1.1239>, 0.0168 }
				cylinder { <0.2868, 5.003293, 1.1239>, <0.3171, 5.1934, 1.2032>, 0.0168 }
				cylinder { <0.3171, 5.1934, 1.2032>, <0.3536, 5.3811, 1.2857>, 0.0168 }
				cylinder { <0.3536, 5.3811, 1.2857>, <0.396, 5.5661, 1.3712>, 0.0168 }
				cylinder { <0.396, 5.5661, 1.3712>, <0.4443, 5.7483, 1.4596>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.4443, 5.7483, 1.4596>, <0.4463, 5.7525, 1.4615>, 0.00008473 }
				cylinder { <0.4463, 5.7525, 1.4615>, <0.449, 5.7565, 1.463>, 0.00008473 }
				cylinder { <0.449, 5.7565, 1.463>, <0.4523, 5.76, 1.4641>, 0.00008473 }
				cylinder { <0.4523, 5.76, 1.4641>, <0.4562, 5.763, 1.4648>, 0.00008473 }
				cylinder { <0.4562, 5.763, 1.4648>, <0.4606, 5.7655, 1.4651>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <0.4443, 5.7483, 1.4596>, <0.4937, 5.9281, 1.5524>, 0.0168 }
				cylinder { <0.4937, 5.9281, 1.5524>, <0.5441, 6.1052, 1.6495>, 0.0168 }
				cylinder { <0.5441, 6.1052, 1.6495>, <0.5954, 6.2797, 1.7509>, 0.0168 }
				cylinder { <0.5954, 6.2797, 1.7509>, <0.6478, 6.4514, 1.8564>, 0.0168 }
				cylinder { <0.6478, 6.4514, 1.8564>, <0.701, 6.6202, 1.9661>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.701, 6.6202, 1.9661>, <0.7015, 6.6243, 1.9689>, 0.00008473 }
				cylinder { <0.7015, 6.6243, 1.9689>, <0.7014, 6.6284, 1.9718>, 0.00008473 }
				cylinder { <0.7014, 6.6284, 1.9718>, <0.7005, 6.6323, 1.9748>, 0.00008473 }
				cylinder { <0.7005, 6.6323, 1.9748>, <0.6989, 6.6359, 1.9778>, 0.00008473 }
				cylinder { <0.6989, 6.6359, 1.9778>, <0.6967, 6.6393, 1.9807>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <0.701, 6.6202, 1.9661>, <0.7484, 6.7925, 2.0731>, 0.0168 }
				cylinder { <0.7484, 6.7925, 2.0731>, <0.79, 6.9679, 2.1772>, 0.0168 }
				cylinder { <0.79, 6.9679, 2.1772>, <0.8257, 7.1463, 2.2785>, 0.0168 }
				cylinder { <0.8257, 7.1463, 2.2785>, <0.8555, 7.3275, 2.3767>, 0.0168 }
				cylinder { <0.8555, 7.3275, 2.3767>, <0.8793, 7.5112, 2.4717>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.8793, 7.5112, 2.4717>, <0.8804, 7.5156, 2.4738>, 0.00008473 }
				cylinder { <0.8804, 7.5156, 2.4738>, <0.8822, 7.5199, 2.4757>, 0.00008473 }
				cylinder { <0.8822, 7.5199, 2.4757>, <0.8845, 7.524, 2.4775>, 0.00008473 }
				cylinder { <0.8845, 7.524, 2.4775>, <0.8873, 7.5278, 2.4789>, 0.00008473 }
				cylinder { <0.8873, 7.5278, 2.4789>, <0.8905, 7.5314, 2.4801>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf internode
				cylinder { <0.8793, 7.5112, 2.4717>, <0.8971, 7.6973, 2.5634>, 0.0168 }
				cylinder { <0.8971, 7.6973, 2.5634>, <0.9089, 7.8855, 2.6517>, 0.0168 }
				cylinder { <0.9089, 7.8855, 2.6517>, <0.9146, 8.0756, 2.7365>, 0.0168 }
				cylinder { <0.9146, 8.0756, 2.7365>, <0.9144, 8.2673, 2.8177>, 0.0168 }
				cylinder { <0.9144, 8.2673, 2.8177>, <0.9081, 8.4605, 2.8952>, 0.0168 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.9081, 8.4605, 2.8952>, <0.9071, 8.4649, 2.8972>, 0.00008473 }
				cylinder { <0.9071, 8.4649, 2.8972>, <0.9053, 8.4691, 2.8993>, 0.00008473 }
				cylinder { <0.9053, 8.4691, 2.8993>, <0.9028, 8.4729, 2.9013>, 0.00008473 }
				cylinder { <0.9028, 8.4729, 2.9013>, <0.8995, 8.4762, 2.9033>, 0.00008473 }
				cylinder { <0.8995, 8.4762, 2.9033>, <0.8957, 8.4788, 2.9052>, 0.00008473 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.9081, 8.4605, 2.8952>, <0.9078, 8.4651, 2.8971>, 0.00008473 }
				cylinder { <0.9078, 8.4651, 2.8971>, <0.9074, 8.4697, 2.899>, 0.00008473 }
				cylinder { <0.9074, 8.4697, 2.899>, <0.9069, 8.4743, 2.9009>, 0.00008473 }
				cylinder { <0.9069, 8.4743, 2.9009>, <0.9063, 8.4788, 2.9029>, 0.00008473 }
				cylinder { <0.9063, 8.4788, 2.9029>, <0.9055, 8.4834, 2.9048>, 0.00008473 }
				texture{Grass_Texture4}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 15.8924, 0.0>, 0.2172 }
			cylinder { <-0.0, 15.8924, 0.0>, <-0.00000001, 31.7849, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 31.7849, 0.0>, <-0.00000001, 47.6774, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 47.6774, 0.0>, <-0.00000001, 63.5699, 0.0>, 0.2172 }
			cylinder { <-0.00000001, 63.5699, 0.0>, <-0.00000002, 79.4624, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <-0.00000002, 80.1801, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 80.1801, 0.0>, <-0.00000002, 80.8979, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 80.8979, 0.0>, <-0.00000002, 81.6156, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 81.6156, 0.0>, <-0.00000002, 82.3333, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 82.3333, 0.0>, <-0.00000002, 83.0511, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 83.0511, 0.0>, <-0.00000002, 83.7688, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 83.7688, 0.0>, <-0.00000002, 84.4865, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 84.4865, 0.0>, <-0.00000002, 85.2042, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 85.2042, 0.0>, <-0.00000002, 85.922, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 85.922, 0.0>, <-0.00000002, 86.6397, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 86.6397, 0.0>, <-0.00000002, 87.3574, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 87.3574, 0.0>, <-0.00000002, 88.0752, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 88.0752, 0.0>, <-0.00000002, 88.7929, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 88.7929, 0.0>, <-0.00000002, 89.5106, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 89.5106, 0.0>, <-0.00000002, 90.2283, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 90.2283, 0.0>, <-0.00000002, 90.9461, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 90.9461, 0.0>, <-0.00000002, 91.6638, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 91.6638, 0.0>, <-0.00000002, 92.3815, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 92.3815, 0.0>, <-0.00000002, 93.09929, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 93.09929, 0.0>, <-0.00000002, 93.817, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 93.817, 0.0>, <-0.00000002, 94.5347, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 94.5347, 0.0>, <-0.00000002, 95.2524, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 95.2524, 0.0>, <-0.00000002, 95.9702, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 95.9702, 0.0>, <-0.00000002, 96.6879, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 96.6879, 0.0>, <-0.00000002, 97.4056, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 97.4056, 0.0>, <0.07818, 100.7882, -0.02797>, 0.2172 }
				cylinder { <0.07818, 100.7882, -0.02797>, <0.2345, 104.1677, -0.0839>, 0.2172 }
				cylinder { <0.2345, 104.1677, -0.0839>, <0.4688, 107.5421, -0.1677>, 0.2172 }
				cylinder { <0.4688, 107.5421, -0.1677>, <0.7811, 110.9094, -0.2794>, 0.2172 }
				cylinder { <0.7811, 110.9094, -0.2794>, <1.171, 114.2675, -0.419>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.171, 114.2675, -0.419>, <1.3007, 115.0833, -0.3647>, <1.2161, 115.1099, -0.3917> }
					triangle { <1.3007, 115.0833, -0.3647>, <1.3078, 115.5372, -0.2927>, <1.2161, 115.1099, -0.3917> }
					triangle { <1.3078, 115.5372, -0.2927>, <1.214, 115.5647, -0.3256>, <1.2161, 115.1099, -0.3917> }
					triangle { <1.3078, 115.5372, -0.2927>, <1.2071, 116.2158, -0.2448>, <1.214, 115.5647, -0.3256> }
					triangle { <1.214, 115.5647, -0.3256>, <1.2071, 116.2158, -0.2448>, <1.1433, 115.552, -0.3995> }
					triangle { <1.2161, 115.1099, -0.3917>, <1.214, 115.5647, -0.3256>, <1.1433, 115.552, -0.3995> }
					triangle { <1.2161, 115.1099, -0.3917>, <1.1433, 115.552, -0.3995>, <1.1484, 115.0956, -0.4506> }
					triangle { <1.2161, 115.1099, -0.3917>, <1.1484, 115.0956, -0.4506>, <1.171, 114.2675, -0.419> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 97.4056, 0.0>, <-0.00000002, 98.1233, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 98.1233, 0.0>, <-0.00000002, 98.8411, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 98.8411, 0.0>, <-0.00000002, 99.5588, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 99.5588, 0.0>, <-0.00000002, 100.2766, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 100.2766, 0.0>, <-0.00000002, 100.9943, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 100.9943, 0.0>, <-0.07671, 104.3768, -0.03177>, 0.2172 }
				cylinder { <-0.07671, 104.3768, -0.03177>, <-0.2301, 107.7563, -0.09531>, 0.2172 }
				cylinder { <-0.2301, 107.7563, -0.09531>, <-0.46, 111.1307, -0.1905>, 0.2172 }
				cylinder { <-0.46, 111.1307, -0.1905>, <-0.7664, 114.498, -0.3174>, 0.2172 }
				cylinder { <-0.7664, 114.498, -0.3174>, <-1.1491, 117.8561, -0.4759>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.1491, 117.8561, -0.4759>, <-1.414, 118.5984, -0.5032>, <-1.3633, 118.6303, -0.4383> }
					triangle { <-1.414, 118.5984, -0.5032>, <-1.49, 119.0293, -0.5218>, <-1.3633, 118.6303, -0.4383> }
					triangle { <-1.49, 119.0293, -0.5218>, <-1.4347, 119.0621, -0.4476>, <-1.3633, 118.6303, -0.4383> }
					triangle { <-1.49, 119.0293, -0.5218>, <-1.5399, 119.6784, -0.4476>, <-1.4347, 119.0621, -0.4476> }
					triangle { <-1.4347, 119.0621, -0.4476>, <-1.5399, 119.6784, -0.4476>, <-1.4072, 119.0466, -0.3546> }
					triangle { <-1.3633, 118.6303, -0.4383>, <-1.4347, 119.0621, -0.4476>, <-1.4072, 119.0466, -0.3546> }
					triangle { <-1.3633, 118.6303, -0.4383>, <-1.4072, 119.0466, -0.3546>, <-1.3313, 118.6157, -0.3593> }
					triangle { <-1.3633, 118.6303, -0.4383>, <-1.3313, 118.6157, -0.3593>, <-1.1491, 117.8561, -0.4759> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 100.9943, 0.0>, <-0.00000002, 101.712, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 101.712, 0.0>, <-0.00000002, 102.4297, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 102.4297, 0.0>, <-0.00000002, 103.1475, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 103.1475, 0.0>, <-0.00000002, 103.8652, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 103.8652, 0.0>, <-0.00000002, 104.5829, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 104.5829, 0.0>, <0.0355, 107.9655, 0.07506>, 0.2172 }
				cylinder { <0.0355, 107.9655, 0.07506>, <0.1064, 111.345, 0.2251>, 0.2172 }
				cylinder { <0.1064, 111.345, 0.2251>, <0.2129, 114.7194, 0.4501>, 0.2172 }
				cylinder { <0.2129, 114.7194, 0.4501>, <0.3547, 118.0866, 0.7499>, 0.2172 }
				cylinder { <0.3547, 118.0866, 0.7499>, <0.5317, 121.4447, 1.1243>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.5317, 121.4447, 1.1243>, <0.7805, 122.1272, 1.3165>, <0.7833, 122.1593, 1.2387> }
					triangle { <0.7805, 122.1272, 1.3165>, <0.8651, 122.5299, 1.3846>, <0.7833, 122.1593, 1.2387> }
					triangle { <0.8651, 122.5299, 1.3846>, <0.8699, 122.563, 1.2972>, <0.7833, 122.1593, 1.2387> }
					triangle { <0.8651, 122.5299, 1.3846>, <1.003857, 123.1383, 1.3727>, <0.8699, 122.563, 1.2972> }
					triangle { <0.8699, 122.563, 1.2972>, <1.003857, 123.1383, 1.3727>, <0.9022, 122.5471, 1.2109> }
					triangle { <0.7833, 122.1593, 1.2387>, <0.8699, 122.563, 1.2972>, <0.9022, 122.5471, 1.2109> }
					triangle { <0.7833, 122.1593, 1.2387>, <0.9022, 122.5471, 1.2109>, <0.8041, 122.1452, 1.1603> }
					triangle { <0.7833, 122.1593, 1.2387>, <0.8041, 122.1452, 1.1603>, <0.5317, 121.4447, 1.1243> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 104.5829, 0.0>, <-0.00000002, 105.3007, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 105.3007, 0.0>, <-0.00000002, 106.0184, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 106.0184, 0.0>, <-0.00000002, 106.7361, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 106.7361, 0.0>, <-0.00000002, 107.4538, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 107.4538, 0.0>, <-0.00000002, 108.1716, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 108.1716, 0.0>, <0.0241, 111.5541, -0.07946>, 0.2172 }
				cylinder { <0.0241, 111.5541, -0.07946>, <0.07229, 114.9336, -0.2383>, 0.2172 }
				cylinder { <0.07229, 114.9336, -0.2383>, <0.1445, 118.308, -0.4765>, 0.2172 }
				cylinder { <0.1445, 118.308, -0.4765>, <0.2408, 121.6753, -0.7938>, 0.2172 }
				cylinder { <0.2408, 121.6753, -0.7938>, <0.361, 125.0334, -1.1902>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.361, 125.0334, -1.1902>, <0.3621, 125.707, -1.4318>, <0.308, 125.7359, -1.3803> }
					triangle { <0.3621, 125.707, -1.4318>, <0.3721, 126.0979, -1.5021>, <0.308, 125.7359, -1.3803> }
					triangle { <0.3721, 126.0979, -1.5021>, <0.31, 126.1277, -1.4456>, <0.308, 125.7359, -1.3803> }
					triangle { <0.3721, 126.0979, -1.5021>, <0.3007, 126.6868, -1.5406>, <0.31, 126.1277, -1.4456> }
					triangle { <0.31, 126.1277, -1.4456>, <0.3007, 126.6868, -1.5406>, <0.2285, 126.1136, -1.4125> }
					triangle { <0.308, 125.7359, -1.3803>, <0.31, 126.1277, -1.4456>, <0.2285, 126.1136, -1.4125> }
					triangle { <0.308, 125.7359, -1.3803>, <0.2285, 126.1136, -1.4125>, <0.2395, 125.7226, -1.3444> }
					triangle { <0.308, 125.7359, -1.3803>, <0.2395, 125.7226, -1.3444>, <0.361, 125.0334, -1.1902> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 79.4624, 0.0>, <-0.00000002, 80.1801, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 80.1801, 0.0>, <-0.00000002, 80.8979, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 80.8979, 0.0>, <-0.00000002, 81.6156, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 81.6156, 0.0>, <-0.00000002, 82.3333, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 82.3333, 0.0>, <-0.00000002, 83.0511, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 83.0511, 0.0>, <0.1155, 83.7582, -0.04133>, 0.2172 }
			cylinder { <0.1155, 83.7582, -0.04133>, <0.231, 84.4654, -0.08267>, 0.2172 }
			cylinder { <0.231, 84.4654, -0.08267>, <0.3465, 85.1725, -0.124>, 0.2172 }
			cylinder { <0.3465, 85.1725, -0.124>, <0.4621, 85.8797, -0.1653>, 0.2172 }
			cylinder { <0.4621, 85.8797, -0.1653>, <0.5776, 86.5869, -0.2066>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.5776, 86.5869, -0.2066>, <1.04627, 89.9301, -0.4335>, 0.2172 }
				cylinder { <1.04627, 89.9301, -0.4335>, <1.4385, 93.2809, -0.6923>, 0.2172 }
				cylinder { <1.4385, 93.2809, -0.6923>, <1.7543, 96.6371, -0.9828>, 0.2172 }
				cylinder { <1.7543, 96.6371, -0.9828>, <1.9933, 99.9968, -1.3049>, 0.2172 }
				cylinder { <1.9933, 99.9968, -1.3049>, <2.1555, 103.358, -1.6584>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <2.1555, 103.358, -1.6584>, <2.2274, 104.1641, -1.8327>, <2.276, 104.1876, -1.7573> }
					triangle { <2.2274, 104.1641, -1.8327>, <2.3427, 104.601, -1.9167>, <2.276, 104.1876, -1.7573> }
					triangle { <2.3427, 104.601, -1.9167>, <2.3943, 104.6255, -1.8308>, <2.276, 104.1876, -1.7573> }
					triangle { <2.3427, 104.601, -1.9167>, <2.5574, 105.2543, -1.9232>, <2.3943, 104.6255, -1.8308> }
					triangle { <2.3943, 104.6255, -1.8308>, <2.5574, 105.2543, -1.9232>, <2.3955, 104.6185, -1.728> }
					triangle { <2.276, 104.1876, -1.7573>, <2.3943, 104.6255, -1.8308>, <2.3955, 104.6185, -1.728> }
					triangle { <2.276, 104.1876, -1.7573>, <2.3955, 104.6185, -1.728>, <2.2846, 104.1769, -1.6676> }
					triangle { <2.276, 104.1876, -1.7573>, <2.2846, 104.1769, -1.6676>, <2.1555, 103.358, -1.6584> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.5776, 86.5869, -0.2066>, <0.6931, 87.294, -0.248>, 0.2172 }
			cylinder { <0.6931, 87.294, -0.248>, <0.8087, 88.00123, -0.2893>, 0.2172 }
			cylinder { <0.8087, 88.00123, -0.2893>, <0.9242, 88.7083, -0.3307>, 0.2172 }
			cylinder { <0.9242, 88.7083, -0.3307>, <1.03977, 89.4155, -0.372>, 0.2172 }
			cylinder { <1.03977, 89.4155, -0.372>, <1.1553, 90.1227, -0.4133>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.1553, 90.1227, -0.4133>, <1.7351, 93.454, -0.533>, 0.2172 }
				cylinder { <1.7351, 93.454, -0.533>, <2.3499, 96.781, -0.5775>, 0.2172 }
				cylinder { <2.3499, 96.781, -0.5775>, <2.9991, 100.1016, -0.5467>, 0.2172 }
				cylinder { <2.9991, 100.1016, -0.5467>, <3.6825, 103.4137, -0.4407>, 0.2172 }
				cylinder { <3.6825, 103.4137, -0.4407>, <4.3996, 106.7154, -0.2595>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.3996, 106.7154, -0.2595>, <4.6957, 107.4296, -0.1036>, <4.7063, 107.4553, -0.1875> }
					triangle { <4.6957, 107.4296, -0.1036>, <4.8086, 107.8508, -0.06356>, <4.7063, 107.4553, -0.1875> }
					triangle { <4.8086, 107.8508, -0.06356>, <4.8221, 107.8764, -0.1574>, <4.7063, 107.4553, -0.1875> }
					triangle { <4.8086, 107.8508, -0.06356>, <4.9986, 108.4751, -0.122>, <4.8221, 107.8764, -0.1574> }
					triangle { <4.8221, 107.8764, -0.1574>, <4.9986, 108.4751, -0.122>, <4.8608, 107.8493, -0.2435> }
					triangle { <4.7063, 107.4553, -0.1875>, <4.8221, 107.8764, -0.1574>, <4.8608, 107.8493, -0.2435> }
					triangle { <4.7063, 107.4553, -0.1875>, <4.8608, 107.8493, -0.2435>, <4.7326, 107.4316, -0.2664> }
					triangle { <4.7063, 107.4553, -0.1875>, <4.7326, 107.4316, -0.2664>, <4.3996, 106.7154, -0.2595> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.1553, 90.1227, -0.4133>, <1.2708, 90.8298, -0.4547>, 0.2172 }
			cylinder { <1.2708, 90.8298, -0.4547>, <1.3863, 91.537, -0.496>, 0.2172 }
			cylinder { <1.3863, 91.537, -0.496>, <1.5019, 92.2441, -0.5373>, 0.2172 }
			cylinder { <1.5019, 92.2441, -0.5373>, <1.6174, 92.9513, -0.5787>, 0.2172 }
			cylinder { <1.6174, 92.9513, -0.5787>, <1.7329, 93.6585, -0.62>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.7329, 93.6585, -0.62>, <2.3008, 96.9828, -0.894>, 0.2172 }
				cylinder { <2.3008, 96.9828, -0.894>, <2.8916, 100.2956, -1.2471>, 0.2172 }
				cylinder { <2.8916, 100.2956, -1.2471>, <3.505, 103.595, -1.6789>, 0.2172 }
				cylinder { <3.505, 103.595, -1.6789>, <4.1406, 106.8789, -2.1892>, 0.2172 }
				cylinder { <4.1406, 106.8789, -2.1892>, <4.7979, 110.1454, -2.7777>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.7979, 110.1454, -2.7777>, <4.8518, 110.8089, -3.1262>, <4.8036, 110.8524, -3.07269> }
					triangle { <4.8518, 110.8089, -3.1262>, <4.8994, 111.2022, -3.2566>, <4.8036, 110.8524, -3.07269> }
					triangle { <4.8994, 111.2022, -3.2566>, <4.8436, 111.2484, -3.1974>, <4.8036, 110.8524, -3.07269> }
					triangle { <4.8994, 111.2022, -3.2566>, <4.8876, 111.8147, -3.3763>, <4.8436, 111.2484, -3.1974> }
					triangle { <4.8436, 111.2484, -3.1974>, <4.8876, 111.8147, -3.3763>, <4.7603, 111.2484, -3.1546> }
					triangle { <4.8036, 110.8524, -3.07269>, <4.8436, 111.2484, -3.1974>, <4.7603, 111.2484, -3.1546> }
					triangle { <4.8036, 110.8524, -3.07269>, <4.7603, 111.2484, -3.1546>, <4.7343, 110.8521, -3.02815> }
					triangle { <4.8036, 110.8524, -3.07269>, <4.7343, 110.8521, -3.02815>, <4.7979, 110.1454, -2.7777> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.7329, 93.6585, -0.62>, <1.8484, 94.3656, -0.6614>, 0.2172 }
			cylinder { <1.8484, 94.3656, -0.6614>, <1.964, 95.07284, -0.7027>, 0.2172 }
			cylinder { <1.964, 95.07284, -0.7027>, <2.07955, 95.78, -0.744>, 0.2172 }
			cylinder { <2.07955, 95.78, -0.744>, <2.195, 96.4871, -0.7854>, 0.2172 }
			cylinder { <2.195, 96.4871, -0.7854>, <2.3106, 97.1943, -0.8267>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.3106, 97.1943, -0.8267>, <2.785, 100.541, -0.9792>, 0.2172 }
				cylinder { <2.785, 100.541, -0.9792>, <3.1888, 103.8986, -1.08938>, 0.2172 }
				cylinder { <3.1888, 103.8986, -1.08938>, <3.5219, 107.265, -1.1569>, 0.2172 }
				cylinder { <3.5219, 107.265, -1.1569>, <3.7839, 110.6383, -1.182>, 0.2172 }
				cylinder { <3.7839, 110.6383, -1.182>, <3.9749, 114.0165, -1.1645>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <3.9749, 114.0165, -1.1645>, <3.9232, 114.7166, -1.02603>, <4.001616, 114.733, -1.02923> }
					triangle { <3.9232, 114.7166, -1.02603>, <3.9324, 115.1132, -1.003551>, <4.001616, 114.733, -1.02923> }
					triangle { <3.9324, 115.1132, -1.003551>, <4.02011, 115.129, -1.005089>, <4.001616, 114.733, -1.02923> }
					triangle { <3.9324, 115.1132, -1.003551>, <4.05435, 115.6935, -0.961>, <4.02011, 115.129, -1.005089> }
					triangle { <4.02011, 115.129, -1.005089>, <4.05435, 115.6935, -0.961>, <4.09954, 115.1036, -0.9737> }
					triangle { <4.001616, 114.733, -1.02923>, <4.02011, 115.129, -1.005089>, <4.09954, 115.1036, -0.9737> }
					triangle { <4.001616, 114.733, -1.02923>, <4.09954, 115.1036, -0.9737>, <4.07347, 114.709, -1.008755> }
					triangle { <4.001616, 114.733, -1.02923>, <4.07347, 114.709, -1.008755>, <3.9749, 114.0165, -1.1645> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 83.0511, 0.0>, <-0.00000002, 83.7688, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 83.7688, 0.0>, <-0.00000002, 84.4865, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 84.4865, 0.0>, <-0.00000002, 85.2042, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 85.2042, 0.0>, <-0.00000002, 85.922, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 85.922, 0.0>, <-0.00000002, 86.6397, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 86.6397, 0.0>, <-0.1133, 87.3469, -0.04695>, 0.2172 }
			cylinder { <-0.1133, 87.3469, -0.04695>, <-0.2267, 88.05406, -0.09391>, 0.2172 }
			cylinder { <-0.2267, 88.05406, -0.09391>, <-0.34, 88.7612, -0.1408>, 0.2172 }
			cylinder { <-0.34, 88.7612, -0.1408>, <-0.4534, 89.4683, -0.1878>, 0.2172 }
			cylinder { <-0.4534, 89.4683, -0.1878>, <-0.5668, 90.1755, -0.2347>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.5668, 90.1755, -0.2347>, <-1.06641, 93.5188, -0.3813>, 0.2172 }
				cylinder { <-1.06641, 93.5188, -0.3813>, <-1.5308, 96.8695, -0.453>, 0.2172 }
				cylinder { <-1.5308, 96.8695, -0.453>, <-1.9599, 100.2258, -0.4498>, 0.2172 }
				cylinder { <-1.9599, 100.2258, -0.4498>, <-2.3533, 103.5855, -0.3717>, 0.2172 }
				cylinder { <-2.3533, 103.5855, -0.3717>, <-2.7108, 106.9467, -0.2187>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.7108, 106.9467, -0.2187>, <-2.8811, 107.7527, -0.1378>, <-2.8666, 107.7763, -0.2264> }
					triangle { <-2.8811, 107.7527, -0.1378>, <-3.02305, 108.1897, -0.153>, <-2.8666, 107.7763, -0.2264> }
					triangle { <-3.02305, 108.1897, -0.153>, <-3.003635, 108.2142, -0.2513>, <-2.8666, 107.7763, -0.2264> }
					triangle { <-3.02305, 108.1897, -0.153>, <-3.1864, 108.843, -0.2924>, <-3.003635, 108.2142, -0.2513> }
					triangle { <-3.003635, 108.2142, -0.2513>, <-3.1864, 108.843, -0.2924>, <-2.9354, 108.2071, -0.3283> }
					triangle { <-2.8666, 107.7763, -0.2264>, <-3.003635, 108.2142, -0.2513>, <-2.9354, 108.2071, -0.3283> }
					triangle { <-2.8666, 107.7763, -0.2264>, <-2.9354, 108.2071, -0.3283>, <-2.8126, 107.7656, -0.2986> }
					triangle { <-2.8666, 107.7763, -0.2264>, <-2.8126, 107.7656, -0.2986>, <-2.7108, 106.9467, -0.2187> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.5668, 90.1755, -0.2347>, <-0.6801, 90.8827, -0.2817>, 0.2172 }
			cylinder { <-0.6801, 90.8827, -0.2817>, <-0.7935, 91.5898, -0.3286>, 0.2172 }
			cylinder { <-0.7935, 91.5898, -0.3286>, <-0.9069, 92.297, -0.3756>, 0.2172 }
			cylinder { <-0.9069, 92.297, -0.3756>, <-1.02027, 93.00419, -0.4226>, 0.2172 }
			cylinder { <-1.02027, 93.00419, -0.4226>, <-1.1336, 93.7113, -0.4695>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.1336, 93.7113, -0.4695>, <-1.6436, 97.0427, -0.7702>, 0.2172 }
				cylinder { <-1.6436, 97.0427, -0.7702>, <-2.129, 100.3697, -1.1501>, 0.2172 }
				cylinder { <-2.129, 100.3697, -1.1501>, <-2.5894, 103.6902, -1.6089>, 0.2172 }
				cylinder { <-2.5894, 103.6902, -1.6089>, <-3.02458, 107.0023, -2.1464>, 0.2172 }
				cylinder { <-3.02458, 107.0023, -2.1464>, <-3.4342, 110.3041, -2.7622>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.4342, 110.3041, -2.7622>, <-3.5489, 111.0182, -3.07662>, <-3.6131, 111.044, -3.02167> }
					triangle { <-3.5489, 111.0182, -3.07662>, <-3.6056, 111.4394, -3.1821>, <-3.6131, 111.044, -3.02167> }
					triangle { <-3.6056, 111.4394, -3.1821>, <-3.6787, 111.4651, -3.1217>, <-3.6131, 111.044, -3.02167> }
					triangle { <-3.6056, 111.4394, -3.1821>, <-3.7856, 112.0637, -3.2664>, <-3.6787, 111.4651, -3.1217> }
					triangle { <-3.6787, 111.4651, -3.1217>, <-3.7856, 112.0637, -3.2664>, <-3.7651, 111.4379, -3.08386> }
					triangle { <-3.6131, 111.044, -3.02167>, <-3.6787, 111.4651, -3.1217>, <-3.7651, 111.4379, -3.08386> }
					triangle { <-3.6131, 111.044, -3.02167>, <-3.7651, 111.4379, -3.08386>, <-3.6855, 111.0202, -2.9808> }
					triangle { <-3.6131, 111.044, -3.02167>, <-3.6855, 111.0202, -2.9808>, <-3.4342, 110.3041, -2.7622> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.1336, 93.7113, -0.4695>, <-1.2469, 94.4185, -0.5165>, 0.2172 }
			cylinder { <-1.2469, 94.4185, -0.5165>, <-1.3603, 95.1256, -0.5634>, 0.2172 }
			cylinder { <-1.3603, 95.1256, -0.5634>, <-1.4737, 95.8328, -0.6104>, 0.2172 }
			cylinder { <-1.4737, 95.8328, -0.6104>, <-1.587, 96.5399, -0.6573>, 0.2172 }
			cylinder { <-1.587, 96.5399, -0.6573>, <-1.7004, 97.2471, -0.7043>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.7004, 97.2471, -0.7043>, <-2.3052, 100.5714, -0.8826>, 0.2172 }
				cylinder { <-2.3052, 100.5714, -0.8826>, <-2.9801, 103.8843, -1.01787>, 0.2172 }
				cylinder { <-2.9801, 103.8843, -1.01787>, <-3.7245, 107.1836, -1.1098>, 0.2172 }
				cylinder { <-3.7245, 107.1836, -1.1098>, <-4.5382, 110.4676, -1.1585>, 0.2172 }
				cylinder { <-4.5382, 110.4676, -1.1585>, <-5.4205, 113.7341, -1.1639>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-5.4205, 113.7341, -1.1639>, <-5.6944, 114.3975, -0.9419>, <-5.6227, 114.4411, -0.9492> }
					triangle { <-5.6944, 114.3975, -0.9419>, <-5.8172, 114.7909, -0.8772>, <-5.6227, 114.4411, -0.9492> }
					triangle { <-5.8172, 114.7909, -0.8772>, <-5.7361, 114.837, -0.8836>, <-5.6227, 114.4411, -0.9492> }
					triangle { <-5.8172, 114.7909, -0.8772>, <-5.8889, 115.4033, -0.7805>, <-5.7361, 114.837, -0.8836> }
					triangle { <-5.7361, 114.837, -0.8836>, <-5.8889, 115.4033, -0.7805>, <-5.6457, 114.837, -0.8594> }
					triangle { <-5.6227, 114.4411, -0.9492>, <-5.7361, 114.837, -0.8836>, <-5.6457, 114.837, -0.8594> }
					triangle { <-5.6227, 114.4411, -0.9492>, <-5.6457, 114.837, -0.8594>, <-5.5415, 114.4407, -0.9356> }
					triangle { <-5.6227, 114.4411, -0.9492>, <-5.5415, 114.4407, -0.9356>, <-5.4205, 113.7341, -1.1639> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.7004, 97.2471, -0.7043>, <-1.8138, 97.9543, -0.7513>, 0.2172 }
			cylinder { <-1.8138, 97.9543, -0.7513>, <-1.9271, 98.6614, -0.7982>, 0.2172 }
			cylinder { <-1.9271, 98.6614, -0.7982>, <-2.04054, 99.3686, -0.8452>, 0.2172 }
			cylinder { <-2.04054, 99.3686, -0.8452>, <-2.1539, 100.0758, -0.8921>, 0.2172 }
			cylinder { <-2.1539, 100.0758, -0.8921>, <-2.2672, 100.783, -0.9391>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.2672, 100.783, -0.9391>, <-2.7212, 104.1296, -1.1446>, 0.2172 }
				cylinder { <-2.7212, 104.1296, -1.1446>, <-3.09436, 107.4872, -1.3343>, 0.2172 }
				cylinder { <-3.09436, 107.4872, -1.3343>, <-3.3865, 110.8537, -1.5079>, 0.2172 }
				cylinder { <-3.3865, 110.8537, -1.5079>, <-3.5975, 114.227, -1.6653>, 0.2172 }
				cylinder { <-3.5975, 114.227, -1.6653>, <-3.7272, 117.6051, -1.8065>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.7272, 117.6051, -1.8065>, <-3.5959, 118.3053, -1.8744>, <-3.6561, 118.3216, -1.9247> }
					triangle { <-3.5959, 118.3053, -1.8744>, <-3.5876, 118.7019, -1.8972>, <-3.6561, 118.3216, -1.9247> }
					triangle { <-3.5876, 118.7019, -1.8972>, <-3.6536, 118.7177, -1.955>, <-3.6561, 118.3216, -1.9247> }
					triangle { <-3.5876, 118.7019, -1.8972>, <-3.6494, 119.2821, -2.01067>, <-3.6536, 118.7177, -1.955> }
					triangle { <-3.6536, 118.7177, -1.955>, <-3.6494, 119.2821, -2.01067>, <-3.6914, 118.6922, -2.03161> }
					triangle { <-3.6561, 118.3216, -1.9247>, <-3.6536, 118.7177, -1.955>, <-3.6914, 118.6922, -2.03161> }
					triangle { <-3.6561, 118.3216, -1.9247>, <-3.6914, 118.6922, -2.03161>, <-3.6956, 118.2976, -1.9881> }
					triangle { <-3.6561, 118.3216, -1.9247>, <-3.6956, 118.2976, -1.9881>, <-3.7272, 117.6051, -1.8065> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 86.6397, 0.0>, <-0.00000002, 87.3574, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 87.3574, 0.0>, <-0.00000002, 88.0752, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 88.0752, 0.0>, <-0.00000002, 88.7929, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 88.7929, 0.0>, <-0.00000002, 89.5106, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 89.5106, 0.0>, <-0.00000002, 90.2283, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 90.2283, 0.0>, <0.05246, 90.9355, 0.1109>, 0.2172 }
			cylinder { <0.05246, 90.9355, 0.1109>, <0.1049, 91.6427, 0.2218>, 0.2172 }
			cylinder { <0.1049, 91.6427, 0.2218>, <0.1573, 92.3498, 0.3327>, 0.2172 }
			cylinder { <0.1573, 92.3498, 0.3327>, <0.2098, 93.05702, 0.4436>, 0.2172 }
			cylinder { <0.2098, 93.05702, 0.4436>, <0.2623, 93.7641, 0.5546>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.2623, 93.7641, 0.5546>, <0.534, 97.1074, 0.9987>, 0.2172 }
				cylinder { <0.534, 97.1074, 0.9987>, <0.83, 100.4582, 1.3637>, 0.2172 }
				cylinder { <0.83, 100.4582, 1.3637>, <1.1501, 103.8145, 1.6495>, 0.2172 }
				cylinder { <1.1501, 103.8145, 1.6495>, <1.494, 107.1742, 1.8558>, 0.2172 }
				cylinder { <1.494, 107.1742, 1.8558>, <1.8616, 110.5353, 1.9825>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.8616, 110.5353, 1.9825>, <2.04219, 111.3414, 2.03703>, <1.9719, 111.3649, 2.09285> }
					triangle { <2.04219, 111.3414, 2.03703>, <2.1371, 111.7783, 2.1435>, <1.9719, 111.3649, 2.09285> }
					triangle { <2.1371, 111.7783, 2.1435>, <2.05675, 111.8028, 2.2033>, <1.9719, 111.3649, 2.09285> }
					triangle { <2.1371, 111.7783, 2.1435>, <2.1646, 112.4316, 2.3566>, <2.05675, 111.8028, 2.2033> }
					triangle { <2.05675, 111.8028, 2.2033>, <2.1646, 112.4316, 2.3566>, <1.9545, 111.7957, 2.2146> }
					triangle { <1.9719, 111.3649, 2.09285>, <2.05675, 111.8028, 2.2033>, <1.9545, 111.7957, 2.2146> }
					triangle { <1.9719, 111.3649, 2.09285>, <1.9545, 111.7957, 2.2146>, <1.8835, 111.3542, 2.1101> }
					triangle { <1.9719, 111.3649, 2.09285>, <1.8835, 111.3542, 2.1101>, <1.8616, 110.5353, 1.9825> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.2623, 93.7641, 0.5546>, <0.3147, 94.4713, 0.6655>, 0.2172 }
			cylinder { <0.3147, 94.4713, 0.6655>, <0.3672, 95.1785, 0.7764>, 0.2172 }
			cylinder { <0.3672, 95.1785, 0.7764>, <0.4197, 95.8856, 0.8873>, 0.2172 }
			cylinder { <0.4197, 95.8856, 0.8873>, <0.4721, 96.5928, 0.9983>, 0.2172 }
			cylinder { <0.4721, 96.5928, 0.9983>, <0.5246, 97.2999, 1.1092>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.5246, 97.2999, 1.1092>, <0.7006, 100.6313, 1.6745>, 0.2172 }
				cylinder { <0.7006, 100.6313, 1.6745>, <0.8051, 103.9583, 2.282>, 0.2172 }
				cylinder { <0.8051, 103.9583, 2.282>, <0.8381, 107.2788, 2.9311>, 0.2172 }
				cylinder { <0.8381, 107.2788, 2.9311>, <0.7995, 110.591, 3.6216>, 0.2172 }
				cylinder { <0.7995, 110.591, 3.6216>, <0.6895, 113.8927, 4.353>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.6895, 113.8927, 4.353>, <0.5634, 114.6069, 4.6629>, <0.6479, 114.6326, 4.6653> }
					triangle { <0.5634, 114.6069, 4.6629>, <0.5345, 115.0281, 4.7792>, <0.6479, 114.6326, 4.6653> }
					triangle { <0.5345, 115.0281, 4.7792>, <0.6293, 115.0537, 4.7835>, <0.6479, 114.6326, 4.6653> }
					triangle { <0.5345, 115.0281, 4.7792>, <0.6113, 115.6524, 4.9626>, <0.6293, 115.0537, 4.7835> }
					triangle { <0.6293, 115.0537, 4.7835>, <0.6113, 115.6524, 4.9626>, <0.7188, 115.0266, 4.8135> }
					triangle { <0.6479, 114.6326, 4.6653>, <0.6293, 115.0537, 4.7835>, <0.7188, 115.0266, 4.8135> }
					triangle { <0.6479, 114.6326, 4.6653>, <0.7188, 115.0266, 4.8135>, <0.729, 114.6089, 4.6837> }
					triangle { <0.6479, 114.6326, 4.6653>, <0.729, 114.6089, 4.6837>, <0.6895, 113.8927, 4.353> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.5246, 97.2999, 1.1092>, <0.577, 98.00715, 1.2201>, 0.2172 }
			cylinder { <0.577, 98.00715, 1.2201>, <0.6295, 98.7143, 1.331>, 0.2172 }
			cylinder { <0.6295, 98.7143, 1.331>, <0.682, 99.4214, 1.4419>, 0.2172 }
			cylinder { <0.682, 99.4214, 1.4419>, <0.7344, 100.1286, 1.5529>, 0.2172 }
			cylinder { <0.7344, 100.1286, 1.5529>, <0.7869, 100.8358, 1.6638>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.7869, 100.8358, 1.6638>, <1.1153, 104.1601, 2.2021>, 0.2172 }
				cylinder { <1.1153, 104.1601, 2.2021>, <1.5245, 107.4729, 2.7555>, 0.2172 }
				cylinder { <1.5245, 107.4729, 2.7555>, <2.0144, 110.7723, 3.3236>, 0.2172 }
				cylinder { <2.0144, 110.7723, 3.3236>, <2.5845, 114.0562, 3.906>, 0.2172 }
				cylinder { <2.5845, 114.0562, 3.906>, <3.2347, 117.3227, 4.5025>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <3.2347, 117.3227, 4.5025>, <3.5867, 117.9861, 4.522>, <3.5287, 118.0297, 4.4793> }
					triangle { <3.5867, 117.9861, 4.522>, <3.7211, 118.3795, 4.5566>, <3.5287, 118.0297, 4.4793> }
					triangle { <3.7211, 118.3795, 4.5566>, <3.6568, 118.4257, 4.5068>, <3.5287, 118.0297, 4.4793> }
					triangle { <3.7211, 118.3795, 4.5566>, <3.8391, 118.992, 4.5331>, <3.6568, 118.4257, 4.5068> }
					triangle { <3.6568, 118.4257, 4.5068>, <3.8391, 118.992, 4.5331>, <3.606, 118.4257, 4.4282> }
					triangle { <3.5287, 118.0297, 4.4793>, <3.6568, 118.4257, 4.5068>, <3.606, 118.4257, 4.4282> }
					triangle { <3.5287, 118.0297, 4.4793>, <3.606, 118.4257, 4.4282>, <3.4776, 118.0294, 4.4147> }
					triangle { <3.5287, 118.0297, 4.4793>, <3.4776, 118.0294, 4.4147>, <3.2347, 117.3227, 4.5025> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.7869, 100.8358, 1.6638>, <0.8394, 101.543, 1.7747>, 0.2172 }
			cylinder { <0.8394, 101.543, 1.7747>, <0.8918, 102.2501, 1.8856>, 0.2172 }
			cylinder { <0.8918, 102.2501, 1.8856>, <0.9443, 102.9573, 1.9966>, 0.2172 }
			cylinder { <0.9443, 102.9573, 1.9966>, <0.9967, 103.6644, 2.1075>, 0.2172 }
			cylinder { <0.9967, 103.6644, 2.1075>, <1.04925, 104.3716, 2.2184>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.04925, 104.3716, 2.2184>, <1.2475, 107.7183, 2.6756>, 0.2172 }
				cylinder { <1.2475, 107.7183, 2.6756>, <1.3966, 111.0758, 3.06671>, 0.2172 }
				cylinder { <1.3966, 111.0758, 3.06671>, <1.4966, 114.4423, 3.3915>, 0.2172 }
				cylinder { <1.4966, 114.4423, 3.3915>, <1.5472, 117.8156, 3.6498>, 0.2172 }
				cylinder { <1.5472, 117.8156, 3.6498>, <1.5485, 121.1937, 3.8416>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.5485, 121.1937, 3.8416>, <1.4056, 121.8939, 3.8037>, <1.4165, 121.9103, 3.8814> }
					triangle { <1.4056, 121.8939, 3.8037>, <1.3841, 122.2905, 3.8151>, <1.4165, 121.9103, 3.8814> }
					triangle { <1.3841, 122.2905, 3.8151>, <1.3942, 122.3063, 3.9022>, <1.4165, 121.9103, 3.8814> }
					triangle { <1.3841, 122.2905, 3.8151>, <1.3537, 122.8708, 3.9406>, <1.3942, 122.3063, 3.9022> }
					triangle { <1.3942, 122.3063, 3.9022>, <1.3537, 122.8708, 3.9406>, <1.3708, 122.2809, 3.9843> }
					triangle { <1.4165, 121.9103, 3.8814>, <1.3942, 122.3063, 3.9022>, <1.3708, 122.2809, 3.9843> }
					triangle { <1.4165, 121.9103, 3.8814>, <1.3708, 122.2809, 3.9843>, <1.4031, 121.8863, 3.9549> }
					triangle { <1.4165, 121.9103, 3.8814>, <1.4031, 121.8863, 3.9549>, <1.5485, 121.1937, 3.8416> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 90.2283, 0.0>, <-0.00000002, 90.9461, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 90.9461, 0.0>, <-0.00000002, 91.6638, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 91.6638, 0.0>, <-0.00000002, 92.3815, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 92.3815, 0.0>, <-0.00000002, 93.09929, 0.0>, 0.2172 }
			cylinder { <-0.00000002, 93.09929, 0.0>, <-0.00000002, 93.817, 0.0>, 0.2172 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 93.817, 0.0>, <0.03561, 94.5241, -0.1174>, 0.2172 }
			cylinder { <0.03561, 94.5241, -0.1174>, <0.07123, 95.2313, -0.2348>, 0.2172 }
			cylinder { <0.07123, 95.2313, -0.2348>, <0.1068, 95.9385, -0.3522>, 0.2172 }
			cylinder { <0.1068, 95.9385, -0.3522>, <0.1424, 96.6456, -0.4696>, 0.2172 }
			cylinder { <0.1424, 96.6456, -0.4696>, <0.178, 97.3528, -0.5871>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.178, 97.3528, -0.5871>, <0.275, 100.6961, -1.09866>, 0.2172 }
				cylinder { <0.275, 100.6961, -1.09866>, <0.3008, 104.0468, -1.5679>, 0.2172 }
				cylinder { <0.3008, 104.0468, -1.5679>, <0.2555, 107.4031, -1.9946>, 0.2172 }
				cylinder { <0.2555, 107.4031, -1.9946>, <0.1392, 110.7628, -2.3784>, 0.2172 }
				cylinder { <0.1392, 110.7628, -2.3784>, <-0.04799, 114.1239, -2.7192>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.04799, 114.1239, -2.7192>, <-0.1451, 114.93, -2.8808>, <-0.05566, 114.9535, -2.8749> }
					triangle { <-0.1451, 114.93, -2.8808>, <-0.1439, 115.367, -3.0235>, <-0.05566, 114.9535, -2.8749> }
					triangle { <-0.1439, 115.367, -3.0235>, <-0.04427, 115.3914, -3.0138>, <-0.05566, 114.9535, -2.8749> }
					triangle { <-0.1439, 115.367, -3.0235>, <-0.02125, 116.0203, -3.1998>, <-0.04427, 115.3914, -3.0138> }
					triangle { <-0.04427, 115.3914, -3.0138>, <-0.02125, 116.0203, -3.1998>, <0.03906, 115.3844, -2.9535> }
					triangle { <-0.05566, 114.9535, -2.8749>, <-0.04427, 115.3914, -3.0138>, <0.03906, 115.3844, -2.9535> }
					triangle { <-0.05566, 114.9535, -2.8749>, <0.03906, 115.3844, -2.9535>, <0.0215, 114.9428, -2.8284> }
					triangle { <-0.05566, 114.9535, -2.8749>, <0.0215, 114.9428, -2.8284>, <-0.04799, 114.1239, -2.7192> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.178, 97.3528, -0.5871>, <0.2137, 98.05998, -0.7045>, 0.2172 }
			cylinder { <0.2137, 98.05998, -0.7045>, <0.2493, 98.7671, -0.8219>, 0.2172 }
			cylinder { <0.2493, 98.7671, -0.8219>, <0.2849, 99.4743, -0.9393>, 0.2172 }
			cylinder { <0.2849, 99.4743, -0.9393>, <0.3205, 100.1815, -1.05678>, 0.2172 }
			cylinder { <0.3205, 100.1815, -1.05678>, <0.3561, 100.8886, -1.1742>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.3561, 100.8886, -1.1742>, <0.6054, 104.22, -1.7112>, 0.2172 }
				cylinder { <0.6054, 104.22, -1.7112>, <0.9359, 107.5469, -2.2315>, 0.2172 }
				cylinder { <0.9359, 107.5469, -2.2315>, <1.3474, 110.8675, -2.7346>, 0.2172 }
				cylinder { <1.3474, 110.8675, -2.7346>, <1.8396, 114.1796, -3.2204>, 0.2172 }
				cylinder { <1.8396, 114.1796, -3.2204>, <2.4123, 117.4813, -3.6884>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <2.4123, 117.4813, -3.6884>, <2.7139, 118.1955, -3.8333>, <2.6529, 118.2212, -3.8919> }
					triangle { <2.7139, 118.1955, -3.8333>, <2.8134, 118.6167, -3.9001>, <2.6529, 118.2212, -3.8919> }
					triangle { <2.8134, 118.6167, -3.9001>, <2.7461, 118.6423, -3.9669>, <2.6529, 118.2212, -3.8919> }
					triangle { <2.8134, 118.6167, -3.9001>, <2.8796, 119.241, -4.08763>, <2.7461, 118.6423, -3.9669> }
					triangle { <2.7461, 118.6423, -3.9669>, <2.8796, 119.241, -4.08763>, <2.6999, 118.6152, -4.04933> }
					triangle { <2.6529, 118.2212, -3.8919>, <2.7461, 118.6423, -3.9669>, <2.6999, 118.6152, -4.04933> }
					triangle { <2.6529, 118.2212, -3.8919>, <2.6999, 118.6152, -4.04933>, <2.6052, 118.1975, -3.96> }
					triangle { <2.6529, 118.2212, -3.8919>, <2.6052, 118.1975, -3.96>, <2.4123, 117.4813, -3.6884> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.3561, 100.8886, -1.1742>, <0.3918, 101.5958, -1.2916>, 0.2172 }
			cylinder { <0.3918, 101.5958, -1.2916>, <0.4274, 102.3029, -1.409>, 0.2172 }
			cylinder { <0.4274, 102.3029, -1.409>, <0.463, 103.0101, -1.5264>, 0.2172 }
			cylinder { <0.463, 103.0101, -1.5264>, <0.4986, 103.7173, -1.6438>, 0.2172 }
			cylinder { <0.4986, 103.7173, -1.6438>, <0.5342, 104.4244, -1.7613>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.5342, 104.4244, -1.7613>, <0.6524, 107.7487, -2.3806>, 0.2172 }
				cylinder { <0.6524, 107.7487, -2.3806>, <0.7208, 111.0615, -3.06553>, 0.2172 }
				cylinder { <0.7208, 111.0615, -3.06553>, <0.7394, 114.3609, -3.8154>, 0.2172 }
				cylinder { <0.7394, 114.3609, -3.8154>, <0.7081, 117.6448, -4.6299>, 0.2172 }
				cylinder { <0.7081, 117.6448, -4.6299>, <0.6269, 120.9113, -5.5084>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.6269, 120.9113, -5.5084>, <0.3792, 121.5748, -5.7593>, <0.3935, 121.6184, -5.6887> }
					triangle { <0.3792, 121.5748, -5.7593>, <0.3028, 121.9681, -5.8752>, <0.3935, 121.6184, -5.6887> }
					triangle { <0.3028, 121.9681, -5.8752>, <0.3171, 122.0143, -5.7951>, <0.3935, 121.6184, -5.6887> }
					triangle { <0.3028, 121.9681, -5.8752>, <0.1996, 122.5806, -5.937>, <0.3171, 122.0143, -5.7951> }
					triangle { <0.3171, 122.0143, -5.7951>, <0.1996, 122.5806, -5.937>, <0.3018, 122.0143, -5.7028> }
					triangle { <0.3935, 121.6184, -5.6887>, <0.3171, 122.0143, -5.7951>, <0.3018, 122.0143, -5.7028> }
					triangle { <0.3935, 121.6184, -5.6887>, <0.3018, 122.0143, -5.7028>, <0.388, 121.618, -5.6065> }
					triangle { <0.3935, 121.6184, -5.6887>, <0.388, 121.618, -5.6065>, <0.6269, 120.9113, -5.5084> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.5342, 104.4244, -1.7613>, <0.5699, 105.1316, -1.8787>, 0.2172 }
			cylinder { <0.5699, 105.1316, -1.8787>, <0.6055, 105.8388, -1.9961>, 0.2172 }
			cylinder { <0.6055, 105.8388, -1.9961>, <0.6411, 106.5459, -2.1135>, 0.2172 }
			cylinder { <0.6411, 106.5459, -2.1135>, <0.6767, 107.2531, -2.2309>, 0.2172 }
			cylinder { <0.6767, 107.2531, -2.2309>, <0.7123, 107.9602, -2.3484>, 0.2172 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.7123, 107.9602, -2.3484>, <0.8724, 111.3069, -2.8202>, 0.2172 }
				cylinder { <0.8724, 111.3069, -2.8202>, <1.02459, 114.6645, -3.2102>, 0.2172 }
				cylinder { <1.02459, 114.6645, -3.2102>, <1.1687, 118.0309, -3.518>, 0.2172 }
				cylinder { <1.1687, 118.0309, -3.518>, <1.3046, 121.4042, -3.7434>, 0.2172 }
				cylinder { <1.3046, 121.4042, -3.7434>, <1.4324, 124.7824, -3.8863>, 0.2172 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.4324, 124.7824, -3.8863>, <1.5129, 125.4825, -3.7623>, <1.557, 125.4989, -3.8272> }
					triangle { <1.5129, 125.4825, -3.7623>, <1.5364, 125.8791, -3.7563>, <1.557, 125.4989, -3.8272> }
					triangle { <1.5364, 125.8791, -3.7563>, <1.5874, 125.895, -3.8277>, <1.557, 125.4989, -3.8272> }
					triangle { <1.5364, 125.8791, -3.7563>, <1.6432, 126.4594, -3.8289>, <1.5874, 125.895, -3.8277> }
					triangle { <1.5874, 125.895, -3.8277>, <1.6432, 126.4594, -3.8289>, <1.66, 125.8695, -3.8728> }
					triangle { <1.557, 125.4989, -3.8272>, <1.5874, 125.895, -3.8277>, <1.66, 125.8695, -3.8728> }
					triangle { <1.557, 125.4989, -3.8272>, <1.66, 125.8695, -3.8728>, <1.6163, 125.4749, -3.8727> }
					triangle { <1.557, 125.4989, -3.8272>, <1.6163, 125.4749, -3.8727>, <1.4324, 124.7824, -3.8863> }
					texture{Grass_Texture8}}
				}
			}
		}
} // end maiden_grass

#declare curvy_maiden_grass = union {
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.3754, 5.9337, 0.225>, 0.09187 }
			cylinder { <0.3754, 5.9337, 0.225>, <1.1242, 11.8192, 0.6738>, 0.09187 }
			cylinder { <1.1242, 11.8192, 0.6738>, <2.2424, 17.6245, 1.344>, 0.09187 }
			cylinder { <2.2424, 17.6245, 1.344>, <3.7238, 23.3182, 2.2319>, 0.09187 }
			cylinder { <3.7238, 23.3182, 2.2319>, <5.5605, 28.8694, 3.3328>, 0.09187 }
			cylinder { <5.5605, 28.8694, 3.3328>, <7.7425, 34.248, 4.6406>, 0.09187 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <7.7425, 34.248, 4.6406>, <8.3424, 35.8853, 5.05149>, 0.09187 }
				cylinder { <8.3424, 35.8853, 5.05149>, <8.8845, 37.5385, 5.4788>, 0.09187 }
				cylinder { <8.8845, 37.5385, 5.4788>, <9.3681, 39.2056, 5.9221>, 0.09187 }
				cylinder { <9.3681, 39.2056, 5.9221>, <9.7927, 40.8845, 6.3808>, 0.09187 }
				cylinder { <9.7927, 40.8845, 6.3808>, <10.1577, 42.5733, 6.8545>, 0.09187 }
				cylinder { <10.1577, 42.5733, 6.8545>, <10.4627, 44.2699, 7.3423>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <10.4627, 44.2699, 7.3423>, <10.5059, 44.4541, 7.3791>, 0.002976 }
				cylinder { <10.5059, 44.4541, 7.3791>, <10.559, 44.6383, 7.3997>, 0.002976 }
				cylinder { <10.559, 44.6383, 7.3997>, <10.6214, 44.8206, 7.404>, 0.002976 }
				cylinder { <10.6214, 44.8206, 7.404>, <10.6927, 44.9993, 7.392>, 0.002976 }
				cylinder { <10.6927, 44.9993, 7.392>, <10.7721, 45.1726, 7.3638>, 0.002976 }
				cylinder { <10.7721, 45.1726, 7.3638>, <10.8589, 45.339, 7.3195>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.8589, 45.339, 7.3195>, <12.09653, 46.5079, 6.5966>, <12.02035, 46.6191, 6.6015> }
				triangle { <12.09653, 46.5079, 6.5966>, <12.751, 47.1396, 6.02813>, <12.02035, 46.6191, 6.6015> }
				triangle { <12.751, 47.1396, 6.02813>, <12.6385, 47.2376, 6.01499>, <12.02035, 46.6191, 6.6015> }
				triangle { <12.751, 47.1396, 6.02813>, <14.5426, 48.8909, 3.8002>, <12.6385, 47.2376, 6.01499> }
				triangle { <12.6385, 47.2376, 6.01499>, <14.5426, 48.8909, 3.8002>, <12.5105, 47.3191, 6.0115> }
				triangle { <12.02035, 46.6191, 6.6015>, <12.6385, 47.2376, 6.01499>, <12.5105, 47.3191, 6.0115> }
				triangle { <12.02035, 46.6191, 6.6015>, <12.5105, 47.3191, 6.0115>, <11.9114, 46.6861, 6.6039> }
				triangle { <12.02035, 46.6191, 6.6015>, <11.9114, 46.6861, 6.6039>, <10.8589, 45.339, 7.3195> }
				triangle { <15.3835, 49.7162, 2.4809>, <14.5426, 48.8909, 3.8002>, <14.6879, 48.7304, 3.7594> }
				triangle { <12.5105, 47.3191, 6.0115>, <14.5426, 48.8909, 3.8002>, <14.3296, 49.02785, 3.6922> }
				triangle { <12.751, 47.1396, 6.02813>, <14.6879, 48.7304, 3.7594>, <14.5426, 48.8909, 3.8002> }
				triangle { <15.3835, 49.7162, 2.4809>, <14.3296, 49.02785, 3.6922>, <14.5426, 48.8909, 3.8002> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <10.4627, 44.2699, 7.3423>, <10.9464, 45.9368, 7.786>, 0.09187 }
				cylinder { <10.9464, 45.9368, 7.786>, <11.6035, 47.556, 8.1811>, 0.09187 }
				cylinder { <11.6035, 47.556, 8.1811>, <12.427, 49.1096, 8.5238>, 0.09187 }
				cylinder { <12.427, 49.1096, 8.5238>, <13.4082, 50.5808, 8.8109>, 0.09187 }
				cylinder { <13.4082, 50.5808, 8.8109>, <14.5365, 51.9534, 9.03983>, 0.09187 }
				cylinder { <14.5365, 51.9534, 9.03983>, <15.7997, 53.2125, 9.2084>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <15.7997, 53.2125, 9.2084>, <15.93, 53.3512, 9.2392>, 0.002976 }
				cylinder { <15.93, 53.3512, 9.2392>, <16.05414, 53.4922, 9.2825>, 0.002976 }
				cylinder { <16.05414, 53.4922, 9.2825>, <16.1712, 53.6349, 9.3381>, 0.002976 }
				cylinder { <16.1712, 53.6349, 9.3381>, <16.2807, 53.7784, 9.4056>, 0.002976 }
				cylinder { <16.2807, 53.7784, 9.4056>, <16.382, 53.9221, 9.4847>, 0.002976 }
				cylinder { <16.382, 53.9221, 9.4847>, <16.4746, 54.06507, 9.575>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <16.4746, 54.06507, 9.575>, <17.8547, 55.19, 10.07563>, <17.7786, 55.2902, 10.1242> }
				triangle { <17.8547, 55.19, 10.07563>, <18.6463, 55.9016, 10.2084>, <17.7786, 55.2902, 10.1242> }
				triangle { <18.6463, 55.9016, 10.2084>, <18.5424, 56.00815, 10.2253>, <17.7786, 55.2902, 10.1242> }
				triangle { <18.6463, 55.9016, 10.2084>, <21.03652, 58.249, 10.07978>, <18.5424, 56.00815, 10.2253> }
				triangle { <18.5424, 56.00815, 10.2253>, <21.03652, 58.249, 10.07978>, <18.421, 56.09872, 10.2353> }
				triangle { <17.7786, 55.2902, 10.1242>, <18.5424, 56.00815, 10.2253>, <18.421, 56.09872, 10.2353> }
				triangle { <17.7786, 55.2902, 10.1242>, <18.421, 56.09872, 10.2353>, <17.6736, 55.3624, 10.1353> }
				triangle { <17.7786, 55.2902, 10.1242>, <17.6736, 55.3624, 10.1353>, <16.4746, 54.06507, 9.575> }
				triangle { <22.2495, 59.509, 9.8155>, <21.03652, 58.249, 10.07978>, <21.1908, 58.1172, 9.9942> }
				triangle { <18.421, 56.09872, 10.2353>, <21.03652, 58.249, 10.07978>, <20.8685, 58.4589, 10.02033> }
				triangle { <18.6463, 55.9016, 10.2084>, <21.1908, 58.1172, 9.9942>, <21.03652, 58.249, 10.07978> }
				triangle { <22.2495, 59.509, 9.8155>, <20.8685, 58.4589, 10.02033>, <21.03652, 58.249, 10.07978> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <15.7997, 53.2125, 9.2084>, <17.1305, 54.4002, 9.3755>, 0.09187 }
				cylinder { <17.1305, 54.4002, 9.3755>, <18.5248, 55.5129, 9.5407>, 0.09187 }
				cylinder { <18.5248, 55.5129, 9.5407>, <19.9784, 56.5473, 9.7035>, 0.09187 }
				cylinder { <19.9784, 56.5473, 9.7035>, <21.487, 57.5002, 9.8634>, 0.09187 }
				cylinder { <21.487, 57.5002, 9.8634>, <23.04608, 58.3688, 10.02013>, 0.09187 }
				cylinder { <23.04608, 58.3688, 10.02013>, <24.6508, 59.1504, 10.1731>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <24.6508, 59.1504, 10.1731>, <24.8291, 59.2222, 10.1594>, 0.002976 }
				cylinder { <24.8291, 59.2222, 10.1594>, <25.008, 59.2796, 10.1159>, 0.002976 }
				cylinder { <25.008, 59.2796, 10.1159>, <25.182, 59.3209, 10.04404>, 0.002976 }
				cylinder { <25.182, 59.3209, 10.04404>, <25.346, 59.3448, 9.9457>, 0.002976 }
				cylinder { <25.346, 59.3448, 9.9457>, <25.4953, 59.3507, 9.8239>, 0.002976 }
				cylinder { <25.4953, 59.3507, 9.8239>, <25.6255, 59.3384, 9.6822>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <25.6255, 59.3384, 9.6822>, <26.539, 58.66, 8.2241>, <26.596, 58.7755, 8.1841> }
				triangle { <26.539, 58.66, 8.2241>, <26.9273, 58.2974, 7.2923>, <26.596, 58.7755, 8.1841> }
				triangle { <26.9273, 58.2974, 7.2923>, <26.951, 58.4395, 7.2514>, <26.596, 58.7755, 8.1841> }
				triangle { <26.9273, 58.2974, 7.2923>, <27.6283, 57.2798, 4.1757>, <26.951, 58.4395, 7.2514> }
				triangle { <26.951, 58.4395, 7.2514>, <27.6283, 57.2798, 4.1757>, <26.9622, 58.5894, 7.2302> }
				triangle { <26.596, 58.7755, 8.1841>, <26.951, 58.4395, 7.2514>, <26.9622, 58.5894, 7.2302> }
				triangle { <26.596, 58.7755, 8.1841>, <26.9622, 58.5894, 7.2302>, <26.6068, 58.9024, 8.1717> }
				triangle { <26.596, 58.7755, 8.1841>, <26.6068, 58.9024, 8.1717>, <25.6255, 59.3384, 9.6822> }
				triangle { <27.8058, 56.7896, 2.4854>, <27.6283, 57.2798, 4.1757>, <27.5402, 57.07933, 4.1988> }
				triangle { <26.9622, 58.5894, 7.2302>, <27.6283, 57.2798, 4.1757>, <27.5904, 57.5245, 4.05561> }
				triangle { <26.9273, 58.2974, 7.2923>, <27.5402, 57.07933, 4.1988>, <27.6283, 57.2798, 4.1757> }
				triangle { <27.8058, 56.7896, 2.4854>, <27.5904, 57.5245, 4.05561>, <27.6283, 57.2798, 4.1757> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <24.6508, 59.1504, 10.1731>, <26.2555, 59.9321, 10.3261>, 0.09187 }
				cylinder { <26.2555, 59.9321, 10.3261>, <27.8602, 60.7137, 10.4792>, 0.09187 }
				cylinder { <27.8602, 60.7137, 10.4792>, <29.4649, 61.4953, 10.6322>, 0.09187 }
				cylinder { <29.4649, 61.4953, 10.6322>, <31.06969, 62.277, 10.7852>, 0.09187 }
				cylinder { <31.06969, 62.277, 10.7852>, <32.6744, 63.05865, 10.9383>, 0.09187 }
				cylinder { <32.6744, 63.05865, 10.9383>, <34.2791, 63.8402, 11.09134>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <34.2791, 63.8402, 11.09134>, <34.4428, 63.9329, 11.1333>, 0.002976 }
				cylinder { <34.4428, 63.9329, 11.1333>, <34.594, 64.03226, 11.1998>, 0.002976 }
				cylinder { <34.594, 64.03226, 11.1998>, <34.7295, 64.1359, 11.2896>, 0.002976 }
				cylinder { <34.7295, 64.1359, 11.2896>, <34.8463, 64.2418, 11.4005>, 0.002976 }
				cylinder { <34.8463, 64.2418, 11.4005>, <34.9418, 64.3476, 11.5303>, 0.002976 }
				cylinder { <34.9418, 64.3476, 11.5303>, <35.01413, 64.451, 11.676>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <35.01413, 64.451, 11.676>, <36.2636, 65.1973, 12.8172>, <36.1862, 65.2968, 12.8651> }
				triangle { <36.2636, 65.1973, 12.8172>, <37.03642, 65.7212, 13.3456>, <36.1862, 65.2968, 12.8651> }
				triangle { <37.03642, 65.7212, 13.3456>, <36.9434, 65.838, 13.3577>, <36.1862, 65.2968, 12.8651> }
				triangle { <37.03642, 65.7212, 13.3456>, <39.5586, 67.6036, 14.5008>, <36.9434, 65.838, 13.3577> }
				triangle { <36.9434, 65.838, 13.3577>, <39.5586, 67.6036, 14.5008>, <36.8347, 65.9438, 13.3544> }
				triangle { <36.1862, 65.2968, 12.8651>, <36.9434, 65.838, 13.3577>, <36.8347, 65.9438, 13.3544> }
				triangle { <36.1862, 65.2968, 12.8651>, <36.8347, 65.9438, 13.3544>, <36.09076, 65.382, 12.863> }
				triangle { <36.1862, 65.2968, 12.8651>, <36.09076, 65.382, 12.863>, <35.01413, 64.451, 11.676> }
				triangle { <40.9092, 68.6661, 14.9202>, <39.5586, 67.6036, 14.5008>, <39.7186, 67.4679, 14.4335> }
				triangle { <36.8347, 65.9438, 13.3544>, <39.5586, 67.6036, 14.5008>, <39.4399, 67.8466, 14.4495> }
				triangle { <37.03642, 65.7212, 13.3456>, <39.7186, 67.4679, 14.4335>, <39.5586, 67.6036, 14.5008> }
				triangle { <40.9092, 68.6661, 14.9202>, <39.4399, 67.8466, 14.4495>, <39.5586, 67.6036, 14.5008> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <34.2791, 63.8402, 11.09134>, <35.8557, 64.6729, 11.2661>, 0.09187 }
				cylinder { <35.8557, 64.6729, 11.2661>, <37.4023, 65.5555, 11.4625>, 0.09187 }
				cylinder { <37.4023, 65.5555, 11.4625>, <38.917, 66.4871, 11.6802>, 0.09187 }
				cylinder { <38.917, 66.4871, 11.6802>, <40.3979, 67.4665, 11.9189>, 0.09187 }
				cylinder { <40.3979, 67.4665, 11.9189>, <41.8434, 68.4925, 12.1784>, 0.09187 }
				cylinder { <41.8434, 68.4925, 12.1784>, <43.2517, 69.564, 12.4582>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <43.2517, 69.564, 12.4582>, <43.4095, 69.6738, 12.4714>, 0.002976 }
				cylinder { <43.4095, 69.6738, 12.4714>, <43.5723, 69.777, 12.4675>, 0.002976 }
				cylinder { <43.5723, 69.777, 12.4675>, <43.7383, 69.8728, 12.4465>, 0.002976 }
				cylinder { <43.7383, 69.8728, 12.4465>, <43.9059, 69.96, 12.4087>, 0.002976 }
				cylinder { <43.9059, 69.96, 12.4087>, <44.07373, 70.03803, 12.3545>, 0.002976 }
				cylinder { <44.07373, 70.03803, 12.3545>, <44.2399, 70.1059, 12.2843>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <44.2399, 70.1059, 12.2843>, <45.8104, 70.1702, 11.3097>, <45.8272, 70.304, 11.3126> }
				triangle { <45.8104, 70.1702, 11.3097>, <46.6214, 70.2151, 10.6089>, <45.8272, 70.304, 11.3126> }
				triangle { <46.6214, 70.2151, 10.6089>, <46.5999, 70.363, 10.5995>, <45.8272, 70.304, 11.3126> }
				triangle { <46.6214, 70.2151, 10.6089>, <48.7527, 70.3574, 8.02493>, <46.5999, 70.363, 10.5995> }
				triangle { <46.5999, 70.363, 10.5995>, <48.7527, 70.3574, 8.02493>, <46.5575, 70.5088, 10.6032> }
				triangle { <45.8272, 70.304, 11.3126>, <46.5999, 70.363, 10.5995>, <46.5575, 70.5088, 10.6032> }
				triangle { <45.8272, 70.304, 11.3126>, <46.5575, 70.5088, 10.6032>, <45.7905, 70.4262, 11.3211> }
				triangle { <45.8272, 70.304, 11.3126>, <45.7905, 70.4262, 11.3211>, <44.2399, 70.1059, 12.2843> }
				triangle { <49.7133, 70.4277, 6.5412>, <48.7527, 70.3574, 8.02493>, <48.7495, 70.1411, 7.9832> }
				triangle { <46.5575, 70.5088, 10.6032>, <48.7527, 70.3574, 8.02493>, <48.6675, 70.6013, 7.9298> }
				triangle { <46.6214, 70.2151, 10.6089>, <48.7495, 70.1411, 7.9832>, <48.7527, 70.3574, 8.02493> }
				triangle { <49.7133, 70.4277, 6.5412>, <48.6675, 70.6013, 7.9298>, <48.7527, 70.3574, 8.02493> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <43.2517, 69.564, 12.4582>, <44.7326, 70.5433, 12.6971>, 0.09187 }
				cylinder { <44.7326, 70.5433, 12.6971>, <46.2792, 71.4258, 12.8939>, 0.09187 }
				cylinder { <46.2792, 71.4258, 12.8939>, <47.884, 72.2071, 13.04794>, 0.09187 }
				cylinder { <47.884, 72.2071, 13.04794>, <49.5393, 72.8835, 13.1585>, 0.09187 }
				cylinder { <49.5393, 72.8835, 13.1585>, <51.237, 73.4515, 13.2252>, 0.09187 }
				cylinder { <51.237, 73.4515, 13.2252>, <52.9691, 73.9085, 13.2479>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <52.9691, 73.9085, 13.2479>, <53.1533, 73.9631, 13.2633>, 0.002976 }
				cylinder { <53.1533, 73.9631, 13.2633>, <53.3344, 74.02298, 13.2915>, 0.002976 }
				cylinder { <53.3344, 74.02298, 13.2915>, <53.5114, 74.08761, 13.3324>, 0.002976 }
				cylinder { <53.5114, 74.08761, 13.3324>, <53.6832, 74.1567, 13.3857>, 0.002976 }
				cylinder { <53.6832, 74.1567, 13.3857>, <53.849, 74.2299, 13.4513>, 0.002976 }
				cylinder { <53.849, 74.2299, 13.4513>, <54.00801, 74.3069, 13.5286>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <54.00801, 74.3069, 13.5286>, <55.8023, 74.5875, 13.8783>, <55.7909, 74.7121, 13.9287> }
				triangle { <55.8023, 74.5875, 13.8783>, <56.8514, 74.8068, 13.9225>, <55.7909, 74.7121, 13.9287> }
				triangle { <56.8514, 74.8068, 13.9225>, <56.8164, 74.9509, 13.9433>, <55.7909, 74.7121, 13.9287> }
				triangle { <56.8514, 74.8068, 13.9225>, <60.07301, 75.6435, 13.5208>, <56.8164, 74.9509, 13.9433> }
				triangle { <56.8164, 74.9509, 13.9433>, <60.07301, 75.6435, 13.5208>, <56.7578, 75.09006, 13.9591> }
				triangle { <55.7909, 74.7121, 13.9287>, <56.8164, 74.9509, 13.9433>, <56.7578, 75.09006, 13.9591> }
				triangle { <55.7909, 74.7121, 13.9287>, <56.7578, 75.09006, 13.9591>, <55.7373, 74.8271, 13.945> }
				triangle { <55.7909, 74.7121, 13.9287>, <55.7373, 74.8271, 13.945>, <54.00801, 74.3069, 13.5286> }
				triangle { <61.7252, 76.1286, 13.1161>, <60.07301, 75.6435, 13.5208>, <60.1329, 75.4526, 13.4289> }
				triangle { <56.7578, 75.09006, 13.9591>, <60.07301, 75.6435, 13.5208>, <60.0278, 75.9095, 13.4664> }
				triangle { <56.8514, 74.8068, 13.9225>, <60.1329, 75.4526, 13.4289>, <60.07301, 75.6435, 13.5208> }
				triangle { <61.7252, 76.1286, 13.1161>, <60.0278, 75.9095, 13.4664>, <60.07301, 75.6435, 13.5208> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <52.9691, 73.9085, 13.2479>, <54.6956, 74.3827, 13.3107>, 0.09187 }
				cylinder { <54.6956, 74.3827, 13.3107>, <56.4154, 74.8738, 13.4136>, 0.09187 }
				cylinder { <56.4154, 74.8738, 13.4136>, <58.1275, 75.3815, 13.5564>, 0.09187 }
				cylinder { <58.1275, 75.3815, 13.5564>, <59.8309, 75.9055, 13.7391>, 0.09187 }
				cylinder { <59.8309, 75.9055, 13.7391>, <61.5245, 76.4455, 13.9616>, 0.09187 }
				cylinder { <61.5245, 76.4455, 13.9616>, <63.2074, 77.00128, 14.2237>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <63.2074, 77.00128, 14.2237>, <63.3924, 77.05412, 14.2347>, 0.002976 }
				cylinder { <63.3924, 77.05412, 14.2347>, <63.5797, 77.0995, 14.2286>, 0.002976 }
				cylinder { <63.5797, 77.0995, 14.2286>, <63.7673, 77.1369, 14.2052>, 0.002976 }
				cylinder { <63.7673, 77.1369, 14.2052>, <63.9535, 77.1662, 14.1649>, 0.002976 }
				cylinder { <63.9535, 77.1662, 14.1649>, <64.1366, 77.1869, 14.108>, 0.002976 }
				cylinder { <64.1366, 77.1869, 14.108>, <64.3146, 77.1988, 14.03509>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <64.3146, 77.1988, 14.03509>, <65.806, 76.7703, 13.02873>, <65.8651, 76.8915, 13.03275> }
				triangle { <65.806, 76.7703, 13.02873>, <66.5766, 76.5635, 12.3117>, <65.8651, 76.8915, 13.03275> }
				triangle { <66.5766, 76.5635, 12.3117>, <66.6038, 76.7106, 12.3044>, <65.8651, 76.8915, 13.03275> }
				triangle { <66.5766, 76.5635, 12.3117>, <68.5978, 76.05557, 9.6855>, <66.6038, 76.7106, 12.3044> }
				triangle { <66.6038, 76.7106, 12.3044>, <68.5978, 76.05557, 9.6855>, <66.6108, 76.8621, 12.3105> }
				triangle { <65.8651, 76.8915, 13.03275>, <66.6038, 76.7106, 12.3044>, <66.6108, 76.8621, 12.3105> }
				triangle { <65.8651, 76.8915, 13.03275>, <66.6108, 76.8621, 12.3105>, <65.8698, 77.01892, 13.04341> }
				triangle { <65.8651, 76.8915, 13.03275>, <65.8698, 77.01892, 13.04341>, <64.3146, 77.1988, 14.03509> }
				triangle { <69.5056, 75.8379, 8.1831>, <68.5978, 76.05557, 9.6855>, <68.5244, 75.8526, 9.6416> }
				triangle { <66.6108, 76.8621, 12.3105>, <68.5978, 76.05557, 9.6855>, <68.5942, 76.3154, 9.5949> }
				triangle { <66.5766, 76.5635, 12.3117>, <68.5244, 75.8526, 9.6416>, <68.5978, 76.05557, 9.6855> }
				triangle { <69.5056, 75.8379, 8.1831>, <68.5942, 76.3154, 9.5949>, <68.5978, 76.05557, 9.6855> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <63.2074, 77.00128, 14.2237>, <64.8997, 77.518, 14.5038>, 0.09187 }
				cylinder { <64.8997, 77.518, 14.5038>, <66.6006, 77.9954, 14.8017>, 0.09187 }
				cylinder { <66.6006, 77.9954, 14.8017>, <68.3088, 78.4332, 15.1173>, 0.09187 }
				cylinder { <68.3088, 78.4332, 15.1173>, <70.0236, 78.8312, 15.4503>, 0.09187 }
				cylinder { <70.0236, 78.8312, 15.4503>, <71.7436, 79.1891, 15.8005>, 0.09187 }
				cylinder { <71.7436, 79.1891, 15.8005>, <73.4681, 79.5067, 16.1678>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <73.4681, 79.5067, 16.1678>, <73.6462, 79.549, 16.2283>, 0.002976 }
				cylinder { <73.6462, 79.549, 16.2283>, <73.8142, 79.5986, 16.3087>, 0.002976 }
				cylinder { <73.8142, 79.5986, 16.3087>, <73.9695, 79.655, 16.408>, 0.002976 }
				cylinder { <73.9695, 79.655, 16.408>, <74.1098, 79.7172, 16.5247>, 0.002976 }
				cylinder { <74.1098, 79.7172, 16.5247>, <74.233, 79.7842, 16.6569>, 0.002976 }
				cylinder { <74.233, 79.7842, 16.6569>, <74.3373, 79.8552, 16.8026>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <74.3373, 79.8552, 16.8026>, <75.7807, 80.1317, 17.9254>, <75.7402, 80.2495, 17.9771> }
				triangle { <75.7807, 80.1317, 17.9254>, <76.6902, 80.3662, 18.4437>, <75.7402, 80.2495, 17.9771> }
				triangle { <76.6902, 80.3662, 18.4437>, <76.6399, 80.5063, 18.4603>, <75.7402, 80.2495, 17.9771> }
				triangle { <76.6902, 80.3662, 18.4437>, <79.7039, 81.3098, 19.5693>, <76.6399, 80.5063, 18.4603> }
				triangle { <76.6399, 80.5063, 18.4603>, <79.7039, 81.3098, 19.5693>, <76.5709, 80.6415, 18.4618> }
				triangle { <75.7402, 80.2495, 17.9771>, <76.6399, 80.5063, 18.4603>, <76.5709, 80.6415, 18.4618> }
				triangle { <75.7402, 80.2495, 17.9771>, <76.5709, 80.6415, 18.4618>, <75.6771, 80.3608, 17.979> }
				triangle { <75.7402, 80.2495, 17.9771>, <75.6771, 80.3608, 17.979>, <74.3373, 79.8552, 16.8026> }
				triangle { <81.3316, 81.8719, 19.974>, <79.7039, 81.3098, 19.5693>, <79.8105, 81.1318, 19.4955> }
				triangle { <76.5709, 80.6415, 18.4618>, <79.7039, 81.3098, 19.5693>, <79.6686, 81.5793, 19.5256> }
				triangle { <76.6902, 80.3662, 18.4437>, <79.8105, 81.1318, 19.4955>, <79.7039, 81.3098, 19.5693> }
				triangle { <81.3316, 81.8719, 19.974>, <79.6686, 81.5793, 19.5256>, <79.7039, 81.3098, 19.5693> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <73.4681, 79.5067, 16.1678>, <73.6536, 79.5409, 16.2073>, 0.002976 }
				cylinder { <73.6536, 79.5409, 16.2073>, <73.8392, 79.5751, 16.2468>, 0.002976 }
				cylinder { <73.8392, 79.5751, 16.2468>, <74.02478, 79.6092, 16.2864>, 0.002976 }
				cylinder { <74.02478, 79.6092, 16.2864>, <74.2103, 79.6434, 16.3259>, 0.002976 }
				cylinder { <74.2103, 79.6434, 16.3259>, <74.3958, 79.6776, 16.3654>, 0.002976 }
				cylinder { <74.3958, 79.6776, 16.3654>, <74.5814, 79.7118, 16.4049>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <74.5814, 79.7118, 16.4049>, <76.422, 79.5368, 16.3603>, <76.4523, 79.6595, 16.4075> }
				triangle { <76.422, 79.5368, 16.3603>, <77.4777, 79.4908, 16.1757>, <76.4523, 79.6595, 16.4075> }
				triangle { <77.4777, 79.4908, 16.1757>, <77.4841, 79.6387, 16.1983>, <76.4523, 79.6595, 16.4075> }
				triangle { <77.4777, 79.4908, 16.1757>, <80.6454, 79.5174, 15.07799>, <77.4841, 79.6387, 16.1983> }
				triangle { <77.4841, 79.6387, 16.1983>, <80.6454, 79.5174, 15.07799>, <77.4659, 79.7876, 16.2211> }
				triangle { <76.4523, 79.6595, 16.4075>, <77.4841, 79.6387, 16.1983>, <77.4659, 79.7876, 16.2211> }
				triangle { <76.4523, 79.6595, 16.4075>, <77.4659, 79.7876, 16.2211>, <76.4331, 79.7838, 16.4307> }
				triangle { <76.4523, 79.6595, 16.4075>, <76.4331, 79.7838, 16.4307>, <74.5814, 79.7118, 16.4049> }
				triangle { <82.2415, 79.5888, 14.3188>, <80.6454, 79.5174, 15.07799>, <80.6361, 79.3192, 14.9823> }
				triangle { <77.4659, 79.7876, 16.2211>, <80.6454, 79.5174, 15.07799>, <80.6559, 79.7873, 15.02491> }
				triangle { <77.4777, 79.4908, 16.1757>, <80.6361, 79.3192, 14.9823>, <80.6454, 79.5174, 15.07799> }
				triangle { <82.2415, 79.5888, 14.3188>, <80.6559, 79.7873, 15.02491>, <80.6454, 79.5174, 15.07799> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 5.9498, 0.0>, 0.09187 }
			cylinder { <-0.0, 5.9498, 0.0>, <-0.0, 11.8997, 0.0>, 0.09187 }
			cylinder { <-0.0, 11.8997, 0.0>, <-0.0, 17.8496, 0.0>, 0.09187 }
			cylinder { <-0.0, 17.8496, 0.0>, <-0.0, 23.7995, 0.0>, 0.09187 }
			cylinder { <-0.0, 23.7995, 0.0>, <-0.00000001, 29.7494, 0.0>, 0.09187 }
			cylinder { <-0.00000001, 29.7494, 0.0>, <-0.00000001, 35.6992, 0.0>, 0.09187 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.00000001, 35.6992, 0.0>, <0.08288, 37.488, -0.05277>, 0.09187 }
				cylinder { <0.08288, 37.488, -0.05277>, <0.2484, 39.2688, -0.1581>, 0.09187 }
				cylinder { <0.2484, 39.2688, -0.1581>, <0.4962, 41.03611, -0.3156>, 0.09187 }
				cylinder { <0.4962, 41.03611, -0.3156>, <0.8254, 42.7846, -0.5248>, 0.09187 }
				cylinder { <0.8254, 42.7846, -0.5248>, <1.2352, 44.5091, -0.785>, 0.09187 }
				cylinder { <1.2352, 44.5091, -0.785>, <1.7243, 46.2043, -1.09541>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.7243, 46.2043, -1.09541>, <1.7701, 46.3904, -1.1169>, 0.002976 }
				cylinder { <1.7701, 46.3904, -1.1169>, <1.8086, 46.579, -1.1265>, 0.002976 }
				cylinder { <1.8086, 46.579, -1.1265>, <1.8399, 46.7692, -1.124>, 0.002976 }
				cylinder { <1.8399, 46.7692, -1.124>, <1.8635, 46.96, -1.1095>, 0.002976 }
				cylinder { <1.8635, 46.96, -1.1095>, <1.8796, 47.1502, -1.0831>, 0.002976 }
				cylinder { <1.8796, 47.1502, -1.0831>, <1.8879, 47.339, -1.04487>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.8879, 47.339, -1.04487>, <2.4975, 49.06972, -0.8131>, <2.6243, 49.03905, -0.779> }
				triangle { <2.4975, 49.06972, -0.8131>, <2.7962, 50.05747, -0.5202>, <2.6243, 49.03905, -0.779> }
				triangle { <2.7962, 50.05747, -0.5202>, <2.9173, 49.9974, -0.4557>, <2.6243, 49.03905, -0.779> }
				triangle { <2.7962, 50.05747, -0.5202>, <3.5035, 53.01339, 0.8947>, <2.9173, 49.9974, -0.4557> }
				triangle { <2.9173, 49.9974, -0.4557>, <3.5035, 53.01339, 0.8947>, <3.02922, 49.9148, -0.3948> }
				triangle { <2.6243, 49.03905, -0.779>, <2.9173, 49.9974, -0.4557>, <3.02922, 49.9148, -0.3948> }
				triangle { <2.6243, 49.03905, -0.779>, <3.02922, 49.9148, -0.3948>, <2.7183, 48.966, -0.7322> }
				triangle { <2.6243, 49.03905, -0.779>, <2.7183, 48.966, -0.7322>, <1.8879, 47.339, -1.04487> }
				triangle { <3.7851, 54.5017, 1.8082>, <3.5035, 53.01339, 0.8947>, <3.304, 53.1006, 0.8618> }
				triangle { <3.02922, 49.9148, -0.3948>, <3.5035, 53.01339, 0.8947>, <3.6709, 52.9136, 1.08922> }
				triangle { <2.7962, 50.05747, -0.5202>, <3.304, 53.1006, 0.8618>, <3.5035, 53.01339, 0.8947> }
				triangle { <3.7851, 54.5017, 1.8082>, <3.6709, 52.9136, 1.08922>, <3.5035, 53.01339, 0.8947> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <1.7243, 46.2043, -1.09541>, <2.1183, 47.9224, -1.4154>, 0.09187 }
				cylinder { <2.1183, 47.9224, -1.4154>, <2.416, 49.6582, -1.7442>, 0.09187 }
				cylinder { <2.416, 49.6582, -1.7442>, <2.6165, 51.4063, -2.08089>, 0.09187 }
				cylinder { <2.6165, 51.4063, -2.08089>, <2.7192, 53.1616, -2.4244>, 0.09187 }
				cylinder { <2.7192, 53.1616, -2.4244>, <2.7238, 54.9187, -2.7738>, 0.09187 }
				cylinder { <2.7238, 54.9187, -2.7738>, <2.6302, 56.6723, -3.1282>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.6302, 56.6723, -3.1282>, <2.6296, 56.8573, -3.1823>, 0.002976 }
				cylinder { <2.6296, 56.8573, -3.1823>, <2.6384, 57.03691, -3.2518>, 0.002976 }
				cylinder { <2.6384, 57.03691, -3.2518>, <2.6565, 57.2092, -3.3362>, 0.002976 }
				cylinder { <2.6565, 57.2092, -3.3362>, <2.6838, 57.3728, -3.4346>, 0.002976 }
				cylinder { <2.6838, 57.3728, -3.4346>, <2.72, 57.5258, -3.546>, 0.002976 }
				cylinder { <2.72, 57.5258, -3.546>, <2.7648, 57.6671, -3.6693>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.7648, 57.6671, -3.6693>, <3.6792, 58.7564, -4.8517>, <3.8027, 58.7371, -4.8011> }
				triangle { <3.6792, 58.7564, -4.8517>, <4.1758, 59.5122, -5.4285>, <3.8027, 58.7371, -4.8011> }
				triangle { <4.1758, 59.5122, -5.4285>, <4.2932, 59.4999, -5.3363>, <3.8027, 58.7371, -4.8011> }
				triangle { <4.1758, 59.5122, -5.4285>, <5.5558, 62.2285, -6.8275>, <4.2932, 59.4999, -5.3363> }
				triangle { <4.2932, 59.4999, -5.3363>, <5.5558, 62.2285, -6.8275>, <4.3973, 59.4732, -5.2291> }
				triangle { <3.8027, 58.7371, -4.8011>, <4.2932, 59.4999, -5.3363>, <4.3973, 59.4732, -5.2291> }
				triangle { <3.8027, 58.7371, -4.8011>, <4.3973, 59.4732, -5.2291>, <3.889, 58.7091, -4.7109> }
				triangle { <3.8027, 58.7371, -4.8011>, <3.889, 58.7091, -4.7109>, <2.7648, 57.6671, -3.6693> }
				triangle { <6.2064, 63.7669, -7.41>, <5.5558, 62.2285, -6.8275>, <5.3709, 62.2983, -6.9247> }
				triangle { <4.3973, 59.4732, -5.2291>, <5.5558, 62.2285, -6.8275>, <5.7302, 62.2824, -6.6215> }
				triangle { <4.1758, 59.5122, -5.4285>, <5.3709, 62.2983, -6.9247>, <5.5558, 62.2285, -6.8275> }
				triangle { <6.2064, 63.7669, -7.41>, <5.7302, 62.2824, -6.6215>, <5.5558, 62.2285, -6.8275> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.6302, 56.6723, -3.1282>, <2.4769, 58.425, -3.4657>, 0.09187 }
				cylinder { <2.4769, 58.425, -3.4657>, <2.2638, 60.1747, -3.786>, 0.09187 }
				cylinder { <2.2638, 60.1747, -3.786>, <1.9913, 61.9193, -4.08882>, 0.09187 }
				cylinder { <1.9913, 61.9193, -4.08882>, <1.6597, 63.6567, -4.3736>, 0.09187 }
				cylinder { <1.6597, 63.6567, -4.3736>, <1.2694, 65.3847, -4.6402>, 0.09187 }
				cylinder { <1.2694, 65.3847, -4.6402>, <0.8209, 67.1013, -4.8883>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.8209, 67.1013, -4.8883>, <0.7597, 67.2841, -4.8898>, 0.002976 }
				cylinder { <0.7597, 67.2841, -4.8898>, <0.6869, 67.4611, -4.8661>, 0.002976 }
				cylinder { <0.6869, 67.4611, -4.8661>, <0.6041, 67.6283, -4.8177>, 0.002976 }
				cylinder { <0.6041, 67.6283, -4.8177>, <0.5131, 67.7822, -4.7457>, 0.002976 }
				cylinder { <0.5131, 67.7822, -4.7457>, <0.4158, 67.9194, -4.6516>, 0.002976 }
				cylinder { <0.4158, 67.9194, -4.6516>, <0.3144, 68.03706, -4.5374>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.3144, 68.03706, -4.5374>, <-0.2503, 69.5128, -3.5763>, <-0.1285, 69.566, -3.553> }
				triangle { <-0.2503, 69.5128, -3.5763>, <-0.5683, 70.2681, -2.8841>, <-0.1285, 69.566, -3.553> }
				triangle { <-0.5683, 70.2681, -2.8841>, <-0.4248, 70.2878, -2.8458>, <-0.1285, 69.566, -3.553> }
				triangle { <-0.5683, 70.2681, -2.8841>, <-1.5218, 72.222, -0.3321>, <-0.4248, 70.2878, -2.8458> }
				triangle { <-0.4248, 70.2878, -2.8458>, <-1.5218, 72.222, -0.3321>, <-0.2751, 70.2875, -2.8206> }
				triangle { <-0.1285, 69.566, -3.553>, <-0.4248, 70.2878, -2.8458>, <-0.2751, 70.2875, -2.8206> }
				triangle { <-0.1285, 69.566, -3.553>, <-0.2751, 70.2875, -2.8206>, <-0.001618, 69.5649, -3.5373> }
				triangle { <-0.1285, 69.566, -3.553>, <-0.001618, 69.5649, -3.5373>, <0.3144, 68.03706, -4.5374> }
				triangle { <-2.006136, 73.08836, 1.132>, <-1.5218, 72.222, -0.3321>, <-1.7322, 72.1572, -0.3336> }
				triangle { <-0.2751, 70.2875, -2.8206>, <-1.5218, 72.222, -0.3321>, <-1.2864, 72.2027, -0.1906> }
				triangle { <-0.5683, 70.2681, -2.8841>, <-1.7322, 72.1572, -0.3336>, <-1.5218, 72.222, -0.3321> }
				triangle { <-2.006136, 73.08836, 1.132>, <-1.2864, 72.2027, -0.1906>, <-1.5218, 72.222, -0.3321> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.8209, 67.1013, -4.8883>, <0.3354, 68.8049, -5.1562>, 0.09187 }
				cylinder { <0.3354, 68.8049, -5.1562>, <-0.1866, 70.4943, -5.444>, 0.09187 }
				cylinder { <-0.1866, 70.4943, -5.444>, <-0.7451, 72.1685, -5.7513>, 0.09187 }
				cylinder { <-0.7451, 72.1685, -5.7513>, <-1.3395, 73.8267, -6.07804>, 0.09187 }
				cylinder { <-1.3395, 73.8267, -6.07804>, <-1.9697, 75.4676, -6.4239>, 0.09187 }
				cylinder { <-1.9697, 75.4676, -6.4239>, <-2.635, 77.09053, -6.7888>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-2.635, 77.09053, -6.7888>, <-2.6949, 77.2637, -6.8485>, 0.002976 }
				cylinder { <-2.6949, 77.2637, -6.8485>, <-2.7421, 77.433, -6.9278>, 0.002976 }
				cylinder { <-2.7421, 77.433, -6.9278>, <-2.7759, 77.5957, -7.02554>, 0.002976 }
				cylinder { <-2.7759, 77.5957, -7.02554>, <-2.7958, 77.7494, -7.1401>, 0.002976 }
				cylinder { <-2.7958, 77.7494, -7.1401>, <-2.8016, 77.8919, -7.2698>, 0.002976 }
				cylinder { <-2.8016, 77.8919, -7.2698>, <-2.7931, 78.0209, -7.4128>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.7931, 78.0209, -7.4128>, <-2.1753, 79.1273, -8.7599>, <-2.05143, 79.1473, -8.7105> }
				triangle { <-2.1753, 79.1273, -8.7599>, <-1.8821, 79.8947, -9.4497>, <-2.05143, 79.1473, -8.7105> }
				triangle { <-1.8821, 79.8947, -9.4497>, <-1.7663, 79.9256, -9.36>, <-2.05143, 79.1473, -8.7105> }
				triangle { <-1.8821, 79.8947, -9.4497>, <-1.2258, 82.6454, -11.2505>, <-1.7663, 79.9256, -9.36> }
				triangle { <-1.7663, 79.9256, -9.36>, <-1.2258, 82.6454, -11.2505>, <-1.6598, 79.9416, -9.253> }
				triangle { <-2.05143, 79.1473, -8.7105>, <-1.7663, 79.9256, -9.36>, <-1.6598, 79.9416, -9.253> }
				triangle { <-2.05143, 79.1473, -8.7105>, <-1.6598, 79.9416, -9.253>, <-1.9616, 79.1551, -8.6197> }
				triangle { <-2.05143, 79.1473, -8.7105>, <-1.9616, 79.1551, -8.6197>, <-2.7931, 78.0209, -7.4128> }
				triangle { <-0.9826, 84.1998, -12.05905>, <-1.2258, 82.6454, -11.2505>, <-1.4215, 82.6517, -11.3513> }
				triangle { <-1.6598, 79.9416, -9.253>, <-1.2258, 82.6454, -11.2505>, <-1.07277, 82.7703, -11.05886> }
				triangle { <-1.8821, 79.8947, -9.4497>, <-1.4215, 82.6517, -11.3513>, <-1.2258, 82.6454, -11.2505> }
				triangle { <-0.9826, 84.1998, -12.05905>, <-1.07277, 82.7703, -11.05886>, <-1.2258, 82.6454, -11.2505> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-2.635, 77.09053, -6.7888>, <-3.4446, 78.6514, -7.1317>, 0.09187 }
				cylinder { <-3.4446, 78.6514, -7.1317>, <-4.392, 80.1382, -7.4503>, 0.09187 }
				cylinder { <-4.392, 80.1382, -7.4503>, <-5.4699, 81.539, -7.7423>, 0.09187 }
				cylinder { <-5.4699, 81.539, -7.7423>, <-6.6699, 82.8429, -8.005823>, 0.09187 }
				cylinder { <-6.6699, 82.8429, -8.005823>, <-7.9825, 84.03975, -8.2388>, 0.09187 }
				cylinder { <-7.9825, 84.03975, -8.2388>, <-9.3975, 85.1199, -8.44>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-9.3975, 85.1199, -8.44>, <-9.5577, 85.2268, -8.4309>, 0.002976 }
				cylinder { <-9.5577, 85.2268, -8.4309>, <-9.721, 85.3212, -8.3913>, 0.002976 }
				cylinder { <-9.721, 85.3212, -8.3913>, <-9.8827, 85.4003, -8.3225>, 0.002976 }
				cylinder { <-9.8827, 85.4003, -8.3225>, <-10.03806, 85.4619, -8.2263>, 0.002976 }
				cylinder { <-10.03806, 85.4619, -8.2263>, <-10.1824, 85.5041, -8.1058>, 0.002976 }
				cylinder { <-10.1824, 85.5041, -8.1058>, <-10.3115, 85.5257, -7.9643>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.3115, 85.5257, -7.9643>, <-11.4946, 86.2635, -6.7492>, <-11.4337, 86.3832, -6.7361> }
				triangle { <-11.4946, 86.2635, -6.7492>, <-12.08363, 86.6203, -5.9267>, <-11.4337, 86.3832, -6.7361> }
				triangle { <-12.08363, 86.6203, -5.9267>, <-11.9822, 86.7286, -5.9062>, <-11.4337, 86.3832, -6.7361> }
				triangle { <-12.08363, 86.6203, -5.9267>, <-13.5601, 87.4504, -3.03349>, <-11.9822, 86.7286, -5.9062> }
				triangle { <-11.9822, 86.7286, -5.9062>, <-13.5601, 87.4504, -3.03349>, <-11.8659, 86.8261, -5.9021> }
				triangle { <-11.4337, 86.3832, -6.7361>, <-11.9822, 86.7286, -5.9062>, <-11.8659, 86.8261, -5.9021> }
				triangle { <-11.4337, 86.3832, -6.7361>, <-11.8659, 86.8261, -5.9021>, <-11.3356, 86.4652, -6.7382> }
				triangle { <-11.4337, 86.3832, -6.7361>, <-11.3356, 86.4652, -6.7382>, <-10.3115, 85.5257, -7.9643> }
				triangle { <-14.1973, 87.7749, -1.4155>, <-13.5601, 87.4504, -3.03349>, <-13.6755, 87.2637, -3.0145> }
				triangle { <-11.8659, 86.8261, -5.9021>, <-13.5601, 87.4504, -3.03349>, <-13.3458, 87.5883, -2.9295> }
				triangle { <-12.08363, 86.6203, -5.9267>, <-13.6755, 87.2637, -3.0145>, <-13.5601, 87.4504, -3.03349> }
				triangle { <-14.1973, 87.7749, -1.4155>, <-13.3458, 87.5883, -2.9295>, <-13.5601, 87.4504, -3.03349> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-9.3975, 85.1199, -8.44>, <-10.9039, 86.07494, -8.608>, 0.09187 }
				cylinder { <-10.9039, 86.07494, -8.608>, <-12.4899, 86.8973, -8.7417>, 0.09187 }
				cylinder { <-12.4899, 86.8973, -8.7417>, <-14.143, 87.5805, -8.8404>, 0.09187 }
				cylinder { <-14.143, 87.5805, -8.8404>, <-15.8505, 88.1192, -8.9036>, 0.09187 }
				cylinder { <-15.8505, 88.1192, -8.9036>, <-17.5988, 88.509, -8.9311>, 0.09187 }
				cylinder { <-17.5988, 88.509, -8.9311>, <-19.3745, 88.7469, -8.923>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-19.3745, 88.7469, -8.923>, <-19.5644, 88.7774, -8.9354>, 0.002976 }
				cylinder { <-19.5644, 88.7774, -8.9354>, <-19.7522, 88.8127, -8.9609>, 0.002976 }
				cylinder { <-19.7522, 88.8127, -8.9609>, <-19.9368, 88.8525, -8.9996>, 0.002976 }
				cylinder { <-19.9368, 88.8525, -8.9996>, <-20.1172, 88.8966, -9.05112>, 0.002976 }
				cylinder { <-20.1172, 88.8966, -9.05112>, <-20.2925, 88.9449, -9.1151>, 0.002976 }
				cylinder { <-20.2925, 88.9449, -9.1151>, <-20.4617, 88.997, -9.1914>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-20.4617, 88.997, -9.1914>, <-21.7839, 89.9312, -10.08575>, <-21.735, 90.05511, -10.06454> }
				triangle { <-21.7839, 89.9312, -10.08575>, <-22.6328, 90.4716, -10.4572>, <-21.735, 90.05511, -10.06454> }
				triangle { <-22.6328, 90.4716, -10.4572>, <-22.5767, 90.5953, -10.3939>, <-21.735, 90.05511, -10.06454> }
				triangle { <-22.6328, 90.4716, -10.4572>, <-25.4961, 92.09313, -11.09943>, <-22.5767, 90.5953, -10.3939> }
				triangle { <-22.5767, 90.5953, -10.3939>, <-25.4961, 92.09313, -11.09943>, <-22.5036, 90.7054, -10.3192> }
				triangle { <-21.735, 90.05511, -10.06454>, <-22.5767, 90.5953, -10.3939>, <-22.5036, 90.7054, -10.3192> }
				triangle { <-21.735, 90.05511, -10.06454>, <-22.5036, 90.7054, -10.3192>, <-21.6685, 90.1456, -10.00326> }
				triangle { <-21.735, 90.05511, -10.06454>, <-21.6685, 90.1456, -10.00326>, <-20.4617, 88.997, -9.1914> }
				triangle { <-27.05992, 92.9066, -11.2465>, <-25.4961, 92.09313, -11.09943>, <-25.6147, 91.9116, -11.1379> }
				triangle { <-22.5036, 90.7054, -10.3192>, <-25.4961, 92.09313, -11.09943>, <-25.4565, 92.2959, -10.9175> }
				triangle { <-22.6328, 90.4716, -10.4572>, <-25.6147, 91.9116, -11.1379>, <-25.4961, 92.09313, -11.09943> }
				triangle { <-27.05992, 92.9066, -11.2465>, <-25.4565, 92.2959, -10.9175>, <-25.4961, 92.09313, -11.09943> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-19.3745, 88.7469, -8.923>, <-21.1501, 88.9848, -8.9148>, 0.09187 }
				cylinder { <-21.1501, 88.9848, -8.9148>, <-22.9257, 89.2227, -8.9067>, 0.09187 }
				cylinder { <-22.9257, 89.2227, -8.9067>, <-24.7013, 89.4605, -8.8985>, 0.09187 }
				cylinder { <-24.7013, 89.4605, -8.8985>, <-26.477, 89.6984, -8.8904>, 0.09187 }
				cylinder { <-26.477, 89.6984, -8.8904>, <-28.2526, 89.9363, -8.8822>, 0.09187 }
				cylinder { <-28.2526, 89.9363, -8.8822>, <-30.02826, 90.1742, -8.8741>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-30.02826, 90.1742, -8.8741>, <-30.2188, 90.1913, -8.8511>, 0.002976 }
				cylinder { <-30.2188, 90.1913, -8.8511>, <-30.4062, 90.1996, -8.8065>, 0.002976 }
				cylinder { <-30.4062, 90.1996, -8.8065>, <-30.5874, 90.1992, -8.7408>, 0.002976 }
				cylinder { <-30.5874, 90.1992, -8.7408>, <-30.7598, 90.1898, -8.655>, 0.002976 }
				cylinder { <-30.7598, 90.1898, -8.655>, <-30.9207, 90.1717, -8.5505>, 0.002976 }
				cylinder { <-30.9207, 90.1717, -8.5505>, <-31.0679, 90.1452, -8.4288>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-31.0679, 90.1452, -8.4288>, <-32.6153, 90.3933, -7.4467>, <-32.609, 90.5277, -7.4379> }
				triangle { <-32.6153, 90.3933, -7.4467>, <-33.4146, 90.5159, -6.7418>, <-32.609, 90.5277, -7.4379> }
				triangle { <-33.4146, 90.5159, -6.7418>, <-33.3682, 90.6566, -6.7197>, <-32.609, 90.5277, -7.4379> }
				triangle { <-33.4146, 90.5159, -6.7418>, <-35.5193, 90.7983, -4.1476>, <-33.3682, 90.6566, -6.7197> }
				triangle { <-33.3682, 90.6566, -6.7197>, <-35.5193, 90.7983, -4.1476>, <-33.3016, 90.7927, -6.7109> }
				triangle { <-32.609, 90.5277, -7.4379>, <-33.3682, 90.6566, -6.7197>, <-33.3016, 90.7927, -6.7109> }
				triangle { <-32.609, 90.5277, -7.4379>, <-33.3016, 90.7927, -6.7109>, <-32.5518, 90.6422, -7.436> }
				triangle { <-32.609, 90.5277, -7.4379>, <-32.5518, 90.6422, -7.436>, <-31.0679, 90.1452, -8.4288> }
				triangle { <-36.4706, 90.9043, -2.66>, <-35.5193, 90.7983, -4.1476>, <-35.5536, 90.5819, -4.1248> }
				triangle { <-33.3016, 90.7927, -6.7109>, <-35.5193, 90.7983, -4.1476>, <-35.3948, 91.01495, -4.03209> }
				triangle { <-33.4146, 90.5159, -6.7418>, <-35.5536, 90.5819, -4.1248>, <-35.5193, 90.7983, -4.1476> }
				triangle { <-36.4706, 90.9043, -2.66>, <-35.3948, 91.01495, -4.03209>, <-35.5193, 90.7983, -4.1476> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-30.02826, 90.1742, -8.8741>, <-31.7802, 90.5388, -8.9579>, 0.09187 }
				cylinder { <-31.7802, 90.5388, -8.9579>, <-33.4948, 91.02766, -9.133>, 0.09187 }
				cylinder { <-33.4948, 91.02766, -9.133>, <-35.1587, 91.6368, -9.3975>, 0.09187 }
				cylinder { <-35.1587, 91.6368, -9.3975>, <-36.7587, 92.3619, -9.7493>, 0.09187 }
				cylinder { <-36.7587, 92.3619, -9.7493>, <-38.2823, 93.1973, -10.1853>, 0.09187 }
				cylinder { <-38.2823, 93.1973, -10.1853>, <-39.7177, 94.1367, -10.7019>, 0.09187 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-39.7177, 94.1367, -10.7019>, <-39.8522, 94.2438, -10.7891>, 0.002976 }
				cylinder { <-39.8522, 94.2438, -10.7891>, <-39.9616, 94.3529, -10.9044>, 0.002976 }
				cylinder { <-39.9616, 94.3529, -10.9044>, <-40.04174, 94.4596, -11.04345>, 0.002976 }
				cylinder { <-40.04174, 94.4596, -11.04345>, <-40.08946, 94.5601, -11.2009>, 0.002976 }
				cylinder { <-40.08946, 94.5601, -11.2009>, <-40.1029, 94.6503, -11.3707>, 0.002976 }
				cylinder { <-40.1029, 94.6503, -11.3707>, <-40.08174, 94.7268, -11.5463>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-40.08174, 94.7268, -11.5463>, <-39.3805, 95.5867, -13.02606>, <-39.2982, 95.6707, -12.9599> }
				triangle { <-39.3805, 95.5867, -13.02606>, <-39.1051, 96.1899, -13.8693>, <-39.2982, 95.6707, -12.9599> }
				triangle { <-39.1051, 96.1899, -13.8693>, <-39.04887, 96.2906, -13.7738>, <-39.2982, 95.6707, -12.9599> }
				triangle { <-39.1051, 96.1899, -13.8693>, <-38.718, 98.3609, -16.3945>, <-39.04887, 96.2906, -13.7738> }
				triangle { <-39.04887, 96.2906, -13.7738>, <-38.718, 98.3609, -16.3945>, <-39.00249, 96.379, -13.6595> }
				triangle { <-39.2982, 95.6707, -12.9599>, <-39.04887, 96.2906, -13.7738>, <-39.00249, 96.379, -13.6595> }
				triangle { <-39.2982, 95.6707, -12.9599>, <-39.00249, 96.379, -13.6595>, <-39.2575, 95.7405, -12.8608> }
				triangle { <-39.2982, 95.6707, -12.9599>, <-39.2575, 95.7405, -12.8608>, <-40.08174, 94.7268, -11.5463> }
				triangle { <-38.6901, 99.5884, -17.6679>, <-38.718, 98.3609, -16.3945>, <-38.8512, 98.2547, -16.5341> }
				triangle { <-39.00249, 96.379, -13.6595>, <-38.718, 98.3609, -16.3945>, <-38.6982, 98.5859, -16.2371> }
				triangle { <-39.1051, 96.1899, -13.8693>, <-38.8512, 98.2547, -16.5341>, <-38.718, 98.3609, -16.3945> }
				triangle { <-38.6901, 99.5884, -17.6679>, <-38.6982, 98.5859, -16.2371>, <-38.718, 98.3609, -16.3945> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-39.7177, 94.1367, -10.7019>, <-39.8762, 94.2356, -10.7493>, 0.002976 }
				cylinder { <-39.8762, 94.2356, -10.7493>, <-40.03846, 94.3322, -10.7882>, 0.002976 }
				cylinder { <-40.03846, 94.3322, -10.7882>, <-40.2039, 94.4262, -10.8187>, 0.002976 }
				cylinder { <-40.2039, 94.4262, -10.8187>, <-40.3724, 94.5173, -10.8406>, 0.002976 }
				cylinder { <-40.3724, 94.5173, -10.8406>, <-40.5433, 94.6054, -10.8539>, 0.002976 }
				cylinder { <-40.5433, 94.6054, -10.8539>, <-40.7163, 94.6902, -10.8586>, 0.002976 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-40.7163, 94.6902, -10.8586>, <-42.07415, 95.9222, -11.1021>, <-42.00029, 96.03351, -11.08317> }
				triangle { <-42.07415, 95.9222, -11.1021>, <-42.8901, 96.6181, -11.07827>, <-42.00029, 96.03351, -11.08317> }
				triangle { <-42.8901, 96.6181, -11.07827>, <-42.7959, 96.7206, -11.02287>, <-42.00029, 96.03351, -11.08317> }
				triangle { <-42.8901, 96.6181, -11.07827>, <-45.4786, 98.6566, -10.458>, <-42.7959, 96.7206, -11.02287> }
				triangle { <-42.7959, 96.7206, -11.02287>, <-45.4786, 98.6566, -10.458>, <-42.6845, 96.8056, -10.9646> }
				triangle { <-42.00029, 96.03351, -11.08317>, <-42.7959, 96.7206, -11.02287>, <-42.6845, 96.8056, -10.9646> }
				triangle { <-42.00029, 96.03351, -11.08317>, <-42.6845, 96.8056, -10.9646>, <-41.9027, 96.1027, -11.03763> }
				triangle { <-42.00029, 96.03351, -11.08317>, <-41.9027, 96.1027, -11.03763>, <-40.7163, 94.6902, -10.8586> }
				triangle { <-46.8385, 99.6622, -9.94>, <-45.4786, 98.6566, -10.458>, <-45.6329, 98.5006, -10.4762> }
				triangle { <-42.6845, 96.8056, -10.9646>, <-45.4786, 98.6566, -10.458>, <-45.3473, 98.8164, -10.2764> }
				triangle { <-42.8901, 96.6181, -11.07827>, <-45.6329, 98.5006, -10.4762>, <-45.4786, 98.6566, -10.458> }
				triangle { <-46.8385, 99.6622, -9.94>, <-45.3473, 98.8164, -10.2764>, <-45.4786, 98.6566, -10.458> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1231, 5.847, 0.07379>, 0.09031 }
			cylinder { <0.1231, 5.847, 0.07379>, <0.3692, 11.6887, 0.2213>, 0.09031 }
			cylinder { <0.3692, 11.6887, 0.2213>, <0.7383, 17.5217, 0.4425>, 0.09031 }
			cylinder { <0.7383, 17.5217, 0.4425>, <1.23, 23.3423, 0.7372>, 0.09031 }
			cylinder { <1.23, 23.3423, 0.7372>, <1.8441, 29.1471, 1.1053>, 0.09031 }
			cylinder { <1.8441, 29.1471, 1.1053>, <2.5802, 34.9326, 1.5465>, 0.09031 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.5802, 34.9326, 1.5465>, <2.824, 36.6741, 1.6422>, 0.09031 }
				cylinder { <2.824, 36.6741, 1.6422>, <3.08982, 38.414, 1.7008>, 0.09031 }
				cylinder { <3.08982, 38.414, 1.7008>, <3.3774, 40.1513, 1.7222>, 0.09031 }
				cylinder { <3.3774, 40.1513, 1.7222>, <3.6867, 41.885, 1.7063>, 0.09031 }
				cylinder { <3.6867, 41.885, 1.7063>, <4.01758, 43.6139, 1.6532>, 0.09031 }
				cylinder { <4.01758, 43.6139, 1.6532>, <4.3696, 45.337, 1.563>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.3696, 45.337, 1.563>, <4.3954, 45.5212, 1.5731>, 0.002876 }
				cylinder { <4.3954, 45.5212, 1.5731>, <4.4094, 45.7046, 1.6028>, 0.002876 }
				cylinder { <4.4094, 45.7046, 1.6028>, <4.4112, 45.8844, 1.6515>, 0.002876 }
				cylinder { <4.4112, 45.8844, 1.6515>, <4.4011, 46.05791, 1.7186>, 0.002876 }
				cylinder { <4.4011, 46.05791, 1.7186>, <4.3789, 46.2224, 1.8029>, 0.002876 }
				cylinder { <4.3789, 46.2224, 1.8029>, <4.3452, 46.3756, 1.9034>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.3452, 46.3756, 1.9034>, <4.9748, 47.8264, 2.8003>, <5.09181, 47.7751, 2.8358> }
				triangle { <4.9748, 47.8264, 2.8003>, <5.263, 48.6034, 3.4523>, <5.09181, 47.7751, 2.8358> }
				triangle { <5.263, 48.6034, 3.4523>, <5.3688, 48.5152, 3.5044>, <5.09181, 47.7751, 2.8358> }
				triangle { <5.263, 48.6034, 3.4523>, <5.8657, 50.7601, 5.8703>, <5.3688, 48.5152, 3.5044> }
				triangle { <5.3688, 48.5152, 3.5044>, <5.8657, 50.7601, 5.8703>, <5.4652, 48.4085, 3.544> }
				triangle { <5.09181, 47.7751, 2.8358>, <5.3688, 48.5152, 3.5044>, <5.4652, 48.4085, 3.544> }
				triangle { <5.09181, 47.7751, 2.8358>, <5.4652, 48.4085, 3.544>, <5.1733, 47.6835, 2.8639> }
				triangle { <5.09181, 47.7751, 2.8358>, <5.1733, 47.6835, 2.8639>, <4.3452, 46.3756, 1.9034> }
				triangle { <6.0677, 51.7835, 7.2615>, <5.8657, 50.7601, 5.8703>, <5.6803, 50.8694, 5.8471> }
				triangle { <5.4652, 48.4085, 3.544>, <5.8657, 50.7601, 5.8703>, <5.996, 50.5866, 6.03208> }
				triangle { <5.263, 48.6034, 3.4523>, <5.6803, 50.8694, 5.8471>, <5.8657, 50.7601, 5.8703> }
				triangle { <6.0677, 51.7835, 7.2615>, <5.996, 50.5866, 6.03208>, <5.8657, 50.7601, 5.8703> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.3696, 45.337, 1.563>, <4.7428, 47.05344, 1.4357>, 0.09031 }
				cylinder { <4.7428, 47.05344, 1.4357>, <5.1368, 48.7619, 1.2713>, 0.09031 }
				cylinder { <5.1368, 48.7619, 1.2713>, <5.5514, 50.4616, 1.06997>, 0.09031 }
				cylinder { <5.5514, 50.4616, 1.06997>, <5.9864, 52.1514, 0.8318>, 0.09031 }
				cylinder { <5.9864, 52.1514, 0.8318>, <6.4415, 53.8303, 0.5569>, 0.09031 }
				cylinder { <6.4415, 53.8303, 0.5569>, <6.9164, 55.4973, 0.2456>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <6.9164, 55.4973, 0.2456>, <6.9785, 55.6639, 0.19>, 0.002876 }
				cylinder { <6.9785, 55.6639, 0.19>, <7.05128, 55.8171, 0.1129>, 0.002876 }
				cylinder { <7.05128, 55.8171, 0.1129>, <7.1329, 55.9536, 0.01604>, 0.002876 }
				cylinder { <7.1329, 55.9536, 0.01604>, <7.2218, 56.07057, -0.09854>, 0.002876 }
				cylinder { <7.2218, 56.07057, -0.09854>, <7.316, 56.1653, -0.2283>, 0.002876 }
				cylinder { <7.316, 56.1653, -0.2283>, <7.4134, 56.2358, -0.3705>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <7.4134, 56.2358, -0.3705>, <8.9315, 56.2488, -1.3709>, <9.01484, 56.2081, -1.2761> }
				triangle { <8.9315, 56.2488, -1.3709>, <9.8252, 56.415, -1.9053>, <9.01484, 56.2081, -1.2761> }
				triangle { <9.8252, 56.415, -1.9053>, <9.8991, 56.4001, -1.7788>, <9.01484, 56.2081, -1.2761> }
				triangle { <9.8252, 56.415, -1.9053>, <12.5758, 57.4559, -3.3927>, <9.8991, 56.4001, -1.7788> }
				triangle { <9.8991, 56.4001, -1.7788>, <12.5758, 57.4559, -3.3927>, <9.952, 56.3852, -1.6401> }
				triangle { <9.01484, 56.2081, -1.2761>, <9.8991, 56.4001, -1.7788>, <9.952, 56.3852, -1.6401> }
				triangle { <9.01484, 56.2081, -1.2761>, <9.952, 56.3852, -1.6401>, <9.05559, 56.1917, -1.1582> }
				triangle { <9.01484, 56.2081, -1.2761>, <9.05559, 56.1917, -1.1582>, <7.4134, 56.2358, -0.3705> }
				triangle { <13.9858, 58.1854, -4.1019>, <12.5758, 57.4559, -3.3927>, <12.4754, 57.5402, -3.565> }
				triangle { <9.952, 56.3852, -1.6401>, <12.5758, 57.4559, -3.3927>, <12.7084, 57.5211, -3.166> }
				triangle { <9.8252, 56.415, -1.9053>, <12.4754, 57.5402, -3.565>, <12.5758, 57.4559, -3.3927> }
				triangle { <13.9858, 58.1854, -4.1019>, <12.7084, 57.5211, -3.166>, <12.5758, 57.4559, -3.3927> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <6.9164, 55.4973, 0.2456>, <7.5217, 57.108, -0.1296>, 0.09031 }
				cylinder { <7.5217, 57.108, -0.1296>, <8.2528, 58.6497, -0.5655>, 0.09031 }
				cylinder { <8.2528, 58.6497, -0.5655>, <9.1041, 60.1104, -1.05851>, 0.09031 }
				cylinder { <9.1041, 60.1104, -1.05851>, <10.06904, 61.4787, -1.6044>, 0.09031 }
				cylinder { <10.06904, 61.4787, -1.6044>, <11.1402, 62.744, -2.1987>, 0.09031 }
				cylinder { <11.1402, 62.744, -2.1987>, <12.3093, 63.8962, -2.8365>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <12.3093, 63.8962, -2.8365>, <12.4292, 64.02672, -2.8939>, 0.002876 }
				cylinder { <12.4292, 64.02672, -2.8939>, <12.5446, 64.1651, -2.9411>, 0.002876 }
				cylinder { <12.5446, 64.1651, -2.9411>, <12.6549, 64.3106, -2.9778>, 0.002876 }
				cylinder { <12.6549, 64.3106, -2.9778>, <12.7596, 64.4625, -3.003763>, 0.002876 }
				cylinder { <12.7596, 64.4625, -3.003763>, <12.858, 64.6199, -3.01879>, 0.002876 }
				cylinder { <12.858, 64.6199, -3.01879>, <12.9497, 64.782, -3.02286>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <12.9497, 64.782, -3.02286>, <14.5263, 65.6871, -2.9988>, <14.5955, 65.5989, -2.9281> }
				triangle { <14.5263, 65.6871, -2.9988>, <15.3812, 66.2859, -2.8491>, <14.5955, 65.5989, -2.9281> }
				triangle { <15.3812, 66.2859, -2.8491>, <15.4251, 66.1906, -2.7458>, <14.5955, 65.5989, -2.9281> }
				triangle { <15.3812, 66.2859, -2.8491>, <17.7737, 68.3669, -1.9509>, <15.4251, 66.1906, -2.7458> }
				triangle { <15.4251, 66.1906, -2.7458>, <17.7737, 68.3669, -1.9509>, <15.4474, 66.08425, -2.6436> }
				triangle { <14.5955, 65.5989, -2.9281>, <15.4251, 66.1906, -2.7458>, <15.4474, 66.08425, -2.6436> }
				triangle { <14.5955, 65.5989, -2.9281>, <15.4474, 66.08425, -2.6436>, <14.6122, 65.5055, -2.8455> }
				triangle { <14.5955, 65.5989, -2.9281>, <14.6122, 65.5055, -2.8455>, <12.9497, 64.782, -3.02286> }
				triangle { <18.9129, 69.5256, -1.3317>, <17.7737, 68.3669, -1.9509>, <17.6895, 68.5395, -2.05088> }
				triangle { <15.4474, 66.08425, -2.6436>, <17.7737, 68.3669, -1.9509>, <17.8171, 68.2577, -1.7071> }
				triangle { <15.3812, 66.2859, -2.8491>, <17.6895, 68.5395, -2.05088>, <17.7737, 68.3669, -1.9509> }
				triangle { <18.9129, 69.5256, -1.3317>, <17.8171, 68.2577, -1.7071>, <17.7737, 68.3669, -1.9509> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <12.3093, 63.8962, -2.8365>, <13.4364, 65.09251, -3.4689>, 0.09031 }
				cylinder { <13.4364, 65.09251, -3.4689>, <14.5201, 66.3313, -4.09517>, 0.09031 }
				cylinder { <14.5201, 66.3313, -4.09517>, <15.5591, 67.6113, -4.7145>, 0.09031 }
				cylinder { <15.5591, 67.6113, -4.7145>, <16.5521, 68.9308, -5.3263>, 0.09031 }
				cylinder { <16.5521, 68.9308, -5.3263>, <17.4979, 70.2882, -5.9297>, 0.09031 }
				cylinder { <17.4979, 70.2882, -5.9297>, <18.3954, 71.682, -6.5242>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <18.3954, 71.682, -6.5242>, <18.4974, 71.8158, -6.604>, 0.002876 }
				cylinder { <18.4974, 71.8158, -6.604>, <18.6049, 71.9341, -6.6996>, 0.002876 }
				cylinder { <18.6049, 71.9341, -6.6996>, <18.7163, 72.03512, -6.8096>, 0.002876 }
				cylinder { <18.7163, 72.03512, -6.8096>, <18.83, 72.1172, -6.9322>, 0.002876 }
				cylinder { <18.83, 72.1172, -6.9322>, <18.9442, 72.1791, -7.06577>, 0.002876 }
				cylinder { <18.9442, 72.1791, -7.06577>, <19.05722, 72.2201, -7.208>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <19.05722, 72.2201, -7.208>, <20.5738, 71.874, -8.1491>, <20.645, 71.8242, -8.04904> }
				triangle { <20.5738, 71.874, -8.1491>, <21.4962, 71.829, -8.6581>, <20.645, 71.8242, -8.04904> }
				triangle { <21.4962, 71.829, -8.6581>, <21.5624, 71.8084, -8.5282>, <20.645, 71.8242, -8.04904> }
				triangle { <21.4962, 71.829, -8.6581>, <24.4346, 72.219, -10.09851>, <21.5624, 71.8084, -8.5282> }
				triangle { <21.5624, 71.8084, -8.5282>, <24.4346, 72.219, -10.09851>, <21.6078, 71.7926, -8.387> }
				triangle { <20.645, 71.8242, -8.04904>, <21.5624, 71.8084, -8.5282>, <21.6078, 71.7926, -8.387> }
				triangle { <20.645, 71.8242, -8.04904>, <21.6078, 71.7926, -8.387>, <20.6787, 71.8079, -7.9289> }
				triangle { <20.645, 71.8242, -8.04904>, <20.6787, 71.8079, -7.9289>, <19.05722, 72.2201, -7.208> }
				triangle { <25.978, 72.6142, -10.7952>, <24.4346, 72.219, -10.09851>, <24.3572, 72.3098, -10.2791> }
				triangle { <21.6078, 71.7926, -8.387>, <24.4346, 72.219, -10.09851>, <24.5715, 72.2719, -9.8711> }
				triangle { <21.4962, 71.829, -8.6581>, <24.3572, 72.3098, -10.2791>, <24.4346, 72.219, -10.09851> }
				triangle { <25.978, 72.6142, -10.7952>, <24.5715, 72.2719, -9.8711>, <24.4346, 72.219, -10.09851> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <18.3954, 71.682, -6.5242>, <19.2929, 73.07578, -7.1186>, 0.09031 }
				cylinder { <19.2929, 73.07578, -7.1186>, <20.1904, 74.4695, -7.713>, 0.09031 }
				cylinder { <20.1904, 74.4695, -7.713>, <21.08792, 75.8633, -8.3074>, 0.09031 }
				cylinder { <21.08792, 75.8633, -8.3074>, <21.9854, 77.257, -8.9018>, 0.09031 }
				cylinder { <21.9854, 77.257, -8.9018>, <22.8829, 78.6508, -9.4962>, 0.09031 }
				cylinder { <22.8829, 78.6508, -9.4962>, <23.7803, 80.04458, -10.09067>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <23.7803, 80.04458, -10.09067>, <23.8668, 80.2033, -10.1356>, 0.002876 }
				cylinder { <23.8668, 80.2033, -10.1356>, <23.9434, 80.371, -10.1619>, 0.002876 }
				cylinder { <23.9434, 80.371, -10.1619>, <24.0092, 80.5451, -10.1693>, 0.002876 }
				cylinder { <24.0092, 80.5451, -10.1693>, <24.06298, 80.7231, -10.1575>, 0.002876 }
				cylinder { <24.06298, 80.7231, -10.1575>, <24.104, 80.9022, -10.1268>, 0.002876 }
				cylinder { <24.104, 80.9022, -10.1268>, <24.1317, 81.07975, -10.07775>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <24.1317, 81.07975, -10.07775>, <25.2805, 82.42, -9.6427>, <25.3762, 82.3443, -9.5909> }
				triangle { <25.2805, 82.42, -9.6427>, <25.8639, 83.2043, -9.2471>, <25.3762, 82.3443, -9.5909> }
				triangle { <25.8639, 83.2043, -9.2471>, <25.9382, 83.1042, -9.1687>, <25.3762, 82.3443, -9.5909> }
				triangle { <25.8639, 83.2043, -9.2471>, <27.3484, 85.6243, -7.5735>, <25.9382, 83.1042, -9.1687> }
				triangle { <25.9382, 83.1042, -9.1687>, <27.3484, 85.6243, -7.5735>, <25.9964, 82.9873, -9.09675> }
				triangle { <25.3762, 82.3443, -9.5909>, <25.9382, 83.1042, -9.1687>, <25.9964, 82.9873, -9.09675> }
				triangle { <25.3762, 82.3443, -9.5909>, <25.9964, 82.9873, -9.09675>, <25.4245, 82.2427, -9.5348> }
				triangle { <25.3762, 82.3443, -9.5909>, <25.4245, 82.2427, -9.5348>, <24.1317, 81.07975, -10.07775> }
				triangle { <27.9939, 86.8719, -6.5486>, <27.3484, 85.6243, -7.5735>, <27.2087, 85.7789, -7.6326> }
				triangle { <25.9964, 82.9873, -9.09675>, <27.3484, 85.6243, -7.5735>, <27.4262, 85.4713, -7.3643> }
				triangle { <25.8639, 83.2043, -9.2471>, <27.2087, 85.7789, -7.6326>, <27.3484, 85.6243, -7.5735> }
				triangle { <27.9939, 86.8719, -6.5486>, <27.4262, 85.4713, -7.3643>, <27.3484, 85.6243, -7.5735> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <23.7803, 80.04458, -10.09067>, <24.6434, 81.4498, -10.7085>, 0.09031 }
				cylinder { <24.6434, 81.4498, -10.7085>, <25.4716, 82.8656, -11.3496>, 0.09031 }
				cylinder { <25.4716, 82.8656, -11.3496>, <26.2643, 84.2912, -12.01345>, 0.09031 }
				cylinder { <26.2643, 84.2912, -12.01345>, <27.02115, 85.7257, -12.6996>, 0.09031 }
				cylinder { <27.02115, 85.7257, -12.6996>, <27.7416, 87.1682, -13.4077>, 0.09031 }
				cylinder { <27.7416, 87.1682, -13.4077>, <28.4252, 88.618, -14.1373>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <28.4252, 88.618, -14.1373>, <28.5047, 88.7577, -14.2313>, 0.002876 }
				cylinder { <28.5047, 88.7577, -14.2313>, <28.5903, 88.8817, -14.3408>, 0.002876 }
				cylinder { <28.5903, 88.8817, -14.3408>, <28.6806, 88.9882, -14.4641>, 0.002876 }
				cylinder { <28.6806, 88.9882, -14.4641>, <28.7744, 89.07554, -14.5994>, 0.002876 }
				cylinder { <28.7744, 89.07554, -14.5994>, <28.87, 89.1423, -14.7445>, 0.002876 }
				cylinder { <28.87, 89.1423, -14.7445>, <28.9663, 89.1876, -14.8975>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <28.9663, 89.1876, -14.8975>, <30.4352, 88.9601, -15.9443>, <30.5192, 88.924, -15.8483> }
				triangle { <30.4352, 88.9601, -15.9443>, <31.3146, 88.9895, -16.5255>, <30.5192, 88.924, -15.8483> }
				triangle { <31.3146, 88.9895, -16.5255>, <31.3926, 88.9833, -16.4007>, <30.5192, 88.924, -15.8483> }
				triangle { <31.3146, 88.9895, -16.5255>, <34.06907, 89.6219, -18.2208>, <31.3926, 88.9833, -16.4007> }
				triangle { <31.3926, 88.9833, -16.4007>, <34.06907, 89.6219, -18.2208>, <31.4503, 88.9804, -16.2632> }
				triangle { <30.5192, 88.924, -15.8483>, <31.3926, 88.9833, -16.4007>, <31.4503, 88.9804, -16.2632> }
				triangle { <30.5192, 88.924, -15.8483>, <31.4503, 88.9804, -16.2632>, <30.5637, 88.9181, -15.7308> }
				triangle { <30.5192, 88.924, -15.8483>, <30.5637, 88.9181, -15.7308>, <28.9663, 89.1876, -14.8975> }
				triangle { <35.4986, 90.1463, -19.06047>, <34.06907, 89.6219, -18.2208>, <33.968, 89.6936, -18.3983> }
				triangle { <31.4503, 88.9804, -16.2632>, <34.06907, 89.6219, -18.2208>, <34.2162, 89.7019, -18.0083> }
				triangle { <31.3146, 88.9895, -16.5255>, <33.968, 89.6936, -18.3983>, <34.06907, 89.6219, -18.2208> }
				triangle { <35.4986, 90.1463, -19.06047>, <34.2162, 89.7019, -18.0083>, <34.06907, 89.6219, -18.2208> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <28.4252, 88.618, -14.1373>, <29.1234, 90.04369, -14.8997>, 0.09031 }
				cylinder { <29.1234, 90.04369, -14.8997>, <29.8357, 91.4444, -15.6946>, 0.09031 }
				cylinder { <29.8357, 91.4444, -15.6946>, <30.5616, 92.8195, -16.5213>, 0.09031 }
				cylinder { <30.5616, 92.8195, -16.5213>, <31.3009, 94.168, -17.3795>, 0.09031 }
				cylinder { <31.3009, 94.168, -17.3795>, <32.05291, 95.4891, -18.2686>, 0.09031 }
				cylinder { <32.05291, 95.4891, -18.2686>, <32.8172, 96.7821, -19.1881>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <32.8172, 96.7821, -19.1881>, <32.8926, 96.9302, -19.2722>, 0.002876 }
				cylinder { <32.8926, 96.9302, -19.2722>, <32.9617, 97.08842, -19.3423>, 0.002876 }
				cylinder { <32.9617, 97.08842, -19.3423>, <33.02393, 97.255, -19.3977>, 0.002876 }
				cylinder { <33.02393, 97.255, -19.3977>, <33.07864, 97.4284, -19.4379>, 0.002876 }
				cylinder { <33.07864, 97.4284, -19.4379>, <33.1253, 97.6071, -19.4625>, 0.002876 }
				cylinder { <33.1253, 97.6071, -19.4625>, <33.1635, 97.7892, -19.4713>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <33.1635, 97.7892, -19.4713>, <34.3908, 99.1239, -19.604>, <34.4915, 99.06041, -19.5458> }
				triangle { <34.3908, 99.1239, -19.604>, <35.04188, 99.9506, -19.5361>, <34.4915, 99.06041, -19.5458> }
				triangle { <35.04188, 99.9506, -19.5361>, <35.1248, 99.8727, -19.4427>, <34.4915, 99.06041, -19.5458> }
				triangle { <35.04188, 99.9506, -19.5361>, <36.8051, 102.6503, -18.8548>, <35.1248, 99.8727, -19.4427> }
				triangle { <35.1248, 99.8727, -19.4427>, <36.8051, 102.6503, -18.8548>, <35.1906, 99.7777, -19.3483> }
				triangle { <34.4915, 99.06041, -19.5458>, <35.1248, 99.8727, -19.4427>, <35.1906, 99.7777, -19.3483> }
				triangle { <34.4915, 99.06041, -19.5458>, <35.1906, 99.7777, -19.3483>, <34.5455, 98.9761, -19.4696> }
				triangle { <34.4915, 99.06041, -19.5458>, <34.5455, 98.9761, -19.4696>, <33.1635, 97.7892, -19.4713> }
				triangle { <37.6195, 104.0956, -18.3339>, <36.8051, 102.6503, -18.8548>, <36.6615, 102.79, -18.9369> }
				triangle { <35.1906, 99.7777, -19.3483>, <36.8051, 102.6503, -18.8548>, <36.9097, 102.5587, -18.6227> }
				triangle { <35.04188, 99.9506, -19.5361>, <36.6615, 102.79, -18.9369>, <36.8051, 102.6503, -18.8548> }
				triangle { <37.6195, 104.0956, -18.3339>, <36.9097, 102.5587, -18.6227>, <36.8051, 102.6503, -18.8548> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <32.8172, 96.7821, -19.1881>, <33.532, 98.1095, -20.09826>, 0.09031 }
				cylinder { <33.532, 98.1095, -20.09826>, <34.1963, 99.4699, -20.9979>, 0.09031 }
				cylinder { <34.1963, 99.4699, -20.9979>, <34.8094, 100.8615, -21.8861>, 0.09031 }
				cylinder { <34.8094, 100.8615, -21.8861>, <35.3705, 102.2827, -22.7618>, 0.09031 }
				cylinder { <35.3705, 102.2827, -22.7618>, <35.8789, 103.7318, -23.6238>, 0.09031 }
				cylinder { <35.8789, 103.7318, -23.6238>, <36.334, 105.2069, -24.4713>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <36.334, 105.2069, -24.4713>, <36.3894, 105.3494, -24.5778>, 0.002876 }
				cylinder { <36.3894, 105.3494, -24.5778>, <36.4512, 105.4761, -24.6996>, 0.002876 }
				cylinder { <36.4512, 105.4761, -24.6996>, <36.5184, 105.5851, -24.8348>, 0.002876 }
				cylinder { <36.5184, 105.5851, -24.8348>, <36.5901, 105.6749, -24.9814>, 0.002876 }
				cylinder { <36.5901, 105.6749, -24.9814>, <36.6652, 105.744, -25.1372>, 0.002876 }
				cylinder { <36.6652, 105.744, -25.1372>, <36.7425, 105.7915, -25.2999>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <36.7425, 105.7915, -25.2999>, <38.1336, 105.6684, -26.4641>, <38.2289, 105.6464, -26.3746> }
				triangle { <38.1336, 105.6684, -26.4641>, <38.9519, 105.7615, -27.1225>, <38.2289, 105.6464, -26.3746> }
				triangle { <38.9519, 105.7615, -27.1225>, <39.04045, 105.7701, -27.00521>, <38.2289, 105.6464, -26.3746> }
				triangle { <38.9519, 105.7615, -27.1225>, <41.4661, 106.5962, -29.08308>, <39.04045, 105.7701, -27.00521> }
				triangle { <39.04045, 105.7701, -27.00521>, <41.4661, 106.5962, -29.08308>, <39.1095, 105.7803, -26.8733> }
				triangle { <38.2289, 105.6464, -26.3746>, <39.04045, 105.7701, -27.00521>, <39.1095, 105.7803, -26.8733> }
				triangle { <38.2289, 105.6464, -26.3746>, <39.1095, 105.7803, -26.8733>, <38.2836, 105.6513, -26.2614> }
				triangle { <38.2289, 105.6464, -26.3746>, <38.2836, 105.6513, -26.2614>, <36.7425, 105.7915, -25.2999> }
				triangle { <42.7527, 107.2262, -30.06862>, <41.4661, 106.5962, -29.08308>, <41.3431, 106.6476, -29.2536> }
				triangle { <39.1095, 105.7803, -26.8733>, <41.4661, 106.5962, -29.08308>, <41.621, 106.7021, -28.888> }
				triangle { <38.9519, 105.7615, -27.1225>, <41.3431, 106.6476, -29.2536>, <41.4661, 106.5962, -29.08308> }
				triangle { <42.7527, 107.2262, -30.06862>, <41.621, 106.7021, -28.888>, <41.4661, 106.5962, -29.08308> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <36.334, 105.2069, -24.4713>, <36.3822, 105.363, -24.5609>, 0.002876 }
				cylinder { <36.3822, 105.363, -24.5609>, <36.4303, 105.519, -24.6505>, 0.002876 }
				cylinder { <36.4303, 105.519, -24.6505>, <36.4785, 105.675, -24.7402>, 0.002876 }
				cylinder { <36.4785, 105.675, -24.7402>, <36.5266, 105.8311, -24.8298>, 0.002876 }
				cylinder { <36.5266, 105.8311, -24.8298>, <36.5747, 105.9871, -24.9195>, 0.002876 }
				cylinder { <36.5747, 105.9871, -24.9195>, <36.6229, 106.1431, -25.00914>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <36.6229, 106.1431, -25.00914>, <37.901, 107.1453, -25.826>, <38.00488, 107.1001, -25.757> }
				triangle { <37.901, 107.1453, -25.826>, <38.6068, 107.8413, -26.1858>, <38.00488, 107.1001, -25.757> }
				triangle { <38.6068, 107.8413, -26.1858>, <38.6972, 107.7998, -26.07729>, <38.00488, 107.1001, -25.757> }
				triangle { <38.6068, 107.8413, -26.1858>, <40.6197, 110.3482, -26.91>, <38.6972, 107.7998, -26.07729> }
				triangle { <38.6972, 107.7998, -26.07729>, <40.6197, 110.3482, -26.91>, <38.7697, 107.7454, -25.9588> }
				triangle { <38.00488, 107.1001, -25.757>, <38.6972, 107.7998, -26.07729>, <38.7697, 107.7454, -25.9588> }
				triangle { <38.00488, 107.1001, -25.757>, <38.7697, 107.7454, -25.9588>, <38.06387, 107.0492, -25.6583> }
				triangle { <38.00488, 107.1001, -25.757>, <38.06387, 107.0492, -25.6583>, <36.6229, 106.1431, -25.00914> }
				triangle { <41.5921, 111.7706, -27.144>, <40.6197, 110.3482, -26.91>, <40.475, 110.4573, -27.02845> }
				triangle { <38.7697, 107.7454, -25.9588>, <40.6197, 110.3482, -26.91>, <40.7508, 110.3494, -26.6733> }
				triangle { <38.6068, 107.8413, -26.1858>, <40.475, 110.4573, -27.02845>, <40.6197, 110.3482, -26.91> }
				triangle { <41.5921, 111.7706, -27.144>, <40.7508, 110.3494, -26.6733>, <40.6197, 110.3482, -26.91> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1231, 5.847, 0.07379>, 0.09031 }
			cylinder { <0.1231, 5.847, 0.07379>, <0.3692, 11.6887, 0.2213>, 0.09031 }
			cylinder { <0.3692, 11.6887, 0.2213>, <0.7383, 17.5217, 0.4425>, 0.09031 }
			cylinder { <0.7383, 17.5217, 0.4425>, <1.23, 23.3423, 0.7372>, 0.09031 }
			cylinder { <1.23, 23.3423, 0.7372>, <1.8441, 29.1471, 1.1053>, 0.09031 }
			cylinder { <1.8441, 29.1471, 1.1053>, <2.5802, 34.9326, 1.5465>, 0.09031 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.5802, 34.9326, 1.5465>, <2.7428, 36.6799, 1.6943>, 0.09031 }
				cylinder { <2.7428, 36.6799, 1.6943>, <2.8462, 38.4304, 1.857>, 0.09031 }
				cylinder { <2.8462, 38.4304, 1.857>, <2.8903, 40.182, 2.03427>, 0.09031 }
				cylinder { <2.8903, 40.182, 2.03427>, <2.875, 41.9326, 2.2258>, 0.09031 }
				cylinder { <2.875, 41.9326, 2.2258>, <2.8002, 43.68, 2.4315>, 0.09031 }
				cylinder { <2.8002, 43.68, 2.4315>, <2.6662, 45.4222, 2.6511>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.6662, 45.4222, 2.6511>, <2.6616, 45.6082, 2.6588>, 0.002876 }
				cylinder { <2.6616, 45.6082, 2.6588>, <2.6666, 45.7943, 2.651>, 0.002876 }
				cylinder { <2.6666, 45.7943, 2.651>, <2.6811, 45.9785, 2.6277>, 0.002876 }
				cylinder { <2.6811, 45.9785, 2.6277>, <2.705, 46.1592, 2.5891>, 0.002876 }
				cylinder { <2.705, 46.1592, 2.5891>, <2.7381, 46.3345, 2.5357>, 0.002876 }
				cylinder { <2.7381, 46.3345, 2.5357>, <2.78, 46.5029, 2.4679>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.78, 46.5029, 2.4679>, <2.9935, 48.2207, 1.912>, <2.8652, 48.2485, 1.893> }
				triangle { <2.9935, 48.2207, 1.912>, <3.1336, 49.1522, 1.4381>, <2.8652, 48.2485, 1.893> }
				triangle { <3.1336, 49.1522, 1.4381>, <2.9926, 49.1475, 1.3959>, <2.8652, 48.2485, 1.893> }
				triangle { <3.1336, 49.1522, 1.4381>, <3.6331, 51.7657, -0.5064>, <2.9926, 49.1475, 1.3959> }
				triangle { <2.9926, 49.1475, 1.3959>, <3.6331, 51.7657, -0.5064>, <2.8501, 49.12, 1.3614> }
				triangle { <2.8652, 48.2485, 1.893>, <2.9926, 49.1475, 1.3959>, <2.8501, 49.12, 1.3614> }
				triangle { <2.8652, 48.2485, 1.893>, <2.8501, 49.12, 1.3614>, <2.7445, 48.223, 1.869> }
				triangle { <2.8652, 48.2485, 1.893>, <2.7445, 48.223, 1.869>, <2.78, 46.5029, 2.4679> }
				triangle { <3.9187, 53.01438, -1.6823>, <3.6331, 51.7657, -0.5064>, <3.8492, 51.7517, -0.5046> }
				triangle { <2.8501, 49.12, 1.3614>, <3.6331, 51.7657, -0.5064>, <3.415, 51.7281, -0.662> }
				triangle { <3.1336, 49.1522, 1.4381>, <3.8492, 51.7517, -0.5046>, <3.6331, 51.7657, -0.5064> }
				triangle { <3.9187, 53.01438, -1.6823>, <3.415, 51.7281, -0.662>, <3.6331, 51.7657, -0.5064> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.6662, 45.4222, 2.6511>, <2.6509, 47.1727, 2.8428>, 0.09031 }
				cylinder { <2.6509, 47.1727, 2.8428>, <2.7544, 48.9232, 3.005944>, 0.09031 }
				cylinder { <2.7544, 48.9232, 3.005944>, <2.9762, 50.6651, 3.1397>, 0.09031 }
				cylinder { <2.9762, 50.6651, 3.1397>, <3.3153, 52.3901, 3.2438>, 0.09031 }
				cylinder { <3.3153, 52.3901, 3.2438>, <3.7701, 54.08983, 3.3177>, 0.09031 }
				cylinder { <3.7701, 54.08983, 3.3177>, <4.3385, 55.756, 3.3612>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.3385, 55.756, 3.3612>, <4.3894, 55.9341, 3.3815>, 0.002876 }
				cylinder { <4.3894, 55.9341, 3.3815>, <4.4306, 56.1122, 3.4173>, 0.002876 }
				cylinder { <4.4306, 56.1122, 3.4173>, <4.4618, 56.2886, 3.4683>, 0.002876 }
				cylinder { <4.4618, 56.2886, 3.4683>, <4.4825, 56.4617, 3.5339>, 0.002876 }
				cylinder { <4.4825, 56.4617, 3.5339>, <4.4926, 56.6298, 3.6135>, 0.002876 }
				cylinder { <4.4926, 56.6298, 3.6135>, <4.492, 56.7913, 3.7064>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.492, 56.7913, 3.7064>, <4.2753, 58.3023, 4.6939>, <4.1447, 58.3161, 4.6756> }
				triangle { <4.2753, 58.3023, 4.6939>, <4.1854, 59.2597, 5.1266>, <4.1447, 58.3161, 4.6756> }
				triangle { <4.1854, 59.2597, 5.1266>, <4.05135, 59.2699, 5.06681>, <4.1447, 58.3161, 4.6756> }
				triangle { <4.1854, 59.2597, 5.1266>, <4.05107, 62.4404, 5.9789>, <4.05135, 59.2699, 5.06681> }
				triangle { <4.05135, 59.2699, 5.06681>, <4.05107, 62.4404, 5.9789>, <3.9213, 59.2599, 4.9942> }
				triangle { <4.1447, 58.3161, 4.6756>, <4.05135, 59.2699, 5.06681>, <3.9213, 59.2599, 4.9942> }
				triangle { <4.1447, 58.3161, 4.6756>, <3.9213, 59.2599, 4.9942>, <4.03499, 58.3022, 4.6158> }
				triangle { <4.1447, 58.3161, 4.6756>, <4.03499, 58.3022, 4.6158>, <4.492, 56.7913, 3.7064> }
				triangle { <4.03814, 64.1592, 6.2417>, <4.05107, 62.4404, 5.9789>, <4.2634, 62.4609, 6.0155> }
				triangle { <3.9213, 59.2599, 4.9942>, <4.05107, 62.4404, 5.9789>, <3.8534, 62.5081, 5.8069> }
				triangle { <4.1854, 59.2597, 5.1266>, <4.2634, 62.4609, 6.0155>, <4.05107, 62.4404, 5.9789> }
				triangle { <4.03814, 64.1592, 6.2417>, <3.8534, 62.5081, 5.8069>, <4.05107, 62.4404, 5.9789> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.3385, 55.756, 3.3612>, <4.9418, 57.4093, 3.4268>, 0.09031 }
				cylinder { <4.9418, 57.4093, 3.4268>, <5.5795, 59.04853, 3.5143>, 0.09031 }
				cylinder { <5.5795, 59.04853, 3.5143>, <6.2514, 60.6727, 3.6236>, 0.09031 }
				cylinder { <6.2514, 60.6727, 3.6236>, <6.957, 62.2809, 3.7548>, 0.09031 }
				cylinder { <6.957, 62.2809, 3.7548>, <7.6958, 63.8721, 3.9078>, 0.09031 }
				cylinder { <7.6958, 63.8721, 3.9078>, <8.4675, 65.4455, 4.08238>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <8.4675, 65.4455, 4.08238>, <8.5616, 65.6062, 4.07713>, 0.002876 }
				cylinder { <8.5616, 65.6062, 4.07713>, <8.6661, 65.7576, 4.04827>, 0.002876 }
				cylinder { <8.6661, 65.7576, 4.04827>, <8.7788, 65.8966, 3.9964>, 0.002876 }
				cylinder { <8.7788, 65.8966, 3.9964>, <8.8973, 66.02006, 3.9227>, 0.002876 }
				cylinder { <8.8973, 66.02006, 3.9227>, <9.01891, 66.1253, 3.8287>, 0.002876 }
				cylinder { <9.01891, 66.1253, 3.8287>, <9.141, 66.2101, 3.7165>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <9.141, 66.2101, 3.7165>, <10.2451, 67.24, 2.7037>, <10.159, 67.3376, 2.6785> }
				triangle { <10.2451, 67.24, 2.7037>, <10.8318, 67.7464, 1.9887>, <10.159, 67.3376, 2.6785> }
				triangle { <10.8318, 67.7464, 1.9887>, <10.7119, 67.8228, 1.9502>, <10.159, 67.3376, 2.6785> }
				triangle { <10.8318, 67.7464, 1.9887>, <12.4501, 68.9694, -0.6086>, <10.7119, 67.8228, 1.9502> }
				triangle { <10.7119, 67.8228, 1.9502>, <12.4501, 68.9694, -0.6086>, <10.5785, 67.8848, 1.9256> }
				triangle { <10.159, 67.3376, 2.6785>, <10.7119, 67.8228, 1.9502>, <10.5785, 67.8848, 1.9256> }
				triangle { <10.159, 67.3376, 2.6785>, <10.5785, 67.8848, 1.9256>, <10.04554, 67.3896, 2.6631> }
				triangle { <10.159, 67.3376, 2.6785>, <10.04554, 67.3896, 2.6631>, <9.141, 66.2101, 3.7165> }
				triangle { <13.2155, 69.4717, -2.08698>, <12.4501, 68.9694, -0.6086>, <12.6096, 68.8232, -0.6042> }
				triangle { <10.5785, 67.8848, 1.9256>, <12.4501, 68.9694, -0.6086>, <12.2301, 69.04585, -0.7465> }
				triangle { <10.8318, 67.7464, 1.9887>, <12.6096, 68.8232, -0.6042>, <12.4501, 68.9694, -0.6086> }
				triangle { <13.2155, 69.4717, -2.08698>, <12.2301, 69.04585, -0.7465>, <12.4501, 68.9694, -0.6086> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <8.4675, 65.4455, 4.08238>, <9.3447, 66.9658, 4.2254>, 0.09031 }
				cylinder { <9.3447, 66.9658, 4.2254>, <10.3233, 68.4258, 4.3364>, 0.09031 }
				cylinder { <10.3233, 68.4258, 4.3364>, <11.3984, 69.8184, 4.4149>, 0.09031 }
				cylinder { <11.3984, 69.8184, 4.4149>, <12.565, 71.1368, 4.4608>, 0.09031 }
				cylinder { <12.565, 71.1368, 4.4608>, <13.8175, 72.3747, 4.4739>, 0.09031 }
				cylinder { <13.8175, 72.3747, 4.4739>, <15.1499, 73.5261, 4.4542>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <15.1499, 73.5261, 4.4542>, <15.2844, 73.6542, 4.4681>, 0.002876 }
				cylinder { <15.2844, 73.6542, 4.4681>, <15.4112, 73.7875, 4.4976>, 0.002876 }
				cylinder { <15.4112, 73.7875, 4.4976>, <15.529, 73.9245, 4.5427>, 0.002876 }
				cylinder { <15.529, 73.9245, 4.5427>, <15.6368, 74.06411, 4.6028>, 0.002876 }
				cylinder { <15.6368, 74.06411, 4.6028>, <15.7334, 74.2048, 4.6774>, 0.002876 }
				cylinder { <15.7334, 74.2048, 4.6774>, <15.818, 74.3453, 4.7657>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <15.818, 74.3453, 4.7657>, <16.4319, 75.7682, 5.7164>, <16.3255, 75.8458, 5.7016> }
				triangle { <16.4319, 75.7682, 5.7164>, <16.8543, 76.6439, 6.1247>, <16.3255, 75.8458, 5.7016> }
				triangle { <16.8543, 76.6439, 6.1247>, <16.7414, 76.7198, 6.06853>, <16.3255, 75.8458, 5.7016> }
				triangle { <16.8543, 76.6439, 6.1247>, <18.376, 79.4648, 6.8913>, <16.7414, 76.7198, 6.06853> }
				triangle { <16.7414, 76.7198, 6.06853>, <18.376, 79.4648, 6.8913>, <16.6214, 76.7762, 6.000093> }
				triangle { <16.3255, 75.8458, 5.7016>, <16.7414, 76.7198, 6.06853>, <16.6214, 76.7762, 6.000093> }
				triangle { <16.3255, 75.8458, 5.7016>, <16.6214, 76.7762, 6.000093>, <16.2215, 75.8887, 5.6454> }
				triangle { <16.3255, 75.8458, 5.7016>, <16.2215, 75.8887, 5.6454>, <15.818, 74.3453, 4.7657> }
				triangle { <19.2421, 80.9573, 7.1062>, <18.376, 79.4648, 6.8913>, <18.5711, 79.3756, 6.921> }
				triangle { <16.6214, 76.7762, 6.000093>, <18.376, 79.4648, 6.8913>, <18.233, 79.6215, 6.7233> }
				triangle { <16.8543, 76.6439, 6.1247>, <18.5711, 79.3756, 6.921>, <18.376, 79.4648, 6.8913> }
				triangle { <19.2421, 80.9573, 7.1062>, <18.233, 79.6215, 6.7233>, <18.376, 79.4648, 6.8913> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <15.1499, 73.5261, 4.4542>, <16.4683, 74.6936, 4.4722>, 0.09031 }
				cylinder { <16.4683, 74.6936, 4.4722>, <17.7719, 75.8764, 4.5278>, 0.09031 }
				cylinder { <17.7719, 75.8764, 4.5278>, <19.05991, 77.07381, 4.621>, 0.09031 }
				cylinder { <19.05991, 77.07381, 4.621>, <20.3315, 78.2851, 4.7516>, 0.09031 }
				cylinder { <20.3315, 78.2851, 4.7516>, <21.586, 79.5096, 4.9197>, 0.09031 }
				cylinder { <21.586, 79.5096, 4.9197>, <22.8225, 80.7465, 5.1251>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <22.8225, 80.7465, 5.1251>, <22.962, 80.87, 5.1271>, 0.002876 }
				cylinder { <22.962, 80.87, 5.1271>, <23.108, 80.9843, 5.1091>, 0.002876 }
				cylinder { <23.108, 80.9843, 5.1091>, <23.2584, 81.08768, 5.07161>, 0.002876 }
				cylinder { <23.2584, 81.08768, 5.07161>, <23.4108, 81.1785, 5.01506>, 0.002876 }
				cylinder { <23.4108, 81.1785, 5.01506>, <23.5631, 81.2555, 4.9403>, 0.002876 }
				cylinder { <23.5631, 81.2555, 4.9403>, <23.7128, 81.3175, 4.8485>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <23.7128, 81.3175, 4.8485>, <25.1314, 82.1308, 4.05388>, <25.075, 82.2493, 4.03526> }
				triangle { <25.1314, 82.1308, 4.05388>, <25.8927, 82.5424, 3.4513>, <25.075, 82.2493, 4.03526> }
				triangle { <25.8927, 82.5424, 3.4513>, <25.7998, 82.6505, 3.4147>, <25.075, 82.2493, 4.03526> }
				triangle { <25.8927, 82.5424, 3.4513>, <28.01208, 83.5762, 1.149>, <25.7998, 82.6505, 3.4147> }
				triangle { <25.7998, 82.6505, 3.4147>, <28.01208, 83.5762, 1.149>, <25.6889, 82.7469, 3.3888> }
				triangle { <25.075, 82.2493, 4.03526>, <25.7998, 82.6505, 3.4147>, <25.6889, 82.7469, 3.3888> }
				triangle { <25.075, 82.2493, 4.03526>, <25.6889, 82.7469, 3.3888>, <24.9799, 82.3299, 4.01878> }
				triangle { <25.075, 82.2493, 4.03526>, <24.9799, 82.3299, 4.01878>, <23.7128, 81.3175, 4.8485> }
				triangle { <29.02043, 84.01836, -0.1968>, <28.01208, 83.5762, 1.149>, <28.1294, 83.3943, 1.1458> }
				triangle { <25.6889, 82.7469, 3.3888>, <28.01208, 83.5762, 1.149>, <27.8324, 83.7205, 1.006995> }
				triangle { <25.8927, 82.5424, 3.4513>, <28.1294, 83.3943, 1.1458>, <28.01208, 83.5762, 1.149> }
				triangle { <29.02043, 84.01836, -0.1968>, <27.8324, 83.7205, 1.006995>, <28.01208, 83.5762, 1.149> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <22.8225, 80.7465, 5.1251>, <24.04055, 81.9952, 5.3678>, 0.09031 }
				cylinder { <24.04055, 81.9952, 5.3678>, <25.2391, 83.2548, 5.6475>, 0.09031 }
				cylinder { <25.2391, 83.2548, 5.6475>, <26.4176, 84.5245, 5.964>, 0.09031 }
				cylinder { <26.4176, 84.5245, 5.964>, <27.5753, 85.8037, 6.3173>, 0.09031 }
				cylinder { <27.5753, 85.8037, 6.3173>, <28.7115, 87.09158, 6.707>, 0.09031 }
				cylinder { <28.7115, 87.09158, 6.707>, <29.8255, 88.3872, 7.1331>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <29.8255, 88.3872, 7.1331>, <29.9278, 88.5275, 7.2005>, 0.002876 }
				cylinder { <29.9278, 88.5275, 7.2005>, <30.01246, 88.6681, 7.2888>, 0.002876 }
				cylinder { <30.01246, 88.6681, 7.2888>, <30.07749, 88.8057, 7.3961>, 0.002876 }
				cylinder { <30.07749, 88.8057, 7.3961>, <30.1215, 88.9376, 7.52>, 0.002876 }
				cylinder { <30.1215, 88.9376, 7.52>, <30.1436, 89.06086, 7.658>, 0.002876 }
				cylinder { <30.1436, 89.06086, 7.658>, <30.1434, 89.1727, 7.8069>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <30.1434, 89.1727, 7.8069>, <29.9076, 90.2334, 9.2645>, <29.7918, 90.2867, 9.2283> }
				triangle { <29.9076, 90.2334, 9.2645>, <29.858, 90.9616, 10.02566>, <29.7918, 90.2867, 9.2283> }
				triangle { <29.858, 90.9616, 10.02566>, <29.75, 91.02748, 9.9502>, <29.7918, 90.2867, 9.2283> }
				triangle { <29.858, 90.9616, 10.02566>, <30.01435, 93.5456, 12.06513>, <29.75, 91.02748, 9.9502> }
				triangle { <29.75, 91.02748, 9.9502>, <30.01435, 93.5456, 12.06513>, <29.6462, 91.07864, 9.856> }
				triangle { <29.7918, 90.2867, 9.2283>, <29.75, 91.02748, 9.9502>, <29.6462, 91.07864, 9.856> }
				triangle { <29.7918, 90.2867, 9.2283>, <29.6462, 91.07864, 9.856>, <29.7029, 90.3246, 9.1478> }
				triangle { <29.7918, 90.2867, 9.2283>, <29.7029, 90.3246, 9.1478>, <30.1434, 89.1727, 7.8069> }
				triangle { <30.2114, 94.9966, 13.00288>, <30.01435, 93.5456, 12.06513>, <30.2079, 93.495, 12.1477> }
				triangle { <29.6462, 91.07864, 9.856>, <30.01435, 93.5456, 12.06513>, <29.8877, 93.7197, 11.9011> }
				triangle { <29.858, 90.9616, 10.02566>, <30.2079, 93.495, 12.1477>, <30.01435, 93.5456, 12.06513> }
				triangle { <30.2114, 94.9966, 13.00288>, <29.8877, 93.7197, 11.9011>, <30.01435, 93.5456, 12.06513> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <29.8255, 88.3872, 7.1331>, <31.00991, 89.617, 7.5649>, 0.09031 }
				cylinder { <31.00991, 89.617, 7.5649>, <32.261, 90.7769, 8.001471>, 0.09031 }
				cylinder { <32.261, 90.7769, 8.001471>, <33.5751, 91.8637, 8.4413>, 0.09031 }
				cylinder { <33.5751, 91.8637, 8.4413>, <34.9481, 92.874, 8.8832>, 0.09031 }
				cylinder { <34.9481, 92.874, 8.8832>, <36.3761, 93.8047, 9.326>, 0.09031 }
				cylinder { <36.3761, 93.8047, 9.326>, <37.8546, 94.6531, 9.7684>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <37.8546, 94.6531, 9.7684>, <38.02188, 94.7331, 9.7867>, 0.002876 }
				cylinder { <38.02188, 94.7331, 9.7867>, <38.195, 94.8008, 9.7761>, 0.002876 }
				cylinder { <38.195, 94.8008, 9.7761>, <38.369, 94.8545, 9.7369>, 0.002876 }
				cylinder { <38.369, 94.8545, 9.7369>, <38.5388, 94.8924, 9.6702>, 0.002876 }
				cylinder { <38.5388, 94.8924, 9.6702>, <38.6992, 94.9134, 9.5779>, 0.002876 }
				cylinder { <38.6992, 94.9134, 9.5779>, <38.8456, 94.917, 9.4628>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <38.8456, 94.917, 9.4628>, <40.3286, 95.1583, 8.4392>, <40.3186, 95.2897, 8.4253> }
				triangle { <40.3286, 95.1583, 8.4392>, <41.08868, 95.2693, 7.7167>, <40.3186, 95.2897, 8.4253> }
				triangle { <41.08868, 95.2693, 7.7167>, <41.0388, 95.4054, 7.6908>, <40.3186, 95.2897, 8.4253> }
				triangle { <41.08868, 95.2693, 7.7167>, <43.06829, 95.4914, 5.09126>, <41.0388, 95.4054, 7.6908> }
				triangle { <41.0388, 95.4054, 7.6908>, <43.06829, 95.4914, 5.09126>, <40.9695, 95.537, 7.6787> }
				triangle { <40.3186, 95.2897, 8.4253>, <41.0388, 95.4054, 7.6908>, <40.9695, 95.537, 7.6787> }
				triangle { <40.3186, 95.2897, 8.4253>, <40.9695, 95.537, 7.6787>, <40.2594, 95.4006, 8.4207> }
				triangle { <40.3186, 95.2897, 8.4253>, <40.2594, 95.4006, 8.4207>, <38.8456, 94.917, 9.4628> }
				triangle { <43.9537, 95.5575, 3.5962>, <43.06829, 95.4914, 5.09126>, <43.1069, 95.2789, 5.07652> }
				triangle { <40.9695, 95.537, 7.6787>, <43.06829, 95.4914, 5.09126>, <42.9367, 95.6962, 4.973> }
				triangle { <41.08868, 95.2693, 7.7167>, <43.1069, 95.2789, 5.07652>, <43.06829, 95.4914, 5.09126> }
				triangle { <43.9537, 95.5575, 3.5962>, <42.9367, 95.6962, 4.973>, <43.06829, 95.4914, 5.09126> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <37.8546, 94.6531, 9.7684>, <39.3653, 95.4534, 10.1911>, 0.09031 }
				cylinder { <39.3653, 95.4534, 10.1911>, <40.9064, 96.2046, 10.5937>, 0.09031 }
				cylinder { <40.9064, 96.2046, 10.5937>, <42.476, 96.9059, 10.9757>, 0.09031 }
				cylinder { <42.476, 96.9059, 10.9757>, <44.07231, 97.5563, 11.3367>, 0.09031 }
				cylinder { <44.07231, 97.5563, 11.3367>, <45.6932, 98.1551, 11.6762>, 0.09031 }
				cylinder { <45.6932, 98.1551, 11.6762>, <47.337, 98.7015, 11.9939>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <47.337, 98.7015, 11.9939>, <47.5048, 98.765, 12.04391>, 0.002876 }
				cylinder { <47.5048, 98.765, 12.04391>, <47.6651, 98.8335, 12.1096>, 0.002876 }
				cylinder { <47.6651, 98.8335, 12.1096>, <47.8161, 98.9065, 12.1905>, 0.002876 }
				cylinder { <47.8161, 98.9065, 12.1905>, <47.9566, 98.9831, 12.2859>, 0.002876 }
				cylinder { <47.9566, 98.9831, 12.2859>, <48.08515, 99.06282, 12.3947>, 0.002876 }
				cylinder { <48.08515, 99.06282, 12.3947>, <48.2004, 99.1446, 12.516>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <48.2004, 99.1446, 12.516>, <49.1359, 100.0565, 13.7804>, <49.06779, 100.17, 13.7735> }
				triangle { <49.1359, 100.0565, 13.7804>, <49.7788, 100.629, 14.3894>, <49.06779, 100.17, 13.7735> }
				triangle { <49.7788, 100.629, 14.3894>, <49.7102, 100.75, 14.3413>, <49.06779, 100.17, 13.7735> }
				triangle { <49.7788, 100.629, 14.3894>, <52.07926, 102.4995, 15.8283>, <49.7102, 100.75, 14.3413> }
				triangle { <49.7102, 100.75, 14.3413>, <52.07926, 102.4995, 15.8283>, <49.6298, 100.8579, 14.2767> }
				triangle { <49.06779, 100.17, 13.7735>, <49.7102, 100.75, 14.3413>, <49.6298, 100.8579, 14.2767> }
				triangle { <49.06779, 100.17, 13.7735>, <49.6298, 100.8579, 14.2767>, <48.9956, 100.2576, 13.7193> }
				triangle { <49.06779, 100.17, 13.7735>, <48.9956, 100.2576, 13.7193>, <48.2004, 99.1446, 12.516> }
				triangle { <53.3806, 103.4963, 16.4081>, <52.07926, 102.4995, 15.8283>, <52.2227, 102.3394, 15.8543> }
				triangle { <49.6298, 100.8579, 14.2767>, <52.07926, 102.4995, 15.8283>, <52.0283, 102.7234, 15.6851> }
				triangle { <49.7788, 100.629, 14.3894>, <52.2227, 102.3394, 15.8543>, <52.07926, 102.4995, 15.8283> }
				triangle { <53.3806, 103.4963, 16.4081>, <52.0283, 102.7234, 15.6851>, <52.07926, 102.4995, 15.8283> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <47.337, 98.7015, 11.9939>, <47.5108, 98.7593, 12.0276>, 0.002876 }
				cylinder { <47.5108, 98.7593, 12.0276>, <47.6847, 98.8171, 12.06121>, 0.002876 }
				cylinder { <47.6847, 98.8171, 12.06121>, <47.8586, 98.8749, 12.09481>, 0.002876 }
				cylinder { <47.8586, 98.8749, 12.09481>, <48.03246, 98.9327, 12.1284>, 0.002876 }
				cylinder { <48.03246, 98.9327, 12.1284>, <48.2063, 98.9905, 12.162>, 0.002876 }
				cylinder { <48.2063, 98.9905, 12.162>, <48.3801, 99.04829, 12.1956>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <48.3801, 99.04829, 12.1956>, <49.9798, 99.7744, 12.6636>, <49.9401, 99.9007, 12.6699> }
				triangle { <49.9798, 99.7744, 12.6636>, <50.9364, 100.2047, 12.7722>, <49.9401, 99.9007, 12.6699> }
				triangle { <50.9364, 100.2047, 12.7722>, <50.8766, 100.3357, 12.7419>, <49.9401, 99.9007, 12.6699> }
				triangle { <50.9364, 100.2047, 12.7722>, <53.9485, 101.5249, 12.5583>, <50.8766, 100.3357, 12.7419> }
				triangle { <50.8766, 100.3357, 12.7419>, <53.9485, 101.5249, 12.5583>, <50.7961, 100.456, 12.7056> }
				triangle { <49.9401, 99.9007, 12.6699>, <50.8766, 100.3357, 12.7419>, <50.7961, 100.456, 12.7056> }
				triangle { <49.9401, 99.9007, 12.6699>, <50.7961, 100.456, 12.7056>, <49.868, 100.0, 12.6422> }
				triangle { <49.9401, 99.9007, 12.6699>, <49.868, 100.0, 12.6422>, <48.3801, 99.04829, 12.1956> }
				triangle { <55.5216, 102.1976, 12.2477>, <53.9485, 101.5249, 12.5583>, <54.05267, 101.3359, 12.5407> }
				triangle { <50.7961, 100.456, 12.7056>, <53.9485, 101.5249, 12.5583>, <53.8739, 101.7448, 12.4194> }
				triangle { <50.9364, 100.2047, 12.7722>, <54.05267, 101.3359, 12.5407>, <53.9485, 101.5249, 12.5583> }
				triangle { <55.5216, 102.1976, 12.2477>, <53.8739, 101.7448, 12.4194>, <53.9485, 101.5249, 12.5583> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.06875, 5.9414, 0.1286>, 0.09177 }
			cylinder { <0.06875, 5.9414, 0.1286>, <0.2062, 11.8775, 0.3858>, 0.09177 }
			cylinder { <0.2062, 11.8775, 0.3858>, <0.4123, 17.8046, 0.7714>, 0.09177 }
			cylinder { <0.4123, 17.8046, 0.7714>, <0.6869, 23.7192, 1.2851>, 0.09177 }
			cylinder { <0.6869, 23.7192, 1.2851>, <1.02988, 29.6178, 1.9267>, 0.09177 }
			cylinder { <1.02988, 29.6178, 1.9267>, <1.4409, 35.4967, 2.6958>, 0.09177 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.4409, 35.4967, 2.6958>, <1.4461, 37.2754, 2.8916>, 0.09177 }
				cylinder { <1.4461, 37.2754, 2.8916>, <1.3327, 39.05432, 3.05046>, 0.09177 }
				cylinder { <1.3327, 39.05432, 3.05046>, <1.1014, 40.8246, 3.1715>, 0.09177 }
				cylinder { <1.1014, 40.8246, 3.1715>, <0.7532, 42.578, 3.254>, 0.09177 }
				cylinder { <0.7532, 42.578, 3.254>, <0.2899, 44.306, 3.2974>, 0.09177 }
				cylinder { <0.2899, 44.306, 3.2974>, <-0.2861, 46.00024, 3.3014>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.2861, 46.00024, 3.3014>, <-0.3358, 46.1859, 3.2956>, 0.002969 }
				cylinder { <-0.3358, 46.1859, 3.2956>, <-0.3732, 46.3742, 3.2834>, 0.002969 }
				cylinder { <-0.3732, 46.3742, 3.2834>, <-0.3979, 46.564, 3.2651>, 0.002969 }
				cylinder { <-0.3979, 46.564, 3.2651>, <-0.4098, 46.7544, 3.2406>, 0.002969 }
				cylinder { <-0.4098, 46.7544, 3.2406>, <-0.4089, 46.9443, 3.2102>, 0.002969 }
				cylinder { <-0.4089, 46.9443, 3.2102>, <-0.3952, 47.1327, 3.174>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.3952, 47.1327, 3.174>, <-0.5017, 48.9402, 2.8068>, <-0.6039, 48.9341, 2.7191> }
				triangle { <-0.5017, 48.9402, 2.8068>, <-0.4489, 49.9575, 2.4745>, <-0.6039, 48.9341, 2.7191> }
				triangle { <-0.4489, 49.9575, 2.4745>, <-0.5382, 49.9206, 2.3602>, <-0.6039, 48.9341, 2.7191> }
				triangle { <-0.4489, 49.9575, 2.4745>, <0.1089, 52.9499, 1.0784>, <-0.5382, 49.9206, 2.3602> }
				triangle { <-0.5382, 49.9206, 2.3602>, <0.1089, 52.9499, 1.0784>, <-0.6253, 49.86, 2.2519> }
				triangle { <-0.6039, 48.9341, 2.7191>, <-0.5382, 49.9206, 2.3602>, <-0.6253, 49.86, 2.2519> }
				triangle { <-0.6039, 48.9341, 2.7191>, <-0.6253, 49.86, 2.2519>, <-0.6796, 48.8797, 2.6317> }
				triangle { <-0.6039, 48.9341, 2.7191>, <-0.6796, 48.8797, 2.6317>, <-0.3952, 47.1327, 3.174> }
				triangle { <0.5434, 54.4362, 0.2275>, <0.1089, 52.9499, 1.0784>, <0.286, 52.9971, 1.2> }
				triangle { <-0.6253, 49.86, 2.2519>, <0.1089, 52.9499, 1.0784>, <0.02855, 52.8796, 0.825> }
				triangle { <-0.4489, 49.9575, 2.4745>, <0.286, 52.9971, 1.2>, <0.1089, 52.9499, 1.0784> }
				triangle { <0.5434, 54.4362, 0.2275>, <0.02855, 52.8796, 0.825>, <0.1089, 52.9499, 1.0784> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.2861, 46.00024, 3.3014>, <-0.7871, 47.717, 3.3645>, 0.09177 }
				cylinder { <-0.7871, 47.717, 3.3645>, <-1.2115, 49.4511, 3.4866>, 0.09177 }
				cylinder { <-1.2115, 49.4511, 3.4866>, <-1.5581, 51.1974, 3.6673>, 0.09177 }
				cylinder { <-1.5581, 51.1974, 3.6673>, <-1.8258, 52.9506, 3.9061>, 0.09177 }
				cylinder { <-1.8258, 52.9506, 3.9061>, <-2.01396, 54.7054, 4.2023>, 0.09177 }
				cylinder { <-2.01396, 54.7054, 4.2023>, <-2.1219, 56.4564, 4.5552>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-2.1219, 56.4564, 4.5552>, <-2.15, 56.641, 4.6015>, 0.002969 }
				cylinder { <-2.15, 56.641, 4.6015>, <-2.1943, 56.8201, 4.6559>, 0.002969 }
				cylinder { <-2.1943, 56.8201, 4.6559>, <-2.2544, 56.992, 4.7177>, 0.002969 }
				cylinder { <-2.2544, 56.992, 4.7177>, <-2.3297, 57.1551, 4.7863>, 0.002969 }
				cylinder { <-2.3297, 57.1551, 4.7863>, <-2.4195, 57.3079, 4.8612>, 0.002969 }
				cylinder { <-2.4195, 57.3079, 4.8612>, <-2.5229, 57.4487, 4.9416>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.5229, 57.4487, 4.9416>, <-3.7083, 58.6698, 5.6604>, <-3.8074, 58.6527, 5.5707> }
				triangle { <-3.7083, 58.6698, 5.6604>, <-4.3172, 59.4912, 5.9807>, <-3.8074, 58.6527, 5.5707> }
				triangle { <-4.3172, 59.4912, 5.9807>, <-4.3955, 59.4775, 5.854>, <-3.8074, 58.6527, 5.5707> }
				triangle { <-4.3172, 59.4912, 5.9807>, <-5.8929, 62.3703, 6.6462>, <-4.3955, 59.4775, 5.854> }
				triangle { <-4.3955, 59.4775, 5.854>, <-5.8929, 62.3703, 6.6462>, <-4.4572, 59.4477, 5.7187> }
				triangle { <-3.8074, 58.6527, 5.5707>, <-4.3955, 59.4775, 5.854>, <-4.4572, 59.4477, 5.7187> }
				triangle { <-3.8074, 58.6527, 5.5707>, <-4.4572, 59.4477, 5.7187>, <-3.8585, 58.6221, 5.4577> }
				triangle { <-3.8074, 58.6527, 5.5707>, <-3.8585, 58.6221, 5.4577>, <-2.5229, 57.4487, 4.9416> }
				triangle { <-6.5898, 63.978, 6.8736>, <-5.8929, 62.3703, 6.6462>, <-5.7491, 62.4383, 6.7982> }
				triangle { <-4.4572, 59.4477, 5.7187>, <-5.8929, 62.3703, 6.6462>, <-5.9797, 62.4164, 6.3894> }
				triangle { <-4.3172, 59.4912, 5.9807>, <-5.7491, 62.4383, 6.7982>, <-5.8929, 62.3703, 6.6462> }
				triangle { <-6.5898, 63.978, 6.8736>, <-5.9797, 62.4164, 6.3894>, <-5.8929, 62.3703, 6.6462> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-2.1219, 56.4564, 4.5552>, <-2.1495, 58.1985, 4.9636>, 0.09177 }
				cylinder { <-2.1495, 58.1985, 4.9636>, <-2.09657, 59.9263, 5.4265>, 0.09177 }
				cylinder { <-2.09657, 59.9263, 5.4265>, <-1.9633, 61.6346, 5.9424>, 0.09177 }
				cylinder { <-1.9633, 61.6346, 5.9424>, <-1.7502, 63.3183, 6.5099>, 0.09177 }
				cylinder { <-1.7502, 63.3183, 6.5099>, <-1.458, 64.9723, 7.1273>, 0.09177 }
				cylinder { <-1.458, 64.9723, 7.1273>, <-1.08749, 66.5917, 7.7928>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.08749, 66.5917, 7.7928>, <-1.0197, 66.7633, 7.847>, 0.002969 }
				cylinder { <-1.0197, 66.7633, 7.847>, <-0.9259, 66.9275, 7.8822>, 0.002969 }
				cylinder { <-0.9259, 66.9275, 7.8822>, <-0.8089, 67.07948, 7.8974>, 0.002969 }
				cylinder { <-0.8089, 67.07948, 7.8974>, <-0.6722, 67.2146, 7.8921>, 0.002969 }
				cylinder { <-0.6722, 67.2146, 7.8921>, <-0.5198, 67.3291, 7.8666>, 0.002969 }
				cylinder { <-0.5198, 67.3291, 7.8666>, <-0.356, 67.4194, 7.8215>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.356, 67.4194, 7.8215>, <1.09424, 68.4904, 7.4185>, <1.02675, 68.5874, 7.3538> }
				triangle { <1.09424, 68.4904, 7.4185>, <1.9493, 69.01772, 7.04573>, <1.02675, 68.5874, 7.3538> }
				triangle { <1.9493, 69.01772, 7.04573>, <1.8581, 69.09238, 6.9535>, <1.02675, 68.5874, 7.3538> }
				triangle { <1.9493, 69.01772, 7.04573>, <4.6068, 70.2943, 5.4574>, <1.8581, 69.09238, 6.9535> }
				triangle { <1.8581, 69.09238, 6.9535>, <4.6068, 70.2943, 5.4574>, <1.7484, 69.152, 6.8675> }
				triangle { <1.02675, 68.5874, 7.3538>, <1.8581, 69.09238, 6.9535>, <1.7484, 69.152, 6.8675> }
				triangle { <1.02675, 68.5874, 7.3538>, <1.7484, 69.152, 6.8675>, <0.9308, 68.6374, 7.2857> }
				triangle { <1.02675, 68.5874, 7.3538>, <0.9308, 68.6374, 7.2857>, <-0.356, 67.4194, 7.8215> }
				triangle { <5.9832, 70.8203, 4.4824>, <4.6068, 70.2943, 5.4574>, <4.7512, 70.1496, 5.5386> }
				triangle { <1.7484, 69.152, 6.8675>, <4.6068, 70.2943, 5.4574>, <4.4725, 70.3663, 5.2285> }
				triangle { <1.9493, 69.01772, 7.04573>, <4.7512, 70.1496, 5.5386>, <4.6068, 70.2943, 5.4574> }
				triangle { <5.9832, 70.8203, 4.4824>, <4.4725, 70.3663, 5.2285>, <4.6068, 70.2943, 5.4574> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.08749, 66.5917, 7.7928>, <-0.7552, 68.2103, 8.4799>, 0.09177 }
				cylinder { <-0.7552, 68.2103, 8.4799>, <-0.4613, 69.8272, 9.1881>, 0.09177 }
				cylinder { <-0.4613, 69.8272, 9.1881>, <-0.2061, 71.4414, 9.9171>, 0.09177 }
				cylinder { <-0.2061, 71.4414, 9.9171>, <0.01028, 73.05205, 10.6664>, 0.09177 }
				cylinder { <0.01028, 73.05205, 10.6664>, <0.1878, 74.658, 11.4356>, 0.09177 }
				cylinder { <0.1878, 74.658, 11.4356>, <0.3263, 76.2584, 12.2241>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.3263, 76.2584, 12.2241>, <0.3159, 76.4247, 12.3203>, 0.002969 }
				cylinder { <0.3159, 76.4247, 12.3203>, <0.2805, 76.5816, 12.4257>, 0.002969 }
				cylinder { <0.2805, 76.5816, 12.4257>, <0.2209, 76.7257, 12.5382>, 0.002969 }
				cylinder { <0.2209, 76.7257, 12.5382>, <0.1382, 76.854, 12.6553>, 0.002969 }
				cylinder { <0.1382, 76.854, 12.6553>, <0.03446, 76.9637, 12.7744>, 0.002969 }
				cylinder { <0.03446, 76.9637, 12.7744>, <-0.0883, 77.05231, 12.893>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.0883, 77.05231, 12.893>, <-1.4401, 77.7852, 13.9169>, <-1.5324, 77.7952, 13.8192> }
				triangle { <-1.4401, 77.7852, 13.9169>, <-2.1553, 78.3588, 14.4716>, <-1.5324, 77.7952, 13.8192> }
				triangle { <-2.1553, 78.3588, 14.4716>, <-2.2257, 78.3881, 14.3429>, <-1.5324, 77.7952, 13.8192> }
				triangle { <-2.1553, 78.3588, 14.4716>, <-4.08753, 80.5977, 16.0428>, <-2.2257, 78.3881, 14.3429> }
				triangle { <-2.2257, 78.3881, 14.3429>, <-4.08753, 80.5977, 16.0428>, <-2.2774, 78.4075, 14.2016> }
				triangle { <-1.5324, 77.7952, 13.8192>, <-2.2257, 78.3881, 14.3429>, <-2.2774, 78.4075, 14.2016> }
				triangle { <-1.5324, 77.7952, 13.8192>, <-2.2774, 78.4075, 14.2016>, <-1.5745, 77.8062, 13.6991> }
				triangle { <-1.5324, 77.7952, 13.8192>, <-1.5745, 77.8062, 13.6991>, <-0.0883, 77.05231, 12.893> }
				triangle { <-4.9786, 81.9205, 16.8031>, <-4.08753, 80.5977, 16.0428>, <-3.9596, 80.6144, 16.221> }
				triangle { <-2.2774, 78.4075, 14.2016>, <-4.08753, 80.5977, 16.0428>, <-4.1677, 80.7315, 15.8163> }
				triangle { <-2.1553, 78.3588, 14.4716>, <-3.9596, 80.6144, 16.221>, <-4.08753, 80.5977, 16.0428> }
				triangle { <-4.9786, 81.9205, 16.8031>, <-4.1677, 80.7315, 15.8163>, <-4.08753, 80.5977, 16.0428> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.3263, 76.2584, 12.2241>, <0.4059, 77.8705, 12.9969>, 0.09177 }
				cylinder { <0.4059, 77.8705, 12.9969>, <0.4265, 79.4923, 13.7529>, 0.09177 }
				cylinder { <0.4265, 79.4923, 13.7529>, <0.3881, 81.1219, 14.4913>, 0.09177 }
				cylinder { <0.3881, 81.1219, 14.4913>, <0.2906, 82.7574, 15.2111>, 0.09177 }
				cylinder { <0.2906, 82.7574, 15.2111>, <0.1344, 84.3967, 15.9115>, 0.09177 }
				cylinder { <0.1344, 84.3967, 15.9115>, <-0.08052, 86.03801, 16.5916>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.08052, 86.03801, 16.5916>, <-0.0868, 86.2186, 16.6572>, 0.002969 }
				cylinder { <-0.0868, 86.2186, 16.6572>, <-0.07618, 86.4018, 16.7149>, 0.002969 }
				cylinder { <-0.07618, 86.4018, 16.7149>, <-0.04877, 86.5858, 16.764>, 0.002969 }
				cylinder { <-0.04877, 86.5858, 16.764>, <-0.004836, 86.7687, 16.804>, 0.002969 }
				cylinder { <-0.004836, 86.7687, 16.804>, <0.0552, 86.9488, 16.8345>, 0.002969 }
				cylinder { <0.0552, 86.9488, 16.8345>, <0.1307, 87.1245, 16.8553>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.1307, 87.1245, 16.8553>, <0.6311, 88.8908, 17.06178>, <0.5327, 88.9455, 16.9878> }
				triangle { <0.6311, 88.8908, 17.06178>, <1.01898, 89.8896, 17.04681>, <0.5327, 88.9455, 16.9878> }
				triangle { <1.01898, 89.8896, 17.04681>, <0.9223, 89.9212, 16.937>, <0.5327, 88.9455, 16.9878> }
				triangle { <1.01898, 89.8896, 17.04681>, <2.539, 92.8341, 16.563>, <0.9223, 89.9212, 16.937> }
				triangle { <0.9223, 89.9212, 16.937>, <2.539, 92.8341, 16.563>, <0.82, 89.929, 16.8254> }
				triangle { <0.5327, 88.9455, 16.9878>, <0.9223, 89.9212, 16.937>, <0.82, 89.929, 16.8254> }
				triangle { <0.5327, 88.9455, 16.9878>, <0.82, 89.929, 16.8254>, <0.4431, 88.9487, 16.8967> }
				triangle { <0.5327, 88.9455, 16.9878>, <0.4431, 88.9487, 16.8967>, <0.1307, 87.1245, 16.8553> }
				triangle { <3.4423, 94.2973, 16.1566>, <2.539, 92.8341, 16.563>, <2.7219, 92.7817, 16.6735> }
				triangle { <0.82, 89.929, 16.8254>, <2.539, 92.8341, 16.563>, <2.4396, 92.8774, 16.3103> }
				triangle { <1.01898, 89.8896, 17.04681>, <2.7219, 92.7817, 16.6735>, <2.539, 92.8341, 16.563> }
				triangle { <3.4423, 94.2973, 16.1566>, <2.4396, 92.8774, 16.3103>, <2.539, 92.8341, 16.563> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.08052, 86.03801, 16.5916>, <-0.2954, 87.6792, 17.2716>, 0.09177 }
				cylinder { <-0.2954, 87.6792, 17.2716>, <-0.5104, 89.3204, 17.9517>, 0.09177 }
				cylinder { <-0.5104, 89.3204, 17.9517>, <-0.7253, 90.9617, 18.6318>, 0.09177 }
				cylinder { <-0.7253, 90.9617, 18.6318>, <-0.9403, 92.6029, 19.3118>, 0.09177 }
				cylinder { <-0.9403, 92.6029, 19.3118>, <-1.1552, 94.2441, 19.9919>, 0.09177 }
				cylinder { <-1.1552, 94.2441, 19.9919>, <-1.3701, 95.8854, 20.672>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.3701, 95.8854, 20.672>, <-1.418, 96.05226, 20.7548>, 0.002969 }
				cylinder { <-1.418, 96.05226, 20.7548>, <-1.4896, 96.2059, 20.8456>, 0.002969 }
				cylinder { <-1.4896, 96.2059, 20.8456>, <-1.5835, 96.343, 20.9425>, 0.002969 }
				cylinder { <-1.5835, 96.343, 20.9425>, <-1.6974, 96.4607, 21.04327>, 0.002969 }
				cylinder { <-1.6974, 96.4607, 21.04327>, <-1.8291, 96.5564, 21.1457>, 0.002969 }
				cylinder { <-1.8291, 96.5564, 21.1457>, <-1.9756, 96.628, 21.2477>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-1.9756, 96.628, 21.2477>, <-3.5212, 97.1619, 22.1074>, <-3.6047, 97.1495, 22.00242> }
				triangle { <-3.5212, 97.1619, 22.1074>, <-4.3726, 97.6276, 22.5618>, <-3.6047, 97.1495, 22.00242> }
				triangle { <-4.3726, 97.6276, 22.5618>, <-4.4352, 97.6363, 22.4262>, <-3.6047, 97.1495, 22.00242> }
				triangle { <-4.3726, 97.6276, 22.5618>, <-6.7998, 99.5666, 23.8123>, <-4.4352, 97.6363, 22.4262> }
				triangle { <-4.4352, 97.6363, 22.4262>, <-6.7998, 99.5666, 23.8123>, <-4.4766, 97.638, 22.2804> }
				triangle { <-3.6047, 97.1495, 22.00242>, <-4.4352, 97.6363, 22.4262>, <-4.4766, 97.638, 22.2804> }
				triangle { <-3.6047, 97.1495, 22.00242>, <-4.4766, 97.638, 22.2804>, <-3.6371, 97.1459, 21.8788> }
				triangle { <-3.6047, 97.1495, 22.00242>, <-3.6371, 97.1459, 21.8788>, <-1.9756, 96.628, 21.2477> }
				triangle { <-7.9732, 100.7479, 24.4037>, <-6.7998, 99.5666, 23.8123>, <-6.6933, 99.6161, 23.9983> }
				triangle { <-4.4766, 97.638, 22.2804>, <-6.7998, 99.5666, 23.8123>, <-6.8815, 99.6706, 23.5713> }
				triangle { <-4.3726, 97.6276, 22.5618>, <-6.6933, 99.6161, 23.9983>, <-6.7998, 99.5666, 23.8123> }
				triangle { <-7.9732, 100.7479, 24.4037>, <-6.8815, 99.6706, 23.5713>, <-6.7998, 99.5666, 23.8123> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.3701, 95.8854, 20.672>, <-1.5067, 97.5104, 21.4089>, 0.09177 }
				cylinder { <-1.5067, 97.5104, 21.4089>, <-1.5645, 99.1143, 22.2005>, 0.09177 }
				cylinder { <-1.5645, 99.1143, 22.2005>, <-1.5433, 100.6922, 23.04444>, 0.09177 }
				cylinder { <-1.5433, 100.6922, 23.04444>, <-1.4434, 102.2393, 23.9382>, 0.09177 }
				cylinder { <-1.4434, 102.2393, 23.9382>, <-1.265, 103.7509, 24.8791>, 0.09177 }
				cylinder { <-1.265, 103.7509, 24.8791>, <-1.008675, 105.2226, 25.8644>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.008675, 105.2226, 25.8644>, <-0.9523, 105.383, 25.9543>, 0.002969 }
				cylinder { <-0.9523, 105.383, 25.9543>, <-0.8689, 105.5411, 26.02553>, 0.002969 }
				cylinder { <-0.8689, 105.5411, 26.02553>, <-0.7609, 105.692, 26.07593>, 0.002969 }
				cylinder { <-0.7609, 105.692, 26.07593>, <-0.6314, 105.8314, 26.104>, 0.002969 }
				cylinder { <-0.6314, 105.8314, 26.104>, <-0.4842, 105.9551, 26.1091>, 0.002969 }
				cylinder { <-0.4842, 105.9551, 26.1091>, <-0.3238, 106.0596, 26.09091>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.3238, 106.0596, 26.09091>, <1.08358, 107.2511, 25.9785>, <1.01382, 107.3559, 25.9305> }
				triangle { <1.08358, 107.2511, 25.9785>, <1.9245, 107.8781, 25.7596>, <1.01382, 107.3559, 25.9305> }
				triangle { <1.9245, 107.8781, 25.7596>, <1.8334, 107.9653, 25.6792>, <1.01382, 107.3559, 25.9305> }
				triangle { <1.9245, 107.8781, 25.7596>, <4.5751, 109.5563, 24.5882>, <1.8334, 107.9653, 25.6792> }
				triangle { <1.8334, 107.9653, 25.6792>, <4.5751, 109.5563, 24.5882>, <1.7244, 108.0359, 25.6008> }
				triangle { <1.01382, 107.3559, 25.9305>, <1.8334, 107.9653, 25.6792>, <1.7244, 108.0359, 25.6008> }
				triangle { <1.01382, 107.3559, 25.9305>, <1.7244, 108.0359, 25.6008>, <0.9183, 107.4141, 25.8686> }
				triangle { <1.01382, 107.3559, 25.9305>, <0.9183, 107.4141, 25.8686>, <-0.3238, 106.0596, 26.09091> }
				triangle { <5.9615, 110.323, 23.8059>, <4.5751, 109.5563, 24.5882>, <4.7234, 109.4049, 24.647> }
				triangle { <1.7244, 108.0359, 25.6008>, <4.5751, 109.5563, 24.5882>, <4.4469, 109.6659, 24.371> }
				triangle { <1.9245, 107.8781, 25.7596>, <4.7234, 109.4049, 24.647>, <4.5751, 109.5563, 24.5882> }
				triangle { <5.9615, 110.323, 23.8059>, <4.4469, 109.6659, 24.371>, <4.5751, 109.5563, 24.5882> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.008675, 105.2226, 25.8644>, <-0.6178, 106.6282, 26.9007>, 0.09177 }
				cylinder { <-0.6178, 106.6282, 26.9007>, <-0.09571, 107.9566, 27.9801>, 0.09177 }
				cylinder { <-0.09571, 107.9566, 27.9801>, <0.5534, 109.1974, 29.09427>, 0.09177 }
				cylinder { <0.5534, 109.1974, 29.09427>, <1.3245, 110.3407, 30.2347>, 0.09177 }
				cylinder { <1.3245, 110.3407, 30.2347>, <2.2113, 111.3774, 31.3928>, 0.09177 }
				cylinder { <2.2113, 111.3774, 31.3928>, <3.2066, 112.2993, 32.5598>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.2066, 112.2993, 32.5598>, <3.3022, 112.3991, 32.6935>, 0.002969 }
				cylinder { <3.3022, 112.3991, 32.6935>, <3.3858, 112.4991, 32.835>, 0.002969 }
				cylinder { <3.3858, 112.4991, 32.835>, <3.4571, 112.5987, 32.9833>, 0.002969 }
				cylinder { <3.4571, 112.5987, 32.9833>, <3.5157, 112.6973, 33.1376>, 0.002969 }
				cylinder { <3.5157, 112.6973, 33.1376>, <3.5611, 112.7946, 33.2972>, 0.002969 }
				cylinder { <3.5611, 112.7946, 33.2972>, <3.5932, 112.8898, 33.4612>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.5932, 112.8898, 33.4612>, <3.6708, 113.8653, 35.02822>, <3.5849, 113.9627, 34.9923> }
				triangle { <3.6708, 113.8653, 35.02822>, <3.8467, 114.5096, 35.8661>, <3.5849, 113.9627, 34.9923> }
				triangle { <3.8467, 114.5096, 35.8661>, <3.7759, 114.6186, 35.7921>, <3.5849, 113.9627, 34.9923> }
				triangle { <3.8467, 114.5096, 35.8661>, <4.8312, 116.7171, 38.184>, <3.7759, 114.6186, 35.7921> }
				triangle { <3.7759, 114.6186, 35.7921>, <4.8312, 116.7171, 38.184>, <3.7048, 114.7137, 35.6978> }
				triangle { <3.5849, 113.9627, 34.9923>, <3.7759, 114.6186, 35.7921>, <3.7048, 114.7137, 35.6978> }
				triangle { <3.5849, 113.9627, 34.9923>, <3.7048, 114.7137, 35.6978>, <3.5217, 114.0386, 34.9111> }
				triangle { <3.5849, 113.9627, 34.9923>, <3.5217, 114.0386, 34.9111>, <3.5932, 112.8898, 33.4612> }
				triangle { <5.5018, 117.9299, 39.28>, <4.8312, 116.7171, 38.184>, <4.9877, 116.5886, 38.2701> }
				triangle { <3.7048, 114.7137, 35.6978>, <4.8312, 116.7171, 38.184>, <4.7907, 116.9414, 38.03017> }
				triangle { <3.8467, 114.5096, 35.8661>, <4.9877, 116.5886, 38.2701>, <4.8312, 116.7171, 38.184> }
				triangle { <5.5018, 117.9299, 39.28>, <4.7907, 116.9414, 38.03017>, <4.8312, 116.7171, 38.184> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <3.2066, 112.2993, 32.5598>, <3.3173, 112.398, 32.6822>, 0.002969 }
				cylinder { <3.3173, 112.398, 32.6822>, <3.4315, 112.4964, 32.8017>, 0.002969 }
				cylinder { <3.4315, 112.4964, 32.8017>, <3.5493, 112.5942, 32.9181>, 0.002969 }
				cylinder { <3.5493, 112.5942, 32.9181>, <3.6706, 112.6915, 33.03133>, 0.002969 }
				cylinder { <3.6706, 112.6915, 33.03133>, <3.7952, 112.7882, 33.1413>, 0.002969 }
				cylinder { <3.7952, 112.7882, 33.1413>, <3.9232, 112.8843, 33.248>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.9232, 112.8843, 33.248>, <4.9661, 113.9301, 34.3579>, <4.896, 114.0444, 34.3449> }
				triangle { <4.9661, 113.9301, 34.3579>, <5.6626, 114.568, 34.8639>, <4.896, 114.0444, 34.3449> }
				triangle { <5.6626, 114.568, 34.8639>, <5.5888, 114.6858, 34.8087>, <4.896, 114.0444, 34.3449> }
				triangle { <5.6626, 114.568, 34.8639>, <8.09753, 116.5964, 35.9462>, <5.5888, 114.6858, 34.8087> }
				triangle { <5.5888, 114.6858, 34.8087>, <8.09753, 116.5964, 35.9462>, <5.5018, 114.7886, 34.739> }
				triangle { <4.896, 114.0444, 34.3449>, <5.5888, 114.6858, 34.8087>, <5.5018, 114.7886, 34.739> }
				triangle { <4.896, 114.0444, 34.3449>, <5.5018, 114.7886, 34.739>, <4.8182, 114.1277, 34.2871> }
				triangle { <4.896, 114.0444, 34.3449>, <4.8182, 114.1277, 34.2871>, <3.9232, 112.8843, 33.248> }
				triangle { <9.4568, 117.6585, 36.3286>, <8.09753, 116.5964, 35.9462>, <8.2456, 116.4367, 35.9771> }
				triangle { <5.5018, 114.7886, 34.739>, <8.09753, 116.5964, 35.9462>, <8.03358, 116.8086, 35.7835> }
				triangle { <5.6626, 114.568, 34.8639>, <8.2456, 116.4367, 35.9771>, <8.09753, 116.5964, 35.9462> }
				triangle { <9.4568, 117.6585, 36.3286>, <8.03358, 116.8086, 35.7835>, <8.09753, 116.5964, 35.9462> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 5.9432, 0.0>, 0.09177 }
			cylinder { <-0.0, 5.9432, 0.0>, <-0.0, 11.8864, 0.0>, 0.09177 }
			cylinder { <-0.0, 11.8864, 0.0>, <-0.0, 17.8297, 0.0>, 0.09177 }
			cylinder { <-0.0, 17.8297, 0.0>, <-0.0, 23.7729, 0.0>, 0.09177 }
			cylinder { <-0.0, 23.7729, 0.0>, <-0.00000001, 29.7161, 0.0>, 0.09177 }
			cylinder { <-0.00000001, 29.7161, 0.0>, <-0.00000001, 35.6594, 0.0>, 0.09177 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.00000001, 35.6594, 0.0>, <-0.08007, 37.4462, -0.05676>, 0.09177 }
				cylinder { <-0.08007, 37.4462, -0.05676>, <-0.2399, 39.2249, -0.1701>, 0.09177 }
				cylinder { <-0.2399, 39.2249, -0.1701>, <-0.4791, 40.9902, -0.3399>, 0.09177 }
				cylinder { <-0.4791, 40.9902, -0.3399>, <-0.7968, 42.7368, -0.5655>, 0.09177 }
				cylinder { <-0.7968, 42.7368, -0.5655>, <-1.192, 44.4594, -0.8464>, 0.09177 }
				cylinder { <-1.192, 44.4594, -0.8464>, <-1.6635, 46.1527, -1.1817>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.6635, 46.1527, -1.1817>, <-1.7419, 46.3273, -1.2014>, 0.002969 }
				cylinder { <-1.7419, 46.3273, -1.2014>, <-1.8456, 46.4893, -1.2041>, 0.002969 }
				cylinder { <-1.8456, 46.4893, -1.2041>, <-1.9716, 46.6339, -1.1897>, 0.002969 }
				cylinder { <-1.9716, 46.6339, -1.1897>, <-2.1162, 46.7569, -1.1587>, 0.002969 }
				cylinder { <-2.1162, 46.7569, -1.1587>, <-2.2751, 46.8546, -1.1121>, 0.002969 }
				cylinder { <-2.2751, 46.8546, -1.1121>, <-2.4437, 46.9242, -1.05109>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.4437, 46.9242, -1.05109>, <-3.7416, 48.01904, -0.3231>, <-3.6629, 48.08239, -0.234> }
				triangle { <-3.7416, 48.01904, -0.3231>, <-4.5242, 48.5262, 0.2045>, <-3.6629, 48.08239, -0.234> }
				triangle { <-4.5242, 48.5262, 0.2045>, <-4.4258, 48.557, 0.3128>, <-3.6629, 48.08239, -0.234> }
				triangle { <-4.5242, 48.5262, 0.2045>, <-7.01637, 49.6335, 2.1482>, <-4.4258, 48.557, 0.3128> }
				triangle { <-4.4258, 48.557, 0.3128>, <-7.01637, 49.6335, 2.1482>, <-4.311, 48.5729, 0.4105> }
				triangle { <-3.6629, 48.08239, -0.234>, <-4.4258, 48.557, 0.3128>, <-4.311, 48.5729, 0.4105> }
				triangle { <-3.6629, 48.08239, -0.234>, <-4.311, 48.5729, 0.4105>, <-3.5626, 48.0964, -0.156> }
				triangle { <-3.6629, 48.08239, -0.234>, <-3.5626, 48.0964, -0.156>, <-2.4437, 46.9242, -1.05109> }
				triangle { <-8.3292, 50.03435, 3.2607>, <-7.01637, 49.6335, 2.1482>, <-7.1774, 49.5406, 2.03076> }
				triangle { <-4.311, 48.5729, 0.4105>, <-7.01637, 49.6335, 2.1482>, <-6.8787, 49.6156, 2.3856> }
				triangle { <-4.5242, 48.5262, 0.2045>, <-7.1774, 49.5406, 2.03076>, <-7.01637, 49.6335, 2.1482> }
				triangle { <-8.3292, 50.03435, 3.2607>, <-6.8787, 49.6156, 2.3856>, <-7.01637, 49.6335, 2.1482> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.6635, 46.1527, -1.1817>, <-2.1538, 47.8329, -1.5545>, 0.09177 }
				cylinder { <-2.1538, 47.8329, -1.5545>, <-2.6625, 49.4989, -1.9646>, 0.09177 }
				cylinder { <-2.6625, 49.4989, -1.9646>, <-3.1892, 51.1496, -2.4117>, 0.09177 }
				cylinder { <-3.1892, 51.1496, -2.4117>, <-3.7337, 52.7842, -2.8955>, 0.09177 }
				cylinder { <-3.7337, 52.7842, -2.8955>, <-4.2957, 54.4015, -3.4158>, 0.09177 }
				cylinder { <-4.2957, 54.4015, -3.4158>, <-4.8748, 56.00076, -3.9722>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.8748, 56.00076, -3.9722>, <-4.9163, 56.1747, -4.04298>, 0.002969 }
				cylinder { <-4.9163, 56.1747, -4.04298>, <-4.9363, 56.3482, -4.1235>, 0.002969 }
				cylinder { <-4.9363, 56.3482, -4.1235>, <-4.9345, 56.5186, -4.2127>, 0.002969 }
				cylinder { <-4.9345, 56.5186, -4.2127>, <-4.9111, 56.6834, -4.3091>, 0.002969 }
				cylinder { <-4.9111, 56.6834, -4.3091>, <-4.8663, 56.84, -4.4114>, 0.002969 }
				cylinder { <-4.8663, 56.84, -4.4114>, <-4.8008, 56.9861, -4.518>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.8008, 56.9861, -4.518>, <-3.7183, 58.2972, -5.2406>, <-3.6432, 58.32, -5.1311> }
				triangle { <-3.7183, 58.2972, -5.2406>, <-3.21, 59.1652, -5.6098>, <-3.6432, 58.32, -5.1311> }
				triangle { <-3.21, 59.1652, -5.6098>, <-3.1644, 59.193, -5.4701>, <-3.6432, 58.32, -5.1311> }
				triangle { <-3.21, 59.1652, -5.6098>, <-2.07299, 62.1611, -6.5825>, <-3.1644, 59.193, -5.4701> }
				triangle { <-3.1644, 59.193, -5.4701>, <-2.07299, 62.1611, -6.5825>, <-3.1338, 59.2033, -5.3219> }
				triangle { <-3.6432, 58.32, -5.1311>, <-3.1644, 59.193, -5.4701>, <-3.1338, 59.2033, -5.3219> }
				triangle { <-3.6432, 58.32, -5.1311>, <-3.1338, 59.2033, -5.3219>, <-3.617, 58.323, -5.006135> }
				triangle { <-3.6432, 58.32, -5.1311>, <-3.617, 58.323, -5.006135>, <-4.8008, 56.9861, -4.518> }
				triangle { <-1.6478, 63.8179, -7.02577>, <-2.07299, 62.1611, -6.5825>, <-2.1845, 62.1653, -6.7721> }
				triangle { <-3.1338, 59.2033, -5.3219>, <-2.07299, 62.1611, -6.5825>, <-2.0625, 62.2717, -6.331> }
				triangle { <-3.21, 59.1652, -5.6098>, <-2.1845, 62.1653, -6.7721>, <-2.07299, 62.1611, -6.5825> }
				triangle { <-1.6478, 63.8179, -7.02577>, <-2.0625, 62.2717, -6.331>, <-2.07299, 62.1611, -6.5825> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.8748, 56.00076, -3.9722>, <-5.5248, 57.5538, -4.5786>, 0.09177 }
				cylinder { <-5.5248, 57.5538, -4.5786>, <-6.2438, 59.05625, -5.2331>, 0.09177 }
				cylinder { <-6.2438, 59.05625, -5.2331>, <-7.02941, 60.5033, -5.9338>, 0.09177 }
				cylinder { <-7.02941, 60.5033, -5.9338>, <-7.8793, 61.8908, -6.6787>, 0.09177 }
				cylinder { <-7.8793, 61.8908, -6.6787>, <-8.7909, 63.2145, -7.4656>, 0.09177 }
				cylinder { <-8.7909, 63.2145, -7.4656>, <-9.7615, 64.4703, -8.2921>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-9.7615, 64.4703, -8.2921>, <-9.8906, 64.5946, -8.362>, 0.002969 }
				cylinder { <-9.8906, 64.5946, -8.362>, <-10.04074, 64.7045, -8.4109>, 0.002969 }
				cylinder { <-10.04074, 64.7045, -8.4109>, <-10.2074, 64.7967, -8.4373>, 0.002969 }
				cylinder { <-10.2074, 64.7967, -8.4373>, <-10.3857, 64.8687, -8.4405>, 0.002969 }
				cylinder { <-10.3857, 64.8687, -8.4405>, <-10.5705, 64.9181, -8.4203>, 0.002969 }
				cylinder { <-10.5705, 64.9181, -8.4203>, <-10.7562, 64.9437, -8.3774>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.7562, 64.9437, -8.3774>, <-12.3843, 65.719, -7.9758>, <-12.3365, 65.8287, -7.9139> }
				triangle { <-12.3843, 65.719, -7.9758>, <-13.3225, 66.07693, -7.6018>, <-12.3365, 65.8287, -7.9139> }
				triangle { <-13.3225, 66.07693, -7.6018>, <-13.2468, 66.1699, -7.5123>, <-12.3365, 65.8287, -7.9139> }
				triangle { <-13.3225, 66.07693, -7.6018>, <-16.1633, 66.8437, -6.002863>, <-13.2468, 66.1699, -7.5123> }
				triangle { <-13.2468, 66.1699, -7.5123>, <-16.1633, 66.8437, -6.002863>, <-13.1501, 66.2518, -7.429> }
				triangle { <-12.3365, 65.8287, -7.9139>, <-13.2468, 66.1699, -7.5123>, <-13.1501, 66.2518, -7.429> }
				triangle { <-12.3365, 65.8287, -7.9139>, <-13.1501, 66.2518, -7.429>, <-12.2516, 65.898, -7.8482> }
				triangle { <-12.3365, 65.8287, -7.9139>, <-12.2516, 65.898, -7.8482>, <-10.7562, 64.9437, -8.3774> }
				triangle { <-17.6067, 67.1115, -5.01966>, <-16.1633, 66.8437, -6.002863>, <-16.2774, 66.6717, -6.0792> }
				triangle { <-13.1501, 66.2518, -7.429>, <-16.1633, 66.8437, -6.002863>, <-16.04356, 66.9455, -5.7772> }
				triangle { <-13.3225, 66.07693, -7.6018>, <-16.2774, 66.6717, -6.0792>, <-16.1633, 66.8437, -6.002863> }
				triangle { <-17.6067, 67.1115, -5.01966>, <-16.04356, 66.9455, -5.7772>, <-16.1633, 66.8437, -6.002863> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-9.7615, 64.4703, -8.2921>, <-10.6372, 65.8045, -9.1018>, 0.09177 }
				cylinder { <-10.6372, 65.8045, -9.1018>, <-11.4138, 67.2106, -9.8904>, 0.09177 }
				cylinder { <-11.4138, 67.2106, -9.8904>, <-12.08778, 68.6819, -10.6542>, 0.09177 }
				cylinder { <-12.08778, 68.6819, -10.6542>, <-12.6558, 70.2114, -11.3894>, 0.09177 }
				cylinder { <-12.6558, 70.2114, -11.3894>, <-13.1152, 71.7917, -12.09218>, 0.09177 }
				cylinder { <-13.1152, 71.7917, -12.09218>, <-13.4639, 73.4153, -12.759>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-13.4639, 73.4153, -12.759>, <-13.4664, 73.5875, -12.8446>, 0.002969 }
				cylinder { <-13.4664, 73.5875, -12.8446>, <-13.4338, 73.7509, -12.9407>, 0.002969 }
				cylinder { <-13.4338, 73.7509, -12.9407>, <-13.3674, 73.8991, -13.04381>, 0.002969 }
				cylinder { <-13.3674, 73.8991, -13.04381>, <-13.2697, 74.02649, -13.1497>, 0.002969 }
				cylinder { <-13.2697, 74.02649, -13.1497>, <-13.1445, 74.1281, -13.2545>, 0.002969 }
				cylinder { <-13.1445, 74.1281, -13.2545>, <-12.9966, 74.2, -13.3542>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-12.9966, 74.2, -13.3542>, <-11.2959, 74.6986, -13.876>, <-11.2442, 74.7152, -13.7528> }
				triangle { <-11.2959, 74.6986, -13.876>, <-10.3711, 75.1444, -14.1826>, <-11.2442, 74.7152, -13.7528> }
				triangle { <-10.3711, 75.1444, -14.1826>, <-10.3485, 75.1858, -14.04059>, <-11.2442, 74.7152, -13.7528> }
				triangle { <-10.3711, 75.1444, -14.1826>, <-7.77, 77.02084, -15.1462>, <-10.3485, 75.1858, -14.04059> }
				triangle { <-10.3485, 75.1858, -14.04059>, <-7.77, 77.02084, -15.1462>, <-10.3488, 75.2202, -13.8929> }
				triangle { <-11.2442, 74.7152, -13.7528>, <-10.3485, 75.1858, -14.04059>, <-10.3488, 75.2202, -13.8929> }
				triangle { <-11.2442, 74.7152, -13.7528>, <-10.3488, 75.2202, -13.8929>, <-11.2468, 74.7392, -13.6273> }
				triangle { <-11.2442, 74.7152, -13.7528>, <-11.2468, 74.7392, -13.6273>, <-12.9966, 74.2, -13.3542> }
				triangle { <-6.5256, 78.1685, -15.6524>, <-7.77, 77.02084, -15.1462>, <-7.8231, 77.02221, -15.3597> }
				triangle { <-10.3488, 75.2202, -13.8929>, <-7.77, 77.02084, -15.1462>, <-7.7617, 77.1777, -14.9205> }
				triangle { <-10.3711, 75.1444, -14.1826>, <-7.8231, 77.02221, -15.3597>, <-7.77, 77.02084, -15.1462> }
				triangle { <-6.5256, 78.1685, -15.6524>, <-7.7617, 77.1777, -14.9205>, <-7.77, 77.02084, -15.1462> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-13.4639, 73.4153, -12.759>, <-13.6598, 75.07321, -13.4035>, 0.09177 }
				cylinder { <-13.6598, 75.07321, -13.4035>, <-13.7013, 76.7525, -14.02034>, 0.09177 }
				cylinder { <-13.7013, 76.7525, -14.02034>, <-13.5882, 78.4403, -14.6043>, 0.09177 }
				cylinder { <-13.5882, 78.4403, -14.6043>, <-13.3215, 80.1233, -15.1506>, 0.09177 }
				cylinder { <-13.3215, 80.1233, -15.1506>, <-12.9033, 81.7887, -15.6547>, 0.09177 }
				cylinder { <-12.9033, 81.7887, -15.6547>, <-12.3369, 83.4233, -16.1125>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-12.3369, 83.4233, -16.1125>, <-12.2844, 83.6023, -16.1593>, 0.002969 }
				cylinder { <-12.2844, 83.6023, -16.1593>, <-12.2406, 83.7843, -16.2034>, 0.002969 }
				cylinder { <-12.2406, 83.7843, -16.2034>, <-12.2055, 83.9688, -16.2449>, 0.002969 }
				cylinder { <-12.2055, 83.9688, -16.2449>, <-12.1792, 84.1554, -16.2836>, 0.002969 }
				cylinder { <-12.1792, 84.1554, -16.2836>, <-12.1617, 84.3435, -16.3194>, 0.002969 }
				cylinder { <-12.1617, 84.3435, -16.3194>, <-12.1531, 84.5328, -16.3523>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-12.1531, 84.5328, -16.3523>, <-11.5808, 86.288, -16.4211>, <-11.5044, 86.2857, -16.3101> }
				triangle { <-11.5808, 86.288, -16.4211>, <-11.3884, 87.3411, -16.3738>, <-11.5044, 86.2857, -16.3101> }
				triangle { <-11.3884, 87.3411, -16.3738>, <-11.3385, 87.3216, -16.2341>, <-11.5044, 86.2857, -16.3101> }
				triangle { <-11.3884, 87.3411, -16.3738>, <-11.2803, 90.6619, -15.9551>, <-11.3385, 87.3216, -16.2341> }
				triangle { <-11.3385, 87.3216, -16.2341>, <-11.2803, 90.6619, -15.9551>, <-11.2968, 87.279, -16.09471> }
				triangle { <-11.5044, 86.2857, -16.3101>, <-11.3385, 87.3216, -16.2341>, <-11.2968, 87.279, -16.09471> }
				triangle { <-11.5044, 86.2857, -16.3101>, <-11.2968, 87.279, -16.09471>, <-11.4672, 86.245, -16.1948> }
				triangle { <-11.5044, 86.2857, -16.3101>, <-11.4672, 86.245, -16.1948>, <-12.1531, 84.5328, -16.3523> }
				triangle { <-11.4042, 92.3967, -15.6438>, <-11.2803, 90.6619, -15.9551>, <-11.4075, 90.709, -16.1283> }
				triangle { <-11.2968, 87.279, -16.09471>, <-11.2803, 90.6619, -15.9551>, <-11.276, 90.6568, -15.6802> }
				triangle { <-11.3884, 87.3411, -16.3738>, <-11.4075, 90.709, -16.1283>, <-11.2803, 90.6619, -15.9551> }
				triangle { <-11.4042, 92.3967, -15.6438>, <-11.276, 90.6568, -15.6802>, <-11.2803, 90.6619, -15.9551> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-12.3369, 83.4233, -16.1125>, <-11.7704, 85.05792, -16.5703>, 0.09177 }
				cylinder { <-11.7704, 85.05792, -16.5703>, <-11.204, 86.6925, -17.02811>, 0.09177 }
				cylinder { <-11.204, 86.6925, -17.02811>, <-10.6376, 88.3271, -17.4858>, 0.09177 }
				cylinder { <-10.6376, 88.3271, -17.4858>, <-10.07128, 89.9617, -17.9436>, 0.09177 }
				cylinder { <-10.07128, 89.9617, -17.9436>, <-9.5048, 91.5963, -18.4014>, 0.09177 }
				cylinder { <-9.5048, 91.5963, -18.4014>, <-8.9384, 93.2309, -18.8592>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-8.9384, 93.2309, -18.8592>, <-8.8531, 93.394, -18.915>, 0.002969 }
				cylinder { <-8.8531, 93.394, -18.915>, <-8.7452, 93.541, -18.9763>, 0.002969 }
				cylinder { <-8.7452, 93.541, -18.9763>, <-8.617, 93.6686, -19.04176>, 0.002969 }
				cylinder { <-8.617, 93.6686, -19.04176>, <-8.4713, 93.7741, -19.1098>, 0.002969 }
				cylinder { <-8.4713, 93.7741, -19.1098>, <-8.3113, 93.8553, -19.1791>, 0.002969 }
				cylinder { <-8.3113, 93.8553, -19.1791>, <-8.1405, 93.9103, -19.2482>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.1405, 93.9103, -19.2482>, <-6.3219, 94.1026, -19.5109>, <-6.2837, 94.08144, -19.3835> }
				triangle { <-6.3219, 94.1026, -19.5109>, <-5.2941, 94.3781, -19.6363>, <-6.2837, 94.08144, -19.3835> }
				triangle { <-5.2941, 94.3781, -19.6363>, <-5.2814, 94.3832, -19.4873>, <-6.2837, 94.08144, -19.3835> }
				triangle { <-5.2941, 94.3781, -19.6363>, <-2.2622, 95.7661, -19.9461>, <-5.2814, 94.3832, -19.4873> }
				triangle { <-5.2814, 94.3832, -19.4873>, <-2.2622, 95.7661, -19.9461>, <-5.2931, 94.3859, -19.3361> }
				triangle { <-6.2837, 94.08144, -19.3835>, <-5.2814, 94.3832, -19.4873>, <-5.2931, 94.3859, -19.3361> }
				triangle { <-6.2837, 94.08144, -19.3835>, <-5.2931, 94.3859, -19.3361>, <-6.297, 94.07923, -19.2564> }
				triangle { <-6.2837, 94.08144, -19.3835>, <-6.297, 94.07923, -19.2564>, <-8.1405, 93.9103, -19.2482> }
				triangle { <-0.7545, 96.6774, -20.08147>, <-2.2622, 95.7661, -19.9461>, <-2.2868, 95.8232, -20.1571> }
				triangle { <-5.2931, 94.3859, -19.3361>, <-2.2622, 95.7661, -19.9461>, <-2.25, 95.8675, -19.6908> }
				triangle { <-5.2941, 94.3781, -19.6363>, <-2.2868, 95.8232, -20.1571>, <-2.2622, 95.7661, -19.9461> }
				triangle { <-0.7545, 96.6774, -20.08147>, <-2.25, 95.8675, -19.6908>, <-2.2622, 95.7661, -19.9461> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-8.9384, 93.2309, -18.8592>, <-8.2664, 94.8412, -19.2563>, 0.09177 }
				cylinder { <-8.2664, 94.8412, -19.2563>, <-7.4922, 96.4195, -19.5907>, 0.09177 }
				cylinder { <-7.4922, 96.4195, -19.5907>, <-6.6194, 97.9583, -19.8606>, 0.09177 }
				cylinder { <-6.6194, 97.9583, -19.8606>, <-5.6524, 99.4501, -20.0647>, 0.09177 }
				cylinder { <-5.6524, 99.4501, -20.0647>, <-4.5958, 100.888, -20.2017>, 0.09177 }
				cylinder { <-4.5958, 100.888, -20.2017>, <-3.4549, 102.2649, -20.2711>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.4549, 102.2649, -20.2711>, <-3.3432, 102.4214, -20.2756>, 0.002969 }
				cylinder { <-3.3432, 102.4214, -20.2756>, <-3.2431, 102.5856, -20.2772>, 0.002969 }
				cylinder { <-3.2431, 102.5856, -20.2772>, <-3.155, 102.7566, -20.2759>, 0.002969 }
				cylinder { <-3.155, 102.7566, -20.2759>, <-3.07949, 102.9334, -20.2717>, 0.002969 }
				cylinder { <-3.07949, 102.9334, -20.2717>, <-3.01692, 103.1151, -20.2646>, 0.002969 }
				cylinder { <-3.01692, 103.1151, -20.2646>, <-2.9676, 103.3008, -20.2546>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.9676, 103.3008, -20.2546>, <-2.07632, 104.8718, -19.8668>, <-2.02261, 104.8328, -19.7496> }
				triangle { <-2.07632, 104.8718, -19.8668>, <-1.7032, 105.8311, -19.5689>, <-2.02261, 104.8328, -19.7496> }
				triangle { <-1.7032, 105.8311, -19.5689>, <-1.6833, 105.7761, -19.4312>, <-2.02261, 104.8328, -19.7496> }
				triangle { <-1.7032, 105.8311, -19.5689>, <-1.05605, 108.9155, -18.4366>, <-1.6833, 105.7761, -19.4312> }
				triangle { <-1.6833, 105.7761, -19.4312>, <-1.05605, 108.9155, -18.4366>, <-1.6755, 105.7008, -19.2998> }
				triangle { <-2.02261, 104.8328, -19.7496>, <-1.6833, 105.7761, -19.4312>, <-1.6755, 105.7008, -19.2998> }
				triangle { <-2.02261, 104.8328, -19.7496>, <-1.6755, 105.7008, -19.2998>, <-2.01458, 104.7647, -19.6417> }
				triangle { <-2.02261, 104.8328, -19.7496>, <-2.01458, 104.7647, -19.6417>, <-2.9676, 103.3008, -20.2546> }
				triangle { <-0.9086, 110.5493, -17.7799>, <-1.05605, 108.9155, -18.4366>, <-1.1396, 109.0199, -18.6113> }
				triangle { <-1.6755, 105.7008, -19.2998>, <-1.05605, 108.9155, -18.4366>, <-1.1014, 108.8596, -18.1713> }
				triangle { <-1.7032, 105.8311, -19.5689>, <-1.1396, 109.0199, -18.6113>, <-1.05605, 108.9155, -18.4366> }
				triangle { <-0.9086, 110.5493, -17.7799>, <-1.1014, 108.8596, -18.1713>, <-1.05605, 108.9155, -18.4366> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.4549, 102.2649, -20.2711>, <-2.2815, 103.6137, -20.3493>, 0.09177 }
				cylinder { <-2.2815, 103.6137, -20.3493>, <-1.07623, 104.9335, -20.4364>, 0.09177 }
				cylinder { <-1.07623, 104.9335, -20.4364>, <0.1601, 106.2237, -20.5323>, 0.09177 }
				cylinder { <0.1601, 106.2237, -20.5323>, <1.4269, 107.4833, -20.637>, 0.09177 }
				cylinder { <1.4269, 107.4833, -20.637>, <2.7232, 108.7117, -20.7504>, 0.09177 }
				cylinder { <2.7232, 108.7117, -20.7504>, <4.04847, 109.9081, -20.8723>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.04847, 109.9081, -20.8723>, <4.2076, 110.0145, -20.8908>, 0.002969 }
				cylinder { <4.2076, 110.0145, -20.8908>, <4.38, 110.0964, -20.9143>, 0.002969 }
				cylinder { <4.38, 110.0964, -20.9143>, <4.562, 110.152, -20.9422>, 0.002969 }
				cylinder { <4.562, 110.152, -20.9422>, <4.7496, 110.1802, -20.974>, 0.002969 }
				cylinder { <4.7496, 110.1802, -20.974>, <4.9387, 110.1803, -21.00906>, 0.002969 }
				cylinder { <4.9387, 110.1803, -21.00906>, <5.1253, 110.1524, -21.04646>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.1253, 110.1524, -21.04646>, <6.8435, 109.4737, -21.04325>, <6.8435, 109.427, -20.9168> }
				triangle { <6.8435, 109.4737, -21.04325>, <7.8867, 109.2343, -20.9927>, <6.8435, 109.427, -20.9168> }
				triangle { <7.8867, 109.2343, -20.9927>, <7.8725, 109.2212, -20.8443>, <6.8435, 109.427, -20.9168> }
				triangle { <7.8867, 109.2343, -20.9927>, <11.2159, 109.0274, -20.6954>, <7.8725, 109.2212, -20.8443> }
				triangle { <7.8725, 109.2212, -20.8443>, <11.2159, 109.0274, -20.6954>, <7.8355, 109.2174, -20.6974> }
				triangle { <6.8435, 109.427, -20.9168>, <7.8725, 109.2212, -20.8443>, <7.8355, 109.2174, -20.6974> }
				triangle { <6.8435, 109.427, -20.9168>, <7.8355, 109.2174, -20.6974>, <6.8073, 109.4216, -20.7944> }
				triangle { <6.8435, 109.427, -20.9168>, <6.8073, 109.4216, -20.7944>, <5.1253, 110.1524, -21.04646> }
				triangle { <12.9692, 109.1165, -20.4949>, <11.2159, 109.0274, -20.6954>, <11.2598, 109.1054, -20.8964> }
				triangle { <7.8355, 109.2174, -20.6974>, <11.2159, 109.0274, -20.6954>, <11.2256, 109.0906, -20.428> }
				triangle { <7.8867, 109.2343, -20.9927>, <11.2598, 109.1054, -20.8964>, <11.2159, 109.0274, -20.6954> }
				triangle { <12.9692, 109.1165, -20.4949>, <11.2256, 109.0906, -20.428>, <11.2159, 109.0274, -20.6954> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <4.04847, 109.9081, -20.8723>, <4.1846, 110.0435, -20.8836>, 0.002969 }
				cylinder { <4.1846, 110.0435, -20.8836>, <4.3141, 110.1853, -20.893>, 0.002969 }
				cylinder { <4.3141, 110.1853, -20.893>, <4.4367, 110.3333, -20.9004>, 0.002969 }
				cylinder { <4.4367, 110.3333, -20.9004>, <4.5521, 110.4871, -20.9059>, 0.002969 }
				cylinder { <4.5521, 110.4871, -20.9059>, <4.6601, 110.6462, -20.9095>, 0.002969 }
				cylinder { <4.6601, 110.6462, -20.9095>, <4.7602, 110.8104, -20.9111>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.7602, 110.8104, -20.9111>, <6.07369, 112.0794, -20.6325>, <6.1184, 112.0324, -20.5145> }
				triangle { <6.07369, 112.0794, -20.6325>, <6.7138, 112.9059, -20.3977>, <6.1184, 112.0324, -20.5145> }
				triangle { <6.7138, 112.9059, -20.3977>, <6.7225, 112.8543, -20.2576>, <6.1184, 112.0324, -20.5145> }
				triangle { <6.7138, 112.9059, -20.3977>, <8.2493, 115.7293, -19.4567>, <6.7225, 112.8543, -20.2576> }
				triangle { <6.7225, 112.8543, -20.2576>, <8.2493, 115.7293, -19.4567>, <6.7134, 112.7863, -20.1224> }
				triangle { <6.1184, 112.0324, -20.5145>, <6.7225, 112.8543, -20.2576>, <6.7134, 112.7863, -20.1224> }
				triangle { <6.1184, 112.0324, -20.5145>, <6.7134, 112.7863, -20.1224>, <6.1108, 111.9701, -20.4031> }
				triangle { <6.1184, 112.0324, -20.5145>, <6.1108, 111.9701, -20.4031>, <4.7602, 110.8104, -20.9111> }
				triangle { <8.8775, 117.2831, -18.8971>, <8.2493, 115.7293, -19.4567>, <8.1924, 115.8446, -19.6351> }
				triangle { <6.7134, 112.7863, -20.1224>, <8.2493, 115.7293, -19.4567>, <8.1998, 115.7015, -19.1876> }
				triangle { <6.7138, 112.9059, -20.3977>, <8.1924, 115.8446, -19.6351>, <8.2493, 115.7293, -19.4567> }
				triangle { <8.8775, 117.2831, -18.8971>, <8.1998, 115.7015, -19.1876>, <8.2493, 115.7293, -19.4567> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.004471, 3.7124, 0.09102>, 0.05734 }
			cylinder { <-0.004471, 3.7124, 0.09102>, <-0.01341, 7.4216, 0.273>, 0.05734 }
			cylinder { <-0.01341, 7.4216, 0.273>, <-0.02681, 11.1251, 0.5458>, 0.05734 }
			cylinder { <-0.02681, 11.1251, 0.5458>, <-0.04467, 14.8209, 0.9094>, 0.05734 }
			cylinder { <-0.04467, 14.8209, 0.9094>, <-0.06698, 18.5066, 1.3634>, 0.05734 }
			cylinder { <-0.06698, 18.5066, 1.3634>, <-0.09372, 22.18, 1.9077>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.09372, 22.18, 1.9077>, <-0.1796, 23.2921, 1.9854>, 0.05734 }
				cylinder { <-0.1796, 23.2921, 1.9854>, <-0.3423, 24.3984, 1.9758>, 0.05734 }
				cylinder { <-0.3423, 24.3984, 1.9758>, <-0.5797, 25.4867, 1.879>, 0.05734 }
				cylinder { <-0.5797, 25.4867, 1.879>, <-0.8891, 26.5455, 1.6956>, 0.05734 }
				cylinder { <-0.8891, 26.5455, 1.6956>, <-1.2668, 27.5632, 1.4275>, 0.05734 }
				cylinder { <-1.2668, 27.5632, 1.4275>, <-1.7085, 28.5289, 1.07743>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.7085, 28.5289, 1.07743>, <-1.7509, 28.5863, 1.05397>, 0.001159 }
				cylinder { <-1.7509, 28.5863, 1.05397>, <-1.8043, 28.634, 1.03146>, 0.001159 }
				cylinder { <-1.8043, 28.634, 1.03146>, <-1.8668, 28.6703, 1.01077>, 0.001159 }
				cylinder { <-1.8668, 28.6703, 1.01077>, <-1.9358, 28.6936, 0.9926>, 0.001159 }
				cylinder { <-1.9358, 28.6936, 0.9926>, <-2.008862, 28.7032, 0.9779>, 0.001159 }
				cylinder { <-2.008862, 28.7032, 0.9779>, <-2.08301, 28.6986, 0.967>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.08301, 28.6986, 0.967>, <-3.1824, 29.02457, 1.09977>, <-3.1744, 29.05887, 1.1762> }
				triangle { <-3.1824, 29.02457, 1.09977>, <-3.8352, 29.1172, 1.2161>, <-3.1744, 29.05887, 1.1762> }
				triangle { <-3.8352, 29.1172, 1.2161>, <-3.8144, 29.1324, 1.306>, <-3.1744, 29.05887, 1.1762> }
				triangle { <-3.8352, 29.1172, 1.2161>, <-5.8727, 29.07298, 1.6906>, <-3.8144, 29.1324, 1.306> }
				triangle { <-3.8144, 29.1324, 1.306>, <-5.8727, 29.07298, 1.6906>, <-3.7793, 29.143, 1.3934> }
				triangle { <-3.1744, 29.05887, 1.1762>, <-3.8144, 29.1324, 1.306>, <-3.7793, 29.143, 1.3934> }
				triangle { <-3.1744, 29.05887, 1.1762>, <-3.7793, 29.143, 1.3934>, <-3.1419, 29.0694, 1.2484> }
				triangle { <-3.1744, 29.05887, 1.1762>, <-3.1419, 29.0694, 1.2484>, <-2.08301, 28.6986, 0.967> }
				triangle { <-6.9298, 28.9285, 1.9743>, <-5.8727, 29.07298, 1.6906>, <-5.9122, 29.01363, 1.573> }
				triangle { <-3.7793, 29.143, 1.3934>, <-5.8727, 29.07298, 1.6906>, <-5.8518, 29.04449, 1.8587> }
				triangle { <-3.8352, 29.1172, 1.2161>, <-5.9122, 29.01363, 1.573>, <-5.8727, 29.07298, 1.6906> }
				triangle { <-6.9298, 28.9285, 1.9743>, <-5.8518, 29.04449, 1.8587>, <-5.8727, 29.07298, 1.6906> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.7085, 28.5289, 1.07743>, <-2.1082, 29.5305, 0.7817>, 0.05734 }
				cylinder { <-2.1082, 29.5305, 0.7817>, <-2.4639, 30.5631, 0.5419>, 0.05734 }
				cylinder { <-2.4639, 30.5631, 0.5419>, <-2.774, 31.6218, 0.3593>, 0.05734 }
				cylinder { <-2.774, 31.6218, 0.3593>, <-3.03715, 32.7014, 0.2347>, 0.05734 }
				cylinder { <-3.03715, 32.7014, 0.2347>, <-3.252, 33.7967, 0.1689>, 0.05734 }
				cylinder { <-3.252, 33.7967, 0.1689>, <-3.4177, 34.9025, 0.1621>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.4177, 34.9025, 0.1621>, <-3.4142, 34.9775, 0.1629>, 0.001159 }
				cylinder { <-3.4142, 34.9775, 0.1629>, <-3.3962, 35.05044, 0.1648>, 0.001159 }
				cylinder { <-3.3962, 35.05044, 0.1648>, <-3.3643, 35.1183, 0.1679>, 0.001159 }
				cylinder { <-3.3643, 35.1183, 0.1679>, <-3.3198, 35.1787, 0.1719>, 0.001159 }
				cylinder { <-3.3198, 35.1787, 0.1719>, <-3.2645, 35.2292, 0.1768>, 0.001159 }
				cylinder { <-3.2645, 35.2292, 0.1768>, <-3.2004, 35.2679, 0.1823>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.2004, 35.2679, 0.1823>, <-2.1863, 35.5509, 0.6558>, <-2.2051, 35.5297, 0.735> }
				triangle { <-2.1863, 35.5509, 0.6558>, <-1.6394, 35.8111, 0.9412>, <-2.2051, 35.5297, 0.735> }
				triangle { <-1.6394, 35.8111, 0.9412>, <-1.6815, 35.8022, 1.02419>, <-2.2051, 35.5297, 0.735> }
				triangle { <-1.6394, 35.8111, 0.9412>, <-0.1105, 36.9267, 1.8336>, <-1.6815, 35.8022, 1.02419> }
				triangle { <-1.6815, 35.8022, 1.02419>, <-0.1105, 36.9267, 1.8336>, <-1.7367, 35.7896, 1.1001> }
				triangle { <-2.2051, 35.5297, 0.735>, <-1.6815, 35.8022, 1.02419>, <-1.7367, 35.7896, 1.1001> }
				triangle { <-2.2051, 35.5297, 0.735>, <-1.7367, 35.7896, 1.1001>, <-2.2528, 35.5161, 0.7976> }
				triangle { <-2.2051, 35.5297, 0.735>, <-2.2528, 35.5161, 0.7976>, <-3.2004, 35.2679, 0.1823> }
				triangle { <0.6188, 37.6155, 2.2947>, <-0.1105, 36.9267, 1.8336>, <-0.06165, 36.9784, 1.716> }
				triangle { <-1.7367, 35.7896, 1.1001>, <-0.1105, 36.9267, 1.8336>, <-0.198, 36.9675, 1.9758> }
				triangle { <-1.6394, 35.8111, 0.9412>, <-0.06165, 36.9784, 1.716>, <-0.1105, 36.9267, 1.8336> }
				triangle { <0.6188, 37.6155, 2.2947>, <-0.198, 36.9675, 1.9758>, <-0.1105, 36.9267, 1.8336> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.4177, 34.9025, 0.1621>, <-3.5586, 36.01159, 0.185>, 0.05734 }
				cylinder { <-3.5586, 36.01159, 0.185>, <-3.6744, 37.1225, 0.2374>, 0.05734 }
				cylinder { <-3.6744, 37.1225, 0.2374>, <-3.765, 38.2339, 0.3194>, 0.05734 }
				cylinder { <-3.765, 38.2339, 0.3194>, <-3.8303, 39.3446, 0.4308>, 0.05734 }
				cylinder { <-3.8303, 39.3446, 0.4308>, <-3.8703, 40.4532, 0.5715>, 0.05734 }
				cylinder { <-3.8703, 40.4532, 0.5715>, <-3.8849, 41.5583, 0.7414>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.8849, 41.5583, 0.7414>, <-3.8933, 41.6321, 0.7522>, 0.001159 }
				cylinder { <-3.8933, 41.6321, 0.7522>, <-3.9088, 41.7049, 0.7624>, 0.001159 }
				cylinder { <-3.9088, 41.7049, 0.7624>, <-3.9315, 41.7758, 0.7717>, 0.001159 }
				cylinder { <-3.9315, 41.7758, 0.7717>, <-3.9611, 41.8444, 0.7801>, 0.001159 }
				cylinder { <-3.9611, 41.8444, 0.7801>, <-3.9973, 41.9097, 0.7876>, 0.001159 }
				cylinder { <-3.9973, 41.9097, 0.7876>, <-4.03973, 41.9714, 0.794>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.03973, 41.9714, 0.794>, <-4.4152, 42.9344, 1.308>, <-4.3996, 42.9111, 1.3873> }
				triangle { <-4.4152, 42.9344, 1.308>, <-4.7273, 43.4465, 1.6057>, <-4.3996, 42.9111, 1.3873> }
				triangle { <-4.7273, 43.4465, 1.6057>, <-4.723, 43.3991, 1.6862>, <-4.3996, 42.9111, 1.3873> }
				triangle { <-4.7273, 43.4465, 1.6057>, <-5.9938, 44.8526, 2.4986>, <-4.723, 43.3991, 1.6862> }
				triangle { <-4.723, 43.3991, 1.6862>, <-5.9938, 44.8526, 2.4986>, <-4.7138, 43.3392, 1.759> }
				triangle { <-4.3996, 42.9111, 1.3873>, <-4.723, 43.3991, 1.6862>, <-4.7138, 43.3392, 1.759> }
				triangle { <-4.3996, 42.9111, 1.3873>, <-4.7138, 43.3392, 1.759>, <-4.3887, 42.8597, 1.4475> }
				triangle { <-4.3996, 42.9111, 1.3873>, <-4.3887, 42.8597, 1.4475>, <-4.03973, 41.9714, 0.794> }
				triangle { <-6.7567, 45.5134, 2.9461>, <-5.9938, 44.8526, 2.4986>, <-6.03813, 44.9072, 2.3805> }
				triangle { <-4.7138, 43.3392, 1.759>, <-5.9938, 44.8526, 2.4986>, <-6.04144, 44.7534, 2.6305> }
				triangle { <-4.7273, 43.4465, 1.6057>, <-6.03813, 44.9072, 2.3805>, <-5.9938, 44.8526, 2.4986> }
				triangle { <-6.7567, 45.5134, 2.9461>, <-6.04144, 44.7534, 2.6305>, <-5.9938, 44.8526, 2.4986> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.8849, 41.5583, 0.7414>, <-3.9249, 42.6668, 0.8821>, 0.05734 }
				cylinder { <-3.9249, 42.6668, 0.8821>, <-3.9903, 43.7775, 0.9935>, 0.05734 }
				cylinder { <-3.9903, 43.7775, 0.9935>, <-4.08084, 44.889, 1.07549>, 0.05734 }
				cylinder { <-4.08084, 44.889, 1.07549>, <-4.1965, 45.9999, 1.1278>, 0.05734 }
				cylinder { <-4.1965, 45.9999, 1.1278>, <-4.3371, 47.109, 1.1504>, 0.05734 }
				cylinder { <-4.3371, 47.109, 1.1504>, <-4.5025, 48.2148, 1.1434>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.5025, 48.2148, 1.1434>, <-4.5063, 48.2898, 1.1436>, 0.001159 }
				cylinder { <-4.5063, 48.2898, 1.1436>, <-4.5027, 48.3648, 1.1444>, 0.001159 }
				cylinder { <-4.5027, 48.3648, 1.1444>, <-4.4919, 48.4391, 1.1458>, 0.001159 }
				cylinder { <-4.4919, 48.4391, 1.1458>, <-4.4738, 48.512, 1.1478>, 0.001159 }
				cylinder { <-4.4738, 48.512, 1.1478>, <-4.4488, 48.5827, 1.1504>, 0.001159 }
				cylinder { <-4.4488, 48.5827, 1.1504>, <-4.4169, 48.6507, 1.1536>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.4169, 48.6507, 1.1536>, <-3.7388, 49.4683, 1.6055>, <-3.7443, 49.4438, 1.6859> }
				triangle { <-3.7388, 49.4683, 1.6055>, <-3.4333, 50.00014, 1.874>, <-3.7443, 49.4438, 1.6859> }
				triangle { <-3.4333, 50.00014, 1.874>, <-3.4651, 49.973, 1.9577>, <-3.7443, 49.4438, 1.6859> }
				triangle { <-3.4333, 50.00014, 1.874>, <-2.7957, 51.8137, 2.7004>, <-3.4651, 49.973, 1.9577> }
				triangle { <-3.4651, 49.973, 1.9577>, <-2.7957, 51.8137, 2.7004>, <-3.5057, 49.9354, 2.03456> }
				triangle { <-3.7443, 49.4438, 1.6859>, <-3.4651, 49.973, 1.9577>, <-3.5057, 49.9354, 2.03456> }
				triangle { <-3.7443, 49.4438, 1.6859>, <-3.5057, 49.9354, 2.03456>, <-3.7779, 49.4088, 1.7493> }
				triangle { <-3.7443, 49.4438, 1.6859>, <-3.7779, 49.4088, 1.7493>, <-4.4169, 48.6507, 1.1536> }
				triangle { <-2.5789, 52.8107, 3.1223>, <-2.7957, 51.8137, 2.7004>, <-2.7812, 51.8785, 2.5801> }
				triangle { <-3.5057, 49.9354, 2.03456>, <-2.7957, 51.8137, 2.7004>, <-2.8941, 51.8055, 2.8411> }
				triangle { <-3.4333, 50.00014, 1.874>, <-2.7812, 51.8785, 2.5801>, <-2.7957, 51.8137, 2.7004> }
				triangle { <-2.5789, 52.8107, 3.1223>, <-2.8941, 51.8055, 2.8411>, <-2.7957, 51.8137, 2.7004> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.5025, 48.2148, 1.1434>, <-4.6679, 49.3207, 1.1364>, 0.05734 }
				cylinder { <-4.6679, 49.3207, 1.1364>, <-4.8333, 50.4265, 1.1294>, 0.05734 }
				cylinder { <-4.8333, 50.4265, 1.1294>, <-4.9987, 51.5324, 1.1224>, 0.05734 }
				cylinder { <-4.9987, 51.5324, 1.1224>, <-5.1641, 52.6382, 1.1154>, 0.05734 }
				cylinder { <-5.1641, 52.6382, 1.1154>, <-5.3295, 53.7441, 1.1083>, 0.05734 }
				cylinder { <-5.3295, 53.7441, 1.1083>, <-5.4949, 54.8499, 1.1013>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.4949, 54.8499, 1.1013>, <-5.515, 54.9223, 1.1001>, 0.001159 }
				cylinder { <-5.515, 54.9223, 1.1001>, <-5.5437, 54.9916, 1.0981>, 0.001159 }
				cylinder { <-5.5437, 54.9916, 1.0981>, <-5.5807, 55.05694, 1.09534>, 0.001159 }
				cylinder { <-5.5807, 55.05694, 1.09534>, <-5.6254, 55.1172, 1.09189>, 0.001159 }
				cylinder { <-5.6254, 55.1172, 1.09189>, <-5.6771, 55.1715, 1.0878>, 0.001159 }
				cylinder { <-5.6771, 55.1715, 1.0878>, <-5.735, 55.2191, 1.08313>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.735, 55.2191, 1.08313>, <-6.3884, 56.1087, 1.4209>, <-6.3718, 56.1037, 1.5033> }
				triangle { <-6.3884, 56.1087, 1.4209>, <-6.8452, 56.5544, 1.6233>, <-6.3718, 56.1037, 1.5033> }
				triangle { <-6.8452, 56.5544, 1.6233>, <-6.8329, 56.5236, 1.7107>, <-6.3718, 56.1037, 1.5033> }
				triangle { <-6.8452, 56.5544, 1.6233>, <-8.4974, 57.6762, 2.2481>, <-6.8329, 56.5236, 1.7107> }
				triangle { <-6.8329, 56.5236, 1.7107>, <-8.4974, 57.6762, 2.2481>, <-6.8121, 56.4812, 1.7928> }
				triangle { <-6.3718, 56.1037, 1.5033>, <-6.8329, 56.5236, 1.7107>, <-6.8121, 56.4812, 1.7928> }
				triangle { <-6.3718, 56.1037, 1.5033>, <-6.8121, 56.4812, 1.7928>, <-6.3509, 56.06776, 1.5714> }
				triangle { <-6.3718, 56.1037, 1.5033>, <-6.3509, 56.06776, 1.5714>, <-5.735, 55.2191, 1.08313> }
				triangle { <-9.4366, 58.1611, 2.5673>, <-8.4974, 57.6762, 2.2481>, <-8.5479, 57.6966, 2.1219> }
				triangle { <-6.8121, 56.4812, 1.7928>, <-8.4974, 57.6762, 2.2481>, <-8.5239, 57.59, 2.3945> }
				triangle { <-6.8452, 56.5544, 1.6233>, <-8.5479, 57.6966, 2.1219>, <-8.4974, 57.6762, 2.2481> }
				triangle { <-9.4366, 58.1611, 2.5673>, <-8.5239, 57.59, 2.3945>, <-8.4974, 57.6762, 2.2481> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.4949, 54.8499, 1.1013>, <-5.6355, 55.959, 1.124>, 0.05734 }
				cylinder { <-5.6355, 55.959, 1.124>, <-5.7512, 57.06995, 1.1764>, 0.05734 }
				cylinder { <-5.7512, 57.06995, 1.1764>, <-5.8418, 58.1814, 1.2583>, 0.05734 }
				cylinder { <-5.8418, 58.1814, 1.2583>, <-5.9073, 59.292, 1.3698>, 0.05734 }
				cylinder { <-5.9073, 59.292, 1.3698>, <-5.9475, 60.4006, 1.5108>, 0.05734 }
				cylinder { <-5.9475, 60.4006, 1.5108>, <-5.9624, 61.5056, 1.6809>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.9624, 61.5056, 1.6809>, <-5.9524, 61.579, 1.6931>, 0.001159 }
				cylinder { <-5.9524, 61.579, 1.6931>, <-5.9317, 61.6501, 1.7057>, 0.001159 }
				cylinder { <-5.9317, 61.6501, 1.7057>, <-5.9006, 61.7172, 1.7185>, 0.001159 }
				cylinder { <-5.9006, 61.7172, 1.7185>, <-5.8598, 61.779, 1.7312>, 0.001159 }
				cylinder { <-5.8598, 61.779, 1.7312>, <-5.8103, 61.8341, 1.7435>, 0.001159 }
				cylinder { <-5.8103, 61.8341, 1.7435>, <-5.753, 61.8813, 1.7552>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.753, 61.8813, 1.7552>, <-4.7941, 62.2535, 2.279>, <-4.8089, 62.2192, 2.3544> }
				triangle { <-4.7941, 62.2535, 2.279>, <-4.2937, 62.5556, 2.6056>, <-4.8089, 62.2192, 2.3544> }
				triangle { <-4.2937, 62.5556, 2.6056>, <-4.3335, 62.5291, 2.686>, <-4.8089, 62.2192, 2.3544> }
				triangle { <-4.2937, 62.5556, 2.6056>, <-2.9557, 63.7671, 3.6642>, <-4.3335, 62.5291, 2.686> }
				triangle { <-4.3335, 62.5291, 2.686>, <-2.9557, 63.7671, 3.6642>, <-4.3857, 62.498, 2.7586> }
				triangle { <-4.8089, 62.2192, 2.3544>, <-4.3335, 62.5291, 2.686>, <-4.3857, 62.498, 2.7586> }
				triangle { <-4.8089, 62.2192, 2.3544>, <-4.3857, 62.498, 2.7586>, <-4.8536, 62.19, 2.4138> }
				triangle { <-4.8089, 62.2192, 2.3544>, <-4.8536, 62.19, 2.4138>, <-5.753, 61.8813, 1.7552> }
				triangle { <-2.3418, 64.4934, 4.225>, <-2.9557, 63.7671, 3.6642>, <-2.9161, 63.8411, 3.5553> }
				triangle { <-4.3857, 62.498, 2.7586>, <-2.9557, 63.7671, 3.6642>, <-3.04789, 63.7741, 3.809> }
				triangle { <-4.2937, 62.5556, 2.6056>, <-2.9161, 63.8411, 3.5553>, <-2.9557, 63.7671, 3.6642> }
				triangle { <-2.3418, 64.4934, 4.225>, <-3.04789, 63.7741, 3.809>, <-2.9557, 63.7671, 3.6642> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.9624, 61.5056, 1.6809>, <-5.9521, 62.6058, 1.8801>, 0.05734 }
				cylinder { <-5.9521, 62.6058, 1.8801>, <-5.9165, 63.6999, 2.1081>, 0.05734 }
				cylinder { <-5.9165, 63.6999, 2.1081>, <-5.8557, 64.7866, 2.3646>, 0.05734 }
				cylinder { <-5.8557, 64.7866, 2.3646>, <-5.7697, 65.8645, 2.6494>, 0.05734 }
				cylinder { <-5.7697, 65.8645, 2.6494>, <-5.6587, 66.9323, 2.9621>, 0.05734 }
				cylinder { <-5.6587, 66.9323, 2.9621>, <-5.5229, 67.9887, 3.3023>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.5229, 67.9887, 3.3023>, <-5.5211, 68.0604, 3.3248>, 0.001159 }
				cylinder { <-5.5211, 68.0604, 3.3248>, <-5.5266, 68.132, 3.3465>, 0.001159 }
				cylinder { <-5.5266, 68.132, 3.3465>, <-5.5394, 68.203, 3.3674>, 0.001159 }
				cylinder { <-5.5394, 68.203, 3.3674>, <-5.5594, 68.2726, 3.3872>, 0.001159 }
				cylinder { <-5.5594, 68.2726, 3.3872>, <-5.5864, 68.3402, 3.4058>, 0.001159 }
				cylinder { <-5.5864, 68.3402, 3.4058>, <-5.62, 68.4051, 3.4229>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.62, 68.4051, 3.4229>, <-5.8586, 69.3159, 4.09085>, <-5.8458, 69.2785, 4.1651> }
				triangle { <-5.8586, 69.3159, 4.09085>, <-6.09681, 69.8112, 4.4732>, <-5.8458, 69.2785, 4.1651> }
				triangle { <-6.09681, 69.8112, 4.4732>, <-6.09843, 69.7515, 4.5452>, <-5.8458, 69.2785, 4.1651> }
				triangle { <-6.09681, 69.8112, 4.4732>, <-7.1558, 71.2136, 5.6091>, <-6.09843, 69.7515, 4.5452> }
				triangle { <-6.09843, 69.7515, 4.5452>, <-7.1558, 71.2136, 5.6091>, <-6.09693, 69.6803, 4.6075> }
				triangle { <-5.8458, 69.2785, 4.1651>, <-6.09843, 69.7515, 4.5452>, <-6.09693, 69.6803, 4.6075> }
				triangle { <-5.8458, 69.2785, 4.1651>, <-6.09693, 69.6803, 4.6075>, <-5.8416, 69.2173, 4.2162> }
				triangle { <-5.8458, 69.2785, 4.1651>, <-5.8416, 69.2173, 4.2162>, <-5.62, 68.4051, 3.4229> }
				triangle { <-7.8196, 71.8904, 6.1751>, <-7.1558, 71.2136, 5.6091>, <-7.1931, 71.2916, 5.5022> }
				triangle { <-6.09693, 69.6803, 4.6075>, <-7.1558, 71.2136, 5.6091>, <-7.2155, 71.1019, 5.7252> }
				triangle { <-6.09681, 69.8112, 4.4732>, <-7.1931, 71.2916, 5.5022>, <-7.1558, 71.2136, 5.6091> }
				triangle { <-7.8196, 71.8904, 6.1751>, <-7.2155, 71.1019, 5.7252>, <-7.1558, 71.2136, 5.6091> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.5229, 67.9887, 3.3023>, <-5.3623, 69.03258, 3.6697>, 0.05734 }
				cylinder { <-5.3623, 69.03258, 3.6697>, <-5.1772, 70.06252, 4.06382>, 0.05734 }
				cylinder { <-5.1772, 70.06252, 4.06382>, <-4.9679, 71.07732, 4.4841>, 0.05734 }
				cylinder { <-4.9679, 71.07732, 4.4841>, <-4.7346, 72.07578, 4.9301>, 0.05734 }
				cylinder { <-4.7346, 72.07578, 4.9301>, <-4.4775, 73.05667, 5.4013>, 0.05734 }
				cylinder { <-4.4775, 73.05667, 5.4013>, <-4.1971, 74.01883, 5.8972>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.1971, 74.01883, 5.8972>, <-4.1662, 74.07896, 5.9299>, 0.001159 }
				cylinder { <-4.1662, 74.07896, 5.9299>, <-4.1241, 74.1328, 5.961>, 0.001159 }
				cylinder { <-4.1241, 74.1328, 5.961>, <-4.07219, 74.1788, 5.9897>, 0.001159 }
				cylinder { <-4.07219, 74.1788, 5.9897>, <-4.01184, 74.2156, 6.01506>, 0.001159 }
				cylinder { <-4.01184, 74.2156, 6.01506>, <-3.9448, 74.2422, 6.03631>, 0.001159 }
				cylinder { <-3.9448, 74.2422, 6.03631>, <-3.8732, 74.2576, 6.05286>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.8732, 74.2576, 6.05286>, <-2.8372, 74.04673, 6.5161>, <-2.8633, 73.9977, 6.5793> }
				triangle { <-2.8372, 74.04673, 6.5161>, <-2.2522, 74.0125, 6.84>, <-2.8633, 73.9977, 6.5793> }
				triangle { <-2.2522, 74.0125, 6.84>, <-2.2979, 73.978, 6.9139>, <-2.8633, 73.9977, 6.5793> }
				triangle { <-2.2522, 74.0125, 6.84>, <-0.5219, 74.2094, 8.000095>, <-2.2979, 73.978, 6.9139> }
				triangle { <-2.2979, 73.978, 6.9139>, <-0.5219, 74.2094, 8.000095>, <-2.3571, 73.9467, 6.9809> }
				triangle { <-2.8633, 73.9977, 6.5793>, <-2.2979, 73.978, 6.9139>, <-2.3571, 73.9467, 6.9809> }
				triangle { <-2.8633, 73.9977, 6.5793>, <-2.3571, 73.9467, 6.9809>, <-2.9151, 73.9697, 6.6333> }
				triangle { <-2.8633, 73.9977, 6.5793>, <-2.9151, 73.9697, 6.6333>, <-3.8732, 74.2576, 6.05286> }
				triangle { <0.3419, 74.4228, 8.6536>, <-0.5219, 74.2094, 8.000095>, <-0.4576, 74.2945, 7.9133> }
				triangle { <-2.3571, 73.9467, 6.9809>, <-0.5219, 74.2094, 8.000095>, <-0.601, 74.2025, 8.1524> }
				triangle { <-2.2522, 74.0125, 6.84>, <-0.4576, 74.2945, 7.9133>, <-0.5219, 74.2094, 8.000095> }
				triangle { <0.3419, 74.4228, 8.6536>, <-0.601, 74.2025, 8.1524>, <-0.5219, 74.2094, 8.000095> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-4.1971, 74.01883, 5.8972>, <-4.1818, 74.08438, 5.9305>, 0.001159 }
				cylinder { <-4.1818, 74.08438, 5.9305>, <-4.1701, 74.1507, 5.9637>, 0.001159 }
				cylinder { <-4.1701, 74.1507, 5.9637>, <-4.1621, 74.2176, 5.9967>, 0.001159 }
				cylinder { <-4.1621, 74.2176, 5.9967>, <-4.1577, 74.285, 6.02958>, 0.001159 }
				cylinder { <-4.1577, 74.285, 6.02958>, <-4.157, 74.3528, 6.06205>, 0.001159 }
				cylinder { <-4.157, 74.3528, 6.06205>, <-4.1599, 74.4206, 6.09411>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.1599, 74.4206, 6.09411>, <-3.9509, 75.1962, 6.9231>, <-3.9479, 75.1424, 6.9878> }
				triangle { <-3.9509, 75.1962, 6.9231>, <-3.9343, 75.6553, 7.4102>, <-3.9479, 75.1424, 6.9878> }
				triangle { <-3.9343, 75.6553, 7.4102>, <-3.9536, 75.5874, 7.4715>, <-3.9479, 75.1424, 6.9878> }
				triangle { <-3.9343, 75.6553, 7.4102>, <-4.233, 77.09102, 8.9029>, <-3.9536, 75.5874, 7.4715> }
				triangle { <-3.9536, 75.5874, 7.4715>, <-4.233, 77.09102, 8.9029>, <-3.9757, 75.5098, 7.5211> }
				triangle { <-3.9479, 75.1424, 6.9878>, <-3.9536, 75.5874, 7.4715>, <-3.9757, 75.5098, 7.5211> }
				triangle { <-3.9479, 75.1424, 6.9878>, <-3.9757, 75.5098, 7.5211>, <-3.9644, 75.07512, 7.0276> }
				triangle { <-3.9479, 75.1424, 6.9878>, <-3.9644, 75.07512, 7.0276>, <-4.1599, 74.4206, 6.09411> }
				triangle { <-4.5145, 77.8383, 9.6652>, <-4.233, 77.09102, 8.9029>, <-4.2447, 77.1973, 8.8166> }
				triangle { <-3.9757, 75.5098, 7.5211>, <-4.233, 77.09102, 8.9029>, <-4.3224, 76.9893, 9.008657> }
				triangle { <-3.9343, 75.6553, 7.4102>, <-4.2447, 77.1973, 8.8166>, <-4.233, 77.09102, 8.9029> }
				triangle { <-4.5145, 77.8383, 9.6652>, <-4.3224, 76.9893, 9.008657>, <-4.233, 77.09102, 8.9029> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.0, 3.7136, 0.0>, 0.05734 }
			cylinder { <0.0, 3.7136, 0.0>, <-0.0, 7.4272, 0.0>, 0.05734 }
			cylinder { <-0.0, 7.4272, 0.0>, <-0.0, 11.1408, 0.0>, 0.05734 }
			cylinder { <-0.0, 11.1408, 0.0>, <-0.0, 14.8544, 0.0>, 0.05734 }
			cylinder { <-0.0, 14.8544, 0.0>, <-0.0, 18.568, 0.0>, 0.05734 }
			cylinder { <-0.0, 18.568, 0.0>, <-0.0, 22.2816, 0.0>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.0, 22.2816, 0.0>, <-0.02605, 23.3991, -0.02875>, 0.05734 }
				cylinder { <-0.02605, 23.3991, -0.02875>, <-0.07812, 24.5146, -0.08623>, 0.05734 }
				cylinder { <-0.07812, 24.5146, -0.08623>, <-0.1561, 25.6267, -0.1723>, 0.05734 }
				cylinder { <-0.1561, 25.6267, -0.1723>, <-0.2599, 26.7341, -0.2871>, 0.05734 }
				cylinder { <-0.2599, 26.7341, -0.2871>, <-0.3895, 27.8355, -0.4302>, 0.05734 }
				cylinder { <-0.3895, 27.8355, -0.4302>, <-0.5446, 28.9295, -0.6016>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.5446, 28.9295, -0.6016>, <-0.5477, 29.00375, -0.6128>, 0.001159 }
				cylinder { <-0.5477, 29.00375, -0.6128>, <-0.5434, 29.07795, -0.6235>, 0.001159 }
				cylinder { <-0.5434, 29.07795, -0.6235>, <-0.5318, 29.1514, -0.6337>, 0.001159 }
				cylinder { <-0.5318, 29.1514, -0.6337>, <-0.513, 29.2235, -0.6432>, 0.001159 }
				cylinder { <-0.513, 29.2235, -0.6432>, <-0.4872, 29.2935, -0.6519>, 0.001159 }
				cylinder { <-0.4872, 29.2935, -0.6519>, <-0.4547, 29.3607, -0.6599>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.4547, 29.3607, -0.6599>, <-0.205, 30.4098, -1.0716>, <-0.2261, 30.3953, -1.1517> }
				triangle { <-0.205, 30.4098, -1.0716>, <0.03705, 30.9807, -1.324>, <-0.2261, 30.3953, -1.1517> }
				triangle { <0.03705, 30.9807, -1.324>, <0.02892, 30.9435, -1.4094>, <-0.2261, 30.3953, -1.1517> }
				triangle { <0.03705, 30.9807, -1.324>, <1.1011, 32.5944, -2.1255>, <0.02892, 30.9435, -1.4094> }
				triangle { <0.02892, 30.9435, -1.4094>, <1.1011, 32.5944, -2.1255>, <0.0176, 30.8927, -1.4885> }
				triangle { <-0.2261, 30.3953, -1.1517>, <0.02892, 30.9435, -1.4094>, <0.0176, 30.8927, -1.4885> }
				triangle { <-0.2261, 30.3953, -1.1517>, <0.0176, 30.8927, -1.4885>, <-0.2385, 30.351, -1.217> }
				triangle { <-0.2261, 30.3953, -1.1517>, <-0.2385, 30.351, -1.217>, <-0.4547, 29.3607, -0.6599> }
				triangle { <1.765, 33.3711, -2.5437>, <1.1011, 32.5944, -2.1255>, <1.1519, 32.6375, -2.005386> }
				triangle { <0.0176, 30.8927, -1.4885>, <1.1011, 32.5944, -2.1255>, <1.1436, 32.5169, -2.2729> }
				triangle { <0.03705, 30.9807, -1.324>, <1.1519, 32.6375, -2.005386>, <1.1011, 32.5944, -2.1255> }
				triangle { <1.765, 33.3711, -2.5437>, <1.1436, 32.5169, -2.2729>, <1.1011, 32.5944, -2.1255> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.5446, 28.9295, -0.6016>, <-0.7501, 30.00489, -0.829>, 0.05734 }
				cylinder { <-0.7501, 30.00489, -0.829>, <-1.005076, 31.05639, -1.1113>, 0.05734 }
				cylinder { <-1.005076, 31.05639, -1.1113>, <-1.308, 32.07898, -1.4471>, 0.05734 }
				cylinder { <-1.308, 32.07898, -1.4471>, <-1.6576, 33.06775, -1.835>, 0.05734 }
				cylinder { <-1.6576, 33.06775, -1.835>, <-2.05198, 34.01791, -2.2732>, 0.05734 }
				cylinder { <-2.05198, 34.01791, -2.2732>, <-2.4891, 34.9249, -2.7595>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-2.4891, 34.9249, -2.7595>, <-2.5312, 34.9785, -2.7909>, 0.001159 }
				cylinder { <-2.5312, 34.9785, -2.7909>, <-2.5845, 35.0229, -2.8199>, 0.001159 }
				cylinder { <-2.5845, 35.0229, -2.8199>, <-2.6468, 35.0562, -2.8453>, 0.001159 }
				cylinder { <-2.6468, 35.0562, -2.8453>, <-2.7158, 35.07719, -2.8662>, 0.001159 }
				cylinder { <-2.7158, 35.07719, -2.8662>, <-2.7888, 35.08508, -2.8818>, 0.001159 }
				cylinder { <-2.7888, 35.08508, -2.8818>, <-2.8631, 35.07955, -2.8914>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.8631, 35.07955, -2.8914>, <-3.8985, 34.6463, -3.1613>, <-3.8729, 34.5942, -3.2222> }
				triangle { <-3.8985, 34.6463, -3.1613>, <-4.5067, 34.4765, -3.384>, <-3.8729, 34.5942, -3.2222> }
				triangle { <-4.5067, 34.4765, -3.384>, <-4.466, 34.4403, -3.46>, <-3.8729, 34.5942, -3.2222> }
				triangle { <-4.5067, 34.4765, -3.384>, <-6.3859, 34.239, -4.2731>, <-4.466, 34.4403, -3.46> }
				triangle { <-4.466, 34.4403, -3.46>, <-6.3859, 34.239, -4.2731>, <-4.4119, 34.4102, -3.5317> }
				triangle { <-3.8729, 34.5942, -3.2222>, <-4.466, 34.4403, -3.46>, <-4.4119, 34.4102, -3.5317> }
				triangle { <-3.8729, 34.5942, -3.2222>, <-4.4119, 34.4102, -3.5317>, <-3.8249, 34.5679, -3.2803> }
				triangle { <-3.8729, 34.5942, -3.2222>, <-3.8249, 34.5679, -3.2803>, <-2.8631, 35.07955, -2.8914> }
				triangle { <-7.3547, 34.2231, -4.8024>, <-6.3859, 34.239, -4.2731>, <-6.4519, 34.3235, -4.187> }
				triangle { <-4.4119, 34.4102, -3.5317>, <-6.3859, 34.239, -4.2731>, <-6.3283, 34.2247, -4.4343> }
				triangle { <-4.5067, 34.4765, -3.384>, <-6.4519, 34.3235, -4.187>, <-6.3859, 34.239, -4.2731> }
				triangle { <-7.3547, 34.2231, -4.8024>, <-6.3283, 34.2247, -4.4343>, <-6.3859, 34.239, -4.2731> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-2.4891, 34.9249, -2.7595>, <-2.9511, 35.8202, -3.2445>, 0.05734 }
				cylinder { <-2.9511, 35.8202, -3.2445>, <-3.4376, 36.7033, -3.728>, 0.05734 }
				cylinder { <-3.4376, 36.7033, -3.728>, <-3.9484, 37.5736, -4.2096>, 0.05734 }
				cylinder { <-3.9484, 37.5736, -4.2096>, <-4.483, 38.4307, -4.689>, 0.05734 }
				cylinder { <-4.483, 38.4307, -4.689>, <-5.04134, 39.274, -5.1661>, 0.05734 }
				cylinder { <-5.04134, 39.274, -5.1661>, <-5.6228, 40.103, -5.6403>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.6228, 40.103, -5.6403>, <-5.6538, 40.1631, -5.6729>, 0.001159 }
				cylinder { <-5.6538, 40.1631, -5.6729>, <-5.6764, 40.2268, -5.7057>, 0.001159 }
				cylinder { <-5.6764, 40.2268, -5.7057>, <-5.6901, 40.293, -5.7383>, 0.001159 }
				cylinder { <-5.6901, 40.293, -5.7383>, <-5.6947, 40.3609, -5.7701>, 0.001159 }
				cylinder { <-5.6947, 40.3609, -5.7701>, <-5.6903, 40.4293, -5.8006>, 0.001159 }
				cylinder { <-5.6903, 40.4293, -5.8006>, <-5.6768, 40.4973, -5.8295>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.6768, 40.4973, -5.8295>, <-5.7008, 41.4023, -6.5458>, <-5.7132, 41.3593, -6.6171> }
				triangle { <-5.7008, 41.4023, -6.5458>, <-5.6104, 41.9153, -6.9664>, <-5.7132, 41.3593, -6.6171> }
				triangle { <-5.6104, 41.9153, -6.9664>, <-5.6039, 41.8536, -7.0364>, <-5.7132, 41.3593, -6.6171> }
				triangle { <-5.6104, 41.9153, -6.9664>, <-4.9853, 43.4427, -8.2528>, <-5.6039, 41.8536, -7.0364> }
				triangle { <-5.6039, 41.8536, -7.0364>, <-4.9853, 43.4427, -8.2528>, <-5.5971, 41.7804, -7.09614> }
				triangle { <-5.7132, 41.3593, -6.6171>, <-5.6039, 41.8536, -7.0364>, <-5.5971, 41.7804, -7.09614> }
				triangle { <-5.7132, 41.3593, -6.6171>, <-5.5971, 41.7804, -7.09614>, <-5.7099, 41.2959, -6.6656> }
				triangle { <-5.7132, 41.3593, -6.6171>, <-5.7099, 41.2959, -6.6656>, <-5.6768, 40.4973, -5.8295> }
				triangle { <-4.537, 44.2097, -8.9082>, <-4.9853, 43.4427, -8.2528>, <-4.9541, 43.5319, -8.153> }
				triangle { <-5.5971, 41.7804, -7.09614>, <-4.9853, 43.4427, -8.2528>, <-4.9161, 43.3396, -8.3715> }
				triangle { <-5.6104, 41.9153, -6.9664>, <-4.9541, 43.5319, -8.153>, <-4.9853, 43.4427, -8.2528> }
				triangle { <-4.537, 44.2097, -8.9082>, <-4.9161, 43.3396, -8.3715>, <-4.9853, 43.4427, -8.2528> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.6228, 40.103, -5.6403>, <-6.2043, 40.9319, -6.1146>, 0.05734 }
				cylinder { <-6.2043, 40.9319, -6.1146>, <-6.7859, 41.7609, -6.5889>, 0.05734 }
				cylinder { <-6.7859, 41.7609, -6.5889>, <-7.3674, 42.5899, -7.06317>, 0.05734 }
				cylinder { <-7.3674, 42.5899, -7.06317>, <-7.9489, 43.4189, -7.5374>, 0.05734 }
				cylinder { <-7.9489, 43.4189, -7.5374>, <-8.5304, 44.2478, -8.01171>, 0.05734 }
				cylinder { <-8.5304, 44.2478, -8.01171>, <-9.112, 45.07686, -8.4859>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-9.112, 45.07686, -8.4859>, <-9.1599, 45.126, -8.5163>, 0.001159 }
				cylinder { <-9.1599, 45.126, -8.5163>, <-9.2156, 45.1678, -8.5445>, 0.001159 }
				cylinder { <-9.2156, 45.1678, -8.5445>, <-9.2779, 45.2011, -8.5699>, 0.001159 }
				cylinder { <-9.2779, 45.2011, -8.5699>, <-9.3455, 45.2252, -8.592>, 0.001159 }
				cylinder { <-9.3455, 45.2252, -8.592>, <-9.4168, 45.2397, -8.6103>, 0.001159 }
				cylinder { <-9.4168, 45.2397, -8.6103>, <-9.4904, 45.2443, -8.6245>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.4904, 45.2443, -8.6245>, <-10.5551, 44.9571, -8.9659>, <-10.5328, 44.9031, -9.02654> }
				triangle { <-10.5551, 44.9571, -8.9659>, <-11.1653, 44.8734, -9.2283>, <-10.5328, 44.9031, -9.02654> }
				triangle { <-11.1653, 44.8734, -9.2283>, <-11.1252, 44.8334, -9.3027>, <-10.5328, 44.9031, -9.02654> }
				triangle { <-11.1653, 44.8734, -9.2283>, <-13.00101, 44.903, -10.2324>, <-11.1252, 44.8334, -9.3027> }
				triangle { <-11.1252, 44.8334, -9.3027>, <-13.00101, 44.903, -10.2324>, <-11.07123, 44.7977, -9.3718> }
				triangle { <-10.5328, 44.9031, -9.02654>, <-11.1252, 44.8334, -9.3027>, <-11.07123, 44.7977, -9.3718> }
				triangle { <-10.5328, 44.9031, -9.02654>, <-11.07123, 44.7977, -9.3718>, <-10.4852, 44.8717, -9.08239> }
				triangle { <-10.5328, 44.9031, -9.02654>, <-10.4852, 44.8717, -9.08239>, <-9.4904, 45.2443, -8.6245> }
				triangle { <-13.9289, 45.02504, -10.8181>, <-13.00101, 44.903, -10.2324>, <-13.06052, 44.9939, -10.1482> }
				triangle { <-11.07123, 44.7977, -9.3718>, <-13.00101, 44.903, -10.2324>, <-12.9359, 44.8839, -10.3903> }
				triangle { <-11.1653, 44.8734, -9.2283>, <-13.06052, 44.9939, -10.1482>, <-13.00101, 44.903, -10.2324> }
				triangle { <-13.9289, 45.02504, -10.8181>, <-12.9359, 44.8839, -10.3903>, <-13.00101, 44.903, -10.2324> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-9.112, 45.07686, -8.4859>, <-9.6741, 45.9311, -8.9381>, 0.05734 }
				cylinder { <-9.6741, 45.9311, -8.9381>, <-10.2162, 46.8097, -9.3676>, 0.05734 }
				cylinder { <-10.2162, 46.8097, -9.3676>, <-10.7375, 47.7116, -9.774>, 0.05734 }
				cylinder { <-10.7375, 47.7116, -9.774>, <-11.2376, 48.6356, -10.1567>, 0.05734 }
				cylinder { <-11.2376, 48.6356, -10.1567>, <-11.7157, 49.5807, -10.5152>, 0.05734 }
				cylinder { <-11.7157, 49.5807, -10.5152>, <-12.1713, 50.5457, -10.8492>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-12.1713, 50.5457, -10.8492>, <-12.1916, 50.6143, -10.8719>, 0.001159 }
				cylinder { <-12.1916, 50.6143, -10.8719>, <-12.201, 50.6853, -10.8945>, 0.001159 }
				cylinder { <-12.201, 50.6853, -10.8945>, <-12.1995, 50.7571, -10.9163>, 0.001159 }
				cylinder { <-12.1995, 50.7571, -10.9163>, <-12.187, 50.8282, -10.9371>, 0.001159 }
				cylinder { <-12.187, 50.8282, -10.9371>, <-12.1638, 50.897, -10.9562>, 0.001159 }
				cylinder { <-12.1638, 50.897, -10.9562>, <-12.1304, 50.9621, -10.9733>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-12.1304, 50.9621, -10.9733>, <-11.8619, 51.9365, -11.5309>, <-11.8814, 51.9103, -11.6085> }
				triangle { <-11.8619, 51.9365, -11.5309>, <-11.609, 52.4618, -11.8601>, <-11.8814, 51.9103, -11.6085> }
				triangle { <-11.609, 52.4618, -11.8601>, <-11.6157, 52.4124, -11.9391>, <-11.8814, 51.9103, -11.6085> }
				triangle { <-11.609, 52.4618, -11.8601>, <-10.5127, 53.931, -12.8692>, <-11.6157, 52.4124, -11.9391> }
				triangle { <-11.6157, 52.4124, -11.9391>, <-10.5127, 53.931, -12.8692>, <-11.6259, 52.3504, -12.01008> }
				triangle { <-11.8814, 51.9103, -11.6085>, <-11.6157, 52.4124, -11.9391>, <-11.6259, 52.3504, -12.01008> }
				triangle { <-11.8814, 51.9103, -11.6085>, <-11.6259, 52.3504, -12.01008>, <-11.893, 51.8569, -11.6667> }
				triangle { <-11.8814, 51.9103, -11.6085>, <-11.893, 51.8569, -11.6667>, <-12.1304, 50.9621, -10.9733> }
				triangle { <-9.8326, 54.6323, -13.3835>, <-10.5127, 53.931, -12.8692>, <-10.464, 53.9912, -12.7556> }
				triangle { <-11.6259, 52.3504, -12.01008>, <-10.5127, 53.931, -12.8692>, <-10.4678, 53.8322, -13.00246> }
				triangle { <-11.609, 52.4618, -11.8601>, <-10.464, 53.9912, -12.7556>, <-10.5127, 53.931, -12.8692> }
				triangle { <-9.8326, 54.6323, -13.3835>, <-10.4678, 53.8322, -13.00246>, <-10.5127, 53.931, -12.8692> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-12.1713, 50.5457, -10.8492>, <-12.627, 51.5106, -11.1831>, 0.05734 }
				cylinder { <-12.627, 51.5106, -11.1831>, <-13.08265, 52.4756, -11.5171>, 0.05734 }
				cylinder { <-13.08265, 52.4756, -11.5171>, <-13.5382, 53.4406, -11.8511>, 0.05734 }
				cylinder { <-13.5382, 53.4406, -11.8511>, <-13.9939, 54.4055, -12.185>, 0.05734 }
				cylinder { <-13.9939, 54.4055, -12.185>, <-14.4495, 55.3705, -12.519>, 0.05734 }
				cylinder { <-14.4495, 55.3705, -12.519>, <-14.9052, 56.3355, -12.853>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-14.9052, 56.3355, -12.853>, <-14.9439, 56.396, -12.8748>, 0.001159 }
				cylinder { <-14.9439, 56.396, -12.8748>, <-14.9902, 56.4513, -12.8956>, 0.001159 }
				cylinder { <-14.9902, 56.4513, -12.8956>, <-15.04335, 56.5007, -12.9152>, 0.001159 }
				cylinder { <-15.04335, 56.5007, -12.9152>, <-15.1025, 56.5432, -12.9332>, 0.001159 }
				cylinder { <-15.1025, 56.5432, -12.9332>, <-15.1668, 56.5784, -12.9494>, 0.001159 }
				cylinder { <-15.1668, 56.5784, -12.9494>, <-15.2354, 56.6056, -12.9635>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-15.2354, 56.6056, -12.9635>, <-16.3161, 56.6864, -13.361>, <-16.3061, 56.6384, -13.4294> }
				triangle { <-16.3161, 56.6864, -13.361>, <-16.9094, 56.8196, -13.6413>, <-16.3061, 56.6384, -13.4294> }
				triangle { <-16.9094, 56.8196, -13.6413>, <-16.8775, 56.782, -13.7208>, <-16.3061, 56.6384, -13.4294> }
				triangle { <-16.9094, 56.8196, -13.6413>, <-18.6036, 57.5202, -14.65>, <-16.8775, 56.782, -13.7208> }
				triangle { <-16.8775, 56.782, -13.7208>, <-18.6036, 57.5202, -14.65>, <-16.8315, 56.7437, -13.7942> }
				triangle { <-16.3061, 56.6384, -13.4294>, <-16.8775, 56.782, -13.7208>, <-16.8315, 56.7437, -13.7942> }
				triangle { <-16.3061, 56.6384, -13.4294>, <-16.8315, 56.7437, -13.7942>, <-16.2658, 56.6039, -13.4891> }
				triangle { <-16.3061, 56.6384, -13.4294>, <-16.2658, 56.6039, -13.4891>, <-15.2354, 56.6056, -12.9635> }
				triangle { <-19.426, 57.9877, -15.2193>, <-18.6036, 57.5202, -14.65>, <-18.6406, 57.61, -14.5527> }
				triangle { <-16.8315, 56.7437, -13.7942>, <-18.6036, 57.5202, -14.65>, <-18.5372, 57.5082, -14.808> }
				triangle { <-16.9094, 56.8196, -13.6413>, <-18.6406, 57.61, -14.5527>, <-18.6036, 57.5202, -14.65> }
				triangle { <-19.426, 57.9877, -15.2193>, <-18.5372, 57.5082, -14.808>, <-18.6036, 57.5202, -14.65> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-14.9052, 56.3355, -12.853>, <-15.3608, 57.3004, -13.1869>, 0.05734 }
				cylinder { <-15.3608, 57.3004, -13.1869>, <-15.8164, 58.2654, -13.5209>, 0.05734 }
				cylinder { <-15.8164, 58.2654, -13.5209>, <-16.2721, 59.2304, -13.8548>, 0.05734 }
				cylinder { <-16.2721, 59.2304, -13.8548>, <-16.7277, 60.1953, -14.1888>, 0.05734 }
				cylinder { <-16.7277, 60.1953, -14.1888>, <-17.1833, 61.1603, -14.5228>, 0.05734 }
				cylinder { <-17.1833, 61.1603, -14.5228>, <-17.639, 62.1253, -14.8567>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-17.639, 62.1253, -14.8567>, <-17.661, 62.1934, -14.8794>, 0.001159 }
				cylinder { <-17.661, 62.1934, -14.8794>, <-17.6741, 62.2638, -14.9021>, 0.001159 }
				cylinder { <-17.6741, 62.2638, -14.9021>, <-17.678, 62.3354, -14.9244>, 0.001159 }
				cylinder { <-17.678, 62.3354, -14.9244>, <-17.6728, 62.4071, -14.9459>, 0.001159 }
				cylinder { <-17.6728, 62.4071, -14.9459>, <-17.6585, 62.478, -14.9664>, 0.001159 }
				cylinder { <-17.6585, 62.478, -14.9664>, <-17.6353, 62.5468, -14.9855>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-17.6353, 62.5468, -14.9855>, <-17.5297, 63.5408, -15.5629>, <-17.5486, 63.511, -15.6393> }
				triangle { <-17.5297, 63.5408, -15.5629>, <-17.3669, 64.09138, -15.9074>, <-17.5486, 63.511, -15.6393> }
				triangle { <-17.3669, 64.09138, -15.9074>, <-17.3699, 64.04031, -15.9856>, <-17.5486, 63.511, -15.6393> }
				triangle { <-17.3669, 64.09138, -15.9074>, <-16.5306, 65.6841, -16.9762>, <-17.3699, 64.04031, -15.9856> }
				triangle { <-17.3699, 64.04031, -15.9856>, <-16.5306, 65.6841, -16.9762>, <-17.3743, 63.9764, -16.05549> }
				triangle { <-17.5486, 63.511, -15.6393>, <-17.3699, 64.04031, -15.9856>, <-17.3743, 63.9764, -16.05549> }
				triangle { <-17.5486, 63.511, -15.6393>, <-17.3743, 63.9764, -16.05549>, <-17.5549, 63.4556, -15.6965> }
				triangle { <-17.5486, 63.511, -15.6393>, <-17.5549, 63.4556, -15.6965>, <-17.6353, 62.5468, -14.9855> }
				triangle { <-15.9777, 66.4658, -17.5259>, <-16.5306, 65.6841, -16.9762>, <-16.486, 65.7522, -16.8654> }
				triangle { <-17.3743, 63.9764, -16.05549>, <-16.5306, 65.6841, -16.9762>, <-16.4779, 65.5905, -17.1104> }
				triangle { <-17.3669, 64.09138, -15.9074>, <-16.486, 65.7522, -16.8654>, <-16.5306, 65.6841, -16.9762> }
				triangle { <-15.9777, 66.4658, -17.5259>, <-16.4779, 65.5905, -17.1104>, <-16.5306, 65.6841, -16.9762> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-17.639, 62.1253, -14.8567>, <-18.02417, 63.1429, -15.1146>, 0.05734 }
				cylinder { <-18.02417, 63.1429, -15.1146>, <-18.3348, 64.202, -15.2933>, 0.05734 }
				cylinder { <-18.3348, 64.202, -15.2933>, <-18.568, 65.2913, -15.3907>, 0.05734 }
				cylinder { <-18.568, 65.2913, -15.3907>, <-18.7212, 66.3988, -15.4055>, 0.05734 }
				cylinder { <-18.7212, 66.3988, -15.4055>, <-18.7932, 67.5126, -15.3374>, 0.05734 }
				cylinder { <-18.7932, 67.5126, -15.3374>, <-18.7832, 68.6205, -15.1868>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-18.7832, 68.6205, -15.1868>, <-18.7881, 68.6948, -15.1767>, 0.001159 }
				cylinder { <-18.7881, 68.6948, -15.1767>, <-18.7984, 68.7685, -15.1668>, 0.001159 }
				cylinder { <-18.7984, 68.7685, -15.1668>, <-18.8143, 68.8412, -15.157>, 0.001159 }
				cylinder { <-18.8143, 68.8412, -15.157>, <-18.8354, 68.9126, -15.1474>, 0.001159 }
				cylinder { <-18.8354, 68.9126, -15.1474>, <-18.8618, 68.9823, -15.1381>, 0.001159 }
				cylinder { <-18.8618, 68.9823, -15.1381>, <-18.8933, 69.04993, -15.1291>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-18.8933, 69.04993, -15.1291>, <-19.5916, 69.9565, -15.2806>, <-19.6056, 69.9458, -15.3629> }
				triangle { <-19.5916, 69.9565, -15.2806>, <-19.9083, 70.537, -15.3858>, <-19.6056, 69.9458, -15.3629> }
				triangle { <-19.9083, 70.537, -15.3858>, <-19.8977, 70.5233, -15.4777>, <-19.6056, 69.9458, -15.3629> }
				triangle { <-19.9083, 70.537, -15.3858>, <-20.5754, 72.4864, -15.7511>, <-19.8977, 70.5233, -15.4777> }
				triangle { <-19.8977, 70.5233, -15.4777>, <-20.5754, 72.4864, -15.7511>, <-19.8778, 70.4976, -15.5667> }
				triangle { <-19.6056, 69.9458, -15.3629>, <-19.8977, 70.5233, -15.4777>, <-19.8778, 70.4976, -15.5667> }
				triangle { <-19.6056, 69.9458, -15.3629>, <-19.8778, 70.4976, -15.5667>, <-19.5895, 69.9208, -15.437> }
				triangle { <-19.6056, 69.9458, -15.3629>, <-19.5895, 69.9208, -15.437>, <-18.8933, 69.04993, -15.1291> }
				triangle { <-20.805, 73.5475, -15.9513>, <-20.5754, 72.4864, -15.7511>, <-20.5584, 72.5304, -15.622> }
				triangle { <-19.8778, 70.4976, -15.5667>, <-20.5754, 72.4864, -15.7511>, <-20.5112, 72.4983, -15.91> }
				triangle { <-19.9083, 70.537, -15.3858>, <-20.5584, 72.5304, -15.622>, <-20.5754, 72.4864, -15.7511> }
				triangle { <-20.805, 73.5475, -15.9513>, <-20.5112, 72.4983, -15.91>, <-20.5754, 72.4864, -15.7511> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-18.7832, 68.6205, -15.1868>, <-18.7789, 68.6948, -15.1767>, 0.001159 }
				cylinder { <-18.7789, 68.6948, -15.1767>, <-18.7709, 68.7688, -15.1666>, 0.001159 }
				cylinder { <-18.7709, 68.7688, -15.1666>, <-18.7592, 68.8423, -15.1565>, 0.001159 }
				cylinder { <-18.7592, 68.8423, -15.1565>, <-18.7439, 68.9151, -15.1466>, 0.001159 }
				cylinder { <-18.7439, 68.9151, -15.1466>, <-18.725, 68.9871, -15.1367>, 0.001159 }
				cylinder { <-18.725, 68.9871, -15.1367>, <-18.7025, 69.05815, -15.1269>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-18.7025, 69.05815, -15.1269>, <-18.6299, 70.2044, -15.2418>, <-18.6549, 70.2089, -15.3221> }
				triangle { <-18.6299, 70.2044, -15.2418>, <-18.4876, 70.8519, -15.3354>, <-18.6549, 70.2089, -15.3221> }
				triangle { <-18.4876, 70.8519, -15.3354>, <-18.4971, 70.8382, -15.4274>, <-18.6549, 70.2089, -15.3221> }
				triangle { <-18.4876, 70.8519, -15.3354>, <-17.7169, 72.7632, -15.6981>, <-18.4971, 70.8382, -15.4274> }
				triangle { <-18.4971, 70.8382, -15.4274>, <-17.7169, 72.7632, -15.6981>, <-18.5073, 70.8092, -15.517> }
				triangle { <-18.6549, 70.2089, -15.3221>, <-18.4971, 70.8382, -15.4274>, <-18.5073, 70.8092, -15.517> }
				triangle { <-18.6549, 70.2089, -15.3221>, <-18.5073, 70.8092, -15.517>, <-18.6661, 70.1824, -15.3965> }
				triangle { <-18.6549, 70.2089, -15.3221>, <-18.6661, 70.1824, -15.3965>, <-18.7025, 69.05815, -15.1269> }
				triangle { <-17.1985, 73.7149, -15.9092>, <-17.7169, 72.7632, -15.6981>, <-17.6635, 72.7799, -15.5725> }
				triangle { <-18.5073, 70.8092, -15.517>, <-17.7169, 72.7632, -15.6981>, <-17.6755, 72.7355, -15.8625> }
				triangle { <-18.4876, 70.8519, -15.3354>, <-17.6635, 72.7799, -15.5725>, <-17.7169, 72.7632, -15.6981> }
				triangle { <-17.1985, 73.7149, -15.9092>, <-17.6755, 72.7355, -15.8625>, <-17.7169, 72.7632, -15.6981> }
				texture{Grass_Texture5}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 11.2873, 0.0>, 0.07351 }
			cylinder { <-0.0, 11.2873, 0.0>, <-0.0, 22.5746, 0.0>, 0.07351 }
			cylinder { <-0.0, 22.5746, 0.0>, <-0.00000001, 33.862, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 33.862, 0.0>, <-0.00000001, 45.1493, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 45.1493, 0.0>, <-0.00000001, 56.4367, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 56.4367, 0.0>, <-0.00000001, 67.724, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <0.00355, 68.2486, 0.01786>, 0.07351 }
			cylinder { <0.00355, 68.2486, 0.01786>, <0.01064, 68.7722, 0.05357>, 0.07351 }
			cylinder { <0.01064, 68.7722, 0.05357>, <0.02126, 69.2942, 0.107>, 0.07351 }
			cylinder { <0.02126, 69.2942, 0.107>, <0.03538, 69.814, 0.1783>, 0.07351 }
			cylinder { <0.03538, 69.814, 0.1783>, <0.053, 70.331, 0.2672>, 0.07351 }
			cylinder { <0.053, 70.331, 0.2672>, <0.07407, 70.8445, 0.3736>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.07407, 70.8445, 0.3736>, <0.09857, 71.354, 0.4975>, 0.07351 }
			cylinder { <0.09857, 71.354, 0.4975>, <0.1264, 71.8587, 0.6386>, 0.07351 }
			cylinder { <0.1264, 71.8587, 0.6386>, <0.1577, 72.3582, 0.7969>, 0.07351 }
			cylinder { <0.1577, 72.3582, 0.7969>, <0.1922, 72.8517, 0.972>, 0.07351 }
			cylinder { <0.1922, 72.8517, 0.972>, <0.2301, 73.3388, 1.1639>, 0.07351 }
			cylinder { <0.2301, 73.3388, 1.1639>, <0.2711, 73.8188, 1.3722>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.2711, 73.8188, 1.3722>, <0.3218, 74.3039, 1.566>, 0.07351 }
			cylinder { <0.3218, 74.3039, 1.566>, <0.382, 74.7937, 1.7449>, 0.07351 }
			cylinder { <0.382, 74.7937, 1.7449>, <0.4517, 75.2874, 1.9088>, 0.07351 }
			cylinder { <0.4517, 75.2874, 1.9088>, <0.5309, 75.7845, 2.05758>, 0.07351 }
			cylinder { <0.5309, 75.7845, 2.05758>, <0.6193, 76.2844, 2.1908>, 0.07351 }
			cylinder { <0.6193, 76.2844, 2.1908>, <0.717, 76.7864, 2.3086>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.717, 76.7864, 2.3086>, <0.73, 76.8395, 2.3203>, 0.07351 }
				cylinder { <0.73, 76.8395, 2.3203>, <0.7456, 76.892, 2.3313>, 0.07351 }
				cylinder { <0.7456, 76.892, 2.3313>, <0.7637, 76.9439, 2.3414>, 0.07351 }
				cylinder { <0.7637, 76.9439, 2.3414>, <0.7843, 76.995, 2.3506>, 0.07351 }
				cylinder { <0.7843, 76.995, 2.3506>, <0.8073, 77.0453, 2.359>, 0.07351 }
				cylinder { <0.8073, 77.0453, 2.359>, <0.8327, 77.0945, 2.3664>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.8327, 77.0945, 2.3664>, <1.6403, 79.06742, 3.2115>, <1.4564, 79.2195, 3.1166> }
					triangle { <1.6403, 79.06742, 3.2115>, <1.8904, 80.1909, 3.7559>, <1.4564, 79.2195, 3.1166> }
					triangle { <1.8904, 80.1909, 3.7559>, <1.6875, 80.3561, 3.6413>, <1.4564, 79.2195, 3.1166> }
					triangle { <1.8904, 80.1909, 3.7559>, <2.01816, 81.9952, 4.3541>, <1.6875, 80.3561, 3.6413> }
					triangle { <1.6875, 80.3561, 3.6413>, <2.01816, 81.9952, 4.3541>, <1.5489, 80.4242, 3.4011> }
					triangle { <1.4564, 79.2195, 3.1166>, <1.6875, 80.3561, 3.6413>, <1.5489, 80.4242, 3.4011> }
					triangle { <1.4564, 79.2195, 3.1166>, <1.5489, 80.4242, 3.4011>, <1.3142, 79.2718, 2.916> }
					triangle { <1.4564, 79.2195, 3.1166>, <1.3142, 79.2718, 2.916>, <0.8327, 77.0945, 2.3664> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.717, 76.7864, 2.3086>, <0.7976, 77.2901, 2.4322>, 0.07351 }
			cylinder { <0.7976, 77.2901, 2.4322>, <0.8608, 77.7949, 2.5614>, 0.07351 }
			cylinder { <0.8608, 77.7949, 2.5614>, <0.9067, 78.3001, 2.6963>, 0.07351 }
			cylinder { <0.9067, 78.3001, 2.6963>, <0.9352, 78.8051, 2.8365>, 0.07351 }
			cylinder { <0.9352, 78.8051, 2.8365>, <0.9462, 79.3093, 2.9818>, 0.07351 }
			cylinder { <0.9462, 79.3093, 2.9818>, <0.9398, 79.8121, 3.1322>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9398, 79.8121, 3.1322>, <0.9367, 79.8659, 3.147>, 0.07351 }
				cylinder { <0.9367, 79.8659, 3.147>, <0.9313, 79.9198, 3.1604>, 0.07351 }
				cylinder { <0.9313, 79.9198, 3.1604>, <0.9234, 79.9738, 3.1725>, 0.07351 }
				cylinder { <0.9234, 79.9738, 3.1725>, <0.9131, 80.02773, 3.1831>, 0.07351 }
				cylinder { <0.9131, 80.02773, 3.1831>, <0.9005, 80.08137, 3.1924>, 0.07351 }
				cylinder { <0.9005, 80.08137, 3.1924>, <0.8856, 80.1346, 3.2003>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.8856, 80.1346, 3.2003>, <1.128, 82.2322, 3.389>, <1.1648, 82.236, 3.6236> }
					triangle { <1.128, 82.2322, 3.389>, <1.429, 83.3521, 3.591>, <1.1648, 82.236, 3.6236> }
					triangle { <1.429, 83.3521, 3.591>, <1.4621, 83.3512, 3.8529>, <1.1648, 82.236, 3.6236> }
					triangle { <1.429, 83.3521, 3.591>, <1.8601, 84.9452, 4.2057>, <1.4621, 83.3512, 3.8529> }
					triangle { <1.4621, 83.3512, 3.8529>, <1.8601, 84.9452, 4.2057>, <1.3636, 83.2683, 4.08344> }
					triangle { <1.1648, 82.236, 3.6236>, <1.4621, 83.3512, 3.8529>, <1.3636, 83.2683, 4.08344> }
					triangle { <1.1648, 82.236, 3.6236>, <1.3636, 83.2683, 4.08344>, <1.09702, 82.1514, 3.8293> }
					triangle { <1.1648, 82.236, 3.6236>, <1.09702, 82.1514, 3.8293>, <0.8856, 80.1346, 3.2003> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9398, 79.8121, 3.1322>, <0.9499, 80.3125, 3.2901>, 0.07351 }
			cylinder { <0.9499, 80.3125, 3.2901>, <0.9763, 80.81, 3.4554>, 0.07351 }
			cylinder { <0.9763, 80.81, 3.4554>, <1.01915, 81.3039, 3.6277>, 0.07351 }
			cylinder { <1.01915, 81.3039, 3.6277>, <1.07828, 81.7936, 3.807>, 0.07351 }
			cylinder { <1.07828, 81.7936, 3.807>, <1.1536, 82.2786, 3.993>, 0.07351 }
			cylinder { <1.1536, 82.2786, 3.993>, <1.2452, 82.7582, 4.1855>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.2452, 82.7582, 4.1855>, <1.2558, 82.8081, 4.2083>, 0.07351 }
				cylinder { <1.2558, 82.8081, 4.2083>, <1.2672, 82.8567, 4.2334>, 0.07351 }
				cylinder { <1.2672, 82.8567, 4.2334>, <1.2795, 82.9039, 4.2607>, 0.07351 }
				cylinder { <1.2795, 82.9039, 4.2607>, <1.2925, 82.9496, 4.2901>, 0.07351 }
				cylinder { <1.2925, 82.9496, 4.2901>, <1.3063, 82.9936, 4.3216>, 0.07351 }
				cylinder { <1.3063, 82.9936, 4.3216>, <1.3208, 83.03594, 4.3552>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.3208, 83.03594, 4.3552>, <2.1501, 84.1649, 5.7056>, <2.2086, 84.3271, 5.5722> }
					triangle { <2.1501, 84.1649, 5.7056>, <2.5054, 84.9235, 6.3879>, <2.2086, 84.3271, 5.5722> }
					triangle { <2.5054, 84.9235, 6.3879>, <2.5741, 85.09811, 6.2345>, <2.2086, 84.3271, 5.5722> }
					triangle { <2.5054, 84.9235, 6.3879>, <3.125, 86.1999, 7.1626>, <2.5741, 85.09811, 6.2345> }
					triangle { <2.5741, 85.09811, 6.2345>, <3.125, 86.1999, 7.1626>, <2.6898, 85.1461, 6.02709> }
					triangle { <2.2086, 84.3271, 5.5722>, <2.5741, 85.09811, 6.2345>, <2.6898, 85.1461, 6.02709> }
					triangle { <2.2086, 84.3271, 5.5722>, <2.6898, 85.1461, 6.02709>, <2.2926, 84.3767, 5.3824> }
					triangle { <2.2086, 84.3271, 5.5722>, <2.2926, 84.3767, 5.3824>, <1.3208, 83.03594, 4.3552> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.2452, 82.7582, 4.1855>, <1.33, 83.245, 4.3626>, 0.07351 }
			cylinder { <1.33, 83.245, 4.3626>, <1.4081, 83.7382, 4.5241>, 0.07351 }
			cylinder { <1.4081, 83.7382, 4.5241>, <1.4793, 84.2374, 4.6698>, 0.07351 }
			cylinder { <1.4793, 84.2374, 4.6698>, <1.5436, 84.7419, 4.7995>, 0.07351 }
			cylinder { <1.5436, 84.7419, 4.7995>, <1.6009, 85.2511, 4.9131>, 0.07351 }
			cylinder { <1.6009, 85.2511, 4.9131>, <1.6511, 85.7644, 5.01049>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.6511, 85.7644, 5.01049>, <1.6574, 85.8194, 5.01832>, 0.07351 }
				cylinder { <1.6574, 85.8194, 5.01832>, <1.6648, 85.8745, 5.0236>, 0.07351 }
				cylinder { <1.6648, 85.8745, 5.0236>, <1.6731, 85.9297, 5.02632>, 0.07351 }
				cylinder { <1.6731, 85.9297, 5.02632>, <1.6824, 85.9848, 5.02648>, 0.07351 }
				cylinder { <1.6824, 85.9848, 5.02648>, <1.6926, 86.03973, 5.02406>, 0.07351 }
				cylinder { <1.6926, 86.03973, 5.02406>, <1.7037, 86.09425, 5.01908>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.7037, 86.09425, 5.01908>, <2.2585, 87.7756, 4.9909>, <2.1053, 87.8532, 5.09021> }
					triangle { <2.2585, 87.7756, 4.9909>, <2.5398, 88.7061, 5.1382>, <2.1053, 87.8532, 5.09021> }
					triangle { <2.5398, 88.7061, 5.1382>, <2.3647, 88.7888, 5.2437>, <2.1053, 87.8532, 5.09021> }
					triangle { <2.5398, 88.7061, 5.1382>, <2.7086, 90.1338, 5.45>, <2.3647, 88.7888, 5.2437> }
					triangle { <2.3647, 88.7888, 5.2437>, <2.7086, 90.1338, 5.45>, <2.1444, 88.7975, 5.2492> }
					triangle { <2.1053, 87.8532, 5.09021>, <2.3647, 88.7888, 5.2437>, <2.1444, 88.7975, 5.2492> }
					triangle { <2.1053, 87.8532, 5.09021>, <2.1444, 88.7975, 5.2492>, <1.9124, 87.8529, 5.1119> }
					triangle { <2.1053, 87.8532, 5.09021>, <1.9124, 87.8529, 5.1119>, <1.7037, 86.09425, 5.01908> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.6511, 85.7644, 5.01049>, <1.6953, 86.2748, 5.1247>, 0.07351 }
			cylinder { <1.6953, 86.2748, 5.1247>, <1.7335, 86.7816, 5.2558>, 0.07351 }
			cylinder { <1.7335, 86.7816, 5.2558>, <1.7656, 87.2842, 5.4036>, 0.07351 }
			cylinder { <1.7656, 87.2842, 5.4036>, <1.7916, 87.782, 5.5678>, 0.07351 }
			cylinder { <1.7916, 87.782, 5.5678>, <1.8114, 88.2745, 5.7483>, 0.07351 }
			cylinder { <1.8114, 88.2745, 5.7483>, <1.8251, 88.7609, 5.9449>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.8251, 88.7609, 5.9449>, <1.824, 88.8123, 5.9669>, 0.07351 }
				cylinder { <1.824, 88.8123, 5.9669>, <1.8205, 88.8631, 5.9899>, 0.07351 }
				cylinder { <1.8205, 88.8631, 5.9899>, <1.8146, 88.9132, 6.01392>, 0.07351 }
				cylinder { <1.8146, 88.9132, 6.01392>, <1.8061, 88.9625, 6.03883>, 0.07351 }
				cylinder { <1.8061, 88.9625, 6.03883>, <1.7952, 89.01089, 6.06459>, 0.07351 }
				cylinder { <1.7952, 89.01089, 6.06459>, <1.7819, 89.05822, 6.09113>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.7819, 89.05822, 6.09113>, <1.7399, 90.6363, 6.3186>, <1.8918, 90.6488, 6.412> }
					triangle { <1.7399, 90.6363, 6.3186>, <1.856, 91.5112, 6.3928>, <1.8918, 90.6488, 6.412> }
					triangle { <1.856, 91.5112, 6.3928>, <2.02251, 91.52, 6.5008>, <1.8918, 90.6488, 6.412> }
					triangle { <1.856, 91.5112, 6.3928>, <2.211, 92.7605, 6.655>, <2.02251, 91.52, 6.5008> }
					triangle { <2.02251, 91.52, 6.5008>, <2.211, 92.7605, 6.655>, <2.1196, 91.4447, 6.6569> }
					triangle { <1.8918, 90.6488, 6.412>, <2.02251, 91.52, 6.5008>, <2.1196, 91.4447, 6.6569> }
					triangle { <1.8918, 90.6488, 6.412>, <2.1196, 91.4447, 6.6569>, <1.9892, 90.5775, 6.5386> }
					triangle { <1.8918, 90.6488, 6.412>, <1.9892, 90.5775, 6.5386>, <1.7819, 89.05822, 6.09113> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <0.009365, 68.2486, -0.01562>, 0.07351 }
			cylinder { <0.009365, 68.2486, -0.01562>, <0.02809, 68.7722, -0.04684>, 0.07351 }
			cylinder { <0.02809, 68.7722, -0.04684>, <0.05615, 69.2942, -0.09361>, 0.07351 }
			cylinder { <0.05615, 69.2942, -0.09361>, <0.09353, 69.814, -0.1558>, 0.07351 }
			cylinder { <0.09353, 69.814, -0.1558>, <0.1401, 70.331, -0.2335>, 0.07351 }
			cylinder { <0.1401, 70.331, -0.2335>, <0.196, 70.8445, -0.3266>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.196, 70.8445, -0.3266>, <0.3684, 71.3261, -0.4441>, 0.07351 }
			cylinder { <0.3684, 71.3261, -0.4441>, <0.5242, 71.8143, -0.5574>, 0.07351 }
			cylinder { <0.5242, 71.8143, -0.5574>, <0.6635, 72.3085, -0.6664>, 0.07351 }
			cylinder { <0.6635, 72.3085, -0.6664>, <0.7859, 72.8081, -0.7709>, 0.07351 }
			cylinder { <0.7859, 72.8081, -0.7709>, <0.8913, 73.3124, -0.8709>, 0.07351 }
			cylinder { <0.8913, 73.3124, -0.8709>, <0.9797, 73.821, -0.9661>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9797, 73.821, -0.9661>, <0.9867, 73.8752, -0.9776>, 0.07351 }
				cylinder { <0.9867, 73.8752, -0.9776>, <0.9913, 73.9294, -0.9904>, 0.07351 }
				cylinder { <0.9913, 73.9294, -0.9904>, <0.9934, 73.9834, -1.004417>, 0.07351 }
				cylinder { <0.9934, 73.9834, -1.004417>, <0.9932, 74.03724, -1.01965>, 0.07351 }
				cylinder { <0.9932, 74.03724, -1.01965>, <0.9904, 74.09057, -1.03609>, 0.07351 }
				cylinder { <0.9904, 74.09057, -1.03609>, <0.9853, 74.1433, -1.05368>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.9853, 74.1433, -1.05368>, <0.9759, 75.7535, -1.7904>, <1.0545, 75.8509, -1.6365> }
					triangle { <0.9759, 75.7535, -1.7904>, <1.1295, 76.6539, -2.1543>, <1.0545, 75.8509, -1.6365> }
					triangle { <1.1295, 76.6539, -2.1543>, <1.2115, 76.7589, -1.9786>, <1.0545, 75.8509, -1.6365> }
					triangle { <1.1295, 76.6539, -2.1543>, <1.4195, 78.06689, -2.4434>, <1.2115, 76.7589, -1.9786> }
					triangle { <1.2115, 76.7589, -1.9786>, <1.4195, 78.06689, -2.4434>, <1.1909, 76.7913, -1.7614> }
					triangle { <1.0545, 75.8509, -1.6365>, <1.2115, 76.7589, -1.9786>, <1.1909, 76.7913, -1.7614> }
					triangle { <1.0545, 75.8509, -1.6365>, <1.1909, 76.7913, -1.7614>, <1.05354, 75.872, -1.4435> }
					triangle { <1.0545, 75.8509, -1.6365>, <1.05354, 75.872, -1.4435>, <0.9853, 74.1433, -1.05368> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9797, 73.821, -0.9661>, <1.08431, 74.3279, -1.0533>, 0.07351 }
			cylinder { <1.08431, 74.3279, -1.0533>, <1.2049, 74.8325, -1.1321>, 0.07351 }
			cylinder { <1.2049, 74.8325, -1.1321>, <1.3415, 75.3344, -1.2026>, 0.07351 }
			cylinder { <1.3415, 75.3344, -1.2026>, <1.4939, 75.8328, -1.2647>, 0.07351 }
			cylinder { <1.4939, 75.8328, -1.2647>, <1.6618, 76.3272, -1.3183>, 0.07351 }
			cylinder { <1.6618, 76.3272, -1.3183>, <1.8452, 76.8169, -1.3633>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.8452, 76.8169, -1.3633>, <1.8655, 76.8689, -1.3654>, 0.07351 }
				cylinder { <1.8655, 76.8689, -1.3654>, <1.8865, 76.9207, -1.365>, 0.07351 }
				cylinder { <1.8865, 76.9207, -1.365>, <1.9083, 76.972, -1.3619>, 0.07351 }
				cylinder { <1.9083, 76.972, -1.3619>, <1.9307, 77.02295, -1.3562>, 0.07351 }
				cylinder { <1.9307, 77.02295, -1.3562>, <1.9536, 77.0732, -1.3479>, 0.07351 }
				cylinder { <1.9536, 77.0732, -1.3479>, <1.9771, 77.1227, -1.337>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.9771, 77.1227, -1.337>, <2.1547, 78.7041, -1.4441>, <2.2648, 78.7041, -1.5849> }
					triangle { <2.1547, 78.7041, -1.4441>, <2.2178, 79.5639, -1.647>, <2.2648, 78.7041, -1.5849> }
					triangle { <2.2178, 79.5639, -1.647>, <2.3442, 79.5592, -1.8001>, <2.2648, 78.7041, -1.5849> }
					triangle { <2.2178, 79.5639, -1.647>, <2.4852, 80.7778, -2.1059>, <2.3442, 79.5592, -1.8001> }
					triangle { <2.3442, 79.5592, -1.8001>, <2.4852, 80.7778, -2.1059>, <2.5126, 79.4804, -1.87> }
					triangle { <2.2648, 78.7041, -1.5849>, <2.3442, 79.5592, -1.8001>, <2.5126, 79.4804, -1.87> }
					triangle { <2.2648, 78.7041, -1.5849>, <2.5126, 79.4804, -1.87>, <2.4038, 78.628, -1.6589> }
					triangle { <2.2648, 78.7041, -1.5849>, <2.4038, 78.628, -1.6589>, <1.9771, 77.1227, -1.337> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.196, 70.8445, -0.3266>, <0.2346, 71.3605, -0.4145>, 0.07351 }
			cylinder { <0.2346, 71.3605, -0.4145>, <0.2557, 71.8784, -0.4973>, 0.07351 }
			cylinder { <0.2557, 71.8784, -0.4973>, <0.2595, 72.3974, -0.5749>, 0.07351 }
			cylinder { <0.2595, 72.3974, -0.5749>, <0.2459, 72.9171, -0.6471>, 0.07351 }
			cylinder { <0.2459, 72.9171, -0.6471>, <0.2149, 73.4368, -0.7139>, 0.07351 }
			cylinder { <0.2149, 73.4368, -0.7139>, <0.1665, 73.9558, -0.7752>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.1665, 73.9558, -0.7752>, <0.01215, 74.4439, -0.8911>, 0.07351 }
			cylinder { <0.01215, 74.4439, -0.8911>, <-0.1265, 74.9382, -1.000217>, 0.07351 }
			cylinder { <-0.1265, 74.9382, -1.000217>, <-0.2493, 75.4381, -1.1023>, 0.07351 }
			cylinder { <-0.2493, 75.4381, -1.1023>, <-0.3562, 75.9432, -1.1973>, 0.07351 }
			cylinder { <-0.3562, 75.9432, -1.1973>, <-0.4469, 76.4526, -1.2852>, 0.07351 }
			cylinder { <-0.4469, 76.4526, -1.2852>, <-0.5214, 76.9659, -1.3657>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.5214, 76.9659, -1.3657>, <-0.5284, 77.02102, -1.3717>, 0.07351 }
				cylinder { <-0.5284, 77.02102, -1.3717>, <-0.5344, 77.07645, -1.3752>, 0.07351 }
				cylinder { <-0.5344, 77.07645, -1.3752>, <-0.5396, 77.132, -1.3761>, 0.07351 }
				cylinder { <-0.5396, 77.132, -1.3761>, <-0.5437, 77.1877, -1.3745>, 0.07351 }
				cylinder { <-0.5437, 77.1877, -1.3745>, <-0.5469, 77.2433, -1.3702>, 0.07351 }
				cylinder { <-0.5469, 77.2433, -1.3702>, <-0.5491, 77.2988, -1.3635>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.5491, 77.2988, -1.3635>, <-0.8585, 79.02396, -1.1109>, <-0.8045, 79.08484, -1.2918> }
					triangle { <-0.8585, 79.02396, -1.1109>, <-1.1175, 79.9724, -1.1107>, <-0.8045, 79.08484, -1.2918> }
					triangle { <-1.1175, 79.9724, -1.1107>, <-1.05083, 80.03624, -1.311>, <-0.8045, 79.08484, -1.2918> }
					triangle { <-1.1175, 79.9724, -1.1107>, <-1.3736, 81.4017, -1.3466>, <-1.05083, 80.03624, -1.311> }
					triangle { <-1.05083, 80.03624, -1.311>, <-1.3736, 81.4017, -1.3466>, <-0.8883, 80.02474, -1.4597> }
					triangle { <-0.8045, 79.08484, -1.2918>, <-1.05083, 80.03624, -1.311>, <-0.8883, 80.02474, -1.4597> }
					triangle { <-0.8045, 79.08484, -1.2918>, <-0.8883, 80.02474, -1.4597>, <-0.6738, 79.06641, -1.4342> }
					triangle { <-0.8045, 79.08484, -1.2918>, <-0.6738, 79.06641, -1.4342>, <-0.5491, 77.2988, -1.3635> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.5214, 76.9659, -1.3657>, <-0.6027, 77.4753, -1.4627>, 0.07351 }
			cylinder { <-0.6027, 77.4753, -1.4627>, <-0.6907, 77.9801, -1.576>, 0.07351 }
			cylinder { <-0.6907, 77.9801, -1.576>, <-0.7853, 78.4799, -1.7055>, 0.07351 }
			cylinder { <-0.7853, 78.4799, -1.7055>, <-0.8864, 78.9739, -1.851>, 0.07351 }
			cylinder { <-0.8864, 78.9739, -1.851>, <-0.9938, 79.4617, -2.01239>, 0.07351 }
			cylinder { <-0.9938, 79.4617, -2.01239>, <-1.1075, 79.9425, -2.1894>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.1075, 79.9425, -2.1894>, <-1.1184, 79.993, -2.2106>, 0.07351 }
				cylinder { <-1.1184, 79.993, -2.2106>, <-1.1282, 80.04277, -2.2342>, 0.07351 }
				cylinder { <-1.1282, 80.04277, -2.2342>, <-1.1369, 80.09153, -2.2601>, 0.07351 }
				cylinder { <-1.1369, 80.09153, -2.2601>, <-1.1443, 80.1392, -2.2882>, 0.07351 }
				cylinder { <-1.1443, 80.1392, -2.2882>, <-1.1505, 80.1857, -2.3185>, 0.07351 }
				cylinder { <-1.1505, 80.1857, -2.3185>, <-1.1554, 80.231, -2.3509>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.1554, 80.231, -2.3509>, <-1.1897, 81.7929, -2.6727>, <-1.3646, 81.8169, -2.6448> }
					triangle { <-1.1897, 81.7929, -2.6727>, <-1.2793, 82.6726, -2.7209>, <-1.3646, 81.8169, -2.6448> }
					triangle { <-1.2793, 82.6726, -2.7209>, <-1.475, 82.694, -2.6942>, <-1.3646, 81.8169, -2.6448> }
					triangle { <-1.2793, 82.6726, -2.7209>, <-1.6523, 83.9425, -2.7839>, <-1.475, 82.694, -2.6942> }
					triangle { <-1.475, 82.694, -2.6942>, <-1.6523, 83.9425, -2.7839>, <-1.6546, 82.6242, -2.7425> }
					triangle { <-1.3646, 81.8169, -2.6448>, <-1.475, 82.694, -2.6942>, <-1.6546, 82.6242, -2.7425> }
					triangle { <-1.3646, 81.8169, -2.6448>, <-1.6546, 82.6242, -2.7425>, <-1.5248, 81.7518, -2.6709> }
					triangle { <-1.3646, 81.8169, -2.6448>, <-1.5248, 81.7518, -2.6709>, <-1.1554, 80.231, -2.3509> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.1359, 5.8708, -0.2543>, 0.09076 }
			cylinder { <-0.1359, 5.8708, -0.2543>, <-0.4075, 11.7203, -0.7624>, 0.09076 }
			cylinder { <-0.4075, 11.7203, -0.7624>, <-0.8141, 17.5346, -1.523>, 0.09076 }
			cylinder { <-0.8141, 17.5346, -1.523>, <-1.3546, 23.2995, -2.5344>, 0.09076 }
			cylinder { <-1.3546, 23.2995, -2.5344>, <-2.02791, 29.0013, -3.7939>, 0.09076 }
			cylinder { <-2.02791, 29.0013, -3.7939>, <-2.8322, 34.626, -5.2987>, 0.09076 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-2.8322, 34.626, -5.2987>, <-3.03604, 36.3191, -5.7721>, 0.09076 }
				cylinder { <-3.03604, 36.3191, -5.7721>, <-3.2013, 38.01078, -6.2656>, 0.09076 }
				cylinder { <-3.2013, 38.01078, -6.2656>, <-3.328, 39.6998, -6.7789>, 0.09076 }
				cylinder { <-3.328, 39.6998, -6.7789>, <-3.416, 41.3852, -7.3115>, 0.09076 }
				cylinder { <-3.416, 41.3852, -7.3115>, <-3.4653, 43.06616, -7.8633>, 0.09076 }
				cylinder { <-3.4653, 43.06616, -7.8633>, <-3.4759, 44.7414, -8.434>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.4759, 44.7414, -8.434>, <-3.4934, 44.9212, -8.4864>, 0.002905 }
				cylinder { <-3.4934, 44.9212, -8.4864>, <-3.5273, 45.101, -8.5302>, 0.002905 }
				cylinder { <-3.5273, 45.101, -8.5302>, <-3.5771, 45.2791, -8.5648>, 0.002905 }
				cylinder { <-3.5771, 45.2791, -8.5648>, <-3.6424, 45.4537, -8.59>, 0.002905 }
				cylinder { <-3.6424, 45.4537, -8.59>, <-3.7225, 45.6232, -8.6054>, 0.002905 }
				cylinder { <-3.7225, 45.6232, -8.6054>, <-3.8167, 45.786, -8.6111>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.8167, 45.786, -8.6111>, <-5.05667, 47.1258, -8.6878>, <-4.9779, 47.2245, -8.6454> }
				triangle { <-5.05667, 47.1258, -8.6878>, <-5.8154, 47.8573, -8.5772>, <-4.9779, 47.2245, -8.6454> }
				triangle { <-5.8154, 47.8573, -8.5772>, <-5.7195, 47.9394, -8.5>, <-4.9779, 47.2245, -8.6454> }
				triangle { <-5.8154, 47.8573, -8.5772>, <-8.2674, 49.916, -7.7296>, <-5.7195, 47.9394, -8.5> }
				triangle { <-5.7195, 47.9394, -8.5>, <-8.2674, 49.916, -7.7296>, <-5.608, 48.0029, -8.4224> }
				triangle { <-4.9779, 47.2245, -8.6454>, <-5.7195, 47.9394, -8.5>, <-5.608, 48.0029, -8.4224> }
				triangle { <-4.9779, 47.2245, -8.6454>, <-5.608, 48.0029, -8.4224>, <-4.8803, 47.276, -8.5837> }
				triangle { <-4.9779, 47.2245, -8.6454>, <-4.8803, 47.276, -8.5837>, <-3.8167, 45.786, -8.6111> }
				triangle { <-9.572, 50.8998, -7.1099>, <-8.2674, 49.916, -7.7296>, <-8.4283, 49.7799, -7.7835> }
				triangle { <-5.608, 48.0029, -8.4224>, <-8.2674, 49.916, -7.7296>, <-8.1393, 50.02829, -7.5176> }
				triangle { <-5.8154, 47.8573, -8.5772>, <-8.4283, 49.7799, -7.7835>, <-8.2674, 49.916, -7.7296> }
				triangle { <-9.572, 50.8998, -7.1099>, <-8.1393, 50.02829, -7.5176>, <-8.2674, 49.916, -7.7296> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.4759, 44.7414, -8.434>, <-3.603, 46.3996, -9.03933>, 0.09076 }
				cylinder { <-3.603, 46.3996, -9.03933>, <-3.8459, 48.03281, -9.6766>, 0.09076 }
				cylinder { <-3.8459, 48.03281, -9.6766>, <-4.2036, 49.6329, -10.3429>, 0.09076 }
				cylinder { <-4.2036, 49.6329, -10.3429>, <-4.6742, 51.1923, -11.03513>, 0.09076 }
				cylinder { <-4.6742, 51.1923, -11.03513>, <-5.2554, 52.7034, -11.75>, 0.09076 }
				cylinder { <-5.2554, 52.7034, -11.75>, <-5.9443, 54.1588, -12.4844>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.9443, 54.1588, -12.4844>, <-6.001853, 54.3151, -12.572>, 0.002905 }
				cylinder { <-6.001853, 54.3151, -12.572>, <-6.04297, 54.4715, -12.6681>, 0.002905 }
				cylinder { <-6.04297, 54.4715, -12.6681>, <-6.06737, 54.6265, -12.7719>, 0.002905 }
				cylinder { <-6.06737, 54.6265, -12.7719>, <-6.07481, 54.7786, -12.8824>, 0.002905 }
				cylinder { <-6.07481, 54.7786, -12.8824>, <-6.06521, 54.9263, -12.9985>, 0.002905 }
				cylinder { <-6.06521, 54.9263, -12.9985>, <-6.03868, 55.06822, -13.1191>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-6.03868, 55.06822, -13.1191>, <-6.1758, 56.3968, -14.3658>, <-6.06184, 56.4594, -14.3368> }
				triangle { <-6.1758, 56.3968, -14.3658>, <-6.3397, 57.2506, -14.9719>, <-6.06184, 56.4594, -14.3368> }
				triangle { <-6.3397, 57.2506, -14.9719>, <-6.2283, 57.3174, -14.901>, <-6.06184, 56.4594, -14.3368> }
				triangle { <-6.3397, 57.2506, -14.9719>, <-7.1366, 60.1158, -16.4296>, <-6.2283, 57.3174, -14.901> }
				triangle { <-6.2283, 57.3174, -14.901>, <-7.1366, 60.1158, -16.4296>, <-6.1161, 57.3659, -14.8142> }
				triangle { <-6.06184, 56.4594, -14.3368>, <-6.2283, 57.3174, -14.901>, <-6.1161, 57.3659, -14.8142> }
				triangle { <-6.06184, 56.4594, -14.3368>, <-6.1161, 57.3659, -14.8142>, <-5.9651, 56.4952, -14.2638> }
				triangle { <-6.06184, 56.4594, -14.3368>, <-5.9651, 56.4952, -14.2638>, <-6.03868, 55.06822, -13.1191> }
				triangle { <-7.6565, 61.6724, -17.03011>, <-7.1366, 60.1158, -16.4296>, <-7.3353, 60.05276, -16.492> }
				triangle { <-6.1161, 57.3659, -14.8142>, <-7.1366, 60.1158, -16.4296>, <-7.004402, 60.2757, -16.2538> }
				triangle { <-6.3397, 57.2506, -14.9719>, <-7.3353, 60.05276, -16.492>, <-7.1366, 60.1158, -16.4296> }
				triangle { <-7.6565, 61.6724, -17.03011>, <-7.004402, 60.2757, -16.2538>, <-7.1366, 60.1158, -16.4296> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.9443, 54.1588, -12.4844>, <-6.5968, 55.6193, -13.2418>, 0.09076 }
				cylinder { <-6.5968, 55.6193, -13.2418>, <-7.2122, 57.08408, -14.0216>, 0.09076 }
				cylinder { <-7.2122, 57.08408, -14.0216>, <-7.7904, 58.5521, -14.8234>, 0.09076 }
				cylinder { <-7.7904, 58.5521, -14.8234>, <-8.3309, 60.02258, -15.6467>, 0.09076 }
				cylinder { <-8.3309, 60.02258, -15.6467>, <-8.8335, 61.4945, -16.491>, 0.09076 }
				cylinder { <-8.8335, 61.4945, -16.491>, <-9.2977, 62.9672, -17.3559>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-9.2977, 62.9672, -17.3559>, <-9.3671, 63.1225, -17.4364>, 0.002905 }
				cylinder { <-9.3671, 63.1225, -17.4364>, <-9.4554, 63.2741, -17.5043>, 0.002905 }
				cylinder { <-9.4554, 63.2741, -17.5043>, <-9.5613, 63.4198, -17.5585>, 0.002905 }
				cylinder { <-9.5613, 63.4198, -17.5585>, <-9.6833, 63.5574, -17.5982>, 0.002905 }
				cylinder { <-9.6833, 63.5574, -17.5982>, <-9.8194, 63.6849, -17.6228>, 0.002905 }
				cylinder { <-9.8194, 63.6849, -17.6228>, <-9.9678, 63.8002, -17.632>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.9678, 63.8002, -17.632>, <-11.6201, 64.579, -17.6724>, <-11.5804, 64.7045, -17.6519> }
				triangle { <-11.6201, 64.579, -17.6724>, <-12.5837, 64.9975, -17.5327>, <-11.5804, 64.7045, -17.6519> }
				triangle { <-12.5837, 64.9975, -17.5327>, <-12.5188, 65.119, -17.4787>, <-11.5804, 64.7045, -17.6519> }
				triangle { <-12.5837, 64.9975, -17.5327>, <-15.538, 66.1414, -16.5671>, <-12.5188, 65.119, -17.4787> }
				triangle { <-12.5188, 65.119, -17.4787>, <-15.538, 66.1414, -16.5671>, <-12.4324, 65.229, -17.4246> }
				triangle { <-11.5804, 64.7045, -17.6519>, <-12.5188, 65.119, -17.4787>, <-12.4324, 65.229, -17.4246> }
				triangle { <-11.5804, 64.7045, -17.6519>, <-12.4324, 65.229, -17.4246>, <-11.5039, 64.7961, -17.6102> }
				triangle { <-11.5804, 64.7045, -17.6519>, <-11.5039, 64.7961, -17.6102>, <-9.9678, 63.8002, -17.632> }
				triangle { <-17.05263, 66.6723, -15.8756>, <-15.538, 66.1414, -16.5671>, <-15.6406, 65.9502, -16.5834> }
				triangle { <-12.4324, 65.229, -17.4246>, <-15.538, 66.1414, -16.5671>, <-15.4421, 66.3223, -16.388> }
				triangle { <-12.5837, 64.9975, -17.5327>, <-15.6406, 65.9502, -16.5834>, <-15.538, 66.1414, -16.5671> }
				triangle { <-17.05263, 66.6723, -15.8756>, <-15.4421, 66.3223, -16.388>, <-15.538, 66.1414, -16.5671> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-9.2977, 62.9672, -17.3559>, <-9.6677, 64.4622, -18.228>, 0.09076 }
				cylinder { <-9.6677, 64.4622, -18.228>, <-9.9424, 65.975, -19.1045>, 0.09076 }
				cylinder { <-9.9424, 65.975, -19.1045>, <-10.1209, 67.5011, -19.9828>, 0.09076 }
				cylinder { <-10.1209, 67.5011, -19.9828>, <-10.2027, 69.03593, -20.8603>, 0.09076 }
				cylinder { <-10.2027, 69.03593, -20.8603>, <-10.1875, 70.5749, -21.7341>, 0.09076 }
				cylinder { <-10.1875, 70.5749, -21.7341>, <-10.07546, 72.1134, -22.6017>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-10.07546, 72.1134, -22.6017>, <-10.03427, 72.2666, -22.7028>, 0.002905 }
				cylinder { <-10.03427, 72.2666, -22.7028>, <-9.965, 72.405, -22.8098>, 0.002905 }
				cylinder { <-9.965, 72.405, -22.8098>, <-9.8697, 72.5244, -22.9196>, 0.002905 }
				cylinder { <-9.8697, 72.5244, -22.9196>, <-9.7512, 72.6215, -23.02888>, 0.002905 }
				cylinder { <-9.7512, 72.6215, -23.02888>, <-9.613, 72.6933, -23.1344>, 0.002905 }
				cylinder { <-9.613, 72.6933, -23.1344>, <-9.4592, 72.7376, -23.2331>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-9.4592, 72.7376, -23.2331>, <-8.231, 73.342, -24.4434>, <-8.1232, 73.3293, -24.3662> }
				triangle { <-8.231, 73.342, -24.4434>, <-7.5534, 73.8438, -25.08533>, <-8.1232, 73.3293, -24.3662> }
				triangle { <-7.5534, 73.8438, -25.08533>, <-7.4577, 73.8504, -24.9726>, <-8.1232, 73.3293, -24.3662> }
				triangle { <-7.5534, 73.8438, -25.08533>, <-5.6237, 75.8772, -26.8491>, <-7.4577, 73.8504, -24.9726> }
				triangle { <-7.4577, 73.8504, -24.9726>, <-5.6237, 75.8772, -26.8491>, <-7.3792, 73.849, -24.8449> }
				triangle { <-8.1232, 73.3293, -24.3662>, <-7.4577, 73.8504, -24.9726>, <-7.3792, 73.849, -24.8449> }
				triangle { <-8.1232, 73.3293, -24.3662>, <-7.3792, 73.849, -24.8449>, <-8.05918, 73.323, -24.2574> }
				triangle { <-8.1232, 73.3293, -24.3662>, <-8.05918, 73.323, -24.2574>, <-9.4592, 72.7376, -23.2331> }
				triangle { <-4.693, 77.1009, -27.6799>, <-5.6237, 75.8772, -26.8491>, <-5.776, 75.9283, -26.9957> }
				triangle { <-7.3792, 73.849, -24.8449>, <-5.6237, 75.8772, -26.8491>, <-5.4838, 75.9754, -26.6375> }
				triangle { <-7.5534, 73.8438, -25.08533>, <-5.776, 75.9283, -26.9957>, <-5.6237, 75.8772, -26.8491> }
				triangle { <-4.693, 77.1009, -27.6799>, <-5.4838, 75.9754, -26.6375>, <-5.6237, 75.8772, -26.8491> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-10.07546, 72.1134, -22.6017>, <-9.8668, 73.6468, -23.4604>, 0.09076 }
				cylinder { <-9.8668, 73.6468, -23.4604>, <-9.5622, 75.1706, -24.3075>, 0.09076 }
				cylinder { <-9.5622, 75.1706, -24.3075>, <-9.1626, 76.6802, -25.1404>, 0.09076 }
				cylinder { <-9.1626, 76.6802, -25.1404>, <-8.6691, 78.1711, -25.9566>, 0.09076 }
				cylinder { <-8.6691, 78.1711, -25.9566>, <-8.08346, 79.6387, -26.7536>, 0.09076 }
				cylinder { <-8.08346, 79.6387, -26.7536>, <-7.4071, 81.07888, -27.5288>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-7.4071, 81.07888, -27.5288>, <-7.3513, 81.2403, -27.6076>, 0.002905 }
				cylinder { <-7.3513, 81.2403, -27.6076>, <-7.312, 81.4086, -27.6819>, 0.002905 }
				cylinder { <-7.312, 81.4086, -27.6819>, <-7.2897, 81.5821, -27.7511>, 0.002905 }
				cylinder { <-7.2897, 81.5821, -27.7511>, <-7.2845, 81.7592, -27.8145>, 0.002905 }
				cylinder { <-7.2845, 81.7592, -27.8145>, <-7.2965, 81.9381, -27.8715>, 0.002905 }
				cylinder { <-7.2965, 81.9381, -27.8715>, <-7.3257, 82.1171, -27.9215>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.3257, 82.1171, -27.9215>, <-7.9871, 83.7278, -28.4749>, <-7.8882, 83.8039, -28.4282> }
				triangle { <-7.9871, 83.7278, -28.4749>, <-8.4514, 84.6642, -28.6503>, <-7.8882, 83.8039, -28.4282> }
				triangle { <-8.4514, 84.6642, -28.6503>, <-8.3489, 84.7267, -28.5639>, <-7.8882, 83.8039, -28.4282> }
				triangle { <-8.4514, 84.6642, -28.6503>, <-10.1477, 87.5083, -28.7051>, <-8.3489, 84.7267, -28.5639> }
				triangle { <-8.3489, 84.7267, -28.5639>, <-10.1477, 87.5083, -28.7051>, <-8.2386, 84.7673, -28.4708> }
				triangle { <-7.8882, 83.8039, -28.4282>, <-8.3489, 84.7267, -28.5639>, <-8.2386, 84.7673, -28.4708> }
				triangle { <-7.8882, 83.8039, -28.4282>, <-8.2386, 84.7673, -28.4708>, <-7.7919, 83.8343, -28.3522> }
				triangle { <-7.8882, 83.8039, -28.4282>, <-7.7919, 83.8343, -28.3522>, <-7.3257, 82.1171, -27.9215> }
				triangle { <-11.1198, 88.9529, -28.5573>, <-10.1477, 87.5083, -28.7051>, <-10.333, 87.4205, -28.7777> }
				triangle { <-8.2386, 84.7673, -28.4708>, <-10.1477, 87.5083, -28.7051>, <-10.02978, 87.6168, -28.4854> }
				triangle { <-8.4514, 84.6642, -28.6503>, <-10.333, 87.4205, -28.7777>, <-10.1477, 87.5083, -28.7051> }
				triangle { <-11.1198, 88.9529, -28.5573>, <-10.02978, 87.6168, -28.4854>, <-10.1477, 87.5083, -28.7051> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-7.4071, 81.07888, -27.5288>, <-6.7308, 82.5189, -28.3041>, 0.09076 }
				cylinder { <-6.7308, 82.5189, -28.3041>, <-6.0546, 83.959, -29.07944>, 0.09076 }
				cylinder { <-6.0546, 83.959, -29.07944>, <-5.3783, 85.3991, -29.8547>, 0.09076 }
				cylinder { <-5.3783, 85.3991, -29.8547>, <-4.702, 86.8392, -30.6299>, 0.09076 }
				cylinder { <-4.702, 86.8392, -30.6299>, <-4.02575, 88.2793, -31.4052>, 0.09076 }
				cylinder { <-4.02575, 88.2793, -31.4052>, <-3.3494, 89.7194, -32.1805>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.3494, 89.7194, -32.1805>, <-3.2548, 89.8572, -32.2669>, 0.002905 }
				cylinder { <-3.2548, 89.8572, -32.2669>, <-3.1396, 89.9766, -32.3554>, 0.002905 }
				cylinder { <-3.1396, 89.9766, -32.3554>, <-3.006211, 90.07525, -32.4442>, 0.002905 }
				cylinder { <-3.006211, 90.07525, -32.4442>, <-2.8575, 90.1508, -32.5312>, 0.002905 }
				cylinder { <-2.8575, 90.1508, -32.5312>, <-2.6967, 90.2017, -32.6147>, 0.002905 }
				cylinder { <-2.6967, 90.2017, -32.6147>, <-2.5274, 90.2268, -32.6927>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.5274, 90.2268, -32.6927>, <-1.08807, 90.7013, -33.7132>, <-0.9932, 90.6663, -33.6264> }
				triangle { <-1.08807, 90.7013, -33.7132>, <-0.271, 91.1273, -34.2367>, <-0.9932, 90.6663, -33.6264> }
				triangle { <-0.271, 91.1273, -34.2367>, <-0.1892, 91.1109, -34.1144>, <-0.9932, 90.6663, -33.6264> }
				triangle { <-0.271, 91.1273, -34.2367>, <2.1412, 92.9311, -35.6139>, <-0.1892, 91.1109, -34.1144> }
				triangle { <-0.1892, 91.1109, -34.1144>, <2.1412, 92.9311, -35.6139>, <-0.1274, 91.08855, -33.9797> }
				triangle { <-0.9932, 90.6663, -33.6264>, <-0.1892, 91.1109, -34.1144>, <-0.1274, 91.08855, -33.9797> }
				triangle { <-0.9932, 90.6663, -33.6264>, <-0.1274, 91.08855, -33.9797>, <-0.944, 90.6427, -33.5124> }
				triangle { <-0.9932, 90.6663, -33.6264>, <-0.944, 90.6427, -33.5124>, <-2.5274, 90.2268, -32.6927> }
				triangle { <3.3397, 94.03898, -36.2384>, <2.1412, 92.9311, -35.6139>, <2.01673, 93.01566, -35.771> }
				triangle { <-0.1274, 91.08855, -33.9797>, <2.1412, 92.9311, -35.6139>, <2.2689, 92.9912, -35.3815> }
				triangle { <-0.271, 91.1273, -34.2367>, <2.01673, 93.01566, -35.771>, <2.1412, 92.9311, -35.6139> }
				triangle { <3.3397, 94.03898, -36.2384>, <2.2689, 92.9912, -35.3815>, <2.1412, 92.9311, -35.6139> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.3494, 89.7194, -32.1805>, <-2.7799, 91.1725, -33.01513>, 0.09076 }
				cylinder { <-2.7799, 91.1725, -33.01513>, <-2.3198, 92.6314, -33.9051>, 0.09076 }
				cylinder { <-2.3198, 92.6314, -33.9051>, <-1.9714, 94.08921, -34.8463>, 0.09076 }
				cylinder { <-1.9714, 94.08921, -34.8463>, <-1.7361, 95.5386, -35.8343>, 0.09076 }
				cylinder { <-1.7361, 95.5386, -35.8343>, <-1.6152, 96.9726, -36.8644>, 0.09076 }
				cylinder { <-1.6152, 96.9726, -36.8644>, <-1.6092, 98.3843, -37.9319>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.6092, 98.3843, -37.9319>, <-1.6378, 98.5402, -38.03323>, 0.002905 }
				cylinder { <-1.6378, 98.5402, -38.03323>, <-1.695, 98.6974, -38.1193>, 0.002905 }
				cylinder { <-1.695, 98.6974, -38.1193>, <-1.7789, 98.8512, -38.1877>, 0.002905 }
				cylinder { <-1.7789, 98.8512, -38.1877>, <-1.8872, 98.9972, -38.2365>, 0.002905 }
				cylinder { <-1.8872, 98.9972, -38.2365>, <-2.01659, 99.1309, -38.264>, 0.002905 }
				cylinder { <-2.01659, 99.1309, -38.264>, <-2.1632, 99.2486, -38.2696>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.1632, 99.2486, -38.2696>, <-3.8039, 100.0528, -38.27>, <-3.7618, 100.1777, -38.2505> }
				triangle { <-3.8039, 100.0528, -38.27>, <-4.7571, 100.4861, -38.107>, <-3.7618, 100.1777, -38.2505> }
				triangle { <-4.7571, 100.4861, -38.107>, <-4.6891, 100.6066, -38.05469>, <-3.7618, 100.1777, -38.2505> }
				triangle { <-4.7571, 100.4861, -38.107>, <-7.6691, 101.6754, -37.07015>, <-4.6891, 100.6066, -38.05469> }
				triangle { <-4.6891, 100.6066, -38.05469>, <-7.6691, 101.6754, -37.07015>, <-4.5998, 100.7153, -38.00267> }
				triangle { <-3.7618, 100.1777, -38.2505>, <-4.6891, 100.6066, -38.05469>, <-4.5998, 100.7153, -38.00267> }
				triangle { <-3.7618, 100.1777, -38.2505>, <-4.5998, 100.7153, -38.00267>, <-3.6828, 100.2681, -38.2107> }
				triangle { <-3.7618, 100.1777, -38.2505>, <-3.6828, 100.2681, -38.2107>, <-2.1632, 99.2486, -38.2696> }
				triangle { <-9.1581, 102.2295, -36.3422>, <-7.6691, 101.6754, -37.07015>, <-7.775, 101.4858, -37.08394> }
				triangle { <-4.5998, 100.7153, -38.00267>, <-7.6691, 101.6754, -37.07015>, <-7.5661, 101.8547, -36.8935> }
				triangle { <-4.7571, 100.4861, -38.107>, <-7.775, 101.4858, -37.08394>, <-7.6691, 101.6754, -37.07015> }
				triangle { <-9.1581, 102.2295, -36.3422>, <-7.5661, 101.8547, -36.8935>, <-7.6691, 101.6754, -37.07015> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.6092, 98.3843, -37.9319>, <-1.7357, 99.7407, -39.06166>, 0.09076 }
				cylinder { <-1.7357, 99.7407, -39.06166>, <-1.9937, 101.0313, -40.245>, 0.09076 }
				cylinder { <-1.9937, 101.0313, -40.245>, <-2.3809, 102.2457, -41.4728>, 0.09076 }
				cylinder { <-2.3809, 102.2457, -41.4728>, <-2.8943, 103.3742, -42.7359>, 0.09076 }
				cylinder { <-2.8943, 103.3742, -42.7359>, <-3.5295, 104.4079, -44.02438>, 0.09076 }
				cylinder { <-3.5295, 104.4079, -44.02438>, <-4.2816, 105.3386, -45.3284>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.2816, 105.3386, -45.3284>, <-4.3495, 105.4367, -45.4738>, 0.002905 }
				cylinder { <-4.3495, 105.4367, -45.4738>, <-4.4051, 105.5333, -45.6254>, 0.002905 }
				cylinder { <-4.4051, 105.5333, -45.6254>, <-4.448, 105.6281, -45.7821>, 0.002905 }
				cylinder { <-4.448, 105.6281, -45.7821>, <-4.478, 105.7203, -45.9433>, 0.002905 }
				cylinder { <-4.478, 105.7203, -45.9433>, <-4.4949, 105.8097, -46.108>, 0.002905 }
				cylinder { <-4.4949, 105.8097, -46.108>, <-4.4987, 105.8956, -46.2753>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.4987, 105.8956, -46.2753>, <-4.9174, 106.5961, -47.91>, <-4.8155, 106.6814, -47.9188> }
				triangle { <-4.9174, 106.5961, -47.91>, <-5.2538, 107.1107, -48.7732>, <-4.8155, 106.6814, -47.9188> }
				triangle { <-5.2538, 107.1107, -48.7732>, <-5.1536, 107.2159, -48.7447>, <-4.8155, 106.6814, -47.9188> }
				triangle { <-5.2538, 107.1107, -48.7732>, <-6.6042, 109.0252, -51.1142>, <-5.1536, 107.2159, -48.7447> }
				triangle { <-5.1536, 107.2159, -48.7447>, <-6.6042, 109.0252, -51.1142>, <-5.0489, 107.3108, -48.6947> }
				triangle { <-4.8155, 106.6814, -47.9188>, <-5.1536, 107.2159, -48.7447>, <-5.0489, 107.3108, -48.6947> }
				triangle { <-4.8155, 106.6814, -47.9188>, <-5.0489, 107.3108, -48.6947>, <-4.7241, 106.757, -47.875> }
				triangle { <-4.8155, 106.6814, -47.9188>, <-4.7241, 106.757, -47.875>, <-4.4987, 105.8956, -46.2753> }
				triangle { <-7.4162, 110.1268, -52.2009>, <-6.6042, 109.0252, -51.1142>, <-6.7905, 108.9136, -51.1274> }
				triangle { <-5.0489, 107.3108, -48.6947>, <-6.6042, 109.0252, -51.1142>, <-6.4963, 109.259, -51.02655> }
				triangle { <-5.2538, 107.1107, -48.7732>, <-6.7905, 108.9136, -51.1274>, <-6.6042, 109.0252, -51.1142> }
				triangle { <-7.4162, 110.1268, -52.2009>, <-6.4963, 109.259, -51.02655>, <-6.6042, 109.0252, -51.1142> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-4.2816, 105.3386, -45.3284>, <-4.3693, 105.4378, -45.462>, 0.002905 }
				cylinder { <-4.3693, 105.4378, -45.462>, <-4.4646, 105.5371, -45.5903>, 0.002905 }
				cylinder { <-4.4646, 105.5371, -45.5903>, <-4.5671, 105.6362, -45.713>, 0.002905 }
				cylinder { <-4.5671, 105.6362, -45.713>, <-4.6768, 105.7348, -45.8298>, 0.002905 }
				cylinder { <-4.6768, 105.7348, -45.8298>, <-4.7933, 105.8328, -45.9404>, 0.002905 }
				cylinder { <-4.7933, 105.8328, -45.9404>, <-4.9163, 105.9298, -46.04452>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.9163, 105.9298, -46.04452>, <-6.3797, 106.6133, -46.8986>, <-6.3258, 106.7298, -46.9345> }
				triangle { <-6.3797, 106.6133, -46.8986>, <-7.2726, 107.0675, -47.2443>, <-6.3258, 106.7298, -46.9345> }
				triangle { <-7.2726, 107.0675, -47.2443>, <-7.2019, 107.1975, -47.244>, <-6.3258, 106.7298, -46.9345> }
				triangle { <-7.2726, 107.0675, -47.2443>, <-10.1441, 108.6248, -47.791>, <-7.2019, 107.1975, -47.244> }
				triangle { <-7.2019, 107.1975, -47.244>, <-10.1441, 108.6248, -47.791>, <-7.1125, 107.3173, -47.2322> }
				triangle { <-6.3258, 106.7298, -46.9345>, <-7.2019, 107.1975, -47.244>, <-7.1125, 107.3173, -47.2322> }
				triangle { <-6.3258, 106.7298, -46.9345>, <-7.1125, 107.3173, -47.2322>, <-6.2461, 106.8275, -46.9263> }
				triangle { <-6.3258, 106.7298, -46.9345>, <-6.2461, 106.8275, -46.9263>, <-4.9163, 105.9298, -46.04452> }
				triangle { <-11.6657, 109.4793, -47.8814>, <-10.1441, 108.6248, -47.791>, <-10.27, 108.4564, -47.735> }
				triangle { <-7.1125, 107.3173, -47.2322>, <-10.1441, 108.6248, -47.791>, <-10.06012, 108.8703, -47.7094> }
				triangle { <-7.2726, 107.0675, -47.2443>, <-10.27, 108.4564, -47.735>, <-10.1441, 108.6248, -47.791> }
				triangle { <-11.6657, 109.4793, -47.8814>, <-10.06012, 108.8703, -47.7094>, <-10.1441, 108.6248, -47.791> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1359, 5.8708, 0.2543>, 0.09076 }
			cylinder { <0.1359, 5.8708, 0.2543>, <0.4075, 11.7203, 0.7624>, 0.09076 }
			cylinder { <0.4075, 11.7203, 0.7624>, <0.8141, 17.5346, 1.523>, 0.09076 }
			cylinder { <0.8141, 17.5346, 1.523>, <1.3546, 23.2995, 2.5344>, 0.09076 }
			cylinder { <1.3546, 23.2995, 2.5344>, <2.02791, 29.0013, 3.7939>, 0.09076 }
			cylinder { <2.02791, 29.0013, 3.7939>, <2.8322, 34.626, 5.2987>, 0.09076 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.8322, 34.626, 5.2987>, <2.9779, 36.3297, 5.7554>, 0.09076 }
				cylinder { <2.9779, 36.3297, 5.7554>, <3.0266, 38.03839, 6.2142>, 0.09076 }
				cylinder { <3.0266, 38.03839, 6.2142>, <2.9781, 39.7468, 6.6738>, 0.09076 }
				cylinder { <2.9781, 39.7468, 6.6738>, <2.8328, 41.4499, 7.1326>, 0.09076 }
				cylinder { <2.8328, 41.4499, 7.1326>, <2.5909, 43.1426, 7.5893>, 0.09076 }
				cylinder { <2.5909, 43.1426, 7.5893>, <2.2532, 44.8198, 8.04238>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.2532, 44.8198, 8.04238>, <2.2295, 45.00156, 8.08498>, 0.002905 }
				cylinder { <2.2295, 45.00156, 8.08498>, <2.2182, 45.1857, 8.1218>, 0.002905 }
				cylinder { <2.2182, 45.1857, 8.1218>, <2.2192, 45.3712, 8.1526>, 0.002905 }
				cylinder { <2.2192, 45.3712, 8.1526>, <2.2327, 45.5573, 8.1772>, 0.002905 }
				cylinder { <2.2327, 45.5573, 8.1772>, <2.2585, 45.7427, 8.1956>, 0.002905 }
				cylinder { <2.2585, 45.7427, 8.1956>, <2.2965, 45.9266, 8.2076>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.2965, 45.9266, 8.2076>, <2.9879, 47.6093, 8.377>, <2.884, 47.6757, 8.3267> }
				triangle { <2.9879, 47.6093, 8.377>, <3.455, 48.5591, 8.3247>, <2.884, 47.6757, 8.3267> }
				triangle { <3.455, 48.5591, 8.3247>, <3.3437, 48.6047, 8.2385>, <2.884, 47.6757, 8.3267> }
				triangle { <3.455, 48.5591, 8.3247>, <5.1116, 51.3515, 7.6708>, <3.3437, 48.6047, 8.2385> }
				triangle { <3.3437, 48.6047, 8.2385>, <5.1116, 51.3515, 7.6708>, <3.2243, 48.6274, 8.1507> }
				triangle { <2.884, 47.6757, 8.3267>, <3.3437, 48.6047, 8.2385>, <3.2243, 48.6274, 8.1507> }
				triangle { <2.884, 47.6757, 8.3267>, <3.2243, 48.6274, 8.1507>, <2.7803, 47.6916, 8.2562> }
				triangle { <2.884, 47.6757, 8.3267>, <2.7803, 47.6916, 8.2562>, <2.2965, 45.9266, 8.2076> }
				triangle { <6.0459, 52.7357, 7.1562>, <5.1116, 51.3515, 7.6708>, <5.3043, 51.278, 7.7402> }
				triangle { <3.2243, 48.6274, 8.1507>, <5.1116, 51.3515, 7.6708>, <4.9713, 51.4169, 7.4472> }
				triangle { <3.455, 48.5591, 8.3247>, <5.3043, 51.278, 7.7402>, <5.1116, 51.3515, 7.6708> }
				triangle { <6.0459, 52.7357, 7.1562>, <4.9713, 51.4169, 7.4472>, <5.1116, 51.3515, 7.6708> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.2532, 44.8198, 8.04238>, <1.8776, 46.4842, 8.5123>, 0.09076 }
				cylinder { <1.8776, 46.4842, 8.5123>, <1.4642, 48.1349, 8.9989>, 0.09076 }
				cylinder { <1.4642, 48.1349, 8.9989>, <1.01352, 49.7708, 9.5018>, 0.09076 }
				cylinder { <1.01352, 49.7708, 9.5018>, <0.5255, 51.391, 10.02077>, 0.09076 }
				cylinder { <0.5255, 51.391, 10.02077>, <0.0007431, 52.9944, 10.5554>, 0.09076 }
				cylinder { <0.0007431, 52.9944, 10.5554>, <-0.5606, 54.5802, 11.1054>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.5606, 54.5802, 11.1054>, <-0.6428, 54.7354, 11.1729>, 0.002905 }
				cylinder { <-0.6428, 54.7354, 11.1729>, <-0.7456, 54.8738, 11.2479>, 0.002905 }
				cylinder { <-0.7456, 54.8738, 11.2479>, <-0.867, 54.9926, 11.329>, 0.002905 }
				cylinder { <-0.867, 54.9926, 11.329>, <-1.004267, 55.08905, 11.4142>, 0.002905 }
				cylinder { <-1.004267, 55.08905, 11.4142>, <-1.1543, 55.1611, 11.5018>, 0.002905 }
				cylinder { <-1.1543, 55.1611, 11.5018>, <-1.314, 55.2072, 11.5898>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-1.314, 55.2072, 11.5898>, <-2.6688, 55.8776, 12.6162>, <-2.7702, 55.8285, 12.545> }
				triangle { <-2.6688, 55.8776, 12.6162>, <-3.4427, 56.4019, 13.1154>, <-2.7702, 55.8285, 12.545> }
				triangle { <-3.4427, 56.4019, 13.1154>, <-3.5339, 56.3645, 13.00513>, <-2.7702, 55.8285, 12.545> }
				triangle { <-3.4427, 56.4019, 13.1154>, <-5.7424, 58.4561, 14.3243>, <-3.5339, 56.3645, 13.00513> }
				triangle { <-3.5339, 56.3645, 13.00513>, <-5.7424, 58.4561, 14.3243>, <-3.6062, 56.3185, 12.882> }
				triangle { <-2.7702, 55.8285, 12.545>, <-3.5339, 56.3645, 13.00513>, <-3.6062, 56.3185, 12.882> }
				triangle { <-2.7702, 55.8285, 12.545>, <-3.6062, 56.3185, 12.882>, <-2.8282, 55.785, 12.4415> }
				triangle { <-2.7702, 55.8285, 12.545>, <-2.8282, 55.785, 12.4415>, <-1.314, 55.2072, 11.5898> }
				triangle { <-6.8903, 59.6738, 14.8276>, <-5.7424, 58.4561, 14.3243>, <-5.606, 58.5664, 14.453> }
				triangle { <-3.6062, 56.3185, 12.882>, <-5.7424, 58.4561, 14.3243>, <-5.8883, 58.4743, 14.09564> }
				triangle { <-3.4427, 56.4019, 13.1154>, <-5.606, 58.5664, 14.453>, <-5.7424, 58.4561, 14.3243> }
				triangle { <-6.8903, 59.6738, 14.8276>, <-5.8883, 58.4743, 14.09564>, <-5.7424, 58.4561, 14.3243> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.5606, 54.5802, 11.1054>, <-0.9894, 56.1765, 11.7379>, 0.09076 }
				cylinder { <-0.9894, 56.1765, 11.7379>, <-1.2825, 57.7708, 12.4483>, 0.09076 }
				cylinder { <-1.2825, 57.7708, 12.4483>, <-1.4376, 59.3505, 13.2311>, 0.09076 }
				cylinder { <-1.4376, 59.3505, 13.2311>, <-1.4536, 60.9031, 14.0806>, 0.09076 }
				cylinder { <-1.4536, 60.9031, 14.0806>, <-1.3306, 62.4163, 14.9901>, 0.09076 }
				cylinder { <-1.3306, 62.4163, 14.9901>, <-1.0697, 63.8782, 15.953>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.0697, 63.8782, 15.953>, <-1.01061, 64.03632, 16.03613>, 0.002905 }
				cylinder { <-1.01061, 64.03632, 16.03613>, <-0.9224, 64.191, 16.09682>, 0.002905 }
				cylinder { <-0.9224, 64.191, 16.09682>, <-0.8085, 64.3364, 16.1327>, 0.002905 }
				cylinder { <-0.8085, 64.3364, 16.1327>, <-0.6733, 64.4668, 16.1425>, 0.002905 }
				cylinder { <-0.6733, 64.4668, 16.1425>, <-0.522, 64.5774, 16.1258>, 0.002905 }
				cylinder { <-0.522, 64.5774, 16.1258>, <-0.3604, 64.6638, 16.0832>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.3604, 64.6638, 16.0832>, <1.332, 65.1846, 15.6333>, <1.3043, 65.3123, 15.607> }
				triangle { <1.332, 65.1846, 15.6333>, <2.2735, 65.4383, 15.2182>, <1.3043, 65.3123, 15.607> }
				triangle { <2.2735, 65.4383, 15.2182>, <2.2126, 65.5627, 15.1662>, <1.3043, 65.3123, 15.607> }
				triangle { <2.2735, 65.4383, 15.2182>, <5.007918, 66.02954, 13.4454>, <2.2126, 65.5627, 15.1662> }
				triangle { <2.2126, 65.5627, 15.1662>, <5.007918, 66.02954, 13.4454>, <2.1297, 65.679, 15.1205> }
				triangle { <1.3043, 65.3123, 15.607>, <2.2126, 65.5627, 15.1662>, <2.1297, 65.679, 15.1205> }
				triangle { <1.3043, 65.3123, 15.607>, <2.1297, 65.679, 15.1205>, <1.2316, 65.4101, 15.5734> }
				triangle { <1.3043, 65.3123, 15.607>, <1.2316, 65.4101, 15.5734>, <-0.3604, 64.6638, 16.0832> }
				triangle { <6.3534, 66.2598, 12.3543>, <5.007918, 66.02954, 13.4454>, <5.08687, 65.8274, 13.461> }
				triangle { <2.1297, 65.679, 15.1205>, <5.007918, 66.02954, 13.4454>, <4.8931, 66.2055, 13.2727> }
				triangle { <2.2735, 65.4383, 15.2182>, <5.08687, 65.8274, 13.461>, <5.007918, 66.02954, 13.4454> }
				triangle { <6.3534, 66.2598, 12.3543>, <4.8931, 66.2055, 13.2727>, <5.007918, 66.02954, 13.4454> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.0697, 63.8782, 15.953>, <-0.6358, 65.2817, 16.94>, 0.09076 }
				cylinder { <-0.6358, 65.2817, 16.94>, <-0.0338, 66.6114, 17.9409>, 0.09076 }
				cylinder { <-0.0338, 66.6114, 17.9409>, <0.7296, 67.8527, 18.9452>, 0.09076 }
				cylinder { <0.7296, 67.8527, 18.9452>, <1.6461, 68.9918, 19.9426>, 0.09076 }
				cylinder { <1.6461, 68.9918, 19.9426>, <2.7056, 70.01624, 20.9225>, 0.09076 }
				cylinder { <2.7056, 70.01624, 20.9225>, <3.8964, 70.9146, 21.8749>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.8964, 70.9146, 21.8749>, <4.0132, 71.01209, 21.9857>, 0.002905 }
				cylinder { <4.0132, 71.01209, 21.9857>, <4.1194, 71.111, 22.1054>, 0.002905 }
				cylinder { <4.1194, 71.111, 22.1054>, <4.2145, 71.2108, 22.2333>, 0.002905 }
				cylinder { <4.2145, 71.2108, 22.2333>, <4.2981, 71.311, 22.3689>, 0.002905 }
				cylinder { <4.2981, 71.311, 22.3689>, <4.3697, 71.411, 22.5112>, 0.002905 }
				cylinder { <4.3697, 71.411, 22.5112>, <4.4288, 71.5103, 22.6597>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.4288, 71.5103, 22.6597>, <5.2966, 72.3034, 24.05841>, <5.2116, 72.4044, 24.07625> }
				triangle { <5.2966, 72.3034, 24.05841>, <5.8854, 72.8456, 24.7528>, <5.2116, 72.4044, 24.07625> }
				triangle { <5.8854, 72.8456, 24.7528>, <5.7964, 72.9619, 24.7316>, <5.2116, 72.4044, 24.07625> }
				triangle { <5.8854, 72.8456, 24.7528>, <7.9744, 74.7549, 26.4734>, <5.7964, 72.9619, 24.7316> }
				triangle { <5.7964, 72.9619, 24.7316>, <7.9744, 74.7549, 26.4734>, <5.6967, 73.0666, 24.6918> }
				triangle { <5.2116, 72.4044, 24.07625>, <5.7964, 72.9619, 24.7316>, <5.6967, 73.0666, 24.6918> }
				triangle { <5.2116, 72.4044, 24.07625>, <5.6967, 73.0666, 24.6918>, <5.1237, 72.4887, 24.04245> }
				triangle { <5.2116, 72.4044, 24.07625>, <5.1237, 72.4887, 24.04245>, <4.4288, 71.5103, 22.6597> }
				triangle { <9.1512, 75.8203, 27.204>, <7.9744, 74.7549, 26.4734>, <8.1421, 74.6168, 26.4628> }
				triangle { <5.6967, 73.0666, 24.6918>, <7.9744, 74.7549, 26.4734>, <7.8817, 74.9923, 26.3785> }
				triangle { <5.8854, 72.8456, 24.7528>, <8.1421, 74.6168, 26.4628>, <7.9744, 74.7549, 26.4734> }
				triangle { <9.1512, 75.8203, 27.204>, <7.8817, 74.9923, 26.3785>, <7.9744, 74.7549, 26.4734> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.8964, 70.9146, 21.8749>, <5.1777, 71.6853, 22.8219>, 0.09076 }
				cylinder { <5.1777, 71.6853, 22.8219>, <6.5391, 72.3222, 23.7563>, 0.09076 }
				cylinder { <6.5391, 72.3222, 23.7563>, <7.9701, 72.8202, 24.671>, 0.09076 }
				cylinder { <7.9701, 72.8202, 24.671>, <9.4592, 73.1754, 25.5591>, 0.09076 }
				cylinder { <9.4592, 73.1754, 25.5591>, <10.9947, 73.3848, 26.4139>, 0.09076 }
				cylinder { <10.9947, 73.3848, 26.4139>, <12.5645, 73.4468, 27.2289>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <12.5645, 73.4468, 27.2289>, <12.7434, 73.4451, 27.2868>, 0.002905 }
				cylinder { <12.7434, 73.4451, 27.2868>, <12.9293, 73.4353, 27.3142>, 0.002905 }
				cylinder { <12.9293, 73.4353, 27.3142>, <13.1166, 73.4176, 27.3103>, 0.002905 }
				cylinder { <13.1166, 73.4176, 27.3103>, <13.2997, 73.3924, 27.2753>, 0.002905 }
				cylinder { <13.2997, 73.3924, 27.2753>, <13.4733, 73.3607, 27.2102>, 0.002905 }
				cylinder { <13.4733, 73.3607, 27.2102>, <13.6323, 73.3232, 27.1169>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <13.6323, 73.3232, 27.1169>, <14.9876, 72.7235, 26.04834>, <15.07159, 72.825, 26.06852> }
				triangle { <14.9876, 72.7235, 26.04834>, <15.6945, 72.4555, 25.3057>, <15.07159, 72.825, 26.06852> }
				triangle { <15.6945, 72.4555, 25.3057>, <15.7538, 72.5904, 25.319>, <15.07159, 72.825, 26.06852> }
				triangle { <15.6945, 72.4555, 25.3057>, <17.5687, 71.8912, 22.6339>, <15.7538, 72.5904, 25.319> }
				triangle { <15.7538, 72.5904, 25.319>, <17.5687, 71.8912, 22.6339>, <15.7944, 72.7321, 25.3463> }
				triangle { <15.07159, 72.825, 26.06852>, <15.7538, 72.5904, 25.319>, <15.7944, 72.7321, 25.3463> }
				triangle { <15.07159, 72.825, 26.06852>, <15.7944, 72.7321, 25.3463>, <15.1046, 72.9436, 26.09696> }
				triangle { <15.07159, 72.825, 26.06852>, <15.1046, 72.9436, 26.09696>, <13.6323, 73.3232, 27.1169> }
				triangle { <18.4183, 71.6936, 21.1197>, <17.5687, 71.8912, 22.6339>, <17.4533, 71.7208, 22.5633> }
				triangle { <15.7944, 72.7321, 25.3463>, <17.5687, 71.8912, 22.6339>, <17.6252, 72.1522, 22.5823> }
				triangle { <15.6945, 72.4555, 25.3057>, <17.4533, 71.7208, 22.5633>, <17.5687, 71.8912, 22.6339> }
				triangle { <18.4183, 71.6936, 21.1197>, <17.6252, 72.1522, 22.5823>, <17.5687, 71.8912, 22.6339> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <12.5645, 73.4468, 27.2289>, <14.07666, 73.6254, 28.131>, 0.09076 }
				cylinder { <14.07666, 73.6254, 28.131>, <15.5194, 73.9194, 29.1129>, 0.09076 }
				cylinder { <15.5194, 73.9194, 29.1129>, <16.8817, 74.3268, 30.1667>, 0.09076 }
				cylinder { <16.8817, 74.3268, 30.1667>, <18.1529, 74.8445, 31.284>, 0.09076 }
				cylinder { <18.1529, 74.8445, 31.284>, <19.3231, 75.4686, 32.4559>, 0.09076 }
				cylinder { <19.3231, 75.4686, 32.4559>, <20.3834, 76.1945, 33.673>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <20.3834, 76.1945, 33.673>, <20.4649, 76.2761, 33.8215>, 0.002905 }
				cylinder { <20.4649, 76.2761, 33.8215>, <20.5122, 76.3591, 33.9836>, 0.002905 }
				cylinder { <20.5122, 76.3591, 33.9836>, <20.5233, 76.4403, 34.153>, 0.002905 }
				cylinder { <20.5233, 76.4403, 34.153>, <20.4979, 76.5165, 34.3231>, 0.002905 }
				cylinder { <20.4979, 76.5165, 34.3231>, <20.4369, 76.5849, 34.4874>, 0.002905 }
				cylinder { <20.4369, 76.5849, 34.4874>, <20.3428, 76.6427, 34.6397>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <20.3428, 76.6427, 34.6397>, <19.7042, 77.09655, 36.2903>, <19.6045, 77.1747, 36.2492> }
				triangle { <19.7042, 77.09655, 36.2903>, <19.4443, 77.4842, 37.2417>, <19.6045, 77.1747, 36.2492> }
				triangle { <19.4443, 77.4842, 37.2417>, <19.364, 77.5878, 37.1732>, <19.6045, 77.1747, 36.2492> }
				triangle { <19.4443, 77.4842, 37.2417>, <19.03649, 79.06715, 40.1223>, <19.364, 77.5878, 37.1732> }
				triangle { <19.364, 77.5878, 37.1732>, <19.03649, 79.06715, 40.1223>, <19.2929, 77.6845, 37.08334> }
				triangle { <19.6045, 77.1747, 36.2492>, <19.364, 77.5878, 37.1732>, <19.2929, 77.6845, 37.08334> }
				triangle { <19.6045, 77.1747, 36.2492>, <19.2929, 77.6845, 37.08334>, <19.5435, 77.252, 36.17> }
				triangle { <19.6045, 77.1747, 36.2492>, <19.5435, 77.252, 36.17>, <20.3428, 76.6427, 34.6397> }
				triangle { <18.9736, 80.02033, 41.5855>, <19.03649, 79.06715, 40.1223>, <19.1972, 78.9633, 40.2259> }
				triangle { <19.2929, 77.6845, 37.08334>, <19.03649, 79.06715, 40.1223>, <18.9662, 79.3066, 40.01424> }
				triangle { <19.4443, 77.4842, 37.2417>, <19.1972, 78.9633, 40.2259>, <19.03649, 79.06715, 40.1223> }
				triangle { <18.9736, 80.02033, 41.5855>, <18.9662, 79.3066, 40.01424>, <19.03649, 79.06715, 40.1223> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <20.3834, 76.1945, 33.673>, <21.5209, 76.8266, 34.8725>, 0.09076 }
				cylinder { <21.5209, 76.8266, 34.8725>, <22.7302, 77.3617, 36.04874>, 0.09076 }
				cylinder { <22.7302, 77.3617, 36.04874>, <24.00539, 77.7973, 37.1961>, 0.09076 }
				cylinder { <24.00539, 77.7973, 37.1961>, <25.3401, 78.1312, 38.3093>, 0.09076 }
				cylinder { <25.3401, 78.1312, 38.3093>, <26.7281, 78.3616, 39.383>, 0.09076 }
				cylinder { <26.7281, 78.3616, 39.383>, <28.1624, 78.4873, 40.4121>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <28.1624, 78.4873, 40.4121>, <28.3313, 78.4927, 40.4949>, 0.002905 }
				cylinder { <28.3313, 78.4927, 40.4949>, <28.5116, 78.49, 40.5486>, 0.002905 }
				cylinder { <28.5116, 78.49, 40.5486>, <28.698, 78.4793, 40.5716>, 0.002905 }
				cylinder { <28.698, 78.4793, 40.5716>, <28.885, 78.4608, 40.5632>, 0.002905 }
				cylinder { <28.885, 78.4608, 40.5632>, <29.06721, 78.4351, 40.5238>, 0.002905 }
				cylinder { <29.06721, 78.4351, 40.5238>, <29.2391, 78.403, 40.4545>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <29.2391, 78.403, 40.4545>, <30.7535, 77.8474, 39.5965>, <30.83, 77.9521, 39.6272> }
				triangle { <30.7535, 77.8474, 39.5965>, <31.5682, 77.6012, 38.9651>, <30.83, 77.9521, 39.6272> }
				triangle { <31.5682, 77.6012, 38.9651>, <31.6201, 77.7383, 38.9852>, <30.83, 77.9521, 39.6272> }
				triangle { <31.5682, 77.6012, 38.9651>, <33.8231, 77.09007, 36.5937>, <31.6201, 77.7383, 38.9852> }
				triangle { <31.6201, 77.7383, 38.9852>, <33.8231, 77.09007, 36.5937>, <31.6513, 77.8816, 39.01638> }
				triangle { <30.83, 77.9521, 39.6272>, <31.6201, 77.7383, 38.9852>, <31.6513, 77.8816, 39.01638> }
				triangle { <30.83, 77.9521, 39.6272>, <31.6513, 77.8816, 39.01638>, <30.8544, 78.0721, 39.6587> }
				triangle { <30.83, 77.9521, 39.6272>, <30.8544, 78.0721, 39.6587>, <29.2391, 78.403, 40.4545> }
				triangle { <34.8864, 76.9145, 35.2181>, <33.8231, 77.09007, 36.5937>, <33.7252, 76.915, 36.5094> }
				triangle { <31.6513, 77.8816, 39.01638>, <33.8231, 77.09007, 36.5937>, <33.8769, 77.3526, 36.5476> }
				triangle { <31.5682, 77.6012, 38.9651>, <33.7252, 76.915, 36.5094>, <33.8231, 77.09007, 36.5937> }
				triangle { <34.8864, 76.9145, 35.2181>, <33.8769, 77.3526, 36.5476>, <33.8231, 77.09007, 36.5937> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <28.1624, 78.4873, 40.4121>, <29.5712, 78.6236, 41.4748>, 0.09076 }
				cylinder { <29.5712, 78.6236, 41.4748>, <30.9534, 78.7702, 42.5702>, 0.09076 }
				cylinder { <30.9534, 78.7702, 42.5702>, <32.3084, 78.9271, 43.6979>, 0.09076 }
				cylinder { <32.3084, 78.9271, 43.6979>, <33.6353, 79.09424, 44.8571>, 0.09076 }
				cylinder { <33.6353, 79.09424, 44.8571>, <34.9333, 79.2714, 46.04716>, 0.09076 }
				cylinder { <34.9333, 79.2714, 46.04716>, <36.2016, 79.4585, 47.2672>, 0.09076 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <36.2016, 79.4585, 47.2672>, <36.3159, 79.4845, 47.4144>, 0.002905 }
				cylinder { <36.3159, 79.4845, 47.4144>, <36.4071, 79.516, 47.5759>, 0.002905 }
				cylinder { <36.4071, 79.516, 47.5759>, <36.4733, 79.5524, 47.7482>, 0.002905 }
				cylinder { <36.4733, 79.5524, 47.7482>, <36.513, 79.5928, 47.9276>, 0.002905 }
				cylinder { <36.513, 79.5928, 47.9276>, <36.5255, 79.6365, 48.1102>, 0.002905 }
				cylinder { <36.5255, 79.6365, 48.1102>, <36.5103, 79.6823, 48.292>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <36.5103, 79.6823, 48.292>, <36.6191, 79.9038, 50.1024>, <36.5475, 80.01598, 50.1103> }
				triangle { <36.6191, 79.9038, 50.1024>, <36.823, 80.1153, 51.1206>, <36.5475, 80.01598, 50.1103> }
				triangle { <36.823, 80.1153, 51.1206>, <36.7693, 80.2515, 51.099>, <36.5475, 80.01598, 50.1103> }
				triangle { <36.823, 80.1153, 51.1206>, <37.9233, 81.01871, 54.111>, <36.7693, 80.2515, 51.099> }
				triangle { <36.7693, 80.2515, 51.099>, <37.9233, 81.01871, 54.111>, <36.7149, 80.3835, 51.05343> }
				triangle { <36.5475, 80.01598, 50.1103>, <36.7693, 80.2515, 51.099>, <36.7149, 80.3835, 51.05343> }
				triangle { <36.5475, 80.01598, 50.1103>, <36.7149, 80.3835, 51.05343>, <36.498, 80.1245, 50.06862> }
				triangle { <36.5475, 80.01598, 50.1103>, <36.498, 80.1245, 50.06862>, <36.5103, 79.6823, 48.292> }
				triangle { <38.6638, 81.5716, 55.5941>, <37.9233, 81.01871, 54.111>, <38.05832, 80.8497, 54.1353> }
				triangle { <36.7149, 80.3835, 51.05343>, <37.9233, 81.01871, 54.111>, <37.9163, 81.2866, 54.06492> }
				triangle { <36.823, 80.1153, 51.1206>, <38.05832, 80.8497, 54.1353>, <37.9233, 81.01871, 54.111> }
				triangle { <38.6638, 81.5716, 55.5941>, <37.9163, 81.2866, 54.06492>, <37.9233, 81.01871, 54.111> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <36.2016, 79.4585, 47.2672>, <36.3365, 79.4784, 47.3969>, 0.002905 }
				cylinder { <36.3365, 79.4784, 47.3969>, <36.4713, 79.4983, 47.5266>, 0.002905 }
				cylinder { <36.4713, 79.4983, 47.5266>, <36.6061, 79.5182, 47.6563>, 0.002905 }
				cylinder { <36.6061, 79.5182, 47.6563>, <36.7409, 79.5381, 47.786>, 0.002905 }
				cylinder { <36.7409, 79.5381, 47.786>, <36.8757, 79.558, 47.9157>, 0.002905 }
				cylinder { <36.8757, 79.558, 47.9157>, <37.01059, 79.5779, 48.04545>, 0.002905 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <37.01059, 79.5779, 48.04545>, <38.4681, 79.5067, 49.1449>, <38.4522, 79.626, 49.2021> }
				triangle { <38.4681, 79.5067, 49.1449>, <39.3973, 79.5296, 49.6539>, <38.4522, 79.626, 49.2021> }
				triangle { <39.3973, 79.5296, 49.6539>, <39.3762, 79.6741, 49.6778>, <38.4522, 79.626, 49.2021> }
				triangle { <39.3973, 79.5296, 49.6539>, <42.506, 79.7961, 50.7648>, <39.3762, 79.6741, 49.6778> }
				triangle { <39.3762, 79.6741, 49.6778>, <42.506, 79.7961, 50.7648>, <39.3359, 79.8183, 49.6867> }
				triangle { <38.4522, 79.626, 49.2021>, <39.3762, 79.6741, 49.6778>, <39.3359, 79.8183, 49.6867> }
				triangle { <38.4522, 79.626, 49.2021>, <39.3359, 79.8183, 49.6867>, <38.413, 79.7458, 49.2103> }
				triangle { <38.4522, 79.626, 49.2021>, <38.413, 79.7458, 49.2103>, <37.01059, 79.5779, 48.04545> }
				triangle { <44.1943, 80.00087, 51.1668>, <42.506, 79.7961, 50.7648>, <42.574, 79.6068, 50.6819> }
				triangle { <39.3359, 79.8183, 49.6867>, <42.506, 79.7961, 50.7648>, <42.5245, 80.0658, 50.7351> }
				triangle { <39.3973, 79.5296, 49.6539>, <42.574, 79.6068, 50.6819>, <42.506, 79.7961, 50.7648> }
				triangle { <44.1943, 80.00087, 51.1668>, <42.5245, 80.0658, 50.7351>, <42.506, 79.7961, 50.7648> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.08589, 3.7091, -0.1607>, 0.05734 }
			cylinder { <-0.08589, 3.7091, -0.1607>, <-0.2574, 7.4048, -0.4817>, 0.05734 }
			cylinder { <-0.2574, 7.4048, -0.4817>, <-0.5143, 11.07829, -0.9622>, 0.05734 }
			cylinder { <-0.5143, 11.07829, -0.9622>, <-0.8558, 14.7205, -1.6012>, 0.05734 }
			cylinder { <-0.8558, 14.7205, -1.6012>, <-1.2812, 18.3228, -2.397>, 0.05734 }
			cylinder { <-1.2812, 18.3228, -2.397>, <-1.7893, 21.8765, -3.3477>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.7893, 21.8765, -3.3477>, <-1.9424, 22.9465, -3.6339>, 0.05734 }
				cylinder { <-1.9424, 22.9465, -3.6339>, <-2.09541, 24.01661, -3.9202>, 0.05734 }
				cylinder { <-2.09541, 24.01661, -3.9202>, <-2.2484, 25.08663, -4.2065>, 0.05734 }
				cylinder { <-2.2484, 25.08663, -4.2065>, <-2.4014, 26.1566, -4.4927>, 0.05734 }
				cylinder { <-2.4014, 26.1566, -4.4927>, <-2.5544, 27.2266, -4.779>, 0.05734 }
				cylinder { <-2.5544, 27.2266, -4.779>, <-2.7074, 28.2966, -5.06528>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-2.7074, 28.2966, -5.06528>, <-2.7257, 28.368, -5.08003>, 0.001159 }
				cylinder { <-2.7257, 28.368, -5.08003>, <-2.7518, 28.4377, -5.09008>, 0.001159 }
				cylinder { <-2.7518, 28.4377, -5.09008>, <-2.7852, 28.5047, -5.09527>, 0.001159 }
				cylinder { <-2.7852, 28.5047, -5.09527>, <-2.8255, 28.5681, -5.09554>, 0.001159 }
				cylinder { <-2.8255, 28.5681, -5.09554>, <-2.872, 28.6268, -5.09088>, 0.001159 }
				cylinder { <-2.872, 28.6268, -5.09088>, <-2.9241, 28.6801, -5.08135>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.9241, 28.6801, -5.08135>, <-3.7919, 29.4329, -4.9688>, <-3.7478, 29.4952, -4.9333> }
				triangle { <-3.7919, 29.4329, -4.9688>, <-4.3129, 29.8227, -4.811>, <-3.7478, 29.4952, -4.9333> }
				triangle { <-4.3129, 29.8227, -4.811>, <-4.256, 29.8723, -4.7559>, <-3.7478, 29.4952, -4.9333> }
				triangle { <-4.3129, 29.8227, -4.811>, <-5.9633, 30.8432, -4.02773>, <-4.256, 29.8723, -4.7559> }
				triangle { <-4.256, 29.8723, -4.7559>, <-5.9633, 30.8432, -4.02773>, <-4.188, 29.9114, -4.7028> }
				triangle { <-3.7478, 29.4952, -4.9333>, <-4.256, 29.8723, -4.7559>, <-4.188, 29.9114, -4.7028> }
				triangle { <-3.7478, 29.4952, -4.9333>, <-4.188, 29.9114, -4.7028>, <-3.6882, 29.5274, -4.8911> }
				triangle { <-3.7478, 29.4952, -4.9333>, <-3.6882, 29.5274, -4.8911>, <-2.9241, 28.6801, -5.08135> }
				triangle { <-6.8294, 31.2998, -3.5175>, <-5.9633, 30.8432, -4.02773>, <-6.05694, 30.7533, -4.07291> }
				triangle { <-4.188, 29.9114, -4.7028>, <-5.9633, 30.8432, -4.02773>, <-5.8843, 30.8999, -3.886> }
				triangle { <-4.3129, 29.8227, -4.811>, <-6.05694, 30.7533, -4.07291>, <-5.9633, 30.8432, -4.02773> }
				triangle { <-6.8294, 31.2998, -3.5175>, <-5.8843, 30.8999, -3.886>, <-5.9633, 30.8432, -4.02773> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-2.7074, 28.2966, -5.06528>, <-2.9091, 29.3491, -5.3845>, 0.05734 }
				cylinder { <-2.9091, 29.3491, -5.3845>, <-3.1589, 30.3809, -5.7357>, 0.05734 }
				cylinder { <-3.1589, 30.3809, -5.7357>, <-3.4559, 31.3889, -6.1179>, 0.05734 }
				cylinder { <-3.4559, 31.3889, -6.1179>, <-3.7993, 32.3699, -6.53>, 0.05734 }
				cylinder { <-3.7993, 32.3699, -6.53>, <-4.1881, 33.3212, -6.9708>, 0.05734 }
				cylinder { <-4.1881, 33.3212, -6.9708>, <-4.621, 34.2398, -7.4389>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.621, 34.2398, -7.4389>, <-4.6437, 34.3022, -7.474>, 0.001159 }
				cylinder { <-4.6437, 34.3022, -7.474>, <-4.6598, 34.3646, -7.5124>, 0.001159 }
				cylinder { <-4.6598, 34.3646, -7.5124>, <-4.6692, 34.4266, -7.5538>, 0.001159 }
				cylinder { <-4.6692, 34.4266, -7.5538>, <-4.6718, 34.4874, -7.5978>, 0.001159 }
				cylinder { <-4.6718, 34.4874, -7.5978>, <-4.6675, 34.5466, -7.6439>, 0.001159 }
				cylinder { <-4.6675, 34.5466, -7.6439>, <-4.6565, 34.6034, -7.6916>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.6565, 34.6034, -7.6916>, <-4.573, 35.4526, -8.4691>, <-4.5027, 35.4879, -8.4391> }
				triangle { <-4.573, 35.4526, -8.4691>, <-4.586, 35.9999, -8.8545>, <-4.5027, 35.4879, -8.4391> }
				triangle { <-4.586, 35.9999, -8.8545>, <-4.5213, 36.03784, -8.7986>, <-4.5027, 35.4879, -8.4391> }
				triangle { <-4.586, 35.9999, -8.8545>, <-4.8403, 37.8426, -9.8128>, <-4.5213, 36.03784, -8.7986> }
				triangle { <-4.5213, 36.03784, -8.7986>, <-4.8403, 37.8426, -9.8128>, <-4.4584, 36.06408, -8.7328> }
				triangle { <-4.5027, 35.4879, -8.4391>, <-4.5213, 36.03784, -8.7986>, <-4.4584, 36.06408, -8.7328> }
				triangle { <-4.5027, 35.4879, -8.4391>, <-4.4584, 36.06408, -8.7328>, <-4.4485, 35.5067, -8.3836> }
				triangle { <-4.5027, 35.4879, -8.4391>, <-4.4485, 35.5067, -8.3836>, <-4.6565, 34.6034, -7.6916> }
				triangle { <-5.05174, 38.8458, -10.2226>, <-4.8403, 37.8426, -9.8128>, <-4.96, 37.8102, -9.8721> }
				triangle { <-4.4584, 36.06408, -8.7328>, <-4.8403, 37.8426, -9.8128>, <-4.7699, 37.9379, -9.6884> }
				triangle { <-4.586, 35.9999, -8.8545>, <-4.96, 37.8102, -9.8721>, <-4.8403, 37.8426, -9.8128> }
				triangle { <-5.05174, 38.8458, -10.2226>, <-4.7699, 37.9379, -9.6884>, <-4.8403, 37.8426, -9.8128> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.621, 34.2398, -7.4389>, <-5.08693, 35.1389, -7.913>, 0.05734 }
				cylinder { <-5.08693, 35.1389, -7.913>, <-5.5853, 36.01761, -8.3924>, 0.05734 }
				cylinder { <-5.5853, 36.01761, -8.3924>, <-6.1156, 36.8746, -8.8767>, 0.05734 }
				cylinder { <-6.1156, 36.8746, -8.8767>, <-6.6772, 37.7091, -9.3652>, 0.05734 }
				cylinder { <-6.6772, 37.7091, -9.3652>, <-7.2693, 38.5199, -9.8574>, 0.05734 }
				cylinder { <-7.2693, 38.5199, -9.8574>, <-7.8913, 39.3061, -10.3527>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-7.8913, 39.3061, -10.3527>, <-7.9412, 39.3556, -10.3792>, 0.001159 }
				cylinder { <-7.9412, 39.3556, -10.3792>, <-7.9981, 39.4007, -10.3984>, 0.001159 }
				cylinder { <-7.9981, 39.4007, -10.3984>, <-8.06076, 39.4405, -10.4098>, 0.001159 }
				cylinder { <-8.06076, 39.4405, -10.4098>, <-8.1278, 39.4741, -10.4132>, 0.001159 }
				cylinder { <-8.1278, 39.4741, -10.4132>, <-8.1978, 39.5007, -10.4086>, 0.001159 }
				cylinder { <-8.1978, 39.5007, -10.4086>, <-8.2694, 39.5199, -10.3959>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.2694, 39.5199, -10.3959>, <-9.3917, 39.7173, -10.2116>, <-9.3856, 39.7996, -10.1952> }
				triangle { <-9.3917, 39.7173, -10.2116>, <-10.02245, 39.8054, -10.00502>, <-9.3856, 39.7996, -10.1952> }
				triangle { <-10.02245, 39.8054, -10.00502>, <-9.9969, 39.8884, -9.9704>, <-9.3856, 39.7996, -10.1952> }
				triangle { <-10.02245, 39.8054, -10.00502>, <-11.8746, 39.9729, -9.04597>, <-9.9969, 39.8884, -9.9704> }
				triangle { <-9.9969, 39.8884, -9.9704>, <-11.8746, 39.9729, -9.04597>, <-9.9566, 39.968, -9.9385> }
				triangle { <-9.3856, 39.7996, -10.1952>, <-9.9969, 39.8884, -9.9704>, <-9.9566, 39.968, -9.9385> }
				triangle { <-9.3856, 39.7996, -10.1952>, <-9.9566, 39.968, -9.9385>, <-9.3497, 39.8668, -10.1712> }
				triangle { <-9.3856, 39.7996, -10.1952>, <-9.3497, 39.8668, -10.1712>, <-8.2694, 39.5199, -10.3959> }
				triangle { <-12.7936, 40.01846, -8.4357>, <-11.8746, 39.9729, -9.04597>, <-11.9075, 39.8399, -9.05771> }
				triangle { <-9.9566, 39.968, -9.9385>, <-11.8746, 39.9729, -9.04597>, <-11.8261, 40.09306, -8.9331> }
				triangle { <-10.02245, 39.8054, -10.00502>, <-11.9075, 39.8399, -9.05771>, <-11.8746, 39.9729, -9.04597> }
				triangle { <-12.7936, 40.01846, -8.4357>, <-11.8261, 40.09306, -8.9331>, <-11.8746, 39.9729, -9.04597> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-7.8913, 39.3061, -10.3527>, <-8.4835, 40.1169, -10.8449>, 0.05734 }
				cylinder { <-8.4835, 40.1169, -10.8449>, <-9.04509, 40.9513, -11.3334>, 0.05734 }
				cylinder { <-9.04509, 40.9513, -11.3334>, <-9.5754, 41.8084, -11.8176>, 0.05734 }
				cylinder { <-9.5754, 41.8084, -11.8176>, <-10.07393, 42.6871, -12.2969>, 0.05734 }
				cylinder { <-10.07393, 42.6871, -12.2969>, <-10.5399, 43.5863, -12.7707>, 0.05734 }
				cylinder { <-10.5399, 43.5863, -12.7707>, <-10.9729, 44.505, -13.2384>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-10.9729, 44.505, -13.2384>, <-10.9924, 44.5676, -13.2752>, 0.001159 }
				cylinder { <-10.9924, 44.5676, -13.2752>, <-11.00181, 44.6296, -13.3165>, 0.001159 }
				cylinder { <-11.00181, 44.6296, -13.3165>, <-11.00094, 44.6897, -13.3615>, 0.001159 }
				cylinder { <-11.00094, 44.6897, -13.3615>, <-10.9898, 44.7467, -13.4091>, 0.001159 }
				cylinder { <-10.9898, 44.7467, -13.4091>, <-10.9687, 44.7992, -13.4584>, 0.001159 }
				cylinder { <-10.9687, 44.7992, -13.4584>, <-10.938, 44.8463, -13.5083>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.938, 44.8463, -13.5083>, <-10.5494, 45.5575, -14.3303>, <-10.4784, 45.5809, -14.2917> }
				triangle { <-10.5494, 45.5575, -14.3303>, <-10.3807, 46.04393, -14.7584>, <-10.4784, 45.5809, -14.2917> }
				triangle { <-10.3807, 46.04393, -14.7584>, <-10.3185, 46.07423, -14.6955>, <-10.4784, 45.5809, -14.2917> }
				triangle { <-10.3807, 46.04393, -14.7584>, <-10.06731, 47.7669, -15.9037>, <-10.3185, 46.07423, -14.6955> }
				triangle { <-10.3185, 46.07423, -14.6955>, <-10.06731, 47.7669, -15.9037>, <-10.262, 46.09483, -14.6223> }
				triangle { <-10.4784, 45.5809, -14.2917>, <-10.3185, 46.07423, -14.6955>, <-10.262, 46.09483, -14.6223> }
				triangle { <-10.4784, 45.5809, -14.2917>, <-10.262, 46.09483, -14.6223>, <-10.4304, 45.5948, -14.2294> }
				triangle { <-10.4784, 45.5809, -14.2917>, <-10.4304, 45.5948, -14.2294>, <-10.938, 44.8463, -13.5083> }
				triangle { <-9.9838, 48.7337, -16.4301>, <-10.06731, 47.7669, -15.9037>, <-10.1808, 47.7527, -15.9799> }
				triangle { <-10.262, 46.09483, -14.6223>, <-10.06731, 47.7669, -15.9037>, <-9.997, 47.8602, -15.7776> }
				triangle { <-10.3807, 46.04393, -14.7584>, <-10.1808, 47.7527, -15.9799>, <-10.06731, 47.7669, -15.9037> }
				triangle { <-9.9838, 48.7337, -16.4301>, <-9.997, 47.8602, -15.7776>, <-10.06731, 47.7669, -15.9037> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-10.9729, 44.505, -13.2384>, <-11.5032, 45.3621, -13.7228>, 0.05734 }
				cylinder { <-11.5032, 45.3621, -13.7228>, <-12.1248, 46.1481, -14.2188>, 0.05734 }
				cylinder { <-12.1248, 46.1481, -14.2188>, <-12.831, 46.8545, -14.7214>, 0.05734 }
				cylinder { <-12.831, 46.8545, -14.7214>, <-13.614, 47.4735, -15.2254>, 0.05734 }
				cylinder { <-13.614, 47.4735, -15.2254>, <-14.4652, 47.9984, -15.7257>, 0.05734 }
				cylinder { <-14.4652, 47.9984, -15.7257>, <-15.3753, 48.4234, -16.217>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-15.3753, 48.4234, -16.217>, <-15.4437, 48.4452, -16.2391>, 0.001159 }
				cylinder { <-15.4437, 48.4452, -16.2391>, <-15.5167, 48.4594, -16.2495>, 0.001159 }
				cylinder { <-15.5167, 48.4594, -16.2495>, <-15.5915, 48.4656, -16.2477>, 0.001159 }
				cylinder { <-15.5915, 48.4656, -16.2477>, <-15.6652, 48.4634, -16.2338>, 0.001159 }
				cylinder { <-15.6652, 48.4634, -16.2338>, <-15.7351, 48.4529, -16.2084>, 0.001159 }
				cylinder { <-15.7351, 48.4529, -16.2084>, <-15.7984, 48.4345, -16.1724>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-15.7984, 48.4345, -16.1724>, <-16.7411, 48.05766, -15.623>, <-16.7754, 48.1329, -15.6075> }
				triangle { <-16.7411, 48.05766, -15.623>, <-17.2286, 47.8426, -15.2176>, <-16.7754, 48.1329, -15.6075> }
				triangle { <-17.2286, 47.8426, -15.2176>, <-17.2425, 47.9312, -15.1914>, <-16.7754, 48.1329, -15.6075> }
				triangle { <-17.2286, 47.8426, -15.2176>, <-18.5089, 47.1892, -13.6969>, <-17.2425, 47.9312, -15.1914> }
				triangle { <-17.2425, 47.9312, -15.1914>, <-18.5089, 47.1892, -13.6969>, <-17.2437, 48.02412, -15.1726> }
				triangle { <-16.7754, 48.1329, -15.6075>, <-17.2425, 47.9312, -15.1914>, <-17.2437, 48.02412, -15.1726> }
				triangle { <-16.7754, 48.1329, -15.6075>, <-17.2437, 48.02412, -15.1726>, <-16.7757, 48.2118, -15.5951> }
				triangle { <-16.7754, 48.1329, -15.6075>, <-16.7757, 48.2118, -15.5951>, <-15.7984, 48.4345, -16.1724> }
				triangle { <-19.08492, 46.8544, -12.8165>, <-18.5089, 47.1892, -13.6969>, <-18.4676, 47.0582, -13.7003> }
				triangle { <-17.2437, 48.02412, -15.1726>, <-18.5089, 47.1892, -13.6969>, <-18.5016, 47.3332, -13.6035> }
				triangle { <-17.2286, 47.8426, -15.2176>, <-18.4676, 47.0582, -13.7003>, <-18.5089, 47.1892, -13.6969> }
				triangle { <-19.08492, 46.8544, -12.8165>, <-18.5016, 47.3332, -13.6035>, <-18.5089, 47.1892, -13.6969> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-15.3753, 48.4234, -16.217>, <-16.32, 48.7559, -16.7143>, 0.05734 }
				cylinder { <-16.32, 48.7559, -16.7143>, <-17.2918, 48.9933, -17.2139>, 0.05734 }
				cylinder { <-17.2918, 48.9933, -17.2139>, <-18.283, 49.1338, -17.7119>, 0.05734 }
				cylinder { <-18.283, 49.1338, -17.7119>, <-19.2859, 49.1762, -18.2046>, 0.05734 }
				cylinder { <-19.2859, 49.1762, -18.2046>, <-20.2924, 49.1202, -18.6884>, 0.05734 }
				cylinder { <-20.2924, 49.1202, -18.6884>, <-21.2947, 48.9662, -19.1596>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-21.2947, 48.9662, -19.1596>, <-21.3601, 48.9585, -19.1957>, 0.001159 }
				cylinder { <-21.3601, 48.9585, -19.1957>, <-21.4232, 48.9534, -19.2361>, 0.001159 }
				cylinder { <-21.4232, 48.9534, -19.2361>, <-21.4836, 48.951, -19.2806>, 0.001159 }
				cylinder { <-21.4836, 48.951, -19.2806>, <-21.5412, 48.9513, -19.3289>, 0.001159 }
				cylinder { <-21.5412, 48.9513, -19.3289>, <-21.5954, 48.9543, -19.3807>, 0.001159 }
				cylinder { <-21.5954, 48.9543, -19.3807>, <-21.6461, 48.9599, -19.4358>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-21.6461, 48.9599, -19.4358>, <-22.4399, 48.9487, -20.2738>, <-22.4422, 49.03169, -20.2877> }
				triangle { <-22.4399, 48.9487, -20.2738>, <-22.9706, 48.9483, -20.682>, <-22.4422, 49.03169, -20.2877> }
				triangle { <-22.9706, 48.9483, -20.682>, <-22.9758, 49.04105, -20.6713>, <-22.4422, 49.03169, -20.2877> }
				triangle { <-22.9706, 48.9483, -20.682>, <-24.8197, 48.9555, -21.6616>, <-22.9758, 49.04105, -20.6713> }
				triangle { <-22.9758, 49.04105, -20.6713>, <-24.8197, 48.9555, -21.6616>, <-22.9704, 49.133, -20.6494> }
				triangle { <-22.4422, 49.03169, -20.2877>, <-22.9758, 49.04105, -20.6713>, <-22.9704, 49.133, -20.6494> }
				triangle { <-22.4422, 49.03169, -20.2877>, <-22.9704, 49.133, -20.6494>, <-22.4341, 49.1089, -20.2694> }
				triangle { <-22.4422, 49.03169, -20.2877>, <-22.4341, 49.1089, -20.2694>, <-21.6461, 48.9599, -19.4358> }
				triangle { <-25.8481, 48.9596, -22.06319>, <-24.8197, 48.9555, -21.6616>, <-24.8416, 48.8204, -21.6492> }
				triangle { <-22.9704, 49.133, -20.6494>, <-24.8197, 48.9555, -21.6616>, <-24.8706, 49.1089, -21.6036> }
				triangle { <-22.9706, 48.9483, -20.682>, <-24.8416, 48.8204, -21.6492>, <-24.8197, 48.9555, -21.6616> }
				triangle { <-25.8481, 48.9596, -22.06319>, <-24.8706, 49.1089, -21.6036>, <-24.8197, 48.9555, -21.6616> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-21.2947, 48.9662, -19.1596>, <-22.2962, 48.8491, -19.6429>, 0.05734 }
				cylinder { <-22.2962, 48.8491, -19.6429>, <-23.2958, 48.769, -20.1376>, 0.05734 }
				cylinder { <-23.2958, 48.769, -20.1376>, <-24.2922, 48.726, -20.6431>, 0.05734 }
				cylinder { <-24.2922, 48.726, -20.6431>, <-25.2843, 48.7202, -21.1589>, 0.05734 }
				cylinder { <-25.2843, 48.7202, -21.1589>, <-26.2708, 48.7516, -21.6843>, 0.05734 }
				cylinder { <-26.2708, 48.7516, -21.6843>, <-27.2506, 48.8202, -22.2187>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-27.2506, 48.8202, -22.2187>, <-27.3194, 48.8213, -22.2488>, 0.001159 }
				cylinder { <-27.3194, 48.8213, -22.2488>, <-27.3905, 48.8189, -22.2729>, 0.001159 }
				cylinder { <-27.3905, 48.8189, -22.2729>, <-27.4632, 48.8129, -22.2907>, 0.001159 }
				cylinder { <-27.4632, 48.8129, -22.2907>, <-27.5368, 48.8035, -22.3021>, 0.001159 }
				cylinder { <-27.5368, 48.8035, -22.3021>, <-27.6107, 48.7908, -22.3069>, 0.001159 }
				cylinder { <-27.6107, 48.7908, -22.3069>, <-27.684, 48.7748, -22.3051>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-27.684, 48.7748, -22.3051>, <-28.7861, 48.4348, -22.2565>, <-28.8213, 48.5105, -22.2674> }
				triangle { <-28.7861, 48.4348, -22.2565>, <-29.4164, 48.2514, -22.1244>, <-28.8213, 48.5105, -22.2674> }
				triangle { <-29.4164, 48.2514, -22.1244>, <-29.4386, 48.3419, -22.1174>, <-28.8213, 48.5105, -22.2674> }
				triangle { <-29.4164, 48.2514, -22.1244>, <-31.2985, 47.728, -21.3745>, <-29.4386, 48.3419, -22.1174> }
				triangle { <-29.4386, 48.3419, -22.1174>, <-31.2985, 47.728, -21.3745>, <-29.446, 48.4361, -22.1111> }
				triangle { <-28.8213, 48.5105, -22.2674>, <-29.4386, 48.3419, -22.1174>, <-29.446, 48.4361, -22.1111> }
				triangle { <-28.8213, 48.5105, -22.2674>, <-29.446, 48.4361, -22.1111>, <-28.8252, 48.5902, -22.2648> }
				triangle { <-28.8213, 48.5105, -22.2674>, <-28.8252, 48.5902, -22.2648>, <-27.684, 48.7748, -22.3051> }
				triangle { <-32.2429, 47.472, -20.8633>, <-31.2985, 47.728, -21.3745>, <-31.2648, 47.5983, -21.344> }
				triangle { <-29.446, 48.4361, -22.1111>, <-31.2985, 47.728, -21.3745>, <-31.3335, 47.881, -21.3045> }
				triangle { <-29.4164, 48.2514, -22.1244>, <-31.2648, 47.5983, -21.344>, <-31.2985, 47.728, -21.3745> }
				triangle { <-32.2429, 47.472, -20.8633>, <-31.3335, 47.881, -21.3045>, <-31.2985, 47.728, -21.3745> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-27.2506, 48.8202, -22.2187>, <-28.2252, 48.8647, -22.7651>, 0.05734 }
				cylinder { <-28.2252, 48.8647, -22.7651>, <-29.194, 48.885, -23.3231>, 0.05734 }
				cylinder { <-29.194, 48.885, -23.3231>, <-30.1563, 48.8811, -23.8925>, 0.05734 }
				cylinder { <-30.1563, 48.8811, -23.8925>, <-31.1116, 48.8532, -24.4729>, 0.05734 }
				cylinder { <-31.1116, 48.8532, -24.4729>, <-32.05941, 48.8011, -25.06404>, 0.05734 }
				cylinder { <-32.05941, 48.8011, -25.06404>, <-32.999, 48.7248, -25.6653>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-32.999, 48.7248, -25.6653>, <-33.05754, 48.7241, -25.7124>, 0.001159 }
				cylinder { <-33.05754, 48.7241, -25.7124>, <-33.1106, 48.7278, -25.7654>, 0.001159 }
				cylinder { <-33.1106, 48.7278, -25.7654>, <-33.1574, 48.7359, -25.8236>, 0.001159 }
				cylinder { <-33.1574, 48.7359, -25.8236>, <-33.1972, 48.7482, -25.886>, 0.001159 }
				cylinder { <-33.1972, 48.7482, -25.886>, <-33.2295, 48.7645, -25.9518>, 0.001159 }
				cylinder { <-33.2295, 48.7645, -25.9518>, <-33.2537, 48.7847, -26.02005>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-33.2537, 48.7847, -26.02005>, <-33.6565, 49.00027, -27.08017>, <-33.6417, 49.08313, -27.08076> }
				triangle { <-33.6565, 49.00027, -27.08017>, <-33.9834, 49.1373, -27.6481>, <-33.6417, 49.08313, -27.08076> }
				triangle { <-33.9834, 49.1373, -27.6481>, <-33.9794, 49.2279, -27.6256>, <-33.6417, 49.08313, -27.08076> }
				triangle { <-33.9834, 49.1373, -27.6481>, <-35.2918, 49.5822, -29.2194>, <-33.9794, 49.2279, -27.6256> }
				triangle { <-33.9794, 49.2279, -27.6256>, <-35.2918, 49.5822, -29.2194>, <-33.9701, 49.3149, -27.5892> }
				triangle { <-33.6417, 49.08313, -27.08076>, <-33.9794, 49.2279, -27.6256>, <-33.9701, 49.3149, -27.5892> }
				triangle { <-33.6417, 49.08313, -27.08076>, <-33.9701, 49.3149, -27.5892>, <-33.6307, 49.1555, -27.04884> }
				triangle { <-33.6417, 49.08313, -27.08076>, <-33.6307, 49.1555, -27.04884>, <-33.2537, 48.7847, -26.02005> }
				triangle { <-36.07472, 49.8165, -29.9617>, <-35.2918, 49.5822, -29.2194>, <-35.3353, 49.453, -29.2371> }
				triangle { <-33.9701, 49.3149, -27.5892>, <-35.2918, 49.5822, -29.2194>, <-35.3393, 49.7364, -29.1606> }
				triangle { <-33.9834, 49.1373, -27.6481>, <-35.3353, 49.453, -29.2371>, <-35.2918, 49.5822, -29.2194> }
				triangle { <-36.07472, 49.8165, -29.9617>, <-35.3393, 49.7364, -29.1606>, <-35.2918, 49.5822, -29.2194> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-32.999, 48.7248, -25.6653>, <-33.0604, 48.7215, -25.7085>, 0.001159 }
				cylinder { <-33.0604, 48.7215, -25.7085>, <-33.1199, 48.7199, -25.7542>, 0.001159 }
				cylinder { <-33.1199, 48.7199, -25.7542>, <-33.1774, 48.7201, -25.8026>, 0.001159 }
				cylinder { <-33.1774, 48.7201, -25.8026>, <-33.2327, 48.722, -25.8533>, 0.001159 }
				cylinder { <-33.2327, 48.722, -25.8533>, <-33.2858, 48.7257, -25.9063>, 0.001159 }
				cylinder { <-33.2858, 48.7257, -25.9063>, <-33.3364, 48.7311, -25.9615>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-33.3364, 48.7311, -25.9615>, <-34.1299, 48.7167, -26.7998>, <-34.1318, 48.7996, -26.8143> }
				triangle { <-34.1299, 48.7167, -26.7998>, <-34.6604, 48.7155, -27.2081>, <-34.1318, 48.7996, -26.8143> }
				triangle { <-34.6604, 48.7155, -27.2081>, <-34.6652, 48.8083, -27.1982>, <-34.1318, 48.7996, -26.8143> }
				triangle { <-34.6604, 48.7155, -27.2081>, <-36.509, 48.7231, -28.1887>, <-34.6652, 48.8083, -27.1982> }
				triangle { <-34.6652, 48.8083, -27.1982>, <-36.509, 48.7231, -28.1887>, <-34.6594, 48.9005, -27.1771> }
				triangle { <-34.1318, 48.7996, -26.8143>, <-34.6652, 48.8083, -27.1982>, <-34.6594, 48.9005, -27.1771> }
				triangle { <-34.1318, 48.7996, -26.8143>, <-34.6594, 48.9005, -27.1771>, <-34.1234, 48.877, -26.7966> }
				triangle { <-34.1318, 48.7996, -26.8143>, <-34.1234, 48.877, -26.7966>, <-33.3364, 48.7311, -25.9615> }
				triangle { <-37.5372, 48.7286, -28.5907>, <-36.509, 48.7231, -28.1887>, <-36.5315, 48.5881, -28.1752> }
				triangle { <-34.6594, 48.9005, -27.1771>, <-36.509, 48.7231, -28.1887>, <-36.5593, 48.8772, -28.1318> }
				triangle { <-34.6604, 48.7155, -27.2081>, <-36.5315, 48.5881, -28.1752>, <-36.509, 48.7231, -28.1887> }
				triangle { <-37.5372, 48.7286, -28.5907>, <-36.5593, 48.8772, -28.1318>, <-36.509, 48.7231, -28.1887> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.0, 3.7136, 0.0>, 0.05734 }
			cylinder { <0.0, 3.7136, 0.0>, <-0.0, 7.4272, 0.0>, 0.05734 }
			cylinder { <-0.0, 7.4272, 0.0>, <-0.0, 11.1408, 0.0>, 0.05734 }
			cylinder { <-0.0, 11.1408, 0.0>, <-0.0, 14.8544, 0.0>, 0.05734 }
			cylinder { <-0.0, 14.8544, 0.0>, <-0.0, 18.568, 0.0>, 0.05734 }
			cylinder { <-0.0, 18.568, 0.0>, <-0.0, 22.2816, 0.0>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.0, 22.2816, 0.0>, <0.1111, 23.3937, 0.03387>, 0.05734 }
				cylinder { <0.1111, 23.3937, 0.03387>, <0.332, 24.4878, 0.1015>, 0.05734 }
				cylinder { <0.332, 24.4878, 0.1015>, <0.6603, 25.5519, 0.2026>, 0.05734 }
				cylinder { <0.6603, 25.5519, 0.2026>, <1.09237, 26.5745, 0.3362>, 0.05734 }
				cylinder { <1.09237, 26.5745, 0.3362>, <1.6232, 27.5447, 0.5013>, 0.05734 }
				cylinder { <1.6232, 27.5447, 0.5013>, <2.2472, 28.4518, 0.6963>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.2472, 28.4518, 0.6963>, <2.2995, 28.5054, 0.7019>, 0.001159 }
				cylinder { <2.2995, 28.5054, 0.7019>, <2.3601, 28.5497, 0.6997>, 0.001159 }
				cylinder { <2.3601, 28.5497, 0.6997>, <2.4267, 28.583, 0.6899>, 0.001159 }
				cylinder { <2.4267, 28.583, 0.6899>, <2.4968, 28.6039, 0.6728>, 0.001159 }
				cylinder { <2.4968, 28.6039, 0.6728>, <2.5676, 28.6118, 0.6491>, 0.001159 }
				cylinder { <2.5676, 28.6118, 0.6491>, <2.6364, 28.6061, 0.6196>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.6364, 28.6061, 0.6196>, <3.6039, 28.8739, 0.04961>, <3.5693, 28.9264, -0.00636> }
				triangle { <3.6039, 28.8739, 0.04961>, <4.1438, 28.9446, -0.3398>, <3.5693, 28.9264, -0.00636> }
				triangle { <4.1438, 28.9446, -0.3398>, <4.08878, 28.9828, -0.405>, <3.5693, 28.9264, -0.00636> }
				triangle { <4.1438, 28.9446, -0.3398>, <5.721, 28.8701, -1.713>, <4.08878, 28.9828, -0.405> }
				triangle { <4.08878, 28.9828, -0.405>, <5.721, 28.8701, -1.713>, <4.0213, 29.01713, -0.462> }
				triangle { <3.5693, 28.9264, -0.00636>, <4.08878, 28.9828, -0.405>, <4.0213, 29.01713, -0.462> }
				triangle { <3.5693, 28.9264, -0.00636>, <4.0213, 29.01713, -0.462>, <3.5108, 28.9566, -0.05157> }
				triangle { <3.5693, 28.9264, -0.00636>, <3.5108, 28.9566, -0.05157>, <2.6364, 28.6061, 0.6196> }
				triangle { <6.5012, 28.7233, -2.4802>, <5.721, 28.8701, -1.713>, <5.7969, 28.781, -1.6409> }
				triangle { <4.0213, 29.01713, -0.462>, <5.721, 28.8701, -1.713>, <5.6236, 28.8854, -1.8537> }
				triangle { <4.1438, 28.9446, -0.3398>, <5.7969, 28.781, -1.6409>, <5.721, 28.8701, -1.713> }
				triangle { <6.5012, 28.7233, -2.4802>, <5.6236, 28.8854, -1.8537>, <5.721, 28.8701, -1.713> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.2472, 28.4518, 0.6963>, <2.8195, 29.3917, 0.895>, 0.05734 }
				cylinder { <2.8195, 29.3917, 0.895>, <3.3383, 30.3615, 1.09665>, 0.05734 }
				cylinder { <3.3383, 30.3615, 1.09665>, <3.802, 31.3583, 1.3006>, 0.05734 }
				cylinder { <3.802, 31.3583, 1.3006>, <4.2093, 32.3791, 1.5062>, 0.05734 }
				cylinder { <4.2093, 32.3791, 1.5062>, <4.559, 33.4209, 1.7129>, 0.05734 }
				cylinder { <4.559, 33.4209, 1.7129>, <4.8499, 34.4805, 1.92>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.8499, 34.4805, 1.92>, <4.8578, 34.5527, 1.9393>, 0.001159 }
				cylinder { <4.8578, 34.5527, 1.9393>, <4.8538, 34.6236, 1.9636>, 0.001159 }
				cylinder { <4.8538, 34.6236, 1.9636>, <4.8381, 34.6913, 1.9919>, 0.001159 }
				cylinder { <4.8381, 34.6913, 1.9919>, <4.8111, 34.7538, 2.0237>, 0.001159 }
				cylinder { <4.8111, 34.7538, 2.0237>, <4.7736, 34.8092, 2.05781>, 0.001159 }
				cylinder { <4.7736, 34.8092, 2.05781>, <4.7267, 34.8559, 2.0933>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.7267, 34.8559, 2.0933>, <3.7625, 35.4199, 2.3846>, <3.726, 35.4189, 2.3087> }
				triangle { <3.7625, 35.4199, 2.3846>, <3.2577, 35.8343, 2.5317>, <3.726, 35.4189, 2.3087> }
				triangle { <3.2577, 35.8343, 2.5317>, <3.2408, 35.8422, 2.4401>, <3.726, 35.4189, 2.3087> }
				triangle { <3.2577, 35.8343, 2.5317>, <1.9086, 37.3866, 2.9177>, <3.2408, 35.8422, 2.4401> }
				triangle { <3.2408, 35.8422, 2.4401>, <1.9086, 37.3866, 2.9177>, <3.2369, 35.8426, 2.3455> }
				triangle { <3.726, 35.4189, 2.3087>, <3.2408, 35.8422, 2.4401>, <3.2369, 35.8426, 2.3455> }
				triangle { <3.726, 35.4189, 2.3087>, <3.2369, 35.8426, 2.3455>, <3.7236, 35.4158, 2.229> }
				triangle { <3.726, 35.4189, 2.3087>, <3.7236, 35.4158, 2.229>, <4.7267, 34.8559, 2.0933> }
				triangle { <1.2918, 38.2852, 3.09391>, <1.9086, 37.3866, 2.9177>, <1.9525, 37.4106, 3.04581> }
				triangle { <3.2369, 35.8426, 2.3455>, <1.9086, 37.3866, 2.9177>, <1.9082, 37.4507, 2.7583> }
				triangle { <3.2577, 35.8343, 2.5317>, <1.9525, 37.4106, 3.04581>, <1.9086, 37.3866, 2.9177> }
				triangle { <1.2918, 38.2852, 3.09391>, <1.9082, 37.4507, 2.7583>, <1.9086, 37.3866, 2.9177> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.8499, 34.4805, 1.92>, <5.2099, 35.5137, 2.1506>, 0.05734 }
				cylinder { <5.2099, 35.5137, 2.1506>, <5.6371, 36.5155, 2.4039>, 0.05734 }
				cylinder { <5.6371, 36.5155, 2.4039>, <6.1296, 37.4811, 2.6785>, 0.05734 }
				cylinder { <6.1296, 37.4811, 2.6785>, <6.6848, 38.4058, 2.9734>, 0.05734 }
				cylinder { <6.6848, 38.4058, 2.9734>, <7.3001, 39.2852, 3.2871>, 0.05734 }
				cylinder { <7.3001, 39.2852, 3.2871>, <7.9724, 40.115, 3.6183>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <7.9724, 40.115, 3.6183>, <8.02671, 40.1646, 3.6338>, 0.001159 }
				cylinder { <8.02671, 40.1646, 3.6338>, <8.08839, 40.2067, 3.6419>, 0.001159 }
				cylinder { <8.08839, 40.2067, 3.6419>, <8.1557, 40.2399, 3.6425>, 0.001159 }
				cylinder { <8.1557, 40.2399, 3.6425>, <8.2267, 40.2633, 3.6356>, 0.001159 }
				cylinder { <8.2267, 40.2633, 3.6356>, <8.2993, 40.2763, 3.6214>, 0.001159 }
				cylinder { <8.2993, 40.2763, 3.6214>, <8.3713, 40.2784, 3.6003>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <8.3713, 40.2784, 3.6003>, <9.3804, 40.675, 3.2041>, <9.3495, 40.7344, 3.1532> }
				triangle { <9.3804, 40.675, 3.2041>, <9.9568, 40.8303, 2.9009>, <9.3495, 40.7344, 3.1532> }
				triangle { <9.9568, 40.8303, 2.9009>, <9.9074, 40.8763, 2.8361>, <9.3495, 40.7344, 3.1532> }
				triangle { <9.9568, 40.8303, 2.9009>, <11.6847, 41.04519, 1.7404>, <9.9074, 40.8763, 2.8361> }
				triangle { <9.9074, 40.8763, 2.8361>, <11.6847, 41.04519, 1.7404>, <9.8451, 40.9165, 2.7772> }
				triangle { <9.3495, 40.7344, 3.1532>, <9.9074, 40.8763, 2.8361>, <9.8451, 40.9165, 2.7772> }
				triangle { <9.3495, 40.7344, 3.1532>, <9.8451, 40.9165, 2.7772>, <9.295, 40.7691, 3.1063> }
				triangle { <9.3495, 40.7344, 3.1532>, <9.295, 40.7691, 3.1063>, <8.3713, 40.2784, 3.6003> }
				triangle { <12.5564, 41.05731, 1.06297>, <11.6847, 41.04519, 1.7404>, <11.757, 40.9488, 1.8066> }
				triangle { <9.8451, 40.9165, 2.7772>, <11.6847, 41.04519, 1.7404>, <11.6036, 41.07904, 1.5928> }
				triangle { <9.9568, 40.8303, 2.9009>, <11.757, 40.9488, 1.8066>, <11.6847, 41.04519, 1.7404> }
				triangle { <12.5564, 41.05731, 1.06297>, <11.6036, 41.07904, 1.5928>, <11.6847, 41.04519, 1.7404> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <7.9724, 40.115, 3.6183>, <8.5953, 40.9806, 3.9545>, 0.05734 }
				cylinder { <8.5953, 40.9806, 3.9545>, <9.1667, 41.8796, 4.2947>, 0.05734 }
				cylinder { <9.1667, 41.8796, 4.2947>, <9.685, 42.8091, 4.6378>, 0.05734 }
				cylinder { <9.685, 42.8091, 4.6378>, <10.1487, 43.7663, 4.9827>, 0.05734 }
				cylinder { <10.1487, 43.7663, 4.9827>, <10.5563, 44.7485, 5.3283>, 0.05734 }
				cylinder { <10.5563, 44.7485, 5.3283>, <10.9066, 45.7527, 5.6737>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <10.9066, 45.7527, 5.6737>, <10.9183, 45.8213, 5.7018>, 0.001159 }
				cylinder { <10.9183, 45.8213, 5.7018>, <10.9178, 45.8891, 5.7341>, 0.001159 }
				cylinder { <10.9178, 45.8891, 5.7341>, <10.9051, 45.9541, 5.7696>, 0.001159 }
				cylinder { <10.9051, 45.9541, 5.7696>, <10.8807, 46.01436, 5.8072>, 0.001159 }
				cylinder { <10.8807, 46.01436, 5.8072>, <10.8452, 46.06808, 5.8458>, 0.001159 }
				cylinder { <10.8452, 46.06808, 5.8458>, <10.7996, 46.1137, 5.8843>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.7996, 46.1137, 5.8843>, <9.8613, 46.7102, 6.1943>, <9.8291, 46.7207, 6.1172> }
				triangle { <9.8613, 46.7102, 6.1943>, <9.3783, 47.1413, 6.3654>, <9.8291, 46.7207, 6.1172> }
				triangle { <9.3783, 47.1413, 6.3654>, <9.3672, 47.1609, 6.2747>, <9.8291, 46.7207, 6.1172> }
				triangle { <9.3783, 47.1413, 6.3654>, <8.1185, 48.7345, 6.8684>, <9.3672, 47.1609, 6.2747> }
				triangle { <9.3672, 47.1609, 6.2747>, <8.1185, 48.7345, 6.8684>, <9.3686, 47.1725, 6.1807> }
				triangle { <9.8291, 46.7207, 6.1172>, <9.3672, 47.1609, 6.2747>, <9.3686, 47.1725, 6.1807> }
				triangle { <9.8291, 46.7207, 6.1172>, <9.3686, 47.1725, 6.1807>, <9.831, 46.7271, 6.03764> }
				triangle { <9.8291, 46.7207, 6.1172>, <9.831, 46.7271, 6.03764>, <10.7996, 46.1137, 5.8843> }
				triangle { <7.5554, 49.65, 7.1206>, <8.1185, 48.7345, 6.8684>, <8.1567, 48.7402, 7.000422> }
				triangle { <9.3686, 47.1725, 6.1807>, <8.1185, 48.7345, 6.8684>, <8.1314, 48.8164, 6.7179> }
				triangle { <9.3783, 47.1413, 6.3654>, <8.1567, 48.7402, 7.000422>, <8.1185, 48.7345, 6.8684> }
				triangle { <7.5554, 49.65, 7.1206>, <8.1314, 48.8164, 6.7179>, <8.1185, 48.7345, 6.8684> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <10.9066, 45.7527, 5.6737>, <11.3225, 46.7228, 6.04262>, 0.05734 }
				cylinder { <11.3225, 46.7228, 6.04262>, <11.8021, 47.6543, 6.4333>, 0.05734 }
				cylinder { <11.8021, 47.6543, 6.4333>, <12.3429, 48.5426, 6.8442>, 0.05734 }
				cylinder { <12.3429, 48.5426, 6.8442>, <12.9423, 49.3834, 7.2732>, 0.05734 }
				cylinder { <12.9423, 49.3834, 7.2732>, <13.5974, 50.1726, 7.7184>, 0.05734 }
				cylinder { <13.5974, 50.1726, 7.7184>, <14.3051, 50.9065, 8.1777>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <14.3051, 50.9065, 8.1777>, <14.3616, 50.9499, 8.2015>, 0.001159 }
				cylinder { <14.3616, 50.9499, 8.2015>, <14.4254, 50.986, 8.2175>, 0.001159 }
				cylinder { <14.4254, 50.986, 8.2175>, <14.4947, 51.01387, 8.2253>, 0.001159 }
				cylinder { <14.4947, 51.01387, 8.2253>, <14.5674, 51.03262, 8.2247>, 0.001159 }
				cylinder { <14.5674, 51.03262, 8.2247>, <14.6414, 51.04172, 8.2156>, 0.001159 }
				cylinder { <14.6414, 51.04172, 8.2156>, <14.7145, 51.04089, 8.1983>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <14.7145, 51.04089, 8.1983>, <15.7689, 51.4045, 7.9009>, <15.745, 51.4715, 7.8559> }
				triangle { <15.7689, 51.4045, 7.9009>, <16.3706, 51.5506, 7.6461>, <15.745, 51.4715, 7.8559> }
				triangle { <16.3706, 51.5506, 7.6461>, <16.3283, 51.6072, 7.585>, <15.745, 51.4715, 7.8559> }
				triangle { <16.3706, 51.5506, 7.6461>, <18.1716, 51.769, 6.6034>, <16.3283, 51.6072, 7.585> }
				triangle { <16.3283, 51.6072, 7.585>, <18.1716, 51.769, 6.6034>, <16.2722, 51.6585, 7.5284> }
				triangle { <15.745, 51.4715, 7.8559>, <16.3283, 51.6072, 7.585>, <16.2722, 51.6585, 7.5284> }
				triangle { <15.745, 51.4715, 7.8559>, <16.2722, 51.6585, 7.5284>, <15.6957, 51.5154, 7.811> }
				triangle { <15.745, 51.4715, 7.8559>, <15.6957, 51.5154, 7.811>, <14.7145, 51.04089, 8.1983> }
				triangle { <19.07883, 51.7944, 5.9746>, <18.1716, 51.769, 6.6034>, <18.2334, 51.6605, 6.661> }
				triangle { <16.2722, 51.6585, 7.5284>, <18.1716, 51.769, 6.6034>, <18.1015, 51.8255, 6.4571> }
				triangle { <16.3706, 51.5506, 7.6461>, <18.2334, 51.6605, 6.661>, <18.1716, 51.769, 6.6034> }
				triangle { <19.07883, 51.7944, 5.9746>, <18.1015, 51.8255, 6.4571>, <18.1716, 51.769, 6.6034> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <14.3051, 50.9065, 8.1777>, <15.06532, 51.563, 8.669>, 0.05734 }
				cylinder { <15.06532, 51.563, 8.669>, <15.8721, 52.137, 9.1886>, 0.05734 }
				cylinder { <15.8721, 52.137, 9.1886>, <16.719, 52.6239, 9.7325>, 0.05734 }
				cylinder { <16.719, 52.6239, 9.7325>, <17.5994, 53.02005, 10.2968>, 0.05734 }
				cylinder { <17.5994, 53.02005, 10.2968>, <18.5062, 53.3222, 10.877>, 0.05734 }
				cylinder { <18.5062, 53.3222, 10.877>, <19.4323, 53.5281, 11.4688>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <19.4323, 53.5281, 11.4688>, <19.4914, 53.5448, 11.512>, 0.001159 }
				cylinder { <19.4914, 53.5448, 11.512>, <19.547, 53.5645, 11.5585>, 0.001159 }
				cylinder { <19.547, 53.5645, 11.5585>, <19.5989, 53.5869, 11.608>, 0.001159 }
				cylinder { <19.5989, 53.5869, 11.608>, <19.6467, 53.6119, 11.6601>, 0.001159 }
				cylinder { <19.6467, 53.6119, 11.6601>, <19.6903, 53.6394, 11.7148>, 0.001159 }
				cylinder { <19.6903, 53.6394, 11.7148>, <19.7294, 53.6693, 11.7715>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <19.7294, 53.6693, 11.7715>, <20.1244, 54.4354, 12.5393>, <20.1137, 54.5044, 12.4923> }
				triangle { <20.1244, 54.4354, 12.5393>, <20.4481, 54.8602, 12.9431>, <20.1137, 54.5044, 12.4923> }
				triangle { <20.4481, 54.8602, 12.9431>, <20.449, 54.9222, 12.8731>, <20.1137, 54.5044, 12.4923> }
				triangle { <20.4481, 54.8602, 12.9431>, <21.7501, 56.07689, 14.04>, <20.449, 54.9222, 12.8731> }
				triangle { <20.449, 54.9222, 12.8731>, <21.7501, 56.07689, 14.04>, <20.4446, 54.9734, 12.7935> }
				triangle { <20.1137, 54.5044, 12.4923>, <20.449, 54.9222, 12.8731>, <20.4446, 54.9734, 12.7935> }
				triangle { <20.1137, 54.5044, 12.4923>, <20.4446, 54.9734, 12.7935>, <20.1068, 54.5462, 12.4246> }
				triangle { <20.1137, 54.5044, 12.4923>, <20.1068, 54.5462, 12.4246>, <19.7294, 53.6693, 11.7715> }
				triangle { <22.5311, 56.6664, 14.5514>, <21.7501, 56.07689, 14.04>, <21.787, 55.9792, 14.1295> }
				triangle { <20.4446, 54.9734, 12.7935>, <21.7501, 56.07689, 14.04>, <21.8063, 56.169, 13.9062> }
				triangle { <20.4481, 54.8602, 12.9431>, <21.787, 55.9792, 14.1295>, <21.7501, 56.07689, 14.04> }
				triangle { <22.5311, 56.6664, 14.5514>, <21.8063, 56.169, 13.9062>, <21.7501, 56.07689, 14.04> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <19.4323, 53.5281, 11.4688>, <20.3679, 53.6964, 12.05752>, 0.05734 }
				cylinder { <20.3679, 53.6964, 12.05752>, <21.312, 53.8271, 12.6423>, 0.05734 }
				cylinder { <21.312, 53.8271, 12.6423>, <22.2633, 53.92, 13.2225>, 0.05734 }
				cylinder { <22.2633, 53.92, 13.2225>, <23.2207, 53.9749, 13.7975>, 0.05734 }
				cylinder { <23.2207, 53.9749, 13.7975>, <24.1831, 53.9917, 14.3666>, 0.05734 }
				cylinder { <24.1831, 53.9917, 14.3666>, <25.1492, 53.9705, 14.9291>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <25.1492, 53.9705, 14.9291>, <25.2179, 53.963, 14.9585>, 0.001159 }
				cylinder { <25.2179, 53.963, 14.9585>, <25.289, 53.9496, 14.9789>, 0.001159 }
				cylinder { <25.289, 53.9496, 14.9789>, <25.3608, 53.9305, 14.9898>, 0.001159 }
				cylinder { <25.3608, 53.9305, 14.9898>, <25.4318, 53.9062, 14.9909>, 0.001159 }
				cylinder { <25.4318, 53.9062, 14.9909>, <25.5005, 53.8771, 14.9824>, 0.001159 }
				cylinder { <25.5005, 53.8771, 14.9824>, <25.5655, 53.844, 14.9643>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <25.5655, 53.844, 14.9643>, <26.6951, 53.6798, 14.7928>, <26.7152, 53.7597, 14.7753> }
				triangle { <26.6951, 53.6798, 14.7928>, <27.3238, 53.5643, 14.5935>, <26.7152, 53.7597, 14.7753> }
				triangle { <27.3238, 53.5643, 14.5935>, <27.3257, 53.6506, 14.5577>, <26.7152, 53.7597, 14.7753> }
				triangle { <27.3238, 53.5643, 14.5935>, <29.1449, 53.1334, 13.6573>, <27.3257, 53.6506, 14.5577> }
				triangle { <27.3257, 53.6506, 14.5577>, <29.1449, 53.1334, 13.6573>, <27.3125, 53.7383, 14.5245> }
				triangle { <26.7152, 53.7597, 14.7753>, <27.3257, 53.6506, 14.5577>, <27.3125, 53.7383, 14.5245> }
				triangle { <26.7152, 53.7597, 14.7753>, <27.3125, 53.7383, 14.5245>, <26.7021, 53.8343, 14.7502> }
				triangle { <26.7152, 53.7597, 14.7753>, <26.7021, 53.8343, 14.7502>, <25.5655, 53.844, 14.9643> }
				triangle { <30.03801, 52.882, 13.05888>, <29.1449, 53.1334, 13.6573>, <29.1347, 52.997, 13.6709> }
				triangle { <27.3125, 53.7383, 14.5245>, <29.1449, 53.1334, 13.6573>, <29.1373, 53.261, 13.5426> }
				triangle { <27.3238, 53.5643, 14.5935>, <29.1347, 52.997, 13.6709>, <29.1449, 53.1334, 13.6573> }
				triangle { <30.03801, 52.882, 13.05888>, <29.1373, 53.261, 13.5426>, <29.1449, 53.1334, 13.6573> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <25.1492, 53.9705, 14.9291>, <26.1039, 53.9646, 15.5113>, 0.05734 }
				cylinder { <26.1039, 53.9646, 15.5113>, <27.04644, 53.9738, 16.1128>, 0.05734 }
				cylinder { <27.04644, 53.9738, 16.1128>, <27.9763, 53.9983, 16.7334>, 0.05734 }
				cylinder { <27.9763, 53.9983, 16.7334>, <28.8929, 54.03807, 17.3725>, 0.05734 }
				cylinder { <28.8929, 54.03807, 17.3725>, <29.7957, 54.09296, 18.02998>, 0.05734 }
				cylinder { <29.7957, 54.09296, 18.02998>, <30.6842, 54.163, 18.7052>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <30.6842, 54.163, 18.7052>, <30.7374, 54.1737, 18.7571>, 0.001159 }
				cylinder { <30.7374, 54.1737, 18.7571>, <30.7829, 54.1902, 18.8145>, 0.001159 }
				cylinder { <30.7829, 54.1902, 18.8145>, <30.8198, 54.2122, 18.8761>, 0.001159 }
				cylinder { <30.8198, 54.2122, 18.8761>, <30.8472, 54.2391, 18.9407>, 0.001159 }
				cylinder { <30.8472, 54.2391, 18.9407>, <30.8646, 54.2704, 19.00671>, 0.001159 }
				cylinder { <30.8646, 54.2704, 19.00671>, <30.8716, 54.3054, 19.07278>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <30.8716, 54.3054, 19.07278>, <30.8059, 55.1208, 19.8872>, <30.8089, 55.1875, 19.836> }
				triangle { <30.8059, 55.1208, 19.8872>, <30.8726, 55.5861, 20.3639>, <30.8089, 55.1875, 19.836> }
				triangle { <30.8726, 55.5861, 20.3639>, <30.8966, 55.6473, 20.2974>, <30.8089, 55.1875, 19.836> }
				triangle { <30.8726, 55.5861, 20.3639>, <31.4248, 56.967, 21.836>, <30.8966, 55.6473, 20.2974> }
				triangle { <30.8966, 55.6473, 20.2974>, <31.4248, 56.967, 21.836>, <30.9214, 55.697, 20.2206> }
				triangle { <30.8089, 55.1875, 19.836>, <30.8966, 55.6473, 20.2974>, <30.9214, 55.697, 20.2206> }
				triangle { <30.8089, 55.1875, 19.836>, <30.9214, 55.697, 20.2206>, <30.8273, 55.2276, 19.7695> }
				triangle { <30.8089, 55.1875, 19.836>, <30.8273, 55.2276, 19.7695>, <30.8716, 54.3054, 19.07278> }
				triangle { <31.8352, 57.6552, 22.5955>, <31.4248, 56.967, 21.836>, <31.4301, 56.8755, 21.9384> }
				triangle { <30.9214, 55.697, 20.2206>, <31.4248, 56.967, 21.836>, <31.5225, 57.06476, 21.7338> }
				triangle { <30.8726, 55.5861, 20.3639>, <31.4301, 56.8755, 21.9384>, <31.4248, 56.967, 21.836> }
				triangle { <31.8352, 57.6552, 22.5955>, <31.5225, 57.06476, 21.7338>, <31.4248, 56.967, 21.836> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <30.6842, 54.163, 18.7052>, <30.7449, 54.1666, 18.7493>, 0.001159 }
				cylinder { <30.7449, 54.1666, 18.7493>, <30.8064, 54.1693, 18.7922>, 0.001159 }
				cylinder { <30.8064, 54.1693, 18.7922>, <30.8689, 54.171, 18.8339>, 0.001159 }
				cylinder { <30.8689, 54.171, 18.8339>, <30.9322, 54.1716, 18.8743>, 0.001159 }
				cylinder { <30.9322, 54.1716, 18.8743>, <30.9963, 54.1712, 18.9134>, 0.001159 }
				cylinder { <30.9963, 54.1712, 18.9134>, <31.06121, 54.1698, 18.9512>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <31.06121, 54.1698, 18.9512>, <31.9774, 54.5221, 19.5585>, <31.9809, 54.6006, 19.5284> }
				triangle { <31.9774, 54.5221, 19.5585>, <32.5659, 54.6882, 19.8312>, <31.9809, 54.6006, 19.5284> }
				triangle { <32.5659, 54.6882, 19.8312>, <32.5683, 54.7627, 19.7747>, <31.9809, 54.6006, 19.5284> }
				triangle { <32.5659, 54.6882, 19.8312>, <34.5463, 55.0542, 20.3995>, <32.5683, 54.7627, 19.7747> }
				triangle { <32.5683, 54.7627, 19.7747>, <34.5463, 55.0542, 20.3995>, <32.5584, 54.8318, 19.7107> }
				triangle { <31.9809, 54.6006, 19.5284>, <32.5683, 54.7627, 19.7747>, <32.5584, 54.8318, 19.7107> }
				triangle { <31.9809, 54.6006, 19.5284>, <32.5584, 54.8318, 19.7107>, <31.9691, 54.6589, 19.475> }
				triangle { <31.9809, 54.6006, 19.5284>, <31.9691, 54.6589, 19.475>, <31.06121, 54.1698, 18.9512> }
				triangle { <35.6251, 55.1865, 20.5933>, <34.5463, 55.0542, 20.3995>, <34.5676, 54.9296, 20.4536> }
				triangle { <32.5584, 54.8318, 19.7107>, <34.5463, 55.0542, 20.3995>, <34.5856, 55.1545, 20.2657> }
				triangle { <32.5659, 54.6882, 19.8312>, <34.5676, 54.9296, 20.4536>, <34.5463, 55.0542, 20.3995> }
				triangle { <35.6251, 55.1865, 20.5933>, <34.5856, 55.1545, 20.2657>, <34.5463, 55.0542, 20.3995> }
				texture{Grass_Texture5}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 11.2873, 0.0>, 0.07351 }
			cylinder { <-0.0, 11.2873, 0.0>, <-0.0, 22.5746, 0.0>, 0.07351 }
			cylinder { <-0.0, 22.5746, 0.0>, <-0.00000001, 33.862, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 33.862, 0.0>, <-0.00000001, 45.1493, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 45.1493, 0.0>, <-0.00000001, 56.4367, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 56.4367, 0.0>, <-0.00000001, 67.724, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <0.01222, 68.2486, 0.01349>, 0.07351 }
			cylinder { <0.01222, 68.2486, 0.01349>, <0.03666, 68.7722, 0.04047>, 0.07351 }
			cylinder { <0.03666, 68.7722, 0.04047>, <0.07328, 69.2942, 0.08091>, 0.07351 }
			cylinder { <0.07328, 69.2942, 0.08091>, <0.122, 69.814, 0.1347>, 0.07351 }
			cylinder { <0.122, 69.814, 0.1347>, <0.1828, 70.331, 0.2019>, 0.07351 }
			cylinder { <0.1828, 70.331, 0.2019>, <0.2556, 70.8445, 0.2824>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.2556, 70.8445, 0.2824>, <0.3403, 71.354, 0.376>, 0.07351 }
			cylinder { <0.3403, 71.354, 0.376>, <0.4368, 71.8587, 0.4827>, 0.07351 }
			cylinder { <0.4368, 71.8587, 0.4827>, <0.5449, 72.3582, 0.6024>, 0.07351 }
			cylinder { <0.5449, 72.3582, 0.6024>, <0.6646, 72.8517, 0.7349>, 0.07351 }
			cylinder { <0.6646, 72.8517, 0.7349>, <0.7957, 73.3388, 0.88>, 0.07351 }
			cylinder { <0.7957, 73.3388, 0.88>, <0.938, 73.8188, 1.03763>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.938, 73.8188, 1.03763>, <1.08114, 74.3039, 1.1777>, 0.07351 }
			cylinder { <1.08114, 74.3039, 1.1777>, <1.2247, 74.7937, 1.3002>, 0.07351 }
			cylinder { <1.2247, 74.7937, 1.3002>, <1.3688, 75.2874, 1.405>, 0.07351 }
			cylinder { <1.3688, 75.2874, 1.405>, <1.5131, 75.7845, 1.4918>, 0.07351 }
			cylinder { <1.5131, 75.7845, 1.4918>, <1.6576, 76.2844, 1.5607>, 0.07351 }
			cylinder { <1.6576, 76.2844, 1.5607>, <1.8019, 76.7864, 1.6115>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.8019, 76.7864, 1.6115>, <1.8191, 76.8395, 1.6149>, 0.07351 }
				cylinder { <1.8191, 76.8395, 1.6149>, <1.8381, 76.892, 1.6162>, 0.07351 }
				cylinder { <1.8381, 76.892, 1.6162>, <1.8588, 76.9439, 1.6156>, 0.07351 }
				cylinder { <1.8588, 76.9439, 1.6156>, <1.8812, 76.995, 1.613>, 0.07351 }
				cylinder { <1.8812, 76.995, 1.613>, <1.9052, 77.0453, 1.6083>, 0.07351 }
				cylinder { <1.9052, 77.0453, 1.6083>, <1.9308, 77.0945, 1.6016>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.9308, 77.0945, 1.6016>, <3.1526, 78.9855, 1.1658>, <2.9688, 79.1554, 1.2235> }
					triangle { <3.1526, 78.9855, 1.1658>, <3.768, 80.0993, 1.1181>, <2.9688, 79.1554, 1.2235> }
					triangle { <3.768, 80.0993, 1.1181>, <3.5573, 80.2832, 1.176>, <2.9688, 79.1554, 1.2235> }
					triangle { <3.768, 80.0993, 1.1181>, <4.3699, 81.9064, 1.08283>, <3.5573, 80.2832, 1.176> }
					triangle { <3.5573, 80.2832, 1.176>, <4.3699, 81.9064, 1.08283>, <3.285, 80.3515, 1.1236> }
					triangle { <2.9688, 79.1554, 1.2235>, <3.5573, 80.2832, 1.176>, <3.285, 80.3515, 1.1236> }
					triangle { <2.9688, 79.1554, 1.2235>, <3.285, 80.3515, 1.1236>, <2.7248, 79.2119, 1.2009> }
					triangle { <2.9688, 79.1554, 1.2235>, <2.7248, 79.2119, 1.2009>, <1.9308, 77.0945, 1.6016> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.8019, 76.7864, 1.6115>, <1.9345, 77.2901, 1.6761>, 0.07351 }
			cylinder { <1.9345, 77.2901, 1.6761>, <2.05525, 77.7949, 1.7544>, 0.07351 }
			cylinder { <2.05525, 77.7949, 1.7544>, <2.1639, 78.3001, 1.8465>, 0.07351 }
			cylinder { <2.1639, 78.3001, 1.8465>, <2.2604, 78.8051, 1.9521>, 0.07351 }
			cylinder { <2.2604, 78.8051, 1.9521>, <2.3446, 79.3093, 2.07115>, 0.07351 }
			cylinder { <2.3446, 79.3093, 2.07115>, <2.4164, 79.8121, 2.2034>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.4164, 79.8121, 2.2034>, <2.4214, 79.8659, 2.2176>, 0.07351 }
				cylinder { <2.4214, 79.8659, 2.2176>, <2.4235, 79.9198, 2.232>, 0.07351 }
				cylinder { <2.4235, 79.9198, 2.232>, <2.423, 79.9738, 2.2464>, 0.07351 }
				cylinder { <2.423, 79.9738, 2.2464>, <2.4197, 80.02773, 2.2608>, 0.07351 }
				cylinder { <2.4197, 80.02773, 2.2608>, <2.4137, 80.08137, 2.2753>, 0.07351 }
				cylinder { <2.4137, 80.08137, 2.2753>, <2.4049, 80.1346, 2.2897>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <2.4049, 80.1346, 2.2897>, <1.5589, 81.8586, 3.1876>, <1.753, 81.9278, 3.3056> }
					triangle { <1.5589, 81.8586, 3.1876>, <1.2472, 82.9105, 3.6141>, <1.753, 81.9278, 3.3056> }
					triangle { <1.2472, 82.9105, 3.6141>, <1.4637, 82.9788, 3.7489>, <1.753, 81.9278, 3.3056> }
					triangle { <1.2472, 82.9105, 3.6141>, <1.06024, 84.4676, 4.4154>, <1.4637, 82.9788, 3.7489> }
					triangle { <1.4637, 82.9788, 3.7489>, <1.06024, 84.4676, 4.4154>, <1.651, 82.8947, 3.915> }
					triangle { <1.753, 81.9278, 3.3056>, <1.4637, 82.9788, 3.7489>, <1.651, 82.8947, 3.915> }
					triangle { <1.753, 81.9278, 3.3056>, <1.651, 82.8947, 3.915>, <1.9327, 81.8583, 3.4357> }
					triangle { <1.753, 81.9278, 3.3056>, <1.9327, 81.8583, 3.4357>, <2.4049, 80.1346, 2.2897> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.4164, 79.8121, 2.2034>, <2.5062, 80.3125, 2.3337>, 0.07351 }
			cylinder { <2.5062, 80.3125, 2.3337>, <2.6138, 80.81, 2.4618>, 0.07351 }
			cylinder { <2.6138, 80.81, 2.4618>, <2.7391, 81.3039, 2.5876>, 0.07351 }
			cylinder { <2.7391, 81.3039, 2.5876>, <2.882, 81.7936, 2.711>, 0.07351 }
			cylinder { <2.882, 81.7936, 2.711>, <3.04237, 82.2786, 2.8318>, 0.07351 }
			cylinder { <3.04237, 82.2786, 2.8318>, <3.2198, 82.7582, 2.9498>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.2198, 82.7582, 2.9498>, <3.2406, 82.8081, 2.964>, 0.07351 }
				cylinder { <3.2406, 82.8081, 2.964>, <3.2633, 82.8567, 2.9796>, 0.07351 }
				cylinder { <3.2633, 82.8567, 2.9796>, <3.2879, 82.9039, 2.9967>, 0.07351 }
				cylinder { <3.2879, 82.9039, 2.9967>, <3.3142, 82.9496, 3.01531>, 0.07351 }
				cylinder { <3.3142, 82.9496, 3.01531>, <3.3422, 82.9936, 3.03526>, 0.07351 }
				cylinder { <3.3422, 82.9936, 3.03526>, <3.3719, 83.03594, 3.05655>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <3.3719, 83.03594, 3.05655>, <4.8255, 84.1275, 3.7505>, <4.8058, 84.2914, 3.6081> }
					triangle { <4.8255, 84.1275, 3.7505>, <5.5105, 84.868, 4.1374>, <4.8058, 84.2914, 3.6081> }
					triangle { <5.5105, 84.868, 4.1374>, <5.4889, 85.0445, 3.9727>, <4.8058, 84.2914, 3.6081> }
					triangle { <5.5105, 84.868, 4.1374>, <6.479, 86.1207, 4.4628>, <5.4889, 85.0445, 3.9727> }
					triangle { <5.4889, 85.0445, 3.9727>, <6.479, 86.1207, 4.4628>, <5.4746, 85.09491, 3.7361> }
					triangle { <4.8058, 84.2914, 3.6081>, <5.4889, 85.0445, 3.9727>, <5.4746, 85.09491, 3.7361> }
					triangle { <4.8058, 84.2914, 3.6081>, <5.4746, 85.09491, 3.7361>, <4.7745, 84.3434, 3.4036> }
					triangle { <4.8058, 84.2914, 3.6081>, <4.7745, 84.3434, 3.4036>, <3.3719, 83.03594, 3.05655> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.2198, 82.7582, 2.9498>, <3.3836, 83.245, 3.05817>, 0.07351 }
			cylinder { <3.3836, 83.245, 3.05817>, <3.5337, 83.7382, 3.1565>, 0.07351 }
			cylinder { <3.5337, 83.7382, 3.1565>, <3.6697, 84.2374, 3.2449>, 0.07351 }
			cylinder { <3.6697, 84.2374, 3.2449>, <3.7915, 84.7419, 3.3231>, 0.07351 }
			cylinder { <3.7915, 84.7419, 3.3231>, <3.899, 85.2511, 3.3911>, 0.07351 }
			cylinder { <3.899, 85.2511, 3.3911>, <3.9921, 85.7644, 3.4488>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.9921, 85.7644, 3.4488>, <4.001591, 85.8194, 3.4522>, 0.07351 }
				cylinder { <4.001591, 85.8194, 3.4522>, <4.01061, 85.8745, 3.453>, 0.07351 }
				cylinder { <4.01061, 85.8745, 3.453>, <4.01915, 85.9297, 3.451>, 0.07351 }
				cylinder { <4.01915, 85.9297, 3.451>, <4.02719, 85.9848, 3.4464>, 0.07351 }
				cylinder { <4.02719, 85.9848, 3.4464>, <4.03472, 86.03973, 3.439>, 0.07351 }
				cylinder { <4.03472, 86.03973, 3.439>, <4.04172, 86.09425, 3.429>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.04172, 86.09425, 3.429>, <4.1382, 87.7642, 2.8482>, <4.08362, 87.8518, 3.0176> }
					triangle { <4.1382, 87.7642, 2.8482>, <4.2841, 88.7182, 2.66>, <4.08362, 87.8518, 3.0176> }
					triangle { <4.2841, 88.7182, 2.66>, <4.2172, 88.8109, 2.8486>, <4.08362, 87.8518, 3.0176> }
					triangle { <4.2841, 88.7182, 2.66>, <4.3789, 90.1855, 2.6157>, <4.2172, 88.8109, 2.8486> }
					triangle { <4.2172, 88.8109, 2.8486>, <4.3789, 90.1855, 2.6157>, <4.06243, 88.81, 3.005666> }
					triangle { <4.08362, 87.8518, 3.0176>, <4.2172, 88.8109, 2.8486>, <4.06243, 88.81, 3.005666> }
					triangle { <4.08362, 87.8518, 3.0176>, <4.06243, 88.81, 3.005666>, <3.9608, 87.8464, 3.1679> }
					triangle { <4.08362, 87.8518, 3.0176>, <3.9608, 87.8464, 3.1679>, <4.04172, 86.09425, 3.429> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.9921, 85.7644, 3.4488>, <4.08878, 86.2748, 3.524>, 0.07351 }
			cylinder { <4.08878, 86.2748, 3.524>, <4.1889, 86.7816, 3.6168>, 0.07351 }
			cylinder { <4.1889, 86.7816, 3.6168>, <4.2924, 87.2842, 3.7271>, 0.07351 }
			cylinder { <4.2924, 87.2842, 3.7271>, <4.3991, 87.782, 3.8546>, 0.07351 }
			cylinder { <4.3991, 87.782, 3.8546>, <4.5089, 88.2745, 3.9992>, 0.07351 }
			cylinder { <4.5089, 88.2745, 3.9992>, <4.6217, 88.7609, 4.1608>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.6217, 88.7609, 4.1608>, <4.6321, 88.8123, 4.1802>, 0.07351 }
				cylinder { <4.6321, 88.8123, 4.1802>, <4.641, 88.8631, 4.2017>, 0.07351 }
				cylinder { <4.641, 88.8631, 4.2017>, <4.6482, 88.9132, 4.2254>, 0.07351 }
				cylinder { <4.6482, 88.9132, 4.2254>, <4.6537, 88.9625, 4.2511>, 0.07351 }
				cylinder { <4.6537, 88.9625, 4.2511>, <4.6576, 89.01089, 4.2788>, 0.07351 }
				cylinder { <4.6576, 89.01089, 4.2788>, <4.6599, 89.05822, 4.3084>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <4.6599, 89.05822, 4.3084>, <4.6648, 90.1489, 5.4721>, <4.8228, 90.2223, 5.4324> }
					triangle { <4.6648, 90.1489, 5.4721>, <4.6981, 90.8518, 6.009892>, <4.8228, 90.2223, 5.4324> }
					triangle { <4.6981, 90.8518, 6.009892>, <4.8765, 90.927, 5.9657>, <4.8228, 90.2223, 5.4324> }
					triangle { <4.6981, 90.8518, 6.009892>, <4.9777, 91.924, 6.7365>, <4.8765, 90.927, 5.9657> }
					triangle { <4.8765, 90.927, 5.9657>, <4.9777, 91.924, 6.7365>, <5.06724, 90.884, 5.9301> }
					triangle { <4.8228, 90.2223, 5.4324>, <4.8765, 90.927, 5.9657>, <5.06724, 90.884, 5.9301> }
					triangle { <4.8228, 90.2223, 5.4324>, <5.06724, 90.884, 5.9301>, <4.9884, 90.1909, 5.3857> }
					triangle { <4.8228, 90.2223, 5.4324>, <4.9884, 90.1909, 5.3857>, <4.6599, 89.05822, 4.3084> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <0.00000273, 68.2486, -0.01821>, 0.07351 }
			cylinder { <0.00000273, 68.2486, -0.01821>, <0.0000137, 68.7722, -0.05461>, 0.07351 }
			cylinder { <0.0000137, 68.7722, -0.05461>, <0.00003838, 69.2942, -0.1091>, 0.07351 }
			cylinder { <0.00003838, 69.2942, -0.1091>, <0.00008221, 69.814, -0.1818>, 0.07351 }
			cylinder { <0.00008221, 69.814, -0.1818>, <0.0001506, 70.331, -0.2724>, 0.07351 }
			cylinder { <0.0001506, 70.331, -0.2724>, <0.000249, 70.8445, -0.3809>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.000249, 70.8445, -0.3809>, <0.0965, 71.3212, -0.5783>, 0.07351 }
			cylinder { <0.0965, 71.3212, -0.5783>, <0.1808, 71.8049, -0.7638>, 0.07351 }
			cylinder { <0.1808, 71.8049, -0.7638>, <0.2532, 72.295, -0.9371>, 0.07351 }
			cylinder { <0.2532, 72.295, -0.9371>, <0.3135, 72.7909, -1.09816>, 0.07351 }
			cylinder { <0.3135, 72.7909, -1.09816>, <0.3616, 73.292, -1.2466>, 0.07351 }
			cylinder { <0.3616, 73.292, -1.2466>, <0.3975, 73.7977, -1.3824>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.3975, 73.7977, -1.3824>, <0.3986, 73.8517, -1.3968>, 0.07351 }
				cylinder { <0.3986, 73.8517, -1.3968>, <0.397, 73.9057, -1.411>, 0.07351 }
				cylinder { <0.397, 73.9057, -1.411>, <0.3926, 73.9596, -1.4251>, 0.07351 }
				cylinder { <0.3926, 73.9596, -1.4251>, <0.3855, 74.01332, -1.439>, 0.07351 }
				cylinder { <0.3855, 74.01332, -1.439>, <0.3756, 74.0666, -1.4526>, 0.07351 }
				cylinder { <0.3756, 74.0666, -1.4526>, <0.3631, 74.1193, -1.466>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.3631, 74.1193, -1.466>, <-0.3062, 75.7261, -1.7915>, <-0.1505, 75.8306, -1.7268> }
					triangle { <-0.3062, 75.7261, -1.7915>, <-0.5353, 76.6464, -2.05089>, <-0.1505, 75.8306, -1.7268> }
					triangle { <-0.5353, 76.6464, -2.05089>, <-0.3624, 76.7585, -1.9723>, <-0.1505, 75.8306, -1.7268> }
					triangle { <-0.5353, 76.6464, -2.05089>, <-0.6605, 78.09193, -2.2936>, <-0.3624, 76.7585, -1.9723> }
					triangle { <-0.3624, 76.7585, -1.9723>, <-0.6605, 78.09193, -2.2936>, <-0.2254, 76.7832, -1.8012> }
					triangle { <-0.1505, 75.8306, -1.7268>, <-0.3624, 76.7585, -1.9723>, <-0.2254, 76.7832, -1.8012> }
					triangle { <-0.1505, 75.8306, -1.7268>, <-0.2254, 76.7832, -1.8012>, <-0.01603, 75.8474, -1.5877> }
					triangle { <-0.1505, 75.8306, -1.7268>, <-0.01603, 75.8474, -1.5877>, <0.3631, 74.1193, -1.466> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.3975, 73.7977, -1.3824>, <0.4515, 74.3015, -1.5195>, 0.07351 }
			cylinder { <0.4515, 74.3015, -1.5195>, <0.5235, 74.8027, -1.6576>, 0.07351 }
			cylinder { <0.5235, 74.8027, -1.6576>, <0.6134, 75.3008, -1.7967>, 0.07351 }
			cylinder { <0.6134, 75.3008, -1.7967>, <0.7211, 75.7951, -1.9365>, 0.07351 }
			cylinder { <0.7211, 75.7951, -1.9365>, <0.8465, 76.285, -2.07692>, 0.07351 }
			cylinder { <0.8465, 76.285, -2.07692>, <0.9894, 76.77, -2.2177>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9894, 76.77, -2.2177>, <1.006671, 76.8215, -2.2308>, 0.07351 }
				cylinder { <1.006671, 76.8215, -2.2308>, <1.02587, 76.8728, -2.242>, 0.07351 }
				cylinder { <1.02587, 76.8728, -2.242>, <1.04701, 76.9237, -2.2514>, 0.07351 }
				cylinder { <1.04701, 76.9237, -2.2514>, <1.07003, 76.974, -2.2588>, 0.07351 }
				cylinder { <1.07003, 76.974, -2.2588>, <1.09487, 77.02382, -2.2643>, 0.07351 }
				cylinder { <1.09487, 77.02382, -2.2643>, <1.1214, 77.07282, -2.2677>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.1214, 77.07282, -2.2677>, <2.206, 78.2421, -2.2469>, <2.181, 78.2978, -2.4148> }
					triangle { <2.206, 78.2421, -2.2469>, <2.6983, 78.9772, -2.2874>, <2.181, 78.2978, -2.4148> }
					triangle { <2.6983, 78.9772, -2.2874>, <2.6713, 79.03254, -2.4763>, <2.181, 78.2978, -2.4148> }
					triangle { <2.6983, 78.9772, -2.2874>, <3.3841, 80.07089, -2.5863>, <2.6713, 79.03254, -2.4763> }
					triangle { <2.6713, 79.03254, -2.4763>, <3.3841, 80.07089, -2.5863>, <2.6618, 78.97, -2.6646> }
					triangle { <2.181, 78.2978, -2.4148>, <2.6713, 79.03254, -2.4763>, <2.6618, 78.97, -2.6646> }
					triangle { <2.181, 78.2978, -2.4148>, <2.6618, 78.97, -2.6646>, <2.1567, 78.2483, -2.5808> }
					triangle { <2.181, 78.2978, -2.4148>, <2.1567, 78.2483, -2.5808>, <1.1214, 77.07282, -2.2677> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.000249, 70.8445, -0.3809>, <-0.01191, 71.3605, -0.4762>, 0.07351 }
			cylinder { <-0.01191, 71.3605, -0.4762>, <-0.03631, 71.8784, -0.5581>, 0.07351 }
			cylinder { <-0.03631, 71.8784, -0.5581>, <-0.07294, 72.3974, -0.6265>, 0.07351 }
			cylinder { <-0.07294, 72.3974, -0.6265>, <-0.1217, 72.9171, -0.6815>, 0.07351 }
			cylinder { <-0.1217, 72.9171, -0.6815>, <-0.1826, 73.4368, -0.7228>, 0.07351 }
			cylinder { <-0.1826, 73.4368, -0.7228>, <-0.2556, 73.9558, -0.7505>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.2556, 73.9558, -0.7505>, <-0.4596, 74.4391, -0.7696>, 0.07351 }
			cylinder { <-0.4596, 74.4391, -0.7696>, <-0.6467, 74.929, -0.7909>, 0.07351 }
			cylinder { <-0.6467, 74.929, -0.7909>, <-0.8168, 75.425, -0.8144>, 0.07351 }
			cylinder { <-0.8168, 75.425, -0.8144>, <-0.9696, 75.9264, -0.8401>, 0.07351 }
			cylinder { <-0.9696, 75.9264, -0.8401>, <-1.1051, 76.4327, -0.8679>, 0.07351 }
			cylinder { <-1.1051, 76.4327, -0.8679>, <-1.2229, 76.9433, -0.8978>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.2229, 76.9433, -0.8978>, <-1.2334, 76.9982, -0.8993>, 0.07351 }
				cylinder { <-1.2334, 76.9982, -0.8993>, <-1.2417, 77.05347, -0.8991>, 0.07351 }
				cylinder { <-1.2417, 77.05347, -0.8991>, <-1.2479, 77.1089, -0.8972>, 0.07351 }
				cylinder { <-1.2479, 77.1089, -0.8972>, <-1.252, 77.1645, -0.8935>, 0.07351 }
				cylinder { <-1.252, 77.1645, -0.8935>, <-1.2539, 77.2201, -0.8882>, 0.07351 }
				cylinder { <-1.2539, 77.2201, -0.8882>, <-1.2537, 77.2755, -0.8812>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.2537, 77.2755, -0.8812>, <-0.9772, 78.9904, -0.5371>, <-1.04885, 79.06116, -0.708> }
					triangle { <-0.9772, 78.9904, -0.5371>, <-0.982, 79.9624, -0.3888>, <-1.04885, 79.06116, -0.708> }
					triangle { <-0.982, 79.9624, -0.3888>, <-1.0571, 80.03605, -0.5827>, <-1.04885, 79.06116, -0.708> }
					triangle { <-0.982, 79.9624, -0.3888>, <-1.05248, 81.4312, -0.4295>, <-1.0571, 80.03605, -0.5827> }
					triangle { <-1.0571, 80.03605, -0.5827>, <-1.05248, 81.4312, -0.4295>, <-1.04331, 80.01501, -0.8018> }
					triangle { <-1.04885, 79.06116, -0.708>, <-1.0571, 80.03605, -0.5827>, <-1.04331, 80.01501, -0.8018> }
					triangle { <-1.04885, 79.06116, -0.708>, <-1.04331, 80.01501, -0.8018>, <-1.05477, 79.03768, -0.9007> }
					triangle { <-1.04885, 79.06116, -0.708>, <-1.05477, 79.03768, -0.9007>, <-1.2537, 77.2755, -0.8812> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.2229, 76.9433, -0.8978>, <-1.355, 77.4497, -0.9383>, 0.07351 }
			cylinder { <-1.355, 77.4497, -0.9383>, <-1.5011, 77.9512, -0.9894>, 0.07351 }
			cylinder { <-1.5011, 77.9512, -0.9894>, <-1.6611, 78.4473, -1.05093>, 0.07351 }
			cylinder { <-1.6611, 78.4473, -1.05093>, <-1.8347, 78.9373, -1.1228>, 0.07351 }
			cylinder { <-1.8347, 78.9373, -1.1228>, <-2.02189, 79.4208, -1.205>, 0.07351 }
			cylinder { <-2.02189, 79.4208, -1.205>, <-2.2222, 79.897, -1.2975>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.2222, 79.897, -1.2975>, <-2.2438, 79.947, -1.31>, 0.07351 }
				cylinder { <-2.2438, 79.947, -1.31>, <-2.2656, 79.9962, -1.3251>, 0.07351 }
				cylinder { <-2.2656, 79.9962, -1.3251>, <-2.2875, 80.04449, -1.3428>, 0.07351 }
				cylinder { <-2.2875, 80.04449, -1.3428>, <-2.3095, 80.09171, -1.363>, 0.07351 }
				cylinder { <-2.3095, 80.09171, -1.363>, <-2.3315, 80.1377, -1.3857>, 0.07351 }
				cylinder { <-2.3315, 80.1377, -1.3857>, <-2.3535, 80.1825, -1.4108>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.3535, 80.1825, -1.4108>, <-3.1416, 81.1727, -2.3817>, <-3.2361, 81.2563, -2.2552> }
					triangle { <-3.1416, 81.1727, -2.3817>, <-3.5329, 81.8296, -2.8284>, <-3.2361, 81.2563, -2.2552> }
					triangle { <-3.5329, 81.8296, -2.8284>, <-3.64, 81.9164, -2.6854>, <-3.2361, 81.2563, -2.2552> }
					triangle { <-3.5329, 81.8296, -2.8284>, <-4.2411, 82.8501, -3.2898>, <-3.64, 81.9164, -2.6854> }
					triangle { <-3.64, 81.9164, -2.6854>, <-4.2411, 82.8501, -3.2898>, <-3.7597, 81.8854, -2.5299> }
					triangle { <-3.2361, 81.2563, -2.2552>, <-3.64, 81.9164, -2.6854>, <-3.7597, 81.8854, -2.5299> }
					triangle { <-3.2361, 81.2563, -2.2552>, <-3.7597, 81.8854, -2.5299>, <-3.3298, 81.2367, -2.1088> }
					triangle { <-3.2361, 81.2563, -2.2552>, <-3.3298, 81.2367, -2.1088>, <-2.3535, 80.1825, -1.4108> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.1287, 3.7035, 0.2409>, 0.05734 }
			cylinder { <0.1287, 3.7035, 0.2409>, <0.3856, 7.3769, 0.7214>, 0.05734 }
			cylinder { <0.3856, 7.3769, 0.7214>, <0.7692, 11.00035, 1.439>, 0.05734 }
			cylinder { <0.7692, 11.00035, 1.439>, <1.2773, 14.554, 2.3897>, 0.05734 }
			cylinder { <1.2773, 14.554, 2.3897>, <1.9073, 18.01883, 3.5684>, 0.05734 }
			cylinder { <1.9073, 18.01883, 3.5684>, <2.6558, 21.3758, 4.9687>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <2.6558, 21.3758, 4.9687>, <2.8812, 22.3867, 5.3904>, 0.05734 }
				cylinder { <2.8812, 22.3867, 5.3904>, <3.1065, 23.3975, 5.812>, 0.05734 }
				cylinder { <3.1065, 23.3975, 5.812>, <3.3319, 24.4083, 6.2336>, 0.05734 }
				cylinder { <3.3319, 24.4083, 6.2336>, <3.5573, 25.4191, 6.6552>, 0.05734 }
				cylinder { <3.5573, 25.4191, 6.6552>, <3.7826, 26.4299, 7.07691>, 0.05734 }
				cylinder { <3.7826, 26.4299, 7.07691>, <4.008054, 27.4407, 7.4985>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.008054, 27.4407, 7.4985>, <4.03118, 27.5081, 7.5223>, 0.001159 }
				cylinder { <4.03118, 27.5081, 7.5223>, <4.06195, 27.5739, 7.5411>, 0.001159 }
				cylinder { <4.06195, 27.5739, 7.5411>, <4.09991, 27.6373, 7.5548>, 0.001159 }
				cylinder { <4.09991, 27.6373, 7.5548>, <4.1444, 27.6971, 7.5631>, 0.001159 }
				cylinder { <4.1444, 27.6971, 7.5631>, <4.1949, 27.7527, 7.5659>, 0.001159 }
				cylinder { <4.1949, 27.7527, 7.5659>, <4.2506, 27.8029, 7.5631>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.2506, 27.8029, 7.5631>, <5.338, 28.1593, 7.4108>, <5.3209, 28.2404, 7.3965> }
				triangle { <5.338, 28.1593, 7.4108>, <5.9543, 28.34, 7.2215>, <5.3209, 28.2404, 7.3965> }
				triangle { <5.9543, 28.34, 7.2215>, <5.9181, 28.4197, 7.1887>, <5.3209, 28.2404, 7.3965> }
				triangle { <5.9543, 28.34, 7.2215>, <7.7835, 28.7916, 6.3113>, <5.9181, 28.4197, 7.1887> }
				triangle { <5.9181, 28.4197, 7.1887>, <7.7835, 28.7916, 6.3113>, <5.8678, 28.4939, 7.1581> }
				triangle { <5.3209, 28.2404, 7.3965>, <5.9181, 28.4197, 7.1887>, <5.8678, 28.4939, 7.1581> }
				triangle { <5.3209, 28.2404, 7.3965>, <5.8678, 28.4939, 7.1581>, <5.2765, 28.3027, 7.3735> }
				triangle { <5.3209, 28.2404, 7.3965>, <5.2765, 28.3027, 7.3735>, <4.2506, 27.8029, 7.5631> }
				triangle { <8.6989, 28.9826, 5.7243>, <7.7835, 28.7916, 6.3113>, <7.8343, 28.6642, 6.3201> }
				triangle { <5.8678, 28.4939, 7.1581>, <7.7835, 28.7916, 6.3113>, <7.721, 28.9073, 6.2007> }
				triangle { <5.9543, 28.34, 7.2215>, <7.8343, 28.6642, 6.3201>, <7.7835, 28.7916, 6.3113> }
				triangle { <8.6989, 28.9826, 5.7243>, <7.721, 28.9073, 6.2007>, <7.7835, 28.7916, 6.3113> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.008054, 27.4407, 7.4985>, <4.1973, 28.4627, 7.9109>, 0.05734 }
				cylinder { <4.1973, 28.4627, 7.9109>, <4.3504, 29.4945, 8.3136>, 0.05734 }
				cylinder { <4.3504, 29.4945, 8.3136>, <4.4671, 30.535, 8.7062>, 0.05734 }
				cylinder { <4.4671, 30.535, 8.7062>, <4.5472, 31.5829, 9.08804>, 0.05734 }
				cylinder { <4.5472, 31.5829, 9.08804>, <4.5907, 32.6369, 9.4587>, 0.05734 }
				cylinder { <4.5907, 32.6369, 9.4587>, <4.5974, 33.6959, 9.8177>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.5974, 33.6959, 9.8177>, <4.5863, 33.7642, 9.8469>, 0.001159 }
				cylinder { <4.5863, 33.7642, 9.8469>, <4.564, 33.8277, 9.8802>, 0.001159 }
				cylinder { <4.564, 33.8277, 9.8802>, <4.5312, 33.8845, 9.9166>, 0.001159 }
				cylinder { <4.5312, 33.8845, 9.9166>, <4.4887, 33.933, 9.9552>, 0.001159 }
				cylinder { <4.4887, 33.933, 9.9552>, <4.438, 33.9717, 9.9947>, 0.001159 }
				cylinder { <4.438, 33.9717, 9.9947>, <4.3804, 33.9995, 10.03411>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.3804, 33.9995, 10.03411>, <3.8625, 34.7204, 10.7721>, <3.7835, 34.7079, 10.7459> }
				triangle { <3.8625, 34.7204, 10.7721>, <3.5798, 35.2124, 11.1275>, <3.7835, 34.7079, 10.7459> }
				triangle { <3.5798, 35.2124, 11.1275>, <3.5031, 35.203, 11.07493>, <3.7835, 34.7079, 10.7459> }
				triangle { <3.5798, 35.2124, 11.1275>, <2.7904, 36.9577, 11.9698>, <3.5031, 35.203, 11.07493> }
				triangle { <3.5031, 35.203, 11.07493>, <2.7904, 36.9577, 11.9698>, <3.434, 35.1841, 11.01294> }
				triangle { <3.7835, 34.7079, 10.7459>, <3.5031, 35.203, 11.07493>, <3.434, 35.1841, 11.01294> }
				triangle { <3.7835, 34.7079, 10.7459>, <3.434, 35.1841, 11.01294>, <3.7262, 34.6885, 10.6938> }
				triangle { <3.7835, 34.7079, 10.7459>, <3.7262, 34.6885, 10.6938>, <4.3804, 33.9995, 10.03411> }
				triangle { <2.4169, 37.9389, 12.3113>, <2.7904, 36.9577, 11.9698>, <2.9097, 37.00255, 12.0213> }
				triangle { <3.434, 35.1841, 11.01294>, <2.7904, 36.9577, 11.9698>, <2.6742, 36.9867, 11.8466> }
				triangle { <3.5798, 35.2124, 11.1275>, <2.9097, 37.00255, 12.0213>, <2.7904, 36.9577, 11.9698> }
				triangle { <2.4169, 37.9389, 12.3113>, <2.6742, 36.9867, 11.8466>, <2.7904, 36.9577, 11.9698> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.5974, 33.6959, 9.8177>, <4.6894, 34.7342, 10.2224>, 0.05734 }
				cylinder { <4.6894, 34.7342, 10.2224>, <4.8659, 35.7437, 10.6696>, 0.05734 }
				cylinder { <4.8659, 35.7437, 10.6696>, <5.1255, 36.7165, 11.1561>, 0.05734 }
				cylinder { <5.1255, 36.7165, 11.1561>, <5.4659, 37.6448, 11.6781>, 0.05734 }
				cylinder { <5.4659, 37.6448, 11.6781>, <5.8844, 38.5215, 12.2318>, 0.05734 }
				cylinder { <5.8844, 38.5215, 12.2318>, <6.3778, 39.3396, 12.8129>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <6.3778, 39.3396, 12.8129>, <6.4225, 39.3917, 12.8433>, 0.001159 }
				cylinder { <6.4225, 39.3917, 12.8433>, <6.4771, 39.4389, 12.8639>, 0.001159 }
				cylinder { <6.4771, 39.4389, 12.8639>, <6.5395, 39.4795, 12.874>, 0.001159 }
				cylinder { <6.5395, 39.4795, 12.874>, <6.6072, 39.5119, 12.8731>, 0.001159 }
				cylinder { <6.6072, 39.5119, 12.8731>, <6.6778, 39.5347, 12.8613>, 0.001159 }
				cylinder { <6.6778, 39.5347, 12.8613>, <6.7484, 39.5473, 12.839>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <6.7484, 39.5473, 12.839>, <7.76, 39.2785, 12.3522>, <7.7865, 39.3571, 12.3381> }
				triangle { <7.76, 39.2785, 12.3522>, <8.2929, 39.1192, 11.9796>, <7.7865, 39.3571, 12.3381> }
				triangle { <8.2929, 39.1192, 11.9796>, <8.2983, 39.2088, 11.9534>, <7.7865, 39.3571, 12.3381> }
				triangle { <8.2929, 39.1192, 11.9796>, <9.7311, 38.6121, 10.5466>, <8.2983, 39.2088, 11.9534> }
				triangle { <8.2983, 39.2088, 11.9534>, <9.7311, 38.6121, 10.5466>, <8.2902, 39.3012, 11.934> }
				triangle { <7.7865, 39.3571, 12.3381>, <8.2983, 39.2088, 11.9534>, <8.2902, 39.3012, 11.934> }
				triangle { <7.7865, 39.3571, 12.3381>, <8.2902, 39.3012, 11.934>, <7.7786, 39.4355, 12.3251> }
				triangle { <7.7865, 39.3571, 12.3381>, <7.7786, 39.4355, 12.3251>, <6.7484, 39.5473, 12.839> }
				triangle { <10.3949, 38.343, 9.7064>, <9.7311, 38.6121, 10.5466>, <9.7046, 38.4773, 10.5487> }
				triangle { <8.2902, 39.3012, 11.934>, <9.7311, 38.6121, 10.5466>, <9.7133, 38.7543, 10.4517> }
				triangle { <8.2929, 39.1192, 11.9796>, <9.7046, 38.4773, 10.5487>, <9.7311, 38.6121, 10.5466> }
				triangle { <10.3949, 38.343, 9.7064>, <9.7133, 38.7543, 10.4517>, <9.7311, 38.6121, 10.5466> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <6.3778, 39.3396, 12.8129>, <6.8481, 40.1608, 13.4086>, 0.05734 }
				cylinder { <6.8481, 40.1608, 13.4086>, <7.295, 40.9846, 14.01845>, 0.05734 }
				cylinder { <7.295, 40.9846, 14.01845>, <7.7183, 41.8105, 14.6421>, 0.05734 }
				cylinder { <7.7183, 41.8105, 14.6421>, <8.1178, 42.638, 15.2792>, 0.05734 }
				cylinder { <8.1178, 42.638, 15.2792>, <8.4931, 43.4666, 15.9294>, 0.05734 }
				cylinder { <8.4931, 43.4666, 15.9294>, <8.8441, 44.2959, 16.5923>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <8.8441, 44.2959, 16.5923>, <8.8576, 44.3512, 16.6413>, 0.001159 }
				cylinder { <8.8576, 44.3512, 16.6413>, <8.8608, 44.4048, 16.6938>, 0.001159 }
				cylinder { <8.8608, 44.4048, 16.6938>, <8.8535, 44.4555, 16.7487>, 0.001159 }
				cylinder { <8.8535, 44.4555, 16.7487>, <8.8359, 44.5024, 16.8046>, 0.001159 }
				cylinder { <8.8359, 44.5024, 16.8046>, <8.8085, 44.5444, 16.8605>, 0.001159 }
				cylinder { <8.8085, 44.5444, 16.8605>, <8.7717, 44.5805, 16.9152>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <8.7717, 44.5805, 16.9152>, <8.6744, 45.2065, 17.8801>, <8.5962, 45.2347, 17.867> }
				triangle { <8.6744, 45.2065, 17.8801>, <8.6608, 45.6476, 18.3837>, <8.5962, 45.2347, 17.867> }
				triangle { <8.6608, 45.6476, 18.3837>, <8.5841, 45.685, 18.3456>, <8.5962, 45.2347, 17.867> }
				triangle { <8.6608, 45.6476, 18.3837>, <8.7737, 47.2453, 19.7302>, <8.5841, 45.685, 18.3456> }
				triangle { <8.5841, 45.685, 18.3456>, <8.7737, 47.2453, 19.7302>, <8.5094, 45.7137, 18.2949> }
				triangle { <8.5962, 45.2347, 17.867>, <8.5841, 45.685, 18.3456>, <8.5094, 45.7137, 18.2949> }
				triangle { <8.5962, 45.2347, 17.867>, <8.5094, 45.7137, 18.2949>, <8.5326, 45.2556, 17.8235> }
				triangle { <8.5962, 45.2347, 17.867>, <8.5326, 45.2556, 17.8235>, <8.7717, 44.5805, 16.9152> }
				triangle { <8.8907, 48.1529, 20.3479>, <8.7737, 47.2453, 19.7302>, <8.904, 47.222, 19.7673> }
				triangle { <8.5094, 45.7137, 18.2949>, <8.7737, 47.2453, 19.7302>, <8.6732, 47.352, 19.6406> }
				triangle { <8.6608, 45.6476, 18.3837>, <8.904, 47.222, 19.7673>, <8.7737, 47.2453, 19.7302> }
				triangle { <8.8907, 48.1529, 20.3479>, <8.6732, 47.352, 19.6406>, <8.7737, 47.2453, 19.7302> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <8.8441, 44.2959, 16.5923>, <9.2041, 45.1065, 17.2732>, 0.05734 }
				cylinder { <9.2041, 45.1065, 17.2732>, <9.5727, 45.898, 17.9717>, 0.05734 }
				cylinder { <9.5727, 45.898, 17.9717>, <9.9498, 46.6699, 18.6875>, 0.05734 }
				cylinder { <9.9498, 46.6699, 18.6875>, <10.3352, 47.4217, 19.42>, 0.05734 }
				cylinder { <10.3352, 47.4217, 19.42>, <10.7286, 48.1529, 20.1689>, 0.05734 }
				cylinder { <10.7286, 48.1529, 20.1689>, <11.1299, 48.8632, 20.9336>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <11.1299, 48.8632, 20.9336>, <11.1663, 48.9102, 20.9794>, 0.001159 }
				cylinder { <11.1663, 48.9102, 20.9794>, <11.2115, 48.9556, 21.0187>, 0.001159 }
				cylinder { <11.2115, 48.9556, 21.0187>, <11.2645, 48.9982, 21.05054>, 0.001159 }
				cylinder { <11.2645, 48.9982, 21.05054>, <11.324, 49.03738, 21.07428>, 0.001159 }
				cylinder { <11.324, 49.03738, 21.07428>, <11.3889, 49.07204, 21.08941>, 0.001159 }
				cylinder { <11.3889, 49.07204, 21.08941>, <11.4577, 49.1015, 21.0956>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <11.4577, 49.1015, 21.0956>, <12.5994, 49.1482, 20.9318>, <12.609, 49.2307, 20.9453> }
				triangle { <12.5994, 49.1482, 20.9318>, <13.2382, 49.1895, 20.7354>, <12.609, 49.2307, 20.9453> }
				triangle { <13.2382, 49.1895, 20.7354>, <13.2289, 49.2825, 20.7332>, <12.609, 49.2307, 20.9453> }
				triangle { <13.2382, 49.1895, 20.7354>, <15.1015, 49.3508, 19.797>, <13.2289, 49.2825, 20.7332> }
				triangle { <13.2289, 49.2825, 20.7332>, <15.1015, 49.3508, 19.797>, <13.2044, 49.374, 20.7331> }
				triangle { <12.609, 49.2307, 20.9453>, <13.2289, 49.2825, 20.7332>, <13.2044, 49.374, 20.7331> }
				triangle { <12.609, 49.2307, 20.9453>, <13.2044, 49.374, 20.7331>, <12.5864, 49.3072, 20.9481> }
				triangle { <12.609, 49.2307, 20.9453>, <12.5864, 49.3072, 20.9481>, <11.4577, 49.1015, 21.0956> }
				triangle { <16.0208, 49.4435, 19.1926>, <15.1015, 49.3508, 19.797>, <15.1091, 49.2186, 19.7601> }
				triangle { <13.2044, 49.374, 20.7331>, <15.1015, 49.3508, 19.797>, <15.07759, 49.5095, 19.7357> }
				triangle { <13.2382, 49.1895, 20.7354>, <15.1091, 49.2186, 19.7601>, <15.1015, 49.3508, 19.797> }
				triangle { <16.0208, 49.4435, 19.1926>, <15.07759, 49.5095, 19.7357>, <15.1015, 49.3508, 19.797> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <11.1299, 48.8632, 20.9336>, <11.5311, 49.5734, 21.6984>, 0.05734 }
				cylinder { <11.5311, 49.5734, 21.6984>, <11.9323, 50.2837, 22.4631>, 0.05734 }
				cylinder { <11.9323, 50.2837, 22.4631>, <12.3335, 50.994, 23.2279>, 0.05734 }
				cylinder { <12.3335, 50.994, 23.2279>, <12.7347, 51.7042, 23.9927>, 0.05734 }
				cylinder { <12.7347, 51.7042, 23.9927>, <13.1359, 52.4145, 24.7574>, 0.05734 }
				cylinder { <13.1359, 52.4145, 24.7574>, <13.5371, 53.1248, 25.5222>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <13.5371, 53.1248, 25.5222>, <13.5539, 53.1721, 25.578>, 0.001159 }
				cylinder { <13.5539, 53.1721, 25.578>, <13.5603, 53.2181, 25.637>, 0.001159 }
				cylinder { <13.5603, 53.2181, 25.637>, <13.5561, 53.2616, 25.6981>, 0.001159 }
				cylinder { <13.5561, 53.2616, 25.6981>, <13.5413, 53.3018, 25.7597>, 0.001159 }
				cylinder { <13.5413, 53.3018, 25.7597>, <13.5164, 53.3379, 25.8207>, 0.001159 }
				cylinder { <13.5164, 53.3379, 25.8207>, <13.4818, 53.3689, 25.8797>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <13.4818, 53.3689, 25.8797>, <13.4202, 53.8686, 26.9185>, <13.3441, 53.9035, 26.9093> }
				triangle { <13.4202, 53.8686, 26.9185>, <13.4328, 54.2401, 27.4754>, <13.3441, 53.9035, 26.9093> }
				triangle { <13.4328, 54.2401, 27.4754>, <13.3589, 54.2872, 27.4427>, <13.3441, 53.9035, 26.9093> }
				triangle { <13.4328, 54.2401, 27.4754>, <13.6431, 55.6371, 29.01903>, <13.3589, 54.2872, 27.4427> }
				triangle { <13.3589, 54.2872, 27.4427>, <13.6431, 55.6371, 29.01903>, <13.2866, 54.3272, 27.3964> }
				triangle { <13.3441, 53.9035, 26.9093>, <13.3589, 54.2872, 27.4427>, <13.2866, 54.3272, 27.3964> }
				triangle { <13.3441, 53.9035, 26.9093>, <13.2866, 54.3272, 27.3964>, <13.2823, 53.934, 26.869> }
				triangle { <13.3441, 53.9035, 26.9093>, <13.2823, 53.934, 26.869>, <13.4818, 53.3689, 25.8797> }
				triangle { <13.8164, 56.4464, 29.7497>, <13.6431, 55.6371, 29.01903>, <13.7714, 55.6005, 29.05242> }
				triangle { <13.2866, 54.3272, 27.3964>, <13.6431, 55.6371, 29.01903>, <13.5506, 55.7611, 28.9443> }
				triangle { <13.4328, 54.2401, 27.4754>, <13.7714, 55.6005, 29.05242>, <13.6431, 55.6371, 29.01903> }
				triangle { <13.8164, 56.4464, 29.7497>, <13.5506, 55.7611, 28.9443>, <13.6431, 55.6371, 29.01903> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <13.5371, 53.1248, 25.5222>, <13.9702, 53.8131, 26.2897>, 0.05734 }
				cylinder { <13.9702, 53.8131, 26.2897>, <14.4346, 54.4785, 27.059>, 0.05734 }
				cylinder { <14.4346, 54.4785, 27.059>, <14.9297, 55.1203, 27.8291>, 0.05734 }
				cylinder { <14.9297, 55.1203, 27.8291>, <15.4551, 55.7377, 28.5993>, 0.05734 }
				cylinder { <15.4551, 55.7377, 28.5993>, <16.00996, 56.3299, 29.3685>, 0.05734 }
				cylinder { <16.00996, 56.3299, 29.3685>, <16.5936, 56.8963, 30.1359>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <16.5936, 56.8963, 30.1359>, <16.6415, 56.9328, 30.1807>, 0.001159 }
				cylinder { <16.6415, 56.9328, 30.1807>, <16.697, 56.9671, 30.2179>, 0.001159 }
				cylinder { <16.697, 56.9671, 30.2179>, <16.759, 56.9982, 30.2467>, 0.001159 }
				cylinder { <16.759, 56.9982, 30.2467>, <16.826, 57.02576, 30.2664>, 0.001159 }
				cylinder { <16.826, 57.02576, 30.2664>, <16.8967, 57.04893, 30.2766>, 0.001159 }
				cylinder { <16.8967, 57.04893, 30.2766>, <16.9695, 57.06729, 30.2771>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <16.9695, 57.06729, 30.2771>, <18.08162, 56.9622, 29.9857>, <18.1052, 57.04081, 30.00462> }
				triangle { <18.08162, 56.9622, 29.9857>, <18.6953, 56.9286, 29.7201>, <18.1052, 57.04081, 30.00462> }
				triangle { <18.6953, 56.9286, 29.7201>, <18.7004, 57.0218, 29.7265>, <18.1052, 57.04081, 30.00462> }
				triangle { <18.6953, 56.9286, 29.7201>, <20.4543, 56.9061, 28.587>, <18.7004, 57.0218, 29.7265> }
				triangle { <18.7004, 57.0218, 29.7265>, <20.4543, 56.9061, 28.587>, <18.6907, 57.1154, 29.7366> }
				triangle { <18.1052, 57.04081, 30.00462>, <18.7004, 57.0218, 29.7265>, <18.6907, 57.1154, 29.7366> }
				triangle { <18.1052, 57.04081, 30.00462>, <18.6907, 57.1154, 29.7366>, <18.09528, 57.1192, 30.01616> }
				triangle { <18.1052, 57.04081, 30.00462>, <18.09528, 57.1192, 30.01616>, <16.9695, 57.06729, 30.2771> }
				triangle { <21.3095, 56.9217, 27.889>, <20.4543, 56.9061, 28.587>, <20.4373, 56.7785, 28.539> }
				triangle { <18.6907, 57.1154, 29.7366>, <20.4543, 56.9061, 28.587>, <20.4492, 57.07189, 28.5418> }
				triangle { <18.6953, 56.9286, 29.7201>, <20.4373, 56.7785, 28.539>, <20.4543, 56.9061, 28.587> }
				triangle { <21.3095, 56.9217, 27.889>, <20.4492, 57.07189, 28.5418>, <20.4543, 56.9061, 28.587> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <16.5936, 56.8963, 30.1359>, <17.1773, 57.4626, 30.9032>, 0.05734 }
				cylinder { <17.1773, 57.4626, 30.9032>, <17.7611, 58.02905, 31.6706>, 0.05734 }
				cylinder { <17.7611, 58.02905, 31.6706>, <18.3448, 58.5954, 32.4379>, 0.05734 }
				cylinder { <18.3448, 58.5954, 32.4379>, <18.9285, 59.1617, 33.2053>, 0.05734 }
				cylinder { <18.9285, 59.1617, 33.2053>, <19.5122, 59.7281, 33.9726>, 0.05734 }
				cylinder { <19.5122, 59.7281, 33.9726>, <20.09595, 60.2944, 34.74>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <20.09595, 60.2944, 34.74>, <20.1272, 60.3331, 34.7962>, 0.001159 }
				cylinder { <20.1272, 60.3331, 34.7962>, <20.1502, 60.3718, 34.8563>, 0.001159 }
				cylinder { <20.1502, 60.3718, 34.8563>, <20.1644, 60.41, 34.9194>, 0.001159 }
				cylinder { <20.1644, 60.41, 34.9194>, <20.1698, 60.447, 34.9845>, 0.001159 }
				cylinder { <20.1698, 60.447, 34.9845>, <20.1661, 60.4824, 35.05067>, 0.001159 }
				cylinder { <20.1661, 60.4824, 35.05067>, <20.1535, 60.5156, 35.1168>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <20.1535, 60.5156, 35.1168>, <20.4398, 60.9346, 36.1536>, <20.3737, 60.9859, 36.1632> }
				triangle { <20.4398, 60.9346, 36.1536>, <20.6604, 61.25, 36.7015>, <20.3737, 60.9859, 36.1632> }
				triangle { <20.6604, 61.25, 36.7015>, <20.5941, 61.3145, 36.688>, <20.3737, 60.9859, 36.1632> }
				triangle { <20.6604, 61.25, 36.7015>, <21.5229, 62.4433, 38.1884>, <20.5941, 61.3145, 36.688> }
				triangle { <20.5941, 61.3145, 36.688>, <21.5229, 62.4433, 38.1884>, <20.5246, 61.3729, 36.6608> }
				triangle { <20.3737, 60.9859, 36.1632>, <20.5941, 61.3145, 36.688>, <20.5246, 61.3729, 36.6608> }
				triangle { <20.3737, 60.9859, 36.1632>, <20.5246, 61.3729, 36.6608>, <20.3133, 61.03228, 36.1393> }
				triangle { <20.3737, 60.9859, 36.1632>, <20.3133, 61.03228, 36.1393>, <20.1535, 60.5156, 35.1168> }
				triangle { <22.03515, 63.136, 38.8788>, <21.5229, 62.4433, 38.1884>, <21.6433, 62.3771, 38.1901> }
				triangle { <20.5246, 61.3729, 36.6608>, <21.5229, 62.4433, 38.1884>, <21.4473, 62.59, 38.1404> }
				triangle { <20.6604, 61.25, 36.7015>, <21.6433, 62.3771, 38.1901>, <21.5229, 62.4433, 38.1884> }
				triangle { <22.03515, 63.136, 38.8788>, <21.4473, 62.59, 38.1404>, <21.5229, 62.4433, 38.1884> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <20.09595, 60.2944, 34.74>, <20.1304, 60.3329, 34.7944>, 0.001159 }
				cylinder { <20.1304, 60.3329, 34.7944>, <20.1601, 60.3716, 34.8515>, 0.001159 }
				cylinder { <20.1601, 60.3716, 34.8515>, <20.1848, 60.4104, 34.9109>, 0.001159 }
				cylinder { <20.1848, 60.4104, 34.9109>, <20.2043, 60.4489, 34.9723>, 0.001159 }
				cylinder { <20.2043, 60.4489, 34.9723>, <20.2185, 60.4871, 35.03546>, 0.001159 }
				cylinder { <20.2185, 60.4871, 35.03546>, <20.2275, 60.5247, 35.09986>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <20.2275, 60.5247, 35.09986>, <20.8182, 60.9436, 35.9987>, <20.7638, 61.00427, 36.02018> }
				triangle { <20.8182, 60.9436, 35.9987>, <21.2088, 61.2479, 36.4494>, <20.7638, 61.00427, 36.02018> }
				triangle { <21.2088, 61.2479, 36.4494>, <21.1501, 61.3206, 36.4475>, <20.7638, 61.00427, 36.02018> }
				triangle { <21.2088, 61.2479, 36.4494>, <22.5655, 62.369, 37.5813>, <21.1501, 61.3206, 36.4475> }
				triangle { <21.1501, 61.3206, 36.4475>, <22.5655, 62.369, 37.5813>, <21.08418, 61.3872, 36.4336> }
				triangle { <20.7638, 61.00427, 36.02018>, <21.1501, 61.3206, 36.4475>, <21.08418, 61.3872, 36.4336> }
				triangle { <20.7638, 61.00427, 36.02018>, <21.08418, 61.3872, 36.4336>, <20.7058, 61.05778, 36.00817> }
				triangle { <20.7638, 61.00427, 36.02018>, <20.7058, 61.05778, 36.00817>, <20.2275, 60.5247, 35.09986> }
				triangle { <23.3204, 63.01056, 38.0687>, <22.5655, 62.369, 37.5813>, <22.6729, 62.2863, 37.5587> }
				triangle { <21.08418, 61.3872, 36.4336>, <22.5655, 62.369, 37.5813>, <22.4997, 62.5228, 37.5418> }
				triangle { <21.2088, 61.2479, 36.4494>, <22.6729, 62.2863, 37.5587>, <22.5655, 62.369, 37.5813> }
				triangle { <23.3204, 63.01056, 38.0687>, <22.4997, 62.5228, 37.5418>, <22.5655, 62.369, 37.5813> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.04296, 3.7124, 0.08037>, 0.05734 }
			cylinder { <0.04296, 3.7124, 0.08037>, <0.1288, 7.4216, 0.241>, 0.05734 }
			cylinder { <0.1288, 7.4216, 0.241>, <0.2576, 11.1251, 0.482>, 0.05734 }
			cylinder { <0.2576, 11.1251, 0.482>, <0.4292, 14.8209, 0.803>, 0.05734 }
			cylinder { <0.4292, 14.8209, 0.803>, <0.6435, 18.5066, 1.2039>, 0.05734 }
			cylinder { <0.6435, 18.5066, 1.2039>, <0.9003, 22.18, 1.6844>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.9003, 22.18, 1.6844>, <0.8908, 23.2938, 1.7826>, 0.05734 }
				cylinder { <0.8908, 23.2938, 1.7826>, <0.7944, 24.4066, 1.8333>, 0.05734 }
				cylinder { <0.7944, 24.4066, 1.8333>, <0.6122, 25.5099, 1.836>, 0.05734 }
				cylinder { <0.6122, 25.5099, 1.836>, <0.3455, 26.5948, 1.7905>, 0.05734 }
				cylinder { <0.3455, 26.5948, 1.7905>, <-0.003296, 27.653, 1.6971>, 0.05734 }
				cylinder { <-0.003296, 27.653, 1.6971>, <-0.4315, 28.6763, 1.5562>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.4315, 28.6763, 1.5562>, <-0.4721, 28.7394, 1.5537>, 0.001159 }
				cylinder { <-0.4721, 28.7394, 1.5537>, <-0.5227, 28.7947, 1.5582>, 0.001159 }
				cylinder { <-0.5227, 28.7947, 1.5582>, <-0.5817, 28.8398, 1.5695>, 0.001159 }
				cylinder { <-0.5817, 28.8398, 1.5695>, <-0.6466, 28.8731, 1.5873>, 0.001159 }
				cylinder { <-0.6466, 28.8731, 1.5873>, <-0.715, 28.8933, 1.6109>, 0.001159 }
				cylinder { <-0.715, 28.8933, 1.6109>, <-0.7842, 28.8996, 1.6392>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.7842, 28.8996, 1.6392>, <-1.6385, 29.3616, 2.2632>, <-1.5905, 29.3968, 2.3229> }
				triangle { <-1.6385, 29.3616, 2.2632>, <-2.1365, 29.537, 2.6749>, <-1.5905, 29.3968, 2.3229> }
				triangle { <-2.1365, 29.537, 2.6749>, <-2.07285, 29.5519, 2.7416>, <-1.5905, 29.3968, 2.3229> }
				triangle { <-2.1365, 29.537, 2.6749>, <-3.6676, 29.7562, 4.08433>, <-2.07285, 29.5519, 2.7416> }
				triangle { <-2.07285, 29.5519, 2.7416>, <-3.6676, 29.7562, 4.08433>, <-1.9983, 29.5604, 2.7995> }
				triangle { <-1.5905, 29.3968, 2.3229>, <-2.07285, 29.5519, 2.7416>, <-1.9983, 29.5604, 2.7995> }
				triangle { <-1.5905, 29.3968, 2.3229>, <-1.9983, 29.5604, 2.7995>, <-1.5258, 29.4052, 2.3689> }
				triangle { <-1.5905, 29.3968, 2.3229>, <-1.5258, 29.4052, 2.3689>, <-0.7842, 28.8996, 1.6392> }
				triangle { <-4.4548, 29.7504, 4.8584>, <-3.6676, 29.7562, 4.08433>, <-3.7654, 29.699, 4.006457> }
				triangle { <-1.9983, 29.5604, 2.7995>, <-3.6676, 29.7562, 4.08433>, <-3.5692, 29.7298, 4.2226> }
				triangle { <-2.1365, 29.537, 2.6749>, <-3.7654, 29.699, 4.006457>, <-3.6676, 29.7562, 4.08433> }
				triangle { <-4.4548, 29.7504, 4.8584>, <-3.5692, 29.7298, 4.2226>, <-3.6676, 29.7562, 4.08433> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.4315, 28.6763, 1.5562>, <-0.8932, 29.6832, 1.4039>, 0.05734 }
				cylinder { <-0.8932, 29.6832, 1.4039>, <-1.3876, 30.6727, 1.2405>, 0.05734 }
				cylinder { <-1.3876, 30.6727, 1.2405>, <-1.9143, 31.6436, 1.06607>, 0.05734 }
				cylinder { <-1.9143, 31.6436, 1.06607>, <-2.4725, 32.5946, 0.8808>, 0.05734 }
				cylinder { <-2.4725, 32.5946, 0.8808>, <-3.0616, 33.5246, 0.6849>, 0.05734 }
				cylinder { <-3.0616, 33.5246, 0.6849>, <-3.6808, 34.4325, 0.4787>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.6808, 34.4325, 0.4787>, <-3.7165, 34.4962, 0.4613>, 0.001159 }
				cylinder { <-3.7165, 34.4962, 0.4613>, <-3.746, 34.5621, 0.4407>, 0.001159 }
				cylinder { <-3.746, 34.5621, 0.4407>, <-3.769, 34.6296, 0.4169>, 0.001159 }
				cylinder { <-3.769, 34.6296, 0.4169>, <-3.7853, 34.6979, 0.3903>, 0.001159 }
				cylinder { <-3.7853, 34.6979, 0.3903>, <-3.7947, 34.7664, 0.361>, 0.001159 }
				cylinder { <-3.7947, 34.7664, 0.361>, <-3.7971, 34.8344, 0.3293>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.7971, 34.8344, 0.3293>, <-3.4495, 35.9099, 0.09487>, <-3.4097, 35.9246, 0.1675> }
				triangle { <-3.4495, 35.9099, 0.09487>, <-3.3409, 36.5635, -0.001868>, <-3.4097, 35.9246, 0.1675> }
				triangle { <-3.3409, 36.5635, -0.001868>, <-3.3193, 36.5708, 0.08879>, <-3.4097, 35.9246, 0.1675> }
				triangle { <-3.3409, 36.5635, -0.001868>, <-3.3262, 38.6487, -0.1759>, <-3.3193, 36.5708, 0.08879> }
				triangle { <-3.3193, 36.5708, 0.08879>, <-3.3262, 38.6487, -0.1759>, <-3.3026, 36.5637, 0.1817> }
				triangle { <-3.4097, 35.9246, 0.1675>, <-3.3193, 36.5708, 0.08879>, <-3.3026, 36.5637, 0.1817> }
				triangle { <-3.4097, 35.9246, 0.1675>, <-3.3026, 36.5637, 0.1817>, <-3.3942, 35.9154, 0.2453> }
				triangle { <-3.4097, 35.9246, 0.1675>, <-3.3942, 35.9154, 0.2453>, <-3.7971, 34.8344, 0.3293> }
				triangle { <-3.4368, 39.7462, -0.2223>, <-3.3262, 38.6487, -0.1759>, <-3.3936, 38.6523, -0.2956> }
				triangle { <-3.3026, 36.5637, 0.1817>, <-3.3262, 38.6487, -0.1759>, <-3.3423, 38.6813, -0.008025> }
				triangle { <-3.3409, 36.5635, -0.001868>, <-3.3936, 38.6523, -0.2956>, <-3.3262, 38.6487, -0.1759> }
				triangle { <-3.4368, 39.7462, -0.2223>, <-3.3423, 38.6813, -0.008025>, <-3.3262, 38.6487, -0.1759> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.6808, 34.4325, 0.4787>, <-4.2699, 35.3625, 0.2828>, 0.05734 }
				cylinder { <-4.2699, 35.3625, 0.2828>, <-4.8281, 36.3135, 0.09766>, 0.05734 }
				cylinder { <-4.8281, 36.3135, 0.09766>, <-5.3548, 37.2843, -0.07669>, 0.05734 }
				cylinder { <-5.3548, 37.2843, -0.07669>, <-5.8493, 38.2738, -0.2399>, 0.05734 }
				cylinder { <-5.8493, 38.2738, -0.2399>, <-6.311, 39.2808, -0.3919>, 0.05734 }
				cylinder { <-6.311, 39.2808, -0.3919>, <-6.7394, 40.3041, -0.5324>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-6.7394, 40.3041, -0.5324>, <-6.7743, 40.3703, -0.5384>, 0.001159 }
				cylinder { <-6.7743, 40.3703, -0.5384>, <-6.8148, 40.4335, -0.5409>, 0.001159 }
				cylinder { <-6.8148, 40.4335, -0.5409>, <-6.8607, 40.4929, -0.54>, 0.001159 }
				cylinder { <-6.8607, 40.4929, -0.54>, <-6.9114, 40.5481, -0.5355>, 0.001159 }
				cylinder { <-6.9114, 40.5481, -0.5355>, <-6.9665, 40.5985, -0.5276>, 0.001159 }
				cylinder { <-6.9665, 40.5985, -0.5276>, <-7.02558, 40.6436, -0.5164>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.02558, 40.6436, -0.5164>, <-7.5872, 41.594, -0.179>, <-7.5345, 41.6164, -0.1173> }
				triangle { <-7.5872, 41.594, -0.179>, <-7.9672, 42.08086, 0.07951>, <-7.5345, 41.6164, -0.1173> }
				triangle { <-7.9672, 42.08086, 0.07951>, <-7.9119, 42.08052, 0.1549>, <-7.5345, 41.6164, -0.1173> }
				triangle { <-7.9672, 42.08086, 0.07951>, <-9.3121, 43.3435, 1.06712>, <-7.9119, 42.08052, 0.1549> }
				triangle { <-7.9119, 42.08052, 0.1549>, <-9.3121, 43.3435, 1.06712>, <-7.8498, 42.06747, 0.2251> }
				triangle { <-7.5345, 41.6164, -0.1173>, <-7.9119, 42.08052, 0.1549>, <-7.8498, 42.06747, 0.2251> }
				triangle { <-7.5345, 41.6164, -0.1173>, <-7.8498, 42.06747, 0.2251>, <-7.4796, 41.6048, -0.06053> }
				triangle { <-7.5345, 41.6164, -0.1173>, <-7.4796, 41.6048, -0.06053>, <-7.02558, 40.6436, -0.5164> }
				triangle { <-10.06868, 43.9052, 1.6425>, <-9.3121, 43.3435, 1.06712>, <-9.4167, 43.3213, 0.9808> }
				triangle { <-7.8498, 42.06747, 0.2251>, <-9.3121, 43.3435, 1.06712>, <-9.2554, 43.3103, 1.2258> }
				triangle { <-7.9672, 42.08086, 0.07951>, <-9.4167, 43.3213, 0.9808>, <-9.3121, 43.3435, 1.06712> }
				triangle { <-10.06868, 43.9052, 1.6425>, <-9.2554, 43.3103, 1.2258>, <-9.3121, 43.3435, 1.06712> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-6.7394, 40.3041, -0.5324>, <-7.1106, 41.3493, -0.6736>, 0.05734 }
				cylinder { <-7.1106, 41.3493, -0.6736>, <-7.4234, 42.4135, -0.8152>, 0.05734 }
				cylinder { <-7.4234, 42.4135, -0.8152>, <-7.6769, 43.4933, -0.9566>, 0.05734 }
				cylinder { <-7.6769, 43.4933, -0.9566>, <-7.8703, 44.5856, -1.09737>, 0.05734 }
				cylinder { <-7.8703, 44.5856, -1.09737>, <-8.003142, 45.687, -1.237>, 0.05734 }
				cylinder { <-8.003142, 45.687, -1.237>, <-8.07484, 46.7943, -1.3751>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-8.07484, 46.7943, -1.3751>, <-8.06792, 46.8677, -1.3897>, 0.001159 }
				cylinder { <-8.06792, 46.8677, -1.3897>, <-8.04947, 46.9379, -1.409>, 0.001159 }
				cylinder { <-8.04947, 46.9379, -1.409>, <-8.02003, 47.00285, -1.4325>, 0.001159 }
				cylinder { <-8.02003, 47.00285, -1.4325>, <-7.9804, 47.06065, -1.4596>, 0.001159 }
				cylinder { <-7.9804, 47.06065, -1.4596>, <-7.9319, 47.1096, -1.4894>, 0.001159 }
				cylinder { <-7.9319, 47.1096, -1.4894>, <-7.8759, 47.1482, -1.5211>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.8759, 47.1482, -1.5211>, <-6.7893, 47.5012, -1.6862>, <-6.7623, 47.4906, -1.6072> }
				triangle { <-6.7893, 47.5012, -1.6862>, <-6.196, 47.8023, -1.7616>, <-6.7623, 47.4906, -1.6072> }
				triangle { <-6.196, 47.8023, -1.7616>, <-6.1879, 47.8041, -1.6685>, <-6.7623, 47.4906, -1.6072> }
				triangle { <-6.196, 47.8023, -1.7616>, <-4.5185, 49.04111, -1.9345>, <-6.1879, 47.8041, -1.6685> }
				triangle { <-6.1879, 47.8041, -1.6685>, <-4.5185, 49.04111, -1.9345>, <-6.1943, 47.8012, -1.574> }
				triangle { <-6.7623, 47.4906, -1.6072>, <-6.1879, 47.8041, -1.6685>, <-6.1943, 47.8012, -1.574> }
				triangle { <-6.7623, 47.4906, -1.6072>, <-6.1943, 47.8012, -1.574>, <-6.7693, 47.485, -1.5279> }
				triangle { <-6.7623, 47.4906, -1.6072>, <-6.7693, 47.485, -1.5279>, <-7.8759, 47.1482, -1.5211> }
				triangle { <-3.712, 49.7919, -2.004198>, <-4.5185, 49.04111, -1.9345>, <-4.5422, 49.07712, -2.06507> }
				triangle { <-6.1943, 47.8012, -1.574>, <-4.5185, 49.04111, -1.9345>, <-4.5221, 49.09956, -1.773> }
				triangle { <-6.196, 47.8023, -1.7616>, <-4.5422, 49.07712, -2.06507>, <-4.5185, 49.04111, -1.9345> }
				triangle { <-3.712, 49.7919, -2.004198>, <-4.5221, 49.09956, -1.773>, <-4.5185, 49.04111, -1.9345> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-8.07484, 46.7943, -1.3751>, <-8.1578, 47.8974, -1.5379>, 0.05734 }
				cylinder { <-8.1578, 47.8974, -1.5379>, <-8.2521, 48.9958, -1.7253>, 0.05734 }
				cylinder { <-8.2521, 48.9958, -1.7253>, <-8.3575, 50.08866, -1.9371>, 0.05734 }
				cylinder { <-8.3575, 50.08866, -1.9371>, <-8.4741, 51.1753, -2.1732>, 0.05734 }
				cylinder { <-8.4741, 51.1753, -2.1732>, <-8.6018, 52.2552, -2.4335>, 0.05734 }
				cylinder { <-8.6018, 52.2552, -2.4335>, <-8.7405, 53.3277, -2.7179>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-8.7405, 53.3277, -2.7179>, <-8.7597, 53.3989, -2.7322>, 0.001159 }
				cylinder { <-8.7597, 53.3989, -2.7322>, <-8.7884, 53.4677, -2.7413>, 0.001159 }
				cylinder { <-8.7884, 53.4677, -2.7413>, <-8.826, 53.5326, -2.7452>, 0.001159 }
				cylinder { <-8.826, 53.5326, -2.7452>, <-8.8717, 53.5922, -2.7436>, 0.001159 }
				cylinder { <-8.8717, 53.5922, -2.7436>, <-8.9244, 53.6452, -2.7367>, 0.001159 }
				cylinder { <-8.9244, 53.6452, -2.7367>, <-8.983, 53.6905, -2.7246>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.983, 53.6905, -2.7246>, <-9.5357, 54.6439, -2.3807>, <-9.4819, 54.6663, -2.32> }
				triangle { <-9.5357, 54.6439, -2.3807>, <-9.9096, 55.1328, -2.1172>, <-9.4819, 54.6663, -2.32> }
				triangle { <-9.9096, 55.1328, -2.1172>, <-9.8531, 55.1325, -2.04282>, <-9.4819, 54.6663, -2.32> }
				triangle { <-9.9096, 55.1328, -2.1172>, <-11.2331, 56.4031, -1.1106>, <-9.8531, 55.1325, -2.04282> }
				triangle { <-9.8531, 55.1325, -2.04282>, <-11.2331, 56.4031, -1.1106>, <-9.7897, 55.1195, -1.9736> }
				triangle { <-9.4819, 54.6663, -2.32>, <-9.8531, 55.1325, -2.04282>, <-9.7897, 55.1195, -1.9736> }
				triangle { <-9.4819, 54.6663, -2.32>, <-9.7897, 55.1195, -1.9736>, <-9.426, 54.6547, -2.2641> }
				triangle { <-9.4819, 54.6663, -2.32>, <-9.426, 54.6547, -2.2641>, <-8.983, 53.6905, -2.7246> }
				triangle { <-11.9777, 56.9691, -0.524>, <-11.2331, 56.4031, -1.1106>, <-11.3393, 56.3809, -1.195> }
				triangle { <-9.7897, 55.1195, -1.9736>, <-11.2331, 56.4031, -1.1106>, <-11.1737, 56.3702, -0.9528> }
				triangle { <-9.9096, 55.1328, -2.1172>, <-11.3393, 56.3809, -1.195>, <-11.2331, 56.4031, -1.1106> }
				triangle { <-11.9777, 56.9691, -0.524>, <-11.1737, 56.3702, -0.9528>, <-11.2331, 56.4031, -1.1106> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-8.7405, 53.3277, -2.7179>, <-8.9257, 54.3829, -3.03822>, 0.05734 }
				cylinder { <-8.9257, 54.3829, -3.03822>, <-9.157, 55.4176, -3.3935>, 0.05734 }
				cylinder { <-9.157, 55.4176, -3.3935>, <-9.4335, 56.4286, -3.7829>, 0.05734 }
				cylinder { <-9.4335, 56.4286, -3.7829>, <-9.7545, 57.413, -4.2051>, 0.05734 }
				cylinder { <-9.7545, 57.413, -4.2051>, <-10.1189, 58.3678, -4.6589>, 0.05734 }
				cylinder { <-10.1189, 58.3678, -4.6589>, <-10.5256, 59.29, -5.143>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-10.5256, 59.29, -5.143>, <-10.5463, 59.3527, -5.1788>, 0.001159 }
				cylinder { <-10.5463, 59.3527, -5.1788>, <-10.5603, 59.4155, -5.2175>, 0.001159 }
				cylinder { <-10.5603, 59.4155, -5.2175>, <-10.5674, 59.4779, -5.2587>, 0.001159 }
				cylinder { <-10.5674, 59.4779, -5.2587>, <-10.5676, 59.5391, -5.3022>, 0.001159 }
				cylinder { <-10.5676, 59.5391, -5.3022>, <-10.5607, 59.5987, -5.3473>, 0.001159 }
				cylinder { <-10.5607, 59.5987, -5.3473>, <-10.547, 59.6561, -5.3938>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.547, 59.6561, -5.3938>, <-9.9737, 60.561, -5.8239>, <-9.9375, 60.5861, -5.7521> }
				triangle { <-9.9737, 60.561, -5.8239>, <-9.729, 61.1403, -6.05377>, <-9.9375, 60.5861, -5.7521> }
				triangle { <-9.729, 61.1403, -6.05377>, <-9.7135, 61.1661, -5.9652>, <-9.9375, 60.5861, -5.7521> }
				triangle { <-9.729, 61.1403, -6.05377>, <-9.2831, 63.08054, -6.6983>, <-9.7135, 61.1661, -5.9652> }
				triangle { <-9.7135, 61.1661, -5.9652>, <-9.2831, 63.08054, -6.6983>, <-9.7059, 61.1795, -5.8717> }
				triangle { <-9.9375, 60.5861, -5.7521>, <-9.7135, 61.1661, -5.9652>, <-9.7059, 61.1795, -5.8717> }
				triangle { <-9.9375, 60.5861, -5.7521>, <-9.7059, 61.1795, -5.8717>, <-9.9302, 60.594, -5.673> }
				triangle { <-9.9375, 60.5861, -5.7521>, <-9.9302, 60.594, -5.673>, <-10.547, 59.6561, -5.3938> }
				triangle { <-9.1675, 64.1337, -7.008725>, <-9.2831, 63.08054, -6.6983>, <-9.339, 63.06606, -6.8231> }
				triangle { <-9.7059, 61.1795, -5.8717>, <-9.2831, 63.08054, -6.6983>, <-9.3053, 63.1562, -6.5457> }
				triangle { <-9.729, 61.1403, -6.05377>, <-9.339, 63.06606, -6.8231>, <-9.2831, 63.08054, -6.6983> }
				triangle { <-9.1675, 64.1337, -7.008725>, <-9.3053, 63.1562, -6.5457>, <-9.2831, 63.08054, -6.6983> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-10.5256, 59.29, -5.143>, <-10.9969, 60.1723, -5.6427>, 0.05734 }
				cylinder { <-10.9969, 60.1723, -5.6427>, <-11.5306, 61.01036, -6.1558>, 0.05734 }
				cylinder { <-11.5306, 61.01036, -6.1558>, <-12.124, 61.8, -6.6798>, 0.05734 }
				cylinder { <-12.124, 61.8, -6.6798>, <-12.7742, 62.5376, -7.2123>, 0.05734 }
				cylinder { <-12.7742, 62.5376, -7.2123>, <-13.4781, 63.2194, -7.7508>, 0.05734 }
				cylinder { <-13.4781, 63.2194, -7.7508>, <-14.2322, 63.8422, -8.2928>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-14.2322, 63.8422, -8.2928>, <-14.2913, 63.8788, -8.321>, 0.001159 }
				cylinder { <-14.2913, 63.8788, -8.321>, <-14.3572, 63.9093, -8.3402>, 0.001159 }
				cylinder { <-14.3572, 63.9093, -8.3402>, <-14.4279, 63.9327, -8.3497>, 0.001159 }
				cylinder { <-14.4279, 63.9327, -8.3497>, <-14.5014, 63.9482, -8.3494>, 0.001159 }
				cylinder { <-14.5014, 63.9482, -8.3494>, <-14.5754, 63.9556, -8.3392>, 0.001159 }
				cylinder { <-14.5754, 63.9556, -8.3392>, <-14.6479, 63.9544, -8.3194>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-14.6479, 63.9544, -8.3194>, <-15.6755, 64.3892, -8.0239>, <-15.6474, 64.4599, -7.9877> }
				triangle { <-15.6755, 64.3892, -8.0239>, <-16.2604, 64.5858, -7.7639>, <-15.6474, 64.4599, -7.9877> }
				triangle { <-16.2604, 64.5858, -7.7639>, <-16.2135, 64.6472, -7.7112>, <-15.6474, 64.4599, -7.9877> }
				triangle { <-16.2604, 64.5858, -7.7639>, <-18.00649, 64.9879, -6.683>, <-16.2135, 64.6472, -7.7112> }
				triangle { <-16.2135, 64.6472, -7.7112>, <-18.00649, 64.9879, -6.683>, <-16.1534, 64.7022, -7.6629> }
				triangle { <-15.6474, 64.4599, -7.9877>, <-16.2135, 64.6472, -7.7112>, <-16.1534, 64.7022, -7.6629> }
				triangle { <-15.6474, 64.4599, -7.9877>, <-16.1534, 64.7022, -7.6629>, <-15.5948, 64.5065, -7.9499> }
				triangle { <-15.6474, 64.4599, -7.9877>, <-15.5948, 64.5065, -7.9499>, <-14.6479, 63.9544, -8.3194> }
				triangle { <-18.8843, 65.1179, -6.0263>, <-18.00649, 64.9879, -6.683>, <-18.0743, 64.8761, -6.7256> }
				triangle { <-16.1534, 64.7022, -7.6629>, <-18.00649, 64.9879, -6.683>, <-17.9282, 65.05756, -6.5468> }
				triangle { <-16.2604, 64.5858, -7.7639>, <-18.0743, 64.8761, -6.7256>, <-18.00649, 64.9879, -6.683> }
				triangle { <-18.8843, 65.1179, -6.0263>, <-17.9282, 65.05756, -6.5468>, <-18.00649, 64.9879, -6.683> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-14.2322, 63.8422, -8.2928>, <-14.9863, 64.4649, -8.8348>, 0.05734 }
				cylinder { <-14.9863, 64.4649, -8.8348>, <-15.7404, 65.08776, -9.3769>, 0.05734 }
				cylinder { <-15.7404, 65.08776, -9.3769>, <-16.4945, 65.7105, -9.9189>, 0.05734 }
				cylinder { <-16.4945, 65.7105, -9.9189>, <-17.2486, 66.3333, -10.4609>, 0.05734 }
				cylinder { <-17.2486, 66.3333, -10.4609>, <-18.00271, 66.9561, -11.00294>, 0.05734 }
				cylinder { <-18.00271, 66.9561, -11.00294>, <-18.7568, 67.5788, -11.5449>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-18.7568, 67.5788, -11.5449>, <-18.8004, 67.6236, -11.5865>, 0.001159 }
				cylinder { <-18.8004, 67.6236, -11.5865>, <-18.8364, 67.6706, -11.6327>, 0.001159 }
				cylinder { <-18.8364, 67.6706, -11.6327>, <-18.8642, 67.7191, -11.6829>, 0.001159 }
				cylinder { <-18.8642, 67.7191, -11.6829>, <-18.8833, 67.7685, -11.7361>, 0.001159 }
				cylinder { <-18.8833, 67.7685, -11.7361>, <-18.8936, 67.8179, -11.7917>, 0.001159 }
				cylinder { <-18.8936, 67.8179, -11.7917>, <-18.8948, 67.8666, -11.8488>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-18.8948, 67.8666, -11.8488>, <-18.5723, 68.7862, -12.4676>, <-18.5446, 68.8332, -12.4035> }
				triangle { <-18.5723, 68.7862, -12.4676>, <-18.4844, 69.3524, -12.8141>, <-18.5446, 68.8332, -12.4035> }
				triangle { <-18.4844, 69.3524, -12.8141>, <-18.477, 69.398, -12.7328>, <-18.5446, 68.8332, -12.4035> }
				triangle { <-18.4844, 69.3524, -12.8141>, <-18.5519, 71.1771, -13.836>, <-18.477, 69.398, -12.7328> }
				triangle { <-18.477, 69.398, -12.7328>, <-18.5519, 71.1771, -13.836>, <-18.474, 69.431, -12.6441> }
				triangle { <-18.5446, 68.8332, -12.4035>, <-18.477, 69.398, -12.7328>, <-18.474, 69.431, -12.6441> }
				triangle { <-18.5446, 68.8332, -12.4035>, <-18.474, 69.431, -12.6441>, <-18.5404, 68.8581, -12.3278> }
				triangle { <-18.5446, 68.8332, -12.4035>, <-18.5404, 68.8581, -12.3278>, <-18.8948, 67.8666, -11.8488> }
				triangle { <-18.7111, 72.1429, -14.3467>, <-18.5519, 71.1771, -13.836>, <-18.6009, 71.1246, -13.9532> }
				triangle { <-18.474, 69.431, -12.6441>, <-18.5519, 71.1771, -13.836>, <-18.5945, 71.2729, -13.6999> }
				triangle { <-18.4844, 69.3524, -12.8141>, <-18.6009, 71.1246, -13.9532>, <-18.5519, 71.1771, -13.836> }
				triangle { <-18.7111, 72.1429, -14.3467>, <-18.5945, 71.2729, -13.6999>, <-18.5519, 71.1771, -13.836> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-18.7568, 67.5788, -11.5449>, <-18.8033, 67.6225, -11.5845>, 0.001159 }
				cylinder { <-18.8033, 67.6225, -11.5845>, <-18.8454, 67.6677, -11.6271>, 0.001159 }
				cylinder { <-18.8454, 67.6677, -11.6271>, <-18.883, 67.7143, -11.6725>, 0.001159 }
				cylinder { <-18.883, 67.7143, -11.6725>, <-18.9158, 67.762, -11.7203>, 0.001159 }
				cylinder { <-18.9158, 67.762, -11.7203>, <-18.9436, 67.8106, -11.7704>, 0.001159 }
				cylinder { <-18.9436, 67.8106, -11.7704>, <-18.9662, 67.8597, -11.8225>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-18.9662, 67.8597, -11.8225>, <-18.9607, 68.8399, -12.4322>, <-18.9284, 68.8896, -12.3725> }
				triangle { <-18.9607, 68.8399, -12.4322>, <-19.05577, 69.4214, -12.7502>, <-18.9284, 68.8896, -12.3725> }
				triangle { <-19.05577, 69.4214, -12.7502>, <-19.03878, 69.4655, -12.6695>, <-18.9284, 68.8896, -12.3725> }
				triangle { <-19.05577, 69.4214, -12.7502>, <-19.6767, 71.2262, -13.6079>, <-19.03878, 69.4655, -12.6695> }
				triangle { <-19.03878, 69.4655, -12.6695>, <-19.6767, 71.2262, -13.6079>, <-19.02208, 69.496, -12.5814> }
				triangle { <-18.9284, 68.8896, -12.3725>, <-19.03878, 69.4655, -12.6695>, <-19.02208, 69.496, -12.5814> }
				triangle { <-18.9284, 68.8896, -12.3725>, <-19.02208, 69.496, -12.5814>, <-18.9119, 68.9128, -12.2978> }
				triangle { <-18.9284, 68.8896, -12.3725>, <-18.9119, 68.9128, -12.2978>, <-18.9662, 67.8597, -11.8225> }
				triangle { <-20.117, 72.1571, -14.00603>, <-19.6767, 71.2262, -13.6079>, <-19.7404, 71.1685, -13.7152> }
				triangle { <-19.02208, 69.496, -12.5814>, <-19.6767, 71.2262, -13.6079>, <-19.7045, 71.3084, -13.4596> }
				triangle { <-19.05577, 69.4214, -12.7502>, <-19.7404, 71.1685, -13.7152>, <-19.6767, 71.2262, -13.6079> }
				triangle { <-20.117, 72.1571, -14.00603>, <-19.7045, 71.3084, -13.4596>, <-19.6767, 71.2262, -13.6079> }
				texture{Grass_Texture5}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 11.2873, 0.0>, 0.07351 }
			cylinder { <-0.0, 11.2873, 0.0>, <-0.0, 22.5746, 0.0>, 0.07351 }
			cylinder { <-0.0, 22.5746, 0.0>, <-0.00000001, 33.862, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 33.862, 0.0>, <-0.00000001, 45.1493, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 45.1493, 0.0>, <-0.00000001, 56.4367, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 56.4367, 0.0>, <-0.00000001, 67.724, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <-0.00000001, 68.2489, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 68.2489, 0.0>, <-0.00000001, 68.7738, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 68.7738, 0.0>, <-0.00000001, 69.2986, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 69.2986, 0.0>, <-0.00000001, 69.8235, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 69.8235, 0.0>, <-0.00000001, 70.3484, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 70.3484, 0.0>, <-0.00000001, 70.8732, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 70.8732, 0.0>, <-0.00000001, 71.3981, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 71.3981, 0.0>, <-0.00000001, 71.923, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 71.923, 0.0>, <-0.00000001, 72.4478, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 72.4478, 0.0>, <-0.00000001, 72.9727, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 72.9727, 0.0>, <-0.00000002, 73.4975, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 73.4975, 0.0>, <-0.00000002, 74.02245, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 74.02245, 0.0>, <-0.00000002, 74.5473, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 74.5473, 0.0>, <-0.00000002, 75.07218, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 75.07218, 0.0>, <-0.00000002, 75.597, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 75.597, 0.0>, <-0.00000002, 76.1219, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 76.1219, 0.0>, <-0.00000002, 76.6467, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 76.6467, 0.0>, <-0.00000002, 77.1716, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 77.1716, 0.0>, <-0.0009695, 77.2274, 0.0009695>, 0.07351 }
				cylinder { <-0.0009695, 77.2274, 0.0009695>, <-0.002908, 77.2832, 0.002908>, 0.07351 }
				cylinder { <-0.002908, 77.2832, 0.002908>, <-0.005814, 77.339, 0.005814>, 0.07351 }
				cylinder { <-0.005814, 77.339, 0.005814>, <-0.009686, 77.3946, 0.009686>, 0.07351 }
				cylinder { <-0.009686, 77.3946, 0.009686>, <-0.01452, 77.45, 0.01452>, 0.07351 }
				cylinder { <-0.01452, 77.45, 0.01452>, <-0.02032, 77.5053, 0.02032>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.02032, 77.5053, 0.02032>, <-0.2876, 79.5045, 1.1115>, <-0.06579, 79.6105, 1.03709> }
					triangle { <-0.2876, 79.5045, 1.1115>, <-0.3903, 80.7033, 1.5281>, <-0.06579, 79.6105, 1.03709> }
					triangle { <-0.3903, 80.7033, 1.5281>, <-0.1389, 80.8129, 1.4485>, <-0.06579, 79.6105, 1.03709> }
					triangle { <-0.3903, 80.7033, 1.5281>, <-0.2085, 82.525, 2.05491>, <-0.1389, 80.8129, 1.4485> }
					triangle { <-0.1389, 80.8129, 1.4485>, <-0.2085, 82.525, 2.05491>, <0.1427, 80.7675, 1.4352> }
					triangle { <-0.06579, 79.6105, 1.03709>, <-0.1389, 80.8129, 1.4485>, <0.1427, 80.7675, 1.4352> }
					triangle { <-0.06579, 79.6105, 1.03709>, <0.1427, 80.7675, 1.4352>, <0.1801, 79.5722, 1.001288> }
					triangle { <-0.06579, 79.6105, 1.03709>, <0.1801, 79.5722, 1.001288>, <-0.02032, 77.5053, 0.02032> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 77.1716, 0.0>, <-0.00000002, 77.6965, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 77.6965, 0.0>, <-0.00000002, 78.2213, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 78.2213, 0.0>, <-0.00000002, 78.7462, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 78.7462, 0.0>, <-0.00000002, 79.2711, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 79.2711, 0.0>, <-0.00000002, 79.7959, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 79.7959, 0.0>, <-0.00000002, 80.3208, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 80.3208, 0.0>, <0.001369, 80.3766, -0.00006728>, 0.07351 }
				cylinder { <0.001369, 80.3766, -0.00006728>, <0.004107, 80.4324, -0.0002018>, 0.07351 }
				cylinder { <0.004107, 80.4324, -0.0002018>, <0.008213, 80.4882, -0.0004034>, 0.07351 }
				cylinder { <0.008213, 80.4882, -0.0004034>, <0.01368, 80.5438, -0.0006722>, 0.07351 }
				cylinder { <0.01368, 80.5438, -0.0006722>, <0.02051, 80.5992, -0.001007>, 0.07351 }
				cylinder { <0.02051, 80.5992, -0.001007>, <0.0287, 80.6545, -0.00141>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.0287, 80.6545, -0.00141>, <0.7146, 82.6527, -0.1766>, <0.5196, 82.7412, -0.2793> }
					triangle { <0.7146, 82.6527, -0.1766>, <0.9245, 83.8109, -0.1871>, <0.5196, 82.7412, -0.2793> }
					triangle { <0.9245, 83.8109, -0.1871>, <0.7081, 83.9025, -0.3076>, <0.5196, 82.7412, -0.2793> }
					triangle { <0.9245, 83.8109, -0.1871>, <0.9708, 85.5604, -0.3843>, <0.7081, 83.9025, -0.3076> }
					triangle { <0.7081, 83.9025, -0.3076>, <0.9708, 85.5604, -0.3843>, <0.5395, 83.8656, -0.5074> }
					triangle { <0.5196, 82.7412, -0.2793>, <0.7081, 83.9025, -0.3076>, <0.5395, 83.8656, -0.5074> }
					triangle { <0.5196, 82.7412, -0.2793>, <0.5395, 83.8656, -0.5074>, <0.3551, 82.706, -0.4397> }
					triangle { <0.5196, 82.7412, -0.2793>, <0.3551, 82.706, -0.4397>, <0.0287, 80.6545, -0.00141> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 80.3208, 0.0>, <-0.00000002, 80.8456, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 80.8456, 0.0>, <-0.00000002, 81.3705, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 81.3705, 0.0>, <-0.00000002, 81.8954, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 81.8954, 0.0>, <-0.00000002, 82.4202, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 82.4202, 0.0>, <-0.00000002, 82.9451, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 82.9451, 0.0>, <-0.00000002, 83.47, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 83.47, 0.0>, <-0.001059, 83.5258, -0.0008698>, 0.07351 }
				cylinder { <-0.001059, 83.5258, -0.0008698>, <-0.003179, 83.5816, -0.002609>, 0.07351 }
				cylinder { <-0.003179, 83.5816, -0.002609>, <-0.006356, 83.6373, -0.005216>, 0.07351 }
				cylinder { <-0.006356, 83.6373, -0.005216>, <-0.01058, 83.6929, -0.00869>, 0.07351 }
				cylinder { <-0.01058, 83.6929, -0.00869>, <-0.01587, 83.7484, -0.01302>, 0.07351 }
				cylinder { <-0.01587, 83.7484, -0.01302>, <-0.02221, 83.8037, -0.01823>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.02221, 83.8037, -0.01823>, <-0.5292, 85.6545, -0.3398>, <-0.4625, 85.7339, -0.1481> }
					triangle { <-0.5292, 85.6545, -0.3398>, <-0.641, 86.7215, -0.4674>, <-0.4625, 85.7339, -0.1481> }
					triangle { <-0.641, 86.7215, -0.4674>, <-0.5713, 86.8037, -0.2504>, <-0.4625, 85.7339, -0.1481> }
					triangle { <-0.641, 86.7215, -0.4674>, <-0.7453, 88.3316, -0.3683>, <-0.5713, 86.8037, -0.2504> }
					triangle { <-0.5713, 86.8037, -0.2504>, <-0.7453, 88.3316, -0.3683>, <-0.5873, 86.7707, -0.01086> }
					triangle { <-0.4625, 85.7339, -0.1481>, <-0.5713, 86.8037, -0.2504>, <-0.5873, 86.7707, -0.01086> }
					triangle { <-0.4625, 85.7339, -0.1481>, <-0.5873, 86.7707, -0.01086>, <-0.4563, 85.7017, 0.06271> }
					triangle { <-0.4625, 85.7339, -0.1481>, <-0.4563, 85.7017, 0.06271>, <-0.02221, 83.8037, -0.01823> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 83.47, 0.0>, <-0.00000002, 83.9948, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 83.9948, 0.0>, <-0.00000002, 84.5197, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 84.5197, 0.0>, <-0.00000002, 85.0446, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 85.0446, 0.0>, <-0.00000002, 85.5694, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 85.5694, 0.0>, <-0.00000002, 86.09433, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 86.09433, 0.0>, <-0.00000002, 86.6191, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 86.6191, 0.0>, <0.0002011, 86.675, 0.001356>, 0.07351 }
				cylinder { <0.0002011, 86.675, 0.001356>, <0.0006034, 86.7308, 0.004068>, 0.07351 }
				cylinder { <0.0006034, 86.7308, 0.004068>, <0.001206, 86.7865, 0.008133>, 0.07351 }
				cylinder { <0.001206, 86.7865, 0.008133>, <0.00201, 86.8421, 0.01355>, 0.07351 }
				cylinder { <0.00201, 86.8421, 0.01355>, <0.003013, 86.8976, 0.02031>, 0.07351 }
				cylinder { <0.003013, 86.8976, 0.02031>, <0.004216, 86.9528, 0.02842>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.004216, 86.9528, 0.02842>, <0.4987, 88.5213, 0.6849>, <0.5565, 88.6021, 0.5132> }
					triangle { <0.4987, 88.5213, 0.6849>, <0.6779, 89.4563, 0.9307>, <0.5565, 88.6021, 0.5132> }
					triangle { <0.6779, 89.4563, 0.9307>, <0.7465, 89.5399, 0.7384>, <0.5565, 88.6021, 0.5132> }
					triangle { <0.6779, 89.4563, 0.9307>, <1.04605, 90.8757, 1.04798>, <0.7465, 89.5399, 0.7384> }
					triangle { <0.7465, 89.5399, 0.7384>, <1.04605, 90.8757, 1.04798>, <0.8731, 89.5055, 0.5612> }
					triangle { <0.5565, 88.6021, 0.5132>, <0.7465, 89.5399, 0.7384>, <0.8731, 89.5055, 0.5612> }
					triangle { <0.5565, 88.6021, 0.5132>, <0.8731, 89.5055, 0.5612>, <0.6523, 88.5726, 0.3469> }
					triangle { <0.5565, 88.6021, 0.5132>, <0.6523, 88.5726, 0.3469>, <0.004216, 86.9528, 0.02842> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000002, 86.6191, 0.0>, <-0.00000002, 87.144, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 87.144, 0.0>, <-0.00000002, 87.6689, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 87.6689, 0.0>, <-0.00000002, 88.1937, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 88.1937, 0.0>, <-0.00000002, 88.7186, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 88.7186, 0.0>, <-0.00000002, 89.2435, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 89.2435, 0.0>, <-0.00000002, 89.7683, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.00000002, 89.7683, 0.0>, <0.0007617, 89.8242, -0.00114>, 0.07351 }
				cylinder { <0.0007617, 89.8242, -0.00114>, <0.002284, 89.88, -0.003419>, 0.07351 }
				cylinder { <0.002284, 89.88, -0.003419>, <0.004568, 89.9357, -0.006837>, 0.07351 }
				cylinder { <0.004568, 89.9357, -0.006837>, <0.00761, 89.9913, -0.01139>, 0.07351 }
				cylinder { <0.00761, 89.9913, -0.01139>, <0.01141, 90.04681, -0.01707>, 0.07351 }
				cylinder { <0.01141, 90.04681, -0.01707>, <0.01596, 90.102, -0.02389>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.01596, 90.102, -0.02389>, <0.2907, 91.6711, 0.05621>, <0.1246, 91.72, 0.1002> }
					triangle { <0.2907, 91.6711, 0.05621>, <0.3784, 92.5342, 0.2343>, <0.1246, 91.72, 0.1002> }
					triangle { <0.3784, 92.5342, 0.2343>, <0.1913, 92.5848, 0.2778>, <0.1246, 91.72, 0.1002> }
					triangle { <0.3784, 92.5342, 0.2343>, <0.2662, 93.8247, 0.5132>, <0.1913, 92.5848, 0.2778> }
					triangle { <0.1913, 92.5848, 0.2778>, <0.2662, 93.8247, 0.5132>, <0.0008158, 92.5652, 0.2251> }
					triangle { <0.1246, 91.72, 0.1002>, <0.1913, 92.5848, 0.2778>, <0.0008158, 92.5652, 0.2251> }
					triangle { <0.1246, 91.72, 0.1002>, <0.0008158, 92.5652, 0.2251>, <-0.04565, 91.6955, 0.06885> }
					triangle { <0.1246, 91.72, 0.1002>, <-0.04565, 91.6955, 0.06885>, <0.01596, 90.102, -0.02389> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <-0.00000001, 68.2489, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 68.2489, 0.0>, <-0.00000001, 68.7738, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 68.7738, 0.0>, <-0.00000001, 69.2986, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 69.2986, 0.0>, <-0.00000001, 69.8235, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 69.8235, 0.0>, <-0.00000001, 70.3484, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 70.3484, 0.0>, <-0.00000001, 70.8732, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 70.8732, 0.0>, <-0.01821, 71.3975, 0.01821>, 0.07351 }
			cylinder { <-0.01821, 71.3975, 0.01821>, <-0.03642, 71.9217, 0.03642>, 0.07351 }
			cylinder { <-0.03642, 71.9217, 0.03642>, <-0.05463, 72.4459, 0.05463>, 0.07351 }
			cylinder { <-0.05463, 72.4459, 0.05463>, <-0.07284, 72.9701, 0.07284>, 0.07351 }
			cylinder { <-0.07284, 72.9701, 0.07284>, <-0.09105, 73.4944, 0.09105>, 0.07351 }
			cylinder { <-0.09105, 73.4944, 0.09105>, <-0.1092, 74.01865, 0.1092>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.1092, 74.01865, 0.1092>, <-0.1098, 74.07449, 0.1111>, 0.07351 }
				cylinder { <-0.1098, 74.07449, 0.1111>, <-0.109, 74.1303, 0.1129>, 0.07351 }
				cylinder { <-0.109, 74.1303, 0.1129>, <-0.1068, 74.1861, 0.1146>, 0.07351 }
				cylinder { <-0.1068, 74.1861, 0.1146>, <-0.1033, 74.2418, 0.1163>, 0.07351 }
				cylinder { <-0.1033, 74.2418, 0.1163>, <-0.09842, 74.2975, 0.1179>, 0.07351 }
				cylinder { <-0.09842, 74.2975, 0.1179>, <-0.09215, 74.353, 0.1194>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.09215, 74.353, 0.1194>, <0.5545, 75.9587, -0.2532>, <0.3865, 76.03635, -0.3248> }
					triangle { <0.5545, 75.9587, -0.2532>, <0.784, 76.907, -0.3748>, <0.3865, 76.03635, -0.3248> }
					triangle { <0.784, 76.907, -0.3748>, <0.5966, 76.9871, -0.4591>, <0.3865, 76.03635, -0.3248> }
					triangle { <0.784, 76.907, -0.3748>, <0.8872, 78.3424, -0.68>, <0.5966, 76.9871, -0.4591> }
					triangle { <0.5966, 76.9871, -0.4591>, <0.8872, 78.3424, -0.68>, <0.4338, 76.9521, -0.6036> }
					triangle { <0.3865, 76.03635, -0.3248>, <0.5966, 76.9871, -0.4591>, <0.4338, 76.9521, -0.6036> }
					triangle { <0.3865, 76.03635, -0.3248>, <0.4338, 76.9521, -0.6036>, <0.2315, 76.00526, -0.4375> }
					triangle { <0.3865, 76.03635, -0.3248>, <0.2315, 76.00526, -0.4375>, <-0.09215, 74.353, 0.1194> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.1092, 74.01865, 0.1092>, <-0.1274, 74.5428, 0.1274>, 0.07351 }
			cylinder { <-0.1274, 74.5428, 0.1274>, <-0.1456, 75.06712, 0.1456>, 0.07351 }
			cylinder { <-0.1456, 75.06712, 0.1456>, <-0.1638, 75.5913, 0.1638>, 0.07351 }
			cylinder { <-0.1638, 75.5913, 0.1638>, <-0.1821, 76.1155, 0.1821>, 0.07351 }
			cylinder { <-0.1821, 76.1155, 0.1821>, <-0.2003, 76.6398, 0.2003>, 0.07351 }
			cylinder { <-0.2003, 76.6398, 0.2003>, <-0.2185, 77.164, 0.2185>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.2185, 77.164, 0.2185>, <-0.2215, 77.2198, 0.2195>, 0.07351 }
				cylinder { <-0.2215, 77.2198, 0.2195>, <-0.2255, 77.2755, 0.2197>, 0.07351 }
				cylinder { <-0.2255, 77.2755, 0.2197>, <-0.2306, 77.3311, 0.2191>, 0.07351 }
				cylinder { <-0.2306, 77.3311, 0.2191>, <-0.2368, 77.3866, 0.2175>, 0.07351 }
				cylinder { <-0.2368, 77.3866, 0.2175>, <-0.244, 77.442, 0.2151>, 0.07351 }
				cylinder { <-0.244, 77.442, 0.2151>, <-0.2523, 77.4972, 0.2118>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.2523, 77.4972, 0.2118>, <-0.2003, 79.07734, 0.0008975>, <-0.1744, 79.1212, 0.1721> }
					triangle { <-0.2003, 79.07734, 0.0008975>, <-0.04453, 79.9482, -0.03878>, <-0.1744, 79.1212, 0.1721> }
					triangle { <-0.04453, 79.9482, -0.03878>, <-0.02125, 79.993, 0.1533>, <-0.1744, 79.1212, 0.1721> }
					triangle { <-0.04453, 79.9482, -0.03878>, <0.1772, 81.2416, 0.145>, <-0.02125, 79.993, 0.1533> }
					triangle { <-0.02125, 79.993, 0.1533>, <0.1772, 81.2416, 0.145>, <-0.0915, 79.9646, 0.3369> }
					triangle { <-0.1744, 79.1212, 0.1721>, <-0.02125, 79.993, 0.1533>, <-0.0915, 79.9646, 0.3369> }
					triangle { <-0.1744, 79.1212, 0.1721>, <-0.0915, 79.9646, 0.3369>, <-0.2213, 79.08932, 0.3375> }
					triangle { <-0.1744, 79.1212, 0.1721>, <-0.2213, 79.08932, 0.3375>, <-0.2523, 77.4972, 0.2118> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000001, 70.8732, 0.0>, <-0.00000001, 71.3981, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 71.3981, 0.0>, <-0.00000001, 71.923, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 71.923, 0.0>, <-0.00000001, 72.4478, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 72.4478, 0.0>, <-0.00000001, 72.9727, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 72.9727, 0.0>, <-0.00000002, 73.4975, 0.0>, 0.07351 }
			cylinder { <-0.00000002, 73.4975, 0.0>, <-0.00000002, 74.02245, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000002, 74.02245, 0.0>, <0.02572, 74.5466, -0.001263>, 0.07351 }
			cylinder { <0.02572, 74.5466, -0.001263>, <0.05144, 75.07092, -0.002527>, 0.07351 }
			cylinder { <0.05144, 75.07092, -0.002527>, <0.07716, 75.5951, -0.003791>, 0.07351 }
			cylinder { <0.07716, 75.5951, -0.003791>, <0.1028, 76.1193, -0.005054>, 0.07351 }
			cylinder { <0.1028, 76.1193, -0.005054>, <0.1286, 76.6436, -0.006318>, 0.07351 }
			cylinder { <0.1286, 76.6436, -0.006318>, <0.1543, 77.1678, -0.007582>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.1543, 77.1678, -0.007582>, <0.156, 77.2236, -0.008586>, 0.07351 }
				cylinder { <0.156, 77.2236, -0.008586>, <0.1566, 77.2795, -0.01046>, 0.07351 }
				cylinder { <0.1566, 77.2795, -0.01046>, <0.1561, 77.3353, -0.0132>, 0.07351 }
				cylinder { <0.1561, 77.3353, -0.0132>, <0.1546, 77.391, -0.01681>, 0.07351 }
				cylinder { <0.1546, 77.391, -0.01681>, <0.1521, 77.4466, -0.02128>, 0.07351 }
				cylinder { <0.1521, 77.4466, -0.02128>, <0.1485, 77.5021, -0.02661>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.1485, 77.5021, -0.02661>, <-0.5809, 79.1079, -0.1847>, <-0.5046, 79.1855, -0.01891> }
					triangle { <-0.5809, 79.1079, -0.1847>, <-0.8326, 80.05626, -0.2487>, <-0.5046, 79.1855, -0.01891> }
					triangle { <-0.8326, 80.05626, -0.2487>, <-0.7504, 80.1363, -0.06048>, <-0.5046, 79.1855, -0.01891> }
					triangle { <-0.8326, 80.05626, -0.2487>, <-1.1141, 81.4916, -0.09193>, <-0.7504, 80.1363, -0.06048> }
					triangle { <-0.7504, 80.1363, -0.06048>, <-1.1141, 81.4916, -0.09193>, <-0.7268, 80.1013, 0.1559> }
					triangle { <-0.5046, 79.1855, -0.01891>, <-0.7504, 80.1363, -0.06048>, <-0.7268, 80.1013, 0.1559> }
					triangle { <-0.5046, 79.1855, -0.01891>, <-0.7268, 80.1013, 0.1559>, <-0.4653, 79.1544, 0.1687> }
					triangle { <-0.5046, 79.1855, -0.01891>, <-0.4653, 79.1544, 0.1687>, <0.1485, 77.5021, -0.02661> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.1543, 77.1678, -0.007582>, <0.18, 77.692, -0.008845>, 0.07351 }
			cylinder { <0.18, 77.692, -0.008845>, <0.2057, 78.2163, -0.0101>, 0.07351 }
			cylinder { <0.2057, 78.2163, -0.0101>, <0.2315, 78.7405, -0.01137>, 0.07351 }
			cylinder { <0.2315, 78.7405, -0.01137>, <0.2572, 79.2647, -0.01263>, 0.07351 }
			cylinder { <0.2572, 79.2647, -0.01263>, <0.2829, 79.7889, -0.0139>, 0.07351 }
			cylinder { <0.2829, 79.7889, -0.0139>, <0.3086, 80.3132, -0.01516>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.3086, 80.3132, -0.01516>, <0.3116, 80.369, -0.01394>, 0.07351 }
				cylinder { <0.3116, 80.369, -0.01394>, <0.3147, 80.4247, -0.01136>, 0.07351 }
				cylinder { <0.3147, 80.4247, -0.01136>, <0.318, 80.4803, -0.007433>, 0.07351 }
				cylinder { <0.318, 80.4803, -0.007433>, <0.3216, 80.5358, -0.002149>, 0.07351 }
				cylinder { <0.3216, 80.5358, -0.002149>, <0.3253, 80.5912, 0.004482>, 0.07351 }
				cylinder { <0.3253, 80.5912, 0.004482>, <0.3292, 80.6463, 0.01245>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.3292, 80.6463, 0.01245>, <0.149, 82.2265, 0.1338>, <0.2448, 82.2704, -0.0104> }
					triangle { <0.149, 82.2265, 0.1338>, <0.006952, 83.09743, 0.05864>, <0.2448, 82.2704, -0.0104> }
					triangle { <0.006952, 83.09743, 0.05864>, <0.1187, 83.1422, -0.09934>, <0.2448, 82.2704, -0.0104> }
					triangle { <0.006952, 83.09743, 0.05864>, <-0.0339, 84.3907, -0.2264>, <0.1187, 83.1422, -0.09934> }
					triangle { <0.1187, 83.1422, -0.09934>, <-0.0339, 84.3907, -0.2264>, <0.294, 83.1137, -0.1882> }
					triangle { <0.2448, 82.2704, -0.0104>, <0.1187, 83.1422, -0.09934>, <0.294, 83.1137, -0.1882> }
					triangle { <0.2448, 82.2704, -0.0104>, <0.294, 83.1137, -0.1882>, <0.3907, 82.2385, -0.1014> }
					triangle { <0.2448, 82.2704, -0.0104>, <0.3907, 82.2385, -0.1014>, <0.3292, 80.6463, 0.01245> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.02812, 5.8206, 0.5725>, 0.09031 }
			cylinder { <-0.02812, 5.8206, 0.5725>, <-0.08411, 11.557, 1.7122>, 0.09031 }
			cylinder { <-0.08411, 11.557, 1.7122>, <-0.1674, 17.154, 3.408>, 0.09031 }
			cylinder { <-0.1674, 17.154, 3.408>, <-0.2772, 22.5575, 5.6435>, 0.09031 }
			cylinder { <-0.2772, 22.5575, 5.6435>, <-0.4125, 27.7157, 8.3973>, 0.09031 }
			cylinder { <-0.4125, 27.7157, 8.3973>, <-0.5719, 32.5788, 11.6428>, 0.09031 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.5719, 32.5788, 11.6428>, <-0.539, 33.9654, 12.728>, 0.09031 }
				cylinder { <-0.539, 33.9654, 12.728>, <-0.4255, 35.2633, 13.9129>, 0.09031 }
				cylinder { <-0.4255, 35.2633, 13.9129>, <-0.2327, 36.4624, 15.1882>, 0.09031 }
				cylinder { <-0.2327, 36.4624, 15.1882>, <0.03762, 37.5531, 16.5441>, 0.09031 }
				cylinder { <0.03762, 37.5531, 16.5441>, <0.3832, 38.5269, 17.9702>, 0.09031 }
				cylinder { <0.3832, 38.5269, 17.9702>, <0.8012, 39.3761, 19.4554>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.8012, 39.3761, 19.4554>, <0.8755, 39.458, 19.6052>, 0.002876 }
				cylinder { <0.8755, 39.458, 19.6052>, <0.9778, 39.5296, 19.7434>, 0.002876 }
				cylinder { <0.9778, 39.5296, 19.7434>, <1.1049, 39.5889, 19.866>, 0.002876 }
				cylinder { <1.1049, 39.5889, 19.866>, <1.2533, 39.634, 19.9692>, 0.002876 }
				cylinder { <1.2533, 39.634, 19.9692>, <1.4185, 39.6636, 20.05006>, 0.002876 }
				cylinder { <1.4185, 39.6636, 20.05006>, <1.5956, 39.6769, 20.1061>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.5956, 39.6769, 20.1061>, <3.285, 39.02968, 19.9261>, <3.3492, 39.1369, 19.9702> }
				triangle { <3.285, 39.02968, 19.9261>, <4.2569, 38.7131, 19.667>, <3.3492, 39.1369, 19.9702> }
				triangle { <4.2569, 38.7131, 19.667>, <4.3034, 38.8511, 19.6887>, <3.3492, 39.1369, 19.9702> }
				triangle { <4.2569, 38.7131, 19.667>, <7.1777, 37.9304, 18.3565>, <4.3034, 38.8511, 19.6887> }
				triangle { <4.3034, 38.8511, 19.6887>, <7.1777, 37.9304, 18.3565>, <4.327, 38.9964, 19.7125> }
				triangle { <3.3492, 39.1369, 19.9702>, <4.3034, 38.8511, 19.6887>, <4.327, 38.9964, 19.7125> }
				triangle { <3.3492, 39.1369, 19.9702>, <4.327, 38.9964, 19.7125>, <3.3653, 39.2593, 19.9944> }
				triangle { <3.3492, 39.1369, 19.9702>, <3.3653, 39.2593, 19.9944>, <1.5956, 39.6769, 20.1061> }
				triangle { <8.65, 37.5952, 17.4943>, <7.1777, 37.9304, 18.3565>, <7.11, 37.7471, 18.2633> }
				triangle { <4.327, 38.9964, 19.7125>, <7.1777, 37.9304, 18.3565>, <7.2548, 38.1844, 18.3039> }
				triangle { <4.2569, 38.7131, 19.667>, <7.11, 37.7471, 18.2633>, <7.1777, 37.9304, 18.3565> }
				triangle { <8.65, 37.5952, 17.4943>, <7.2548, 38.1844, 18.3039>, <7.1777, 37.9304, 18.3565> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.8012, 39.3761, 19.4554>, <1.1814, 40.2704, 20.924>, 0.09031 }
				cylinder { <1.1814, 40.2704, 20.924>, <1.5234, 41.2088, 22.3745>, 0.09031 }
				cylinder { <1.5234, 41.2088, 22.3745>, <1.827, 42.1902, 23.8049>, 0.09031 }
				cylinder { <1.827, 42.1902, 23.8049>, <2.0916, 43.2135, 25.2135>, 0.09031 }
				cylinder { <2.0916, 43.2135, 25.2135>, <2.3169, 44.2773, 26.5987>, 0.09031 }
				cylinder { <2.3169, 44.2773, 26.5987>, <2.5029, 45.3805, 27.9588>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.5029, 45.3805, 27.9588>, <2.4906, 45.4994, 28.1017>, 0.002876 }
				cylinder { <2.4906, 45.4994, 28.1017>, <2.4469, 45.6172, 28.2392>, 0.002876 }
				cylinder { <2.4469, 45.6172, 28.2392>, <2.373, 45.7302, 28.3675>, 0.002876 }
				cylinder { <2.373, 45.7302, 28.3675>, <2.271, 45.8352, 28.4827>, 0.002876 }
				cylinder { <2.271, 45.8352, 28.4827>, <2.144, 45.9291, 28.5814>, 0.002876 }
				cylinder { <2.144, 45.9291, 28.5814>, <1.9957, 46.00917, 28.6608>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.9957, 46.00917, 28.6608>, <1.3606, 46.8939, 30.1166>, <1.2576, 46.9526, 30.05732> }
				triangle { <1.3606, 46.8939, 30.1166>, <1.0966, 47.5279, 30.9167>, <1.2576, 46.9526, 30.05732> }
				triangle { <1.0966, 47.5279, 30.9167>, <1.01144, 47.6036, 30.8235>, <1.2576, 46.9526, 30.05732> }
				triangle { <1.0966, 47.5279, 30.9167>, <0.6562, 49.8512, 33.2122>, <1.01144, 47.6036, 30.8235> }
				triangle { <1.01144, 47.6036, 30.8235>, <0.6562, 49.8512, 33.2122>, <0.9356, 47.6669, 30.7117> }
				triangle { <1.2576, 46.9526, 30.05732>, <1.01144, 47.6036, 30.8235>, <0.9356, 47.6669, 30.7117> }
				triangle { <1.2576, 46.9526, 30.05732>, <0.9356, 47.6669, 30.7117>, <1.1927, 47.00094, 29.961> }
				triangle { <1.2576, 46.9526, 30.05732>, <1.1927, 47.00094, 29.961>, <1.9957, 46.00917, 28.6608> }
				triangle { <0.5696, 51.1788, 34.3319>, <0.6562, 49.8512, 33.2122>, <0.8217, 49.7886, 33.337> }
				triangle { <0.9356, 47.6669, 30.7117>, <0.6562, 49.8512, 33.2122>, <0.5748, 50.04517, 33.04198> }
				triangle { <1.0966, 47.5279, 30.9167>, <0.8217, 49.7886, 33.337>, <0.6562, 49.8512, 33.2122> }
				triangle { <0.5696, 51.1788, 34.3319>, <0.5748, 50.04517, 33.04198>, <0.6562, 49.8512, 33.2122> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.5029, 45.3805, 27.9588>, <2.7247, 46.4101, 29.3702>, 0.09031 }
				cylinder { <2.7247, 46.4101, 29.3702>, <2.9819, 47.363, 30.8287>, 0.09031 }
				cylinder { <2.9819, 47.363, 30.8287>, <3.2735, 48.2364, 32.3299>, 0.09031 }
				cylinder { <3.2735, 48.2364, 32.3299>, <3.5986, 49.02766, 33.8693>, 0.09031 }
				cylinder { <3.5986, 49.02766, 33.8693>, <3.9561, 49.7342, 35.4422>, 0.09031 }
				cylinder { <3.9561, 49.7342, 35.4422>, <4.3451, 50.3541, 37.04411>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.3451, 50.3541, 37.04411>, <4.4164, 50.4123, 37.206>, 0.002876 }
				cylinder { <4.4164, 50.4123, 37.206>, <4.5158, 50.4614, 37.3557>, 0.002876 }
				cylinder { <4.5158, 50.4614, 37.3557>, <4.6403, 50.5, 37.4887>, 0.002876 }
				cylinder { <4.6403, 50.5, 37.4887>, <4.7864, 50.5269, 37.6011>, 0.002876 }
				cylinder { <4.7864, 50.5269, 37.6011>, <4.9497, 50.5414, 37.6896>, 0.002876 }
				cylinder { <4.9497, 50.5414, 37.6896>, <5.1253, 50.5429, 37.7517>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.1253, 50.5429, 37.7517>, <6.8084, 49.8941, 37.5249>, <6.873, 49.9927, 37.5856> }
				triangle { <6.8084, 49.8941, 37.5249>, <7.7821, 49.5982, 37.2485>, <6.873, 49.9927, 37.5856> }
				triangle { <7.7821, 49.5982, 37.2485>, <7.8302, 49.7307, 37.291>, <6.873, 49.9927, 37.5856> }
				triangle { <7.7821, 49.5982, 37.2485>, <10.7262, 48.9519, 35.916>, <7.8302, 49.7307, 37.291> }
				triangle { <7.8302, 49.7307, 37.291>, <10.7262, 48.9519, 35.916>, <7.8554, 49.8707, 37.336> }
				triangle { <6.873, 49.9927, 37.5856>, <7.8302, 49.7307, 37.291>, <7.8554, 49.8707, 37.336> }
				triangle { <6.873, 49.9927, 37.5856>, <7.8554, 49.8707, 37.336>, <6.8905, 50.11, 37.6274> }
				triangle { <6.873, 49.9927, 37.5856>, <6.8905, 50.11, 37.6274>, <5.1253, 50.5429, 37.7517> }
				triangle { <12.217, 48.7136, 35.05336>, <10.7262, 48.9519, 35.916>, <10.6583, 48.7852, 35.7958> }
				triangle { <7.8554, 49.8707, 37.336>, <10.7262, 48.9519, 35.916>, <10.8089, 49.2092, 35.9023> }
				triangle { <7.7821, 49.5982, 37.2485>, <10.6583, 48.7852, 35.7958>, <10.7262, 48.9519, 35.916> }
				triangle { <12.217, 48.7136, 35.05336>, <10.8089, 49.2092, 35.9023>, <10.7262, 48.9519, 35.916> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.3451, 50.3541, 37.04411>, <4.6554, 51.03, 38.6404>, 0.09031 }
				cylinder { <4.6554, 51.03, 38.6404>, <4.8862, 51.7598, 40.2264>, 0.09031 }
				cylinder { <4.8862, 51.7598, 40.2264>, <5.03688, 52.5414, 41.7974>, 0.09031 }
				cylinder { <5.03688, 52.5414, 41.7974>, <5.1069, 53.3725, 43.3484>, 0.09031 }
				cylinder { <5.1069, 53.3725, 43.3484>, <5.09628, 54.2506, 44.8749>, 0.09031 }
				cylinder { <5.09628, 54.2506, 44.8749>, <5.004911, 55.1731, 46.3722>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.004911, 55.1731, 46.3722>, <4.9638, 55.2716, 46.5248>, 0.002876 }
				cylinder { <4.9638, 55.2716, 46.5248>, <4.8924, 55.3682, 46.6673>, 0.002876 }
				cylinder { <4.8924, 55.3682, 46.6673>, <4.793, 55.4599, 46.7953>, 0.002876 }
				cylinder { <4.793, 55.4599, 46.7953>, <4.6683, 55.5441, 46.9052>, 0.002876 }
				cylinder { <4.6683, 55.5441, 46.9052>, <4.5222, 55.6183, 46.9937>, 0.002876 }
				cylinder { <4.5222, 55.6183, 46.9937>, <4.3588, 55.6803, 47.05816>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.3588, 55.6803, 47.05816>, <3.4574, 56.3363, 48.4943>, <3.3607, 56.3975, 48.4273> }
				triangle { <3.4574, 56.3363, 48.4943>, <3.03618, 56.8471, 49.315>, <3.3607, 56.3975, 48.4273> }
				triangle { <3.03618, 56.8471, 49.315>, <2.961, 56.9304, 49.2196>, <3.3607, 56.3975, 48.4273> }
				triangle { <3.03618, 56.8471, 49.315>, <2.1076, 58.8265, 51.781>, <2.961, 56.9304, 49.2196> }
				triangle { <2.961, 56.9304, 49.2196>, <2.1076, 58.8265, 51.781>, <2.8987, 57.00433, 49.106> }
				triangle { <3.3607, 56.3975, 48.4273>, <2.961, 56.9304, 49.2196>, <2.8987, 57.00433, 49.106> }
				triangle { <3.3607, 56.3975, 48.4273>, <2.8987, 57.00433, 49.106>, <3.3079, 56.455, 48.3287> }
				triangle { <3.3607, 56.3975, 48.4273>, <3.3079, 56.455, 48.3287>, <4.3588, 55.6803, 47.05816> }
				triangle { <1.7684, 59.9903, 53.02766>, <2.1076, 58.8265, 51.781>, <2.2564, 58.7557, 51.9214> }
				triangle { <2.8987, 57.00433, 49.106>, <2.1076, 58.8265, 51.781>, <2.03997, 59.03717, 51.6251> }
				triangle { <3.03618, 56.8471, 49.315>, <2.2564, 58.7557, 51.9214>, <2.1076, 58.8265, 51.781> }
				triangle { <1.7684, 59.9903, 53.02766>, <2.03997, 59.03717, 51.6251>, <2.1076, 58.8265, 51.781> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <5.004911, 55.1731, 46.3722>, <4.9513, 56.05531, 47.8955>, 0.09031 }
				cylinder { <4.9513, 56.05531, 47.8955>, <4.9355, 56.8959, 49.4429>, 0.09031 }
				cylinder { <4.9355, 56.8959, 49.4429>, <4.9575, 57.694, 51.01263>, 0.09031 }
				cylinder { <4.9575, 57.694, 51.01263>, <5.01733, 58.4485, 52.6027>, 0.09031 }
				cylinder { <5.01733, 58.4485, 52.6027>, <5.1148, 59.1587, 54.2113>, 0.09031 }
				cylinder { <5.1148, 59.1587, 54.2113>, <5.2498, 59.8236, 55.8364>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.2498, 59.8236, 55.8364>, <5.291, 59.8892, 56.00583>, 0.002876 }
				cylinder { <5.291, 59.8892, 56.00583>, <5.3582, 59.9488, 56.169>, 0.002876 }
				cylinder { <5.3582, 59.9488, 56.169>, <5.4499, 60.00112, 56.3225>, 0.002876 }
				cylinder { <5.4499, 60.00112, 56.3225>, <5.5642, 60.04485, 56.4629>, 0.002876 }
				cylinder { <5.5642, 60.04485, 56.4629>, <5.6985, 60.07914, 56.5873>, 0.002876 }
				cylinder { <5.6985, 60.07914, 56.5873>, <5.8501, 60.1032, 56.6929>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.8501, 60.1032, 56.6929>, <7.5946, 59.6589, 56.9473>, <7.6293, 59.7658, 57.01768> }
				triangle { <7.5946, 59.6589, 56.9473>, <8.6334, 59.4778, 56.9505>, <7.6293, 59.7658, 57.01768> }
				triangle { <8.6334, 59.4778, 56.9505>, <8.6534, 59.616, 56.9972>, <7.6293, 59.7658, 57.01768> }
				triangle { <8.6334, 59.4778, 56.9505>, <11.8787, 59.1668, 56.4685>, <8.6534, 59.616, 56.9972> }
				triangle { <8.6534, 59.616, 56.9972>, <11.8787, 59.1668, 56.4685>, <8.65, 59.7589, 57.04001> }
				triangle { <7.6293, 59.7658, 57.01768>, <8.6534, 59.616, 56.9972>, <8.65, 59.7589, 57.04001> }
				triangle { <7.6293, 59.7658, 57.01768>, <8.65, 59.7589, 57.04001>, <7.6218, 59.8851, 57.05659> }
				triangle { <7.6293, 59.7658, 57.01768>, <7.6218, 59.8851, 57.05659>, <5.8501, 60.1032, 56.6929> }
				triangle { <13.562, 59.09389, 56.03872>, <11.8787, 59.1668, 56.4685>, <11.8642, 58.9907, 56.3434> }
				triangle { <8.65, 59.7589, 57.04001>, <11.8787, 59.1668, 56.4685>, <11.9328, 59.4319, 56.4637> }
				triangle { <8.6334, 59.4778, 56.9505>, <11.8642, 58.9907, 56.3434>, <11.8787, 59.1668, 56.4685> }
				triangle { <13.562, 59.09389, 56.03872>, <11.9328, 59.4319, 56.4637>, <11.8787, 59.1668, 56.4685> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <5.2498, 59.8236, 55.8364>, <5.2669, 60.5833, 57.4251>, 0.09031 }
				cylinder { <5.2669, 60.5833, 57.4251>, <5.166, 61.4322, 58.9647>, 0.09031 }
				cylinder { <5.166, 61.4322, 58.9647>, <4.9481, 62.3639, 60.4433>, 0.09031 }
				cylinder { <4.9481, 62.3639, 60.4433>, <4.6152, 63.3711, 61.849>, 0.09031 }
				cylinder { <4.6152, 63.3711, 61.849>, <4.17, 64.4462, 63.1708>, 0.09031 }
				cylinder { <4.17, 64.4462, 63.1708>, <3.6161, 65.581, 64.3984>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.6161, 65.581, 64.3984>, <3.5247, 65.6958, 64.5131>, 0.002876 }
				cylinder { <3.5247, 65.6958, 64.5131>, <3.404, 65.801, 64.6082>, 0.002876 }
				cylinder { <3.404, 65.801, 64.6082>, <3.2586, 65.8926, 64.6801>, 0.002876 }
				cylinder { <3.2586, 65.8926, 64.6801>, <3.09423, 65.967, 64.7261>, 0.002876 }
				cylinder { <3.09423, 65.967, 64.7261>, <2.917, 66.02147, 64.7443>, 0.002876 }
				cylinder { <2.917, 66.02147, 64.7443>, <2.7338, 66.05373, 64.7341>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.7338, 66.05373, 64.7341>, <1.269, 66.7041, 65.5925>, <1.1963, 66.7301, 65.4848> }
				triangle { <1.269, 66.7041, 65.5925>, <0.4965, 67.2279, 66.08327>, <1.1963, 66.7301, 65.4848> }
				triangle { <0.4965, 67.2279, 66.08327>, <0.4506, 67.2755, 65.9517>, <1.1963, 66.7301, 65.4848> }
				triangle { <0.4965, 67.2279, 66.08327>, <-1.5862, 69.306, 67.568>, <0.4506, 67.2755, 65.9517> }
				triangle { <0.4506, 67.2755, 65.9517>, <-1.5862, 69.306, 67.568>, <0.4247, 67.3142, 65.81> }
				triangle { <1.1963, 66.7301, 65.4848>, <0.4506, 67.2755, 65.9517>, <0.4247, 67.3142, 65.81> }
				triangle { <1.1963, 66.7301, 65.4848>, <0.4247, 67.3142, 65.81>, <1.1759, 66.7576, 65.3638> }
				triangle { <1.1963, 66.7301, 65.4848>, <1.1759, 66.7576, 65.3638>, <2.7338, 66.05373, 64.7341> }
				triangle { <-2.5457, 70.5431, 68.3246>, <-1.5862, 69.306, 67.568>, <-1.4918, 69.2944, 67.7625> }
				triangle { <0.4247, 67.3142, 65.81>, <-1.5862, 69.306, 67.568>, <-1.6226, 69.4681, 67.3544> }
				triangle { <0.4965, 67.2279, 66.08327>, <-1.4918, 69.2944, 67.7625>, <-1.5862, 69.306, 67.568> }
				triangle { <-2.5457, 70.5431, 68.3246>, <-1.6226, 69.4681, 67.3544>, <-1.5862, 69.306, 67.568> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.6161, 65.581, 64.3984>, <3.1231, 66.6197, 65.7323>, 0.09031 }
				cylinder { <3.1231, 66.6197, 65.7323>, <2.6944, 67.5539, 67.1622>, 0.09031 }
				cylinder { <2.6944, 67.5539, 67.1622>, <2.3332, 68.3764, 68.677>, 0.09031 }
				cylinder { <2.3332, 68.3764, 68.677>, <2.04216, 69.0805, 70.2647>, 0.09031 }
				cylinder { <2.04216, 69.0805, 70.2647>, <1.8231, 69.6605, 71.9131>, 0.09031 }
				cylinder { <1.8231, 69.6605, 71.9131>, <1.6777, 70.1118, 73.6091>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.6777, 70.1118, 73.6091>, <1.6987, 70.1562, 73.7888>, 0.002876 }
				cylinder { <1.6987, 70.1562, 73.7888>, <1.7552, 70.1956, 73.9619>, 0.002876 }
				cylinder { <1.7552, 70.1956, 73.9619>, <1.8452, 70.2284, 74.1216>, 0.002876 }
				cylinder { <1.8452, 70.2284, 74.1216>, <1.965, 70.2535, 74.262>, 0.002876 }
				cylinder { <1.965, 70.2535, 74.262>, <2.1102, 70.2698, 74.3776>, 0.002876 }
				cylinder { <2.1102, 70.2698, 74.3776>, <2.2751, 70.2767, 74.4639>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.2751, 70.2767, 74.4639>, <4.02763, 69.7964, 74.404>, <4.07396, 69.8908, 74.4848> }
				triangle { <4.02763, 69.7964, 74.404>, <5.05304, 69.6165, 74.2364>, <4.07396, 69.8908, 74.4848> }
				triangle { <5.05304, 69.6165, 74.2364>, <5.08225, 69.7455, 74.301>, <4.07396, 69.8908, 74.4848> }
				triangle { <5.05304, 69.6165, 74.2364>, <8.1956, 69.3838, 73.2716>, <5.08225, 69.7455, 74.301> }
				triangle { <5.08225, 69.7455, 74.301>, <8.1956, 69.3838, 73.2716>, <5.08784, 69.8798, 74.3658> }
				triangle { <4.07396, 69.8908, 74.4848>, <5.08225, 69.7455, 74.301>, <5.08784, 69.8798, 74.3658> }
				triangle { <4.07396, 69.8908, 74.4848>, <5.08784, 69.8798, 74.3658>, <4.07445, 70.0025, 74.5426> }
				triangle { <4.07396, 69.8908, 74.4848>, <4.07445, 70.0025, 74.5426>, <2.2751, 70.2767, 74.4639> }
				triangle { <9.8034, 69.3789, 72.6092>, <8.1956, 69.3838, 73.2716>, <8.1604, 69.2298, 73.1235> }
				triangle { <5.08784, 69.8798, 74.3658>, <8.1956, 69.3838, 73.2716>, <8.2545, 69.6462, 73.3012> }
				triangle { <5.05304, 69.6165, 74.2364>, <8.1604, 69.2298, 73.1235>, <8.1956, 69.3838, 73.2716> }
				triangle { <9.8034, 69.3789, 72.6092>, <8.2545, 69.6462, 73.3012>, <8.1956, 69.3838, 73.2716> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <1.6777, 70.1118, 73.6091>, <1.6497, 70.4272, 75.3415>, 0.09031 }
				cylinder { <1.6497, 70.4272, 75.3415>, <1.739, 70.6029, 77.09155>, 0.09031 }
				cylinder { <1.739, 70.6029, 77.09155>, <1.9442, 70.6369, 78.8402>, 0.09031 }
				cylinder { <1.9442, 70.6369, 78.8402>, <2.2629, 70.5283, 80.5688>, 0.09031 }
				cylinder { <2.2629, 70.5283, 80.5688>, <2.691, 70.278, 82.2587>, 0.09031 }
				cylinder { <2.691, 70.278, 82.2587>, <3.2236, 69.8885, 83.8914>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.2236, 69.8885, 83.8914>, <3.267, 69.8487, 84.06821>, 0.002876 }
				cylinder { <3.267, 69.8487, 84.06821>, <3.297, 69.8104, 84.248>, 0.002876 }
				cylinder { <3.297, 69.8104, 84.248>, <3.3136, 69.7739, 84.4299>, 0.002876 }
				cylinder { <3.3136, 69.7739, 84.4299>, <3.3166, 69.7393, 84.6129>, 0.002876 }
				cylinder { <3.3166, 69.7393, 84.6129>, <3.3062, 69.7069, 84.796>, 0.002876 }
				cylinder { <3.3062, 69.7069, 84.796>, <3.2822, 69.6769, 84.9783>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.2822, 69.6769, 84.9783>, <3.999, 68.9795, 86.4966>, <3.9294, 69.05191, 86.5831> }
				triangle { <3.999, 68.9795, 86.4966>, <4.5307, 68.6922, 87.3607>, <3.9294, 69.05191, 86.5831> }
				triangle { <4.5307, 68.6922, 87.3607>, <4.4663, 68.8035, 87.4326>, <3.9294, 69.05191, 86.5831> }
				triangle { <4.5307, 68.6922, 87.3607>, <6.545, 68.1984, 89.9219>, <4.4663, 68.8035, 87.4326> }
				triangle { <4.4663, 68.8035, 87.4326>, <6.545, 68.1984, 89.9219>, <4.3931, 68.9231, 87.4835> }
				triangle { <3.9294, 69.05191, 86.5831>, <4.4663, 68.8035, 87.4326>, <4.3931, 68.9231, 87.4835> }
				triangle { <3.9294, 69.05191, 86.5831>, <4.3931, 68.9231, 87.4835>, <3.8633, 69.1512, 86.6229> }
				triangle { <3.9294, 69.05191, 86.5831>, <3.8633, 69.1512, 86.6229>, <3.2822, 69.6769, 84.9783> }
				triangle { <7.7201, 68.08543, 91.1986>, <6.545, 68.1984, 89.9219>, <6.6877, 68.07755, 89.8129> }
				triangle { <4.3931, 68.9231, 87.4835>, <6.545, 68.1984, 89.9219>, <6.5089, 68.4418, 90.03461> }
				triangle { <4.5307, 68.6922, 87.3607>, <6.6877, 68.07755, 89.8129>, <6.545, 68.1984, 89.9219> }
				triangle { <7.7201, 68.08543, 91.1986>, <6.5089, 68.4418, 90.03461>, <6.545, 68.1984, 89.9219> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <3.2236, 69.8885, 83.8914>, <3.2885, 69.8466, 84.06097>, 0.002876 }
				cylinder { <3.2885, 69.8466, 84.06097>, <3.3617, 69.8039, 84.2268>, 0.002876 }
				cylinder { <3.3617, 69.8039, 84.2268>, <3.4432, 69.7607, 84.3887>, 0.002876 }
				cylinder { <3.4432, 69.7607, 84.3887>, <3.5326, 69.717, 84.5461>, 0.002876 }
				cylinder { <3.5326, 69.717, 84.5461>, <3.6298, 69.673, 84.6988>, 0.002876 }
				cylinder { <3.6298, 69.673, 84.6988>, <3.7346, 69.6286, 84.8463>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.7346, 69.6286, 84.8463>, <5.3286, 68.9664, 85.4171>, <5.3277, 69.02141, 85.5377> }
				triangle { <5.3286, 68.9664, 85.4171>, <6.3194, 68.7174, 85.6786>, <5.3277, 69.02141, 85.5377> }
				triangle { <6.3194, 68.7174, 85.6786>, <6.3095, 68.8124, 85.7907>, <5.3277, 69.02141, 85.5377> }
				triangle { <6.3194, 68.7174, 85.6786>, <9.5541, 68.4021, 86.2249>, <6.3095, 68.8124, 85.7907> }
				triangle { <6.3095, 68.8124, 85.7907>, <9.5541, 68.4021, 86.2249>, <6.2785, 68.9154, 85.8941> }
				triangle { <5.3277, 69.02141, 85.5377>, <6.3095, 68.8124, 85.7907>, <6.2785, 68.9154, 85.8941> }
				triangle { <5.3277, 69.02141, 85.5377>, <6.2785, 68.9154, 85.8941>, <5.2965, 69.1063, 85.6251> }
				triangle { <5.3277, 69.02141, 85.5377>, <5.2965, 69.1063, 85.6251>, <3.7346, 69.6286, 84.8463> }
				triangle { <11.2834, 68.4036, 86.4069>, <9.5541, 68.4021, 86.2249>, <9.5987, 68.3124, 86.03304> }
				triangle { <6.2785, 68.9154, 85.8941>, <9.5541, 68.4021, 86.2249>, <9.5814, 68.6294, 86.3692> }
				triangle { <6.3194, 68.7174, 85.6786>, <9.5987, 68.3124, 86.03304>, <9.5541, 68.4021, 86.2249> }
				triangle { <11.2834, 68.4036, 86.4069>, <9.5814, 68.6294, 86.3692>, <9.5541, 68.4021, 86.2249> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.007043, 5.847, -0.1433>, 0.09031 }
			cylinder { <0.007043, 5.847, -0.1433>, <0.02112, 11.6887, -0.43>, 0.09031 }
			cylinder { <0.02112, 11.6887, -0.43>, <0.04223, 17.5217, -0.8597>, 0.09031 }
			cylinder { <0.04223, 17.5217, -0.8597>, <0.07036, 23.3423, -1.4323>, 0.09031 }
			cylinder { <0.07036, 23.3423, -1.4323>, <0.1054, 29.1471, -2.1474>, 0.09031 }
			cylinder { <0.1054, 29.1471, -2.1474>, <0.1476, 34.9326, -3.004599>, 0.09031 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.1476, 34.9326, -3.004599>, <0.07824, 36.6578, -3.3516>, 0.09031 }
				cylinder { <0.07824, 36.6578, -3.3516>, <-0.07271, 38.3577, -3.7861>, 0.09031 }
				cylinder { <-0.07271, 38.3577, -3.7861>, <-0.3044, 40.02431, -4.306>, 0.09031 }
				cylinder { <-0.3044, 40.02431, -4.306>, <-0.6156, 41.6494, -4.909>, 0.09031 }
				cylinder { <-0.6156, 41.6494, -4.909>, <-1.004867, 43.2252, -5.5921>, 0.09031 }
				cylinder { <-1.004867, 43.2252, -5.5921>, <-1.4699, 44.7442, -6.3522>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-1.4699, 44.7442, -6.3522>, <-1.549, 44.8936, -6.4305>, 0.002876 }
				cylinder { <-1.549, 44.8936, -6.4305>, <-1.6555, 45.02741, -6.5043>, 0.002876 }
				cylinder { <-1.6555, 45.02741, -6.5043>, <-1.7865, 45.1416, -6.5714>, 0.002876 }
				cylinder { <-1.7865, 45.1416, -6.5714>, <-1.9379, 45.2328, -6.63>, 0.002876 }
				cylinder { <-1.9379, 45.2328, -6.63>, <-2.1055, 45.2985, -6.6782>, 0.002876 }
				cylinder { <-2.1055, 45.2985, -6.6782>, <-2.2841, 45.3365, -6.7147>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.2841, 45.3365, -6.7147>, <-3.9529, 45.9906, -7.0195>, <-3.9487, 46.08976, -6.9316> }
				triangle { <-3.9529, 45.9906, -7.0195>, <-4.9703, 46.2605, -7.08209>, <-3.9487, 46.08976, -6.9316> }
				triangle { <-4.9703, 46.2605, -7.08209>, <-4.9526, 46.3403, -6.9595>, <-3.9487, 46.08976, -6.9316> }
				triangle { <-4.9703, 46.2605, -7.08209>, <-8.2313, 46.7026, -6.9047>, <-4.9526, 46.3403, -6.9595> }
				triangle { <-4.9526, 46.3403, -6.9595>, <-8.2313, 46.7026, -6.9047>, <-4.9129, 46.4105, -6.834> }
				triangle { <-3.9487, 46.08976, -6.9316>, <-4.9526, 46.3403, -6.9595>, <-4.9129, 46.4105, -6.834> }
				triangle { <-3.9487, 46.08976, -6.9316>, <-4.9129, 46.4105, -6.834>, <-3.9103, 46.1499, -6.8281> }
				triangle { <-3.9487, 46.08976, -6.9316>, <-3.9103, 46.1499, -6.8281>, <-2.2841, 45.3365, -6.7147> }
				triangle { <-9.9538, 46.7841, -6.681>, <-8.2313, 46.7026, -6.9047>, <-8.2813, 46.5432, -7.04252> }
				triangle { <-4.9129, 46.4105, -6.834>, <-8.2313, 46.7026, -6.9047>, <-8.2369, 46.7725, -6.6433> }
				triangle { <-4.9703, 46.2605, -7.08209>, <-8.2813, 46.5432, -7.04252>, <-8.2313, 46.7026, -6.9047> }
				triangle { <-9.9538, 46.7841, -6.681>, <-8.2369, 46.7725, -6.6433>, <-8.2313, 46.7026, -6.9047> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-1.4699, 44.7442, -6.3522>, <-2.003829, 46.1784, -7.2236>, 0.09031 }
				cylinder { <-2.003829, 46.1784, -7.2236>, <-2.6019, 47.5168, -8.1995>, 0.09031 }
				cylinder { <-2.6019, 47.5168, -8.1995>, <-3.2594, 48.7488, -9.2724>, 0.09031 }
				cylinder { <-3.2594, 48.7488, -9.2724>, <-3.9709, 49.8649, -10.4342>, 0.09031 }
				cylinder { <-3.9709, 49.8649, -10.4342>, <-4.7306, 50.8561, -11.6758>, 0.09031 }
				cylinder { <-4.7306, 50.8561, -11.6758>, <-5.5323, 51.7149, -12.9877>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.5323, 51.7149, -12.9877>, <-5.6052, 51.8122, -13.1288>, 0.002876 }
				cylinder { <-5.6052, 51.8122, -13.1288>, <-5.6659, 51.9154, -13.2715>, 0.002876 }
				cylinder { <-5.6659, 51.9154, -13.2715>, <-5.714, 52.02406, -13.415>, 0.002876 }
				cylinder { <-5.714, 52.02406, -13.415>, <-5.7492, 52.1374, -13.5586>, 0.002876 }
				cylinder { <-5.7492, 52.1374, -13.5586>, <-5.7714, 52.2549, -13.7014>, 0.002876 }
				cylinder { <-5.7714, 52.2549, -13.7014>, <-5.7804, 52.3759, -13.8427>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.7804, 52.3759, -13.8427>, <-5.669, 53.7144, -15.06807>, <-5.6485, 53.8139, -14.9828> }
				triangle { <-5.669, 53.7144, -15.06807>, <-5.7691, 54.5011, -15.763>, <-5.6485, 53.8139, -14.9828> }
				triangle { <-5.7691, 54.5011, -15.763>, <-5.7791, 54.5947, -15.6498>, <-5.6485, 53.8139, -14.9828> }
				triangle { <-5.7691, 54.5011, -15.763>, <-6.6254, 56.9143, -17.8378>, <-5.7791, 54.5947, -15.6498> }
				triangle { <-5.7791, 54.5947, -15.6498>, <-6.6254, 56.9143, -17.8378>, <-5.7906, 54.6695, -15.5213> }
				triangle { <-5.6485, 53.8139, -14.9828>, <-5.7791, 54.5947, -15.6498>, <-5.7906, 54.6695, -15.5213> }
				triangle { <-5.6485, 53.8139, -14.9828>, <-5.7906, 54.6695, -15.5213>, <-5.6544, 53.8736, -14.8723> }
				triangle { <-5.6485, 53.8139, -14.9828>, <-5.6544, 53.8736, -14.8723>, <-5.7804, 52.3759, -13.8427> }
				triangle { <-7.2665, 58.1476, -18.8825>, <-6.6254, 56.9143, -17.8378>, <-6.6747, 56.7831, -18.00282> }
				triangle { <-5.7906, 54.6695, -15.5213>, <-6.6254, 56.9143, -17.8378>, <-6.7339, 57.07656, -17.6503> }
				triangle { <-5.7691, 54.5011, -15.763>, <-6.6747, 56.7831, -18.00282>, <-6.6254, 56.9143, -17.8378> }
				triangle { <-7.2665, 58.1476, -18.8825>, <-6.7339, 57.07656, -17.6503>, <-6.6254, 56.9143, -17.8378> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.5323, 51.7149, -12.9877>, <-6.3222, 52.5422, -14.3267>, 0.09031 }
				cylinder { <-6.3222, 52.5422, -14.3267>, <-7.09996, 53.3375, -15.692>, 0.09031 }
				cylinder { <-7.09996, 53.3375, -15.692>, <-7.8649, 54.1002, -17.08293>, 0.09031 }
				cylinder { <-7.8649, 54.1002, -17.08293>, <-8.6166, 54.83, -18.4984>, 0.09031 }
				cylinder { <-8.6166, 54.83, -18.4984>, <-9.3548, 55.5264, -19.9377>, 0.09031 }
				cylinder { <-9.3548, 55.5264, -19.9377>, <-10.07891, 56.189, -21.3999>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-10.07891, 56.189, -21.3999>, <-10.1778, 56.2449, -21.5474>, 0.002876 }
				cylinder { <-10.1778, 56.2449, -21.5474>, <-10.2971, 56.2856, -21.6847>, 0.002876 }
				cylinder { <-10.2971, 56.2856, -21.6847>, <-10.4339, 56.31, -21.8086>, 0.002876 }
				cylinder { <-10.4339, 56.31, -21.8086>, <-10.5855, 56.3177, -21.9166>, 0.002876 }
				cylinder { <-10.5855, 56.3177, -21.9166>, <-10.7485, 56.3085, -22.00633>, 0.002876 }
				cylinder { <-10.7485, 56.3085, -22.00633>, <-10.9194, 56.2826, -22.07576>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.9194, 56.2826, -22.07576>, <-12.5624, 56.308, -22.8537>, <-12.5894, 56.4361, -22.8326> }
				triangle { <-12.5624, 56.308, -22.8537>, <-13.5723, 56.2783, -23.1558>, <-12.5894, 56.4361, -22.8326> }
				triangle { <-13.5723, 56.2783, -23.1558>, <-13.5907, 56.4106, -23.0939>, <-12.5894, 56.4361, -22.8326> }
				triangle { <-13.5723, 56.2783, -23.1558>, <-16.8302, 56.0205, -23.5808>, <-13.5907, 56.4106, -23.0939> }
				triangle { <-13.5907, 56.4106, -23.0939>, <-16.8302, 56.0205, -23.5808>, <-13.587, 56.5413, -23.02206> }
				triangle { <-12.5894, 56.4361, -22.8326>, <-13.5907, 56.4106, -23.0939>, <-13.587, 56.5413, -23.02206> }
				triangle { <-12.5894, 56.4361, -22.8326>, <-13.587, 56.5413, -23.02206>, <-12.5811, 56.5471, -22.774> }
				triangle { <-12.5894, 56.4361, -22.8326>, <-12.5811, 56.5471, -22.774>, <-10.9194, 56.2826, -22.07576> }
				triangle { <-18.5575, 55.8232, -23.615>, <-16.8302, 56.0205, -23.5808>, <-16.8295, 55.8069, -23.6163> }
				triangle { <-13.587, 56.5413, -23.02206>, <-16.8302, 56.0205, -23.5808>, <-16.8981, 56.2096, -23.3996> }
				triangle { <-13.5723, 56.2783, -23.1558>, <-16.8295, 55.8069, -23.6163>, <-16.8302, 56.0205, -23.5808> }
				triangle { <-18.5575, 55.8232, -23.615>, <-16.8981, 56.2096, -23.3996>, <-16.8302, 56.0205, -23.5808> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-10.07891, 56.189, -21.3999>, <-10.7188, 56.9802, -22.8372>, 0.09031 }
				cylinder { <-10.7188, 56.9802, -22.8372>, <-11.2697, 57.894, -24.2382>, 0.09031 }
				cylinder { <-11.2697, 57.894, -24.2382>, <-11.7276, 58.9233, -25.5918>, 0.09031 }
				cylinder { <-11.7276, 58.9233, -25.5918>, <-12.08909, 60.06032, -26.8872>, 0.09031 }
				cylinder { <-12.08909, 60.06032, -26.8872>, <-12.3515, 61.296, -28.1142>, 0.09031 }
				cylinder { <-12.3515, 61.296, -28.1142>, <-12.513, 62.621, -29.263>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-12.513, 62.621, -29.263>, <-12.4949, 62.7672, -29.3769>, 0.002876 }
				cylinder { <-12.4949, 62.7672, -29.3769>, <-12.4422, 62.9139, -29.479>, 0.002876 }
				cylinder { <-12.4422, 62.9139, -29.479>, <-12.3571, 63.05543, -29.5652>, 0.002876 }
				cylinder { <-12.3571, 63.05543, -29.5652>, <-12.2427, 63.1862, -29.6323>, 0.002876 }
				cylinder { <-12.2427, 63.1862, -29.6323>, <-12.1036, 63.3014, -29.6776>, 0.002876 }
				cylinder { <-12.1036, 63.3014, -29.6776>, <-11.9449, 63.3966, -29.6995>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-11.9449, 63.3966, -29.6995>, <-10.3462, 64.2594, -29.6278>, <-10.3543, 64.2998, -29.5019> }
				triangle { <-10.3462, 64.2594, -29.6278>, <-9.5024, 64.8916, -29.6421>, <-10.3543, 64.2998, -29.5019> }
				triangle { <-9.5024, 64.8916, -29.6421>, <-9.5485, 64.9495, -29.5149>, <-10.3543, 64.2998, -29.5019> }
				triangle { <-9.5024, 64.8916, -29.6421>, <-7.2123, 67.2485, -29.89>, <-9.5485, 64.9495, -29.5149> }
				triangle { <-9.5485, 64.9495, -29.5149>, <-7.2123, 67.2485, -29.89>, <-9.6156, 64.9956, -29.3898> }
				triangle { <-10.3543, 64.2998, -29.5019>, <-9.5485, 64.9495, -29.5149>, <-9.6156, 64.9956, -29.3898> }
				triangle { <-10.3543, 64.2998, -29.5019>, <-9.6156, 64.9956, -29.3898>, <-10.4123, 64.3334, -29.3955> }
				triangle { <-10.3543, 64.2998, -29.5019>, <-10.4123, 64.3334, -29.3955>, <-11.9449, 63.3966, -29.6995> }
				triangle { <-6.1482, 68.6083, -30.09604>, <-7.2123, 67.2485, -29.89>, <-7.1724, 67.2165, -30.1004> }
				triangle { <-9.6156, 64.9956, -29.3898>, <-7.2123, 67.2485, -29.89>, <-7.3279, 67.4198, -29.7153> }
				triangle { <-9.5024, 64.8916, -29.6421>, <-7.1724, 67.2165, -30.1004>, <-7.2123, 67.2485, -29.89> }
				triangle { <-6.1482, 68.6083, -30.09604>, <-7.3279, 67.4198, -29.7153>, <-7.2123, 67.2485, -29.89> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-12.513, 62.621, -29.263>, <-12.7341, 63.869, -30.4856>, 0.09031 }
				cylinder { <-12.7341, 63.869, -30.4856>, <-13.01355, 65.03408, -31.7764>, 0.09031 }
				cylinder { <-13.01355, 65.03408, -31.7764>, <-13.3498, 66.1104, -33.1291>, 0.09031 }
				cylinder { <-13.3498, 66.1104, -33.1291>, <-13.7413, 67.09285, -34.5373>, 0.09031 }
				cylinder { <-13.7413, 67.09285, -34.5373>, <-14.1859, 67.9766, -35.9942>, 0.09031 }
				cylinder { <-14.1859, 67.9766, -35.9942>, <-14.6814, 68.7574, -37.4929>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-14.6814, 68.7574, -37.4929>, <-14.7618, 68.8252, -37.6467>, 0.002876 }
				cylinder { <-14.7618, 68.8252, -37.6467>, <-14.8677, 68.8763, -37.7911>, 0.002876 }
				cylinder { <-14.8677, 68.8763, -37.7911>, <-14.9961, 68.9092, -37.922>, 0.002876 }
				cylinder { <-14.9961, 68.9092, -37.922>, <-15.1432, 68.9228, -38.03549>, 0.002876 }
				cylinder { <-15.1432, 68.9228, -38.03549>, <-15.3047, 68.9168, -38.1282>, 0.002876 }
				cylinder { <-15.3047, 68.9168, -38.1282>, <-15.4757, 68.8914, -38.1974>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-15.4757, 68.8914, -38.1974>, <-17.1194, 68.9211, -38.9738>, <-17.1459, 69.04938, -38.9529> }
				triangle { <-17.1194, 68.9211, -38.9738>, <-18.1296, 68.8943, -39.2749>, <-17.1459, 69.04938, -38.9529> }
				triangle { <-18.1296, 68.8943, -39.2749>, <-18.1475, 69.02682, -39.2132>, <-17.1459, 69.04938, -38.9529> }
				triangle { <-18.1296, 68.8943, -39.2749>, <-21.3888, 68.647, -39.6964>, <-18.1475, 69.02682, -39.2132> }
				triangle { <-18.1475, 69.02682, -39.2132>, <-21.3888, 68.647, -39.6964>, <-18.1433, 69.1576, -39.1416> }
				triangle { <-17.1459, 69.04938, -38.9529>, <-18.1475, 69.02682, -39.2132>, <-18.1433, 69.1576, -39.1416> }
				triangle { <-17.1459, 69.04938, -38.9529>, <-18.1433, 69.1576, -39.1416>, <-17.1372, 69.1604, -38.8945> }
				triangle { <-17.1459, 69.04938, -38.9529>, <-17.1372, 69.1604, -38.8945>, <-15.4757, 68.8914, -38.1974> }
				triangle { <-23.1168, 68.4556, -39.7286>, <-21.3888, 68.647, -39.6964>, <-21.3889, 68.4334, -39.7316> }
				triangle { <-18.1433, 69.1576, -39.1416>, <-21.3888, 68.647, -39.6964>, <-21.4559, 68.8366, -39.5154> }
				triangle { <-18.1296, 68.8943, -39.2749>, <-21.3889, 68.4334, -39.7316>, <-21.3888, 68.647, -39.6964> }
				triangle { <-23.1168, 68.4556, -39.7286>, <-21.4559, 68.8366, -39.5154>, <-21.3888, 68.647, -39.6964> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-14.6814, 68.7574, -37.4929>, <-15.2102, 69.3963, -39.04651>, 0.09031 }
				cylinder { <-15.2102, 69.3963, -39.04651>, <-15.768, 69.8883, -40.6428>, 0.09031 }
				cylinder { <-15.768, 69.8883, -40.6428>, <-16.3501, 70.2295, -42.2695>, 0.09031 }
				cylinder { <-16.3501, 70.2295, -42.2695>, <-16.9518, 70.4171, -43.9139>, 0.09031 }
				cylinder { <-16.9518, 70.4171, -43.9139>, <-17.5679, 70.4498, -45.5633>, 0.09031 }
				cylinder { <-17.5679, 70.4498, -45.5633>, <-18.1936, 70.3272, -47.205>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-18.1936, 70.3272, -47.205>, <-18.2486, 70.321, -47.3828>, 0.002876 }
				cylinder { <-18.2486, 70.321, -47.3828>, <-18.2922, 70.3216, -47.5639>, 0.002876 }
				cylinder { <-18.2922, 70.3216, -47.5639>, <-18.324, 70.3289, -47.7473>, 0.002876 }
				cylinder { <-18.324, 70.3289, -47.7473>, <-18.344, 70.343, -47.932>, 0.002876 }
				cylinder { <-18.344, 70.343, -47.932>, <-18.352, 70.3638, -48.1169>, 0.002876 }
				cylinder { <-18.352, 70.3638, -48.1169>, <-18.348, 70.3912, -48.3011>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-18.348, 70.3912, -48.3011>, <-18.1668, 70.9103, -50.03408>, <-18.1768, 71.04102, -50.01392> }
				triangle { <-18.1668, 70.9103, -50.03408>, <-18.226, 71.1924, -51.04842>, <-18.1768, 71.04102, -50.01392> }
				triangle { <-18.226, 71.1924, -51.04842>, <-18.2706, 71.3257, -51.00471>, <-18.1768, 71.04102, -50.01392> }
				triangle { <-18.226, 71.1924, -51.04842>, <-18.9525, 71.9677, -54.168>, <-18.2706, 71.3257, -51.00471> }
				triangle { <-18.2706, 71.3257, -51.00471>, <-18.9525, 71.9677, -54.168>, <-18.3174, 71.4509, -50.9382> }
				triangle { <-18.1768, 71.04102, -50.01392>, <-18.2706, 71.3257, -51.00471>, <-18.3174, 71.4509, -50.9382> }
				triangle { <-18.1768, 71.04102, -50.01392>, <-18.3174, 71.4509, -50.9382>, <-18.2126, 71.1455, -49.9538> }
				triangle { <-18.1768, 71.04102, -50.01392>, <-18.2126, 71.1455, -49.9538>, <-18.348, 70.3912, -48.3011> }
				triangle { <-19.5246, 72.3278, -55.7701>, <-18.9525, 71.9677, -54.168>, <-18.9502, 71.7639, -54.241> }
				triangle { <-18.3174, 71.4509, -50.9382>, <-18.9525, 71.9677, -54.168>, <-19.1166, 72.1746, -54.109> }
				triangle { <-18.226, 71.1924, -51.04842>, <-18.9502, 71.7639, -54.241>, <-18.9525, 71.9677, -54.168> }
				triangle { <-19.5246, 72.3278, -55.7701>, <-19.1166, 72.1746, -54.109>, <-18.9525, 71.9677, -54.168> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-18.1936, 70.3272, -47.205>, <-18.8571, 70.02941, -48.8089>, 0.09031 }
				cylinder { <-18.8571, 70.02941, -48.8089>, <-19.5508, 69.5594, -50.3578>, 0.09031 }
				cylinder { <-19.5508, 69.5594, -50.3578>, <-20.2668, 68.9222, -51.8352>, 0.09031 }
				cylinder { <-20.2668, 68.9222, -51.8352>, <-20.9968, 68.1246, -53.2253>, 0.09031 }
				cylinder { <-20.9968, 68.1246, -53.2253>, <-21.7326, 67.175, -54.5131>, 0.09031 }
				cylinder { <-21.7326, 67.175, -54.5131>, <-22.4656, 66.08378, -55.6848>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-22.4656, 66.08378, -55.6848>, <-22.564, 65.9579, -55.7807>, 0.002876 }
				cylinder { <-22.564, 65.9579, -55.7807>, <-22.6795, 65.8266, -55.8447>, 0.002876 }
				cylinder { <-22.6795, 65.8266, -55.8447>, <-22.8077, 65.6948, -55.8746>, 0.002876 }
				cylinder { <-22.8077, 65.6948, -55.8746>, <-22.9437, 65.5675, -55.869>, 0.002876 }
				cylinder { <-22.9437, 65.5675, -55.869>, <-23.08214, 65.4498, -55.8282>, 0.002876 }
				cylinder { <-23.08214, 65.4498, -55.8282>, <-23.2177, 65.346, -55.7538>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-23.2177, 65.346, -55.7538>, <-24.6672, 64.3484, -55.2964>, <-24.7554, 64.4098, -55.374> }
				triangle { <-24.6672, 64.3484, -55.2964>, <-25.5281, 63.8791, -54.9083>, <-24.7554, 64.4098, -55.374> }
				triangle { <-25.5281, 63.8791, -54.9083>, <-25.6096, 63.9809, -54.9766>, <-24.7554, 64.4098, -55.374> }
				triangle { <-25.5281, 63.8791, -54.9083>, <-28.2014, 62.8072, -53.3067>, <-25.6096, 63.9809, -54.9766> }
				triangle { <-25.6096, 63.9809, -54.9766>, <-28.2014, 62.8072, -53.3067>, <-25.6711, 64.09521, -55.05036> }
				triangle { <-24.7554, 64.4098, -55.374>, <-25.6096, 63.9809, -54.9766>, <-25.6711, 64.09521, -55.05036> }
				triangle { <-24.7554, 64.4098, -55.374>, <-25.6711, 64.09521, -55.05036>, <-24.8033, 64.5056, -55.44> }
				triangle { <-24.7554, 64.4098, -55.374>, <-24.8033, 64.5056, -55.44>, <-23.2177, 65.346, -55.7538> }
				triangle { <-29.5804, 62.391, -52.3327>, <-28.2014, 62.8072, -53.3067>, <-28.09228, 62.6964, -53.1561> }
				triangle { <-25.6711, 64.09521, -55.05036>, <-28.2014, 62.8072, -53.3067>, <-28.3502, 63.0298, -53.3464> }
				triangle { <-25.5281, 63.8791, -54.9083>, <-28.09228, 62.6964, -53.1561>, <-28.2014, 62.8072, -53.3067> }
				triangle { <-29.5804, 62.391, -52.3327>, <-28.3502, 63.0298, -53.3464>, <-28.2014, 62.8072, -53.3067> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-22.4656, 66.08378, -55.6848>, <-23.1959, 64.9477, -56.8151>, 0.09031 }
				cylinder { <-23.1959, 64.9477, -56.8151>, <-23.9225, 63.7682, -57.9024>, 0.09031 }
				cylinder { <-23.9225, 63.7682, -57.9024>, <-24.6446, 62.5468, -58.9456>, 0.09031 }
				cylinder { <-24.6446, 62.5468, -58.9456>, <-25.3613, 61.2849, -59.9432>, 0.09031 }
				cylinder { <-25.3613, 61.2849, -59.9432>, <-26.0717, 59.984, -60.8943>, 0.09031 }
				cylinder { <-26.0717, 59.984, -60.8943>, <-26.7748, 58.6457, -61.7975>, 0.09031 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-26.7748, 58.6457, -61.7975>, <-26.8387, 58.5093, -61.9071>, 0.002876 }
				cylinder { <-26.8387, 58.5093, -61.9071>, <-26.8915, 58.3794, -62.02975>, 0.002876 }
				cylinder { <-26.8915, 58.3794, -62.02975>, <-26.9327, 58.2573, -62.1641>, 0.002876 }
				cylinder { <-26.9327, 58.2573, -62.1641>, <-26.962, 58.144, -62.3091>, 0.002876 }
				cylinder { <-26.962, 58.144, -62.3091>, <-26.9789, 58.04075, -62.4632>, 0.002876 }
				cylinder { <-26.9789, 58.04075, -62.4632>, <-26.9834, 57.9484, -62.6249>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-26.9834, 57.9484, -62.6249>, <-26.972, 57.3115, -64.3278>, <-27.02275, 57.419, -64.3865> }
				triangle { <-26.972, 57.3115, -64.3278>, <-27.1153, 56.8813, -65.2798>, <-27.02275, 57.419, -64.3865> }
				triangle { <-27.1153, 56.8813, -65.2798>, <-27.1997, 56.9967, -65.3149>, <-27.02275, 57.419, -64.3865> }
				triangle { <-27.1153, 56.8813, -65.2798>, <-28.04376, 55.3539, -68.04858>, <-27.1997, 56.9967, -65.3149> }
				triangle { <-27.1997, 56.9967, -65.3149>, <-28.04376, 55.3539, -68.04858>, <-27.2836, 57.1195, -65.327> }
				triangle { <-27.02275, 57.419, -64.3865>, <-27.1997, 56.9967, -65.3149>, <-27.2836, 57.1195, -65.327> }
				triangle { <-27.02275, 57.419, -64.3865>, <-27.2836, 57.1195, -65.327>, <-27.08972, 57.5252, -64.3937> }
				triangle { <-27.02275, 57.419, -64.3865>, <-27.08972, 57.5252, -64.3937>, <-26.9834, 57.9484, -62.6249> }
				triangle { <-28.6974, 54.4916, -69.4097>, <-28.04376, 55.3539, -68.04858>, <-27.9772, 55.1573, -67.9869> }
				triangle { <-27.2836, 57.1195, -65.327>, <-28.04376, 55.3539, -68.04858>, <-28.2647, 55.5039, -68.09174> }
				triangle { <-27.1153, 56.8813, -65.2798>, <-27.9772, 55.1573, -67.9869>, <-28.04376, 55.3539, -68.04858> }
				triangle { <-28.6974, 54.4916, -69.4097>, <-28.2647, 55.5039, -68.09174>, <-28.04376, 55.3539, -68.04858> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-26.7748, 58.6457, -61.7975>, <-26.8517, 58.5031, -61.8894>, 0.002876 }
				cylinder { <-26.8517, 58.5031, -61.8894>, <-26.9311, 58.3595, -61.9775>, 0.002876 }
				cylinder { <-26.9311, 58.3595, -61.9775>, <-27.01288, 58.2149, -62.06196>, 0.002876 }
				cylinder { <-27.01288, 58.2149, -62.06196>, <-27.09702, 58.06962, -62.1425>, 0.002876 }
				cylinder { <-27.09702, 58.06962, -62.1425>, <-27.1834, 57.9235, -62.2192>, 0.002876 }
				cylinder { <-27.1834, 57.9235, -62.2192>, <-27.2721, 57.7767, -62.2919>, 0.002876 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-27.2721, 57.7767, -62.2919>, <-28.1201, 56.4919, -63.2591>, <-28.1809, 56.5725, -63.345> }
				triangle { <-28.1201, 56.4919, -63.2591>, <-28.7334, 55.7611, -63.7084>, <-28.1809, 56.5725, -63.345> }
				triangle { <-28.7334, 55.7611, -63.7084>, <-28.812, 55.8699, -63.7688>, <-28.1809, 56.5725, -63.345> }
				triangle { <-28.7334, 55.7611, -63.7084>, <-30.9954, 53.5747, -64.6902>, <-28.812, 55.8699, -63.7688> }
				triangle { <-28.812, 55.8699, -63.7688>, <-30.9954, 53.5747, -64.6902>, <-28.8788, 55.9949, -63.8157> }
				triangle { <-28.1809, 56.5725, -63.345>, <-28.812, 55.8699, -63.7688>, <-28.8788, 55.9949, -63.8157> }
				triangle { <-28.1809, 56.5725, -63.345>, <-28.8788, 55.9949, -63.8157>, <-28.2322, 56.6802, -63.3849> }
				triangle { <-28.1809, 56.5725, -63.345>, <-28.2322, 56.6802, -63.3849>, <-27.2721, 57.7767, -62.2919> }
				triangle { <-32.2922, 52.472, -65.04502>, <-30.9954, 53.5747, -64.6902>, <-30.9285, 53.4157, -64.5594> }
				triangle { <-28.8788, 55.9949, -63.8157>, <-30.9954, 53.5747, -64.6902>, <-31.1943, 53.7541, -64.7287> }
				triangle { <-28.7334, 55.7611, -63.7084>, <-30.9285, 53.4157, -64.5594>, <-30.9954, 53.5747, -64.6902> }
				triangle { <-32.2922, 52.472, -65.04502>, <-31.1943, 53.7541, -64.7287>, <-30.9954, 53.5747, -64.6902> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.0134, 3.7035, -0.2728>, 0.05734 }
			cylinder { <0.0134, 3.7035, -0.2728>, <0.04014, 7.3769, -0.8171>, 0.05734 }
			cylinder { <0.04014, 7.3769, -0.8171>, <0.08006, 11.00035, -1.6297>, 0.05734 }
			cylinder { <0.08006, 11.00035, -1.6297>, <0.1329, 14.554, -2.7064>, 0.05734 }
			cylinder { <0.1329, 14.554, -2.7064>, <0.1985, 18.01883, -4.04138>, 0.05734 }
			cylinder { <0.1985, 18.01883, -4.04138>, <0.2764, 21.3758, -5.6272>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <0.2764, 21.3758, -5.6272>, <0.3534, 22.3969, -6.07656>, 0.05734 }
				cylinder { <0.3534, 22.3969, -6.07656>, <0.4837, 23.425, -6.4963>, 0.05734 }
				cylinder { <0.4837, 23.425, -6.4963>, <0.6668, 24.4573, -6.8851>, 0.05734 }
				cylinder { <0.6668, 24.4573, -6.8851>, <0.9022, 25.4905, -7.242>, 0.05734 }
				cylinder { <0.9022, 25.4905, -7.242>, <1.1893, 26.5216, -7.5656>, 0.05734 }
				cylinder { <1.1893, 26.5216, -7.5656>, <1.527, 27.5475, -7.8551>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.527, 27.5475, -7.8551>, <1.5425, 27.618, -7.8756>, 0.001159 }
				cylinder { <1.5425, 27.618, -7.8756>, <1.5509, 27.6896, -7.8969>, 0.001159 }
				cylinder { <1.5509, 27.6896, -7.8969>, <1.5518, 27.7614, -7.9189>, 0.001159 }
				cylinder { <1.5518, 27.7614, -7.9189>, <1.5455, 27.8328, -7.9413>, 0.001159 }
				cylinder { <1.5455, 27.8328, -7.9413>, <1.5318, 27.9031, -7.9639>, 0.001159 }
				cylinder { <1.5318, 27.9031, -7.9639>, <1.511, 27.9716, -7.9865>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.511, 27.9716, -7.9865>, <0.9142, 28.825, -8.4845>, <0.9468, 28.8885, -8.4399> }
				triangle { <0.9142, 28.825, -8.4845>, <0.4948, 29.3, -8.7006>, <0.9468, 28.8885, -8.4399> }
				triangle { <0.4948, 29.3, -8.7006>, <0.5248, 29.3547, -8.631>, <0.9468, 28.8885, -8.4399> }
				triangle { <0.4948, 29.3, -8.7006>, <-1.03042, 30.6693, -9.1218>, <0.5248, 29.3547, -8.631> }
				triangle { <0.5248, 29.3547, -8.631>, <-1.03042, 30.6693, -9.1218>, <0.5625, 29.3976, -8.5553> }
				triangle { <0.9468, 28.8885, -8.4399>, <0.5248, 29.3547, -8.631>, <0.5625, 29.3976, -8.5553> }
				triangle { <0.9468, 28.8885, -8.4399>, <0.5625, 29.3976, -8.5553>, <0.9817, 28.9231, -8.3769> }
				triangle { <0.9468, 28.8885, -8.4399>, <0.9817, 28.9231, -8.3769>, <1.511, 27.9716, -7.9865> }
				triangle { <-1.9005, 31.3366, -9.2504>, <-1.03042, 30.6693, -9.1218>, <-1.1052, 30.5826, -9.1979> }
				triangle { <0.5625, 29.3976, -8.5553>, <-1.03042, 30.6693, -9.1218>, <-1.02532, 30.7498, -8.9701> }
				triangle { <0.4948, 29.3, -8.7006>, <-1.1052, 30.5826, -9.1979>, <-1.03042, 30.6693, -9.1218> }
				triangle { <-1.9005, 31.3366, -9.2504>, <-1.02532, 30.7498, -8.9701>, <-1.03042, 30.6693, -9.1218> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <1.527, 27.5475, -7.8551>, <1.8421, 28.5632, -8.2007>, 0.05734 }
				cylinder { <1.8421, 28.5632, -8.2007>, <2.1336, 29.5655, -8.6014>, 0.05734 }
				cylinder { <2.1336, 29.5655, -8.6014>, <2.4008, 30.5516, -9.05602>, 0.05734 }
				cylinder { <2.4008, 30.5516, -9.05602>, <2.6428, 31.5183, -9.5631>, 0.05734 }
				cylinder { <2.6428, 31.5183, -9.5631>, <2.859, 32.4628, -10.1212>, 0.05734 }
				cylinder { <2.859, 32.4628, -10.1212>, <3.04878, 33.3822, -10.7286>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.04878, 33.3822, -10.7286>, <3.06872, 33.4427, -10.7685>, 0.001159 }
				cylinder { <3.06872, 33.4427, -10.7685>, <3.09565, 33.5012, -10.8071>, 0.001159 }
				cylinder { <3.09565, 33.5012, -10.8071>, <3.1293, 33.5573, -10.844>, 0.001159 }
				cylinder { <3.1293, 33.5573, -10.844>, <3.1694, 33.6103, -10.8788>, 0.001159 }
				cylinder { <3.1694, 33.6103, -10.8788>, <3.2155, 33.6599, -10.9113>, 0.001159 }
				cylinder { <3.2155, 33.6599, -10.9113>, <3.2672, 33.7054, -10.9412>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.2672, 33.7054, -10.9412>, <3.7892, 34.4518, -11.6503>, <3.8487, 34.4779, -11.5967> }
				triangle { <3.7892, 34.4518, -11.6503>, <4.02217, 34.9548, -12.02598>, <3.8487, 34.4779, -11.5967> }
				triangle { <4.02217, 34.9548, -12.02598>, <4.06738, 34.9868, -11.9506>, <3.8487, 34.4779, -11.5967> }
				triangle { <4.02217, 34.9548, -12.02598>, <4.4888, 36.7146, -13.05745>, <4.06738, 34.9868, -11.9506> }
				triangle { <4.06738, 34.9868, -11.9506>, <4.4888, 36.7146, -13.05745>, <4.1051, 35.00866, -11.8665> }
				triangle { <3.8487, 34.4779, -11.5967>, <4.06738, 34.9868, -11.9506>, <4.1051, 35.00866, -11.8665> }
				triangle { <3.8487, 34.4779, -11.5967>, <4.1051, 35.00866, -11.8665>, <3.881, 34.4929, -11.5253> }
				triangle { <3.8487, 34.4779, -11.5967>, <3.881, 34.4929, -11.5253>, <3.2672, 33.7054, -10.9412> }
				triangle { <4.6351, 37.6951, -13.5433>, <4.4888, 36.7146, -13.05745>, <4.3957, 36.6965, -13.1569> }
				triangle { <4.1051, 35.00866, -11.8665>, <4.4888, 36.7146, -13.05745>, <4.5246, 36.8086, -12.9181> }
				triangle { <4.02217, 34.9548, -12.02598>, <4.3957, 36.6965, -13.1569>, <4.4888, 36.7146, -13.05745> }
				triangle { <4.6351, 37.6951, -13.5433>, <4.5246, 36.8086, -12.9181>, <4.4888, 36.7146, -13.05745> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.04878, 33.3822, -10.7286>, <3.2385, 34.3016, -11.3361>, 0.05734 }
				cylinder { <3.2385, 34.3016, -11.3361>, <3.4282, 35.2211, -11.9435>, 0.05734 }
				cylinder { <3.4282, 35.2211, -11.9435>, <3.6179, 36.1405, -12.5509>, 0.05734 }
				cylinder { <3.6179, 36.1405, -12.5509>, <3.8076, 37.05994, -13.1584>, 0.05734 }
				cylinder { <3.8076, 37.05994, -13.1584>, <3.9973, 37.9793, -13.7658>, 0.05734 }
				cylinder { <3.9973, 37.9793, -13.7658>, <4.1871, 38.8987, -14.3733>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.1871, 38.8987, -14.3733>, <4.1906, 38.9613, -14.4146>, 0.001159 }
				cylinder { <4.1906, 38.9613, -14.4146>, <4.185, 39.02375, -14.456>, 0.001159 }
				cylinder { <4.185, 39.02375, -14.456>, <4.1703, 39.0851, -14.4967>, 0.001159 }
				cylinder { <4.1703, 39.0851, -14.4967>, <4.1466, 39.1444, -14.5362>, 0.001159 }
				cylinder { <4.1466, 39.1444, -14.5362>, <4.1144, 39.2009, -14.5738>, 0.001159 }
				cylinder { <4.1144, 39.2009, -14.5738>, <4.07422, 39.2536, -14.6089>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.07422, 39.2536, -14.6089>, <3.2183, 39.7775, -15.1796>, <3.2401, 39.8567, -15.1614> }
				triangle { <3.2183, 39.7775, -15.1796>, <2.6671, 40.07076, -15.4214>, <3.2401, 39.8567, -15.1614> }
				triangle { <2.6671, 40.07076, -15.4214>, <2.6922, 40.149, -15.3768>, <3.2401, 39.8567, -15.1614> }
				triangle { <2.6671, 40.07076, -15.4214>, <0.8044, 40.9159, -15.8623>, <2.6922, 40.149, -15.3768> }
				triangle { <2.6922, 40.149, -15.3768>, <0.8044, 40.9159, -15.8623>, <2.7284, 40.2195, -15.325> }
				triangle { <3.2401, 39.8567, -15.1614>, <2.6922, 40.149, -15.3768>, <2.7284, 40.2195, -15.325> }
				triangle { <3.2401, 39.8567, -15.1614>, <2.7284, 40.2195, -15.325>, <3.2739, 39.9151, -15.1187> }
				triangle { <3.2401, 39.8567, -15.1614>, <3.2739, 39.9151, -15.1187>, <4.07422, 39.2536, -14.6089> }
				triangle { <-0.2138, 41.3265, -15.9784>, <0.8044, 40.9159, -15.8623>, <0.7435, 40.7971, -15.895> }
				triangle { <2.7284, 40.2195, -15.325>, <0.8044, 40.9159, -15.8623>, <0.8109, 41.0386, -15.7422> }
				triangle { <2.6671, 40.07076, -15.4214>, <0.7435, 40.7971, -15.895>, <0.8044, 40.9159, -15.8623> }
				triangle { <-0.2138, 41.3265, -15.9784>, <0.8109, 41.0386, -15.7422>, <0.8044, 40.9159, -15.8623> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.1871, 38.8987, -14.3733>, <4.3498, 39.8062, -15.00595>, 0.05734 }
				cylinder { <4.3498, 39.8062, -15.00595>, <4.4853, 40.7007, -15.663>, 0.05734 }
				cylinder { <4.4853, 40.7007, -15.663>, <4.5935, 41.5812, -16.3438>, 0.05734 }
				cylinder { <4.5935, 41.5812, -16.3438>, <4.6742, 42.4465, -17.04741>, 0.05734 }
				cylinder { <4.6742, 42.4465, -17.04741>, <4.7274, 43.2956, -17.773>, 0.05734 }
				cylinder { <4.7274, 43.2956, -17.773>, <4.7529, 44.1274, -18.5197>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.7529, 44.1274, -18.5197>, <4.7638, 44.1827, -18.5694>, 0.001159 }
				cylinder { <4.7638, 44.1827, -18.5694>, <4.7837, 44.2365, -18.6179>, 0.001159 }
				cylinder { <4.7837, 44.2365, -18.6179>, <4.8123, 44.288, -18.6644>, 0.001159 }
				cylinder { <4.8123, 44.288, -18.6644>, <4.8492, 44.3365, -18.7083>, 0.001159 }
				cylinder { <4.8492, 44.3365, -18.7083>, <4.8939, 44.3812, -18.7489>, 0.001159 }
				cylinder { <4.8939, 44.3812, -18.7489>, <4.9456, 44.4215, -18.7855>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.9456, 44.4215, -18.7855>, <5.4649, 45.05221, -19.6011>, <5.5251, 45.0854, -19.5524> }
				triangle { <5.4649, 45.05221, -19.6011>, <5.6971, 45.493, -20.04836>, <5.5251, 45.0854, -19.5524> }
				triangle { <5.6971, 45.493, -20.04836>, <5.7433, 45.5353, -19.9789>, <5.5251, 45.0854, -19.5524> }
				triangle { <5.6971, 45.493, -20.04836>, <6.1643, 47.07953, -21.3302>, <5.7433, 45.5353, -19.9789> }
				triangle { <5.7433, 45.5353, -19.9789>, <6.1643, 47.07953, -21.3302>, <5.7821, 45.5688, -19.8993> }
				triangle { <5.5251, 45.0854, -19.5524>, <5.7433, 45.5353, -19.9789>, <5.7821, 45.5688, -19.8993> }
				triangle { <5.5251, 45.0854, -19.5524>, <5.7821, 45.5688, -19.8993>, <5.5582, 45.1103, -19.4842> }
				triangle { <5.5251, 45.0854, -19.5524>, <5.5582, 45.1103, -19.4842>, <4.9456, 44.4215, -18.7855> }
				triangle { <6.3119, 47.9774, -21.9555>, <6.1643, 47.07953, -21.3302>, <6.07017, 47.04784, -21.4252> }
				triangle { <5.7821, 45.5688, -19.8993>, <6.1643, 47.07953, -21.3302>, <6.2022, 47.1926, -21.2065> }
				triangle { <5.6971, 45.493, -20.04836>, <6.07017, 47.04784, -21.4252>, <6.1643, 47.07953, -21.3302> }
				triangle { <6.3119, 47.9774, -21.9555>, <6.2022, 47.1926, -21.2065>, <6.1643, 47.07953, -21.3302> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.7529, 44.1274, -18.5197>, <4.7508, 44.9411, -19.2868>, 0.05734 }
				cylinder { <4.7508, 44.9411, -19.2868>, <4.7211, 45.7355, -20.07313>, 0.05734 }
				cylinder { <4.7211, 45.7355, -20.07313>, <4.6638, 46.5097, -20.8778>, 0.05734 }
				cylinder { <4.6638, 46.5097, -20.8778>, <4.579, 47.2628, -21.7>, 0.05734 }
				cylinder { <4.579, 47.2628, -21.7>, <4.4668, 47.9939, -22.5385>, 0.05734 }
				cylinder { <4.4668, 47.9939, -22.5385>, <4.3274, 48.7021, -23.3926>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.3274, 48.7021, -23.3926>, <4.3072, 48.7482, -23.4483>, 0.001159 }
				cylinder { <4.3072, 48.7482, -23.4483>, <4.2766, 48.792, -23.5011>, 0.001159 }
				cylinder { <4.2766, 48.792, -23.5011>, <4.2363, 48.8323, -23.5499>, 0.001159 }
				cylinder { <4.2363, 48.8323, -23.5499>, <4.1871, 48.8685, -23.5936>, 0.001159 }
				cylinder { <4.1871, 48.8685, -23.5936>, <4.1301, 48.8996, -23.6314>, 0.001159 }
				cylinder { <4.1301, 48.8996, -23.6314>, <4.06665, 48.9251, -23.6623>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.06665, 48.9251, -23.6623>, <2.9707, 48.9824, -24.02041>, <2.9665, 49.06602, -24.02915> }
				triangle { <2.9707, 48.9824, -24.02041>, <2.3106, 49.02018, -24.1259>, <2.9665, 49.06602, -24.02915> }
				triangle { <2.3106, 49.02018, -24.1259>, <2.3161, 49.1123, -24.1113>, <2.9665, 49.06602, -24.02915> }
				triangle { <2.3106, 49.02018, -24.1259>, <0.2215, 49.1378, -24.1046>, <2.3161, 49.1123, -24.1113> }
				triangle { <2.3161, 49.1123, -24.1113>, <0.2215, 49.1378, -24.1046>, <2.336, 49.2029, -24.09211> }
				triangle { <2.9665, 49.06602, -24.02915>, <2.3161, 49.1123, -24.1113>, <2.336, 49.2029, -24.09211> }
				triangle { <2.9665, 49.06602, -24.02915>, <2.336, 49.2029, -24.09211>, <2.9864, 49.1419, -24.01463> }
				triangle { <2.9665, 49.06602, -24.02915>, <2.9864, 49.1419, -24.01463>, <4.06665, 48.9251, -23.6623> }
				triangle { <-0.8723, 49.1962, -23.9669>, <0.2215, 49.1378, -24.1046>, <0.201, 49.00311, -24.08716> }
				triangle { <2.336, 49.2029, -24.09211>, <0.2215, 49.1378, -24.1046>, <0.2124, 49.2898, -24.02496> }
				triangle { <2.3106, 49.02018, -24.1259>, <0.201, 49.00311, -24.08716>, <0.2215, 49.1378, -24.1046> }
				triangle { <-0.8723, 49.1962, -23.9669>, <0.2124, 49.2898, -24.02496>, <0.2215, 49.1378, -24.1046> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.3274, 48.7021, -23.3926>, <4.2152, 49.4123, -24.2489>, 0.05734 }
				cylinder { <4.2152, 49.4123, -24.2489>, <4.1304, 50.124, -25.1071>, 0.05734 }
				cylinder { <4.1304, 50.124, -25.1071>, <4.073, 50.837, -25.9666>, 0.05734 }
				cylinder { <4.073, 50.837, -25.9666>, <4.04298, 51.5506, -26.8269>, 0.05734 }
				cylinder { <4.04298, 51.5506, -26.8269>, <4.0404, 52.2646, -27.6874>, 0.05734 }
				cylinder { <4.0404, 52.2646, -27.6874>, <4.06526, 52.9785, -28.5477>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.06526, 52.9785, -28.5477>, <4.07793, 53.02579, -28.6047>, 0.001159 }
				cylinder { <4.07793, 53.02579, -28.6047>, <4.1013, 53.0714, -28.6595>, 0.001159 }
				cylinder { <4.1013, 53.0714, -28.6595>, <4.1349, 53.1143, -28.7112>, 0.001159 }
				cylinder { <4.1349, 53.1143, -28.7112>, <4.178, 53.1536, -28.7584>, 0.001159 }
				cylinder { <4.178, 53.1536, -28.7584>, <4.2296, 53.1885, -28.8003>, 0.001159 }
				cylinder { <4.2296, 53.1885, -28.8003>, <4.2887, 53.2182, -28.8359>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.2887, 53.2182, -28.8359>, <4.9524, 53.6712, -29.6647>, <5.01029, 53.706, -29.6144> }
				triangle { <4.9524, 53.6712, -29.6647>, <5.274, 54.01771, -30.1388>, <5.01029, 53.706, -29.6144> }
				triangle { <5.274, 54.01771, -30.1388>, <5.3168, 54.06588, -30.07112>, <5.01029, 53.706, -29.6144> }
				triangle { <5.274, 54.01771, -30.1388>, <6.03295, 55.3459, -31.5666>, <5.3168, 54.06588, -30.07112> }
				triangle { <5.3168, 54.06588, -30.07112>, <6.03295, 55.3459, -31.5666>, <5.3504, 54.1076, -29.9929> }
				triangle { <5.01029, 53.706, -29.6144>, <5.3168, 54.06588, -30.07112>, <5.3504, 54.1076, -29.9929> }
				triangle { <5.01029, 53.706, -29.6144>, <5.3504, 54.1076, -29.9929>, <5.03852, 53.7381, -29.547> }
				triangle { <5.01029, 53.706, -29.6144>, <5.03852, 53.7381, -29.547>, <4.2887, 53.2182, -28.8359> }
				triangle { <6.3363, 56.1228, -32.2899>, <6.03295, 55.3459, -31.5666>, <5.9464, 55.3085, -31.6666> }
				triangle { <5.3504, 54.1076, -29.9929>, <6.03295, 55.3459, -31.5666>, <6.06906, 55.4727, -31.4564> }
				triangle { <5.274, 54.01771, -30.1388>, <5.9464, 55.3085, -31.6666>, <6.03295, 55.3459, -31.5666> }
				triangle { <6.3363, 56.1228, -32.2899>, <6.06906, 55.4727, -31.4564>, <6.03295, 55.3459, -31.5666> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.06526, 52.9785, -28.5477>, <4.1174, 53.7127, -29.3895>, 0.05734 }
				cylinder { <4.1174, 53.7127, -29.3895>, <4.1969, 54.4663, -30.2116>, 0.05734 }
				cylinder { <4.1969, 54.4663, -30.2116>, <4.3036, 55.2385, -31.01329>, 0.05734 }
				cylinder { <4.3036, 55.2385, -31.01329>, <4.4373, 56.02847, -31.7933>, 0.05734 }
				cylinder { <4.4373, 56.02847, -31.7933>, <4.5978, 56.835, -32.5509>, 0.05734 }
				cylinder { <4.5978, 56.835, -32.5509>, <4.7851, 57.6573, -33.2851>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <4.7851, 57.6573, -33.2851>, <4.7903, 57.7131, -33.3351>, 0.001159 }
				cylinder { <4.7903, 57.7131, -33.3351>, <4.7882, 57.7689, -33.3853>, 0.001159 }
				cylinder { <4.7882, 57.7689, -33.3853>, <4.7788, 57.8242, -33.4352>, 0.001159 }
				cylinder { <4.7788, 57.8242, -33.4352>, <4.7621, 57.8785, -33.4844>, 0.001159 }
				cylinder { <4.7621, 57.8785, -33.4844>, <4.7383, 57.9312, -33.5323>, 0.001159 }
				cylinder { <4.7383, 57.9312, -33.5323>, <4.7076, 57.9818, -33.5785>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <4.7076, 57.9818, -33.5785>, <3.9718, 58.4967, -34.3038>, <4.000741, 58.5752, -34.2946> }
				triangle { <3.9718, 58.4967, -34.3038>, <3.4816, 58.8037, -34.641>, <4.000741, 58.5752, -34.2946> }
				triangle { <3.4816, 58.8037, -34.641>, <3.5112, 58.8848, -34.6053>, <4.000741, 58.5752, -34.2946> }
				triangle { <3.4816, 58.8037, -34.641>, <1.7743, 59.7539, -35.3898>, <3.5112, 58.8848, -34.6053> }
				triangle { <3.5112, 58.8848, -34.6053>, <1.7743, 59.7539, -35.3898>, <3.5504, 58.9584, -34.5603> }
				triangle { <4.000741, 58.5752, -34.2946>, <3.5112, 58.8848, -34.6053>, <3.5504, 58.9584, -34.5603> }
				triangle { <4.000741, 58.5752, -34.2946>, <3.5504, 58.9584, -34.5603>, <4.03691, 58.6357, -34.2571> }
				triangle { <4.000741, 58.5752, -34.2946>, <4.03691, 58.6357, -34.2571>, <4.7076, 57.9818, -33.5785> }
				triangle { <0.8238, 60.2415, -35.669>, <1.7743, 59.7539, -35.3898>, <1.7035, 59.6382, -35.4119> }
				triangle { <3.5504, 58.9584, -34.5603>, <1.7743, 59.7539, -35.3898>, <1.7838, 59.8919, -35.2879> }
				triangle { <3.4816, 58.8037, -34.641>, <1.7035, 59.6382, -35.4119>, <1.7743, 59.7539, -35.3898> }
				triangle { <0.8238, 60.2415, -35.669>, <1.7838, 59.8919, -35.2879>, <1.7743, 59.7539, -35.3898> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <4.7851, 57.6573, -33.2851>, <4.9728, 58.461, -34.03957>, 0.05734 }
				cylinder { <4.9728, 58.461, -34.03957>, <5.1608, 59.2457, -34.8136>, 0.05734 }
				cylinder { <5.1608, 59.2457, -34.8136>, <5.349, 60.01084, -35.607>, 0.05734 }
				cylinder { <5.349, 60.01084, -35.607>, <5.5373, 60.7559, -36.4192>, 0.05734 }
				cylinder { <5.5373, 60.7559, -36.4192>, <5.7256, 61.4806, -37.2497>, 0.05734 }
				cylinder { <5.7256, 61.4806, -37.2497>, <5.9138, 62.1843, -38.09805>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <5.9138, 62.1843, -38.09805>, <5.9354, 62.2302, -38.1534>, 0.001159 }
				cylinder { <5.9354, 62.2302, -38.1534>, <5.9656, 62.274, -38.2064>, 0.001159 }
				cylinder { <5.9656, 62.274, -38.2064>, <6.004078, 62.3151, -38.2561>, 0.001159 }
				cylinder { <6.004078, 62.3151, -38.2561>, <6.05011, 62.3528, -38.3019>, 0.001159 }
				cylinder { <6.05011, 62.3528, -38.3019>, <6.103, 62.3865, -38.3431>, 0.001159 }
				cylinder { <6.103, 62.3865, -38.3431>, <6.1621, 62.4159, -38.379>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <6.1621, 62.4159, -38.379>, <6.8237, 62.8654, -39.2113>, <6.8821, 62.8998, -39.1614> }
				triangle { <6.8237, 62.8654, -39.2113>, <7.1448, 63.2103, -39.687>, <6.8821, 62.8998, -39.1614> }
				triangle { <7.1448, 63.2103, -39.687>, <7.1883, 63.2581, -39.6194>, <6.8821, 62.8998, -39.1614> }
				triangle { <7.1448, 63.2103, -39.687>, <7.9039, 64.5351, -41.1178>, <7.1883, 63.2581, -39.6194> }
				triangle { <7.1883, 63.2581, -39.6194>, <7.9039, 64.5351, -41.1178>, <7.2226, 63.2995, -39.5414> }
				triangle { <6.8821, 62.8998, -39.1614>, <7.1883, 63.2581, -39.6194>, <7.2226, 63.2995, -39.5414> }
				triangle { <6.8821, 62.8998, -39.1614>, <7.2226, 63.2995, -39.5414>, <6.911, 62.9316, -39.09406> }
				triangle { <6.8821, 62.8998, -39.1614>, <6.911, 62.9316, -39.09406>, <6.1621, 62.4159, -38.379> }
				triangle { <8.208, 65.3108, -41.8421>, <7.9039, 64.5351, -41.1178>, <7.8165, 64.4983, -41.2173> }
				triangle { <7.2226, 63.2995, -39.5414>, <7.9039, 64.5351, -41.1178>, <7.9415, 64.6615, -41.00774> }
				triangle { <7.1448, 63.2103, -39.687>, <7.8165, 64.4983, -41.2173>, <7.9039, 64.5351, -41.1178> }
				triangle { <8.208, 65.3108, -41.8421>, <7.9415, 64.6615, -41.00774>, <7.9039, 64.5351, -41.1178> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <5.9138, 62.1843, -38.09805>, <5.9227, 62.232, -38.1554>, 0.001159 }
				cylinder { <5.9227, 62.232, -38.1554>, <5.9281, 62.2798, -38.213>, 0.001159 }
				cylinder { <5.9281, 62.2798, -38.213>, <5.9297, 62.3278, -38.2707>, 0.001159 }
				cylinder { <5.9297, 62.3278, -38.2707>, <5.9277, 62.3758, -38.3284>, 0.001159 }
				cylinder { <5.9277, 62.3758, -38.3284>, <5.9219, 62.4237, -38.386>, 0.001159 }
				cylinder { <5.9219, 62.4237, -38.386>, <5.9125, 62.4714, -38.4432>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <5.9125, 62.4714, -38.4432>, <5.4567, 63.00218, -39.3614>, <5.501, 63.07355, -39.3558> }
				triangle { <5.4567, 63.00218, -39.3614>, <5.1188, 63.3445, -39.8271>, <5.501, 63.07355, -39.3558> }
				triangle { <5.1188, 63.3445, -39.8271>, <5.1598, 63.4225, -39.7959>, <5.501, 63.07355, -39.3558> }
				triangle { <5.1188, 63.3445, -39.8271>, <3.8392, 64.4907, -41.02194>, <5.1598, 63.4225, -39.7959> }
				triangle { <5.1598, 63.4225, -39.7959>, <3.8392, 64.4907, -41.02194>, <5.2064, 63.4928, -39.7528> }
				triangle { <5.501, 63.07355, -39.3558>, <5.1598, 63.4225, -39.7959>, <5.2064, 63.4928, -39.7528> }
				triangle { <5.501, 63.07355, -39.3558>, <5.2064, 63.4928, -39.7528>, <5.543, 63.1306, -39.319> }
				triangle { <5.501, 63.07355, -39.3558>, <5.543, 63.1306, -39.319>, <5.9125, 62.4714, -38.4432> }
				triangle { <3.093, 65.1111, -41.5484>, <3.8392, 64.4907, -41.02194>, <3.7485, 64.3899, -41.04443> }
				triangle { <5.2064, 63.4928, -39.7528>, <3.8392, 64.4907, -41.02194>, <3.8624, 64.6384, -40.9372> }
				triangle { <5.1188, 63.3445, -39.8271>, <3.7485, 64.3899, -41.04443>, <3.8392, 64.4907, -41.02194> }
				triangle { <3.093, 65.1111, -41.5484>, <3.8624, 64.6384, -40.9372>, <3.8392, 64.4907, -41.02194> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.01786, 3.6957, 0.3635>, 0.05734 }
			cylinder { <-0.01786, 3.6957, 0.3635>, <-0.0534, 7.3379, 1.08717>, 0.05734 }
			cylinder { <-0.0534, 7.3379, 1.08717>, <-0.1063, 10.8916, 2.1638>, 0.05734 }
			cylinder { <-0.1063, 10.8916, 2.1638>, <-0.176, 14.3226, 3.5833>, 0.05734 }
			cylinder { <-0.176, 14.3226, 3.5833>, <-0.2619, 17.5977, 5.3317>, 0.05734 }
			cylinder { <-0.2619, 17.5977, 5.3317>, <-0.3631, 20.6854, 7.3924>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.3631, 20.6854, 7.3924>, <-0.3422, 21.5658, 8.08151>, 0.05734 }
				cylinder { <-0.3422, 21.5658, 8.08151>, <-0.2702, 22.3899, 8.8338>, 0.05734 }
				cylinder { <-0.2702, 22.3899, 8.8338>, <-0.1477, 23.1513, 9.6435>, 0.05734 }
				cylinder { <-0.1477, 23.1513, 9.6435>, <0.02389, 23.8438, 10.5044>, 0.05734 }
				cylinder { <0.02389, 23.8438, 10.5044>, <0.2433, 24.4621, 11.4099>, 0.05734 }
				cylinder { <0.2433, 24.4621, 11.4099>, <0.5087, 25.0013, 12.3529>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.5087, 25.0013, 12.3529>, <0.5403, 25.03379, 12.4127>, 0.001159 }
				cylinder { <0.5403, 25.03379, 12.4127>, <0.5845, 25.06133, 12.4668>, 0.001159 }
				cylinder { <0.5845, 25.06133, 12.4668>, <0.6397, 25.08285, 12.513>, 0.001159 }
				cylinder { <0.6397, 25.08285, 12.513>, <0.7036, 25.09752, 12.5496>, 0.001159 }
				cylinder { <0.7036, 25.09752, 12.5496>, <0.7738, 25.1047, 12.5752>, 0.001159 }
				cylinder { <0.7738, 25.1047, 12.5752>, <0.8477, 25.1043, 12.5887>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.8477, 25.1043, 12.5887>, <1.9033, 24.658, 12.4511>, <1.947, 24.7268, 12.4722> }
				triangle { <1.9033, 24.658, 12.4511>, <2.5064, 24.4297, 12.271>, <1.947, 24.7268, 12.4722> }
				triangle { <2.5064, 24.4297, 12.271>, <2.5387, 24.5172, 12.2771>, <1.947, 24.7268, 12.4722> }
				triangle { <2.5064, 24.4297, 12.271>, <4.3042, 23.827, 11.3859>, <2.5387, 24.5172, 12.2771> }
				triangle { <2.5387, 24.5172, 12.2771>, <4.3042, 23.827, 11.3859>, <2.5565, 24.6099, 12.2849> }
				triangle { <1.947, 24.7268, 12.4722>, <2.5387, 24.5172, 12.2771>, <2.5565, 24.6099, 12.2849> }
				triangle { <1.947, 24.7268, 12.4722>, <2.5565, 24.6099, 12.2849>, <1.9599, 24.805, 12.4815> }
				triangle { <1.947, 24.7268, 12.4722>, <1.9599, 24.805, 12.4815>, <0.8477, 25.1043, 12.5887> }
				triangle { <5.2048, 23.5518, 10.8095>, <4.3042, 23.827, 11.3859>, <4.2556, 23.7079, 11.3373> }
				triangle { <2.5565, 24.6099, 12.2849>, <4.3042, 23.827, 11.3859>, <4.3551, 23.9842, 11.3388> }
				triangle { <2.5064, 24.4297, 12.271>, <4.2556, 23.7079, 11.3373>, <4.3042, 23.827, 11.3859> }
				triangle { <5.2048, 23.5518, 10.8095>, <4.3551, 23.9842, 11.3388>, <4.3042, 23.827, 11.3859> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.5087, 25.0013, 12.3529>, <0.8437, 25.4505, 13.3205>, 0.05734 }
				cylinder { <0.8437, 25.4505, 13.3205>, <1.2446, 25.805, 14.3023>, 0.05734 }
				cylinder { <1.2446, 25.805, 14.3023>, <1.7066, 26.06062, 15.2879>, 0.05734 }
				cylinder { <1.7066, 26.06062, 15.2879>, <2.2247, 26.2144, 16.2668>, 0.05734 }
				cylinder { <2.2247, 26.2144, 16.2668>, <2.793, 26.2647, 17.2285>, 0.05734 }
				cylinder { <2.793, 26.2647, 17.2285>, <3.405, 26.2108, 18.1628>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <3.405, 26.2108, 18.1628>, <3.4416, 26.2089, 18.2283>, 0.001159 }
				cylinder { <3.4416, 26.2089, 18.2283>, <3.4736, 26.2089, 18.2962>, 0.001159 }
				cylinder { <3.4736, 26.2089, 18.2962>, <3.5008, 26.2106, 18.3662>, 0.001159 }
				cylinder { <3.5008, 26.2106, 18.3662>, <3.5231, 26.2141, 18.4378>, 0.001159 }
				cylinder { <3.5231, 26.2141, 18.4378>, <3.5402, 26.2194, 18.5107>, 0.001159 }
				cylinder { <3.5402, 26.2194, 18.5107>, <3.5522, 26.2264, 18.5845>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <3.5522, 26.2264, 18.5845>, <4.1336, 25.9701, 19.5483>, <4.1118, 26.03837, 19.5926> }
				triangle { <4.1336, 25.9701, 19.5483>, <4.5517, 25.8709, 20.06182>, <4.1118, 26.03837, 19.5926> }
				triangle { <4.5517, 25.8709, 20.06182>, <4.5352, 25.9588, 20.08901>, <4.1118, 26.03837, 19.5926> }
				triangle { <4.5517, 25.8709, 20.06182>, <6.09674, 25.7237, 21.4653>, <4.5352, 25.9588, 20.08901> }
				triangle { <4.5352, 25.9588, 20.08901>, <6.09674, 25.7237, 21.4653>, <4.5112, 26.0494, 20.103> }
				triangle { <4.1118, 26.03837, 19.5926>, <4.5352, 25.9588, 20.08901>, <4.5112, 26.0494, 20.103> }
				triangle { <4.1118, 26.03837, 19.5926>, <4.5112, 26.0494, 20.103>, <4.08831, 26.1139, 19.6033> }
				triangle { <4.1118, 26.03837, 19.5926>, <4.08831, 26.1139, 19.6033>, <3.5522, 26.2264, 18.5845> }
				triangle { <6.9854, 25.7039, 22.1201>, <6.09674, 25.7237, 21.4653>, <6.1543, 25.6121, 21.4096> }
				triangle { <4.5112, 26.0494, 20.103>, <6.09674, 25.7237, 21.4653>, <6.1178, 25.8929, 21.4873> }
				triangle { <4.5517, 25.8709, 20.06182>, <6.1543, 25.6121, 21.4096>, <6.09674, 25.7237, 21.4653> }
				triangle { <6.9854, 25.7039, 22.1201>, <6.1178, 25.8929, 21.4873>, <6.09674, 25.7237, 21.4653> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <3.405, 26.2108, 18.1628>, <4.008764, 26.1309, 19.1005>, 0.05734 }
				cylinder { <4.008764, 26.1309, 19.1005>, <4.6039, 26.02517, 20.04125>, 0.05734 }
				cylinder { <4.6039, 26.02517, 20.04125>, <5.1901, 25.8935, 20.9842>, 0.05734 }
				cylinder { <5.1901, 25.8935, 20.9842>, <5.767, 25.7361, 21.9291>, 0.05734 }
				cylinder { <5.767, 25.7361, 21.9291>, <6.3343, 25.5531, 22.8751>, 0.05734 }
				cylinder { <6.3343, 25.5531, 22.8751>, <6.8916, 25.3445, 23.8218>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <6.8916, 25.3445, 23.8218>, <6.9373, 25.3271, 23.8788>, 0.001159 }
				cylinder { <6.9373, 25.3271, 23.8788>, <6.9902, 25.3067, 23.9281>, 0.001159 }
				cylinder { <6.9902, 25.3067, 23.9281>, <7.04921, 25.2838, 23.9685>, 0.001159 }
				cylinder { <7.04921, 25.2838, 23.9685>, <7.113, 25.2588, 23.9991>, 0.001159 }
				cylinder { <7.113, 25.2588, 23.9991>, <7.1803, 25.2323, 24.01946>, 0.001159 }
				cylinder { <7.1803, 25.2323, 24.01946>, <7.2495, 25.2048, 24.02891>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <7.2495, 25.2048, 24.02891>, <8.1678, 24.6134, 23.6553>, <8.2245, 24.6476, 23.7072> }
				triangle { <8.1678, 24.6134, 23.6553>, <8.7111, 24.3477, 23.3681>, <8.2245, 24.6476, 23.7072> }
				triangle { <8.7111, 24.3477, 23.3681>, <8.7633, 24.4079, 23.417>, <8.2245, 24.6476, 23.7072> }
				triangle { <8.7111, 24.3477, 23.3681>, <10.3914, 23.7921, 22.2516>, <8.7633, 24.4079, 23.417> }
				triangle { <8.7633, 24.4079, 23.417>, <10.3914, 23.7921, 22.2516>, <8.8028, 24.4755, 23.4703> }
				triangle { <8.2245, 24.6476, 23.7072>, <8.7633, 24.4079, 23.417>, <8.8028, 24.4755, 23.4703> }
				triangle { <8.2245, 24.6476, 23.7072>, <8.8028, 24.4755, 23.4703>, <8.2554, 24.7039, 23.7547> }
				triangle { <8.2245, 24.6476, 23.7072>, <8.2554, 24.7039, 23.7547>, <7.2495, 25.2048, 24.02891> }
				triangle { <11.2556, 23.6017, 21.5915>, <10.3914, 23.7921, 22.2516>, <10.3206, 23.7316, 22.1506> }
				triangle { <8.8028, 24.4755, 23.4703>, <10.3914, 23.7921, 22.2516>, <10.4854, 23.9309, 22.2896> }
				triangle { <8.7111, 24.3477, 23.3681>, <10.3206, 23.7316, 22.1506>, <10.3914, 23.7921, 22.2516> }
				triangle { <11.2556, 23.6017, 21.5915>, <10.4854, 23.9309, 22.2896>, <10.3914, 23.7921, 22.2516> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <6.8916, 25.3445, 23.8218>, <7.4386, 25.1105, 24.7686>, 0.05734 }
				cylinder { <7.4386, 25.1105, 24.7686>, <7.9749, 24.8512, 25.7148>, 0.05734 }
				cylinder { <7.9749, 24.8512, 25.7148>, <8.5002, 24.5667, 26.6601>, 0.05734 }
				cylinder { <8.5002, 24.5667, 26.6601>, <9.01426, 24.2574, 27.6036>, 0.05734 }
				cylinder { <9.01426, 24.2574, 27.6036>, <9.5166, 23.9232, 28.545>, 0.05734 }
				cylinder { <9.5166, 23.9232, 28.545>, <10.00721, 23.5645, 29.4837>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <10.00721, 23.5645, 29.4837>, <10.03269, 23.5435, 29.5511>, 0.001159 }
				cylinder { <10.03269, 23.5435, 29.5511>, <10.05035, 23.526, 29.622>, 0.001159 }
				cylinder { <10.05035, 23.526, 29.622>, <10.05989, 23.5121, 29.6951>, 0.001159 }
				cylinder { <10.05989, 23.5121, 29.6951>, <10.0612, 23.5022, 29.7696>, 0.001159 }
				cylinder { <10.0612, 23.5022, 29.7696>, <10.05423, 23.4964, 29.8441>, 0.001159 }
				cylinder { <10.05423, 23.4964, 29.8441>, <10.0391, 23.4946, 29.9176>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <10.0391, 23.4946, 29.9176>, <10.1895, 23.05922, 30.9761>, <10.1618, 23.1259, 31.01933> }
				triangle { <10.1895, 23.05922, 30.9761>, <10.3743, 22.8455, 31.5831>, <10.1618, 23.1259, 31.01933> }
				triangle { <10.3743, 22.8455, 31.5831>, <10.3602, 22.9321, 31.6152>, <10.1618, 23.1259, 31.01933> }
				triangle { <10.3743, 22.8455, 31.5831>, <11.2657, 22.3151, 33.4005>, <10.3602, 22.9321, 31.6152> }
				triangle { <10.3602, 22.9321, 31.6152>, <11.2657, 22.3151, 33.4005>, <10.3442, 23.02388, 31.6329> }
				triangle { <10.1618, 23.1259, 31.01933>, <10.3602, 22.9321, 31.6152>, <10.3442, 23.02388, 31.6329> }
				triangle { <10.1618, 23.1259, 31.01933>, <10.3442, 23.02388, 31.6329>, <10.1456, 23.2031, 31.03196> }
				triangle { <10.1618, 23.1259, 31.01933>, <10.1456, 23.2031, 31.03196>, <10.0391, 23.4946, 29.9176> }
				triangle { <11.8424, 22.08735, 34.3139>, <11.2657, 22.3151, 33.4005>, <11.3252, 22.2007, 33.3529> }
				triangle { <10.3442, 23.02388, 31.6329>, <11.2657, 22.3151, 33.4005>, <11.2983, 22.4756, 33.4525> }
				triangle { <10.3743, 22.8455, 31.5831>, <11.3252, 22.2007, 33.3529>, <11.2657, 22.3151, 33.4005> }
				triangle { <11.8424, 22.08735, 34.3139>, <11.2983, 22.4756, 33.4525>, <11.2657, 22.3151, 33.4005> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <10.00721, 23.5645, 29.4837>, <10.5154, 23.1401, 30.3848>, 0.05734 }
				cylinder { <10.5154, 23.1401, 30.3848>, <11.03874, 22.6523, 31.244>, 0.05734 }
				cylinder { <11.03874, 22.6523, 31.244>, <11.5746, 22.1031, 32.05745>, 0.05734 }
				cylinder { <11.5746, 22.1031, 32.05745>, <12.1204, 21.4953, 32.8209>, 0.05734 }
				cylinder { <12.1204, 21.4953, 32.8209>, <12.6733, 20.8317, 33.531>, 0.05734 }
				cylinder { <12.6733, 20.8317, 33.531>, <13.2307, 20.1155, 34.1842>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <13.2307, 20.1155, 34.1842>, <13.2758, 20.06582, 34.2179>, 0.001159 }
				cylinder { <13.2758, 20.06582, 34.2179>, <13.3273, 20.01592, 34.2403>, 0.001159 }
				cylinder { <13.3273, 20.01592, 34.2403>, <13.3835, 19.9673, 34.2508>, 0.001159 }
				cylinder { <13.3835, 19.9673, 34.2508>, <13.443, 19.9214, 34.2492>, 0.001159 }
				cylinder { <13.443, 19.9214, 34.2492>, <13.5038, 19.8796, 34.2354>, 0.001159 }
				cylinder { <13.5038, 19.8796, 34.2354>, <13.5643, 19.8431, 34.2099>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <13.5643, 19.8431, 34.2099>, <14.213, 19.4286, 33.3498>, <14.2855, 19.4234, 33.3923> }
				triangle { <14.213, 19.4286, 33.3498>, <14.6057, 19.289, 32.8257>, <14.2855, 19.4234, 33.3923> }
				triangle { <14.6057, 19.289, 32.8257>, <14.6798, 19.308, 32.8794>, <14.2855, 19.4234, 33.3923> }
				triangle { <14.6057, 19.289, 32.8257>, <15.8439, 19.2013, 31.1412>, <14.6798, 19.308, 32.8794> }
				triangle { <14.6798, 19.308, 32.8794>, <15.8439, 19.2013, 31.1412>, <14.7447, 19.3324, 32.944> }
				triangle { <14.2855, 19.4234, 33.3923>, <14.6798, 19.308, 32.8794>, <14.7447, 19.3324, 32.944> }
				triangle { <14.2855, 19.4234, 33.3923>, <14.7447, 19.3324, 32.944>, <14.3381, 19.4424, 33.4493> }
				triangle { <14.2855, 19.4234, 33.3923>, <14.3381, 19.4424, 33.4493>, <13.5643, 19.8431, 34.2099> }
				triangle { <16.4885, 19.2815, 30.2484>, <15.8439, 19.2013, 31.1412>, <15.742, 19.2116, 31.04951> }
				triangle { <14.7447, 19.3324, 32.944>, <15.8439, 19.2013, 31.1412>, <15.9755, 19.2872, 31.2106> }
				triangle { <14.6057, 19.289, 32.8257>, <15.742, 19.2116, 31.04951>, <15.8439, 19.2013, 31.1412> }
				triangle { <16.4885, 19.2815, 30.2484>, <15.9755, 19.2872, 31.2106>, <15.8439, 19.2013, 31.1412> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <13.2307, 20.1155, 34.1842>, <13.7881, 19.3993, 34.8374>, 0.05734 }
				cylinder { <13.7881, 19.3993, 34.8374>, <14.3455, 18.6831, 35.4906>, 0.05734 }
				cylinder { <14.3455, 18.6831, 35.4906>, <14.9029, 17.9669, 36.1438>, 0.05734 }
				cylinder { <14.9029, 17.9669, 36.1438>, <15.4603, 17.2507, 36.7971>, 0.05734 }
				cylinder { <15.4603, 17.2507, 36.7971>, <16.01769, 16.5345, 37.4503>, 0.05734 }
				cylinder { <16.01769, 16.5345, 37.4503>, <16.575, 15.8183, 38.1035>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <16.575, 15.8183, 38.1035>, <16.605, 15.7728, 38.1551>, 0.001159 }
				cylinder { <16.605, 15.7728, 38.1551>, <16.6269, 15.7307, 38.2133>, 0.001159 }
				cylinder { <16.6269, 15.7307, 38.2133>, <16.6402, 15.6931, 38.277>, 0.001159 }
				cylinder { <16.6402, 15.6931, 38.277>, <16.6446, 15.6607, 38.3446>, 0.001159 }
				cylinder { <16.6446, 15.6607, 38.3446>, <16.64, 15.6343, 38.4147>, 0.001159 }
				cylinder { <16.64, 15.6343, 38.4147>, <16.6266, 15.6143, 38.4858>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <16.6266, 15.6143, 38.4858>, <16.7278, 14.8817, 39.3722>, <16.7127, 14.9371, 39.4338> }
				triangle { <16.7278, 14.8817, 39.3722>, <16.889, 14.4806, 39.8835>, <16.7127, 14.9371, 39.4338> }
				triangle { <16.889, 14.4806, 39.8835>, <16.8903, 14.5559, 39.9389>, <16.7127, 14.9371, 39.4338> }
				triangle { <16.889, 14.4806, 39.8835>, <17.723, 13.3315, 41.4205>, <16.8903, 14.5559, 39.9389> }
				triangle { <16.8903, 14.5559, 39.9389>, <17.723, 13.3315, 41.4205>, <16.8904, 14.6403, 39.982> }
				triangle { <16.7127, 14.9371, 39.4338>, <16.8903, 14.5559, 39.9389>, <16.8904, 14.6403, 39.982> }
				triangle { <16.7127, 14.9371, 39.4338>, <16.8904, 14.6403, 39.982>, <16.71, 15.00918, 39.4681> }
				triangle { <16.7127, 14.9371, 39.4338>, <16.71, 15.00918, 39.4681>, <16.6266, 15.6143, 38.4858> }
				triangle { <18.2756, 12.7708, 42.1946>, <17.723, 13.3315, 41.4205>, <17.7615, 13.2272, 41.3395> }
				triangle { <16.8904, 14.6403, 39.982>, <17.723, 13.3315, 41.4205>, <17.7832, 13.4639, 41.5119> }
				triangle { <16.889, 14.4806, 39.8835>, <17.7615, 13.2272, 41.3395>, <17.723, 13.3315, 41.4205> }
				triangle { <18.2756, 12.7708, 42.1946>, <17.7832, 13.4639, 41.5119>, <17.723, 13.3315, 41.4205> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <16.575, 15.8183, 38.1035>, <17.1281, 15.1548, 38.8135>, 0.05734 }
				cylinder { <17.1281, 15.1548, 38.8135>, <17.6742, 14.5471, 39.5769>, 0.05734 }
				cylinder { <17.6742, 14.5471, 39.5769>, <18.2108, 13.9983, 40.39>, 0.05734 }
				cylinder { <18.2108, 13.9983, 40.39>, <18.7354, 13.511, 41.2489>, 0.05734 }
				cylinder { <18.7354, 13.511, 41.2489>, <19.2456, 13.08765, 42.1493>, 0.05734 }
				cylinder { <19.2456, 13.08765, 42.1493>, <19.739, 12.7302, 43.08695>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <19.739, 12.7302, 43.08695>, <19.7763, 12.7044, 43.1467>, 0.001159 }
				cylinder { <19.7763, 12.7044, 43.1467>, <19.8177, 12.677, 43.2031>, 0.001159 }
				cylinder { <19.8177, 12.677, 43.2031>, <19.8628, 12.6481, 43.2558>, 0.001159 }
				cylinder { <19.8628, 12.6481, 43.2558>, <19.9114, 12.6179, 43.3044>, 0.001159 }
				cylinder { <19.9114, 12.6179, 43.3044>, <19.9633, 12.5866, 43.3486>, 0.001159 }
				cylinder { <19.9633, 12.5866, 43.3486>, <20.01828, 12.5542, 43.3884>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <20.01828, 12.5542, 43.3884>, <20.9301, 11.852, 43.4771>, <20.9632, 11.8859, 43.5467> }
				triangle { <20.9301, 11.852, 43.4771>, <21.5078, 11.5137, 43.4658>, <20.9632, 11.8859, 43.5467> }
				triangle { <21.5078, 11.5137, 43.4658>, <21.5412, 11.5735, 43.5294>, <20.9632, 11.8859, 43.5467> }
				triangle { <21.5078, 11.5137, 43.4658>, <23.4228, 10.7093, 43.2122>, <21.5412, 11.5735, 43.5294> }
				triangle { <21.5412, 11.5735, 43.5294>, <23.4228, 10.7093, 43.2122>, <21.5622, 11.6422, 43.5911> }
				triangle { <20.9632, 11.8859, 43.5467>, <21.5412, 11.5735, 43.5294>, <21.5622, 11.6422, 43.5911> }
				triangle { <20.9632, 11.8859, 43.5467>, <21.5622, 11.6422, 43.5911>, <20.9776, 11.9436, 43.5999> }
				triangle { <20.9632, 11.8859, 43.5467>, <20.9776, 11.9436, 43.5999>, <20.01828, 12.5542, 43.3884> }
				triangle { <24.4555, 10.3819, 42.9995>, <23.4228, 10.7093, 43.2122>, <23.3947, 10.6457, 43.09362> }
				triangle { <21.5622, 11.6422, 43.5911>, <23.4228, 10.7093, 43.2122>, <23.5078, 10.8424, 43.28> }
				triangle { <21.5078, 11.5137, 43.4658>, <23.3947, 10.6457, 43.09362>, <23.4228, 10.7093, 43.2122> }
				triangle { <24.4555, 10.3819, 42.9995>, <23.5078, 10.8424, 43.28>, <23.4228, 10.7093, 43.2122> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <19.739, 12.7302, 43.08695>, <20.1913, 12.4501, 44.07046>, 0.05734 }
				cylinder { <20.1913, 12.4501, 44.07046>, <20.5991, 12.2497, 45.09214>, 0.05734 }
				cylinder { <20.5991, 12.2497, 45.09214>, <20.9594, 12.1306, 46.1439>, 0.05734 }
				cylinder { <20.9594, 12.1306, 46.1439>, <21.2694, 12.09393, 47.2176>, 0.05734 }
				cylinder { <21.2694, 12.09393, 47.2176>, <21.527, 12.1399, 48.3047>, 0.05734 }
				cylinder { <21.527, 12.1399, 48.3047>, <21.7302, 12.2683, 49.3967>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <21.7302, 12.2683, 49.3967>, <21.7302, 12.2824, 49.4705>, 0.001159 }
				cylinder { <21.7302, 12.2824, 49.4705>, <21.7166, 12.3016, 49.5418>, 0.001159 }
				cylinder { <21.7166, 12.3016, 49.5418>, <21.6899, 12.3249, 49.608>, 0.001159 }
				cylinder { <21.6899, 12.3249, 49.608>, <21.651, 12.3516, 49.6664>, 0.001159 }
				cylinder { <21.651, 12.3516, 49.6664>, <21.6016, 12.3807, 49.7149>, 0.001159 }
				cylinder { <21.6016, 12.3807, 49.7149>, <21.5434, 12.4109, 49.7516>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <21.5434, 12.4109, 49.7516>, <20.9452, 12.6114, 50.7183>, <20.9039, 12.6797, 50.6916> }
				triangle { <20.9452, 12.6114, 50.7183>, <20.6818, 12.784, 51.3092>, <20.9039, 12.6797, 50.6916> }
				triangle { <20.6818, 12.784, 51.3092>, <20.6602, 12.8672, 51.2724>, <20.9039, 12.6797, 50.6916> }
				triangle { <20.6818, 12.784, 51.3092>, <20.1652, 13.4871, 53.2111>, <20.6602, 12.8672, 51.2724> }
				triangle { <20.6602, 12.8672, 51.2724>, <20.1652, 13.4871, 53.2111>, <20.6468, 12.947, 51.2231> }
				triangle { <20.9039, 12.6797, 50.6916>, <20.6602, 12.8672, 51.2724>, <20.6468, 12.947, 51.2231> }
				triangle { <20.9039, 12.6797, 50.6916>, <20.6468, 12.947, 51.2231>, <20.892, 12.745, 50.6472> }
				triangle { <20.9039, 12.6797, 50.6916>, <20.892, 12.745, 50.6472>, <21.5434, 12.4109, 49.7516> }
				triangle { <20.00879, 13.909, 54.2193>, <20.1652, 13.4871, 53.2111>, <20.2284, 13.3864, 53.2799> }
				triangle { <20.6468, 12.947, 51.2231>, <20.1652, 13.4871, 53.2111>, <20.1749, 13.6542, 53.1722> }
				triangle { <20.6818, 12.784, 51.3092>, <20.2284, 13.3864, 53.2799>, <20.1652, 13.4871, 53.2111> }
				triangle { <20.00879, 13.909, 54.2193>, <20.1749, 13.6542, 53.1722>, <20.1652, 13.4871, 53.2111> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <21.7302, 12.2683, 49.3967>, <21.7472, 12.2755, 49.4695>, 0.001159 }
				cylinder { <21.7472, 12.2755, 49.4695>, <21.7675, 12.2812, 49.5416>, 0.001159 }
				cylinder { <21.7675, 12.2812, 49.5416>, <21.7911, 12.2855, 49.6128>, 0.001159 }
				cylinder { <21.7911, 12.2855, 49.6128>, <21.8179, 12.2882, 49.6829>, 0.001159 }
				cylinder { <21.8179, 12.2882, 49.6829>, <21.8478, 12.2895, 49.7518>, 0.001159 }
				cylinder { <21.8478, 12.2895, 49.7518>, <21.8807, 12.2893, 49.8192>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <21.8807, 12.2893, 49.8192>, <22.6695, 11.8938, 50.5635>, <22.6701, 11.9604, 50.615> }
				triangle { <22.6695, 11.8938, 50.5635>, <23.1977, 11.7077, 50.9304>, <22.6701, 11.9604, 50.615> }
				triangle { <23.1977, 11.7077, 50.9304>, <23.2012, 11.7945, 50.9649>, <22.6701, 11.9604, 50.615> }
				triangle { <23.1977, 11.7077, 50.9304>, <25.04037, 11.2759, 51.8231>, <23.2012, 11.7945, 50.9649> }
				triangle { <23.2012, 11.7945, 50.9649>, <25.04037, 11.2759, 51.8231>, <23.1942, 11.8858, 50.9891> }
				triangle { <22.6701, 11.9604, 50.615>, <23.2012, 11.7945, 50.9649>, <23.1942, 11.8858, 50.9891> }
				triangle { <22.6701, 11.9604, 50.615>, <23.1942, 11.8858, 50.9891>, <22.6607, 12.03708, 50.6353> }
				triangle { <22.6701, 11.9604, 50.615>, <22.6607, 12.03708, 50.6353>, <21.8807, 12.2893, 49.8192> }
				triangle { <26.06612, 11.1037, 52.1935>, <25.04037, 11.2759, 51.8231>, <25.06492, 11.1631, 51.7486> }
				triangle { <23.1942, 11.8858, 50.9891>, <25.04037, 11.2759, 51.8231>, <25.08881, 11.4393, 51.8453> }
				triangle { <23.1977, 11.7077, 50.9304>, <25.06492, 11.1631, 51.7486>, <25.04037, 11.2759, 51.8231> }
				triangle { <26.06612, 11.1037, 52.1935>, <25.08881, 11.4393, 51.8453>, <25.04037, 11.2759, 51.8231> }
				texture{Grass_Texture5}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 11.2873, 0.0>, 0.07351 }
			cylinder { <-0.0, 11.2873, 0.0>, <-0.0, 22.5746, 0.0>, 0.07351 }
			cylinder { <-0.0, 22.5746, 0.0>, <-0.00000001, 33.862, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 33.862, 0.0>, <-0.00000001, 45.1493, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 45.1493, 0.0>, <-0.00000001, 56.4367, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 56.4367, 0.0>, <-0.00000001, 67.724, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <-0.00355, 68.2486, -0.01786>, 0.07351 }
			cylinder { <-0.00355, 68.2486, -0.01786>, <-0.01064, 68.7722, -0.05357>, 0.07351 }
			cylinder { <-0.01064, 68.7722, -0.05357>, <-0.02126, 69.2942, -0.107>, 0.07351 }
			cylinder { <-0.02126, 69.2942, -0.107>, <-0.03538, 69.814, -0.1783>, 0.07351 }
			cylinder { <-0.03538, 69.814, -0.1783>, <-0.053, 70.331, -0.2672>, 0.07351 }
			cylinder { <-0.053, 70.331, -0.2672>, <-0.07407, 70.8445, -0.3736>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.07407, 70.8445, -0.3736>, <-0.09857, 71.354, -0.4975>, 0.07351 }
			cylinder { <-0.09857, 71.354, -0.4975>, <-0.1264, 71.8587, -0.6386>, 0.07351 }
			cylinder { <-0.1264, 71.8587, -0.6386>, <-0.1577, 72.3582, -0.7969>, 0.07351 }
			cylinder { <-0.1577, 72.3582, -0.7969>, <-0.1922, 72.8517, -0.972>, 0.07351 }
			cylinder { <-0.1922, 72.8517, -0.972>, <-0.2301, 73.3388, -1.1639>, 0.07351 }
			cylinder { <-0.2301, 73.3388, -1.1639>, <-0.2711, 73.8188, -1.3722>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.2711, 73.8188, -1.3722>, <-0.3218, 74.3039, -1.566>, 0.07351 }
			cylinder { <-0.3218, 74.3039, -1.566>, <-0.382, 74.7937, -1.7449>, 0.07351 }
			cylinder { <-0.382, 74.7937, -1.7449>, <-0.4517, 75.2874, -1.9088>, 0.07351 }
			cylinder { <-0.4517, 75.2874, -1.9088>, <-0.5309, 75.7845, -2.05758>, 0.07351 }
			cylinder { <-0.5309, 75.7845, -2.05758>, <-0.6193, 76.2844, -2.1908>, 0.07351 }
			cylinder { <-0.6193, 76.2844, -2.1908>, <-0.717, 76.7864, -2.3086>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.717, 76.7864, -2.3086>, <-0.7274, 76.8399, -2.3211>, 0.07351 }
				cylinder { <-0.7274, 76.8399, -2.3211>, <-0.7378, 76.8933, -2.3336>, 0.07351 }
				cylinder { <-0.7378, 76.8933, -2.3336>, <-0.7482, 76.9468, -2.3462>, 0.07351 }
				cylinder { <-0.7482, 76.9468, -2.3462>, <-0.7586, 77.00026, -2.3587>, 0.07351 }
				cylinder { <-0.7586, 77.00026, -2.3587>, <-0.769, 77.0537, -2.3712>, 0.07351 }
				cylinder { <-0.769, 77.0537, -2.3712>, <-0.7794, 77.1071, -2.3838>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.7794, 77.1071, -2.3838>, <-0.864, 79.2917, -3.07619>, <-1.1111, 79.2926, -3.1463> }
					triangle { <-0.864, 79.2917, -3.07619>, <-1.08299, 80.5192, -3.3341>, <-1.1111, 79.2926, -3.1463> }
					triangle { <-1.08299, 80.5192, -3.3341>, <-1.356, 80.5119, -3.4176>, <-1.1111, 79.2926, -3.1463> }
					triangle { <-1.08299, 80.5192, -3.3341>, <-1.7189, 82.242, -3.8409>, <-1.356, 80.5119, -3.4176> }
					triangle { <-1.356, 80.5119, -3.4176>, <-1.7189, 82.242, -3.8409>, <-1.5493, 80.3721, -3.5746> }
					triangle { <-1.1111, 79.2926, -3.1463>, <-1.356, 80.5119, -3.4176>, <-1.5493, 80.3721, -3.5746> }
					triangle { <-1.1111, 79.2926, -3.1463>, <-1.5493, 80.3721, -3.5746>, <-1.2933, 79.1652, -3.2639> }
					triangle { <-1.1111, 79.2926, -3.1463>, <-1.2933, 79.1652, -3.2639>, <-0.7794, 77.1071, -2.3838> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.717, 76.7864, -2.3086>, <-0.7976, 77.2901, -2.4322>, 0.07351 }
			cylinder { <-0.7976, 77.2901, -2.4322>, <-0.8608, 77.7949, -2.5614>, 0.07351 }
			cylinder { <-0.8608, 77.7949, -2.5614>, <-0.9067, 78.3001, -2.6963>, 0.07351 }
			cylinder { <-0.9067, 78.3001, -2.6963>, <-0.9352, 78.8051, -2.8365>, 0.07351 }
			cylinder { <-0.9352, 78.8051, -2.8365>, <-0.9462, 79.3093, -2.9818>, 0.07351 }
			cylinder { <-0.9462, 79.3093, -2.9818>, <-0.9398, 79.8121, -3.1322>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.9398, 79.8121, -3.1322>, <-0.9392, 79.8656, -3.1482>, 0.07351 }
				cylinder { <-0.9392, 79.8656, -3.1482>, <-0.9385, 79.9191, -3.1642>, 0.07351 }
				cylinder { <-0.9385, 79.9191, -3.1642>, <-0.9378, 79.9727, -3.1803>, 0.07351 }
				cylinder { <-0.9378, 79.9727, -3.1803>, <-0.9371, 80.02623, -3.1963>, 0.07351 }
				cylinder { <-0.9371, 80.02623, -3.1963>, <-0.9364, 80.07976, -3.2123>, 0.07351 }
				cylinder { <-0.9364, 80.07976, -3.2123>, <-0.9358, 80.1332, -3.2283>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.9358, 80.1332, -3.2283>, <-1.7021, 82.07164, -3.6152>, <-1.566, 82.188, -3.4593> }
					triangle { <-1.7021, 82.07164, -3.6152>, <-1.9381, 83.2005, -3.8506>, <-1.566, 82.188, -3.4593> }
					triangle { <-1.9381, 83.2005, -3.8506>, <-1.7894, 83.3239, -3.6707>, <-1.566, 82.188, -3.4593> }
					triangle { <-1.9381, 83.2005, -3.8506>, <-2.1166, 84.9505, -3.9368>, <-1.7894, 83.3239, -3.6707> }
					triangle { <-1.7894, 83.3239, -3.6707>, <-2.1166, 84.9505, -3.9368>, <-1.7114, 83.3255, -3.4184> }
					triangle { <-1.566, 82.188, -3.4593>, <-1.7894, 83.3239, -3.6707>, <-1.7114, 83.3255, -3.4184> }
					triangle { <-1.566, 82.188, -3.4593>, <-1.7114, 83.3255, -3.4184>, <-1.4765, 82.1863, -3.2448> }
					triangle { <-1.566, 82.188, -3.4593>, <-1.4765, 82.1863, -3.2448>, <-0.9358, 80.1332, -3.2283> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.9398, 79.8121, -3.1322>, <-0.9499, 80.3125, -3.2901>, 0.07351 }
			cylinder { <-0.9499, 80.3125, -3.2901>, <-0.9763, 80.81, -3.4554>, 0.07351 }
			cylinder { <-0.9763, 80.81, -3.4554>, <-1.01915, 81.3039, -3.6277>, 0.07351 }
			cylinder { <-1.01915, 81.3039, -3.6277>, <-1.07828, 81.7936, -3.807>, 0.07351 }
			cylinder { <-1.07828, 81.7936, -3.807>, <-1.1536, 82.2786, -3.993>, 0.07351 }
			cylinder { <-1.1536, 82.2786, -3.993>, <-1.2452, 82.7582, -4.1855>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.2452, 82.7582, -4.1855>, <-1.2549, 82.8093, -4.206>, 0.07351 }
				cylinder { <-1.2549, 82.8093, -4.206>, <-1.2647, 82.8604, -4.2265>, 0.07351 }
				cylinder { <-1.2647, 82.8604, -4.2265>, <-1.2744, 82.9114, -4.247>, 0.07351 }
				cylinder { <-1.2744, 82.9114, -4.247>, <-1.2841, 82.9625, -4.2675>, 0.07351 }
				cylinder { <-1.2841, 82.9625, -4.2675>, <-1.2939, 83.01357, -4.2879>, 0.07351 }
				cylinder { <-1.2939, 83.01357, -4.2879>, <-1.3036, 83.06462, -4.3084>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.3036, 83.06462, -4.3084>, <-1.9537, 84.7626, -5.001631>, <-1.8882, 84.7339, -5.2075> }
					triangle { <-1.9537, 84.7626, -5.001631>, <-2.3939, 85.605, -5.5153>, <-1.8882, 84.7339, -5.2075> }
					triangle { <-2.3939, 85.605, -5.5153>, <-2.3132, 85.5712, -5.7413>, <-1.8882, 84.7339, -5.2075> }
					triangle { <-2.3939, 85.605, -5.5153>, <-2.8893, 86.7745, -6.5152>, <-2.3132, 85.5712, -5.7413> }
					triangle { <-2.3132, 85.5712, -5.7413>, <-2.8893, 86.7745, -6.5152>, <-2.1212, 85.5127, -5.8771> }
					triangle { <-1.8882, 84.7339, -5.2075>, <-2.3132, 85.5712, -5.7413>, <-2.1212, 85.5127, -5.8771> }
					triangle { <-1.8882, 84.7339, -5.2075>, <-2.1212, 85.5127, -5.8771>, <-1.7299, 84.6661, -5.3335> }
					triangle { <-1.8882, 84.7339, -5.2075>, <-1.7299, 84.6661, -5.3335>, <-1.3036, 83.06462, -4.3084> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.2452, 82.7582, -4.1855>, <-1.33, 83.245, -4.3626>, 0.07351 }
			cylinder { <-1.33, 83.245, -4.3626>, <-1.4081, 83.7382, -4.5241>, 0.07351 }
			cylinder { <-1.4081, 83.7382, -4.5241>, <-1.4793, 84.2374, -4.6698>, 0.07351 }
			cylinder { <-1.4793, 84.2374, -4.6698>, <-1.5436, 84.7419, -4.7995>, 0.07351 }
			cylinder { <-1.5436, 84.7419, -4.7995>, <-1.6009, 85.2511, -4.9131>, 0.07351 }
			cylinder { <-1.6009, 85.2511, -4.9131>, <-1.6511, 85.7644, -5.01049>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.6511, 85.7644, -5.01049>, <-1.6564, 85.8191, -5.02085>, 0.07351 }
				cylinder { <-1.6564, 85.8191, -5.02085>, <-1.6617, 85.8737, -5.03121>, 0.07351 }
				cylinder { <-1.6617, 85.8737, -5.03121>, <-1.6671, 85.9284, -5.04157>, 0.07351 }
				cylinder { <-1.6671, 85.9284, -5.04157>, <-1.6724, 85.983, -5.05193>, 0.07351 }
				cylinder { <-1.6724, 85.983, -5.05193>, <-1.6778, 86.03769, -5.06229>, 0.07351 }
				cylinder { <-1.6778, 86.03769, -5.06229>, <-1.6831, 86.09233, -5.07265>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.6831, 86.09233, -5.07265>, <-1.6477, 87.8516, -5.2704>, <-1.8184, 87.8898, -5.1768> }
					triangle { <-1.6477, 87.8516, -5.2704>, <-1.6551, 88.8334, -5.2173>, <-1.8184, 87.8898, -5.1768> }
					triangle { <-1.6551, 88.8334, -5.2173>, <-1.8483, 88.8705, -5.1177>, <-1.8184, 87.8898, -5.1768> }
					triangle { <-1.6551, 88.8334, -5.2173>, <-1.9188, 90.2705, -5.04681>, <-1.8483, 88.8705, -5.1177> }
					triangle { <-1.8483, 88.8705, -5.1177>, <-1.9188, 90.2705, -5.04681>, <-2.06152, 88.8145, -5.1099> }
					triangle { <-1.8184, 87.8898, -5.1768>, <-1.8483, 88.8705, -5.1177>, <-2.06152, 88.8145, -5.1099> }
					triangle { <-1.8184, 87.8898, -5.1768>, <-2.06152, 88.8145, -5.1099>, <-2.003022, 87.8348, -5.1523> }
					triangle { <-1.8184, 87.8898, -5.1768>, <-2.003022, 87.8348, -5.1523>, <-1.6831, 86.09233, -5.07265> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.6511, 85.7644, -5.01049>, <-1.6953, 86.2748, -5.1247>, 0.07351 }
			cylinder { <-1.6953, 86.2748, -5.1247>, <-1.7335, 86.7816, -5.2558>, 0.07351 }
			cylinder { <-1.7335, 86.7816, -5.2558>, <-1.7656, 87.2842, -5.4036>, 0.07351 }
			cylinder { <-1.7656, 87.2842, -5.4036>, <-1.7916, 87.782, -5.5678>, 0.07351 }
			cylinder { <-1.7916, 87.782, -5.5678>, <-1.8114, 88.2745, -5.7483>, 0.07351 }
			cylinder { <-1.8114, 88.2745, -5.7483>, <-1.8251, 88.7609, -5.9449>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.8251, 88.7609, -5.9449>, <-1.8265, 88.8127, -5.9658>, 0.07351 }
				cylinder { <-1.8265, 88.8127, -5.9658>, <-1.828, 88.8645, -5.9867>, 0.07351 }
				cylinder { <-1.828, 88.8645, -5.9867>, <-1.8294, 88.9163, -6.007676>, 0.07351 }
				cylinder { <-1.8294, 88.9163, -6.007676>, <-1.8309, 88.9681, -6.0286>, 0.07351 }
				cylinder { <-1.8309, 88.9681, -6.0286>, <-1.8323, 89.01993, -6.04952>, 0.07351 }
				cylinder { <-1.8323, 89.01993, -6.04952>, <-1.8338, 89.07172, -6.07045>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.8338, 89.07172, -6.07045>, <-2.1167, 90.6279, -6.2755>, <-1.9462, 90.6792, -6.2903> }
					triangle { <-2.1167, 90.6279, -6.2755>, <-2.185, 91.4797, -6.5082>, <-1.9462, 90.6792, -6.2903> }
					triangle { <-2.185, 91.4797, -6.5082>, <-1.994, 91.5333, -6.5187>, <-1.9462, 90.6792, -6.2903> }
					triangle { <-2.185, 91.4797, -6.5082>, <-2.04586, 92.7592, -6.8235>, <-1.994, 91.5333, -6.5187> }
					triangle { <-1.994, 91.5333, -6.5187>, <-2.04586, 92.7592, -6.8235>, <-1.8162, 91.521, -6.4309> }
					triangle { <-1.9462, 90.6792, -6.2903>, <-1.994, 91.5333, -6.5187>, <-1.8162, 91.521, -6.4309> }
					triangle { <-1.9462, 90.6792, -6.2903>, <-1.8162, 91.521, -6.4309>, <-1.7842, 90.6606, -6.2269> }
					triangle { <-1.9462, 90.6792, -6.2903>, <-1.7842, 90.6606, -6.2269>, <-1.8338, 89.07172, -6.07045> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <-0.009365, 68.2486, 0.01562>, 0.07351 }
			cylinder { <-0.009365, 68.2486, 0.01562>, <-0.02809, 68.7722, 0.04684>, 0.07351 }
			cylinder { <-0.02809, 68.7722, 0.04684>, <-0.05615, 69.2942, 0.09361>, 0.07351 }
			cylinder { <-0.05615, 69.2942, 0.09361>, <-0.09353, 69.814, 0.1558>, 0.07351 }
			cylinder { <-0.09353, 69.814, 0.1558>, <-0.1401, 70.331, 0.2335>, 0.07351 }
			cylinder { <-0.1401, 70.331, 0.2335>, <-0.196, 70.8445, 0.3266>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.196, 70.8445, 0.3266>, <-0.2346, 71.3605, 0.4145>, 0.07351 }
			cylinder { <-0.2346, 71.3605, 0.4145>, <-0.2557, 71.8784, 0.4973>, 0.07351 }
			cylinder { <-0.2557, 71.8784, 0.4973>, <-0.2595, 72.3974, 0.5749>, 0.07351 }
			cylinder { <-0.2595, 72.3974, 0.5749>, <-0.2459, 72.9171, 0.6471>, 0.07351 }
			cylinder { <-0.2459, 72.9171, 0.6471>, <-0.2149, 73.4368, 0.7139>, 0.07351 }
			cylinder { <-0.2149, 73.4368, 0.7139>, <-0.1665, 73.9558, 0.7752>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.1665, 73.9558, 0.7752>, <-0.1614, 74.01112, 0.7817>, 0.07351 }
				cylinder { <-0.1614, 74.01112, 0.7817>, <-0.1562, 74.06638, 0.7882>, 0.07351 }
				cylinder { <-0.1562, 74.06638, 0.7882>, <-0.1511, 74.1216, 0.7947>, 0.07351 }
				cylinder { <-0.1511, 74.1216, 0.7947>, <-0.1459, 74.1768, 0.8013>, 0.07351 }
				cylinder { <-0.1459, 74.1768, 0.8013>, <-0.1408, 74.2321, 0.8078>, 0.07351 }
				cylinder { <-0.1408, 74.2321, 0.8078>, <-0.1356, 74.2873, 0.8143>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.1356, 74.2873, 0.8143>, <0.1789, 76.02994, 0.8295>, <0.2632, 76.03761, 1.008938> }
					triangle { <0.1789, 76.02994, 0.8295>, <0.5079, 76.9551, 0.879>, <0.2632, 76.03761, 1.008938> }
					triangle { <0.5079, 76.9551, 0.879>, <0.5955, 76.9598, 1.08136>, <0.2632, 76.03761, 1.008938> }
					triangle { <0.5079, 76.9551, 0.879>, <1.05467, 78.2798, 1.2112>, <0.5955, 76.9598, 1.08136> }
					triangle { <0.5955, 76.9598, 1.08136>, <1.05467, 78.2798, 1.2112>, <0.5673, 76.9013, 1.2921> }
					triangle { <0.2632, 76.03761, 1.008938>, <0.5955, 76.9598, 1.08136>, <0.5673, 76.9013, 1.2921> }
					triangle { <0.2632, 76.03761, 1.008938>, <0.5673, 76.9013, 1.2921>, <0.2537, 75.9756, 1.1927> }
					triangle { <0.2632, 76.03761, 1.008938>, <0.2537, 75.9756, 1.1927>, <-0.1356, 74.2873, 0.8143> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.1665, 73.9558, 0.7752>, <-0.1346, 74.477, 0.829>, 0.07351 }
			cylinder { <-0.1346, 74.477, 0.829>, <-0.1192, 74.9996, 0.8752>, 0.07351 }
			cylinder { <-0.1192, 74.9996, 0.8752>, <-0.1203, 75.523, 0.9137>, 0.07351 }
			cylinder { <-0.1203, 75.523, 0.9137>, <-0.1379, 76.04669, 0.9446>, 0.07351 }
			cylinder { <-0.1379, 76.04669, 0.9446>, <-0.1721, 76.5699, 0.9678>, 0.07351 }
			cylinder { <-0.1721, 76.5699, 0.9678>, <-0.2226, 77.09212, 0.9832>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.2226, 77.09212, 0.9832>, <-0.228, 77.1477, 0.9848>, 0.07351 }
				cylinder { <-0.228, 77.1477, 0.9848>, <-0.2334, 77.2033, 0.9864>, 0.07351 }
				cylinder { <-0.2334, 77.2033, 0.9864>, <-0.2388, 77.2588, 0.9881>, 0.07351 }
				cylinder { <-0.2388, 77.2588, 0.9881>, <-0.2442, 77.3144, 0.9897>, 0.07351 }
				cylinder { <-0.2442, 77.3144, 0.9897>, <-0.2495, 77.37, 0.9914>, 0.07351 }
				cylinder { <-0.2495, 77.37, 0.9914>, <-0.2549, 77.4256, 0.993>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.2549, 77.4256, 0.993>, <-0.03462, 78.9718, 1.3167>, <-0.01837, 79.0273, 1.1476> }
					triangle { <-0.03462, 78.9718, 1.3167>, <-0.02091, 79.8536, 1.3974>, <-0.01837, 79.0273, 1.1476> }
					triangle { <-0.02091, 79.8536, 1.3974>, <0.00199, 79.9103, 1.2084>, <-0.01837, 79.0273, 1.1476> }
					triangle { <-0.02091, 79.8536, 1.3974>, <0.05481, 81.1714, 1.2808>, <0.00199, 79.9103, 1.2084> }
					triangle { <0.00199, 79.9103, 1.2084>, <0.05481, 81.1714, 1.2808>, <0.09886, 79.8756, 1.0385> }
					triangle { <-0.01837, 79.0273, 1.1476>, <0.00199, 79.9103, 1.2084>, <0.09886, 79.8756, 1.0385> }
					triangle { <-0.01837, 79.0273, 1.1476>, <0.09886, 79.8756, 1.0385>, <0.05192, 78.9932, 0.9911> }
					triangle { <-0.01837, 79.0273, 1.1476>, <0.05192, 78.9932, 0.9911>, <-0.2549, 77.4256, 0.993> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.196, 70.8445, 0.3266>, <-0.2346, 71.3605, 0.4145>, 0.07351 }
			cylinder { <-0.2346, 71.3605, 0.4145>, <-0.2557, 71.8784, 0.4973>, 0.07351 }
			cylinder { <-0.2557, 71.8784, 0.4973>, <-0.2595, 72.3974, 0.5749>, 0.07351 }
			cylinder { <-0.2595, 72.3974, 0.5749>, <-0.2459, 72.9171, 0.6471>, 0.07351 }
			cylinder { <-0.2459, 72.9171, 0.6471>, <-0.2149, 73.4368, 0.7139>, 0.07351 }
			cylinder { <-0.2149, 73.4368, 0.7139>, <-0.1665, 73.9558, 0.7752>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.1665, 73.9558, 0.7752>, <-0.1346, 74.477, 0.829>, 0.07351 }
			cylinder { <-0.1346, 74.477, 0.829>, <-0.1192, 74.9996, 0.8752>, 0.07351 }
			cylinder { <-0.1192, 74.9996, 0.8752>, <-0.1203, 75.523, 0.9137>, 0.07351 }
			cylinder { <-0.1203, 75.523, 0.9137>, <-0.1379, 76.04669, 0.9446>, 0.07351 }
			cylinder { <-0.1379, 76.04669, 0.9446>, <-0.1721, 76.5699, 0.9678>, 0.07351 }
			cylinder { <-0.1721, 76.5699, 0.9678>, <-0.2226, 77.09212, 0.9832>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.2226, 77.09212, 0.9832>, <-0.228, 77.1477, 0.9848>, 0.07351 }
				cylinder { <-0.228, 77.1477, 0.9848>, <-0.2334, 77.2033, 0.9864>, 0.07351 }
				cylinder { <-0.2334, 77.2033, 0.9864>, <-0.2388, 77.2588, 0.9881>, 0.07351 }
				cylinder { <-0.2388, 77.2588, 0.9881>, <-0.2442, 77.3144, 0.9897>, 0.07351 }
				cylinder { <-0.2442, 77.3144, 0.9897>, <-0.2495, 77.37, 0.9914>, 0.07351 }
				cylinder { <-0.2495, 77.37, 0.9914>, <-0.2549, 77.4256, 0.993>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.2549, 77.4256, 0.993>, <-0.6638, 79.1463, 1.08039>, <-0.6084, 79.1936, 0.8958> }
					triangle { <-0.6638, 79.1463, 1.08039>, <-0.9736, 80.07496, 0.9884>, <-0.6084, 79.1936, 0.8958> }
					triangle { <-0.9736, 80.07496, 0.9884>, <-0.9052, 80.1241, 0.7846>, <-0.6084, 79.1936, 0.8958> }
					triangle { <-0.9736, 80.07496, 0.9884>, <-1.3003, 81.4605, 0.6176>, <-0.9052, 80.1241, 0.7846> }
					triangle { <-0.9052, 80.1241, 0.7846>, <-1.3003, 81.4605, 0.6176>, <-0.7385, 80.1084, 0.6411> }
					triangle { <-0.6084, 79.1936, 0.8958>, <-0.9052, 80.1241, 0.7846>, <-0.7385, 80.1084, 0.6411> }
					triangle { <-0.6084, 79.1936, 0.8958>, <-0.7385, 80.1084, 0.6411>, <-0.4731, 79.1699, 0.7586> }
					triangle { <-0.6084, 79.1936, 0.8958>, <-0.4731, 79.1699, 0.7586>, <-0.2549, 77.4256, 0.993> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.2226, 77.09212, 0.9832>, <-0.2662, 77.6141, 1.01542>, 0.07351 }
			cylinder { <-0.2662, 77.6141, 1.01542>, <-0.3026, 78.1354, 1.06439>, 0.07351 }
			cylinder { <-0.3026, 78.1354, 1.06439>, <-0.332, 78.6553, 1.13>, 0.07351 }
			cylinder { <-0.332, 78.6553, 1.13>, <-0.3542, 79.1732, 1.2124>, 0.07351 }
			cylinder { <-0.3542, 79.1732, 1.2124>, <-0.3693, 79.6885, 1.3112>, 0.07351 }
			cylinder { <-0.3693, 79.6885, 1.3112>, <-0.3772, 80.2005, 1.4265>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-0.3772, 80.2005, 1.4265>, <-0.378, 80.255, 1.4388>, 0.07351 }
				cylinder { <-0.378, 80.255, 1.4388>, <-0.3788, 80.3095, 1.451>, 0.07351 }
				cylinder { <-0.3788, 80.3095, 1.451>, <-0.3797, 80.364, 1.4633>, 0.07351 }
				cylinder { <-0.3797, 80.364, 1.4633>, <-0.3805, 80.4185, 1.4756>, 0.07351 }
				cylinder { <-0.3805, 80.4185, 1.4756>, <-0.3813, 80.473, 1.4879>, 0.07351 }
				cylinder { <-0.3813, 80.473, 1.4879>, <-0.3822, 80.5275, 1.5001>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-0.3822, 80.5275, 1.5001>, <-0.496, 82.1148, 1.3932>, <-0.6259, 82.1355, 1.5141> }
					triangle { <-0.496, 82.1148, 1.3932>, <-0.5466, 82.9945, 1.482>, <-0.6259, 82.1355, 1.5141> }
					triangle { <-0.5466, 82.9945, 1.482>, <-0.6948, 83.01262, 1.6131>, <-0.6259, 82.1355, 1.5141> }
					triangle { <-0.5466, 82.9945, 1.482>, <-0.8202, 84.2632, 1.749>, <-0.6948, 83.01262, 1.6131> }
					triangle { <-0.6948, 83.01262, 1.6131>, <-0.8202, 84.2632, 1.749>, <-0.8754, 82.9481, 1.6647> }
					triangle { <-0.6259, 82.1355, 1.5141>, <-0.6948, 83.01262, 1.6131>, <-0.8754, 82.9481, 1.6647> }
					triangle { <-0.6259, 82.1355, 1.5141>, <-0.8754, 82.9481, 1.6647>, <-0.778, 82.07333, 1.574> }
					triangle { <-0.6259, 82.1355, 1.5141>, <-0.778, 82.07333, 1.574>, <-0.3822, 80.5275, 1.5001> }
					texture{Grass_Texture8}}
				}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.08103, 5.9414, 0.1212>, 0.09177 }
			cylinder { <-0.08103, 5.9414, 0.1212>, <-0.243, 11.8775, 0.3637>, 0.09177 }
			cylinder { <-0.243, 11.8775, 0.3637>, <-0.4859, 17.8046, 0.7272>, 0.09177 }
			cylinder { <-0.4859, 17.8046, 0.7272>, <-0.8095, 23.7192, 1.2116>, 0.09177 }
			cylinder { <-0.8095, 23.7192, 1.2116>, <-1.2137, 29.6178, 1.8165>, 0.09177 }
			cylinder { <-1.2137, 29.6178, 1.8165>, <-1.6982, 35.4967, 2.5416>, 0.09177 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-1.6982, 35.4967, 2.5416>, <-1.8684, 37.2754, 2.6384>, 0.09177 }
				cylinder { <-1.8684, 37.2754, 2.6384>, <-2.062, 39.05432, 2.6133>, 0.09177 }
				cylinder { <-2.062, 39.05432, 2.6133>, <-2.2778, 40.8246, 2.4664>, 0.09177 }
				cylinder { <-2.2778, 40.8246, 2.4664>, <-2.5147, 42.578, 2.1982>, 0.09177 }
				cylinder { <-2.5147, 42.578, 2.1982>, <-2.7714, 44.306, 1.8101>, 0.09177 }
				cylinder { <-2.7714, 44.306, 1.8101>, <-3.04652, 46.00024, 1.3039>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.04652, 46.00024, 1.3039>, <-3.1017, 46.1701, 1.2326>, 0.002969 }
				cylinder { <-3.1017, 46.1701, 1.2326>, <-3.1808, 46.3228, 1.1466>, 0.002969 }
				cylinder { <-3.1808, 46.3228, 1.1466>, <-3.2817, 46.4538, 1.04834>, 0.002969 }
				cylinder { <-3.2817, 46.4538, 1.04834>, <-3.4012, 46.5593, 0.9407>, 0.002969 }
				cylinder { <-3.4012, 46.5593, 0.9407>, <-3.5358, 46.6361, 0.8268>, 0.002969 }
				cylinder { <-3.5358, 46.6361, 0.8268>, <-3.6817, 46.682, 0.7102>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.6817, 46.682, 0.7102>, <-5.2106, 47.6691, 0.3921>, <-5.2498, 47.6823, 0.5203> }
				triangle { <-5.2106, 47.6691, 0.3921>, <-6.1742, 48.09266, 0.1913>, <-5.2498, 47.6823, 0.5203> }
				triangle { <-6.1742, 48.09266, 0.1913>, <-6.2113, 48.06576, 0.3337>, <-5.2498, 47.6823, 0.5203> }
				triangle { <-6.1742, 48.09266, 0.1913>, <-9.3558, 48.8826, -0.4926>, <-6.2113, 48.06576, 0.3337> }
				triangle { <-6.2113, 48.06576, 0.3337>, <-9.3558, 48.8826, -0.4926>, <-6.2277, 48.02585, 0.4791> }
				triangle { <-5.2498, 47.6823, 0.5203>, <-6.2113, 48.06576, 0.3337>, <-6.2277, 48.02585, 0.4791> }
				triangle { <-5.2498, 47.6823, 0.5203>, <-6.2277, 48.02585, 0.4791>, <-5.2582, 47.6501, 0.6437> }
				triangle { <-5.2498, 47.6823, 0.5203>, <-5.2582, 47.6501, 0.6437>, <-3.6817, 46.682, 0.7102> }
				triangle { <-11.06783, 49.09991, -0.8721>, <-9.3558, 48.8826, -0.4926>, <-9.3349, 48.8667, -0.711> }
				triangle { <-6.2277, 48.02585, 0.4791>, <-9.3558, 48.8826, -0.4926>, <-9.4648, 48.7589, -0.2725> }
				triangle { <-6.1742, 48.09266, 0.1913>, <-9.3349, 48.8667, -0.711>, <-9.3558, 48.8826, -0.4926> }
				triangle { <-11.06783, 49.09991, -0.8721>, <-9.4648, 48.7589, -0.2725>, <-9.3558, 48.8826, -0.4926> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.04652, 46.00024, 1.3039>, <-3.3041, 47.6668, 0.7052>, 0.09177 }
				cylinder { <-3.3041, 47.6668, 0.7052>, <-3.5433, 49.3007, 0.0157>, 0.09177 }
				cylinder { <-3.5433, 49.3007, 0.0157>, <-3.7634, 50.897, -0.7624>, 0.09177 }
				cylinder { <-3.7634, 50.897, -0.7624>, <-3.9636, 52.451, -1.6269>, 0.09177 }
				cylinder { <-3.9636, 52.451, -1.6269>, <-4.1433, 53.958, -2.5752>, 0.09177 }
				cylinder { <-4.1433, 53.958, -2.5752>, <-4.3018, 55.4134, -3.6042>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.3018, 55.4134, -3.6042>, <-4.3042, 55.577, -3.7053>, 0.002969 }
				cylinder { <-4.3042, 55.577, -3.7053>, <-4.292, 55.7462, -3.7959>, 0.002969 }
				cylinder { <-4.292, 55.7462, -3.7959>, <-4.2652, 55.9194, -3.8752>, 0.002969 }
				cylinder { <-4.2652, 55.9194, -3.8752>, <-4.2241, 56.09495, -3.9423>, 0.002969 }
				cylinder { <-4.2241, 56.09495, -3.9423>, <-4.1692, 56.271, -3.9967>, 0.002969 }
				cylinder { <-4.1692, 56.271, -3.9967>, <-4.1009, 56.4461, -4.03777>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.1009, 56.4461, -4.03777>, <-3.6771, 58.1561, -3.4817>, <-3.7686, 58.1655, -3.3833> }
				triangle { <-3.6771, 58.1561, -3.4817>, <-3.5408, 59.199, -3.2766>, <-3.7686, 58.1655, -3.3833> }
				triangle { <-3.5408, 59.199, -3.2766>, <-3.668, 59.196, -3.1978>, <-3.7686, 58.1655, -3.3833> }
				triangle { <-3.5408, 59.199, -3.2766>, <-3.4776, 62.5401, -3.05816>, <-3.668, 59.196, -3.1978> }
				triangle { <-3.668, 59.196, -3.1978>, <-3.4776, 62.5401, -3.05816>, <-3.7998, 59.1704, -3.1273> }
				triangle { <-3.7686, 58.1655, -3.3833>, <-3.668, 59.196, -3.1978>, <-3.7998, 59.1704, -3.1273> }
				triangle { <-3.7686, 58.1655, -3.3833>, <-3.7998, 59.1704, -3.1273>, <-3.8778, 58.1388, -3.3224> }
				triangle { <-3.7686, 58.1655, -3.3833>, <-3.8778, 58.1388, -3.3224>, <-4.1009, 56.4461, -4.03777> }
				triangle { <-3.5727, 64.3039, -3.1002>, <-3.4776, 62.5401, -3.05816>, <-3.3308, 62.5688, -3.2194> }
				triangle { <-3.7998, 59.1704, -3.1273>, <-3.4776, 62.5401, -3.05816>, <-3.7435, 62.5705, -2.9947> }
				triangle { <-3.5408, 59.199, -3.2766>, <-3.3308, 62.5688, -3.2194>, <-3.4776, 62.5401, -3.05816> }
				triangle { <-3.5727, 64.3039, -3.1002>, <-3.7435, 62.5705, -2.9947>, <-3.4776, 62.5401, -3.05816> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.3018, 55.4134, -3.6042>, <-4.4541, 56.904, -4.5826>, 0.09177 }
				cylinder { <-4.4541, 56.904, -4.5826>, <-4.5998, 58.4281, -5.509>, 0.09177 }
				cylinder { <-4.5998, 58.4281, -5.509>, <-4.7388, 59.9838, -6.3824>, 0.09177 }
				cylinder { <-4.7388, 59.9838, -6.3824>, <-4.8711, 61.5693, -7.2016>, 0.09177 }
				cylinder { <-4.8711, 61.5693, -7.2016>, <-4.9964, 63.1826, -7.9658>, 0.09177 }
				cylinder { <-4.9964, 63.1826, -7.9658>, <-5.1146, 64.8217, -8.674>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.1146, 64.8217, -8.674>, <-5.142, 64.9915, -8.7601>, 0.002969 }
				cylinder { <-5.142, 64.9915, -8.7601>, <-5.1838, 65.1533, -8.8554>, 0.002969 }
				cylinder { <-5.1838, 65.1533, -8.8554>, <-5.2397, 65.3055, -8.9589>, 0.002969 }
				cylinder { <-5.2397, 65.3055, -8.9589>, <-5.309, 65.4466, -9.06967>, 0.002969 }
				cylinder { <-5.309, 65.4466, -9.06967>, <-5.3911, 65.5754, -9.1866>, 0.002969 }
				cylinder { <-5.3911, 65.5754, -9.1866>, <-5.4853, 65.6905, -9.3086>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-5.4853, 65.6905, -9.3086>, <-6.435, 67.2457, -9.6122>, <-6.4878, 67.2582, -9.4888> }
				triangle { <-6.435, 67.2457, -9.6122>, <-7.11, 68.04625, -9.8396>, <-6.4878, 67.2582, -9.4888> }
				triangle { <-7.11, 68.04625, -9.8396>, <-7.1789, 68.01988, -9.7094>, <-6.4878, 67.2582, -9.4888> }
				triangle { <-7.11, 68.04625, -9.8396>, <-9.5695, 70.1412, -10.7209>, <-7.1789, 68.01988, -9.7094> }
				triangle { <-7.1789, 68.01988, -9.7094>, <-9.5695, 70.1412, -10.7209>, <-7.2345, 67.9729, -9.5764> }
				triangle { <-6.4878, 67.2582, -9.4888>, <-7.1789, 68.01988, -9.7094>, <-7.2345, 67.9729, -9.5764> }
				triangle { <-6.4878, 67.2582, -9.4888>, <-7.2345, 67.9729, -9.5764>, <-6.5294, 67.2176, -9.375> }
				triangle { <-6.4878, 67.2582, -9.4888>, <-6.5294, 67.2176, -9.375>, <-5.4853, 65.6905, -9.3086> }
				triangle { <-10.9709, 71.08189, -11.2437>, <-9.5695, 70.1412, -10.7209>, <-9.5185, 70.1446, -10.9348> }
				triangle { <-7.2345, 67.9729, -9.5764>, <-9.5695, 70.1412, -10.7209>, <-9.7543, 70.04729, -10.5403> }
				triangle { <-7.11, 68.04625, -9.8396>, <-9.5185, 70.1446, -10.9348>, <-9.5695, 70.1412, -10.7209> }
				triangle { <-10.9709, 71.08189, -11.2437>, <-9.7543, 70.04729, -10.5403>, <-9.5695, 70.1412, -10.7209> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.1146, 64.8217, -8.674>, <-5.1985, 66.4733, -9.3578>, 0.09177 }
				cylinder { <-5.1985, 66.4733, -9.3578>, <-5.2479, 68.1363, -10.01695>, 0.09177 }
				cylinder { <-5.2479, 68.1363, -10.01695>, <-5.2628, 69.8097, -10.6508>, 0.09177 }
				cylinder { <-5.2628, 69.8097, -10.6508>, <-5.2433, 71.4925, -11.2592>, 0.09177 }
				cylinder { <-5.2433, 71.4925, -11.2592>, <-5.1892, 73.1837, -11.8417>, 0.09177 }
				cylinder { <-5.1892, 73.1837, -11.8417>, <-5.1008, 74.8822, -12.398>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-5.1008, 74.8822, -12.398>, <-5.06933, 75.06727, -12.4401>, 0.002969 }
				cylinder { <-5.06933, 75.06727, -12.4401>, <-5.01649, 75.2506, -12.4638>, 0.002969 }
				cylinder { <-5.01649, 75.2506, -12.4638>, <-4.9434, 75.4285, -12.4683>, 0.002969 }
				cylinder { <-4.9434, 75.4285, -12.4683>, <-4.8518, 75.597, -12.4538>, 0.002969 }
				cylinder { <-4.8518, 75.597, -12.4538>, <-4.7436, 75.7524, -12.4204>, 0.002969 }
				cylinder { <-4.7436, 75.7524, -12.4204>, <-4.6211, 75.8915, -12.3689>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.6211, 75.8915, -12.3689>, <-3.8619, 76.9276, -11.04107>, <-3.9662, 76.9258, -10.9558> }
				triangle { <-3.8619, 76.9276, -11.04107>, <-3.4834, 77.6597, -10.3563>, <-3.9662, 76.9258, -10.9558> }
				triangle { <-3.4834, 77.6597, -10.3563>, <-3.6203, 77.6687, -10.2964>, <-3.9662, 76.9258, -10.9558> }
				triangle { <-3.4834, 77.6597, -10.3563>, <-2.5232, 80.3249, -8.5704>, <-3.6203, 77.6687, -10.2964> }
				triangle { <-3.6203, 77.6687, -10.2964>, <-2.5232, 80.3249, -8.5704>, <-3.766, 77.6639, -10.2549> }
				triangle { <-3.9662, 76.9258, -10.9558>, <-3.6203, 77.6687, -10.2964>, <-3.766, 77.6639, -10.2549> }
				triangle { <-3.9662, 76.9258, -10.9558>, <-3.766, 77.6639, -10.2549>, <-4.08909, 76.9162, -10.9218> }
				triangle { <-3.9662, 76.9258, -10.9558>, <-4.08909, 76.9162, -10.9218>, <-4.6211, 75.8915, -12.3689> }
				triangle { <-2.1015, 81.8446, -7.7736>, <-2.5232, 80.3249, -8.5704>, <-2.3425, 80.3657, -8.6891> }
				triangle { <-3.766, 77.6639, -10.2549>, <-2.5232, 80.3249, -8.5704>, <-2.7766, 80.4172, -8.5167> }
				triangle { <-3.4834, 77.6597, -10.3563>, <-2.3425, 80.3657, -8.6891>, <-2.5232, 80.3249, -8.5704> }
				triangle { <-2.1015, 81.8446, -7.7736>, <-2.7766, 80.4172, -8.5167>, <-2.5232, 80.3249, -8.5704> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-5.1008, 74.8822, -12.398>, <-4.9641, 76.6187, -12.8083>, 0.09177 }
				cylinder { <-4.9641, 76.6187, -12.8083>, <-4.7804, 78.3795, -13.06957>, 0.09177 }
				cylinder { <-4.7804, 78.3795, -13.06957>, <-4.5516, 80.1509, -13.1794>, 0.09177 }
				cylinder { <-4.5516, 80.1509, -13.1794>, <-4.2796, 81.9191, -13.1371>, 0.09177 }
				cylinder { <-4.2796, 81.9191, -13.1371>, <-3.9668, 83.6703, -12.9428>, 0.09177 }
				cylinder { <-3.9668, 83.6703, -12.9428>, <-3.616, 85.3909, -12.5979>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-3.616, 85.3909, -12.5979>, <-3.5886, 85.5792, -12.5699>, 0.002969 }
				cylinder { <-3.5886, 85.5792, -12.5699>, <-3.5716, 85.7699, -12.5512>, 0.002969 }
				cylinder { <-3.5716, 85.7699, -12.5512>, <-3.5652, 85.9619, -12.5419>, 0.002969 }
				cylinder { <-3.5652, 85.9619, -12.5419>, <-3.5694, 86.1541, -12.542>, 0.002969 }
				cylinder { <-3.5694, 86.1541, -12.542>, <-3.5841, 86.3457, -12.5514>, 0.002969 }
				cylinder { <-3.5841, 86.3457, -12.5514>, <-3.6093, 86.5354, -12.5703>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-3.6093, 86.5354, -12.5703>, <-3.9626, 88.1752, -11.7961>, <-4.03651, 88.1301, -11.6928> }
				triangle { <-3.9626, 88.1752, -11.7961>, <-4.3005, 89.1313, -11.4501>, <-4.03651, 88.1301, -11.6928> }
				triangle { <-4.3005, 89.1313, -11.4501>, <-4.4023, 89.06068, -11.3663>, <-4.03651, 88.1301, -11.6928> }
				triangle { <-4.3005, 89.1313, -11.4501>, <-5.7612, 92.06403, -10.7567>, <-4.4023, 89.06068, -11.3663> }
				triangle { <-4.4023, 89.06068, -11.3663>, <-5.7612, 92.06403, -10.7567>, <-4.4986, 88.9687, -11.2937> }
				triangle { <-4.03651, 88.1301, -11.6928>, <-4.4023, 89.06068, -11.3663>, <-4.4986, 88.9687, -11.2937> }
				triangle { <-4.03651, 88.1301, -11.6928>, <-4.4986, 88.9687, -11.2937>, <-4.1134, 88.04892, -11.631> }
				triangle { <-4.03651, 88.1301, -11.6928>, <-4.1134, 88.04892, -11.631>, <-3.6093, 86.5354, -12.5703> }
				triangle { <-6.663, 93.5679, -10.5396>, <-5.7612, 92.06403, -10.7567>, <-5.6632, 92.1751, -10.9193> }
				triangle { <-4.4986, 88.9687, -11.2937>, <-5.7612, 92.06403, -10.7567>, <-6.002135, 91.9586, -10.6762> }
				triangle { <-4.3005, 89.1313, -11.4501>, <-5.6632, 92.1751, -10.9193>, <-5.7612, 92.06403, -10.7567> }
				triangle { <-6.663, 93.5679, -10.5396>, <-6.002135, 91.9586, -10.6762>, <-5.7612, 92.06403, -10.7567> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-3.616, 85.3909, -12.5979>, <-3.2302, 87.06741, -12.1051>, 0.09177 }
				cylinder { <-3.2302, 87.06741, -12.1051>, <-2.8126, 88.6867, -11.4682>, 0.09177 }
				cylinder { <-2.8126, 88.6867, -11.4682>, <-2.3668, 90.2363, -10.6921>, 0.09177 }
				cylinder { <-2.3668, 90.2363, -10.6921>, <-1.8967, 91.7041, -9.7827>, 0.09177 }
				cylinder { <-1.8967, 91.7041, -9.7827>, <-1.406, 93.07859, -8.7471>, 0.09177 }
				cylinder { <-1.406, 93.07859, -8.7471>, <-0.8989, 94.349, -7.5934>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.8989, 94.349, -7.5934>, <-0.8228, 94.4584, -7.4547>, 0.002969 }
				cylinder { <-0.8228, 94.4584, -7.4547>, <-0.728, 94.5364, -7.3067>, 0.002969 }
				cylinder { <-0.728, 94.5364, -7.3067>, <-0.6181, 94.5801, -7.155>, 0.002969 }
				cylinder { <-0.6181, 94.5801, -7.155>, <-0.4973, 94.5876, -7.005519>, 0.002969 }
				cylinder { <-0.4973, 94.5876, -7.005519>, <-0.3704, 94.5589, -6.8639>, 0.002969 }
				cylinder { <-0.3704, 94.5589, -6.8639>, <-0.2421, 94.4949, -6.7356>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.2421, 94.4949, -6.7356>, <0.2132, 93.2924, -5.4091>, <0.08864, 93.2686, -5.3638> }
				triangle { <0.2132, 93.2924, -5.4091>, <0.4956, 92.7305, -4.5416>, <0.08864, 93.2686, -5.3638> }
				triangle { <0.4956, 92.7305, -4.5416>, <0.3557, 92.7461, -4.4908>, <0.08864, 93.2686, -5.3638> }
				triangle { <0.4956, 92.7305, -4.5416>, <1.434, 91.4765, -1.5816>, <0.3557, 92.7461, -4.4908> }
				triangle { <0.3557, 92.7461, -4.4908>, <1.434, 91.4765, -1.5816>, <0.2111, 92.7776, -4.4582> }
				triangle { <0.08864, 93.2686, -5.3638>, <0.3557, 92.7461, -4.4908>, <0.2111, 92.7776, -4.4582> }
				triangle { <0.08864, 93.2686, -5.3638>, <0.2111, 92.7776, -4.4582>, <-0.03452, 93.2946, -5.3417> }
				triangle { <0.08864, 93.2686, -5.3638>, <-0.03452, 93.2946, -5.3417>, <-0.2421, 94.4949, -6.7356> }
				triangle { <1.9453, 91.00717, 0.04326>, <1.434, 91.4765, -1.5816>, <1.6498, 91.5033, -1.6149> }
				triangle { <0.2111, 92.7776, -4.4582>, <1.434, 91.4765, -1.5816>, <1.2197, 91.5735, -1.4392> }
				triangle { <0.4956, 92.7305, -4.5416>, <1.6498, 91.5033, -1.6149>, <1.434, 91.4765, -1.5816> }
				triangle { <1.9453, 91.00717, 0.04326>, <1.2197, 91.5735, -1.4392>, <1.434, 91.4765, -1.5816> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.8989, 94.349, -7.5934>, <-0.3655, 95.5904, -6.42>, 0.09177 }
				cylinder { <-0.3655, 95.5904, -6.42>, <0.1939, 96.8019, -5.2277>, 0.09177 }
				cylinder { <0.1939, 96.8019, -5.2277>, <0.7792, 97.9828, -4.0173>, 0.09177 }
				cylinder { <0.7792, 97.9828, -4.0173>, <1.3898, 99.1324, -2.7893>, 0.09177 }
				cylinder { <1.3898, 99.1324, -2.7893>, <2.0255, 100.2501, -1.5447>, 0.09177 }
				cylinder { <2.0255, 100.2501, -1.5447>, <2.6857, 101.3351, -0.284>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.6857, 101.3351, -0.284>, <2.7431, 101.4685, -0.1579>, 0.002969 }
				cylinder { <2.7431, 101.4685, -0.1579>, <2.7859, 101.6167, -0.04312>, 0.002969 }
				cylinder { <2.7859, 101.6167, -0.04312>, <2.8136, 101.7775, 0.0587>, 0.002969 }
				cylinder { <2.8136, 101.7775, 0.0587>, <2.8257, 101.9485, 0.146>, 0.002969 }
				cylinder { <2.8257, 101.9485, 0.146>, <2.8221, 102.127, 0.2174>, 0.002969 }
				cylinder { <2.8221, 102.127, 0.2174>, <2.8029, 102.3104, 0.2719>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.8029, 102.3104, 0.2719>, <2.3965, 103.5417, 1.5879>, <2.3107, 103.4649, 1.6577> }
				triangle { <2.3965, 103.5417, 1.5879>, <2.04031, 104.3086, 2.2461>, <2.3107, 103.4649, 1.6577> }
				triangle { <2.04031, 104.3086, 2.2461>, <1.9284, 104.2174, 2.2854>, <2.3107, 103.4649, 1.6577> }
				triangle { <2.04031, 104.3086, 2.2461>, <0.5675, 106.8288, 3.8876>, <1.9284, 104.2174, 2.2854> }
				triangle { <1.9284, 104.2174, 2.2854>, <0.5675, 106.8288, 3.8876>, <1.8229, 104.1106, 2.3067> }
				triangle { <2.3107, 103.4649, 1.6577>, <1.9284, 104.2174, 2.2854>, <1.8229, 104.1106, 2.3067> }
				triangle { <2.3107, 103.4649, 1.6577>, <1.8229, 104.1106, 2.3067>, <2.2258, 103.3709, 1.6752> }
				triangle { <2.3107, 103.4649, 1.6577>, <2.2258, 103.3709, 1.6752>, <2.8029, 102.3104, 0.2719> }
				triangle { <-0.3239, 108.1841, 4.5879>, <0.5675, 106.8288, 3.8876>, <0.6852, 106.9879, 3.7915> }
				triangle { <1.8229, 104.1106, 2.3067>, <0.5675, 106.8288, 3.8876>, <0.3171, 106.7155, 3.897> }
				triangle { <2.04031, 104.3086, 2.2461>, <0.6852, 106.9879, 3.7915>, <0.5675, 106.8288, 3.8876> }
				triangle { <-0.3239, 108.1841, 4.5879>, <0.3171, 106.7155, 3.897>, <0.5675, 106.8288, 3.8876> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <2.6857, 101.3351, -0.284>, <3.3539, 102.4638, 0.9332>, 0.09177 }
				cylinder { <3.3539, 102.4638, 0.9332>, <4.02918, 103.635, 2.1057>, 0.09177 }
				cylinder { <4.02918, 103.635, 2.1057>, <4.7107, 104.8472, 3.2319>, 0.09177 }
				cylinder { <4.7107, 104.8472, 3.2319>, <5.3977, 106.0989, 4.3106>, 0.09177 }
				cylinder { <5.3977, 106.0989, 4.3106>, <6.0894, 107.3887, 5.3404>, 0.09177 }
				cylinder { <6.0894, 107.3887, 5.3404>, <6.7849, 108.7149, 6.3201>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <6.7849, 108.7149, 6.3201>, <6.8708, 108.8444, 6.4333>, 0.002969 }
				cylinder { <6.8708, 108.8444, 6.4333>, <6.9671, 108.9598, 6.5534>, 0.002969 }
				cylinder { <6.9671, 108.9598, 6.5534>, <7.07275, 109.0598, 6.6793>, 0.002969 }
				cylinder { <7.07275, 109.0598, 6.6793>, <7.1868, 109.1435, 6.8096>, 0.002969 }
				cylinder { <7.1868, 109.1435, 6.8096>, <7.3081, 109.21, 6.9431>, 0.002969 }
				cylinder { <7.3081, 109.21, 6.9431>, <7.4355, 109.2589, 7.07868>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <7.4355, 109.2589, 7.07868>, <8.09421, 109.043, 8.7911>, <7.9787, 109.0053, 8.8495> }
				triangle { <8.09421, 109.043, 8.7911>, <8.4418, 109.0814, 9.804>, <7.9787, 109.0053, 8.8495> }
				triangle { <8.4418, 109.0814, 9.804>, <8.2993, 109.0738, 9.849>, <7.9787, 109.0053, 8.8495> }
				triangle { <8.4418, 109.0814, 9.804>, <9.4016, 109.7495, 12.942>, <8.2993, 109.0738, 9.849> }
				triangle { <8.2993, 109.0738, 9.849>, <9.4016, 109.7495, 12.942>, <8.1493, 109.0693, 9.8707> }
				triangle { <7.9787, 109.0053, 8.8495>, <8.2993, 109.0738, 9.849>, <8.1493, 109.0693, 9.8707> }
				triangle { <7.9787, 109.0053, 8.8495>, <8.1493, 109.0693, 9.8707>, <7.8519, 108.998, 8.8634> }
				triangle { <7.9787, 109.0053, 8.8495>, <7.8519, 108.998, 8.8634>, <7.4355, 109.2589, 7.07868> }
				triangle { <9.8579, 110.2951, 14.5594>, <9.4016, 109.7495, 12.942>, <9.6011, 109.8243, 12.8874> }
				triangle { <8.1493, 109.0693, 9.8707>, <9.4016, 109.7495, 12.942>, <9.1542, 109.8285, 13.0323> }
				triangle { <8.4418, 109.0814, 9.804>, <9.6011, 109.8243, 12.8874>, <9.4016, 109.7495, 12.942> }
				triangle { <9.8579, 110.2951, 14.5594>, <9.1542, 109.8285, 13.0323>, <9.4016, 109.7495, 12.942> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <6.7849, 108.7149, 6.3201>, <6.8538, 108.8634, 6.421>, 0.002969 }
				cylinder { <6.8538, 108.8634, 6.421>, <6.9167, 109.0175, 6.5173>, 0.002969 }
				cylinder { <6.9167, 109.0175, 6.5173>, <6.9734, 109.1769, 6.6088>, 0.002969 }
				cylinder { <6.9734, 109.1769, 6.6088>, <7.02379, 109.3412, 6.6953>, 0.002969 }
				cylinder { <7.02379, 109.3412, 6.6953>, <7.06775, 109.5099, 6.7764>, 0.002969 }
				cylinder { <7.06775, 109.5099, 6.7764>, <7.1051, 109.6827, 6.8521>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <7.1051, 109.6827, 6.8521>, <7.2297, 110.772, 8.3391>, <7.1379, 110.7087, 8.4147> }
				triangle { <7.2297, 110.772, 8.3391>, <7.1855, 111.4985, 9.1254>, <7.1379, 110.7087, 8.4147> }
				triangle { <7.1855, 111.4985, 9.1254>, <7.06068, 111.4322, 9.1743>, <7.1379, 110.7087, 8.4147> }
				triangle { <7.1855, 111.4985, 9.1254>, <6.6763, 114.0343, 11.2526>, <7.06068, 111.4322, 9.1743> }
				triangle { <7.06068, 111.4322, 9.1743>, <6.6763, 114.0343, 11.2526>, <6.9351, 111.3521, 9.2028> }
				triangle { <7.1379, 110.7087, 8.4147>, <7.06068, 111.4322, 9.1743>, <6.9351, 111.3521, 9.2028> }
				triangle { <7.1379, 110.7087, 8.4147>, <6.9351, 111.3521, 9.2028>, <7.03489, 110.6365, 8.4372> }
				triangle { <7.1379, 110.7087, 8.4147>, <7.03489, 110.6365, 8.4372>, <7.1051, 109.6827, 6.8521> }
				triangle { <6.2811, 115.4484, 12.2356>, <6.6763, 114.0343, 11.2526>, <6.8163, 114.1727, 11.1542> }
				triangle { <6.9351, 111.3521, 9.2028>, <6.6763, 114.0343, 11.2526>, <6.4092, 113.9845, 11.2944> }
				triangle { <7.1855, 111.4985, 9.1254>, <6.8163, 114.1727, 11.1542>, <6.6763, 114.0343, 11.2526> }
				triangle { <6.2811, 115.4484, 12.2356>, <6.4092, 113.9845, 11.2944>, <6.6763, 114.0343, 11.2526> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <-0.2429, 5.9271, 0.3635>, 0.09177 }
			cylinder { <-0.2429, 5.9271, 0.3635>, <-0.7273, 11.806, 1.08861>, 0.09177 }
			cylinder { <-0.7273, 11.806, 1.08861>, <-1.4508, 17.6048, 2.1713>, 0.09177 }
			cylinder { <-1.4508, 17.6048, 2.1713>, <-2.4093, 23.2921, 3.6058>, 0.09177 }
			cylinder { <-2.4093, 23.2921, 3.6058>, <-3.5976, 28.8371, 5.3842>, 0.09177 }
			cylinder { <-3.5976, 28.8371, 5.3842>, <-5.009393, 34.2098, 7.497>, 0.09177 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-5.009393, 34.2098, 7.497>, <-5.4708, 35.827, 8.1086>, 0.09177 }
				cylinder { <-5.4708, 35.827, 8.1086>, <-5.9684, 37.4427, 8.6952>, 0.09177 }
				cylinder { <-5.9684, 37.4427, 8.6952>, <-6.5018, 39.05608, 9.2565>, 0.09177 }
				cylinder { <-6.5018, 39.05608, 9.2565>, <-7.07067, 40.6659, 9.7922>, 0.09177 }
				cylinder { <-7.07067, 40.6659, 9.7922>, <-7.6746, 42.2715, 10.3019>, 0.09177 }
				cylinder { <-7.6746, 42.2715, 10.3019>, <-8.3134, 43.8717, 10.7853>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-8.3134, 43.8717, 10.7853>, <-8.363, 44.04551, 10.851>, 0.002969 }
				cylinder { <-8.363, 44.04551, 10.851>, <-8.3928, 44.2185, 10.9295>, 0.002969 }
				cylinder { <-8.3928, 44.2185, 10.9295>, <-8.4024, 44.3881, 11.01971>, 0.002969 }
				cylinder { <-8.4024, 44.3881, 11.01971>, <-8.3915, 44.5519, 11.12>, 0.002969 }
				cylinder { <-8.3915, 44.5519, 11.12>, <-8.3604, 44.7072, 11.2292>, 0.002969 }
				cylinder { <-8.3604, 44.7072, 11.2292>, <-8.3096, 44.8517, 11.3454>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-8.3096, 44.8517, 11.3454>, <-7.6085, 45.8372, 12.742>, <-7.6101, 45.9573, 12.681> }
				triangle { <-7.6085, 45.8372, 12.742>, <-7.05176, 46.369, 13.4871>, <-7.6101, 45.9573, 12.681> }
				triangle { <-7.05176, 46.369, 13.4871>, <-7.03447, 46.4805, 13.3889>, <-7.6101, 45.9573, 12.681> }
				triangle { <-7.05176, 46.369, 13.4871>, <-4.8567, 47.8368, 15.5468>, <-7.03447, 46.4805, 13.3889> }
				triangle { <-7.03447, 46.4805, 13.3889>, <-4.8567, 47.8368, 15.5468>, <-7.02657, 46.5779, 13.273> }
				triangle { <-7.6101, 45.9573, 12.681>, <-7.03447, 46.4805, 13.3889>, <-7.02657, 46.5779, 13.273> }
				triangle { <-7.6101, 45.9573, 12.681>, <-7.02657, 46.5779, 13.273>, <-7.6087, 46.03792, 12.5818> }
				triangle { <-7.6101, 45.9573, 12.681>, <-7.6087, 46.03792, 12.5818>, <-8.3096, 44.8517, 11.3454> }
				triangle { <-3.5532, 48.525, 16.5211>, <-4.8567, 47.8368, 15.5468>, <-4.8217, 47.6584, 15.6707> }
				triangle { <-7.02657, 46.5779, 13.273>, <-4.8567, 47.8368, 15.5468>, <-4.7416, 47.9986, 15.3567> }
				triangle { <-7.05176, 46.369, 13.4871>, <-4.8217, 47.6584, 15.6707>, <-4.8567, 47.8368, 15.5468> }
				triangle { <-3.5532, 48.525, 16.5211>, <-4.7416, 47.9986, 15.3567>, <-4.8567, 47.8368, 15.5468> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-8.3134, 43.8717, 10.7853>, <-8.9757, 45.4939, 11.1488>, 0.09177 }
				cylinder { <-8.9757, 45.4939, 11.1488>, <-9.658, 47.1304, 11.3905>, 0.09177 }
				cylinder { <-9.658, 47.1304, 11.3905>, <-10.3571, 48.7735, 11.5094>, 0.09177 }
				cylinder { <-10.3571, 48.7735, 11.5094>, <-11.06933, 50.4151, 11.5048>, 0.09177 }
				cylinder { <-11.06933, 50.4151, 11.5048>, <-11.7911, 52.04763, 11.3768>, 0.09177 }
				cylinder { <-11.7911, 52.04763, 11.3768>, <-12.519, 53.663, 11.1259>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-12.519, 53.663, 11.1259>, <-12.6208, 53.8183, 11.07598>, 0.002969 }
				cylinder { <-12.6208, 53.8183, 11.07598>, <-12.7424, 53.9494, 11.00494>, 0.002969 }
				cylinder { <-12.7424, 53.9494, 11.00494>, <-12.879, 54.05116, 10.9155>, 0.002969 }
				cylinder { <-12.879, 54.05116, 10.9155>, <-13.02535, 54.1196, 10.8112>, 0.002969 }
				cylinder { <-13.02535, 54.1196, 10.8112>, <-13.1758, 54.1523, 10.696>, 0.002969 }
				cylinder { <-13.1758, 54.1523, 10.696>, <-13.3247, 54.1478, 10.5743>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-13.3247, 54.1478, 10.5743>, <-14.9206, 54.508, 9.7162>, <-14.8924, 54.4456, 9.6002> }
				triangle { <-14.9206, 54.508, 9.7162>, <-15.772, 54.8596, 9.1688>, <-14.8924, 54.4456, 9.6002> }
				triangle { <-15.772, 54.8596, 9.1688>, <-15.7055, 54.813, 9.04317>, <-14.8924, 54.4456, 9.6002> }
				triangle { <-15.772, 54.8596, 9.1688>, <-18.1189, 56.4143, 7.355>, <-15.7055, 54.813, 9.04317> }
				triangle { <-15.7055, 54.813, 9.04317>, <-18.1189, 56.4143, 7.355>, <-15.6182, 54.7622, 8.93> }
				triangle { <-14.8924, 54.4456, 9.6002>, <-15.7055, 54.813, 9.04317>, <-15.6182, 54.7622, 8.93> }
				triangle { <-14.8924, 54.4456, 9.6002>, <-15.6182, 54.7622, 8.93>, <-14.8172, 54.3985, 9.5082> }
				triangle { <-14.8924, 54.4456, 9.6002>, <-14.8172, 54.3985, 9.5082>, <-13.3247, 54.1478, 10.5743> }
				triangle { <-19.225, 57.3877, 6.3798>, <-18.1189, 56.4143, 7.355>, <-18.1926, 56.5401, 7.5196> }
				triangle { <-15.6182, 54.7622, 8.93>, <-18.1189, 56.4143, 7.355>, <-17.9754, 56.4207, 7.1205> }
				triangle { <-15.772, 54.8596, 9.1688>, <-18.1926, 56.5401, 7.5196>, <-18.1189, 56.4143, 7.355> }
				triangle { <-19.225, 57.3877, 6.3798>, <-17.9754, 56.4207, 7.1205>, <-18.1189, 56.4143, 7.355> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-12.519, 53.663, 11.1259>, <-13.2672, 55.2859, 11.03181>, 0.09177 }
				cylinder { <-13.2672, 55.2859, 11.03181>, <-14.03027, 56.9033, 11.09516>, 0.09177 }
				cylinder { <-14.03027, 56.9033, 11.09516>, <-14.8023, 58.5026, 11.3154>, 0.09177 }
				cylinder { <-14.8023, 58.5026, 11.3154>, <-15.5777, 60.07112, 11.6909>, 0.09177 }
				cylinder { <-15.5777, 60.07112, 11.6909>, <-16.3505, 61.5964, 12.2187>, 0.09177 }
				cylinder { <-16.3505, 61.5964, 12.2187>, <-17.1151, 63.06647, 12.8945>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-17.1151, 63.06647, 12.8945>, <-17.1701, 63.2265, 12.9858>, 0.002969 }
				cylinder { <-17.1701, 63.2265, 12.9858>, <-17.1963, 63.3841, 13.09304>, 0.002969 }
				cylinder { <-17.1963, 63.3841, 13.09304>, <-17.193, 63.5343, 13.213>, 0.002969 }
				cylinder { <-17.193, 63.5343, 13.213>, <-17.1602, 63.673, 13.3422>, 0.002969 }
				cylinder { <-17.1602, 63.673, 13.3422>, <-17.09898, 63.7958, 13.4769>, 0.002969 }
				cylinder { <-17.09898, 63.7958, 13.4769>, <-17.01103, 63.8993, 13.6131>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-17.01103, 63.8993, 13.6131>, <-15.9748, 64.4119, 15.05417>, <-15.9681, 64.5432, 15.02487> }
				triangle { <-15.9748, 64.4119, 15.05417>, <-15.2423, 64.6725, 15.7915>, <-15.9681, 64.5432, 15.02487> }
				triangle { <-15.2423, 64.6725, 15.7915>, <-15.2239, 64.8033, 15.7212>, <-15.9681, 64.5432, 15.02487> }
				triangle { <-15.2423, 64.6725, 15.7915>, <-12.5762, 65.3235, 17.7106>, <-15.2239, 64.8033, 15.7212> }
				triangle { <-15.2239, 64.8033, 15.7212>, <-12.5762, 65.3235, 17.7106>, <-15.2193, 64.926, 15.6323> }
				triangle { <-15.9681, 64.5432, 15.02487>, <-15.2239, 64.8033, 15.7212>, <-15.2193, 64.926, 15.6323> }
				triangle { <-15.9681, 64.5432, 15.02487>, <-15.2193, 64.926, 15.6323>, <-15.9698, 64.6462, 14.9492> }
				triangle { <-15.9681, 64.5432, 15.02487>, <-15.9698, 64.6462, 14.9492>, <-17.01103, 63.8993, 13.6131> }
				triangle { <-11.05653, 65.5984, 18.569>, <-12.5762, 65.3235, 17.7106>, <-12.5493, 65.1165, 17.78> }
				triangle { <-15.2193, 64.926, 15.6323>, <-12.5762, 65.3235, 17.7106>, <-12.4685, 65.5164, 17.5469> }
				triangle { <-15.2423, 64.6725, 15.7915>, <-12.5493, 65.1165, 17.78>, <-12.5762, 65.3235, 17.7106> }
				triangle { <-11.05653, 65.5984, 18.569>, <-12.4685, 65.5164, 17.5469>, <-12.5762, 65.3235, 17.7106> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-17.1151, 63.06647, 12.8945>, <-17.8944, 64.554, 13.5126>, 0.09177 }
				cylinder { <-17.8944, 64.554, 13.5126>, <-18.6876, 66.05736, 14.07232>, 0.09177 }
				cylinder { <-18.6876, 66.05736, 14.07232>, <-19.4937, 67.5746, 14.5728>, 0.09177 }
				cylinder { <-19.4937, 67.5746, 14.5728>, <-20.3118, 69.1039, 15.01361>, 0.09177 }
				cylinder { <-20.3118, 69.1039, 15.01361>, <-21.1407, 70.6435, 15.3941>, 0.09177 }
				cylinder { <-21.1407, 70.6435, 15.3941>, <-21.9795, 72.1916, 15.7138>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-21.9795, 72.1916, 15.7138>, <-22.09207, 72.347, 15.7266>, 0.002969 }
				cylinder { <-22.09207, 72.347, 15.7266>, <-22.2237, 72.4869, 15.7174>, 0.002969 }
				cylinder { <-22.2237, 72.4869, 15.7174>, <-22.3706, 72.6072, 15.6865>, 0.002969 }
				cylinder { <-22.3706, 72.6072, 15.6865>, <-22.5284, 72.7042, 15.6348>, 0.002969 }
				cylinder { <-22.5284, 72.7042, 15.6348>, <-22.6925, 72.7752, 15.5638>, 0.002969 }
				cylinder { <-22.6925, 72.7752, 15.5638>, <-22.858, 72.818, 15.4756>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-22.858, 72.818, 15.4756>, <-24.5353, 73.4887, 15.08866>, <-24.5294, 73.4739, 14.9548> }
				triangle { <-24.5353, 73.4887, 15.08866>, <-25.4322, 74.02798, 14.8587>, <-24.5294, 73.4739, 14.9548> }
				triangle { <-25.4322, 74.02798, 14.8587>, <-25.3889, 74.03113, 14.7155>, <-24.5294, 73.4739, 14.9548> }
				triangle { <-25.4322, 74.02798, 14.8587>, <-27.9089, 76.1713, 14.1608>, <-25.3889, 74.03113, 14.7155> }
				triangle { <-25.3889, 74.03113, 14.7155>, <-27.9089, 76.1713, 14.1608>, <-25.3236, 74.02541, 14.5788> }
				triangle { <-24.5294, 73.4739, 14.9548>, <-25.3889, 74.03113, 14.7155>, <-25.3236, 74.02541, 14.5788> }
				triangle { <-24.5294, 73.4739, 14.9548>, <-25.3236, 74.02541, 14.5788>, <-24.4725, 73.4639, 14.8409> }
				triangle { <-24.5294, 73.4739, 14.9548>, <-24.4725, 73.4639, 14.8409>, <-22.858, 72.818, 15.4756> }
				triangle { <-29.07718, 77.4497, 13.8102>, <-27.9089, 76.1713, 14.1608>, <-27.9478, 76.2272, 14.37> }
				triangle { <-25.3236, 74.02541, 14.5788>, <-27.9089, 76.1713, 14.1608>, <-27.8024, 76.2634, 13.9247> }
				triangle { <-25.4322, 74.02798, 14.8587>, <-27.9478, 76.2272, 14.37>, <-27.9089, 76.1713, 14.1608> }
				triangle { <-29.07718, 77.4497, 13.8102>, <-27.8024, 76.2634, 13.9247>, <-27.9089, 76.1713, 14.1608> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-21.9795, 72.1916, 15.7138>, <-22.8271, 73.7463, 15.9725>, 0.09177 }
				cylinder { <-22.8271, 73.7463, 15.9725>, <-23.6826, 75.3056, 16.1697>, 0.09177 }
				cylinder { <-23.6826, 75.3056, 16.1697>, <-24.5448, 76.8678, 16.3052>, 0.09177 }
				cylinder { <-24.5448, 76.8678, 16.3052>, <-25.4128, 78.431, 16.379>, 0.09177 }
				cylinder { <-25.4128, 78.431, 16.379>, <-26.2854, 79.9933, 16.3907>, 0.09177 }
				cylinder { <-26.2854, 79.9933, 16.3907>, <-27.1617, 81.5528, 16.3406>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-27.1617, 81.5528, 16.3406>, <-27.2431, 81.7269, 16.3475>, 0.002969 }
				cylinder { <-27.2431, 81.7269, 16.3475>, <-27.3111, 81.9058, 16.3668>, 0.002969 }
				cylinder { <-27.3111, 81.9058, 16.3668>, <-27.3649, 82.08781, 16.3981>, 0.002969 }
				cylinder { <-27.3649, 82.08781, 16.3981>, <-27.404, 82.2711, 16.4413>, 0.002969 }
				cylinder { <-27.404, 82.2711, 16.4413>, <-27.4281, 82.4539, 16.4958>, 0.002969 }
				cylinder { <-27.4281, 82.4539, 16.4958>, <-27.4369, 82.6346, 16.5612>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-27.4369, 82.6346, 16.5612>, <-27.3115, 84.1401, 17.6246>, <-27.3211, 84.2317, 17.5262> }
				triangle { <-27.3115, 84.1401, 17.6246>, <-27.07237, 84.9975, 18.221>, <-27.3211, 84.2317, 17.5262> }
				triangle { <-27.07237, 84.9975, 18.221>, <-27.05315, 85.07522, 18.09465>, <-27.3211, 84.2317, 17.5262> }
				triangle { <-27.07237, 84.9975, 18.221>, <-25.7886, 87.54, 19.9825>, <-27.05315, 85.07522, 18.09465> }
				triangle { <-27.05315, 85.07522, 18.09465>, <-25.7886, 87.54, 19.9825>, <-27.03567, 85.132, 17.9551> }
				triangle { <-27.3211, 84.2317, 17.5262>, <-27.05315, 85.07522, 18.09465>, <-27.03567, 85.132, 17.9551> }
				triangle { <-27.3211, 84.2317, 17.5262>, <-27.03567, 85.132, 17.9551>, <-27.3107, 84.2764, 17.407> }
				triangle { <-27.3211, 84.2317, 17.5262>, <-27.3107, 84.2764, 17.407>, <-27.4369, 82.6346, 16.5612> }
				triangle { <-24.9284, 88.8076, 20.863>, <-25.7886, 87.54, 19.9825>, <-25.7516, 87.4226, 20.1648> }
				triangle { <-27.03567, 85.132, 17.9551>, <-25.7886, 87.54, 19.9825>, <-25.6633, 87.6624, 19.7705> }
				triangle { <-27.07237, 84.9975, 18.221>, <-25.7516, 87.4226, 20.1648>, <-25.7886, 87.54, 19.9825> }
				triangle { <-24.9284, 88.8076, 20.863>, <-25.6633, 87.6624, 19.7705>, <-25.7886, 87.54, 19.9825> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-27.1617, 81.5528, 16.3406>, <-28.02976, 83.1159, 16.4143>, 0.09177 }
				cylinder { <-28.02976, 83.1159, 16.4143>, <-28.8856, 84.6751, 16.6115>, 0.09177 }
				cylinder { <-28.8856, 84.6751, 16.6115>, <-29.7253, 86.2226, 16.9313>, 0.09177 }
				cylinder { <-29.7253, 86.2226, 16.9313>, <-30.5448, 87.7511, 17.3721>, 0.09177 }
				cylinder { <-30.5448, 87.7511, 17.3721>, <-31.3405, 89.2531, 17.9319>, 0.09177 }
				cylinder { <-31.3405, 89.2531, 17.9319>, <-32.1085, 90.7213, 18.6079>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-32.1085, 90.7213, 18.6079>, <-32.2055, 90.8759, 18.6687>, 0.002969 }
				cylinder { <-32.2055, 90.8759, 18.6687>, <-32.3158, 91.02576, 18.7172>, 0.002969 }
				cylinder { <-32.3158, 91.02576, 18.7172>, <-32.4386, 91.1694, 18.7528>, 0.002969 }
				cylinder { <-32.4386, 91.1694, 18.7528>, <-32.5726, 91.3056, 18.7753>, 0.002969 }
				cylinder { <-32.5726, 91.3056, 18.7753>, <-32.7164, 91.4329, 18.7843>, 0.002969 }
				cylinder { <-32.7164, 91.4329, 18.7843>, <-32.8688, 91.5502, 18.7799>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-32.8688, 91.5502, 18.7799>, <-34.2086, 92.7302, 19.2547>, <-34.2394, 92.7723, 19.1305> }
				triangle { <-34.2086, 92.7302, 19.2547>, <-34.862, 93.5278, 19.5462>, <-34.2394, 92.7723, 19.1305> }
				triangle { <-34.862, 93.5278, 19.5462>, <-34.8546, 93.5798, 19.4061>, <-34.2394, 92.7723, 19.1305> }
				triangle { <-34.862, 93.5278, 19.5462>, <-36.4333, 96.3254, 20.5052>, <-34.8546, 93.5798, 19.4061> }
				triangle { <-34.8546, 93.5798, 19.4061>, <-36.4333, 96.3254, 20.5052>, <-34.8294, 93.6156, 19.261> }
				triangle { <-34.2394, 92.7723, 19.1305>, <-34.8546, 93.5798, 19.4061>, <-34.8294, 93.6156, 19.261> }
				triangle { <-34.2394, 92.7723, 19.1305>, <-34.8294, 93.6156, 19.261>, <-34.2181, 92.797, 19.007> }
				triangle { <-34.2394, 92.7723, 19.1305>, <-34.2181, 92.797, 19.007>, <-32.8688, 91.5502, 18.7799> }
				triangle { <-37.07836, 97.8864, 21.02419>, <-36.4333, 96.3254, 20.5052>, <-36.3994, 96.2957, 20.7205> }
				triangle { <-34.8294, 93.6156, 19.261>, <-36.4333, 96.3254, 20.5052>, <-36.3568, 96.4776, 20.2893> }
				triangle { <-34.862, 93.5278, 19.5462>, <-36.3994, 96.2957, 20.7205>, <-36.4333, 96.3254, 20.5052> }
				triangle { <-37.07836, 97.8864, 21.02419>, <-36.3568, 96.4776, 20.2893>, <-36.4333, 96.3254, 20.5052> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-32.1085, 90.7213, 18.6079>, <-32.9108, 92.1833, 19.257>, 0.09177 }
				cylinder { <-32.9108, 92.1833, 19.257>, <-33.7467, 93.6382, 19.8789>, 0.09177 }
				cylinder { <-33.7467, 93.6382, 19.8789>, <-34.6158, 95.08522, 20.4731>, 0.09177 }
				cylinder { <-34.6158, 95.08522, 20.4731>, <-35.5177, 96.5234, 21.03946>, 0.09177 }
				cylinder { <-35.5177, 96.5234, 21.03946>, <-36.4516, 97.9519, 21.5774>, 0.09177 }
				cylinder { <-36.4516, 97.9519, 21.5774>, <-37.4172, 99.3699, 22.08668>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-37.4172, 99.3699, 22.08668>, <-37.507, 99.5262, 22.1535>, 0.002969 }
				cylinder { <-37.507, 99.5262, 22.1535>, <-37.5821, 99.6851, 22.2318>, 0.002969 }
				cylinder { <-37.5821, 99.6851, 22.2318>, <-37.6416, 99.8449, 22.3208>, 0.002969 }
				cylinder { <-37.6416, 99.8449, 22.3208>, <-37.685, 100.0041, 22.4196>, 0.002969 }
				cylinder { <-37.685, 100.0041, 22.4196>, <-37.712, 100.1611, 22.5274>, 0.002969 }
				cylinder { <-37.712, 100.1611, 22.5274>, <-37.7221, 100.3145, 22.643>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-37.7221, 100.3145, 22.643>, <-37.5368, 101.467, 24.07492>, <-37.5657, 101.581, 24.00927> }
				triangle { <-37.5368, 101.467, 24.07492>, <-37.2669, 102.1423, 24.8618>, <-37.5657, 101.581, 24.00927> }
				triangle { <-37.2669, 102.1423, 24.8618>, <-37.2705, 102.2537, 24.762>, <-37.5657, 101.581, 24.00927> }
				triangle { <-37.2669, 102.1423, 24.8618>, <-35.8997, 104.2028, 27.1201>, <-37.2705, 102.2537, 24.762> }
				triangle { <-37.2705, 102.2537, 24.762>, <-35.8997, 104.2028, 27.1201>, <-37.2763, 102.3488, 24.644> }
				triangle { <-37.5657, 101.581, 24.00927>, <-37.2705, 102.2537, 24.762>, <-37.2763, 102.3488, 24.644> }
				triangle { <-37.5657, 101.581, 24.00927>, <-37.2763, 102.3488, 24.644>, <-37.5751, 101.6582, 23.9078> }
				triangle { <-37.5657, 101.581, 24.00927>, <-37.5751, 101.6582, 23.9078>, <-37.7221, 100.3145, 22.643> }
				triangle { <-35.00028, 105.2509, 28.2221>, <-35.8997, 104.2028, 27.1201>, <-35.8303, 104.0433, 27.2547> }
				triangle { <-37.2763, 102.3488, 24.644>, <-35.8997, 104.2028, 27.1201>, <-35.8133, 104.3913, 26.9394> }
				triangle { <-37.2669, 102.1423, 24.8618>, <-35.8303, 104.0433, 27.2547>, <-35.8997, 104.2028, 27.1201> }
				triangle { <-35.00028, 105.2509, 28.2221>, <-35.8133, 104.3913, 26.9394>, <-35.8997, 104.2028, 27.1201> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-37.4172, 99.3699, 22.08668>, <-38.3894, 100.7478, 22.6853>, 0.09177 }
				cylinder { <-38.3894, 100.7478, 22.6853>, <-39.3655, 102.0815, 23.3716>, 0.09177 }
				cylinder { <-39.3655, 102.0815, 23.3716>, <-40.3425, 103.3669, 24.1433>, 0.09177 }
				cylinder { <-40.3425, 103.3669, 24.1433>, <-41.3175, 104.6001, 24.9982>, 0.09177 }
				cylinder { <-41.3175, 104.6001, 24.9982>, <-42.2878, 105.7774, 25.9336>, 0.09177 }
				cylinder { <-42.2878, 105.7774, 25.9336>, <-43.2503, 106.8951, 26.9468>, 0.09177 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-43.2503, 106.8951, 26.9468>, <-43.3681, 107.012, 27.04401>, 0.002969 }
				cylinder { <-43.3681, 107.012, 27.04401>, <-43.4993, 107.1245, 27.1284>, 0.002969 }
				cylinder { <-43.4993, 107.1245, 27.1284>, <-43.6424, 107.2316, 27.1994>, 0.002969 }
				cylinder { <-43.6424, 107.2316, 27.1994>, <-43.7962, 107.3321, 27.2562>, 0.002969 }
				cylinder { <-43.7962, 107.3321, 27.2562>, <-43.9592, 107.4252, 27.2983>, 0.002969 }
				cylinder { <-43.9592, 107.4252, 27.2983>, <-44.1297, 107.51, 27.3253>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-44.1297, 107.51, 27.3253>, <-45.6176, 108.2875, 28.09647>, <-45.6644, 108.3487, 27.9859> }
				triangle { <-45.6176, 108.2875, 28.09647>, <-46.3779, 108.8667, 28.5808>, <-45.6644, 108.3487, 27.9859> }
				triangle { <-46.3779, 108.8667, 28.5808>, <-46.3901, 108.948, 28.4558>, <-45.6644, 108.3487, 27.9859> }
				triangle { <-46.3779, 108.8667, 28.5808>, <-48.3419, 111.0471, 30.1943>, <-46.3901, 108.948, 28.4558> }
				triangle { <-46.3901, 108.948, 28.4558>, <-48.3419, 111.0471, 30.1943>, <-46.3822, 109.0182, 28.3217> }
				triangle { <-45.6644, 108.3487, 27.9859>, <-46.3901, 108.948, 28.4558>, <-46.3822, 109.0182, 28.3217> }
				triangle { <-45.6644, 108.3487, 27.9859>, <-46.3822, 109.0182, 28.3217>, <-45.6569, 108.403, 27.8705> }
				triangle { <-45.6644, 108.3487, 27.9859>, <-45.6569, 108.403, 27.8705>, <-44.1297, 107.51, 27.3253> }
				triangle { <-49.2115, 112.3106, 31.07143>, <-48.3419, 111.0471, 30.1943>, <-48.2876, 110.9788, 30.3962> }
				triangle { <-46.3822, 109.0182, 28.3217>, <-48.3419, 111.0471, 30.1943>, <-48.3094, 111.2537, 30.01583> }
				triangle { <-46.3779, 108.8667, 28.5808>, <-48.2876, 110.9788, 30.3962>, <-48.3419, 111.0471, 30.1943> }
				triangle { <-49.2115, 112.3106, 31.07143>, <-48.3094, 111.2537, 30.01583>, <-48.3419, 111.0471, 30.1943> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-43.2503, 106.8951, 26.9468>, <-43.3646, 107.0129, 27.04704>, 0.002969 }
				cylinder { <-43.3646, 107.0129, 27.04704>, <-43.4893, 107.1278, 27.1379>, 0.002969 }
				cylinder { <-43.4893, 107.1278, 27.1379>, <-43.6235, 107.239, 27.2191>, 0.002969 }
				cylinder { <-43.6235, 107.239, 27.2191>, <-43.7667, 107.3461, 27.2901>, 0.002969 }
				cylinder { <-43.7667, 107.3461, 27.2901>, <-43.918, 107.4483, 27.3505>, 0.002969 }
				cylinder { <-43.918, 107.4483, 27.3505>, <-44.07659, 107.5453, 27.4>, 0.002969 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-44.07659, 107.5453, 27.4>, <-45.3972, 108.4037, 28.3654>, <-45.4505, 108.4737, 28.2634> }
				triangle { <-45.3972, 108.4037, 28.3654>, <-46.04648, 109.0191, 28.9553>, <-45.4505, 108.4737, 28.2634> }
				triangle { <-46.04648, 109.0191, 28.9553>, <-46.06536, 109.1069, 28.8357>, <-45.4505, 108.4737, 28.2634> }
				triangle { <-46.04648, 109.0191, 28.9553>, <-47.6243, 111.2727, 30.8647>, <-46.06536, 109.1069, 28.8357> }
				triangle { <-46.06536, 109.1069, 28.8357>, <-47.6243, 111.2727, 30.8647>, <-46.0664, 109.1826, 28.7043> }
				triangle { <-45.4505, 108.4737, 28.2634>, <-46.06536, 109.1069, 28.8357>, <-46.0664, 109.1826, 28.7043> }
				triangle { <-45.4505, 108.4737, 28.2634>, <-46.0664, 109.1826, 28.7043>, <-45.4512, 108.5325, 28.15> }
				triangle { <-45.4505, 108.4737, 28.2634>, <-45.4512, 108.5325, 28.15>, <-44.07659, 107.5453, 27.4> }
				triangle { <-48.2792, 112.5597, 31.883>, <-47.6243, 111.2727, 30.8647>, <-47.554, 111.1907, 31.05641> }
				triangle { <-46.0664, 109.1826, 28.7043>, <-47.6243, 111.2727, 30.8647>, <-47.5941, 111.4843, 30.6917> }
				triangle { <-46.04648, 109.0191, 28.9553>, <-47.554, 111.1907, 31.05641>, <-47.6243, 111.2727, 30.8647> }
				triangle { <-48.2792, 112.5597, 31.883>, <-47.5941, 111.4843, 30.6917>, <-47.6243, 111.2727, 30.8647> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.08238, 3.7124, -0.03896>, 0.05734 }
			cylinder { <0.08238, 3.7124, -0.03896>, <0.2471, 7.4216, -0.1168>, 0.05734 }
			cylinder { <0.2471, 7.4216, -0.1168>, <0.494, 11.1251, -0.2336>, 0.05734 }
			cylinder { <0.494, 11.1251, -0.2336>, <0.8231, 14.8209, -0.3893>, 0.05734 }
			cylinder { <0.8231, 14.8209, -0.3893>, <1.234, 18.5066, -0.5836>, 0.05734 }
			cylinder { <1.234, 18.5066, -0.5836>, <1.7266, 22.18, -0.8166>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <1.7266, 22.18, -0.8166>, <1.8373, 23.2924, -0.8387>, 0.05734 }
				cylinder { <1.8373, 23.2924, -0.8387>, <1.9102, 24.4079, -0.8126>, 0.05734 }
				cylinder { <1.9102, 24.4079, -0.8126>, <1.9448, 25.5231, -0.7385>, 0.05734 }
				cylinder { <1.9448, 25.5231, -0.7385>, <1.9412, 26.6346, -0.6166>, 0.05734 }
				cylinder { <1.9412, 26.6346, -0.6166>, <1.8992, 27.7391, -0.4473>, 0.05734 }
				cylinder { <1.8992, 27.7391, -0.4473>, <1.8189, 28.8332, -0.2312>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.8189, 28.8332, -0.2312>, <1.819, 28.9037, -0.2054>, 0.001159 }
				cylinder { <1.819, 28.9037, -0.2054>, <1.8246, 28.9692, -0.1691>, 0.001159 }
				cylinder { <1.8246, 28.9692, -0.1691>, <1.8354, 29.02779, -0.1233>, 0.001159 }
				cylinder { <1.8354, 29.02779, -0.1233>, <1.8512, 29.07763, -0.06944>, 0.001159 }
				cylinder { <1.8512, 29.07763, -0.06944>, <1.8716, 29.1173, -0.009026>, 0.001159 }
				cylinder { <1.8716, 29.1173, -0.009026>, <1.8959, 29.1456, 0.05613>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.8959, 29.1456, 0.05613>, <2.5562, 29.8769, 0.6575>, <2.6188, 29.8835, 0.6016> }
				triangle { <2.5562, 29.8769, 0.6575>, <2.9807, 30.2148, 1.04989>, <2.6188, 29.8835, 0.6016> }
				triangle { <2.9807, 30.2148, 1.04989>, <3.04864, 30.1959, 0.9884>, <2.6188, 29.8835, 0.6016> }
				triangle { <2.9807, 30.2148, 1.04989>, <4.4012, 30.9538, 2.3969>, <3.04864, 30.1959, 0.9884> }
				triangle { <3.04864, 30.1959, 0.9884>, <4.4012, 30.9538, 2.3969>, <3.1071, 30.1674, 0.9196> }
				triangle { <2.6188, 29.8835, 0.6016>, <3.04864, 30.1959, 0.9884>, <3.1071, 30.1674, 0.9196> }
				triangle { <2.6188, 29.8835, 0.6016>, <3.1071, 30.1674, 0.9196>, <2.6655, 29.86, 0.5412> }
				triangle { <2.6188, 29.8835, 0.6016>, <2.6655, 29.86, 0.5412>, <1.8959, 29.1456, 0.05613> }
				triangle { <5.1705, 31.2231, 3.1416>, <4.4012, 30.9538, 2.3969>, <4.3185, 30.9499, 2.5066> }
				triangle { <3.1071, 30.1674, 0.9196>, <4.4012, 30.9538, 2.3969>, <4.5369, 30.8774, 2.3243> }
				triangle { <2.9807, 30.2148, 1.04989>, <4.3185, 30.9499, 2.5066>, <4.4012, 30.9538, 2.3969> }
				triangle { <5.1705, 31.2231, 3.1416>, <4.5369, 30.8774, 2.3243>, <4.4012, 30.9538, 2.3969> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <1.8189, 28.8332, -0.2312>, <1.7406, 29.9377, -0.07556>, 0.05734 }
				cylinder { <1.7406, 29.9377, -0.07556>, <1.6645, 31.04931, 0.01921>, 0.05734 }
				cylinder { <1.6645, 31.04931, 0.01921>, <1.5909, 32.1645, 0.0528>, 0.05734 }
				cylinder { <1.5909, 32.1645, 0.0528>, <1.52, 33.2801, 0.02509>, 0.05734 }
				cylinder { <1.52, 33.2801, 0.02509>, <1.4521, 34.3926, -0.06381>, 0.05734 }
				cylinder { <1.4521, 34.3926, -0.06381>, <1.3874, 35.4988, -0.2136>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <1.3874, 35.4988, -0.2136>, <1.378, 35.5701, -0.2352>, 0.001159 }
				cylinder { <1.378, 35.5701, -0.2352>, <1.3638, 35.6364, -0.2676>, 0.001159 }
				cylinder { <1.3638, 35.6364, -0.2676>, <1.3454, 35.6956, -0.3099>, 0.001159 }
				cylinder { <1.3454, 35.6956, -0.3099>, <1.3231, 35.7461, -0.3608>, 0.001159 }
				cylinder { <1.3231, 35.7461, -0.3608>, <1.2976, 35.7863, -0.4189>, 0.001159 }
				cylinder { <1.2976, 35.7863, -0.4189>, <1.2698, 35.8151, -0.4824>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <1.2698, 35.8151, -0.4824>, <1.2717, 35.9177, -1.6322>, <1.3537, 35.903, -1.6443> }
				triangle { <1.2717, 35.9177, -1.6322>, <1.2888, 36.0798, -2.2816>, <1.3537, 35.903, -1.6443> }
				triangle { <1.2888, 36.0798, -2.2816>, <1.3821, 36.0816, -2.2762>, <1.3537, 35.903, -1.6443> }
				triangle { <1.2888, 36.0798, -2.2816>, <1.382, 36.9166, -4.1972>, <1.3821, 36.0816, -2.2762> }
				triangle { <1.3821, 36.0816, -2.2762>, <1.382, 36.9166, -4.1972>, <1.4745, 36.08207, -2.2554> }
				triangle { <1.3537, 35.903, -1.6443>, <1.3821, 36.0816, -2.2762>, <1.4745, 36.08207, -2.2554> }
				triangle { <1.3537, 35.903, -1.6443>, <1.4745, 36.08207, -2.2554>, <1.4311, 35.9007, -1.6246> }
				triangle { <1.3537, 35.903, -1.6443>, <1.4311, 35.9007, -1.6246>, <1.2698, 35.8151, -0.4824> }
				triangle { <1.4421, 37.4706, -5.1503>, <1.382, 36.9166, -4.1972>, <1.2499, 36.9543, -4.2015> }
				triangle { <1.4745, 36.08207, -2.2554>, <1.382, 36.9166, -4.1972>, <1.542, 36.9776, -4.1829> }
				triangle { <1.2888, 36.0798, -2.2816>, <1.2499, 36.9543, -4.2015>, <1.382, 36.9166, -4.1972> }
				triangle { <1.4421, 37.4706, -5.1503>, <1.542, 36.9776, -4.1829>, <1.382, 36.9166, -4.1972> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <1.3874, 35.4988, -0.2136>, <1.2834, 36.6074, -0.3164>, 0.05734 }
				cylinder { <1.2834, 36.6074, -0.3164>, <1.1404, 37.715, -0.3718>, 0.05734 }
				cylinder { <1.1404, 37.715, -0.3718>, <0.9588, 38.8183, -0.3797>, 0.05734 }
				cylinder { <0.9588, 38.8183, -0.3797>, <0.7392, 39.914, -0.3401>, 0.05734 }
				cylinder { <0.7392, 39.914, -0.3401>, <0.4822, 40.9987, -0.2531>, 0.05734 }
				cylinder { <0.4822, 40.9987, -0.2531>, <0.1884, 42.06929, -0.119>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.1884, 42.06929, -0.119>, <0.1735, 42.1404, -0.1001>, 0.001159 }
				cylinder { <0.1735, 42.1404, -0.1001>, <0.1637, 42.2092, -0.07172>, 0.001159 }
				cylinder { <0.1637, 42.2092, -0.07172>, <0.1593, 42.2742, -0.03441>, 0.001159 }
				cylinder { <0.1593, 42.2742, -0.03441>, <0.1604, 42.334, 0.01097>, 0.001159 }
				cylinder { <0.1604, 42.334, 0.01097>, <0.1668, 42.3873, 0.06346>, 0.001159 }
				cylinder { <0.1668, 42.3873, 0.06346>, <0.1785, 42.433, 0.1219>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.1785, 42.433, 0.1219>, <0.595, 43.4097, 0.5747>, <0.6581, 43.4209, 0.5201> }
				triangle { <0.595, 43.4097, 0.5747>, <0.8944, 43.9133, 0.8987>, <0.6581, 43.4209, 0.5201> }
				triangle { <0.8944, 43.9133, 0.8987>, <0.9693, 43.9007, 0.8442>, <0.6581, 43.4209, 0.5201> }
				triangle { <0.8944, 43.9133, 0.8987>, <1.9887, 45.2341, 2.09738>, <0.9693, 43.9007, 0.8442> }
				triangle { <0.9693, 43.9007, 0.8442>, <1.9887, 45.2341, 2.09738>, <1.03795, 43.8751, 0.7841> }
				triangle { <0.6581, 43.4209, 0.5201>, <0.9693, 43.9007, 0.8442>, <1.03795, 43.8751, 0.7841> }
				triangle { <0.6581, 43.4209, 0.5201>, <1.03795, 43.8751, 0.7841>, <0.7135, 43.3987, 0.4671> }
				triangle { <0.6581, 43.4209, 0.5201>, <0.7135, 43.3987, 0.4671>, <0.1785, 42.433, 0.1219> }
				triangle { <2.6121, 45.8283, 2.7883>, <1.9887, 45.2341, 2.09738>, <1.9015, 45.2308, 2.2035> }
				triangle { <1.03795, 43.8751, 0.7841>, <1.9887, 45.2341, 2.09738>, <2.1439, 45.1819, 2.04534> }
				triangle { <0.8944, 43.9133, 0.8987>, <1.9015, 45.2308, 2.2035>, <1.9887, 45.2341, 2.09738> }
				triangle { <2.6121, 45.8283, 2.7883>, <2.1439, 45.1819, 2.04534>, <1.9887, 45.2341, 2.09738> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.1884, 42.06929, -0.119>, <-0.1293, 43.1214, 0.08641>, 0.05734 }
				cylinder { <-0.1293, 43.1214, 0.08641>, <-0.4699, 44.1501, 0.3623>, 0.05734 }
				cylinder { <-0.4699, 44.1501, 0.3623>, <-0.8315, 45.1504, 0.7072>, 0.05734 }
				cylinder { <-0.8315, 45.1504, 0.7072>, <-1.2126, 46.1174, 1.1194>, 0.05734 }
				cylinder { <-1.2126, 46.1174, 1.1194>, <-1.6115, 47.04646, 1.597>, 0.05734 }
				cylinder { <-1.6115, 47.04646, 1.597>, <-2.02624, 47.933, 2.1376>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-2.02624, 47.933, 2.1376>, <-2.05769, 47.9942, 2.1677>, 0.001159 }
				cylinder { <-2.05769, 47.9942, 2.1677>, <-2.09242, 48.05655, 2.1913>, 0.001159 }
				cylinder { <-2.09242, 48.05655, 2.1913>, <-2.1301, 48.1192, 2.2081>, 0.001159 }
				cylinder { <-2.1301, 48.1192, 2.2081>, <-2.1703, 48.1818, 2.218>, 0.001159 }
				cylinder { <-2.1703, 48.1818, 2.218>, <-2.2128, 48.2437, 2.221>, 0.001159 }
				cylinder { <-2.2128, 48.2437, 2.221>, <-2.2571, 48.3042, 2.2169>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-2.2571, 48.3042, 2.2169>, <-2.5593, 49.3054, 1.7282>, <-2.483, 49.3273, 1.7004> }
				triangle { <-2.5593, 49.3054, 1.7282>, <-2.7175, 49.928, 1.5397>, <-2.483, 49.3273, 1.7004> }
				triangle { <-2.7175, 49.928, 1.5397>, <-2.6261, 49.9468, 1.5336>, <-2.483, 49.3273, 1.7004> }
				triangle { <-2.7175, 49.928, 1.5397>, <-3.1527, 51.9591, 1.2868>, <-2.6261, 49.9468, 1.5336> }
				triangle { <-2.6261, 49.9468, 1.5336>, <-3.1527, 51.9591, 1.2868>, <-2.5315, 49.952, 1.5341> }
				triangle { <-2.483, 49.3273, 1.7004>, <-2.6261, 49.9468, 1.5336>, <-2.5315, 49.952, 1.5341> }
				triangle { <-2.483, 49.3273, 1.7004>, <-2.5315, 49.952, 1.5341>, <-2.4031, 49.3284, 1.6997> }
				triangle { <-2.483, 49.3273, 1.7004>, <-2.4031, 49.3284, 1.6997>, <-2.2571, 48.3042, 2.2169> }
				triangle { <-3.3599, 53.04354, 1.2775>, <-3.1527, 51.9591, 1.2868>, <-3.2824, 51.9504, 1.3317> }
				triangle { <-2.5315, 49.952, 1.5341>, <-3.1527, 51.9591, 1.2868>, <-2.9964, 52.0168, 1.3285> }
				triangle { <-2.7175, 49.928, 1.5397>, <-3.2824, 51.9504, 1.3317>, <-3.1527, 51.9591, 1.2868> }
				triangle { <-3.3599, 53.04354, 1.2775>, <-2.9964, 52.0168, 1.3285>, <-3.1527, 51.9591, 1.2868> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-2.02624, 47.933, 2.1376>, <-2.4481, 48.7968, 2.7087>, 0.05734 }
				cylinder { <-2.4481, 48.7968, 2.7087>, <-2.8768, 49.6367, 3.3096>, 0.05734 }
				cylinder { <-2.8768, 49.6367, 3.3096>, <-3.3117, 50.4517, 3.9397>, 0.05734 }
				cylinder { <-3.3117, 50.4517, 3.9397>, <-3.7523, 51.2408, 4.5981>, 0.05734 }
				cylinder { <-3.7523, 51.2408, 4.5981>, <-4.1981, 52.00312, 5.284>, 0.05734 }
				cylinder { <-4.1981, 52.00312, 5.284>, <-4.6485, 52.7376, 5.9967>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-4.6485, 52.7376, 5.9967>, <-4.6722, 52.7823, 6.05223>, 0.001159 }
				cylinder { <-4.6722, 52.7823, 6.05223>, <-4.6889, 52.8214, 6.1141>, 0.001159 }
				cylinder { <-4.6889, 52.8214, 6.1141>, <-4.6982, 52.854, 6.1811>, 0.001159 }
				cylinder { <-4.6982, 52.854, 6.1811>, <-4.6999, 52.8795, 6.2517>, 0.001159 }
				cylinder { <-4.6999, 52.8795, 6.2517>, <-4.694, 52.8973, 6.3244>, 0.001159 }
				cylinder { <-4.694, 52.8973, 6.3244>, <-4.6805, 52.907, 6.3976>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-4.6805, 52.907, 6.3976>, <-4.371, 53.5708, 7.2899>, <-4.3213, 53.6237, 7.2473> }
				triangle { <-4.371, 53.5708, 7.2899>, <-4.1137, 53.8863, 7.8214>, <-4.3213, 53.6237, 7.2473> }
				triangle { <-4.1137, 53.8863, 7.8214>, <-4.04843, 53.9226, 7.7652>, <-4.3213, 53.6237, 7.2473> }
				triangle { <-4.1137, 53.8863, 7.8214>, <-3.07889, 54.6068, 9.4914>, <-4.04843, 53.9226, 7.7652> }
				triangle { <-4.04843, 53.9226, 7.7652>, <-3.07889, 54.6068, 9.4914>, <-3.9878, 53.9496, 7.6976> }
				triangle { <-4.3213, 53.6237, 7.2473>, <-4.04843, 53.9226, 7.7652>, <-3.9878, 53.9496, 7.6976> }
				triangle { <-4.3213, 53.6237, 7.2473>, <-3.9878, 53.9496, 7.6976>, <-4.2729, 53.6466, 7.1881> }
				triangle { <-4.3213, 53.6237, 7.2473>, <-4.2729, 53.6466, 7.1881>, <-4.6805, 52.907, 6.3976> }
				triangle { <-2.46, 54.8835, 10.3628>, <-3.07889, 54.6068, 9.4914>, <-3.1444, 54.5276, 9.5826> }
				triangle { <-3.9878, 53.9496, 7.6976>, <-3.07889, 54.6068, 9.4914>, <-2.9283, 54.6289, 9.4116> }
				triangle { <-4.1137, 53.8863, 7.8214>, <-3.1444, 54.5276, 9.5826>, <-3.07889, 54.6068, 9.4914> }
				triangle { <-2.46, 54.8835, 10.3628>, <-2.9283, 54.6289, 9.4116>, <-3.07889, 54.6068, 9.4914> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-4.6485, 52.7376, 5.9967>, <-5.09897, 53.4721, 6.7094>, 0.05734 }
				cylinder { <-5.09897, 53.4721, 6.7094>, <-5.5494, 54.2066, 7.422>, 0.05734 }
				cylinder { <-5.5494, 54.2066, 7.422>, <-5.9998, 54.9411, 8.1347>, 0.05734 }
				cylinder { <-5.9998, 54.9411, 8.1347>, <-6.4502, 55.6757, 8.8474>, 0.05734 }
				cylinder { <-6.4502, 55.6757, 8.8474>, <-6.9007, 56.4102, 9.56>, 0.05734 }
				cylinder { <-6.9007, 56.4102, 9.56>, <-7.3511, 57.1447, 10.2727>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-7.3511, 57.1447, 10.2727>, <-7.3872, 57.1976, 10.3119>, 0.001159 }
				cylinder { <-7.3872, 57.1976, 10.3119>, <-7.4284, 57.2529, 10.3416>, 0.001159 }
				cylinder { <-7.4284, 57.2529, 10.3416>, <-7.4738, 57.3094, 10.3612>, 0.001159 }
				cylinder { <-7.4738, 57.3094, 10.3612>, <-7.5224, 57.366, 10.3701>, 0.001159 }
				cylinder { <-7.5224, 57.366, 10.3701>, <-7.5732, 57.4213, 10.3684>, 0.001159 }
				cylinder { <-7.5732, 57.4213, 10.3684>, <-7.625, 57.4742, 10.3558>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-7.625, 57.4742, 10.3558>, <-8.002514, 58.4064, 9.7892>, <-7.9271, 58.4392, 9.771> }
				triangle { <-8.002514, 58.4064, 9.7892>, <-8.2241, 58.9932, 9.5551>, <-7.9271, 58.4392, 9.771> }
				triangle { <-8.2241, 58.9932, 9.5551>, <-8.1366, 59.02565, 9.5605>, <-7.9271, 58.4392, 9.771> }
				triangle { <-8.2241, 58.9932, 9.5551>, <-8.9184, 60.9274, 9.1607>, <-8.1366, 59.02565, 9.5605> }
				triangle { <-8.1366, 59.02565, 9.5605>, <-8.9184, 60.9274, 9.1607>, <-8.04486, 59.04536, 9.5735> }
				triangle { <-7.9271, 58.4392, 9.771>, <-8.1366, 59.02565, 9.5605>, <-8.04486, 59.04536, 9.5735> }
				triangle { <-7.9271, 58.4392, 9.771>, <-8.04486, 59.04536, 9.5735>, <-7.849, 58.4526, 9.7809> }
				triangle { <-7.9271, 58.4392, 9.771>, <-7.849, 58.4526, 9.7809>, <-7.625, 57.4742, 10.3558> }
				triangle { <-9.2818, 61.9666, 9.0781>, <-8.9184, 60.9274, 9.1607>, <-9.05028, 60.8998, 9.1882> }
				triangle { <-8.04486, 59.04536, 9.5735>, <-8.9184, 60.9274, 9.1607>, <-8.7797, 61.00929, 9.2206> }
				triangle { <-8.2241, 58.9932, 9.5551>, <-9.05028, 60.8998, 9.1882>, <-8.9184, 60.9274, 9.1607> }
				triangle { <-9.2818, 61.9666, 9.0781>, <-8.7797, 61.00929, 9.2206>, <-8.9184, 60.9274, 9.1607> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-7.3511, 57.1447, 10.2727>, <-7.8212, 57.861, 10.9912>, 0.05734 }
				cylinder { <-7.8212, 57.861, 10.9912>, <-8.3108, 58.5586, 11.715>, 0.05734 }
				cylinder { <-8.3108, 58.5586, 11.715>, <-8.8194, 59.2372, 12.4438>, 0.05734 }
				cylinder { <-8.8194, 59.2372, 12.4438>, <-9.3468, 59.8963, 13.1771>, 0.05734 }
				cylinder { <-9.3468, 59.8963, 13.1771>, <-9.8927, 60.5355, 13.9144>, 0.05734 }
				cylinder { <-9.8927, 60.5355, 13.9144>, <-10.4568, 61.1545, 14.6554>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-10.4568, 61.1545, 14.6554>, <-10.4892, 61.1923, 14.7116>, 0.001159 }
				cylinder { <-10.4892, 61.1923, 14.7116>, <-10.5157, 61.2259, 14.7733>, 0.001159 }
				cylinder { <-10.5157, 61.2259, 14.7733>, <-10.5359, 61.2546, 14.8397>, 0.001159 }
				cylinder { <-10.5359, 61.2546, 14.8397>, <-10.5494, 61.2781, 14.9097>, 0.001159 }
				cylinder { <-10.5494, 61.2781, 14.9097>, <-10.5561, 61.296, 14.9824>, 0.001159 }
				cylinder { <-10.5561, 61.296, 14.9824>, <-10.5558, 61.308, 15.05654>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-10.5558, 61.308, 15.05654>, <-10.4814, 62.01495, 15.9661>, <-10.433, 62.07375, 15.9302> }
				triangle { <-10.4814, 62.01495, 15.9661>, <-10.3552, 62.3667, 16.5216>, <-10.433, 62.07375, 15.9302> }
				triangle { <-10.3552, 62.3667, 16.5216>, <-10.2872, 62.4109, 16.4752>, <-10.433, 62.07375, 15.9302> }
				triangle { <-10.3552, 62.3667, 16.5216>, <-9.7017, 63.2339, 18.3103>, <-10.2872, 62.4109, 16.4752> }
				triangle { <-10.2872, 62.4109, 16.4752>, <-9.7017, 63.2339, 18.3103>, <-10.2207, 62.4453, 16.4171> }
				triangle { <-10.433, 62.07375, 15.9302>, <-10.2872, 62.4109, 16.4752>, <-10.2207, 62.4453, 16.4171> }
				triangle { <-10.433, 62.07375, 15.9302>, <-10.2207, 62.4453, 16.4171>, <-10.3793, 62.1024, 15.8785> }
				triangle { <-10.433, 62.07375, 15.9302>, <-10.3793, 62.1024, 15.8785>, <-10.5558, 61.308, 15.05654> }
				triangle { <-9.2705, 63.5987, 19.2589>, <-9.7017, 63.2339, 18.3103>, <-9.7698, 63.1474, 18.3925> }
				triangle { <-10.2207, 62.4453, 16.4171>, <-9.7017, 63.2339, 18.3103>, <-9.5446, 63.2754, 18.2543> }
				triangle { <-10.3552, 62.3667, 16.5216>, <-9.7698, 63.1474, 18.3925>, <-9.7017, 63.2339, 18.3103> }
				triangle { <-9.2705, 63.5987, 19.2589>, <-9.5446, 63.2754, 18.2543>, <-9.7017, 63.2339, 18.3103> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-10.4568, 61.1545, 14.6554>, <-11.02566, 61.6783, 15.4631>, 0.05734 }
				cylinder { <-11.02566, 61.6783, 15.4631>, <-11.5933, 62.1012, 16.3287>, 0.05734 }
				cylinder { <-11.5933, 62.1012, 16.3287>, <-12.1539, 62.4185, 17.2426>, 0.05734 }
				cylinder { <-12.1539, 62.4185, 17.2426>, <-12.7018, 62.6268, 18.1949>, 0.05734 }
				cylinder { <-12.7018, 62.6268, 18.1949>, <-13.2311, 62.7236, 19.175>, 0.05734 }
				cylinder { <-13.2311, 62.7236, 19.175>, <-13.7366, 62.7079, 20.1723>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-13.7366, 62.7079, 20.1723>, <-13.7747, 62.7096, 20.237>, 0.001159 }
				cylinder { <-13.7747, 62.7096, 20.237>, <-13.8167, 62.7142, 20.299>, 0.001159 }
				cylinder { <-13.8167, 62.7142, 20.299>, <-13.8625, 62.7215, 20.3581>, 0.001159 }
				cylinder { <-13.8625, 62.7215, 20.3581>, <-13.9118, 62.7316, 20.4138>, 0.001159 }
				cylinder { <-13.9118, 62.7316, 20.4138>, <-13.9644, 62.7444, 20.466>, 0.001159 }
				cylinder { <-13.9644, 62.7444, 20.466>, <-14.01985, 62.7598, 20.5142>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-14.01985, 62.7598, 20.5142>, <-14.7144, 63.5091, 21.05141>, <-14.6621, 63.5751, 21.05029> }
				triangle { <-14.7144, 63.5091, 21.05141>, <-15.07559, 63.906, 21.4518>, <-14.6621, 63.5751, 21.05029> }
				triangle { <-15.07559, 63.906, 21.4518>, <-15.00078, 63.9614, 21.4602>, <-14.6621, 63.5751, 21.05029> }
				triangle { <-15.07559, 63.906, 21.4518>, <-16.043, 64.9777, 22.9665>, <-15.00078, 63.9614, 21.4602> }
				triangle { <-15.00078, 63.9614, 21.4602>, <-16.043, 64.9777, 22.9665>, <-14.9173, 64.0064, 21.4614> }
				triangle { <-14.6621, 63.5751, 21.05029>, <-15.00078, 63.9614, 21.4602>, <-14.9173, 64.0064, 21.4614> }
				triangle { <-14.6621, 63.5751, 21.05029>, <-14.9173, 64.0064, 21.4614>, <-14.5914, 63.6121, 21.04794> }
				triangle { <-14.6621, 63.5751, 21.05029>, <-14.5914, 63.6121, 21.04794>, <-14.01985, 62.7598, 20.5142> }
				triangle { <-16.4887, 65.4712, 23.8478>, <-16.043, 64.9777, 22.9665>, <-16.1394, 64.8826, 22.9902> }
				triangle { <-14.9173, 64.0064, 21.4614>, <-16.043, 64.9777, 22.9665>, <-15.901, 65.04893, 23.03217> }
				triangle { <-15.07559, 63.906, 21.4518>, <-16.1394, 64.8826, 22.9902>, <-16.043, 64.9777, 22.9665> }
				triangle { <-16.4887, 65.4712, 23.8478>, <-15.901, 65.04893, 23.03217>, <-16.043, 64.9777, 22.9665> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <-13.7366, 62.7079, 20.1723>, <-13.7691, 62.7059, 20.24>, 0.001159 }
				cylinder { <-13.7691, 62.7059, 20.24>, <-13.8001, 62.703, 20.3083>, 0.001159 }
				cylinder { <-13.8001, 62.703, 20.3083>, <-13.8297, 62.6991, 20.3772>, 0.001159 }
				cylinder { <-13.8297, 62.6991, 20.3772>, <-13.8578, 62.6943, 20.4467>, 0.001159 }
				cylinder { <-13.8578, 62.6943, 20.4467>, <-13.8844, 62.6886, 20.5167>, 0.001159 }
				cylinder { <-13.8844, 62.6886, 20.5167>, <-13.9095, 62.6819, 20.5871>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-13.9095, 62.6819, 20.5871>, <-14.2954, 63.1456, 21.5714>, <-14.2552, 63.2193, 21.5651> }
				triangle { <-14.2954, 63.1456, 21.5714>, <-14.4364, 63.3676, 22.1871>, <-14.2552, 63.2193, 21.5651> }
				triangle { <-14.4364, 63.3676, 22.1871>, <-14.3713, 63.4337, 22.1755>, <-14.2552, 63.2193, 21.5651> }
				triangle { <-14.4364, 63.3676, 22.1871>, <-14.5951, 63.8759, 24.2107>, <-14.3713, 63.4337, 22.1755> }
				triangle { <-14.3713, 63.4337, 22.1755>, <-14.5951, 63.8759, 24.2107>, <-14.3016, 63.4929, 22.1509> }
				triangle { <-14.2552, 63.2193, 21.5651>, <-14.3713, 63.4337, 22.1755>, <-14.3016, 63.4929, 22.1509> }
				triangle { <-14.2552, 63.2193, 21.5651>, <-14.3016, 63.4929, 22.1509>, <-14.1977, 63.2692, 21.5411> }
				triangle { <-14.2552, 63.2193, 21.5651>, <-14.1977, 63.2692, 21.5411>, <-13.9095, 62.6819, 20.5871> }
				triangle { <-14.5772, 64.07057, 25.2973>, <-14.5951, 63.8759, 24.2107>, <-14.6603, 63.7607, 24.248> }
				triangle { <-14.3016, 63.4929, 22.1509>, <-14.5951, 63.8759, 24.2107>, <-14.4446, 63.9581, 24.2209> }
				triangle { <-14.4364, 63.3676, 22.1871>, <-14.6603, 63.7607, 24.248>, <-14.5951, 63.8759, 24.2107> }
				triangle { <-14.5772, 64.07057, 25.2973>, <-14.4446, 63.9581, 24.2209>, <-14.5951, 63.8759, 24.2107> }
				texture{Grass_Texture5}}
			}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.0, 0.0, 0.0>, <0.0, 3.7136, 0.0>, 0.05734 }
			cylinder { <0.0, 3.7136, 0.0>, <-0.0, 7.4272, 0.0>, 0.05734 }
			cylinder { <-0.0, 7.4272, 0.0>, <-0.0, 11.1408, 0.0>, 0.05734 }
			cylinder { <-0.0, 11.1408, 0.0>, <-0.0, 14.8544, 0.0>, 0.05734 }
			cylinder { <-0.0, 14.8544, 0.0>, <-0.0, 18.568, 0.0>, 0.05734 }
			cylinder { <-0.0, 18.568, 0.0>, <-0.0, 22.2816, 0.0>, 0.05734 }
			texture{Grass_Texture4}}
		union { // compound leaf
			union { // compound leaf internode
				cylinder { <-0.0, 22.2816, 0.0>, <-0.01307, 23.3991, 0.03653>, 0.05734 }
				cylinder { <-0.01307, 23.3991, 0.03653>, <-0.03922, 24.5146, 0.1095>, 0.05734 }
				cylinder { <-0.03922, 24.5146, 0.1095>, <-0.07843, 25.6267, 0.2189>, 0.05734 }
				cylinder { <-0.07843, 25.6267, 0.2189>, <-0.1306, 26.7341, 0.3646>, 0.05734 }
				cylinder { <-0.1306, 26.7341, 0.3646>, <-0.1958, 27.8355, 0.5463>, 0.05734 }
				cylinder { <-0.1958, 27.8355, 0.5463>, <-0.2739, 28.9295, 0.7639>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.2739, 28.9295, 0.7639>, <-0.2823, 29.00375, 0.7719>, 0.001159 }
				cylinder { <-0.2823, 29.00375, 0.7719>, <-0.2937, 29.07795, 0.7732>, 0.001159 }
				cylinder { <-0.2937, 29.07795, 0.7732>, <-0.3081, 29.1514, 0.7678>, 0.001159 }
				cylinder { <-0.3081, 29.1514, 0.7678>, <-0.3254, 29.2235, 0.7557>, 0.001159 }
				cylinder { <-0.3254, 29.2235, 0.7557>, <-0.3452, 29.2935, 0.737>, 0.001159 }
				cylinder { <-0.3452, 29.2935, 0.737>, <-0.3676, 29.3607, 0.712>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.3676, 29.3607, 0.712>, <-0.7694, 30.4298, 0.5448>, <-0.8291, 30.4284, 0.6042> }
				triangle { <-0.7694, 30.4298, 0.5448>, <-1.06572, 31.00612, 0.3762>, <-0.8291, 30.4284, 0.6042> }
				triangle { <-1.06572, 31.00612, 0.3762>, <-1.138, 30.9818, 0.4302>, <-0.8291, 30.4284, 0.6042> }
				triangle { <-1.06572, 31.00612, 0.3762>, <-2.1692, 32.6129, -0.3845>, <-1.138, 30.9818, 0.4302> }
				triangle { <-1.138, 30.9818, 0.4302>, <-2.1692, 32.6129, -0.3845>, <-1.2044, 30.9435, 0.4859> }
				triangle { <-0.8291, 30.4284, 0.6042>, <-1.138, 30.9818, 0.4302>, <-1.2044, 30.9435, 0.4859> }
				triangle { <-0.8291, 30.4284, 0.6042>, <-1.2044, 30.9435, 0.4859>, <-0.8825, 30.3948, 0.6531> }
				triangle { <-0.8291, 30.4284, 0.6042>, <-0.8825, 30.3948, 0.6531>, <-0.3676, 29.3607, 0.712> }
				triangle { <-2.8042, 33.3773, -0.8656>, <-2.1692, 32.6129, -0.3845>, <-2.08778, 32.6345, -0.4931> }
				triangle { <-1.2044, 30.9435, 0.4859>, <-2.1692, 32.6129, -0.3845>, <-2.3234, 32.553, -0.3381> }
				triangle { <-1.06572, 31.00612, 0.3762>, <-2.08778, 32.6345, -0.4931>, <-2.1692, 32.6129, -0.3845> }
				triangle { <-2.8042, 33.3773, -0.8656>, <-2.3234, 32.553, -0.3381>, <-2.1692, 32.6129, -0.3845> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.2739, 28.9295, 0.7639>, <-0.3401, 30.01921, 1.005915>, 0.05734 }
				cylinder { <-0.3401, 30.01921, 1.005915>, <-0.3944, 31.1038, 1.272>, 0.05734 }
				cylinder { <-0.3944, 31.1038, 1.272>, <-0.4368, 32.1828, 1.5623>, 0.05734 }
				cylinder { <-0.4368, 32.1828, 1.5623>, <-0.4673, 33.2555, 1.8764>, 0.05734 }
				cylinder { <-0.4673, 33.2555, 1.8764>, <-0.4858, 34.3213, 2.2143>, 0.05734 }
				cylinder { <-0.4858, 34.3213, 2.2143>, <-0.4923, 35.3795, 2.5756>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.4923, 35.3795, 2.5756>, <-0.4879, 35.4466, 2.609>, 0.001159 }
				cylinder { <-0.4879, 35.4466, 2.609>, <-0.4788, 35.5083, 2.6508>, 0.001159 }
				cylinder { <-0.4788, 35.5083, 2.6508>, <-0.4652, 35.5633, 2.7001>, 0.001159 }
				cylinder { <-0.4652, 35.5633, 2.7001>, <-0.4473, 35.6103, 2.7558>, 0.001159 }
				cylinder { <-0.4473, 35.6103, 2.7558>, <-0.4256, 35.6485, 2.8167>, 0.001159 }
				cylinder { <-0.4256, 35.6485, 2.8167>, <-0.4006, 35.6768, 2.8816>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.4006, 35.6768, 2.8816>, <-0.09459, 35.9188, 3.968>, <-0.1575, 35.8781, 4.006404> }
				triangle { <-0.09459, 35.9188, 3.968>, <0.02557, 36.1466, 4.5861>, <-0.1575, 35.8781, 4.006404> }
				triangle { <0.02557, 36.1466, 4.5861>, <-0.05871, 36.1151, 4.6114>, <-0.1575, 35.8781, 4.006404> }
				triangle { <0.02557, 36.1466, 4.5861>, <0.2093, 37.1368, 6.4203>, <-0.05871, 36.1151, 4.6114> }
				triangle { <-0.05871, 36.1151, 4.6114>, <0.2093, 37.1368, 6.4203>, <-0.1463, 36.08072, 4.622> }
				triangle { <-0.1575, 35.8781, 4.006404>, <-0.05871, 36.1151, 4.6114>, <-0.1463, 36.08072, 4.622> }
				triangle { <-0.1575, 35.8781, 4.006404>, <-0.1463, 36.08072, 4.622>, <-0.2305, 35.8465, 4.01314> }
				triangle { <-0.1575, 35.8781, 4.006404>, <-0.2305, 35.8465, 4.01314>, <-0.4006, 35.6768, 2.8816> }
				triangle { <0.2375, 37.7525, 7.3363>, <0.2093, 37.1368, 6.4203>, <0.3126, 37.2184, 6.3808> }
				triangle { <-0.1463, 36.08072, 4.622>, <0.2093, 37.1368, 6.4203>, <0.04181, 37.1359, 6.4585> }
				triangle { <0.02557, 36.1466, 4.5861>, <0.3126, 37.2184, 6.3808>, <0.2093, 37.1368, 6.4203> }
				triangle { <0.2375, 37.7525, 7.3363>, <0.04181, 37.1359, 6.4585>, <0.2093, 37.1368, 6.4203> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.4923, 35.3795, 2.5756>, <-0.4988, 36.4376, 2.9369>, 0.05734 }
				cylinder { <-0.4988, 36.4376, 2.9369>, <-0.5053, 37.4958, 3.2982>, 0.05734 }
				cylinder { <-0.5053, 37.4958, 3.2982>, <-0.5118, 38.554, 3.6595>, 0.05734 }
				cylinder { <-0.5118, 38.554, 3.6595>, <-0.5183, 39.6121, 4.02091>, 0.05734 }
				cylinder { <-0.5183, 39.6121, 4.02091>, <-0.5248, 40.6703, 4.3822>, 0.05734 }
				cylinder { <-0.5248, 40.6703, 4.3822>, <-0.5313, 41.7284, 4.7435>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.5313, 41.7284, 4.7435>, <-0.5358, 41.8016, 4.7598>, 0.001159 }
				cylinder { <-0.5358, 41.8016, 4.7598>, <-0.5442, 41.8758, 4.7677>, 0.001159 }
				cylinder { <-0.5442, 41.8758, 4.7677>, <-0.5564, 41.9499, 4.7674>, 0.001159 }
				cylinder { <-0.5564, 41.9499, 4.7674>, <-0.5722, 42.02283, 4.7586>, 0.001159 }
				cylinder { <-0.5722, 42.02283, 4.7586>, <-0.5915, 42.0934, 4.7416>, 0.001159 }
				cylinder { <-0.5915, 42.0934, 4.7416>, <-0.6138, 42.1606, 4.7166>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.6138, 42.1606, 4.7166>, <-1.01564, 43.2297, 4.5494>, <-1.07535, 43.2283, 4.6087> }
				triangle { <-1.01564, 43.2297, 4.5494>, <-1.3119, 43.806, 4.3807>, <-1.07535, 43.2283, 4.6087> }
				triangle { <-1.3119, 43.806, 4.3807>, <-1.3842, 43.7817, 4.4347>, <-1.07535, 43.2283, 4.6087> }
				triangle { <-1.3119, 43.806, 4.3807>, <-2.4154, 45.4128, 3.6199>, <-1.3842, 43.7817, 4.4347> }
				triangle { <-1.3842, 43.7817, 4.4347>, <-2.4154, 45.4128, 3.6199>, <-1.4506, 43.7434, 4.4904> }
				triangle { <-1.07535, 43.2283, 4.6087>, <-1.3842, 43.7817, 4.4347>, <-1.4506, 43.7434, 4.4904> }
				triangle { <-1.07535, 43.2283, 4.6087>, <-1.4506, 43.7434, 4.4904>, <-1.1287, 43.1947, 4.6577> }
				triangle { <-1.07535, 43.2283, 4.6087>, <-1.1287, 43.1947, 4.6577>, <-0.6138, 42.1606, 4.7166> }
				triangle { <-3.05049, 46.1772, 3.1388>, <-2.4154, 45.4128, 3.6199>, <-2.3339, 45.4344, 3.5113> }
				triangle { <-1.4506, 43.7434, 4.4904>, <-2.4154, 45.4128, 3.6199>, <-2.5696, 45.3528, 3.6663> }
				triangle { <-1.3119, 43.806, 4.3807>, <-2.3339, 45.4344, 3.5113>, <-2.4154, 45.4128, 3.6199> }
				triangle { <-3.05049, 46.1772, 3.1388>, <-2.5696, 45.3528, 3.6663>, <-2.4154, 45.4128, 3.6199> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.5313, 41.7284, 4.7435>, <-0.5378, 42.7866, 5.1048>, 0.05734 }
				cylinder { <-0.5378, 42.7866, 5.1048>, <-0.5443, 43.8448, 5.4661>, 0.05734 }
				cylinder { <-0.5443, 43.8448, 5.4661>, <-0.5508, 44.9029, 5.8275>, 0.05734 }
				cylinder { <-0.5508, 44.9029, 5.8275>, <-0.5574, 45.9611, 6.1888>, 0.05734 }
				cylinder { <-0.5574, 45.9611, 6.1888>, <-0.5639, 47.0193, 6.5501>, 0.05734 }
				cylinder { <-0.5639, 47.0193, 6.5501>, <-0.5704, 48.07746, 6.9114>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.5704, 48.07746, 6.9114>, <-0.566, 48.1445, 6.9448>, 0.001159 }
				cylinder { <-0.566, 48.1445, 6.9448>, <-0.5569, 48.2063, 6.9866>, 0.001159 }
				cylinder { <-0.5569, 48.2063, 6.9866>, <-0.5433, 48.2612, 7.03597>, 0.001159 }
				cylinder { <-0.5433, 48.2612, 7.03597>, <-0.5254, 48.3083, 7.0917>, 0.001159 }
				cylinder { <-0.5254, 48.3083, 7.0917>, <-0.5037, 48.3464, 7.1526>, 0.001159 }
				cylinder { <-0.5037, 48.3464, 7.1526>, <-0.4786, 48.3748, 7.2175>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.4786, 48.3748, 7.2175>, <-0.1726, 48.6168, 8.3039>, <-0.2356, 48.5761, 8.3422> }
				triangle { <-0.1726, 48.6168, 8.3039>, <-0.05251, 48.8445, 8.9219>, <-0.2356, 48.5761, 8.3422> }
				triangle { <-0.05251, 48.8445, 8.9219>, <-0.1368, 48.813, 8.9473>, <-0.2356, 48.5761, 8.3422> }
				triangle { <-0.05251, 48.8445, 8.9219>, <0.1312, 49.8347, 10.7561>, <-0.1368, 48.813, 8.9473> }
				triangle { <-0.1368, 48.813, 8.9473>, <0.1312, 49.8347, 10.7561>, <-0.2244, 48.7786, 8.9579> }
				triangle { <-0.2356, 48.5761, 8.3422>, <-0.1368, 48.813, 8.9473>, <-0.2244, 48.7786, 8.9579> }
				triangle { <-0.2356, 48.5761, 8.3422>, <-0.2244, 48.7786, 8.9579>, <-0.3086, 48.5445, 8.349> }
				triangle { <-0.2356, 48.5761, 8.3422>, <-0.3086, 48.5445, 8.349>, <-0.4786, 48.3748, 7.2175> }
				triangle { <0.1594, 50.4505, 11.6721>, <0.1312, 49.8347, 10.7561>, <0.2346, 49.9163, 10.7167> }
				triangle { <-0.2244, 48.7786, 8.9579>, <0.1312, 49.8347, 10.7561>, <-0.03626, 49.8338, 10.7944> }
				triangle { <-0.05251, 48.8445, 8.9219>, <0.2346, 49.9163, 10.7167>, <0.1312, 49.8347, 10.7561> }
				triangle { <0.1594, 50.4505, 11.6721>, <-0.03626, 49.8338, 10.7944>, <0.1312, 49.8347, 10.7561> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.5704, 48.07746, 6.9114>, <-0.5896, 49.123, 7.3072>, 0.05734 }
				cylinder { <-0.5896, 49.123, 7.3072>, <-0.6215, 50.1548, 7.737>, 0.05734 }
				cylinder { <-0.6215, 50.1548, 7.737>, <-0.666, 51.1716, 8.2002>, 0.05734 }
				cylinder { <-0.666, 51.1716, 8.2002>, <-0.7232, 52.172, 8.6963>, 0.05734 }
				cylinder { <-0.7232, 52.172, 8.6963>, <-0.793, 53.155, 9.2246>, 0.05734 }
				cylinder { <-0.793, 53.155, 9.2246>, <-0.8752, 54.1193, 9.7847>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.8752, 54.1193, 9.7847>, <-0.884, 54.1869, 9.8163>, 0.001159 }
				cylinder { <-0.884, 54.1869, 9.8163>, <-0.8958, 54.2566, 9.8415>, 0.001159 }
				cylinder { <-0.8958, 54.2566, 9.8415>, <-0.9107, 54.3278, 9.8603>, 0.001159 }
				cylinder { <-0.9107, 54.3278, 9.8603>, <-0.9285, 54.3997, 9.8723>, 0.001159 }
				cylinder { <-0.9285, 54.3997, 9.8723>, <-0.949, 54.4718, 9.8774>, 0.001159 }
				cylinder { <-0.949, 54.4718, 9.8774>, <-0.972, 54.5433, 9.8756>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.972, 54.5433, 9.8756>, <-1.3817, 55.6056, 10.06603>, <-1.4408, 55.5845, 10.1221> }
				triangle { <-1.3817, 55.6056, 10.06603>, <-1.683, 56.2028, 10.09491>, <-1.4408, 55.5845, 10.1221> }
				triangle { <-1.683, 56.2028, 10.09491>, <-1.7546, 56.1617, 10.1387>, <-1.4408, 55.5845, 10.1221> }
				triangle { <-1.683, 56.2028, 10.09491>, <-2.8035, 57.9595, 9.9026>, <-1.7546, 56.1617, 10.1387> }
				triangle { <-1.7546, 56.1617, 10.1387>, <-2.8035, 57.9595, 9.9026>, <-1.8202, 56.1069, 10.1795> }
				triangle { <-1.4408, 55.5845, 10.1221>, <-1.7546, 56.1617, 10.1387>, <-1.8202, 56.1069, 10.1795> }
				triangle { <-1.4408, 55.5845, 10.1221>, <-1.8202, 56.1069, 10.1795>, <-1.4934, 55.5364, 10.158> }
				triangle { <-1.4408, 55.5845, 10.1221>, <-1.4934, 55.5364, 10.158>, <-0.972, 54.5433, 9.8756> }
				triangle { <-3.4478, 58.8327, 9.6992>, <-2.8035, 57.9595, 9.9026>, <-2.7232, 58.01576, 9.8062> }
				triangle { <-1.8202, 56.1069, 10.1795>, <-2.8035, 57.9595, 9.9026>, <-2.9568, 57.8864, 9.9283> }
				triangle { <-1.683, 56.2028, 10.09491>, <-2.7232, 58.01576, 9.8062>, <-2.8035, 57.9595, 9.9026> }
				triangle { <-3.4478, 58.8327, 9.6992>, <-2.9568, 57.8864, 9.9283>, <-2.8035, 57.9595, 9.9026> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.8752, 54.1193, 9.7847>, <-0.9196, 55.136, 10.248>, 0.05734 }
				cylinder { <-0.9196, 55.136, 10.248>, <-0.9254, 56.1941, 10.6096>, 0.05734 }
				cylinder { <-0.9254, 56.1941, 10.6096>, <-0.8921, 57.282, 10.8659>, 0.05734 }
				cylinder { <-0.8921, 57.282, 10.8659>, <-0.8199, 58.3879, 11.01399>, 0.05734 }
				cylinder { <-0.8199, 58.3879, 11.01399>, <-0.7093, 59.5, 11.05246>, 0.05734 }
				cylinder { <-0.7093, 59.5, 11.05246>, <-0.5611, 60.606, 10.9809>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <-0.5611, 60.606, 10.9809>, <-0.5488, 60.68, 10.9811>, 0.001159 }
				cylinder { <-0.5488, 60.68, 10.9811>, <-0.5341, 60.7535, 10.9863>, 0.001159 }
				cylinder { <-0.5341, 60.7535, 10.9863>, <-0.5171, 60.826, 10.9964>, 0.001159 }
				cylinder { <-0.5171, 60.826, 10.9964>, <-0.498, 60.897, 11.0114>, 0.001159 }
				cylinder { <-0.498, 60.897, 11.0114>, <-0.4769, 60.9663, 11.0312>, 0.001159 }
				cylinder { <-0.4769, 60.9663, 11.0312>, <-0.4538, 61.03345, 11.0557>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <-0.4538, 61.03345, 11.0557>, <-0.1652, 61.9886, 11.6361>, <-0.2254, 61.9842, 11.6948> }
				triangle { <-0.1652, 61.9886, 11.6361>, <-0.06084, 62.5928, 11.905>, <-0.2254, 61.9842, 11.6948> }
				triangle { <-0.06084, 62.5928, 11.905>, <-0.1429, 62.5847, 11.949>, <-0.2254, 61.9842, 11.6948> }
				triangle { <-0.06084, 62.5928, 11.905>, <0.05604, 64.5989, 12.4885>, <-0.1429, 62.5847, 11.949> }
				triangle { <-0.1429, 62.5847, 11.949>, <0.05604, 64.5989, 12.4885>, <-0.2281, 62.5639, 11.9848> }
				triangle { <-0.2254, 61.9842, 11.6948>, <-0.1429, 62.5847, 11.949>, <-0.2281, 62.5639, 11.9848> }
				triangle { <-0.2254, 61.9842, 11.6948>, <-0.2281, 62.5639, 11.9848>, <-0.2962, 61.9634, 11.7252> }
				triangle { <-0.2254, 61.9842, 11.6948>, <-0.2962, 61.9634, 11.7252>, <-0.4538, 61.03345, 11.0557> }
				triangle { <0.04309, 65.683, 12.6969>, <0.05604, 64.5989, 12.4885>, <0.1538, 64.6331, 12.3982> }
				triangle { <-0.2281, 62.5639, 11.9848>, <0.05604, 64.5989, 12.4885>, <-0.111, 64.6176, 12.5237> }
				triangle { <-0.06084, 62.5928, 11.905>, <0.1538, 64.6331, 12.3982>, <0.05604, 64.5989, 12.4885> }
				triangle { <0.04309, 65.683, 12.6969>, <-0.111, 64.6176, 12.5237>, <0.05604, 64.5989, 12.4885> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <-0.5611, 60.606, 10.9809>, <-0.4007, 61.7073, 10.8729>, 0.05734 }
				cylinder { <-0.4007, 61.7073, 10.8729>, <-0.2282, 62.8026, 10.7285>, 0.05734 }
				cylinder { <-0.2282, 62.8026, 10.7285>, <-0.04394, 63.8906, 10.5479>, 0.05734 }
				cylinder { <-0.04394, 63.8906, 10.5479>, <0.152, 64.9699, 10.3313>, 0.05734 }
				cylinder { <0.152, 64.9699, 10.3313>, <0.3594, 66.03935, 10.07903>, 0.05734 }
				cylinder { <0.3594, 66.03935, 10.07903>, <0.578, 67.09752, 9.7912>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <0.578, 67.09752, 9.7912>, <0.5874, 67.1662, 9.7625>, 0.001159 }
				cylinder { <0.5874, 67.1662, 9.7625>, <0.5914, 67.2311, 9.7249>, 0.001159 }
				cylinder { <0.5914, 67.2311, 9.7249>, <0.5898, 67.2908, 9.6793>, 0.001159 }
				cylinder { <0.5898, 67.2908, 9.6793>, <0.5827, 67.3439, 9.6267>, 0.001159 }
				cylinder { <0.5827, 67.3439, 9.6267>, <0.5703, 67.3894, 9.5683>, 0.001159 }
				cylinder { <0.5703, 67.3894, 9.5683>, <0.5528, 67.4262, 9.5052>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <0.5528, 67.4262, 9.5052>, <0.2512, 68.1691, 8.6748>, <0.1978, 68.2154, 8.7205> }
				triangle { <0.2512, 68.1691, 8.6748>, <0.002025, 68.5297, 8.1687>, <0.1978, 68.2154, 8.7205> }
				triangle { <0.002025, 68.5297, 8.1687>, <-0.0668, 68.5574, 8.2255>, <0.1978, 68.2154, 8.7205> }
				triangle { <0.002025, 68.5297, 8.1687>, <-0.9959, 69.3852, 6.5405>, <-0.0668, 68.5574, 8.2255> }
				triangle { <-0.0668, 68.5574, 8.2255>, <-0.9959, 69.3852, 6.5405>, <-0.131, 68.5749, 8.293> }
				triangle { <0.1978, 68.2154, 8.7205>, <-0.0668, 68.5574, 8.2255>, <-0.131, 68.5749, 8.293> }
				triangle { <0.1978, 68.2154, 8.7205>, <-0.131, 68.5749, 8.293>, <0.1463, 68.2301, 8.7797> }
				triangle { <0.1978, 68.2154, 8.7205>, <0.1463, 68.2301, 8.7797>, <0.5528, 67.4262, 9.5052> }
				triangle { <-1.5913, 69.7301, 5.6771>, <-0.9959, 69.3852, 6.5405>, <-0.9237, 69.3185, 6.4444> }
				triangle { <-0.131, 68.5749, 8.293>, <-0.9959, 69.3852, 6.5405>, <-1.1502, 69.3932, 6.6157> }
				triangle { <0.002025, 68.5297, 8.1687>, <-0.9237, 69.3185, 6.4444>, <-0.9959, 69.3852, 6.5405> }
				triangle { <-1.5913, 69.7301, 5.6771>, <-1.1502, 69.3932, 6.6157>, <-0.9959, 69.3852, 6.5405> }
				texture{Grass_Texture5}}
			union { // compound leaf internode
				cylinder { <0.578, 67.09752, 9.7912>, <0.8182, 68.1294, 9.4337>, 0.05734 }
				cylinder { <0.8182, 68.1294, 9.4337>, <1.07898, 69.13, 9.008287>, 0.05734 }
				cylinder { <1.07898, 69.13, 9.008287>, <1.3591, 70.0946, 8.5169>, 0.05734 }
				cylinder { <1.3591, 70.0946, 8.5169>, <1.6573, 71.01842, 7.962>, 0.05734 }
				cylinder { <1.6573, 71.01842, 7.962>, <1.9723, 71.897, 7.3463>, 0.05734 }
				cylinder { <1.9723, 71.897, 7.3463>, <2.3027, 72.7262, 6.6728>, 0.05734 }
				texture{Grass_Texture4}}
			union { // compound leaf petiolet
				cylinder { <2.3027, 72.7262, 6.6728>, <2.3287, 72.7846, 6.6333>, 0.001159 }
				cylinder { <2.3287, 72.7846, 6.6333>, <2.3582, 72.845, 6.5999>, 0.001159 }
				cylinder { <2.3582, 72.845, 6.5999>, <2.391, 72.907, 6.573>, 0.001159 }
				cylinder { <2.391, 72.907, 6.573>, <2.4267, 72.9698, 6.5527>, 0.001159 }
				cylinder { <2.4267, 72.9698, 6.5527>, <2.465, 73.03308, 6.5393>, 0.001159 }
				cylinder { <2.465, 73.03308, 6.5393>, <2.5055, 73.09598, 6.533>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.5055, 73.09598, 6.533>, <3.05779, 74.1031, 6.6481>, <3.002174, 74.1402, 6.6992> }
				triangle { <3.05779, 74.1031, 6.6481>, <3.3255, 74.7164, 6.6285>, <3.002174, 74.1402, 6.6992> }
				triangle { <3.3255, 74.7164, 6.6285>, <3.2469, 74.7493, 6.667>, <3.002174, 74.1402, 6.6992> }
				triangle { <3.3255, 74.7164, 6.6285>, <3.9732, 76.6743, 6.2735>, <3.2469, 74.7493, 6.667> }
				triangle { <3.2469, 74.7493, 6.667>, <3.9732, 76.6743, 6.2735>, <3.1616, 74.7684, 6.7034> }
				triangle { <3.002174, 74.1402, 6.6992>, <3.2469, 74.7493, 6.667>, <3.1616, 74.7684, 6.7034> }
				triangle { <3.002174, 74.1402, 6.6992>, <3.1616, 74.7684, 6.7034>, <2.9304, 74.1533, 6.7318> }
				triangle { <3.002174, 74.1402, 6.6992>, <2.9304, 74.1533, 6.7318>, <2.5055, 73.09598, 6.533> }
				triangle { <4.2429, 77.7043, 5.9817>, <3.9732, 76.6743, 6.2735>, <4.07068, 76.6396, 6.183> }
				triangle { <3.1616, 74.7684, 6.7034>, <3.9732, 76.6743, 6.2735>, <3.8184, 76.7476, 6.2875> }
				triangle { <3.3255, 74.7164, 6.6285>, <4.07068, 76.6396, 6.183>, <3.9732, 76.6743, 6.2735> }
				triangle { <4.2429, 77.7043, 5.9817>, <3.8184, 76.7476, 6.2875>, <3.9732, 76.6743, 6.2735> }
				texture{Grass_Texture5}}
			union { // compound leaf petiolet
				cylinder { <2.3027, 72.7262, 6.6728>, <2.3259, 72.7826, 6.629>, 0.001159 }
				cylinder { <2.3259, 72.7826, 6.629>, <2.35, 72.8397, 6.5865>, 0.001159 }
				cylinder { <2.35, 72.8397, 6.5865>, <2.375, 72.8974, 6.5456>, 0.001159 }
				cylinder { <2.375, 72.8974, 6.5456>, <2.401, 72.9558, 6.5061>, 0.001159 }
				cylinder { <2.401, 72.9558, 6.5061>, <2.4279, 73.01474, 6.4681>, 0.001159 }
				cylinder { <2.4279, 73.01474, 6.4681>, <2.4557, 73.07421, 6.4316>, 0.001159 }
				texture{Grass_Texture4}}
			mesh { // leaf
				triangle { <2.4557, 73.07421, 6.4316>, <2.8526, 74.09579, 6.06925>, <2.8038, 74.1442, 6.1177> }
				triangle { <2.8526, 74.09579, 6.06925>, <3.009509, 74.6809, 5.7841>, <2.8038, 74.1442, 6.1177> }
				triangle { <3.009509, 74.6809, 5.7841>, <2.9365, 74.7191, 5.8282>, <2.8038, 74.1442, 6.1177> }
				triangle { <3.009509, 74.6809, 5.7841>, <3.2488, 76.4292, 4.6595>, <2.9365, 74.7191, 5.8282> }
				triangle { <2.9365, 74.7191, 5.8282>, <3.2488, 76.4292, 4.6595>, <2.8588, 74.7434, 5.8767> }
				triangle { <2.8038, 74.1442, 6.1177>, <2.9365, 74.7191, 5.8282>, <2.8588, 74.7434, 5.8767> }
				triangle { <2.8038, 74.1442, 6.1177>, <2.8588, 74.7434, 5.8767>, <2.7394, 74.1625, 6.1612> }
				triangle { <2.8038, 74.1442, 6.1177>, <2.7394, 74.1625, 6.1612>, <2.4557, 73.07421, 6.4316> }
				triangle { <3.2842, 77.3065, 3.9901>, <3.2488, 76.4292, 4.6595>, <3.3293, 76.3723, 4.5638> }
				triangle { <2.8588, 74.7434, 5.8767>, <3.2488, 76.4292, 4.6595>, <3.09086, 76.4908, 4.6874> }
				triangle { <3.009509, 74.6809, 5.7841>, <3.3293, 76.3723, 4.5638>, <3.2488, 76.4292, 4.6595> }
				triangle { <3.2842, 77.3065, 3.9901>, <3.09086, 76.4908, 4.6874>, <3.2488, 76.4292, 4.6595> }
				texture{Grass_Texture5}}
			}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <0.0, 0.0, 0.0>, <-0.0, 11.2873, 0.0>, 0.07351 }
			cylinder { <-0.0, 11.2873, 0.0>, <-0.0, 22.5746, 0.0>, 0.07351 }
			cylinder { <-0.0, 22.5746, 0.0>, <-0.00000001, 33.862, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 33.862, 0.0>, <-0.00000001, 45.1493, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 45.1493, 0.0>, <-0.00000001, 56.4367, 0.0>, 0.07351 }
			cylinder { <-0.00000001, 56.4367, 0.0>, <-0.00000001, 67.724, 0.0>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <-0.01408, 68.2486, 0.01155>, 0.07351 }
			cylinder { <-0.01408, 68.2486, 0.01155>, <-0.04222, 68.7722, 0.03463>, 0.07351 }
			cylinder { <-0.04222, 68.7722, 0.03463>, <-0.08441, 69.2942, 0.06922>, 0.07351 }
			cylinder { <-0.08441, 69.2942, 0.06922>, <-0.1405, 69.814, 0.1152>, 0.07351 }
			cylinder { <-0.1405, 69.814, 0.1152>, <-0.2106, 70.331, 0.1727>, 0.07351 }
			cylinder { <-0.2106, 70.331, 0.1727>, <-0.2946, 70.8445, 0.2414>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-0.2946, 70.8445, 0.2414>, <-0.3923, 71.354, 0.3214>, 0.07351 }
			cylinder { <-0.3923, 71.354, 0.3214>, <-0.5036, 71.8587, 0.4126>, 0.07351 }
			cylinder { <-0.5036, 71.8587, 0.4126>, <-0.6284, 72.3582, 0.5147>, 0.07351 }
			cylinder { <-0.6284, 72.3582, 0.5147>, <-0.7666, 72.8517, 0.6278>, 0.07351 }
			cylinder { <-0.7666, 72.8517, 0.6278>, <-0.918, 73.3388, 0.7516>, 0.07351 }
			cylinder { <-0.918, 73.3388, 0.7516>, <-1.08241, 73.8188, 0.886>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <-1.08241, 73.8188, 0.886>, <-1.2294, 74.3039, 1.02204>, 0.07351 }
			cylinder { <-1.2294, 74.3039, 1.02204>, <-1.3588, 74.7937, 1.1595>, 0.07351 }
			cylinder { <-1.3588, 74.7937, 1.1595>, <-1.4705, 75.2874, 1.2982>, 0.07351 }
			cylinder { <-1.4705, 75.2874, 1.2982>, <-1.5643, 75.7845, 1.4381>, 0.07351 }
			cylinder { <-1.5643, 75.7845, 1.4381>, <-1.6402, 76.2844, 1.579>, 0.07351 }
			cylinder { <-1.6402, 76.2844, 1.579>, <-1.6979, 76.7864, 1.7206>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-1.6979, 76.7864, 1.7206>, <-1.7041, 76.8399, 1.7357>, 0.07351 }
				cylinder { <-1.7041, 76.8399, 1.7357>, <-1.7102, 76.8933, 1.7508>, 0.07351 }
				cylinder { <-1.7102, 76.8933, 1.7508>, <-1.7164, 76.9468, 1.7659>, 0.07351 }
				cylinder { <-1.7164, 76.9468, 1.7659>, <-1.7225, 77.00026, 1.781>, 0.07351 }
				cylinder { <-1.7225, 77.00026, 1.781>, <-1.7287, 77.0537, 1.796>, 0.07351 }
				cylinder { <-1.7287, 77.0537, 1.796>, <-1.7348, 77.1071, 1.8111>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-1.7348, 77.1071, 1.8111>, <-3.2042, 78.7485, 2.4481>, <-3.1222, 78.7714, 2.6905> }
					triangle { <-3.2042, 78.7485, 2.4481>, <-3.8463, 79.763, 2.872>, <-3.1222, 78.7714, 2.6905> }
					triangle { <-3.8463, 79.763, 2.872>, <-3.756, 79.7785, 3.1425>, <-3.1222, 78.7714, 2.6905> }
					triangle { <-3.8463, 79.763, 2.872>, <-4.6739, 81.1944, 3.8184>, <-3.756, 79.7785, 3.1425> }
					triangle { <-3.756, 79.7785, 3.1425>, <-4.6739, 81.1944, 3.8184>, <-3.6975, 79.6292, 3.3788> }
					triangle { <-3.1222, 78.7714, 2.6905>, <-3.756, 79.7785, 3.1425>, <-3.6975, 79.6292, 3.3788> }
					triangle { <-3.1222, 78.7714, 2.6905>, <-3.6975, 79.6292, 3.3788>, <-3.0478, 78.6476, 2.8963> }
					triangle { <-3.1222, 78.7714, 2.6905>, <-3.0478, 78.6476, 2.8963>, <-1.7348, 77.1071, 1.8111> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-1.6979, 76.7864, 1.7206>, <-1.769, 77.2901, 1.8499>, 0.07351 }
			cylinder { <-1.769, 77.2901, 1.8499>, <-1.8532, 77.7949, 1.9666>, 0.07351 }
			cylinder { <-1.8532, 77.7949, 1.9666>, <-1.9504, 78.3001, 2.07072>, 0.07351 }
			cylinder { <-1.9504, 78.3001, 2.07072>, <-2.06069, 78.8051, 2.1619>, 0.07351 }
			cylinder { <-2.06069, 78.8051, 2.1619>, <-2.1837, 79.3093, 2.2402>, 0.07351 }
			cylinder { <-2.1837, 79.3093, 2.2402>, <-2.3193, 79.8121, 2.3054>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-2.3193, 79.8121, 2.3054>, <-2.3337, 79.8656, 2.3124>, 0.07351 }
				cylinder { <-2.3337, 79.8656, 2.3124>, <-2.3482, 79.9191, 2.3193>, 0.07351 }
				cylinder { <-2.3482, 79.9191, 2.3193>, <-2.3626, 79.9727, 2.3262>, 0.07351 }
				cylinder { <-2.3626, 79.9727, 2.3262>, <-2.3771, 80.02623, 2.3332>, 0.07351 }
				cylinder { <-2.3771, 80.02623, 2.3332>, <-2.3915, 80.07976, 2.3401>, 0.07351 }
				cylinder { <-2.3915, 80.07976, 2.3401>, <-2.406, 80.1332, 2.3471>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-2.406, 80.1332, 2.3471>, <-2.08938, 82.01254, 3.2758>, <-2.0237, 82.1305, 3.08045> }
					triangle { <-2.08938, 82.01254, 3.2758>, <-2.02999, 83.1275, 3.6483>, <-2.0237, 82.1305, 3.08045> }
					triangle { <-2.02999, 83.1275, 3.6483>, <-1.9507, 83.2519, 3.4294>, <-2.0237, 82.1305, 3.08045> }
					triangle { <-2.02999, 83.1275, 3.6483>, <-1.8121, 84.8547, 3.9147>, <-1.9507, 83.2519, 3.4294> }
					triangle { <-1.9507, 83.2519, 3.4294>, <-1.8121, 84.8547, 3.9147>, <-1.7858, 83.2439, 3.2234> }
					triangle { <-2.0237, 82.1305, 3.08045>, <-1.9507, 83.2519, 3.4294>, <-1.7858, 83.2439, 3.2234> }
					triangle { <-2.0237, 82.1305, 3.08045>, <-1.7858, 83.2439, 3.2234>, <-1.8966, 82.1227, 2.8859> }
					triangle { <-2.0237, 82.1305, 3.08045>, <-1.8966, 82.1227, 2.8859>, <-2.406, 80.1332, 2.3471> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-2.3193, 79.8121, 2.3054>, <-2.4538, 80.3125, 2.3887>, 0.07351 }
			cylinder { <-2.4538, 80.3125, 2.3887>, <-2.5871, 80.81, 2.4899>, 0.07351 }
			cylinder { <-2.5871, 80.81, 2.4899>, <-2.7189, 81.3039, 2.6089>, 0.07351 }
			cylinder { <-2.7189, 81.3039, 2.6089>, <-2.8492, 81.7936, 2.7455>, 0.07351 }
			cylinder { <-2.8492, 81.7936, 2.7455>, <-2.9777, 82.2786, 2.8997>, 0.07351 }
			cylinder { <-2.9777, 82.2786, 2.8997>, <-3.1043, 82.7582, 3.07122>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.1043, 82.7582, 3.07122>, <-3.1178, 82.8093, 3.08948>, 0.07351 }
				cylinder { <-3.1178, 82.8093, 3.08948>, <-3.1312, 82.8604, 3.1077>, 0.07351 }
				cylinder { <-3.1312, 82.8604, 3.1077>, <-3.1447, 82.9114, 3.1259>, 0.07351 }
				cylinder { <-3.1447, 82.9114, 3.1259>, <-3.1582, 82.9625, 3.1442>, 0.07351 }
				cylinder { <-3.1582, 82.9625, 3.1442>, <-3.1717, 83.01357, 3.1624>, 0.07351 }
				cylinder { <-3.1717, 83.01357, 3.1624>, <-3.1851, 83.06462, 3.1807>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.1851, 83.06462, 3.1807>, <-3.5107, 84.9486, 3.542>, <-3.7146, 84.9266, 3.6158> }
					triangle { <-3.5107, 84.9486, 3.542>, <-3.7447, 85.9383, 3.9068>, <-3.7146, 84.9266, 3.6158> }
					triangle { <-3.7447, 85.9383, 3.9068>, <-3.9733, 85.9093, 3.9817>, <-3.7146, 84.9266, 3.6158> }
					triangle { <-3.7447, 85.9383, 3.9068>, <-4.3703, 87.3122, 4.4847>, <-3.9733, 85.9093, 3.9817> }
					triangle { <-3.9733, 85.9093, 3.9817>, <-4.3703, 87.3122, 4.4847>, <-4.1893, 85.8132, 3.9284> }
					triangle { <-3.7146, 84.9266, 3.6158>, <-3.9733, 85.9093, 3.9817>, <-4.1893, 85.8132, 3.9284> }
					triangle { <-3.7146, 84.9266, 3.6158>, <-4.1893, 85.8132, 3.9284>, <-3.9027, 84.8305, 3.5857> }
					triangle { <-3.7146, 84.9266, 3.6158>, <-3.9027, 84.8305, 3.5857>, <-3.1851, 83.06462, 3.1807> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-3.1043, 82.7582, 3.07122>, <-3.2205, 83.245, 3.2295>, 0.07351 }
			cylinder { <-3.2205, 83.245, 3.2295>, <-3.3261, 83.7382, 3.3745>, 0.07351 }
			cylinder { <-3.3261, 83.7382, 3.3745>, <-3.421, 84.2374, 3.506>, 0.07351 }
			cylinder { <-3.421, 84.2374, 3.506>, <-3.5051, 84.7419, 3.6239>, 0.07351 }
			cylinder { <-3.5051, 84.7419, 3.6239>, <-3.5783, 85.2511, 3.7279>, 0.07351 }
			cylinder { <-3.5783, 85.2511, 3.7279>, <-3.6405, 85.7644, 3.818>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-3.6405, 85.7644, 3.818>, <-3.6471, 85.8191, 3.8276>, 0.07351 }
				cylinder { <-3.6471, 85.8191, 3.8276>, <-3.6537, 85.8737, 3.8372>, 0.07351 }
				cylinder { <-3.6537, 85.8737, 3.8372>, <-3.6603, 85.9284, 3.8468>, 0.07351 }
				cylinder { <-3.6603, 85.9284, 3.8468>, <-3.667, 85.983, 3.8564>, 0.07351 }
				cylinder { <-3.667, 85.983, 3.8564>, <-3.6736, 86.03769, 3.866>, 0.07351 }
				cylinder { <-3.6736, 86.03769, 3.866>, <-3.6802, 86.09233, 3.8756>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-3.6802, 86.09233, 3.8756>, <-3.532, 87.8514, 3.7376>, <-3.3826, 87.8732, 3.8663> }
					triangle { <-3.532, 87.8514, 3.7376>, <-3.2891, 88.7987, 3.6354>, <-3.3826, 87.8732, 3.8663> }
					triangle { <-3.2891, 88.7987, 3.6354>, <-3.1272, 88.8188, 3.7837>, <-3.3826, 87.8732, 3.8663> }
					triangle { <-3.2891, 88.7987, 3.6354>, <-2.7658, 90.1722, 3.6962>, <-3.1272, 88.8188, 3.7837> }
					triangle { <-3.1272, 88.8188, 3.7837>, <-2.7658, 90.1722, 3.6962>, <-3.06186, 88.7681, 3.9882> }
					triangle { <-3.3826, 87.8732, 3.8663>, <-3.1272, 88.8188, 3.7837>, <-3.06186, 88.7681, 3.9882> }
					triangle { <-3.3826, 87.8732, 3.8663>, <-3.06186, 88.7681, 3.9882>, <-3.311, 87.8192, 4.03853> }
					triangle { <-3.3826, 87.8732, 3.8663>, <-3.311, 87.8192, 4.03853>, <-3.6802, 86.09233, 3.8756> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-3.6405, 85.7644, 3.818>, <-3.7204, 86.2748, 3.9109>, 0.07351 }
			cylinder { <-3.7204, 86.2748, 3.9109>, <-3.818, 86.7816, 4.006422>, 0.07351 }
			cylinder { <-3.818, 86.7816, 4.006422>, <-3.9332, 87.2842, 4.1043>, 0.07351 }
			cylinder { <-3.9332, 87.2842, 4.1043>, <-4.06582, 87.782, 4.2047>, 0.07351 }
			cylinder { <-4.06582, 87.782, 4.2047>, <-4.2156, 88.2745, 4.3073>, 0.07351 }
			cylinder { <-4.2156, 88.2745, 4.3073>, <-4.3825, 88.7609, 4.412>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-4.3825, 88.7609, 4.412>, <-4.4003, 88.8127, 4.4231>, 0.07351 }
				cylinder { <-4.4003, 88.8127, 4.4231>, <-4.4181, 88.8645, 4.4343>, 0.07351 }
				cylinder { <-4.4181, 88.8645, 4.4343>, <-4.4358, 88.9163, 4.4454>, 0.07351 }
				cylinder { <-4.4358, 88.9163, 4.4454>, <-4.4536, 88.9681, 4.4566>, 0.07351 }
				cylinder { <-4.4536, 88.9681, 4.4566>, <-4.4714, 89.01993, 4.4677>, 0.07351 }
				cylinder { <-4.4714, 89.01993, 4.4677>, <-4.4891, 89.07172, 4.4788>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <-4.4891, 89.07172, 4.4788>, <-4.3832, 90.6416, 4.7397>, <-4.4817, 90.6935, 4.6> }
					triangle { <-4.3832, 90.6416, 4.7397>, <-4.4727, 91.5126, 4.8725>, <-4.4817, 90.6935, 4.6> }
					triangle { <-4.4727, 91.5126, 4.8725>, <-4.5783, 91.5663, 4.7131>, <-4.4817, 90.6935, 4.6> }
					triangle { <-4.4727, 91.5126, 4.8725>, <-4.7062, 92.8167, 4.8489>, <-4.5783, 91.5663, 4.7131> }
					triangle { <-4.5783, 91.5663, 4.7131>, <-4.7062, 92.8167, 4.8489>, <-4.5992, 91.5447, 4.5167> }
					triangle { <-4.4817, 90.6935, 4.6>, <-4.5783, 91.5663, 4.7131>, <-4.5992, 91.5447, 4.5167> }
					triangle { <-4.4817, 90.6935, 4.6>, <-4.5992, 91.5447, 4.5167>, <-4.5155, 90.6681, 4.4303> }
					triangle { <-4.4817, 90.6935, 4.6>, <-4.5155, 90.6681, 4.4303>, <-4.4891, 89.07172, 4.4788> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <-0.00000001, 67.724, 0.0>, <0.01819, 68.2486, 0.0008964>, 0.07351 }
			cylinder { <0.01819, 68.2486, 0.0008964>, <0.05455, 68.7722, 0.002693>, 0.07351 }
			cylinder { <0.05455, 68.7722, 0.002693>, <0.109, 69.2942, 0.005395>, 0.07351 }
			cylinder { <0.109, 69.2942, 0.005395>, <0.1815, 69.814, 0.009002>, 0.07351 }
			cylinder { <0.1815, 69.814, 0.009002>, <0.272, 70.331, 0.01351>, 0.07351 }
			cylinder { <0.272, 70.331, 0.01351>, <0.3804, 70.8445, 0.01894>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.3804, 70.8445, 0.01894>, <0.5098, 71.3523, 0.04964>, 0.07351 }
			cylinder { <0.5098, 71.3523, 0.04964>, <0.6267, 71.8636, 0.06748>, 0.07351 }
			cylinder { <0.6267, 71.8636, 0.06748>, <0.7312, 72.378, 0.07241>, 0.07351 }
			cylinder { <0.7312, 72.378, 0.07241>, <0.823, 72.8947, 0.06444>, 0.07351 }
			cylinder { <0.823, 72.8947, 0.06444>, <0.902, 73.4131, 0.04356>, 0.07351 }
			cylinder { <0.902, 73.4131, 0.04356>, <0.9683, 73.9327, 0.009805>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9683, 73.9327, 0.009805>, <0.9753, 73.988, 0.006212>, 0.07351 }
				cylinder { <0.9753, 73.988, 0.006212>, <0.9824, 74.04333, 0.002618>, 0.07351 }
				cylinder { <0.9824, 74.04333, 0.002618>, <0.9894, 74.09864, -0.0009749>, 0.07351 }
				cylinder { <0.9894, 74.09864, -0.0009749>, <0.9965, 74.1539, -0.004568>, 0.07351 }
				cylinder { <0.9965, 74.1539, -0.004568>, <1.003582, 74.2092, -0.008162>, 0.07351 }
				cylinder { <1.003582, 74.2092, -0.008162>, <1.01063, 74.2645, -0.01175>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.01063, 74.2645, -0.01175>, <0.8307, 75.9506, -0.522>, <0.9733, 75.9494, -0.6598> }
					triangle { <0.8307, 75.9506, -0.522>, <0.723, 76.825, -0.9585>, <0.9733, 75.9494, -0.6598> }
					triangle { <0.723, 76.825, -0.9585>, <0.8865, 76.8207, -1.1064>, <0.9733, 75.9494, -0.6598> }
					triangle { <0.723, 76.825, -0.9585>, <0.7922, 78.07048, -1.7384>, <0.8865, 76.8207, -1.1064> }
					triangle { <0.8865, 76.8207, -1.1064>, <0.7922, 78.07048, -1.7384>, <1.09821, 76.7691, -1.1405> }
					triangle { <0.9733, 75.9494, -0.6598>, <0.8865, 76.8207, -1.1064>, <1.09821, 76.7691, -1.1405> }
					triangle { <0.9733, 75.9494, -0.6598>, <1.09821, 76.7691, -1.1405>, <1.1537, 75.8915, -0.7026> }
					triangle { <0.9733, 75.9494, -0.6598>, <1.1537, 75.8915, -0.7026>, <1.01063, 74.2645, -0.01175> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9683, 73.9327, 0.009805>, <1.03554, 74.453, -0.005777>, 0.07351 }
			cylinder { <1.03554, 74.453, -0.005777>, <1.1036, 74.9734, -0.003166>, 0.07351 }
			cylinder { <1.1036, 74.9734, -0.003166>, <1.1725, 75.4933, 0.01763>, 0.07351 }
			cylinder { <1.1725, 75.4933, 0.01763>, <1.2421, 76.01212, 0.0566>, 0.07351 }
			cylinder { <1.2421, 76.01212, 0.0566>, <1.3124, 76.5291, 0.1136>, 0.07351 }
			cylinder { <1.3124, 76.5291, 0.1136>, <1.3832, 77.04372, 0.1888>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.3832, 77.04372, 0.1888>, <1.3907, 77.0985, 0.1968>, 0.07351 }
				cylinder { <1.3907, 77.0985, 0.1968>, <1.3982, 77.1532, 0.2048>, 0.07351 }
				cylinder { <1.3982, 77.1532, 0.2048>, <1.4058, 77.208, 0.2128>, 0.07351 }
				cylinder { <1.4058, 77.208, 0.2128>, <1.4133, 77.2628, 0.2208>, 0.07351 }
				cylinder { <1.4133, 77.2628, 0.2208>, <1.4208, 77.3176, 0.2288>, 0.07351 }
				cylinder { <1.4208, 77.3176, 0.2288>, <1.4284, 77.3724, 0.2368>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.4284, 77.3724, 0.2368>, <1.6469, 78.9026, -0.1565>, <1.4961, 78.9653, -0.08409> }
					triangle { <1.6469, 78.9026, -0.1565>, <1.7409, 79.78, -0.2313>, <1.4961, 78.9653, -0.08409> }
					triangle { <1.7409, 79.78, -0.2313>, <1.5697, 79.8448, -0.1542>, <1.4961, 78.9653, -0.08409> }
					triangle { <1.7409, 79.78, -0.2313>, <1.6503, 81.1014, -0.2673>, <1.5697, 79.8448, -0.1542> }
					triangle { <1.5697, 79.8448, -0.1542>, <1.6503, 81.1014, -0.2673>, <1.3731, 79.8174, -0.148> }
					triangle { <1.4961, 78.9653, -0.08409>, <1.5697, 79.8448, -0.1542>, <1.3731, 79.8174, -0.148> }
					triangle { <1.4961, 78.9653, -0.08409>, <1.3731, 79.8174, -0.148>, <1.3247, 78.9381, -0.06219> }
					triangle { <1.4961, 78.9653, -0.08409>, <1.3247, 78.9381, -0.06219>, <1.4284, 77.3724, 0.2368> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.3804, 70.8445, 0.01894>, <0.4762, 71.3605, 0.01147>, 0.07351 }
			cylinder { <0.4762, 71.3605, 0.01147>, <0.5592, 71.8784, -0.008886>, 0.07351 }
			cylinder { <0.5592, 71.8784, -0.008886>, <0.6294, 72.3974, -0.04211>, 0.07351 }
			cylinder { <0.6294, 72.3974, -0.04211>, <0.6866, 72.9171, -0.08816>, 0.07351 }
			cylinder { <0.6866, 72.9171, -0.08816>, <0.7309, 73.4368, -0.147>, 0.07351 }
			cylinder { <0.7309, 73.4368, -0.147>, <0.7621, 73.9558, -0.2185>, 0.07351 }
			texture{Grass_Texture6}}
		union { // inflor. internode
			cylinder { <0.7621, 73.9558, -0.2185>, <0.7937, 74.4692, -0.3229>, 0.07351 }
			cylinder { <0.7937, 74.4692, -0.3229>, <0.8265, 74.9859, -0.4094>, 0.07351 }
			cylinder { <0.8265, 74.9859, -0.4094>, <0.8604, 75.5051, -0.478>, 0.07351 }
			cylinder { <0.8604, 75.5051, -0.478>, <0.8955, 76.02643, -0.5284>, 0.07351 }
			cylinder { <0.8955, 76.02643, -0.5284>, <0.9316, 76.549, -0.5607>, 0.07351 }
			cylinder { <0.9316, 76.549, -0.5607>, <0.9687, 77.0724, -0.5749>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.9687, 77.0724, -0.5749>, <0.9727, 77.1281, -0.5764>, 0.07351 }
				cylinder { <0.9727, 77.1281, -0.5764>, <0.9767, 77.1838, -0.5779>, 0.07351 }
				cylinder { <0.9767, 77.1838, -0.5779>, <0.9806, 77.2395, -0.5794>, 0.07351 }
				cylinder { <0.9806, 77.2395, -0.5794>, <0.9846, 77.2952, -0.5809>, 0.07351 }
				cylinder { <0.9846, 77.2952, -0.5809>, <0.9885, 77.3509, -0.5824>, 0.07351 }
				cylinder { <0.9885, 77.3509, -0.5824>, <0.9925, 77.4066, -0.5839>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <0.9925, 77.4066, -0.5839>, <1.1343, 79.09459, -0.06779>, <0.9401, 79.1343, -0.06168> }
					triangle { <1.1343, 79.09459, -0.06779>, <1.1051, 79.9902, 0.3367>, <0.9401, 79.1343, -0.06168> }
					triangle { <1.1051, 79.9902, 0.3367>, <0.8884, 80.03158, 0.3363>, <0.9401, 79.1343, -0.06168> }
					triangle { <1.1051, 79.9902, 0.3367>, <0.798, 81.3222, 0.8805>, <0.8884, 80.03158, 0.3363> }
					triangle { <0.8884, 80.03158, 0.3363>, <0.798, 81.3222, 0.8805>, <0.7022, 80.01938, 0.2188> }
					triangle { <0.9401, 79.1343, -0.06168>, <0.8884, 80.03158, 0.3363>, <0.7022, 80.01938, 0.2188> }
					triangle { <0.9401, 79.1343, -0.06168>, <0.7022, 80.01938, 0.2188>, <0.7695, 79.1121, -0.1518> }
					triangle { <0.9401, 79.1343, -0.06168>, <0.7695, 79.1121, -0.1518>, <0.9925, 77.4066, -0.5839> }
					texture{Grass_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <0.9687, 77.0724, -0.5749>, <1.01736, 77.5942, -0.6032>, 0.07351 }
			cylinder { <1.01736, 77.5942, -0.6032>, <1.0773, 78.1139, -0.6455>, 0.07351 }
			cylinder { <1.0773, 78.1139, -0.6455>, <1.1485, 78.6309, -0.7018>, 0.07351 }
			cylinder { <1.1485, 78.6309, -0.7018>, <1.231, 79.1444, -0.7721>, 0.07351 }
			cylinder { <1.231, 79.1444, -0.7721>, <1.3246, 79.654, -0.8563>, 0.07351 }
			cylinder { <1.3246, 79.654, -0.8563>, <1.4292, 80.1589, -0.9541>, 0.07351 }
			texture{Grass_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.4292, 80.1589, -0.9541>, <1.4403, 80.2126, -0.9646>, 0.07351 }
				cylinder { <1.4403, 80.2126, -0.9646>, <1.4514, 80.2664, -0.975>, 0.07351 }
				cylinder { <1.4514, 80.2664, -0.975>, <1.4626, 80.3201, -0.9854>, 0.07351 }
				cylinder { <1.4626, 80.3201, -0.9854>, <1.4737, 80.3739, -0.9958>, 0.07351 }
				cylinder { <1.4737, 80.3739, -0.9958>, <1.4848, 80.4276, -1.006296>, 0.07351 }
				cylinder { <1.4848, 80.4276, -1.006296>, <1.496, 80.4814, -1.01671>, 0.07351 }
				texture{Grass_Texture7}}
			union { // flower
				mesh { // flower petal
					triangle { <1.496, 80.4814, -1.01671>, <1.3946, 82.06513, -0.8565>, <1.5644, 82.09294, -0.8081> }
					triangle { <1.3946, 82.06513, -0.8565>, <1.4585, 82.9484, -0.8552>, <1.5644, 82.09294, -0.8081> }
					triangle { <1.4585, 82.9484, -0.8552>, <1.6465, 82.9744, -0.7966>, <1.5644, 82.09294, -0.8081> }
					triangle { <1.4585, 82.9484, -0.8552>, <1.7732, 84.2315, -0.754>, <1.6465, 82.9744, -0.7966> }
					triangle { <1.6465, 82.9744, -0.7966>, <1.7732, 84.2315, -0.754>, <1.7871, 82.9153, -0.6692> }
					triangle { <1.5644, 82.09294, -0.8081>, <1.6465, 82.9744, -0.7966>, <1.7871, 82.9153, -0.6692> }
					triangle { <1.5644, 82.09294, -0.8081>, <1.7871, 82.9153, -0.6692>, <1.6971, 82.03602, -0.7094> }
					triangle { <1.5644, 82.09294, -0.8081>, <1.6971, 82.03602, -0.7094>, <1.496, 80.4814, -1.01671> }
					texture{Grass_Texture8}}
				}
			}
		}
} // end curvy_maiden_grass


/* 
#declare allPlants_grass = union { // all plants
	object { Grassy_plant }
	object { maiden_grass }
	object { curvy_maiden_grass }
	}
*/ 
