

// pigment

#declare P_Rock1 = <.75,.75,.7>;
#declare P_Rock2 = <.8,.8,.9>;
#declare P_Rock3 = <.5,.3,.25>;

#declare P_Snow  = <1,1,1>; 

#declare P_Grass1 = <.4,.5,.4>;
#declare P_Grass2 = <.5,.6,.5>;
#declare P_Grass3 = <.2,.3,.2>;

// texture

#declare T13_Rock = 
texture{pigment{
	crackle
	color_map {
		[0.0 rgb P_Rock2]
		[0.5 rgb P_Rock1]
		[0.8 rgb P_Rock1]
		[1.0 rgb P_Rock3]
	}
	turbulence .1
	scale .2
}
normal {crackle 1 turbulence <.1,.5,.1> poly_wave .1 scale <.3,1.5,.3>}
finish {phong .2}
}

#declare T13_Low  = 
texture{pigment{
	granite
	color_map {
		[0.0  rgb P_Grass1]
		[0.25 rgb P_Grass1] 
		[0.3 rgb <.1,.3,0>]
		[0.4 rgb <.1,.2,.05>]
		[0.5 rgb P_Grass1]
		[0.75 rgb P_Grass2]
		[1.0  rgb P_Grass2]
	}
	scale .1
}
normal {wrinkles 1 scale .2}
finish {phong .1 phong_size 10}
}

#declare T13_Mid  = 
texture{pigment{
	granite
	color_map {
		[0.0  rgb P_Grass2]
		[0.25 rgb P_Grass2]
		[0.75 rgb P_Grass3]
		[1.0  rgb P_Grass3]
	}   
	scale .1
}
normal {crackle 2 scale .5 scallop_wave}
finish {phong 1 phong_size 10 crand .01}
}


#declare T13_High = texture{pigment{rgb P_Snow}finish{phong 1 ambient <.3,.3,.34>}normal {granite 2 scale .1}}

// #macro LANDFORM (DISTRIBUTION,SCALE TURBULENCE)

#declare Distribution 		= 0.25;
#declare Scale				= .1;
#declare Turbulence			= .25;

#declare T13_Rock_Low = 
texture {
	granite
	texture_map {
		[0.0 T13_Rock]
		[Distribution T13_Rock]
		[Distribution T13_Low]
		[1.0 T13_Low]
	}
	scale Scale
	turbulence Turbulence
}                                      
                                     
#declare T13_Slope_Low =
texture {
	slope y
	texture_map {
		[0.0 T13_Rock]
		[0.6 T13_Rock]
		[0.65 T13_Rock_Low]
		[0.8 T13_Rock_Low]
		[0.85 T13_Low]
		[1.0 T13_Low]
	}
}

#declare Distribution 		= 0.25;
#declare Scale				= .1;
#declare Turbulence			= .25;

#declare T13_Rock_Mid = 
texture {
	granite
	texture_map {
		[0.0 T13_Rock]
		[Distribution T13_Rock]
		[Distribution T13_Mid]
		[1.0 T13_Mid]
	}
	scale Scale
	turbulence Turbulence
}                                      
                                     
#declare T13_Slope_Mid =
texture {
	slope y
	texture_map {
		[0.0 T13_Rock]
		[0.6 T13_Rock]
		[0.65 T13_Rock_Mid]
		[0.8 T13_Rock_Mid]
		[0.85 T13_Mid]
		[1.0 T13_Mid]
	}
}    

#declare Distribution 		= 0.75;


#declare T13_Rock_High = 
texture {
	granite
	texture_map {
		[0.0 T13_High]
		[Distribution T13_High]
		[Distribution T13_Rock]
		[1.0 T13_Rock]
	}
}                                      
                                     
#declare T13_Slope_High =
texture {
	slope y
	texture_map {
		[0.0 T13_High]
		[0.6 T13_Rock_High]
		[0.65 T13_Rock_High]
		[0.7 T13_Rock]
		[0.75 T13_High]
		[1.0 T13_Rock]
	}
}

#declare T13_LandformA =
texture {
	gradient y
	texture_map {
		[0.0 T13_Slope_Low ]
		[0.2 T13_Slope_Low ]
		[0.3 T13_Slope_Mid ]
		[0.4 T13_Slope_Mid ]
		[0.5 T13_Slope_High ]
		[1.0 T13_Slope_High ]
	}
	turbulence .25
	lambda 4
	omega .3
}  

#declare T13_LandformB =
texture {
	gradient y
	texture_map {
		[0.0 T13_Slope_Low]
		[0.2 T13_Slope_Low]
		[0.3 T13_Slope_Mid]
		[0.4 T13_Slope_Mid]
		[0.5 T13_Slope_High]
		[1.0 T13_Slope_High]
	}
	turbulence .25
	lambda 4
	omega .3
}   

#declare Tex_Scale = 0.1;
#declare Tex_Scale2 = <.025,.05,.025>;

#declare T13_Landform =
texture {
	slope y
	texture_map {
		[0.0 T13_Low scale Tex_Scale]
		[0.1 T13_Low scale Tex_Scale] 
		[0.1 T13_Rock scale Tex_Scale2]
		[0.8 T13_Rock scale Tex_Scale2]
		[0.8 T13_Low scale Tex_Scale]
		[1.0 T13_Low scale Tex_Scale]
	}
	turbulence 0.05
}                                