#include "ptexture.inc"   
#include "grass.inc"
#include "wflowers.inc"
#include "flowers.inc"

#declare Plant_Rand = seed (169);

#declare Plant_Scale = 0.1;
#declare Grass_Scale = 0.1;
#declare Wflowers_Scale = 0.1;
#declare Flowers_Scale = 0.11;  

#declare Grass_Frequency	= 0.7;
#declare Wflower_Frequency	= 0.2;
#declare Flower_Frequency   = 0.1;   

#declare Scale_Min = 0.8;
#declare Scale_Max = 1.2;

#declare Grass_Height = 1.0;
#declare Grass_Variation = 0.5;
#declare Grass_Jitter = 0.1;

#macro DRAW_CONE (ORIGIN)

#local Grass_Min = (Grass_Height - (Grass_Variation / 2));	
#local S1 = rand(Plant_Rand);
#if (S1 < 0.5) #local S1 = 1; #else #local S1 = -1; #end
#local S2 = rand(Plant_Rand);
#if (S2 < 0.5) #local S2 = 1; #else #local S2 = -1; #end
#local NX = (ORIGIN.x + (rand(Plant_Rand) * Grass_Jitter * S1));
#local NZ = (ORIGIN.z + (rand(Plant_Rand) * Grass_Jitter * S2));
#local NY = (ORIGIN.y + ((rand(Plant_Rand) * Grass_Variation) + Grass_Min));
#local NP1 = <NX,NY,NZ>;
#local S3 = int(rand(Plant_Rand) * 8);

cone {ORIGIN,.025,NP1,0
#if (S3 = 0)texture{Grass_Texture1}#end
#if (S3 = 1)texture{Grass_Texture2}#end
#if (S3 = 2)texture{Grass_Texture3}#end
#if (S3 = 3)texture{Grass_Texture4}#end
#if (S3 = 4)texture{Grass_Texture5}#end
#if (S3 = 5)texture{Grass_Texture6}#end
#if (S3 = 6)texture{Grass_Texture7}#end
#if (S3 > 6)texture{Grass_Texture8}#end  
}

#local GQTY = 10;
#local GCount = 0;
#while (GCount < GQTY)

#local S1 = rand(Plant_Rand);
#if (S1 < 0.5) #local S1 = 1; #else #local S1 = -1; #end
#local S2 = rand(Plant_Rand);
#if (S2 < 0.5) #local S2 = 1; #else #local S2 = -1; #end
#local NX = (ORIGIN.x + (rand(Plant_Rand) * Grass_Jitter * S1 * 3));
#local NZ = (ORIGIN.z + (rand(Plant_Rand) * Grass_Jitter * S2 * 3));
#local NY = (ORIGIN.y + ((rand(Plant_Rand) * Grass_Variation) + Grass_Min));
#local NP1 = <NX,NY,NZ>;  
#local S1 = rand(Plant_Rand);
#if (S1 < 0.5) #local S1 = 1; #else #local S1 = -1; #end
#local S2 = rand(Plant_Rand);
#if (S2 < 0.5) #local S2 = 1; #else #local S2 = -1; #end
#local NX = (ORIGIN.x + (rand(Plant_Rand) * Grass_Jitter * S1));
#local NZ = (ORIGIN.z + (rand(Plant_Rand) * Grass_Jitter * S2));
#local NY = (ORIGIN.y + (rand(Plant_Rand) * Grass_Jitter * S2));
#local NP2 = <NX,NY,NZ>;
#local S3 = int(rand(Plant_Rand) * 8);

cone {NP2,.015,NP1,0
#if (S3 = 0)texture{Grass_Texture1}#end
#if (S3 = 1)texture{Grass_Texture2}#end
#if (S3 = 2)texture{Grass_Texture3}#end
#if (S3 = 3)texture{Grass_Texture4}#end
#if (S3 = 4)texture{Grass_Texture5}#end
#if (S3 = 5)texture{Grass_Texture6}#end
#if (S3 = 6)texture{Grass_Texture7}#end
#if (S3 > 6)texture{Grass_Texture8}#end  
}

#local GCount = (GCount + 1);

#end

#end

#macro INSERT_PLANT (ORIGIN) 

#local Scale_Range = (Scale_Max - Scale_Min);
#local Freq_Step = (Grass_Frequency + Wflower_Frequency); 

#local Ptype = rand(Plant_Rand);
#if (Ptype <= Grass_Frequency)
	#local Pgroup = 1;
#else
	#if (Ptype <= Freq_Step)
		#local Pgroup = 2;
	#else
		#local Pgroup = 3;
	#end
#end

#local Ssize = ((rand(Plant_Rand) * Scale_Range) + Scale_Min);

#if (Pgroup = 1)
	#local Pset = int(rand(Plant_Rand) * 15);
	#if (Pset = 1) 
		object {Grassy_plant scale (Grass_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset = 2) 
		object {maiden_grass scale (Grass_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset = 3) 
		object {curvy_maiden_grass scale (Grass_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset > 3) 
		DRAW_CONE (ORIGIN)
	#end
#end

#if (Pgroup = 2)
	#local Pset = int(rand(Plant_Rand) * 5);
	#if (Pset = 1) 
		object {clover scale (Wflowers_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset = 2) 
		object {Solomon_s_seal scale (Wflowers_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset = 3) 
		object {Pink_daisy scale (Wflowers_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset = 4) 
		object {another_daisy scale (Wflowers_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
#end

#if (Pgroup = 3)
	#local Pset = int(rand(Plant_Rand) * 3);
	#if (Pset = 1) 
		object {gilia scale (Flowers_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
	#if (Pset = 2) 
		object {snapdragon scale (Flowers_Scale * Plant_Scale) scale Ssize rotate <0,(rand(Plant_Rand) * 360),0> translate ORIGIN}
	#end
#end

#end

//eof