// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare clover = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.1804, 3.6901, -0.01776>, 0.1599 }
		cylinder { <-0.1804, 3.6901, -0.01776>, <-0.5408, 7.3669, -0.05326>, 0.1599 }
		cylinder { <-0.5408, 7.3669, -0.05326>, <-1.0803, 11.02162, -0.1064>, 0.1599 }
		texture{Wflower_Texture1}}
	union { // internode
		cylinder { <-1.0803, 11.02162, -0.1064>, <-1.7512, 17.9138, 0.1715>, 0.3 }
		cylinder { <-1.7512, 17.9138, 0.1715>, <-2.07751, 24.8055, 0.8256>, 0.3 }
		cylinder { <-2.07751, 24.8055, 0.8256>, <-2.05731, 31.6594, 1.8522>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.05731, 31.6594, 1.8522>, <-0.4498, 42.9178, 5.2569>, 0.2496 }
			cylinder { <-0.4498, 42.9178, 5.2569>, <2.6688, 53.2616, 10.1767>, 0.2496 }
			cylinder { <2.6688, 53.2616, 10.1767>, <7.1787, 62.2934, 16.4227>, 0.2496 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <7.1787, 62.2934, 16.4227>, <7.06801, 64.478, 19.2331>, 0.2496 }
				cylinder { <7.06801, 64.478, 19.2331>, <5.5223, 65.5699, 22.25>, 0.2496 }
				cylinder { <5.5223, 65.5699, 22.25>, <2.9432, 65.2856, 24.6895>, 0.2496 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <2.9432, 65.2856, 24.6895>, <-2.7433, 68.4859, 29.6936>, <0.8298, 64.8414, 27.5415> }
				triangle { <0.8298, 64.8414, 27.5415>, <-2.7433, 68.4859, 29.6936>, <-3.8618, 66.5277, 32.6869> }
				triangle { <0.8298, 64.8414, 27.5415>, <-3.8618, 66.5277, 32.6869>, <-2.1937, 64.2969, 31.2544> }
				triangle { <-3.8618, 66.5277, 32.6869>, <-2.8332, 64.08396, 32.02152>, <-2.1937, 64.2969, 31.2544> }
				triangle { <0.8298, 64.8414, 27.5415>, <-2.4425, 60.8596, 28.9392>, <2.9432, 65.2856, 24.6895> }
				triangle { <-3.6138, 61.8852, 32.408>, <-2.1937, 64.2969, 31.2544>, <-2.8332, 64.08396, 32.02152> }
				triangle { <-2.8332, 64.08396, 32.02152>, <-3.3814, 64.1488, 32.5505>, <-3.6138, 61.8852, 32.408> }
				triangle { <-3.8618, 66.5277, 32.6869>, <-3.3814, 64.1488, 32.5505>, <-2.8332, 64.08396, 32.02152> }
				triangle { <-2.4425, 60.8596, 28.9392>, <1.3713, 62.7097, 24.9295>, <2.9432, 65.2856, 24.6895> }
				triangle { <2.9432, 65.2856, 24.6895>, <1.204, 67.7198, 25.3364>, <-2.7433, 68.4859, 29.6936> }
				triangle { <0.8298, 64.8414, 27.5415>, <-2.1937, 64.2969, 31.2544>, <-3.6138, 61.8852, 32.408> }
				triangle { <-3.6138, 61.8852, 32.408>, <-2.4425, 60.8596, 28.9392>, <0.8298, 64.8414, 27.5415> }
				triangle { <1.3713, 62.7097, 24.9295>, <-2.4425, 60.8596, 28.9392>, <-0.704, 61.3534, 26.7978> }
				triangle { <1.204, 67.7198, 25.3364>, <-1.2523, 68.52, 27.05339>, <-2.7433, 68.4859, 29.6936> }
				triangle { <-2.7433, 68.4859, 29.6936>, <-3.9256, 67.427, 31.2563>, <-3.8618, 66.5277, 32.6869> }
				triangle { <-3.6138, 61.8852, 32.408>, <-3.554, 61.06141, 30.5402>, <-2.4425, 60.8596, 28.9392> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <7.1787, 62.2934, 16.4227>, <9.3329, 64.9628, 17.3804>, 0.2496 }
				cylinder { <9.3329, 64.9628, 17.3804>, <12.03651, 67.2799, 17.31>, 0.2496 }
				cylinder { <12.03651, 67.2799, 17.31>, <14.9733, 68.9739, 16.2197>, 0.2496 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <14.9733, 68.9739, 16.2197>, <19.6325, 72.4987, 10.4328>, <18.2162, 70.1115, 15.2263> }
				triangle { <18.2162, 70.1115, 15.2263>, <19.6325, 72.4987, 10.4328>, <23.3297, 72.7813, 10.977> }
				triangle { <18.2162, 70.1115, 15.2263>, <23.3297, 72.7813, 10.977>, <22.4956, 71.8471, 13.848> }
				triangle { <23.3297, 72.7813, 10.977>, <23.4225, 72.2283, 13.6526>, <22.4956, 71.8471, 13.848> }
				triangle { <18.2162, 70.1115, 15.2263>, <21.8462, 73.1062, 17.7506>, <14.9733, 68.9739, 16.2197> }
				triangle { <24.8199, 73.03304, 15.3825>, <22.4956, 71.8471, 13.848>, <23.4225, 72.2283, 13.6526> }
				triangle { <23.4225, 72.2283, 13.6526>, <24.00749, 72.5743, 13.3022>, <24.8199, 73.03304, 15.3825> }
				triangle { <23.3297, 72.7813, 10.977>, <24.00749, 72.5743, 13.3022>, <23.4225, 72.2283, 13.6526> }
				triangle { <21.8462, 73.1062, 17.7506>, <16.5927, 70.6051, 18.1895>, <14.9733, 68.9739, 16.2197> }
				triangle { <14.9733, 68.9739, 16.2197>, <15.05227, 70.2053, 13.4186>, <19.6325, 72.4987, 10.4328> }
				triangle { <18.2162, 70.1115, 15.2263>, <22.4956, 71.8471, 13.848>, <24.8199, 73.03304, 15.3825> }
				triangle { <24.8199, 73.03304, 15.3825>, <21.8462, 73.1062, 17.7506>, <18.2162, 70.1115, 15.2263> }
				triangle { <16.5927, 70.6051, 18.1895>, <21.8462, 73.1062, 17.7506>, <19.3097, 72.09494, 18.3795> }
				triangle { <15.05227, 70.2053, 13.4186>, <16.8974, 71.9178, 11.6063>, <19.6325, 72.4987, 10.4328> }
				triangle { <19.6325, 72.4987, 10.4328>, <21.732, 73.215, 10.632>, <23.3297, 72.7813, 10.977> }
				triangle { <24.8199, 73.03304, 15.3825>, <23.4722, 73.6353, 16.7938>, <21.8462, 73.1062, 17.7506> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <7.1787, 62.2934, 16.4227>, <8.5317, 65.00298, 18.2965>, 0.2496 }
				cylinder { <8.5317, 65.00298, 18.2965>, <9.8847, 67.7125, 20.1703>, 0.2496 }
				cylinder { <9.8847, 67.7125, 20.1703>, <11.2377, 70.422, 22.0441>, 0.2496 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <11.2377, 70.422, 22.0441>, <14.5169, 77.9375, 22.6649>, <13.1019, 72.7548, 24.01392> }
				triangle { <13.1019, 72.7548, 24.01392>, <14.5169, 77.9375, 22.6649>, <16.59, 78.7903, 25.6682> }
				triangle { <13.1019, 72.7548, 24.01392>, <16.59, 78.7903, 25.6682>, <15.4436, 76.04395, 26.645> }
				triangle { <16.59, 78.7903, 25.6682>, <15.9055, 76.6936, 27.2832>, <15.4436, 76.04395, 26.645> }
				triangle { <13.1019, 72.7548, 24.01392>, <12.6353, 74.2478, 29.1198>, <11.2377, 70.422, 22.0441> }
				triangle { <15.6335, 76.5304, 29.6268>, <15.4436, 76.04395, 26.645>, <15.9055, 76.6936, 27.2832> }
				triangle { <15.9055, 76.6936, 27.2832>, <16.224, 77.3253, 27.5732>, <15.6335, 76.5304, 29.6268> }
				triangle { <16.59, 78.7903, 25.6682>, <16.224, 77.3253, 27.5732>, <15.9055, 76.6936, 27.2832> }
				triangle { <12.6353, 74.2478, 29.1198>, <10.5019, 70.7543, 24.9616>, <11.2377, 70.422, 22.0441> }
				triangle { <11.2377, 70.422, 22.0441>, <11.6659, 73.1308, 20.6846>, <14.5169, 77.9375, 22.6649> }
				triangle { <13.1019, 72.7548, 24.01392>, <15.4436, 76.04395, 26.645>, <15.6335, 76.5304, 29.6268> }
				triangle { <15.6335, 76.5304, 29.6268>, <12.6353, 74.2478, 29.1198>, <13.1019, 72.7548, 24.01392> }
				triangle { <10.5019, 70.7543, 24.9616>, <12.6353, 74.2478, 29.1198>, <11.3131, 72.4321, 27.4444> }
				triangle { <11.6659, 73.1308, 20.6846>, <12.5722, 76.0237, 21.3418>, <14.5169, 77.9375, 22.6649> }
				triangle { <14.5169, 77.9375, 22.6649>, <15.3931, 78.8896, 24.4778>, <16.59, 78.7903, 25.6682> }
				triangle { <15.6335, 76.5304, 29.6268>, <13.7827, 75.6841, 29.798>, <12.6353, 74.2478, 29.1198> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <-2.05731, 31.6594, 1.8522>, <-0.3437, 37.7781, 4.6192>, 0.3 }
		cylinder { <-0.3437, 37.7781, 4.6192>, <2.8334, 42.3415, 8.7558>, 0.3 }
		cylinder { <2.8334, 42.3415, 8.7558>, <7.04859, 44.7381, 13.7074>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <7.04859, 44.7381, 13.7074>, <8.5047, 45.08714, 15.3478>, 0.0467 }
			cylinder { <8.5047, 45.08714, 15.3478>, <10.01014, 45.00363, 16.9786>, 0.0467 }
			cylinder { <10.01014, 45.00363, 16.9786>, <11.507, 44.4908, 18.5371>, 0.0467 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <11.507, 44.4908, 18.5371>, <11.6568, 44.3246, 19.1648>, 0.0467 }
				cylinder { <11.6568, 44.3246, 19.1648>, <11.4683, 44.1892, 19.7893>, 0.0467 }
				cylinder { <11.4683, 44.1892, 19.7893>, <10.9906, 44.1198, 20.2486>, 0.0467 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <10.9906, 44.1198, 20.2486>, <10.4086, 44.341, 21.6555>, <10.5446, 43.9345, 20.7119> }
				triangle { <10.5446, 43.9345, 20.7119>, <10.4086, 44.341, 21.6555>, <9.9152, 43.9042, 21.8951> }
				triangle { <10.5446, 43.9345, 20.7119>, <9.9152, 43.9042, 21.8951>, <9.9299, 43.7248, 21.3374> }
				triangle { <9.9152, 43.9042, 21.8951>, <9.7888, 43.6744, 21.456>, <9.9299, 43.7248, 21.3374> }
				triangle { <10.5446, 43.9345, 20.7119>, <9.5629, 43.758, 20.6536>, <10.9906, 44.1198, 20.2486> }
				triangle { <9.4033, 43.5191, 21.3044>, <9.9299, 43.7248, 21.3374>, <9.7888, 43.6744, 21.456> }
				triangle { <9.7888, 43.6744, 21.456>, <9.702, 43.669, 21.5695>, <9.4033, 43.5191, 21.3044> }
				triangle { <9.9152, 43.9042, 21.8951>, <9.702, 43.669, 21.5695>, <9.7888, 43.6744, 21.456> }
				triangle { <9.5629, 43.758, 20.6536>, <10.4544, 44.0344, 20.08746>, <10.9906, 44.1198, 20.2486> }
				triangle { <10.9906, 44.1198, 20.2486>, <11.01732, 44.4257, 20.732>, <10.4086, 44.341, 21.6555> }
				triangle { <10.5446, 43.9345, 20.7119>, <9.9299, 43.7248, 21.3374>, <9.4033, 43.5191, 21.3044> }
				triangle { <9.4033, 43.5191, 21.3044>, <9.5629, 43.758, 20.6536>, <10.5446, 43.9345, 20.7119> }
				triangle { <10.4544, 44.0344, 20.08746>, <9.5629, 43.758, 20.6536>, <9.9382, 43.8948, 20.3141> }
				triangle { <11.01732, 44.4257, 20.732>, <10.7114, 44.5292, 21.2142>, <10.4086, 44.341, 21.6555> }
				triangle { <10.4086, 44.341, 21.6555>, <10.0632, 44.1726, 21.8166>, <9.9152, 43.9042, 21.8951> }
				triangle { <9.4033, 43.5191, 21.3044>, <9.377, 43.6845, 20.9609>, <9.5629, 43.758, 20.6536> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <11.507, 44.4908, 18.5371>, <12.09456, 44.3681, 18.8265>, 0.0467 }
				cylinder { <12.09456, 44.3681, 18.8265>, <12.7518, 44.2908, 18.9038>, 0.0467 }
				cylinder { <12.7518, 44.2908, 18.9038>, <13.402, 44.2681, 18.7599>, 0.0467 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <13.402, 44.2681, 18.7599>, <14.673, 44.8284, 18.09865>, <14.02495, 44.1533, 18.5437> }
				triangle { <14.02495, 44.1533, 18.5437>, <14.673, 44.8284, 18.09865>, <15.2042, 44.3941, 17.9538> }
				triangle { <14.02495, 44.1533, 18.5437>, <15.2042, 44.3941, 17.9538>, <14.8773, 44.03054, 18.2768> }
				triangle { <15.2042, 44.3941, 17.9538>, <15.05909, 43.991, 18.2331>, <14.8773, 44.03054, 18.2768> }
				triangle { <14.02495, 44.1533, 18.5437>, <14.8036, 43.7007, 18.9762>, <13.402, 44.2681, 18.7599> }
				triangle { <15.2911, 43.689, 18.4583>, <14.8773, 44.03054, 18.2768>, <15.05909, 43.991, 18.2331> }
				triangle { <15.05909, 43.991, 18.2331>, <15.1941, 44.00449, 18.188>, <15.2911, 43.689, 18.4583> }
				triangle { <15.2042, 44.3941, 17.9538>, <15.1941, 44.00449, 18.188>, <15.05909, 43.991, 18.2331> }
				triangle { <14.8036, 43.7007, 18.9762>, <13.7558, 43.9821, 19.0973>, <13.402, 44.2681, 18.7599> }
				triangle { <13.402, 44.2681, 18.7599>, <13.6567, 44.7272, 18.5312>, <14.673, 44.8284, 18.09865> }
				triangle { <14.02495, 44.1533, 18.5437>, <14.8773, 44.03054, 18.2768>, <15.2911, 43.689, 18.4583> }
				triangle { <15.2911, 43.689, 18.4583>, <14.8036, 43.7007, 18.9762>, <14.02495, 44.1533, 18.5437> }
				triangle { <13.7558, 43.9821, 19.0973>, <14.8036, 43.7007, 18.9762>, <14.3069, 43.7993, 19.1118> }
				triangle { <13.6567, 44.7272, 18.5312>, <14.1815, 44.9139, 18.3686>, <14.673, 44.8284, 18.09865> }
				triangle { <14.673, 44.8284, 18.09865>, <15.04506, 44.6433, 18.0664>, <15.2042, 44.3941, 17.9538> }
				triangle { <15.2911, 43.689, 18.4583>, <15.1267, 43.699, 18.8031>, <14.8036, 43.7007, 18.9762> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <11.507, 44.4908, 18.5371>, <11.9561, 44.337, 19.00476>, 0.0467 }
				cylinder { <11.9561, 44.337, 19.00476>, <12.4051, 44.1831, 19.4723>, 0.0467 }
				cylinder { <12.4051, 44.1831, 19.4723>, <12.8542, 44.02935, 19.9399>, 0.0467 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <12.8542, 44.02935, 19.9399>, <14.1908, 44.2446, 20.6706>, <13.3262, 43.7773, 20.342> }
				triangle { <13.3262, 43.7773, 20.342>, <14.1908, 44.2446, 20.6706>, <14.4792, 43.711, 21.02241> }
				triangle { <13.3262, 43.7773, 20.342>, <14.4792, 43.711, 21.02241>, <13.9567, 43.4711, 20.9091> }
				triangle { <14.4792, 43.711, 21.02241>, <14.07711, 43.3953, 21.03667>, <13.9567, 43.4711, 20.9091> }
				triangle { <13.3262, 43.7773, 20.342>, <13.2647, 43.2925, 21.2133>, <12.8542, 44.02935, 19.9399> }
				triangle { <13.9391, 43.1066, 21.3422>, <13.9567, 43.4711, 20.9091>, <14.07711, 43.3953, 21.03667> }
				triangle { <14.07711, 43.3953, 21.03667>, <14.1872, 43.3782, 21.1262>, <13.9391, 43.1066, 21.3422> }
				triangle { <14.4792, 43.711, 21.02241>, <14.1872, 43.3782, 21.1262>, <14.07711, 43.3953, 21.03667> }
				triangle { <13.2647, 43.2925, 21.2133>, <12.6912, 43.7571, 20.409>, <12.8542, 44.02935, 19.9399> }
				triangle { <12.8542, 44.02935, 19.9399>, <13.2851, 44.3909, 20.04713>, <14.1908, 44.2446, 20.6706> }
				triangle { <13.3262, 43.7773, 20.342>, <13.9567, 43.4711, 20.9091>, <13.9391, 43.1066, 21.3422> }
				triangle { <13.9391, 43.1066, 21.3422>, <13.2647, 43.2925, 21.2133>, <13.3262, 43.7773, 20.342> }
				triangle { <12.6912, 43.7571, 20.409>, <13.2647, 43.2925, 21.2133>, <12.9202, 43.4935, 20.8731> }
				triangle { <13.2851, 44.3909, 20.04713>, <13.7356, 44.457, 20.407>, <14.1908, 44.2446, 20.6706> }
				triangle { <14.1908, 44.2446, 20.6706>, <14.3649, 43.9991, 20.9588>, <14.4792, 43.711, 21.02241> }
				triangle { <13.9391, 43.1066, 21.3422>, <13.5736, 43.2066, 21.3911>, <13.2647, 43.2925, 21.2133> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <7.04859, 44.7381, 13.7074>, <9.002522, 46.4095, 15.1596>, 0.1278 }
		cylinder { <9.002522, 46.4095, 15.1596>, <10.9171, 48.5623, 15.8075>, 0.1278 }
		cylinder { <10.9171, 48.5623, 15.8075>, <12.599, 50.9794, 15.5857>, 0.1278 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <12.599, 50.9794, 15.5857>, <13.5929, 52.6623, 15.07147>, 0.0425 }
			cylinder { <13.5929, 52.6623, 15.07147>, <14.3913, 54.3094, 14.2144>, 0.0425 }
			cylinder { <14.3913, 54.3094, 14.2144>, <14.9636, 55.8571, 13.04755>, 0.0425 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <14.9636, 55.8571, 13.04755>, <15.3363, 56.09575, 12.633>, 0.0425 }
				cylinder { <15.3363, 56.09575, 12.633>, <15.813, 56.04655, 12.2616>, 0.0425 }
				cylinder { <15.813, 56.04655, 12.2616>, <16.2701, 55.7223, 12.03003>, 0.0425 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <16.2701, 55.7223, 12.03003>, <17.6, 55.5683, 11.6207>, <16.6747, 55.4059, 11.7027> }
				triangle { <16.6747, 55.4059, 11.7027>, <17.6, 55.5683, 11.6207>, <17.7448, 55.1172, 11.1934> }
				triangle { <16.6747, 55.4059, 11.7027>, <17.7448, 55.1172, 11.1934>, <17.2406, 54.9751, 11.2937> }
				triangle { <17.7448, 55.1172, 11.1934>, <17.3505, 54.8704, 11.209>, <17.2406, 54.9751, 11.2937> }
				triangle { <16.6747, 55.4059, 11.7027>, <16.8317, 54.5128, 11.638>, <16.2701, 55.7223, 12.03003> }
				triangle { <17.2788, 54.4759, 11.1714>, <17.2406, 54.9751, 11.2937>, <17.3505, 54.8704, 11.209> }
				triangle { <17.3505, 54.8704, 11.209>, <17.4595, 54.8193, 11.1594>, <17.2788, 54.4759, 11.1714> }
				triangle { <17.7448, 55.1172, 11.1934>, <17.4595, 54.8193, 11.1594>, <17.3505, 54.8704, 11.209> }
				triangle { <16.8317, 54.5128, 11.638>, <16.2611, 55.2079, 12.06003>, <16.2701, 55.7223, 12.03003> }
				triangle { <16.2701, 55.7223, 12.03003>, <16.7567, 55.9061, 12.06084>, <17.6, 55.5683, 11.6207> }
				triangle { <16.6747, 55.4059, 11.7027>, <17.2406, 54.9751, 11.2937>, <17.2788, 54.4759, 11.1714> }
				triangle { <17.2788, 54.4759, 11.1714>, <16.8317, 54.5128, 11.638>, <16.6747, 55.4059, 11.7027> }
				triangle { <16.2611, 55.2079, 12.06003>, <16.8317, 54.5128, 11.638>, <16.5221, 54.7867, 11.8762> }
				triangle { <16.7567, 55.9061, 12.06084>, <17.2533, 55.7662, 11.9481>, <17.6, 55.5683, 11.6207> }
				triangle { <17.6, 55.5683, 11.6207>, <17.7517, 55.2753, 11.4339>, <17.7448, 55.1172, 11.1934> }
				triangle { <17.2788, 54.4759, 11.1714>, <17.08943, 54.4068, 11.4546>, <16.8317, 54.5128, 11.638> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <14.9636, 55.8571, 13.04755>, <14.9727, 56.4074, 12.7931>, 0.0425 }
				cylinder { <14.9727, 56.4074, 12.7931>, <14.818, 56.9793, 12.664>, 0.0425 }
				cylinder { <14.818, 56.9793, 12.664>, <14.5178, 57.506, 12.6754>, 0.0425 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <14.5178, 57.506, 12.6754>, <13.8832, 58.5586, 13.3456>, <14.1325, 57.9768, 12.6466> }
				triangle { <14.1325, 57.9768, 12.6466>, <13.8832, 58.5586, 13.3456>, <13.4493, 58.9093, 13.03596> }
				triangle { <14.1325, 57.9768, 12.6466>, <13.4493, 58.9093, 13.03596>, <13.6413, 58.6335, 12.6218> }
				triangle { <13.4493, 58.9093, 13.03596>, <13.5413, 58.774, 12.6002>, <13.6413, 58.6335, 12.6218> }
				triangle { <14.1325, 57.9768, 12.6466>, <14.06517, 58.6656, 12.05711>, <14.5178, 57.506, 12.6754> }
				triangle { <13.5277, 58.971, 12.2493>, <13.6413, 58.6335, 12.6218>, <13.5413, 58.774, 12.6002> }
				triangle { <13.5413, 58.774, 12.6002>, <13.4746, 58.8833, 12.6237>, <13.5277, 58.971, 12.2493> }
				triangle { <13.4493, 58.9093, 13.03596>, <13.4746, 58.8833, 12.6237>, <13.5413, 58.774, 12.6002> }
				triangle { <14.06517, 58.6656, 12.05711>, <14.5628, 57.8358, 12.282>, <14.5178, 57.506, 12.6754> }
				triangle { <14.5178, 57.506, 12.6754>, <14.4568, 57.757, 13.128>, <13.8832, 58.5586, 13.3456> }
				triangle { <14.1325, 57.9768, 12.6466>, <13.6413, 58.6335, 12.6218>, <13.5277, 58.971, 12.2493> }
				triangle { <13.5277, 58.971, 12.2493>, <14.06517, 58.6656, 12.05711>, <14.1325, 57.9768, 12.6466> }
				triangle { <14.5628, 57.8358, 12.282>, <14.06517, 58.6656, 12.05711>, <14.347, 58.2833, 12.1017> }
				triangle { <14.4568, 57.757, 13.128>, <14.2615, 58.2082, 13.3209>, <13.8832, 58.5586, 13.3456> }
				triangle { <13.8832, 58.5586, 13.3456>, <13.6804, 58.8405, 13.1933>, <13.4493, 58.9093, 13.03596> }
				triangle { <13.5277, 58.971, 12.2493>, <13.8419, 58.9066, 12.1149>, <14.06517, 58.6656, 12.05711> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <14.9636, 55.8571, 13.04755>, <15.1353, 56.3215, 12.6974>, 0.0425 }
				cylinder { <15.1353, 56.3215, 12.6974>, <15.307, 56.7858, 12.3474>, 0.0425 }
				cylinder { <15.307, 56.7858, 12.3474>, <15.4787, 57.2502, 11.9973>, 0.0425 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <15.4787, 57.2502, 11.9973>, <15.7544, 58.6055, 11.7806>, <15.5542, 57.7025, 11.5966> }
				triangle { <15.5542, 57.7025, 11.5966>, <15.7544, 58.6055, 11.7806>, <15.7287, 58.8381, 11.187> }
				triangle { <15.5542, 57.7025, 11.5966>, <15.7287, 58.8381, 11.187>, <15.6903, 58.3188, 11.07233> }
				triangle { <15.7287, 58.8381, 11.187>, <15.7241, 58.4376, 10.95>, <15.6903, 58.3188, 11.07233> }
				triangle { <15.5542, 57.7025, 11.5966>, <16.04408, 57.7557, 10.8325>, <15.4787, 57.2502, 11.9973> }
				triangle { <15.8804, 58.3346, 10.5935>, <15.6903, 58.3188, 11.07233>, <15.7241, 58.4376, 10.95> }
				triangle { <15.7241, 58.4376, 10.95>, <15.7553, 58.5496, 10.8915>, <15.8804, 58.3346, 10.5935> }
				triangle { <15.7287, 58.8381, 11.187>, <15.7553, 58.5496, 10.8915>, <15.7241, 58.4376, 10.95> }
				triangle { <16.04408, 57.7557, 10.8325>, <15.774, 57.1645, 11.5838>, <15.4787, 57.2502, 11.9973> }
				triangle { <15.4787, 57.2502, 11.9973>, <15.5869, 57.7105, 12.2163>, <15.7544, 58.6055, 11.7806> }
				triangle { <15.5542, 57.7025, 11.5966>, <15.6903, 58.3188, 11.07233>, <15.8804, 58.3346, 10.5935> }
				triangle { <15.8804, 58.3346, 10.5935>, <16.04408, 57.7557, 10.8325>, <15.5542, 57.7025, 11.5966> }
				triangle { <15.774, 57.1645, 11.5838>, <16.04408, 57.7557, 10.8325>, <15.96, 57.4182, 11.1591> }
				triangle { <15.5869, 57.7105, 12.2163>, <15.7644, 58.1912, 12.08842>, <15.7544, 58.6055, 11.7806> }
				triangle { <15.7544, 58.6055, 11.7806>, <15.8279, 58.7762, 11.4501>, <15.7287, 58.8381, 11.187> }
				triangle { <15.8804, 58.3346, 10.5935>, <16.05987, 58.04696, 10.6705>, <16.04408, 57.7557, 10.8325> }
				texture{Wflower_Texture2}}
			}
		}
	union { // inflorescence
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6201, 51.00707, 15.5823>, 0.1 }
				cylinder { <12.6201, 51.00707, 15.5823>, <12.6424, 51.03371, 15.5781>, 0.1 }
				cylinder { <12.6424, 51.03371, 15.5781>, <12.6657, 51.05928, 15.5732>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6657, 51.05928, 15.5732>, <16.03075, 54.4611, 13.8816>, <16.471, 54.4628, 15.5242> }
					triangle { <16.03075, 54.4611, 13.8816>, <21.2814, 56.7548, 13.5837>, <16.471, 54.4628, 15.5242> }
					triangle { <16.03075, 54.4611, 13.8816>, <19.6166, 55.7866, 13.182>, <21.2814, 56.7548, 13.5837> }
					triangle { <21.2814, 56.7548, 13.5837>, <20.2745, 55.7136, 14.5758>, <16.471, 54.4628, 15.5242> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6657, 51.05928, 15.5732>, <15.3051, 55.3774, 15.1934>, <16.1957, 54.4371, 14.09151> }
					triangle { <15.3051, 55.3774, 15.1934>, <18.01605, 59.4751, 12.2304>, <16.1957, 54.4371, 14.09151> }
					triangle { <15.3051, 55.3774, 15.1934>, <16.7057, 58.4672, 13.2969>, <18.01605, 59.4751, 12.2304> }
					triangle { <18.01605, 59.4751, 12.2304>, <17.447, 57.8188, 12.1092>, <16.1957, 54.4371, 14.09151> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6657, 51.05928, 15.5732>, <16.6201, 54.24, 15.522>, <15.4209, 55.3161, 14.9781> }
					triangle { <16.6201, 54.24, 15.522>, <19.1457, 59.2833, 16.5737>, <15.4209, 55.3161, 14.9781> }
					triangle { <16.6201, 54.24, 15.522>, <18.5846, 57.3992, 16.6471>, <19.1457, 59.2833, 16.5737> }
					triangle { <19.1457, 59.2833, 16.5737>, <17.5709, 58.5317, 16.3812>, <15.4209, 55.3161, 14.9781> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6175, 51.00891, 15.5827>, 0.1 }
				cylinder { <12.6175, 51.00891, 15.5827>, <12.6346, 51.03923, 15.5792>, 0.1 }
				cylinder { <12.6346, 51.03923, 15.5792>, <12.6502, 51.07029, 15.5753>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6502, 51.07029, 15.5753>, <14.1862, 55.9068, 15.649>, <14.8907, 55.4385, 14.1737> }
					triangle { <14.1862, 55.9068, 15.649>, <15.09714, 61.02514, 13.2214>, <14.8907, 55.4385, 14.1737> }
					triangle { <14.1862, 55.9068, 15.649>, <14.3649, 59.5427, 14.2875>, <15.09714, 61.02514, 13.2214> }
					triangle { <15.09714, 61.02514, 13.2214>, <14.8483, 59.3301, 12.8377>, <14.8907, 55.4385, 14.1737> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6502, 51.07029, 15.5753>, <15.7274, 55.1021, 15.3952>, <14.2362, 55.9195, 15.3859> }
					triangle { <15.7274, 55.1021, 15.3952>, <17.3744, 60.3592, 16.9984>, <14.2362, 55.9195, 15.3859> }
					triangle { <15.7274, 55.1021, 15.3952>, <17.243, 58.4109, 16.7588>, <17.3744, 60.3592, 16.9984> }
					triangle { <17.3744, 60.3592, 16.9984>, <15.9891, 59.2808, 16.9859>, <14.2362, 55.9195, 15.3859> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6502, 51.07029, 15.5753>, <14.6714, 55.4584, 14.02091>, <15.5518, 55.2695, 15.4634> }
					triangle { <14.6714, 55.4584, 14.02091>, <19.07395, 59.01137, 13.06491>, <15.5518, 55.2695, 15.4634> }
					triangle { <14.6714, 55.4584, 14.02091>, <17.5833, 57.7468, 12.8424>, <19.07395, 59.01137, 13.06491> }
					triangle { <19.07395, 59.01137, 13.06491>, <18.6119, 57.5871, 13.9815>, <15.5518, 55.2695, 15.4634> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6197, 51.00754, 15.5846>, 0.1 }
				cylinder { <12.6197, 51.00754, 15.5846>, <12.6412, 51.03514, 15.5848>, 0.1 }
				cylinder { <12.6412, 51.03514, 15.5848>, <12.6634, 51.06212, 15.5865>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6634, 51.06212, 15.5865>, <16.5973, 54.2526, 15.9063>, <15.3685, 55.3118, 16.4162> }
					triangle { <16.5973, 54.2526, 15.9063>, <19.6956, 58.3115, 18.5226>, <15.3685, 55.3118, 16.4162> }
					triangle { <16.5973, 54.2526, 15.9063>, <19.05328, 56.6017, 17.7918>, <19.6956, 58.3115, 18.5226> }
					triangle { <19.6956, 58.3115, 18.5226>, <18.09597, 57.589, 18.4915>, <15.3685, 55.3118, 16.4162> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6634, 51.06212, 15.5865>, <15.5115, 55.2076, 14.9082>, <16.4744, 54.4248, 16.07095> }
					triangle { <15.5115, 55.2076, 14.9082>, <20.5152, 57.9128, 14.1564>, <16.4744, 54.4248, 16.07095> }
					triangle { <15.5115, 55.2076, 14.9082>, <18.7449, 57.1013, 13.8768>, <20.5152, 57.9128, 14.1564> }
					triangle { <20.5152, 57.9128, 14.1564>, <19.8237, 56.4057, 14.7331>, <16.4744, 54.4248, 16.07095> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6634, 51.06212, 15.5865>, <15.3516, 55.2281, 16.6703>, <15.7192, 55.1118, 15.0141> }
					triangle { <15.3516, 55.2281, 16.6703>, <17.1847, 60.5586, 15.6002>, <15.7192, 55.1118, 15.0141> }
					triangle { <15.3516, 55.2281, 16.6703>, <16.2514, 58.995, 16.3448>, <17.1847, 60.5586, 15.6002> }
					triangle { <17.1847, 60.5586, 15.6002>, <16.4739, 59.1524, 14.8261>, <15.7192, 55.1118, 15.0141> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6191, 51.00772, 15.5814>, 0.1 }
				cylinder { <12.6191, 51.00772, 15.5814>, <12.6392, 51.03568, 15.5754>, 0.1 }
				cylinder { <12.6392, 51.03568, 15.5754>, <12.6594, 51.06321, 15.5678>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6594, 51.06321, 15.5678>, <14.8688, 55.2583, 13.7576>, <16.2407, 54.5238, 14.4435> }
					triangle { <14.8688, 55.2583, 13.7576>, <19.06543, 58.06249, 11.02911>, <16.2407, 54.5238, 14.4435> }
					triangle { <14.8688, 55.2583, 13.7576>, <17.3572, 57.2039, 11.4933>, <19.06543, 58.06249, 11.02911> }
					triangle { <19.06543, 58.06249, 11.02911>, <18.7095, 56.5527, 11.8512>, <16.2407, 54.5238, 14.4435> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6594, 51.06321, 15.5678>, <15.4091, 55.3266, 15.4281>, <15.1171, 55.1574, 13.7614> }
					triangle { <15.4091, 55.3266, 15.4281>, <16.5025, 60.6541, 13.6>, <15.1171, 55.1574, 13.7614> }
					triangle { <15.4091, 55.3266, 15.4281>, <15.9819, 59.09834, 14.6858>, <16.5025, 60.6541, 13.6> }
					triangle { <16.5025, 60.6541, 13.6>, <15.5991, 59.2043, 13.1948>, <15.1171, 55.1574, 13.7614> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6594, 51.06321, 15.5678>, <16.2923, 54.351, 14.2452>, <15.3402, 55.3921, 15.1947> }
					triangle { <16.2923, 54.351, 14.2452>, <20.0562, 58.5377, 15.3519>, <15.3402, 55.3921, 15.1947> }
					triangle { <16.2923, 54.351, 14.2452>, <19.2264, 56.7976, 14.9593>, <20.0562, 58.5377, 15.3519> }
					triangle { <20.0562, 58.5377, 15.3519>, <18.6012, 57.7774, 15.9742>, <15.3402, 55.3921, 15.1947> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6179, 51.00882, 15.5842>, 0.1 }
				cylinder { <12.6179, 51.00882, 15.5842>, <12.6356, 51.03896, 15.5837>, 0.1 }
				cylinder { <12.6356, 51.03896, 15.5837>, <12.6521, 51.06976, 15.5843>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6521, 51.06976, 15.5843>, <15.01923, 55.4222, 16.6844>, <14.4704, 55.8183, 15.1244> }
					triangle { <15.01923, 55.4222, 16.6844>, <15.4008, 61.1451, 16.8326>, <14.4704, 55.8183, 15.1244> }
					triangle { <15.01923, 55.4222, 16.6844>, <15.1822, 59.2524, 17.3228>, <15.4008, 61.1451, 16.8326> }
					triangle { <15.4008, 61.1451, 16.8326>, <14.5526, 59.8295, 16.03775>, <14.4704, 55.8183, 15.1244> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6521, 51.06976, 15.5843>, <15.7767, 55.04479, 15.1447>, <14.8903, 55.5664, 16.4989> }
					triangle { <15.7767, 55.04479, 15.1447>, <19.3081, 59.03815, 17.2665>, <14.8903, 55.5664, 16.4989> }
					triangle { <15.7767, 55.04479, 15.1447>, <18.5746, 57.4485, 16.369>, <19.3081, 59.03815, 17.2665> }
					triangle { <19.3081, 59.03815, 17.2665>, <18.02492, 57.9322, 17.7272>, <14.8903, 55.5664, 16.4989> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6521, 51.06976, 15.5843>, <14.218, 55.8811, 15.1895>, <15.7345, 55.1345, 15.3764> }
					triangle { <14.218, 55.8811, 15.1895>, <17.6901, 59.9852, 13.1845>, <15.7345, 55.1345, 15.3764> }
					triangle { <14.218, 55.8811, 15.1895>, <16.1497, 58.8057, 13.5101>, <17.6901, 59.9852, 13.1845> }
					triangle { <17.6901, 59.9852, 13.1845>, <17.5867, 58.2498, 13.4282>, <15.7345, 55.1345, 15.3764> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6203, 51.00702, 15.5832>, 0.1 }
				cylinder { <12.6203, 51.00702, 15.5832>, <12.643, 51.03356, 15.5808>, 0.1 }
				cylinder { <12.643, 51.03356, 15.5808>, <12.6669, 51.05896, 15.5786>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6669, 51.05896, 15.5786>, <16.5248, 54.1736, 14.4958>, <16.2216, 54.688, 16.08815> }
					triangle { <16.5248, 54.1736, 14.4958>, <21.4616, 56.826, 15.7259>, <16.2216, 54.688, 16.08815> }
					triangle { <16.5248, 54.1736, 14.4958>, <20.1014, 55.6145, 14.9826>, <21.4616, 56.826, 15.7259> }
					triangle { <21.4616, 56.826, 15.7259>, <20.09919, 56.00987, 16.474>, <16.2216, 54.688, 16.08815> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6669, 51.05896, 15.5786>, <15.3343, 55.3434, 15.04484>, <16.5837, 54.2277, 14.7517> }
					triangle { <15.3343, 55.3434, 15.04484>, <19.1631, 58.6915, 12.3895>, <16.5837, 54.2277, 14.7517> }
					triangle { <15.3343, 55.3434, 15.04484>, <17.4955, 57.8963, 13.06569>, <19.1631, 58.6915, 12.3895> }
					triangle { <19.1631, 58.6915, 12.3895>, <18.6547, 57.01878, 12.5489>, <16.5837, 54.2277, 14.7517> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6669, 51.05896, 15.5786>, <16.3512, 54.4908, 16.2153>, <15.5292, 55.236, 14.9265> }
					triangle { <16.3512, 54.4908, 16.2153>, <18.3249, 59.861, 16.6447>, <15.5292, 55.236, 14.9265> }
					triangle { <16.3512, 54.4908, 16.2153>, <17.7341, 58.02737, 17.04321>, <18.3249, 59.861, 16.6447> }
					triangle { <18.3249, 59.861, 16.6447>, <16.9628, 58.9248, 16.05302>, <15.5292, 55.236, 14.9265> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6179, 51.00859, 15.5819>, 0.1 }
				cylinder { <12.6179, 51.00859, 15.5819>, <12.6356, 51.03829, 15.5768>, 0.1 }
				cylinder { <12.6356, 51.03829, 15.5768>, <12.6522, 51.06841, 15.5706>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6522, 51.06841, 15.5706>, <14.1432, 55.8599, 14.8123>, <15.3967, 55.06856, 13.9791> }
					triangle { <14.1432, 55.8599, 14.8123>, <16.1447, 60.1439, 11.5624>, <15.3967, 55.06856, 13.9791> }
					triangle { <14.1432, 55.8599, 14.8123>, <14.9866, 58.9571, 12.621>, <16.1447, 60.1439, 11.5624> }
					triangle { <16.1447, 60.1439, 11.5624>, <16.03666, 58.3934, 11.6409>, <15.3967, 55.06856, 13.9791> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6522, 51.06841, 15.5706>, <15.6223, 55.1826, 15.4762>, <14.301, 55.8025, 14.6033> }
					triangle { <15.6223, 55.1826, 15.4762>, <16.5723, 60.8211, 15.9502>, <14.301, 55.8025, 14.6033> }
					triangle { <15.6223, 55.1826, 15.4762>, <16.5019, 58.8825, 16.2776>, <16.5723, 60.8211, 15.9502> }
					triangle { <16.5723, 60.8211, 15.9502>, <15.2956, 59.6445, 15.6902>, <14.301, 55.8025, 14.6033> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6522, 51.06841, 15.5706>, <15.2643, 55.02104, 13.7509>, <15.4391, 55.3432, 15.4115> }
					triangle { <15.2643, 55.02104, 13.7509>, <19.7503, 58.5975, 13.6845>, <15.4391, 55.3432, 15.4115> }
					triangle { <15.2643, 55.02104, 13.7509>, <18.4629, 57.1727, 13.2567>, <19.7503, 58.5975, 13.6845> }
					triangle { <19.7503, 58.5975, 13.6845>, <18.9019, 57.4521, 14.7093>, <15.4391, 55.3432, 15.4115> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.619, 51.00806, 15.5848>, 0.1 }
				cylinder { <12.619, 51.00806, 15.5848>, <12.6391, 51.03668, 15.5856>, 0.1 }
				cylinder { <12.6391, 51.03668, 15.5856>, <12.6592, 51.06521, 15.5881>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6592, 51.06521, 15.5881>, <16.1669, 54.6095, 16.5319>, <14.8679, 55.6349, 16.1407> }
					triangle { <16.1669, 54.6095, 16.5319>, <17.963, 59.5462, 18.839>, <14.8679, 55.6349, 16.1407> }
					triangle { <16.1669, 54.6095, 16.5319>, <17.647, 57.6416, 18.4608>, <17.963, 59.5462, 18.839> }
					triangle { <17.963, 59.5462, 18.839>, <16.5104, 58.6809, 18.3668>, <14.8679, 55.6349, 16.1407> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6592, 51.06521, 15.5881>, <15.638, 55.1222, 14.9368>, <15.9903, 54.8075, 16.5704> }
					triangle { <15.638, 55.1222, 14.9368>, <20.5566, 58.01188, 15.5506>, <15.9903, 54.8075, 16.5704> }
					triangle { <15.638, 55.1222, 14.9368>, <19.05343, 56.9733, 14.8211>, <20.5566, 58.01188, 15.5506> }
					triangle { <20.5566, 58.01188, 15.5506>, <19.6436, 56.6668, 16.2134>, <15.9903, 54.8075, 16.5704> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6592, 51.06521, 15.5881>, <14.7418, 55.6256, 16.3771>, <15.7779, 55.08285, 15.1427> }
					triangle { <14.7418, 55.6256, 16.3771>, <17.00328, 60.5942, 14.6111>, <15.7779, 55.08285, 15.1427> }
					triangle { <14.7418, 55.6256, 16.3771>, <15.7985, 59.2175, 15.3348>, <17.00328, 60.5942, 14.6111> }
					triangle { <17.00328, 60.5942, 14.6111>, <16.6523, 58.9594, 14.07579>, <15.7779, 55.08285, 15.1427> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6198, 51.00727, 15.5818>, 0.1 }
				cylinder { <12.6198, 51.00727, 15.5818>, <12.6413, 51.03433, 15.5766>, 0.1 }
				cylinder { <12.6413, 51.03433, 15.5766>, <12.6635, 51.0605, 15.5701>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6635, 51.0605, 15.5701>, <15.5496, 54.7762, 13.6671>, <16.4765, 54.4151, 15.04645> }
					triangle { <15.5496, 54.7762, 13.6671>, <20.5853, 57.114, 12.2193>, <16.4765, 54.4151, 15.04645> }
					triangle { <15.5496, 54.7762, 13.6671>, <18.8194, 56.2484, 12.1684>, <20.5853, 57.114, 12.2193> }
					triangle { <20.5853, 57.114, 12.2193>, <19.8708, 55.8713, 13.2328>, <16.4765, 54.4151, 15.04645> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6635, 51.0605, 15.5701>, <15.3268, 55.3725, 15.3048>, <15.7697, 54.7072, 13.8038> }
					triangle { <15.3268, 55.3725, 15.3048>, <17.2431, 60.04533, 12.5821>, <15.7697, 54.7072, 13.8038> }
					triangle { <15.3268, 55.3725, 15.3048>, <16.2659, 58.8164, 13.7676>, <17.2431, 60.04533, 12.5821> }
					triangle { <17.2431, 60.04533, 12.5821>, <16.5594, 58.4537, 12.2968>, <15.7697, 54.7072, 13.8038> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6635, 51.0605, 15.5701>, <16.603, 54.1994, 14.9497>, <15.366, 55.3615, 15.05609> }
					triangle { <16.603, 54.1994, 14.9497>, <19.6487, 58.8989, 16.1982>, <15.366, 55.3615, 15.05609> }
					triangle { <16.603, 54.1994, 14.9497>, <19.01812, 57.04197, 16.04177>, <19.6487, 58.8989, 16.1982> }
					triangle { <19.6487, 58.8989, 16.1982>, <18.04694, 58.1984, 16.3583>, <15.366, 55.3615, 15.05609> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6175, 51.00897, 15.5833>, 0.1 }
				cylinder { <12.6175, 51.00897, 15.5833>, <12.6346, 51.03942, 15.5812>, 0.1 }
				cylinder { <12.6346, 51.03942, 15.5812>, <12.6501, 51.07068, 15.5793>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6501, 51.07068, 15.5793>, <14.4407, 55.7796, 16.1928>, <14.6215, 55.6564, 14.5064> }
					triangle { <14.4407, 55.7796, 16.1928>, <14.881, 61.316, 14.7524>, <14.6215, 55.6564, 14.5064> }
					triangle { <14.4407, 55.7796, 16.1928>, <14.4217, 59.6285, 15.6534>, <14.881, 61.316, 14.7524> }
					triangle { <14.881, 61.316, 14.7524>, <14.4172, 59.7474, 14.115>, <14.6215, 55.6564, 14.5064> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6501, 51.07068, 15.5793>, <15.7722, 55.06206, 15.2989>, <14.4074, 55.8509, 15.9366> }
					triangle { <15.7722, 55.06206, 15.2989>, <18.1691, 59.8412, 17.3807>, <14.4074, 55.8509, 15.9366> }
					triangle { <15.7722, 55.06206, 15.2989>, <17.8452, 57.9943, 16.7853>, <18.1691, 59.8412, 17.3807> }
					triangle { <18.1691, 59.8412, 17.3807>, <16.7819, 58.7834, 17.5776>, <14.4074, 55.8509, 15.9366> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6501, 51.07068, 15.5793>, <14.3674, 55.7083, 14.4388>, <15.6376, 55.2089, 15.4532> }
					triangle { <14.3674, 55.7083, 14.4388>, <18.4754, 59.4145, 12.9196>, <15.6376, 55.2089, 15.4532> }
					triangle { <14.3674, 55.7083, 14.4388>, <16.9114, 58.2212, 12.9161>, <18.4754, 59.4145, 12.9196> }
					triangle { <18.4754, 59.4145, 12.9196>, <18.2298, 57.8189, 13.6093>, <15.6376, 55.2089, 15.4532> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <12.599, 50.9794, 15.5857>, <12.6201, 51.00724, 15.5841>, 0.1 }
				cylinder { <12.6201, 51.00724, 15.5841>, <12.6423, 51.03423, 15.5834>, 0.1 }
				cylinder { <12.6423, 51.03423, 15.5834>, <12.6656, 51.06031, 15.5837>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <12.6656, 51.06031, 15.5837>, <16.7013, 54.126, 15.3148>, <15.7618, 55.03677, 16.4009> }
					triangle { <16.7013, 54.126, 15.3148>, <20.7119, 57.5213, 17.6183>, <15.7618, 55.03677, 16.4009> }
					triangle { <16.7013, 54.126, 15.3148>, <19.7663, 56.01279, 16.7814>, <20.7119, 57.5213, 17.6183> }
					triangle { <20.7119, 57.5213, 17.6183>, <19.1385, 56.813, 17.9417>, <15.7618, 55.03677, 16.4009> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6656, 51.06031, 15.5837>, <15.4233, 55.2719, 14.9396>, <16.6468, 54.2563, 15.5426> }
					triangle { <15.4233, 55.2719, 14.9396>, <20.1103, 58.1102, 13.2381>, <16.6468, 54.2563, 15.5426> }
					triangle { <15.4233, 55.2719, 14.9396>, <18.2924, 57.3694, 13.3668>, <20.1103, 58.1102, 13.2381> }
					triangle { <20.1103, 58.1102, 13.2381>, <19.5364, 56.5079, 13.6686>, <16.6468, 54.2563, 15.5426> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <12.6656, 51.06031, 15.5837>, <15.8191, 54.8985, 16.6233>, <15.647, 55.1563, 14.9513> }
					triangle { <15.8191, 54.8985, 16.6233>, <17.5686, 60.3457, 16.191>, <15.647, 55.1563, 14.9513> }
					triangle { <15.8191, 54.8985, 16.6233>, <16.8137, 58.6493, 16.8411>, <17.5686, 60.3457, 16.191> }
					triangle { <17.5686, 60.3457, 16.191>, <16.5641, 59.1423, 15.4005>, <15.647, 55.1563, 14.9513> }
					texture{Wflower_Texture3}}
				}
			}
		}
	union { // internode
		cylinder { <-2.05731, 31.6594, 1.8522>, <-2.04262, 38.5703, 2.3719>, 0.3 }
		cylinder { <-2.04262, 38.5703, 2.3719>, <-2.03352, 45.5007, 2.3819>, 0.3 }
		cylinder { <-2.03352, 45.5007, 2.3819>, <-2.03006, 52.413, 1.882>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-2.03006, 52.413, 1.882>, <-2.04977, 63.7716, -1.2436>, 0.2477 }
			cylinder { <-2.04977, 63.7716, -1.2436>, <-2.0943, 74.3021, -6.5249>, 0.2477 }
			cylinder { <-2.0943, 74.3021, -6.5249>, <-2.1619, 83.6, -13.7591>, 0.2477 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-2.1619, 83.6, -13.7591>, <-0.4376, 86.02471, -15.6666>, 0.2477 }
				cylinder { <-0.4376, 86.02471, -15.6666>, <2.5831, 87.4547, -16.8157>, 0.2477 }
				cylinder { <2.5831, 87.4547, -16.8157>, <6.1155, 87.5186, -16.9079>, 0.2477 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <6.1155, 87.5186, -16.9079>, <13.2896, 91.4015, -16.6831>, <9.5927, 87.4426, -17.6195> }
				triangle { <9.5927, 87.4426, -17.6195>, <13.2896, 91.4015, -16.6831>, <16.2737, 89.7999, -18.2202> }
				triangle { <9.5927, 87.4426, -17.6195>, <16.2737, 89.7999, -18.2202>, <14.3167, 87.3891, -18.3636> }
				triangle { <16.2737, 89.7999, -18.2202>, <15.3132, 87.2795, -18.5115>, <14.3167, 87.3891, -18.3636> }
				triangle { <9.5927, 87.4426, -17.6195>, <13.3038, 83.7906, -16.6314>, <6.1155, 87.5186, -16.9079> }
				triangle { <16.3534, 85.1808, -18.3646>, <14.3167, 87.3891, -18.3636>, <15.3132, 87.2795, -18.5115> }
				triangle { <15.3132, 87.2795, -18.5115>, <16.05901, 87.4177, -18.5338>, <16.3534, 85.1808, -18.3646> }
				triangle { <16.2737, 89.7999, -18.2202>, <16.05901, 87.4177, -18.5338>, <15.3132, 87.2795, -18.5115> }
				triangle { <13.3038, 83.7906, -16.6314>, <7.6774, 85.06941, -16.1423>, <6.1155, 87.5186, -16.9079> }
				triangle { <6.1155, 87.5186, -16.9079>, <7.5875, 90.05966, -16.1311>, <13.2896, 91.4015, -16.6831> }
				triangle { <9.5927, 87.4426, -17.6195>, <14.3167, 87.3891, -18.3636>, <16.3534, 85.1808, -18.3646> }
				triangle { <16.3534, 85.1808, -18.3646>, <13.3038, 83.7906, -16.6314>, <9.5927, 87.4426, -17.6195> }
				triangle { <7.6774, 85.06941, -16.1423>, <13.3038, 83.7906, -16.6314>, <10.5659, 83.9991, -16.1916> }
				triangle { <7.5875, 90.05966, -16.1311>, <10.4492, 91.1205, -15.7299>, <13.2896, 91.4015, -16.6831> }
				triangle { <13.2896, 91.4015, -16.6831>, <15.2911, 90.5561, -17.08932>, <16.2737, 89.7999, -18.2202> }
				triangle { <16.3534, 85.1808, -18.3646>, <15.1573, 84.1898, -17.0628>, <13.3038, 83.7906, -16.6314> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-2.1619, 83.6, -13.7591>, <-3.3716, 86.2278, -15.7894>, 0.2477 }
				cylinder { <-3.3716, 86.2278, -15.7894>, <-5.6292, 88.3869, -17.4423>, 0.2477 }
				cylinder { <-5.6292, 88.3869, -17.4423>, <-8.6709, 89.8248, -18.5246>, 0.2477 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-8.6709, 89.8248, -18.5246>, <-16.2514, 92.5517, -17.2228>, <-11.8204, 90.7091, -19.9038> }
				triangle { <-11.8204, 90.7091, -19.9038>, <-16.2514, 92.5517, -17.2228>, <-18.6393, 92.716, -20.06952> }
				triangle { <-11.8204, 90.7091, -19.9038>, <-18.6393, 92.716, -20.06952>, <-16.04345, 92.1009, -21.6649> }
				triangle { <-18.6393, 92.716, -20.06952>, <-16.8907, 92.4172, -22.122>, <-16.04345, 92.1009, -21.6649> }
				triangle { <-11.8204, 90.7091, -19.9038>, <-13.1142, 93.7389, -24.05489>, <-8.6709, 89.8248, -18.5246> }
				triangle { <-16.8555, 93.3112, -24.2917>, <-16.04345, 92.1009, -21.6649>, <-16.8907, 92.4172, -22.122> }
				triangle { <-16.8907, 92.4172, -22.122>, <-17.5851, 92.6996, -22.2392>, <-16.8555, 93.3112, -24.2917> }
				triangle { <-18.6393, 92.716, -20.06952>, <-17.5851, 92.6996, -22.2392>, <-16.8907, 92.4172, -22.122> }
				triangle { <-13.1142, 93.7389, -24.05489>, <-8.7203, 91.547, -20.9855>, <-8.6709, 89.8248, -18.5246> }
				triangle { <-8.6709, 89.8248, -18.5246>, <-10.6938, 90.7738, -16.4669>, <-16.2514, 92.5517, -17.2228> }
				triangle { <-11.8204, 90.7091, -19.9038>, <-16.04345, 92.1009, -21.6649>, <-16.8555, 93.3112, -24.2917> }
				triangle { <-16.8555, 93.3112, -24.2917>, <-13.1142, 93.7389, -24.05489>, <-11.8204, 90.7091, -19.9038> }
				triangle { <-8.7203, 91.547, -20.9855>, <-13.1142, 93.7389, -24.05489>, <-10.7367, 92.9134, -22.872> }
				triangle { <-10.6938, 90.7738, -16.4669>, <-13.4102, 92.2111, -16.2916>, <-16.2514, 92.5517, -17.2228> }
				triangle { <-16.2514, 92.5517, -17.2228>, <-17.7333, 93.1833, -18.7364>, <-18.6393, 92.716, -20.06952> }
				triangle { <-16.8555, 93.3112, -24.2917>, <-14.9917, 94.09848, -24.4104>, <-13.1142, 93.7389, -24.05489> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-2.1619, 83.6, -13.7591>, <-2.1822, 86.3893, -15.9294>, 0.2477 }
				cylinder { <-2.1822, 86.3893, -15.9294>, <-2.2025, 89.1786, -18.09965>, 0.2477 }
				cylinder { <-2.2025, 89.1786, -18.09965>, <-2.2228, 91.968, -20.2699>, 0.2477 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-2.2228, 91.968, -20.2699>, <-4.9477, 99.2965, -22.6071>, <-2.5196, 94.3716, -22.8656> }
				triangle { <-2.5196, 94.3716, -22.8656>, <-4.9477, 99.2965, -22.6071>, <-4.5747, 100.3272, -26.1611> }
				triangle { <-2.5196, 94.3716, -22.8656>, <-4.5747, 100.3272, -26.1611>, <-2.8236, 97.7597, -26.2272> }
				triangle { <-4.5747, 100.3272, -26.1611>, <-2.8051, 98.4401, -26.978>, <-2.8236, 97.7597, -26.2272> }
				triangle { <-2.5196, 94.3716, -22.8656>, <1.04595, 96.3452, -26.2532>, <-2.2228, 91.968, -20.2699> }
				triangle { <-1.0445, 98.5112, -28.5282>, <-2.8236, 97.7597, -26.2272>, <-2.8051, 98.4401, -26.978> }
				triangle { <-2.8051, 98.4401, -26.978>, <-2.9089, 99.07658, -27.3779>, <-1.0445, 98.5112, -28.5282> }
				triangle { <-4.5747, 100.3272, -26.1611>, <-2.9089, 99.07658, -27.3779>, <-2.8051, 98.4401, -26.978> }
				triangle { <1.04595, 96.3452, -26.2532>, <0.2096, 92.6027, -21.9144>, <-2.2228, 91.968, -20.2699> }
				triangle { <-2.2228, 91.968, -20.2699>, <-3.6942, 94.4946, -19.4464>, <-4.9477, 99.2965, -22.6071> }
				triangle { <-2.5196, 94.3716, -22.8656>, <-2.8236, 97.7597, -26.2272>, <-1.0445, 98.5112, -28.5282> }
				triangle { <-1.0445, 98.5112, -28.5282>, <1.04595, 96.3452, -26.2532>, <-2.5196, 94.3716, -22.8656> }
				triangle { <0.2096, 92.6027, -21.9144>, <1.04595, 96.3452, -26.2532>, <1.0885, 94.4552, -24.2139> }
				triangle { <-3.6942, 94.4946, -19.4464>, <-4.2055, 97.3707, -20.4172>, <-4.9477, 99.2965, -22.6071> }
				triangle { <-4.9477, 99.2965, -22.6071>, <-4.4885, 100.3671, -24.4857>, <-4.5747, 100.3272, -26.1611> }
				triangle { <-1.0445, 98.5112, -28.5282>, <0.511, 97.7749, -27.4577>, <1.04595, 96.3452, -26.2532> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <-2.03006, 52.413, 1.882>, <-2.8125, 59.2879, 2.2738>, 0.3 }
		cylinder { <-2.8125, 59.2879, 2.2738>, <-4.3579, 65.923, 3.5457>, 0.3 }
		cylinder { <-4.3579, 65.923, 3.5457>, <-6.6208, 72.1229, 5.6603>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.6208, 72.1229, 5.6603>, <-11.5521, 81.1306, 10.5918>, 0.2395 }
			cylinder { <-11.5521, 81.1306, 10.5918>, <-17.5056, 88.6087, 16.7893>, 0.2395 }
			cylinder { <-17.5056, 88.6087, 16.7893>, <-24.2525, 94.2699, 24.01464>, 0.2395 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-24.2525, 94.2699, 24.01464>, <-27.2742, 95.6677, 24.7861>, 0.2395 }
				cylinder { <-27.2742, 95.6677, 24.7861>, <-30.5085, 96.4017, 23.9611>, 0.2395 }
				cylinder { <-30.5085, 96.4017, 23.9611>, <-33.1149, 96.2811, 21.7539>, 0.2395 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-33.1149, 96.2811, 21.7539>, <-39.1935, 99.5422, 17.9215>, <-36.0074, 95.8107, 19.9658> }
				triangle { <-36.0074, 95.8107, 19.9658>, <-39.1935, 99.5422, 17.9215>, <-41.7996, 97.4256, 16.6322> }
				triangle { <-36.0074, 95.8107, 19.9658>, <-41.7996, 97.4256, 16.6322>, <-39.8197, 95.2977, 17.3986> }
				triangle { <-41.7996, 97.4256, 16.6322>, <-40.5917, 95.105, 16.8267>, <-39.8197, 95.2977, 17.3986> }
				triangle { <-36.0074, 95.8107, 19.9658>, <-37.09022, 92.7576, 15.995>, <-33.1149, 96.2811, 21.7539> }
				triangle { <-40.6774, 93.2406, 15.5355>, <-39.8197, 95.2977, 17.3986>, <-40.5917, 95.105, 16.8267> }
				triangle { <-40.5917, 95.105, 16.8267>, <-41.1778, 95.19, 16.3935>, <-40.6774, 93.2406, 15.5355> }
				triangle { <-41.7996, 97.4256, 16.6322>, <-41.1778, 95.19, 16.3935>, <-40.5917, 95.105, 16.8267> }
				triangle { <-37.09022, 92.7576, 15.995>, <-33.1154, 94.309, 19.621>, <-33.1149, 96.2811, 21.7539> }
				triangle { <-33.1149, 96.2811, 21.7539>, <-34.4101, 98.7773, 20.9059>, <-39.1935, 99.5422, 17.9215> }
				triangle { <-36.0074, 95.8107, 19.9658>, <-39.8197, 95.2977, 17.3986>, <-40.6774, 93.2406, 15.5355> }
				triangle { <-40.6774, 93.2406, 15.5355>, <-37.09022, 92.7576, 15.995>, <-36.0074, 95.8107, 19.9658> }
				triangle { <-33.1154, 94.309, 19.621>, <-37.09022, 92.7576, 15.995>, <-34.9241, 93.2167, 17.5209> }
				triangle { <-34.4101, 98.7773, 20.9059>, <-36.5183, 99.7562, 19.04638>, <-39.1935, 99.5422, 17.9215> }
				triangle { <-39.1935, 99.5422, 17.9215>, <-40.637, 98.5561, 16.6917>, <-41.7996, 97.4256, 16.6322> }
				triangle { <-40.6774, 93.2406, 15.5355>, <-38.7829, 92.8808, 15.1857>, <-37.09022, 92.7576, 15.995> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-24.2525, 94.2699, 24.01464>, <-25.2966, 95.9237, 26.8172>, 0.2395 }
				cylinder { <-25.2966, 95.9237, 26.8172>, <-25.2388, 97.3394, 29.9272>, 0.2395 }
				cylinder { <-25.2388, 97.3394, 29.9272>, <-24.08576, 98.3517, 32.981>, 0.2395 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-24.08576, 98.3517, 32.981>, <-18.6276, 101.5751, 37.6809>, <-22.8781, 98.7647, 36.1678> }
				triangle { <-22.8781, 98.7647, 36.1678>, <-18.6276, 101.5751, 37.6809>, <-18.6317, 100.7755, 41.1873> }
				triangle { <-22.8781, 98.7647, 36.1678>, <-18.6317, 100.7755, 41.1873>, <-21.2635, 99.5349, 40.4325> }
				triangle { <-18.6317, 100.7755, 41.1873>, <-21.01074, 99.6846, 41.3673>, <-21.2635, 99.5349, 40.4325> }
				triangle { <-22.8781, 98.7647, 36.1678>, <-25.2181, 100.0036, 40.5554>, <-24.08576, 98.3517, 32.981> }
				triangle { <-22.5555, 99.6867, 43.02988>, <-21.2635, 99.5349, 40.4325>, <-21.01074, 99.6846, 41.3673> }
				triangle { <-21.01074, 99.6846, 41.3673>, <-20.6586, 99.9223, 41.9655>, <-22.5555, 99.6867, 43.02988> }
				triangle { <-18.6317, 100.7755, 41.1873>, <-20.6586, 99.9223, 41.9655>, <-21.01074, 99.6846, 41.3673> }
				triangle { <-25.2181, 100.0036, 40.5554>, <-25.9676, 98.9908, 35.09963>, <-24.08576, 98.3517, 32.981> }
				triangle { <-24.08576, 98.3517, 32.981>, <-21.6848, 100.0368, 33.1357>, <-18.6276, 101.5751, 37.6809> }
				triangle { <-22.8781, 98.7647, 36.1678>, <-21.2635, 99.5349, 40.4325>, <-22.5555, 99.6867, 43.02988> }
				triangle { <-22.5555, 99.6867, 43.02988>, <-25.2181, 100.0036, 40.5554>, <-22.8781, 98.7647, 36.1678> }
				triangle { <-25.9676, 98.9908, 35.09963>, <-25.2181, 100.0036, 40.5554>, <-26.00319, 99.6026, 38.01501> }
				triangle { <-21.6848, 100.0368, 33.1357>, <-20.02604, 101.4965, 35.1303>, <-18.6276, 101.5751, 37.6809> }
				triangle { <-18.6276, 101.5751, 37.6809>, <-18.6265, 101.645, 39.8172>, <-18.6317, 100.7755, 41.1873> }
				triangle { <-22.5555, 99.6867, 43.02988>, <-24.1781, 100.271, 42.099>, <-25.2181, 100.0036, 40.5554> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-24.2525, 94.2699, 24.01464>, <-26.2766, 95.9683, 26.1822>, 0.2395 }
				cylinder { <-26.2766, 95.9683, 26.1822>, <-28.3007, 97.6666, 28.3498>, 0.2395 }
				cylinder { <-28.3007, 97.6666, 28.3498>, <-30.3247, 99.365, 30.5174>, 0.2395 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-30.3247, 99.365, 30.5174>, <-31.7486, 105.1696, 35.6701>, <-32.2948, 100.5739, 33.05561> }
				triangle { <-32.2948, 100.5739, 33.05561>, <-31.7486, 105.1696, 35.6701>, <-34.3866, 104.7726, 38.08208> }
				triangle { <-32.2948, 100.5739, 33.05561>, <-34.3866, 104.7726, 38.08208>, <-34.9792, 102.3822, 36.3588> }
				triangle { <-34.3866, 104.7726, 38.08208>, <-35.6199, 102.7143, 37.0218>, <-34.9792, 102.3822, 36.3588> }
				triangle { <-32.2948, 100.5739, 33.05561>, <-37.3841, 100.9508, 33.5231>, <-30.3247, 99.365, 30.5174> }
				triangle { <-37.8136, 102.1378, 36.9464>, <-34.9792, 102.3822, 36.3588>, <-35.6199, 102.7143, 37.0218> }
				triangle { <-35.6199, 102.7143, 37.0218>, <-35.9545, 103.1408, 37.5161>, <-37.8136, 102.1378, 36.9464> }
				triangle { <-34.3866, 104.7726, 38.08208>, <-35.9545, 103.1408, 37.5161>, <-35.6199, 102.7143, 37.0218> }
				triangle { <-37.3841, 100.9508, 33.5231>, <-33.2103, 99.2304, 30.2105>, <-30.3247, 99.365, 30.5174> }
				triangle { <-30.3247, 99.365, 30.5174>, <-29.4766, 101.9853, 31.5385>, <-31.7486, 105.1696, 35.6701> }
				triangle { <-32.2948, 100.5739, 33.05561>, <-34.9792, 102.3822, 36.3588>, <-37.8136, 102.1378, 36.9464> }
				triangle { <-37.8136, 102.1378, 36.9464>, <-37.3841, 100.9508, 33.5231>, <-32.2948, 100.5739, 33.05561> }
				triangle { <-33.2103, 99.2304, 30.2105>, <-37.3841, 100.9508, 33.5231>, <-35.699, 100.0073, 31.6519> }
				triangle { <-29.4766, 101.9853, 31.5385>, <-30.4673, 104.221, 33.2357>, <-31.7486, 105.1696, 35.6701> }
				triangle { <-31.7486, 105.1696, 35.6701>, <-33.4748, 105.4191, 36.9055>, <-34.3866, 104.7726, 38.08208> }
				triangle { <-37.8136, 102.1378, 36.9464>, <-38.09929, 101.8089, 35.03566>, <-37.3841, 100.9508, 33.5231> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <-6.6208, 72.1229, 5.6603>, <-8.4031, 78.4901, 7.737>, 0.3 }
		cylinder { <-8.4031, 78.4901, 7.737>, <-9.6954, 84.99, 9.7645>, 0.3 }
		cylinder { <-9.6954, 84.99, 9.7645>, <-10.4905, 91.5876, 11.7318>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.4905, 91.5876, 11.7318>, <-9.7265, 100.9681, 14.1964>, 0.2045 }
			cylinder { <-9.7265, 100.9681, 14.1964>, <-7.1117, 110.1068, 16.2693>, 0.2045 }
			cylinder { <-7.1117, 110.1068, 16.2693>, <-2.7466, 118.6526, 17.8707>, 0.2045 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-2.7466, 118.6526, 17.8707>, <-1.3674, 120.5046, 19.6557>, 0.2045 }
				cylinder { <-1.3674, 120.5046, 19.6557>, <-0.2767, 121.1637, 22.2815>, 0.2045 }
				cylinder { <-0.2767, 121.1637, 22.2815>, <0.2419, 120.4585, 25.06584>, 0.2045 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <0.2419, 120.4585, 25.06584>, <0.3908, 121.86, 31.656>, <1.2711, 119.7704, 27.7233> }
				triangle { <1.2711, 119.7704, 27.7233>, <0.3908, 121.86, 31.656>, <2.2515, 120.2483, 33.4927> }
				triangle { <1.2711, 119.7704, 27.7233>, <2.2515, 120.2483, 33.4927>, <2.4834, 118.8334, 31.3635> }
				triangle { <2.2515, 120.2483, 33.4927>, <2.7469, 118.5579, 32.1085>, <2.4834, 118.8334, 31.3635> }
				triangle { <1.2711, 119.7704, 27.7233>, <1.5158, 115.9483, 29.8412>, <0.2419, 120.4585, 25.06584> }
				triangle { <3.08424, 116.6771, 32.4332>, <2.4834, 118.8334, 31.3635>, <2.7469, 118.5579, 32.1085> }
				triangle { <2.7469, 118.5579, 32.1085>, <2.8396, 118.5062, 32.726>, <3.08424, 116.6771, 32.4332> }
				triangle { <2.2515, 120.2483, 33.4927>, <2.8396, 118.5062, 32.726>, <2.7469, 118.5579, 32.1085> }
				triangle { <1.5158, 115.9483, 29.8412>, <0.2041, 118.0788, 25.7659>, <0.2419, 120.4585, 25.06584> }
				triangle { <0.2419, 120.4585, 25.06584>, <-0.5799, 121.9643, 26.896>, <0.3908, 121.86, 31.656> }
				triangle { <1.2711, 119.7704, 27.7233>, <2.4834, 118.8334, 31.3635>, <3.08424, 116.6771, 32.4332> }
				triangle { <3.08424, 116.6771, 32.4332>, <1.5158, 115.9483, 29.8412>, <1.2711, 119.7704, 27.7233> }
				triangle { <0.2041, 118.0788, 25.7659>, <1.5158, 115.9483, 29.8412>, <0.7791, 116.6274, 27.7748> }
				triangle { <-0.5799, 121.9643, 26.896>, <-0.6953, 122.0881, 29.4325>, <0.3908, 121.86, 31.656> }
				triangle { <0.3908, 121.86, 31.656>, <1.1032, 120.8419, 32.9931>, <2.2515, 120.2483, 33.4927> }
				triangle { <3.08424, 116.6771, 32.4332>, <2.03883, 115.9319, 31.3594>, <1.5158, 115.9483, 29.8412> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-2.7466, 118.6526, 17.8707>, <-1.6776, 121.3254, 17.3888>, 0.2045 }
				cylinder { <-1.6776, 121.3254, 17.3888>, <-0.9741, 123.7946, 16.00084>, 0.2045 }
				cylinder { <-0.9741, 123.7946, 16.00084>, <-0.7183, 125.7716, 13.869>, 0.2045 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-0.7183, 125.7716, 13.869>, <-3.154, 129.3025, 8.6713>, <-0.1538, 127.3974, 11.4955> }
				triangle { <-0.1538, 127.3974, 11.4955>, <-3.154, 129.3025, 8.6713>, <-1.2056, 130.4726, 6.6055> }
				triangle { <-0.1538, 127.3974, 11.4955>, <-1.2056, 130.4726, 6.6055>, <0.5008, 129.7209, 8.3697> }
				triangle { <-1.2056, 130.4726, 6.6055>, <0.7096, 130.2349, 7.7431>, <0.5008, 129.7209, 8.3697> }
				triangle { <-0.1538, 127.3974, 11.4955>, <2.5421, 130.7883, 10.8738>, <-0.7183, 125.7716, 13.869> }
				triangle { <2.3159, 131.3173, 7.8114>, <0.5008, 129.7209, 8.3697>, <0.7096, 130.2349, 7.7431> }
				triangle { <0.7096, 130.2349, 7.7431>, <0.671, 130.6269, 7.2558>, <2.3159, 131.3173, 7.8114> }
				triangle { <-1.2056, 130.4726, 6.6055>, <0.671, 130.6269, 7.2558>, <0.7096, 130.2349, 7.7431> }
				triangle { <2.5421, 130.7883, 10.8738>, <0.9836, 127.5678, 14.04669>, <-0.7183, 125.7716, 13.869> }
				triangle { <-0.7183, 125.7716, 13.869>, <-2.7725, 126.5722, 12.6726>, <-3.154, 129.3025, 8.6713> }
				triangle { <-0.1538, 127.3974, 11.4955>, <0.5008, 129.7209, 8.3697>, <2.3159, 131.3173, 7.8114> }
				triangle { <2.3159, 131.3173, 7.8114>, <2.5421, 130.7883, 10.8738>, <-0.1538, 127.3974, 11.4955> }
				triangle { <0.9836, 127.5678, 14.04669>, <2.5421, 130.7883, 10.8738>, <2.02661, 129.4127, 12.6389> }
				triangle { <-2.7725, 126.5722, 12.6726>, <-3.4825, 128.2475, 10.8973>, <-3.154, 129.3025, 8.6713> }
				triangle { <-3.154, 129.3025, 8.6713>, <-2.2286, 130.3928, 7.537>, <-1.2056, 130.4726, 6.6055> }
				triangle { <2.3159, 131.3173, 7.8114>, <2.5304, 131.5422, 9.456>, <2.5421, 130.7883, 10.8738> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-2.7466, 118.6526, 17.8707>, <-1.4371, 121.2164, 18.3512>, 0.2045 }
				cylinder { <-1.4371, 121.2164, 18.3512>, <-0.1276, 123.7801, 18.8316>, 0.2045 }
				cylinder { <-0.1276, 123.7801, 18.8316>, <1.1819, 126.3439, 19.3121>, 0.2045 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <1.1819, 126.3439, 19.3121>, <1.5827, 133.0472, 18.7448>, <2.8557, 128.747, 19.4482> }
				triangle { <2.8557, 128.747, 19.4482>, <1.5827, 133.0472, 18.7448>, <4.3207, 134.4153, 19.00044> }
				triangle { <2.8557, 128.747, 19.4482>, <4.3207, 134.4153, 19.00044>, <4.9918, 132.0549, 19.754> }
				triangle { <4.3207, 134.4153, 19.00044>, <5.4916, 132.7157, 19.8718>, <4.9918, 132.0549, 19.754> }
				triangle { <2.8557, 128.747, 19.4482>, <5.727, 130.1181, 22.4531>, <1.1819, 126.3439, 19.3121> }
				triangle { <6.9494, 132.67, 21.1482>, <4.9918, 132.0549, 19.754>, <5.4916, 132.7157, 19.8718> }
				triangle { <5.4916, 132.7157, 19.8718>, <5.7013, 133.3048, 19.9112>, <6.9494, 132.67, 21.1482> }
				triangle { <4.3207, 134.4153, 19.00044>, <5.7013, 133.3048, 19.9112>, <5.4916, 132.7157, 19.8718> }
				triangle { <5.727, 130.1181, 22.4531>, <2.7155, 126.6057, 21.2444>, <1.1819, 126.3439, 19.3121> }
				triangle { <1.1819, 126.3439, 19.3121>, <-0.05382, 128.4728, 18.8293>, <1.5827, 133.0472, 18.7448> }
				triangle { <2.8557, 128.747, 19.4482>, <4.9918, 132.0549, 19.754>, <6.9494, 132.67, 21.1482> }
				triangle { <6.9494, 132.67, 21.1482>, <5.727, 130.1181, 22.4531>, <2.8557, 128.747, 19.4482> }
				triangle { <2.7155, 126.6057, 21.2444>, <5.727, 130.1181, 22.4531>, <4.3876, 128.2705, 22.1959> }
				triangle { <-0.05382, 128.4728, 18.8293>, <0.2181, 130.9914, 19.04104>, <1.5827, 133.0472, 18.7448> }
				triangle { <1.5827, 133.0472, 18.7448>, <2.9831, 134.1206, 19.2122>, <4.3207, 134.4153, 19.00044> }
				triangle { <6.9494, 132.67, 21.1482>, <6.4045, 131.5636, 22.2797>, <5.727, 130.1181, 22.4531> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <-10.4905, 91.5876, 11.7318>, <-12.1288, 98.1757, 13.1257>, 0.3 }
		cylinder { <-12.1288, 98.1757, 13.1257>, <-14.5747, 104.6118, 13.9161>, 0.3 }
		cylinder { <-14.5747, 104.6118, 13.9161>, <-17.7754, 110.7565, 14.08588>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-17.7754, 110.7565, 14.08588>, <-20.8989, 114.9888, 13.5817>, 0.1111 }
			cylinder { <-20.8989, 114.9888, 13.5817>, <-24.5854, 118.6055, 12.4635>, 0.1111 }
			cylinder { <-24.5854, 118.6055, 12.4635>, <-28.6934, 121.4678, 10.7741>, 0.1111 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-28.6934, 121.4678, 10.7741>, <-29.3483, 122.4494, 9.7155>, 0.1111 }
				cylinder { <-29.3483, 122.4494, 9.7155>, <-29.2557, 123.2988, 8.3803>, 0.1111 }
				cylinder { <-29.2557, 123.2988, 8.3803>, <-28.4395, 123.7954, 7.1153>, 0.1111 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-28.4395, 123.7954, 7.1153>, <-27.3369, 126.3871, 4.7775>, <-27.8148, 124.1486, 5.6938> }
				triangle { <-27.8148, 124.1486, 5.6938>, <-27.3369, 126.3871, 4.7775>, <-26.823, 125.9457, 3.253> }
				triangle { <-27.8148, 124.1486, 5.6938>, <-26.823, 125.9457, 3.253>, <-26.902, 124.677, 3.8258> }
				triangle { <-26.823, 125.9457, 3.253>, <-26.6884, 124.7495, 3.4312>, <-26.902, 124.677, 3.8258> }
				triangle { <-27.8148, 124.1486, 5.6938>, <-25.9159, 123.2914, 4.5492>, <-28.4395, 123.7954, 7.1153> }
				triangle { <-26.00118, 124.0542, 3.04087>, <-26.902, 124.677, 3.8258>, <-26.6884, 124.7495, 3.4312> }
				triangle { <-26.6884, 124.7495, 3.4312>, <-26.54, 124.9048, 3.1673>, <-26.00118, 124.0542, 3.04087> }
				triangle { <-26.823, 125.9457, 3.253>, <-26.54, 124.9048, 3.1673>, <-26.6884, 124.7495, 3.4312> }
				triangle { <-25.9159, 123.2914, 4.5492>, <-27.3573, 123.1071, 6.702>, <-28.4395, 123.7954, 7.1153> }
				triangle { <-28.4395, 123.7954, 7.1153>, <-28.2938, 125.1316, 6.8925>, <-27.3369, 126.3871, 4.7775> }
				triangle { <-27.8148, 124.1486, 5.6938>, <-26.902, 124.677, 3.8258>, <-26.00118, 124.0542, 3.04087> }
				triangle { <-26.00118, 124.0542, 3.04087>, <-25.9159, 123.2914, 4.5492>, <-27.8148, 124.1486, 5.6938> }
				triangle { <-27.3573, 123.1071, 6.702>, <-25.9159, 123.2914, 4.5492>, <-26.4748, 123.0587, 5.6398> }
				triangle { <-28.2938, 125.1316, 6.8925>, <-27.6617, 126.0061, 6.03099>, <-27.3369, 126.3871, 4.7775> }
				triangle { <-27.3369, 126.3871, 4.7775>, <-26.8287, 126.2639, 3.9352>, <-26.823, 125.9457, 3.253> }
				triangle { <-26.00118, 124.0542, 3.04087>, <-25.681, 123.6524, 3.7908>, <-25.9159, 123.2914, 4.5492> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-28.6934, 121.4678, 10.7741>, <-30.139, 122.1161, 10.719>, 0.1111 }
				cylinder { <-30.139, 122.1161, 10.719>, <-31.6287, 122.4781, 11.1221>, 0.1111 }
				cylinder { <-31.6287, 122.4781, 11.1221>, <-32.9886, 122.5116, 11.9362>, 0.1111 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-32.9886, 122.5116, 11.9362>, <-34.9038, 122.7546, 15.04605>, <-34.3703, 122.2668, 12.6887> }
				triangle { <-34.3703, 122.2668, 12.6887>, <-34.9038, 122.7546, 15.04605>, <-36.451, 122.1333, 15.102> }
				triangle { <-34.3703, 122.2668, 12.6887>, <-36.451, 122.1333, 15.102>, <-36.2321, 122.0337, 13.7286> }
				triangle { <-36.451, 122.1333, 15.102>, <-36.6466, 121.9889, 13.9097>, <-36.2321, 122.0337, 13.7286> }
				triangle { <-34.3703, 122.2668, 12.6887>, <-36.6082, 122.7976, 12.08846>, <-32.9886, 122.5116, 11.9362> }
				triangle { <-37.5165, 122.0822, 13.3243>, <-36.2321, 122.0337, 13.7286>, <-36.6466, 121.9889, 13.9097> }
				triangle { <-36.6466, 121.9889, 13.9097>, <-36.9058, 121.9944, 14.1301>, <-37.5165, 122.0822, 13.3243> }
				triangle { <-36.451, 122.1333, 15.102>, <-36.9058, 121.9944, 14.1301>, <-36.6466, 121.9889, 13.9097> }
				triangle { <-36.6082, 122.7976, 12.08846>, <-34.1273, 122.8941, 11.3258>, <-32.9886, 122.5116, 11.9362> }
				triangle { <-32.9886, 122.5116, 11.9362>, <-32.9775, 122.8844, 13.2466>, <-34.9038, 122.7546, 15.04605> }
				triangle { <-34.3703, 122.2668, 12.6887>, <-36.2321, 122.0337, 13.7286>, <-37.5165, 122.0822, 13.3243> }
				triangle { <-37.5165, 122.0822, 13.3243>, <-36.6082, 122.7976, 12.08846>, <-34.3703, 122.2668, 12.6887> }
				triangle { <-34.1273, 122.8941, 11.3258>, <-36.6082, 122.7976, 12.08846>, <-35.4894, 122.936, 11.5547> }
				triangle { <-32.9775, 122.8844, 13.2466>, <-33.8443, 123.1221, 14.2947>, <-34.9038, 122.7546, 15.04605> }
				triangle { <-34.9038, 122.7546, 15.04605>, <-35.8781, 122.6172, 15.1673>, <-36.451, 122.1333, 15.102> }
				triangle { <-37.5165, 122.0822, 13.3243>, <-37.2476, 122.6426, 12.661>, <-36.6082, 122.7976, 12.08846> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-28.6934, 121.4678, 10.7741>, <-29.9258, 122.3265, 10.2673>, 0.1111 }
				cylinder { <-29.9258, 122.3265, 10.2673>, <-31.1581, 123.1852, 9.7604>, 0.1111 }
				cylinder { <-31.1581, 123.1852, 9.7604>, <-32.3905, 124.0439, 9.2536>, 0.1111 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-32.3905, 124.0439, 9.2536>, <-35.1703, 126.3634, 9.7928>, <-33.7591, 124.6534, 8.7141> }
				triangle { <-33.7591, 124.6534, 8.7141>, <-35.1703, 126.3634, 9.7928>, <-36.4389, 126.3824, 8.7096> }
				triangle { <-33.7591, 124.6534, 8.7141>, <-36.4389, 126.3824, 8.7096>, <-35.5627, 125.5659, 7.9957> }
				triangle { <-36.4389, 126.3824, 8.7096>, <-35.9305, 125.7504, 7.8026>, <-35.5627, 125.5659, 7.9957> }
				triangle { <-33.7591, 124.6534, 8.7141>, <-34.3708, 125.514, 6.5844>, <-32.3905, 124.0439, 9.2536> }
				triangle { <-36.02594, 125.8224, 6.7567>, <-35.5627, 125.5659, 7.9957>, <-35.9305, 125.7504, 7.8026> }
				triangle { <-35.9305, 125.7504, 7.8026>, <-36.2044, 125.9449, 7.7482>, <-36.02594, 125.8224, 6.7567> }
				triangle { <-36.4389, 126.3824, 8.7096>, <-36.2044, 125.9449, 7.7482>, <-35.9305, 125.7504, 7.8026> }
				triangle { <-34.3708, 125.514, 6.5844>, <-32.4575, 124.4256, 7.9631>, <-32.3905, 124.0439, 9.2536> }
				triangle { <-32.3905, 124.0439, 9.2536>, <-32.942, 124.9783, 10.07773>, <-35.1703, 126.3634, 9.7928> }
				triangle { <-33.7591, 124.6534, 8.7141>, <-35.5627, 125.5659, 7.9957>, <-36.02594, 125.8224, 6.7567> }
				triangle { <-36.02594, 125.8224, 6.7567>, <-34.3708, 125.514, 6.5844>, <-33.7591, 124.6534, 8.7141> }
				triangle { <-32.4575, 124.4256, 7.9631>, <-34.3708, 125.514, 6.5844>, <-33.3415, 125.0084, 7.0753> }
				triangle { <-32.942, 124.9783, 10.07773>, <-33.9149, 125.958, 10.07836>, <-35.1703, 126.3634, 9.7928> }
				triangle { <-35.1703, 126.3634, 9.7928>, <-35.8739, 126.6237, 9.1446>, <-36.4389, 126.3824, 8.7096> }
				triangle { <-36.02594, 125.8224, 6.7567>, <-35.1602, 125.8708, 6.4835>, <-34.3708, 125.514, 6.5844> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <-17.7754, 110.7565, 14.08588>, <-20.9761, 116.9012, 14.2556>, 0.3 }
		cylinder { <-20.9761, 116.9012, 14.2556>, <-24.1767, 123.0459, 14.4253>, 0.3 }
		cylinder { <-24.1767, 123.0459, 14.4253>, <-27.3774, 129.1906, 14.5951>, 0.3 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-27.3774, 129.1906, 14.5951>, <-28.3801, 131.2913, 15.1102>, 0.05013 }
			cylinder { <-28.3801, 131.2913, 15.1102>, <-29.2458, 133.2982, 16.06221>, 0.05013 }
			cylinder { <-29.2458, 133.2982, 16.06221>, <-29.9414, 135.1342, 17.4145>, 0.05013 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-29.9414, 135.1342, 17.4145>, <-30.4301, 135.4517, 17.829>, 0.05013 }
				cylinder { <-30.4301, 135.4517, 17.829>, <-31.07195, 135.4535, 18.1446>, 0.05013 }
				cylinder { <-31.07195, 135.4535, 18.1446>, <-31.7, 135.1391, 18.2794>, 0.05013 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-31.7, 135.1391, 18.2794>, <-33.3439, 135.1595, 18.4354>, <-32.2896, 134.8196, 18.5371> }
				triangle { <-32.2896, 134.8196, 18.5371>, <-33.3439, 135.1595, 18.4354>, <-33.6803, 134.6337, 18.8559> }
				triangle { <-32.2896, 134.8196, 18.5371>, <-33.6803, 134.6337, 18.8559>, <-33.1009, 134.3892, 18.8425> }
				triangle { <-33.6803, 134.6337, 18.8559>, <-33.2629, 134.2807, 18.906>, <-33.1009, 134.3892, 18.8425> }
				triangle { <-32.2896, 134.8196, 18.5371>, <-32.6215, 133.8006, 18.4976>, <-31.7, 135.1391, 18.2794> }
				triangle { <-33.2501, 133.8066, 18.931>, <-33.1009, 134.3892, 18.8425>, <-33.2629, 134.2807, 18.906> }
				triangle { <-33.2629, 134.2807, 18.906>, <-33.4073, 134.2366, 18.9338>, <-33.2501, 133.8066, 18.931> }
				triangle { <-33.6803, 134.6337, 18.8559>, <-33.4073, 134.2366, 18.9338>, <-33.2629, 134.2807, 18.906> }
				triangle { <-32.6215, 133.8006, 18.4976>, <-31.7613, 134.5393, 18.2016>, <-31.7, 135.1391, 18.2794> }
				triangle { <-31.7, 135.1391, 18.2794>, <-32.2218, 135.4367, 18.1492>, <-33.3439, 135.1595, 18.4354> }
				triangle { <-32.2896, 134.8196, 18.5371>, <-33.1009, 134.3892, 18.8425>, <-33.2501, 133.8066, 18.931> }
				triangle { <-33.2501, 133.8066, 18.931>, <-32.6215, 133.8006, 18.4976>, <-32.2896, 134.8196, 18.5371> }
				triangle { <-31.7613, 134.5393, 18.2016>, <-32.6215, 133.8006, 18.4976>, <-32.1685, 134.0815, 18.3172> }
				triangle { <-32.2218, 135.4367, 18.1492>, <-32.8387, 135.3504, 18.1539>, <-33.3439, 135.1595, 18.4354> }
				triangle { <-33.3439, 135.1595, 18.4354>, <-33.6069, 134.8327, 18.5906>, <-33.6803, 134.6337, 18.8559> }
				triangle { <-33.2501, 133.8066, 18.931>, <-32.9765, 133.71, 18.6412>, <-32.6215, 133.8006, 18.4976> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-29.9414, 135.1342, 17.4145>, <-29.928, 135.7633, 17.7544>, 0.05013 }
				cylinder { <-29.928, 135.7633, 17.7544>, <-29.6939, 136.3972, 17.9888>, 0.05013 }
				cylinder { <-29.6939, 136.3972, 17.9888>, <-29.2667, 136.9617, 18.09031>, 0.05013 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-29.2667, 136.9617, 18.09031>, <-28.2195, 138.1204, 17.5538>, <-28.7603, 137.4447, 18.2526> }
				triangle { <-28.7603, 137.4447, 18.2526>, <-28.2195, 138.1204, 17.5538>, <-27.7426, 138.4394, 18.04089> }
				triangle { <-28.7603, 137.4447, 18.2526>, <-27.7426, 138.4394, 18.04089>, <-28.103, 138.1269, 18.4508> }
				triangle { <-27.7426, 138.4394, 18.04089>, <-27.9721, 138.2728, 18.5109>, <-28.103, 138.1269, 18.4508> }
				triangle { <-28.7603, 137.4447, 18.2526>, <-28.7177, 138.2039, 19.00889>, <-29.2667, 136.9617, 18.09031> }
				triangle { <-28.00983, 138.4807, 18.9362>, <-28.103, 138.1269, 18.4508>, <-27.9721, 138.2728, 18.5109> }
				triangle { <-27.9721, 138.2728, 18.5109>, <-27.8734, 138.3904, 18.5086>, <-28.00983, 138.4807, 18.9362> }
				triangle { <-27.7426, 138.4394, 18.04089>, <-27.8734, 138.3904, 18.5086>, <-27.9721, 138.2728, 18.5109> }
				triangle { <-28.7177, 138.2039, 19.00889>, <-29.3612, 137.332, 18.5631>, <-29.2667, 136.9617, 18.09031> }
				triangle { <-29.2667, 136.9617, 18.09031>, <-29.05089, 137.2695, 17.604>, <-28.2195, 138.1204, 17.5538> }
				triangle { <-28.7603, 137.4447, 18.2526>, <-28.103, 138.1269, 18.4508>, <-28.00983, 138.4807, 18.9362> }
				triangle { <-28.00983, 138.4807, 18.9362>, <-28.7177, 138.2039, 19.00889>, <-28.7603, 137.4447, 18.2526> }
				triangle { <-29.3612, 137.332, 18.5631>, <-28.7177, 138.2039, 19.00889>, <-29.08849, 137.8077, 18.8595> }
				triangle { <-29.05089, 137.2695, 17.604>, <-28.7123, 137.7737, 17.4654>, <-28.2195, 138.1204, 17.5538> }
				triangle { <-28.2195, 138.1204, 17.5538>, <-27.9803, 138.4067, 17.8006>, <-27.7426, 138.4394, 18.04089> }
				triangle { <-28.00983, 138.4807, 18.9362>, <-28.4113, 138.4508, 19.01422>, <-28.7177, 138.2039, 19.00889> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-29.9414, 135.1342, 17.4145>, <-30.1501, 135.685, 17.8201>, 0.05013 }
				cylinder { <-30.1501, 135.685, 17.8201>, <-30.3588, 136.2357, 18.2258>, 0.05013 }
				cylinder { <-30.3588, 136.2357, 18.2258>, <-30.5674, 136.7865, 18.6315>, 0.05013 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-30.5674, 136.7865, 18.6315>, <-30.7271, 138.4014, 18.938>, <-30.6799, 137.3044, 19.1165> }
				triangle { <-30.6799, 137.3044, 19.1165>, <-30.7271, 138.4014, 18.938>, <-30.8031, 138.6353, 19.6493> }
				triangle { <-30.6799, 137.3044, 19.1165>, <-30.8031, 138.6353, 19.6493>, <-30.866, 138.0167, 19.7448> }
				triangle { <-30.8031, 138.6353, 19.6493>, <-30.9155, 138.1542, 19.8886>, <-30.866, 138.0167, 19.7448> }
				triangle { <-30.6799, 137.3044, 19.1165>, <-31.4142, 137.406, 19.8915>, <-30.5674, 136.7865, 18.6315> }
				triangle { <-31.195, 138.0404, 20.2554>, <-30.866, 138.0167, 19.7448>, <-30.9155, 138.1542, 19.8886> }
				triangle { <-30.9155, 138.1542, 19.8886>, <-30.948, 138.2868, 19.9589>, <-31.195, 138.0404, 20.2554> }
				triangle { <-30.8031, 138.6353, 19.6493>, <-30.948, 138.2868, 19.9589>, <-30.9155, 138.1542, 19.8886> }
				triangle { <-31.4142, 137.406, 19.8915>, <-31.01712, 136.7131, 19.03406>, <-30.5674, 136.7865, 18.6315> }
				triangle { <-30.5674, 136.7865, 18.6315>, <-30.5689, 137.3538, 18.3947>, <-30.7271, 138.4014, 18.938> }
				triangle { <-30.6799, 137.3044, 19.1165>, <-30.866, 138.0167, 19.7448>, <-31.195, 138.0404, 20.2554> }
				triangle { <-31.195, 138.0404, 20.2554>, <-31.4142, 137.406, 19.8915>, <-30.6799, 137.3044, 19.1165> }
				triangle { <-31.01712, 136.7131, 19.03406>, <-31.4142, 137.406, 19.8915>, <-31.2921, 137.0165, 19.5041> }
				triangle { <-30.5689, 137.3538, 18.3947>, <-30.7289, 137.937, 18.5441>, <-30.7271, 138.4014, 18.938> }
				triangle { <-30.7271, 138.4014, 18.938>, <-30.8637, 138.5944, 19.3176>, <-30.8031, 138.6353, 19.6493> }
				triangle { <-31.195, 138.0404, 20.2554>, <-31.4262, 137.7392, 20.1004>, <-31.4142, 137.406, 19.8915> }
				texture{Wflower_Texture2}}
			}
		}
	union { // internode
		cylinder { <-27.3774, 129.1906, 14.5951>, <-29.5311, 133.9118, 14.2905>, 0.225 }
		cylinder { <-29.5311, 133.9118, 14.2905>, <-31.4169, 138.6998, 13.5568>, 0.225 }
		cylinder { <-31.4169, 138.6998, 13.5568>, <-33.01695, 143.5087, 12.4013>, 0.225 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-33.01695, 143.5087, 12.4013>, <-33.4053, 145.3668, 11.6275>, 0.0431 }
			cylinder { <-33.4053, 145.3668, 11.6275>, <-33.5361, 147.1151, 10.5654>, 0.0431 }
			cylinder { <-33.5361, 147.1151, 10.5654>, <-33.4044, 148.6866, 9.2558>, 0.0431 }
			texture{Wflower_Texture1}}
		union { // compound leaf
			union { // compound leaf petiolet
				cylinder { <-33.4044, 148.6866, 9.2558>, <-33.1405, 149.2119, 9.07519>, 0.0431 }
				cylinder { <-33.1405, 149.2119, 9.07519>, <-32.7209, 149.6545, 9.1536>, 0.0431 }
				cylinder { <-32.7209, 149.6545, 9.1536>, <-32.2545, 149.8995, 9.4709>, 0.0431 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-32.2545, 149.8995, 9.4709>, <-31.5758, 150.9947, 10.06761>, <-31.7264, 150.1255, 9.6979> }
				triangle { <-31.7264, 150.1255, 9.6979>, <-31.5758, 150.9947, 10.06761>, <-30.9387, 150.9527, 10.1731> }
				triangle { <-31.7264, 150.1255, 9.6979>, <-30.9387, 150.9527, 10.1731>, <-31.03367, 150.4379, 10.03705> }
				triangle { <-30.9387, 150.9527, 10.1731>, <-30.8824, 150.488, 10.1126>, <-31.03367, 150.4379, 10.03705> }
				triangle { <-31.7264, 150.1255, 9.6979>, <-31.1161, 149.7733, 10.2928>, <-32.2545, 149.8995, 9.4709> }
				triangle { <-30.6333, 150.2182, 10.2913>, <-31.03367, 150.4379, 10.03705>, <-30.8824, 150.488, 10.1126> }
				triangle { <-30.8824, 150.488, 10.1126>, <-30.7912, 150.5597, 10.1756>, <-30.6333, 150.2182, 10.2913> }
				triangle { <-30.9387, 150.9527, 10.1731>, <-30.7912, 150.5597, 10.1756>, <-30.8824, 150.488, 10.1126> }
				triangle { <-31.1161, 149.7733, 10.2928>, <-31.9763, 149.6008, 9.7974>, <-32.2545, 149.8995, 9.4709> }
				triangle { <-32.2545, 149.8995, 9.4709>, <-32.2927, 150.3958, 9.6486>, <-31.5758, 150.9947, 10.06761> }
				triangle { <-31.7264, 150.1255, 9.6979>, <-31.03367, 150.4379, 10.03705>, <-30.6333, 150.2182, 10.2913> }
				triangle { <-30.6333, 150.2182, 10.2913>, <-31.1161, 149.7733, 10.2928>, <-31.7264, 150.1255, 9.6979> }
				triangle { <-31.9763, 149.6008, 9.7974>, <-31.1161, 149.7733, 10.2928>, <-31.5292, 149.6206, 10.09253> }
				triangle { <-32.2927, 150.3958, 9.6486>, <-32.0227, 150.7507, 9.9452>, <-31.5758, 150.9947, 10.06761> }
				triangle { <-31.5758, 150.9947, 10.06761>, <-31.2234, 150.9961, 10.2216>, <-30.9387, 150.9527, 10.1731> }
				triangle { <-30.6333, 150.2182, 10.2913>, <-30.8562, 149.965, 10.3939>, <-31.1161, 149.7733, 10.2928> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-33.4044, 148.6866, 9.2558>, <-33.524, 149.0518, 8.7757>, 0.0431 }
				cylinder { <-33.524, 149.0518, 8.7757>, <-33.7889, 149.2682, 8.2646>, 0.0431 }
				cylinder { <-33.7889, 149.2682, 8.2646>, <-34.1679, 149.3103, 7.7822>, 0.0431 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-34.1679, 149.3103, 7.7822>, <-35.4507, 149.2316, 7.1784>, <-34.4983, 149.2598, 7.2627> }
				triangle { <-34.4983, 149.2598, 7.2627>, <-35.4507, 149.2316, 7.1784>, <-35.4947, 149.1328, 6.5404> }
				triangle { <-34.4983, 149.2598, 7.2627>, <-35.4947, 149.1328, 6.5404>, <-34.9626, 149.2242, 6.573> }
				triangle { <-35.4947, 149.1328, 6.5404>, <-35.04787, 149.2242, 6.4187>, <-34.9626, 149.2242, 6.573> }
				triangle { <-34.4983, 149.2598, 7.2627>, <-34.4464, 149.7085, 6.4588>, <-34.1679, 149.3103, 7.7822> }
				triangle { <-34.8858, 149.3951, 6.08504>, <-34.9626, 149.2242, 6.573>, <-35.04787, 149.2242, 6.4187> }
				triangle { <-35.04787, 149.2242, 6.4187>, <-35.1442, 149.225, 6.3285>, <-34.8858, 149.3951, 6.08504> }
				triangle { <-35.4947, 149.1328, 6.5404>, <-35.1442, 149.225, 6.3285>, <-35.04787, 149.2242, 6.4187> }
				triangle { <-34.4464, 149.7085, 6.4588>, <-34.03894, 149.6119, 7.3752>, <-34.1679, 149.3103, 7.7822> }
				triangle { <-34.1679, 149.3103, 7.7822>, <-34.6906, 149.3051, 7.8604>, <-35.4507, 149.2316, 7.1784> }
				triangle { <-34.4983, 149.2598, 7.2627>, <-34.9626, 149.2242, 6.573>, <-34.8858, 149.3951, 6.08504> }
				triangle { <-34.8858, 149.3951, 6.08504>, <-34.4464, 149.7085, 6.4588>, <-34.4983, 149.2598, 7.2627> }
				triangle { <-34.03894, 149.6119, 7.3752>, <-34.4464, 149.7085, 6.4588>, <-34.2012, 149.7196, 6.8758> }
				triangle { <-34.6906, 149.3051, 7.8604>, <-35.1498, 149.3541, 7.5891>, <-35.4507, 149.2316, 7.1784> }
				triangle { <-35.4507, 149.2316, 7.1784>, <-35.5349, 149.2524, 6.8037>, <-35.4947, 149.1328, 6.5404> }
				triangle { <-34.8858, 149.3951, 6.08504>, <-34.6788, 149.6461, 6.2209>, <-34.4464, 149.7085, 6.4588> }
				texture{Wflower_Texture2}}
			union { // compound leaf petiolet
				cylinder { <-33.4044, 148.6866, 9.2558>, <-33.3649, 149.1581, 8.8629>, 0.0431 }
				cylinder { <-33.3649, 149.1581, 8.8629>, <-33.3254, 149.6295, 8.4701>, 0.0431 }
				cylinder { <-33.3254, 149.6295, 8.4701>, <-33.2859, 150.101, 8.07722>, 0.0431 }
				texture{Wflower_Texture1}}
			mesh { // leaf
				triangle { <-33.2859, 150.101, 8.07722>, <-33.8593, 151.1241, 7.2768>, <-33.2175, 150.4971, 7.6082> }
				triangle { <-33.2175, 150.4971, 7.6082>, <-33.8593, 151.1241, 7.2768>, <-33.5264, 151.3552, 6.7722> }
				triangle { <-33.2175, 150.4971, 7.6082>, <-33.5264, 151.3552, 6.7722>, <-33.1352, 151.0596, 7.000538> }
				triangle { <-33.5264, 151.3552, 6.7722>, <-33.1009, 151.1787, 6.8751>, <-33.1352, 151.0596, 7.000538> }
				triangle { <-33.2175, 150.4971, 7.6082>, <-32.5413, 151.0888, 7.401>, <-33.2859, 150.101, 8.07722> }
				triangle { <-32.724, 151.3245, 6.8161>, <-33.1352, 151.0596, 7.000538>, <-33.1009, 151.1787, 6.8751> }
				triangle { <-33.1009, 151.1787, 6.8751>, <-33.1141, 151.2787, 6.7898>, <-32.724, 151.3245, 6.8161> }
				triangle { <-33.5264, 151.3552, 6.7722>, <-33.1141, 151.2787, 6.7898>, <-33.1009, 151.1787, 6.8751> }
				triangle { <-32.5413, 151.0888, 7.401>, <-32.8463, 150.3827, 8.05185>, <-33.2859, 150.101, 8.07722> }
				triangle { <-33.2859, 150.101, 8.07722>, <-33.7121, 150.3997, 7.9851>, <-33.8593, 151.1241, 7.2768> }
				triangle { <-33.2175, 150.4971, 7.6082>, <-33.1352, 151.0596, 7.000538>, <-32.724, 151.3245, 6.8161> }
				triangle { <-32.724, 151.3245, 6.8161>, <-32.5413, 151.0888, 7.401>, <-33.2175, 150.4971, 7.6082> }
				triangle { <-32.8463, 150.3827, 8.05185>, <-32.5413, 151.0888, 7.401>, <-32.6198, 150.7647, 7.7516> }
				triangle { <-33.7121, 150.3997, 7.9851>, <-33.859, 150.8388, 7.7158>, <-33.8593, 151.1241, 7.2768> }
				triangle { <-33.8593, 151.1241, 7.2768>, <-33.6811, 151.348, 7.01983>, <-33.5264, 151.3552, 6.7722> }
				triangle { <-32.724, 151.3245, 6.8161>, <-32.5806, 151.2968, 7.1371>, <-32.5413, 151.0888, 7.401> }
				texture{Wflower_Texture2}}
			}
		}
	union { // inflorescence
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02631, 143.5417, 12.3943>, 0.1 }
				cylinder { <-33.02631, 143.5417, 12.3943>, <-33.03425, 143.5751, 12.3881>, 0.1 }
				cylinder { <-33.03425, 143.5751, 12.3881>, <-33.04074, 143.6091, 12.3827>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.04074, 143.6091, 12.3827>, <-33.03857, 148.547, 11.2102>, <-34.2516, 148.5689, 12.4018> }
					triangle { <-33.03857, 148.547, 11.2102>, <-33.1278, 154.1254, 12.5493>, <-34.2516, 148.5689, 12.4018> }
					triangle { <-33.03857, 148.547, 11.2102>, <-32.5674, 152.3267, 11.9827>, <-33.1278, 154.1254, 12.5493> }
					triangle { <-33.1278, 154.1254, 12.5493>, <-33.4985, 152.5356, 13.1952>, <-34.2516, 148.5689, 12.4018> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04074, 143.6091, 12.3827>, <-34.748, 148.1895, 11.01804>, <-33.1584, 148.6249, 11.4369> }
					triangle { <-34.748, 148.1895, 11.01804>, <-34.2735, 153.2368, 8.3312>, <-33.1584, 148.6249, 11.4369> }
					triangle { <-34.748, 148.1895, 11.01804>, <-34.7808, 151.4035, 8.833>, <-34.2735, 153.2368, 8.3312> }
					triangle { <-34.2735, 153.2368, 8.3312>, <-33.3223, 151.8947, 8.9444>, <-33.1584, 148.6249, 11.4369> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04074, 143.6091, 12.3827>, <-34.0914, 148.5688, 12.6167>, <-34.52, 148.2942, 10.9941> }
					triangle { <-34.0914, 148.5688, 12.6167>, <-37.3733, 153.1596, 11.5812>, <-34.52, 148.2942, 10.9941> }
					triangle { <-34.0914, 148.5688, 12.6167>, <-36.4417, 151.6595, 12.4484>, <-37.3733, 153.1596, 11.5812> }
					triangle { <-37.3733, 153.1596, 11.5812>, <-37.08694, 151.5095, 11.05484>, <-34.52, 148.2942, 10.9941> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02816, 143.5405, 12.3919>, 0.1 }
				cylinder { <-33.02816, 143.5405, 12.3919>, <-33.03978, 143.5716, 12.3811>, 0.1 }
				cylinder { <-33.03978, 143.5716, 12.3811>, <-33.05178, 143.6021, 12.3687>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.05178, 143.6021, 12.3687>, <-35.6317, 147.4767, 10.3468>, <-34.05841, 148.0952, 10.1632> }
					triangle { <-35.6317, 147.4767, 10.3468>, <-36.5215, 151.5099, 6.3642>, <-34.05841, 148.0952, 10.1632> }
					triangle { <-35.6317, 147.4767, 10.3468>, <-36.6407, 149.887, 7.4697>, <-36.5215, 151.5099, 6.3642> }
					triangle { <-36.5215, 151.5099, 6.3642>, <-35.2789, 150.4605, 7.02526>, <-34.05841, 148.0952, 10.1632> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05178, 143.6021, 12.3687>, <-34.6655, 148.3407, 11.533>, <-35.4218, 147.5781, 10.2145> }
					triangle { <-34.6655, 148.3407, 11.533>, <-38.6768, 152.2218, 10.2039>, <-35.4218, 147.5781, 10.2145> }
					triangle { <-34.6655, 148.3407, 11.533>, <-37.3779, 151.0999, 11.1654>, <-38.6768, 152.2218, 10.2039> }
					triangle { <-38.6768, 152.2218, 10.2039>, <-38.3056, 150.5102, 10.08265>, <-35.4218, 147.5781, 10.2145> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05178, 143.6021, 12.3687>, <-33.9915, 147.9593, 9.942>, <-34.8508, 148.2756, 11.375> }
					triangle { <-33.9915, 147.9593, 9.942>, <-34.4582, 153.6716, 9.6756>, <-34.8508, 148.2756, 11.375> }
					triangle { <-33.9915, 147.9593, 9.942>, <-33.8331, 151.8158, 9.487>, <-34.4582, 153.6716, 9.6756> }
					triangle { <-34.4582, 153.6716, 9.6756>, <-34.4413, 152.3306, 10.8084>, <-34.8508, 148.2756, 11.375> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02842, 143.5411, 12.3951>, 0.1 }
				cylinder { <-33.02842, 143.5411, 12.3951>, <-33.04056, 143.5736, 12.3904>, 0.1 }
				cylinder { <-33.04056, 143.5736, 12.3904>, <-33.05335, 143.606, 12.3874>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.05335, 143.606, 12.3874>, <-34.4065, 148.4783, 12.8189>, <-35.663, 147.9546, 11.7998> }
					triangle { <-34.4065, 148.4783, 12.8189>, <-38.24, 152.676, 13.5961>, <-35.663, 147.9546, 11.7998> }
					triangle { <-34.4065, 148.4783, 12.8189>, <-36.7905, 151.3699, 13.8485>, <-38.24, 152.676, 13.5961> }
					triangle { <-38.24, 152.676, 13.5961>, <-38.1027, 150.9885, 13.1319>, <-35.663, 147.9546, 11.7998> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05335, 143.606, 12.3874>, <-34.3841, 148.3228, 11.06895>, <-34.6605, 148.4389, 12.7428> }
					triangle { <-34.3841, 148.3228, 11.06895>, <-34.4022, 154.0183, 11.7617>, <-34.6605, 148.4389, 12.7428> }
					triangle { <-34.3841, 148.3228, 11.06895>, <-34.04992, 152.1946, 11.1134>, <-34.4022, 154.0183, 11.7617> }
					triangle { <-34.4022, 154.0183, 11.7617>, <-34.1128, 152.5152, 12.6214>, <-34.6605, 148.4389, 12.7428> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05335, 143.606, 12.3874>, <-35.8182, 147.8431, 11.9878>, <-34.3718, 148.4174, 11.3022> }
					triangle { <-35.8182, 147.8431, 11.9878>, <-37.7256, 152.4631, 9.1706>, <-34.3718, 148.4174, 11.3022> }
					triangle { <-35.8182, 147.8431, 11.9878>, <-37.5824, 150.6984, 10.02833>, <-37.7256, 152.4631, 9.1706> }
					triangle { <-37.7256, 152.4631, 9.1706>, <-36.4321, 151.2763, 9.1776>, <-34.3718, 148.4174, 11.3022> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02619, 143.5413, 12.3928>, 0.1 }
				cylinder { <-33.02619, 143.5413, 12.3928>, <-33.03387, 143.5742, 12.3836>, 0.1 }
				cylinder { <-33.03387, 143.5742, 12.3836>, <-33.03999, 143.6072, 12.3737>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.03999, 143.6072, 12.3737>, <-33.629, 148.0642, 10.01897>, <-33.4783, 148.6366, 11.6131> }
					triangle { <-33.629, 148.0642, 10.01897>, <-32.2996, 153.5634, 9.06431>, <-33.4783, 148.6366, 11.6131> }
					triangle { <-33.629, 148.0642, 10.01897>, <-32.4951, 151.612, 8.9087>, <-32.2996, 153.5634, 9.06431> }
					triangle { <-32.2996, 153.5634, 9.06431>, <-32.1377, 152.2811, 10.2524>, <-33.4783, 148.6366, 11.6131> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.03999, 143.6072, 12.3737>, <-34.8836, 148.1981, 11.2416>, <-33.5253, 148.21, 10.2186> }
					triangle { <-34.8836, 148.1981, 11.2416>, <-36.3334, 152.371, 7.5804>, <-33.5253, 148.21, 10.2186> }
					triangle { <-34.8836, 148.1981, 11.2416>, <-36.3846, 150.8759, 8.858>, <-36.3334, 152.371, 7.5804> }
					triangle { <-36.3334, 152.371, 7.5804>, <-35.3429, 150.9284, 7.721>, <-33.5253, 148.21, 10.2186> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.03999, 143.6072, 12.3737>, <-33.2111, 148.6248, 11.6309>, <-34.7508, 148.2258, 11.0293> }
					triangle { <-33.2111, 148.6248, 11.6309>, <-35.7987, 153.742, 11.8245>, <-34.7508, 148.2258, 11.0293> }
					triangle { <-33.2111, 148.6248, 11.6309>, <-34.6349, 152.198, 12.1875>, <-35.7987, 153.742, 11.8245> }
					triangle { <-35.7987, 153.742, 11.8245>, <-36.1275, 152.0176, 11.8407>, <-34.7508, 148.2258, 11.0293> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02923, 143.5404, 12.393>, 0.1 }
				cylinder { <-33.02923, 143.5404, 12.393>, <-33.043, 143.5713, 12.3844>, 0.1 }
				cylinder { <-33.043, 143.5713, 12.3844>, <-33.05822, 143.6015, 12.3753>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.05822, 143.6015, 12.3753>, <-36.00648, 147.6762, 11.6961>, <-35.1112, 147.7665, 10.2531> }
					triangle { <-36.00648, 147.6762, 11.6961>, <-39.3841, 151.0823, 8.5481>, <-35.1112, 147.7665, 10.2531> }
					triangle { <-36.00648, 147.6762, 11.6961>, <-38.7106, 149.7703, 9.8502>, <-39.3841, 151.0823, 8.5481> }
					triangle { <-39.3841, 151.0823, 8.5481>, <-38.1535, 149.8376, 8.4129>, <-35.1112, 147.7665, 10.2531> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05822, 143.6015, 12.3753>, <-34.4248, 148.4007, 11.4498>, <-35.9688, 147.6884, 11.431> }
					triangle { <-34.4248, 148.4007, 11.4498>, <-37.7461, 153.0156, 12.2188>, <-35.9688, 147.6884, 11.431> }
					triangle { <-34.4248, 148.4007, 11.4498>, <-36.2528, 151.7354, 12.2522>, <-37.7461, 153.0156, 12.2188> }
					triangle { <-37.7461, 153.0156, 12.2188>, <-37.7129, 151.2749, 12.4441>, <-35.9688, 147.6884, 11.431> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05822, 143.6015, 12.3753>, <-35.2479, 147.5826, 10.114>, <-34.6682, 148.368, 11.5065> }
					triangle { <-35.2479, 147.5826, 10.114>, <-35.3868, 153.0553, 8.3966>, <-34.6682, 148.368, 11.5065> }
					triangle { <-35.2479, 147.5826, 10.114>, <-35.2535, 151.0932, 8.4465>, <-35.3868, 153.0553, 8.3966> }
					triangle { <-35.3868, 153.0553, 8.3966>, <-34.588, 151.9733, 9.525>, <-34.6682, 148.368, 11.5065> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02695, 143.5416, 12.3949>, 0.1 }
				cylinder { <-33.02695, 143.5416, 12.3949>, <-33.03616, 143.575, 12.39>, 0.1 }
				cylinder { <-33.03616, 143.575, 12.39>, <-33.04456, 143.6087, 12.3866>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.04456, 143.6087, 12.3866>, <-33.2608, 148.6653, 12.01069>, <-34.8761, 148.3739, 12.4552> }
					triangle { <-33.2608, 148.6653, 12.01069>, <-34.8259, 153.8716, 13.8448>, <-34.8761, 148.3739, 12.4552> }
					triangle { <-33.2608, 148.6653, 12.01069>, <-33.7953, 152.2575, 13.3948>, <-34.8259, 153.8716, 13.8448> }
					triangle { <-34.8259, 153.8716, 13.8448>, <-35.2037, 152.166, 14.01844>, <-34.8761, 148.3739, 12.4552> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04456, 143.6087, 12.3866>, <-34.6052, 148.2251, 10.9686>, <-33.4829, 148.6903, 12.1586> }
					triangle { <-34.6052, 148.2251, 10.9686>, <-33.7214, 153.7077, 9.5265>, <-33.4829, 148.6903, 12.1586> }
					triangle { <-34.6052, 148.2251, 10.9686>, <-34.1134, 151.7804, 9.4777>, <-33.7214, 153.7077, 9.5265> }
					triangle { <-33.7214, 153.7077, 9.5265>, <-32.9707, 152.3483, 10.3453>, <-33.4829, 148.6903, 12.1586> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04456, 143.6087, 12.3866>, <-34.8366, 148.3453, 12.7187>, <-34.4117, 148.3489, 11.0722> }
					triangle { <-34.8366, 148.3453, 12.7187>, <-37.9242, 152.794, 10.8225>, <-34.4117, 148.3489, 11.0722> }
					triangle { <-34.8366, 148.3453, 12.7187>, <-37.2843, 151.2308, 11.8311>, <-37.9242, 152.794, 10.8225> }
					triangle { <-37.9242, 152.794, 10.8225>, <-37.174, 151.2976, 10.2935>, <-34.4117, 148.3489, 11.0722> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02729, 143.5408, 12.3919>, 0.1 }
				cylinder { <-33.02729, 143.5408, 12.3919>, <-33.03717, 143.5724, 12.3808>, 0.1 }
				cylinder { <-33.03717, 143.5724, 12.3808>, <-33.04657, 143.6037, 12.3682>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.04657, 143.6037, 12.3682>, <-34.9521, 147.5876, 9.8673>, <-33.5916, 148.344, 10.552> }
					triangle { <-34.9521, 147.5876, 9.8673>, <-34.4962, 152.2192, 6.5118>, <-33.5916, 148.344, 10.552> }
					triangle { <-34.9521, 147.5876, 9.8673>, <-34.8639, 150.4135, 7.2006>, <-34.4962, 152.2192, 6.5118> }
					triangle { <-34.4962, 152.2192, 6.5118>, <-33.5592, 151.1591, 7.5511>, <-33.5916, 148.344, 10.552> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04657, 143.6037, 12.3682>, <-34.7967, 148.2827, 11.4735>, <-34.7233, 147.7272, 9.8679> }
					triangle { <-34.7967, 148.2827, 11.4735>, <-38.2729, 152.0375, 8.8779>, <-34.7233, 147.7272, 9.8679> }
					triangle { <-34.7967, 148.2827, 11.4735>, <-37.4155, 150.8542, 10.1951>, <-38.2729, 152.0375, 8.8779> }
					triangle { <-38.2729, 152.0375, 8.8779>, <-37.6281, 150.4111, 8.7324>, <-34.7233, 147.7272, 9.8679> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04657, 143.6037, 12.3682>, <-33.4092, 148.2572, 10.3756>, <-34.8744, 148.235, 11.2386> }
					triangle { <-33.4092, 148.2572, 10.3756>, <-34.576, 153.8679, 10.6555>, <-34.8744, 148.235, 11.2386> }
					triangle { <-33.4092, 148.2572, 10.3756>, <-33.6562, 152.1316, 10.5564>, <-34.576, 153.8679, 10.6555> }
					triangle { <-34.576, 153.8679, 10.6555>, <-34.8813, 152.3432, 11.4703>, <-34.8744, 148.235, 11.2386> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02907, 143.5408, 12.3945>, 0.1 }
				cylinder { <-33.02907, 143.5408, 12.3945>, <-33.04251, 143.5726, 12.3888>, 0.1 }
				cylinder { <-33.04251, 143.5726, 12.3888>, <-33.05725, 143.6039, 12.3841>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.05725, 143.6039, 12.3841>, <-35.1914, 148.1956, 12.729>, <-35.7302, 147.781, 11.1703> }
					triangle { <-35.1914, 148.1956, 12.729>, <-39.543, 151.8786, 12.082>, <-35.7302, 147.781, 11.1703> }
					triangle { <-35.1914, 148.1956, 12.729>, <-38.1957, 150.6589, 12.8352>, <-39.543, 151.8786, 12.082> }
					triangle { <-39.543, 151.8786, 12.082>, <-38.946, 150.3228, 11.5295>, <-35.7302, 147.781, 11.1703> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05725, 143.6039, 12.3841>, <-34.3325, 148.373, 11.2065>, <-35.3711, 148.1525, 12.5348> }
					triangle { <-34.3325, 148.373, 11.2065>, <-35.5528, 153.8205, 12.5314>, <-35.3711, 148.1525, 12.5348> }
					triangle { <-34.3325, 148.373, 11.2065>, <-34.6614, 152.1817, 11.9066>, <-35.5528, 153.8205, 12.5314> }
					triangle { <-35.5528, 153.8205, 12.5314>, <-35.4685, 152.2084, 13.2214>, <-35.3711, 148.1525, 12.5348> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05725, 143.6039, 12.3841>, <-35.9357, 147.6251, 11.2432>, <-34.4452, 148.4229, 11.4263> }
					triangle { <-35.9357, 147.6251, 11.2432>, <-37.00031, 152.5378, 8.4771>, <-34.4452, 148.4229, 11.4263> }
					triangle { <-35.9357, 147.6251, 11.2432>, <-37.0019, 150.6591, 9.06076>, <-37.00031, 152.5378, 8.4771> }
					triangle { <-37.00031, 152.5378, 8.4771>, <-35.6928, 151.4695, 8.9579>, <-34.4452, 148.4229, 11.4263> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02609, 143.5416, 12.3936>, 0.1 }
				cylinder { <-33.02609, 143.5416, 12.3936>, <-33.03358, 143.5749, 12.3862>, 0.1 }
				cylinder { <-33.03358, 143.5749, 12.3862>, <-33.03941, 143.6086, 12.3789>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.03941, 143.6086, 12.3789>, <-33.1455, 148.3723, 10.6316>, <-33.8455, 148.6452, 12.1572> }
					triangle { <-33.1455, 148.3723, 10.6316>, <-32.3938, 154.0358, 11.1606>, <-33.8455, 148.6452, 12.1572> }
					triangle { <-33.1455, 148.3723, 10.6316>, <-32.1897, 152.1392, 10.6795>, <-32.3938, 154.0358, 11.1606> }
					triangle { <-32.3938, 154.0358, 11.1606>, <-32.6078, 152.569, 12.1012>, <-33.8455, 148.6452, 12.1572> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.03941, 143.6086, 12.3789>, <-34.8289, 148.1816, 11.09735>, <-33.1707, 148.4853, 10.8734> }
					triangle { <-34.8289, 148.1816, 11.09735>, <-35.03229, 152.8485, 7.7659>, <-33.1707, 148.4853, 10.8734> }
					triangle { <-34.8289, 148.1816, 11.09735>, <-35.4406, 151.1407, 8.653>, <-35.03229, 152.8485, 7.7659> }
					triangle { <-35.03229, 152.8485, 7.7659>, <-34.0115, 151.4822, 8.182>, <-33.1707, 148.4853, 10.8734> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.03941, 143.6086, 12.3789>, <-33.6191, 148.6499, 12.3007>, <-34.6185, 148.2584, 10.9817> }
					triangle { <-33.6191, 148.6499, 12.3007>, <-36.7559, 153.435, 11.8723>, <-34.6185, 148.2584, 10.9817> }
					triangle { <-33.6191, 148.6499, 12.3007>, <-35.672, 151.9405, 12.5519>, <-36.7559, 153.435, 11.8723> }
					triangle { <-36.7559, 153.435, 11.8723>, <-36.7829, 151.7187, 11.5042>, <-34.6185, 148.2584, 10.9817> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.02872, 143.5404, 12.3923>, 0.1 }
				cylinder { <-33.02872, 143.5404, 12.3923>, <-33.04147, 143.5713, 12.3821>, 0.1 }
				cylinder { <-33.04147, 143.5713, 12.3821>, <-33.05516, 143.6014, 12.3707>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.05516, 143.6014, 12.3707>, <-35.938, 147.5024, 10.8781>, <-34.4998, 147.9275, 10.07639> }
					triangle { <-35.938, 147.5024, 10.8781>, <-37.9414, 151.1797, 6.9558>, <-34.4998, 147.9275, 10.07639> }
					triangle { <-35.938, 147.5024, 10.8781>, <-37.7582, 149.7001, 8.2395>, <-37.9414, 151.1797, 6.9558> }
					triangle { <-37.9414, 151.1797, 6.9558>, <-36.6136, 150.0766, 7.2756>, <-34.4998, 147.9275, 10.07639> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05516, 143.6014, 12.3707>, <-34.5575, 148.375, 11.5261>, <-35.7836, 147.5668, 10.6686> }
					triangle { <-34.5575, 148.375, 11.5261>, <-38.5237, 152.5059, 11.1744>, <-35.7836, 147.5668, 10.6686> }
					triangle { <-34.5575, 148.375, 11.5261>, <-37.04011, 151.3559, 11.763>, <-38.5237, 152.5059, 11.1744> }
					triangle { <-38.5237, 152.5059, 11.1744>, <-38.3303, 150.7611, 11.1609>, <-35.7836, 147.5668, 10.6686> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.05516, 143.6014, 12.3707>, <-34.5256, 147.7633, 9.866>, <-34.7909, 148.3143, 11.4528> }
					triangle { <-34.5256, 147.7633, 9.866>, <-34.6937, 153.4356, 9.01941>, <-34.7909, 148.3143, 11.4528> }
					triangle { <-34.5256, 147.7633, 9.866>, <-34.2971, 151.5141, 8.874>, <-34.6937, 153.4356, 9.01941> }
					triangle { <-34.6937, 153.4356, 9.01941>, <-34.356, 152.2231, 10.2432>, <-34.7909, 148.3143, 11.4528> }
					texture{Wflower_Texture3}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.01695, 143.5087, 12.4013>, <-33.0278, 143.5414, 12.3952>, 0.1 }
				cylinder { <-33.0278, 143.5414, 12.3952>, <-33.03871, 143.5743, 12.3908>, 0.1 }
				cylinder { <-33.03871, 143.5743, 12.3908>, <-33.04966, 143.6074, 12.3881>, 0.1 }
				texture{Wflower_Texture1}}
			union { // flower
				mesh { // flower petal
					triangle { <-33.04966, 143.6074, 12.3881>, <-33.8457, 148.6148, 12.6102>, <-35.4149, 148.1268, 12.173> }
					triangle { <-33.8457, 148.6148, 12.6102>, <-36.8696, 153.255, 14.1082>, <-35.4149, 148.1268, 12.173> }
					triangle { <-33.8457, 148.6148, 12.6102>, <-35.5122, 151.8343, 14.01113>, <-36.8696, 153.255, 14.1082> }
					triangle { <-36.8696, 153.255, 14.1082>, <-37.01562, 151.5239, 13.855>, <-35.4149, 148.1268, 12.173> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04966, 143.6074, 12.3881>, <-34.4633, 148.2798, 10.9998>, <-34.112, 148.5951, 12.6335> }
					triangle { <-34.4633, 148.2798, 10.9998>, <-33.8702, 153.9855, 10.8888>, <-34.112, 148.5951, 12.6335> }
					triangle { <-34.4633, 148.2798, 10.9998>, <-33.8907, 152.078, 10.4078>, <-33.8702, 153.9855, 10.8888> }
					triangle { <-33.8702, 153.9855, 10.8888>, <-33.3872, 152.5559, 11.7859>, <-34.112, 148.5951, 12.6335> }
					texture{Wflower_Texture3}}
				mesh { // flower petal
					triangle { <-33.04966, 143.6074, 12.3881>, <-35.4989, 148.0524, 12.4164>, <-34.3621, 148.396, 11.1993> }
					triangle { <-35.4989, 148.0524, 12.4164>, <-37.994, 152.5376, 9.8519>, <-34.3621, 148.396, 11.1993> }
					triangle { <-35.4989, 148.0524, 12.4164>, <-37.6644, 150.8645, 10.8331>, <-37.994, 152.5376, 9.8519> }
					triangle { <-37.994, 152.5376, 9.8519>, <-36.8623, 151.2264, 9.5656>, <-34.3621, 148.396, 11.1993> }
					texture{Wflower_Texture3}}
				}
			}
		}
} // end clover

#declare Solomon_s_seal = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.1926, 5.8556, -0.696>, 0.7999 }
		cylinder { <0.1926, 5.8556, -0.696>, <0.5749, 11.5788, -2.07771>, 0.7999 }
		cylinder { <0.5749, 11.5788, -2.07771>, <1.1413, 17.08347, -4.1241>, 0.7999 }
		texture{Wflower_Texture4}}
	union { // internode
		cylinder { <1.1413, 17.08347, -4.1241>, <1.6013, 22.6849, -5.9192>, 0.8 }
		cylinder { <1.6013, 22.6849, -5.9192>, <1.9538, 28.3696, -7.4586>, 0.8 }
		cylinder { <1.9538, 28.3696, -7.4586>, <2.1981, 34.1239, -8.7386>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <2.1981, 34.1239, -8.7386>, <2.08443, 35.2894, -8.5947>, 0.9998 }
			cylinder { <2.08443, 35.2894, -8.5947>, <1.8234, 36.3135, -8.07017>, 0.9998 }
			cylinder { <1.8234, 36.3135, -8.07017>, <1.4501, 37.05903, -7.2353>, 0.9998 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <1.4501, 37.05903, -7.2353>, <-10.6492, 51.6903, 4.05351>, <-13.9711, 54.1899, 9.2653> }
			triangle { <1.4501, 37.05903, -7.2353>, <-7.8161, 48.155, -0.452>, <-10.6492, 51.6903, 4.05351> }
			triangle { <1.4501, 37.05903, -7.2353>, <-4.7673, 44.8146, -5.03514>, <-7.8161, 48.155, -0.452> }
			triangle { <1.4501, 37.05903, -7.2353>, <-2.2176, 41.1949, -7.04089>, <-4.7673, 44.8146, -5.03514> }
			triangle { <1.4501, 37.05903, -7.2353>, <-13.9711, 54.1899, 9.2653>, <-12.05288, 50.2598, 14.05764> }
			triangle { <-13.9711, 54.1899, 9.2653>, <-21.7842, 51.7605, 16.4447>, <-12.05288, 50.2598, 14.05764> }
			triangle { <-12.05288, 50.2598, 14.05764>, <-21.7842, 51.7605, 16.4447>, <-22.07124, 51.9283, 19.5682> }
			triangle { <-12.05288, 50.2598, 14.05764>, <-22.07124, 51.9283, 19.5682>, <-29.6028, 42.3861, 25.9963> }
			triangle { <-6.7092, 48.873, 17.2602>, <-3.01344, 46.1173, 12.4443>, <1.4501, 37.05903, -7.2353> }
			triangle { <-3.01344, 46.1173, 12.4443>, <0.09279, 43.4228, 7.3101>, <1.4501, 37.05903, -7.2353> }
			triangle { <0.09279, 43.4228, 7.3101>, <2.3363, 39.9487, 2.4863>, <1.4501, 37.05903, -7.2353> }
			triangle { <2.3363, 39.9487, 2.4863>, <2.6427, 37.8656, -1.8946>, <1.4501, 37.05903, -7.2353> }
			triangle { <-12.05288, 50.2598, 14.05764>, <-6.7092, 48.873, 17.2602>, <1.4501, 37.05903, -7.2353> }
			triangle { <-12.05288, 50.2598, 14.05764>, <-15.4283, 47.4068, 23.1745>, <-6.7092, 48.873, 17.2602> }
			triangle { <-19.3443, 47.8797, 23.9775>, <-15.4283, 47.4068, 23.1745>, <-12.05288, 50.2598, 14.05764> }
			triangle { <-29.6028, 42.3861, 25.9963>, <-19.3443, 47.8797, 23.9775>, <-12.05288, 50.2598, 14.05764> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <2.1981, 34.1239, -8.7386>, <1.8627, 35.03927, -8.0174>, 0.08564 }
			cylinder { <1.8627, 35.03927, -8.0174>, <1.4128, 34.947, -6.895>, 0.08564 }
			cylinder { <1.4128, 34.947, -6.895>, <1.2123, 33.9219, -6.279>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <1.2123, 33.9219, -6.279>, <1.1455, 33.5801, -6.07376>, 0.08564 }
			cylinder { <1.1455, 33.5801, -6.07376>, <1.07868, 33.2384, -5.8684>, 0.08564 }
			cylinder { <1.07868, 33.2384, -5.8684>, <1.01185, 32.8967, -5.6631>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <1.01185, 32.8967, -5.6631>, <0.9158, 32.2604, -5.1738>, 0.08564 }
				cylinder { <0.9158, 32.2604, -5.1738>, <0.8589, 31.6807, -4.6131>, 0.08564 }
				cylinder { <0.8589, 31.6807, -4.6131>, <0.842, 31.1664, -3.9895>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <0.842, 31.1664, -3.9895>, <0.9408, 31.3185, -2.001666>, <2.103, 30.5383, -2.6136> }
					triangle { <0.9408, 31.3185, -2.001666>, <0.9672, 30.2815, -0.6365>, <2.103, 30.5383, -2.6136> }
					triangle { <2.103, 30.5383, -2.6136>, <0.9672, 30.2815, -0.6365>, <2.2386, 29.327, -1.3892> }
					triangle { <2.2386, 29.327, -1.3892>, <0.9672, 30.2815, -0.6365>, <0.7771, 28.4171, -0.4994> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <0.842, 31.1664, -3.9895>, <-0.4596, 30.6996, -2.55>, <0.8459, 31.2939, -2.02454> }
					triangle { <-0.4596, 30.6996, -2.55>, <-0.541, 29.6733, -1.1789>, <0.8459, 31.2939, -2.02454> }
					triangle { <0.8459, 31.2939, -2.02454>, <-0.541, 29.6733, -1.1789>, <1.01148, 30.2901, -0.6282> }
					triangle { <1.01148, 30.2901, -0.6282>, <-0.541, 29.6733, -1.1789>, <0.6634, 28.3863, -0.5279> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <0.842, 31.1664, -3.9895>, <-0.1144, 29.4689, -3.5556>, <-0.4575, 30.622, -2.614> }
					triangle { <-0.1144, 29.4689, -3.5556>, <-0.241, 28.3671, -2.2481>, <-0.4575, 30.622, -2.614> }
					triangle { <-0.4575, 30.622, -2.614>, <-0.241, 28.3671, -2.2481>, <-0.5384, 29.7085, -1.1498> }
					triangle { <-0.5384, 29.7085, -1.1498>, <-0.241, 28.3671, -2.2481>, <0.6675, 28.2927, -0.605> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <0.842, 31.1664, -3.9895>, <1.5025, 29.3157, -3.6382>, <-0.01828, 29.4448, -3.5729> }
					triangle { <1.5025, 29.3157, -3.6382>, <1.4554, 28.1559, -2.3763>, <-0.01828, 29.4448, -3.5729> }
					triangle { <-0.01828, 29.4448, -3.5729>, <1.4554, 28.1559, -2.3763>, <-0.2836, 28.3806, -2.2381> }
					triangle { <-0.2836, 28.3806, -2.2381>, <1.4554, 28.1559, -2.3763>, <0.7838, 28.2649, -0.6248> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <0.842, 31.1664, -3.9895>, <2.1646, 30.4761, -2.6633>, <1.5881, 29.3923, -3.5727> }
					triangle { <2.1646, 30.4761, -2.6633>, <2.2134, 29.3569, -1.3652>, <1.5881, 29.3923, -3.5727> }
					triangle { <1.5881, 29.3923, -3.5727>, <2.2134, 29.3569, -1.3652>, <1.4586, 28.1413, -2.3882> }
					triangle { <1.4586, 28.1413, -2.3882>, <2.2134, 29.3569, -1.3652>, <0.8526, 28.3429, -0.5586> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <1.01185, 32.8967, -5.6631>, <0.945, 32.555, -5.4578>, 0.08564 }
			cylinder { <0.945, 32.555, -5.4578>, <0.8781, 32.2132, -5.2524>, 0.08564 }
			cylinder { <0.8781, 32.2132, -5.2524>, <0.8113, 31.8715, -5.04717>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <0.8113, 31.8715, -5.04717>, <0.5907, 31.1837, -4.684>, 0.08564 }
				cylinder { <0.5907, 31.1837, -4.684>, <0.2865, 30.5019, -4.3739>, 0.08564 }
				cylinder { <0.2865, 30.5019, -4.3739>, <-0.09659, 29.8363, -4.1214>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <-0.09659, 29.8363, -4.1214>, <-1.2887, 28.9389, -4.6522>, <-1.5209, 29.4753, -3.5904> }
					triangle { <-1.2887, 28.9389, -4.6522>, <-1.9961, 27.8476, -4.253>, <-1.5209, 29.4753, -3.5904> }
					triangle { <-1.5209, 29.4753, -3.5904>, <-1.9961, 27.8476, -4.253>, <-2.1951, 28.4362, -3.00342> }
					triangle { <-2.1951, 28.4362, -3.00342>, <-1.9961, 27.8476, -4.253>, <-1.8245, 26.9459, -3.07833> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <-0.09659, 29.8363, -4.1214>, <-0.1597, 28.3193, -4.5721>, <-1.2216, 28.8966, -4.6619> }
					triangle { <-0.1597, 28.3193, -4.5721>, <-0.8119, 27.1794, -4.2175>, <-1.2216, 28.8966, -4.6619> }
					triangle { <-1.2216, 28.8966, -4.6619>, <-0.8119, 27.1794, -4.2175>, <-2.02579, 27.8674, -4.246> }
					triangle { <-2.02579, 27.8674, -4.246>, <-0.8119, 27.1794, -4.2175>, <-1.7434, 26.8952, -3.08876> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <-0.09659, 29.8363, -4.1214>, <0.3155, 28.4958, -3.3854>, <-0.1185, 28.3216, -4.5036> }
					triangle { <0.3155, 28.4958, -3.3854>, <-0.27, 27.3369, -2.9799>, <-0.1185, 28.3216, -4.5036> }
					triangle { <-0.1185, 28.3216, -4.5036>, <-0.27, 27.3369, -2.9799>, <-0.8325, 27.1799, -4.2474> }
					triangle { <-0.8325, 27.1799, -4.2474>, <-0.27, 27.3369, -2.9799>, <-1.6948, 26.8987, -3.005849> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <-0.09659, 29.8363, -4.1214>, <-0.5153, 29.2262, -2.7211>, <0.2742, 28.5395, -3.3328> }
					triangle { <-0.5153, 29.2262, -2.7211>, <-1.1142, 28.104, -2.239>, <0.2742, 28.5395, -3.3328> }
					triangle { <0.2742, 28.5395, -3.3328>, <-1.1142, 28.104, -2.239>, <-0.2533, 27.3175, -3.005731> }
					triangle { <-0.2533, 27.3175, -3.005731>, <-1.1142, 28.104, -2.239>, <-1.7454, 26.9515, -2.9433> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <-0.09659, 29.8363, -4.1214>, <-1.5218, 29.5041, -3.5159>, <-0.6055, 29.2634, -2.7599> }
					triangle { <-1.5218, 29.5041, -3.5159>, <-2.1971, 28.4244, -3.03771>, <-0.6055, 29.2634, -2.7599> }
					triangle { <-0.6055, 29.2634, -2.7599>, <-2.1971, 28.4244, -3.03771>, <-1.1081, 28.1056, -2.2252> }
					triangle { <-1.1081, 28.1056, -2.2252>, <-2.1971, 28.4244, -3.03771>, <-1.8267, 26.9811, -2.9888> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <2.1981, 34.1239, -8.7386>, <2.5826, 39.8106, -10.2628>, 0.8 }
		cylinder { <2.5826, 39.8106, -10.2628>, <3.1066, 45.4161, -12.02744>, 0.8 }
		cylinder { <3.1066, 45.4161, -12.02744>, <3.7686, 50.9268, -14.02832>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.7686, 50.9268, -14.02832>, <4.09356, 51.8063, -14.7446>, 0.9998 }
			cylinder { <4.09356, 51.8063, -14.7446>, <4.5674, 52.3453, -15.681>, 0.9998 }
			cylinder { <4.5674, 52.3453, -15.681>, <5.1268, 52.4717, -16.7122>, 0.9998 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <5.1268, 52.4717, -16.7122>, <20.4042, 57.2268, -31.9404>, <24.4955, 56.1192, -37.08625> }
			triangle { <5.1268, 52.4717, -16.7122>, <16.6666, 57.03672, -26.7617>, <20.4042, 57.2268, -31.9404> }
			triangle { <5.1268, 52.4717, -16.7122>, <12.7451, 57.07365, -21.6549>, <16.6666, 57.03672, -26.7617> }
			triangle { <5.1268, 52.4717, -16.7122>, <9.461, 55.4219, -18.4749>, <12.7451, 57.07365, -21.6549> }
			triangle { <5.1268, 52.4717, -16.7122>, <24.4955, 56.1192, -37.08625>, <22.2935, 50.4404, -39.321> }
			triangle { <24.4955, 56.1192, -37.08625>, <32.2904, 49.367, -40.5705>, <22.2935, 50.4404, -39.321> }
			triangle { <22.2935, 50.4404, -39.321>, <32.2904, 49.367, -40.5705>, <32.8384, 47.7752, -43.2224> }
			triangle { <22.2935, 50.4404, -39.321>, <32.8384, 47.7752, -43.2224>, <39.06492, 35.5435, -42.3764> }
			triangle { <17.04909, 48.1034, -42.1082>, <12.5762, 48.8215, -37.217>, <5.1268, 52.4717, -16.7122> }
			triangle { <12.5762, 48.8215, -37.217>, <8.6686, 49.7021, -31.9993>, <5.1268, 52.4717, -16.7122> }
			triangle { <8.6686, 49.7021, -31.9993>, <5.4963, 49.6743, -26.494>, <5.1268, 52.4717, -16.7122> }
			triangle { <5.4963, 49.6743, -26.494>, <4.5013, 50.3593, -21.7859>, <5.1268, 52.4717, -16.7122> }
			triangle { <22.2935, 50.4404, -39.321>, <17.04909, 48.1034, -42.1082>, <5.1268, 52.4717, -16.7122> }
			triangle { <22.2935, 50.4404, -39.321>, <25.8046, 42.7465, -44.9002>, <17.04909, 48.1034, -42.1082> }
			triangle { <29.7927, 42.2914, -45.2024>, <25.8046, 42.7465, -44.9002>, <22.2935, 50.4404, -39.321> }
			triangle { <39.06492, 35.5435, -42.3764>, <29.7927, 42.2914, -45.2024>, <22.2935, 50.4404, -39.321> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <3.7686, 50.9268, -14.02832>, <4.3116, 51.2604, -15.06003>, 0.08564 }
			cylinder { <4.3116, 51.2604, -15.06003>, <4.8225, 50.5252, -15.8779>, 0.08564 }
			cylinder { <4.8225, 50.5252, -15.8779>, <4.8882, 49.3156, -15.8207>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <4.8882, 49.3156, -15.8207>, <4.91, 48.9125, -15.8016>, 0.08564 }
			cylinder { <4.91, 48.9125, -15.8016>, <4.9319, 48.5093, -15.7825>, 0.08564 }
			cylinder { <4.9319, 48.5093, -15.7825>, <4.9538, 48.1061, -15.7634>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.9538, 48.1061, -15.7634>, <4.9747, 47.3, -15.8217>, 0.08564 }
				cylinder { <4.9747, 47.3, -15.8217>, <4.9725, 46.5064, -15.9757>, 0.08564 }
				cylinder { <4.9725, 46.5064, -15.9757>, <4.9471, 45.7371, -16.2229>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <4.9471, 45.7371, -16.2229>, <5.0275, 44.7913, -17.979>, <3.7044, 44.5975, -17.2401> }
					triangle { <5.0275, 44.7913, -17.979>, <4.9252, 43.1876, -18.577>, <3.7044, 44.5975, -17.2401> }
					triangle { <3.7044, 44.5975, -17.2401>, <4.9252, 43.1876, -18.577>, <3.454, 42.937, -17.646> }
					triangle { <3.454, 42.937, -17.646>, <4.9252, 43.1876, -18.577>, <4.7985, 41.5418, -17.6793> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.9471, 45.7371, -16.2229>, <6.2535, 44.4279, -16.974>, <5.1146, 44.7733, -17.9319> }
					triangle { <6.2535, 44.4279, -16.974>, <6.2593, 42.8186, -17.5656>, <5.1146, 44.7733, -17.9319> }
					triangle { <5.1146, 44.7733, -17.9319>, <6.2593, 42.8186, -17.5656>, <4.8839, 43.1949, -18.5954> }
					triangle { <4.8839, 43.1949, -18.5954>, <6.2593, 42.8186, -17.5656>, <4.9027, 41.5197, -17.6213> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.9471, 45.7371, -16.2229>, <5.6246, 43.9879, -15.5402>, <6.2331, 44.3984, -16.88> }
					triangle { <5.6246, 43.9879, -15.5402>, <5.6568, 42.3456, -16.03192>, <6.2331, 44.3984, -16.88> }
					triangle { <6.2331, 44.3984, -16.88>, <5.6568, 42.3456, -16.03192>, <6.2651, 42.8324, -17.6089> }
					triangle { <6.2651, 42.8324, -17.6089>, <5.6568, 42.3456, -16.03192>, <4.8766, 41.4843, -17.5084> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.9471, 45.7371, -16.2229>, <4.004054, 44.07523, -15.6455>, <5.5247, 43.9873, -15.5282> }
					triangle { <4.004054, 44.07523, -15.6455>, <3.9447, 42.4179, -16.0811>, <5.5247, 43.9873, -15.5282> }
					triangle { <5.5247, 43.9873, -15.5282>, <3.9447, 42.4179, -16.0811>, <5.7018, 42.347, -16.04066> }
					triangle { <5.7018, 42.347, -16.04066>, <3.9447, 42.4179, -16.0811>, <4.756, 41.4841, -17.4955> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.9471, 45.7371, -16.2229>, <3.6294, 44.5792, -17.1755>, <3.9382, 44.1122, -15.7541> }
					triangle { <3.6294, 44.5792, -17.1755>, <3.4857, 42.9461, -17.6778>, <3.9382, 44.1122, -15.7541> }
					triangle { <3.9382, 44.1122, -15.7541>, <3.4857, 42.9461, -17.6778>, <3.9382, 42.4126, -16.06394> }
					triangle { <3.9382, 42.4126, -16.06394>, <3.4857, 42.9461, -17.6778>, <4.7071, 41.5202, -17.6027> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <4.9538, 48.1061, -15.7634>, <4.9757, 47.7029, -15.7443>, 0.08564 }
			cylinder { <4.9757, 47.7029, -15.7443>, <4.9976, 47.2997, -15.7253>, 0.08564 }
			cylinder { <4.9976, 47.2997, -15.7253>, <5.01951, 46.8966, -15.7062>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <5.01951, 46.8966, -15.7062>, <5.1442, 46.1033, -15.6123>, 0.08564 }
				cylinder { <5.1442, 46.1033, -15.6123>, <5.348, 45.3352, -15.4642>, 0.08564 }
				cylinder { <5.348, 45.3352, -15.4642>, <5.6279, 44.6036, -15.264>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <5.6279, 44.6036, -15.264>, <6.6024, 44.02087, -14.1599>, <7.004082, 43.8645, -15.2927> }
					triangle { <6.6024, 44.02087, -14.1599>, <7.1377, 42.8211, -13.8068>, <7.004082, 43.8645, -15.2927> }
					triangle { <7.004082, 43.8645, -15.2927>, <7.1377, 42.8211, -13.8068>, <7.5302, 42.6093, -15.1292> }
					triangle { <7.5302, 42.6093, -15.1292>, <7.1377, 42.8211, -13.8068>, <6.9019, 41.449, -14.34> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.6279, 44.6036, -15.264>, <5.3923, 43.5802, -14.07851>, <6.5284, 43.9979, -14.1401> }
					triangle { <5.3923, 43.5802, -14.07851>, <5.8617, 42.3701, -13.6712>, <6.5284, 43.9979, -14.1401> }
					triangle { <6.5284, 43.9979, -14.1401>, <5.8617, 42.3701, -13.6712>, <7.1708, 42.8306, -13.8184> }
					triangle { <7.1708, 42.8306, -13.8184>, <5.8617, 42.3701, -13.6712>, <6.8127, 41.421, -14.3174> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.6279, 44.6036, -15.264>, <5.04642, 43.1307, -15.2375>, <5.3575, 43.5491, -14.1433> }
					triangle { <5.04642, 43.1307, -15.2375>, <5.4509, 41.884, -14.8733>, <5.3575, 43.5491, -14.1433> }
					triangle { <5.3575, 43.5491, -14.1433>, <5.4509, 41.884, -14.8733>, <5.8798, 42.3847, -13.6432> }
					triangle { <5.8798, 42.3847, -13.6432>, <5.4509, 41.884, -14.8733>, <6.7718, 41.3839, -14.3961> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.6279, 44.6036, -15.264>, <6.03949, 43.2893, -16.04608>, <5.09852, 43.1341, -15.298> }
					triangle { <6.03949, 43.2893, -16.04608>, <6.4693, 42.03008, -15.7631>, <5.09852, 43.1341, -15.298> }
					triangle { <5.09852, 43.1341, -15.298>, <6.4693, 42.03008, -15.7631>, <5.4292, 41.8836, -14.8442> }
					triangle { <5.4292, 41.8836, -14.8442>, <6.4693, 42.03008, -15.7631>, <6.8354, 41.3885, -14.4681> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.6279, 44.6036, -15.264>, <7.01566, 43.8478, -15.37>, <6.1315, 43.3319, -16.01909> }
					triangle { <7.01566, 43.8478, -15.37>, <7.5275, 42.618, -15.09406>, <6.1315, 43.3319, -16.01909> }
					triangle { <6.1315, 43.3319, -16.01909>, <7.5275, 42.618, -15.09406>, <6.4646, 42.02463, -15.7764> }
					triangle { <6.4646, 42.02463, -15.7764>, <7.5275, 42.618, -15.09406>, <6.917, 41.4293, -14.4329> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <3.7686, 50.9268, -14.02832>, <4.2626, 56.5291, -15.8118>, 0.8 }
		cylinder { <4.2626, 56.5291, -15.8118>, <4.5874, 62.2093, -17.3736>, 0.8 }
		cylinder { <4.5874, 62.2093, -17.3736>, <4.7422, 67.9539, -18.7099>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.7422, 67.9539, -18.7099>, <4.5215, 69.1099, -18.6262>, 0.9998 }
			cylinder { <4.5215, 69.1099, -18.6262>, <4.07874, 70.1182, -18.2028>, 0.9998 }
			cylinder { <4.07874, 70.1182, -18.2028>, <3.4731, 70.8437, -17.4964>, 0.9998 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <3.4731, 70.8437, -17.4964>, <-11.8579, 84.6987, -9.6922>, <-16.4581, 87.00945, -5.4561> }
			triangle { <3.4731, 70.8437, -17.4964>, <-7.8279, 81.3274, -13.3278>, <-11.8579, 84.6987, -9.6922> }
			triangle { <3.4731, 70.8437, -17.4964>, <-3.5834, 78.1649, -16.9941>, <-7.8279, 81.3274, -13.3278> }
			triangle { <3.4731, 70.8437, -17.4964>, <-0.404, 74.7137, -18.262>, <-3.5834, 78.1649, -16.9941> }
			triangle { <3.4731, 70.8437, -17.4964>, <-16.4581, 87.00945, -5.4561>, <-15.4516, 83.2702, -0.2506> }
			triangle { <-16.4581, 87.00945, -5.4561>, <-25.5485, 84.1074, -0.2183>, <-15.4516, 83.2702, -0.2506> }
			triangle { <-15.4516, 83.2702, -0.2506>, <-25.5485, 84.1074, -0.2183>, <-26.5643, 84.2849, 2.7487> }
			triangle { <-15.4516, 83.2702, -0.2506>, <-26.5643, 84.2849, 2.7487>, <-34.7374, 74.3005, 7.5038> }
			triangle { <-10.9195, 82.293, 4.1356>, <-6.03164, 79.7568, 0.3776>, <3.4731, 70.8437, -17.4964> }
			triangle { <-6.03164, 79.7568, 0.3776>, <-1.6459, 77.2373, -3.8278>, <3.4731, 70.8437, -17.4964> }
			triangle { <-1.6459, 77.2373, -3.8278>, <1.882, 73.8826, -7.9109>, <3.4731, 70.8437, -17.4964> }
			triangle { <1.882, 73.8826, -7.9109>, <3.3354, 71.7837, -12.04724>, <3.4731, 70.8437, -17.4964> }
			triangle { <-15.4516, 83.2702, -0.2506>, <-10.9195, 82.293, 4.1356>, <3.4731, 70.8437, -17.4964> }
			triangle { <-15.4516, 83.2702, -0.2506>, <-20.6584, 80.2759, 7.9086>, <-10.9195, 82.293, 4.1356> }
			triangle { <-24.6762, 80.4806, 7.7718>, <-20.6584, 80.2759, 7.9086>, <-15.4516, 83.2702, -0.2506> }
			triangle { <-34.7374, 74.3005, 7.5038>, <-24.6762, 80.4806, 7.7718>, <-15.4516, 83.2702, -0.2506> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <4.7422, 67.9539, -18.7099>, <4.1886, 68.8504, -18.1096>, 0.08564 }
			cylinder { <4.1886, 68.8504, -18.1096>, <3.4973, 68.7378, -17.1197>, 0.08564 }
			cylinder { <3.4973, 68.7378, -17.1197>, <3.2271, 67.7071, -16.5407>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <3.2271, 67.7071, -16.5407>, <3.1371, 67.3635, -16.3477>, 0.08564 }
			cylinder { <3.1371, 67.3635, -16.3477>, <3.04712, 67.02, -16.1547>, 0.08564 }
			cylinder { <3.04712, 67.02, -16.1547>, <2.957, 66.6764, -15.9616>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.957, 66.6764, -15.9616>, <2.7921, 66.03969, -15.4916>, 0.08564 }
				cylinder { <2.7921, 66.03969, -15.4916>, <2.6448, 65.4629, -14.9446>, 0.08564 }
				cylinder { <2.6448, 65.4629, -14.9446>, <2.5174, 64.9547, -14.3288>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <2.5174, 64.9547, -14.3288>, <2.141, 65.1327, -12.3765>, <3.4625, 64.43, -12.6829> }
					triangle { <2.141, 65.1327, -12.3765>, <1.9176, 64.1133, -11.01611>, <3.4625, 64.43, -12.6829> }
					triangle { <3.4625, 64.43, -12.6829>, <1.9176, 64.1133, -11.01611>, <3.3894, 63.2432, -11.4295> }
					triangle { <3.3894, 63.2432, -11.4295>, <1.9176, 64.1133, -11.01611>, <1.8244, 62.2416, -10.8788> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.5174, 64.9547, -14.3288>, <0.9504, 64.4118, -13.2178>, <2.05592, 65.1012, -12.4201> }
					triangle { <0.9504, 64.4118, -13.2178>, <0.6204, 63.3955, -11.8768>, <2.05592, 65.1012, -12.4201> }
					triangle { <2.05592, 65.1012, -12.4201>, <0.6204, 63.3955, -11.8768>, <1.9581, 64.1251, -10.998> }
					triangle { <1.9581, 64.1251, -10.998>, <0.6204, 63.3955, -11.8768>, <1.7227, 62.2026, -10.9321> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.5174, 64.9547, -14.3288>, <1.6003, 63.1986, -14.08446>, <0.9724, 64.3338, -13.2776> }
					triangle { <1.6003, 63.1986, -14.08446>, <1.2463, 62.1034, -12.8136>, <0.9724, 64.3338, -13.2776> }
					triangle { <0.9724, 64.3338, -13.2776>, <1.2463, 62.1034, -12.8136>, <0.6138, 63.4312, -11.8488> }
					triangle { <0.6138, 63.4312, -11.8488>, <1.2463, 62.1034, -12.8136>, <1.7508, 62.1089, -11.00365> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.5174, 64.9547, -14.3288>, <3.1988, 63.1584, -13.7868>, <1.6993, 63.1811, -14.0784> }
					triangle { <3.1988, 63.1584, -13.7868>, <2.9362, 62.0105, -12.5406>, <1.6993, 63.1811, -14.0784> }
					triangle { <1.6993, 63.1811, -14.0784>, <2.9362, 62.0105, -12.5406>, <1.2017, 62.1139, -12.8141> }
					triangle { <1.2017, 62.1139, -12.8141>, <2.9362, 62.0105, -12.5406>, <1.8701, 62.0891, -10.9953> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.5174, 64.9547, -14.3288>, <3.538, 64.3718, -12.7153>, <3.2615, 63.2415, -13.7052> }
					triangle { <3.538, 64.3718, -12.7153>, <3.3574, 63.2714, -11.4128>, <3.2615, 63.2415, -13.7052> }
					triangle { <3.2615, 63.2415, -13.7052>, <3.3574, 63.2714, -11.4128>, <2.943, 61.996, -12.5511> }
					triangle { <2.943, 61.996, -12.5511>, <3.3574, 63.2714, -11.4128>, <1.9162, 62.1723, -10.917> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <2.957, 66.6764, -15.9616>, <2.867, 66.3328, -15.7686>, 0.08564 }
			cylinder { <2.867, 66.3328, -15.7686>, <2.777, 65.9893, -15.5756>, 0.08564 }
			cylinder { <2.777, 65.9893, -15.5756>, <2.6869, 65.6457, -15.3826>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <2.6869, 65.6457, -15.3826>, <2.4339, 64.9476, -15.06284>, 0.08564 }
				cylinder { <2.4339, 64.9476, -15.06284>, <2.1116, 64.2492, -14.814>, 0.08564 }
				cylinder { <2.1116, 64.2492, -14.814>, <1.725, 63.5608, -14.6399>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <1.725, 63.5608, -14.6399>, <0.7508, 62.5769, -15.4088>, <0.2433, 63.106, -14.4436> }
					triangle { <0.7508, 62.5769, -15.4088>, <0.04371, 61.4426, -15.1561>, <0.2433, 63.106, -14.4436> }
					triangle { <0.2433, 63.106, -14.4436>, <0.04371, 61.4426, -15.1561>, <-0.4787, 62.0279, -14.002> }
					triangle { <-0.4787, 62.0279, -14.002>, <0.04371, 61.4426, -15.1561>, <-0.003407, 60.5665, -13.9508> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <1.725, 63.5608, -14.6399>, <1.8687, 62.03889, -15.05386>, <0.821, 62.5393, -15.4016> }
					triangle { <1.8687, 62.03889, -15.05386>, <1.2286, 60.8594, -14.8305>, <0.821, 62.5393, -15.4016> }
					triangle { <0.821, 62.5393, -15.4016>, <1.2286, 60.8594, -14.8305>, <0.01197, 61.4603, -15.1567> }
					triangle { <0.01197, 61.4603, -15.1567>, <1.2286, 60.8594, -14.8305>, <0.08105, 60.5216, -13.9409> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <1.725, 63.5608, -14.6399>, <2.04231, 62.2598, -13.7944>, <1.8925, 62.04472, -14.9778> }
					triangle { <2.04231, 62.2598, -13.7944>, <1.4562, 61.06661, -13.5056>, <1.8925, 62.04472, -14.9778> }
					triangle { <1.8925, 62.04472, -14.9778>, <1.4562, 61.06661, -13.5056>, <1.2154, 60.8583, -14.8644> }
					triangle { <1.2154, 60.8583, -14.8644>, <1.4562, 61.06661, -13.5056>, <0.1087, 60.5293, -13.8491> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <1.725, 63.5608, -14.6399>, <1.03339, 62.9364, -13.3593>, <1.9871, 62.301, -13.7539> }
					triangle { <1.03339, 62.9364, -13.3593>, <0.4141, 61.7797, -13.00007>, <1.9871, 62.301, -13.7539> }
					triangle { <1.9871, 62.301, -13.7539>, <0.4141, 61.7797, -13.00007>, <1.4797, 61.04818, -13.5263> }
					triangle { <1.4797, 61.04818, -13.5263>, <0.4141, 61.7797, -13.00007>, <0.04161, 60.579, -13.8014> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <1.725, 63.5608, -14.6399>, <0.2231, 63.1354, -14.3721>, <0.9524, 62.9668, -13.4188> }
					triangle { <0.2231, 63.1354, -14.3721>, <-0.4719, 62.01561, -14.03552>, <0.9524, 62.9668, -13.4188> }
					triangle { <0.9524, 62.9668, -13.4188>, <-0.4719, 62.01561, -14.03552>, <0.4168, 61.7819, -12.9853> }
					triangle { <0.4168, 61.7819, -12.9853>, <-0.4719, 62.01561, -14.03552>, <-0.02873, 60.6024, -13.8652> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <4.7422, 67.9539, -18.7099>, <5.1928, 73.6035, -20.3498>, 0.8 }
		cylinder { <5.1928, 73.6035, -20.3498>, <5.9367, 79.1274, -22.2844>, 0.8 }
		cylinder { <5.9367, 79.1274, -22.2844>, <6.9699, 84.4958, -24.5032>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.9699, 84.4958, -24.5032>, <7.4428, 85.3308, -25.1891>, 0.9996 }
			cylinder { <7.4428, 85.3308, -25.1891>, <8.1187, 85.8156, -26.02549>, 0.9996 }
			cylinder { <8.1187, 85.8156, -26.02549>, <8.907, 85.8853, -26.9001>, 0.9996 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <8.907, 85.8853, -26.9001>, <27.3101, 90.03761, -38.3778>, <32.5338, 88.6985, -42.2948> }
			triangle { <8.907, 85.8853, -26.9001>, <22.443, 90.09831, -34.2412>, <27.3101, 90.03761, -38.3778> }
			triangle { <8.907, 85.8853, -26.9001>, <17.4111, 90.3735, -30.2362>, <22.443, 90.09831, -34.2412> }
			triangle { <8.907, 85.8853, -26.9001>, <13.4877, 88.8468, -27.8092>, <17.4111, 90.3735, -30.2362> }
			triangle { <8.907, 85.8853, -26.9001>, <32.5338, 88.6985, -42.2948>, <31.02642, 82.7987, -44.5287> }
			triangle { <32.5338, 88.6985, -42.2948>, <41.0443, 81.9867, -43.2717>, <31.02642, 82.7987, -44.5287> }
			triangle { <31.02642, 82.7987, -44.5287>, <41.0443, 81.9867, -43.2717>, <42.2388, 80.2248, -45.5805> }
			triangle { <31.02642, 82.7987, -44.5287>, <42.2388, 80.2248, -45.5805>, <48.277, 68.3168, -42.3035> }
			triangle { <26.6448, 80.08184, -48.2882>, <21.1185, 81.00079, -44.6774>, <8.907, 85.8853, -26.9001> }
			triangle { <21.1185, 81.00079, -44.6774>, <16.05967, 82.1252, -40.629>, <8.907, 85.8853, -26.9001> }
			triangle { <16.05967, 82.1252, -40.629>, <11.66, 82.3915, -36.05479>, <8.907, 85.8853, -26.9001> }
			triangle { <11.66, 82.3915, -36.05479>, <9.5528, 83.3854, -31.7903>, <8.907, 85.8853, -26.9001> }
			triangle { <31.02642, 82.7987, -44.5287>, <26.6448, 80.08184, -48.2882>, <8.907, 85.8853, -26.9001> }
			triangle { <31.02642, 82.7987, -44.5287>, <35.8986, 74.8449, -48.4778>, <26.6448, 80.08184, -48.2882> }
			triangle { <39.8483, 74.5085, -47.7843>, <35.8986, 74.8449, -48.4778>, <31.02642, 82.7987, -44.5287> }
			triangle { <48.277, 68.3168, -42.3035>, <39.8483, 74.5085, -47.7843>, <31.02642, 82.7987, -44.5287> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <6.9699, 84.4958, -24.5032>, <7.7393, 84.7714, -25.3991>, 0.08564 }
			cylinder { <7.7393, 84.7714, -25.3991>, <8.4436, 83.9963, -26.01045>, 0.08564 }
			cylinder { <8.4436, 83.9963, -26.01045>, <8.5133, 82.7973, -25.8429>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <8.5133, 82.7973, -25.8429>, <8.5365, 82.3976, -25.787>, 0.08564 }
			cylinder { <8.5365, 82.3976, -25.787>, <8.5598, 81.998, -25.7312>, 0.08564 }
			cylinder { <8.5598, 81.998, -25.7312>, <8.583, 81.5983, -25.6753>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.583, 81.5983, -25.6753>, <8.6305, 80.7913, -25.6625>, 0.08564 }
				cylinder { <8.6305, 80.7913, -25.6625>, <8.6782, 79.9889, -25.7487>, 0.08564 }
				cylinder { <8.6782, 79.9889, -25.7487>, <8.7256, 79.2031, -25.9326>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <8.7256, 79.2031, -25.9326>, <9.2407, 78.1341, -27.5378>, <7.7823, 77.949, -27.1222> }
					triangle { <9.2407, 78.1341, -27.5378>, <9.3112, 76.4882, -28.0131>, <7.7823, 77.949, -27.1222> }
					triangle { <7.7823, 77.949, -27.1222>, <9.3112, 76.4882, -28.0131>, <7.6638, 76.2554, -27.4423> }
					triangle { <7.6638, 76.2554, -27.4423>, <9.3112, 76.4882, -28.0131>, <8.9996, 74.9094, -27.043> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <8.7256, 79.2031, -25.9326>, <10.1953, 77.8887, -26.2441>, <9.3143, 78.1227, -27.47> }
					triangle { <10.1953, 77.8887, -26.2441>, <10.3693, 76.2415, -26.6869>, <9.3143, 78.1227, -27.47> }
					triangle { <9.3143, 78.1227, -27.47>, <10.3693, 76.2415, -26.6869>, <9.2755, 76.4926, -28.04135> }
					triangle { <9.2755, 76.4926, -28.04135>, <10.3693, 76.2415, -26.6869>, <9.08717, 74.8953, -26.9603> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <8.7256, 79.2031, -25.9326>, <9.2477, 77.5336, -24.9708>, <10.1534, 77.8655, -26.1555> }
					triangle { <9.2477, 77.5336, -24.9708>, <9.4239, 75.8618, -25.3081>, <10.1534, 77.8655, -26.1555> }
					triangle { <10.1534, 77.8655, -26.1555>, <9.4239, 75.8618, -25.3081>, <10.3851, 76.2522, -26.7285> }
					triangle { <10.3851, 76.2522, -26.7285>, <9.4239, 75.8618, -25.3081>, <9.03526, 74.8674, -26.8543> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <8.7256, 79.2031, -25.9326>, <7.6986, 77.5562, -25.4658>, <9.1478, 77.5305, -24.983> }
					triangle { <7.6986, 77.5562, -25.4658>, <7.7727, 75.8703, -25.7692>, <9.1478, 77.5305, -24.983> }
					triangle { <9.1478, 77.5305, -24.983>, <7.7727, 75.8703, -25.7692>, <9.4696, 75.864, -25.3059> }
					triangle { <9.4696, 75.864, -25.3059>, <7.7727, 75.8703, -25.7692>, <8.9151, 74.864, -26.8706> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <8.7256, 79.2031, -25.9326>, <7.6942, 77.9329, -27.07622>, <7.6603, 77.5829, -25.5895> }
					triangle { <7.6942, 77.9329, -27.07622>, <7.7021, 76.2633, -27.4662>, <7.6603, 77.5829, -25.5895> }
					triangle { <7.6603, 77.5829, -25.5895>, <7.7021, 76.2633, -27.4662>, <7.7623, 75.8661, -25.7538> }
					triangle { <7.7623, 75.8661, -25.7538>, <7.7021, 76.2633, -27.4662>, <8.8928, 74.8903, -26.9889> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <8.583, 81.5983, -25.6753>, <8.6063, 81.1986, -25.6195>, 0.08564 }
			cylinder { <8.6063, 81.1986, -25.6195>, <8.6295, 80.7989, -25.5636>, 0.08564 }
			cylinder { <8.6295, 80.7989, -25.5636>, <8.6527, 80.3993, -25.5078>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <8.6527, 80.3993, -25.5078>, <8.7642, 79.6199, -25.3239>, 0.08564 }
				cylinder { <8.7642, 79.6199, -25.3239>, <8.939, 78.8723, -25.07071>, 0.08564 }
				cylinder { <8.939, 78.8723, -25.07071>, <9.1745, 78.1677, -24.7519>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <9.1745, 78.1677, -24.7519>, <9.8646, 77.7021, -23.4045>, <10.5291, 77.477, -24.3929> }
					triangle { <9.8646, 77.7021, -23.4045>, <10.319, 76.5511, -22.8396>, <10.5291, 77.477, -24.3929> }
					triangle { <10.5291, 77.477, -24.3929>, <10.319, 76.5511, -22.8396>, <11.02107, 76.2565, -24.00926> }
					triangle { <11.02107, 76.2565, -24.00926>, <10.319, 76.5511, -22.8396>, <10.2406, 75.1361, -23.3023> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <9.1745, 78.1677, -24.7519>, <8.6778, 77.2267, -23.5788>, <9.7885, 77.6782, -23.4012> }
					triangle { <8.6778, 77.2267, -23.5788>, <9.05537, 76.06699, -22.9762>, <9.7885, 77.6782, -23.4012> }
					triangle { <9.7885, 77.6782, -23.4012>, <9.05537, 76.06699, -22.9762>, <10.3538, 76.5609, -22.8437> }
					triangle { <10.3538, 76.5609, -22.8437>, <9.05537, 76.06699, -22.9762>, <10.149, 75.1068, -23.2995> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <9.1745, 78.1677, -24.7519>, <8.6278, 76.6813, -24.7472>, <8.6601, 77.1897, -23.6474> }
					triangle { <8.6278, 76.6813, -24.7472>, <8.9533, 75.4797, -24.1988>, <8.6601, 77.1897, -23.6474> }
					triangle { <8.6601, 77.1897, -23.6474>, <8.9533, 75.4797, -24.1988>, <9.06599, 76.0842, -22.946> }
					triangle { <9.06599, 76.0842, -22.946>, <8.9533, 75.4797, -24.1988>, <10.1289, 75.06255, -23.3825> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <9.1745, 78.1677, -24.7519>, <9.7832, 76.8146, -25.3059>, <8.6928, 76.682, -24.7936> }
					triangle { <9.7832, 76.8146, -25.3059>, <10.153, 75.5954, -24.8292>, <8.6928, 76.682, -24.7936> }
					triangle { <8.6928, 76.682, -24.7936>, <10.153, 75.5954, -24.8292>, <8.9252, 75.4807, -24.1758> }
					triangle { <8.9252, 75.4807, -24.1758>, <10.153, 75.5954, -24.8292>, <10.2079, 75.06409, -23.4374> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <9.1745, 78.1677, -24.7519>, <10.5592, 77.4551, -24.4636>, <9.8654, 76.8623, -25.2613> }
					triangle { <10.5592, 77.4551, -24.4636>, <11.00989, 76.2676, -23.9765>, <9.8654, 76.8623, -25.2613> }
					triangle { <9.8654, 76.8623, -25.2613>, <11.00989, 76.2676, -23.9765>, <10.1517, 75.5888, -24.8428> }
					triangle { <10.1517, 75.5888, -24.8428>, <11.00989, 76.2676, -23.9765>, <10.2779, 75.1102, -23.3871> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <6.9699, 84.4958, -24.5032>, <7.4576, 90.09281, -26.305>, 0.8 }
		cylinder { <7.4576, 90.09281, -26.305>, <7.3924, 95.834, -27.6628>, 0.8 }
		cylinder { <7.3924, 95.834, -27.6628>, <6.7755, 101.6333, -28.5562>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.7755, 101.6333, -28.5562>, <6.3402, 102.7201, -28.4463>, 0.9965 }
			cylinder { <6.3402, 102.7201, -28.4463>, <5.6507, 103.5922, -28.06308>, 0.9965 }
			cylinder { <5.6507, 103.5922, -28.06308>, <4.7997, 104.1328, -27.4579>, 0.9965 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <4.7997, 104.1328, -27.4579>, <-13.9452, 114.4226, -22.2256>, <-19.614, 115.5124, -18.9356> }
			triangle { <4.7997, 104.1328, -27.4579>, <-8.7528, 112.1427, -25.1225>, <-13.9452, 114.4226, -22.2256> }
			triangle { <4.7997, 104.1328, -27.4579>, <-3.3858, 110.1047, -27.9899>, <-8.7528, 112.1427, -25.1225> }
			triangle { <4.7997, 104.1328, -27.4579>, <0.5354, 107.37, -28.7721>, <-3.3858, 110.1047, -27.9899> }
			triangle { <4.7997, 104.1328, -27.4579>, <-19.614, 115.5124, -18.9356>, <-19.00811, 111.4911, -13.9086> }
			triangle { <-19.614, 115.5124, -18.9356>, <-28.8602, 110.6765, -15.9661>, <-19.00811, 111.4911, -13.9086> }
			triangle { <-19.00811, 111.4911, -13.9086>, <-28.8602, 110.6765, -15.9661>, <-30.4542, 110.3863, -13.2875> }
			triangle { <-19.00811, 111.4911, -13.9086>, <-30.4542, 110.3863, -13.2875>, <-37.4568, 98.8187, -11.05467> }
			triangle { <-15.3487, 110.8237, -8.7487>, <-9.4579, 109.5116, -11.5278>, <4.7997, 104.1328, -27.4579> }
			triangle { <-9.4579, 109.5116, -11.5278>, <-3.9636, 108.1799, -14.8472>, <4.7997, 104.1328, -27.4579> }
			triangle { <-3.9636, 108.1799, -14.8472>, <0.832, 105.8803, -18.2843>, <4.7997, 104.1328, -27.4579> }
			triangle { <0.832, 105.8803, -18.2843>, <3.4213, 104.4796, -22.1315>, <4.7997, 104.1328, -27.4579> }
			triangle { <-19.00811, 111.4911, -13.9086>, <-15.3487, 110.8237, -8.7487>, <4.7997, 104.1328, -27.4579> }
			triangle { <-19.00811, 111.4911, -13.9086>, <-25.08629, 106.8968, -7.2822>, <-15.3487, 110.8237, -8.7487> }
			triangle { <-28.954, 106.4621, -8.2548>, <-25.08629, 106.8968, -7.2822>, <-19.00811, 111.4911, -13.9086> }
			triangle { <-37.4568, 98.8187, -11.05467>, <-28.954, 106.4621, -8.2548>, <-19.00811, 111.4911, -13.9086> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <6.7755, 101.6333, -28.5562>, <5.962, 102.3627, -28.03023>, 0.08564 }
			cylinder { <5.962, 102.3627, -28.03023>, <5.1196, 102.0398, -27.2198>, 0.08564 }
			cylinder { <5.1196, 102.0398, -27.2198>, <4.9295, 100.9257, -26.7804>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <4.9295, 100.9257, -26.7804>, <4.8661, 100.5543, -26.634>, 0.08564 }
			cylinder { <4.8661, 100.5543, -26.634>, <4.8027, 100.1829, -26.4875>, 0.08564 }
			cylinder { <4.8027, 100.1829, -26.4875>, <4.7393, 99.8115, -26.341>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.7393, 99.8115, -26.341>, <4.6015, 99.1121, -25.9596>, 0.08564 }
				cylinder { <4.6015, 99.1121, -25.9596>, <4.4545, 98.4667, -25.4955>, 0.08564 }
				cylinder { <4.4545, 98.4667, -25.4955>, <4.3008, 97.8848, -24.9557>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <4.3008, 97.8848, -24.9557>, <3.5187, 97.8006, -23.121>, <4.9789, 97.3561, -23.1842> }
					triangle { <3.5187, 97.8006, -23.121>, <3.2165, 96.6259, -21.9092>, <4.9789, 97.3561, -23.1842> }
					triangle { <4.9789, 97.3561, -23.1842>, <3.2165, 96.6259, -21.9092>, <4.8728, 96.05222, -22.05579> }
					triangle { <4.8728, 96.05222, -22.05579>, <3.2165, 96.6259, -21.9092>, <3.4354, 94.7597, -21.9179> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.3008, 97.8848, -24.9557>, <2.6679, 96.9854, -24.242>, <3.4509, 97.7603, -23.1837> }
					triangle { <2.6679, 96.9854, -24.242>, <2.2662, 95.7985, -23.07169>, <3.4509, 97.7603, -23.1837> }
					triangle { <3.4509, 97.7603, -23.1837>, <2.2662, 95.7985, -23.07169>, <3.2497, 96.6422, -21.8822> }
					triangle { <3.2497, 96.6422, -21.8822>, <2.2662, 95.7985, -23.07169>, <3.355, 94.7103, -21.994> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.3008, 97.8848, -24.9557>, <3.6839, 95.9877, -25.0279>, <2.7149, 96.9185, -24.3007> }
					triangle { <3.6839, 95.9877, -25.0279>, <3.2872, 94.7265, -23.9362>, <2.7149, 96.9185, -24.3007> }
					triangle { <2.7149, 96.9185, -24.3007>, <3.2872, 94.7265, -23.9362>, <2.2479, 95.8295, -23.04344> }
					triangle { <2.2479, 95.8295, -23.04344>, <3.2872, 94.7265, -23.9362>, <3.4131, 94.6301, -22.06393> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.3008, 97.8848, -24.9557>, <5.1722, 96.1771, -24.3999>, <3.7812, 95.986, -25.00205> }
					triangle { <5.1722, 96.1771, -24.3999>, <4.8779, 94.8814, -23.3161>, <3.7812, 95.986, -25.00205> }
					triangle { <3.7812, 95.986, -25.00205>, <4.8779, 94.8814, -23.3161>, <3.2424, 94.7297, -23.9455> }
					triangle { <3.2424, 94.7297, -23.9455>, <4.8779, 94.8814, -23.3161>, <3.5299, 94.6292, -22.03167> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <4.3008, 97.8848, -24.9557>, <5.06856, 97.3144, -23.2036>, <5.2015, 96.2605, -24.3015> }
					triangle { <5.06856, 97.3144, -23.2036>, <4.8336, 96.07308, -22.04447>, <5.2015, 96.2605, -24.3015> }
					triangle { <5.2015, 96.2605, -24.3015>, <4.8336, 96.07308, -22.04447>, <4.8892, 94.8694, -23.3259> }
					triangle { <4.8892, 94.8694, -23.3259>, <4.8336, 96.07308, -22.04447>, <3.5439, 94.7104, -21.94> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <4.7393, 99.8115, -26.341>, <4.676, 99.4401, -26.1946>, 0.08564 }
			cylinder { <4.676, 99.4401, -26.1946>, <4.6126, 99.06876, -26.04813>, 0.08564 }
			cylinder { <4.6126, 99.06876, -26.04813>, <4.5492, 98.6973, -25.9016>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <4.5492, 98.6973, -25.9016>, <4.3672, 97.9387, -25.6895>, 0.08564 }
				cylinder { <4.3672, 97.9387, -25.6895>, <4.1327, 97.1757, -25.5613>, 0.08564 }
				cylinder { <4.1327, 97.1757, -25.5613>, <3.8493, 96.4198, -25.5191>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <3.8493, 96.4198, -25.5191>, <3.2399, 95.3741, -26.5407>, <2.4643, 95.7133, -25.6732> }
					triangle { <3.2399, 95.3741, -26.5407>, <2.712, 94.1205, -26.5192>, <2.4643, 95.7133, -25.6732> }
					triangle { <2.4643, 95.7133, -25.6732>, <2.712, 94.1205, -26.5192>, <1.8744, 94.4933, -25.4671> }
					triangle { <1.8744, 94.4933, -25.4671>, <2.712, 94.1205, -26.5192>, <2.5846, 93.1308, -25.4116> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.8493, 96.4198, -25.5191>, <4.3431, 94.9911, -25.9917>, <3.3128, 95.3478, -26.5212> }
					triangle { <4.3431, 94.9911, -25.9917>, <3.8938, 93.7071, -25.9877>, <3.3128, 95.3478, -26.5212> }
					triangle { <3.3128, 95.3478, -26.5212>, <3.8938, 93.7071, -25.9877>, <2.6783, 94.1328, -26.5254> }
					triangle { <2.6783, 94.1328, -26.5254>, <3.8938, 93.7071, -25.9877>, <2.6721, 93.09939, -25.3869> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.8493, 96.4198, -25.5191>, <4.2207, 95.1084, -24.7125>, <4.3499, 94.993, -25.9121> }
					triangle { <4.2207, 95.1084, -24.7125>, <3.813, 93.813, -24.634>, <4.3499, 94.993, -25.9121> }
					triangle { <4.3499, 94.993, -25.9121>, <3.813, 93.813, -24.634>, <3.888, 93.7072, -26.02359> }
					triangle { <3.888, 93.7072, -26.02359>, <3.813, 93.813, -24.634>, <2.6792, 93.1021, -25.2911> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.8493, 96.4198, -25.5191>, <3.04081, 95.565, -24.4589>, <4.1521, 95.1358, -24.6821> }
					triangle { <3.04081, 95.565, -24.4589>, <2.5805, 94.2928, -24.3164>, <4.1521, 95.1358, -24.6821> }
					triangle { <4.1521, 95.1358, -24.6821>, <2.5805, 94.2928, -24.3164>, <3.843, 93.8008, -24.6504> }
					triangle { <3.843, 93.8008, -24.6504>, <2.5805, 94.2928, -24.3164>, <2.5961, 93.1352, -25.2556> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.8493, 96.4198, -25.5191>, <2.4254, 95.7317, -25.6058>, <2.9691, 95.5878, -24.5322> }
					triangle { <2.4254, 95.7317, -25.6058>, <1.8898, 94.4858, -25.4991>, <2.9691, 95.5878, -24.5322> }
					triangle { <2.9691, 95.5878, -24.5322>, <1.8898, 94.4858, -25.4991>, <2.5798, 94.294, -24.3013> }
					triangle { <2.5798, 94.294, -24.3013>, <1.8898, 94.4858, -25.4991>, <2.5368, 93.1532, -25.3313> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <6.7755, 101.6333, -28.5562>, <6.5208, 107.418, -29.6888>, 0.8 }
		cylinder { <6.5208, 107.418, -29.6888>, <6.6298, 113.1568, -31.05433>, 0.8 }
		cylinder { <6.6298, 113.1568, -31.05433>, <7.1018, 118.8185, -32.6454>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <7.1018, 118.8185, -32.6454>, <7.5295, 119.7532, -33.1422>, 0.9675 }
			cylinder { <7.5295, 119.7532, -33.1422>, <8.2363, 120.4018, -33.7612>, 0.9675 }
			cylinder { <8.2363, 120.4018, -33.7612>, <9.1273, 120.6774, -34.4196>, 0.9675 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <9.1273, 120.6774, -34.4196>, <27.7726, 128.634, -41.1915>, <33.6291, 128.5653, -43.8953> }
			triangle { <9.1273, 120.6774, -34.4196>, <22.4286, 127.5227, -38.2882>, <27.7726, 128.634, -41.1915> }
			triangle { <9.1273, 120.6774, -34.4196>, <16.9188, 126.6022, -35.5293>, <22.4286, 127.5227, -38.2882> }
			triangle { <9.1273, 120.6774, -34.4196>, <13.05919, 124.2984, -34.1451>, <16.9188, 126.6022, -35.5293> }
			triangle { <9.1273, 120.6774, -34.4196>, <33.6291, 128.5653, -43.8953>, <33.6776, 122.9432, -46.6879> }
			triangle { <33.6291, 128.5653, -43.8953>, <42.9195, 123.6193, -43.4881>, <33.6776, 122.9432, -46.6879> }
			triangle { <33.6776, 122.9432, -46.6879>, <42.9195, 123.6193, -43.4881>, <44.7831, 122.3593, -45.5319> }
			triangle { <33.6776, 122.9432, -46.6879>, <44.7831, 122.3593, -45.5319>, <51.8538, 111.6718, -41.9502> }
			triangle { <30.7858, 120.0439, -51.3107>, <24.7789, 119.696, -48.9849>, <9.1273, 120.6774, -34.4196> }
			triangle { <24.7789, 119.696, -48.9849>, <19.08819, 119.5739, -46.1368>, <9.1273, 120.6774, -34.4196> }
			triangle { <19.08819, 119.5739, -46.1368>, <14.06033, 118.6881, -42.7111>, <9.1273, 120.6774, -34.4196> }
			triangle { <14.06033, 118.6881, -42.7111>, <11.1033, 118.8836, -39.05898>, <9.1273, 120.6774, -34.4196> }
			triangle { <33.6776, 122.9432, -46.6879>, <30.7858, 120.0439, -51.3107>, <9.1273, 120.6774, -34.4196> }
			triangle { <33.6776, 122.9432, -46.6879>, <40.3619, 116.5383, -49.9139>, <30.7858, 120.0439, -51.3107> }
			triangle { <43.9705, 116.7701, -48.4666>, <40.3619, 116.5383, -49.9139>, <33.6776, 122.9432, -46.6879> }
			triangle { <51.8538, 111.6718, -41.9502>, <43.9705, 116.7701, -48.4666>, <33.6776, 122.9432, -46.6879> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <7.1018, 118.8185, -32.6454>, <7.9715, 119.3045, -33.3369>, 0.08564 }
			cylinder { <7.9715, 119.3045, -33.3369>, <8.9106, 118.7197, -33.8336>, 0.08564 }
			cylinder { <8.9106, 118.7197, -33.8336>, <9.1598, 117.5371, -33.734>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <9.1598, 117.5371, -33.734>, <9.2429, 117.1429, -33.7007>, 0.08564 }
			cylinder { <9.2429, 117.1429, -33.7007>, <9.3259, 116.7487, -33.6675>, 0.08564 }
			cylinder { <9.3259, 116.7487, -33.6675>, <9.409, 116.3545, -33.6343>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.409, 116.3545, -33.6343>, <9.5971, 115.5688, -33.6646>, 0.08564 }
				cylinder { <9.5971, 115.5688, -33.6646>, <9.8042, 114.7977, -33.791>, 0.08564 }
				cylinder { <9.8042, 114.7977, -33.791>, <10.02748, 114.0527, -34.01176>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <10.02748, 114.0527, -34.01176>, <11.03435, 113.2495, -35.5368>, <9.5798, 112.7895, -35.4545> }
					triangle { <11.03435, 113.2495, -35.5368>, <11.4921, 111.6936, -36.09301>, <9.5798, 112.7895, -35.4545> }
					triangle { <9.5798, 112.7895, -35.4545>, <11.4921, 111.6936, -36.09301>, <9.8332, 111.1403, -35.9028> }
					triangle { <9.8332, 111.1403, -35.9028>, <11.4921, 111.6936, -36.09301>, <11.2827, 109.9951, -35.3171> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.02748, 114.0527, -34.01176>, <11.7414, 113.0322, -34.08842>, <11.09388, 113.2434, -35.4559> }
					triangle { <11.7414, 113.0322, -34.08842>, <12.2926, 111.4884, -34.5909>, <11.09388, 113.2434, -35.4559> }
					triangle { <11.09388, 113.2434, -35.4559>, <12.2926, 111.4884, -34.5909>, <11.4624, 111.695, -36.1278> }
					triangle { <11.4624, 111.695, -36.1278>, <12.2926, 111.4884, -34.5909>, <11.3532, 109.987, -35.2188> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.02748, 114.0527, -34.01176>, <10.6394, 112.4011, -33.07233>, <11.6876, 112.9936, -34.01254> }
					triangle { <10.6394, 112.4011, -33.07233>, <11.1762, 110.8228, -33.4731>, <11.6876, 112.9936, -34.01254> }
					triangle { <11.6876, 112.9936, -34.01254>, <11.1762, 110.8228, -33.4731>, <12.3142, 111.5057, -34.6274> }
					triangle { <12.3142, 111.5057, -34.6274>, <11.1762, 110.8228, -33.4731>, <11.2871, 109.9405, -35.1284> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.02748, 114.0527, -34.01176>, <9.241, 112.2224, -33.8833>, <10.5461, 112.383, -33.1057> }
					triangle { <9.241, 112.2224, -33.8833>, <9.6753, 110.6104, -34.2738>, <10.5461, 112.383, -33.1057> }
					triangle { <10.5461, 112.383, -33.1057>, <9.6753, 110.6104, -34.2738>, <11.2194, 110.8322, -33.4611> }
					triangle { <11.2194, 110.8322, -33.4611>, <9.6753, 110.6104, -34.2738>, <11.1753, 109.9193, -35.17> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.02748, 114.0527, -34.01176>, <9.4887, 112.7547, -35.4294>, <9.2238, 112.2549, -34.01037> }
					triangle { <9.4887, 112.7547, -35.4294>, <9.8734, 111.1567, -35.9174>, <9.2238, 112.2549, -34.01037> }
					triangle { <9.2238, 112.2549, -34.01037>, <9.8734, 111.1567, -35.9174>, <9.6629, 110.603, -34.2612> }
					triangle { <9.6629, 110.603, -34.2612>, <9.8734, 111.1567, -35.9174>, <11.1725, 109.9535, -35.2884> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <9.409, 116.3545, -33.6343>, <9.4921, 115.9603, -33.6011>, 0.08564 }
			cylinder { <9.4921, 115.9603, -33.6011>, <9.5751, 115.5661, -33.5679>, 0.08564 }
			cylinder { <9.5751, 115.5661, -33.5679>, <9.6582, 115.1719, -33.5347>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <9.6582, 115.1719, -33.5347>, <9.869, 114.4064, -33.3828>, 0.08564 }
				cylinder { <9.869, 114.4064, -33.3828>, <10.1214, 113.6752, -33.1477>, 0.08564 }
				cylinder { <10.1214, 113.6752, -33.1477>, <10.4115, 112.9894, -32.8329>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <10.4115, 112.9894, -32.8329>, <10.8927, 112.5076, -31.4029>, <11.7695, 112.4945, -32.2397> }
					triangle { <10.8927, 112.5076, -31.4029>, <11.425, 111.3942, -30.8308>, <11.7695, 112.4945, -32.2397> }
					triangle { <11.7695, 112.4945, -32.2397>, <11.425, 111.3942, -30.8308>, <12.3864, 111.3373, -31.8408> }
					triangle { <12.3864, 111.3373, -31.8408>, <11.425, 111.3942, -30.8308>, <11.6953, 110.0394, -31.3913> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.4115, 112.9894, -32.8329>, <9.8691, 111.8663, -31.8568>, <10.8229, 112.4715, -31.4174> }
					triangle { <9.8691, 111.8663, -31.8568>, <10.3215, 110.728, -31.2649>, <10.8229, 112.4715, -31.4174> }
					triangle { <10.8229, 112.4715, -31.4174>, <10.3215, 110.728, -31.2649>, <11.4576, 111.4098, -30.8267> }
					triangle { <11.4576, 111.4098, -30.8267>, <10.3215, 110.728, -31.2649>, <11.6118, 109.9955, -31.41> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.4115, 112.9894, -32.8329>, <10.1507, 111.4413, -33.04224>, <9.8722, 111.8341, -31.9298> }
					triangle { <10.1507, 111.4413, -33.04224>, <10.5712, 110.259, -32.517>, <9.8722, 111.8341, -31.9298> }
					triangle { <9.8722, 111.8341, -31.9298>, <10.5712, 110.259, -32.517>, <10.3226, 110.7436, -31.2321> }
					triangle { <10.3226, 110.7436, -31.2321>, <10.5712, 110.259, -32.517>, <11.6168, 109.9572, -31.4981> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.4115, 112.9894, -32.8329>, <11.3509, 111.8161, -33.332>, <10.2224, 111.4573, -33.07355> }
					triangle { <11.3509, 111.8161, -33.332>, <11.8315, 110.6309, -32.8684>, <10.2224, 111.4573, -33.07355> }
					triangle { <10.2224, 111.4573, -33.07355>, <11.8315, 110.6309, -32.8684>, <10.5394, 110.2531, -32.5005> }
					triangle { <10.5394, 110.2531, -32.5005>, <11.8315, 110.6309, -32.8684>, <11.7035, 109.9771, -31.5347> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.4115, 112.9894, -32.8329>, <11.8164, 112.485, -32.3036>, <11.4127, 111.8716, -33.2679> }
					triangle { <11.8164, 112.485, -32.3036>, <12.3672, 111.343, -31.8105>, <11.4127, 111.8716, -33.2679> }
					triangle { <11.4127, 111.8716, -33.2679>, <12.3672, 111.343, -31.8105>, <11.8342, 110.6256, -32.8823> }
					triangle { <11.8342, 110.6256, -32.8823>, <12.3672, 111.343, -31.8105>, <11.7528, 110.0287, -31.4677> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <7.1018, 118.8185, -32.6454>, <7.1845, 124.5468, -34.05608>, 0.8 }
		cylinder { <7.1845, 124.5468, -34.05608>, <6.8773, 130.3106, -35.2785>, 0.8 }
		cylinder { <6.8773, 130.3106, -35.2785>, <6.182, 136.0786, -36.3061>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.182, 136.0786, -36.3061>, <5.7997, 136.8806, -36.3049>, 0.7528 }
			cylinder { <5.7997, 136.8806, -36.3049>, <5.1912, 137.5086, -36.1479>, 0.7528 }
			cylinder { <5.1912, 137.5086, -36.1479>, <4.4378, 137.8783, -35.8562>, 0.7528 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <4.4378, 137.8783, -35.8562>, <-10.6483, 144.8645, -35.3731>, <-15.4337, 145.4385, -33.9696> }
			triangle { <4.4378, 137.8783, -35.8562>, <-6.2345, 143.3707, -36.5708>, <-10.6483, 144.8645, -35.3731> }
			triangle { <4.4378, 137.8783, -35.8562>, <-1.7077, 142.0661, -37.7161>, <-6.2345, 143.3707, -36.5708> }
			triangle { <4.4378, 137.8783, -35.8562>, <1.4159, 140.163, -37.5868>, <-1.7077, 142.0661, -37.7161> }
			triangle { <4.4378, 137.8783, -35.8562>, <-15.4337, 145.4385, -33.9696>, <-15.7234, 142.3898, -30.1634> }
			triangle { <-15.4337, 145.4385, -33.9696>, <-22.5477, 141.4037, -33.4279>, <-15.7234, 142.3898, -30.1634> }
			triangle { <-15.7234, 142.3898, -30.1634>, <-22.5477, 141.4037, -33.4279>, <-24.1817, 141.1015, -31.7447> }
			triangle { <-15.7234, 142.3898, -30.1634>, <-24.1817, 141.1015, -31.7447>, <-29.2502, 132.0819, -31.332> }
			triangle { <-13.9324, 141.9906, -25.7217>, <-9.06625, 141.2536, -26.7103>, <4.4378, 137.8783, -35.8562> }
			triangle { <-9.06625, 141.2536, -26.7103>, <-4.3939, 140.4904, -28.1661>, <4.4378, 137.8783, -35.8562> }
			triangle { <-4.3939, 140.4904, -28.1661>, <-0.174, 138.9703, -29.831>, <4.4378, 137.8783, -35.8562> }
			triangle { <-0.174, 138.9703, -29.831>, <2.4653, 138.0449, -32.1917>, <4.4378, 137.8783, -35.8562> }
			triangle { <-15.7234, 142.3898, -30.1634>, <-13.9324, 141.9906, -25.7217>, <4.4378, 137.8783, -35.8562> }
			triangle { <-15.7234, 142.3898, -30.1634>, <-21.1755, 138.6338, -26.3728>, <-13.9324, 141.9906, -25.7217> }
			triangle { <-23.8206, 138.1612, -27.7752>, <-21.1755, 138.6338, -26.3728>, <-15.7234, 142.3898, -30.1634> }
			triangle { <-29.2502, 132.0819, -31.332>, <-23.8206, 138.1612, -27.7752>, <-15.7234, 142.3898, -30.1634> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <6.182, 136.0786, -36.3061>, <5.23, 136.7594, -35.9885>, 0.08564 }
			cylinder { <5.23, 136.7594, -35.9885>, <4.2387, 136.3848, -35.3989>, 0.08564 }
			cylinder { <4.2387, 136.3848, -35.3989>, <4.00971, 135.2579, -35.01406>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <4.00971, 135.2579, -35.01406>, <3.9333, 134.8822, -34.8857>, 0.08564 }
			cylinder { <3.9333, 134.8822, -34.8857>, <3.857, 134.5066, -34.7575>, 0.08564 }
			cylinder { <3.857, 134.5066, -34.7575>, <3.7806, 134.1309, -34.6292>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.7806, 134.1309, -34.6292>, <3.594, 133.4215, -34.2894>, 0.08564 }
				cylinder { <3.594, 133.4215, -34.2894>, <3.3763, 132.7646, -33.8715>, 0.08564 }
				cylinder { <3.3763, 132.7646, -33.8715>, <3.1307, 132.1701, -33.3817>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <3.1307, 132.1701, -33.3817>, <1.9439, 132.0266, -31.783>, <3.3994, 131.6593, -31.499> }
					triangle { <1.9439, 132.0266, -31.783>, <1.4273, 130.8256, -30.6738>, <3.3994, 131.6593, -31.499> }
					triangle { <3.3994, 131.6593, -31.499>, <1.4273, 130.8256, -30.6738>, <3.09959, 130.3403, -30.4243> }
					triangle { <3.09959, 130.3403, -30.4243>, <1.4273, 130.8256, -30.6738>, <1.7407, 128.9734, -30.6261> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.1307, 132.1701, -33.3817>, <1.4256, 131.1796, -33.07113>, <1.8951, 131.9836, -31.8598> }
					triangle { <1.4256, 131.1796, -33.07113>, <0.8229, 129.9616, -32.02563>, <1.8951, 131.9836, -31.8598> }
					triangle { <1.8951, 131.9836, -31.8598>, <0.8229, 129.9616, -32.02563>, <1.4524, 130.8432, -30.6398> }
					triangle { <1.4524, 130.8432, -30.6398>, <0.8229, 129.9616, -32.02563>, <1.6832, 128.9207, -30.7189> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.1307, 132.1701, -33.3817>, <2.6496, 130.2443, -33.5927>, <1.4887, 131.1159, -33.1169> }
					triangle { <2.6496, 130.2443, -33.5927>, <2.07423, 128.953, -32.6224>, <1.4887, 131.1159, -33.1169> }
					triangle { <1.4887, 131.1159, -33.1169>, <2.07423, 128.953, -32.6224>, <0.7969, 129.9914, -32.00258> }
					triangle { <0.7969, 129.9914, -32.00258>, <2.07423, 128.953, -32.6224>, <1.7603, 128.8444, -30.773> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.1307, 132.1701, -33.3817>, <3.9358, 130.5044, -32.6319>, <2.738, 130.2473, -33.5447> }
					triangle { <3.9358, 130.5044, -32.6319>, <3.4636, 129.1842, -31.6451>, <2.738, 130.2473, -33.5447> }
					triangle { <2.738, 130.2473, -33.5447>, <3.4636, 129.1842, -31.6451>, <2.03282, 128.954, -32.642> }
					triangle { <2.03282, 128.954, -32.642>, <3.4636, 129.1842, -31.6451>, <1.8661, 128.8492, -30.7141> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <3.1307, 132.1701, -33.3817>, <3.4931, 131.6226, -31.4966>, <3.9367, 130.5883, -32.5297> }
					triangle { <3.4931, 131.6226, -31.4966>, <3.05779, 130.359, -30.4226>, <3.9367, 130.5883, -32.5297> }
					triangle { <3.9367, 130.5883, -32.5297>, <3.05779, 130.359, -30.4226>, <3.4774, 129.1729, -31.6519> }
					triangle { <3.4774, 129.1729, -31.6519>, <3.05779, 130.359, -30.4226>, <1.8538, 128.9301, -30.622> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <3.7806, 134.1309, -34.6292>, <3.7043, 133.7553, -34.5009>, 0.08564 }
			cylinder { <3.7043, 133.7553, -34.5009>, <3.6279, 133.3796, -34.3726>, 0.08564 }
			cylinder { <3.6279, 133.3796, -34.3726>, <3.5516, 133.004, -34.2443>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <3.5516, 133.004, -34.2443>, <3.3652, 132.2348, -34.0793>, 0.08564 }
				cylinder { <3.3652, 132.2348, -34.0793>, <3.1479, 131.4594, -34.00824>, 0.08564 }
				cylinder { <3.1479, 131.4594, -34.00824>, <2.9029, 130.6893, -34.03225>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <2.9029, 130.6893, -34.03225>, <2.6076, 129.6237, -35.1661>, <1.6326, 129.9134, -34.5068> }
					triangle { <2.6076, 129.6237, -35.1661>, <2.1567, 128.3443, -35.2668>, <1.6326, 129.9134, -34.5068> }
					triangle { <1.6326, 129.9134, -34.5068>, <2.1567, 128.3443, -35.2668>, <1.07631, 128.6623, -34.4427> }
					triangle { <1.07631, 128.6623, -34.4427>, <2.1567, 128.3443, -35.2668>, <1.8246, 127.338, -34.2181> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.9029, 130.6893, -34.03225>, <3.5691, 129.2931, -34.3716>, <2.6751, 129.6012, -35.1299> }
					triangle { <3.5691, 129.2931, -34.3716>, <3.2001, 127.9875, -34.4705>, <2.6751, 129.6012, -35.1299> }
					triangle { <2.6751, 129.6012, -35.1299>, <3.2001, 127.9875, -34.4705>, <2.1249, 128.3548, -35.2807> }
					triangle { <2.1249, 128.3548, -35.2807>, <3.2001, 127.9875, -34.4705>, <1.9053, 127.3109, -34.1734> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.9029, 130.6893, -34.03225>, <3.1428, 129.3909, -33.1576>, <3.5569, 129.2945, -34.2926> }
					triangle { <3.1428, 129.3909, -33.1576>, <2.7972, 128.0753, -33.1743>, <3.5569, 129.2945, -34.2926> }
					triangle { <3.5569, 129.2945, -34.2926>, <2.7972, 128.0753, -33.1743>, <3.2031, 127.9877, -34.5067> }
					triangle { <3.2031, 127.9877, -34.5067>, <2.7972, 128.0753, -33.1743>, <1.8894, 127.313, -34.07857> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.9029, 130.6893, -34.03225>, <1.9138, 129.7829, -33.1905>, <3.06763, 129.4144, -33.1443> }
					triangle { <1.9138, 129.7829, -33.1905>, <1.501, 128.4871, -33.1575>, <3.06763, 129.4144, -33.1443> }
					triangle { <3.06763, 129.4144, -33.1443>, <1.501, 128.4871, -33.1575>, <2.8309, 128.0648, -33.1831> }
					triangle { <2.8309, 128.0648, -33.1831>, <1.501, 128.4871, -33.1575>, <1.7987, 127.3414, -34.0638> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <2.9029, 130.6893, -34.03225>, <1.5781, 129.929, -34.4506>, <1.8604, 129.8026, -33.2786> }
					triangle { <1.5781, 129.929, -34.4506>, <1.0992, 128.6559, -34.4702>, <1.8604, 129.8026, -33.2786> }
					triangle { <1.8604, 129.8026, -33.2786>, <1.0992, 128.6559, -34.4702>, <1.4966, 128.488, -33.143> }
					triangle { <1.4966, 128.488, -33.143>, <1.0992, 128.6559, -34.4702>, <1.7581, 127.3571, -34.1513> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <6.182, 136.0786, -36.3061>, <6.1688, 141.8405, -37.5751>, 0.8 }
		cylinder { <6.1688, 141.8405, -37.5751>, <6.8378, 147.5096, -39.06644>, 0.8 }
		cylinder { <6.8378, 147.5096, -39.06644>, <8.1791, 153.0006, -40.7576>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <8.1791, 153.0006, -40.7576>, <8.3372, 153.2218, -40.8627>, 0.247 }
			cylinder { <8.3372, 153.2218, -40.8627>, <8.5658, 153.3634, -40.9754>, 0.247 }
			cylinder { <8.5658, 153.3634, -40.9754>, <8.8343, 153.4063, -41.08049>, 0.247 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <8.8343, 153.4063, -41.08049>, <14.03413, 154.9862, -41.5846>, <15.651, 154.8195, -41.8518> }
			triangle { <8.8343, 153.4063, -41.08049>, <12.5046, 154.8478, -41.2185>, <14.03413, 154.9862, -41.5846> }
			triangle { <8.8343, 153.4063, -41.08049>, <10.9481, 154.7582, -40.9015>, <12.5046, 154.8478, -41.2185> }
			triangle { <8.8343, 153.4063, -41.08049>, <9.8589, 154.2639, -40.7931>, <10.9481, 154.7582, -40.9015> }
			triangle { <8.8343, 153.4063, -41.08049>, <15.651, 154.8195, -41.8518>, <15.7289, 153.3396, -42.4631> }
			triangle { <15.651, 154.8195, -41.8518>, <17.8003, 153.4102, -41.05907>, <15.7289, 153.3396, -42.4631> }
			triangle { <15.7289, 153.3396, -42.4631>, <17.8003, 153.4102, -41.05907>, <18.3671, 153.0212, -41.4192> }
			triangle { <15.7289, 153.3396, -42.4631>, <18.3671, 153.0212, -41.4192>, <19.6376, 150.2479, -39.9225> }
			triangle { <15.2645, 152.5693, -43.7584>, <13.6269, 152.6259, -43.589>, <8.8343, 153.4063, -41.08049> }
			triangle { <13.6269, 152.6259, -43.589>, <12.0371, 152.7439, -43.2726>, <8.8343, 153.4063, -41.08049> }
			triangle { <12.0371, 152.7439, -43.2726>, <10.5553, 152.6668, -42.7595>, <8.8343, 153.4063, -41.08049> }
			triangle { <10.5553, 152.6668, -42.7595>, <9.5901, 152.833, -42.06437>, <8.8343, 153.4063, -41.08049> }
			triangle { <15.7289, 153.3396, -42.4631>, <15.2645, 152.5693, -43.7584>, <8.8343, 153.4063, -41.08049> }
			triangle { <15.7289, 153.3396, -42.4631>, <17.4488, 151.539, -42.7214>, <15.2645, 152.5693, -43.7584> }
			triangle { <18.2437, 151.5619, -42.1241>, <17.4488, 151.539, -42.7214>, <15.7289, 153.3396, -42.4631> }
			triangle { <19.6376, 150.2479, -39.9225>, <18.2437, 151.5619, -42.1241>, <15.7289, 153.3396, -42.4631> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <8.1791, 153.0006, -40.7576>, <9.2364, 153.377, -41.2171>, 0.08564 }
			cylinder { <9.2364, 153.377, -41.2171>, <10.2203, 152.6969, -41.4169>, 0.08564 }
			cylinder { <10.2203, 152.6969, -41.4169>, <10.3353, 151.5101, -41.1955>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <10.3353, 151.5101, -41.1955>, <10.3736, 151.1145, -41.1217>, 0.08564 }
			cylinder { <10.3736, 151.1145, -41.1217>, <10.4119, 150.719, -41.04789>, 0.08564 }
			cylinder { <10.4119, 150.719, -41.04789>, <10.4503, 150.3234, -40.974>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <10.4503, 150.3234, -40.974>, <10.5734, 149.5266, -40.9138>, 0.08564 }
				cylinder { <10.5734, 149.5266, -40.9138>, <10.7413, 148.7363, -40.9419>, 0.08564 }
				cylinder { <10.7413, 148.7363, -40.9419>, <10.9513, 147.9643, -41.05783>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <10.9513, 147.9643, -41.05783>, <12.2501, 146.9898, -42.2188>, <10.7913, 146.6356, -42.5023> }
					triangle { <12.2501, 146.9898, -42.2188>, <12.7055, 145.3712, -42.5548>, <10.7913, 146.6356, -42.5023> }
					triangle { <10.7913, 146.6356, -42.5023>, <12.7055, 145.3712, -42.5548>, <11.01427, 144.9456, -42.7839> }
					triangle { <11.01427, 144.9456, -42.7839>, <12.7055, 145.3712, -42.5548>, <12.1601, 143.7495, -41.7779> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9513, 147.9643, -41.05783>, <12.5346, 146.8279, -40.6257>, <12.2858, 146.9854, -42.1248> }
					triangle { <12.5346, 146.8279, -40.6257>, <13.06693, 145.219, -40.8859>, <12.2858, 146.9854, -42.1248> }
					triangle { <12.2858, 146.9854, -42.1248>, <13.06693, 145.219, -40.8859>, <12.6862, 145.3722, -42.5963> }
					triangle { <12.6862, 145.3722, -42.5963>, <13.06693, 145.219, -40.8859>, <12.2016, 143.7437, -41.6642> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9513, 147.9643, -41.05783>, <11.1572, 146.3455, -39.908>, <12.4599, 146.7985, -40.565> }
					triangle { <11.1572, 146.3455, -39.908>, <11.6462, 144.7104, -40.07225>, <12.4599, 146.7985, -40.565> }
					triangle { <12.4599, 146.7985, -40.565>, <11.6462, 144.7104, -40.07225>, <13.09865, 145.2321, -40.9162> }
					triangle { <13.09865, 145.2321, -40.9162>, <11.6462, 144.7104, -40.07225>, <12.1106, 143.7082, -41.5923> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9513, 147.9643, -41.05783>, <10.00863, 146.2047, -41.05086>, <11.0747, 146.3315, -39.9639> }
					triangle { <10.00863, 146.2047, -41.05086>, <10.3935, 144.5436, -41.2307>, <11.0747, 146.3315, -39.9639> }
					triangle { <11.0747, 146.3315, -39.9639>, <10.3935, 144.5436, -41.2307>, <11.6854, 144.7177, -40.04975> }
					triangle { <11.6854, 144.7177, -40.04975>, <10.3935, 144.5436, -41.2307>, <12.01217, 143.6917, -41.661> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9513, 147.9643, -41.05783>, <10.6943, 146.6089, -42.5006>, <10.02793, 146.2293, -41.1793> }
					triangle { <10.6943, 146.6089, -42.5006>, <11.05811, 144.9582, -42.7881>, <10.02793, 146.2293, -41.1793> }
					triangle { <10.02793, 146.2293, -41.1793>, <11.05811, 144.9582, -42.7881>, <10.3778, 144.5379, -41.2214> }
					triangle { <10.3778, 144.5379, -41.2214>, <11.05811, 144.9582, -42.7881>, <12.04322, 143.7177, -41.7775> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <10.4503, 150.3234, -40.974>, <10.4886, 149.9278, -40.9002>, 0.08564 }
			cylinder { <10.4886, 149.9278, -40.9002>, <10.5269, 149.5322, -40.8264>, 0.08564 }
			cylinder { <10.5269, 149.5322, -40.8264>, <10.5652, 149.1366, -40.7526>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <10.5652, 149.1366, -40.7526>, <10.6645, 148.3712, -40.512>, 0.08564 }
				cylinder { <10.6645, 148.3712, -40.512>, <10.785, 147.6431, -40.1819>, 0.08564 }
				cylinder { <10.785, 147.6431, -40.1819>, <10.9247, 146.9632, -39.7674>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <10.9247, 146.9632, -39.7674>, <10.9746, 146.5521, -38.2388>, <12.03502, 146.4211, -38.8112> }
					triangle { <10.9746, 146.5521, -38.2388>, <11.2446, 145.4484, -37.4907>, <12.03502, 146.4211, -38.8112> }
					triangle { <12.03502, 146.4211, -38.8112>, <11.2446, 145.4484, -37.4907>, <12.4278, 145.256, -38.2054> }
					triangle { <12.4278, 145.256, -38.2054>, <11.2446, 145.4484, -37.4907>, <11.5376, 144.0425, -37.8907> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9247, 146.9632, -39.7674>, <10.0549, 145.9507, -38.9151>, <10.9083, 146.5198, -38.2694> }
					triangle { <10.0549, 145.9507, -38.9151>, <10.2407, 144.8292, -38.168>, <10.9083, 146.5198, -38.2694> }
					triangle { <10.9083, 146.5198, -38.2694>, <10.2407, 144.8292, -38.168>, <11.2762, 145.4621, -37.479> }
					triangle { <11.2762, 145.4621, -37.479>, <10.2407, 144.8292, -38.168>, <11.4584, 144.0031, -37.9286> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9247, 146.9632, -39.7674>, <10.5992, 145.4253, -39.9604>, <10.07431, 145.9134, -38.9829> }
					triangle { <10.5992, 145.4253, -39.9604>, <10.7681, 144.2573, -39.2838>, <10.07431, 145.9134, -38.9829> }
					triangle { <10.07431, 145.9134, -38.9829>, <10.7681, 144.2573, -39.2838>, <10.2346, 144.8469, -38.1369> }
					triangle { <10.2346, 144.8469, -38.1369>, <10.7681, 144.2573, -39.2838>, <11.483, 143.9584, -38.01023> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9247, 146.9632, -39.7674>, <11.8604, 145.6971, -39.9399>, <10.6777, 145.4342, -39.9723> }
					triangle { <11.8604, 145.6971, -39.9399>, <12.1029, 144.5179, -39.3065>, <10.6777, 145.4342, -39.9723> }
					triangle { <10.6777, 145.4342, -39.9723>, <12.1029, 144.5179, -39.3065>, <10.7327, 144.2548, -39.276> }
					triangle { <10.7327, 144.2548, -39.276>, <12.1029, 144.5179, -39.3065>, <11.5776, 143.9698, -38.02349> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <10.9247, 146.9632, -39.7674>, <12.09604, 146.404, -38.8598>, <11.9077, 145.7528, -39.8646> }
					triangle { <12.09604, 146.404, -38.8598>, <12.4019, 145.2651, -38.1816>, <11.9077, 145.7528, -39.8646> }
					triangle { <11.9077, 145.7528, -39.8646>, <12.4019, 145.2651, -38.1816>, <12.1087, 144.5115, -39.319> }
					triangle { <12.1087, 144.5115, -39.319>, <12.4019, 145.2651, -38.1816>, <11.6118, 144.0225, -37.9485> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <8.1791, 153.0006, -40.7576>, <9.1044, 158.5967, -42.3816>, 0.8 }
		cylinder { <9.1044, 158.5967, -42.3816>, <9.6087, 164.2676, -43.9295>, 0.8 }
		cylinder { <9.6087, 164.2676, -43.9295>, <9.6892, 169.9827, -45.3931>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <9.6892, 169.9827, -45.3931>, <9.6093, 170.2015, -45.4304>, 0.2 }
			cylinder { <9.6093, 170.2015, -45.4304>, <9.4568, 170.3814, -45.4416>, 0.2 }
			cylinder { <9.4568, 170.3814, -45.4416>, <9.2524, 170.498, -45.425>, 0.2 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <9.2524, 170.498, -45.425>, <5.5193, 172.6237, -46.4576>, <4.2122, 172.8873, -46.4435> }
			triangle { <9.2524, 170.498, -45.425>, <6.6968, 172.1275, -46.433>, <5.5193, 172.6237, -46.4576> }
			triangle { <9.2524, 170.498, -45.425>, <7.9038, 171.6802, -46.3896>, <6.6968, 172.1275, -46.433> }
			triangle { <9.2524, 170.498, -45.425>, <8.6507, 171.1237, -46.111>, <7.9038, 171.6802, -46.3896> }
			triangle { <9.2524, 170.498, -45.425>, <4.2122, 172.8873, -46.4435>, <3.807, 172.1577, -45.4497> }
			triangle { <4.2122, 172.8873, -46.4435>, <2.2676, 171.9579, -46.7524>, <3.807, 172.1577, -45.4497> }
			triangle { <3.807, 172.1577, -45.4497>, <2.2676, 171.9579, -46.7524>, <1.7269, 171.9387, -46.4329> }
			triangle { <3.807, 172.1577, -45.4497>, <1.7269, 171.9387, -46.4329>, <0.2033, 169.6524, -46.5642> }
			triangle { <3.9483, 172.1032, -44.1821>, <5.2437, 171.8029, -44.08224>, <9.2524, 170.498, -45.425> }
			triangle { <5.2437, 171.8029, -44.08224>, <6.5214, 171.4904, -44.1152>, <9.2524, 170.498, -45.425> }
			triangle { <6.5214, 171.4904, -44.1152>, <7.6811, 170.9819, -44.2234>, <9.2524, 170.498, -45.425> }
			triangle { <7.6811, 170.9819, -44.2234>, <8.4984, 170.6459, -44.6289>, <9.2524, 170.498, -45.425> }
			triangle { <3.807, 172.1577, -45.4497>, <3.9483, 172.1032, -44.1821>, <9.2524, 170.498, -45.425> }
			triangle { <3.807, 172.1577, -45.4497>, <2.06839, 171.3331, -44.8142>, <3.9483, 172.1032, -44.1821> }
			triangle { <1.4791, 171.2292, -45.353>, <2.06839, 171.3331, -44.8142>, <3.807, 172.1577, -45.4497> }
			triangle { <0.2033, 169.6524, -46.5642>, <1.4791, 171.2292, -45.353>, <3.807, 172.1577, -45.4497> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <9.6892, 169.9827, -45.3931>, <8.7476, 170.7466, -45.374>, 0.08564 }
			cylinder { <8.7476, 170.7466, -45.374>, <7.6092, 170.4821, -45.05049>, 0.08564 }
			cylinder { <7.6092, 170.4821, -45.05049>, <7.1946, 169.403, -44.684>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <7.1946, 169.403, -44.684>, <7.0564, 169.0433, -44.5619>, 0.08564 }
			cylinder { <7.0564, 169.0433, -44.5619>, <6.9181, 168.6836, -44.4398>, 0.08564 }
			cylinder { <6.9181, 168.6836, -44.4398>, <6.7799, 168.3239, -44.3176>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.7799, 168.3239, -44.3176>, <6.4526, 167.6543, -44.00437>, 0.08564 }
				cylinder { <6.4526, 167.6543, -44.00437>, <6.07951, 167.0446, -43.6267>, 0.08564 }
				cylinder { <6.07951, 167.0446, -43.6267>, <5.666, 166.504, -43.1904>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <5.666, 166.504, -43.1904>, <4.09598, 166.5537, -41.9587>, <5.3911, 166.1102, -41.2807> }
					triangle { <4.09598, 166.5537, -41.9587>, <3.2097, 165.4713, -40.9673>, <5.3911, 166.1102, -41.2807> }
					triangle { <5.3911, 166.1102, -41.2807>, <3.2097, 165.4713, -40.9673>, <4.7125, 164.8934, -40.2592> }
					triangle { <4.7125, 164.8934, -40.2592>, <3.2097, 165.4713, -40.9673>, <3.3441, 163.6102, -40.7453> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.666, 166.504, -43.1904>, <3.8624, 165.6549, -43.2939>, <4.06541, 166.5087, -42.04345> }
					triangle { <3.8624, 165.6549, -43.2939>, <2.9086, 164.5569, -42.3859>, <4.06541, 166.5087, -42.04345> }
					triangle { <4.06541, 166.5087, -42.04345>, <2.9086, 164.5569, -42.3859>, <3.2264, 165.4896, -40.9288> }
					triangle { <3.2264, 165.4896, -40.9288>, <2.9086, 164.5569, -42.3859>, <3.3086, 163.5551, -40.8473> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.666, 166.504, -43.1904>, <5.09753, 164.6049, -43.4245>, <3.9296, 165.584, -43.318> }
					triangle { <5.09753, 164.6049, -43.4245>, <4.1834, 163.4268, -42.578>, <3.9296, 165.584, -43.318> }
					triangle { <3.9296, 165.584, -43.318>, <4.1834, 163.4268, -42.578>, <2.88, 164.5899, -42.3721> }
					triangle { <2.88, 164.5899, -42.3721>, <4.1834, 163.4268, -42.578>, <3.3904, 163.4701, -40.8751> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.666, 166.504, -43.1904>, <6.1059, 164.8449, -42.1713>, <5.1703, 164.6053, -43.3549> }
					triangle { <6.1059, 164.8449, -42.1713>, <5.2843, 163.6323, -41.28>, <5.1703, 164.6053, -43.3549> }
					triangle { <5.1703, 164.6053, -43.3549>, <5.2843, 163.6323, -41.28>, <4.1488, 163.4292, -42.6079> }
					triangle { <4.1488, 163.4292, -42.6079>, <5.2843, 163.6323, -41.28>, <3.4773, 163.4719, -40.7905> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.666, 166.504, -43.1904>, <5.4776, 166.0676, -41.2517>, <6.0872, 164.9355, -42.07684> }
					triangle { <5.4776, 166.0676, -41.2517>, <4.6735, 164.9149, -40.2695>, <6.0872, 164.9355, -42.07684> }
					triangle { <6.0872, 164.9355, -42.07684>, <4.6735, 164.9149, -40.2695>, <5.2985, 163.6196, -41.2823> }
					triangle { <5.2985, 163.6196, -41.2823>, <4.6735, 164.9149, -40.2695>, <3.4482, 163.5598, -40.7091> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <6.7799, 168.3239, -44.3176>, <6.6417, 167.9642, -44.1955>, 0.08564 }
			cylinder { <6.6417, 167.9642, -44.1955>, <6.5035, 167.6045, -44.07341>, 0.08564 }
			cylinder { <6.5035, 167.6045, -44.07341>, <6.3653, 167.2448, -43.9512>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <6.3653, 167.2448, -43.9512>, <6.07879, 166.5035, -43.8031>, 0.08564 }
				cylinder { <6.07879, 166.5035, -43.8031>, <5.7865, 165.7514, -43.7534>, 0.08564 }
				cylinder { <5.7865, 165.7514, -43.7534>, <5.4928, 164.9998, -43.8028>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <5.4928, 164.9998, -43.8028>, <5.4154, 163.8793, -44.9194>, <4.33, 164.2796, -44.5578> }
					triangle { <5.4154, 163.8793, -44.9194>, <4.9011, 162.6291, -45.07176>, <4.33, 164.2796, -44.5578> }
					triangle { <4.33, 164.2796, -44.5578>, <4.9011, 162.6291, -45.07176>, <3.6737, 163.0764, -44.5808> }
					triangle { <3.6737, 163.0764, -44.5808>, <4.9011, 162.6291, -45.07176>, <4.2244, 161.7239, -44.09956> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.4928, 164.9998, -43.8028>, <6.1055, 163.5415, -43.8828>, <5.469, 163.8548, -44.8655> }
					triangle { <6.1055, 163.5415, -43.8828>, <5.6674, 162.2599, -44.01036>, <5.469, 163.8548, -44.8655> }
					triangle { <5.469, 163.8548, -44.8655>, <5.6674, 162.2599, -44.01036>, <4.875, 162.6408, -45.09416> }
					triangle { <4.875, 162.6408, -45.09416>, <5.6674, 162.2599, -44.01036>, <4.2881, 161.6947, -44.03373> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.4928, 164.9998, -43.8028>, <5.3872, 163.753, -42.8318>, <6.07336, 163.5493, -43.8101> }
					triangle { <5.3872, 163.753, -42.8318>, <4.9494, 162.4657, -42.8736>, <6.07336, 163.5493, -43.8101> }
					triangle { <6.07336, 163.5493, -43.8101>, <4.9494, 162.4657, -42.8736>, <5.6797, 162.2574, -44.04448> }
					triangle { <5.6797, 162.2574, -44.04448>, <4.9494, 162.4657, -42.8736>, <4.2483, 161.7045, -43.9467> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.4928, 164.9998, -43.8028>, <4.2465, 164.2235, -43.2092>, <5.3134, 163.7824, -42.8401> }
					triangle { <4.2465, 164.2235, -43.2092>, <3.7326, 162.964, -43.2218>, <5.3134, 163.7824, -42.8401> }
					triangle { <5.3134, 163.7824, -42.8401>, <3.7326, 162.964, -43.2218>, <4.9832, 162.4524, -42.8726> }
					triangle { <4.9832, 162.4524, -42.8726>, <3.7326, 162.964, -43.2218>, <4.1596, 161.7399, -43.9579> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <5.4928, 164.9998, -43.8028>, <4.2641, 164.3027, -44.5189>, <4.2197, 164.2406, -43.3092> }
					triangle { <4.2641, 164.3027, -44.5189>, <3.7023, 163.0665, -44.6009>, <4.2197, 164.2406, -43.3092> }
					triangle { <4.2197, 164.2406, -43.3092>, <3.7023, 163.0665, -44.6009>, <3.7247, 162.9662, -43.2091> }
					triangle { <3.7247, 162.9662, -43.2091>, <3.7023, 163.0665, -44.6009>, <4.1446, 161.7521, -44.05387> }
					texture{Wflower_Texture8}}
				}
			}
		}
	union { // internode
		cylinder { <9.6892, 169.9827, -45.3931>, <10.05792, 175.6803, -46.8799>, 0.8 }
		cylinder { <10.05792, 175.6803, -46.8799>, <10.7138, 181.347, -48.3862>, 0.8 }
		cylinder { <10.7138, 181.347, -48.3862>, <11.6553, 186.9689, -49.9085>, 0.8 }
		texture{Wflower_Texture4}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <11.6553, 186.9689, -49.9085>, <11.774, 187.1636, -49.9694>, 0.2 }
			cylinder { <11.774, 187.1636, -49.9694>, <11.9576, 187.3021, -50.02234>, 0.2 }
			cylinder { <11.9576, 187.3021, -50.02234>, <12.1818, 187.3657, -50.06>, 0.2 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <12.1818, 187.3657, -50.06>, <16.1752, 189.1985, -49.5971>, <17.5061, 189.2405, -49.5252> }
			triangle { <12.1818, 187.3657, -50.06>, <14.9279, 188.9211, -49.5686>, <16.1752, 189.1985, -49.5971> }
			triangle { <12.1818, 187.3657, -50.06>, <13.6629, 188.6799, -49.5847>, <14.9279, 188.9211, -49.5686> }
			triangle { <12.1818, 187.3657, -50.06>, <12.8432, 188.165, -49.6757>, <13.6629, 188.6799, -49.5847> }
			triangle { <12.1818, 187.3657, -50.06>, <17.5061, 189.2405, -49.5252>, <17.8308, 188.062, -49.9607> }
			triangle { <17.5061, 189.2405, -49.5252>, <19.2013, 188.3434, -48.4946>, <17.8308, 188.062, -49.9607> }
			triangle { <17.8308, 188.062, -49.9607>, <19.2013, 188.3434, -48.4946>, <19.7495, 188.0931, -48.6725> }
			triangle { <17.8308, 188.062, -49.9607>, <19.7495, 188.0931, -48.6725>, <20.7785, 186.0061, -47.2057> }
			triangle { <17.7745, 187.394, -51.04718>, <16.4561, 187.2614, -51.1973>, <12.1818, 187.3657, -50.06> }
			triangle { <16.4561, 187.2614, -51.1973>, <15.143, 187.1831, -51.2245>, <12.1818, 187.3657, -50.06> }
			triangle { <15.143, 187.1831, -51.2245>, <13.901, 186.96, -51.07304>, <12.1818, 187.3657, -50.06> }
			triangle { <13.901, 186.96, -51.07304>, <13.00623, 186.9882, -50.6939>, <12.1818, 187.3657, -50.06> }
			triangle { <17.8308, 188.062, -49.9607>, <17.7745, 187.394, -51.04718>, <12.1818, 187.3657, -50.06> }
			triangle { <17.8308, 188.062, -49.9607>, <19.4144, 186.8046, -49.8263>, <17.7745, 187.394, -51.04718> }
			triangle { <19.9306, 186.9092, -49.2173>, <19.4144, 186.8046, -49.8263>, <17.8308, 188.062, -49.9607> }
			triangle { <20.7785, 186.0061, -47.2057>, <19.9306, 186.9092, -49.2173>, <17.8308, 188.062, -49.9607> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <11.6553, 186.9689, -49.9085>, <12.728, 187.4841, -50.1424>, 0.08564 }
			cylinder { <12.728, 187.4841, -50.1424>, <13.8123, 186.9423, -50.1082>, 0.08564 }
			cylinder { <13.8123, 186.9423, -50.1082>, <14.03169, 185.7817, -49.8335>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // inflor. internode
			cylinder { <14.03169, 185.7817, -49.8335>, <14.1048, 185.3948, -49.742>, 0.08564 }
			cylinder { <14.1048, 185.3948, -49.742>, <14.1779, 185.0079, -49.6504>, 0.08564 }
			cylinder { <14.1779, 185.0079, -49.6504>, <14.251, 184.621, -49.5589>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <14.251, 184.621, -49.5589>, <14.4617, 183.8481, -49.451>, 0.08564 }
				cylinder { <14.4617, 183.8481, -49.451>, <14.7339, 183.0874, -49.42>, 0.08564 }
				cylinder { <14.7339, 183.0874, -49.42>, <15.06341, 182.3506, -49.4663>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <15.06341, 182.3506, -49.4663>, <16.698, 181.5598, -50.2952>, <15.3939, 181.0129, -50.8731> }
					triangle { <16.698, 181.5598, -50.2952>, <17.4234, 180.0171, -50.4799>, <15.3939, 181.0129, -50.8731> }
					triangle { <15.3939, 181.0129, -50.8731>, <17.4234, 180.0171, -50.4799>, <15.8919, 179.3683, -51.05232> }
					triangle { <15.8919, 179.3683, -51.05232>, <17.4234, 180.0171, -50.4799>, <16.9412, 178.3366, -49.7913> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <15.06341, 182.3506, -49.4663>, <16.6516, 181.437, -48.6741>, <16.7129, 181.5601, -50.1956> }
					triangle { <16.6516, 181.437, -48.6741>, <17.4338, 179.9142, -48.7687>, <16.7129, 181.5601, -50.1956> }
					triangle { <16.7129, 181.5601, -50.1956>, <17.4338, 179.9142, -48.7687>, <17.4135, 180.0155, -50.5246> }
					triangle { <17.4135, 180.0155, -50.5246>, <17.4338, 179.9142, -48.7687>, <16.9576, 178.3364, -49.6712> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <15.06341, 182.3506, -49.4663>, <15.2275, 180.7738, -48.2533>, <16.5701, 181.3978, -48.6299> }
					triangle { <15.2275, 180.7738, -48.2533>, <15.9506, 179.2192, -48.2626>, <16.5701, 181.3978, -48.6299> }
					triangle { <16.5701, 181.3978, -48.6299>, <15.9506, 179.2192, -48.2626>, <17.4693, 179.9315, -48.7919> }
					triangle { <17.4693, 179.9315, -48.7919>, <15.9506, 179.2192, -48.2626>, <16.8588, 178.289, -49.6194> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <15.06341, 182.3506, -49.4663>, <14.3805, 180.4804, -49.6104>, <15.1615, 180.7488, -48.3251> }
					triangle { <14.3805, 180.4804, -49.6104>, <15.00967, 178.8861, -49.6564>, <15.1615, 180.7488, -48.3251> }
					triangle { <15.1615, 180.7488, -48.3251>, <15.00967, 178.8861, -49.6564>, <15.9828, 179.2317, -48.2325> }
					triangle { <15.9828, 179.2317, -48.2325>, <15.00967, 178.8861, -49.6564>, <16.7804, 178.2594, -49.707> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <15.06341, 182.3506, -49.4663>, <15.303, 180.9735, -50.8914>, <14.4236, 180.5074, -49.7324> }
					triangle { <15.303, 180.9735, -50.8914>, <15.9336, 179.3867, -51.04749>, <14.4236, 180.5074, -49.7324> }
					triangle { <14.4236, 180.5074, -49.7324>, <15.9336, 179.3867, -51.04749>, <14.9931, 178.8783, -49.6506> }
					triangle { <14.9931, 178.8783, -49.6506>, <15.9336, 179.3867, -51.04749>, <16.8321, 178.2893, -49.8149> }
					texture{Wflower_Texture8}}
				}
			}
		union { // inflor. internode
			cylinder { <14.251, 184.621, -49.5589>, <14.3241, 184.2342, -49.4673>, 0.08564 }
			cylinder { <14.3241, 184.2342, -49.4673>, <14.3972, 183.8473, -49.3757>, 0.08564 }
			cylinder { <14.3972, 183.8473, -49.3757>, <14.4703, 183.4604, -49.2842>, 0.08564 }
			texture{Wflower_Texture6}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <14.4703, 183.4604, -49.2842>, <14.615, 182.7152, -49.00617>, 0.08564 }
				cylinder { <14.615, 182.7152, -49.00617>, <14.756, 182.0098, -48.6373>, 0.08564 }
				cylinder { <14.756, 182.0098, -48.6373>, <14.8913, 181.3547, -48.1833>, 0.08564 }
				texture{Wflower_Texture7}}
			union { // fruit
				mesh { // fruit section
					triangle { <14.8913, 181.3547, -48.1833>, <14.6645, 180.9535, -46.6681>, <15.8309, 180.9662, -46.9971> }
					triangle { <14.6645, 180.9535, -46.6681>, <14.9095, 179.8958, -45.8484>, <15.8309, 180.9662, -46.9971> }
					triangle { <15.8309, 180.9662, -46.9971>, <14.9095, 179.8958, -45.8484>, <16.2336, 179.8642, -46.2884> }
					triangle { <16.2336, 179.8642, -46.2884>, <14.9095, 179.8958, -45.8484>, <15.4636, 178.542, -46.1364> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <14.8913, 181.3547, -48.1833>, <13.9989, 180.2343, -47.5076>, <14.6111, 180.9126, -46.7112> }
					triangle { <13.9989, 180.2343, -47.5076>, <14.1651, 179.1475, -46.7063>, <14.6111, 180.9126, -46.7112> }
					triangle { <14.6111, 180.9126, -46.7112>, <14.1651, 179.1475, -46.7063>, <14.9357, 179.9135, -45.8306> }
					triangle { <14.9357, 179.9135, -45.8306>, <14.1651, 179.1475, -46.7063>, <15.4003, 178.4924, -46.1891> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <14.8913, 181.3547, -48.1833>, <14.8195, 179.787, -48.3973>, <14.0372, 180.1998, -47.5686> }
					triangle { <14.8195, 179.787, -48.3973>, <14.9906, 178.6521, -47.6671>, <14.0372, 180.1998, -47.5686> }
					triangle { <14.0372, 180.1998, -47.5686>, <14.9906, 178.6521, -47.6671>, <14.1501, 179.1642, -46.6777> }
					triangle { <14.1501, 179.1642, -46.6777>, <14.9906, 178.6521, -47.6671>, <15.4476, 178.4515, -46.2623> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <14.8913, 181.3547, -48.1833>, <16.00004, 180.2257, -48.1159>, <14.8969, 179.8064, -48.3924> }
					triangle { <16.00004, 180.2257, -48.1159>, <16.253, 179.0895, -47.4119>, <14.8969, 179.8064, -48.3924> }
					triangle { <14.8969, 179.8064, -48.3924>, <16.253, 179.0895, -47.4119>, <14.955, 178.6448, -47.667> }
					triangle { <14.955, 178.6448, -47.667>, <16.253, 179.0895, -47.4119>, <15.5404, 178.4754, -46.2554> }
					texture{Wflower_Texture8}}
				mesh { // fruit section
					triangle { <14.8913, 181.3547, -48.1833>, <15.9027, 180.9575, -47.03113>, <16.02229, 180.2872, -48.0339> }
					triangle { <15.9027, 180.9575, -47.03113>, <16.2021, 179.8698, -46.271>, <16.02229, 180.2872, -48.0339> }
					triangle { <16.02229, 180.2872, -48.0339>, <16.2021, 179.8698, -46.271>, <16.2621, 179.0839, -47.4227> }
					triangle { <16.2621, 179.0839, -47.4227>, <16.2021, 179.8698, -46.271>, <15.5505, 178.5322, -46.1764> }
					texture{Wflower_Texture8}}
				}
			}
		}
} // end Solomon_s_seal

#declare Pink_daisy = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.09608, 4.4986, 0.05443>, 0.25 }
		cylinder { <-0.09608, 4.4986, 0.05443>, <-0.2882, 8.9932, 0.1632>, 0.25 }
		cylinder { <-0.2882, 8.9932, 0.1632>, <-0.5762, 13.481, 0.3264>, 0.25 }
		texture{Grass_Texture2}}
	union { // internode
		cylinder { <-0.5762, 13.481, 0.3264>, <-0.541, 17.9747, 0.562>, 0.25 }
		cylinder { <-0.541, 17.9747, 0.562>, <-0.1829, 22.4499, 0.8687>, 0.25 }
		cylinder { <-0.1829, 22.4499, 0.8687>, <0.4963, 26.8824, 1.2449>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.4963, 26.8824, 1.2449>, <2.2116, 29.1905, 1.7446>, 0.4378 }
			cylinder { <2.2116, 29.1905, 1.7446>, <4.7967, 30.3865, 2.3821>, 0.4378 }
			cylinder { <4.7967, 30.3865, 2.3821>, <7.6409, 30.1881, 3.006741>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <7.6409, 30.1881, 3.006741>, <11.4813, 30.6674, 1.3839>, <11.3211, 29.9849, 3.8604> }
			triangle { <11.3211, 29.9849, 3.8604>, <11.4813, 30.6674, 1.3839>, <13.7796, 30.00402, 1.8371> }
			triangle { <11.3211, 29.9849, 3.8604>, <13.7796, 30.00402, 1.8371>, <14.7996, 29.1528, 4.1235> }
			triangle { <14.7996, 29.1528, 4.1235>, <13.7796, 30.00402, 1.8371>, <16.3761, 28.8249, 2.4054> }
			triangle { <14.7996, 29.1528, 4.1235>, <16.3761, 28.8249, 2.4054>, <17.2242, 28.2252, 3.9177> }
			triangle { <17.2242, 28.2252, 3.9177>, <16.3761, 28.8249, 2.4054>, <19.7501, 26.8164, 3.4254> }
			triangle { <15.6571, 27.06006, 4.4642>, <17.2242, 28.2252, 3.9177>, <19.7501, 26.8164, 3.4254> }
			triangle { <15.6571, 27.06006, 4.4642>, <14.7996, 29.1528, 4.1235>, <17.2242, 28.2252, 3.9177> }
			triangle { <15.6571, 27.06006, 4.4642>, <13.00595, 27.5786, 4.9172>, <14.7996, 29.1528, 4.1235> }
			triangle { <14.7996, 29.1528, 4.1235>, <13.00595, 27.5786, 4.9172>, <11.3211, 29.9849, 3.8604> }
			triangle { <11.3211, 29.9849, 3.8604>, <13.00595, 27.5786, 4.9172>, <10.4904, 28.00958, 5.05164> }
			triangle { <11.3211, 29.9849, 3.8604>, <10.4904, 28.00958, 5.05164>, <7.6409, 30.1881, 3.006741> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <0.4963, 26.8824, 1.2449>, <0.9215, 31.3622, 1.263>, 0.25 }
		cylinder { <0.9215, 31.3622, 1.263>, <1.08874, 35.8462, 0.9227>, 0.25 }
		cylinder { <1.08874, 35.8462, 0.9227>, <0.9962, 40.2912, 0.2274>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.9962, 40.2912, 0.2274>, <0.1345, 42.6455, -1.2673>, 0.4378 }
			cylinder { <0.1345, 42.6455, -1.2673>, <-1.3252, 43.9148, -3.4529>, 0.4378 }
			cylinder { <-1.3252, 43.9148, -3.4529>, <-3.03845, 43.7996, -5.8132>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-3.03845, 43.7996, -5.8132>, <-6.9643, 44.4358, -7.1527>, <-5.2229, 43.7032, -8.9007> }
			triangle { <-5.2229, 43.7032, -8.9007>, <-6.9643, 44.4358, -7.1527>, <-8.4015, 43.8409, -9.02585> }
			triangle { <-5.2229, 43.7032, -8.9007>, <-8.4015, 43.8409, -9.02585>, <-7.673, 42.9824, -11.4185> }
			triangle { <-7.673, 42.9824, -11.4185>, <-8.4015, 43.8409, -9.02585>, <-10.00372, 42.7386, -11.1875> }
			triangle { <-7.673, 42.9824, -11.4185>, <-10.00372, 42.7386, -11.1875>, <-9.6525, 42.1397, -12.8858> }
			triangle { <-9.6525, 42.1397, -12.8858>, <-10.00372, 42.7386, -11.1875>, <-11.9159, 40.8248, -14.2107> }
			triangle { <-8.1632, 40.9134, -12.261>, <-9.6525, 42.1397, -12.8858>, <-11.9159, 40.8248, -14.2107> }
			triangle { <-8.1632, 40.9134, -12.261>, <-7.673, 42.9824, -11.4185>, <-9.6525, 42.1397, -12.8858> }
			triangle { <-8.1632, 40.9134, -12.261>, <-5.8655, 41.3353, -10.8309>, <-7.673, 42.9824, -11.4185> }
			triangle { <-7.673, 42.9824, -11.4185>, <-5.8655, 41.3353, -10.8309>, <-5.2229, 43.7032, -8.9007> }
			triangle { <-5.2229, 43.7032, -8.9007>, <-5.8655, 41.3353, -10.8309>, <-3.884, 41.6799, -9.254> }
			triangle { <-5.2229, 43.7032, -8.9007>, <-3.884, 41.6799, -9.254>, <-3.03845, 43.7996, -5.8132> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <0.9962, 40.2912, 0.2274>, <0.8566, 44.7816, -0.03108>, 0.25 }
		cylinder { <0.8566, 44.7816, -0.03108>, <0.6713, 49.2742, 0.1495>, 0.25 }
		cylinder { <0.6713, 49.2742, 0.1495>, <0.4422, 53.7256, 0.7677>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.4422, 53.7256, 0.7677>, <0.1776, 56.07693, 2.4768>, 0.4378 }
			cylinder { <0.1776, 56.07693, 2.4768>, <-0.1403, 57.3368, 5.09038>, 0.4378 }
			cylinder { <-0.1403, 57.3368, 5.09038>, <-0.4367, 57.208, 7.9912>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-0.4367, 57.208, 7.9912>, <1.6238, 57.7378, 11.6085>, <-0.8646, 57.0956, 11.7486> }
			triangle { <-0.8646, 57.0956, 11.7486>, <1.6238, 57.7378, 11.6085>, <1.4279, 57.1298, 13.9579> }
			triangle { <-0.8646, 57.0956, 11.7486>, <1.4279, 57.1298, 13.9579>, <-0.7385, 56.3399, 15.2521> }
			triangle { <-0.7385, 56.3399, 15.2521>, <1.4279, 57.1298, 13.9579>, <1.1444, 56.01468, 16.6283> }
			triangle { <-0.7385, 56.3399, 15.2521>, <1.1444, 56.01468, 16.6283>, <-0.2692, 55.4589, 17.6574> }
			triangle { <-0.2692, 55.4589, 17.6574>, <1.1444, 56.01468, 16.6283>, <0.489, 54.0941, 20.1412> }
			triangle { <-1.009719, 54.2715, 16.1898>, <-0.2692, 55.4589, 17.6574>, <0.489, 54.0941, 20.1412> }
			triangle { <-1.009719, 54.2715, 16.1898>, <-0.7385, 56.3399, 15.2521>, <-0.2692, 55.4589, 17.6574> }
			triangle { <-1.009719, 54.2715, 16.1898>, <-1.7566, 54.7433, 13.597>, <-0.7385, 56.3399, 15.2521> }
			triangle { <-0.7385, 56.3399, 15.2521>, <-1.7566, 54.7433, 13.597>, <-0.8646, 57.0956, 11.7486> }
			triangle { <-0.8646, 57.0956, 11.7486>, <-1.7566, 54.7433, 13.597>, <-2.1728, 55.1246, 11.1045> }
			triangle { <-0.8646, 57.0956, 11.7486>, <-2.1728, 55.1246, 11.1045>, <-0.4367, 57.208, 7.9912> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <0.4422, 53.7256, 0.7677>, <0.3766, 58.2004, 1.2393>, 0.25 }
		cylinder { <0.3766, 58.2004, 1.2393>, <0.4747, 62.6876, 1.5631>, 0.25 }
		cylinder { <0.4747, 62.6876, 1.5631>, <0.7363, 67.1766, 1.7384>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <0.7363, 67.1766, 1.7384>, <1.9025, 69.7214, 0.9118>, 0.4378 }
			cylinder { <1.9025, 69.7214, 0.9118>, <3.7899, 71.2983, -0.6598>, 0.4378 }
			cylinder { <3.7899, 71.2983, -0.6598>, <5.9527, 71.5351, -2.6054>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <5.9527, 71.5351, -2.6054>, <6.797, 72.5597, -6.5865>, <8.783, 71.895, -5.09024> }
			triangle { <8.783, 71.895, -5.09024>, <6.797, 72.5597, -6.5865>, <8.5523, 72.2529, -8.2456> }
			triangle { <8.783, 71.895, -5.09024>, <8.5523, 72.2529, -8.2456>, <11.0793, 71.5948, -7.8285> }
			triangle { <11.0793, 71.5948, -7.8285>, <8.5523, 72.2529, -8.2456>, <10.623, 71.4824, -10.136> }
			triangle { <11.0793, 71.5948, -7.8285>, <10.623, 71.4824, -10.136>, <12.3978, 71.03667, -10.00376> }
			triangle { <12.3978, 71.03667, -10.00376>, <10.623, 71.4824, -10.136>, <13.5892, 70.0139, -12.482> }
			triangle { <12.05447, 69.6583, -8.5565>, <12.3978, 71.03667, -10.00376>, <13.5892, 70.0139, -12.482> }
			triangle { <12.05447, 69.6583, -8.5565>, <11.0793, 71.5948, -7.8285>, <12.3978, 71.03667, -10.00376> }
			triangle { <12.05447, 69.6583, -8.5565>, <10.8463, 69.7817, -6.1012>, <11.0793, 71.5948, -7.8285> }
			triangle { <11.0793, 71.5948, -7.8285>, <10.8463, 69.7817, -6.1012>, <8.783, 71.895, -5.09024> }
			triangle { <8.783, 71.895, -5.09024>, <10.8463, 69.7817, -6.1012>, <9.4662, 69.8343, -3.9509> }
			triangle { <8.783, 71.895, -5.09024>, <9.4662, 69.8343, -3.9509>, <5.9527, 71.5351, -2.6054> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <0.7363, 67.1766, 1.7384>, <0.5562, 71.6695, 1.9144>, 0.25 }
		cylinder { <0.5562, 71.6695, 1.9144>, <-0.06361, 76.1232, 2.08939>, 0.25 }
		cylinder { <-0.06361, 76.1232, 2.08939>, <-1.1173, 80.4947, 2.2617>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.1173, 80.4947, 2.2617>, <-3.05783, 82.6733, 2.3493>, 0.4378 }
			cylinder { <-3.05783, 82.6733, 2.3493>, <-5.7969, 83.6806, 2.3921>, 0.4378 }
			cylinder { <-5.7969, 83.6806, 2.3921>, <-8.6879, 83.2787, 2.3799>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-8.6879, 83.2787, 2.3799>, <-12.09647, 83.3036, 4.8279>, <-12.4423, 82.8151, 2.3246> }
			triangle { <-12.4423, 82.8151, 2.3246>, <-12.09647, 83.3036, 4.8279>, <-14.3859, 82.4753, 4.8237> }
			triangle { <-12.4423, 82.8151, 2.3246>, <-14.3859, 82.4753, 4.8237>, <-15.8257, 81.7024, 2.7447> }
			triangle { <-15.8257, 81.7024, 2.7447>, <-14.3859, 82.4753, 4.8237>, <-16.9549, 81.1167, 4.7263> }
			triangle { <-15.8257, 81.7024, 2.7447>, <-16.9549, 81.1167, 4.7263>, <-18.07338, 80.5537, 3.3852> }
			triangle { <-18.07338, 80.5537, 3.3852>, <-16.9549, 81.1167, 4.7263>, <-20.3223, 78.8979, 4.2837> }
			triangle { <-16.589, 79.572, 2.4131>, <-18.07338, 80.5537, 3.3852>, <-20.3223, 78.8979, 4.2837> }
			triangle { <-16.589, 79.572, 2.4131>, <-15.8257, 81.7024, 2.7447>, <-18.07338, 80.5537, 3.3852> }
			triangle { <-16.589, 79.572, 2.4131>, <-14.1472, 80.3516, 1.4472>, <-15.8257, 81.7024, 2.7447> }
			triangle { <-15.8257, 81.7024, 2.7447>, <-14.1472, 80.3516, 1.4472>, <-12.4423, 82.8151, 2.3246> }
			triangle { <-12.4423, 82.8151, 2.3246>, <-14.1472, 80.3516, 1.4472>, <-11.7606, 81.00957, 0.8126> }
			triangle { <-12.4423, 82.8151, 2.3246>, <-11.7606, 81.00957, 0.8126>, <-8.6879, 83.2787, 2.3799> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <-1.1173, 80.4947, 2.2617>, <-2.0912, 84.8811, 2.5087>, 0.25 }
		cylinder { <-2.0912, 84.8811, 2.5087>, <-2.9844, 89.2798, 2.8302>, 0.25 }
		cylinder { <-2.9844, 89.2798, 2.8302>, <-3.7966, 93.6882, 3.2262>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-3.7966, 93.6882, 3.2262>, <-3.2479, 96.3135, 4.3777>, 0.4378 }
			cylinder { <-3.2479, 96.3135, 4.3777>, <-1.7533, 98.08485, 6.1519>, 0.4378 }
			cylinder { <-1.7533, 98.08485, 6.1519>, <0.3341, 98.5838, 8.1299>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <0.3341, 98.5838, 8.1299>, <4.182, 100.1832, 8.6271>, <2.9982, 99.2772, 10.7253> }
			triangle { <2.9982, 99.2772, 10.7253>, <4.182, 100.1832, 8.6271>, <6.02905, 100.107, 10.2116> }
			triangle { <2.9982, 99.2772, 10.7253>, <6.02905, 100.107, 10.2116>, <5.9584, 99.3626, 12.748> }
			triangle { <5.9584, 99.3626, 12.748>, <6.02905, 100.107, 10.2116>, <8.2025, 99.603, 12.07631> }
			triangle { <5.9584, 99.3626, 12.748>, <8.2025, 99.603, 12.07631>, <8.3086, 99.1205, 13.8432> }
			triangle { <8.3086, 99.1205, 13.8432>, <8.2025, 99.603, 12.07631>, <11.01381, 98.4662, 14.7712> }
			triangle { <7.05529, 97.5451, 13.5994>, <8.3086, 99.1205, 13.8432>, <11.01381, 98.4662, 14.7712> }
			triangle { <7.05529, 97.5451, 13.5994>, <5.9584, 99.3626, 12.748>, <8.3086, 99.1205, 13.8432> }
			triangle { <7.05529, 97.5451, 13.5994>, <4.5043, 97.314, 12.6287>, <5.9584, 99.3626, 12.748> }
			triangle { <5.9584, 99.3626, 12.748>, <4.5043, 97.314, 12.6287>, <2.9982, 99.2772, 10.7253> }
			triangle { <2.9982, 99.2772, 10.7253>, <4.5043, 97.314, 12.6287>, <2.2475, 97.06067, 11.4565> }
			triangle { <2.9982, 99.2772, 10.7253>, <2.2475, 97.06067, 11.4565>, <0.3341, 98.5838, 8.1299> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <-3.7966, 93.6882, 3.2262>, <-4.6316, 98.1065, 3.4026>, 0.25 }
		cylinder { <-4.6316, 98.1065, 3.4026>, <-5.4875, 102.5242, 3.3592>, 0.25 }
		cylinder { <-5.4875, 102.5242, 3.3592>, <-6.3621, 106.9305, 3.09608>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-6.3621, 106.9305, 3.09608>, <-6.9727, 109.3475, 1.5779>, 0.4378 }
			cylinder { <-6.9727, 109.3475, 1.5779>, <-7.4824, 110.7526, -0.929>, 0.4378 }
			cylinder { <-7.4824, 110.7526, -0.929>, <-7.771, 110.8141, -3.8328>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-7.771, 110.8141, -3.8328>, <-10.5991, 111.0035, -6.9275>, <-8.1145, 110.9568, -7.5979> }
			triangle { <-8.1145, 110.9568, -7.5979>, <-10.5991, 111.0035, -6.9275>, <-10.7657, 110.5535, -9.3145> }
			triangle { <-8.1145, 110.9568, -7.5979>, <-10.7657, 110.5535, -9.3145>, <-8.7947, 110.3364, -11.06403> }
			triangle { <-8.7947, 110.3364, -11.06403>, <-10.7657, 110.5535, -9.3145>, <-10.8049, 109.6435, -12.07596> }
			triangle { <-8.7947, 110.3364, -11.06403>, <-10.8049, 109.6435, -12.07596>, <-9.5482, 109.4703, -13.4014> }
			triangle { <-9.5482, 109.4703, -13.4014>, <-10.8049, 109.6435, -12.07596>, <-10.4887, 108.0704, -15.802> }
			triangle { <-8.281, 108.4259, -12.2116>, <-9.5482, 109.4703, -13.4014>, <-10.4887, 108.0704, -15.802> }
			triangle { <-8.281, 108.4259, -12.2116>, <-8.7947, 110.3364, -11.06403>, <-9.5482, 109.4703, -13.4014> }
			triangle { <-8.281, 108.4259, -12.2116>, <-7.1351, 108.9503, -9.7796>, <-8.7947, 110.3364, -11.06403> }
			triangle { <-8.7947, 110.3364, -11.06403>, <-7.1351, 108.9503, -9.7796>, <-8.1145, 110.9568, -7.5979> }
			triangle { <-8.1145, 110.9568, -7.5979>, <-7.1351, 108.9503, -9.7796>, <-6.3058, 109.3148, -7.3899> }
			triangle { <-8.1145, 110.9568, -7.5979>, <-6.3058, 109.3148, -7.3899>, <-7.771, 110.8141, -3.8328> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <-6.3621, 106.9305, 3.09608>, <-7.432, 111.3015, 3.09811>, 0.25 }
		cylinder { <-7.432, 111.3015, 3.09811>, <-8.6914, 115.6134, 3.3653>, 0.25 }
		cylinder { <-8.6914, 115.6134, 3.3653>, <-10.1335, 119.8429, 3.8963>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-10.1335, 119.8429, 3.8963>, <-11.6982, 121.8679, 5.2875>, 0.4369 }
			cylinder { <-11.6982, 121.8679, 5.2875>, <-13.5248, 122.702, 7.3976>, 0.4369 }
			cylinder { <-13.5248, 122.702, 7.3976>, <-15.1817, 122.1481, 9.7283>, 0.4369 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-15.1817, 122.1481, 9.7283>, <-15.3512, 122.54, 13.8945>, <-17.3765, 121.4766, 12.7262> }
			triangle { <-17.3765, 121.4766, 12.7262>, <-15.3512, 122.54, 13.8945>, <-16.5497, 121.608, 15.7914> }
			triangle { <-17.3765, 121.4766, 12.7262>, <-16.5497, 121.608, 15.7914>, <-18.8441, 120.3043, 15.7726> }
			triangle { <-18.8441, 120.3043, 15.7726>, <-16.5497, 121.608, 15.7914>, <-17.8734, 120.1247, 17.9053> }
			triangle { <-18.8441, 120.3043, 15.7726>, <-17.8734, 120.1247, 17.9053>, <-19.4533, 119.2107, 18.05015> }
			triangle { <-19.4533, 119.2107, 18.05015>, <-17.8734, 120.1247, 17.9053>, <-19.7563, 117.6839, 20.5298> }
			triangle { <-19.0988, 118.1197, 16.383>, <-19.4533, 119.2107, 18.05015>, <-19.7563, 117.6839, 20.5298> }
			triangle { <-19.0988, 118.1197, 16.383>, <-18.8441, 120.3043, 15.7726>, <-19.4533, 119.2107, 18.05015> }
			triangle { <-19.0988, 118.1197, 16.383>, <-18.5436, 118.792, 13.7922>, <-18.8441, 120.3043, 15.7726> }
			triangle { <-18.8441, 120.3043, 15.7726>, <-18.5436, 118.792, 13.7922>, <-17.3765, 121.4766, 12.7262> }
			triangle { <-17.3765, 121.4766, 12.7262>, <-18.5436, 118.792, 13.7922>, <-17.7409, 119.4186, 11.4539> }
			triangle { <-17.3765, 121.4766, 12.7262>, <-17.7409, 119.4186, 11.4539>, <-15.1817, 122.1481, 9.7283> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <-10.1335, 119.8429, 3.8963>, <-11.4732, 124.1084, 4.4067>, 0.25 }
		cylinder { <-11.4732, 124.1084, 4.4067>, <-12.7098, 128.4074, 4.8961>, 0.25 }
		cylinder { <-12.7098, 128.4074, 4.8961>, <-13.8425, 132.7372, 5.3643>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-13.8425, 132.7372, 5.3643>, <-13.1918, 135.5826, 5.3661>, 0.4378 }
			cylinder { <-13.1918, 135.5826, 5.3661>, <-11.3094, 137.7928, 5.06545>, 0.4378 }
			cylinder { <-11.3094, 137.7928, 5.06545>, <-8.6397, 138.8461, 4.5334>, 0.4378 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-8.6397, 138.8461, 4.5334>, <-6.2888, 140.7292, 1.6113>, <-5.1903, 140.2614, 3.8914> }
			triangle { <-5.1903, 140.2614, 3.8914>, <-6.2888, 140.7292, 1.6113>, <-3.9427, 141.12, 1.09069> }
			triangle { <-5.1903, 140.2614, 3.8914>, <-3.9427, 141.12, 1.09069>, <-1.8727, 140.9716, 2.7294> }
			triangle { <-1.8727, 140.9716, 2.7294>, <-3.9427, 141.12, 1.09069>, <-1.09275, 141.1774, 0.517> }
			triangle { <-1.8727, 140.9716, 2.7294>, <-1.09275, 141.1774, 0.517>, <0.4349, 141.1177, 1.5314> }
			triangle { <0.4349, 141.1177, 1.5314>, <-1.09275, 141.1774, 0.517>, <2.9159, 140.8448, -0.01034> }
			triangle { <-0.1667, 139.4608, 2.5338>, <0.4349, 141.1177, 1.5314>, <2.9159, 140.8448, -0.01034> }
			triangle { <-0.1667, 139.4608, 2.5338>, <-1.8727, 140.9716, 2.7294>, <0.4349, 141.1177, 1.5314> }
			triangle { <-0.1667, 139.4608, 2.5338>, <-2.3973, 138.872, 4.01056>, <-1.8727, 140.9716, 2.7294> }
			triangle { <-1.8727, 140.9716, 2.7294>, <-2.3973, 138.872, 4.01056>, <-5.1903, 140.2614, 3.8914> }
			triangle { <-5.1903, 140.2614, 3.8914>, <-2.3973, 138.872, 4.01056>, <-4.6014, 138.232, 5.1347> }
			triangle { <-5.1903, 140.2614, 3.8914>, <-4.6014, 138.232, 5.1347>, <-8.6397, 138.8461, 4.5334> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <-13.8425, 132.7372, 5.3643>, <-14.9752, 137.0671, 5.8326>, 0.25 }
		cylinder { <-14.9752, 137.0671, 5.8326>, <-16.1079, 141.397, 6.3008>, 0.25 }
		cylinder { <-16.1079, 141.397, 6.3008>, <-17.2406, 145.7268, 6.769>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-17.2406, 145.7268, 6.769>, <-18.9267, 147.8248, 6.362>, 0.4083 }
			cylinder { <-18.9267, 147.8248, 6.362>, <-21.2155, 148.906, 5.3609>, 0.4083 }
			cylinder { <-21.2155, 148.906, 5.3609>, <-23.5664, 148.7152, 4.002082>, 0.4083 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-23.5664, 148.7152, 4.002082>, <-27.449, 148.5377, 4.4624>, <-26.6035, 148.5275, 2.2159> }
			triangle { <-26.6035, 148.5275, 2.2159>, <-27.449, 148.5377, 4.4624>, <-29.2996, 147.9187, 3.3014> }
			triangle { <-26.6035, 148.5275, 2.2159>, <-29.2996, 147.9187, 3.3014>, <-29.5312, 147.6438, 0.8616> }
			triangle { <-29.5312, 147.6438, 0.8616>, <-29.2996, 147.9187, 3.3014>, <-31.3234, 146.8466, 1.8493> }
			triangle { <-29.5312, 147.6438, 0.8616>, <-31.3234, 146.8466, 1.8493>, <-31.6264, 146.6218, 0.1803> }
			triangle { <-31.6264, 146.6218, 0.1803>, <-31.3234, 146.8466, 1.8493>, <-33.824, 145.0925, -0.3833> }
			triangle { <-29.9515, 145.7945, -0.1146>, <-31.6264, 146.6218, 0.1803>, <-33.824, 145.0925, -0.3833> }
			triangle { <-29.9515, 145.7945, -0.1146>, <-29.5312, 147.6438, 0.8616>, <-31.6264, 146.6218, 0.1803> }
			triangle { <-29.9515, 145.7945, -0.1146>, <-27.5426, 146.5209, 0.327>, <-29.5312, 147.6438, 0.8616> }
			triangle { <-29.5312, 147.6438, 0.8616>, <-27.5426, 146.5209, 0.327>, <-26.6035, 148.5275, 2.2159> }
			triangle { <-26.6035, 148.5275, 2.2159>, <-27.5426, 146.5209, 0.327>, <-25.3232, 147.0842, 0.9887> }
			triangle { <-26.6035, 148.5275, 2.2159>, <-25.3232, 147.0842, 0.9887>, <-23.5664, 148.7152, 4.002082> }
			texture{Grass_Texture1}}
		}
	union { // internode
		cylinder { <-17.2406, 145.7268, 6.769>, <-18.3393, 150.0528, 7.3422>, 0.25 }
		cylinder { <-18.3393, 150.0528, 7.3422>, <-19.4032, 154.3724, 8.02014>, 0.25 }
		cylinder { <-19.4032, 154.3724, 8.02014>, <-20.4317, 158.6829, 8.8022>, 0.25 }
		texture{Grass_Texture2}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-20.4317, 158.6829, 8.8022>, <-20.5346, 160.3556, 10.04994>, 0.3133 }
			cylinder { <-20.5346, 160.3556, 10.04994>, <-20.2385, 161.3046, 11.8875>, 0.3133 }
			cylinder { <-20.2385, 161.3046, 11.8875>, <-19.6135, 161.3058, 13.8811>, 0.3133 }
			texture{Grass_Texture3}}
		mesh { // leaf
			triangle { <-19.6135, 161.3058, 13.8811>, <-17.3981, 162.1874, 15.7084>, <-18.8412, 161.338, 16.4767> }
			triangle { <-18.8412, 161.338, 16.4767>, <-17.3981, 162.1874, 15.7084>, <-16.7778, 161.8458, 17.3008> }
			triangle { <-18.8412, 161.338, 16.4767>, <-16.7778, 161.8458, 17.3008>, <-17.6746, 161.0023, 18.7386> }
			triangle { <-17.6746, 161.0023, 18.7386>, <-16.7778, 161.8458, 17.3008>, <-16.03947, 161.1526, 19.1192> }
			triangle { <-17.6746, 161.0023, 18.7386>, <-16.03947, 161.1526, 19.1192>, <-16.5673, 160.5831, 20.1784> }
			triangle { <-16.5673, 160.5831, 20.1784>, <-16.03947, 161.1526, 19.1192>, <-15.1713, 159.879, 21.5804> }
			triangle { <-17.2393, 159.5653, 19.3913>, <-16.5673, 160.5831, 20.1784>, <-15.1713, 159.879, 21.5804> }
			triangle { <-17.2393, 159.5653, 19.3913>, <-17.6746, 161.0023, 18.7386>, <-16.5673, 160.5831, 20.1784> }
			triangle { <-17.2393, 159.5653, 19.3913>, <-18.5056, 159.6454, 17.8964>, <-17.6746, 161.0023, 18.7386> }
			triangle { <-17.6746, 161.0023, 18.7386>, <-18.5056, 159.6454, 17.8964>, <-18.8412, 161.338, 16.4767> }
			triangle { <-18.8412, 161.338, 16.4767>, <-18.5056, 159.6454, 17.8964>, <-19.5177, 159.7219, 16.3745> }
			triangle { <-18.8412, 161.338, 16.4767>, <-19.5177, 159.7219, 16.3745>, <-19.6135, 161.3058, 13.8811> }
			texture{Grass_Texture1}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-20.4317, 158.6829, 8.8022>, <-20.5003, 158.9703, 8.8543>, 0.5 }
			cylinder { <-20.5003, 158.9703, 8.8543>, <-20.5688, 159.2576, 8.9065>, 0.5 }
			cylinder { <-20.5688, 159.2576, 8.9065>, <-20.6374, 159.545, 8.9586>, 0.5 }
			texture{Grass_Texture4}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-18.8517, 158.1566, 6.9879>, 0.5 }
				cylinder { <-18.8517, 158.1566, 6.9879>, <-17.06595, 156.7683, 5.01733>, 0.5 }
				cylinder { <-17.06595, 156.7683, 5.01733>, <-15.2802, 155.3799, 3.04667>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-15.2802, 155.3799, 3.04667>, <-13.3485, 154.5743, 1.03508>, <-13.9469, 153.8097, 0.9767> }
					triangle { <-13.3485, 154.5743, 1.03508>, <-12.5074, 153.3582, -1.8946>, <-13.9469, 153.8097, 0.9767> }
					triangle { <-13.3485, 154.5743, 1.03508>, <-12.7087, 154.0462, -1.02728>, <-12.5074, 153.3582, -1.8946> }
					triangle { <-12.5074, 153.3582, -1.8946>, <-13.2658, 153.3948, -1.2375>, <-13.9469, 153.8097, 0.9767> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-18.3714, 158.3435, 7.4025>, 0.5 }
				cylinder { <-18.3714, 158.3435, 7.4025>, <-16.1054, 157.1419, 5.8463>, 0.5 }
				cylinder { <-16.1054, 157.1419, 5.8463>, <-13.8394, 155.9404, 4.2902>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-13.8394, 155.9404, 4.2902>, <-11.4869, 155.3338, 2.7015>, <-11.9765, 154.5056, 2.5585> }
					triangle { <-11.4869, 155.3338, 2.7015>, <-9.9806, 154.1844, 0.02203>, <-11.9765, 154.5056, 2.5585> }
					triangle { <-11.4869, 155.3338, 2.7015>, <-10.4157, 154.8559, 0.8131>, <-9.9806, 154.1844, 0.02203> }
					triangle { <-9.9806, 154.1844, 0.02203>, <-10.8487, 154.1429, 0.5249>, <-11.9765, 154.5056, 2.5585> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-18.03642, 158.5589, 7.8351>, 0.5 }
				cylinder { <-18.03642, 158.5589, 7.8351>, <-15.4353, 157.5728, 6.7117>, 0.5 }
				cylinder { <-15.4353, 157.5728, 6.7117>, <-12.8343, 156.5866, 5.5882>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-12.8343, 156.5866, 5.5882>, <-10.2007, 156.2007, 4.4298>, <-10.5766, 155.3258, 4.2315> }
					triangle { <-10.2007, 156.2007, 4.4298>, <-8.1614, 155.1763, 2.07157>, <-10.5766, 155.3258, 4.2315> }
					triangle { <-10.2007, 156.2007, 4.4298>, <-8.7864, 155.8102, 2.7598>, <-8.1614, 155.1763, 2.07157> }
					triangle { <-8.1614, 155.1763, 2.07157>, <-9.09351, 155.0538, 2.4245>, <-10.5766, 155.3258, 4.2315> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-17.7794, 158.8461, 8.3726>, 0.5 }
				cylinder { <-17.7794, 158.8461, 8.3726>, <-14.9214, 158.1471, 7.7866>, 0.5 }
				cylinder { <-14.9214, 158.1471, 7.7866>, <-12.0635, 157.4481, 7.2006>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-12.0635, 157.4481, 7.2006>, <-9.2325, 157.3488, 6.5662>, <-9.4666, 156.4345, 6.3309> }
					triangle { <-9.2325, 157.3488, 6.5662>, <-6.6856, 156.5327, 4.6644>, <-9.4666, 156.4345, 6.3309> }
					triangle { <-9.2325, 157.3488, 6.5662>, <-7.4945, 157.1002, 5.2027>, <-6.6856, 156.5327, 4.6644> }
					triangle { <-6.6856, 156.5327, 4.6644>, <-7.6485, 156.3097, 4.8416>, <-9.4666, 156.4345, 6.3309> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-17.6674, 159.1303, 8.8751>, 0.5 }
				cylinder { <-17.6674, 159.1303, 8.8751>, <-14.6974, 158.7156, 8.7916>, 0.5 }
				cylinder { <-14.6974, 158.7156, 8.7916>, <-11.7273, 158.3009, 8.7081>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-11.7273, 158.3009, 8.7081>, <-8.834, 158.4794, 8.5551>, <-8.9352, 157.5434, 8.3108> }
					triangle { <-8.834, 158.4794, 8.5551>, <-5.9368, 157.9008, 7.1264>, <-8.9352, 157.5434, 8.3108> }
					triangle { <-8.834, 158.4794, 8.5551>, <-6.8759, 158.3905, 7.5065>, <-5.9368, 157.9008, 7.1264> }
					triangle { <-5.9368, 157.9008, 7.1264>, <-6.8895, 157.5842, 7.1478>, <-8.9352, 157.5434, 8.3108> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-17.6778, 159.4686, 9.4433>, 0.5 }
				cylinder { <-17.6778, 159.4686, 9.4433>, <-14.7182, 159.3922, 9.928>, 0.5 }
				cylinder { <-14.7182, 159.3922, 9.928>, <-11.7586, 159.3157, 10.4126>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-11.7586, 159.3157, 10.4126>, <-8.9254, 159.8191, 10.7949>, <-8.876, 158.8746, 10.5676> }
					triangle { <-8.9254, 159.8191, 10.7949>, <-5.7651, 159.5547, 9.9506>, <-8.876, 158.8746, 10.5676> }
					triangle { <-8.9254, 159.8191, 10.7949>, <-6.8068, 159.9395, 10.1326>, <-5.7651, 159.5547, 9.9506> }
					triangle { <-5.7651, 159.5547, 9.9506>, <-6.6645, 159.1325, 9.8049>, <-8.876, 158.8746, 10.5676> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-17.808, 159.7729, 9.9294>, 0.5 }
				cylinder { <-17.808, 159.7729, 9.9294>, <-14.9786, 160.0008, 10.9002>, 0.5 }
				cylinder { <-14.9786, 160.0008, 10.9002>, <-12.1491, 160.2287, 11.871>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-12.1491, 160.2287, 11.871>, <-9.4829, 161.0194, 12.7031>, <-9.3045, 160.082, 12.5145> }
					triangle { <-9.4829, 161.0194, 12.7031>, <-6.2152, 161.0644, 12.4026>, <-9.3045, 160.082, 12.5145> }
					triangle { <-9.4829, 161.0194, 12.7031>, <-7.305, 161.3445, 12.3981>, <-6.2152, 161.0644, 12.4026> }
					triangle { <-6.2152, 161.0644, 12.4026>, <-7.03203, 160.552, 12.122>, <-9.3045, 160.082, 12.5145> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-18.08404, 160.1042, 10.4308>, 0.5 }
				cylinder { <-18.08404, 160.1042, 10.4308>, <-15.5306, 160.6635, 11.903>, 0.5 }
				cylinder { <-15.5306, 160.6635, 11.903>, <-12.9772, 161.2227, 13.3752>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-12.9772, 161.2227, 13.3752>, <-10.6181, 162.3208, 14.6619>, <-10.3063, 161.4074, 14.5414> }
					triangle { <-10.6181, 162.3208, 14.6619>, <-7.3772, 162.7321, 14.9735>, <-10.3063, 161.4074, 14.5414> }
					triangle { <-10.6181, 162.3208, 14.6619>, <-8.4705, 162.8868, 14.7568>, <-7.3772, 162.7321, 14.9735> }
					triangle { <-7.3772, 162.7321, 14.9735>, <-8.06561, 162.127, 14.5632>, <-10.3063, 161.4074, 14.5414> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-18.4341, 160.3764, 10.8171>, 0.5 }
				cylinder { <-18.4341, 160.3764, 10.8171>, <-16.2307, 161.2078, 12.6756>, 0.5 }
				cylinder { <-16.2307, 161.2078, 12.6756>, <-14.02742, 162.0392, 14.5341>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-14.02742, 162.0392, 14.5341>, <-12.03604, 163.3849, 16.1621>, <-11.621, 162.5061, 16.1213> }
					triangle { <-12.03604, 163.3849, 16.1621>, <-8.9489, 164.1242, 16.9947>, <-11.621, 162.5061, 16.1213> }
					triangle { <-12.03604, 163.3849, 16.1621>, <-10.00021, 164.1654, 16.5955>, <-8.9489, 164.1242, 16.9947> }
					triangle { <-8.9489, 164.1242, 16.9947>, <-9.4965, 163.4479, 16.4937>, <-11.621, 162.5061, 16.1213> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-18.9283, 160.6439, 11.1657>, 0.5 }
				cylinder { <-18.9283, 160.6439, 11.1657>, <-17.2192, 161.7428, 13.3728>, 0.5 }
				cylinder { <-17.2192, 161.7428, 13.3728>, <-15.5101, 162.8417, 15.5799>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-15.5101, 162.8417, 15.5799>, <-14.02042, 164.4247, 17.5039>, <-13.5119, 163.5982, 17.5706> }
					triangle { <-14.02042, 164.4247, 17.5039>, <-11.2452, 165.5194, 18.8713>, <-13.5119, 163.5982, 17.5706> }
					triangle { <-14.02042, 164.4247, 17.5039>, <-12.2003, 165.4363, 18.2821>, <-11.2452, 165.5194, 18.8713> }
					triangle { <-11.2452, 165.5194, 18.8713>, <-11.6113, 164.7792, 18.3>, <-13.5119, 163.5982, 17.5706> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-19.4382, 160.8372, 11.386>, 0.5 }
				cylinder { <-19.4382, 160.8372, 11.386>, <-18.239, 162.1295, 13.8133>, 0.5 }
				cylinder { <-18.239, 162.1295, 13.8133>, <-17.0398, 163.4217, 16.2407>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-17.0398, 163.4217, 16.2407>, <-16.05535, 165.1699, 18.3385>, <-15.4873, 164.3997, 18.5125> }
					triangle { <-16.05535, 165.1699, 18.3385>, <-13.6689, 166.5551, 20.115>, <-15.4873, 164.3997, 18.5125> }
					triangle { <-16.05535, 165.1699, 18.3385>, <-14.4988, 166.369, 19.3783>, <-13.6689, 166.5551, 20.115> }
					triangle { <-13.6689, 166.5551, 20.115>, <-13.8602, 165.7749, 19.5126>, <-15.4873, 164.3997, 18.5125> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-20.0659, 160.9951, 11.5219>, 0.5 }
				cylinder { <-20.0659, 160.9951, 11.5219>, <-19.4943, 162.4451, 14.08532>, 0.5 }
				cylinder { <-19.4943, 162.4451, 14.08532>, <-18.9227, 163.8952, 16.6486>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-18.9227, 163.8952, 16.6486>, <-18.5483, 165.7698, 18.8331>, <-17.9429, 165.0711, 19.1355> }
					triangle { <-18.5483, 165.7698, 18.8331>, <-16.7054, 167.4387, 20.9752>, <-17.9429, 165.0711, 19.1355> }
					triangle { <-18.5483, 165.7698, 18.8331>, <-17.3561, 167.1505, 20.1036>, <-16.7054, 167.4387, 20.9752> }
					triangle { <-16.7054, 167.4387, 20.9752>, <-16.6934, 166.6343, 20.3742>, <-17.9429, 165.0711, 19.1355> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-20.6481, 161.0764, 11.5383>, 0.5 }
				cylinder { <-20.6481, 161.0764, 11.5383>, <-20.6588, 162.6077, 14.118>, 0.5 }
				cylinder { <-20.6588, 162.6077, 14.118>, <-20.6694, 164.139, 16.6977>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-20.6694, 164.139, 16.6977>, <-20.8512, 166.0683, 18.8591>, <-20.2401, 165.4379, 19.2777> }
					triangle { <-20.8512, 166.0683, 18.8591>, <-19.5652, 167.9402, 21.228>, <-20.2401, 165.4379, 19.2777> }
					triangle { <-20.8512, 166.0683, 18.8591>, <-20.02921, 167.5774, 20.2692>, <-19.5652, 167.9402, 21.228> }
					triangle { <-19.5652, 167.9402, 21.228>, <-19.3743, 167.1339, 20.6608>, <-20.2401, 165.4379, 19.2777> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-21.3015, 161.0974, 11.4383>, 0.5 }
				cylinder { <-21.3015, 161.0974, 11.4383>, <-21.9655, 162.6498, 13.9181>, 0.5 }
				cylinder { <-21.9655, 162.6498, 13.9181>, <-22.6296, 164.2022, 16.3978>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-22.6296, 164.2022, 16.3978>, <-23.4251, 166.1253, 18.4216>, <-22.839, 165.5735, 18.9675> }
					triangle { <-23.4251, 166.1253, 18.4216>, <-22.8209, 168.1604, 20.9242>, <-22.839, 165.5735, 18.9675> }
					triangle { <-23.4251, 166.1253, 18.4216>, <-23.05339, 167.7354, 19.9086>, <-22.8209, 168.1604, 20.9242> }
					triangle { <-22.8209, 168.1604, 20.9242>, <-22.4398, 167.3739, 20.4299>, <-22.839, 165.5735, 18.9675> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-21.9226, 161.043, 11.2179>, 0.5 }
				cylinder { <-21.9226, 161.043, 11.2179>, <-23.2078, 162.541, 13.4771>, 0.5 }
				cylinder { <-23.2078, 162.541, 13.4771>, <-24.493, 164.039, 15.7364>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-24.493, 164.039, 15.7364>, <-25.8607, 165.8847, 17.511>, <-25.3316, 165.4097, 18.1747> }
					triangle { <-25.8607, 165.8847, 17.511>, <-25.9652, 168.0062, 20.01264>, <-25.3316, 165.4097, 18.1747> }
					triangle { <-25.8607, 165.8847, 17.511>, <-25.954, 167.545, 18.9863>, <-25.9652, 168.0062, 20.01264> }
					triangle { <-25.9652, 168.0062, 20.01264>, <-25.4141, 167.2619, 19.6245>, <-25.3316, 165.4097, 18.1747> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-22.4232, 160.9334, 10.9293>, 0.5 }
				cylinder { <-22.4232, 160.9334, 10.9293>, <-24.2089, 162.3217, 12.8999>, 0.5 }
				cylinder { <-24.2089, 162.3217, 12.8999>, <-25.9947, 163.7101, 14.8706>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-25.9947, 163.7101, 14.8706>, <-27.8138, 165.4302, 16.3398>, <-27.36, 165.019, 17.09555> }
					triangle { <-27.8138, 165.4302, 16.3398>, <-28.5426, 167.5607, 18.7272>, <-27.36, 165.019, 17.09555> }
					triangle { <-27.8138, 165.4302, 16.3398>, <-28.3145, 167.0905, 17.7307>, <-28.5426, 167.5607, 18.7272> }
					triangle { <-28.5426, 167.5607, 18.7272>, <-27.8645, 166.871, 18.4575>, <-27.36, 165.019, 17.09555> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-22.9034, 160.7466, 10.5147>, 0.5 }
				cylinder { <-22.9034, 160.7466, 10.5147>, <-25.1694, 161.9481, 12.07092>, 0.5 }
				cylinder { <-25.1694, 161.9481, 12.07092>, <-27.4354, 163.1497, 13.627>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-27.4354, 163.1497, 13.627>, <-29.6755, 164.6707, 14.6734>, <-29.3304, 164.3231, 15.5137> }
					triangle { <-29.6755, 164.6707, 14.6734>, <-31.06941, 166.7346, 16.8105>, <-29.3304, 164.3231, 15.5137> }
					triangle { <-29.6755, 164.6707, 14.6734>, <-30.6075, 166.2808, 15.8902>, <-31.06941, 166.7346, 16.8105> }
					triangle { <-31.06941, 166.7346, 16.8105>, <-30.2815, 166.1228, 16.695>, <-29.3304, 164.3231, 15.5137> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-23.2384, 160.5311, 10.08212>, 0.5 }
				cylinder { <-23.2384, 160.5311, 10.08212>, <-25.8395, 161.5173, 11.2055>, 0.5 }
				cylinder { <-25.8395, 161.5173, 11.2055>, <-28.4405, 162.5034, 12.329>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-28.4405, 162.5034, 12.329>, <-30.9616, 163.8038, 12.945>, <-30.7304, 163.5029, 13.8406> }
					triangle { <-30.9616, 163.8038, 12.945>, <-32.8885, 165.7427, 14.7609>, <-30.7304, 163.5029, 13.8406> }
					triangle { <-30.9616, 163.8038, 12.945>, <-32.2368, 165.3265, 13.9435>, <-32.8885, 165.7427, 14.7609> }
					triangle { <-32.8885, 165.7427, 14.7609>, <-32.03682, 165.212, 14.7954>, <-30.7304, 163.5029, 13.8406> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-23.4954, 160.244, 9.5446>, 0.5 }
				cylinder { <-23.4954, 160.244, 9.5446>, <-26.3534, 160.9429, 10.1306>, 0.5 }
				cylinder { <-26.3534, 160.9429, 10.1306>, <-29.2113, 161.6419, 10.7166>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-29.2113, 161.6419, 10.7166>, <-31.9298, 162.6557, 10.8087>, <-31.8404, 162.3943, 11.7412> }
					triangle { <-31.9298, 162.6557, 10.8087>, <-34.3644, 164.3863, 12.1681>, <-31.8404, 162.3943, 11.7412> }
					triangle { <-31.9298, 162.6557, 10.8087>, <-33.5287, 164.0365, 11.5006>, <-34.3644, 164.3863, 12.1681> }
					triangle { <-34.3644, 164.3863, 12.1681>, <-33.4818, 163.956, 12.3783>, <-31.8404, 162.3943, 11.7412> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-23.6074, 159.9597, 9.04215>, 0.5 }
				cylinder { <-23.6074, 159.9597, 9.04215>, <-26.5775, 160.3744, 9.1256>, 0.5 }
				cylinder { <-26.5775, 160.3744, 9.1256>, <-29.5475, 160.7891, 9.2091>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-29.5475, 160.7891, 9.2091>, <-32.3284, 161.5251, 8.8197>, <-32.3717, 161.2854, 9.7614> }
					triangle { <-32.3284, 161.5251, 8.8197>, <-35.1131, 163.0182, 9.7061>, <-32.3717, 161.2854, 9.7614> }
					triangle { <-32.3284, 161.5251, 8.8197>, <-34.1472, 162.7462, 9.1969>, <-35.1131, 163.0182, 9.7061> }
					triangle { <-35.1131, 163.0182, 9.7061>, <-34.2408, 162.6816, 10.07211>, <-32.3717, 161.2854, 9.7614> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-23.597, 159.6214, 8.4739>, 0.5 }
				cylinder { <-23.597, 159.6214, 8.4739>, <-26.5566, 159.6979, 7.9893>, 0.5 }
				cylinder { <-26.5566, 159.6979, 7.9893>, <-29.5162, 159.7743, 7.5046>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-29.5162, 159.7743, 7.5046>, <-32.237, 160.1854, 6.58>, <-32.4309, 159.9541, 7.5046> }
					triangle { <-32.237, 160.1854, 6.58>, <-35.2848, 161.3642, 6.8819>, <-32.4309, 159.9541, 7.5046> }
					triangle { <-32.237, 160.1854, 6.58>, <-34.2164, 161.1972, 6.5708>, <-35.2848, 161.3642, 6.8819> }
					triangle { <-35.2848, 161.3642, 6.8819>, <-34.4658, 161.1333, 7.4149>, <-32.4309, 159.9541, 7.5046> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-23.4668, 159.3171, 7.9878>, 0.5 }
				cylinder { <-23.4668, 159.3171, 7.9878>, <-26.2962, 159.0892, 7.01707>, 0.5 }
				cylinder { <-26.2962, 159.0892, 7.01707>, <-29.1257, 158.8613, 6.04628>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-29.1257, 158.8613, 6.04628>, <-31.6795, 158.9851, 4.6718>, <-32.00249, 158.7467, 5.5577> }
					triangle { <-31.6795, 158.9851, 4.6718>, <-34.8347, 159.8546, 4.4299>, <-32.00249, 158.7467, 5.5577> }
					triangle { <-31.6795, 158.9851, 4.6718>, <-33.7181, 159.7922, 4.3052>, <-34.8347, 159.8546, 4.4299> }
					triangle { <-34.8347, 159.8546, 4.4299>, <-34.0983, 159.7138, 5.09788>, <-32.00249, 158.7467, 5.5577> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-23.1908, 158.9858, 7.4864>, 0.5 }
				cylinder { <-23.1908, 158.9858, 7.4864>, <-25.7442, 158.4266, 6.01426>, 0.5 }
				cylinder { <-25.7442, 158.4266, 6.01426>, <-28.2976, 157.8674, 4.542>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-28.2976, 157.8674, 4.542>, <-30.5442, 157.6837, 2.7129>, <-31.00067, 157.4214, 3.5308> }
					triangle { <-30.5442, 157.6837, 2.7129>, <-33.6727, 158.1869, 1.859>, <-31.00067, 157.4214, 3.5308> }
					triangle { <-30.5442, 157.6837, 2.7129>, <-32.5526, 158.2499, 1.9465>, <-33.6727, 158.1869, 1.859> }
					triangle { <-33.6727, 158.1869, 1.859>, <-33.06471, 158.1388, 2.6567>, <-31.00067, 157.4214, 3.5308> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-22.8407, 158.7136, 7.1001>, 0.5 }
				cylinder { <-22.8407, 158.7136, 7.1001>, <-25.04413, 157.8822, 5.2416>, 0.5 }
				cylinder { <-25.04413, 157.8822, 5.2416>, <-27.2474, 157.0508, 3.3831>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-27.2474, 157.0508, 3.3831>, <-29.1264, 156.6196, 1.2128>, <-29.6859, 156.3226, 1.9509> }
					triangle { <-29.1264, 156.6196, 1.2128>, <-32.101, 156.7948, -0.1622>, <-29.6859, 156.3226, 1.9509> }
					triangle { <-29.1264, 156.6196, 1.2128>, <-31.02304, 156.9713, 0.1079>, <-32.101, 156.7948, -0.1622> }
					triangle { <-32.101, 156.7948, -0.1622>, <-31.6337, 156.8179, 0.7262>, <-29.6859, 156.3226, 1.9509> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-22.3465, 158.4461, 6.7515>, 0.5 }
				cylinder { <-22.3465, 158.4461, 6.7515>, <-24.05566, 157.3472, 4.5444>, 0.5 }
				cylinder { <-24.05566, 157.3472, 4.5444>, <-25.7647, 156.2483, 2.3373>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-25.7647, 156.2483, 2.3373>, <-27.142, 155.5798, -0.129>, <-27.795, 155.2306, 0.5016> }
					triangle { <-27.142, 155.5798, -0.129>, <-29.8047, 155.3995, -2.03873>, <-27.795, 155.2306, 0.5016> }
					triangle { <-27.142, 155.5798, -0.129>, <-28.8229, 155.7004, -1.5787>, <-29.8047, 155.3995, -2.03873> }
					triangle { <-29.8047, 155.3995, -2.03873>, <-29.5189, 155.4866, -1.08008>, <-27.795, 155.2306, 0.5016> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-21.8366, 158.2528, 6.5313>, 0.5 }
				cylinder { <-21.8366, 158.2528, 6.5313>, <-23.03588, 156.9606, 4.1039>, 0.5 }
				cylinder { <-23.03588, 156.9606, 4.1039>, <-24.235, 155.6684, 1.6766>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-24.235, 155.6684, 1.6766>, <-25.1071, 154.8346, -0.9636>, <-25.8196, 154.4291, -0.4402> }
					triangle { <-25.1071, 154.8346, -0.9636>, <-27.3811, 154.3639, -3.2825>, <-25.8196, 154.4291, -0.4402> }
					triangle { <-25.1071, 154.8346, -0.9636>, <-26.5243, 154.7677, -2.6749>, <-27.3811, 154.3639, -3.2825> }
					triangle { <-27.3811, 154.3639, -3.2825>, <-27.2701, 154.4909, -2.2926>, <-25.8196, 154.4291, -0.4402> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-21.209, 158.095, 6.3953>, 0.5 }
				cylinder { <-21.209, 158.095, 6.3953>, <-21.7805, 156.6449, 3.8319>, 0.5 }
				cylinder { <-21.7805, 156.6449, 3.8319>, <-22.3521, 155.1948, 1.2686>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-22.3521, 155.1948, 1.2686>, <-22.6141, 154.2347, -1.4582>, <-23.364, 153.7576, -1.06327> }
					triangle { <-22.6141, 154.2347, -1.4582>, <-24.3445, 153.4803, -4.1426>, <-23.364, 153.7576, -1.06327> }
					triangle { <-22.6141, 154.2347, -1.4582>, <-23.667, 153.9862, -3.4001>, <-24.3445, 153.4803, -4.1426> }
					triangle { <-24.3445, 153.4803, -4.1426>, <-24.4368, 153.6315, -3.1542>, <-23.364, 153.7576, -1.06327> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-20.6267, 158.0137, 6.3789>, 0.5 }
				cylinder { <-20.6267, 158.0137, 6.3789>, <-20.6161, 156.4823, 3.7992>, 0.5 }
				cylinder { <-20.6161, 156.4823, 3.7992>, <-20.6054, 154.951, 1.2195>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-20.6054, 154.951, 1.2195>, <-20.3112, 153.9362, -1.4841>, <-21.0669, 153.3909, -1.2054> }
					triangle { <-20.3112, 153.9362, -1.4841>, <-21.4848, 152.9788, -4.3955>, <-21.0669, 153.3909, -1.2054> }
					triangle { <-20.3112, 153.9362, -1.4841>, <-20.994, 153.5593, -3.5658>, <-21.4848, 152.9788, -4.3955> }
					triangle { <-21.4848, 152.9788, -4.3955>, <-21.756, 153.1319, -3.4408>, <-21.0669, 153.3909, -1.2054> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-19.9733, 157.9926, 6.4789>, 0.5 }
				cylinder { <-19.9733, 157.9926, 6.4789>, <-19.3093, 156.4402, 3.9991>, 0.5 }
				cylinder { <-19.3093, 156.4402, 3.9991>, <-18.6452, 154.8878, 1.5194>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-18.6452, 154.8878, 1.5194>, <-17.7373, 153.8792, -1.04667>, <-18.468, 153.2553, -0.8952> }
					triangle { <-17.7373, 153.8792, -1.04667>, <-18.229, 152.7586, -4.09171>, <-18.468, 153.2553, -0.8952> }
					triangle { <-17.7373, 153.8792, -1.04667>, <-17.9698, 153.4013, -3.2052>, <-18.229, 152.7586, -4.09171> }
					triangle { <-18.229, 152.7586, -4.09171>, <-18.6905, 152.8919, -3.2099>, <-18.468, 153.2553, -0.8952> }
					texture{Wflower_Texture10}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-20.6374, 159.545, 8.9586>, <-19.3522, 158.047, 6.6993>, 0.5 }
				cylinder { <-19.3522, 158.047, 6.6993>, <-18.06706, 156.549, 4.4401>, 0.5 }
				cylinder { <-18.06706, 156.549, 4.4401>, <-16.7818, 155.051, 2.1808>, 0.5 }
				texture{Wflower_Texture9}}
			union { // flower
				mesh { // flower petal
					triangle { <-16.7818, 155.051, 2.1808>, <-15.3016, 154.1198, -0.1361>, <-15.9753, 153.419, -0.1024> }
					triangle { <-15.3016, 154.1198, -0.1361>, <-15.08482, 152.9127, -3.18>, <-15.9753, 153.419, -0.1024> }
					triangle { <-15.3016, 154.1198, -0.1361>, <-15.0692, 153.5917, -2.2829>, <-15.08482, 152.9127, -3.18> }
					triangle { <-15.08482, 152.9127, -3.18>, <-15.7161, 153.0039, -2.4045>, <-15.9753, 153.419, -0.1024> }
					texture{Wflower_Texture10}}
				}
			}
		}
} // end Pink_daisy

#declare another_daisy = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <0.0, 3.8, 0.0>, 0.5 }
		cylinder { <0.0, 3.8, 0.0>, <-0.0, 7.6, 0.0>, 0.5 }
		cylinder { <-0.0, 7.6, 0.0>, <-0.0, 11.4, 0.0>, 0.5 }
		texture{Wflower_Texture1}}
	union { // internode
		cylinder { <-0.0, 11.4, 0.0>, <-0.0, 15.2, 0.0>, 0.5 }
		cylinder { <-0.0, 15.2, 0.0>, <-0.0, 19.0, 0.0>, 0.5 }
		cylinder { <-0.0, 19.0, 0.0>, <-0.0, 22.8, 0.0>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.0, 22.8, 0.0>, <0.2782, 25.1403, -0.7213>, 0.9729 }
			cylinder { <0.2782, 25.1403, -0.7213>, <0.8066, 27.12, -2.0912>, 0.9729 }
			cylinder { <0.8066, 27.12, -2.0912>, <1.5319, 28.5392, -3.9713>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <1.5319, 28.5392, -3.9713>, <0.1433, 32.7169, -8.5266>, <3.2275, 31.5327, -8.03694> }
			triangle { <3.2275, 31.5327, -8.03694>, <0.1433, 32.7169, -8.5266>, <1.06438, 35.8643, -12.9687> }
			triangle { <3.2275, 31.5327, -8.03694>, <1.06438, 35.8643, -12.9687>, <4.8373, 34.4052, -12.6147> }
			triangle { <1.06438, 35.8643, -12.9687>, <5.7131, 36.5835, -17.418>, <4.8373, 34.4052, -12.6147> }
			triangle { <3.2275, 31.5327, -8.03694>, <5.6937, 29.6198, -8.7234>, <1.5319, 28.5392, -3.9713> }
			triangle { <5.6937, 29.6198, -8.7234>, <3.2275, 31.5327, -8.03694>, <4.8373, 34.4052, -12.6147> }
			triangle { <7.4031, 32.06885, -13.3886>, <5.6937, 29.6198, -8.7234>, <4.8373, 34.4052, -12.6147> }
			triangle { <7.4031, 32.06885, -13.3886>, <4.8373, 34.4052, -12.6147>, <5.7131, 36.5835, -17.418> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <-0.0, 22.8, 0.0>, <-0.2496, 26.5897, 0.1256>, 0.5 }
		cylinder { <-0.2496, 26.5897, 0.1256>, <-0.7477, 30.3485, 0.3763>, 0.5 }
		cylinder { <-0.7477, 30.3485, 0.3763>, <-1.4914, 34.05624, 0.7507>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.4914, 34.05624, 0.7507>, <-2.6232, 36.1703, 1.3204>, 0.9729 }
			cylinder { <-2.6232, 36.1703, 1.3204>, <-4.2903, 37.7802, 2.1595>, 0.9729 }
			cylinder { <-4.2903, 37.7802, 2.1595>, <-6.3242, 38.7234, 3.1833>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <-6.3242, 38.7234, 3.1833>, <-9.09083, 41.9778, 7.8616>, <-10.8012, 40.6794, 5.3039> }
			triangle { <-10.8012, 40.6794, 5.3039>, <-9.09083, 41.9778, 7.8616>, <-13.2751, 44.06814, 10.7957> }
			triangle { <-10.8012, 40.6794, 5.3039>, <-13.2751, 44.06814, 10.7957>, <-15.5252, 42.4193, 7.8446> }
			triangle { <-13.2751, 44.06814, 10.7957>, <-19.722, 43.4938, 10.9777>, <-15.5252, 42.4193, 7.8446> }
			triangle { <-10.8012, 40.6794, 5.3039>, <-12.6821, 38.4781, 3.9511>, <-6.3242, 38.7234, 3.1833> }
			triangle { <-12.6821, 38.4781, 3.9511>, <-10.8012, 40.6794, 5.3039>, <-15.5252, 42.4193, 7.8446> }
			triangle { <-17.4531, 39.7792, 6.4468>, <-12.6821, 38.4781, 3.9511>, <-15.5252, 42.4193, 7.8446> }
			triangle { <-17.4531, 39.7792, 6.4468>, <-15.5252, 42.4193, 7.8446>, <-19.722, 43.4938, 10.9777> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <-1.4914, 34.05624, 0.7507>, <-1.8785, 37.8065, 1.2256>, 0.5 }
		cylinder { <-1.8785, 37.8065, 1.2256>, <-1.9053, 41.5633, 1.7964>, 0.5 }
		cylinder { <-1.9053, 41.5633, 1.7964>, <-1.5716, 45.2903, 2.4578>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-1.5716, 45.2903, 2.4578>, <-0.621, 47.4869, 3.04636>, 0.9729 }
			cylinder { <-0.621, 47.4869, 3.04636>, <0.9677, 49.2409, 3.735>, 0.9729 }
			cylinder { <0.9677, 49.2409, 3.735>, <3.0344, 50.3752, 4.4543>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <3.0344, 50.3752, 4.4543>, <7.7554, 54.4249, 3.2533>, <7.5109, 52.7307, 6.121> }
			triangle { <7.5109, 52.7307, 6.121>, <7.7554, 54.4249, 3.2533>, <12.5317, 57.04844, 4.143> }
			triangle { <7.5109, 52.7307, 6.121>, <12.5317, 57.04844, 4.143>, <12.4742, 54.9492, 7.6186> }
			triangle { <12.5317, 57.04844, 4.143>, <17.5179, 56.6065, 8.25>, <12.4742, 54.9492, 7.6186> }
			triangle { <7.5109, 52.7307, 6.121>, <8.2977, 50.3568, 8.1107>, <3.0344, 50.3752, 4.4543> }
			triangle { <8.2977, 50.3568, 8.1107>, <7.5109, 52.7307, 6.121>, <12.4742, 54.9492, 7.6186> }
			triangle { <13.3214, 52.1359, 9.6208>, <8.2977, 50.3568, 8.1107>, <12.4742, 54.9492, 7.6186> }
			triangle { <13.3214, 52.1359, 9.6208>, <12.4742, 54.9492, 7.6186>, <17.5179, 56.6065, 8.25> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <-1.5716, 45.2903, 2.4578>, <-1.2888, 49.03442, 3.0429>, 0.5 }
		cylinder { <-1.2888, 49.03442, 3.0429>, <-1.05707, 52.7931, 3.5513>, 0.5 }
		cylinder { <-1.05707, 52.7931, 3.5513>, <-0.8765, 56.5642, 3.9827>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.8765, 56.5642, 3.9827>, <-1.1903, 58.9802, 3.6094>, 0.9729 }
			cylinder { <-1.1903, 58.9802, 3.6094>, <-1.9034, 61.1223, 2.6206>, 0.9729 }
			cylinder { <-1.9034, 61.1223, 2.6206>, <-2.9437, 62.7744, 1.1161>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <-2.9437, 62.7744, 1.1161>, <-7.2545, 67.3057, 0.1085>, <-5.123, 66.2802, -2.2491> }
			triangle { <-5.123, 66.2802, -2.2491>, <-7.2545, 67.3057, 0.1085>, <-10.1821, 70.9531, -2.826> }
			triangle { <-5.123, 66.2802, -2.2491>, <-10.1821, 70.9531, -2.826>, <-7.7742, 69.7138, -5.8519> }
			triangle { <-10.1821, 70.9531, -2.826>, <-11.06785, 72.4343, -9.06677>, <-7.7742, 69.7138, -5.8519> }
			triangle { <-5.123, 66.2802, -2.2491>, <-4.3409, 64.614, -4.8617>, <-2.9437, 62.7744, 1.1161> }
			triangle { <-4.3409, 64.614, -4.8617>, <-5.123, 66.2802, -2.2491>, <-7.7742, 69.7138, -5.8519> }
			triangle { <-7.02562, 67.643, -8.6434>, <-4.3409, 64.614, -4.8617>, <-7.7742, 69.7138, -5.8519> }
			triangle { <-7.02562, 67.643, -8.6434>, <-7.7742, 69.7138, -5.8519>, <-11.06785, 72.4343, -9.06677> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <-0.8765, 56.5642, 3.9827>, <-0.7391, 60.2957, 4.6877>, 0.5 }
		cylinder { <-0.7391, 60.2957, 4.6877>, <-0.6457, 63.9674, 5.6624>, 0.5 }
		cylinder { <-0.6457, 63.9674, 5.6624>, <-0.5968, 67.5593, 6.9015>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.5968, 67.5593, 6.9015>, <-0.6899, 69.5241, 8.3867>, 0.9729 }
			cylinder { <-0.6899, 69.5241, 8.3867>, <-0.8985, 70.9256, 10.4035>, 0.9729 }
			cylinder { <-0.8985, 70.9256, 10.4035>, <-1.2016, 71.6223, 12.7482>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <-1.2016, 71.6223, 12.7482>, <1.1512, 74.1832, 18.0433>, <-1.9825, 73.05049, 17.8193> }
			triangle { <-1.9825, 73.05049, 17.8193>, <1.1512, 74.1832, 18.0433>, <1.2078, 75.6787, 23.358> }
			triangle { <-1.9825, 73.05049, 17.8193>, <1.2078, 75.6787, 23.358>, <-2.5754, 74.2042, 23.3072> }
			triangle { <1.2078, 75.6787, 23.358>, <-2.4123, 74.67, 28.6307>, <-2.5754, 74.2042, 23.3072> }
			triangle { <-1.9825, 73.05049, 17.8193>, <-4.2783, 70.8848, 18.3215>, <-1.2016, 71.6223, 12.7482> }
			triangle { <-4.2783, 70.8848, 18.3215>, <-1.9825, 73.05049, 17.8193>, <-2.5754, 74.2042, 23.3072> }
			triangle { <-4.9559, 71.6046, 23.7719>, <-4.2783, 70.8848, 18.3215>, <-2.5754, 74.2042, 23.3072> }
			triangle { <-4.9559, 71.6046, 23.7719>, <-2.5754, 74.2042, 23.3072>, <-2.4123, 74.67, 28.6307> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <-0.5968, 67.5593, 6.9015>, <-0.1849, 71.2146, 7.8553>, 0.5 }
		cylinder { <-0.1849, 71.2146, 7.8553>, <0.5837, 74.8781, 8.5093>, 0.5 }
		cylinder { <0.5837, 74.8781, 8.5093>, <1.6976, 78.4948, 8.8537>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <1.6976, 78.4948, 8.8537>, <2.9434, 80.5993, 8.5469>, 0.9729 }
			cylinder { <2.9434, 80.5993, 8.5469>, <4.5869, 82.2499, 7.741>, 0.9729 }
			cylinder { <4.5869, 82.2499, 7.741>, <6.462, 83.2801, 6.5173>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <6.462, 83.2801, 6.5173>, <8.5699, 87.4295, 2.2195>, <10.6022, 85.3974, 3.9208> }
			triangle { <10.6022, 85.3974, 3.9208>, <8.5699, 87.4295, 2.2195>, <12.2718, 89.907, -1.04303> }
			triangle { <10.6022, 85.3974, 3.9208>, <12.2718, 89.907, -1.04303>, <14.8655, 87.3978, 0.819> }
			triangle { <12.2718, 89.907, -1.04303>, <18.4081, 88.9471, -2.8733>, <14.8655, 87.3978, 0.819> }
			triangle { <10.6022, 85.3974, 3.9208>, <12.4302, 82.7948, 4.2332>, <6.462, 83.2801, 6.5173> }
			triangle { <12.4302, 82.7948, 4.2332>, <10.6022, 85.3974, 3.9208>, <14.8655, 87.3978, 0.819> }
			triangle { <16.6927, 84.3574, 1.05944>, <12.4302, 82.7948, 4.2332>, <14.8655, 87.3978, 0.819> }
			triangle { <16.6927, 84.3574, 1.05944>, <14.8655, 87.3978, 0.819>, <18.4081, 88.9471, -2.8733> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <1.6976, 78.4948, 8.8537>, <2.5413, 82.1839, 9.198>, 0.5 }
		cylinder { <2.5413, 82.1839, 9.198>, <3.1101, 85.9255, 9.5404>, 0.5 }
		cylinder { <3.1101, 85.9255, 9.5404>, <3.4012, 89.6991, 9.879>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <3.4012, 89.6991, 9.879>, <2.8098, 92.08392, 10.07464>, 0.9729 }
			cylinder { <2.8098, 92.08392, 10.07464>, <1.4979, 94.165, 10.2263>, 0.9729 }
			cylinder { <1.4979, 94.165, 10.2263>, <-0.402, 95.7323, 10.3189>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <-0.402, 95.7323, 10.3189>, <-3.8898, 99.918, 13.5509>, <-4.5592, 99.06065, 10.3933> }
			triangle { <-4.5592, 99.06065, 10.3933>, <-3.8898, 99.918, 13.5509>, <-8.1278, 103.3298, 14.4925> }
			triangle { <-4.5592, 99.06065, 10.3933>, <-8.1278, 103.3298, 14.4925>, <-9.1774, 102.2807, 10.7126> }
			triangle { <-8.1278, 103.3298, 14.4925>, <-13.8134, 104.7401, 11.734>, <-9.1774, 102.2807, 10.7126> }
			triangle { <-4.5592, 99.06065, 10.3933>, <-6.1802, 97.4605, 8.1517>, <-0.402, 95.7323, 10.3189> }
			triangle { <-6.1802, 97.4605, 8.1517>, <-4.5592, 99.06065, 10.3933>, <-9.1774, 102.2807, 10.7126> }
			triangle { <-10.9465, 100.2746, 8.3701>, <-6.1802, 97.4605, 8.1517>, <-9.1774, 102.2807, 10.7126> }
			triangle { <-10.9465, 100.2746, 8.3701>, <-9.1774, 102.2807, 10.7126>, <-13.8134, 104.7401, 11.734> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <3.4012, 89.6991, 9.879>, <3.6922, 93.4728, 10.2177>, 0.5 }
		cylinder { <3.6922, 93.4728, 10.2177>, <3.9833, 97.2465, 10.5563>, 0.5 }
		cylinder { <3.9833, 97.2465, 10.5563>, <4.2743, 101.0202, 10.8949>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <4.2743, 101.0202, 10.8949>, <5.0123, 103.254, 11.6302>, 0.9729 }
			cylinder { <5.0123, 103.254, 11.6302>, <6.2249, 105.0484, 12.8069>, 0.9729 }
			cylinder { <6.2249, 105.0484, 12.8069>, <7.7899, 106.2223, 14.3061>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <7.7899, 106.2223, 14.3061>, <12.8362, 109.9686, 15.1008>, <11.1197, 108.679, 17.6591> }
			triangle { <11.1197, 108.679, 17.6591>, <12.8362, 109.9686, 15.1008>, <16.8197, 112.5801, 17.8933> }
			triangle { <11.1197, 108.679, 17.6591>, <16.8197, 112.5801, 17.8933>, <14.9449, 110.9665, 21.1137> }
			triangle { <16.8197, 112.5801, 17.8933>, <19.2043, 112.5803, 23.9131>, <14.9449, 110.9665, 21.1137> }
			triangle { <11.1197, 108.679, 17.6591>, <10.6666, 106.5756, 20.02209>, <7.7899, 106.2223, 14.3061> }
			triangle { <10.6666, 106.5756, 20.02209>, <11.1197, 108.679, 17.6591>, <14.9449, 110.9665, 21.1137> }
			triangle { <14.502, 108.4281, 23.5635>, <10.6666, 106.5756, 20.02209>, <14.9449, 110.9665, 21.1137> }
			triangle { <14.502, 108.4281, 23.5635>, <14.9449, 110.9665, 21.1137>, <19.2043, 112.5803, 23.9131> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <4.2743, 101.0202, 10.8949>, <4.5438, 104.8102, 10.9551>, 0.5 }
		cylinder { <4.5438, 104.8102, 10.9551>, <4.7904, 108.5958, 10.7366>, 0.5 }
		cylinder { <4.7904, 108.5958, 10.7366>, <5.01265, 112.3568, 10.2404>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.01265, 112.3568, 10.2404>, <5.08063, 114.5763, 9.1709>, 0.9729 }
			cylinder { <5.08063, 114.5763, 9.1709>, <5.06558, 116.352, 7.4616>, 0.9729 }
			cylinder { <5.06558, 116.352, 7.4616>, <4.969, 117.5046, 5.2851>, 0.9729 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <4.969, 117.5046, 5.2851>, <1.9609, 121.3739, 1.2711>, <4.8698, 119.9082, 0.5334> }
			triangle { <4.8698, 119.9082, 0.5334>, <1.9609, 121.3739, 1.2711>, <1.01099, 123.9804, -3.5027> }
			triangle { <4.8698, 119.9082, 0.5334>, <1.01099, 123.9804, -3.5027>, <4.4609, 122.1545, -4.6226> }
			triangle { <1.01099, 123.9804, -3.5027>, <3.2544, 123.7737, -9.573>, <4.4609, 122.1545, -4.6226> }
			triangle { <4.8698, 119.9082, 0.5334>, <6.664, 117.6812, -0.8928>, <4.969, 117.5046, 5.2851> }
			triangle { <6.664, 117.6812, -0.8928>, <4.8698, 119.9082, 0.5334>, <4.4609, 122.1545, -4.6226> }
			triangle { <6.2809, 119.4895, -6.1146>, <6.664, 117.6812, -0.8928>, <4.4609, 122.1545, -4.6226> }
			triangle { <6.2809, 119.4895, -6.1146>, <4.4609, 122.1545, -4.6226>, <3.2544, 123.7737, -9.573> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <5.01265, 112.3568, 10.2404>, <5.1787, 116.1295, 9.8178>, 0.5 }
		cylinder { <5.1787, 116.1295, 9.8178>, <5.2885, 119.9119, 9.4689>, 0.5 }
		cylinder { <5.2885, 119.9119, 9.4689>, <5.3419, 123.7015, 9.194>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <5.3419, 123.7015, 9.194>, <4.9136, 126.0532, 9.6322>, 0.9592 }
			cylinder { <4.9136, 126.0532, 9.6322>, <4.06619, 128.0955, 10.6404>, 0.9592 }
			cylinder { <4.06619, 128.0955, 10.6404>, <2.885, 129.6224, 12.1166>, 0.9592 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <2.885, 129.6224, 12.1166>, <3.0132, 134.0689, 16.5012>, <0.2092, 132.8491, 15.2794> }
			triangle { <0.2092, 132.8491, 15.2794>, <3.0132, 134.0689, 16.5012>, <0.9703, 137.4793, 20.2206> }
			triangle { <0.2092, 132.8491, 15.2794>, <0.9703, 137.4793, 20.2206>, <-2.5269, 135.9944, 18.958> }
			triangle { <0.9703, 137.4793, 20.2206>, <-4.639, 138.4784, 23.1001>, <-2.5269, 135.9944, 18.958> }
			triangle { <0.2092, 132.8491, 15.2794>, <-2.341, 131.0018, 15.3896>, <2.885, 129.6224, 12.1166> }
			triangle { <-2.341, 131.0018, 15.3896>, <0.2092, 132.8491, 15.2794>, <-2.5269, 135.9944, 18.958> }
			triangle { <-5.2012, 133.7365, 19.1538>, <-2.341, 131.0018, 15.3896>, <-2.5269, 135.9944, 18.958> }
			triangle { <-5.2012, 133.7365, 19.1538>, <-2.5269, 135.9944, 18.958>, <-4.639, 138.4784, 23.1001> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <5.3419, 123.7015, 9.194>, <5.5785, 127.4816, 8.8853>, 0.5 }
		cylinder { <5.5785, 127.4816, 8.8853>, <5.9977, 131.2429, 8.5435>, 0.5 }
		cylinder { <5.9977, 131.2429, 8.5435>, <6.5985, 134.9764, 8.1696>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.5985, 134.9764, 8.1696>, <7.5894, 136.8922, 7.8494>, 0.8607 }
			cylinder { <7.5894, 136.8922, 7.8494>, <9.1263, 138.388, 7.4559>, 0.8607 }
			cylinder { <9.1263, 138.388, 7.4559>, <11.0542, 139.3128, 7.02883>, 0.8607 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <11.0542, 139.3128, 7.02883>, <14.3783, 142.1915, 3.5545>, <15.2711, 141.2474, 6.2079> }
			triangle { <15.2711, 141.2474, 6.2079>, <14.3783, 142.1915, 3.5545>, <18.539, 144.1967, 1.9649> }
			triangle { <15.2711, 141.2474, 6.2079>, <18.539, 144.1967, 1.9649>, <19.8117, 142.9922, 5.1009> }
			triangle { <18.539, 144.1967, 1.9649>, <24.08406, 144.0955, 3.398>, <19.8117, 142.9922, 5.1009> }
			triangle { <15.2711, 141.2474, 6.2079>, <16.6499, 139.4751, 7.9258>, <11.0542, 139.3128, 7.02883> }
			triangle { <16.6499, 139.4751, 7.9258>, <15.2711, 141.2474, 6.2079>, <19.8117, 142.9922, 5.1009> }
			triangle { <21.2419, 140.8376, 6.8912>, <16.6499, 139.4751, 7.9258>, <19.8117, 142.9922, 5.1009> }
			triangle { <21.2419, 140.8376, 6.8912>, <19.8117, 142.9922, 5.1009>, <24.08406, 144.0955, 3.398> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <6.5985, 134.9764, 8.1696>, <6.9622, 138.7228, 7.6479>, 0.5 }
		cylinder { <6.9622, 138.7228, 7.6479>, <7.08678, 142.4618, 6.9812>, 0.5 }
		cylinder { <7.08678, 142.4618, 6.9812>, <6.9714, 146.1731, 6.1732>, 0.5 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <6.9714, 146.1731, 6.1732>, <6.5421, 147.4501, 5.6566>, 0.5695 }
			cylinder { <6.5421, 147.4501, 5.6566>, <5.7706, 148.466, 4.9823>, 0.5695 }
			cylinder { <5.7706, 148.466, 4.9823>, <4.7347, 149.1182, 4.2185>, 0.5695 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <4.7347, 149.1182, 4.2185>, <1.8949, 151.4974, 4.05028>, <2.5088, 150.4701, 2.5042> }
			triangle { <2.5088, 150.4701, 2.5042>, <1.8949, 151.4974, 4.05028>, <-0.6286, 153.0156, 2.7181> }
			triangle { <2.5088, 150.4701, 2.5042>, <-0.6286, 153.0156, 2.7181>, <-0.01869, 151.7434, 0.8048> }
			triangle { <-0.6286, 153.0156, 2.7181>, <-2.7378, 152.699, -0.4152>, <-0.01869, 151.7434, 0.8048> }
			triangle { <2.5088, 150.4701, 2.5042>, <2.3954, 149.0548, 1.286>, <4.7347, 149.1182, 4.2185> }
			triangle { <2.3954, 149.0548, 1.286>, <2.5088, 150.4701, 2.5042>, <-0.01869, 151.7434, 0.8048> }
			triangle { <-0.1649, 150.0707, -0.425>, <2.3954, 149.0548, 1.286>, <-0.01869, 151.7434, 0.8048> }
			triangle { <-0.1649, 150.0707, -0.425>, <-0.01869, 151.7434, 0.8048>, <-2.7378, 152.699, -0.4152> }
			texture{Wflower_Texture5}}
		}
	union { // internode
		cylinder { <6.9714, 146.1731, 6.1732>, <6.9515, 148.3668, 5.8554>, 0.2916 }
		cylinder { <6.9515, 148.3668, 5.8554>, <6.979, 150.5773, 5.6928>, 0.2916 }
		cylinder { <6.979, 150.5773, 5.6928>, <7.05381, 152.7927, 5.6863>, 0.2916 }
		texture{Wflower_Texture1}}
	union { // leaf and petiole
		union { // petiole
			cylinder { <7.05381, 152.7927, 5.6863>, <7.1159, 153.2724, 5.837>, 0.2 }
			cylinder { <7.1159, 153.2724, 5.837>, <7.2167, 153.6771, 6.1248>, 0.2 }
			cylinder { <7.2167, 153.6771, 6.1248>, <7.3461, 153.9658, 6.5206>, 0.2 }
			texture{Wflower_Texture1}}
		mesh { // leaf
			triangle { <7.3461, 153.9658, 6.5206>, <8.1749, 154.7987, 7.08199>, <7.6048, 154.5753, 7.3924> }
			triangle { <7.6048, 154.5753, 7.3924>, <8.1749, 154.7987, 7.08199>, <8.6078, 155.434, 7.9171> }
			triangle { <7.6048, 154.5753, 7.3924>, <8.6078, 155.434, 7.9171>, <7.9412, 155.1576, 8.3367> }
			triangle { <8.6078, 155.434, 7.9171>, <8.4202, 155.5921, 9.2253>, <7.9412, 155.1576, 8.3367> }
			triangle { <7.6048, 154.5753, 7.3924>, <7.2782, 154.1941, 7.8163>, <7.3461, 153.9658, 6.5206> }
			triangle { <7.2782, 154.1941, 7.8163>, <7.6048, 154.5753, 7.3924>, <7.9412, 155.1576, 8.3367> }
			triangle { <7.6066, 154.6896, 8.7875>, <7.2782, 154.1941, 7.8163>, <7.9412, 155.1576, 8.3367> }
			triangle { <7.6066, 154.6896, 8.7875>, <7.9412, 155.1576, 8.3367>, <8.4202, 155.5921, 9.2253> }
			texture{Wflower_Texture5}}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <7.05381, 152.7927, 5.6863>, <7.3101, 160.3884, 5.664>, 0.5 }
			cylinder { <7.3101, 160.3884, 5.664>, <7.5664, 167.984, 5.6417>, 0.5 }
			cylinder { <7.5664, 167.984, 5.6417>, <7.8228, 175.5797, 5.6194>, 0.5 }
			texture{Wflower_Texture1}}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <8.9629, 173.7792, 4.2496>, 0.5 }
				cylinder { <8.9629, 173.7792, 4.2496>, <10.103, 171.9788, 2.8798>, 0.5 }
				cylinder { <10.103, 171.9788, 2.8798>, <11.2431, 170.1784, 1.5099>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <11.2431, 170.1784, 1.5099>, <12.4433, 168.2333, 0.6239>, <12.5337, 168.7368, -0.01873> }
					triangle { <12.4433, 168.2333, 0.6239>, <14.5636, 167.0239, -0.6881>, <12.5337, 168.7368, -0.01873> }
					triangle { <12.4433, 168.2333, 0.6239>, <13.9574, 167.3332, -0.02493>, <14.5636, 167.0239, -0.6881> }
					triangle { <14.5636, 167.0239, -0.6881>, <14.1746, 167.7707, -0.5878>, <12.5337, 168.7368, -0.01873> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <11.2431, 170.1784, 1.5099>, <11.8979, 168.3714, -0.01144>, <12.508, 168.3001, 0.5338> }
					triangle { <11.8979, 168.3714, -0.01144>, <12.7904, 165.8066, -0.564>, <12.508, 168.3001, 0.5338> }
					triangle { <11.8979, 168.3714, -0.01144>, <12.2527, 166.5828, -0.4575>, <12.7904, 165.8066, -0.564> }
					triangle { <12.7904, 165.8066, -0.564>, <12.7608, 166.3886, 0.05194>, <12.508, 168.3001, 0.5338> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <11.2431, 170.1784, 1.5099>, <12.6323, 168.8067, 0.02756>, <11.9739, 168.3172, 0.06673> }
					triangle { <12.6323, 168.8067, 0.02756>, <13.04021, 167.2095, -2.2>, <11.9739, 168.3172, 0.06673> }
					triangle { <12.6323, 168.8067, 0.02756>, <13.03167, 167.9347, -1.5861>, <13.04021, 167.2095, -2.2> }
					triangle { <13.04021, 167.2095, -2.2>, <12.4319, 167.5041, -1.6879>, <11.9739, 168.3172, 0.06673> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <9.3964, 173.8849, 4.5853>, 0.5 }
				cylinder { <9.3964, 173.8849, 4.5853>, <10.9701, 172.1902, 3.5513>, 0.5 }
				cylinder { <10.9701, 172.1902, 3.5513>, <12.5437, 170.4955, 2.5173>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <12.5437, 170.4955, 2.5173>, <14.1196, 168.6961, 1.9808>, <14.2412, 169.1673, 1.3192> }
					triangle { <14.1196, 168.6961, 1.9808>, <16.5633, 167.7314, 1.09923>, <14.2412, 169.1673, 1.3192> }
					triangle { <14.1196, 168.6961, 1.9808>, <15.8243, 167.9887, 1.6382>, <16.5633, 167.7314, 1.09923> }
					triangle { <16.5633, 167.7314, 1.09923>, <16.0664, 168.4182, 1.07932>, <14.2412, 169.1673, 1.3192> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <12.5437, 170.4955, 2.5173>, <13.6673, 168.7141, 1.2629>, <14.1881, 168.7659, 1.896> }
					triangle { <13.6673, 168.7141, 1.2629>, <14.9733, 166.2783, 1.06107>, <14.1881, 168.7659, 1.896> }
					triangle { <13.6673, 168.7141, 1.2629>, <14.3259, 166.9727, 1.02296>, <14.9733, 166.2783, 1.06107> }
					triangle { <14.9733, 166.2783, 1.06107>, <14.769, 166.8861, 1.6158>, <14.1881, 168.7659, 1.896> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <12.5437, 170.4955, 2.5173>, <14.321, 169.2536, 1.3735>, <13.7367, 168.6765, 1.3557> }
					triangle { <14.321, 169.2536, 1.3735>, <15.2858, 167.6005, -0.6304>, <13.7367, 168.6765, 1.3557> }
					triangle { <14.321, 169.2536, 1.3735>, <15.08308, 168.3526, -0.08634>, <15.2858, 167.6005, -0.6304> }
					triangle { <15.2858, 167.6005, -0.6304>, <14.5704, 167.8338, -0.2394>, <13.7367, 168.6765, 1.3557> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <9.7182, 174.0482, 4.9266>, 0.5 }
				cylinder { <9.7182, 174.0482, 4.9266>, <11.6136, 172.5168, 4.2337>, 0.5 }
				cylinder { <11.6136, 172.5168, 4.2337>, <13.509, 170.9854, 3.5409>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <13.509, 170.9854, 3.5409>, <15.3497, 169.3782, 3.3479>, <15.5048, 169.8239, 2.6757> }
					triangle { <15.3497, 169.3782, 3.3479>, <17.991, 168.6906, 2.8674>, <15.5048, 169.8239, 2.6757> }
					triangle { <15.3497, 169.3782, 3.3479>, <17.1584, 168.8795, 3.2845>, <17.991, 168.6906, 2.8674> }
					triangle { <17.991, 168.6906, 2.8674>, <17.4224, 169.3051, 2.7327>, <15.5048, 169.8239, 2.6757> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <13.509, 170.9854, 3.5409>, <15.0033, 169.2979, 2.5774>, <15.4205, 169.4516, 3.2681> }
					triangle { <15.0033, 169.2979, 2.5774>, <16.6089, 167.0441, 2.7257>, <15.4205, 169.4516, 3.2681> }
					triangle { <15.0033, 169.2979, 2.5774>, <15.8941, 167.6458, 2.5527>, <16.6089, 167.0441, 2.7257> }
					triangle { <16.6089, 167.0441, 2.7257>, <16.2573, 167.6501, 3.2034>, <15.4205, 169.4516, 3.2681> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <13.509, 170.9854, 3.5409>, <15.5651, 169.9227, 2.7337>, <15.06307, 169.2748, 2.6809> }
					triangle { <15.5651, 169.9227, 2.7337>, <16.9925, 168.3001, 0.9988>, <15.06307, 169.2748, 2.6809> }
					triangle { <15.5651, 169.9227, 2.7337>, <16.6265, 169.0486, 1.4556>, <16.9925, 168.3001, 0.9988> }
					triangle { <16.9925, 168.3001, 0.9988>, <16.2067, 168.4601, 1.2744>, <15.06307, 169.2748, 2.6809> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <9.9926, 174.3019, 5.3416>, 0.5 }
				cylinder { <9.9926, 174.3019, 5.3416>, <12.1624, 173.0242, 5.0638>, 0.5 }
				cylinder { <12.1624, 173.0242, 5.0638>, <14.3322, 171.7465, 4.7859>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <14.3322, 171.7465, 4.7859>, <16.3801, 170.4163, 4.999>, <16.5774, 170.8381, 4.3224> }
					triangle { <16.3801, 170.4163, 4.999>, <19.1324, 170.0935, 4.9705>, <16.5774, 170.8381, 4.3224> }
					triangle { <16.3801, 170.4163, 4.999>, <18.2267, 170.1839, 5.2436>, <19.1324, 170.0935, 4.9705> }
					triangle { <19.1324, 170.0935, 4.9705>, <18.5145, 170.6092, 4.7034>, <16.5774, 170.8381, 4.3224> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.3322, 171.7465, 4.7859>, <16.1732, 170.2396, 4.1952>, <16.452, 170.4942, 4.9246> }
					triangle { <16.1732, 170.2396, 4.1952>, <18.02466, 168.2574, 4.7634>, <16.452, 170.4942, 4.9246> }
					triangle { <16.1732, 170.2396, 4.1952>, <17.2714, 168.7367, 4.438>, <18.02466, 168.2574, 4.7634> }
					triangle { <18.02466, 168.2574, 4.7634>, <17.5238, 168.8335, 5.1325>, <16.452, 170.4942, 4.9246> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.3322, 171.7465, 4.7859>, <16.614, 170.948, 4.3803>, <16.2185, 170.2318, 4.3079> }
					triangle { <16.614, 170.948, 4.3803>, <18.5021, 169.4486, 3.01403>, <16.2185, 170.2318, 4.3079> }
					triangle { <16.614, 170.948, 4.3803>, <17.9713, 170.1621, 3.3488>, <18.5021, 169.4486, 3.01403> }
					triangle { <18.5021, 169.4486, 3.01403>, <17.6684, 169.5087, 3.1569>, <16.2185, 170.2318, 4.3079> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <10.1483, 174.58, 5.7224>, 0.5 }
				cylinder { <10.1483, 174.58, 5.7224>, <12.4737, 173.5804, 5.8255>, 0.5 }
				cylinder { <12.4737, 173.5804, 5.8255>, <14.7992, 172.5807, 5.9285>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <14.7992, 172.5807, 5.9285>, <16.9428, 171.5405, 6.5047>, <17.1802, 171.9463, 5.8312> }
					triangle { <16.9428, 171.5405, 6.5047>, <19.6907, 171.5755, 6.8618>, <17.1802, 171.9463, 5.8312> }
					triangle { <16.9428, 171.5405, 6.5047>, <18.7516, 171.5629, 7.006219>, <19.6907, 171.5755, 6.8618> }
					triangle { <19.6907, 171.5755, 6.8618>, <19.05852, 171.9913, 6.4792>, <17.1802, 171.9463, 5.8312> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.7992, 172.5807, 5.9285>, <16.8729, 171.2944, 5.6955>, <17.01443, 171.6228, 6.435> }
					triangle { <16.8729, 171.2944, 5.6955>, <18.8524, 169.6029, 6.6441>, <17.01443, 171.6228, 6.435> }
					triangle { <16.8729, 171.2944, 5.6955>, <18.09971, 169.9619, 6.1888>, <18.8524, 169.6029, 6.6441> }
					triangle { <18.8524, 169.6029, 6.6441>, <18.2392, 170.1288, 6.9016>, <17.01443, 171.6228, 6.435> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.7992, 172.5807, 5.9285>, <17.1948, 172.063, 5.8853>, <16.9026, 171.2988, 5.8135> }
					triangle { <17.1948, 172.063, 5.8853>, <19.4221, 170.7473, 4.8912>, <16.9026, 171.2988, 5.8135> }
					triangle { <17.1948, 172.063, 5.8853>, <18.7676, 171.4036, 5.1008>, <19.4221, 170.7473, 4.8912> }
					triangle { <19.4221, 170.7473, 4.8912>, <18.5755, 170.7069, 4.9186>, <16.9026, 171.2988, 5.8135> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <10.2164, 174.9382, 6.1455>, 0.5 }
				cylinder { <10.2164, 174.9382, 6.1455>, <12.6101, 174.2967, 6.6715>, 0.5 }
				cylinder { <12.6101, 174.2967, 6.6715>, <15.00375, 173.6553, 7.1976>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <15.00375, 173.6553, 7.1976>, <17.1505, 172.976, 8.1666>, <17.4339, 173.3703, 7.5042> }
					triangle { <17.1505, 172.976, 8.1666>, <19.7779, 173.4331, 8.9199>, <17.4339, 173.3703, 7.5042> }
					triangle { <17.1505, 172.976, 8.1666>, <18.8381, 173.2924, 8.9251>, <19.7779, 173.4331, 8.9199> }
					triangle { <19.7779, 173.4331, 8.9199>, <19.1634, 173.7282, 8.4155>, <17.4339, 173.3703, 7.5042> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <15.00375, 173.6553, 7.1976>, <17.2425, 172.6735, 7.379>, <17.2204, 173.0634, 8.1016> }
					triangle { <17.2425, 172.6735, 7.379>, <19.2581, 171.3498, 8.7447>, <17.2204, 173.0634, 8.1016> }
					triangle { <17.2425, 172.6735, 7.379>, <18.5448, 171.5668, 8.1555>, <19.2581, 171.3498, 8.7447> }
					triangle { <19.2581, 171.3498, 8.7447>, <18.5467, 171.7953, 8.8649>, <17.2204, 173.0634, 8.1016> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <15.00375, 173.6553, 7.1976>, <17.424, 173.491, 7.55>, <17.2525, 172.6893, 7.4993> }
					triangle { <17.424, 173.491, 7.55>, <19.9367, 172.4564, 7.006306>, <17.2525, 172.6893, 7.4993> }
					triangle { <17.424, 173.491, 7.55>, <19.1749, 173.0216, 7.06253>, <19.9367, 172.4564, 7.006306> }
					triangle { <19.9367, 172.4564, 7.006306>, <19.1097, 172.2946, 6.9121>, <17.2525, 172.6893, 7.4993> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <10.1793, 175.2833, 6.5006>, 0.5 }
				cylinder { <10.1793, 175.2833, 6.5006>, <12.5359, 174.987, 7.3819>, 0.5 }
				cylinder { <12.5359, 174.987, 7.3819>, <14.8924, 174.6906, 8.2631>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <14.8924, 174.6906, 8.2631>, <16.9491, 174.3493, 9.5525>, <17.2725, 174.7399, 8.9064> }
					triangle { <16.9491, 174.3493, 9.5525>, <19.3712, 175.1835, 10.6097>, <17.2725, 174.7399, 8.9064> }
					triangle { <16.9491, 174.3493, 9.5525>, <18.4638, 174.9229, 10.5015>, <19.3712, 175.1835, 10.6097> }
					triangle { <19.3712, 175.1835, 10.6097>, <18.8021, 175.3683, 10.0089>, <17.2725, 174.7399, 8.9064> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.8924, 174.6906, 8.2631>, <17.1859, 174.0183, 8.8079>, <17.01636, 174.4414, 9.4911> }
					triangle { <17.1859, 174.0183, 8.8079>, <19.1361, 173.044, 10.5188>, <17.01636, 174.4414, 9.4911> }
					triangle { <17.1859, 174.0183, 8.8079>, <18.4911, 173.134, 9.8269>, <19.1361, 173.044, 10.5188> }
					triangle { <19.1361, 173.044, 10.5188>, <18.3664, 173.3997, 10.5119>, <17.01636, 174.4414, 9.4911> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.8924, 174.6906, 8.2631>, <17.2418, 174.8606, 8.9417>, <17.1771, 174.0419, 8.927> }
					triangle { <17.2418, 174.8606, 8.9417>, <19.9121, 174.1313, 8.8093>, <17.1771, 174.0419, 8.927> }
					triangle { <17.2418, 174.8606, 8.9417>, <19.08742, 174.5954, 8.7238>, <19.9121, 174.1313, 8.8093> }
					triangle { <19.9121, 174.1313, 8.8093>, <19.1319, 173.8589, 8.6191>, <17.1771, 174.0419, 8.927> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <10.02961, 175.6845, 6.8591>, 0.5 }
				cylinder { <10.02961, 175.6845, 6.8591>, <12.2364, 175.7893, 8.09883>, 0.5 }
				cylinder { <12.2364, 175.7893, 8.09883>, <14.4431, 175.8942, 9.3385>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <14.4431, 175.8942, 9.3385>, <16.2984, 175.9357, 10.9401>, <16.6638, 176.3292, 10.3186> }
					triangle { <16.2984, 175.9357, 10.9401>, <18.3891, 177.1771, 12.2696>, <16.6638, 176.3292, 10.3186> }
					triangle { <16.2984, 175.9357, 10.9401>, <17.5536, 176.7809, 12.051>, <18.3891, 177.1771, 12.2696> }
					triangle { <18.3891, 177.1771, 12.2696>, <17.902, 177.24, 11.5784>, <16.6638, 176.3292, 10.3186> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.4431, 175.8942, 9.3385>, <16.6919, 175.5981, 10.2682>, <16.3614, 176.0327, 10.8819> }
					triangle { <16.6919, 175.5981, 10.2682>, <18.462, 175.0246, 12.3219>, <16.3614, 176.0327, 10.8819> }
					triangle { <16.6919, 175.5981, 10.2682>, <17.9277, 174.9774, 11.5375>, <18.462, 175.0246, 12.3219> }
					triangle { <18.462, 175.0246, 12.3219>, <17.6621, 175.2631, 12.1725>, <16.3614, 176.0327, 10.8819> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <14.4431, 175.8942, 9.3385>, <16.6119, 176.4461, 10.3389>, <16.6613, 175.6273, 10.3824> }
					triangle { <16.6119, 176.4461, 10.3389>, <19.3434, 176.1076, 10.6613>, <16.6613, 175.6273, 10.3824> }
					triangle { <16.6119, 176.4461, 10.3389>, <18.4874, 176.4403, 10.4175>, <19.3434, 176.1076, 10.6613> }
					triangle { <19.3434, 176.1076, 10.6613>, <18.6468, 175.7132, 10.3816>, <16.6613, 175.6273, 10.3824> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <9.8061, 176.0374, 7.1276>, 0.5 }
				cylinder { <9.8061, 176.0374, 7.1276>, <11.7894, 176.4952, 8.6359>, 0.5 }
				cylinder { <11.7894, 176.4952, 8.6359>, <13.7726, 176.953, 10.1441>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <13.7726, 176.953, 10.1441>, <15.3676, 177.3226, 11.9685>, <15.7659, 177.7252, 11.3736> }
					triangle { <15.3676, 177.3226, 11.9685>, <17.08717, 178.8957, 13.468>, <15.7659, 177.7252, 11.3736> }
					triangle { <15.3676, 177.3226, 11.9685>, <16.3443, 178.3831, 13.1707>, <17.08717, 178.8957, 13.468> }
					triangle { <17.08717, 178.8957, 13.468>, <16.6972, 178.8567, 12.7161>, <15.7659, 177.7252, 11.3736> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <13.7726, 176.953, 10.1441>, <15.8888, 177.0022, 11.3804>, <15.4259, 177.4236, 11.9122> }
					triangle { <15.8888, 177.0022, 11.3804>, <17.4112, 176.7769, 13.685>, <15.4259, 177.4236, 11.9122> }
					triangle { <15.8888, 177.0022, 11.3804>, <17.00124, 176.6176, 12.8427>, <17.4112, 176.7769, 13.685> }
					triangle { <17.4112, 176.7769, 13.685>, <16.6171, 176.9013, 13.4149>, <15.4259, 177.4236, 11.9122> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <13.7726, 176.953, 10.1441>, <15.698, 177.8353, 11.3784>, <15.8392, 177.0335, 11.4871> }
					triangle { <15.698, 177.8353, 11.3784>, <18.3785, 177.8714, 12.08083>, <15.8392, 177.0335, 11.4871> }
					triangle { <15.698, 177.8353, 11.3784>, <17.5311, 178.0766, 11.7031>, <18.3785, 177.8714, 12.08083> }
					triangle { <18.3785, 177.8714, 12.08083>, <17.7805, 177.3753, 11.7412>, <15.8392, 177.0335, 11.4871> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <9.4641, 176.4128, 7.36>, 0.5 }
				cylinder { <9.4641, 176.4128, 7.36>, <11.1054, 177.246, 9.1006>, 0.5 }
				cylinder { <11.1054, 177.246, 9.1006>, <12.7466, 178.0792, 10.8412>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <12.7466, 178.0792, 10.8412>, <13.9702, 178.7878, 12.8437>, <14.3992, 179.2072, 12.2827> }
					triangle { <13.9702, 178.7878, 12.8437>, <15.2044, 180.6832, 14.4449>, <14.3992, 179.2072, 12.2827> }
					triangle { <13.9702, 178.7878, 12.8437>, <14.5936, 180.0506, 14.08488>, <15.2044, 180.6832, 14.4449> }
					triangle { <15.2044, 180.6832, 14.4449>, <14.9464, 180.5421, 13.6496>, <14.3992, 179.2072, 12.2827> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <12.7466, 178.0792, 10.8412>, <14.6158, 178.5117, 12.3671>, <14.02253, 178.8926, 12.7884> }
					triangle { <14.6158, 178.5117, 12.3671>, <15.7731, 178.6516, 14.8812>, <14.02253, 178.8926, 12.7884> }
					triangle { <14.6158, 178.5117, 12.3671>, <15.5259, 178.3832, 14.00385>, <15.7731, 178.6516, 14.8812> }
					triangle { <15.7731, 178.6516, 14.8812>, <15.02195, 178.6421, 14.4879>, <14.02253, 178.8926, 12.7884> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <12.7466, 178.0792, 10.8412>, <14.3171, 179.3064, 12.2683>, <14.5463, 178.5419, 12.4624> }
					triangle { <14.3171, 179.3064, 12.2683>, <16.8241, 179.7758, 13.352>, <14.5463, 178.5419, 12.4624> }
					triangle { <14.3171, 179.3064, 12.2683>, <16.02682, 179.8319, 12.8382>, <16.8241, 179.7758, 13.352> }
					triangle { <16.8241, 179.7758, 13.352>, <16.3594, 179.1781, 12.9702>, <14.5463, 178.5419, 12.4624> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <9.09254, 176.713, 7.4958>, 0.5 }
				cylinder { <9.09254, 176.713, 7.4958>, <10.3622, 177.8464, 9.3723>, 0.5 }
				cylinder { <10.3622, 177.8464, 9.3723>, <11.632, 178.9798, 11.2487>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <11.632, 178.9798, 11.2487>, <12.4696, 179.9503, 13.338>, <12.9189, 180.39, 12.8094> }
					triangle { <12.4696, 179.9503, 13.338>, <13.2305, 182.0749, 14.9463>, <12.9189, 180.39, 12.8094> }
					triangle { <12.4696, 179.9503, 13.338>, <12.7567, 181.3498, 14.5558>, <13.2305, 182.0749, 14.9463> }
					triangle { <13.2305, 182.0749, 14.9463>, <13.105, 181.8579, 14.1363>, <12.9189, 180.39, 12.8094> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <11.632, 178.9798, 11.2487>, <13.2039, 179.7341, 12.9717>, <12.5161, 180.0578, 13.2827> }
					triangle { <13.2039, 179.7341, 12.9717>, <13.9737, 180.1612, 15.5994>, <12.5161, 180.0578, 13.2827> }
					triangle { <13.2039, 179.7341, 12.9717>, <13.8856, 179.8151, 14.7189>, <13.9737, 180.1612, 15.5994> }
					triangle { <13.9737, 180.1612, 15.5994>, <13.2914, 180.0329, 15.1125>, <12.5161, 180.0578, 13.2827> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <11.632, 178.9798, 11.2487>, <12.8283, 180.4768, 12.7773>, <13.1187, 179.7603, 13.05466> }
					triangle { <12.8283, 180.4768, 12.7773>, <15.08444, 181.3258, 14.1444>, <13.1187, 179.7603, 13.05466> }
					triangle { <12.8283, 180.4768, 12.7773>, <14.3657, 181.2497, 13.5275>, <15.08444, 181.3258, 14.1444> }
					triangle { <15.08444, 181.3258, 14.1444>, <14.753, 180.6528, 13.749>, <13.1187, 179.7603, 13.05466> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <8.6169, 176.9982, 7.5623>, 0.5 }
				cylinder { <8.6169, 176.9982, 7.5623>, <9.4111, 178.4167, 9.5051>, 0.5 }
				cylinder { <9.4111, 178.4167, 9.5051>, <10.2053, 179.8353, 11.448>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <10.2053, 179.8353, 11.448>, <10.5653, 181.0429, 13.5506>, <11.02866, 181.5105, 13.05949> }
					triangle { <10.5653, 181.0429, 13.5506>, <10.7702, 183.3497, 15.07271>, <11.02866, 181.5105, 13.05949> }
					triangle { <10.5653, 181.0429, 13.5506>, <10.4659, 182.5408, 14.6778>, <10.7702, 183.3497, 15.07271> }
					triangle { <10.7702, 183.3497, 15.07271>, <10.804, 183.0678, 14.2737>, <11.02866, 181.5105, 13.05949> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <10.2053, 179.8353, 11.448>, <11.3704, 180.9143, 13.3154>, <10.6049, 181.1524, 13.4941> }
					triangle { <11.3704, 180.9143, 13.3154>, <11.6526, 181.6082, 15.9835>, <10.6049, 181.1524, 13.4941> }
					triangle { <11.3704, 180.9143, 13.3154>, <11.7516, 181.2, 15.1311>, <11.6526, 181.6082, 15.9835> }
					triangle { <11.6526, 181.6082, 15.9835>, <11.07908, 181.3523, 15.4138>, <10.6049, 181.1524, 13.4941> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <10.2053, 179.8353, 11.448>, <10.9333, 181.581, 13.00737>, <11.2705, 180.9328, 13.3824> }
					triangle { <10.9333, 181.581, 13.00737>, <12.811, 182.8317, 14.6167>, <11.2705, 180.9328, 13.3824> }
					triangle { <10.9333, 181.581, 13.00737>, <12.2152, 182.6142, 13.9091>, <12.811, 182.8317, 14.6167> }
					triangle { <12.811, 182.8317, 14.6167>, <12.6398, 182.0948, 14.2337>, <11.2705, 180.9328, 13.3824> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <8.1611, 177.1942, 7.5421>, 0.5 }
				cylinder { <8.1611, 177.1942, 7.5421>, <8.4994, 178.8087, 9.4647>, 0.5 }
				cylinder { <8.4994, 178.8087, 9.4647>, <8.8377, 180.4232, 11.3874>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <8.8377, 180.4232, 11.3874>, <8.7524, 181.7815, 13.4262>, <9.2199, 182.2773, 12.9677> }
					triangle { <8.7524, 181.7815, 13.4262>, <8.4631, 184.1759, 14.791>, <9.2199, 182.2773, 12.9677> }
					triangle { <8.7524, 181.7815, 13.4262>, <8.3167, 183.3138, 14.4191>, <8.4631, 184.1759, 14.791> }
					triangle { <8.4631, 184.1759, 14.791>, <8.6418, 183.8571, 14.02598>, <9.2199, 182.2773, 12.9677> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <8.8377, 180.4232, 11.3874>, <9.5921, 181.7454, 13.3088>, <8.786, 181.8919, 13.3676> }
					triangle { <9.5921, 181.7454, 13.3088>, <9.4134, 182.6162, 15.9336>, <8.786, 181.8919, 13.3676> }
					triangle { <9.5921, 181.7454, 13.3088>, <9.6789, 182.1778, 15.1334>, <9.4134, 182.6162, 15.9336> }
					triangle { <9.4134, 182.6162, 15.9336>, <8.96, 182.2572, 15.3134>, <8.786, 181.8919, 13.3676> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <8.8377, 180.4232, 11.3874>, <9.125, 182.3318, 12.8985>, <9.4823, 181.7544, 13.3606> }
					triangle { <9.125, 182.3318, 12.8985>, <10.595, 183.9019, 14.646>, <9.4823, 181.7544, 13.3606> }
					triangle { <9.125, 182.3318, 12.8985>, <10.1344, 183.5704, 13.8839>, <10.595, 183.9019, 14.646> }
					triangle { <10.595, 183.9019, 14.646>, <10.5691, 183.129, 14.2982>, <9.4823, 181.7544, 13.3606> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <7.6336, 177.3402, 7.4312>, 0.5 }
				cylinder { <7.6336, 177.3402, 7.4312>, <7.4444, 179.1007, 9.243>, 0.5 }
				cylinder { <7.4444, 179.1007, 9.243>, <7.2552, 180.8612, 11.05478>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <7.2552, 180.8612, 11.05478>, <6.6678, 182.314, 12.9397>, <7.1305, 182.8439, 12.5157> }
					triangle { <6.6678, 182.314, 12.9397>, <5.8472, 184.7191, 14.0451>, <7.1305, 182.8439, 12.5157> }
					triangle { <6.6678, 182.314, 12.9397>, <5.8788, 183.8239, 13.7281>, <5.8472, 184.7191, 14.0451> }
					triangle { <5.8472, 184.7191, 14.0451>, <6.1854, 184.3838, 13.3435>, <7.1305, 182.8439, 12.5157> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <7.2552, 180.8612, 11.05478>, <7.5127, 182.3937, 12.9505>, <6.6951, 182.4244, 12.8778> }
					triangle { <7.5127, 182.3937, 12.9505>, <6.8076, 183.3872, 15.4396>, <6.6951, 182.4244, 12.8778> }
					triangle { <7.5127, 182.3937, 12.9505>, <7.2523, 182.9444, 14.7261>, <6.8076, 183.3872, 15.4396> }
					triangle { <6.8076, 183.3872, 15.4396>, <6.51, 182.9288, 14.7912>, <6.6951, 182.4244, 12.8778> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <7.2552, 180.8612, 11.05478>, <7.04121, 182.8797, 12.429>, <7.3959, 182.3897, 12.9847> }
					triangle { <7.04121, 182.8797, 12.429>, <7.9926, 184.7508, 14.2383>, <7.3959, 182.3897, 12.9847> }
					triangle { <7.04121, 182.8797, 12.429>, <7.7066, 184.3099, 13.4467>, <7.9926, 184.7508, 14.2383> }
					triangle { <7.9926, 184.7508, 14.2383>, <8.1262, 183.9627, 13.9554>, <7.3959, 182.3897, 12.9847> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <7.1153, 177.4006, 7.2322>, 0.5 }
				cylinder { <7.1153, 177.4006, 7.2322>, <6.4078, 179.2216, 8.8451>, 0.5 }
				cylinder { <6.4078, 179.2216, 8.8451>, <5.7003, 181.0426, 10.4579>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <5.7003, 181.0426, 10.4579>, <4.6332, 182.5061, 12.1097>, <5.08109, 183.071, 11.7161> }
					triangle { <4.6332, 182.5061, 12.1097>, <3.3321, 184.8284, 12.8802>, <5.08109, 183.071, 11.7161> }
					triangle { <4.6332, 182.5061, 12.1097>, <3.5337, 183.9298, 12.6462>, <3.3321, 184.8284, 12.8802> }
					triangle { <3.3321, 184.8284, 12.8802>, <3.8186, 184.504, 12.2661>, <5.08109, 183.071, 11.7161> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <5.7003, 181.0426, 10.4579>, <5.4473, 182.7087, 12.2381>, <4.6547, 182.6153, 12.04366> }
					triangle { <5.4473, 182.7087, 12.2381>, <4.232, 183.7382, 14.5059>, <4.6547, 182.6153, 12.04366> }
					triangle { <5.4473, 182.7087, 12.2381>, <4.839, 183.3224, 13.9045>, <4.232, 183.7382, 14.5059> }
					triangle { <4.232, 183.7382, 14.5059>, <4.1047, 183.2027, 13.8608>, <4.6547, 182.6153, 12.04366> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <5.7003, 181.0426, 10.4579>, <5.002528, 183.088, 11.6146>, <5.3282, 182.6898, 12.2549> }
					triangle { <5.002528, 183.088, 11.6146>, <5.3964, 185.1845, 13.3836>, <5.3282, 182.6898, 12.2549> }
					triangle { <5.002528, 183.088, 11.6146>, <5.3005, 184.6593, 12.5976>, <5.3964, 185.1845, 13.3836> }
					triangle { <5.3964, 185.1845, 13.3836>, <5.6778, 184.4086, 13.1894>, <5.3282, 182.6898, 12.2549> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <6.6827, 177.3801, 6.9892>, 0.5 }
				cylinder { <6.6827, 177.3801, 6.9892>, <5.5425, 179.1805, 8.359>, 0.5 }
				cylinder { <5.5425, 179.1805, 8.359>, <4.4024, 180.9809, 9.7288>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <4.4024, 180.9809, 9.7288>, <2.9467, 182.383, 11.1158>, <3.3736, 182.9785, 10.7446> }
					triangle { <2.9467, 182.383, 11.1158>, <1.2802, 184.5565, 11.5385>, <3.3736, 182.9785, 10.7446> }
					triangle { <2.9467, 182.383, 11.1158>, <1.6193, 183.68, 11.3986>, <1.2802, 184.5565, 11.5385> }
					triangle { <1.2802, 184.5565, 11.5385>, <1.8831, 184.2644, 11.01877>, <3.3736, 182.9785, 10.7446> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <4.4024, 180.9809, 9.7288>, <3.7044, 182.6961, 11.335>, <2.9639, 182.4903, 11.0454> }
					triangle { <3.7044, 182.6961, 11.335>, <2.06936, 183.6833, 13.3429>, <2.9639, 182.4903, 11.0454> }
					triangle { <3.7044, 182.6961, 11.335>, <2.8, 183.317, 12.8582>, <2.06936, 183.6833, 13.3429> }
					triangle { <2.06936, 183.6833, 13.3429>, <2.09886, 183.1011, 12.7271>, <2.9639, 182.4903, 11.0454> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <4.4024, 180.9809, 9.7288>, <3.3084, 182.9797, 10.6327>, <3.5873, 182.6629, 11.3374> }
					triangle { <3.3084, 182.9797, 10.6327>, <3.1958, 185.204, 12.2818>, <3.5873, 182.6629, 11.3374> }
					triangle { <3.3084, 182.9797, 10.6327>, <3.2746, 184.6281, 11.5301>, <3.1958, 185.204, 12.2818> }
					triangle { <3.1958, 185.204, 12.2818>, <3.5932, 184.4615, 12.1829>, <3.5873, 182.6629, 11.3374> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <6.2491, 177.2744, 6.6534>, 0.5 }
				cylinder { <6.2491, 177.2744, 6.6534>, <4.6755, 178.9691, 7.6875>, 0.5 }
				cylinder { <4.6755, 178.9691, 7.6875>, <3.1018, 180.6638, 8.7215>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <3.1018, 180.6638, 8.7215>, <1.2704, 181.9203, 9.7588>, <1.6661, 182.548, 9.4067> }
					triangle { <1.2704, 181.9203, 9.7588>, <-0.7195, 183.849, 9.7511>, <1.6661, 182.548, 9.4067> }
					triangle { <1.2704, 181.9203, 9.7588>, <-0.2475, 183.0244, 9.7354>, <-0.7195, 183.849, 9.7511> }
					triangle { <-0.7195, 183.849, 9.7511>, <-0.008521, 183.6169, 9.3516>, <1.6661, 182.548, 9.4067> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <3.1018, 180.6638, 8.7215>, <1.9349, 182.3533, 10.06063>, <1.2838, 182.0244, 9.6831> }
					triangle { <1.9349, 182.3533, 10.06063>, <-0.1135, 183.2117, 11.7178>, <1.2838, 182.0244, 9.6831> }
					triangle { <1.9349, 182.3533, 10.06063>, <0.7268, 182.9272, 11.3778>, <-0.1135, 183.2117, 11.7178> }
					triangle { <-0.1135, 183.2117, 11.7178>, <0.09067, 182.6037, 11.1632>, <1.2838, 182.0244, 9.6831> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <3.1018, 180.6638, 8.7215>, <1.6198, 182.5328, 9.2867>, <1.8245, 182.3036, 10.04847> }
					triangle { <1.6198, 182.5328, 9.2867>, <0.9502, 184.813, 10.7122>, <1.8245, 182.3036, 10.04847> }
					triangle { <1.6198, 182.5328, 9.2867>, <1.2232, 184.2102, 10.0304>, <0.9502, 184.813, 10.7122> }
					triangle { <0.9502, 184.813, 10.7122>, <1.4546, 184.1318, 10.7344>, <1.8245, 182.3036, 10.04847> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.9274, 177.1111, 6.3122>, 0.5 }
				cylinder { <5.9274, 177.1111, 6.3122>, <4.032, 178.6425, 7.005077>, 0.5 }
				cylinder { <4.032, 178.6425, 7.005077>, <2.1366, 180.1739, 7.6978>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <2.1366, 180.1739, 7.6978>, <0.04026, 181.2382, 8.3917>, <0.4025, 181.8914, 8.05022> }
					triangle { <0.04026, 181.2382, 8.3917>, <-2.1471, 182.8898, 7.9829>, <0.4025, 181.8914, 8.05022> }
					triangle { <0.04026, 181.2382, 8.3917>, <-1.5815, 182.1337, 8.08916>, <-2.1471, 182.8898, 7.9829> }
					triangle { <-2.1471, 182.8898, 7.9829>, <-1.3645, 182.7299, 7.6982>, <0.4025, 181.8914, 8.05022> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <2.1366, 180.1739, 7.6978>, <0.599, 181.7695, 8.7461>, <0.05146, 181.3388, 8.3111> }
					triangle { <0.599, 181.7695, 8.7461>, <-1.7491, 182.4459, 10.05316>, <0.05146, 181.3388, 8.3111> }
					triangle { <0.599, 181.7695, 8.7461>, <-0.8413, 182.2541, 9.848>, <-1.7491, 182.4459, 10.05316> }
					triangle { <-1.7491, 182.4459, 10.05316>, <-1.3976, 181.8397, 9.5756>, <0.05146, 181.3388, 8.3111> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <2.1366, 180.1739, 7.6978>, <0.3756, 181.8637, 7.9266>, <0.4982, 181.7053, 8.7232> }
					triangle { <0.3756, 181.8637, 7.9266>, <-0.7564, 184.1134, 9.083>, <0.4982, 181.7053, 8.7232> }
					triangle { <0.3756, 181.8637, 7.9266>, <-0.3202, 183.5142, 8.4883>, <-0.7564, 184.1134, 9.083> }
					triangle { <-0.7564, 184.1134, 9.083>, <-0.1815, 183.5054, 9.2205>, <0.4982, 181.7053, 8.7232> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.653, 176.8574, 5.8972>, 0.5 }
				cylinder { <5.653, 176.8574, 5.8972>, <3.4832, 178.1351, 6.175>, 0.5 }
				cylinder { <3.4832, 178.1351, 6.175>, <1.3134, 179.4128, 6.4528>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <1.3134, 179.4128, 6.4528>, <-0.9901, 180.2001, 6.7407>, <-0.67, 180.8772, 6.4034> }
					triangle { <-0.9901, 180.2001, 6.7407>, <-3.2885, 181.4869, 5.8798>, <-0.67, 180.8772, 6.4034> }
					triangle { <-0.9901, 180.2001, 6.7407>, <-2.6499, 180.8292, 6.13>, <-3.2885, 181.4869, 5.8798> }
					triangle { <-3.2885, 181.4869, 5.8798>, <-2.4566, 181.4259, 5.7274>, <-0.67, 180.8772, 6.4034> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <1.3134, 179.4128, 6.4528>, <-0.5708, 180.8278, 7.1284>, <-0.98, 180.2962, 6.6545> }
					triangle { <-0.5708, 180.8278, 7.1284>, <-3.1648, 181.2325, 8.01551>, <-0.98, 180.2962, 6.6545> }
					triangle { <-0.5708, 180.8278, 7.1284>, <-2.2186, 181.1632, 7.9626>, <-3.1648, 181.2325, 8.01551> }
					triangle { <-3.1648, 181.2325, 8.01551>, <-2.6641, 180.6562, 7.6465>, <-0.98, 180.2962, 6.6545> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <1.3134, 179.4128, 6.4528>, <-0.6732, 180.8384, 6.2799>, <-0.6572, 180.7483, 7.09624> }
					triangle { <-0.6732, 180.8384, 6.2799>, <-2.266, 182.9649, 7.06777>, <-0.6572, 180.7483, 7.09624> }
					triangle { <-0.6732, 180.8384, 6.2799>, <-1.6649, 182.4007, 6.5952>, <-2.266, 182.9649, 7.06777> }
					triangle { <-2.266, 182.9649, 7.06777>, <-1.6432, 182.4569, 7.338>, <-0.6572, 180.7483, 7.09624> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.4973, 176.5793, 5.5163>, 0.5 }
				cylinder { <5.4973, 176.5793, 5.5163>, <3.1718, 177.5789, 5.4133>, 0.5 }
				cylinder { <3.1718, 177.5789, 5.4133>, <0.8463, 178.5786, 5.3102>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <0.8463, 178.5786, 5.3102>, <-1.5527, 179.0758, 5.235>, <-1.2728, 179.769, 4.8947> }
					triangle { <-1.5527, 179.0758, 5.235>, <-3.8468, 180.0049, 3.9885>, <-1.2728, 179.769, 4.8947> }
					triangle { <-1.5527, 179.0758, 5.235>, <-3.1748, 179.4503, 4.3674>, <-3.8468, 180.0049, 3.9885> }
					triangle { <-3.8468, 180.0049, 3.9885>, <-3.000637, 180.0438, 3.9517>, <-1.2728, 179.769, 4.8947> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <0.8463, 178.5786, 5.3102>, <-1.2705, 179.773, 5.628>, <-1.5424, 179.1675, 5.1442> }
					triangle { <-1.2705, 179.773, 5.628>, <-3.9926, 179.8871, 6.1347>, <-1.5424, 179.1675, 5.1442> }
					triangle { <-1.2705, 179.773, 5.628>, <-3.04694, 179.9379, 6.2119>, <-3.9926, 179.8871, 6.1347> }
					triangle { <-3.9926, 179.8871, 6.1347>, <-3.3795, 179.3609, 5.8774>, <-1.5424, 179.1675, 5.1442> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <0.8463, 178.5786, 5.3102>, <-1.254, 179.7234, 4.775>, <-1.3413, 179.6814, 5.5906> }
					triangle { <-1.254, 179.7234, 4.775>, <-3.186, 181.6662, 5.1905>, <-1.3413, 179.6814, 5.5906> }
					triangle { <-1.254, 179.7234, 4.775>, <-2.4612, 181.1593, 4.8432>, <-3.186, 181.6662, 5.1905> }
					triangle { <-3.186, 181.6662, 5.1905>, <-2.5503, 181.2587, 5.5764>, <-1.3413, 179.6814, 5.5906> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.4291, 176.2211, 5.09336>, 0.5 }
				cylinder { <5.4291, 176.2211, 5.09336>, <3.03552, 176.8626, 4.5672>, 0.5 }
				cylinder { <3.03552, 176.8626, 4.5672>, <0.6418, 177.504, 4.04122>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <0.6418, 177.504, 4.04122>, <-1.7604, 177.6404, 3.5731>, <-1.5265, 178.345, 3.2217> }
					triangle { <-1.7604, 177.6404, 3.5731>, <-3.934, 178.1473, 1.9304>, <-1.5265, 178.345, 3.2217> }
					triangle { <-1.7604, 177.6404, 3.5731>, <-3.2613, 177.7207, 2.4485>, <-3.934, 178.1473, 1.9304> }
					triangle { <-3.934, 178.1473, 1.9304>, <-3.1056, 178.3068, 2.01545>, <-1.5265, 178.345, 3.2217> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <0.6418, 177.504, 4.04122>, <-1.6401, 178.3939, 3.9445>, <-1.7484, 177.7269, 3.4775> }
					triangle { <-1.6401, 178.3939, 3.9445>, <-4.3982, 178.1402, 4.03418>, <-1.7484, 177.7269, 3.4775> }
					triangle { <-1.6401, 178.3939, 3.9445>, <-3.4921, 178.3331, 4.2451>, <-4.3982, 178.1402, 4.03418> }
					triangle { <-4.3982, 178.1402, 4.03418>, <-3.687, 177.6944, 3.9142>, <-1.7484, 177.7269, 3.4775> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <0.6418, 177.504, 4.04122>, <-1.4831, 178.2954, 3.1102>, <-1.6912, 178.2908, 3.9048> }
					triangle { <-1.4831, 178.2954, 3.1102>, <-3.7006, 179.9571, 3.0755>, <-1.6912, 178.2908, 3.9048> }
					triangle { <-1.4831, 178.2954, 3.1102>, <-2.8686, 179.5412, 2.8815>, <-3.7006, 179.9571, 3.0755> }
					triangle { <-3.7006, 179.9571, 3.0755>, <-3.08452, 179.671, 3.5829>, <-1.6912, 178.2908, 3.9048> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.4662, 175.876, 4.7381>, 0.5 }
				cylinder { <5.4662, 175.876, 4.7381>, <3.1097, 176.1723, 3.8569>, 0.5 }
				cylinder { <3.1097, 176.1723, 3.8569>, <0.7531, 176.4687, 2.9757>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <0.7531, 176.4687, 2.9757>, <-1.559, 176.267, 2.1871>, <-1.3651, 176.9754, 1.8195> }
					triangle { <-1.559, 176.267, 2.1871>, <-3.5273, 176.3969, 0.2406>, <-1.3651, 176.9754, 1.8195> }
					triangle { <-1.559, 176.267, 2.1871>, <-2.887, 176.0902, 0.8722>, <-3.5273, 176.3969, 0.2406> }
					triangle { <-3.5273, 176.3969, 0.2406>, <-2.7442, 176.6667, 0.422>, <-1.3651, 176.9754, 1.8195> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <0.7531, 176.4687, 2.9757>, <-1.5836, 177.0491, 2.5157>, <-1.5443, 176.349, 2.08804> }
					triangle { <-1.5836, 177.0491, 2.5157>, <-4.2763, 176.446, 2.26>, <-1.5443, 176.349, 2.08804> }
					triangle { <-1.5836, 177.0491, 2.5157>, <-3.4383, 176.7659, 2.5738>, <-4.2763, 176.446, 2.26> }
					triangle { <-4.2763, 176.446, 2.26>, <-3.5067, 176.0901, 2.2671>, <-1.5443, 176.349, 2.08804> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <0.7531, 176.4687, 2.9757>, <-1.301, 176.9258, 1.7186>, <-1.6158, 176.9382, 2.4771> }
					triangle { <-1.301, 176.9258, 1.7186>, <-3.676, 178.2822, 1.2724>, <-1.6158, 176.9382, 2.4771> }
					triangle { <-1.301, 176.9258, 1.7186>, <-2.781, 177.9674, 1.2201>, <-3.676, 178.2822, 1.2724> }
					triangle { <-3.676, 178.2822, 1.2724>, <-3.1068, 178.1067, 1.8758>, <-1.6158, 176.9382, 2.4771> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.616, 175.4748, 4.3797>, 0.5 }
				cylinder { <5.616, 175.4748, 4.3797>, <3.4092, 175.37, 3.14>, 0.5 }
				cylinder { <3.4092, 175.37, 3.14>, <1.2024, 175.2651, 1.9003>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <1.2024, 175.2651, 1.9003>, <-0.9084, 174.6806, 0.7996>, <-0.7564, 175.3861, 0.4073> }
					triangle { <-0.9084, 174.6806, 0.7996>, <-2.5452, 174.4033, -1.4192>, <-0.7564, 175.3861, 0.4073> }
					triangle { <-0.9084, 174.6806, 0.7996>, <-1.9768, 174.2323, -0.6772>, <-2.5452, 174.4033, -1.4192> }
					triangle { <-2.5452, 174.4033, -1.4192>, <-1.8441, 174.7951, -1.1475>, <-0.7564, 175.3861, 0.4073> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <1.2024, 175.2651, 1.9003>, <-1.08953, 175.4693, 1.05535>, <-0.8894, 174.7577, 0.6973> }
					triangle { <-1.08953, 175.4693, 1.05535>, <-3.6022, 174.4653, 0.4569>, <-0.8894, 174.7577, 0.6973> }
					triangle { <-1.08953, 175.4693, 1.05535>, <-2.875, 174.9225, 0.8631>, <-3.6022, 174.4653, 0.4569> }
					triangle { <-3.6022, 174.4653, 0.4569>, <-2.8024, 174.2266, 0.6065>, <-0.8894, 174.7577, 0.6973> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <1.2024, 175.2651, 1.9003>, <-0.671, 175.3403, 0.3213>, <-1.1, 175.3528, 1.02175> }
					triangle { <-0.671, 175.3403, 0.3213>, <-3.1074, 176.3059, -0.5795>, <-1.1, 175.3528, 1.02175> }
					triangle { <-0.671, 175.3403, 0.3213>, <-2.1811, 176.1225, -0.4734>, <-3.1074, 176.3059, -0.5795> }
					triangle { <-3.1074, 176.3059, -0.5795>, <-2.6216, 176.2524, 0.1134>, <-1.1, 175.3528, 1.02175> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <5.8395, 175.1219, 4.1112>, 0.5 }
				cylinder { <5.8395, 175.1219, 4.1112>, <3.8562, 174.6641, 2.6029>, 0.5 }
				cylinder { <3.8562, 174.6641, 2.6029>, <1.8729, 174.2063, 1.09474>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <1.8729, 174.2063, 1.09474>, <0.02242, 173.2937, -0.2287>, <0.1414, 173.9901, -0.6476> }
					triangle { <0.02242, 173.2937, -0.2287>, <-1.2433, 172.6848, -2.6176>, <0.1414, 173.9901, -0.6476> }
					triangle { <0.02242, 173.2937, -0.2287>, <-0.7674, 172.63, -1.7969>, <-1.2433, 172.6848, -2.6176> }
					triangle { <-1.2433, 172.6848, -2.6176>, <-0.6393, 173.1784, -2.2851>, <0.1414, 173.9901, -0.6476> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <1.8729, 174.2063, 1.09474>, <-0.2864, 174.0652, -0.05679>, <0.046, 173.3668, -0.333> }
					triangle { <-0.2864, 174.0652, -0.05679>, <-2.5513, 172.7131, -0.9061>, <0.046, 173.3668, -0.333> }
					triangle { <-0.2864, 174.0652, -0.05679>, <-1.9484, 173.2822, -0.4419>, <-2.5513, 172.7131, -0.9061> }
					triangle { <-2.5513, 172.7131, -0.9061>, <-1.7574, 172.5884, -0.6358>, <0.046, 173.3668, -0.333> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <1.8729, 174.2063, 1.09474>, <0.2428, 173.9511, -0.718>, <-0.2779, 173.9466, -0.08296> }
					triangle { <0.2428, 173.9511, -0.718>, <-2.1424, 174.5422, -1.999>, <-0.2779, 173.9466, -0.08296> }
					triangle { <0.2428, 173.9511, -0.718>, <-1.2247, 174.4862, -1.759>, <-2.1424, 174.5422, -1.999> }
					triangle { <-2.1424, 174.5422, -1.999>, <-1.7553, 174.5902, -1.2461>, <-0.2779, 173.9466, -0.08296> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <6.1815, 174.7465, 3.8788>, 0.5 }
				cylinder { <6.1815, 174.7465, 3.8788>, <4.5402, 173.9133, 2.1382>, 0.5 }
				cylinder { <4.5402, 173.9133, 2.1382>, <2.8989, 173.0801, 0.3975>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <2.8989, 173.0801, 0.3975>, <1.4198, 171.8285, -1.1039>, <1.5081, 172.5081, -1.5567> }
					triangle { <1.4198, 171.8285, -1.1039>, <0.6394, 170.8972, -3.5945>, <1.5081, 172.5081, -1.5567> }
					triangle { <1.4198, 171.8285, -1.1039>, <0.9832, 170.9625, -2.7111>, <0.6394, 170.8972, -3.5945> }
					triangle { <0.6394, 170.8972, -3.5945>, <1.1114, 171.493, -3.2186>, <1.5081, 172.5081, -1.5567> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <2.8989, 173.0801, 0.3975>, <0.9865, 172.5557, -1.04347>, <1.4494, 171.8978, -1.2092> }
					triangle { <0.9865, 172.5557, -1.04347>, <-0.9132, 170.8384, -2.1023>, <1.4494, 171.8978, -1.2092> }
					triangle { <0.9865, 172.5557, -1.04347>, <-0.4732, 171.5166, -1.603>, <-0.9132, 170.8384, -2.1023> }
					triangle { <-0.9132, 170.8384, -2.1023>, <-0.1622, 170.8476, -1.7088>, <1.4494, 171.8978, -1.2092> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <2.8989, 173.0801, 0.3975>, <1.6237, 172.48, -1.608>, <1.01492, 172.4383, -1.05824> }
					triangle { <1.6237, 172.48, -1.608>, <-0.588, 172.6377, -3.2702>, <1.01492, 172.4383, -1.05824> }
					triangle { <1.6237, 172.48, -1.608>, <0.2795, 172.731, -2.8941>, <-0.588, 172.6377, -3.2702> }
					triangle { <-0.588, 172.6377, -3.2702>, <-0.3342, 172.7874, -2.4751>, <1.01492, 172.4383, -1.05824> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <6.553, 174.4463, 3.743>, 0.5 }
				cylinder { <6.553, 174.4463, 3.743>, <5.2833, 173.3129, 1.8665>, 0.5 }
				cylinder { <5.2833, 173.3129, 1.8665>, <4.01363, 172.1795, -0.009861>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <4.01363, 172.1795, -0.009861>, <2.9204, 170.666, -1.5983>, <2.9884, 171.3253, -2.08355> }
					triangle { <2.9204, 170.666, -1.5983>, <2.6133, 169.5055, -4.096>, <2.9884, 171.3253, -2.08355> }
					triangle { <2.9204, 170.666, -1.5983>, <2.82, 169.6634, -3.1821>, <2.6133, 169.5055, -4.096> }
					triangle { <2.6133, 169.5055, -4.096>, <2.9528, 170.1771, -3.7054>, <2.9884, 171.3253, -2.08355> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <4.01363, 172.1795, -0.009861>, <2.3984, 171.3333, -1.6481>, <2.9558, 170.7326, -1.7035> }
					triangle { <2.3984, 171.3333, -1.6481>, <0.8861, 169.3288, -2.8205>, <2.9558, 170.7326, -1.7035> }
					triangle { <2.3984, 171.3333, -1.6481>, <1.1671, 170.0848, -2.3181>, <0.8861, 169.3288, -2.8205> }
					triangle { <0.8861, 169.3288, -2.8205>, <1.5682, 169.4568, -2.3334>, <2.9558, 170.7326, -1.7035> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <4.01363, 172.1795, -0.009861>, <3.1125, 171.3096, -2.117>, <2.4425, 171.2199, -1.6504> }
					triangle { <3.1125, 171.3096, -2.117>, <1.1516, 171.0877, -4.06262>, <2.4425, 171.2199, -1.6504> }
					triangle { <3.1125, 171.3096, -2.117>, <1.9405, 171.3131, -3.5834>, <1.1516, 171.0877, -4.06262> }
					triangle { <1.1516, 171.0877, -4.06262>, <1.272, 171.3128, -3.254>, <2.4425, 171.2199, -1.6504> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <7.02863, 174.1611, 3.6765>, 0.5 }
				cylinder { <7.02863, 174.1611, 3.6765>, <6.2344, 172.7426, 1.7336>, 0.5 }
				cylinder { <6.2344, 172.7426, 1.7336>, <5.4402, 171.324, -0.2091>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <5.4402, 171.324, -0.2091>, <4.8247, 169.5734, -1.8109>, <4.8787, 170.2048, -2.3335> }
					triangle { <4.8247, 169.5734, -1.8109>, <5.07366, 168.2307, -4.2223>, <4.8787, 170.2048, -2.3335> }
					triangle { <4.8247, 169.5734, -1.8109>, <5.1108, 168.4724, -3.3041>, <5.07366, 168.2307, -4.2223> }
					triangle { <5.07366, 168.2307, -4.2223>, <5.2538, 168.9672, -3.8427>, <4.8787, 170.2048, -2.3335> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <5.4402, 171.324, -0.2091>, <4.2319, 170.1531, -1.9918>, <4.8669, 169.6379, -1.9149> }
					triangle { <4.2319, 170.1531, -1.9918>, <3.2071, 167.8818, -3.2046>, <4.8669, 169.6379, -1.9149> }
					triangle { <4.2319, 170.1531, -1.9918>, <3.3011, 168.6998, -2.7304>, <3.2071, 167.8818, -3.2046> }
					triangle { <3.2071, 167.8818, -3.2046>, <3.7806, 168.1374, -2.6346>, <4.8669, 169.6379, -1.9149> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <5.4402, 171.324, -0.2091>, <5.00747, 170.2054, -2.347>, <4.2907, 170.0474, -1.9783> }
					triangle { <5.00747, 170.2054, -2.347>, <3.425, 169.5818, -4.5348>, <4.2907, 170.0474, -1.9783> }
					triangle { <5.00747, 170.2054, -2.347>, <4.09113, 169.9486, -3.9651>, <3.425, 169.5818, -4.5348> }
					triangle { <3.425, 169.5818, -4.5348>, <3.3853, 169.8708, -3.7387>, <4.2907, 170.0474, -1.9783> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <7.4845, 173.9651, 3.6967>, 0.5 }
				cylinder { <7.4845, 173.9651, 3.6967>, <7.1462, 172.3506, 1.774>, 0.5 }
				cylinder { <7.1462, 172.3506, 1.774>, <6.8078, 170.7361, -0.1485>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <6.8078, 170.7361, -0.1485>, <6.6376, 168.8349, -1.6864>, <6.6874, 169.438, -2.2417> }
					triangle { <6.6376, 168.8349, -1.6864>, <7.3807, 167.4045, -3.9406>, <6.6874, 169.438, -2.2417> }
					triangle { <6.6376, 168.8349, -1.6864>, <7.26, 167.6993, -3.04547>, <7.3807, 167.4045, -3.9406> }
					triangle { <7.3807, 167.4045, -3.9406>, <7.416, 168.178, -3.595>, <6.6874, 169.438, -2.2417> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <6.8078, 170.7361, -0.1485>, <6.01027, 169.3221, -1.9851>, <6.6858, 168.8985, -1.7883> }
					triangle { <6.01027, 169.3221, -1.9851>, <5.4463, 166.8738, -3.1546>, <6.6858, 168.8985, -1.7883> }
					triangle { <6.01027, 169.3221, -1.9851>, <5.3738, 167.7221, -2.7326>, <5.4463, 166.8738, -3.1546> }
					triangle { <5.4463, 166.8738, -3.1546>, <5.8996, 167.2325, -2.5342>, <6.6858, 168.8985, -1.7883> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <6.8078, 170.7361, -0.1485>, <6.8157, 169.4546, -2.2381>, <6.07895, 169.2258, -1.9564> }
					triangle { <6.8157, 169.4546, -2.2381>, <5.641, 168.5116, -4.5642>, <6.07895, 169.2258, -1.9564> }
					triangle { <6.8157, 169.4546, -2.2381>, <6.1719, 168.9924, -3.9398>, <5.641, 168.5116, -4.5642> }
					triangle { <5.641, 168.5116, -4.5642>, <5.456, 168.8366, -3.8031>, <6.07895, 169.2258, -1.9564> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <8.01201, 173.8191, 3.8076>, 0.5 }
				cylinder { <8.01201, 173.8191, 3.8076>, <8.2012, 172.0586, 1.9958>, 0.5 }
				cylinder { <8.2012, 172.0586, 1.9958>, <8.3904, 170.2981, 0.184>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <8.3904, 170.2981, 0.184>, <8.7221, 168.3024, -1.2>, <8.7768, 168.8714, -1.7897> }
					triangle { <8.7221, 168.3024, -1.2>, <9.9966, 166.8613, -3.1947>, <8.7768, 168.8714, -1.7897> }
					triangle { <8.7221, 168.3024, -1.2>, <9.6979, 167.1892, -2.3543>, <9.9966, 166.8613, -3.1947> }
					triangle { <9.9966, 166.8613, -3.1947>, <9.8724, 167.6512, -2.9125>, <8.7768, 168.8714, -1.7897> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <8.3904, 170.2981, 0.184>, <8.08967, 168.6737, -1.6269>, <8.7768, 168.366, -1.2986> }
					triangle { <8.08967, 168.6737, -1.6269>, <8.05219, 166.1028, -2.6607>, <8.7768, 168.366, -1.2986> }
					triangle { <8.08967, 168.6737, -1.6269>, <7.8004, 166.9555, -2.3253>, <8.05219, 166.1028, -2.6607> }
					triangle { <8.05219, 166.1028, -2.6607>, <8.3496, 166.5609, -2.01214>, <8.7768, 168.366, -1.2986> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <8.3904, 170.2981, 0.184>, <8.8996, 168.9067, -1.7687>, <8.1653, 168.5904, -1.5805> }
					triangle { <8.8996, 168.9067, -1.7687>, <8.2433, 167.6627, -4.1565>, <8.1653, 168.5904, -1.5805> }
					triangle { <8.8996, 168.9067, -1.7687>, <8.5997, 168.2529, -3.5026>, <8.2433, 167.6627, -4.1565> }
					triangle { <8.2433, 167.6627, -4.1565>, <7.8989, 168.0029, -3.4603>, <8.1653, 168.5904, -1.5805> }
					texture{Wflower_Texture12}}
				}
			}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <7.8228, 175.5797, 5.6194>, <8.5303, 173.7587, 4.006598>, 0.5 }
				cylinder { <8.5303, 173.7587, 4.006598>, <9.2378, 171.9377, 2.3937>, 0.5 }
				cylinder { <9.2378, 171.9377, 2.3937>, <9.9453, 170.1167, 0.7809>, 0.5 }
				texture{Wflower_Texture11}}
			union { // flower
				mesh { // flower petal
					triangle { <9.9453, 170.1167, 0.7809>, <10.7567, 168.1103, -0.37>, <10.8262, 168.6443, -0.9902> }
					triangle { <10.7567, 168.1103, -0.37>, <12.5116, 166.752, -2.02985>, <10.8262, 168.6443, -0.9902> }
					triangle { <10.7567, 168.1103, -0.37>, <12.04311, 167.0834, -1.2725>, <12.5116, 166.752, -2.02985> }
					triangle { <12.5116, 166.752, -2.02985>, <12.2392, 167.531, -1.8351>, <10.8262, 168.6443, -0.9902> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <9.9453, 170.1167, 0.7809>, <10.155, 168.3587, -0.9144>, <10.8171, 168.1751, -0.4644> }
					triangle { <10.155, 168.3587, -0.9144>, <10.6277, 165.7518, -1.727>, <10.8171, 168.1751, -0.4644> }
					triangle { <10.155, 168.3587, -0.9144>, <10.2137, 166.5774, -1.5037>, <10.6277, 165.7518, -1.727> }
					triangle { <10.6277, 165.7518, -1.727>, <10.7549, 166.287, -1.08171>, <10.8171, 168.1751, -0.4644> }
					texture{Wflower_Texture12}}
				mesh { // flower petal
					triangle { <9.9453, 170.1167, 0.7809>, <10.9383, 168.6984, -0.9543>, <10.233, 168.2903, -0.8507> }
					triangle { <10.9383, 168.6984, -0.9543>, <10.8396, 167.229, -3.3018>, <10.233, 168.2903, -0.8507> }
					triangle { <10.9383, 168.6984, -0.9543>, <11.0058, 167.9036, -2.6536>, <10.8396, 167.229, -3.3018> }
					triangle { <10.8396, 167.229, -3.3018>, <10.3472, 167.557, -2.6943>, <10.233, 168.2903, -0.8507> }
					texture{Wflower_Texture12}}
				}
			}
		}
} // end another_daisy



/* 
#declare allPlants_wflowers = union { // all plants
	object { clover }
	object { Solomon_s_seal }
	object { Pink_daisy }
	object { another_daisy }
	}
*/ 
