// Persistence of Vision Ray Tracer Scene Description File
// Auth: Bob Franke
//

#version 3.1;
                  
#declare test=false; 
#declare showGrass=true; 
#declare showBarn=true;
#declare showWagon=true;
#declare sepia=false;  
#include "colors.inc" 
#include "finish.inc"  
#include "textures.inc" 
#include "ruintex.inc"

global_settings{
  assumed_gamma 2.2
   max_trace_level 60
}   


// ----------------------------------------
camera{
  location  <-5, 5+0, -30.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0, 5 , 0+0>
}  

                               
// the clouds 
// thanks to Jaime Vives Piqueres
// www.ctav.es/jaime
#include "i_stsky.inc"
#declare dark_color= grayScale(SkyBlue*.5+White*.5,sepia)
#declare light_color= grayScale(White*1.19,sepia) 


#declare height=8000;
#declare cloud_level=.5;
#declare planes=23;   //60
#declare pdist=30;
#declare ppatt=pigment{bumps}
#declare pturb=.9 + .1;
#declare pocta=9;
#declare plamb=3.5;
#declare pomeg=.55;
#declare tdist=30;
#declare sfactor=10000;
#declare dfactor=.8;
#declare border=.1;
#declare fstart=.75; //7
#declare fend=.95;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 5*y
 translate<0,0,0>
}



sky_sphere{  
  pigment  {
    gradient y  
    color_map { [0.0 grayScale(Blue+White*.3,sepia)] [1.0  grayScale(White*1.0,sepia) ] }    
  }
  rotate<-20,0,0>  
}

light_source{<-10, 75, -50>*100 color White*1.5}         
light_source{<30, 35, -150> color White*0.4 shadowless} 

#declare tree = union{          
  sphere{<0,-40,0>,100 scale<.4,0,.4>}
  sphere{<0,40,0>,30 } 
  sphere{<30,15,0>,60 scale<1,0.1,.4> rotate<0,0,-30>} 
  sphere{<-30,50,0>,60 scale<1,0.1,.4> rotate<0,0,-30>} 
  sphere{<0,0,0>,120 scale<.2,1,.2> rotate<0,0,15>} 
  sphere{<0,0,0>,120 scale<.1,1,.1> rotate<0,0,-20>} 
  sphere{<-30,20,-20>,30 } 
  sphere{<30,20,10>,30 } 
  pigment {
    bozo 
    turbulence .5 
    omega .75
    color_map {
        [0.0 rgbf <0.0, 0.1, 0.0, 0.0>]
        [0.5 rgbf <0.2, 0.4, 0.2, 0.0>]
        [0.6 rgbf <1.0, 1.0, 1.0, 1.0>]
        [1.0 rgbf <1.0, 1.0, 1.0, 1.0>] 
    }             
    scale 8
  }
  scale .3
} 
   
   
#if (showWagon)
  #declare notUseAsInclude = false;  
  #declare notIncludeWagon  = false; 
  #include "wagon.pov"
  object{wagon rotate<-15,0,1.5> rotate<0,45,0> translate<-.4,-1.0,0>}    
  object{woodRim scale<1,1,1.5>*.9 rotate<10,52,0> translate<-4,-.5,-5> finish { ambient .3}}          
  #declare notUseAsInclude = true; 
  #declare notIncludeWagon  = true; 
#end     



plane{y, -2.25 
  hollow on 
  pigment{grayScale(Yellow*.4 + Green*.1,sepia)}   
  rotate<.5,0,0> 
} 
     
// thanks to Chris Colefax for OBJECT BENDER      
#if (showBarn)
  #declare notUseAsInclude = false;     
  #include "barn2.pov"
  
// BEND OPTIONS
   #declare bend_object = object {barn }  
   #declare object_axis1 = <0,10,-1>;
   #declare object_axis2 = <0,10,55>;
   #declare bend_smoothness = 20;
   #declare bend_direction = <0, 1, 0>;
   #declare bend_angle = 10;  
// ONLY BEND MIDDLE SECTION OF STEM
   #declare bend_start = .1;
   #declare bend_finish = .9;

// CREATE BENT OBJECT
   object{#include "Bend.inc"  rotate<5,0,0>  rotate<0,-35,0>  translate<75,0,150>     }
//  object{barn  rotate<0,-35,0>  translate<75,0,150>  }
  #declare notUseAsInclude = true;     
#end  

// the grass
// thanks to Gilles Tran
//  http://www.mediaport.net/Artichaud/Tran/gtran.en.html
#if (showGrass)
  #include "mgrass.pov"      
  #declare Blanc1=rgb<0.90,0.81,0.81>;
  
  #declare Green1=rgb<230,170,50>/255;
  #declare Green2=rgb<110,160,8>/255;
  
  #declare Blanc1= grayScale(Blanc1,sepia)
  
  #declare Green1= grayScale(Green1,sepia)
  #declare Green2= grayScale(Green2,sepia) 
  
  
  
  // --------------------------------------
  // Grass texture
  // --------------------------------------
  #declare pigSpotted =pigment {
  spotted
      color_map {
          [0.0, 0.2   color grayScale(Tan*0.1,sepia) color grayScale(Tan*0.4,sepia)]
          [0.2, 0.3   color grayScale(Tan*0.4,sepia) color grayScale(Green1,sepia)]
          [0.3, 1.01  color grayScale(Green1,sepia) color grayScale(Green1*1.2,sepia)]
      }
  } 
  #declare pigEarth =pigment {
      spotted
      color_map {
          [0   grayScale(Tan*0.3,sepia)]
          [0.6 grayScale(Tan*0.3,sepia) ]
          [0.6 grayScale(Green1*0.4,sepia) ]
          [1   grayScale(Green1*0.4,sepia) ]
      }
  }  
  
  #declare pigGreen=pigment{Green2*1.3}
  #declare txtGrass=
    texture {                  
     pigment {
       gradient y
       turbulence 0.2
       pigment_map {                                
         [0.0 pigEarth]
         [0.3 pigGreen]
         [0.9 pigSpotted]
         [1.00 pigEarth]
       }
     }
     finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
     scale <0.001,1,0.001>
   }
                               
  // --------------------------------------
  // Patch parameters
  // --------------------------------------
  // Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
  // --------------------------------------
  #declare lPatch=50;               // size of patch
  #declare nBlade=10;                // number of blades per line (there will be nBlade x nBlade blades)
  #declare ryBlade = 0;            // initial y rotation of blade
  #declare segBlade= 15;            // number of blade segments
  #declare lBlade = 25;             // length of blade
  #declare wBlade = 1/10;              // width of blade at start
  #declare wBladeEnd = 0.3;         // width of blade at the end
  #declare doSmooth=false;          // true makes smooth triangles
  #declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
  #declare vBend = <0,-0.5,0>;         // force bending the blade (<0,1,1> = 45)
  #declare pwBend = 3;              // bending power (how slowly the curve bends)
  #declare rd = 459;                // seed
  #declare stdposBlade = 1;         // standard deviation of blade position 0..1
  #declare stdrotBlade = 360;       // standard deviation of rotation
  #declare stdBlade = 1.2;           // standard deviation of blade scale;
  #declare stdBend = 2.25;            // standard deviation of blade bending;
  #declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
  #declare dofile = true;          // true creates a mesh file
  #declare fname = "fgrass1.inc"     // name of the mesh file to create
  
  // --------------------------------------
  // Prairie parameters
  // --------------------------------------
  #declare nxPrairie=40;             // number of patches for the first line
  #declare addPatches=1;            // number of patches to add at each line
  #declare nzPrairie=300;             // number of lines of patches
  #declare rd=seed(779);            // random seed
  #declare stdscale=1;              // stddev of scale
  #declare stdrotate=1;             // stddev of rotation
  #declare doTest=false;            // replaces the patch with a sphere
  
  // --------------------------------------
  // Create the patch and the prairie
  // --------------------------------------
  #if (dofile=true) // if the patch is already created, turn off the next line
  //        MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
          #declare objectPatch=#include fname
  #else        
          #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
  #end        

  object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
  texture{txtGrass scale 40}
  scale<.05,.1,.05>
   translate<0,-2.5,-10>
  }  
   
  #declare nxPrairie=50;             // number of patches for the first line
  #declare addPatches=1;            // number of patches to add at each line
  #declare nzPrairie=1;             // number of lines of patches
  #declare rd=seed(555);            // random seed
  #declare stdscale=1;              // stddev of scale
  #declare stdrotate=1;             // stddev of rotation
  #declare doTest=false;            // replaces the patch with a sphere
  
  // --------------------------------------
  // Create the patch and the prairie
  // --------------------------------------
  #if (dofile=true) // if the patch is already created, turn off the next line
  //        MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
          #declare objectPatch=#include fname
  #else        
          #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
  #end        
  

  object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
    texture{txtGrass scale 40}
    scale<.05,.1,.05>
    translate<0,-2.5,-10>
  }  
  
   
    height_field {
      tga "hills.tga"
      water_level .1
      pigment{grayScale(Yellow*.4 + Green*.1,sepia)}  
      translate <-.5, 0, -.5>    
      scale <800, 18, 500>  
      translate <125-100,-7,400>*1.5      
    }  
    
  #include "hillgras.inc"
  object{ hillGrass 
    translate<-400,0,-250>
    translate <125-100,-5.5,400>*1.5
  }  
#end // #if showGrass   



fog{
  color rgbft <.6, 0.6,.8,0, 0>
  fog_type 2
  fog_alt 150
  fog_offset -900
  distance 500
}
  
// add distant trees  
#declare yy = seed(4844);      
#declare xx = -900;
#while (xx < 150)      
  object{tree  rotate<0,rand(yy)*360,0> translate<xx + rand(yy)*5,-35 + rand(yy)*100,3200>}    
  #declare xx = xx + 5;
#end 