 // Persistence of Vision Ray Tracer Scene Description File
// Auth: Bob Franke
//

#version 3.1;

//#declare notUseAsInclude = true;

#if (notUseAsInclude)  

  global_settings{
    assumed_gamma 2.2
  }  

  #include "colors.inc"
  #include "textures.inc"                    
  #include "finish.inc"    
  #include "ruintex.inc"
  
  camera{
    location  <0, 4,-10>
    direction 1.5*z  
    right     4/3*x
    look_at   <0.0, 0.0, 0.0>
  }
  
  sky_sphere{
    pigment{
      gradient y
      color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
    }
  }
  
  light_source{    
    <-10, 100, -30>
    color White*2 // light's color
  }
#end //#if (notUseAsInclude)  


#declare xcone=
cone {
  <0, 0, 1>, .3535   // Center and radius of one end
  <0, 0, 0>, .25    // Center and radius of other end   
} 

#declare frontAxle=
union{
  union{
    box{<-.25,2/12,3>,<.25,8/12,-3>}
    intersection{
      box{<-.25,2/12,4>,<.25,8/12,-4>}
      object{xcone translate<0,5/12,-4>}
    }
    cylinder{<0,5/12,-4>,<0,5/12,-4.5>, .25}  
    cylinder{<0,5/12,4>,<0,5/12,4.5>, .25}  
    
    intersection{
      box{<-.25,2/12,4>,<.25,8/12,-4> }
      object{xcone rotate<0,180,0> translate<0,5/12,4>}
    }  
    texture{topRailTexture}                       
  }  
  #include "wheel2.pov"
  object{woodRim scale<1,1,1.5>  translate<0,5/12,4.5> finish { ambient .3}}

  box{<-2,2/12,1.75>,<-1.75,-4/12,-1.75>  }
  box{<0,2/12,-.75>,<-5,-4/12,-.5>  texture{mossyOldWood rotate<90,0,0>} rotate<0,-10,0> translate<3,0,0> }
  box{<0,2/12,.75>,<-5,-4/12,.5> texture{mossyOldWood rotate<90,0,0>} rotate<0,10,0> translate<3,0,0> }
  
  union{
    box{<1,2/12,-.25>,<12,-4/12,.25> texture{mossyOldWood rotate<90,0,0>}} 
    cylinder{<2.75,-1/12,-.9>,<2.75,-1/12,.9>,.125  pigment{Black}} 
    cylinder{<1.25,-1/12,-.65>,<1.25,-1/12,.65>,.125  pigment{Black}} 
  
    box{<0,2/12,-.25>,<-5,-4/12,-.375> texture{mossyOldWood rotate<90,0,0>}   rotate<0,-3,0> translate<6,0,0> } 
    box{<0,2/12,.25>,<-5,-4/12,.375> texture{mossyOldWood rotate<90,0,0>}   rotate<0,3,0> translate<6,0,0>}  
    translate<-2.75,1/12,0> rotate<0,0,7> translate<2.75,-1/12,0>
  }
}  


#if (notUseAsInclude) 
  object{frontAxle translate<0,5/12,0> rotate<0,0,0>}      
#end 






 



