//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 20 materials and 8969 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 02/28/2000    (28.02.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from ship.mdl:
This scene was created with Moray V3.2 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.424> }

fog {
  fog_type 1    // Constant
  distance     3500.0
  color <0.541176,0.6,0.788235,0.121569,-0.121569>
}

camera {  //  Camera StdCam
  location  <   -165.374,    -235.692,      16.183>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38377,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         55.32631    // Vertical      41.495
  look_at   <    -16.717,       8.088,      53.104>
}

//
// *******  L I G H T S *******
//

light_source {   // Sunlight
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.8000
  translate  <-111.546772, 662.033024, 344.905447>
}

light_source {   // Light2Maufhellen
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.900>*0.5000
  translate  <-714.63476, 226.15344, 191.896975>
}

light_source {   // Light1Maufhellen
  <0.0, 0.0, 0.0>
  color rgb <0.857, 0.943, 1.000>*0.4000
  translate  <553.572193, -443.024503, 248.722151>
}


//
// ********  MATERIALS  *******
//

#include "sea-scene.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare wave = object { 
  height_field {
    tga "E:\Projekte\oilrigg\wave-05-big copy.TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    waveMskin
  }
  hollow
  scale <200.0, 200.0, 1.0>
  translate  <-38.243238, -38.243238, 2.0>
}


#declare endMpart17 = union {
  cylinder { // Cylndr1356
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1357
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1358
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube4038
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube4039
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube4040
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-26.294875, 11.925657, 0.108806>
}
#declare Group154 = union {
  box { // Cube4041
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4042
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4043
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1359
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group155 = union {
  box { // Cube4044
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4045
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4046
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1360
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group156 = union {
  box { // Cube4047
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4048
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4049
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1361
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart51 = union {
  object { Group154 }
  object { Group155 }
  object { Group156 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group157 = union {
  box { // Cube4050
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4051
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4052
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1362
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group158 = union {
  box { // Cube4053
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4054
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4055
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1363
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group159 = union {
  box { // Cube4056
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4057
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4058
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1364
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart52 = union {
  object { Group157 }
  object { Group158 }
  object { Group159 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group160 = union {
  box { // Cube4059
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4060
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4061
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1365
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group161 = union {
  box { // Cube4062
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4063
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4064
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1366
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group162 = union {
  box { // Cube4065
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4066
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4067
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1367
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart53 = union {
  object { Group160 }
  object { Group161 }
  object { Group162 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare Group163 = union {
  box { // Cube4068
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4069
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4070
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1368
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group164 = union {
  box { // Cube4071
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4072
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4073
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1369
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group165 = union {
  box { // Cube4074
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4075
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4076
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1370
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart54 = union {
  object { Group163 }
  object { Group164 }
  object { Group165 }
  translate  <-27.794253, 11.919136, 8.046751>
}
#declare Group166 = union {
  box { // Cube4077
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4078
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4079
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1371
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group167 = union {
  box { // Cube4080
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4081
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4082
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1372
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group168 = union {
  box { // Cube4083
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4084
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4085
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1373
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart55 = union {
  object { Group166 }
  object { Group167 }
  object { Group168 }
  translate  <-27.794253, 11.919136, 4.046751>
}
#declare Group169 = union {
  box { // Cube4086
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4087
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4088
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1374
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group170 = union {
  box { // Cube4089
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4090
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4091
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1375
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group171 = union {
  box { // Cube4092
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube4093
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube4094
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1376
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart56 = union {
  object { Group169 }
  object { Group170 }
  object { Group171 }
  translate  <-27.794253, 11.919136, 0.046751>
}
#declare endMpart18 = union {
  cylinder { // Cylndr1377
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1378
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1379
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube4095
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube4096
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube4097
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger6 = union {
  cylinder { // Cylndr1355
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { endMpart17 }
  object { StrebeMpart51 }
  object { StrebeMpart52 }
  object { StrebeMpart53 }
  object { StrebeMpart54 }
  object { StrebeMpart55 }
  object { StrebeMpart56 }
  object { endMpart18 }
  rotate <-0.0, -0.0, -0.0>
  translate  <27.043577, -12.351519, 2.615767>
  scale <2.307692, 5.0, 1.538462>
  rotate <-90.0, 0.0, -45.0>
  translate  <-15.984255, -15.877198, -2.639776>
}


#declare Group199 = union {
  box { // Cube5995
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube5996
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube5997
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2099
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group200 = union {
  box { // Cube5998
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube5999
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6000
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2100
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group201 = union {
  box { // Cube6001
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6002
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6003
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2101
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart66 = union {
  object { Group199 }
  object { Group200 }
  object { Group201 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group202 = union {
  box { // Cube6004
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6005
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6006
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2102
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group203 = union {
  box { // Cube6007
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6008
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6009
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2103
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group204 = union {
  box { // Cube6010
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6011
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6012
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2104
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart67 = union {
  object { Group202 }
  object { Group203 }
  object { Group204 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group205 = union {
  box { // Cube6013
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6014
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6015
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2105
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group206 = union {
  box { // Cube6016
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6017
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6018
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2106
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group207 = union {
  box { // Cube6019
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6020
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6021
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2107
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart68 = union {
  object { Group205 }
  object { Group206 }
  object { Group207 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare endMpart22 = union {
  cylinder { // Cylndr2108
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr2109
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr2110
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube6022
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube6023
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube6024
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger10 = union {
  cylinder { // Cylndr2098
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { StrebeMpart66 }
  object { StrebeMpart67 }
  object { StrebeMpart68 }
  object { endMpart22 }
  rotate <-0.0, -0.0, -0.0>
  translate  <26.71912, -12.14948, -13.678116>
  scale <3.0, 3.0, 2.0>
  rotate <11.069156, 17.135855, 33.58326>
  translate  <2.141127, -0.140388, 6.685507>
}
#declare endMpart23 = union {
  cylinder { // Cylndr2114
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr2115
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr2116
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube6026
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube6027
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube6028
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-26.294875, 11.925657, 0.108806>
}
#declare Group208 = union {
  box { // Cube6029
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6030
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6031
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2117
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group209 = union {
  box { // Cube6032
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6033
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6034
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2118
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group210 = union {
  box { // Cube6035
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6036
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6037
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2119
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart69 = union {
  object { Group208 }
  object { Group209 }
  object { Group210 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group211 = union {
  box { // Cube6038
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6039
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6040
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2120
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group212 = union {
  box { // Cube6041
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6042
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6043
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2121
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group213 = union {
  box { // Cube6044
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6045
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6046
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2122
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart70 = union {
  object { Group211 }
  object { Group212 }
  object { Group213 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group214 = union {
  box { // Cube6047
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6048
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6049
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2123
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group215 = union {
  box { // Cube6050
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6051
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6052
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2124
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group216 = union {
  box { // Cube6053
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6054
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6055
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2125
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart71 = union {
  object { Group214 }
  object { Group215 }
  object { Group216 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare Group217 = union {
  box { // Cube6056
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6057
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6058
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2126
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group218 = union {
  box { // Cube6059
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6060
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6061
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2127
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group219 = union {
  box { // Cube6062
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6063
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6064
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2128
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart72 = union {
  object { Group217 }
  object { Group218 }
  object { Group219 }
  translate  <-27.794253, 11.919136, 8.046751>
}
#declare Group220 = union {
  box { // Cube6065
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6066
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6067
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2129
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group221 = union {
  box { // Cube6068
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6069
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6070
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2130
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group222 = union {
  box { // Cube6071
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6072
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6073
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2131
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart73 = union {
  object { Group220 }
  object { Group221 }
  object { Group222 }
  translate  <-27.794253, 11.919136, 4.046751>
}
#declare Group223 = union {
  box { // Cube6074
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6075
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6076
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2132
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group224 = union {
  box { // Cube6077
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6078
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6079
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2133
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group225 = union {
  box { // Cube6080
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6081
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6082
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2134
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart74 = union {
  object { Group223 }
  object { Group224 }
  object { Group225 }
  translate  <-27.794253, 11.919136, 0.046751>
}
#declare endMpart24 = union {
  cylinder { // Cylndr2135
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr2136
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr2137
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube6083
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube6084
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube6085
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger11 = union {
  cylinder { // Cylndr2113
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { endMpart23 }
  object { StrebeMpart69 }
  object { StrebeMpart70 }
  object { StrebeMpart71 }
  object { StrebeMpart72 }
  object { StrebeMpart73 }
  object { StrebeMpart74 }
  object { endMpart24 }
  rotate <-0.0, -0.0, -0.0>
  translate  <27.043577, -12.351519, 2.615767>
  scale 3.0
  rotate <9.647342, -17.210249, -29.87809>
  translate  <-7.800329, 0.015998, 5.158919>
}
#declare krahn4 = union {
  cylinder { // Cylndr2095
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    scale <0.2, 0.2, 50.0>
    rotate -45.612755*y
    translate  <7.513612, 1.251085, 28.076141>
  }
  cylinder { // Cylndr2096
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    scale <0.2, 0.2, 50.0>
    rotate -45.612755*y
    translate  <7.669998, -1.563857, 28.076141>
  }
  cylinder { // Cylndr2097
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <2.0, 2.0, 6.0>
    rotate -90.0*x
    translate  <7.695465, -3.127714, 26.999318>
  }
  object { ausleger10 }
  cylinder { // Cylndr2111
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <5.0, 5.0, 2.0>
    translate  <-2.289882, 0.0, -10.0>
  }
  cylinder { // Cylndr2112
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <4.0, 4.0, 40.0>
    translate  <-2.249829, 0.824209, -40.743385>
  }
  box { // Cube6025
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <4.0, 4.0, 2.0>
    translate  <-3.446197, 0.0, 6.203155>
  }
  object { ausleger11 }
  box { // Cube6086
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <4.0, 6.0, 4.0>
    rotate -8.018505*y
    translate  <-12.176691, 0.0, -0.974012>
  }
  box { // Cube6087
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <10.0, 8.0, 5.0>
  }
  scale 0.5
  rotate <0.0, 0.0, -87.21785>
  translate  <93.545774, 86.659953, 109.291317>
}
#declare endMpart25 = union {
  cylinder { // Cylndr2139
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr2140
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr2141
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube6088
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube6089
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube6090
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-26.294875, 11.925657, 0.108806>
}
#declare Group226 = union {
  box { // Cube6091
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6092
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6093
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2142
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group227 = union {
  box { // Cube6094
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6095
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6096
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2143
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group228 = union {
  box { // Cube6097
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6098
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6099
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2144
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart75 = union {
  object { Group226 }
  object { Group227 }
  object { Group228 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group229 = union {
  box { // Cube6100
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6101
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6102
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2145
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group230 = union {
  box { // Cube6103
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6104
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6105
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2146
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group231 = union {
  box { // Cube6106
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6107
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6108
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2147
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart76 = union {
  object { Group229 }
  object { Group230 }
  object { Group231 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group232 = union {
  box { // Cube6109
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6110
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6111
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2148
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group233 = union {
  box { // Cube6112
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6113
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6114
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2149
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group234 = union {
  box { // Cube6115
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6116
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6117
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2150
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart77 = union {
  object { Group232 }
  object { Group233 }
  object { Group234 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare Group235 = union {
  box { // Cube6118
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6119
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6120
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2151
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group236 = union {
  box { // Cube6121
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6122
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6123
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2152
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group237 = union {
  box { // Cube6124
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6125
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6126
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2153
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart78 = union {
  object { Group235 }
  object { Group236 }
  object { Group237 }
  translate  <-27.794253, 11.919136, 8.046751>
}
#declare Group238 = union {
  box { // Cube6127
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6128
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6129
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2154
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group239 = union {
  box { // Cube6130
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6131
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6132
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2155
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group240 = union {
  box { // Cube6133
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6134
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6135
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2156
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart79 = union {
  object { Group238 }
  object { Group239 }
  object { Group240 }
  translate  <-27.794253, 11.919136, 4.046751>
}
#declare Group241 = union {
  box { // Cube6136
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6137
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6138
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2157
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group242 = union {
  box { // Cube6139
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6140
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6141
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2158
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group243 = union {
  box { // Cube6142
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube6143
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube6144
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr2159
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart80 = union {
  object { Group241 }
  object { Group242 }
  object { Group243 }
  translate  <-27.794253, 11.919136, 0.046751>
}
#declare endMpart26 = union {
  cylinder { // Cylndr2160
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr2161
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr2162
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube6145
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube6146
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube6147
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger12 = union {
  cylinder { // Cylndr2138
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { endMpart25 }
  object { StrebeMpart75 }
  object { StrebeMpart76 }
  object { StrebeMpart77 }
  object { StrebeMpart78 }
  object { StrebeMpart79 }
  object { StrebeMpart80 }
  object { endMpart26 }
  rotate <-0.0, -0.0, -0.0>
  translate  <27.043577, -12.351519, 2.615767>
  scale <2.307692, 5.0, 1.538462>
  rotate <-90.0, 0.0, -45.0>
  translate  <-15.984255, -15.877198, -2.639776>
}




//
// ********  OBJECTS  *******
//

#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <-165.374, -235.692, 16.183>;  // using camera 'StdCam'
#declare lookat = <-16.717, 8.088, 53.104>;
#declare light_loc = <-111.54677, 662.03302, 344.90545>;  // using light source 'Sunlight'

#declare flare_size = 1.500;
#declare bright_background = 0;
#declare flare_brightness = 0.600;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\TV-Day2.flr"
#include "NKFlare\nkflare.inc"






union { // surrounding
  sphere { // skyMsphere
    <0,0,0>,1
    material {
      Dark_Cloud_Sky
    }
    hollow
    scale 1000.0
  }
  object { wave }
  object { // wave1->wave
    wave
    translate  380.229877*y
  }
  object { // wave2->wave
    wave
    translate  <388.586578, 0.0, 0.0>
  }
  object { // wave3->wave
    wave
    translate  <388.586578, 384.408228, 0.0>
  }
  hollow
}




#declare chimneyMpart2 = union {
  box { // Cube3380
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 104.0>
  }
  box { // Cube3381
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 100.0>
  }
  box { // Cube3382
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 96.0>
  }
  box { // Cube3383
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 92.0>
  }
  box { // Cube3384
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 88.0>
  }
  box { // Cube3385
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 84.0>
  }
  box { // Cube3386
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 80.0>
  }
  box { // Cube3387
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 76.0>
  }
  box { // Cube3388
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 72.0>
  }
  box { // Cube3389
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 68.0>
  }
  box { // Cube3390
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 64.0>
  }
  box { // Cube3392
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 60.0>
  }
  box { // Cube3393
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
  rotate -90.0*z
  translate  <3.837424, 114.036317, 0.0>
}
#declare chimneyMpart1 = union {
  box { // Cube3366
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 104.0>
  }
  box { // Cube3367
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 100.0>
  }
  box { // Cube3368
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 96.0>
  }
  box { // Cube3369
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 92.0>
  }
  box { // Cube3370
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 88.0>
  }
  box { // Cube3371
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 84.0>
  }
  box { // Cube3372
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 80.0>
  }
  box { // Cube3373
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 76.0>
  }
  box { // Cube3374
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 72.0>
  }
  box { // Cube3375
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 68.0>
  }
  box { // Cube3376
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 64.0>
  }
  box { // Cube3378
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 60.0>
  }
  box { // Cube3379
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
  rotate -90.0*z
  translate  <3.837424, 74.036317, 0.0>
}
#declare chimneyMpart = union {
  box { // Cube3365
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 104.0>
  }
  box { // Cube3364
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 100.0>
  }
  box { // Cube3363
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 96.0>
  }
  box { // Cube3362
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 92.0>
  }
  box { // Cube3361
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 88.0>
  }
  box { // Cube3360
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 84.0>
  }
  box { // Cube3359
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 80.0>
  }
  box { // Cube3358
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 76.0>
  }
  box { // Cube3357
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 72.0>
  }
  box { // Cube3356
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 68.0>
  }
  box { // Cube3355
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 64.0>
  }
  box { // Cube3353
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 60.0>
  }
  box { // Cube3352
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
}
#declare railMpart222 = union {
  box { // Cube2517
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2518
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2519
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2520
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2521
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2522
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2523
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart223 = union {
  box { // Cube2524
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2525
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2526
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2527
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2528
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2529
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2530
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart224 = union {
  box { // Cube2531
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2532
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2533
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2534
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2535
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2536
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2537
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart225 = union {
  box { // Cube2538
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2539
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2540
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2541
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2542
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2543
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2544
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart226 = union {
  box { // Cube2545
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2546
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2547
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2548
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2549
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2550
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2551
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart227 = union {
  box { // Cube2552
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2553
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2554
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2555
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2556
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2557
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2558
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart228 = union {
  box { // Cube2559
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2560
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2561
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2562
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2563
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2564
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2565
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart229 = union {
  box { // Cube2566
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2567
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2568
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2569
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2570
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2571
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2572
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart230 = union {
  box { // Cube2573
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2574
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2575
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2576
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2577
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2578
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2579
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart231 = union {
  box { // Cube2580
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2581
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2582
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2583
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2584
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2585
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2586
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup21 = union {
  object { railMpart222 }
  object { railMpart223 }
  object { railMpart224 }
  object { railMpart225 }
  object { railMpart226 }
  object { railMpart227 }
  object { railMpart228 }
  object { railMpart229 }
  object { railMpart230 }
  object { railMpart231 }
}
#declare windowMpart168 = union {
  box { // Cube2588
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2589
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2590
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr855
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr856
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2591
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2592
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr857
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr858
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart169 = union {
  box { // Cube2593
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2594
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2595
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr859
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr860
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2596
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2597
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr861
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr862
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart170 = union {
  box { // Cube2598
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2599
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2600
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr863
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr864
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2601
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2602
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr865
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr866
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart171 = union {
  box { // Cube2603
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2604
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2605
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr867
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr868
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2606
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2607
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr869
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr870
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart172 = union {
  box { // Cube2608
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2609
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2610
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr871
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr872
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2611
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2612
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr873
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr874
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart173 = union {
  box { // Cube2613
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2614
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2615
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr875
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr876
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2616
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2617
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr877
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr878
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart174 = union {
  box { // Cube2618
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2619
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2620
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr879
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr880
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2621
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2622
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr881
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr882
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart175 = union {
  box { // Cube2627
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2628
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2629
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr883
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr884
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2630
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2631
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr885
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr886
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock21 = union {
  object { railingMgroup21 }
  box { // Cube2587
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart168 }
  object { windowMpart169 }
  object { windowMpart170 }
  object { windowMpart171 }
  object { windowMpart172 }
  object { windowMpart173 }
  object { windowMpart174 }
  box { // Cube2623
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2624
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2625
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2626
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart175 }
  rotate 180.0*z
  translate  <53.71575, 94.0, 73.165269>
}
#declare railMpart232 = union {
  box { // Cube2632
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2633
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2634
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2635
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2636
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2637
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2638
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart233 = union {
  box { // Cube2639
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2640
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2641
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2642
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2643
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2644
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2645
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner6 = union {
  object { railMpart232 }
  object { railMpart233 }
  box { // Cube2646
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
  rotate -90.0*z
  translate  <0.479885, 107.73253, 0.0>
}
#declare railMpart234 = union {
  box { // Cube2647
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2648
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2649
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2650
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2651
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2652
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2653
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart235 = union {
  box { // Cube2654
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2655
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2656
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2657
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2658
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2659
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2660
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart236 = union {
  box { // Cube2661
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2662
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2663
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2664
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2665
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2666
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2667
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart237 = union {
  box { // Cube2668
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2669
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2670
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2671
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2672
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2673
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2674
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart238 = union {
  box { // Cube2675
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2676
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2677
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2678
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2679
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2680
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2681
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart239 = union {
  box { // Cube2682
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2683
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2684
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2685
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2686
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2687
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2688
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart240 = union {
  box { // Cube2689
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2690
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2691
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2692
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2693
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2694
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2695
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart241 = union {
  box { // Cube2696
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2697
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2698
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2699
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2700
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2701
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2702
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart242 = union {
  box { // Cube2703
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2704
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2705
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2706
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2707
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2708
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2709
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart243 = union {
  box { // Cube2710
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2711
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2712
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2713
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2714
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2715
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2716
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup22 = union {
  object { railMpart234 }
  object { railMpart235 }
  object { railMpart236 }
  object { railMpart237 }
  object { railMpart238 }
  object { railMpart239 }
  object { railMpart240 }
  object { railMpart241 }
  object { railMpart242 }
  object { railMpart243 }
}
#declare windowMpart176 = union {
  box { // Cube2718
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2719
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2720
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr887
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr888
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2721
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2722
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr889
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr890
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart177 = union {
  box { // Cube2723
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2724
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2725
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr891
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr892
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2726
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2727
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr893
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr894
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart178 = union {
  box { // Cube2728
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2729
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2730
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr895
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr896
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2731
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2732
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr897
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr898
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart179 = union {
  box { // Cube2733
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2734
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2735
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr899
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr900
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2736
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2737
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr901
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr902
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart180 = union {
  box { // Cube2738
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2739
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2740
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr903
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr904
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2741
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2742
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr905
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr906
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart181 = union {
  box { // Cube2743
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2744
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2745
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr907
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr908
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2746
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2747
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr909
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr910
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart182 = union {
  box { // Cube2748
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2749
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2750
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr911
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr912
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2751
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2752
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr913
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr914
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart183 = union {
  box { // Cube2757
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2758
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2759
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr915
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr916
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2760
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2761
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr917
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr918
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock22 = union {
  object { railingMgroup22 }
  box { // Cube2717
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart176 }
  object { windowMpart177 }
  object { windowMpart178 }
  object { windowMpart179 }
  object { windowMpart180 }
  object { windowMpart181 }
  object { windowMpart182 }
  box { // Cube2753
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2754
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2755
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2756
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart183 }
  rotate 180.0*z
  translate  <13.71575, 94.0, 73.165269>
}
#declare railMpart244 = union {
  box { // Cube2762
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2763
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2764
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2765
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2766
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2767
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2768
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart245 = union {
  box { // Cube2769
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2770
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2771
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2772
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2773
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2774
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2775
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart246 = union {
  box { // Cube2776
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2777
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2778
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2779
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2780
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2781
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2782
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart247 = union {
  box { // Cube2783
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2784
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2785
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2786
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2787
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2788
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2789
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart248 = union {
  box { // Cube2790
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2791
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2792
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2793
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2794
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2795
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2796
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart249 = union {
  box { // Cube2797
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2798
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2799
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2800
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2801
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2802
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2803
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart250 = union {
  box { // Cube2804
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2805
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2806
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2807
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2808
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2809
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2810
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart251 = union {
  box { // Cube2811
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2812
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2813
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2814
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2815
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2816
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2817
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart252 = union {
  box { // Cube2818
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2819
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2820
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2821
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2822
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2823
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2824
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart253 = union {
  box { // Cube2825
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2826
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2827
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2828
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2829
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2830
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2831
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup23 = union {
  object { railMpart244 }
  object { railMpart245 }
  object { railMpart246 }
  object { railMpart247 }
  object { railMpart248 }
  object { railMpart249 }
  object { railMpart250 }
  object { railMpart251 }
  object { railMpart252 }
  object { railMpart253 }
}
#declare windowMpart184 = union {
  box { // Cube2833
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2834
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2835
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr919
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr920
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2836
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2837
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr921
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr922
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart185 = union {
  box { // Cube2838
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2839
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2840
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr923
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr924
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2841
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2842
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr925
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr926
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart186 = union {
  box { // Cube2843
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2844
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2845
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr927
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr928
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2846
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2847
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr929
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr930
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart187 = union {
  box { // Cube2848
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2849
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2850
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr931
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr932
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2851
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2852
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr933
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr934
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart188 = union {
  box { // Cube2853
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2854
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2855
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr935
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr936
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2856
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2857
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr937
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr938
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart189 = union {
  box { // Cube2858
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2859
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2860
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr939
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr940
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2861
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2862
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr941
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr942
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart190 = union {
  box { // Cube2863
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2864
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2865
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr943
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr944
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2866
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2867
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr945
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr946
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart191 = union {
  box { // Cube2872
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2873
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2874
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr947
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr948
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2875
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2876
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr949
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr950
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock23 = union {
  object { railingMgroup23 }
  box { // Cube2832
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart184 }
  object { windowMpart185 }
  object { windowMpart186 }
  object { windowMpart187 }
  object { windowMpart188 }
  object { windowMpart189 }
  object { windowMpart190 }
  box { // Cube2868
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2869
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2870
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2871
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart191 }
  rotate -90.0*z
  translate  <13.71575, 93.625383, 73.165269>
}
#declare railMpart254 = union {
  box { // Cube2877
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2878
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2879
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2880
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2881
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2882
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2883
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart255 = union {
  box { // Cube2884
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2885
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2886
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2887
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2888
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2889
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2890
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart256 = union {
  box { // Cube2891
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2892
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2893
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2894
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2895
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2896
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2897
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart257 = union {
  box { // Cube2898
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2899
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2900
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2901
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2902
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2903
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2904
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart258 = union {
  box { // Cube2905
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2906
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2907
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2908
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2909
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2910
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2911
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart259 = union {
  box { // Cube2912
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2913
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2914
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2915
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2916
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2917
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2918
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart260 = union {
  box { // Cube2919
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2920
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2921
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2922
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2923
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2924
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2925
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart261 = union {
  box { // Cube2926
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2927
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2928
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2929
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2930
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2931
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2932
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart262 = union {
  box { // Cube2933
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2934
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2935
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2936
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2937
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2938
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2939
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart263 = union {
  box { // Cube2940
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2941
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2942
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2943
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2944
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2945
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2946
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup24 = union {
  object { railMpart254 }
  object { railMpart255 }
  object { railMpart256 }
  object { railMpart257 }
  object { railMpart258 }
  object { railMpart259 }
  object { railMpart260 }
  object { railMpart261 }
  object { railMpart262 }
  object { railMpart263 }
}
#declare windowMpart192 = union {
  box { // Cube2948
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2949
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2950
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr951
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr952
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2951
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2952
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr953
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr954
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart193 = union {
  box { // Cube2953
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2954
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2955
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr955
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr956
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2956
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2957
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr957
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr958
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart194 = union {
  box { // Cube2958
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2959
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2960
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr959
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr960
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2961
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2962
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr961
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr962
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart195 = union {
  box { // Cube2963
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2964
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2965
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr963
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr964
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2966
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2967
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr965
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr966
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart196 = union {
  box { // Cube2968
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2969
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2970
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr967
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr968
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2971
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2972
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr969
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr970
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart197 = union {
  box { // Cube2973
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2974
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2975
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr971
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr972
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2976
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2977
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr973
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr974
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart198 = union {
  box { // Cube2978
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2979
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2980
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr975
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr976
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2981
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2982
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr977
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr978
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart199 = union {
  box { // Cube2987
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2988
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2989
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr979
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr980
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2990
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2991
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr981
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr982
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock24 = union {
  object { railingMgroup24 }
  box { // Cube2947
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart192 }
  object { windowMpart193 }
  object { windowMpart194 }
  object { windowMpart195 }
  object { windowMpart196 }
  object { windowMpart197 }
  object { windowMpart198 }
  box { // Cube2983
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2984
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2985
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2986
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart199 }
  rotate -90.0*z
  translate  <13.71575, 53.625383, 73.165269>
}
#declare railMpart264 = union {
  box { // Cube2992
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2993
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2994
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2995
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2996
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2997
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2998
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart265 = union {
  box { // Cube2999
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3000
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3001
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3002
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3003
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3004
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3005
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner7 = union {
  object { railMpart264 }
  object { railMpart265 }
  box { // Cube3006
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
}
#declare railMpart276 = union {
  box { // Cube3122
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3123
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3124
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3125
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3126
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3127
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3128
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart277 = union {
  box { // Cube3129
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3130
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3131
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3132
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3133
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3134
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3135
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart278 = union {
  box { // Cube3136
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3137
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3138
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3139
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3140
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3141
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3142
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart279 = union {
  box { // Cube3143
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3144
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3145
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3146
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3147
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3148
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3149
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart280 = union {
  box { // Cube3150
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3151
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3152
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3153
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3154
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3155
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3156
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart281 = union {
  box { // Cube3157
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3158
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3159
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3160
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3161
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3162
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3163
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart282 = union {
  box { // Cube3164
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3165
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3166
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3167
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3168
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3169
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3170
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart283 = union {
  box { // Cube3171
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3172
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3173
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3174
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3175
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3176
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3177
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart284 = union {
  box { // Cube3178
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3179
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3180
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3181
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3182
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3183
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3184
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart285 = union {
  box { // Cube3185
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3186
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3187
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3188
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3189
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3190
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3191
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup26 = union {
  object { railMpart276 }
  object { railMpart277 }
  object { railMpart278 }
  object { railMpart279 }
  object { railMpart280 }
  object { railMpart281 }
  object { railMpart282 }
  object { railMpart283 }
  object { railMpart284 }
  object { railMpart285 }
}
#declare windowMpart208 = union {
  box { // Cube3193
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3194
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3195
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1015
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1016
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3196
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3197
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1017
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1018
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart209 = union {
  box { // Cube3198
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3199
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3200
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1019
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1020
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3201
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3202
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1021
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1022
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart210 = union {
  box { // Cube3203
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3204
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3205
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1023
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1024
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3206
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3207
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1025
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1026
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart211 = union {
  box { // Cube3208
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3209
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3210
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1027
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1028
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3211
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3212
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1029
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1030
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart212 = union {
  box { // Cube3213
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3214
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3215
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1031
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1032
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3216
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3217
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1033
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1034
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart213 = union {
  box { // Cube3218
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3219
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3220
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1035
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1036
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3221
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3222
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1037
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1038
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart214 = union {
  box { // Cube3223
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3224
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3225
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1039
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1040
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3226
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3227
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1041
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1042
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart215 = union {
  box { // Cube3232
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube3233
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube3234
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1043
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1044
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube3235
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube3236
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1045
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1046
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock26 = union {
  object { railingMgroup26 }
  box { // Cube3192
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart208 }
  object { windowMpart209 }
  object { windowMpart210 }
  object { windowMpart211 }
  object { windowMpart212 }
  object { windowMpart213 }
  object { windowMpart214 }
  box { // Cube3228
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube3229
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube3230
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube3231
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart215 }
  translate  <53.71575, 13.222295, 73.165269>
}
#declare houseMblockMgroup3 = union {
  box { // Cube2516
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <7.824406, 58.380085, 4.0>
    translate  <66.022599, 54.089578, 77.0>
  }
  object { houseMblock21 }
  object { railMcorner6 }
  object { houseMblock22 }
  object { houseMblock23 }
  object { houseMblock24 }
  object { railMcorner7 }
  object { houseMblock26 }
  translate  <0.0, -3.209311, 27.0>
}
#declare railMpart148 = union {
  box { // Cube1681
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1682
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1683
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1684
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1685
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1686
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1687
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart149 = union {
  box { // Cube1688
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1689
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1690
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1691
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1692
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1693
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1694
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart150 = union {
  box { // Cube1695
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1696
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1697
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1698
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1699
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1700
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1701
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart151 = union {
  box { // Cube1702
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1703
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1704
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1705
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1706
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1707
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1708
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart152 = union {
  box { // Cube1709
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1710
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1711
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1712
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1713
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1714
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1715
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart153 = union {
  box { // Cube1716
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1717
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1718
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1719
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1720
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1721
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1722
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart154 = union {
  box { // Cube1723
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1724
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1725
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1726
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1727
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1728
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1729
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart155 = union {
  box { // Cube1730
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1731
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1732
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1733
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1734
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1735
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1736
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart156 = union {
  box { // Cube1737
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1738
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1739
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1740
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1741
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1742
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1743
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart157 = union {
  box { // Cube1744
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1745
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1746
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1747
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1748
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1749
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1750
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup14 = union {
  object { railMpart148 }
  object { railMpart149 }
  object { railMpart150 }
  object { railMpart151 }
  object { railMpart152 }
  object { railMpart153 }
  object { railMpart154 }
  object { railMpart155 }
  object { railMpart156 }
  object { railMpart157 }
}
#declare windowMpart112 = union {
  box { // Cube1752
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1753
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1754
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr632
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1755
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1756
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr633
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr634
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart113 = union {
  box { // Cube1757
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1758
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1759
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr635
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr636
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1760
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1761
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr637
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr638
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart114 = union {
  box { // Cube1762
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1763
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1764
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr639
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr640
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1765
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1766
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr641
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr642
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart115 = union {
  box { // Cube1767
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1768
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1769
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr643
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr644
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1770
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1771
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr645
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr646
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart116 = union {
  box { // Cube1772
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1773
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1774
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr647
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr648
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1775
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1776
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr649
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr650
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart117 = union {
  box { // Cube1777
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1778
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1779
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr651
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr652
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1780
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1781
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr653
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr654
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart118 = union {
  box { // Cube1782
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1783
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1784
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr655
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr656
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1785
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1786
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr657
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr658
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart119 = union {
  box { // Cube1791
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1792
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1793
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr659
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr660
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1794
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1795
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr661
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr662
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock14 = union {
  object { railingMgroup14 }
  box { // Cube1751
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart112 }
  object { windowMpart113 }
  object { windowMpart114 }
  object { windowMpart115 }
  object { windowMpart116 }
  object { windowMpart117 }
  object { windowMpart118 }
  box { // Cube1787
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1788
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1789
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1790
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart119 }
  rotate 180.0*z
  translate  <53.71575, 94.0, 73.165269>
}
#declare railMpart158 = union {
  box { // Cube1796
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1797
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1798
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1799
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1800
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1801
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1802
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart159 = union {
  box { // Cube1803
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1804
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1805
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1806
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1807
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1808
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1809
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner4 = union {
  object { railMpart158 }
  object { railMpart159 }
  box { // Cube1810
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
  rotate -90.0*z
  translate  <0.479885, 107.73253, 0.0>
}
#declare railMpart160 = union {
  box { // Cube1811
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1812
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1813
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1814
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1815
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1816
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1817
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart161 = union {
  box { // Cube1818
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1819
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1820
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1821
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1822
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1823
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1824
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart162 = union {
  box { // Cube1825
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1826
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1827
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1828
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1829
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1830
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1831
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart163 = union {
  box { // Cube1832
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1833
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1834
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1835
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1836
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1837
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1838
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart164 = union {
  box { // Cube1839
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1840
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1841
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1842
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1843
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1844
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1845
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart165 = union {
  box { // Cube1846
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1847
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1848
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1849
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1850
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1851
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1852
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart166 = union {
  box { // Cube1853
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1854
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1855
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1856
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1857
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1858
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1859
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart167 = union {
  box { // Cube1860
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1861
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1862
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1863
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1864
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1865
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1866
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart168 = union {
  box { // Cube1867
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1868
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1869
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1870
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1871
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1872
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1873
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart169 = union {
  box { // Cube1874
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1875
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1876
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1877
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1878
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1879
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1880
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup15 = union {
  object { railMpart160 }
  object { railMpart161 }
  object { railMpart162 }
  object { railMpart163 }
  object { railMpart164 }
  object { railMpart165 }
  object { railMpart166 }
  object { railMpart167 }
  object { railMpart168 }
  object { railMpart169 }
}
#declare windowMpart120 = union {
  box { // Cube1882
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1883
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1884
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr663
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr664
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1885
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1886
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr665
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr666
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart121 = union {
  box { // Cube1887
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1888
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1889
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr667
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr668
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1890
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1891
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr669
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr670
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart122 = union {
  box { // Cube1892
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1893
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1894
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr671
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr672
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1895
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1896
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr673
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr674
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart123 = union {
  box { // Cube1897
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1898
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1899
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr675
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr676
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1900
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1901
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr677
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr678
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart124 = union {
  box { // Cube1902
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1903
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1904
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr679
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr680
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1905
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1906
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr681
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr682
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart125 = union {
  box { // Cube1907
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1908
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1909
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr683
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr684
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1910
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1911
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr685
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr686
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart126 = union {
  box { // Cube1912
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1913
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1914
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr687
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr688
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1915
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1916
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr689
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr690
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart127 = union {
  box { // Cube1921
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1922
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1923
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr691
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr692
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1924
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1925
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr693
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr694
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock15 = union {
  object { railingMgroup15 }
  box { // Cube1881
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart120 }
  object { windowMpart121 }
  object { windowMpart122 }
  object { windowMpart123 }
  object { windowMpart124 }
  object { windowMpart125 }
  object { windowMpart126 }
  box { // Cube1917
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1918
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1919
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1920
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart127 }
  rotate 180.0*z
  translate  <13.71575, 94.0, 73.165269>
}
#declare railMpart170 = union {
  box { // Cube1926
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1927
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1928
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1929
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1930
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1931
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1932
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart171 = union {
  box { // Cube1933
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1934
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1935
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1936
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1937
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1938
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1939
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart172 = union {
  box { // Cube1940
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1941
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1942
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1943
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1944
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1945
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1946
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart173 = union {
  box { // Cube1947
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1948
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1949
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1950
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1951
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1952
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1953
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart174 = union {
  box { // Cube1954
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1955
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1956
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1957
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1958
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1959
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1960
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart175 = union {
  box { // Cube1961
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1962
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1963
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1964
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1965
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1966
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1967
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart176 = union {
  box { // Cube1968
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1969
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1970
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1971
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1972
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1973
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1974
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart177 = union {
  box { // Cube1975
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1976
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1977
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1978
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1979
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1980
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1981
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart178 = union {
  box { // Cube1982
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1983
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1984
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1985
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1986
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1987
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1988
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart179 = union {
  box { // Cube1989
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1990
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1991
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1992
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1993
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1994
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1995
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup16 = union {
  object { railMpart170 }
  object { railMpart171 }
  object { railMpart172 }
  object { railMpart173 }
  object { railMpart174 }
  object { railMpart175 }
  object { railMpart176 }
  object { railMpart177 }
  object { railMpart178 }
  object { railMpart179 }
}
#declare windowMpart128 = union {
  box { // Cube1997
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1998
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1999
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr695
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr696
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2000
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2001
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr697
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr698
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart129 = union {
  box { // Cube2002
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2003
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2004
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr699
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr700
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2005
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2006
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr701
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr702
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart130 = union {
  box { // Cube2007
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2008
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2009
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr703
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr704
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2010
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2011
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr705
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr706
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart131 = union {
  box { // Cube2012
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2013
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2014
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr707
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr708
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2015
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2016
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr709
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr710
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart132 = union {
  box { // Cube2017
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2018
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2019
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr711
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr712
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2020
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2021
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr713
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr714
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart133 = union {
  box { // Cube2022
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2023
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2024
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr715
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr716
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2025
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2026
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr717
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr718
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart134 = union {
  box { // Cube2027
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2028
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2029
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr719
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr720
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2030
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2031
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr721
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr722
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart135 = union {
  box { // Cube2036
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2037
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2038
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr723
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr724
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2039
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2040
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr725
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr726
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock16 = union {
  object { railingMgroup16 }
  box { // Cube1996
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart128 }
  object { windowMpart129 }
  object { windowMpart130 }
  object { windowMpart131 }
  object { windowMpart132 }
  object { windowMpart133 }
  object { windowMpart134 }
  box { // Cube2032
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2033
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2034
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2035
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart135 }
  rotate -90.0*z
  translate  <13.71575, 93.625383, 73.165269>
}
#declare railMpart180 = union {
  box { // Cube2041
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2042
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2043
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2044
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2045
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2046
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2047
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart181 = union {
  box { // Cube2048
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2049
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2050
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2051
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2052
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2053
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2054
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart182 = union {
  box { // Cube2055
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2056
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2057
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2058
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2059
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2060
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2061
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart183 = union {
  box { // Cube2062
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2063
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2064
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2065
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2066
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2067
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2068
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart184 = union {
  box { // Cube2069
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2070
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2071
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2072
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2073
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2074
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2075
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart185 = union {
  box { // Cube2076
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2077
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2078
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2079
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2080
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2081
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2082
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart186 = union {
  box { // Cube2083
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2084
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2085
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2086
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2087
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2088
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2089
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart187 = union {
  box { // Cube2090
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2091
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2092
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2093
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2094
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2095
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2096
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart188 = union {
  box { // Cube2097
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2098
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2099
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2100
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2101
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2102
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2103
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart189 = union {
  box { // Cube2104
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2105
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2106
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2107
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2108
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2109
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2110
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup17 = union {
  object { railMpart180 }
  object { railMpart181 }
  object { railMpart182 }
  object { railMpart183 }
  object { railMpart184 }
  object { railMpart185 }
  object { railMpart186 }
  object { railMpart187 }
  object { railMpart188 }
  object { railMpart189 }
}
#declare windowMpart136 = union {
  box { // Cube2112
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2113
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2114
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr727
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr728
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2115
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2116
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr729
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr730
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart137 = union {
  box { // Cube2117
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2118
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2119
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr731
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr732
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2120
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2121
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr733
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr734
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart138 = union {
  box { // Cube2122
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2123
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2124
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr735
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr736
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2125
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2126
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr737
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr738
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart139 = union {
  box { // Cube2127
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2128
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2129
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr739
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr740
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2130
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2131
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr741
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr742
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart140 = union {
  box { // Cube2132
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2133
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2134
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr743
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr744
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2135
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2136
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr745
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr746
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart141 = union {
  box { // Cube2137
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2138
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2139
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr747
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr748
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2140
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2141
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr749
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr750
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart142 = union {
  box { // Cube2142
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2143
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2144
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr751
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr752
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2145
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2146
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr753
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr754
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart143 = union {
  box { // Cube2151
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2152
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2153
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr755
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr756
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2154
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2155
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr757
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr758
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock17 = union {
  object { railingMgroup17 }
  box { // Cube2111
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart136 }
  object { windowMpart137 }
  object { windowMpart138 }
  object { windowMpart139 }
  object { windowMpart140 }
  object { windowMpart141 }
  object { windowMpart142 }
  box { // Cube2147
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2148
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2149
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2150
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart143 }
  rotate -90.0*z
  translate  <13.71575, 53.625383, 73.165269>
}
#declare railMpart190 = union {
  box { // Cube2156
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2157
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2158
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2159
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2160
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2161
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2162
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart191 = union {
  box { // Cube2163
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2164
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2165
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2166
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2167
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2168
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2169
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner5 = union {
  object { railMpart190 }
  object { railMpart191 }
  box { // Cube2170
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
}
#declare railMpart192 = union {
  box { // Cube2171
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2172
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2173
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2174
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2175
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2176
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2177
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart193 = union {
  box { // Cube2178
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2179
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2180
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2181
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2182
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2183
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2184
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart194 = union {
  box { // Cube2185
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2186
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2187
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2188
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2189
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2190
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2191
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart195 = union {
  box { // Cube2192
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2193
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2194
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2195
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2196
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2197
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2198
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart196 = union {
  box { // Cube2199
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2200
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2201
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2202
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2203
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2204
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2205
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart197 = union {
  box { // Cube2206
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2207
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2208
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2209
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2210
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2211
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2212
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart198 = union {
  box { // Cube2213
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2214
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2215
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2216
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2217
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2218
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2219
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart199 = union {
  box { // Cube2220
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2221
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2222
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2223
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2224
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2225
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2226
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart200 = union {
  box { // Cube2227
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2228
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2229
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2230
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2231
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2232
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2233
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart201 = union {
  box { // Cube2234
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2235
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2236
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2237
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2238
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2239
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2240
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup18 = union {
  object { railMpart192 }
  object { railMpart193 }
  object { railMpart194 }
  object { railMpart195 }
  object { railMpart196 }
  object { railMpart197 }
  object { railMpart198 }
  object { railMpart199 }
  object { railMpart200 }
  object { railMpart201 }
}
#declare windowMpart144 = union {
  box { // Cube2242
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2243
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2244
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr759
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr760
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2245
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2246
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr761
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr762
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart145 = union {
  box { // Cube2247
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2248
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2249
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr763
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr764
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2250
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2251
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr765
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr766
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart146 = union {
  box { // Cube2252
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2253
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2254
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr767
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr768
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2255
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2256
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr769
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr770
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart147 = union {
  box { // Cube2257
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2258
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2259
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr771
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr772
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2260
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2261
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr773
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr774
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart148 = union {
  box { // Cube2262
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2263
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2264
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr775
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr776
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2265
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2266
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr777
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr778
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart149 = union {
  box { // Cube2267
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2268
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2269
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr779
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr780
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2270
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2271
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr781
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr782
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart150 = union {
  box { // Cube2272
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2273
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2274
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr783
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr784
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2275
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2276
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr785
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr786
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart151 = union {
  box { // Cube2281
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2282
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2283
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr787
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr788
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2284
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2285
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr789
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr790
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock18 = union {
  object { railingMgroup18 }
  box { // Cube2241
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart144 }
  object { windowMpart145 }
  object { windowMpart146 }
  object { windowMpart147 }
  object { windowMpart148 }
  object { windowMpart149 }
  object { windowMpart150 }
  box { // Cube2277
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2278
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2279
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2280
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart151 }
  rotate -90.0*z
  translate  <13.71575, 13.625383, 73.165269>
}
#declare railMpart202 = union {
  box { // Cube2286
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2287
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2288
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2289
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2290
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2291
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2292
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart203 = union {
  box { // Cube2293
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2294
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2295
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2296
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2297
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2298
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2299
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart204 = union {
  box { // Cube2300
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2301
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2302
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2303
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2304
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2305
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2306
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart205 = union {
  box { // Cube2307
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2308
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2309
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2310
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2311
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2312
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2313
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart206 = union {
  box { // Cube2314
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2315
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2316
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2317
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2318
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2319
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2320
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart207 = union {
  box { // Cube2321
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2322
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2323
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2324
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2325
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2326
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2327
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart208 = union {
  box { // Cube2328
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2329
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2330
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2331
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2332
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2333
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2334
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart209 = union {
  box { // Cube2335
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2336
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2337
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2338
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2339
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2340
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2341
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart210 = union {
  box { // Cube2342
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2343
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2344
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2345
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2346
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2347
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2348
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart211 = union {
  box { // Cube2349
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2350
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2351
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2352
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2353
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2354
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2355
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup19 = union {
  object { railMpart202 }
  object { railMpart203 }
  object { railMpart204 }
  object { railMpart205 }
  object { railMpart206 }
  object { railMpart207 }
  object { railMpart208 }
  object { railMpart209 }
  object { railMpart210 }
  object { railMpart211 }
}
#declare windowMpart152 = union {
  box { // Cube2357
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2358
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2359
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr791
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr792
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2360
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2361
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr793
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr794
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart153 = union {
  box { // Cube2362
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2363
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2364
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr795
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr796
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2365
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2366
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr797
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr798
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart154 = union {
  box { // Cube2367
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2368
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2369
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr799
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr800
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2370
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2371
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr801
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr802
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart155 = union {
  box { // Cube2372
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2373
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2374
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr803
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr804
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2375
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2376
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr805
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr806
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart156 = union {
  box { // Cube2377
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2378
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2379
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr807
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr808
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2380
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2381
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr809
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr810
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart157 = union {
  box { // Cube2382
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2383
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2384
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr811
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr812
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2385
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2386
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr813
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr814
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart158 = union {
  box { // Cube2387
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2388
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2389
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr815
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr816
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2390
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2391
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr817
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr818
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart159 = union {
  box { // Cube2396
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2397
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2398
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr819
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr820
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2399
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2400
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr821
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr822
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock19 = union {
  object { railingMgroup19 }
  box { // Cube2356
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart152 }
  object { windowMpart153 }
  object { windowMpart154 }
  object { windowMpart155 }
  object { windowMpart156 }
  object { windowMpart157 }
  object { windowMpart158 }
  box { // Cube2392
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2393
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2394
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2395
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart159 }
  translate  <53.71575, 13.222295, 73.165269>
}
#declare railMpart212 = union {
  box { // Cube2401
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2402
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2403
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2404
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2405
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2406
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2407
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart213 = union {
  box { // Cube2408
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2409
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2410
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2411
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2412
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2413
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2414
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart214 = union {
  box { // Cube2415
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2416
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2417
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2418
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2419
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2420
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2421
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart215 = union {
  box { // Cube2422
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2423
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2424
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2425
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2426
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2427
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2428
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart216 = union {
  box { // Cube2429
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2430
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2431
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2432
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2433
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2434
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2435
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart217 = union {
  box { // Cube2436
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2437
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2438
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2439
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2440
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2441
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2442
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart218 = union {
  box { // Cube2443
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2444
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2445
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2446
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2447
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2448
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2449
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart219 = union {
  box { // Cube2450
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2451
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2452
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2453
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2454
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2455
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2456
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart220 = union {
  box { // Cube2457
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2458
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2459
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2460
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2461
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2462
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2463
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart221 = union {
  box { // Cube2464
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube2465
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube2466
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube2467
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube2468
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube2469
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube2470
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup20 = union {
  object { railMpart212 }
  object { railMpart213 }
  object { railMpart214 }
  object { railMpart215 }
  object { railMpart216 }
  object { railMpart217 }
  object { railMpart218 }
  object { railMpart219 }
  object { railMpart220 }
  object { railMpart221 }
}
#declare windowMpart160 = union {
  box { // Cube2472
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2473
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2474
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr823
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr824
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2475
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2476
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr825
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr826
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart161 = union {
  box { // Cube2477
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2478
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2479
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr827
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr828
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2480
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2481
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr829
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr830
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart162 = union {
  box { // Cube2482
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2483
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2484
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr831
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr832
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2485
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2486
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr833
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr834
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart163 = union {
  box { // Cube2487
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2488
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2489
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr835
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr836
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2490
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2491
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr837
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr838
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart164 = union {
  box { // Cube2492
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2493
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2494
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr839
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr840
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2495
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2496
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr841
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr842
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart165 = union {
  box { // Cube2497
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2498
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2499
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr843
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr844
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2500
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2501
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr845
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr846
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart166 = union {
  box { // Cube2502
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2503
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2504
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr847
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr848
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2505
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2506
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr849
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr850
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart167 = union {
  box { // Cube2511
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube2512
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube2513
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr851
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr852
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube2514
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube2515
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr853
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr854
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock20 = union {
  object { railingMgroup20 }
  box { // Cube2471
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart160 }
  object { windowMpart161 }
  object { windowMpart162 }
  object { windowMpart163 }
  object { windowMpart164 }
  object { windowMpart165 }
  object { windowMpart166 }
  box { // Cube2507
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube2508
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube2509
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube2510
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart167 }
  translate  <13.71575, 13.222295, 73.165269>
}
#declare houseMblockMgroup2 = union {
  box { // Cube1680
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <7.824406, 58.380085, 4.0>
    translate  <66.022599, 54.089578, 77.0>
  }
  object { houseMblock14 }
  object { railMcorner4 }
  object { houseMblock15 }
  object { houseMblock16 }
  object { houseMblock17 }
  object { railMcorner5 }
  object { houseMblock18 }
  object { houseMblock19 }
  object { houseMblock20 }
  translate  <0.0, -3.209311, 18.0>
}
#declare railMpart74 = union {
  box { // Cube845
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube846
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube847
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube848
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube849
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube850
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube851
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart75 = union {
  box { // Cube852
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube853
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube854
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube855
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube856
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube857
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube858
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart76 = union {
  box { // Cube859
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube860
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube861
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube862
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube863
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube864
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube865
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart77 = union {
  box { // Cube866
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube867
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube868
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube869
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube870
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube871
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube872
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart78 = union {
  box { // Cube873
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube874
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube875
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube876
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube877
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube878
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube879
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart79 = union {
  box { // Cube880
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube881
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube882
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube883
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube884
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube885
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube886
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart80 = union {
  box { // Cube887
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube888
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube889
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube890
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube891
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube892
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube893
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart81 = union {
  box { // Cube894
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube895
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube896
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube897
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube898
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube899
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube900
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart82 = union {
  box { // Cube901
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube902
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube903
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube904
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube905
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube906
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube907
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart83 = union {
  box { // Cube908
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube909
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube910
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube911
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube912
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube913
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube914
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup7 = union {
  object { railMpart74 }
  object { railMpart75 }
  object { railMpart76 }
  object { railMpart77 }
  object { railMpart78 }
  object { railMpart79 }
  object { railMpart80 }
  object { railMpart81 }
  object { railMpart82 }
  object { railMpart83 }
}
#declare windowMpart56 = union {
  box { // Cube916
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube917
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube918
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube919
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube920
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart57 = union {
  box { // Cube921
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube922
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube923
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube924
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube925
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart58 = union {
  box { // Cube926
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube927
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube928
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube929
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube930
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart59 = union {
  box { // Cube931
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube932
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube933
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube934
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube935
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart60 = union {
  box { // Cube936
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube937
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube938
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube939
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube940
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart61 = union {
  box { // Cube941
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube942
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube943
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube944
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube945
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart62 = union {
  box { // Cube946
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube947
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube948
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube949
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube950
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart63 = union {
  box { // Cube955
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube956
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube957
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube958
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube959
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock7 = union {
  object { railingMgroup7 }
  box { // Cube915
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart56 }
  object { windowMpart57 }
  object { windowMpart58 }
  object { windowMpart59 }
  object { windowMpart60 }
  object { windowMpart61 }
  object { windowMpart62 }
  box { // Cube951
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube952
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube953
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube954
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart63 }
  rotate 180.0*z
  translate  <53.71575, 94.0, 73.165269>
}
#declare railMpart84 = union {
  box { // Cube960
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube961
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube962
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube963
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube964
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube965
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube966
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart85 = union {
  box { // Cube967
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube968
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube969
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube970
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube971
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube972
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube973
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner2 = union {
  object { railMpart84 }
  object { railMpart85 }
  box { // Cube974
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
  rotate -90.0*z
  translate  <0.479885, 107.73253, 0.0>
}
#declare railMpart86 = union {
  box { // Cube975
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube976
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube977
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube978
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube979
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube980
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube981
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart87 = union {
  box { // Cube982
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube983
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube984
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube985
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube986
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube987
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube988
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart88 = union {
  box { // Cube989
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube990
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube991
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube992
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube993
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube994
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube995
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart89 = union {
  box { // Cube996
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube997
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube998
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube999
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1000
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1001
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1002
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart90 = union {
  box { // Cube1003
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1004
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1005
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1006
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1007
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1008
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1009
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart91 = union {
  box { // Cube1010
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1011
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1012
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1013
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1014
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1015
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1016
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart92 = union {
  box { // Cube1017
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1018
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1019
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1020
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1021
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1022
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1023
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart93 = union {
  box { // Cube1024
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1025
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1026
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1027
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1028
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1029
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1030
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart94 = union {
  box { // Cube1031
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1032
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1033
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1034
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1035
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1036
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1037
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart95 = union {
  box { // Cube1038
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1039
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1040
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1041
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1042
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1043
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1044
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup8 = union {
  object { railMpart86 }
  object { railMpart87 }
  object { railMpart88 }
  object { railMpart89 }
  object { railMpart90 }
  object { railMpart91 }
  object { railMpart92 }
  object { railMpart93 }
  object { railMpart94 }
  object { railMpart95 }
}
#declare windowMpart64 = union {
  box { // Cube1046
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1047
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1048
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1049
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1050
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart65 = union {
  box { // Cube1051
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1052
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1053
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1054
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1055
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart66 = union {
  box { // Cube1056
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1057
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1058
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1059
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1060
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart67 = union {
  box { // Cube1061
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1062
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1063
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1064
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1065
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart68 = union {
  box { // Cube1066
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1067
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1068
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1069
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1070
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart69 = union {
  box { // Cube1071
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1072
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1073
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1074
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1075
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart70 = union {
  box { // Cube1076
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1077
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1078
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1079
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1080
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart71 = union {
  box { // Cube1085
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1086
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1087
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1088
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1089
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock8 = union {
  object { railingMgroup8 }
  box { // Cube1045
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart64 }
  object { windowMpart65 }
  object { windowMpart66 }
  object { windowMpart67 }
  object { windowMpart68 }
  object { windowMpart69 }
  object { windowMpart70 }
  box { // Cube1081
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1082
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1083
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1084
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart71 }
  rotate 180.0*z
  translate  <13.71575, 94.0, 73.165269>
}
#declare railMpart96 = union {
  box { // Cube1090
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1091
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1092
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1093
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1094
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1095
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1096
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart97 = union {
  box { // Cube1097
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1098
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1099
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1100
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1101
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1102
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1103
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart98 = union {
  box { // Cube1104
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1105
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1106
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1107
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1108
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1109
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1110
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart99 = union {
  box { // Cube1111
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1112
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1113
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1114
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1115
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1116
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1117
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart100 = union {
  box { // Cube1118
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1119
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1120
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1121
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1122
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1123
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1124
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart101 = union {
  box { // Cube1125
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1126
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1127
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1128
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1129
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1130
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1131
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart102 = union {
  box { // Cube1132
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1133
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1134
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1135
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1136
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1137
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1138
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart103 = union {
  box { // Cube1139
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1140
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1141
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1142
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1143
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1144
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1145
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart104 = union {
  box { // Cube1146
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1147
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1148
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1149
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1150
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1151
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1152
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart105 = union {
  box { // Cube1153
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1154
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1155
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1156
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1157
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1158
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1159
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup9 = union {
  object { railMpart96 }
  object { railMpart97 }
  object { railMpart98 }
  object { railMpart99 }
  object { railMpart100 }
  object { railMpart101 }
  object { railMpart102 }
  object { railMpart103 }
  object { railMpart104 }
  object { railMpart105 }
}
#declare windowMpart72 = union {
  box { // Cube1161
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1162
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1163
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1164
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1165
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart73 = union {
  box { // Cube1166
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1167
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1168
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1169
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1170
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart74 = union {
  box { // Cube1171
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1172
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1173
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1174
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1175
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart75 = union {
  box { // Cube1176
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1177
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1178
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1179
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1180
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart76 = union {
  box { // Cube1181
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1182
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1183
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1184
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1185
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart77 = union {
  box { // Cube1186
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1187
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1188
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1189
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1190
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart78 = union {
  box { // Cube1191
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1192
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1193
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1194
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1195
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart79 = union {
  box { // Cube1200
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1201
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1202
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1203
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1204
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock9 = union {
  object { railingMgroup9 }
  box { // Cube1160
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart72 }
  object { windowMpart73 }
  object { windowMpart74 }
  object { windowMpart75 }
  object { windowMpart76 }
  object { windowMpart77 }
  object { windowMpart78 }
  box { // Cube1196
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1197
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1198
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1199
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart79 }
  rotate -90.0*z
  translate  <13.71575, 93.625383, 73.165269>
}
#declare railMpart106 = union {
  box { // Cube1205
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1206
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1207
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1208
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1209
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1210
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1211
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart107 = union {
  box { // Cube1212
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1213
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1214
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1215
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1216
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1217
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1218
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart108 = union {
  box { // Cube1219
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1220
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1221
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1222
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1223
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1224
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1225
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart109 = union {
  box { // Cube1226
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1227
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1228
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1229
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1230
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1231
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1232
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart110 = union {
  box { // Cube1233
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1234
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1235
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1236
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1237
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1238
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1239
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart111 = union {
  box { // Cube1240
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1241
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1242
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1243
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1244
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1245
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1246
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart112 = union {
  box { // Cube1247
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1248
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1249
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1250
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1251
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1252
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1253
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart113 = union {
  box { // Cube1254
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1255
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1256
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1257
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1258
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1259
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1260
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart114 = union {
  box { // Cube1261
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1262
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1263
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1264
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1265
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1266
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1267
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart115 = union {
  box { // Cube1268
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1269
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1270
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1271
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1272
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1273
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1274
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup10 = union {
  object { railMpart106 }
  object { railMpart107 }
  object { railMpart108 }
  object { railMpart109 }
  object { railMpart110 }
  object { railMpart111 }
  object { railMpart112 }
  object { railMpart113 }
  object { railMpart114 }
  object { railMpart115 }
}
#declare windowMpart80 = union {
  box { // Cube1276
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1277
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1278
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1279
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1280
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart81 = union {
  box { // Cube1281
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1282
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1283
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1284
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1285
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart82 = union {
  box { // Cube1286
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1287
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1288
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1289
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1290
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart83 = union {
  box { // Cube1291
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1292
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1293
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1294
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1295
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart84 = union {
  box { // Cube1296
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1297
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1298
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1299
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1300
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart85 = union {
  box { // Cube1301
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1302
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1303
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1304
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1305
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart86 = union {
  box { // Cube1306
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1307
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1308
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1309
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1310
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart87 = union {
  box { // Cube1315
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1316
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1317
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1318
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1319
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock10 = union {
  object { railingMgroup10 }
  box { // Cube1275
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart80 }
  object { windowMpart81 }
  object { windowMpart82 }
  object { windowMpart83 }
  object { windowMpart84 }
  object { windowMpart85 }
  object { windowMpart86 }
  box { // Cube1311
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1312
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1313
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1314
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart87 }
  rotate -90.0*z
  translate  <13.71575, 53.625383, 73.165269>
}
#declare railMpart116 = union {
  box { // Cube1320
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1321
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1322
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1323
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1324
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1325
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1326
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart117 = union {
  box { // Cube1327
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1328
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1329
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1330
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1331
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1332
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1333
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner3 = union {
  object { railMpart116 }
  object { railMpart117 }
  box { // Cube1334
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
}
#declare railMpart118 = union {
  box { // Cube1335
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1336
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1337
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1338
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1339
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1340
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1341
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart119 = union {
  box { // Cube1342
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1343
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1344
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1345
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1346
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1347
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1348
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart120 = union {
  box { // Cube1349
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1350
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1351
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1352
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1353
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1354
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1355
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart121 = union {
  box { // Cube1356
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1357
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1358
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1359
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1360
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1361
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1362
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart122 = union {
  box { // Cube1363
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1364
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1365
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1366
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1367
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1368
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1369
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart123 = union {
  box { // Cube1370
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1371
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1372
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1373
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1374
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1375
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1376
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart124 = union {
  box { // Cube1377
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1378
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1379
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1380
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1381
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1382
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1383
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart125 = union {
  box { // Cube1384
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1385
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1386
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1387
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1388
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1389
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1390
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart126 = union {
  box { // Cube1391
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1392
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1393
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1394
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1395
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1396
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1397
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart127 = union {
  box { // Cube1398
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1399
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1400
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1401
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1402
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1403
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1404
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup11 = union {
  object { railMpart118 }
  object { railMpart119 }
  object { railMpart120 }
  object { railMpart121 }
  object { railMpart122 }
  object { railMpart123 }
  object { railMpart124 }
  object { railMpart125 }
  object { railMpart126 }
  object { railMpart127 }
}
#declare windowMpart88 = union {
  box { // Cube1406
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1407
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1408
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1409
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1410
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart89 = union {
  box { // Cube1411
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1412
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1413
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1414
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1415
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart90 = union {
  box { // Cube1416
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1417
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1418
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1419
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1420
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart91 = union {
  box { // Cube1421
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1422
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1423
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1424
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1425
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart92 = union {
  box { // Cube1426
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1427
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1428
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1429
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1430
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart93 = union {
  box { // Cube1431
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1432
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1433
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1434
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1435
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart94 = union {
  box { // Cube1436
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1437
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1438
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1439
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1440
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart95 = union {
  box { // Cube1445
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1446
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1447
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1448
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1449
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock11 = union {
  object { railingMgroup11 }
  box { // Cube1405
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart88 }
  object { windowMpart89 }
  object { windowMpart90 }
  object { windowMpart91 }
  object { windowMpart92 }
  object { windowMpart93 }
  object { windowMpart94 }
  box { // Cube1441
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1442
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1443
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1444
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart95 }
  rotate -90.0*z
  translate  <13.71575, 13.625383, 73.165269>
}
#declare railMpart128 = union {
  box { // Cube1450
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1451
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1452
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1453
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1454
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1455
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1456
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart129 = union {
  box { // Cube1457
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1458
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1459
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1460
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1461
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1462
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1463
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart130 = union {
  box { // Cube1464
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1465
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1466
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1467
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1468
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1469
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1470
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart131 = union {
  box { // Cube1471
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1472
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1473
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1474
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1475
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1476
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1477
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart132 = union {
  box { // Cube1478
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1479
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1480
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1481
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1482
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1483
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1484
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart133 = union {
  box { // Cube1485
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1486
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1487
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1488
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1489
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1490
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1491
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart134 = union {
  box { // Cube1492
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1493
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1494
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1495
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1496
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1497
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1498
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart135 = union {
  box { // Cube1499
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1500
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1501
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1502
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1503
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1504
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1505
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart136 = union {
  box { // Cube1506
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1507
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1508
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1509
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1510
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1511
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1512
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart137 = union {
  box { // Cube1513
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1514
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1515
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1516
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1517
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1518
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1519
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup12 = union {
  object { railMpart128 }
  object { railMpart129 }
  object { railMpart130 }
  object { railMpart131 }
  object { railMpart132 }
  object { railMpart133 }
  object { railMpart134 }
  object { railMpart135 }
  object { railMpart136 }
  object { railMpart137 }
}
#declare windowMpart96 = union {
  box { // Cube1521
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1522
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1523
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1524
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1525
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart97 = union {
  box { // Cube1526
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1527
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1528
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1529
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1530
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart98 = union {
  box { // Cube1531
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1532
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1533
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1534
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1535
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart99 = union {
  box { // Cube1536
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1537
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1538
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1539
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1540
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart100 = union {
  box { // Cube1541
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1542
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1543
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1544
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1545
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart101 = union {
  box { // Cube1546
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1547
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1548
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1549
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1550
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart102 = union {
  box { // Cube1551
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1552
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1553
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1554
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1555
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr593
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart103 = union {
  box { // Cube1560
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1561
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1562
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr595
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1563
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1564
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock12 = union {
  object { railingMgroup12 }
  box { // Cube1520
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart96 }
  object { windowMpart97 }
  object { windowMpart98 }
  object { windowMpart99 }
  object { windowMpart100 }
  object { windowMpart101 }
  object { windowMpart102 }
  box { // Cube1556
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1557
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1558
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1559
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart103 }
  translate  <53.71575, 13.222295, 73.165269>
}
#declare railMpart138 = union {
  box { // Cube1565
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1566
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1567
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1568
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1569
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1570
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1571
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart139 = union {
  box { // Cube1572
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1573
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1574
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1575
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1576
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1577
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1578
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart140 = union {
  box { // Cube1579
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1580
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1581
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1582
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1583
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1584
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1585
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart141 = union {
  box { // Cube1586
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1587
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1588
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1589
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1590
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1591
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1592
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart142 = union {
  box { // Cube1593
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1594
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1595
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1596
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1597
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1598
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1599
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart143 = union {
  box { // Cube1600
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1601
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1602
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1603
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1604
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1605
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1606
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart144 = union {
  box { // Cube1607
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1608
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1609
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1610
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1611
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1612
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1613
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart145 = union {
  box { // Cube1614
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1615
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1616
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1617
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1618
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1619
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1620
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart146 = union {
  box { // Cube1621
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1622
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1623
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1624
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1625
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1626
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1627
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart147 = union {
  box { // Cube1628
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube1629
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube1630
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube1631
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube1632
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube1633
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube1634
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup13 = union {
  object { railMpart138 }
  object { railMpart139 }
  object { railMpart140 }
  object { railMpart141 }
  object { railMpart142 }
  object { railMpart143 }
  object { railMpart144 }
  object { railMpart145 }
  object { railMpart146 }
  object { railMpart147 }
}
#declare windowMpart104 = union {
  box { // Cube1636
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1637
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1638
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1639
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1640
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr602
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart105 = union {
  box { // Cube1641
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1642
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1643
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr604
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1644
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1645
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart106 = union {
  box { // Cube1646
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1647
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1648
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1649
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1650
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart107 = union {
  box { // Cube1651
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1652
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1653
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1654
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1655
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart108 = union {
  box { // Cube1656
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1657
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1658
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1659
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1660
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart109 = union {
  box { // Cube1661
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1662
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1663
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1664
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1665
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart110 = union {
  box { // Cube1666
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1667
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1668
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1669
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1670
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr625
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr626
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart111 = union {
  box { // Cube1675
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube1676
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube1677
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr627
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube1678
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube1679
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock13 = union {
  object { railingMgroup13 }
  box { // Cube1635
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart104 }
  object { windowMpart105 }
  object { windowMpart106 }
  object { windowMpart107 }
  object { windowMpart108 }
  object { windowMpart109 }
  object { windowMpart110 }
  box { // Cube1671
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube1672
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube1673
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube1674
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart111 }
  translate  <13.71575, 13.222295, 73.165269>
}
#declare houseMblockMgroup1 = union {
  box { // Cube844
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <7.824406, 58.380085, 4.0>
    translate  <66.022599, 54.089578, 77.0>
  }
  object { houseMblock7 }
  object { railMcorner2 }
  object { houseMblock8 }
  object { houseMblock9 }
  object { houseMblock10 }
  object { railMcorner3 }
  object { houseMblock11 }
  object { houseMblock12 }
  object { houseMblock13 }
  translate  <0.0, -3.209311, 9.0>
}
#declare railMpart64 = union {
  box { // Cube728
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube729
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube730
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube731
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube732
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube733
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube734
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart65 = union {
  box { // Cube735
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube736
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube737
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube738
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube739
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube740
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube741
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart66 = union {
  box { // Cube742
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube743
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube744
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube745
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube746
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube747
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube748
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart67 = union {
  box { // Cube749
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube750
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube751
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube752
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube753
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube754
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube755
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart68 = union {
  box { // Cube756
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube757
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube758
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube759
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube760
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube761
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube762
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart69 = union {
  box { // Cube763
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube764
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube765
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube766
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube767
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube768
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube769
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart70 = union {
  box { // Cube770
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube771
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube772
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube773
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube774
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube775
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube776
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart71 = union {
  box { // Cube777
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube778
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube779
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube780
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube781
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube782
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube783
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart72 = union {
  box { // Cube784
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube785
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube786
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube787
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube788
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube789
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube790
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart73 = union {
  box { // Cube791
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube792
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube793
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube794
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube795
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube796
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube797
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup6 = union {
  object { railMpart64 }
  object { railMpart65 }
  object { railMpart66 }
  object { railMpart67 }
  object { railMpart68 }
  object { railMpart69 }
  object { railMpart70 }
  object { railMpart71 }
  object { railMpart72 }
  object { railMpart73 }
}
#declare windowMpart48 = union {
  box { // Cube799
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube800
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube801
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube802
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube803
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart49 = union {
  box { // Cube804
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube805
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube806
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube807
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube808
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart50 = union {
  box { // Cube809
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube810
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube811
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube812
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube813
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart51 = union {
  box { // Cube814
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube815
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube816
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube817
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube818
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart52 = union {
  box { // Cube819
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube820
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube821
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube822
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube823
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart53 = union {
  box { // Cube824
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube825
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube826
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube827
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube828
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart54 = union {
  box { // Cube829
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube830
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube831
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube832
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube833
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart55 = union {
  box { // Cube838
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube839
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube840
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube841
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube842
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock6 = union {
  object { railingMgroup6 }
  box { // Cube798
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart48 }
  object { windowMpart49 }
  object { windowMpart50 }
  object { windowMpart51 }
  object { windowMpart52 }
  object { windowMpart53 }
  object { windowMpart54 }
  box { // Cube834
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube835
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube836
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube837
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart55 }
  rotate 180.0*z
  translate  <53.71575, 94.0, 73.165269>
}
#declare railMpart62 = union {
  box { // Cube713
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube714
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube715
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube716
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube717
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube718
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube719
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart63 = union {
  box { // Cube720
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube721
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube722
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube723
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube724
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube725
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube726
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner1 = union {
  object { railMpart62 }
  object { railMpart63 }
  box { // Cube727
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
  rotate -90.0*z
  translate  <0.479885, 107.73253, 0.0>
}
#declare railMpart52 = union {
  box { // Cube598
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube599
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube600
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube601
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube602
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube603
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube604
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart53 = union {
  box { // Cube605
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube606
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube607
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube608
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube609
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube610
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube611
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart54 = union {
  box { // Cube612
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube613
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube614
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube615
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube616
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube617
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube618
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart55 = union {
  box { // Cube619
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube620
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube621
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube622
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube623
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube624
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube625
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart56 = union {
  box { // Cube626
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube627
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube628
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube629
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube630
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube631
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube632
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart57 = union {
  box { // Cube633
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube634
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube635
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube636
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube637
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube638
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube639
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart58 = union {
  box { // Cube640
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube641
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube642
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube643
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube644
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube645
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube646
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart59 = union {
  box { // Cube647
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube648
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube649
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube650
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube651
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube652
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube653
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart60 = union {
  box { // Cube654
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube655
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube656
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube657
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube658
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube659
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube660
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart61 = union {
  box { // Cube661
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube662
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube663
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube664
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube665
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube666
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube667
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup5 = union {
  object { railMpart52 }
  object { railMpart53 }
  object { railMpart54 }
  object { railMpart55 }
  object { railMpart56 }
  object { railMpart57 }
  object { railMpart58 }
  object { railMpart59 }
  object { railMpart60 }
  object { railMpart61 }
}
#declare windowMpart40 = union {
  box { // Cube669
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube670
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube671
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube672
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube673
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart41 = union {
  box { // Cube674
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube675
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube676
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube677
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube678
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart42 = union {
  box { // Cube679
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube680
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube681
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube682
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube683
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart43 = union {
  box { // Cube684
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube685
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube686
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube687
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube688
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart44 = union {
  box { // Cube689
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube690
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube691
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube692
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube693
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart45 = union {
  box { // Cube694
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube695
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube696
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube697
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube698
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart46 = union {
  box { // Cube699
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube700
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube701
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube702
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube703
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart47 = union {
  box { // Cube708
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube709
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube710
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube711
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube712
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock5 = union {
  object { railingMgroup5 }
  box { // Cube668
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart40 }
  object { windowMpart41 }
  object { windowMpart42 }
  object { windowMpart43 }
  object { windowMpart44 }
  object { windowMpart45 }
  object { windowMpart46 }
  box { // Cube704
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube705
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube706
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube707
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart47 }
  rotate 180.0*z
  translate  <13.71575, 94.0, 73.165269>
}
#declare railMpart42 = union {
  box { // Cube483
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube484
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube485
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube486
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube487
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube488
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube489
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart43 = union {
  box { // Cube490
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube491
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube492
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube493
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube494
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube495
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube496
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart44 = union {
  box { // Cube497
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube498
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube499
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube500
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube501
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube502
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube503
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart45 = union {
  box { // Cube504
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube505
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube506
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube507
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube508
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube509
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube510
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart46 = union {
  box { // Cube511
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube512
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube513
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube514
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube515
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube516
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube517
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart47 = union {
  box { // Cube518
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube519
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube520
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube521
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube522
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube523
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube524
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart48 = union {
  box { // Cube525
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube526
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube527
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube528
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube529
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube530
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube531
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart49 = union {
  box { // Cube532
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube533
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube534
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube535
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube536
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube537
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube538
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart50 = union {
  box { // Cube539
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube540
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube541
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube542
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube543
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube544
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube545
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart51 = union {
  box { // Cube546
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube547
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube548
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube549
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube550
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube551
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube552
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup4 = union {
  object { railMpart42 }
  object { railMpart43 }
  object { railMpart44 }
  object { railMpart45 }
  object { railMpart46 }
  object { railMpart47 }
  object { railMpart48 }
  object { railMpart49 }
  object { railMpart50 }
  object { railMpart51 }
}
#declare windowMpart32 = union {
  box { // Cube554
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube555
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube556
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube557
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube558
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart33 = union {
  box { // Cube559
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube560
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube561
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube562
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube563
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart34 = union {
  box { // Cube564
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube565
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube566
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube567
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube568
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart35 = union {
  box { // Cube569
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube570
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube571
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube572
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube573
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart36 = union {
  box { // Cube574
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube575
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube576
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube577
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube578
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart37 = union {
  box { // Cube579
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube580
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube581
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube582
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube583
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart38 = union {
  box { // Cube584
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube585
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube586
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube587
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube588
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart39 = union {
  box { // Cube593
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube594
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube595
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube596
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube597
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock4 = union {
  object { railingMgroup4 }
  box { // Cube553
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart32 }
  object { windowMpart33 }
  object { windowMpart34 }
  object { windowMpart35 }
  object { windowMpart36 }
  object { windowMpart37 }
  object { windowMpart38 }
  box { // Cube589
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube590
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube591
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube592
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart39 }
  rotate -90.0*z
  translate  <13.71575, 93.625383, 73.165269>
}
#declare railMpart32 = union {
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart33 = union {
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart34 = union {
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart35 = union {
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart36 = union {
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart37 = union {
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube405
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube406
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube407
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube409
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart38 = union {
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube412
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube413
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube414
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube415
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube416
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart39 = union {
  box { // Cube417
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube418
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube419
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube420
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube421
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube422
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube423
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart40 = union {
  box { // Cube424
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube425
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube426
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube427
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube428
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube429
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube430
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart41 = union {
  box { // Cube431
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube432
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube433
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube434
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube435
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube436
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube437
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup3 = union {
  object { railMpart32 }
  object { railMpart33 }
  object { railMpart34 }
  object { railMpart35 }
  object { railMpart36 }
  object { railMpart37 }
  object { railMpart38 }
  object { railMpart39 }
  object { railMpart40 }
  object { railMpart41 }
}
#declare windowMpart24 = union {
  box { // Cube439
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube440
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube441
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube442
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube443
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart25 = union {
  box { // Cube444
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube445
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube446
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube447
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube448
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart26 = union {
  box { // Cube449
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube450
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube451
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube452
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube453
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart27 = union {
  box { // Cube454
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube455
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube456
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube457
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube458
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart28 = union {
  box { // Cube459
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube460
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube461
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube462
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube463
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart29 = union {
  box { // Cube464
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube465
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube466
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube467
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube468
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart30 = union {
  box { // Cube469
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube470
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube471
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube472
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube473
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart31 = union {
  box { // Cube478
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube479
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube480
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube481
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube482
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock3 = union {
  object { railingMgroup3 }
  box { // Cube438
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart24 }
  object { windowMpart25 }
  object { windowMpart26 }
  object { windowMpart27 }
  object { windowMpart28 }
  object { windowMpart29 }
  object { windowMpart30 }
  box { // Cube474
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube475
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube476
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube477
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart31 }
  rotate -90.0*z
  translate  <13.71575, 53.625383, 73.165269>
}
#declare railMpart31 = union {
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart30 = union {
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner = union {
  object { railMpart31 }
  object { railMpart30 }
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
}
#declare railMpart20 = union {
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart21 = union {
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart22 = union {
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart23 = union {
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart24 = union {
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart25 = union {
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart26 = union {
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart27 = union {
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart28 = union {
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart29 = union {
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup2 = union {
  object { railMpart20 }
  object { railMpart21 }
  object { railMpart22 }
  object { railMpart23 }
  object { railMpart24 }
  object { railMpart25 }
  object { railMpart26 }
  object { railMpart27 }
  object { railMpart28 }
  object { railMpart29 }
}
#declare windowMpart16 = union {
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart17 = union {
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart18 = union {
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart19 = union {
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart20 = union {
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart21 = union {
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart22 = union {
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart23 = union {
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock2 = union {
  object { railingMgroup2 }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart16 }
  object { windowMpart17 }
  object { windowMpart18 }
  object { windowMpart19 }
  object { windowMpart20 }
  object { windowMpart21 }
  object { windowMpart22 }
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart23 }
  rotate -90.0*z
  translate  <13.71575, 13.625383, 73.165269>
}
#declare railMpart10 = union {
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart11 = union {
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart12 = union {
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart13 = union {
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart14 = union {
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart15 = union {
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart16 = union {
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart17 = union {
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart18 = union {
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart19 = union {
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup1 = union {
  object { railMpart10 }
  object { railMpart11 }
  object { railMpart12 }
  object { railMpart13 }
  object { railMpart14 }
  object { railMpart15 }
  object { railMpart16 }
  object { railMpart17 }
  object { railMpart18 }
  object { railMpart19 }
}
#declare windowMpart8 = union {
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart9 = union {
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart10 = union {
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart11 = union {
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart12 = union {
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart13 = union {
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart14 = union {
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart15 = union {
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock1 = union {
  object { railingMgroup1 }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart8 }
  object { windowMpart9 }
  object { windowMpart10 }
  object { windowMpart11 }
  object { windowMpart12 }
  object { windowMpart13 }
  object { windowMpart14 }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart15 }
  translate  <53.71575, 13.222295, 73.165269>
}
#declare railMpart9 = union {
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart8 = union {
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart7 = union {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart6 = union {
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart5 = union {
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart4 = union {
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart3 = union {
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart2 = union {
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart1 = union {
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup = union {
  object { railMpart9 }
  object { railMpart8 }
  object { railMpart7 }
  object { railMpart6 }
  object { railMpart5 }
  object { railMpart4 }
  object { railMpart3 }
  object { railMpart2 }
  object { railMpart1 }
  object { railMpart }
}
#declare windowMpart7 = union {
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart6 = union {
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart5 = union {
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart4 = union {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart3 = union {
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart2 = union {
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart1 = union {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart = union {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock = union {
  object { railingMgroup }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart7 }
  object { windowMpart6 }
  object { windowMpart5 }
  object { windowMpart4 }
  object { windowMpart3 }
  object { windowMpart2 }
  object { windowMpart1 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart }
  translate  <13.71575, 13.222295, 73.165269>
}
#declare houseMblockMgroup = union {
  box { // Cube843
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <7.824406, 58.380085, 4.0>
    translate  <66.022599, 54.089578, 77.0>
  }
  object { houseMblock6 }
  object { railMcorner1 }
  object { houseMblock5 }
  object { houseMblock4 }
  object { houseMblock3 }
  object { railMcorner }
  object { houseMblock2 }
  object { houseMblock1 }
  object { houseMblock }
  translate  -3.209311*y
}
#declare railMpart296 = union {
  box { // Cube3402
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3403
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3404
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3405
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3406
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3407
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3408
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart297 = union {
  box { // Cube3409
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3410
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3411
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3412
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3413
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3414
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3471
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner8 = union {
  object { railMpart296 }
  object { railMpart297 }
  box { // Cube3472
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
  rotate 90.0*z
  translate  <99.217326, -0.574964, 8.750755>
}
#declare railMpart298 = union {
  box { // Cube3415
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3416
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3417
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3418
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3419
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3420
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3421
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart299 = union {
  box { // Cube3422
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3423
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3424
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3425
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3426
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3427
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3428
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart300 = union {
  box { // Cube3429
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3430
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3431
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3432
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3433
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3434
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3435
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart301 = union {
  box { // Cube3436
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3437
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3438
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3439
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3440
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3441
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3442
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart302 = union {
  box { // Cube3443
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3444
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3445
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3446
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3447
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3448
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3449
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart303 = union {
  box { // Cube3450
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3451
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3452
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3453
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3454
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3455
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3456
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart304 = union {
  box { // Cube3457
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3458
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3459
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3460
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3461
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3462
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3463
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart305 = union {
  box { // Cube3464
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube3465
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube3466
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube3467
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube3468
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube3469
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube3470
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup28 = union {
  object { railMpart298 }
  object { railMpart299 }
  object { railMpart300 }
  object { railMpart301 }
  object { railMpart302 }
  object { railMpart303 }
  object { railMpart304 }
  object { railMpart305 }
  translate  <93.535371, 13.185049, 81.8024>
}
#declare balconyMpart = union {
  object { railMcorner8 }
  box { // Cube3401
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <16.0, 2.0, 0.5>
    translate  <89.656714, -8.695873, 81.353726>
  }
  object { railingMgroup28 }
}
#declare damage = difference {
  box { // largeMhouseMblock
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <16.870214, 44.979382, 20.0>
    rotate -180.0*z
    translate  <89.893937, 45.640974, 91.708161>
  }
  box { // Cube3400
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale 10.0
    rotate <8.120702, 3.680658, 0.524816>
    translate  <99.981093, 4.280606, 105.454308>
  }
}
#declare damagedMhouse = union {
  box { // Cube3473
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <10.0, 10.0, 12.0>
    translate  <95.737573, 11.297858, 98.492063>
  }
  object { damage }
  scale <1.111111, 1.111111, 1.0>
  translate  <-8.256758, -7.614936, 0.126462>
}
#declare platformMhouse = union {
  object { chimneyMpart2 }
  object { chimneyMpart1 }
  object { chimneyMpart }
  object { houseMblockMgroup3 }
  object { houseMblockMgroup2 }
  object { houseMblockMgroup1 }
  object { houseMblockMgroup }
  object { balconyMpart }
  object { damagedMhouse }
  scale <0.9, 0.9, 1.0>
  translate  <7.431082, 6.853442, -0.126462>
}
#declare ringstrebeMpart3 = union {
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  100.0*z
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  95.0*z
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  90.0*z
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  85.0*z
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  80.0*z
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  75.0*z
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  70.0*z
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  65.0*z
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  60.0*z
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  55.0*z
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  50.0*z
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  45.0*z
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  40.0*z
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  35.0*z
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  30.0*z
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  25.0*z
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  20.0*z
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  15.0*z
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  10.0*z
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  5.0*z
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 100.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <3.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <-4.406747, -0.0, 55.360106>
  }
  rotate <90.0, 90.0, 0.0>
  translate  <97.83549, 100.637837, 55.13848>
}
#declare ringstrebeMpart2 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  100.0*z
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  95.0*z
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  90.0*z
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  85.0*z
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  80.0*z
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  75.0*z
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  70.0*z
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  65.0*z
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  60.0*z
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  55.0*z
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  50.0*z
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  45.0*z
  }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  40.0*z
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  35.0*z
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  30.0*z
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  25.0*z
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  20.0*z
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  15.0*z
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  10.0*z
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  5.0*z
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 100.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <3.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <-4.406747, -0.0, 55.360106>
  }
  rotate <90.0, 90.0, 0.0>
  translate  <0.90393, 101.099721, 54.98066>
}
#declare ringstrebeMpart1 = union {
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  100.0*z
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  95.0*z
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  90.0*z
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  85.0*z
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  80.0*z
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  75.0*z
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  70.0*z
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  65.0*z
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  60.0*z
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  55.0*z
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  50.0*z
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  45.0*z
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  40.0*z
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  35.0*z
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  30.0*z
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  25.0*z
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  20.0*z
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  15.0*z
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  10.0*z
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  5.0*z
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 100.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <3.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <-4.406747, -0.0, 55.360106>
  }
  rotate 90.0*y
  translate  <-0.620602, 96.817677, 55.13848>
}
#declare ringstrebeMpart = union {
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  100.0*z
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  95.0*z
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  90.0*z
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  85.0*z
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  80.0*z
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  75.0*z
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  70.0*z
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  65.0*z
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  60.0*z
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  55.0*z
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  50.0*z
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  45.0*z
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  40.0*z
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  35.0*z
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  30.0*z
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  25.0*z
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  20.0*z
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  15.0*z
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  10.0*z
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    translate  5.0*z
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 100.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <3.0, 3.0, 6.0>
    rotate -90.0*y
    translate  <-4.406747, -0.0, 55.360106>
  }
  rotate 90.0*y
  translate  <-1.082485, 2.367762, 55.13848>
}
#declare legMpart3 = union {
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <21.424953, 0.0, 59.192076>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <17.302511, 0.0, 55.069634>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <11.680999, 0.0, 49.448123>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <6.809023, 0.0, 44.576146>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate 45.0*y
    translate  <2.311814, 0.0, 37.830332>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 18.800774, 54.125125>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 13.719484, 49.551964>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 9.146323, 45.486932>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 2.540645, 37.864996>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -6.994225, 55.562463>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.977967, 47.432399>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.469838, 39.302334>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 29.800397>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 19.566136>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 9.902638>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate <0.0, 45.0, 90.0>
    translate  42.438157*z
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate 45.0*y
    translate  42.438157*z
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <2.0, -6.0, 0.0>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <-2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <-2.0, -6.0, 0.0>
  }
  cone { // Cone004
    <0,0,0>, 5.5, <0,0,1>, 7.0
    material {
      rust2
    }
    scale <1.0, 1.0, 20.0>
    translate  40.0*z
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <6.05, 5.5, 22.0>
    translate  20.0*z
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <5.5, 5.5, 20.0>
  }
  rotate 90.0*z
  translate  <90.0, 10.0, 0.0>
}
#declare legMpart2 = union {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <21.424953, 0.0, 59.192076>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <17.302511, 0.0, 55.069634>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <11.680999, 0.0, 49.448123>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <6.809023, 0.0, 44.576146>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate 45.0*y
    translate  <2.311814, 0.0, 37.830332>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 18.800774, 54.125125>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 13.719484, 49.551964>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 9.146323, 45.486932>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 2.540645, 37.864996>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -6.994225, 55.562463>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.977967, 47.432399>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.469838, 39.302334>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 29.800397>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 19.566136>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 9.902638>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate <0.0, 45.0, 90.0>
    translate  42.438157*z
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate 45.0*y
    translate  42.438157*z
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <2.0, -6.0, 0.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <-2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <-2.0, -6.0, 0.0>
  }
  cone { // Cone003
    <0,0,0>, 5.5, <0,0,1>, 7.0
    material {
      rust2
    }
    scale <1.0, 1.0, 20.0>
    translate  40.0*z
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <6.05, 5.5, 22.0>
    translate  20.0*z
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <5.5, 5.5, 20.0>
  }
  rotate 180.0*z
  translate  <90.0, 90.0, 0.0>
}
#declare legMpart1 = union {
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <21.424953, 0.0, 59.192076>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <17.302511, 0.0, 55.069634>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <11.680999, 0.0, 49.448123>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <6.809023, 0.0, 44.576146>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate 45.0*y
    translate  <2.311814, 0.0, 37.830332>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 18.800774, 54.125125>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 13.719484, 49.551964>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 9.146323, 45.486932>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 2.540645, 37.864996>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -6.994225, 55.562463>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.977967, 47.432399>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.469838, 39.302334>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 29.800397>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 19.566136>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 9.902638>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate <0.0, 45.0, 90.0>
    translate  42.438157*z
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate 45.0*y
    translate  42.438157*z
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <2.0, -6.0, 0.0>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <-2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <-2.0, -6.0, 0.0>
  }
  cone { // Cone002
    <0,0,0>, 5.5, <0,0,1>, 7.0
    material {
      rust2
    }
    scale <1.0, 1.0, 20.0>
    translate  40.0*z
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <6.05, 5.5, 22.0>
    translate  20.0*z
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <5.5, 5.5, 20.0>
  }
  rotate -90.0*z
  translate  <10.0, 90.0, 0.0>
}
#declare legMpart = union {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <21.424953, 0.0, 59.192076>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <17.302511, 0.0, 55.069634>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <11.680999, 0.0, 49.448123>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 2.0>
    rotate 45.0*y
    translate  <6.809023, 0.0, 44.576146>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate 45.0*y
    translate  <2.311814, 0.0, 37.830332>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 18.800774, 54.125125>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 13.719484, 49.551964>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 2.0, 1.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 9.146323, 45.486932>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <1.0, 1.0, 35.0>
    rotate <0.0, 45.0, 90.0>
    translate  <0.0, 2.540645, 37.864996>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -6.994225, 55.562463>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.977967, 47.432399>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.469838, 39.302334>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 29.800397>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 19.566136>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <4.0, 2.0, 1.0>
    translate  <-0.075727, -5.05671, 9.902638>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate <0.0, 45.0, 90.0>
    translate  42.438157*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <3.0, 3.0, 30.0>
    rotate 45.0*y
    translate  42.438157*z
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <2.0, -6.0, 0.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 20.0>
    rotate 5.861329*x
    translate  <-2.0, -5.984417, 39.93043>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 40.0>
    translate  <-2.0, -6.0, 0.0>
  }
  cone { // Cone001
    <0,0,0>, 5.5, <0,0,1>, 7.0
    material {
      rust2
    }
    scale <1.0, 1.0, 20.0>
    translate  40.0*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <6.05, 5.5, 22.0>
    translate  20.0*z
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <5.5, 5.5, 20.0>
  }
  translate  <10.0, 10.0, 0.0>
}
#declare ringstrebeMpart5 = union {
  cylinder { // Cylndr1101
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  100.0*z
  }
  cylinder { // Cylndr1102
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  95.0*z
  }
  cylinder { // Cylndr1103
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  90.0*z
  }
  cylinder { // Cylndr1104
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  85.0*z
  }
  cylinder { // Cylndr1105
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  80.0*z
  }
  cylinder { // Cylndr1106
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  75.0*z
  }
  cylinder { // Cylndr1107
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  70.0*z
  }
  cylinder { // Cylndr1108
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  65.0*z
  }
  cylinder { // Cylndr1109
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  60.0*z
  }
  cylinder { // Cylndr1110
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  55.0*z
  }
  cylinder { // Cylndr1111
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  50.0*z
  }
  cylinder { // Cylndr1112
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  45.0*z
  }
  cylinder { // Cylndr1113
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  40.0*z
  }
  cylinder { // Cylndr1114
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  35.0*z
  }
  cylinder { // Cylndr1115
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  30.0*z
  }
  cylinder { // Cylndr1116
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  25.0*z
  }
  cylinder { // Cylndr1117
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  20.0*z
  }
  cylinder { // Cylndr1118
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  15.0*z
  }
  cylinder { // Cylndr1119
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  10.0*z
  }
  cylinder { // Cylndr1120
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  5.0*z
  }
  cylinder { // Cylndr1121
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
  }
  cylinder { // Cylndr1122
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 100.0>
  }
  scale <1.4, 1.0, 1.25>
  rotate 90.0*y
  translate  <-13.030601, 114.0, 70.533605>
}
#declare ringstrebeMpart4 = union {
  cylinder { // Cylndr1079
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  100.0*z
  }
  cylinder { // Cylndr1080
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  95.0*z
  }
  cylinder { // Cylndr1081
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  90.0*z
  }
  cylinder { // Cylndr1082
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  85.0*z
  }
  cylinder { // Cylndr1083
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  80.0*z
  }
  cylinder { // Cylndr1084
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  75.0*z
  }
  cylinder { // Cylndr1085
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  70.0*z
  }
  cylinder { // Cylndr1086
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  65.0*z
  }
  cylinder { // Cylndr1087
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  60.0*z
  }
  cylinder { // Cylndr1088
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  55.0*z
  }
  cylinder { // Cylndr1089
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  50.0*z
  }
  cylinder { // Cylndr1090
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  45.0*z
  }
  cylinder { // Cylndr1091
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  40.0*z
  }
  cylinder { // Cylndr1092
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  35.0*z
  }
  cylinder { // Cylndr1093
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  30.0*z
  }
  cylinder { // Cylndr1094
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  25.0*z
  }
  cylinder { // Cylndr1095
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  20.0*z
  }
  cylinder { // Cylndr1096
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  15.0*z
  }
  cylinder { // Cylndr1097
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  10.0*z
  }
  cylinder { // Cylndr1098
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    translate  5.0*z
  }
  cylinder { // Cylndr1099
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
  }
  cylinder { // Cylndr1100
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 100.0>
  }
  scale <1.4, 1.0, 1.25>
  rotate 90.0*y
  translate  <-13.030601, -14.034773, 70.533605>
}
#declare platformMbasis = union {
  object { ringstrebeMpart3 }
  object { ringstrebeMpart2 }
  object { ringstrebeMpart1 }
  object { ringstrebeMpart }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <3.0, 3.0, 140.0>
    rotate <-45.0, 90.0, 0.0>
    translate  <0.788729, 0.271632, 58.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <3.0, 3.0, 140.0>
    rotate <45.0, 90.0, 0.0>
    translate  <0.900833, 99.674921, 58.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <64.0, 64.0, 2.0>
    translate  <50.0, 50.0, 70.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <60.0, 60.0, 2.0>
    translate  <50.0, 50.0, 66.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <64.0, 64.0, 2.0>
    translate  <50.0, 50.0, 62.0>
  }
  object { legMpart3 }
  object { legMpart2 }
  object { legMpart1 }
  object { legMpart }
  box { // Cube3399
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <60.0, 1.0, 0.5>
    rotate -90.0*z
    translate  <-13.945243, 50.388012, 70.553991>
  }
  box { // Cube3398
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <60.0, 1.0, 0.5>
    rotate -90.0*z
    translate  <113.907999, 50.430129, 70.682667>
  }
  box { // Cube3397
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <60.0, 1.0, 0.5>
    rotate -90.0*z
    translate  <113.907999, 50.796613, 62.253521>
  }
  box { // Cube3396
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <60.0, 1.0, 0.5>
    rotate -90.0*z
    translate  <-13.945243, 49.749514, 62.253521>
  }
  box { // Cube3395
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <60.0, 1.0, 0.5>
    translate  <50.25368, 114.17031, 62.253521>
  }
  box { // Cube3394
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <60.0, 1.0, 0.5>
    translate  <50.25368, -14.449408, 62.253521>
  }
  object { ringstrebeMpart5 }
  object { ringstrebeMpart4 }
  box { // Cube3474
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <61.0, 61.0, 1.0>
    translate  <50.0, 50.0, 66.0>
  }
}
#declare Group019 = union {
  box { // Cube3541
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3542
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3543
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1154
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group020 = union {
  box { // Cube3544
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3545
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3546
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1155
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group021 = union {
  box { // Cube3547
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3548
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3549
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1156
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart6 = union {
  object { Group019 }
  object { Group020 }
  object { Group021 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group022 = union {
  box { // Cube3550
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3551
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3552
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1157
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group023 = union {
  box { // Cube3553
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3554
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3555
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1158
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group024 = union {
  box { // Cube3556
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3557
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3558
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1159
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart7 = union {
  object { Group022 }
  object { Group023 }
  object { Group024 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group025 = union {
  box { // Cube3559
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3560
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3561
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1160
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group026 = union {
  box { // Cube3562
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3563
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3564
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1161
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group027 = union {
  box { // Cube3565
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3566
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3567
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1162
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart8 = union {
  object { Group025 }
  object { Group026 }
  object { Group027 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare endMpart3 = union {
  cylinder { // Cylndr1172
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1173
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1174
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3595
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3596
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3597
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger1 = union {
  cylinder { // Cylndr1150
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { StrebeMpart6 }
  object { StrebeMpart7 }
  object { StrebeMpart8 }
  object { endMpart3 }
  rotate <-0.0, -0.0, -0.0>
  translate  <26.71912, -12.14948, -13.678116>
  scale <3.0, 3.0, 2.0>
  rotate <11.069156, 17.135855, 33.58326>
  translate  <2.141127, -0.140388, 6.685507>
}
#declare endMpart1 = union {
  cylinder { // Cylndr1144
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1145
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1146
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3535
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3536
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3537
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-26.294875, 11.925657, 0.108806>
}
#declare Group016 = union {
  box { // Cube3526
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3527
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3528
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1141
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group017 = union {
  box { // Cube3529
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3530
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3531
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1142
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group018 = union {
  box { // Cube3532
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3533
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3534
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1143
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart5 = union {
  object { Group016 }
  object { Group017 }
  object { Group018 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group013 = union {
  box { // Cube3517
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3518
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3519
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1138
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group014 = union {
  box { // Cube3520
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3521
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3522
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1139
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group015 = union {
  box { // Cube3523
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3524
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3525
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1140
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart4 = union {
  object { Group013 }
  object { Group014 }
  object { Group015 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group010 = union {
  box { // Cube3508
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3509
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3510
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1135
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group011 = union {
  box { // Cube3511
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3512
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3513
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1136
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group012 = union {
  box { // Cube3514
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3515
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3516
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1137
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart3 = union {
  object { Group010 }
  object { Group011 }
  object { Group012 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare Group007 = union {
  box { // Cube3499
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3500
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3501
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1132
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group008 = union {
  box { // Cube3502
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3503
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3504
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1133
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group009 = union {
  box { // Cube3505
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3506
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3507
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1134
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart2 = union {
  object { Group007 }
  object { Group008 }
  object { Group009 }
  translate  <-27.794253, 11.919136, 8.046751>
}
#declare Group004 = union {
  box { // Cube3490
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3491
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3492
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1129
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group005 = union {
  box { // Cube3493
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3494
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3495
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1130
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group006 = union {
  box { // Cube3496
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3497
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3498
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1131
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart1 = union {
  object { Group004 }
  object { Group005 }
  object { Group006 }
  translate  <-27.794253, 11.919136, 4.046751>
}
#declare Group001 = union {
  box { // Cube3478
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3479
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3480
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1123
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group002 = union {
  box { // Cube3481
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3482
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3483
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1124
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group003 = union {
  box { // Cube3484
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3485
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3486
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1125
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart = union {
  object { Group001 }
  object { Group002 }
  object { Group003 }
  translate  <-27.794253, 11.919136, 0.046751>
}
#declare endMpart = union {
  cylinder { // Cylndr1126
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1127
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1128
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3487
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3488
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3489
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger = union {
  cylinder { // Cylndr1147
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { endMpart1 }
  object { StrebeMpart5 }
  object { StrebeMpart4 }
  object { StrebeMpart3 }
  object { StrebeMpart2 }
  object { StrebeMpart1 }
  object { StrebeMpart }
  object { endMpart }
  rotate <-0.0, -0.0, -0.0>
  translate  <27.043577, -12.351519, 2.615767>
  scale 3.0
  rotate <9.647342, -17.210249, -29.87809>
  translate  <-7.800329, 0.015998, 5.158919>
}
#declare krahn = union {
  cylinder { // Cylndr1153
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    scale <0.2, 0.2, 50.0>
    rotate -45.612755*y
    translate  <7.513612, 1.251085, 28.076141>
  }
  cylinder { // Cylndr1152
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    scale <0.2, 0.2, 50.0>
    rotate -45.612755*y
    translate  <7.669998, -1.563857, 28.076141>
  }
  cylinder { // Cylndr1151
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <2.0, 2.0, 6.0>
    rotate -90.0*x
    translate  <7.695465, -3.127714, 26.999318>
  }
  object { ausleger1 }
  cylinder { // Cylndr1149
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <5.0, 5.0, 2.0>
    translate  <-2.289882, 0.0, -10.0>
  }
  cylinder { // Cylndr1148
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <4.0, 4.0, 25.0>
    translate  <-2.289882, 0.0, -26.715289>
  }
  box { // Cube3477
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <4.0, 4.0, 2.0>
    translate  <-3.446197, 0.0, 6.203155>
  }
  object { ausleger }
  box { // Cube3476
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <4.0, 6.0, 4.0>
    rotate -8.018505*y
    translate  <-12.176691, 0.0, -0.974012>
  }
  box { // Cube3475
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <10.0, 8.0, 5.0>
  }
  scale 0.5
  rotate -11.294664*z
  translate  <4.895798, 96.35978, 117.059939>
}
#declare Group028 = union {
  box { // Cube3568
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3569
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3570
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1167
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group029 = union {
  box { // Cube3571
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3572
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3573
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1168
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group030 = union {
  box { // Cube3574
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3575
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3576
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1169
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart9 = union {
  object { Group028 }
  object { Group029 }
  object { Group030 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group031 = union {
  box { // Cube3577
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3578
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3579
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1170
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group032 = union {
  box { // Cube3580
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3581
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3582
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1171
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group033 = union {
  box { // Cube3583
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3584
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3585
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1175
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart10 = union {
  object { Group031 }
  object { Group032 }
  object { Group033 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group034 = union {
  box { // Cube3586
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3587
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3588
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1176
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group035 = union {
  box { // Cube3589
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3590
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3591
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1177
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group036 = union {
  box { // Cube3592
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3593
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3594
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1178
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart11 = union {
  object { Group034 }
  object { Group035 }
  object { Group036 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare endMpart4 = union {
  cylinder { // Cylndr1179
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1180
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1181
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3598
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3599
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3600
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger2 = union {
  cylinder { // Cylndr1166
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { StrebeMpart9 }
  object { StrebeMpart10 }
  object { StrebeMpart11 }
  object { endMpart4 }
  rotate <-0.0, -0.0, -0.0>
  translate  <26.71912, -12.14948, -13.678116>
  scale <3.0, 3.0, 2.0>
  rotate <11.069156, 17.135855, 33.58326>
  translate  <2.141127, -0.140388, 6.685507>
}
#declare endMpart2 = union {
  cylinder { // Cylndr1185
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1186
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1187
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3539
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3540
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3601
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-26.294875, 11.925657, 0.108806>
}
#declare Group037 = union {
  box { // Cube3602
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3603
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3604
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1188
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group038 = union {
  box { // Cube3605
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3606
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3607
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1189
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group039 = union {
  box { // Cube3608
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3609
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3610
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1190
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart12 = union {
  object { Group037 }
  object { Group038 }
  object { Group039 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group040 = union {
  box { // Cube3611
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3612
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3613
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1191
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group041 = union {
  box { // Cube3614
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3615
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3616
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1192
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group042 = union {
  box { // Cube3617
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3618
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3619
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1193
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart13 = union {
  object { Group040 }
  object { Group041 }
  object { Group042 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group043 = union {
  box { // Cube3620
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3621
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3622
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1194
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group044 = union {
  box { // Cube3623
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3624
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3625
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1195
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group045 = union {
  box { // Cube3626
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3627
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3628
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1196
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart14 = union {
  object { Group043 }
  object { Group044 }
  object { Group045 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare Group046 = union {
  box { // Cube3629
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3630
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3631
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1197
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group047 = union {
  box { // Cube3632
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3633
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3634
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1198
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group048 = union {
  box { // Cube3635
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3636
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3637
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1199
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart15 = union {
  object { Group046 }
  object { Group047 }
  object { Group048 }
  translate  <-27.794253, 11.919136, 8.046751>
}
#declare Group049 = union {
  box { // Cube3638
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3639
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3640
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1200
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group050 = union {
  box { // Cube3641
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3642
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3643
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1201
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group051 = union {
  box { // Cube3644
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3645
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3646
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1202
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart16 = union {
  object { Group049 }
  object { Group050 }
  object { Group051 }
  translate  <-27.794253, 11.919136, 4.046751>
}
#declare Group052 = union {
  box { // Cube3647
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3648
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3649
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1203
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group053 = union {
  box { // Cube3650
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3651
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3652
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1204
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group054 = union {
  box { // Cube3653
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3654
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3655
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1205
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart17 = union {
  object { Group052 }
  object { Group053 }
  object { Group054 }
  translate  <-27.794253, 11.919136, 0.046751>
}
#declare endMpart5 = union {
  cylinder { // Cylndr1206
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1207
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1208
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3656
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3657
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3658
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger3 = union {
  cylinder { // Cylndr1184
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { endMpart2 }
  object { StrebeMpart12 }
  object { StrebeMpart13 }
  object { StrebeMpart14 }
  object { StrebeMpart15 }
  object { StrebeMpart16 }
  object { StrebeMpart17 }
  object { endMpart5 }
  rotate <-0.0, -0.0, -0.0>
  translate  <27.043577, -12.351519, 2.615767>
  scale 3.0
  rotate <9.647342, -17.210249, -29.87809>
  translate  <-7.800329, 0.015998, 5.158919>
}
#declare krahn1 = union {
  cylinder { // Cylndr1163
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    scale <0.2, 0.2, 50.0>
    rotate -45.612755*y
    translate  <7.513612, 1.251085, 28.076141>
  }
  cylinder { // Cylndr1164
    <0,0,1>, <0,0,0>, 1 
    material {
      rust4
    }
    scale <0.2, 0.2, 50.0>
    rotate -45.612755*y
    translate  <7.669998, -1.563857, 28.076141>
  }
  cylinder { // Cylndr1165
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <2.0, 2.0, 6.0>
    rotate -90.0*x
    translate  <7.695465, -3.127714, 26.999318>
  }
  object { ausleger2 }
  cylinder { // Cylndr1182
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <5.0, 5.0, 2.0>
    translate  <-2.289882, 0.0, -10.0>
  }
  cylinder { // Cylndr1183
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <4.0, 4.0, 40.0>
    translate  <-2.249829, 0.824209, -40.743385>
  }
  box { // Cube3538
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <4.0, 4.0, 2.0>
    translate  <-3.446197, 0.0, 6.203155>
  }
  object { ausleger3 }
  box { // Cube3659
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <4.0, 6.0, 4.0>
    rotate -8.018505*y
    translate  <-12.176691, 0.0, -0.974012>
  }
  box { // Cube3660
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <10.0, 8.0, 5.0>
  }
  scale 0.5
  rotate <0.0, 0.0, -87.21785>
  translate  <88.159516, 80.087183, 125.777987>
}
#declare Group055 = union {
  box { // Cube3661
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3662
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3663
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1213
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group056 = union {
  box { // Cube3664
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3665
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3666
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1214
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group057 = union {
  box { // Cube3667
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3668
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3669
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1215
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart18 = union {
  object { Group055 }
  object { Group056 }
  object { Group057 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group058 = union {
  box { // Cube3670
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3671
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3672
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1216
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group059 = union {
  box { // Cube3673
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3674
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3675
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1217
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group060 = union {
  box { // Cube3676
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3677
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3678
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1218
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart19 = union {
  object { Group058 }
  object { Group059 }
  object { Group060 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group061 = union {
  box { // Cube3679
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3680
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3681
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1219
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group062 = union {
  box { // Cube3682
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3683
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3684
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1220
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group063 = union {
  box { // Cube3685
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3686
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3687
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1221
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart20 = union {
  object { Group061 }
  object { Group062 }
  object { Group063 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare endMpart6 = union {
  cylinder { // Cylndr1222
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1223
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1224
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3688
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3689
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3690
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger4 = union {
  cylinder { // Cylndr1212
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { StrebeMpart18 }
  object { StrebeMpart19 }
  object { StrebeMpart20 }
  object { endMpart6 }
  rotate <-0.0, -0.0, -0.0>
  translate  <26.71912, -12.14948, -13.678116>
  scale <3.0, 3.0, 2.0>
  rotate <11.069156, 17.135855, 33.58326>
  translate  <2.141127, -0.140388, 6.685507>
}
#declare endMpart7 = union {
  cylinder { // Cylndr1228
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1229
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1230
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3692
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3693
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3694
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-26.294875, 11.925657, 0.108806>
}
#declare Group064 = union {
  box { // Cube3695
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3696
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3697
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1231
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group065 = union {
  box { // Cube3698
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3699
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3700
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1232
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group066 = union {
  box { // Cube3701
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3702
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3703
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1233
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart21 = union {
  object { Group064 }
  object { Group065 }
  object { Group066 }
  translate  <-27.794253, 11.919136, 20.046751>
}
#declare Group067 = union {
  box { // Cube3704
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3705
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3706
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1234
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group068 = union {
  box { // Cube3707
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3708
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3709
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1235
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group069 = union {
  box { // Cube3710
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3711
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3712
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1236
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart22 = union {
  object { Group067 }
  object { Group068 }
  object { Group069 }
  translate  <-27.794253, 11.919136, 16.046751>
}
#declare Group070 = union {
  box { // Cube3713
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3714
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3715
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1237
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group071 = union {
  box { // Cube3716
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3717
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3718
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1238
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group072 = union {
  box { // Cube3719
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3720
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3721
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1239
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart23 = union {
  object { Group070 }
  object { Group071 }
  object { Group072 }
  translate  <-27.794253, 11.919136, 12.046751>
}
#declare Group073 = union {
  box { // Cube3722
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3723
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3724
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1240
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group074 = union {
  box { // Cube3725
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3726
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3727
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1241
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group075 = union {
  box { // Cube3728
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3729
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3730
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1242
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart24 = union {
  object { Group073 }
  object { Group074 }
  object { Group075 }
  translate  <-27.794253, 11.919136, 8.046751>
}
#declare Group076 = union {
  box { // Cube3731
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3732
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3733
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1243
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group077 = union {
  box { // Cube3734
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3735
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3736
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1244
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group078 = union {
  box { // Cube3737
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3738
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3739
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1245
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart25 = union {
  object { Group076 }
  object { Group077 }
  object { Group078 }
  translate  <-27.794253, 11.919136, 4.046751>
}
#declare Group079 = union {
  box { // Cube3740
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3741
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3742
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1246
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group080 = union {
  box { // Cube3743
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3744
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3745
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1247
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group081 = union {
  box { // Cube3746
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3747
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3748
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1248
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart26 = union {
  object { Group079 }
  object { Group080 }
  object { Group081 }
  translate  <-27.794253, 11.919136, 0.046751>
}
#declare endMpart8 = union {
  cylinder { // Cylndr1249
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1250
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1251
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3749
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3750
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3751
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  <-27.797134, 11.925657, 23.966403>
}
#declare ausleger5 = union {
  cylinder { // Cylndr1227
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <0.5, 0.5, 3.0>
    translate  <-27.04553, 12.349717, 16.159658>
  }
  object { endMpart7 }
  object { StrebeMpart21 }
  object { StrebeMpart22 }
  object { StrebeMpart23 }
  object { StrebeMpart24 }
  object { StrebeMpart25 }
  object { StrebeMpart26 }
  object { endMpart8 }
  rotate <-0.0, -0.0, -0.0>
  translate  <27.043577, -12.351519, 2.615767>
  scale 3.0
  rotate <-76.128082, -162.454742, 114.471832>
  translate  <4.329528, 10.989189, 16.916291>
}
#declare krahn2 = union {
  cylinder { // Cylndr1211
    <0,0,1>, <0,0,0>, 1 
    material {
      rust2
    }
    scale <2.0, 2.0, 6.0>
    rotate -90.0*x
    translate  <7.695465, -3.127714, 26.999318>
  }
  object { ausleger4 }
  cylinder { // Cylndr1225
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <5.0, 5.0, 2.0>
    translate  <-2.289882, 0.0, -10.0>
  }
  cylinder { // Cylndr1226
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <4.0, 4.0, 40.0>
    translate  <-2.289882, -0.0, -40.124498>
  }
  box { // Cube3691
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <4.0, 4.0, 2.0>
    translate  <-3.446197, 0.0, 6.203155>
  }
  object { ausleger5 }
  box { // Cube3752
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <4.0, 6.0, 4.0>
    rotate -8.018505*y
    translate  <-12.176691, 0.0, -0.974012>
  }
  box { // Cube3753
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <10.0, 8.0, 5.0>
  }
  scale 0.4
  rotate 137.86615*z
  translate  <62.764022, 20.505893, 120.940312>
}
#declare endMpart13 = union {
  cylinder { // Cylndr1300
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1301
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1302
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3874
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3875
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3876
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate -180.0*y
  translate  <1.501319, 0.0, 0.115486>
}
#declare Group118 = union {
  box { // Cube3877
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3878
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3879
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1303
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group119 = union {
  box { // Cube3880
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3881
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3882
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1304
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group120 = union {
  box { // Cube3883
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3884
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3885
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1305
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart39 = union {
  object { Group118 }
  object { Group119 }
  object { Group120 }
  translate  20.0*z
}
#declare Group121 = union {
  box { // Cube3886
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3887
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3888
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1306
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group122 = union {
  box { // Cube3889
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3890
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3891
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1307
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group123 = union {
  box { // Cube3892
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3893
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3894
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1308
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart40 = union {
  object { Group121 }
  object { Group122 }
  object { Group123 }
  translate  16.0*z
}
#declare Group124 = union {
  box { // Cube3895
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3896
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3897
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1309
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group125 = union {
  box { // Cube3898
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3899
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3900
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1310
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group126 = union {
  box { // Cube3901
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3902
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3903
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1311
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart41 = union {
  object { Group124 }
  object { Group125 }
  object { Group126 }
  translate  12.0*z
}
#declare Group127 = union {
  box { // Cube3904
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3905
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3906
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1312
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group128 = union {
  box { // Cube3907
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3908
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3909
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1313
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group129 = union {
  box { // Cube3910
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3911
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3912
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1314
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart42 = union {
  object { Group127 }
  object { Group128 }
  object { Group129 }
  translate  8.0*z
}
#declare Group130 = union {
  box { // Cube3913
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3914
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3915
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1315
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group131 = union {
  box { // Cube3916
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3917
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3918
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1316
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group132 = union {
  box { // Cube3919
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3920
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3921
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1317
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart43 = union {
  object { Group130 }
  object { Group131 }
  object { Group132 }
  translate  4.0*z
}
#declare Group133 = union {
  box { // Cube3922
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3923
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3924
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1318
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group134 = union {
  box { // Cube3925
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3926
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3927
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1319
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group135 = union {
  box { // Cube3928
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3929
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3930
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1320
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart44 = union {
  object { Group133 }
  object { Group134 }
  object { Group135 }
}
#declare endMpart14 = union {
  cylinder { // Cylndr1321
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1322
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1323
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3931
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3932
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3933
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  23.971535*z
}
#declare strebe2 = union {
  object { endMpart13 }
  object { StrebeMpart39 }
  object { StrebeMpart40 }
  object { StrebeMpart41 }
  object { StrebeMpart42 }
  object { StrebeMpart43 }
  object { StrebeMpart44 }
  object { endMpart14 }
  scale 2.0
  rotate <-73.004692, 1.126215, 90.3442>
  translate  <7.57795, -2.159508, 38.544759>
}
#declare endMpart11 = union {
  cylinder { // Cylndr1276
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1277
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1278
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3814
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3815
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3816
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate -180.0*y
  translate  <1.501319, 0.0, 0.115486>
}
#declare Group100 = union {
  box { // Cube3817
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3818
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3819
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1279
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group101 = union {
  box { // Cube3820
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3821
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3822
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1280
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group102 = union {
  box { // Cube3823
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3824
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3825
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1281
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart33 = union {
  object { Group100 }
  object { Group101 }
  object { Group102 }
  translate  20.0*z
}
#declare Group103 = union {
  box { // Cube3826
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3827
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3828
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1282
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group104 = union {
  box { // Cube3829
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3830
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3831
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1283
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group105 = union {
  box { // Cube3832
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3833
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3834
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1284
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart34 = union {
  object { Group103 }
  object { Group104 }
  object { Group105 }
  translate  16.0*z
}
#declare Group106 = union {
  box { // Cube3835
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3836
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3837
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1285
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group107 = union {
  box { // Cube3838
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3839
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3840
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1286
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group108 = union {
  box { // Cube3841
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3842
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3843
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1287
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart35 = union {
  object { Group106 }
  object { Group107 }
  object { Group108 }
  translate  12.0*z
}
#declare Group109 = union {
  box { // Cube3844
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3845
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3846
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1288
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group110 = union {
  box { // Cube3847
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3848
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3849
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1289
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group111 = union {
  box { // Cube3850
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3851
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3852
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1290
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart36 = union {
  object { Group109 }
  object { Group110 }
  object { Group111 }
  translate  8.0*z
}
#declare Group112 = union {
  box { // Cube3853
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3854
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3855
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1291
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group113 = union {
  box { // Cube3856
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3857
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3858
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1292
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group114 = union {
  box { // Cube3859
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3860
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3861
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1293
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart37 = union {
  object { Group112 }
  object { Group113 }
  object { Group114 }
  translate  4.0*z
}
#declare Group115 = union {
  box { // Cube3862
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3863
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3864
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1294
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group116 = union {
  box { // Cube3865
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3866
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3867
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1295
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group117 = union {
  box { // Cube3868
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3869
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3870
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1296
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart38 = union {
  object { Group115 }
  object { Group116 }
  object { Group117 }
}
#declare endMpart12 = union {
  cylinder { // Cylndr1297
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1298
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1299
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3871
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3872
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3873
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  23.971535*z
}
#declare strebe1 = union {
  object { endMpart11 }
  object { StrebeMpart33 }
  object { StrebeMpart34 }
  object { StrebeMpart35 }
  object { StrebeMpart36 }
  object { StrebeMpart37 }
  object { StrebeMpart38 }
  object { endMpart12 }
  scale 2.0
  rotate <-60.456322, -11.66846, 66.418816>
  translate  <27.203209, -18.220165, -1.625859>
}
#declare endMpart10 = union {
  cylinder { // Cylndr1273
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1274
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1275
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3811
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3812
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3813
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate -180.0*y
  translate  <1.501319, 0.0, 0.115486>
}
#declare Group097 = union {
  box { // Cube3802
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3803
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3804
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1270
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group098 = union {
  box { // Cube3805
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3806
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3807
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1271
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group099 = union {
  box { // Cube3808
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3809
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3810
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1272
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart32 = union {
  object { Group097 }
  object { Group098 }
  object { Group099 }
  translate  20.0*z
}
#declare Group094 = union {
  box { // Cube3793
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3794
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3795
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1267
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group095 = union {
  box { // Cube3796
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3797
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3798
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1268
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group096 = union {
  box { // Cube3799
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3800
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3801
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1269
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart31 = union {
  object { Group094 }
  object { Group095 }
  object { Group096 }
  translate  16.0*z
}
#declare Group091 = union {
  box { // Cube3784
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3785
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3786
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1264
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group092 = union {
  box { // Cube3787
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3788
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3789
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1265
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group093 = union {
  box { // Cube3790
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3791
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3792
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1266
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart30 = union {
  object { Group091 }
  object { Group092 }
  object { Group093 }
  translate  12.0*z
}
#declare Group088 = union {
  box { // Cube3775
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3776
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3777
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1261
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group089 = union {
  box { // Cube3778
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3779
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3780
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1262
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group090 = union {
  box { // Cube3781
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3782
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3783
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1263
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart29 = union {
  object { Group088 }
  object { Group089 }
  object { Group090 }
  translate  8.0*z
}
#declare Group085 = union {
  box { // Cube3766
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3767
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3768
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1258
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group086 = union {
  box { // Cube3769
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3770
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3771
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1259
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group087 = union {
  box { // Cube3772
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3773
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3774
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1260
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart28 = union {
  object { Group085 }
  object { Group086 }
  object { Group087 }
  translate  4.0*z
}
#declare Group082 = union {
  box { // Cube3754
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3755
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3756
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1252
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group083 = union {
  box { // Cube3757
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3758
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3759
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1253
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group084 = union {
  box { // Cube3760
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3761
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3762
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1254
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart27 = union {
  object { Group082 }
  object { Group083 }
  object { Group084 }
}
#declare endMpart9 = union {
  cylinder { // Cylndr1255
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1256
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1257
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3763
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3764
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3765
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  23.971535*z
}
#declare strebe = union {
  object { endMpart10 }
  object { StrebeMpart32 }
  object { StrebeMpart31 }
  object { StrebeMpart30 }
  object { StrebeMpart29 }
  object { StrebeMpart28 }
  object { StrebeMpart27 }
  object { endMpart9 }
  scale <3.0, 6.0, 4.0>
  rotate <-40.564388, 0.459543, 91.007805>
  translate  <1.448215, -3.001669, 0.265495>
}
#declare endMpart15 = union {
  cylinder { // Cylndr1327
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1328
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1329
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3934
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3935
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3936
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  rotate -180.0*y
  translate  <1.501319, 0.0, 0.115486>
}
#declare Group136 = union {
  box { // Cube3937
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3938
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3939
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1330
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group137 = union {
  box { // Cube3940
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3941
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3942
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1331
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group138 = union {
  box { // Cube3943
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3944
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3945
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1332
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart45 = union {
  object { Group136 }
  object { Group137 }
  object { Group138 }
  translate  20.0*z
}
#declare Group139 = union {
  box { // Cube3946
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3947
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3948
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1333
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group140 = union {
  box { // Cube3949
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3950
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3951
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1334
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group141 = union {
  box { // Cube3952
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3953
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3954
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1335
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart46 = union {
  object { Group139 }
  object { Group140 }
  object { Group141 }
  translate  16.0*z
}
#declare Group142 = union {
  box { // Cube3955
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3956
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3957
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1336
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group143 = union {
  box { // Cube3958
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3959
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3960
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1337
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group144 = union {
  box { // Cube3961
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3962
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3963
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1338
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart47 = union {
  object { Group142 }
  object { Group143 }
  object { Group144 }
  translate  12.0*z
}
#declare Group145 = union {
  box { // Cube3964
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3965
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3966
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1339
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group146 = union {
  box { // Cube3967
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3968
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3969
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1340
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group147 = union {
  box { // Cube3970
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3971
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3972
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1341
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart48 = union {
  object { Group145 }
  object { Group146 }
  object { Group147 }
  translate  8.0*z
}
#declare Group148 = union {
  box { // Cube3973
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3974
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3975
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1342
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group149 = union {
  box { // Cube3976
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3977
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3978
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1343
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group150 = union {
  box { // Cube3979
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3980
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3981
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1344
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart49 = union {
  object { Group148 }
  object { Group149 }
  object { Group150 }
  translate  4.0*z
}
#declare Group151 = union {
  box { // Cube3982
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3983
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3984
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1345
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
}
#declare Group152 = union {
  box { // Cube3985
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3986
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3987
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1346
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate 120.0*z
  translate  1.5*x
}
#declare Group153 = union {
  box { // Cube3988
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 3.2>
  }
  box { // Cube3989
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 2.0>
  }
  box { // Cube3990
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <1.0, 0.1, 0.1>
    rotate -45.0*y
    translate  <0.75, 0.0, 0.8>
  }
  cylinder { // Cylndr1347
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
  }
  rotate -120.0*z
  translate  <0.75, 1.3, 0.0>
}
#declare StrebeMpart50 = union {
  object { Group151 }
  object { Group152 }
  object { Group153 }
}
#declare endMpart16 = union {
  cylinder { // Cylndr1348
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.35183, 10.847674, -120.603706>
    translate  <0.75, 1.3, 0.0>
  }
  cylinder { // Cylndr1349
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.148853, 0.257821, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.448449, 10.99403, 118.805984>
    translate  <1.544656, 0.0, 0.089312>
  }
  cylinder { // Cylndr1350
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.297706, 0.0, -0.022328>
    material {
      rust3
    }
    scale <0.15, 0.15, 4.0>
    rotate <-6.278159, 10.812471, -0.045634>
    translate  <-0.044656, 0.0, 0.089312>
  }
  box { // Cube3991
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -150.0*z
    translate  <1.121989, 0.64826, 0.1>
  }
  box { // Cube3992
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -90.0*z
    translate  <0.747993, 0.0, 0.1>
  }
  box { // Cube3993
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.75, 0.1>
    rotate -30.0*z
    translate  <0.373996, 0.64826, 0.1>
  }
  translate  23.971535*z
}
#declare strebe3 = union {
  object { endMpart15 }
  object { StrebeMpart45 }
  object { StrebeMpart46 }
  object { StrebeMpart47 }
  object { StrebeMpart48 }
  object { StrebeMpart49 }
  object { StrebeMpart50 }
  object { endMpart16 }
  scale 2.0
  rotate <-60.456322, -11.66846, 110.126366>
  translate  <24.176641, 20.135595, -1.258699>
}
#declare fackel = union {
  cylinder { // Cylndr1326
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <2.0, 2.0, 4.0>
    rotate -90.0*x
    translate  <13.3283, -2.666209, 34.705489>
  }
  cylinder { // Cylndr1325
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale <2.0, 2.0, 4.0>
    rotate -90.0*x
    translate  <-43.796388, -3.196622, 51.498468>
  }
  cylinder { // Cylndr1324
    <0,0,1>, <0,0,0>, 1 
    material {
      rust3
    }
    scale <1.0, 1.0, 130.0>
    rotate -40.720676*y
    translate  <8.448432, -1.248934, -10.443858>
  }
  object { strebe2 }
  object { strebe1 }
  object { strebe }
  object { strebe3 }
  scale 0.8
  rotate -41.221588*z
  translate  <-8.573044, 107.957077, 73.015174>
}
#declare towerMpart3 = union {
  box { // Cube4021
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <55.296589, -22.369862, 13.350252>
    translate  <-5.958562, -5.983422, 90.284714>
  }
  box { // Cube4022
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <-55.385464, -22.019886, -13.114965>
    translate  <-5.818796, 6.73135, 89.928985>
  }
  box { // Cube4023
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 22.0, 1.0>
    translate  -26.177473*z
  }
  box { // Cube4024
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    translate  <0.0, -0.0, 79.280347>
  }
  box { // Cube4025
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 16.0, 1.0>
    translate  50.111163*z
  }
  box { // Cube4026
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 18.0, 1.0>
    translate  24.681617*z
  }
  box { // Cube4027
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 20.0, 1.0>
  }
  box { // Cube4028
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate -5.184144*x
    translate  -20.0*y
  }
  box { // Cube4029
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate 5.194804*x
    translate  20.0*y
  }
  rotate 0.0*y
  translate  <0.0, 0.0, 78.714282>
  rotate <0.0, -5.115169, -90.0>
  translate  <0.533027, -26.85878, -78.60143>
}
#declare towerMpart2 = union {
  box { // Cube4012
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <55.146229, 21.868719, -13.023157>
    translate  <5.292849, -5.983422, 90.05305>
  }
  box { // Cube4013
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <-55.482403, 21.629616, 12.854221>
    translate  <5.277624, 6.73135, 90.223296>
  }
  box { // Cube4014
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 22.0, 1.0>
    translate  -26.177473*z
  }
  box { // Cube4015
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    translate  <0.0, -0.0, 79.280347>
  }
  box { // Cube4016
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 16.0, 1.0>
    translate  50.111163*z
  }
  box { // Cube4017
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 18.0, 1.0>
    translate  24.681617*z
  }
  box { // Cube4018
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 20.0, 1.0>
  }
  box { // Cube4019
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate -5.184144*x
    translate  -20.0*y
  }
  box { // Cube4020
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate 5.194804*x
    translate  20.0*y
  }
  rotate 0.0*y
  translate  <0.0, 0.0, 78.714282>
  rotate <-0.0, 5.110168, -90.0>
  translate  <0.533027, 26.85878, -78.60143>
}
#declare towerMpart1 = union {
  box { // Cube4003
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <55.372772, 22.070299, -13.148775>
    translate  <6.150472, -5.983422, 90.298869>
  }
  box { // Cube4004
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <-55.956394, 21.343864, 12.662028>
    translate  <6.150472, 6.73135, 90.298869>
  }
  box { // Cube4005
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 22.0, 1.0>
    translate  -26.177473*z
  }
  box { // Cube4006
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    translate  <0.0, -0.0, 79.280347>
  }
  box { // Cube4007
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 16.0, 1.0>
    translate  50.111163*z
  }
  box { // Cube4008
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 18.0, 1.0>
    translate  24.681617*z
  }
  box { // Cube4009
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 20.0, 1.0>
  }
  box { // Cube4010
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate -5.184144*x
    translate  -20.0*y
  }
  box { // Cube4011
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate 5.194804*x
    translate  20.0*y
  }
  rotate -0.0*y
  translate  <0.0, 0.0, 77.867892>
  rotate 5.087229*y
  translate  <-26.403491, 0.0, -77.867892>
}
#declare towerMpart = union {
  box { // Cube4002
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <55.911007, -19.782726, 11.642217>
    translate  <-5.466361, -5.983422, 90.246111>
  }
  box { // Cube4001
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    rotate <-55.858913, -20.018837, -11.795238>
    translate  <-5.466361, 6.73135, 90.246111>
  }
  box { // Cube4000
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 22.0, 1.0>
    translate  -26.177473*z
  }
  box { // Cube3999
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale <1.0, 13.0, 1.0>
    translate  <0.0, -0.0, 79.280347>
  }
  box { // Cube3998
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 16.0, 1.0>
    translate  50.111163*z
  }
  box { // Cube3997
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 18.0, 1.0>
    translate  24.681617*z
  }
  box { // Cube3996
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 20.0, 1.0>
  }
  box { // Cube3995
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate -5.184144*x
    translate  -20.0*y
  }
  box { // Cube3994
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <1.0, 1.0, 80.0>
    rotate 5.194804*x
    translate  20.0*y
  }
  rotate 0.0*y
  translate  <0.0, 0.0, 78.714282>
  rotate -5.171901*y
  translate  <27.68419, 0.0, -78.714282>
}
#declare tower = union {
  cylinder { // Cylndr1354
    <0,0,1>, <0,0,0>, 1 
    material {
      darkMgrey
    }
    scale <1.0, 1.0, 150.0>
    translate  <11.932769, 7.051182, -68.397904>
  }
  cylinder { // Cylndr1353
    <0,0,1>, <0,0,0>, 1 
    material {
      darkMgrey
    }
    scale <2.0, 2.0, 150.0>
    translate  <11.860565, 3.129581, -70.260522>
  }
  box { // Cube4034
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <17.0, 17.0, 2.0>
    translate  <0.588993, 0.0, 36.009857>
  }
  box { // Cube4033
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <21.0, 21.0, 2.0>
    translate  <0.588993, -0.418428, -12.092676>
  }
  box { // Cube4032
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <14.0, 14.0, 2.0>
    translate  <0.588993, 0.0, 64.475563>
  }
  cylinder { // Cylndr1352
    <0,0,1>, <0,0,0>, 1 
    material {
      darkMgrey
    }
    scale <1.0, 1.0, 150.0>
    translate  <4.555907, 0.097562, -66.604665>
  }
  cylinder { // Cylndr1351
    <0,0,1>, <0,0,0>, 1 
    material {
      darkMgrey
    }
    scale <1.0, 1.0, 150.0>
    translate  <-2.466466, 0.257827, -67.133002>
  }
  box { // Cube4031
    <-1, -1, -1>, <1, 1, 1>
    material {
      invisible
    }
    scale 5.0
    translate  <1.071651, 0.284589, 84.585619>
  }
  box { // Cube4030
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <18.0, 18.0, 5.0>
    translate  <0.640349, 0.0, 13.447332>
  }
  object { towerMpart3 }
  object { towerMpart2 }
  object { towerMpart1 }
  object { towerMpart }
  box { // Cube4035
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <50.0, 40.0, 40.0>
    translate  <-10.428314, 0.231499, -100.063504>
  }
  cone { // Cone005
    <0,0,0>, 35.0, <0,0,1>, 30.0
    material {
      rustMgrid
    }
    scale <1.0, 1.0, 30.0>
    translate  -63.294343*z
  }
  box { // Cube4036
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale 35.0
    translate  <28.879394, -74.866778, -94.757928>
  }
  scale 0.4
  translate  <32.313432, 66.121978, 148.154146>
}
#declare CSG001 = union {
  box { // Cube4037
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <24.699999, 24.699999, 0.4>
  }
  box { // Cube4098
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <26.0, 26.0, 0.4>
    translate  1.0*z
  }
  box { // Cube4099
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <26.0, 26.0, 0.4>
    translate  -1.0*z
  }
}
#declare CSG002 = difference {
  object { CSG001 }
  box { // Cube4103
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <15.0, 8.0, 2.0>
    rotate 45.0*z
    translate  <-24.320907, 23.824562, 0.0>
  }
  box { // Cube4102
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <15.0, 8.0, 2.0>
    rotate 135.0*z
    translate  <-23.824562, -24.320907, 0.0>
  }
  box { // Cube4101
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <15.0, 8.0, 2.0>
    rotate -135.0*z
    translate  <24.320907, -23.824562, 0.0>
  }
  box { // Cube4100
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <15.0, 8.0, 2.0>
    rotate -45.0*z
    translate  <23.824562, 24.320907, 0.0>
  }
  scale <1.0, 1.0, 1.625>
  rotate <-0.0, 0.0, -0.0>
  translate  <-0.029592, 0.415142, 0.256458>
}
#declare landingMplatform = union {
  object { ausleger6 }
  object { // ausleger7->ausleger6
    ausleger6
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.460872, -0.195027, 0.0>
  }
  object { CSG002 }
  scale <1.3, 1.3, 0.8>
  translate  <104.978452, 26.639963, 117.740914>
}
union { // oilrigg
  object { platformMhouse }
  object { platformMbasis }
  object { krahn }
  object { krahn1 }
  object { krahn2 }
  object { fackel }
  object { tower }
  object { landingMplatform }
  cylinder { // spray1
    <0,0,1>, <0,0,0>, 1 
    material {
      spray
    }
    hollow
    scale <18.0, 12.0, 12.0>
    rotate <0.0, -6.221683, -0.0>
    translate  <14.729482, 8.994446, 9.132375>
  }
  cylinder { // spray2
    <0,0,1>, <0,0,0>, 1 
    material {
      spray
    }
    hollow
    scale <18.0, 12.0, 12.0>
    rotate <0.0, -6.302633, -0.0>
    translate  <16.305278, 89.039786, 11.239958>
  }
  cylinder { // spray4
    <0,0,1>, <0,0,0>, 1 
    material {
      spray
    }
    hollow
    scale <18.0, 12.0, 12.0>
    rotate -7.435032*y
    translate  <97.13581, 9.051469, 9.31904>
  }
  rotate -9.646537*z
  translate  <5.049655, -32.452278, -15.517892>
}


#declare chimneyMpart3 = union {
  box { // Cube4104
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 104.0>
  }
  box { // Cube4105
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 100.0>
  }
  box { // Cube4106
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 96.0>
  }
  box { // Cube4107
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 92.0>
  }
  box { // Cube4108
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 88.0>
  }
  box { // Cube4109
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 84.0>
  }
  box { // Cube4110
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 80.0>
  }
  box { // Cube4111
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 76.0>
  }
  box { // Cube4112
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 72.0>
  }
  box { // Cube4113
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 68.0>
  }
  box { // Cube4114
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 64.0>
  }
  box { // Cube4115
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
  box { // Cube4116
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 60.0>
  }
  box { // Cube4117
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
  scale <1.0, 1.0, 0.75>
  rotate -90.0*z
  translate  <5.65066, 114.036317, 11.423389>
}
#declare chimneyMpart4 = union {
  box { // Cube3377
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 104.0>
  }
  box { // Cube4118
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 100.0>
  }
  box { // Cube4119
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 96.0>
  }
  box { // Cube4120
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 92.0>
  }
  box { // Cube4121
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 88.0>
  }
  box { // Cube4122
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 84.0>
  }
  box { // Cube4123
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 80.0>
  }
  box { // Cube4124
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 76.0>
  }
  box { // Cube4125
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 72.0>
  }
  box { // Cube4126
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 68.0>
  }
  box { // Cube4127
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 64.0>
  }
  box { // Cube4128
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 60.0>
  }
  box { // Cube4129
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
  scale <1.0, 1.0, 0.75>
  rotate -90.0*z
  translate  <5.65066, 74.036317, 11.423389>
}
#declare chimneyMpart5 = union {
  box { // Cube4130
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 104.0>
  }
  box { // Cube4131
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 100.0>
  }
  box { // Cube4132
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 96.0>
  }
  box { // Cube4133
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 92.0>
  }
  box { // Cube4134
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 88.0>
  }
  box { // Cube4135
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 84.0>
  }
  box { // Cube4136
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 80.0>
  }
  box { // Cube4137
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 76.0>
  }
  box { // Cube4138
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 72.0>
  }
  box { // Cube4139
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 68.0>
  }
  box { // Cube4140
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 64.0>
  }
  box { // Cube3354
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <4.3, 3.3, 0.5>
    translate  <53.671124, -11.97651, 60.0>
  }
  box { // Cube4141
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid2
    }
    scale <4.0, 3.0, 25.0>
    translate  <53.671124, -11.97651, 83.115914>
  }
  scale <1.0, 1.0, 0.75>
  translate  <0.0, 0.0, 12.239346>
}
#declare railMpart306 = union {
  box { // Cube4143
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4144
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4145
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4146
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4147
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4148
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4149
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart307 = union {
  box { // Cube4150
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4151
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4152
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4153
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4154
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4155
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4156
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart308 = union {
  box { // Cube4157
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4158
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4159
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4160
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4161
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4162
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4163
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart309 = union {
  box { // Cube4164
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4165
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4166
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4167
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4168
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4169
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4170
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart310 = union {
  box { // Cube4171
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4172
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4173
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4174
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4175
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4176
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4177
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart311 = union {
  box { // Cube4178
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4179
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4180
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4181
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4182
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4183
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4184
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart312 = union {
  box { // Cube4185
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4186
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4187
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4188
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4189
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4190
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4191
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart313 = union {
  box { // Cube4192
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4193
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4194
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4195
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4196
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4197
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4198
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart314 = union {
  box { // Cube4199
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4200
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4201
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4202
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4203
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4204
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4205
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart315 = union {
  box { // Cube4206
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4207
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4208
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4209
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4210
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4211
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4212
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup29 = union {
  object { railMpart306 }
  object { railMpart307 }
  object { railMpart308 }
  object { railMpart309 }
  object { railMpart310 }
  object { railMpart311 }
  object { railMpart312 }
  object { railMpart313 }
  object { railMpart314 }
  object { railMpart315 }
}
#declare windowMpart224 = union {
  box { // Cube4214
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4215
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4216
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1209
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1210
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4217
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4218
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1380
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1381
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart225 = union {
  box { // Cube4219
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4220
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4221
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1382
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1383
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4222
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4223
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1384
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1385
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart226 = union {
  box { // Cube4224
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4225
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4226
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1386
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1387
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4227
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4228
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1388
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1389
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart227 = union {
  box { // Cube4229
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4230
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4231
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1390
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1391
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4232
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4233
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1392
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1393
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart228 = union {
  box { // Cube4234
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4235
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4236
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1394
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1395
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4237
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4238
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1396
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1397
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart229 = union {
  box { // Cube4239
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4240
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4241
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1398
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1399
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4242
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4243
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1400
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1401
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart230 = union {
  box { // Cube4244
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4245
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4246
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1402
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1403
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4247
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4248
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1404
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1405
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart231 = union {
  box { // Cube4253
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4254
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4255
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1406
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1407
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4256
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4257
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1408
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1409
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock28 = union {
  object { railingMgroup29 }
  box { // Cube4213
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart224 }
  object { windowMpart225 }
  object { windowMpart226 }
  object { windowMpart227 }
  object { windowMpart228 }
  object { windowMpart229 }
  object { windowMpart230 }
  box { // Cube4249
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube4250
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube4251
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube4252
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart231 }
  rotate 180.0*z
  translate  <53.71575, 94.0, 73.165269>
}
#declare railMpart316 = union {
  box { // Cube4258
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4259
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4260
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4261
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4262
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4263
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4264
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart317 = union {
  box { // Cube4265
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4266
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4267
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4268
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4269
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4270
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4271
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner9 = union {
  object { railMpart316 }
  object { railMpart317 }
  box { // Cube4272
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
  rotate -90.0*z
  translate  <0.479885, 107.73253, 0.0>
}
#declare railMpart318 = union {
  box { // Cube4273
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4274
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4275
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4276
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4277
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4278
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4279
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart319 = union {
  box { // Cube4280
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4281
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4282
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4283
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4284
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4285
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4286
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart320 = union {
  box { // Cube4287
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4288
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4289
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4290
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4291
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4292
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4293
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart321 = union {
  box { // Cube4294
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4295
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4296
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4297
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4298
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4299
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4300
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart322 = union {
  box { // Cube4301
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4302
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4303
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4304
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4305
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4306
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4307
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart323 = union {
  box { // Cube4308
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4309
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4310
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4311
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4312
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4313
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4314
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart324 = union {
  box { // Cube4315
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4316
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4317
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4318
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4319
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4320
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4321
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart325 = union {
  box { // Cube4322
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4323
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4324
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4325
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4326
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4327
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4328
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart326 = union {
  box { // Cube4329
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4330
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4331
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4332
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4333
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4334
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4335
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart327 = union {
  box { // Cube4336
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4337
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4338
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4339
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4340
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4341
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4342
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup30 = union {
  object { railMpart318 }
  object { railMpart319 }
  object { railMpart320 }
  object { railMpart321 }
  object { railMpart322 }
  object { railMpart323 }
  object { railMpart324 }
  object { railMpart325 }
  object { railMpart326 }
  object { railMpart327 }
}
#declare windowMpart232 = union {
  box { // Cube4344
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4345
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4346
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1410
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1411
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4347
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4348
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1412
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1413
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart233 = union {
  box { // Cube4349
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4350
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4351
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1414
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1415
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4352
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4353
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1416
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1417
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart234 = union {
  box { // Cube4354
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4355
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4356
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1418
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1419
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4357
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4358
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1420
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1421
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart235 = union {
  box { // Cube4359
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4360
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4361
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1422
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1423
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4362
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4363
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1424
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1425
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart236 = union {
  box { // Cube4364
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4365
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4366
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1426
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1427
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4367
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4368
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1428
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1429
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart237 = union {
  box { // Cube4369
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4370
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4371
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1430
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1431
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4372
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4373
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1432
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1433
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart238 = union {
  box { // Cube4374
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4375
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4376
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1434
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1435
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4377
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4378
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1436
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1437
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart239 = union {
  box { // Cube4383
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4384
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4385
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1438
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1439
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4386
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4387
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1440
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1441
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock29 = union {
  object { railingMgroup30 }
  box { // Cube4343
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart232 }
  object { windowMpart233 }
  object { windowMpart234 }
  object { windowMpart235 }
  object { windowMpart236 }
  object { windowMpart237 }
  object { windowMpart238 }
  box { // Cube4379
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube4380
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube4381
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube4382
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart239 }
  rotate 180.0*z
  translate  <13.71575, 94.0, 73.165269>
}
#declare railMpart328 = union {
  box { // Cube4388
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4389
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4390
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4391
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4392
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4393
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4394
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart329 = union {
  box { // Cube4395
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4396
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4397
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4398
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4399
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4400
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4401
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart330 = union {
  box { // Cube4402
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4403
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4404
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4405
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4406
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4407
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4408
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart331 = union {
  box { // Cube4409
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4410
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4411
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4412
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4413
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4414
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4415
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart332 = union {
  box { // Cube4416
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4417
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4418
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4419
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4420
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4421
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4422
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart333 = union {
  box { // Cube4423
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4424
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4425
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4426
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4427
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4428
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4429
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart334 = union {
  box { // Cube4430
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4431
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4432
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4433
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4434
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4435
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4436
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart335 = union {
  box { // Cube4437
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4438
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4439
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4440
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4441
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4442
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4443
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart336 = union {
  box { // Cube4444
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4445
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4446
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4447
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4448
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4449
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4450
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart337 = union {
  box { // Cube4451
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4452
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4453
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4454
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4455
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4456
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4457
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup31 = union {
  object { railMpart328 }
  object { railMpart329 }
  object { railMpart330 }
  object { railMpart331 }
  object { railMpart332 }
  object { railMpart333 }
  object { railMpart334 }
  object { railMpart335 }
  object { railMpart336 }
  object { railMpart337 }
}
#declare windowMpart240 = union {
  box { // Cube4459
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4460
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4461
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1442
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1443
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4462
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4463
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1444
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1445
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart241 = union {
  box { // Cube4464
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4465
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4466
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1446
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1447
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4467
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4468
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1448
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1449
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart242 = union {
  box { // Cube4469
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4470
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4471
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1450
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1451
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4472
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4473
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1452
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1453
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart243 = union {
  box { // Cube4474
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4475
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4476
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1454
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1455
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4477
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4478
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1456
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1457
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart244 = union {
  box { // Cube4479
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4480
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4481
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1458
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1459
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4482
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4483
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1460
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1461
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart245 = union {
  box { // Cube4484
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4485
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4486
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1462
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1463
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4487
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4488
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1464
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1465
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart246 = union {
  box { // Cube4489
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4490
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4491
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1466
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1467
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4492
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4493
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1468
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1469
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart247 = union {
  box { // Cube4498
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4499
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4500
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1470
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1471
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4501
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4502
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1472
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1473
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock30 = union {
  object { railingMgroup31 }
  box { // Cube4458
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart240 }
  object { windowMpart241 }
  object { windowMpart242 }
  object { windowMpart243 }
  object { windowMpart244 }
  object { windowMpart245 }
  object { windowMpart246 }
  box { // Cube4494
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube4495
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube4496
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube4497
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart247 }
  rotate -90.0*z
  translate  <13.71575, 93.625383, 73.165269>
}
#declare railMpart338 = union {
  box { // Cube4503
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4504
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4505
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4506
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4507
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4508
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4509
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart339 = union {
  box { // Cube4510
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4511
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4512
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4513
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4514
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4515
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4516
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart340 = union {
  box { // Cube4517
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4518
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4519
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4520
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4521
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4522
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4523
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart341 = union {
  box { // Cube4524
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4525
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4526
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4527
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4528
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4529
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4530
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart342 = union {
  box { // Cube4531
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4532
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4533
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4534
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4535
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4536
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4537
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart343 = union {
  box { // Cube4538
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4539
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4540
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4541
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4542
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4543
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4544
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart344 = union {
  box { // Cube4545
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4546
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4547
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4548
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4549
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4550
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4551
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart345 = union {
  box { // Cube4552
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4553
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4554
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4555
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4556
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4557
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4558
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart346 = union {
  box { // Cube4559
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4560
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4561
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4562
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4563
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4564
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4565
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart347 = union {
  box { // Cube4566
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4567
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4568
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4569
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4570
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4571
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4572
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup32 = union {
  object { railMpart338 }
  object { railMpart339 }
  object { railMpart340 }
  object { railMpart341 }
  object { railMpart342 }
  object { railMpart343 }
  object { railMpart344 }
  object { railMpart345 }
  object { railMpart346 }
  object { railMpart347 }
}
#declare windowMpart248 = union {
  box { // Cube4574
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4575
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4576
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1474
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1475
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4577
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4578
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1476
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1477
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart249 = union {
  box { // Cube4579
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4580
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4581
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1478
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1479
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4582
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4583
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1480
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1481
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart250 = union {
  box { // Cube4584
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4585
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4586
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1482
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1483
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4587
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4588
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1484
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1485
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart251 = union {
  box { // Cube4589
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4590
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4591
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1486
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1487
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4592
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4593
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1488
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1489
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart252 = union {
  box { // Cube4594
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4595
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4596
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1490
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1491
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4597
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4598
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1492
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1493
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart253 = union {
  box { // Cube4599
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4600
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4601
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1494
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1495
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4602
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4603
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1496
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1497
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart254 = union {
  box { // Cube4604
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4605
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4606
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1498
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1499
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4607
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4608
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1500
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1501
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart255 = union {
  box { // Cube4613
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4614
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4615
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1502
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1503
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4616
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4617
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1504
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1505
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock31 = union {
  object { railingMgroup32 }
  box { // Cube4573
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart248 }
  object { windowMpart249 }
  object { windowMpart250 }
  object { windowMpart251 }
  object { windowMpart252 }
  object { windowMpart253 }
  object { windowMpart254 }
  box { // Cube4609
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube4610
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube4611
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube4612
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart255 }
  rotate -90.0*z
  translate  <13.71575, 53.625383, 73.165269>
}
#declare railMpart348 = union {
  box { // Cube4618
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4619
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4620
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4621
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4622
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4623
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4624
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  rotate -90.0*z
  translate  <-9.458382, -8.145884, 76.0>
}
#declare railMpart349 = union {
  box { // Cube4625
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4626
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4627
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4628
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4629
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4630
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4631
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-7.445466, -9.9631, 76.0>
}
#declare railMcorner10 = union {
  object { railMpart348 }
  object { railMpart349 }
  box { // Cube4632
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.083872, 2.251615, 0.5>
    translate  <-8.193208, -8.520761, 72.665878>
  }
}
#declare railMpart350 = union {
  box { // Cube4633
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4634
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4635
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4636
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4637
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4638
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4639
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart351 = union {
  box { // Cube4640
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4641
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4642
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4643
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4644
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4645
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4646
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart352 = union {
  box { // Cube4647
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4648
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4649
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4650
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4651
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4652
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4653
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart353 = union {
  box { // Cube4654
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4655
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4656
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4657
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4658
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4659
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4660
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart354 = union {
  box { // Cube4661
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4662
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4663
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4664
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4665
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4666
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4667
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart355 = union {
  box { // Cube4668
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4669
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4670
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4671
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4672
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4673
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4674
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart356 = union {
  box { // Cube4675
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4676
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4677
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4678
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4679
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4680
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4681
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart357 = union {
  box { // Cube4682
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4683
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4684
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4685
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4686
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4687
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4688
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart358 = union {
  box { // Cube4689
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4690
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4691
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4692
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4693
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4694
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4695
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart359 = union {
  box { // Cube4696
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4697
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4698
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4699
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4700
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4701
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4702
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005, 2.820798>
}
#declare railingMgroup33 = union {
  object { railMpart350 }
  object { railMpart351 }
  object { railMpart352 }
  object { railMpart353 }
  object { railMpart354 }
  object { railMpart355 }
  object { railMpart356 }
  object { railMpart357 }
  object { railMpart358 }
  object { railMpart359 }
}
#declare windowMpart256 = union {
  box { // Cube4704
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4705
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4706
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1506
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1507
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4707
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4708
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1508
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1509
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <16.856075, -20.05733, 4.232644>
}
#declare windowMpart257 = union {
  box { // Cube4709
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4710
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4711
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1510
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1511
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4712
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4713
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1512
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1513
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <11.856075, -20.15494, 4.233124>
}
#declare windowMpart258 = union {
  box { // Cube4714
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4715
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4716
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1514
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1515
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4717
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4718
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1516
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1517
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <6.856075, -20.05733, 4.232644>
}
#declare windowMpart259 = union {
  box { // Cube4719
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4720
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4721
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1518
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1519
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4722
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4723
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1520
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1521
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <1.856075, -20.05733, 4.232644>
}
#declare windowMpart260 = union {
  box { // Cube4724
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4725
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4726
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1522
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1523
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4727
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4728
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1524
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1525
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-3.143925, -20.05733, 4.232644>
}
#declare windowMpart261 = union {
  box { // Cube4729
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4730
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4731
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1526
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1527
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4732
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4733
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1528
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1529
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-8.143925, -20.05733, 4.232644>
}
#declare windowMpart262 = union {
  box { // Cube4734
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4735
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4736
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1530
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1531
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4737
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4738
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1532
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1533
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-13.143925, -20.05733, 4.232644>
}
#declare windowMpart263 = union {
  box { // Cube4743
    <-1, -1, -1>, <1, 1, 1>
    material {
      darkMgrey
    }
    scale <0.5, 0.5, 0.01>
    translate  <0.5, 0.5, 0.0>
  }
  box { // Cube4744
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  <1.0, 0.5, 0.0>
  }
  box { // Cube4745
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.1, 0.5, 0.1>
    translate  0.5*y
  }
  cylinder { // Cylndr1534
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*y
  }
  cylinder { // Cylndr1535
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  <1.0, 1.0, 0.0>
  }
  box { // Cube4746
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  <0.5, 1.0, 0.0>
  }
  box { // Cube4747
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <0.5, 0.1, 0.1>
    translate  0.5*x
  }
  cylinder { // Cylndr1536
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
    translate  1.0*x
  }
  cylinder { // Cylndr1537
    <0,0,1>, <0,0,0>, 1 
    material {
      rust1
    }
    scale 0.1
  }
  scale <1.5, 1.5, 1.0>
  rotate 90.0*x
  translate  <-18.143925, -20.05733, 4.232644>
}
#declare houseMblock32 = union {
  object { railingMgroup33 }
  box { // Cube4703
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <1.841419, 0.5, 3.524256>
    translate  <12.559778, -19.622618, 3.225039>
  }
  object { windowMpart256 }
  object { windowMpart257 }
  object { windowMpart258 }
  object { windowMpart259 }
  object { windowMpart260 }
  object { windowMpart261 }
  object { windowMpart262 }
  box { // Cube4739
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -1.0>
  }
  box { // Cube4740
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <20.0, 21.0, 0.2>
    translate  <0.0, -2.0, -0.6>
  }
  box { // Cube4741
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust1
    }
    scale <20.0, 22.0, 0.2>
    translate  <0.0, -2.0, -0.2>
  }
  box { // Cube4742
    <-1, -1, -1>, <1, 1, 1>
    material {
      rustMgrid
    }
    scale <20.0, 2.0, 4.0>
    translate  <0.0, -18.0, 4.0>
  }
  object { windowMpart263 }
  rotate -90.0*z
  translate  <13.71575, 13.625383, 73.165269>
}
#declare railMpart360 = union {
  box { // Cube4748
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4749
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4750
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4751
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4752
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4753
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4754
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <18.035514, -23.198005, 2.820798>
}
#declare railMpart361 = union {
  box { // Cube4755
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4756
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4757
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4758
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4759
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4760
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4761
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <14.035514, -23.198005, 2.820798>
}
#declare railMpart362 = union {
  box { // Cube4762
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4763
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4764
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4765
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4766
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4767
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4768
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <10.035514, -23.198005, 2.820798>
}
#declare railMpart363 = union {
  box { // Cube4769
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4770
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4771
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4772
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4773
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4774
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4775
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <6.035514, -23.198005, 2.820798>
}
#declare railMpart364 = union {
  box { // Cube4776
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4777
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4778
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4779
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4780
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4781
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4782
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <2.035514, -23.198005, 2.820798>
}
#declare railMpart365 = union {
  box { // Cube4783
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4784
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4785
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4786
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4787
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4788
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4789
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-1.964486, -23.198005, 2.820798>
}
#declare railMpart366 = union {
  box { // Cube4790
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4791
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4792
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4793
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4794
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4795
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4796
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-5.964486, -23.198005, 2.820798>
}
#declare railMpart367 = union {
  box { // Cube4797
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4798
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4799
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4800
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4801
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4802
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4803
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-9.964486, -23.198005, 2.820798>
}
#declare railMpart368 = union {
  box { // Cube4804
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4805
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4806
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4807
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4808
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4809
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4810
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-13.964486, -23.198005, 2.820798>
}
#declare railMpart369 = union {
  box { // Cube4811
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
    translate  -1.8*z
  }
  box { // Cube4812
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <1.6, 0.0, -0.9>
  }
  box { // Cube4813
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <0.8, 0.0, -0.9>
  }
  box { // Cube4814
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  -0.9*z
  }
  box { // Cube4815
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-0.8, 0.0, -0.9>
  }
  box { // Cube4816
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust3
    }
    scale <0.1, 0.1, 1.0>
    translate  <-1.6, 0.0, -0.9>
  }
  box { // Cube4817
    <-1, -1, -1>, <1, 1, 1>
    material {
      rust2
    }
    scale <2.0, 0.1, 0.1>
  }
  scale <1.0, 1.5, 1.5>
  translate  <-17.964486, -23.198005,