// INC file for Persistence of Vision (POV) raytracer
// created by PlantStudio

#declare snapdragon = union {
	union { // internode
		cylinder { <0.0, 0.0, 0.0>, <-0.1597, 6.852, -0.05276>, 0.4569 }
		cylinder { <-0.1597, 6.852, -0.05276>, <-0.479, 13.6978, -0.1582>, 0.4569 }
		cylinder { <-0.479, 13.6978, -0.1582>, <-0.9578, 20.5334, -0.3164>, 0.4569 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.9578, 20.5334, -0.3164>, <-0.9533, 20.724, -0.3149>, 0.3814 }
			cylinder { <-0.9533, 20.724, -0.3149>, <-0.9312, 20.9133, -0.3076>, 0.3814 }
			cylinder { <-0.9312, 20.9133, -0.3076>, <-0.8915, 21.09943, -0.2945>, 0.3814 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // seedling leaf
			triangle { <-0.8915, 21.09943, -0.2945>, <1.1301, 29.9865, -3.3648>, <0.4868, 29.5624, 0.1014> }
			triangle { <0.4868, 29.5624, 0.1014>, <1.1301, 29.9865, -3.3648>, <2.4356, 34.908, -3.9709> }
			triangle { <0.4868, 29.5624, 0.1014>, <2.4356, 34.908, -3.9709>, <2.5714, 34.6728, -0.1442> }
			triangle { <2.5714, 34.6728, -0.1442>, <2.4356, 34.908, -3.9709>, <4.5668, 37.855, -3.1469> }
			triangle { <2.5714, 34.6728, -0.1442>, <4.5668, 37.855, -3.1469>, <4.7297, 37.3284, -0.4613> }
			triangle { <4.7297, 37.3284, -0.4613>, <4.5668, 37.855, -3.1469>, <6.293, 38.1191, -0.913> }
			triangle { <6.1765, 37.3102, 1.4707>, <4.7297, 37.3284, -0.4613>, <6.293, 38.1191, -0.913> }
			triangle { <6.1765, 37.3102, 1.4707>, <2.5714, 34.6728, -0.1442>, <4.7297, 37.3284, -0.4613> }
			triangle { <6.1765, 37.3102, 1.4707>, <4.605, 34.4939, 2.7836>, <2.5714, 34.6728, -0.1442> }
			triangle { <2.5714, 34.6728, -0.1442>, <4.605, 34.4939, 2.7836>, <0.4868, 29.5624, 0.1014> }
			triangle { <0.4868, 29.5624, 0.1014>, <4.605, 34.4939, 2.7836>, <2.4333, 29.4508, 2.09225> }
			triangle { <0.4868, 29.5624, 0.1014>, <2.4333, 29.4508, 2.09225>, <-0.8915, 21.09943, -0.2945> }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-0.9578, 20.5334, -0.3164>, <-0.9887, 20.7213, -0.3266>, 0.3814 }
			cylinder { <-0.9887, 20.7213, -0.3266>, <-1.03708, 20.9051, -0.3426>, 0.3814 }
			cylinder { <-1.03708, 20.9051, -0.3426>, <-1.1022, 21.08306, -0.3641>, 0.3814 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // seedling leaf
			triangle { <-1.1022, 21.08306, -0.3641>, <-3.9901, 29.8222, 2.4255>, <-3.3805, 29.3313, -1.0381> }
			triangle { <-3.3805, 29.3313, -1.0381>, <-3.9901, 29.8222, 2.4255>, <-5.7979, 34.5988, 2.8821> }
			triangle { <-3.3805, 29.3313, -1.0381>, <-5.7979, 34.5988, 2.8821>, <-5.9907, 34.1992, -0.9284> }
			triangle { <-5.9907, 34.1992, -0.9284>, <-5.7979, 34.5988, 2.8821>, <-8.2476, 37.2699, 2.004429> }
			triangle { <-5.9907, 34.1992, -0.9284>, <-8.2476, 37.2699, 2.004429>, <-8.4116, 36.6231, -0.6546> }
			triangle { <-8.4116, 36.6231, -0.6546>, <-8.2476, 37.2699, 2.004429>, <-10.0401, 37.262, -0.1925> }
			triangle { <-9.8898, 36.3761, -2.5469>, <-8.4116, 36.6231, -0.6546>, <-10.0401, 37.262, -0.1925> }
			triangle { <-9.8898, 36.3761, -2.5469>, <-5.9907, 34.1992, -0.9284>, <-8.4116, 36.6231, -0.6546> }
			triangle { <-9.8898, 36.3761, -2.5469>, <-8.05678, 33.6913, -3.7945>, <-5.9907, 34.1992, -0.9284> }
			triangle { <-5.9907, 34.1992, -0.9284>, <-8.05678, 33.6913, -3.7945>, <-3.3805, 29.3313, -1.0381> }
			triangle { <-3.3805, 29.3313, -1.0381>, <-8.05678, 33.6913, -3.7945>, <-5.3468, 28.9365, -2.9726> }
			triangle { <-3.3805, 29.3313, -1.0381>, <-5.3468, 28.9365, -2.9726>, <-1.1022, 21.08306, -0.3641> }
			pigment { color rgb <0.19, 0.39, 0.19> }}
		}
	union { // internode
		cylinder { <-0.9578, 20.5334, -0.3164>, <-1.8218, 27.7836, -1.111>, 0.4896 }
		cylinder { <-1.8218, 27.7836, -1.111>, <-3.02855, 34.8894, -2.523>, 0.4896 }
		cylinder { <-3.02855, 34.8894, -2.523>, <-4.5663, 41.7825, -4.5389>, 0.4896 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.5663, 41.7825, -4.5389>, <-4.6681, 42.188, -4.6775>, 0.4403 }
			cylinder { <-4.6681, 42.188, -4.6775>, <-4.7792, 42.5845, -4.8334>, 0.4403 }
			cylinder { <-4.7792, 42.5845, -4.8334>, <-4.8995, 42.9713, -5.006316>, 0.4403 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-4.8995, 42.9713, -5.006316>, <-11.4661, 51.3835, -8.07428>, <-7.8099, 51.08028, -9.9042> }
			triangle { <-7.8099, 51.08028, -9.9042>, <-11.4661, 51.3835, -8.07428>, <-14.2475, 55.8927, -10.716> }
			triangle { <-7.8099, 51.08028, -9.9042>, <-14.2475, 55.8927, -10.716>, <-10.8457, 55.381, -13.506> }
			triangle { <-10.8457, 55.381, -13.506>, <-14.2475, 55.8927, -10.716>, <-15.759, 57.8618, -14.2337> }
			triangle { <-10.8457, 55.381, -13.506>, <-15.759, 57.8618, -14.2337>, <-13.3173, 57.09287, -16.09539> }
			triangle { <-13.3173, 57.09287, -16.09539>, <-15.759, 57.8618, -14.2337>, <-14.9939, 57.1646, -17.3394> }
			triangle { <-12.5563, 56.2558, -18.6424>, <-13.3173, 57.09287, -16.09539>, <-14.9939, 57.1646, -17.3394> }
			triangle { <-12.5563, 56.2558, -18.6424>, <-10.8457, 55.381, -13.506>, <-13.3173, 57.09287, -16.09539> }
			triangle { <-12.5563, 56.2558, -18.6424>, <-9.5435, 54.03391, -17.1765>, <-10.8457, 55.381, -13.506> }
			triangle { <-10.8457, 55.381, -13.506>, <-9.5435, 54.03391, -17.1765>, <-7.8099, 51.08028, -9.9042> }
			triangle { <-7.8099, 51.08028, -9.9042>, <-9.5435, 54.03391, -17.1765>, <-7.3073, 49.8951, -12.8527> }
			triangle { <-7.8099, 51.08028, -9.9042>, <-7.3073, 49.8951, -12.8527>, <-4.8995, 42.9713, -5.006316> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-4.5663, 41.7825, -4.5389>, <-4.6486, 42.2027, -4.6418>, 0.4403 }
			cylinder { <-4.6486, 42.2027, -4.6418>, <-4.721, 42.6288, -4.7265>, 0.4403 }
			cylinder { <-4.721, 42.6288, -4.7265>, <-4.7831, 43.05976, -4.7927>, 0.4403 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-4.7831, 43.05976, -4.7927>, <-2.3457, 53.7001, -6.827>, <-5.8246, 52.9152, -4.8046> }
			triangle { <-5.8246, 52.9152, -4.8046>, <-2.3457, 53.7001, -6.827>, <-1.848, 59.5969, -6.9964> }
			triangle { <-5.8246, 52.9152, -4.8046>, <-1.848, 59.5969, -6.9964>, <-5.1422, 59.2133, -4.06051> }
			triangle { <-5.1422, 59.2133, -4.06051>, <-1.848, 59.5969, -6.9964>, <-1.6717, 63.4326, -5.04908> }
			triangle { <-5.1422, 59.2133, -4.06051>, <-1.6717, 63.4326, -5.04908>, <-3.8658, 62.7748, -2.8645> }
			triangle { <-3.8658, 62.7748, -2.8645>, <-1.6717, 63.4326, -5.04908>, <-2.521, 64.09048, -1.9566> }
			triangle { <-4.5846, 63.05457, -0.1864>, <-3.8658, 62.7748, -2.8645>, <-2.521, 64.09048, -1.9566> }
			triangle { <-4.5846, 63.05457, -0.1864>, <-5.1422, 59.2133, -4.06051>, <-3.8658, 62.7748, -2.8645> }
			triangle { <-4.5846, 63.05457, -0.1864>, <-6.3132, 59.4255, -0.115>, <-5.1422, 59.2133, -4.06051> }
			triangle { <-5.1422, 59.2133, -4.06051>, <-6.3132, 59.4255, -0.115>, <-5.8246, 52.9152, -4.8046> }
			triangle { <-5.8246, 52.9152, -4.8046>, <-6.3132, 59.4255, -0.115>, <-6.2283, 53.2182, -1.6272> }
			triangle { <-5.8246, 52.9152, -4.8046>, <-6.2283, 53.2182, -1.6272>, <-4.7831, 43.05976, -4.7927> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-4.5663, 41.7825, -4.5389>, <-6.1332, 48.8065, -6.5931>, 0.4989 }
		cylinder { <-6.1332, 48.8065, -6.5931>, <-7.7001, 55.8304, -8.6472>, 0.4989 }
		cylinder { <-7.7001, 55.8304, -8.6472>, <-9.2671, 62.8544, -10.7014>, 0.4989 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.2671, 62.8544, -10.7014>, <-9.375, 63.3068, -10.7985>, 0.4751 }
			cylinder { <-9.375, 63.3068, -10.7985>, <-9.4909, 63.7632, -10.8617>, 0.4751 }
			cylinder { <-9.4909, 63.7632, -10.8617>, <-9.6139, 64.2211, -10.8908>, 0.4751 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-9.6139, 64.2211, -10.8908>, <-8.3404, 76.1319, -11.03286>, <-12.444, 74.5197, -11.3869> }
			triangle { <-12.444, 74.5197, -11.3869>, <-8.3404, 76.1319, -11.03286>, <-8.9565, 82.4843, -10.7856> }
			triangle { <-12.444, 74.5197, -11.3869>, <-8.9565, 82.4843, -10.7856>, <-13.5266, 81.2127, -10.2097> }
			triangle { <-13.5266, 81.2127, -10.2097>, <-8.9565, 82.4843, -10.7856>, <-10.7237, 86.3391, -8.8901> }
			triangle { <-13.5266, 81.2127, -10.2097>, <-10.7237, 86.3391, -8.8901>, <-13.8267, 85.03699, -8.3097> }
			triangle { <-13.8267, 85.03699, -8.3097>, <-10.7237, 86.3391, -8.8901>, <-13.4546, 86.5246, -6.6583> }
			triangle { <-16.1205, 84.8925, -6.3712>, <-13.8267, 85.03699, -8.3097>, <-13.4546, 86.5246, -6.6583> }
			triangle { <-16.1205, 84.8925, -6.3712>, <-13.5266, 81.2127, -10.2097>, <-13.8267, 85.03699, -8.3097> }
			triangle { <-16.1205, 84.8925, -6.3712>, <-16.9647, 80.771, -7.4256>, <-13.5266, 81.2127, -10.2097> }
			triangle { <-13.5266, 81.2127, -10.2097>, <-16.9647, 80.771, -7.4256>, <-12.444, 74.5197, -11.3869> }
			triangle { <-12.444, 74.5197, -11.3869>, <-16.9647, 80.771, -7.4256>, <-14.7673, 74.386, -8.8118> }
			triangle { <-12.444, 74.5197, -11.3869>, <-14.7673, 74.386, -8.8118>, <-9.6139, 64.2211, -10.8908> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-9.2671, 62.8544, -10.7014>, <-9.3513, 63.2841, -10.8856>, 0.4751 }
			cylinder { <-9.3513, 63.2841, -10.8856>, <-9.4189, 63.6913, -11.121>, 0.4751 }
			cylinder { <-9.4189, 63.6913, -11.121>, <-9.4689, 64.06973, -11.4039>, 0.4751 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-9.4689, 64.06973, -11.4039>, <-15.5845, 72.987, -16.5603>, <-11.1807, 73.3666, -16.399> }
			triangle { <-11.1807, 73.3666, -16.399>, <-15.5845, 72.987, -16.5603>, <-17.67, 78.03615, -19.8696> }
			triangle { <-11.1807, 73.3666, -16.399>, <-17.67, 78.03615, -19.8696>, <-12.988, 78.3683, -20.7662> }
			triangle { <-12.988, 78.3683, -20.7662>, <-17.67, 78.03615, -19.8696>, <-17.6767, 80.6957, -23.6777> }
			triangle { <-12.988, 78.3683, -20.7662>, <-17.6767, 80.6957, -23.6777>, <-14.316, 80.4813, -24.2442> }
			triangle { <-14.316, 80.4813, -24.2442>, <-17.6767, 80.6957, -23.6777>, <-15.2812, 80.6602, -26.2728> }
			triangle { <-12.1793, 80.1842, -26.3386>, <-14.316, 80.4813, -24.2442>, <-15.2812, 80.6602, -26.2728> }
			triangle { <-12.1793, 80.1842, -26.3386>, <-12.988, 78.3683, -20.7662>, <-14.316, 80.4813, -24.2442> }
			triangle { <-12.1793, 80.1842, -26.3386>, <-9.691, 77.8098, -23.6961>, <-12.988, 78.3683, -20.7662> }
			triangle { <-12.988, 78.3683, -20.7662>, <-9.691, 77.8098, -23.6961>, <-11.1807, 73.3666, -16.399> }
			triangle { <-11.1807, 73.3666, -16.399>, <-9.691, 77.8098, -23.6961>, <-9.02465, 72.7607, -19.05073> }
			triangle { <-11.1807, 73.3666, -16.399>, <-9.02465, 72.7607, -19.05073>, <-9.4689, 64.06973, -11.4039> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-9.2671, 62.8544, -10.7014>, <-10.3806, 69.8829, -13.06997>, 0.5 }
		cylinder { <-10.3806, 69.8829, -13.06997>, <-11.03145, 76.8629, -15.7357>, 0.5 }
		cylinder { <-11.03145, 76.8629, -15.7357>, <-11.2159, 83.7566, -18.6841>, 0.5 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.2159, 83.7566, -18.6841>, <-11.1878, 84.1877, -18.8958>, 0.4811 }
			cylinder { <-11.1878, 84.1877, -18.8958>, <-11.1199, 84.6035, -19.1281>, 0.4811 }
			cylinder { <-11.1199, 84.6035, -19.1281>, <-11.01315, 85.0002, -19.3786>, 0.4811 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-11.01315, 85.0002, -19.3786>, <-11.9545, 93.2644, -28.2094>, <-9.12, 94.1463, -24.8552> }
			triangle { <-9.12, 94.1463, -24.8552>, <-11.9545, 93.2644, -28.2094>, <-11.2626, 98.09866, -32.4502> }
			triangle { <-9.12, 94.1463, -24.8552>, <-11.2626, 98.09866, -32.4502>, <-7.4438, 98.9612, -29.6059> }
			triangle { <-7.4438, 98.9612, -29.6059>, <-11.2626, 98.09866, -32.4502>, <-8.6118, 100.7626, -35.2789> }
			triangle { <-7.4438, 98.9612, -29.6059>, <-8.6118, 100.7626, -35.2789>, <-5.8949, 100.9263, -33.1459> }
			triangle { <-5.8949, 100.9263, -33.1459>, <-8.6118, 100.7626, -35.2789>, <-5.04262, 100.9907, -35.2619> }
			triangle { <-2.8565, 100.8633, -32.9578>, <-5.8949, 100.9263, -33.1459>, <-5.04262, 100.9907, -35.2619> }
			triangle { <-2.8565, 100.8633, -32.9578>, <-7.4438, 98.9612, -29.6059>, <-5.8949, 100.9263, -33.1459> }
			triangle { <-2.8565, 100.8633, -32.9578>, <-2.9742, 98.7641, -29.1014>, <-7.4438, 98.9612, -29.6059> }
			triangle { <-7.4438, 98.9612, -29.6059>, <-2.9742, 98.7641, -29.1014>, <-9.12, 94.1463, -24.8552> }
			triangle { <-9.12, 94.1463, -24.8552>, <-2.9742, 98.7641, -29.1014>, <-5.6283, 93.7729, -25.00596> }
			triangle { <-9.12, 94.1463, -24.8552>, <-5.6283, 93.7729, -25.00596>, <-11.01315, 85.0002, -19.3786> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-11.2159, 83.7566, -18.6841>, <-11.2576, 84.2043, -18.8551>, 0.4811 }
			cylinder { <-11.2576, 84.2043, -18.8551>, <-11.3291, 84.6552, -19.00709>, 0.4811 }
			cylinder { <-11.3291, 84.6552, -19.00709>, <-11.4298, 85.1068, -19.1391>, 0.4811 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-11.4298, 85.1068, -19.1391>, <-11.6677, 97.2304, -18.782>, <-14.1908, 95.2101, -21.8828> }
			triangle { <-14.1908, 95.2101, -21.8828>, <-11.6677, 97.2304, -18.782>, <-12.9519, 103.5503, -19.2747> }
			triangle { <-14.1908, 95.2101, -21.8828>, <-12.9519, 103.5503, -19.2747>, <-16.5031, 101.782, -22.04584> }
			triangle { <-16.5031, 101.782, -22.04584>, <-12.9519, 103.5503, -19.2747>, <-15.9648, 107.1624, -19.2975> }
			triangle { <-16.5031, 101.782, -22.04584>, <-15.9648, 107.1624, -19.2975>, <-18.4638, 105.5111, -21.02574> }
			triangle { <-18.4638, 105.5111, -21.02574>, <-15.9648, 107.1624, -19.2975>, <-19.5212, 106.9681, -19.6231> }
			triangle { <-21.4646, 105.0427, -21.2418>, <-18.4638, 105.5111, -21.02574>, <-19.5212, 106.9681, -19.6231> }
			triangle { <-21.4646, 105.0427, -21.2418>, <-16.5031, 101.782, -22.04584>, <-18.4638, 105.5111, -21.02574> }
			triangle { <-21.4646, 105.0427, -21.2418>, <-20.8912, 100.8588, -22.4492>, <-16.5031, 101.782, -22.04584> }
			triangle { <-16.5031, 101.782, -22.04584>, <-20.8912, 100.8588, -22.4492>, <-14.1908, 95.2101, -21.8828> }
			triangle { <-14.1908, 95.2101, -21.8828>, <-20.8912, 100.8588, -22.4492>, <-17.6641, 94.7195, -21.6597> }
			triangle { <-14.1908, 95.2101, -21.8828>, <-17.6641, 94.7195, -21.6597>, <-11.4298, 85.1068, -19.1391> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-11.2159, 83.7566, -18.6841>, <-11.9405, 90.5573, -21.6967>, 0.4982 }
		cylinder { <-11.9405, 90.5573, -21.6967>, <-13.2019, 97.2528, -24.7675>, 0.4982 }
		cylinder { <-13.2019, 97.2528, -24.7675>, <-14.9933, 103.8068, -27.8799>, 0.4982 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-14.9933, 103.8068, -27.8799>, <-15.1469, 104.1973, -28.07435>, 0.4624 }
			cylinder { <-15.1469, 104.1973, -28.07435>, <-15.3418, 104.569, -28.2687>, 0.4624 }
			cylinder { <-15.3418, 104.569, -28.2687>, <-15.5761, 104.9182, -28.4611>, 0.4624 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-15.5761, 104.9182, -28.4611>, <-20.7407, 115.3526, -29.1146>, <-20.3865, 113.086, -32.7579> }
			triangle { <-20.3865, 113.086, -32.7579>, <-20.7407, 115.3526, -29.1146>, <-23.9836, 120.4523, -30.5737> }
			triangle { <-20.3865, 113.086, -32.7579>, <-23.9836, 120.4523, -30.5737>, <-24.6465, 117.9702, -34.4512> }
			triangle { <-24.6465, 117.9702, -34.4512>, <-23.9836, 120.4523, -30.5737>, <-27.652, 122.4702, -32.2807> }
			triangle { <-24.6465, 117.9702, -34.4512>, <-27.652, 122.4702, -32.2807>, <-28.05878, 120.3366, -34.7969> }
			triangle { <-28.05878, 120.3366, -34.7969>, <-27.652, 122.4702, -32.2807>, <-30.07108, 121.0065, -34.2364> }
			triangle { <-30.0058, 118.8275, -36.3773>, <-28.05878, 120.3366, -34.7969>, <-30.07108, 121.0065, -34.2364> }
			triangle { <-30.0058, 118.8275, -36.3773>, <-24.6465, 117.9702, -34.4512>, <-28.05878, 120.3366, -34.7969> }
			triangle { <-30.0058, 118.8275, -36.3773>, <-27.3587, 115.5682, -36.8185>, <-24.6465, 117.9702, -34.4512> }
			triangle { <-24.6465, 117.9702, -34.4512>, <-27.3587, 115.5682, -36.8185>, <-20.3865, 113.086, -32.7579> }
			triangle { <-20.3865, 113.086, -32.7579>, <-27.3587, 115.5682, -36.8185>, <-22.8785, 111.316, -34.1973> }
			triangle { <-20.3865, 113.086, -32.7579>, <-22.8785, 111.316, -34.1973>, <-15.5761, 104.9182, -28.4611> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-14.9933, 103.8068, -27.8799>, <-15.06033, 104.2236, -28.06887>, 0.4624 }
			cylinder { <-15.06033, 104.2236, -28.06887>, <-15.08288, 104.6475, -28.2523>, 0.4624 }
			cylinder { <-15.08288, 104.6475, -28.2523>, <-15.06073, 105.0745, -28.4285>, 0.4624 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-15.06073, 105.0745, -28.4285>, <-15.4735, 113.264, -36.7195>, <-15.4464, 114.5912, -32.6238> }
			triangle { <-15.4464, 114.5912, -32.6238>, <-15.4735, 113.264, -36.7195>, <-15.2708, 118.415, -40.1948> }
			triangle { <-15.4464, 114.5912, -32.6238>, <-15.2708, 118.415, -40.1948>, <-14.3071, 120.2461, -36.0289> }
			triangle { <-14.3071, 120.2461, -36.0289>, <-15.2708, 118.415, -40.1948>, <-13.3372, 122.3236, -41.3896> }
			triangle { <-14.3071, 120.2461, -36.0289>, <-13.3372, 122.3236, -41.3896>, <-12.4931, 123.2283, -38.3045> }
			triangle { <-12.4931, 123.2283, -38.3045>, <-13.3372, 122.3236, -41.3896>, <-10.9443, 124.0485, -39.6239> }
			triangle { <-10.417, 124.4483, -36.6409>, <-12.4931, 123.2283, -38.3045>, <-10.9443, 124.0485, -39.6239> }
			triangle { <-10.417, 124.4483, -36.6409>, <-14.3071, 120.2461, -36.0289>, <-12.4931, 123.2283, -38.3045> }
			triangle { <-10.417, 124.4483, -36.6409>, <-11.31, 121.9102, -33.3874>, <-14.3071, 120.2461, -36.0289> }
			triangle { <-14.3071, 120.2461, -36.0289>, <-11.31, 121.9102, -33.3874>, <-15.4464, 114.5912, -32.6238> }
			triangle { <-15.4464, 114.5912, -32.6238>, <-11.31, 121.9102, -33.3874>, <-12.7506, 115.8101, -30.9922> }
			triangle { <-15.4464, 114.5912, -32.6238>, <-12.7506, 115.8101, -30.9922>, <-15.06073, 105.0745, -28.4285> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-14.9933, 103.8068, -27.8799>, <-16.4779, 110.1506, -30.5885>, 0.4703 }
		cylinder { <-16.4779, 110.1506, -30.5885>, <-17.7522, 116.6351, -33.06066>, 0.4703 }
		cylinder { <-17.7522, 116.6351, -33.06066>, <-18.8132, 123.2448, -35.2903>, 0.4703 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-18.8132, 123.2448, -35.2903>, <-18.8401, 123.6019, -35.3738>, 0.3677 }
			cylinder { <-18.8401, 123.6019, -35.3738>, <-18.8384, 123.9663, -35.4233>, 0.3677 }
			cylinder { <-18.8384, 123.9663, -35.4233>, <-18.8079, 124.3325, -35.438>, 0.3677 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-18.8079, 124.3325, -35.438>, <-17.09245, 132.3408, -39.7869>, <-19.0997, 132.4518, -37.01546> }
			triangle { <-19.0997, 132.4518, -37.01546>, <-17.09245, 132.3408, -39.7869>, <-16.4679, 137.0344, -41.2091> }
			triangle { <-19.0997, 132.4518, -37.01546>, <-16.4679, 137.0344, -41.2091>, <-18.00507, 137.5908, -37.891> }
			triangle { <-18.00507, 137.5908, -37.891>, <-16.4679, 137.0344, -41.2091>, <-15.4784, 140.4274, -40.5493> }
			triangle { <-18.00507, 137.5908, -37.891>, <-15.4784, 140.4274, -40.5493>, <-16.4455, 140.5076, -38.09061> }
			triangle { <-16.4455, 140.5076, -38.09061>, <-15.4784, 140.4274, -40.5493>, <-15.04649, 141.5496, -38.09416> }
			triangle { <-16.07359, 141.2422, -35.9137>, <-16.4455, 140.5076, -38.09061>, <-15.04649, 141.5496, -38.09416> }
			triangle { <-16.07359, 141.2422, -35.9137>, <-18.00507, 137.5908, -37.891>, <-16.4455, 140.5076, -38.09061> }
			triangle { <-16.07359, 141.2422, -35.9137>, <-17.5527, 138.5249, -34.6098>, <-18.00507, 137.5908, -37.891> }
			triangle { <-18.00507, 137.5908, -37.891>, <-17.5527, 138.5249, -34.6098>, <-19.0997, 132.4518, -37.01546> }
			triangle { <-19.0997, 132.4518, -37.01546>, <-17.5527, 138.5249, -34.6098>, <-18.3177, 133.2443, -34.5702> }
			triangle { <-19.0997, 132.4518, -37.01546>, <-18.3177, 133.2443, -34.5702>, <-18.8079, 124.3325, -35.438> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-18.8132, 123.2448, -35.2903>, <-18.8851, 123.5792, -35.4254>, 0.3677 }
			cylinder { <-18.8851, 123.5792, -35.4254>, <-18.9732, 123.9017, -35.5786>, 0.3677 }
			cylinder { <-18.9732, 123.9017, -35.5786>, <-19.0772, 124.2106, -35.749>, 0.3677 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-19.0772, 124.2106, -35.749>, <-23.9827, 131.8845, -37.4909>, <-21.4719, 131.0894, -39.6786> }
			triangle { <-21.4719, 131.0894, -39.6786>, <-23.9827, 131.8845, -37.4909>, <-26.2282, 135.8644, -39.3778> }
			triangle { <-21.4719, 131.0894, -39.6786>, <-26.2282, 135.8644, -39.3778>, <-24.1447, 134.895, -42.2763> }
			triangle { <-24.1447, 134.895, -42.2763>, <-26.2282, 135.8644, -39.3778>, <-27.9371, 137.553, -42.05286> }
			triangle { <-24.1447, 134.895, -42.2763>, <-27.9371, 137.553, -42.05286>, <-26.4595, 136.5314, -43.992> }
			triangle { <-26.4595, 136.5314, -43.992>, <-27.9371, 137.553, -42.05286>, <-28.0512, 136.7629, -44.6675> }
			triangle { <-26.4773, 135.6475, -46.1449>, <-26.4595, 136.5314, -43.992>, <-28.0512, 136.7629, -44.6675> }
			triangle { <-26.4773, 135.6475, -46.1449>, <-24.1447, 134.895, -42.2763>, <-26.4595, 136.5314, -43.992> }
			triangle { <-26.4773, 135.6475, -46.1449>, <-24.02251, 133.4782, -45.4102>, <-24.1447, 134.895, -42.2763> }
			triangle { <-24.1447, 134.895, -42.2763>, <-24.02251, 133.4782, -45.4102>, <-21.4719, 131.0894, -39.6786> }
			triangle { <-21.4719, 131.0894, -39.6786>, <-24.02251, 133.4782, -45.4102>, <-21.8207, 129.9374, -42.08064> }
			triangle { <-21.4719, 131.0894, -39.6786>, <-21.8207, 129.9374, -42.08064>, <-19.0772, 124.2106, -35.749> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // internode
		cylinder { <-18.8132, 123.2448, -35.2903>, <-19.5671, 127.9478, -37.00785>, 0.3375 }
		cylinder { <-19.5671, 127.9478, -37.00785>, <-20.3132, 132.608, -38.8416>, 0.3375 }
		cylinder { <-20.3132, 132.608, -38.8416>, <-21.05099, 137.2225, -40.7907>, 0.3375 }
		pigment { color rgb <0.19, 0.51, 0.19> }}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-21.05099, 137.2225, -40.7907>, <-21.08075, 137.4094, -40.8866>, 0.2121 }
			cylinder { <-21.08075, 137.4094, -40.8866>, <-21.1091, 137.5888, -40.9961>, 0.2121 }
			cylinder { <-21.1091, 137.5888, -40.9961>, <-21.1361, 137.7599, -41.1187>, 0.2121 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-21.1361, 137.7599, -41.1187>, <-23.6972, 141.5371, -43.9087>, <-21.7227, 141.5678, -43.9375> }
			triangle { <-21.7227, 141.5678, -43.9375>, <-23.6972, 141.5371, -43.9087>, <-24.5429, 143.6033, -45.6831> }
			triangle { <-21.7227, 141.5678, -43.9375>, <-24.5429, 143.6033, -45.6831>, <-22.4691, 143.5318, -46.1796> }
			triangle { <-22.4691, 143.5318, -46.1796>, <-24.5429, 143.6033, -45.6831>, <-24.5474, 144.5145, -47.5462> }
			triangle { <-22.4691, 143.5318, -46.1796>, <-24.5474, 144.5145, -47.5462>, <-23.07097, 144.2692, -47.8371> }
			triangle { <-23.07097, 144.2692, -47.8371>, <-24.5474, 144.5145, -47.5462>, <-23.5389, 144.2421, -48.7275> }
			triangle { <-22.1747, 143.9244, -48.7753>, <-23.07097, 144.2692, -47.8371>, <-23.5389, 144.2421, -48.7275> }
			triangle { <-22.1747, 143.9244, -48.7753>, <-22.4691, 143.5318, -46.1796>, <-23.07097, 144.2692, -47.8371> }
			triangle { <-22.1747, 143.9244, -48.7753>, <-21.08267, 142.9763, -47.4873>, <-22.4691, 143.5318, -46.1796> }
			triangle { <-22.4691, 143.5318, -46.1796>, <-21.08267, 142.9763, -47.4873>, <-21.7227, 141.5678, -43.9375> }
			triangle { <-21.7227, 141.5678, -43.9375>, <-21.08267, 142.9763, -47.4873>, <-20.8393, 141.0486, -45.1002> }
			triangle { <-21.7227, 141.5678, -43.9375>, <-20.8393, 141.0486, -45.1002>, <-21.1361, 137.7599, -41.1187> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // leaf and petiole
		union { // petiole
			cylinder { <-21.05099, 137.2225, -40.7907>, <-21.08318, 137.4228, -40.8528>, 0.2121 }
			cylinder { <-21.08318, 137.4228, -40.8528>, <-21.1163, 137.6281, -40.8947>, 0.2121 }
			cylinder { <-21.1163, 137.6281, -40.8947>, <-21.1501, 137.8364, -40.916>, 0.2121 }
			pigment { color rgb <0.19, 0.49, 0.19> }}
		mesh { // leaf
			triangle { <-21.1501, 137.8364, -40.916>, <-19.9757, 142.9496, -41.9586>, <-21.873, 142.4983, -41.6471> }
			triangle { <-21.873, 142.4983, -41.6471>, <-19.9757, 142.9496, -41.9586>, <-19.8804, 145.7832, -42.2657> }
			triangle { <-21.873, 142.4983, -41.6471>, <-19.8804, 145.7832, -42.2657>, <-21.8746, 145.569, -41.5378> }
			triangle { <-21.8746, 145.569, -41.5378>, <-19.8804, 145.7832, -42.2657>, <-20.2628, 147.7029, -41.58> }
			triangle { <-21.8746, 145.569, -41.5378>, <-20.2628, 147.7029, -41.58>, <-21.6225, 147.3771, -40.9717> }
			triangle { <-21.6225, 147.3771, -40.9717>, <-20.2628, 147.7029, -41.58>, <-21.2272, 148.1035, -40.3984> }
			triangle { <-22.4425, 147.5863, -39.9295>, <-21.6225, 147.3771, -40.9717>, <-21.2272, 148.1035, -40.3984> }
			triangle { <-22.4425, 147.5863, -39.9295>, <-21.8746, 145.569, -41.5378>, <-21.6225, 147.3771, -40.9717> }
			triangle { <-22.4425, 147.5863, -39.9295>, <-23.1271, 145.7766, -40.0118>, <-21.8746, 145.569, -41.5378> }
			triangle { <-21.8746, 145.569, -41.5378>, <-23.1271, 145.7766, -40.0118>, <-21.873, 142.4983, -41.6471> }
			triangle { <-21.873, 142.4983, -41.6471>, <-23.1271, 145.7766, -40.0118>, <-22.6457, 142.7531, -40.328> }
			triangle { <-21.873, 142.4983, -41.6471>, <-22.6457, 142.7531, -40.328>, <-21.1501, 137.8364, -40.916> }
			pigment { color rgb <0.19, 0.78, 0.19> }}
		}
	union { // inflorescence
		union { // peduncle
			cylinder { <-21.05099, 137.2225, -40.7907>, <-22.508, 146.3361, -44.6402>, 0.55 }
			cylinder { <-22.508, 146.3361, -44.6402>, <-23.9651, 155.4497, -48.4897>, 0.55 }
			cylinder { <-23.9651, 155.4497, -48.4897>, <-25.4222, 164.5634, -52.3392>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // inflor. internode
			cylinder { <-25.4222, 164.5634, -52.3392>, <-25.5914, 165.4808, -52.6993>, 0.55 }
			cylinder { <-25.5914, 165.4808, -52.6993>, <-25.7839, 166.4032, -53.03426>, 0.55 }
			cylinder { <-25.7839, 166.4032, -53.03426>, <-25.9994, 167.3294, -53.3434>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-25.9994, 167.3294, -53.3434>, <-25.7624, 167.7425, -53.4957>, 0.55 }
				cylinder { <-25.7624, 167.7425, -53.4957>, <-25.2957, 167.905, -53.5717>, 0.55 }
				cylinder { <-25.2957, 167.905, -53.5717>, <-24.8259, 167.7379, -53.5345>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-24.8259, 167.7379, -53.5345>, <-24.5603, 166.2434, -54.2958>, <-24.2262, 166.7175, -53.5139> }
					triangle { <-23.9315, 165.788, -54.853>, <-22.9978, 165.2422, -53.6261>, <-23.9408, 165.9749, -53.5845> }
					triangle { <-24.5603, 166.2434, -54.2958>, <-23.9408, 165.9749, -53.5845>, <-24.2262, 166.7175, -53.5139> }
					triangle { <-24.5603, 166.2434, -54.2958>, <-23.9315, 165.788, -54.853>, <-23.9408, 165.9749, -53.5845> }
					triangle { <-23.9315, 165.788, -54.853>, <-22.7386, 165.3573, -55.08102>, <-22.9978, 165.2422, -53.6261> }
					triangle { <-22.7386, 165.3573, -55.08102>, <-21.6327, 164.8528, -55.0561>, <-22.1975, 164.8303, -53.6873> }
					triangle { <-22.7386, 165.3573, -55.08102>, <-22.1975, 164.8303, -53.6873>, <-22.9978, 165.2422, -53.6261> }
					triangle { <-21.6327, 164.8528, -55.0561>, <-20.4885, 164.223, -54.8783>, <-20.5185, 164.1646, -53.7525> }
					triangle { <-21.6327, 164.8528, -55.0561>, <-20.5185, 164.1646, -53.7525>, <-22.1975, 164.8303, -53.6873> }
					triangle { <-20.4885, 164.223, -54.8783>, <-21.1743, 162.6379, -52.878>, <-20.7208, 162.9458, -52.7923> }
					triangle { <-20.4885, 164.223, -54.8783>, <-20.7208, 162.9458, -52.7923>, <-20.5185, 164.1646, -53.7525> }
					triangle { <-20.5185, 164.1646, -53.7525>, <-20.7208, 162.9458, -52.7923>, <-20.4203, 163.351, -52.4827> }
					triangle { <-24.2262, 166.7175, -53.5139>, <-23.9408, 165.9749, -53.5845>, <-22.7737, 165.6957, -53.4167> }
					triangle { <-23.9408, 165.9749, -53.5845>, <-22.9978, 165.2422, -53.6261>, <-22.7737, 165.6957, -53.4167> }
					triangle { <-22.9978, 165.2422, -53.6261>, <-22.1975, 164.8303, -53.6873>, <-22.7737, 165.6957, -53.4167> }
					triangle { <-22.1975, 164.8303, -53.6873>, <-20.3877, 164.4306, -53.03736>, <-22.7737, 165.6957, -53.4167> }
					triangle { <-22.1975, 164.8303, -53.6873>, <-20.5185, 164.1646, -53.7525>, <-20.3877, 164.4306, -53.03736> }
					triangle { <-20.5185, 164.1646, -53.7525>, <-20.4203, 163.351, -52.4827>, <-20.3877, 164.4306, -53.03736> }
					triangle { <-20.4203, 163.351, -52.4827>, <-20.1432, 163.8103, -52.1492>, <-20.3877, 164.4306, -53.03736> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-24.2262, 166.7175, -53.5139>, <-24.09944, 166.8737, -52.8081> }
					triangle { <-24.2262, 166.7175, -53.5139>, <-22.7737, 165.6957, -53.4167>, <-24.09944, 166.8737, -52.8081> }
					triangle { <-22.7737, 165.6957, -53.4167>, <-22.6897, 166.0701, -52.6539>, <-24.09944, 166.8737, -52.8081> }
					triangle { <-22.7737, 165.6957, -53.4167>, <-20.3877, 164.4306, -53.03736>, <-22.6897, 166.0701, -52.6539> }
					triangle { <-22.6897, 166.0701, -52.6539>, <-20.3877, 164.4306, -53.03736>, <-20.3375, 164.7364, -52.3222> }
					triangle { <-20.3877, 164.4306, -53.03736>, <-20.1432, 163.8103, -52.1492>, <-20.3375, 164.7364, -52.3222> }
					triangle { <-20.1432, 163.8103, -52.1492>, <-20.01239, 164.177, -51.749>, <-20.3375, 164.7364, -52.3222> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-25.08935, 166.5962, -53.662>, <-24.5603, 166.2434, -54.2958> }
					triangle { <-23.8203, 167.5391, -52.9424>, <-23.478, 168.4343, -52.7717>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-23.1629, 167.5496, -52.489>, <-22.05087, 167.1593, -52.2925>, <-22.5448, 168.5951, -52.9003> }
					triangle { <-23.8203, 167.5391, -52.9424>, <-23.1629, 167.5496, -52.489>, <-23.478, 168.4343, -52.7717> }
					triangle { <-23.1629, 167.5496, -52.489>, <-22.5448, 168.5951, -52.9003>, <-23.478, 168.4343, -52.7717> }
					triangle { <-22.05087, 167.1593, -52.2925>, <-21.3519, 168.1644, -53.1282>, <-22.5448, 168.5951, -52.9003> }
					triangle { <-21.2166, 166.8158, -52.3061>, <-20.2798, 167.5914, -53.1509>, <-21.3519, 168.1644, -53.1282> }
					triangle { <-22.05087, 167.1593, -52.2925>, <-21.2166, 166.8158, -52.3061>, <-21.3519, 168.1644, -53.1282> }
					triangle { <-19.6053, 166.0132, -52.4666>, <-19.1694, 166.8932, -53.02087>, <-20.2798, 167.5914, -53.1509> }
					triangle { <-21.2166, 166.8158, -52.3061>, <-19.6053, 166.0132, -52.4666>, <-20.2798, 167.5914, -53.1509> }
					triangle { <-19.4394, 165.3365, -51.1015>, <-19.5357, 165.8527, -50.8398>, <-19.1694, 166.8932, -53.02087> }
					triangle { <-19.6053, 166.0132, -52.4666>, <-19.4394, 165.3365, -51.1015>, <-19.1694, 166.8932, -53.02087> }
					triangle { <-19.6275, 164.8546, -51.2106>, <-19.4394, 165.3365, -51.1015>, <-19.6053, 166.0132, -52.4666> }
					triangle { <-22.2326, 166.7912, -52.6546>, <-23.1629, 167.5496, -52.489>, <-23.8203, 167.5391, -52.9424> }
					triangle { <-22.2326, 166.7912, -52.6546>, <-22.05087, 167.1593, -52.2925>, <-23.1629, 167.5496, -52.489> }
					triangle { <-22.2326, 166.7912, -52.6546>, <-21.2166, 166.8158, -52.3061>, <-22.05087, 167.1593, -52.2925> }
					triangle { <-22.2326, 166.7912, -52.6546>, <-19.948, 165.3206, -52.4182>, <-21.2166, 166.8158, -52.3061> }
					triangle { <-19.948, 165.3206, -52.4182>, <-19.6053, 166.0132, -52.4666>, <-21.2166, 166.8158, -52.3061> }
					triangle { <-19.948, 165.3206, -52.4182>, <-19.6275, 164.8546, -51.2106>, <-19.6053, 166.0132, -52.4666> }
					triangle { <-19.948, 165.3206, -52.4182>, <-19.8135, 164.4781, -51.4726>, <-19.6275, 164.8546, -51.2106> }
					triangle { <-24.09944, 166.8737, -52.8081>, <-23.8203, 167.5391, -52.9424>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-24.09944, 166.8737, -52.8081>, <-22.2326, 166.7912, -52.6546>, <-23.8203, 167.5391, -52.9424> }
					triangle { <-24.09944, 166.8737, -52.8081>, <-22.6897, 166.0701, -52.6539>, <-22.2326, 166.7912, -52.6546> }
					triangle { <-22.6897, 166.0701, -52.6539>, <-19.948, 165.3206, -52.4182>, <-22.2326, 166.7912, -52.6546> }
					triangle { <-20.3375, 164.7364, -52.3222>, <-19.948, 165.3206, -52.4182>, <-22.6897, 166.0701, -52.6539> }
					triangle { <-20.3375, 164.7364, -52.3222>, <-19.8135, 164.4781, -51.4726>, <-19.948, 165.3206, -52.4182> }
					triangle { <-20.3375, 164.7364, -52.3222>, <-20.01239, 164.177, -51.749>, <-19.8135, 164.4781, -51.4726> }
					triangle { <-23.478, 168.4343, -52.7717>, <-24.3114, 168.1709, -52.5666>, <-24.8259, 167.7379, -53.5345> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-24.8259, 167.7379, -53.5345>, <-23.6803, 168.0214, -54.7556>, <-23.9467, 167.281, -54.1823> }
					triangle { <-22.7471, 168.1822, -54.8842>, <-22.3226, 166.6044, -54.9583>, <-23.3904, 167.0851, -54.7209> }
					triangle { <-23.6803, 168.0214, -54.7556>, <-23.3904, 167.0851, -54.7209>, <-23.9467, 167.281, -54.1823> }
					triangle { <-23.6803, 168.0214, -54.7556>, <-22.7471, 168.1822, -54.8842>, <-23.3904, 167.0851, -54.7209> }
					triangle { <-22.7471, 168.1822, -54.8842>, <-21.5162, 167.8289, -54.7401>, <-22.3226, 166.6044, -54.9583> }
					triangle { <-21.5162, 167.8289, -54.7401>, <-20.4378, 167.2688, -54.7008>, <-21.4884, 166.2609, -54.9719> }
					triangle { <-21.5162, 167.8289, -54.7401>, <-21.4884, 166.2609, -54.9719>, <-22.3226, 166.6044, -54.9583> }
					triangle { <-20.4378, 167.2688, -54.7008>, <-19.3464, 166.5319, -54.7567>, <-19.8455, 165.5228, -54.8224> }
					triangle { <-20.4378, 167.2688, -54.7008>, <-19.8455, 165.5228, -54.8224>, <-21.4884, 166.2609, -54.9719> }
					triangle { <-19.3464, 166.5319, -54.7567>, <-20.1512, 164.6985, -56.4815>, <-19.9475, 164.5024, -56.00422> }
					triangle { <-19.3464, 166.5319, -54.7567>, <-19.9475, 164.5024, -56.00422>, <-19.8455, 165.5228, -54.8224> }
					triangle { <-19.8455, 165.5228, -54.8224>, <-19.9475, 164.5024, -56.00422>, <-20.00453, 164.1852, -55.5077> }
					triangle { <-23.9467, 167.281, -54.1823>, <-23.3904, 167.0851, -54.7209>, <-22.4159, 166.417, -54.4525> }
					triangle { <-23.3904, 167.0851, -54.7209>, <-22.3226, 166.6044, -54.9583>, <-22.4159, 166.417, -54.4525> }
					triangle { <-22.3226, 166.6044, -54.9583>, <-21.4884, 166.2609, -54.9719>, <-22.4159, 166.417, -54.4525> }
					triangle { <-21.4884, 166.2609, -54.9719>, <-20.1629, 164.8819, -54.526>, <-22.4159, 166.417, -54.4525> }
					triangle { <-21.4884, 166.2609, -54.9719>, <-19.8455, 165.5228, -54.8224>, <-20.1629, 164.8819, -54.526> }
					triangle { <-19.8455, 165.5228, -54.8224>, <-20.00453, 164.1852, -55.5077>, <-20.1629, 164.8819, -54.526> }
					triangle { <-20.00453, 164.1852, -55.5077>, <-20.1124, 163.8666, -54.9731>, <-20.1629, 164.8819, -54.526> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-23.9467, 167.281, -54.1823>, <-24.2195, 166.6285, -53.9861> }
					triangle { <-23.9467, 167.281, -54.1823>, <-22.4159, 166.417, -54.4525>, <-24.2195, 166.6285, -53.9861> }
					triangle { <-22.4159, 166.417, -54.4525>, <-22.8351, 165.7733, -54.07988>, <-24.2195, 166.6285, -53.9861> }
					triangle { <-22.4159, 166.417, -54.4525>, <-20.1629, 164.8819, -54.526>, <-22.8351, 165.7733, -54.07988> }
					triangle { <-22.8351, 165.7733, -54.07988>, <-20.1629, 164.8819, -54.526>, <-20.5609, 164.2809, -54.2297> }
					triangle { <-20.1629, 164.8819, -54.526>, <-20.1124, 163.8666, -54.9731>, <-20.5609, 164.2809, -54.2297> }
					triangle { <-20.1124, 163.8666, -54.9731>, <-20.3306, 163.5279, -54.5864>, <-20.5609, 164.2809, -54.2297> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-24.5263, 167.7322, -54.6744>, <-23.6803, 168.0214, -54.7556> }
					triangle { <-24.2009, 166.7691, -53.266>, <-24.3581, 166.6563, -52.3119>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-23.8776, 166.1039, -52.9645>, <-22.9157, 165.41, -52.8201>, <-23.6155, 166.4332, -51.7532> }
					triangle { <-24.2009, 166.7691, -53.266>, <-23.8776, 166.1039, -52.9645>, <-24.3581, 166.6563, -52.3119> }
					triangle { <-23.8776, 166.1039, -52.9645>, <-23.6155, 166.4332, -51.7532>, <-24.3581, 166.6563, -52.3119> }
					triangle { <-22.9157, 165.41, -52.8201>, <-22.3847, 166.0799, -51.6092>, <-23.6155, 166.4332, -51.7532> }
					triangle { <-22.1027, 165.0238, -52.7573>, <-21.2851, 165.5625, -51.6463>, <-22.3847, 166.0799, -51.6092> }
					triangle { <-22.9157, 165.41, -52.8201>, <-22.1027, 165.0238, -52.7573>, <-22.3847, 166.0799, -51.6092> }
					triangle { <-20.4174, 164.371, -52.7606>, <-20.1724, 164.8682, -51.7785>, <-21.2851, 165.5625, -51.6463> }
					triangle { <-22.1027, 165.0238, -52.7573>, <-20.4174, 164.371, -52.7606>, <-21.2851, 165.5625, -51.6463> }
					triangle { <-20.6188, 162.9481, -53.2931>, <-21.01764, 162.8531, -52.8734>, <-20.1724, 164.8682, -51.7785> }
					triangle { <-20.4174, 164.371, -52.7606>, <-20.6188, 162.9481, -53.2931>, <-20.1724, 164.8682, -51.7785> }
					triangle { <-20.5296, 163.0258, -53.8084>, <-20.6188, 162.9481, -53.2931>, <-20.4174, 164.371, -52.7606> }
					triangle { <-22.7548, 165.7344, -53.2307>, <-23.8776, 166.1039, -52.9645>, <-24.2009, 166.7691, -53.266> }
					triangle { <-22.7548, 165.7344, -53.2307>, <-22.9157, 165.41, -52.8201>, <-23.8776, 166.1039, -52.9645> }
					triangle { <-22.7548, 165.7344, -53.2307>, <-22.1027, 165.0238, -52.7573>, <-22.9157, 165.41, -52.8201> }
					triangle { <-22.7548, 165.7344, -53.2307>, <-20.4382, 164.3273, -53.5333>, <-22.1027, 165.0238, -52.7573> }
					triangle { <-20.4382, 164.3273, -53.5333>, <-20.4174, 164.371, -52.7606>, <-22.1027, 165.0238, -52.7573> }
					triangle { <-20.4382, 164.3273, -53.5333>, <-20.5296, 163.0258, -53.8084>, <-20.4174, 164.371, -52.7606> }
					triangle { <-20.4382, 164.3273, -53.5333>, <-20.4131, 163.2604, -54.2284>, <-20.5296, 163.0258, -53.8084> }
					triangle { <-24.2195, 166.6285, -53.9861>, <-24.2009, 166.7691, -53.266>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-24.2195, 166.6285, -53.9861>, <-22.7548, 165.7344, -53.2307>, <-24.2009, 166.7691, -53.266> }
					triangle { <-24.2195, 166.6285, -53.9861>, <-22.8351, 165.7733, -54.07988>, <-22.7548, 165.7344, -53.2307> }
					triangle { <-22.8351, 165.7733, -54.07988>, <-20.4382, 164.3273, -53.5333>, <-22.7548, 165.7344, -53.2307> }
					triangle { <-20.5609, 164.2809, -54.2297>, <-20.4382, 164.3273, -53.5333>, <-22.8351, 165.7733, -54.07988> }
					triangle { <-20.5609, 164.2809, -54.2297>, <-20.4131, 163.2604, -54.2284>, <-20.4382, 164.3273, -53.5333> }
					triangle { <-20.5609, 164.2809, -54.2297>, <-20.3306, 163.5279, -54.5864>, <-20.4131, 163.2604, -54.2284> }
					triangle { <-24.3581, 166.6563, -52.3119>, <-25.01351, 166.751, -52.9181>, <-24.8259, 167.7379, -53.5345> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-24.8259, 167.7379, -53.5345>, <-23.478, 168.4343, -52.7717>, <-23.6508, 167.8804, -53.5533> }
					triangle { <-22.7355, 168.2112, -52.213>, <-21.7331, 167.7992, -53.438>, <-22.8875, 168.1042, -53.4817> }
					triangle { <-23.478, 168.4343, -52.7717>, <-22.8875, 168.1042, -53.4817>, <-23.6508, 167.8804, -53.5533> }
					triangle { <-23.478, 168.4343, -52.7717>, <-22.7355, 168.2112, -52.213>, <-22.8875, 168.1042, -53.4817> }
					triangle { <-22.7355, 168.2112, -52.213>, <-21.6696, 167.5245, -51.9828>, <-21.7331, 167.7992, -53.438> }
					triangle { <-21.6696, 167.5245, -51.9828>, <-20.5975, 166.9515, -52.0055>, <-20.9201, 167.413, -53.3752> }
					triangle { <-21.6696, 167.5245, -51.9828>, <-20.9201, 167.413, -53.3752>, <-21.7331, 167.7992, -53.438> }
					triangle { <-20.5975, 166.9515, -52.0055>, <-19.4024, 166.424, -52.1808>, <-19.3723, 166.4824, -53.3066> }
					triangle { <-20.5975, 166.9515, -52.0055>, <-19.3723, 166.4824, -53.3066>, <-20.9201, 167.413, -53.3752> }
					triangle { <-19.4024, 166.424, -52.1808>, <-18.5552, 167.9293, -54.181>, <-18.5247, 167.3819, -54.2661> }
					triangle { <-19.4024, 166.424, -52.1808>, <-18.5247, 167.3819, -54.2661>, <-19.3723, 166.4824, -53.3066> }
					triangle { <-19.3723, 166.4824, -53.3066>, <-18.5247, 167.3819, -54.2661>, <-18.6639, 166.897, -54.5756> }
					triangle { <-23.6508, 167.8804, -53.5533>, <-22.8875, 168.1042, -53.4817>, <-21.9572, 167.3457, -53.6474> }
					triangle { <-22.8875, 168.1042, -53.4817>, <-21.7331, 167.7992, -53.438>, <-21.9572, 167.3457, -53.6474> }
					triangle { <-21.7331, 167.7992, -53.438>, <-20.9201, 167.413, -53.3752>, <-21.9572, 167.3457, -53.6474> }
					triangle { <-20.9201, 167.413, -53.3752>, <-19.5032, 166.2164, -54.02185>, <-21.9572, 167.3457, -53.6474> }
					triangle { <-20.9201, 167.413, -53.3752>, <-19.3723, 166.4824, -53.3066>, <-19.5032, 166.2164, -54.02185> }
					triangle { <-19.3723, 166.4824, -53.3066>, <-18.6639, 166.897, -54.5756>, <-19.5032, 166.2164, -54.02185> }
					triangle { <-18.6639, 166.897, -54.5756>, <-18.8603, 166.3977, -54.909>, <-19.5032, 166.2164, -54.02185> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-23.6508, 167.8804, -53.5533>, <-23.6969, 167.6842, -54.2591> }
					triangle { <-23.6508, 167.8804, -53.5533>, <-21.9572, 167.3457, -53.6474>, <-23.6969, 167.6842, -54.2591> }
					triangle { <-21.9572, 167.3457, -53.6474>, <-22.2026, 167.0512, -54.4103>, <-23.6969, 167.6842, -54.2591> }
					triangle { <-21.9572, 167.3457, -53.6474>, <-19.5032, 166.2164, -54.02185>, <-22.2026, 167.0512, -54.4103> }
					triangle { <-22.2026, 167.0512, -54.4103>, <-19.5032, 166.2164, -54.02185>, <-19.7147, 165.9904, -54.7371> }
					triangle { <-19.5032, 166.2164, -54.02185>, <-18.8603, 166.3977, -54.909>, <-19.7147, 165.9904, -54.7371> }
					triangle { <-18.8603, 166.3977, -54.909>, <-19.07186, 166.0709, -55.3094>, <-19.7147, 165.9904, -54.7371> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-24.07844, 168.6402, -53.4066>, <-23.478, 168.4343, -52.7717> }
					triangle { <-24.05676, 167.0588, -54.1249>, <-24.5603, 166.2434, -54.2958>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-23.6654, 166.5294, -54.5772>, <-22.6801, 165.8821, -54.7716>, <-24.1222, 165.4041, -54.1658> }
					triangle { <-24.05676, 167.0588, -54.1249>, <-23.6654, 166.5294, -54.5772>, <-24.5603, 166.2434, -54.2958> }
					triangle { <-23.6654, 166.5294, -54.5772>, <-24.1222, 165.4041, -54.1658>, <-24.5603, 166.2434, -54.2958> }
					triangle { <-22.6801, 165.8821, -54.7716>, <-23.0564, 164.7174, -53.9355>, <-24.1222, 165.4041, -54.1658> }
					triangle { <-21.9009, 165.4275, -54.7564>, <-21.9504, 164.2129, -53.9106>, <-23.0564, 164.7174, -53.9355> }
					triangle { <-22.6801, 165.8821, -54.7716>, <-21.9009, 165.4275, -54.7564>, <-23.0564, 164.7174, -53.9355> }
					triangle { <-20.2855, 164.6338, -54.5925>, <-20.7215, 163.7538, -54.03835>, <-21.9504, 164.2129, -53.9106> }
					triangle { <-21.9009, 165.4275, -54.7564>, <-20.2855, 164.6338, -54.5925>, <-21.9504, 164.2129, -53.9106> }
					triangle { <-19.6447, 164.9114, -55.9569>, <-20.1131, 164.6745, -56.2191>, <-20.7215, 163.7538, -54.03835> }
					triangle { <-20.2855, 164.6338, -54.5925>, <-19.6447, 164.9114, -55.9569>, <-20.7215, 163.7538, -54.03835> }
					triangle { <-19.376, 165.3534, -55.8476>, <-19.6447, 164.9114, -55.9569>, <-20.2855, 164.6338, -54.5925> }
					triangle { <-22.4984, 166.2503, -54.4094>, <-23.6654, 166.5294, -54.5772>, <-24.05676, 167.0588, -54.1249> }
					triangle { <-22.4984, 166.2503, -54.4094>, <-22.6801, 165.8821, -54.7716>, <-23.6654, 166.5294, -54.5772> }
					triangle { <-22.4984, 166.2503, -54.4094>, <-21.9009, 165.4275, -54.7564>, <-22.6801, 165.8821, -54.7716> }
					triangle { <-22.4984, 166.2503, -54.4094>, <-19.9429, 165.3264, -54.641>, <-21.9009, 165.4275, -54.7564> }
					triangle { <-19.9429, 165.3264, -54.641>, <-20.2855, 164.6338, -54.5925>, <-21.9009, 165.4275, -54.7564> }
					triangle { <-19.9429, 165.3264, -54.641>, <-19.376, 165.3534, -55.8476>, <-20.2855, 164.6338, -54.5925> }
					triangle { <-19.9429, 165.3264, -54.641>, <-19.19, 165.7299, -55.5856>, <-19.376, 165.3534, -55.8476> }
					triangle { <-23.6969, 167.6842, -54.2591>, <-24.05676, 167.0588, -54.1249>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-23.6969, 167.6842, -54.2591>, <-22.4984, 166.2503, -54.4094>, <-24.05676, 167.0588, -54.1249> }
					triangle { <-23.6969, 167.6842, -54.2591>, <-22.2026, 167.0512, -54.4103>, <-22.4984, 166.2503, -54.4094> }
					triangle { <-22.2026, 167.0512, -54.4103>, <-19.9429, 165.3264, -54.641>, <-22.4984, 166.2503, -54.4094> }
					triangle { <-19.7147, 165.9904, -54.7371>, <-19.9429, 165.3264, -54.641>, <-22.2026, 167.0512, -54.4103> }
					triangle { <-19.7147, 165.9904, -54.7371>, <-19.19, 165.7299, -55.5856>, <-19.9429, 165.3264, -54.641> }
					triangle { <-19.7147, 165.9904, -54.7371>, <-19.07186, 166.0709, -55.3094>, <-19.19, 165.7299, -55.5856> }
					triangle { <-24.5603, 166.2434, -54.2958>, <-24.8563, 167.0654, -54.502>, <-24.8259, 167.7379, -53.5345> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-24.8259, 167.7379, -53.5345>, <-24.3581, 166.6563, -52.3119>, <-23.9303, 167.3168, -52.8849> }
					triangle { <-23.9199, 165.817, -52.1819>, <-22.4083, 166.437, -52.1057>, <-23.4379, 166.994, -52.3453> }
					triangle { <-24.3581, 166.6563, -52.3119>, <-23.4379, 166.994, -52.3453>, <-23.9303, 167.3168, -52.8849> }
					triangle { <-24.3581, 166.6563, -52.3119>, <-23.9199, 165.817, -52.1819>, <-23.4379, 166.994, -52.3453> }
					triangle { <-23.9199, 165.817, -52.1819>, <-22.892, 165.0529, -52.3236>, <-22.4083, 166.437, -52.1057> }
					triangle { <-22.892, 165.0529, -52.3236>, <-21.7924, 164.5355, -52.3607>, <-21.6292, 165.9824, -52.09057> }
					triangle { <-22.892, 165.0529, -52.3236>, <-21.6292, 165.9824, -52.09057>, <-22.4083, 166.437, -52.1057> }
					triangle { <-21.7924, 164.5355, -52.3607>, <-20.5445, 164.1151, -52.3024>, <-20.04539, 165.1242, -52.2367> }
					triangle { <-21.7924, 164.5355, -52.3607>, <-20.04539, 165.1242, -52.2367>, <-21.6292, 165.9824, -52.09057> }
					triangle { <-20.5445, 164.1151, -52.3024>, <-19.5783, 165.8687, -50.5775>, <-19.298, 165.8254, -51.05435> }
					triangle { <-20.5445, 164.1151, -52.3024>, <-19.298, 165.8254, -51.05435>, <-20.04539, 165.1242, -52.2367> }
					triangle { <-20.04539, 165.1242, -52.2367>, <-19.298, 165.8254, -51.05435>, <-19.07971, 166.0627, -51.5506> }
					triangle { <-23.9303, 167.3168, -52.8849>, <-23.4379, 166.994, -52.3453>, <-22.3151, 166.6245, -52.6115> }
					triangle { <-23.4379, 166.994, -52.3453>, <-22.4083, 166.437, -52.1057>, <-22.3151, 166.6245, -52.6115> }
					triangle { <-22.4083, 166.437, -52.1057>, <-21.6292, 165.9824, -52.09057>, <-22.3151, 166.6245, -52.6115> }
					triangle { <-21.6292, 165.9824, -52.09057>, <-19.728, 165.7651, -52.5331>, <-22.3151, 166.6245, -52.6115> }
					triangle { <-21.6292, 165.9824, -52.09057>, <-20.04539, 165.1242, -52.2367>, <-19.728, 165.7651, -52.5331> }
					triangle { <-20.04539, 165.1242, -52.2367>, <-19.07971, 166.0627, -51.5506>, <-19.728, 165.7651, -52.5331> }
					triangle { <-19.07971, 166.0627, -51.5506>, <-18.8911, 166.3414, -52.08515>, <-19.728, 165.7651, -52.5331> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-23.9303, 167.3168, -52.8849>, <-23.5769, 167.9294, -53.08117> }
					triangle { <-23.9303, 167.3168, -52.8849>, <-22.3151, 166.6245, -52.6115>, <-23.5769, 167.9294, -53.08117> }
					triangle { <-22.3151, 166.6245, -52.6115>, <-22.05723, 167.348, -52.9844>, <-23.5769, 167.9294, -53.08117> }
					triangle { <-22.3151, 166.6245, -52.6115>, <-19.728, 165.7651, -52.5331>, <-22.05723, 167.348, -52.9844> }
					triangle { <-22.05723, 167.348, -52.9844>, <-19.728, 165.7651, -52.5331>, <-19.4913, 166.446, -52.8296> }
					triangle { <-19.728, 165.7651, -52.5331>, <-18.8911, 166.3414, -52.08515>, <-19.4913, 166.446, -52.8296> }
					triangle { <-18.8911, 166.3414, -52.08515>, <-18.7536, 166.72, -52.4719>, <-19.4913, 166.446, -52.8296> }
					triangle { <-24.8259, 167.7379, -53.5345>, <-24.6414, 167.5042, -52.3941>, <-24.3581, 166.6563, -52.3119> }
					triangle { <-23.6761, 167.8287, -53.8013>, <-23.6803, 168.0214, -54.7556>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-22.9507, 167.9751, -54.1017>, <-21.8153, 167.6314, -54.2439>, <-23.05152, 167.566, -55.3128> }
					triangle { <-23.6761, 167.8287, -53.8013>, <-22.9507, 167.9751, -54.1017>, <-23.6803, 168.0214, -54.7556> }
					triangle { <-22.9507, 167.9751, -54.1017>, <-23.05152, 167.566, -55.3128>, <-23.6803, 168.0214, -54.7556> }
					triangle { <-21.8153, 167.6314, -54.2439>, <-22.02362, 166.8019, -55.4546>, <-23.05152, 167.566, -55.3128> }
					triangle { <-21.01494, 167.2195, -54.3051>, <-20.9451, 166.2418, -55.4153>, <-22.02362, 166.8019, -55.4546> }
					triangle { <-21.8153, 167.6314, -54.2439>, <-21.01494, 167.2195, -54.3051>, <-22.02362, 166.8019, -55.4546> }
					triangle { <-19.4734, 166.276, -54.2985>, <-19.7184, 165.7788, -55.2806>, <-20.9451, 166.2418, -55.4153> }
					triangle { <-21.01494, 167.2195, -54.3051>, <-19.4734, 166.276, -54.2985>, <-20.9451, 166.2418, -55.4153> }
					triangle { <-18.4654, 167.2999, -53.7652>, <-18.6312, 167.6741, -54.1855>, <-19.7184, 165.7788, -55.2806> }
					triangle { <-19.4734, 166.276, -54.2985>, <-18.4654, 167.2999, -53.7652>, <-19.7184, 165.7788, -55.2806> }
					triangle { <-18.4739, 167.1822, -53.2499>, <-18.4654, 167.2999, -53.7652>, <-19.4734, 166.276, -54.2985> }
					triangle { <-21.9762, 167.307, -53.8334>, <-22.9507, 167.9751, -54.1017>, <-23.6761, 167.8287, -53.8013> }
					triangle { <-21.9762, 167.307, -53.8334>, <-21.8153, 167.6314, -54.2439>, <-22.9507, 167.9751, -54.1017> }
					triangle { <-21.9762, 167.307, -53.8334>, <-21.01494, 167.2195, -54.3051>, <-21.8153, 167.6314, -54.2439> }
					triangle { <-21.9762, 167.307, -53.8334>, <-19.4526, 166.3197, -53.5258>, <-21.01494, 167.2195, -54.3051> }
					triangle { <-19.4526, 166.3197, -53.5258>, <-19.4734, 166.276, -54.2985>, <-21.01494, 167.2195, -54.3051> }
					triangle { <-19.4526, 166.3197, -53.5258>, <-18.4739, 167.1822, -53.2499>, <-19.4734, 166.276, -54.2985> }
					triangle { <-19.4526, 166.3197, -53.5258>, <-18.5904, 166.9476, -52.8299>, <-18.4739, 167.1822, -53.2499> }
					triangle { <-23.5769, 167.9294, -53.08117>, <-23.6761, 167.8287, -53.8013>, <-24.8259, 167.7379, -53.5345> }
					triangle { <-23.5769, 167.9294, -53.08117>, <-21.9762, 167.307, -53.8334>, <-23.6761, 167.8287, -53.8013> }
					triangle { <-23.5769, 167.9294, -53.08117>, <-22.05723, 167.348, -52.9844>, <-21.9762, 167.307, -53.8334> }
					triangle { <-22.05723, 167.348, -52.9844>, <-19.4526, 166.3197, -53.5258>, <-21.9762, 167.307, -53.8334> }
					triangle { <-19.4913, 166.446, -52.8296>, <-19.4526, 166.3197, -53.5258>, <-22.05723, 167.348, -52.9844> }
					triangle { <-19.4913, 166.446, -52.8296>, <-18.5904, 166.9476, -52.8299>, <-19.4526, 166.3197, -53.5258> }
					triangle { <-19.4913, 166.446, -52.8296>, <-18.7536, 166.72, -52.4719>, <-18.5904, 166.9476, -52.8299> }
					triangle { <-23.6803, 168.0214, -54.7556>, <-24.1542, 168.4853, -54.1505>, <-24.8259, 167.7379, -53.5345> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-25.9994, 167.3294, -53.3434>, <-26.1811, 168.2612, -53.6578>, 0.55 }
			cylinder { <-26.1811, 168.2612, -53.6578>, <-26.3287, 169.1973, -53.977>, 0.55 }
			cylinder { <-26.3287, 169.1973, -53.977>, <-26.442, 170.1367, -54.3005>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-26.442, 170.1367, -54.3005>, <-26.7337, 170.3973, -54.612>, 0.55 }
				cylinder { <-26.7337, 170.3973, -54.612>, <-27.1188, 170.3222, -54.9219>, 0.55 }
				cylinder { <-27.1188, 170.3222, -54.9219>, <-27.4103, 169.9479, -55.07985>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-27.4103, 169.9479, -55.07985>, <-28.07735, 169.0701, -53.7883>, <-27.772, 168.8886, -54.6947> }
					triangle { <-28.8957, 168.6717, -53.4971>, <-28.6489, 167.2377, -54.244>, <-27.9909, 168.2338, -54.2932> }
					triangle { <-28.07735, 169.0701, -53.7883>, <-27.9909, 168.2338, -54.2932>, <-27.772, 168.8886, -54.6947> }
					triangle { <-28.07735, 169.0701, -53.7883>, <-28.8957, 168.6717, -53.4971>, <-27.9909, 168.2338, -54.2932> }
					triangle { <-28.8957, 168.6717, -53.4971>, <-29.874, 167.8533, -53.6806>, <-28.6489, 167.2377, -54.244> }
					triangle { <-29.874, 167.8533, -53.6806>, <-30.6078, 166.91, -53.9042>, <-29.2346, 166.557, -54.3318> }
					triangle { <-29.874, 167.8533, -53.6806>, <-29.2346, 166.557, -54.3318>, <-28.6489, 167.2377, -54.244> }
					triangle { <-30.6078, 166.91, -53.9042>, <-31.254, 165.7862, -54.1427>, <-30.4265, 165.2452, -54.685> }
					triangle { <-30.6078, 166.91, -53.9042>, <-30.4265, 165.2452, -54.685>, <-29.2346, 166.557, -54.3318> }
					triangle { <-31.254, 165.7862, -54.1427>, <-29.2801, 164.0673, -53.7772>, <-29.5486, 164.0215, -54.2606> }
					triangle { <-31.254, 165.7862, -54.1427>, <-29.5486, 164.0215, -54.2606>, <-30.4265, 165.2452, -54.685> }
					triangle { <-30.4265, 165.2452, -54.685>, <-29.5486, 164.0215, -54.2606>, <-29.5542, 164.0223, -54.8524> }
					triangle { <-27.772, 168.8886, -54.6947>, <-27.9909, 168.2338, -54.2932>, <-28.6747, 167.3585, -54.7773> }
					triangle { <-27.9909, 168.2338, -54.2932>, <-28.6489, 167.2377, -54.244>, <-28.6747, 167.3585, -54.7773> }
					triangle { <-28.6489, 167.2377, -54.244>, <-29.2346, 166.557, -54.3318>, <-28.6747, 167.3585, -54.7773> }
					triangle { <-29.2346, 166.557, -54.3318>, <-30.01811, 165.046, -55.3119>, <-28.6747, 167.3585, -54.7773> }
					triangle { <-29.2346, 166.557, -54.3318>, <-30.4265, 165.2452, -54.685>, <-30.01811, 165.046, -55.3119> }
					triangle { <-30.4265, 165.2452, -54.685>, <-29.5542, 164.0223, -54.8524>, <-30.01811, 165.046, -55.3119> }
					triangle { <-29.5542, 164.0223, -54.8524>, <-29.5287, 164.0638, -55.4822>, <-30.01811, 165.046, -55.3119> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-27.772, 168.8886, -54.6947>, <-27.363, 168.6158, -55.2396> }
					triangle { <-27.772, 168.8886, -54.6947>, <-28.6747, 167.3585, -54.7773>, <-27.363, 168.6158, -55.2396> }
					triangle { <-28.6747, 167.3585, -54.7773>, <-28.2042, 167.2406, -55.4799>, <-27.363, 168.6158, -55.2396> }
					triangle { <-28.6747, 167.3585, -54.7773>, <-30.01811, 165.046, -55.3119>, <-28.2042, 167.2406, -55.4799> }
					triangle { <-28.2042, 167.2406, -55.4799>, <-30.01811, 165.046, -55.3119>, <-29.555, 164.9171, -55.9255> }
					triangle { <-30.01811, 165.046, -55.3119>, <-29.5287, 164.0638, -55.4822>, <-29.555, 164.9171, -55.9255> }
					triangle { <-29.5287, 164.0638, -55.4822>, <-29.3495, 164.0819, -56.01079>, <-29.555, 164.9171, -55.9255> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-27.2698, 169.3079, -54.1001>, <-28.07735, 169.0701, -53.7883> }
					triangle { <-27.6815, 169.02, -55.7629>, <-27.836, 169.4203, -56.6367>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-27.8174, 168.4855, -56.3406>, <-28.4377, 167.5441, -56.7363>, <-28.5865, 169.1203, -57.1467> }
					triangle { <-27.6815, 169.02, -55.7629>, <-27.8174, 168.4855, -56.3406>, <-27.836, 169.4203, -56.6367> }
					triangle { <-27.8174, 168.4855, -56.3406>, <-28.5865, 169.1203, -57.1467>, <-27.836, 169.4203, -56.6367> }
					triangle { <-28.4377, 167.5441, -56.7363>, <-29.5647, 168.3019, -57.3302>, <-28.5865, 169.1203, -57.1467> }
					triangle { <-29.0159, 166.8744, -56.9132>, <-30.3061, 167.3477, -57.4648>, <-29.5647, 168.3019, -57.3302> }
					triangle { <-28.4377, 167.5441, -56.7363>, <-29.0159, 166.8744, -56.9132>, <-29.5647, 168.3019, -57.3302> }
					triangle { <-30.2228, 165.5406, -57.08843>, <-30.9599, 166.2129, -57.6142>, <-30.3061, 167.3477, -57.4648> }
					triangle { <-29.0159, 166.8744, -56.9132>, <-30.2228, 165.5406, -57.08843>, <-30.3061, 167.3477, -57.4648> }
					triangle { <-29.3355, 164.3397, -57.4338>, <-29.1028, 164.6458, -57.877>, <-30.9599, 166.2129, -57.6142> }
					triangle { <-30.2228, 165.5406, -57.08843>, <-29.3355, 164.3397, -57.4338>, <-30.9599, 166.2129, -57.6142> }
					triangle { <-29.262, 164.134, -56.9524>, <-29.3355, 164.3397, -57.4338>, <-30.2228, 165.5406, -57.08843> }
					triangle { <-28.5541, 167.5336, -56.2015>, <-27.8174, 168.4855, -56.3406>, <-27.6815, 169.02, -55.7629> }
					triangle { <-28.5541, 167.5336, -56.2015>, <-28.4377, 167.5441, -56.7363>, <-27.8174, 168.4855, -56.3406> }
					triangle { <-28.5541, 167.5336, -56.2015>, <-29.0159, 166.8744, -56.9132>, <-28.4377, 167.5441, -56.7363> }
					triangle { <-28.5541, 167.5336, -56.2015>, <-29.92, 165.1883, -56.4691>, <-29.0159, 166.8744, -56.9132> }
					triangle { <-29.92, 165.1883, -56.4691>, <-30.2228, 165.5406, -57.08843>, <-29.0159, 166.8744, -56.9132> }
					triangle { <-29.92, 165.1883, -56.4691>, <-29.262, 164.134, -56.9524>, <-30.2228, 165.5406, -57.08843> }
					triangle { <-29.92, 165.1883, -56.4691>, <-29.3035, 164.0739, -56.4628>, <-29.262, 164.134, -56.9524> }
					triangle { <-27.363, 168.6158, -55.2396>, <-27.6815, 169.02, -55.7629>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-27.363, 168.6158, -55.2396>, <-28.5541, 167.5336, -56.2015>, <-27.6815, 169.02, -55.7629> }
					triangle { <-27.363, 168.6158, -55.2396>, <-28.2042, 167.2406, -55.4799>, <-28.5541, 167.5336, -56.2015> }
					triangle { <-28.2042, 167.2406, -55.4799>, <-29.92, 165.1883, -56.4691>, <-28.5541, 167.5336, -56.2015> }
					triangle { <-29.555, 164.9171, -55.9255>, <-29.92, 165.1883, -56.4691>, <-28.2042, 167.2406, -55.4799> }
					triangle { <-29.555, 164.9171, -55.9255>, <-29.3035, 164.0739, -56.4628>, <-29.92, 165.1883, -56.4691> }
					triangle { <-29.555, 164.9171, -55.9255>, <-29.3495, 164.0819, -56.01079>, <-29.3035, 164.0739, -56.4628> }
					triangle { <-27.836, 169.4203, -56.6367>, <-27.09633, 169.5596, -56.1474>, <-27.4103, 169.9479, -55.07985> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-27.4103, 169.9479, -55.07985>, <-29.09458, 170.1276, -55.2004>, <-28.4681, 169.462, -54.8652> }
					triangle { <-29.845, 169.8276, -55.7104>, <-30.1289, 168.4945, -54.8063>, <-29.2333, 169.2812, -54.7247> }
					triangle { <-29.09458, 170.1276, -55.2004>, <-29.2333, 169.2812, -54.7247>, <-28.4681, 169.462, -54.8652> }
					triangle { <-29.09458, 170.1276, -55.2004>, <-29.845, 169.8276, -55.7104>, <-29.2333, 169.2812, -54.7247> }
					triangle { <-29.845, 169.8276, -55.7104>, <-30.5873, 168.8766, -56.1632>, <-30.1289, 168.4945, -54.8063> }
					triangle { <-30.5873, 168.8766, -56.1632>, <-31.2894, 167.9003, -56.3427>, <-30.7071, 167.8248, -54.9832> }
					triangle { <-30.5873, 168.8766, -56.1632>, <-30.7071, 167.8248, -54.9832>, <-30.1289, 168.4945, -54.8063> }
					triangle { <-31.2894, 167.9003, -56.3427>, <-32.06118, 166.8318, -56.3574>, <-31.7174, 166.3806, -55.3828> }
					triangle { <-31.2894, 167.9003, -56.3427>, <-31.7174, 166.3806, -55.3828>, <-30.7071, 167.8248, -54.9832> }
					triangle { <-32.06118, 166.8318, -56.3574>, <-32.6545, 166.6924, -53.7859>, <-32.4478, 166.2277, -54.00757> }
					triangle { <-32.06118, 166.8318, -56.3574>, <-32.4478, 166.2277, -54.00757>, <-31.7174, 166.3806, -55.3828> }
					triangle { <-31.7174, 166.3806, -55.3828>, <-32.4478, 166.2277, -54.00757>, <-32.04016, 165.7989, -54.02574> }
					triangle { <-28.4681, 169.462, -54.8652>, <-29.2333, 169.2812, -54.7247>, <-29.6947, 168.1746, -54.8999> }
					triangle { <-29.2333, 169.2812, -54.7247>, <-30.1289, 168.4945, -54.8063>, <-29.6947, 168.1746, -54.8999> }
					triangle { <-30.1289, 168.4945, -54.8063>, <-30.7071, 167.8248, -54.9832>, <-29.6947, 168.1746, -54.8999> }
					triangle { <-30.7071, 167.8248, -54.9832>, <-31.2573, 165.9398, -54.943>, <-29.6947, 168.1746, -54.8999> }
					triangle { <-30.7071, 167.8248, -54.9832>, <-31.7174, 166.3806, -55.3828>, <-31.2573, 165.9398, -54.943> }
					triangle { <-31.7174, 166.3806, -55.3828>, <-32.04016, 165.7989, -54.02574>, <-31.2573, 165.9398, -54.943> }
					triangle { <-32.04016, 165.7989, -54.02574>, <-31.5696, 165.3778, -54.03765>, <-31.2573, 165.9398, -54.943> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-28.4681, 169.462, -54.8652>, <-28.1102, 169.0358, -54.3868> }
					triangle { <-28.4681, 169.462, -54.8652>, <-29.6947, 168.1746, -54.8999>, <-28.1102, 169.0358, -54.3868> }
					triangle { <-29.6947, 168.1746, -54.8999>, <-29.1088, 167.7489, -54.4476>, <-28.1102, 169.0358, -54.3868> }
					triangle { <-29.6947, 168.1746, -54.8999>, <-31.2573, 165.9398, -54.943>, <-29.1088, 167.7489, -54.4476> }
					triangle { <-29.1088, 167.7489, -54.4476>, <-31.2573, 165.9398, -54.943>, <-30.7425, 165.5693, -54.49> }
					triangle { <-31.2573, 165.9398, -54.943>, <-31.5696, 165.3778, -54.03765>, <-30.7425, 165.5693, -54.49> }
					triangle { <-31.5696, 165.3778, -54.03765>, <-31.1269, 165.0656, -53.902>, <-30.7425, 165.5693, -54.49> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-28.4335, 170.3111, -54.6214>, <-29.09458, 170.1276, -55.2004> }
					triangle { <-27.6147, 168.8002, -54.8742>, <-26.8187, 168.3628, -55.2245>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-27.5976, 168.0128, -54.7421>, <-28.1376, 166.9503, -54.8275>, <-26.9292, 167.5665, -55.7413> }
					triangle { <-27.6147, 168.8002, -54.8742>, <-27.5976, 168.0128, -54.7421>, <-26.8187, 168.3628, -55.2245> }
					triangle { <-27.5976, 168.0128, -54.7421>, <-26.9292, 167.5665, -55.7413>, <-26.8187, 168.3628, -55.2245> }
					triangle { <-28.1376, 166.9503, -54.8275>, <-27.6714, 166.6155, -56.1941>, <-26.9292, 167.5665, -55.7413> }
					triangle { <-28.6446, 166.2255, -55.00507>, <-28.4446, 165.6943, -56.3728>, <-27.6714, 166.6155, -56.1941> }
					triangle { <-28.1376, 166.9503, -54.8275>, <-28.6446, 166.2255, -55.00507>, <-27.6714, 166.6155, -56.1941> }
					triangle { <-29.7972, 164.8915, -55.4032>, <-29.2875, 164.681, -56.3868>, <-28.4446, 165.6943, -56.3728> }
					triangle { <-28.6446, 166.2255, -55.00507>, <-29.7972, 164.8915, -55.4032>, <-28.4446, 165.6943, -56.3728> }
					triangle { <-29.9777, 164.1996, -54.0476>, <-29.3953, 164.1422, -54.0053>, <-29.2875, 164.681, -56.3868> }
					triangle { <-29.7972, 164.8915, -55.4032>, <-29.9777, 164.1996, -54.0476>, <-29.2875, 164.681, -56.3868> }
					triangle { <-30.4112, 164.4459, -53.872>, <-29.9777, 164.1996, -54.0476>, <-29.7972, 164.8915, -55.4032> }
					triangle { <-28.5568, 167.2922, -54.9119>, <-27.5976, 168.0128, -54.7421>, <-27.6147, 168.8002, -54.8742> }
					triangle { <-28.5568, 167.2922, -54.9119>, <-28.1376, 166.9503, -54.8275>, <-27.5976, 168.0128, -54.7421> }
					triangle { <-28.5568, 167.2922, -54.9119>, <-28.6446, 166.2255, -55.00507>, <-28.1376, 166.9503, -54.8275> }
					triangle { <-28.5568, 167.2922, -54.9119>, <-30.3327, 165.2229, -54.9528>, <-28.6446, 166.2255, -55.00507> }
					triangle { <-30.3327, 165.2229, -54.9528>, <-29.7972, 164.8915, -55.4032>, <-28.6446, 166.2255, -55.00507> }
					triangle { <-30.3327, 165.2229, -54.9528>, <-30.4112, 164.4459, -53.872>, <-29.7972, 164.8915, -55.4032> }
					triangle { <-30.3327, 165.2229, -54.9528>, <-30.8024, 164.7492, -53.8679>, <-30.4112, 164.4459, -53.872> }
					triangle { <-28.1102, 169.0358, -54.3868>, <-27.6147, 168.8002, -54.8742>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-28.1102, 169.0358, -54.3868>, <-28.5568, 167.2922, -54.9119>, <-27.6147, 168.8002, -54.8742> }
					triangle { <-28.1102, 169.0358, -54.3868>, <-29.1088, 167.7489, -54.4476>, <-28.5568, 167.2922, -54.9119> }
					triangle { <-29.1088, 167.7489, -54.4476>, <-30.3327, 165.2229, -54.9528>, <-28.5568, 167.2922, -54.9119> }
					triangle { <-30.7425, 165.5693, -54.49>, <-30.3327, 165.2229, -54.9528>, <-29.1088, 167.7489, -54.4476> }
					triangle { <-30.7425, 165.5693, -54.49>, <-30.8024, 164.7492, -53.8679>, <-30.3327, 165.2229, -54.9528> }
					triangle { <-30.7425, 165.5693, -54.49>, <-31.1269, 165.0656, -53.902>, <-30.8024, 164.7492, -53.8679> }
					triangle { <-26.8187, 168.3628, -55.2245>, <-26.7978, 169.0427, -54.6387>, <-27.4103, 169.9479, -55.07985> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-27.4103, 169.9479, -55.07985>, <-27.836, 169.4203, -56.6367>, <-28.2505, 169.4612, -55.7568> }
					triangle { <-27.9464, 168.624, -57.1534>, <-29.5045, 168.3713, -56.725>, <-28.7419, 169.2024, -56.3308> }
					triangle { <-27.836, 169.4203, -56.6367>, <-28.7419, 169.2024, -56.3308>, <-28.2505, 169.4612, -55.7568> }
					triangle { <-27.836, 169.4203, -56.6367>, <-27.9464, 168.624, -57.1534>, <-28.7419, 169.2024, -56.3308> }
					triangle { <-27.9464, 168.624, -57.1534>, <-28.498, 167.4747, -57.3415>, <-29.5045, 168.3713, -56.725> }
					triangle { <-28.498, 167.4747, -57.3415>, <-29.2393, 166.5205, -57.4761>, <-30.01157, 167.6465, -56.9026> }
					triangle { <-28.498, 167.4747, -57.3415>, <-30.01157, 167.6465, -56.9026>, <-29.5045, 168.3713, -56.725> }
					triangle { <-29.2393, 166.5205, -57.4761>, <-30.1776, 165.6063, -57.6225>, <-31.00517, 166.1473, -57.08014> }
					triangle { <-29.2393, 166.5205, -57.4761>, <-31.00517, 166.1473, -57.08014>, <-30.01157, 167.6465, -56.9026> }
					triangle { <-30.1776, 165.6063, -57.6225>, <-32.2607, 167.1846, -58.01448>, <-32.3201, 166.8087, -57.6107> }
					triangle { <-30.1776, 165.6063, -57.6225>, <-32.3201, 166.8087, -57.6107>, <-31.00517, 166.1473, -57.08014> }
					triangle { <-31.00517, 166.1473, -57.08014>, <-32.3201, 166.8087, -57.6107>, <-32.4238, 166.6673, -57.04541> }
					triangle { <-28.2505, 169.4612, -55.7568>, <-28.7419, 169.2024, -56.3308>, <-29.4786, 168.2505, -56.1917> }
					triangle { <-28.7419, 169.2024, -56.3308>, <-29.5045, 168.3713, -56.725>, <-29.4786, 168.2505, -56.1917> }
					triangle { <-29.5045, 168.3713, -56.725>, <-30.01157, 167.6465, -56.9026>, <-29.4786, 168.2505, -56.1917> }
					triangle { <-30.01157, 167.6465, -56.9026>, <-31.4135, 166.3464, -56.4532>, <-29.4786, 168.2505, -56.1917> }
					triangle { <-30.01157, 167.6465, -56.9026>, <-31.00517, 166.1473, -57.08014>, <-31.4135, 166.3464, -56.4532> }
					triangle { <-31.00517, 166.1473, -57.08014>, <-32.4238, 166.6673, -57.04541>, <-31.4135, 166.3464, -56.4532> }
					triangle { <-32.4238, 166.6673, -57.04541>, <-32.5039, 166.5556, -56.4289>, <-31.4135, 166.3464, -56.4532> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-28.2505, 169.4612, -55.7568>, <-28.7142, 169.6637, -55.2252> }
					triangle { <-28.2505, 169.4612, -55.7568>, <-29.4786, 168.2505, -56.1917>, <-28.7142, 169.6637, -55.2252> }
					triangle { <-29.4786, 168.2505, -56.1917>, <-29.8399, 168.509, -55.4626>, <-28.7142, 169.6637, -55.2252> }
					triangle { <-29.4786, 168.2505, -56.1917>, <-31.4135, 166.3464, -56.4532>, <-29.8399, 168.509, -55.4626> }
					triangle { <-29.8399, 168.509, -55.4626>, <-31.4135, 166.3464, -56.4532>, <-31.7673, 166.6158, -55.8131> }
					triangle { <-31.4135, 166.3464, -56.4532>, <-32.5039, 166.5556, -56.4289>, <-31.7673, 166.6158, -55.8131> }
					triangle { <-32.5039, 166.5556, -56.4289>, <-32.6285, 166.6078, -55.8871>, <-31.7673, 166.6158, -55.8131> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-27.8786, 170.1663, -56.1391>, <-27.836, 169.4203, -56.6367> }
					triangle { <-28.341, 169.3298, -54.6887>, <-28.07735, 169.0701, -53.7883>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-28.9154, 168.9507, -54.2834>, <-29.7157, 168.0649, -54.2327>, <-28.2556, 168.1753, -53.5039> }
					triangle { <-28.341, 169.3298, -54.6887>, <-28.9154, 168.9507, -54.2834>, <-28.07735, 169.0701, -53.7883> }
					triangle { <-28.9154, 168.9507, -54.2834>, <-28.2556, 168.1753, -53.5039>, <-28.07735, 169.0701, -53.7883> }
					triangle { <-29.7157, 168.0649, -54.2327>, <-28.8072, 167.026, -53.6919>, <-28.2556, 168.1753, -53.5039> }
					triangle { <-30.2302, 167.3291, -54.3212>, <-29.541, 166.0827, -53.9155>, <-28.8072, 167.026, -53.6919> }
					triangle { <-29.7157, 168.0649, -54.2327>, <-30.2302, 167.3291, -54.3212>, <-28.8072, 167.026, -53.6919> }
					triangle { <-31.2088, 165.8518, -54.6767>, <-30.4717, 165.1795, -54.1509>, <-29.541, 166.0827, -53.9155> }
					triangle { <-30.2302, 167.3291, -54.3212>, <-31.2088, 165.8518, -54.6767>, <-29.541, 166.0827, -53.9155> }
					triangle { <-32.6425, 166.35, -54.464>, <-32.4927, 166.5358, -53.928>, <-30.4717, 165.1795, -54.1509> }
					triangle { <-31.2088, 165.8518, -54.6767>, <-32.6425, 166.35, -54.464>, <-30.4717, 165.1795, -54.1509> }
					triangle { <-32.7706, 166.4854, -54.9587>, <-32.6425, 166.35, -54.464>, <-31.2088, 165.8518, -54.6767> }
					triangle { <-29.5993, 168.0754, -54.7675>, <-28.9154, 168.9507, -54.2834>, <-28.341, 169.3298, -54.6887> }
					triangle { <-29.5993, 168.0754, -54.7675>, <-29.7157, 168.0649, -54.2327>, <-28.9154, 168.9507, -54.2834> }
					triangle { <-29.5993, 168.0754, -54.7675>, <-30.2302, 167.3291, -54.3212>, <-29.7157, 168.0649, -54.2327> }
					triangle { <-29.5993, 168.0754, -54.7675>, <-31.5116, 166.2042, -55.2961>, <-30.2302, 167.3291, -54.3212> }
					triangle { <-31.5116, 166.2042, -55.2961>, <-31.2088, 165.8518, -54.6767>, <-30.2302, 167.3291, -54.3212> }
					triangle { <-31.5116, 166.2042, -55.2961>, <-32.7706, 166.4854, -54.9587>, <-31.2088, 165.8518, -54.6767> }
					triangle { <-31.5116, 166.2042, -55.2961>, <-32.7291, 166.5455, -55.4482>, <-32.7706, 166.4854, -54.9587> }
					triangle { <-28.7142, 169.6637, -55.2252>, <-28.341, 169.3298, -54.6887>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-28.7142, 169.6637, -55.2252>, <-29.5993, 168.0754, -54.7675>, <-28.341, 169.3298, -54.6887> }
					triangle { <-28.7142, 169.6637, -55.2252>, <-29.8399, 168.509, -55.4626>, <-29.5993, 168.0754, -54.7675> }
					triangle { <-29.8399, 168.509, -55.4626>, <-31.5116, 166.2042, -55.2961>, <-29.5993, 168.0754, -54.7675> }
					triangle { <-31.7673, 166.6158, -55.8131>, <-31.5116, 166.2042, -55.2961>, <-29.8399, 168.509, -55.4626> }
					triangle { <-31.7673, 166.6158, -55.8131>, <-32.7291, 166.5455, -55.4482>, <-31.5116, 166.2042, -55.2961> }
					triangle { <-31.7673, 166.6158, -55.8131>, <-32.6285, 166.6078, -55.8871>, <-32.7291, 166.5455, -55.4482> }
					triangle { <-28.07735, 169.0701, -53.7883>, <-28.05211, 169.9146, -54.09185>, <-27.4103, 169.9479, -55.07985> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-27.4103, 169.9479, -55.07985>, <-26.8187, 168.3628, -55.2245>, <-27.5544, 168.8878, -55.5863> }
					triangle { <-26.997, 167.468, -54.9402>, <-28.0245, 167.1145, -56.1626>, <-27.4995, 168.155, -55.8993> }
					triangle { <-26.8187, 168.3628, -55.2245>, <-27.4995, 168.155, -55.8993>, <-27.5544, 168.8878, -55.5863> }
					triangle { <-26.8187, 168.3628, -55.2245>, <-26.997, 167.468, -54.9402>, <-27.4995, 168.155, -55.8993> }
					triangle { <-26.997, 167.468, -54.9402>, <-27.7846, 166.4513, -54.8589>, <-28.0245, 167.1145, -56.1626> }
					triangle { <-27.7846, 166.4513, -54.8589>, <-28.5577, 165.5302, -55.03768>, <-28.539, 166.3787, -56.2512> }
					triangle { <-27.7846, 166.4513, -54.8589>, <-28.539, 166.3787, -56.2512>, <-28.0245, 167.1145, -56.1626> }
					triangle { <-28.5577, 165.5302, -55.03768>, <-29.3704, 164.5606, -55.4077>, <-29.7142, 165.0119, -56.3823> }
					triangle { <-28.5577, 165.5302, -55.03768>, <-29.7142, 165.0119, -56.3823>, <-28.539, 166.3787, -56.2512> }
					triangle { <-29.3704, 164.5606, -55.4077>, <-28.8863, 164.5595, -58.00578>, <-29.4209, 164.6025, -57.8637> }
					triangle { <-29.3704, 164.5606, -55.4077>, <-29.4209, 164.6025, -57.8637>, <-29.7142, 165.0119, -56.3823> }
					triangle { <-29.7142, 165.0119, -56.3823>, <-29.4209, 164.6025, -57.8637>, <-29.9378, 164.8907, -57.8721> }
					triangle { <-27.5544, 168.8878, -55.5863>, <-27.4995, 168.155, -55.8993>, <-28.4587, 167.4344, -56.06916> }
					triangle { <-27.4995, 168.155, -55.8993>, <-28.0245, 167.1145, -56.1626>, <-28.4587, 167.4344, -56.06916> }
					triangle { <-28.0245, 167.1145, -56.1626>, <-28.539, 166.3787, -56.2512>, <-28.4587, 167.4344, -56.06916> }
					triangle { <-28.539, 166.3787, -56.2512>, <-30.1743, 165.4527, -56.8221>, <-28.4587, 167.4344, -56.06916> }
					triangle { <-28.539, 166.3787, -56.2512>, <-29.7142, 165.0119, -56.3823>, <-30.1743, 165.4527, -56.8221> }
					triangle { <-29.7142, 165.0119, -56.3823>, <-29.9378, 164.8907, -57.8721>, <-30.1743, 165.4527, -56.8221> }
					triangle { <-29.9378, 164.8907, -57.8721>, <-30.463, 165.2417, -57.8735>, <-30.1743, 165.4527, -56.8221> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-27.5544, 168.8878, -55.5863>, <-27.9669, 169.2437, -56.07806> }
					triangle { <-27.5544, 168.8878, -55.5863>, <-28.4587, 167.4344, -56.06916>, <-27.9669, 169.2437, -56.07806> }
					triangle { <-28.4587, 167.4344, -56.06916>, <-28.9353, 168.0006, -56.4949>, <-27.9669, 169.2437, -56.07806> }
					triangle { <-28.4587, 167.4344, -56.06916>, <-30.1743, 165.4527, -56.8221>, <-28.9353, 168.0006, -56.4949> }
					triangle { <-28.9353, 168.0006, -56.4949>, <-30.1743, 165.4527, -56.8221>, <-30.5798, 165.9637, -57.2486> }
					triangle { <-30.1743, 165.4527, -56.8221>, <-30.463, 165.2417, -57.8735>, <-30.5798, 165.9637, -57.2486> }
					triangle { <-30.463, 165.2417, -57.8735>, <-30.8511, 165.6241, -57.9958>, <-30.5798, 165.9637, -57.2486> }
					triangle { <-27.4103, 169.9479, -55.07985>, <-26.7148, 169.1631, -55.6178>, <-26.8187, 168.3628, -55.2245> }
					triangle { <-28.4078, 169.5496, -55.5773>, <-29.09458, 170.1276, -55.2004>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-29.1353, 169.4234, -55.8819>, <-30.01583, 168.6587, -56.1415>, <-29.9129, 169.7292, -54.9093> }
					triangle { <-28.4078, 169.5496, -55.5773>, <-29.1353, 169.4234, -55.8819>, <-29.09458, 170.1276, -55.2004> }
					triangle { <-29.1353, 169.4234, -55.8819>, <-29.9129, 169.7292, -54.9093>, <-29.09458, 170.1276, -55.2004> }
					triangle { <-30.01583, 168.6587, -56.1415>, <-30.7005, 168.7125, -54.828>, <-29.9129, 169.7292, -54.9093> }
					triangle { <-30.6015, 167.978, -56.2293>, <-31.4025, 167.7361, -55.00753>, <-30.7005, 168.7125, -54.828> }
					triangle { <-30.01583, 168.6587, -56.1415>, <-30.6015, 167.978, -56.2293>, <-30.7005, 168.7125, -54.828> }
					triangle { <-31.6344, 166.5009, -56.362>, <-32.1441, 166.7115, -55.3783>, <-31.4025, 167.7361, -55.00753> }
					triangle { <-30.6015, 167.978, -56.2293>, <-31.6344, 166.5009, -56.362>, <-31.4025, 167.7361, -55.00753> }
					triangle { <-32.00033, 166.4901, -57.8503>, <-32.2002, 167.0394, -57.7997>, <-32.1441, 166.7115, -55.3783> }
					triangle { <-31.6344, 166.5009, -56.362>, <-32.00033, 166.4901, -57.8503>, <-32.1441, 166.7115, -55.3783> }
					triangle { <-31.6214, 166.1735, -58.0391>, <-32.00033, 166.4901, -57.8503>, <-31.6344, 166.5009, -56.362> }
					triangle { <-29.5966, 168.3168, -56.0571>, <-29.1353, 169.4234, -55.8819>, <-28.4078, 169.5496, -55.5773> }
					triangle { <-29.5966, 168.3168, -56.0571>, <-30.01583, 168.6587, -56.1415>, <-29.1353, 169.4234, -55.8819> }
					triangle { <-29.5966, 168.3168, -56.0571>, <-30.6015, 167.978, -56.2293>, <-30.01583, 168.6587, -56.1415> }
					triangle { <-29.5966, 168.3168, -56.0571>, <-31.09892, 166.1696, -56.8123>, <-30.6015, 167.978, -56.2293> }
					triangle { <-31.09892, 166.1696, -56.8123>, <-31.6344, 166.5009, -56.362>, <-30.6015, 167.978, -56.2293> }
					triangle { <-31.09892, 166.1696, -56.8123>, <-31.6214, 166.1735, -58.0391>, <-31.6344, 166.5009, -56.362> }
					triangle { <-31.09892, 166.1696, -56.8123>, <-31.2302, 165.8702, -58.04325>, <-31.6214, 166.1735, -58.0391> }
					triangle { <-27.9669, 169.2437, -56.07806>, <-28.4078, 169.5496, -55.5773>, <-27.4103, 169.9479, -55.07985> }
					triangle { <-27.9669, 169.2437, -56.07806>, <-29.5966, 168.3168, -56.0571>, <-28.4078, 169.5496, -55.5773> }
					triangle { <-27.9669, 169.2437, -56.07806>, <-28.9353, 168.0006, -56.4949>, <-29.5966, 168.3168, -56.0571> }
					triangle { <-28.9353, 168.0006, -56.4949>, <-31.09892, 166.1696, -56.8123>, <-29.5966, 168.3168, -56.0571> }
					triangle { <-30.5798, 165.9637, -57.2486>, <-31.09892, 166.1696, -56.8123>, <-28.9353, 168.0006, -56.4949> }
					triangle { <-30.5798, 165.9637, -57.2486>, <-31.2302, 165.8702, -58.04325>, <-31.09892, 166.1696, -56.8123> }
					triangle { <-30.5798, 165.9637, -57.2486>, <-30.8511, 165.6241, -57.9958>, <-31.2302, 165.8702, -58.04325> }
					triangle { <-29.09458, 170.1276, -55.2004>, <-28.3506, 170.4315, -55.6005>, <-27.4103, 169.9479, -55.07985> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-26.442, 170.1367, -54.3005>, <-26.5827, 171.0658, -54.6426>, 0.55 }
			cylinder { <-26.5827, 171.0658, -54.6426>, <-26.7506, 171.9834, -55.00296>, 0.55 }
			cylinder { <-26.7506, 171.9834, -55.00296>, <-26.9456, 172.8884, -55.381>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-26.9456, 172.8884, -55.381>, <-26.979, 173.3633, -55.2283>, 0.55 }
				cylinder { <-26.979, 173.3633, -55.2283>, <-26.932, 173.6301, -54.808>, 0.55 }
				cylinder { <-26.932, 173.6301, -54.808>, <-26.8275, 173.5591, -54.3242>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-26.8275, 173.5591, -54.3242>, <-25.7017, 172.5193, -53.5929>, <-26.5822, 172.8796, -53.3865> }
					triangle { <-25.04737, 172.4943, -52.8968>, <-26.09225, 172.0719, -51.7116>, <-26.3204, 172.3474, -52.8516> }
					triangle { <-25.7017, 172.5193, -53.5929>, <-26.3204, 172.3474, -52.8516>, <-26.5822, 172.8796, -53.3865> }
					triangle { <-25.7017, 172.5193, -53.5929>, <-25.04737, 172.4943, -52.8968>, <-26.3204, 172.3474, -52.8516> }
					triangle { <-25.04737, 172.4943, -52.8968>, <-24.7199, 172.6297, -51.6579>, <-26.09225, 172.0719, -51.7116> }
					triangle { <-24.7199, 172.6297, -51.6579>, <-24.6167, 172.604, -50.4467>, <-25.9287, 172.031, -50.8252> }
					triangle { <-24.7199, 172.6297, -51.6579>, <-25.9287, 172.031, -50.8252>, <-26.09225, 172.0719, -51.7116> }
					triangle { <-24.6167, 172.604, -50.4467>, <-24.6281, 172.4445, -49.1383>, <-25.6989, 172.1063, -49.03421> }
					triangle { <-24.6167, 172.604, -50.4467>, <-25.6989, 172.1063, -49.03421>, <-25.9287, 172.031, -50.8252> }
					triangle { <-24.6281, 172.4445, -49.1383>, <-26.1385, 170.2816, -48.9802>, <-26.3042, 170.7103, -48.6694> }
					triangle { <-24.6281, 172.4445, -49.1383>, <-26.3042, 170.7103, -48.6694>, <-25.6989, 172.1063, -49.03421> }
					triangle { <-25.6989, 172.1063, -49.03421>, <-26.3042, 170.7103, -48.6694>, <-26.7108, 171.1114, -48.5142> }
					triangle { <-26.5822, 172.8796, -53.3865>, <-26.3204, 172.3474, -52.8516>, <-26.4145, 172.5108, -51.6547> }
					triangle { <-26.3204, 172.3474, -52.8516>, <-26.09225, 172.0719, -51.7116>, <-26.4145, 172.5108, -51.6547> }
					triangle { <-26.09225, 172.0719, -51.7116>, <-25.9287, 172.031, -50.8252>, <-26.4145, 172.5108, -51.6547> }
					triangle { <-25.9287, 172.031, -50.8252>, <-26.4594, 172.2189, -48.9435>, <-26.4145, 172.5108, -51.6547> }
					triangle { <-25.9287, 172.031, -50.8252>, <-25.6989, 172.1063, -49.03421>, <-26.4594, 172.2189, -48.9435> }
					triangle { <-25.6989, 172.1063, -49.03421>, <-26.7108, 171.1114, -48.5142>, <-26.4594, 172.2189, -48.9435> }
					triangle { <-26.7108, 171.1114, -48.5142>, <-27.1545, 171.5457, -48.3987>, <-26.4594, 172.2189, -48.9435> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-26.5822, 172.8796, -53.3865>, <-27.3048, 172.8954, -53.2593> }
					triangle { <-26.5822, 172.8796, -53.3865>, <-26.4145, 172.5108, -51.6547>, <-27.3048, 172.8954, -53.2593> }
					triangle { <-26.4145, 172.5108, -51.6547>, <-27.2492, 172.6901, -51.6433>, <-27.3048, 172.8954, -53.2593> }
					triangle { <-26.4145, 172.5108, -51.6547>, <-26.4594, 172.2189, -48.9435>, <-27.2492, 172.6901, -51.6433> }
					triangle { <-27.2492, 172.6901, -51.6433>, <-26.4594, 172.2189, -48.9435>, <-27.23, 172.3358, -48.9422> }
					triangle { <-26.4594, 172.2189, -48.9435>, <-27.1545, 171.5457, -48.3987>, <-27.23, 172.3358, -48.9422> }
					triangle { <-27.1545, 171.5457, -48.3987>, <-27.6377, 171.8248, -48.3766>, <-27.23, 172.3358, -48.9422> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-26.4033, 172.4732, -54.151>, <-25.7017, 172.5193, -53.5929> }
					triangle { <-27.3514, 173.6279, -53.2649>, <-27.753, 174.5147, -53.2687>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-27.7947, 173.7815, -52.6186>, <-27.8871, 173.8179, -51.4279>, <-27.6756, 175.0509, -52.4815> }
					triangle { <-27.3514, 173.6279, -53.2649>, <-27.7947, 173.7815, -52.6186>, <-27.753, 174.5147, -53.2687> }
					triangle { <-27.7947, 173.7815, -52.6186>, <-27.6756, 175.0509, -52.4815>, <-27.753, 174.5147, -53.2687> }
					triangle { <-27.8871, 173.8179, -51.4279>, <-27.3481, 175.1862, -51.2425>, <-27.6756, 175.0509, -52.4815> }
					triangle { <-27.7877, 173.8393, -50.5314>, <-27.1808, 175.0981, -50.04152>, <-27.3481, 175.1862, -51.2425> }
					triangle { <-27.8871, 173.8179, -51.4279>, <-27.7877, 173.8393, -50.5314>, <-27.3481, 175.1862, -51.2425> }
					triangle { <-27.4296, 173.7899, -48.7606>, <-27.1282, 174.8764, -48.7432>, <-27.1808, 175.0981, -50.04152> }
					triangle { <-27.7877, 173.8393, -50.5314>, <-27.4296, 173.7899, -48.7606>, <-27.1808, 175.0981, -50.04152> }
					triangle { <-28.5698, 172.9197, -48.2204>, <-28.9574, 173.2774, -48.4774>, <-27.1282, 174.8764, -48.7432> }
					triangle { <-27.4296, 173.7899, -48.7606>, <-28.5698, 172.9197, -48.2204>, <-27.1282, 174.8764, -48.7432> }
					triangle { <-28.337, 172.4451, -48.2236>, <-28.5698, 172.9197, -48.2204>, <-27.4296, 173.7899, -48.7606> }
					triangle { <-27.4401, 173.5085, -51.4926>, <-27.7947, 173.7815, -52.6186>, <-27.3514, 173.6279, -53.2649> }
					triangle { <-27.4401, 173.5085, -51.4926>, <-27.8871, 173.8179, -51.4279>, <-27.7947, 173.7815, -52.6186> }
					triangle { <-27.4401, 173.5085, -51.4926>, <-27.7877, 173.8393, -50.5314>, <-27.8871, 173.8179, -51.4279> }
					triangle { <-27.4401, 173.5085, -51.4926>, <-27.2928, 173.0296, -48.8118>, <-27.7877, 173.8393, -50.5314> }
					triangle { <-27.2928, 173.0296, -48.8118>, <-27.4296, 173.7899, -48.7606>, <-27.7877, 173.8393, -50.5314> }
					triangle { <-27.2928, 173.0296, -48.8118>, <-28.337, 172.4451, -48.2236>, <-27.4296, 173.7899, -48.7606> }
					triangle { <-27.2928, 173.0296, -48.8118>, <-27.9844, 172.1021, -48.2793>, <-28.337, 172.4451, -48.2236> }
					triangle { <-27.3048, 172.8954, -53.2593>, <-27.3514, 173.6279, -53.2649>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-27.3048, 172.8954, -53.2593>, <-27.4401, 173.5085, -51.4926>, <-27.3514, 173.6279, -53.2649> }
					triangle { <-27.3048, 172.8954, -53.2593>, <-27.2492, 172.6901, -51.6433>, <-27.4401, 173.5085, -51.4926> }
					triangle { <-27.2492, 172.6901, -51.6433>, <-27.2928, 173.0296, -48.8118>, <-27.4401, 173.5085, -51.4926> }
					triangle { <-27.23, 172.3358, -48.9422>, <-27.2928, 173.0296, -48.8118>, <-27.2492, 172.6901, -51.6433> }
					triangle { <-27.23, 172.3358, -48.9422>, <-27.9844, 172.1021, -48.2793>, <-27.2928, 173.0296, -48.8118> }
					triangle { <-27.23, 172.3358, -48.9422>, <-27.6377, 171.8248, -48.3766>, <-27.9844, 172.1021, -48.2793> }
					triangle { <-27.753, 174.5147, -53.2687>, <-27.8777, 173.9074, -53.918>, <-26.8275, 173.5591, -54.3242> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-26.8275, 173.5591, -54.3242>, <-25.7293, 174.5532, -53.4939>, <-26.08668, 173.6519, -53.4056> }
					triangle { <-25.6519, 175.0894, -52.7066>, <-25.1679, 173.8696, -51.7305>, <-25.5182, 173.8249, -52.8719> }
					triangle { <-25.7293, 174.5532, -53.4939>, <-25.5182, 173.8249, -52.8719>, <-26.08668, 173.6519, -53.4056> }
					triangle { <-25.7293, 174.5532, -53.4939>, <-25.6519, 175.0894, -52.7066>, <-25.5182, 173.8249, -52.8719> }
					triangle { <-25.6519, 175.0894, -52.7066>, <-25.7039, 175.2175, -51.4255>, <-25.1679, 173.8696, -51.7305> }
					triangle { <-25.7039, 175.2175, -51.4255>, <-25.5998, 175.1282, -50.2174>, <-25.06856, 173.8911, -50.834> }
					triangle { <-25.7039, 175.2175, -51.4255>, <-25.06856, 173.8911, -50.834>, <-25.1679, 173.8696, -51.7305> }
					triangle { <-25.5998, 175.1282, -50.2174>, <-25.3575, 174.9101, -48.9402>, <-25.02665, 173.8356, -49.02808> }
					triangle { <-25.5998, 175.1282, -50.2174>, <-25.02665, 173.8356, -49.02808>, <-25.06856, 173.8911, -50.834> }
					triangle { <-25.3575, 174.9101, -48.9402>, <-23.2078, 173.389, -49.1625>, <-23.6178, 173.1772, -48.8545> }
					triangle { <-25.3575, 174.9101, -48.9402>, <-23.6178, 173.1772, -48.8545>, <-25.02665, 173.8356, -49.02808> }
					triangle { <-25.02665, 173.8356, -49.02808>, <-23.6178, 173.1772, -48.8545>, <-24.01326, 172.7521, -48.7395> }
					triangle { <-26.08668, 173.6519, -53.4056>, <-25.5182, 173.8249, -52.8719>, <-25.6062, 173.5434, -51.6967> }
					triangle { <-25.5182, 173.8249, -52.8719>, <-25.1679, 173.8696, -51.7305>, <-25.6062, 173.5434, -51.6967> }
					triangle { <-25.1679, 173.8696, -51.7305>, <-25.06856, 173.8911, -50.834>, <-25.6062, 173.5434, -51.6967> }
					triangle { <-25.06856, 173.8911, -50.834>, <-25.1427, 173.0705, -49.05113>, <-25.6062, 173.5434, -51.6967> }
					triangle { <-25.06856, 173.8911, -50.834>, <-25.02665, 173.8356, -49.02808>, <-25.1427, 173.0705, -49.05113> }
					triangle { <-25.02665, 173.8356, -49.02808>, <-24.01326, 172.7521, -48.7395>, <-25.1427, 173.0705, -49.05113> }
					triangle { <-24.01326, 172.7521, -48.7395>, <-24.4448, 172.2966, -48.6672>, <-25.1427, 173.0705, -49.05113> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-26.08668, 173.6519, -53.4056>, <-26.1033, 172.9183, -53.393> }
					triangle { <-26.08668, 173.6519, -53.4056>, <-25.6062, 173.5434, -51.6967>, <-26.1033, 172.9183, -53.393> }
					triangle { <-25.6062, 173.5434, -51.6967>, <-25.7947, 172.7178, -51.8052>, <-26.1033, 172.9183, -53.393> }
					triangle { <-25.6062, 173.5434, -51.6967>, <-25.1427, 173.0705, -49.05113>, <-25.7947, 172.7178, -51.8052> }
					triangle { <-25.7947, 172.7178, -51.8052>, <-25.1427, 173.0705, -49.05113>, <-25.2688, 172.3096, -49.1635> }
					triangle { <-25.1427, 173.0705, -49.05113>, <-24.4448, 172.2966, -48.6672>, <-25.2688, 172.3096, -49.1635> }
					triangle { <-24.4448, 172.2966, -48.6672>, <-24.7279, 171.8166, -48.7034>, <-25.2688, 172.3096, -49.1635> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-25.7276, 173.9483, -54.1573>, <-25.7293, 174.5532, -53.4939> }
					triangle { <-26.8351, 172.8748, -53.3583>, <-27.7253, 172.4808, -53.3677>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-26.9528, 172.3353, -52.7813>, <-26.9143, 172.0563, -51.6201>, <-28.2092, 172.4342, -52.545> }
					triangle { <-26.8351, 172.8748, -53.3583>, <-26.9528, 172.3353, -52.7813>, <-27.7253, 172.4808, -53.3677> }
					triangle { <-26.9528, 172.3353, -52.7813>, <-28.2092, 172.4342, -52.545>, <-27.7253, 172.4808, -53.3677> }
					triangle { <-26.9143, 172.0563, -51.6201>, <-28.2612, 172.5623, -51.2638>, <-28.2092, 172.4342, -52.545> }
					triangle { <-26.8773, 172.013, -50.7196>, <-28.09479, 172.5378, -50.05973>, <-28.2612, 172.5623, -51.2638> }
					triangle { <-26.9143, 172.0563, -51.6201>, <-26.8773, 172.013, -50.7196>, <-28.2612, 172.5623, -51.2638> }
					triangle { <-26.7107, 172.087, -48.9216>, <-27.79, 172.3843, -48.7865>, <-28.09479, 172.5378, -50.05973> }
					triangle { <-26.8773, 172.013, -50.7196>, <-26.7107, 172.087, -48.9216>, <-28.09479, 172.5378, -50.05973> }
					triangle { <-25.822, 170.874, -48.6251>, <-26.2001, 170.5325, -48.9161>, <-27.79, 172.3843, -48.7865> }
					triangle { <-26.7107, 172.087, -48.9216>, <-25.822, 170.874, -48.6251>, <-27.79, 172.3843, -48.7865> }
					triangle { <-25.3458, 171.1034, -48.6224>, <-25.822, 170.874, -48.6251>, <-26.7107, 172.087, -48.9216> }
					triangle { <-26.6042, 172.5072, -51.6336>, <-26.9528, 172.3353, -52.7813>, <-26.8351, 172.8748, -53.3583> }
					triangle { <-26.6042, 172.5072, -51.6336>, <-26.9143, 172.0563, -51.6201>, <-26.9528, 172.3353, -52.7813> }
					triangle { <-26.6042, 172.5072, -51.6336>, <-26.8773, 172.013, -50.7196>, <-26.9143, 172.0563, -51.6201> }
					triangle { <-26.6042, 172.5072, -51.6336>, <-25.9535, 172.2286, -48.9998>, <-26.8773, 172.013, -50.7196> }
					triangle { <-25.9535, 172.2286, -48.9998>, <-26.7107, 172.087, -48.9216>, <-26.8773, 172.013, -50.7196> }
					triangle { <-25.9535, 172.2286, -48.9998>, <-25.3458, 171.1034, -48.6224>, <-26.7107, 172.087, -48.9216> }
					triangle { <-25.9535, 172.2286, -48.9998>, <-25.00275, 171.4595, -48.6441>, <-25.3458, 171.1034, -48.6224> }
					triangle { <-26.1033, 172.9183, -53.393>, <-26.8351, 172.8748, -53.3583>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-26.1033, 172.9183, -53.393>, <-26.6042, 172.5072, -51.6336>, <-26.8351, 172.8748, -53.3583> }
					triangle { <-26.1033, 172.9183, -53.393>, <-25.7947, 172.7178, -51.8052>, <-26.6042, 172.5072, -51.6336> }
					triangle { <-25.7947, 172.7178, -51.8052>, <-25.9535, 172.2286, -48.9998>, <-26.6042, 172.5072, -51.6336> }
					triangle { <-25.2688, 172.3096, -49.1635>, <-25.9535, 172.2286, -48.9998>, <-25.7947, 172.7178, -51.8052> }
					triangle { <-25.2688, 172.3096, -49.1635>, <-25.00275, 171.4595, -48.6441>, <-25.9535, 172.2286, -48.9998> }
					triangle { <-25.2688, 172.3096, -49.1635>, <-24.7279, 171.8166, -48.7034>, <-25.00275, 171.4595, -48.6441> }
					triangle { <-27.7253, 172.4808, -53.3677>, <-27.1622, 172.4588, -54.06661>, <-26.8275, 173.5591, -54.3242> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-26.8275, 173.5591, -54.3242>, <-27.753, 174.5147, -53.2687>, <-26.8524, 174.146, -53.2964> }
					triangle { <-28.2369, 174.468, -52.446>, <-26.9515, 174.7893, -51.487>, <-26.9839, 174.6234, -52.6699> }
					triangle { <-27.753, 174.5147, -53.2687>, <-26.9839, 174.6234, -52.6699>, <-26.8524, 174.146, -53.2964> }
					triangle { <-27.753, 174.5147, -53.2687>, <-28.2369, 174.468, -52.446>, <-26.9839, 174.6234, -52.6699> }
					triangle { <-28.2369, 174.468, -52.446>, <-28.2837, 174.2148, -51.1834>, <-26.9515, 174.7893, -51.487> }
					triangle { <-28.2837, 174.2148, -51.1834>, <-28.1164, 174.1267, -49.9823>, <-26.9145, 174.746, -50.5866> }
					triangle { <-28.2837, 174.2148, -51.1834>, <-26.9145, 174.746, -50.5866>, <-26.9515, 174.7893, -51.487> }
					triangle { <-28.1164, 174.1267, -49.9823>, <-27.8143, 174.164, -48.6998>, <-26.7435, 174.5022, -48.804> }
					triangle { <-28.1164, 174.1267, -49.9823>, <-26.7435, 174.5022, -48.804>, <-26.9145, 174.746, -50.5866> }
					triangle { <-27.8143, 174.164, -48.6998>, <-26.2839, 176.3185, -48.6792>, <-26.05811, 175.8645, -48.454> }
					triangle { <-27.8143, 174.164, -48.6998>, <-26.05811, 175.8645, -48.454>, <-26.7435, 174.5022, -48.804> }
					triangle { <-26.7435, 174.5022, -48.804>, <-26.05811, 175.8645, -48.454>, <-25.6314, 175.455, -48.4305> }
					triangle { <-26.8524, 174.146, -53.2964>, <-26.9839, 174.6234, -52.6699>, <-26.6293, 174.3504, -51.5439> }
					triangle { <-26.9839, 174.6234, -52.6699>, <-26.9515, 174.7893, -51.487>, <-26.6293, 174.3504, -51.5439> }
					triangle { <-26.9515, 174.7893, -51.487>, <-26.9145, 174.746, -50.5866>, <-26.6293, 174.3504, -51.5439> }
					triangle { <-26.9145, 174.746, -50.5866>, <-25.983, 174.3896, -48.8946>, <-26.6293, 174.3504, -51.5439> }
					triangle { <-26.9145, 174.746, -50.5866>, <-26.7435, 174.5022, -48.804>, <-25.983, 174.3896, -48.8946> }
					triangle { <-26.7435, 174.5022, -48.804>, <-25.6314, 175.455, -48.4305>, <-25.983, 174.3896, -48.8946> }
					triangle { <-25.6314, 175.455, -48.4305>, <-25.1776, 175.0164, -48.4568>, <-25.983, 174.3896, -48.8946> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-26.8524, 174.146, -53.2964>, <-26.1197, 174.1259, -53.3342> }
					triangle { <-26.8524, 174.146, -53.2964>, <-26.6293, 174.3504, -51.5439>, <-26.1197, 174.1259, -53.3342> }
					triangle { <-26.6293, 174.3504, -51.5439>, <-25.8146, 174.1796, -51.734>, <-26.1197, 174.1259, -53.3342> }
					triangle { <-26.6293, 174.3504, -51.5439>, <-25.983, 174.3896, -48.8946>, <-25.8146, 174.1796, -51.734> }
					triangle { <-25.8146, 174.1796, -51.734>, <-25.983, 174.3896, -48.8946>, <-25.2324, 174.2811, -49.07465> }
					triangle { <-25.983, 174.3896, -48.8946>, <-25.1776, 175.0164, -48.4568>, <-25.2324, 174.2811, -49.07465> }
					triangle { <-25.1776, 175.0164, -48.4568>, <-24.7045, 174.7415, -48.5681>, <-25.2324, 174.2811, -49.07465> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-27.1916, 174.6198, -53.9614>, <-27.753, 174.5147, -53.2687> }
					triangle { <-26.08322, 173.3977, -53.418>, <-25.7017, 172.5193, -53.5929>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-25.5095, 173.1893, -52.9029>, <-25.1566, 173.0434, -51.7707>, <-25.6087, 171.9115, -52.8613> }
					triangle { <-26.08322, 173.3977, -53.418>, <-25.5095, 173.1893, -52.9029>, <-25.7017, 172.5193, -53.5929> }
					triangle { <-25.5095, 173.1893, -52.9029>, <-25.6087, 171.9115, -52.8613>, <-25.7017, 172.5193, -53.5929> }
					triangle { <-25.1566, 173.0434, -51.7707>, <-25.6555, 171.6582, -51.5987>, <-25.6087, 171.9115, -52.8613> }
					triangle { <-25.05558, 172.9377, -50.8804>, <-25.5522, 171.6325, -50.3876>, <-25.6555, 171.6582, -51.5987> }
					triangle { <-25.1566, 173.0434, -51.7707>, <-25.05558, 172.9377, -50.8804>, <-25.6555, 171.6582, -51.5987> }
					triangle { <-25.0128, 172.8186, -49.07758>, <-25.3142, 171.7321, -49.095>, <-25.5522, 171.6325, -50.3876> }
					triangle { <-25.05558, 172.9377, -50.8804>, <-25.0128, 172.8186, -49.07758>, <-25.5522, 171.6325, -50.3876> }
					triangle { <-23.7724, 173.6467, -48.7243>, <-23.4549, 173.3185, -49.09277>, <-25.3142, 171.7321, -49.095> }
					triangle { <-25.0128, 172.8186, -49.07758>, <-23.7724, 173.6467, -48.7243>, <-25.3142, 171.7321, -49.095> }
					triangle { <-23.9952, 174.1171, -48.6318>, <-23.7724, 173.6467, -48.7243>, <-25.0128, 172.8186, -49.07758> }
					triangle { <-25.6036, 173.3528, -51.706>, <-25.5095, 173.1893, -52.9029>, <-26.08322, 173.3977, -53.418> }
					triangle { <-25.6036, 173.3528, -51.706>, <-25.1566, 173.0434, -51.7707>, <-25.5095, 173.1893, -52.9029> }
					triangle { <-25.6036, 173.3528, -51.706>, <-25.05558, 172.9377, -50.8804>, <-25.1566, 173.0434, -51.7707> }
					triangle { <-25.6036, 173.3528, -51.706>, <-25.1496, 173.5789, -49.02638>, <-25.05558, 172.9377, -50.8804> }
					triangle { <-25.1496, 173.5789, -49.02638>, <-25.0128, 172.8186, -49.07758>, <-25.05558, 172.9377, -50.8804> }
					triangle { <-25.1496, 173.5789, -49.02638>, <-23.9952, 174.1171, -48.6318>, <-25.0128, 172.8186, -49.07758> }
					triangle { <-25.1496, 173.5789, -49.02638>, <-24.3478, 174.46, -48.5761>, <-23.9952, 174.1171, -48.6318> }
					triangle { <-26.1197, 174.1259, -53.3342>, <-26.08322, 173.3977, -53.418>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-26.1197, 174.1259, -53.3342>, <-25.6036, 173.3528, -51.706>, <-26.08322, 173.3977, -53.418> }
					triangle { <-26.1197, 174.1259, -53.3342>, <-25.8146, 174.1796, -51.734>, <-25.6036, 173.3528, -51.706> }
					triangle { <-25.8146, 174.1796, -51.734>, <-25.1496, 173.5789, -49.02638>, <-25.6036, 173.3528, -51.706> }
					triangle { <-25.2324, 174.2811, -49.07465>, <-25.1496, 173.5789, -49.02638>, <-25.8146, 174.1796, -51.734> }
					triangle { <-25.2324, 174.2811, -49.07465>, <-24.3478, 174.46, -48.5761>, <-25.1496, 173.5789, -49.02638> }
					triangle { <-25.2324, 174.2811, -49.07465>, <-24.7045, 174.7415, -48.5681>, <-24.3478, 174.46, -48.5761> }
					triangle { <-25.7017, 172.5193, -53.5929>, <-25.7172, 173.1856, -54.1944>, <-26.8275, 173.5591, -54.3242> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-26.8275, 173.5591, -54.3242>, <-27.7253, 172.4808, -53.3677>, <-27.3479, 173.3736, -53.2773> }
					triangle { <-27.6323, 171.873, -52.6362>, <-27.8758, 172.9916, -51.4681>, <-27.7861, 173.146, -52.6495> }
					triangle { <-27.7253, 172.4808, -53.3677>, <-27.7861, 173.146, -52.6495>, <-27.3479, 173.3736, -53.2773> }
					triangle { <-27.7253, 172.4808, -53.3677>, <-27.6323, 171.873, -52.6362>, <-27.7861, 173.146, -52.6495> }
					triangle { <-27.6323, 171.873, -52.6362>, <-27.2997, 171.6269, -51.4158>, <-27.8758, 172.9916, -51.4681> }
					triangle { <-27.2997, 171.6269, -51.4158>, <-27.1332, 171.6024, -50.2117>, <-27.7748, 172.8859, -50.5778> }
					triangle { <-27.2997, 171.6269, -51.4158>, <-27.7748, 172.8859, -50.5778>, <-27.8758, 172.9916, -51.4681> }
					triangle { <-27.1332, 171.6024, -50.2117>, <-27.08494, 171.6984, -48.8979>, <-27.4158, 172.7729, -48.8101> }
					triangle { <-27.1332, 171.6024, -50.2117>, <-27.4158, 172.7729, -48.8101>, <-27.7748, 172.8859, -50.5778> }
					triangle { <-27.08494, 171.6984, -48.8979>, <-29.2145, 173.2111, -48.497>, <-28.7444, 173.3976, -48.269> }
					triangle { <-27.08494, 171.6984, -48.8979>, <-28.7444, 173.3976, -48.269>, <-27.4158, 172.7729, -48.8101> }
					triangle { <-27.4158, 172.7729, -48.8101>, <-28.7444, 173.3976, -48.269>, <-28.329, 173.8143, -48.2053> }
					triangle { <-27.3479, 173.3736, -53.2773>, <-27.7861, 173.146, -52.6495>, <-27.4375, 173.3178, -51.5019> }
					triangle { <-27.7861, 173.146, -52.6495>, <-27.8758, 172.9916, -51.4681>, <-27.4375, 173.3178, -51.5019> }
					triangle { <-27.8758, 172.9916, -51.4681>, <-27.7748, 172.8859, -50.5778>, <-27.4375, 173.3178, -51.5019> }
					triangle { <-27.7748, 172.8859, -50.5778>, <-27.2997, 173.538, -48.7871>, <-27.4375, 173.3178, -51.5019> }
					triangle { <-27.7748, 172.8859, -50.5778>, <-27.4158, 172.7729, -48.8101>, <-27.2997, 173.538, -48.7871> }
					triangle { <-27.4158, 172.7729, -48.8101>, <-28.329, 173.8143, -48.2053>, <-27.2997, 173.538, -48.7871> }
					triangle { <-28.329, 173.8143, -48.2053>, <-27.8873, 174.2655, -48.1882>, <-27.2997, 173.538, -48.7871> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-27.3479, 173.3736, -53.2773>, <-27.3213, 174.1031, -53.2005> }
					triangle { <-27.3479, 173.3736, -53.2773>, <-27.4375, 173.3178, -51.5019>, <-27.3213, 174.1031, -53.2005> }
					triangle { <-27.4375, 173.3178, -51.5019>, <-27.2691, 174.1519, -51.5721>, <-27.3213, 174.1031, -53.2005> }
					triangle { <-27.4375, 173.3178, -51.5019>, <-27.2997, 173.538, -48.7871>, <-27.2691, 174.1519, -51.5721> }
					triangle { <-27.2691, 174.1519, -51.5721>, <-27.2997, 173.538, -48.7871>, <-27.1936, 174.3073, -48.8534> }
					triangle { <-27.2997, 173.538, -48.7871>, <-27.8873, 174.2655, -48.1882>, <-27.1936, 174.3073, -48.8534> }
					triangle { <-27.8873, 174.2655, -48.1882>, <-27.6143, 174.7497, -48.2413>, <-27.1936, 174.3073, -48.8534> }
					triangle { <-26.8275, 173.5591, -54.3242>, <-27.8673, 173.1447, -53.9551>, <-27.7253, 172.4808, -53.3677> }
					triangle { <-26.5995, 174.1508, -53.3246>, <-25.7293, 174.5532, -53.4939>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-26.3515, 174.6355, -52.7402>, <-26.1294, 174.805, -51.5785>, <-25.07506, 174.5282, -52.7978> }
					triangle { <-26.5995, 174.1508, -53.3246>, <-26.3515, 174.6355, -52.7402>, <-25.7293, 174.5532, -53.4939> }
					triangle { <-26.3515, 174.6355, -52.7402>, <-25.07506, 174.5282, -52.7978>, <-25.7293, 174.5532, -53.4939> }
					triangle { <-26.1294, 174.805, -51.5785>, <-24.7424, 174.2822, -51.5774>, <-25.07506, 174.5282, -52.7978> }
					triangle { <-25.966, 174.764, -50.6922>, <-24.6383, 174.1929, -50.3694>, <-24.7424, 174.2822, -51.5774> }
					triangle { <-26.1294, 174.805, -51.5785>, <-25.966, 174.764, -50.6922>, <-24.7424, 174.2822, -51.5774> }
					triangle { <-25.7317, 174.5215, -48.9166>, <-24.6524, 174.2242, -49.05173>, <-24.6383, 174.1929, -50.3694> }
					triangle { <-25.966, 174.764, -50.6922>, <-25.7317, 174.5215, -48.9166>, <-24.6383, 174.1929, -50.3694> }
					triangle { <-26.5202, 175.6924, -48.3196>, <-26.2122, 176.0633, -48.654>, <-24.6524, 174.2242, -49.05173> }
					triangle { <-25.7317, 174.5215, -48.9166>, <-26.5202, 175.6924, -48.3196>, <-24.6524, 174.2242, -49.05173> }
					triangle { <-26.9864, 175.4588, -48.233>, <-26.5202, 175.6924, -48.3196>, <-25.7317, 174.5215, -48.9166> }
					triangle { <-26.4395, 174.354, -51.565>, <-26.3515, 174.6355, -52.7402>, <-26.5995, 174.1508, -53.3246> }
					triangle { <-26.4395, 174.354, -51.565>, <-26.1294, 174.805, -51.5785>, <-26.3515, 174.6355, -52.7402> }
					triangle { <-26.4395, 174.354, -51.565>, <-25.966, 174.764, -50.6922>, <-26.1294, 174.805, -51.5785> }
					triangle { <-26.4395, 174.354, -51.565>, <-26.4889, 174.3799, -48.8383>, <-25.966, 174.764, -50.6922> }
					triangle { <-26.4889, 174.3799, -48.8383>, <-25.7317, 174.5215, -48.9166>, <-25.966, 174.764, -50.6922> }
					triangle { <-26.4889, 174.3799, -48.8383>, <-26.9864, 175.4588, -48.233>, <-25.7317, 174.5215, -48.9166> }
					triangle { <-26.4889, 174.3799, -48.8383>, <-27.3295, 175.1026, -48.2113>, <-26.9864, 175.4588, -48.233> }
					triangle { <-27.3213, 174.1031, -53.2005>, <-26.5995, 174.1508, -53.3246>, <-26.8275, 173.5591, -54.3242> }
					triangle { <-27.3213, 174.1031, -53.2005>, <-26.4395, 174.354, -51.565>, <-26.5995, 174.1508, -53.3246> }
					triangle { <-27.3213, 174.1031, -53.2005>, <-27.2691, 174.1519, -51.5721>, <-26.4395, 174.354, -51.565> }
					triangle { <-27.2691, 174.1519, -51.5721>, <-26.4889, 174.3799, -48.8383>, <-26.4395, 174.354, -51.565> }
					triangle { <-27.1936, 174.3073, -48.8534>, <-26.4889, 174.3799, -48.8383>, <-27.2691, 174.1519, -51.5721> }
					triangle { <-27.1936, 174.3073, -48.8534>, <-27.3295, 175.1026, -48.2113>, <-26.4889, 174.3799, -48.8383> }
					triangle { <-27.1936, 174.3073, -48.8534>, <-27.6143, 174.7497, -48.2413>, <-27.3295, 175.1026, -48.2113> }
					triangle { <-25.7293, 174.5532, -53.4939>, <-26.4327, 174.6342, -54.04586>, <-26.8275, 173.5591, -54.3242> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-26.9456, 172.8884, -55.381>, <-27.1346, 173.8071, -55.7277>, 0.55 }
			cylinder { <-27.1346, 173.8071, -55.7277>, <-27.3172, 174.7385, -56.04282>, 0.55 }
			cylinder { <-27.3172, 174.7385, -56.04282>, <-27.4934, 175.6813, -56.3257>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-27.4934, 175.6813, -56.3257>, <-27.3809, 175.991, -56.7018>, 0.55 }
				cylinder { <-27.3809, 175.991, -56.7018>, <-27.1225, 175.9887, -57.1298>, 0.55 }
				cylinder { <-27.1225, 175.9887, -57.1298>, <-26.8436, 175.6754, -57.402>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-26.8436, 175.6754, -57.402>, <-27.5765, 174.1716, -57.6937>, <-26.6755, 174.5139, -57.5571> }
					triangle { <-27.7172, 173.529, -58.3869>, <-26.3222, 172.7137, -58.1333>, <-26.7104, 173.7182, -57.6156> }
					triangle { <-27.5765, 174.1716, -57.6937>, <-26.7104, 173.7182, -57.6156>, <-26.6755, 174.5139, -57.5571> }
					triangle { <-27.5765, 174.1716, -57.6937>, <-27.7172, 173.529, -58.3869>, <-26.7104, 173.7182, -57.6156> }
					triangle { <-27.7172, 173.529, -58.3869>, <-27.2579, 172.7248, -59.2829>, <-26.3222, 172.7137, -58.1333> }
					triangle { <-27.2579, 172.7248, -59.2829>, <-26.6725, 171.8819, -59.9348>, <-25.9691, 172.0588, -58.6437> }
					triangle { <-27.2579, 172.7248, -59.2829>, <-25.9691, 172.0588, -58.6437>, <-26.3222, 172.7137, -58.1333> }
					triangle { <-26.6725, 171.8819, -59.9348>, <-25.9725, 170.9093, -60.484>, <-25.1387, 170.8729, -59.7255> }
					triangle { <-26.6725, 171.8819, -59.9348>, <-25.1387, 170.8729, -59.7255>, <-25.9691, 172.0588, -58.6437> }
					triangle { <-25.9725, 170.9093, -60.484>, <-25.1816, 169.6575, -58.295>, <-24.777, 169.798, -58.6476> }
					triangle { <-25.9725, 170.9093, -60.484>, <-24.777, 169.798, -58.6476>, <-25.1387, 170.8729, -59.7255> }
					triangle { <-25.1387, 170.8729, -59.7255>, <-24.777, 169.798, -58.6476>, <-24.273, 170.0827, -58.7714> }
					triangle { <-26.6755, 174.5139, -57.5571>, <-26.7104, 173.7182, -57.6156>, <-25.9316, 173.0686, -58.2787> }
					triangle { <-26.7104, 173.7182, -57.6156>, <-26.3222, 172.7137, -58.1333>, <-25.9316, 173.0686, -58.2787> }
					triangle { <-26.3222, 172.7137, -58.1333>, <-25.9691, 172.0588, -58.6437>, <-25.9316, 173.0686, -58.2787> }
					triangle { <-25.9691, 172.0588, -58.6437>, <-24.4553, 171.0859, -59.4307>, <-25.9316, 173.0686, -58.2787> }
					triangle { <-25.9691, 172.0588, -58.6437>, <-25.1387, 170.8729, -59.7255>, <-24.4553, 171.0859, -59.4307> }
					triangle { <-25.1387, 170.8729, -59.7255>, <-24.273, 170.0827, -58.7714>, <-24.4553, 171.0859, -59.4307> }
					triangle { <-24.273, 170.0827, -58.7714>, <-23.7539, 170.4265, -58.8771>, <-24.4553, 171.0859, -59.4307> }
					triangle { <-26.8436, 175.6754, -57.402>, <-26.6755, 174.5139, -57.5571>, <-26.02453, 174.6246, -57.2368> }
					triangle { <-26.6755, 174.5139, -57.5571>, <-25.9316, 173.0686, -58.2787>, <-26.02453, 174.6246, -57.2368> }
					triangle { <-25.9316, 173.0686, -58.2787>, <-25.2176, 173.3997, -57.9476>, <-26.02453, 174.6246, -57.2368> }
					triangle { <-25.9316, 173.0686, -58.2787>, <-24.4553, 171.0859, -59.4307>, <-25.2176, 173.3997, -57.9476> }
					triangle { <-25.2176, 173.3997, -57.9476>, <-24.4553, 171.0859, -59.4307>, <-23.8126, 171.3633, -59.08804> }
					triangle { <-24.4553, 171.0859, -59.4307>, <-23.7539, 170.4265, -58.8771>, <-23.8126, 171.3633, -59.08804> }
					triangle { <-23.7539, 170.4265, -58.8771>, <-23.2913, 170.7321, -58.8103>, <-23.8126, 171.3633, -59.08804> }
					triangle { <-26.8436, 175.6754, -57.402>, <-27.3378, 174.685, -56.997>, <-27.5765, 174.1716, -57.6937> }
					triangle { <-25.8204, 175.1585, -57.6972>, <-25.2962, 175.8906, -58.06748>, <-26.8436, 175.6754, -57.402> }
					triangle { <-25.07148, 174.9537, -57.8842>, <-24.3269, 174.2178, -58.4603>, <-24.7956, 175.7314, -58.8657> }
					triangle { <-25.8204, 175.1585, -57.6972>, <-25.07148, 174.9537, -57.8842>, <-25.2962, 175.8906, -58.06748> }
					triangle { <-25.07148, 174.9537, -57.8842>, <-24.7956, 175.7314, -58.8657>, <-25.2962, 175.8906, -58.06748> }
					triangle { <-24.3269, 174.2178, -58.4603>, <-24.3362, 174.9272, -59.7617>, <-24.7956, 175.7314, -58.8657> }
					triangle { <-23.9025, 173.6167, -58.9824>, <-23.8221, 174.0306, -60.402>, <-24.3362, 174.9272, -59.7617> }
					triangle { <-24.3269, 174.2178, -58.4603>, <-23.9025, 173.6167, -58.9824>, <-24.3362, 174.9272, -59.7617> }
					triangle { <-23.2147, 172.3233, -60.04093>, <-23.1934, 173.0043, -60.9395>, <-23.8221, 174.0306, -60.402> }
					triangle { <-23.9025, 173.6167, -58.9824>, <-23.2147, 172.3233, -60.04093>, <-23.8221, 174.0306, -60.402> }
					triangle { <-22.2065, 171.6405, -59.1101>, <-21.9571, 172.1615, -59.00689>, <-23.1934, 173.0043, -60.9395> }
					triangle { <-23.2147, 172.3233, -60.04093>, <-22.2065, 171.6405, -59.1101>, <-23.1934, 173.0043, -60.9395> }
					triangle { <-22.5042, 171.2477, -58.9192>, <-22.2065, 171.6405, -59.1101>, <-23.2147, 172.3233, -60.04093> }
					triangle { <-24.7914, 173.9281, -58.4655>, <-25.07148, 174.9537, -57.8842>, <-25.8204, 175.1585, -57.6972> }
					triangle { <-24.7914, 173.9281, -58.4655>, <-24.3269, 174.2178, -58.4603>, <-25.07148, 174.9537, -57.8842> }
					triangle { <-24.7914, 173.9281, -58.4655>, <-23.9025, 173.6167, -58.9824>, <-24.3269, 174.2178, -58.4603> }
					triangle { <-24.7914, 173.9281, -58.4655>, <-23.5289, 171.7842, -59.5825>, <-23.9025, 173.6167, -58.9824> }
					triangle { <-23.5289, 171.7842, -59.5825>, <-23.2147, 172.3233, -60.04093>, <-23.9025, 173.6167, -58.9824> }
					triangle { <-23.5289, 171.7842, -59.5825>, <-22.5042, 171.2477, -58.9192>, <-23.2147, 172.3233, -60.04093> }
					triangle { <-23.5289, 171.7842, -59.5825>, <-22.8961, 170.9522, -58.8549>, <-22.5042, 171.2477, -58.9192> }
					triangle { <-26.02453, 174.6246, -57.2368>, <-25.8204, 175.1585, -57.6972>, <-26.8436, 175.6754, -57.402> }
					triangle { <-26.02453, 174.6246, -57.2368>, <-24.7914, 173.9281, -58.4655>, <-25.8204, 175.1585, -57.6972> }
					triangle { <-26.02453, 174.6246, -57.2368>, <-25.2176, 173.3997, -57.9476>, <-24.7914, 173.9281, -58.4655> }
					triangle { <-25.2176, 173.3997, -57.9476>, <-23.5289, 171.7842, -59.5825>, <-24.7914, 173.9281, -58.4655> }
					triangle { <-23.8126, 171.3633, -59.08804>, <-23.5289, 171.7842, -59.5825>, <-25.2176, 173.3997, -57.9476> }
					triangle { <-23.8126, 171.3633, -59.08804>, <-22.8961, 170.9522, -58.8549>, <-23.5289, 171.7842, -59.5825> }
					triangle { <-23.8126, 171.3633, -59.08804>, <-23.2913, 170.7321, -58.8103>, <-22.8961, 170.9522, -58.8549> }
					triangle { <-25.2962, 175.8906, -58.06748>, <-25.6989, 175.9205, -57.2656>, <-26.8436, 175.6754, -57.402> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-26.8436, 175.6754, -57.402>, <-27.02725, 175.5528, -59.08572>, <-26.9023, 174.9474, -58.3336> }
					triangle { <-26.5266, 175.3937, -59.884>, <-26.653, 173.7639, -59.8286>, <-27.01884, 174.5737, -59.02981> }
					triangle { <-27.02725, 175.5528, -59.08572>, <-27.01884, 174.5737, -59.02981>, <-26.9023, 174.9474, -58.3336> }
					triangle { <-27.02725, 175.5528, -59.08572>, <-26.5266, 175.3937, -59.884>, <-27.01884, 174.5737, -59.02981> }
					triangle { <-26.5266, 175.3937, -59.884>, <-25.7426, 174.6528, -60.5891>, <-26.653, 173.7639, -59.8286> }
					triangle { <-25.7426, 174.6528, -60.5891>, <-25.1744, 173.7667, -61.1975>, <-26.2286, 173.1628, -60.3507> }
					triangle { <-25.7426, 174.6528, -60.5891>, <-26.2286, 173.1628, -60.3507>, <-26.653, 173.7639, -59.8286> }
					triangle { <-25.1744, 173.7667, -61.1975>, <-24.708, 172.7088, -61.8304>, <-25.2703, 171.9222, -61.2501> }
					triangle { <-25.1744, 173.7667, -61.1975>, <-25.2703, 171.9222, -61.2501>, <-26.2286, 173.1628, -60.3507> }
					triangle { <-24.708, 172.7088, -61.8304>, <-26.9, 171.2333, -61.8785>, <-26.4506, 170.9844, -61.6689> }
					triangle { <-24.708, 172.7088, -61.8304>, <-26.4506, 170.9844, -61.6689>, <-25.2703, 171.9222, -61.2501> }
					triangle { <-25.2703, 171.9222, -61.2501>, <-26.4506, 170.9844, -61.6689>, <-26.1699, 170.708, -61.2272> }
					triangle { <-26.9023, 174.9474, -58.3336>, <-27.01884, 174.5737, -59.02981>, <-26.3601, 173.622, -59.3883> }
					triangle { <-27.01884, 174.5737, -59.02981>, <-26.653, 173.7639, -59.8286>, <-26.3601, 173.622, -59.3883> }
					triangle { <-26.653, 173.7639, -59.8286>, <-26.2286, 173.1628, -60.3507>, <-26.3601, 173.622, -59.3883> }
					triangle { <-26.2286, 173.1628, -60.3507>, <-25.3681, 171.4254, -60.6644>, <-26.3601, 173.622, -59.3883> }
					triangle { <-26.2286, 173.1628, -60.3507>, <-25.2703, 171.9222, -61.2501>, <-25.3681, 171.4254, -60.6644> }
					triangle { <-25.2703, 171.9222, -61.2501>, <-26.1699, 170.708, -61.2272>, <-25.3681, 171.4254, -60.6644> }
					triangle { <-26.1699, 170.708, -61.2272>, <-25.891, 170.4475, -60.7238>, <-25.3681, 171.4254, -60.6644> }
					triangle { <-26.8436, 175.6754, -57.402>, <-26.9023, 174.9474, -58.3336>, <-27.05231, 174.4241, -57.8414> }
					triangle { <-26.9023, 174.9474, -58.3336>, <-26.3601, 173.622, -59.3883>, <-27.05231, 174.4241, -57.8414> }
					triangle { <-26.3601, 173.622, -59.3883>, <-26.4618, 173.157, -58.6795>, <-27.05231, 174.4241, -57.8414> }
					triangle { <-26.3601, 173.622, -59.3883>, <-25.3681, 171.4254, -60.6644>, <-26.4618, 173.157, -58.6795> }
					triangle { <-26.4618, 173.157, -58.6795>, <-25.3681, 171.4254, -60.6644>, <-25.5066, 170.993, -60.03096> }
					triangle { <-25.3681, 171.4254, -60.6644>, <-25.891, 170.4475, -60.7238>, <-25.5066, 170.993, -60.03096> }
					triangle { <-25.891, 170.4475, -60.7238>, <-25.7967, 170.2035, -60.2305>, <-25.5066, 170.993, -60.03096> }
					triangle { <-26.8436, 175.6754, -57.402>, <-27.538, 175.5616, -58.3475>, <-27.02725, 175.5528, -59.08572> }
					triangle { <-26.4591, 174.5561, -57.4298>, <-25.8455, 174.5093, -56.6754>, <-26.8436, 175.6754, -57.402> }
					triangle { <-26.1695, 173.8237, -57.2974>, <-25.619, 172.8509, -57.7196>, <-25.0126, 174.0567, -56.7959> }
					triangle { <-26.4591, 174.5561, -57.4298>, <-26.1695, 173.8237, -57.2974>, <-25.8455, 174.5093, -56.6754> }
					triangle { <-26.1695, 173.8237, -57.2974>, <-25.0126, 174.0567, -56.7959>, <-25.8455, 174.5093, -56.6754> }
					triangle { <-25.619, 172.8509, -57.7196>, <-24.2286, 173.3158, -57.5009>, <-25.0126, 174.0567, -56.7959> }
					triangle { <-25.1577, 172.2171, -58.1664>, <-23.6973, 172.4624, -58.1847>, <-24.2286, 173.3158, -57.5009> }
					triangle { <-25.619, 172.8509, -57.7196>, <-25.1577, 172.2171, -58.1664>, <-24.2286, 173.3158, -57.5009> }
					triangle { <-24.2732, 171.0418, -59.2164>, <-23.2678, 171.437, -58.893>, <-23.6973, 172.4624, -58.1847> }
					triangle { <-25.1577, 172.2171, -58.1664>, <-24.2732, 171.0418, -59.2164>, <-23.6973, 172.4624, -58.1847> }
					triangle { <-25.09906, 169.7623, -59.04293>, <-25.03849, 169.8085, -58.4611>, <-23.2678, 171.437, -58.893> }
					triangle { <-24.2732, 171.0418, -59.2164>, <-25.09906, 169.7623, -59.04293>, <-23.2678, 171.437, -58.893> }
					triangle { <-25.4243, 169.802, -59.4577>, <-25.09906, 169.7623, -59.04293>, <-24.2732, 171.0418, -59.2164> }
					triangle { <-25.7693, 173.1003, -58.1832>, <-26.1695, 173.8237, -57.2974>, <-26.4591, 174.5561, -57.4298> }
					triangle { <-25.7693, 173.1003, -58.1832>, <-25.619, 172.8509, -57.7196>, <-26.1695, 173.8237, -57.2974> }
					triangle { <-25.7693, 173.1003, -58.1832>, <-25.1577, 172.2171, -58.1664>, <-25.619, 172.8509, -57.7196> }
					triangle { <-25.7693, 173.1003, -58.1832>, <-24.888, 171.0014, -59.6853>, <-25.1577, 172.2171, -58.1664> }
					triangle { <-24.888, 171.0014, -59.6853>, <-24.2732, 171.0418, -59.2164>, <-25.1577, 172.2171, -58.1664> }
					triangle { <-24.888, 171.0014, -59.6853>, <-25.4243, 169.802, -59.4577>, <-24.2732, 171.0418, -59.2164> }
					triangle { <-24.888, 171.0014, -59.6853>, <-25.6274, 169.9814, -59.872>, <-25.4243, 169.802, -59.4577> }
					triangle { <-27.05231, 174.4241, -57.8414>, <-26.4591, 174.5561, -57.4298>, <-26.8436, 175.6754, -57.402> }
					triangle { <-27.05231, 174.4241, -57.8414>, <-25.7693, 173.1003, -58.1832>, <-26.4591, 174.5561, -57.4298> }
					triangle { <-27.05231, 174.4241, -57.8414>, <-26.4618, 173.157, -58.6795>, <-25.7693, 173.1003, -58.1832> }
					triangle { <-26.4618, 173.157, -58.6795>, <-24.888, 171.0014, -59.6853>, <-25.7693, 173.1003, -58.1832> }
					triangle { <-25.5066, 170.993, -60.03096>, <-24.888, 171.0014, -59.6853>, <-26.4618, 173.157, -58.6795> }
					triangle { <-25.5066, 170.993, -60.03096>, <-25.6274, 169.9814, -59.872>, <-24.888, 171.0014, -59.6853> }
					triangle { <-25.5066, 170.993, -60.03096>, <-25.7967, 170.2035, -60.2305>, <-25.6274, 169.9814, -59.872> }
					triangle { <-25.8455, 174.5093, -56.6754>, <-26.6887, 174.8116, -56.6151>, <-26.8436, 175.6754, -57.402> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-26.8436, 175.6754, -57.402>, <-25.2962, 175.8906, -58.06748>, <-26.1158, 175.4194, -58.2998> }
					triangle { <-24.4632, 175.4379, -58.1879>, <-24.8808, 174.7069, -59.5901>, <-25.5515, 175.3776, -58.8634> }
					triangle { <-25.2962, 175.8906, -58.06748>, <-25.5515, 175.3776, -58.8634>, <-26.1158, 175.4194, -58.2998> }
					triangle { <-25.2962, 175.8906, -58.06748>, <-24.4632, 175.4379, -58.1879>, <-25.5515, 175.3776, -58.8634> }
					triangle { <-24.4632, 175.4379, -58.1879>, <-23.7823, 174.4381, -58.6319>, <-24.8808, 174.7069, -59.5901> }
					triangle { <-23.7823, 174.4381, -58.6319>, <-23.2682, 173.5414, -59.2722>, <-24.4195, 174.0732, -60.03691> }
					triangle { <-23.7823, 174.4381, -58.6319>, <-24.4195, 174.0732, -60.03691>, <-24.8808, 174.7069, -59.5901> }
					triangle { <-23.2682, 173.5414, -59.2722>, <-22.7872, 172.6456, -60.111>, <-23.6209, 172.682, -60.8694> }
					triangle { <-23.2682, 173.5414, -59.2722>, <-23.6209, 172.682, -60.8694>, <-24.4195, 174.0732, -60.03691> }
					triangle { <-22.7872, 172.6456, -60.111>, <-23.4966, 173.7686, -62.3956>, <-23.6569, 173.2415, -62.3302> }
					triangle { <-22.7872, 172.6456, -60.111>, <-23.6569, 173.2415, -62.3302>, <-23.6209, 172.682, -60.8694> }
					triangle { <-23.6209, 172.682, -60.8694>, <-23.6569, 173.2415, -62.3302>, <-24.07943, 172.8279, -62.3021> }
					triangle { <-26.1158, 175.4194, -58.2998>, <-25.5515, 175.3776, -58.8634>, <-25.2715, 174.352, -59.4447> }
					triangle { <-25.5515, 175.3776, -58.8634>, <-24.8808, 174.7069, -59.5901>, <-25.2715, 174.352, -59.4447> }
					triangle { <-24.8808, 174.7069, -59.5901>, <-24.4195, 174.0732, -60.03691>, <-25.2715, 174.352, -59.4447> }
					triangle { <-24.4195, 174.0732, -60.03691>, <-24.3044, 172.469, -61.1642>, <-25.2715, 174.352, -59.4447> }
					triangle { <-24.4195, 174.0732, -60.03691>, <-23.6209, 172.682, -60.8694>, <-24.3044, 172.469, -61.1642> }
					triangle { <-23.6209, 172.682, -60.8694>, <-24.07943, 172.8279, -62.3021>, <-24.3044, 172.469, -61.1642> }
					triangle { <-24.07943, 172.8279, -62.3021>, <-24.5578, 172.4196, -62.2443>, <-24.3044, 172.469, -61.1642> }
					triangle { <-26.8436, 175.6754, -57.402>, <-26.1158, 175.4194, -58.2998>, <-26.7261, 175.2442, -58.6679> }
					triangle { <-26.1158, 175.4194, -58.2998>, <-25.2715, 174.352, -59.4447>, <-26.7261, 175.2442, -58.6679> }
					triangle { <-25.2715, 174.352, -59.4447>, <-26.06697, 174.1497, -59.68>, <-26.7261, 175.2442, -58.6679> }
					triangle { <-25.2715, 174.352, -59.4447>, <-24.3044, 172.469, -61.1642>, <-26.06697, 174.1497, -59.68> }
					triangle { <-26.06697, 174.1497, -59.68>, <-24.3044, 172.469, -61.1642>, <-25.02859, 172.3205, -61.4112> }
					triangle { <-24.3044, 172.469, -61.1642>, <-24.5578, 172.4196, -62.2443>, <-25.02859, 172.3205, -61.4112> }
					triangle { <-24.5578, 172.4196, -62.2443>, <-25.0612, 172.1785, -62.2633>, <-25.02859, 172.3205, -61.4112> }
					triangle { <-26.8436, 175.6754, -57.402>, <-26.105, 176.2792, -58.09416>, <-25.2962, 175.8906, -58.06748> }
					triangle { <-26.9709, 174.7748, -58.1596>, <-27.5765, 174.1716, -57.6937>, <-26.8436, 175.6754, -57.402> }
					triangle { <-27.1905, 174.1421, -58.5948>, <-26.8761, 173.2028, -59.2631>, <-27.3849, 173.2355, -57.709> }
					triangle { <-26.9709, 174.7748, -58.1596>, <-27.1905, 174.1421, -58.5948>, <-27.5765, 174.1716, -57.6937> }
					triangle { <-27.1905, 174.1421, -58.5948>, <-27.3849, 173.2355, -57.709>, <-27.5765, 174.1716, -57.6937> }
					triangle { <-26.8761, 173.2028, -59.2631>, <-26.704, 172.2357, -58.1531>, <-27.3849, 173.2355, -57.709> }
					triangle { <-26.4861, 172.5154, -59.6982>, <-26.1186, 171.3927, -58.805>, <-26.704, 172.2357, -58.1531> }
					triangle { <-26.8761, 173.2028, -59.2631>, <-26.4861, 172.5154, -59.6982>, <-26.704, 172.2357, -58.1531> }
					triangle { <-25.5449, 171.2316, -60.5541>, <-25.5663, 170.5506, -59.6555>, <-26.1186, 171.3927, -58.805> }
					triangle { <-26.4861, 172.5154, -59.6982>, <-25.5449, 171.2316, -60.5541>, <-26.1186, 171.3927, -58.805> }
					triangle { <-26.1459, 171.2701, -61.9634>, <-26.6804, 171.2001, -61.7317>, <-25.5663, 170.5506, -59.6555> }
					triangle { <-25.5449, 171.2316, -60.5541>, <-26.1459, 171.2701, -61.9634>, <-25.5663, 170.5506, -59.6555> }
					triangle { <-25.8075, 171.5985, -62.2022>, <-26.1459, 171.2701, -61.9634>, <-25.5449, 171.2316, -60.5541> }
					triangle { <-26.4116, 173.4925, -59.2578>, <-27.1905, 174.1421, -58.5948>, <-26.9709, 174.7748, -58.1596> }
					triangle { <-26.4116, 173.4925, -59.2578>, <-26.8761, 173.2028, -59.2631>, <-27.1905, 174.1421, -58.5948> }
					triangle { <-26.4116, 173.4925, -59.2578>, <-26.4861, 172.5154, -59.6982>, <-26.8761, 173.2028, -59.2631> }
					triangle { <-26.4116, 173.4925, -59.2578>, <-25.2307, 171.7707, -61.01245>, <-26.4861, 172.5154, -59.6982> }
					triangle { <-25.2307, 171.7707, -61.01245>, <-25.5449, 171.2316, -60.5541>, <-26.4861, 172.5154, -59.6982> }
					triangle { <-25.2307, 171.7707, -61.01245>, <-25.8075, 171.5985, -62.2022>, <-25.5449, 171.2316, -60.5541> }
					triangle { <-25.2307, 171.7707, -61.01245>, <-25.4156, 171.894, -62.2665>, <-25.8075, 171.5985, -62.2022> }
					triangle { <-26.7261, 175.2442, -58.6679>, <-26.9709, 174.7748, -58.1596>, <-26.8436, 175.6754, -57.402> }
					triangle { <-26.7261, 175.2442, -58.6679>, <-26.4116, 173.4925, -59.2578>, <-26.9709, 174.7748, -58.1596> }
					triangle { <-26.7261, 175.2442, -58.6679>, <-26.06697, 174.1497, -59.68>, <-26.4116, 173.4925, -59.2578> }
					triangle { <-26.06697, 174.1497, -59.68>, <-25.2307, 171.7707, -61.01245>, <-26.4116, 173.4925, -59.2578> }
					triangle { <-25.02859, 172.3205, -61.4112>, <-25.2307, 171.7707, -61.01245>, <-26.06697, 174.1497, -59.68> }
					triangle { <-25.02859, 172.3205, -61.4112>, <-25.4156, 171.894, -62.2665>, <-25.2307, 171.7707, -61.01245> }
					triangle { <-25.02859, 172.3205, -61.4112>, <-25.0612, 172.1785, -62.2633>, <-25.4156, 171.894, -62.2665> }
					triangle { <-27.5765, 174.1716, -57.6937>, <-27.744, 175.0437, -57.8255>, <-26.8436, 175.6754, -57.402> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-26.8436, 175.6754, -57.402>, <-25.8455, 174.5093, -56.6754>, <-25.8891, 174.9859, -57.5232> }
					triangle { <-25.6539, 173.5732, -56.6908>, <-24.5501, 173.6566, -57.8948>, <-25.2431, 174.522, -57.4493> }
					triangle { <-25.8455, 174.5093, -56.6754>, <-25.2431, 174.522, -57.4493>, <-25.8891, 174.9859, -57.5232> }
					triangle { <-25.8455, 174.5093, -56.6754>, <-25.6539, 173.5732, -56.6908>, <-25.2431, 174.522, -57.4493> }
					triangle { <-25.6539, 173.5732, -56.6908>, <-25.2975, 172.5101, -57.3258>, <-24.5501, 173.6566, -57.8948> }
					triangle { <-25.2975, 172.5101, -57.3258>, <-24.7662, 171.6566, -58.00956>, <-24.16, 172.9692, -58.3299> }
					triangle { <-25.2975, 172.5101, -57.3258>, <-24.16, 172.9692, -58.3299>, <-24.5501, 173.6566, -57.8948> }
					triangle { <-24.7662, 171.6566, -58.00956>, <-24.05173, 170.8461, -58.7645>, <-23.4894, 171.6327, -59.3449> }
					triangle { <-24.7662, 171.6566, -58.00956>, <-23.4894, 171.6327, -59.3449>, <-24.16, 172.9692, -58.3299> }
					triangle { <-24.05173, 170.8461, -58.7645>, <-21.7783, 172.1927, -58.8121>, <-21.9832, 172.0551, -59.3089> }
					triangle { <-24.05173, 170.8461, -58.7645>, <-21.9832, 172.0551, -59.3089>, <-23.4894, 171.6327, -59.3449> }
					triangle { <-23.4894, 171.6327, -59.3449>, <-21.9832, 172.0551, -59.3089>, <-22.1825, 172.2026, -59.8464> }
					triangle { <-25.8891, 174.9859, -57.5232>, <-25.2431, 174.522, -57.4493>, <-24.8429, 173.7986, -58.335> }
					triangle { <-25.2431, 174.522, -57.4493>, <-24.5501, 173.6566, -57.8948>, <-24.8429, 173.7986, -58.335> }
					triangle { <-24.5501, 173.6566, -57.8948>, <-24.16, 172.9692, -58.3299>, <-24.8429, 173.7986, -58.335> }
					triangle { <-24.16, 172.9692, -58.3299>, <-23.3916, 172.1295, -59.9305>, <-24.8429, 173.7986, -58.335> }
					triangle { <-24.16, 172.9692, -58.3299>, <-23.4894, 171.6327, -59.3449>, <-23.3916, 172.1295, -59.9305> }
					triangle { <-23.4894, 171.6327, -59.3449>, <-22.1825, 172.2026, -59.8464>, <-23.3916, 172.1295, -59.9305> }
					triangle { <-22.1825, 172.2026, -59.8464>, <-22.4207, 172.3987, -60.3976>, <-23.3916, 172.1295, -59.9305> }
					triangle { <-26.8436, 175.6754, -57.402>, <-25.8891, 174.9859, -57.5232>, <-25.6983, 175.4448, -58.06335> }
					triangle { <-25.8891, 174.9859, -57.5232>, <-24.8429, 173.7986, -58.335>, <-25.6983, 175.4448, -58.06335> }
					triangle { <-24.8429, 173.7986, -58.335>, <-24.8228, 174.3925, -58.9481>, <-25.6983, 175.4448, -58.06335> }
					triangle { <-24.8429, 173.7986, -58.335>, <-23.3916, 172.1295, -59.9305>, <-24.8228, 174.3925, -58.9481> }
					triangle { <-24.8228, 174.3925, -58.9481>, <-23.3916, 172.1295, -59.9305>, <-23.3345, 172.6908, -60.4683> }
					triangle { <-23.3916, 172.1295, -59.9305>, <-22.4207, 172.3987, -60.3976>, <-23.3345, 172.6908, -60.4683> }
					triangle { <-22.4207, 172.3987, -60.3976>, <-22.5557, 172.7071, -60.8431>, <-23.3345, 172.6908, -60.4683> }
					triangle { <-26.8436, 175.6754, -57.402>, <-25.9049, 175.4025, -56.7436>, <-25.8455, 174.5093, -56.6754> }
					triangle { <-26.3322, 175.3772, -58.4271>, <-27.02725, 175.5528, -59.08572>, <-26.8436, 175.6754, -57.402> }
					triangle { <-26.09246, 175.272, -59.1816>, <-25.5841, 174.5697, -60.0038>, <-27.1679, 174.9102, -59.7789> }
					triangle { <-26.3322, 175.3772, -58.4271>, <-26.09246, 175.272, -59.1816>, <-27.02725, 175.5528, -59.08572> }
					triangle { <-26.09246, 175.272, -59.1816>, <-27.1679, 174.9102, -59.7789>, <-27.02725, 175.5528, -59.08572> }
					triangle { <-25.5841, 174.5697, -60.0038>, <-26.8115, 173.8471, -60.4139>, <-27.1679, 174.9102, -59.7789> }
					triangle { <-25.2309, 173.9149, -60.5142>, <-26.2433, 172.961, -61.02235>, <-26.8115, 173.8471, -60.4139> }
					triangle { <-25.5841, 174.5697, -60.0038>, <-25.2309, 173.9149, -60.5142>, <-26.8115, 173.8471, -60.4139> }
					triangle { <-24.4864, 172.5131, -61.3785>, <-25.4918, 172.1179, -61.702>, <-26.2433, 172.961, -61.02235> }
					triangle { <-25.2309, 173.9149, -60.5142>, <-24.4864, 172.5131, -61.3785>, <-26.2433, 172.961, -61.02235> }
					triangle { <-23.2534, 173.1483, -62.0307>, <-23.599, 173.5531, -62.2774>, <-25.4918, 172.1179, -61.702> }
					triangle { <-24.4864, 172.5131, -61.3785>, <-23.2534, 173.1483, -62.0307>, <-25.4918, 172.1179, -61.702> }
					triangle { <-22.8874, 173.0442, -61.6637>, <-23.2534, 173.1483, -62.0307>, <-24.4864, 172.5131, -61.3785> }
					triangle { <-25.4338, 174.3203, -59.5402>, <-26.09246, 175.272, -59.1816>, <-26.3322, 175.3772, -58.4271> }
					triangle { <-25.4338, 174.3203, -59.5402>, <-25.5841, 174.5697, -60.0038>, <-26.09246, 175.272, -59.1816> }
					triangle { <-25.4338, 174.3203, -59.5402>, <-25.2309, 173.9149, -60.5142>, <-25.5841, 174.5697, -60.0038> }
					triangle { <-25.4338, 174.3203, -59.5402>, <-23.8716, 172.5534, -60.9097>, <-25.2309, 173.9149, -60.5142> }
					triangle { <-23.8716, 172.5534, -60.9097>, <-24.4864, 172.5131, -61.3785>, <-25.2309, 173.9149, -60.5142> }
					triangle { <-23.8716, 172.5534, -60.9097>, <-22.8874, 173.0442, -61.6637>, <-24.4864, 172.5131, -61.3785> }
					triangle { <-23.8716, 172.5534, -60.9097>, <-22.6843, 172.8648, -61.2494>, <-22.8874, 173.0442, -61.6637> }
					triangle { <-25.6983, 175.4448, -58.06335>, <-26.3322, 175.3772, -58.4271>, <-26.8436, 175.6754, -57.402> }
					triangle { <-25.6983, 175.4448, -58.06335>, <-25.4338, 174.3203, -59.5402>, <-26.3322, 175.3772, -58.4271> }
					triangle { <-25.6983, 175.4448, -58.06335>, <-24.8228, 174.3925, -58.9481>, <-25.4338, 174.3203, -59.5402> }
					triangle { <-24.8228, 174.3925, -58.9481>, <-23.8716, 172.5534, -60.9097>, <-25.4338, 174.3203, -59.5402> }
					triangle { <-23.3345, 172.6908, -60.4683>, <-23.8716, 172.5534, -60.9097>, <-24.8228, 174.3925, -58.9481> }
					triangle { <-23.3345, 172.6908, -60.4683>, <-22.6843, 172.8648, -61.2494>, <-23.8716, 172.5534, -60.9097> }
					triangle { <-23.3345, 172.6908, -60.4683>, <-22.5557, 172.7071, -60.8431>, <-22.6843, 172.8648, -61.2494> }
					triangle { <-27.02725, 175.5528, -59.08572>, <-26.7542, 176.1525, -58.476>, <-26.8436, 175.6754, -57.402> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-27.4934, 175.6813, -56.3257>, <-27.6518, 176.618, -56.6379>, 0.55 }
			cylinder { <-27.6518, 176.618, -56.6379>, <-27.7923, 177.5475, -56.9788>, 0.55 }
			cylinder { <-27.7923, 177.5475, -56.9788>, <-27.9147, 178.4687, -57.3482>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-27.9147, 178.4687, -57.3482>, <-28.2767, 178.809, -57.4048>, 0.55 }
				cylinder { <-28.2767, 178.809, -57.4048>, <-28.7638, 178.8636, -57.3057>, 0.55 }
				cylinder { <-28.7638, 178.8636, -57.3057>, <-29.1393, 178.6061, -57.09924>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-29.1393, 178.6061, -57.09924>, <-28.8194, 177.9058, -55.5857>, <-29.3522, 177.6959, -56.3729> }
					triangle { <-29.2112, 177.7726, -54.7243>, <-29.9879, 176.3874, -55.1154>, <-29.3594, 177.1209, -55.8187> }
					triangle { <-28.8194, 177.9058, -55.5857>, <-29.3594, 177.1209, -55.8187>, <-29.3522, 177.6959, -56.3729> }
					triangle { <-28.8194, 177.9058, -55.5857>, <-29.2112, 177.7726, -54.7243>, <-29.3594, 177.1209, -55.8187> }
					triangle { <-29.2112, 177.7726, -54.7243>, <-30.1638, 177.3249, -53.9809>, <-29.9879, 176.3874, -55.1154> }
					triangle { <-30.1638, 177.3249, -53.9809>, <-31.02811, 176.6834, -53.4153>, <-30.5915, 175.9377, -54.6179> }
					triangle { <-30.1638, 177.3249, -53.9809>, <-30.5915, 175.9377, -54.6179>, <-29.9879, 176.3874, -55.1154> }
					triangle { <-31.02811, 176.6834, -53.4153>, <-31.8964, 175.8443, -52.8869>, <-31.9304, 175.1033, -53.7363> }
					triangle { <-31.02811, 176.6834, -53.4153>, <-31.9304, 175.1033, -53.7363>, <-30.5915, 175.9377, -54.6179> }
					triangle { <-31.8964, 175.8443, -52.8869>, <-30.8564, 173.5633, -53.7233>, <-31.3929, 173.6377, -53.843> }
					triangle { <-31.8964, 175.8443, -52.8869>, <-31.3929, 173.6377, -53.843>, <-31.9304, 175.1033, -53.7363> }
					triangle { <-31.9304, 175.1033, -53.7363>, <-31.3929, 173.6377, -53.843>, <-31.836, 173.6791, -54.2333> }
					triangle { <-29.3522, 177.6959, -56.3729>, <-29.3594, 177.1209, -55.8187>, <-30.3687, 176.5448, -55.4759> }
					triangle { <-29.3594, 177.1209, -55.8187>, <-29.9879, 176.3874, -55.1154>, <-30.3687, 176.5448, -55.4759> }
					triangle { <-29.9879, 176.3874, -55.1154>, <-30.5915, 175.9377, -54.6179>, <-30.3687, 176.5448, -55.4759> }
					triangle { <-30.5915, 175.9377, -54.6179>, <-32.1965, 174.8253, -54.4081>, <-30.3687, 176.5448, -55.4759> }
					triangle { <-30.5915, 175.9377, -54.6179>, <-31.9304, 175.1033, -53.7363>, <-32.1965, 174.8253, -54.4081> }
					triangle { <-31.9304, 175.1033, -53.7363>, <-31.836, 173.6791, -54.2333>, <-32.1965, 174.8253, -54.4081> }
					triangle { <-31.836, 173.6791, -54.2333>, <-32.2775, 173.7514, -54.6792>, <-32.1965, 174.8253, -54.4081> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-29.3522, 177.6959, -56.3729>, <-29.5761, 177.3427, -56.9761> }
					triangle { <-29.3522, 177.6959, -56.3729>, <-30.3687, 176.5448, -55.4759>, <-29.5761, 177.3427, -56.9761> }
					triangle { <-30.3687, 176.5448, -55.4759>, <-30.6316, 176.3286, -56.2589>, <-29.5761, 177.3427, -56.9761> }
					triangle { <-30.3687, 176.5448, -55.4759>, <-32.1965, 174.8253, -54.4081>, <-30.6316, 176.3286, -56.2589> }
					triangle { <-30.6316, 176.3286, -56.2589>, <-32.1965, 174.8253, -54.4081>, <-32.4007, 174.5953, -55.1243> }
					triangle { <-32.1965, 174.8253, -54.4081>, <-32.2775, 173.7514, -54.6792>, <-32.4007, 174.5953, -55.1243> }
					triangle { <-32.2775, 173.7514, -54.6792>, <-32.5551, 173.7457, -55.1637>, <-32.4007, 174.5953, -55.1243> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-28.4915, 177.8921, -56.4213>, <-28.8194, 177.9058, -55.5857> }
					triangle { <-30.05602, 177.861, -57.1753>, <-30.6962, 178.346, -57.7253>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-30.7083, 177.4373, -57.3565>, <-31.6301, 176.7726, -56.9877>, <-31.6159, 178.3366, -57.4657> }
					triangle { <-30.05602, 177.861, -57.1753>, <-30.7083, 177.4373, -57.3565>, <-30.6962, 178.346, -57.7253> }
					triangle { <-30.7083, 177.4373, -57.3565>, <-31.6159, 178.3366, -57.4657>, <-30.6962, 178.346, -57.7253> }
					triangle { <-31.6301, 176.7726, -56.9877>, <-32.5684, 177.8889, -56.7223>, <-31.6159, 178.3366, -57.4657> }
					triangle { <-32.2923, 176.3367, -56.557>, <-33.3741, 177.2337, -56.08993>, <-32.5684, 177.8889, -56.7223> }
					triangle { <-31.6301, 176.7726, -56.9877>, <-32.2923, 176.3367, -56.557>, <-32.5684, 177.8889, -56.7223> }
					triangle { <-33.514, 175.4748, -55.5416>, <-34.1838, 176.3808, -55.4946>, <-33.3741, 177.2337, -56.08993> }
					triangle { <-32.2923, 176.3367, -56.557>, <-33.514, 175.4748, -55.5416>, <-33.3741, 177.2337, -56.08993> }
					triangle { <-33.5369, 174.0781, -56.1724>, <-33.643, 174.3219, -56.6954>, <-34.1838, 176.3808, -55.4946> }
					triangle { <-33.514, 175.4748, -55.5416>, <-33.5369, 174.0781, -56.1724>, <-34.1838, 176.3808, -55.4946> }
					triangle { <-33.1874, 173.8287, -55.8639>, <-33.5369, 174.0781, -56.1724>, <-33.514, 175.4748, -55.5416> }
					triangle { <-31.3071, 176.7649, -56.5457>, <-30.7083, 177.4373, -57.3565>, <-30.05602, 177.861, -57.1753> }
					triangle { <-31.3071, 176.7649, -56.5457>, <-31.6301, 176.7726, -56.9877>, <-30.7083, 177.4373, -57.3565> }
					triangle { <-31.3071, 176.7649, -56.5457>, <-32.2923, 176.3367, -56.557>, <-31.6301, 176.7726, -56.9877> }
					triangle { <-31.3071, 176.7649, -56.5457>, <-32.959, 175.0042, -55.2773>, <-32.2923, 176.3367, -56.557> }
					triangle { <-32.959, 175.0042, -55.2773>, <-33.514, 175.4748, -55.5416>, <-32.2923, 176.3367, -56.557> }
					triangle { <-32.959, 175.0042, -55.2773>, <-33.1874, 173.8287, -55.8639>, <-33.514, 175.4748, -55.5416> }
					triangle { <-32.959, 175.0042, -55.2773>, <-32.8648, 173.753, -55.4962>, <-33.1874, 173.8287, -55.8639> }
					triangle { <-29.5761, 177.3427, -56.9761>, <-30.05602, 177.861, -57.1753>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-29.5761, 177.3427, -56.9761>, <-31.3071, 176.7649, -56.5457>, <-30.05602, 177.861, -57.1753> }
					triangle { <-29.5761, 177.3427, -56.9761>, <-30.6316, 176.3286, -56.2589>, <-31.3071, 176.7649, -56.5457> }
					triangle { <-30.6316, 176.3286, -56.2589>, <-32.959, 175.0042, -55.2773>, <-31.3071, 176.7649, -56.5457> }
					triangle { <-32.4007, 174.5953, -55.1243>, <-32.959, 175.0042, -55.2773>, <-30.6316, 176.3286, -56.2589> }
					triangle { <-32.4007, 174.5953, -55.1243>, <-32.8648, 173.753, -55.4962>, <-32.959, 175.0042, -55.2773> }
					triangle { <-32.4007, 174.5953, -55.1243>, <-32.5551, 173.7457, -55.1637>, <-32.8648, 173.753, -55.4962> }
					triangle { <-30.6962, 178.346, -57.7253>, <-29.8404, 178.2085, -57.9592>, <-29.1393, 178.6061, -57.09924> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.1393, 178.6061, -57.09924>, <-30.2201, 179.3237, -56.00357>, <-29.7584, 178.472, -56.09923> }
					triangle { <-31.1398, 179.3143, -55.7439>, <-30.9904, 178.0864, -54.674>, <-30.1727, 178.5373, -55.4195> }
					triangle { <-30.2201, 179.3237, -56.00357>, <-30.1727, 178.5373, -55.4195>, <-29.7584, 178.472, -56.09923> }
					triangle { <-30.2201, 179.3237, -56.00357>, <-31.1398, 179.3143, -55.7439>, <-30.1727, 178.5373, -55.4195> }
					triangle { <-31.1398, 179.3143, -55.7439>, <-32.1816, 178.6833, -55.3233>, <-30.9904, 178.0864, -54.674> }
					triangle { <-32.1816, 178.6833, -55.3233>, <-33.00218, 177.9976, -54.7447>, <-31.6526, 177.6505, -54.2433> }
					triangle { <-32.1816, 178.6833, -55.3233>, <-31.6526, 177.6505, -54.2433>, <-30.9904, 178.0864, -54.674> }
					triangle { <-33.00218, 177.9976, -54.7447>, <-33.7672, 177.2363, -53.988>, <-32.9487, 176.6358, -53.497> }
					triangle { <-33.00218, 177.9976, -54.7447>, <-32.9487, 176.6358, -53.497>, <-31.6526, 177.6505, -54.2433> }
					triangle { <-33.7672, 177.2363, -53.988>, <-32.2582, 177.1262, -51.8212>, <-32.4166, 176.6353, -52.0256> }
					triangle { <-33.7672, 177.2363, -53.988>, <-32.4166, 176.6353, -52.0256>, <-32.9487, 176.6358, -53.497> }
					triangle { <-32.9487, 176.6358, -53.497>, <-32.4166, 176.6353, -52.0256>, <-32.2906, 176.1007, -52.2461> }
					triangle { <-29.7584, 178.472, -56.09923>, <-30.1727, 178.5373, -55.4195>, <-30.8756, 177.6509, -54.9853> }
					triangle { <-30.1727, 178.5373, -55.4195>, <-30.9904, 178.0864, -54.674>, <-30.8756, 177.6509, -54.9853> }
					triangle { <-30.9904, 178.0864, -54.674>, <-31.6526, 177.6505, -54.2433>, <-30.8756, 177.6509, -54.9853> }
					triangle { <-31.6526, 177.6505, -54.2433>, <-32.4531, 176.043, -53.4479>, <-30.8756, 177.6509, -54.9853> }
					triangle { <-31.6526, 177.6505, -54.2433>, <-32.9487, 176.6358, -53.497>, <-32.4531, 176.043, -53.4479> }
					triangle { <-32.9487, 176.6358, -53.497>, <-32.2906, 176.1007, -52.2461>, <-32.4531, 176.043, -53.4479> }
					triangle { <-32.2906, 176.1007, -52.2461>, <-32.1193, 175.5526, -52.5091>, <-32.4531, 176.043, -53.4479> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-29.7584, 178.472, -56.09923>, <-29.2934, 177.9232, -55.9537> }
					triangle { <-29.7584, 178.472, -56.09923>, <-30.8756, 177.6509, -54.9853>, <-29.2934, 177.9232, -55.9537> }
					triangle { <-30.8756, 177.6509, -54.9853>, <-30.2894, 177.0313, -55.0214>, <-29.2934, 177.9232, -55.9537> }
					triangle { <-30.8756, 177.6509, -54.9853>, <-32.4531, 176.043, -53.4479>, <-30.2894, 177.0313, -55.0214> }
					triangle { <-30.2894, 177.0313, -55.0214>, <-32.4531, 176.043, -53.4479>, <-31.8958, 175.4981, -53.4432> }
					triangle { <-32.4531, 176.043, -53.4479>, <-32.1193, 175.5526, -52.5091>, <-31.8958, 175.4981, -53.4432> }
					triangle { <-32.1193, 175.5526, -52.5091>, <-31.827, 175.1068, -52.6755>, <-31.8958, 175.4981, -53.4432> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-29.3346, 179.2473, -56.1297>, <-30.2201, 179.3237, -56.00357> }
					triangle { <-29.4117, 177.5737, -56.5882>, <-29.2955, 176.9281, -57.3075>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-29.5081, 176.8154, -56.3567>, <-30.1813, 175.9902, -55.8149>, <-29.9551, 176.2449, -57.4146> }
					triangle { <-29.4117, 177.5737, -56.5882>, <-29.5081, 176.8154, -56.3567>, <-29.2955, 176.9281, -57.3075> }
					triangle { <-29.5081, 176.8154, -56.3567>, <-29.9551, 176.2449, -57.4146>, <-29.2955, 176.9281, -57.3075> }
					triangle { <-30.1813, 175.9902, -55.8149>, <-30.9969, 175.6139, -56.994>, <-29.9551, 176.2449, -57.4146> }
					triangle { <-30.8146, 175.4794, -55.425>, <-31.8463, 175.003, -56.3747>, <-30.9969, 175.6139, -56.994> }
					triangle { <-30.1813, 175.9902, -55.8149>, <-30.8146, 175.4794, -55.425>, <-30.9969, 175.6139, -56.994> }
					triangle { <-32.1685, 174.6145, -54.5972>, <-32.6403, 174.3166, -55.5772>, <-31.8463, 175.003, -56.3747> }
					triangle { <-30.8146, 175.4794, -55.425>, <-32.1685, 174.6145, -54.5972>, <-31.8463, 175.003, -56.3747> }
					triangle { <-31.4526, 173.9296, -53.4278>, <-31.07729, 173.686, -53.8072>, <-32.6403, 174.3166, -55.5772> }
					triangle { <-32.1685, 174.6145, -54.5972>, <-31.4526, 173.9296, -53.4278>, <-32.6403, 174.3166, -55.5772> }
					triangle { <-31.5252, 174.2899, -53.04779>, <-31.4526, 173.9296, -53.4278>, <-32.1685, 174.6145, -54.5972> }
					triangle { <-30.4133, 176.4531, -55.6373>, <-29.5081, 176.8154, -56.3567>, <-29.4117, 177.5737, -56.5882> }
					triangle { <-30.4133, 176.4531, -55.6373>, <-30.1813, 175.9902, -55.8149>, <-29.5081, 176.8154, -56.3567> }
					triangle { <-30.4133, 176.4531, -55.6373>, <-30.8146, 175.4794, -55.425>, <-30.1813, 175.9902, -55.8149> }
					triangle { <-30.4133, 176.4531, -55.6373>, <-32.07755, 175.0697, -53.9776>, <-30.8146, 175.4794, -55.425> }
					triangle { <-32.07755, 175.0697, -53.9776>, <-32.1685, 174.6145, -54.5972>, <-30.8146, 175.4794, -55.425> }
					triangle { <-32.07755, 175.0697, -53.9776>, <-31.5252, 174.2899, -53.04779>, <-32.1685, 174.6145, -54.5972> }
					triangle { <-32.07755, 175.0697, -53.9776>, <-31.6841, 174.7016, -52.8236>, <-31.5252, 174.2899, -53.04779> }
					triangle { <-29.2934, 177.9232, -55.9537>, <-29.4117, 177.5737, -56.5882>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-29.2934, 177.9232, -55.9537>, <-30.4133, 176.4531, -55.6373>, <-29.4117, 177.5737, -56.5882> }
					triangle { <-29.2934, 177.9232, -55.9537>, <-30.2894, 177.0313, -55.0214>, <-30.4133, 176.4531, -55.6373> }
					triangle { <-30.2894, 177.0313, -55.0214>, <-32.07755, 175.0697, -53.9776>, <-30.4133, 176.4531, -55.6373> }
					triangle { <-31.8958, 175.4981, -53.4432>, <-32.07755, 175.0697, -53.9776>, <-30.2894, 177.0313, -55.0214> }
					triangle { <-31.8958, 175.4981, -53.4432>, <-31.6841, 174.7016, -52.8236>, <-32.07755, 175.0697, -53.9776> }
					triangle { <-31.8958, 175.4981, -53.4432>, <-31.827, 175.1068, -52.6755>, <-31.6841, 174.7016, -52.8236> }
					triangle { <-29.2955, 176.9281, -57.3075>, <-28.67, 177.5255, -57.06699>, <-29.1393, 178.6061, -57.09924> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.1393, 178.6061, -57.09924>, <-30.6962, 178.346, -57.7253>, <-30.2871, 178.4599, -56.8493> }
					triangle { <-31.3558, 177.6629, -57.8325>, <-32.06356, 177.8955, -56.3764>, <-31.08401, 178.4106, -56.8268> }
					triangle { <-30.6962, 178.346, -57.7253>, <-31.08401, 178.4106, -56.8268>, <-30.2871, 178.4599, -56.8493> }
					triangle { <-30.6962, 178.346, -57.7253>, <-31.3558, 177.6629, -57.8325>, <-31.08401, 178.4106, -56.8268> }
					triangle { <-31.3558, 177.6629, -57.8325>, <-32.135, 176.766, -57.3335>, <-32.06356, 177.8955, -56.3764> }
					triangle { <-32.135, 176.766, -57.3335>, <-32.9406, 176.1108, -56.7011>, <-32.6969, 177.3848, -55.9865> }
					triangle { <-32.135, 176.766, -57.3335>, <-32.6969, 177.3848, -55.9865>, <-32.06356, 177.8955, -56.3764> }
					triangle { <-32.9406, 176.1108, -56.7011>, <-33.8659, 175.5573, -55.9428>, <-33.8319, 176.2983, -55.09345> }
					triangle { <-32.9406, 176.1108, -56.7011>, <-33.8319, 176.2983, -55.09345>, <-32.6969, 177.3848, -55.9865> }
					triangle { <-33.8659, 175.5573, -55.9428>, <-35.02969, 177.7422, -55.01768>, <-34.8641, 177.3797, -54.6317> }
					triangle { <-33.8659, 175.5573, -55.9428>, <-34.8641, 177.3797, -54.6317>, <-33.8319, 176.2983, -55.09345> }
					triangle { <-33.8319, 176.2983, -55.09345>, <-34.8641, 177.3797, -54.6317>, <-34.5448, 177.2422, -54.1527> }
					triangle { <-30.2871, 178.4599, -56.8493>, <-31.08401, 178.4106, -56.8268>, <-31.6827, 177.7381, -56.01603> }
					triangle { <-31.08401, 178.4106, -56.8268>, <-32.06356, 177.8955, -56.3764>, <-31.6827, 177.7381, -56.01603> }
					triangle { <-32.06356, 177.8955, -56.3764>, <-32.6969, 177.3848, -55.9865>, <-31.6827, 177.7381, -56.01603> }
					triangle { <-32.6969, 177.3848, -55.9865>, <-33.5658, 176.5763, -54.4216>, <-31.6827, 177.7381, -56.01603> }
					triangle { <-32.6969, 177.3848, -55.9865>, <-33.8319, 176.2983, -55.09345>, <-33.5658, 176.5763, -54.4216> }
					triangle { <-33.8319, 176.2983, -55.09345>, <-34.5448, 177.2422, -54.1527>, <-33.5658, 176.5763, -54.4216> }
					triangle { <-34.5448, 177.2422, -54.1527>, <-34.1651, 177.1219, -53.6625>, <-33.5658, 176.5763, -54.4216> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-30.2871, 178.4599, -56.8493>, <-30.1251, 178.7651, -56.2018> }
					triangle { <-30.2871, 178.4599, -56.8493>, <-31.6827, 177.7381, -56.01603>, <-30.1251, 178.7651, -56.2018> }
					triangle { <-31.6827, 177.7381, -56.01603>, <-31.2961, 178.0504, -55.3217>, <-30.1251, 178.7651, -56.2018> }
					triangle { <-31.6827, 177.7381, -56.01603>, <-33.5658, 176.5763, -54.4216>, <-31.2961, 178.0504, -55.3217> }
					triangle { <-31.2961, 178.0504, -55.3217>, <-33.5658, 176.5763, -54.4216>, <-33.2379, 176.9023, -53.7942> }
					triangle { <-33.5658, 176.5763, -54.4216>, <-34.1651, 177.1219, -53.6625>, <-33.2379, 176.9023, -53.7942> }
					triangle { <-34.1651, 177.1219, -53.6625>, <-33.8257, 177.1757, -53.2224>, <-33.2379, 176.9023, -53.7942> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-30.1583, 179.032, -57.5109>, <-30.6962, 178.346, -57.7253> }
					triangle { <-29.5833, 178.2948, -56.047>, <-28.8194, 177.9058, -55.5857>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-29.735, 178.0941, -55.2889>, <-30.4213, 177.5103, -54.5042>, <-28.9512, 177.0988, -55.09105> }
					triangle { <-29.5833, 178.2948, -56.047>, <-29.735, 178.0941, -55.2889>, <-28.8194, 177.9058, -55.5857> }
					triangle { <-29.735, 178.0941, -55.2889>, <-28.9512, 177.0988, -55.09105>, <-28.8194, 177.9058, -55.5857> }
					triangle { <-30.4213, 177.5103, -54.5042>, <-29.7304, 176.2019, -54.5921>, <-28.9512, 177.0988, -55.09105> }
					triangle { <-30.996, 176.9858, -54.0475>, <-30.5946, 175.5605, -54.02658>, <-29.7304, 176.2019, -54.5921> }
					triangle { <-30.4213, 177.5103, -54.5042>, <-30.996, 176.9858, -54.0475>, <-29.7304, 176.2019, -54.5921> }
					triangle { <-32.2483, 175.9268, -53.2881>, <-31.5785, 175.0208, -53.3351>, <-30.5946, 175.5605, -54.02658> }
					triangle { <-30.996, 176.9858, -54.0475>, <-32.2483, 175.9268, -53.2881>, <-30.5946, 175.5605, -54.02658> }
					triangle { <-32.8439, 176.8432, -52.2136>, <-32.3049, 176.9357, -52.00122>, <-31.5785, 175.0208, -53.3351> }
					triangle { <-32.2483, 175.9268, -53.2881>, <-32.8439, 176.8432, -52.2136>, <-31.5785, 175.0208, -53.3351> }
					triangle { <-33.2552, 177.0446, -52.4777>, <-32.8439, 176.8432, -52.2136>, <-32.2483, 175.9268, -53.2881> }
					triangle { <-30.7443, 177.518, -54.9461>, <-29.735, 178.0941, -55.2889>, <-29.5833, 178.2948, -56.047> }
					triangle { <-30.7443, 177.518, -54.9461>, <-30.4213, 177.5103, -54.5042>, <-29.735, 178.0941, -55.2889> }
					triangle { <-30.7443, 177.518, -54.9461>, <-30.996, 176.9858, -54.0475>, <-30.4213, 177.5103, -54.5042> }
					triangle { <-30.7443, 177.518, -54.9461>, <-32.8033, 176.3974, -53.5524>, <-30.996, 176.9858, -54.0475> }
					triangle { <-32.8033, 176.3974, -53.5524>, <-32.2483, 175.9268, -53.2881>, <-30.996, 176.9858, -54.0475> }
					triangle { <-32.8033, 176.3974, -53.5524>, <-33.2552, 177.0446, -52.4777>, <-32.2483, 175.9268, -53.2881> }
					triangle { <-32.8033, 176.3974, -53.5524>, <-33.5778, 177.1203, -52.8455>, <-33.2552, 177.0446, -52.4777> }
					triangle { <-30.1251, 178.7651, -56.2018>, <-29.5833, 178.2948, -56.047>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-30.1251, 178.7651, -56.2018>, <-30.7443, 177.518, -54.9461>, <-29.5833, 178.2948, -56.047> }
					triangle { <-30.1251, 178.7651, -56.2018>, <-31.2961, 178.0504, -55.3217>, <-30.7443, 177.518, -54.9461> }
					triangle { <-31.2961, 178.0504, -55.3217>, <-32.8033, 176.3974, -53.5524>, <-30.7443, 177.518, -54.9461> }
					triangle { <-33.2379, 176.9023, -53.7942>, <-32.8033, 176.3974, -53.5524>, <-31.2961, 178.0504, -55.3217> }
					triangle { <-33.2379, 176.9023, -53.7942>, <-33.5778, 177.1203, -52.8455>, <-32.8033, 176.3974, -53.5524> }
					triangle { <-33.2379, 176.9023, -53.7942>, <-33.8257, 177.1757, -53.2224>, <-33.5778, 177.1203, -52.8455> }
					triangle { <-28.8194, 177.9058, -55.5857>, <-28.8093, 178.7156, -55.973>, <-29.1393, 178.6061, -57.09924> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.1393, 178.6061, -57.09924>, <-29.2955, 176.9281, -57.3075>, <-29.8809, 177.6837, -57.1231> }
					triangle { <-29.4272, 176.1211, -56.8128>, <-31.06108, 176.1965, -56.8179>, <-30.2706, 176.9942, -57.226> }
					triangle { <-29.2955, 176.9281, -57.3075>, <-30.2706, 176.9942, -57.226>, <-29.8809, 177.6837, -57.1231> }
					triangle { <-29.2955, 176.9281, -57.3075>, <-29.4272, 176.1211, -56.8128>, <-30.2706, 176.9942, -57.226> }
					triangle { <-29.4272, 176.1211, -56.8128>, <-30.1172, 175.4075, -55.9911>, <-31.06108, 176.1965, -56.8179> }
					triangle { <-30.1172, 175.4075, -55.9911>, <-30.9666, 174.7967, -55.3717>, <-31.6358, 175.672, -56.3612> }
					triangle { <-30.1172, 175.4075, -55.9911>, <-31.6358, 175.672, -56.3612>, <-31.06108, 176.1965, -56.8179> }
					triangle { <-30.9666, 174.7967, -55.3717>, <-31.9951, 174.1653, -54.8417>, <-32.8136, 174.7658, -55.3327> }
					triangle { <-30.9666, 174.7967, -55.3717>, <-32.8136, 174.7658, -55.3327>, <-31.6358, 175.672, -56.3612> }
					triangle { <-31.9951, 174.1653, -54.8417>, <-33.6278, 174.1793, -56.9198>, <-33.8405, 174.3821, -56.4492> }
					triangle { <-31.9951, 174.1653, -54.8417>, <-33.8405, 174.3821, -56.4492>, <-32.8136, 174.7658, -55.3327> }
					triangle { <-32.8136, 174.7658, -55.3327>, <-33.8405, 174.3821, -56.4492>, <-34.09022, 174.8207, -56.14> }
					triangle { <-29.8809, 177.6837, -57.1231>, <-30.2706, 176.9942, -57.226>, <-31.1758, 176.632, -56.5065> }
					triangle { <-30.2706, 176.9942, -57.226>, <-31.06108, 176.1965, -56.8179>, <-31.1758, 176.632, -56.5065> }
					triangle { <-31.06108, 176.1965, -56.8179>, <-31.6358, 175.672, -56.3612>, <-31.1758, 176.632, -56.5065> }
					triangle { <-31.6358, 175.672, -56.3612>, <-33.3092, 175.3586, -55.3818>, <-31.1758, 176.632, -56.5065> }
					triangle { <-31.6358, 175.672, -56.3612>, <-32.8136, 174.7658, -55.3327>, <-33.3092, 175.3586, -55.3818> }
					triangle { <-32.8136, 174.7658, -55.3327>, <-34.09022, 174.8207, -56.14>, <-33.3092, 175.3586, -55.3818> }
					triangle { <-34.09022, 174.8207, -56.14>, <-34.3234, 175.3207, -55.8325>, <-33.3092, 175.3586, -55.3818> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-29.8809, 177.6837, -57.1231>, <-30.4078, 178.1846, -57.2242> }
					triangle { <-29.8809, 177.6837, -57.1231>, <-31.1758, 176.632, -56.5065>, <-30.4078, 178.1846, -57.2242> }
					triangle { <-31.1758, 176.632, -56.5065>, <-31.6383, 177.3477, -56.5592>, <-30.4078, 178.1846, -57.2242> }
					triangle { <-31.1758, 176.632, -56.5065>, <-33.3092, 175.3586, -55.3818>, <-31.6383, 177.3477, -56.5592> }
					triangle { <-31.6383, 177.3477, -56.5592>, <-33.3092, 175.3586, -55.3818>, <-33.7428, 175.9995, -55.4753> }
					triangle { <-33.3092, 175.3586, -55.3818>, <-34.3234, 175.3207, -55.8325>, <-33.7428, 175.9995, -55.4753> }
					triangle { <-34.3234, 175.3207, -55.8325>, <-34.5538, 175.8145, -55.7105>, <-33.7428, 175.9995, -55.4753> }
					triangle { <-29.1393, 178.6061, -57.09924>, <-29.3151, 177.6768, -57.8025>, <-29.2955, 176.9281, -57.3075> }
					triangle { <-30.2276, 178.5821, -56.6341>, <-30.2201, 179.3237, -56.00357>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-30.9352, 178.7161, -56.2887>, <-31.8701, 178.2927, -55.6769>, <-30.6119, 179.1905, -55.1421> }
					triangle { <-30.2276, 178.5821, -56.6341>, <-30.9352, 178.7161, -56.2887>, <-30.2201, 179.3237, -56.00357> }
					triangle { <-30.9352, 178.7161, -56.2887>, <-30.6119, 179.1905, -55.1421>, <-30.2201, 179.3237, -56.00357> }
					triangle { <-31.8701, 178.2927, -55.6769>, <-31.3019, 178.4769, -54.3204>, <-30.6119, 179.1905, -55.1421> }
					triangle { <-32.4737, 177.8431, -55.1794>, <-32.1224, 177.7912, -53.7417>, <-31.3019, 178.4769, -54.3204> }
					triangle { <-31.8701, 178.2927, -55.6769>, <-32.4737, 177.8431, -55.1794>, <-31.3019, 178.4769, -54.3204> }
					triangle { <-33.5938, 176.7871, -54.2325>, <-33.122, 177.085, -53.2525>, <-32.1224, 177.7912, -53.7417> }
					triangle { <-32.4737, 177.8431, -55.1794>, <-33.5938, 176.7871, -54.2325>, <-32.1224, 177.7912, -53.7417> }
					triangle { <-34.9281, 176.9917, -54.9582>, <-34.8706, 177.5715, -54.8894>, <-33.122, 177.085, -53.2525> }
					triangle { <-33.5938, 176.7871, -54.2325>, <-34.9281, 176.9917, -54.9582>, <-33.122, 177.085, -53.2525> }
					triangle { <-34.9174, 176.5835, -55.2939>, <-34.9281, 176.9917, -54.9582>, <-33.5938, 176.7871, -54.2325> }
					triangle { <-31.6381, 177.8298, -55.8546>, <-30.9352, 178.7161, -56.2887>, <-30.2276, 178.5821, -56.6341> }
					triangle { <-31.6381, 177.8298, -55.8546>, <-31.8701, 178.2927, -55.6769>, <-30.9352, 178.7161, -56.2887> }
					triangle { <-31.6381, 177.8298, -55.8546>, <-32.4737, 177.8431, -55.1794>, <-31.8701, 178.2927, -55.6769> }
					triangle { <-31.6381, 177.8298, -55.8546>, <-33.6848, 176.3319, -54.8521>, <-32.4737, 177.8431, -55.1794> }
					triangle { <-33.6848, 176.3319, -54.8521>, <-33.5938, 176.7871, -54.2325>, <-32.4737, 177.8431, -55.1794> }
					triangle { <-33.6848, 176.3319, -54.8521>, <-34.9174, 176.5835, -55.2939>, <-33.5938, 176.7871, -54.2325> }
					triangle { <-33.6848, 176.3319, -54.8521>, <-34.7585, 176.1717, -55.518>, <-34.9174, 176.5835, -55.2939> }
					triangle { <-30.4078, 178.1846, -57.2242>, <-30.2276, 178.5821, -56.6341>, <-29.1393, 178.6061, -57.09924> }
					triangle { <-30.4078, 178.1846, -57.2242>, <-31.6381, 177.8298, -55.8546>, <-30.2276, 178.5821, -56.6341> }
					triangle { <-30.4078, 178.1846, -57.2242>, <-31.6383, 177.3477, -56.5592>, <-31.6381, 177.8298, -55.8546> }
					triangle { <-31.6383, 177.3477, -56.5592>, <-33.6848, 176.3319, -54.8521>, <-31.6381, 177.8298, -55.8546> }
					triangle { <-33.7428, 175.9995, -55.4753>, <-33.6848, 176.3319, -54.8521>, <-31.6383, 177.3477, -56.5592> }
					triangle { <-33.7428, 175.9995, -55.4753>, <-34.7585, 176.1717, -55.518>, <-33.6848, 176.3319, -54.8521> }
					triangle { <-33.7428, 175.9995, -55.4753>, <-34.5538, 175.8145, -55.7105>, <-34.7585, 176.1717, -55.518> }
					triangle { <-30.2201, 179.3237, -56.00357>, <-29.9797, 179.3987, -56.8652>, <-29.1393, 178.6061, -57.09924> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-27.9147, 178.4687, -57.3482>, <-28.07018, 179.3891, -57.707>, 0.55 }
			cylinder { <-28.07018, 179.3891, -57.707>, <-28.2584, 180.3076, -58.05484>, 0.55 }
			cylinder { <-28.2584, 180.3076, -58.05484>, <-28.4794, 181.223, -58.3912>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-28.4794, 181.223, -58.3912>, <-28.284, 181.6833, -58.3925>, 0.55 }
				cylinder { <-28.284, 181.6833, -58.3925>, <-27.8776, 181.9225, -58.2263>, 0.55 }
				cylinder { <-27.8776, 181.9225, -58.2263>, <-27.4576, 181.8247, -57.9733>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.4617, 180.465, -58.1809>, <-26.7335, 181.048, -57.4502> }
					triangle { <-25.542, 180.2126, -58.2416>, <-25.3194, 180.0345, -56.6311>, <-26.2817, 180.4319, -57.2174> }
					triangle { <-26.4617, 180.465, -58.1809>, <-26.2817, 180.4319, -57.2174>, <-26.7335, 181.048, -57.4502> }
					triangle { <-26.4617, 180.465, -58.1809>, <-25.542, 180.2126, -58.2416>, <-26.2817, 180.4319, -57.2174> }
					triangle { <-25.542, 180.2126, -58.2416>, <-24.353, 180.1738, -57.7464>, <-25.3194, 180.0345, -56.6311> }
					triangle { <-24.353, 180.1738, -57.7464>, <-23.3523, 180.0466, -57.06768>, <-24.5407, 179.8951, -56.1971> }
					triangle { <-24.353, 180.1738, -57.7464>, <-24.5407, 179.8951, -56.1971>, <-25.3194, 180.0345, -56.6311> }
					triangle { <-23.3523, 180.0466, -57.06768>, <-22.3724, 179.8182, -56.2162>, <-22.9907, 179.7933, -55.2734> }
					triangle { <-23.3523, 180.0466, -57.06768>, <-22.9907, 179.7933, -55.2734>, <-24.5407, 179.8951, -56.1971> }
					triangle { <-22.3724, 179.8182, -56.2162>, <-23.6117, 178.1697, -54.5637>, <-23.3699, 178.6082, -54.3248> }
					triangle { <-22.3724, 179.8182, -56.2162>, <-23.3699, 178.6082, -54.3248>, <-22.9907, 179.7933, -55.2734> }
					triangle { <-22.9907, 179.7933, -55.2734>, <-23.3699, 178.6082, -54.3248>, <-23.3963, 179.0984, -53.9941> }
					triangle { <-26.7335, 181.048, -57.4502>, <-26.2817, 180.4319, -57.2174>, <-25.365, 180.5427, -56.4328> }
					triangle { <-26.2817, 180.4319, -57.2174>, <-25.3194, 180.0345, -56.6311>, <-25.365, 180.5427, -56.4328> }
					triangle { <-25.3194, 180.0345, -56.6311>, <-24.5407, 179.8951, -56.1971>, <-25.365, 180.5427, -56.4328> }
					triangle { <-24.5407, 179.8951, -56.1971>, <-23.3382, 180.1123, -54.6595>, <-25.365, 180.5427, -56.4328> }
					triangle { <-24.5407, 179.8951, -56.1971>, <-22.9907, 179.7933, -55.2734>, <-23.3382, 180.1123, -54.6595> }
					triangle { <-22.9907, 179.7933, -55.2734>, <-23.3963, 179.0984, -53.9941>, <-23.3382, 180.1123, -54.6595> }
					triangle { <-23.3963, 179.0984, -53.9941>, <-23.4679, 179.6333, -53.666>, <-23.3382, 180.1123, -54.6595> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.7335, 181.048, -57.4502>, <-27.05197, 181.2613, -56.8243> }
					triangle { <-26.7335, 181.048, -57.4502>, <-25.365, 180.5427, -56.4328>, <-27.05197, 181.2613, -56.8243> }
					triangle { <-25.365, 180.5427, -56.4328>, <-25.8027, 180.9513, -55.8242>, <-27.05197, 181.2613, -56.8243> }
					triangle { <-25.365, 180.5427, -56.4328>, <-23.3382, 180.1123, -54.6595>, <-25.8027, 180.9513, -55.8242> }
					triangle { <-25.8027, 180.9513, -55.8242>, <-23.3382, 180.1123, -54.6595>, <-23.7604, 180.4436, -54.09429> }
					triangle { <-23.3382, 180.1123, -54.6595>, <-23.4679, 179.6333, -53.666>, <-23.7604, 180.4436, -54.09429> }
					triangle { <-23.4679, 179.6333, -53.666>, <-23.6701, 180.0367, -53.3369>, <-23.7604, 180.4436, -54.09429> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-27.3171, 180.6545, -57.9851>, <-26.4617, 180.465, -58.1809> }
					triangle { <-26.9201, 181.9756, -56.9295>, <-26.9594, 182.9386, -56.7924>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-26.6394, 182.2098, -56.2194>, <-25.7549, 182.1989, -55.4162>, <-26.1797, 183.3819, -56.4626> }
					triangle { <-26.9201, 181.9756, -56.9295>, <-26.6394, 182.2098, -56.2194>, <-26.9594, 182.9386, -56.7924> }
					triangle { <-26.6394, 182.2098, -56.2194>, <-26.1797, 183.3819, -56.4626>, <-26.9594, 182.9386, -56.7924> }
					triangle { <-25.7549, 182.1989, -55.4162>, <-24.9907, 183.3431, -55.9674>, <-26.1797, 183.3819, -56.4626> }
					triangle { <-24.9918, 182.1369, -54.9388>, <-23.9744, 183.1386, -55.332>, <-24.9907, 183.3431, -55.9674> }
					triangle { <-25.7549, 182.1989, -55.4162>, <-24.9918, 182.1369, -54.9388>, <-24.9907, 183.3431, -55.9674> }
					triangle { <-23.4106, 181.8804, -54.1019>, <-22.9789, 182.8329, -54.5239>, <-23.9744, 183.1386, -55.332> }
					triangle { <-24.9918, 182.1369, -54.9388>, <-23.4106, 181.8804, -54.1019>, <-23.9744, 183.1386, -55.332> }
					triangle { <-23.8474, 181.3401, -52.7358>, <-24.1944, 181.8083, -52.6675>, <-22.9789, 182.8329, -54.5239> }
					triangle { <-23.4106, 181.8804, -54.1019>, <-23.8474, 181.3401, -52.7358>, <-22.9789, 182.8329, -54.5239> }
					triangle { <-23.8199, 180.8199, -52.826>, <-23.8474, 181.3401, -52.7358>, <-23.4106, 181.8804, -54.1019> }
					triangle { <-25.6138, 181.7795, -55.7386>, <-26.6394, 182.2098, -56.2194>, <-26.9201, 181.9756, -56.9295> }
					triangle { <-25.6138, 181.7795, -55.7386>, <-25.7549, 182.1989, -55.4162>, <-26.6394, 182.2098, -56.2194> }
					triangle { <-25.6138, 181.7795, -55.7386>, <-24.9918, 182.1369, -54.9388>, <-25.7549, 182.1989, -55.4162> }
					triangle { <-25.6138, 181.7795, -55.7386>, <-23.5404, 181.1172, -54.09547>, <-24.9918, 182.1369, -54.9388> }
					triangle { <-23.5404, 181.1172, -54.09547>, <-23.4106, 181.8804, -54.1019>, <-24.9918, 182.1369, -54.9388> }
					triangle { <-23.5404, 181.1172, -54.09547>, <-23.8199, 180.8199, -52.826>, <-23.4106, 181.8804, -54.1019> }
					triangle { <-23.5404, 181.1172, -54.09547>, <-23.7344, 180.3948, -53.06469>, <-23.8199, 180.8199, -52.826> }
					triangle { <-27.05197, 181.2613, -56.8243>, <-26.9201, 181.9756, -56.9295>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-27.05197, 181.2613, -56.8243>, <-25.6138, 181.7795, -55.7386>, <-26.9201, 181.9756, -56.9295> }
					triangle { <-27.05197, 181.2613, -56.8243>, <-25.8027, 180.9513, -55.8242>, <-25.6138, 181.7795, -55.7386> }
					triangle { <-25.8027, 180.9513, -55.8242>, <-23.5404, 181.1172, -54.09547>, <-25.6138, 181.7795, -55.7386> }
					triangle { <-23.7604, 180.4436, -54.09429>, <-23.5404, 181.1172, -54.09547>, <-25.8027, 180.9513, -55.8242> }
					triangle { <-23.7604, 180.4436, -54.09429>, <-23.7344, 180.3948, -53.06469>, <-23.5404, 181.1172, -54.09547> }
					triangle { <-23.7604, 180.4436, -54.09429>, <-23.6701, 180.0367, -53.3369>, <-23.7344, 180.3948, -53.06469> }
					triangle { <-26.9594, 182.9386, -56.7924>, <-27.6748, 182.4324, -56.9871>, <-27.4576, 181.8247, -57.9733> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-27.4576, 181.8247, -57.9733>, <-25.947, 182.4126, -58.4792>, <-26.2873, 181.6468, -57.9838> }
					triangle { <-25.1672, 182.8559, -58.1495>, <-24.3944, 181.4921, -57.6829>, <-25.5004, 181.6181, -58.1171> }
					triangle { <-25.947, 182.4126, -58.4792>, <-25.5004, 181.6181, -58.1171>, <-26.2873, 181.6468, -57.9838> }
					triangle { <-25.947, 182.4126, -58.4792>, <-25.1672, 182.8559, -58.1495>, <-25.5004, 181.6181, -58.1171> }
					triangle { <-25.1672, 182.8559, -58.1495>, <-24.1681, 182.9158, -57.3379>, <-24.3944, 181.4921, -57.6829> }
					triangle { <-24.1681, 182.9158, -57.3379>, <-23.1835, 182.7277, -56.6499>, <-23.6313, 181.43, -57.2055> }
					triangle { <-24.1681, 182.9158, -57.3379>, <-23.6313, 181.43, -57.2055>, <-24.3944, 181.4921, -57.6829> }
					triangle { <-23.1835, 182.7277, -56.6499>, <-22.09308, 182.3727, -55.9999>, <-22.2083, 181.2558, -56.105> }
					triangle { <-23.1835, 182.7277, -56.6499>, <-22.2083, 181.2558, -56.105>, <-23.6313, 181.43, -57.2055> }
					triangle { <-22.09308, 182.3727, -55.9999>, <-21.3525, 180.3186, -57.4887>, <-21.3982, 180.2142, -56.9458> }
					triangle { <-22.09308, 182.3727, -55.9999>, <-21.3982, 180.2142, -56.9458>, <-22.2083, 181.2558, -56.105> }
					triangle { <-22.2083, 181.2558, -56.105>, <-21.3982, 180.2142, -56.9458>, <-21.6337, 179.9131, -56.4939> }
					triangle { <-26.2873, 181.6468, -57.9838>, <-25.5004, 181.6181, -58.1171>, <-24.6963, 181.3028, -57.2673> }
					triangle { <-25.5004, 181.6181, -58.1171>, <-24.3944, 181.4921, -57.6829>, <-24.6963, 181.3028, -57.2673> }
					triangle { <-24.3944, 181.4921, -57.6829>, <-23.6313, 181.43, -57.2055>, <-24.6963, 181.3028, -57.2673> }
					triangle { <-23.6313, 181.43, -57.2055>, <-22.4646, 180.5583, -55.8877>, <-24.6963, 181.3028, -57.2673> }
					triangle { <-23.6313, 181.43, -57.2055>, <-22.2083, 181.2558, -56.105>, <-22.4646, 180.5583, -55.8877> }
					triangle { <-22.2083, 181.2558, -56.105>, <-21.6337, 179.9131, -56.4939>, <-22.4646, 180.5583, -55.8877> }
					triangle { <-21.6337, 179.9131, -56.4939>, <-21.9304, 179.596, -56.03531>, <-22.4646, 180.5583, -55.8877> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.2873, 181.6468, -57.9838>, <-26.4508, 180.949, -57.8258> }
					triangle { <-26.2873, 181.6468, -57.9838>, <-24.6963, 181.3028, -57.2673>, <-26.4508, 180.949, -57.8258> }
					triangle { <-24.6963, 181.3028, -57.2673>, <-25.07508, 180.5732, -57.03662>, <-26.4508, 180.949, -57.8258> }
					triangle { <-24.6963, 181.3028, -57.2673>, <-22.4646, 180.5583, -55.8877>, <-25.07508, 180.5732, -57.03662> }
					triangle { <-25.07508, 180.5732, -57.03662>, <-22.4646, 180.5583, -55.8877>, <-22.7956, 179.8731, -55.719> }
					triangle { <-22.4646, 180.5583, -55.8877>, <-21.9304, 179.596, -56.03531>, <-22.7956, 179.8731, -55.719> }
					triangle { <-21.9304, 179.596, -56.03531>, <-22.2308, 179.2197, -55.7525>, <-22.7956, 179.8731, -55.719> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.5991, 181.8735, -58.7794>, <-25.947, 182.4126, -58.4792> }
					triangle { <-26.86, 181.1137, -57.2393>, <-27.4742, 180.991, -56.494>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-26.5981, 180.5963, -56.6902>, <-25.7307, 180.2482, -55.9458>, <-27.124, 181.0345, -55.6059> }
					triangle { <-26.86, 181.1137, -57.2393>, <-26.5981, 180.5963, -56.6902>, <-27.4742, 180.991, -56.494> }
					triangle { <-26.5981, 180.5963, -56.6902>, <-27.124, 181.0345, -55.6059>, <-27.4742, 180.991, -56.494> }
					triangle { <-25.7307, 180.2482, -55.9458>, <-26.1248, 181.0943, -54.7944>, <-27.124, 181.0345, -55.6059> }
					triangle { <-25.01538, 180.1417, -55.4064>, <-25.09254, 180.9507, -54.1684>, <-26.1248, 181.0943, -54.7944> }
					triangle { <-25.7307, 180.2482, -55.9458>, <-25.01538, 180.1417, -55.4064>, <-26.1248, 181.0943, -54.7944> }
					triangle { <-23.4969, 180.0563, -54.43>, <-23.9544, 180.6401, -53.5805>, <-25.09254, 180.9507, -54.1684> }
					triangle { <-25.01538, 180.1417, -55.4064>, <-23.4969, 180.0563, -54.43>, <-25.09254, 180.9507, -54.1684> }
					triangle { <-23.01777, 178.6248, -54.6948>, <-23.5417, 178.4235, -54.5239>, <-23.9544, 180.6401, -53.5805> }
					triangle { <-23.4969, 180.0563, -54.43>, <-23.01777, 178.6248, -54.6948>, <-23.9544, 180.6401, -53.5805> }
					triangle { <-22.6868, 178.7084, -55.09847>, <-23.01777, 178.6248, -54.6948>, <-23.4969, 180.0563, -54.43> }
					triangle { <-25.4599, 180.592, -56.2747>, <-26.5981, 180.5963, -56.6902>, <-26.86, 181.1137, -57.2393> }
					triangle { <-25.4599, 180.592, -56.2747>, <-25.7307, 180.2482, -55.9458>, <-26.5981, 180.5963, -56.6902> }
					triangle { <-25.4599, 180.592, -56.2747>, <-25.01538, 180.1417, -55.4064>, <-25.7307, 180.2482, -55.9458> }
					triangle { <-25.4599, 180.592, -56.2747>, <-23.0851, 179.9808, -55.08125>, <-25.01538, 180.1417, -55.4064> }
					triangle { <-23.0851, 179.9808, -55.08125>, <-23.4969, 180.0563, -54.43>, <-25.01538, 180.1417, -55.4064> }
					triangle { <-23.0851, 179.9808, -55.08125>, <-22.6868, 178.7084, -55.09847>, <-23.4969, 180.0563, -54.43> }
					triangle { <-23.0851, 179.9808, -55.08125>, <-22.4243, 178.9527, -55.4396>, <-22.6868, 178.7084, -55.09847> }
					triangle { <-26.4508, 180.949, -57.8258>, <-26.86, 181.1137, -57.2393>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-26.4508, 180.949, -57.8258>, <-25.4599, 180.592, -56.2747>, <-26.86, 181.1137, -57.2393> }
					triangle { <-26.4508, 180.949, -57.8258>, <-25.07508, 180.5732, -57.03662>, <-25.4599, 180.592, -56.2747> }
					triangle { <-25.07508, 180.5732, -57.03662>, <-23.0851, 179.9808, -55.08125>, <-25.4599, 180.592, -56.2747> }
					triangle { <-22.7956, 179.8731, -55.719>, <-23.0851, 179.9808, -55.08125>, <-25.07508, 180.5732, -57.03662> }
					triangle { <-22.7956, 179.8731, -55.719>, <-22.4243, 178.9527, -55.4396>, <-23.0851, 179.9808, -55.08125> }
					triangle { <-22.7956, 179.8731, -55.719>, <-22.2308, 179.2197, -55.7525>, <-22.4243, 178.9527, -55.4396> }
					triangle { <-27.4742, 180.991, -56.494>, <-27.6968, 180.8517, -57.3525>, <-27.4576, 181.8247, -57.9733> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.9594, 182.9386, -56.7924>, <-26.5383, 182.331, -57.4258> }
					triangle { <-26.6092, 182.9821, -55.9043>, <-25.03904, 182.8653, -56.3467>, <-26.019, 182.7873, -57.02592> }
					triangle { <-26.9594, 182.9386, -56.7924>, <-26.019, 182.7873, -57.02592>, <-26.5383, 182.331, -57.4258> }
					triangle { <-26.9594, 182.9386, -56.7924>, <-26.6092, 182.9821, -55.9043>, <-26.019, 182.7873, -57.02592> }
					triangle { <-26.6092, 182.9821, -55.9043>, <-25.7066, 182.6768, -55.03685>, <-25.03904, 182.8653, -56.3467> }
					triangle { <-25.7066, 182.6768, -55.03685>, <-24.6903, 182.4722, -54.4015>, <-24.3236, 182.7588, -55.8073> }
					triangle { <-25.7066, 182.6768, -55.03685>, <-24.3236, 182.7588, -55.8073>, <-25.03904, 182.8653, -56.3467> }
					triangle { <-24.6903, 182.4722, -54.4015>, <-23.5039, 182.3442, -53.8415>, <-22.8856, 182.3691, -54.7843> }
					triangle { <-24.6903, 182.4722, -54.4015>, <-22.8856, 182.3691, -54.7843>, <-24.3236, 182.7588, -55.8073> }
					triangle { <-23.5039, 182.3442, -53.8415>, <-22.1152, 183.9681, -55.3967>, <-21.9087, 183.4559, -55.3436> }
					triangle { <-23.5039, 182.3442, -53.8415>, <-21.9087, 183.4559, -55.3436>, <-22.8856, 182.3691, -54.7843> }
					triangle { <-22.8856, 182.3691, -54.7843>, <-21.9087, 183.4559, -55.3436>, <-21.7329, 182.9412, -55.5769> }
					triangle { <-26.5383, 182.331, -57.4258>, <-26.019, 182.7873, -57.02592>, <-24.9934, 182.357, -56.545> }
					triangle { <-26.019, 182.7873, -57.02592>, <-25.03904, 182.8653, -56.3467>, <-24.9934, 182.357, -56.545> }
					triangle { <-25.03904, 182.8653, -56.3467>, <-24.3236, 182.7588, -55.8073>, <-24.9934, 182.357, -56.545> }
					triangle { <-24.3236, 182.7588, -55.8073>, <-22.5381, 182.0501, -55.3982>, <-24.9934, 182.357, -56.545> }
					triangle { <-24.3236, 182.7588, -55.8073>, <-22.8856, 182.3691, -54.7843>, <-22.5381, 182.0501, -55.3982> }
					triangle { <-22.8856, 182.3691, -54.7843>, <-21.7329, 182.9412, -55.5769>, <-22.5381, 182.0501, -55.3982> }
					triangle { <-21.7329, 182.9412, -55.5769>, <-21.5867, 182.3939, -55.8563>, <-22.5381, 182.0501, -55.3982> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.5383, 182.331, -57.4258>, <-26.1451, 182.1054, -58.00303> }
					triangle { <-26.5383, 182.331, -57.4258>, <-24.9934, 182.357, -56.545>, <-26.1451, 182.1054, -58.00303> }
					triangle { <-24.9934, 182.357, -56.545>, <-24.705, 181.973, -57.251>, <-26.1451, 182.1054, -58.00303> }
					triangle { <-24.9934, 182.357, -56.545>, <-22.5381, 182.0501, -55.3982>, <-24.705, 181.973, -57.251> }
					triangle { <-24.705, 181.973, -57.251>, <-22.5381, 182.0501, -55.3982>, <-22.2653, 181.7434, -56.06083> }
					triangle { <-22.5381, 182.0501, -55.3982>, <-21.5867, 182.3939, -55.8563>, <-22.2653, 181.7434, -56.06083> }
					triangle { <-21.5867, 182.3939, -55.8563>, <-21.4592, 182.0029, -56.2341>, <-22.2653, 181.7434, -56.06083> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-27.1499, 182.9211, -57.6695>, <-26.9594, 182.9386, -56.7924> }
					triangle { <-26.3517, 181.4034, -57.9465>, <-26.4617, 180.465, -58.1809>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-25.6612, 181.0094, -58.02389>, <-24.6035, 180.7009, -57.5617>, <-25.9715, 179.8127, -57.6833> }
					triangle { <-26.3517, 181.4034, -57.9465>, <-25.6612, 181.0094, -58.02389>, <-26.4617, 180.465, -58.1809> }
					triangle { <-25.6612, 181.0094, -58.02389>, <-25.9715, 179.8127, -57.6833>, <-26.4617, 180.465, -58.1809> }
					triangle { <-24.6035, 180.7009, -57.5617>, <-25.06894, 179.5074, -56.8158>, <-25.9715, 179.8127, -57.6833> }
					triangle { <-23.8726, 180.5171, -57.06569>, <-24.06825, 179.3802, -56.1371>, <-25.06894, 179.5074, -56.8158> }
					triangle { <-24.6035, 180.7009, -57.5617>, <-23.8726, 180.5171, -57.06569>, <-25.06894, 179.5074, -56.8158> }
					triangle { <-22.4657, 180.282, -55.9558>, <-22.8974, 179.3295, -55.5337>, <-24.06825, 179.3802, -56.1371> }
					triangle { <-23.8726, 180.5171, -57.06569>, <-22.4657, 180.282, -55.9558>, <-24.06825, 179.3802, -56.1371> }
					triangle { <-21.2819, 180.6995, -56.8352>, <-21.4578, 180.3173, -57.2442>, <-22.8974, 179.3295, -55.5337> }
					triangle { <-22.4657, 180.282, -55.9558>, <-21.2819, 180.6995, -56.8352>, <-22.8974, 179.3295, -55.5337> }
					triangle { <-21.2346, 181.2073, -56.6963>, <-21.2819, 180.6995, -56.8352>, <-22.4657, 180.282, -55.9558> }
					triangle { <-24.7445, 181.1202, -57.2393>, <-25.6612, 181.0094, -58.02389>, <-26.3517, 181.4034, -57.9465> }
					triangle { <-24.7445, 181.1202, -57.2393>, <-24.6035, 180.7009, -57.5617>, <-25.6612, 181.0094, -58.02389> }
					triangle { <-24.7445, 181.1202, -57.2393>, <-23.8726, 180.5171, -57.06569>, <-24.6035, 180.7009, -57.5617> }
					triangle { <-24.7445, 181.1202, -57.2393>, <-22.3359, 181.0452, -55.9623>, <-23.8726, 180.5171, -57.06569> }
					triangle { <-22.3359, 181.0452, -55.9623>, <-22.4657, 180.282, -55.9558>, <-23.8726, 180.5171, -57.06569> }
					triangle { <-22.3359, 181.0452, -55.9623>, <-21.2346, 181.2073, -56.6963>, <-22.4657, 180.282, -55.9558> }
					triangle { <-22.3359, 181.0452, -55.9623>, <-21.3202, 181.6325, -56.4577>, <-21.2346, 181.2073, -56.6963> }
					triangle { <-26.1451, 182.1054, -58.00303>, <-26.3517, 181.4034, -57.9465>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-26.1451, 182.1054, -58.00303>, <-24.7445, 181.1202, -57.2393>, <-26.3517, 181.4034, -57.9465> }
					triangle { <-26.1451, 182.1054, -58.00303>, <-24.705, 181.973, -57.251>, <-24.7445, 181.1202, -57.2393> }
					triangle { <-24.705, 181.973, -57.251>, <-22.3359, 181.0452, -55.9623>, <-24.7445, 181.1202, -57.2393> }
					triangle { <-22.2653, 181.7434, -56.06083>, <-22.3359, 181.0452, -55.9623>, <-24.705, 181.973, -57.251> }
					triangle { <-22.2653, 181.7434, -56.06083>, <-21.3202, 181.6325, -56.4577>, <-22.3359, 181.0452, -55.9623> }
					triangle { <-22.2653, 181.7434, -56.06083>, <-21.4592, 182.0029, -56.2341>, <-21.3202, 181.6325, -56.4577> }
					triangle { <-26.4617, 180.465, -58.1809>, <-26.7921, 181.1432, -58.6675>, <-27.4576, 181.8247, -57.9733> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-27.4576, 181.8247, -57.9733>, <-27.4742, 180.991, -56.494>, <-26.9844, 181.7321, -56.8922> }
					triangle { <-26.984, 180.3388, -55.9964>, <-25.964, 181.4077, -55.295>, <-26.8003, 181.6012, -56.1262> }
					triangle { <-27.4742, 180.991, -56.494>, <-26.8003, 181.6012, -56.1262>, <-26.9844, 181.7321, -56.8922> }
					triangle { <-27.4742, 180.991, -56.494>, <-26.984, 180.3388, -55.9964>, <-26.8003, 181.6012, -56.1262> }
					triangle { <-26.984, 180.3388, -55.9964>, <-25.8915, 179.9348, -55.4452>, <-25.964, 181.4077, -55.295> }
					triangle { <-25.8915, 179.9348, -55.4452>, <-24.8592, 179.7911, -54.8192>, <-25.2331, 181.2239, -54.799> }
					triangle { <-25.8915, 179.9348, -55.4452>, <-25.2331, 181.2239, -54.799>, <-25.964, 181.4077, -55.295> }
					triangle { <-24.8592, 179.7911, -54.8192>, <-23.7833, 179.7898, -54.05781>, <-23.668, 180.9066, -53.9527> }
					triangle { <-24.8592, 179.7911, -54.8192>, <-23.668, 180.9066, -53.9527>, <-25.2331, 181.2239, -54.799> }
					triangle { <-23.7833, 179.7898, -54.05781>, <-24.3744, 181.8193, -52.4716>, <-23.8805, 181.8499, -52.7226> }
					triangle { <-23.7833, 179.7898, -54.05781>, <-23.8805, 181.8499, -52.7226>, <-23.668, 180.9066, -53.9527> }
					triangle { <-23.668, 180.9066, -53.9527>, <-23.8805, 181.8499, -52.7226>, <-23.4956, 182.1264, -53.07719> }
					triangle { <-26.9844, 181.7321, -56.8922>, <-26.8003, 181.6012, -56.1262>, <-25.6621, 181.5969, -55.7106> }
					triangle { <-26.8003, 181.6012, -56.1262>, <-25.964, 181.4077, -55.295>, <-25.6621, 181.5969, -55.7106> }
					triangle { <-25.964, 181.4077, -55.295>, <-25.2331, 181.2239, -54.799>, <-25.6621, 181.5969, -55.7106> }
					triangle { <-25.2331, 181.2239, -54.799>, <-23.4117, 181.6041, -54.17>, <-25.6621, 181.5969, -55.7106> }
					triangle { <-25.2331, 181.2239, -54.799>, <-23.668, 180.9066, -53.9527>, <-23.4117, 181.6041, -54.17> }
					triangle { <-23.668, 180.9066, -53.9527>, <-23.4956, 182.1264, -53.07719>, <-23.4117, 181.6041, -54.17> }
					triangle { <-23.4956, 182.1264, -53.07719>, <-23.1242, 182.4313, -53.4871>, <-23.4117, 181.6041, -54.17> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-26.9844, 181.7321, -56.8922>, <-26.7463, 182.4177, -57.00147> }
					triangle { <-26.9844, 181.7321, -56.8922>, <-25.6621, 181.5969, -55.7106>, <-26.7463, 182.4177, -57.00147> }
					triangle { <-25.6621, 181.5969, -55.7106>, <-25.4328, 182.3511, -56.03865>, <-26.7463, 182.4177, -57.00147> }
					triangle { <-25.6621, 181.5969, -55.7106>, <-23.4117, 181.6041, -54.17>, <-25.4328, 182.3511, -56.03865> }
					triangle { <-25.4328, 182.3511, -56.03865>, <-23.4117, 181.6041, -54.17>, <-23.2301, 182.3139, -54.436> }
					triangle { <-23.4117, 181.6041, -54.17>, <-23.1242, 182.4313, -53.4871>, <-23.2301, 182.3139, -54.436> }
					triangle { <-23.1242, 182.4313, -53.4871>, <-22.8985, 182.8199, -53.8186>, <-23.2301, 182.3139, -54.436> }
					triangle { <-27.4576, 181.8247, -57.9733>, <-27.8679, 181.7021, -56.8752>, <-27.4742, 180.991, -56.494> }
					triangle { <-26.4117, 182.2652, -57.6366>, <-25.947, 182.4126, -58.4792>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-25.7026, 182.623, -57.553>, <-24.6277, 182.6516, -57.03206>, <-25.02729, 182.1602, -58.54> }
					triangle { <-26.4117, 182.2652, -57.6366>, <-25.7026, 182.623, -57.553>, <-25.947, 182.4126, -58.4792> }
					triangle { <-25.7026, 182.623, -57.553>, <-25.02729, 182.1602, -58.54>, <-25.947, 182.4126, -58.4792> }
					triangle { <-24.6277, 182.6516, -57.03206>, <-23.9348, 181.7563, -57.9888>, <-25.02729, 182.1602, -58.54> }
					triangle { <-23.849, 182.5123, -56.598>, <-22.9502, 181.5681, -57.3007>, <-23.9348, 181.7563, -57.9888> }
					triangle { <-24.6277, 182.6516, -57.03206>, <-23.849, 182.5123, -56.598>, <-23.9348, 181.7563, -57.9888> }
					triangle { <-22.3794, 182.1061, -55.6277>, <-21.922, 181.5224, -56.4772>, <-22.9502, 181.5681, -57.3007> }
					triangle { <-23.849, 182.5123, -56.598>, <-22.3794, 182.1061, -55.6277>, <-22.9502, 181.5681, -57.3007> }
					triangle { <-22.1116, 183.4147, -54.8762>, <-22.1105, 183.7021, -55.3878>, <-21.922, 181.5224, -56.4772> }
					triangle { <-22.3794, 182.1061, -55.6277>, <-22.1116, 183.4147, -54.8762>, <-21.922, 181.5224, -56.4772> }
					triangle { <-22.3678, 183.3189, -54.4239>, <-22.1116, 183.4147, -54.8762>, <-22.3794, 182.1061, -55.6277> }
					triangle { <-24.8985, 182.3077, -56.7032>, <-25.7026, 182.623, -57.553>, <-26.4117, 182.2652, -57.6366> }
					triangle { <-24.8985, 182.3077, -56.7032>, <-24.6277, 182.6516, -57.03206>, <-25.7026, 182.623, -57.553> }
					triangle { <-24.8985, 182.3077, -56.7032>, <-23.849, 182.5123, -56.598>, <-24.6277, 182.6516, -57.03206> }
					triangle { <-24.8985, 182.3077, -56.7032>, <-22.7912, 182.1816, -54.9765>, <-23.849, 182.5123, -56.598> }
					triangle { <-22.7912, 182.1816, -54.9765>, <-22.3794, 182.1061, -55.6277>, <-23.849, 182.5123, -56.598> }
					triangle { <-22.7912, 182.1816, -54.9765>, <-22.3678, 183.3189, -54.4239>, <-22.3794, 182.1061, -55.6277> }
					triangle { <-22.7912, 182.1816, -54.9765>, <-22.6303, 183.0745, -54.08275>, <-22.3678, 183.3189, -54.4239> }
					triangle { <-26.7463, 182.4177, -57.00147>, <-26.4117, 182.2652, -57.6366>, <-27.4576, 181.8247, -57.9733> }
					triangle { <-26.7463, 182.4177, -57.00147>, <-24.8985, 182.3077, -56.7032>, <-26.4117, 182.2652, -57.6366> }
					triangle { <-26.7463, 182.4177, -57.00147>, <-25.4328, 182.3511, -56.03865>, <-24.8985, 182.3077, -56.7032> }
					triangle { <-25.4328, 182.3511, -56.03865>, <-22.7912, 182.1816, -54.9765>, <-24.8985, 182.3077, -56.7032> }
					triangle { <-23.2301, 182.3139, -54.436>, <-22.7912, 182.1816, -54.9765>, <-25.4328, 182.3511, -56.03865> }
					triangle { <-23.2301, 182.3139, -54.436>, <-22.6303, 183.0745, -54.08275>, <-22.7912, 182.1816, -54.9765> }
					triangle { <-23.2301, 182.3139, -54.436>, <-22.8985, 182.8199, -53.8186>, <-22.6303, 183.0745, -54.08275> }
					triangle { <-25.947, 182.4126, -58.4792>, <-26.7702, 182.7238, -58.3021>, <-27.4576, 181.8247, -57.9733> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-28.4794, 181.223, -58.3912>, <-28.6697, 182.1496, -58.7155>, 0.55 }
			cylinder { <-28.6697, 182.1496, -58.7155>, <-28.8294, 183.0863, -59.02725>, 0.55 }
			cylinder { <-28.8294, 183.0863, -59.02725>, <-28.958, 184.0319, -59.326>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-28.958, 184.0319, -59.326>, <-29.1142, 184.2837, -59.7287>, 0.55 }
				cylinder { <-29.1142, 184.2837, -59.7287>, <-29.2865, 184.1924, -60.1891>, 0.55 }
				cylinder { <-29.2865, 184.1924, -60.1891>, <-29.3912, 183.8022, -60.4837>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-29.3912, 183.8022, -60.4837>, <-30.4004, 182.6741, -59.7139>, <-29.6776, 182.6596, -60.3659> }
					triangle { <-31.1648, 182.1227, -59.872>, <-30.3238, 180.8512, -60.4645>, <-29.927, 181.9329, -60.148> }
					triangle { <-30.4004, 182.6741, -59.7139>, <-29.927, 181.9329, -60.148>, <-29.6776, 182.6596, -60.3659> }
					triangle { <-30.4004, 182.6741, -59.7139>, <-31.1648, 182.1227, -59.872>, <-29.927, 181.9329, -60.148> }
					triangle { <-31.1648, 182.1227, -59.872>, <-31.7632, 181.1972, -60.5397>, <-30.3238, 180.8512, -60.4645> }
					triangle { <-31.7632, 181.1972, -60.5397>, <-32.1079, 180.1913, -61.1293>, <-30.6554, 180.1074, -60.8529> }
					triangle { <-31.7632, 181.1972, -60.5397>, <-30.6554, 180.1074, -60.8529>, <-30.3238, 180.8512, -60.4645> }
					triangle { <-32.1079, 180.1913, -61.1293>, <-32.335, 179.0235, -61.6969>, <-31.2627, 178.6881, -61.7927> }
					triangle { <-32.1079, 180.1913, -61.1293>, <-31.2627, 178.6881, -61.7927>, <-30.6554, 180.1074, -60.8529> }
					triangle { <-32.335, 179.0235, -61.6969>, <-30.4708, 177.5885, -60.493>, <-30.467, 177.5659, -61.04736> }
					triangle { <-32.335, 179.0235, -61.6969>, <-30.467, 177.5659, -61.04736>, <-31.2627, 178.6881, -61.7927> }
					triangle { <-31.2627, 178.6881, -61.7927>, <-30.467, 177.5659, -61.04736>, <-30.1949, 177.6425, -61.5673> }
					triangle { <-29.6776, 182.6596, -60.3659>, <-29.927, 181.9329, -60.148>, <-30.1199, 181.0348, -60.9382> }
					triangle { <-29.927, 181.9329, -60.148>, <-30.3238, 180.8512, -60.4645>, <-30.1199, 181.0348, -60.9382> }
					triangle { <-30.3238, 180.8512, -60.4645>, <-30.6554, 180.1074, -60.8529>, <-30.1199, 181.0348, -60.9382> }
					triangle { <-30.6554, 180.1074, -60.8529>, <-30.5784, 178.6356, -62.1512>, <-30.1199, 181.0348, -60.9382> }
					triangle { <-30.6554, 180.1074, -60.8529>, <-31.2627, 178.6881, -61.7927>, <-30.5784, 178.6356, -62.1512> }
					triangle { <-31.2627, 178.6881, -61.7927>, <-30.1949, 177.6425, -61.5673>, <-30.5784, 178.6356, -62.1512> }
					triangle { <-30.1949, 177.6425, -61.5673>, <-29.8861, 177.7686, -62.1037>, <-30.5784, 178.6356, -62.1512> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-29.6776, 182.6596, -60.3659>, <-29.01693, 182.5244, -60.6554> }
					triangle { <-29.6776, 182.6596, -60.3659>, <-30.1199, 181.0348, -60.9382>, <-29.01693, 182.5244, -60.6554> }
					triangle { <-30.1199, 181.0348, -60.9382>, <-29.3624, 181.0811, -61.3295>, <-29.01693, 182.5244, -60.6554> }
					triangle { <-30.1199, 181.0348, -60.9382>, <-30.5784, 178.6356, -62.1512>, <-29.3624, 181.0811, -61.3295> }
					triangle { <-29.3624, 181.0811, -61.3295>, <-30.5784, 178.6356, -62.1512>, <-29.867, 178.6585, -62.4687> }
					triangle { <-30.5784, 178.6356, -62.1512>, <-29.8861, 177.7686, -62.1037>, <-29.867, 178.6585, -62.4687> }
					triangle { <-29.8861, 177.7686, -62.1037>, <-29.4876, 177.8818, -62.4782>, <-29.867, 178.6585, -62.4687> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-29.6044, 183.0691, -59.5858>, <-30.4004, 182.6741, -59.7139> }
					triangle { <-29.125, 182.9404, -61.2504>, <-28.9267, 183.4227, -62.07243>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-28.8678, 182.4709, -61.8431>, <-29.03446, 181.5063, -62.5282>, <-29.2767, 183.0819, -62.8938> }
					triangle { <-29.125, 182.9404, -61.2504>, <-28.8678, 182.4709, -61.8431>, <-28.9267, 183.4227, -62.07243> }
					triangle { <-28.8678, 182.4709, -61.8431>, <-29.2767, 183.0819, -62.8938>, <-28.9267, 183.4227, -62.07243> }
					triangle { <-29.03446, 181.5063, -62.5282>, <-29.8751, 182.1564, -63.5615>, <-29.2767, 183.0819, -62.8938> }
					triangle { <-29.3199, 180.7858, -62.9902>, <-30.2658, 181.1271, -64.07742>, <-29.8751, 182.1564, -63.5615> }
					triangle { <-29.03446, 181.5063, -62.5282>, <-29.3199, 180.7858, -62.9902>, <-29.8751, 182.1564, -63.5615> }
					triangle { <-30.01933, 179.3198, -63.7827>, <-30.5391, 179.936, -64.5713>, <-30.2658, 181.1271, -64.07742> }
					triangle { <-29.3199, 180.7858, -62.9902>, <-30.01933, 179.3198, -63.7827>, <-30.2658, 181.1271, -64.07742> }
					triangle { <-28.8594, 178.321, -63.7047>, <-28.5108, 178.7135, -63.9667>, <-30.5391, 179.936, -64.5713> }
					triangle { <-30.01933, 179.3198, -63.7827>, <-28.8594, 178.321, -63.7047>, <-30.5391, 179.936, -64.5713> }
					triangle { <-28.9815, 178.0681, -63.2568>, <-28.8594, 178.321, -63.7047>, <-30.01933, 179.3198, -63.7827> }
					triangle { <-29.3831, 181.4092, -62.1175>, <-28.8678, 182.4709, -61.8431>, <-29.125, 182.9404, -61.2504> }
					triangle { <-29.3831, 181.4092, -62.1175>, <-29.03446, 181.5063, -62.5282>, <-28.8678, 182.4709, -61.8431> }
					triangle { <-29.3831, 181.4092, -62.1175>, <-29.3199, 180.7858, -62.9902>, <-29.03446, 181.5063, -62.5282> }
					triangle { <-29.3831, 181.4092, -62.1175>, <-29.9798, 178.9397, -63.1093>, <-29.3199, 180.7858, -62.9902> }
					triangle { <-29.9798, 178.9397, -63.1093>, <-30.01933, 179.3198, -63.7827>, <-29.3199, 180.7858, -62.9902> }
					triangle { <-29.9798, 178.9397, -63.1093>, <-28.9815, 178.0681, -63.2568>, <-30.01933, 179.3198, -63.7827> }
					triangle { <-29.9798, 178.9397, -63.1093>, <-29.2348, 177.9395, -62.8515>, <-28.9815, 178.0681, -63.2568> }
					triangle { <-29.01693, 182.5244, -60.6554>, <-29.125, 182.9404, -61.2504>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-29.01693, 182.5244, -60.6554>, <-29.3831, 181.4092, -62.1175>, <-29.125, 182.9404, -61.2504> }
					triangle { <-29.01693, 182.5244, -60.6554>, <-29.3624, 181.0811, -61.3295>, <-29.3831, 181.4092, -62.1175> }
					triangle { <-29.3624, 181.0811, -61.3295>, <-29.9798, 178.9397, -63.1093>, <-29.3831, 181.4092, -62.1175> }
					triangle { <-29.867, 178.6585, -62.4687>, <-29.9798, 178.9397, -63.1093>, <-29.3624, 181.0811, -61.3295> }
					triangle { <-29.867, 178.6585, -62.4687>, <-29.2348, 177.9395, -62.8515>, <-29.9798, 178.9397, -63.1093> }
					triangle { <-29.867, 178.6585, -62.4687>, <-29.4876, 177.8818, -62.4782>, <-29.2348, 177.9395, -62.8515> }
					triangle { <-28.9267, 183.4227, -62.07243>, <-28.5453, 183.6072, -61.2809>, <-29.3912, 183.8022, -60.4837> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.3912, 183.8022, -60.4837>, <-30.8215, 183.7405, -61.397>, <-30.3092, 183.139, -60.8282> }
					triangle { <-31.1714, 183.3997, -62.2184>, <-31.5805, 181.9333, -61.6206>, <-30.9994, 182.8284, -61.08334> }
					triangle { <-30.8215, 183.7405, -61.397>, <-30.9994, 182.8284, -61.08334>, <-30.3092, 183.139, -60.8282> }
					triangle { <-30.8215, 183.7405, -61.397>, <-31.1714, 183.3997, -62.2184>, <-30.9994, 182.8284, -61.08334> }
					triangle { <-31.1714, 183.3997, -62.2184>, <-31.4146, 182.4146, -63.01273>, <-31.5805, 181.9333, -61.6206> }
					triangle { <-31.4146, 182.4146, -63.01273>, <-31.7461, 181.3754, -63.5497>, <-31.866, 181.2128, -62.08268> }
					triangle { <-31.4146, 182.4146, -63.01273>, <-31.866, 181.2128, -62.08268>, <-31.5805, 181.9333, -61.6206> }
					triangle { <-31.7461, 181.3754, -63.5497>, <-32.197, 180.214, -63.9803>, <-32.2693, 179.6971, -62.9806> }
					triangle { <-31.7461, 181.3754, -63.5497>, <-32.2693, 179.6971, -62.9806>, <-31.866, 181.2128, -62.08268> }
					triangle { <-32.197, 180.214, -63.9803>, <-33.8853, 179.6548, -62.02558>, <-33.5131, 179.2592, -62.1383> }
					triangle { <-32.197, 180.214, -63.9803>, <-33.5131, 179.2592, -62.1383>, <-32.2693, 179.6971, -62.9806> }
					triangle { <-32.2693, 179.6971, -62.9806>, <-33.5131, 179.2592, -62.1383>, <-33.06996, 178.9027, -61.9746> }
					triangle { <-30.3092, 183.139, -60.8282>, <-30.9994, 182.8284, -61.08334>, <-31.1002, 181.6971, -61.5054> }
					triangle { <-30.9994, 182.8284, -61.08334>, <-31.5805, 181.9333, -61.6206>, <-31.1002, 181.6971, -61.5054> }
					triangle { <-31.5805, 181.9333, -61.6206>, <-31.866, 181.2128, -62.08268>, <-31.1002, 181.6971, -61.5054> }
					triangle { <-31.866, 181.2128, -62.08268>, <-31.9929, 179.2774, -62.3917>, <-31.1002, 181.6971, -61.5054> }
					triangle { <-31.866, 181.2128, -62.08268>, <-32.2693, 179.6971, -62.9806>, <-31.9929, 179.2774, -62.3917> }
					triangle { <-32.2693, 179.6971, -62.9806>, <-33.06996, 178.9027, -61.9746>, <-31.9929, 179.2774, -62.3917> }
					triangle { <-33.06996, 178.9027, -61.9746>, <-32.5769, 178.5622, -61.7747>, <-31.9929, 179.2774, -62.3917> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-30.3092, 183.139, -60.8282>, <-30.1419, 182.7131, -60.2544> }
					triangle { <-30.3092, 183.139, -60.8282>, <-31.1002, 181.6971, -61.5054>, <-30.1419, 182.7131, -60.2544> }
					triangle { <-31.1002, 181.6971, -61.5054>, <-30.7242, 181.3095, -60.844>, <-30.1419, 182.7131, -60.2544> }
					triangle { <-31.1002, 181.6971, -61.5054>, <-31.9929, 179.2774, -62.3917>, <-30.7242, 181.3095, -60.844> }
					triangle { <-30.7242, 181.3095, -60.844>, <-31.9929, 179.2774, -62.3917>, <-31.6894, 178.933, -61.7618> }
					triangle { <-31.9929, 179.2774, -62.3917>, <-32.5769, 178.5622, -61.7747>, <-31.6894, 178.933, -61.7618> }
					triangle { <-32.5769, 178.5622, -61.7747>, <-32.1982, 178.3053, -61.4547>, <-31.6894, 178.933, -61.7618> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-30.5584, 183.9448, -60.5633>, <-30.8215, 183.7405, -61.397> }
					triangle { <-29.4408, 182.6199, -60.4504>, <-28.5056, 182.3563, -60.3893>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-29.3349, 181.8336, -60.3591>, <-29.5541, 180.7221, -60.7389>, <-28.2042, 181.6262, -60.9273> }
					triangle { <-29.4408, 182.6199, -60.4504>, <-29.3349, 181.8336, -60.3591>, <-28.5056, 182.3563, -60.3893> }
					triangle { <-29.3349, 181.8336, -60.3591>, <-28.2042, 181.6262, -60.9273>, <-28.5056, 182.3563, -60.3893> }
					triangle { <-29.5541, 180.7221, -60.7389>, <-28.4474, 180.6411, -61.7217>, <-28.2042, 181.6262, -60.9273> }
					triangle { <-29.7673, 179.9584, -61.1695>, <-28.8513, 179.6452, -62.2902>, <-28.4474, 180.6411, -61.7217> }
					triangle { <-29.5541, 180.7221, -60.7389>, <-29.7673, 179.9584, -61.1695>, <-28.4474, 180.6411, -61.7217> }
					triangle { <-30.3153, 178.5292, -62.1304>, <-29.3745, 178.5271, -62.7522>, <-28.8513, 179.6452, -62.2902> }
					triangle { <-29.7673, 179.9584, -61.1695>, <-30.3153, 178.5292, -62.1304>, <-28.8513, 179.6452, -62.2902> }
					triangle { <-30.9712, 177.6483, -61.06149>, <-30.4778, 177.6742, -60.745>, <-29.3745, 178.5271, -62.7522> }
					triangle { <-30.3153, 178.5292, -62.1304>, <-30.9712, 177.6483, -61.06149>, <-29.3745, 178.5271, -62.7522> }
					triangle { <-31.4749, 177.8017, -61.1077>, <-30.9712, 177.6483, -61.06149>, <-30.3153, 178.5292, -62.1304> }
					triangle { <-29.9423, 181.0051, -61.0016>, <-29.3349, 181.8336, -60.3591>, <-29.4408, 182.6199, -60.4504> }
					triangle { <-29.9423, 181.0051, -61.0016>, <-29.5541, 180.7221, -60.7389>, <-29.3349, 181.8336, -60.3591> }
					triangle { <-29.9423, 181.0051, -61.0016>, <-29.7673, 179.9584, -61.1695>, <-29.5541, 180.7221, -60.7389> }
					triangle { <-29.9423, 181.0051, -61.0016>, <-31.05218, 178.715, -61.9823>, <-29.7673, 179.9584, -61.1695> }
					triangle { <-31.05218, 178.715, -61.9823>, <-30.3153, 178.5292, -62.1304>, <-29.7673, 179.9584, -61.1695> }
					triangle { <-31.05218, 178.715, -61.9823>, <-31.4749, 177.8017, -61.1077>, <-30.3153, 178.5292, -62.1304> }
					triangle { <-31.05218, 178.715, -61.9823>, <-31.873, 178.0396, -61.2809>, <-31.4749, 177.8017, -61.1077> }
					triangle { <-30.1419, 182.7131, -60.2544>, <-29.4408, 182.6199, -60.4504>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-30.1419, 182.7131, -60.2544>, <-29.9423, 181.0051, -61.0016>, <-29.4408, 182.6199, -60.4504> }
					triangle { <-30.1419, 182.7131, -60.2544>, <-30.7242, 181.3095, -60.844>, <-29.9423, 181.0051, -61.0016> }
					triangle { <-30.7242, 181.3095, -60.844>, <-31.05218, 178.715, -61.9823>, <-29.9423, 181.0051, -61.0016> }
					triangle { <-31.6894, 178.933, -61.7618>, <-31.05218, 178.715, -61.9823>, <-30.7242, 181.3095, -60.844> }
					triangle { <-31.6894, 178.933, -61.7618>, <-31.873, 178.0396, -61.2809>, <-31.05218, 178.715, -61.9823> }
					triangle { <-31.6894, 178.933, -61.7618>, <-32.1982, 178.3053, -61.4547>, <-31.873, 178.0396, -61.2809> }
					triangle { <-28.5056, 182.3563, -60.3893>, <-28.8939, 182.9499, -59.8391>, <-29.3912, 183.8022, -60.4837> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.3912, 183.8022, -60.4837>, <-28.9267, 183.4227, -62.07243>, <-29.704, 183.2864, -61.5023> }
					triangle { <-28.6254, 182.6926, -62.6104>, <-30.12, 182.1551, -63.00056>, <-29.8087, 183.0333, -62.2525> }
					triangle { <-28.9267, 183.4227, -62.07243>, <-29.8087, 183.0333, -62.2525>, <-29.704, 183.2864, -61.5023> }
					triangle { <-28.9267, 183.4227, -62.07243>, <-28.6254, 182.6926, -62.6104>, <-29.8087, 183.0333, -62.2525> }
					triangle { <-28.6254, 182.6926, -62.6104>, <-28.7896, 181.5076, -63.08919>, <-30.12, 182.1551, -63.00056> }
					triangle { <-28.7896, 181.5076, -63.08919>, <-29.1803, 180.4783, -63.605>, <-30.3331, 181.3914, -63.4311> }
					triangle { <-28.7896, 181.5076, -63.08919>, <-30.3331, 181.3914, -63.4311>, <-30.12, 182.1551, -63.00056> }
					triangle { <-29.1803, 180.4783, -63.605>, <-29.743, 179.4602, -64.2249>, <-30.8154, 179.7956, -64.129> }
					triangle { <-29.1803, 180.4783, -63.605>, <-30.8154, 179.7956, -64.129>, <-30.3331, 181.3914, -63.4311> }
					triangle { <-29.743, 179.4602, -64.2249>, <-31.6617, 180.7445, -65.5106>, <-31.829, 180.3148, -65.202> }
					triangle { <-29.743, 179.4602, -64.2249>, <-31.829, 180.3148, -65.202>, <-30.8154, 179.7956, -64.129> }
					triangle { <-30.8154, 179.7956, -64.129>, <-31.829, 180.3148, -65.202>, <-32.1555, 180.0874, -64.7639> }
					triangle { <-29.704, 183.2864, -61.5023>, <-29.8087, 183.0333, -62.2525>, <-30.3239, 181.9715, -62.5268> }
					triangle { <-29.8087, 183.0333, -62.2525>, <-30.12, 182.1551, -63.00056>, <-30.3239, 181.9715, -62.5268> }
					triangle { <-30.12, 182.1551, -63.00056>, <-30.3331, 181.3914, -63.4311>, <-30.3239, 181.9715, -62.5268> }
					triangle { <-30.3331, 181.3914, -63.4311>, <-31.4996, 179.8481, -63.7706>, <-30.3239, 181.9715, -62.5268> }
					triangle { <-30.3331, 181.3914, -63.4311>, <-30.8154, 179.7956, -64.129>, <-31.4996, 179.8481, -63.7706> }
					triangle { <-30.8154, 179.7956, -64.129>, <-32.1555, 180.0874, -64.7639>, <-31.4996, 179.8481, -63.7706> }
					triangle { <-32.1555, 180.0874, -64.7639>, <-32.4915, 179.8859, -64.2684>, <-31.4996, 179.8481, -63.7706> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-29.704, 183.2864, -61.5023>, <-30.3919, 183.3462, -61.2537> }
					triangle { <-29.704, 183.2864, -61.5023>, <-30.3239, 181.9715, -62.5268>, <-30.3919, 183.3462, -61.2537> }
					triangle { <-30.3239, 181.9715, -62.5268>, <-31.02697, 182.076, -62.05374>, <-30.3919, 183.3462, -61.2537> }
					triangle { <-30.3239, 181.9715, -62.5268>, <-31.4996, 179.8481, -63.7706>, <-31.02697, 182.076, -62.05374> }
					triangle { <-31.02697, 182.076, -62.05374>, <-31.4996, 179.8481, -63.7706>, <-32.1565, 179.976, -63.3711> }
					triangle { <-31.4996, 179.8481, -63.7706>, <-32.4915, 179.8859, -64.2684>, <-32.1565, 179.976, -63.3711> }
					triangle { <-32.4915, 179.8859, -64.2684>, <-32.8627, 179.8481, -63.853>, <-32.1565, 179.976, -63.3711> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-29.3413, 184.083, -61.6273>, <-28.9267, 183.4227, -62.07243> }
					triangle { <-30.2566, 183.0057, -60.6178>, <-30.4004, 182.6741, -59.7139>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-30.8678, 182.4952, -60.5573>, <-31.4094, 181.5, -60.9369>, <-30.5134, 181.7334, -59.5886> }
					triangle { <-30.2566, 183.0057, -60.6178>, <-30.8678, 182.4952, -60.5573>, <-30.4004, 182.6741, -59.7139> }
					triangle { <-30.8678, 182.4952, -60.5573>, <-30.5134, 181.7334, -59.5886>, <-30.4004, 182.6741, -59.7139> }
					triangle { <-31.4094, 181.5, -60.9369>, <-30.6776, 180.5484, -60.06741>, <-30.5134, 181.7334, -59.5886> }
					triangle { <-31.6686, 180.713, -61.2937>, <-31.02235, 179.5425, -60.657>, <-30.6776, 180.5484, -60.06741> }
					triangle { <-31.4094, 181.5, -60.9369>, <-31.6686, 180.713, -61.2937>, <-30.6776, 180.5484, -60.06741> }
					triangle { <-32.05877, 179.1639, -62.1391>, <-31.539, 178.5477, -61.3505>, <-31.02235, 179.5425, -60.657> }
					triangle { <-31.6686, 180.713, -61.2937>, <-32.05877, 179.1639, -62.1391>, <-31.02235, 179.5425, -60.657> }
					triangle { <-33.491, 179.4089, -62.6265>, <-33.6489, 179.5441, -62.07788>, <-31.539, 178.5477, -61.3505> }
					triangle { <-32.05877, 179.1639, -62.1391>, <-33.491, 179.4089, -62.6265>, <-31.539, 178.5477, -61.3505> }
					triangle { <-33.3961, 179.5864, -63.1153>, <-33.491, 179.4089, -62.6265>, <-32.05877, 179.1639, -62.1391> }
					triangle { <-31.06076, 181.5972, -61.3476>, <-30.8678, 182.4952, -60.5573>, <-30.2566, 183.0057, -60.6178> }
					triangle { <-31.06076, 181.5972, -61.3476>, <-31.4094, 181.5, -60.9369>, <-30.8678, 182.4952, -60.5573> }
					triangle { <-31.06076, 181.5972, -61.3476>, <-31.6686, 180.713, -61.2937>, <-31.4094, 181.5, -60.9369> }
					triangle { <-31.06076, 181.5972, -61.3476>, <-32.09827, 179.544, -62.8124>, <-31.6686, 180.713, -61.2937> }
					triangle { <-32.09827, 179.544, -62.8124>, <-32.05877, 179.1639, -62.1391>, <-31.6686, 180.713, -61.2937> }
					triangle { <-32.09827, 179.544, -62.8124>, <-33.3961, 179.5864, -63.1153>, <-32.05877, 179.1639, -62.1391> }
					triangle { <-32.09827, 179.544, -62.8124>, <-33.1428, 179.7151, -63.5207>, <-33.3961, 179.5864, -63.1153> }
					triangle { <-30.3919, 183.3462, -61.2537>, <-30.2566, 183.0057, -60.6178>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-30.3919, 183.3462, -61.2537>, <-31.06076, 181.5972, -61.3476>, <-30.2566, 183.0057, -60.6178> }
					triangle { <-30.3919, 183.3462, -61.2537>, <-31.02697, 182.076, -62.05374>, <-31.06076, 181.5972, -61.3476> }
					triangle { <-31.02697, 182.076, -62.05374>, <-32.09827, 179.544, -62.8124>, <-31.06076, 181.5972, -61.3476> }
					triangle { <-32.1565, 179.976, -63.3711>, <-32.09827, 179.544, -62.8124>, <-31.02697, 182.076, -62.05374> }
					triangle { <-32.1565, 179.976, -63.3711>, <-33.1428, 179.7151, -63.5207>, <-32.09827, 179.544, -62.8124> }
					triangle { <-32.1565, 179.976, -63.3711>, <-32.8627, 179.8481, -63.853>, <-33.1428, 179.7151, -63.5207> }
					triangle { <-30.4004, 182.6741, -59.7139>, <-30.4005, 183.5449, -59.9321>, <-29.3912, 183.8022, -60.4837> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.3912, 183.8022, -60.4837>, <-28.5056, 182.3563, -60.3893>, <-29.07241, 182.8071, -61.04002> }
					triangle { <-28.6187, 181.4157, -60.264>, <-28.8633, 181.0731, -61.8445>, <-28.7362, 182.1377, -61.3172> }
					triangle { <-28.5056, 182.3563, -60.3893>, <-28.7362, 182.1377, -61.3172>, <-29.07241, 182.8071, -61.04002> }
					triangle { <-28.5056, 182.3563, -60.3893>, <-28.6187, 181.4157, -60.264>, <-28.7362, 182.1377, -61.3172> }
					triangle { <-28.6187, 181.4157, -60.264>, <-29.1382, 180.2902, -60.6161>, <-28.8633, 181.0731, -61.8445> }
					triangle { <-29.1382, 180.2902, -60.6161>, <-29.542, 179.2943, -61.1846>, <-29.1225, 180.286, -62.2013> }
					triangle { <-29.1382, 180.2902, -60.6161>, <-29.1225, 180.286, -62.2013>, <-28.8633, 181.0731, -61.8445> }
					triangle { <-29.542, 179.2943, -61.1846>, <-29.8811, 178.2697, -61.9415>, <-29.8087, 178.7866, -62.9411> }
					triangle { <-29.542, 179.2943, -61.1846>, <-29.8087, 178.7866, -62.9411>, <-29.1225, 180.286, -62.2013> }
					triangle { <-29.8811, 178.2697, -61.9415>, <-28.2472, 178.6781, -63.9781>, <-28.7828, 178.6215, -64.111> }
					triangle { <-29.8811, 178.2697, -61.9415>, <-28.7828, 178.6215, -64.111>, <-29.8087, 178.7866, -62.9411> }
					triangle { <-29.8087, 178.7866, -62.9411>, <-28.7828, 178.6215, -64.111>, <-29.2805, 178.8273, -64.3566> }
					triangle { <-29.07241, 182.8071, -61.04002>, <-28.7362, 182.1377, -61.3172>, <-29.3436, 181.3092, -61.9597> }
					triangle { <-28.7362, 182.1377, -61.3172>, <-28.8633, 181.0731, -61.8445>, <-29.3436, 181.3092, -61.9597> }
					triangle { <-28.8633, 181.0731, -61.8445>, <-29.1225, 180.286, -62.2013>, <-29.3436, 181.3092, -61.9597> }
					triangle { <-29.1225, 180.286, -62.2013>, <-30.08511, 179.2063, -63.5301>, <-29.3436, 181.3092, -61.9597> }
					triangle { <-29.1225, 180.286, -62.2013>, <-29.8087, 178.7866, -62.9411>, <-30.08511, 179.2063, -63.5301> }
					triangle { <-29.8087, 178.7866, -62.9411>, <-29.2805, 178.8273, -64.3566>, <-30.08511, 179.2063, -63.5301> }
					triangle { <-29.2805, 178.8273, -64.3566>, <-29.8007, 179.0924, -64.5975>, <-30.08511, 179.2063, -63.5301> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-29.07241, 182.8071, -61.04002>, <-29.2669, 183.1576, -61.6547> }
					triangle { <-29.07241, 182.8071, -61.04002>, <-29.3436, 181.3092, -61.9597>, <-29.2669, 183.1576, -61.6547> }
					triangle { <-29.3436, 181.3092, -61.9597>, <-29.6651, 181.8476, -62.5392>, <-29.2669, 183.1576, -61.6547> }
					triangle { <-29.3436, 181.3092, -61.9597>, <-30.08511, 179.2063, -63.5301>, <-29.6651, 181.8476, -62.5392> }
					triangle { <-29.6651, 181.8476, -62.5392>, <-30.08511, 179.2063, -63.5301>, <-30.3342, 179.7015, -64.0781> }
					triangle { <-30.08511, 179.2063, -63.5301>, <-29.8007, 179.0924, -64.5975>, <-30.3342, 179.7015, -64.0781> }
					triangle { <-29.8007, 179.0924, -64.5975>, <-30.1522, 179.4247, -64.8765>, <-30.3342, 179.7015, -64.0781> }
					triangle { <-29.3912, 183.8022, -60.4837>, <-28.3874, 183.2073, -60.6498>, <-28.5056, 182.3563, -60.3893> }
					triangle { <-29.9408, 183.3261, -61.4178>, <-30.8215, 183.7405, -61.397>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-30.4008, 183.1326, -62.04147>, <-30.8897, 182.2842, -62.7261>, <-31.5859, 183.1891, -61.555> }
					triangle { <-29.9408, 183.3261, -61.4178>, <-30.4008, 183.1326, -62.04147>, <-30.8215, 183.7405, -61.397> }
					triangle { <-30.4008, 183.1326, -62.04147>, <-31.5859, 183.1891, -61.555>, <-30.8215, 183.7405, -61.397> }
					triangle { <-30.8897, 182.2842, -62.7261>, <-32.1054, 182.0637, -61.9072>, <-31.5859, 183.1891, -61.555> }
					triangle { <-31.2213, 181.5404, -63.1145>, <-32.4369, 181.0245, -62.4442>, <-32.1054, 182.0637, -61.9072> }
					triangle { <-30.8897, 182.2842, -62.7261>, <-31.2213, 181.5404, -63.1145>, <-32.1054, 182.0637, -61.9072> }
					triangle { <-31.7627, 179.9545, -63.7913>, <-32.7035, 179.9566, -63.1695>, <-32.4369, 181.0245, -62.4442> }
					triangle { <-31.2213, 181.5404, -63.1145>, <-31.7627, 179.9545, -63.7913>, <-32.4369, 181.0245, -62.4442> }
					triangle { <-31.3792, 180.0817, -65.2697>, <-31.6819, 180.5834, -65.2996>, <-32.7035, 179.9566, -63.1695> }
					triangle { <-31.7627, 179.9545, -63.7913>, <-31.3792, 180.0817, -65.2697>, <-32.7035, 179.9566, -63.1695> }
					triangle { <-30.9027, 179.8529, -65.2644>, <-31.3792, 180.0817, -65.2697>, <-31.7627, 179.9545, -63.7913> }
					triangle { <-30.5015, 182.0013, -62.4635>, <-30.4008, 183.1326, -62.04147>, <-29.9408, 183.3261, -61.4178> }
					triangle { <-30.5015, 182.0013, -62.4635>, <-30.8897, 182.2842, -62.7261>, <-30.4008, 183.1326, -62.04147> }
					triangle { <-30.5015, 182.0013, -62.4635>, <-31.2213, 181.5404, -63.1145>, <-30.8897, 182.2842, -62.7261> }
					triangle { <-30.5015, 182.0013, -62.4635>, <-31.02593, 179.7687, -63.9394>, <-31.2213, 181.5404, -63.1145> }
					triangle { <-31.02593, 179.7687, -63.9394>, <-31.7627, 179.9545, -63.7913>, <-31.2213, 181.5404, -63.1145> }
					triangle { <-31.02593, 179.7687, -63.9394>, <-30.9027, 179.8529, -65.2644>, <-31.7627, 179.9545, -63.7913> }
					triangle { <-31.02593, 179.7687, -63.9394>, <-30.5047, 179.615, -65.0913>, <-30.9027, 179.8529, -65.2644> }
					triangle { <-29.2669, 183.1576, -61.6547>, <-29.9408, 183.3261, -61.4178>, <-29.3912, 183.8022, -60.4837> }
					triangle { <-29.2669, 183.1576, -61.6547>, <-30.5015, 182.0013, -62.4635>, <-29.9408, 183.3261, -61.4178> }
					triangle { <-29.2669, 183.1576, -61.6547>, <-29.6651, 181.8476, -62.5392>, <-30.5015, 182.0013, -62.4635> }
					triangle { <-29.6651, 181.8476, -62.5392>, <-31.02593, 179.7687, -63.9394>, <-30.5015, 182.0013, -62.4635> }
					triangle { <-30.3342, 179.7015, -64.0781>, <-31.02593, 179.7687, -63.9394>, <-29.6651, 181.8476, -62.5392> }
					triangle { <-30.3342, 179.7015, -64.0781>, <-30.5047, 179.615, -65.0913>, <-31.02593, 179.7687, -63.9394> }
					triangle { <-30.3342, 179.7015, -64.0781>, <-30.1522, 179.4247, -64.8765>, <-30.5047, 179.615, -65.0913> }
					triangle { <-30.8215, 183.7405, -61.397>, <-30.05192, 184.2021, -61.374>, <-29.3912, 183.8022, -60.4837> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-28.958, 184.0319, -59.326>, <-29.09963, 184.9656, -59.6548>, 0.55 }
			cylinder { <-29.09963, 184.9656, -59.6548>, <-29.2539, 185.8864, -60.01323>, 0.55 }
			cylinder { <-29.2539, 185.8864, -60.01323>, <-29.4208, 186.793, -60.4007>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-29.4208, 186.793, -60.4007>, <-29.6133, 187.2337, -60.2637>, 0.55 }
				cylinder { <-29.6133, 187.2337, -60.2637>, <-29.8213, 187.4477, -59.8626>, 0.55 }
				cylinder { <-29.8213, 187.4477, -59.8626>, <-29.944, 187.3312, -59.3921>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-29.944, 187.3312, -59.3921>, <-28.5995, 186.6829, -58.5823>, <-29.566, 186.5662, -58.5717> }
					triangle { <-28.1383, 186.7222, -57.7462>, <-29.03881, 185.57, -57.01373>, <-29.1764, 186.0559, -58.09657> }
					triangle { <-28.5995, 186.6829, -58.5823>, <-29.1764, 186.0559, -58.09657>, <-29.566, 186.5662, -58.5717> }
					triangle { <-28.5995, 186.6829, -58.5823>, <-28.1383, 186.7222, -57.7462>, <-29.1764, 186.0559, -58.09657> }
					triangle { <-28.1383, 186.7222, -57.7462>, <-28.1263, 186.6004, -56.4634>, <-29.03881, 185.57, -57.01373> }
					triangle { <-28.1263, 186.6004, -56.4634>, <-28.227, 186.2559, -55.3018>, <-29.02603, 185.3352, -56.1426> }
					triangle { <-28.1263, 186.6004, -56.4634>, <-29.02603, 185.3352, -56.1426>, <-29.03881, 185.57, -57.01373> }
					triangle { <-28.227, 186.2559, -55.3018>, <-28.3796, 185.7198, -54.1073>, <-29.1619, 184.955, -54.381> }
					triangle { <-28.227, 186.2559, -55.3018>, <-29.1619, 184.955, -54.381>, <-29.02603, 185.3352, -56.1426> }
					triangle { <-28.3796, 185.7198, -54.1073>, <-28.685, 183.1893, -54.8057>, <-29.08354, 183.3954, -54.4793> }
					triangle { <-28.3796, 185.7198, -54.1073>, <-29.08354, 183.3954, -54.4793>, <-29.1619, 184.955, -54.381> }
					triangle { <-29.1619, 184.955, -54.381>, <-29.08354, 183.3954, -54.4793>, <-29.6512, 183.5251, -54.3733> }
					triangle { <-29.566, 186.5662, -58.5717>, <-29.1764, 186.0559, -58.09657>, <-29.535, 185.7967, -56.9686> }
					triangle { <-29.1764, 186.0559, -58.09657>, <-29.03881, 185.57, -57.01373>, <-29.535, 185.7967, -56.9686> }
					triangle { <-29.03881, 185.57, -57.01373>, <-29.02603, 185.3352, -56.1426>, <-29.535, 185.7967, -56.9686> }
					triangle { <-29.02603, 185.3352, -56.1426>, <-29.8878, 184.71, -54.4922>, <-29.535, 185.7967, -56.9686> }
					triangle { <-29.02603, 185.3352, -56.1426>, <-29.1619, 184.955, -54.381>, <-29.8878, 184.71, -54.4922> }
					triangle { <-29.1619, 184.955, -54.381>, <-29.6512, 183.5251, -54.3733>, <-29.8878, 184.71, -54.4922> }
					triangle { <-29.6512, 183.5251, -54.3733>, <-30.2601, 183.68, -54.3087>, <-29.8878, 184.71, -54.4922> }
					triangle { <-29.944, 187.3312, -59.3921>, <-29.566, 186.5662, -58.5717>, <-30.2193, 186.2426, -58.6563> }
					triangle { <-29.566, 186.5662, -58.5717>, <-29.535, 185.7967, -56.9686>, <-30.2193, 186.2426, -58.6563> }
					triangle { <-29.535, 185.7967, -56.9686>, <-30.3434, 185.6021, -57.1626>, <-30.2193, 186.2426, -58.6563> }
					triangle { <-29.535, 185.7967, -56.9686>, <-29.8878, 184.71, -54.4922>, <-30.3434, 185.6021, -57.1626> }
					triangle { <-30.3434, 185.6021, -57.1626>, <-29.8878, 184.71, -54.4922>, <-30.6095, 184.4914, -54.6893> }
					triangle { <-29.8878, 184.71, -54.4922>, <-30.2601, 183.68, -54.3087>, <-30.6095, 184.4914, -54.6893> }
					triangle { <-30.2601, 183.68, -54.3087>, <-30.8138, 183.7133, -54.3729>, <-30.6095, 184.4914, -54.6893> }
					triangle { <-29.944, 187.3312, -59.3921>, <-29.09102, 186.5214, -59.316>, <-28.5995, 186.6829, -58.5823> }
					triangle { <-30.6061, 186.8543, -58.5345>, <-31.3734, 187.4513, -58.4833>, <-29.944, 187.3312, -59.3921> }
					triangle { <-31.1701, 186.6082, -58.02541>, <-31.4659, 186.2423, -56.9271>, <-31.6923, 187.7067, -57.6194> }
					triangle { <-30.6061, 186.8543, -58.5345>, <-31.1701, 186.6082, -58.02541>, <-31.3734, 187.4513, -58.4833> }
					triangle { <-31.1701, 186.6082, -58.02541>, <-31.6923, 187.7067, -57.6194>, <-31.3734, 187.4513, -58.4833> }
					triangle { <-31.4659, 186.2423, -56.9271>, <-31.6802, 187.5849, -56.3366>, <-31.6923, 187.7067, -57.6194> }
					triangle { <-31.5398, 186.0316, -56.05293>, <-31.6943, 187.2164, -55.178>, <-31.6802, 187.5849, -56.3366> }
					triangle { <-31.4659, 186.2423, -56.9271>, <-31.5398, 186.0316, -56.05293>, <-31.6802, 187.5849, -56.3366> }
					triangle { <-31.5023, 185.6034, -54.2974>, <-31.7602, 186.6563, -53.9867>, <-31.6943, 187.2164, -55.178> }
					triangle { <-31.5398, 186.0316, -56.05293>, <-31.5023, 185.6034, -54.2974>, <-31.6943, 187.2164, -55.178> }
					triangle { <-32.165, 184.2215, -54.2836>, <-32.6268, 184.446, -54.5673>, <-31.7602, 186.6563, -53.9867> }
					triangle { <-31.5023, 185.6034, -54.2974>, <-32.165, 184.2215, -54.2836>, <-31.7602, 186.6563, -53.9867> }
					triangle { <-31.738, 183.911, -54.3107>, <-32.165, 184.2215, -54.2836>, <-31.5023, 185.6034, -54.2974> }
					triangle { <-30.9219, 186.1809, -56.9191>, <-31.1701, 186.6082, -58.02541>, <-30.6061, 186.8543, -58.5345> }
					triangle { <-30.9219, 186.1809, -56.9191>, <-31.4659, 186.2423, -56.9271>, <-31.1701, 186.6082, -58.02541> }
					triangle { <-30.9219, 186.1809, -56.9191>, <-31.5398, 186.0316, -56.05293>, <-31.4659, 186.2423, -56.9271> }
					triangle { <-30.9219, 186.1809, -56.9191>, <-31.01474, 185.0222, -54.4519>, <-31.5398, 186.0316, -56.05293> }
					triangle { <-31.01474, 185.0222, -54.4519>, <-31.5023, 185.6034, -54.2974>, <-31.5398, 186.0316, -56.05293> }
					triangle { <-31.01474, 185.0222, -54.4519>, <-31.738, 183.911, -54.3107>, <-31.5023, 185.6034, -54.2974> }
					triangle { <-31.01474, 185.0222, -54.4519>, <-31.2613, 183.7789, -54.3278>, <-31.738, 183.911, -54.3107> }
					triangle { <-30.2193, 186.2426, -58.6563>, <-30.6061, 186.8543, -58.5345>, <-29.944, 187.3312, -59.3921> }
					triangle { <-30.2193, 186.2426, -58.6563>, <-30.9219, 186.1809, -56.9191>, <-30.6061, 186.8543, -58.5345> }
					triangle { <-30.2193, 186.2426, -58.6563>, <-30.3434, 185.6021, -57.1626>, <-30.9219, 186.1809, -56.9191> }
					triangle { <-30.3434, 185.6021, -57.1626>, <-31.01474, 185.0222, -54.4519>, <-30.9219, 186.1809, -56.9191> }
					triangle { <-30.6095, 184.4914, -54.6893>, <-31.01474, 185.0222, -54.4519>, <-30.3434, 185.6021, -57.1626> }
					triangle { <-30.6095, 184.4914, -54.6893>, <-31.2613, 183.7789, -54.3278>, <-31.01474, 185.0222, -54.4519> }
					triangle { <-30.6095, 184.4914, -54.6893>, <-30.8138, 183.7133, -54.3729>, <-31.2613, 183.7789, -54.3278> }
					triangle { <-31.3734, 187.4513, -58.4833>, <-31.08471, 187.0737, -59.2448>, <-29.944, 187.3312, -59.3921> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.944, 187.3312, -59.3921>, <-29.6051, 188.3891, -58.1077>, <-29.501, 187.4404, -58.2998> }
					triangle { <-29.924, 188.6445, -57.2438>, <-29.08976, 187.5024, -56.4224>, <-29.1808, 187.6631, -57.6029> }
					triangle { <-29.6051, 188.3891, -58.1077>, <-29.1808, 187.6631, -57.6029>, <-29.501, 187.4404, -58.2998> }
					triangle { <-29.6051, 188.3891, -58.1077>, <-29.924, 188.6445, -57.2438>, <-29.1808, 187.6631, -57.6029> }
					triangle { <-29.924, 188.6445, -57.2438>, <-30.2435, 188.3468, -56.03149>, <-29.08976, 187.5024, -56.4224> }
					triangle { <-30.2435, 188.3468, -56.03149>, <-30.3128, 187.949, -54.8846>, <-29.1636, 187.2916, -55.5482> }
					triangle { <-30.2435, 188.3468, -56.03149>, <-29.1636, 187.2916, -55.5482>, <-29.08976, 187.5024, -56.4224> }
					triangle { <-30.3128, 187.949, -54.8846>, <-30.2129, 187.4768, -53.658>, <-29.4024, 186.7169, -53.8515> }
					triangle { <-30.3128, 187.949, -54.8846>, <-29.4024, 186.7169, -53.8515>, <-29.1636, 187.2916, -55.5482> }
					triangle { <-30.2129, 187.4768, -53.658>, <-27.5961, 187.1258, -53.5423>, <-27.9014, 186.6815, -53.4111> }
					triangle { <-30.2129, 187.4768, -53.658>, <-27.9014, 186.6815, -53.4111>, <-29.4024, 186.7169, -53.8515> }
					triangle { <-29.4024, 186.7169, -53.8515>, <-27.9014, 186.6815, -53.4111>, <-28.06065, 186.118, -53.4979> }
					triangle { <-29.501, 187.4404, -58.2998>, <-29.1808, 187.6631, -57.6029>, <-29.3194, 187.0307, -56.5787> }
					triangle { <-29.1808, 187.6631, -57.6029>, <-29.08976, 187.5024, -56.4224>, <-29.3194, 187.0307, -56.5787> }
					triangle { <-29.08976, 187.5024, -56.4224>, <-29.1636, 187.2916, -55.5482>, <-29.3194, 187.0307, -56.5787> }
					triangle { <-29.1636, 187.2916, -55.5482>, <-29.1359, 186.0185, -54.05295>, <-29.3194, 187.0307, -56.5787> }
					triangle { <-29.1636, 187.2916, -55.5482>, <-29.4024, 186.7169, -53.8515>, <-29.1359, 186.0185, -54.05295> }
					triangle { <-29.4024, 186.7169, -53.8515>, <-28.06065, 186.118, -53.4979>, <-29.1359, 186.0185, -54.05295> }
					triangle { <-28.06065, 186.118, -53.4979>, <-28.2296, 185.5265, -53.6409>, <-29.1359, 186.0185, -54.05295> }
					triangle { <-29.944, 187.3312, -59.3921>, <-29.501, 187.4404, -58.2998>, <-29.1693, 186.7994, -58.4333> }
					triangle { <-29.501, 187.4404, -58.2998>, <-29.3194, 187.0307, -56.5787>, <-29.1693, 186.7994, -58.4333> }
					triangle { <-29.3194, 187.0307, -56.5787>, <-29.0725, 186.2761, -56.8926>, <-29.1693, 186.7994, -58.4333> }
					triangle { <-29.3194, 187.0307, -56.5787>, <-29.1359, 186.0185, -54.05295>, <-29.0725, 186.2761, -56.8926> }
					triangle { <-29.0725, 186.2761, -56.8926>, <-29.1359, 186.0185, -54.05295>, <-28.8651, 185.3465, -54.3403> }
					triangle { <-29.1359, 186.0185, -54.05295>, <-28.2296, 185.5265, -53.6409>, <-28.8651, 185.3465, -54.3403> }
					triangle { <-28.2296, 185.5265, -53.6409>, <-28.2405, 185.008, -53.8479>, <-28.8651, 185.3465, -54.3403> }
					triangle { <-29.944, 187.3312, -59.3921>, <-29.2059, 188.07, -58.8458>, <-29.6051, 188.3891, -58.1077> }
					triangle { <-29.787, 186.4489, -58.6186>, <-30.3678, 185.7452, -58.9578>, <-29.944, 187.3312, -59.3921> }
					triangle { <-29.729, 185.7629, -58.2139>, <-29.7571, 185.189, -57.1663>, <-30.9013, 185.257, -58.333> }
					triangle { <-29.787, 186.4489, -58.6186>, <-29.729, 185.7629, -58.2139>, <-30.3678, 185.7452, -58.9578> }
					triangle { <-29.729, 185.7629, -58.2139>, <-30.9013, 185.257, -58.333>, <-30.3678, 185.7452, -58.9578> }
					triangle { <-29.7571, 185.189, -57.1663>, <-31.2208, 184.9594, -57.1207>, <-30.9013, 185.257, -58.333> }
					triangle { <-29.8549, 184.8957, -56.3187>, <-31.2662, 184.6442, -55.9473>, <-31.2208, 184.9594, -57.1207> }
					triangle { <-29.7571, 185.189, -57.1663>, <-29.8549, 184.8957, -56.3187>, <-31.2208, 184.9594, -57.1207> }
					triangle { <-30.04607, 184.4862, -54.5688>, <-31.1425, 184.2546, -54.6941>, <-31.2662, 184.6442, -55.9473> }
					triangle { <-29.8549, 184.8957, -56.3187>, <-30.04607, 184.4862, -54.5688>, <-31.2662, 184.6442, -55.9473> }
					triangle { <-28.7519, 183.7221, -54.2683>, <-28.8681, 183.3601, -54.7152>, <-31.1425, 184.2546, -54.6941> }
					triangle { <-30.04607, 184.4862, -54.5688>, <-28.7519, 183.7221, -54.2683>, <-31.1425, 184.2546, -54.6941> }
					triangle { <-28.4495, 184.1152, -54.08545>, <-28.7519, 183.7221, -54.2683>, <-30.04607, 184.4862, -54.5688> }
					triangle { <-29.7008, 185.7088, -57.00381>, <-29.729, 185.7629, -58.2139>, <-29.787, 186.4489, -58.6186> }
					triangle { <-29.7008, 185.7088, -57.00381>, <-29.7571, 185.189, -57.1663>, <-29.729, 185.7629, -58.2139> }
					triangle { <-29.7008, 185.7088, -57.00381>, <-29.8549, 184.8957, -56.3187>, <-29.7571, 185.189, -57.1663> }
					triangle { <-29.7008, 185.7088, -57.00381>, <-29.4458, 184.9444, -54.3983>, <-29.8549, 184.8957, -56.3187> }
					triangle { <-29.4458, 184.9444, -54.3983>, <-30.04607, 184.4862, -54.5688>, <-29.8549, 184.8957, -56.3187> }
					triangle { <-29.4458, 184.9444, -54.3983>, <-28.4495, 184.1152, -54.08545>, <-30.04607, 184.4862, -54.5688> }
					triangle { <-29.4458, 184.9444, -54.3983>, <-28.3184, 184.5697, -53.9393>, <-28.4495, 184.1152, -54.08545> }
					triangle { <-29.1693, 186.7994, -58.4333>, <-29.787, 186.4489, -58.6186>, <-29.944, 187.3312, -59.3921> }
					triangle { <-29.1693, 186.7994, -58.4333>, <-29.7008, 185.7088, -57.00381>, <-29.787, 186.4489, -58.6186> }
					triangle { <-29.1693, 186.7994, -58.4333>, <-29.0725, 186.2761, -56.8926>, <-29.7008, 185.7088, -57.00381> }
					triangle { <-29.0725, 186.2761, -56.8926>, <-29.4458, 184.9444, -54.3983>, <-29.7008, 185.7088, -57.00381> }
					triangle { <-28.8651, 185.3465, -54.3403>, <-29.4458, 184.9444, -54.3983>, <-29.0725, 186.2761, -56.8926> }
					triangle { <-28.8651, 185.3465, -54.3403>, <-28.3184, 184.5697, -53.9393>, <-29.4458, 184.9444, -54.3983> }
					triangle { <-28.8651, 185.3465, -54.3403>, <-28.2405, 185.008, -53.8479>, <-28.3184, 184.5697, -53.9393> }
					triangle { <-30.3678, 185.7452, -58.9578>, <-29.7541, 186.1698, -59.4568>, <-29.944, 187.3312, -59.3921> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.944, 187.3312, -59.3921>, <-31.3734, 187.4513, -58.4833>, <-30.4155, 187.5153, -58.322> }
					triangle { <-31.9068, 186.9632, -57.8585>, <-31.1083, 187.4816, -56.5286>, <-30.8602, 187.6823, -57.68> }
					triangle { <-31.3734, 187.4513, -58.4833>, <-30.8602, 187.6823, -57.68>, <-30.4155, 187.5153, -58.322> }
					triangle { <-31.3734, 187.4513, -58.4833>, <-31.9068, 186.9632, -57.8585>, <-30.8602, 187.6823, -57.68> }
					triangle { <-31.9068, 186.9632, -57.8585>, <-32.03784, 186.3456, -56.7351>, <-31.1083, 187.4816, -56.5286> }
					triangle { <-32.03784, 186.3456, -56.7351>, <-32.05185, 185.9771, -55.5765>, <-31.2061, 187.1883, -55.681> }
					triangle { <-32.03784, 186.3456, -56.7351>, <-31.2061, 187.1883, -55.681>, <-31.1083, 187.4816, -56.5286> }
					triangle { <-32.05185, 185.9771, -55.5765>, <-32.02243, 185.7475, -54.2789>, <-31.2401, 186.5122, -54.00527> }
					triangle { <-32.05185, 185.9771, -55.5765>, <-31.2401, 186.5122, -54.00527>, <-31.2061, 187.1883, -55.681> }
					triangle { <-32.02243, 185.7475, -54.2789>, <-31.7255, 188.2251, -53.4086>, <-31.3525, 187.8606, -53.2194> }
					triangle { <-32.02243, 185.7475, -54.2789>, <-31.3525, 187.8606, -53.2194>, <-31.2401, 186.5122, -54.00527> }
					triangle { <-31.2401, 186.5122, -54.00527>, <-31.3525, 187.8606, -53.2194>, <-30.7933, 187.6781, -53.1536> }
					triangle { <-30.4155, 187.5153, -58.322>, <-30.8602, 187.6823, -57.68>, <-30.6121, 187.2549, -56.5737> }
					triangle { <-30.8602, 187.6823, -57.68>, <-31.1083, 187.4816, -56.5286>, <-30.6121, 187.2549, -56.5737> }
					triangle { <-31.1083, 187.4816, -56.5286>, <-31.2061, 187.1883, -55.681>, <-30.6121, 187.2549, -56.5737> }
					triangle { <-31.2061, 187.1883, -55.681>, <-30.5141, 186.7572, -53.894>, <-30.6121, 187.2549, -56.5737> }
					triangle { <-31.2061, 187.1883, -55.681>, <-31.2401, 186.5122, -54.00527>, <-30.5141, 186.7572, -53.894> }
					triangle { <-31.2401, 186.5122, -54.00527>, <-30.7933, 187.6781, -53.1536>, <-30.5141, 186.7572, -53.894> }
					triangle { <-30.7933, 187.6781, -53.1536>, <-30.1886, 187.4968, -53.1323>, <-30.5141, 186.7572, -53.894> }
					triangle { <-29.944, 187.3312, -59.3921>, <-30.4155, 187.5153, -58.322>, <-29.7664, 187.8124, -58.1515> }
					triangle { <-30.4155, 187.5153, -58.322>, <-30.6121, 187.2549, -56.5737>, <-29.7664, 187.8124, -58.1515> }
					triangle { <-30.6121, 187.2549, -56.5737>, <-29.7952, 187.5023, -56.5515>, <-29.7664, 187.8124, -58.1515> }
					triangle { <-30.6121, 187.2549, -56.5737>, <-30.5141, 186.7572, -53.894>, <-29.7952, 187.5023, -56.5515> }
					triangle { <-29.7952, 187.5023, -56.5515>, <-30.5141, 186.7572, -53.894>, <-29.7839, 187.0286, -53.8688> }
					triangle { <-30.5141, 186.7572, -53.894>, <-30.1886, 187.4968, -53.1323>, <-29.7839, 187.0286, -53.8688> }
					triangle { <-30.1886, 187.4968, -53.1323>, <-29.6307, 187.4898, -53.154>, <-29.7839, 187.0286, -53.8688> }
					triangle { <-29.944, 187.3312, -59.3921>, <-30.8225, 187.9825, -58.9526>, <-31.3734, 187.4513, -58.4833> }
					triangle { <-29.3753, 187.2271, -58.3591>, <-28.5995, 186.6829, -58.5823>, <-29.944, 187.3312, -59.3921> }
					triangle { <-28.8665, 187.13, -57.7512>, <-28.6812, 186.8093, -56.6152>, <-28.3528, 185.9786, -57.9853> }
					triangle { <-29.3753, 187.2271, -58.3591>, <-28.8665, 187.13, -57.7512>, <-28.5995, 186.6829, -58.5823> }
					triangle { <-28.8665, 187.13, -57.7512>, <-28.3528, 185.9786, -57.9853>, <-28.5995, 186.6829, -58.5823> }
					triangle { <-28.6812, 186.8093, -56.6152>, <-28.4838, 185.3611, -56.8619>, <-28.3528, 185.9786, -57.9853> }
					triangle { <-28.6923, 186.4919, -55.7707>, <-28.5845, 185.0166, -55.7003>, <-28.4838, 185.3611, -56.8619> }
					triangle { <-28.6812, 186.8093, -56.6152>, <-28.6923, 186.4919, -55.7707>, <-28.4838, 185.3611, -56.8619> }
					triangle { <-28.8997, 185.8638, -54.0888>, <-28.6418, 184.8109, -54.3995>, <-28.5845, 185.0166, -55.7003> }
					triangle { <-28.6923, 186.4919, -55.7707>, <-28.8997, 185.8638, -54.0888>, <-28.5845, 185.0166, -55.7003> }
					triangle { <-28.2795, 186.9817, -53.2433>, <-27.7879, 186.942, -53.5611>, <-28.6418, 184.8109, -54.3995> }
					triangle { <-28.8997, 185.8638, -54.0888>, <-28.2795, 186.9817, -53.2433>, <-28.6418, 184.8109, -54.3995> }
					triangle { <-28.7107, 187.2658, -53.1302>, <-28.2795, 186.9817, -53.2433>, <-28.8997, 185.8638, -54.0888> }
					triangle { <-29.2251, 186.8707, -56.6232>, <-28.8665, 187.13, -57.7512>, <-29.3753, 187.2271, -58.3591> }
					triangle { <-29.2251, 186.8707, -56.6232>, <-28.6812, 186.8093, -56.6152>, <-28.8665, 187.13, -57.7512> }
					triangle { <-29.2251, 186.8707, -56.6232>, <-28.6923, 186.4919, -55.7707>, <-28.6812, 186.8093, -56.6152> }
					triangle { <-29.2251, 186.8707, -56.6232>, <-29.3873, 186.445, -53.9343>, <-28.6923, 186.4919, -55.7707> }
					triangle { <-29.3873, 186.445, -53.9343>, <-28.8997, 185.8638, -54.0888>, <-28.6923, 186.4919, -55.7707> }
					triangle { <-29.3873, 186.445, -53.9343>, <-28.7107, 187.2658, -53.1302>, <-28.8997, 185.8638, -54.0888> }
					triangle { <-29.3873, 186.445, -53.9343>, <-29.1874, 187.3979, -53.1132>, <-28.7107, 187.2658, -53.1302> }
					triangle { <-29.7664, 187.8124, -58.1515>, <-29.3753, 187.2271, -58.3591>, <-29.944, 187.3312, -59.3921> }
					triangle { <-29.7664, 187.8124, -58.1515>, <-29.2251, 186.8707, -56.6232>, <-29.3753, 187.2271, -58.3591> }
					triangle { <-29.7664, 187.8124, -58.1515>, <-29.7952, 187.5023, -56.5515>, <-29.2251, 186.8707, -56.6232> }
					triangle { <-29.7952, 187.5023, -56.5515>, <-29.3873, 186.445, -53.9343>, <-29.2251, 186.8707, -56.6232> }
					triangle { <-29.7839, 187.0286, -53.8688>, <-29.3873, 186.445, -53.9343>, <-29.7952, 187.5023, -56.5515> }
					triangle { <-29.7839, 187.0286, -53.8688>, <-29.1874, 187.3979, -53.1132>, <-29.3873, 186.445, -53.9343> }
					triangle { <-29.7839, 187.0286, -53.8688>, <-29.6307, 187.4898, -53.154>, <-29.1874, 187.3979, -53.1132> }
					triangle { <-28.5995, 186.6829, -58.5823>, <-28.8288, 187.4302, -59.02382>, <-29.944, 187.3312, -59.3921> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-29.944, 187.3312, -59.3921>, <-30.3678, 185.7452, -58.9578>, <-30.4805, 186.6411, -58.5939> }
					triangle { <-30.1211, 185.0409, -58.3609>, <-31.05741, 185.5492, -57.1198>, <-30.8559, 186.075, -58.1737> }
					triangle { <-30.3678, 185.7452, -58.9578>, <-30.8559, 186.075, -58.1737>, <-30.4805, 186.6411, -58.5939> }
					triangle { <-30.3678, 185.7452, -58.9578>, <-30.1211, 185.0409, -58.3609>, <-30.8559, 186.075, -58.1737> }
					triangle { <-30.1211, 185.0409, -58.3609>, <-29.9206, 184.5992, -57.1671>, <-31.05741, 185.5492, -57.1198> }
					triangle { <-29.9206, 184.5992, -57.1671>, <-29.966, 184.284, -55.9937>, <-31.06847, 185.2318, -56.2753> }
					triangle { <-29.9206, 184.5992, -57.1671>, <-31.06847, 185.2318, -56.2753>, <-31.05741, 185.5492, -57.1198> }
					triangle { <-29.966, 184.284, -55.9937>, <-30.189, 183.9904, -54.7282>, <-30.9995, 184.7503, -54.5347> }
					triangle { <-29.966, 184.284, -55.9937>, <-30.9995, 184.7503, -54.5347>, <-31.06847, 185.2318, -56.2753> }
					triangle { <-30.189, 183.9904, -54.7282>, <-32.8143, 184.2887, -54.6721>, <-32.5345, 184.5745, -54.2876> }
					triangle { <-30.189, 183.9904, -54.7282>, <-32.5345, 184.5745, -54.2876>, <-30.9995, 184.7503, -54.5347> }
					triangle { <-30.9995, 184.7503, -54.5347>, <-32.5345, 184.5745, -54.2876>, <-32.3838, 185.0851, -54.02904> }
					triangle { <-30.4805, 186.6411, -58.5939>, <-30.8559, 186.075, -58.1737>, <-30.8277, 186.0209, -56.9635> }
					triangle { <-30.8559, 186.075, -58.1737>, <-31.05741, 185.5492, -57.1198>, <-30.8277, 186.0209, -56.9635> }
					triangle { <-31.05741, 185.5492, -57.1198>, <-31.06847, 185.2318, -56.2753>, <-30.8277, 186.0209, -56.9635> }
					triangle { <-31.06847, 185.2318, -56.2753>, <-31.2661, 185.4487, -54.3333>, <-30.8277, 186.0209, -56.9635> }
					triangle { <-31.06847, 185.2318, -56.2753>, <-30.9995, 184.7503, -54.5347>, <-31.2661, 185.4487, -54.3333> }
					triangle { <-30.9995, 184.7503, -54.5347>, <-32.3838, 185.0851, -54.02904>, <-31.2661, 185.4487, -54.3333> }
					triangle { <-32.3838, 185.0851, -54.02904>, <-32.2191, 185.6503, -53.8001>, <-31.2661, 185.4487, -54.3333> }
					triangle { <-29.944, 187.3312, -59.3921>, <-30.4805, 186.6411, -58.5939>, <-30.8163, 187.2556, -58.3745> }
					triangle { <-30.4805, 186.6411, -58.5939>, <-30.8277, 186.0209, -56.9635>, <-30.8163, 187.2556, -58.3745> }
					triangle { <-30.8277, 186.0209, -56.9635>, <-31.06618, 186.8284, -56.8215>, <-30.8163, 187.2556, -58.3745> }
					triangle { <-30.8277, 186.0209, -56.9635>, <-31.2661, 185.4487, -54.3333>, <-31.06618, 186.8284, -56.8215> }
					triangle { <-31.06618, 186.8284, -56.8215>, <-31.2661, 185.4487, -54.3333>, <-31.5284, 186.1735, -54.2178> }
					triangle { <-31.2661, 185.4487, -54.3333>, <-32.2191, 185.6503, -53.8001>, <-31.5284, 186.1735, -54.2178> }
					triangle { <-32.2191, 185.6503, -53.8001>, <-32.204, 186.1952, -53.679>, <-31.5284, 186.1735, -54.2178> }
					triangle { <-29.944, 187.3312, -59.3921>, <-30.7076, 186.4339, -59.4228>, <-30.3678, 185.7452, -58.9578> }
					triangle { <-30.1944, 187.6325, -58.2751>, <-29.6051, 188.3891, -58.1077>, <-29.944, 187.3312, -59.3921> }
					triangle { <-30.3076, 187.9753, -57.5626>, <-30.39, 187.8626, -56.376>, <-29.1439, 188.4283, -57.2716> }
					triangle { <-30.1944, 187.6325, -58.2751>, <-30.3076, 187.9753, -57.5626>, <-29.6051, 188.3891, -58.1077> }
					triangle { <-30.3076, 187.9753, -57.5626>, <-29.1439, 188.4283, -57.2716>, <-29.6051, 188.3891, -58.1077> }
					triangle { <-30.39, 187.8626, -56.376>, <-28.9433, 187.9866, -56.0779>, <-29.1439, 188.4283, -57.2716> }
					triangle { <-30.3772, 187.6278, -55.5049>, <-29.01259, 187.5888, -54.931>, <-28.9433, 187.9866, -56.0779> }
					triangle { <-30.39, 187.8626, -56.376>, <-30.3772, 187.6278, -55.5049>, <-28.9433, 187.9866, -56.0779> }
					triangle { <-30.3559, 186.9811, -53.8174>, <-29.2594, 187.2126, -53.6921>, <-29.01259, 187.5888, -54.931> }
					triangle { <-30.3772, 187.6278, -55.5049>, <-30.3559, 186.9811, -53.8174>, <-29.01259, 187.5888, -54.931> }
					triangle { <-31.6926, 187.4811, -53.2586>, <-31.5466, 188.0279, -53.4132>, <-29.2594, 187.2126, -53.6921> }
					triangle { <-30.3559, 186.9811, -53.8174>, <-31.6926, 187.4811, -53.2586>, <-29.2594, 187.2126, -53.6921> }
					triangle { <-31.9992, 187.0615, -53.3555>, <-31.6926, 187.4811, -53.2586>, <-30.3559, 186.9811, -53.8174> }
					triangle { <-30.4463, 187.3428, -56.5385>, <-30.3076, 187.9753, -57.5626>, <-30.1944, 187.6325, -58.2751> }
					triangle { <-30.4463, 187.3428, -56.5385>, <-30.39, 187.8626, -56.376>, <-30.3076, 187.9753, -57.5626> }
					triangle { <-30.4463, 187.3428, -56.5385>, <-30.3772, 187.6278, -55.5049>, <-30.39, 187.8626, -56.376> }
					triangle { <-30.4463, 187.3428, -56.5385>, <-30.9562, 186.5228, -53.9879>, <-30.3772, 187.6278, -55.5049> }
					triangle { <-30.9562, 186.5228, -53.9879>, <-30.3559, 186.9811, -53.8174>, <-30.3772, 187.6278, -55.5049> }
					triangle { <-30.9562, 186.5228, -53.9879>, <-31.9992, 187.0615, -53.3555>, <-30.3559, 186.9811, -53.8174> }
					triangle { <-30.9562, 186.5228, -53.9879>, <-32.1303, 186.6071, -53.5016>, <-31.9992, 187.0615, -53.3555> }
					triangle { <-30.8163, 187.2556, -58.3745>, <-30.1944, 187.6325, -58.2751>, <-29.944, 187.3312, -59.3921> }
					triangle { <-30.8163, 187.2556, -58.3745>, <-30.4463, 187.3428, -56.5385>, <-30.1944, 187.6325, -58.2751> }
					triangle { <-30.8163, 187.2556, -58.3745>, <-31.06618, 186.8284, -56.8215>, <-30.4463, 187.3428, -56.5385> }
					triangle { <-31.06618, 186.8284, -56.8215>, <-30.9562, 186.5228, -53.9879>, <-30.4463, 187.3428, -56.5385> }
					triangle { <-31.5284, 186.1735, -54.2178>, <-30.9562, 186.5228, -53.9879>, <-31.06618, 186.8284, -56.8215> }
					triangle { <-31.5284, 186.1735, -54.2178>, <-32.1303, 186.6071, -53.5016>, <-30.9562, 186.5228, -53.9879> }
					triangle { <-31.5284, 186.1735, -54.2178>, <-32.204, 186.1952, -53.679>, <-32.1303, 186.6071, -53.5016> }
					triangle { <-29.6051, 188.3891, -58.1077>, <-30.1594, 188.3342, -58.8118>, <-29.944, 187.3312, -59.3921> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-29.4208, 186.793, -60.4007>, <-29.5997, 187.7099, -60.7573>, 0.55 }
			cylinder { <-29.5997, 187.7099, -60.7573>, <-29.7906, 188.6361, -61.08266>, 0.55 }
			cylinder { <-29.7906, 188.6361, -61.08266>, <-29.9931, 189.5703, -61.3763>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-29.9931, 189.5703, -61.3763>, <-29.7802, 189.9395, -61.6377>, 0.55 }
				cylinder { <-29.7802, 189.9395, -61.6377>, <-29.3566, 190.0316, -61.8869>, 0.55 }
				cylinder { <-29.3566, 190.0316, -61.8869>, <-28.9279, 189.8017, -62.00278>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-28.9279, 189.8017, -62.00278>, <-29.1901, 188.2763, -62.7011>, <-28.5254, 188.6954, -62.1265> }
					triangle { <-28.8857, 187.7163, -63.4131>, <-27.6636, 187.0339, -62.5671>, <-28.4025, 187.9147, -62.2421> }
					triangle { <-29.1901, 188.2763, -62.7011>, <-28.4025, 187.9147, -62.2421>, <-28.5254, 188.6954, -62.1265> }
					triangle { <-29.1901, 188.2763, -62.7011>, <-28.8857, 187.7163, -63.4131>, <-28.4025, 187.9147, -62.2421> }
					triangle { <-28.8857, 187.7163, -63.4131>, <-27.9391, 187.0891, -64.02249>, <-27.6636, 187.0339, -62.5671> }
					triangle { <-27.9391, 187.0891, -64.02249>, <-26.9914, 186.4064, -64.36>, <-27.0138, 186.4928, -62.8818> }
					triangle { <-27.9391, 187.0891, -64.02249>, <-27.0138, 186.4928, -62.8818>, <-27.6636, 187.0339, -62.5671> }
					triangle { <-26.9914, 186.4064, -64.36>, <-25.9718, 185.5953, -64.5602>, <-25.5973, 185.5541, -63.4973> }
					triangle { <-26.9914, 186.4064, -64.36>, <-25.5973, 185.5541, -63.4973>, <-27.0138, 186.4928, -62.8818> }
					triangle { <-25.9718, 185.5953, -64.5602>, <-26.1133, 184.168, -62.3405>, <-25.6185, 184.3963, -62.445> }
					triangle { <-25.9718, 185.5953, -64.5602>, <-25.6185, 184.3963, -62.445>, <-25.5973, 185.5541, -63.4973> }
					triangle { <-25.5973, 185.5541, -63.4973>, <-25.6185, 184.3963, -62.445>, <-25.1677, 184.7483, -62.293> }
					triangle { <-28.5254, 188.6954, -62.1265>, <-28.4025, 187.9147, -62.2421>, <-27.3121, 187.4453, -62.4844> }
					triangle { <-28.4025, 187.9147, -62.2421>, <-27.6636, 187.0339, -62.5671>, <-27.3121, 187.4453, -62.4844> }
					triangle { <-27.6636, 187.0339, -62.5671>, <-27.0138, 186.4928, -62.8818>, <-27.3121, 187.4453, -62.4844> }
					triangle { <-27.0138, 186.4928, -62.8818>, <-25.1754, 185.8015, -62.8971>, <-27.3121, 187.4453, -62.4844> }
					triangle { <-27.0138, 186.4928, -62.8818>, <-25.5973, 185.5541, -63.4973>, <-25.1754, 185.8015, -62.8971> }
					triangle { <-25.5973, 185.5541, -63.4973>, <-25.1677, 184.7483, -62.293>, <-25.1754, 185.8015, -62.8971> }
					triangle { <-25.1677, 184.7483, -62.293>, <-24.7213, 185.1579, -62.1143>, <-25.1754, 185.8015, -62.8971> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-28.5254, 188.6954, -62.1265>, <-28.1275, 188.8352, -61.5259> }
					triangle { <-28.5254, 188.6954, -62.1265>, <-27.3121, 187.4453, -62.4844>, <-28.1275, 188.8352, -61.5259> }
					triangle { <-27.3121, 187.4453, -62.4844>, <-26.8993, 187.8079, -61.8308>, <-28.1275, 188.8352, -61.5259> }
					triangle { <-27.3121, 187.4453, -62.4844>, <-25.1754, 185.8015, -62.8971>, <-26.8993, 187.8079, -61.8308> }
					triangle { <-26.8993, 187.8079, -61.8308>, <-25.1754, 185.8015, -62.8971>, <-24.8215, 186.1018, -62.2709> }
					triangle { <-25.1754, 185.8015, -62.8971>, <-24.7213, 185.1579, -62.1143>, <-24.8215, 186.1018, -62.2709> }
					triangle { <-24.7213, 185.1579, -62.1143>, <-24.3991, 185.5015, -61.8144>, <-24.8215, 186.1018, -62.2709> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-29.3907, 188.7192, -61.9465>, <-29.1901, 188.2763, -62.7011> }
					triangle { <-27.8186, 189.4429, -61.7978>, <-27.3053, 190.2696, -61.8247>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-27.04777, 189.3475, -61.6121>, <-26.01433, 188.778, -61.8002>, <-26.4706, 190.2702, -62.2902> }
					triangle { <-27.8186, 189.4429, -61.7978>, <-27.04777, 189.3475, -61.6121>, <-27.3053, 190.2696, -61.8247> }
					triangle { <-27.04777, 189.3475, -61.6121>, <-26.4706, 190.2702, -62.2902>, <-27.3053, 190.2696, -61.8247> }
					triangle { <-26.01433, 188.778, -61.8002>, <-25.5241, 189.6431, -62.8995>, <-26.4706, 190.2702, -62.2902> }
					triangle { <-25.3056, 188.2993, -62.08754>, <-24.6353, 188.8981, -63.2644>, <-25.5241, 189.6431, -62.8995> }
					triangle { <-26.01433, 188.778, -61.8002>, <-25.3056, 188.2993, -62.08754>, <-25.5241, 189.6431, -62.8995> }
					triangle { <-24.00699, 187.236, -62.7578>, <-23.6746, 188.0247, -63.492>, <-24.6353, 188.8981, -63.2644> }
					triangle { <-25.3056, 188.2993, -62.08754>, <-24.00699, 187.236, -62.7578>, <-24.6353, 188.8981, -63.2644> }
					triangle { <-23.4595, 186.5548, -61.4987>, <-23.3736, 187.0825, -61.257>, <-23.6746, 188.0247, -63.492> }
					triangle { <-24.00699, 187.236, -62.7578>, <-23.4595, 186.5548, -61.4987>, <-23.6746, 188.0247, -63.492> }
					triangle { <-23.7456, 186.1103, -61.499>, <-23.4595, 186.5548, -61.4987>, <-24.00699, 187.236, -62.7578> }
					triangle { <-26.3696, 188.442, -62.04623>, <-27.04777, 189.3475, -61.6121>, <-27.8186, 189.4429, -61.7978> }
					triangle { <-26.3696, 188.442, -62.04623>, <-26.01433, 188.778, -61.8002>, <-27.04777, 189.3475, -61.6121> }
					triangle { <-26.3696, 188.442, -62.04623>, <-25.3056, 188.2993, -62.08754>, <-26.01433, 188.778, -61.8002> }
					triangle { <-26.3696, 188.442, -62.04623>, <-24.4097, 186.6113, -62.5411>, <-25.3056, 188.2993, -62.08754> }
					triangle { <-24.4097, 186.6113, -62.5411>, <-24.00699, 187.236, -62.7578>, <-25.3056, 188.2993, -62.08754> }
					triangle { <-24.4097, 186.6113, -62.5411>, <-23.7456, 186.1103, -61.499>, <-24.00699, 187.236, -62.7578> }
					triangle { <-24.4097, 186.6113, -62.5411>, <-24.06962, 185.7677, -61.6496>, <-23.7456, 186.1103, -61.499> }
					triangle { <-28.1275, 188.8352, -61.5259>, <-27.8186, 189.4429, -61.7978>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-28.1275, 188.8352, -61.5259>, <-26.3696, 188.442, -62.04623>, <-27.8186, 189.4429, -61.7978> }
					triangle { <-28.1275, 188.8352, -61.5259>, <-26.8993, 187.8079, -61.8308>, <-26.3696, 188.442, -62.04623> }
					triangle { <-26.8993, 187.8079, -61.8308>, <-24.4097, 186.6113, -62.5411>, <-26.3696, 188.442, -62.04623> }
					triangle { <-24.8215, 186.1018, -62.2709>, <-24.4097, 186.6113, -62.5411>, <-26.8993, 187.8079, -61.8308> }
					triangle { <-24.8215, 186.1018, -62.2709>, <-24.06962, 185.7677, -61.6496>, <-24.4097, 186.6113, -62.5411> }
					triangle { <-24.8215, 186.1018, -62.2709>, <-24.3991, 185.5015, -61.8144>, <-24.06962, 185.7677, -61.6496> }
					triangle { <-27.3053, 190.2696, -61.8247>, <-28.03598, 190.152, -61.3165>, <-28.9279, 189.8017, -62.00278> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-28.9279, 189.8017, -62.00278>, <-28.2783, 189.8766, -63.5699>, <-28.4268, 189.1973, -62.8886> }
					triangle { <-27.4437, 189.8772, -64.03545>, <-27.3219, 188.2499, -64.1453>, <-28.1424, 188.9053, -63.5755> }
					triangle { <-28.2783, 189.8766, -63.5699>, <-28.1424, 188.9053, -63.5755>, <-28.4268, 189.1973, -62.8886> }
					triangle { <-28.2783, 189.8766, -63.5699>, <-27.4437, 189.8772, -64.03545>, <-28.1424, 188.9053, -63.5755> }
					triangle { <-27.4437, 189.8772, -64.03545>, <-26.3147, 189.3238, -64.3175>, <-27.3219, 188.2499, -64.1453> }
					triangle { <-26.3147, 189.3238, -64.3175>, <-25.3955, 188.591, -64.6279>, <-26.6132, 187.7711, -64.4326> }
					triangle { <-26.3147, 189.3238, -64.3175>, <-26.6132, 187.7711, -64.4326>, <-27.3219, 188.2499, -64.1453> }
					triangle { <-25.3955, 188.591, -64.6279>, <-24.526, 187.6808, -65.01912>, <-25.1625, 186.7693, -64.8302> }
					triangle { <-25.3955, 188.591, -64.6279>, <-25.1625, 186.7693, -64.8302>, <-26.6132, 187.7711, -64.4326> }
					triangle { <-24.526, 187.6808, -65.01912>, <-26.1748, 185.9913, -66.207>, <-25.8434, 185.7686, -65.8218> }
					triangle { <-24.526, 187.6808, -65.01912>, <-25.8434, 185.7686, -65.8218>, <-25.1625, 186.7693, -64.8302> }
					triangle { <-25.1625, 186.7693, -64.8302>, <-25.8434, 185.7686, -65.8218>, <-25.7629, 185.4704, -65.3169> }
					triangle { <-28.4268, 189.1973, -62.8886>, <-28.1424, 188.9053, -63.5755>, <-27.2515, 188.0858, -63.6278> }
					triangle { <-28.1424, 188.9053, -63.5755>, <-27.3219, 188.2499, -64.1453>, <-27.2515, 188.0858, -63.6278> }
					triangle { <-27.3219, 188.2499, -64.1453>, <-26.6132, 187.7711, -64.4326>, <-27.2515, 188.0858, -63.6278> }
					triangle { <-26.6132, 187.7711, -64.4326>, <-25.4436, 186.1937, -64.3954>, <-27.2515, 188.0858, -63.6278> }
					triangle { <-26.6132, 187.7711, -64.4326>, <-25.1625, 186.7693, -64.8302>, <-25.4436, 186.1937, -64.3954> }
					triangle { <-25.1625, 186.7693, -64.8302>, <-25.7629, 185.4704, -65.3169>, <-25.4436, 186.1937, -64.3954> }
					triangle { <-25.7629, 185.4704, -65.3169>, <-25.7155, 185.1799, -64.7581>, <-25.4436, 186.1937, -64.3954> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-28.4268, 189.1973, -62.8886>, <-28.7053, 188.6019, -62.5621> }
					triangle { <-28.4268, 189.1973, -62.8886>, <-27.2515, 188.0858, -63.6278>, <-28.7053, 188.6019, -62.5621> }
					triangle { <-27.2515, 188.0858, -63.6278>, <-27.5987, 187.5254, -63.08528>, <-28.7053, 188.6019, -62.5621> }
					triangle { <-27.2515, 188.0858, -63.6278>, <-25.4436, 186.1937, -64.3954>, <-27.5987, 187.5254, -63.08528> }
					triangle { <-27.5987, 187.5254, -63.08528>, <-25.4436, 186.1937, -64.3954>, <-25.7927, 185.671, -63.9345> }
					triangle { <-25.4436, 186.1937, -64.3954>, <-25.7155, 185.1799, -64.7581>, <-25.7927, 185.671, -63.9345> }
					triangle { <-25.7155, 185.1799, -64.7581>, <-25.8264, 184.8866, -64.296>, <-25.7927, 185.671, -63.9345> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-29.06989, 189.7344, -63.1708>, <-28.2783, 189.8766, -63.5699> }
					triangle { <-28.4038, 188.7445, -61.9084>, <-28.2171, 188.6693, -60.9559>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-28.09844, 188.0376, -61.6967>, <-27.2682, 187.1935, -61.8581>, <-27.3652, 188.3304, -60.6862> }
					triangle { <-28.4038, 188.7445, -61.9084>, <-28.09844, 188.0376, -61.6967>, <-28.2171, 188.6693, -60.9559> }
					triangle { <-28.09844, 188.0376, -61.6967>, <-27.3652, 188.3304, -60.6862>, <-28.2171, 188.6693, -60.9559> }
					triangle { <-27.2682, 187.1935, -61.8581>, <-26.2362, 187.7769, -60.9683>, <-27.3652, 188.3304, -60.6862> }
					triangle { <-26.5576, 186.677, -62.06375>, <-25.3189, 187.0819, -61.3604>, <-26.2362, 187.7769, -60.9683> }
					triangle { <-27.2682, 187.1935, -61.8581>, <-26.5576, 186.677, -62.06375>, <-26.2362, 187.7769, -60.9683> }
					triangle { <-25.1108, 185.7506, -62.6247>, <-24.4514, 186.2094, -61.8333>, <-25.3189, 187.0819, -61.3604> }
					triangle { <-26.5576, 186.677, -62.06375>, <-25.1108, 185.7506, -62.6247>, <-25.3189, 187.0819, -61.3604> }
					triangle { <-25.7074, 184.3763, -62.9479>, <-25.9349, 184.3539, -62.4076>, <-24.4514, 186.2094, -61.8333> }
					triangle { <-25.1108, 185.7506, -62.6247>, <-25.7074, 184.3763, -62.9479>, <-24.4514, 186.2094, -61.8333> }
					triangle { <-25.8017, 184.4328, -63.465>, <-25.7074, 184.3763, -62.9479>, <-25.1108, 185.7506, -62.6247> }
					triangle { <-27.2208, 187.4822, -62.3208>, <-28.09844, 188.0376, -61.6967>, <-28.4038, 188.7445, -61.9084> }
					triangle { <-27.2208, 187.4822, -62.3208>, <-27.2682, 187.1935, -61.8581>, <-28.09844, 188.0376, -61.6967> }
					triangle { <-27.2208, 187.4822, -62.3208>, <-26.5576, 186.677, -62.06375>, <-27.2682, 187.1935, -61.8581> }
					triangle { <-27.2208, 187.4822, -62.3208>, <-25.4187, 185.7032, -63.3334>, <-26.5576, 186.677, -62.06375> }
					triangle { <-25.4187, 185.7032, -63.3334>, <-25.1108, 185.7506, -62.6247>, <-26.5576, 186.677, -62.06375> }
					triangle { <-25.4187, 185.7032, -63.3334>, <-25.8017, 184.4328, -63.465>, <-25.1108, 185.7506, -62.6247> }
					triangle { <-25.4187, 185.7032, -63.3334>, <-25.8122, 184.6403, -63.9143>, <-25.8017, 184.4328, -63.465> }
					triangle { <-28.7053, 188.6019, -62.5621>, <-28.4038, 188.7445, -61.9084>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-28.7053, 188.6019, -62.5621>, <-27.2208, 187.4822, -62.3208>, <-28.4038, 188.7445, -61.9084> }
					triangle { <-28.7053, 188.6019, -62.5621>, <-27.5987, 187.5254, -63.08528>, <-27.2208, 187.4822, -62.3208> }
					triangle { <-27.5987, 187.5254, -63.08528>, <-25.4187, 185.7032, -63.3334>, <-27.2208, 187.4822, -62.3208> }
					triangle { <-25.7927, 185.671, -63.9345>, <-25.4187, 185.7032, -63.3334>, <-27.5987, 187.5254, -63.08528> }
					triangle { <-25.7927, 185.671, -63.9345>, <-25.8122, 184.6403, -63.9143>, <-25.4187, 185.7032, -63.3334> }
					triangle { <-25.7927, 185.671, -63.9345>, <-25.8264, 184.8866, -64.296>, <-25.8122, 184.6403, -63.9143> }
					triangle { <-28.2171, 188.6693, -60.9559>, <-29.02584, 188.8666, -61.292>, <-28.9279, 189.8017, -62.00278> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-28.9279, 189.8017, -62.00278>, <-27.3053, 190.2696, -61.8247>, <-27.8339, 189.7447, -62.4513> }
					triangle { <-26.4534, 189.9307, -61.555>, <-26.04305, 189.344, -63.02553>, <-27.07267, 189.8379, -62.674> }
					triangle { <-27.3053, 190.2696, -61.8247>, <-27.07267, 189.8379, -62.674>, <-27.8339, 189.7447, -62.4513> }
					triangle { <-27.3053, 190.2696, -61.8247>, <-26.4534, 189.9307, -61.555>, <-27.07267, 189.8379, -62.674> }
					triangle { <-26.4534, 189.9307, -61.555>, <-25.4954, 189.0772, -61.6742>, <-26.04305, 189.344, -63.02553> }
					triangle { <-25.4954, 189.0772, -61.6742>, <-24.6065, 188.3322, -62.03915>, <-25.3324, 188.8275, -63.2311> }
					triangle { <-25.4954, 189.0772, -61.6742>, <-25.3324, 188.8275, -63.2311>, <-26.04305, 189.344, -63.02553> }
					triangle { <-24.6065, 188.3322, -62.03915>, <-23.6535, 187.6097, -62.5934>, <-24.02805, 187.651, -63.6563> }
					triangle { <-24.6065, 188.3322, -62.03915>, <-24.02805, 187.651, -63.6563>, <-25.3324, 188.8275, -63.2311> }
					triangle { <-23.6535, 187.6097, -62.5934>, <-23.376, 188.9313, -64.8651>, <-23.4626, 188.3857, -64.9168> }
					triangle { <-23.6535, 187.6097, -62.5934>, <-23.4626, 188.3857, -64.9168>, <-24.02805, 187.651, -63.6563> }
					triangle { <-24.02805, 187.651, -63.6563>, <-23.4626, 188.3857, -64.9168>, <-23.7774, 187.9279, -65.1208> }
					triangle { <-27.8339, 189.7447, -62.4513>, <-27.07267, 189.8379, -62.674>, <-26.3945, 188.9325, -63.1081> }
					triangle { <-27.07267, 189.8379, -62.674>, <-26.04305, 189.344, -63.02553>, <-26.3945, 188.9325, -63.1081> }
					triangle { <-26.04305, 189.344, -63.02553>, <-25.3324, 188.8275, -63.2311>, <-26.3945, 188.9325, -63.1081> }
					triangle { <-25.3324, 188.8275, -63.2311>, <-24.4499, 187.4036, -64.2565>, <-26.3945, 188.9325, -63.1081> }
					triangle { <-25.3324, 188.8275, -63.2311>, <-24.02805, 187.651, -63.6563>, <-24.4499, 187.4036, -64.2565> }
					triangle { <-24.02805, 187.651, -63.6563>, <-23.7774, 187.9279, -65.1208>, <-24.4499, 187.4036, -64.2565> }
					triangle { <-23.7774, 187.9279, -65.1208>, <-24.1558, 187.4655, -65.3255>, <-24.4499, 187.4036, -64.2565> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-27.8339, 189.7447, -62.4513>, <-28.1639, 189.552, -63.07801> }
					triangle { <-27.8339, 189.7447, -62.4513>, <-26.3945, 188.9325, -63.1081>, <-28.1639, 189.552, -63.07801> }
					triangle { <-26.3945, 188.9325, -63.1081>, <-26.9433, 188.6757, -63.7097>, <-28.1639, 189.552, -63.07801> }
					triangle { <-26.3945, 188.9325, -63.1081>, <-24.4499, 187.4036, -64.2565>, <-26.9433, 188.6757, -63.7097> }
					triangle { <-26.9433, 188.6757, -63.7097>, <-24.4499, 187.4036, -64.2565>, <-24.9398, 187.209, -64.8306> }
					triangle { <-24.4499, 187.4036, -64.2565>, <-24.1558, 187.4655, -65.3255>, <-24.9398, 187.209, -64.8306> }
					triangle { <-24.1558, 187.4655, -65.3255>, <-24.5461, 187.1747, -65.5994>, <-24.9398, 187.209, -64.8306> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-28.05705, 190.567, -62.2151>, <-27.3053, 190.2696, -61.8247> }
					triangle { <-28.5408, 188.9972, -62.78>, <-29.1901, 188.2763, -62.7011>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-28.4274, 188.4052, -63.304>, <-27.6923, 187.5998, -63.7924>, <-28.8684, 187.3767, -62.6779> }
					triangle { <-28.5408, 188.9972, -62.78>, <-28.4274, 188.4052, -63.304>, <-29.1901, 188.2763, -62.7011> }
					triangle { <-28.4274, 188.4052, -63.304>, <-28.8684, 187.3767, -62.6779>, <-29.1901, 188.2763, -62.7011> }
					triangle { <-27.6923, 187.5998, -63.7924>, <-27.9104, 186.5232, -62.7971>, <-28.8684, 187.3767, -62.6779> }
					triangle { <-27.04061, 187.021, -64.02546>, <-26.9626, 185.8405, -63.1347>, <-27.9104, 186.5232, -62.7971> }
					triangle { <-27.6923, 187.5998, -63.7924>, <-27.04061, 187.021, -64.02546>, <-27.9104, 186.5232, -62.7971> }
					triangle { <-25.6184, 185.9691, -64.3958>, <-25.9507, 185.1803, -63.6616>, <-26.9626, 185.8405, -63.1347> }
					triangle { <-27.04061, 187.021, -64.02546>, <-25.6184, 185.9691, -64.3958>, <-26.9626, 185.8405, -63.1347> }
					triangle { <-25.4856, 186.1215, -65.9151>, <-26.0477, 185.9639, -65.9747>, <-25.9507, 185.1803, -63.6616> }
					triangle { <-25.6184, 185.9691, -64.3958>, <-25.4856, 186.1215, -65.9151>, <-25.9507, 185.1803, -63.6616> }
					triangle { <-25.1315, 186.5131, -65.9409>, <-25.4856, 186.1215, -65.9151>, <-25.6184, 185.9691, -64.3958> }
					triangle { <-27.337, 187.9358, -63.5464>, <-28.4274, 188.4052, -63.304>, <-28.5408, 188.9972, -62.78> }
					triangle { <-27.337, 187.9358, -63.5464>, <-27.6923, 187.5998, -63.7924>, <-28.4274, 188.4052, -63.304> }
					triangle { <-27.337, 187.9358, -63.5464>, <-27.04061, 187.021, -64.02546>, <-27.6923, 187.5998, -63.7924> }
					triangle { <-27.337, 187.9358, -63.5464>, <-25.2156, 186.5938, -64.6126>, <-27.04061, 187.021, -64.02546> }
					triangle { <-25.2156, 186.5938, -64.6126>, <-25.6184, 185.9691, -64.3958>, <-27.04061, 187.021, -64.02546> }
					triangle { <-25.2156, 186.5938, -64.6126>, <-25.1315, 186.5131, -65.9409>, <-25.6184, 185.9691, -64.3958> }
					triangle { <-25.2156, 186.5938, -64.6126>, <-24.8075, 186.8557, -65.7902>, <-25.1315, 186.5131, -65.9409> }
					triangle { <-28.1639, 189.552, -63.07801>, <-28.5408, 188.9972, -62.78>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-28.1639, 189.552, -63.07801>, <-27.337, 187.9358, -63.5464>, <-28.5408, 188.9972, -62.78> }
					triangle { <-28.1639, 189.552, -63.07801>, <-26.9433, 188.6757, -63.7097>, <-27.337, 187.9358, -63.5464> }
					triangle { <-26.9433, 188.6757, -63.7097>, <-25.2156, 186.5938, -64.6126>, <-27.337, 187.9358, -63.5464> }
					triangle { <-24.9398, 187.209, -64.8306>, <-25.2156, 186.5938, -64.6126>, <-26.9433, 188.6757, -63.7097> }
					triangle { <-24.9398, 187.209, -64.8306>, <-24.8075, 186.8557, -65.7902>, <-25.2156, 186.5938, -64.6126> }
					triangle { <-24.9398, 187.209, -64.8306>, <-24.5461, 187.1747, -65.5994>, <-24.8075, 186.8557, -65.7902> }
					triangle { <-29.1901, 188.2763, -62.7011>, <-29.4118, 189.1342, -62.845>, <-28.9279, 189.8017, -62.00278> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-28.9279, 189.8017, -62.00278>, <-28.2171, 188.6693, -60.9559>, <-27.9326, 189.2429, -61.6892> }
					triangle { <-27.8953, 187.7697, -60.9327>, <-26.3847, 188.1279, -61.4472>, <-27.3327, 188.8474, -61.3406> }
					triangle { <-28.2171, 188.6693, -60.9559>, <-27.3327, 188.8474, -61.3406>, <-27.9326, 189.2429, -61.6892> }
					triangle { <-28.2171, 188.6693, -60.9559>, <-27.8953, 187.7697, -60.9327>, <-27.3327, 188.8474, -61.3406> }
					triangle { <-27.8953, 187.7697, -60.9327>, <-27.1197, 186.8425, -61.3791>, <-26.3847, 188.1279, -61.4472> }
					triangle { <-27.1197, 186.8425, -61.3791>, <-26.2024, 186.1475, -61.7712>, <-25.733, 187.5491, -61.6803> }
					triangle { <-27.1197, 186.8425, -61.3791>, <-25.733, 187.5491, -61.6803>, <-26.3847, 188.1279, -61.4472> }
					triangle { <-26.2024, 186.1475, -61.7712>, <-25.09932, 185.5242, -62.1345>, <-24.4628, 186.4358, -62.3234> }
					triangle { <-26.2024, 186.1475, -61.7712>, <-24.4628, 186.4358, -62.3234>, <-25.733, 187.5491, -61.6803> }
					triangle { <-25.09932, 185.5242, -62.1345>, <-23.3145, 187.108, -60.9987>, <-23.2378, 187.0134, -61.5399> }
					triangle { <-25.09932, 185.5242, -62.1345>, <-23.2378, 187.0134, -61.5399>, <-24.4628, 186.4358, -62.3234> }
					triangle { <-24.4628, 186.4358, -62.3234>, <-23.2378, 187.0134, -61.5399>, <-23.1822, 187.2058, -62.09697> }
					triangle { <-27.9326, 189.2429, -61.6892>, <-27.3327, 188.8474, -61.3406>, <-26.4551, 188.292, -61.9647> }
					triangle { <-27.3327, 188.8474, -61.3406>, <-26.3847, 188.1279, -61.4472>, <-26.4551, 188.292, -61.9647> }
					triangle { <-26.3847, 188.1279, -61.4472>, <-25.733, 187.5491, -61.6803>, <-26.4551, 188.292, -61.9647> }
					triangle { <-25.733, 187.5491, -61.6803>, <-24.1817, 187.0114, -62.7582>, <-26.4551, 188.292, -61.9647> }
					triangle { <-25.733, 187.5491, -61.6803>, <-24.4628, 186.4358, -62.3234>, <-24.1817, 187.0114, -62.7582> }
					triangle { <-24.4628, 186.4358, -62.3234>, <-23.1822, 187.2058, -62.09697>, <-24.1817, 187.0114, -62.7582> }
					triangle { <-23.1822, 187.2058, -62.09697>, <-23.1616, 187.4435, -62.6817>, <-24.1817, 187.0114, -62.7582> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-27.9326, 189.2429, -61.6892>, <-27.5861, 189.7854, -62.04178> }
					triangle { <-27.9326, 189.2429, -61.6892>, <-26.4551, 188.292, -61.9647>, <-27.5861, 189.7854, -62.04178> }
					triangle { <-26.4551, 188.292, -61.9647>, <-26.2439, 188.9582, -62.4553>, <-27.5861, 189.7854, -62.04178> }
					triangle { <-26.4551, 188.292, -61.9647>, <-24.1817, 187.0114, -62.7582>, <-26.2439, 188.9582, -62.4553> }
					triangle { <-26.2439, 188.9582, -62.4553>, <-24.1817, 187.0114, -62.7582>, <-23.9686, 187.6398, -63.1671> }
					triangle { <-24.1817, 187.0114, -62.7582>, <-23.1616, 187.4435, -62.6817>, <-23.9686, 187.6398, -63.1671> }
					triangle { <-23.1616, 187.4435, -62.6817>, <-23.1188, 187.7897, -63.1178>, <-23.9686, 187.6398, -63.1671> }
					triangle { <-28.9279, 189.8017, -62.00278>, <-28.3779, 189.5518, -60.9907>, <-28.2171, 188.6693, -60.9559> }
					triangle { <-27.9556, 189.6956, -62.6695>, <-28.2783, 189.8766, -63.5699>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-27.3767, 189.7151, -63.2194>, <-26.4383, 189.1843, -63.7345>, <-27.9739, 189.3166, -64.2819> }
					triangle { <-27.9556, 189.6956, -62.6695>, <-27.3767, 189.7151, -63.2194>, <-28.2783, 189.8766, -63.5699> }
					triangle { <-27.3767, 189.7151, -63.2194>, <-27.9739, 189.3166, -64.2819>, <-28.2783, 189.8766, -63.5699> }
					triangle { <-26.4383, 189.1843, -63.7345>, <-27.1983, 188.3894, -64.7283>, <-27.9739, 189.3166, -64.2819> }
					triangle { <-25.7885, 188.6432, -64.04925>, <-26.279, 187.6567, -65.03877>, <-27.1983, 188.3894, -64.7283> }
					triangle { <-26.4383, 189.1843, -63.7345>, <-25.7885, 188.6432, -64.04925>, <-27.1983, 188.3894, -64.7283> }
					triangle { <-24.5146, 187.4545, -64.5289>, <-25.174, 186.9956, -65.3204>, <-26.279, 187.6567, -65.03877> }
					triangle { <-25.7885, 188.6432, -64.04925>, <-24.5146, 187.4545, -64.5289>, <-26.279, 187.6567, -65.03877> }
					triangle { <-23.2378, 188.2999, -64.4659>, <-23.4864, 188.6925, -64.8241>, <-25.174, 186.9956, -65.3204> }
					triangle { <-24.5146, 187.4545, -64.5289>, <-23.2378, 188.2999, -64.4659>, <-25.174, 186.9956, -65.3204> }
					triangle { <-23.07545, 188.1906, -63.9748>, <-23.2378, 188.2999, -64.4659>, <-24.5146, 187.4545, -64.5289> }
					triangle { <-26.4857, 188.8956, -63.2717>, <-27.3767, 189.7151, -63.2194>, <-27.9556, 189.6956, -62.6695> }
					triangle { <-26.4857, 188.8956, -63.2717>, <-26.4383, 189.1843, -63.7345>, <-27.3767, 189.7151, -63.2194> }
					triangle { <-26.4857, 188.8956, -63.2717>, <-25.7885, 188.6432, -64.04925>, <-26.4383, 189.1843, -63.7345> }
					triangle { <-26.4857, 188.8956, -63.2717>, <-24.2066, 187.5018, -63.8202>, <-25.7885, 188.6432, -64.04925> }
					triangle { <-24.2066, 187.5018, -63.8202>, <-24.5146, 187.4545, -64.5289>, <-25.7885, 188.6432, -64.04925> }
					triangle { <-24.2066, 187.5018, -63.8202>, <-23.07545, 188.1906, -63.9748>, <-24.5146, 187.4545, -64.5289> }
					triangle { <-24.2066, 187.5018, -63.8202>, <-23.06491, 187.9831, -63.5255>, <-23.07545, 188.1906, -63.9748> }
					triangle { <-27.5861, 189.7854, -62.04178>, <-27.9556, 189.6956, -62.6695>, <-28.9279, 189.8017, -62.00278> }
					triangle { <-27.5861, 189.7854, -62.04178>, <-26.4857, 188.8956, -63.2717>, <-27.9556, 189.6956, -62.6695> }
					triangle { <-27.5861, 189.7854, -62.04178>, <-26.2439, 188.9582, -62.4553>, <-26.4857, 188.8956, -63.2717> }
					triangle { <-26.2439, 188.9582, -62.4553>, <-24.2066, 187.5018, -63.8202>, <-26.4857, 188.8956, -63.2717> }
					triangle { <-23.9686, 187.6398, -63.1671>, <-24.2066, 187.5018, -63.8202>, <-26.2439, 188.9582, -62.4553> }
					triangle { <-23.9686, 187.6398, -63.1671>, <-23.06491, 187.9831, -63.5255>, <-24.2066, 187.5018, -63.8202> }
					triangle { <-23.9686, 187.6398, -63.1671>, <-23.1188, 187.7897, -63.1178>, <-23.06491, 187.9831, -63.5255> }
					triangle { <-28.2783, 189.8766, -63.5699>, <-28.4219, 190.4196, -62.8696>, <-28.9279, 189.8017, -62.00278> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-29.9931, 189.5703, -61.3763>, <-30.1654, 190.505, -61.6871>, 0.55 }
			cylinder { <-30.1654, 190.505, -61.6871>, <-30.3074, 191.4391, -62.01484>, 0.55 }
			cylinder { <-30.3074, 191.4391, -62.01484>, <-30.4189, 192.3714, -62.3589>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-30.4189, 192.3714, -62.3589>, <-30.7706, 192.6577, -62.5695>, 0.55 }
				cylinder { <-30.7706, 192.6577, -62.5695>, <-31.2474, 192.6251, -62.7164>, 0.55 }
				cylinder { <-31.2474, 192.6251, -62.7164>, <-31.6178, 192.2895, -62.7283>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-31.6178, 192.2895, -62.7283>, <-31.9146, 191.4551, -61.2794>, <-31.9646, 191.2713, -62.2341> }
					triangle { <-32.6298, 191.154, -60.7216>, <-32.8471, 189.7302, -61.4967>, <-32.1186, 190.6348, -61.7768> }
					triangle { <-31.9146, 191.4551, -61.2794>, <-32.1186, 190.6348, -61.7768>, <-31.9646, 191.2713, -62.2341> }
					triangle { <-31.9146, 191.4551, -61.2794>, <-32.6298, 191.154, -60.7216>, <-32.1186, 190.6348, -61.7768> }
					triangle { <-32.6298, 191.154, -60.7216>, <-33.712, 190.4755, -60.5514>, <-32.8471, 189.7302, -61.4967> }
					triangle { <-33.712, 190.4755, -60.5514>, <-34.5973, 189.6436, -60.5019>, <-33.513, 189.1342, -61.3725> }
					triangle { <-33.712, 190.4755, -60.5514>, <-33.513, 189.1342, -61.3725>, <-32.8471, 189.7302, -61.4967> }
					triangle { <-34.5973, 189.6436, -60.5019>, <-35.4302, 188.622, -60.4949>, <-34.918, 188.0007, -61.2845> }
					triangle { <-34.5973, 189.6436, -60.5019>, <-34.918, 188.0007, -61.2845>, <-33.513, 189.1342, -61.3725> }
					triangle { <-35.4302, 188.622, -60.4949>, <-33.699, 186.6513, -60.8168>, <-34.12, 186.659, -61.1781> }
					triangle { <-35.4302, 188.622, -60.4949>, <-34.12, 186.659, -61.1781>, <-34.918, 188.0007, -61.2845> }
					triangle { <-34.918, 188.0007, -61.2845>, <-34.12, 186.659, -61.1781>, <-34.3273, 186.6835, -61.732> }
					triangle { <-31.9646, 191.2713, -62.2341>, <-32.1186, 190.6348, -61.7768>, <-33.03726, 189.8739, -61.9895> }
					triangle { <-32.1186, 190.6348, -61.7768>, <-32.8471, 189.7302, -61.4967>, <-33.03726, 189.8739, -61.9895> }
					triangle { <-32.8471, 189.7302, -61.4967>, <-33.513, 189.1342, -61.3725>, <-33.03726, 189.8739, -61.9895> }
					triangle { <-33.513, 189.1342, -61.3725>, <-34.7788, 187.7753, -62.01197>, <-33.03726, 189.8739, -61.9895> }
					triangle { <-33.513, 189.1342, -61.3725>, <-34.918, 188.0007, -61.2845>, <-34.7788, 187.7753, -62.01197> }
					triangle { <-34.918, 188.0007, -61.2845>, <-34.3273, 186.6835, -61.732>, <-34.7788, 187.7753, -62.01197> }
					triangle { <-34.3273, 186.6835, -61.732>, <-34.5131, 186.7458, -62.3324>, <-34.7788, 187.7753, -62.01197> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-31.9646, 191.2713, -62.2341>, <-31.8066, 190.9696, -62.8842> }
					triangle { <-31.9646, 191.2713, -62.2341>, <-33.03726, 189.8739, -61.9895>, <-31.8066, 190.9696, -62.8842> }
					triangle { <-33.03726, 189.8739, -61.9895>, <-32.8552, 189.7239, -62.8101>, <-31.8066, 190.9696, -62.8842> }
					triangle { <-33.03726, 189.8739, -61.9895>, <-34.7788, 187.7753, -62.01197>, <-32.8552, 189.7239, -62.8101> }
					triangle { <-32.8552, 189.7239, -62.8101>, <-34.7788, 187.7753, -62.01197>, <-34.5749, 187.612, -62.7463> }
					triangle { <-34.7788, 187.7753, -62.01197>, <-34.5131, 186.7458, -62.3324>, <-34.5749, 187.612, -62.7463> }
					triangle { <-34.5131, 186.7458, -62.3324>, <-34.5245, 186.7612, -62.8905>, <-34.5749, 187.612, -62.7463> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-31.2381, 191.5993, -61.8516>, <-31.9146, 191.4551, -61.2794> }
					triangle { <-32.2276, 191.4312, -63.2693>, <-32.6162, 191.8815, -64.03996>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-32.6229, 190.9413, -63.7609>, <-33.461, 190.1033, -63.9121>, <-33.5287, 191.7003, -64.2585> }
					triangle { <-32.2276, 191.4312, -63.2693>, <-32.6229, 190.9413, -63.7609>, <-32.6162, 191.8815, -64.03996> }
					triangle { <-32.6229, 190.9413, -63.7609>, <-33.5287, 191.7003, -64.2585>, <-32.6162, 191.8815, -64.03996> }
					triangle { <-33.461, 190.1033, -63.9121>, <-34.611, 191.0219, -64.08832>, <-33.5287, 191.7003, -64.2585> }
					triangle { <-34.1489, 189.5207, -63.8742>, <-35.4743, 190.1766, -63.9525>, <-34.611, 191.0219, -64.08832> }
					triangle { <-33.461, 190.1033, -63.9121>, <-34.1489, 189.5207, -63.8742>, <-34.611, 191.0219, -64.08832> }
					triangle { <-35.5099, 188.3605, -63.6136>, <-36.2853, 189.1417, -63.8593>, <-35.4743, 190.1766, -63.9525> }
					triangle { <-34.1489, 189.5207, -63.8742>, <-35.5099, 188.3605, -63.6136>, <-35.4743, 190.1766, -63.9525> }
					triangle { <-34.9631, 187.07, -64.2337>, <-34.857, 187.3607, -64.7321>, <-36.2853, 189.1417, -63.8593> }
					triangle { <-35.5099, 188.3605, -63.6136>, <-34.9631, 187.07, -64.2337>, <-36.2853, 189.1417, -63.8593> }
					triangle { <-34.7578, 186.8382, -63.8052>, <-34.9631, 187.07, -64.2337>, <-35.5099, 188.3605, -63.6136> }
					triangle { <-33.388, 190.0871, -63.3698>, <-32.6229, 190.9413, -63.7609>, <-32.2276, 191.4312, -63.2693> }
					triangle { <-33.388, 190.0871, -63.3698>, <-33.461, 190.1033, -63.9121>, <-32.6229, 190.9413, -63.7609> }
					triangle { <-33.388, 190.0871, -63.3698>, <-34.1489, 189.5207, -63.8742>, <-33.461, 190.1033, -63.9121> }
					triangle { <-33.388, 190.0871, -63.3698>, <-35.06388, 187.9485, -63.1334>, <-34.1489, 189.5207, -63.8742> }
					triangle { <-35.06388, 187.9485, -63.1334>, <-35.5099, 188.3605, -63.6136>, <-34.1489, 189.5207, -63.8742> }
					triangle { <-35.06388, 187.9485, -63.1334>, <-34.7578, 186.8382, -63.8052>, <-35.5099, 188.3605, -63.6136> }
					triangle { <-35.06388, 187.9485, -63.1334>, <-34.6373, 186.7649, -63.3308>, <-34.7578, 186.8382, -63.8052> }
					triangle { <-31.8066, 190.9696, -62.8842>, <-32.2276, 191.4312, -63.2693>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-31.8066, 190.9696, -62.8842>, <-33.388, 190.0871, -63.3698>, <-32.2276, 191.4312, -63.2693> }
					triangle { <-31.8066, 190.9696, -62.8842>, <-32.8552, 189.7239, -62.8101>, <-33.388, 190.0871, -63.3698> }
					triangle { <-32.8552, 189.7239, -62.8101>, <-35.06388, 187.9485, -63.1334>, <-33.388, 190.0871, -63.3698> }
					triangle { <-34.5749, 187.612, -62.7463>, <-35.06388, 187.9485, -63.1334>, <-32.8552, 189.7239, -62.8101> }
					triangle { <-34.5749, 187.612, -62.7463>, <-34.6373, 186.7649, -63.3308>, <-35.06388, 187.9485, -63.1334> }
					triangle { <-34.5749, 187.612, -62.7463>, <-34.5245, 186.7612, -62.8905>, <-34.6373, 186.7649, -63.3308> }
					triangle { <-32.6162, 191.8815, -64.03996>, <-31.7424, 191.9058, -63.8357>, <-31.6178, 192.2895, -62.7283> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.6178, 192.2895, -62.7283>, <-33.2019, 192.6883, -62.2641>, <-32.5937, 191.9354, -62.1594> }
					triangle { <-34.1144, 192.507, -62.4827>, <-34.248, 191.1873, -61.5259>, <-33.2817, 191.8489, -61.7632> }
					triangle { <-33.2019, 192.6883, -62.2641>, <-33.2817, 191.8489, -61.7632>, <-32.5937, 191.9354, -62.1594> }
					triangle { <-33.2019, 192.6883, -62.2641>, <-34.1144, 192.507, -62.4827>, <-33.2817, 191.8489, -61.7632> }
					triangle { <-34.1144, 192.507, -62.4827>, <-35.08683, 191.6773, -62.6454>, <-34.248, 191.1873, -61.5259> }
					triangle { <-35.08683, 191.6773, -62.6454>, <-35.9318, 190.8068, -62.5651>, <-34.9358, 190.6047, -61.488> }
					triangle { <-35.08683, 191.6773, -62.6454>, <-34.9358, 190.6047, -61.488>, <-34.248, 191.1873, -61.5259> }
					triangle { <-35.9318, 190.8068, -62.5651>, <-36.7977, 189.8476, -62.3055>, <-36.2054, 189.3185, -61.5049> }
					triangle { <-35.9318, 190.8068, -62.5651>, <-36.2054, 189.3185, -61.5049>, <-34.9358, 190.6047, -61.488> }
					triangle { <-36.7977, 189.8476, -62.3055>, <-36.49, 189.6859, -59.6856>, <-36.4355, 189.2074, -59.9612> }
					triangle { <-36.7977, 189.8476, -62.3055>, <-36.4355, 189.2074, -59.9612>, <-36.2054, 189.3185, -61.5049> }
					triangle { <-36.2054, 189.3185, -61.5049>, <-36.4355, 189.2074, -59.9612>, <-36.1199, 188.731, -60.115> }
					triangle { <-32.5937, 191.9354, -62.1594>, <-33.2817, 191.8489, -61.7632>, <-33.9187, 190.8182, -61.7605> }
					triangle { <-33.2817, 191.8489, -61.7632>, <-34.248, 191.1873, -61.5259>, <-33.9187, 190.8182, -61.7605> }
					triangle { <-34.248, 191.1873, -61.5259>, <-34.9358, 190.6047, -61.488>, <-33.9187, 190.8182, -61.7605> }
					triangle { <-34.9358, 190.6047, -61.488>, <-35.6861, 188.8057, -61.2466>, <-33.9187, 190.8182, -61.7605> }
					triangle { <-34.9358, 190.6047, -61.488>, <-36.2054, 189.3185, -61.5049>, <-35.6861, 188.8057, -61.2466> }
					triangle { <-36.2054, 189.3185, -61.5049>, <-36.1199, 188.731, -60.115>, <-35.6861, 188.8057, -61.2466> }
					triangle { <-36.1199, 188.731, -60.115>, <-35.7426, 188.2537, -60.2846>, <-35.6861, 188.8057, -61.2466> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-32.5937, 191.9354, -62.1594>, <-32.1543, 191.4485, -61.8299> }
					triangle { <-32.5937, 191.9354, -62.1594>, <-33.9187, 190.8182, -61.7605>, <-32.1543, 191.4485, -61.8299> }
					triangle { <-33.9187, 190.8182, -61.7605>, <-33.2761, 190.3037, -61.5338>, <-32.1543, 191.4485, -61.8299> }
					triangle { <-33.9187, 190.8182, -61.7605>, <-35.6861, 188.8057, -61.2466>, <-33.2761, 190.3037, -61.5338> }
					triangle { <-33.2761, 190.3037, -61.5338>, <-35.6861, 188.8057, -61.2466>, <-35.102, 188.3549, -60.9952> }
					triangle { <-35.6861, 188.8057, -61.2466>, <-35.7426, 188.2537, -60.2846>, <-35.102, 188.3549, -60.9952> }
					triangle { <-35.7426, 188.2537, -60.2846>, <-35.3261, 187.8823, -60.307>, <-35.102, 188.3549, -60.9952> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-32.3646, 192.763, -61.9489>, <-33.2019, 192.6883, -62.2641> }
					triangle { <-31.8913, 191.1704, -62.4561>, <-31.329, 190.6484, -63.05526>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-31.9356, 190.3827, -62.3318>, <-32.6092, 189.4025, -62.2181>, <-31.7148, 189.8935, -63.4963> }
					triangle { <-31.8913, 191.1704, -62.4561>, <-31.9356, 190.3827, -62.3318>, <-31.329, 190.6484, -63.05526> }
					triangle { <-31.9356, 190.3827, -62.3318>, <-31.7148, 189.8935, -63.4963>, <-31.329, 190.6484, -63.05526> }
					triangle { <-32.6092, 189.4025, -62.2181>, <-32.6872, 189.0638, -63.659>, <-31.7148, 189.8935, -63.4963> }
					triangle { <-33.2385, 188.7561, -62.2049>, <-33.5907, 188.257, -63.554>, <-32.6872, 189.0638, -63.659> }
					triangle { <-32.6092, 189.4025, -62.2181>, <-33.2385, 188.7561, -62.2049>, <-32.6872, 189.0638, -63.659> }
					triangle { <-34.6252, 187.5974, -62.1724>, <-34.5152, 187.3615, -63.2696>, <-33.5907, 188.257, -63.554> }
					triangle { <-33.2385, 188.7561, -62.2049>, <-34.6252, 187.5974, -62.1724>, <-33.5907, 188.257, -63.554> }
					triangle { <-34.4226, 186.8823, -60.832>, <-33.874, 186.7492, -60.992>, <-34.5152, 187.3615, -63.2696> }
					triangle { <-34.6252, 187.5974, -62.1724>, <-34.4226, 186.8823, -60.832>, <-34.5152, 187.3615, -63.2696> }
					triangle { <-34.733, 187.1752, -60.52>, <-34.4226, 186.8823, -60.832>, <-34.6252, 187.5974, -62.1724> }
					triangle { <-32.9823, 189.7983, -62.156>, <-31.9356, 190.3827, -62.3318>, <-31.8913, 191.1704, -62.4561> }
					triangle { <-32.9823, 189.7983, -62.156>, <-32.6092, 189.4025, -62.2181>, <-31.9356, 190.3827, -62.3318> }
					triangle { <-32.9823, 189.7983, -62.156>, <-33.2385, 188.7561, -62.2049>, <-32.6092, 189.4025, -62.2181> }
					triangle { <-32.9823, 189.7983, -62.156>, <-34.9252, 187.977, -61.568>, <-33.2385, 188.7561, -62.2049> }
					triangle { <-34.9252, 187.977, -61.568>, <-34.6252, 187.5974, -62.1724>, <-33.2385, 188.7561, -62.2049> }
					triangle { <-34.9252, 187.977, -61.568>, <-34.733, 187.1752, -60.52>, <-34.6252, 187.5974, -62.1724> }
					triangle { <-34.9252, 187.977, -61.568>, <-35.05495, 187.5258, -60.3841>, <-34.733, 187.1752, -60.52> }
					triangle { <-32.1543, 191.4485, -61.8299>, <-31.8913, 191.1704, -62.4561>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-32.1543, 191.4485, -61.8299>, <-32.9823, 189.7983, -62.156>, <-31.8913, 191.1704, -62.4561> }
					triangle { <-32.1543, 191.4485, -61.8299>, <-33.2761, 190.3037, -61.5338>, <-32.9823, 189.7983, -62.156> }
					triangle { <-33.2761, 190.3037, -61.5338>, <-34.9252, 187.977, -61.568>, <-32.9823, 189.7983, -62.156> }
					triangle { <-35.102, 188.3549, -60.9952>, <-34.9252, 187.977, -61.568>, <-33.2761, 190.3037, -61.5338> }
					triangle { <-35.102, 188.3549, -60.9952>, <-35.05495, 187.5258, -60.3841>, <-34.9252, 187.977, -61.568> }
					triangle { <-35.102, 188.3549, -60.9952>, <-35.3261, 187.8823, -60.307>, <-35.05495, 187.5258, -60.3841> }
					triangle { <-31.329, 190.6484, -63.05526>, <-31.01852, 191.2968, -62.5176>, <-31.6178, 192.2895, -62.7283> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.6178, 192.2895, -62.7283>, <-32.6162, 191.8815, -64.03996>, <-32.6959, 191.9411, -63.07155> }
					triangle { <-33.00204, 191.1266, -64.481>, <-34.3389, 191.0595, -63.5413>, <-33.3837, 191.77, -63.4396> }
					triangle { <-32.6162, 191.8815, -64.03996>, <-33.3837, 191.77, -63.4396>, <-32.6959, 191.9411, -63.07155> }
					triangle { <-32.6162, 191.8815, -64.03996>, <-33.00204, 191.1266, -64.481>, <-33.3837, 191.77, -63.4396> }
					triangle { <-33.00204, 191.1266, -64.481>, <-33.7331, 190.0657, -64.4591>, <-34.3389, 191.0595, -63.5413> }
					triangle { <-33.7331, 190.0657, -64.4591>, <-34.5964, 189.2204, -64.3233>, <-34.9682, 190.4131, -63.5281> }
					triangle { <-33.7331, 190.0657, -64.4591>, <-34.9682, 190.4131, -63.5281>, <-34.3389, 191.0595, -63.5413> }
					triangle { <-34.5964, 189.2204, -64.3233>, <-35.6415, 188.4405, -64.1312>, <-36.1537, 189.0617, -63.3417> }
					triangle { <-34.5964, 189.2204, -64.3233>, <-36.1537, 189.0617, -63.3417>, <-34.9682, 190.4131, -63.5281> }
					triangle { <-35.6415, 188.4405, -64.1312>, <-37.5022, 190.287, -63.7956>, <-37.4698, 189.9065, -63.3931> }
					triangle { <-35.6415, 188.4405, -64.1312>, <-37.4698, 189.9065, -63.3931>, <-36.1537, 189.0617, -63.3417> }
					triangle { <-36.1537, 189.0617, -63.3417>, <-37.4698, 189.9065, -63.3931>, <-37.392, 189.7577, -62.8256> }
					triangle { <-32.6959, 191.9411, -63.07155>, <-33.3837, 191.77, -63.4396>, <-34.1489, 190.9158, -63.04845> }
					triangle { <-33.3837, 191.77, -63.4396>, <-34.3389, 191.0595, -63.5413>, <-34.1489, 190.9158, -63.04845> }
					triangle { <-34.3389, 191.0595, -63.5413>, <-34.9682, 190.4131, -63.5281>, <-34.1489, 190.9158, -63.04845> }
					triangle { <-34.9682, 190.4131, -63.5281>, <-36.2929, 189.2872, -62.6142>, <-34.1489, 190.9158, -63.04845> }
					triangle { <-34.9682, 190.4131, -63.5281>, <-36.1537, 189.0617, -63.3417>, <-36.2929, 189.2872, -62.6142> }
					triangle { <-36.1537, 189.0617, -63.3417>, <-37.392, 189.7577, -62.8256>, <-36.2929, 189.2872, -62.6142> }
					triangle { <-37.392, 189.7577, -62.8256>, <-37.2709, 189.6334, -62.2183>, <-36.2929, 189.2872, -62.6142> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-32.6959, 191.9411, -63.07155>, <-32.9186, 192.1807, -62.4145> }
					triangle { <-32.6959, 191.9411, -63.07155>, <-34.1489, 190.9158, -63.04845>, <-32.9186, 192.1807, -62.4145> }
					triangle { <-34.1489, 190.9158, -63.04845>, <-34.2013, 191.19, -62.2415>, <-32.9186, 192.1807, -62.4145> }
					triangle { <-34.1489, 190.9158, -63.04845>, <-36.2929, 189.2872, -62.6142>, <-34.2013, 191.19, -62.2415> }
					triangle { <-34.2013, 191.19, -62.2415>, <-36.2929, 189.2872, -62.6142>, <-36.3673, 189.5748, -61.8936> }
					triangle { <-36.2929, 189.2872, -62.6142>, <-37.2709, 189.6334, -62.2183>, <-36.3673, 189.5748, -61.8936> }
					triangle { <-37.2709, 189.6334, -62.2183>, <-37.1948, 189.6801, -61.667>, <-36.3673, 189.5748, -61.8936> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-32.3862, 192.607, -63.5638>, <-32.6162, 191.8815, -64.03996> }
					triangle { <-32.4328, 191.7812, -62.03637>, <-31.9146, 191.4551, -61.2794>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-32.8794, 191.4635, -61.4554>, <-33.725, 190.6864, -61.1258>, <-32.1031, 190.5803, -60.9441> }
					triangle { <-32.4328, 191.7812, -62.03637>, <-32.8794, 191.4635, -61.4554>, <-31.9146, 191.4551, -61.2794> }
					triangle { <-32.8794, 191.4635, -61.4554>, <-32.1031, 190.5803, -60.9441>, <-31.9146, 191.4551, -61.2794> }
					triangle { <-33.725, 190.6864, -61.1258>, <-32.8341, 189.5193, -60.9222>, <-32.1031, 190.5803, -60.9441> }
					triangle { <-34.3324, 190.0266, -61.02648>, <-33.7194, 188.6874, -60.8727>, <-32.8341, 189.5193, -60.9222> }
					triangle { <-33.725, 190.6864, -61.1258>, <-34.3324, 190.0266, -61.02648>, <-32.8341, 189.5193, -60.9222> }
					triangle { <-35.5618, 188.702, -61.01257>, <-34.7864, 187.9208, -60.7669>, <-33.7194, 188.6874, -60.8727> }
					triangle { <-34.3324, 190.0266, -61.02648>, <-35.5618, 188.702, -61.01257>, <-33.7194, 188.6874, -60.8727> }
					triangle { <-36.7562, 189.3713, -60.3239>, <-36.409, 189.5154, -59.8734>, <-34.7864, 187.9208, -60.7669> }
					triangle { <-35.5618, 188.702, -61.01257>, <-36.7562, 189.3713, -60.3239>, <-34.7864, 187.9208, -60.7669> }
					triangle { <-37.02629, 189.541, -60.7454>, <-36.7562, 189.3713, -60.3239>, <-35.5618, 188.702, -61.01257> }
					triangle { <-33.7981, 190.7026, -61.6682>, <-32.8794, 191.4635, -61.4554>, <-32.4328, 191.7812, -62.03637> }
					triangle { <-33.7981, 190.7026, -61.6682>, <-33.725, 190.6864, -61.1258>, <-32.8794, 191.4635, -61.4554> }
					triangle { <-33.7981, 190.7026, -61.6682>, <-34.3324, 190.0266, -61.02648>, <-33.725, 190.6864, -61.1258> }
					triangle { <-33.7981, 190.7026, -61.6682>, <-36.00792, 189.114, -61.4928>, <-34.3324, 190.0266, -61.02648> }
					triangle { <-36.00792, 189.114, -61.4928>, <-35.5618, 188.702, -61.01257>, <-34.3324, 190.0266, -61.02648> }
					triangle { <-36.00792, 189.114, -61.4928>, <-37.02629, 189.541, -60.7454>, <-35.5618, 188.702, -61.01257> }
					triangle { <-36.00792, 189.114, -61.4928>, <-37.1468, 189.6143, -61.2199>, <-37.02629, 189.541, -60.7454> }
					triangle { <-32.9186, 192.1807, -62.4145>, <-32.4328, 191.7812, -62.03637>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-32.9186, 192.1807, -62.4145>, <-33.7981, 190.7026, -61.6682>, <-32.4328, 191.7812, -62.03637> }
					triangle { <-32.9186, 192.1807, -62.4145>, <-34.2013, 191.19, -62.2415>, <-33.7981, 190.7026, -61.6682> }
					triangle { <-34.2013, 191.19, -62.2415>, <-36.00792, 189.114, -61.4928>, <-33.7981, 190.7026, -61.6682> }
					triangle { <-36.3673, 189.5748, -61.8936>, <-36.00792, 189.114, -61.4928>, <-34.2013, 191.19, -62.2415> }
					triangle { <-36.3673, 189.5748, -61.8936>, <-37.1468, 189.6143, -61.2199>, <-36.00792, 189.114, -61.4928> }
					triangle { <-36.3673, 189.5748, -61.8936>, <-37.1948, 189.6801, -61.667>, <-37.1468, 189.6143, -61.2199> }
					triangle { <-31.9146, 191.4551, -61.2794>, <-31.8819, 192.3005, -61.5797>, <-31.6178, 192.2895, -62.7283> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.6178, 192.2895, -62.7283>, <-31.329, 190.6484, -63.05526>, <-32.06679, 191.277, -63.1462> }
					triangle { <-31.5175, 189.7736, -62.7199>, <-32.9381, 189.6024, -63.5121>, <-32.2206, 190.556, -63.4532> }
					triangle { <-31.329, 190.6484, -63.05526>, <-32.2206, 190.556, -63.4532>, <-32.06679, 191.277, -63.1462> }
					triangle { <-31.329, 190.6484, -63.05526>, <-31.5175, 189.7736, -62.7199>, <-32.2206, 190.556, -63.4532> }
					triangle { <-31.5175, 189.7736, -62.7199>, <-32.3583, 188.8639, -62.3651>, <-32.9381, 189.6024, -63.5121> }
					triangle { <-32.3583, 188.8639, -62.3651>, <-33.2619, 188.0571, -62.26>, <-33.5455, 188.9426, -63.4127> }
					triangle { <-32.3583, 188.8639, -62.3651>, <-33.5455, 188.9426, -63.4127>, <-32.9381, 189.6024, -63.5121> }
					triangle { <-33.2619, 188.0571, -62.26>, <-34.274, 187.2149, -62.3207>, <-34.8663, 187.744, -63.1213> }
					triangle { <-33.2619, 188.0571, -62.26>, <-34.8663, 187.744, -63.1213>, <-33.5455, 188.9426, -63.4127> }
					triangle { <-34.274, 187.2149, -62.3207>, <-34.7112, 187.2524, -64.9268>, <-35.1543, 187.3581, -64.61> }
					triangle { <-34.274, 187.2149, -62.3207>, <-35.1543, 187.3581, -64.61>, <-34.8663, 187.744, -63.1213> }
					triangle { <-34.8663, 187.744, -63.1213>, <-35.1543, 187.3581, -64.61>, <-35.5995, 187.7103, -64.4425> }
					triangle { <-32.06679, 191.277, -63.1462>, <-32.2206, 190.556, -63.4532>, <-33.2673, 189.9715, -63.2775> }
					triangle { <-32.2206, 190.556, -63.4532>, <-32.9381, 189.6024, -63.5121>, <-33.2673, 189.9715, -63.2775> }
					triangle { <-32.9381, 189.6024, -63.5121>, <-33.5455, 188.9426, -63.4127>, <-33.2673, 189.9715, -63.2775> }
					triangle { <-33.5455, 188.9426, -63.4127>, <-35.3856, 188.2568, -63.3796>, <-33.2673, 189.9715, -63.2775> }
					triangle { <-33.5455, 188.9426, -63.4127>, <-34.8663, 187.744, -63.1213>, <-35.3856, 188.2568, -63.3796> }
					triangle { <-34.8663, 187.744, -63.1213>, <-35.5995, 187.7103, -64.4425>, <-35.3856, 188.2568, -63.3796> }
					triangle { <-35.5995, 187.7103, -64.4425>, <-36.04157, 188.1255, -64.266>, <-35.3856, 188.2568, -63.3796> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-32.06679, 191.277, -63.1462>, <-32.5709, 191.7018, -63.4689> }
					triangle { <-32.06679, 191.277, -63.1462>, <-33.2673, 189.9715, -63.2775>, <-32.5709, 191.7018, -63.4689> }
					triangle { <-33.2673, 189.9715, -63.2775>, <-33.7804, 190.6102, -63.5179>, <-32.5709, 191.7018, -63.4689> }
					triangle { <-33.2673, 189.9715, -63.2775>, <-35.3856, 188.2568, -63.3796>, <-33.7804, 190.6102, -63.5179> }
					triangle { <-33.7804, 190.6102, -63.5179>, <-35.3856, 188.2568, -63.3796>, <-35.8402, 188.8318, -63.6447> }
					triangle { <-35.3856, 188.2568, -63.3796>, <-36.04157, 188.1255, -64.266>, <-35.8402, 188.8318, -63.6447> }
					triangle { <-36.04157, 188.1255, -64.266>, <-36.3932, 188.559, -64.2505>, <-35.8402, 188.8318, -63.6447> }
					triangle { <-31.6178, 192.2895, -62.7283>, <-31.2597, 191.4434, -63.4665>, <-31.329, 190.6484, -63.05526> }
					triangle { <-32.7691, 192.042, -62.8495>, <-33.2019, 192.6883, -62.2641>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-33.5667, 192.0221, -62.8846>, <-34.5768, 191.3872, -62.8199>, <-33.917, 192.3871, -61.7063> }
					triangle { <-32.7691, 192.042, -62.8495>, <-33.5667, 192.0221, -62.8846>, <-33.2019, 192.6883, -62.2641> }
					triangle { <-33.5667, 192.0221, -62.8846>, <-33.917, 192.3871, -61.7063>, <-33.2019, 192.6883, -62.2641> }
					triangle { <-34.5768, 191.3872, -62.8199>, <-34.7579, 191.4774, -61.3515>, <-33.917, 192.3871, -61.7063> }
					triangle { <-35.2428, 190.7912, -62.6957>, <-35.6029, 190.6069, -61.2712>, <-34.7579, 191.4774, -61.3515> }
					triangle { <-34.5768, 191.3872, -62.8199>, <-35.2428, 190.7912, -62.6957>, <-34.7579, 191.4774, -61.3515> }
					triangle { <-36.4466, 189.4651, -62.4538>, <-36.5565, 189.701, -61.3565>, <-35.6029, 190.6069, -61.2712> }
					triangle { <-35.2428, 190.7912, -62.6957>, <-36.4466, 189.4651, -62.4538>, <-35.6029, 190.6069, -61.2712> }
					triangle { <-37.2967, 189.5589, -63.7256>, <-37.392, 190.127, -63.6136>, <-36.5565, 189.701, -61.3565> }
					triangle { <-36.4466, 189.4651, -62.4538>, <-37.2967, 189.5589, -63.7256>, <-36.5565, 189.701, -61.3565> }
					triangle { <-37.05111, 189.2039, -64.03067>, <-37.2967, 189.5589, -63.7256>, <-36.4466, 189.4651, -62.4538> }
					triangle { <-34.2038, 190.9914, -62.8819>, <-33.5667, 192.0221, -62.8846>, <-32.7691, 192.042, -62.8495> }
					triangle { <-34.2038, 190.9914, -62.8819>, <-34.5768, 191.3872, -62.8199>, <-33.5667, 192.0221, -62.8846> }
					triangle { <-34.2038, 190.9914, -62.8819>, <-35.2428, 190.7912, -62.6957>, <-34.5768, 191.3872, -62.8199> }
					triangle { <-34.2038, 190.9914, -62.8819>, <-36.1465, 189.0855, -63.05821>, <-35.2428, 190.7912, -62.6957> }
					triangle { <-36.1465, 189.0855, -63.05821>, <-36.4466, 189.4651, -62.4538>, <-35.2428, 190.7912, -62.6957> }
					triangle { <-36.1465, 189.0855, -63.05821>, <-37.05111, 189.2039, -64.03067>, <-36.4466, 189.4651, -62.4538> }
					triangle { <-36.1465, 189.0855, -63.05821>, <-36.7292, 188.8533, -64.1666>, <-37.05111, 189.2039, -64.03067> }
					triangle { <-32.5709, 191.7018, -63.4689>, <-32.7691, 192.042, -62.8495>, <-31.6178, 192.2895, -62.7283> }
					triangle { <-32.5709, 191.7018, -63.4689>, <-34.2038, 190.9914, -62.8819>, <-32.7691, 192.042, -62.8495> }
					triangle { <-32.5709, 191.7018, -63.4689>, <-33.7804, 190.6102, -63.5179>, <-34.2038, 190.9914, -62.8819> }
					triangle { <-33.7804, 190.6102, -63.5179>, <-36.1465, 189.0855, -63.05821>, <-34.2038, 190.9914, -62.8819> }
					triangle { <-35.8402, 188.8318, -63.6447>, <-36.1465, 189.0855, -63.05821>, <-33.7804, 190.6102, -63.5179> }
					triangle { <-35.8402, 188.8318, -63.6447>, <-36.7292, 188.8533, -64.1666>, <-36.1465, 189.0855, -63.05821> }
					triangle { <-35.8402, 188.8318, -63.6447>, <-36.3932, 188.559, -64.2505>, <-36.7292, 188.8533, -64.1666> }
					triangle { <-33.2019, 192.6883, -62.2641>, <-32.6058, 192.9095, -62.8979>, <-31.6178, 192.2895, -62.7283> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-30.4189, 192.3714, -62.3589>, <-30.5637, 193.2965, -62.7097>, 0.55 }
			cylinder { <-30.5637, 193.2965, -62.7097>, <-30.7415, 194.2135, -63.06699>, 0.55 }
			cylinder { <-30.7415, 194.2135, -63.06699>, <-30.9523, 195.121, -63.4301>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-30.9523, 195.121, -63.4301>, <-30.8726, 195.6017, -63.3177>, 0.55 }
				cylinder { <-30.8726, 195.6017, -63.3177>, <-30.6466, 195.8758, -62.9659>, 0.55 }
				cylinder { <-30.6466, 195.8758, -62.9659>, <-30.384, 195.8103, -62.5455>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-30.384, 195.8103, -62.5455>, <-29.09943, 194.7032, -62.6338>, <-29.744, 194.9995, -61.9672> }
					triangle { <-28.1894, 194.589, -62.3653>, <-28.5351, 193.9537, -60.8984>, <-29.2806, 194.398, -61.7196> }
					triangle { <-29.09943, 194.7032, -62.6338>, <-29.2806, 194.398, -61.7196>, <-29.744, 194.9995, -61.9672> }
					triangle { <-29.09943, 194.7032, -62.6338>, <-28.1894, 194.589, -62.3653>, <-29.2806, 194.398, -61.7196> }
					triangle { <-28.1894, 194.589, -62.3653>, <-27.2877, 194.5377, -61.4462>, <-28.5351, 193.9537, -60.8984> }
					triangle { <-27.2877, 194.5377, -61.4462>, <-26.6027, 194.3249, -60.4645>, <-27.9586, 193.7789, -60.2267> }
					triangle { <-27.2877, 194.5377, -61.4462>, <-27.9586, 193.7789, -60.2267>, <-28.5351, 193.9537, -60.8984> }
					triangle { <-26.6027, 194.3249, -60.4645>, <-25.9764, 193.9613, -59.3631>, <-26.8728, 193.5784, -58.7959> }
					triangle { <-26.6027, 194.3249, -60.4645>, <-26.8728, 193.5784, -58.7959>, <-27.9586, 193.7789, -60.2267> }
					triangle { <-25.9764, 193.9613, -59.3631>, <-27.3223, 191.7554, -58.8093>, <-27.291, 192.1245, -58.3963> }
					triangle { <-25.9764, 193.9613, -59.3631>, <-27.291, 192.1245, -58.3963>, <-26.8728, 193.5784, -58.7959> }
					triangle { <-26.8728, 193.5784, -58.7959>, <-27.291, 192.1245, -58.3963>, <-27.5471, 192.4836, -58.00168> }
					triangle { <-29.744, 194.9995, -61.9672>, <-29.2806, 194.398, -61.7196>, <-28.7644, 194.3681, -60.6238> }
					triangle { <-29.2806, 194.398, -61.7196>, <-28.5351, 193.9537, -60.8984>, <-28.7644, 194.3681, -60.6238> }
					triangle { <-28.5351, 193.9537, -60.8984>, <-27.9586, 193.7789, -60.2267>, <-28.7644, 194.3681, -60.6238> }
					triangle { <-27.9586, 193.7789, -60.2267>, <-27.483, 193.6521, -58.3253>, <-28.7644, 194.3681, -60.6238> }
					triangle { <-27.9586, 193.7789, -60.2267>, <-26.8728, 193.5784, -58.7959>, <-27.483, 193.6521, -58.3253> }
					triangle { <-26.8728, 193.5784, -58.7959>, <-27.5471, 192.4836, -58.00168>, <-27.483, 193.6521, -58.3253> }
					triangle { <-27.5471, 192.4836, -58.00168>, <-27.8532, 192.8806, -57.6175>, <-27.483, 193.6521, -58.3253> }
					triangle { <-30.384, 195.8103, -62.5455>, <-29.744, 194.9995, -61.9672>, <-30.3084, 194.973, -61.4988> }
					triangle { <-29.744, 194.9995, -61.9672>, <-28.7644, 194.3681, -60.6238>, <-30.3084, 194.973, -61.4988> }
					triangle { <-28.7644, 194.3681, -60.6238>, <-29.4746, 194.5178, -60.1742>, <-30.3084, 194.973, -61.4988> }
					triangle { <-28.7644, 194.3681, -60.6238>, <-27.483, 193.6521, -58.3253>, <-29.4746, 194.5178, -60.1742> }
					triangle { <-29.4746, 194.5178, -60.1742>, <-27.483, 193.6521, -58.3253>, <-28.1458, 193.7437, -57.9255> }
					triangle { <-27.483, 193.6521, -58.3253>, <-27.8532, 192.8806, -57.6175>, <-28.1458, 193.7437, -57.9255> }
					triangle { <-27.8532, 192.8806, -57.6175>, <-28.2477, 193.1379, -57.3174>, <-28.1458, 193.7437, -57.9255> }
					triangle { <-30.384, 195.8103, -62.5455>, <-29.9862, 194.7241, -62.7717>, <-29.09943, 194.7032, -62.6338> }
					triangle { <-30.3138, 195.6954, -61.3694>, <-30.6187, 196.5591, -61.03963>, <-30.384, 195.8103, -62.5455> }
					triangle { <-30.3726, 195.7319, -60.5737>, <-29.8645, 195.5776, -59.5034>, <-30.136, 196.9669, -60.3227> }
					triangle { <-30.3138, 195.6954, -61.3694>, <-30.3726, 195.7319, -60.5737>, <-30.6187, 196.5591, -61.03963> }
					triangle { <-30.3726, 195.7319, -60.5737>, <-30.136, 196.9669, -60.3227>, <-30.6187, 196.5591, -61.03963> }
					triangle { <-29.8645, 195.5776, -59.5034>, <-29.2343, 196.9155, -59.4035>, <-30.136, 196.9669, -60.3227> }
					triangle { <-29.3355, 195.4608, -58.7819>, <-28.5018, 196.6448, -58.4716>, <-29.2343, 196.9155, -59.4035> }
					triangle { <-29.8645, 195.5776, -59.5034>, <-29.3355, 195.4608, -58.7819>, <-29.2343, 196.9155, -59.4035> }
					triangle { <-28.1547, 195.1443, -57.4508>, <-27.8281, 196.2232, -57.4201>, <-28.5018, 196.6448, -58.4716> }
					triangle { <-29.3355, 195.4608, -58.7819>, <-28.1547, 195.1443, -57.4508>, <-28.5018, 196.6448, -58.4716> }
					triangle { <-28.924, 194.1655, -56.5568>, <-29.3689, 194.5472, -56.5309>, <-27.8281, 196.2232, -57.4201> }
					triangle { <-28.1547, 195.1443, -57.4508>, <-28.924, 194.1655, -56.5568>, <-27.8281, 196.2232, -57.4201> }
					triangle { <-28.7478, 193.7047, -56.7467>, <-28.924, 194.1655, -56.5568>, <-28.1547, 195.1443, -57.4508> }
					triangle { <-29.524, 195.2961, -59.8267>, <-30.3726, 195.7319, -60.5737>, <-30.3138, 195.6954, -61.3694> }
					triangle { <-29.524, 195.2961, -59.8267>, <-29.8645, 195.5776, -59.5034>, <-30.3726, 195.7319, -60.5737> }
					triangle { <-29.524, 195.2961, -59.8267>, <-29.3355, 195.4608, -58.7819>, <-29.8645, 195.5776, -59.5034> }
					triangle { <-29.524, 195.2961, -59.8267>, <-28.1003, 194.4061, -57.6776>, <-29.3355, 195.4608, -58.7819> }
					triangle { <-28.1003, 194.4061, -57.6776>, <-28.1547, 195.1443, -57.4508>, <-29.3355, 195.4608, -58.7819> }
					triangle { <-28.1003, 194.4061, -57.6776>, <-28.7478, 193.7047, -56.7467>, <-28.1547, 195.1443, -57.4508> }
					triangle { <-28.1003, 194.4061, -57.6776>, <-28.4867, 193.3857, -57.02071>, <-28.7478, 193.7047, -56.7467> }
					triangle { <-30.3084, 194.973, -61.4988>, <-30.3138, 195.6954, -61.3694>, <-30.384, 195.8103, -62.5455> }
					triangle { <-30.3084, 194.973, -61.4988>, <-29.524, 195.2961, -59.8267>, <-30.3138, 195.6954, -61.3694> }
					triangle { <-30.3084, 194.973, -61.4988>, <-29.4746, 194.5178, -60.1742>, <-29.524, 195.2961, -59.8267> }
					triangle { <-29.4746, 194.5178, -60.1742>, <-28.1003, 194.4061, -57.6776>, <-29.524, 195.2961, -59.8267> }
					triangle { <-28.1458, 193.7437, -57.9255>, <-28.1003, 194.4061, -57.6776>, <-29.4746, 194.5178, -60.1742> }
					triangle { <-28.1458, 193.7437, -57.9255>, <-28.4867, 193.3857, -57.02071>, <-28.1003, 194.4061, -57.6776> }
					triangle { <-28.1458, 193.7437, -57.9255>, <-28.2477, 193.1379, -57.3174>, <-28.4867, 193.3857, -57.02071> }
					triangle { <-30.6187, 196.5591, -61.03963>, <-31.0783, 196.058, -61.6258>, <-30.384, 195.8103, -62.5455> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-30.384, 195.8103, -62.5455>, <-28.9697, 196.6944, -62.2268>, <-29.2831, 195.78, -62.1114> }
					triangle { <-28.4869, 197.1022, -61.5099>, <-27.6486, 195.7594, -61.0988>, <-28.5175, 195.884, -61.9094> }
					triangle { <-28.9697, 196.6944, -62.2268>, <-28.5175, 195.884, -61.9094>, <-29.2831, 195.78, -62.1114> }
					triangle { <-28.9697, 196.6944, -62.2268>, <-28.4869, 197.1022, -61.5099>, <-28.5175, 195.884, -61.9094> }
					triangle { <-28.4869, 197.1022, -61.5099>, <-27.8944, 197.0254, -60.3682>, <-27.6486, 195.7594, -61.0988> }
					triangle { <-27.8944, 197.0254, -60.3682>, <-27.2135, 196.7504, -59.3992>, <-27.1195, 195.6425, -60.3773> }
					triangle { <-27.8944, 197.0254, -60.3682>, <-27.1195, 195.6425, -60.3773>, <-27.6486, 195.7594, -61.0988> }
					triangle { <-27.2135, 196.7504, -59.3992>, <-26.3852, 196.3416, -58.4589>, <-26.1964, 195.3049, -58.8606> }
					triangle { <-27.2135, 196.7504, -59.3992>, <-26.1964, 195.3049, -58.8606>, <-27.1195, 195.6425, -60.3773> }
					triangle { <-26.3852, 196.3416, -58.4589>, <-24.7057, 194.9408, -59.9425>, <-24.9211, 194.6708, -59.5084> }
					triangle { <-26.3852, 196.3416, -58.4589>, <-24.9211, 194.6708, -59.5084>, <-26.1964, 195.3049, -58.8606> }
					triangle { <-26.1964, 195.3049, -58.8606>, <-24.9211, 194.6708, -59.5084>, <-25.2299, 194.2209, -59.279> }
					triangle { <-29.2831, 195.78, -62.1114>, <-28.5175, 195.884, -61.9094>, <-28.02961, 195.4187, -60.9026> }
					triangle { <-28.5175, 195.884, -61.9094>, <-27.6486, 195.7594, -61.0988>, <-28.02961, 195.4187, -60.9026> }
					triangle { <-27.6486, 195.7594, -61.0988>, <-27.1195, 195.6425, -60.3773>, <-28.02961, 195.4187, -60.9026> }
					triangle { <-27.1195, 195.6425, -60.3773>, <-26.3481, 194.5497, -58.9391>, <-28.02961, 195.4187, -60.9026> }
					triangle { <-27.1195, 195.6425, -60.3773>, <-26.1964, 195.3049, -58.8606>, <-26.3481, 194.5497, -58.9391> }
					triangle { <-26.1964, 195.3049, -58.8606>, <-25.2299, 194.2209, -59.279>, <-26.3481, 194.5497, -58.9391> }
					triangle { <-25.2299, 194.2209, -59.279>, <-25.5927, 193.7468, -59.07294>, <-26.3481, 194.5497, -58.9391> }
					triangle { <-30.384, 195.8103, -62.5455>, <-29.2831, 195.78, -62.1114>, <-29.3293, 195.0533, -62.2037> }
					triangle { <-29.2831, 195.78, -62.1114>, <-28.02961, 195.4187, -60.9026>, <-29.3293, 195.0533, -62.2037> }
					triangle { <-28.02961, 195.4187, -60.9026>, <-28.2894, 194.615, -61.02761>, <-29.3293, 195.0533, -62.2037> }
					triangle { <-28.02961, 195.4187, -60.9026>, <-26.3481, 194.5497, -58.9391>, <-28.2894, 194.615, -61.02761> }
					triangle { <-28.2894, 194.615, -61.02761>, <-26.3481, 194.5497, -58.9391>, <-26.5524, 193.8125, -59.08842> }
					triangle { <-26.3481, 194.5497, -58.9391>, <-25.5927, 193.7468, -59.07294>, <-26.5524, 193.8125, -59.08842> }
					triangle { <-25.5927, 193.7468, -59.07294>, <-25.8813, 193.2701, -59.03682>, <-26.5524, 193.8125, -59.08842> }
					triangle { <-30.384, 195.8103, -62.5455>, <-29.3261, 196.2017, -62.8873>, <-28.9697, 196.6944, -62.2268> }
					triangle { <-29.9502, 194.9826, -61.8188>, <-30.7484, 194.568, -61.4466>, <-30.384, 195.8103, -62.5455> }
					triangle { <-29.796, 194.3557, -61.3486>, <-29.205, 193.8988, -60.4161>, <-30.766, 194.3777, -60.5102> }
					triangle { <-29.9502, 194.9826, -61.8188>, <-29.796, 194.3557, -61.3486>, <-30.7484, 194.568, -61.4466> }
					triangle { <-29.796, 194.3557, -61.3486>, <-30.766, 194.3777, -60.5102>, <-30.7484, 194.568, -61.4466> }
					triangle { <-29.205, 193.8988, -60.4161>, <-30.1735, 194.301, -59.3685>, <-30.766, 194.3777, -60.5102> }
					triangle { <-28.7316, 193.7155, -59.6702>, <-29.437, 194.0925, -58.4239>, <-30.1735, 194.301, -59.3685> }
					triangle { <-29.205, 193.8988, -60.4161>, <-28.7316, 193.7155, -59.6702>, <-30.1735, 194.301, -59.3685> }
					triangle { <-27.6973, 193.5107, -58.2023>, <-28.5531, 193.75, -57.508>, <-29.437, 194.0925, -58.4239> }
					triangle { <-28.7316, 193.7155, -59.6702>, <-27.6973, 193.5107, -58.2023>, <-29.437, 194.0925, -58.4239> }
					triangle { <-26.8419, 192.2939, -58.5719>, <-27.3314, 191.9911, -58.6859>, <-28.5531, 193.75, -57.508> }
					triangle { <-27.6973, 193.5107, -58.2023>, <-26.8419, 192.2939, -58.5719>, <-28.5531, 193.75, -57.508> }
					triangle { <-26.415, 192.5344, -58.7702>, <-26.8419, 192.2939, -58.5719>, <-27.6973, 193.5107, -58.2023> }
					triangle { <-28.919, 194.3555, -60.5125>, <-29.796, 194.3557, -61.3486>, <-29.9502, 194.9826, -61.8188> }
					triangle { <-28.919, 194.3555, -60.5125>, <-29.205, 193.8988, -60.4161>, <-29.796, 194.3557, -61.3486> }
					triangle { <-28.919, 194.3555, -60.5125>, <-28.7316, 193.7155, -59.6702>, <-29.205, 193.8988, -60.4161> }
					triangle { <-28.919, 194.3555, -60.5125>, <-27.07082, 193.6859, -58.6221>, <-28.7316, 193.7155, -59.6702> }
					triangle { <-27.07082, 193.6859, -58.6221>, <-27.6973, 193.5107, -58.2023>, <-28.7316, 193.7155, -59.6702> }
					triangle { <-27.07082, 193.6859, -58.6221>, <-26.415, 192.5344, -58.7702>, <-27.6973, 193.5107, -58.2023> }
					triangle { <-27.07082, 193.6859, -58.6221>, <-26.1092, 192.8999, -58.9043>, <-26.415, 192.5344, -58.7702> }
					triangle { <-29.3293, 195.0533, -62.2037>, <-29.9502, 194.9826, -61.8188>, <-30.384, 195.8103, -62.5455> }
					triangle { <-29.3293, 195.0533, -62.2037>, <-28.919, 194.3555, -60.5125>, <-29.9502, 194.9826, -61.8188> }
					triangle { <-29.3293, 195.0533, -62.2037>, <-28.2894, 194.615, -61.02761>, <-28.919, 194.3555, -60.5125> }
					triangle { <-28.2894, 194.615, -61.02761>, <-27.07082, 193.6859, -58.6221>, <-28.919, 194.3555, -60.5125> }
					triangle { <-26.5524, 193.8125, -59.08842>, <-27.07082, 193.6859, -58.6221>, <-28.2894, 194.615, -61.02761> }
					triangle { <-26.5524, 193.8125, -59.08842>, <-26.1092, 192.8999, -58.9043>, <-27.07082, 193.6859, -58.6221> }
					triangle { <-26.5524, 193.8125, -59.08842>, <-25.8813, 193.2701, -59.03682>, <-26.1092, 192.8999, -58.9043> }
					triangle { <-30.7484, 194.568, -61.4466>, <-30.6046, 194.6734, -62.3265>, <-30.384, 195.8103, -62.5455> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-30.384, 195.8103, -62.5455>, <-30.6187, 196.5591, -61.03963>, <-29.8691, 196.2271, -61.5644> }
					triangle { <-30.6363, 196.3689, -60.1032>, <-29.03071, 196.5744, -59.8691>, <-29.65, 196.5957, -60.8907> }
					triangle { <-30.6187, 196.5591, -61.03963>, <-29.65, 196.5957, -60.8907>, <-29.8691, 196.2271, -61.5644> }
					triangle { <-30.6187, 196.5591, -61.03963>, <-30.6363, 196.3689, -60.1032>, <-29.65, 196.5957, -60.8907> }
					triangle { <-30.6363, 196.3689, -60.1032>, <-30.06814, 195.9188, -59.03786>, <-29.03071, 196.5744, -59.8691> }
					triangle { <-30.06814, 195.9188, -59.03786>, <-29.3357, 195.648, -58.1059>, <-28.5572, 196.3911, -59.1233> }
					triangle { <-30.06814, 195.9188, -59.03786>, <-28.5572, 196.3911, -59.1233>, <-29.03071, 196.5744, -59.8691> }
					triangle { <-29.3357, 195.648, -58.1059>, <-28.4395, 195.4923, -57.1519>, <-27.5432, 195.8752, -57.719> }
					triangle { <-29.3357, 195.648, -58.1059>, <-27.5432, 195.8752, -57.719>, <-28.5572, 196.3911, -59.1233> }
					triangle { <-28.4395, 195.4923, -57.1519>, <-26.9887, 197.6624, -57.5639>, <-26.705, 197.1858, -57.5516> }
					triangle { <-28.4395, 195.4923, -57.1519>, <-26.705, 197.1858, -57.5516>, <-27.5432, 195.8752, -57.719> }
					triangle { <-27.5432, 195.8752, -57.719>, <-26.705, 197.1858, -57.5516>, <-26.3439, 196.7909, -57.8045> }
					triangle { <-29.8691, 196.2271, -61.5644>, <-29.65, 196.5957, -60.8907>, <-28.8014, 196.1599, -60.1437> }
					triangle { <-29.65, 196.5957, -60.8907>, <-29.03071, 196.5744, -59.8691>, <-28.8014, 196.1599, -60.1437> }
					triangle { <-29.03071, 196.5744, -59.8691>, <-28.5572, 196.3911, -59.1233>, <-28.8014, 196.1599, -60.1437> }
					triangle { <-28.5572, 196.3911, -59.1233>, <-26.9329, 195.8015, -58.1896>, <-28.8014, 196.1599, -60.1437> }
					triangle { <-28.5572, 196.3911, -59.1233>, <-27.5432, 195.8752, -57.719>, <-26.9329, 195.8015, -58.1896> }
					triangle { <-27.5432, 195.8752, -57.719>, <-26.3439, 196.7909, -57.8045>, <-26.9329, 195.8015, -58.1896> }
					triangle { <-26.3439, 196.7909, -57.8045>, <-25.9853, 196.376, -58.1178>, <-26.9329, 195.8015, -58.1896> }
					triangle { <-30.384, 195.8103, -62.5455>, <-29.8691, 196.2271, -61.5644>, <-29.2522, 196.2356, -61.962> }
					triangle { <-29.8691, 196.2271, -61.5644>, <-28.8014, 196.1599, -60.1437>, <-29.2522, 196.2356, -61.962> }
					triangle { <-28.8014, 196.1599, -60.1437>, <-28.1961, 196.0461, -60.735>, <-29.2522, 196.2356, -61.962> }
					triangle { <-28.8014, 196.1599, -60.1437>, <-26.9329, 195.8015, -58.1896>, <-28.1961, 196.0461, -60.735> }
					triangle { <-28.1961, 196.0461, -60.735>, <-26.9329, 195.8015, -58.1896>, <-26.3751, 195.7457, -58.7312> }
					triangle { <-26.9329, 195.8015, -58.1896>, <-25.9853, 196.376, -58.1178>, <-26.3751, 195.7457, -58.7312> }
					triangle { <-25.9853, 196.376, -58.1178>, <-25.6433, 196.1366, -58.4888>, <-26.3751, 195.7457, -58.7312> }
					triangle { <-30.384, 195.8103, -62.5455>, <-30.4668, 196.789, -61.894>, <-30.6187, 196.5591, -61.03963> }
					triangle { <-29.2993, 195.5311, -62.1623>, <-29.09943, 194.7032, -62.6338>, <-30.384, 195.8103, -62.5455> }
					triangle { <-28.558, 195.2618, -62.03661>, <-27.7013, 194.9505, -61.2641>, <-28.6897, 193.991, -62.1459> }
					triangle { <-29.2993, 195.5311, -62.1623>, <-28.558, 195.2618, -62.03661>, <-29.09943, 194.7032, -62.6338> }
					triangle { <-28.558, 195.2618, -62.03661>, <-28.6897, 193.991, -62.1459>, <-29.09943, 194.7032, -62.6338> }
					triangle { <-27.7013, 194.9505, -61.2641>, <-28.1215, 193.5409, -61.08051>, <-28.6897, 193.991, -62.1459> }
					triangle { <-27.1804, 194.7092, -60.5681>, <-27.4365, 193.3281, -60.09877>, <-28.1215, 193.5409, -61.08051> }
					triangle { <-27.7013, 194.9505, -61.2641>, <-27.1804, 194.7092, -60.5681>, <-28.1215, 193.5409, -61.08051> }
					triangle { <-26.2613, 194.3093, -59.06419>, <-26.5879, 193.2304, -59.09492>, <-27.4365, 193.3281, -60.09877> }
					triangle { <-27.1804, 194.7092, -60.5681>, <-26.2613, 194.3093, -59.06419>, <-27.4365, 193.3281, -60.09877> }
					triangle { <-24.967, 195.109, -59.2493>, <-24.8896, 194.8527, -59.7714>, <-26.5879, 193.2304, -59.09492> }
					triangle { <-26.2613, 194.3093, -59.06419>, <-24.967, 195.109, -59.2493>, <-26.5879, 193.2304, -59.09492> }
					triangle { <-25.09074, 195.5519, -58.9887>, <-24.967, 195.109, -59.2493>, <-26.2613, 194.3093, -59.06419> }
					triangle { <-28.04177, 195.232, -60.9408>, <-28.558, 195.2618, -62.03661>, <-29.2993, 195.5311, -62.1623> }
					triangle { <-28.04177, 195.232, -60.9408>, <-27.7013, 194.9505, -61.2641>, <-28.558, 195.2618, -62.03661> }
					triangle { <-28.04177, 195.232, -60.9408>, <-27.1804, 194.7092, -60.5681>, <-27.7013, 194.9505, -61.2641> }
					triangle { <-28.04177, 195.232, -60.9408>, <-26.3157, 195.0475, -58.8373>, <-27.1804, 194.7092, -60.5681> }
					triangle { <-26.3157, 195.0475, -58.8373>, <-26.2613, 194.3093, -59.06419>, <-27.1804, 194.7092, -60.5681> }
					triangle { <-26.3157, 195.0475, -58.8373>, <-25.09074, 195.5519, -58.9887>, <-26.2613, 194.3093, -59.06419> }
					triangle { <-26.3157, 195.0475, -58.8373>, <-25.3518, 195.8709, -58.7146>, <-25.09074, 195.5519, -58.9887> }
					triangle { <-29.2522, 196.2356, -61.962>, <-29.2993, 195.5311, -62.1623>, <-30.384, 195.8103, -62.5455> }
					triangle { <-29.2522, 196.2356, -61.962>, <-28.04177, 195.232, -60.9408>, <-29.2993, 195.5311, -62.1623> }
					triangle { <-29.2522, 196.2356, -61.962>, <-28.1961, 196.0461, -60.735>, <-28.04177, 195.232, -60.9408> }
					triangle { <-28.1961, 196.0461, -60.735>, <-26.3157, 195.0475, -58.8373>, <-28.04177, 195.232, -60.9408> }
					triangle { <-26.3751, 195.7457, -58.7312>, <-26.3157, 195.0475, -58.8373>, <-28.1961, 196.0461, -60.735> }
					triangle { <-26.3751, 195.7457, -58.7312>, <-25.3518, 195.8709, -58.7146>, <-26.3157, 195.0475, -58.8373> }
					triangle { <-26.3751, 195.7457, -58.7312>, <-25.6433, 196.1366, -58.4888>, <-25.3518, 195.8709, -58.7146> }
					triangle { <-29.09943, 194.7032, -62.6338>, <-29.3748, 195.455, -63.03993>, <-30.384, 195.8103, -62.5455> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-30.384, 195.8103, -62.5455>, <-30.7484, 194.568, -61.4466>, <-30.33, 195.4465, -61.4203> }
					triangle { <-30.3387, 193.8557, -60.9586>, <-29.9172, 194.7687, -59.6688>, <-30.4132, 195.1097, -60.7009> }
					triangle { <-30.7484, 194.568, -61.4466>, <-30.4132, 195.1097, -60.7009>, <-30.33, 195.4465, -61.4203> }
					triangle { <-30.7484, 194.568, -61.4466>, <-30.3387, 193.8557, -60.9586>, <-30.4132, 195.1097, -60.7009> }
					triangle { <-30.3387, 193.8557, -60.9586>, <-29.4613, 193.431, -60.1158>, <-29.9172, 194.7687, -59.6688> }
					triangle { <-29.4613, 193.431, -60.1158>, <-28.7248, 193.2225, -59.1712>, <-29.3963, 194.5274, -58.9727> }
					triangle { <-29.4613, 193.431, -60.1158>, <-29.3963, 194.5274, -58.9727>, <-29.9172, 194.7687, -59.6688> }
					triangle { <-28.7248, 193.2225, -59.1712>, <-28.03085, 193.112, -58.05608>, <-28.2195, 194.1487, -57.6543> }
					triangle { <-28.7248, 193.2225, -59.1712>, <-28.2195, 194.1487, -57.6543>, <-29.3963, 194.5274, -58.9727> }
					triangle { <-28.03085, 193.112, -58.05608>, <-29.6053, 194.477, -56.4306>, <-29.07499, 194.6396, -56.4396> }
					triangle { <-28.03085, 193.112, -58.05608>, <-29.07499, 194.6396, -56.4396>, <-28.2195, 194.1487, -57.6543> }
					triangle { <-28.2195, 194.1487, -57.6543>, <-29.07499, 194.6396, -56.4396>, <-28.6611, 195.0536, -56.5272> }
					triangle { <-30.33, 195.4465, -61.4203>, <-30.4132, 195.1097, -60.7009>, <-29.5362, 195.1094, -59.8649> }
					triangle { <-30.4132, 195.1097, -60.7009>, <-29.9172, 194.7687, -59.6688>, <-29.5362, 195.1094, -59.8649> }
					triangle { <-29.9172, 194.7687, -59.6688>, <-29.3963, 194.5274, -58.9727>, <-29.5362, 195.1094, -59.8649> }
					triangle { <-29.3963, 194.5274, -58.9727>, <-28.06787, 194.9038, -57.5759>, <-29.5362, 195.1094, -59.8649> }
					triangle { <-29.3963, 194.5274, -58.9727>, <-28.2195, 194.1487, -57.6543>, <-28.06787, 194.9038, -57.5759> }
					triangle { <-28.2195, 194.1487, -57.6543>, <-28.6611, 195.0536, -56.5272>, <-28.06787, 194.9038, -57.5759> }
					triangle { <-28.6611, 195.0536, -56.5272>, <-28.2458, 195.5098, -56.6624>, <-28.06787, 194.9038, -57.5759> }
					triangle { <-30.384, 195.8103, -62.5455>, <-30.33, 195.4465, -61.4203>, <-30.2313, 196.1553, -61.2571> }
					triangle { <-30.33, 195.4465, -61.4203>, <-29.5362, 195.1094, -59.8649>, <-30.2313, 196.1553, -61.2571> }
					triangle { <-29.5362, 195.1094, -59.8649>, <-29.3814, 195.9489, -59.8817>, <-30.2313, 196.1553, -61.2571> }
					triangle { <-29.5362, 195.1094, -59.8649>, <-28.06787, 194.9038, -57.5759>, <-29.3814, 195.9489, -59.8817> }
					triangle { <-29.3814, 195.9489, -59.8817>, <-28.06787, 194.9038, -57.5759>, <-27.9686, 195.6769, -57.5683> }
					triangle { <-28.06787, 194.9038, -57.5759>, <-28.2458, 195.5098, -56.6624>, <-27.9686, 195.6769, -57.5683> }
					triangle { <-28.2458, 195.5098, -56.6624>, <-28.00976, 196.0044, -56.7694>, <-27.9686, 195.6769, -57.5683> }
					triangle { <-30.384, 195.8103, -62.5455>, <-31.1269, 195.3113, -61.7784>, <-30.7484, 194.568, -61.4466> }
					triangle { <-29.6629, 196.244, -61.7128>, <-28.9697, 196.6944, -62.2268>, <-30.384, 195.8103, -62.5455> }
					triangle { <-29.1347, 196.638, -61.2617>, <-28.3607, 196.6293, -60.3514>, <-28.05968, 196.5802, -61.9583> }
					triangle { <-29.6629, 196.244, -61.7128>, <-29.1347, 196.638, -61.2617>, <-28.9697, 196.6944, -62.2268> }
					triangle { <-29.1347, 196.638, -61.2617>, <-28.05968, 196.5802, -61.9583>, <-28.9697, 196.6944, -62.2268> }
					triangle { <-28.3607, 196.6293, -60.3514>, <-27.1823, 196.1555, -61.1155>, <-28.05968, 196.5802, -61.9583> }
					triangle { <-27.7842, 196.4545, -59.6798>, <-26.5013, 195.8805, -60.1465>, <-27.1823, 196.1555, -61.1155> }
					triangle { <-28.3607, 196.6293, -60.3514>, <-27.7842, 196.4545, -59.6798>, <-27.1823, 196.1555, -61.1155> }
					triangle { <-26.7187, 195.9429, -58.3126>, <-25.8629, 195.7036, -59.00697>, <-26.5013, 195.8805, -60.1465> }
					triangle { <-27.7842, 196.4545, -59.6798>, <-26.7187, 195.9429, -58.3126>, <-26.5013, 195.8805, -60.1465> }
					triangle { <-27.04915, 196.9806, -57.2342>, <-26.9271, 197.4088, -57.6164>, <-25.8629, 195.7036, -59.00697> }
					triangle { <-26.7187, 195.9429, -58.3126>, <-27.04915, 196.9806, -57.2342>, <-25.8629, 195.7036, -59.00697> }
					triangle { <-27.4235, 196.7222, -56.9651>, <-27.04915, 196.9806, -57.2342>, <-26.7187, 195.9429, -58.3126> }
					triangle { <-28.6468, 196.1726, -60.255>, <-29.1347, 196.638, -61.2617>, <-29.6629, 196.244, -61.7128> }
					triangle { <-28.6468, 196.1726, -60.255>, <-28.3607, 196.6293, -60.3514>, <-29.1347, 196.638, -61.2617> }
					triangle { <-28.6468, 196.1726, -60.255>, <-27.7842, 196.4545, -59.6798>, <-28.3607, 196.6293, -60.3514> }
					triangle { <-28.6468, 196.1726, -60.255>, <-27.3452, 195.7677, -57.8928>, <-27.7842, 196.4545, -59.6798> }
					triangle { <-27.3452, 195.7677, -57.8928>, <-26.7187, 195.9429, -58.3126>, <-27.7842, 196.4545, -59.6798> }
					triangle { <-27.3452, 195.7677, -57.8928>, <-27.4235, 196.7222, -56.9651>, <-26.7187, 195.9429, -58.3126> }
					triangle { <-27.3452, 195.7677, -57.8928>, <-27.7293, 196.3567, -56.831>, <-27.4235, 196.7222, -56.9651> }
					triangle { <-30.2313, 196.1553, -61.2571>, <-29.6629, 196.244, -61.7128>, <-30.384, 195.8103, -62.5455> }
					triangle { <-30.2313, 196.1553, -61.2571>, <-28.6468, 196.1726, -60.255>, <-29.6629, 196.244, -61.7128> }
					triangle { <-30.2313, 196.1553, -61.2571>, <-29.3814, 195.9489, -59.8817>, <-28.6468, 196.1726, -60.255> }
					triangle { <-29.3814, 195.9489, -59.8817>, <-27.3452, 195.7677, -57.8928>, <-28.6468, 196.1726, -60.255> }
					triangle { <-27.9686, 195.6769, -57.5683>, <-27.3452, 195.7677, -57.8928>, <-29.3814, 195.9489, -59.8817> }
					triangle { <-27.9686, 195.6769, -57.5683>, <-27.7293, 196.3567, -56.831>, <-27.3452, 195.7677, -57.8928> }
					triangle { <-27.9686, 195.6769, -57.5683>, <-28.00976, 196.0044, -56.7694>, <-27.7293, 196.3567, -56.831> }
					triangle { <-28.9697, 196.6944, -62.2268>, <-29.8484, 196.8397, -62.3392>, <-30.384, 195.8103, -62.5455> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-30.9523, 195.121, -63.4301>, <-31.1446, 196.0426, -63.7675>, 0.55 }
			cylinder { <-31.1446, 196.0426, -63.7675>, <-31.3181, 196.977, -64.07858>, 0.55 }
			cylinder { <-31.3181, 196.977, -64.07858>, <-31.4728, 197.9231, -64.363>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-31.4728, 197.9231, -64.363>, <-31.4678, 198.1987, -64.7802>, 0.55 }
				cylinder { <-31.4678, 198.1987, -64.7802>, <-31.383, 198.1429, -65.2698>, 0.55 }
				cylinder { <-31.383, 198.1429, -65.2698>, <-31.2596, 197.7829, -65.594>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-31.2596, 197.7829, -65.594>, <-32.321, 196.4667, -65.4365>, <-31.3836, 196.6074, -65.6586> }
					triangle { <-32.8218, 195.8419, -65.9582>, <-31.6122, 194.7506, -66.1034>, <-31.5885, 195.8372, -65.6069> }
					triangle { <-32.321, 196.4667, -65.4365>, <-31.5885, 195.8372, -65.6069>, <-31.3836, 196.6074, -65.6586> }
					triangle { <-32.321, 196.4667, -65.4365>, <-32.8218, 195.8419, -65.9582>, <-31.5885, 195.8372, -65.6069> }
					triangle { <-32.8218, 195.8419, -65.9582>, <-32.8785, 194.9187, -66.8553>, <-31.6122, 194.7506, -66.1034> }
					triangle { <-32.8785, 194.9187, -66.8553>, <-32.7397, 193.9404, -67.5637>, <-31.5986, 194.0128, -66.6226> }
					triangle { <-32.8785, 194.9187, -66.8553>, <-31.5986, 194.0128, -66.6226>, <-31.6122, 194.7506, -66.1034> }
					triangle { <-32.7397, 193.9404, -67.5637>, <-32.4839, 192.8148, -68.2002>, <-31.4564, 192.6278, -67.7749> }
					triangle { <-32.7397, 193.9404, -67.5637>, <-31.4564, 192.6278, -67.7749>, <-31.5986, 194.0128, -66.6226> }
					triangle { <-32.4839, 192.8148, -68.2002>, <-31.2123, 191.514, -66.2831>, <-30.943, 191.5467, -66.767> }
					triangle { <-32.4839, 192.8148, -68.2002>, <-30.943, 191.5467, -66.767>, <-31.4564, 192.6278, -67.7749> }
					triangle { <-31.4564, 192.6278, -67.7749>, <-30.943, 191.5467, -66.767>, <-30.4731, 191.7077, -67.0889> }
					triangle { <-31.3836, 196.6074, -65.6586>, <-31.5885, 195.8372, -65.6069>, <-31.2401, 195.0041, -66.4148> }
					triangle { <-31.5885, 195.8372, -65.6069>, <-31.6122, 194.7506, -66.1034>, <-31.2401, 195.0041, -66.4148> }
					triangle { <-31.6122, 194.7506, -66.1034>, <-31.5986, 194.0128, -66.6226>, <-31.2401, 195.0041, -66.4148> }
					triangle { <-31.5986, 194.0128, -66.6226>, <-30.6854, 192.6972, -67.7596>, <-31.2401, 195.0041, -66.4148> }
					triangle { <-31.5986, 194.0128, -66.6226>, <-31.4564, 192.6278, -67.7749>, <-30.6854, 192.6972, -67.7596> }
					triangle { <-31.4564, 192.6278, -67.7749>, <-30.4731, 191.7077, -67.0889>, <-30.6854, 192.6972, -67.7596> }
					triangle { <-30.4731, 191.7077, -67.0889>, <-29.9714, 191.9237, -67.406>, <-30.6854, 192.6972, -67.7596> }
					triangle { <-31.2596, 197.7829, -65.594>, <-31.3836, 196.6074, -65.6586>, <-30.6527, 196.5854, -65.5964> }
					triangle { <-31.3836, 196.6074, -65.6586>, <-31.2401, 195.0041, -66.4148>, <-30.6527, 196.5854, -65.5964> }
					triangle { <-31.2401, 195.0041, -66.4148>, <-30.4057, 195.1834, -66.3903>, <-30.6527, 196.5854, -65.5964> }
					triangle { <-31.2401, 195.0041, -66.4148>, <-30.6854, 192.6972, -67.7596>, <-30.4057, 195.1834, -66.3903> }
					triangle { <-30.4057, 195.1834, -66.3903>, <-30.6854, 192.6972, -67.7596>, <-29.9221, 192.8404, -67.6934> }
					triangle { <-30.6854, 192.6972, -67.7596>, <-29.9714, 191.9237, -67.406>, <-29.9221, 192.8404, -67.6934> }
					triangle { <-29.9714, 191.9237, -67.406>, <-29.4666, 192.1223, -67.5385>, <-29.9221, 192.8404, -67.6934> }
					triangle { <-31.2596, 197.7829, -65.594>, <-31.7541, 196.9441, -64.9299>, <-32.321, 196.4667, -65.4365> }
					triangle { <-30.5302, 197.0409, -66.1587>, <-30.04517, 197.6228, -66.7701>, <-31.2596, 197.7829, -65.594> }
					triangle { <-29.9528, 196.6681, -66.5654>, <-29.6209, 195.7622, -67.2703>, <-29.9058, 197.3232, -67.6668> }
					triangle { <-30.5302, 197.0409, -66.1587>, <-29.9528, 196.6681, -66.5654>, <-30.04517, 197.6228, -66.7701> }
					triangle { <-29.9528, 196.6681, -66.5654>, <-29.9058, 197.3232, -67.6668>, <-30.04517, 197.6228, -66.7701> }
					triangle { <-29.6209, 195.7622, -67.2703>, <-29.9626, 196.3999, -68.564>, <-29.9058, 197.3232, -67.6668> }
					triangle { <-29.5361, 195.0605, -67.8311>, <-29.8948, 195.3855, -69.2307>, <-29.9626, 196.3999, -68.564> }
					triangle { <-29.6209, 195.7622, -67.2703>, <-29.5361, 195.0605, -67.8311>, <-29.9626, 196.3999, -68.564> }
					triangle { <-29.5361, 193.6033, -68.9001>, <-29.7102, 194.2238, -69.8255>, <-29.8948, 195.3855, -69.2307> }
					triangle { <-29.5361, 195.0605, -67.8311>, <-29.5361, 193.6033, -68.9001>, <-29.8948, 195.3855, -69.2307> }
					triangle { <-28.4106, 192.7554, -68.2974>, <-28.04625, 193.2124, -68.3484>, <-29.7102, 194.2238, -69.8255> }
					triangle { <-29.5361, 193.6033, -68.9001>, <-28.4106, 192.7554, -68.2974>, <-29.7102, 194.2238, -69.8255> }
					triangle { <-28.6887, 192.4464, -67.9709>, <-28.4106, 192.7554, -68.2974>, <-29.5361, 193.6033, -68.9001> }
					triangle { <-30.1022, 195.5821, -67.08168>, <-29.9528, 196.6681, -66.5654>, <-30.5302, 197.0409, -66.1587> }
					triangle { <-30.1022, 195.5821, -67.08168>, <-29.6209, 195.7622, -67.2703>, <-29.9528, 196.6681, -66.5654> }
					triangle { <-30.1022, 195.5821, -67.08168>, <-29.5361, 195.0605, -67.8311>, <-29.6209, 195.7622, -67.2703> }
					triangle { <-30.1022, 195.5821, -67.08168>, <-29.7609, 193.1669, -68.3014>, <-29.5361, 195.0605, -67.8311> }
					triangle { <-29.7609, 193.1669, -68.3014>, <-29.5361, 193.6033, -68.9001>, <-29.5361, 195.0605, -67.8311> }
					triangle { <-29.7609, 193.1669, -68.3014>, <-28.6887, 192.4464, -67.9709>, <-29.5361, 193.6033, -68.9001> }
					triangle { <-29.7609, 193.1669, -68.3014>, <-29.07988, 192.2477, -67.7417>, <-28.6887, 192.4464, -67.9709> }
					triangle { <-30.6527, 196.5854, -65.5964>, <-30.5302, 197.0409, -66.1587>, <-31.2596, 197.7829, -65.594> }
					triangle { <-30.6527, 196.5854, -65.5964>, <-30.1022, 195.5821, -67.08168>, <-30.5302, 197.0409, -66.1587> }
					triangle { <-30.6527, 196.5854, -65.5964>, <-30.4057, 195.1834, -66.3903>, <-30.1022, 195.5821, -67.08168> }
					triangle { <-30.4057, 195.1834, -66.3903>, <-29.7609, 193.1669, -68.3014>, <-30.1022, 195.5821, -67.08168> }
					triangle { <-29.9221, 192.8404, -67.6934>, <-29.7609, 193.1669, -68.3014>, <-30.4057, 195.1834, -66.3903> }
					triangle { <-29.9221, 192.8404, -67.6934>, <-29.07988, 192.2477, -67.7417>, <-29.7609, 193.1669, -68.3014> }
					triangle { <-29.9221, 192.8404, -67.6934>, <-29.4666, 192.1223, -67.5385>, <-29.07988, 192.2477, -67.7417> }
					triangle { <-30.04517, 197.6228, -66.7701>, <-30.1183, 197.775, -65.8884>, <-31.2596, 197.7829, -65.594> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.2596, 197.7829, -65.594>, <-32.05702, 197.632, -67.08569>, <-31.7876, 197.0467, -66.3559> }
					triangle { <-31.9177, 197.3324, -67.9824>, <-32.3243, 195.7746, -67.6943>, <-32.2161, 196.6784, -66.9204> }
					triangle { <-32.05702, 197.632, -67.08569>, <-32.2161, 196.6784, -66.9204>, <-31.7876, 197.0467, -66.3559> }
					triangle { <-32.05702, 197.632, -67.08569>, <-31.9177, 197.3324, -67.9824>, <-32.2161, 196.6784, -66.9204> }
					triangle { <-31.9177, 197.3324, -67.9824>, <-31.5972, 196.4074, -68.8204>, <-32.3243, 195.7746, -67.6943> }
					triangle { <-31.5972, 196.4074, -68.8204>, <-31.4666, 195.3926, -69.4772>, <-32.2395, 195.0729, -68.2552> }
					triangle { <-31.5972, 196.4074, -68.8204>, <-32.2395, 195.0729, -68.2552>, <-32.3243, 195.7746, -67.6943> }
					triangle { <-31.4666, 195.3926, -69.4772>, <-31.4706, 194.2318, -70.1016>, <-31.9252, 193.6142, -69.2748> }
					triangle { <-31.4666, 195.3926, -69.4772>, <-31.9252, 193.6142, -69.2748>, <-32.2395, 195.0729, -68.2552> }
					triangle { <-31.4706, 194.2318, -70.1016>, <-33.7712, 193.2755, -69.2203>, <-33.3329, 192.9428, -69.1494> }
					triangle { <-31.4706, 194.2318, -70.1016>, <-33.3329, 192.9428, -69.1494>, <-31.9252, 193.6142, -69.2748> }
					triangle { <-31.9252, 193.6142, -69.2748>, <-33.3329, 192.9428, -69.1494>, <-32.9702, 192.6304, -68.8013> }
					triangle { <-31.7876, 197.0467, -66.3559>, <-32.2161, 196.6784, -66.9204>, <-31.9254, 195.5905, -67.3676> }
					triangle { <-32.2161, 196.6784, -66.9204>, <-32.3243, 195.7746, -67.6943>, <-31.9254, 195.5905, -67.3676> }
					triangle { <-32.3243, 195.7746, -67.6943>, <-32.2395, 195.0729, -68.2552>, <-31.9254, 195.5905, -67.3676> }
					triangle { <-32.2395, 195.0729, -68.2552>, <-31.8985, 193.1766, -68.6367>, <-31.9254, 195.5905, -67.3676> }
					triangle { <-32.2395, 195.0729, -68.2552>, <-31.9252, 193.6142, -69.2748>, <-31.8985, 193.1766, -68.6367> }
					triangle { <-31.9252, 193.6142, -69.2748>, <-32.9702, 192.6304, -68.8013>, <-31.8985, 193.1766, -68.6367> }
					triangle { <-32.9702, 192.6304, -68.8013>, <-32.5841, 192.3366, -68.397>, <-31.8985, 193.1766, -68.6367> }
					triangle { <-31.2596, 197.7829, -65.594>, <-31.7876, 197.0467, -66.3559>, <-31.8472, 196.5908, -65.7838> }
					triangle { <-31.7876, 197.0467, -66.3559>, <-31.9254, 195.5905, -67.3676>, <-31.8472, 196.5908, -65.7838> }
					triangle { <-31.9254, 195.5905, -67.3676>, <-31.8517, 195.19, -66.6172>, <-31.8472, 196.5908, -65.7838> }
					triangle { <-31.9254, 195.5905, -67.3676>, <-31.8985, 193.1766, -68.6367>, <-31.8517, 195.19, -66.6172> }
					triangle { <-31.8517, 195.19, -66.6172>, <-31.8985, 193.1766, -68.6367>, <-31.8794, 192.8129, -67.9476> }
					triangle { <-31.8985, 193.1766, -68.6367>, <-32.5841, 192.3366, -68.397>, <-31.8794, 192.8129, -67.9476> }
					triangle { <-32.5841, 192.3366, -68.397>, <-32.3669, 192.0991, -67.9406>, <-31.8794, 192.8129, -67.9476> }
					triangle { <-31.2596, 197.7829, -65.594>, <-32.2559, 197.7848, -66.2237>, <-32.05702, 197.632, -67.08569> }
					triangle { <-31.1322, 196.6062, -65.6191>, <-30.3091, 196.4575, -65.1209>, <-31.2596, 197.7829, -65.594> }
					triangle { <-30.9598, 195.8343, -65.5083>, <-30.7949, 194.7469, -65.9752>, <-29.6783, 195.8276, -65.4651> }
					triangle { <-31.1322, 196.6062, -65.6191>, <-30.9598, 195.8343, -65.5083>, <-30.3091, 196.4575, -65.1209> }
					triangle { <-30.9598, 195.8343, -65.5083>, <-29.6783, 195.8276, -65.4651>, <-30.3091, 196.4575, -65.1209> }
					triangle { <-30.7949, 194.7469, -65.9752>, <-29.3578, 194.9026, -66.3031>, <-29.6783, 195.8276, -65.4651> }
					triangle { <-30.6555, 194.0085, -66.4746>, <-29.2818, 193.9246, -67.02137>, <-29.3578, 194.9026, -66.3031> }
					triangle { <-30.7949, 194.7469, -65.9752>, <-30.6555, 194.0085, -66.4746>, <-29.3578, 194.9026, -66.3031> }
					triangle { <-30.4504, 192.6232, -67.6171>, <-29.3404, 192.8004, -67.7071>, <-29.2818, 193.9246, -67.02137> }
					triangle { <-30.6555, 194.0085, -66.4746>, <-30.4504, 192.6232, -67.6171>, <-29.2818, 193.9246, -67.02137> }
					triangle { <-31.3863, 191.566, -67.02082>, <-31.1126, 191.6225, -66.5048>, <-29.3404, 192.8004, -67.7071> }
					triangle { <-30.4504, 192.6232, -67.6171>, <-31.3863, 191.566, -67.02082>, <-29.3404, 192.8004, -67.7071> }
					triangle { <-31.8251, 191.6587, -67.3006>, <-31.3863, 191.566, -67.02082>, <-30.4504, 192.6232, -67.6171> }
					triangle { <-31.05156, 195.0032, -66.3853>, <-30.9598, 195.8343, -65.5083>, <-31.1322, 196.6062, -65.6191> }
					triangle { <-31.05156, 195.0032, -66.3853>, <-30.7949, 194.7469, -65.9752>, <-30.9598, 195.8343, -65.5083> }
					triangle { <-31.05156, 195.0032, -66.3853>, <-30.6555, 194.0085, -66.4746>, <-30.7949, 194.7469, -65.9752> }
					triangle { <-31.05156, 195.0032, -66.3853>, <-31.1884, 192.6995, -67.8385>, <-30.6555, 194.0085, -66.4746> }
					triangle { <-31.1884, 192.6995, -67.8385>, <-30.4504, 192.6232, -67.6171>, <-30.6555, 194.0085, -66.4746> }
					triangle { <-31.1884, 192.6995, -67.8385>, <-31.8251, 191.6587, -67.3006>, <-30.4504, 192.6232, -67.6171> }
					triangle { <-31.1884, 192.6995, -67.8385>, <-32.1255, 191.8606, -67.6383>, <-31.8251, 191.6587, -67.3006> }
					triangle { <-31.8472, 196.5908, -65.7838>, <-31.1322, 196.6062, -65.6191>, <-31.2596, 197.7829, -65.594> }
					triangle { <-31.8472, 196.5908, -65.7838>, <-31.05156, 195.0032, -66.3853>, <-31.1322, 196.6062, -65.6191> }
					triangle { <-31.8472, 196.5908, -65.7838>, <-31.8517, 195.19, -66.6172>, <-31.05156, 195.0032, -66.3853> }
					triangle { <-31.8517, 195.19, -66.6172>, <-31.1884, 192.6995, -67.8385>, <-31.05156, 195.0032, -66.3853> }
					triangle { <-31.8794, 192.8129, -67.9476>, <-31.1884, 192.6995, -67.8385>, <-31.8517, 195.19, -66.6172> }
					triangle { <-31.8794, 192.8129, -67.9476>, <-32.1255, 191.8606, -67.6383>, <-31.1884, 192.6995, -67.8385> }
					triangle { <-31.8794, 192.8129, -67.9476>, <-32.3669, 192.0991, -67.9406>, <-32.1255, 191.8606, -67.6383> }
					triangle { <-30.3091, 196.4575, -65.1209>, <-30.9996, 196.9407, -64.8115>, <-31.2596, 197.7829, -65.594> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.2596, 197.7829, -65.594>, <-30.04517, 197.6228, -66.7701>, <-30.9672, 197.3345, -66.6498> }
					triangle { <-29.4143, 196.9928, -67.1142>, <-30.4402, 196.3127, -68.1912>, <-30.6628, 197.1452, -67.3636> }
					triangle { <-30.04517, 197.6228, -66.7701>, <-30.6628, 197.1452, -67.3636>, <-30.9672, 197.3345, -66.6498> }
					triangle { <-30.04517, 197.6228, -66.7701>, <-29.4143, 196.9928, -67.1142>, <-30.6628, 197.1452, -67.3636> }
					triangle { <-29.4143, 196.9928, -67.1142>, <-29.1433, 195.8494, -67.643>, <-30.4402, 196.3127, -68.1912> }
					triangle { <-29.1433, 195.8494, -67.643>, <-29.07559, 194.8349, -68.3097>, <-30.3008, 195.5744, -68.6907> }
					triangle { <-29.1433, 195.8494, -67.643>, <-30.3008, 195.5744, -68.6907>, <-30.4402, 196.3127, -68.1912> }
					triangle { <-29.07559, 194.8349, -68.3097>, <-29.1094, 193.82, -69.1501>, <-30.1369, 194.007, -69.5755> }
					triangle { <-29.07559, 194.8349, -68.3097>, <-30.1369, 194.007, -69.5755>, <-30.3008, 195.5744, -68.6907> }
					triangle { <-29.1094, 193.82, -69.1501>, <-30.3657, 194.9732, -71.1691>, <-30.5891, 194.4977, -70.9907> }
					triangle { <-29.1094, 193.82, -69.1501>, <-30.5891, 194.4977, -70.9907>, <-30.1369, 194.007, -69.5755> }
					triangle { <-30.1369, 194.007, -69.5755>, <-30.5891, 194.4977, -70.9907>, <-31.04378, 194.1891, -70.7708> }
					triangle { <-30.9672, 197.3345, -66.6498>, <-30.6628, 197.1452, -67.3636>, <-30.8123, 196.0593, -67.8798> }
					triangle { <-30.6628, 197.1452, -67.3636>, <-30.4402, 196.3127, -68.1912>, <-30.8123, 196.0593, -67.8798> }
					triangle { <-30.4402, 196.3127, -68.1912>, <-30.3008, 195.5744, -68.6907>, <-30.8123, 196.0593, -67.8798> }
					triangle { <-30.3008, 195.5744, -68.6907>, <-30.9079, 193.9376, -69.5907>, <-30.8123, 196.0593, -67.8798> }
					triangle { <-30.3008, 195.5744, -68.6907>, <-30.1369, 194.007, -69.5755>, <-30.9079, 193.9376, -69.5907> }
					triangle { <-30.1369, 194.007, -69.5755>, <-31.04378, 194.1891, -70.7708>, <-30.9079, 193.9376, -69.5907> }
					triangle { <-31.04378, 194.1891, -70.7708>, <-31.5377, 193.8993, -70.5045>, <-30.9079, 193.9376, -69.5907> }
					triangle { <-31.2596, 197.7829, -65.594>, <-30.9672, 197.3345, -66.6498>, <-31.6905, 197.2827, -66.763> }
					triangle { <-30.9672, 197.3345, -66.6498>, <-30.8123, 196.0593, -67.8798>, <-31.6905, 197.2827, -66.763> }
					triangle { <-30.8123, 196.0593, -67.8798>, <-31.662, 196.0276, -67.8025>, <-31.6905, 197.2827, -66.763> }
					triangle { <-30.8123, 196.0593, -67.8798>, <-30.9079, 193.9376, -69.5907>, <-31.662, 196.0276, -67.8025> }
					triangle { <-31.662, 196.0276, -67.8025>, <-30.9079, 193.9376, -69.5907>, <-31.6865, 193.942, -69.5551> }
					triangle { <-30.9079, 193.9376, -69.5907>, <-31.5377, 193.8993, -70.5045>, <-31.6865, 193.942, -69.5551> }
					triangle { <-31.5377, 193.8993, -70.5045>, <-32.05027, 193.7744, -70.3211>, <-31.6865, 193.942, -69.5551> }
					triangle { <-31.2596, 197.7829, -65.594>, <-30.7191, 198.1788, -66.5637>, <-30.04517, 197.6228, -66.7701> }
					triangle { <-31.8206, 196.901, -66.1498>, <-32.321, 196.4667, -65.4365>, <-31.2596, 197.7829, -65.594> }
					triangle { <-32.2986, 196.3143, -66.4051>, <-32.4315, 195.3012, -67.02441>, <-32.3302, 195.5116, -65.4056> }
					triangle { <-31.8206, 196.901, -66.1498>, <-32.2986, 196.3143, -66.4051>, <-32.321, 196.4667, -65.4365> }
					triangle { <-32.2986, 196.3143, -66.4051>, <-32.3302, 195.5116, -65.4056>, <-32.321, 196.4667, -65.4365> }
					triangle { <-32.4315, 195.3012, -67.02441>, <-32.05925, 194.3682, -65.9344>, <-32.3302, 195.5116, -65.4056> }
					triangle { <-32.3633, 194.5267, -67.4821>, <-31.9204, 193.3898, -66.6428>, <-32.05925, 194.3682, -65.9344> }
					triangle { <-32.4315, 195.3012, -67.02441>, <-32.3633, 194.5267, -67.4821>, <-32.05925, 194.3682, -65.9344> }
					triangle { <-32.05724, 193.0316, -68.4503>, <-31.8831, 192.4111, -67.5248>, <-31.9204, 193.3898, -66.6428> }
					triangle { <-32.3633, 194.5267, -67.4821>, <-32.05724, 193.0316, -68.4503>, <-31.9204, 193.3898, -66.6428> }
					triangle { <-33.1062, 193.1414, -69.5622>, <-33.5242, 193.201, -69.1548>, <-31.8831, 192.4111, -67.5248> }
					triangle { <-32.05724, 193.0316, -68.4503>, <-33.1062, 193.1414, -69.5622>, <-31.8831, 192.4111, -67.5248> }
					triangle { <-32.8205, 193.3766, -69.9397>, <-33.1062, 193.1414, -69.5622>, <-32.05724, 193.0316, -68.4503> }
					triangle { <-31.9502, 195.4812, -67.213>, <-32.2986, 196.3143, -66.4051>, <-31.8206, 196.901, -66.1498> }
					triangle { <-31.9502, 195.4812, -67.213>, <-32.4315, 195.3012, -67.02441>, <-32.2986, 196.3143, -66.4051> }
					triangle { <-31.9502, 195.4812, -67.213>, <-32.3633, 194.5267, -67.4821>, <-32.4315, 195.3012, -67.02441> }
					triangle { <-31.9502, 195.4812, -67.213>, <-31.8324, 193.468, -69.04901>, <-32.3633, 194.5267, -67.4821> }
					triangle { <-31.8324, 193.468, -69.04901>, <-32.05724, 193.0316, -68.4503>, <-32.3633, 194.5267, -67.4821> }
					triangle { <-31.8324, 193.468, -69.04901>, <-32.8205, 193.3766, -69.9397>, <-32.05724, 193.0316, -68.4503> }
					triangle { <-31.8324, 193.468, -69.04901>, <-32.4293, 193.5753, -70.1689>, <-32.8205, 193.3766, -69.9397> }
					triangle { <-31.6905, 197.2827, -66.763>, <-31.8206, 196.901, -66.1498>, <-31.2596, 197.7829, -65.594> }
					triangle { <-31.6905, 197.2827, -66.763>, <-31.9502, 195.4812, -67.213>, <-31.8206, 196.901, -66.1498> }
					triangle { <-31.6905, 197.2827, -66.763>, <-31.662, 196.0276, -67.8025>, <-31.9502, 195.4812, -67.213> }
					triangle { <-31.662, 196.0276, -67.8025>, <-31.8324, 193.468, -69.04901>, <-31.9502, 195.4812, -67.213> }
					triangle { <-31.6865, 193.942, -69.5551>, <-31.8324, 193.468, -69.04901>, <-31.662, 196.0276, -67.8025> }
					triangle { <-31.6865, 193.942, -69.5551>, <-32.4293, 193.5753, -70.1689>, <-31.8324, 193.468, -69.04901> }
					triangle { <-31.6865, 193.942, -69.5551>, <-32.05027, 193.7744, -70.3211>, <-32.4293, 193.5753, -70.1689> }
					triangle { <-32.321, 196.4667, -65.4365>, <-32.3549, 197.3478, -65.6052>, <-31.2596, 197.7829, -65.594> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.2596, 197.7829, -65.594>, <-30.3091, 196.4575, -65.1209>, <-30.5632, 196.8952, -65.9525> }
					triangle { <-30.3183, 195.5024, -65.09006>, <-29.7281, 195.2888, -66.6003>, <-30.0353, 196.304, -66.05011> }
					triangle { <-30.3091, 196.4575, -65.1209>, <-30.0353, 196.304, -66.05011>, <-30.5632, 196.8952, -65.9525> }
					triangle { <-30.3091, 196.4575, -65.1209>, <-30.3183, 195.5024, -65.09006>, <-30.0353, 196.304, -66.05011> }
					triangle { <-30.3183, 195.5024, -65.09006>, <-30.4246, 194.3607, -65.678>, <-29.7281, 195.2888, -66.6003> }
					triangle { <-30.4246, 194.3607, -65.678>, <-30.3486, 193.3826, -66.3962>, <-29.6598, 194.5143, -67.05811> }
					triangle { <-30.4246, 194.3607, -65.678>, <-29.6598, 194.5143, -67.05811>, <-29.7281, 195.2888, -66.6003> }
					triangle { <-30.3486, 193.3826, -66.3962>, <-30.1227, 192.403, -67.2487>, <-29.6681, 193.0206, -68.07556> }
					triangle { <-30.3486, 193.3826, -66.3962>, <-29.6681, 193.0206, -68.07556>, <-29.6598, 194.5143, -67.05811> }
					triangle { <-30.1227, 192.403, -67.2487>, <-27.8068, 193.2117, -68.2319>, <-28.1992, 193.1016, -68.6083> }
					triangle { <-30.1227, 192.403, -67.2487>, <-28.1992, 193.1016, -68.6083>, <-29.6681, 193.0206, -68.07556> }
					triangle { <-29.6681, 193.0206, -68.07556>, <-28.1992, 193.1016, -68.6083>, <-28.5466, 193.2663, -69.05838> }
					triangle { <-30.5632, 196.8952, -65.9525>, <-30.0353, 196.304, -66.05011>, <-30.127, 195.4729, -66.927> }
					triangle { <-30.0353, 196.304, -66.05011>, <-29.7281, 195.2888, -66.6003>, <-30.127, 195.4729, -66.927> }
					triangle { <-29.7281, 195.2888, -66.6003>, <-29.6598, 194.5143, -67.05811>, <-30.127, 195.4729, -66.927> }
					triangle { <-29.6598, 194.5143, -67.05811>, <-29.6949, 193.4582, -68.7137>, <-30.127, 195.4729, -66.927> }
					triangle { <-29.6598, 194.5143, -67.05811>, <-29.6681, 193.0206, -68.07556>, <-29.6949, 193.4582, -68.7137> }
					triangle { <-29.6681, 193.0206, -68.07556>, <-28.5466, 193.2663, -69.05838>, <-29.6949, 193.4582, -68.7137> }
					triangle { <-28.5466, 193.2663, -69.05838>, <-28.9251, 193.4863, -69.5136>, <-29.6949, 193.4582, -68.7137> }
					triangle { <-31.2596, 197.7829, -65.594>, <-30.5632, 196.8952, -65.9525>, <-30.4959, 197.2773, -66.5756> }
					triangle { <-30.5632, 196.8952, -65.9525>, <-30.127, 195.4729, -66.927>, <-30.4959, 197.2773, -66.5756> }
					triangle { <-30.127, 195.4729, -66.927>, <-30.216, 196.021, -67.5756>, <-30.4959, 197.2773, -66.5756> }
					triangle { <-30.127, 195.4729, -66.927>, <-29.6949, 193.4582, -68.7137>, <-30.216, 196.021, -67.5756> }
					triangle { <-30.216, 196.021, -67.5756>, <-29.6949, 193.4582, -68.7137>, <-29.7293, 193.9695, -69.3009> }
					triangle { <-29.6949, 193.4582, -68.7137>, <-28.9251, 193.4863, -69.5136>, <-29.7293, 193.9695, -69.3009> }
					triangle { <-28.9251, 193.4863, -69.5136>, <-29.1499, 193.7977, -69.919>, <-29.7293, 193.9695, -69.3009> }
					triangle { <-31.2596, 197.7829, -65.594>, <-30.2173, 197.3381, -65.2699>, <-30.3091, 196.4575, -65.1209> }
					triangle { <-31.2186, 197.3357, -66.6893>, <-32.05702, 197.632, -67.08569>, <-31.2596, 197.7829, -65.594> }
					triangle { <-31.2915, 197.1481, -67.4622>, <-31.2575, 196.3165, -68.3194>, <-32.5578, 197.0072, -67.6073> }
					triangle { <-31.2186, 197.3357, -66.6893>, <-31.2915, 197.1481, -67.4622>, <-32.05702, 197.632, -67.08569> }
					triangle { <-31.2915, 197.1481, -67.4622>, <-32.5578, 197.0072, -67.6073>, <-32.05702, 197.632, -67.08569> }
					triangle { <-31.2575, 196.3165, -68.3194>, <-32.664, 195.8655, -68.1953>, <-32.5578, 197.0072, -67.6073> }
					triangle { <-31.2438, 195.5787, -68.8386>, <-32.5334, 194.8507, -68.8521>, <-32.664, 195.8655, -68.1953> }
					triangle { <-31.2575, 196.3165, -68.3194>, <-31.2438, 195.5787, -68.8386>, <-32.664, 195.8655, -68.1953> }
					triangle { <-31.1429, 194.0116, -69.7332>, <-32.2529, 193.8344, -69.6432>, <-32.5334, 194.8507, -68.8521> }
					triangle { <-31.2438, 195.5787, -68.8386>, <-31.1429, 194.0116, -69.7332>, <-32.5334, 194.8507, -68.8521> }
					triangle { <-30.1305, 194.3307, -70.8389>, <-30.4577, 194.7909, -70.9983>, <-32.2529, 193.8344, -69.6432> }
					triangle { <-31.1429, 194.0116, -69.7332>, <-30.1305, 194.3307, -70.8389>, <-32.2529, 193.8344, -69.6432> }
					triangle { <-29.6841, 194.1642, -70.61>, <-30.1305, 194.3307, -70.8389>, <-31.1429, 194.0116, -69.7332> }
					triangle { <-31.00092, 196.0601, -67.9094>, <-31.2915, 197.1481, -67.4622>, <-31.2186, 197.3357, -66.6893> }
					triangle { <-31.00092, 196.0601, -67.9094>, <-31.2575, 196.3165, -68.3194>, <-31.2915, 197.1481, -67.4622> }
					triangle { <-31.00092, 196.0601, -67.9094>, <-31.2438, 195.5787, -68.8386>, <-31.2575, 196.3165, -68.3194> }
					triangle { <-31.00092, 196.0601, -67.9094>, <-30.4049, 193.9353, -69.5118>, <-31.2438, 195.5787, -68.8386> }
					triangle { <-30.4049, 193.9353, -69.5118>, <-31.1429, 194.0116, -69.7332>, <-31.2438, 195.5787, -68.8386> }
					triangle { <-30.4049, 193.9353, -69.5118>, <-29.6841, 194.1642, -70.61>, <-31.1429, 194.0116, -69.7332> }
					triangle { <-30.4049, 193.9353, -69.5118>, <-29.3837, 193.9623, -70.2723>, <-29.6841, 194.1642, -70.61> }
					triangle { <-30.4959, 197.2773, -66.5756>, <-31.2186, 197.3357, -66.6893>, <-31.2596, 197.7829, -65.594> }
					triangle { <-30.4959, 197.2773, -66.5756>, <-31.00092, 196.0601, -67.9094>, <-31.2186, 197.3357, -66.6893> }
					triangle { <-30.4959, 197.2773, -66.5756>, <-30.216, 196.021, -67.5756>, <-31.00092, 196.0601, -67.9094> }
					triangle { <-30.216, 196.021, -67.5756>, <-30.4049, 193.9353, -69.5118>, <-31.00092, 196.0601, -67.9094> }
					triangle { <-29.7293, 193.9695, -69.3009>, <-30.4049, 193.9353, -69.5118>, <-30.216, 196.021, -67.5756> }
					triangle { <-29.7293, 193.9695, -69.3009>, <-29.3837, 193.9623, -70.2723>, <-30.4049, 193.9353, -69.5118> }
					triangle { <-29.7293, 193.9695, -69.3009>, <-29.1499, 193.7977, -69.919>, <-29.3837, 193.9623, -70.2723> }
					triangle { <-32.05702, 197.632, -67.08569>, <-31.4736, 198.1822, -66.6821>, <-31.2596, 197.7829, -65.594> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-31.4728, 197.9231, -64.363>, <-31.6222, 198.8596, -64.6804>, 0.55 }
			cylinder { <-31.6222, 198.8596, -64.6804>, <-31.7663, 199.7852, -65.03031>, 0.55 }
			cylinder { <-31.7663, 199.7852, -65.03031>, <-31.9048, 200.6989, -65.4123>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-31.9048, 200.6989, -65.4123>, <-32.2205, 201.0841, -65.3676>, 0.55 }
				cylinder { <-32.2205, 201.0841, -65.3676>, <-32.6292, 201.2106, -65.1089>, 0.55 }
				cylinder { <-32.6292, 201.2106, -65.1089>, <-32.9326, 201.017, -64.7618>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-32.9326, 201.017, -64.7618>, <-32.02692, 200.4789, -63.4299>, <-32.8422, 200.2177, -63.8932> }
					triangle { <-32.02839, 200.4784, -62.4743>, <-32.9237, 199.1188, -62.3174>, <-32.6298, 199.7146, -63.3104> }
					triangle { <-32.02692, 200.4789, -63.4299>, <-32.6298, 199.7146, -63.3104>, <-32.8422, 200.2177, -63.8932> }
					triangle { <-32.02692, 200.4789, -63.4299>, <-32.02839, 200.4784, -62.4743>, <-32.6298, 199.7146, -63.3104> }
					triangle { <-32.02839, 200.4784, -62.4743>, <-32.5949, 200.1946, -61.3522>, <-32.9237, 199.1188, -62.3174> }
					triangle { <-32.5949, 200.1946, -61.3522>, <-33.1586, 199.6913, -60.3998>, <-33.2749, 198.7777, -61.5595> }
					triangle { <-32.5949, 200.1946, -61.3522>, <-33.2749, 198.7777, -61.5595>, <-32.9237, 199.1188, -62.3174> }
					triangle { <-33.1586, 199.6913, -60.3998>, <-33.7453, 198.9881, -59.4518>, <-34.143, 198.1564, -60.1012> }
					triangle { <-33.1586, 199.6913, -60.3998>, <-34.143, 198.1564, -60.1012>, <-33.2749, 198.7777, -61.5595> }
					triangle { <-33.7453, 198.9881, -59.4518>, <-33.1901, 196.5526, -60.3145>, <-33.7265, 196.6523, -60.2136> }
					triangle { <-33.7453, 198.9881, -59.4518>, <-33.7265, 196.6523, -60.2136>, <-34.143, 198.1564, -60.1012> }
					triangle { <-34.143, 198.1564, -60.1012>, <-33.7265, 196.6523, -60.2136>, <-34.2907, 196.6803, -60.3903> }
					triangle { <-32.8422, 200.2177, -63.8932>, <-32.6298, 199.7146, -63.3104>, <-33.4167, 199.2605, -62.5088> }
					triangle { <-32.6298, 199.7146, -63.3104>, <-32.9237, 199.1188, -62.3174>, <-33.4167, 199.2605, -62.5088> }
					triangle { <-32.9237, 199.1188, -62.3174>, <-33.2749, 198.7777, -61.5595>, <-33.4167, 199.2605, -62.5088> }
					triangle { <-33.2749, 198.7777, -61.5595>, <-34.6691, 197.8214, -60.5599>, <-33.4167, 199.2605, -62.5088> }
					triangle { <-33.2749, 198.7777, -61.5595>, <-34.143, 198.1564, -60.1012>, <-34.6691, 197.8214, -60.5599> }
					triangle { <-34.143, 198.1564, -60.1012>, <-34.2907, 196.6803, -60.3903>, <-34.6691, 197.8214, -60.5599> }
					triangle { <-34.2907, 196.6803, -60.3903>, <-34.8759, 196.7321, -60.6222>, <-34.6691, 197.8214, -60.5599> }
					triangle { <-32.9326, 201.017, -64.7618>, <-32.8422, 200.2177, -63.8932>, <-33.303, 199.8133, -64.2968> }
					triangle { <-32.8422, 200.2177, -63.8932>, <-33.4167, 199.2605, -62.5088>, <-33.303, 199.8133, -64.2968> }
					triangle { <-33.4167, 199.2605, -62.5088>, <-33.9849, 198.9733, -63.07774>, <-33.303, 199.8133, -64.2968> }
					triangle { <-33.4167, 199.2605, -62.5088>, <-34.6691, 197.8214, -60.5599>, <-33.9849, 198.9733, -63.07774> }
					triangle { <-33.9849, 198.9733, -63.07774>, <-34.6691, 197.8214, -60.5599>, <-35.1565, 197.5242, -61.09055> }
					triangle { <-34.6691, 197.8214, -60.5599>, <-34.8759, 196.7321, -60.6222>, <-35.1565, 197.5242, -61.09055> }
					triangle { <-34.8759, 196.7321, -60.6222>, <-35.3296, 196.6898, -60.945>, <-35.1565, 197.5242, -61.09055> }
					triangle { <-32.9326, 201.017, -64.7618>, <-32.07566, 200.3418, -64.3158>, <-32.02692, 200.4789, -63.4299> }
					triangle { <-33.8122, 200.3389, -64.3524>, <-34.6136, 200.8019, -64.6543>, <-32.9326, 201.017, -64.7618> }
					triangle { <-34.489, 199.9468, -64.1905>, <-35.1871, 199.4014, -63.3887>, <-35.3426, 200.8923, -64.04302> }
					triangle { <-33.8122, 200.3389, -64.3524>, <-34.489, 199.9468, -64.1905>, <-34.6136, 200.8019, -64.6543> }
					triangle { <-34.489, 199.9468, -64.1905>, <-35.3426, 200.8923, -64.04302>, <-34.6136, 200.8019, -64.6543> }
					triangle { <-35.1871, 199.4014, -63.3887>, <-35.9091, 200.6085, -62.9209>, <-35.3426, 200.8923, -64.04302> }
					triangle { <-35.6191, 199.0704, -62.6691>, <-36.392, 200.0951, -61.9303>, <-35.9091, 200.6085, -62.9209> }
					triangle { <-35.1871, 199.4014, -63.3887>, <-35.6191, 199.0704, -62.6691>, <-35.9091, 200.6085, -62.9209> }
					triangle { <-36.3255, 198.4289, -61.1342>, <-36.8978, 199.3818, -60.9439>, <-36.392, 200.0951, -61.9303> }
					triangle { <-35.6191, 199.0704, -62.6691>, <-36.3255, 198.4289, -61.1342>, <-36.392, 200.0951, -61.9303> }
					triangle { <-36.6349, 196.973, -61.4999>, <-36.9438, 197.1603, -61.9622>, <-36.8978, 199.3818, -60.9439> }
					triangle { <-36.3255, 198.4289, -61.1342>, <-36.6349, 196.973, -61.4999>, <-36.8978, 199.3818, -60.9439> }
					triangle { <-36.1938, 196.7364, -61.3298>, <-36.6349, 196.973, -61.4999>, <-36.3255, 198.4289, -61.1342> }
					triangle { <-34.71, 199.422, -63.121>, <-34.489, 199.9468, -64.1905>, <-33.8122, 200.3389, -64.3524> }
					triangle { <-34.71, 199.422, -63.121>, <-35.1871, 199.4014, -63.3887>, <-34.489, 199.9468, -64.1905> }
					triangle { <-34.71, 199.422, -63.121>, <-35.6191, 199.0704, -62.6691>, <-35.1871, 199.4014, -63.3887> }
					triangle { <-34.71, 199.422, -63.121>, <-35.72, 197.9527, -61.0573>, <-35.6191, 199.0704, -62.6691> }
					triangle { <-35.72, 197.9527, -61.0573>, <-36.3255, 198.4289, -61.1342>, <-35.6191, 199.0704, -62.6691> }
					triangle { <-35.72, 197.9527, -61.0573>, <-36.1938, 196.7364, -61.3298>, <-36.3255, 198.4289, -61.1342> }
					triangle { <-35.72, 197.9527, -61.0573>, <-35.7492, 196.6809, -61.1194>, <-36.1938, 196.7364, -61.3298> }
					triangle { <-33.303, 199.8133, -64.2968>, <-33.8122, 200.3389, -64.3524>, <-32.9326, 201.017, -64.7618> }
					triangle { <-33.303, 199.8133, -64.2968>, <-34.71, 199.422, -63.121>, <-33.8122, 200.3389, -64.3524> }
					triangle { <-33.303, 199.8133, -64.2968>, <-33.9849, 198.9733, -63.07774>, <-34.71, 199.422, -63.121> }
					triangle { <-33.9849, 198.9733, -63.07774>, <-35.72, 197.9527, -61.0573>, <-34.71, 199.422, -63.121> }
					triangle { <-35.1565, 197.5242, -61.09055>, <-35.72, 197.9527, -61.0573>, <-33.9849, 198.9733, -63.07774> }
					triangle { <-35.1565, 197.5242, -61.09055>, <-35.7492, 196.6809, -61.1194>, <-35.72, 197.9527, -61.0573> }
					triangle { <-35.1565, 197.5242, -61.09055>, <-35.3296, 196.6898, -60.945>, <-35.7492, 196.6809, -61.1194> }
					triangle { <-34.6136, 200.8019, -64.6543>, <-33.9348, 200.5739, -65.1958>, <-32.9326, 201.017, -64.7618> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-32.9326, 201.017, -64.7618>, <-33.4472, 201.9383, -63.4314>, <-33.08332, 201.0491, -63.5881> }
					triangle { <-34.1762, 202.0287, -62.8201>, <-33.6198, 200.9284, -61.7455>, <-33.1768, 201.2253, -62.8147> }
					triangle { <-33.4472, 201.9383, -63.4314>, <-33.1768, 201.2253, -62.8147>, <-33.08332, 201.0491, -63.5881> }
					triangle { <-33.4472, 201.9383, -63.4314>, <-34.1762, 202.0287, -62.8201>, <-33.1768, 201.2253, -62.8147> }
					triangle { <-34.1762, 202.0287, -62.8201>, <-34.9614, 201.5318, -61.9273>, <-33.6198, 200.9284, -61.7455> }
					triangle { <-34.9614, 201.5318, -61.9273>, <-35.4808, 200.9829, -60.9749>, <-34.05188, 200.5975, -61.02588> }
					triangle { <-34.9614, 201.5318, -61.9273>, <-34.05188, 200.5975, -61.02588>, <-33.6198, 200.9284, -61.7455> }
					triangle { <-35.4808, 200.9829, -60.9749>, <-35.8773, 200.3761, -59.8739>, <-34.9405, 199.7784, -59.6821> }
					triangle { <-35.4808, 200.9829, -60.9749>, <-34.9405, 199.7784, -59.6821>, <-34.05188, 200.5975, -61.02588> }
					triangle { <-35.8773, 200.3761, -59.8739>, <-33.6076, 200.4108, -58.5206>, <-33.8458, 199.9124, -58.5721> }
					triangle { <-35.8773, 200.3761, -59.8739>, <-33.8458, 199.9124, -58.5721>, <-34.9405, 199.7784, -59.6821> }
					triangle { <-34.9405, 199.7784, -59.6821>, <-33.8458, 199.9124, -58.5721>, <-33.833, 199.3475, -58.7482> }
					triangle { <-33.08332, 201.0491, -63.5881>, <-33.1768, 201.2253, -62.8147>, <-33.653, 200.4518, -62.01278> }
					triangle { <-33.1768, 201.2253, -62.8147>, <-33.6198, 200.9284, -61.7455>, <-33.653, 200.4518, -62.01278> }
					triangle { <-33.6198, 200.9284, -61.7455>, <-34.05188, 200.5975, -61.02588>, <-33.653, 200.4518, -62.01278> }
					triangle { <-34.05188, 200.5975, -61.02588>, <-34.4807, 199.1601, -59.7579>, <-33.653, 200.4518, -62.01278> }
					triangle { <-34.05188, 200.5975, -61.02588>, <-34.9405, 199.7784, -59.6821>, <-34.4807, 199.1601, -59.7579> }
					triangle { <-34.9405, 199.7784, -59.6821>, <-33.833, 199.3475, -58.7482>, <-34.4807, 199.1601, -59.7579> }
					triangle { <-33.833, 199.3475, -58.7482>, <-33.7968, 198.7608, -58.9794>, <-34.4807, 199.1601, -59.7579> }
					triangle { <-32.9326, 201.017, -64.7618>, <-33.08332, 201.0491, -63.5881>, <-32.6104, 200.488, -63.5707> }
					triangle { <-33.08332, 201.0491, -63.5881>, <-33.653, 200.4518, -62.01278>, <-32.6104, 200.488, -63.5707> }
					triangle { <-33.653, 200.4518, -62.01278>, <-33.1466, 199.79, -62.1987>, <-32.6104, 200.488, -63.5707> }
					triangle { <-33.653, 200.4518, -62.01278>, <-34.4807, 199.1601, -59.7579>, <-33.1466, 199.79, -62.1987> }
					triangle { <-33.1466, 199.79, -62.1987>, <-34.4807, 199.1601, -59.7579>, <-33.9822, 198.5794, -59.9058> }
					triangle { <-34.4807, 199.1601, -59.7579>, <-33.7968, 198.7608, -58.9794>, <-33.9822, 198.5794, -59.9058> }
					triangle { <-33.7968, 198.7608, -58.9794>, <-33.6086, 198.2778, -59.187>, <-33.9822, 198.5794, -59.9058> }
					triangle { <-32.9326, 201.017, -64.7618>, <-32.6955, 201.7814, -63.8965>, <-33.4472, 201.9383, -63.4314> }
					triangle { <-32.988, 200.0757, -64.04615>, <-33.1932, 199.3425, -64.6528>, <-32.9326, 201.017, -64.7618> }
					triangle { <-32.9943, 199.3595, -63.6926>, <-33.3975, 198.6571, -62.8142>, <-33.8508, 198.7029, -64.385> }
					triangle { <-32.988, 200.0757, -64.04615>, <-32.9943, 199.3595, -63.6926>, <-33.1932, 199.3425, -64.6528> }
					triangle { <-32.9943, 199.3595, -63.6926>, <-33.8508, 198.7029, -64.385>, <-33.1932, 199.3425, -64.6528> }
					triangle { <-33.3975, 198.6571, -62.8142>, <-34.636, 198.2059, -63.4923>, <-33.8508, 198.7029, -64.385> }
					triangle { <-33.8217, 198.245, -62.1327>, <-35.1633, 197.7381, -62.5016>, <-34.636, 198.2059, -63.4923> }
					triangle { <-33.3975, 198.6571, -62.8142>, <-33.8217, 198.245, -62.1327>, <-34.636, 198.2059, -63.4923> }
					triangle { <-34.7262, 197.5882, -60.7126>, <-35.5677, 197.2125, -61.3625>, <-35.1633, 197.7381, -62.5016> }
					triangle { <-33.8217, 198.245, -62.1327>, <-34.7262, 197.5882, -60.7126>, <-35.1633, 197.7381, -62.5016> }
					triangle { <-33.6028, 196.995, -59.8551>, <-33.4235, 196.6807, -60.3169>, <-35.5677, 197.2125, -61.3625> }
					triangle { <-34.7262, 197.5882, -60.7126>, <-33.6028, 196.995, -59.8551>, <-35.5677, 197.2125, -61.3625> }
					triangle { <-33.5042, 197.4022, -59.5327>, <-33.6028, 196.995, -59.8551>, <-34.7262, 197.5882, -60.7126> }
					triangle { <-33.526, 199.1539, -62.6234>, <-32.9943, 199.3595, -63.6926>, <-32.988, 200.0757, -64.04615> }
					triangle { <-33.526, 199.1539, -62.6234>, <-33.3975, 198.6571, -62.8142>, <-32.9943, 199.3595, -63.6926> }
					triangle { <-33.526, 199.1539, -62.6234>, <-33.8217, 198.245, -62.1327>, <-33.3975, 198.6571, -62.8142> }
					triangle { <-33.526, 199.1539, -62.6234>, <-34.3776, 198.1055, -60.2541>, <-33.8217, 198.245, -62.1327> }
					triangle { <-34.3776, 198.1055, -60.2541>, <-34.7262, 197.5882, -60.7126>, <-33.8217, 198.245, -62.1327> }
					triangle { <-34.3776, 198.1055, -60.2541>, <-33.5042, 197.4022, -59.5327>, <-34.7262, 197.5882, -60.7126> }
					triangle { <-34.3776, 198.1055, -60.2541>, <-33.5479, 197.8483, -59.3228>, <-33.5042, 197.4022, -59.5327> }
					triangle { <-32.6104, 200.488, -63.5707>, <-32.988, 200.0757, -64.04615>, <-32.9326, 201.017, -64.7618> }
					triangle { <-32.6104, 200.488, -63.5707>, <-33.526, 199.1539, -62.6234>, <-32.988, 200.0757, -64.04615> }
					triangle { <-32.6104, 200.488, -63.5707>, <-33.1466, 199.79, -62.1987>, <-33.526, 199.1539, -62.6234> }
					triangle { <-33.1466, 199.79, -62.1987>, <-34.3776, 198.1055, -60.2541>, <-33.526, 199.1539, -62.6234> }
					triangle { <-33.9822, 198.5794, -59.9058>, <-34.3776, 198.1055, -60.2541>, <-33.1466, 199.79, -62.1987> }
					triangle { <-33.9822, 198.5794, -59.9058>, <-33.5479, 197.8483, -59.3228>, <-34.3776, 198.1055, -60.2541> }
					triangle { <-33.9822, 198.5794, -59.9058>, <-33.6086, 198.2778, -59.187>, <-33.5479, 197.8483, -59.3228> }
					triangle { <-33.1932, 199.3425, -64.6528>, <-32.513, 199.9156, -64.7744>, <-32.9326, 201.017, -64.7618> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-32.9326, 201.017, -64.7618>, <-34.6136, 200.8019, -64.6543>, <-33.8757, 200.9878, -64.04707> }
					triangle { <-35.2711, 200.1622, -64.3865>, <-35.3061, 200.6182, -62.8162>, <-34.5922, 201.0013, -63.6943> }
					triangle { <-34.6136, 200.8019, -64.6543>, <-34.5922, 201.0013, -63.6943>, <-33.8757, 200.9878, -64.04707> }
					triangle { <-34.6136, 200.8019, -64.6543>, <-35.2711, 200.1622, -64.3865>, <-34.5922, 201.0013, -63.6943> }
					triangle { <-35.2711, 200.1622, -64.3865>, <-35.79, 199.3917, -63.4935>, <-35.3061, 200.6182, -62.8162> }
					triangle { <-35.79, 199.3917, -63.4935>, <-36.273, 198.8783, -62.5028>, <-35.7302, 200.2061, -62.1347> }
					triangle { <-35.79, 199.3917, -63.4935>, <-35.7302, 200.2061, -62.1347>, <-35.3061, 200.6182, -62.8162> }
					triangle { <-36.273, 198.8783, -62.5028>, <-36.8105, 198.4895, -61.3638>, <-36.4128, 199.3212, -60.7144> }
					triangle { <-36.273, 198.8783, -62.5028>, <-36.4128, 199.3212, -60.7144>, <-35.7302, 200.2061, -62.1347> }
					triangle { <-36.8105, 198.4895, -61.3638>, <-37.4432, 200.8497, -60.3571>, <-37.1395, 200.524, -60.02629> }
					triangle { <-36.8105, 198.4895, -61.3638>, <-37.1395, 200.524, -60.02629>, <-36.4128, 199.3212, -60.7144> }
					triangle { <-36.4128, 199.3212, -60.7144>, <-37.1395, 200.524, -60.02629>, <-36.6528, 200.4207, -59.7056> }
					triangle { <-33.8757, 200.9878, -64.04707>, <-34.5922, 201.0013, -63.6943>, <-34.8132, 200.4765, -62.6248> }
					triangle { <-34.5922, 201.0013, -63.6943>, <-35.3061, 200.6182, -62.8162>, <-34.8132, 200.4765, -62.6248> }
					triangle { <-35.3061, 200.6182, -62.8162>, <-35.7302, 200.2061, -62.1347>, <-34.8132, 200.4765, -62.6248> }
					triangle { <-35.7302, 200.2061, -62.1347>, <-35.8867, 199.6561, -60.2557>, <-34.8132, 200.4765, -62.6248> }
					triangle { <-35.7302, 200.2061, -62.1347>, <-36.4128, 199.3212, -60.7144>, <-35.8867, 199.6561, -60.2557> }
					triangle { <-36.4128, 199.3212, -60.7144>, <-36.6528, 200.4207, -59.7056>, <-35.8867, 199.6561, -60.2557> }
					triangle { <-36.6528, 200.4207, -59.7056>, <-36.1064, 200.3312, -59.4018>, <-35.8867, 199.6561, -60.2557> }
					triangle { <-32.9326, 201.017, -64.7618>, <-33.8757, 200.9878, -64.04707>, <-33.4538, 201.3546, -63.5715> }
					triangle { <-33.8757, 200.9878, -64.04707>, <-34.8132, 200.4765, -62.6248>, <-33.4538, 201.3546, -63.5715> }
					triangle { <-34.8132, 200.4765, -62.6248>, <-34.1674, 200.839, -62.1998>, <-33.4538, 201.3546, -63.5715> }
					triangle { <-34.8132, 200.4765, -62.6248>, <-35.8867, 199.6561, -60.2557>, <-34.1674, 200.839, -62.1998> }
					triangle { <-34.1674, 200.839, -62.1998>, <-35.8867, 199.6561, -60.2557>, <-35.3218, 200.0287, -59.869> }
					triangle { <-35.8867, 199.6561, -60.2557>, <-36.1064, 200.3312, -59.4018>, <-35.3218, 200.0287, -59.869> }
					triangle { <-36.1064, 200.3312, -59.4018>, <-35.6139, 200.4112, -59.1509>, <-35.3218, 200.0287, -59.869> }
					triangle { <-32.9326, 201.017, -64.7618>, <-34.02215, 201.4662, -64.7759>, <-34.6136, 200.8019, -64.6543> }
					triangle { <-32.9057, 200.8667, -63.5879>, <-32.02692, 200.4789, -63.4299>, <-32.9326, 201.017, -64.7618> }
					triangle { <-32.733, 200.7692, -62.8142>, <-33.04282, 200.3355, -61.7449>, <-31.9569, 199.7484, -62.8178> }
					triangle { <-32.9057, 200.8667, -63.5879>, <-32.733, 200.7692, -62.8142>, <-32.02692, 200.4789, -63.4299> }
					triangle { <-32.733, 200.7692, -62.8142>, <-31.9569, 199.7484, -62.8178>, <-32.02692, 200.4789, -63.4299> }
					triangle { <-33.04282, 200.3355, -61.7449>, <-32.4758, 198.9778, -61.9248>, <-31.9569, 199.7484, -62.8178> }
					triangle { <-33.386, 199.9134, -61.02519>, <-33.03963, 198.4745, -60.9723>, <-32.4758, 198.9778, -61.9248> }
					triangle { <-33.04282, 200.3355, -61.7449>, <-33.386, 199.9134, -61.02519>, <-32.4758, 198.9778, -61.9248> }
					triangle { <-34.2303, 199.0487, -59.6813>, <-33.658, 198.0958, -59.8716>, <-33.03963, 198.4745, -60.9723> }
					triangle { <-33.386, 199.9134, -61.02519>, <-34.2303, 199.0487, -59.6813>, <-33.03963, 198.4745, -60.9723> }
					triangle { <-34.3086, 200.128, -58.596>, <-33.7284, 200.2043, -58.6375>, <-33.658, 198.0958, -59.8716> }
					triangle { <-34.2303, 199.0487, -59.6813>, <-34.3086, 200.128, -58.596>, <-33.658, 198.0958, -59.8716> }
					triangle { <-34.7885, 200.3269, -58.6941>, <-34.3086, 200.128, -58.596>, <-34.2303, 199.0487, -59.6813> }
					triangle { <-33.5198, 200.315, -62.01264>, <-32.733, 200.7692, -62.8142>, <-32.9057, 200.8667, -63.5879> }
					triangle { <-33.5198, 200.315, -62.01264>, <-33.04282, 200.3355, -61.7449>, <-32.733, 200.7692, -62.8142> }
					triangle { <-33.5198, 200.315, -62.01264>, <-33.386, 199.9134, -61.02519>, <-33.04282, 200.3355, -61.7449> }
					triangle { <-33.5198, 200.315, -62.01264>, <-34.8358, 199.5249, -59.7583>, <-33.386, 199.9134, -61.02519> }
					triangle { <-34.8358, 199.5249, -59.7583>, <-34.2303, 199.0487, -59.6813>, <-33.386, 199.9134, -61.02519> }
					triangle { <-34.8358, 199.5249, -59.7583>, <-34.7885, 200.3269, -58.6941>, <-34.2303, 199.0487, -59.6813> }
					triangle { <-34.8358, 199.5249, -59.7583>, <-35.2331, 200.3824, -58.9046>, <-34.7885, 200.3269, -58.6941> }
					triangle { <-33.4538, 201.3546, -63.5715>, <-32.9057, 200.8667, -63.5879>, <-32.9326, 201.017, -64.7618> }
					triangle { <-33.4538, 201.3546, -63.5715>, <-33.5198, 200.315, -62.01264>, <-32.9057, 200.8667, -63.5879> }
					triangle { <-33.4538, 201.3546, -63.5715>, <-34.1674, 200.839, -62.1998>, <-33.5198, 200.315, -62.01264> }
					triangle { <-34.1674, 200.839, -62.1998>, <-34.8358, 199.5249, -59.7583>, <-33.5198, 200.315, -62.01264> }
					triangle { <-35.3218, 200.0287, -59.869>, <-34.8358, 199.5249, -59.7583>, <-34.1674, 200.839, -62.1998> }
					triangle { <-35.3218, 200.0287, -59.869>, <-35.2331, 200.3824, -58.9046>, <-34.8358, 199.5249, -59.7583> }
					triangle { <-35.3218, 200.0287, -59.869>, <-35.6139, 200.4112, -59.1509>, <-35.2331, 200.3824, -58.9046> }
					triangle { <-32.02692, 200.4789, -63.4299>, <-32.1629, 201.2341, -63.8959>, <-32.9326, 201.017, -64.7618> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-32.9326, 201.017, -64.7618>, <-33.1932, 199.3425, -64.6528>, <-33.6347, 200.1564, -64.3522> }
					triangle { <-33.1233, 198.612, -64.04072>, <-34.6101, 198.8085, -63.3881>, <-34.04516, 199.4908, -64.19> }
					triangle { <-33.1932, 199.3425, -64.6528>, <-34.04516, 199.4908, -64.19>, <-33.6347, 200.1564, -64.3522> }
					triangle { <-33.1932, 199.3425, -64.6528>, <-33.1233, 198.612, -64.04072>, <-34.04516, 199.4908, -64.19> }
					triangle { <-33.1233, 198.612, -64.04072>, <-33.4235, 198.0545, -62.9184>, <-34.6101, 198.8085, -63.3881> }
					triangle { <-33.4235, 198.0545, -62.9184>, <-33.9508, 197.5867, -61.9277>, <-34.9533, 198.3864, -62.6684> }
					triangle { <-33.4235, 198.0545, -62.9184>, <-34.9533, 198.3864, -62.6684>, <-34.6101, 198.8085, -63.3881> }
					triangle { <-33.9508, 197.5867, -61.9277>, <-34.6785, 197.1015, -60.9416>, <-35.6153, 197.6992, -61.1335> }
					triangle { <-33.9508, 197.5867, -61.9277>, <-35.6153, 197.6992, -61.1335>, <-34.9533, 198.3864, -62.6684> }
					triangle { <-34.6785, 197.1015, -60.9416>, <-37.02584, 196.9915, -62.151>, <-37.02015, 197.2639, -61.6677> }
					triangle { <-34.6785, 197.1015, -60.9416>, <-37.02015, 197.2639, -61.6677>, <-35.6153, 197.6992, -61.1335> }
					triangle { <-35.6153, 197.6992, -61.1335>, <-37.02015, 197.2639, -61.6677>, <-37.1105, 197.7536, -61.3477> }
					triangle { <-33.6347, 200.1564, -64.3522>, <-34.04516, 199.4908, -64.19>, <-34.5769, 199.2851, -63.1208> }
					triangle { <-34.04516, 199.4908, -64.19>, <-34.6101, 198.8085, -63.3881>, <-34.5769, 199.2851, -63.1208> }
					triangle { <-34.6101, 198.8085, -63.3881>, <-34.9533, 198.3864, -62.6684>, <-34.5769, 199.2851, -63.1208> }
					triangle { <-34.9533, 198.3864, -62.6684>, <-36.07513, 198.3175, -61.05767>, <-34.5769, 199.2851, -63.1208> }
					triangle { <-34.9533, 198.3864, -62.6684>, <-35.6153, 197.6992, -61.1335>, <-36.07513, 198.3175, -61.05767> }
					triangle { <-35.6153, 197.6992, -61.1335>, <-37.1105, 197.7536, -61.3477>, <-36.07513, 198.3175, -61.05767> }
					triangle { <-37.1105, 197.7536, -61.3477>, <-37.1854, 198.3026, -61.04456>, <-36.07513, 198.3175, -61.05767> }
					triangle { <-32.9326, 201.017, -64.7618>, <-33.6347, 200.1564, -64.3522>, <-34.1463, 200.6798, -64.2976> }
					triangle { <-33.6347, 200.1564, -64.3522>, <-34.5769, 199.2851, -63.1208>, <-34.1463, 200.6798, -64.2976> }
					triangle { <-34.5769, 199.2851, -63.1208>, <-35.0058, 200.0222, -63.0788>, <-34.1463, 200.6798, -64.2976> }
					triangle { <-34.5769, 199.2851, -63.1208>, <-36.07513, 198.3175, -61.05767>, <-35.0058, 200.0222, -63.0788> }
					triangle { <-35.0058, 200.0222, -63.0788>, <-36.07513, 198.3175, -61.05767>, <-36.496, 198.9735, -61.05376> }
					triangle { <-36.07513, 198.3175, -61.05767>, <-37.1854, 198.3026, -61.04456>, <-36.496, 198.9735, -61.05376> }
					triangle { <-37.1854, 198.3026, -61.04456>, <-37.3349, 198.8232, -60.9089>, <-36.496, 198.9735, -61.05376> }
					triangle { <-32.9326, 201.017, -64.7618>, <-33.4022, 200.0267, -65.1952>, <-33.1932, 199.3425, -64.6528> }
					triangle { <-33.7299, 201.1299, -63.8942>, <-33.4472, 201.9383, -63.4314>, <-32.9326, 201.017, -64.7618> }
					triangle { <-34.2277, 201.3565, -63.3121>, <-34.8323, 201.0798, -62.3194>, <-33.4487, 201.9378, -62.4757> }
					triangle { <-33.7299, 201.1299, -63.8942>, <-34.2277, 201.3565, -63.3121>, <-33.4472, 201.9383, -63.4314> }
					triangle { <-34.2277, 201.3565, -63.3121>, <-33.4487, 201.9378, -62.4757>, <-33.4472, 201.9383, -63.4314> }
					triangle { <-34.8323, 201.0798, -62.3194>, <-33.7489, 201.3804, -61.3534>, <-33.4487, 201.9378, -62.4757> }
					triangle { <-35.1835, 200.7388, -61.5615>, <-34.2683, 200.8315, -60.401>, <-33.7489, 201.3804, -61.3534> }
					triangle { <-34.8323, 201.0798, -62.3194>, <-35.1835, 200.7388, -61.5615>, <-33.7489, 201.3804, -61.3534> }
					triangle { <-35.8296, 199.8894, -60.1029>, <-34.9881, 200.2651, -59.453>, <-34.2683, 200.8315, -60.401> }
					triangle { <-35.1835, 200.7388, -61.5615>, <-35.8296, 199.8894, -60.1029>, <-34.2683, 200.8315, -60.401> }
					triangle { <-37.3406, 200.106, -60.2408>, <-37.2486, 200.6839, -60.2827>, <-34.9881, 200.2651, -59.453> }
					triangle { <-35.8296, 199.8894, -60.1029>, <-37.3406, 200.106, -60.2408>, <-34.9881, 200.2651, -59.453> }
					triangle { <-37.478, 199.6612, -60.4912>, <-37.3406, 200.106, -60.2408>, <-35.8296, 199.8894, -60.1029> }
					triangle { <-34.7038, 200.583, -62.5101>, <-34.2277, 201.3565, -63.3121>, <-33.7299, 201.1299, -63.8942> }
					triangle { <-34.7038, 200.583, -62.5101>, <-34.8323, 201.0798, -62.3194>, <-34.2277, 201.3565, -63.3121> }
					triangle { <-34.7038, 200.583, -62.5101>, <-35.1835, 200.7388, -61.5615>, <-34.8323, 201.0798, -62.3194> }
					triangle { <-34.7038, 200.583, -62.5101>, <-36.1783, 199.372, -60.5614>, <-35.1835, 200.7388, -61.5615> }
					triangle { <-36.1783, 199.372, -60.5614>, <-35.8296, 199.8894, -60.1029>, <-35.1835, 200.7388, -61.5615> }
					triangle { <-36.1783, 199.372, -60.5614>, <-37.478, 199.6612, -60.4912>, <-35.8296, 199.8894, -60.1029> }
					triangle { <-36.1783, 199.372, -60.5614>, <-37.4344, 199.215, -60.7012>, <-37.478, 199.6612, -60.4912> }
					triangle { <-34.1463, 200.6798, -64.2976>, <-33.7299, 201.1299, -63.8942>, <-32.9326, 201.017, -64.7618> }
					triangle { <-34.1463, 200.6798, -64.2976>, <-34.7038, 200.583, -62.5101>, <-33.7299, 201.1299, -63.8942> }
					triangle { <-34.1463, 200.6798, -64.2976>, <-35.0058, 200.0222, -63.0788>, <-34.7038, 200.583, -62.5101> }
					triangle { <-35.0058, 200.0222, -63.0788>, <-36.1783, 199.372, -60.5614>, <-34.7038, 200.583, -62.5101> }
					triangle { <-36.496, 198.9735, -61.05376>, <-36.1783, 199.372, -60.5614>, <-35.0058, 200.0222, -63.0788> }
					triangle { <-36.496, 198.9735, -61.05376>, <-37.4344, 199.215, -60.7012>, <-36.1783, 199.372, -60.5614> }
					triangle { <-36.496, 198.9735, -61.05376>, <-37.3349, 198.8232, -60.9089>, <-37.4344, 199.215, -60.7012> }
					triangle { <-33.4472, 201.9383, -63.4314>, <-33.5847, 201.8924, -64.3174>, <-32.9326, 201.017, -64.7618> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-31.9048, 200.6989, -65.4123>, <-32.07027, 201.6169, -65.7728>, 0.55 }
			cylinder { <-32.07027, 201.6169, -65.7728>, <-32.2623, 202.5381, -66.1113>, 0.55 }
			cylinder { <-32.2623, 202.5381, -66.1113>, <-32.4808, 203.4613, -66.4274>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-32.4808, 203.4613, -66.4274>, <-32.2466, 203.8891, -66.5377>, 0.55 }
				cylinder { <-32.2466, 203.8891, -66.5377>, <-31.7827, 204.0753, -66.5466>, 0.55 }
				cylinder { <-31.7827, 204.0753, -66.5466>, <-31.3143, 203.9295, -66.4499>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.8323, 202.4581, -67.1471>, <-30.6503, 202.9568, -66.3311> }
					triangle { <-30.09793, 202.0503, -67.6027>, <-29.3133, 201.5772, -66.2478>, <-30.3038, 202.2375, -66.3509> }
					triangle { <-30.8323, 202.4581, -67.1471>, <-30.3038, 202.2375, -66.3509>, <-30.6503, 202.9568, -66.3311> }
					triangle { <-30.8323, 202.4581, -67.1471>, <-30.09793, 202.0503, -67.6027>, <-30.3038, 202.2375, -66.3509> }
					triangle { <-30.09793, 202.0503, -67.6027>, <-28.8561, 201.7095, -67.6516>, <-29.3133, 201.5772, -66.2478> }
					triangle { <-28.8561, 201.7095, -67.6516>, <-27.7312, 201.289, -67.462>, <-28.4843, 201.2261, -66.1884> }
					triangle { <-28.8561, 201.7095, -67.6516>, <-28.4843, 201.2261, -66.1884>, <-29.3133, 201.5772, -66.2478> }
					triangle { <-27.7312, 201.289, -67.462>, <-26.5813, 200.7467, -67.1141>, <-26.769, 200.6875, -66.00374> }
					triangle { <-27.7312, 201.289, -67.462>, <-26.769, 200.6875, -66.00374>, <-28.4843, 201.2261, -66.1884> }
					triangle { <-26.5813, 200.7467, -67.1141>, <-27.4297, 199.1172, -65.2143>, <-27.0173, 199.4583, -65.06806> }
					triangle { <-26.5813, 200.7467, -67.1141>, <-27.0173, 199.4583, -65.06806>, <-26.769, 200.6875, -66.00374> }
					triangle { <-26.769, 200.6875, -66.00374>, <-27.0173, 199.4583, -65.06806>, <-26.7952, 199.8851, -64.7232> }
					triangle { <-30.6503, 202.9568, -66.3311>, <-30.3038, 202.2375, -66.3509>, <-29.1557, 202.0464, -66.01388> }
					triangle { <-30.3038, 202.2375, -66.3509>, <-29.3133, 201.5772, -66.2478>, <-29.1557, 202.0464, -66.01388> }
					triangle { <-29.3133, 201.5772, -66.2478>, <-28.4843, 201.2261, -66.1884>, <-29.1557, 202.0464, -66.01388> }
					triangle { <-28.4843, 201.2261, -66.1884>, <-26.7626, 200.9634, -65.2803>, <-29.1557, 202.0464, -66.01388> }
					triangle { <-28.4843, 201.2261, -66.1884>, <-26.769, 200.6875, -66.00374>, <-26.7626, 200.9634, -65.2803> }
					triangle { <-26.769, 200.6875, -66.00374>, <-26.7952, 199.8851, -64.7232>, <-26.7626, 200.9634, -65.2803> }
					triangle { <-26.7952, 199.8851, -64.7232>, <-26.6038, 200.3642, -64.359>, <-26.7626, 200.9634, -65.2803> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.6503, 202.9568, -66.3311>, <-30.6385, 203.1229, -65.6163> }
					triangle { <-30.6503, 202.9568, -66.3311>, <-29.1557, 202.0464, -66.01388>, <-30.6385, 203.1229, -65.6163> }
					triangle { <-29.1557, 202.0464, -66.01388>, <-29.2104, 202.4269, -65.2515>, <-30.6385, 203.1229, -65.6163> }
					triangle { <-29.1557, 202.0464, -66.01388>, <-26.7626, 200.9634, -65.2803>, <-29.2104, 202.4269, -65.2515> }
					triangle { <-29.2104, 202.4269, -65.2515>, <-26.7626, 200.9634, -65.2803>, <-26.8388, 201.273, -64.5691> }
					triangle { <-26.7626, 200.9634, -65.2803>, <-26.6038, 200.3642, -64.359>, <-26.8388, 201.273, -64.5691> }
					triangle { <-26.6038, 200.3642, -64.359>, <-26.5594, 200.7402, -63.9484>, <-26.8388, 201.273, -64.5691> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-31.4717, 202.7712, -66.6002>, <-30.8323, 202.4581, -67.1471> }
					triangle { <-30.3928, 203.8071, -65.717>, <-30.1456, 204.7255, -65.5096>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-29.8102, 203.8672, -65.174>, <-28.7124, 203.5612, -64.815>, <-29.218, 204.9554, -65.5046> }
					triangle { <-30.3928, 203.8071, -65.717>, <-29.8102, 203.8672, -65.174>, <-30.1456, 204.7255, -65.5096> }
					triangle { <-29.8102, 203.8672, -65.174>, <-29.218, 204.9554, -65.5046>, <-30.1456, 204.7255, -65.5096> }
					triangle { <-28.7124, 203.5612, -64.815>, <-27.9763, 204.6147, -65.5536>, <-29.218, 204.9554, -65.5046> }
					triangle { <-27.8619, 203.281, -64.7044>, <-26.8728, 204.1233, -65.4151>, <-27.9763, 204.6147, -65.5536> }
					triangle { <-28.7124, 203.5612, -64.815>, <-27.8619, 203.281, -64.7044>, <-27.9763, 204.6147, -65.5536> }
					triangle { <-26.1896, 202.6007, -64.622>, <-25.7443, 203.5101, -65.1183>, <-26.8728, 204.1233, -65.4151> }
					triangle { <-27.8619, 203.281, -64.7044>, <-26.1896, 202.6007, -64.622>, <-26.8728, 204.1233, -65.4151> }
					triangle { <-26.1729, 201.9399, -63.2392>, <-26.3437, 202.4479, -63.00037>, <-25.7443, 203.5101, -65.1183> }
					triangle { <-26.1896, 202.6007, -64.622>, <-26.1729, 201.9399, -63.2392>, <-25.7443, 203.5101, -65.1183> }
					triangle { <-26.3072, 201.4453, -63.3685>, <-26.1729, 201.9399, -63.2392>, <-26.1896, 202.6007, -64.622> }
					triangle { <-28.8124, 203.1801, -65.1951>, <-29.8102, 203.8672, -65.174>, <-30.3928, 203.8071, -65.717> }
					triangle { <-28.8124, 203.1801, -65.1951>, <-28.7124, 203.5612, -64.815>, <-29.8102, 203.8672, -65.174> }
					triangle { <-28.8124, 203.1801, -65.1951>, <-27.8619, 203.281, -64.7044>, <-28.7124, 203.5612, -64.815> }
					triangle { <-28.8124, 203.1801, -65.1951>, <-26.4837, 201.8845, -64.6151>, <-27.8619, 203.281, -64.7044> }
					triangle { <-26.4837, 201.8845, -64.6151>, <-26.1896, 202.6007, -64.622>, <-27.8619, 203.281, -64.7044> }
					triangle { <-26.4837, 201.8845, -64.6151>, <-26.3072, 201.4453, -63.3685>, <-26.1896, 202.6007, -64.622> }
					triangle { <-26.4837, 201.8845, -64.6151>, <-26.4252, 201.0555, -63.65>, <-26.3072, 201.4453, -63.3685> }
					triangle { <-30.6385, 203.1229, -65.6163>, <-30.3928, 203.8071, -65.717>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-30.6385, 203.1229, -65.6163>, <-28.8124, 203.1801, -65.1951>, <-30.3928, 203.8071, -65.717> }
					triangle { <-30.6385, 203.1229, -65.6163>, <-29.2104, 202.4269, -65.2515>, <-28.8124, 203.1801, -65.1951> }
					triangle { <-29.2104, 202.4269, -65.2515>, <-26.4837, 201.8845, -64.6151>, <-28.8124, 203.1801, -65.1951> }
					triangle { <-26.8388, 201.273, -64.5691>, <-26.4837, 201.8845, -64.6151>, <-29.2104, 202.4269, -65.2515> }
					triangle { <-26.8388, 201.273, -64.5691>, <-26.4252, 201.0555, -63.65>, <-26.4837, 201.8845, -64.6151> }
					triangle { <-26.8388, 201.273, -64.5691>, <-26.5594, 200.7402, -63.9484>, <-26.4252, 201.0555, -63.65> }
					triangle { <-30.1456, 204.7255, -65.5096>, <-30.9781, 204.4009, -65.4232>, <-31.3143, 203.9295, -66.4499> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.02865, 204.2963, -67.4968>, <-30.3196, 203.5388, -66.959> }
					triangle { <-29.101, 204.5262, -67.4919>, <-28.5552, 202.9844, -67.4854>, <-29.6786, 203.3843, -67.4097> }
					triangle { <-30.02865, 204.2963, -67.4968>, <-29.6786, 203.3843, -67.4097>, <-30.3196, 203.5388, -66.959> }
					triangle { <-30.02865, 204.2963, -67.4968>, <-29.101, 204.5262, -67.4919>, <-29.6786, 203.3843, -67.4097> }
					triangle { <-29.101, 204.5262, -67.4919>, <-27.8812, 204.2659, -67.1682>, <-28.5552, 202.9844, -67.4854> }
					triangle { <-27.8812, 204.2659, -67.1682>, <-26.7814, 203.788, -66.9676>, <-27.7047, 202.7041, -67.3748> }
					triangle { <-27.8812, 204.2659, -67.1682>, <-27.7047, 202.7041, -67.3748>, <-28.5552, 202.9844, -67.4854> }
					triangle { <-26.7814, 203.788, -66.9676>, <-25.642, 203.1345, -66.8572>, <-26.05071, 202.0909, -66.9819> }
					triangle { <-26.7814, 203.788, -66.9676>, <-26.05071, 202.0909, -66.9819>, <-27.7047, 202.7041, -67.3748> }
					triangle { <-25.642, 203.1345, -66.8572>, <-26.05235, 201.244, -68.6577>, <-25.9056, 201.0643, -68.1537> }
					triangle { <-25.642, 203.1345, -66.8572>, <-25.9056, 201.0643, -68.1537>, <-26.05071, 202.0909, -66.9819> }
					triangle { <-26.05071, 202.0909, -66.9819>, <-25.9056, 201.0643, -68.1537>, <-26.01017, 200.7443, -67.6669> }
					triangle { <-30.3196, 203.5388, -66.959>, <-29.6786, 203.3843, -67.4097>, <-28.7063, 202.7911, -66.996> }
					triangle { <-29.6786, 203.3843, -67.4097>, <-28.5552, 202.9844, -67.4854>, <-28.7063, 202.7911, -66.996> }
					triangle { <-28.5552, 202.9844, -67.4854>, <-27.7047, 202.7041, -67.3748>, <-28.7063, 202.7911, -66.996> }
					triangle { <-27.7047, 202.7041, -67.3748>, <-26.3594, 201.4284, -66.7266>, <-28.7063, 202.7911, -66.996> }
					triangle { <-27.7047, 202.7041, -67.3748>, <-26.05071, 202.0909, -66.9819>, <-26.3594, 201.4284, -66.7266> }
					triangle { <-26.05071, 202.0909, -66.9819>, <-26.01017, 200.7443, -67.6669>, <-26.3594, 201.4284, -66.7266> }
					triangle { <-26.01017, 200.7443, -67.6669>, <-26.1703, 200.4192, -67.1496>, <-26.3594, 201.4284, -66.7266> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.3196, 203.5388, -66.959>, <-30.569, 202.868, -66.7962> }
					triangle { <-30.3196, 203.5388, -66.959>, <-28.7063, 202.7911, -66.996>, <-30.569, 202.868, -66.7962> }
					triangle { <-28.7063, 202.7911, -66.996>, <-29.1264, 202.1184, -66.6798>, <-30.569, 202.868, -66.7962> }
					triangle { <-28.7063, 202.7911, -66.996>, <-26.3594, 201.4284, -66.7266>, <-29.1264, 202.1184, -66.6798> }
					triangle { <-29.1264, 202.1184, -66.6798>, <-26.3594, 201.4284, -66.7266>, <-26.7506, 200.7997, -66.4834> }
					triangle { <-26.3594, 201.4284, -66.7266>, <-26.1703, 200.4192, -67.1496>, <-26.7506, 200.7997, -66.4834> }
					triangle { <-26.1703, 200.4192, -67.1496>, <-26.4164, 200.0656, -66.7942>, <-26.7506, 200.7997, -66.4834> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.8538, 203.9448, -67.5347>, <-30.02865, 204.2963, -67.4968> }
					triangle { <-30.6649, 203.0104, -66.08271>, <-30.9493, 202.8873, -65.1598>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-30.3403, 202.3716, -65.7299>, <-29.3608, 201.7516, -65.4405>, <-30.2807, 202.721, -64.4976> }
					triangle { <-30.6649, 203.0104, -66.08271>, <-30.3403, 202.3716, -65.7299>, <-30.9493, 202.8873, -65.1598> }
					triangle { <-30.3403, 202.3716, -65.7299>, <-30.2807, 202.721, -64.4976>, <-30.9493, 202.8873, -65.1598> }
					triangle { <-29.3608, 201.7516, -65.4405>, <-29.06089, 202.4608, -64.1739>, <-30.2807, 202.721, -64.4976> }
					triangle { <-28.5391, 201.4273, -65.2569>, <-27.9323, 202.0268, -64.04639>, <-29.06089, 202.4608, -64.1739> }
					triangle { <-29.3608, 201.7516, -65.4405>, <-28.5391, 201.4273, -65.2569>, <-29.06089, 202.4608, -64.1739> }
					triangle { <-26.8275, 200.9021, -65.0101>, <-26.7641, 201.4174, -64.00901>, <-27.9323, 202.0268, -64.04639> }
					triangle { <-28.5391, 201.4273, -65.2569>, <-26.8275, 200.9021, -65.0101>, <-27.9323, 202.0268, -64.04639> }
					triangle { <-26.8445, 199.4675, -65.549>, <-27.2916, 199.3435, -65.1898>, <-26.7641, 201.4174, -64.00901> }
					triangle { <-26.8275, 200.9021, -65.0101>, <-26.8445, 199.4675, -65.549>, <-26.7641, 201.4174, -64.00901> }
					triangle { <-26.6879, 199.551, -66.04694>, <-26.8445, 199.4675, -65.549>, <-26.8275, 200.9021, -65.0101> }
					triangle { <-29.1667, 202.0867, -65.8275>, <-30.3403, 202.3716, -65.7299>, <-30.6649, 203.0104, -66.08271> }
					triangle { <-29.1667, 202.0867, -65.8275>, <-29.3608, 201.7516, -65.4405>, <-30.3403, 202.3716, -65.7299> }
					triangle { <-29.1667, 202.0867, -65.8275>, <-28.5391, 201.4273, -65.2569>, <-29.3608, 201.7516, -65.4405> }
					triangle { <-29.1667, 202.0867, -65.8275>, <-26.7334, 200.8561, -65.7771>, <-28.5391, 201.4273, -65.2569> }
					triangle { <-26.7334, 200.8561, -65.7771>, <-26.8275, 200.9021, -65.0101>, <-28.5391, 201.4273, -65.2569> }
					triangle { <-26.7334, 200.8561, -65.7771>, <-26.6879, 199.551, -66.04694>, <-26.8275, 200.9021, -65.0101> }
					triangle { <-26.7334, 200.8561, -65.7771>, <-26.5297, 199.7932, -66.4486>, <-26.6879, 199.551, -66.04694> }
					triangle { <-30.569, 202.868, -66.7962>, <-30.6649, 203.0104, -66.08271>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-30.569, 202.868, -66.7962>, <-29.1667, 202.0867, -65.8275>, <-30.6649, 203.0104, -66.08271> }
					triangle { <-30.569, 202.868, -66.7962>, <-29.1264, 202.1184, -66.6798>, <-29.1667, 202.0867, -65.8275> }
					triangle { <-29.1264, 202.1184, -66.6798>, <-26.7334, 200.8561, -65.7771>, <-29.1667, 202.0867, -65.8275> }
					triangle { <-26.7506, 200.7997, -66.4834>, <-26.7334, 200.8561, -65.7771>, <-29.1264, 202.1184, -66.6798> }
					triangle { <-26.7506, 200.7997, -66.4834>, <-26.5297, 199.7932, -66.4486>, <-26.7334, 200.8561, -65.7771> }
					triangle { <-26.7506, 200.7997, -66.4834>, <-26.4164, 200.0656, -66.7942>, <-26.5297, 199.7932, -66.4486> }
					triangle { <-30.9493, 202.8873, -65.1598>, <-31.5156, 202.9322, -65.855>, <-31.3143, 203.9295, -66.4499> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.1456, 204.7255, -65.5096>, <-30.1626, 204.1593, -66.3013> }
					triangle { <-29.477, 204.5592, -64.8473>, <-28.2808, 204.2217, -65.9105>, <-29.4362, 204.4396, -66.1234> }
					triangle { <-30.1456, 204.7255, -65.5096>, <-29.4362, 204.4396, -66.1234>, <-30.1626, 204.1593, -66.3013> }
					triangle { <-30.1456, 204.7255, -65.5096>, <-29.477, 204.5592, -64.8473>, <-29.4362, 204.4396, -66.1234> }
					triangle { <-29.477, 204.5592, -64.8473>, <-28.4078, 203.9543, -64.4581>, <-28.2808, 204.2217, -65.9105> }
					triangle { <-28.4078, 203.9543, -64.4581>, <-27.3044, 203.4629, -64.3196>, <-27.4591, 203.8974, -65.7268> }
					triangle { <-28.4078, 203.9543, -64.4581>, <-27.4591, 203.8974, -65.7268>, <-28.2808, 204.2217, -65.9105> }
					triangle { <-27.3044, 203.4629, -64.3196>, <-26.06088, 203.0258, -64.315>, <-25.8731, 203.085, -65.4254> }
					triangle { <-27.3044, 203.4629, -64.3196>, <-25.8731, 203.085, -65.4254>, <-27.4591, 203.8974, -65.7268> }
					triangle { <-26.06088, 203.0258, -64.315>, <-25.04739, 204.5878, -66.1905>, <-24.9646, 204.0441, -66.2638> }
					triangle { <-26.06088, 203.0258, -64.315>, <-24.9646, 204.0441, -66.2638>, <-25.8731, 203.085, -65.4254> }
					triangle { <-25.8731, 203.085, -65.4254>, <-24.9646, 204.0441, -66.2638>, <-25.02159, 203.5497, -66.5843> }
					triangle { <-30.1626, 204.1593, -66.3013>, <-29.4362, 204.4396, -66.1234>, <-28.4383, 203.7525, -66.1445> }
					triangle { <-29.4362, 204.4396, -66.1234>, <-28.2808, 204.2217, -65.9105>, <-28.4383, 203.7525, -66.1445> }
					triangle { <-28.2808, 204.2217, -65.9105>, <-27.4591, 203.8974, -65.7268>, <-28.4383, 203.7525, -66.1445> }
					triangle { <-27.4591, 203.8974, -65.7268>, <-25.8795, 202.8091, -66.1487>, <-28.4383, 203.7525, -66.1445> }
					triangle { <-27.4591, 203.8974, -65.7268>, <-25.8731, 203.085, -65.4254>, <-25.8795, 202.8091, -66.1487> }
					triangle { <-25.8731, 203.085, -65.4254>, <-25.02159, 203.5497, -66.5843>, <-25.8795, 202.8091, -66.1487> }
					triangle { <-25.02159, 203.5497, -66.5843>, <-25.1305, 203.0368, -66.9364>, <-25.8795, 202.8091, -66.1487> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.1626, 204.1593, -66.3013>, <-30.09187, 203.9594, -67.00394> }
					triangle { <-30.1626, 204.1593, -66.3013>, <-28.4383, 203.7525, -66.1445>, <-30.09187, 203.9594, -67.00394> }
					triangle { <-28.4383, 203.7525, -66.1445>, <-28.5487, 203.4396, -66.9312>, <-30.09187, 203.9594, -67.00394> }
					triangle { <-28.4383, 203.7525, -66.1445>, <-25.8795, 202.8091, -66.1487>, <-28.5487, 203.4396, -66.9312> }
					triangle { <-28.5487, 203.4396, -66.9312>, <-25.8795, 202.8091, -66.1487>, <-25.9684, 202.567, -66.8843> }
					triangle { <-25.8795, 202.8091, -66.1487>, <-25.1305, 203.0368, -66.9364>, <-25.9684, 202.567, -66.8843> }
					triangle { <-25.1305, 203.0368, -66.9364>, <-25.2574, 202.6946, -67.3591>, <-25.9684, 202.567, -66.8843> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.6617, 204.8852, -66.2266>, <-30.1456, 204.7255, -65.5096> }
					triangle { <-30.4201, 203.309, -66.9153>, <-30.8323, 202.4581, -67.1471>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-29.9297, 202.8098, -67.3004>, <-28.8817, 202.2377, -67.3433>, <-30.3568, 201.654, -66.9454> }
					triangle { <-30.4201, 203.309, -66.9153>, <-29.9297, 202.8098, -67.3004>, <-30.8323, 202.4581, -67.1471> }
					triangle { <-29.9297, 202.8098, -67.3004>, <-30.3568, 201.654, -66.9454>, <-30.8323, 202.4581, -67.1471> }
					triangle { <-28.8817, 202.2377, -67.3433>, <-29.2877, 201.0491, -66.5562>, <-30.3568, 201.654, -66.9454> }
					triangle { <-28.08152, 201.8425, -67.2108>, <-28.1628, 200.6286, -66.3665>, <-29.2877, 201.0491, -66.5562> }
					triangle { <-28.8817, 202.2377, -67.3433>, <-28.08152, 201.8425, -67.2108>, <-29.2877, 201.0491, -66.5562> }
					triangle { <-26.4525, 201.1718, -66.807>, <-26.8978, 200.2624, -66.3107>, <-28.1628, 200.6286, -66.3665> }
					triangle { <-28.08152, 201.8425, -67.2108>, <-26.4525, 201.1718, -66.807>, <-28.1628, 200.6286, -66.3665> }
					triangle { <-25.6439, 201.4949, -68.06834>, <-26.05082, 201.2233, -68.3923>, <-26.8978, 200.2624, -66.3107> }
					triangle { <-26.4525, 201.1718, -66.807>, <-25.6439, 201.4949, -68.06834>, <-26.8978, 200.2624, -66.3107> }
					triangle { <-25.427, 201.9557, -67.9268>, <-25.6439, 201.4949, -68.06834>, <-26.4525, 201.1718, -66.807> }
					triangle { <-28.7817, 202.6188, -66.9632>, <-29.9297, 202.8098, -67.3004>, <-30.4201, 203.309, -66.9153> }
					triangle { <-28.7817, 202.6188, -66.9632>, <-28.8817, 202.2377, -67.3433>, <-29.9297, 202.8098, -67.3004> }
					triangle { <-28.7817, 202.6188, -66.9632>, <-28.08152, 201.8425, -67.2108>, <-28.8817, 202.2377, -67.3433> }
					triangle { <-28.7817, 202.6188, -66.9632>, <-26.1584, 201.888, -66.814>, <-28.08152, 201.8425, -67.2108> }
					triangle { <-26.1584, 201.888, -66.814>, <-26.4525, 201.1718, -66.807>, <-28.08152, 201.8425, -67.2108> }
					triangle { <-26.1584, 201.888, -66.814>, <-25.427, 201.9557, -67.9268>, <-26.4525, 201.1718, -66.807> }
					triangle { <-26.1584, 201.888, -66.814>, <-25.309, 202.3455, -67.6454>, <-25.427, 201.9557, -67.9268> }
					triangle { <-30.09187, 203.9594, -67.00394>, <-30.4201, 203.309, -66.9153>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-30.09187, 203.9594, -67.00394>, <-28.7817, 202.6188, -66.9632>, <-30.4201, 203.309, -66.9153> }
					triangle { <-30.09187, 203.9594, -67.00394>, <-28.5487, 203.4396, -66.9312>, <-28.7817, 202.6188, -66.9632> }
					triangle { <-28.5487, 203.4396, -66.9312>, <-26.1584, 201.888, -66.814>, <-28.7817, 202.6188, -66.9632> }
					triangle { <-25.9684, 202.567, -66.8843>, <-26.1584, 201.888, -66.814>, <-28.5487, 203.4396, -66.9312> }
					triangle { <-25.9684, 202.567, -66.8843>, <-25.309, 202.3455, -67.6454>, <-26.1584, 201.888, -66.814> }
					triangle { <-25.9684, 202.567, -66.8843>, <-25.2574, 202.6946, -67.3591>, <-25.309, 202.3455, -67.6454> }
					triangle { <-30.8323, 202.4581, -67.1471>, <-31.1552, 203.2555, -67.4036>, <-31.3143, 203.9295, -66.4499> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.9493, 202.8873, -65.1598>, <-30.4932, 203.5773, -65.6733> }
					triangle { <-30.4738, 202.0833, -64.9581>, <-29.03894, 202.8145, -64.6729>, <-30.0614, 203.2928, -65.06472> }
					triangle { <-30.9493, 202.8873, -65.1598>, <-30.0614, 203.2928, -65.06472>, <-30.4932, 203.5773, -65.6733> }
					triangle { <-30.9493, 202.8873, -65.1598>, <-30.4738, 202.0833, -64.9581>, <-30.0614, 203.2928, -65.06472> }
					triangle { <-30.4738, 202.0833, -64.9581>, <-29.3827, 201.3979, -64.9415>, <-29.03894, 202.8145, -64.6729> }
					triangle { <-29.3827, 201.3979, -64.9415>, <-28.2542, 200.964, -64.8139>, <-28.2387, 202.4193, -64.5405> }
					triangle { <-29.3827, 201.3979, -64.9415>, <-28.2387, 202.4193, -64.5405>, <-29.03894, 202.8145, -64.6729> }
					triangle { <-28.2542, 200.964, -64.8139>, <-27.00018, 200.638, -64.5719>, <-26.5914, 201.6816, -64.4472> }
					triangle { <-28.2542, 200.964, -64.8139>, <-26.5914, 201.6816, -64.4472>, <-28.2387, 202.4193, -64.5405> }
					triangle { <-27.00018, 200.638, -64.5719>, <-26.4247, 202.461, -62.7471>, <-26.07625, 202.4381, -63.1781> }
					triangle { <-27.00018, 200.638, -64.5719>, <-26.07625, 202.4381, -63.1781>, <-26.5914, 201.6816, -64.4472> }
					triangle { <-26.5914, 201.6816, -64.4472>, <-26.07625, 202.4381, -63.1781>, <-25.8067, 202.6905, -63.6407> }
					triangle { <-30.4932, 203.5773, -65.6733>, <-30.0614, 203.2928, -65.06472>, <-28.8877, 203.0078, -65.1623> }
					triangle { <-30.0614, 203.2928, -65.06472>, <-29.03894, 202.8145, -64.6729>, <-28.8877, 203.0078, -65.1623> }
					triangle { <-29.03894, 202.8145, -64.6729>, <-28.2387, 202.4193, -64.5405>, <-28.8877, 203.0078, -65.1623> }
					triangle { <-28.2387, 202.4193, -64.5405>, <-26.2827, 202.3441, -64.7025>, <-28.8877, 203.0078, -65.1623> }
					triangle { <-28.2387, 202.4193, -64.5405>, <-26.5914, 201.6816, -64.4472>, <-26.2827, 202.3441, -64.7025> }
					triangle { <-26.5914, 201.6816, -64.4472>, <-25.8067, 202.6905, -63.6407>, <-26.2827, 202.3441, -64.7025> }
					triangle { <-25.8067, 202.6905, -63.6407>, <-25.564, 202.9818, -64.1458>, <-26.2827, 202.3441, -64.7025> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-30.4932, 203.5773, -65.6733>, <-30.1613, 204.2143, -65.8239> }
					triangle { <-30.4932, 203.5773, -65.6733>, <-28.8877, 203.0078, -65.1623>, <-30.1613, 204.2143, -65.8239> }
					triangle { <-28.8877, 203.0078, -65.1623>, <-28.6328, 203.7481, -65.5028>, <-30.1613, 204.2143, -65.8239> }
					triangle { <-28.8877, 203.0078, -65.1623>, <-26.2827, 202.3441, -64.7025>, <-28.6328, 203.7481, -65.5028> }
					triangle { <-28.6328, 203.7481, -65.5028>, <-26.2827, 202.3441, -64.7025>, <-26.05662, 203.0403, -64.97> }
					triangle { <-26.2827, 202.3441, -64.7025>, <-25.564, 202.9818, -64.1458>, <-26.05662, 203.0403, -64.97> }
					triangle { <-25.564, 202.9818, -64.1458>, <-25.4004, 203.3691, -64.5133>, <-26.05662, 203.0403, -64.97> }
					triangle { <-31.3143, 203.9295, -66.4499>, <-31.2795, 203.7116, -65.2921>, <-30.9493, 202.8873, -65.1598> }
					triangle { <-30.148, 204.1056, -66.5497>, <-30.02865, 204.2963, -67.4968>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-29.3996, 204.3054, -66.7444>, <-28.2333, 204.0473, -66.7178>, <-29.2942, 203.8885, -67.9524> }
					triangle { <-30.148, 204.1056, -66.5497>, <-29.3996, 204.3054, -66.7444>, <-30.02865, 204.2963, -67.4968> }
					triangle { <-29.3996, 204.3054, -66.7444>, <-29.2942, 203.8885, -67.9524>, <-30.02865, 204.2963, -67.4968> }
					triangle { <-28.2333, 204.0473, -66.7178>, <-28.2031, 203.2031, -67.9358>, <-29.2942, 203.8885, -67.9524> }
					triangle { <-27.4043, 203.6962, -66.6584>, <-27.1033, 202.7251, -67.7352>, <-28.2031, 203.2031, -67.9358> }
					triangle { <-28.2333, 204.0473, -66.7178>, <-27.4043, 203.6962, -66.6584>, <-28.2031, 203.2031, -67.9358> }
					triangle { <-25.8146, 202.8704, -66.419>, <-25.878, 202.3551, -67.4201>, <-27.1033, 202.7251, -67.7352> }
					triangle { <-27.4043, 203.6962, -66.6584>, <-25.8146, 202.8704, -66.419>, <-27.1033, 202.7251, -67.7352> }
					triangle { <-24.9723, 203.9673, -65.7586>, <-25.1029, 204.3277, -66.2028>, <-25.878, 202.3551, -67.4201> }
					triangle { <-25.8146, 202.8704, -66.419>, <-24.9723, 203.9673, -65.7586>, <-25.878, 202.3551, -67.4201> }
					triangle { <-25.04637, 203.85, -65.2485>, <-24.9723, 203.9673, -65.7586>, <-25.8146, 202.8704, -66.419> }
					triangle { <-28.4274, 203.7123, -66.3308>, <-29.3996, 204.3054, -66.7444>, <-30.148, 204.1056, -66.5497> }
					triangle { <-28.4274, 203.7123, -66.3308>, <-28.2333, 204.0473, -66.7178>, <-29.3996, 204.3054, -66.7444> }
					triangle { <-28.4274, 203.7123, -66.3308>, <-27.4043, 203.6962, -66.6584>, <-28.2333, 204.0473, -66.7178> }
					triangle { <-28.4274, 203.7123, -66.3308>, <-25.9087, 202.9165, -65.6519>, <-27.4043, 203.6962, -66.6584> }
					triangle { <-25.9087, 202.9165, -65.6519>, <-25.8146, 202.8704, -66.419>, <-27.4043, 203.6962, -66.6584> }
					triangle { <-25.9087, 202.9165, -65.6519>, <-25.04637, 203.85, -65.2485>, <-25.8146, 202.8704, -66.419> }
					triangle { <-25.9087, 202.9165, -65.6519>, <-25.2046, 203.6078, -64.8468>, <-25.04637, 203.85, -65.2485> }
					triangle { <-30.1613, 204.2143, -65.8239>, <-30.148, 204.1056, -66.5497>, <-31.3143, 203.9295, -66.4499> }
					triangle { <-30.1613, 204.2143, -65.8239>, <-28.4274, 203.7123, -66.3308>, <-30.148, 204.1056, -66.5497> }
					triangle { <-30.1613, 204.2143, -65.8239>, <-28.6328, 203.7481, -65.5028>, <-28.4274, 203.7123, -66.3308> }
					triangle { <-28.6328, 203.7481, -65.5028>, <-25.9087, 202.9165, -65.6519>, <-28.4274, 203.7123, -66.3308> }
					triangle { <-26.05662, 203.0403, -64.97>, <-25.9087, 202.9165, -65.6519>, <-28.6328, 203.7481, -65.5028> }
					triangle { <-26.05662, 203.0403, -64.97>, <-25.2046, 203.6078, -64.8468>, <-25.9087, 202.9165, -65.6519> }
					triangle { <-26.05662, 203.0403, -64.97>, <-25.4004, 203.3691, -64.5133>, <-25.2046, 203.6078, -64.8468> }
					triangle { <-30.02865, 204.2963, -67.4968>, <-30.6178, 204.7243, -66.9718>, <-31.3143, 203.9295, -66.4499> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-32.4808, 203.4613, -66.4274>, <-32.6654, 204.3917, -66.744>, 0.55 }
			cylinder { <-32.6654, 204.3917, -66.744>, <-32.8158, 205.3283, -67.06059>, 0.55 }
			cylinder { <-32.8158, 205.3283, -67.06059>, <-32.9319, 206.2698, -67.3768>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-32.9319, 206.2698, -67.3768>, <-33.192, 206.5248, -67.7193>, 0.55 }
				cylinder { <-33.192, 206.5248, -67.7193>, <-33.528, 206.4403, -68.07986>, 0.55 }
				cylinder { <-33.528, 206.4403, -68.07986>, <-33.7765, 206.0572, -68.2834>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-33.7765, 206.0572, -68.2834>, <-34.4013, 205.2592, -67.3787>, <-34.05206, 205.1766, -68.06994> }
					triangle { <-35.06062, 204.8909, -67.2592>, <-34.7126, 203.799, -67.8904>, <-34.2363, 204.6236, -67.8082> }
					triangle { <-34.4013, 205.2592, -67.3787>, <-34.2363, 204.6236, -67.8082>, <-34.05206, 205.1766, -68.06994> }
					triangle { <-34.4013, 205.2592, -67.3787>, <-35.06062, 204.8909, -67.2592>, <-34.2363, 204.6236, -67.8082> }
					triangle { <-35.06062, 204.8909, -67.2592>, <-35.7737, 204.2068, -67.5528>, <-34.7126, 203.799, -67.8904> }
					triangle { <-35.7737, 204.2068, -67.5528>, <-36.2828, 203.4359, -67.8568>, <-35.1325, 203.2362, -68.05795> }
					triangle { <-35.7737, 204.2068, -67.5528>, <-35.1325, 203.2362, -68.05795>, <-34.7126, 203.799, -67.8904> }
					triangle { <-36.2828, 203.4359, -67.8568>, <-36.7121, 202.5255, -68.1713>, <-35.9715, 202.1589, -68.5332> }
					triangle { <-36.2828, 203.4359, -67.8568>, <-35.9715, 202.1589, -68.5332>, <-35.1325, 203.2362, -68.05795> }
					triangle { <-36.7121, 202.5255, -68.1713>, <-35.1052, 201.2199, -67.7433>, <-35.2625, 201.1981, -68.1577> }
					triangle { <-36.7121, 202.5255, -68.1713>, <-35.2625, 201.1981, -68.1577>, <-35.9715, 202.1589, -68.5332> }
					triangle { <-35.9715, 202.1589, -68.5332>, <-35.2625, 201.1981, -68.1577>, <-35.2025, 201.2305, -68.6263> }
					triangle { <-34.05206, 205.1766, -68.06994>, <-34.2363, 204.6236, -67.8082>, <-34.6809, 203.923, -68.3093> }
					triangle { <-34.2363, 204.6236, -67.8082>, <-34.7126, 203.799, -67.8904>, <-34.6809, 203.923, -68.3093> }
					triangle { <-34.7126, 203.799, -67.8904>, <-35.1325, 203.2362, -68.05795>, <-34.6809, 203.923, -68.3093> }
					triangle { <-35.1325, 203.2362, -68.05795>, <-35.5702, 202.0515, -68.9927>, <-34.6809, 203.923, -68.3093> }
					triangle { <-35.1325, 203.2362, -68.05795>, <-35.9715, 202.1589, -68.5332>, <-35.5702, 202.0515, -68.9927> }
					triangle { <-35.9715, 202.1589, -68.5332>, <-35.2025, 201.2305, -68.6263>, <-35.5702, 202.0515, -68.9927> }
					triangle { <-35.2025, 201.2305, -68.6263>, <-35.1157, 201.2988, -69.1193>, <-35.5702, 202.0515, -68.9927> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-34.05206, 205.1766, -68.06994>, <-33.6555, 205.0061, -68.4679> }
					triangle { <-34.05206, 205.1766, -68.06994>, <-34.6809, 203.923, -68.3093>, <-33.6555, 205.0061, -68.4679> }
					triangle { <-34.6809, 203.923, -68.3093>, <-34.2263, 203.8871, -68.8177>, <-33.6555, 205.0061, -68.4679> }
					triangle { <-34.6809, 203.923, -68.3093>, <-35.5702, 202.0515, -68.9927>, <-34.2263, 203.8871, -68.8177> }
					triangle { <-34.2263, 203.8871, -68.8177>, <-35.5702, 202.0515, -68.9927>, <-35.1306, 202.0018, -69.4321> }
					triangle { <-35.5702, 202.0515, -68.9927>, <-35.1157, 201.2988, -69.1193>, <-35.1306, 202.0018, -69.4321> }
					triangle { <-35.1157, 201.2988, -69.1193>, <-34.9172, 201.3494, -69.5164>, <-35.1306, 202.0018, -69.4321> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-33.7404, 205.5, -67.5235>, <-34.4013, 205.2592, -67.3787> }
					triangle { <-33.8705, 205.3429, -68.8981>, <-33.9173, 205.7027, -69.5872>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-33.8884, 204.9424, -69.3956>, <-34.2891, 204.187, -69.8229>, <-34.4404, 205.4592, -70.08882> }
					triangle { <-33.8705, 205.3429, -68.8981>, <-33.8884, 204.9424, -69.3956>, <-33.9173, 205.7027, -69.5872> }
					triangle { <-33.8884, 204.9424, -69.3956>, <-34.4404, 205.4592, -70.08882>, <-33.9173, 205.7027, -69.5872> }
					triangle { <-34.2891, 204.187, -69.8229>, <-35.1535, 204.7751, -70.3825>, <-34.4404, 205.4592, -70.08882> }
					triangle { <-34.6938, 203.6382, -70.05939>, <-35.6778, 203.9902, -70.6174>, <-35.1535, 204.7751, -70.3825> }
					triangle { <-34.2891, 204.187, -69.8229>, <-34.6938, 203.6382, -70.05939>, <-35.1535, 204.7751, -70.3825> }
					triangle { <-35.5631, 202.5331, -70.3967>, <-36.1222, 203.066, -70.8629>, <-35.6778, 203.9902, -70.6174> }
					triangle { <-34.6938, 203.6382, -70.05939>, <-35.5631, 202.5331, -70.3967>, <-35.6778, 203.9902, -70.6174> }
					triangle { <-34.7638, 201.6325, -70.6277>, <-34.5466, 201.9104, -70.9374>, <-36.1222, 203.066, -70.8629> }
					triangle { <-35.5631, 202.5331, -70.3967>, <-34.7638, 201.6325, -70.6277>, <-36.1222, 203.066, -70.8629> }
					triangle { <-34.748, 201.4457, -70.2486>, <-34.7638, 201.6325, -70.6277>, <-35.5631, 202.5331, -70.3967> }
					triangle { <-34.4389, 204.1448, -69.4135>, <-33.8884, 204.9424, -69.3956>, <-33.8705, 205.3429, -68.8981> }
					triangle { <-34.4389, 204.1448, -69.4135>, <-34.2891, 204.187, -69.8229>, <-33.8884, 204.9424, -69.3956> }
					triangle { <-34.4389, 204.1448, -69.4135>, <-34.6938, 203.6382, -70.05939>, <-34.2891, 204.187, -69.8229> }
					triangle { <-34.4389, 204.1448, -69.4135>, <-35.3735, 202.2317, -69.8899>, <-34.6938, 203.6382, -70.05939> }
					triangle { <-35.3735, 202.2317, -69.8899>, <-35.5631, 202.5331, -70.3967>, <-34.6938, 203.6382, -70.05939> }
					triangle { <-35.3735, 202.2317, -69.8899>, <-34.748, 201.4457, -70.2486>, <-35.5631, 202.5331, -70.3967> }
					triangle { <-35.3735, 202.2317, -69.8899>, <-34.8312, 201.3694, -69.869>, <-34.748, 201.4457, -70.2486> }
					triangle { <-33.6555, 205.0061, -68.4679>, <-33.8705, 205.3429, -68.8981>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-33.6555, 205.0061, -68.4679>, <-34.4389, 204.1448, -69.4135>, <-33.8705, 205.3429, -68.8981> }
					triangle { <-33.6555, 205.0061, -68.4679>, <-34.2263, 203.8871, -68.8177>, <-34.4389, 204.1448, -69.4135> }
					triangle { <-34.2263, 203.8871, -68.8177>, <-35.3735, 202.2317, -69.8899>, <-34.4389, 204.1448, -69.4135> }
					triangle { <-35.1306, 202.0018, -69.4321>, <-35.3735, 202.2317, -69.8899>, <-34.2263, 203.8871, -68.8177> }
					triangle { <-35.1306, 202.0018, -69.4321>, <-34.8312, 201.3694, -69.869>, <-35.3735, 202.2317, -69.8899> }
					triangle { <-35.1306, 202.0018, -69.4321>, <-34.9172, 201.3494, -69.5164>, <-34.8312, 201.3694, -69.869> }
					triangle { <-33.9173, 205.7027, -69.5872>, <-33.3925, 205.8188, -69.1109>, <-33.7765, 206.0572, -68.2834> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-33.7765, 206.0572, -68.2834>, <-35.1045, 206.135, -68.5588>, <-34.6125, 205.6131, -68.2553> }
					triangle { <-35.6277, 205.8916, -69.06039>, <-35.8845, 204.768, -68.4409>, <-35.2241, 205.4288, -68.2386> }
					triangle { <-35.1045, 206.135, -68.5588>, <-35.2241, 205.4288, -68.2386>, <-34.6125, 205.6131, -68.2553> }
					triangle { <-35.1045, 206.135, -68.5588>, <-35.6277, 205.8916, -69.06039>, <-35.2241, 205.4288, -68.2386> }
					triangle { <-35.6277, 205.8916, -69.06039>, <-36.1181, 205.1264, -69.5469>, <-35.8845, 204.768, -68.4409> }
					triangle { <-36.1181, 205.1264, -69.5469>, <-36.6053, 204.328, -69.814>, <-36.2892, 204.2191, -68.6774> }
					triangle { <-36.1181, 205.1264, -69.5469>, <-36.2892, 204.2191, -68.6774>, <-35.8845, 204.768, -68.4409> }
					triangle { <-36.6053, 204.328, -69.814>, <-37.161, 203.4443, -69.963>, <-36.9729, 203.0466, -69.1754> }
					triangle { <-36.6053, 204.328, -69.814>, <-36.9729, 203.0466, -69.1754>, <-36.2892, 204.2191, -68.6774> }
					triangle { <-37.161, 203.4443, -69.963>, <-37.9038, 203.1687, -68.00288>, <-37.693, 202.8192, -68.1771> }
					triangle { <-37.161, 203.4443, -69.963>, <-37.693, 202.8192, -68.1771>, <-36.9729, 203.0466, -69.1754> }
					triangle { <-36.9729, 203.0466, -69.1754>, <-37.693, 202.8192, -68.1771>, <-37.3473, 202.4958, -68.1662> }
					triangle { <-34.6125, 205.6131, -68.2553>, <-35.2241, 205.4288, -68.2386>, <-35.5149, 204.5366, -68.4815> }
					triangle { <-35.2241, 205.4288, -68.2386>, <-35.8845, 204.768, -68.4409>, <-35.5149, 204.5366, -68.4815> }
					triangle { <-35.8845, 204.768, -68.4409>, <-36.2892, 204.2191, -68.6774>, <-35.5149, 204.5366, -68.4815> }
					triangle { <-36.2892, 204.2191, -68.6774>, <-36.635, 202.6911, -68.7972>, <-35.5149, 204.5366, -68.4815> }
					triangle { <-36.2892, 204.2191, -68.6774>, <-36.9729, 203.0466, -69.1754>, <-36.635, 202.6911, -68.7972> }
					triangle { <-36.9729, 203.0466, -69.1754>, <-37.3473, 202.4958, -68.1662>, <-36.635, 202.6911, -68.7972> }
					triangle { <-37.3473, 202.4958, -68.1662>, <-36.9528, 202.1808, -68.143>, <-36.635, 202.6911, -68.7972> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-34.6125, 205.6131, -68.2553>, <-34.3604, 205.2628, -67.8573> }
					triangle { <-34.6125, 205.6131, -68.2553>, <-35.5149, 204.5366, -68.4815>, <-34.3604, 205.2628, -67.8573> }
					triangle { <-35.5149, 204.5366, -68.4815>, <-35.07965, 204.1978, -68.07859>, <-34.3604, 205.2628, -67.8573> }
					triangle { <-35.5149, 204.5366, -68.4815>, <-36.635, 202.6911, -68.7972>, <-35.07965, 204.1978, -68.07859> }
					triangle { <-35.07965, 204.1978, -68.07859>, <-36.635, 202.6911, -68.7972>, <-36.2588, 202.3932, -68.3989> }
					triangle { <-36.635, 202.6911, -68.7972>, <-36.9528, 202.1808, -68.143>, <-36.2588, 202.3932, -68.3989> }
					triangle { <-36.9528, 202.1808, -68.143>, <-36.6019, 201.9435, -68.00114>, <-36.2588, 202.3932, -68.3989> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-34.654, 206.2782, -68.0182>, <-35.1045, 206.135, -68.5588> }
					triangle { <-33.9036, 205.1226, -68.1984>, <-33.214, 204.8268, -68.4072>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-33.8653, 204.4885, -68.1296>, <-34.2303, 203.6233, -68.3082>, <-33.2055, 204.2154, -68.8661> }
					triangle { <-33.9036, 205.1226, -68.1984>, <-33.8653, 204.4885, -68.1296>, <-33.214, 204.8268, -68.4072> }
					triangle { <-33.8653, 204.4885, -68.1296>, <-33.2055, 204.2154, -68.8661>, <-33.214, 204.8268, -68.4072> }
					triangle { <-34.2303, 203.6233, -68.3082>, <-33.6959, 203.4502, -69.3526>, <-33.2055, 204.2154, -68.8661> }
					triangle { <-34.5759, 203.0336, -68.54>, <-34.2422, 202.6927, -69.6244>, <-33.6959, 203.4502, -69.3526> }
					triangle { <-34.2303, 203.6233, -68.3082>, <-34.5759, 203.0336, -68.54>, <-33.6959, 203.4502, -69.3526> }
					triangle { <-35.3778, 201.9427, -69.04751>, <-34.857, 201.8499, -69.7782>, <-34.2422, 202.6927, -69.6244> }
					triangle { <-34.5759, 203.0336, -68.54>, <-35.3778, 201.9427, -69.04751>, <-34.2422, 202.6927, -69.6244> }
					triangle { <-35.634, 201.3102, -68.02885>, <-35.1751, 201.2871, -67.9329>, <-34.857, 201.8499, -69.7782> }
					triangle { <-35.3778, 201.9427, -69.04751>, <-35.634, 201.3102, -68.02885>, <-34.857, 201.8499, -69.7782> }
					triangle { <-36.00835, 201.4785, -67.9268>, <-35.634, 201.3102, -68.02885>, <-35.3778, 201.9427, -69.04751> }
					triangle { <-34.5696, 203.8825, -68.4057>, <-33.8653, 204.4885, -68.1296>, <-33.9036, 205.1226, -68.1984> }
					triangle { <-34.5696, 203.8825, -68.4057>, <-34.2303, 203.6233, -68.3082>, <-33.8653, 204.4885, -68.1296> }
					triangle { <-34.5696, 203.8825, -68.4057>, <-34.5759, 203.0336, -68.54>, <-34.2303, 203.6233, -68.3082> }
					triangle { <-34.5696, 203.8825, -68.4057>, <-35.867, 202.1596, -68.7356>, <-34.5759, 203.0336, -68.54> }
					triangle { <-35.867, 202.1596, -68.7356>, <-35.3778, 201.9427, -69.04751>, <-34.5759, 203.0336, -68.54> }
					triangle { <-35.867, 202.1596, -68.7356>, <-36.00835, 201.4785, -67.9268>, <-35.3778, 201.9427, -69.04751> }
					triangle { <-35.867, 202.1596, -68.7356>, <-36.3332, 201.7034, -67.9529>, <-36.00835, 201.4785, -67.9268> }
					triangle { <-34.3604, 205.2628, -67.8573>, <-33.9036, 205.1226, -68.1984>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-34.3604, 205.2628, -67.8573>, <-34.5696, 203.8825, -68.4057>, <-33.9036, 205.1226, -68.1984> }
					triangle { <-34.3604, 205.2628, -67.8573>, <-35.07965, 204.1978, -68.07859>, <-34.5696, 203.8825, -68.4057> }
					triangle { <-35.07965, 204.1978, -68.07859>, <-35.867, 202.1596, -68.7356>, <-34.5696, 203.8825, -68.4057> }
					triangle { <-36.2588, 202.3932, -68.3989>, <-35.867, 202.1596, -68.7356>, <-35.07965, 204.1978, -68.07859> }
					triangle { <-36.2588, 202.3932, -68.3989>, <-36.3332, 201.7034, -67.9529>, <-35.867, 202.1596, -68.7356> }
					triangle { <-36.2588, 202.3932, -68.3989>, <-36.6019, 201.9435, -68.00114>, <-36.3332, 201.7034, -67.9529> }
					triangle { <-33.214, 204.8268, -68.4072>, <-33.2952, 205.3379, -67.9092>, <-33.7765, 206.0572, -68.2834> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-33.7765, 206.0572, -68.2834>, <-33.9173, 205.7027, -69.5872>, <-34.3431, 205.67, -68.936> }
					triangle { <-33.9087, 205.0913, -70.04618>, <-35.1753, 204.8003, -69.8939>, <-34.6564, 205.4738, -69.4572> }
					triangle { <-33.9173, 205.7027, -69.5872>, <-34.6564, 205.4738, -69.4572>, <-34.3431, 205.67, -68.936> }
					triangle { <-33.9173, 205.7027, -69.5872>, <-33.9087, 205.0913, -70.04618>, <-34.6564, 205.4738, -69.4572> }
					triangle { <-33.9087, 205.0913, -70.04618>, <-34.2673, 204.1619, -70.3114>, <-35.1753, 204.8003, -69.8939> }
					triangle { <-34.2673, 204.1619, -70.3114>, <-34.7916, 203.377, -70.5463>, <-35.5209, 204.2105, -70.1257> }
					triangle { <-34.2673, 204.1619, -70.3114>, <-35.5209, 204.2105, -70.1257>, <-35.1753, 204.8003, -69.8939> }
					triangle { <-34.7916, 203.377, -70.5463>, <-35.4723, 202.6163, -70.8108>, <-36.2129, 202.9828, -70.4488> }
					triangle { <-34.7916, 203.377, -70.5463>, <-36.2129, 202.9828, -70.4488>, <-35.5209, 204.2105, -70.1257> }
					triangle { <-35.4723, 202.6163, -70.8108>, <-37.1558, 203.8066, -71.2787>, <-37.2281, 203.4827, -70.984> }
					triangle { <-35.4723, 202.6163, -70.8108>, <-37.2281, 203.4827, -70.984>, <-36.2129, 202.9828, -70.4488> }
					triangle { <-36.2129, 202.9828, -70.4488>, <-37.2281, 203.4827, -70.984>, <-37.3647, 203.335, -70.5554> }
					triangle { <-34.3431, 205.67, -68.936>, <-34.6564, 205.4738, -69.4572>, <-35.2069, 204.6762, -69.4751> }
					triangle { <-34.6564, 205.4738, -69.4572>, <-35.1753, 204.8003, -69.8939>, <-35.2069, 204.6762, -69.4751> }
					triangle { <-35.1753, 204.8003, -69.8939>, <-35.5209, 204.2105, -70.1257>, <-35.2069, 204.6762, -69.4751> }
					triangle { <-35.5209, 204.2105, -70.1257>, <-36.6142, 203.0902, -69.9894>, <-35.2069, 204.6762, -69.4751> }
					triangle { <-35.5209, 204.2105, -70.1257>, <-36.2129, 202.9828, -70.4488>, <-36.6142, 203.0902, -69.9894> }
					triangle { <-36.2129, 202.9828, -70.4488>, <-37.3647, 203.335, -70.5554>, <-36.6142, 203.0902, -69.9894> }
					triangle { <-37.3647, 203.335, -70.5554>, <-37.4897, 203.2091, -70.08231>, <-36.6142, 203.0902, -69.9894> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-34.3431, 205.67, -68.936>, <-34.7779, 205.7829, -68.5579> }
					triangle { <-34.3431, 205.67, -68.936>, <-35.2069, 204.6762, -69.4751>, <-34.7779, 205.7829, -68.5579> }
					triangle { <-35.2069, 204.6762, -69.4751>, <-35.5851, 204.8274, -68.9267>, <-34.7779, 205.7829, -68.5579> }
					triangle { <-35.2069, 204.6762, -69.4751>, <-36.6142, 203.0902, -69.9894>, <-35.5851, 204.8274, -68.9267> }
					triangle { <-35.5851, 204.8274, -68.9267>, <-36.6142, 203.0902, -69.9894>, <-36.9772, 203.2552, -69.51> }
					triangle { <-36.6142, 203.0902, -69.9894>, <-37.4897, 203.2091, -70.08231>, <-36.9772, 203.2552, -69.51> }
					triangle { <-37.4897, 203.2091, -70.08231>, <-37.6499, 203.2161, -69.6653>, <-36.9772, 203.2552, -69.51> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-34.04239, 206.2685, -69.163>, <-33.9173, 205.7027, -69.5872> }
					triangle { <-34.5246, 205.5037, -68.1078>, <-34.4013, 205.2592, -67.3787>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-35.00436, 205.1551, -67.8698>, <-35.5988, 204.4122, -67.9615>, <-34.5289, 204.523, -67.2165> }
					triangle { <-34.5246, 205.5037, -68.1078>, <-35.00436, 205.1551, -67.8698>, <-34.4013, 205.2592, -67.3787> }
					triangle { <-35.00436, 205.1551, -67.8698>, <-34.5289, 204.523, -67.2165>, <-34.4013, 205.2592, -67.3787> }
					triangle { <-35.5988, 204.4122, -67.9615>, <-34.8875, 203.5936, -67.4818>, <-34.5289, 204.523, -67.2165> }
					triangle { <-35.9596, 203.8086, -68.1242>, <-35.3966, 202.8226, -67.7857>, <-34.8875, 203.5936, -67.4818> }
					triangle { <-35.5988, 204.4122, -67.9615>, <-35.9596, 203.8086, -68.1242>, <-34.8875, 203.5936, -67.4818> }
					triangle { <-36.6213, 202.6086, -68.5854>, <-36.06226, 202.0758, -68.1192>, <-35.3966, 202.8226, -67.7857> }
					triangle { <-35.9596, 203.8086, -68.1242>, <-36.6213, 202.6086, -68.5854>, <-35.3966, 202.8226, -67.7857> }
					triangle { <-37.8033, 202.933, -68.5539>, <-37.7526, 203.0585, -68.1045>, <-36.06226, 202.0758, -68.1192> }
					triangle { <-36.6213, 202.6086, -68.5854>, <-37.8033, 202.933, -68.5539>, <-36.06226, 202.0758, -68.1192> }
					triangle { <-37.8574, 203.0622, -68.953>, <-37.8033, 202.933, -68.5539>, <-36.6213, 202.6086, -68.5854> }
					triangle { <-35.449, 204.4545, -68.3709>, <-35.00436, 205.1551, -67.8698>, <-34.5246, 205.5037, -68.1078> }
					triangle { <-35.449, 204.4545, -68.3709>, <-35.5988, 204.4122, -67.9615>, <-35.00436, 205.1551, -67.8698> }
					triangle { <-35.449, 204.4545, -68.3709>, <-35.9596, 203.8086, -68.1242>, <-35.5988, 204.4122, -67.9615> }
					triangle { <-35.449, 204.4545, -68.3709>, <-36.8108, 202.91, -69.09222>, <-35.9596, 203.8086, -68.1242> }
					triangle { <-36.8108, 202.91, -69.09222>, <-36.6213, 202.6086, -68.5854>, <-35.9596, 203.8086, -68.1242> }
					triangle { <-36.8108, 202.91, -69.09222>, <-37.8574, 203.0622, -68.953>, <-36.6213, 202.6086, -68.5854> }
					triangle { <-36.8108, 202.91, -69.09222>, <-37.7742, 203.1384, -69.3326>, <-37.8574, 203.0622, -68.953> }
					triangle { <-34.7779, 205.7829, -68.5579>, <-34.5246, 205.5037, -68.1078>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-34.7779, 205.7829, -68.5579>, <-35.449, 204.4545, -68.3709>, <-34.5246, 205.5037, -68.1078> }
					triangle { <-34.7779, 205.7829, -68.5579>, <-35.5851, 204.8274, -68.9267>, <-35.449, 204.4545, -68.3709> }
					triangle { <-35.5851, 204.8274, -68.9267>, <-36.8108, 202.91, -69.09222>, <-35.449, 204.4545, -68.3709> }
					triangle { <-36.9772, 203.2552, -69.51>, <-36.8108, 202.91, -69.09222>, <-35.5851, 204.8274, -68.9267> }
					triangle { <-36.9772, 203.2552, -69.51>, <-37.7742, 203.1384, -69.3326>, <-36.8108, 202.91, -69.09222> }
					triangle { <-36.9772, 203.2552, -69.51>, <-37.6499, 203.2161, -69.6653>, <-37.7742, 203.1384, -69.3326> }
					triangle { <-34.4013, 205.2592, -67.3787>, <-34.3903, 205.9498, -67.5756>, <-33.7765, 206.0572, -68.2834> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-33.7765, 206.0572, -68.2834>, <-33.214, 204.8268, -68.4072>, <-33.7826, 205.2334, -68.7506> }
					triangle { <-33.3416, 204.0907, -68.2449>, <-34.00344, 203.8312, -69.3435>, <-33.6686, 204.6687, -69.02684> }
					triangle { <-33.214, 204.8268, -68.4072>, <-33.6686, 204.6687, -69.02684>, <-33.7826, 205.2334, -68.7506> }
					triangle { <-33.214, 204.8268, -68.4072>, <-33.3416, 204.0907, -68.2449>, <-33.6686, 204.6687, -69.02684> }
					triangle { <-33.3416, 204.0907, -68.2449>, <-33.9228, 203.2423, -68.3174>, <-34.00344, 203.8312, -69.3435> }
					triangle { <-33.9228, 203.2423, -68.3174>, <-34.4691, 202.4848, -68.5892>, <-34.3642, 203.2276, -69.5062> }
					triangle { <-33.9228, 203.2423, -68.3174>, <-34.3642, 203.2276, -69.5062>, <-34.00344, 203.8312, -69.3435> }
					triangle { <-34.4691, 202.4848, -68.5892>, <-35.0234, 201.6975, -69.01908>, <-35.2114, 202.0952, -69.8066> }
					triangle { <-34.4691, 202.4848, -68.5892>, <-35.2114, 202.0952, -69.8066>, <-34.3642, 203.2276, -69.5062> }
					triangle { <-35.0234, 201.6975, -69.01908>, <-34.3571, 201.8578, -71.01916>, <-34.7976, 201.8616, -70.9647> }
					triangle { <-35.0234, 201.6975, -69.01908>, <-34.7976, 201.8616, -70.9647>, <-35.2114, 202.0952, -69.8066> }
					triangle { <-35.2114, 202.0952, -69.8066>, <-34.7976, 201.8616, -70.9647>, <-35.2199, 202.0697, -71.01546> }
					triangle { <-33.7826, 205.2334, -68.7506>, <-33.6686, 204.6687, -69.02684>, <-34.373, 204.0627, -69.3029> }
					triangle { <-33.6686, 204.6687, -69.02684>, <-34.00344, 203.8312, -69.3435>, <-34.373, 204.0627, -69.3029> }
					triangle { <-34.00344, 203.8312, -69.3435>, <-34.3642, 203.2276, -69.5062>, <-34.373, 204.0627, -69.3029> }
					triangle { <-34.3642, 203.2276, -69.5062>, <-35.5494, 202.4507, -70.1849>, <-34.373, 204.0627, -69.3029> }
					triangle { <-34.3642, 203.2276, -69.5062>, <-35.2114, 202.0952, -69.8066>, <-35.5494, 202.4507, -70.1849> }
					triangle { <-35.2114, 202.0952, -69.8066>, <-35.2199, 202.0697, -71.01546>, <-35.5494, 202.4507, -70.1849> }
					triangle { <-35.2199, 202.0697, -71.01546>, <-35.6526, 202.3271, -71.05862>, <-35.5494, 202.4507, -70.1849> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-33.7826, 205.2334, -68.7506>, <-34.07305, 205.5262, -69.1686> }
					triangle { <-33.7826, 205.2334, -68.7506>, <-34.373, 204.0627, -69.3029>, <-34.07305, 205.5262, -69.1686> }
					triangle { <-34.373, 204.0627, -69.3029>, <-34.7317, 204.5166, -69.6659>, <-34.07305, 205.5262, -69.1686> }
					triangle { <-34.373, 204.0627, -69.3029>, <-35.5494, 202.4507, -70.1849>, <-34.7317, 204.5166, -69.6659> }
					triangle { <-34.7317, 204.5166, -69.6659>, <-35.5494, 202.4507, -70.1849>, <-35.849, 202.8638, -70.5432> }
					triangle { <-35.5494, 202.4507, -70.1849>, <-35.6526, 202.3271, -71.05862>, <-35.849, 202.8638, -70.5432> }
					triangle { <-35.6526, 202.3271, -71.05862>, <-35.9652, 202.622, -71.1805>, <-35.849, 202.8638, -70.5432> }
					triangle { <-33.7765, 206.0572, -68.2834>, <-33.1288, 205.4904, -68.6683>, <-33.214, 204.8268, -68.4072> }
					triangle { <-34.4915, 205.724, -68.8074>, <-35.1045, 206.135, -68.5588>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-35.02748, 205.609, -69.1358>, <-35.6576, 204.9759, -69.4761>, <-35.7638, 205.7668, -68.4392> }
					triangle { <-34.4915, 205.724, -68.8074>, <-35.02748, 205.609, -69.1358>, <-35.1045, 206.135, -68.5588> }
					triangle { <-35.02748, 205.609, -69.1358>, <-35.7638, 205.7668, -68.4392>, <-35.1045, 206.135, -68.5588> }
					triangle { <-35.6576, 204.9759, -69.4761>, <-36.345, 204.9185, -68.5116>, <-35.7638, 205.7668, -68.4392> }
					triangle { <-36.07748, 204.4132, -69.6436>, <-36.8322, 204.1201, -68.7787>, <-36.345, 204.9185, -68.5116> }
					triangle { <-35.6576, 204.9759, -69.4761>, <-36.07748, 204.4132, -69.6436>, <-36.345, 204.9185, -68.5116> }
					triangle { <-36.8065, 203.199, -69.9346>, <-37.3274, 203.2919, -69.2038>, <-36.8322, 204.1201, -68.7787> }
					triangle { <-36.07748, 204.4132, -69.6436>, <-36.8065, 203.199, -69.9346>, <-36.8322, 204.1201, -68.7787> }
					triangle { <-36.9331, 203.2553, -71.1528>, <-37.1241, 203.6818, -71.109>, <-37.3274, 203.2919, -69.2038> }
					triangle { <-36.8065, 203.199, -69.9346>, <-36.9331, 203.2553, -71.1528>, <-37.3274, 203.2919, -69.2038> }
					triangle { <-36.5971, 203.0294, -71.2748>, <-36.9331, 203.2553, -71.1528>, <-36.8065, 203.199, -69.9346> }
					triangle { <-35.3182, 204.7168, -69.3787>, <-35.02748, 205.609, -69.1358>, <-34.4915, 205.724, -68.8074> }
					triangle { <-35.3182, 204.7168, -69.3787>, <-35.6576, 204.9759, -69.4761>, <-35.02748, 205.609, -69.1358> }
					triangle { <-35.3182, 204.7168, -69.3787>, <-36.07748, 204.4132, -69.6436>, <-35.6576, 204.9759, -69.4761> }
					triangle { <-35.3182, 204.7168, -69.3787>, <-36.3174, 202.9821, -70.2465>, <-36.07748, 204.4132, -69.6436> }
					triangle { <-36.3174, 202.9821, -70.2465>, <-36.8065, 203.199, -69.9346>, <-36.07748, 204.4132, -69.6436> }
					triangle { <-36.3174, 202.9821, -70.2465>, <-36.5971, 203.0294, -71.2748>, <-36.8065, 203.199, -69.9346> }
					triangle { <-36.3174, 202.9821, -70.2465>, <-36.2722, 202.8045, -71.2487>, <-36.5971, 203.0294, -71.2748> }
					triangle { <-34.07305, 205.5262, -69.1686>, <-34.4915, 205.724, -68.8074>, <-33.7765, 206.0572, -68.2834> }
					triangle { <-34.07305, 205.5262, -69.1686>, <-35.3182, 204.7168, -69.3787>, <-34.4915, 205.724, -68.8074> }
					triangle { <-34.07305, 205.5262, -69.1686>, <-34.7317, 204.5166, -69.6659>, <-35.3182, 204.7168, -69.3787> }
					triangle { <-34.7317, 204.5166, -69.6659>, <-36.3174, 202.9821, -70.2465>, <-35.3182, 204.7168, -69.3787> }
					triangle { <-35.849, 202.8638, -70.5432>, <-36.3174, 202.9821, -70.2465>, <-34.7317, 204.5166, -69.6659> }
					triangle { <-35.849, 202.8638, -70.5432>, <-36.2722, 202.8045, -71.2487>, <-36.3174, 202.9821, -70.2465> }
					triangle { <-35.849, 202.8638, -70.5432>, <-35.9652, 202.622, -71.1805>, <-36.2722, 202.8045, -71.2487> }
					triangle { <-35.1045, 206.135, -68.5588>, <-34.4876, 206.4307, -68.7773>, <-33.7765, 206.0572, -68.2834> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-32.9319, 206.2698, -67.3768>, <-33.07216, 207.2003, -67.7153>, 0.55 }
			cylinder { <-33.07216, 207.2003, -67.7153>, <-33.2363, 208.1185, -68.07584>, 0.55 }
			cylinder { <-33.2363, 208.1185, -68.07584>, <-33.4242, 209.0234, -68.4578>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.4242, 209.0234, -68.4578>, <-33.5015, 209.4919, -68.3011>, 0.55 }
				cylinder { <-33.5015, 209.4919, -68.3011>, <-33.5246, 209.7489, -67.8729>, 0.55 }
				cylinder { <-33.5246, 209.7489, -67.8729>, <-33.4823, 209.6697, -67.381>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower
				mesh { // flower petal
					triangle { <-33.4823, 209.6697, -67.381>, <-32.7855, 209.0811, -66.9272>, <-33.3421, 209.2338, -66.8381> }
					triangle { <-32.4308, 209.0705, -66.4768>, <-33.08654, 208.6999, -65.8477>, <-33.1807, 208.9062, -66.5278> }
					triangle { <-32.7855, 209.0811, -66.9272>, <-33.1807, 208.9062, -66.5278>, <-33.3421, 209.2338, -66.8381> }
					triangle { <-32.7855, 209.0811, -66.9272>, <-32.4308, 209.0705, -66.4768>, <-33.1807, 208.9062, -66.5278> }
					triangle { <-32.4308, 209.0705, -66.4768>, <-32.3084, 209.1095, -65.7144>, <-33.08654, 208.6999, -65.8477> }
					triangle { <-32.3084, 209.1095, -65.7144>, <-32.3079, 209.041, -64.9881>, <-33.03247, 208.6417, -65.3122> }
					triangle { <-32.3084, 209.1095, -65.7144>, <-33.03247, 208.6417, -65.3122>, <-33.08654, 208.6999, -65.8477> }
					triangle { <-32.3079, 209.041, -64.9881>, <-32.3721, 208.8815, -64.2162>, <-32.9928, 208.6123, -64.229> }
					triangle { <-32.3079, 209.041, -64.9881>, <-32.9928, 208.6123, -64.229>, <-33.03247, 208.6417, -65.3122> }
					triangle { <-32.3721, 208.8815, -64.2162>, <-33.1424, 207.498, -64.3009>, <-33.2838, 207.7282, -64.1064> }
					triangle { <-32.3721, 208.8815, -64.2162>, <-33.2838, 207.7282, -64.1064>, <-32.9928, 208.6123, -64.229> }
					triangle { <-32.9928, 208.6123, -64.229>, <-33.2838, 207.7282, -64.1064>, <-33.5587, 207.9355, -64.0194> }
					triangle { <-33.3421, 209.2338, -66.8381>, <-33.1807, 208.9062, -66.5278>, <-33.3085, 208.9394, -65.8129> }
					triangle { <-33.1807, 208.9062, -66.5278>, <-33.08654, 208.6999, -65.8477>, <-33.3085, 208.9394, -65.8129> }
					triangle { <-33.08654, 208.6999, -65.8477>, <-33.03247, 208.6417, -65.3122>, <-33.3085, 208.9394, -65.8129> }
					triangle { <-33.03247, 208.6417, -65.3122>, <-33.4567, 208.6304, -64.2129>, <-33.3085, 208.9394, -65.8129> }
					triangle { <-33.03247, 208.6417, -65.3122>, <-32.9928, 208.6123, -64.229>, <-33.4567, 208.6304, -64.2129> }
					triangle { <-32.9928, 208.6123, -64.229>, <-33.5587, 207.9355, -64.0194>, <-33.4567, 208.6304, -64.2129> }
					triangle { <-33.5587, 207.9355, -64.0194>, <-33.8557, 208.1624, -63.9566>, <-33.4567, 208.6304, -64.2129> }
					triangle { <-33.4823, 209.6697, -67.381>, <-33.3421, 209.2338, -66.8381>, <-33.7793, 209.1947, -66.8023> }
					triangle { <-33.3421, 209.2338, -66.8381>, <-33.3085, 208.9394, -65.8129>, <-33.7793, 209.1947, -66.8023> }
					triangle { <-33.3085, 208.9394, -65.8129>, <-33.8166, 208.9966, -65.8453>, <-33.7793, 209.1947, -66.8023> }
					triangle { <-33.3085, 208.9394, -65.8129>, <-33.4567, 208.6304, -64.2129>, <-33.8166, 208.9966, -65.8453> }
					triangle { <-33.8166, 208.9966, -65.8453>, <-33.4567, 208.6304, -64.2129>, <-33.9222, 208.6548, -64.2503> }
					triangle { <-33.4567, 208.6304, -64.2129>, <-33.8557, 208.1624, -63.9566>, <-33.9222, 208.6548, -64.2503> }
					triangle { <-33.8557, 208.1624, -63.9566>, <-34.1616, 208.2991, -63.9585>, <-33.9222, 208.6548, -64.2503> }
					triangle { <-33.4823, 209.6697, -67.381>, <-33.1709, 209.0398, -67.3012>, <-32.7855, 209.0811, -66.9272> }
					triangle { <-33.8527, 209.6281, -66.7764>, <-34.1468, 210.1325, -66.7627>, <-33.4823, 209.6697, -67.381> }
					triangle { <-34.1592, 209.662, -66.4096>, <-34.2777, 209.6199, -65.7038>, <-34.175, 210.4176, -66.266> }
					triangle { <-33.8527, 209.6281, -66.7764>, <-34.1592, 209.662, -66.4096>, <-34.1468, 210.1325, -66.7627> }
					triangle { <-34.1592, 209.662, -66.4096>, <-34.175, 210.4176, -66.266>, <-34.1468, 210.1325, -66.7627> }
					triangle { <-34.2777, 209.6199, -65.7038>, <-34.05275, 210.4567, -65.5036>, <-34.175, 210.4176, -66.266> }
					triangle { <-34.2662, 209.5946, -65.1631>, <-34.00962, 210.3554, -64.7824>, <-34.05275, 210.4567, -65.5036> }
					triangle { <-34.2777, 209.6199, -65.7038>, <-34.2662, 209.5946, -65.1631>, <-34.05275, 210.4567, -65.5036> }
					triangle { <-34.1414, 209.4995, -64.09023>, <-34.03131, 210.1629, -64.01569>, <-34.00962, 210.3554, -64.7824> }
					triangle { <-34.2662, 209.5946, -65.1631>, <-34.1414, 209.4995, -64.09023>, <-34.00962, 210.3554, -64.7824> }
					triangle { <-34.7925, 208.8884, -63.8703>, <-35.03215, 209.0912, -64.02966>, <-34.03131, 210.1629, -64.01569> }
					triangle { <-34.1414, 209.4995, -64.09023>, <-34.7925, 208.8884, -63.8703>, <-34.03131, 210.1629, -64.01569> }
					triangle { <-34.6241, 208.6198, -63.8797>, <-34.7925, 208.8884, -63.8703>, <-34.1414, 209.4995, -64.09023> }
					triangle { <-33.9892, 209.4652, -65.7307>, <-34.1592, 209.662, -66.4096>, <-33.8527, 209.6281, -66.7764> }
					triangle { <-33.9892, 209.4652, -65.7307>, <-34.2777, 209.6199, -65.7038>, <-34.1592, 209.662, -66.4096> }
					triangle { <-33.9892, 209.4652, -65.7307>, <-34.2662, 209.5946, -65.1631>, <-34.2777, 209.6199, -65.7038> }
					triangle { <-33.9892, 209.4652, -65.7307>, <-34.00975, 209.0576, -64.146>, <-34.2662, 209.5946, -65.1631> }
					triangle { <-34.00975, 209.0576, -64.146>, <-34.1414, 209.4995, -64.09023>, <-34.2662, 209.5946, -65.1631> }
					triangle { <-34.00975, 209.0576, -64.146>, <-34.6241, 208.6198, -63.8797>, <-34.1414, 209.4995, -64.09023> }
					triangle { <-34.00975, 209.0576, -64.146>, <-34.3901, 208.4391, -63.908>, <-34.6241, 208.6198, -63.8797> }
					triangle { <-33.7793, 209.1947, -66.8023>, <-33.8527, 209.6281, -66.7764>, <-33.4823, 209.6697, -67.381> }
					triangle { <-33.7793, 209.1947, -66.8023>, <-33.9892, 209.4652, -65.7307>, <-33.8527, 209.6281, -66.7764> }
					triangle { <-33.7793, 209.1947, -66.8023>, <-33.8166, 208.9966, -65.8453>, <-33.9892, 209.4652, -65.7307> }
					triangle { <-33.8166, 208.9966, -65.8453>, <-34.00975, 209.0576, -64.146>, <-33.9892, 209.4652, -65.7307> }
					triangle { <-33.9222, 208.6548, -64.2503>, <-34.00975, 209.0576, -64.146>, <-33.8166, 208.9966, -65.8453> }
					triangle { <-33.9222, 208.6548, -64.2503>, <-34.3901, 208.4391, -63.908>, <-34.00975, 209.0576, -64.146> }
					triangle { <-33.9222, 208.6548, -64.2503>, <-34.1616, 208.2991, -63.9585>, <-34.3901, 208.4391, -63.908> }
					triangle { <-34.1468, 210.1325, -66.7627>, <-34.1494, 209.7956, -67.1829>, <-33.4823, 209.6697, -67.381> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-33.4823, 209.6697, -67.381>, <-32.9347, 210.285, -66.7814>, <-33.09509, 209.7234, -66.7881> }
					triangle { <-32.9628, 210.5701, -66.2847>, <-32.6488, 209.8248, -65.7289>, <-32.7955, 209.8335, -66.4306> }
					triangle { <-32.9347, 210.285, -66.7814>, <-32.7955, 209.8335, -66.4306>, <-33.09509, 209.7234, -66.7881> }
					triangle { <-32.9347, 210.285, -66.7814>, <-32.9628, 210.5701, -66.2847>, <-32.7955, 209.8335, -66.4306> }
					triangle { <-32.9628, 210.5701, -66.2847>, <-33.06785, 210.5806, -65.5188>, <-32.6488, 209.8248, -65.7289> }
					triangle { <-33.06785, 210.5806, -65.5188>, <-33.0626, 210.4745, -64.7971>, <-32.6373, 209.7995, -65.1883> }
					triangle { <-33.06785, 210.5806, -65.5188>, <-32.6373, 209.7995, -65.1883>, <-32.6488, 209.8248, -65.7289> }
					triangle { <-33.0626, 210.4745, -64.7971>, <-32.9706, 210.2963, -64.03207>, <-32.7019, 209.6806, -64.1124> }
					triangle { <-33.0626, 210.4745, -64.7971>, <-32.7019, 209.6806, -64.1124>, <-32.6373, 209.7995, -65.1883> }
					triangle { <-32.9706, 210.2963, -64.03207>, <-31.5858, 209.5279, -64.1096>, <-31.8321, 209.3628, -63.9584> }
					triangle { <-32.9706, 210.2963, -64.03207>, <-31.8321, 209.3628, -63.9584>, <-32.7019, 209.6806, -64.1124> }
					triangle { <-32.7019, 209.6806, -64.1124>, <-31.8321, 209.3628, -63.9584>, <-32.04643, 209.081, -63.9306> }
					triangle { <-33.09509, 209.7234, -66.7881>, <-32.7955, 209.8335, -66.4306>, <-32.8907, 209.6033, -65.7476> }
					triangle { <-32.7955, 209.8335, -66.4306>, <-32.6488, 209.8248, -65.7289>, <-32.8907, 209.6033, -65.7476> }
					triangle { <-32.6488, 209.8248, -65.7289>, <-32.6373, 209.7995, -65.1883>, <-32.8907, 209.6033, -65.7476> }
					triangle { <-32.6373, 209.7995, -65.1883>, <-32.7218, 209.2196, -64.1659>, <-32.8907, 209.6033, -65.7476> }
					triangle { <-32.6373, 209.7995, -65.1883>, <-32.7019, 209.6806, -64.1124>, <-32.7218, 209.2196, -64.1659> }
					triangle { <-32.7019, 209.6806, -64.1124>, <-32.04643, 209.081, -63.9306>, <-32.7218, 209.2196, -64.1659> }
					triangle { <-32.04643, 209.081, -63.9306>, <-32.2781, 208.7811, -63.9316>, <-32.7218, 209.2196, -64.1659> }
					triangle { <-33.4823, 209.6697, -67.381>, <-33.09509, 209.7234, -66.7881>, <-33.05961, 209.2852, -66.8134> }
					triangle { <-33.09509, 209.7234, -66.7881>, <-32.8907, 209.6033, -65.7476>, <-33.05961, 209.2852, -66.8134> }
					triangle { <-32.8907, 209.6033, -65.7476>, <-32.9453, 209.1062, -65.8587>, <-33.05961, 209.2852, -66.8134> }
					triangle { <-32.8907, 209.6033, -65.7476>, <-32.7218, 209.2196, -64.1659>, <-32.9453, 209.1062, -65.8587> }
					triangle { <-32.9453, 209.1062, -65.8587>, <-32.7218, 209.2196, -64.1659>, <-32.7432, 208.7648, -64.273> }
					triangle { <-32.7218, 209.2196, -64.1659>, <-32.2781, 208.7811, -63.9316>, <-32.7432, 208.7648, -64.273> }
					triangle { <-32.2781, 208.7811, -63.9316>, <-32.4144, 208.4807, -63.9899>, <-32.7432, 208.7648, -64.273> }
					triangle { <-33.4823, 209.6697, -67.381>, <-32.8615, 209.9576, -67.2028>, <-32.9347, 210.285, -66.7814> }
					triangle { <-33.4937, 209.2147, -66.8357>, <-33.9977, 208.9286, -66.9085>, <-33.4823, 209.6697, -67.381> }
					triangle { <-33.5595, 208.8586, -66.522>, <-33.5789, 208.6379, -65.8401>, <-34.3248, 208.8322, -66.4475> }
					triangle { <-33.4937, 209.2147, -66.8357>, <-33.5595, 208.8586, -66.522>, <-33.9977, 208.9286, -66.9085> }
					triangle { <-33.5595, 208.8586, -66.522>, <-34.3248, 208.8322, -66.4475>, <-33.9977, 208.9286, -66.9085> }
					triangle { <-33.5789, 208.6379, -65.8401>, <-34.4298, 208.8427, -65.6816>, <-34.3248, 208.8322, -66.4475> }
					triangle { <-33.6006, 208.5703, -65.3035>, <-34.3913, 208.779, -64.9559>, <-34.4298, 208.8427, -65.6816> }
					triangle { <-33.5789, 208.6379, -65.8401>, <-33.6006, 208.5703, -65.3035>, <-34.4298, 208.8427, -65.6816> }
					triangle { <-33.5989, 208.5361, -64.2196>, <-34.2661, 208.6432, -64.1869>, <-34.3913, 208.779, -64.9559> }
					triangle { <-33.6006, 208.5703, -65.3035>, <-33.5989, 208.5361, -64.2196>, <-34.3913, 208.779, -64.9559> }
					triangle { <-33.00977, 207.8517, -64.04582>, <-33.1981, 207.6406, -64.2552>, <-34.2661, 208.6432, -64.1869> }
					triangle { <-33.5989, 208.5361, -64.2196>, <-33.00977, 207.8517, -64.04582>, <-34.2661, 208.6432, -64.1869> }
					triangle { <-32.7411, 208.016, -64.00745>, <-33.00977, 207.8517, -64.04582>, <-33.5989, 208.5361, -64.2196> }
					triangle { <-33.4222, 208.9251, -65.8112>, <-33.5595, 208.8586, -66.522>, <-33.4937, 209.2147, -66.8357> }
					triangle { <-33.4222, 208.9251, -65.8112>, <-33.5789, 208.6379, -65.8401>, <-33.5595, 208.8586, -66.522> }
					triangle { <-33.4222, 208.9251, -65.8112>, <-33.6006, 208.5703, -65.3035>, <-33.5789, 208.6379, -65.8401> }
					triangle { <-33.4222, 208.9251, -65.8112>, <-33.1536, 208.6685, -64.2175>, <-33.6006, 208.5703, -65.3035> }
					triangle { <-33.1536, 208.6685, -64.2175>, <-33.5989, 208.5361, -64.2196>, <-33.6006, 208.5703, -65.3035> }
					triangle { <-33.1536, 208.6685, -64.2175>, <-32.7411, 208.016, -64.00745>, <-33.5989, 208.5361, -64.2196> }
					triangle { <-33.1536, 208.6685, -64.2175>, <-32.5584, 208.2491, -63.9856>, <-32.7411, 208.016, -64.00745> }
					triangle { <-33.05961, 209.2852, -66.8134>, <-33.4937, 209.2147, -66.8357>, <-33.4823, 209.6697, -67.381> }
					triangle { <-33.05961, 209.2852, -66.8134>, <-33.4222, 208.9251, -65.8112>, <-33.4937, 209.2147, -66.8357> }
					triangle { <-33.05961, 209.2852, -66.8134>, <-32.9453, 209.1062, -65.8587>, <-33.4222, 208.9251, -65.8112> }
					triangle { <-32.9453, 209.1062, -65.8587>, <-33.1536, 208.6685, -64.2175>, <-33.4222, 208.9251, -65.8112> }
					triangle { <-32.7432, 208.7648, -64.273>, <-33.1536, 208.6685, -64.2175>, <-32.9453, 209.1062, -65.8587> }
					triangle { <-32.7432, 208.7648, -64.273>, <-32.5584, 208.2491, -63.9856>, <-33.1536, 208.6685, -64.2175> }
					triangle { <-32.7432, 208.7648, -64.273>, <-32.4144, 208.4807, -63.9899>, <-32.5584, 208.2491, -63.9856> }
					triangle { <-33.9977, 208.9286, -66.9085>, <-33.6255, 208.9827, -67.2941>, <-33.4823, 209.6697, -67.381> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-33.4823, 209.6697, -67.381>, <-34.1468, 210.1325, -66.7627>, <-33.5869, 209.9672, -66.7446> }
					triangle { <-34.474, 210.0362, -66.3017>, <-33.7794, 210.2557, -65.6442>, <-33.7273, 210.213, -66.3579> }
					triangle { <-34.1468, 210.1325, -66.7627>, <-33.7273, 210.213, -66.3579>, <-33.5869, 209.9672, -66.7446> }
					triangle { <-34.1468, 210.1325, -66.7627>, <-34.474, 210.0362, -66.3017>, <-33.7273, 210.213, -66.3579> }
					triangle { <-34.474, 210.0362, -66.3017>, <-34.551, 209.8209, -65.5631>, <-33.7794, 210.2557, -65.6442> }
					triangle { <-34.551, 209.8209, -65.5631>, <-34.5079, 209.7195, -64.842>, <-33.8011, 210.1881, -65.1075> }
					triangle { <-34.551, 209.8209, -65.5631>, <-33.8011, 210.1881, -65.1075>, <-33.7794, 210.2557, -65.6442> }
					triangle { <-34.5079, 209.7195, -64.842>, <-34.3967, 209.6967, -64.05937>, <-33.776, 209.9658, -64.04654> }
					triangle { <-34.5079, 209.7195, -64.842>, <-33.776, 209.9658, -64.04654>, <-33.8011, 210.1881, -65.1075> }
					triangle { <-34.3967, 209.6967, -64.05937>, <-33.6232, 211.0675, -63.8674>, <-33.472, 210.7995, -63.7402> }
					triangle { <-34.3967, 209.6967, -64.05937>, <-33.472, 210.7995, -63.7402>, <-33.776, 209.9658, -64.04654> }
					triangle { <-33.776, 209.9658, -64.04654>, <-33.472, 210.7995, -63.7402>, <-33.1939, 210.5797, -63.72> }
					triangle { <-33.5869, 209.9672, -66.7446>, <-33.7273, 210.213, -66.3579>, <-33.5574, 210.0162, -65.679> }
					triangle { <-33.7273, 210.213, -66.3579>, <-33.7794, 210.2557, -65.6442>, <-33.5574, 210.0162, -65.679> }
					triangle { <-33.7794, 210.2557, -65.6442>, <-33.8011, 210.1881, -65.1075>, <-33.5574, 210.0162, -65.679> }
					triangle { <-33.8011, 210.1881, -65.1075>, <-33.3121, 209.9477, -64.06267>, <-33.5574, 210.0162, -65.679> }
					triangle { <-33.8011, 210.1881, -65.1075>, <-33.776, 209.9658, -64.04654>, <-33.3121, 209.9477, -64.06267> }
					triangle { <-33.776, 209.9658, -64.04654>, <-33.1939, 210.5797, -63.72>, <-33.3121, 209.9477, -64.06267> }
					triangle { <-33.1939, 210.5797, -63.72>, <-32.8953, 210.3465, -63.7292>, <-33.3121, 209.9477, -64.06267> }
					triangle { <-33.4823, 209.6697, -67.381>, <-33.5869, 209.9672, -66.7446>, <-33.1481, 210.0, -66.7268> }
					triangle { <-33.5869, 209.9672, -66.7446>, <-33.5574, 210.0162, -65.679>, <-33.1481, 210.0, -66.7268> }
					triangle { <-33.5574, 210.0162, -65.679>, <-33.05261, 209.9716, -65.7539>, <-33.1481, 210.0, -66.7268> }
					triangle { <-33.5574, 210.0162, -65.679>, <-33.3121, 209.9477, -64.06267>, <-33.05261, 209.9716, -65.7539> }
					triangle { <-33.05261, 209.9716, -65.7539>, <-33.3121, 209.9477, -64.06267>, <-32.8498, 209.9359, -64.1324> }
					triangle { <-33.3121, 209.9477, -64.06267>, <-32.8953, 210.3465, -63.7292>, <-32.8498, 209.9359, -64.1324> }
					triangle { <-32.8953, 210.3465, -63.7292>, <-32.591, 210.2161, -63.7809>, <-32.8498, 209.9359, -64.1324> }
					triangle { <-33.4823, 209.6697, -67.381>, <-33.784, 210.2618, -67.1392>, <-34.1468, 210.1325, -66.7627> }
					triangle { <-33.07645, 209.5729, -66.8063>, <-32.7855, 209.0811, -66.9272>, <-33.4823, 209.6697, -67.381> }
					triangle { <-32.7488, 209.4573, -66.4762>, <-32.5882, 209.3357, -65.7882>, <-32.7297, 208.689, -66.5125> }
					triangle { <-33.07645, 209.5729, -66.8063>, <-32.7488, 209.4573, -66.4762>, <-32.7855, 209.0811, -66.9272> }
					triangle { <-32.7488, 209.4573, -66.4762>, <-32.7297, 208.689, -66.5125>, <-32.7855, 209.0811, -66.9272> }
					triangle { <-32.5882, 209.3357, -65.7882>, <-32.8067, 208.4737, -65.7739>, <-32.7297, 208.689, -66.5125> }
					triangle { <-32.5674, 209.2352, -65.2566>, <-32.8061, 208.4052, -65.04771>, <-32.8067, 208.4737, -65.7739> }
					triangle { <-32.5882, 209.3357, -65.7882>, <-32.5674, 209.2352, -65.2566>, <-32.8067, 208.4737, -65.7739> }
					triangle { <-32.6274, 209.0786, -64.1853>, <-32.7375, 208.4152, -64.2598>, <-32.8061, 208.4052, -65.04771> }
					triangle { <-32.5674, 209.2352, -65.2566>, <-32.6274, 209.0786, -64.1853>, <-32.8061, 208.4052, -65.04771> }
					triangle { <-31.9601, 209.6268, -63.8691>, <-31.7318, 209.4681, -64.0851>, <-32.7375, 208.4152, -64.2598> }
					triangle { <-32.6274, 209.0786, -64.1853>, <-31.9601, 209.6268, -63.8691>, <-32.7375, 208.4152, -64.2598> }
					triangle { <-32.1269, 209.8891, -63.8061>, <-31.9601, 209.6268, -63.8691>, <-32.6274, 209.0786, -64.1853> }
					triangle { <-32.8767, 209.4905, -65.7613>, <-32.7488, 209.4573, -66.4762>, <-33.07645, 209.5729, -66.8063> }
					triangle { <-32.8767, 209.4905, -65.7613>, <-32.5882, 209.3357, -65.7882>, <-32.7488, 209.4573, -66.4762> }
					triangle { <-32.8767, 209.4905, -65.7613>, <-32.5674, 209.2352, -65.2566>, <-32.5882, 209.3357, -65.7882> }
					triangle { <-32.8767, 209.4905, -65.7613>, <-32.7591, 209.5206, -64.1295>, <-32.5674, 209.2352, -65.2566> }
					triangle { <-32.7591, 209.5206, -64.1295>, <-32.6274, 209.0786, -64.1853>, <-32.5674, 209.2352, -65.2566> }
					triangle { <-32.7591, 209.5206, -64.1295>, <-32.1269, 209.8891, -63.8061>, <-32.6274, 209.0786, -64.1853> }
					triangle { <-32.7591, 209.5206, -64.1295>, <-32.3609, 210.0699, -63.7778>, <-32.1269, 209.8891, -63.8061> }
					triangle { <-33.1481, 210.0, -66.7268>, <-33.07645, 209.5729, -66.8063>, <-33.4823, 209.6697, -67.381> }
					triangle { <-33.1481, 210.0, -66.7268>, <-32.8767, 209.4905, -65.7613>, <-33.07645, 209.5729, -66.8063> }
					triangle { <-33.1481, 210.0, -66.7268>, <-33.05261, 209.9716, -65.7539>, <-32.8767, 209.4905, -65.7613> }
					triangle { <-33.05261, 209.9716, -65.7539>, <-32.7591, 209.5206, -64.1295>, <-32.8767, 209.4905, -65.7613> }
					triangle { <-32.8498, 209.9359, -64.1324>, <-32.7591, 209.5206, -64.1295>, <-33.05261, 209.9716, -65.7539> }
					triangle { <-32.8498, 209.9359, -64.1324>, <-32.3609, 210.0699, -63.7778>, <-32.7591, 209.5206, -64.1295> }
					triangle { <-32.8498, 209.9359, -64.1324>, <-32.591, 210.2161, -63.7809>, <-32.3609, 210.0699, -63.7778> }
					triangle { <-32.7855, 209.0811, -66.9272>, <-32.8055, 209.5061, -67.2575>, <-33.4823, 209.6697, -67.381> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower petal
					triangle { <-33.4823, 209.6697, -67.381>, <-33.9977, 208.9286, -66.9085>, <-33.834, 209.4776, -66.7946> }
					triangle { <-33.9419, 208.5365, -66.4938>, <-34.2171, 209.1308, -65.763>, <-34.1126, 209.2857, -66.4551> }
					triangle { <-33.9977, 208.9286, -66.9085>, <-34.1126, 209.2857, -66.4551>, <-33.834, 209.4776, -66.7946> }
					triangle { <-33.9977, 208.9286, -66.9085>, <-33.9419, 208.5365, -66.4938>, <-34.1126, 209.2857, -66.4551> }
					triangle { <-33.9419, 208.5365, -66.4938>, <-33.7916, 208.3498, -65.7587>, <-34.2171, 209.1308, -65.763> }
					triangle { <-33.7916, 208.3498, -65.7587>, <-33.7532, 208.2861, -65.03309>, <-34.1962, 209.0303, -65.2315> }
					triangle { <-33.7916, 208.3498, -65.7587>, <-34.1962, 209.0303, -65.2315>, <-34.2171, 209.1308, -65.763> }
					triangle { <-33.7532, 208.2861, -65.03309>, <-33.7982, 208.2818, -64.2435>, <-34.06687, 208.8976, -64.1631> }
					triangle { <-33.7532, 208.2861, -65.03309>, <-34.06687, 208.8976, -64.1631>, <-34.1962, 209.0303, -65.2315> }
					triangle { <-33.7982, 208.2818, -64.2435>, <-35.1798, 209.0376, -64.05868>, <-34.9237, 209.165, -63.8882> }
					triangle { <-33.7982, 208.2818, -64.2435>, <-34.9237, 209.165, -63.8882>, <-34.06687, 208.8976, -64.1631> }
					triangle { <-34.06687, 208.8976, -64.1631>, <-34.9237, 209.165, -63.8882>, <-34.7062, 209.4342, -63.8088> }
					triangle { <-33.834, 209.4776, -66.7946>, <-34.1126, 209.2857, -66.4551>, <-33.9752, 209.3523, -65.7443> }
					triangle { <-34.1126, 209.2857, -66.4551>, <-34.2171, 209.1308, -65.763>, <-33.9752, 209.3523, -65.7443> }
					triangle { <-34.2171, 209.1308, -65.763>, <-34.1962, 209.0303, -65.2315>, <-33.9752, 209.3523, -65.7443> }
					triangle { <-34.1962, 209.0303, -65.2315>, <-34.04705, 209.3586, -64.1096>, <-33.9752, 209.3523, -65.7443> }
					triangle { <-34.1962, 209.0303, -65.2315>, <-34.06687, 208.8976, -64.1631>, <-34.04705, 209.3586, -64.1096> }
					triangle { <-34.06687, 208.8976, -64.1631>, <-34.7062, 209.4342, -63.8088>, <-34.04705, 209.3586, -64.1096> }
					triangle { <-34.7062, 209.4342, -63.8088>, <-34.4729, 209.7278, -63.7542>, <-34.04705, 209.3586, -64.1096> }
					triangle { <-33.4823, 209.6697, -67.381>, <-33.834, 209.4776, -66.7946>, <-33.8679, 209.9095, -66.7157> }
					triangle { <-33.834, 209.4776, -66.7946>, <-33.9752, 209.3523, -65.7443>, <-33.8679, 209.9095, -66.7157> }
					triangle { <-33.9752, 209.3523, -65.7443>, <-33.9238, 209.862, -65.7405>, <-33.8679, 209.9095, -66.7157> }
					triangle { <-33.9752, 209.3523, -65.7443>, <-34.04705, 209.3586, -64.1096>, <-33.9238, 209.862, -65.7405> }
					triangle { <-33.9238, 209.862, -65.7405>, <-34.04705, 209.3586, -64.1096>, <-34.02885, 209.8259, -64.1097> }
					triangle { <-34.04705, 209.3586, -64.1096>, <-34.4729, 209.7278, -63.7542>, <-34.02885, 209.8259, -64.1097> }
					triangle { <-34.4729, 209.7278, -63.7542>, <-34.3382, 210.0345, -63.7495>, <-34.02885, 209.8259, -64.1097> }
					triangle { <-33.4823, 209.6697, -67.381>, <-34.09353, 209.3441, -67.2376>, <-33.9977, 208.9286, -66.9085> }
					triangle { <-33.4354, 209.9863, -66.7469>, <-32.9347, 210.285, -66.7814>, <-33.4823, 209.6697, -67.381> }
					triangle { <-33.3485, 210.2607, -66.3638>, <-33.287, 210.3177, -65.6518>, <-32.58, 210.2744, -66.331> }
					triangle { <-33.4354, 209.9863, -66.7469>, <-33.3485, 210.2607, -66.3638>, <-32.9347, 210.285, -66.7814> }
					triangle { <-33.3485, 210.2607, -66.3638>, <-32.58, 210.2744, -66.331>, <-32.9347, 210.285, -66.7814> }
					triangle { <-33.287, 210.3177, -65.6518>, <-32.4297, 210.0877, -65.5959>, <-32.58, 210.2744, -66.331> }
					triangle { <-33.2329, 210.2595, -65.1163>, <-32.4244, 209.9816, -64.8742>, <-32.4297, 210.0877, -65.5959> }
					triangle { <-33.287, 210.3177, -65.6518>, <-33.2329, 210.2595, -65.1163>, <-32.4297, 210.0877, -65.5959> }
					triangle { <-33.1699, 210.042, -64.05589>, <-32.5026, 209.9349, -64.08862>, <-32.4244, 209.9816, -64.8742> }
					triangle { <-33.2329, 210.2595, -65.1163>, <-33.1699, 210.042, -64.05589>, <-32.4244, 209.9816, -64.8742> }
					triangle { <-33.7428, 210.6635, -63.6936>, <-33.5658, 210.9186, -63.8594>, <-32.5026, 209.9349, -64.08862> }
					triangle { <-33.1699, 210.042, -64.05589>, <-33.7428, 210.6635, -63.6936>, <-32.5026, 209.9349, -64.08862> }
					triangle { <-34.00987, 210.4929, -63.6784>, <-33.7428, 210.6635, -63.6936>, <-33.1699, 210.042, -64.05589> }
					triangle { <-33.4437, 210.0305, -65.6808>, <-33.3485, 210.2607, -66.3638>, <-33.4354, 209.9863, -66.7469> }
					triangle { <-33.4437, 210.0305, -65.6808>, <-33.287, 210.3177, -65.6518>, <-33.3485, 210.2607, -66.3638> }
					triangle { <-33.4437, 210.0305, -65.6808>, <-33.2329, 210.2595, -65.1163>, <-33.287, 210.3177, -65.6518> }
					triangle { <-33.4437, 210.0305, -65.6808>, <-33.6152, 209.9096, -64.05799>, <-33.2329, 210.2595, -65.1163> }
					triangle { <-33.6152, 209.9096, -64.05799>, <-33.1699, 210.042, -64.05589>, <-33.2329, 210.2595, -65.1163> }
					triangle { <-33.6152, 209.9096, -64.05799>, <-34.00987, 210.4929, -63.6784>, <-33.1699, 210.042, -64.05589> }
					triangle { <-33.6152, 209.9096, -64.05799>, <-34.1925, 210.2598, -63.7002>, <-34.00987, 210.4929, -63.6784> }
					triangle { <-33.8679, 209.9095, -66.7157>, <-33.4354, 209.9863, -66.7469>, <-33.4823, 209.6697, -67.381> }
					triangle { <-33.8679, 209.9095, -66.7157>, <-33.4437, 210.0305, -65.6808>, <-33.4354, 209.9863, -66.7469> }
					triangle { <-33.8679, 209.9095, -66.7157>, <-33.9238, 209.862, -65.7405>, <-33.4437, 210.0305, -65.6808> }
					triangle { <-33.9238, 209.862, -65.7405>, <-33.6152, 209.9096, -64.05799>, <-33.4437, 210.0305, -65.6808> }
					triangle { <-34.02885, 209.8259, -64.1097>, <-33.6152, 209.9096, -64.05799>, <-33.9238, 209.862, -65.7405> }
					triangle { <-34.02885, 209.8259, -64.1097>, <-34.1925, 210.2598, -63.7002>, <-33.6152, 209.9096, -64.05799> }
					triangle { <-34.02885, 209.8259, -64.1097>, <-34.3382, 210.0345, -63.7495>, <-34.1925, 210.2598, -63.7002> }
					triangle { <-32.9347, 210.285, -66.7814>, <-33.3295, 210.319, -67.1462>, <-33.4823, 209.6697, -67.381> }
					pigment { rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		union { // inflor. internode
			cylinder { <-33.4242, 209.0234, -68.4578>, <-33.611, 209.9413, -68.8077>, 0.55 }
			cylinder { <-33.611, 209.9413, -68.8077>, <-33.7964, 210.8714, -69.125>, 0.55 }
			cylinder { <-33.7964, 210.8714, -69.125>, <-33.9803, 211.8123, -69.4094>, 0.55 }
			pigment { color rgb <0.19, 0.52, 0.19> }}
		union { // pedicel and flower/fruit
			union { // pedicel
				cylinder { <-33.9803, 211.8123, -69.4094>, <-33.8343, 212.1371, -69.7603>, 0.55 }
				cylinder { <-33.8343, 212.1371, -69.7603>, <-33.5211, 212.1586, -70.1495>, 0.55 }
				cylinder { <-33.5211, 212.1586, -70.1495>, <-33.1929, 211.8664, -70.388>, 0.55 }
				pigment { color rgb <0.19, 0.54, 0.19> }}
			union { // flower bud
				mesh { // flower bud petal
					triangle { <-33.1929, 211.8664, -70.388>, <-32.7596, 209.6891, -71.6833>, <-31.7794, 210.579, -71.3949> }
					triangle { <-31.7794, 210.579, -71.3949>, <-32.7596, 209.6891, -71.6833>, <-31.5382, 208.1032, -72.689> }
					triangle { <-31.7794, 210.579, -71.3949>, <-31.5382, 208.1032, -72.689>, <-30.2877, 209.109, -72.316> }
					triangle { <-31.5382, 208.1032, -72.689>, <-28.9985, 207.4691, -72.9108>, <-30.2877, 209.109, -72.316> }
					triangle { <-31.7794, 210.579, -71.3949>, <-30.7624, 211.0005, -70.7099>, <-33.1929, 211.8664, -70.388> }
					triangle { <-30.7624, 211.0005, -70.7099>, <-31.7794, 210.579, -71.3949>, <-30.2877, 209.109, -72.316> }
					triangle { <-29.2144, 209.5552, -71.4618>, <-30.7624, 211.0005, -70.7099>, <-30.2877, 209.109, -72.316> }
					triangle { <-29.2144, 209.5552, -71.4618>, <-30.2877, 209.109, -72.316>, <-28.9985, 207.4691, -72.9108> }
					pigment { color rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower bud petal
					triangle { <-33.1929, 211.8664, -70.388>, <-32.3277, 210.8361, -72.578>, <-31.8106, 210.5234, -71.3652> }
					triangle { <-31.8106, 210.5234, -71.3652>, <-32.3277, 210.8361, -72.578>, <-31.1152, 209.4607, -73.8651> }
					triangle { <-31.8106, 210.5234, -71.3652>, <-31.1152, 209.4607, -73.8651>, <-30.4839, 208.9861, -72.4192> }
					triangle { <-31.1152, 209.4607, -73.8651>, <-29.5649, 207.3663, -73.5314>, <-30.4839, 208.9861, -72.4192> }
					triangle { <-31.8106, 210.5234, -71.3652>, <-31.6716, 209.7586, -70.3274>, <-33.1929, 211.8664, -70.388> }
					triangle { <-31.6716, 209.7586, -70.3274>, <-31.8106, 210.5234, -71.3652>, <-30.4839, 208.9861, -72.4192> }
					triangle { <-30.4401, 208.127, -71.2612>, <-31.6716, 209.7586, -70.3274>, <-30.4839, 208.9861, -72.4192> }
					triangle { <-30.4401, 208.127, -71.2612>, <-30.4839, 208.9861, -72.4192>, <-29.5649, 207.3663, -73.5314> }
					pigment { color rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower bud petal
					triangle { <-33.1929, 211.8664, -70.388>, <-31.1547, 211.5381, -71.919>, <-31.8627, 210.5023, -71.4073> }
					triangle { <-31.8627, 210.5023, -71.4073>, <-31.1547, 211.5381, -71.919>, <-29.6869, 210.4019, -73.1731> }
					triangle { <-31.8627, 210.5023, -71.4073>, <-29.6869, 210.4019, -73.1731>, <-30.5413, 209.0983, -72.6391> }
					triangle { <-29.6869, 210.4019, -73.1731>, <-29.4296, 207.9634, -74.1159>, <-30.5413, 209.0983, -72.6391> }
					triangle { <-31.8627, 210.5023, -71.4073>, <-32.7404, 209.5507, -71.4805>, <-33.1929, 211.8664, -70.388> }
					triangle { <-32.7404, 209.5507, -71.4805>, <-31.8627, 210.5023, -71.4073>, <-30.5413, 209.0983, -72.6391> }
					triangle { <-31.5872, 208.1131, -72.7668>, <-32.7404, 209.5507, -71.4805>, <-30.5413, 209.0983, -72.6391> }
					triangle { <-31.5872, 208.1131, -72.7668>, <-30.5413, 209.0983, -72.6391>, <-29.4296, 207.9634, -74.1159> }
					pigment { color rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower bud petal
					triangle { <-33.1929, 211.8664, -70.388>, <-30.8509, 210.8315, -70.6109>, <-31.8642, 210.5446, -71.4635> }
					triangle { <-31.8642, 210.5446, -71.4635>, <-30.8509, 210.8315, -70.6109>, <-29.2138, 209.6349, -71.563> }
					triangle { <-31.8642, 210.5446, -71.4635>, <-29.2138, 209.6349, -71.563>, <-30.3811, 209.2917, -72.6738> }
					triangle { <-29.2138, 209.6349, -71.563>, <-28.7782, 208.4407, -73.862>, <-30.3811, 209.2917, -72.6738> }
					triangle { <-31.8642, 210.5446, -71.4635>, <-32.5017, 210.6621, -72.5864>, <-33.1929, 211.8664, -70.388> }
					triangle { <-32.5017, 210.6621, -72.5864>, <-31.8642, 210.5446, -71.4635>, <-30.3811, 209.2917, -72.6738> }
					triangle { <-31.08111, 209.5327, -73.9119>, <-32.5017, 210.6621, -72.5864>, <-30.3811, 209.2917, -72.6738> }
					triangle { <-31.08111, 209.5327, -73.9119>, <-30.3811, 209.2917, -72.6738>, <-28.7782, 208.4407, -73.862> }
					pigment { color rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				mesh { // flower bud petal
					triangle { <-33.1929, 211.8664, -70.388>, <-31.8577, 209.6715, -70.4631>, <-31.812, 210.5927, -71.4557> }
					triangle { <-31.812, 210.5927, -71.4557>, <-31.8577, 209.6715, -70.4631>, <-30.3752, 208.1928, -71.2593> }
					triangle { <-31.812, 210.5927, -71.4557>, <-30.3752, 208.1928, -71.2593>, <-30.222, 209.2984, -72.4712> }
					triangle { <-30.3752, 208.1928, -71.2593>, <-28.5078, 208.1306, -73.106>, <-30.222, 209.2984, -72.4712> }
					triangle { <-31.812, 210.5927, -71.4557>, <-31.2608, 211.5717, -72.1029>, <-33.1929, 211.8664, -70.388> }
					triangle { <-31.2608, 211.5717, -72.1029>, <-31.812, 210.5927, -71.4557>, <-30.222, 209.2984, -72.4712> }
					triangle { <-29.5924, 210.4374, -73.09326>, <-31.2608, 211.5717, -72.1029>, <-30.222, 209.2984, -72.4712> }
					triangle { <-29.5924, 210.4374, -73.09326>, <-30.222, 209.2984, -72.4712>, <-28.5078, 208.1306, -73.106> }
					pigment { color rgbt <0.3, 0.25, 0.98,0.2>*2 }}
				}
			}
		}
} // end snapdragon

