

#version unofficial megapov 0.4;


#include "blruins2.inc"  //materials


default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

global_settings {
  adc_bailout 0.003922
 // ambient_light <0, 0, 0>   
  ambient_light<1 ,1 ,1>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {    
        pretrace_start 0.08
        pretrace_end   0.02
        count 150             // CHANGE range from 20 to 150
        nearest_count 10  // 5      // CHANGE range from 3 to 10    
        
        error_bound 0.5           // CHANGE - range from 1 to 3 - should correspond with pretrace_end
                                //   1 : pretrace_end = 0.02
                                //   3 : pretrace_end = 0.08
                                //   use pretrace_start = 0.08
                                // you can go lower than 1, but then you probably will want to set
                                // pretrace_end to 0.01, which is really slow   
                                
        recursion_limit 4    // CHANGE
    
        low_error_factor .5  // leave this
        gray_threshold 0.0   // leave this
        minimum_reuse 0.015  // leave this
        brightness 1         // leave this
    
        adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object 
        }
}       



 
camera {  //  Camera Final
  location  <     68.958,      37.302,      12.879>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.34708,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         30.00874    // Vertical      22.507
  look_at   <    150.644,     163.503,     -50.560>
}
 
  

//    this works ok
light_source {   // RoomLight
  <0.0, 0.0, 0.0>        
  color rgb < 1, 1, 0.9 >
  translate  <50, 50, 113>     //< 0.347803, 0.402307, 113.485385 >
}

 //comment this out until final render coz it takes tooooooo long
light_source { //extra light for softer shadows.  directly above desk
        <0, 0, 0>                   
        color rgb < 1, 1, 0.9> * 0.1        
        translate <    150.644,     163.503,     115>
        shadowless
                  }  



//******************************************************************************************************




difference { // ChairScrew1
  sphere { // ChairScrewRoundBit
    <0,0,0>,1
    scale <0.230007, 0.5, 0.5>
  }
  box { // ChairScrewCutout1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.156735, 0.068222, 0.595754>
    translate  <-0.186754, -0.011463, -0.009625>
  }
  box { // ChairScrewCutout2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.156735, 0.068222, 0.595754>
    rotate <-90.0, 0.0, -0.0>
    translate  <-0.167751, -0.011463, -0.009625>
  }
  material {
    Aluminum
  }
  translate  <141.108069, 105.942705, -46.630146>
}

      
      
plane { // Floor
  z,0
  material {
    mCarpet
  }
  translate  <0.0, 0.000034, -119.999005>
}
                  
                  

#declare FloppyBit = difference {
  box { // DiskInside
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot = union {
  box { // ReadSlotLongBit
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside = difference {
  box { // DiskCase
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout1
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot }
  cylinder { // BottomNotchLeft
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerGreen
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk = union {
  object { FloppyBit }
  object { DiskOutside }
  object { Sticker }
}
union { // FloppyDisk1
  object { Disk }
  rotate 28.002497*z
  translate  <185.13331, 138.239009, -59.418932>
}
 
 

//***************************************** room box ********************************************
/*
box { // Room
  <-1, -1, -1>, <1, 1, 1> 
  
  pigment {color rgb <0.9479, 0.854167, 0.791667>}  
  //material { YukkySortOfWhiteWallPaint }            
  hollow
  scale <200.0, 200.0, 120.0>
}
*/

//******************************************* desk *************************************************

union { // Desk
  box { // DeskTop
    <-1, -1, -1>, <1, 1, 1>
    scale <43.580639, 36.165897, 1.0>
    translate  <7.336416, 3.089243, 0.0>
  }
  box { // DeskLeftSide
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 32.0, 1.0>
    rotate -90.0*y
    translate  <-32.755599, 7.36739, -29.49804>
  }
  box { // DeskRightSide
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 32.0, 1.0>
    rotate -90.0*y
    translate  <46.589921, 7.36739, -29.49804>
  }
  box { // DeskShelf
    <-1, -1, -1>, <1, 1, 1>
    scale <39.435215, 26.38471, 1.0>
    translate  <7.336416, 12.868489, -22.745676>
  }
  material {
    DeskWhite
  }
  translate  <146.901289, 158.305949, -60.498496>
}

  
  
  
 //****************************************** computer *********************************************
 
#declare BottomCase = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.200021, -1.999989>,
  <22.299927, -1.999601>,
  <23.464405, -1.382206>,
  <17.986771, -0.004889>,
  <0.000016, -0.000013>,
  <0.200021, -1.999989>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0, 1.0, 40.799999>
  rotate <90.0, 0.0, -90.0>
  translate  <20.529403, 10.509309, -1.295853>
}
#declare MiddleCase = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  12  // control points
  <0.200307, -1.199993>,
  <17.500347, -1.200157>,
  <23.430012, -2.630795>,
  <23.657066, -2.628916>,
  <23.865777, -2.55445>,
  <24.045539, -2.435646>,
  <24.194221, -2.268908>,
  <24.290175, -2.128533>,
  <24.349858, -2.000143>,
  <16.200306, -0.000159>,
  <0.000004, -0.0>,
  <0.200307, -1.199993>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0, 1.0, 41.200001>
  rotate <90.0, 0.0, -90.0>
  translate  <20.72822, 10.731504, -0.099397>
}
#declare CommodoreKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mCommodore
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-14.998706, -7.367473, 0.951592>
}
#declare LeftShiftKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mShift
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <-12.628916, -7.361121, 0.932285>
}
#declare RunStopKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mRunStop
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-15.007689, -5.513597, 1.365962>
}
#declare Xkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mX
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-8.37862, -7.360028, 0.951592>
}
#declare Ckey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mC
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219411>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-6.47862, -7.360028, 0.951592>
}
#declare Vkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mV
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-4.57862, -7.360028, 0.951592>
}
#declare Bkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mB
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-2.67862, -7.360028, 0.951592>
}
#declare Nkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mN
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-0.77862, -7.360028, 0.951592>
}
#declare Mkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mM
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <1.12138, -7.360028, 0.951592>
}
#declare CommaKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mComma
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <3.02138, -7.360028, 0.951592>
}
#declare FullStopKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mFullStop
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <4.92138, -7.360028, 0.951592>
}
#declare QuestionMarkKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mQuestionMark
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <6.82138, -7.360028, 0.951592>
}
#declare RightShiftKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mShift
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <9.17206, -7.361121, 0.932285>
}
#declare LeftCursorKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mLeftCrsr
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <11.53028, -7.359347, 0.951592>
}
#declare RightCursorKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mRightCrsr
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <13.43028, -7.359347, 0.951592>
}
#declare Zkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mZ
    rotate <14.695726, 0.0, 90.0>
    translate <0.692541, -0.497011, 0.219409>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-10.27862, -7.360028, 0.951592>
}
#declare Key1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m1
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-12.632807, -1.786255, 2.225114>
}
#declare Key2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m2
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-10.72634, -1.786255, 2.225114>
}
#declare Key3 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m3
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-8.82634, -1.792722, 2.225114>
}
#declare Key4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m4
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-6.92634, -1.799189, 2.225114>
}
#declare Key5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m5
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-5.02634, -1.812124, 2.225114>
}
#declare Key6 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m6
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-3.12634, -1.818592, 2.225114>
}
#declare Key7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m7
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-1.22634, -1.831527, 2.225114>
}
#declare Key8 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m8
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <0.67366, -1.831527, 2.225114>
}
#declare Key9 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m9
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <2.57366, -1.837994, 2.225114>
}
#declare Key0 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    m0
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <4.47366, -1.844461, 2.225114>
}
#declare PlusKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mPlus
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <6.37366, -1.850929, 2.225114>
}
#declare MinusKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mMinus
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <8.27366, -1.850929, 2.225114>
}
#declare PoundKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mPound
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <10.17366, -1.844461, 2.225114>
}
#declare ClrHomeKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mClrHome
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <12.07366, -1.844461, 2.225114>
}
#declare InstDelKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mInstDel
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <13.97366, -1.844461, 2.225114>
}
#declare ArrowKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mBackArrow
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-14.52634, -1.786255, 2.225114>
}
#declare ReturnKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mReturn
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 3.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <12.542088, -5.510622, 1.367059>
}
#declare CTRLkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mCtrl
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <-14.075981, -3.652569, 1.788533>
}
#declare Qkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mQ
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-11.703881, -3.659186, 1.787408>
}
#declare Wkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mW
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-9.803881, -3.653567, 1.787408>
}
#declare Ekey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mE
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-7.903881, -3.659186, 1.787408>
}
#declare Rkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mR
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-6.003881, -3.659186, 1.787408>
}
#declare Tkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mT
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-4.103881, -3.659186, 1.787408>
}
#declare Ykey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mY
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-2.203881, -3.653567, 1.787408>
}
#declare Ukey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mU
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-0.303881, -3.653567, 1.787408>
}
#declare Ikey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mI
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <1.596119, -3.659186, 1.787408>
}
#declare Okey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mO
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <3.496119, -3.653567, 1.787408>
}
#declare Pkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mP
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <5.396119, -3.659186, 1.787408>
}
#declare AtKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mAt
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <7.296119, -3.659186, 1.787408>
}
#declare AsteriskKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mAsterisk
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <9.196119, -3.659186, 1.787408>
}
#declare UpArrowKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mUpArrow
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <11.096119, -3.659186, 1.787408>
}
#declare RestoreKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mRestore
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <13.486129, -3.6573, 1.788504>
}
#declare ShiftLockKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mShiftLock
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-13.093596, -5.513597, 1.365962>
}
#declare Akey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mA
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-11.207689, -5.513597, 1.365962>
}
#declare Skey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mS
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-9.307689, -5.513597, 1.365962>
}
#declare Dkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mD
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-7.407689, -5.513597, 1.365962>
}
#declare Fkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mF
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-5.507689, -5.513597, 1.365962>
}
#declare Gkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mG
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-3.607689, -5.513597, 1.365962>
}
#declare Hkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mH
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <-1.707689, -5.513597, 1.365962>
}
#declare Jkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mJ
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <0.192311, -5.513597, 1.365962>
}
#declare Kkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mK
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <2.092311, -5.513597, 1.365962>
}
#declare Lkey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mL
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <3.992311, -5.513597, 1.365962>
}
#declare ColonKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mColon
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <5.892311, -5.513597, 1.365962>
}
#declare SemiColonKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mSemiColon
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <7.792311, -5.513597, 1.365962>
}
#declare EqualKey = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mEqual
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale 1.8
  rotate <-0.0, 12.671583, -90.0>
  translate  <9.692311, -5.513597, 1.365962>
}
#declare SpaceBar = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -5.701791, 0.325375>, <0.302950, -5.624836, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -5.724836, 0.160300>, <0.342360, -5.647881, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -5.793970, -0.334925>, <0.460590, -5.693970, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -5.817015, -0.500000>, <0.500000, -5.717015, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -5.817015, -0.500000>, <-0.300000, -5.817015, -0.500000>, <0.300000, -5.817015, -0.500000>, <0.500000, -5.817015, -0.500000>, 
      <-0.500000, -5.717015, -0.500000>, <-0.300000, -5.717015, -0.500000>, <0.300000, -5.717015, -0.500000>, <0.500000, -5.717015, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -5.701791, 0.108567>, <-0.287753, -5.701791, 0.151929>, <0.155274, -5.701791, 0.282013>, <0.302950, -5.701791, 0.325375>, 
      <-0.448343, -5.724836, -0.013146>, <-0.300667, -5.724836, 0.030215>, <0.194684, -5.724836, 0.116938>, <0.342360, -5.724836, 0.160300>, 
      <-0.487086, -5.793970, -0.378287>, <-0.287086, -5.793970, -0.378287>, <0.260590, -5.793970, -0.334925>, <0.460590, -5.793970, -0.334925>, 
      <-0.500000, -5.817015, -0.500000>, <-0.300000, -5.817015, -0.500000>, <0.300000, -5.817015, -0.500000>, <0.500000, -5.817015, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -5.701791, 0.108567>, <-0.448343, -5.724836, -0.013146>, <-0.487086, -5.793970, -0.378287>, <-0.500000, -5.817015, -0.500000>, 
      <-0.435429, -5.624836, 0.108567>, <-0.448343, -5.647881, -0.013146>, <-0.487086, -5.693970, -0.378287>, <-0.500000, -5.717015, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -5.701791, 0.108567>, <-0.435429, -5.624836, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -5.701791, 0.151929>, <-0.287753, -5.624836, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -5.701791, 0.282013>, <0.155274, -5.624836, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -5.701791, 0.325375>, <0.302950, -5.624836, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <4.992794, -9.279721, 0.508587>
}
#declare F1key = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mF1key
    rotate <14.596, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <18.456157, -1.855886, 2.22256>
}
#declare F3key = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mF3key
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <18.475505, -3.66596, 1.788504>
}
#declare F5key = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mF5key
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <18.456157, -5.508186, 1.370525>
}
#declare F7key = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>, 
      <0.342360, -0.407820, 0.160300>, <0.342360, -0.330865, 0.160300>, <0.342360, 0.253910, 0.160300>, <0.342360, 0.407820, 0.160300>, 
      <0.460590, -0.476955, -0.334925>, <0.460590, -0.376955, -0.334925>, <0.460590, 0.276955, -0.334925>, <0.460590, 0.476955, -0.334925>, 
      <0.500000, -0.500000, -0.500000>, <0.500000, -0.400000, -0.500000>, <0.500000, 0.300000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>, 
      <-0.500000, -0.400000, -0.500000>, <-0.300000, -0.400000, -0.500000>, <0.300000, -0.400000, -0.500000>, <0.500000, -0.400000, -0.500000>, 
      <-0.500000, 0.300000, -0.500000>, <-0.300000, 0.300000, -0.500000>, <0.300000, 0.300000, -0.500000>, <0.500000, 0.300000, -0.500000>, 
      <-0.500000, 0.500000, -0.500000>, <-0.300000, 0.500000, -0.500000>, <0.300000, 0.500000, -0.500000>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>, 
      <-0.287753, 0.384775, 0.151929>, <-0.300667, 0.407820, 0.030215>, <-0.287086, 0.476955, -0.378287>, <-0.300000, 0.500000, -0.500000>, 
      <0.155274, 0.384775, 0.282013>, <0.194684, 0.407820, 0.116938>, <0.260590, 0.476955, -0.334925>, <0.300000, 0.500000, -0.500000>, 
      <0.302950, 0.384775, 0.325375>, <0.342360, 0.407820, 0.160300>, <0.460590, 0.476955, -0.334925>, <0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.287753, -0.384775, 0.151929>, <0.155274, -0.384775, 0.282013>, <0.302950, -0.384775, 0.325375>, 
      <-0.448343, -0.407820, -0.013146>, <-0.300667, -0.407820, 0.030215>, <0.194684, -0.407820, 0.116938>, <0.342360, -0.407820, 0.160300>, 
      <-0.487086, -0.476955, -0.378287>, <-0.287086, -0.476955, -0.378287>, <0.260590, -0.476955, -0.334925>, <0.460590, -0.476955, -0.334925>, 
      <-0.500000, -0.500000, -0.500000>, <-0.300000, -0.500000, -0.500000>, <0.300000, -0.500000, -0.500000>, <0.500000, -0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.448343, -0.407820, -0.013146>, <-0.487086, -0.476955, -0.378287>, <-0.500000, -0.500000, -0.500000>, 
      <-0.435429, -0.307820, 0.108567>, <-0.448343, -0.330865, -0.013146>, <-0.487086, -0.376955, -0.378287>, <-0.500000, -0.400000, -0.500000>, 
      <-0.435429, 0.230865, 0.108567>, <-0.448343, 0.253910, -0.013146>, <-0.487086, 0.276955, -0.378287>, <-0.500000, 0.300000, -0.500000>, 
      <-0.435429, 0.384775, 0.108567>, <-0.448343, 0.407820, -0.013146>, <-0.487086, 0.476955, -0.378287>, <-0.500000, 0.500000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.435429, -0.384775, 0.108567>, <-0.435429, -0.307820, 0.108567>, <-0.435429, 0.230865, 0.108567>, <-0.435429, 0.384775, 0.108567>, 
      <-0.287753, -0.384775, 0.151929>, <-0.287753, -0.307820, 0.151929>, <-0.287753, 0.230865, 0.151929>, <-0.287753, 0.384775, 0.151929>, 
      <0.155274, -0.384775, 0.282013>, <0.155274, -0.307820, 0.282013>, <0.155274, 0.230865, 0.282013>, <0.155274, 0.384775, 0.282013>, 
      <0.302950, -0.384775, 0.325375>, <0.302950, -0.307820, 0.325375>, <0.302950, 0.230865, 0.325375>, <0.302950, 0.384775, 0.325375>
    }
  }
  material {
    mF7Key
    rotate <14.695, 0.0, 90.0>
    translate <0.692540, -0.497000, 0.219410>
  }
  scale <1.8, 2.7, 1.8>
  rotate <0.0, 12.67158, -90.0>
  translate  <18.456157, -7.366488, 0.944508>
}
#declare Keys = union {
  object { CommodoreKey }
  object { LeftShiftKey }
  object { RunStopKey }
  object { Xkey }
  object { Ckey }
  object { Vkey }
  object { Bkey }
  object { Nkey }
  object { Mkey }
  object { CommaKey }
  object { FullStopKey }
  object { QuestionMarkKey }
  object { RightShiftKey }
  object { LeftCursorKey }
  object { RightCursorKey }
  object { Zkey }
  object { Key1 }
  object { Key2 }
  object { Key3 }
  object { Key4 }
  object { Key5 }
  object { Key6 }
  object { Key7 }
  object { Key8 }
  object { Key9 }
  object { Key0 }
  object { PlusKey }
  object { MinusKey }
  object { PoundKey }
  object { ClrHomeKey }
  object { InstDelKey }
  object { ArrowKey }
  object { ReturnKey }
  object { CTRLkey }
  object { Qkey }
  object { Wkey }
  object { Ekey }
  object { Rkey }
  object { Tkey }
  object { Ykey }
  object { Ukey }
  object { Ikey }
  object { Okey }
  object { Pkey }
  object { AtKey }
  object { AsteriskKey }
  object { UpArrowKey }
  object { RestoreKey }
  object { ShiftLockKey }
  object { Akey }
  object { Skey }
  object { Dkey }
  object { Fkey }
  object { Gkey }
  object { Hkey }
  object { Jkey }
  object { Kkey }
  object { Lkey }
  object { ColonKey }
  object { SemiColonKey }
  object { EqualKey }
  object { SpaceBar }
  object { F1key }
  object { F3key }
  object { F5key }
  object { F7key }
  material {
    YukkyGreyPlastic
  }
}
#declare Keyboard = union {
  object { Keys }
  box { // BlackKeyBase
    <-1, -1, -1>, <1, 1, 1>
    material {
      ReallyBlack
    }
    scale <18.600311, 5.388345, 0.217953>
    rotate 12.89056*x
    translate  <2.098572, -5.482581, 0.120315>
  }
  translate  -1.747307*x
}
#declare TopCase = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  49  // control points
  <-0.00025, 0.000057>,
  <16.2, -0.000001>,
  <24.400034, -2.000102>,
  <24.399158, -1.762513>,
  <24.348153, -1.547943>,
  <24.290182, -1.400467>,
  <24.192493, -1.233474>,
  <24.066618, -1.115807>,
  <23.899585, -1.000433>,
  <9.799736, 2.200231>,
  <7.799954, 1.000051>,
  <7.499932, 0.99998>,
  <7.500031, 0.700059>,
  <7.199955, 0.699998>,
  <7.19997, 1.000016>,
  <6.900001, 0.999997>,
  <6.899958, 0.700028>,
  <6.599968, 0.700007>,
  <6.599954, 1.000023>,
  <6.300022, 1.000004>,
  <6.300029, 0.699952>,
  <5.99998, 0.700024>,
  <5.999967, 1.000029>,
  <5.700024, 0.999926>,
  <5.699941, 0.70001>,
  <5.399924, 0.699952>,
  <5.39992, 0.999998>,
  <5.099993, 0.999992>,
  <5.100001, 0.699983>,
  <4.799985, 0.699964>,
  <4.799975, 0.999981>,
  <4.499997, 0.999974>,
  <4.500024, 0.699999>,
  <4.199984, 0.700015>,
  <4.19993, 1.000002>,
  <3.899991, 0.999996>,
  <3.89998, 0.700027>,
  <3.599976, 0.699984>,
  <3.599946, 1.000001>,
  <3.300008, 0.999998>,
  <3.300033, 0.699995>,
  <2.999988, 0.700011>,
  <2.999975, 0.999984>,
  <2.699983, 0.999981>,
  <2.70006, 0.70001>,
  <2.399748, 0.699935>,
  <2.399986, 0.999945>,
  <0.200022, 0.999899>,
  <-0.00025, 0.000057>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0, 1.0, 41.200001>
  rotate <90.0, 0.0, -90.0>
  translate  <20.728216, 10.734255, 0.0>
}
#declare KeyboardHoleCutOut = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <0.499949, -3.799962>,
  <0.000005, -3.799897>,
  <-0.000186, -7.801087>,
  <5.200936, -7.80082>,
  <5.199946, -9.699953>,
  <22.500606, -9.699061>,
  <22.500001, -7.799999>,
  <30.501014, -7.798932>,
  <30.500228, -3.800005>,
  <30.999994, -3.800024>,
  <31.000024, -0.000004>,
  <0.499909, 0.000024>,
  <0.499949, -3.799962>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0, 1.0, 1.5>
  rotate 12.97*x
  translate  <-17.771128, -0.586446, 1.016227>
}
#declare TopWithHole = difference {
  object { TopCase }
  object { KeyboardHoleCutOut }
  box { // FunctionKeysCutOut
    <-1, -1, -1>, <1, 1, 1>
    material {
      YukkyGreyPlastic
    }
    scale <1.5, 3.8, 1.0>
    rotate <12.939349, 0.0, -0.0>
    translate  <16.728216, -4.5974, 0.739644>
  }
  box { // CompLedCutOut
    <-1, -1, -1>, <1, 1, 1>
    material {
      YukkyGreyPlastic
    }
    scale <1.05, 0.2, 0.2>
    rotate <13.138309, -0.0, 0.0>
    translate  <-16.235988, 0.647574, 2.244205>
  }
}
#declare Label = merge {
  sphere { <0.4450, 0.4450, 0.4450>, 0.0550 }
  sphere { <0.4450, -0.4450, 0.4450>, 0.0550 }
  sphere { <-0.4450, -0.4450, 0.4450>, 0.0550 }
  sphere { <-0.4450, 0.4450, 0.4450>, 0.0550 }
  sphere { <0.4450, 0.4450, -0.4450>, 0.0550 }
  sphere { <0.4450, -0.4450, -0.4450>, 0.0550 }
  sphere { <-0.4450, -0.4450, -0.4450>, 0.0550 }
  sphere { <-0.4450, 0.4450, -0.4450>, 0.0550 }
  cylinder { <0.4450, 0.4450, 0.4450>, <-0.4450, 0.4450, 0.4450>, 0.0550 }
  cylinder { <0.4450, -0.4450, 0.4450>, <-0.4450, -0.4450, 0.4450>, 0.0550 }
  cylinder { <0.4450, -0.4450, -0.4450>, <-0.4450, -0.4450, -0.4450>, 0.0550 }
  cylinder { <0.4450, 0.4450, -0.4450>, <-0.4450, 0.4450, -0.4450>, 0.0550 }
  cylinder { <0.4450, 0.4450, -0.4450>, <0.4450, 0.4450, 0.4450>, 0.0550 }
  cylinder { <0.4450, -0.4450, -0.4450>, <0.4450, -0.4450, 0.4450>, 0.0550 }
  cylinder { <-0.4450, -0.4450, -0.4450>, <-0.4450, -0.4450, 0.4450>, 0.0550 }
  cylinder { <-0.4450, 0.4450, -0.4450>, <-0.4450, 0.4450, 0.4450>, 0.0550 }
  cylinder { <0.4450, 0.4450, 0.4450>, <0.4450, -0.4450, 0.4450>, 0.0550 }
  cylinder { <0.4450, 0.4450, -0.4450>, <0.4450, -0.4450, -0.4450>, 0.0550 }
  cylinder { <-0.4450, 0.4450, -0.4450>, <-0.4450, -0.4450, -0.4450>, 0.0550 }
  cylinder { <-0.4450, 0.4450, 0.4450>, <-0.4450, -0.4450, 0.4450>, 0.0550 }
  box { <-0.4450, -0.4450, -0.5000> <0.4450, 0.4450, 0.5000> }
  box { <-0.4450, -0.5000, -0.4450> <0.4450, 0.5000, 0.4450> }
  box { <-0.5000, -0.4450, -0.4450> <0.5000, 0.4450, 0.4450> }
// Attributes returned success!
  material {
    mComputerLabel
    translate <-0.495947, -0.471373, 1.285428>
  }
  scale <7.7, 1.2, 0.1>
  rotate 12.80297*x
  translate  <14.308938, -10.568896, -0.428478>
}
union { // Computer
  object { BottomCase }
  object { MiddleCase }
  object { Keyboard }
  object { TopWithHole }
  text {   // CompLedText
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "POWER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      YukkyGreyPlastic
    }
    scale 0.335364
    rotate <14.072846, 0.0, 0.0>
    translate  <-16.642226, 0.660224, 1.74644>
  }

  object { Label }
  box { // CompLed
    <-1, -1, -1>, <1, 1, 1>
    material {
      mGreenLed
    }
    scale <0.1, 0.2, 0.05>
    rotate <-0.0, 13.092609, -90.0>
    translate  <-16.941913, 0.712076, 2.046423>
  }
  translate  <154.259863, 143.222986, -56.20688>
}



//*********************************************** tv ***************************************************

#declare Speaker = union {
  box { // SpeakerGrille1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -10.824399>
  }
  box { // SpeakerGrille2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -10.324399>
  }
  box { // SpeakerGrille3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -9.824399>
  }
  box { // SpeakerGrille4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -9.324399>
  }
  box { // SpeakerGrille5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -8.824399>
  }
  box { // SpeakerGrille6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -8.324399>
  }
  box { // SpeakerGrille7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -7.824399>
  }
  box { // SpeakerGrille8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -7.324399>
  }
  box { // SpeakerGrille9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -6.824399>
  }
  box { // SpeakerGrille10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -6.324399>
  }
  box { // SpeakerGrille11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -5.824399>
  }
  box { // SpeakerGrille12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -5.324399>
  }
  box { // SpeakerGrille13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -4.824399>
  }
  box { // SpeakerGrille14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    translate  <-17.026418, 7.57202, -4.324399>
  }
  box { // SpeakerBar1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    rotate -90.0*x
    translate  <-16.975537, 8.768119, -7.569443>
  }
  box { // SpeakerBar2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.7, 0.1>
    rotate -90.0*x
    translate  <-16.958576, 6.375922, -7.569443>
  }
  material {
    TVblack
  }
  translate  <-0.814106, 0.0, -0.033921>
}
#declare Tube = difference {
  box { // MainTubeBit
    <-1, -1, -1>, <1, 1, 1>
    scale <11.5, 7.0, 10.0>
    translate  <0.0, 21.79977, 0.0>
  }
  box { // TubeTopCuttoff
    <-1, -1, -1>, <1, 1, 1>
    scale <13.368664, 8.575807, 4.401382>
    rotate -15.543896*x
    translate  <0.0, 24.431164, 11.796679>
  }
  box { // TubeBottomCutoff
    <-1, -1, -1>, <1, 1, 1>
    scale <13.368664, 8.575807, 4.401382>
    rotate 12.871431*x
    translate  <0.0, 25.659731, -12.634748>
  }
  material {
    TVblack
  }
}
#declare MainBody = difference {
  box { // MainBack
    <-1, -1, -1>, <1, 1, 1>
    scale <18.0, 6.0, 18.779758>
    translate  <0.0, 7.597369, -1.033929>
  }
  box { // MainTopBackCutOff
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 4.991184, 2.037708>
    rotate -22.812025*x
    translate  <0.0, 11.068424, 16.607305>
  }
  box { // MainTopFrontCutOff
    <-1, -1, -1>, <1, 1, 1>
    scale <-20.0, -9.00811, -2.740541>
    rotate <173.654617, 0.0, -180.0>
    translate  <0.0, 8.125273, 18.074475>
  }
  cylinder { // SpeakerCutout
    <0,0,1>, <0,0,0>, 1 
    scale 3.5
    rotate -90.0*y
    translate  <-14.811169, 7.554723, -7.554723>
  }
}
#declare BackOfBody = difference {
  box { // BodyBack
    <-1, -1, -1>, <1, 1, 1>
    scale <17.0, 5.0, 16.460831>
    translate  <0.0, 14.95361, -2.164516>
  }
  box { // BodyBackCutOff
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 3.961383, 2.899417>
    rotate -29.939913*x
    translate  <0.0, 20.061734, 15.461591>
  }
}
#declare ControlBar = difference {
  box { // BaseBottom
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 2.052448, 1.239995>
    translate  <0.0, 0.899195, -18.57815>
  }
  box { // ControlPanelCutout
    <-1, -1, -1>, <1, 1, 1>
    scale <3.888307, 0.518537, 1.0>
    translate  <-3.833571, -0.965688, -18.599474>
  }
}
#declare Body = union {
  box { // BaseMiddle
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 2.052448, 1.0>
    translate  <0.0, 1.613457, -17.297746>
  }
  box { // BaseTop
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 1.623673, 1.0>
    translate  <0.0, 0.773473, -15.34898>
  }
  object { MainBody }
  box { // MainBaseBottom
    <-1, -1, -1>, <1, 1, 1>
    scale <17.0, 9.597225, 1.310743>
    translate  <0.0, 9.350683, -19.380506>
  }
  object { BackOfBody }
  object { ControlBar }
  material {
    TVblack
  }
}
#declare Screen = union {
  box { // ScreenBack
    <-1, -1, -1>, <1, 1, 1>
    material {
      TVblack
    }
    scale <17.5, 0.2, 14.25>
    translate  -0.293614*y
  }
  superellipsoid { // ScreenGlassInside
    <1.0, 0.256>
    material {
      ScreenGlassMaterial
      scale <1.0, 1.0, 1.9>
      translate <0.000000, 0.000000, 0.948867>
    }
    scale <14.3235, 0.9, 11.393999>
    translate  -0.498699*y
  }
  superellipsoid { // ScreenGlassOutside
    <1.0, 0.266>
    material {
      Glass
      scale <1.0, 1.0, 1.9>
      translate <0.000000, 0.000000, 0.948867>
    }
    scale <15.915, 1.0, 12.659999>
    translate  -0.714997*y
  }
}
#declare BevelledSideLeft = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.00018, 0.000252>,
  <0.985506, 0.000074>,
  <0.985506, 0.898543>,
  <0.200318, 1.500064>,
  <0.00003, 1.499972>,
  <0.00018, 0.000252>
  rotate -x*90
  scale <1.0, 1.66928, 27.299999>
  rotate -180.0*z
  translate  <16.899918, 1.00378, -13.64967>
}
#declare BevelledSideright = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.00018, 0.000252>,
  <0.985506, 0.000074>,
  <0.985506, 0.898543>,
  <0.200318, 1.500064>,
  <0.00003, 1.499972>,
  <0.00018, 0.000252>
  rotate -x*90
  scale <1.0, 1.66928, 27.299999>
  rotate <-0.0, -180.0, 180.0>
  translate  <-16.900019, 1.00378, 13.650424>
}
#declare BevelledSideTop = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.00018, 0.000252>,
  <0.985506, 0.000074>,
  <0.985506, 0.898543>,
  <0.200318, 1.500064>,
  <0.00003, 1.499972>,
  <0.00018, 0.000252>
  rotate -x*90
  scale <1.0, 1.669278, 33.79982>
  rotate <-90.0, -270.0, 90.0>
  translate  <16.899761, 1.003779, 13.650185>
}
#declare BevelledSideBottom = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.00018, 0.000252>,
  <0.985506, 0.000074>,
  <0.985506, 0.898543>,
  <0.200318, 1.500064>,
  <0.00003, 1.499972>,
  <0.00018, 0.000252>
  rotate -x*90
  scale <1.0, 1.66928, 33.79982>
  rotate <90.0, -90.0, 90.0>
  translate  <-16.899864, 1.00378, -13.650278>
}
#declare BevelledFrame = union {
  object { BevelledSideLeft }
  object { BevelledSideright }
  object { BevelledSideTop }
  object { BevelledSideBottom }
  material {
    TVblack
  }
}
#declare outside = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 1.5, 14.25>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <17.0, 1.6, 13.75>
  }
  material {
    TVblack
  }
}
union { // Monitor
  text {   // txtPower
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "POWER",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      MyWhite
    }
    scale 0.4
    rotate 90.0*x
    translate  <-15.719201, -0.801174, -19.628339>
  }

  box { // ControlButton1
    <-1, -1, -1>, <1, 1, 1>
    material {
      TvGrey
    }
    scale <0.205995, 0.157863, 0.523853>
    translate  <-1.04858, -0.515417, -18.619462>
  }
  text {   // txtVolume
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "VOLUME",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      MyWhite
    }
    scale 0.4
    rotate 90.0*x
    translate  <13.901399, -0.792115, -19.361912>
  }

  text {   // txtBrightness
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "BRIGHTNESS",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      MyWhite
    }
    scale 0.4
    rotate 90.0*x
    translate  <10.819333, -0.789551, -19.359223>
  }

  text {   // txtContrast
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "CONTRAST",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      MyWhite
    }
    scale 0.4
    rotate 90.0*x
    translate  <8.26905, -0.792328, -19.36015>
  }

  text {   // txtColour
    ttf      "C:\WINDOWS\Fonts\Arial.ttf",
    "COLOUR",
    1.0,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      MyWhite
    }
    scale 0.4
    rotate 90.0*x
    translate  <5.916556, -0.792089, -19.361115>
  }

  cylinder { // SpeakerBlackInside
    <0,0,1>, <0,0,0>, 1 
    material {
      ReallyBlack_1
    }
    scale <3.5, 3.5, 1.0>
    rotate -90.0*y
    translate  <-16.62632, 7.554723, -7.554723>
  }
  object { Speaker }
  object { Tube }
  cylinder { // VolumeKnob
    <0,0,1>, <0,0,0>, 1 
    material {
      TvGrey
    }
    scale <0.46001, 0.46001, 1.0>
    rotate -90.0*x
    translate  <14.685264, -1.919963, -18.212129>
  }
  cylinder { // BrightnessKnob
    <0,0,1>, <0,0,0>, 1 
    material {
      TvGrey
    }
    scale <0.46001, 0.46001, 1.0>
    rotate -90.0*x
    translate  <12.0, -1.919963, -18.212129>
  }
  cylinder { // ContrastKnob
    <0,0,1>, <0,0,0>, 1 
    material {
      TvGrey
    }
    scale <0.46001, 0.46001, 1.0>
    rotate -90.0*x
    translate  <9.314736, -1.919963, -18.212129>
  }
  cylinder { // ColorKnob
    <0,0,1>, <0,0,0>, 1 
    material {
      TvGrey
    }
    scale <0.46001, 0.46001, 1.0>
    rotate -90.0*x
    translate  <6.737671, -1.919963, -18.212129>
  }
  box { // PowerButton
    <-1, -1, -1>, <1, 1, 1>
    material {
      TvGrey
    }
    scale <0.79, 0.790004, 0.790004>
    translate  <-14.975251, -0.569989, -18.388192>
  }
  object { Body }
  object { Screen }
  object { BevelledFrame }
  object { outside }
  box { // ControlButton2
    <-1, -1, -1>, <1, 1, 1>
    material {
      TvGrey
    }
    scale <0.205995, 0.157863, 0.523853>
    translate  <-2.407015, -0.515417, -18.619462>
  }
  box { // ControlButton3
    <-1, -1, -1>, <1, 1, 1>
    material {
      TvGrey
    }
    scale <0.205995, 0.157863, 0.523853>
    translate  <-3.766244, -0.515417, -18.619462>
  }
  box { // ControlButton4
    <-1, -1, -1>, <1, 1, 1>
    material {
      TvGrey
    }
    scale <0.205995, 0.157863, 0.523853>
    translate  <-6.780744, -0.515417, -18.619462>
  }
  translate  <154.723128, 164.174898, -38.80877>
}



//***************************************** joystick *************************************************

#declare FireButtonTop = lathe {
  cubic_spline
  7  // control points
  <2.700307, -0.76443>,
  <2.950245, -0.000483>,
  <2.555662, 0.326064>,
  <2.032835, 0.201649>,
  <1.396539, 0.103429>,
  <0.000011, 0.000002>,
  <-0.974522, -0.104034>
  rotate <90,0,90>
  scale 0.304991
  translate  <2.860584, -2.918424, 2.347539>
}
#declare LeftFireButton = union {
  cylinder { // FireButtonBottom
    <0,0,1>, <0,0,0>, 1 
    material {
      OrangePlastic
    }
    scale <0.9, 0.9, 1.0>
    translate  <2.858163, -2.904549, 1.348588>
  }
  object { FireButtonTop }
  material {
    OrangePlastic
  }
}
#declare TopOfBase = lathe {
  cubic_spline
  10  // control points
  <2.892661, -0.04845>,
  <2.4974, 0.006151>,
  <2.07456, 0.180987>,
  <1.781561, 0.362857>,
  <1.531788, 0.567792>,
  <1.317097, 0.763646>,
  <1.091094, 0.973181>,
  <1.02255, 1.001251>,
  <1.000325, 0.983229>,
  <1.026279, 0.944077>
  rotate <90,0,90>
  material {
    Brushed_Aluminum
  }
  translate  1.993511*z
}
#declare Base = merge {
  sphere { <0.3200, 0.3200, 0.3200>, 0.1800 }
  sphere { <0.3200, -0.3200, 0.3200>, 0.1800 }
  sphere { <-0.3200, -0.3200, 0.3200>, 0.1800 }
  sphere { <-0.3200, 0.3200, 0.3200>, 0.1800 }
  sphere { <0.3200, 0.3200, -0.3200>, 0.1800 }
  sphere { <0.3200, -0.3200, -0.3200>, 0.1800 }
  sphere { <-0.3200, -0.3200, -0.3200>, 0.1800 }
  sphere { <-0.3200, 0.3200, -0.3200>, 0.1800 }
  cylinder { <0.3200, 0.3200, 0.3200>, <-0.3200, 0.3200, 0.3200>, 0.1800 }
  cylinder { <0.3200, -0.3200, 0.3200>, <-0.3200, -0.3200, 0.3200>, 0.1800 }
  cylinder { <0.3200, -0.3200, -0.3200>, <-0.3200, -0.3200, -0.3200>, 0.1800 }
  cylinder { <0.3200, 0.3200, -0.3200>, <-0.3200, 0.3200, -0.3200>, 0.1800 }
  cylinder { <0.3200, 0.3200, -0.3200>, <0.3200, 0.3200, 0.3200>, 0.1800 }
  cylinder { <0.3200, -0.3200, -0.3200>, <0.3200, -0.3200, 0.3200>, 0.1800 }
  cylinder { <-0.3200, -0.3200, -0.3200>, <-0.3200, -0.3200, 0.3200>, 0.1800 }
  cylinder { <-0.3200, 0.3200, -0.3200>, <-0.3200, 0.3200, 0.3200>, 0.1800 }
  cylinder { <0.3200, 0.3200, 0.3200>, <0.3200, -0.3200, 0.3200>, 0.1800 }
  cylinder { <0.3200, 0.3200, -0.3200>, <0.3200, -0.3200, -0.3200>, 0.1800 }
  cylinder { <-0.3200, 0.3200, -0.3200>, <-0.3200, -0.3200, -0.3200>, 0.1800 }
  cylinder { <-0.3200, 0.3200, 0.3200>, <-0.3200, -0.3200, 0.3200>, 0.1800 }
  box { <-0.3200, -0.3200, -0.5000> <0.3200, 0.3200, 0.5000> }
  box { <-0.3200, -0.5000, -0.3200> <0.3200, 0.5000, 0.3200> }
  box { <-0.5000, -0.3200, -0.3200> <0.5000, 0.3200, 0.3200> }
// Attributes returned success!
  material {
    TVblack
  }
  scale <10.0, 10.0, 4.0>
}
#declare FireButtonTop1 = lathe {
  cubic_spline
  7  // control points
  <2.700307, -0.76443>,
  <2.950245, -0.000483>,
  <2.555662, 0.326064>,
  <2.032835, 0.201649>,
  <1.396539, 0.103429>,
  <0.000011, 0.000002>,
  <-0.974522, -0.104034>
  rotate <90,0,90>
  scale 0.304991
  translate  <2.860584, -2.918424, 2.347539>
}
#declare RightFireButton = union {
  cylinder { // FireButtonBottom1
    <0,0,1>, <0,0,0>, 1 
    material {
      OrangePlastic
    }
    scale <0.9, 0.9, 1.0>
    translate  <2.858163, -2.904549, 1.348588>
  }
  object { FireButtonTop1 }
  material {
    OrangePlastic
  }
  translate  <-5.730584, -0.028678, 0.0>
}
#declare MetalTop = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    Brushed_Aluminum
  }
  scale <6.5, 6.5, 0.01>
  translate  <0.0, 0.02543, 2.001848>
}
#declare TopMetalFlatBit = difference {
  object { MetalTop }
  cylinder { // TopMetalBitCutoff
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.028678, 1.028678, 0.466134>
    translate  <-2.867789, -2.91799, 1.673894>
  }
  cylinder { // TopMetalBitCutoff1
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.028678, 1.028678, 0.466134>
    translate  <2.856849, -2.91799, 1.673894>
  }
}
#declare CordHolderBit = lathe {
  linear_spline
  2  // control points
  <0.449858, 0.000124>,
  <0.350008, 1.999989>
  rotate <90,0,90>
  material {
    TVblack
  }
  rotate 90.0*x
  translate  <0.0, -7.173514, -0.10525>
}
#declare CordHolder = difference {
  object { CordHolderBit }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -7.462125, 0.561046>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -7.822125, 0.561046>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -8.182125, 0.561046>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -8.542125, 0.561046>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -8.902125, 0.561046>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -7.463935, -0.763408>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -7.823935, -0.763408>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -8.183935, -0.763408>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -8.543935, -0.763408>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.09, 0.5>
    translate  <0.0, -8.903935, -0.763408>
  }
  material {
    BlckPlastic
  }
  translate  <0.0, 2.191754, 0.106386>
}
union { // Joystick
  object { LeftFireButton }
  sphere { // Handle
    <0,0,0>,1
    material {
      ShinyBlackPlastic
    }
    scale <1.7, 1.7, 1.5>
    translate  7.321607*z
  }
  cylinder { // Shaft
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <0.543141, 0.543141, 3.0>
    translate  2.966032*z
  }
  torus { // ShinyBlackRing
    1.615, 0.385  rotate -x*90
    material {
      ShinyBlackPlastic
    }
    scale <0.463866, 0.463866, 0.2>
    translate  <0.0, 0.005351, 3.021035>
  }
  object { TopOfBase }
  object { Base }
  object { RightFireButton }
  object { TopMetalFlatBit }
  object { CordHolder }
  rotate -73.219482*z
  translate  <188.537464, 145.390026, -57.491358>
}

 
 
//************************************************* disk drive *****************************************

#declare LogoC1 = difference {
  cylinder { // LogoRoundBit1
    <0,0,1>, <0,0,0>, 1 
    translate  <14.28859, -9.808398, 0.0>
  }
  cylinder { // LogoRoundBitCutOut1
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.1>
    translate  <14.294685, -9.814362, -0.031269>
  }
  box { // LogoCcutoff1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.510525, 1.0, 0.699088>
    translate  <14.264654, -8.564526, 0.494355>
  }
  material {
    YukkyGreyPlastic
  }
  translate  <0.0, 0.060669, 5.046938>
}
#declare LogoTopStraightBit1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.000039, -0.400143>,
  <0.499985, -0.399996>,
  <0.899112, 0.000143>,
  <0.000006, -0.000006>,
  <0.000039, -0.400143>
  rotate -x*90
  rotate 90.0*z
  translate  <13.859891, -9.51256, 5.049604>
}
#declare LogoBottomStraightBit1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.000039, -0.400143>,
  <0.499985, -0.399996>,
  <0.899112, 0.000143>,
  <0.000006, -0.000006>,
  <0.000039, -0.400143>
  rotate -x*90
  rotate <180.0, 0.0, 90.0>
  translate  <14.727801, -9.512291, 6.049349>
}
#declare FrontPanelLogo = union {
  object { LogoC1 }
  object { LogoTopStraightBit1 }
  object { LogoBottomStraightBit1 }
  material {
    YukkyGreyPlastic
  }
  scale 0.6
  rotate 76.406296*y
  translate  <30.523551, -10.241987, 10.452697>
}


//************************************ label on front of disk drive  (change somehow) ******************
#declare FrontLabel = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    mFrontLabel
    scale <1.0, -1.0059, -9.37061>  //<1.0, -0.947432, -8.877222>
    rotate <-90.0, -0.0, 0.0>
    translate <-0.49959, 0.27411, -0.50219>  //<-0.500884, 0.000000, -0.469705>
  }
  scale <18.5, 0.05, 1.8>
  rotate <-13.192195, -0.0, 90.0>
  translate  <35.997492, -9.649127, 2.974555>
}


#declare DiskDriveBottomMain = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <0.470959, -3.458003>,
  <0.609697, -3.499791>,
  <33.935424, -3.500093>,
  <34.217493, -3.483296>,
  <34.449944, -3.379668>,
  <34.566568, -3.203988>,
  <34.649985, -2.975074>,
  <35.500194, 0.000036>,
  <-0.000401, 0.000032>,
  <0.417118, -3.300277>,
  <0.470959, -3.458003>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0506, 1.0, 19.4>
  rotate 90.0*x
  translate  <-0.596489, 0.0, -0.100903>
}
#declare GreenLed = union {
  cylinder { // GreenLedOutside
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale 0.4
    rotate <180.0, 72.987778, 180.0>
    translate  <35.784009, -17.715856, -1.81411>
  }
  sphere { // GreenLEDinside
    <0,0,0>,1
    material {
      mGreenLed
    }
    scale 0.25
    translate  <36.116071, -17.71398, -1.902152>
  }
  translate  <0.077151, -0.656425, 0.187948>
}
#declare DiskDriveBottomAllBits = union {
  object { DiskDriveBottomMain }
  object { GreenLed }
}
#declare TopMain = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.600165, -0.000201>,
  <36.700441, -0.000252>,
  <35.661711, 4.343463>,
  <35.582852, 4.5322>,
  <35.481643, 4.644931>,
  <35.32572, 4.718306>,
  <35.114766, 4.745822>,
  <0.635824, 5.494123>,
  <0.475472, 5.489718>,
  <0.383256, 5.453007>,
  <0.336674, 5.342671>,
  <0.322602, 5.203598>,
  <-0.600165, -0.000201>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0, 1.0, 19.4>
  rotate 90.0*x
}
#declare LogoCutout = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  scale <2.6, 2.6, 0.2>
  rotate 1.077088*y
  translate  <14.305494, -9.767761, 5.200955>
}
#declare DiskDriveTop = difference {
  object { TopMain }
  box { // VentCutOut
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 10.0, 0.4>
    rotate 1.243166*y
    translate  <6.493262, -9.736154, 4.970131>
  }
  object { LogoCutout }
  material {
    YukkyGreyPlastic
  }
}
#declare LogoC = difference {
  cylinder { // LogoRoundBit
    <0,0,1>, <0,0,0>, 1 
    translate  <14.28859, -9.808398, 0.0>
  }
  cylinder { // LogoRoundBitCutOut
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 1.1>
    translate  <14.294685, -9.814362, -0.031269>
  }
  box { // LogoCcutoff
    <-1, -1, -1>, <1, 1, 1>
    scale <1.510525, 1.0, 0.699088>
    translate  <14.264654, -8.564526, 0.494355>
  }
  material {
    YukkyGreyPlastic
  }
  translate  <0.0, 0.060669, 5.046938>
}
#declare LogoTopStraightBit = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.000039, -0.400143>,
  <0.499985, -0.399996>,
  <0.899112, 0.000143>,
  <0.000006, -0.000006>,
  <0.000039, -0.400143>
  rotate -x*90
  rotate 90.0*z
  translate  <13.859891, -9.51256, 5.049604>
}
#declare LogoBottomStraightBit = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.000039, -0.400143>,
  <0.499985, -0.399996>,
  <0.899112, 0.000143>,
  <0.000006, -0.000006>,
  <0.000039, -0.400143>
  rotate -x*90
  rotate <180.0, 0.0, 90.0>
  translate  <14.727801, -9.512291, 6.049349>
}
#declare Logo = union {
  object { LogoC }
  object { LogoTopStraightBit }
  object { LogoBottomStraightBit }
  material {
    YukkyGreyPlastic
  }
  rotate 1.156407*y
  translate  <-0.106165, -0.086298, -0.561118>
}
#declare DiskDriveTopAllBits = union {
  object { DiskDriveTop }
  box { // VentInsideCube
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 9.5, 0.5>
    rotate 1.250799*y
    translate  <6.469234, -9.706774, 4.540684>
  }
  box { // VentStrip1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <2.23948, -9.705136, 5.051889>
  }
  box { // VentStrip2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <2.673768, -9.705136, 5.043889>
  }
  box { // VentStrip3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <3.073281, -9.700465, 5.035889>
  }
  box { // VentStrip4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <3.508057, -9.705136, 5.027889>
  }
  box { // VentStrip5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <3.942346, -9.705136, 5.019889>
  }
  box { // VentStrip6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <4.324017, -9.705136, 5.011889>
  }
  box { // VentStrip7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <4.776635, -9.705136, 5.003889>
  }
  box { // VentStrip8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <5.208555, -9.705136, 4.995889>
  }
  box { // VentStrip9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <5.679501, -9.705136, 4.987889>
  }
  box { // VentStrip10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <6.079501, -9.705136, 4.979889>
  }
  box { // VentStrip11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <6.548078, -9.705136, 4.971889>
  }
  box { // VentStrip13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <6.986862, -9.705136, 4.955889>
  }
  box { // VentStrip14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <7.43948, -9.705136, 4.947889>
  }
  box { // VentStrip15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <7.837112, -9.705136, 4.939889>
  }
  box { // VentStrip16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <8.308057, -9.705136, 4.931889>
  }
  box { // VentStrip17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <8.72165, -9.705136, 4.923889>
  }
  box { // VentStrip18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <9.210923, -9.705136, 4.915889>
  }
  box { // VentStrip19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <9.624516, -9.705136, 4.907889>
  }
  box { // VentStrip20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <10.113789, -9.705136, 4.899889>
  }
  box { // VentStrip21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.075, 9.65, 0.4>
    rotate 1.233935*y
    translate  <10.54571, -9.705136, 4.891889>
  }
  object { Logo }
  material {
    YukkyGreyPlastic
  }
}
#declare Case = union {
  object { DiskDriveBottomAllBits }
  object { DiskDriveTopAllBits }
}
#declare CaseWithHole = difference {
  object { Case }
  box { // FrontPanelCutout
    <-1, -1, -1>, <1, 1, 1>
    material {
      YukkyGreyPlastic
    }
    scale <0.997391, 7.5, 2.025229>
    translate  <35.738327, -9.903172, -0.45202>
  }
}
#declare HoleBevelCutout = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-0.000039, -0.000048>,
  <1.0, 0.000135>,
  <0.499986, 1.000015>,
  <-0.000039, -0.000048>
  rotate -x*90
  scale <1.0, 1.0, 13.6>
  rotate <-90.0, 90.0, 0.0>
  translate  <12.73016, 11.520138, 15.797917>
}
#declare BigHoleCutout = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.000116, -0.009914>,
  <2.656012, -0.010008>,
  <2.656533, 1.399791>,
  <1.306459, 1.400015>,
  <0.000116, -0.009914>
  rotate -x*90
  scale <1.199654, 1.0, 4.0>
  rotate <-90.0, -90.0, -180.0>
  translate  <12.725981, 22.346556, 13.407691>
}
#declare SmallHoleCutout = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.000012, -0.049918>,
  <2.899676, -0.04983>,
  <2.899905, 0.099917>,
  <-0.00041, 0.499759>,
  <-0.000012, -0.049918>
  rotate -x*90
  scale <1.1, 1.0, 4.314311>
  rotate <-90.0, 90.0, -0.0>
  translate  <12.679989, 14.049965, 16.59608>
}
#declare DiskHoleAll = difference {
  box { // DiskHoleMain
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 7.55, 2.1>
    translate  <11.686747, 18.321237, 14.899999>
  }
  box { // DiskHoleCutout
    <-1, -1, -1>, <1, 1, 1>
    scale <1.317409, 6.8, 0.2>
    translate  <11.984755, 18.318911, 15.30086>
  }
  object { HoleBevelCutout }
  object { BigHoleCutout }
  object { SmallHoleCutout }
  material {
    YukkyGreyPlastic
  }
}
#declare RoundLeverBit = lathe {
  linear_spline
  4  // control points
  <0.000932, 0.000057>,
  <0.600378, -0.000208>,
  <0.400002, 1.299981>,
  <0.00003, 1.299982>
  rotate <90,0,90>
  material {
    YukkyGreyPlastic
  }
  rotate 90.0*y
  translate  <12.70542, 15.152017, 16.302473>
}
#declare Handle1 = difference {
  box { // LeverHandle
    <-1, -1, -1>, <1, 1, 1>
    material {
      YukkyGreyPlastic
    }
    scale <0.33, 0.2, 1.2>
    translate  <13.141216, 14.959338, 15.109829>
  }
  box { // LeverHandleCutoff
    <-1, -1, -1>, <1, 1, 1>
    scale <0.591925, 0.446222, 0.327877>
    rotate <-0.0, -15.950422, -0.0>
    translate  <13.188909, 14.934918, 13.78713>
  }
  material {
    YukkyGreyPlastic
  }
}
#declare FrontPanel = union {
  cylinder { // LeverHolderThingy
    <0,0,1>, <0,0,0>, 1 
    material {
      YukkyGreyPlastic
    }
    scale 0.5
    rotate -90.0*y
    translate  <12.686092, 15.156548, 16.296495>
  }
  box { // HangDownBit
    <-1, -1, -1>, <1, 1, 1>
    material {
      YukkyGreyPlastic
    }
    scale <0.254963, 1.82446, 0.289921>
    translate  <12.431666, 16.516199, 16.362662>
  }
  object { DiskHoleAll }
  object { RoundLeverBit }
  object { Handle1 }
  box { // RedLed
    <-1, -1, -1>, <1, 1, 1>
    material {
      mRedLed
    }
    scale <0.1, 0.2, 0.05>
    translate  <12.510317, 14.410858, 13.676837>
  }
  translate  <24.056595, -28.249944, -15.378931>
}
union { // DiskDrive
  object { FrontPanelLogo }
  object { FrontLabel }
  object { CaseWithHole }
  object { FrontPanel }
  rotate -90.0*z
  translate  <132.096379, 195.61105, -55.895749>
}
 
 
//************************************* c64 user manual ************************************************


#declare BindingRings = union {
  torus { // BinderRing1
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -9.931474, 0.0>
  }
  torus { // BinderRing2
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -9.111474, 0.0>
  }
  torus { // BinderRing3
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -8.291474, 0.0>
  }
  torus { // BinderRing4
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -7.471474, 0.0>
  }
  torus { // BinderRing5
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -6.651474, 0.0>
  }
  torus { // BinderRing6
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -5.831474, 0.0>
  }
  torus { // BinderRing7
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -5.011474, 0.0>
  }
  torus { // BinderRing8
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -4.191474, 0.0>
  }
  torus { // BinderRing9
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -3.371474, 0.0>
  }
  torus { // BinderRing10
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -2.551474, 0.0>
  }
  torus { // BinderRing11
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -1.731474, 0.0>
  }
  torus { // BinderRing12
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -0.911474, 0.0>
  }
  torus { // BinderRing13
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -0.091474, 0.0>
  }
  torus { // BinderRing14
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 0.728526, 0.0>
  }
  torus { // BinderRing15
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 1.548526, 0.0>
  }
  torus { // BinderRing16
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 2.368526, 0.0>
  }
  torus { // BinderRing17
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 3.188526, 0.0>
  }
  torus { // BinderRing18
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 4.008526, 0.0>
  }
  torus { // BinderRing19
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 4.828526, 0.0>
  }
  torus { // BinderRing20
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 5.648526, 0.0>
  }
  torus { // BinderRing21
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 6.468526, 0.0>
  }
  torus { // BinderRing22
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 7.288526, 0.0>
  }
  torus { // BinderRing23
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 8.108526, 0.0>
  }
  torus { // BinderRing24
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 8.928526, 0.0>
  }
  torus { // BinderRing25
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 9.748526, 0.0>
  }
  torus { // BinderRing26
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -9.723328, 0.0>
  }
  torus { // BinderRing27
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -8.903328, 0.0>
  }
  torus { // BinderRing28
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -8.083328, 0.0>
  }
  torus { // BinderRing29
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -7.263328, 0.0>
  }
  torus { // BinderRing30
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -6.443328, 0.0>
  }
  torus { // BinderRing31
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -5.623328, 0.0>
  }
  torus { // BinderRing32
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -4.803328, 0.0>
  }
  torus { // BinderRing33
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -3.983328, 0.0>
  }
  torus { // BinderRing34
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -3.163328, 0.0>
  }
  torus { // BinderRing35
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -2.343328, 0.0>
  }
  torus { // BinderRing36
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -1.523328, 0.0>
  }
  torus { // BinderRing37
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, -0.703328, 0.0>
  }
  torus { // BinderRing38
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 0.116672, 0.0>
  }
  torus { // BinderRing39
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 0.936672, 0.0>
  }
  torus { // BinderRing40
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 1.756672, 0.0>
  }
  torus { // BinderRing41
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 2.576672, 0.0>
  }
  torus { // BinderRing42
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 3.396672, 0.0>
  }
  torus { // BinderRing43
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 4.216672, 0.0>
  }
  torus { // BinderRing44
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 5.036672, 0.0>
  }
  torus { // BinderRing45
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 5.856672, 0.0>
  }
  torus { // BinderRing46
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 6.676672, 0.0>
  }
  torus { // BinderRing47
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 7.496672, 0.0>
  }
  torus { // BinderRing48
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 8.316672, 0.0>
  }
  torus { // BinderRing49
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 9.136672, 0.0>
  }
  torus { // BinderRing50
    1.805, 0.205  rotate -x*90
    material {
      blank
    }
    scale 0.25
    rotate -90.0*x
    translate  <-6.949477, 9.956672, 0.0>
  }
  translate  <0.005792, 0.0, -0.27186>
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -9.000000, 0.000000>, <-5.000000, -9.000000, 0.000000>, <-4.000000, -9.000000, 0.000000>, <-2.911071, -9.000000, 0.059227>, 
      <-6.000000, -8.000000, 0.000000>, <-5.000000, -8.000000, 0.000000>, <-4.000000, -8.000000, 0.000000>, <-2.911071, -8.000000, 0.059227>, 
      <-6.000000, -7.000000, 0.000000>, <-5.000000, -7.000000, 0.000000>, <-4.000000, -7.000000, 0.000000>, <-2.911071, -7.000000, 0.059227>, 
      <-6.000000, -6.000000, 0.000000>, <-5.000000, -6.000000, 0.000000>, <-4.000000, -6.000000, 0.000000>, <-2.911071, -6.000000, 0.059227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -6.000000, 0.000000>, <-5.000000, -6.000000, 0.000000>, <-4.000000, -6.000000, 0.000000>, <-2.911071, -6.000000, 0.059227>, 
      <-6.000000, -5.000000, 0.000000>, <-5.000000, -5.000000, 0.000000>, <-4.000000, -5.000000, 0.000000>, <-2.911071, -5.000000, 0.059227>, 
      <-6.000000, -4.000000, 0.000000>, <-5.000000, -4.000000, 0.000000>, <-4.000000, -4.000000, 0.000000>, <-2.911071, -4.000000, 0.059227>, 
      <-6.000000, -3.000000, 0.000000>, <-5.000000, -3.000000, 0.000000>, <-4.000000, -3.000000, 0.000000>, <-2.911071, -3.000000, 0.059227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, -3.000000, 0.000000>, <-5.000000, -3.000000, 0.000000>, <-4.000000, -3.000000, 0.000000>, <-2.911071, -3.000000, 0.059227>, 
      <-6.000000, -2.000000, 0.000000>, <-5.000000, -2.000000, 0.000000>, <-4.000000, -2.000000, 0.000000>, <-2.911071, -2.000000, 0.059227>, 
      <-6.000000, -1.000000, 0.000000>, <-5.000000, -1.000000, 0.000000>, <-4.000000, -1.000000, 0.000000>, <-2.911071, -1.000000, 0.059227>, 
      <-6.000000, 0.000000, 0.000000>, <-5.000000, 0.000000, 0.000000>, <-4.000000, 0.000000, 0.000000>, <-2.911071, 0.000000, 0.059227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 0.000000, 0.000000>, <-5.000000, 0.000000, 0.000000>, <-4.000000, 0.000000, 0.000000>, <-2.911071, 0.000000, 0.059227>, 
      <-6.000000, 1.000000, 0.000000>, <-5.000000, 1.000000, 0.000000>, <-4.000000, 1.000000, 0.000000>, <-2.911071, 1.000000, 0.059227>, 
      <-6.000000, 2.000000, 0.000000>, <-5.000000, 2.000000, 0.000000>, <-4.000000, 2.000000, 0.000000>, <-2.911071, 2.000000, 0.059227>, 
      <-6.000000, 3.000000, 0.000000>, <-5.000000, 3.000000, 0.000000>, <-4.000000, 3.000000, 0.000000>, <-2.911071, 3.000000, 0.059227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.000000, 3.000000, 0.000000>, <-5.000000, 3.000000, 0.000000>, <-4.000000, 3.000000, 0.000000>, <-2.911071, 3.000000, 0.059227>, 
      <-6.000000, 4.000000, 0.000000>, <-5.000000, 4.000000, 0.000000>, <-4.000000, 4.000000, 0.000000>, <-2.911071, 4.000000, 0.059227>, 
      <-6.000000, 5.000000, 0.000000>, <-5.000000, 5.000000, 0.000000>, <-4.000000, 5.000000, 0.000000>, <-2.911071, 5.000000, 0.059227>, 
      <-5.993959, 6.000000, 0.135549>, <-5.000000, 6.000000, 0.000000>, <-4.000000, 6.000000, 0.000000>, <-2.911071, 6.000000, 0.059227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.993959, 6.000000, 0.135549>, <-5.000000, 6.000000, 0.000000>, <-4.000000, 6.000000, 0.000000>, <-2.911071, 6.000000, 0.059227>, 
      <-5.987917, 7.000000, 0.271098>, <-5.000000, 7.000000, 0.000000>, <-4.000000, 7.000000, 0.000000>, <-2.911071, 7.000000, 0.059227>, 
      <-5.987917, 8.000000, 0.271098>, <-5.002204, 8.000000, 0.102667>, <-4.000000, 8.000000, 0.000000>, <-2.911071, 8.000000, 0.059227>, 
      <-5.987917, 9.000000, 0.271098>, <-5.002204, 9.000000, 0.102667>, <-4.016491, 9.000000, -0.065765>, <-2.919316, 9.000000, 0.026344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.911071, -9.000000, 0.059227>, <-1.822141, -9.000000, 0.118454>, <-0.826145, -9.000000, 0.207847>, <0.169851, -9.000000, 0.297240>, 
      <-2.911071, -8.000000, 0.059227>, <-1.822141, -8.000000, 0.118454>, <-0.826145, -8.000000, 0.207847>, <0.169851, -8.000000, 0.297240>, 
      <-2.911071, -7.000000, 0.059227>, <-1.822141, -7.000000, 0.118454>, <-0.826145, -7.000000, 0.207847>, <0.169851, -7.000000, 0.297240>, 
      <-2.911071, -6.000000, 0.059227>, <-1.822141, -6.000000, 0.118454>, <-0.826145, -6.000000, 0.207847>, <0.169851, -6.000000, 0.297240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.911071, -6.000000, 0.059227>, <-1.822141, -6.000000, 0.118454>, <-0.826145, -6.000000, 0.207847>, <0.169851, -6.000000, 0.297240>, 
      <-2.911071, -5.000000, 0.059227>, <-1.822141, -5.000000, 0.118454>, <-0.826145, -5.000000, 0.207847>, <0.169851, -5.000000, 0.297240>, 
      <-2.911071, -4.000000, 0.059227>, <-1.822141, -4.000000, 0.118454>, <-0.826145, -4.000000, 0.207847>, <0.169851, -4.000000, 0.297240>, 
      <-2.911071, -3.000000, 0.059227>, <-1.822141, -3.000000, 0.118454>, <-0.826145, -3.000000, 0.207847>, <0.169851, -3.000000, 0.297240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.911071, -3.000000, 0.059227>, <-1.822141, -3.000000, 0.118454>, <-0.826145, -3.000000, 0.207847>, <0.169851, -3.000000, 0.297240>, 
      <-2.911071, -2.000000, 0.059227>, <-1.822141, -2.000000, 0.118454>, <-0.826145, -2.000000, 0.207847>, <0.169851, -2.000000, 0.297240>, 
      <-2.911071, -1.000000, 0.059227>, <-1.822141, -1.000000, 0.118454>, <-0.826145, -1.000000, 0.207847>, <0.169851, -1.000000, 0.297240>, 
      <-2.911071, 0.000000, 0.059227>, <-1.822141, 0.000000, 0.118454>, <-0.826145, 0.000000, 0.207847>, <0.169851, 0.000000, 0.297240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.911071, 0.000000, 0.059227>, <-1.822141, 0.000000, 0.118454>, <-0.826145, 0.000000, 0.207847>, <0.169851, 0.000000, 0.297240>, 
      <-2.911071, 1.000000, 0.059227>, <-1.822141, 1.000000, 0.118454>, <-0.826145, 1.000000, 0.207847>, <0.169851, 1.000000, 0.297240>, 
      <-2.911071, 2.000000, 0.059227>, <-1.822141, 2.000000, 0.118454>, <-0.826145, 2.000000, 0.207847>, <0.169851, 2.000000, 0.297240>, 
      <-2.911071, 3.000000, 0.059227>, <-1.822141, 3.000000, 0.118454>, <-0.826145, 3.000000, 0.207847>, <0.169851, 3.000000, 0.297240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.911071, 3.000000, 0.059227>, <-1.822141, 3.000000, 0.118454>, <-0.826145, 3.000000, 0.207847>, <0.169851, 3.000000, 0.297240>, 
      <-2.911071, 4.000000, 0.059227>, <-1.822141, 4.000000, 0.118454>, <-0.826145, 4.000000, 0.207847>, <0.169851, 4.000000, 0.297240>, 
      <-2.911071, 5.000000, 0.059227>, <-1.822141, 5.000000, 0.118454>, <-0.826145, 5.000000, 0.207847>, <0.169851, 5.000000, 0.297240>, 
      <-2.911071, 6.000000, 0.059227>, <-1.822141, 6.000000, 0.118454>, <-0.826145, 6.000000, 0.207847>, <0.169851, 6.000000, 0.297240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.911071, 6.000000, 0.059227>, <-1.822141, 6.000000, 0.118454>, <-0.826145, 6.000000, 0.207847>, <0.169851, 6.000000, 0.297240>, 
      <-2.911071, 7.000000, 0.059227>, <-1.822141, 7.000000, 0.118454>, <-0.826145, 7.000000, 0.207847>, <0.169851, 7.000000, 0.297240>, 
      <-2.911071, 8.000000, 0.059227>, <-1.822141, 8.000000, 0.118454>, <-0.826145, 8.000000, 0.207847>, <0.169851, 8.000000, 0.297240>, 
      <-2.919316, 9.000000, 0.026344>, <-1.822141, 9.000000, 0.118454>, <-0.826145, 9.000000, 0.207847>, <0.169851, 9.000000, 0.297240>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.169851, -9.000000, 0.297240>, <1.165848, -9.000000, 0.386633>, <2.142915, -9.000000, 0.624379>, <3.126286, -9.000000, 1.005198>, 
      <0.169851, -8.000000, 0.297240>, <1.165848, -8.000000, 0.386633>, <2.142915, -8.000000, 0.624379>, <3.129447, -8.000000, 0.787949>, 
      <0.169851, -7.000000, 0.297240>, <1.165848, -7.000000, 0.386633>, <2.142915, -7.000000, 0.624379>, <3.129447, -7.000000, 0.787949>, 
      <0.169851, -6.000000, 0.297240>, <1.165848, -6.000000, 0.386633>, <2.142915, -6.000000, 0.624379>, <3.129447, -6.000000, 0.787949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.169851, -6.000000, 0.297240>, <1.165848, -6.000000, 0.386633>, <2.142915, -6.000000, 0.624379>, <3.129447, -6.000000, 0.787949>, 
      <0.169851, -5.000000, 0.297240>, <1.165848, -5.000000, 0.386633>, <2.142915, -5.000000, 0.624379>, <3.129447, -5.000000, 0.787949>, 
      <0.169851, -4.000000, 0.297240>, <1.165848, -4.000000, 0.386633>, <2.142915, -4.000000, 0.624379>, <3.129447, -4.000000, 0.787949>, 
      <0.169851, -3.000000, 0.297240>, <1.165848, -3.000000, 0.386633>, <2.142915, -3.000000, 0.624379>, <3.129447, -3.000000, 0.787949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.169851, -3.000000, 0.297240>, <1.165848, -3.000000, 0.386633>, <2.142915, -3.000000, 0.624379>, <3.129447, -3.000000, 0.787949>, 
      <0.169851, -2.000000, 0.297240>, <1.165848, -2.000000, 0.386633>, <2.142915, -2.000000, 0.624379>, <3.129447, -2.000000, 0.787949>, 
      <0.169851, -1.000000, 0.297240>, <1.165848, -1.000000, 0.386633>, <2.142915, -1.000000, 0.624379>, <3.129447, -1.000000, 0.787949>, 
      <0.169851, 0.000000, 0.297240>, <1.165848, 0.000000, 0.386633>, <2.142915, 0.000000, 0.624379>, <3.129447, 0.000000, 0.787949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.169851, 0.000000, 0.297240>, <1.165848, 0.000000, 0.386633>, <2.142915, 0.000000, 0.624379>, <3.129447, 0.000000, 0.787949>, 
      <0.169851, 1.000000, 0.297240>, <1.165848, 1.000000, 0.386633>, <2.142915, 1.000000, 0.624379>, <3.129447, 1.000000, 0.787949>, 
      <0.169851, 2.000000, 0.297240>, <1.165848, 2.000000, 0.386633>, <2.142915, 2.000000, 0.624379>, <3.129447, 2.000000, 0.787949>, 
      <0.169851, 3.000000, 0.297240>, <1.165848, 3.000000, 0.386633>, <2.142915, 3.000000, 0.624379>, <3.129447, 3.000000, 0.787949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.169851, 3.000000, 0.297240>, <1.165848, 3.000000, 0.386633>, <2.142915, 3.000000, 0.624379>, <3.129447, 3.000000, 0.787949>, 
      <0.169851, 4.000000, 0.297240>, <1.165848, 4.000000, 0.386633>, <2.142915, 4.000000, 0.624379>, <3.129447, 4.000000, 0.787949>, 
      <0.169851, 5.000000, 0.297240>, <1.165848, 5.000000, 0.386633>, <2.142915, 5.000000, 0.624379>, <3.129447, 5.000000, 0.787949>, 
      <0.169851, 6.000000, 0.297240>, <1.165848, 6.000000, 0.386633>, <2.142915, 6.000000, 0.624379>, <3.184615, 6.031774, 0.641601>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.169851, 6.000000, 0.297240>, <1.165848, 6.000000, 0.386633>, <2.142915, 6.000000, 0.624379>, <3.184615, 6.031774, 0.641601>, 
      <0.169851, 7.000000, 0.297240>, <1.165848, 7.000000, 0.386633>, <2.142915, 7.000000, 0.624379>, <3.241406, 7.063548, 0.493937>, 
      <0.169851, 8.000000, 0.297240>, <1.165848, 8.000000, 0.386633>, <2.142915, 8.000000, 0.624379>, <3.166189, 8.019458, 0.684957>, 
      <0.169851, 9.000000, 0.297240>, <1.165848, 9.000000, 0.386633>, <2.312454, 9.085056, 0.127128>, <3.175742, 9.017896, 0.627352>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.126286, -9.000000, 1.005198>, <4.109656, -9.000000, 1.386018>, <5.099220, -9.000000, 1.241920>, <6.088783, -9.000000, 1.097821>, 
      <3.129447, -8.000000, 0.787949>, <4.115979, -8.000000, 0.951518>, <5.099220, -8.000000, 1.241920>, <6.088783, -8.000000, 1.097821>, 
      <3.129447, -7.000000, 0.787949>, <4.115979, -7.000000, 0.951518>, <5.102510, -7.000000, 1.115088>, <6.088783, -7.000000, 1.097821>, 
      <3.129447, -6.000000, 0.787949>, <4.115979, -6.000000, 0.951518>, <5.102510, -6.000000, 1.115088>, <6.088913, -6.000000, 1.188239>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.129447, -6.000000, 0.787949>, <4.115979, -6.000000, 0.951518>, <5.102510, -6.000000, 1.115088>, <6.088913, -6.000000, 1.188239>, 
      <3.129447, -5.000000, 0.787949>, <4.115979, -5.000000, 0.951518>, <5.102510, -5.000000, 1.115088>, <6.089042, -5.000000, 1.278657>, 
      <3.129447, -4.000000, 0.787949>, <4.115979, -4.000000, 0.951518>, <5.102510, -4.000000, 1.115088>, <6.089042, -4.000000, 1.278657>, 
      <3.129447, -3.000000, 0.787949>, <4.115979, -3.000000, 0.951518>, <5.102510, -3.000000, 1.115088>, <6.089042, -3.000000, 1.278657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.129447, -3.000000, 0.787949>, <4.115979, -3.000000, 0.951518>, <5.102510, -3.000000, 1.115088>, <6.089042, -3.000000, 1.278657>, 
      <3.129447, -2.000000, 0.787949>, <4.115979, -2.000000, 0.951518>, <5.102510, -2.000000, 1.115088>, <6.089042, -2.000000, 1.278657>, 
      <3.129447, -1.000000, 0.787949>, <4.115979, -1.000000, 0.951518>, <5.102510, -1.000000, 1.115088>, <6.089042, -1.000000, 1.278657>, 
      <3.129447, 0.000000, 0.787949>, <4.115979, 0.000000, 0.951518>, <5.102510, 0.000000, 1.115088>, <6.089042, 0.000000, 1.278657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.129447, 0.000000, 0.787949>, <4.115979, 0.000000, 0.951518>, <5.102510, 0.000000, 1.115088>, <6.089042, 0.000000, 1.278657>, 
      <3.129447, 1.000000, 0.787949>, <4.115979, 1.000000, 0.951518>, <5.102510, 1.000000, 1.115088>, <6.089042, 1.000000, 1.278657>, 
      <3.129447, 2.000000, 0.787949>, <4.115979, 2.000000, 0.951518>, <5.102510, 2.000000, 1.115088>, <6.089042, 2.000000, 1.278657>, 
      <3.129447, 3.000000, 0.787949>, <4.115979, 3.000000, 0.951518>, <5.102510, 3.000000, 1.115088>, <6.089042, 3.000000, 1.278657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.129447, 3.000000, 0.787949>, <4.115979, 3.000000, 0.951518>, <5.102510, 3.000000, 1.115088>, <6.089042, 3.000000, 1.278657>, 
      <3.129447, 4.000000, 0.787949>, <4.115979, 4.000000, 0.951518>, <5.102510, 4.000000, 1.115088>, <6.089042, 4.000000, 1.278657>, 
      <3.129447, 5.000000, 0.787949>, <4.115979, 5.000000, 0.951518>, <5.102510, 5.000000, 1.115088>, <6.367339, 5.169137, 0.599863>, 
      <3.184615, 6.031774, 0.641601>, <4.227938, 6.063548, 0.657507>, <5.152847, 6.029968, 0.989404>, <6.216906, 6.080957, 0.981903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.184615, 6.031774, 0.641601>, <4.227938, 6.063548, 0.657507>, <5.152847, 6.029968, 0.989404>, <6.216906, 6.080957, 0.981903>, 
      <3.241406, 7.063548, 0.493937>, <4.339896, 7.127097, 0.363496>, <5.203184, 7.059936, 0.863719>, <6.066472, 6.992776, 1.363943>, 
      <3.166189, 8.019458, 0.684957>, <4.189463, 8.038916, 0.745536>, <5.052751, 7.971756, 1.245759>, <5.916039, 7.904596, 1.745983>, 
      <3.175742, 9.017896, 0.627352>, <4.039030, 8.950736, 1.127575>, <4.902317, 8.883576, 1.627799>, <5.765605, 8.816416, 2.128023>
    }
  }
  material {
    mFrontCover
    scale <12.100844, 18.021301, 1.0>
    translate <-6.020797, -9.015519, 0.000000>
  }
  scale <1.142605, 1.192283, 1.0>
}
#declare CSG001 = union {
  cylinder { // PagesAddOn
    <0,0,1>, <0,0,0>, 1 
    material {
      blank
    }
    scale <0.164692, 0.30284, 21.459837>
    rotate -90.0*x
    translate  <6.9581, -10.729987, -0.308505>
  }
  box { // Pages1
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <6.905998, 10.729151, 0.307192>
    translate  <0.051436, 0.0, -0.308506>
  }
}
#declare pagesAndRoundBits = difference {
  object { CSG001 }
  cylinder { // PagesCutoff
    <0,0,1>, <0,0,0>, 1 
    material {
      blank
    }
    scale <0.164692, 0.30284, 21.459837>
    rotate -90.0*x
    translate  <-6.871167, -10.729987, -0.308505>
  }
}
#declare PagesGroup = union {
  object { BezPtch001 }
  object { pagesAndRoundBits }
}
#declare cover = difference {
  object { PagesGroup }
  box { // HoleCutout1
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -9.849504, 0.0>
  }
  box { // HoleCutout2
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -9.029504, 0.0>
  }
  box { // HoleCutout3
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -8.209504, 0.0>
  }
  box { // HoleCutout4
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -7.389504, 0.0>
  }
  box { // HoleCutout5
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -6.569504, 0.0>
  }
  box { // HoleCutout6
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -5.749504, 0.0>
  }
  box { // HoleCutout7
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -4.929504, 0.0>
  }
  box { // HoleCutout8
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -4.109504, 0.0>
  }
  box { // HoleCutout9
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -3.289504, 0.0>
  }
  box { // HoleCutout10
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -2.469504, 0.0>
  }
  box { // HoleCutout11
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -1.649504, 0.0>
  }
  box { // HoleCutout12
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -0.829504, 0.0>
  }
  box { // HoleCutout13
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, -0.009504, 0.0>
  }
  box { // HoleCutout14
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 0.810496, 0.0>
  }
  box { // HoleCutout15
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 1.630496, 0.0>
  }
  box { // HoleCutout16
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 2.450496, 0.0>
  }
  box { // HoleCutout17
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 3.270496, 0.0>
  }
  box { // HoleCutout18
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 4.090496, 0.0>
  }
  box { // HoleCutout19
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 4.910496, 0.0>
  }
  box { // HoleCutout20
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 5.730496, 0.0>
  }
  box { // HoleCutout21
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 6.550496, 0.0>
  }
  box { // HoleCutout22
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 7.370496, 0.0>
  }
  box { // HoleCutout23
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 8.190496, 0.0>
  }
  box { // HoleCutout24
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 9.010496, 0.0>
  }
  box { // HoleCutout25
    <-1, -1, -1>, <1, 1, 1>
    material {
      blank
    }
    scale <0.2, 0.2, 1.0>
    translate  <-6.500115, 9.830496, 0.0>
  }
}
union { // C64UserManual
  object { BindingRings }
  object { cover }
  rotate <-0.0, 0.639559, 5.884331>
  translate  <123.36645, 144.21389, -58.644276>
}



// -----------------------------------------------------------------------------------------------------

#declare FloppyBit1 = difference {
  box { // DiskInside1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout1
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot1 = union {
  box { // ReadSlotLongBit1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside1 = difference {
  box { // DiskCase1
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout1
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout2
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot1 }
  cylinder { // BottomNotchLeft1
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight1
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker1 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerGreen
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk1 = union {
  object { FloppyBit1 }
  object { DiskOutside1 }
  object { Sticker1 }
}
#declare Corner3 = intersection {
  cylinder { // DiskJacketBottomRoundBit4
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit4
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft1 = union {
  object { Corner3 }
  cylinder { // DiskJacketBottomRoundBit5
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit5
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner4 = intersection {
  cylinder { // DiskJacketBottomRoundBit6
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit6
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight1 = union {
  object { Corner4 }
  cylinder { // DiskJacketBottomRoundBit7
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit7
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket1 = union {
  object { RoundBitsLeft1 }
  box { // DiskJacketTop1
    <-1, -1, -1>, <1, 1, 1>
    material {
      DiskJacketLabel
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight1 }
  box { // DiskJacketBack1
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
union { // FloppyDisk2
  object { Disk1 }
  object { DiskJacket1 }
  rotate -174.16922*z
  translate  <186.82802, 148.756098, -59.418932>
}


#declare FloppyBit2 = difference {
  box { // DiskInside2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout2
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot2 = union {
  box { // ReadSlotLongBit2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside2 = difference {
  box { // DiskCase2
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout2
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout3
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot2 }
  cylinder { // BottomNotchLeft2
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight2
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker2 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerYellow
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk2 = union {
  object { FloppyBit2 }
  object { DiskOutside2 }
  object { Sticker2 }
}
#declare Corner5 = intersection {
  cylinder { // DiskJacketBottomRoundBit8
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit8
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft2 = union {
  object { Corner5 }
  cylinder { // DiskJacketBottomRoundBit9
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit9
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner6 = intersection {
  cylinder { // DiskJacketBottomRoundBit10
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit10
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight2 = union {
  object { Corner6 }
  cylinder { // DiskJacketBottomRoundBit11
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit11
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket2 = union {
  object { RoundBitsLeft2 }
  box { // DiskJacketTop2
    <-1, -1, -1>, <1, 1, 1>
    material {
      DiskJacketLabel
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight2 }
  box { // DiskJacketBack2
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
union { // FloppyDisk3
  object { Disk2 }
  object { DiskJacket2 }
  rotate 80.232536*z
  translate  <189.416713, 150.446844, -59.261647>
}


#declare FloppyBit3 = difference {
  box { // DiskInside3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout3
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot3 = union {
  box { // ReadSlotLongBit3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside3 = difference {
  box { // DiskCase3
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout3
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout4
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot3 }
  cylinder { // BottomNotchLeft3
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight3
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker3 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerRed
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk3 = union {
  object { FloppyBit3 }
  object { DiskOutside3 }
  object { Sticker3 }
}
union { // FloppyDisk4
  object { Disk3 }
  rotate <0.343521, 1.176491, -73.721588>
  translate  <121.782685, 170.156759, -50.877387>
}


//******************************************** chair ***************************************************


#declare LeftBackLeg = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 40.0>
  translate  4.72809*z
}
#declare RightBackLeg = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 40.0>
  translate  <17.5721, 0.0, 4.728085>
}
#declare LeftFrontLeg = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 20.0>
  translate  <0.840656, -15.163685, -5.338121>
}
#declare RightFrontLeg = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 20.0>
  translate  <16.698434, -15.163685, -5.338121>
}
#declare FrontUnderneathSupport = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 16.656219>
  rotate -90.0*y
  translate  <8.811445, -15.163685, 3.470696>
}
#declare BackUnderneathSupport1 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 16.656219>
  rotate -90.0*y
  translate  <8.724916, -0.996272, 3.470696>
}
#declare LeftUnderneathSupport = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.007498, 14.931076>
  rotate <-90.0, -90.0, 0.0>
  translate  <0.779322, -8.093475, 3.470696>
}
#declare RightUnderneathSupport1 = merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
// Attributes returned success!
  material {
    ShinyBlackChairLegs
  }
  scale <1.0, 1.0, 14.931076>
  rotate <-90.0, -90.0, 0.0>
  translate  <16.673876, -8.093475, 3.470696>
}
union { // Chair
  superellipsoid { // ChairSeat
    <0.1, 0.54>
    material {
      ChairMaterial
    }
    scale <8.670307, 7.755611, 1.227375>
    translate  <8.773752, -8.236294, 4.789932>
  }
  superellipsoid { // ChairBack
    <0.721, 0.191>
    material {
      ChairMaterial
    }
    scale <8.808559, 0.741731, 6.549752>
    translate  <8.841396, 0.0, 18.597118>
  }
  object { LeftBackLeg }
  object { RightBackLeg }
  object { LeftFrontLeg }
  object { RightFrontLeg }
  object { FrontUnderneathSupport }
  object { BackUnderneathSupport1 }
  object { LeftUnderneathSupport }
  object { RightUnderneathSupport1 }
  scale 1.958576
  rotate -180.0*z
  translate  <176.494528, 105.874027, -90.20946>
}


//----------------------------------------------------------------------------------------------------
#declare FloppyBit4 = difference {
  box { // DiskInside4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout4
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot4 = union {
  box { // ReadSlotLongBit4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside4 = difference {
  box { // DiskCase4
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout4
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout5
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot4 }
  cylinder { // BottomNotchLeft4
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight4
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker4 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerYellow
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk4 = union {
  object { FloppyBit4 }
  object { DiskOutside4 }
  object { Sticker4 }
}
#declare Corner7 = intersection {
  cylinder { // DiskJacketBottomRoundBit12
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit12
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft3 = union {
  object { Corner7 }
  cylinder { // DiskJacketBottomRoundBit13
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit13
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner8 = intersection {
  cylinder { // DiskJacketBottomRoundBit14
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit14
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight3 = union {
  object { Corner8 }
  cylinder { // DiskJacketBottomRoundBit15
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit15
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket3 = union {
  object { RoundBitsLeft3 }
  box { // DiskJacketTop3
    <-1, -1, -1>, <1, 1, 1>
    material {
      DiskJacketLabel
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight3 }
  box { // DiskJacketBack3
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
union { // FloppyDisk5
  object { Disk4 }
  object { DiskJacket3 }
  rotate 28.002497*z
  translate  <120.38749, 135.62873, -59.418932>
}



//*********************************************** disk box ********************************************

#declare DiskBoxLidTop = difference {
  box { // DiskBoxLidTopMain
    <-1, -1, -1>, <1, 1, 1>
    scale <16.25, 8.3, 2.0>
  }
  box { // LidTopCutoff
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 8.854294, 3.361186>
    rotate 8.198238*y
    translate  <-17.472773, 0.0, 0.826415>
  }
  box { // LidTopCutoff1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 8.854294, 3.361186>
    rotate -8.19824*y
    translate  <17.503934, 0.0, 0.699993>
  }
  translate  16.348802*z
}
#declare DiskBoxLidMiddle = difference {
  box { // DiskBoxLidTopMain1
    <-1, -1, -1>, <1, 1, 1>
    scale <16.75, 8.75, 2.0>
  }
  box { // LidTopCutoff2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 9.649738, 3.361186>
    rotate 5.44399*y
    translate  <-18.114211, 0.0, 0.799752>
  }
  box { // LidTopCutoff3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 10.047461, 3.361186>
    rotate -5.519469*y
    translate  <18.13248, 0.0, 0.699993>
  }
  scale <1.025, 1.0, 0.652975>
  translate  13.043753*z
}
#declare DiskBoxLidBottom = difference {
  box { // DiskBoxLidTopMain2
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 9.25, 2.0>
    translate  -0.726848*z
  }
  box { // LidTopCutoff4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 9.649738, 3.361186>
    rotate 5.44399*y
    translate  <-18.935148, 0.0, 0.7831>
  }
  box { // LidTopCutoff5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 10.047461, 3.361186>
    rotate -5.519469*y
    translate  <18.936318, 0.0, 0.732163>
  }
  scale <1.025, 1.0, 0.652975>
  translate  10.922161*z
}
#declare DiskBoxLid1 = union {
  object { DiskBoxLidTop }
  object { DiskBoxLidMiddle }
  object { DiskBoxLidBottom }
  box { // FrontLockBit
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.9, 1.3>
    translate  <16.684034, 0.0, 13.044625>
  }
}
#declare DiskBoxLidTop1 = difference {
  box { // DiskBoxLidTopMain3
    <-1, -1, -1>, <1, 1, 1>
    scale <16.25, 8.3, 2.0>
  }
  box { // LidTopCutoff6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 8.854294, 3.361186>
    rotate 8.198238*y
    translate  <-17.472773, 0.0, 0.826415>
  }
  box { // LidTopCutoff7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 8.854294, 3.361186>
    rotate -8.19824*y
    translate  <17.503934, 0.0, 0.699993>
  }
  translate  16.348802*z
}
#declare DiskBoxLidMiddle1 = difference {
  box { // DiskBoxLidTopMain4
    <-1, -1, -1>, <1, 1, 1>
    scale <16.75, 8.75, 2.0>
  }
  box { // LidTopCutoff8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 9.649738, 3.361186>
    rotate 5.44399*y
    translate  <-18.114211, 0.0, 0.799752>
  }
  box { // LidTopCutoff9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 10.047461, 3.361186>
    rotate -5.519469*y
    translate  <18.13248, 0.0, 0.699993>
  }
  scale <1.025, 1.0, 0.652975>
  translate  13.043753*z
}
#declare DiskBoxLidBottom1 = difference {
  box { // DiskBoxLidTopMain5
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 9.25, 2.0>
    translate  -0.726848*z
  }
  box { // LidTopCutoff10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 9.649738, 3.361186>
    rotate 5.44399*y
    translate  <-18.935148, 0.0, 0.7831>
  }
  box { // LidTopCutoff11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.622912, 10.047461, 3.361186>
    rotate -5.519469*y
    translate  <18.936318, 0.0, 0.732163>
  }
  scale <1.025, 1.0, 0.652975>
  translate  10.922161*z
}
#declare DiskBoxLid2 = union {
  object { DiskBoxLidTop1 }
  object { DiskBoxLidMiddle1 }
  object { DiskBoxLidBottom1 }
  box { // FrontLockBit1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.9, 1.3>
    translate  <16.684034, 0.0, 13.044625>
  }
  scale 0.95
  translate  0.45*z
}
#declare DiskBoxLid = difference {
  object { DiskBoxLid1 }
  object { DiskBoxLid2 }
  cylinder { // DiskBoxLidKeyholeCutout
    <0,0,1>, <0,0,0>, 1 
    scale <0.720014, 0.720014, 3.492505>
    rotate <-90.0, -0.0, 90.0>
    translate  <18.109598, 0.041067, 12.962535>
  }
  material {
    ClearPlastic
  }
}
#declare BottomOfBase = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.999898, -7.30008>,
  <31.000019, -7.299971>,
  <32.001255, 0.000749>,
  <-0.000008, -0.000004>,
  <0.999898, -7.30008>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <1.0, 1.0, 15.5>
  rotate 90.0*x
  translate  <-15.988156, 7.610353, 9.42068>
}
#declare BottomOfBaseCutout = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.999898, -7.30008>,
  <31.000019, -7.299971>,
  <32.001255, 0.000749>,
  <-0.000008, -0.000004>,
  <0.999898, -7.30008>
  rotate -x*90
  material {
    YukkyGreyPlastic
  }
  scale <0.97, 1.0, 15.0>
  rotate 90.0*x
  translate  <-15.592358, 7.412454, 9.740054>
}
#declare BaseBottom1 = difference {
  object { BottomOfBase }
  object { BottomOfBaseCutout }
  material {
    YukkyGreyPlastic
  }
  translate  0.104222*y
}
#declare TopOfBase1 = merge {
  sphere { <0.4620, 0.4620, 0.4620>, 0.0380 }
  sphere { <0.4620, -0.4620, 0.4620>, 0.0380 }
  sphere { <-0.4620, -0.4620, 0.4620>, 0.0380 }
  sphere { <-0.4620, 0.4620, 0.4620>, 0.0380 }
  sphere { <0.4620, 0.4620, -0.4620>, 0.0380 }
  sphere { <0.4620, -0.4620, -0.4620>, 0.0380 }
  sphere { <-0.4620, -0.4620, -0.4620>, 0.0380 }
  sphere { <-0.4620, 0.4620, -0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, 0.4620>, <-0.4620, 0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, -0.4620, 0.4620>, <-0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, -0.4620, -0.4620>, <-0.4620, -0.4620, -0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, -0.4620>, <-0.4620, 0.4620, -0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, -0.4620>, <0.4620, 0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, -0.4620, -0.4620>, <0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <-0.4620, -0.4620, -0.4620>, <-0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <-0.4620, 0.4620, -0.4620>, <-0.4620, 0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, 0.4620>, <0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, -0.4620>, <0.4620, -0.4620, -0.4620>, 0.0380 }
  cylinder { <-0.4620, 0.4620, -0.4620>, <-0.4620, -0.4620, -0.4620>, 0.0380 }
  cylinder { <-0.4620, 0.4620, 0.4620>, <-0.4620, -0.4620, 0.4620>, 0.0380 }
  box { <-0.4620, -0.4620, -0.5000> <0.4620, 0.4620, 0.5000> }
  box { <-0.4620, -0.5000, -0.4620> <0.4620, 0.5000, 0.4620> }
  box { <-0.5000, -0.4620, -0.4620> <0.5000, 0.4620, 0.4620> }
// Attributes returned success!
  material {
    YukkyGreyPlastic
  }
  scale <34.435982, 17.758968, 2.544374>
  translate  <0.077219, 0.0, 10.270085>
}
#declare TopOfBaseCutout = merge {
  sphere { <0.4620, 0.4620, 0.4620>, 0.0380 }
  sphere { <0.4620, -0.4620, 0.4620>, 0.0380 }
  sphere { <-0.4620, -0.4620, 0.4620>, 0.0380 }
  sphere { <-0.4620, 0.4620, 0.4620>, 0.0380 }
  sphere { <0.4620, 0.4620, -0.4620>, 0.0380 }
  sphere { <0.4620, -0.4620, -0.4620>, 0.0380 }
  sphere { <-0.4620, -0.4620, -0.4620>, 0.0380 }
  sphere { <-0.4620, 0.4620, -0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, 0.4620>, <-0.4620, 0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, -0.4620, 0.4620>, <-0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, -0.4620, -0.4620>, <-0.4620, -0.4620, -0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, -0.4620>, <-0.4620, 0.4620, -0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, -0.4620>, <0.4620, 0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, -0.4620, -0.4620>, <0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <-0.4620, -0.4620, -0.4620>, <-0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <-0.4620, 0.4620, -0.4620>, <-0.4620, 0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, 0.4620>, <0.4620, -0.4620, 0.4620>, 0.0380 }
  cylinder { <0.4620, 0.4620, -0.4620>, <0.4620, -0.4620, -0.4620>, 0.0380 }
  cylinder { <-0.4620, 0.4620, -0.4620>, <-0.4620, -0.4620, -0.4620>, 0.0380 }
  cylinder { <-0.4620, 0.4620, 0.4620>, <-0.4620, -0.4620, 0.4620>, 0.0380 }
  box { <-0.4620, -0.4620, -0.5000> <0.4620, 0.4620, 0.5000> }
  box { <-0.4620, -0.5000, -0.4620> <0.4620, 0.5000, 0.4620> }
  box { <-0.5000, -0.4620, -0.4620> <0.5000, 0.4620, 0.4620> }
// Attributes returned success!
  material {
    YukkyGreyPlastic
  }
  scale <32.400002, 16.0, 3.0>
  translate  <0.077219, 0.0, 10.270085>
}
#declare BaseTop1 = difference {
  object { TopOfBase1 }
  object { TopOfBaseCutout }
  material {
    YukkyGreyPlastic
  }
}
#declare DiskBoxInsert10 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <5.300011, -0.000004>,
  <5.300001, 1.499999>,
  <1.499998, 1.499997>,
  <1.499932, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <8.729955, -12.253435, 15.084781>
}
#declare DiskBoxInsert9 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <6.58601, -0.000004>,
  <6.586, 1.499999>,
  <2.785997, 1.499997>,
  <2.785931, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <6.129955, -12.253435, 15.084781>
}
#declare DiskBoxInsert8 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <10.251574, -0.000004>,
  <10.251564, 1.499999>,
  <6.451561, 1.499997>,
  <6.451495, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <3.529955, -12.253435, 15.084781>
}
#declare DiskBoxInsert7 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <7.911607, -0.000004>,
  <7.911596, 1.499999>,
  <4.111594, 1.499997>,
  <4.111527, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <0.929955, -12.253435, 15.084781>
}
#declare DiskBoxInsert6 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <10.676649, -0.000004>,
  <10.676638, 1.499999>,
  <6.876636, 1.499997>,
  <6.876569, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <-1.670045, -12.253435, 15.084781>
}
#declare DiskBoxInsert5 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <7.450666, -0.000004>,
  <7.450656, 1.499999>,
  <3.650653, 1.499997>,
  <3.650587, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <-4.270045, -12.253435, 15.084781>
}
#declare DiskBoxInsert4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <5.300011, -0.000004>,
  <5.300001, 1.499999>,
  <1.499998, 1.499997>,
  <1.499932, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <-6.870045, -12.253435, 15.084781>
}
#declare DiskBoxInsert3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <5.300011, -0.000004>,
  <5.300001, 1.499999>,
  <1.499998, 1.499997>,
  <1.499932, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <-9.470045, -12.253435, 15.084781>
}
#declare DiskBoxInsert2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <5.300011, -0.000004>,
  <5.300001, 1.499999>,
  <1.499998, 1.499997>,
  <1.499932, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <-12.070045, -12.253435, 15.084781>
}
#declare DiskBoxInsert1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-0.000003, -12.799996>,
  <1.700002, -12.800005>,
  <1.699993, -1.8>,
  <6.699994, -1.800002>,
  <6.699991, -12.799992>,
  <7.699959, -12.799999>,
  <7.7, -1.799984>,
  <12.700005, -1.799995>,
  <12.69979, -12.800037>,
  <14.400021, -12.800026>,
  <14.399999, 0.0>,
  <5.300011, -0.000004>,
  <5.300001, 1.499999>,
  <1.499998, 1.499997>,
  <1.499932, 0.000034>,
  <-0.000223, 0.000223>,
  <-0.000003, -12.799996>
  rotate -x*90
  material {
    BrownPlastic
  }
  scale <1.0, 1.0, 0.2>
  rotate <76.703651, 0.0, 90.0>
  translate  <-14.670045, -12.253435, 15.084781>
}
#declare DiskBoxInserts = union {
  object { DiskBoxInsert10 }
  object { DiskBoxInsert9 }
  object { DiskBoxInsert8 }
  object { DiskBoxInsert7 }
  object { DiskBoxInsert6 }
  object { DiskBoxInsert5 }
  object { DiskBoxInsert4 }
  object { DiskBoxInsert3 }
  object { DiskBoxInsert2 }
  object { DiskBoxInsert1 }
  rotate -0.0*y
  translate  <-0.011801, 5.015137, -0.190276>
}
#declare Corner9 = intersection {
  cylinder { // DiskJacketBottomRoundBit16
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit16
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft4 = union {
  object { Corner9 }
  cylinder { // DiskJacketBottomRoundBit17
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit17
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner10 = intersection {
  cylinder { // DiskJacketBottomRoundBit18
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit18
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight4 = union {
  object { Corner10 }
  cylinder { // DiskJacketBottomRoundBit19
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit19
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket4 = union {
  object { RoundBitsLeft4 }
  box { // DiskJacketTop4
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight4 }
  box { // DiskJacketBack4
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit5 = difference {
  box { // DiskInside5
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout5
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot5 = union {
  box { // ReadSlotLongBit5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside5 = difference {
  box { // DiskCase5
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout5
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout6
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot5 }
  cylinder { // BottomNotchLeft5
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight5
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker5 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk5 = union {
  object { FloppyBit5 }
  object { DiskOutside5 }
  object { Sticker5 }
}
#declare FloppyDisk6 = union {
  object { DiskJacket4 }
  object { Disk5 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner11 = intersection {
  cylinder { // DiskJacketBottomRoundBit20
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit20
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft5 = union {
  object { Corner11 }
  cylinder { // DiskJacketBottomRoundBit21
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit21
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner12 = intersection {
  cylinder { // DiskJacketBottomRoundBit22
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit22
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight5 = union {
  object { Corner12 }
  cylinder { // DiskJacketBottomRoundBit23
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit23
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket5 = union {
  object { RoundBitsLeft5 }
  box { // DiskJacketTop5
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight5 }
  box { // DiskJacketBack5
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit6 = difference {
  box { // DiskInside6
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout6
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot6 = union {
  box { // ReadSlotLongBit6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside6 = difference {
  box { // DiskCase6
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout6
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout7
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot6 }
  cylinder { // BottomNotchLeft6
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight6
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker6 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk6 = union {
  object { FloppyBit6 }
  object { DiskOutside6 }
  object { Sticker6 }
}
#declare FloppyDisk7 = union {
  object { DiskJacket5 }
  object { Disk6 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner13 = intersection {
  cylinder { // DiskJacketBottomRoundBit24
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit24
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft6 = union {
  object { Corner13 }
  cylinder { // DiskJacketBottomRoundBit25
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit25
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner14 = intersection {
  cylinder { // DiskJacketBottomRoundBit26
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit26
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight6 = union {
  object { Corner14 }
  cylinder { // DiskJacketBottomRoundBit27
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit27
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket6 = union {
  object { RoundBitsLeft6 }
  box { // DiskJacketTop6
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight6 }
  box { // DiskJacketBack6
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit7 = difference {
  box { // DiskInside7
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout7
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot7 = union {
  box { // ReadSlotLongBit7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside7 = difference {
  box { // DiskCase7
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout7
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout8
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot7 }
  cylinder { // BottomNotchLeft7
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight7
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker7 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerGreen
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk7 = union {
  object { FloppyBit7 }
  object { DiskOutside7 }
  object { Sticker7 }
}
#declare FloppyDisk8 = union {
  object { DiskJacket6 }
  object { Disk7 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup1 = union {
  object { FloppyDisk6 }
  object { FloppyDisk7 }
  object { FloppyDisk8 }
  rotate -0.0*y
  translate  <0.008248, 0.088684, -0.018464>
}
#declare Corner15 = intersection {
  cylinder { // DiskJacketBottomRoundBit28
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit28
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft7 = union {
  object { Corner15 }
  cylinder { // DiskJacketBottomRoundBit29
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit29
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner16 = intersection {
  cylinder { // DiskJacketBottomRoundBit30
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit30
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight7 = union {
  object { Corner16 }
  cylinder { // DiskJacketBottomRoundBit31
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit31
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket7 = union {
  object { RoundBitsLeft7 }
  box { // DiskJacketTop7
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight7 }
  box { // DiskJacketBack7
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit8 = difference {
  box { // DiskInside8
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout8
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot8 = union {
  box { // ReadSlotLongBit8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside8 = difference {
  box { // DiskCase8
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout8
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout9
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot8 }
  cylinder { // BottomNotchLeft8
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight8
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker8 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk8 = union {
  object { FloppyBit8 }
  object { DiskOutside8 }
  object { Sticker8 }
}
#declare FloppyDisk9 = union {
  object { DiskJacket7 }
  object { Disk8 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner17 = intersection {
  cylinder { // DiskJacketBottomRoundBit32
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit32
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft8 = union {
  object { Corner17 }
  cylinder { // DiskJacketBottomRoundBit33
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit33
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner18 = intersection {
  cylinder { // DiskJacketBottomRoundBit34
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit34
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight8 = union {
  object { Corner18 }
  cylinder { // DiskJacketBottomRoundBit35
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit35
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket8 = union {
  object { RoundBitsLeft8 }
  box { // DiskJacketTop8
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight8 }
  box { // DiskJacketBack8
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit9 = difference {
  box { // DiskInside9
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout9
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot9 = union {
  box { // ReadSlotLongBit9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside9 = difference {
  box { // DiskCase9
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout9
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout10
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot9 }
  cylinder { // BottomNotchLeft9
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight9
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker9 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk9 = union {
  object { FloppyBit9 }
  object { DiskOutside9 }
  object { Sticker9 }
}
#declare FloppyDisk10 = union {
  object { DiskJacket8 }
  object { Disk9 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner19 = intersection {
  cylinder { // DiskJacketBottomRoundBit36
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit36
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft9 = union {
  object { Corner19 }
  cylinder { // DiskJacketBottomRoundBit37
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit37
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner20 = intersection {
  cylinder { // DiskJacketBottomRoundBit38
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit38
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight9 = union {
  object { Corner20 }
  cylinder { // DiskJacketBottomRoundBit39
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit39
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket9 = union {
  object { RoundBitsLeft9 }
  box { // DiskJacketTop9
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight9 }
  box { // DiskJacketBack9
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit10 = difference {
  box { // DiskInside10
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout10
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot10 = union {
  box { // ReadSlotLongBit10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside10 = difference {
  box { // DiskCase10
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout10
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout11
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot10 }
  cylinder { // BottomNotchLeft10
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight10
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker10 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mStickerRed
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk10 = union {
  object { FloppyBit10 }
  object { DiskOutside10 }
  object { Sticker10 }
}
#declare FloppyDisk11 = union {
  object { DiskJacket9 }
  object { Disk10 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup2 = union {
  object { FloppyDisk9 }
  object { FloppyDisk10 }
  object { FloppyDisk11 }
  rotate <-0.0, 0.419036, -0.0>
  translate  <-2.711672, 0.088684, 0.066219>
}
#declare Corner21 = intersection {
  cylinder { // DiskJacketBottomRoundBit40
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit40
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft10 = union {
  object { Corner21 }
  cylinder { // DiskJacketBottomRoundBit41
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit41
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner22 = intersection {
  cylinder { // DiskJacketBottomRoundBit42
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit42
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight10 = union {
  object { Corner22 }
  cylinder { // DiskJacketBottomRoundBit43
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit43
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket10 = union {
  object { RoundBitsLeft10 }
  box { // DiskJacketTop10
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight10 }
  box { // DiskJacketBack10
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit11 = difference {
  box { // DiskInside11
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout11
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot11 = union {
  box { // ReadSlotLongBit11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside11 = difference {
  box { // DiskCase11
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout11
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout12
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot11 }
  cylinder { // BottomNotchLeft11
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight11
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker11 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk11 = union {
  object { FloppyBit11 }
  object { DiskOutside11 }
  object { Sticker11 }
}
#declare FloppyDisk12 = union {
  object { DiskJacket10 }
  object { Disk11 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner23 = intersection {
  cylinder { // DiskJacketBottomRoundBit44
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit44
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft11 = union {
  object { Corner23 }
  cylinder { // DiskJacketBottomRoundBit45
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit45
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner24 = intersection {
  cylinder { // DiskJacketBottomRoundBit46
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit46
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight11 = union {
  object { Corner24 }
  cylinder { // DiskJacketBottomRoundBit47
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit47
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket11 = union {
  object { RoundBitsLeft11 }
  box { // DiskJacketTop11
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight11 }
  box { // DiskJacketBack11
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit12 = difference {
  box { // DiskInside12
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout12
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot12 = union {
  box { // ReadSlotLongBit12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside12 = difference {
  box { // DiskCase12
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout12
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout13
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot12 }
  cylinder { // BottomNotchLeft12
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight12
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker12 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk12 = union {
  object { FloppyBit12 }
  object { DiskOutside12 }
  object { Sticker12 }
}
#declare FloppyDisk13 = union {
  object { DiskJacket11 }
  object { Disk12 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner25 = intersection {
  cylinder { // DiskJacketBottomRoundBit48
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit48
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft12 = union {
  object { Corner25 }
  cylinder { // DiskJacketBottomRoundBit49
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit49
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner26 = intersection {
  cylinder { // DiskJacketBottomRoundBit50
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit50
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight12 = union {
  object { Corner26 }
  cylinder { // DiskJacketBottomRoundBit51
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit51
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket12 = union {
  object { RoundBitsLeft12 }
  box { // DiskJacketTop12
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight12 }
  box { // DiskJacketBack12
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit13 = difference {
  box { // DiskInside13
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout13
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot13 = union {
  box { // ReadSlotLongBit13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside13 = difference {
  box { // DiskCase13
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout13
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout14
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot13 }
  cylinder { // BottomNotchLeft13
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight13
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker13 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk13 = union {
  object { FloppyBit13 }
  object { DiskOutside13 }
  object { Sticker13 }
}
#declare FloppyDisk14 = union {
  object { DiskJacket12 }
  object { Disk13 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup3 = union {
  object { FloppyDisk12 }
  object { FloppyDisk13 }
  object { FloppyDisk14 }
  rotate -0.0*y
  translate  <-5.190816, 0.088684, -0.010426>
}
#declare Corner27 = intersection {
  cylinder { // DiskJacketBottomRoundBit52
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit52
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft13 = union {
  object { Corner27 }
  cylinder { // DiskJacketBottomRoundBit53
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit53
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner28 = intersection {
  cylinder { // DiskJacketBottomRoundBit54
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit54
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight13 = union {
  object { Corner28 }
  cylinder { // DiskJacketBottomRoundBit55
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit55
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket13 = union {
  object { RoundBitsLeft13 }
  box { // DiskJacketTop13
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight13 }
  box { // DiskJacketBack13
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit14 = difference {
  box { // DiskInside14
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout14
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot14 = union {
  box { // ReadSlotLongBit14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside14 = difference {
  box { // DiskCase14
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout14
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout15
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot14 }
  cylinder { // BottomNotchLeft14
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight14
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker14 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk14 = union {
  object { FloppyBit14 }
  object { DiskOutside14 }
  object { Sticker14 }
}
#declare FloppyDisk15 = union {
  object { DiskJacket13 }
  object { Disk14 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner29 = intersection {
  cylinder { // DiskJacketBottomRoundBit56
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit56
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft14 = union {
  object { Corner29 }
  cylinder { // DiskJacketBottomRoundBit57
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit57
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner30 = intersection {
  cylinder { // DiskJacketBottomRoundBit58
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit58
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight14 = union {
  object { Corner30 }
  cylinder { // DiskJacketBottomRoundBit59
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit59
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket14 = union {
  object { RoundBitsLeft14 }
  box { // DiskJacketTop14
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight14 }
  box { // DiskJacketBack14
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit15 = difference {
  box { // DiskInside15
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout15
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot15 = union {
  box { // ReadSlotLongBit15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside15 = difference {
  box { // DiskCase15
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout15
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout16
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot15 }
  cylinder { // BottomNotchLeft15
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight15
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker15 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk15 = union {
  object { FloppyBit15 }
  object { DiskOutside15 }
  object { Sticker15 }
}
#declare FloppyDisk16 = union {
  object { DiskJacket14 }
  object { Disk15 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner31 = intersection {
  cylinder { // DiskJacketBottomRoundBit60
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit60
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft15 = union {
  object { Corner31 }
  cylinder { // DiskJacketBottomRoundBit61
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit61
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner32 = intersection {
  cylinder { // DiskJacketBottomRoundBit62
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit62
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight15 = union {
  object { Corner32 }
  cylinder { // DiskJacketBottomRoundBit63
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit63
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket15 = union {
  object { RoundBitsLeft15 }
  box { // DiskJacketTop15
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight15 }
  box { // DiskJacketBack15
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit16 = difference {
  box { // DiskInside16
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout16
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot16 = union {
  box { // ReadSlotLongBit16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside16 = difference {
  box { // DiskCase16
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout16
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout17
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot16 }
  cylinder { // BottomNotchLeft16
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight16
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker16 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk16 = union {
  object { FloppyBit16 }
  object { DiskOutside16 }
  object { Sticker16 }
}
#declare FloppyDisk17 = union {
  object { DiskJacket15 }
  object { Disk16 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup4 = union {
  object { FloppyDisk15 }
  object { FloppyDisk16 }
  object { FloppyDisk17 }
  rotate -0.0*y
  translate  <-7.78996, 0.088684, -0.010426>
}
#declare Corner33 = intersection {
  cylinder { // DiskJacketBottomRoundBit64
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit64
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft16 = union {
  object { Corner33 }
  cylinder { // DiskJacketBottomRoundBit65
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit65
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner34 = intersection {
  cylinder { // DiskJacketBottomRoundBit66
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit66
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight16 = union {
  object { Corner34 }
  cylinder { // DiskJacketBottomRoundBit67
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit67
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket16 = union {
  object { RoundBitsLeft16 }
  box { // DiskJacketTop16
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight16 }
  box { // DiskJacketBack16
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit17 = difference {
  box { // DiskInside17
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout17
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot17 = union {
  box { // ReadSlotLongBit17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside17 = difference {
  box { // DiskCase17
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout17
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout18
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot17 }
  cylinder { // BottomNotchLeft17
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight17
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker17 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk17 = union {
  object { FloppyBit17 }
  object { DiskOutside17 }
  object { Sticker17 }
}
#declare FloppyDisk18 = union {
  object { DiskJacket16 }
  object { Disk17 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner35 = intersection {
  cylinder { // DiskJacketBottomRoundBit68
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit68
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft17 = union {
  object { Corner35 }
  cylinder { // DiskJacketBottomRoundBit69
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit69
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner36 = intersection {
  cylinder { // DiskJacketBottomRoundBit70
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit70
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight17 = union {
  object { Corner36 }
  cylinder { // DiskJacketBottomRoundBit71
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit71
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket17 = union {
  object { RoundBitsLeft17 }
  box { // DiskJacketTop17
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight17 }
  box { // DiskJacketBack17
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit18 = difference {
  box { // DiskInside18
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout18
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot18 = union {
  box { // ReadSlotLongBit18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside18 = difference {
  box { // DiskCase18
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout18
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout19
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot18 }
  cylinder { // BottomNotchLeft18
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight18
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker18 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk18 = union {
  object { FloppyBit18 }
  object { DiskOutside18 }
  object { Sticker18 }
}
#declare FloppyDisk19 = union {
  object { DiskJacket17 }
  object { Disk18 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner37 = intersection {
  cylinder { // DiskJacketBottomRoundBit72
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit72
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft18 = union {
  object { Corner37 }
  cylinder { // DiskJacketBottomRoundBit73
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit73
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner38 = intersection {
  cylinder { // DiskJacketBottomRoundBit74
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit74
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight18 = union {
  object { Corner38 }
  cylinder { // DiskJacketBottomRoundBit75
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit75
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket18 = union {
  object { RoundBitsLeft18 }
  box { // DiskJacketTop18
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight18 }
  box { // DiskJacketBack18
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit19 = difference {
  box { // DiskInside19
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout19
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot19 = union {
  box { // ReadSlotLongBit19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside19 = difference {
  box { // DiskCase19
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout19
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout20
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot19 }
  cylinder { // BottomNotchLeft19
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight19
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker19 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk19 = union {
  object { FloppyBit19 }
  object { DiskOutside19 }
  object { Sticker19 }
}
#declare FloppyDisk20 = union {
  object { DiskJacket18 }
  object { Disk19 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup5 = union {
  object { FloppyDisk18 }
  object { FloppyDisk19 }
  object { FloppyDisk20 }
  rotate -0.0*y
  translate  <-10.385385, 0.088684, -0.010426>
}
#declare Corner39 = intersection {
  cylinder { // DiskJacketBottomRoundBit76
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit76
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft19 = union {
  object { Corner39 }
  cylinder { // DiskJacketBottomRoundBit77
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit77
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner40 = intersection {
  cylinder { // DiskJacketBottomRoundBit78
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit78
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight19 = union {
  object { Corner40 }
  cylinder { // DiskJacketBottomRoundBit79
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit79
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket19 = union {
  object { RoundBitsLeft19 }
  box { // DiskJacketTop19
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight19 }
  box { // DiskJacketBack19
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit20 = difference {
  box { // DiskInside20
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout20
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot20 = union {
  box { // ReadSlotLongBit20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside20 = difference {
  box { // DiskCase20
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout20
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout21
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot20 }
  cylinder { // BottomNotchLeft20
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight20
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker20 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk20 = union {
  object { FloppyBit20 }
  object { DiskOutside20 }
  object { Sticker20 }
}
#declare FloppyDisk21 = union {
  object { DiskJacket19 }
  object { Disk20 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner41 = intersection {
  cylinder { // DiskJacketBottomRoundBit80
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit80
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft20 = union {
  object { Corner41 }
  cylinder { // DiskJacketBottomRoundBit81
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit81
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner42 = intersection {
  cylinder { // DiskJacketBottomRoundBit82
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit82
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight20 = union {
  object { Corner42 }
  cylinder { // DiskJacketBottomRoundBit83
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit83
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket20 = union {
  object { RoundBitsLeft20 }
  box { // DiskJacketTop20
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight20 }
  box { // DiskJacketBack20
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit21 = difference {
  box { // DiskInside21
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout21
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot21 = union {
  box { // ReadSlotLongBit21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside21 = difference {
  box { // DiskCase21
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout21
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout22
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot21 }
  cylinder { // BottomNotchLeft21
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight21
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker21 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk21 = union {
  object { FloppyBit21 }
  object { DiskOutside21 }
  object { Sticker21 }
}
#declare FloppyDisk22 = union {
  object { DiskJacket20 }
  object { Disk21 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner43 = intersection {
  cylinder { // DiskJacketBottomRoundBit84
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit84
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft21 = union {
  object { Corner43 }
  cylinder { // DiskJacketBottomRoundBit85
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit85
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner44 = intersection {
  cylinder { // DiskJacketBottomRoundBit86
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit86
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight21 = union {
  object { Corner44 }
  cylinder { // DiskJacketBottomRoundBit87
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit87
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket21 = union {
  object { RoundBitsLeft21 }
  box { // DiskJacketTop21
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight21 }
  box { // DiskJacketBack21
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit22 = difference {
  box { // DiskInside22
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout22
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot22 = union {
  box { // ReadSlotLongBit22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside22 = difference {
  box { // DiskCase22
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout22
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout23
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot22 }
  cylinder { // BottomNotchLeft22
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight22
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker22 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk22 = union {
  object { FloppyBit22 }
  object { DiskOutside22 }
  object { Sticker22 }
}
#declare FloppyDisk23 = union {
  object { DiskJacket21 }
  object { Disk22 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup6 = union {
  object { FloppyDisk21 }
  object { FloppyDisk22 }
  object { FloppyDisk23 }
  rotate -0.0*y
  translate  <-12.987143, 0.088684, -0.010426>
}
#declare Corner45 = intersection {
  cylinder { // DiskJacketBottomRoundBit88
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit88
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft22 = union {
  object { Corner45 }
  cylinder { // DiskJacketBottomRoundBit89
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit89
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner46 = intersection {
  cylinder { // DiskJacketBottomRoundBit90
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit90
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight22 = union {
  object { Corner46 }
  cylinder { // DiskJacketBottomRoundBit91
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit91
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket22 = union {
  object { RoundBitsLeft22 }
  box { // DiskJacketTop22
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight22 }
  box { // DiskJacketBack22
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit23 = difference {
  box { // DiskInside23
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout23
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot23 = union {
  box { // ReadSlotLongBit23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside23 = difference {
  box { // DiskCase23
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout23
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout24
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot23 }
  cylinder { // BottomNotchLeft23
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight23
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker23 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk23 = union {
  object { FloppyBit23 }
  object { DiskOutside23 }
  object { Sticker23 }
}
#declare FloppyDisk24 = union {
  object { DiskJacket22 }
  object { Disk23 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner47 = intersection {
  cylinder { // DiskJacketBottomRoundBit92
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit92
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft23 = union {
  object { Corner47 }
  cylinder { // DiskJacketBottomRoundBit93
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit93
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner48 = intersection {
  cylinder { // DiskJacketBottomRoundBit94
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit94
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight23 = union {
  object { Corner48 }
  cylinder { // DiskJacketBottomRoundBit95
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit95
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket23 = union {
  object { RoundBitsLeft23 }
  box { // DiskJacketTop23
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight23 }
  box { // DiskJacketBack23
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit24 = difference {
  box { // DiskInside24
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout24
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot24 = union {
  box { // ReadSlotLongBit24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside24 = difference {
  box { // DiskCase24
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout24
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout25
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot24 }
  cylinder { // BottomNotchLeft24
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight24
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker24 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk24 = union {
  object { FloppyBit24 }
  object { DiskOutside24 }
  object { Sticker24 }
}
#declare FloppyDisk25 = union {
  object { DiskJacket23 }
  object { Disk24 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner49 = intersection {
  cylinder { // DiskJacketBottomRoundBit96
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit96
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft24 = union {
  object { Corner49 }
  cylinder { // DiskJacketBottomRoundBit97
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit97
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner50 = intersection {
  cylinder { // DiskJacketBottomRoundBit98
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit98
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight24 = union {
  object { Corner50 }
  cylinder { // DiskJacketBottomRoundBit99
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit99
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket24 = union {
  object { RoundBitsLeft24 }
  box { // DiskJacketTop24
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight24 }
  box { // DiskJacketBack24
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit25 = difference {
  box { // DiskInside25
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout25
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot25 = union {
  box { // ReadSlotLongBit25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside25 = difference {
  box { // DiskCase25
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout25
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout26
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot25 }
  cylinder { // BottomNotchLeft25
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight25
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker25 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk25 = union {
  object { FloppyBit25 }
  object { DiskOutside25 }
  object { Sticker25 }
}
#declare FloppyDisk26 = union {
  object { DiskJacket24 }
  object { Disk25 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup7 = union {
  object { FloppyDisk24 }
  object { FloppyDisk25 }
  object { FloppyDisk26 }
  rotate -0.0*y
  translate  <-15.594607, 0.088684, -0.010426>
}
#declare Corner51 = intersection {
  cylinder { // DiskJacketBottomRoundBit100
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit100
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft25 = union {
  object { Corner51 }
  cylinder { // DiskJacketBottomRoundBit101
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit101
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner52 = intersection {
  cylinder { // DiskJacketBottomRoundBit102
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit102
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight25 = union {
  object { Corner52 }
  cylinder { // DiskJacketBottomRoundBit103
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit103
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket25 = union {
  object { RoundBitsLeft25 }
  box { // DiskJacketTop25
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight25 }
  box { // DiskJacketBack25
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit26 = difference {
  box { // DiskInside26
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout26
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot26 = union {
  box { // ReadSlotLongBit26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside26 = difference {
  box { // DiskCase26
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout26
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout27
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot26 }
  cylinder { // BottomNotchLeft26
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight26
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker26 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk26 = union {
  object { FloppyBit26 }
  object { DiskOutside26 }
  object { Sticker26 }
}
#declare FloppyDisk27 = union {
  object { DiskJacket25 }
  object { Disk26 }
  rotate <75.321053, -0.0, 90.0>
  translate  <7.917475, 0.0, 9.089808>
}
#declare Corner53 = intersection {
  cylinder { // DiskJacketBottomRoundBit104
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit104
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft26 = union {
  object { Corner53 }
  cylinder { // DiskJacketBottomRoundBit105
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit105
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner54 = intersection {
  cylinder { // DiskJacketBottomRoundBit106
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit106
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight26 = union {
  object { Corner54 }
  cylinder { // DiskJacketBottomRoundBit107
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit107
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket26 = union {
  object { RoundBitsLeft26 }
  box { // DiskJacketTop26
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight26 }
  box { // DiskJacketBack26
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit27 = difference {
  box { // DiskInside27
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout27
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot27 = union {
  box { // ReadSlotLongBit27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside27 = difference {
  box { // DiskCase27
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout27
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout28
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot27 }
  cylinder { // BottomNotchLeft27
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight27
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker27 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk27 = union {
  object { FloppyBit27 }
  object { DiskOutside27 }
  object { Sticker27 }
}
#declare FloppyDisk28 = union {
  object { DiskJacket26 }
  object { Disk27 }
  rotate <74.343567, -0.0, 90.0>
  translate  <8.181933, 0.0, 9.089374>
}
#declare Corner55 = intersection {
  cylinder { // DiskJacketBottomRoundBit108
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit108
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsLeft27 = union {
  object { Corner55 }
  cylinder { // DiskJacketBottomRoundBit109
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit109
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
}
#declare Corner56 = intersection {
  cylinder { // DiskJacketBottomRoundBit110
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 2.0>
    rotate -90.0*y
    translate  <-4.816543, -6.657704, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit110
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 2.0>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.612278, -4.861969, 0.003167>
  }
  translate  <0.010095, 0.009412, 0.0>
}
#declare RoundBitsRight27 = union {
  object { Corner56 }
  cylinder { // DiskJacketBottomRoundBit111
    <0,0,1>, <0,0,0>, 1 
    material {
      mBlack
    }
    scale <0.073627, 0.204277, 13.0>
    rotate -90.0*y
    translate  <6.459949, -6.647975, 0.003167>
  }
  cylinder { // DiskJacketLeftRoundBit111
    <0,0,1>, <0,0,0>, 1 
    material {
      mWhite
    }
    scale <0.073627, 0.204277, 9.795>
    rotate <-90.0, -90.0, -180.0>
    translate  <-6.603623, 3.173089, 0.003167>
  }
  rotate <180.0, 0.0, 180.0>
  translate  <0.000204, 0.0, 0.006207>
}
#declare DiskJacket27 = union {
  object { RoundBitsLeft27 }
  box { // DiskJacketTop27
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
      scale <1.999188, 1.996622, 1.0>
      translate <-1.000059, -1.000025, 0.000000>
    }
    scale <6.631048, 4.906599, 0.01>
    translate  <0.0, -1.722518, 0.067461>
  }
  object { RoundBitsRight27 }
  box { // DiskJacketBack27
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWhite
    }
    scale <6.646208, 5.768106, 0.01>
    translate  <0.0, -0.883854, -0.06746>
  }
  scale <1.05, 1.0, 1.0>
}
#declare FloppyBit28 = difference {
  box { // DiskInside28
    <-1, -1, -1>, <1, 1, 1>
    scale <3.149637, 4.560336, 0.005>
    translate  <0.086567, -1.830447, 0.0>
  }
  cylinder { // InsideDiskCutout28
    <0,0,1>, <0,0,0>, 1 
    scale 1.4
    translate  -0.585959*z
  }
  material {
    mDiskInside
  }
}
#declare Slot28 = union {
  box { // ReadSlotLongBit28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.6, 0.5, 1.25>
    translate  -4.284543*z
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <0.002356, -0.3, -5.536322>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale 0.6
    rotate -90.0*x
    translate  <-0.001459, -0.3, -3.033769>
  }
  scale <1.0, 1.0, 0.940463>
  translate  <0.0, 0.010963, -0.555801>
}
#declare DiskOutside28 = difference {
  box { // DiskCase28
    <-1, -1, -1>, <1, 1, 1>
    scale <6.65, 0.05, 6.65>
  }
  cylinder { // CentreCutout28
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // SmallHoleCutout29
    <0,0,1>, <0,0,0>, 1 
    scale 0.3
    rotate -90.0*x
    translate  <2.637776, -0.140866, -0.974885>
  }
  object { Slot28 }
  cylinder { // BottomNotchLeft28
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <-1.290903, 0.082541, -6.632569>
  }
  cylinder { // BottomNotchRight28
    <0,0,1>, <0,0,0>, 1 
    scale 0.15
    rotate 90.0*x
    translate  <1.291143, 0.082541, -6.632569>
  }
  box { // TopNotchCutout28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.3, 0.4>
    rotate 90.0*x
    translate  <6.492076, -0.0, 3.316122>
  }
  material {
    mDiskCase
  }
  rotate -90.0*x
}
#declare Sticker28 = merge {
  sphere { <0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, 0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, 0.4550>, 0.0450 }
  sphere { <0.4550, 0.4550, -0.4550>, 0.0450 }
  sphere { <0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, -0.4550, -0.4550>, 0.0450 }
  sphere { <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, -0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, -0.4550, -0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, -0.4550, -0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, 0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, 0.4550>, <0.4550, -0.4550, 0.4550>, 0.0450 }
  cylinder { <0.4550, 0.4550, -0.4550>, <0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, -0.4550>, <-0.4550, -0.4550, -0.4550>, 0.0450 }
  cylinder { <-0.4550, 0.4550, 0.4550>, <-0.4550, -0.4550, 0.4550>, 0.0450 }
  box { <-0.4550, -0.4550, -0.5000> <0.4550, 0.4550, 0.5000> }
  box { <-0.4550, -0.5000, -0.4550> <0.4550, 0.5000, 0.4550> }
  box { <-0.5000, -0.4550, -0.4550> <0.5000, 0.4550, 0.4550> }
// Attributes returned success!
  material {
    mSticker
    translate <-0.497091, -0.508286, -0.000000>
  }
  scale <6.0, 3.1, 0.01>
  translate  <-3.320195, 4.785773, 0.054381>
}
#declare Disk28 = union {
  object { FloppyBit28 }
  object { DiskOutside28 }
  object { Sticker28 }
}
#declare FloppyDisk29 = union {
  object { DiskJacket27 }
  object { Disk28 }
  rotate <72.131073, -0.0, 90.0>
  translate  <8.601472, 0.0, 9.010871>
}
#declare diskGroup8 = union {
  object { FloppyDisk27 }
  object { FloppyDisk28 }
  object { FloppyDisk29 }
  rotate -0.0*y
  translate  <-18.20207, 0.088684, -0.010426>
}      


//****************************************** disk box **********************************************
union { // DiskBox
  object { DiskBoxLid }
  object { BaseBottom1 }
  object { BaseTop1 }
  object { DiskBoxInserts }
  object { diskGroup1 }
  object { diskGroup2 }
  object { diskGroup3 }
  object { diskGroup4 }
  object { diskGroup5 }
  object { diskGroup6 }
  object { diskGroup7 }
  object { diskGroup8 }
  rotate -90.0*z
  translate  <186.464334, 176.119437, -61.630267>
}             

//***********************************************machine language book ********************************


#declare cover1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, <-0.996643, -5.000000, -0.032837>, <0.002751, -5.000000, 0.025586>, 
      <-3.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, <-0.996643, -4.000000, -0.032837>, <0.002751, -4.000000, 0.025586>, 
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-0.996643, -3.000000, -0.032837>, <0.002751, -3.000000, 0.025586>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-0.996643, -2.000000, -0.032837>, <0.002751, -2.000000, 0.025586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-0.996643, -2.000000, -0.032837>, <0.002751, -2.000000, 0.025586>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-0.996643, -1.000000, -0.032837>, <0.002751, -1.000000, 0.025586>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-0.996643, 0.000000, -0.032837>, <0.002751, 0.000000, 0.025586>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-0.996643, 1.000000, -0.032837>, <0.002751, 1.000000, 0.025586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-0.996643, 1.000000, -0.032837>, <0.002751, 1.000000, 0.025586>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-0.996643, 2.000000, -0.032837>, <0.002751, 2.000000, 0.025586>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-0.996643, 3.000000, -0.032837>, <0.002751, 3.000000, 0.025586>, 
      <-3.000000, 4.000000, 0.000000>, <-2.000000, 4.000000, 0.000000>, <-0.996643, 4.000000, -0.032837>, <0.002751, 4.000000, 0.025586>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.002751, -5.000000, 0.025586>, <1.002146, -5.000000, 0.084009>, <2.010355, -5.000000, 0.248937>, <2.939127, -5.000000, 0.678966>, 
      <0.002751, -4.000000, 0.025586>, <1.002146, -4.000000, 0.084009>, <2.010355, -4.000000, 0.248937>, <2.939127, -4.000000, 0.678966>, 
      <0.002751, -3.000000, 0.025586>, <1.002146, -3.000000, 0.084009>, <2.010355, -3.000000, 0.248937>, <2.939127, -3.000000, 0.678966>, 
      <0.002751, -2.000000, 0.025586>, <1.002146, -2.000000, 0.084009>, <2.010355, -2.000000, 0.248937>, <2.939127, -2.000000, 0.678966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.002751, -2.000000, 0.025586>, <1.002146, -2.000000, 0.084009>, <2.010355, -2.000000, 0.248937>, <2.939127, -2.000000, 0.678966>, 
      <0.002751, -1.000000, 0.025586>, <1.002146, -1.000000, 0.084009>, <2.010355, -1.000000, 0.248937>, <2.939127, -1.000000, 0.678966>, 
      <0.002751, 0.000000, 0.025586>, <1.002146, 0.000000, 0.084009>, <2.010355, 0.000000, 0.248937>, <2.939127, 0.000000, 0.678966>, 
      <0.002751, 1.000000, 0.025586>, <1.002146, 1.000000, 0.084009>, <2.010355, 1.000000, 0.248937>, <2.939127, 1.000000, 0.678966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.002751, 1.000000, 0.025586>, <1.002146, 1.000000, 0.084009>, <2.010355, 1.000000, 0.248937>, <2.939127, 1.000000, 0.678966>, 
      <0.002751, 2.000000, 0.025586>, <1.002146, 2.000000, 0.084009>, <2.010355, 2.000000, 0.248937>, <2.939127, 2.000000, 0.678966>, 
      <0.002751, 3.000000, 0.025586>, <1.002146, 3.000000, 0.084009>, <2.010355, 3.000000, 0.248937>, <2.939127, 3.000000, 0.678966>, 
      <0.002751, 4.000000, 0.025586>, <1.002146, 4.000000, 0.084009>, <2.010355, 4.000000, 0.248937>, <2.939127, 4.000000, 0.678966>
    }
  }
  material {
    mMLBookCover
    scale <5.939737, 8.999297, 0.977757>
    translate <-3.000917, -4.998916, 0.013513>
  }
  scale <2.539, 2.5399, 1.0>
  rotate -0.101613*y
  translate  <-0.048387, 1.2813, 1.624752>
}
union { // MachineLanguageBook
  box { // Spine
    <-1, -1, -1>, <1, 1, 1>
    material {
      mMLBookSpine
      scale <2.000034, 2.050901, 10.290773>
      rotate <-90.0, -180.0, 90.0>
      translate <0.000000, 0.999788, -1.022273>
    }
    scale <0.05, 11.4, 1.61>
    translate  <-7.640981, 0.0, 0.000458>
  }
  object { cover1 }
  box { // pages
    <-1, -1, -1>, <1, 1, 1>
    material {
      DirtyWhitePages
    }
    scale <7.65, 11.4, 1.6>
  }
  rotate <1.293178, 0.081219, 10.381664>
  translate  <123.602256, 183.38179, -48.965571>
}




//*************************************disk drive CABLE ************************************************
  
//MegaPov
  
 sphere_sweep {                  
    b_spline_sphere_sweep, 13,      
    
    <112.401, 153.893, -58.679>, 0.3
    <112.802, 154.247, -58.679>, 0.3
    <115.513, 156.165, -58.679>, 0.3
    <118.701, 156.360, -58.679>, 0.3
    <121.848, 156.862, -58.679>, 0.3
    <125.361, 156.907, -58.679>, 0.3
    <128.918, 156.634, -58.679>, 0.3
    <132.659, 156.314, -58.679>, 0.3
    <134.711, 158.641, -58.679>, 0.3
    <134.346, 161.879, -58.679>, 0.3
    <133.023, 165.482, -58.679>, 0.3
    <132.887, 169.040, -58.679>, 0.3
    <133.297, 172.872, -58.679>, 0.3    
      
    material { YukkyGreyPlastic}
}         
      


//*************************************** disk drive cable plug *************************************

#declare PlugTop = lathe {
  linear_spline
  11  // control points
  <0.599749, -2.50018>,
  <0.627447, -2.114259>,
  <0.692968, -1.745843>,
  <0.800683, -1.399456>,
  <0.800046, -0.100854>,
  <0.649958, -0.000032>,
  <0.021782, -0.006455>,
  <0.001832, -3.199715>,
  <0.609939, -3.200039>,
  <0.610145, -2.500173>,
  <0.599749, -2.50018>
  rotate <90,0,90>
}
#declare PointyBit = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>,
  <-0.655515, -0.793106>,
  <0.002123, -1.010616>,
  <0.669039, -0.766142>,
  <1.010616, -0.008493>,
  <0.710981, 0.726539>,
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>
  rotate <90,0,90>
  scale <-0.049789, -0.049786, -0.145023>
  rotate -180.0*z
  translate  <1.077383, 1.371901, 2.765303>
}
#declare MetalPin1 = union {
  object { PointyBit }
  cylinder { // Pin1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    translate  <1.077383, 1.372396, 1.820299>
  }
  translate  <-1.083387, -1.375269, -1.774153>
}
#declare PointyBit1 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>,
  <-0.655515, -0.793106>,
  <0.002123, -1.010616>,
  <0.669039, -0.766142>,
  <1.010616, -0.008493>,
  <0.710981, 0.726539>,
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>
  rotate <90,0,90>
  scale <-0.049789, -0.049786, -0.145023>
  rotate -180.0*z
  translate  <1.077383, 1.371901, 2.765303>
}
#declare MetalPin2 = union {
  object { PointyBit1 }
  cylinder { // Pin2
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    translate  <1.077383, 1.372396, 1.820299>
  }
  translate  <-1.428203, -1.520244, -1.774153>
}
#declare PointyBit2 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>,
  <-0.655515, -0.793106>,
  <0.002123, -1.010616>,
  <0.669039, -0.766142>,
  <1.010616, -0.008493>,
  <0.710981, 0.726539>,
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>
  rotate <90,0,90>
  scale <-0.049789, -0.049786, -0.145023>
  rotate -180.0*z
  translate  <1.077383, 1.371901, 2.765303>
}
#declare MetalPin3 = union {
  object { PointyBit2 }
  cylinder { // Pin3
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    translate  <1.077383, 1.372396, 1.820299>
  }
  translate  <-0.738795, -1.527074, -1.774153>
}
#declare PointyBit3 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>,
  <-0.655515, -0.793106>,
  <0.002123, -1.010616>,
  <0.669039, -0.766142>,
  <1.010616, -0.008493>,
  <0.710981, 0.726539>,
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>
  rotate <90,0,90>
  scale <-0.049789, -0.049786, -0.145023>
  rotate -180.0*z
  translate  <1.077383, 1.371901, 2.765303>
}
#declare MetalPin4 = union {
  object { PointyBit3 }
  cylinder { // Pin4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    translate  <1.077383, 1.372396, 1.820299>
  }
  translate  <-0.752184, -1.175484, -1.774153>
}
#declare PointyBit4 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>,
  <-0.655515, -0.793106>,
  <0.002123, -1.010616>,
  <0.669039, -0.766142>,
  <1.010616, -0.008493>,
  <0.710981, 0.726539>,
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>
  rotate <90,0,90>
  scale <-0.049789, -0.049786, -0.145023>
  rotate -180.0*z
  translate  <1.077383, 1.371901, 2.765303>
}
#declare MetalPin5 = union {
  object { PointyBit4 }
  cylinder { // Pin5
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    translate  <1.077383, 1.372396, 1.820299>
  }
  translate  <-1.414956, -1.148705, -1.774153>
}
#declare PointyBit5 = prism {
  conic_sweep
  cubic_spline
  0.0,1.0
  11  // control points
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>,
  <-0.655515, -0.793106>,
  <0.002123, -1.010616>,
  <0.669039, -0.766142>,
  <1.010616, -0.008493>,
  <0.710981, 0.726539>,
  <-0.002123, 1.021231>,
  <-0.713464, 0.71729>,
  <-0.989384, -0.023355>
  rotate <90,0,90>
  scale <-0.049789, -0.049786, -0.145023>
  rotate -180.0*z
  translate  <1.077383, 1.371901, 2.765303>
}
#declare MetalPin6 = union {
  object { PointyBit5 }
  cylinder { // Pin6
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.8>
    translate  <1.077383, 1.372396, 1.820299>
  }
  translate  <-1.093612, -0.974644, -1.774153>
}
#declare Pins = union {
  object { MetalPin1 }
  object { MetalPin2 }
  object { MetalPin3 }
  object { MetalPin4 }
  object { MetalPin5 }
  object { MetalPin6 }
  translate  -0.12944*z
}
#declare MetalEndBit = difference {
  cylinder { // MetalBitOutside
    <0,0,1>, <0,0,0>, 1 
    scale <0.65, 0.65, 0.9>
  }
  cylinder { // MetalBitInside
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 1.0>
    translate  -0.045944*z
  }
}
#declare MetalBit = union {
  object { Pins }
  object { MetalEndBit }
  material {
    Aluminum
  }
}
#declare PlasticEndBase = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <0.05, -1.5>,
  <1.050054, -1.500109>,
  <1.100017, -0.000001>,
  <-0.000023, 0.000035>,
  <0.05, -1.5>
  rotate -x*90
  scale <1.106864, 1.0, 0.2>
  rotate <90.0, -0.0, 90.0>
  translate  <-0.1, -0.60801, -3.200774>
}
#declare DiskDrivePlug = union {
  object { PlugTop }
  torus { // Ridge1
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.551376*z
  }
  torus { // Ridge2
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.601376*z
  }
  torus { // Ridge3
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.651376*z
  }
  torus { // Ridge4
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.701376*z
  }
  torus { // Ridge5
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.751376*z
  }
  torus { // Ridge6
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.801376*z
  }
  torus { // Ridge7
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.851376*z
  }
  torus { // Ridge8
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.901376*z
  }
  torus { // Ridge9
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -2.951376*z
  }
  torus { // Ridge10
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -3.001376*z
  }
  torus { // Ridge11
    1.5, 0.5  rotate -x*90
    scale <0.334737, 0.334737, 0.05>
    translate  -3.051376*z
  }
  object { MetalBit }
  object { PlasticEndBase }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.607275, 0.607275, 0.1>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -3.33703>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <0.6, 0.6, 0.1>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -3.53703>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.59, 0.59, 0.1>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -3.73703>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <0.58, 0.58, 0.1>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -3.93703>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.57, 0.57, 0.1>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -4.13703>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <0.56, 0.56, 0.1>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -4.33703>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <0.555, 0.555, 0.2>
    rotate <180.0, -0.0, -90.0>
    translate  <-0.0, 0.0, -4.53703>
  }
  cylinder { // CordInEndBit
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    rotate <180.0, -0.0, -90.0>
    translate  -2.732109*z
  }
  material {
    YukkyGreyPlastic
  }
  rotate  <135, 90, 0>   //-90.0*y
  translate  < -3.5397, -5.2425, 0>    //<-2.218044, 0.0, 0.0>
}
union { // DiskDriveCableAndPlug
  //object { Cable }
  object { DiskDrivePlug }
  translate  <112.998298, 156.166009, -58.678085>
}



//*********************************************** joystick cable ***********************************

//     use with MegaPov
sphere_sweep {                  
    b_spline_sphere_sweep, 22,
      
    <184.3, 144, -57.5>, 0.2  //1
    <183.9, 144, -57.5>, 0.2  //2
    <182, 143.2, -57.5>, 0.2  //3
    <180, 143.5, -57>, 0.2  //3a
    <177.8, 146, -55>, 0.2   //4
    <180, 150, -54>, 0.2     //5
    <185, 151, -53>, 0.2     //6
    <189.2, 148.5, -54>, 0.2   //7
    <191.3, 143.8, -55>, 0.2   //8
    <190.8, 139.5, -56 >, 0.2  //9
    <185, 138.5, -58>, 0.2       //10
    <181, 139.8, -58.5 >, 0.2    //11
    <178.5, 142.9, -58.5 >, 0.2   //12
    <177, 139, -58.5 >, 0.2       //13
    <181, 136.5, -58.5>, 0.2      //14
    <183, 139, -58>, 0.2     //15
    <181.5, 143.6, -58.5>, 0.2  //16
    <183, 152, -58.5>, 0.2    //17
    <191.5, 154, -58.5>, 0.2  //18
    <197, 146, -58> , 0.2     //19
    <195.5, 140, -58.5 >, 0.2   //20
    <191, 134, -58.5>, 0.2      //21
    
    material {ShinyBlackChairLegs}
    }
    


















//**************************************** wall pannelling *********************************************



#declare WallPanelsRight = union {
  box { // WallPanel1
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.866242, 0.000000>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 190.0, 0.0>
  }
  box { // WallPanel2
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.144374, -0.072187>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 169.6, 0.0>
  }
  box { // WallPanel3
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, 0.000000, 0.445152>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 149.2, 0.0>
  }
  box { // WallPanel4
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, 0.721868, -0.144374>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 128.8, 0.0>
  }
  box { // WallPanel5
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.433121, 0.000000>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 108.4, 0.0>
  }
  box { // BlackBitInWallPanelling
    <-1, -1, -1>, <1, 1, 1>
    material {
      mBlack
    }
    scale <0.1, 100.0, 120.0>
    translate  <199.987707, 100.0, 0.0>
  }
}
#declare WallPanelsBack = union {
  box { // WallPanel6
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.866242, 0.000000>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 190.0, 0.0>
  }
  box { // WallPanel7
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.144374, -0.072187>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 169.6, 0.0>
  }
  box { // WallPanel8
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, 0.000000, 0.445152>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 149.2, 0.0>
  }
  box { // WallPanel9
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, 0.721868, -0.144374>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 128.8, 0.0>
  }
  box { // WallPanel10
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.433121, 0.000000>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 108.4, 0.0>
  }
  box { // BlackBitInWallPanelling1
    <-1, -1, -1>, <1, 1, 1>
    material {
      mBlack
    }
    scale <0.1, 100.0, 120.0>
    translate  <199.987707, 100.0, 0.0>
  }
  rotate 90.0*z
  translate  <297.918355, 0.008459, 0.0>
}
union { // WallPanelling
  object { WallPanelsRight }
  object { WallPanelsBack }
  translate  <0.165375, 0.151491, 0.0>
}




union { // WallPanelsRight1
  box { // WallPanel11
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.866242, 0.000000>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 190.0, 0.0>
  }
  box { // WallPanel12
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.144374, -0.072187>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 169.6, 0.0>
  }
  box { // WallPanel13
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, 0.000000, 0.445152>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 149.2, 0.0>
  }
  box { // WallPanel14
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, 0.721868, -0.144374>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 128.8, 0.0>
  }
  box { // WallPanel15
    <-1, -1, -1>, <1, 1, 1>
    material {
      mWoodPanelling
      scale <1.0, 1.5, 1.0>
      translate <0.000000, -0.433121, 0.000000>
    }
    scale <0.1, 10.0, 120.0>
    translate  <199.921147, 108.4, 0.0>
  }
  translate  <0.160726, -101.789667, 0.0>
}


//***************************** bit of paper with balloon sprite on it ********************************** 
 


union { // BezPtch002
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, 0.000000>, <-1.000000, -5.000000, 0.000000>, <0.000000, -5.000000, 0.000000>, 
      <-3.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, 0.000000>, <-1.000000, -4.000000, 0.000000>, <0.000000, -4.000000, 0.000000>, 
      <-3.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, 0.000000>, <-1.000000, -3.000000, 0.000000>, <0.000000, -3.000000, 0.000000>, 
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, 
      <-3.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, 0.000000>, <-1.000000, 2.000000, 0.000000>, <0.000000, 2.000000, 0.000000>, 
      <-3.000000, 3.000000, 0.000000>, <-2.000000, 3.000000, 0.000000>, <-1.000000, 3.000000, 0.000000>, <0.000000, 3.000000, 0.000000>, 
      <-3.000000, 4.000000, 0.000000>, <-2.000000, 4.000000, 0.000000>, <-1.000000, 4.000000, 0.000000>, <0.000000, 4.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -5.000000, 0.000000>, <1.000000, -5.000000, 0.000000>, <2.000000, -5.000000, 0.000000>, <3.000000, -5.000000, 0.000000>, 
      <0.000000, -4.000000, 0.000000>, <1.000000, -4.000000, 0.000000>, <2.000000, -4.000000, 0.000000>, <3.000000, -4.000000, 0.000000>, 
      <0.000000, -3.000000, 0.000000>, <1.000000, -3.000000, 0.000000>, <2.000000, -3.000000, 0.000000>, <3.000000, -3.000000, 0.000000>, 
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>, 
      <0.000000, 2.000000, 0.000000>, <1.000000, 2.000000, 0.000000>, <2.000000, 2.000000, 0.000000>, <3.000000, 2.000000, 0.000000>, 
      <0.000000, 3.000000, 0.000000>, <1.000000, 3.000000, 0.000000>, <2.000000, 3.000000, 0.000000>, <3.000000, 3.000000, 0.000000>, 
      <0.000000, 4.000000, 0.000000>, <1.000000, 4.000000, 0.000000>, <2.000000, 4.000000, 0.000000>, <3.000000, 4.000000, 0.000000>
    }
  }
  material {
    mProgram
    scale <6.063444, 12.823448, 1.0> *0.8
    translate <-3.036152, -6.5, 0.000000>
  }
  scale <3.49695, 2.4, 1.0>
  rotate <90.0, 0.0, -0.0>
  translate  <133.542479, 199.981095, -34.702916>
}
