#include "colors.inc"
#include "stones.inc"

camera {
  location <90,35,-110>
  look_at <0,20,-50>
  angle 45
  blur_samples 50
  aperture 2.5
  confidence 0.97
  focal_point <0,20,-50>
}

light_source {
  <200,500,-1400>
  color Gray60
  area_light <50,0,0>,<0,50,0>,3,3
  adaptive 1
  media_interaction off
}

#declare Hand = blob {
  threshold 0.65
  sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }
  sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }
  sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> }
  sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> }
  sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> }
  sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> }
  cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }
  cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }
  cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }
  cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }
  cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }
  cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }
  cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }
  cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }
  cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }
  cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }
  sphere { <-.65,.28,-.05>, .26, -1 }
  sphere { <-.65,-.28,0>, .26, -1 }
  sphere { <-.3,.44,-.05>, .26, -1 }
  sphere { <-.3,-.28,0>, .26, -1 }
  sphere { <.05,.49,-.05>, .26, -1 }
  sphere { <.05,-.28,0>, .26, -1 }
  sphere { <.4,.512,-.05>, .26, -1 }
  sphere { <.4,-.4,0>, .26, -1 }
  sphere { <.85,-.68,-.05>, .25, -1 }
  sphere { <.41,-.7,0>, .25, -.89 }
}

#declare Chrystal1 = union {
  sphere { <-19,11.7,0>,3 hollow
    pigment { color rgbf <0.2,0.2,0.8,0.9> }
    finish {
      ambient 0.1 diffuse 0.2
      phong 1 phong_size 100 reflection 0.3
      refraction 1 ior 1.33
    }
  }
  light_source {
    <-19,11.7,0>
    color White
    area_light <-2,0,0>,<0,0,2>,3,3
    adaptive 1
    fade_distance 35
    fade_power 2
    media_interaction off
  }
}

#declare Chrystal2 = union {
  sphere { <19,11.7,0>,3 hollow
    pigment { color rgbf <0.2,0.2,0.8,0.9> }
    finish {
      ambient 0.1 diffuse 0.2
      phong 1 phong_size 100 reflection 0.3
      refraction 1 ior 1.33
    }
  }
  light_source {
    <19,11.7,0>
    color White
    area_light <-2,0,0>,<0,0,2>,3,3
    adaptive 1
    fade_distance 35
    fade_power 2
    media_interaction off
  }
}

#declare Arm = union {
  sphere { <-3,5,0>,1.8 }
  cone { <-3,5,0>,1.8,<-10,4,0>,1.5 }
  sphere { <-10,4,0>,1.5 }
  cone { <-10,4,0>,1.5,<-15,8,0>,1 }
  sphere { <-15,8,0>,1 }
  object { Hand scale 3 rotate y*-90 rotate z*90
           translate <-19,8.7,0.6> }
}

#declare AugenFormY = union {
  sphere { <0,0,0>,3.6 scale <1,2.0,1> clipped_by {plane{ y,0}}}
	sphere { <0,0,0>,3.6 scale <1,1.0,1> clipped_by {plane{-y,0}}}
}

#declare AugenFormZ = union {
  object { AugenFormY scale <1,1,1.0> clipped_by {plane{ z,0}}}
	object { AugenFormY scale <1,1,2.0> clipped_by {plane{-z,0}}}
 // pigment { Black }
 // finish { ambient 0.2 diffuse 0.5 specular 0.8 roughness 0.03 reflection 0.2 }
}

#declare Kopf = union {
  difference {
    union {
  		sphere { <0,0,0>,10 scale <1,1.3,0.5> clipped_by {plane { y,0}} rotate x*30}
	    sphere { <0,0,0>,10 scale <1,0.7,0.5> clipped_by {plane {-y,0}} rotate x*30}
    }
		cylinder { <-1,-8,0>,<-1,-8,-10>,0.5 rotate x*30 }  // Nasenlcher
		cylinder { < 1,-8,0>,< 1,-8,-10>,0.5 rotate x*30 }
    cylinder { <0,-11,0>,<0,-11,-10>,0.7 rotate x*30 }
	}
	object { AugenFormZ rotate z*-40
	         translate <0,-1,-8> rotate y*-38 scale <1,1,0.5> rotate x*30}
	object { AugenFormZ rotate z* 40
	         translate <0,-1,-8> rotate y* 38 scale <1,1,0.5> rotate x*30}
	cylinder { <0,0,0>,<0,-15,0>,2 }
}

#declare Koerper = blob {
  threshold 0.5
  sphere { <0,0,0>,20,1 scale <0.6,0.8,0.25> }                   // Oberkrper
  sphere { <0,0,0>,20,1 scale z*0.7 translate < 0,-10,-3> }     // Bauch
  sphere { <0,0,0>, 8,1 scale z*0.4 translate <-5, 1 ,-3> }
  sphere { <0,0,0>, 8,1 scale z*0.4 translate < 5, 1 ,-3> }
}

#declare Sockel = union {
  cylinder { <-10, -0.5,-10>,< 10, -0.5,-10>,0.5 }
  cylinder { <-10, -10, -10>,< 10, -10 ,-10>,0.5 }
  cylinder { <-10, -0.5,-10>,<-10, -10 ,-10>,0.5 }
  cylinder { < 10, -0.5,-10>,< 10, -10 ,-10>,0.5 }
  sphere { <-10, -0.5,-10>,0.5 }
  sphere { <-10, -10 ,-10>,0.5 }
  sphere { < 10, -0.5,-10>,0.5 }
  sphere { < 10, -10 ,-10>,0.5 }
}

#declare Statue = union {
  object { Koerper scale 0.7 translate y*3 }
  object { Arm translate x*-2 }
  object { Arm translate x*-2 scale <-1,1,1> }
  object { Chrystal1 }
  object { Chrystal2 }
  object { Kopf scale 0.6 translate y*13}
  box { <-10,-9.5,-10>,<10,0,10> translate y*-5 }
  object { Sockel rotate y*0   translate y*-5 }
  object { Sockel rotate y*90  translate y*-5 }
  object { Sockel rotate y*180 translate y*-5 }
  object { Sockel rotate y*270 translate y*-5 }
  texture { T_Stone14 }
}

object { Statue
  rotate y*-0
  scale 1.5
  translate <0,15*1.5,-25>
}

plane {
  y,0
  pigment { color rgb <0.5,0.4,0.2> }
  normal { bumps 0.6 scale 1 }
  finish { ambient 0.4 diffuse 0.6 }
  hollow
}

// Hinterwand
//=====================================================
#declare S1 = seed (22412)
#declare odd = 4
#declare ypos=37;
#while (ypos>-5)
#declare xpos=-150+odd-7;
#while (xpos<50)
blob {
  threshold 0.2
  cylinder { <-1,0,0>,<1,0,0>,3,2 }
  #declare anz = 10;
  #while (anz>0)
  sphere {
    <0,0,0>,1+rand(S1),0.17
    scale <rand(S1)+1,rand(S1)+1,rand(S1)+1>
    rotate <rand(S1)*360,rand(S1)*360,rand(S1)*360>
    translate <rand(S1)*6-3,rand(S1)*4-2,rand(S1)*2-1>
  }
  #declare anz=anz-1;
  #end
  scale <1,1,0.6>
  texture {
    T_Grnt9
    finish { ambient 0.2 diffuse 0.4 } //phong 0.7 phong_size 90 }
    translate <rand(S1)*100,rand(S1)*100,rand(S1)*100>
    scale 3
  }
  #declare xpos=xpos+7;
  translate <xpos+rand(S1)/2,ypos+rand(S1)/2,0>
}
#end
#declare ypos=ypos-5;
#if (odd=4) #declare odd=0; #else #declare odd=4; #end
#end

box {
 <-150,0,-0.5>,<50,37,0.5>
 pigment { Gray40 }
 normal { bumps 0.5 scale 0.2 }
}

//=====================================================
// Seitenwand
//=====================================================
#declare S1 = seed (22412)
#declare odd = 4;
#declare ypos=37;
#while (ypos>-10)
#declare xpos=0+odd-7
#while (xpos<100)
blob {
  threshold 0.2
  cylinder { <-1,0,0>,<1,0,0>,3,2 }
  #declare anz = 10;
  #while (anz>0)
  sphere {
    <0,0,0>,1+rand(S1),0.17
    scale <rand(S1)+1,rand(S1)+1,rand(S1)+1>
    rotate <rand(S1)*360,rand(S1)*360,rand(S1)*360>
    translate <rand(S1)*6-3,rand(S1)*4-2,rand(S1)*2-1>
  }
  #declare anz=anz-1;
  #end
  scale <1,1,0.6>
  texture {
    T_Grnt9
    finish { ambient 0.2 diffuse 0.4 } //phong 0.7 phong_size 90 }
    translate <rand(S1)*100,rand(S1)*100,rand(S1)*100>
    scale 3
  }
  #declare xpos=xpos+7;
  translate <xpos+rand(S1)/2,ypos+rand(S1)/2,0>
  rotate y*90
  translate x*-150
}
#end
#declare ypos=ypos-5;
#if (odd=4) #declare odd=0; #else #declare odd=4; #end
#end

box {
 <-150-0.5,0,0>,<-150+0.5,37,-100>
 pigment { Gray40 }
}
//=====================================================

// Gras
//=====================================================
#declare Anz = 15000;
#while (Anz>0)
  torus { 2,0.09
    rotate x*90
    scale <1,1+rand(S1)*3,1>
    clipped_by { plane { x,0 rotate z*(rand(S1)*30-10) } }
    rotate y*rand(S1)*360
    pigment { color rgb <0.4,0.9,0.1> }
    finish { ambient 0.3 diffuse 0.5}
    translate <rand(S1)*-200+55,0,rand(S1)*-100-5>
  }
  #declare Anz=Anz-1;
#end


#declare Hand = blob {
  threshold 0.6
  // --------------- 1.Finger -------------------------------------------------------
	cylinder { <0,0.0,0>,<0,2.5,0>,2,1 rotate z*-20 translate y*5     // Fingerkuppe
	                                   rotate z*-25 translate y*5
																		 rotate z*-30 }
  cylinder { <0,0.0,0>,<0,4.0,0>,2,1 rotate z*-25 translate y*5     // 1.Glied
	                                   rotate z*-30 }
  cylinder { <0,0,0>,<0,5.0,0>,2.2,1 rotate z*-30 }                 // 2.Glied
  // --------------- 2.Finger -------------------------------------------------------
	cylinder { <0,0.0,0>,<0,2.5,0>,2,1 rotate z*-20 translate y*5        // Fingerkuppe
	                                   rotate z*-15 translate y*5
																		 rotate z*-20
																		 rotate x*-20 translate z*-2.5 }
  cylinder { <0,0.0,0>,<0,4.0,0>,2,1 rotate z*-15 translate y*5        // 1.Glied
	                                   rotate z*-20
	                                   rotate x*-20 translate z*-2.5 }
  cylinder { <0,0,0>,<0,5.0,0>,2.2,1 rotate z*-20                      // 2.Glied
	                                   rotate x*-20 translate z*-2.5 }
  // --------------- 3.Finger -------------------------------------------------------
	cylinder { <0,0.0,0>,<0,3.5,0>,2,1 rotate z*-20 translate y*6     // Fingerkuppe
	                                   rotate z*-15 translate y*8
																		 rotate x*-40 translate z*-5 }
  cylinder { <0,0.0,0>,<0,5.0,0>,2,1 rotate z*-15 translate y*8     // 1.Glied
	                                   rotate x*-40 translate z*-5 }
  cylinder { <0,0,0>,<0,7.0,0>,2.2,1 rotate x*-40 translate z*-5 }  // 2.Glied
  // ---------------- HandWurzel ----------------------------------------------------
	cylinder { <0,0,0>,<0,0,-5>,2.3,1 scale y*1.5 translate y*-1.5  }
	sphere   { <0,-3,-2.5>,4,1 }
	sphere   { <0,-3,0 >,4,1 }
	translate y*3
	rotate y*-90
  translate x*-2
	rotate z*20
	scale 1.2
}

#declare S1 = seed (3234)
#declare UnterArm = blob {
  threshold 0.5
  // Unterarm
	sphere { <0,0,0>,2.4,1 translate <rand(S1)*0.4-0.2,- 0.0+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.4,1 translate <rand(S1)*0.4-0.2,- 1.5+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.3,1 translate <rand(S1)*0.4-0.2,- 3.0+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
  sphere { <0,0,0>,2.3,1 translate <rand(S1)*0.4-0.2,- 4.5+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.2,1 translate <rand(S1)*0.4-0.2,- 6.0+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.2,1 translate <rand(S1)*0.4-0.2,- 7.5+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.1,1 translate <rand(S1)*0.4-0.2,- 9.0+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
  sphere { <0,0,0>,2.1,1 translate <rand(S1)*0.4-0.2,-10.5+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.0,1 translate <rand(S1)*0.4-0.2,-12.0+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	sphere { <0,0,0>,2.0,1 translate <rand(S1)*0.4-0.2,-13.5+rand(S1)*0.2-0.1,rand(S1)*0.4-0.2>}
	scale 2.5
}

#declare OberArm = blob {
  threshold 0.5
  // Oberarm
	sphere { <0,0,0>,2.8,1 translate <rand(S1)*0.2-0.1,- 0.0+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.8,1 translate <rand(S1)*0.2-0.1,- 1.5+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.7,1 translate <rand(S1)*0.2-0.1,- 3.0+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
  sphere { <0,0,0>,2.7,1 translate <rand(S1)*0.2-0.1,- 4.5+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.7,1 translate <rand(S1)*0.2-0.1,- 6.0+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.6,1 translate <rand(S1)*0.2-0.1,- 7.5+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.6,1 translate <rand(S1)*0.2-0.1,- 9.0+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
  sphere { <0,0,0>,2.6,1 translate <rand(S1)*0.2-0.1,-10.5+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.5,1 translate <rand(S1)*0.2-0.1,-12.0+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	sphere { <0,0,0>,2.5,1 translate <rand(S1)*0.2-0.1,-13.5+rand(S1)*0.2-0.1,rand(S1)*0.2-0.1>}
	scale 2.5
}

#declare Arm =  union {
  union { // unterer Arm und Hand
	  object { Hand rotate x*210 rotate y*60 translate y*(-13.5*2.5)}
    object { UnterArm }
		rotate z*-40
  	translate y*(-13.5*2.5)
	}
	object { OberArm }
	rotate z*70
}

#declare Koerper = blob {
  threshold 0.5
	sphere { <0,0,0>,20,1 scale <0.6,0.8,0.25> }                   // Oberkrper
	sphere { <0,0,0>,20,1 scale z*0.7 translate < 0,-10,-3> }     // Bauch
	sphere { <0,0,0>, 8,1 scale z*0.4 translate <-5, 1 ,-3> }
	sphere { <0,0,0>, 8,1 scale z*0.4 translate < 5, 1 ,-3> }
}

#declare AugenFormY = union {
  sphere { <0,0,0>,3.6 scale <1,2.0,1> clipped_by {plane{ y,0}}}
	sphere { <0,0,0>,3.6 scale <1,1.0,1> clipped_by {plane{-y,0}}}
}

#declare AugenFormZ = union {
  object { AugenFormY scale <1,1,1.0> clipped_by {plane{ z,0}}}
	object { AugenFormY scale <1,1,2.0> clipped_by {plane{-z,0}}}
  pigment { Black }
	finish { ambient 0.2 diffuse 0.5 specular 0.8 roughness 0.03 reflection 0.2 }
}

#declare Kopf = union {
  difference {
    union {
  		sphere { <0,0,0>,10 scale <1,1.3,0.5> clipped_by {plane { y,0}} rotate x*30}
	    sphere { <0,0,0>,10 scale <1,0.7,0.5> clipped_by {plane {-y,0}} rotate x*30}
    }
		cylinder { <-1,-8,0>,<-1,-8,-10>,0.5 rotate x*30 }  // Nasenlcher
		cylinder { < 1,-8,0>,< 1,-8,-10>,0.5 rotate x*30 }
    cylinder { <0,-11,0>,<0,-11,-10>,0.7 rotate x*30 }
	}
	object { AugenFormZ rotate z*-40
	         translate <0,-1,-8> rotate y*-38 scale <1,1,0.5> rotate x*30}
	object { AugenFormZ rotate z* 40
	         translate <0,-1,-8> rotate y* 38 scale <1,1,0.5> rotate x*30}
	cylinder { <0,0,0>,<0,-15,0>,2 }
}

#declare Duese = union {
  cylinder { <0,-0.7,5.3>,<0,-3,5.3>,1 }
  cylinder { <0,-100,5.3>,<0,-3,5.3>,0.8 
    hollow  
    pigment { rgbt <1,1,1,1> } 
    interior {
      media {      
        emission 0.3
        intervals 20
        samples 1,50
        confidence 0.95
        variance 1/128
      
        density {
          gradient y   
          turbulence 0.4
          density_map {
            [ 0.0 rgb <1  ,1  ,1> ]
            [ 1.0 rgb <0.5,0.5,1> ]
          }    
        } 
      }
    }             
  }
}

#declare Plattform = union {
  torus { 5.3,1.0 }
  torus { 4.8,1.0 translate y*-0.9 }
	object { Duese rotate y*0 }
	object { Duese rotate y*72 }
	object { Duese rotate y*144 }
	object { Duese rotate y*216 }
	object { Duese rotate y*288 }
	pigment { Gray50 }
	finish { ambient 0.1 diffuse 0.5 reflection 0.2 phong 1 phong_size 150 }
}

#declare Alien = union {
  object { Arm translate x*13}
  object { Arm translate x*13 scale <-1,1,1> }
  object { Koerper translate <0,-4,0> scale 2.5 }
  object { Kopf scale 2.5 translate <0,33,-6> }
  object { Plattform translate <0,-10,-0.6> scale 5 }
  pigment { Green*0.3+DarkTan*0.3 }
  normal { bumps 0.7 scale 0.8 }
  finish { ambient 0.4 diffuse 0.55 specular 0.3 roughness 0.07 }
  translate y*5
  scale 0.2
}

object { Alien scale 1.3 rotate y*-140  translate <-40,27,-70> }
object { Alien scale 1.3 rotate y*-180  translate < 10,27,-95> }

plane {
  y,2000
  pigment {
    bozo
    turbulence 1.4
    lambda 2.8
    omega 0.6
    octaves 4
    color_map {
      [0.4 color Clear ]
      [0.6 color Gray90 ]
    }
    scale 7000
  }
  finish { ambient 1 diffuse 0 }
  hollow
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0 color rgb <0.8,0.8,1> ]
      [0.15 color rgb <0.7,0.7,1>*0.6 ]
    }
  }
}

#include "blatt1.inc"

#declare Stack    = 1;      // Stackposition
#declare S  = seed (22412); // Zufallsreihe fr Richtungen
#declare S1 = seed (23769); // Zufallsreihe fr ste
#declare S2 = seed (13288); // Zufallsreihe fr Blattrotation
#declare SegVar = 3;        // variable Segmentlnge
#declare SegRot = 10;       // Segmentrotationswinkel
#declare AstMinRot = 10;    // min. Astrotationswinkel
#declare AstRot = 30;       // var. Astrotationswinkel
#declare AstRand = 0.75;    // Wk. fr neuen Ast
#declare SegRand = 0.9;     // Wk. fr neues Segment
#declare BlattRand = 0.7;   // Wk. fr Blatt am Segment
#declare Pos = <0,0,0>;     // Position des 1. Segments
#declare Dir = <0,1,0>;     // Richtung des 1. Segments
#declare Rad = 4;           // Segmentdicke des 1. Seg.
#declare RadFak = 0.97;     // Dickenfaktor des jeweils nchst. Segments
#declare AstFak = 0.8;      // Dickenfaktor fr wachsenden Ast
#declare MinRad = 0.1;     // min.Segmentdicke (Bailout)   
#declare BlattRad = 0.7;   // max.Segmendicke fr Blatt anfgen
#declare Leaf1 = object { Blatt1 scale 1 }
#declare Leaf2 = object { Blatt1 scale 0.9 }
#declare Leaf3 = object { Blatt1 scale 0.7 }

union {
  #include "povbaum.inc" 
  rotate y*-30
  translate <-90,0,-70>
  pigment { Gray50 }
}                       

plane { y,0 pigment {White}}
    

