//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 12 materials and 72 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 01/26/2000    (26.01.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     10.0
  color <0.6,0.6,0.6,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      1.0
}

camera {  //  Camera StdCam
  location  <    -28.548,     -10.846,       7.961>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <     -0.936,      -0.359,       3.550>
}

//
// *******  L I G H T S *******
// 


light_source {   // Sun
  <-15.944, -10.846, 76.317>
  color rgb <1.000, 1.000, 1.000>
  shadowless
}


//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "modernfount1.inc"
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Stadard Color definitions




//
// ********  REFERENCED OBJECTS  *******
//


#declare NotherCrack3 = prism { // NotherCrack3
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>,
  <0.490646, 0.089966>,
  <1.001701, -0.371088>,
  <1.057228, -1.194609>,
  <1.394558, -2.326531>,
  <1.632653, -0.197279>,
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, -2.230537, -0.0>
  translate  <-0.699542, 12.38088, 5.116107>
}


#declare NotherCrack4 = prism { // NotherCrack4
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>,
  <0.490646, 0.089966>,
  <1.001701, -0.371088>,
  <1.057228, -1.194609>,
  <1.394558, -2.326531>,
  <1.632653, -0.197279>,
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>
  rotate -x*90
  material {
    White_Marble_2MOD
    translate <-0.186173, 0.007251, -0.512363>
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, -2.230537, 90.0>
  translate  <7.844364, 11.334565, 3.355988>
}


#declare NotherCrack5 = prism { // NotherCrack5
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>,
  <0.490646, 0.089966>,
  <1.001701, -0.371088>,
  <1.057228, -1.194609>,
  <1.394558, -2.326531>,
  <1.632653, -0.197279>,
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>
  rotate -x*90
  material {
    White_Marble_2MOD
    translate <-0.186173, 0.007251, -0.512363>
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, -2.230537, -90.0>
  translate  <10.73223, 9.015156, 3.430808>
}

#declare NotherCrack = prism { // NotherCrack
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.612245, 0.07483>,
  <0.613946, -0.595578>,
  <1.394558, -2.326531>,
  <1.258503, -0.809524>,
  <0.586735, 0.312925>,
  <-1.07483, 1.14966>,
  <-0.612245, 0.07483>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, -0.0, 0>
  translate  <-2.200264, 12.38088, 5.548501>
}

#declare NotherCrack1 = prism { // NotherCrack1
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.612245, 0.07483>,
  <0.613946, -0.595578>,
  <1.394558, -2.326531>,
  <1.258503, -0.809524>,
  <0.586735, 0.312925>,
  <-1.07483, 1.14966>,
  <-0.612245, 0.07483>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, -28.464256, 0.0>
  translate  <1.725755, 12.38088, 2.130555>
}


#declare NotherCrack2 = prism { // NotherCrack2
  linear_sweep
  cubic_spline
  -1.0,0.0
  11  // control points
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>,
  <0.490646, 0.089966>,
  <1.001701, -0.371088>,
  <1.057228, -1.194609>,
  <1.394558, -2.326531>,
  <1.632653, -0.197279>,
  <0.430272, 0.92517>,
  <-1.503401, 0.666667>,
  <-0.183673, 0.442177>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale <1.0, 1.0, 3.0>
  rotate <90.0, -2.230537, -0.0>
  translate  <4.195782, 12.38088, 1.740022>
}



#declare Cylndr013MOD = object {
  cylinder { // Cylndr013MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.461005, 1.028875, 1.0>
  }
}


#declare Cylndr007MOD = object {
  cylinder { // Cylndr007MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.461005, 1.028875, 1.0>
  }
}


#declare Cylndr001MOD = object {
  cylinder { // Cylndr001MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.461005, 1.028875, 1.0>
  }
}


#declare Arch5MOD = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>,
  <-0.189671, -1.237872>,
  <-0.001565, -0.945227>,
  <-0.007825, 0.699218>,
  <-0.101408, 1.073959>,
  <-0.353678, 1.273865>,
  <-0.755008, 1.338811>,
  <-1.064163, 1.242567>,
  <-1.532081, 0.733959>,
  <-1.27011, 0.886604>,
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>
  rotate -x*90
  material {
    AzuriteMOD
  }
  scale <0.638287, 0.638287, 0.127657>
  rotate <90.0, -14.850901, -0.0>
  translate  <-0.361713, 0.0, 0.699312>
}
#declare Point7MOD = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.009125, -0.868963>,
  <0.416782, -0.435297>,
  <-0.000132, 2.411867>,
  <-0.472327, -0.4349>,
  <-0.009125, -0.868963>
  rotate -x*90
  material {
    Gold_MetalMOD
  }
  scale <0.776526, 0.776526, 0.2>
  rotate 90.0*x
  translate  <0.0, 0.047723, 0.645592>
}




//
// ********  OBJECTS  *******
//

difference {
box { // MODTopBackWall6
  <-1, -1, -1>, <1, 1, 1>
  material {
    White_Marble_2MOD
  }
  scale <-7.8, -0.86, -1.2>
  rotate <180.0, 0.0, 180.0>
  translate  <-2.303844, 10.734255, 0.870403>
}
NotherCrack1
NotherCrack2
} 

difference {
box { // MODBackWall
  <-1, -1, -1>, <1, 1, 1>
  material {
    White_Marble_2MOD
  }
  scale <-2.4, -0.86, -2.8>
  rotate <180.0, 0.0, 180.0>
  translate  <-2.046678, 10.734255, 2.756287>
}
NotherCrack
NotherCrack3
}

#declare Col_Trunk2MOD = merge {
  object { Cylndr013MOD }
  object { // Cylndr014MOD->Cylndr013MOD
    Cylndr013MOD
    rotate -30.0*z
  }
  object { // Cylndr015MOD->Cylndr013MOD
    Cylndr013MOD
    rotate -60.0*z
  }
  object { // Cylndr016MOD->Cylndr013MOD
    Cylndr013MOD
    rotate -120.0*z
  }
  object { // Cylndr017mod->Cylndr013MOD
    Cylndr013MOD
    rotate -90.0*z
  }
  object { // Cylndr018MOD->Cylndr013MOD
    Cylndr013MOD
    rotate -150.0*z
  }
  material {
    White_Marble_1
  }
  scale <1.0, 1.0, 8.0>
}
#declare Column2MOD = union {
  box { // MOD_FOOT
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
  }
  box { // Foot13MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.3, 1.3, 0.127387>
    translate  -0.148983*z
  }
  box { // Head2MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
    translate  8.0*z
  }
  object { Col_Trunk2MOD }
  translate  <3.583397, -4.971855, 0.0>
}
difference { // BrokenColumnMOD
  object { Column2MOD }
  box { // WallCut4MOD
    <-1, -1, -1>, <1, 1, 1>
    scale <2.200108, 2.673584, 1.657561>
    rotate <35.791039, 0.0, -0.0>
    translate  <3.514602, -4.327806, 8.50115>
  }
  box { // WallCut5mod
    <-1, -1, -1>, <1, 1, 1>
    scale <2.200108, 2.673584, 1.657561>
    rotate <32.649323, -8.010423, 42.776787>
    translate  <3.514602, -4.327806, 8.50115>
  }
  box { // WallCut6MOD
    <-1, -1, -1>, <1, 1, 1>
    scale <2.200108, 2.673584, 1.657561>
    rotate <25.055304, 3.765631, -35.519081>
    translate  <3.514602, -4.327806, 8.50115>
  }
  material {
    White_MarbleMOD
  }
}


box { // Sky
  <-1, -1, -1>, <1, 1, 1>
  material {
    High_Sky
  }
  scale <-0.015138, 150, 150>
  translate  100*x
}




#declare FountMOD = lathe {
  quadratic_spline
  8  // control points
  <1.0, -1.0>,
  <1.026808, -0.992376>,
  <1.107981, -0.36698>,
  <2.088395, 0.393511>,
  <1.890196, 0.594313>,
  <2.039724, 0.494445>,
  <1.179324, -0.079472>,
  <0.051471, -0.27711>
  rotate <90,0,90>
  scale <1.0, 1.0, 2.20405>
  translate  <-0.053208, -2.599091, 1.725641>
}
#declare WholeFountMOD = union {
  torus { // BasinFootMOD
    1.5, 0.5  rotate -x*90
    scale <0.75, 0.75, 0.680908>
    translate  <-0.049661, -2.589463, 0.0>
  }
  object { FountMOD }
  material {
    Black_Vein_GranitMOD
  }
  translate  <-5.974486, -0.013736, 0.0>
}
#declare FountCut1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <2.289007, 0.672344, 1.633214>
  rotate 54.685322*y
  translate  <-6.759048, -3.322244, 2.657382>
}
#declare FountCut2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <1.718848, 1.745951, 1.039512>
  rotate 81.302025*y
  translate  <-7.143624, -3.178028, 2.657382>
}
#declare FountCut3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <-2.476856, -1.104609, -3.352437>
  rotate <158.622772, -65.610321, -42.980274>
  translate  <-6.759048, -3.322244, 2.657382>
}
#declare FountCut4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  scale <-2.476856, -1.104609, -3.352437>
  rotate <115.524025, -84.249481, -39.443928>
  translate  <-4.358832, -3.322244, 4.886154>
}
difference { // BrokenFountMOD
  object { WholeFountMOD }
  object { FountCut1 }
  object { FountCut2 }
  object { FountCut3 }
  object { FountCut4 }
  box { // AnotherCut
    <-1, -1, -1>, <1, 1, 1>
    scale <1.296043, 2.70225, 1.0>
    translate  <-7.571542, -3.108456, 3.128678>
  }

  material {
    Black_Vein_GranitMOD
  }
  rotate <0,0,0>
}


union { // VerticalTorchHolder3
  cylinder { // Foot18MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.1>
    translate  <0.00602, -1.401148, -3.733196>
  }
  cone { // Cone004MOD
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    hollow
    scale <0.5, 0.5, 0.713057>
    translate  <0.0, -1.404511, -0.045307>
  }
  cylinder { // TorchHolderColumn3MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <0.0, -1.39696, -3.639646>
  }
  cylinder { // Foot19MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.1>
    translate  <0.00602, -1.401148, -3.818329>
  }
  cylinder { // Foot20MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.1>
    translate  <0.00602, -1.401148, -3.906122>
  }
  cylinder { // Foot21MOD
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.1>
    translate  <0.00336, -1.401148, -3.988595>
  }
  material {
    Rusty_Iron1MOD
  }
  rotate -80.814865*y
  translate  <-5.897096, -4.848222, 0.330701>
}


lathe { // RotSweep002MOD
  linear_spline
  4  // control points
  <0.024081, -0.486692>,
  <2.038023, -0.480989>,
  <0.751584, 0.506337>,
  <0.030418, 0.505703>
  rotate <90,0,90>
  material {
    Gold_MetalMOD
  }
  scale 0.1
  translate  <-5.982838, 2.403721, 0.488672>
}

difference {
union { // WallWDoorMOD
  box { // TopBackWall1MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_2MOD
    }
    scale <-15.889284, -0.850734, 1.0>
    rotate <-180.0, 0.0, 90.0>
    translate  <-0.338379, 9.813002, 0.865561>
  }
  box { // TopBackWall2MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_2MOD
    }
    scale <2.13648, 0.850734, 1.384694>
    rotate <-180.0, 0.0, -90.0>
    translate  <0.0, 10.00204, 2.404336>
  }
  box { // TopBackWall3MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_2MOD
    }
    scale <2.13648, 0.850734, 1.384694>
    rotate <-180.0, 0.0, -90.0>
    translate  <0.0, 4.327806, 2.115816>
  }
  box { // TopBackWall4MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_2MOD
    }
    scale <2.13648, 0.850734, 1.384694>
    rotate <-180.0, 0.0, -90.0>
    translate  <0.0, -3.558418, 1.731122>
  }
  box { // TopBackWall5MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_2MOD
    }
    scale <2.13648, 0.850734, 1.384694>
    rotate <-0.0, -175.420837, -270.0>
    translate  <3.214604, 1.046637, 0.943493>
  }
  translate  9.2428*x
}
prism { // Crack1
  linear_sweep
  linear_spline
  -1.0,0.0
  15  // control points
  <-0.14966, 0.340136>,
  <0.253061, -0.122449>,
  <0.755782, -0.761905>,
  <1.0, -1.0>,
  <0.423151, -0.176339>,
  <0.393495, 0.065944>,
  <0.060799, 1.805697>,
  <0.028393, 1.497304>,
  <-0.098448, 1.334035>,
  <-0.243197, 1.137755>,
  <-0.394558, 1.068027>,
  <-1.0, 1.0>,
  <-0.639456, 0.882993>,
  <-0.442177, 0.816735>,
  <-0.14966, 0.340136>
  material {
      White_Marble_2MOD
    }
  rotate -x*90
  scale <1.0, 1.0, 3.0>
  rotate <-90.0, -240.961761, -90.0>
  translate  <7.654905, 3.974881, 2.941958>
}
NotherCrack4
NotherCrack5

}

#declare Col_Trunk1MOD = union {
  object { Cylndr007MOD }
  object { // Cylndr008MOD->Cylndr007MOD
    Cylndr007MOD
    rotate -30.0*z
  }
  object { // Cylndr009MOD->Cylndr007MOD
    Cylndr007MOD
    rotate -60.0*z
  }
  object { // Cylndr010mod->Cylndr007MOD
    Cylndr007MOD
    rotate -120.0*z
  }
  object { // Cylndr011MOD->Cylndr007MOD
    Cylndr007MOD
    rotate -90.0*z
  }
  object { // Cylndr012MOD->Cylndr007MOD
    Cylndr007MOD
    rotate -150.0*z
  }
  material {
    White_Marble_1
  }
  scale <1.0, 1.0, 8.0>
}

union { // Column1MOD
  box { // Foot2MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
  }
  box { // Foot3MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.3, 1.3, 0.127387>
    translate  -0.148983*z
  }
  object { Col_Trunk1MOD }
  translate  <-8.200125, 6.641909, 0.0>
}


#declare Col_TrunkMOD = union {
  object { Cylndr001MOD }
  object { // Cylndr002MOD->Cylndr001MOD
    Cylndr001MOD
    rotate -30.0*z
  }
  object { // Cylndr003MOD->Cylndr001MOD
    Cylndr001MOD
    rotate -60.0*z
  }
  object { // Cylndr005MOD->Cylndr001MOD
    Cylndr001MOD
    rotate -120.0*z
  }
  object { // Cylndr004MOD->Cylndr001MOD
    Cylndr001MOD
    rotate -90.0*z
  }
  object { // Cylndr006MOD->Cylndr001MOD
    Cylndr001MOD
    rotate -150.0*z
  }
  material {
    White_Marble_1
  }
  scale <1.0, 1.0, 8.0>
}
union { // ColumnMOD
  box { // FootMOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
  }
  box { // Foot1MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.3, 1.3, 0.127387>
    translate  -0.148983*z
  }
  box { // HeadMOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
    translate  8.0*z
  }
  object { Col_TrunkMOD }
  translate  <3.546805, 6.684363, 0.0>
}


difference { // InnerWallJoinMOD
  box { // Cube001MOD
    <-1, -1, -1>, <1, 1, 1>
    scale <1.032944, 15.153571, 3.931829>
    translate  <3.532551, -7.168521, 12.069632>
  }
  cylinder { // Cut_Inner_WallMOD
    <0,0,1>, <0,0,0>, 1 
    scale <2.329398, 4.639036, 4.0>
    rotate -90.0*y
    translate  <5.590211, 0.855641, 8.0>
  }
  cylinder { // Cut_Inner_Wall1MOD
    <0,0,1>, <0,0,0>, 1 
    scale <2.329398, 4.639036, 4.0>
    rotate -90.0*y
    translate  <5.590211, -10.757508, 8.024044>
  }
  box { // WallCut2MOD
    <-1, -1, -1>, <1, 1, 1>
    scale <2.200108, 1.0, 1.342888>
    rotate -26.543678*x
    translate  <3.514602, 7.982397, 10.520793>
  }
  box { // TopWallCutMOD
    <-1, -1, -1>, <1, 1, 1>
    scale <3.314494, 22.510248, 7.884793>
    translate  <4.050005, -2.594367, 17.321975>
  }
  box { // WallCut3MOD
    <-1, -1, -1>, <1, 1, 1>
    scale <2.200108, 2.673584, 1.657561>
    rotate <9.98134, 0.0, -0.0>
    translate  <3.514602, -4.327806, 8.50115>
  }
  material {
    White_MarbleMOD
  }
}


plane { // FloorMOD
  z,0
  material {
    Floor_matMOD
  }
}


#declare FrameNBack1MOD = difference {
  box { // Frame1MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      AzuriteMOD
    }
    scale <2.0, 0.2, 2.0>
    rotate -45.0*y
  }
  box { // WhiteBack1MOD
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_DiamondMOD
    }
    scale <1.8, 0.2, 1.8>
    rotate -45.0*y
    translate  -0.2*y
  }
}
#declare Arch6MOD = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>,
  <-0.189671, -1.237872>,
  <-0.001565, -0.945227>,
  <-0.007825, 0.699218>,
  <-0.101408, 1.073959>,
  <-0.353678, 1.273865>,
  <-0.755008, 1.338811>,
  <-1.064163, 1.242567>,
  <-1.532081, 0.733959>,
  <-1.27011, 0.886604>,
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>
  rotate -x*90
  material {
    AzuriteMOD
  }
  scale <0.638287, 0.638287, 0.127657>
  rotate <-90.0, 26.338776, 180.0>
  translate  <0.223429, 0.0, -0.903211>
}

#declare MyDiamondSig1MOD = union { // MyDiamondSig1MOD
  cylinder { // Circle4MOD
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_MetalMOD
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <-0.967312, -0.000709, 0.599402>
  }
  object { // Arch4MOD->Arch5MOD
    Arch5MOD
    rotate <0.0, -6.567825, -180.0>
    translate  <-0.098682, -0.12714, 0.071613>
  }
  object { Arch5MOD }
  object { // Point4MOD->Point7MOD
    Point7MOD
    rotate <-0.0, 90.0, 0.0>
    translate  <0.005075, 0.0, -0.014112>
  }
  object { // Point5MOD->Point7MOD
    Point7MOD
    rotate <-180.0, 0.0, -180.0>
    translate  <-0.009037, 0.0, -0.064373>
  }
  object { // Point6MOD->Point7MOD
    Point7MOD
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.018485, 0.0, -0.000411>
  }
  object { Point7MOD }
  object { FrameNBack1MOD }
  object { Arch6MOD }
  object { // Arch7MOD->Arch5MOD
    Arch5MOD
    rotate <180.0, 10.072739, 0.0>
    translate  <0.195591, -0.12714, -0.232807>
  }
  cylinder { // Circle5MOD
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_MetalMOD
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <0.84906, -0.000709, 0.579107>
  }
  cylinder { // Circle6MOD
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_MetalMOD
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <0.808471, -0.000709, -0.638572>
  }
  cylinder { // Circle7MOD
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_MetalMOD
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <-0.97746, -0.000709, -0.60813>
  }
  scale <0.5, 1.0, 0.5>
  rotate <168.362488, -202.023117, 175.583862>
  translate  <-7.68995, 5.15055, 0.41612>
}
difference { // BrokenStar
  object { MyDiamondSig1MOD }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Marble_1
    }
    rotate <-101.020805, -0.0, 0.0>
    translate  <-6.68082, 4.963632, 1.223038>
  }
  translate  <0.0, -0.209227, 0.141536>
}

prism { // Rubblepeice1
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  translate  <-9.570074, 0.804723, -0.857635>
}
prism { // Rubblepeice2
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale 0.4
  rotate <105.056747, -238.982666, 157.094437>
  translate  <-3.491632, 5.65851, -0.288396>
}


prism { // Rubblepeice3
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale 0.4
  rotate <0.0, -32.181229, -0.0>
  translate  <-5.236543, -9.276985, -0.475715>
}


prism { // Rubblepeice4
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale 0.4
  rotate <0.0, -32.181229, 85.113213>
  translate  <-9.986579, -5.011647, -0.475715>
}


prism { // Rubblepeice5
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_2MOD
  }
  scale 0.4
  rotate <0.0, -32.181229, -0.0>
  translate  <-3.006935, 2.937392, -0.475715>
}


prism { // Rubblepeice6
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_1
  }
  scale 0.4
  rotate <-163.846786, -148.849854, 171.478958>
  translate  <-10.388586, 3.772802, -0.324683>
}


prism { // Rubblepeice7
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_1
  }
  scale 0.4
  rotate <0.0, -32.181229, -0.0>
  translate  <-1.165084, -11.603533, -0.475715>
}


prism { // Rubblepeice8
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_1
  }
  scale 0.4
  rotate <82.102943, -241.14064, -130.191544>
  translate  <-9.504731, -7.334722, -0.075558>
}


prism { // Rubblepeice9
  linear_sweep
  linear_spline
  -1.0,0.0
  23  // control points
  <-1.0, -1.0>,
  <-0.565986, -0.891156>,
  <-0.215238, -1.081633>,
  <0.157932, -0.931973>,
  <0.644005, -1.068027>,
  <0.92517, -1.0>,
  <1.0, -0.8>,
  <1.619048, -0.559184>,
  <0.605442, -0.529796>,
  <1.272109, 0.049932>,
  <0.789116, 0.556041>,
  <1.108844, 0.801919>,
  <0.85034, 0.918367>,
  <0.678027, 1.197279>,
  <0.213197, 0.802721>,
  <-0.2, 1.217687>,
  <-0.618776, 0.829932>,
  <-1.0, 1.0>,
  <-1.047619, 0.431973>,
  <-0.891156, -0.092857>,
  <-1.129252, -0.439949>,
  <-0.823129, -0.706926>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    White_Marble_1
  }
  scale 0.4
  rotate <-131.771484, -198.276062, -280.409332>
  translate  <-0.683236, -4.28992, -0.317941>
}




//
// ********  MATERIALS  *******
//

#include "classicfount1.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cylndr007 = object {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.461005, 1.028875, 1.0>
  }
}


#declare Cylndr001 = object {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.461005, 1.028875, 1.0>
  }
}


#declare Cylndr013 = object {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.461005, 1.028875, 1.0>
  }
}


#declare Arch = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>,
  <-0.189671, -1.237872>,
  <-0.001565, -0.945227>,
  <-0.007825, 0.699218>,
  <-0.101408, 1.073959>,
  <-0.353678, 1.273865>,
  <-0.755008, 1.338811>,
  <-1.064163, 1.242567>,
  <-1.532081, 0.733959>,
  <-1.27011, 0.886604>,
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>
  rotate -x*90
  material {
    Azurite
  }
  scale <0.638287, 0.638287, 0.127657>
  rotate <90.0, -14.850901, -0.0>
  translate  <-0.361713, 0.0, 0.699312>
}
#declare Point = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.009125, -0.868963>,
  <0.416782, -0.435297>,
  <-0.000132, 2.411867>,
  <-0.472327, -0.4349>,
  <-0.009125, -0.868963>
  rotate -x*90
  material {
    Gold_Metal
  }
  scale <0.776526, 0.776526, 0.2>
  rotate 90.0*x
  translate  <0.0, 0.047723, 0.645592>
}


#declare Arch5 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>,
  <-0.189671, -1.237872>,
  <-0.001565, -0.945227>,
  <-0.007825, 0.699218>,
  <-0.101408, 1.073959>,
  <-0.353678, 1.273865>,
  <-0.755008, 1.338811>,
  <-1.064163, 1.242567>,
  <-1.532081, 0.733959>,
  <-1.27011, 0.886604>,
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>
  rotate -x*90
  material {
    Azurite
  }
  scale <0.638287, 0.638287, 0.127657>
  rotate <90.0, -14.850901, -0.0>
  translate  <-0.361713, 0.0, 0.699312>
}
#declare Point7 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.009125, -0.868963>,
  <0.416782, -0.435297>,
  <-0.000132, 2.411867>,
  <-0.472327, -0.4349>,
  <-0.009125, -0.868963>
  rotate -x*90
  material {
    Gold_Metal
  }
  scale <0.776526, 0.776526, 0.2>
  rotate 90.0*x
  translate  <0.0, 0.047723, 0.645592>
}




//
// ********  OBJECTS  *******
//





box { // Carpet
  <-1, -1, -1>, <1, 1, 1>
  material {
    RugColor
  }
  scale <-51.761665, -1.66884, 0.020905>
  translate  <-42.66896, -10.081403, 0.041262>
}


#declare TransSweep001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  24  // control points
  <-1.0, 1.0>,
  <-1.106686, -0.790597>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.106853, -0.790895>,
  <1.0, 1.0>,
  <1.159196, 1.17205>,
  <1.474747, 1.197557>,
  <1.774225, 1.275765>,
  <1.927607, 1.698849>,
  <1.60247, 2.20684>,
  <0.81632, 2.31273>,
  <0.25, 2.525822>,
  <0.0, 3.034429>,
  <-0.25, 2.525822>,
  <-0.795274, 2.323253>,
  <-1.321798, 2.253535>,
  <-1.826549, 1.985727>,
  <-1.892061, 1.471818>,
  <-1.655043, 1.224769>,
  <-1.176579, 1.140866>,
  <-1.0, 1.0>,
  <-1.106686, -0.790597>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Azurite
  }
  scale <2.090732, 2.090732, 2.0>
  rotate <90.0, 0.0, -90.0>
  translate  <10.28603, -11.532045, 1.289047>
}
#declare TransSweep002 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  24  // control points
  <-1.0, 1.0>,
  <-1.055137, -1.300847>,
  <-1.010523, -1.368297>,
  <0.989477, -1.368297>,
  <1.07086, -1.218258>,
  <1.0, 1.0>,
  <1.064491, 1.340414>,
  <1.474747, 1.197557>,
  <1.774225, 1.275765>,
  <1.927607, 1.698849>,
  <1.60247, 2.20684>,
  <0.81632, 2.31273>,
  <0.25, 2.525822>,
  <0.0, 3.034429>,
  <-0.25, 2.525822>,
  <-0.795274, 2.323253>,
  <-1.321798, 2.253535>,
  <-1.826549, 1.985727>,
  <-1.892061, 1.471818>,
  <-1.655043, 1.224769>,
  <-1.176579, 1.288185>,
  <-1.0, 1.0>,
  <-1.055137, -1.300847>,
  <-1.010523, -1.368297>
  rotate -x*90
  material {
    Azurite
  }
  scale <1.815912, 1.785545, 2.5>
  rotate <90.0, 0.0, -90.0>
  translate  <10.517577, -11.532045, 1.774916>
}
difference { // ArchwayDoor
  object { TransSweep001 }
  object { TransSweep002 }
  scale <1.0, 0.872902, 1.0>
}


#declare TransSweep003 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  24  // control points
  <-1.031568, 0.88425>,
  <-1.091791, -1.225478>,
  <-1.010523, -1.368297>,
  <0.989477, -1.368297>,
  <1.102981, -1.148301>,
  <1.042091, 0.757976>,
  <1.085536, 1.182573>,
  <1.474747, 1.197557>,
  <1.774225, 1.275765>,
  <1.927607, 1.698849>,
  <1.60247, 2.20684>,
  <0.805797, 2.354822>,
  <0.239477, 2.567913>,
  <-0.010523, 3.07652>,
  <-0.260523, 2.567913>,
  <-0.805797, 2.365344>,
  <-1.332321, 2.295626>,
  <-1.826549, 1.985727>,
  <-1.892061, 1.471818>,
  <-1.655043, 1.224769>,
  <-1.271284, 1.182957>,
  <-1.031568, 0.88425>,
  <-1.091791, -1.225478>,
  <-1.010523, -1.368297>
  rotate -x*90
  material {
    Azurite
  }
  scale <1.752363, 1.785545, 2.5>
  rotate <90.0, 0.0, -90.0>
  translate  <10.517577, -10.07042, 1.743142>
}
difference { // WallWDoor
  box { // TopBackWall1
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_2
    }
    scale <-15.889284, -0.850734, -6.016694>
    rotate <-180.0, 0.0, 90.0>
    translate  <9.242796, 1.66566, 5.842279>
  }
  object { TransSweep003 }
}


#declare Col_Trunk1 = union {
  object { Cylndr007 }
  object { // Cylndr008->Cylndr007
    Cylndr007
    rotate -30.0*z
  }
  object { // Cylndr009->Cylndr007
    Cylndr007
    rotate -60.0*z
  }
  object { // Cylndr010->Cylndr007
    Cylndr007
    rotate -120.0*z
  }
  object { // Cylndr011->Cylndr007
    Cylndr007
    rotate -90.0*z
  }
  object { // Cylndr012->Cylndr007
    Cylndr007
    rotate -150.0*z
  }
  material {
    White_Marble_1
  }
  scale <1.0, 1.0, 8.0>
}
union { // Column1
  box { // Foot2
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
  }
  box { // Foot3
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.3, 1.3, 0.127387>
    translate  -0.148983*z
  }
  box { // Head1
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
    translate  8.0*z
  }
  object { Col_Trunk1 }
  translate  <-8.200125, 6.641909, 0.0>
  scale <.99,.99,.99>
}


#declare Col_Trunk = union {
  object { Cylndr001 }
  object { // Cylndr002->Cylndr001
    Cylndr001
    rotate -30.0*z
  }
  object { // Cylndr003->Cylndr001
    Cylndr001
    rotate -60.0*z
  }
  object { // Cylndr005->Cylndr001
    Cylndr001
    rotate -120.0*z
  }
  object { // Cylndr004->Cylndr001
    Cylndr001
    rotate -90.0*z
  }
  object { // Cylndr006->Cylndr001
    Cylndr001
    rotate -150.0*z
  }
  material {
    White_Marble_1
  }
  scale <1.0, 1.0, 8.0>
}
union { // Column
  box { // Foot
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
  }
  box { // Foot1
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.3, 1.3, 0.127387>
    translate  -0.148983*z
  }
  box { // Head
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Marble_1
    }
    scale <1.2, 1.2, 0.127387>
    translate  8.0*z
  }
  object { Col_Trunk }
  translate  <3.546805, 6.684363, 0.0>
  scale <.99,.99,.99>
}


difference { // InnerWallJoin
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.032944, 15.153571, 3.931829>
    translate  <3.532551, -9.5, 12.069632>
  }
  cylinder { // Cut_Inner_Wall
    <0,0,1>, <0,0,0>, 1 
    scale <2.329398, 4.639036, 4.0>
    rotate -90.0*y
    translate  <5.590211, 0.855641, 8.0>
  }
  cylinder { // Cut_Inner_Wall1
    <0,0,1>, <0,0,0>, 1 
    scale <2.329398, 4.639036, 4.0>
    rotate -90.0*y
    translate  <5.590211, -10.757508, 8.024044>
  }
  material {
    White_Marble
  }
  scale<.99,.99,.99>
}


box { // TopBackWall
  <-1, -1, -1>, <1, 1, 1>
  material {
    White_Marble_2
  }
  scale <13.283779, -0.850734, 6.080243>
  translate  <-5, 10.734255, 5.842279>
}


plane { // Floor
  z,0
  material {
    Floor_mat
  }
  translate  0.05*z
}


difference { // InnerWallJoin1
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.032944, 15.153571, 3.931829>
    translate  <3.532551, -9.4, 12.069632>
  }
  cylinder { // Cut_Inner_Wall2
    <0,0,1>, <0,0,0>, 1 
    scale <2.329398, 4.639036, 4.0>
    rotate -90.0*y
    translate  <5.590211, 0.855641, 8.0>
  }
  cylinder { // Cut_Inner_Wall3
    <0,0,1>, <0,0,0>, 1 
    scale <2.329398, 4.639036, 4.0>
    rotate -90.0*y
    translate  <5.590211, -10.757508, 8.024044>
  }
  material {
    White_Marble
  }
  rotate -90.0*z
  translate  <-3.25326, 10.262155, 0.0>
}


#declare Fount = lathe {
  quadratic_spline
  8  // control points
  <1.0, -1.0>,
  <1.026808, -0.992376>,
  <1.107981, -0.36698>,
  <2.088395, 0.393511>,
  <1.890196, 0.594313>,
  <2.039724, 0.494445>,
  <1.179324, -0.079472>,
  <0.051471, -0.27711>
  rotate <90,0,90>
  scale <.99, .99, 2.20405>
  translate  <-0.053208, -2.599091, 1.725641>
}
union { // WholeFount
  torus { // BasinFoot
    1.5, 0.5  rotate -x*90
    scale <0.75, 0.75, 0.680908>
    translate  <-0.049661, -2.589463, 0.0>
  }
  object { Fount }
  material {
    Black_Vein_Granit
  }
  translate  <-5.974486, -0.013736, 0.0>
}


#declare Col_Trunk2 = union {
  object { Cylndr013 }
  object { // Cylndr014->Cylndr013
    Cylndr013
    rotate -30.0*z
  }
  object { // Cylndr015->Cylndr013
    Cylndr013
    rotate -60.0*z
  }
  object { // Cylndr016->Cylndr013
    Cylndr013
    rotate -120.0*z
  }
  object { // Cylndr017->Cylndr013
    Cylndr013
    rotate -90.0*z
  }
  object { // Cylndr018->Cylndr013
    Cylndr013
    rotate -150.0*z
  }
  material {
    White_Marble_1
  }
  scale <1.0, 1.0, 8.0>
}
difference { //Whole Column2
  union { // Column2
      box { // Foot12
      <-1, -1, -1>, <1, 1, 1>
      material {
        White_Marble_1
      }
      scale <1.2, 1.2, 0.127387>
    }
    box { // Foot13
      <-1, -1, -1>, <1, 1, 1>
      material {
        White_Marble_1
      }
      scale <1.3, 1.3, 0.127387>
      translate  -0.148983*z
    }
    box { // Head2
      <-1, -1, -1>, <1, 1, 1>
      material {
        White_Marble_1
      }
      scale <1.2, 1.2, 0.127387>
      translate  8.0*z
    }
    object { Col_Trunk2 }
    translate  <3.583397, -4.971855, 0.0>
  }
  cylinder { // ColumnrCut
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Marble_1
    }
    scale <1.0, 1.0, 8.0>
    translate  <3.884584, -4.704576, 0.0>
  }
  scale <.99,.99,.99>
}
#declare FrameNBack = difference {
  box { // Frame
    <-1, -1, -1>, <1, 1, 1>
    material {
      Azurite
    }
    scale <2.0, 0.2, 2.0>
    rotate -45.0*y
  }
  box { // WhiteBack
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Diamond
    }
    scale <1.8, 0.2, 1.8>
    rotate -45.0*y
    translate  -0.2*y
  }
}
#declare Arch2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>,
  <-0.189671, -1.237872>,
  <-0.001565, -0.945227>,
  <-0.007825, 0.699218>,
  <-0.101408, 1.073959>,
  <-0.353678, 1.273865>,
  <-0.755008, 1.338811>,
  <-1.064163, 1.242567>,
  <-1.532081, 0.733959>,
  <-1.27011, 0.886604>,
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>
  rotate -x*90
  material {
    Azurite
  }
  scale <0.638287, 0.638287, 0.127657>
  rotate <-90.0, 26.338776, 180.0>
  translate  <0.223429, 0.0, -0.903211>
}

#declare FrameNBack1 = difference {
  box { // Frame1
    <-1, -1, -1>, <1, 1, 1>
    material {
      Azurite
    }
    scale <2.0, 0.2, 2.0>
    rotate -45.0*y
  }
  box { // WhiteBack1
    <-1, -1, -1>, <1, 1, 1>
    material {
      White_Diamond
    }
    scale <1.8, 0.2, 1.8>
    rotate -45.0*y
    translate  -0.2*y
  }
}
#declare Arch6 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  15  // control points
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>,
  <-0.189671, -1.237872>,
  <-0.001565, -0.945227>,
  <-0.007825, 0.699218>,
  <-0.101408, 1.073959>,
  <-0.353678, 1.273865>,
  <-0.755008, 1.338811>,
  <-1.064163, 1.242567>,
  <-1.532081, 0.733959>,
  <-1.27011, 0.886604>,
  <-0.8482, 0.93928>,
  <-0.540689, 0.775587>,
  <-0.413146, 0.416275>
  rotate -x*90
  material {
    Azurite
  }
  scale <0.638287, 0.638287, 0.127657>
  rotate <-90.0, 26.338776, 180.0>
  translate  <0.223429, 0.0, -0.903211>
}
union { // MyDiamondSig1
  cylinder { // Circle4
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <-0.967312, -0.000709, 0.599402>
  }
  object { // Arch4->Arch5
    Arch5
    rotate <0.0, -6.567825, -180.0>
    translate  <-0.098682, -0.12714, 0.071613>
  }
  object { Arch5 }
  object { // Point4->Point7
    Point7
    rotate <-0.0, 90.0, 0.0>
    translate  <0.005075, 0.0, -0.014112>
  }
  object { // Point5->Point7
    Point7
    rotate <-180.0, 0.0, -180.0>
    translate  <-0.009037, 0.0, -0.064373>
  }
  object { // Point6->Point7
    Point7
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.018485, 0.0, -0.000411>
  }
  object { Point7 }
  object { FrameNBack1 }
  object { Arch6 }
  object { // Arch7->Arch5
    Arch5
    rotate <180.0, 10.072739, 0.0>
    translate  <0.195591, -0.12714, -0.232807>
  }
  cylinder { // Circle5
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <0.84906, -0.000709, 0.579107>
  }
  cylinder { // Circle6
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <0.808471, -0.000709, -0.638572>
  }
  cylinder { // Circle7
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <-0.97746, -0.000709, -0.60813>
  }
  scale <0.5, 1.0, 0.5>
  translate  <-8.11856, 5.612869, 9.677579>
}


box { // Carpet1
  <-1, -1, -1>, <1, 1, 1>
  material {
    RugColor
  }
  scale <-51.761665, -1.66884, 0.020905>
  rotate -90.0*z
  translate  <-9.901653, -51.668347, 0.041262>
}


#declare LecturnMain = difference {
  box { // trunk
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cherry_Wood
    }
    scale <1.0, 1.0, 6.0>
  }
  box { // CutTop
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cherry_Wood
    }
    scale <2.076977, 2.211831, 1.507408>
    rotate 29.154303*x
    translate  <-0.036243, -0.435202, 5.463714>
  }
}
union { // LecturnGroup
   box { // BookHolder
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cherry_Wood_1
    }
    scale <2.0, 2.0, 0.1>
    rotate 28.54636*x
    translate  <0.0, -0.0544, 4.134415>
  }
  object { LecturnMain }
  scale 0.5
  rotate 90.0*z
  translate  <-2.737428, -2.749738, 2.963174>
}



#declare RotSweep001 = lathe {
  linear_spline
  4  // control points
  <0.024081, -0.486692>,
  <2.038023, -0.480989>,
  <0.751584, 0.506337>,
  <0.030418, 0.505703>
  rotate <90,0,90>
  material {
    Gold_Metal
  }
  scale 0.1
  translate  <-0.000019, -1.403669, 1.761465>
}
#declare VerticalTorchHolder2 = union {
  cylinder { // Foot14
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.1>
    translate  <0.00602, -1.401148, -3.733196>
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    hollow
    scale <0.5, 0.5, 0.713057>
    translate  <0.0, -1.404511, -0.045307>
  }
  cylinder { // TorchHolderColumn2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <0.0, -1.39696, -3.639646>
  }
  cylinder { // Foot15
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.1>
    translate  <0.00602, -1.401148, -3.818329>
  }
  cylinder { // Foot16
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.1>
    translate  <0.00602, -1.401148, -3.906122>
  }
  cylinder { // Foot17
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.1>
    translate  <0.00336, -1.401148, -3.988595>
  }
  material {
    Rusty_Iron1
  }
}
#declare VertTorch2 = union {
  object { VerticalTorchHolder2 }
}
union { // Candle
  object { RotSweep001 }
  cylinder { // CandleStick
    <0,0,1>, <0,0,0>, 1 
    material {
      WhiteWax
    }
    scale <0.1, 0.1, 1.735566>
    translate  <0.000644, -1.396328, 0.0>
  }
  object { VertTorch2 }
  translate  <-6.199903, 2.532653, 4.016747>
}
//

#declare RotSweep002 = lathe {
  linear_spline
  4  // control points
  <0.024081, -0.486692>,
  <2.038023, -0.480989>,
  <0.751584, 0.506337>,
  <0.030418, 0.505703>
  rotate <90,0,90>
  material {
    Gold_Metal
  }
  scale 0.1
  translate  <-0.000019, -1.403669, 1.761465>
}
#declare VerticalTorchHolder3 = union {
  cylinder { // Foot18
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.1>
    translate  <0.00602, -1.401148, -3.733196>
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    open
    hollow
    scale <0.5, 0.5, 0.713057>
    translate  <0.0, -1.404511, -0.045307>
  }
  cylinder { // TorchHolderColumn3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.0>
    translate  <0.0, -1.39696, -3.639646>
  }
  cylinder { // Foot19
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 0.1>
    translate  <0.00602, -1.401148, -3.818329>
  }
  cylinder { // Foot20
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 0.1>
    translate  <0.00602, -1.401148, -3.906122>
  }
  cylinder { // Foot21
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 0.1>
    translate  <0.00336, -1.401148, -3.988595>
  }
  material {
    Rusty_Iron1
  }
}
#declare VertTorch3 = union {
  object { VerticalTorchHolder3 }
}
union { // Candle1
  object { RotSweep002 }
  cylinder { // CandleStick1
    <0,0,1>, <0,0,0>, 1 
    material {
      WhiteWax
    }
    scale <0.1, 0.1, 1.735566>
    translate  <0.000644, -1.396328, 0.0>
  }
  object { VertTorch3 }
  translate  <-5.982818, -4.848222, 4.016747>
}


sphere { // Hill
  <0,0,0>,1
  scale <38.433075, -42.607601, 5.877057>
  translate  <71.007067, 43.607601, -0.845421>
  material {
    Floor_matMOD
  }
}
sphere { // Hill1
  <0,0,0>,1
  scale <40.730694, -57.658012, 7.441396>
  translate  <71.007067, -25.469926, -1.43354>
  material {
    Floor_matMOD
  }
}
 
superellipsoid { // GroundTile
  <0.1, 0.117>
  material {
    White_Marble_2MOD
  }
  scale <1.0, 1.5, 1.0>
  rotate -1.179958*y
  translate  <-4.196239, 3.557343, -0.94847>
} 
 
superellipsoid { // GroundTile1
  <0.1, 0.117>
  material {
    White_Marble_2MOD
  }
  scale <1.0, 1.5, 1.0>
  rotate -1.179958*y
  translate  <-0.618972, -6.332748, -0.94847>
}

//Left Tree
object {
	#declare LeafShape=6
	#declare LeafTexture=2
	#declare BarkTexture=3
	#include "trees.inc"
    rotate <90,0,0>
    scale <.5,.5,.5>
    rotate <0,0,-90>
    translate <50,40,1>
}

//Right Tree
object {
	#declare LeafShape=6
	#declare LeafTexture=2
	#declare BarkTexture=3
	#include "trees.inc"
    rotate <90,0,0>
    scale <.4,.4,.4>
    rotate <0,0,0>
    translate <64,-6.5,4>
}

//Front Tree
object {
	#declare LeafShape=6
	#declare LeafTexture=2
	#declare BarkTexture=2
	#include "trees.inc"
    rotate <90,0,0>
    scale <.7,.7,.7>
    rotate <0,0,-90>
	translate <22,6,0>
}
superellipsoid { // RandomRock
  <0.1, 1.0>
  material {
    White_Marble_2MOD
  }
  translate  <-13.795075, -0.103811, -0.18404>
}
superellipsoid { // RandomRock1
  <0.1, 1.0>
  material {
    White_Marble_1
  }
  translate  <-1.545374, 7.993449, -0.18404>
}

#declare TransSweep001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  24  // control points
  <-1.0, 1.0>,
  <-1.106686, -0.790597>,
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.106853, -0.790895>,
  <1.0, 1.0>,
  <1.159196, 1.17205>,
  <1.474747, 1.197557>,
  <1.774225, 1.275765>,
  <1.927607, 1.698849>,
  <1.60247, 2.20684>,
  <0.81632, 2.31273>,
  <0.25, 2.525822>,
  <0.0, 3.034429>,
  <-0.25, 2.525822>,
  <-0.795274, 2.323253>,
  <-1.321798, 2.253535>,
  <-1.826549, 1.985727>,
  <-1.892061, 1.471818>,
  <-1.655043, 1.224769>,
  <-1.176579, 1.140866>,
  <-1.0, 1.0>,
  <-1.106686, -0.790597>,
  <-1.0, -1.0>
  rotate -x*90
  scale <2.090732, 2.090732, 2.0>
  rotate <90.0, 0.0, -90.0>
  translate  <10.28603, -11.532045, 1.289047>
}
#declare TransSweep002 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  24  // control points
  <-1.0, 1.0>,
  <-1.055137, -1.300847>,
  <-1.010523, -1.368297>,
  <0.989477, -1.368297>,
  <1.07086, -1.218258>,
  <1.0, 1.0>,
  <1.064491, 1.340414>,
  <1.474747, 1.197557>,
  <1.774225, 1.275765>,
  <1.927607, 1.698849>,
  <1.60247, 2.20684>,
  <0.81632, 2.31273>,
  <0.25, 2.525822>,
  <0.0, 3.034429>,
  <-0.25, 2.525822>,
  <-0.795274, 2.323253>,
  <-1.321798, 2.253535>,
  <-1.826549, 1.985727>,
  <-1.892061, 1.471818>,
  <-1.655043, 1.224769>,
  <-1.176579, 1.288185>,
  <-1.0, 1.0>,
  <-1.055137, -1.300847>,
  <-1.010523, -1.368297>
  rotate -x*90
  scale <1.815912, 1.785545, 2.5>
  rotate <90.0, 0.0, -90.0>
  translate  <10.517577, -11.532045, 1.774916>
}
difference { // ArchwayDoor
  object { TransSweep001 }
  object { TransSweep002 }
  box { // BreaktheDoor1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.830187, 3.313561, 2.745795>
    translate  <9.081991, -11.714727, 0.387339>
  }
  box { // BreaktheDoor2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.830187, 2.560876, 5.055562>
    rotate <-47.072075, -0.0, 0.0>
    translate  <9.081991, -12.4976, 5.538913>
  }
  material {
    AzuriteMOD
  }
  scale <1.0, 0.872902, 1.0>
  rotate <-0.0, -94.0, 0.0>
  translate  <7.269576, 0.0, -9.754114>
}

union { // MyDiamondSig
  cylinder { // Circle
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <-0.967312, -0.000709, 0.599402>
  }
  object { // Arch1->Arch
    Arch
    rotate <0.0, -6.567825, -180.0>
    translate  <-0.098682, -0.12714, 0.071613>
  }
  object { Arch }
  object { // Point3->Point
    Point
    rotate <-0.0, 90.0, 0.0>
    translate  <0.005075, 0.0, -0.014112>
  }
  object { // Point2->Point
    Point
    rotate <-180.0, 0.0, -180.0>
    translate  <-0.009037, 0.0, -0.064373>
  }
  object { // Point1->Point
    Point
    rotate <-0.0, -90.0, 0.0>
    translate  <-0.018485, 0.0, -0.000411>
  }
  object { Point }
  object { FrameNBack }
  object { Arch2 }
  object { // Arch3->Arch
    Arch
    rotate <180.0, 10.072739, 0.0>
    translate  <0.195591, -0.12714, -0.232807>
  }
  cylinder { // Circle1
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <0.84906, -0.000709, 0.579107>
  }
  cylinder { // Circle2
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <0.808471, -0.000709, -0.638572>
  }
  cylinder { // Circle3
    <0,0,1>, <0,0,0>, 1 
    material {
      Gold_Metal
    }
    scale <0.1, 0.1, 0.07>
    rotate 90.0*x
    translate  <-0.97746, -0.000709, -0.60813>
  }
  scale <0.5, 1.0, 0.5>
  rotate -90.0*z
  translate  <2.167422, -5.019578, 9.762067>
}