#include "colors.inc"
#include "stones.inc"
#include "schild.pov"

#declare Details=4


/*

background {color White}

camera {

	location <-35,30,3> look_at <30,3,0>  //von oben
// 	location <-5,2,3> look_at <10,10,0>  // von unten
//	location <-.1,60,.1> look_at <.1,1,0>  // genau von oben
      
	//blur_samples 20
    //focal_point <9,0,0>
    //aperture .4

//	location <-2,1,2> look_at <0,1,0>  // mitte anschauen
//	location <-10,10,3> look_at <30,3,0>  // untere Eingaenge	
//	location <5,8,3> look_at <30,5,2>  // untere Eingaenge

//	location <0,23,3> look_at <30,13+5+4,0> // obere Eingaenge

//	location <-25,10,-15> look_at <0,8,-18>  // Seite
//	location <-15,4,-13> look_at <0,2,-14>  // Seite

}

light_source {
    <-10,50,10>
    color White
}

light_source {
    <-2,20,3>
    color White
}


#declare Pfeil =
union {
    cone {
        <.7,0,0>,.2,<1,0,0>,0
    }                    
	cylinder {
        <0,0,0>,<.7,0,0>,.06
    }
    texture {
        finish {
            ambient 1 diffuse 0
        }
    }
}

//union {Pfeil texture{pigment{Red}}}
//union {Pfeil rotate -90*y texture{pigment{Green}}}
//union {Pfeil rotate 90*z texture{pigment{Blue}}}



*/

#declare Purpur = pigment {rgb<211,31,91>/255}
#declare Sand = pigment {
	marble  turbulence 1
	color_map {
		[0 rgb<252,232,184>/255]
		[.8 rgb<252,232,184>/255*.7]
		[1 rgb White]
	}
}
#declare SandDunkel = pigment {
	marble  turbulence 1
	color_map {
		[0 rgb<252,232,184>/255*.8]
		[.8 rgb<252,232,184>/255*.7*.8]
		[1 rgb White*.8]
	}
}



#declare KleineSaeule =
union {
	cone { <0,.4,0> .1 <0,2,0> .08 }
	box {<-.14,0,-.14> <.14,.4,.14>}
	sphere {0,1 scale <.13,.08,.13> translate .4*y}	
	sphere {0,1 scale <.17,.06,.17> translate 2*y}
	sphere {0,1 scale <.10,.04,.10> translate 1.92*y}

}	

#declare Dach =
difference {
	box {<-.2,2,2> <1.2,2.5,-.2>}
	box {<-.3,0,1.4> <1.3,2,-.3> rotate 20*z translate 2.2*y}
	box {<-1.3,0,1.41> <.3,2,-.3> rotate -20*z translate <1,2.2,0>}
	difference {
		box {<-.0,2.05,-.1> <1.0,2.5,-.3>}
		box {<-.3,0,.4> <1.3,2,-.4> rotate 20*z translate 2.15*y}
		box {<-1.3,0,1.41> <.3,2,-.4> rotate -20*z translate <1,2.15,0>}
	pigment {rgb<249,142,79>/255}	
	}
}

#declare Faehnchen =
union {
	cone {<.0,2.4,0> .02 <.0,4,0> .005 pigment {Gold}} 
	cylinder {<.0,2.2,0> <.0,2.55,0> .03 pigment {Gold}} 
	object {fahne scale 2 translate <0,2.9,0> pigment {Purpur}}

}

#declare Haeuschen =
union {
	object {KleineSaeule translate <1,5,9.5>}
	object {KleineSaeule translate <0,5,9.5>}
	object {KleineSaeule translate <1,5,11.4>}
	object {KleineSaeule translate <0,5,11.4>}
	object {Dach translate <0,5,9.5>}
//	object {Faehnchen translate <0,5,9.5>}

}
#declare Bogen =
union {
	difference {
		union{
			cylinder {<0,0,-.2> <0,0,.2> 1.4}
			box {<-1.5,.1,.3><1.5,2,.5>}	
		}
		cylinder {<0,0,-.3> <0,0,.6> 1}
		box {<-2,-2,-.3> <2,0,.3> }
		#declare ct1=0
		#while (ct1<=180)
		box {<0,-.1,-.3> <1.6,.1,.0> pigment {Red} rotate ct1*z translate .2*y}
		#declare ct1=ct1+30
		#end

		scale <1,.8,1>
		translate 2.5*y 
	}
	difference {
		box {<-1.4,2,-.2><1.4,2.5,.2>}	
		box {<-1,1.9,-.3><1,2.6,.3>} 
	} 
	difference {
		box {<-1.5,2,-.2><1.5,2.5,.5>}	
		#declare ct2=-1
		#while (ct2<=1)
		box {<-.12,2.1,-.3> <.12,2.4,.4> translate ct2*x}
		#declare ct2=ct2+.5
		#end
		scale <1,.8,1>
		translate 2.5*y 
	}
	box {<-.6,.4,-.2> <.6,2.4,-.18> pigment {Purpur}}
	cylinder {<-1,2.4,-.19> <1,2.4,.19> .06 pigment {Gold}}

	rotate 90*y	
}

#declare Randsaeule =
union {
	box {<-.3,0,-.4><.3,.5,.2>}	
	cone {<0,0,0> .25 <0,4.5,0> .2 scale <1,1,.5> translate <0,0,-.2>}
	sphere {0,1 scale <.35,.15,.35> scale <1,1,.5> translate <0,4.5,-.2>}
	box {<.4,4.5,-.45><-.4,1+4.5,.2>}	


}

#declare Randelement =
union {
	difference {
		union{
			cylinder {<0,0,-.2> <0,0,.2> 1.4}
			box {<-1.5,.1,.1><1.5,2,.5>}	
		}
		cylinder {<0,0,-.3> <0,0,.6> 1}
		box {<-2,-2,-.3> <2,0,.3> }
		#declare ct1=0
		#while (ct1<=180)
		box {<0,-.1,-.3> <1.6,.1,.0> pigment {Red} rotate ct1*z translate .2*y}
		#declare ct1=ct1+30
		#end

		scale <1,.8,1>
		translate 2.5*y 
	}

	difference {
		box {<-1.4,0,-.2><1.4,2.5,.2>}	
		box {<-1,-.1,-.3><1,2.6,.3>} 
	} 
	box {<-1.9,0,-.4><-1.3,.5,.2>}	
	box {<1.9,0,-.4><1.3,.5,.2>}	
	box {<1.8,4,-.2><-1.8,4.5,.2>}	

	cone {<1.6,0,0> .25 <1.6,4.5,0> .2 scale <1,1,.5> translate <0,0,-.2>}
	cone {<1.6,0,0> .25 <1.6,4.5,0> .2 scale <-1,1,.5> translate <0,0,-.2>}

	sphere {0,1 scale <.35,.15,.35> scale <1,1,.5> translate <1.6,4.5,-.2>}
	sphere {0,1 scale <.35,.15,.35> scale <1,1,.5> translate <-1.6,4.5,-.2>}


	box {<-.9,2,-.3><-1.4,2.1,.2>}	
	box {<.9,2,-.3><1.4,2.1,.2>}	


}

#declare Randsockel =
union {
	box {<-1.8,0,-.35> <1.8,1,.4>}	
	box {<-1.8,.6,-.4> <1.8,.7,.4>}

	box {<-2,0,-.45><-1.2,1,.2>}	
	box {<2,0,-.45><1.2,1,.2>}	


}

#declare Seitenbild = 
union {
/*	difference {
		box { <-22.5,0,0> <-10,19,.3>}
		box { <-19.5,15,-.1> <-9.5,19.5,.4> } 
		#declare ct1=0
		#while (ct1<8)
		box { <-19.5+ct1,15-ct1,-.1> <-9.5,19.5,.4> } 
		#declare ct1=ct1+1
		#end
		box  { <-12,5,-.1> <-9.5,7,.4> } 
		box { <-19.5+8.5,15-8,-.1> <-9.5,19.5,.4> } 
		

	}
*/
	object {Randelement rotate 180*y translate <-20.7,0,.5> }
	object {Randsockel rotate 180*y translate <-20.7,4.5,.5>}

	object {Randelement rotate 180*y translate <-20.7+3.2,0,.5> }
	object {Randsockel rotate 180*y translate <-20.7+3.2,4.5,.5> }

	object {Randelement rotate 180*y translate <-20.7+6.4,0,.5> }
	object {Randsockel rotate 180*y translate <-20.7+6.4,4.5,.5> }

	object {Randelement  rotate (180)*y 
		translate <1.6,0,.2> rotate -20*y 	translate <-1.6,0,-.2>  
		translate <-20.7+9.6,0,.5> }
	object {Randsockel  rotate (180)*y 
		translate <1.6,0,.2> rotate -20*y 	translate <-1.6,0,-.2>  
		translate <-20.7+9.6,4.5,.5>}

	object {Randelement rotate 180*y scale <1,1,1> 
		translate <-20.7,5.5,.5> }
	object {Randsockel rotate 180*y translate 5.5*y scale <1,1,1> 
		translate <-20.7,4.5,.5> }

	object {Randelement rotate 180*y scale <1,.9,1>
		translate <-20.7+3.2,5.5,.5>}
	object {Randsockel rotate 180*y translate 5.5*y scale <1,.9,1>
		translate <-20.7+3.2,4.5,.5>}

	object {Randelement rotate 180*y scale <1,.8,1>
		translate <-20.7+6.4,5.5,.5>}
	object {Randsockel rotate 180*y translate 5.5*y scale <1,.8,1>
		translate <-20.7+6.4,4.5,.5>}

	object {Randsaeule   rotate 180*y 
		translate <-20.7-1.6,11,.2>}
	object {Randsaeule   rotate 180*y 
		translate <-20.7,11,.2>}
	box {<.4,4.5,-.35><1.9,1+4.5,.2> rotate 180*y 
		translate <-20.7,11,.2>}
	








	rotate -70*y

}

#declare Segel =
union {
	//box {<-.1,0,-1> <.1,1,1>}
	
	bicubic_patch {
	    type 1
    	flatness .01
	    u_steps 3
    	v_steps 3
	    <0,1,-1>,  <-.4,1,-.33>,   <-.4,1,.33>,   <0,1,1>,
    	<0,.67,-1.1>,  <-1.,.67,-.9>,   <-1,.67,.9>,   <0,.67,1.1>,
	    <0,.33,-1.2>,  <-1.,.33,-.99>,  <-1.,.33,.99>,  <0,.33,1.2>,
    	<0,0,-1.3>, <-.3,0,-.5>,  <-.3,0,.5>,  <0,0,1.3>
	}  
	
	bicubic_patch {
	    type 1
    	flatness .01
    	u_steps 3
	    v_steps 3
    	<0,1,-.85>,  <-.5,1,-.25>,   <-.5,1,.25>,   <0,1,.85>,
	    <0,.67,-.9>,  <-1.,.67,-.7>,   <-1,.67,.7>,   <0,.67,.9>,
    	<0,.33,-.95>,  <-1.,.33,-.7>,  <-1.,.33,.7>,  <0,.33,.95>,
	    <0,0,-1>, <-.4,0,-.33>,  <-.4,0,.33>,  <0,0,1>

		scale .67*y
		translate 1*y
	}
  
	bicubic_patch {
	    type 1
    	flatness .01
    	u_steps 3
	    v_steps 3
    	<0,1,-.75>,  <-.6,1,-.25>,   <-.6,1,.25>,   <0,1,.75>,
	    <0,.67,-.75-.033>,  <-1.,.67,-.7>,   <-1,.67,.7>,   <0,.67,.75+.033>,
    	<0,.33,-.75-.067>,  <-1.,.33,-.7>,  <-1.,.33,.7>,  <0,.33,.75+.067>,
	    <0,0,-.85>, <-.5,0,-.25>,  <-.5,0,.25>,  <0,0,.85>

		scale .33*y
		translate 1.67*y
	}
	
	bicubic_patch {
	    type 1
    	flatness .01
    	u_steps 3
	    v_steps 3
    	<-.4,1,-.58>,  <-.6,.6,-.25>,   <-.6,.6,.25>,   <-.4,1,.58>,
	    <-.267,.67,-.55-.067>,<-1.,.47,-.7>,<-1,.47,.7>,<-.267,.67,.55+.067>,
    	<-.133,.33,-.55-.133>,<-1.,.33,-.7>,<-1.,.33,.7>,<-.133,.33,.55+.133>,
	    <0,0,-.75>, <-.6,0,-.25>,  <-.6,0,.25>,  <0,0,.75>

		scale .4*y
		translate 2*y
	}


	scale 2*x  

	pigment {rgbt <.5,.5,.1,.3>} 
	finish {ambient .4}
//	pigment {rgb <.5,.5,.1>} 

}
 
#declare Grosses_Segel =
union {
	bicubic_patch {
	    type 1
    	flatness .01
    	u_steps 3
	    v_steps 3
    	<11.614677*.80901699,0,11.614677*.58778525>,  <7,-1,3>,   
			<7,-1,-3>,   <11.614677*.80901699,0,-11.614677*.58778525>,


	    <5,-1,5>,<5.,-.5,2>,<5,-1.5,-2>,<5,-1,-5>,


    	<1,-1,7>,<1.,0,3>,<1.,-2.5,-3>,<1,-1,-7>,


	    <-11.614677*.309016990,0,11.614677*.95105652>, <-.1,-2,2>, 
			<-.1,-2,-2>,  <-11.614677*.30901699,0,-11.614677*.95105652>

	}


	//box {<11.614677*.80901699,0,11.614677*.58778525> <0,1,0>}
	//box {<-11.614677*.30901699,0,11.614677*.95105652> <0,1,0>}


	scale 2*y


	pigment {rgbt <.5,.5,.1,.3>} 
//	pigment {rgb <.5,.5,.1>} 
	finish {ambient .4}

}

//object {KleineSaeule pigment {Grey} translate -.5*x}
//object {KleineSaeule pigment {Grey} translate .5*x}
//object {Dach pigment {Grey} }
//object {Bogen pigment {Grey}}


#declare InneresTheater = 
object {
	difference {
		union {
			cylinder { <0,0,0>, <0,5,0>, 12}
			box { <-5,0,-12>, <0,5,12> }
			
		}
		box { <-12.5,-.5,-12.5>, <-4.701,5.5,12.5>}
		#if (Details>-2)
		union {
			#declare ct1=0
			#while (ct1<5)
			cylinder { <0,ct1-.001,0>, <0,5.5,0>, 5+ct1}
			box { <-5.5,ct1-.001,-5-ct1>, <0,5.5,5+ct1>}
			#declare ct1=ct1+.5
			#end
		}
		#else 
		cone {<0,-.001,0> 5 <0,5.5,0>, 5+4.5}
		cone {<-5.5,-.001,0> 5 <-5.5,5.5,0>, 5+4.5}

		#end
		
		#if (Details>0)
		intersection {
			union {
				#declare ct1=0
				#while (ct1<5)
				cylinder { <0,ct1+.167,0>, <0,5.5,0>, 5+ct1+.167}
				cylinder { <0,ct1+.333,0>, <0,5.5,0>, 5+ct1+.333}

				#declare ct1=ct1+.5
				#end
			}
			union {
				box{ <1,0,4>, <0,5,10>}
				box{ <1,0,-10>, <0,5,-4>}
				box{ <1,0,-10>, <0,5,-4> rotate -60*y}	
				box{ <1,0,4>, <0,5,10> rotate 60*y}

			}
		}
		#end
	}
} 

#declare AeusseresTheater = 
union {
	difference {
		//union {
			cylinder { <0,0,0>, <0,17,0>, 22}

		//}
		cylinder { <0,6.1-.001,0>, <0,7,0>, 11.5}	
		cylinder { <0,5.2-.001,0>, <0,20+.001,0>, 11.5-.5}	
		cylinder { <0,5.4-.001,0>, <0,6.2,0>, 11.5+.2}	

		cylinder { <0,0-.001,0>, <0,20+.001,0>, 9.5}

		difference {
			cylinder { <0,0-.001,0>, <0,5.5,0>, 11.5+.4}
			cylinder { <0,0-.001,0>, <0,5.5,0>, 9.5+.1}
		}
		box { <0,4.5,-11> <-12,7,11>}		

		box { <-30,0-.001,0>,<0,20+.001,30> rotate -70*y}
		box { <-30,0-.001,-30>,<0,20+.001,0> rotate 70*y}

		// Rand an Bruestung
		#if (Details>2) 
		#declare ct1=-110
		#while (ct1<=110)
		difference {
			box {<10,-.15,-.15> <11.1,.15,.15>}
			box {<10,-.05,-.05> <11.2,.05,.05>}		
			pigment {rgb <48,104,78>/255}
			rotate 45*x scale <1,.8,1> translate 7.25*y
			rotate ct1*y
		}
		#declare ct1=ct1+2
		#end
		#end

		// Sitze
		#if (Details>-3)
		union {
			#declare ct1=0
			#while (ct1<6.5)
			cylinder { <0,5+2.5+ct1,0>, <0,20+.001,0>, 11.5+1.5+ct1}
	
			#declare ct1=ct1+.5
			#end
		}
		#else
		cone {<0,5+2.5+0,0>,11.5+1.5, <0,14+.001,0>, 11.5+1.5+6}
		#end
		// obere Galerie
		cylinder { <0,5+2.5+6.5,0>, <0,20+.001,0>, 11.5+1.5+6.5+1-.2}
		cylinder { <0,5+2.5+6.5+.5,0>, <0,5+2.5+6.5+1.6+.001,0>, 11.5+1.5+6.5+1}
	
		#if (Details>-1)
		intersection {
			// Treppen
			union {
				#declare ct1=0
				#while (ct1<6.5)
				cylinder { <0,5+2.5+ct1+.167,0>, <0,14+.001,0>, 
					11.5+1.5+ct1+.167}
				cylinder { <0,5+2.5+ct1+.333,0>, <0,14+.001,0>, 
					11.5+1.5+ct1+.333}
				#declare ct1=ct1+.5
				#end
			}
			union {
				box{ <-.5,5+2.5,10>, <.5,13.5+.001,22>}
				box{ <-.5,5+2.5,-22>, <.5,13.5+.001,-10>}
				box{ <-.5,5+2.5,-22>, <.5,13.5+.001,-10> rotate -36*y}	
				box{ <-.5,5+2.5,10>, <.5,13.5+.001,22> rotate 36*y}
				box{ <-.5,5+2.5,-22>, <.5,13.5+.001,-10> rotate -72*y}	
				box{ <-.5,5+2.5,10>, <.5,13.5+.001,22> rotate 72*y}

				box{ <-2,10.5,-10>,<2,13.5+.001,-22> rotate -0*y}
				box{ <-2,10.5,10>,<2,13.5+.001,22> rotate 0*y}
				box{ <-2,10.5,-10>,<2,13.5+.001,-22> rotate -36*y}
				box{ <-2,10.5,10>,<2,13.5+.001,22> rotate 36*y}
				box{ <-2,10.5,-10>,<2,13.5+.001,-22> rotate -72*y}
				box{ <-2,10.5,10>,<2,13.5+.001,22> rotate 72*y}



			}
		}
		#end
		union {						//untere Eingaenge
			box{ <1,5,8>,<0,7,15>} 
			box{ <1,5,8>,<0,7,15> rotate 60*y}
			box{ <1,5,-8>,<0,7,-15>}
			box{ <1,5,-8>,<0,7,-15> rotate -60*y}
		}
		union {						// obere Eingaenge
			box{ <1.5,11,-20>, <-1.5,13.5+.001,-10> rotate -0*y}	
			box{ <1.5,11,10>, <-1.5,13.5+.001,20> rotate 0*y}
			box{ <1.5,11,-20>, <-1.5,13.5+.001,-10> rotate -36*y}	
			box{ <1.5,11,10>, <-1.5,13.5+.001,20> rotate 36*y}
			box{ <1.5,11,-20>, <-1.5,13.5+.001,-10> rotate -72*y}	
			box{ <1.5,11,10>, <-1.5,13.5+.001,20> rotate 72*y}
		}
	}

	// Gelaender
	#if (Details>1)
	union {
		#declare ct=-110
		#while (ct<=110)
		cylinder {<0,0,0> <0,1,0> .02 translate <0,7.5,11.4> 
			rotate (90+ct)*y}
		sphere {0,.05 translate <0,1+7.5,11.4> rotate (90+ct)*y}
		cone {<0,1,0> .02 <0,1.2,0> .0 translate <0,7.5,11.4> 
			rotate (90+ct)*y}
	
		#declare ct=ct+5
		#end

		#declare ct=-110+2.5
		#while (ct<=110)
		cylinder {<0,-.55,0> <0,.55,0> .02 rotate 60*z translate .4*y 
			translate <0,7.5,11.4> 
			rotate (90+ct)*y}	
		cylinder {<0,-.55,0> <0,.55,0> .02 rotate -60*z translate .4*y 
			translate <0,7.5,11.4> 
			rotate (90+ct)*y}
		cylinder {<0,-.55,0> <0,.55,0> .02 rotate -90*z translate .75*y 
			translate <0,7.5,11.4> 
			rotate (90+ct)*y}
		box {<-.1,-.1,-.03> <.1,.1,.03>  translate .4*y 
			translate <0,7.5,11.4> 
			rotate (90+ct)*y}


		#declare ct=ct+5
		#end
		pigment {rgb <204,34,8>/255}

	}
	#end

	#if (Details>-1)	
	#declare ct=-15
	#while (ct<0)
	object {KleineSaeule translate <0,5,11.4>  rotate ct*y}
	object {KleineSaeule translate <0,5,-11.4>  rotate -ct*y}
	#declare ct=ct+10
	#end
	#declare ct=20
	#while (ct<60)
	object {KleineSaeule translate <0,5,11.4>  rotate ct*y}
	object {KleineSaeule translate <0,5,-11.4>  rotate -ct*y}
	#declare ct=ct+10
	#end
	#declare ct=75
	#while (ct<90)
	object {KleineSaeule translate <0,5,11.4>  rotate ct*y}
	object {KleineSaeule translate <0,5,-11.4>  rotate -ct*y}
	#declare ct=ct+10
	#end

	object {Haeuschen}
	object {Haeuschen rotate 60*y}
	object {Haeuschen scale -z}
	object {Haeuschen scale -z rotate -60*y}

	object {Faehnchen rotate 60*y translate <.5,5,9.5>}
	object {Faehnchen translate <.5,5,9.5> rotate 60*y}
	object {Faehnchen rotate 60*y translate <.5,5,-9.5>}
	object {Faehnchen rotate 120*y translate <.5,5,-9.5> rotate -60*y}

	#end

//		cylinder { <0,5+2.5+6.5,0>, <0,20+.001,0>, 11.5+1.5+6.5+1}
	
	#if (Details>-4)
	
	#declare ct=-8*13-4
	#while (ct<=8*13+4)
	object {KleineSaeule translate <20,14,0> rotate ct*y}
	#declare ct=ct+8
	#end

	#declare ct=-8*13
	#while (ct<=8*13)
	object {Bogen scale <1,1,1> translate <20,14,0> rotate ct*y}
	#declare ct=ct+8
	#end
	
	#end	
	
	#if (Details>-4)
	
	#declare ct=-8*12-12
	#while (ct<=8*12+12)
	cone {<0,0,0> .06 <0,3,0> .04  rotate 20*z translate 10*y rotate 60*z translate <20,19+1,0> rotate ct*y}
	cone {<0,0,0> .15 <0,10,0> .06  rotate 60*z translate <20,19+1,0> rotate ct*y}		
	cone {<0,-1,0> .18 <0,1,0> .15  translate <20,19,0> rotate ct*y}

	#declare ct=ct+24
	#end

	#declare ct=-8*12
	#while (ct<=8*12)
	object {Segel scale <1,5,3.3> rotate 60*z translate <20,19+1,0> rotate ct*y}
	#declare ct=ct+24
	#end
	
	object {Grosses_Segel 
		translate <0,19+1+10*.5+3*.017452406,0> 
		//rotate -12*y
	}
		

	#end


}


#declare Theater =
union {
	object {AeusseresTheater texture {pigment{Sand} finish {ambient .3}}}
	object {InneresTheater texture {pigment{SandDunkel}finish {ambient .3}}}

	#if (Details>1)
	object {Seitenbild pigment {Sand} finish {ambient .3}}
	object {Seitenbild pigment {Sand} finish {ambient .3} scale -1*z}
	#end

	intersection {
		plane {y 0.01  }
		box {<-18,-1,-50> <16,1,50>}
		texture {pigment {image_map {tga "boden.tga"}} scale 2 rotate 90*x rotate 45*y}
	}
}

