// ******************** a piece of an arch *****************************
// *********************************************************************
#macro arc(angl,wid,inrad,outrad)

object{
 difference{
  cylinder{<0,0,-wid/2>,<0,0,wid/2>,outrad}
  cylinder{<0,0,-wid/2*1.05>,<0,0,wid/2*1.05>,inrad}
  box{<-(outrad)*1.1, -(outrad)*1.1, -wid*0.6>,
      <(outrad)*1.1, 0, wid*0.6>}
  box{<-(outrad)*1.1, -(outrad)*1.1, -wid*0.6>,
      <(outrad)*1.1, 0, wid*0.6> rotate <0,0,180-angl>}
 }
}

#end

// ************************** a cascade of arch pieces *****************
// *********************************************************************

#macro cascade(steps,stepheight,angl,inrad,wid,diff)
 object{
  union{
   #local i = 0;
   #while (i < steps)
    #local irad = inrad + i*stepheight; 
    #if (diff)
     #local irad = (inrad + i*stepheight)*0.9;
    #end
    #local orad = inrad + (i+1)*stepheight;
    #local aangl = angl - (2*i*stepheight*180/pi/irad);
    #local awidt = wid - 2*i*stepheight;
    object{arc(aangl,awidt,irad,orad) rotate <0,0,-(angl-aangl)/2>}
    #local i = i + 1;
   #end
  }
 }
#end
// *********************************************************************
// *********************************************************************

#macro roof(side,athick)
 object{
  union{
   difference{
    box{<-side/2,0,-side/2>,<side/2,side/1.9,side/2>}
    cylinder{<0,0,-side/1.5>,<0,0,side/1.5>,side/2}
    cylinder{<-side/1.5,0,0>,<side/1.5,0,0>,side/2}
   }
    object{arc(180,athick,side/2-athick,side/2) 
           scale <sqrt(2),1,sqrt(2)> 
           rotate<0,45,0>}
    object{arc(180,athick,side/2-athick,side/2) 
           scale <sqrt(2),1,sqrt(2)> 
           rotate<0,-45,0>}
  }
 }
#end

// *********************************************************************
// *********************************************************************

#macro tcyl(p1,p2,ri,ro)
object{
 difference{
  cylinder{p1,p2,ro}
  cylinder{(p2-p1)*1.1,p1-p2*1.1,ri}
 }
}

#end

// *********************************************************************
// *********************************************************************

#macro roundedge(heig,len,wid,rad,hoff)
 object{
  difference{
   box{<len/2,0,wid/2>,<-len/2,heig,-wid/2>}
   cylinder{<0,-hoff,wid/2*1.1>,<0,-hoff,-wid/2*1.1>,rad}
  }
 }
#end 

#macro roundedgeh(heig,len,wid,rad,hoff,wthick)
 object{
  difference{
   roundedge(heig,len,wid,rad,hoff)
   roundedge(heig-wthick,len-2*wthick,wid*1.1,rad+wthick,hoff)
  }
 }
#end 
// *********************************************************************
// *********************************************************************

#macro eqbox(wid,leng,heigb,heig)

 object{
  box{<-wid/2,heigb,-leng/2>,<wid/2,heigb+heig,leng/2>}
 }

#end 



// *********************************************************************
// *********************************************************************
#macro roundb(L,W,R)
 
object{ 
 union{
//  box{<L/2,0,W/2>,<-L/2,R,-W/2>}
  intersection{
   cylinder{<-L/2, R, -W/2-R>, <-L/2, R, W/2+R>, R}
   cylinder{<-L/2-R, R, -W/2>, <L/2+R, R, -W/2>, R}
   box{<L/2+2*R,0,W/2+2*R>,<-L/2-2*R,R,-W/2-2*R>}
  }
  intersection{
   cylinder{<L/2, R, -W/2-R>, <L/2, R, W/2+R>, R}
   cylinder{<-L/2-R, R, -W/2>, <L/2+R, R, -W/2>, R}
   box{<L/2+2*R,0,W/2+2*R>,<-L/2-2*R,R,-W/2-2*R>}
  }
  intersection{
   cylinder{<-L/2, R, -W/2-R>, <-L/2, R, W/2+R>, R}
   cylinder{<-L/2-R, R, W/2>, <L/2+R, R, W/2>, R}
   box{<L/2+2*R,0,W/2+2*R>,<-L/2-2*R,R,-W/2-2*R>}
  }
  intersection{
   cylinder{<L/2, R, -W/2-R>, <L/2, R, W/2+R>, R}
   cylinder{<-L/2-R, R, W/2>, <L/2+R, R, W/2>, R}
   box{<L/2+2*R,0,W/2+2*R>,<-L/2-2*R,R,-W/2-2*R>}
  }
  difference{
   union{
    cylinder{<-L/2, R, -W/2>,<-L/2, R, W/2>, R}
    cylinder{<L/2, R, -W/2>,<L/2, R, W/2>, R}
    cylinder{<-L/2, R, W/2>,<L/2, R, W/2>, R}
    cylinder{<-L/2, R, -W/2>,<L/2, R, -W/2>, R}
   }
   box{<-L/2-R,R,-W/2-R>,<L/2+R,2*R,W/2+R>}
  }
 }
}
#end

// *********************************************************************
// *********************************************************************
#macro arch(rad,wid,thick)

object{
 union{
  object{arc(10,rad*0.1,rad,rad+thick) 
         translate <0,0,-wid/2> 
         rotate <0,0,-85>}
  torus{thick*0.25, thick*0.05 
        rotate <0,0,90> 
        translate<-0.2*thick, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.25,thick*0.05
        rotate <0,0,90> 
        translate<0, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.2,thick*0.05 
        rotate <0,0,90> 
        translate<-0.1*thick, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.25,thick*0.05
        rotate <0,0,90> 
        translate<0.2*thick, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.2,thick*0.05 
        rotate <0,0,90> 
        translate<0.1*thick, rad+thick*0.7,-wid/2*1.2>}
  sphere{0,0.15*thick 
         scale <2,1,1> 
         translate <0,rad+0.2*thick,-wid/2*1.2>}
  cylinder{<-0.25*thick, rad+thick*0.7,-wid/2*1.2>,
           <-0.15*thick, rad+thick*0.7,-wid/2*1.2>,thick*0.25}
  cylinder{<0.25*thick, rad+thick*0.7,-wid/2*1.2>,
           <0.15*thick, rad+thick*0.7,-wid/2*1.2>,thick*0.25}
  cylinder{<-0.05*thick, rad+thick*0.7,-wid/2*1.2>,
           <0.05*thick, rad+thick*0.7,-wid/2*1.2>,thick*0.25}
  roundedgeh(rad+thick,2*(rad+thick),wid*0.95,rad+thick,0,0.2)
  roundedge(rad+thick,2*(rad+thick),wid*0.9,rad+thick,0)
  roundedgeh(rad+thick/2,2*(rad+0.4*thick),wid,rad+1.3*thick,0,0.1)
  eqbox(2*(rad+thick), wid, rad+thick, 0.2*thick)
  eqbox(2*(rad+thick), 0.9*wid, rad+thick+0.2*thick, 2.3*thick)
  eqbox(2*(rad+thick), wid, rad+thick+1.5*thick, 0.2*thick)
  eqbox(2*(rad+thick), wid, rad+thick+1.9*thick, 0.2*thick)
  difference{
   union{
    cylinder{<0,0,wid/2>,<0,0,-wid/2>,rad+thick} 
    tcyl(<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad+0.2*thick,rad+0.3*thick)
    tcyl(<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad+0.5*thick,rad+0.6*thick)
    tcyl(<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad+0.7*thick,rad+0.8*thick)
   } 
   cylinder{<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad}
   box{<-(rad+thick)*1.1, -(rad+thick)*1.1, -wid*0.6>,
       <(rad+thick)*1.1, 0, wid*0.6>}
   object{cascade(3,thick/8,20,rad,wid*0.8,1) rotate <0,0,  -5>}
   object{cascade(3,thick/8,20,rad,wid*0.8,1) rotate <0,0, -30>}
   object{cascade(3,thick/8,10,rad,wid*0.8,1) rotate <0,0, -55>}
   object{cascade(3,thick/8,10,rad,wid*0.8,1) rotate <0,0, -70>}
   object{cascade(3,thick/8,10,rad,wid*0.8,1) rotate <0,0, -85>}
   object{cascade(3,thick/8,10,rad,wid*0.8,1) rotate <0,0,-100>}
   object{cascade(3,thick/8,10,rad,wid*0.8,1) rotate <0,0,-115>}
   object{cascade(3,thick/8,20,rad,wid*0.8,1) rotate <0,0,-130>}
   object{cascade(3,thick/8,20,rad,wid*0.8,1) rotate <0,0,-155>}
  }
 }
}

#end

// *********************************************************************
// *********************************************************************
#macro archn(rad,wid,thick)

object{
 union{
  object{arc(10,rad*0.1,rad,rad+thick) 
         translate <0,0,-wid/2> 
         rotate <0,0,-85>}
  torus{thick*0.25, thick*0.05 
        rotate <0,0,90> 
        translate<-0.2*thick, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.25,thick*0.05
        rotate <0,0,90> 
        translate<0, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.2,thick*0.05 
        rotate <0,0,90> 
        translate<-0.1*thick, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.25,thick*0.05
        rotate <0,0,90> 
        translate<0.2*thick, rad+thick*0.7,-wid/2*1.2>}
  torus{thick*0.2,thick*0.05 
        rotate <0,0,90> 
        translate<0.1*thick, rad+thick*0.7,-wid/2*1.2>}
  sphere{0,0.15*thick 
         scale <2,1,1> 
         translate <0,rad+0.2*thick,-wid/2*1.2>}
  cylinder{<-0.25*thick, rad+thick*0.7,-wid/2*1.2>,
           <-0.15*thick, rad+thick*0.7,-wid/2*1.2>,thick*0.25}
  cylinder{<0.25*thick, rad+thick*0.7,-wid/2*1.2>,
           <0.15*thick, rad+thick*0.7,-wid/2*1.2>,thick*0.25}
  cylinder{<-0.05*thick, rad+thick*0.7,-wid/2*1.2>,
           <0.05*thick, rad+thick*0.7,-wid/2*1.2>,thick*0.25}
  roundedgeh(rad+thick,2*(rad+thick),wid*0.95,rad+thick,0,0.2)
  roundedge(rad+thick,2*(rad+thick),wid*0.9,rad+thick,0)
  roundedgeh(rad+thick/2,2*(rad+0.4*thick),wid,rad+1.3*thick,0,0.1)
  eqbox(2*(rad+thick), wid, rad+thick, 0.2*thick)
  eqbox(2*(rad+thick), 0.9*wid, rad+thick+0.2*thick, 2.3*thick)
  eqbox(2*(rad+thick), wid, rad+thick+1.5*thick, 0.2*thick)
  eqbox(2*(rad+thick), wid, rad+thick+1.9*thick, 0.2*thick)
  difference{
   union{
    cylinder{<0,0,wid/2>,<0,0,-wid/2>,rad+thick} 
    tcyl(<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad+0.2*thick,rad+0.3*thick)
    tcyl(<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad+0.5*thick,rad+0.6*thick)
    tcyl(<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad+0.7*thick,rad+0.8*thick)
   } 
   cylinder{<0,0,wid/2*1.05>,<0,0,-wid/2*1.05>,rad}
   box{<-(rad+thick)*1.1, -(rad+thick)*1.1, -wid*0.6>,
       <(rad+thick)*1.1, 0, wid*0.6>}
  }
 }
}

#end

// *********************************************************************
// *********************************************************************

#macro rbox(heig,wid)
 #local leng = sqrt(2)*heig;
 object{
  difference{
   box{<leng/2,leng/2,wid/2>,<-leng/2,-leng/2,-wid/2> rotate <0,0,45>}
   box{<leng,0,wid>,<-leng,-leng,-wid>}
  }
 }
#end

#macro rboxh(heig,wid,thick)
 object{
  difference{
   rbox(heig,wid)
   rbox(heig-thick,wid*1.1)
  }
 }
#end

// *********************************************************************
// *********************************************************************

#declare heighta = array[3][6]{{0.05, 0.05, 0.10, 0.05, 0.05, 0.15},
                               {1.80, 1.60, 1.70, 1.60, 1.80, 1.60},
                               {1.20, 1.00, 1.10, 1.00, 1.10, 1.00}
                              }
#declare heightb = array[3][6]{{0.05, 0.05, 0.05, 0.10, 0.05, 0.05},
                               {2.20, 2.15, 2.25, 2.20, 2.35, 2.40},
                               {1.60, 1.55, 1.65, 1.60, 1.75, 1.80}
                              }


#declare orna1 = object{
 union{
  #declare i = 0;
  #declare hpos = 0;
  #while (i < 6)
   object{eqbox(heighta[1][i],heighta[2][i],hpos,heighta[0][i])}
   #declare hpos = hpos + heighta[0][i];
   #declare i = i + 1;  
  #end
  object{roundb(1.60,1.00,0.2) translate <0,hpos,0>}
  #declare hpos = hpos + 0.2;
  #declare i = 0;
  #while (i < 6)
   object{eqbox(heightb[1][i],heightb[2][i],hpos,heightb[0][i])}
   #declare hpos = hpos + heightb[0][i];
   #declare i = i + 1;  
  #end
  object{rbox(0.5, 1.2) translate <0,hpos,0>}
  object{rboxh(0.8, 1.3, 0.3) translate <0,hpos,0>}
  object{rboxh(0.85, 1.4, 0.05) translate <0,hpos,0>}
  object{rboxh(0.9, 1.5, 0.05) translate <0,hpos,0>}
  eqbox(1.7, 1.2, hpos,1.4)
  eqbox(1.8, 1.6, hpos+1.3,0.2)
  eqbox(1.8, 1.6, hpos+0.95,0.2)
 }
}

// *********************************************************************
// *********************************************************************


#macro spiral(thickbeg,height,turns,radbeg,angbeg,slope)
 #local elem = int(turns*360/10);
 #local i = 0;
 object{
  union{
   #while (i < elem)
    #local ang = i*10 + angbeg;
    #local rad = radbeg - i*(radbeg/elem);
    #local thick = thickbeg + i*slope/360*10;
    #local barc = 0.1745329 * 1.1 * (rad+height/2);
    #local slch = degrees(atan2(slope,rad));
    box{<-thick/2,-height/2,-barc/2>,<thick/2,height/2,barc/2>
        translate <0,rad,0>
        rotate <ang+90-slch/2,0,0>} 
    #local i = i + 1;
   #end
  }
 }
#end

//****************************************************************
//****************************************************************

#macro updown(rad, thick)
 object{
  union{
   box{<0,rad,-thick/2>,<rad,2*rad,thick/2>}
   difference{
    box{<0,0,-thick/2>,<rad,rad,thick/2>}
    cylinder{<rad,0,-0.6*thick>,<rad,0,0.6*thick>,rad}
   }
   intersection{
    box{<rad,rad,-thick/2>,<2*rad,2*rad,thick/2>}
    cylinder{<rad,2*rad,-0.6*thick>,<rad,2*rad,0.6*thick>,rad}
   }
  }
 }

#end    

//****************************************************************
//****************************************************************

#declare orna2 = object{
union{
 object{spiral(1,0.3,2.5,0.5,90,0.2) translate <0,0.65,-0.5>}
 object{spiral(1,0.3,2.5,0.5,90,0.2) translate <0,5.5,-1.75>}
 box{<-0.5,0,0>,<0.5,4.75,-0.5>}
 object{updown(0.5,1) rotate <0,90,0> translate <0,3.75,-0.5>}
 box{<-0.5, 4.75, 0>,<0.5, 6, -1.75>}
 box{<-0.5,0,0>,<0.5,6,1> }
 }
}

// ****************************************************************
// ****************************************************************

#declare orna3 = object{
 union{
  eqbox(2*(5+1), 3, 5+1, 0.2*1)
  eqbox(2*(5+1), 0.9*3, 5+1+0.2*1, 2.3*1)
  eqbox(2*(5+1), 3, 5+1+1.5*1, 0.2*1)
  eqbox(2*(5+1), 3, 5+1+1.9*1, 0.2*1)
 }
}

// ****************************************************************
// ****************************************************************

#declare orna4 = object{
 difference{
  box{<0,6.1,0>,<1,7.5,-2>}
  box{<0.1,5.5,-0.2>,<0.9,6.5,-1.8>}
 }
}

#declare roof2 = object{
 union{
  #declare j = 0;
  #while (j < 12)
   #declare h = 0;
   #while (h < 6)
    object{orna4 translate <j,0,h*-2>}
    #declare h = h + 1;
   #end
   #declare j = j + 1;
  #end
 }
}