// Persistence of Vision Ray Tracer Scene Description File
// File: roulette.pov
// Vers: 3.1
// Desc: IRTC entry, subject Ruins
// Date: January-February 2000
// Auth: Jrme Grimbert

#include "finish.inc"  
#include "colors.inc"
#include "woods.inc"
#include "metals.inc" 

#include "shapes.inc"
#include "shapes2.inc"


#declare num=array[37]{0,32,15,19,4,21,2,25,17,34,6,27,13,
36,11,30,8,23,10,5,24,16,33,1,20,14,31,9,22,18,29,7,28,12,35,3,26}

#declare pilo1=array[36] {0,0,12,9,4,
                         16,0,8,5,13,
                         0,17,0,3,0,
                         14,7,2,9,0,
                         4,0,0,15,6,
                         7,5,0,17,9,
                         9,4,6,0,13,
                         9}
#declare pilo2=array[36] {3,7,0,0,0,
                         0,0,0,5,0,
                         10,0,0,0,4,
                         0,0,9,0,0,
                         0,0,6,0,0,
                         0,3,0,0,20,
                         0,0,12,0,0,
                         0}                         

#declare pilo4=array[36] {0,0,7,0,4,
                         0,0,8,5,13,
                         0,5,6,0,1,
                         5,7,8,0,0,
                         0,0,0,0,6,
                         3,2,1,2,9,
                         10,5,6,20,1,
                         0}
#declare pilo3=array[36] {3,0,2,3,0,
                         0,7,0,8,0,
                         8,0,0,0,4,
                         0,0,9,0,0,
                         3,0,0,2,3,
                         0,3,6,0,6,
                         4,0,7,4,0,
                         0}                         

#declare bo1=array[8] { 
     pigment{Red},
     pigment{Red},
     pigment{Magenta},
     pigment{Magenta},
     pigment{Green},
     pigment{Blue},
     pigment{Yellow},
     pigment{Black}
      }
      
#declare bo2=array[8] { 
     pigment{White},
     pigment{Black},
     pigment{White},
     pigment{Black},
     pigment{Black},
     pigment{White},
     pigment{Black},
     pigment{White}
      }

#declare cent=array[8] {
     pigment{White},
     pigment{Red},
     pigment{White},
     pigment{Magenta},
     pigment{White},
     pigment{White},
     pigment{Black},
     pigment{Black}
     }

#declare rayon=56/2;

global_settings { max_trace_level 20 }

camera {location <000,90,-100>
up y
right 4/3*x  
direction 2*z 
look_at <0,0,45>
}



light_source
{
  0*x // light's position (translated below)
  color rgb 1.0  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <80, 0, 0> <0, 0, 80> // lights spread out across this distance (x * z)
  6, 6                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 2          // 0,1,2,3... 
  jitter              // adds random softening of light
  translate <00, 200, 00>   // <x y z> position of light
}



box { <-50,0,-50>,<50,-10,200> 
texture {pigment { rgb <0,0.8,0> } finish { Dull }} 
}
box { <-50,0,-50>,<-48,2,200>
texture {T_Wood6 }
}
box { <50,0,-50>,<48,2,200>
texture {T_Wood6 }
}
box { <-50,0,-50>,<50,2,-48>
texture {T_Wood6 rotate <0,90,0> }
}

box { <-50,0,200>,<50,2,198>
texture {T_Wood6 rotate <0,90,0> }
}


plane { y, -90
texture { 
checker 
texture {
 T_Wood1 scale 2.5
 }
, texture { T_Wood1 scale 2.5 rotate <0,90,0> }
scale 20 }
//finish { Glossy }
} 

plane { -y, -250
texture { pigment { White } }
}

plane { x, -800  
texture { pigment { White } }
}

plane { -x, -800
texture { pigment { White } }
}

plane { z, -800
texture { pigment { White } }
}

plane { -z, -800
texture { pigment { White } }
}


#macro bkd(ee,ang,coul)

difference {
cylinder{ <0,0,0>,<0,1,0>,rayon+2 }
plane { -x,0 rotate <0,360/37,0>}
plane { x, 0  }
texture { pigment { coul } finish { Glossy } }
rotate <0,-ang*360/37,0>
}

cylinder { <rayon,1,0>,<rayon+2,1,0>,0.2
rotate <0,-90-ang*360/37,0>
texture { T_Chrome_3C }   
}

 
difference {
cone { <0,1,0>,rayon+2.01,<0,3,0>,rayon+4.01}
cone { <0,0,0>,rayon+1,<0,4,0>,rayon+5}
plane { -x,0 rotate <0,360/37,0>}
plane { x, 0 }
texture { pigment { coul } finish { Glossy } }
rotate <0,-ang*360/37,0>
}



text { ttf "arialalt.ttf"  str(ee,2,0) 0.08,0
 translate <0,0,-0.08> scale 2 
rotate <45,0,0>
translate <0,1.5,rayon+2.5> 
rotate <0,-ang*360/37+3,0>
texture { pigment { White } finish { Luminous } }
}
#end

union {

bkd(num[0],0,rgb<0,1,0>)
#declare i=2;
#while (i<37)
bkd(num[i],i,rgb<0,0,0>)
#declare i=i+2;
#end 

#declare i=1;
#while (i<37)
bkd(num[i],i,rgb<1,0,0>)
#declare i=i+2;
#end 
rotate <0,50,0>
}

sphere { <0,0,0>,1
translate <rayon+1,2,0>
rotate <0,-90+50+(180/37),0>
texture { pigment { White } finish { Glossy } }
}

/* merge {
cone{ <0,8,0>,2,<0,10,0>,0.5 }
cylinder {<0,10,0>,<0,17,0>,0.5  }
cylinder {<-4,15,0>,<4,15,0>,0.4 }
cylinder {<0,15,-4>,<0,15,4>,0.4 }
sphere { <0,15,0>,1 }
 texture { T_Chrome_4D } 
 rotate <0,30,0>
 } 
*/


lathe {
    linear_spline
    27,
    <0,0>, <4,0>, <4.1,0.1>,
     <4.1,0.9>, <4,1>, <3,1> ,
     <3,1.5>,<2,1.7>, <2,2>,
     <2.2,2.5>,<2.2,3>,<2.3,3.1>,
     <2.3,3.5>,<4,4>,<2,5>,
     <2,5.1>,<4,5.1>,<4.2,5.2>,
     <4.2,5.4>,<4,5.5>,<2,5.5>,
     <2,6>,<2.5,6>,<2.5,6.7>,
     <1.4,6.7>,<1.4,6.8>,<0,7.5>
    texture { T_Chrome_4D }
    scale <1,2,1>
    translate <0,8,0>
  }


#declare i=0;
#while (i<8)
difference {

cone{<0,8,0>,2,<0,1,0>,rayon 
}
plane { -x,0 rotate <0,360/8,0>}
plane { x, 0  }
texture { T_Wood9 scale 10 translate <i+1,0,i*rayon*5> rotate <8,2,0> }

rotate <0,i*360/8,0>
} 
#declare i=i+1;
#end

#declare i=0;
#while (i<14)
difference{
cylinder { <0,0,0>,<0,7.5,0>,rayon*1.5 }
cone { <0,3,0>,rayon+4,<0,5,0>,rayon*1.5-2 }
cylinder { <0,4.99,0>,<0,9,0>,rayon*1.5-2 } 
cylinder { <0,4,0>,<0,-1,0>,rayon+4 }

torus { rayon*1.5-2, 1  sturm 
 translate <0,6,0>
 }
plane { -x,0 rotate <0,360/14,0>}
plane { x, 0  }
texture { T_Wood9 scale 10 translate <0,i,i*rayon*3> rotate <-5,36,0> } 
rotate <0,i*360/14,0>
}
#declare i=i+1;
#end

#declare i=0;
#while (i<12)
object { Octahedron rotate <0,45,0> scale <1,0.5,0.25> 
rotate <75.96,0,0>
translate <0,4,((rayon+4)+(rayon*1.5-2))/2>
rotate <0,(i+0.5)*360/12,0>
texture { T_Chrome_4D }
}
#declare i=i+2;
#end

#declare i=1;
#while (i<12)
object { Octahedron rotate <0,45,0> scale <0.5,1,0.25> 
rotate <75.96,0,0>
translate <0,4,((rayon+4)+(rayon*1.5-2))/2>
rotate <0,(i+0.5)*360/12,0>
texture { T_Chrome_4D }
}
#declare i=i+2;
#end




text { ttf "arialalt.ttf" " 0" 0.01,0
translate<0,0,-0.01>
scale 5
rotate <90,0,0>
rotate <0,180,0>
translate <0,0,rayon*2.5>
translate <2,0,-10>   
texture { pigment { Yellow } finish { Dull } }

}
#declare i=0;
#declare j=0;
#while (i<12)
#while (j<3)
#declare k=i*3+j+1;
text { ttf "arialalt.ttf" str(k,2,0) 0.01,0
translate <0,0,-0.01>
scale 5
rotate <90,0,0>
rotate <0,180,0>
translate <0,0,rayon*2.5>
translate <-j*16+16,0,i*10> 

#if (i<3)
translate <2,0,0>
#end
texture { pigment { Yellow } finish { Dull } }
}
#declare j=j+1;
#end
#declare i=i+1;
#declare j=0;
#end

union {
#declare i=-1;
#while (i<13)
box { <17+4,0,i*10-5>,<-32+4,0.01,-1+i*10-5> }
#declare i=i+1;
#end 
box { <16+4,0,-11-5>,<17+4,0.01,120-5>}
box { <0+4,0,-5>,<1+4,0.01,120-5>}
box { <-16+4,0,0-5>,<-15+4,0.01,120-5>}
box { <-32+4,0,-11-5>,<-31+4,0.01,120-5>}
#declare i=0;
#while (i<4)
box { <17+17+4,0,i*40-5>,<-32+4-17,0.01,-1+i*40-5> }
#declare i=i+1;
#end 
box { <17+16+4,0,-5>,<17+17+4,0.01,120-5>}
box { <-32-17+4,0,-5>,<-31-17+4,0.01,120-5>}



translate <0,0,rayon*2.5> 
texture { pigment { Yellow } finish { Dull } }
}

text { ttf "arialalt.ttf" "Passe" 0.01,0
translate<0,0,-0.01>
scale 7
rotate <90,0,0>
rotate <0,-90,0>
translate <0,0,rayon*2.5>
translate <31,0,4>   
texture { pigment { Yellow } finish { Dull } }

}

text { ttf "arialalt.ttf" "Manque" 0.01,0
translate<0,0,-0.01>
scale 7
rotate <90,0,0>
rotate <0,90,0>
translate <0,0,rayon*2.5>
translate <-37,0,30>   
texture { pigment { Yellow } finish { Dull } }

}
text { ttf "arialalt.ttf" "Pair" 0.01,0
translate<0,0,-0.01>
scale 7
rotate <90,0,0>
rotate <0,-90,0>
translate <0,0,rayon*2.5>
translate <31,0,42>   
texture { pigment { Yellow } finish { Dull } }

}
text { ttf "arialalt.ttf" "Impair" 0.01,0
translate<0,0,-0.01>
scale 7
rotate <90,0,0>
rotate <0,90,0>
translate <0,0,rayon*2.5>
translate <-37,0,70>   
texture { pigment { Yellow } finish { Dull } }

}

superellipsoid{ <0.1,0.1> rotate <0,0,45>
scale <0.5,1,0.1>
scale <8,8,1>
rotate <90,0,0>
translate <0,0,rayon*2.5>
translate <29,0,95>   

texture {pigment {Black} finish{Dull}} 
}
 
superellipsoid{ <0.1,0.1> rotate <0,0,45>
scale <0.5,1,0.1>
scale <8,8,1>
rotate <90,0,0>
translate <0,0,rayon*2.5>
translate <-36,0,95>   

texture {pigment {Red} finish{Dull}} 
}


#macro jeton(b1,b2,c,xx,yy,zz,amp,s)
#local bord=texture
 {radial frequency 5
  texture_map {
    [0.5 pigment{b1} finish { Shiny} ]
    [0.5 pigment{b2}  finish { Shiny}  ]
    }
    }
union {
cone{ <0,0,0>,0.95,<0,0.15,0>,1 }
cone{ <0,1,0>,0.95,<0,0.85,0>,1 }
cylinder { <0,0.15,0>,<0,.85,0>,1 }
texture { cylindrical 
texture_map { 
[0.3 bord ]
[0.3 pigment {c} finish { Shiny}]
}    


  }
scale <3,0.4,3>
rotate <0,amp*rand(s),0> 
translate <xx,yy,zz>
}

#end 


#macro pile(b1,b2,c,xx,zz,h)
#local i=0;
#local j=seed(xx*zz);
#while (i<h)
jeton(b1,b2,c,xx,i*0.4,zz,120,j)
#local i=i+1;
#end
#end

#macro pile2(b1,b2,c,xx,zz,h,b)
#local i=0;
#local j=seed(xx*zz);
#while (i<h)
jeton(b1,b2,c,xx,(b+i)*0.4,zz,120,j)
#local i=i+1;
#end
#end

#declare tai=8;

#declare k=seed(42);
#declare i=0;
#while (i<12)
#declare j=0;
#while (j<3)
pile(bo1[mod((i*3+j),tai)],bo2[mod((i*3+j),tai)],
 cent[mod((i*3+j),tai)],-j*16+16+rand(k),
 rayon*2.5+i*10-2*rand(k),
 pilo1[(i*3+j)] )
pile(bo1[mod(45-(i*3+j),tai)],bo2[mod(45-(i*3+j),tai)],
 cent[mod(45-(i*3+j),tai)],-j*16+8+rand(k),
 rayon*2.5+i*10-2*rand(k),
 pilo2[(i*3+j)] )

pile2(bo1[mod((i*3+j+2),tai)],bo2[mod((i*3+j+2),tai)],
 cent[mod((i*3+j+2),tai)],-j*16+16+rand(k),
 rayon*2.5+i*10-2*rand(k),
 pilo3[(i*3+j)],pilo1[(i*3+j)] )
pile2(bo1[mod(46-(i*3+j),tai)],bo2[mod(46-(i*3+j),tai)],
 cent[mod(46-(i*3+j),tai)],-j*16+8+rand(k),
 rayon*2.5+i*10-2*rand(k),
 pilo4[(i*3+j)],pilo2[(i*3+j)] )

#declare j=j+1;
#end
#declare i=i+1;
#end

pile(bo1[6],bo2[6],cent[6],
  8,rayon*2.5+15, 12)
  
pile(bo1[7],bo2[7],cent[7],
  4,rayon*2.5+65, 24)  