// buildings, walls and floors for ruincity.pov

#include "brickwall.inc" 
#include "flagstones.inc"
#include "DistantCity.inc"

#version unofficial MegaPov 0.4;

#declare Hill=
 union {
  height_field {
   tga "hills.tga"
   scale <750,20,80>
   rotate x*-2
   translate <-250,-7,600>
   pigment {BakersChoc}
  }
  height_field {
   tga "hills.tga"
   scale <-750,20,80>
   rotate x*-2
   translate <250,-14,500>
   pigment {BakersChoc}
  }
 }

#declare Base=
 height_field {
  pattern 200,200 { 
   hf_gray_16
   bozo 
   scale 0.18
   color_map {
    [0 rgb 0]
    [1 rgb 1]
   }
  }
  scale <25,0.5,25> 
 }

#declare CloseFlagStones =
 union {
  object {
   FlagStones (25,0.08,Base,1.5,FlagStoneTex) 
   translate <-10,0,-15> 
  }
  object {
   Base  
   pigment {Gray80}
   finish {
    diffuse 0.4
   }
   translate <-10,0,-15>
  }
 }
 
#declare Dust=
 box {
  <-10,-0.2,-20>,<15,0.85,6>
  pigment {Clear}  
  hollow
  interior {
   media {
    emission rgb <0.1,0.1,0.1>
    absorption <0.9,0.9,0.9>*1.5
    //scattering {1 rgb <0.2,0.2,0.2>*2 extinction 1}
    intervals 1
    samples 1, 1  
    method 3     
    confidence 1/256
    variance 0.99
    density {
    granite
     color_map {
      [0.0 rgbf <2,2,2,0>]
      [0.3 rgbf <2,2,2,0>]
      [1.0 rgbf <0.0,0.0,0.0,0>]
     }          
     scale 0.5
    }
    density {
     gradient y
     color_map {  
      [0.0 rgbt <0.55,0.55,0.55,0.4>]
      [0.15 rgbt <0.55,0.55,0.55,0.5>]
      [0.26 rgbt <0.4,0.4,0.4,0.6>]
      [0.28 rgbt <0,0,0,0>]
      [1.0 rgbt <0,0,0,0>]
     }
    }
   }
  }       
 }

#declare Dust2=
 box {
  <-10,-0.2,-20>,<15,1,6>
  pigment {Clear}
  hollow
  interior {
   media {
     emission rgb <0.5,0.5,0.5>
     absorption rgb <0.7,0.7,0.7>
     intervals 1 samples 15, 15
     confidence 0.99 variance 1/128
     method 3
     density {
        proximity {Base, 1
           samples 60
           max_density 1
           type 1//minimum distance
    //             method 0//point in BBox
           method 1//Always use random direction.
                   //Slower, but pretty fast because all
                   //points are prety close to Prox
           sides 1//Outside only
        }
        color_map {
           [0 color Black]
    //Since only the outside is being calculated, all points
    //inside the object are set to 0.
    //We want the color to range from 1 at the surface(distance 0)
    //to 0 as the distance increases, and the inside to be 0. That
    //is the reason for this short entry at the beginning of the
    //color_map.
           [0.01 color White] 
           [0.1 color White]
           [0.15 color Black]
        }
    }
   }
  }
 }
  
 
 #declare Road=
  box {
   <-100,-20,7>,<100,-0.2,41>
   pigment {Gray15} 
   finish {ambient 0.05 diffuse 0.4}
  }        
 
#declare Base=
 union {
  #declare HeightFieldNo=0;
  #while (HeightFieldNo<4)
   height_field {
    pattern 200,200 { 
     hf_gray_16
     bozo 
     scale 0.18
     color_map {
      [0 rgb 0]
      [1 rgb 1]
     }
    }
    scale <25,0.4,25>
    translate z*25*HeightFieldNo 
   }
   height_field {
    pattern 200,200 { 
     hf_gray_16
     bozo 
     scale 0.18
     color_map {
      [0 rgb 0]
      [1 rgb 1]
     }
    }
    scale <25,0.4,25>
    translate <25,0,25*HeightFieldNo> 
   }
   height_field {
    pattern 200,200 { 
     hf_gray_16
     bozo 
     scale 0.18
     color_map {
      [0 rgb 0]
      [1 rgb 1]
     }
    }
    scale <25,0.4,25>
    translate <50,0,25*HeightFieldNo> 
   }
   height_field {
    pattern 200,200 { 
     hf_gray_16
     bozo 
     scale 0.18
     color_map {
      [0 rgb 0]
      [1 rgb 1]
     }
    }
    scale <25,0.4,25>
    translate <100,0,25*HeightFieldNo> 
   }
   #declare HeightFieldNo=HeightFieldNo+1;
  #end
 }
  
#declare DistantFlagStones=
 union {
  object {
   FlagStones (80,0.1,Base,1.5,FlagStoneTex) 
   translate <-50,-0.15,40> 
  }              
  intersection {
   object {
    Base
    pigment {Gray40}
    translate <-50,-0.15,40>
   } 
   box {
    <-100,-10,30>,<100,0,100>
    pigment {Gray30}
   }
  }
 }
 
#declare RedWall=
 union {
  object {
   BrickWall(25,40,2,0.6,15,pigment{Firebrick},pigment{Firebrick3},texture{BrickTex},texture{Mortar})
   rotate y*-90
   translate <-4.2,0,-21>
  }
  intersection {
   box {
    <-5.5,0,-20>,<-4,40,4>
   }
   height_field {
    tga "plaster.tga"
    rotate <-90,-90,0>
    scale <0.15,15,15>
    translate <-4.32,0,-12>
   }      
   texture {
    pigment {Beige}
    finish {specular 0.5 roughness 0.1}  normal {granite 0.1 bump_size 0.11}
   }
  }
  union {
   box {
    <-20,0,-20>,<-4.2,40,3>
   }
   intersection {
    box {
     <-5.5,0,-20>,<-4.0,40,4>
    }
    height_field {
     tga "plaster.tga"
     rotate <-90,-90,0>
     scale <0.15,15,15>
     translate <-4.32,0,-12>
    }
   }
   scale <1.01,1,1> 
   translate x*0.06
   pigment {
    wrinkles
    color_map {
     [0.0 rgbt<0.2,0.2,0.2,0.2>]
     [0.6 rgbt<0.3,0.3,0.3,0.3>]
     [0.75 rgbt<0.4,0.4,0.4,0.4>]
     [1.0 rgbt<0.5,0.5,0.5,0.6>]
    }       
    turbulence 0.6
    translate x*5  
    //scale 0.1
   }
  }
 }
 
#declare BrownWall=
 union {
  #declare Windowx1=8;
  #declare Windowx2=9.5;
  #declare Windowy1=6;
  #declare Windowy2=10;
  object {
   BrickWall(25,20,1.8,0.5,15,pigment{Cornsilk4},pigment{Bisque3},texture{BrickTex2},texture{Mortar})
   rotate y*-90
   translate <9.8,0,-21>
  }
  difference {                          
   box {
    <9.6,0,-20>,<10.0,40,4>
   }
   box {
    <14.985,3.666,-1>,<19.928,6.291,3>
    rotate y*-90
    translate <9.8,0,-21>
   }
   texture {
    pigment {
     wrinkles
     color_map {
      [0.0 rgbt<0.2,0.2,0.2,0.2>]
      [0.2 rgbt<0.3,0.3,0.3,0.3>]
      [0.35 rgbt<0.4,0.4,0.4,0.4>]
      [1.0 rgbt<0.5,0.5,0.5,0.6>]
     }       
     turbulence 0.6 
     scale <1,5,1>
     translate x*5  
     //scale 0.1
    }
   }
  }
  #declare Windowx1=-1;
  #declare Windowx2=-1;
  #declare Windowy1=-1;
  #declare Windowy2=-1;
  object {
   BrickWall(3.5,20,1.8,0.5,15,pigment{Cornsilk4},pigment{Bisque3},texture{BrickTex2},texture{Mortar})
   translate <9.8,0,5>
  }
  object {
   BrickWall(11,4.8,1.8,0.5,15,pigment{Cornsilk4},pigment{Bisque3},texture{BrickTex2},texture{Mortar})
   translate <11.8,0,5>
  }
  box {
   <10,0,-40>,<50,20,-39>
   pigment {Black}
  }
 }

#declare Window=
 difference {
  union {
   box {
    <14.9,3.6,0.3>,<20,3.85,0.45>
   }
   box {
    <14.9,6.05,0.3>,<20,6.3,0.45>
   }                           
   box {
    <14.9,3.6,0.3>,<15.3,6.3,0.45>
   }
   box {
    <19.6,3.6,0.3>,<20,6.3,0.45>
   }
   box {
    <17.23,3.6,0.3>,<17.67,6.3,0.45>
   }  
  }
  union {
   box {
    <15.03,3.7,0.32>,<17.4,6.24,0.43>
   }
   box {
    <17.5,3.7,0.32>,<19.8,6.24,0.43> 
   }
  }
  pigment {White}
  rotate y*-90
  translate <9.8,0,-21>
 }
  
#declare Windowx1=1;
#declare Windowx2=2.5;
#declare Windowy1=2;
#declare Windowy2=5;

//#declare StaggeredLeft=1;  
//#declare UnevenStagger=1; 

#declare SecondTexture=1;
#declare LayerTexture=
 texture {
    pigment {
     wrinkles
     color_map {
      [0.0 rgbt<0.2,0.2,0.2,0.2>]
      [0.2 rgbt<0.3,0.3,0.3,0.3>]
      [0.35 rgbt<0.4,0.4,0.4,0.4>]
      [1.0 rgbt<0.5,0.5,0.5,0.6>]
     }       
     turbulence 0.6 
     scale <1,5,1>
     translate x*5  
     scale 1.5
    }
   }
   
#declare BrokenBuild1=
 union {                   
 
  #declare StaggeredRight=1;  
  #declare UnevenStagger=1;
  object {
   BrickWall(12,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
   //rotate y*90 
  }
  
  #declare StaggeredRight=0;  
  #declare UnevenStagger=0;
  #declare Start=<8.43,0,0>;
    
  object {
   BrickWall(12,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
   //rotate y*90 
  }
                              
  #declare Windowx1=1.5;
  #declare Windowx2=2.5;
  #declare Windowy1=0;
  #declare Windowy2=8;                              
  #declare Start=<16.9,0,0>;  
  
  object {
   BrickWall(12,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
   //rotate y*90 
  }
  
  #declare Windowx1=-1;
  #declare Windowx2=-1;
  #declare Windowy1=-1;
  #declare Windowy2=-1; 
  #declare Start=<0,5.9,0>;  
  
  object {
   BrickWall(12,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
   //translate y*0.17
   //rotate y*90 
  }
  
  #declare Start=<8.43,5.9,0>;  
  
  object {
   BrickWall(12,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
   //translate y*0.17
   //rotate y*90 
  }
  #declare Start=<16.9,5.9,0>;  
  #declare StaggeredRight=1;  
  #declare UnevenStagger=1;
  
  object {
   BrickWall(12,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
   //translate y*0.17
   //rotate y*90 
  }
 }    

#declare Stagger=seed(6825);
 
#declare BrokenBuild2=
 union {
  #declare Start=<25.42,0,0>;  
  #declare StaggeredRight=0;
  object {
   BrickWall(20,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
  }
  #declare Start=<25.42,5.9,0>;  
  #declare StaggeredLeft=1;
  object {
   BrickWall(20,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
  }
  translate x*-25.42
  rotate y*-90
  translate <27.42,0,1>
 }

#declare Start=<0,0,0>;  
#declare StaggeredLeft=0;

#declare BrokenBuild3=
 union {
  object {
   BrickWall(20,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
  } 
  #declare Start=<0,5.9,0>;  
  #declare StaggeredLeft=1;
  object {
   BrickWall(20,7.2,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
  }
  rotate y*-90
 } 

#declare BrokenBuild4=  
  #declare Start=<0,0,0>;  
  #declare StaggeredLeft=0;
 object {
  BrickWall(27,14.4,2,0.6,15,pigment{Coral5},pigment{DarkWood},texture{BrickTex},texture{Mortar})
  translate z*19
 }
 
#declare WoodPlank=
 box {
  <-3,-0.45,-0.05>,<3,0.45,0.05>
  texture {T_Wood2 rotate y*90}
 } 
  
#declare DistantBuilding=   
 union {
  difference {
   union {   
    object {BrokenBuild1 }
    object {BrokenBuild2}
    object {BrokenBuild3}
    object {BrokenBuild4}
   }
   box {
    <-5,10.1,-1>,<60,25,43>
    texture {Mortar}
   }
  }
  object {
   WoodPlank
   translate <4.5,1.5,0.8>
  }
  object {
   WoodPlank
   rotate z*-10
   translate <4.5,2.5,0.8>
  }
  object {
   WoodPlank
   rotate z*5
   translate <13,2.8,0.8>
  }
  object {
   WoodPlank
   rotate z*-5
   translate <13,1.5,0.8>
  }
  object {
   WoodPlank
   rotate z*-2
   translate <22,0.5,0>
  }
  object {
   WoodPlank
   translate <22,2.2,0>
  }
  object {
   WoodPlank
   rotate z*4
   translate <22,3.6,0>
  }
  object {
   WoodPlank
   rotate z*-6
   translate <22,5,0>
  }
  height_field {
   tga "junk.tga"
   scale <28.2,0.5,19.9>
   pigment { Gray15}
  } 
 }  

#declare Windowx1=2;
#declare Windowx2=4;
#declare Windowy1=0;
#declare Windowy2=12;  

#declare Start=<0,0,0>; 
          
#declare StaggeredLeft=0;
#declare StaggeredRight=0;
#declare UnevenStagger=1;        

#declare SecondTexture=1;

#declare BrokenBuild1a=
 union {       
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }    
  #declare Windowx1=2;
  #declare Windowx2=4;
  #declare Windowy1=0;
  #declare Windowy2=3;
  #declare Start=<0,5.75,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  #declare Windowx1=-1;
  #declare Windowx2=-1;
  #declare Windowy1=-1;
  #declare Windowy2=-1;       
  #declare Start=<12,0,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }       
  #declare Start=<12,5.75,0>; 
  #declare StaggeredRight=1; 
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }    
  #declare Start=<24,0,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }    
 }

#declare Stagger=seed(6825);
 
#declare BrokenBuild2a=
 union {
  #declare Start=<48,0,0>;  
  #declare StaggeredRight=0;
  object {
   BrickWall(20,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  } 
  #declare Start=<48,5.75,0>;
  #declare StaggeredLeft=1;
  object {
   BrickWall(20,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }      
  #declare Start=<36,0,0>;  
  #declare StaggeredLeft=1;
  object {
   BrickWall(20,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  translate x*-36
  rotate y*-90
  translate <38,0,1>
 } 

#declare StaggeredLeft=0;

#declare BrokenBuild3a=
 union {          
  #declare Start=<0,0,0>;  
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }    
  #declare Start=<0,5.75,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  #declare Start=<12,0,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }       
  #declare Start=<12,5.75,0>; 
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }    
  #declare Start=<24,0,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  #declare Start=<24,5.75,0>;
  object {
   BrickWall(15,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  translate z*30    
 }

#declare BrokenBuild4a=
 union {
  #declare Start=<12,0,0>;  
  object {
   BrickWall(20,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  } 
  #declare Start=<12,5.75,0>;
  object {
   BrickWall(20,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }      
  #declare Start=<0,0,0>;  
  object {
   BrickWall(20,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  #declare Start=<0,5.75,0>;  
  object {
   BrickWall(25,7.5,2,0.6,15,pigment{Brown5},pigment{Goldenrod5},texture{BrickTex},texture{Mortar})
  }
  rotate y*-90
 }

#declare DistantBuild2 =
 union {
  object {BrokenBuild1a} 
  object {BrokenBuild2a}
  object {BrokenBuild3a}
  object {BrokenBuild4a}
  box {
   <3.5,0,0.1>,<9.75,7.9,0.4>
   pigment {VeryDarkBrown}
  }
 }   
 
#declare Start=<0,0,0>;  
#declare Wall=
 object {
  BrickWall(26,7.8,2,0.6,15,pigment{LightYellow4},pigment{Snow4},texture{BrickTex},texture{Mortar})
  translate <-18,-1,100>
 }
 
#declare DamageObj=
 height_field {
  tga "damage2.tga" 
  scale <1,3,1>
 }

//DistantCity (NoOfBuildings,AverageHeight,HeightVarience,AverageSize,SizeVarience,DamagedPercentage,DamageObject,BuildingsbetweenRoadsX,BuildingsbetweenRoadsZ,AverageRoad,RoadVarience)

#declare City=
 object {
  DistantCity (20,70,25,20,5,0.9,DamageObj,2,4,12,5)  
  uv_mapping
  pigment {
   image_map {
    tga "CityTex.tga"
   }         
   scale 800
  }
  rotate y*10   
  translate <-330,-2,800>
 }

#declare SingleGate=
 union {                         
  isosurface {  
    function{(sqrt(sqr(sqrt(sqr(x)+sqr(z))-0.85)+sqr(y)) -0.15)+noise3d(x*8,y*8,z*8)*0.04 }
    contained_by { box { <-1,-0.18,-1>, <1, 0.18, 0> } } 
    rotate x*90    
    scale <2,1.8,2>       
    translate y*1.8
   }             
  isosurface {
   function {x^2+z^2 +noise3d(x*4,y*4,z*4)*0.02} 
   threshold 0.08
   contained_by {
    box {
     <-1,-2,-1>,<1,2,1>
    }
   }
   translate x*-0.85*2
  } 
  isosurface {
   function {x^2+z^2 +noise3d(x*4+32,y*4+74,z*4+9)*0.02} 
   threshold 0.08
   contained_by {
    box {
     <-1,-2,-1>,<1,2,1>
    }
   }
   translate x*0.85*2
  } 
  isosurface {
   function {y^2+z^2 +noise3d(x*4,y*4,z*4)*0.04}
   threshold 0.05
   contained_by {
    box {
     <-0.75,-0.2,-0.2>,<0.75,0.2,0.2>
    }
   }
   scale <2,0.5,0.5>
   translate y*-2
  } 
  isosurface {
   function {y^2+z^2 +noise3d(x*4,y*4,z*4)*0.04}
   threshold 0.05
   contained_by {
    box {
     <-0.75,-0.2,-0.2>,<0.75,0.2,0.2>
    }
   }
   scale <2,0.5,0.5> 
   translate y*0.5
  }
  isosurface {  
   function {x^2+z^2 +noise3d(x*4,y*4,z*4)*0.04}
   threshold 0.05
   contained_by {
    box {
     <-0.2,-1.5,-0.2>,<0.2,1.5,0.2>
    }
   }
   scale <0.5,1.5,0.5>              
   translate y*0.2
  }  
  isosurface {  
   function {x^2+z^2 +noise3d(x*4+52,y*4+3,z*4+2)*0.04}
   threshold 0.05
   contained_by {
    box {
     <-0.2,-1.5,-0.2>,<0.2,1.5,0.2>
    }
   }
   scale <0.5,1.4,0.5>              
   translate <0.8,0.1,0>
  }
  isosurface {  
   function {x^2+z^2 +noise3d(x*4+25,y*4,z*4+68)*0.04}
   threshold 0.05
   contained_by {
    box {
     <-0.2,-1.5,-0.2>,<0.2,1.5,0.2>
    }
   }
   scale <0.5,1.4,0.5>              
   translate <-0.8,0.1,0>
  }
 }
 
#declare GatePost = 
 box {
  <0,-2.5,0>,<1,2.5,1>
  uv_mapping
  pigment {
   image_map {
    png "stonewall.png"
   }
   scale <1.5,1,1>*2
  }
 }
 
