// Persistence of Vision Ray Tracer Scene Description File
// File: ruincity.inc
// Vers: 3.14159
// Desc: Textures for the ruined city
// Date: 6 Jan 2000 
// Auth: Gail Shaw

#version unofficial MegaPov 0.4;

#declare Mortar=   
 texture {
  pigment {rgb <0.9,0.9,1>}
  finish { ambient 0.15
           diffuse 0.45
           specular 0.1
           roughness 0.35
           crand 0.2
         }
 }

#declare BrickTex=
 texture {
  finish {specular 0.3 roughness 0.2}
  normal {granite 0.1 bump_size 0.3 scale 0.2}
 } 
 
#declare BrickTex2=
 texture {
  finish {ambient 0.1 diffuse 0.3}
  normal {granite 0.1 bump_size 0.1 scale 0.2}
 }
             
#declare FlagStoneTex = 
 texture {      
  pigment {
   granite
   color_map {
    [0.0  rgb <0.5, 0.5, 0.5> ]
    [0.25 rgb <0.65, 0.65, 0.65> ]
    [0.5  rgb <0.5, 0.5, 0.5> ]
    [0.75 rgb <0.7, 0.7, 0.7> ]
    [1.0  rgb <0.5, 0.5, 0.5> ]
   }
   frequency 100
  }      
  normal {
   crackle 0.5
   turbulence 0.5
  }      
  finish {
   specular 0.1
   roughness 0.2
  }      
  scale 0.25
 }
 texture {
  pigment {
   wrinkles
   color_map {
    [0.0 rgbt<0.2,0.2,0.2,0.2>]
    [0.6 rgbt<0.3,0.3,0.3,0.4>]
    [0.75 rgbt<0.4,0.4,0.4,0.5>]
    [1.0 rgbt<0.5,0.5,0.5,0.7>]
   }       
   turbulence 0.6
   translate x*5  
   //scale 0.1
  }
 }

// from glass.inc

#declare T_Glass1 =
 texture {
  pigment { color rgbf<0.99, 0.99, 0.99, 0.7> }
  finish {
   specular 1
   roughness 0.001
   ambient 0
   diffuse 0
   reflection 0.1
  }
  normal {
   granite
   bump_size 0.2
   scale 0.2
  }
}

#declare T_Glass1a =
 texture {
  pigment { color rgbf<0.9, 0.9, 0.9, 0.5> }
  finish {
   specular 0.7
   roughness 0.001
   ambient 0
   diffuse 0
   reflection 0.08
  }
  normal {
   granite
   bump_size 0.2
   scale 0.2
  }
}  

// modified version of the one in metals.inc

#declare T_Chrome_2B = 
 texture { 
  pigment { rgb <0.39, 0.41, 0.43> } 
  finish { 
   ambient 0.10
   brilliance 3
   diffuse 0.4
   metallic
   specular 0.50
   roughness 1/60
   reflection 0.15
  }
  normal {
   dents
   bump_size 4
   scale 0.5
   turbulence 0.4
  } 
 }

// from woods.inc

#declare P_WoodGrain2A =
pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.15, .15, 1>
}

#declare P_WoodGrain2B =
pigment {
    wood  
    turbulence <0.1, 0.35, 0.1>
    octaves 5
    lambda 3.25
    scale <0.25, .25, 1>
    rotate <5, 10, 5>
    translate -x*2
}  

#declare T_Wood2   =
    texture { 
     pigment { 
      P_WoodGrain2A  
      color_map { 
          [0.0, 0.1 color rgb <0.35, 0.16, 0.12 >* 0.5
                    color rgb <0.35, 0.16, 0.12>* 0.5]
          [0.1, 0.9 color rgb <0.35, 0.20, 0.16>* 0.5
                    color rgb <0.46, 0.26, 0.18>* 0.5]
          [0.9, 1.0 color rgb <0.46, 0.26, 0.18>* 0.5
                    color rgb <0.35, 0.16, 0.12>* 0.5]
      }
     }
    }
    texture { 
     pigment { 
      P_WoodGrain2B  
      color_map { 
          [0.0, 0.1 color rgbf <0.50, 0.30, 0.20, 0.100> 
                    color rgbf <0.50, 0.30, 0.20, 0.500>]
          [0.1, 0.9 color rgbf <0.50, 0.30, 0.20, 0.650>
                    color rgbf <0.50, 0.25, 0.15, 0.975>]
          [0.9, 1.0 color rgbf <0.50, 0.25, 0.15, 0.975>
                    color rgbf <0.50, 0.30, 0.20, 0.000>]
      }
     }
    }


#declare Rust_Tex = 
 texture {
  pigment{
   bumps 
   color_map {
  	[0.000000 color rgbt <0.113636, 0.113636, 0.113636, 0.000000>]
  	[0.243924 color rgbt <0.395047, 0.243284, 0.147405, 0.000000>]
  	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
  	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
  	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
  	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
  	[0.493990 color rgbt <0.676458, 0.372932, 0.181175, 0.000000>]
  	[0.747913 color rgbt <0.838229, 0.447461, 0.200587, 0.000000>]
  	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
  	[0.777963 color rgbt <1.000000, 0.521990, 0.220000, 0.000000>]
  	[0.854667 color rgbt <0.602272, 0.321683, 0.133005, 0.000000>]
  	[1.000000 color rgbt <0.204545, 0.121376, 0.046011, 0.000000>]
   }
   turbulence 1.2
  }
  normal {
   bumps 
   normal_map{
    [0.2 bumps turbulence 1.1 scale 0.01]
    [0.8 granite turbulence 0.1]
   }
  }
 }
 
// from metals.inc

#declare PipeTex=
 texture {
  wrinkles
  texture_map {
   [0.0 Rust_Tex]
   [0.5 Rust_Tex] 
   [0.7 T_Chrome_3B]
   [1.0 T_Chrome_3B]
  }
 }
 
#declare Bumpfunc=
 function {
  pigment{
   granite 
   color_map {
    [0.0 Gray30]
    [1.0 Gray80]
   }
   //scale 5
  }
 }
 
#declare RedPlastic = 
 texture {      
  pigment {
   rgb <0.501961, 0.0, 0.0>
  }      
  finish {
   ambient 0.1
   diffuse 0.294933
   phong 0.503567
  }
 }
 texture {
  pigment {
    wrinkles
    color_map {
     [0.0 rgbt<0.2,0.2,0.2,0.2>]
     [0.6 rgbt<0.3,0.3,0.3,0.3>]
     [0.75 rgbt<0.4,0.4,0.4,0.4>]
     [1.0 rgbt<0.5,0.5,0.5,0.6>]
    }       
    turbulence 0.6
    translate x*5  
    scale 0.5
   }
 }

#declare DullBlackPlastic = 
 texture {      
  pigment {
   rgb <0.0, 0.0, 0.0>
  }      
  finish {
   ambient 0.0863
   diffuse 0.388467
   brilliance 0.075
   phong 0.136667
   phong_size 19.866667
  }
 }

#declare Chrome_Textur1 = 
 texture {      
  pigment {
   rgb <0.658824, 0.658824, 0.658824>
  }      
  finish {
   ambient 0.3
   diffuse 0.7
   brilliance 8.0
   specular 0.8
   roughness 0.1
   metallic 1.0
   reflection 0.15
  }
 }

#declare Chrome_Metal_3 = 
 texture {      
  pigment {
   rgb <0.854902, 0.854902, 0.854902>
  }      
  finish {
   ambient 0.3
   diffuse 0.0
   brilliance 20.0
   phong 1.0
   phong_size 90.0
   specular 1.0
   roughness 0.001
   reflection 1.0
  }
 }

#declare MetallicOrange = 
  texture {      
   pigment {
    rgb <1.0, 0.501961, 0.0>
   }      
   finish {
    ambient 0.1
    phong 1.0
    phong_size 80.13
    metallic 1.0
    reflection 1.0
   }
  }
 
#declare colBark=rgb <1,0.8,0.51>*0.8; // dirty brown
#declare txtTree=texture{pigment{crackle turbulence 0.4 lambda 3.2 color_map{[0 color colBark*.3][0.1 color colBark*.4][0.6 color colBark*.8] [1 color colBark*1.2]}}       
finish{ambient 0.1} scale <0.2,0.7,0.2>*1} 