// Persistence of Vision Ray Tracer Scene Description File
// File: teddy.inc
// Vers: 3.14159
// Desc: Teddy bear made from blobs 
// Date: 19 Feb 2000                   
// Auth: Gail Shaw

#version unofficial MegaPov 0.4;
#declare DarkBrown = rgb <0.3600, 0.2500, 0.2000>;
#include "fur.inc"

// head

#declare Teddy=
 union {
  blob {    
   sphere {
    <0,0,0>,2,2
   }
   sphere {
    <1.25,-0.25,0>,0.4,2
    scale <0.8,1,1.3>
   }
   sphere {
    <1,0.3,-0.4>,0.1,-0.8
   }
   sphere {
    <1,0.3,0.4>,0.1,-0.8
   }                    
   scale 0.95
   pigment {DarkBrown}  
   rotate y*90
  }   
  
  // ear
  
  blob {
   sphere {
    <0.6,0.5,-0.5>,0.3,5
   }
   sphere {
    <0.75,0.5,-0.5>,0.18,-3.5
   }
   scale <0.5,1,1>*1.6
   pigment {DarkBrown} 
   rotate y*90
  } 
  
  blob {
   sphere {
    <0.6,0.5,0.5>,0.3,5
   }
   sphere {
    <0.75,0.5,0.5>,0.18,-3.5
   }
   scale <0.5,1,1>*1.6
   pigment {DarkBrown} 
   rotate y*90
  }
  
  // body
  
  blob {
   sphere {
    <0,-1.6,0>,1.8,3
    scale <1,1.15,1>
   } 
   cylinder {
    <-0.01,-2.8,-0.6>,<1.2,-2.85,-0.6>,0.5,5
   } 
   cylinder {
    <-0.01,-2.8,0.6>,<1.2,-2.85,0.6>,0.5,5
   }
   cylinder {
    <-0.2,-1.1,-0.95>,<0.5,-1.55,-1.25>,0.3,5
   }
   cylinder {
    <0.5,-1.55,-1.25>,<1.4,-1.7,-1.3>,0.28,5
   }
   cylinder {
    <-0.2,-1.1,0.95>,<0.5,-1.55,1.25>,0.3,5
   }
   cylinder {
    <0.5,-1.55,1.25>,<1.4,-1.7,1.3>,0.28,5
   }
   pigment {DarkBrown}
   rotate y*90
  }
  
 } 
  
#declare HalfTorus=
 difference {
  torus {
   0.15,0.02
  }
  box {
   <-0.3,-0.03,-0.3>,<0.3,0.03,0>
  }
  box {
   <0.3,-0.03,-0.3>,<0,0.03,0.3>
  }
 }
 
#declare TPos=array[3]{<0,-1,-5>,<0,5,-10>,<20,5,0>}

#declare Bear=
 union {
  object{
      Fur(
          Teddy, <50,65,50>, 2, //Sampling options
          3, 0.2, 0.1, 0.01,  //Length and thickness options
          -y, .3, .1,         //Bend and twist options
          0, "furtemp.o",     //Object file output
          0, "furtemp.p",     //Point file output
          0, TPos, 115,       //Culling options
          12345               //Random number seed
          )
      pigment{DarkBrown}    
  } 
  object {Teddy}
  union {         
   sphere {
    <0.85,0.3,-0.35>,0.085
   } 
   sphere {
    <0.85,0.3,0.35>,0.085
   }
   sphere {
    <1.15,-0.1,0>,0.1
   }
   pigment {rgb <0,0,0>}
   finish {
    specular 1 roughness 0.005
   }
   rotate y*90   
  }
  union {
   object {
    HalfTorus 
    rotate z*63
    //rotate z*-30 
    translate <1.19,-0.3,-0.15>
    pigment {rgb <1,0.7,0.7>} 
   }   
   object {
    HalfTorus 
    rotate z*63 
    scale <1,1,-1>
    //rotate z*-30 
    translate <1.19,-0.3,0.15>
    pigment {rgb <1,0.7,0.7>} 
   }
   rotate y*90        
  } 
 }
 
  