//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 1 lights, 6 materials and 178 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1991-1999 Lutz + Kretzschmar
//

//  Date : 01/06/2000    (06.01.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            400
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 0    // none
  distance     80.0
  color <0.862745,0.0,1.0,0.0,0.0>
  turbulence   <100.0,100.0,100.0>
    omega      0.5
    lambda     2.0
    octaves    6
    turb_depth 150.0
}

camera {  //  Camera StdCam
  location  <    -15.330,     -13.420,      14.040>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35289,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         35.57330    // Vertical      26.680
  look_at   <      0.000,       0.000,       0.000>
}

//
// *******  L I G H T S *******
//

light_source {   // Light1
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <0.0, -20.0, 20.0>
}

#declare EngineLight1 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>
  translate  <0.0, -2.57, 0.85>
}

#declare EngineLight2 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>
  translate  <-0.98, -2.56, 0.06>
}

#declare EngineLight3 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>
  translate  <1.03, -2.55, 0.06>
}

#declare EngineLight4 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>
  translate  <0.01, -2.56, -0.94>
}


//
// ********  MATERIALS  *******
//

#include "alien ruins.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Torus120 = object {
  torus { // Torus120
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}
#declare Torus140 = object {
  torus { // Torus140
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}
#declare Torus100 = object {
  torus { // Torus100
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}


#declare Torus001 = object {
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}


#declare Torus040 = object {
  torus { // Torus040
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}


#declare Torus060 = object {
  torus { // Torus060
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}


#declare Torus080 = object {
  torus { // Torus080
    1.5, 0.5  rotate -x*90
    material {
      Torus_Texture
    }
  }
}




//
// ********  OBJECTS  *******
//

#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <-15.330, -13.420, 14.040>;  // using camera 'StdCam'
#declare lookat = <0.000, 0.000, 0.000>;
#declare light_loc = <-3.85000, -7.84000, 5.91000>;  // using light source 'EngineLight1'

#declare flare_size = 0.500;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sports.flr"
#include "NKFlare\nkflare.inc"


#declare CSG011 = union {
  object { // Torus101->Torus120
    Torus120
    translate  19.0*z
  }
  object { // Torus102->Torus120
    Torus120
    translate  18.0*z
  }
  object { // Torus103->Torus120
    Torus120
    translate  17.0*z
  }
  object { // Torus104->Torus120
    Torus120
    translate  16.0*z
  }
  object { // Torus105->Torus120
    Torus120
    translate  15.0*z
  }
  object { // Torus106->Torus120
    Torus120
    translate  14.0*z
  }
  object { // Torus107->Torus120
    Torus120
    translate  13.0*z
  }
  object { // Torus108->Torus120
    Torus120
    translate  12.0*z
  }
  object { // Torus109->Torus120
    Torus120
    translate  11.0*z
  }
  object { // Torus110->Torus120
    Torus120
    translate  10.0*z
  }
  object { // Torus111->Torus120
    Torus120
    translate  9.0*z
  }
  object { // Torus112->Torus120
    Torus120
    translate  8.0*z
  }
  object { // Torus113->Torus120
    Torus120
    translate  7.0*z
  }
  object { // Torus114->Torus120
    Torus120
    translate  6.0*z
  }
  object { // Torus115->Torus120
    Torus120
    translate  5.0*z
  }
  object { // Torus116->Torus120
    Torus120
    translate  4.0*z
  }
  object { // Torus117->Torus120
    Torus120
    translate  3.0*z
  }
  object { // Torus118->Torus120
    Torus120
    translate  2.0*z
  }
  object { // Torus119->Torus120
    Torus120
    translate  1.0*z
  }
  object { Torus120 }
}
#declare CSG012 = union {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG011 }
  no_shadow
  rotate <94.266335, -77.917419, -106.221458>
  translate  <41.65, 38.08, -16.03>
}
#declare CSG013 = union {
  object { // Torus121->Torus140
    Torus140
    translate  19.0*z
  }
  object { // Torus122->Torus140
    Torus140
    translate  18.0*z
  }
  object { // Torus123->Torus140
    Torus140
    translate  17.0*z
  }
  object { // Torus124->Torus140
    Torus140
    translate  16.0*z
  }
  object { // Torus125->Torus140
    Torus140
    translate  15.0*z
  }
  object { // Torus126->Torus140
    Torus140
    translate  14.0*z
  }
  object { // Torus127->Torus140
    Torus140
    translate  13.0*z
  }
  object { // Torus128->Torus140
    Torus140
    translate  12.0*z
  }
  object { // Torus129->Torus140
    Torus140
    translate  11.0*z
  }
  object { // Torus130->Torus140
    Torus140
    translate  10.0*z
  }
  object { // Torus131->Torus140
    Torus140
    translate  9.0*z
  }
  object { // Torus132->Torus140
    Torus140
    translate  8.0*z
  }
  object { // Torus133->Torus140
    Torus140
    translate  7.0*z
  }
  object { // Torus134->Torus140
    Torus140
    translate  6.0*z
  }
  object { // Torus135->Torus140
    Torus140
    translate  5.0*z
  }
  object { // Torus136->Torus140
    Torus140
    translate  4.0*z
  }
  object { // Torus137->Torus140
    Torus140
    translate  3.0*z
  }
  object { // Torus138->Torus140
    Torus140
    translate  2.0*z
  }
  object { // Torus139->Torus140
    Torus140
    translate  1.0*z
  }
  object { Torus140 }
}
#declare CSG014 = union {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG013 }
  no_shadow
  rotate <94.266335, -77.917419, -106.221458>
  translate  <70.99, 31.83, -15.56>
}
#declare CSG009 = union {
  object { // Torus081->Torus100
    Torus100
    translate  19.0*z
  }
  object { // Torus082->Torus100
    Torus100
    translate  18.0*z
  }
  object { // Torus083->Torus100
    Torus100
    translate  17.0*z
  }
  object { // Torus084->Torus100
    Torus100
    translate  16.0*z
  }
  object { // Torus085->Torus100
    Torus100
    translate  15.0*z
  }
  object { // Torus086->Torus100
    Torus100
    translate  14.0*z
  }
  object { // Torus087->Torus100
    Torus100
    translate  13.0*z
  }
  object { // Torus088->Torus100
    Torus100
    translate  12.0*z
  }
  object { // Torus089->Torus100
    Torus100
    translate  11.0*z
  }
  object { // Torus090->Torus100
    Torus100
    translate  10.0*z
  }
  object { // Torus091->Torus100
    Torus100
    translate  9.0*z
  }
  object { // Torus092->Torus100
    Torus100
    translate  8.0*z
  }
  object { // Torus093->Torus100
    Torus100
    translate  7.0*z
  }
  object { // Torus094->Torus100
    Torus100
    translate  6.0*z
  }
  object { // Torus095->Torus100
    Torus100
    translate  5.0*z
  }
  object { // Torus096->Torus100
    Torus100
    translate  4.0*z
  }
  object { // Torus097->Torus100
    Torus100
    translate  3.0*z
  }
  object { // Torus098->Torus100
    Torus100
    translate  2.0*z
  }
  object { // Torus099->Torus100
    Torus100
    translate  1.0*z
  }
  object { Torus100 }
}
#declare CSG010 = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG009 }
  no_shadow
  rotate <94.266335, -77.917419, -106.221458>
  translate  <12.35, 44.4, -16.51>
}
union { // CSG015
  object { CSG012 }
  object { CSG014 }
  object { CSG010 }
  translate  <6.12, -13.95, -6.35>
}


sphere { // Sphere001
  <0,0,0>,1
  material {
    Starfield
  }
  hollow
  scale 77.5
}


#declare CSG001 = union {
  object { // Torus020->Torus001
    Torus001
    translate  19.0*z
  }
  object { // Torus019->Torus001
    Torus001
    translate  18.0*z
  }
  object { // Torus018->Torus001
    Torus001
    translate  17.0*z
  }
  object { // Torus017->Torus001
    Torus001
    translate  16.0*z
  }
  object { // Torus016->Torus001
    Torus001
    translate  15.0*z
  }
  object { // Torus015->Torus001
    Torus001
    translate  14.0*z
  }
  object { // Torus014->Torus001
    Torus001
    translate  13.0*z
  }
  object { // Torus013->Torus001
    Torus001
    translate  12.0*z
  }
  object { // Torus012->Torus001
    Torus001
    translate  11.0*z
  }
  object { // Torus011->Torus001
    Torus001
    translate  10.0*z
  }
  object { // Torus010->Torus001
    Torus001
    translate  9.0*z
  }
  object { // Torus009->Torus001
    Torus001
    translate  8.0*z
  }
  object { // Torus008->Torus001
    Torus001
    translate  7.0*z
  }
  object { // Torus007->Torus001
    Torus001
    translate  6.0*z
  }
  object { // Torus006->Torus001
    Torus001
    translate  5.0*z
  }
  object { // Torus005->Torus001
    Torus001
    translate  4.0*z
  }
  object { // Torus004->Torus001
    Torus001
    translate  3.0*z
  }
  object { // Torus003->Torus001
    Torus001
    translate  2.0*z
  }
  object { // Torus002->Torus001
    Torus001
    translate  1.0*z
  }
  object { Torus001 }
}
union { // CSG002
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG001 }
  no_shadow
  rotate <-29.510818, 3.840966, -75.489182>
  translate  <-7.5, -11.23, -7.11>
}




#declare CSG003 = union {
  object { // Torus021->Torus040
    Torus040
    translate  19.0*z
  }
  object { // Torus022->Torus040
    Torus040
    translate  18.0*z
  }
  object { // Torus023->Torus040
    Torus040
    translate  17.0*z
  }
  object { // Torus024->Torus040
    Torus040
    translate  16.0*z
  }
  object { // Torus025->Torus040
    Torus040
    translate  15.0*z
  }
  object { // Torus026->Torus040
    Torus040
    translate  14.0*z
  }
  object { // Torus027->Torus040
    Torus040
    translate  13.0*z
  }
  object { // Torus028->Torus040
    Torus040
    translate  12.0*z
  }
  object { // Torus029->Torus040
    Torus040
    translate  11.0*z
  }
  object { // Torus030->Torus040
    Torus040
    translate  10.0*z
  }
  object { // Torus031->Torus040
    Torus040
    translate  9.0*z
  }
  object { // Torus032->Torus040
    Torus040
    translate  8.0*z
  }
  object { // Torus033->Torus040
    Torus040
    translate  7.0*z
  }
  object { // Torus034->Torus040
    Torus040
    translate  6.0*z
  }
  object { // Torus035->Torus040
    Torus040
    translate  5.0*z
  }
  object { // Torus036->Torus040
    Torus040
    translate  4.0*z
  }
  object { // Torus037->Torus040
    Torus040
    translate  3.0*z
  }
  object { // Torus038->Torus040
    Torus040
    translate  2.0*z
  }
  object { // Torus039->Torus040
    Torus040
    translate  1.0*z
  }
  object { Torus040 }
}
union { // CSG004
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG003 }
  no_shadow
  rotate <-29.510818, 3.840966, 29.510818>
  translate  <-2.56, 4.06, -11.5>
}


#declare CSG005 = union {
  object { // Torus041->Torus060
    Torus060
    translate  19.0*z
  }
  object { // Torus042->Torus060
    Torus060
    translate  18.0*z
  }
  object { // Torus043->Torus060
    Torus060
    translate  17.0*z
  }
  object { // Torus044->Torus060
    Torus060
    translate  16.0*z
  }
  object { // Torus045->Torus060
    Torus060
    translate  15.0*z
  }
  object { // Torus046->Torus060
    Torus060
    translate  14.0*z
  }
  object { // Torus047->Torus060
    Torus060
    translate  13.0*z
  }
  object { // Torus048->Torus060
    Torus060
    translate  12.0*z
  }
  object { // Torus049->Torus060
    Torus060
    translate  11.0*z
  }
  object { // Torus050->Torus060
    Torus060
    translate  10.0*z
  }
  object { // Torus051->Torus060
    Torus060
    translate  9.0*z
  }
  object { // Torus052->Torus060
    Torus060
    translate  8.0*z
  }
  object { // Torus053->Torus060
    Torus060
    translate  7.0*z
  }
  object { // Torus054->Torus060
    Torus060
    translate  6.0*z
  }
  object { // Torus055->Torus060
    Torus060
    translate  5.0*z
  }
  object { // Torus056->Torus060
    Torus060
    translate  4.0*z
  }
  object { // Torus057->Torus060
    Torus060
    translate  3.0*z
  }
  object { // Torus058->Torus060
    Torus060
    translate  2.0*z
  }
  object { // Torus059->Torus060
    Torus060
    translate  1.0*z
  }
  object { Torus060 }
}
union { // CSG006
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG005 }
  no_shadow
  rotate <-66.482178, 21.545097, 41.00724>
  translate  <20.74, 3.44, -5.98>
}


#declare CSG007 = union {
  object { // Torus061->Torus080
    Torus080
    translate  19.0*z
  }
  object { // Torus062->Torus080
    Torus080
    translate  18.0*z
  }
  object { // Torus063->Torus080
    Torus080
    translate  17.0*z
  }
  object { // Torus064->Torus080
    Torus080
    translate  16.0*z
  }
  object { // Torus065->Torus080
    Torus080
    translate  15.0*z
  }
  object { // Torus066->Torus080
    Torus080
    translate  14.0*z
  }
  object { // Torus067->Torus080
    Torus080
    translate  13.0*z
  }
  object { // Torus068->Torus080
    Torus080
    translate  12.0*z
  }
  object { // Torus069->Torus080
    Torus080
    translate  11.0*z
  }
  object { // Torus070->Torus080
    Torus080
    translate  10.0*z
  }
  object { // Torus071->Torus080
    Torus080
    translate  9.0*z
  }
  object { // Torus072->Torus080
    Torus080
    translate  8.0*z
  }
  object { // Torus073->Torus080
    Torus080
    translate  7.0*z
  }
  object { // Torus074->Torus080
    Torus080
    translate  6.0*z
  }
  object { // Torus075->Torus080
    Torus080
    translate  5.0*z
  }
  object { // Torus076->Torus080
    Torus080
    translate  4.0*z
  }
  object { // Torus077->Torus080
    Torus080
    translate  3.0*z
  }
  object { // Torus078->Torus080
    Torus080
    translate  2.0*z
  }
  object { // Torus079->Torus080
    Torus080
    translate  1.0*z
  }
  object { Torus080 }
}
union { // CSG008
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Cylinder_Texture
    }
    scale <0.5, 0.5, 30.0>
    translate  -4.91*z
  }
  object { CSG007 }
  no_shadow
  rotate <-52.407295, -107.666832, 86.473564>
  translate  <17.21, 32.09, -6.77>
}


#declare CSG016 = merge {
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <1.37, -1.01, 0.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      Blue_Texture
    }
    scale <0.02, 0.4, 0.15>
    translate  <1.37, -0.51, 0.0>
  }
  translate  <-1.37, 0.49, 1.55>
}
#declare Engines = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.1, 0.4, 0.4>
    rotate 90.0*z
    translate  <0.01, -2.5, 0.9>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.1, 0.4, 0.4>
    rotate 90.0*z
    translate  <-0.97, -2.5, 0.03>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale <0.1, 0.4, 0.4>
    rotate 90.0*z
    translate  <1.03, -2.5, 0.03>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale <0.1, 0.4, 0.4>
    rotate 90.0*z
    translate  <0.01, -2.47, -0.88>
  }
  object { EngineLight1 }
  object { EngineLight2 }
  object { EngineLight3 }
  object { EngineLight4 }
  material {
    Engine_Texture
  }
  translate  -0.01*y
}
#declare Fin_1 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-2.00939, 0.00939>,
  <-1.449139, -0.514867>,
  <2.017214, 0.00626>,
  <-1.516432, 0.530516>,
  <-2.00939, 0.00939>
  rotate <90,0,90>
  scale <0.275, 0.275, 1.1>
  rotate <180.0, 0.0, -0.0>
  translate  <0.0, 0.01, 1.64>
}
#declare Fin_2 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-2.00939, 0.00939>,
  <-1.449139, -0.514867>,
  <2.017214, 0.00626>,
  <-1.516432, 0.530516>,
  <-2.00939, 0.00939>
  rotate <90,0,90>
  scale <0.275, 0.275, 1.1>
  rotate <180.0, 90.0, 0.0>
  translate  <1.55, -0.02, 0.05>
}
#declare Fin_3 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-2.00939, 0.00939>,
  <-1.449139, -0.514867>,
  <2.017214, 0.00626>,
  <-1.516432, 0.530516>,
  <-2.00939, 0.00939>
  rotate <90,0,90>
  scale <0.275, 0.275, 1.1>
  rotate <-0.0, 0.0, 180.0>
  translate  <0.02, -0.04, -1.47>
}
#declare Fin_4 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-2.00939, 0.00939>,
  <-1.449139, -0.514867>,
  <2.017214, 0.00626>,
  <-1.516432, 0.530516>,
  <-2.00939, 0.00939>
  rotate <90,0,90>
  scale <0.275, 0.275, 1.1>
  rotate <180.0, -90.0, 0.0>
  translate  <-1.57, 0.0, 0.05>
}
#declare Engine_Senction = difference {
  superellipsoid { // SuperQ002
    <1.0, 3.0>
    scale 2.1
    rotate -90.0*x
    translate  <0.0, -2.51, 0.09>
  }
  plane { // Plane001
    z,0
    rotate -90.0*x
    translate  <0.0, -2.5, 0.14>
  }
}
#declare CSG017 = intersection {
  object { Engine_Senction }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 3.0>
    rotate 90.0*x
    translate  <0.08, -0.89, -0.05>
  }
}
#declare CSG018 = union {
  superellipsoid { // Main_Section
    <1.0, 2.0>
    rotate <-90.0, -0.0, 0.0>
    translate  0.1*z
  }
  object { Fin_1 }
  object { Fin_2 }
  object { Fin_3 }
  object { Fin_4 }
  object { CSG017 }
  material {
    Aluminum
  }
}
#declare CSG019 = merge {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <1.37, -1.01, 0.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      Blue_Texture
    }
    scale <0.02, 0.4, 0.15>
    translate  <1.37, -0.51, -0.01>
  }
  translate  <-1.37, 0.49, -1.37>
}
#declare CSG020 = merge {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <1.37, -1.01, 0.0>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      Blue_Texture
    }
    scale <0.02, 0.4, 0.15>
    translate  <1.37, -0.51, 0.01>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <-1.36, 0.53, 0.03>
  rotate <0.0, 90.0, 0.0>
  translate  <1.42, -0.06, 0.06>
}
#declare CSG021 = merge {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <0.1, 0.1, 1.0>
    rotate -90.0*x
    translate  <1.37, -1.01, 0.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      Blue_Texture
    }
    scale <0.02, 0.4, 0.15>
    translate  <1.37, -0.51, -0.01>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <-1.36, 0.53, 0.03>
  rotate <0.0, 90.0, 0.0>
  translate  <-1.51, -0.06, 0.1>
}
union { // Ship
  object { CSG016 }
  object { Engines }
  object { CSG018 }
  object { CSG019 }
  object { CSG020 }
  object { CSG021 }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      Blue_Texture
    }
    scale 0.1
    translate  <-0.01, 0.89, 0.11>
  }
  translate  <-3.85, -5.26, 5.06>
}


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <-15.330, -13.420, 14.040>;  // using camera 'StdCam'
#declare lookat = <0.000, 0.000, 0.000>;
#declare light_loc = <-4.83000, -7.83000, 5.12000>;  // using light source 'EngineLight2'

#declare flare_size = 0.500;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sports.flr"
#include "NKFlare\nkflare.inc"


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <-15.330, -13.420, 14.040>;  // using camera 'StdCam'
#declare lookat = <0.000, 0.000, 0.000>;
#declare light_loc = <-2.82000, -7.82000, 5.12000>;  // using light source 'EngineLight3'

#declare flare_size = 0.500;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sports.flr"
#include "NKFlare\nkflare.inc"


#declare sky_vect = <0.00000, 0.00000, 1.00000>;
#declare cam_loc = <-15.330, -13.420, 14.040>;  // using camera 'StdCam'
#declare lookat = <0.000, 0.000, 0.000>;
#declare light_loc = <-3.84000, -7.83000, 4.12000>;  // using light source 'EngineLight4'

#declare flare_size = 0.500;
#declare bright_background = 0;
#declare flare_brightness = 1.000;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "NKFlare\Sports.flr"
#include "NKFlare\nkflare.inc"


